<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'Türkçe (TR)',
    'moduleList' => [
        'Home' => 'Ana Sayfa',
        'Contacts' => 'Kontaklar',
        'Accounts' => 'Müşteriler',
        'Opportunities' => 'Fırsatlar',
        'Cases' => 'Talepler',
        'Notes' => 'Notlar',
        'Calls' => 'Aramalar',
        'Emails' => 'E-Postalar',
        'Meetings' => 'Toplantılar',
        'Tasks' => 'Görevler',
        'Calendar' => 'Takvim',
        'Leads' => 'Potansiyeller',
        'Currencies' => 'Para Birimleri',
        'Contracts' => 'Kontratlar',
        'Quotes' => 'Teklifler',
        'Products' => 'Teklif Kalemleri',
        'WebLogicHooks' => 'Web Mantık Çengelleri',
        'ProductCategories' => 'Ürün Kategorileri',
        'ProductTypes' => 'Ürün Tipleri',
        'ProductTemplates' => 'Ürün Kataloğu',
        'ProductBundles' => 'Ürün Paketleri',
        'ProductBundleNotes' => 'Ürün Paketi Notları',
        'Reports' => 'Raporlar',
        'Forecasts' => 'Tahminler',
        'ForecastWorksheets' => 'Tahmin Çalışma Sayfası',
        'ForecastManagerWorksheets' => 'Satış Tahmini Yönetici Çalışma Sayfası',
        'VisualPipeline' => 'Görsel Satış Olasılığı',
        'ConsoleConfiguration' => 'Konsol Yapılandırması',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'Kotalar',
        'Teams' => 'Takımlar',
        'TeamNotices' => 'Takım Bildirimleri',
        'Manufacturers' => 'Üreticiler',
        'Activities' => 'Aktiviteler',
        'Comments' => 'Yorumlar',
        'Subscriptions' => 'Abonelikler',
        'Bugs' => 'Hatalar',
        'Feeds' => 'Bilgi Beslemesi',
        'iFrames' => 'Sitelerim',
        'TimePeriods' => 'Zaman Aralıkları',
        'TaxRates' => 'Vergi Oranları',
        'ContractTypes' => 'Kontrat Tipleri',
        'Schedulers' => 'Planlayıcılar',
        'Project' => 'Projeler',
        'ProjectTask' => 'Proje Görevleri',
        'Campaigns' => 'Kampanyalar',
        'CampaignLog' => 'Kampanya Tarihçesi',
        'CampaignTrackers' => 'Kampanya Takip Edicileri',
        'Documents' => 'Dokümanlar',
        'DocumentRevisions' => 'Doküman Revizyonları',
        'Connectors' => 'Konnektörler',
        'Notifications' => 'Uyarılar',
        'Sync' => 'Senkronizasyon',
        'HintAccountsets' => 'Hinthesapsetleri',
        'HintNotificationTargets' => 'HintBildirimHedefleri',
        'HintNewsNotifications' => 'HintHaberBildirimleri',
        'HintEnrichFieldConfigs' => 'HintAlanYapılandırmalarınıZenginleştirin',
        'ExternalUsers' => 'Harici Kullanıcılar',
        'ReportMaker' => 'Şirket Raporları',
        'DataSets' => 'Veri Formatları',
        'CustomQueries' => 'Özel Sorgula',
        'pmse_Inbox' => 'Süreç',
        'pmse_Project' => 'Süreç Tanımı',
        'pmse_Business_Rules' => 'İş Kuralını İşlet',
        'pmse_Emails_Templates' => 'E-Posta Şablonlarını İşle',
        'BusinessCenters' => 'İş Merkezleri',
        'Shifts' => 'Vardiyalar',
        'ShiftExceptions' => 'Vardiya İstisnaları',
        'Purchases' => 'Satın Alımlar',
        'PurchasedLineItems' => 'Satın Alınan Kalemler',
        'MobileDevices' => 'Mobil Cihazlar',
        'PushNotifications' => 'Anlık Bildirimler',
        'Escalations' => 'Artışlar',
        'DocumentTemplates' => 'Doküman Şablonları',
        'DocumentMerges' => 'Doküman Birleştirmeleri',
        'CloudDrivePaths' => 'Bulut Sürücüsü Yolları',
        'WorkFlow' => 'İş Akış Tanımları',
        'EAPM' => 'Harici Hesaplar',
        'Worksheet' => 'Çalışma Sayfası',
        'Users' => 'Kullanıcılar',
        'Employees' => 'Çalışanlar',
        'Administration' => 'Yönetim',
        'ACLRoles' => 'Roller',
        'InboundEmail' => 'Grup Posta Hesapları',
        'Releases' => 'Sürümler',
        'Prospects' => 'Hedefler',
        'Queues' => 'Kuyruklar',
        'EmailMarketing' => 'E-Posta İle Pazarlama',
        'EmailTemplates' => 'E-Posta Şablonları',
        'SNIP' => 'E-Posta Arşivleme',
        'ProspectLists' => 'Hedef Listeler',
        'SavedSearch' => 'Kaydedilmiş Aramalar',
        'UpgradeWizard' => 'Yükseltme Sihirbazı',
        'Trackers' => 'Takipçiler',
        'TrackerPerfs' => 'Takipçi Performansı',
        'TrackerSessions' => 'Takipçi Oturumu',
        'TrackerQueries' => 'Takipçi Sorguları',
        'FAQ' => 'SSS',
        'Newsletters' => 'Bültenler',
        'SugarFavorites' => 'Favoriler',
        'PdfManager' => 'Pdf Yöneticisi',
        'DataArchiver' => 'Veri Arşivleyici',
        'ArchiveRuns' => 'Arşiv Çalışır',

        'OAuthKeys' => 'OAuth Müşteri Anahtarları',
        'OAuthTokens' => 'OAuth Anahtarları',
        'Filters' => 'Filtreler',
        'UserSignatures' => 'E-posta imzaları',
        'Shippers' => 'Nakliyat Sağlayıcıları',
        'Styleguide' => 'Stilrehberi',
        'Feedbacks' => 'Geri Bildirim',
        'Tags' => 'Etiketler',
        'Categories' => 'Kategoriler',
        'Dashboards' => 'Gösterge Panoları',
        'OutboundEmail' => 'E-Posta Ayarları',
        'EmailParticipants' => 'E-posta Katılımcıları',
        'DataPrivacy' => 'Veri Gizliliği',
        'ReportSchedules' => 'Planları Raporla',
        'CommentLog' => 'Yorum günlüğü',
        'Holidays' => 'Tatiller',
        'ChangeTimers' => 'Zamanlayıcıları Değiştirin',
        'Metrics' => 'Ölçüler',
        'Messages' => 'Mesajlar',
        'Audit' => 'Denetle',
        'RevenueLineItems' => 'Gelir Satır Öğeleri',
        'DocuSignEnvelopes' => 'DocuSign Zarfları',
        'Geocode' => 'Coğrafi Kodlama',
        'DRI_Workflows' => 'Akıllı Kılavuzlar',
        'DRI_Workflow_Task_Templates' => 'Akıllı Kılavuz Etkinlik Şablonları',
        'DRI_SubWorkflows' => 'Akıllı Kılavuz Aşamaları',
        'DRI_Workflow_Templates' => 'Akıllı Kılavuz Şablonları',
        'CJ_WebHooks' => 'Sugar Automate Web Çengelleri',
        'CJ_Forms' => 'Smart Guide Sugar İşlemleri',
        'DRI_SubWorkflow_Templates' => 'Akıllı Kılavuz Aşama Şablonları',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub Modülü Olay Anlık Abonelikleri',
    ],

    'moduleIconList' => [
        'Home' => 'An',
        'Contacts' => 'İl',
        'Accounts' => 'He',
        'Opportunities' => 'Fı',
        'Cases' => 'Talep',
        'Notes' => 'Not',
        'Calls' => 'Arama',
        'Emails' => 'Ep',
        'Meetings' => 'To',
        'Tasks' => 'Görev',
        'Calendar' => 'Ta',
        'Leads' => 'Po',
        'Currencies' => 'Pa',
        'Contracts' => 'İl',
        'Quotes' => 'Te',
        'Products' => 'Ür',
        'WebLogicHooks' => 'WM',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'ÜT',
        'ProductTemplates' => 'ÜŞ',
        'ProductBundles' => 'ÜS',
        'ProductBundleNotes' => 'ÜS',
        'Reports' => 'Ra',
        'Forecasts' => 'Ta',
        'ForecastWorksheets' => 'TÇ',
        'ForecastManagerWorksheets' => 'TY',
        'Quotas' => 'Kota',
        'VisualPipeline' => 'GS',
        'ConsoleConfiguration' => 'KY',
        'SugarLive' => 'Su',
        'Teams' => 'Ta',
        'TeamNotices' => 'TB',
        'Manufacturers' => 'Ür',
        'Activities' => 'Ak',
        'Comments' => 'Yo',
        'Subscriptions' => 'Ab',
        'Bugs' => 'Ha',
        'Feeds' => 'BE',
        'iFrames' => 'IF',
        'TimePeriods' => 'ZA',
        'TaxRates' => 'VO',
        'ContractTypes' => 'KT',
        'Schedulers' => 'Pl',
        'Project' => 'Pr',
        'ProjectTask' => 'PG',
        'Campaigns' => 'Kampanya',
        'CampaignLog' => 'KL',
        'CampaignTrackers' => 'Kİ',
        'Documents' => 'Do',
        'DocumentRevisions' => 'DR',
        'Connectors' => 'Ko',
        'Notifications' => 'Bi',
        'Sync' => 'Se',
        'HintAccountsets' => 'Hi',
        'HintNotificationTargets' => 'Hi',
        'HintNewsNotifications' => 'Hi',
        'HintEnrichFieldConfigs' => 'Hi',
        'ExternalUsers' => 'HK',
        'ReportMaker' => 'RY',
        'DataSets' => 'VK',
        'CustomQueries' => 'ÖS',
        'pmse_Inbox' => 'Pr',
        'pmse_Project' => 'PD',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE',
        'BusinessCenters' => 'İM',
        'Shifts' => 'Va',
        'ShiftExceptions' => 'Vİ',
        'Purchases' => 'Sa',
        'PurchasedLineItems' => 'SAK',
        'MobileDevices' => 'Mo',
        'PushNotifications' => 'An',
        'Escalations' => 'Ar',
        'DocumentTemplates' => 'DŞ',
        'DocumentMerges' => 'DB',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'İA',
        'EAPM' => 'EA',
        'Worksheet' => 'Ça',
        'Users' => 'Ku',
        'Employees' => 'Ça',
        'Administration' => 'Yö',
        'ACLRoles' => 'Ro',
        'InboundEmail' => 'GE',
        'Releases' => 'Sü',
        'Prospects' => 'Ta',
        'Queues' => 'Ku',
        'EmailMarketing' => 'PE',
        'EmailTemplates' => 'EŞ',
        'SNIP' => 'EA',
        'ProspectLists' => 'TL',
        'SavedSearch' => 'KA',
        'UpgradeWizard' => 'YS',
        'Trackers' => 'Ta',
        'TrackerPerfs' => 'TP',
        'TrackerSessions' => 'TO',
        'TrackerQueries' => 'TS',
        'FAQ' => 'SS',
        'Newsletters' => 'Bü',
        'SugarFavorites' => 'Fa',
        'PdfManager' => 'PY',
        'DataArchiver' => 'VA',
        'ArchiveRuns' => 'AÇ',
        'OAuthKeys' => 'OC',
        'OAuthTokens' => 'OT',
        'Filters' => 'Fi',
        'UserSignatures' => 'Kİ',
        'Shippers' => 'NA',
        'Styleguide' => 'St',
        'Feedbacks' => 'Ge',
        'Tags' => 'Et',
        'Categories' => 'Ka',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'ES',
        'EmailParticipants' => 'EK',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'PR',
        'CommentLog' => 'YG',
        'Holidays' => 'Ta',
        'ChangeTimers' => 'ZD',
        'Metrics' => 'Öl',
        'Messages' => 'Me',
        'Audit' => 'De',
        'RevenueLineItems' => 'GK',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'CK',
        'DRI_Workflows' => 'SG',
        'DRI_Workflow_Task_Templates' => 'SG',
        'DRI_SubWorkflows' => 'SG',
        'DRI_Workflow_Templates' => 'SG',
        'CJ_WebHooks' => 'SA',
        'CJ_Forms' => 'SG',
        'DRI_SubWorkflow_Templates' => 'SG',
        'Library' => 'Ki',
        'EmailAddresses' => 'EA',
        'Words' => 'Ke',
        'Sugar_Favorites' => 'Sı',
        'KBDocuments' => 'KB',
        'KBContents' => 'KB',
        'KBArticles' => 'KB',
        'KBContentTemplates' => 'KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'KD',
    ],

    'moduleListSingular' => [
        'Home' => 'Ana Sayfa',
        'Dashboards' => 'Gösterge Panosu',
        'Styleguide' => 'Stilrehberi',
        'Contacts' => 'Kontak',
        'Accounts' => 'Müşteri',
        'Opportunities' => 'Fırsat',
        'Cases' => 'Talep',
        'Notes' => 'Not',
        'Calls' => 'Tel.Araması',
        'Emails' => 'E-Posta',
        'Meetings' => 'Toplantı',
        'Tasks' => 'Görev',
        'Calendar' => 'Takvim',
        'Leads' => 'Potansiyel',
        'Manufacturers' => 'Üretici',
        'VisualPipeline' => 'GörselSatışOlasılığı',
        'ConsoleConfiguration' => 'KonsolYapılandırması',
        'MobileDevices' => 'Mobil Cihaz',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'Kontrat',
        'Quotes' => 'Teklif',
        'Products' => 'Teklif Kalemi',
        'ProductCategories' => 'Ürün Kategorisi',
        'ProductBundles' => 'Ürün Paketi',
        'ProductBundleNotes' => 'Ürün Paketi Notu',
        'RevenueLineItems' => 'Gelir Kalemi',
        'WebLogicHooks' => 'Web Mantık Çengelleri',
        'Reports' => 'Rapor',
        'Forecasts' => 'Tahmin',
        'ForecastWorksheets' => 'Tahmin Çalışma Sayfası',
        'ForecastManagerWorksheets' => 'Satış Tahmini Yönetici Çalışma Sayfası',
        'Quotas' => 'Kota',
        'Teams' => 'Takım',
        'TeamNotices' => 'Takım Bildirimi',
        'Activities' => 'Aktivite',
        'ActivityStream' => 'Aktiviteler',
        'Bugs' => 'Hata',
        'Feeds' => 'Bilgi Beslemesi',
        'iFrames' => 'Sitelerim',
        'TimePeriods' => 'Zaman Aralığı',
        'TaxRates' => 'Vergi Oranı',
        'ContractTypes' => 'Kontrat Tipi',
        'Schedulers' => 'Planlayıcı',
        'Campaigns' => 'Kampanya',
        'CampaignLog' => 'Kampanya Tarihçesi',
        'Project' => 'Proje',
        'ProjectTask' => 'Proje Görevi',
        'Prospects' => 'Hedef',
        'ProspectLists' => 'Hedef Liste',
        'CampaignTrackers' => 'Kampanya İzleyici',
        'Documents' => 'Doküman',
        'DocumentRevisions' => 'Doküman Revizyonu',
        'Connectors' => 'Konnektör',
        'Notifications' => 'Bilgilendirme',
        'Sync' => 'Senkronizasyon',
        'PdfManager' => 'Pdf Yöneticisi',
        'DataArchiver' => 'Veri Arşivleyici',
        'ArchiveRuns' => 'Arşiv Çalışır',
        'ExternalUsers' => 'Harici Kullanıcı',
        'ReportMaker' => 'Sweet Raporlama',
        'DataSets' => 'Veri Biçimi',
        'CustomQueries' => 'Özel Sorgu',
        'pmse_Inbox' => 'Süreç',
        'pmse_Project' => 'Süreç Tanımı',
        'pmse_Business_Rules' => 'İş Kuralını İşlet',
        'pmse_Emails_Templates' => 'İşlem E-postası Şablonu',
        'BusinessCenters' => 'İş Merkezi',
        'Shifts' => 'Vardiya',
        'ShiftExceptions' => 'Vardiya İstisnaları',
        'Purchases' => 'Satın Alma',
        'PurchasedLineItems' => 'Satın Alınan Kalem',
        'PushNotifications' => 'Anlık Bildirim',
        'Escalations' => 'Artış',
        'DocumentTemplates' => 'Doküman Şablonu',
        'DocumentMerges' => 'Doküman Birleştirme',
        'CloudDrivePaths' => 'Bulut Sürücüsü Yolu',
        'WorkFlow' => 'İş Akışı',
        'EAPM' => 'Harici Hesap',
        'Worksheet' => 'Çalışma Sayfası',
        'Users' => 'Kullanıcı',
        'SugarFavorites' => 'SugarFavoriler',
        'Employees' => 'Çalışan',
        'Administration' => 'Yönetim',
        'ACLRoles' => 'Rol',
        'InboundEmail' => 'Grup Posta Hesapları',
        'Releases' => 'Sürüm',
        'Queues' => 'Kuyruk',
        'EmailMarketing' => 'E-Posta İle Pazarlama',
        'EmailTemplates' => 'E-Posta Şablonu',
        'SNIP' => 'E-Posta Arşivleme',
        'SavedSearch' => 'Kaydedilmiş Aramalar',
        'UpgradeWizard' => 'Yükseltme Sihirbazı',
        'Trackers' => 'Takip Edici',
        'TrackerPerfs' => 'Takipçi Performansı',
        'TrackerSessions' => 'Takipçi Oturumu',
        'TrackerQueries' => 'Takipçi Sorgular',
        'FAQ' => 'SSS',
        'Newsletters' => 'Bülten',
        'OAuthKeys' => 'OAuth Müşteri Anahtarı',
        'OAuthTokens' => 'OAuth Anahtarı',
        'Filters' => 'Filtre',
        'Comments' => 'Açıklama',
        'CommentLog' => 'Yorum günlüğü',
        'Currencies' => 'Para Birimi',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'Ürün Tipi',
        'Shippers' => 'Nakliyatçı',
        'Subscriptions' => 'Abonelik',
        'UserSignatures' => 'E-posta İmzası',
        'Feedbacks' => 'Geri Bildirim',
        'Tags' => 'Etiket',
        'Categories' => 'Kategori',
        'OutboundEmail' => 'E-posta Ayarı',
        'EmailParticipants' => 'E-posta Katılımcısı',
        'DataPrivacy' => 'Veri Gizliliği',
        'ReportSchedules' => 'Planı Raporla',
        'Holidays' => 'Tatil',
        'ChangeTimers' => 'Zamanlayıcıyı Değiştirin',
        'Metrics' => 'Ölçü',
        'Messages' => 'Mesajlar',
        'Audit' => 'Denetle',
        'DocuSignEnvelopes' => 'DocuSignZarfı',
        'HintAccountsets' => 'HintHesapsetleri',
        'HintNotificationTargets' => 'HintBildirimHedefleri',
        'HintNewsNotifications' => 'HintHaberBildirimleri',
        'HintEnrichFieldConfigs' => 'HintAlanYapılandırmalarınıZenginleştirin',
        'Geocode' => 'Coğrafi Kodlama',
        'DRI_Workflows' => 'Akıllı Kılavuz',
        'DRI_Workflow_Task_Templates' => 'Akıllı Kılavuz Etkinlik Şablonu',
        'DRI_SubWorkflows' => 'Akıllı Kılavuz Aşaması',
        'DRI_Workflow_Templates' => 'Akıllı Kılavuz Şablonu',
        'CJ_WebHooks' => 'Sugar Automate Web Çengeli',
        'CJ_Forms' => 'Smart Guide Sugar İşlemi',
        'DRI_SubWorkflow_Templates' => 'Akıllı Kılavuz Aşama Şablonu',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub Modülü Olay Anlık Abonelikleri',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'Evet',
        '2' => 'Hayır',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'Hayır',
        1 => 'Evet',
    ],

    'notifications_status_dom' => [
        0 => 'Okunmadı',
        1 => 'Okundu',
    ],

    'optout_dom' => [
        '' => '-yok-',
        'false' => 'Hayır',
        'true' => 'Evet',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'Analist',
        'Competitor' => 'Rakip',
        'Customer' => 'Müşteri',
        'Integrator' => 'Entegratör',
        'Investor' => 'Yatırımcı',
        'Partner' => 'Ortak',
        'Press' => 'Basın',
        'Prospect' => 'Potansiyel Müşteri',
        'Reseller' => 'Satıcı',
        'Other' => 'Diğer',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'Tekstil',
        'Banking' => 'Bankacılık',
        'Biotechnology' => 'Biyoteknoloji',
        'Chemicals' => 'Kimyasal',
        'Communications' => 'İletişim',
        'Construction' => 'İnşaat',
        'Consulting' => 'Danışmanlık',
        'Education' => 'Eğitim',
        'Electronics' => 'Elektronik',
        'Energy' => 'Enerji',
        'Engineering' => 'Mühendislik',
        'Entertainment' => 'Eğlence',
        'Environmental' => 'Çevresel',
        'Finance' => 'Finans',
        'Government' => 'Hükümet',
        'Healthcare' => 'Sağlık',
        'Hospitality' => 'Konukseverlik',
        'Insurance' => 'Sigorta',
        'Machinery' => 'Makine',
        'Manufacturing' => 'Üretim',
        'Media' => 'Medya',
        'Not For Profit' => 'Sivil Toplum Kuruluşu',
        'Recreation' => 'Rekreasyon',
        'Retail' => 'Perakende',
        'Shipping' => 'Nakliyat',
        'Technology' => 'Teknoloji',
        'Telecommunications' => 'Telekomünikasyon',
        'Transportation' => 'Ulaşım',
        'Utilities' => 'Alt Yapı',
        'Other' => 'Diğer',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF ve CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'Grafik',
        'Data Table' => 'Veri Tablosu',
        'Chart and Data Table' => 'Grafik ve Veri Tablosu',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'İşlemde',
        'Completed' => 'Tamamlandı',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'Gelen',
        'Outbound' => 'Giden',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'Sohbet',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'Aşama 1',
        'T2' => 'Aşama 2',
        'T3' => 'Aşama 3',
        'T4' => 'Aşama 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'Evet',
        'No' => 'Hayır',
        'Completed' => 'Tamamlandı',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'Gelecek',
        'Active' => 'Aktif',
        'Past' => 'Yapıştır',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'Kendini Oluşturulan',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'Beklenmeyen Arama',
        'Existing Customer' => 'Mevcut Müşteri',
        'Self Generated' => 'Kendini Oluşturulan',
        'Employee' => 'Çalışan',
        'Partner' => 'Ortak',
        'Public Relations' => 'Halkla İlişkiler',
        'Direct Mail' => 'Posta',
        'Conference' => 'Konferans',
        'Trade Show' => 'Ticari Etkinlik',
        'Web Site' => 'Web Sitesi',
        'Word of mouth' => 'Tavsiyeyle',
        'Email' => 'E-Posta',
        'Campaign' => 'Kampanya',
        'Support Portal User Registration' => 'Destek Portali Kullanıcı Tanımlaması',
        'Other' => 'Diğer',
    ],
    'metric_status_dom' => [
        'Inactive' => 'İnaktif',
        'Active' => 'Aktif',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'Mevcut Firma',
        'New Business' => 'Yeni Firma',
    ],
    'taxrate_status_dom' => [
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
    ],
    'roi_type_dom' => [
        'Revenue' => 'Ciro',
        'Investment' => 'Yatırım',
        'Expected_Revenue' => 'Beklenen Gelir',
        'Budget' => 'Bütçe',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'Birincil Karar Verici',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Birincil Karar Verici',
        'Business Decision Maker' => 'Ticari Karar Verici',
        'Business Evaluator' => 'Ticari Değerlendirici',
        'Technical Decision Maker' => 'Teknik Karar Verici',
        'Technical Evaluator' => 'Teknik Değerlendirici',
        'Executive Sponsor' => 'Yönetici Sponsor',
        'Influencer' => 'Kararı Etkileyici',
        'Other' => 'Diğer',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
    ],

    'shipper_status_dom' => [
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'Birincil Kontak',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'Birincil Kontak',
        'Alternate Contact' => 'Alternatif Kontak',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'Alan Değerinin Yanında',
        'field_on_top' => 'Alan Değerinin Üstünde',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'Yüzde 15',
        'Net 30' => 'Yüzde 30',
    ],
    'sales_stage_default_key' => 'İnceleme',
    'fts_type' => [
        'Elastic' => 'elasticsearch',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'İnceleme',
        'Qualification' => 'Kalifikasyon',
        'Needs Analysis' => 'İhtiyaç Analizi',
        'Value Proposition' => 'Değer Önerisi',
        'Id. Decision Makers' => 'Karar Verenlerin Belirlenmesi',
        'Perception Analysis' => 'Persepsiyon Analizi',
        'Proposal/Price Quote' => 'Teklif/Fiyat Verme',
        'Negotiation/Review' => 'Anlaşma/İnceleme',
        'Closed Won' => 'Kapalı',
        'Closed Lost' => 'Başarısızlıkla Kapandı',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'Yeni',
        'In Progress' => 'İşlemde',
        'Closed Won' => 'Kapalı',
        'Closed Lost' => 'Başarısızlıkla Kapandı',
        'Converted to Quote' => 'Teklife Dönüştürülmüş',
    ],
    'sales_status_dom' => [
        'New' => 'Yeni',
        'In Progress' => 'İşlemde',
        'Closed Won' => 'Kapalı',
        'Closed Lost' => 'Başarısızlıkla Kapandı',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'Dahil et',
        'exclude' => 'Hariç',
    ],
    'commit_stage_dom' => [
        'include' => 'Dahil et',
        'upside' => 'Üst taraf',
        'exclude' => 'Hariç',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'Dahil et',
        'upside' => 'Üst taraf',
        'exclude' => 'Hariç',
    ],

    'in_total_group_stages' => [
        'Draft' => 'Taslak',
        'Negotiation' => 'Pazarlık',
        'Delivered' => 'Teslim Edildi',
        'On Hold' => 'Durdurulmuş',
        'Confirmed' => 'Onaylandı',
        'Closed Accepted' => 'Kabul Edilerek Kapandı',
        'Closed Lost' => 'Başarısızlıkla Kapandı',
        'Closed Dead' => 'Çıkmaza Girdi',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'Tel.Araması',
        'Meeting' => 'Toplantı',
        'Task' => 'Görev',
        'Email' => 'E-Posta',
        'Note' => 'Not',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'Bay',
        'Ms.' => 'Bayan',
        'Mrs.' => 'Bayan',
        'Dr.' => 'Dr.',
        'Prof.' => 'Prof.',
        'Mx.' => '.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'Yok',
        60 => '1 dakika önce',
        300 => '5 dakika önce',
        600 => '10 dakika önce',
        900 => '15 dakika önce',
        1800 => '30 dakika önce',
        3600 => '1 saat önce',
        7200 => '2 saat önce',
        10800 => '3 saat önce',
        18000 => '5 saat önce',
        86400 => '1 gün önce',
        ],

        'task_priority_default' => 'Orta',
        'task_priority_dom' => [
        'High' => 'Yüksek',
        'Medium' => 'Orta',
        'Low' => 'Düşük',
        ],
        'task_status_default' => 'Başlamadı',
        'task_status_dom' => [
        'Not Started' => 'Başlamadı',
        'In Progress' => 'İşlemde',
        'Completed' => 'Tamamlandı',
        'Pending Input' => 'Cevap Bekleniyor',
        'Deferred' => 'Ertelendi',
        'Not Applicable' => 'Uygulanamaz',
        ],
        'meeting_status_default' => 'Planlanmış',
        'meeting_status_dom' => [
        'Planned' => 'Planlanmış',
        'Held' => 'Yapıldı',
        'Not Held' => 'İptal Edildi',
        'Deferred' => 'Ertelendi',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'Diğer',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'Planlanmış',
        'call_status_dom' => [
        'Planned' => 'Planlanmış',
        'In Progress' => 'İşlemde',
        'Held' => 'Yapıldı',
        'Not Held' => 'İptal Edildi',
        'Deferred' => 'Ertelendi',
        ],
        'call_direction_default' => 'Giden',
        'call_direction_dom' => [
        'Inbound' => 'Gelen',
        'Outbound' => 'Giden',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'Yeni',
        'Assigned' => 'Atanmış',
        'In Process' => 'İşleniyor',
        'Converted' => 'Dönüştü',
        'Recycled' => 'Geri Kazanıldı',
        'Dead' => 'Ölü',
        ],
        'gender_list' => [
        'male' => 'Bay',
        'female' => 'Bayan',
        'other' => 'Diğer',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'Yeni',
        'case_status_dom' => [
        'New' => 'Yeni',
        'Assigned' => 'Atanmış',
        'Closed' => 'Kapalı',
        'Pending Input' => 'Cevap Bekleniyor',
        'Rejected' => 'Reddedildi',
        'Duplicate' => 'Aynı Kayıttan Oluştur',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'Yüksek',
        'P2' => 'Orta',
        'P3' => 'Düşük',
        ],
        'user_type_dom' => [
        'RegularUser' => 'Normal Kullanıcı',
        'Administrator' => 'Yönetici',
        ],
        'user_type_bool_dom' => [
            false => 'Normal Kullanıcı',
            true => 'Yönetici',
        ],
        'user_type_group_bool_dom' => [
            true => 'Grup Kullanıcısı',
        ],
        'user_type_portal_bool_dom' => [
            true => 'Portal API Kullanıcısı',
        ],
        'license_type_dom' => [
        'CURRENT' => 'Mevcut Ürün',
        'SUGAR_SERVE' => 'Sugar Hizmeti',
        'SUGAR_SELL' => 'Sugar Satışı',
        ],
        'user_status_dom' => [
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
        ],
        'employee_status_dom' => [
        'Active' => 'Aktif',
        'Terminated' => 'Sonlandırıldı',
        'Leave of Absence' => 'İzin',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
        ],
        'project_task_priority_options' => [
        'High' => 'Yüksek',
        'Medium' => 'Orta',
        'Low' => 'Düşük',
        ],
        'project_task_priority_default' => 'Orta',

        'project_task_status_options' => [
        'Not Started' => 'Başlamadı',
        'In Progress' => 'İşlemde',
        'Completed' => 'Tamamlandı',
        'Pending Input' => 'Cevap Bekleniyor',
        'Deferred' => 'Ertelendi',
        ],
        'project_task_utilization_options' => [
        '0' => 'boş',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'Taslak',
        'In Review' => 'İncelemede',
        'Published' => 'Yayınlandı',
        ],
        'project_status_default' => 'Taslak',

        'project_duration_units_dom' => [
        'Days' => 'Gün',
        'Hours' => 'Saat',
        ],

        'project_priority_options' => [
        'High' => 'Yüksek',
        'Medium' => 'Orta',
        'Low' => 'Düşük',
        ],
        'project_priority_default' => 'Orta',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Müşteriler',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'Müşteri',
        'Opportunities' => 'Fırsat',
        'Cases' => 'Talep',
        'Leads' => 'Potansiyel',
        'Contacts' => 'Kontaklar', // cn (11/22/2005) added to support Emails
        'Products' => 'Teklif Kalemi',
        'Quotes' => 'Teklif',
        'Bugs' => 'Hata',
        'Project' => 'Proje',

        'Prospects' => 'Hedef',
        'ProjectTask' => 'Proje Görevi',

        'Tasks' => 'Görev',
        'KBContents' => 'Bilgi Tabanı',
        'Notes' => 'Not',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'Müşteri',
        'Contacts' => 'Kontak',
        'Opportunities' => 'Fırsat',
        'Tasks' => 'Görev',
        'ProductTemplates' => 'Ürün Kataloğu',
        'Quotes' => 'Teklif',
        'Products' => 'Teklif Kalemi',
        'Contracts' => 'Kontrat',
        'Emails' => 'E-Posta',

        'Bugs' => 'Hata',
        'Project' => 'Proje',
        'ProjectTask' => 'Proje Görevi',
        'Prospects' => 'Hedef',
        'Cases' => 'Talep',
        'Leads' => 'Potansiyel',

        'Meetings' => 'Toplantı',
        'Calls' => 'Tel.Araması',
        'KBContents' => 'Bilgi Tabanı',
        'PurchasedLineItems' => 'Satın Alınan Kalem',
        'Purchases' => 'Satın Alma',
        'Escalations' => 'Artış',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'Hesap',
        'Contacts' => 'Kontak',
        'Employees' => 'Çalışan',
        'Leads' => 'Potansiyel',
        'Prospects' => 'Hedef',
        'Users' => 'Kullanıcı',
        ],

        'parent_type_display' => [
        'Accounts' => 'Müşteri',
        'Contacts' => 'Kontak',
        'Tasks' => 'Görev',
        'Opportunities' => 'Fırsat',
        'Products' => 'Teklif Kalemi',
        'Quotes' => 'Teklif',

        'Bugs' => 'Hatalar',
        'Cases' => 'Talep',
        'Leads' => 'Potansiyel',

        'Project' => 'Proje',
        'ProjectTask' => 'Proje Görevi',

        'Prospects' => 'Hedef',
        'KBContents' => 'Bilgi Tabanı',
        'Notes' => 'Not',
        'PurchasedLineItems' => 'Satın Alınan Kalem',
        'Purchases' => 'Satın Alma',
        'Escalations' => 'Artış',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'Talep',
        ],

        'product_status_default_key' => 'Gönderildi',
        'product_status_quote_key' => 'Teklifler',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'Teklif Edilmiş',
        'Orders' => 'Sipariş Edilmiş',
        'Ship' => 'Gönderilmiş',
        ],
        'active_status_dom' => [
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
        'Retired' => 'Emekli',
        ],
        'appearance_options' => [
        'system_default' => 'Sistem ayarını kullanın',
        'light' => 'Açık',
        'dark' => 'Koyu',
        ],


        'pricing_formula_default_key' => 'Sabit',
        'pricing_formula_dom' => [
        'Fixed' => 'Sabit Fiyat',
        'ProfitMargin' => 'Kar Payı',
        'PercentageMarkup' => 'Maliyet üzerinden Fiyat Artışı',
        'PercentageDiscount' => 'Listeden indirim',
        'IsList' => 'Liste ile aynı',
        ],
        'product_template_status_dom' => [
        'Available' => 'Stokta',
        'Unavailable' => 'Stokta Yok',
        ],
        'tax_class_dom' => [
        'Taxable' => 'Vergilendirilebilir',
        'Non-Taxable' => 'Vergilendirilemez',
        ],
        'support_term_dom' => [
        '+6 months' => 'Altı Ay',
        '+1 year' => 'Bir Yıl',
        '+2 years' => 'İki yıl',
        ],

        'quote_type_dom' => [
        'Quotes' => 'Teklif',
        'Orders' => 'Sıra',
        ],
        'default_quote_stage_key' => 'Taslak',
        'quote_stage_dom' => [
        'Draft' => 'Taslak',
        'Negotiation' => 'Pazarlık',
        'Delivered' => 'Teslim Edildi',
        'On Hold' => 'Durdurulmuş',
        'Confirmed' => 'Onaylandı',
        'Closed Accepted' => 'Kabul Edilerek Kapandı',
        'Closed Lost' => 'Başarısızlıkla Kapandı',
        'Closed Dead' => 'Çıkmaza Girdi',
        ],
        'default_order_stage_key' => 'Beklemede',
        'order_stage_dom' => [
        'Pending' => 'Beklemede',
        'Confirmed' => 'Onaylandı',
        'On Hold' => 'Durdurulmuş',
        'Shipped' => 'Gönderilmiş',
        'Cancelled' => 'İptal Edilmiş',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'Birincil Karar Verici',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Birincil Karar Verici',
        'Business Decision Maker' => 'Ticari Karar Verici',
        'Business Evaluator' => 'Ticari Değerlendirici',
        'Technical Decision Maker' => 'Teknik Karar Verici',
        'Technical Evaluator' => 'Teknik Değerlendirici',
        'Executive Sponsor' => 'Yönetici Sponsor',
        'Influencer' => 'Kararı Etkileyici',
        'Other' => 'Diğer',
        ],
        'layouts_dom' => [
        'Standard' => 'Teklif',
        'Invoice' => 'Fatura',
        ],
        'issue_priority_default_key' => 'Orta',
        'issue_priority_dom' => [
        'Urgent' => 'Acil',
        'High' => 'Yüksek',
        'Medium' => 'Orta',
        'Low' => 'Düşük',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'Kabul edildi',
        'Duplicate' => 'Aynı Kayıttan Oluştur',
        'Closed' => 'Kapalı',
        'Out of Date' => 'Geçerliliğini Yitirmiş',
        'Invalid' => 'Geçersiz',
        ],

        'issue_status_default_key' => 'Yeni',
        'issue_status_dom' => [
        'New' => 'Yeni',
        'Assigned' => 'Atanmış',
        'Closed' => 'Kapalı',
        'Pending' => 'Beklemede',
        'Rejected' => 'Reddedildi',
        ],

        'bug_priority_default_key' => 'Orta',
        'bug_priority_dom' => [
        'Urgent' => 'Acil',
        'High' => 'Yüksek',
        'Medium' => 'Orta',
        'Low' => 'Düşük',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'Kabul edildi',
        'Duplicate' => 'Aynı Kayıttan Oluştur',
        'Fixed' => 'Sabit',
        'Out of Date' => 'Geçerliliğini Yitirmiş',
        'Invalid' => 'Geçersiz',
        'Later' => 'Sonra',
        ],
        'bug_status_default_key' => 'Yeni',
        'bug_status_dom' => [
        'New' => 'Yeni',
        'Assigned' => 'Atanmış',
        'Closed' => 'Kapalı',
        'Pending' => 'Beklemede',
        'Rejected' => 'Reddedildi',
        ],
        'bug_type_default_key' => 'Hata',
        'bug_type_dom' => [
        'Defect' => 'Kusur',
        'Feature' => 'Özellik',
        ],
        'case_type_dom' => [
        'Administration' => 'Yönetim',
        'Product' => 'Ürün',
        'User' => 'Kullanıcı',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'Dahili',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'E-Posta',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'Dahili',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'E-Posta',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        'Phone' => 'Telefon',
        'Chat' => 'Sohbet',
        'Chatbot' => 'Sohbet Robotu',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'Gizlilik Politikası İsteği',
        'Send Personal Information being processed' => 'İşlenecek Kişisel Bilgileri Gönderin',
        'Rectify Information' => 'Bilgileri Düzeltin',
        'Request to Erase Information' => 'Bilgi Silme İsteği',
        'Export Information' => 'Bilgileri Dışa Aktar',
        'Restrict Processing' => 'İşlemeyi Kısıtla',
        'Object to Processing' => 'İşleme İçin Nesneyi Biçimle',
        'Consent to Process' => 'İşleme İçin İzin Ver',
        'Withdraw Consent' => 'İzni Geri Çek',
        'Other' => 'Diğer',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'İşletme İletişimi',
        'Marketing Communications by company' => 'Şirketle Pazarlama İletişimi',
        'Marketing Communications by partners' => 'Ortaklarla Pazarlama İletişimi',
        ],
        'dataprivacy_status_default_key' => 'Aç',
        'dataprivacy_status_dom' => [
        'Open' => 'Aç',
        'Closed' => 'Tamamlandı',
        'Rejected' => 'Reddedildi',
        ],
        'dataprivacy_priority_default_key' => 'Düşük',
        'dataprivacy_priority_dom' => [
        'Low' => 'Düşük',
        'Medium' => 'Orta',
        'High' => 'Yüksek',
        ],
        'business_day_status_dom' => [
        'Open' => 'Açık',
        'Open 24 Hours' => '24 Saat Açık',
        'Closed' => 'Kapalı',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'Müşteriler',
        'Activities' => 'Aktiviteler',
        'Bug Tracker' => 'Hata İzleme',
        'Calendar' => 'Takvim',
        'Calls' => 'Aramalar',
        'Campaigns' => 'Kampanyalar',
        'Cases' => 'Talepler',
        'Contacts' => 'Kontaklar',
        'Currencies' => 'Para Birimleri',
        'Dashboard' => 'Gösterge Panosu',
        'Documents' => 'Dokümanlar',
        'Emails' => 'E-Postalar',
        'Feeds' => 'Beslemeler',
        'Forecasts' => 'Tahminler',
        'Help' => 'Yardım',
        'Home' => 'Ana Sayfa',
        'Leads' => 'Potansiyeller',
        'Meetings' => 'Toplantılar',
        'Notes' => 'Notlar',
        'Opportunities' => 'Fırsatlar',
        'Outlook Plugin' => 'Outlook Eki',
        'Product Catalog' => 'Ürün Kataloğu',
        'Products' => 'Teklif Kalemleri',
        'RevenueLineItems' => 'Gelir Kalemleri',
        'Projects' => 'Projeler',
        'Quotes' => 'Teklifler',
        'Releases' => 'Sürümler',
        'RSS' => 'Bilgi Beslemesi',
        'Studio' => 'Stüdyo',
        'Upgrade' => 'Versiyon Yükseltme',
        'Users' => 'Kullanıcılar',
        'OutboundEmail' => 'E-Posta Ayarları',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'Planlama',
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
        'Complete' => 'Tamamlandı',
        'In Queue' => 'Kuyrukta',
        'Sending' => 'Gönderiliyor',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'Tele Satış',
        'Mail' => 'Posta',
        'Email' => 'E-Posta',
        'Print' => 'Yazdır',
        'Web' => 'Web',
        'Radio' => 'Radyo',
        'Television' => 'Televizyon',
        'NewsLetter' => 'Bülten',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'AL',
        'POST' => 'YAYINLA',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'Haftalık',
        'Monthly' => 'Aylık',
        'Quarterly' => 'Çeyrek',
        'Annually' => 'Yıllık',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'Ocak',
        '2' => 'Şubat',
        '3' => 'Mart',
        '4' => 'Nisan',
        '5' => 'Mayıs',
        '6' => 'Haziran',
        '7' => 'Temmuz',
        '8' => 'Ağustos',
        '9' => 'Eylül',
        '10' => 'Ekim',
        '11' => 'Kasım',
        '12' => 'Aralık',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'Oca',
        '2' => 'Şub',
        '3' => 'Mar',
        '4' => 'Nis',
        '5' => 'Mayıs',
        '6' => 'Haz',
        '7' => 'Tem',
        '8' => 'Ağu',
        '9' => 'Eyl',
        '10' => 'Eki',
        '11' => 'Kas',
        '12' => 'Ara',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'Pazar',
        '2' => 'Pazartesi',
        '3' => 'Salı',
        '4' => 'Çarşamba',
        '5' => 'Perşembe',
        '6' => 'Cuma',
        '7' => 'Cumartesi',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'Paz',
        '2' => 'Pzt',
        '3' => 'Sal',
        '4' => 'Çar',
        '5' => 'Per',
        '6' => 'Cum',
        '7' => 'Cmt',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'Pz',
        '2' => 'Pt',
        '3' => 'Sa',
        '4' => 'Ça',
        '5' => 'Pe',
        '6' => 'Cu',
        '7' => 'Ct',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'Paz',
        '1' => 'Pzt',
        '2' => 'Sal',
        '3' => 'Çar',
        '4' => 'Per',
        '5' => 'Cum',
        '6' => 'Cmt',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'öö',
        'pm' => 'ös',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'ÖÖ',
        'PM' => 'ÖS',
        ],

        'dom_report_types' => [
        'tabular' => 'Satırlar ve Sütunlar',
        'summary' => 'Toplam',
        'detailed_summary' => 'Detaylı Toplam',
        'Matrix' => 'Matris',
        ],


        'dom_email_types' => [
        'out' => 'Gönderildi',
        'archived' => 'Arşivlendi',
        'draft' => 'Taslak',
        'inbound' => 'Gelen',
        'campaign' => 'Kampanya',
        ],
        'dom_email_status' => [
        'archived' => 'Arşivlendi',
        'closed' => 'Kapalı',
        'draft' => 'Taslakta',
        'read' => 'Okundu',
        'replied' => 'Yanıtlandı',
        'sent' => 'Gönderildi',
        'send_error' => 'Gönderim Hatası',
        'unread' => 'Okunmadı',
        ],
        'dom_email_archived_status' => [
        'archived' => 'Arşivlendi',
        ],

        'dom_email_server_type' => ['' => '--Boş--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--Boş--',
        'createcase' => 'Talep Oluştur',
        'bounce' => 'Ulaşmayan E-Posta Yönetimi',
        ],
        'dom_email_distribution' => ['' => '--Boş--',
        'direct' => 'Doğrudan Atama',
        'roundRobin' => 'Sırayla',
        'leastBusy' => 'En Az Meşgul',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'Sırayla',
        'leastBusy' => 'En Az Meşgul',
        'none' => 'Yok',
        ],
        'dom_email_errors' => [1 => 'Doğrudan atama yaparken sadece bir kullanıcı seçin.',
        2 => 'Doğrudan atama yaparken sadece işaretli öğeleri atayabilirsiniz.',
        ],
        'dom_email_bool' => ['bool_true' => 'Evet',
        'bool_false' => 'Hayır',
        ],
        'dom_int_bool' => [1 => 'Evet',
        0 => 'Hayır',
        ],
        'dom_switch_bool' => ['on' => 'Evet',
        'off' => 'Hayır',
        '' => 'Hayır',],

        'dom_email_link_type' => ['sugar' => 'SugarCRM E-Posta İstemcisi',
        'mailto' => 'Harici E-Posta İstemcisi'],


        'dom_email_editor_option' => ['' => 'Varsayılan E-Posta Formatı',
        'html' => 'HTML E-Posta',
        'plain' => 'Düz Metin E-Posta'],

        'schedulers_times_dom' => ['not run' => 'Önceki İşlem Zamanı, Çalışmadı',
        'ready' => 'Hazır',
        'in progress' => 'İşlemde',
        'failed' => 'Başarısız',
        'completed' => 'Tamamlandı',
        'no curl' => 'Çalışmıyor: cURL mevcut değil',
        ],

        'dom_email_states' => [
        'Draft' => 'Taslak',
        'Archived' => 'Arşivlendi',
        ],

        'dom_email_direction' => [
        'Unknown' => 'Bilinmeyen',
        'Outbound' => 'Giden',
        'Inbound' => 'Gelen',
        'Internal' => 'Dahili',
        ],

        'scheduler_status_dom' => [
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
        ],

        'scheduler_period_dom' => [
        'min' => 'Dakika',
        'hour' => 'Saat',
        ],
        'forecast_type_dom' => [
        'Direct' => 'Direkt',
        'Rollup' => 'Toplam',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'Pazarlama',
        'Knowledge Base' => 'Bilgi Bankası',
        'Sales' => 'Satışlar',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'Pazarlama Teminatı',
        'Product Brochures' => 'Ürün Broşürleri',
        'FAQ' => 'SSS',
        ],

        'document_status_dom' => [
        'Active' => 'Aktif',
        'Draft' => 'Taslak',
        'FAQ' => 'SSS',
        'Expired' => 'Süresi Geçmiş',
        'Under Review' => 'İncelemede',
        'Pending' => 'Beklemede',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'Posta Birleştir',
        'eula' => 'EULA',
        'nda' => 'NDA',
        'license' => 'Lisans Sözleşmesi',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'Kabul',
        'decline' => 'Red',
        'tentative' => 'Kesin Değil',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'Kabul edildi',
        'decline' => 'Reddedildi',
        'tentative' => 'Kesin Değil',
        'none' => 'Yok',
        ],
        'dataset_output_default_dom' => [
        'table' => 'Tablo',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'Tek Modül',
        'Multi Module' => 'Çok Modül',
        ],
        'report_align_dom' => [
        'left' => 'Sol',
        'center' => 'Merkez',
        'right' => 'Sağ',
        ],

        'width_type_dom' => [
        '%' => 'Yüzde (%)',
        'px' => 'Piksel (px)',
        ],
        'report_color_dom' => [
        '' => 'Varsayılan',
        'black' => 'Siyah',
        'green' => 'Yeşil',
        'blue' => 'Mavi',
        'red' => 'Kırmızı',
        'white' => 'Beyaz',
        'DarkGreen' => 'Koyu Yeşil',
        'LightGray' => 'Açık Yeşil',
        'DodgerBlue' => 'Masmavi',
        'LightBlue' => 'Açık Mavi',
        ],
        'font_size_dom' => [
        '-5' => 'Daha Küçük (-5)',
        '-4' => 'Daha Küçük (-4)',
        '-3' => 'Daha Küçük (-3)',
        '-2' => 'Daha Küçük (-2)',
        '-1' => 'Daha Küçük (-1)',
        'Default' => 'Varsayılan',
        '1' => 'Daha Büyük (+1)',
        '2' => 'Daha Büyük (+2)',
        '3' => 'Daha Büyük (+3)',
        '4' => 'Daha Büyük (+4)',
        '5' => 'Daha Büyük (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'Ana Sorgu',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'Görüntüle',
//  'Group By' => 'Group By',
        'Calculation' => 'Hesaplama',
        ],
        'query_display_type_dom' => [
        'Default' => 'Varsayılan',
        'Custom' => 'Özel',
        'Hidden' => 'Gizli',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'Gün',
        'Week' => 'Hafta',
        'Month' => 'Ay',
        'Quarter' => 'Çeyrek',
        'Year' => 'Yıl',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'Şimdi',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'TOPLAM',
        'AVG' => 'ORTALAMA',
        'COUNT' => 'Sayı',
        'STDDEV' => 'Standart Sapma',
        'VARIANCE' => 'Varyans',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'Standart Alan',
        'Time' => 'Zaman Aralığı',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'Satırlar (Y-Eksen)',
        'Columns' => 'Satırlar (X-Eksen)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'Toplam (Genel)',
        'AVG' => 'Ortalama',
        'MAX' => 'Maksimum',
        'MIN' => 'Minimum',
        'COUNT' => 'Sayı',
        'STDDEV' => 'Standart Sapma',
        'VARIANCE' => 'Varyans',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'Standart',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'Matematik Hesaplayıcı',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'Alan',
        'Value' => 'Değer',
        'Group' => 'Grup',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'Kolon',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'Etkisiz',
        'Enabled' => 'Etkin',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'Normal',
        'Scalar' => 'Sayısal',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'Metin',
        'Accounting' => 'Finansal',
        'Date' => 'Tarih',
        'Datetime' => 'Tarih Saat',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'Yıl',
        'Quarter' => 'Çeyrek',
        'Month' => 'Ay',
        'Week' => 'Hafta',
        'Day' => 'Gün',
        ],
        'dataset_style_dom' => [
        'normal' => 'Normal',
        'bold' => 'Kalın',
        'italic' => 'İtalik',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) Artı',
        '-' => '(-) Eksi',
        '*' => '(X) Çarpım',
        '/' => '(/) Böl',
        ],
        'wflow_type_dom' => [
        'Normal' => 'Kayıtlar kaydedildiği zaman',
        'Time' => 'Zaman geçtikten sonra',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Eşittir',
        'in' => 'Ondan',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'Ondan',
        'not_in' => 'Ondan Değil',
        ],
        'cselect_type_dom' => [
        'Equals' => 'Eşittir',
        'Does not Equal' => 'Eşit Değildir',
        ],
        'dselect_type_dom' => [
        'Equals' => 'Eşittir',
        'Less Than' => 'Küçüktür',
        'More Than' => 'Daha Fazla',
        'Does not Equal' => 'Eşit Değil',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'Evet',
        'bool_false' => 'Hayır',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'Eşittir',
        ],
        'tselect_type_dom' => [
        '0' => '0 saat',
        '14440' => '4 saat',
        '28800' => '8 saat',
        '43200' => '12 saat',
        '86400' => '1 gün',
        '172800' => '2 gün',
        '259200' => '3 gün',
        '345600' => '4 gün',
        '432000' => '5 gün',
        '604800' => '1 hafta',
        '1209600' => '2 hafta',
        '1814400' => '3 hafta',
        '2592000' => '30 gün',
        '5184000' => '60 gün',
        '7776000' => '90 gün',
        '10368000' => '120 gün',
        '12960000' => '150 gün',
        '15552000' => '180 gün',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'daha fazlaydı',
        'Less Than' => 'daha küçük:',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'E-Posta',
        'Invite' => 'Davetiye',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'Normal Mesaj',
        'Custom Template' => 'Özel Şablon',
        'System Default' => 'Sistem Varsayılan Değerleri',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'Oturum Açmış Kullanıcılar',
        'rel_user' => 'İlgili Kullanıcılar',
        'rel_user_custom' => 'İlgili Özel Kullanıcı',
        'specific_team' => 'Belirli Takım',
        'specific_role' => 'Belirli Rol',
        'specific_user' => 'Belirli Kullanıcı',
        ],
        'wflow_array_type_dom' => [
        'future' => 'Yeni Değer',
        'past' => 'Eski Değer',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'Kullanıcı',
        'Manager' => "Kullanıcının Yöneticisi",
        ],
        'wflow_address_type_dom' => [
        'to' => 'Kime:',
        'cc' => 'Bilgi:',
        'bcc' => 'Gizli:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'Kime:',
        'cc' => 'Bilgi:',
        'bcc' => 'Gizli:',
        'invite_only' => '(Yalnızca Davet Et)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'Kime:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'Kaydı Güncelle',
        'update_rel' => 'İlgili Kaydı Güncelle',
        'new' => 'Yeni Kayıt',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'Tetiklenen Tarih',
        'Existing Value' => 'Var olan Değer',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'Temel Seçenekler',
        'Advanced' => 'Gelişmiş Seçenekler',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'Tetiklenmiş kayda atanmış kullanıcı',
        'modified_user_id' => 'Tetiklenmiş kaydı en son değiştiren kullanıcı',
        'created_by' => 'Tetiklenmiş kaydı oluşturan kullanıcı',
        'current_user' => 'Oturum Açmış Kullanıcılar',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'Tetiklenmiş Kaydın Takımı',
        'team_set_id' => 'Başlatılmış Kaydın Geçerli Ekip Seti',
        'current_team' => 'Oturum Açmış Kullanıcının Takımı',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'Açılır-listeyi geri al',
        'advance' => 'Açılır-listeyi ileri al',
        ],
        'wflow_record_type_dom' => [
        'All' => 'Yeni ve Var olan Kayıtlar',
        'New' => 'Sadece Yeni Kayıtlar',
        'Update' => 'Sadece Var olan Kayıtlar',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'Tüm ilişkili',
        //'first' => 'The first related',
        'filter' => 'Filtreleme ile ilgili',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'tüm ilişkili',
        'any' => 'herhangi bir ilişki',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'Alarmlar sonra Aksiyonlar',
        'actions_alerts' => 'Aksiyonlar sonra Alarmlar'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'Yok',
        'Daily' => 'Günlük',
        'Weekly' => 'Haftalık',
        'Monthly' => 'Aylık',
        'Yearly' => 'Yıllık',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'Gün',
        'Weekly' => 'hafta(lar)',
        'Monthly' => 'ay(lar)',
        'Yearly' => 'yıl(lar)',
        ],

        'repeat_end_types' => [
        'Until' => 'Kadar',
        'Occurrences' => 'Yinelemeler',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'Yok',
        'Each' => 'Her',
        'On' => 'Üstünde',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'birinci',
        'second' => 'ikinci',
        'third' => 'üçüncü',
        'fourth' => 'dördüncü',
        'fifth' => 'beşinci',
        'last' => 'sonuncu',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'Pazar',
        'Mon' => 'Pazartesi',
        'Tue' => 'Salı',
        'Wed' => 'Çarşamba',
        'Thu' => 'Perşembe',
        'Fri' => 'Cuma',
        'Sat' => 'Cumartesi',
        'Day' => 'Gün',
        'WD' => 'Hafta içi',
        'WE' => 'Hafta Sonu',
        ],

        'duration_dom' => [
        '' => 'Yok',
        '900' => '15 dakika',
        '1800' => '30 dakika',
        '2700' => '45 dakika',
        '3600' => '1 saat',
        '5400' => '1.5 saat',
        '7200' => '2 saat',
        '10800' => '3 saat',
        '21600' => '6 saat',
        '86400' => '1 gün',
        '172800' => '2 gün',
        '259200' => '3 gün',
        '604800' => '1 hafta',
        ],
        'repeat_month_dom' => [
        '1' => 'Ocak',
        '2' => 'Şubat',
        '3' => 'Mart',
        '4' => 'Nisan',
        '5' => 'Mayıs',
        '6' => 'Haziran',
        '7' => 'Temmuz',
        '8' => 'Ağustos',
        '9' => 'Eylül',
        '10' => 'Ekim',
        '11' => 'Kasım',
        '12' => 'Aralık',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'Varsayılan',
        'seed' => 'Kaynak',
        'exempt_domain' => 'Domain e Göre Engelleme Listesi',
        'exempt_address' => 'E-Posta ya Göre Engelleme Listesi',
        'exempt' => 'Id ye Göre Engelleme Listesi',
        'test' => 'Test',
        ],
        'currency_status_dom' => [
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'Aktif',
        'inactive' => 'İnaktif',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'Gönderilen/Denenen Mesaj',
        'send error' => 'Geri Dönen Mesajlar, Diğerleri',
        'invalid email' => 'Geri Dönen Mesajlar, Geçersiz E-Posta',
        'link' => 'Click-thru Link&#39;i',
        'viewed' => 'Görüntülenmiş Mesaj',
        'removed' => 'Liste Dışı',
        'lead' => 'Oluşturulan Potansiyeller',
        'contact' => 'Oluşturulan Kontaklar',
        'blocked' => 'Adres veya Domain Adı Nedeniyle Engellendi',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'Kontaklar',
        'Users' => 'Kullanıcılar',
        'Prospects' => 'Hedefler',
        'Leads' => 'Potansiyeller',
        'Accounts' => 'Müşteriler',
        ],
        'merge_operators_dom' => [
        'like' => 'İçerir',
        'exact' => 'Tam',
        'start' => 'Başlar',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'Evet',
        'false' => 'Hayır',
        'required' => 'Gerekli',
        ],

        'fts_field_config' => [
        '0' => 'Etkisiz',
        '2' => 'Aranabilir',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'Etkisiz',
        1 => 'Etkin',
        2 => 'Filtrede',
        3 => 'Seçili Varsayılan Filtre',
        4 => 'Sadece Filtrele',
        ],

        'navigation_paradigms' => [
        'm' => 'Modüller',
        'gm' => 'Gruplanmış Modüller',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'Başlamadı',
        'inprogress' => 'İşlemde',
        'signed' => 'İmzalı',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'Aylık',
        'quarterly' => 'Çeyrek',
        'halfyearly' => 'Yarım yıllık',
        'yearly' => 'Yıllık',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 Gün',
        '3' => '3 Gün',
        '5' => '5 Gün',
        '7' => '1 Hafta',
        '14' => '2 Hafta',
        '21' => '3 Hafta',
        '31' => '1 Ay',
        ],
        'projects_priority_options' => [
        'high' => 'Yüksek',
        'medium' => 'Orta',
        'low' => 'Düşük',
        ],

        'projects_status_options' => [
        'notstarted' => 'Başlamadı',
        'inprogress' => 'İşlemde',
        'completed' => 'Tamamlandı',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'Açıklamaları Aç',
        'collapselegend' => 'Açıklamaları Kapat',
        'clickfordrilldown' => 'Detaylar İçin Tıkla',
        'drilldownoptions' => 'Detaylar İçin Seçenekler',
        'detailview' => 'Detay Görüntüleme...',
        'piechart' => 'Dairesel Grafik',
        'groupchart' => 'Grup Grafik',
        'stackedchart' => 'Üst Üste Grafik',
        'barchart' => 'Bar Grafik',
        'horizontalbarchart' => 'Yatay Grafik',
        'linechart' => 'Çizgi Grafik',
        'noData' => 'Veri Mevcut Değil',
        'print' => 'Yazdır',
        'pieWedgeName' => 'bölümler',
        ],
        'chart_types' => [
        'hBarF' => 'Yatay Çubuk (Üst üste)',
        'hGBarF' => 'Yatay Çubuk (Gruplandırılmış)',
        'vBarF' => 'Dikey Çubuk (Üst üste)',
        'vGBarF' => 'Dikey Çubuk (Gruplandırılmış)',
        'pieF' => 'Pasta',
        'funnelF' => 'Huni',
        'lineF' => 'Çizgi',
        'donutF' => 'Halka',
        'treemapF' => 'Ağaç Haritası',
        ],
        'd3_value_placement' => [
        '0' => 'Yok',
        '1' => 'Varsayılan',
        'start' => 'İlk',
        'middle' => 'Orta',
        'end' => 'Son',
        'top' => 'Üst',
        'total' => 'Toplam',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'Boru',
        'hbar' => 'Yatay Çubuk',
        ],
        'release_status_dom' => [
        'Active' => 'Aktif',
        'Inactive' => 'İnaktif',
        ],
        'email_settings_for_ssl' => [
        '0' => 'Boş',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Google Daha Az Güvenli Uygulamalar',
        'exchange' => 'Değiştir',
        'other' => 'Diğer',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'Diğer',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'Tek Tırnak (&#39;)',
        '"' => 'Çift Tırnak (")',
        '' => 'Yok',
        'other' => 'Diğer:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'Diğer:',
        ],
        'link_target_dom' => [
        '_blank' => 'Yeni Pencere',
        '_self' => 'Aynı Pencere',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'Otomatik olarak yenileme',
        '30' => 'Her 30 saniye',
        '60' => 'Her 1 dakika',
        '180' => 'Her 3 dakika',
        '300' => 'Her 5 dak.',
        '600' => 'Her 10 dakika',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'Yok',
        '15' => 'Her 15 Dakikada',
        '30' => 'Her 30 Dakikada',
        '45' => 'Her 45 Dakikada',
        '60' => 'Her Saat',
        '120' => 'Her 2 Saatte',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'Hiç',
        '30' => 'Her 30 saniye',
        '60' => 'Her 1 dakika',
        '180' => 'Her 3 dakika',
        '300' => 'Her 5 dak.',
        '600' => 'Her 10 dakika',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'Yok',
        '1' => 'Her 1 Dakikada',
        '5' => 'Her 5 Dakikada',
        '10' => 'Her 10 Dakikada',
        '15' => 'Her 15 Dakikada',
        '30' => 'Her 30 Dakikada',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'Eşittir',
        'not_equal' => 'Üzerinde değil',
        'greater_than' => 'Sonra',
        'less_than' => 'Önce',
        'last_7_days' => 'Son 7 gün',
        'next_7_days' => 'Önümüzdeki 7 Gün',
        'last_30_days' => 'Son 30 gün',
        'next_30_days' => 'Önümüzdeki 30 Gün',
        'last_month' => 'Geçen Ay',
        'this_month' => 'Bu Ay',
        'next_month' => 'Gelecek Ay',
        'last_year' => 'Son Yıl',
        'this_year' => 'Bu Yıl',
        'next_year' => 'Gelecek Yıl',
        'between' => 'Arasında',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'Son Yıl',
        'last_month' => 'Geçen Ay',
        'last_30_days' => 'Son 30 gün',
        'last_7_days' => 'Son 7 gün',
        'this_month' => 'Bu Ay',
        'this_year' => 'Bu Yıl',
        'next_7_days' => 'Önümüzdeki 7 Gün',
        'next_30_days' => 'Önümüzdeki 30 Gün',
        'next_month' => 'Gelecek Ay',
        'next_year' => 'Gelecek Yıl',
        ],
        'numeric_range_search_dom' => [
        '=' => 'Eşittir',
        'not_equal' => 'Eşit Değildir',
        'greater_than' => 'Büyüktür',
        'greater_than_equals' => 'Eşit veya Büyük',
        'less_than' => 'Küçüktür',
        'less_than_equals' => 'Eşit veya Küçük',
        'between' => 'Arasında',
        ],

        'filter_checkbox_dom' => [
        0 => 'Yanlış',
        1 => 'Doğru',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'Kazanıldı',
        'lost' => 'Kaybedildi',
        'active' => 'Aktif',
        ],

        'sweetspot_theme_options' => [
        'default' => 'Varsayılan',
        'light' => 'Açık',
        'dark' => 'Koyu',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'Taşı',
        'donothing' => 'İşlem Yapma',
        ],
        'processes_auto_save_interval' => [
        0 => 'Hiç',
        30000 => 'Her 30 saniyede',
        60000 => 'Her 1 dakikada',
        120000 => 'Her 2 dakikada',
        180000 => 'Her 3 dakikada',
        240000 => 'Her 4 dakikada',
        300000 => 'Her 5 dakikada',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'Evet',
        'No' => 'Hayır',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'Satış Tahminimde',
        'sales_stage' => 'Satış Aşaması',
        'probability' => 'Olasılık',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'Muhtemel',
        'best' => 'En İyi',
        'worst' => 'En ötüsü',
        ],
        'webLogicHookList' => [
        'after_save' => 'Kayıt Sonrasında',
        'after_delete' => 'Silme Sonrasında',
        'after_relationship_add' => 'İlişki Eklemesi Sonrasında',
        'after_relationship_delete' => 'İlişki Silinmesi Sonrasında',
        'after_login' => 'Bağlantı Sonrasında',
        'after_logout' => 'Bağlantı Sonlandırılması Sonrası',
        'after_login_failed' => 'Bağlantı Sonrası Başarısız',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'Etkin',
        'INACTIVE' => 'Etkisiz',
        ],
        'dashboard_view_name_list' => [
        'record' => 'Kayıt',
        'records' => 'Liste',
        'activities' => 'Aktivite Akışı',
        'multi-line' => 'Çok Satırlı Liste',
        'omnichannel' => 'Omnichannel',
        'home' => 'Home',
        'focus' => 'Odak Bölmesi',
        ],
        'metric_context_list' => [
        'service_console' => 'Servis Konsolu',
        'renewals_console' => 'Yenilemeler Konsolu',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'Saat başı',
        '21600' => 'Her 6 saatte',
        '43200' => 'Her 12 Saatte',
        '86400' => 'Günlük',
        '604800' => 'Haftalık',
        '1209600' => 'Her 2 Haftada',
        '2419200' => 'Her 4 Haftada',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'Yıl(lar)',
        'month' => 'Ay(lar)',
        'day' => 'Gün(ler)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'Zaman Kapalı',
        'event' => 'Olay',
        'other' => 'Diğer',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'Tarih (Son {{module}})',
        'start_date:asc' => 'Tarih (İlk {{module}})',
        'total_revenue:desc' => 'Fiyat (En Yüksek Toplam)',
        'total_revenue:asc' => 'Fiyat (En Düşük Toplam)',
        ],
        'calendar_type_list' => [
        'main' => 'Takvim Merkezi',
        ],
        'calendar_views_options' => [
        'day' => 'Gün',
        'week' => 'Hafta',
        'workWeek' => 'Çalışma Haftası',
        'expandedMonth' => 'Ay',
        'agenda' => 'Ajanda',
        'timeline' => 'Zaman Çizelgesi',
        'monthSchedule' => 'Planlayıcı',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'Oluşturuldu',
        'completed' => 'Tamamlandı',
        'declined' => 'Reddedildi',
        'delivered' => 'Teslim Edildi',
        'sent' => 'Gönderildi',
        'signed' => 'İmzalandı',
        'voided' => 'Geçersiz kılındı',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'Potansiyel alıcıların listesini göster',
        'dont_show' => 'Potansiyel alıcıları gösterme',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'İmzalayan',
        'carbon_copy' => 'Görüntüleyici (Karbon kopya)',
        'certified_delivery' => 'Görüntüleyici (Sertifikalı Teslimat)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'Varsayılan',
        'color' => 'Renk',
        'image' => 'Resim',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'Kısaltma',
        'icon' => 'Simge',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'Aşağı Ok',
        'sicon-chevron-left' => 'Köşeli çift ayraç Sola',
        'sicon-check' => 'Kontrol',
        'sicon-clock' => 'Saat',
        'sicon-dashboard-default' => 'Pano Varsayılanı',
        'sicon-dashboard' => 'Pano',
        'sicon-edit' => 'Düzenle',
        'sicon-caret-down' => 'Düzeltme İşareti Aşağı',
        'sicon-folder' => 'Klasör',
        'sicon-info' => 'Bilgi',
        'sicon-kebab' => 'Kebap',
        'sicon-link' => 'Bağlantı',
        'sicon-list' => 'Liste',
        'sicon-logout' => 'Çıkış',
        'sicon-minus' => 'Eksi',
        'sicon-folder-open' => 'Klasör Açık',
        'sicon-plus-sm' => 'Artı Sm',
        'sicon-refresh' => 'Yenile',
        'sicon-plus' => 'Artı',
        'sicon-settings' => 'Ayarlar',
        'sicon-arrow-right-double' => 'Sağ Ok Çift',
        'sicon-reports' => 'Raporlar',
        'sicon-user' => 'Kullanıcı',
        'sicon-upload' => 'Yükleyin',
        'sicon-user-group' => 'Kullanıcı Grubu',
        'sicon-arrow-left-double' => 'Sol Ok Çift',
        'sicon-chevron-up' => 'Köşeli çift ayraç yukarı',
        'sicon-caret-up' => 'Düzeltme İşareti',
        'sicon-star-fill' => 'İçi Dolu Yıldız',
        'sicon-download' => 'İndir',
        'sicon-close' => 'Kapat',
        'sicon-tile-view' => 'Kutucuk Görünümü',
        'sicon-list-view' => 'Liste Görünümü',
        'sicon-thumbs-down' => 'Başparmak Aşağı',
        'sicon-warning-circle' => 'Uyarı Çemberi',
        'sicon-phone' => 'Telefon',
        'sicon-email' => 'E-posta',
        'sicon-document' => 'Doküman',
        'sicon-note' => 'Not',
        'sicon-preview' => 'Ön İzleme',
        'sicon-copy' => 'Kopyala',
        'sicon-launch' => 'Başlat',
        'sicon-lock' => 'Kilitle',
        'sicon-arrow-top-right' => 'Saü Üst Ok',
        'sicon-full-screen' => 'Tam Ekran',
        'sicon-full-screen-exit' => 'Tam Ekran Çıkış',
        'sicon-expand-left' => 'Sola Genişlet',
        'sicon-expand-right' => 'Sağa Genişlet',
        'sicon-focus-drawer' => 'Odak Bölmesi',
        'sicon-ban' => 'Yasakla',
        'sicon-thumbs-up' => 'Baş Parmak Yukarı',
        'sicon-search' => 'Ara',
        'sicon-calendar' => 'Takvim',
        'sicon-calendar-lg' => 'Takvim Lg',
        'sicon-mobile-lg' => 'Mobil Lg',
        'sicon-star-fill-lg' => 'İçi Dolu Yıldız Lg',
        'sicon-star-outline-lg' => 'İçi Boş Yıldız Lg',
        'sicon-reset-lg' => 'Sıfırla Lg',
        'sicon-exchange-lg' => 'Değiştir Lg',
        'sicon-help-lg' => 'Yardım Lg',
        'sicon-close-lg' => 'Kapat Lg',
        'sicon-plus-lg' => 'Artı Lg',
        'sicon-shortcuts-lg' => 'Kısa Yollar Lg',
        'sicon-search-lg' => 'Ara Lg',
        'sicon-email-lg' => 'E-posta Lg',
        'sicon-note-lg' => 'Not Lg',
        'sicon-document-lg' => 'Doküman Lg',
        'sicon-add-dashlet-lg' => 'Pencere Ekle Lg',
        'sicon-collapse-lg' => 'Daralt Lg',
        'sicon-hamburger-lg' => 'Hamburger Lg',
        'sicon-pin-fill-lg' => 'İçi Dolu İğne Lg',
        'sicon-expand-lg' => 'Genişlet Lg',
        'sicon-copy-lg' => 'Kopyala Lg',
        'sicon-dashboard-lg' => 'Pano Lg',
        'sicon-star-outline' => 'İçi Boş Yıldız',
        'sicon-reset' => 'Sıfırla',
        'sicon-unlink' => 'Bağlantıyı Kaldır',
        'sicon-phone-lg' => 'Telefon Lg',
        'sicon-attach' => 'Ekle',
        'sicon-case-lg' => 'Talep Lg',
        'sicon-arrow-right-lg' => 'Sağ Ok Lg',
        'sicon-check-circle-lg' => 'Kontrol Çemberi Lg',
        'sicon-text-formatting' => 'Metin Biçimlendirme',
        'sicon-check-circle' => 'Kontrol Çemberi',
        'sicon-upload-lg' => 'Yükle Lg',
        'sicon-flag-lg' => 'Bayrak Lg',
        'sicon-studio-lg' => 'Stüdyo Lg',
        'sicon-contact-lg' => 'Kişi Lg',
        'sicon-edit-lg' => 'Düzenle Lg',
        'sicon-arrow-left' => 'Sol Ok',
        'sicon-reply-all' => 'Tümünü Yanıtla',
        'sicon-message-lg' => 'Mesaj Lg',
        'sicon-info-lg' => 'Bilgi Lg',
        'sicon-error-lg' => 'Hata Lg',
        'sicon-check-circle-line-lg' => 'Kontrol Çemberi Satırı Lg',
        'sicon-warning-line-lg' => 'Uyarı Çemberi Lg',
        'sicon-arrow-up' => 'Yukarı Ok',
        'sicon-arrow-right' => 'Sağ Ok',
        'sicon-nodes' => 'Düğümler',
        'sicon-hide' => 'Gizle',
        'sicon-help' => 'Yardım',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'Mesaj',
        'sicon-sugar-predict-lg' => 'Suhar Tahmin Lg',
        'sicon-sugar-predict' => 'Sugar Tahmin',
        'sicon-opportunity-lg' => 'Fırsat Lg',
        'sicon-lead-lg' => 'Potansiyel Lg',
        'sicon-account-lg' => 'Hesap Lg',
        'sicon-user-sm' => 'Kullanıcı Sm',
        'sicon-quote-lg' => 'Teklif Lg',
        'sicon-equal' => 'Eşit',
        'sicon-slicers-xl' => 'Dilimleyiciler Xl',
        'sicon-escalation-lg' => 'Artış Lg',
        'sicon-add-circle-lg' => 'Daire Ekle Lg',
        'sicon-add-line-lg' => 'Satırı Ekle Lg',
        'sicon-add-target-lg' => 'Hedef Ekle Lg',
        'sicon-help-circle-lg' => 'Yardım Dairesi Lg',
        'sicon-divide-line-lg' => 'Satırı Böl Lg',
        'sicon-string' => 'Dizi',
        'sicon-filter' => 'Filtrele',
        'sicon-number' => 'Sayı',
        'sicon-format-lg' => 'Biçimlendir Lg',
        'sicon-insights-lg' => 'Anlayışlar Lg',
        'sicon-invalid-circle-lg' => 'Geçersiz Daire Lg',
        'sicon-layout-xl' => 'Düzen Xl',
        'sicon-layout-lg' => 'Düzen Lg',
        'sicon-multiply-line-lg' => 'Çoklu Satır Lg',
        'sicon-redo-lg' => 'Yinele Lg',
        'sicon-refresh-lg' => 'Yenile Lg',
        'sicon-undo-lg' => 'Geri Al Lg',
        'sicon-activity-feed-xl' => 'Etkinlik Besleme Xl',
        'sicon-chevron-left-xl' => 'Köşeli Çift Ayraç Sola Xl',
        'sicon-close-xl' => 'Kapat Xl',
        'sicon-kebab-lg' => 'Kebap Lg',
        'sicon-insights-xl' => 'Anlayışlar Xl',
        'sicon-hide-lg' => 'Gizle Lg',
        'sicon-kebab-xl' => 'Kebap Xl',
        'sicon-comment-xl' => 'Yorum Xl',
        'sicon-share-lg' => 'Paylaş Lg',
        'sicon-trash' => 'Çöp',
        'sicon-launch-lg' => 'Başlat Lg',
        'sicon-thumbs-up-lg' => 'Baş Parmak Yukarı Lg',
        'sicon-thumbs-down-lg' => 'Başparmak Aşağı Lg',
        'sicon-warning-lg' => 'Uyarı Lg',
        'sicon-wizard-circle-xl' => 'Daire İçinde Sihirbaz Xl',
        'sicon-bell-cross-lg' => 'Üzeri Çizili Çan Lg',
        'sicon-bell-lg' => 'Çan Lg',
        'sicon-daily-lg' => 'Günlik Lg',
        'sicon-cloud-download-lg' => 'Bulut İndirme Lg',
        'sicon-unlock' => 'Kilit Açık',
        'sicon-news-lg' => 'Haber Lg',
        'sicon-weekly-lg' => 'Haftalık Lg',
        'sicon-knowledgebase-xl' => 'Bilgi Bankası Xl',
        'sicon-remove' => 'Kaldır',
        'sicon-chevron-down' => 'Köşeli Çift Ayraç Aşağı',
        'sicon-slicers-lg' => 'Dilimleyiciler Lg',
        'sicon-save-lg' => 'Kaydet Lg',
        'sicon-info-circle-lg' => 'Daire İçinde Bilgi Lg',
        'sicon-chevron-right' => 'Köşeli Çift Ayraç Sağa',
        'sicon-warning-circle-lg' => 'Uyarı Çemberi Lg',
        'sicon-right-paren-line-lg' => 'Sağ Parentez Çizgisi Lg',
        'sicon-comment-lg' => 'Yorum Lg',
        'sicon-target-lg' => 'Hedef Lg',
        'sicon-subtract-line-lg' => 'Çıkarma Çizgisi Lg',
        'sicon-settings-lg' => 'Ayarlar Lg',
        'sicon-left-paren-line-lg' => 'Sol Parantez Çizgisi Lg',
        'sicon-preview-lg' => 'Ön izleme Lg',
        'sicon-thumbs-down-line-lg' => 'Başparmak Aşağı Çizgisi Lg',
        'sicon-thumbs-up-line-lg' => 'Başparmak Yukarı Çizgisi Lg',
        'sicon-send-lg' => 'Gönder Lg',
        'sicon-contact-xl' => 'Kişi Xl',
        'sicon-wizard-circle-line-xl' => 'Daire İçinde Sihirba Çizgisi Xl',
        'sicon-trash-lg' => 'Çöp Lg',
        'sicon-pin-lg' => 'İğne Lg',
        'sicon-clock-lg' => 'Saat Lg',
        'sicon-comment-line-xl' => 'Yorum Satırı Xl',
        'sicon-dropdown-editor' => 'Açılır-Liste Düzenleyici',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'Hata',
        'sicon-catalog' => 'Katalog',
        'sicon-cloud' => 'Bulut',
        'sicon-config-api' => 'Yapılandırma Api&#39;si',
        'sicon-config-nav' => 'Yapılandırma Nav',
        'sicon-connectors' => 'Konnektörler',
        'sicon-contracts' => 'Kontratlar',
        'sicon-currencies' => 'Para Birimleri',
        'sicon-diagnostics' => 'Tanılar',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'E-Posta Kampanyası',
        'sicon-email-inbound' => 'E-posta Gelen',
        'sicon-email-queue' => 'E-Posta Kuyruğu',
        'sicon-forecasts' => 'Tahminler',
        'sicon-display-modules' => 'Modülleri Göster',
        'sicon-email-contacts' => 'E-Posta Kişileri',
        'sicon-import' => 'İçe Aktar',
        'sicon-log-viewer' => 'Günlük Görüntüleyici',
        'sicon-lab' => 'Laboratuvar',
        'sicon-map-pin' => 'Harita İğnesi',
        'sicon-manufacturers' => 'Üreticiler',
        'sicon-update' => 'Güncelle',
        'sicon-content-security' => 'İçerik Güvenliği',
        'sicon-module-builder' => 'Modül Oluşturucu',
        'sicon-languages' => 'Diller',
        'sicon-module-loader' => 'Modül Yükleyici',
        'sicon-oauth-key' => 'Oauth Anahtarı',
        'sicon-password-mgmt' => 'Şifre Yönetimi',
        'sicon-opportunities' => 'Fırsatlar',
        'sicon-upgrade' => 'Yükselt',
        'sicon-portal' => 'Portal',
        'sicon-product-types' => 'Ürün Tipleri',
        'sicon-quotes' => 'Teklifler',
        'sicon-relate-fields' => 'İlişki Alanlar',
        'sicon-repair' => 'Onar',
        'sicon-role-mgmt' => 'Görev Yönetimi',
        'sicon-scheduler' => 'Planlayıcı',
        'sicon-shippers' => 'Nakliyatçılar',
        'sicon-studio' => 'Stüdyo',
        'sicon-web-logic' => 'Web Mantığı',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'Vergi Oranları',
        'sicon-team-mgmt' => 'Ekip Yönetimi',
        'sicon-team-perm' => 'Ekip İzni',
        'sicon-tracker' => 'Takip Edici',
        'sicon-workflow' => 'İş Akışı',
        'sicon-mask' => 'Maske',
        'sicon-mask-disabled' => 'Maske Devre Dışı',
        'sicon-email-archive' => 'E-posta Arşivi',
        'sicon-mobile' => 'Cep Telefonu',
        'sicon-archive' => 'Arşivle',
        'sicon-automate-scroll' => 'Dikey Kaydırmalı Görünüm',
        'sicon-automate-stacked' => 'Yatay Kaydırmalı Görünüm',
        'sicon-pdf-manager' => 'Pdf Yöneticisi',
        'sicon-my-sites' => 'Sitelerim',
        'sicon-cloud-insights' => 'Bulut Anlayışları',
        'sicon-sugar-logo-24' => 'Sugar Logo 24',
        'sicon-sugar-logo-16' => 'Sugar Logo 16',
        'sicon-task-lg' => 'Görev Lg',
        'sicon-web-lg' => 'Web Lg',
        'sicon-events-lg' => 'Etkinlikler Lg',
        'sicon-sugar-logo-12' => 'Sugar Logo 12',
        'sicon-tag' => 'Etiket',
        'sicon-tag-lg' => 'Etiket Lg',
        'sicon-bell-lg-line' => 'Çan Lg Çizgi',
        'sicon-matrix-xxl' => 'Matris Xxl',
        'sicon-advanced-filter' => 'Gelişmiş Filtre',
        'sicon-rows-and-columns-xxl' => 'Satırlar ve Sütunlar Xxl',
        'sicon-summation-details-xxl' => 'Toplama Ayrıntıları Xxl',
        'sicon-summation-xxl' => 'Toplama Xxl',
        'sicon-lock-lg' => 'Kilitle Lg',
        'sicon-csv-file-xxl' => 'Csv Dosyası Xxl',
        'sicon-logo-linkedin' => 'Logo Linkedin',
        'sicon-briefcase' => 'Evrak Çantası',
        'sicon-car-front' => 'Araç Önü',
        'sicon-airplane' => 'Uçak',
        'sicon-laptop' => 'Dizüstü Bilgisayar',
        'sicon-logo-instagram' => 'Logo Instagram',
        'sicon-single-bed' => 'Tek Kişilik Yatak',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'Logo Snapchat',
        'sicon-video-lg' => 'Video Lg',
        'sicon-reply' => 'Yanıtla',
        'sicon-subtract' => 'Çıkar',
        'sicon-arrow-up-circle-line' => 'Daire İçinde Yukarı Ok',
        'sicon-asterisk' => 'Yıldız İşareti',
        'sicon-dot-circle-o-lg' => 'Daire İçinde Nokta Lg',
        'sicon-forward' => 'İlet',
        'sicon-video' => 'Video',
        'sicon-gavel' => 'Yargıç Tokmağı',
        'sicon-login' => 'Oturum Aç',
        'sicon-pdf-file-xxl' => 'Pdf Dosyası Xxl',
        'sicon-login-lg' => 'Oturum Aç Lg',
        'sicon-cloud-download-xl' => 'Bulut İndirme Xl',
        'sicon-campaigns-lg' => 'Kampanyalar Lg',
        'sicon-customer-journey-stages-lg' => 'Müşteri Deneyimi Aşamaları Lg',
        'sicon-role-mgmt-lg' => 'Görev Yönetimi Lg',
        'sicon-default-module-lg' => 'Varsayılan Modül Lg',
        'sicon-quoted-line-items-lg' => 'Teklif Kalemleri Lg',
        'sicon-projects-lg' => 'Projeler Lg',
        'sicon-process-business-rules-lg' => 'İş Kurallarını İşle Lg',
        'sicon-process-email-templates-lg' => 'E-Posta Şablonlarını İşle Lg',
        'sicon-processes-lg' => 'Süreçler Lg',
        'sicon-process-definitions-lg' => 'Süreç Tanımları Lg',
        'sicon-target-lists-lg' => 'Hedef Listeler Lg',
        'sicon-purchased-line-items-lg' => 'Satın Alınan Kalemler Lg',
        'sicon-user-group-lg' => 'Kullanıcı Grubu Lg',
        'sicon-revenue-line-items-lg' => 'Gelir Kalemleri Lg',
        'sicon-business-centers-lg' => 'İş Merkezleri Lg',
        'sicon-logo-fb-simple' => 'Logo Fb Basit',
        'sicon-forecasts-lg' => 'Tahminler Lg',
        'sicon-contracts-lg' => 'Kontratlar Lg',
        'sicon-purchase-lg' => 'Satın Al Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'Müşteri Deneyimi Lg',
        'sicon-data-privacy-lg' => 'Veri Gizliliği Lg',
        'sicon-home-lg' => 'Ana Ekran Lg',
        'sicon-data-table' => 'Veri Tablosu',
        'sicon-medical-clipboard-lg' => 'Tıbbi Pano Lg',
        'sicon-privacy-lg' => 'Gizlilik Lg',
        'sicon-marketplace' => 'Mağaza',
        'sicon-marketplace-lg' => 'Mağaza Lg',
        'sicon-blockquote-lg' => 'Blok Alıntı Lg',
        'sicon-casino-lg' => 'Casino Lg',
        'sicon-jacuzzi-lg' => 'Jakuzi Lg',
        'sicon-scissors-lg' => 'Makas Lg',
        'sicon-storage-lg' => 'Depo Lg',
        'sicon-fan-lg' => 'Fan Lg',
        'sicon-medicine-lg' => 'Tıp',
        'sicon-plant-lg' => 'Fabrika Lg',
        'sicon-telescope-lg' => 'Teleskop Lg',
        'sicon-smart-phone-lg' => 'Akıllı Telefon Lg',
        'sicon-coffee-lg' => 'Kahve Lg',
        'sicon-martini-lg' => 'Martini Lg',
        'sicon-cocktail-lg' => 'Kokteyl Lg',
        'sicon-stadium-lg' => 'Stadyum Lg',
        'sicon-fire-lg' => 'Ateş Lg',
        'sicon-window-lg' => 'Pencere Lg',
        'sicon-lotus-lg' => 'Lotus Lg',
        'sicon-windmill-lg' => 'Yel Değirmeni Lg',
        'sicon-spades-lg' => 'Maça Lg',
        'sicon-hearts-lg' => 'Kupa Lg',
        'sicon-diamonds-lg' => 'Karo Lg',
        'sicon-clubs-lg' => 'Kulüpler Lg',
        'sicon-skull-lg' => 'Kuru Kafa Lg',
        'sicon-send' => 'Gönder',
        'sicon-world-lg' => 'Dünya Lg',
        'sicon-airplane-lg' => 'Uçak Lg',
        'sicon-planet-lg' => 'Gezegen Lg',
        'sicon-trainer-lg' => 'Eğitmen Lg',
        'sicon-calculator-lg' => 'Hesap Makinesi Lg',
        'sicon-tv-lg' => 'TV Lg',
        'sicon-video-player-lg' => 'Video Oynatıcı Lg',
        'sicon-media-player-lg' => 'Medya Oynatıcı Lg',
        'sicon-decentralize-lg' => 'Dağıtılmış Lg',
        'sicon-statistics-lg' => 'İstatistik Lg',
        'sicon-virus-lg' => 'Virüs Lg',
        'sicon-shield-lg' => 'Kalkan Lg',
        'sicon-plug-lg' => 'Fiş Lg',
        'sicon-shuttle-lg' => 'Servis Lg',
        'sicon-soundwave-lg' => 'Ses Dalgası Lg',
        'sicon-graph-lg' => 'Grafik Lg',
        'sicon-playlist-lg' => 'Oynatma Listesi Lg',
        'sicon-voice-recognition-lg' => 'Ses Tanıma Lg',
        'sicon-machine-learning-lg' => 'Bilgisayarla Öğrenme Lg',
        'sicon-bed-lg' => 'Yatak Lg',
        'sicon-blueprint-lg' => 'Proje Lg',
        'sicon-content-delivery-lg' => 'İçerik Teslimi Lg',
        'sicon-questionnaire-lg' => 'Anket Lg',
        'sicon-presentation-lg' => 'Sunum Lg',
        'sicon-organic-lg' => 'Organik Lg',
        'sicon-transactions-lg' => 'İşlemler Lg',
        'sicon-wand-lg' => 'Değnek Lg',
        'sicon-bin-lg' => 'Çöp Kutusu Lg',
        'sicon-sync-lg' => 'Eşitleme Lg',
        'sicon-external-authentication-lg' => 'Harici Kimlik Doğrulama Lg',
        'sicon-tracking-activity-lg' => 'İzleme Etkinliği Lg',
        'sicon-account' => 'Hesap',
        'sicon-meetings-lg' => 'Toplantılar Lg',
        'sicon-stacked' => 'Yatay Bölünmüş Görünüm',
        'sicon-sidebyside' => 'Dikey Bölünmüş Görünüm',
        ],

        'module_colors_dom' => [
        'army' => 'Askeri',
        'coral' => 'Mercan',
        'green' => 'Yeşil',
        'orange' => 'Turuncu',
        'ocean' => 'Okyanus',
        'pacific' => 'Pasifik',
        'pink' => 'Pembe',
        'purple' => 'Mor',
        'red' => 'Kırmızı',
        'teal' => 'Deniz mavisi',
        'yellow' => 'Sarı',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'Yeni',
        'In Progress' => 'Devam Ediyor',
        'Closed' => 'Kapalı',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'Etkisizlik',
        'Lack of Progress' => 'İlerleme Eksikliği',
        'Customer-Imposed Deadline' => 'Müşteri Tarafından Uygulanan Son Tarih',
        'Account at Risk' => 'Risk Altındaki Hesap',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'Müşteri Talep Etti',
        'Internally Requested' => 'Dahili Olarak Talep Edildi',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'Talep',
        'Bugs' => 'Hata',
        'Accounts' => 'Hesap',
        'Opportunities' => 'Fırsat',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'Olumlu',
        'Negative' => 'Olumsuz',
        'Neutral' => 'Nötr',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'Olası Değil',
        '02_less_likely' => 'Daha Az Olası',
        '03_neutral' => 'Neutral',
        '04_more_likely' => 'Daha Fazla Olası',
        '05_very_likely' => 'Büyük Olasılıkla',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'Müşterilerle Eşleşmiyor',
        '02_no_match' => '',
        '01_matches_customers' => 'Müşterilerle Eşleşiyor',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'Potansiyel',
        'Accounts' => 'Hesap',
        'Contacts' => 'Kişi',
        'Cases' => 'Talep',
        'Opportunities' => 'Fırsat',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'Başlamadı',
        'in_progress' => 'Devam Ediyor',
        'completed' => 'Tamamlandı',
        'cancelled' => 'İptal Edildi',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'Yok',
        'create' => 'Oluşturmada',
        'stage_start' => 'Aşama Başlangıcında',
        'previous_activity_completed' => 'Önceki Etkinlik Tamamlandı',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'Geçerli Kullanıcı',
        'parent_assignee' => 'Üst Devralan',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'Oluşturulmadan Sonra Geçen Gün Sayısı',
        'days_from_stage_started' => 'Aşamanın Başlamasından Sonra Geçen Gün Sayısı',
        'days_from_previous_activity_completed' => 'Önceki Etkinliği Tamamlanmasından Sonra Geçen Gün Sayısı',
        'days_from_parent_date_field' => 'Üst Tarihten Sonraki Gün Sayısı Alanı',
        'days_from_specific_activity_completed' => 'Belirli Bir Etkinliğin Tamamlanmasından Sonra Geçen Gün Sayısı',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'Oluşturulduğunda',
        'stage_started' => 'Aşama Başladığında',
        'previous_activity_completed' => 'Önceki Etkinlik Tamamlandığında',
        'parent_date_field' => 'Üst Tarih Alanında',
        'specific_activity_completed' => 'Belirli Etkinlik Tamamlandı',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'Mutlak',
        'Percentage' => 'Yüzde',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'Müşteri Görevi',
        'milestone' => 'Kilometre taşı',
        'internal_task' => 'İç Görev',
        'agency_task' => 'Temsilci Görevi',
        'automatic_task' => 'Otomatik Görev',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'Görev',
        'Calls' => 'Tel.Araması',
        'Meetings' => 'Toplantı',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'Yok',
        'create' => 'Oluşturmada',
        'stage_start' => 'Aşama Başlangıcında',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'Devral',
        'current_user' => 'Geçerli Kullanıcı',
        'parent_assignee' => 'Üst Devralan',
        'user' => 'Kullanıcı',
        'team' => 'Takım',
        'user_team' => 'Kullanıcı ve Takım',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'Devral',
        'none' => 'Yok',
        'create' => 'Oluşturmada',
        'stage_start' => 'Aşama Başlangıcında',
        'previous_activity_completed' => 'Önceki Etkinlik Tamamlandı',
        'specific_activity_completed' => 'Belirli Etkinlik Tamamlandı',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'Başlamadı',
        'in_progress' => 'Devam Ediyor',
        'not_completed' => 'Tamamlanmadı',
        'completed' => 'Tamamlandı',
        'cancelled' => 'İptal Edildi',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'Aşamayı Düzenle',
        'stage_add_task_button' => 'Görev Oluştur',
        'stage_add_meeting_button' => 'Toplantı Planla',
        'stage_add_call_button' => 'Tel. Araması Planla',
        'stage_delete_button' => 'Aşamayı Sil',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'Görev Ekle',
        'activity_add_sub_meeting_button' => 'Toplantı Planla',
        'activity_add_sub_call_button' => 'Tel. Araması Planla',
        'activity_not_applicable_button' => 'Uygulanamaz',
        'activity_delete_button' => 'Sil',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'Ayar Uygulanamaz',
        'remove_open_activities' => 'Açık Etkinlikleri Kaldır',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'Varsayılan',
        'custom' => 'Özel',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'AL',
        'POST' => 'YAYINLA',
        'PUT' => 'KOY',
        'PATCH' => 'YAMA',
        'DELETE' => 'SİL',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'İsteği Atla',
        'json' => 'JSON',
        'http_query' => 'HTTP Sorgusu',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'Yanıt Yok',
        'json' => 'JSON',
        'http_query' => 'HTTP Sorgusu',
        'text' => 'Düz Metin',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'Oluşturmadan Önce',
        'after_create' => 'Oluşturmadan Sonra',
        'before_in_progress' => 'Devam Etmeden Önce',
        'after_in_progress' => 'Devam Etmeden Sonra',
        'before_completed' => 'Tamalanmadan Önce',
        'after_completed' => 'Tamamlanmadan Sonra',
        'before_not_applicable' => 'Uygulanamazdan Önce',
        'after_not_applicable' => 'Uygulanamazdan Sonra',
        'before_delete' => 'Silmeden Önce',
        'after_delete' => 'Silmeden Sonra',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Akıllı Kılavuz Bilgilerini Gönder',
        'custom_body' => 'Özel Yayın Gövdesi Gönder',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'Devam Ediyor',
        'completed' => 'Tamamlandı',
        'not_applicable' => 'Uygulanamaz',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'Kaydı Göster',
        'create_record' => 'Kayıt Oluştur',
        'update_record' => 'Kaydı Güncelle',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'Otomatik Olarak Kayıt Oluştur',
        'manual_create' => 'Manuel Olarak Kayıt Oluştur',
        'automatic_update' => 'Otomatik Olarak Kayıt Güncelle',
        'manual_update' => 'Manuel Olarak Kayıt Güncelle',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Akıllı Kılavuz Şablonu',
        'DRI_SubWorkflow_Templates' => 'Aşama Şablonu',
        'DRI_Workflow_Task_Templates' => 'Etkinlik Şablonu',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'Evet',
        'no' => 'Hayır',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'Yapıldı',
        'Not Held' => 'Düzenlenmedi',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'Yapıldı',
        'Not Held' => 'Düzenlenmedi',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'Tamamlandı',
        'Not Applicable' => 'Uygulanamaz',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Akıllı Kılavuz Şablonu',
        'DRI_SubWorkflow_Templates' => 'Aşama Şablonu',
        'DRI_Workflow_Task_Templates' => 'Etkinlik Şablonu',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'Görev',
        'Meetings' => 'Toplantı',
        'Calls' => 'Tel.Araması',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'Geçerli Görev',
        'Calls' => 'Geçerli Tel. Araması',
        'Meetings' => 'Geçerli Toplantı',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'Belirli Kullanıcılar',
        'specific_contacts' => 'Belirli Kişiler',
        'related_parent_users' => 'İlgili Üst Kullanıcılar',
        'related_parent_contacts' => 'İlgili Üst Kişiler',
        'add_all_contacts_from_parent' => 'Üst Ögeden Tüm Kişileri Ekle',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'Kullanıcılar',
        'specific_contacts' => 'Kişiler',
        'related_parent_users' => 'Kullanıcılar',
        'related_parent_contacts' => 'Kişiler',
        'add_all_contacts_from_parent' => 'Kişiler',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'Dakika',
        'hours' => 'Saat',
        'days' => 'Gün',
        'months' => 'Ay',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'Gün',
        'months' => 'Ay',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'Sabit Tarih',
        'relative' => 'Bağlantılı Tarih',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'Kullanıcılar',
        'teams' => 'Takımlar',
        'roles' => 'Roller',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide&#39;tan Sugar İşlemine',
        'sugar_action_to_smart_guide' => 'Sugar İşleminden Smart Guide&#39;a',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide Aşaması',
        'Smart Guide Activities' => 'Smart Guide Aktiviteleri',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'Tamamlandı',
        'cancelled' => 'İptal Edildi',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'Devam Ediyor',
        'completed' => 'Tamamlandı',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'Devam Ediyor',
        'completed' => 'Tamamlandı',
        'not_applicable' => 'Uygulanamaz',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'Tüm aktiviteleri Tamamlandı olarak işaretleyin',
        'mark_all_not_applicable' => 'Tüm Tamamlanmamış aktiviteleri Uygulanamaz olarak işaretleyin',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'Amerika Birleşik Devletleri (Oregon) [us-west-2]',
        'ca-central-1' => 'Kanada (Orta) [ca-central-1]',
        'ap-southeast-1' => 'Asya Pasifik (Singapur) [ap-southeast-1]',
        'ap-southeast-2' => 'Asya Pasifik (Sidney) [ap-southeast-2]',
        'eu-central-1' => 'Avrupa (Frankfurt) [eu-central-1]',
        'eu-west-2' => 'Avrupa (Londra) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'Kayıt Başlığı', // Studio editing of record views
    'LBL_RECORD_BODY' => 'Kartvizit', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'Daha Fazla Göster', // Studio editing of record views
    'LBL_FAVORITE' => 'Favori', // Record view header panel element
    'LBL_FOLLOW' => 'İzle', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'Bağlantıyı İzleyin',
    'LBL_TOGGLE_VISIBILITY' => 'Görünürlüğü Değiştir', // Record view header panel element
    'LBL_ACTIVITIES' => 'Aktivite Akışı',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar ve 3-D Küp, SugarCRM Inc.&#39;in tescilli ticari markalarıdır. ' .
        'Bu üründe kullanılan veya görünen diğer tüm şirket ve ürün adları, ilişkili olan ' .
        'SugarCRM ®, Sugar Enterprise™ ve Sugar™, SugarCRM Inc.&#39;in ticari markasıdır',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ ve Sugar™, SugarCRM Inc.&#39;nin ticari markalarıdır.',
    'LBL_SEND_INVITE' => 'Davet Gönder',
    'LBL_INVITEES' => 'Davetli',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'Misafir, davetinizi almayacak',
    'LBL_SELECT_ACTION_LABEL' => 'Aksiyon Seç',
    'LBL_TOGGLE_DRAWER' => 'Çekmeceyi Değiştir',
    'LBL_TOUR_NEXT' => 'Sonraki',
    'LBL_TOUR_SKIP' => 'Atla',
    'LBL_TOUR_BACK' => 'Geri',
    'LBL_TOUR_CLOSE' => 'Kapat',
    'LBL_TOUR_BTN_DONE' => 'Tamam',
    'LBL_TOUR_TAKE_TOUR' => 'İnceleyin',
    'LBL_TOUR_FULL_TOUR' => 'Tam Tur',
    'LBL_TOUR_MODULE' => 'Bu sayfayı turlayın',
    'LBL_TOUR_END_TOUR' => 'Tur Sonu',
    'LBL_TOUR_OVERVIEW' => 'Sayfa Genel Görünümü',
    'LBL_TOUR_REVISIT' => 'Turu herhangi bir zamanda görmek için buraya tıklayınız.',
    'LBL_MY_AREA_LINKS' => 'Bölgemdeki linkler:' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Canlıya Geçiyor' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'Hoş geldiniz' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'Gelişmiş Arama' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'Daha Fazla Detay' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'Satır içi Değiştir' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'Göster' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Ara' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'Ara...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'Kaldır' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'Ekle' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'Kolon' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 Kolon' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 Kolon' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Gelişmiş Arama' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'Ekle' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'Gizle/Göster' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'Sil' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'Ekle' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'Temizle' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'Sil' /*for 508 compliance fix*/,
    'LBL_ADD' => 'Ekle' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'Şirket Logosu' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'Takvim' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'Seçtiğiniz bir açılır liste değeri, Kayıt Görünümü Düzeninizi değiştirdi. ' .
        'Bu yeni düzendeki gizli alanların değerleri temizlendi. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'Aç',
    'LBL_SIDEBAR_NAV_CLOSE' => 'Kapat',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} menüsü',
    'LBL_GOTO_SUGARCRM_COM' => 'SugarCRM.com adresine gidin',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'ana modül navigasyon',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'alt panele değiştir',

    'LBL_ADVANCED' => 'Gelişmiş',
    'LBL_BASIC' => 'Temel',
    'LBL_MODULE_FILTER' => 'Filtrenin kaynağı',
    'LBL_CONNECTORS_POPUPS' => 'Bağlantı Açılır Sayfaları',
    'LBL_CLOSEINLINE' => 'Kapat',
    'LBL_EDITINLINE' => 'Değiştir',
    'LBL_VIEWINLINE' => 'Göster',
    'LBL_INFOINLINE' => 'Bilgi',
    'LBL_POWERED_BY_SUGARCRM' => 'SugarCRM Tarafından Geliştirildi',
    'LBL_PRINT' => 'Yazdır',
    'LBL_HELP' => 'Yardım',
    'LBL_TOUR' => 'Aktivite Görünümü Turu',
    'LBL_TOUR_LINK' => 'Bu Sayfada Gezinin',
    'LBL_MOBILE' => 'Cep Telefonu',
    'LBL_ID_FF_SELECT' => 'Seç',
    'DEFAULT' => 'Temel',
    'LBL_SORT' => 'Sıra',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Sunucu Ekle...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'SSL veya TLS üzerinden SMTP Aktifle',
    'LBL_NO_ACTION' => 'Bu isimle bir aksiyon yok.',
    'LBL_NO_DATA' => 'Veri Yok',
    'LBL_NOT_APPLICABLE' => 'Uygulanamaz',
    'LBL_ROUTING_ADD_RULE' => 'Kural Ekle',
    'LBL_ROUTING_ALL' => 'En Az',
    'LBL_ROUTING_ANY' => 'Herhangi Biri',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'İptal',
    'LBL_ROUTING_BUTTON_SAVE' => 'Kuralı Kaydet',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'Posta Kopyala',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Sugar Objesi Sil',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Dosya Sil',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'E-Posta Sil',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'E-Posta İlet',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'E-Posta İşaretle',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'Okunmuş Olarak İşaretle',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Okunmamış Olarak İşaretle',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'E-Posta Taşı',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'Aşağıdaki aksiyonları yerine getirin',
    'LBL_ROUTING_ACTIONS_REPLY' => 'E-Postayı Yanıtla',

    'LBL_ROUTING_CHECK_RULE' => "Bir hata tespit edildi:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'Lütfen işaretli alanları kontrol edin.',
    'LBL_ROUTING_CONFIRM_DELETE' => "Bu kuralı silmek istediğinizden emin misiniz?<br />Bu işlem geri alınamaz.",

    'LBL_ROUTING_FLAGGED' => 'işaret koy',
    'LBL_ROUTING_FORM_DESC' => 'Kaydedilmiş Kurallar hemen aktif hale geçer.',
    'LBL_ROUTING_FW' => 'İlet:',
    'LBL_ROUTING_LIST_TITLE' => 'Kurallar',
    'LBL_ROUTING_MATCH' => 'Eğer',
    'LBL_ROUTING_MATCH_2' => 'ait aşağıdaki kurallar gerçekleşti:',
    'LBL_NOTIFICATIONS' => 'Uyarılar',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'Bilgi',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'Metin İçeriği',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'Kimden',
    'LBL_ROUTING_MATCH_NAME' => 'Konu',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'Yüksek Öncelikli',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Normal Öncelikli',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Az Öncelikli',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'Kime',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'İçerir',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'İçermeyen',

    'LBL_ROUTING_NAME' => 'Kural İsmi',
    'LBL_ROUTING_NEW_NAME' => 'Yeni Kural',
    'LBL_ROUTING_ONE_MOMENT' => 'Bir dakika lütfen...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Ardından orijinal mesaj gelir.',
    'LBL_ROUTING_RE' => 'CVP:',
    'LBL_ROUTING_SAVING_RULE' => 'Kural Kaydediliyor',
    'LBL_ROUTING_SUB_DESC' => 'İşaretlenmiş kurallar etkindir. Değiştirmek için ismine tıklayınız.',
    'LBL_ROUTING_TO' => 'kadar',
    'LBL_ROUTING_TO_ADDRESS' => 'Kime adresi',
    'LBL_ROUTING_WITH_TEMPLATE' => 'Şablon ile',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'Kayıt halihazırda Ofis Telefonu ve Adres alanları için değer içermektedir. Seçmiş olduğunuz Müşteri kaydını aşağıdaki telefon,+E8762 adres bilgileriyle ezmek için, "Tamam" butonuna basınız. Şu anki değerleri korumak için, "İptal" butonuna basınız.',
    'LBL_DROP_HERE' => 'Buraya bırak',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'Değiştir',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Gmail&#153; Varsayılan Ayarları İle Doldur',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'İsim',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Giden Posta Sunucusu',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'Mesaj Aktarım Servisi',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'SMTP Kimlik Doğrulaması Kullanılsın mı?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP Şifresi',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP Portu',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP Sunucusu',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'Bağlanırken SSL kullan',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP Kullanıcı İsmi',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Varsayılan',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Dikkat: Giden e-posta hesabına ait kullanıcı ismi ve şifresi eksik.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP Kullanıcı İsmi gerekli',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP Şifresi gerekli',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'Posta Hesabı Yönetimi',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'Posta Sunucusu Protokolü POP3 bir sonraki versiyonda desteklenmeyecek. Yalnızca IMAP desteklenecek.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'E-posta hesabından gelen e-postaları görüntüleyebilmek için E-posta hesaplarını ayarlayın.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Posta Hesaplarındaki giden e-posta için kullanmak amacıyla SMTP posta sunucu bilgilerini temin ediniz.',
    'LBL_EMAIL_ADD' => 'E-Posta Ekle',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Tamam',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Temizle',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'Kime:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Bilgi:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'GizliBilgi:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'Kime/CC/Gizli',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'Yeni Liste',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'E-Posta Adresi',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Yalnızca kontak değişikliği şu anda desteklenmektedir.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filtre',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'İlk İsim/Hesap İsmi',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Soyisim',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'Kontaklarım',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'Posta Listelerim',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'İsim',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'Adres Bulunamadı',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Kaydet & Adres Defterine Ekle',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Ara',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Adres Defteri Girişlerini Seç',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Adres Defteri',
    'LBL_EMAIL_REPORTS_TITLE' => 'Raporlar',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'Uyarı! Silmeye çalıştığınız giden hesabı mevcuttaki bir gelen hesabı ile ortaktır. Devam etmek istediğinizden emin misiniz?',
    'LBL_EMAIL_ADDRESSES' => 'E-Posta',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'E-Posta Adresi',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'E-Posta Adresleri',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Sugar İçine Aktar',
    'LBL_EMAIL_ASSIGNMENT' => 'Atama',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Ekle',
    'LBL_EMAIL_ATTACHMENT' => 'Ekle',
    'LBL_EMAIL_ATTACHMENTS' => 'Yerel Sistemden',
    'LBL_EMAIL_ATTACHMENTS2' => 'Sugar Dokümanlarından',
    'LBL_EMAIL_ATTACHMENTS3' => 'Şablon Ekleri',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'Dosya adı',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Doküman',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Gömülmüş',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'Eklenti yüklemesi başarısız oldu',
    'LBL_REMOVING_ATTACHMENT' => 'Eki Siliyor...',
    'LBL_EMAIL_BCC' => 'GizliBilgi',
    'LBL_EMAIL_CANCEL' => 'İptal',
    'LBL_EMAIL_CC' => 'Bilgi',
    'LBL_EMAIL_CHARSET' => 'Karakter Seti',
    'LBL_EMAIL_CHECK' => 'E-Posta Kontrol Et',
    'LBL_EMAIL_CHECKING_NEW' => 'Yeni E-Postaları Kontrol Ediyor',
    'LBL_EMAIL_CHECKING_DESC' => 'Yeni E-Postaları Kontrol Ediyor. <br><br>Posta hesabı için ilk kontrol ise biraz daha zaman alabilir.',
    'LBL_EMAIL_CLOSE' => 'Kapat',
    'LBL_EMAIL_COFFEE_BREAK' => 'Yeni E-Postaları Kontrol Ediyor. <br><br>Büyük posta hesapların işlenmesi uzun zaman alabilir.',
    'LBL_EMAIL_COMMON' => 'Ortak',

    'LBL_EMAIL_COMPOSE' => 'E-Posta',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Lütfen bu e-posta için alıcı(ları) girin.',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'İlişkili olarak',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'Mesaj içeriği boş. Yine de gönderilsin mi?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'Bu e-posta konu satırı içermiyor. Yine de gönderilsin mi?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(konu yok)',
    'LBL_EMAIL_COMPOSE_READ' => 'Oku & Yeni E-Posta Oluştur',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Posta Hesabından Gönder',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'Seçenekler',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Kime, Bilgi ve GizliBilgi alanları için geçerli e-posta adresi giriniz',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'Bu e-postayı dikkate alma?',
    'LBL_EMAIL_CONFIRM_DELETE' => 'Adres defterinizden bu girişler kaldırılsın mı?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'Bu imzayı silmeye emin misiniz?',

    'LBL_EMAIL_CREATE_NEW' => '--Kayıt Sırasında Oluştur--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Çoklu',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Boş',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Gönderen Tarafından Gönderim Tarihi',
    'LBL_EMAIL_DATE_RECEIVED' => 'Geliş Tarihi',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'Atanan Kullanıcı',
    'LBL_EMAIL_DATE_TODAY' => 'Bugün',
    'LBL_EMAIL_DATE_YESTERDAY' => 'Dün',
    'LBL_EMAIL_DD_TEXT' => 'E-Posta(lar) seçildi.',
    'LBL_EMAIL_DEFAULTS' => 'Varsayılanlar',
    'LBL_EMAIL_DELETE' => 'Sil',
    'LBL_EMAIL_DELETE_CONFIRM' => 'Seçili mesajlar silinsin mi?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'E-Posta başarı ile silindi.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'Mesajlar siliniyor',
    'LBL_EMAIL_DETAILS' => 'Detaylar',
    'LBL_EMAIL_DISPLAY_MSG' => 'E-Posta(ları) gösteriyor. Toplam {2} adetin {0} - {1} aralığı',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'E-Posta adresini(lerini) gösteriyor. Toplam {2} adetin {0} - {1} aralığı',

    'LBL_EMAIL_EDIT_CONTACT' => 'Kontak Değiştir',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Kontaklar ile çalışırken sadece birincil adres kullanılır.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'Posta Listesi Değiştir',

    'LBL_EMAIL_EMPTYING_TRASH' => 'Çöp Kutusu Boşaltılıyor',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'Gönderim İçin Kullanılan Sunucu Siliniyor',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'Ön Bellek Dosyaları Temizleniyor',
    'LBL_EMAIL_EMPTY_MSG' => 'Gösterilecek e-posta yok.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'Gösterilecek e-posta adresleri yok.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'Dizin ismi tekil olmalıdır ve boşluk olamaz. Lütfen tekrar deneyin.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'Dizin silinemiyor. Dizin veya alt dizini ilişkilendirilmiş bir posta kutusuna sahip.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'Amaçlanan dizini içerikten bulamadı.  Tekrar deneyin.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Lütfen ayarlarınızı kontrol edin.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Soyisim girdiğinizden emin olun.',
    'LBL_EMAIL_ERROR_DESC' => 'Tespit edilen hata:',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'Bu bölüme erişim izniniz yok. İzin için lütfen site yöneticiniz ile temasa geçin.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugar Dosya isimleri tekil olmalıdır.',
    'LBL_EMAIL_ERROR_EMPTY' => 'Lütfen arama kriteri giriniz.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'Bir hata oluştu',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'Bu isimli e-posta listesi zaten mevcut',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Mesaj Sunucudan Silindi',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'Mesaj Sunucudan Silindi veya başka bir dizine taşındı',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'Posta Sunucusuna bağlantı hata aldı. Lütfen Sistem Yöneticisi ile görüşünüz',
    'LBL_EMAIL_ERROR_MOVE' => 'E-Posta, sunucular arasında taşınıyor ve/veya posta hesabı şu anda desteklenmiyor.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'Taşıma hatası',
    'LBL_EMAIL_ERROR_NAME' => 'Bir isim gereklidir.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'Gönderen Adres zorunlu.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'Lütfen bir dosya sağlayın.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'IMAP dizin isim değişikliği şu anda desteklenmiyor.',
    'LBL_EMAIL_ERROR_SERVER' => 'Bir Posta Sunucusu adresi gerekiyor.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'Posta hesabı kaydedilmemiş olabilir.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'Posta Sunucusu ile iletişim sırasında bir hata oluştu.',
    'LBL_EMAIL_ERROR_USER' => 'Bağlantı ismi gerekli.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'Şifre gerekli.',
    'LBL_EMAIL_ERROR_PORT' => 'Posta Sunucusu Portu gerekli.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'Sunucu Protokolü gerekli.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'İzlenen Dizin gerekli.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'Silinenler Dizini gerekli.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'Bu bilgi mevcut değildir',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'Giden posta sunucusu belirlenmemiştir.',
    'LBL_EMAIL_FOLDERS' => 'Klasörler',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'Taşı',
    'LBL_EMAIL_FOLDERS_ADD' => 'Ekle',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Yeni Dizin Ekle',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Dizin İsmini Değiştir',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Kaydet',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Bu dizini ekle:',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'Bu dizin değiştirilemez',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'Bu dizini silmek istediğinizden emin misiniz?\nBu işlem geri döndürülemez.\nDizin silme bütün alt dizilere de uygulanacak.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'Yeni Dizin İsmi',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Lütfen bu aksiyonu yerine getirmeden önce dizin seçiniz.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'Sugar Dizin Yönetimi',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Grup Kullanıyor',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'Takıma Atanan',
    'LBL_EMAIL_FORWARD' => 'İlet',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => 'Toplam [[total]] e-postanın [[count]] adedini İndirdi',
    'LBL_EMAIL_FOUND' => 'Bulundu',
    'LBL_EMAIL_FROM' => 'Kimden',
    'LBL_EMAIL_GROUP' => 'grup',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'Grup',
    'LBL_EMAIL_HOME_FOLDER' => 'Ana Sayfa',
    'LBL_EMAIL_HTML_RTF' => 'HTML Gönder',
    'LBL_EMAIL_IE_DELETE' => 'Posta Hesabı Siliniyor',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'İmza siliniyor',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'Bu posta hesabını silmek istediğinizden emin misiniz?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Silme başarı ile gerçekleşti.',
    'LBL_EMAIL_IE_SAVE' => 'Posta hesabı bilgisi kaydediliyor',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'E-Posta Verilerini Yükle',
    'LBL_EMAIL_IMPORT_EMAIL' => 'Sugar İçine Aktar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'Veri Yükleme Ayarları',
    'LBL_EMAIL_INVALID' => 'Geçersiz',
    'LBL_EMAIL_LINK_RECORD' => 'Buraya Tıklayın',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'Postalama Listesini Yeniden İsimlendir',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'Bu postalama listesi için yeni bir isim giriniz',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'Postalama listesinden bu girişleri kaldırmak mı istiyorsunuz?',
    'LBL_EMAIL_LOADING' => 'Yüklüyor...',
    'LBL_EMAIL_MARK' => 'İşaretle',
    'LBL_EMAIL_MARK_FLAGGED' => 'İşaretlendi',
    'LBL_EMAIL_MARK_READ' => 'Okundu',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'İşaretlenmedi',
    'LBL_EMAIL_MARK_UNREAD' => 'Okunmadı',
    'LBL_EMAIL_ASSIGN_TO' => 'Atandı',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'Dizin oluştur',
    'LBL_EMAIL_MENU_COMPOSE' => 'Oluştur',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Dizin Sil',
    'LBL_EMAIL_MENU_EDIT' => 'Değiştir',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Silinenleri Boşalt',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Senkronize',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Ön Bellek dosyalarını temizle',
    'LBL_EMAIL_MENU_REMOVE' => 'Sil',
    'LBL_EMAIL_MENU_RENAME' => 'Yeniden İsimlendir',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Dizin İsmini Değiştir',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Dizini Yeniden Adlandırıyor',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Bu işlemi tekrar etmeden önce lütfen bir seçim yapın.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Dizin oluştur (uzak veya Sugar sisteminde)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'Bu e-posta(ları) SugarCRM sistemine arşivle',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'Seçili Posta Listelerine E-Posta Gönder',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'Bu Kontağa E-Posta Gönder',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Kontağı Kaldır',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'Bu E-Posta(ları) sil',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Bir Dizin Sil (uzak veya Sugar sisteminde)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Kontak Değiştir',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Posta Listesi Değiştir',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Bütün Posta Kutunuzdaki Silinmiş dizinlerini temizler',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'E-Posta(ları) İşaretlenmiş olarak işaretle',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'E-Posta(ları) Okunmuş olarak işaretle',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'E-Posta(ları) İşaretlenmemiş olarak işaretle',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'E-Posta(ları) Okunmamış olarak işaretle',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Posta Listelerini Siler',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Bir Dizinin İsmini Değiştir (uzak veya Sugar sisteminde)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'Bu E-Postaları Yanıtlandır',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'E-Postaların Tüm Alıcılarına Yanıt Gönder',

    'LBL_EMAIL_MESSAGES' => 'mesajlar',

    'LBL_EMAIL_ML_NAME' => 'Liste İsmi',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'Seçilmiş Liste Adresleri',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'Mevcut Liste Adresleri',

    'LBL_EMAIL_MULTISELECT' => 'Birden fazla seçmek için <b>Ctrl-Tıkla</b><br />(Mac kullanıcıları <b>CMD-Tıkla</b> kullanın)',

    'LBL_EMAIL_NO' => 'Hayır',
    'LBL_EMAIL_NOT_SENT' => 'Sistem talebinizi yerine getiremiyor. Lütfen sistem yöneticisine başvurun.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'Could not insert in users_password_link.',

    'LBL_EMAIL_OK' => 'Tamam',
    'LBL_EMAIL_ONE_MOMENT' => 'Bir dakika lütfen...',
    'LBL_EMAIL_OPEN_ALL' => 'Birden Fazla Mesaj Aç',
    'LBL_EMAIL_OPTIONS' => 'Seçenekler',
    'LBL_EMAIL_QUICK_COMPOSE' => 'Hızlı E-Posta Oluştur',
    'LBL_EMAIL_OPT_OUT' => 'Liste Dışı',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Listeden Çıkmış ve Geçersiz',
    'LBL_EMAIL_PAGE_AFTER' => '{0} adetin',
    'LBL_EMAIL_PAGE_BEFORE' => 'Sayfa',
    'LBL_EMAIL_PERFORMING_TASK' => 'Adımı Gerçekleştiriyor',
    'LBL_EMAIL_PRIMARY' => 'Birincil',
    'LBL_EMAIL_PRINT' => 'Yazdır',

    'LBL_EMAIL_QC_BUGS' => 'Hata',
    'LBL_EMAIL_QC_CASES' => 'Talep',
    'LBL_EMAIL_QC_LEADS' => 'Potansiyel',
    'LBL_EMAIL_QC_CONTACTS' => 'Kontak',
    'LBL_EMAIL_QC_TASKS' => 'Görev',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'Fırsat',
    'LBL_EMAIL_QUICK_CREATE' => 'Hızlı E-Posta Oluştur',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'Dizinleri Tekrar Oluşturuyor',
    'LBL_EMAIL_RELATE_TO' => 'İlişki kur',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'İlişkileri Görüntüle',
    'LBL_EMAIL_RECORD' => 'E-Posta Kaydı',
    'LBL_EMAIL_REMOVE' => 'Sil',
    'LBL_EMAIL_REPLY' => 'Yanıtla',
    'LBL_EMAIL_REPLY_ALL' => 'Tümünü Yanıtla',
    'LBL_EMAIL_REPLY_TO' => 'Yanıt',
    'LBL_EMAIL_RETRIEVING_LIST' => 'E-Posta Listesi Getiriliyor',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Mesaj Getiriliyor',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'E-Posta Kaydını Getiriyor',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Lütfen yalnızca bir e-posta seçiniz',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'Bir önceki modüle dönmek istiyor musunuz?',
    'LBL_EMAIL_REVERT' => 'Geri Al',
    'LBL_EMAIL_RELATE_EMAIL' => 'E-Posta İlişkilendir',

    'LBL_EMAIL_RULES_TITLE' => 'Kural Yönetimi',

    'LBL_EMAIL_SAVE' => 'Kaydet',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'Kaydet & Yanıtla',
    'LBL_EMAIL_SAVE_DRAFT' => 'Taslak Olarak Kaydet',

    'LBL_EMAIL_SEARCHING' => 'Arama Başlatıyor',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'Gelişmiş Arama',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'Başlangıç Tarihi',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Bitiş Tarihi',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'E-Posta İçi Metin',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'Arama Kriterinizle Eşleşen Kayıt Bulunamadı.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Arama Sonuçları',
    'LBL_EMAIL_SEARCH_TITLE' => 'Basit Arama',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'E-Posta Hesabı Arama',

    'LBL_EMAIL_SELECT' => 'Seç',

    'LBL_EMAIL_SEND' => 'Gönder',
    'LBL_EMAIL_SENDING_EMAIL' => 'E-Posta Gönderiliyor',

    'LBL_EMAIL_SETTINGS' => 'Ayarlar',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 Satır',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 Kolon',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'Yerleşim Stili',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'Posta Hesapları',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Formu Temizle',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'Görüntülemek İçin E-Posta Verilerini Yükle',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Yeni E-Posta Kontrol Et',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Ön İzleme Panelini Kullan',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Açılır Pencere Kullan',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'Sayfa başına e-posta sayısı',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'Posta Hesabı Değiştir',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'Dizinler',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'Kimden Adresi',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'Test Bildirisi için E-Posta Adresi:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'E-posta Adresine',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'Kimden İsmi',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Adrese Cevap ver',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Tam Ekran',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Bütün Posta Hesaplarını Senkronize Et',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'Temin edilen giden posta ayarlarını kullanarak bir e-posta belirlenen e-posta adresine gönderildi.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Bu aksiyon posta hesaplarını ve içeriklerini senkronize edecek.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'Tam Senkronizasyon İstiyor musunuz?\nBüyük posta hesapları birkaç dakika alabilir.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Birden fazla dizin seçmek için Shift tuşuna veya Ctrl tuşuna basınız.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'Genel',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Mevcut Grup Dizinleri',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Grup Dizinleri Oluştur',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Grup Dizinlerini Kaydediyor',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Grup Dizinini Getiriyor',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Grup Dizini Değiştir',

    'LBL_EMAIL_SETTINGS_NAME' => 'İsim',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Bu ayarların aktif hale gelmesi için sayfanın yeniden yüklenmesi gerekebilir.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'Posta Hesabını Getiriyor',
    'LBL_EMAIL_SETTINGS_RULES' => 'Kurallar',
    'LBL_EMAIL_SETTINGS_SAVED' => 'Ayarlar saklandı.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'Yeni ayarların etkisini görmek için sayfayı yüklemeniz gerekmektedir.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'Düz Metin Olarak E-Posta Gönder',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Aktif',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'Sayfa Başına E-Posta Sayısı',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'Sekmeleri alt kısma yerleştir',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Sayfa Düzeni Ayarları',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Tercihler',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Detaylı Gösterim',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Mevcut Kullanıcı Dizinleri',
    'LBL_EMAIL_ERROR_PREPEND' => 'Hata:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'Kullandığınız posta hesabı için seçilmiş posta sunucusu geçersizdir. Ayarları kontrol ediniz veya posta hesabınız için farklı bir posta sunucusu seçiniz.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'Bir giden posta sunucusu e-posta göndermek için yapılandırılmamıştır. Lütfen giden mesaj sunucusunu yapılandırın veya Ayarlar&#39;da kullandığınız posta hesabı için bir giden posta sunucusu seçiniz.',
    'LBL_EMAIL_SHOW_READ' => 'Tümünü Göster',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Sadece okunmamışları göster',
    'LBL_EMAIL_SIGNATURES' => 'İmzalar',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'İmza Oluştur',
    'LBL_EMAIL_SIGNATURE_NAME' => 'İmza İsmi',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'İmza İçeriği',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Google Daha Az-Güvenli Uygulamalar',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! E-Posta',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'Diğer',
    'LBL_EMAIL_AUTHORIZE' => 'Yetkilendir',
    'LBL_EMAIL_AUTHORIZED' => 'Yetkilendirildi',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'Yetkilendirilmedi',
    'LBL_EMAIL_AUTH_WARNING' => 'Yönetici, siz bu hesabı düzenlemeden önce {0} Konnektörü Yönetici > Konnektörler üzerinden yapılandırmalıdır. Daha fazla bilgi için {1} belgeye bakın.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'Bağlayıcı bilgiler alınırken hata oluştu',
    'LBL_EMAIL_AUTH_FAILURE' => 'Yetkilendirme hatası.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'Lütfen kaydetmeden önce hesabı yetkilendirin.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'Lütfen test etmeden önce hesabı yatkilendirin.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'Hesap Yetkilendirilmedi',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Uzaktaki Dizinler ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugar Dizinleri ]',
    'LBL_EMAIL_SUBJECT' => 'Konu',
    'LBL_EMAIL_SUCCESS' => 'Başarılı',
    'LBL_EMAIL_SUGAR_FOLDER' => 'SugarDizini',
    'LBL_EMAIL_TEAMS' => 'Takımlara Ata',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'E-Posta Şablon içeriği boş',
    'LBL_EMAIL_TEMPLATES' => 'Şablonlar',
    'LBL_EMAIL_TEXT_FIRST' => 'İlk Sayfa',
    'LBL_EMAIL_TEXT_PREV' => 'Önceki Sayfa',
    'LBL_EMAIL_TEXT_NEXT' => 'Sonraki sayfa',
    'LBL_EMAIL_TEXT_LAST' => 'Son Sayfa',
    'LBL_EMAIL_TEXT_REFRESH' => 'Yenile',
    'LBL_EMAIL_TO' => 'Kime',
    'LBL_EMAIL_TOGGLE_LIST' => 'Listeyi Aç/Kapa',
    'LBL_EMAIL_VIEW' => 'Göster',
    'LBL_EMAIL_VIEWS' => 'Görünümler',
    'LBL_EMAIL_VIEW_HEADERS' => 'Başlıkları Göster',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'Yazdırılabilir Hali',
    'LBL_EMAIL_VIEW_RAW' => 'İşlenmemiş E-Posta Göster',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'POP3 ile kullanıldığında, bu özellik desteklenmez.',
    'LBL_DEFAULT_LINK_TEXT' => 'Varsayılan link metni.',
    'LBL_EMAIL_YES' => 'Evet',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Test E-postası Gönder',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Gönderilen E-posta&#39;yı Test Et',


    'LBL_EMAIL_MESSAGE_NO' => 'Mesaj No',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'Veri Yükleme Başarılı',
    'LBL_EMAIL_IMPORT_FAIL' => 'Veri Yükleme Başarısız, mesaj zaten yüklenmiş veya sunucudan silinmiş olabilir',

    'LBL_EMAILS_FROM' => 'E-postalar Gönderildi',
    'LBL_EMAILS_RECEIVED' => 'E-postalar Alındı',
    'LBL_EMAIL_ADDRESSES_USED' => 'E-postalarda kullanılan E-posta Adresleri',
    'LBL_EMAIL_ADDRESS' => 'E-Posta Adresi',
    'LBL_FROM' => 'Gönderen',
    'LBL_TO' => 'Alıcı',
    'LBL_CC' => 'Bilgi',
    'LBL_BCC' => 'Gizli Bilgi',

    'LBL_START_DATE' => 'Başlangıç Tarihi',
    'LBL_END_DATE' => 'Bitiş Tarihi',
    'LBL_START' => 'Başlat',
    'LBL_END' => 'Bitir',
    'LBL_DATE_LINKED' => 'Tarih Bağlantılı',

    'LBL_LINK_NONE' => 'Yok',
    'LBL_LINK_ALL' => 'Hepsi',
    'LBL_LINK_RECORDS' => 'Kayıtlar',
    'LBL_LINK_SELECT' => 'Seç',
    'LBL_LINK_ACTIONS' => 'Aksiyonlar',
    'LBL_LINK_MORE' => 'Daha fazla',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'Onayla',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => '#module# kapatmak istiyor musunuz?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'Bu mesajı daha sonra gösterme:',
    'LBL_INVALID_FILE_EXTENSION' => 'Geçersiz Dosya Uzantısı',
    'LBL_LIST_TEAM' => 'Takım',
    'LBL_TEAM' => 'Takım:',
    'LBL_TEAMS' => 'Takımlar',
    'LBL_TEAM_SET_ID' => 'Takım Küme ID',
    'LBL_TEAM_SET_SELECTED_ID' => 'Seçili Takım Seti Kimliği',
    'LBL_TEAM_SET_SELECTED' => 'Seçili',
    'LBL_TEAM_SET_ENABLE' => 'Ek izinleri etkinleştirin',
    'LBL_TEAM_SET_DISABLE' => 'Ek izinleri devre dışı bırakın',
    'LBL_TEAM_SET' => 'Takım Kümesi',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'Seçili Takım',
    'LBL_SEARCH_UNAVAILABLE' => 'Arama çalışmıyor, daha sonra tekrar deneyin.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'Birincil Takım belirtilmedi',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => '[{2}] ID&#39;li modül için ID&#39;si [{0}] olan birincil takımı silme sırasında hata',
    'LBL_TEAM_ADD' => 'Takım&nbsp;Ekle',
    'LBL_TEAM_REMOVE' => 'Takımı Kaldır',
    'LBL_TEAM_PRIMARY' => 'Birincil Takım Olarak Ayarla',

    'LBL_CLOSE_BUTTON_LABEL' => 'Kapat',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}}, {{status}} olarak işaretlendi.',

    'LBL_FOCUS' => 'Odakla',

    'LBL_QUERY_VALID' => 'Geçerli',
    'LBL_QUERY_ERROR' => 'Hata!',
    'LBL_QUERY_CHILD' => 'Geçerli Alt-Sorgu',
    'ERROR_EXAMINE_MSG' => 'Aşağıdaki hata mesajını inceleyin:',
    'NO_QUERY_SELECTED' => 'Seçtiğiniz veri formatı bir sorgu içermiyor. Bu veri formatı için özel bir sorgu seçin.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'Bir hata oluştu:',
    'ERR_AJAX_LOAD_FAILURE' => 'Talebiniz işlenirken bir hata oluştu, daha sonra tekrar deneyin.',
    'ERR_AJAX_LOAD_FOOTER' => 'Bu hata devam ederse, yöneticinizden bu modül için Ajax devre dışı bırakmasını isteyin',
    'ERR_CREATING_FIELDS' => 'Ek detay alanlarını doldururken hata:',
    'ERR_CREATING_TABLE' => 'Tablo oluştururken hata:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'Ondalık ayıracı karakteri Binlik ayıracı ile aynı olamaz.

  Lütfen değerleri değiştiriniz.',
    'ERR_DELETE_RECORD' => 'Kontağı silmek için bir kayıt no&#39;su belirtilmesi zorunludur.',
    'ERR_EXPORT_DISABLED' => 'Dışarı Aktarmayı Etkisizleştirildi.',
    'ERR_EXPORT_TYPE' => 'Dışarı Aktarmada Hata',
    'ERR_REPORTS_DISABLED_EXPORT' => 'Raporları Dışa Aktarma devre dışı',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'Yalnızca yönetici kullanıcılar dışa aktarabilir',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'Rapor, Dışa Aktarma erişimi olmayan modülleri kullanır',
    'ERR_REPORTS_EXPORT_OWNER' => 'Rapor, Sahip Dışa Aktarma erişimi olan modülleri kullanır',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'Rapor, Liste kısıtlı erişimi olan modülleri kullanır',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'Rapor, Görünüm kısıtlı erişime sahip modülleri kullanır',
    'ERR_REPORTS_ACCESS_DISABLED' => 'Rapor kısıtlı erişime sahip modülleri kullanır',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'Rapor kısıtlı erişime sahip alanları kullanır',
    'ERR_INVALID_AMOUNT' => 'Lütfen geçerli bir tutar girin.',
    'ERR_INVALID_DATE_FORMAT' => 'Tarih formatı bu şekilde olmak zorundadır:',
    'ERR_INVALID_DATE' => 'Lütfen geçerli bir tarih girin.',
    'ERR_INVALID_DAY' => 'Lütfen geçerli bir gün girin.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'geçersiz e-posta.',
    'ERR_INVALID_FILE_REFERENCE' => 'Geçersiz Dosya Referansı',
    'ERR_INVALID_HOUR' => 'Lütfen geçerli bir saat girin.',
    'ERR_INVALID_MONTH' => 'Lütfen geçerli bir ay girin.',
    'ERR_INVALID_TIME' => 'Lütfen geçerli bir zaman girin.',
    'ERR_INVALID_YEAR' => 'Lütfen geçerli bir 4 basamaklı yıl girin.',
    'ERR_NEED_ACTIVE_SESSION' => 'İçeriğin dışarı aktarılabilmesi için aktif bir oturum gerekmektedir.',
    'ERR_NO_HEADER_ID' => 'Bu özellik bu temada mevcut değil.',
    'ERR_NOT_ADMIN' => 'Sistem Yönetimi Fonksiyonlarına izin verilmemiş erişim.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'Şifre Yönetimi, sadece <a href="%s" target="_blank">SugarCloud ayarlarında</a> kullanılabilir.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'Salt okunur dosyalarda değişiklik yapmak istiyorsanız lütfen Sugar yöneticinizle iletişime geçin.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'Salt okunu alanlarda değişiklikler yapmak için lütfen <a href="{0}" target="_blank">SugarCloud Ayarları</a> ögesine gidin.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'Doldurulması zorunlu alanlar eksik:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'Zorunlu alanda geçersiz değer:',
    'ERR_INVALID_VALUE' => 'Geçersiz Değer:',
    'ERR_NO_SUCH_FILE' => 'Dosya sistemde mevcut değil',
    'ERR_NO_SINGLE_QUOTE' => 'Tek tırnak işareti bu amaçla kullanılamaz:',
    'ERR_NOTHING_SELECTED' => 'Lütfen başlamadan önce bir seçim yapınız.',
    'ERR_OPPORTUNITY_NAME_DUPE' => '%s isminde bir Fırsat zaten var.  Lütfen aşağıda farklı bir isim girin.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'Fırsat ismi girilmemiş. Lütfen aşağıda bir isim girin.',
    'ERR_QUOTE_CONVERTED' => 'Bu Teklif zaten Fırsata dönüştürülmüş.',
    'ERR_POTENTIAL_SEGFAULT' => 'Potansiyel Apache Segmentation Fault hatası fark edildi.  Lütfen Sistem Yöneticisine problemi bildirin ve SugarCRM firmasına iletmesini isteyin.',
    'ERR_SELF_REPORTING' => 'Kullanıcı kendi kendisine raporlayamaz.',
    'ERR_SINGLE_QUOTE' => 'Bu alan için tek tırnak işaretinin kullanımı desteklememektedir.  Lütfen değeri değiştirin.',
    'ERR_SQS_NO_MATCH_FIELD' => 'Alan için eşleşme yok:',
    'ERR_SQS_NO_MATCH' => 'Eşleşme yok',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Lütfen Meta-Data tanımı için displayParams parametresinde &#39;anahtar&#39; indeksini belirtin',
    'ERR_EXISTING_PORTAL_USERNAME' => 'Hata: Portal İsmi başka bir kontağa zaten atanmış.',
    'ERR_PORTAL_NAME_CHECK' => 'Portal Kullanıcısının tekli olduğu kontrol edilemedi',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'Kesinlik değeri ile alan değeri uyumlu değil',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'Harici hesaba kaydetmeye çalışırken hata oluştu.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'Yükleme yaparken hata oluştu. Lütfen karşıya yüklemekte olduğunuz dosyanın boş olmadığından emin olun.',
    'ERR_NO_DB' => 'Veritabanına bağlanılamadı. Detaylar için lütfen sugarcrm.log dosyasına başvurun.',
    'ERR_DB_FAIL' => 'Veritabanı hatası. Detaylar için lütfen sugarcrm.log dosyasına başvurun.',
    'ERR_EXTERNAL_API_403' => 'İzin Verilmedi. Dosya tipi desteklenmiyor.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth Erişim Anahtarı eksik.',
    'ERR_DB_VERSION' => 'Sugar CRM {0} dosyaları yalnızca Sugar CRM {1} Veritabanı ile kullanılabilir.',
    'ERR_DB_QUERY' => '{0}: Sorgu başarısız: {1}',
    'ERR_UW_RETIRED' => 'Yükseltme Sihirbazı bu sürümde mevcut değil.',
    'ERR_NOT_CLOUD_INSTANCE' => 'Sugar&#39;ın bu kurulumu, bir SugarCloud kurlumu değil veya SugarCloud Insights için yapılandırılmamış.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => '{modulename} oluşturmak için yetkili değilsiniz. Germekmesi halinde yöneticinize başvurun.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'Mevcut Kullanıcının {moduleName} yapılandırma ayarlarını değiştirmek için yetkisi bulunmamaktadır',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'Mevcut Kullanıcının {moduleName} yapılandırma ayarlarını değiştirmek için yetkisi bulunmamaktadır',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => '{moduleName} favori olarak işaretlemek için yetkiniz yok. Erişmeniz gerekiyorsa sistem yöneticiniz ile iletişime geçiniz.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => '{modulename} abone olmak için yetkiniz yok. Erişmeniz gerekiyorsa sistem yöneticiniz ile iletişime geçiniz.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'çalışma sayfası_kolonları_ilişkili_alanları veri yükünde bulunamadı',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'özet_kolonları dizi değil',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'özet_kolonları_ilişkili_alanları veri yükünde bulunamadı',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'alt bilgi_sütunları dizi değil',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'alt bilgi_sütunları_ilişkili_alanları veri yükünde bulunamadı',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'Talebiniz bilinmeyen bir hata nedeniyle başarısız oldu.',
    'EXCEPTION_FATAL_ERROR' => 'Talebiniz tamamlanamadı. Önemli bir hata oluştu. Daha fazla ayrıntı için günlüklerini denetleyin.',
    'EXCEPTION_NEED_LOGIN' => 'Bu eylemi gerçekleştirmek için giriş yapmalısınız.',
    'EXCEPTION_INVALID_TOKEN' => 'Kimlik doğrulama anahtarınız geçersiz.',
    'EXCEPTION_NOT_AUTHORIZED' => 'Bu eylemi gerçekleştirmek için yetkiniz yok. Erişim ihtiyacı halinde yöneticinize başvurun',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'Verileri görmek için yetkiniz yok. Erişmeniz gerekiyorsa sistem yöneticiniz ile iletişime geçiniz.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'Portal hesabınız aktif olmadığı için Portale erişemezsiniz. Eğer erişim ihtiyacınız varsa müşteri destek hizmetlerine başvurun.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'Portal doğru yapılandırılmamış. Yardım için Portal Yöneticiniz ile görüşün.',
    'EXCEPTION_NO_METHOD' => 'Talebiniz desteklenmiyor.Bu adres için HTTP metodu bulunamadı.',
    'EXCEPTION_NOT_FOUND' => 'Talep ettiğiniz kaynak bulunamadı. Talepte belirtilen adres için bir işleyici bulunamadı.',
    'EXCEPTION_MISSING_PARAMTER' => 'Talebinizde gerekli bir parametre eksikti.',
    'EXCEPTION_INVALID_PARAMETER' => 'Talebinizde bir parametre geçersiz.',
    'EXCEPTION_REQUEST_FAILURE' => 'Talebiniz tamamlanamadı.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'Metaverileriniz veya kullanıcı hash değeri sunucu ile eşleşmedi. Lütfen Metaverilerinizi tekrar senkronize edin.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'Talebiniz işlemek için çok büyük.',
    'EXCEPTION_EDIT_CONFLICT' => 'Tutarsızlıkları düzeltin, kaydı lütfen tekrar yükleyin.',
    'EXCEPTION_METADATA_CONFLICT' => 'Metaveri uyumsuzluğu, lütfen metaverileri tekrar yükleyin.',
    'EXCEPTION_CLIENT_OUTDATED' => 'Yazılımınız güncel değil, yeniden bağlanmayı denemeden önce istemciyi güncelleyin.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'Bir bağlantı veya entegrasyon isteği, başarısız yanıt aldı.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM onarım modunda. Sadece yöneticiler giriş yapabilir. Ayrıntılar için sistem yöneticinize başvurun.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'Şu anda meşgul veya kullanılamaz durumda olduğundan sunucu isteğinizi devam ettiremiyor.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'Arama motoru geçici olarak kullanılamıyor.',
    'EXCEPTION_SEARCH_RUNTIME' => 'Bir arama motoru çalışma zamanı hatası oluştu. Lütfen Sistem Yöneticinize başvurun.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'Bir işlem tarafından kilitlenen alan düzenlenemez.',
    'EXCEPTION_MODULE_DISABLED' => 'This module is disabled for current user.',
    'EXCEPTION_FIELD_DISABLED' => 'This field is disabled for current user.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'Bu istemciye izin verilmiyor',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'Lisans türünüz için paket yükleme özelliği kullanılamaz',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'Genel arıza veya hata durumuyla karşılaşıldı. Bu hatanın nedeni, tanımlı API hatalarının dışında yer almaktadır.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'Talep sunulmuş olduğu gibi işlenememektedir veya yanıt ile ilgili bir problem bulunmaktadır. Bu genellikle önemli bir hata oluştuğunu gösterir ve problem uygulama log dosyasında bulunabilir.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'Kullanmış olduğunuz API, bu talep için uygun değil.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'Talep edilen bağlantı noktası otantikasyon gerektirmektedir ve talepte bulunan tüketici henüz otantike olmadı.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'Talep ile gönderilen otantikasyon anahtarı geçerli değil. Bu genellikle süresi geçmiş anahtardan kaynaklanmaktadır ancj anahtarın yanlış olması veya hatalı oluşmasından da kaynaklanabilir.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'Talepte bulunan istemcinin, istenen aksiyonu gerçekleştirmeye yetkisi olmadığını belirtir.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'Bağlanan kullanıcı ile ilişkili porta hesabı şu anda aktif değil. Müşteri hizmetleri tarafında aksiyon gerektirmektedir.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'Portal uygulamasının uygun şekilde konfigüre edilmediğini ve kullanılamayacağını gösterir. Bu, portal yöneticisi tarafından aksiyon gerektirmektedir.',
    'EXCEPTION_NO_METHOD_DESC' => 'Son nokta, yapılan HTTP talebini desteklememektedir. Bu örneğin GET talebine cevap verecek şekilde tanımlanmış bir son noktaya, POST talebinde bulunulması olabilir.',
    'EXCEPTION_NOT_FOUND_DESC' => 'Son nokta, bu talep için bir kaynak ayıramıyor veya bu talebi karşılayacak bir metodu bulunmuyor.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'Kayıt üzerinde eş zamanlı değişiklikler olabilir, ve şu anki değişiklik talebi, kaydın önceki değişikliğini etkileyebilir.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'Sunucudaki meta veri ile istemcideki meta verinin farklı olduğunu gösterir. Sistem ayarlarındaki bir değişiklik sonrasında, Stüdyo içinde modül değişikliği, yeni modül uyarlanması veya diğer değişiklikler olabilir.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'Talep, sunucu tarafından işlenmek için çok büyük.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'Talep ile ilgili parametrenin eksik olduğunu gösterir.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'Talep içinde gönderilen parametrenin geçersiz olduğunu gösterir.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'Talep başarısızlıkla sonuçlandı.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'API kullanan istemcinin tarihinin eski olduğunu, API daha fazla kullanılmadan önce güncellenmesi gerektiğini gösterir.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'Farklı bir servise, son noktaya veya URI adresine yapılan API çağrısı hata aldı veya sunucu tarafından işlenemiyor.',
    'EXCEPTION_MAINTENANCE_DESC' => 'API isteklerine cevap veren SugarCRM kurulumu bakım modunda. API erişimine yalnızca sistem yöneticileri için izin verilmektedir.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'Sunucunu meşgul, aşırı yüklü veya çökmüş olduğunu belirtir.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'Arama motoru arka ucu, bir bağlantı sorunu nedeniyle şu anda kullanılamıyor. Bağlantı ve yapılandırmayı Yönetici->arama->test&#39;te doğrulayın.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'SearchEngine içinde bir çalışma zamanı özel durumu oluştu. Daha fazla ayrıntı için sugarcrm.log&#39;a bakın.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'Devam eden bir işlem tarafından kilitlenen alan düzenlenemez.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s devam eden bir işlem tarafından kilitlendi ve düzenlenemez.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s devam eden bir işlem tarafından kilitlendi ve düzenlenemez.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'This module is disabled for current user.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'This field is disabled for current user.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'Bu istemciye izin verilmiyor',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'Sistemde aynı ismi taşıyan bir dosya daha var.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'Hata {0} tarihi için Zaman Aralığı Tanımsız',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'Bu Zaman Aralığı için zaten alt-aralıklar var',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'Alt Zaman Aralığının alt-aralıkları olamaz',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => '{0} tipinde herhangi bir zaman aralığı alınamıyor.',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'Mevcut ayarların aktif Zaman Aralıkları yok.',
    'LBL_CURRENT_TIMEPERIOD' => 'Şimdiki Zaman Aralığı',
    'LBL_PREVIOUS_TIMEPERIOD' => 'Önceki Zaman Aralığı',
    'LBL_NEXT_TIMEPERIOD' => 'Sonraki Zaman Aralığı',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'Önceki, Şimdiki, Sonraki',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'Kapanmış satış aşaması olan kayıtları silemezsiniz.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'Kapalı satış durumundaki kayıtları silemezsiniz.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'Seçilen kayıtlardan bir veya daha fazlası "Kazanılarak Kapandı" veya "Kaybedilerek Kapandı" değerlerini içerir ve silinemez.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'Seçilen kayıtlardan bir veya daha fazlası "Kazanılarak Kapandı" veya "Kaybedilerek Kapandı" değerlerini içermekte ve silinemez.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'Müşteri',
    'LBL_OLD_ACCOUNT_LINK' => 'Eski Müşteri',
    'LBL_ACCOUNTS' => 'Müşteriler',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Aktiviteler',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Özet Göster',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Özet Göster',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Ekle',
    'LBL_ADD_BUTTON' => 'Ekle',
    'LBL_ADD_DASHLET_BUTTON' => 'Dashlet Ekle',
    'LBL_ADD_DOCUMENT' => 'Belge Ekle',
    'LBL_REPLACE_BUTTON' => 'Değiştir',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Hedef Listeye Ekle',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Hedef Listeye Ekle',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Kapamak İçin Tıkla',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Kapat',
    'LBL_ADDITIONAL_DETAILS' => 'Ek Detaylar',
    'LBL_ADMIN' => 'Sistem Yöneticisi',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'Arşivle',
    'LBL_ASSIGNED_TO_USER' => 'Atanan Kullanıcı',
    'LBL_ASSIGNED_TO' => 'Atanan Kişi:',
    'LBL_BACK' => 'Geri',
    'LBL_BASE_RATE' => 'Temel Oran',
    'LBL_BILL_TO_ACCOUNT' => 'Müşteriye Faturala',
    'LBL_BILL_TO_CONTACT' => 'İlgiliye Faturala',
    'LBL_BILLING_ADDRESS' => 'Fatura Adresi',
    'LBL_QUICK_CREATE_TITLE' => 'Hızlı E-Posta Oluştur',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{{module}}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'Hatalar',
    'LBL_BY' => 'ile',
    'LBL_CALLS' => 'Aramalar',
    'LBL_CALL' => 'Tel.Araması',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Kuyruktaki Kampanya E-Postalarını Gönder',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Gönder',
    'LBL_CASE' => 'Talep',
    'LBL_CASES' => 'Talepler',
    'LBL_MESSAGE' => 'Mesaj',
    'LBL_MESSAGES' => 'Mesajlar',
    'LBL_ESCALATIONS' => 'Artışlar',
    'LBL_ESCALATION' => 'Artış',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign Zarfları',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign Zarfı',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'İmzalayan alıcıları seçin',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'Şifreyi Değiştir',
    'LBL_CHANGE_BUTTON_LABEL' => 'Değiştir',
    'LBL_CHANGE_BUTTON_TITLE' => 'Değiştir',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Tümünü Seç',
    'LBL_CITY' => 'Şehir',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Temizle',
    'LBL_CLEAR_BUTTON_TITLE' => 'Temizle',
    'LBL_CLEARALL' => 'Tümünü Temizle',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => 'Kapat',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'Pencereyi Kapat',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Tümünü Kapat',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Tümünü Kapat',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Kapat ve Yeni Oluştur',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Kapat ve Yeni Oluştur',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'Kayıt URL&#39;sini Kopyala',
    'LBL_OPEN_ITEMS' => 'Açık Öğeler:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'E-Posta Oluştur',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'E-Posta',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'E-Posta Oluştur',
    'LBL_SEARCH_DROPDOWN_YES' => 'Evet',
    'LBL_SEARCH_DROPDOWN_NO' => 'Hayır',
    'LBL_CONTACT_LIST' => 'Kontak Listesi',
    'LBL_CONTACT' => 'Kontak',
    'LBL_CONTACTS' => 'Kontaklar',
    'LBL_CONTRACTS' => 'Kontratlar',
    'LBL_COUNTRY' => 'Ülke:',
    'LBL_RESET_BUTTON_LABEL' => 'Sıfırla',
    'LBL_CREATE_BUTTON_LABEL' => 'Oluştur',
    'LBL_CREATED_BY_USER' => 'Oluşturan Kullanıcı',
    'LBL_CREATED_USER' => 'Oluşturan Kullanıcı',
    'LBL_CREATED_ID' => 'Oluşturan ID',
    'LBL_CREATED' => 'Oluşturan',
    'LBL_CREATE_NEW_TARGET_LIST' => 'Yeni hedef listesi oluşturun',
    'LBL_CURRENT_USER_FILTER' => 'Bana Ait Olanlar:',
    'LBL_CURRENCY' => 'Para Birimi:',
    'LBL_CURRENCIES' => 'Kurlar',
    'LBL_CURRENCY_NAME' => 'Para Birimi İsmi',
    'LBL_CURRENCY_SYMBOL' => 'Para Birimi Sembolü',
    'LBL_CURRENCY_RATE' => 'Taban Puan:',
    'LBL_CURRENCY_ID' => 'Para Birimi ID',
    'LBL_DOCUMENTS' => 'Dokümanlar',
    'LBL_DATE_ENTERED' => 'Oluşturulma Tarihi:',
    'LBL_DATE_MODIFIED' => 'Değiştirilme Tarihi:',
    'LBL_ACTIVITY_MODIFIED' => 'Değiştirildi',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'Genel Bakış Sekmesini Düzenleyin',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'Modül Sekmelerini Düzenleyin',
    'LBL_EDIT_BUTTON' => 'Değiştir',
    'LBL_DUPLICATE_BUTTON' => 'Aynı Kayıttan Oluştur',
    'LBL_DELETE_BUTTON' => 'Sil',
    'LBL_DELETE' => 'Sil',
    'LBL_DELETED' => 'Silindi',
    'LBL_DIRECT_REPORTS' => 'Doğrudan Raporlar',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Tamam',
    'LBL_DONE_BUTTON_TITLE' => 'Tamam',
    'LBL_DST_NEEDS_FIXIN' => 'Yaz Saati düzenlemesi uygulama için gereklidir. Lütfen Yönetici konsolunda bulunan <a href="index.php?module=Administration&action=DstFix">Onay</a> bağlantısına gidin ve Yaz Saati Düzenlemesini uygulayın.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Yeni olarak Değiştir',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Yeni olarak Değiştir',
    'LBL_EDIT_IN_NEW_TAB' => 'Yeni Sekmede Düzenle',
    'LBL_FAVORITES' => 'Favoriler',
    'LBL_FILTER' => 'Filtre',
    'LBL_DEFAULT_DATA_FILTER' => 'Varsayılan Veri Filtresi',
    'LBL_FILTER_MENU_BY' => 'Menü ile Filtrele',
    'LBL_FILTER_SELECT_FIELD' => 'Alan seçin...',
    'LBL_FILTER_SELECT_OPERATOR' => 'Operatör seçin...',
    'LBL_FILTER_CREATE_NEW' => 'Filtre Oluştur',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'Filtre Oluştur (Kaydedilmedi)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(Kaydedilmedi)',
    'LBL_FILTER_CREATE_FILTER' => 'Yeni filtre oluştur',
    'LBL_FILTER_CLOSE_FILTER' => 'Filtreyi kapat',
    'LBL_FILTER_EDIT_FILTER' => 'Filtreyi düzenle',
    'LBL_FILTER_ALL_RECORDS' => 'Tüm Kayıtlar',
    'TPL_FILTER_SAVE' => 'Başarılı bir şekilde filtre {{name}} oluşturuldu.',
    'LBL_FILTER_BETWEEN_FROM' => 'den',
    'LBL_FILTER_BETWEEN_TO' => 'e',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'Başlangıç Tarihi',
    'LBL_FILTER_DATEBETWEEN_TO' => 'Bitiş Tarihi',
    'LBL_FOLLOWING' => 'Takip Ediyor',
    'LBL_UNFOLLOW' => 'Takibi Bırak',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => '.vcf indir',
    'LBL_EMPTY_VCARD' => 'Lütfen bir vCard dosyası seçin',
    'LBL_IMAGE' => 'Resim',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard, bu modül tarafından ihtiyaç duyulan bütün alanları barındırmamaktadır.',
    'LBL_VCARD_ERROR_FILESIZE' => 'Yüklenen dosya HTML formunda belirtilen 30000 bayt boyut sınırını aşıyor.',
    'LBL_VCARD_ERROR_DEFAULT' => 'vCard dosyasının yüklenmesi sırasında hata oluştu.',
    'TPL_IMPORT_VCARD_FAILURE' => 'vCard kullanarak {{module}} oluşturma başarısız oldu',
    'LBL_IMPORT_VCARD' => 'vCard Verisini Yükle:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'vCard Verisini Yükle',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'vCard Verisini Yükle',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'Göster',
    'LBL_VIEW_BUTTON_TITLE' => 'Göster',
    'LBL_VIEW_BUTTON' => 'Göster',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'PDF olarak postala',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'PDF olarak postala',
    'LBL_EMAIL' => 'E-Posta',
    'LBL_EMAILS' => 'E-Postalar',
    'LBL_EMPLOYEES' => 'Çalışanlar',
    'LBL_ENTER_DATE' => 'Oluşturulma Tarihi',
    'LBL_EXPORT_ALL' => 'Tümünü Dışarı Aktar',
    'LBL_EXPORT' => 'Dışarı Aktar',
    'LBL_FAVORITES_FILTER' => 'Favorilerim:',
    'LBL_GLOBAL_SEARCH' => 'Global Arama',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'Global Arama Filtre Modülü',
    'LBL_GLOBAL_SEARCH_RUN' => 'Global Aramayı Çalıştır',
    'LBL_GO_BUTTON_LABEL' => 'Devam',
    'LBL_GS_HELP' => 'Bu aramada kullanılan modüldeki alanlar yukarıda gösterilmektedir. İşaretlenen metinler arama kriterlerinizle eşleşenlerdir.',
    'LBL_HIDE' => 'Gizle',
    'LBL_ID' => 'KİMLİK',
    'LBL_IMPORT' => 'Veri Yükle',
    'LBL_IMPORT_STARTED' => 'Veri Yükleme Başladı:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Özel bir ayraç belirtilmesi gerekir.',
    'LBL_LAST_VIEWED' => 'Son Görüntülenenler',
    'LBL_SELECTED_RECORDS' => 'Seçilen: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'Daha Az Göster',
    'LBL_SHOW_MORE' => 'Daha Fazla Göster',
    'LBL_SHOW_MORE_MODULE' => 'Daha Fazla {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'Daha günceller…',
    'LBL_SHOW_LESS_RECENTS' => 'Daha az günceller…',
    'LBL_SHOW_MORE_RESULTS' => 'Daha fazla arama sonuçları...',
    'TPL_SHOW_MORE_MODULE' => 'Daha fazlası: {{module}}…',
    'LBL_SHOW_MORE_GENERIC' => 'Daha fazla {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => 'Bugünün Aktiviteleri',
    'LBL_LEADS' => 'Potansiyeller',
    'LBL_LEAD' => 'Potansiyel',
    'LBL_QUOTES_BILL_TO' => 'Teklifler (Faturalama Yeri)',
    'LBL_LESS' => 'daha az',
    'LBL_CAMPAIGN' => 'Kampanya:',
    'LBL_CAMPAIGNS' => 'Kampanyalar',
    'LBL_CAMPAIGNLOG' => 'Kampanya Log',
    'LBL_CAMPAIGN_CONTACT' => 'Kampanyalar',
    'LBL_CAMPAIGN_ID' => 'Kampanya_ID',
    'LBL_THEME' => 'Tema:',
    'LBL_THEME_PICKER' => 'Sayfa Stili',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Uyarı: Internet Explorer 6 seçilen tema tarafından desteklenmektedir. Seçmek istediğinizden eminseniz Tamam butonuna , farklı tema seçmek için İptal butonuna basınız.',
    'LBL_FOUND_IN_RELEASE' => 'Bulunduğu Versiyon',
    'LBL_FIXED_IN_RELEASE' => 'Düzeltildiği Versiyon',
    'LBL_LIST_ACCOUNT_NAME' => 'Müşteri İsmi',
    'LBL_LIST_ASSIGNED_USER' => 'Kullanıcı',
    'LBL_LIST_CONTACT_NAME' => 'Kontak İsmi',
    'LBL_LIST_CONTACT_ROLE' => 'Kontak Rolü',
    'LBL_LIST_DATE_ENTERED' => 'Oluşturulma Tarihi',
    'LBL_LIST_EMAIL' => 'E-Posta',
    'LBL_LIST_NAME' => 'İsim',
    'LBL_LIST_OF' => '/',
    'LBL_LIST_PHONE' => 'Telefon',
    'LBL_LIST_RELATED_TO' => 'İlişkili',
    'LBL_LIST_USER_NAME' => 'Kullanıcı İsmi',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'Tüm listeyi güncellemek istediğinizden emin misiniz?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Lütfen işlem için en az bir kayıt seçin.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Lütfen işlem için en azından 2 kayıt seçiniz.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Lütfen devam etmek için 10 kayıttan daha az seçin.',
    'LBL_LISTVIEW_ALL' => 'Hepsi',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'Sütun 1&#39;i Dondur',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'Tüm çift kayıtlar',
    'LBL_LISTVIEW_NONE' => 'Tüm Seçimleri Kaldır',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Bu Sayfayı Seç',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Tümünü Seç',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Seçili Kayıtlar',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Seçilen: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'Tüm seçimleri temizle.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'Tüm kayıtları seç',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'Sonuç kümesinde {{num}} kayıtlardan daha vardır. Sen ilk {{num}} kayıtları seçtiniz.',
    'TPL_LISTVIEW_SELECTED' => 'Sonuç kümesindeki {{num}} kayıtlarını seçtiniz.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'Sonuç setinde 1 kayıt seçtiniz.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'Sonuç kümesindeki tüm {{num}} kayıtlarını seçtiniz.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'Bu görünümdeki tüm {{num}} kayıtlarını seçtiniz. Sonuç kümesinde {{link}}.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => '{{num}} / {{total}} güncelleniyor',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(yaklaşık {{time}} {{unit}} kaldı)',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'Toplu Güncelleme başarısız oldu. Yeniden deneniyor ({{num}} / {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'Toplu güncelleme tamamlanmadı.  {{num}} kayıt değişmedi.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'Toplu güncelleme tamamlanmadı.  {{num}} kayıt değişmedi.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => 'Yetki veya hatalar nedeniyle {{remain}} kaydı/kayıtları göz ardı edildi.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} adet kayıt başarıyla güncellendi.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} Toplu Güncelle',
    'TPL_MASSDELETE_PROGRESS_STATUS' => '{{num}} / {{total}} siliniyor',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(yaklaşık {{time}} {{unit}} kaldı)',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'Toplu Silme başarısız oldu. Yeniden deneniyor ({{num}} / {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'Toplu silme tamamlanmadı. {{num}} kayıt kaldı.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'Toplu silme tamamlanmadı. {{num}} kayıt kaldı.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} adet kayıt başarıyla silindi.',
    'TPL_MASSDELETE_TITLE' => '{{module}} Toplu Sil',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => '{{num}} / {{total}} ekleniyor.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(yaklaşık {{time}} {{unit}} kaldı)',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'Hedef Listesine Toplu Ekleme başarısız oldu. Yeniden deneniyor ({{num}} / {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'Hedef Listesine Toplu Ekleme tamamlanmadı. {{num}} kayıt eklenmedi.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'Hedef Listesine Toplu Ekleme tamamlanmadı. {{num}} kayıt eklenmedi.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} kayıt başarıyla eklendi.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} Hedef Listesine Toplu olarak Ekle',
    'TPL_MASSLINK_PROGRESS_STATUS' => '{{num}} / {{total}} bağlanılıyor.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(yaklaşık kalan süre: {{time}} {{unit}})',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'Toplu İlişkilendirme başarısız oldu. Yeni bir deneme başlatılıyor ({{num}} / {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'Toplu İlişkilendirme tamamlanmadı. {{num}} kayıt eklenmedi.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'Toplu İlişkilendirme tamamlanmadı. {{num}} kayıt eklenmedi.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} adet kayıt başarıyla ilişkilendirildi.',
    'TPL_MASSLINK_TITLE' => '{{module}} Toplu İlişkilendirme',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'Seç',
    'LBL_LISTVIEW_ACTIONS' => 'Aksiyonlar',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'Bu sayfadaki tüm kayıtları sil',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'Bu sayfadaki tüm kayıtların seçimini kaldır',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} / {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '{{num}} Yükleniyor...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'Toplam için tıklayın',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => '/',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'Sayfa sayısını al',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'David',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Livingstone',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Dr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Program Geliştirme Uzmanı',
    'LBL_LOGIN_TO_ACCESS' => 'Lütfen bu alana erişim için oturum açınız.',
    'LBL_LOGOUT' => 'Çıkış',
    'LBL_FINISH_IMPERSONATING' => 'Temsil Etmeyi Sonlandırın',
    'LBL_RESET_MFA' => 'Çok Faktörlü Kimlik Doğrulamayı Sıfırlayın',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, şu anda {{user}} kullanıcısını temsil ediyorsunuz.',
    'LBL_PROFILE' => 'Profil',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'Posta Birleştir',
    'LBL_MASS_UPDATE' => 'Toplu Güncelleme',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'Toplu güncelleme için tüm kayıtları seçin',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'Kaydı toplu güncellemeye dahil et',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'Alan Ekle',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'Alan Kaldır',
    'LBL_GENERATE_QUOTE' => 'Teklif Oluştur',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'Toplu Güncelleme işlemi için mevcut alanlar yok',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'Toplu güncelleme isteğiniz iş planlanına alındı.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'Hizmet Başlangıç Tarihi, Hizmet Bitiş Tarihinden sonra',
    'LBL_MASS_UPDATE_SUCCESS' => 'Tüm kayıtlar başarıyla güncellendi.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'Seçilen kayıtlar <a href="{{listUrl}}">{{listName}}</a> hedef listesine eklendi.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'Seçilen kayıtların  <a href="{{listUrl}}">{{listName}}</a> hedef listesine eklenmesi talebiniz iş planına alındı.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'Aşağıdaki nitelikler boş değerler içeriyor:',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'Mevcut değerler boş değerler ile değiştirilecek. Devam etmek istiyor musunuz?',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'Asıl E-Postayı Listeden Çıkar',
    'LBL_MEETINGS' => 'Toplantılar',
    'LBL_MEETING' => 'Toplantı',
    'LBL_MEETING_GO_BACK' => 'Toplantıya geri dön',
    'LBL_MEMBERS' => 'Üyeler',
    'LBL_MEMBER_OF' => 'Üyeliği',
    'LBL_MODIFIED_BY_USER' => 'Değiştiren Kullanıcı',
    'LBL_MODIFIED_USER' => 'Değiştiren Kullanıcı',
    'LBL_MODIFIED' => 'Değiştiren',
    'LBL_MODIFIED_NAME' => 'Değiştiren Kişinin İsmi',
    'LBL_MODIFIED_ID' => 'Değiştiren ID',
    'LBL_MORE' => 'Daha fazla',
    'LBL_MORE_MODULES' => 'Daha fazla Modül',
    'LBL_MORE_TABS' => 'More Tabs',
    'LBL_MULTIPLE_MODULES' => 'Çoklu Modüller',
    'LBL_COUNT_MODULES' => '{{count}} Modül',
    'LBL_MY_ACCOUNT' => 'Hesabım',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'sistem varsayılan değerleri',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'varsayılan kullanıcı',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'kullanıcı hesabı',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'grup hesabı',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'İsim',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Oluştur',
    'LBL_NEW_BUTTON_TITLE' => 'Oluştur',
    'LBL_NEXT_BUTTON_LABEL' => 'Sonraki',
    'LBL_NOTES' => 'Notlar',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Tümünü Aç',
    'LBL_OPENALL_BUTTON_TITLE' => 'Tümünü Aç',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Kişiye Aç:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Kişiye Aç:',
    'LBL_OPEN_IN_NEW_TAB' => 'Yeni Sekmede Aç',
    'LBL_OPPORTUNITIES' => 'Fırsatlar',
    'LBL_OPPORTUNITY_NAME' => 'Fırsat İsmi',
    'LBL_OPPORTUNITY' => 'Fırsat',
    'LBL_OR' => 'VEYA',
    'LBL_LOWER_OR' => 'veya',
    'LBL_PANEL_ASSIGNMENT' => 'Diğer',
    'LBL_PANEL_ADVANCED' => 'Daha Fazla Bilgi',
    'LBL_PANEL_BODY' => 'Genel Bilgi',
    'LBL_PARENT_TYPE' => 'Üst Kayıt Tipi',
    'LBL_RELATED_TYPE' => 'İlişkili Tipi',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'Faz',
    'LBL_PICTURE_FILE' => 'Resim',
    'LBL_POSTAL_CODE' => 'Posta Kodu:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'Birincil Adres Şehir:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'Birincil Adres Ülke:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'Birincil Adres Posta Kodu:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Birincil Adres Eyalet:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Birincil Adres Sokak 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Birincil Adres Ülke:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Birincil Adres Sokak:',
    'LBL_PRIMARY_ADDRESS' => 'Birincil Adres:',

    'LBL_BILLING_STREET' => 'Sokak:',
    'LBL_SHIPPING_STREET' => 'Sokak:',

    'LBL_PRODUCT_BUNDLES' => 'Ürün Paketleri',
    'LBL_PRODUCTS' => 'Ürünler',
    'LBL_PROJECT_TASKS' => 'Proje Görevleri',
    'LBL_PRODUCT_TEMPLATES' => 'Ürün Şablonları',
    'LBL_PROJECTS' => 'Projeler',
    'LBL_PROSPECTS' => 'Hedefler',
    'LBL_QUICK_CREATE_MENU' => 'Hızlı Oluştura Menüsü',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Tekliften Fırsat Oluştur',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Tekliften Fırsat Oluştur',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'Fırsat Oluşturuluyor...',
    'LBL_QUOTES_SHIP_TO' => 'Teklif Alıcısı',
    'LBL_QUOTES' => 'Teklifler',

    'LBL_FORECAST_WORKSHEETS' => 'Tahmin Çalışma Sayfaları',
    'LBL_FORECAST_WORKSHEET' => 'Tahmin Çalışma Sayfası',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'Davetiye',
    'LBL_INVITED' => 'Davetli',
    'LBL_RECOMMENDED_INVITES' => 'Önerilen Davetler',
    'LBL_INSTANCES' => 'Örnekler',
    'LBL_YOUR_INSTANCES' => 'Kurulumlarınız',
    'LBL_INSTANCE_USERS' => 'Kurulum Kullanıcıları',
    'LBL_SWITCH_INSTANCE' => 'Bu kuruluma geçin',
    'LBL_LAST_LOGIN' => 'son giriş',
    'LBL_ENTER_EMAIL' => 'Davetli e-posta adresi girin...',
    'LBL_INSTANCE_IN_USE' => 'Kurulum kullanımda',
    'LBL_INSTANCE_ACTIVE' => 'Zaten bu kurulumu kullanıyorsunuz!',
    'LBL_INSTANCE_INVITE_SENT' => 'Davet gönderildi:',
    'LBL_INSTANCE_SWITCH_FAILED' => 'Kurulumlar arasında geçiş başarısız oldu',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'Hatırlatıcılar',
    'LBL_REMINDERS_OVERDUE' => 'Süresi Geçen',
    'LBL_REMINDERS_UPCOMING' => 'Yaklaşan',
    'LBL_REMINDERS_NONE_FOUND' => 'Hatırlatma bulunamadı.',
    'LBL_REMINDERS_FINISHED' => 'Bitti!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'Fırsat Metrikleri',

    'LBL_SWEETSPOT' => 'En Etkili Nokta',
    'LBL_SWEETSPOT_CONFIG' => 'En Etkili Nokta Yapılandırma Paneli',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'Kısayol tuşları',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'Yapılandırma tercihleri güncelleştirme işlemi başarısız oldu: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'En Etkili Nokta İşlemi',
    'LBL_SWEETSPOT_KEY' => 'Anahtar kelime',
    'LBL_SWEETSPOT_REMOVE' => 'Eylemi kaldır',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'Kısayol tuşları',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'Aksiyonlar',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'Kayıtlar',
    'LBL_SWEETSPOT_THEME' => 'Tema',
    'LBL_SWEETSPOT_THEME_SELECT' => 'Tema seçin',

    'LBL_RELATED' => 'İlişkili',
    'LBL_RELATED_INFORMATION' => 'İlişkili Bilgi',
    'LBL_RELATED_RECORDS' => 'İlişkili {{module}}',
    'LBL_REPORTS_TO' => 'Rapor Edilen Kişi:',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'Zorunlu alanı gösterir',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Tamam',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Farklı Kaydet',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Farklı Kaydet',
    'LBL_FULL_FORM_BUTTON_KEY' => 'L',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Tam Form',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Tam Form',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Kaydet & Yeni Oluştur',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Kaydet & Yeni Oluştur',
    'LBL_SAVE_OBJECT' => '{0} Kaydet',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Ara',
    'LBL_SEARCH_BUTTON_TITLE' => 'Ara',
    'LBL_SEARCH' => 'Ara',
    'LBL_SEARCH_TIPS' => 'Tam bir eşleşme elde etmek için ara butonuna veya enter butonuna basın.',
    'LBL_SEARCH_TIPS_2' => 'Tam bir eşleşme elde etmek için ara butonuna veya enter butonuna basın',
    'LBL_SEARCH_MORE' => 'daha fazla',
    'LBL_SEE_ALL' => 'Tamamını Gör',
    'LBL_SEARCH_LOAD_MORE' => 'DAHA FAZLA YÜKLE',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Geçersiz dosya türü, sadece görüntü dosyası yüklenebilir.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'Görüntü formatı {0} artık desteklenmiyor.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Seç',
    'LBL_SELECT_BUTTON_TITLE' => 'Seç',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'Takım(lar) Ekle',
    'LBL_SELECT_TEAMS_TITLE' => 'Takım(lar) Ekle',
    'LBL_SELECT_APPEND_TEAMS' => 'Takımları Ekle',
    'LBL_SELECT_APPEND_VALUES' => 'Değer(leri) ekle',
    'LBL_SELECT_APPEND_TAGS' => 'Etiket(ler)i Ekle',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Dokümanlara Göz at',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Dokümanlara Göz at',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'İlgili Seç',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'İlgili Seç',
    'LBL_GRID_SELECTED_FILE' => 'seçili dosya',
    'LBL_GRID_SELECTED_FILES' => 'seçili dosyalar',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Raporlardan Seç',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Raporları Seç',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Kullanıcı Seç',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Kullanıcı Seç',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Seçimi Temizle',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Seçimi Temizle',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Seçimi Temizle',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Seçimi Temizle',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Dosya Seçin',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Dosya Seçin',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Dosya Temizle',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Dosya Temizle',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Kullanıcı Seç',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Kullanıcı Seç',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Kullanıcıyı Temizle',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Kullanıcıyı Temizle',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Müşteri Seç',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Müşteri Seç',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Hesabı Temizle',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Hesabı Temizle',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Kampanya Seç',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Kampanya Seç',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Kampanyayı Temizle',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Kampanyayı Temizle',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'İlgili Seç',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'İlgili Seç',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Kontak Kaydını Temizle',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Kontak Kaydını Temizle',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Takım Seç',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Takım Seç',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Takım Kaydını Temizle',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Takım Kaydını Temizle',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Bu sayfanın oluşumu için kullanılan gerekli kaynaklar (sorgular, dosyalar)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'saniye.',
    'LBL_SERVER_RESPONSE_TIME' => 'Sunucu yanıt zamanı:',
    'LBL_SERVER_MEMORY_BYTES' => 'byte',
    'LBL_SERVER_MEMORY_USAGE' => 'Sunucu Bellek Kullanımı: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Kullanımı: - modül: {0} - aksiyon: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Sunucu Maksimum Bellek Kullanımı: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'Gönderilecek Müşteri',
    'LBL_SHIP_TO_CONTACT' => 'Gönderilecek İlgili',
    'LBL_SHIPPING_ADDRESS' => 'Teslimat Adresi',
    'LBL_SHORTCUTS' => 'Kısa yollar',
    'LBL_SHOW' => 'Göster',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'Eyalet:',
    'LBL_STATUS_UPDATED' => 'Bu Etkinlik için durumunuz güncellendi!',
    'LBL_STATUS_NOT_UPDATED' => 'Bu etkinlik için Durumunuz güncellenmedi.',
    'LBL_STATUS' => 'Durum:',
    'LBL_STREET' => 'Sokak',
    'LBL_SUBJECT' => 'Konu',

    'LBL_INBOUNDEMAIL_ID' => 'Gelen E-Posta ID',
    'LBL_EAMP_ID' => 'Kimlik Doğrulama Anahtar Numarası',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'Tüm Hakları Saklıdır.<br />SugarCRM, Sugar ve 3-D Küp, SugarCRM Inc.&#39;in tescilli ticari markalarıdır. ' .
        'Bu üründe kullanılan veya görünen diğer tüm şirket ve ürün adları, ilişkili olan ' .
        'ilgili şirketlerin ticari markalarıdır.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'Planlanan Görev Tamamlandı',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'Planlanan İş başarıyla çalıştı',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'Sugar kurulumunuzda Gelir Kalemleri aktive edildi',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Gelir Kalemleri Sugar kurulumunda şu anda aktive edildi ve bütün mevcut Fırsat kayıtları işlendi. Kurulumunuz şu anda Gelir Kalemleri ile çalışmaya hazır. Yapılan değişiklikler hakkında daha fazla bilgi için, {{doc_url}} adresine bakın.<br /><br />Saygılarımızla, SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'Satış Tahminleri Modülü, Sugar Kurulumunuzda Fırsatlar ile kullanım için hazır',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'Satış Tahminleri Modülü, Sugar Kurulumunuzda bütün fırsatlar ile kullanım için hazır. Daha önceki bütün Gelir Kalemleri satış tahminleri silindi, ve kurulum fırsatlar için tanımlanacak satış tahminlerinin girişi ve onayına hazır. Yapılan değişiklikler hakkında daha fazla bilgi için, {{doc_url}} adresine bakın.<br /><br />Saygılarımızla, SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Sugar kurulumunuzda Gelir Kalemleri Şimdi kapalı halde.',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Gelir Kalemleri Sugar kurulumunda şu anda deaktive edildi ve bütün mevcut Gelir Kalemleri kayıtları işlendi. Kurulumunuz şu anda Fırsatlar ile çalışmaya hazır. Yapılan değişiklikler hakkında daha fazla bilgi için, {{doc_url}} adresine bakın.<br /><br />Saygılarımızla, SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'Fırsat Konfigürasyonu dokümantasyonu',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'Giriş',
    'LBL_LOGIN_WELCOME_TO' => 'Hoş geldiniz',
    'LBL_LOGIN_OPTIONS' => 'Seçenekler',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'Şifrenizi mi Unuttunuz?',
    'LBL_LOGIN_SUBMIT' => 'Gönder',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'Çok fazla başarısız giriş denemesi.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'Girişi tekrar deneyebileceğiniz süre:',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'gün.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 's.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'dak.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'sn.',
    'LBL_LOGIN_ADMIN_CALL' => 'Lütfen sistem yöneticisi ile iletişime geçiniz.',
    'LBL_LOGIN_USERNAME' => 'Kullanıcı İsmi',
    'LBL_LOGIN_PASSWORD' => 'Şifre',
    'LBL_LOGGED_OUT' => 'Çıkış yaptınız.',
    'LBL_LOGIN_FORM_LABEL' => 'Log gösterim şekli:',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'Oturum açmaya dön',
    'LBL_LOGIN_INACTIVE_USER' => 'Etkin olmayan kullanıcı',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'Portal veya grup kullanıcısı oturum açamaz.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'Gösterge Panosu',
    'LBL_SYNC' => 'Senkronizasyon',
    'LBL_TASKS' => 'Görevler',
    'LBL_TEAMS_LINK' => 'Takımlar',
    'LBL_THEME_COLOR' => 'Renk',
    'LBL_THEME_FONT' => 'Yazı Tipi',
    'LBL_THOUSANDS_SYMBOL' => 'Bin',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'Toplantı Planla',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'Toplantı Planla',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'Bin',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'E-Posta Arşivle',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'E-Posta Arşivle',
    'LBL_UNAUTH_ADMIN' => 'Sistem Yönetimi Fonksiyonlarına izinsiz erişim',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Silinenleri Geri Al',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Silinenleri Geri Al',
    'LBL_UNDELETE_BUTTON' => 'Silinenleri Geri Al',
    'LBL_UNDELETE' => 'Silinenleri Geri Al',
    'LBL_UNSYNC' => 'Senkronizasyonu Kaldır',
    'LBL_UPDATE' => 'Güncelle',
    'LBL_UPDATES' => 'Güncellemeler',
    'LBL_USER_LIST' => 'Kullanıcı Listesi',
    'LBL_USER_MENU' => 'Kullanıcı Menüsü',
    'LBL_USERS_SYNC' => 'Kullanıcıları Senkronize Et',
    'LBL_USERS' => 'Kullanıcılar',
    'LBL_USER' => 'Kullanıcı',
    'LBL_CURRENT_USER' => 'Geçerli Kullanıcı',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'E-Postayı var olan kayıtlarda arıyor...',
    'LBL_VERIFY_PORTAL_NAME' => 'Portal ismini var olan kayıtlarda arıyor...',
    'LBL_VIEW_IMAGE' => 'Görünüm',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'PDF Olarak Yazdır',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'PDF Olarak Yazdır',

    'LBL_KBDOCUMENTS' => 'Bilgi Tabanı',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'Hakkında',
    'LNK_ADVANCED_SEARCH' => 'Gelişmiş Arama',
    'LNK_BASIC_SEARCH' => 'Temel Arama',
    'LNK_SEARCH_NO_RESULTS' => 'Sonuç bulunamadı.',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'Tüm sonuçları görüntüle',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Tümünü Göster',
    'LNK_CLOSE' => 'kapat',
    'LBL_MODIFY_CURRENT_SEARCH' => 'Şu anki aramayı değiştir',
    'LNK_SAVED_VIEWS' => 'Yerleşim Seçenekleri',
    'LNK_DELETE_ALL' => 'tümünü sil',
    'LNK_DELETE' => 'sil',
    'LNK_EDIT' => 'değiştir',
    'LNK_VIEW' => 'görünüm',
    'LNK_GET_LATEST' => 'En sonuncuyu al',
    'LNK_GET_LATEST_TOOLTIP' => 'En son sürümle değiştir',
    'LNK_HELP' => 'Yardım',
    'LNK_CREATE' => 'Oluştur',
    'LNK_CREATE_WHEN_EMPTY' => 'Hemen bir kayıt oluşturun.',
    'LNK_LIST_END' => 'Son',
    'LNK_LIST_NEXT' => 'Sonraki',
    'LNK_LIST_PREVIOUS' => 'Önceki',
    'LNK_LIST_RETURN' => 'Listeye Geri Dön',
    'LNK_LIST_START' => 'İlk',
    'LNK_LOAD_SIGNED' => 'İmzala',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'İmzalı belge ile değiştir',
    'LNK_PRINT' => 'Yazdır',
    'LNK_BACKTOTOP' => 'Başa Geri Dön',
    'LNK_REMOVE' => 'sil',
    'LNK_RESUME' => 'Yeniden Başla',
    'LNK_VIEW_CHANGE_LOG' => 'Değişiklik Tarihçesi Günlüğünü Görüntüle',
    'TPL_AUDIT_LOG_TITLE' => '{{{name}}} için Değişiklik Tarihçesi Günlüğü',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'E-posta adresi değişiklik tarihçesi günlüğünü görüntülemek için tıklayın',
    'LBL_NO_SEARCH_RESULTS' => 'No results found for your search',
    'NTC_CLICK_BACK' => 'Lütfen web tarayıcısının geri butonuna basın ve hatayı düzeltin.',
    'NTC_DATE_FORMAT' => '(yıl-ay-gün)',
    'NTC_DATE_TIME_FORMAT' => '(yyyy-aa-gg 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'Seçili kayıt(ları) silmek istediğinizden emin misiniz?',
    'NTC_TEMPLATE_IS_USED' => 'Şablon en azından bir e-posta pazarlama kaydında kullanılmış. Silmek istediğinizden emin misiniz?',
    'NTC_TEMPLATES_IS_USED' => "Aşağıdaki Şablonlar e-posta pazarlama kayıtlarında kullanılmış. Silmek istediğinizden emin misiniz?",
    'NTC_DELETE_CONFIRMATION' => 'Bu kaydı silmek istediğinizden emin misiniz?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => '{0} silmek istediğinizden emin misiniz?',
    'LBL_METRIC_DELETE_WARNING' => 'Bu ölçü sekmesinin paylaşıldığı tüm kullanıcılar da erişimlerini kaybedecek.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'Bu kayıt/kayıtları silmek istediğinizden emin misiniz?',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'Bu kayıt/kayıtları güncellemek istediğinizden emin misiniz?',
    'NTC_DELETE_SELECTED_RECORDS' => 'seçili kayıt(lar)?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'Bu filtre tüm görünümlerden kaldırılacak, bu dashlet için verilerin yapılandırılmasını içerebilir. Bu filtreyi silmek istediğinizden emin misiniz?',
    'TPL_DELETE_FILTER_SUCCESS' => '{{name}} isimli filtreyi sildiniz.',
    'NTC_DELETE_SUCCESS' => 'Silinen {0}.',
    'NTC_UNLINK_CONFIRMATION' => 'Bağlantıyı kaldırmak istediğinizden emin misiniz:',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => '{0} bağlantısını kaldırmak istediğinizden emin misiniz?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => '{0} bağlantısını kaldırmak istediğinizden emin misiniz? Bu işlem aynı zamanda bunları talebin Birincil Kontak alanından da kaldıracaktır.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => 'Bu talepteki birincil kontak olduğu için {0} bağlantısı kaldırılamaz. Bu kaydın bağlantısını kaldırmadan önce Birincil Kontağı güncelleyin.',
    'NTC_UNLINK_SUCCESS' => 'Bağlantısı kaldırılan:',
    'NTC_LOGIN_MESSAGE' => 'Lütfen kullanıcı ismi ve şifrenizi giriniz.',
    'NTC_NO_ITEMS_DISPLAY' => 'boş',
    'NTC_REMOVE_CONFIRMATION' => 'Bu ilişkiyi kaldırmak istediğinizden emin misiniz? Sadece ilişki kaldırılır. Kayıt silinmez.',
    'NTC_REQUIRED' => 'Zorunlu alanı gösterir',
    'NTC_SUPPORT_SUGARCRM' => 'PayPal ile bağış yaparak SugarCRM Projesini destekleyin- Ücretsiz, hızlı ve güvenli!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'Hoş geldiniz',
    'NTC_YEAR_FORMAT' => '(yyyy)',
    'LOGIN_LOGO_ERROR' => 'Lütfen SugarCRM logolarını değiştirin.',
    'FATAL_LICENSE_ALTERED' => 'Son kontrol sonrasında lisansınız değiştirilmiş.',
    'ERROR_FULLY_EXPIRED' => "Şirketinize ait SugarCRM lisansının geçerliliği 7 günden önce sona ermiş ve  güncellenmesi gerekir.  Sadece Yöneticilerini giriş yapmasına izin verilmektedir.",
    'ERROR_LICENSE_EXPIRED' => "Şirketinize ait SugarCRM lisansınızın güncellenmesi gerekmekte. Sadece Yöneticilerin giriş yapmasına izin verilmektedir",
    'WARN_LICENSE_EXPIRED' => "Şirketinizin SugarCRM lisansı yakında sona erecek.",
    'ERROR_LICENSE_VALIDATION' => "Şirketinize ait SugarCRM lisansınızın doğrulanması gereklidir. Sadece Yöneticilerini giriş yapmasına izin verilmektedir",
    'WARN_LICENSE_VALIDATION' => "Şirketinizin SugarCRM lisansı yakında doğrulanması gerekiyor.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>Uyarı:</b> Tarayıcınızın desteklenmeyen IE uyumluluk modunda çalışıyor.',
    'WARN_LICENSE_SEATS' => 'Uyarı: Aktif kullanıcı sayısı izin verilen maksimum lisans sayısını aşıyor.',
    'WARN_LICENSE_SEATS_MAXED' => 'Uyarı: Aktif kullanıcı sayısı izin verilen maksimum lisans sayısını aşıyor.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'Aktif kullanıcı sayısı Lisans Sayısı limitini aştı. Lütfen Yöneticinizle iletişime geçin.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'Yalnızca yönetici sisteme bağlanabilir.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'Kullanıcı Lisansı Sayısı limitine ulaşıldı. Yalnızca mevcut kullanıcılar sisteme bağlanabilir.',
    'WARN_ONLY_ADMINS' => 'Yalnızca yönetici sisteme bağlanabilir.',
    'WARN_UNSAVED_CHANGES' => 'Bu kayıtta yaptığınız değişiklikleri kaydetmeden çıkıyorsunuz. İlgili kayıttan çıkmak istediğinizden emin misiniz?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Tarayıcının yenilenmesi, açmış olduğunuz tüm SugarLive çağrılarını veya sohbet oturumlarını otomatik olarak kapatır ve kaydedilmemiş tüm değişiklikler kaybolur. Devam etmek istiyor musunuz?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'Kaydedilmemiş değişiklikler var. Sayfadan ayrılmak ve değişiklikleri silmek istediğinizden emin misiniz?',
    'LBL_MFA_RESET_CONFIRMATION' => '<a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">çok faktörlü kimlik doğrulamanızı sıfırlamak istediğinizden emin misiniz</a>? 
Bu işlemi gerçekleştirmek anında oturumunuzu kapatacak ve bir dahaki oturum açmanızda kimlik doğrulama uygulamasını kullanarak kimlik doğrulama yapmanız gerekecek.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'Onayla ve Oturumu Kapat',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'One or more dashlets have unsaved changes. Are you sure you want to close the drawer?',
    'LBL_NAVIGATE_TO_REPORTS' => 'Raporlar modülüne gidiyorsunuz. Bilgi Penceresine yapmış olduğunuz değişiklikler kaydedilmeyecek. Devam?',
    'ERROR_NO_RECORD' => 'Kayıt almada hata. Bu kayıt silinmiş olabilir veya görüntülemek için izniniz yok.',
    'ERROR_TYPE_NOT_VALID' => 'Hata. Bu tip geçerli değil.',
    'ERROR_MAX_FIELD_LENGTH' => 'Hata. Bu alanın maksimum uzunluğu: {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'Hata. Bu alanın minimum uzunluğu: {{this}}.',
    'ERROR_EMAIL' => 'Hata. Geçersiz E-posta Adresi: {{#each this}}{{this}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'Hata. En azından bir tane birincil adres belirlenmelidir.',
    'ERROR_DUPLICATE_EMAIL' => 'Hata. Tekrar Eden E-posta Adresi: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'Hata. Bu alan zorunludur.',
    'ERROR_MINVALUE' => 'Hata. Bu alanın minumum değeri: {{this}}.',
    'ERROR_MAXVALUE' => 'Hata. Bu alanın maksimum değeri: {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'Hata. Bu alanın değeri {{this}} değerinden daha fazla olmalıdır.',
    'ERROR_IS_LESS_THAN' => 'Hata. Bu alanın değeri {{this}} değerinden daha az olmalıdır.',
    'ERROR_DATETIME' => 'Hata. Bu alan, geçerli bir tarih gerektirir.',
    'ERROR_IS_BEFORE' => 'Hata. Bu tarih alanının değeri {{this}} alanından sonra olamaz.',
    'ERROR_IS_AFTER' => 'Hata. Bu tarih alanının değeri {{this}} alanından önce olamaz.',
    'ERROR_TIME_IS_BEFORE' => 'Hata. Bu alanın zamanı, {{this}} alanının zamanından önce olmalıdır.',
    'ERROR_TIME_IS_AFTER' => 'Hata. Bu alanın zamanı, {{this}} alanının zamanından sonra olmalıdır.',
    'ERROR_NUMBER' => 'Hata. Bu alan, geçerli bir sayı gerektirir.',
    'ERROR_INT' => 'Hata. Geçersiz tam sayı.',
    'ERROR_URL' => 'Hata. Geçersiz URL.',
    'ERROR_NO_BEAN' => 'Bean verileri alınamadı.',
    'ERROR_ACCESS_MODULE' => 'Bu modüle erişiminiz yok.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'Hata. Ek çok büyük.',
    'ERROR_UPLOAD_FAILED' => 'hata. Dosya yüklenemedi.',
    'ERROR_UPLOAD_ACCESS_PD' => 'Bu modül için [işlem tanımları] oluşturma izniniz yok.',
    'ERROR_UPLOAD_ACCESS_BR' => 'Bu modül için [iş kuralları] oluşturma izniniz yok.',
    'ERROR_UPLOAD_ACCESS_ET' => 'Bu modül için [e-posta şablonları] oluşturma izniniz yok.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'Hata. Desteklenmeyen bir operatör girdiniz.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'Hata. Geçersiz bir operatör girdiniz.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'Hata. Geçersiz bir filtre girdiniz.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'İçe aktarma başarısız oldu. Bir grup alanı, Süreç Tanımında kısmen kilitlendi.' .
        ' Tanımın içe aktarılması için bu alanların Süreç Tanımında kilitlerinin açılması gerekli.',
    'ERROR_EXP_DATE_LOW' => 'Hata. Bitiş Tarihi, yayınlanma tarihinden önce olamaz.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'Hata. Onaylandı durumu yayınlama tarihi gerektirir.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'Yayın Tarihi boş.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'Aynı Kayıtları Bul',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'Tekrarlanan öğe denetimi {{module}} için devre dışı bırakılır.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'Abonelikleri Yönet',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Abonelik Yönetimi:',
    'LBL_SUBSCRIBE' => 'Abone Ol',
    'LBL_UNSUBSCRIBE' => 'Abonelikten Ayrıl',
    'LBL_CREATE_LINK_RECORD' => 'Kayıt Oluştur  ve İlişkilendir',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'Kayıt Oluştur  ve İlişkilendir',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} adet kayıt ilişkilendirildi.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'Bağlayacak kayıt yok.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'Seçilen rapor doğru modül tipinde değil.',
    'ERROR_EMPTY_LINK_MODULE' => 'Lütfen önce ilişkiyi seçin.',
    // Ajax status strings
    'LBL_LOADING' => 'Yükleniyor...',
    'LBL_LOADING_NO_DOTS' => 'Yükleniyor',
    'LBL_SEARCHING' => 'Arıyor...',
    'LBL_SEARCH_UNDERWAY' => 'Arama',
    'LBL_SAVING_LAYOUT' => 'Yerleşim Kaydediliyor ...',
    'LBL_SAVED_LAYOUT' => 'Yerleşim kaydedildi.',
    'LBL_SAVED' => 'Kaydedildi',
    'LBL_SAVING' => 'Kaydediliyor',
    'LBL_FAILED' => 'Başarısız!',
    'LBL_DISPLAY_COLUMNS' => 'Kolonları Göster',
    'LBL_HIDE_COLUMNS' => 'Kolonları Gizle',
    'LBL_SEARCH_CRITERIA' => 'Arama Kriteri',
    'LBL_SAVED_VIEWS' => 'Kaydedilmiş Görünümler',
    'LBL_PROCESSING_REQUEST' => 'İşleniyor...',
    'LBL_REQUEST_PROCESSED' => 'Tamam',
    'LBL_AJAX_FAILURE' => 'Ajax hatası',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'Ara …',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Kaydedilmiş Aramalar',
    'LBL_SEARCH_POPULATE_ONLY' => 'Yukarıdaki arama formunu kullanarak arama yap',
    'LBL_SEARCH_NO_RESULTS' => 'Sonuç bulunamadı:',
    'LBL_SEARCH_FOR' => 'Arama',
    'LBL_SEARCH_FOR_MORE' => 'Daha fazlasını ara...',
    'LBL_SEARCH_SELECT' => 'Seç…',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'Ara ve Seç...',
    'LBL_SEARCH_SELECT_MODULE' => 'Seç {{module}}...',
    'LBL_DETAILVIEW' => 'Detay Görünümü',
    'LBL_LISTVIEW' => 'Liste Görünümü',
    'LBL_EDITVIEW' => 'Değişiklik Görünümü',
    'LBL_SEARCHFORM' => 'Arama Formu',
    'LBL_SAVED_SEARCH_ERROR' => 'Bu Görünüm için bir isim verin.',
    'LBL_DISPLAY_LOG' => 'Günlüğü Göster',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Yer:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Tanım:',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'başlama',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'Çağrıyı görüntülemek için Tamam butonuna basın yada bu mesajı kapatmak için İptal butonuna tıklayın.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'Toplantıyı görüntülemek için Tamam butonuna tıklayın yada bu mesajı kapatmak için İptal butonuna tıklayın.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'Sonuç bulunamadı.',
    'MSG_LIST_VIEW_NO_RESULTS' => '<item1> için sonuç bulunamadı',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Yeni <item2> gibi <item1> oluşturun',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'Şu anda kaydedilmiş <item1> kaydınız yok. Şimdi bir tane <item2> veya <item3>.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'Şu anda kaydedilmiş <item1> kaydınız yok. <item2> ilki oldu.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => '<item2> kullanılarak, <item1> oluşturabilirsiniz. <item3> <item2> listesi.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'Olumlu',
    'LBL_SENTIMENT_NEUTRAL' => 'Nötr',
    'LBL_SENTIMENT_NEGATIVE' => 'Olumsuz',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'Ölçü Sekmesi Yapılandırılmadı',
    'LBL_NO_METRIC_VISIBLE' => 'Görünür Metrik Sekmesi Yok',
    'LBL_MAKE_METRIC_VISIBLE' => 'Metrik sekmelerini görünür hale getirmek için "düzenle"yi seçin',
    'LBL_PLEASE_CONTACT_ADMIN' => 'Lütfen yöneticiniz ile iletişime geçin',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'Buraya tıklayın',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Favorilerime ekle',
    'LBL_MARK_AS_FAVORITES' => 'Favori olarak işaretle',
    'LBL_CREATE_CONTACT' => 'Kontak Oluştur',
    'LBL_CREATE_NOTE' => 'Not Oluştur',
    'LBL_CREATE_OPPORTUNITY' => 'Fırsat Oluştur',
    'LBL_SCHEDULE_CALL' => 'Tel. Araması Planla',
    'LBL_SCHEDULE_CALL2' => 'Çağrı',
    'LBL_SCHEDULE_MEETING' => 'Toplantı Planla',
    'LBL_SCHEDULE_MEETING2' => 'Toplantı',
    'LBL_CREATE_MESSAGE' => 'Mesaj Oluştur',
    'LBL_CREATE_MESSAGE2' => 'Mesaj',
    'LBL_CREATE_TASK' => 'Görev Oluştur',
    'LBL_CREATE_TASK2' => 'Görev',
    'LBL_REMOVE_FROM_FAVORITES' => 'Favorilerimden kaldır',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'Not',
    'LBL_DOWNLOAD_ALL' => 'Tümünü İndir',
    'LBL_DOWNLOAD_ONE' => 'İndir',
    'LBL_ATTACHMENTS' => 'Ekler',
    'LBL_ADD_ATTACHMENT' => 'Göz at',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Form Üret',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Web&#39;den Potansiyel Kaydet Formu',

    'LBL_PLEASE_SELECT' => 'Lütfen Seçiniz',
    'LBL_REDIRECT_URL' => 'Yönlendirme URL&#39;i',
    'LBL_RELATED_CAMPAIGN' => 'İlişkili kampanya',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Tüm Alanları Ekle',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Tüm Alanları Kaldır',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Yalnızca Resim tipindeki ek kabul edilmektedir',
    'LBL_REMOVE' => 'Sil',
    'LBL_TRAINING' => 'Destek',
    'ERR_DATABASE_CONN_DROPPED' => 'Sorgu çalıştırmasında hata, veritabanınız bağlantıyı koparmış olabilir. Sayfayı yeniden yükleyin, web sunucunuzu yeniden başlatmanız gerekebilir.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'Hata ayar {0} ilişki: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'Veritabanı context değeri değiştirildi',
    'ERR_MSSQL_WARNING' => 'Uyarı:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'VCard biçimini ayrıştırma başarısız oldu',
    'ERR_VCARD_FILE_MISSING' => 'vcf dosyası kayıp',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Uyarı: alan [[field]] ,  [moduleDir] vardefs.php dosyasında bir giriş ile eşlenmemiş',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Hata: Dosya [[file]] bulunamadı.  Karşılık gelen HTML dosyası olmadığı için oluşturulamadı.',
    'ERR_CANNOT_FIND_MODULE' => 'Hata: Modül [module] bulunamadı.',
    'LBL_ALT_ADDRESS' => 'Diğer Adres:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Hata : displayParams dizisinde eşit olmayan sayıda &#39;key&#39; ve &#39;copy&#39; elemanları bulunmaktadır.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'displayParams Dizisinde eksik endeks:',

    'LBL_DASHLET' => 'Pano',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filtreler',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Yalnızca Benim Kalemlerim',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Başlık',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Satırları Göster',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'Şu anki kayıtla ilişkilendir',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'Bağlantılı Alan',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'İlk Sütunu Dondur',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'Bu Sugar Dashlet kaldırmak istediğinizden emin misiniz?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'Satırı kaldırmak istediğinizden emin misiniz?',
    'LBL_MAXIMUM_OF' => 'Maksimum:',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => 'sütunları görüntülenebilir.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'Gösterge Panosu',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'Panom',
    'LBL_COLLAPSE_ALL' => 'Tümünü Daralt',
    'LBL_EXPAND_ALL' => 'Tümünü Genişlet',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'Değiştir',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'Raporu Görüntüle',
    'LBL_DASHLET_REFRESH_LABEL' => 'Yenile',
    'LBL_DASHLET_REMOVE_LABEL' => 'Kaldır',
    'LBL_DASHLET_DROP_HERE' => 'Buraya bırak',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'Küçült',
    'LBL_DASHLET_MAXIMIZE' => 'Büyüt',
    'LBL_DASHLET_CONFIGURE' => 'Yapılandır',
    'LBL_DASHLET_TOGGLE' => 'Dashboard Görünürlüğünü Değiştir',
    'LBL_SIDEPANE_TOGGLE' => 'Açma/Kapama Yan Paneli',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'Varsayılan Panoları Geri Yükle',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'Pano Yapılandırılmadı',
    'LBL_CREATE_DASHBOARD_LINK' => 'Pano Oluştur',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'Yardım',
    'LBL_HELPLET_TOGGLE' => 'Aç/Kapat',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'Modüller',
    'LBL_FACET_MODIFIED_BY_ME' => 'Benim Tarafımdan Değiştirildi',
    'LBL_FACET_CREATED_BY_ME' => 'Benim Oluşturduğum',
    'LBL_FACET_MY_FAVORITES' => 'Favorilerim',
    'LBL_FACET_ASSIGNED_TO_ME' => 'Bana Atandı',
    'LBL_FACET_NO_DATA' => 'Bu model için veri yok.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'Liste Görünümü',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'Tanımladığınız kriterlere göre belirli bir modülünden kayıtları listeleyin.',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'Konsol Listesi Görünümü',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'Konsolda görüntülediğiniz kayıtla ilişkili belirli bir modülden kayıtları listeler.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'Kayıt Görüntüle',
    'LBL_RELATED_RECORDS' => 'İlişkili {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'Bir kaydı ve isteğe bağlı olarak ilgili kayıtları sekmelerde gösterir.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'Temel Kayıt Türü',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'Bu {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'Sekmeler',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'Temel Yerleşim Ön İzleme',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'Uyarı, sadece {{numWord}} ({{num}}) modülleri sekmelerde görüntülenebilir. ' .
        'Başkalarını eklemek için lütfen bir veya daha fazla modülü kaldırın.',
    'LBL_SIX' => 'altı', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'Yorum Günlüğü',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'Bir kaydın yorumlarını görüntüler',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'Yorumlar mevcut değil',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'Ekle',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'Yorum ekle',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'Tümünü Göster',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'Veri mevcut değil. Bu modüllere erişim izniniz yok.' .
    " \nLütfen bu dashlet'i güncelleyin veya kaldırın.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'Benim {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'Görüntülemek üzere kayıt seçilmedi',
    'LBL_CONTENT_SEARCH_DASHLET' => 'Content Search Dashlet',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'What can we help you with today, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'Would you like to create a case?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'Fırsat Metrikleri',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'İlgili Hesap için Fırsat Ölçümleri.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'Ürün Kataloğu Hızlı Seçimler',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'Yakın zamanda öğeleri ve ürünleri kullanan listeler, Favoriler olarak kaydedildi',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'Yakın Zamanda Kullanılan',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'Favoriler',

    'LBL_DASHBOARD_CREATE' => 'Pano Oluştur',
    'LBL_DASHBOARD_DUPLICATE' => 'Tekrarlayan Pano',
    'LBL_DASHBOARD_DELETE' => 'Panoyu Sil',
    'LBL_PIN_TO_TOP' => 'Üste Sabitle',
    'LBL_PIN_TO_BOTTOM' => 'Alta Sabitle',
    'LBL_MANAGE_DASHBOARDS' => 'Panoları Yönet',

    'LBL_DASHBOARD_CONFIG' => 'Pano Yapılandırması',
    'LBL_LIST_VIEW__NAME' => 'Liste Görünümü',
    'LBL_PIPELINE_VIEW_NAME' => 'Kutucuk Görünümü',
    'LBL_PIPELINE_VIEW_BTN' => 'Kutucuk Görünümü',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{fieldName}} tarafından {{module}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'Kutucuk Görünümü etkin değil',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'Bu zaman diliminde kayıtlar bulunamadı.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'Talep Özeti',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'Zaman Çizelgesi',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'Notlar & Eklentiler',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'Kayda ait Notlar ve Eklentiler',
    'LBL_DASHLET_PIPLINE_NAME' => 'İletişim hattı',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'Yeni Twitler - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'Kaydedilmiş Bilgi Penceresi yok.',

    'LBL_DNB_AND' => 've',
    'LBL_DNB_PRIM_NAME_DESC' => 'Bu organizasyonun isminin text olarak girilmiş hali',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'Yanıtla',
    'LBL_TWITTER_RETWEET' => 'Tekrar Twitle',
    'LBL_TWITTER_FAVORITE' => 'Favori',
    'LBL_TWITTER_FOLLOW' => 'İzle',
    'LBL_TWITTER_DESCRIPTION' => 'Eşleşen twitter kullanıcısının bilgilerini ve twitlerini görün, tekrar twitleyin ve twitlerine cevap yazın.',
    'LBL_TWITTER_ID' => 'Twitter ID',
    'LBL_TWITTER_DISPLAY_ROWS' => 'Satırları Göster',
    'LBL_TWITTER_MY_ACCOUNT' => 'Hesabım',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Kaynak Tweet:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'Eğitim Kaynakları',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'Eğitim ve Sertifikasyon',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub Topluluğu',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'Belgeler ve Destek',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters Mağazası',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'Ülkelere Göre Satış',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'Ülke haritası üzerinde satış grafiği görüntüler.',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'Bilgi Bankası Kategoriler ve Yayınlanan Makaleler',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'Bilgi Bankası Araması',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'Yayınlanmış bilgi bankası makaleleri ve kategorilerinin aranabilir ağaç görünümünü görüntüler.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'Diğer Dillerde Yayınlanan Makaleler',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'En Kullanışlı Yayınlanmış Bilgi Bankası Makaleleri',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'En çok beğenilen ve görülen bilgi tabanı makalelerini görüntüler',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} modülü {{label}} "{{value}}" tarafından filtrelendi',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'Makaleler için Kullanışlı Değil',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'Sayfa Ekle',
    'LBL_LOADING_PAGE' => 'Sayfa yükleniyor, lütfen bekleyin...',
    'LBL_SEARCH_RESULTS' => 'Arama Sonuçları',
    'LBL_SEARCH_RESULTS_FOR' => 'Şunun için arama sonuçları: ',
    'LBL_SEARCH_HELP_TITLE' => 'Arama İpuçları',
    'LBL_SEARCH_RESULTS_FOUND' => 'Arama Sonuçları Bulundu',
    'LBL_SEARCH_RESULTS_TIME' => 'bayan',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'Potansiyel Satışlarım',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "Takımımın Potansiyel Satışları",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'Potansiyel Satış Grafiği',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'Mevcut potansiyel satış grafiğini gösterir.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'Resim yok',

    'LBL_MODULE' => 'Modül',
    'LBL_RELATIONSHIP' => 'İlişki',
    'LBL_SINGULAR_LABEL' => 'Tek Etiket',
    'LBL_PLURAL_LABEL' => 'Çoklu Etiket',
    'LBL_MODULE_DISPLAY' => 'Görüntü',
    'LBL_MODULE_DISPLAY_TYPE' => 'Görüntü Türü',
    'LBL_MODULE_ICON' => 'Simge',
    'LBL_MODULE_COLOR' => 'Modül Arkaplan Rengi',
    'LBL_LANGUAGE_SELECTOR' => 'Dil',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'Modül Ayarları',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'Modül ayarları kaydedildi.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Adresi soldan kopyalayın:',
    'LBL_SAVE_AND_CONTINUE' => 'Kaydet ve Devam Et',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Çok seçimli kontroller</strong></p><ul><li>Bir özelliği seçmek için değerler üzerine tıklayınız.</li><li>Ctrl tuşu ile tıklayarak birden fazla seçim yapabilirsiniz. Mac kullanıcıları CMD tuşu ile tıklayabilir.</li><li>İki değer arasındaki bütün değerleri seçmek için,  ilk değere tıkladıktan sonra, son değere shift tuşu basılıyken tıklayınız.</li></ul><p><strong>Gelişmiş Arama & Görünüm Opsiyonları</strong><br><br><b>Kaydedilen Arama & Görünüm</b> opsiyonunu kullanarak,  ileride istenen arama sonuçlarına ulaşmak için bir dizi arama parametrelerini ve/veya kişiselleştirilmiş Listeleme Görünümünü kaydedebilirsiniz. Sınırsız sayıda kişiselleştirilmiş arama ve görünümü kaydedebilirsiniz. Bütün kaydedilen aramalar, en son yüklenen kaydedilen aramada en yukarıda olacak şekilde Kaydedilen Aramalar Listesinde görünür. <br><br>Liste Görünüm düzenini kişiselleştirmek için, Gizlenen Kolonlar ve Gösterilen Kolonlar kutularını kullanarak arama sonucunda gösterilecek alanları belirtebilirsiniz. Örneğin, kaydın ismi, atanan kullanıcı, atanan takım gibi detayları arama sonucundan kaldırabilirsiniz. Yeni bir kolonu Liste Görünümüne eklemek için, Gizlenen Kolonlar listesinden ilgili kolonları seçip, sol ok tuşunu kullanarak Gösterilen Kolonlar listesine taşıyınız. Bir kolonu Liste Görünümünden kaldırmak için, bu alanı Gösterilen Kolonlar listesinden seçip, sağ ok tuşu ile Gizlenen Kolonlar listesine taşıyınız.<br><br>Eğer görünüm ayarlarını kaydederseniz, ileride herhangi bir zamanda, arama sonuçlarını kişiselleştirilmiş görünümde göstermek üzere seçebilirsiniz.<br><br>Bir arama ve/veya görünümü kaydetmek veya güncellemek için:<ol><li><b>Bu aramayı kaydetmek için isim</b> alanına bir isim girin ve <b>Kaydet</b> butonuna tıklayın. İsim bundan sonra <b>Temizle</b> tuşunun yanında Kaydedilen Aramalar listesinde görünecektir. </li><li>Kaydedilen aramayı görmek için, Kaydedilen Aramalar listesinden seçiniz. Arama sonuçları Liste Görünümünde belirecektir.</li><li>Kaydedilen arama özelliklerini güncellemek için, listeden kaydedilen aramayı seçin, yeni arama kriteri ve görüntü ayarlarını Gelişmiş Arama içinden seçin ve <b>Şu anki Aramayı Değiştir</b> tuşunun yanındaki <b>Güncelle</b> butonuna basın.</li><li>Bir kaydedilen aramayı silmek için, Kaydedilen Aramalar listesinden seçin, <b>Şu anki Aramayı Değiştir</b> tuşunun yanındaki <b>Sil</b> butonuna basıp, <b>Tamam</b> butonuna basarak silme işlemini onaylayınız.</li></ol>',

    //resource management
    'ERR_QUERY_LIMIT' => 'Hata: Sorgu limiti olan $limit, $module modülü için ulaşıldı.',
    'ERROR_NOTIFY_OVERRIDE' => 'Hata: ResourceObserver->notify() tekrar yazılması gerekir.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'Hata: metadata dosyasının boş olmasından veya dosyanın olmamasından dolayı monitör oluşturamadı.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'Hata: Talep edilen isim için tanımlanmış monitör bulunamamaktadır',
    'ERR_UNDEFINED_METRIC' => 'Hata: Tanımlı olmayan metrik için değer koyamıyor',
    'ERR_STORE_FILE_MISSING' => 'Hata: Store uygulama dosyası bulunamadı',

    'LBL_MONITOR_ID' => 'Monitör Id',
    'LBL_TEAM_ID' => 'Takım id',
    'LBL_SELECT_MODULE' => 'Modül seç:',
    'LBL_USER_ID' => 'Kullanıcı Id',
    'LBL_MODULE_NAME' => 'Modül İsmi',
    'LBL_MODULE_ALL' => 'Hepsi',
    'LBL_ITEM_ID' => 'Kalem Id',
    'LBL_ITEM_SUMMARY' => 'Kalem Özeti',
    'LBL_ACTION' => 'Aksiyon',
    'LBL_SESSION_ID' => 'Oturum Id',
    'LBL_BREADCRUMBSTACK_CREATED' => 'Kullanıcı ID&#39;si {0} için BreadCrumbStack oluşturuldu',
    'LBL_VISIBLE' => 'Kayıt Görünebilir',
    'LBL_DATE_LAST_ACTION' => 'En Son Aksiyon Tarihi',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL Metni',
    'LBL_QUERY_HASH' => 'SQL Sağlaması',
    'LBL_SEC_TOTAL' => 'Toplam Saniye',
    'LBL_SEC_AVG' => 'Ortalama Saniye',
    'LBL_RUN_COUNT' => 'Sorgu Sayısı',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'İstemci IP Adresi',
    'LBL_DATE_START' => 'Başlama Tarihi',
    'LBL_ACTIVE' => 'Aktif Süre',
    'LBL_ROUNDTRIPS' => 'Aksiyon Sayısı',
    'LBL_SECONDS' => 'Aktif Saniye',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'Veritabanına Erişim Sayısı',
    'LBL_FILES_OPENED' => 'Erişilen Dosyalar',
    'LBL_MEMORY_USAGE' => 'Hafıza Kullanımı (bayt)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'Twitter Konnektörü yükleniyor...',
    'LBL_TWITTER_DATA_EMPTY' => 'Twitter&#39;dan',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Outlook için Sugar Eklentisi',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Sugar e-posta ve takvim bilgisi ile Microsoft Outlook&#39;u entegre et.',
    'LBL_PLUGIN_WORD_NAME' => 'Word için Sugar Eklentisi',
    'LBL_PLUGIN_WORD_DESC' => 'Direk posta ve diğer Microsoft dokümanları gibi Form Mektupları içinde SugarCRM&#39;den otomatik olarak bilgi doldur.',
    'LBL_PLUGIN_EXCEL_NAME' => 'Excel için Sugar Eklentisi',
    'LBL_PLUGIN_EXCEL_DESC' => 'Anahtar ölçümlerin daha iyi analiz edilebilmesi için Sugar ile hesap tablolarını entegre et.',
    'LBL_PLUGINS_TITLE' => 'Microsoft Office için Sugar Eklentisi<sup>TM</sup>',
    'LBL_PLUGINS_DESC' => '<a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">Eklentiler Dokümantasyonu</a> içindeki özellikleri okuyunuz.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Lotus NotesTM için Sugar Eklentileri',
    'LBL_PLUGIN_LOTUS_NAME' => 'Lotus Notes için Sugar Eklentisi',
    'LBL_PLUGIN_LOTUS_DESC' => 'Lotus Notus ile Sugar&#39;ı entegre edin.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'daha önce değil:',
    'MSG_IS_MORE_THAN' => 'daha fazla',
    'MSG_IS_LESS_THAN' => 'daha az',
    'MSG_SHOULD_BE' => 'olması gereken',
    'MSG_OR_GREATER' => 'veya daha büyük',
    'MSG_EXCEEDS_MAXLEN' => 'belirtilen en fazla uzunluğu aşıyor ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Sugar Portal 5.1.0&#39;a Hoş Geldiniz',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal, müşterilere gerçek zamanlı talepleri, hata & bültenleri...vb. görüntüleyen sistemi temin eder. Bu herhangi bir harici web sitesi içerisinde uygulanabilen Sugar&#39;ın dış yüz arabirimidir. Gelecekteki sürümlerimizde yer alacak Proje Yönetimi ve Forumlar gibi daha fazla müşteri self servis özelliği için bizi izlemeye devam edin.',
    'LBL_LIST' => 'Liste',
    'LBL_CREATE_CASE' => 'Talep Oluştur',
    'LBL_CREATE_BUG' => 'Hata Oluştur',
    'LBL_NO_RECORDS_FOUND' => '- 0 Kayıt Bulundu -',

    'DATA_TYPE_DUE' => 'Son Tarih:',
    'DATA_TYPE_START' => 'Başlangıç:',
    'DATA_TYPE_SENT' => 'Gönderildi:',
    'DATA_TYPE_MODIFIED' => 'Değiştirildi:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Sayı',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'nesne resmi',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'Tarihi Seçin',

    'LBL_VALIDATE_RANGE' => 'kabul edilebilir aralıkta değil',
    'LBL_VALIDATE_URL' => 'geçerli bir URL değil',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'Hepsi',

    'LBL_OPERATOR_IN_TEXT' => 'şunlardan biri:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'şunlardan biri değil:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Hata: bean parametresi Dizin sayısı, sonuçların Dizin sayısını tutmuyor.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Hata: Modül için eşleşme hatası.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Hata: Bağlayıcı {0} için veri alınamamaktadır.  Servis şu anda ulaşılamıyor veya konfigürasyon değeri hatalı olabilir.  Bağlayıcı Hata Mesajı: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'Veri alınamadı. Servis şu anda erişilemiyor olabilir veya konfigurasyon ayarları geçersiz olabilir.',
    'LBL_CONNECT_TWITTER' => 'Twitter Sayfasına Bağlan',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'Twitter ID için geçerli bir zaman çizelgesi bulunmuyor:',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'Twitter Bağlantısını Yapılandır',
    'LBL_CONNECT_TEST_FAIL' => 'Hata: Bağlayıcı yapılandırma ayarlarınız geçersiz olabilir. Lütfen sistem yöneticinize başvurun.',
    'LBL_CONFIGURE_TWITTER' => 'Twitter ayarlarını yapılandırmak için yöneticinize başvurun',
    'LBL_MERGE_CONNECTORS' => 'Veriyi Al',
    'LBL_NO_DATA_AVAILABLE' => 'Mevcut veri yok.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'Bu modül için bağlayıcı tanımını etkisiz hale getirmek istediğinizden emin misiniz?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Elastik sunucusuna bağlanmak işlemi başarısız oldu',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'Üzgünüm, global takımı silemezsiniz.',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'Bu özel takım [{0}], [{1}] kullanıcısı silinene kadar silinemez.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'Merhaba, Flash kapalı veya Adobe Flash Player&#39;ın eski bir sürümünü kullanıyorsunuz. Lütfen <a href="http://www.adobe.com/go/getflashplayer/">Flash Player en son versiyonunu indirin</a> veya flash&#39;ı açın.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'İsim',
    'LBL_COLLECTION_PRIMARY' => 'Birincil',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'Zorunlu alan boş',
    'LBL_COLLECTION_EXACT' => 'Kesin',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'IIS/FastCGI sapi kullanımının optimal performansı için, php.ini dosyasında fastcgi.logging değerini 0 olarak belirtin.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'Atanan Kişi',
    'LBL_DESCRIPTION' => 'Tanım',
    'LBL_PRIMARY_CONTACT_NAME' => 'Birincil Kontak',
    'LBL_PRIMARY_CONTACT_ID' => 'Birincil Kontak Kimliği',

    'LBL_NONE' => '-yok-',
    'LBL_YESTERDAY' => 'dün',
    'LBL_TODAY' => 'bugün',
    'LBL_TOMORROW' => 'yarın',
    'LBL_NEXT_WEEK' => 'sonraki hafta',
    'LBL_NEXT_MONDAY' => 'sonraki pazartesi',
    'LBL_NEXT_FRIDAY' => 'sonraki cuma',
    'LBL_TWO_WEEKS' => '2 hafta',
    'LBL_NEXT_MONTH' => 'sonraki ay',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'gelecek ayın ilk günü',
    'LBL_THREE_MONTHS' => 'üç ay',
    'LBL_SIXMONTHS' => 'altı ay',
    'LBL_NEXT_YEAR' => 'Gelecek Yıl',
    'LBL_FILTERED' => 'Filtrelendi',

    //Datetimecombo fields
    'LBL_HOURS' => 'Saat',
    'LBL_MINUTES' => 'Dakika',
    'LBL_MERIDIEM' => 'Meridyen',
    'LBL_DATE' => 'Tarih',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Otomatik-Yenileme',

    'LBL_DURATION_DAY' => 'gün',
    'LBL_DURATION_HOUR' => 'saat',
    'LBL_DURATION_MINUTE' => 'dakika',
    'LBL_DURATION_DAYS' => 'gün',
    'LBL_DURATION_HOURS' => 'saat',
    'LBL_DURATION_MINUTES' => 'dakika',
    'LBL_DURATION_SECONDS' => 'saniye',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'Ay Seçiniz',
    'LBL_ENTER_YEAR' => 'Yılı Giriniz',
    'LBL_ENTER_VALID_YEAR' => 'Lütfen geçerli bir yıl giriniz',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'Lütfen alan kodu da dahil olmak üzere, nümerik bir ABD telefon numarası girin.',
    'LBL_CCP_NOT_INITIATED' => 'Satıcı oturum açmamışken CCP kullanarak Çevirmeye çalışılıyor.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'CCP aracılığıyla çağrı başlatılamıyor.',
    'LBL_CCP_DIALING_ERROR' => 'Bu çağrı, aranarak tamamlanamaz.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'Giden bir arama yapmadan önce lütfen SugarLive&#39;deki sohbet oturumlarını kapatın.',

    //File write error label
    'ERR_FILE_WRITE' => 'Hata: {0} dosyasına yazılamıyor. Lütfen sistem ve web sunucusu izinleri kontrol ediniz.',
    'ERR_FILE_NOT_FOUND' => 'Hata: {0} dosyası yüklenemiyor. Lütfen sistem ve web sunucusu izinleri kontrol ediniz.',

    'LBL_AND' => 'Ve',
    'LBL_BEFORE' => 'Önce',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'Bilgisayarınızdan Yükleyin',
    'LBL_SEARCH_EXTERNAL_API' => 'Harici Kaynak Dosyası',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'Harici kaynağa yükle',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'Harici kaynaktan gelen bağlantı',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'Güvenlik',
    'LBL_SHARE_PRIVATE' => 'Özel',
    'LBL_SHARE_COMPANY' => 'Şirket',
    'LBL_SHARE_LINKABLE' => 'Link oluşturulabilir',
    'LBL_SHARE_PUBLIC' => 'Halka Ait',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS Beslemesi',
    'LBL_RSS_RECORDS_FOUND' => 'kayıt(lar) bulundu',
    'ERR_RSS_INVALID_INPUT' => 'RSS geçerli input_type (giriş tipi) değildir',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS bu yöntem için geçerli bir response_type yanıt tipi değildir',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs, sağlanan dosya biçimini desteklemiyor.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'Boş',
    'LBL_IS_EMPTY' => 'Boş',
    'LBL_IS_NOT_EMPTY' => 'Boş değil',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '"Bu dosya, veri yüklemeye hazır dosyanın içeriğinin nasıl olması gerektiğini gösteren örnek dosyadır."<br />"Bu dosya virgül ile ayrılmış .csv dosyası olup, çift tırnak karakterini alan belirleyici olarak kullanmaktadır."<br /><br />"Başlık satırı dosyadaki en üstteki satırdır ve uygulamada görülen saha etiketlerini içerir."<br />"Bu etiketler uygulamada alanlar ile dosya kolonlarının eşleşmesi için kullanılır."<br /><br />"Not: Veritabanı isimleri, başlık satırında kullanılabilir. Bu özellikle phpMyAdmin veya farklı bir veritabanı aracı kullanarak, verileri yüklemek üzere liste oluşturduğunuzda faydalı olacaktır."<br />"Satır sırası, veri yükleme işlemi başlık satırına göre kolonları eşleştireceği için kritik değildir."<br /><br />"Bu dosyayı bir şablon olarak kullanmak için aşağıdakileri yapın:"<br />"1. Örnek satırlarını silin."<br />"2. Şu anda okuduğunuz yardım metnini kaldırın."<br />"3. kendinize ait verileri uygun satır ve sütunlar koyun"<br />"4. Sisteminizde bilinen bir yerde dosyayı saklayın"<br />"5. Uygulamadaki aksiyon menüsünden veri yüklemeye tıklayın ve dosyayı seçin"',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'Atanmış Kullanıcı ID',
    'LBL_EXPORT_CREATED_BY' => 'Oluşturan ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'Değiştiren ID',
    'LBL_EXPORT_REPORTS_TO_ID' => 'Rapor Edilen Kişi ID',
    'LBL_EXPORT_TEAM_ID' => 'Takım ID',
    'LBL_EXPORT_TEAM_SET_ID' => 'Takım Küme ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Atanan Kullanıcı',
    'LBL_EXPORT_FULL_NAME' => 'Tam İsim',
    'LBL_EXPORT_TEAM_NAME' => 'Takımlar',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Geziniyor...',

    'LBL_PENDING_NOTIFICATIONS' => 'Uyarılar',
    'LBL_ALT_ADD_TEAM_ROW' => 'Yeni takım satırı ekle',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'Takımı kaldır',
    'LBL_ALT_SPOT_SEARCH' => 'Anlık Arama',
    'LBL_ALT_NOT_SORTED' => 'Sıralanmamış',
    'LBL_ALT_SORT_DESC' => 'Azalarak Sıralandı',
    'LBL_ALT_SORT_ASC' => 'Arttırılarak Sıralandı',
    'LBL_ALT_SORTABLE' => 'Sıralanabilir',
    'LBL_ALT_NOT_SORTABLE' => 'Sıralanamaz',
    'LBL_ALT_SORT' => 'Sıra',
    'LBL_ALT_SHOW_OPTIONS' => 'Seçenekleri Göster',
    'LBL_ALT_HIDE_OPTIONS' => 'Seçenekleri Gizle',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'Seçilen girdiyi soldaki listeye taşı',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Seçilen girdiyi sağdaki listeye taşı',
    'LBL_ALT_MOVE_COLUMN_UP' => 'Görüntülenen listede seçili girdiyi yukarı taşı',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'Görüntülenen liste sıralamasında seçili girdiyi aşağı taşı',
    'LBL_ALT_INFO' => 'Bilgi',
    'MSG_DUPLICATE' => 'Oluşturmak istediğiniz kayıt {0} zaten var olan bir {0} kaydının kopyası olabilir. Benzer isimler içeren {1} kayıtları aşağıda listelenmiştir. <br> {0} yeni kaydı için {1} Oluştur butonuna basın veya aşağıda listelenen {0} değerlerinden birini seçin.',
    'MSG_SHOW_DUPLICATES' => 'Oluşturmak istediğiniz {0} kaydı zaten var olan bir {0} kaydının kopyası olabilir. İsimleri benzeyen {1} kayıt aşağıda listelenmektedir. {0} için kayıt oluşturmaya devam etmek için Kaydet, oluşturmadan modüle dönmek için İptal tuşunu tıklayınız.',
    'LBL_EMAIL_TITLE' => 'e-posta adresi',
    'LBL_EMAIL_OPT_TITLE' => 'liste dışına çıkmış E-Posta adresi',
    'LBL_EMAIL_INV_TITLE' => 'Geçersiz e-Posta adresi',
    'LBL_EMAIL_PRIM_TITLE' => 'birincil e-posta adresi',
    'LBL_SELECT_ALL_TITLE' => 'Tüm kayıtlar',
    'LBL_SELECT_THIS_ROW_TITLE' => 'Bu satırı seç',
    'LBL_TEAM_SELECTED_TITLE' => 'Takım Seçildi',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Bu takımı birincil yapmak için seçin',
    'LBL_TEAM_TBSELECTED_TITLE' => 'Takım, Takım Bazlı Seçildi olarak işaretlendi ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'Bu takımı, Takım Bazlı Seçildi olarak işaretle',
    'LBL_SEARCH_AND_SELECT' => 'Ara ve Seç {{module}}',
    'TPL_SEARCH_AND_ADD' => 'Arama ve Ekleme {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'HATA: Yükleme esnasında bir hata oluştu. Hata kodu: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'HATA: Yükleme esnasında bir hata oluştu. Hata kodu: {0} - {1}.Upload_maxsize değeri: {2}',
    'UPLOAD_ERROR_HOME_TEXT' => 'HATA: Yükleme esnasında bir hata oldu, lütfen yardım için yöneticiniz ile irtibata geçiniz.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'Yükleme boyutu ({0} bayt) Maksimum Verilen İzin Miktarı : ({1} bayt) aştı',
    'UPLOAD_REQUEST_ERROR' => 'Bir hata oluştu. Lütfen sayfayı yenileyin ve tekrar deneyin.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'E',
    'LBL_EDIT_BUTTON_LABEL' => 'Değiştir',
    'LBL_ADD_BUTTON_LABEL' => 'Ekle',
    'LBL_EDIT_BUTTON_TITLE' => 'Değiştir',
    'LBL_REFRESH_BUTTON_LABEL' => 'Yenile',
    'LBL_REFRESH_BUTTON_TITLE' => 'Yenile',
    'LBL_DUPLICATE_BUTTON_KEY' => 'u',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Aynı Kayıttan Oluştur',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Aynı Kayıttan Oluştur',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'Planları Raporla',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'Planları Raporla',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'Rapor Detayları',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'Rapor Detayları',
    'LBL_DELETE_BUTTON_KEY' => 'D',
    'LBL_DELETE_BUTTON_LABEL' => 'Sil',
    'LBL_DELETE_BUTTON_TITLE' => 'Sil',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => 'Kaydet',
    'LBL_SAVE_BUTTON_TITLE' => 'Kaydet',
    'LBL_CANCEL_BUTTON_KEY' => 'X',
    'LBL_CANCEL_BUTTON_LABEL' => 'İptal',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'durdurmak için.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => '(sayfada kalmak için).',
    'LBL_CANCEL_BUTTON_TITLE' => 'İptal',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'Paylaş',
    'LBL_SHARE_BUTTON_TITLE' => 'Paylaş',
    'LBL_START_BUTTON_LABEL' => 'Başlangıç',
    'LBL_START_BUTTON_TITLE' => 'Başlangıç',
    'LBL_FINISH_BUTTON_LABEL' => 'Bitir',
    'LBL_FINISH_BUTTON_TITLE' => 'Bitir',
    'LBL_CONFIRM_BUTTON_LABEL' => 'Tamam',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => '(devam etmek için).',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => '(sayfadan ayrılmak ve değişiklikleri iptal etmek için).',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Klavye Kısa yolları',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Form Fonksiyonları - Alt+</strong><br/> I = Düzenle (DetaylıGörünüm)<br/> U = Kopyala (DetaylıGörünüm)<br/> D = Sil (DetaylıGörünüm)<br/> A = Kaydet (DeğişiklikGörünümü)<br/> L = İptal (DeğişiklikGörünümü) <br/><br/></p><p><strong>Ara ve Git  - Alt+</strong><br/> 7 = Değiştirme formunda ilk alan<br/> 8 = Detaylı Arama linki<br/> 9 = İlk Arama Formu alanı<br/> 0 = Birleştirilmiş arama girişi<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'Artır',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'Paylaş',
    'TPL_RECORD_SHARE_SUBJECT' => '{{appId}} içinde {{module}} {{name}} paylaşıldı',
    'TPL_RECORD_SHARE_BODY' => 'Lütfen {{appId}} içinden {{module}} {{name}} alın',

    'ERR_CONNECTOR_NOT_ARRAY' => 'Giriş bağlantı dizisi {0} yanlış tanımlanmış yada boş ve kullanılamaz durumda.',
    'LBL_PDF_VIEW' => 'PDF Yükle',
    'LBL_PDF_EMAIL' => 'PDF E-Postala',

    'ERR_SUHOSIN' => 'Yükleme akışı, Suhosin tarafından engellendi suhosin.executor.include için \\"yükleme\\" ekleyin.<br />(Daha fazla bilgi için sugarcrm.log bakınız)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'hemen şimdi',
    'LBL_TIME_AGO_SECONDS' => 'bir dakikadan daha kısa bir süre önce',
    'LBL_TIME_AGO_MINUTE' => 'yaklaşık 1 dakika önce',
    'LBL_TIME_AGO_MINUTES' => '{{this}} dakika önce',
    'LBL_TIME_AGO_HOUR' => 'yaklaşık 1 saat önce',
    'LBL_TIME_AGO_HOURS' => '{{this}} saat önce',
    'LBL_TIME_AGO_DAY' => 'dün',
    'LBL_TIME_AGO_DAYS' => '{{this}} gün önce',
    'LBL_TIME_AGO_YEAR' => 'bir yıl kadar önce',
    'LBL_TIME_UNTIL_SECONDS' => 'bir dakikadan az sürede',
    'LBL_TIME_UNTIL_MINUTE' => 'yaklaşık 1 dakika içinde',
    'LBL_TIME_UNTIL_MINUTES' => '{{this}} dakika içinde',
    'LBL_TIME_UNTIL_HOUR' => 'yaklaşık bir saat içinde',
    'LBL_TIME_UNTIL_HOURS' => '{{this}} saatte',
    'LBL_TIME_UNTIL_DAY' => 'yarın',
    'LBL_TIME_UNTIL_DAYS' => '{{this}} günde',
    'LBL_TIME_UNTIL_YEAR' => 'bir yıl içinde',
    'LBL_TIME_RELATIVE' => '{{date}} tarihinde, {{time}} saatinde {{relativetime}} girildi',
    'LBL_LAST_TOUCHED' => 'Son erişim: {{relativetime}}  / Tarih: {{date}} Saat:{{time}}',
    'LBL_LAST_COMMIT' => 'Son Onay: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'Mevcut veri yok.',
    'LBL_DETAILVIEW_NO_RECORDS' => 'Bu kayıt şu  anda gösterilemiyor.',
    'LBL_REFINE_LIST' => 'Listeyi daraltın',
    'LBL_SEARCH_BY' => 'Arama şekli:',
    'LBL_PREVIEW' => 'Ön izleme',
    'LBL_COLUMNS' => 'Sütunlar',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'Önizleme devre dışı: Veri yok',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'Önizleme devre dışı: Kayıda erişim izni yok',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'Önizleme devre dışı: Veri yok',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'Ön izleme devre dışı: Mevcut kayıt görünümü',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'Önizleme devre dışı: Kayıt silindi veya kayıda erişim izni yok',
    'LBL_PREVIEW_PREVIOUS' => 'Önceki önizleme',
    'LBL_PREVIEW_NEXT' => 'Sonraki önizleme',
    'LBL_PREVIEW_CLOSE' => 'Önzilemeyi kapat',
    'LBL_STREAM_NO_RECORDS' => 'Bu kayıta eklemiş bir not yok. Not ekle bağlantısına tıklayarak bir not ekleyin.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} çift kayıt bulundu.',
    'LBL_NO_DUPLICATES_FOUND' => 'Yinelenen bulunamadı.',
    'LBL_RESET_DEFAULT_VIEW' => 'Varsayılan görünümü sıfırla',
    'LBL_RESET_DEFAULT_WIDTHS' => 'Varsayılan genişlikleri sıfırla',
    'LBL_TIMEZONE_UPDATED' => 'Sugar, kullanıcı profilinizin saat dilimini tarayıcınızın saat dilimiyle eşleşecek şekilde güncelledi',
    'LBL_SUCCESS' => 'Başarılı',
    'LBL_ERROR' => 'Hata',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'Birleştir',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'Devam etmek istiyor musunuz?',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'Bu aksiyon, aşağıdaki kayıtları silecektir:',
    'LBL_MERGE' => 'Birleştir',
    'TPL_MERGING_RECORDS' => '{{mergeCount}} Kayıt Birleştiriliyor',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'Hatalı kayıt sayısı. Geçerli aralık {{minRecords}} ile {{maxRecords}} arası.',
    'LBL_MERGE_NO_ACCESS' =>
        'Bu işlemi gerçekleştirmek için erişim hakkınız yok',
    'LBL_MERGE_LOCKED' => 'Birleştirilmek üzere seçilen kayıtlardan bazıları, bir süreç tarafından düzenlemeye karşı kilitli olan alanlar içeriyor ve bu kez birleştirilemez.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'Birincil kaydı yapmış olduğunuz değişiklikleri kaydetmeden asıl kaydı değiştirmek üzeresiniz. Bütün değişiklikler kaybedilecek. Devam etmek istediğinize emin misiniz?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'İlişkili Kayıtları Birleştir',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'Birleştirilen: %{{percent}}',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'İlişkili {{objectName}} birleştirme işlemi başarısız oldu. Yeniden deneniyor ({{num}} / {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'İlişkili {{objectName}} birleştirilme işlemi başarısız oldu.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'İlişkili Kayıtların Birleştirilmesi tamamlanamadı. Bazı kayıtlar Birleştirilmemiş kaldı.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'İlişkili Kayıtların Birleştirilme İşlemi tamamlanmadı. Bazı kayıtlar birleştirilmemiş kaldı. Devam etmek istiyor musunuz?',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'İlişkili tüm kayıtlar Birincil kayda taşınacaktır.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'Birleştirme işlemi bu kaydı kaldıracak emin misiniz?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'Birleştirme işleminden kaydı kaldır',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'Geçersiz kayıt sayısını geçildi. Geçerli aralık 1 ile {{maxRecords}} arasındadır.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'Girilen kullanıcı adı/şifre kombinasyonu yanlış, lütfen tekrar deneyin.',
    'LBL_INVALID_CREDS_TITLE' => 'Geçersiz Kimlik',
    'LBL_INVALID_GRANT' => 'Simgeniz geçersiz veya süresi dolmuş. Lütfen tekrar giriş yapın.',
    'LBL_INVALID_GRANT_TITLE' => 'Anahtar Süresi Dolmuş',
    'LBL_AUTH_FAILED' => 'İstemci kimlik doğrulaması başarısız oldu.',
    'LBL_AUTH_FAILED_TITLE' => 'Geçersiz istemci',
    'LBL_INVALID_REQUEST' => 'Yapılan istek geçersiz veya bozuk. Lütfen teknik destek ekibine başvurun.',
    'LBL_INVALID_REQUEST_TITLE' => 'Geçersiz İstek',
    'LBL_REQUEST_TIMEOUT' => 'Sunucu yanıt vermiyor. İnternet bağlantınızı kontrol edin.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'İstek zaman aşımına uğradı:',
    'LBL_UNAUTHORIZED' => 'Üzgünüz, ancak bu kaynağa erişmeye hakkınız yok.',
    'LBL_UNAUTHORIZED_TITLE' => 'İzinsiz',
    'LBL_RESOURCE_UNAVAILABLE' => 'Kaynak bulunamadı.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'Yasak',
    'LBL_METHOD_NOT_ALLOWED' => 'Bu kaynak için HTTP metoduna izin verilmiyor. Lütfen teknik destek ekibine başvurun.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'İzin Verilmeyen Metod',
    'LBL_PRECONDITION_MISSING' => 'İstek hatası yada eksik / geçersiz parametre. Lütfen teknik desteğe başvurun',
    'LBL_PRECONDITION_MISSING_TITLE' => 'Hata:',
    'LBL_INVALID_412_RESPONSE' => 'Bir talep uygulamayı çalışmaz hale getirerek hata almaktadır. Lütfen teknik destek ile görüşün.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => '{1} modülündeki {0} alanı için düzenlemeye izin yok',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'Bu kayıt üzerinde "{0}" işlemine izin verilmemektedir',
    'LBL_LOGIN_BUTTON_LABEL' => 'Giriş',
    'LBL_ACTIVITY_VIEW_TOUR' => 'Aktivite Görünüm Turu',
    'LNK_TOUR' => 'Tur',
    'LNK_MOBILE' => 'Cep Telefonu',
    'LBL_FEEDBACK' => 'Geri Bildirim',
    'LBL_SUPPORT' => 'Destek',
    'LBL_LANGUAGE' => 'Dil',
    'LBL_LOADING_LANGUAGE' => 'Dil paketi yükleniyor',
    'LBL_UPLOADING' => 'Yükleniyor',
    'LBL_UPLOADING_DOTS' => 'Yükleniyor...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'Bu resmi silmek istediğinizden emin misiniz?',
    'LBL_FILE_DELETE_CONFIRM' => 'Bu dosyayı silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.',
    'LBL_FILE_DELETED' => 'Dosya başarıyla silindi',

    //theme roller
    'LBL_PORTAL_THEME' => 'Portal Teması',
    'LBL_THEME_PREVIEW' => 'Portal Teması Ön Görünümü',
    'LBL_LOADING_PREVIEW' => 'Önizleme Yükleniyor',
    'LBL_RESET' => 'Sıfırla',
    'LBL_COLORS' => 'Renkler',
    'BorderColor' => 'Çerçeve Rengi',
    'NavigationBar' => 'Navigasyon Bar',
    'PrimaryButton' => 'Birincil Buton',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'Kaydet & Uygula',
    'LBL_RESET_THEME_LNK' => 'Varsayılan Temayı Geri Yükle',
    'LBL_RESET_THEME_MODAL_INFO' => 'Özel temanızı, varsayılan tema ile silmek üzeresiniz.',
    'LBL_RESET_THEME_PROCESS' => 'Varsayılan tema geri yükleniyor...',
    'LBL_SAVE_THEME_PROCESS' => 'Tema kaydediliyor...',

    // image loader
    'LBL_SELECT_PHOTO' => 'Resim Seç',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Sugar içinde gelişmiş satış tahmin işlevi',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Tahmin parametrelerinizi ayarlayın</li><li class="icon-ok">Kolayca öngörülen satış ve hedefleri takip edin</li><li class="icon-ok">Satış ekibinden gelen öngörülere göre satış tahmini oluşturun</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'Tahmin parametrelerinizi ayarlayın',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Mali yılın başlangıç ​​tarihini seçin</li><li class="icon-ok">Zaman Periyodunu yıllık veya üçer aylık  olacak şekilde ayarlayın</li><li class="icon-ok">Çalışma sayfasında ka adet geçmiş ve gelecek Zaman Periyodu görünür olmasını istediğinize karar verin</li><li class="icon-ok">Fırsatları Dahil, Hariç veya Yükselmesi Olası şeklinde işaretlemek için Tahim aralığını seçin,</li><li class="icon-ok">Tahmin senaryolarını Muhtemel, En İyi ve En Kötü olacak şekilde için tahmin senaryolarını seçin</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'Satış Takımınızın Öngörülen Satışlarını Yönetin',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Tahminleri tekrar gözden geçirmek için Zaman Peridoyunu seçin</li><li class="icon-ok"> Satış ekip üyelerinizin çalışma sayfalarını görüntüleyip düzeltilmiş tahminlere ulaşın</li><li class="icon-ok">Satış ekibi üyesi yeni bir tahmini onayladığında, çalışma sayfasında uyarı görün</li><li class="icon-ok">Tahmin çalışma sayfasını Taslak versiyon olarak kaydedin veya yöneticinizin görmesi için onaylayın</li><li class="icon-ok">Daha önceki onayların tarihçesini görün.</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'Satış Takımınızın Öngörülen Satışlarını Yönetin',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Tüm satış ekip üyelerinin tahminleri üzerinden analiz için Pareto grafiğini görüntüleyin</li><li class="icon-ok">Olası, En İyi veya En Kötü Tahmin değerlerine göre satış öngörülerini görselleştirin</li><li class="icon-ok">Öngörülen satışları inceleyip, takımın kotasını nasıl gerçekleştirebileceğini belirleyin</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'Öngörülen Satışlarınızı Yönetin',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Satış Tahminleri için Zaman Periyodunu seçin</li><li class="icon-ok">Kazanma Olasılıklarını inceleyip hızlı bir ne-olurdu (what-if) analizi için değişiklik yapın</li><li class="icon-ok">Tahmin çalışma sayfasını Taslak versiyon olarak kaydedin veya yöneticinizin görmesi için onaylayın</li><li class="icon-ok">Daha önceki onayların tarihçesini görün.</li><li class="icon-ok">Satış tahminlerini yöneticiniz için onaylayın  ve geçiş onay tarihçesini görün</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'Öngörülen Satışlarınızı Yönetin',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Fırsatlarınıza ait satış öngörüsünün zamana göre analizi için Pareto grafiği görüntüleyin</li><li class="icon-ok">Satış  Aşaması veya Kazanma Olasılığına göre satış öngörülerini görselleştirin</li><li class="icon-ok">Öngörülen satışları inceleyip, kotasınızı nasıl gerçekleştirebileceğinizi belirleyin</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Sugar&#39;a Hoşgeldiniz',
    'LBL_TOUR_WATCH' => 'Sugar&#39;da Neler Yeni İzle',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="icon-ok">Gelişmiş görünüm  - artık yeni ve modern bir tema ile.</li><li class="icon-ok">Gelişmiş Tahminler modülü - Şimdi kolay bir kullanıcı arayüzü ve yeni veri görselleştirmesi ile</li></ul>',
    'LBL_TOUR_VISIT' => 'Daha fazla bilgi için uygulamamızı ziyaret edin',
    'LBL_TOUR_DONE' => 'İşleminiz Bitti!',
    'LBL_TOUR_REFERENCE_1' => 'Her zaman daha fazla bilgi için:',
    'LBL_TOUR_REFERENCE_2' => 'profil menüsü altındaki "Destek" bağlantısını kullanarak.',
    'LNK_TOUR_DOCUMENTATION' => 'dokümantasyon',
    'LBL_TOUR_CALENDAR_URL_1' => 'Bu tür Microsoft Outlook veya Exchange gibi 3. parti uygulamalar ile SugarCRM takvimini paylaşıyor musunuz? Eğer öyleyse, yeni bir URL var. Bu yeni ve daha güvenli URL, takvimin  izinsiz olarak yayınlanmasına engel olucak kişisel bir anahtar içerir.',
    'LBL_TOUR_CALENDAR_URL_2' => 'Yeni paylaşılan takvim Url adresini al.',
    'LBL_TOUR_CUBE' => 'Dashboard ve Aktivite Akışına Erişim',
    'LBL_TOUR_NAV_BAR' => 'Navigasyon menüsünden tüm modüllere erişim yapıp aksiyon al',
    'LBL_TOUR_NOTIFICATIONS' => 'Bildirimleri görmek için tıklayın',
    'LBL_TOUR_SEARCH' => 'Bir veya daha fazla modül seçin ve arayın',
    'LBL_TOUR_AVATAR' => 'Uygulama hakkında daha fazla bilgi alın veya uygulamadan çıkın',
    'LBL_TOUR_ADD' => 'Buradan bir kayıt oluşturun',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'Akıllı Bilgi bölmesini kapatmak veya açmak için tıklayın',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'Aktiviteleri veya kayıt listesini görmek için seçin',
    'LBL_TOUR_LIST_FILTER1' => 'Filtre çubuğu bu modül için arama sağlar',
    'LBL_TOUR_LIST_FILTER2' => 'Önceden tanımlanmış bir filtre seçin ya da yeni oluşturun',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'İsme göre sorgulamak için buraya yazın',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'Değiştirmek veya detaylarını önizleme yapmak için kayıt seçin',
    'LBL_TOUR_RECORD_ACTIONS' => 'Kayıt üzerinde aksiyon alın',
    'LBL_TOUR_RECORD_SUBPANEL' => 'Alt paneli genişletmek ve daraltmak için başlığa tıklayın',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'Kayıt ismi yerinde güncellenebilir',
    'LBL_TOUR_RECORD_STATUS' => 'Kayıt seviye durumunu burada bulabilirsiniz',
    'LBL_TOUR_RECORD_SHOWMORE' => 'Kayıt ile ilgili daha fazla veri görmek için tıklayın',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'Aktiviteleri veya ilgili kayıtları görmek için seçin',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'Bulunduğu yerde kaydı değiştirmek için tıklayın',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'yeni Dashlet grupları oluşturun',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'Dashlets grubuna bir isim verin',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'Kaldırmak veya ayarlarını değiştirmek için Dashlet seçin',
    'LBL_TOUR_INTRO' =>'<h4> Sugar uygulamasına hoş geldiniz</h4> Bazı özellikleri size tanıtmak istiyoruz.  Ekranın altındaki < ve > ok tuşlarını kullanarak turu yönlendirebilirsiniz.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">Yeni özellikler</a><p class="details">Versiyonlar arasındaki önemli farkları görün.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Sugar hakkında daha fazla bilgiye erişin.</a><p class="details">Sağlam uzaktan eğitim kütüphanesi, gerçek ve sanal sınıf eğitimleri, web oturumları ve video içeriği.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">Get Support</a><p class="details">Yardıma mı ihtiyacınız var, problem mi var veya Sugar uygulamasının daha iyi olması için bir öneriniz mi var?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'Kayıtların listesini görün ve aksiyon alın.',
    'LBL_TOUR_RECORD_INTRO' => 'Bu kayıtın detaylarını ve bütün ilişkili bilgiyi görün.',
    'LBL_TOUR_FORECAST_INTRO' => 'Payplany ve satış tahminleri yönetimi.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'Karşılık gelen satış tahmini görmek için bir zaman aralığı seçin',
    'LBL_TOUR_FORECASTS_COMMITS' => 'Bir önceki onayları görmek için tıklayın',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'Veri satırını düzenlemek için tıklayın',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'Kotaya kalanı gösterin',
    'LBL_TOUR_FORECASTS_CHART' => 'Satış Tahmini dağılımını gözden geçirin',
    'LBL_TOUR_TOUR' => 'Tura istediğiniz zaman erişim',
    'LBL_TOUR_TAGS_ADD' => 'Etiketleri eklemek ve kaldırmak için etiket alanlarına tıklayın',
    'LBL_TOUR_TAGS_DELETE' => 'Bir etiketi silmek için backspace tuşunu kullanın veya her etikette bulunan [X] butonuna tıklayın',
    'LBL_TOUR_RECORD_SAVE' => 'Hazır olduğunuzda Kaydet&#39;e tıklayın',


    'LBL_FUTURE' => 'Gelecek',
    'LBL_REQUIRED_FIELD' => 'Zorunlu',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'Teklif Kalemi',
    'LBL_DISCOUNT_TOTAL' => 'İndirim toplamı',
    'LBL_DISCOUNT_PERCENT' => 'Yüzde % ',
    'LBL_DISCOUNT_SELECT' => 'İndirimin yüzde mi yoksa sabit tutar mı olduğunu belirler',
    'LBL_TAX' => 'Vergi',
    'LBL_SHIPPING' => 'Nakliyat',
    'LBL_GRAND_TOTAL' => 'Genel Toplam',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'Fatura adresini Hesap profilinden otomatik doldur',
    'LBL_QLI_ADD_GROUP' => 'Bir Grup Ekle',
    'LBL_QLI_COMMENT' => 'Açıklama',
    'LBL_SELECT_ACTION' => 'Aksiyon Seç',
    'LBL_QLI_GROUP_NAME' => 'Grup İsmi',
    'LBL_GROUP_TOTAL' => 'Grup Toplamı',
    'LBL_ITEM_NAME' => 'Kalem',
    'LBL_QLI_DELETE' => 'Bu kalemi silmek istediğinizden emin misiniz?',
    'LBL_QLI_COMMENT_DELETE' => 'Bu kalem açıklamasını silmek istediğinizden emin misiniz?',
    'LBL_QLI_GROUP_DELETE' => '{0} grubunu silmek istediğinizden emin misiniz? Tüm öğeler, varsayılan gruba taşınacak.',
    'LBL_QLI_GROUP_EMPTY' => 'Teklif Kalemi Yok',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'İsteğe Bağlı',
    'LBL_RELATED_MODULE' => '{{{this}}} İlişkili',
    'LBL_RELATED_MODULE_PLURAL' => '{{{this}}} İlişkili',
    'LBL_CREATE_MODULE' => '{{{this}}} Oluştur',
    'LBL_EDIT' => 'Düzenle {{{this}}}',
    'LBL_ASSOC' => 'İlişkili {{{this}}}',
    'LBL_ASSIGN' => 'Seçin {{{this}}}',
    'LBL_EDIT_RELATED' => 'İlişki {{{this}}} kaydı Düzenle',
    'LBL_CREATE_RELATED' => 'İlişkili {{{this}}} Oluştur',
    'LBL_ASSOC_EXISTING' => 'Mevcut {{{this}}} ile bağla',
    'LBL_SEARCH_ALL' => 'Tümünü ara : {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'Tüm kayıtlar ara...',
    'LBL_SEARCH_ALL_MODULES' => 'Tümünü Ara',
    'LBL_OK' => 'Tamam',
    'LBL_YES' => 'Evet',
    'LBL_NO' => 'Hayır',
    'LBL_SHOW_NUMBERING' => 'Aşama numaralandırmasını göster',
    'LBL_HIDE_NUMBERING' => 'Aşama numaralandırmasını gizle',
    'LBL_CALL_BUTTON' => 'Tel.Araması',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'E-Posta',
    'LBL_HONEYPOT' => 'Gerçek kişi iseniz bu alanı doldurmayın.',
    'LBL_LINK_BUTTON' => 'Bağlantı',
    'LBL_UNLINK_BUTTON' => 'Bağlantıyı Kaldır',
    'LBL_MAP_BUTTON' => 'Harita',
    'LBL_FILE_BUTTON' => 'Dosya adı',
    'LBL_URL_BUTTON' => 'Web',
    'LBL_WARNING' => 'Uyarı',
    'LBL_CONFIRM' => 'Onayla',
    'LBL_CONFIRMATION_POPUP' => 'Onay Açılır Penceresi',
    'LBL_NO_ACCESS' => '(Erişim yok)',
    'LBL_NO_ACCESS_LOWER' => 'Kullanıcının kayda erişim hakkı bulunmamaktadır',
    'LBL_NO_FIELD_ACCESS' => 'Erişim yok',
    'LBL_NO_LICENSE_ACCESS' => 'Lisans Gerekli',
    'LBL_VALUE_ERASED' => 'Değer Silindi',
    'LBL_VALUE_ERASED_TOOLTIP' => 'Bu bilgiler, veri gizliliği isteği vasıtasıyla silindi',
    'LBL_CREATE_RELATED_RECORD' => 'İlişkili Kayıt Oluştur',
    'LBL_ASSOC_RELATED_RECORD' => 'Mevcut Kayıt ile Bağla',
    'LBL_CHOOSE_LINK' => 'Bağlantı Tipini seçiniz',
    'LBL_CHOOSE_PARENT_TYPE' => 'Ana Kayıt Tipini seçiniz',
    'LBL_HOME' => 'Ana Sayfa',
    'ERR_NO_DOCS' => 'Doküman Mevcut Değil',
    'ERR_NO_RECORDS_SELECTED' => 'Herhangi bir kayıt seçmediniz.',
    'LBL_DELETING' => 'Siliyor...',
    'LBL_UNLINKING' => 'Bağlantıları Kaldırıyor...',
    'LBL_UNLINKED' => 'Bağlantı Kaldırılmış',
    'LBL_LEGAL' => 'Yasal',
    'LBL_UPCOMING' => 'Yaklaşan Etkinliklerim',
    'LBL_RECENTLY_UPDATED' => 'Kısa süre önce Güncellendi',
    'LBL_NOTES_SUBPANEL_TITLE' => 'Notlar',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'Toplantılar',
    'LBL_TASKS_SUBPANEL_TITLE' => 'Görevler',
    'LBL_CALLS_SUBPANEL_TITLE' => 'Aramalar',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'Hesaplar',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'Kontaklar',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'E-Postalar',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'Vardiyalar',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'Teklif Kalemleri',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'Vardiya İstisnaları',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'Dokümanlar',
    'LBL_ESCALATIONS' => 'Artışlar',
    'LBL_ESCALATED' => 'Arttı',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'Artışlar',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'Diğer İlgili Artışlar',
    'LBL_ESCALATIONS' => 'Artışlar',
    'LNK_SETTINGS' => 'Ayarlar',
    'LBL_MOBILE_SUPPORT' => 'Destek',
    'LBL_MOBILE_SHOW_MORE' => 'Daha fazlasını göster...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'Daha fazlasını göster...',
    'LBL_MOBILE_NO_RECORDS' => 'Kayıt bulunamadı',
    'LBL_MOBILE_SEARCH_TEAMS' => 'Takımları ara...',
    'LBL_MOBILE_SELECT_TEAMS' => 'Takım Seç',
    'LBL_MOBILE_WAIT' => 'Lütfen bekleyin...',
    'LBL_MOBILE_LOGING_OUT' => 'Oturum kapatılıyor lütfen bekleyin...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'Tekrar oturum açın',
    'LBL_MOBILE_META_SYNC_FAILED' => 'Sunucu ile senkronize edilemiyor. Tekrar dene?',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'Sunucu ile senkronize edilemiyor. Tekrar denensin mi?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'Gizlilik, Şartlar & Koşullar',
    'LBL_MOBILE_APP_VERSION' => 'Uygulama Veriyonu',
    'LBL_MOBILE_SERVER_VERSION' => 'Sunucu Versiyonu',
    'LBL_MOBILE_SERVER_URL' => 'Sunucu URL&#39;si',
    'LBL_MOBILE_PTR_PULL' => 'Yenilemek için aşağı çekin...',
    'LBL_MOBILE_PTR_RELEASE' => 'Yenilemek için bırakın ...',
    'LBL_MOBILE_EDIT_REL' => 'İlişkileri Düzenle',
    'LBL_MOBILE_DESKTOP' => 'Masaüstü Sürümü',
    'LBL_MOBILE_DELETE_CONFIRM' => 'Bu kaydı silmek istediğinizden emin misiniz?',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'Bu kaydın bağlantısını kaldırmak istediğinizden emin misiniz?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'Yaptığınız en son çağrıyı kayıt altına almak ister misiniz?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'Alıcı seçiniz',
    'LBL_MOBILE_CHOOSE_PHONE' => 'Telefon numarası seçiniz',
    'LBL_MOBILE_CHOOSE_URL' => 'URL seçiniz',
    'LBL_MOBILE_CHOOSE_DOC' => 'Doküman seçin',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'Konumu seçiniz',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'Aksiyon Mevcut Değil',
    'LBL_MOBILE_FEEDBACK' => 'Geri Bildirim',
    'LBL_MOBILE_DOC' => 'Doküman',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'İndirme başladı: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'İndirme tamamlandı: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'Dosya yükleniyor...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'Dosya başarıyla yüklendi',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'Resim Hazırlanıyor ...',
    'LBL_CLOSE_SAVE_BUTTON' => 'Görevi kaydet ve çık',
    'LBL_LATER' => 'Sonra',
    'LBL_USE_HTTPS' => 'Güvenli bağlantı kullan',
    'LBL_LOADING_FILES' => 'Hala döküman listesini yüklüyor. Lütfen daha sonra tekrar deneyin',
    'LBL_NEW_WEB_VERSION' => 'SugarCRM Mobil ürününün yeni sürümü mevcuttur. Güncelleştirmek istiyor musunuz?',
    'LBL_SET_FONTSIZE' => 'Font büyüklüğü',
    'LBL_FONTSIZE_TINY' => 'Ufacık',
    'LBL_FONTSIZE_SMALL' => 'Küçük',
    'LBL_FONTSIZE_NORMAL' => 'Normal (varsayılan)',
    'LBL_FONTSIZE_LARGE' => 'Büyük',
    'LBL_FONTSIZE_LARGER' => 'Daha büyük',
    'LBL_FONTSIZE_HUGE' => 'Daha büyük',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'Ekstra Büyük',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "İndirme başarısız oldu\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'Daha fazla...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '… Daha az',
    'LBL_OFFLINE_MODE' => 'Çevrimdışı Modu',
    'LBL_OFFLINE_DELETED' => 'Kayıt bulunamadı. Muhtemelen silinmiş.',
    'LBL_OFFLINE_DELETED_RELATED' => 'İlişkili kayıt bulunamadı. Muhtemelen kayıt silindi veya ilişki kaldırıldı.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'Atanan, favori olarak işaretlenen ve izlediğiniz kayıtların çevrimdışı erişim erişimi için indirilmesi zaman alabilir. Hızlı bir bağlantı önerilmektedir. Devam etmek istiyor musunuz?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'Atanan, favori olarak işaretlenen ve izlediğiniz kayıtların çevrimdışı erişim erişimi için indirilmesini istiyor musunuz? Bu işlem zaman alacağı için, hızlı bir bağlantı önerilmektedir.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'Kayıtlar başarıyla indirildi',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'Kayıtlarınızı indiriniz...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'Kayıtları indirirken hata',
    'LBL_OFFLINE_PREFETCHING' => 'Kayıtlar yükleniyor…',
    'LBL_OFFLINE_PREFETCHING_MODULE' => '{{module}} Yükleniyor: {{progressValue}}',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'Yaklaşık kalan zaman: {{estimatedTime}}',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => '{{module}} yüklemesi tamamlandı',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'Kayıt Alanını temizliyor...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'Temizleme tamamlandı',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'Bu değişikliği geri almak istiyor musunuz?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'Geri alma tamamlandı',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'Geri alma başarısız oldu',
    'LBL_OFFLINE_CLEAR_DB' => 'Kayıt AlanınıTemizle...',
    'LBL_OFFLINE_COMPACT_DB' => 'Kayıt Alanını sıkıştır...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'Bu aksiyon, bir süredir ulaşmadığınız kayıtları siler. Devam?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'Lokal depolama biriminden bütün kayıtları silmek istiyor musunuz?',
    'LNK_OFFLINE_SETTINGS' => 'Çevrimdışı',
    'LBL_OFFLINE_SETTINGS' => 'Hata ayıklama ayarları',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'Senkronizasyon bekleyen değişiklik yok.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'Senkronizasyon bekleyen değişiklikler.',
    'LBL_OFFLINE_STATUS_ONLINE' => 'Cihaz çevrimiçi.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'Cihaz çevrimdışı.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'Sunucuya erişilemedi.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'Son senkronizasyon denemesi başarısız oldu. İşlem log dosyasını kontrol ediniz.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'Senkronizasyon devam ediyor...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'İşlem senkronized edildi.',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'Çevrimdışı desteği aktive etmek istediğinizden emin misiniz?',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'Çevrimdışı desteği kapatmak istiyor musunuz?  Senkronizasyon bekleyen bütün değişiklikler kaybolacak.',
    'LBL_OFFLINE_ENABLED' => 'Çevrimdışı modu aktive edildi',
    'LBL_OFFLINE_DISABLED' => 'Çevrimdışı mod devre dışı',
    'LBL_OFFLINE_STATS' => 'Kayıt Alanı istatistikleri',
    'LBL_OFFLINE_SERVER_FETCH' => 'Sunucudan alınıyor...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'Sunucudaki aynı kayıt bir başkası tarafından değiştirildi. Otomatik olarak değişiklikleri birleştirmek için onaylayınız veya iptal ediniz.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'Son senkronizasyon denemesi: {{ts}}',
    'LBL_ACTION_UPDATE' => 'DEĞİŞTİR',
    'LBL_ACTION_CREATE' => 'OLUŞTUR',
    'LBL_ACTION_DELETE' => 'SİL',
    'LBL_ACTION_LINK' => 'BAĞLANTI',
    'LBL_ACTION_UNLINK' => 'BAĞLANTI KALDIR',
    'LBL_ACTION_FAVORITE' => 'FAVORİ',
    'LBL_ACTION_FOLLOW' => 'İZLE',
    'LBL_ACTION_CREATE_EXPLANATION' => '{{module}} "{{name}}" Oluşturuldu',
    'LBL_ACTION_UPDATE_EXPLANATION' => '{{module}} "{{name}}" Güncellendi',
    'LBL_ACTION_DELETE_EXPLANATION' => '{{module}} "{{name}}" Silindi',
    'LBL_ACTION_LINK_EXPLANATION' => 'Modül {{module}} / "{{name}}",  {{relatedModule}} / "{{relatedName}}" ile ilişkilendirildi.',
    'LBL_ACTION_UNLINK_EXPLANATION' => '{{module}} / "{{name}}" ile {{relatedModule}} / "{{relatedName}}" arasındaki ilişki kaldırıldı',
    'LBL_ACTION_FOLLOW_EXPLANATION' => '{{module}} "{{name}}" İzleniyor',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => '{{module}} "{{name}}" İzmeleden çıkarıldı',
    'LBL_ACTION_FAVORITE_EXPLANATION' => '{{module}} "{{name}}" Favori olarak belirtildi',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => '{{module}} "{{name}}" Favori olmaktan çıkarıldı',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => '{{module}} / "{{name}}" kaydı, {{relatedModule}} / "{{relatedName}}" ile ilişkili olarak oluşturuldu',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'Birincil',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'Listeden Çıkış',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'Listeye giriş',
    'LBL_EMAIL_ACTION_SET_VALID' => 'Geçerli',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'Geçersiz',
    'LBL_ROLLBACK_BUTTON' => 'Geri Alma',
    'LBL_TX_LOG' => 'İşlem Günlüğü',
    'LBL_TX_LOG_DETAIL' => 'İşlem Detayı',
    'LBL_RECORD_DELETED' => '(Kayıt Silindi)',
    'LBL_NOT_AVAILABLE' => 'Yok',
    'LBL_FILE_SIZE' => 'Dosya Boyutu',
    'LBL_FILE_SIZE_UNITS_B' => 'Bayt',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'Öğeleri seçin',
    'LBL_OFFLINE_DB_SIZE' => 'Veri Tabanı Boyutu',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'Modül bazında kayıtlar',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'Toplam kayıt sayısı',
    'LBL_RECORD_NOT_FOUND' => 'Kayıt bulunamadı.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'İlişkili kayıt bulunamadı.',
    'LBL_NOT_AUTHORIZED' => 'Bu kaydı görüntülemek için yetkiniz yok',
    'LBL_MOBILE_PROCESSING_FILE' => 'Dosya hazırlanıyor...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'Üçüncü Parti Yazılım',
    'LNK_TERMS_OF_USE' => 'Kullanım Şartları',
    'LNK_PRIVACY_POLICY' => 'Gizlilik Politikası',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'Tek Oturum Aç',
    'LBL_RECENTS' => 'Son dönemdekiler',
    'LBL_SHOWING_CACHED_DATA' => 'Sunucuya ulaşılamıyor. En son kullanılan veri ({{lastFetched}}) gösteriliyor',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'Kapat {{moduleSingular}} ve kaydet',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'Özel Panel',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Özel Modül',
    'LBL_MOBILE_DEFAULT_VIEW' => 'Başlangıç Ekranı',
    'LBL_MOBILE_DEFAULT_MODULE' => 'Seçilen Modül',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'Seçili Pano',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'Seçili Dashlet',
    'LBL_ALL_DASHLETS' => 'Tüm Dashletler',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'Global Arama',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Bir kullanıcıdan bahsetmek için @ yazın. Bir kaydı referans göstermek için # yazın.',
    'LBL_MOBILE_NEW_COMMENT' => 'Yeni yorum',
    'LBL_RECENTLY_VIEWED' => 'Son Görüntülenenler',
    'LBL_FILE_STORED_LOCALLY' => 'Dosya, yerel hafızaya kaydedilir ve aygıt çevrim içi olduğunda eşitlenir edilir.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'Düzenlenebilir olmayan bazı dosyaları değiştirmek isterseniz bu değişiklikleri bildirmek için lütfen Yöneticiyle iletişime geçin.',
    'LBL_ACTIVITY_POST' => '{{{value}}} {{{link}}} bağlantısında',
    'LBL_COMMENTLOG_EMPTY' => 'Yorum yok',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'Sonraki {{{commentsLeft}}} yorumu göster',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'Daralt',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'Yorum oluşturmayı onayla',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'Yorum Günlüğü boş olamaz',
    'LBL_MOBILE_PDF_DOWNLOAD' => '{{{pdfTemplateName}}} PDF dosyasını indirin',

    'ERR_SYNC_FAILED' => 'Sunucu ile senkronize edilemiyor.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'Erişim yetkisi yok.',
    'ERR_MOBILE_INVALID_CREDS' => 'Geçersiz kullanıcı ismi veya şifre.',
    'ERR_MOBILE_SESSION_EXPIRED' => 'Oturumunuz zaman aşımına uğradı.',
    'ERR_MOBILE_NOT_FOUND' => 'İstenen kaynak bulunamadı.',
    'ERR_MOBILE_TIMEOUT' => 'Sunucu yanıt vermiyor.',
    'ERR_MOBILE_CONNECTION_FAILED' => 'Sunucuya ulaşılamıyor.',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'İnternet bağlantısı yok.',
    'ERR_MOBILE_INTERNAL' => 'Dahili hata ({{{code}}}). Daha sonra tekrar deneyiniz.',
    'ERR_MOBILE_VALIDATION' => 'Kayıt geçersiz',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'Uyumsuz sunucu sürümü: {{{flavor}}}. Desteklenen sürümler: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'Uyumsuz sunucu sürümü: {{{version}}}. Minimum gerekli sürümü: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'Hata. Geçersiz E-posta Adresi.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'Bu belge türü desteklenmemektedir.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'Kimlik doğrulama başarısız oldu.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'İstenen kaynak bulunamadı.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'Dahili sunucu hatası.',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'Yasak.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'Servis erişilemiyor.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'Beklenmeyen bir hata oluştu.',
    'ERR_MOBILE_UPLOAD' => 'Dosya yüklemesi sırasında hata oluştu',
    'ERR_MOBILE_FILE_PROCESSING' => 'Dosya işleme hatası',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'Aygıt depolaması kullanılamıyor',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'Uygulamanız güncel değil ve bağlanmakta olduğunuz SugarCRM kurulumu ile uyumlu değil. App Store&#39;dan yeni sürümünü indirmek istiyor musunuz?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'Sunucu konfigurasyonu değişti ve tekrar yükleme gerekli. Devam?',
    'ERR_MOBILE_CONFLICT' => 'Sunucudaki aynı kayıt bir başkası tarafından değiştirildi. Otomatik olarak değişiklikleri birleştirmek için onaylayınız veya iptal ediniz.',
    'ERR_MOBILE_METADATA_CHANGED' => 'Sunucu konfigurasyonu değişti.',
    'ERR_MOBILE_FILE_READ' => 'Dosyayı okumada hata',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'Dosya bulunamadı',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'Dosya okunabilir değil',
    'ERR_MOBILE_FILE_ABORTED' => 'Okuma operasyonu sonlandırıldı',
    'ERR_MOBILE_FILE_SECURITY' => 'Dosya kilitlendi',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'Mobil versiyon bu yeneteği desteklememektedir. İstemci versiyonunu açmak ister misiniz?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'Dosya çok büyük. Maksimum izin verilen boyut: {{size}}',
    'ERR_OFFLINE' => 'Çevrimdışı hata',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'Lokal Depolama Birimini açamadı',
    'ERR_OFFLINE_STORAGE_CREATE' => 'Lokal Depolama Birimi oluşturulamadı',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'Lokal depolama birimi oluşturmada başarısız: yeterince alan kalmadı.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'Lokal diskinizde yer kalmadı.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'Veriatabanı temizliği hata aldı',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'Çevrim dışı depolama için alanınız kalmadı. Depolama alanı temizliği tavsiye edilir. Bu işlem birkaç dakika sürebilir.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'Sunucudan kayıtların ön yüklemesi başarısız oldu',
    'ERR_OFFLINE_SYNC_ERROR' => 'Senkronizasyon hatası',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'Senkronizasyon çakışması',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'Sunucu zamanını alma işlemi başarısız',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'Çevrimdışı modunu etkinleştirme başarısız oldu. Sunucuya ulaşılamıyor.',
    'LBL_EXPORT_CSV' => 'CSV&#39;yi Dışarı Aktar',
    'LBL_ERR_EXPORTING_CSV' => 'Dışa aktarılamadı',
    'LBL_ERR_EXPORT_ALL' => 'Seçili kayıtların verileri getirilemedi, lütfen tekrar deneyin',
    'LBL_LIST_SETTINGS_RESTORE' => 'Varsayılanları Geri Yükle',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'Alanlar geri yüklensin mi?',
    'LBL_LIST_SETTINGS_TITLE' => 'Liste Görünümü Oluşturucusu',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'Mevcut Alanlar',
    'LBL_LIST_SETTINGS_REMOVE' => 'Kaldır',
    'LBL_LIST_SETTINGS_TEXT' => 'Alanları, liste görünümü oluşturucusuna sürükleyerek {{moduleName}} liste görünümünü tasarlamak için yeniden düzenleyin.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'En az bir alan yerleşime eklenmelidir.',
    'LBL_LIST_SETTINGS_EMPTY' => 'Mevcut alanlar yok',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'Eşleşen alanlar bulunamadı',
    'LBL_LIST_FILTER' => 'Alan Arama',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'E-Posta istemcisi',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'Harici E-Posta İstemcisi',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar E-posta İstemcisi',
    'LBL_OFFLINE_CAPABILITIES' => 'Çevrim dışı özellikleri etkinleştirin',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'İşlem silinemedi.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'İşlem silindi.',
    'LBL_SECURE_MODE' => 'Gelişmiş Güvenlik Modu',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'Uygulamalar arka planda olduğunda Sugar Mobile&#39;ın içeriklerini gizlemek ve herhangi bir zamanda uygulamanın ekran görüntülerini önlemek için bu ayarı etkinleştirin.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'Uygulamalar arka planda olduğunda Sugar Mobile&#39;ın içeriklerini gizlemek için bu ayarı etkinleştirin.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'Her Zaman Çevrim Dışı Modu',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'Her Zaman Çevrim Dışı Modunda çalışıyorsunuz. Yeniden bağlanmak istiyor musunuz?',
    'LBL_RECONNECT' => 'Yeniden bağlan',
    'LBL_STAY_OFFLINE' => 'Çevrim Dışı Kal',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'Erişmeye çalıştığınız modül, Sugar Mobile&#39;da mevcut değil.',
    'LBL_MOBILE_RELEASE_NOTE' => '{{platform}} Sürüm Notları için Sugar Mobile',
    'LBL_MOBILE_USER_GUIDE' => '{{platform}} Kullanıcı Kılavuzu için Sugar Mobile',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'bu kelimeleri içeren',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'bu kelimeleri içermeyen',
    'LBL_NOTIFICATIONS_CHANNEL' => 'Güncellemeler',
    'LBL_APPLY_BUTTON_LABEL' => 'Uygula',
    'LBL_ACTION_CREATE_FAILURE' => "Kayıt kaydedilemedi:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "Kayıt güncellenemedi:\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'Sunucudaki alan hesaplamaları çözülemedi.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'Şu alanlar geçersiz: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>Başarılı.</b> Başarıyla oluşturduklarınız {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}".</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>Başarılı.</b> Kaydı başarıyla güncellediniz',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'E-posta verisi sunucudan alınamadı.',
    'LBL_ASSIGN_SUCCESS' => '<b>Başarılı.</b> Kayıt, {{{userName}}} kullanıcısına atandı',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'Bu e-posta taslak olarak kaydedilsin mi?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'Taslak olarak kaydet',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'E-postayı dikkate alma',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'Taslağı kaydetmezseniz bu e-postayı kaybedersiniz.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'İmza Seçin',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'E-posta Şablunu Seçin',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'Şablon, bu e-postadaki tüm içeriklerin üzerine yazacak. Bu şablonu kullanmayı ve üzerine yazmayı istediğinizden emin misiniz?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'E-Posta Oluştur',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'E-postanız, İlişkili kayıttan gelen değerler kullanılarak değiştirilecek değişkenler içeriyor. Göndermeden önce lütfen İlişkili alanının doğru olarak ayarlandığını doğrulayın.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'Giden e-posta hesabı bulunamadı. Lütfen Sugar yöneticinizle iletişime geçin.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' ve {{{count}}} tane daha',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'E-Posta ekle',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'Bir kişi adı veya e-posta adresi yazın',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (Yeni E-posta)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'Değişkenler',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'E-Posta Şablonları',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'Kampanya Şablonları',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'İş Akışı Şablonları',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'Sistem Şablonları',
    'LBL_FILTER_EDIT' => 'Filtreyi Düzenle',
    'LBL_FILTER_MY_FILTER' => 'Filtrem',
    'LBL_FILTER_MY_FILTER_BY' => 'Filtrem kriteri: {{{filters}}}',
    'LBL_FILTER_SAVE' => 'Filtreyi kaydet',
    'LBL_SELECT_PARAM' => 'Seç',
    'LBL_SELECT_MODULES' => 'Modül Seçici',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'İlave Parametreler Seçin',
    'LBL_FILTER_TEMPORARY' => 'Geçici filtre',
    'LBL_ERROR_FILE_UPLOAD' => '{{{fieldLabel}}} dosya "{{{fileName}}}" karşıya yüklenemedi. {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">Başarısız kaydı görüntüle</a>',
    'LBL_FILE_UPLOAD_ONE' => 'Dosya kaydediliyor...',
    'LBL_FILE_UPLOAD_MANY' => '{{{index}}} / {{{total}}} dosya kaydediliyor...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'Bildirim Ayarları',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'Anlık bildirimlerinizi yönetin',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "Cihazınızın bildirim ayarlarını kullanarak bildirimlerin nasıl görüneceğini kontrol edin.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'Atamalar',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'Kayıtlar size atandığında, bildirimler alın.',
    'LBL_NOTIFICATION_MENTIONS' => 'Bahsetmeler',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'Yorum günlüğü girişlerinde sizde bahsedildiğinde bildirimler alın.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'Yorum Günlüğü alanı, bu yerleşime bir yönetici tarafından eklenmedi. Lütfen Sugar yöneticinizle iletişime geçin.',
    'ERR_NO_PERMISSION_TITLE' => 'Lütfen erişim izni verin',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}}, kamera erişimine ihtiyaç duyuyor böylece fotoğraflar ekleyebilirsiniz. Lütfen sistem ayarlarında kamera erişimine izin verin.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'Ayarlar',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'Süre',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'Kalan Süre',
    'LBL_LIST_SUPPORT_EXPIRES' => 'Son Geçerlik',
    'LBL_CASCADE_RLI_EDIT' => 'Açık Gelir Kalemlerini Güncelle',
    'LBL_MOBILE_CALENDAR' => 'Takvim',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'Takvim Ayarları',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'Hafta başlangıç günü',
    'LBL_MOBILE_CALENDAR_MODULES' => 'Gösterilecek olaylar',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}s:{{{minutes}}} dak.',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} Saat',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} Dak.',
    'LBL_MOBILE_CALENDAR_TODAY' => 'Bugün',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => '{{{moduleName}}} ekle',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'Bir etkinlik planla',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'Lütfen en az bir olay türünü etkinleştirin.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'Tüm gün',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'Takvimler yüklenemedi.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'Bu aksiyon, Sugar Mobile&#39;da mevcut değil. Bunun yerine masaüstü uygulaması açmayı istiyor musunuz?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'Şablon Seç',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'Birleştir',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'Hata: HEIC dosyasında EXIF verileri eksik',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'Hata: Görüntü çözünürlüğü çok yüksek',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'Hata: Görüntü işlenemiyor',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'Hata: Görüntü tuvale aktarılamadı',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'Hata: Dosyalar görüntü olarak yüklenemedi',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1 Öge Seçildi',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} Öge Seçildi',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'Tümünü seç',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'Bu görünümde {{{count}}} kayıt seçtiniz. Tüm kayıtlar seçilsin mi?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => '{{{count}}} kayıt seçin',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'Seçili kaydı/kayıtları silmek istediğinizden emin misiniz?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'Siliniyor… {{{count}}} / {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'Seçili kayıtlarda geçerli e-posta yok',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'Görünüm',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'Sistem ayarını kullanın',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'Açık',
    'LBL_MOBILE_APP_THEME_DARK' => 'Koyu',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'Yeni dosya adı',
    'LBL_ATTACHMENT_RENAME_MSG' => 'Dosyayı yeniden adlandır',
    // Filters related
    'LBL_CREATED_BY_ME' => 'Benim oluşturduğum',
    'LBL_OPERATOR_ONE_OF' => 'bunlardan biri',
    'LBL_OPERATOR_NOT_ONE_OF' => 'bunlardan biri değil',
    'LBL_OPERATOR_CONTAINS' => 'herhangi biri:',
    'LBL_OPERATOR_CONTAINS_WORD' => 'içerir',
    'LBL_OPERATOR_NOT_CONTAINS' => 'herhangi biri değil:',
    'LBL_OPERATOR_EMPTY' => 'boştur',
    'LBL_OPERATOR_NOT_EMPTY' => 'boş değildir',
    'LBL_OPERATOR_MATCHES' => 'tam olarak eşleşir',
    'LBL_OPERATOR_STARTS_WITH' => 'ile başlayan',
    'LBL_OPERATOR_EQUALS' => 'eşit:',
    'LBL_OPERATOR_NOT_EQUALS' => 'eşit değil:',
    'LBL_OPERATOR_GREATER_THAN' => 'daha büyük:',
    'LBL_OPERATOR_LESS_THAN' => 'daha küçük:',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'büyük veya eşit:',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'küçük veya eşit:',
    'LBL_OPERATOR_BETWEEN' => 'arasında',
    'LBL_OPERATOR_BEFORE' => 'önce',
    'LBL_OPERATOR_AFTER' => 'sonra',
    'LBL_OPERATOR_YESTERDAY' => 'dün',
    'LBL_OPERATOR_TODAY' => 'bugün',
    'LBL_OPERATOR_TOMORROW' => 'yarın',
    'LBL_OPERATOR_LAST_7_DAYS' => 'son 7 gün',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'önümüzdeki 7 gün',
    'LBL_OPERATOR_LAST_30_DAYS' => 'son 30 gün',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'önümüzdeki 30 gün',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => '__ günden daha uzun süre önce',
    'LBL_OPERATOR_LAST_X_DAYS' => 'Son __ gün',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'Sonraki __ gün',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'Gelecekte __ günden fazla',
    'LBL_OPERATOR_LAST_MONTH' => 'geçen ay',
    'LBL_OPERATOR_THIS_MONTH' => 'bu ay',
    'LBL_OPERATOR_NEXT_MONTH' => 'sonraki ay',
    'LBL_OPERATOR_LAST_YEAR' => 'geçen yıl',
    'LBL_OPERATOR_THIS_YEAR' => 'bu yıl',
    'LBL_OPERATOR_NEXT_YEAR' => 'gelecek yıl',
    'LBL_OPERATOR_IS' => ':',
    'LBL_OPERATOR_IS_NOT' => 'değildir',
    'LBL_OPERATOR_AFTER_TODAY' => 'bugünden sonra',
    'LBL_OPERATOR_BEFORE_TODAY' => 'bugünden önce',
    'LBL_ERROR_FILTER_EMPTY' => 'Lütfen filtre kriteri ekleyin.',
    'LBL_ADD_FILTER' => 'Kriter Ekle',
    'LBL_FILTER_NAME' => 'Filtre adı',
    'LBL_FILTER_FIELD' => 'Alan',
    'LBL_FILTER_OPERATOR' => 'Operatör',
    'LBL_FILTER_VALUE' => 'Değer',
    'LBL_FILTER_SYNC_TO_SERVER' => 'Masaüstü Uygulamasına Kaydet',
    'LBL_FILTER_LOCAL' => 'Yerel filtre',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'SugarCRM hoşgeldiniz.<br /><br><br /><br><br />İzninizle, yeni özelliklerin bir kısmını tanıtmak istiyoruz...<br /><br>',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'Ana menü navigasyon.',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'Görünüm için kullanılabilen aksiyonlar.',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'Kayıtlar için genel arama.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'Favori kayıtlarımı görüntülemek için listeyi filtrele.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'Bana Atanmış kayıtları görüntülemek için listeyi filtrele.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'Kayıdı favori olarak işaretleyin.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'Yaklaşan etkinliklerim bugün başlıyor.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'En son güncellenen kayıtlar.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'Kaydın üzerinde mevcut aksiyonlar.',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'Tüm yeni özelliklerin tadını çıkarın!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'Bu ek menüdür.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'Artı menüyü kapatın.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'Görüntülemek ve Gerçekleştirmek için özel aksiyon seçin.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'Bu ana menüsü.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'Ana menüyü kapatın.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'Belirli bir modülü görüntüle.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'Uygulamayı özelleştirin.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'Sugar uygulamasını web tarayıcısında açın.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'Profilinizi görüntüleyin.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'Bu sayfa ayrıntıları gösterir.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'Bir kayıt hakkında en önemli bilgiler.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'Daha fazla bilgi görüntüle veya kaydı düzenle.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'Kaydın üzerinde mevcut aksiyonlar.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'Önceki sayfaya git.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'İstediğiniz zaman Tura Erişin',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'Geri git.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'İlişkili kaydı açmak için tıklayın',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'Bir kaydı İzle/İzleme dışına al.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'İlişkili kaydı açmak için tıklayın',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'Ana menü görünümü.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'Ana menü, ekranınızın solunda açılmaktadır.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'Detay Görünümü',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'Detaylı görünüm, ekranınızın sağ tarafında açılır.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'Bu menüye ait kilit bileşenlere ait hızlı bir tur için aşağıdaki okları kullanın.',

    'LBL_COMMENT_ADD' => 'Bir Yorum Ekleyin',
    'LBL_REQUIRED' => 'Zorunlu',
    'LBL_MORE_BUTTON' => 'Daha fazla',
    'LBL_NO_OPTIONS' => 'Seçenekler mevcut değil',
    'LBL_TRY_AGAIN' => 'Tekrar dene',
    'LBL_NEW_RECORDS' => 'Son Oluşturulanlar',
    'LBL_ASSIGNED_TO_ME' => 'Benim {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'Tüm {{{module}}}',
    'LBL_UNFAVORITE' => 'Favori olmaktan çıkar',
    'LBL_ACTIVITY_CREATE' => 'Oluşturulan {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => '{{{record}}} {{{module}}} üzerinde güncellenen {{{changes}}}',
    'LBL_ACTIVITY_LINK' => '{{{record}}} {{{module}}} modülüne bağlanan {{{relatedRecord}}}',
    'LBL_ACTIVITY_UNLINK' => '{{{record}}} {{{module}}} modülünden bağlantısı kesilmiş {{{relatedRecord}}} from ',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{parentModule}} için {{relationship}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'İndirmeyle ilişkili kayıtlar...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'Pano yapılandırmanız değişti. Yeniden yüklemek istiyor musunuz?',
    'LBL_RECORDS' => 'Kayıtlar',
    'LBL_DASHBOARDS' => 'Gösterge Panoları',
    'LBL_TEMPLATES' => 'Şablonlar',
    'LBL_NON_TEMPLATES' => 'Şablon Olmayanlar',
    'LBL_IS_TEMPLATE' => 'Şablondur',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'Seçiminiz, toplu olarak güncellenemeyen pano şablonları içeriyor. Devam etmek için lütfen şablonların seçimini kaldırın.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'Seçiminiz, toplu olarak silinemeyen pano şablonları içeriyor. Devam etmek için lütfen şablonların seçimini kaldırın.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'Ara {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'Ana menü',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'Hızlı yeni kayıt oluştur',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'Daha fazla seçenek için kaydır',
    'LBL_DETAILS' => 'Detaylar',
    'LBL_DETAIL_RELATED' => 'İlişkili',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'Bu {{module}}, bir {{relatedModule}} gerektirir. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>Bir {{relatedModule}} kaydı oluşturun</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'Kaydı değiştir',
    'LBL_OFFLINE_MENU_SETTINGS' => 'Çevrimdışı Ayarları',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'Hata Ayıklama Ayarları',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'Toplam Kayıt',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'Son indirme',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'Dosya indirilemiyor.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'Gösterge panoları sunucudan yüklenemedi',
    'ERR_FILTERS_FETCHING' => 'Filtreleriniz getirilemiyor',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'Lokal depolama şifrelenemedi',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'Çevrimdışı veriler şifreleniyor. Bu işlem birkaç dakika sürebilir.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'Çevrimdışı veri şifreleme işlemi tamamlandı.',
    'ERR_ACCESS_SPECIFIC_MODULE' => '{{{module}}} modülüne erişiminiz yok.',
    'LBL_SKIP' => 'Atla',
    'LBL_CONTINUE' => 'Devam Et',
    'LBL_ENABLE' => 'Etkinleştir',
    'LBL_MOBILE_TRIAL_UNTIL' => 'Şu Tarihe Kadar Deneme:',
    'LBL_MOBILE_SDK_VERSION' => 'SDK Versiyonu',
    'LBL_LOG_LEVEL' => 'Günlük Seviyesi',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'Oturum açma ayarları yapılandırıldı.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'Deneme süreniz sona erdi.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'Sunucu güvenli bağlantıyı desteklemiyor. Lütfen güvenli bağlantınızı kapatın.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'Sunucu güvenli bağlantıyı destekliyor. Lütfen güvenli bağlantıyı açın.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'Bağlantınız güvenli değil. Yöneticinizle iletişime geçin.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'Oturum Açma Ayarları',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => '{{{brandName}}} kurulumunuzu ayarlayın',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'Uygulamanın çalışması için {{{brandName}}} kurulumunun URL&#39;sini yazmanız gerekecek. Kurulum URL&#39;niz yoksa lütfen yöneticinizle iletişime geçin.',
    'LBL_FACEID' => 'Yüz Kimliği',
    'LBL_TOUCHID' => 'Touch ID',
    'LBL_ENABLE_TOUCHID' => '{{{biometryType}}} etkinleştir',
    'LBL_SETUP_TOUCHID' => '{{{biometryType}}} kur',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'Parmağınızı kullanarak oturum açın',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} cihazınızda kurulu değil. \n\n{{{biometryType}}} kurmak için cihazınızın ayarlarına gidin. Kurulum tamamlandığında Ana Menü > Ayarlarda {{{brandName}}} için {{{biometryType}}} etkinleştirin.",
    'LBL_TOUCH_ID_DISCLAIMER' => '{{{brandName}}} ile {{{biometryType}}} kullanmanız, {{{brandName}}} erişimi için şifrenizi girmek yerine biyometrik kimlik belirleyiciyi kullanmanıza imkan verir.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => '{{{biometryType}}} ile devam etmek istiyor musunuz?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => '{{{biometryType}}} etkinleştirmek için {{{brandName}}} şifrenizi girin',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'Kurulum',
    'LBL_MDM_CONFIRM_CHANGE' => 'Uygulama yapılandırması, Mobil Cihaz Yöneticisi olarak değiştirildi. Değişiklikleri uygulamak için lütfen yeniden oturum açın.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'Lütfen cihazınızın ayarlarından konumunuza {{{brandName}}} erişimi verin.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'Mevcut konum kullanılamıyor',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "Mevcut konum alma zaman aşımına uğradı. \nLütfen tekrar deneyin.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'Konum işaretleri mevcut değil',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'Konum koordinatları geçersiz',
    'ERR_MOBILE_INVALID_PASSWORD' => 'Geçersiz şifre.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'Uygulamanız güncel değil ve artık bağlanmakta olduğunuz {{{brandName}}} kurulumuyla uyumlu değil. Güncellemek istiyor musunuz?',
    'LBL_MOBILE_BY' => 'İle',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'Bu filtre çevrimdışı kullanılamaz',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'Çevrimdışı Kayıtlar',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'İndirme Ayarları',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'Çevrimdışı erişim için atanan, sık kullandığınız ve izlenen kayıtları indirin. Tercihlerinizi çevrimdışı ayarlarda güncelleyebilirsiniz.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'Kayıtlarınızın indirme işlemi  tamamlandı. Şimdi bunlara çevrimdışı modda erişebilirsiniz.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "Kayıtlarınızın tamamı indirilmedi.\n Tekrar denemek istiyor musunuz?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'Cep telefonu verilerini kullanın',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'Şimdi değil',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'İndirme işlemi duraklatıldı ve uygulamayı tekrar açtığınızda devam edecek.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'İndiriliyor {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'En Son Kayıtları Güncelle',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'Bağlantı bekleniyor',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'Duraklatıldı',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'Durduruluyor',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'İndir',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'Duraklat',
    'LBL_BULK_LOAD_BTN_RESUME' => 'Devam ettir',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'Varsayılan olarak sadece WiFi bağlantısı kullanılıyor',
    'LBL_NPS_RATING_MSG' => "\n{{{productName}}} deneyiminizi nasıl değerlendirirsiniz?",
    'LBL_NPS_THANKS_MSG' => 'Geri bildiriminiz teşekkür ederiz!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'App Store&#39;da değerlendirmenizin sakıncası var mı?',
    'LBL_NPS_NO_THANKS' => 'Hayır, Teşekkürler',
    'LBL_NPS_NOT_NOW' => 'Şimdi Değil',
    'LBL_NPS_RATE_NOW' => 'Şimdi Değerlendir',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'Ağ kullanılamıyor. Yine de çevrimdışıyken uygulamayı kullanabilirsiniz',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'Çevrimiçi olduğunuzda yaptığınız değişiklikler eşleştirilecek. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>Ayrıntılara bakın</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'Eşleştirilmemiş veriler var. Lütfen <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>işlem günlüğünü kontrol edin</a>',
    'LBL_CONVERT' => 'Dönüştür',
    'LBL_CONVERT_LEAD' => 'Potansiyeli Dönüştür',
    'LBL_SEARCH_EXISTING_RECORD' => 'Mevcut {{{this}}} Ara',
    'LBL_DUPLICATES_CHECK_FAILED' => 'Yinelenenler kontrolü yapılalamdı',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'Bağlantılı aktiviteleri kişi kaydına kaydırmayı istiyor musunuz?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'Potansiyel {{{name}}} başarılı şekilde dönüştürüldü',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'Yinelenenler Bulunamadı.',
    'ERR_LEAD_CONVERSION_FAIL' => 'Potansiyel Dönüştürme Başarısız Oldu',
    'LBL_SELECT_DUPLICATE_RECORD' => 'Yinelenen {{{modulePlural}}} İçerisinden Seçin',
    'LBL_SELECTED_EXISTING_RECORD' => 'Seçili {{{moduleSingular}}}',
    'LBL_CREATED_NEW_RECORD' => 'Oluşturulan Yeni {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => 'Geri düğmesi',
    'LBL_VO_HOME_BTN' => 'Giriş sayfası düğmesi',
    'LBL_VO_DASHBOARD_BTN' => 'Gösterge paneli düğmesi',
    'LBL_VO_SEARCH_BTN' => 'Arama düğmesi',
    'LBL_VO_RIGHT_MENU_BTN' => 'Sağ menü düğmesi',
    'LBL_VO_ADD_BTN' => 'Ekleme düğmesi',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'İndirim',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'Bir eşleşme uygulaması seçin',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'Seçilmiş olan {{entityName}} ilişkili değerler: {{localizedFieldNames}}. Mevcut değerleri korumak için İptal Edin. Yeni değerleri üzerine yazmak için Onaylayın.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'Veri şifreleme etkin.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'Seçili potansiyel, zaten dönüştürüldü.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'Bu işlem, sadece cihaz çevrim içi olduğunda kullanılabilir',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'Tekliften bir Fırsat oluşturmak istediğinizden emin misiniz?',
    'LBL_TAG_ADD' => 'Etiket ekleyin',
    'LBL_TAG_ENTER_TAG_NAME' => 'Etiket girin',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'Cihaz çevrim dışıyken Etiketlere göre filtreleme desteklenmez.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'Tüm yorumu göster',
    'LBL_COMMENT_VIEW' => 'Bir Yorum Görüntüle',
    'LBL_PMSE_LABEL_DUEDATE' => 'Bitiş Tarihi',
    'LBL_PMSE_DUE' => 'Son Tarih',
    'LBL_PMSE_DUE_ON' => 'Şu tarihe kadar:',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'Lütfen önce {{conversionParentModuleName}} oluşturun',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'Eksik gerekli kayıtlar: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'Görüntü kalitesini seçin. Görüntü, sunucuya kaydedilmeden önce buna göre yeniden boyutlandırılır. Seçili değer, gelecekteki tüm benzer işlemler için varsayılan olarak kullanılacak.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'Dosya boyutu hesaplanıyor...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'Hesaplanan dosya boyutu:',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'Görüntü kalitesi',
    'LBL_IMAGE_QUALITY_BEST' => 'Orijinal boyut',
    'LBL_IMAGE_QUALITY_GOOD' => 'İyi kalite',
    'LBL_IMAGE_QUALITY_POOR' => 'Küçük boyut',
    'LBL_IMAGE_QUALITY_BTN' => 'Sıkıştırma: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'Alanları {{module}} üzerinde listele',
    'LBL_LIST_RESET_FIELDS' => 'Varsayılanlara sıfırla',
    'LBL_LIST_NOT_ENOUGH' => 'Lütfen en az 1 aktif alan belirleyin.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'Oturum açarak SugarCRM kurulumu ile çalışabilmek için izinleri kabul etmeniz gerekir.',
    'LBL_SELECTING_EXISTING_RECORD' => '{{{moduleSingular}}} seçiliyor',
    'LBL_CREATING_NEW_RECORD' => 'Yeni {{{moduleSingular}}} Oluşturuluyor',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'Görüntü Boyutu',
    'LBL_COPY_ADDRESS' => 'Adresi kopyala',
    'LBL_OPEN_IN' => 'Şurada aç:',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'Dosya seçilmedi.',
    'LBL_ATTACHMENT_ADD' => 'Ekle',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'Bu uygulama çerezleri kullanır',
    'LBL_USE_COOKIES_CONFIRM' => 'Bu uygulama, size daha iyi bir deneyim sunmaya yardımcı olmak için çerezleri kullanır. Devam ederek, gizlilik politikamıza uygun olarak çerezlerin kullanılmasına izin vermiş olursunuz.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'Yaklaşan bir mobil sürümde Sugar Mobile ile uyumlu olmayacak bir Sugar kurulumu kullanıyorsunuz. Lütfen yöneticinizden Sugar&#39;ı en kısa sürede yükseltmesini isteyin.',
    'ERROR_TAG_NAME_INVALID' => 'Etiket adı "{{{forbiddenChars}}}" karakterlerini içeremez',
    'ERROR_NO_TAGS_FOUND' => '"{{{searchQuery}}}" ile eşleşen etiket yok',
    'ERR_PA_RECORD_INVALID' => '{{{moduleName}}} kaydı, bir veya daha fazla geçersiz değere sahip bundan dolayı kaydedilemez. {{{actionLabel}}} işlemini gerçekleştirmek için kaydı düzenlemek istiyor musunuz?',
    'ERR_MOBILE_METADATA_RELOAD' => 'Bir yönetici, Sugar kurulumunuzda yapılandırma değişiklikleri yaptı. uygulamanızın yapılandırmasını sunucuyla eşitlemek için Tamam düğmesine basın.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'This application uses cookies',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'Check to accept (Required)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'This application uses cookies to aid in providing you with a better experience. By continuing, you consent to the use of cookies in accordance with our <a href="{{href}}" target="_blank">privacy policy</a>.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'Kayıt görünümü bir kaydın ayrıntıları görmenizi sağlar.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Notlar diğer Portal kullanıcıları ve destek temsilcileri ile ekip çalışmasını sağlar.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'Kayda bir not eklemek için tıklayınız.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'Eklenmiş notların ayrıntılarını görüntülemek için bu simgelere tıklayın.',

    //for portal
    'LBL_PORTAL_HOME' => 'Home Dashboard',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'All Open Cases',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'Recently Resolved Cases',
    'LBL_PORTAL_SEARCH' => 'İsim, Numara ile Arama',
    'LBL_SIGNUP_BUTTON_LABEL' => 'Üye Ol',
    'LBL_PORTAL_NO_EMAIL' => 'Did not get an email?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'Forgot Password',
    'LBL_PORTAL_FORGOT_USERNAME' => 'Forgot Username',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'Enter your password twice. Passwords must match.',
    'LBL_PORTAL_RESET_PASSWORD' => 'Reset Password',
    'LBL_PORTAL_REENTER_PASSWORD' => 'Re-enter Password',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'Passwords do not match, please enter again',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'Your password has been successfully reset.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'An error occurred. Please initiate a new password reset request.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'Üyelik Kaydediliyor',
    'LBL_PORTAL_SIGNUP_TITLE' => 'Thank you for signing up',
    'LBL_PORTAL_SIGNUP' => 'We will inform you after we confirm your details.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'First Name',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'Last Name',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'Username',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'Email Address',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (isteğe bağlı)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'Ülke',
    'LBL_PORTAL_SIGNUP_STATE' => 'Eyalet',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'Company Name',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'İş ünvanı (isteğe bağlı)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'Password',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'Confirm Password',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'Forgot Login',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'Şifre unutuldu?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'Şifrenizi sıfırlamak için lütfen Sugar Yöneticisine başvurun.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'Kullanıcı İsmi',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'Şifre',
    'LBL_PORTAL_LOADING' => 'Yükleniyor',
    'LBL_PORTAL_SAVING' => 'Kaydediliyor',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'Sayfa Mevcut Değil',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "Üzgünüz, ama bu özellik şu anda mevcut değil.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => '"{query}" için arama sonuçlarını göster',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'Did not get an email?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'For assistance, or to contact us, please use any of the following: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'Phone: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'Email: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'Web: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'Bu sohbeti kapatmak istediğinizden emin misiniz?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'Not veya Ek Oluştur',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'Not Ekle',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'Your login was not successful. Please try again.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'Geçersiz Kimlik',
    'LBL_PORTAL_INVALID_GRANT' => 'Oturumunuzun süresi doldu. Lütfen tekrar giriş yapın.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'Oturum Süresi Doldu',
    'LBL_PORTAL_AUTH_FAILED' => 'İstemci kimlik doğrulaması başarısız oldu.',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'Geçersiz istemci',
    'LBL_PORTAL_INVALID_REQUEST' => 'Yapılan talep geçersiz veya bozuk. Lütfen teknik desteğe başvurun.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'Geçersiz Talep',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'Talep zaman aşımına uğradı.',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'İstek zaman aşımına uğradı',
    'LBL_PORTAL_UNAUTHORIZED' => 'Üzgünüz, ancak bu kaynağa erişmek için yetkiniz yok.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'HTTP Hatası: Yetkisiz',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'Kaynak bulunamadı.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'HTTP Hatası: Yasaklı',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'HTTP metodu bu kaynak için izin verilmiyor. Lütfen teknik desteğe başvurun.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP Hatası: Yönteme İzin Verilmiyor',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'Talep hatası yada eksik / geçersiz parametre. Lütfen teknik desteğe başvurun',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'HTTP Hatası:',
    'LBL_PORTAL_MIN_MODULES' => 'En az Talepler, Hatalar veya Bilgi Bankası modülünün sizin için aktive edilmiş olması gerekir.',
    'LBL_PORTAL_ERROR' => 'Hata',
    'LBL_PORTAL_ROUTE_ERROR' => 'Modülü yüklemede sorun. Lütfen daha sonra tekrar deneyin veya destek birimine başvurun.',
    'LBL_PORTAL_OFFLINE' => 'Üzgünüz uygulama şu anda mevcut değil. Site yöneticisine başvurun.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'Şifreyi değiştir',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'Username is already registered in the system. Either request a forgotten password or select another username.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'The email provided is invalid.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'The passwords do not match.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'Servis Konsolu',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'Genel Bilgi',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'Varsayılan Gösterge Panolarını Geri Yükle',
    'LBL_UNTITLED' => 'Isimsiz',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'Yenilemeler Konsolu',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'Genel Bilgi',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'Aşama/Durum',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'Ad/Hesap Adı',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'Omnichannel Panosu',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'Müşteri',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{time}} sürede {{type}} {{direction}} {{identifier}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'Tarayıcınız, SugarLive için desteklenmiyor. Lütfen Google Chrome veya Mozilla Firefox kullanın.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'Konuşmanızın ayrıntılarını içeren bir <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> modülü oluşturuldu.',
    'LBL_OMNICHANNEL_SUBJECT' => 'Konu',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'Tanım',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'Mesaj Özeti',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'Arama Özeti',
    'LBL_OMNICHANNEL_LINK_TO' => '{{fromModule}} modülünden {{toModule}} modülüne bağla',
    'LBL_OMNICHANNEL_LINK_RECORD' => '{{module}} modülüne bağla',
    'LBL_OMNICHANNEL_LINKED' => 'Bağlandı',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'Tarayıcınız, sohbet için desteklenmiyor. Lütfen Google Chrome veya Mozilla Firefox kullanın.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Yardım için lütfen Sugar Yöneticinizle iletişime geçin.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'Yerleşimi Yapılandır',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'Giden bir arama yapmadan önce lütfen SugarLive yapılandırmasını tamamlayın.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'SugarLive&#39;i açmadan önce lütfen SugarLive yerleşimi yapılandırmasını tamamlayın.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'SugarLive yerleşimini yapılandırmadan önce SugarLive&#39;de kendinizi "Çevrim dışı" olarak ayarlayın.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'Kompakt Görünüm',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'Tam Görünüm',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR Panosu',
    'LBL_SALES_MANAGER_CONSOLE' => 'Satış Müdürü Panosu',
    'LBL_SALES_REP_CONSOLE' => 'Satış Temsilci Panosu',
    'LBL_MARKETING_CONSOLE' => 'Pazarlama Panosu',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'Müşteri Başarısı Panosu',
    'LBL_EXECUTIVE_CONSOLE' => 'Yönetici Panosu',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'Sekmeyi Varsayılana Geri Yükle',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'Özet Panelini Yapılandır',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'Kullanıcı Profili',
    'LBL_WIZ_COMPLETE_TITLE' => 'Kurulum Tamamlandı',
    'LBL_SETUP_COMPLETE_INFO' => 'Sugar kullanmaya başlayın!',
    'LBL_SETUP_USER_INFO' => 'Kullanıcı bilgilerini tanımla',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'Kullanıcı Yerel Ayarları',
    'LBL_SETUP_USER_LOCALE_INFO' => 'Kişisel Zaman dilimi, tarih ve ad biçimlerini ayarlayın',
    'LBL_WIZ_START_SUGAR' => 'Sugarı Başlat',
    'LBL_WIZ_FIRST_NAME' => 'İsim',
    'LBL_WIZ_LAST_NAME' => 'Soyisim',
    'LBL_WIZ_EMAIL' => 'E-Posta',
    'LBL_WIZ_TIMEZONE' => 'Saat Dilimi',
    'LBL_WIZ_TIMEFORMAT' => 'Saat Formatı',
    'LBL_WIZ_DATE_FORMAT' => 'Tarih Formatı',
    'LBL_WIZ_NAME_FORMAT' => 'İsim Formatı',
    'LBL_SETUP_PROGRESS' => 'Kurulum işlemi',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar Eğitimi',
    'LBL_WIZ_DOCUMENTATION' => 'Dokümantasyon',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'Bilgi Tabanı',
    'LBL_WIZ_FORUMS' => 'Forumlar',
    'TPL_TIMEZONE_DIFFERENT' => 'Tarayıcınızın zaman dilimi kayıtlı zaman dilimine uymuyor {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'Saat Diliminizi ayarlayın.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'Yerel Ayarlar',
    'LBL_WIZ_EMAIL_SETTINGS' => 'E-Posta Ayarları',
    'LBL_WIZ_IMPORT_DATA' => 'Veri Yükle',
    'LBL_WIZ_CREATE_USERS' => 'Kullanıcı Oluştur',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'Sistem Ayarları',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Stüdyo',

    'LBL_CSP_ERROR_MESSAGE' => 'Girmiş olduğunuz değer(ler), desteklenmiyor veya kabul edilebilir biçimi karşılamıyor. Kabul edilebilir alan değerleri ve biçimlerinin bir listesi için <a href="{{linkToDocumentation}}" target="_blank">System</a> belgesine bakın.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'Bu içerik onaylanmadı. Lütfen sisteminizin <a href="{{linkToDocumentation}}" target="_blank">İçerik Güvenliği Politikası Ayarlarını güncelleyin</a>.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'Bu içerik onaylanmadı. Yöneticinizden sisteminizin <a href="{{linkToDocumentation}}" target="_blank">İçerik Güvenliği Politikası Ayarlarını güncellemesini isteyin.</a>. Ayarlar güncellendiğinde değişikliklerin geçerli olması için tarayıcınızı yenilemeniz gereklidir.',

    // For password related labels
    'LBL_PASSWORD' => 'Şifre',
    'LBL_CHANGE_YOUR_PASSWORD' => 'Şifrenizi değiştirin',
    'LBL_PASSWORD_REQUIREMENTS' => 'Şifre gereklilikleri',
    'LBL_CURRENT_PASSWORD' => 'Geçerli Şifre',
    'LBL_NEW_PASSWORD1' => 'Yeni Şifre',
    'LBL_NEW_PASSWORD2' => 'Şifreyi Onaylayın',
    'LBL_PASSWORD_CHANGED' => 'Şifrenizi başarıyla değiştirdiniz',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'Lütfen şifre onayınızı girin.',
    'ERR_ENTER_NEW_PASSWORD' => 'Lütfen yeni şifrenizi girin.',
    'ERR_ENTER_OLD_PASSWORD' => 'Lütfen eski şifrenizi girin.',
    'ERR_REENTER_PASSWORDS' => 'Şifreler eşleşmelidir.',
    'ERR_PASSWORD_MISMATCH' => 'Girmiş olduğunuz şifre sistemimizde kayıtlı olan ile uyuşmuyor.',
    'LBL_CANNOT_SEND_PASSWORD' => 'Şifre gönderilemiyor',
    'LBL_REQUEST_PASSWORD' => 'Şifre talep et',
    'LBL_RESET_PASSWORD' => 'Reset Password',
    'LBL_RESET_PASSWORD_MESSAGE' => 'Enter your username and we will send you a link to reset your password.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Check your email <br><br> We have sent password reset instructions to the email address
        we have on file.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'Hata: Bu kullanıcı için parola güncelleştirmede bir sorun oluştu.',
    'LBL_INCORRECT_PASSWORD' => 'Hata: Hatalı şifre.',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'The password you entered did not meet the password requirements. Please try again.',
    'LBL_PASSWORD_MIN_LENGTH' => 'Minimum length is {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'Maximum length is {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'Must contain one upper case letter (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'Must contain one lower case letter (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'Must contain one number (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'Must contain one special character (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'The password must not match the regular expression pattern: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'Dil Tercihi:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'Could not send password reset email.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'Bir Rapor Seçin',
    'LBL_REPORT_AUTO_REFRESH' => 'Otomatik Yenileme',
    'LBL_REPORT_EDIT' => 'Seçilen Kaydı Değiştirin',
    'LBL_REFRESH_LIST_AND_CHART' => 'Listeyi ve Grafiği Yenile',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'Mevcut grafik yok.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'Bu rapor, hiçbir filtre içermiyor.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'Yalnızca gizli çalışma zamanı filtreleriniz var, gelişmiş filtrelere bakın.',
    'LBL_RUNTIME_FILTERS' => 'Çalışma Zamanı Filtreleri',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'Tarih, kullanıcının tercih ettiği tarih biçimiyle eşleşmiyor: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'Bu panonun çalışma zamanı filtresi mevcut değil',
    'LBL_DASHBOARD_FILTER_GROUP' => 'Yeni Filtre',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'En az bir değer seçmeniz gerekir.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'Varsayılan Filtreli Geri Yükle',
    'LBL_COPY_FILTER_SUMMARY' => 'Filtre Özetini Kopyala',
    'LBL_APPLY_FILTERS' => 'Uygula',
    'LBL_REPORTS_FILTERS' => 'Filtreler',
    'LBL_RUNTIME_FILTERS_INVALID' => 'Geçersiz değerlerden dolayı çalışma zamanı filtreleri uygulamanaz',
    'LBL_RUNTIME_FILTERS_COPIED' => 'Filtre özeti panonuza kopyalandı.',
    'LBL_ADVANCED_FILTERS' => 'Gelişmiş Filtreler',
    'LBL_ADVANCED_OR_DESC' => 'HERHANGİ BİR koşul yerine getirildiğinde dahil et',
    'LBL_ADVANCED_AND_DESC' => 'TÜM koşullar yerine getirildiğinde dahil et',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'Bu bir özgün tasarım filtresidir',
    'LBL_AND_UPPERCASE' => 'VE',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'Bu özellik, Önizleme Modunda mevcut değildir',
    'LBL_REPORT_DEFAULT_NAME' => 'Başlıksız Rapor',
    'LBL_REPORT_QUERY' => 'Sorgu',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'Şu anki kayıtla ilişkili',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'Bağlantılı Alan',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'Bağlantılı alan boş bırakılamaz',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'Rapor seçilmedi.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'Çizgi Grafik bu raporla uyumlu değil',
    'LBL_REPORT_DASHLET' => 'Rapor Dashleti',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'Veri Tablosu',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'Çalışma Zamanı Filtreleri',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'Veri Tablosu Önizlemesi',
    'LBL_REPORTS_DASHLET_CHART' => 'Grafik',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'Grafik Önizleme',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'Filtre Önizleme',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'Seçili rapor, grafiği desteklemiyor.',
    'LBL_REPORTS_DASHLET_LABELS' => 'Etiketler',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'Toplam kayıt sayısını göster',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'Sıralama Düzeni',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'Varsayılan seçili görünüm',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'Birincil Grafik Sıralama Düzeni',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'İkincil Grafik Sıralama Düzeni',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'Seçilen rapora {{module}} bağlantısı yok',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'Bu rapor türü için kullanılamaz',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'Bu özellik, yalnızca grafik sekmesinde kullanılabilir',
    'LBL_REPORTS_CHART_TYPE' => 'Grafik Tipi',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'Bar Grafiği Değer Yerleşimi',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'Toplamı Göster',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'Simgeleri Göster',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'X-ekseni Etiketini göster',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Y-ekseni Etiketini göster',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Satır Görüntüleme Sınırı',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'Bu çalışma zamanı filtrelerini kullanmak için izniniz bulunmamaktadır.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'Bilinmeyen',
    'ERR_HTTP_DEFAULT_TITLE' => 'Bilinmeyen hata.',
    'ERR_HTTP_DEFAULT_TEXT' => 'Bilinmeyen hata.',
    'ERR_HTTP_DEFAULT_ACTION' => 'Önceki sayfaya geri dön.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'Hata: Geçersiz İstek',
    'ERR_HTTP_400_TEXT_LINE1' => 'Tarayıcınız, sunucunun anlayamayacağı bir istek gönderdi.',
    'ERR_HTTP_400_TEXT_LINE2' => 'Please contact your Sugar Administrator for more details.',
    'ERR_HTTP_400_ACTION' => 'Önceki sayfaya geri dön.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'HTTP: 404 Bulunamadı',
    'ERR_HTTP_404_TEXT_LINE1' => 'Üzgünüz ama sorduğunuz kaynak bulunamıyor.',
    'ERR_HTTP_404_TEXT_LINE2' => 'Lütfen yeniden deneyin. Hata devam ederse Sugar Yöneticinize başvurun.',
    'ERR_HTTP_404_ACTION' => 'Önceki sayfaya geri dön.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 İç Sunucu Hatası',
    'ERR_HTTP_500_TEXT_LINE1' => 'Sunucu bir hatayla karşılaştı ve isteğinizi tamamlayamadı.',
    'ERR_HTTP_500_TEXT_LINE2' => 'Lütfen yeniden deneyin. Hata devam ederse Sugar Yöneticinize başvurun.',
    'ERR_HTTP_500_ACTION' => 'Lütfen teknik desteğe başvurun.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 Dahili Sunucu Hatası',
    'ERR_HTTP_502_TEXT_LINE1' => 'Sunucu geçici bir hatayla karşılaştı ve isteğinizi tamamlayamadı.',
    'ERR_HTTP_502_TEXT_LINE2' => 'Lütfen yeniden deneyin. Hata devam ederse Sugar Yöneticinize başvurun.',
    'ERR_HTTP_502_ACTION' => 'Lütfen teknik desteğe başvurun.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 Dahili Sunucu Hatası',
    'ERR_HTTP_503_TEXT_LINE1' => 'Sunucu isteğinizi tamamlamak için uygun değil.',
    'ERR_HTTP_503_TEXT_LINE2' => 'Lütfen daha sonra yeniden deneyin. Hata devam ederse Sugar Yöneticinize başvurun.',
    'ERR_HTTP_503_ACTION' => 'Lütfen teknik desteğe başvurun.',

    'ERR_RENDER_FAILED_TITLE' => 'Görüntü Oluşturma Başarısız',
    'ERR_RENDER_FAILED_MSG' => 'Bir görünüm başarısız oldu',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'Alan Gösterimi Başarısız',
    'ERR_RENDER_FIELD_FAILED_MSG' => '{0} alanı gösterilemedi.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'Erişim Reddedildi',
    'ERR_NO_VIEW_ACCESS_REASON' => 'Bu sayfaya erişmek için yetkiniz yok.',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'Erişim istemek için yöneticinize başvurun.',
    'ERR_NO_VIEW_ACCESS_MSG' => '{0} modül görünümüne erişebilmek için Destek Yöneticiniz ile görüşün.',

    'ERR_LAYOUT_RENDER_TITLE' => 'Yerleşim oluşturma başarısız oldu',
    'ERR_LAYOUT_RENDER_MSG' => 'Önemli! Herhangi bir şey oluşturmamız mümkün değil. Lütfen daha sonra tekrar deneyin veya destek birimine başvurun.',
    'ERR_INTERNAL_ERR_MSG' => 'İç hata',
    'ERR_GENERIC_TITLE' => 'Hata',
    'ERR_CONTACT_TECH_SUPPORT' => 'Lütfen teknik desteğe başvurun.',

    'LBL_SYNCED_RECURRING_MSG' => 'Bu kaydı düzenleyemezsiniz çünkü harici bir istemciden senkronize edildi.',
    'LBL_EXISTING' => 'Mevcut',
    'LBL_PANEL_DEFAULT' => 'Varsayılan',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'Sunucudan uygunsuz yanıt',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'AssignTo eylemi sırasında hata oluştu.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => '"{{name}}" erişiminiz yok. Lütfen Yöneticinizle iletişime geçin.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => '{0} Yıl',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'Daha fazla Aksiyon',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'Alarm',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'Çift kaydı dikkate alma ve Kaydet',
    'LBL_RESTORE' => 'Orijinal Haline Geri Al',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'Silme İşlemi İçin İşaretlenmiş Kayıtlar',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'Bir Veri Gizliliği İsteği ile ilişkili kayıtları gösterir'
        . 'Bilgileri Sil.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS Beslemesi',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'Harici bir RSS veya Blog Akışı ekleyerek gelişmelerden haberdar olun.',
    'LBL_RSS_FEED_URL' => 'Geri Besleme URL',
    'LBL_RSS_FEED_AUTHOR' => 'Yazar:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'Gösterilecek kayıt sayısı',
    'LBL_ERR_LOADING_RSS_FEED' => 'Başarısız yükleme RSS Beslemesi',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'Tarihçem',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'Takım Tarihçesi',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'Kullanıcıların Gösterge Tablosuna Sugar Uygulamaları Eklemesine İzin Verir',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'Tarihçe',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'Tarihçe dashleti içinde yapılan toplantılar, yapılan aramalar, alınan e-postalar ve gönderilen e-postalar görüntülenir.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'E-Posta',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'E-Postalar',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'Tarihçem',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'Takım Tarihçesi',
    'LBL_UNASSIGNED' => 'Atanmamış',
    'LBL_ARCHIVE_EMAIL' => 'E-Posta Arşivle',
    'LBL_EMAIL_ARCHIVED' => 'E-posta arşivlendi',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'Arşivlenmiş E-Posta Oluştur',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'Planlanmış Aktiviteler',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'Planlanmış Aktiviteler dashleti, planlanan toplantıları ve aramaları görüntüler.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'Bugün',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'Gelecek',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'Tarihçem',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'Takım Tarihçesi',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'Yapıldı',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'Kapalı olarak {0} işaretlemek istediğinizden emin misiniz?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'Aktif Görevler',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Aktiv görevler dashleti içinde süresi gelen, süresi yaklaşan görevler listelenir.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'Şimdiye Kadar',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'Yaklaşan',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'Yapılacak',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'Tamamlandı',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'Tamamlanmış olarak {0} kapatmak istediğinizden emin misiniz?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Görevlerim',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Takım Görevleri',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'Değiştirdiğiniz kayıt üzerinde faklı bir e-posta bulunmaktaydı. Şimdi birincil olarak belirlendi ve aşağıda dolduruldu.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'İnaktif Görevler',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Görevler dashleti ertelenmiş ve tamamlanmış görevleri görüntüler.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'Ertelendi',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'Tamamlandı',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'Son değişiklik: {{relativetime}}  / Tarih: {{date}} Saat:{{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Görevlerim',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Takım Görevleri',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'En Son Görüntülenen Taleplerim',

    'LBL_REPORT_DASHLET_TITLE_12' => 'Durum Bazında Kullanıcıya Göre Açık Kalan Talepler',
    'LBL_REPORT_DASHLET_TITLE_125' => 'Haftaya Göre İş Merkezi Bazında Yeni Talepler',
    'LBL_REPORT_DASHLET_TITLE_126' => 'En Son Oluşturulan Talepler',
    'LBL_REPORT_DASHLET_TITLE_127' => 'Haftaya Göre Müşteri Aşaması Bazında Yeni Talepler',
    'LBL_REPORT_DASHLET_TITLE_128' => 'Müşteri Aşaması ve Önceliği Bazında Açık Talepler',
    'LBL_REPORT_DASHLET_TITLE_129' => 'İş Merkezi Bazında Bu Ay Kararlaştırılan Toplam Talep',
    'LBL_REPORT_DASHLET_TITLE_130' => 'Temsilci Bazında Bu Ay Kararlaştırılan Toplam Talep',
    'LBL_REPORT_DASHLET_TITLE_131' => 'En Son Kararlaştırılan Talepler Listesi',
    'LBL_REPORT_DASHLET_TITLE_132' => 'Haftaya Göre Bu Ay Kararlaştırılan Taleplerim',
    'LBL_REPORT_DASHLET_TITLE_133' => 'Bugün Süresi Dolan ve Geçmiş',
    'LBL_REPORT_DASHLET_TITLE_134' => 'Bugün Süresi Dolan ve Geçmiş Tüm Talepler',
    'LBL_REPORT_DASHLET_TITLE_135' => 'Sonraki Tarih Bazında Açık Taleplerim',
    'LBL_REPORT_DASHLET_TITLE_136' => 'Sonraki Tarih Bazında Tüm Açık Talepler',
    'LBL_REPORT_DASHLET_TITLE_137' => 'Durum Bazında Açık Taleplerim',
    'LBL_REPORT_DASHLET_TITLE_138' => 'Durum Bazında Geçen Haftaki Taleplerim',
    'LBL_REPORT_DASHLET_TITLE_139' => 'Benim Tarafından Atanmış Olan Açık Taleplerin Durumu',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP veya Eski REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Mantık Çengeli',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar Workflow',
    'LBL_AUDIT_SUBJECT_USER' => 'Kullanıcı',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web&#39;ten Potasiyele',

    //common chart strings
    'LBL_CHART' => 'Grafik',
    'LBL_CHART_NO_DATA' => 'Mevcut veri yok.',
    'LBL_CHART_LEGEND_CLOSE' => 'Simgeleri gizle',
    'LBL_CHART_LEGEND_OPEN' => 'Simgeleri göster',
    'LBL_CHART_CONTROLS_CLOSE' => 'Kontrolleri gizle',
    'LBL_CHART_CONTROLS_OPEN' => 'Kontrolleri göster',
    'LBL_CHART_UNDEFINED' => 'Tanımlanmamış',
    'LBL_CHART_NO_LABEL' => 'Tanımlanmamış',
    'LBL_CHART_AMOUNT' => 'Tutar',
    'LBL_CHART_COUNT' => 'Sayı',
    'LBL_CHART_PERCENT' => 'Yüzde',
    'LBL_CHART_GROUP' => 'Grup',
    'LBL_CHART_DATE' => 'Tarih',
    'LBL_CHART_KEY' => 'Anahtar',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'Grafik tipi',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'Başlığı göster',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'Toplamı Göster',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'X-ekseni etiketini göster',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Y-ekseni etiketini göster',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'İşaretçi gösterim metodu',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'Sözcük Kaydırma işareti',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'Yayılma işaretçileri',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'İşaretleri döndür',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'Bar grafiği değer yerleşimi',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'Bar grafiği gösterim opsiyonları',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'Kaydırmaya izin ver',
    'LBL_CHART_CONFIG_STACK_DATA' => 'Veri serilerini deste olarak göster',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'Boş grupları gizle',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'gönderildi',
    'LBL_EMAIL_RECV' => 'kayıt',

    //record save
    'LBL_RECORD_SAVED' => 'Kayıt kaydedildi.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'Başarılı şekilde {{moduleSingularLower}} oluşturdunuz <a href="#{{buildRoute model=this}}">{{name}}</a>.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'Başarılı bir şekilde {{moduleSingularLower}} oluşturdunuz.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'Başarılı bir şekilde kayıt oluşturuldu, fakat bu kayıda erişmek için izniniz yok.', // use when user has no access to the model
    'LBL_VALIDATING' => 'Doğruluyor...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'Başarılı:',
    'LBL_ALERT_TITLE_WARNING' => 'Uyarı:',
    'LBL_ALERT_TITLE_NOTICE' => 'Uyarı:',
    'LBL_ALERT_TITLE_ERROR' => 'Hata:',
    'LBL_ALERT_TITLE_LOADING' => 'Yükleniyor',
    'LBL_ALERT_NO_ACCESS' => 'Bu panoya uygulanan filtreye erişiminiz yok.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'Bu panoyu kendi filtrenizle yapılandırmak için panoyu çoğaltın.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'Tarayıcınızın sürümü artık desteklenmiyor ya da desteklenmeyen bir tarayıcı kullanıyorsunuz.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'Desteklenen Platformlar',
    'LBL_ALERT_CONFIRM_DELETE' => 'Bu öğeyi silmek istediğinizden emin misiniz?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'Bu öğeleri silmek istediğinizden emin misiniz?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'Seçilen kayıt şu ilişkili değerleri içerir: {{values}}. Bu kayda bu değerleri kopyalamak için "Onayla" butonuna tıklayın. Geçerli değerleri korumak için "İptal" butonuna tıklayınız.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'Seçilmiş olan {{moduleSingularLower}} ilişkili değerler: {{values}}. Mevcut değerleri korumak için İptal. Yeni değerleri üzerine yazmak için Onaylayın.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'Kimden:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'Kime:',

    //organization chart
    'LBL_ORG_CHART' => 'Organizasyon Şeması',
    'LBL_ORG_CHART_DESC' => 'Kuruluşunuzun çalışan yapısını görüntüler.',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'Yönünü değiştir',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'Tüm nodları göster',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'Sığması için yaklaştır',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'Talep Özeti',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'İlişkili talepler hakkında genel bilgi gösterir.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'Özet',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'Kapanmış Talepler',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'Açık Talepler',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'En iyi 10 Satış Gelir Kalemleri',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'Balon grafiğinde en iyi on Gelir Kalemleri görüntülenir.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'Gelir Kalemlerim',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "Takımımın Gelir Kalemleri",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'Varsayılan tarih filtresi',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'Varsayılan veri kümesi',

    'LBL_PRODUCT_CATALOG_NAME' => 'Ürün Kataloğu',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'Ürün Kataloğu',
    'LBL_PRODUCT_CATALOG_DESC' => 'Ürün Kataloğunuzdan kalemleri görüntüleyin ve ekleyin.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'Ürün Kataloğunuzdan kalemleri görüntüleyin ve ekleyin.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{date}} tarihinde, {{time}} saatinde {{relativetime}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Bir not yazın veya bir eki sürükleyip bırakın. Bir kullanıcı hakkında bahsetmek için @ yazın. Bir kayda referas vermek için # kullanın.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'Yorumunuzu ekleyin&hellip;Kullanıcı hakkında bahsetmek için @ ekleyin. Bir kayıda referans vermek için # kullanın.',
    'LBL_ACTIVITY_STREAM' => 'Aktivite Akışı',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'Aktivite Akışı etkin değil',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'Etkinlik Akışı Bu modül için aktif değil',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'Daha fazla paylaşım...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => ':',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'Sugar Bilgi Beslemesi',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'Kayıtlar üzerinde yapılmış olan aktivitelerin listesini inceleyip, not oluşturup yayınla.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'Aktivite Akışları devre dışı',

    'LBL_DATA_VIEW' => 'Veri Görünümü',
    'LBL_COMMENT' => 'Açıklama',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'Sunucuya bağlanırken bir hata oluştu. Lütfen tekrar deneyiniz.',
    'ERR_RESOLVE_ERRORS' => 'Lütfen devam etmeden önce hataları giderin.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'Onaylamak için gerekli tüm alanlar doldurulmalıdır; ancak yine de bu kaydı Reddedebilir veya Yönlendeirebilirsiniz.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'Reddetmek/Yönlendirmek için tüm gerekli alanlar doldurulmalıdır.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'Listeyi yenile',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'Pencereleri Yenile',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'daha fazla',
    'LBL_TEXTAREA_LESS' => 'daha az',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} ekleri',
    'LBL_CREATE_ATTACHMENT' => 'Eklenti oluştur',
    'LBL_DASHLET_REFRESH' => 'Yenile',
    'LBL_DASHLET_MOVE' => 'Taşı',
    'LBL_DASHLET_CLOSE' => 'Kapat',

    'LBL_DASHLET_FORECAST_NAME' => 'Satış Tahminimde',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'Tahmin Bar Grafiği',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Satış Tahmini Pareto Grafiği',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'Tahmin:',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'Belirli bir süre için Tahmin Bar tablosu görüntüler',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'Grupla',
    'LBL_DASHLET_FORECASTS_DATASET' => 'Veri Kümesi',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'Tahmin Detayları',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'Satış Tahmininin detaylarını görüntüler.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'Kayıtlı Raporlar Grafik Dashleti',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'Kaydedilmiş rapordan herhangi bir grafik görüntüler.',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'Yayınlanan İlgili Makaleler',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'Tarihsel Özet',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'Daha fazla tarihçe...',
    'LBL_RELATED_CONTACT' => 'İlişkili Kontak',
    'LBL_MODULE_TYPE' => 'Tip',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'E-Posta',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'Gönderen E-posta',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'Eski modüllerin için önizleme desteklenmemektedir',

    //SFA
    'LBL_BEST' => 'En İyi',
    'LBL_WORST' => 'En Kötü',
    'LBL_LIKELY' => 'Muhtemel',
    'LBL_BEST_FORECAST' => 'Taahhüt (En iyi)',
    'LBL_WORST_FORECAST' => 'Taahhüt (En kötü)',
    'LBL_LIKELY_FORECAST' => 'Taahhüt (Olası)',
    'LBL_BEST_ADJUSTED' => 'Ayarlanmış Taahhüt (En iyi)',
    'LBL_WORST_ADJUSTED' => 'Ayarlanmış Taahhüt (En kötü)',
    'LBL_LIKELY_ADJUSTED' => 'Ayarlanmış Taahhüt (Olası)',
    'LBL_AMOUNT_USDOLLAR' => 'Tutar',
    'LBL_OVERDUE' => 'Süresi Geçen',

    'LBL_PASSWORD_REQUEST_SENT' => 'Talebiniz gönderildi.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'Kullanıcı adınız ve e-posta kombinasyonunuzu alınırken bir sorunla karşılaşıldı.',

    'LBL_REMINDER_TITLE' => 'Hatırlatıcı',
    'LBL_CLICK_TO_DRILLDOWN' => 'Detaylar için tıklayın',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'Tüm diller devre dışı bırakılamaz.',

    'LBL_UPDATE_CALC_FIELDS' => 'Değerleri Yeniden Hesapla',

    //Optimistic Locking
    'LBL_YOU' => 'Siz',
    'LBL_RESOLVE_CONFLICT' => '{{name}} için uyuşmazlık çözümü',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'Daha fazla bilgi için, {{{more_info_url}}} {{plural_module_name}} dokümanlarına bakın. {{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'Mevcut veri yok',
    'LBL_NEED_HELP' => 'Yeni bir şeyle ilgili yardıma mı ihtiyacınız var?',
    'LBL_NEW_CASE' => 'Yeni Talep',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'Value TRUE indicates that the tribe is an Alaskan Native Corporation',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'Liste Görünümü Yardımı',
    'LBL_HELP_RECORDS' => "Bir modülün liste görünümü, mevcut arama kriterlerine uyan ve kullanıcının erişim hakkı olan bütün kayıtları gösterir. Her kayıt ile ilgili detaylara gösterilen alanlardan erişebilirsiniz veya kaydın ismine tıklayarak detay görünümüne gidebilirsiniz.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'Kayıt Görüntüleme Yardımı',
    'LBL_HELP_RECORD' => 'Bu kayıt görünümü, bir kişi ve aynı zamanda bu kişiye bağlı kayıtların bazı detayları hakkında bilgiler sunar.

- Kaydın alanlarını, herhangi bir alana veya Değiştir düğmesine tıklayarak değiştirin.
- Sol altta yer alan paneli "Kayıt Görünümü" olarak değiştirerek, diğer kayıtlar ile olan bağlantıları görün veya değiştirin.
- Sol altta yer alan paneli "Aktivite Akışı" olarak değiştirerek kullanıcı yorumlarıyla iletişime girin ve kayıt değiştirme geçmişini görün.
- Kayıt adının sağ tarafında bulunan simgeleri kullanarak bu kaydı takip edin veya favoriler arasına alın.
- Daha fazla aksiyon, Değiştir düğmesinin sağındaki Aksiyonlar açılır menüsünde yer almaktadır.',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}} Oluşturulması',
    'LBL_HELP_CREATE' => '{{plural_module_name}} oluşturmak için:
1. Alanlar için istediğiniz gibi değer girin.
* "Zorunlu" olarak işaretlenmiş alanların kayıt öncesinde girilmesi gerekmektedir.
* "Daha fazlasını göster" seçeneği ile, gerektiğinde ek alanları görünür kılın.
2. Yeni kaydı tamamlamak ve {{plural_module_name}} liste görünümüne dönmek için "Kaydet" tuşuna basın.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'Muhtemel Çift Kayıt Bulundu',
    'LBL_HELP_DUPLICATE' => 'Sugar oluşturmaya çalıştığınız kayıdın zaten olabileceğini farketti. Yeni kayıt oluşturmadan mevcut kayıdı değiştirmek için, istediğiniz kayıdın sağındaki "Seç ve değiştir" seçeneğini kullanın. Boş alanlar, girmiş olduğunuz değerler ile doldurulacak. "Kaydet" tuşu ile, bu değişikliklerin mevcut kayda uygulanmasını sağlayabilirsiniz. Eğer mevcut kayıttaki değerler yerine, yeni girmiş olduğunuz değerlerin kullanılmasını istiyorsanız, "Orjinale döndür" seçeneğini kullanın. Girmiş olduğunuz değerler, mevcut kayıta uygulanacaktır, ve ek değişiklikleri de uygulayarak "Kaydet" tuşu ile işlemi tamamlayabilirsiniz. Girmiş olduğunuz değerler ile yeni kayıt oluşturmak için "Benzer kayıtları dikkate alma" seçeneğini kullanınız.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'Eksik SMTP Sunucusu ayarları',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'Kayıt atama bilgilendirmelerini gönderebilmek için, {{emailSettingsUrl}} adresinde SMTP ayarlarının yapılmış olması gerekir.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'E-Posta Ayarları',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'Yeni Stok Raporları Mevcut',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'Yeni Stok raporları şunun için mevcut',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'Raporlar Modülü',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => '"Stok Raporu" olarak etiketliler ve filtrelenebilirler. Raporlar aynı zamanda içeriğe bağlı olarak "Satış ve Pazarlama", "Müşteri Hizmetleri", "Veri Gizliliği" veya "İdari" olarak da etiketlenebilir. Daha fazla bilgi için ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'belgeye bakın.',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM üretkenliği arttırmak için, yetkin kullanıcıların belirli işlemleri yapabilmesi için klavye kısa yollarını kullanmasına izin verir. Sağdaki tablolar, mevcut kısa yolları ve gerçekleştirdikleri aksiyonları göstermektedir.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>Desteklenen tuşlar</h1><ul><li>tüm alfa sayısal karakterler ve semboller</li><li>shift, ctrl, alt, command, mod (Windows&#39;da/Linux&#39;de ctrl ve Mac&#39;lerde command)</li><li>enter, esc, space, tab, pageup, pagedown, end, home, ins, del, backspace</li></ul><h1>Desteklenen özellikler</h1><ul><li>Tuş kombinasyonu: ctrl+m</li><li>Birden fazla tuş: m,ctrl+m</li><li>Tuş sırası: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'Global Kısayollar',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'İçeriksel Kısayollar',
    'LBL_SHORTCUT_KEY_KEY' => 'Anahtar',
    'LBL_SHORTCUT_FUNCTION' => 'Fonksiyon',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Bağlamsal Kısayolları Yapılandırın',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'Yapılandırılacak bağlamsal kısayollar yok',
    'LBL_SHORTCUT_HELP' => 'Kısa yollar yardım sayfasını göster',
    'LBL_SHORTCUT_QUICK_CREATE' => 'Hızlı oluşturma menüsünü değiştir',
    'LBL_SHORTCUT_SEARCH' => 'Genel arama alanı üzerinde odak',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'Kenar çubuğu geçişi',
    'LBL_SHORTCUT_CREATE_RECORD' => 'Yeni kayıt oluştur',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'Listede sonraki kaydı seçin',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'Listedeki önceki kaydı seçin',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'Listeyi sola kaydır',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'Listeyi sağa kaydır',
    'LBL_SHORTCUT_OPEN' => 'Listedeki seçilmiş kayıtları aç',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'Listedeki seçilmiş kaydı düzenle',
    'LBL_SHORTCUT_RECORD_DELETE' => 'Kaydı sil',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Listeleme ekranı satır içi düzenleme modundan kaydetmeden çık',
    'LBL_SHORTCUT_RECORD_SAVE' => 'Kaydı kaydet',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'Kayıt üzerindeki değişiklikleri temizle',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'Kaydı favori olarak işaretle',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'Kaydı takibe al',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'Kaydı önizle',
    'LBL_SHORTCUT_MARK_SELECTED' => 'Kaydı seçilmiş olarak işaretle',
    'LBL_SHORTCUT_SELECT_ALL' => 'Tümünü Seç',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'Toplu aksiyon açılır listeyi aç',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'Liste Filtre alanına odaklan',
    'LBL_SHORTCUT_FILTER_CREATE' => 'Yeni liste filtresi oluştur',
    'LBL_SHORTCUT_FILTER_EDIT' => 'Mevcut liste filtrelerini değiştir',
    'LBL_SHORTCUT_FILTER_SHOW' => 'Listeleme Filtresini Aç',
    'LBL_SHORTCUT_RECORD_EDIT' => 'Kaydı Değiştir',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'Önceki Kaydı Aç',
    'LBL_SHORTCUT_RECORD_NEXT' => 'Sonraki kayıtı aç',
    'LBL_SHORTCUT_COPY_RECORD' => 'Geçerli kaydı kopyala',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'Birincil aksiyon açılır listeyi aç',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'Bölmeyi Kapat',
    'LBL_SHORTCUT_FILTER_ADD' => 'Filtrelemek için ek kriter ekle',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'Filtreden son kriteri kaldır',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'Filtre kapat',
    'LBL_SHORTCUT_FILTER_SAVE' => 'Filtreyi kaydet',
    'LBL_SHORTCUT_FILTER_DELETE' => 'Filtre sil',
    'LBL_SHORTCUT_FILTER_RESET' => 'Filtre yenile',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'Satır Ekle',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'Satırı Sil',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'Toplu güncellemeyi kapat',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'Kayıtları Güncelle',
    'LBL_CREATE_CATEGORY' => 'Bir <div class="btn-link" data-action="create-new">kategorisi</div> oluşturun',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'Onayla',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'İptal',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'Çoklu seçim alanında tüm öğeleri seçin',
    'LBL_SHORTCUT_SWEETSPOT' => 'En Etkili Nokta çubuğuna geçiş yapın',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'En Etkili Nokta çubuğunu gizle',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'Yapılandırmayı kaydet',
    'LBL_SHORTCUT_RESTORE' => 'Varsayılanı geri yükle',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'Özel kısayol tuşları sunucuya kaydedilirken bir hata oluştu. Lütfen tekrar deneyin.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}} Ayarları',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}} konfigürasyon ayaları kaydedildi.',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} Konfigürasyon Hatası',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} için herhangi bir konfigurasyon ayarı bulunmamaktadır',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'Kullanıcının {{module}} erişimi yok',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'Kullanıcının, {{module}} ayarlarını değiştirmeye erişim hakkı yok',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => '{{module}} için veri tabanı ayarlarının düzeltilmesi gerekir',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'kadar:',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'Başlangıç & Bitiş Tarihi',

    'LBL_CALENDAR_START_DATE' => 'Başlangıç Tarihi',
    'LBL_CALENDAR_END_DATE' => 'Bitiş Tarihi',
    'LBL_CALENDAR_DURATION' => 'Süre',
    'LBL_CALENDAR_RECURRENCE' => 'Yineleme',
    'LBL_CALENDAR_REMINDERS' => 'Hatırlatıcılar',

    'LBL_CALENDAR_CUSTOM_DATE' => 'Özel Tarih',
    'LBL_CALENDAR_REPEAT_TYPE' => 'Tekrarlama Tipi',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'Tekrarlama Aralığı',
    'LBL_CALENDAR_REPEAT_DOW' => 'Haftanın Günlerinde Tekrar Et',
    'LBL_CALENDAR_REPEAT_ON' => 'Tekrarla',
    'LBL_CALENDAR_REPEAT' => 'Tekrarla',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'Tekrarlama Limiti',
    'LBL_CALENDAR_REPEAT_COUNT' => 'Gerçekleşmeleri Tekrarla',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'Seçiciyi Tekrarla',
    'LBL_CALENDAR_REPEAT_DAYS' => 'Ayın Günü/Günleri',
    'LBL_CALENDAR_REPEAT_MONTH' => 'Yılın Ay(lar)ı',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'Sıralı Tekrarla',
    'LBL_CALENDAR_REPEAT_UNIT' => 'Birimi Tekrarla',
    'TPL_REPEAT_INTERVAL' => 'Her {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'Bu seri, bir takvim istemcisinden senkronize edildiği için Sugar&#39;da bulunmayan Tekrarla seçeneğini kullanır. Belirli bir tarihte tekrarlamaya devam etmek istiyorsanız lütfen takvim istemcinizde bu seriyi düzenleyin. Sugar&#39;da bu seriyi düzenlemek Tekrarla seçeneğini Yok olarak ayarlayacaktır.<br><br>Devam etmek istiyor musunuz?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'Tekrarlayan değişiklikler, serinin ilk kaydı ile yapılmalıdır.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'Yineleme kuralları, oluşturulacak olan bir olaya neden olmaz.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'Katılan',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'Reddedildi',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'Kesinleşmemiş',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'Cevap Yok',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'Planlama Yok',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'Mevcut Görünümler',
    'LBL_CALENDAR_DASHLET_NAME' => 'Takvim Planlayıcısı',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'Varsayılan Görünüm',
    'LBL_CALENDAR_MY_CALENDARS' => 'Takvimlerim',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'Kullanıcı ve Takım Takvimleri',
    'LBL_CALENDAR' => 'Takvim',

    'LBL_CALENDAR_DAY' => 'gün',
    'LBL_CALENDAR_WEEK' => 'hafta',
    'LBL_CALENDAR_MONTH' => 'ay',
    'LBL_CALENDAR_YEAR' => 'yıl',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40&#39;ıncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60&#39;ıncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89&#39;uncu',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90&#39;ıncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94&#39;üncü',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96&#39;ncı',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97&#39;nci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98&#39;inci',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99&#39;uncu',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'Planı alırken hata oluştu.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'Davetleri Kaydet ve Gönder',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'Kabul Durumu',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'Süreçler',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'Süreçler panosu, SugarBPM içinde kullanılabilecek şablonları görüntüler.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'Süreç Tanımları',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'Süreç Tanımları panosu, SugarBPM içinde kullanılabilecek şablonları görüntüler.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'Süreç Tanımı Oluştur',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'Süreç Tanımı İçeri Al',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'İş Kurallarını İşle',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'Süreç İş Kuralları panosu, SugarBPM içinde kullanılabilecek şablonları görüntüler.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'Süreç İş Kuralı oluştur',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'Süreç E-Posta Kurallarını İçeri Aktar',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'E-Posta Şablonlarını İşle',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'Süreç E-posta Şablonları panosu, SugarBPM içinde kullanılabilecek şablonları görüntüler.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'Süreç E-Posta Şablonu Oluştur',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'Süreç E-Posta Şablonlarını İçeri Aktar',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'Süreçleri/iş kurallarını/e-posta şablonlarını Sugar&#39;ın başka bir aşamasında geliştirirken aşamanın üretim sisteminizin tam bir klonu olmasını şiddetle öneririz. Sugar&#39;ım bağımsız bir aşamasında oluşturulan süreçler/iş kuralları/e-posta şablonları içe aktarma işleminin tamamlanmasından sonra istendiği gibi çalışmayabilir. Süreçler/iş kuralları/e-posta şablonları özel alan adları, aşağı açılır değerler, veri taban kimlikleri vb. dahil ancak bunlarla sınırlı olmamakla birlikte belirli Studio veya uygulama alanı değişikliklerine dayanabilir. Bu değerler, süreç/iş kuralları/e-posta şablonunun oluşturulduğu aşamada benzer değildir, süreci/iş kuralını/e-posta şablonunu hedef aşamanızda yeniden oluşturmanız gerekebilir.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'Yine de bu içe aktarma işlemine devam etmek istiyor musunuz?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'Yine de dışa aktarma işlemine devam etmek istiyor musunuz?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'Aşağıdaki açılır alanlar geçersiz seçenekler içeriyor',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'Sürece göre bekleyen aktiviteler',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'Beklenen Aktiviteler',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'Sürece göre bekleyen aktiviteler',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'Tüm Süreçler',
    'LBL_RECORD_DASHBOARD' => 'Kayıt Panosu',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'İşlem Sonucu Özeti',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'Süreç Durum Tanımı',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'İşlemde',
    'LBL_PMSE_COMPLETED_STATUS' => 'Tamamlandı',
    'LBL_PMSE_CANCELLED_STATUS' => 'İptal Edilmiş',
    'LBL_PMSE_TERMINATED_STATUS' => 'Sonlandırıldı',
    'LBL_PMSE_ERROR_STATUS' => 'Hata',
    'LBL_PMSE_SETTINGS' => 'SugarBPM Ayarları',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'Bu kaydı deaktive etmek istediğinizden emin misiniz?',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'Bu kaydı aktive etmek istediğinizden emin misiniz?',
    'LBL_PRO_DELETE_CONFIRMATION' => 'Bu kaydı silmek istediğinizden emin misiniz?',

    'LBL_PRO_ENABLE' => 'Güncelliyor',
    'LBL_PRO_DISABLE' => 'Güncelliyor',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} bir işleme katılıyor ve bazı kilitli alanları içerebilir. Kaydı düzenlemek için buraya tıklayın {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'Bu alan, çalışan bir işleme katıldığı için kilitli.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'Bu kayıt bir işleme katılıyor ve bazı kilitli alanları içerebilir.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'İş Merkezi',
    'LBL_BUSINESS_CENTER_ID' => 'İş Merkezi Kimliği',
    'LBL_BUSINESS_CENTER_NAME' => 'İş Merkezi Adı',

    'LBL_PLIS_ACTIVITIES' => 'Satın Alınmış Kalemler Aktiviteleri',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(Yeni Etiket)',
    'LBL_TAG_FETCH_ERROR' => 'Etiketler alınırken bir hata oluştu.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'SugarCRM javascript kullanımına ihtiyaç duyar. Lütfen kullanıma devam etmek için javascript aktive edin.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'Seri hale getirilmiş veri, seri halden çıkarılamadı',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'Seri hale getirilmiş veri, seri halden çıkarılamadı çünkü nesneler ve sınıflar için referanslar içeriyor',

    'LBL_FIELD_TRIMMED' => 'Alan, maksimum karakter limitini aştığından dolayı kesildi.',
    'LBL_FIELDSIZE_OVERFLOW' => 'Alan maksimum karakter sınırını aşıyor.',
    'LBL_TINYMCE_TARGET_SAME' => 'Aynı pencere',
    'LBL_TINYMCE_TARGET_NEW' => 'Yeni pencere',

    'LBL_OUTBOUND_EMAILS' => 'E-Posta Ayarları',
    'LBL_OUTBOUND_EMAIL' => 'E-posta Ayarı',

    'LBL_EMAIL_PARTICIPANTS' => 'E-posta Katılımcıları',
    'LBL_EMAIL_PARTICIPANT' => 'E-posta Katılımcısı',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'Veri Gizliliği',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'Veri Gizliliği',
    'LBL_DATAPRIVACY_VIEW_PII' => 'Kişisel Bilgileri Göster',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'Silmek İçin İşaretle',
    'LBL_DATAPRIVACY_FIELDNAME' => 'Alan',
    'LBL_DATAPRIVACY_VALUE' => 'Değer',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'Değiştiren',
    'LBL_DATAPRIVACY_SOURCE' => 'Kaynak',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'Son Gücellenen',
    'LBL_DATAPRIVACY_PII' => 'Kişisel Bilgiler',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'Silmek İçin İşaretle',
    'TPL_DATAPRIVACY_PII_TITLE' => '{{{name}}} için Kişisel Bilgiler',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'Zamanlayıcıları Değiştirin',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'Mesajlar',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'Panonuza kopyalandı!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'Panonuza kopyalanamadı',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'Onay Bağlantısını Kopyalayın',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'Zaman Çizelgesi',
    'LBL_NO_ACTIVITY' => 'Aktivite Yok',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} Zaman Çizelgesi',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'Daha fazla',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'Daha Az',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'Zaman çizelgesi, geçerli kaydın ilgili kayıtlarını görüntüler, zaman içinde alan güncelleştirmelerini seçin.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'Daha fazlasını göster...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'Daha az göster...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'Mevcut veri yok',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'Modül lisanslı değil.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'Aktif Abonelikler',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'Bu dashlet, sadece tek bir Hesaba bağlı olan modüller için eklenebilir. Daha fazla bilgi için <a href={{linkToDocumentation}}>Aktif Abonelikler dashleti</a> belgesine bakın.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'Bu bağlı Hesaba ait Satın Almaları göster:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'Belirli bir Hesap için aktif abonelikler.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', miktar {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'Toplam:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'Aktif abonelikler yok',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'Pano, {{module_name}} modülünün çalışması gerekli. {{module_name}} modülünü etkinleştirmekle ilgili yöneticinizle konuşun.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'Satın Alma Geçmişi',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'Belirli bir Hesap için Tüm Satın Almalar.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'Bu pano, sadece tek bir Hesaba bağlı olan modüller için eklenebilir. Daha fazla bilgi için <a href={{linkToDocumentation}} target="_blank">Satın Alma Geçmişi panosu</a> belgesine bakın.',
    'LBL_NO_PURCHASE_HISTORY' => 'Görüntülenecek Satın Alımlar yok',
    'LBL_NO_PLIS' => 'Satın Alınan Kalemler yok',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'Toplam',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'Miktar',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'Bu pano, Satın Alımlar ve Satın Alınan Kalemlerin çalışmasını gerektirir. Satın Alımların ve Satın Alınan Kalemlerin etkinleştirilmesiyle ilgili olarak yöneticinizle konuşun.',
    'LBL_SEARCH_PURCHASE_NAME' => 'Satın Alma Adına göre ara...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'Studio&#39;yu kullanarak kayıt görünüm panosu yerleşimini düzenlemek için ' .
        'Studio > {{module}} > Yerleşimler > Kayıt Görünüm Panosu. <a href={{linkToStudio}}>Studio&#39;da Düzenle</a>.',
    'LBL_SERVICE_LEVEL' => 'Hizmet Seviyesi',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'Numara',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'İzle',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'Öncelik/Durum',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'Konu/Açıklama',

//Service Duration
    'LBL_SERVICE_DURATION' => 'Hizmet Süresi',
    'LBL_SERVICE_DURATION_VALUE' => 'Hizmet Süresi Değeri',
    'LBL_SERVICE_DURATION_UNIT' => 'Hizmet Süresi Birimi',
    'LBL_LOCK_DURATION' => 'Kilitleme Süresi',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Amazon Connect CCP yüklenemedi. Lütfen' .
        'bir ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">desteklenen tarayıcı</a>. ' .
        'Sorun devam ederse lütfen Sugar Yöneticinizle iletişime geçin.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Sugar Yöneticiniz, Amazon Connect için kurulumunuzu yapılandırmadı.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Amazon Connect ile bağlantı kurulamıyor. Destek için lütfen Sugar Yöneticinizle iletişime geçin.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'Bilinmeyen',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'Odak Bölmesi',
    'LBL_CLOSE_FOCUS_DRAWER' => 'Odak Bölmesini Kapat',
    'LBL_EXTERNAL_GUESTS' => 'Harici Misafirler',
    'LBL_MY_FAVORITE_TASKS' => 'Favori Görevlerim',
    'LBL_RECORD' => 'Kayıt',

    'LBL_MY_TASKS' => 'Görevlerim',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'Alan bulunamadı: Modülde {0}: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => '{0} içeren kayıt bulunamadı: Modülde {1}: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'Adı geçen ilişki bulunamadı: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'Kimliği veri tabanı girişi: {0}, {1} içeren: Modülde {2}: {3} zaten var',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'silinen yazılım (silinen bayraklı = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => '{2} modülünde {0} {1} için birden fazla veri tabanı kaydı bulundu . ' .
        'Lütfen eşleşen kayıtları uygun şekilde kaldırın veya güncelleyin. Eşleşen kayıtlar: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'Sonraki Çalıştırma',
    'LBL_TIME_AWARE_TYPE' => 'Tip',
    'LBL_TIME_AWARE_BEAN_ID' => 'Çekirdek kimliği',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'Etiketi Görüntüle',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'Açık Kayıt Görünümü',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'Ekle',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'Yardım mevcut değil',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'Fonksiyonlar',
    'LBL_ACTIONBUTTON_FIELDS' => 'Alanlar',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'Alan Seçin...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Topla',
    'LBL_ACTIONBUTTON_RELATED' => 'İlişkili',
    'LBL_ACTIONBUTTON_SAVE' => 'Kaydet',
    'LBL_ACTIONBUTTON_CANCEL' => 'İptal',
    'LBL_ACTIONBUTTON_R_MODULE' => 'İlişkili Modül',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'İlişkili Alanlar',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'Toplama Modülü',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'Toplama Alanları',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'Toplama Fonksiyonu',
    'LBL_ACTIONBUTTON_MINIMUM' => 'Dak.',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'Maks.',
    'LBL_ACTIONBUTTON_AVERAGE' => 'Ortalama',
    'LBL_ACTIONBUTTON_SUM' => 'Toplam',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'Kaydı Ata',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'E-Posta Oluştur',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'Kayıt Oluştur',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Belge Birleştirme',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'Url Aç',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'Raporu Çalıştır',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'Kaydı Güncelle',
    'LBL_ACTIONBUTTON_ACTION' => 'Aksiyon',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'Şuna Ata:',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'Şuraya E-posta Gönder:',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'PMSE Kullan',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'Şablon',
    'LBL_ACTIONBUTTON_MODULE' => 'Modül',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'Ekran Ayarları',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'Tip',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'Açılır Liste',
    'LBL_ACTIONBUTTON_BUTTON' => 'Düğme',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'Düğme Grubu',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'Kayıttaki Etiketi Görüntüle',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'Başlıkta Göster',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'Düzenlemede Gizle',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'Odak Gösterge Tablosu Üstbilgisinde Görüntüleme',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'Gösterge Tablosu',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'Odak Panosu Başlığı',
    'LBL_ACTIONBUTTON_SIZE' => 'Boyut',
    'LBL_ACTIONBUTTON_DEFAULT' => 'Varsayılan',
    'LBL_ACTIONBUTTON_SMALL' => 'Küçük',
    'LBL_ACTIONBUTTON_LARGE' => 'Büyük',
    'LBL_ACTIONBUTTON_CALCULATED' => 'Hesaplandı',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'PDF&#39;e dönüştür',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Belge Birleştirme',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'Ön İzleme',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'Özellikler',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'Etiket',
    'LBL_ACTIONBUTTON_DESC' => 'Araç İpucu',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'Etiketi Göster',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'Simgeyi Göster',
    'LBL_ACTIONBUTTON_SCHEME' => 'Renk Şeması',
    'LBL_ACTIONBUTTON_ICON' => 'Simge',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'Bağımlı',
    'LBL_ACTIONBUTTON_DESIGN' => 'Yerleşim Yapılandırma',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'Hatada Dur',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'Otomatik Kaydetme',
    'LBL_ACTIONBUTTON_CONFIG' => 'Yapılandır',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'Lütfen kaydetmeden önce Aksiyon Düğmenizi yapılandırın.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'Yapılandırma Düğmeleri',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'Otomatik Oluşturma',
    'LBL_ACTIONBUTTON_LINK' => 'Ebeveyn ile İlişki Oluşturun',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'Üst Değerleri Kopyala',
    'LBL_ACTIONBUTTON_PRESET' => 'Alan Değer(ler)ini Ayarla',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'Ebeveynden Gelen Alan Değer(ler)ini Kopyala',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'Seç...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'Üst Alandan ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'Bu düğmeyi silmek istediğinizden emin misiniz?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'Bu aksiyonu silmek istediğinizden emin misiniz?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'Geçersiz Aksiyon Düğmesi Verisi',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'Kaydetmeden önce lütfen bir modül seçin.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'Lütfen kaydetmeden önce bir bağlantı seçin. Bağlantı mevcut değilse lütfen bağlantı seçeneğinin işaretini kaldırın.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'Lütfen kaydetmeden önce bir kayıt seçin.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'Kaydetmeden önce lütfen bir şablon seçin.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'Birincil',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'İkincil',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'Okyanus',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'Pembe',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'Askeri',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'Deniz mavisi',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'Pasifik',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'Yeşil',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'Sarı',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'Turuncu',
    'LBL_ACTIONBUTTON_THEME_RED' => 'Kırmızı',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'Mercan',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'Mor',
    'LBL_ACTIONBUTTON_FORMULA' => 'Formül',
    'LBL_ACTIONBUTTON_ACTIONS' => 'Aksiyonlar',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'Düğme verileri doğrulanırken hata oluştu.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'Düğmelerin en az bir etiket veya simge seti olması gerekir.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'Lütfen geçerli bir düğme etiketi girin.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'Eksik gerekli değerler nedeniyle kayıt oluşturulamadı. Lütfen yöneticinize başvurun.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'Bu düğme türü için en az iki aktif düğmeye sahip olmalısınız.',
    'LBL_ACTIONBUTTON_RECORD' => 'Kayıt Görüntüleri',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'Aksiyon Menüleri',
    'LBL_ACTIONBUTTON_ORDER' => 'Sipariş',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'Liste Görünümü',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'Kayıt Görüntüleme Başlığı',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'Kayıt Görüntüle Panosu Başlığı',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'Alt Paneller',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'görev dizisi yürütme motoru aşağıdaki eylemleri gerçekleştiremedi: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'Aksiyon Ekle',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'Bu Aksiyonu Kaldır',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'Geçerli Kullanıcı',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'Belge Birleştirme',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'PDF&#39;e Belge Birleştirme',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'Şirket Boyutu',
    'LBL_HINT_COMPANY_INDUSTRY' => 'Endüstri',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'Endüstri Etiketleri',
    'LBL_HINT_COMPANY_LOCATION' => 'Şirket Konumu',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'Şirket Tanımı',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'Kuruluş Yılı',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Şirket Facebook Adresi',
    'LBL_HINT_COMPANY_TWITTER' => 'Şirket Twitter Adresi',
    'LBL_HINT_COMPANY_PIC' => 'Şirket Logosu',
    'LBL_HINT_CONTACT_PIC' => 'Kontak Fotoğrafı',
    'LBL_HINT_COMPANY_WEBSITE' => 'Şirket Web Sitesi',
    'LBL_HINT_PHOTO' => 'Fotoğraf Bağlantısı',
    'LBL_HINT_JOB_2' => 'Önceki İşler',
    'LBL_HINT_EDUCATION' => 'Eğitim',
    'LBL_HINT_EDUCATION_2' => 'Ek Eğitimler',
    'LBL_HINT_TWITTER' => 'Twitter Bağlantısı',
    'LBL_HINT_FACEBOOK' => 'Facebook Bağlantısı',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS Kodu',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC Kodu',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'MY Sonu',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'Yıllık Gelir',
    'LBL_HINT_PHONE_1' => 'Telefon 1',
    'LBL_HINT_PHONE_2' => 'Telefon 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'Masaya katıl',
    'LBL_HINT_FULL_NAME' => 'Tam İsim',
    'LBL_HINT_JOB_TITLE' => 'İş Unvanı',
    'LBL_HINT_OFFICE_PHONE' => 'Ofis Telefonu',
    'LBL_HINT_MOBILE_PHONE' => 'Cep Telefonu',
    'LBL_HINT_OTHER_PHONE' => 'Diğer Telefon',
    'LBL_HINT_WEBSITE' => 'Web Sitesi',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'Sugar Hint&#39;te bulunan yeni verilerle bu kayıt için mevcut tüm verilerin üzerine yazmayı istiyor musunuz?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'Sugar Hint&#39;te bulunan yeni {{fieldName}} ile bu kayıt için mevcut {{fieldName}} üzerine yazmayı istiyor musunuz?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'Verilerle ilişkili tüm hesaplar silinecek. Devam etmek istediğinizden emin misiniz?',
    'LBL_HINT_COMPANY_LOGO' => 'Logo',
    'LBL_HINT_CONTACTS_AVATAR' => 'Fotoğraf',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint Accountsets Etiketleri',

    'LBL_HINT_LOADING' => 'Yüklüyor ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Sugar Hint kaldırılıyor, lütfen bekleyin',
    'LBL_HINT_VALUE_ERASED' => ' Değer Silindi ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'Bu bilgiler, veri gizliliği isteği vasıtasıyla silindi',

    'LBL_HINT_UNINSTALL_TITLE' => 'Lütfen aşğıdan kaldırma seçeneklerinden birini seçin:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Sadece Hint paketini kaldır',
    'LBL_HINT_UNINSTALL_FULL' => 'Hint&#39;i tamamen kaldır',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'Bu seçenek Hint MLP&#39;yi kaldıracak ve Sugar Hint Insights&#39;a olan tüm aktif abonelikleri devre dışı bırakacak.
    Hint&#39;in yeniden kurulması, abonelikleri otomatik olarak yeniden aktif hale getirecek.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'Bu seçenek, MLP&#39;nin kaldırılması ve tüm yapılandırma ve abonelik bilgilerinin silinmesi dahil olmak üzere, Hint&#39;in tam olarak kaldırılmasını gerçekleştirir.',
    'LBL_HINT_UNINSTALL' => 'Kaldır',
    'LBL_HINT_UNINSTALL_HEADER' => 'Sugar Hint&#39;i Kaldır',
    'LBL_HINT_CANCEL' => 'İptal',
    'LBL_HINT_UNINSTALL_WARNING1' => 'UYARI: Bu seçeneği, yalnızca gelecekte Hint&#39;i kullanmayı düşünmüyorsanız seçin.
    Kaldırma işlemini gerçekleştirmeden önce Sugar veri tabanınızın tam yedeğini alarak Sugar&#39;ı bakım moduna alın. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'Kaldırma işlemi ile ilgili ayrıntılar için ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint Yönetim Kılavuzu ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'bakın.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Sadece Sugar Hint paketini kaldırmak istediğinizden emin misiniz?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Sugar Hint&#39;i tamamen kaldırmak istediğinizden emin misiniz?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(DİKKAT: BU İŞLEMİ GERİ ALAMAZSINIZ)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint Alanları',
    'LBL_HINT_NO_RESULTS_MSG' => 'Sonuç bulunamadı.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'Temel Hint Paneli Düzeni',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'Hesaplar',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'Kontaklar',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'Potansiyeller',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'Genişletilmiş Hint Paneli Düzeni',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'Yukarıdaki Hint Paneli Düzeni kısmında sürükleyip bırakarak alanları yeniden ayarlayın.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'Ayrıntılı talimatlar ve varsayılan alanların bir listesi için, ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' modülün varsayılan ayarları geri yüklemeye ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'bakın.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => '{{module}} modülü için varsayılanlara geri dönmek istediğinizden emin misiniz?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'Buraya Tıklayın',
    'LBL_HINT_CONFIG_NAME' => 'Hint Yönetim Kılavuzu.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'Alanlar',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'Zenginleştirilmiş Alanlar',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'Bu bölüm, Hint tarafından zenginleştirilmiş tüm Hint alanlarını ve Sugar alanlarını listeler. Hint alanları bir yıldız (*) ile işaretlenmiştir ve yalnızca zenginleştirilmişlerse Hint panelinde gösterilebilir.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'Alan İsmi',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'Zenginleştirilmiş Alan',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Hint&#39;te Göster',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Hint Panelinde Göster',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'İlave Sugar Alanları',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'Bu bölüm, Hint tarafından zenginleştirilmeyen tüm Sugar alanlarını listeler.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'Uyarı',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'Dikkat: Sugar Hint Insights hizmetiyle eşitlemek üzeresiniz. Bekleyen tüm e-posta özet öyküleri kaybolacak ve mevcut haberler Insights kontrol panelinden silinecek. Senkronizasyon tamamlandıktan sonra her türdeki bildirimler devam edecektir.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => '{{_moduleSingular}} ile ilgili önerilen şirketler aşağıda listelenmiştir. Görüntülenecek şirket verilerini seçin.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'Hesap seçilmedi',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'Birden fazla e-posta bulundu, içe aktarılacak e-postaları seçin: ',

    'LBL_HINT_HELP_MESSAGE1' => 'Girilen verilere dayanarak Hint, sistemde bir eşleşme bulamadı.',
    'LBL_HINT_HELP_MESSAGE2' => 'Hint&#39;te en iyi sonuçlar, bir kişinin adı ve e-posta adresiyle bulunabilir.',
    'LBL_HINT_HELP_MESSAGE3' => 'Hint&#39;te en iyi sonuçlar, şirket web sitesinin url&#39;si ile bulunabilir.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "{{_moduleSingular}}'ınızın şirket adını veya web sitesini girin, Hint, ilave verileri arayacaktır.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "{{currentModule}}'ınızın e-posta adresini girin, Hint, ilave verileri arayacaktır.",

    'LBL_HINT_HISTORY_NONE' => 'Tahrihsel görünüm çin mevcut veri yok',
    'LBL_HINT_HISTORY_TITLE' => 'Aktivite Geçmiş',

    'LBL_HINT_PREVIEW_TITLE' => 'Veri zenginleştirme',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Hint hizmetinizin lisans süresi sona erdi. Lisansınızı yenilemek için SugarCRM yöneticinizle iletişime geçin.',
    'LBL_HINT_PREVIEW_QUESTION' => 'Hint&#39;in sizin ve şirketiniz için nelere yapabileceğini görmek ister misiniz? Hint&#39;i eklemek için SugarCRM yöneticinizle iletişime geçin.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'Hesap bilgileri bulunamadı',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'Zenginleştirilmiş veriler bulundu - zenginleştirilmiş tüm ner,ler, kaydınıza kopyalamak için tıklayın.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'Zenginleştirilmiş verileri kaydınza kaydetmek için tıklayın.',

    'LBL_HINT_CONTACTS_TITLE' => 'İlişkili Kontaklar',
    'LBL_HINT_CONTACTS_NONE' => 'İlişkili olmayan kontaklar',

    'LBL_HINT_NEWS' => 'Haber',
    'LBL_HINT_GENERAL' => 'Genel',
    'LBL_HINT_ALL_NEWS' => 'Bütün Haberler',
    'LBL_HINT_FILTER_NEWS' => 'Haberleri Filtrele',
    'LBL_HINT_FINANCIAL_NEWS' => 'Mali',
    'LBL_HINT_PERSONNEL_NEWS' => 'Personel',
    'LBL_HINT_PRESS_RELEASES' => 'Basın Duyuruları',
    'LBL_HINT_OTHER_NEWS' => 'Diğer',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'Haber makaleleri ara',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'Mevcut haber yok',
    'LBL_NEW_NOTIFICATIONS' => 'Yeni bildirimler',
    'LBL_HINT_DASHLET_ALLOWED1' => 'Sugar Hint Insights panosunu görmek için bir Sugar Hint lisansınız olmalı.
    Yöneticinizden bir Hint lisansı almayı isteyin.',

    'LBL_HINT_FOR' => 'İçin',
    'LBL_HINT_WITH' => 'ile',
    'LBL_HINT_SHOW_ME' => 'Bana göster: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'Beni şununla bilgilendir: ',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insights Tercih Merkezi',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'Tercih Seçenek Tuşu',
    'LBL_HINT_PREFERENCES' => 'Tercihler',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'Silme devre dışı, en az bir tercih ifadesi gerekli',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'Ekleme devre dışı, maksimum tercih ifadesine ulaştınız',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Sugar Hint Insights panosuna dahil et',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'Masaüstü bildirimi olarak açılır pencere',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'Sürekli olarak bildirim almak için tüm tarayıcılarda ve tüm masaüstü bilgisayarlarda bildirimler etkinleştirilmelidir.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Internet Explorer gibi bazı tarayıcılar, bildirimleri desteklemez. Bildirimleri desteklemeyen bir tarayıcı kullanılırken bildirimler etkinleştirilemez.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'Her bildirim için anlık e-posta gönder',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'Günlük bir e-posta özeti gönder',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'Haftalık bir e-posta özeti gönder',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'Tercihler kaydedilemedi. Sistem bağlantınızı kontrol ederek tekrar deneyin.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'Bazı zorunlu alanlarda bir değer eksik. Lütfen tercihlerinizi kontrol edin ve zorunlu tüm alanların doldurulduğundan emin olun.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'Tarayıcı bildirimlerinizi Sugar Hint Insights için etkinleştirmek üzeresiniz. Devam etmek için Onayla düğmesine tıklayın. Ardından tarayıcınız, bildirim olaylarının alınmasına izin vermek için sizden izin isteyecektir.',
    'LBL_HINT_PUSH_ERROR' => 'Anlık Bildirimler eklentisi, bağımlılıkları olmadan {{options.type}} için kaydedildi. Eklenti istendiği gibi çalışmayacak, lütfen çalışma dosyasına bir yol ve aboneliği sunucuya kaydetmek için bir yöntem sağladığınızdan emin olun.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'Tüm kullanıcılar için Hint bildirimlerini AÇIN',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'Tüm kullanıcılar için Hint bildirimlerini KAPATIN',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'UYARI: Sugar Hint&#39;in kaldırılması sırasında bildirimler devre dışı bırakılamadı. Bildirimleri devre dışı bırakmak için Sugar Hint 5.4.0 veya üstünü yükleyin ve Sugar&#39;ın Yönetim bölümünde bulunan Sugar Hint Uninstaller&#39;ı kullanarak tam bir kaldırma işlemi gerçekleştirin.',
    'LBL_HINT_ENRICH_ALL' => 'Tümünü Zenginleştirin',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'İpucu Lisansı Gerekli',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'Haritalar Yapılandırması',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'Coğrafi Kodlayıcı Günlük Görüntüleyici',
    'LBL_MAP_MAP' => 'Harita',
    'LBL_MAP_MAPS' => 'Haritalar',
    'LBL_MAP_GEOCODING_RECORD' => 'Coğrafi Kodlama',
    'LBL_MAP_GEOCODE_SUCCESS' => 'Kaydın coğrafi kodlaması yapıldı.',
    'LBL_MAP_LATITUDE' => 'Enlem',
    'LBL_MAP_LONGITUDE' => 'Boylam',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'Adrese göre ara...',
    'LBL_MAP_ALREADY_GEOCODED' => 'Mevcut kayıt zaten coğrafi olarak kodlanmış. Bu kayıt için coğrafi kodlamanın üzerine yazmak istediğinizden emin misiniz?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'Manuel Coğrafi Kodlama',
    'LBL_MAP_POINT_COORDINATES' => 'Harita Noktası Koordinatları',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'En iyi rota hesaplanıyor...',
    'LBL_MAP_DIRECTIONS' => 'Yönlendirmeler',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'Mevcut Kullanıcıdan başlayan yönlendirmeler',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'Bu kayıttan başlayan yönlendirmeler',
    'LBL_MAPS_RADIUS_INPUT' => 'Yarıçap (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'Posta Kodundan başlayan bir yarıçap içinde',
    'LBL_MAPS_DISTANCE' => 'Mesafe',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'Posta Kodu',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'Geçersiz Yapılandırma: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> alan eşleştirmesi geçersiz.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'Harita Türü',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'Yakınlaştırma Seviyesi',
    'LBL_MAPS_DASHLET' => 'Haritalar',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'Harita üzerinde coğrafi olarak kodlanmış kayıtları görüntüler.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'Haritalar, bu modül için kullanılamaz. Lütfen Yönetici konsolunda etkinleştirin.',
    'LBL_MAP_MODULES' => 'Modül',
    'LBL_MAP_FILTER_BY' => 'Filtreleme Ktiteri',
    'LBL_MAP_UNIT_TYPE' => 'Birim Türü',
    'LBL_MAP_UNIT_TYPE_MILES' => 'Mil',
    'LBL_MAP_UNIT_TYPE_KM' => 'Kilometre',
    'LBL_MAP_ADDRESS' => 'Adres',
    'LBL_MAP_NO_STARTING_POINT' => 'Başlangıç noktası coğrafi olarak kodlanmamış.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'Başlangıç noktası kaydı coğrafi olarak kodlanmamıştır.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'Seçilen kayıtlardan bazıları coğrafi olarak kodlanmamış ve haritada görüntülenmeyecek.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'Kayıt/Kayıtlar coğrafi olarak kodlanmamış.',
    'LBL_MAPS_MODULE_FIELDS' => 'Modül Alanları',
    'LBL_MAPS_SELECT_FIELD' => 'Alan Seçin',
    'LBL_MAPS_RELATE_RECORD' => 'İlgili Kayıt',
    'LBL_MAPS_MAPPING_TYPE' => 'Haritalama Türü',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'Coğrafi Olarak Kodlanmış Kayıtlar Yok',
    'LBL_MAPS_ADDRESS' => 'Adres',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'Atanan Kullanıcı',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'Belirli bir nokta için sokak görünümü mevcut değil',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> kayıtları haritalama için geçerli değil. Lütfen modülü listeden kaldırın.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'Kapat',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'Genişlet',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'PDF olarak kaydet',
    'LBL_MAPS_EMAIL_LINK' => 'E-Posta Bağlantısı',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'En az bir coğrafi kodlu kaydınız olmalı.',
    'LBL_MAPS_GENERATING' => 'Harita oluşturuluyor...',
    'LBL_MAPS_POINTS' => 'Harita Noktaları',
    'LBL_MAPS_POINT' => 'Nokta',
    'LBL_MAPS_TRAVEL_DETAILS' => 'Seyahat Detayları',
    'LBL_MAPS_TOTAL_DISTANCE' => 'Toplam Mesafe',
    'LBL_MAPS_TOTAL_DURATION' => 'Toplam Süre',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'Ttafik olmadan Toplam Süre',
    'LBL_MAPS_ITINERARY' => 'Yol güzergahı',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'Yolculuk Mesafesi',
    'LBL_MAPS_TRAVEL_DURATION' => 'Yolculuk Süresi',
    'LBL_MAPS_TRAVEL_STEPS' => 'Adımlar',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'Uyarılar',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Maps, paylaşılan bir haritada en fazla 10 nokta destekler. Lütfen seçiminizi gözden geçirin.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'Harita Lisans Gerekli',
    'LBL_MAPS_SHARE_HELLO' => 'Merhaba,',
    'LBL_MAPS_SHARE_HEADER' => 'Şu noktalar için bir Bing harita talep ettiniz:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'Aşağıdaki URL, Bing Haritalar&#39;da yukarıdaki noktaları içeren bir harita açacak:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Bing Haritalar&#39;da Harita Göster',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Haritalar',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'Girilen ara noktalar için rota bulunamadı.',
    'LBL_MAPS_GEOCODE_STATUS' => 'Durumu için Coğrafi Kodlama Yap',
    'LBL_MAPS_GEOCODED' => 'Coğrafi kodlama yapıldı',
    'LBL_MAPS_NOT_GEOCODED' => 'Coğrafi kodlu değil',
    'LBL_MAPS_NOT_FOUND' => 'Geçersiz Adres',
    'LBL_MAPS_GEOCODING_FAILED' => 'Coğrafi kodlama yapılamadı',
    'LBL_MAPS_QUEUED' => 'Sıraya alındı',
    'LBL_MAPS_REQUEUED' => 'Yeniden sıraya alındı',
    'LBL_MAPS_RELATED_RECORD' => 'İlgili Kayıt',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'Raporu Görüntüle',
    'LBL_REPORT_DASHLET_DESC' => 'Kaydedilmiş bir raporu görüntüleyin',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'Dashlet Varsayılanlarına Sıfırla',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'Rapor Varsayılanlarına Sıfırla',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'Sonuçları Yenile',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'Grafiği Panoya Kopyala',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'Grafik İndir',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'Pencere {{label}} raporu düzenlendi ve pencere varsayılan yapılandırmaya sıfırlandı.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'Bu alanı kullanmak için izniniz bulunmamaktadır.',

    'LBL_INVALID_FORMULA' => 'Geçersiz formül',
    'LBL_RETURN_TYPE_MISSMATCH' => 'Fonksiyon dönüş türü eşleşmiyor',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'Öngörü',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'İdeal Müşteri Profili',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'Hafta Tahmin Puanlarını Kapat',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'Tahmin Değeri',
    'LBL_AI_CONV_BIN_ACCURACY' => 'Tahmin Kutusu Doğruluğu',
    'LBL_AI_CONV_MULTIPLIER' => 'Tahmin Çarpanı',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP Değeri',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP Kutusu Doğruluğu',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP Çarpanı',
    'LBL_AI_NEW' => 'Yeni',
    'LBL_AI_ENTERED' => 'Girildi',
    'LBL_AI_CREATED' => 'Oluşturuldu',
    'LBL_AI_WEEK' => 'Hafta',
    'LBL_AI_MONTH' => 'Ay',
    'LBL_AI_QUARTER' => 'Üç Ay',
    'LBL_AI_BYWEEK' => 'Haftaya Bazında',
    'LBL_AI_BYMONTH' => 'Aya Bazında',
    'LBL_AI_BYQUARTER' => 'Üç Ay Bazında',
    'LBL_AI_WEEKTREND' => 'Haftalık trend',
    'LBL_AI_MONTHLYTREND' => 'Aylık trend',
    'LBL_AI_QUARTERTREND' => 'Üç aylık trend',
    'LBL_AI_TREND' => 'Trend tarafından',
    'LBL_AI_TRENDS' => 'Trendler tarafından',
    'LBL_AI_VELOCITY' => 'Hız',
    'LBL_AI_TOPX' => 'Üst {X}',
    'LBL_AI_TIMESPAN' => 'Aşamalar Arasındaki Zaman Aralığı -',
    'LBL_AI_BUSINESSTREND' => 'İş Trendleri ile',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Sugar Insights ile tanışın!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights, SugarCRM verilerinizle ilgili yeni anlayışlar oluşturmak için nicel analizden yararlanır. Sugar olarak, verilerinizden en iyi şekilde yararlanmanıza ve bilinçli kararlar almanıza yardımcı olmak için her zaman yeni yollar arıyoruz ve bu, Sugar Insights ile sunmayı umduğumuz şeylerin sadece başlangıcı.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights, SugarCRM verilerinizle ilgili yeni anlayışlar oluşturmak için nicel analizden yararlanır.',
    'LBL_AI_FIRMO' => 'Firmografi',
    'LBL_AI_TOTALCOUNT' => 'Toplam sayım',
    'LBL_AI_DAYSFROMLATESTACT' => 'Şundan bu yana geçen günler',
    'LBL_AI_DAYSSINCE' => 'yaş',
    'LBL_AI_FIELDISSET' => 'var',
    'LBL_AI_CONTACTCOMPLETENESS' => 'İletişim bilgilerinin eksiksiz olması',
    'LBL_AI_CUTDATE' => 'Tahmin süresi',
    'LBL_AI_FROMLASTCHANGE' => 'Son özellik değeri değişikliğinden itibaren geçen günler',
    'LBL_AI_CALLSHELD' => 'Bekletilen toplam arama sayısı',
    'LBL_AI_CALLSPLANNED' => 'Planlanan toplam arama sayısı',
    'LBL_AI_OUTBOUNDCALLS' => 'Giden aramaların toplam sayısı',
    'LBL_AI_INBOUNDCALLS' => 'Gelen aramaların toplam sayısı',
    'LBL_AI_AVGCALLDURATION' => 'Ortalama arama süresi',
    'LBL_AI_EMAILSARCHIVED' => 'Arşivlenen e-postaların toplam sayısı',
    'LBL_AI_EMAILSREAD' => 'Okunan toplam e-posta sayısı',
    'LBL_AI_EMAILSSENT' => 'Gönderilen toplam e-posta sayısı',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'Beklenen Kapanış Tarihinin daha ileri bir tarih olarak değiştirildiği toplam kayıt sayısı',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'Beklenen Kapanış Tarihinin daha sonra bir tarih olarak değiştirildiği toplam kayıt sayısı',
    'LBL_AI_AMOUNTINCREASED' => 'Miktarın arttığı toplam fırsatlar',
    'LBL_AI_AMOUNTDECREASED' => 'Miktarın azaldığı toplam fırsatlar',

    // User last state
    'LBL_LAST_STATE' => 'Son durum',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'DocuSign&#39;a Gönder',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'Alıcıyı düzenlemeyi iptal et',
    'LBL_RECIPIENT_ROLE' => 'Alıcı rolü',
    // Base sales stages
    'LBL_OPEN' => 'Aç',
    'LBL_CLOSED_WON' => 'Başarıyla Kapandı',
    'LBL_CLOSED_LOST' => 'Başarısızlıkla Kapandı',
    'LBL_KIOSK_ADD_FILES' => 'Dosyalar ekle',
    'LBL_KIOSK_ADD_DROP_FILES' => 'Dosyaları ekleyin veya buraya sürükleyin',
    'LBL_KIOSK_CANCEL' => 'İptal',
    'LBL_KIOSK_EDIT' => 'Düzenle',
    'LBL_KIOSK_EMAIL' => 'E-posta',
    'LBL_KIOSK_FILES_UPLOADING' => 'Yükleniyor',
    'LBL_KIOSK_FILES_ERROR' => 'Ek yüklemesi başarısız oldu',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'Ek çok büyük',
    'LBL_KIOSK_FILTER_SEARCH' => 'Ara',
    'LBL_KIOSK_ID' => 'KİMLİK',
    'LBL_KIOSK_TITLE' => 'Kiosk',
    'LBL_KIOSK_LANGUAGE' => 'Dil',
    'LBL_KIOSK_LAST_UPDATED' => 'Son Gücellenen',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'Göster',
    'LBL_KIOSK_MENU' => 'Menü',
    'LBL_KIOSK_MOBILE_PHONE' => 'Cep Telefonu',
    'LBL_KIOSK_MY_ACTIVITIES' => 'Aktivitelerim',
    'LBL_KIOSK_MY_PROFILE' => 'Profilim',
    'LBL_KIOSK_NAME' => 'Ad',
    'LBL_KIOSK_OFFICE_PHONE' => 'Ofis Telefonu',
    'LBL_KIOSK_ORGANIZATION' => 'Şirket',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'Sayfa başına satırlar:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'SugarCRM tarafından desteklenmektedir',
    'LBL_KIOSK_SAVE_CHANGES' => 'Değişiklikleri Kaydet',
    'LBL_KIOSK_SHOW_HIDE' => 'Göster/Gizle',
    'LBL_KIOSK_SIGN_IN' => 'Oturumu Aç',
    'LBL_KIOSK_SIGN_OUT' => 'Oturumu Kapat',
    'LBL_KIOSK_SORT_BY' => 'Sıralama kriteri',
    'LBL_KIOSK_SUBMIT' => 'Gönder',
    'LBL_KIOSK_TIMEZONE' => 'Saat dilimi',
    'LBL_KIOSK_ACTIVITY' => 'Etkinlik',
    'LBL_KIOSK_NO_ACTIVITY' => 'Gösterilecek etkinlik yok',
    'LBL_KIOSK_OLDEST_FIRST' => 'Önce en eski',
    'LBL_KIOSK_NEWEST_FIRST' => 'Önce en yeni',
    'LBL_KIOSK_SHOW_MORE' => 'Daha fazla göster',
    'LBL_KIOSK_ADD_A_REPLY' => 'Yanıt ekle',
    'LBL_KIOSK_REPLY_EMPTY' => 'Yanıt boş bırakılamaz.',
    'LBL_KIOSK_NUM_MORE' => '{{num}} tane daha',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'Hoş geldiniz',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'Kaynaklarınıza hızlı bir şekilde erişin.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'Talepleri ara',
    'LBL_KIOSK_SHOW_ALL' => 'Tümünü göster',
    'LBL_KIOSK_404_TITLE' => 'Bunu bulamadık',
    'LBL_KIOSK_TENANT_404_TITLE' => 'Kiracı bulunamadı',
    'LBL_KIOSK_404_MESSAGE' => 'Kaldırılmış, geçici olarak kullanılmayan bir bağlantıya tıkladınız, veya geçersiz bir URL girdiniz.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'Lütfen doğru URL&#39;ye sahip olduğunuzdan emin olun. Daha fazla yardım için lütfen Destek Bölümüyle iletişime geçin.',
    'LBL_KIOSK_BACK_TO_HOME' => 'Giriş Sayfasına Geri Dön',
    'LBL_KIOSK_ERROR_CODE' => '{code} Hata: ',
    'LBL_KIOSK_401_TITLE' => 'Yetkisiz',
    'LBL_KIOSK_401_MESSAGE' => 'Bu sayfayı görüntülemek için yetkiniz yok.',
    'LBL_KIOSK_403_TITLE' => 'Yetkisiz',
    'LBL_KIOSK_403_MESSAGE' => 'Bu sayfayı görüntülemek için erişiminiz yok.',
    'LBL_KIOSK_500_TITLE' => 'Sunucu yanıt vermiyor',
    'LBL_KIOSK_500_MESSAGE' => 'Bizim tarafımızda bir şeyler ters gitti.',
    'LBL_KIOSK_GO_BACK' => 'Geri git',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'Yinelenen kayıt bulundu',
    'LBL_KIOSK_ACCOUNT' => 'Hesap',
    'LBL_KIOSK_STATUS' => 'Durum',
    'LBL_KIOSK_DEACTIVATE' => 'Devre dışı bırak',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'Kullanıcı devre dışı bırakıldı',
    'LBL_KIOSK_MANAGE_USERS' => 'Kullanıcıları Yönet',
    'LBL_KIOSK_LAST_LOGIN' => 'Son Giriş',
    'LBL_KIOSK_FIRST_NAME' => 'İsim',
    'LBL_KIOSK_LAST_NAME' => 'Soyisim',
    'LBL_KIOSK_ROLE' => 'Görev',
    'LBL_KIOSK_INVITE' => 'Davet et',
    'LBL_KIOSK_SEND_INVITES' => 'Davet(ler) Gönder',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'Davet(ler) başarıyla gönderildi',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'Davet(ler) gönderilmedi',
    'LBL_KIOSK_REACTIVATE' => 'Yeniden etkinleştir',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'Kullanıcı yeniden etkinleştirildi',
    'LBL_KIOSK_RESET_PASSWORD' => 'Şifre Sıfırlama',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'Şifre sıfırlama e-postası gönderildi',
    'LBL_KIOSK_USER_PROFILE' => 'Kullanıcı Profili',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'Kullanıcınız devre dışı bırakıldı. Lütfen yöneticinizle iletişime geçin.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'Girişe geri dön',
    'LBL_KIOSK_REVOKE_INVITATION' => 'Daveti İptal Et',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'Davet başarıyla iptal edildi',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'Ara ve Seç...',
    'LBL_KIOSK_NO_MATCHES' => 'Eşleşme bulunamadı',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'Profil güncellendi.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'Profil güncellenirken hata oluştu.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'Belgeler',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'Gelen paylaşılan belgelerinizi görüntüleyin, arayın ve indirin.',
    'LBL_KIOSK_CASES' => 'Talepler',
    'LBL_KIOSK_CASES_DESC' => 'Sizinle paylaşılan talepleri görüntüleyin, arayın ve yanıtlayın.',
    'LBL_KIOSK_DOWNLOAD' => 'İndir',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'Dosya başarıyla indirildi',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'Başlarken',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'Size daha iyi yardımcı olabilmemiz için lütfen bize adınızı ve soyadınızı bildirin.',
    'LBL_KIOSK_SAVE' => 'Kaydet',
    'LBL_KIOSK_SHARED' => 'Paylaşılan',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'Hoş geldin {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'Arka Plan Rengi',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'Arka Plan Görüntüsü URL&#39;si',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'Dosya boyutu 400K&#39;dan küçük olan bir görüntü seçmeniz önerilir.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'Arka Plan Türü',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'Ana Sayfa Arka Planı',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'Tema',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'Birincil Tema Rengi',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'Uygulama Adı',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'Bu, uygulamanızın başlığıdır ve logonuzun yanında gösterilir.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'Uygulama Logosu URL&#39;si',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'Küçük boyutlarda (ör. sosyal medya profilleri) en iyi görüntülenebilen bir logo seçmeniz önerilir. Ayrıca dosya boyutunun 200K&#39;dan küçük olması önerilir.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'Uygulama Yer İşareti Simgesi URL&#39;si',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'Yer işareti simgesi, tarayıcı sekmesinde sayfa başlığının yanında görünen küçük bir logodur.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'Açık Etkinlikleri Otomatik Yeniden Atama',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'Kullanıcı Sınırına Ulaşıldı',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'Geçersiz Lisans Anahtarı',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'Geçersiz Uygulama',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'Geçersiz Uygulama',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'Bozuk Doğrulama Anahtarı',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'Lisans Süresi Doldu',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'Eksik Bilgi',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'Eksik Doğrulama Anahtarı',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'Kullanıcı Eksik Erişimi',
    'LBL_DRI_WORKFLOW' => 'Akıllı Kılavuz',
    'LBL_DRI_WORKFLOWS' => 'Akıllı Kılavuzlar',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Akıllı Kılavuz Aşama Şablonu',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Akıllı Kılavuz Aşama Şablonları',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Akıllı Kılavuz Şablonu',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Akıllı Kılavuz Etkinlik Şablonu',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'Etkinlik Şablonları',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'Web Kancaları',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Web Çengelleri',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'Mevcut Akıllı Rehber Etkinliği',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Web Çengelleri',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate Web Çengeli',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar İşlemleri',
    'LBL_CJ_FORMS' => 'Smart Guide Sugar İşlemleri',
    'LBL_CJ_FORM' => 'Smart Guide Sugar İşlemi',
    'LBL_DRI_SUBWORKFLOW' => 'Akıllı Kılavuz Aşaması',
    'LBL_DRI_SUBWORKFLOWS' => 'Akıllı Kılavuz Aşamaları',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Akıllı Kılavuz Etkinlik Şablonları',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Akıllı Kılavuz Şablonları',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Akıllı Kılavuz Sıralaması',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Akıllı Kılavuz Gerçek Sıralaması',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Akıllı Kılavuz Puanı',
    'LBL_CJ_MOMENTUM_POINTS' => 'Akıllı Kılavuz Hızı Noktaları',
    'LBL_CJ_MOMENTUM_SCORE' => 'Akıllı Kılavuz Hızı Puanı',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Akıllı Kılavuza İzin Verişme Kriteri',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Akıllı Kılavuz İlerlemesi',
    'LBL_CJ_MOMENTUM_RATIO' => 'Akıllı Kılavuz Hızı Oranı',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Akıllı Kılavuz Noktaları',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Akıllı Kılavuz Görevi',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Akıllı Kılavuz Üst Etkinliği Türü',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Akıllı Kılavuzun Engellenme Kriteri',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'Akıllı Kılavuzun Engellenme Kriteri Aşamalar',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Akıllı Kılavuz Üst Etkinliği Kimliği',
    'LBL_START_NEXT_JOURNEY_ID' => 'Sonraki Akıllı Kılavuzu Başlatma Kimliği',
    'LBL_CJ_URL' => 'Akıllı Kılavuz Url&#39;si',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Akıllı Kılavuz Üst Etkinliğidir',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Akıllı Kılavuz Hızı Başlangıç Tarihi',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Akıllı Kılavuz Hızı Bitiş Tarihi',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'Widget Düzeni Yapılandırması',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'Widget Düzeni Yapılandırması',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'Aynı şablondan maksimum Akıllı Kılavuz sayısı',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'Aktif',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'Arşivlendi',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'Göster',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'Gizle',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'Dikey Mod',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'Yatay Mod',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Geçersiz Lisans',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}}, aşağıdaki Akıllı Kılavuz etkinliklerini {{assigned_user}} kullanıcısına atadı.</p>
    <ul>{{activities}}</ul>
    
    <p>Bu etkinlikleri şurada inceleyebilirsiniz:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Geçersiz Lisans',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'Kullanıcı sınırına ulaştı, lisansı yükseltmek için {{gracePeriodDays}} gününüz var.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - Atanan Akıllı Kılavuz Etkinlikleri',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => '{0} Sugar Automate kullanıcı sınırı aşıldı<br>
    <br>
    Kullanıcı sınırını artırmak için lütfen <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> adresinden iletişime geçin veya eklentiyi kullanan kullanıcıların sayısını azaltın.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate kullanıcı sınırına ulaşıldı',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Sugar Automate lisansınız {0} gün içerisinde sona erecek. <br>
    <br>
    Lütfen SugarCRM veya Sugar Ortağınızla iletişime geçerek lisansınızı yenileyin ve hizmetin kesilmesini önleyin.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate lisansının süresi sona ermek üzere',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'Test Web Kancası',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide İlerlemesi',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Sugar Automate "Smart Guide İlerlemesi" pasta grafiğini görüntüler.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'Web kancası yanıtını görüntüler',
    'LBL_DASHLET_SEND_LABEL' => 'İstek Gönder',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'Bana ata',
    'LBL_COMPLETE_BUTTON_TITLE' => 'Tamamla',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'Tüm Görevleri Tamamla',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'Aşamayı Sil',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'Başlat',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'Uygulanamaz',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'Aşama Ekle',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'Göster',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Smart Guide&#39;yi Düzenle',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'İptal',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'Arşivle',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'Arşivden Çıkar',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'Şablonu Yapılandır',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'Görev Ekle',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'Toplantı Planla',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'Tel. Araması Planla',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'ileri bir tarihte',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'süresi geçti',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'bugün',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'yarın',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'Bu Akıllı Kılavuzu iptal etmek istediğinizden emin misiniz?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'Tüm görevleri tamamlamak üzeresiniz. Devam etmek istediğinizden emin misiniz?',
    'LBL_CJ_BLOCK_BY' => 'Çözülmemiş, bağımlı bir göreviniz var: {{Name}}. Tüm Görevleri Tamamlamadan önce lütfen bu görevi tamamlayın.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'Birden fazlz çözülmemiş, bağımlı bir göreviniz var. Tüm Görevleri Tamamlamadan önce lütfen bu görevleri tamamlayın.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'Tüm görevleri başarıyla tamamladınız',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'Bu Akıllı Kılavuzu arşivlemek istediğinizden emin misiniz?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'Bu Akıllı Kılavuzu arşivden çıkarmak istediğinizden emin misiniz?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Akıllı Kılavuzlar (Odak Bölmeleri ve Konsolu)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'Servis/Yenilemeler Konsolundaki Aktif Akıllı Kılavuzları ve Odak Çekmecesi panolarını görüntüleyin.',
    'LBL_CJ_PROCESSING_REQUEST' => 'İşleniyor...',
    'LBL_CJ_SUCCESS' => 'Tüm görevleri başarıyla tamamladınız',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module} modülü etkin değil',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'Tüm ekran ayarları kaydedildi.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Akıllı Kılavuz Hızı',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Sugar Automate "Akıllı Kılavuz Hızı" gösterge grafiğini görüntüler.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide İlerlemesi',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Sugar Automate "Smart Guide İlerlemesi" pasta grafiğini görüntüler.',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'Üst öge bulunamadı',
    'CJ_NOT_FOUND_EXCEPTION' => '{data} vesine sahip {moduleName} bulunamadı',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'Akıllı Kılavuz, arşivlemeden önce tamamlanmalı veya iptal edilmelidir',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate, mevcut Sugar Lisansı&#39;nda etkinleştirilmedi',
    'LBL_ACTION_NOT_FOUND' => 'İşlem Bulunamadı, Sistem Yöneticinizle İletişime Geçin',
    'LBL_CJ_SELECT_FIELD' => 'Alan Seçin',
    'LBL_CJ_SELECT_OPERATOR' => 'Operatör Seçin',
    'LBL_CJ_SELECT_VALUE' => 'Değer Seçin',
    'LBL_CJ_ENTER_VALUE' => 'Değer Girin',
    'LBL_CJ_FORM_BATCH_TITLE' => 'Kayıt Kaydı',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'Aktif smart guide&#39;ler tespit edildi...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'Aktif sugar işlemleri işleniyor...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'Aktif smart guide&#39;ler güncelleniyor...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'Kayıt ve ilişkili smart guide&#39;ler başarıyla güncellendi.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'İlişkili bir smart guide güncellenemedi. Hata devam ederse lütfen yardım için Sugar yöneticinize ulaşın.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'İlişkili smart guide güncellenemedi. Hatayı gidermek için lütfen <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">günlükleri</a> inceleyin.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => '<a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} başarıyla bağlandı.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => '<a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} bağlanmasıyla ilgili bir sorun vardı. Sorun devam ederse lütfen Sugar destek ile iletişime geçin.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => '{{modulePluralLower}} başarıyla bağlandı.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => '{{modulePluralLower}} bağlanmasıyla ilgili bir sorun vardı. Sorun devam ederse lütfen Sugar destek ile iletişime geçin.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => '{{moduleSingularLower}} bağlanmasıyla ilgi bir sorun vardı. Sorun devam ederse lütfen Sugar destek ile iletişime geçin.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => '{{stage}} aşamasında <a href="#{{module}}/{{id}}">{{name}}</a> adında zaten bir {{moduleSingularLower}} mevcut.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => '<a href="#{{module}}/{{id}}">{{name}}</a> adında zaten bir {{moduleSingularLower}} seçilmiş.',
    'LBL_CJ_ARCHIVED' => 'Arşivlendi',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Smart Guide Şablonunu Seçin...',
    'LBL_ALL_SMART_GUIDES' => 'Tüm Smart Guide&#39;ler',
    'LBL_ACTIVE_SMART_GUIDES' => 'Etkin Smart Guide&#39;ler',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Arşivlenen Smart Guide&#39;ler',
    'LBL_VERTICAL_SCROLL_VIEW' => 'Dikey Yığın Görünüm',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'Yatay Kaydırmalı Görünüm',
    'LBL_DRI_WORKFLOWS_FILTER' => 'Filtre',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'Bu eylem tamamlanamaz. Bu faaliyet modülünün Durum alanı "salt okunur" olarak ayarlanmıştır ve Durum alanını güncelleyen tüm Smart Guide eylemleri engellenir.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'Bu eylem tamamlanamaz. Bu faaliyetlerin ve / veya alt faaliyetlerin modüllerinin Durum alanı "salt okunur" olarak ayarlanmıştır ve Durum alanını güncelleyen tüm Smart Guide eylemleri engellenir.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'Kılavuzdaki bazı faaliyetlerin modülleri için Durum alanı "salt okunur" olarak ayarlanmış, bu faaliyetler kılavuz iptal edildiğinde değiştirilmeden kalacak.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'Panoya kopyalandı.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'Bütün Tekrarları Sil',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'Geçersiz tekrarlanan ayarları',
    'ERROR_INTERVAL_INVALID' => 'Tekrar aralığı 1 ile 99 arasında olmalıdır',
    'LBL_RECURRENCE_ADD' => 'Yapılandır',
    'LBL_REPEAT_DAYS' => 'Ayın Günü/Günleri',
    'LBL_REPEAT_END_TYPES' => 'Tekrarla',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'Navigasyon sağlayıcısı',
    'LBL_MOBILE_PDF_EMAIL' => '{{{pdfTemplateName}}} PDF&#39;i e-posta ile gönder',
    'LBL_MOBILE_EMAIL_SENDING' => 'Gönderiliyor',
    'LBL_MOBILE_EMAIL_SENT' => 'Gönderildi',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'E-posta taslak olarak kaydedildi.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'Ek ekle',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'Yerelden Yükleyin',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar Dokümanı',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'Seçtiğiniz bir açılır liste değeri, Kayıt Görünümü Düzeninizi değiştirdi. ',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'SugarCRM Mobil Uygulama Sürüm Notları',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'SugarCRM Mobil Uygulama Kullanıcı Kılavuzu',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile, root işlemi yapılmış mobil cihazda kullanılamaz. Lütfen uygulamayı root işlemi yapılmamış bir cihazda açın.',
    'LBL_VO_BUILD_ROUTE' => 'Rota oluştur',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'Mesafe filtrem',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'Belge arka planda oluşturulacak. Dosyaya erişmek için Belge Birleştirmeleri sayfasını açın.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'Şablon alınamadı. Yardım için yöneticinizle iletişime geçin.',
    'LBL_MAP_ERROR_LOAD' => 'Harita yüklenemiyor',
    'LBL_MAP_DISTANCE' => 'Mesafe',
    'LBL_SELECT_UNIT_TYPE' => 'Birim Türü',
    'LBL_MAPS_UNIT_MILES' => 'Mil',
    'LBL_MAPS_UNIT_KILOMETERS' => 'Kilometre',
    'LBL_RADIUS' => 'Yarıçap',
    'LBL_ZIP_CODE' => 'Posta Kodu',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'Adres seçin',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'Adresten coğrafi kod oluşturulamıyor:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'Kayıt coğrafi olarak kodlanmamış.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'Kayıt, hiçbir adres verisi içermiyor. Bu kaydı harita üzerinde manuel olarak bulmak istiyor musunuz?',
    'LBL_ERR_SHOW_ON_MAP' => 'Seçili kayıtlar için harita açılamadı.',
    'LBL_ERR_MISSING_ON_MAP' => 'Bazı kayıtlarda adres verileri eksik ve gösterilmiyor',
    'LBL_MAPS_ROUTE' => 'Rota',
    'LBL_MAPS_PROVIDER' => 'Sugar Haritalar',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'Mevcut konum belirlenemedi.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'Eşleme için en fazla {{{num}}} kayıt destekleniyor.',
    'LBL_ALL_MODULES' => 'Tüm Modüller',
    'LBL_DRIVE_SHARE_LINK' => 'Bir bağlantı paylaş',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'Dosyalar yüklenemedi.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'Ad boş bırakılamaz',
    'LBL_DRIVE_FOLDER_CREATED' => 'Klasör oluşturuldu.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'Klasör oluşturulamadı.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'Dosya yüklenemedi.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'Lütfen önce kök klasör oluşturun',
    'LBL_EDIT_ALL_RECURRENCES' => 'Bütün Çift Kayıtları Değiştir',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'Dosya Dropbox&#39;ta açılamıyor',
    'LBL_FILE_NOT_AVAILABLE' => 'Dosya açılamıyor',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'Yönlendirmeler',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'Girilen ara noktalar için rota bulunamadı',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'Yakın',
    'LBL_TAGS' => 'Etiketler',

    'LBL_CALLER_ID_SETTINGS' => 'Arayan Kimliği Ayarları',
    'LBL_CALLER_ID_ENABLED' => 'Arayan Kimliği Etkin',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'Gelen aramalarda, telefon numarasıyla eşleşen kişinin veya müşteri adayının adı görüntülenir.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'Mobil uygulamanın arayan kimliklerini görüntülemesine izin vermek için cihazınızda şu adımları izleyin:<br><br>1. iOS Ayarlarını Açın > Telefon > Arama engelleme ve tanımlama.<br>2. Etkinleştir "{{{brandName}}}".',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'Mobil uygulamanın arayan kimliklerini görüntülemesine izin vermek için cihazınızda şu adımları izleyin:<br>1. Uygulama ayarlarını açın.<br>2. İzinlere gidin.<br>3. Telefon iznini etkinleştirin.<br><br> Bu uygulamayı varsayılan Arayan Kimliği işleyicisi olarak ayarlamak için cihaz ayarlarınıza gidin.<br>1. Uygulamalar kısmına gidin.<br>2. Varsayılan uygulamaları seçin.<br>3. Arayan Kimliği ve spam uygulamasını seçin.<br>4. Varsayılan seçenek olarak bu uygulamayı seçin.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Sugar örneğinizdeki kayıtlardan (ör. Kişiler, Potansiyel Müşteriler) iletişim bilgilerindeki değişiklikleri kontrol edin.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'Ayarlara gidin',
    'LBL_CALLER_ID_SYNC' => 'Kayıt Verilerini Senkronize Et',
    'LBL_CALLER_ID_NOT_ENABLED' => 'Senkronizasyondan önce sistem ayarlarında Arayan Kimliği etkinleştirilmelidir.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'Etkinleştir',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'Ayarların ilerleyen bölümlerinde',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'Bu uygulama Arayan Kimliği özelliğini destekliyor.<br> Bu özelliğin düzgün çalışması için etkinleştir düğmesine bastıktan sonra iki izin vermeniz istenecek.<br> Arayan Kimliği özelliğinin doğru çalıştığından emin olmak için aramaları yönetme izni vermeniz ve bu uygulamayı varsayılan Arayan Kimliği işleyicisi olarak seçmeniz gerekir.<br> Aramaları yönetme izni vermezseniz uygulamadan yapılan aramaları da kaydedemezsiniz.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'SugarCRM&#39;nin arayan kimliklerini görüntülemesine izin vermek için cihazınızda şu adımları izleyin:<br><br>1. iOS Ayarlarını Açın > Telefon > Arama engelleme ve tanımlama.<br>2. Uygulamayı etkinleştir.',
    'LBL_MOBILE_LAST_SYNC' => 'Son Senkronizasyon',
    'LBL_CALLER_ID_SYNCING' => 'Sunucu ile senkronize ediliyor.',
    'LBL_NEVER' => 'Hiç',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} boş bırakılamaz.',
    'LBL_ADD_RELATED_RECORD' => 'İlişkili {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => 'Arayan kimliğini kullanmak için gerekli izinlere sahip değilsiniz. Lütfen yöneticinizle iletişime geçin.',
    'LBL_CALLER_ID_FETCHING' => 'Senkronize ediliyor…',
    'LBL_CALLER_ID_FETCH_ALL' => 'Tüm kayıtları yeniden senkronize et',
    'LBL_CALLER_ID_FETCH_NEW' => 'Kayıt güncellemelerini kontrol edin',

    'LBL_SORT_BY' => 'Sıralama kriteri',
    'LBL_PRIMARY_SORT' => 'Birincil Sıralama',
    'LBL_SECONDARY_SORT' => 'İkincil Sıralama',
    'LBL_OF' => '/',
    'LBL_TABLE_FREEZE_FIRST' => 'İlk Sütunu Dondur',
    'LBL_TABLE_SETTINGS_TITLE' => 'Sütun Görünümü Seçenekleri',
    'LBL_TABLE_SETTINGS_NO_COL' => 'En az bir sütun seçilmelidir.',
    'LBL_TABLE_TOGGLER_INFO' => 'Sütunları gösterin veya gizleyin ve istediğiniz sıraya sürükleyin.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'Çalışma Zamanı Filtreleri',
    'LBL_FILTER_CONDITION' => 'Koşulu Seçin',
    'LBL_FILTER_VALUES' => 'Değerler',
    'LBL_TABLE_EXPAND' => 'Tümünü Genişlet',
    'LBL_TABLE_COLLAPSE' => 'Tümünü Daralt',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'Sunucu hatası. İlgili çalışma zamanı filtreleri yüklenemedi.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Pub/Sub Modülü Olay Anlık Abonelikleri',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Pub/Sub Modülü Olay Anlık Abonelikleri',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'Panel - Üst',
    'panel_bottom' => 'Panel - Alt',
    'tab_first' => 'Sekme - İlk',
    'tab_last' => 'Sekme - Son',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'Son 7 gün',
    '30' => 'Son 30 gün',
    '90' => 'Son Çeyrek',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'Bugün',
    'future' => 'Gelecek',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'Evet',
    'group' => 'Hayır',
];

$app_list_strings['history_filter_options'] = [
    7 => 'Son 7 gün',
    30 => 'Son 30 gün',
    90 => 'Son Çeyrek',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'Evet',
    'group' => 'Hayır',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'Evet',
    'group' => 'Hayır',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'Evet',
    '0' => 'Hayır',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'Bu Çeyrek',
    'next' => 'Gelecek Çeyrek',
    'year' => 'Bu Yıl',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'Kayıtlarım',
    'group' => 'Grup Kayıtları',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'Pipeline&#39;ım',
    'group' => 'Takımımın Payplaynı',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'Tahminlerim',
    'group' => 'Takımımın Satış Tahminleri',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'Fırsatlar',
    'RevenueLineItems' => 'Fırsatlar ve Gelir Kalemleri',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'En Son Kapanma Tarihi',
    'earliest' => 'En erken Kapanma Tarihi',
];

$app_list_strings['moduleList']['Library'] = 'Kitaplık';
$app_list_strings['moduleListSingular']['Library'] = 'Kitaplık';
$app_list_strings['library_type'] = ['Books' => 'Kitap', 'Music' => 'Müzik', 'DVD' => 'DVD', 'Magazines' => 'Dergiler'];
$app_list_strings['moduleList']['EmailAddresses'] = 'E-Posta Adresi';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'E-Posta Adresi';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'Taslak',
    'in-review' => 'İncelemede',
    'approved' => 'Onaylandı',
    'published' => 'Yayınlandı',
    'expired' => 'Süresi Geçmiş',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--Yönetici Aksiyonları--',
        'Create New Tag' => 'Yeni Etiket Oluştur',
        'Delete Tag' => 'Etiket Sil',
        'Rename Tag' => 'Etiket İsmini Değiştir',
        'Move Selected Articles' => 'Seçili Makaleleri Taşı',
        'Apply Tags On Articles' => 'Makalelere Etiket Uygula',
        'Delete Selected Articles' => 'Seçili Makaleleri Sil',
    ];

$app_list_strings['moduleList']['Words'] = 'Kelimeler';
$app_list_strings['moduleListSingular']['Words'] = 'Kelimeler';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Makale Oluştur';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DABİ',
    'ADEN' => 'ADEN',
    'AFGHANISTAN' => 'AFGANİSTAN',
    'ALBANIA' => 'ARNAVUTLUK',
    'ALGERIA' => 'CEZAYİR',
    'AMERICAN SAMOA' => 'AMERİKAN SAMOA',
    'ANDORRA' => 'ANDORA',
    'ANGOLA' => 'ANGOLA',
    'ANTARCTICA' => 'ANTARTİKA',
    'ANTIGUA' => 'ANTİGUA',
    'ARGENTINA' => 'ARJANTİN',
    'ARMENIA' => 'ERMENİSTAN',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => 'AVUSTRALYA',
    'AUSTRIA' => 'AVUSTURYA',
    'AZERBAIJAN' => 'AZERBAYCAN',
    'BAHAMAS' => 'BAHAMALAR',
    'BAHRAIN' => 'BAHREYN',
    'BANGLADESH' => 'BANGLADEŞ',
    'BARBADOS' => 'BARBADOS',
    'BELARUS' => 'BEYAZ RUSYA',
    'BELGIUM' => 'BELÇİKA',
    'BELIZE' => 'BELİZE',
    'BENIN' => 'BENİN',
    'BERMUDA' => 'BERMUDA',
    'BHUTAN' => 'BUTAN',
    'BOLIVIA' => 'BOLIVYA',
    'BOSNIA' => 'BOSNA',
    'BOTSWANA' => 'BOTSVANA',
    'BOUVET ISLAND' => 'BOUVET ADASI',
    'BRAZIL' => 'BREZİLYA',
    'BRITISH ANTARCTICA TERRITORY' => 'İNGİLİZ ANTARKTİK BÖLGESİ',
    'BRITISH INDIAN OCEAN TERRITORY' => 'İNGİLİZ HİNT OKYANUSU BÖLGESİ',
    'BRITISH VIRGIN ISLANDS' => 'İNGİLİZ VİRGİN ADALARI',
    'BRITISH WEST INDIES' => 'İNGİLİZ BATI HİNT ADALARI',
    'BRUNEI' => 'BRUNEİ',
    'BULGARIA' => 'BULGARİSTAN',
    'BURKINA FASO' => 'BURKİNA FASO',
    'BURUNDI' => 'BURUNDİ',
    'CAMBODIA' => 'KAMBOÇYA',
    'CAMEROON' => 'KAMERUN',
    'CANADA' => 'KANADA',
    'CANAL ZONE' => 'KANAL BÖLGESİ',
    'CANARY ISLAND' => 'KANARYA ADALARI',
    'CAPE VERDI ISLANDS' => 'CAPE VERDE ADALARI',
    'CAYMAN ISLANDS' => 'CAYMAN ADALARI',
    'CEVLON' => 'SEYLAN',
    'CHAD' => 'ÇAD',
    'CHANNEL ISLAND UK' => 'İNGİLİZ KANAL ADASI',
    'CHILE' => 'ŞİLİ',
    'CHINA' => 'ÇİN',
    'CHRISTMAS ISLAND' => 'CHRISTMAS ADASI',
    'COCOS (KEELING) ISLAND' => 'COCOS ADASI',
    'COLOMBIA' => 'KOLOMBİYA',
    'COMORO ISLANDS' => 'KOMORO ADALARI',
    'CONGO' => 'KONGO',
    'CONGO KINSHASA' => 'KONGO KINŞASA',
    'COOK ISLANDS' => 'COOK ADALARI',
    'COSTA RICA' => 'KOSTARİKA',
    'CROATIA' => 'HIRVATİSTAN',
    'CUBA' => 'KÜBA',
    'CURACAO' => 'CURAÇAO',
    'CYPRUS' => 'KIBRIS',
    'CZECH REPUBLIC' => 'ÇEK CUMHURİYETİ',
    'DAHOMEY' => 'DAHOMEY',
    'DENMARK' => 'DANİMARKA',
    'DJIBOUTI' => 'CİBUTİ',
    'DOMINICA' => 'DOMİNİK',
    'DOMINICAN REPUBLIC' => 'DOMİNİK CUMHURİYETİ',
    'DUBAI' => 'DUBAİ',
    'ECUADOR' => 'EKVATOR',
    'EGYPT' => 'MISIR',
    'EL SALVADOR' => 'EL SALVADOR',
    'EQUATORIAL GUINEA' => 'EKVATOR GİNESİ',
    'ESTONIA' => 'ESTONYA',
    'ETHIOPIA' => 'ETİYOPYA',
    'FAEROE ISLANDS' => 'FAROE ADALARI',
    'FALKLAND ISLANDS' => 'FALKLAND ADALARI',
    'FIJI' => 'FİJİ SAHİLLERİ',
    'FINLAND' => 'FİNLANDİYA',
    'FRANCE' => 'FRANSA',
    'FRENCH GUIANA' => 'FRANSIZ GİNESİ',
    'FRENCH POLYNESIA' => 'FRANSIZ POLİNEZYASI',
    'GABON' => 'GABON',
    'GAMBIA' => 'GAMBIYA',
    'GEORGIA' => 'GÜRCİSTAN',
    'GERMANY' => 'ALMANYA',
    'GHANA' => 'GANA',
    'GIBRALTAR' => 'CEBELİTARIK',
    'GREECE' => 'YUNANİSTAN',
    'GREENLAND' => 'GRÖNLAND',
    'GUADELOUPE' => 'GUADELOUPE',
    'GUAM' => 'GUAM',
    'GUATEMALA' => 'GUATEMALA',
    'GUINEA' => 'YENİ GİNE',
    'GUYANA' => 'GUYANA',
    'HAITI' => 'HAİTİ',
    'HONDURAS' => 'HONDURAS',
    'HONG KONG' => 'HONG KONG',
    'HUNGARY' => 'MACARİSTAN',
    'ICELAND' => 'İZLANDA',
    'IFNI' => 'IFNİ',
    'INDIA' => 'HİNDİSTAN',
    'INDONESIA' => 'ENDONEZYA',
    'IRAN' => 'İRAN',
    'IRAQ' => 'IRAK',
    'IRELAND' => 'İRLANDA',
    'ISRAEL' => 'İSRAİL',
    'ITALY' => 'İTALYA',
    'IVORY COAST' => 'FİLDİŞİ SAHİLLERİ',
    'JAMAICA' => 'JAMAİKA',
    'JAPAN' => 'JAPONYA',
    'JORDAN' => 'ÜRDÜN',
    'KAZAKHSTAN' => 'KAZAKİSTAN',
    'KENYA' => 'KENYA',
    'KOREA' => 'KORE',
    'KOREA, SOUTH' => 'GÜNEY KORE',
    'KUWAIT' => 'KUVEYT',
    'KYRGYZSTAN' => 'KIRGIZİSTAN',
    'LAOS' => 'LAGOS',
    'LATVIA' => 'LETONYA',
    'LEBANON' => 'LÜBNAN',
    'LEEWARD ISLANDS' => 'RÜZGARALTI ADALARI',
    'LESOTHO' => 'LESOTHO',
    'LIBYA' => 'LİBYA',
    'LIECHTENSTEIN' => 'LIHTENŞTAYN',
    'LITHUANIA' => 'LİTVANYA',
    'LUXEMBOURG' => 'LÜKSEMBURG',
    'MACAO' => 'MAKAO',
    'MACEDONIA' => 'MAKEDONYA',
    'MADAGASCAR' => 'MADAGASKAR',
    'MALAWI' => 'MALAVI',
    'MALAYSIA' => 'MALEZYA',
    'MALDIVES' => 'MALDİVLER',
    'MALI' => 'MALİ',
    'MALTA' => 'MALTA',
    'MARTINIQUE' => 'MARTİNİK',
    'MAURITANIA' => 'MORİTANYA',
    'MAURITIUS' => 'MAURİTİUS',
    'MELANESIA' => 'MELANEZYA',
    'MEXICO' => 'MEKSİKA',
    'MOLDOVIA' => 'MOLDOVYA',
    'MONACO' => 'MONAKO',
    'MONGOLIA' => 'MOĞOLİSTAN',
    'MOROCCO' => 'FAS',
    'MOZAMBIQUE' => 'MOZAMBİK',
    'MYANAMAR' => 'MYANMAR',
    'NAMIBIA' => 'NAMİBYA',
    'NEPAL' => 'NEPAL',
    'NETHERLANDS' => 'HOLLANDA',
    'NETHERLANDS ANTILLES' => 'HOLLANDA ANTİLLERİ',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'HOLLANDA ANTİLLERİ TARAFSIZ BÖLGE',
    'NEW CALADONIA' => 'YENİ CALADONIA',
    'NEW HEBRIDES' => 'YENİ HEBRİDES',
    'NEW ZEALAND' => 'YENİ ZELANDA',
    'NICARAGUA' => 'NIKARAGUA',
    'NIGER' => 'NİJER',
    'NIGERIA' => 'NİJERYA',
    'NORFOLK ISLAND' => 'NORFOLK ADASI',
    'NORWAY' => 'NORVEÇ',
    'OMAN' => 'UMMAN',
    'OTHER' => 'DİĞER',
    'PACIFIC ISLAND' => 'PASİFİK ADASI',
    'PAKISTAN' => 'PAKİSTAN',
    'PANAMA' => 'PANAMA',
    'PAPUA NEW GUINEA' => 'PAPUA YENİ GİNE',
    'PARAGUAY' => 'PARAGUAY',
    'PERU' => 'PERU',
    'PHILIPPINES' => 'FİLİPİNLER',
    'POLAND' => 'POLONYA',
    'PORTUGAL' => 'PORTEKİZ',
    'PORTUGUESE TIMOR' => 'PORTEKİZ TİMOR',
    'PUERTO RICO' => 'PORTO RİKO',
    'QATAR' => 'KATAR',
    'REPUBLIC OF BELARUS' => 'BEYAZ RUSYA CUMHURİYETİ',
    'REPUBLIC OF SOUTH AFRICA' => 'GÜNEY AFRİKA CUMHURİYETİ',
    'REUNION' => 'REUNİON',
    'ROMANIA' => 'ROMANYA',
    'RUSSIA' => 'RUSYA',
    'RWANDA' => 'RUANDA',
    'RYUKYU ISLANDS' => 'RYUKYU ADALARI',
    'SABAH' => 'SABAH',
    'SAN MARINO' => 'SAN MARİNO',
    'SAUDI ARABIA' => 'SUUDİ ARABİSTAN',
    'SENEGAL' => 'SENEGAL',
    'SERBIA' => 'SIRBİSTAN',
    'SEYCHELLES' => 'ŞEYSEL ADALARI',
    'SIERRA LEONE' => 'SIERRA LEONE',
    'SINGAPORE' => 'SİNGAPUR',
    'SLOVAKIA' => 'SLOVAKYA',
    'SLOVENIA' => 'SLOVENYA',
    'SOMALILIAND' => 'SOMALI',
    'SOUTH AFRICA' => 'GÜNEY AFRİKA',
    'SOUTH YEMEN' => 'GÜNEY YEMEN',
    'SPAIN' => 'İSPANYA',
    'SPANISH SAHARA' => 'İSPANYOL SAHRASI',
    'SRI LANKA' => 'SRİ LANKA',
    'ST. KITTS AND NEVIS' => 'SAINT KITTS VE NEVIS',
    'ST. LUCIA' => 'SANTA LUÇİYA',
    'SUDAN' => 'SUDAN',
    'SURINAM' => 'SURİNAM',
    'SW AFRICA' => 'GÜNEY BATI AFRİKA',
    'SWAZILAND' => 'SVAZİLAND',
    'SWEDEN' => 'İŞVEÇ',
    'SWITZERLAND' => 'İŞVİÇRE',
    'SYRIA' => 'SURİYE',
    'TAIWAN' => 'TAYVAN',
    'TAJIKISTAN' => 'TACİKİSTAN',
    'TANZANIA' => 'TANZANYA',
    'THAILAND' => 'TAYLAND',
    'TONGA' => 'TONGA',
    'TRINIDAD' => 'TRINIDAD',
    'TUNISIA' => 'TUNUS',
    'TURKEY' => 'TÜRKİYE',
    'UGANDA' => 'UGANDA',
    'UKRAINE' => 'UKRAYNA',
    'UNITED ARAB EMIRATES' => 'BİRLEŞİK ARAP EMİRLİKLERİ',
    'UNITED KINGDOM' => 'BİRLEŞİK KRALLIK',
    'UPPER VOLTA' => 'ÜST VOLTA',
    'URUGUAY' => 'URUGUAY',
    'US PACIFIC ISLAND' => 'ABD PASİFİK ADALARI',
    'US VIRGIN ISLANDS' => 'ABD VİRJİN ADALARI',
    'USA' => 'ABD',
    'UZBEKISTAN' => 'ÖZBEKİSTAN',
    'VANUATU' => 'VANUATU',
    'VATICAN CITY' => 'VATİKAN ŞEHRİ',
    'VENEZUELA' => 'VENEZUELA',
    'VIETNAM' => 'VİETNAM',
    'WAKE ISLAND' => 'WAKE ADASI',
    'WEST INDIES' => 'BATI HİNT ADALARI',
    'WESTERN SAHARA' => 'BATI SAHRA',
    'YEMEN' => 'YEMEN',
    'ZAIRE' => 'ZAİRE',
    'ZAMBIA' => 'ZAMBİYA',
    'ZIMBABWE' => 'ZİMBABVE',
];

$app_list_strings['state_dom'] = [
    'AL' => 'Alabama',
    'AK' => 'Alaska',
    'AZ' => 'Arizona',
    'AR' => 'Arkansas',
    'CA' => 'California',
    'CO' => 'Colorado',
    'CT' => 'Connecticut',
    'DE' => 'Delaware',
    'DC' => 'District Of Columbia',
    'FL' => 'Florida',
    'GA' => 'Georgia',
    'HI' => 'Hawaii',
    'ID' => 'Idaho',
    'IL' => 'Illinois',
    'IN' => 'Indiana',
    'IA' => 'Iowa',
    'KS' => 'Kansas',
    'KY' => 'Kentucky',
    'LA' => 'Louisiana',
    'ME' => 'Maine',
    'MD' => 'Maryland',
    'MA' => 'Massachusetts',
    'MI' => 'Michigan',
    'MN' => 'Minnesota',
    'MS' => 'Mississippi',
    'MO' => 'Missouri',
    'MT' => 'Montana',
    'NE' => 'Nebraska',
    'NV' => 'Nevada',
    'NH' => 'New Hampshire',
    'NJ' => 'New Jersey',
    'NM' => 'New Mexico',
    'NY' => 'New York',
    'NC' => 'North Carolina',
    'ND' => 'North Dakota',
    'OH' => 'Ohio',
    'OK' => 'Oklahoma',
    'OR' => 'Oregon',
    'PA' => 'Pennsylvania',
    'RI' => 'Rhode Island',
    'SC' => 'South Carolina',
    'SD' => 'South Dakota',
    'TN' => 'Tennessee',
    'TX' => 'Texas',
    'UT' => 'Utah',
    'VT' => 'Vermont',
    'VA' => 'Virginia',
    'WA' => 'Washington',
    'WV' => 'West Virginia',
    'WI' => 'Wisconsin',
    'WY' => 'Wyoming',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (Tayvan ve Hong Kong)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS Slav Alfabesi)',
    'CP1252' => 'CP1252 (MS Batı Avrupa & ABD)',
    'EUC-CN' => 'EUC-CN (Basitleştirilmiş Çince GB2312)',
    'EUC-JP' => 'EUC-JP (Unix Japonca)',
    'EUC-KR' => 'EUC-KR (Korece)',
    'EUC-TW' => 'EUC-TW (Tayvan Dili)',
    'ISO-2022-JP' => 'ISO-2022-JP (Japonca)',
    'ISO-2022-KR' => 'ISO-2022-KR (Korece)',
    'ISO-8859-1' => 'ISO-8859-1 (Batı Avrupa ve ABD)',
    'ISO-8859-2' => 'ISO-8859-2 (Merkezi ve Doğu Avrupa)',
    'ISO-8859-3' => 'ISO-8859-3 (Latin 3)',
    'ISO-8859-4' => 'ISO-8859-4 (Latin 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Slav Alfabesi)',
    'ISO-8859-6' => 'ISO-8859-6 (Arapça)',
    'ISO-8859-7' => 'ISO-8859-7 (Yunanca)',
    'ISO-8859-8' => 'ISO-8859-8 (Hibru)',
    'ISO-8859-9' => 'ISO-8859-9 (Latin 5)',
    'ISO-8859-10' => 'ISO-8859-10 (Latin 6)',
    'ISO-8859-13' => 'ISO-8859-13 (Latin 7)',
    'ISO-8859-14' => 'ISO-8859-14 (Latin 8)',
    'ISO-8859-15' => 'ISO-8859-15 (Latin 9)',
    'KOI8-R' => 'KOI8-R (Slav Alfabesi Rusça)',
    'KOI8-U' => 'KOI8-U (Slav Alfabesi Ukrayna Dili)',
    'SJIS' => 'SJIS (MS Japonca)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Afrika/Cezayir',
    'Africa/Luanda' => 'Afrika/Luanda',
    'Africa/Porto-Novo' => 'Afrika/Porto-Novo',
    'Africa/Gaborone' => 'Afrika/Gaborone',
    'Africa/Ouagadougou' => 'Afrika/Ouagadougou',
    'Africa/Bujumbura' => 'Afrika/Bujumbura',
    'Africa/Douala' => 'Afrika/Douala',
    'Atlantic/Cape_Verde' => 'Atlantik/Cape_Verde',
    'Africa/Bangui' => 'Afrika/Bangui',
    'Africa/Ndjamena' => 'Afrika/Ndjamena',
    'Indian/Comoro' => 'Hint/Comoro',
    'Africa/Kinshasa' => 'Afrika/Kinshasa',
    'Africa/Lubumbashi' => 'Afrika/Lubumbashi',
    'Africa/Brazzaville' => 'Afrika/Brazzaville',
    'Africa/Abidjan' => 'Afrika/Abidjan',
    'Africa/Djibouti' => 'Afrika/Djibouti',
    'Africa/Cairo' => 'Afrika/Cairo',
    'Africa/Malabo' => 'Afrika/Malabo',
    'Africa/Asmera' => 'Afrika/Asmera',
    'Africa/Addis_Ababa' => 'Afrika/Addis_Ababa',
    'Africa/Libreville' => 'Afrika/Libreville',
    'Africa/Banjul' => 'Afrika/Banjul',
    'Africa/Accra' => 'Afrika/Accra',
    'Africa/Conakry' => 'Afrika/Conakry',
    'Africa/Bissau' => 'Afrika/Bissau',
    'Africa/Nairobi' => 'Afrika/Nairobi',
    'Africa/Maseru' => 'Afrika/Maseru',
    'Africa/Monrovia' => 'Afrika/Monrovia',
    'Africa/Tripoli' => 'Afrika/Tripoli',
    'Indian/Antananarivo' => 'Hint/Antananarivo',
    'Africa/Blantyre' => 'Afrika/Blantyre',
    'Africa/Bamako' => 'Afrika/Bamako',
    'Africa/Nouakchott' => 'Afrika/Nouakchott',
    'Indian/Mauritius' => 'Hint/Mauritius',
    'Indian/Mayotte' => 'Hint/Mayotte',
    'Africa/Casablanca' => 'Afrika/Casablanca',
    'Africa/El_Aaiun' => 'Afrika/El_Aaiun',
    'Africa/Maputo' => 'Afrika/Maputo',
    'Africa/Windhoek' => 'Afrika/Windhoek',
    'Africa/Niamey' => 'Afrika/Niamey',
    'Africa/Lagos' => 'Afrika/Lagos',
    'Indian/Reunion' => 'Hint/Reunion',
    'Africa/Kigali' => 'Afrika/Kigali',
    'Atlantic/St_Helena' => 'Atlantik/St_Helena',
    'Africa/Sao_Tome' => 'Afrika/Sao_Tome',
    'Africa/Dakar' => 'Afrika/Dakar',
    'Indian/Mahe' => 'Hint/Mahe',
    'Africa/Freetown' => 'Afrika/Freetown',
    'Africa/Mogadishu' => 'Afrika/Mogadishu',
    'Africa/Johannesburg' => 'Afrika/Johannesburg',
    'Africa/Khartoum' => 'Afrika/Khartoum',
    'Africa/Mbabane' => 'Afrika/Mbabane',
    'Africa/Dar_es_Salaam' => 'Afrika/Dar_es_Salaam',
    'Africa/Lome' => 'Afrika/Lome',
    'Africa/Tunis' => 'Afrika/Tunis',
    'Africa/Kampala' => 'Afrika/Kampala',
    'Africa/Lusaka' => 'Afrika/Lusaka',
    'Africa/Harare' => 'Afrika/Harare',
    'Antarctica/Casey' => 'Antartika/Casey',
    'Antarctica/Davis' => 'Antartika/Davis',
    'Antarctica/Mawson' => 'Antartika/Mawson',
    'Indian/Kerguelen' => 'Hint/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antartika/DumontDUrville',
    'Antarctica/Syowa' => 'Antartika/Syowa',
    'Antarctica/Vostok' => 'Antartika/Vostok',
    'Antarctica/Rothera' => 'Antartika/Rothera',
    'Antarctica/Palmer' => 'Antartika/Palmer',
    'Antarctica/McMurdo' => 'Antartika/McMurdo',
    'Asia/Kabul' => 'Asya/Kabil',
    'Asia/Yerevan' => 'Asya/Yerevan',
    'Asia/Baku' => 'Asya/Baku',
    'Asia/Bahrain' => 'Asya/Bahrain',
    'Asia/Dhaka' => 'Asya/Dhaka',
    'Asia/Thimphu' => 'Asya/Thimphu',
    'Indian/Chagos' => 'Hint/Chagos',
    'Asia/Brunei' => 'Asya/Brunei',
    'Asia/Rangoon' => 'Asya/Rangoon',
    'Asia/Phnom_Penh' => 'Asya/Phnom_Penh',
    'Asia/Beijing' => 'Asya/Beijing',
    'Asia/Harbin' => 'Asya/Harbin',
    'Asia/Shanghai' => 'Asya/Shanghai',
    'Asia/Chongqing' => 'Asya/Chongqing',
    'Asia/Urumqi' => 'Asya/Urumqi',
    'Asia/Kashgar' => 'Asya/Kashgar',
    'Asia/Hong_Kong' => 'Asya/Hong_Kong',
    'Asia/Taipei' => 'Asya/Taipei',
    'Asia/Macau' => 'Asya/Macau',
    'Asia/Nicosia' => 'Asya/Nicosia',
    'Asia/Tbilisi' => 'Asya/Tbilisi',
    'Asia/Dili' => 'Asya/Dili',
    'Asia/Calcutta' => 'Asya/Calcutta',
    'Asia/Jakarta' => 'Asya/Jakarta',
    'Asia/Pontianak' => 'Asya/Pontianak',
    'Asia/Makassar' => 'Asya/Makassar',
    'Asia/Jayapura' => 'Asya/Jayapura',
    'Asia/Tehran' => 'Asya/Tehran',
    'Asia/Baghdad' => 'Asya/Baghdad',
    'Asia/Jerusalem' => 'Asya/Jerusalem',
    'Asia/Tokyo' => 'Asya/Tokyo',
    'Asia/Amman' => 'Asya/Amman',
    'Asia/Almaty' => 'Asya/Almaty',
    'Asia/Qyzylorda' => 'Asya/Qyzylorda',
    'Asia/Aqtobe' => 'Asya/Aqtobe',
    'Asia/Aqtau' => 'Asya/Aqtau',
    'Asia/Oral' => 'Asya/Oral',
    'Asia/Bishkek' => 'Asya/Bishkek',
    'Asia/Seoul' => 'Asya/Seul',
    'Asia/Pyongyang' => 'Asya/Pyongyang',
    'Asia/Kuwait' => 'Asya/Kuwait',
    'Asia/Vientiane' => 'Asya/Vientiane',
    'Asia/Beirut' => 'Asya/Beyrut',
    'Asia/Kuala_Lumpur' => 'Asya/Kuala_Lumpur',
    'Asia/Kuching' => 'Asya/Kuching',
    'Indian/Maldives' => 'Hint/Maldives',
    'Asia/Hovd' => 'Asya/Hovd',
    'Asia/Ulaanbaatar' => 'Asya/Ulaanbaatar',
    'Asia/Choibalsan' => 'Asya/Choibalsan',
    'Asia/Katmandu' => 'Asya/Katmandu',
    'Asia/Muscat' => 'Asya/Muscat',
    'Asia/Karachi' => 'Asya/Karachi',
    'Asia/Gaza' => 'Asya/Gaza',
    'Asia/Manila' => 'Asya/Manila',
    'Asia/Qatar' => 'Asya/Qatar',
    'Asia/Riyadh' => 'Asya/Riyadh',
    'Asia/Singapore' => 'Asya/Singapore',
    'Asia/Colombo' => 'Asya/Colombo',
    'Asia/Damascus' => 'Asya/Damascus',
    'Asia/Dushanbe' => 'Asya/Dushanbe',
    'Asia/Bangkok' => 'Asya/Bangkok',
    'Asia/Ashgabat' => 'Asya/Ashgabat',
    'Asia/Dubai' => 'Asya/Dubai',
    'Asia/Samarkand' => 'Asya/Semerkand',
    'Asia/Tashkent' => 'Asya/Taşkent',
    'Asia/Saigon' => 'Asya/Saigon',
    'Asia/Aden' => 'Asya/Aden',
    'Australia/Darwin' => 'Avustralya/Darwin',
    'Australia/Perth' => 'Avustralya/Perth',
    'Australia/Brisbane' => 'Avustralya/Brisbane',
    'Australia/Lindeman' => 'Avustralya/Lindeman',
    'Australia/Adelaide' => 'Avustralya/Adelaide',
    'Australia/Hobart' => 'Avustralya/Hobart',
    'Australia/Currie' => 'Avustralya/Currie',
    'Australia/Melbourne' => 'Avustralya/Melbourne',
    'Australia/Sydney' => 'Avustralya/Sidney',
    'Australia/Broken_Hill' => 'Avustralya/Broken_Hill',
    'Indian/Christmas' => 'Hint/Christmas',
    'Pacific/Rarotonga' => 'Pasifik/Rarotonga',
    'Indian/Cocos' => 'Hindistan/Cocos',
    'Pacific/Fiji' => 'Pasifik/Fiji',
    'Pacific/Gambier' => 'Pasifik/Gambier',
    'Pacific/Marquesas' => 'Pasifik/Marquesas',
    'Pacific/Tahiti' => 'Pasifik/Tahiti',
    'Pacific/Guam' => 'Pasifik/Guam',
    'Pacific/Tarawa' => 'Pasifik/Tarawa',
    'Pacific/Enderbury' => 'Pasifik/Enderbury',
    'Pacific/Kiritimati' => 'Pasifik/Kiritimati',
    'Pacific/Saipan' => 'Pasifik/Saipan',
    'Pacific/Majuro' => 'Pasifik/Majuro',
    'Pacific/Kwajalein' => 'Pasifik/Kwajalein',
    'Pacific/Truk' => 'Pasifik/Truk',
    'Pacific/Ponape' => 'Pasifik/Ponape',
    'Pacific/Kosrae' => 'Pasifik/Kosrae',
    'Pacific/Nauru' => 'Pasifik/Nauru',
    'Pacific/Noumea' => 'Pasifik/Noumea',
    'Pacific/Auckland' => 'Pasifik/Auckland',
    'Pacific/Chatham' => 'Pasifik/Chatham',
    'Pacific/Niue' => 'Pasifik/Niue',
    'Pacific/Norfolk' => 'Pasifik/Norfolk',
    'Pacific/Palau' => 'Pasifik/Palau',
    'Pacific/Port_Moresby' => 'Pasifik/Port_Moresby',
    'Pacific/Pitcairn' => 'Pasifik/Pitcairn',
    'Pacific/Pago_Pago' => 'Pasifik/Pago_Pago',
    'Pacific/Apia' => 'Pasifik/Apia',
    'Pacific/Guadalcanal' => 'Pasifik/Guadalcanal',
    'Pacific/Fakaofo' => 'Pasifik/Fakaofo',
    'Pacific/Tongatapu' => 'Pasifik/Tongatapu',
    'Pacific/Funafuti' => 'Pasifik/Funafuti',
    'Pacific/Johnston' => 'Pasifik/Johnston',
    'Pacific/Midway' => 'Pasifik/Midway',
    'Pacific/Wake' => 'Pasifik/Wake',
    'Pacific/Efate' => 'Pasifik/Efate',
    'Pacific/Wallis' => 'Pasifik/Wallis',
    'Europe/London' => 'Avrupa/Londra',
    'Europe/Dublin' => 'Avrupa/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'Avrupa/Tiran',
    'Europe/Andorra' => 'Avrupa/Andorra',
    'Europe/Vienna' => 'Avrupa/Viyana',
    'Europe/Minsk' => 'Avrupa/Minsk',
    'Europe/Brussels' => 'Avrupa/Brüksel',
    'Europe/Sofia' => 'Avrupa/Sofya',
    'Europe/Prague' => 'Avrupa/Prag',
    'Europe/Copenhagen' => 'Avrupa/Kopenhag',
    'Atlantic/Faeroe' => 'Atlantik/Faroe Adaları',
    'America/Danmarkshavn' => 'Amerika/Danmarkshavn',
    'America/Scoresbysund' => 'Amerika/Scoresbysund',
    'America/Godthab' => 'Amerika/Godthab',
    'America/Thule' => 'Amerika/Thule',
    'Europe/Tallinn' => 'Avrupa/Tallinn',
    'Europe/Helsinki' => 'Avrupa/Helsinki',
    'Europe/Paris' => 'Avrupa/Paris',
    'Europe/Berlin' => 'Avrupa/Berlin',
    'Europe/Gibraltar' => 'Avrupa/Cebelitarık',
    'Europe/Athens' => 'Avrupa/Atina',
    'Europe/Budapest' => 'Avrupa/Budapeşte',
    'Atlantic/Reykjavik' => 'Atlantik/Reykjavik',
    'Europe/Rome' => 'Avrupa/Roma',
    'Europe/Riga' => 'Avrupa/Riga',
    'Europe/Vaduz' => 'Avrupa/Vaduz',
    'Europe/Vilnius' => 'Avrupa/Vilnius',
    'Europe/Luxembourg' => 'Avrupa/Lüksemburg',
    'Europe/Malta' => 'Avrupa/Malta',
    'Europe/Chisinau' => 'Avrupa/Chisinau',
    'Europe/Monaco' => 'Avrupa/Monako',
    'Europe/Amsterdam' => 'Avrupa/Amsterdam',
    'Europe/Oslo' => 'Avrupa/Oslo',
    'Europe/Warsaw' => 'Avrupa/Warşova',
    'Europe/Lisbon' => 'Avrupa/Lizbon',
    'Atlantic/Azores' => 'Atlantik/Azores',
    'Atlantic/Madeira' => 'Atlantik/Madeira',
    'Europe/Bucharest' => 'Avrupa/Bükreş',
    'Europe/Kaliningrad' => 'Avrupa/Kaliningrad',
    'Europe/Moscow' => 'Avrupa/Moskova',
    'Europe/Samara' => 'Avrupa/Samara',
    'Asia/Yekaterinburg' => 'Asya/Yekaterinburg',
    'Asia/Omsk' => 'Asya/Omsk',
    'Asia/Novosibirsk' => 'Asya/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asya/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asya/Irkutsk',
    'Asia/Yakutsk' => 'Asya/Yakutsk',
    'Asia/Vladivostok' => 'Asya/Vladivostok',
    'Asia/Sakhalin' => 'Asya/Sakhalin',
    'Asia/Magadan' => 'Asya/Magadan',
    'Asia/Kamchatka' => 'Asya/Kamchatka',
    'Asia/Anadyr' => 'Asya/Anadyr',
    'Europe/Belgrade' => 'Avrupa/Belgrad',
    'Europe/Madrid' => 'Avrupa/Madrid',
    'Africa/Ceuta' => 'Afrika/Ceuta',
    'Atlantic/Canary' => 'Atlantik/Kanarya',
    'Europe/Stockholm' => 'Avrupa/Stokholm',
    'Europe/Zurich' => 'Avrupa/Zürih',
    'Europe/Istanbul' => 'Avrupa/İstanbul',
    'Europe/Kiev' => 'Avrupa/Kiev',
    'Europe/Uzhgorod' => 'Avrupa/Uzhgorod',
    'Europe/Zaporozhye' => 'Avrupa/Zaporozhye',
    'Europe/Simferopol' => 'Avrupa/Simferopol',
    'America/New_York' => 'Amerika/New_York',
    'America/Chicago' => 'Amerika/Şikago',
    'America/North_Dakota/Center' => 'Amerika/Kuzey_Dakota/Merkez',
    'America/Denver' => 'Amerika/Denver',
    'America/Los_Angeles' => 'Amerika/Los_Angeles',
    'America/Juneau' => 'Amerika/Juneau',
    'America/Yakutat' => 'Amerika/Yakutat',
    'America/Anchorage' => 'Amerika/Anchorage',
    'America/Nome' => 'Amerika/Nome',
    'America/Adak' => 'Amerika/Adak',
    'Pacific/Honolulu' => 'Pasifik/Honolulu',
    'America/Phoenix' => 'Amerika/Phoenix',
    'America/Boise' => 'Amerika/Boise',
    'America/Indiana/Indianapolis' => 'Amerika/Indiana/Indianapolis',
    'America/Indiana/Marengo' => 'Amerika/Indiana/Marengo',
    'America/Indiana/Knox' => 'Amerika/Indiana/Knox',
    'America/Indiana/Vevay' => 'Amerika/Indiana/Vevay',
    'America/Kentucky/Louisville' => 'Amerika/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'Amerika/Kentucky/Monticello',
    'America/Detroit' => 'Amerika/Detroit',
    'America/Menominee' => 'Amerika/Menominee',
    'America/St_Johns' => 'Amerika/St_Johns',
    'America/Goose_Bay' => 'Amerika/Goose_Bay',
    'America/Halifax' => 'Amerika/Halifax',
    'America/Glace_Bay' => 'Amerika/Glace_Bay',
    'America/Montreal' => 'Amerika/Montreal',
    'America/Toronto' => 'Amerika/Toronto',
    'America/Thunder_Bay' => 'Amerika/Thunder_Bay',
    'America/Nipigon' => 'Amerika/Nipigon',
    'America/Rainy_River' => 'Amerika/Rainy_River',
    'America/Winnipeg' => 'Amerika/Winnipeg',
    'America/Regina' => 'Amerika/Regina',
    'America/Swift_Current' => 'Amerika/Swift_Current',
    'America/Edmonton' => 'Amerika/Edmonton',
    'America/Vancouver' => 'Amerika/Vancouver',
    'America/Dawson_Creek' => 'Amerika/Dawson_Creek',
    'America/Pangnirtung' => 'Amerika/Pangnirtung',
    'America/Iqaluit' => 'Amerika/Iqaluit',
    'America/Coral_Harbour' => 'Amerika/Coral_Harbour',
    'America/Rankin_Inlet' => 'Amerika/Rankin_Inlet',
    'America/Cambridge_Bay' => 'Amerika/Cambridge_Bay',
    'America/Yellowknife' => 'Amerika/Yellowknife',
    'America/Inuvik' => 'Amerika/Inuvik',
    'America/Whitehorse' => 'Amerika/Whitehorse',
    'America/Dawson' => 'Amerika/Dawson',
    'America/Cancun' => 'Amerika/Cancun',
    'America/Merida' => 'Amerika/Merida',
    'America/Monterrey' => 'Amerika/Monterrey',
    'America/Mexico_City' => 'Amerika/Mexico_City',
    'America/Chihuahua' => 'Amerika/Chihuahua',
    'America/Hermosillo' => 'Amerika/Hermosillo',
    'America/Mazatlan' => 'Amerika/Mazatlan',
    'America/Tijuana' => 'Amerika/Tijuana',
    'America/Anguilla' => 'Amerika/Anguilla',
    'America/Antigua' => 'Amerika/Antigua',
    'America/Nassau' => 'Amerika/Nassau',
    'America/Barbados' => 'Amerika/Barbados',
    'America/Belize' => 'Amerika/Belize',
    'Atlantic/Bermuda' => 'Atlantik/Bermuda',
    'America/Cayman' => 'Amerika/Cayman',
    'America/Costa_Rica' => 'Amerika/Costa_Rica',
    'America/Havana' => 'Amerika/Havana',
    'America/Dominica' => 'Amerika/Dominika',
    'America/Santo_Domingo' => 'Amerika/Santo_Domingo',
    'America/El_Salvador' => 'Amerika/El_Salvador',
    'America/Grenada' => 'Amerika/Grenada',
    'America/Guadeloupe' => 'Amerika/Guadelup',
    'America/Guatemala' => 'Amerika/Guatemala',
    'America/Port-au-Prince' => 'Amerika/Port-au-Prince',
    'America/Tegucigalpa' => 'Amerika/Tegucigalpa',
    'America/Jamaica' => 'Amerika/Jamaika',
    'America/Martinique' => 'Amerika/Martinik',
    'America/Montserrat' => 'Amerika/Montserrat',
    'America/Managua' => 'Amerika/Managua',
    'America/Panama' => 'Amerika/Panama',
    'America/Puerto_Rico' => 'America/Porto_Riko',
    'America/St_Kitts' => 'Amerika/St_Kitts',
    'America/St_Lucia' => 'Amerika/St_Lucia',
    'America/Miquelon' => 'Amerika/Miquelon',
    'America/St_Vincent' => 'Amerika/St_Vincent',
    'America/Grand_Turk' => 'Amerika/Grand_Turk',
    'America/Tortola' => 'Amerika/Tortola',
    'America/St_Thomas' => 'Amerika/St_Thomas',
    'America/Argentina/Buenos_Aires' => 'Amerika/Arjantin/Buenos_Aires',
    'America/Argentina/Cordoba' => 'Amerika/Arjantin/Kordoba',
    'America/Argentina/Tucuman' => 'Amerika/Arjantin/Tucuman',
    'America/Argentina/La_Rioja' => 'Amerika/Arjantin/La_Rioja',
    'America/Argentina/San_Juan' => 'Amerika/Arjantin/San_Juan',
    'America/Argentina/Jujuy' => 'Amerika/Arjantin/Jujuy',
    'America/Argentina/Catamarca' => 'Amerika/Arjantin/Catamarca',
    'America/Argentina/Mendoza' => 'Amerika/Arjantin/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'Amerika/Arjantin/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'Amerika/Arjantin/Ushuaia',
    'America/Aruba' => 'Amerika/Aruba',
    'America/La_Paz' => 'Amerika/La_Paz',
    'America/Noronha' => 'Amerika/Noronha',
    'America/Belem' => 'Amerika/Belem',
    'America/Fortaleza' => 'Amerika/Fortaleza',
    'America/Recife' => 'Amerika/Recife',
    'America/Araguaina' => 'Amerika/Araguaina',
    'America/Maceio' => 'Amerika/Maceio',
    'America/Bahia' => 'Amerika/Bahia',
    'America/Sao_Paulo' => 'Amerika/Sao_Paulo',
    'America/Campo_Grande' => 'Amerika/Campo_Grande',
    'America/Cuiaba' => 'Amerika/Cuiaba',
    'America/Porto_Velho' => 'Amerika/Porto_Velho',
    'America/Boa_Vista' => 'Amerika/Boa_Vista',
    'America/Manaus' => 'Amerika/Manaus',
    'America/Eirunepe' => 'Amerika/Eirunepe',
    'America/Rio_Branco' => 'Amerika/Rio_Branco',
    'America/Santiago' => 'Amerika/Santiago',
    'Pacific/Easter' => 'Pasifik/Easter',
    'America/Bogota' => 'Amerika/Bogota',
    'America/Curacao' => 'Amerika/Curaçao',
    'America/Guayaquil' => 'Amerika/Guayaquil',
    'Pacific/Galapagos' => 'Pasifik/Galapagos',
    'Atlantic/Stanley' => 'Atlantik/Stanley',
    'America/Cayenne' => 'Amerika/Cayenne',
    'America/Guyana' => 'Amerika/Guyana',
    'America/Asuncion' => 'Amerika/Asuncion',
    'America/Lima' => 'Amerika/Lima',
    'Atlantic/South_Georgia' => 'Atlantik/Güney_Georgia',
    'America/Paramaribo' => 'Amerika/Paramaribo',
    'America/Port_of_Spain' => 'Amerika/İspanya_Limanı',
    'America/Montevideo' => 'Amerika/Montevideo',
    'America/Caracas' => 'Amerika/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'Favoriler';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'Favori';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Kontakları',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'İstek',
    2 => 'Erişim',
    3 => 'Geçersiz',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugar Kullanıcısı',
    'support_portal' => 'Destek Portali',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'Kampanya',
    'email' => 'E-Posta',
    'workflow' => 'İş Akışı',
    'system' => 'Sistem',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'Kampanya',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'Kampanya',
    'email' => 'E-Posta',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'Dokümantasyon',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'İki Aralık',
    'show_buckets' => 'Üç Aralık',
    'show_custom_buckets' => 'Özel Aralıklar',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'Tarihe Dayalı Yıl',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'Yıllık (Çeyreklik alt-dönemler)',
    'Quarter' => 'Çeyreklik (Aylık alt-dönemler)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'Gelir Kalemleri',
    'Opportunities' => 'Fırsatlar',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'Evet',
    'no' => 'Hayır',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'Alarm',
    'information' => 'Bilgi',
    'other' => 'Diğer',
    'success' => 'Başarılı',
    'warning' => 'Uyarı',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'YAYINLA',
    'GET' => 'AL',
    'PUT' => 'KOY',
    'DELETE' => 'SİL',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'Manuel',
    '5' => 'Her 5 dak.',
    '15' => 'Her 15 dakikada',
    '30' => 'Her 30 dakikada',
    '60' => 'Her Saat',
];

$app_list_strings['moduleList']['KBDocuments'] = 'Bilgi Tabanı';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'Bilgi Tabanı';
$app_list_strings['moduleList']['KBContents'] = 'Bilgi Tabanı';
$app_list_strings['moduleListSingular']['KBContents'] = 'Bilgi Bankası Makalesi';
$app_list_strings['moduleList']['KBArticles'] = 'Bilgi Tabanı Makalesi';
$app_list_strings['moduleListSingular']['KBArticles'] = 'Bilgi Tabanı Makalesi';
$app_list_strings['moduleList']['KBContentTemplates'] = 'Bilgi Bankası Şablonu';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'Bilgi Bankası Şablonu';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'Karıştırılmış Dosyalar';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'Karıştırılmış Dosya';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leke',
    'USD' => 'Dolar',
    'AFN' => 'Afganisi',
    'ARS' => 'Peso',
    'AWG' => 'Gulden',
    'AUD' => 'Dolar',
    'AZN' => 'Yeni Manat',
    'BSD' => 'Dolar',
    'BBD' => 'Dolar',
    'BYR' => 'Ruble',
    'EUR' => 'Euro',
    'BZD' => 'Dolar',
    'BMD' => 'Dolar',
    'BOB' => 'Bolivyano',
    'BAM' => 'Bosna-Hersek Markı',
    'BWP' => 'Pulas',
    'BGN' => 'Leva',
    'BRL' => 'Brezilya Reali',
    'GBP' => 'Paund',
    'BND' => 'Dolar',
    'KHR' => 'Riels',
    'CAD' => 'Dolar',
    'KYD' => 'Dolar',
    'CLP' => 'Peso',
    'CNY' => 'Yuan Renminbi',
    'COP' => 'Peso',
    'CRC' => 'ColÃ³n',
    'HRK' => 'Kuna',
    'CUP' => 'Peso',
    'CZK' => 'Koruny',
    'DKK' => 'Kron',
    'DOP' => 'Peso',
    'XCD' => 'Dolar',
    'EGP' => 'Paund',
    'SVC' => 'Colones',
    'EEK' => 'Krooni',
    'FKP' => 'Paund',
    'FJD' => 'Dolar',
    'GHC' => 'Cedis',
    'GIP' => 'Paund',
    'GTQ' => 'Quetzales',
    'GGP' => 'Paund',
    'GYD' => 'Dolar',
    'HNL' => 'Lempira',
    'HKD' => 'Dolar',
    'HUF' => 'Forint',
    'ISK' => 'Kronur',
    'INR' => 'Rupi',
    'IDR' => 'Rupiah',
    'IRR' => 'Riyal',
    'IMP' => 'Paund',
    'ILS' => 'Yeni Şikel',
    'JMD' => 'Dolar',
    'JPY' => 'Yen',
    'JEP' => 'Paund',
    'KZT' => 'Tenge',
    'KPW' => 'Won',
    'KRW' => 'Won',
    'KGS' => 'Som',
    'LAK' => 'Kip',
    'LVL' => 'Lati',
    'LBP' => 'Paund',
    'LRD' => 'Dolar',
    'CHF' => 'İsviçre Frankı',
    'LTL' => 'Litai',
    'MKD' => 'Dinar',
    'MYR' => 'Ringgit',
    'MUR' => 'Rupi',
    'MXN' => 'Peso',
    'MNT' => 'Tugrik',
    'MZN' => 'Metical',
    'NAD' => 'Dolar',
    'NPR' => 'Rupi',
    'ANG' => 'Gulden',
    'NZD' => 'Dolar',
    'NIO' => 'Kordaba',
    'NGN' => 'Naira',
    'NOK' => 'Kron',
    'OMR' => 'Riyal',
    'PKR' => 'Rupi',
    'PAB' => 'Balboa',
    'PYG' => 'Guarani',
    'PEN' => 'Nuevos Soles',
    'PHP' => 'Peso',
    'PLN' => 'Zloti',
    'QAR' => 'Riyal',
    'RON' => 'Yeni Ley',
    'RUB' => 'Ruble',
    'SHP' => 'Paund',
    'SAR' => 'Riyal',
    'RSD' => 'Dinar',
    'SCR' => 'Rupi',
    'SGD' => 'Dolar',
    'SBD' => 'Dolar',
    'SOS' => 'Şilin',
    'ZAR' => 'Rand',
    'LKR' => 'Rupi',
    'SEK' => 'İsveç Kronu',
    'SRD' => 'Dolar',
    'SYP' => 'Paund',
    'TWD' => 'Yeni Dolar',
    'THB' => 'Baht',
    'TTD' => 'Dolar',
    'TRY' => 'Lira',
    'TRL' => 'Lira',
    'TVD' => 'Dolar',
    'UAH' => 'Hryvnia',
    'UYU' => 'Peso',
    'UZS' => 'Sum',
    'VEF' => 'Bolivares Fuertes',
    'VND' => 'Dong',
    'YER' => 'Riyal',
    'ZWD' => 'Zimbabwe Doları',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'Çok Yüksek',
    '4' => 'Yüksek',
    '3' => 'Nötr',
    '2' => 'Düşük',
    '1' => 'Çok Düşük',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'Yok',
    'future' => 'Güncel Değer',
    'old' => 'Eski Değer',
    'both' => 'Güncel ve Eski Değerler',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Tek-Vuruş',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'İşleme',
    'error' => 'Hata',
    'success' => 'Başarılı',
    'canceled' => 'İptal Edildi',
    'document_load' => 'Şablon Yükleme',
    'tags_extract' => 'Etiketleri Çıkarma',
    'tags_validate' => 'Etiketleri Doğrulama',
    'data_retrieving' => 'Veri Alma',
    'serialize_document' => 'Belgeyi tekrar bir araya getirme',
    'send_document' => 'Belgenin size gönderilmesi',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'Birleştir',
    'convert' => 'PDF Birleştir',
    'multimerge' => 'Çoklu Birleştirme',
    'multimerge_convert' => 'Çoklu PDF Birleştirme',
    'labelsgenerate' => 'Etiketler Oluştur',
    'labelsgenerate_convert' => 'PDF Etiketler Oluştur',
    'excel' => 'Excel Birleştirme',
    'excel_convert' => 'Excel Birleştirme Dönüştür',
    'presentation' => 'PowerPoint Birleştirme',
    'presentation_convert' => 'PowerPoint PDF Birleştirme',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'Hesaplarım',
    'favorites' => 'Favori Hesaplar',
    'tags' => 'Etiketlenen hesaplar',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'Bütün Haberler',
    'General' => 'Genel
',
    'Finance' => 'Mali',
    'People' => 'Personel',
    'Press Releases' => 'Basın Duyuruları',
    'Other' => 'Diğer',
];

$app_strings['LBL_OWNERS'] = 'Sahipleri';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Bulut Sürücüsü';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'Bulut Sürücüsü Entegrasyon Panosu';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'Bağlantıyı Kopyala';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'İndir';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Sugar Belgesi Oluştur';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'Bu dosya indirilemiyor';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'Bulut panosu mevcut değil';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar Belgesi Oluşturuldu';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'DocuSign&#39;a Gönder';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign bu konumdan kullanılamıyor.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'Word/Excel/PowerPoint için Belge Birleştirme bu konumdan kullanılamıyor';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'DocuSign için Belge Birleştirme bu konumdan kullanılamıyor';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'PDF için Belge Birleştirme bu konumdan kullanılamıyor';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'İmzalı dosyanız yalnızca bu konuma yükleme izniniz varsa buraya yüklenecektir.';
$app_strings['LBL_DOC_MERGE_TO'] = 'Şununla Belge Birleştirme:';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'Dosyalarım';
$app_strings['LBL_SHARED_WITH_ME'] = 'Benimle Paylaşılan';
$app_strings['LBL_CLOUD_PROVIDER'] = 'Bulut Sağlayıcı';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Sürücüsü',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'Benimle Paylaşılan';
$app_strings['LBL_MY_FILES'] = 'Dosyalarım';
$app_strings['LBL_UPLOAD_FILE'] = 'Dosya Yükle';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'Klasör bulunamadı';
$app_strings['LBL_CREATE_FOLDER'] = 'Klasör Oluştur';
$app_strings['LBL_LOAD_MORE'] = 'Daha fazla yükle...';
$app_strings['LBL_NEW_FOLDER'] = 'Yeni Klasör';
$app_strings['LBL_FOLDER_NAME'] = 'Klasör Adı: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'Geçerli yolda bunu yapma izniniz yok.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'Geçerli yolda gitme izniniz yok.';
$app_strings['LBL_FILE_UPLOADED'] = 'Dosya yüklendi.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'Dosyanızın büyük boyutu nedeniyle yükleme işlemi biraz zaman alacak.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'Bir veya daha fazla belge kaydında bir ekli dosya yok. Lütfen kayıtlara dosyalar ekleyin ve tekrar deneyin ya da belirli kayıtları dosyalarla tek tek eşitleyin.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Google ile bağlantı bulunamadı...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Microsoft ile bağlantı bulunamadı...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Dropbox ile bağlantı bulunamadı...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'OneDrive ile senkronizasyon biraz zaman alabilir';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'Bu dosyayı silmek istediğinizden emin misiniz?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDrive yüklemesi tamamlandı.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' başarıyla yüklendi.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'Yolların yüklenmesi sırasında hata oluştu.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'Dosya bozuk olduğu için bir hata oluştu.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'Belge <i>"{{documentName}}"</i> bulut sürücünüze kaydedildi ve Belgeler modülüne eklendi.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'Bu dosyayı silmek için yetkiniz yok.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'Bu klasörü silmek için yetkiniz yok.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'Bu konuma dosya yüklemek için izniniz yok.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'Bu konumda bir klasör oluşturmak için izniniz yok.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'Bu konumda klasörler oluşturulamaz.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'Dosyalar bu konuma yüklenemez.';
$app_strings['LBL_SITES'] = 'Siteler';
$app_strings['LBL_SHARED'] = 'Paylaşılan';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'Bağlantı oluşturuldu. Bağlantıyı panonuza kopyalamak için düğmeye tıklayın.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'Panoya kopyala';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-boşluk-',
    'Exact' => 'Kesin',
    'Null_address_components' => 'Bir veya daha fazla adres bileşeni boş',
    'Invalid_address' => 'Geçersiz Adres, sunucu Hata döndürdü',
    'Invalid_server_response_not_XML' => 'Geçersiz sunucu yanıtı, XML değil',
    'Invalid_address_no_location' => 'Geçrsiz adres, sunucu konum yok döndürdü',
    'Ambiguous_address' => 'Belirsiz adres, birden çok eşleşme',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'Yol',
    'a' => 'Havadan',
    'rd' => 'Karanlık Yol',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'İngilizce (ABD)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'New York (EST)'],
    ['pst', 'Los Angeles (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['Yeni', 'Yeni'],
    ['Atandı', 'Atandı'],
    ['Kapatıldı', 'Kapatıldı'],
    ['Bekleyen Giriş ', 'Bekleyen Giriş '],
    ['Reddedildi', 'Reddedildi'],
    ['Aynı Kayıttan Oluştur', 'Aynı Kayıttan Oluştur'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['Yönetim', 'Yönetim'],
    ['Ürün', 'Ürün'],
    ['Kullanıcı', 'Kullanıcı'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'Yüksek'],
    ['P2', 'Orta'],
    ['P3', 'Düşük'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['kullanıcı', 'Kullanıcı'],
    ['yönetici, kullanıcı', 'Yönetici'],
    ['hesap yöneticisi,kullanıcı', 'Hesap Yöneticisi'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['son_30_gün', 'Son 30 gün'],
    ['son_90_gün', 'Son 90 gün'],
    ['bu_yıl', 'Son Yıl'],
    ['özel', 'Özel Aralıklar'],
    ['tümü', 'Tümü'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['Varsayılan', 'Varsayılan'],
    ['Renk', 'Tek Renk'],
    ['Url', 'Özel Görüntü'],
];
