<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'ไทย',
    'moduleList' => [
        'Home' => 'หน้าแรก',
        'Contacts' => 'ที่อยู่ติดต่อ',
        'Accounts' => 'บัญชี',
        'Opportunities' => 'โอกาสทางการขาย',
        'Cases' => 'เคส',
        'Notes' => 'บันทึก',
        'Calls' => 'การโทร',
        'Emails' => 'อีเมล',
        'Meetings' => 'การประชุม',
        'Tasks' => 'งาน',
        'Calendar' => 'ปฏิทิน',
        'Leads' => 'ผู้สนใจ',
        'Currencies' => 'สกุลเงิน',
        'Contracts' => 'สัญญา',
        'Quotes' => 'การเสนอราคา',
        'Products' => 'รายการบรรทัดการเสนอราคา',
        'WebLogicHooks' => 'ฮุคของตรรกะเว็บ',
        'ProductCategories' => 'หมวดหมู่ผลิตภัณฑ์',
        'ProductTypes' => 'ประเภทผลิตภัณฑ์',
        'ProductTemplates' => 'แคตตาล็อกผลิตภัณฑ์',
        'ProductBundles' => 'ชุดผลิตภัณฑ์',
        'ProductBundleNotes' => 'หมายเหตุของชุดผลิตภัณฑ์',
        'Reports' => 'รายงาน',
        'Forecasts' => 'ประมาณการ',
        'ForecastWorksheets' => 'เวิร์กชีทประมาณการ',
        'ForecastManagerWorksheets' => 'เวิร์กชีทเครื่องมือจัดการประมาณการ',
        'VisualPipeline' => 'กระบวนการขายเสมือน',
        'ConsoleConfiguration' => 'การกำหนดค่าคอนโซล',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'โควตา',
        'Teams' => 'ทีม',
        'TeamNotices' => 'ประกาศของทีม',
        'Manufacturers' => 'ผู้ผลิต',
        'Activities' => 'กิจกรรม',
        'Comments' => 'ความคิดเห็น',
        'Subscriptions' => 'การสมัคร',
        'Bugs' => 'บัก',
        'Feeds' => 'RSS',
        'iFrames' => 'ไซต์ของฉัน',
        'TimePeriods' => 'ช่วงเวลา',
        'TaxRates' => 'อัตราภาษี',
        'ContractTypes' => 'ประเภทสัญญา',
        'Schedulers' => 'เครื่องมือวางกำหนดการ',
        'Project' => 'โครงการ',
        'ProjectTask' => 'งานของโครงการ',
        'Campaigns' => 'แคมเปญ',
        'CampaignLog' => 'ล็อกของแคมเปญ',
        'CampaignTrackers' => 'เครื่องมือติดตามแคมเปญ',
        'Documents' => 'เอกสาร',
        'DocumentRevisions' => 'รุ่นเอกสาร',
        'Connectors' => 'เครื่องมือเชื่อมต่อ',
        'Notifications' => 'การแจ้งเตือน',
        'Sync' => 'ซิงค์',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => 'ผู้ใช้จากภายนอก',
        'ReportMaker' => 'รายงานขั้นสูง',
        'DataSets' => 'รูปแบบข้อมูล',
        'CustomQueries' => 'การสืบค้นที่กำหนดเอง',
        'pmse_Inbox' => 'กระบวนการ',
        'pmse_Project' => 'การกำหนดกระบวนการ',
        'pmse_Business_Rules' => 'กฎทางธุรกิจของกระบวนการ',
        'pmse_Emails_Templates' => 'เทมเพลทอีเมลของกระบวนการ',
        'BusinessCenters' => 'ศูนย์บริการธุรกิจ',
        'Shifts' => 'เวรทำงาน',
        'ShiftExceptions' => 'ข้อยกเว้นเวรทำงาน',
        'Purchases' => 'ซื้อ',
        'PurchasedLineItems' => 'ซื้อสินค้าในไลน์',
        'MobileDevices' => 'อุปกรณ์เคลื่อนที่',
        'PushNotifications' => 'การแจ้งเตือนแบบพุช',
        'Escalations' => 'การเพิ่มขึ้น',
        'DocumentTemplates' => 'เทมเพลทเอกสาร',
        'DocumentMerges' => 'ผสานเอกสาร',
        'CloudDrivePaths' => 'เส้นทาง Cloud Drive',
        'WorkFlow' => 'การกำหนดเวิร์กโฟลว์',
        'EAPM' => 'บัญชีภายนอก',
        'Worksheet' => 'เวิร์กชีท',
        'Users' => 'ผู้ใช้',
        'Employees' => 'พนักงาน',
        'Administration' => 'การดูแลระบบ',
        'ACLRoles' => 'บทบาท',
        'InboundEmail' => 'อีเมลขาเข้า',
        'Releases' => 'รีลีส',
        'Prospects' => 'เป้าหมาย',
        'Queues' => 'คิว',
        'EmailMarketing' => 'การตลาดทางอีเมล',
        'EmailTemplates' => 'เทมเพลทอีเมล',
        'SNIP' => 'การเก็บถาวรอีเมล',
        'ProspectLists' => 'รายการเป้าหมาย',
        'SavedSearch' => 'การค้นหาที่บันทึกไว้',
        'UpgradeWizard' => 'วิซาร์ดการอัปเกรด',
        'Trackers' => 'เครื่องมือติดตาม',
        'TrackerPerfs' => 'ประสิทธิภาพของเครื่องมือติดตาม',
        'TrackerSessions' => 'เซสชันของเครื่องมือติดตาม',
        'TrackerQueries' => 'การสืบค้นเครื่องมือติดตาม',
        'FAQ' => 'คำถามที่พบบ่อย',
        'Newsletters' => 'จดหมายข่าว',
        'SugarFavorites' => 'รายการโปรด',
        'PdfManager' => 'เครื่องมือจัดการ PDF',
        'DataArchiver' => 'โปรแกรมเก็บข้อมูลถาวร',
        'ArchiveRuns' => 'ดำเนินการจัดเก็บถาวร',

        'OAuthKeys' => 'คีย์ผู้ใช้ OAuth',
        'OAuthTokens' => 'โทเค็น OAuth',
        'Filters' => 'ตัวกรอง',
        'UserSignatures' => 'ลายเซ็นอีเมล',
        'Shippers' => 'ผู้ให้บริการการส่งสินค้า',
        'Styleguide' => 'สไตล์ไกด์',
        'Feedbacks' => 'ฟีดแบ็ก',
        'Tags' => 'แท็ก',
        'Categories' => 'หมวดหมู่',
        'Dashboards' => 'แดชบอร์ด',
        'OutboundEmail' => 'การตั้งค่าอีเมล',
        'EmailParticipants' => 'ผู้มีส่วนร่วมในอีเมล',
        'DataPrivacy' => 'การคุ้มครองข้อมูลส่วนบุคคล (Data Privacy)',
        'ReportSchedules' => 'ตารางเวลารายงาน',
        'CommentLog' => 'บันทึกความคิดเห็น',
        'Holidays' => 'วันหยุด',
        'ChangeTimers' => 'เปลี่ยนตัวตั้งเวลา',
        'Metrics' => 'เมตริก',
        'Messages' => 'ข้อความ',
        'Audit' => 'ตรวจสอบ',
        'RevenueLineItems' => 'รายการบรรทัดรายได้',
        'DocuSignEnvelopes' => 'ซอง DocuSign',
        'Geocode' => 'จีโอโค้ด',
        'DRI_Workflows' => 'คู่มืออัจฉริยะ',
        'DRI_Workflow_Task_Templates' => 'คู่มืออัจฉริยะ เทมเพลตกิจกรรม',
        'DRI_SubWorkflows' => 'คู่มืออัจฉริยะ ขั้นตอน',
        'DRI_Workflow_Templates' => 'คู่มืออัจฉริยะ เทมเพลต',
        'CJ_WebHooks' => 'เว็บฮุค Sugar Automate',
        'CJ_Forms' => 'Smart Guide การดำเนินการ Sugar',
        'DRI_SubWorkflow_Templates' => 'คู่มืออัจฉริยะ เทมเพลตขั้นตอน',
        'PubSub_ModuleEvent_PushSubs' => 'การสมัครรับข้อมูลแบบพุชโมดูล Pub/Sub',
    ],

    'moduleIconList' => [
        'Home' => 'หลัก',
        'Contacts' => 'ติดต่อ',
        'Accounts' => 'บัญชี',
        'Opportunities' => 'โอกาส',
        'Cases' => 'Cs',
        'Notes' => 'Nt',
        'Calls' => 'Cl',
        'Emails' => 'อีเมล',
        'Meetings' => 'ประชุม',
        'Tasks' => 'Ts',
        'Calendar' => 'ปฏิทิน',
        'Leads' => 'ผู้สนใจ',
        'Currencies' => 'สกุลเงิน',
        'Contracts' => 'ติดต่อ',
        'Quotes' => 'ราคา',
        'Products' => 'ผลิตภัณฑ์',
        'WebLogicHooks' => 'ตว',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'ปผภ',
        'ProductTemplates' => 'มส',
        'ProductBundles' => 'ซส',
        'ProductBundleNotes' => 'ขซส',
        'Reports' => 'รง',
        'Forecasts' => 'คก',
        'ForecastWorksheets' => 'อค',
        'ForecastManagerWorksheets' => 'อผค',
        'Quotas' => 'Fo',
        'VisualPipeline' => 'ชม',
        'ConsoleConfiguration' => 'คป',
        'SugarLive' => 'ลช',
        'Teams' => 'ทม',
        'TeamNotices' => 'ตท',
        'Manufacturers' => 'ผผ',
        'Activities' => 'กก',
        'Comments' => 'คห',
        'Subscriptions' => 'ลช',
        'Bugs' => 'ขผ',
        'Feeds' => 'กป',
        'iFrames' => 'อฟ',
        'TimePeriods' => 'ชว',
        'TaxRates' => 'อภ',
        'ContractTypes' => 'ปส',
        'Schedulers' => 'ผง',
        'Project' => 'คก',
        'ProjectTask' => 'งค',
        'Campaigns' => 'Ca',
        'CampaignLog' => 'บส',
        'CampaignTrackers' => 'ตส',
        'Documents' => 'อส',
        'DocumentRevisions' => 'กอส',
        'Connectors' => 'ชต',
        'Notifications' => 'จต',
        'Sync' => 'กซ',
        'HintAccountsets' => 'ตบ',
        'HintNotificationTargets' => 'ปต',
        'HintNewsNotifications' => 'ตข',
        'HintEnrichFieldConfigs' => 'ตรป',
        'ExternalUsers' => 'ผน',
        'ReportMaker' => 'จร',
        'DataSets' => 'คข',
        'CustomQueries' => 'ผท',
        'pmse_Inbox' => 'กข',
        'pmse_Project' => 'คก',
        'pmse_Business_Rules' => 'กธ',
        'pmse_Emails_Templates' => 'มม',
        'BusinessCenters' => 'BC',
        'Shifts' => 'กย',
        'ShiftExceptions' => 'ยย',
        'Purchases' => 'กซ',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'อค',
        'PushNotifications' => 'จตพ',
        'Escalations' => 'พส',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'ขง',
        'EAPM' => 'อพ',
        'Worksheet' => 'ผง',
        'Users' => 'ผช',
        'Employees' => 'ลจ',
        'Administration' => 'กบ',
        'ACLRoles' => 'นท',
        'InboundEmail' => 'มข',
        'Releases' => 'ปอ',
        'Prospects' => 'อก',
        'Queues' => 'ขค',
        'EmailMarketing' => 'ตอ',
        'EmailTemplates' => 'มอ',
        'SNIP' => 'สน',
        'ProspectLists' => 'รอ',
        'SavedSearch' => 'คบ',
        'UpgradeWizard' => 'อก',
        'Trackers' => 'ตต',
        'TrackerPerfs' => 'กต',
        'TrackerSessions' => 'วต',
        'TrackerQueries' => 'ผต',
        'FAQ' => 'คถ',
        'Newsletters' => 'ขส',
        'SugarFavorites' => 'ชช',
        'PdfManager' => 'ผพ',
        'DataArchiver' => 'ผก',
        'ArchiveRuns' => 'กส',
        'OAuthKeys' => 'คอ',
        'OAuthTokens' => 'ทอ',
        'Filters' => 'ตก',
        'UserSignatures' => 'ลผ',
        'Shippers' => 'ขร',
        'Styleguide' => 'นส',
        'Feedbacks' => 'ตร',
        'Tags' => 'ตท',
        'Categories' => 'ปภ',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'มอ',
        'EmailParticipants' => 'ผม',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'ตร',
        'CommentLog' => 'บค',
        'Holidays' => 'วย',
        'ChangeTimers' => 'ปว',
        'Metrics' => 'มต',
        'Messages' => 'ขค',
        'Audit' => 'ตป',
        'RevenueLineItems' => 'ขภ',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'จค',
        'DRI_Workflows' => 'ขด',
        'DRI_Workflow_Task_Templates' => 'มง',
        'DRI_SubWorkflows' => 'ขย',
        'DRI_Workflow_Templates' => 'มข',
        'CJ_WebHooks' => 'วซ',
        'CJ_Forms' => 'ฟซ',
        'DRI_SubWorkflow_Templates' => 'มย',
        'Library' => 'หส',
        'EmailAddresses' => 'ทอ',
        'Words' => 'คพ',
        'Sugar_Favorites' => 'ชช',
        'KBDocuments' => 'อค',
        'KBContents' => 'นอ',
        'KBArticles' => 'ขค',
        'KBContentTemplates' => 'มนอ',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'ขฝ',
    ],

    'moduleListSingular' => [
        'Home' => 'หน้าแรก',
        'Dashboards' => 'แดชบอร์ด',
        'Styleguide' => 'สไตล์ไกด์',
        'Contacts' => 'ที่อยู่ติดต่อ',
        'Accounts' => 'บัญชี',
        'Opportunities' => 'โอกาสทางการขาย',
        'Cases' => 'เคส',
        'Notes' => 'บันทึก',
        'Calls' => 'การโทร',
        'Emails' => 'อีเมล',
        'Meetings' => 'การประชุม',
        'Tasks' => 'งาน',
        'Calendar' => 'ปฏิทิน',
        'Leads' => 'ผู้สนใจ',
        'Manufacturers' => 'ผู้ผลิต',
        'VisualPipeline' => 'กระบวนการขายเสมือน',
        'ConsoleConfiguration' => 'การกำหนดค่าคอนโซล',
        'MobileDevices' => 'อุปกรณ์เคลื่อนที่',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'สัญญา',
        'Quotes' => 'การเสนอราคา',
        'Products' => 'รายการบรรทัดการเสนอราคา',
        'ProductCategories' => 'หมวดหมู่ผลิตภัณฑ์',
        'ProductBundles' => 'ชุดผลิตภัณฑ์',
        'ProductBundleNotes' => 'หมายเหตุของชุดผลิตภัณฑ์',
        'RevenueLineItems' => 'รายการบรรทัดรายได้',
        'WebLogicHooks' => 'ฮุคของตรรกะเว็บ',
        'Reports' => 'รายงาน',
        'Forecasts' => 'ประมาณการ',
        'ForecastWorksheets' => 'เวิร์กชีทประมาณการ',
        'ForecastManagerWorksheets' => 'เวิร์กชีทเครื่องมือจัดการประมาณการ',
        'Quotas' => 'โควตา',
        'Teams' => 'ทีม',
        'TeamNotices' => 'ประกาศของทีม',
        'Activities' => 'กิจกรรม',
        'ActivityStream' => 'สตรีมกิจกรรม',
        'Bugs' => 'บัก',
        'Feeds' => 'RSS',
        'iFrames' => 'ไซต์ของฉัน',
        'TimePeriods' => 'ช่วงเวลา',
        'TaxRates' => 'อัตราภาษี',
        'ContractTypes' => 'ประเภทสัญญา',
        'Schedulers' => 'เครื่องมือวางกำหนดการ',
        'Campaigns' => 'แคมเปญ',
        'CampaignLog' => 'ล็อกของแคมเปญ',
        'Project' => 'โครงการ',
        'ProjectTask' => 'งานของโครงการ',
        'Prospects' => 'เป้าหมาย',
        'ProspectLists' => 'รายการเป้าหมาย',
        'CampaignTrackers' => 'เครื่องมือติดตามแคมเปญ',
        'Documents' => 'เอกสาร',
        'DocumentRevisions' => 'รุ่นเอกสาร',
        'Connectors' => 'เครื่องมือเชื่อมต่อ',
        'Notifications' => 'การแจ้งเตือน',
        'Sync' => 'ซิงค์',
        'PdfManager' => 'เครื่องมือจัดการ PDF',
        'DataArchiver' => 'โปรแกรมเก็บข้อมูลถาวร',
        'ArchiveRuns' => 'ดำเนินการจัดเก็บถาวร',
        'ExternalUsers' => 'ผู้ใช้จากภายนอก',
        'ReportMaker' => ' รายงานขั้นสูง',
        'DataSets' => 'รูปแบบข้อมูล',
        'CustomQueries' => 'การสืบค้นที่กำหนดเอง',
        'pmse_Inbox' => 'กระบวนการ',
        'pmse_Project' => 'การกำหนดกระบวนการ',
        'pmse_Business_Rules' => 'กฎทางธุรกิจของกระบวนการ',
        'pmse_Emails_Templates' => 'เทมเพลทอีเมลของกระบวนการ',
        'BusinessCenters' => 'ศูนย์บริการธุรกิจ',
        'Shifts' => 'เวรทำงาน',
        'ShiftExceptions' => 'ข้อยกเว้นเวรทำงาน',
        'Purchases' => 'ซื้อ',
        'PurchasedLineItems' => 'ซื้อสินค้าในไลน์',
        'PushNotifications' => 'การแจ้งเตือนแบบพุช',
        'Escalations' => 'การเพิ่มขึ้น',
        'DocumentTemplates' => 'เทมเพลทเอกสาร',
        'DocumentMerges' => 'ผสานเอกสาร',
        'CloudDrivePaths' => 'เส้นทาง Cloud Drive',
        'WorkFlow' => 'เวิร์กโฟลว์',
        'EAPM' => 'บัญชีภายนอก',
        'Worksheet' => 'เวิร์กชีท',
        'Users' => 'ผู้ใช้',
        'SugarFavorites' => 'SugarFavorites',
        'Employees' => 'พนักงาน',
        'Administration' => 'การดูแลระบบ',
        'ACLRoles' => 'บทบาท',
        'InboundEmail' => 'อีเมลขาเข้า',
        'Releases' => 'รีลีส',
        'Queues' => 'คิว',
        'EmailMarketing' => 'การตลาดทางอีเมล',
        'EmailTemplates' => 'เทมเพลทอีเมล',
        'SNIP' => 'การเก็บถาวรอีเมล',
        'SavedSearch' => 'การค้นหาที่บันทึกไว้',
        'UpgradeWizard' => 'วิซาร์ดการอัปเกรด',
        'Trackers' => 'เครื่องมือติดตาม',
        'TrackerPerfs' => 'ประสิทธิภาพของเครื่องมือติดตาม',
        'TrackerSessions' => 'เซสชันของเครื่องมือติดตาม',
        'TrackerQueries' => 'การสืบค้นเครื่องมือติดตาม',
        'FAQ' => 'คำถามที่พบบ่อย',
        'Newsletters' => 'จดหมายข่าว',
        'OAuthKeys' => 'คีย์ผู้ใช้ OAuth',
        'OAuthTokens' => 'โทเค็น OAuth',
        'Filters' => 'ตัวกรอง',
        'Comments' => 'ความคิดเห็น',
        'CommentLog' => 'บันทึกความคิดเห็น',
        'Currencies' => 'สกุลเงิน',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'ประเภทผลิตภัณฑ์',
        'Shippers' => 'ผู้ให้บริการการส่งสินค้า',
        'Subscriptions' => 'การสมัคร',
        'UserSignatures' => 'ลายเซ็นอีเมล',
        'Feedbacks' => 'ฟีดแบ็ก',
        'Tags' => 'แท็ก',
        'Categories' => 'หมวดหมู่',
        'OutboundEmail' => 'การตั้งค่าอีเมล',
        'EmailParticipants' => 'ผู้มีส่วนร่วมในอีเมล',
        'DataPrivacy' => 'การคุ้มครองข้อมูลส่วนบุคคล (Data Privacy)',
        'ReportSchedules' => 'ตารางเวลารายงาน',
        'Holidays' => 'วันหยุด',
        'ChangeTimers' => 'เปลี่ยนตัวตั้งเวลา',
        'Metrics' => 'เมตริก',
        'Messages' => 'ข้อความ',
        'Audit' => 'ตรวจสอบ',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => 'จีโอโค้ด',
        'DRI_Workflows' => 'คู่มืออัจฉริยะ',
        'DRI_Workflow_Task_Templates' => 'คู่มืออัจฉริยะ เทมเพลตกิจกรรม',
        'DRI_SubWorkflows' => 'คู่มืออัจฉริยะ ขั้นตอน',
        'DRI_Workflow_Templates' => 'คู่มืออัจฉริยะ เทมเพลต',
        'CJ_WebHooks' => 'เว็บฮุค Sugar Automate',
        'CJ_Forms' => 'Smart Guide การดำเนินการ Sugar',
        'DRI_SubWorkflow_Templates' => 'คู่มืออัจฉริยะ เทมเพลตขั้นตอน',
        'PubSub_ModuleEvent_PushSubs' => 'การสมัครรับข้อมูลแบบพุชโมดูล Pub/Sub',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'ใช่',
        '2' => 'ไม่',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'ไม่',
        1 => 'ใช่',
    ],

    'notifications_status_dom' => [
        0 => 'ยังไม่ได้อ่าน',
        1 => 'อ่านแล้ว',
    ],

    'optout_dom' => [
        '' => '-ไม่มี-',
        'false' => 'ไม่',
        'true' => 'ใช่',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'นักวิเคราะห์',
        'Competitor' => 'คู่แข่ง',
        'Customer' => 'ลูกค้า',
        'Integrator' => 'ผู้รวมระบบ',
        'Investor' => 'นักลงทุน',
        'Partner' => 'คู่ค้า',
        'Press' => 'สื่อมวลชน',
        'Prospect' => 'ลูกค้าเป้าหมาย',
        'Reseller' => 'ผู้ค้าปลีก',
        'Other' => 'อื่นๆ',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'เครื่องแต่งกาย',
        'Banking' => 'ธนาคาร',
        'Biotechnology' => 'เทคโนโลยีชีวภาพ',
        'Chemicals' => 'เคมีภัณฑ์',
        'Communications' => 'การสื่อสาร',
        'Construction' => 'ก่อสร้าง',
        'Consulting' => 'ที่ปรึกษา',
        'Education' => 'การศึกษา',
        'Electronics' => 'อิเล็กทรอนิกส์',
        'Energy' => 'พลังงาน',
        'Engineering' => 'วิศวกรรม',
        'Entertainment' => 'บันเทิง',
        'Environmental' => 'สิ่งแวดล้อม',
        'Finance' => 'การเงิน',
        'Government' => 'ภาครัฐ',
        'Healthcare' => 'การดูแลสุขภาพ',
        'Hospitality' => 'ท่องเที่ยวและโรงแรม',
        'Insurance' => 'ประกันภัย',
        'Machinery' => 'เครื่องจักรกล',
        'Manufacturing' => 'การผลิต',
        'Media' => 'สื่อ',
        'Not For Profit' => 'ไม่หวังผลกำไร',
        'Recreation' => 'สันทนาการ',
        'Retail' => 'ค้าปลีก',
        'Shipping' => 'ขนส่ง',
        'Technology' => 'เทคโนโลยี',
        'Telecommunications' => 'โทรคมนาคม',
        'Transportation' => 'คมนาคม',
        'Utilities' => 'สาธารณูปโภค',
        'Other' => 'อื่นๆ',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF และ CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'แผนภูมิ',
        'Data Table' => 'ตารางข้อมูล',
        'Chart and Data Table' => 'แผนภูมิและตารางข้อมูล',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'อยู่ระหว่างดำเนินการ',
        'Completed' => 'เสร็จสมบูรณ์',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'ขาเข้า',
        'Outbound' => 'ขาออก',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'สนทนา',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'เทียร์ 1',
        'T2' => 'เทียร์ 2',
        'T3' => 'เทียร์ 3',
        'T4' => 'เทียร์ 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'ใช่',
        'No' => 'ไม่',
        'Completed' => 'เสร็จสมบูรณ์',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'อนาคต',
        'Active' => 'ทำงาน',
        'Past' => 'อดีต',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'สร้างขึ้นด้วยตนเอง',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'โทรศัพท์เสนอขาย',
        'Existing Customer' => 'ลูกค้าที่มีอยู่',
        'Self Generated' => 'สร้างขึ้นด้วยตนเอง',
        'Employee' => 'พนักงาน',
        'Partner' => 'คู่ค้า',
        'Public Relations' => 'ประชาสัมพันธ์',
        'Direct Mail' => 'ไปรษณีย์ขายตรง',
        'Conference' => 'ประชุม',
        'Trade Show' => 'งานแสดงสินค้า',
        'Web Site' => 'เว็บไซต์',
        'Word of mouth' => 'ปากต่อปาก',
        'Email' => 'อีเมล',
        'Campaign' => 'แคมเปญ',
        'Support Portal User Registration' => 'การลงทะเบียนผู้ใช้พอร์ทัลการสนับสนุน',
        'Other' => 'อื่นๆ',
    ],
    'metric_status_dom' => [
        'Inactive' => 'ไม่ใช้งาน',
        'Active' => 'ทำงานอยู่',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'ธุรกิจที่มีอยู่',
        'New Business' => 'ธุรกิจใหม่',
    ],
    'taxrate_status_dom' => [
        'Active' => 'ใช้งาน',
        'Inactive' => 'ไม่ใช้งาน',
    ],
    'roi_type_dom' => [
        'Revenue' => 'รายได้',
        'Investment' => 'การลงทุน',
        'Expected_Revenue' => 'รายได้ที่คาดไว้',
        'Budget' => 'งบประมาณ',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'ผู้ตัดสินใจหลัก',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'ผู้ตัดสินใจหลัก',
        'Business Decision Maker' => 'ผู้ตัดสินใจทางธุรกิจ',
        'Business Evaluator' => 'ผู้ประเมินธุรกิจ',
        'Technical Decision Maker' => 'ผู้ตัดสินใจด้านเทคนิค',
        'Technical Evaluator' => 'ผู้ประเมินด้านเทคนิค',
        'Executive Sponsor' => 'ผู้สนับสนุนฝ่ายบริหาร',
        'Influencer' => 'ผู้มีอำนาจโน้มน้าว',
        'Other' => 'อื่นๆ',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'ใช้งาน',
        'Inactive' => 'ไม่ใช้งาน',
    ],

    'shipper_status_dom' => [
        'Active' => 'ใช้งาน',
        'Inactive' => 'ไม่ใช้งาน',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'ผู้ติดต่อหลัก',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'ผู้ติดต่อหลัก',
        'Alternate Contact' => 'ผู้ติดต่อสำรอง',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'ค่าฟิลด์ด้านข้าง',
        'field_on_top' => 'ค่าฟิลด์ด้านบน',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'สุทธิ 15',
        'Net 30' => 'สุทธิ 30',
    ],
    'sales_stage_default_key' => 'ลูกค้าเป้าหมาย',
    'fts_type' => [
        'Elastic' => 'ElasticSearch',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'ลูกค้าเป้าหมาย',
        'Qualification' => 'คุณสมบัติ',
        'Needs Analysis' => 'การวิเคราะห์ความต้องการ',
        'Value Proposition' => 'ข้อเสนอคุณค่า',
        'Id. Decision Makers' => 'ID ผู้ตัดสินใจ',
        'Perception Analysis' => 'การวิเคราะห์การรับรู้',
        'Proposal/Price Quote' => 'ข้อเสนอ/การเสนอราคา',
        'Negotiation/Review' => 'การต่อรอง/การตรวจทาน',
        'Closed Won' => 'ปิดโดยได้รับการขาย',
        'Closed Lost' => 'ปิดโดยไม่ได้รับการขาย',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'ใหม่',
        'In Progress' => 'อยู่ระหว่างดำเนินการ',
        'Closed Won' => 'ปิดโดยได้รับการขาย',
        'Closed Lost' => 'ปิดโดยไม่ได้รับการขาย',
        'Converted to Quote' => 'แปลงเป็นการเสนอราคาแล้ว',
    ],
    'sales_status_dom' => [
        'New' => 'ใหม่',
        'In Progress' => 'อยู่ระหว่างดำเนินการ',
        'Closed Won' => 'ปิดโดยได้รับการขาย',
        'Closed Lost' => 'ปิดโดยไม่ได้รับการขาย',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'รวม',
        'exclude' => 'ไม่รวม',
    ],
    'commit_stage_dom' => [
        'include' => 'รวม',
        'upside' => 'ข้อดี',
        'exclude' => 'ไม่รวม',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'รวม',
        'upside' => 'ข้อดี',
        'exclude' => 'ไม่รวม',
    ],

    'in_total_group_stages' => [
        'Draft' => 'ร่าง',
        'Negotiation' => 'การต่อรอง',
        'Delivered' => 'จัดส่งแล้ว',
        'On Hold' => 'ระงับ',
        'Confirmed' => 'ยืนยันแล้ว',
        'Closed Accepted' => 'ปิดโดยยอมรับแล้ว',
        'Closed Lost' => 'ปิดโดยไม่ได้รับการขาย',
        'Closed Dead' => 'ปิดโดยถูกปฏิเสธ',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'การโทร',
        'Meeting' => 'การประชุม',
        'Task' => 'งาน',
        'Email' => 'อีเมล',
        'Note' => 'บันทึก',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'นาย',
        'Ms.' => 'คุณ',
        'Mrs.' => 'นาง',
        'Dr.' => 'ดร.',
        'Prof.' => 'ศ.',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'ไม่มี',
        60 => 'ล่วงหน้า 1 นาที',
        300 => 'ล่วงหน้า 5 นาที',
        600 => 'ล่วงหน้า 10 นาที',
        900 => 'ล่วงหน้า 15 นาที',
        1800 => 'ล่วงหน้า 30 นาที',
        3600 => 'ล่วงหน้า 1 ชั่วโมง',
        7200 => 'ล่วงหน้า 2 ชั่วโมง',
        10800 => 'ล่วงหน้า 3 ชั่วโมง',
        18000 => 'ล่วงหน้า 5 ชั่วโมง',
        86400 => 'ล่วงหน้า 1 วัน',
        ],

        'task_priority_default' => 'ปานกลาง',
        'task_priority_dom' => [
        'High' => 'สูง',
        'Medium' => 'ปานกลาง',
        'Low' => 'ต่ำ',
        ],
        'task_status_default' => 'ยังไม่เริ่มต้น',
        'task_status_dom' => [
        'Not Started' => 'ยังไม่เริ่มต้น',
        'In Progress' => 'อยู่ระหว่างดำเนินการ',
        'Completed' => 'เสร็จสมบูรณ์',
        'Pending Input' => 'รออินพุต',
        'Deferred' => 'เลื่อนออก',
        'Not Applicable' => 'ใช้งานไม่ได้',
        ],
        'meeting_status_default' => 'วางแผน',
        'meeting_status_dom' => [
        'Planned' => 'วางกำหนดการแล้ว',
        'Held' => 'ระงับ',
        'Not Held' => 'ยกเลิก',
        'Deferred' => 'เลื่อนออก',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'อื่นๆ',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'วางแผน',
        'call_status_dom' => [
        'Planned' => 'วางกำหนดการแล้ว',
        'In Progress' => 'อยู่ระหว่างดำเนินการ',
        'Held' => 'ระงับ',
        'Not Held' => 'ยกเลิก',
        'Deferred' => 'เลื่อนออก',
        ],
        'call_direction_default' => 'ขาออก',
        'call_direction_dom' => [
        'Inbound' => 'ขาเข้า',
        'Outbound' => 'ขาออก',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'ใหม่',
        'Assigned' => 'ระบุแล้ว',
        'In Process' => 'ระหว่างดำเนินการ',
        'Converted' => 'แปลงค่าแล้ว',
        'Recycled' => 'รีไซเคิล',
        'Dead' => 'ไม่สำเร็จ',
        ],
        'gender_list' => [
        'male' => 'ชาย',
        'female' => 'หญิง',
        'other' => 'อื่น ๆ',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'ใหม่',
        'case_status_dom' => [
        'New' => 'ใหม่',
        'Assigned' => 'ระบุแล้ว',
        'Closed' => 'ปิดแล้ว',
        'Pending Input' => 'รออินพุต',
        'Rejected' => 'ปฏิเสธ',
        'Duplicate' => 'ซ้ำ',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'สูง',
        'P2' => 'ปานกลาง',
        'P3' => 'ต่ำ',
        ],
        'user_type_dom' => [
        'RegularUser' => 'ผู้ใช้ทั่วไป',
        'Administrator' => 'ผู้ดูแลระบบ',
        ],
        'user_type_bool_dom' => [
            false => 'ผู้ใช้ทั่วไป',
            true => 'ผู้ดูแลระบบ',
        ],
        'user_type_group_bool_dom' => [
            true => 'ผู้ใช้ของกลุ่ม',
        ],
        'user_type_portal_bool_dom' => [
            true => 'ผู้ใช้ API ของพอร์ทัล',
        ],
        'license_type_dom' => [
        'CURRENT' => 'ผลิตภัณฑ์ปัจจุบัน',
        'SUGAR_SERVE' => 'Sugar บริการรับใช้',
        'SUGAR_SELL' => 'Sugar การขาย',
        ],
        'user_status_dom' => [
        'Active' => 'ใช้งาน',
        'Inactive' => 'ไม่ใช้งาน',
        ],
        'employee_status_dom' => [
        'Active' => 'ใช้งาน',
        'Terminated' => 'ยุติ',
        'Leave of Absence' => 'ลาหยุด',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'ทำงานอยู่',
        'Inactive' => 'ไม่ทำงาน',
        ],
        'project_task_priority_options' => [
        'High' => 'สูง',
        'Medium' => 'ปานกลาง',
        'Low' => 'ต่ำ',
        ],
        'project_task_priority_default' => 'ปานกลาง',

        'project_task_status_options' => [
        'Not Started' => 'ยังไม่เริ่มต้น',
        'In Progress' => 'อยู่ระหว่างดำเนินการ',
        'Completed' => 'เสร็จสมบูรณ์',
        'Pending Input' => 'รออินพุต',
        'Deferred' => 'เลื่อนออก',
        ],
        'project_task_utilization_options' => [
        '0' => 'ไม่มี',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'ร่าง',
        'In Review' => 'ระหว่างตรวจทาน',
        'Published' => 'เผยแพร่',
        ],
        'project_status_default' => 'ร่าง',

        'project_duration_units_dom' => [
        'Days' => 'วัน',
        'Hours' => 'ชั่วโมง',
        ],

        'project_priority_options' => [
        'High' => 'สูง',
        'Medium' => 'ปานกลาง',
        'Low' => 'ต่ำ',
        ],
        'project_priority_default' => 'ปานกลาง',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'บัญชี',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'บัญชี',
        'Opportunities' => 'โอกาสทางการขาย',
        'Cases' => 'เคส',
        'Leads' => 'ผู้สนใจ',
        'Contacts' => 'ที่อยู่ติดต่อ', // cn (11/22/2005) added to support Emails
        'Products' => 'รายการบรรทัดการเสนอราคา',
        'Quotes' => 'การเสนอราคา',
        'Bugs' => 'บัก',
        'Project' => 'โครงการ',

        'Prospects' => 'เป้าหมาย',
        'ProjectTask' => 'งานของโครงการ',

        'Tasks' => 'งาน',
        'KBContents' => 'ฐานความรู้',
        'Notes' => 'หมายเหตุ',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'บัญชี',
        'Contacts' => 'ที่อยู่ติดต่อ',
        'Opportunities' => 'โอกาสทางการขาย',
        'Tasks' => 'งาน',
        'ProductTemplates' => 'แคตตาล็อกผลิตภัณฑ์',
        'Quotes' => 'การเสนอราคา',
        'Products' => 'รายการบรรทัดการเสนอราคา',
        'Contracts' => 'สัญญา',
        'Emails' => 'อีเมล',

        'Bugs' => 'บัก',
        'Project' => 'โครงการ',
        'ProjectTask' => 'งานของโครงการ',
        'Prospects' => 'เป้าหมาย',
        'Cases' => 'เคส',
        'Leads' => 'ผู้สนใจ',

        'Meetings' => 'การประชุม',
        'Calls' => 'การโทร',
        'KBContents' => 'ฐานความรู้',
        'PurchasedLineItems' => 'ซื้อสินค้าในไลน์',
        'Purchases' => 'ซื้อ',
        'Escalations' => 'การเพิ่มขึ้น',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'บัญชี',
        'Contacts' => 'ที่อยู่ติดต่อ',
        'Employees' => 'พนักงาน',
        'Leads' => 'ผู้สนใจ',
        'Prospects' => 'เป้าหมาย',
        'Users' => 'ผู้ใช้',
        ],

        'parent_type_display' => [
        'Accounts' => 'บัญชี',
        'Contacts' => 'ที่อยู่ติดต่อ',
        'Tasks' => 'งาน',
        'Opportunities' => 'โอกาสทางการขาย',
        'Products' => 'รายการบรรทัดการเสนอราคา',
        'Quotes' => 'การเสนอราคา',

        'Bugs' => 'บัก',
        'Cases' => 'เคส',
        'Leads' => 'ผู้สนใจ',

        'Project' => 'โครงการ',
        'ProjectTask' => 'งานของโครงการ',

        'Prospects' => 'เป้าหมาย',
        'KBContents' => 'ฐานความรู้',
        'Notes' => 'หมายเหตุ',
        'PurchasedLineItems' => 'ซื้อสินค้าในไลน์',
        'Purchases' => 'ซื้อ',
        'Escalations' => 'การเพิ่มขึ้น',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'เคส',
        ],

        'product_status_default_key' => 'ส่ง',
        'product_status_quote_key' => 'การเสนอราคา',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'เสนอราคา',
        'Orders' => 'สั่งซื้อแล้ว',
        'Ship' => 'ส่งแล้ว',
        ],
        'active_status_dom' => [
        'Active' => 'ใช้งาน',
        'Inactive' => 'ไม่ใช้งาน',
        'Retired' => 'ถอนตัวออก',
        ],
        'appearance_options' => [
        'system_default' => 'ใช้การตั้งค่าระบบ',
        'light' => 'สว่าง',
        'dark' => 'เข้ม',
        ],


        'pricing_formula_default_key' => 'คงที่',
        'pricing_formula_dom' => [
        'Fixed' => 'ราคาคงที่',
        'ProfitMargin' => 'กำไรขั้นต้น',
        'PercentageMarkup' => 'มาร์คอัปจากต้นทุน',
        'PercentageDiscount' => 'ส่วนลดจากรายการ',
        'IsList' => 'เหมือนบัญชีราคา',
        ],
        'product_template_status_dom' => [
        'Available' => 'มีสต็อค',
        'Unavailable' => 'หมดสต็อค',
        ],
        'tax_class_dom' => [
        'Taxable' => 'ต้องคำนวณภาษี',
        'Non-Taxable' => 'ไม่ต้องคำนวณภาษี',
        ],
        'support_term_dom' => [
        '+6 months' => 'หกเดือน',
        '+1 year' => 'หนึ่งปี',
        '+2 years' => 'สองปี',
        ],

        'quote_type_dom' => [
        'Quotes' => 'การเสนอราคา',
        'Orders' => 'ลำดับ',
        ],
        'default_quote_stage_key' => 'ร่าง',
        'quote_stage_dom' => [
        'Draft' => 'ร่าง',
        'Negotiation' => 'การต่อรอง',
        'Delivered' => 'จัดส่งแล้ว',
        'On Hold' => 'ระงับ',
        'Confirmed' => 'ยืนยันแล้ว',
        'Closed Accepted' => 'ปิดโดยยอมรับแล้ว',
        'Closed Lost' => 'ปิดโดยไม่ได้รับการขาย',
        'Closed Dead' => 'ปิดโดยถูกปฏิเสธ',
        ],
        'default_order_stage_key' => 'รอดำเนินการ',
        'order_stage_dom' => [
        'Pending' => 'รอดำเนินการ',
        'Confirmed' => 'ยืนยันแล้ว',
        'On Hold' => 'ระงับ',
        'Shipped' => 'ส่งแล้ว',
        'Cancelled' => 'ยกเลิก',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'ผู้ตัดสินใจหลัก',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'ผู้ตัดสินใจหลัก',
        'Business Decision Maker' => 'ผู้ตัดสินใจทางธุรกิจ',
        'Business Evaluator' => 'ผู้ประเมินธุรกิจ',
        'Technical Decision Maker' => 'ผู้ตัดสินใจด้านเทคนิค',
        'Technical Evaluator' => 'ผู้ประเมินด้านเทคนิค',
        'Executive Sponsor' => 'ผู้สนับสนุนฝ่ายบริหาร',
        'Influencer' => 'ผู้มีอำนาจโน้มน้าว',
        'Other' => 'อื่นๆ',
        ],
        'layouts_dom' => [
        'Standard' => 'การเสนอราคา',
        'Invoice' => 'ใบแจ้งหนี้',
        ],
        'issue_priority_default_key' => 'ปานกลาง',
        'issue_priority_dom' => [
        'Urgent' => 'เร่งด่วน',
        'High' => 'สูง',
        'Medium' => 'ปานกลาง',
        'Low' => 'ต่ำ',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'ยอมรับแล้ว',
        'Duplicate' => 'ซ้ำ',
        'Closed' => 'ปิดแล้ว',
        'Out of Date' => 'เก่าเกินไป',
        'Invalid' => 'ไม่ถูกต้อง',
        ],

        'issue_status_default_key' => 'ใหม่',
        'issue_status_dom' => [
        'New' => 'ใหม่',
        'Assigned' => 'ระบุแล้ว',
        'Closed' => 'ปิดแล้ว',
        'Pending' => 'รอดำเนินการ',
        'Rejected' => 'ปฏิเสธ',
        ],

        'bug_priority_default_key' => 'ปานกลาง',
        'bug_priority_dom' => [
        'Urgent' => 'เร่งด่วน',
        'High' => 'สูง',
        'Medium' => 'ปานกลาง',
        'Low' => 'ต่ำ',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'ยอมรับแล้ว',
        'Duplicate' => 'ซ้ำ',
        'Fixed' => 'คงที่',
        'Out of Date' => 'เก่าเกินไป',
        'Invalid' => 'ไม่ถูกต้อง',
        'Later' => 'ภายหลัง',
        ],
        'bug_status_default_key' => 'ใหม่',
        'bug_status_dom' => [
        'New' => 'ใหม่',
        'Assigned' => 'ระบุแล้ว',
        'Closed' => 'ปิดแล้ว',
        'Pending' => 'รอดำเนินการ',
        'Rejected' => 'ปฏิเสธ',
        ],
        'bug_type_default_key' => 'บัก',
        'bug_type_dom' => [
        'Defect' => 'ข้อบกพร่อง',
        'Feature' => 'คุณลักษณะ',
        ],
        'case_type_dom' => [
        'Administration' => 'การดูแลระบบ',
        'Product' => 'ผลิตภัณฑ์',
        'User' => 'ผู้ใช้',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'ภายใน',
        'Forum' => 'ฟอรัม',
        'Web' => 'เว็บ',
        'InboundEmail' => 'อีเมล',
        'Twitter' => 'Twitter',
        'Portal' => 'พอร์ทัล',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'ภายใน',
        'Forum' => 'ฟอรัม',
        'Web' => 'เว็บ',
        'InboundEmail' => 'อีเมล',
        'Twitter' => 'Twitter',
        'Portal' => 'พอร์ทัล',
        'Phone' => 'โทรศัพท์',
        'Chat' => 'สนทนา',
        'Chatbot' => 'บอทสนทนา',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'ร้องขอการคุ้มครองข้อมูลส่วนบุคคล',
        'Send Personal Information being processed' => 'ดำเนินการส่งข้อมูลส่วนบุคคลแล้ว',
        'Rectify Information' => 'แก้ไขข้อมูล',
        'Request to Erase Information' => 'ร้องขอให้ลบข้อมูล',
        'Export Information' => 'ข้อมูลที่ส่งออก',
        'Restrict Processing' => 'การประมวลผลที่จำกัดขอบเขต',
        'Object to Processing' => 'คัดค้านการประมวลผล',
        'Consent to Process' => 'ยินยอมให้ดำเนินการ',
        'Withdraw Consent' => 'ถอดถอนความยินยอม',
        'Other' => 'อื่น ๆ',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'การสื่อสารทางธุรกิจ',
        'Marketing Communications by company' => 'การสื่อสารทางด้านการตลาดของบริษัท',
        'Marketing Communications by partners' => 'การสื่อสารทางด้านการตลาดของคู่ค้า',
        ],
        'dataprivacy_status_default_key' => 'เปิด',
        'dataprivacy_status_dom' => [
        'Open' => 'เปิด',
        'Closed' => 'เสร็จสมบูรณ์',
        'Rejected' => 'ปฏิเสธ',
        ],
        'dataprivacy_priority_default_key' => 'ต่ำ',
        'dataprivacy_priority_dom' => [
        'Low' => 'ต่ำ',
        'Medium' => 'ปานกลาง',
        'High' => 'สูง',
        ],
        'business_day_status_dom' => [
        'Open' => 'เปิด',
        'Open 24 Hours' => 'เปิด 24 ชั่วโมง',
        'Closed' => 'ปิด',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'บัญชี',
        'Activities' => 'กิจกรรม',
        'Bug Tracker' => 'เครื่องมือติดตามบัก',
        'Calendar' => 'ปฏิทิน',
        'Calls' => 'การโทร',
        'Campaigns' => 'แคมเปญ',
        'Cases' => 'เคส',
        'Contacts' => 'ที่อยู่ติดต่อ',
        'Currencies' => 'สกุลเงิน',
        'Dashboard' => 'แดชบอร์ด',
        'Documents' => 'เอกสาร',
        'Emails' => 'อีเมล',
        'Feeds' => 'ฟีด',
        'Forecasts' => 'ประมาณการ',
        'Help' => 'ความช่วยเหลือ',
        'Home' => 'หน้าแรก',
        'Leads' => 'ผู้สนใจ',
        'Meetings' => 'การประชุม',
        'Notes' => 'บันทึก',
        'Opportunities' => 'โอกาสทางการขาย',
        'Outlook Plugin' => 'ปลั๊กอินของ Outlook',
        'Product Catalog' => 'แคตตาล็อกผลิตภัณฑ์',
        'Products' => 'รายการบรรทัดการเสนอราคา',
        'RevenueLineItems' => 'รายการบรรทัดรายได้',
        'Projects' => 'โครงการ',
        'Quotes' => 'การเสนอราคา',
        'Releases' => 'รีลีส',
        'RSS' => 'RSS',
        'Studio' => 'Studio',
        'Upgrade' => 'อัปเกรด',
        'Users' => 'ผู้ใช้',
        'OutboundEmail' => 'การตั้งค่าอีเมล',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'การวางแผน',
        'Active' => 'ใช้งาน',
        'Inactive' => 'ไม่ใช้งาน',
        'Complete' => 'เสร็จสมบูรณ์',
        'In Queue' => 'ในคิว',
        'Sending' => 'กำลังส่ง',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'การขายทางไกล',
        'Mail' => 'ไปรษณีย์',
        'Email' => 'อีเมล',
        'Print' => 'พิมพ์',
        'Web' => 'เว็บ',
        'Radio' => 'วิทยุ',
        'Television' => 'โทรทัศน์',
        'NewsLetter' => 'จดหมายข่าว',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'รายสัปดาห์',
        'Monthly' => 'รายเดือน',
        'Quarterly' => 'รายไตรมาส',
        'Annually' => 'รายปี',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'มกราคม',
        '2' => 'กุมภาพันธ์',
        '3' => 'มีนาคม',
        '4' => 'เมษายน',
        '5' => 'พฤษภาคม',
        '6' => 'มิถุนายน',
        '7' => 'กรกฎาคม',
        '8' => 'สิงหาคม',
        '9' => 'กันยายน',
        '10' => 'ตุลาคม',
        '11' => 'พฤศจิกายน',
        '12' => 'ธันวาคม',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'ม.ค.',
        '2' => 'ก.พ.',
        '3' => 'มี.ค.',
        '4' => 'เม.ย.',
        '5' => 'พ.ค.',
        '6' => 'มิ.ย.',
        '7' => 'ก.ค.',
        '8' => 'ส.ค.',
        '9' => 'ก.ย.',
        '10' => 'ต.ค.',
        '11' => 'พ.ย.',
        '12' => 'ธ.ค.',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'วันอาทิตย์',
        '2' => 'วันจันทร์',
        '3' => 'วันอังคาร',
        '4' => 'วันพุธ',
        '5' => 'วันพฤหัสบดี',
        '6' => 'วันศุกร์',
        '7' => 'วันเสาร์',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'อาทิตย์',
        '2' => 'จันทร์',
        '3' => 'อังคาร',
        '4' => 'พุธ',
        '5' => 'พฤหัส',
        '6' => 'ศุกร์',
        '7' => 'เสาร์',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'อา',
        '2' => 'จ',
        '3' => 'อ',
        '4' => 'พ',
        '5' => 'พฤ',
        '6' => 'ศ',
        '7' => 'ส',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'อาทิตย์',
        '1' => 'จันทร์',
        '2' => 'อังคาร',
        '3' => 'พุธ',
        '4' => 'พฤหัส',
        '5' => 'ศุกร์',
        '6' => 'เสาร์',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'am',
        'pm' => 'pm',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => 'แถวและคอลัมน์',
        'summary' => 'ข้อมูลสรุป',
        'detailed_summary' => 'ข้อมูลสรุปที่มีรายละเอียด',
        'Matrix' => 'เมทริกซ์',
        ],


        'dom_email_types' => [
        'out' => 'ส่งแล้ว',
        'archived' => 'เก็บถาวร',
        'draft' => 'ร่าง',
        'inbound' => 'ขาเข้า',
        'campaign' => 'แคมเปญ',
        ],
        'dom_email_status' => [
        'archived' => 'เก็บถาวร',
        'closed' => 'ปิดแล้ว',
        'draft' => 'แบบร่าง',
        'read' => 'อ่านแล้ว',
        'replied' => 'ตอบกลับแล้ว',
        'sent' => 'ส่งแล้ว',
        'send_error' => 'ข้อผิดพลาดในการส่ง',
        'unread' => 'ยังไม่ได้อ่าน',
        ],
        'dom_email_archived_status' => [
        'archived' => 'เก็บถาวร',
        ],

        'dom_email_server_type' => ['' => '--ไม่มี--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--ไม่มี--',
        'createcase' => 'สร้างเคส',
        'bounce' => 'การจัดการอีเมลตีกลับ',
        ],
        'dom_email_distribution' => ['' => '--ไม่มี--',
        'direct' => 'ระบุโดยตรง',
        'roundRobin' => 'หมุนเวียน',
        'leastBusy' => 'ว่างที่สุด',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'หมุนเวียน',
        'leastBusy' => 'ว่างที่สุด',
        'none' => 'ไม่มี',
        ],
        'dom_email_errors' => [1 => 'เลือกผู้ใช้เพียงหนึ่งรายเมื่อระบุรายการโดยตรง',
        2 => 'คุณต้องระบุเฉพาะรายการที่เลือกเมื่อระบุรายการโดยตรง',
        ],
        'dom_email_bool' => ['bool_true' => 'ใช่',
        'bool_false' => 'ไม่',
        ],
        'dom_int_bool' => [1 => 'ใช่',
        0 => 'ไม่',
        ],
        'dom_switch_bool' => ['on' => 'ใช่',
        'off' => 'ไม่',
        '' => 'ไม่',],

        'dom_email_link_type' => ['sugar' => 'อีเมลไคลเอนต์ของ Sugar',
        'mailto' => 'อีเมลไคลเอนต์ภายนอก'],


        'dom_email_editor_option' => ['' => 'รูปแบบอีเมลเริ่มต้น',
        'html' => 'อีเมล HTML',
        'plain' => 'อีเมลข้อความล้วน'],

        'schedulers_times_dom' => ['not run' => 'เวลาทำงานผ่านไปแล้ว ไม่ได้เรียกใช้',
        'ready' => 'พร้อม',
        'in progress' => 'อยู่ระหว่างดำเนินการ',
        'failed' => 'ล้มเหลว',
        'completed' => 'เสร็จสมบูรณ์',
        'no curl' => 'ไม่ได้ทำงาน: ไม่มี cURL',
        ],

        'dom_email_states' => [
        'Draft' => 'ร่าง',
        'Archived' => 'เก็บถาวร',
        ],

        'dom_email_direction' => [
        'Unknown' => 'ไม่ทราบ',
        'Outbound' => 'ขาออก',
        'Inbound' => 'ขาเข้า',
        'Internal' => 'ภายใน',
        ],

        'scheduler_status_dom' => [
        'Active' => 'ใช้งาน',
        'Inactive' => 'ไม่ใช้งาน',
        ],

        'scheduler_period_dom' => [
        'min' => 'นาที',
        'hour' => 'ชั่วโมง',
        ],
        'forecast_type_dom' => [
        'Direct' => 'โดยตรง',
        'Rollup' => 'ทบยอด',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'การตลาด',
        'Knowledge Base' => 'ฐานความรู้',
        'Sales' => 'การขาย',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'สิ่งส่งเสริมทางการตลาด',
        'Product Brochures' => 'โบรชัวร์ผลิตภัณฑ์',
        'FAQ' => 'คำถามที่พบบ่อย',
        ],

        'document_status_dom' => [
        'Active' => 'ใช้งาน',
        'Draft' => 'ร่าง',
        'FAQ' => 'คำถามที่พบบ่อย',
        'Expired' => 'หมดอายุ',
        'Under Review' => 'อยู่ระหว่างตรวจทาน',
        'Pending' => 'รอดำเนินการ',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'จดหมายเวียน',
        'eula' => 'EULA',
        'nda' => 'NDA',
        'license' => 'ข้อตกลงการอนุญาตใช้งาน',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'ยอมรับ',
        'decline' => 'ปฏิเสธ',
        'tentative' => 'ไม่แน่นอน',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'ยอมรับแล้ว',
        'decline' => 'ปฏิเสธ',
        'tentative' => 'ไม่แน่นอน',
        'none' => 'ไม่มี',
        ],
        'dataset_output_default_dom' => [
        'table' => 'ตาราง',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'โมดูลเดียว',
        'Multi Module' => 'หลายโมดูล',
        ],
        'report_align_dom' => [
        'left' => 'ซ้าย',
        'center' => 'กึ่งกลาง',
        'right' => 'ขวา',
        ],

        'width_type_dom' => [
        '%' => 'เปอร์เซ็นต์ (%)',
        'px' => 'พิกเซล (px)',
        ],
        'report_color_dom' => [
        '' => 'ค่าเริ่มต้น',
        'black' => 'ดำ',
        'green' => 'เขียว',
        'blue' => 'น้ำเงิน',
        'red' => 'แดง',
        'white' => 'ขาว',
        'DarkGreen' => 'เขียวเข้ม',
        'LightGray' => 'เทาอ่อน',
        'DodgerBlue' => 'น้ำเงิน Dodger',
        'LightBlue' => 'ฟ้า',
        ],
        'font_size_dom' => [
        '-5' => 'เล็กลง (-5)',
        '-4' => 'เล็กลง (-4)',
        '-3' => 'เล็กลง (-3)',
        '-2' => 'เล็กลง (-2)',
        '-1' => 'เล็กลง (-1)',
        'Default' => 'ค่าเริ่มต้น',
        '1' => 'ใหญ่ขึ้น (+1)',
        '2' => 'ใหญ่ขึ้น (+2)',
        '3' => 'ใหญ่ขึ้น (+3)',
        '4' => 'ใหญ่ขึ้น (+4)',
        '5' => 'ใหญ่ขึ้น (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'การสืบค้นหลัก',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'แสดงผล',
//  'Group By' => 'Group By',
        'Calculation' => 'การคำนวณ',
        ],
        'query_display_type_dom' => [
        'Default' => 'ค่าเริ่มต้น',
        'Custom' => 'กำหนดเอง',
        'Hidden' => 'ซ่อน',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'วัน',
        'Week' => 'สัปดาห์',
        'Month' => 'เดือน',
        'Quarter' => 'ไตรมาส',
        'Year' => 'ปี',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'ปัจจุบัน',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'ผลรวม',
        'AVG' => 'AVG',
        'COUNT' => 'จำนวน',
        'STDDEV' => 'ค่าเบี่ยงเบนมาตรฐาน',
        'VARIANCE' => 'ส่วนต่าง',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'ฟิลด์มาตรฐาน',
        'Time' => 'ช่วงเวลา',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'แถว (แกน Y)',
        'Columns' => 'คอลัมน์ (แกน X)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'ผลรวม (รวม)',
        'AVG' => 'ค่าเฉลี่ย',
        'MAX' => 'สูงสุด',
        'MIN' => 'ต่ำสุด',
        'COUNT' => 'จำนวน',
        'STDDEV' => 'ค่าเบี่ยงเบนมาตรฐาน',
        'VARIANCE' => 'ส่วนต่าง',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'มาตรฐาน',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'การคำนวณทางคณิตศาสตร์',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'ฟิลด์',
        'Value' => 'ค่า',
        'Group' => 'กลุ่ม',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'คอลัมน์',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'ปิดใช้งาน',
        'Enabled' => 'เปิดใช้งาน',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'ปกติ',
        'Scalar' => 'สเกลาร์',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'ข้อความ',
        'Accounting' => 'บัญชี',
        'Date' => 'วันที่',
        'Datetime' => 'วันที่และเวลา',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'ปี',
        'Quarter' => 'ไตรมาส',
        'Month' => 'เดือน',
        'Week' => 'สัปดาห์',
        'Day' => 'วัน',
        ],
        'dataset_style_dom' => [
        'normal' => 'ปกติ',
        'bold' => 'ตัวหนา',
        'italic' => 'ตัวเอียง',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) บวก',
        '-' => '(-) ลบ',
        '*' => '(X) คูณด้วย',
        '/' => '(/) หารด้วย',
        ],
        'wflow_type_dom' => [
        'Normal' => 'เมื่อบันทึกระเบียน',
        'Time' => 'เมื่อเวลาผ่านไป',
        ],
        'mselect_type_dom' => [
        'Equals' => 'เป็น',
        'in' => 'เป็นหนึ่งใน',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'เป็นหนึ่งใน',
        'not_in' => 'ไม่ใช่หนึ่งใน',
        ],
        'cselect_type_dom' => [
        'Equals' => 'เท่ากับ',
        'Does not Equal' => 'ไม่เท่ากับ',
        ],
        'dselect_type_dom' => [
        'Equals' => 'เท่ากับ',
        'Less Than' => 'น้อยกว่า',
        'More Than' => 'มากกว่า',
        'Does not Equal' => 'ไม่เท่ากับ',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'ใช่',
        'bool_false' => 'ไม่',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'เท่ากับ',
        ],
        'tselect_type_dom' => [
        '0' => '0 ชั่วโมง',
        '14440' => '4 ชั่วโมง',
        '28800' => '8 ชั่วโมง',
        '43200' => '12 ชั่วโมง',
        '86400' => '1 วัน',
        '172800' => '2 วัน',
        '259200' => '3 วัน',
        '345600' => '4 วัน',
        '432000' => '5 วัน',
        '604800' => '1 สัปดาห์',
        '1209600' => '2 สัปดาห์',
        '1814400' => '3 สัปดาห์',
        '2592000' => '30 วัน',
        '5184000' => '60 วัน',
        '7776000' => '90 วัน',
        '10368000' => '120 วัน',
        '12960000' => '150 วัน',
        '15552000' => '180 วัน',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'มากกว่า',
        'Less Than' => 'น้อยกว่า',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'อีเมล',
        'Invite' => 'เชิญ',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'ข้อความปกติ',
        'Custom Template' => 'เทมเพลทแบบกำหนดเอง',
        'System Default' => 'ค่าเริ่มต้นของระบบ',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'ผู้ใช้ปัจจุบัน',
        'rel_user' => 'ผู้ใช้ที่เกี่ยวข้อง',
        'rel_user_custom' => 'ผู้ใช้ที่กำหนดเองที่เกี่ยวข้อง',
        'specific_team' => 'ทีมที่ระบุ',
        'specific_role' => 'บทบาทที่ระบุ',
        'specific_user' => 'ผู้ใช้ที่ระบุ',
        ],
        'wflow_array_type_dom' => [
        'future' => 'ค่าใหม่',
        'past' => 'ค่าเดิม',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'ผู้ใช้',
        'Manager' => "ผู้จัดการของผู้ใช้",
        ],
        'wflow_address_type_dom' => [
        'to' => 'ถึง:',
        'cc' => 'สำเนาถึง:',
        'bcc' => 'สำเนาลับถึง:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'ถึง:',
        'cc' => 'สำเนาถึง:',
        'bcc' => 'สำเนาลับถึง:',
        'invite_only' => '(เชิญเท่านั้น)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'ถึง:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'อัปเดตระเบียน',
        'update_rel' => 'อัปเดตระเบียนที่เกี่ยวข้อง',
        'new' => 'เรกคอร์ดใหม่',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'วันที่ทริกเกอร์',
        'Existing Value' => 'ค่าที่มีอยู่',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'ตัวเลือกพื้นฐาน',
        'Advanced' => 'ตัวเลือกขั้นสูง',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'ผู้ใช้ที่ระบุให้กับระเบียนที่ทริกเกอร์',
        'modified_user_id' => 'ผู้ใช้ที่แก้ไขระเบียนที่ทริกเกอร์ครั้งล่าสุด',
        'created_by' => 'ผู้ใช้ที่สร้างระเบียนที่ทริกเกอร์',
        'current_user' => 'ผู้ใช้ที่ล็อกอิน',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'ทีมปัจจุบันของระเบียนที่ทริกเกอร์',
        'team_set_id' => 'ชุดทีมปัจจุบันของระเบียนที่ทริกเกอร์',
        'current_team' => 'ทีมของผู้ใช้ที่ล็อกอิน',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'ย้ายดรอปดาวน์ไปด้านหลัง',
        'advance' => 'ย้ายดรอปดาวน์ไปด้านหน้า',
        ],
        'wflow_record_type_dom' => [
        'All' => 'ระเบียนใหม่และระเบียนที่อัปเดต',
        'New' => 'ระเบียนใหม่เท่านั้น',
        'Update' => 'ระเบียนที่อัปเดตเท่านั้น',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'ทั้งหมดที่เกี่ยวข้อง',
        //'first' => 'The first related',
        'filter' => 'กรองรายการที่เกี่ยวข้อง',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'ทั้งหมดที่เกี่ยวข้อง',
        'any' => 'รายการใดก็ได้ที่เกี่ยวข้อง',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'การเตือนตามด้วยการดำเนินการ',
        'actions_alerts' => 'การดำเนินการตามด้วยการเตือน'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'ไม่มี',
        'Daily' => 'รายวัน',
        'Weekly' => 'รายสัปดาห์',
        'Monthly' => 'รายเดือน',
        'Yearly' => 'รายปี',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'วัน',
        'Weekly' => 'สัปดาห์',
        'Monthly' => 'เดือน',
        'Yearly' => 'ปี',
        ],

        'repeat_end_types' => [
        'Until' => 'ถึง',
        'Occurrences' => 'ครั้ง',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'ไม่มี',
        'Each' => 'รายการละ',
        'On' => 'ใน',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'หนึ่ง',
        'second' => 'สอง',
        'third' => 'สาม',
        'fourth' => 'สี่',
        'fifth' => 'ห้า',
        'last' => 'สุดท้าย',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'วันอาทิตย์',
        'Mon' => 'วันจันทร์',
        'Tue' => 'วันอังคาร',
        'Wed' => 'วันพุธ',
        'Thu' => 'วันพฤหัสบดี',
        'Fri' => 'วันศุกร์',
        'Sat' => 'วันเสาร์',
        'Day' => 'วัน',
        'WD' => 'วันทำการ',
        'WE' => 'วันหยุดสุดสัปดาห์',
        ],

        'duration_dom' => [
        '' => 'ไม่มี',
        '900' => '15 นาที',
        '1800' => '30 นาที',
        '2700' => '45 นาที',
        '3600' => '1 ชั่วโมง',
        '5400' => '1.5 ชั่วโมง',
        '7200' => '2 ชั่วโมง',
        '10800' => '3 ชั่วโมง',
        '21600' => '6 ชั่วโมง',
        '86400' => '1 วัน',
        '172800' => '2 วัน',
        '259200' => '3 วัน',
        '604800' => '1 สัปดาห์',
        ],
        'repeat_month_dom' => [
        '1' => 'มกราคม',
        '2' => 'กุมภาพันธ์',
        '3' => 'มีนาคม',
        '4' => 'เมษายน',
        '5' => 'พฤษภาคม',
        '6' => 'มิถุนายน',
        '7' => 'กรกฎาคม',
        '8' => 'สิงหาคม',
        '9' => 'กันยายน',
        '10' => 'ตุลาคม',
        '11' => 'พฤศจิกายน',
        '12' => 'ธันวาคม',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'ค่าเริ่มต้น',
        'seed' => 'ตัวเลือกขั้นต้น',
        'exempt_domain' => 'รายการระงับ - แยกตามโดเมน',
        'exempt_address' => 'รายการระงับ - แยกตามที่อยู่อีเมล',
        'exempt' => 'รายการระงับ - แยกตาม ID',
        'test' => 'การทดสอบ',
        ],
        'currency_status_dom' => [
        'Active' => 'ใช้งาน',
        'Inactive' => 'ไม่ใช้งาน',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'ใช้งาน',
        'inactive' => 'ไม่ใช้งาน',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'ส่ง/พยายามส่งข้อความแล้ว',
        'send error' => 'ข้อความตีกลับ, อื่นๆ',
        'invalid email' => 'ข้อความตีกลับ, อีเมลไม่ถูกต้อง',
        'link' => 'ลิงก์แบบคลิกผ่าน',
        'viewed' => 'ข้อความที่ดู',
        'removed' => 'เลือกออก',
        'lead' => 'สร้างผู้สนใจแล้ว',
        'contact' => 'สร้างที่อยู่ติดต่อแล้ว',
        'blocked' => 'ระงับไว้ตามที่อยู่หรือโดเมน',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'ที่อยู่ติดต่อ',
        'Users' => 'ผู้ใช้',
        'Prospects' => 'เป้าหมาย',
        'Leads' => 'ผู้สนใจ',
        'Accounts' => 'บัญชี',
        ],
        'merge_operators_dom' => [
        'like' => 'ประกอบด้วย',
        'exact' => 'ตรงกัน',
        'start' => 'เริ่มต้นด้วย',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'ใช่',
        'false' => 'ไม่',
        'required' => 'ต้องระบุ',
        ],

        'fts_field_config' => [
        '0' => 'ปิดใช้งาน',
        '2' => 'ค้นหาได้',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'ปิดใช้งาน',
        1 => 'เปิดใช้งาน',
        2 => 'ในตัวกรอง',
        3 => 'ตัวกรองที่เลือกเป็นค่าเริ่มต้น',
        4 => 'ตัวกรองเท่านั้น',
        ],

        'navigation_paradigms' => [
        'm' => 'โมดูล',
        'gm' => 'โมดูลที่จัดกลุ่ม',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'ยังไม่เริ่มต้น',
        'inprogress' => 'อยู่ระหว่างดำเนินการ',
        'signed' => 'ลงชื่อแล้ว',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'รายเดือน',
        'quarterly' => 'รายไตรมาส',
        'halfyearly' => 'รายครึ่งปี',
        'yearly' => 'รายปี',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 วัน',
        '3' => '3 วัน',
        '5' => '5 วัน',
        '7' => '1 สัปดาห์',
        '14' => '2 สัปดาห์',
        '21' => '3 สัปดาห์',
        '31' => '1 เดือน',
        ],
        'projects_priority_options' => [
        'high' => 'สูง',
        'medium' => 'ปานกลาง',
        'low' => 'ต่ำ',
        ],

        'projects_status_options' => [
        'notstarted' => 'ยังไม่เริ่มต้น',
        'inprogress' => 'อยู่ระหว่างดำเนินการ',
        'completed' => 'เสร็จสมบูรณ์',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'ขยายคำอธิบาย',
        'collapselegend' => 'ยุบคำอธิบาย',
        'clickfordrilldown' => 'คลิกเพื่อดูรายละเอียด',
        'drilldownoptions' => 'ตัวเลือกดูรายละเอียด',
        'detailview' => 'รายละเอียดเพิ่มเติม...',
        'piechart' => 'แผนภูมิวงกลม',
        'groupchart' => 'แผนภูมิกลุ่ม',
        'stackedchart' => 'แผนภูมิแบบเรียงซ้อน',
        'barchart' => 'แผนภูมิแท่ง',
        'horizontalbarchart' => 'แผนภูมิแท่งแนวนอน',
        'linechart' => 'แผนภูมิเส้น',
        'noData' => 'ไม่มีข้อมูล',
        'print' => 'พิมพ์',
        'pieWedgeName' => 'ส่วน',
        ],
        'chart_types' => [
        'hBarF' => 'แถบแนวนอน (ซ้อนทับ)',
        'hGBarF' => 'แถบแนวนอน (จับกลุ่ม)',
        'vBarF' => 'แถบแนวตั้ง (ซ้อนทับ)',
        'vGBarF' => 'แถบแนวตั้ง (จับกลุ่ม)',
        'pieF' => 'วงกลม',
        'funnelF' => 'กรวย',
        'lineF' => 'เส้น',
        'donutF' => 'แผนภูมิโดนัท',
        'treemapF' => 'แผนภูมิทรีแมป',
        ],
        'd3_value_placement' => [
        '0' => 'ไม่มี',
        '1' => 'ค่าเริ่มต้น',
        'start' => 'เริ่มต้น',
        'middle' => 'กลาง',
        'end' => 'สิ้นสุด',
        'top' => 'บน',
        'total' => 'รวม',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'กรวย',
        'hbar' => 'แท่งแนวนอน',
        ],
        'release_status_dom' => [
        'Active' => 'ใช้งาน',
        'Inactive' => 'ไม่ใช้งาน',
        ],
        'email_settings_for_ssl' => [
        '0' => 'ไม่มี',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'แลกเปลี่ยนออนไลน์',
        'outlook' => 'Outlook',
        'google' => 'แอปที่มีความปลอดภัยน้อยกว่าใน Google',
        'exchange' => 'Exchange',
        'other' => 'อื่นๆ',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'อีเมล Google',
        'exchange_online' => 'แลกเปลี่ยนออนไลน์',
        'other' => 'อื่น ๆ',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'เครื่องหมายคำพูดเดี่ยว (&#39;)',
        '"' => 'เครื่องหมายคำพูด (")',
        '' => 'ไม่มี',
        'other' => 'อื่นๆ:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'อื่นๆ:',
        ],
        'link_target_dom' => [
        '_blank' => 'หน้าต่างใหม่',
        '_self' => 'หน้าต่างเดียวกัน',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'ไม่รีเฟรชอัตโนมัติ',
        '30' => 'ทุก 30 วินาที',
        '60' => 'ทุก 1 นาที',
        '180' => 'ทุก 3 นาที',
        '300' => 'ทุก 5 นาที',
        '600' => 'ทุก 10 นาที',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'ไม่มี',
        '15' => 'ทุก 15 นาที',
        '30' => 'ทุก 30 นาที',
        '45' => 'ทุก 45 นาที',
        '60' => 'ทุกชั่วโมง',
        '120' => 'ทุก 2 ชั่วโมง',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'ไม่มี',
        '30' => 'ทุก 30 วินาที',
        '60' => 'ทุก 1 นาที',
        '180' => 'ทุก 3 นาที',
        '300' => 'ทุก 5 นาที',
        '600' => 'ทุก 10 นาที',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'ไม่มี',
        '1' => 'ทุก 1 นาที',
        '5' => 'ทุก 5 นาที',
        '10' => 'ทุก 10 นาที',
        '15' => 'ทุก 15 นาที',
        '30' => 'ทุก 30 นาที',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'เท่ากับ',
        'not_equal' => 'ไม่อยู่ใน',
        'greater_than' => 'หลัง',
        'less_than' => 'ก่อน',
        'last_7_days' => '7 วันที่ผ่านมา',
        'next_7_days' => '7 วันถัดไป',
        'last_30_days' => '30 วันที่ผ่านมา',
        'next_30_days' => '30 วันถัดไป',
        'last_month' => 'เดือนล่าสุด',
        'this_month' => 'เดือนนี้',
        'next_month' => 'เดือนถัดไป',
        'last_year' => 'ปีล่าสุด',
        'this_year' => 'ปีนี้',
        'next_year' => 'ปีถัดไป',
        'between' => 'อยู่ระหว่าง',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'ปีล่าสุด',
        'last_month' => 'เดือนล่าสุด',
        'last_30_days' => '30 วันที่ผ่านมา',
        'last_7_days' => '7 วันที่ผ่านมา',
        'this_month' => 'เดือนนี้',
        'this_year' => 'ปีนี้',
        'next_7_days' => '7 วันถัดไป',
        'next_30_days' => '30 วันถัดไป',
        'next_month' => 'เดือนถัดไป',
        'next_year' => 'ปีถัดไป',
        ],
        'numeric_range_search_dom' => [
        '=' => 'เท่ากับ',
        'not_equal' => 'ไม่เท่ากับ',
        'greater_than' => 'มากกว่า',
        'greater_than_equals' => 'มากกว่าหรือเท่ากับ',
        'less_than' => 'น้อยกว่า',
        'less_than_equals' => 'น้อยกว่าหรือเท่ากับ',
        'between' => 'อยู่ระหว่าง',
        ],

        'filter_checkbox_dom' => [
        0 => 'เท็จ',
        1 => 'จริง',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'ได้รับการขาย',
        'lost' => 'ไม่สำเร็จ',
        'active' => 'ใช้งาน',
        ],

        'sweetspot_theme_options' => [
        'default' => 'ค่าเริ่มต้น',
        'light' => 'อ่อน',
        'dark' => 'เข้ม',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'ย้าย',
        'donothing' => 'ไม่ต้องดำเนินการ',
        ],
        'processes_auto_save_interval' => [
        0 => 'ไม่บันทึกเลย',
        30000 => 'ทุก 30 วินาที',
        60000 => 'ทุก 1 นาที',
        120000 => 'ทุก 2 นาที',
        180000 => 'ทุก 3 นาที',
        240000 => 'ทุก 4 นาที',
        300000 => 'ทุก 5 นาที',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'ใช่',
        'No' => 'ไม่',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'ในประมาณการ',
        'sales_stage' => 'ขั้นตอนการขาย',
        'probability' => 'ความน่าจะเป็น',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'เป็นไปได้',
        'best' => 'ดีที่สุด',
        'worst' => 'แย่ที่สุด',
        ],
        'webLogicHookList' => [
        'after_save' => 'หลังจากบันทึก',
        'after_delete' => 'หลังจากลบ',
        'after_relationship_add' => 'หลังจากเพิ่มความสัมพันธ์',
        'after_relationship_delete' => 'หลังจากลบความสัมพันธ์',
        'after_login' => 'หลังจากล็อกอิน',
        'after_logout' => 'หลังจากล็อกเอาต์',
        'after_login_failed' => 'หลังจากล็อกอินไม่สำเร็จ',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'เปิดใช้งาน',
        'INACTIVE' => 'ปิดใช้งาน',
        ],
        'dashboard_view_name_list' => [
        'record' => 'ระเบียน',
        'records' => 'รายการ',
        'activities' => 'สตรีมกิจกรรม',
        'multi-line' => 'รายการแบบหลายบรรทัด',
        'omnichannel' => 'ช่องทางการตลาดแบบบูรณาการ',
        'home' => 'Home',
        'focus' => 'ระบบลิ้นชัก',
        ],
        'metric_context_list' => [
        'service_console' => 'คอนโซลบริการ',
        'renewals_console' => 'ต่ออายุคอนโซล',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'รายชั่วโมง',
        '21600' => 'ทุก 6 ชั่วโมง',
        '43200' => 'ทุก 12 ชั่วโมง',
        '86400' => 'รายวัน',
        '604800' => 'รายสัปดาห์',
        '1209600' => 'ทุก 2 สัปดาห์',
        '2419200' => 'ทุก 4 สัปดาห์',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'ปี',
        'month' => 'เดือน',
        'day' => 'วัน',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'หมดเวลา',
        'event' => 'เหตุการณ์',
        'other' => 'อื่น ๆ',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'วันที่ (วันสุดท้าย {{module}})',
        'start_date:asc' => 'วันที่ (วันแรก {{module}})',
        'total_revenue:desc' => 'ราคา (ยอดรวมสูงสุด)',
        'total_revenue:asc' => 'ราคา (ยอดรวมต่ำสุด)',
        ],
        'calendar_type_list' => [
        'main' => 'ศูนย์กลางปฏิทิน',
        ],
        'calendar_views_options' => [
        'day' => 'วัน',
        'week' => 'สัปดาห์',
        'workWeek' => 'สัปดาห์ทำงาน',
        'expandedMonth' => 'เดือน',
        'agenda' => 'กำหนดวาระ',
        'timeline' => 'ไทม์ไลน์',
        'monthSchedule' => 'เครื่องมือวางกำหนดการ',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'สร้างแล้ว',
        'completed' => 'สมบูรณ์แล้ว',
        'declined' => 'ปฏิเสธแล้ว',
        'delivered' => 'ส่งมอบแล้ว',
        'sent' => 'ส่งแล้ว',
        'signed' => 'เซ็นแล้ว',
        'voided' => 'เป็นโมฆะแล้ว',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'แสดงรายการผู้รับที่มีศักยภาพ',
        'dont_show' => 'ไม่แสดงผู้รับที่มีศักยภาพ',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'ผู้ลงนาม',
        'carbon_copy' => 'ผู้ชม (สำเนาคาร์บอน)',
        'certified_delivery' => 'ผู้ชม (การส่งมอบที่ได้รับการยืนยัน)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'ค่าเริ่มต้น',
        'color' => 'สี',
        'image' => 'รูปภาพ',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'อักษรย่อ',
        'icon' => 'ไอคอน',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'ลูกศรลง',
        'sicon-chevron-left' => 'ทิศทางซ้าย',
        'sicon-check' => 'เครื่องหมายถูก',
        'sicon-clock' => 'นาฬิกา',
        'sicon-dashboard-default' => 'ค่าเริ่มต้นของแดชบอร์ด',
        'sicon-dashboard' => 'แดชบอร์ด',
        'sicon-edit' => 'แก้ไข',
        'sicon-caret-down' => 'คาเร็ตชี้ลง',
        'sicon-folder' => 'โฟลเดอร์',
        'sicon-info' => 'ข้อมูล',
        'sicon-kebab' => 'สามจุด',
        'sicon-link' => 'ลิงก์',
        'sicon-list' => 'รายการ',
        'sicon-logout' => 'ล็อกเอาต์',
        'sicon-minus' => 'ลบ',
        'sicon-folder-open' => 'โฟลด์เดอร์ที่เปิด',
        'sicon-plus-sm' => 'บวก Sm',
        'sicon-refresh' => 'รีเฟรช',
        'sicon-plus' => 'บวก',
        'sicon-settings' => 'การตั้งค่า',
        'sicon-arrow-right-double' => 'ลูกศรขวาคู่',
        'sicon-reports' => 'รายงาน',
        'sicon-user' => 'ผู้ใช้',
        'sicon-upload' => 'อัปโหลด',
        'sicon-user-group' => 'กลุ่มผู้ใช้',
        'sicon-arrow-left-double' => 'ลูกศรซ้ายคู่',
        'sicon-chevron-up' => 'เชฟรอนขึ้น',
        'sicon-caret-up' => 'คาเร็ตขึ้น',
        'sicon-star-fill' => 'ดาวทึบ',
        'sicon-download' => 'ดาวน์โหลด',
        'sicon-close' => 'ปิด',
        'sicon-tile-view' => 'มุมมองแบบแผ่นป้าย',
        'sicon-list-view' => 'มุมมองรายการ',
        'sicon-thumbs-down' => 'นิ้วโป้งชี้ลง',
        'sicon-warning-circle' => 'วงกลมเตือน',
        'sicon-phone' => 'โทรศัพท์',
        'sicon-email' => 'อีเมล',
        'sicon-document' => 'เอกสาร',
        'sicon-note' => 'หมายเหตุ',
        'sicon-preview' => 'ดูตัวอย่าง',
        'sicon-copy' => 'คัดลอก',
        'sicon-launch' => 'เปิด',
        'sicon-lock' => 'ล็อก',
        'sicon-arrow-top-right' => 'ลูกศรขวาบน',
        'sicon-full-screen' => 'เต็มหน้าจอ',
        'sicon-full-screen-exit' => 'ออกจากโหมดเต็มหน้าจอ',
        'sicon-expand-left' => 'ขยายไปทางซ้าย',
        'sicon-expand-right' => 'ขยายไปทางขวา',
        'sicon-focus-drawer' => 'ลิ้นชักโฟกัส',
        'sicon-ban' => 'ปิดกั้น',
        'sicon-thumbs-up' => 'นิ้วโป้งชี้ขี้น',
        'sicon-search' => 'ค้นหา',
        'sicon-calendar' => 'ปฏิทิน',
        'sicon-calendar-lg' => 'ปฏิทิน Lg',
        'sicon-mobile-lg' => 'มือถือ Lg',
        'sicon-star-fill-lg' => 'ดาวทึบ Lg',
        'sicon-star-outline-lg' => 'ดาวโปร่ง Lg',
        'sicon-reset-lg' => 'รีเซ็ต Lg',
        'sicon-exchange-lg' => 'แลกเปลี่ยน Lg',
        'sicon-help-lg' => 'ช่วยเหลือ Lg',
        'sicon-close-lg' => 'ปิด Lg',
        'sicon-plus-lg' => 'บวก Lg',
        'sicon-shortcuts-lg' => 'ทางลัด Lg',
        'sicon-search-lg' => 'ค้นหา Lg',
        'sicon-email-lg' => 'อีเมล Lg',
        'sicon-note-lg' => 'หมายเหตุ Lg',
        'sicon-document-lg' => 'เอกสาร Lg',
        'sicon-add-dashlet-lg' => 'เพิ่มส่วนข้อมูล Lg',
        'sicon-collapse-lg' => 'ยุบ Lg',
        'sicon-hamburger-lg' => 'แฮมเบอร์เกอร์ Lg',
        'sicon-pin-fill-lg' => 'เติมรหัสพิน Lg',
        'sicon-expand-lg' => 'ขยาย Lg',
        'sicon-copy-lg' => 'คัดลอก Lg',
        'sicon-dashboard-lg' => 'แดชบอร์ด Lg',
        'sicon-star-outline' => 'ดาวโปร่ง',
        'sicon-reset' => 'รีเซ็ต',
        'sicon-unlink' => 'เลิกเชื่อมโยง',
        'sicon-phone-lg' => 'โทรศัพท์ Lg',
        'sicon-attach' => 'แนบ',
        'sicon-case-lg' => 'เคส Lg',
        'sicon-arrow-right-lg' => 'ลูกศรขวา Lg',
        'sicon-check-circle-lg' => 'เครื่องหมายถูกวงกลม Lg',
        'sicon-text-formatting' => 'การจัดรูปแบบข้อความ',
        'sicon-check-circle' => 'เครื่องหมายถูกวงกลม',
        'sicon-upload-lg' => 'อัปโหลด Lg',
        'sicon-flag-lg' => 'ธง Lg',
        'sicon-studio-lg' => 'สตูดิโอ Lg',
        'sicon-contact-lg' => 'ติดต่อ Lg',
        'sicon-edit-lg' => 'แก้ไข Lg',
        'sicon-arrow-left' => 'ลูกศรซ้าย',
        'sicon-reply-all' => 'ตอบกลับทั้งหมด',
        'sicon-message-lg' => 'ข้อความ Lg',
        'sicon-info-lg' => 'ข้อมูล Lg',
        'sicon-error-lg' => 'ข้อผิดพลาด Lg',
        'sicon-check-circle-line-lg' => 'ขีดเครื่องหมายถูกวงกลม Lg',
        'sicon-warning-line-lg' => 'เส้นเตือน Lg',
        'sicon-arrow-up' => 'ลูกศรขึ้น',
        'sicon-arrow-right' => 'ลูกศรขวา',
        'sicon-nodes' => 'โหนด',
        'sicon-hide' => 'ซ่อน',
        'sicon-help' => 'ความช่วยเหลือ',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'ข้อความ',
        'sicon-sugar-predict-lg' => 'Sugar Predict Lg',
        'sicon-sugar-predict' => 'Sugar Predict',
        'sicon-opportunity-lg' => 'โอกาสทางการขาย Lg',
        'sicon-lead-lg' => 'ผู้สนใจ Lg',
        'sicon-account-lg' => 'บัญชี Lg',
        'sicon-user-sm' => 'ผู้ใช้ Sm',
        'sicon-quote-lg' => 'การเสนอราคา Lg',
        'sicon-equal' => 'เท่ากับ',
        'sicon-slicers-xl' => 'ตัวแบ่งส่วนข้อมูล XI',
        'sicon-escalation-lg' => 'การเพิ่มขึ้น Lg',
        'sicon-add-circle-lg' => 'ใส่วงกลม Lg',
        'sicon-add-line-lg' => 'ใส่เส้น Lg',
        'sicon-add-target-lg' => 'ใส่เป้าหมาย Lg',
        'sicon-help-circle-lg' => 'วงกลมช่วยเหลือ Lg',
        'sicon-divide-line-lg' => 'เส้นแบ่ง Lg',
        'sicon-string' => 'แถว',
        'sicon-filter' => 'ตัวกรอง',
        'sicon-number' => 'เลขที่',
        'sicon-format-lg' => 'รูปแบบ Lg',
        'sicon-insights-lg' => 'Insights Lg',
        'sicon-invalid-circle-lg' => 'วงกลมไม่ถูกต้อง Lg',
        'sicon-layout-xl' => 'เค้าโครง Xl',
        'sicon-layout-lg' => 'เค้าโครง Xl',
        'sicon-multiply-line-lg' => 'เส้นคูณ Lg',
        'sicon-redo-lg' => 'ทำซ้ำ Lg',
        'sicon-refresh-lg' => 'รีเฟรช Lg',
        'sicon-undo-lg' => 'ทำซ้ำ Lg',
        'sicon-activity-feed-xl' => 'ฟีดกิจกรรม Xl',
        'sicon-chevron-left-xl' => 'ทิศทางซ้าย Xl',
        'sicon-close-xl' => 'ปิด Xl',
        'sicon-kebab-lg' => 'สามจุด Lg',
        'sicon-insights-xl' => 'Insights Xl',
        'sicon-hide-lg' => 'ซ่อน Lg',
        'sicon-kebab-xl' => 'สามจุด Xl',
        'sicon-comment-xl' => 'ความคิดเห็น Xl',
        'sicon-share-lg' => 'แชร์ Lg',
        'sicon-trash' => 'ขยะ',
        'sicon-launch-lg' => 'เปิด Lg',
        'sicon-thumbs-up-lg' => 'นิ้วโป้งชี้ขี้น Lg',
        'sicon-thumbs-down-lg' => 'นิ้วโป้งชี้ลง Lg',
        'sicon-warning-lg' => 'คำเตือน Lg',
        'sicon-wizard-circle-xl' => 'วิซาร์ดวงกลม Xl',
        'sicon-bell-cross-lg' => 'กระดิ่งขีดไขว้ Lg',
        'sicon-bell-lg' => 'กระดิ่ง Lg',
        'sicon-daily-lg' => 'รายวัน Lg',
        'sicon-cloud-download-lg' => 'ดาวโหลดคลาวด์ Lg',
        'sicon-unlock' => 'ปลดล็อก',
        'sicon-news-lg' => 'ข่าว Lg',
        'sicon-weekly-lg' => 'รายสัปดาห์ Lg',
        'sicon-knowledgebase-xl' => 'ฐานความรู้ Xl',
        'sicon-remove' => 'นำออก',
        'sicon-chevron-down' => 'เชฟรอนลง',
        'sicon-slicers-lg' => 'ตัวแบ่งส่วนข้อมูล Lg',
        'sicon-save-lg' => 'บันทึก Lg',
        'sicon-info-circle-lg' => 'วงกลมข้อมูล Lg',
        'sicon-chevron-right' => 'เชฟรอนขวา',
        'sicon-warning-circle-lg' => 'วงกลมเตือน Lg',
        'sicon-right-paren-line-lg' => 'สายพาเรนขวา Lg',
        'sicon-comment-lg' => 'ความคิดเห็น Lg',
        'sicon-target-lg' => 'เป้าหมาย Lg',
        'sicon-subtract-line-lg' => 'ลบเส้น Lg',
        'sicon-settings-lg' => 'การตั้งค่า Lg',
        'sicon-left-paren-line-lg' => 'สายพาเรนซ้าย Lg',
        'sicon-preview-lg' => 'ดูตัวอย่าง Lg',
        'sicon-thumbs-down-line-lg' => 'เส้นนิ้วโป้งชี้ลง Lg',
        'sicon-thumbs-up-line-lg' => 'เส้นนิ้วโป้งชี้ขึ้น Lg',
        'sicon-send-lg' => 'ส่ง Lg',
        'sicon-contact-xl' => 'ติดต่อ Xl',
        'sicon-wizard-circle-line-xl' => 'เส้นวิซาร์ดวงกลม Xl',
        'sicon-trash-lg' => 'ขยะ Lg',
        'sicon-pin-lg' => 'พิน Lg',
        'sicon-clock-lg' => 'นาฬิกา Lg',
        'sicon-comment-line-xl' => 'บรรทัดความคิดเห็น XI',
        'sicon-dropdown-editor' => 'เครื่องมือแก้ไขดรอปดาวน์',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'บัก',
        'sicon-catalog' => 'บัญชีรายชื่อ',
        'sicon-cloud' => 'คลาวด์',
        'sicon-config-api' => 'กำหนดค่า Api',
        'sicon-config-nav' => 'กำหนดค่า Nav',
        'sicon-connectors' => 'เครื่องมือเชื่อมต่อ',
        'sicon-contracts' => 'สัญญา',
        'sicon-currencies' => 'สกุลเงิน',
        'sicon-diagnostics' => 'การวินิจฉัย',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'แคมเปญทางอีเมล',
        'sicon-email-inbound' => 'อีเมลขาเข้า',
        'sicon-email-queue' => 'คิวอีเมล',
        'sicon-forecasts' => 'ประมาณการ',
        'sicon-display-modules' => 'แสดงโมดูล',
        'sicon-email-contacts' => 'ที่อยู่ติดต่อทางอีเมล',
        'sicon-import' => 'นำเข้า',
        'sicon-log-viewer' => 'เครื่องมือดูบันทึก',
        'sicon-lab' => 'พื้นที่ทดลอง',
        'sicon-map-pin' => 'จุดแผนที่',
        'sicon-manufacturers' => 'ผู้ผลิต',
        'sicon-update' => 'อัปเดต',
        'sicon-content-security' => 'ความปลอดภัยของเนื้อหา',
        'sicon-module-builder' => 'เครื่องมือสร้างโมดูล',
        'sicon-languages' => 'ภาษา',
        'sicon-module-loader' => 'เครื่องมือโหลดโมดูล',
        'sicon-oauth-key' => 'คีย์ Oauth',
        'sicon-password-mgmt' => 'รหัสผ่านฝ่ายบริหาร',
        'sicon-opportunities' => 'โอกาสทางการขาย',
        'sicon-upgrade' => 'อัปเกรด',
        'sicon-portal' => 'พอร์ทัล',
        'sicon-product-types' => 'ประเภทผลิตภัณฑ์',
        'sicon-quotes' => 'การเสนอราคา',
        'sicon-relate-fields' => 'ฟิลด์ที่เกี่ยวข้อง',
        'sicon-repair' => 'ซ่อมแซม',
        'sicon-role-mgmt' => 'บทบาทการบริหาร',
        'sicon-scheduler' => 'เครื่องมือวางกำหนดการ',
        'sicon-shippers' => 'ผู้ส่งสินค้า',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'เว็บ ลอจิค',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'อัตราภาษี',
        'sicon-team-mgmt' => 'ทีมบริหาร',
        'sicon-team-perm' => 'ทีม Perm',
        'sicon-tracker' => 'เครื่องมือติดตาม',
        'sicon-workflow' => 'เวิร์กโฟลว์',
        'sicon-mask' => 'หน้ากาก',
        'sicon-mask-disabled' => 'ปิดหน้ากาก',
        'sicon-email-archive' => 'เก็บอีเมลถาวร',
        'sicon-mobile' => 'โทรศัพท์มือถือ',
        'sicon-archive' => 'เก็บถาวร',
        'sicon-automate-scroll' => 'มุมมองแบบเลื่อนแนวตั้ง',
        'sicon-automate-stacked' => 'มุมมองแบบเลื่อนแนวนอน',
        'sicon-pdf-manager' => 'เครื่องมือจัดการ Pdf',
        'sicon-my-sites' => 'ไซต์ของฉัน',
        'sicon-cloud-insights' => 'คลาวด์ Insights',
        'sicon-sugar-logo-24' => 'โลโก้ Sugar 24',
        'sicon-sugar-logo-16' => 'โลโก้ Sugar 16',
        'sicon-task-lg' => 'งาน Lg',
        'sicon-web-lg' => 'เว็บ Lg',
        'sicon-events-lg' => 'กิจกรรม Lg',
        'sicon-sugar-logo-12' => 'โลโก้ Sugar 12',
        'sicon-tag' => 'แท็ก',
        'sicon-tag-lg' => 'แท็ก Lg',
        'sicon-bell-lg-line' => 'กระดิ่ง Lg สาย',
        'sicon-matrix-xxl' => 'เมทริกซ์ Xxl',
        'sicon-advanced-filter' => 'ตัวกรองขั้นสูง',
        'sicon-rows-and-columns-xxl' => 'แถวและคอลัมน์ Xxl',
        'sicon-summation-details-xxl' => 'รายละเอียดผลรวม Xxl',
        'sicon-summation-xxl' => 'ผลรวม Xxl',
        'sicon-lock-lg' => 'ล็อก Lg',
        'sicon-csv-file-xxl' => 'ไฟล์ csv Xxl',
        'sicon-logo-linkedin' => 'โลโก้ Linkedin',
        'sicon-briefcase' => 'กระเป๋าเอกสาร',
        'sicon-car-front' => 'หน้ารถ',
        'sicon-airplane' => 'เครื่องบิน',
        'sicon-laptop' => 'แล็ปท็อป',
        'sicon-logo-instagram' => 'โลโก้ Instagram',
        'sicon-single-bed' => 'เตียงเดี่ยว',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'โลโก้ Snapchat',
        'sicon-video-lg' => 'วิดีโอ Lg',
        'sicon-reply' => 'ตอบกลับ',
        'sicon-subtract' => 'หักออก',
        'sicon-arrow-up-circle-line' => 'วงกลมลูกศรชี้ขึ้น',
        'sicon-asterisk' => 'ดอกจัน',
        'sicon-dot-circle-o-lg' => 'วงกลมจุด O Lg',
        'sicon-forward' => 'ส่งต่อ',
        'sicon-video' => 'วิดีโอ',
        'sicon-gavel' => 'ค้อน',
        'sicon-login' => 'ล็อกอิน',
        'sicon-pdf-file-xxl' => 'ไฟล์ Pdf Xxl',
        'sicon-login-lg' => 'ล็อกอิน Lg',
        'sicon-cloud-download-xl' => 'ดาวโหลดคลาวด์ Xl',
        'sicon-campaigns-lg' => 'แคมเปญ Lg',
        'sicon-customer-journey-stages-lg' => 'ขั้นตอนเส้นทางลูกค้า Lg',
        'sicon-role-mgmt-lg' => 'บทบาทการบริหาร Lg',
        'sicon-default-module-lg' => 'โมดูลค่าเริ่มต้น Lg',
        'sicon-quoted-line-items-lg' => 'รายการบรรทัดการเสนอราคา Lg',
        'sicon-projects-lg' => 'โครงการ Lg',
        'sicon-process-business-rules-lg' => 'กฎทางธุรกิจของกระบวนการ Lg',
        'sicon-process-email-templates-lg' => 'เทมเพลทอีเมลของกระบวนการ Lg',
        'sicon-processes-lg' => 'กระบวนการ Lg',
        'sicon-process-definitions-lg' => 'การกำหนดกระบวนการ Lg',
        'sicon-target-lists-lg' => 'รายการเป้าหมาย Lg',
        'sicon-purchased-line-items-lg' => 'ซื้อสินค้าในไลน์ Lg',
        'sicon-user-group-lg' => 'กลุ่มผู้ใช้ Lg',
        'sicon-revenue-line-items-lg' => 'รายการบรรทัดรายได้ Lg',
        'sicon-business-centers-lg' => 'ศูนย์บริการธุรกิจ Lg',
        'sicon-logo-fb-simple' => 'โลโก้ Fb เรียบง่าย',
        'sicon-forecasts-lg' => 'การคาดการณ์ Lg',
        'sicon-contracts-lg' => 'สัญญา Lg',
        'sicon-purchase-lg' => 'จัดซื้อ Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'เส้นทางลูกค้า Lg',
        'sicon-data-privacy-lg' => 'การคุ้มครองข้อมูลส่วนบุคคล Lg',
        'sicon-home-lg' => 'หน้าหลัก Lg',
        'sicon-data-table' => 'ตารางข้อมูล',
        'sicon-medical-clipboard-lg' => 'คลิปบอร์ดทางการแพทย์ Lg',
        'sicon-privacy-lg' => 'ความเป็นส่วนตัว Lg',
        'sicon-marketplace' => 'ตลาดแลกเปลี่ยน',
        'sicon-marketplace-lg' => 'ตลาดแลกเปลี่ยน Lg',
        'sicon-blockquote-lg' => 'บล็อกโควต Lg',
        'sicon-casino-lg' => 'คาสิโน Lg',
        'sicon-jacuzzi-lg' => 'จากุซซี่ Lg',
        'sicon-scissors-lg' => 'กรรไกร Lg',
        'sicon-storage-lg' => 'การจัดเก็บ Lg',
        'sicon-fan-lg' => 'พัดลม Lg',
        'sicon-medicine-lg' => 'ยา Lg',
        'sicon-plant-lg' => 'พืช Lg',
        'sicon-telescope-lg' => 'กล้องโทรทรรศน์ Lg',
        'sicon-smart-phone-lg' => 'สมาร์ทโฟน Lg',
        'sicon-coffee-lg' => 'กาแฟ Lg',
        'sicon-martini-lg' => 'มาร์ตินี่ Lg',
        'sicon-cocktail-lg' => 'ค็อกเทล Lg',
        'sicon-stadium-lg' => 'สเตเดียม Lg',
        'sicon-fire-lg' => 'ไฟ Lg',
        'sicon-window-lg' => 'หน้าต่าง Lg',
        'sicon-lotus-lg' => 'ดอกบัว Lg',
        'sicon-windmill-lg' => 'กังหันลม Lg',
        'sicon-spades-lg' => 'ไพ่สแปดส์ Lg',
        'sicon-hearts-lg' => 'หัวใจ Lg',
        'sicon-diamonds-lg' => 'เพชร Lg',
        'sicon-clubs-lg' => 'คลับ Lg',
        'sicon-skull-lg' => 'กะโหลก Lg',
        'sicon-send' => 'ส่ง',
        'sicon-world-lg' => 'โลก Lg',
        'sicon-airplane-lg' => 'เครื่องบิน Lg',
        'sicon-planet-lg' => 'ดาวเคราะห์ Lg',
        'sicon-trainer-lg' => 'เทรนเนอร์ Lg',
        'sicon-calculator-lg' => 'เครื่องคิดเลข Lg',
        'sicon-tv-lg' => 'TV Lg',
        'sicon-video-player-lg' => 'เครื่องเล่นวีดีโอ Lg',
        'sicon-media-player-lg' => 'เครื่องเล่นสื่อ Lg',
        'sicon-decentralize-lg' => 'กระจายอํานาจ Lg',
        'sicon-statistics-lg' => 'สถิติ Lg',
        'sicon-virus-lg' => 'ไวรัส Lg',
        'sicon-shield-lg' => 'โล่ Lg',
        'sicon-plug-lg' => 'ปลั๊ก lg',
        'sicon-shuttle-lg' => 'ชัตเติ้ล Lg',
        'sicon-soundwave-lg' => 'คลื่นเสียง Lg',
        'sicon-graph-lg' => 'กราฟ Lg',
        'sicon-playlist-lg' => 'รายการเพลง Lg',
        'sicon-voice-recognition-lg' => 'การจดจําเสียง Lg',
        'sicon-machine-learning-lg' => 'การเรียนรู้กลไก Lg',
        'sicon-bed-lg' => 'เตียง Lg',
        'sicon-blueprint-lg' => 'พิมพ์เขียว Lg',
        'sicon-content-delivery-lg' => 'การจัดส่งเนื้อหา Lg',
        'sicon-questionnaire-lg' => 'แบบสอบถาม Lg',
        'sicon-presentation-lg' => 'การนําเสนอ Lg',
        'sicon-organic-lg' => 'ออแกนิก Lg',
        'sicon-transactions-lg' => 'ธุรกรรม Lg',
        'sicon-wand-lg' => 'ไม้เท้า Lg',
        'sicon-bin-lg' => 'ถังขยะ Lg',
        'sicon-sync-lg' => 'ซิงค์ Lg',
        'sicon-external-authentication-lg' => 'การตรวจสอบสิทธิ์ภายนอก Lg',
        'sicon-tracking-activity-lg' => 'ติดตามกิจกรรม Lg',
        'sicon-account' => 'บัญชี',
        'sicon-meetings-lg' => 'การประชุม Lg',
        'sicon-stacked' => 'มุมมองแยกแนวนอน',
        'sicon-sidebyside' => 'มุมมองแยกแนวตั้ง',
        ],

        'module_colors_dom' => [
        'army' => 'กองทัพ',
        'coral' => 'ปะการัง',
        'green' => 'เขียว',
        'orange' => 'ส้ม',
        'ocean' => 'มหาสมุทร',
        'pacific' => 'แปซิฟิก',
        'pink' => 'ชมพู',
        'purple' => 'ม่วง',
        'red' => 'แดง',
        'teal' => 'น้ำเงินอมเขียว',
        'yellow' => 'เหลือง',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'ใหม่',
        'In Progress' => 'อยู่ระหว่างดำเนินการ',
        'Closed' => 'ปิดแล้ว',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'ไม่ได้ใช้งานอยู่',
        'Lack of Progress' => 'ขาดความก้าวหน้า',
        'Customer-Imposed Deadline' => 'วันครบกำหนดที่ลูกค้ากำหนด',
        'Account at Risk' => 'บัญชีที่มีความเสี่ยง',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'คำขอจากลูกค้า',
        'Internally Requested' => 'คำขอภายใน',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'เคส',
        'Bugs' => 'บัก',
        'Accounts' => 'บัญชี',
        'Opportunities' => 'โอกาสทางการขาย',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'เชิงบวก',
        'Negative' => 'เชิงลบ',
        'Neutral' => 'ธรรมดา',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'ไม่น่าเป็นไปได้',
        '02_less_likely' => 'เป็นไปได้น้อย',
        '03_neutral' => 'เฉย ๆ',
        '04_more_likely' => 'น่าจะเป็นไปได้',
        '05_very_likely' => 'เป็นไปได้มาก',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'ไม่ตรงกับลูกค้า',
        '02_no_match' => '',
        '01_matches_customers' => 'ตรงกับลูกค้า',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'ผู้สนใจ',
        'Accounts' => 'บัญชี',
        'Contacts' => 'ที่อยู่ติดต่อ',
        'Cases' => 'เคส',
        'Opportunities' => 'โอกาสทางการขาย',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'ยังไม่เริ่มต้น',
        'in_progress' => 'อยู่ระหว่างดำเนินการ',
        'completed' => 'สมบูรณ์แล้ว',
        'cancelled' => 'ยกเลิกแล้ว',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'ไม่มี',
        'create' => 'เมื่อสร้าง',
        'stage_start' => 'ในขั้นตอนการสร้าง',
        'previous_activity_completed' => 'กิจกรรมก่อนหน้าเสร็จสมบูรณ์แล้ว',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'ผู้ใช้ปัจจุบัน',
        'parent_assignee' => 'ผู้ใช้ที่ได้รับมอบหมายหลัก',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'วันจากวันที่สร้าง',
        'days_from_stage_started' => 'วันจากขั้นตอนที่สร้าง',
        'days_from_previous_activity_completed' => 'วันจากกิจกรรมก่อนหน้าที่สมบูรณ์',
        'days_from_parent_date_field' => 'วันจากฟิลด์วันที่หลัก',
        'days_from_specific_activity_completed' => 'วันจากเวลาที่กิจกรรมที่เฉพาะเจาะจงสมบูรณ์',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'เมื่อสร้าง',
        'stage_started' => 'เมื่อขั้นตอนริ่มขึ้น',
        'previous_activity_completed' => 'เมื่อกิจกรรมก่อนหน้าเสร็จสมบูรณ์',
        'parent_date_field' => 'ในฟิลด์วันที่หลัก',
        'specific_activity_completed' => 'กิจกรรมเฉพาะเจาะจงเสร็จสมบูรณ์แล้ว',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'สมบูรณ์',
        'Percentage' => 'เปอร์เซ็นต์',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'งานของลูกค้า',
        'milestone' => 'ระยะไมล์',
        'internal_task' => 'งานภายใน',
        'agency_task' => 'งานของหน่วยงาน',
        'automatic_task' => 'งานอัตโนมัติ',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'งาน',
        'Calls' => 'การโทร',
        'Meetings' => 'การประชุม',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'ไม่มี',
        'create' => 'เมื่อสร้าง',
        'stage_start' => 'ในขั้นตอนการสร้าง',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'สืบทอด',
        'current_user' => 'ผู้ใช้ปัจจุบัน',
        'parent_assignee' => 'ผู้ใช้ที่ได้รับมอบหมายหลัก',
        'user' => 'ผู้ใช้',
        'team' => 'ทีม',
        'user_team' => 'ผู้ใช้และทีม',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'สืบทอด',
        'none' => 'ไม่มี',
        'create' => 'เมื่อสร้าง',
        'stage_start' => 'ในขั้นตอนการสร้าง',
        'previous_activity_completed' => 'กิจกรรมก่อนหน้าเสร็จสมบูรณ์แล้ว',
        'specific_activity_completed' => 'กิจกรรมเฉพาะเจาะจงเสร็จสมบูรณ์แล้ว',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'ยังไม่เริ่มต้น',
        'in_progress' => 'อยู่ระหว่างดำเนินการ',
        'not_completed' => 'ยังไม่สมบูรณ์',
        'completed' => 'สมบูรณ์แล้ว',
        'cancelled' => 'ยกเลิกแล้ว',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'แก้ไขขั้นตอน',
        'stage_add_task_button' => 'สร้างงาน',
        'stage_add_meeting_button' => 'วางกำหนดการประชุม',
        'stage_add_call_button' => 'วางกำหนดการโทร',
        'stage_delete_button' => 'ลบขั้นตอน',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'เพิ่มงาน',
        'activity_add_sub_meeting_button' => 'วางกำหนดการประชุม',
        'activity_add_sub_call_button' => 'วางกำหนดการโทร',
        'activity_not_applicable_button' => 'ใช้งานไม่ได้',
        'activity_delete_button' => 'ลบ',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'ใช้งานชุดไม่ได้',
        'remove_open_activities' => 'นํากิจกรรมที่เปิดอยู่ออก',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'ค่าเริ่มต้น',
        'custom' => 'กำหนดเอง',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'GET',
        'POST' => 'POST',
        'PUT' => 'PUT',
        'PATCH' => 'PATCH',
        'DELETE' => 'ลบ',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'ข้ามคำขอ',
        'json' => 'JSON',
        'http_query' => 'แบบสอบถาม HTTP',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'ไม่มีการตอบกลับ',
        'json' => 'JSON',
        'http_query' => 'แบบสอบถาม HTTP',
        'text' => 'ข้อความล้วน',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'ก่อนสร้าง',
        'after_create' => 'หลังจากสร้าง',
        'before_in_progress' => 'ก่อนดำเนินการ',
        'after_in_progress' => 'หลังดำเนินการ',
        'before_completed' => 'ก่อนสมบูรณ์',
        'after_completed' => 'หลังสมบูรณ์',
        'before_not_applicable' => 'ก่อนใช้งานไม่ได้',
        'after_not_applicable' => 'หลังใช้งานไม่ได้',
        'before_delete' => 'ก่อนลบ',
        'after_delete' => 'หลังลบ',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'ส่งข้อมูลคู่มืออัจฉริยะ',
        'custom_body' => 'ส่งเนื้อหาโพสต์แบบกำหนดเอง',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'อยู่ระหว่างดำเนินการ',
        'completed' => 'สมบูรณ์แล้ว',
        'not_applicable' => 'ใช้งานไม่ได้',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'ดูระเบียน',
        'create_record' => 'สร้างระเบียน',
        'update_record' => 'อัปเดตระเบียน',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'สร้างระเบียนอัตโนมัติ',
        'manual_create' => 'สร้างระเบียนด้วยตัวเอง',
        'automatic_update' => 'อัปเดตระเบียนอัตโนมัติ',
        'manual_update' => 'อัปเดตระเบียนด้วยตัวเอง',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'คู่มืออัจฉริยะ เทมเพลต',
        'DRI_SubWorkflow_Templates' => 'เทมเพลตขั้นตอน',
        'DRI_Workflow_Task_Templates' => 'เทมเพลตกิจกรรม',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'ใช่',
        'no' => 'ไม่',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'จัดขึ้น',
        'Not Held' => 'ไม่ได้จัดขึ้น',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'จัดขึ้น',
        'Not Held' => 'ไม่ได้จัดขึ้น',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'สมบูรณ์แล้ว',
        'Not Applicable' => 'ใช้งานไม่ได้',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'คู่มืออัจฉริยะ เทมเพลต',
        'DRI_SubWorkflow_Templates' => 'เทมเพลตขั้นตอน',
        'DRI_Workflow_Task_Templates' => 'เทมเพลตกิจกรรม',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'งาน',
        'Meetings' => 'การประชุม',
        'Calls' => 'การโทร',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'งานปัจจุบัน',
        'Calls' => 'การโทรปัจจุบัน',
        'Meetings' => 'การประชุมปัจจุบัน',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'ผู้ใช้ที่ระบุ',
        'specific_contacts' => 'ผู้ติดต่อที่ระบุ',
        'related_parent_users' => 'ผู้ใช้หลักที่เกี่ยวข้อง',
        'related_parent_contacts' => 'ผู้ติดต่อหลักที่เกี่ยวข้อง',
        'add_all_contacts_from_parent' => 'เพิ่มผู้ติดต่อทั้งหมดจากผู้ใช้หลัก',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'ผู้ใช้',
        'specific_contacts' => 'ติดต่อ',
        'related_parent_users' => 'ผู้ใช้',
        'related_parent_contacts' => 'ติดต่อ',
        'add_all_contacts_from_parent' => 'ติดต่อ',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'นาที',
        'hours' => 'ชั่วโมง',
        'days' => 'วัน',
        'months' => 'เดือน',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'วัน',
        'months' => 'เดือน',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'วันที่แน่นอน',
        'relative' => 'วันที่ใกล้เคียง',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'เดือน',
        'teams' => 'ทีม',
        'roles' => 'บทบาท',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide ไปยังการดำเนินการ Sugar',
        'sugar_action_to_smart_guide' => 'การดำเนินการ Sugar ไปยัง Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide ขั้นตอน',
        'Smart Guide Activities' => 'Smart Guide เทมเพลตกิจกรรม',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'สมบูรณ์แล้ว',
        'cancelled' => 'ยกเลิกแล้ว',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'อยู่ระหว่างดำเนินการ',
        'completed' => 'สมบูรณ์แล้ว',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'อยู่ระหว่างดำเนินการ',
        'completed' => 'สมบูรณ์แล้ว',
        'not_applicable' => 'ใช้งานไม่ได้',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'ทําเครื่องหมายกิจกรรมทั้งหมดว่าเสร็จสมบูรณ์แล้ว',
        'mark_all_not_applicable' => 'ทําเครื่องหมายกิจกรรมที่ไม่สมบูรณ์ทั้งหมดว่า ใช้งานไม่ได้',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'สหรัฐอเมริกา (ออริกอน) [us-west-2]',
        'ca-central-1' => 'แคนาดา (ภาคกลาง) [ca-central-1]',
        'ap-southeast-1' => 'เอเชียแปซิฟิก (สิงคโปร์) [ap-southeast-1]',
        'ap-southeast-2' => 'เอเชียแปซิฟิก (ซิดนีย์) [ap-southeast-2]',
        'eu-central-1' => 'ยุโรป (แฟรงก์เฟิร์ต) [eu-central-1]',
        'eu-west-2' => 'ยุโรป (ลอนดอน) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'ส่วนหัวระเบียน', // Studio editing of record views
    'LBL_RECORD_BODY' => 'นามบัตร', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'แสดงเพิ่มเติม', // Studio editing of record views
    'LBL_FAVORITE' => 'รายการโปรด', // Record view header panel element
    'LBL_FOLLOW' => 'ติดตาม', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'เปิดลิงก์',
    'LBL_TOGGLE_VISIBILITY' => 'สลับการแสดงผล', // Record view header panel element
    'LBL_ACTIVITIES' => 'สตรีมกิจกรรม',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar และลูกบาศก์ 3-D เป็นเครื่องหมายการค้าจดทะเบียนของ SugarCRM Inc. ' .
        'ชื่อบริษัทและผลิตภัณฑ์อื่นๆ ทั้งหมดที่ใช้หรือปรากฏในผลิตภัณฑ์นี้อาจเป็นเครื่องหมายการค้าของ' .
        'SugarCRM ®, Sugar Enterprise™ และ Sugar™ เป็นเครื่องหมายการค้าของ SugarCRM Inc.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ และ Sugar™ เป็นเครื่องหมายทางการค้าของ SugarCRM Inc',
    'LBL_SEND_INVITE' => 'ส่งคำเชิญ',
    'LBL_INVITEES' => 'ผู้ใช้ภายนอก',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'ผู้ใช้ภายนอกจะไม่ได้รับคำเชิญของคุณ',
    'LBL_SELECT_ACTION_LABEL' => 'เลือกการดำเนินการ',
    'LBL_TOGGLE_DRAWER' => 'สลับลิ้นชัก',
    'LBL_TOUR_NEXT' => 'ถัดไป',
    'LBL_TOUR_SKIP' => 'ข้าม',
    'LBL_TOUR_BACK' => 'ย้อนกลับ',
    'LBL_TOUR_CLOSE' => 'ปิด',
    'LBL_TOUR_BTN_DONE' => 'เสร็จสิ้น',
    'LBL_TOUR_TAKE_TOUR' => 'ทัวร์ชม',
    'LBL_TOUR_FULL_TOUR' => 'ทัวร์เต็มรูปแบบ',
    'LBL_TOUR_MODULE' => 'ทัวร์ชมเพจนี้',
    'LBL_TOUR_END_TOUR' => 'ยุติการทัวร์',
    'LBL_TOUR_OVERVIEW' => 'ภาพรวมของเพจ',
    'LBL_TOUR_REVISIT' => 'คลิกที่นี่เพื่อเปิดทัวร์ได้ทุกเวลา',
    'LBL_MY_AREA_LINKS' => 'ลิงก์พื้นที่ของฉัน: ' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'สูดอากาศ' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'ยินดีต้อนรับ' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'การค้นหาขั้นสูง' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'รายละเอียดเพิ่มเติม' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'แก้ไขแบบอินไลน์' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'ดู' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'ค้นหา' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'ค้นหา...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'นำออก' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'เพิ่ม' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'คอลัมน์' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 คอลัมน์' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 คอลัมน์' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'การค้นหาขั้นสูง' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'เพิ่ม' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'ซ่อน/แสดง' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'ลบ' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'เพิ่ม' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'ล้าง' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'เลิกเชื่อมโยง' /*for 508 compliance fix*/,
    'LBL_ADD' => 'เพิ่ม' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'โลโก้บริษัท' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'ปฏิทิน' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'ค่าดรอปดาวน์ที่คุณเลือกได้เปลีี่ยนเลย์เอาต์มุมมองระเบียนของคุณ ' .
        'ฟิลด์ที่ซ่อนอยู่ในเลย์เอาต์นี้ถูกล้างค่าไปแล้ว ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'เปิด',
    'LBL_SIDEBAR_NAV_CLOSE' => 'ปิด',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} เมนู',
    'LBL_GOTO_SUGARCRM_COM' => 'ไปที่ SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'การนำทางโมดูลหลัก',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'สลับแผงข้อมูลย่อย',

    'LBL_ADVANCED' => 'ขั้นสูง',
    'LBL_BASIC' => 'ขั้นต้น',
    'LBL_MODULE_FILTER' => 'กรองตาม...',
    'LBL_CONNECTORS_POPUPS' => 'ป๊อปอัปของเครื่องมือเชื่อมต่อ',
    'LBL_CLOSEINLINE' => 'ปิด',
    'LBL_EDITINLINE' => 'แก้ไข',
    'LBL_VIEWINLINE' => 'มุมมอง',
    'LBL_INFOINLINE' => 'ข้อมูล',
    'LBL_POWERED_BY_SUGARCRM' => 'ขับเคลื่อนโดย SugarCRM',
    'LBL_PRINT' => 'พิมพ์',
    'LBL_HELP' => 'ความช่วยเหลือ',
    'LBL_TOUR' => 'ทัวร์',
    'LBL_TOUR_LINK' => 'ทัวร์ชมเพจนี้',
    'LBL_MOBILE' => 'อุปกรณ์เคลื่อนที่',
    'LBL_ID_FF_SELECT' => 'เลือก',
    'DEFAULT' => 'ขั้นต้น',
    'LBL_SORT' => 'จัดเรียง',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'เพิ่มเซิร์ฟเวอร์...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'เปิดใช้ SMTP ผ่าน SSL หรือ TLS?',
    'LBL_NO_ACTION' => 'ไม่มีการดำเนินการชื่อนี้',
    'LBL_NO_DATA' => 'ไม่มีข้อมูล',
    'LBL_NOT_APPLICABLE' => 'ใช้งานไม่ได้',
    'LBL_ROUTING_ADD_RULE' => 'เพิ่มกฎ',
    'LBL_ROUTING_ALL' => 'อย่างน้อย',
    'LBL_ROUTING_ANY' => 'ไม่ระบุ',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'ยกเลิก',
    'LBL_ROUTING_BUTTON_SAVE' => 'บันทึกกฎ',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'คัดลอกอีเมล',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'ลบออบเจกต์ Sugar',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'ลบไฟล์',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'ลบอีเมล',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'ส่งต่ออีเมล',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'ติดธงสถานะอีเมล',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'ทำเครื่องหมายว่าอ่านแล้ว',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'ทำเครื่องหมายว่ายังไม่ได้อ่าน',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'ย้ายอีเมล',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'ดำเนินการต่อไปนี้',
    'LBL_ROUTING_ACTIONS_REPLY' => 'ตอบกลับอีเมล',

    'LBL_ROUTING_CHECK_RULE' => "ตรวจพบข้อผิดพลาด:\n",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'โปรดยืนยันฟิลด์ทั้งหมดที่มีเครื่องหมาย',
    'LBL_ROUTING_CONFIRM_DELETE' => "คุณแน่ใจหรือไม่ว่าต้องการลบกฎนี้\nขั้นตอนนี้ไม่สามารถยกเลิกได้",

    'LBL_ROUTING_FLAGGED' => 'ตั้งค่าธงสถานะ',
    'LBL_ROUTING_FORM_DESC' => 'กฎที่บันทึกไว้จะมีผลใช้งานทันที',
    'LBL_ROUTING_FW' => 'ส่งต่อ: ',
    'LBL_ROUTING_LIST_TITLE' => 'กฎ',
    'LBL_ROUTING_MATCH' => 'ถ้า',
    'LBL_ROUTING_MATCH_2' => 'จากเงื่อนไขต่อไปนี้ตรง:',
    'LBL_NOTIFICATIONS' => 'การแจ้งเตือน',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'สำเนาถึง',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'เนื้อหาข้อความ',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'จาก',
    'LBL_ROUTING_MATCH_NAME' => 'เรื่อง',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'ลำดับความสำคัญสูง',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'ระดับความสำคัญปกติ',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'ลำดับความสำคัญต่ำ',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'ถึง',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'ประกอบด้วย',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'ไม่มี',

    'LBL_ROUTING_NAME' => 'ชื่อกฎ',
    'LBL_ROUTING_NEW_NAME' => 'กฎใหม่',
    'LBL_ROUTING_ONE_MOMENT' => 'โปรดรอสักครู่...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'ต่อจากนี้เป็นข้อความต้นฉบับ',
    'LBL_ROUTING_RE' => 'ตอบกลับ: ',
    'LBL_ROUTING_SAVING_RULE' => 'บันทึกกฎ',
    'LBL_ROUTING_SUB_DESC' => 'กฎที่มีเครื่องหมายจะมีผลใช้งาน คลิกที่ชื่อเพื่อแก้ไข',
    'LBL_ROUTING_TO' => 'ถึง',
    'LBL_ROUTING_TO_ADDRESS' => 'ถึงที่อยู่',
    'LBL_ROUTING_WITH_TEMPLATE' => 'ใช้เทมเพลท',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'ขณะนี้ระเบียนนี้มีค่าในฟิลด์โทรศัพท์ที่ทำงานและที่อยู่ในการเขียนทับค่าเหล่านี้ด้วยข้อมูลโทรศัพท์ที่ทำงานและที่อยู่ของบัญชีที่คุณเลือกไว้ ให้คลิก "ตกลง" ในการเก็บค่าปัจจุบันไว้ ให้คลิก "ยกเลิก',
    'LBL_DROP_HERE' => '[วางที่นี่]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'แก้ไข',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'เติมค่าเริ่มต้นของ Gmail ล่วงหน้า',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'ชื่อ',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'คุณสมบัติของเซิร์ฟเวอร์อีเมลขาออก',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'โปรแกรมรับส่งอีเมล',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'ใช้การตรวจสอบสิทธิ์ SMTP หรือไม่',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'รหัสผ่าน SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'พอร์ต SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'เซิร์ฟเวอร์ SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'ใช้ SSL เมื่อเชื่อมต่อ',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'ชื่อผู้ใช้ SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'ค่าเริ่มต้น',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'คำเตือน: ไม่มีชื่อผู้ใช้และรหัสผ่านสำหรับบัญชีอีเมลขาออก',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'ต้องระบุชื่อผู้ใช้ SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'ต้องระบุรหัสผ่าน SMTP',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'การจัดการบัญชีอีเมล',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'โปรโตคอลของเซิร์ฟเวอร์อีเมลประเภท POP3 จะไม่มีการสนับสนุนในรุ่นถัดไป โดยจะมีเฉพาะการสนับสนุน IMAP',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'ตั้งค่าบัญชีอีเมลเพื่อดูอีเมลขาเข้าจากบัญชีอีเมลของคุณ',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'ระบุข้อมูลเซิร์ฟเวอร์อีเมล SMTP เพื่อใช้สำหรับอีเมลขาออกในบัญชีอีเมล',
    'LBL_EMAIL_ADD' => 'เพิ่มอีเมล',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'เสร็จสิ้น',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'ล้าง',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'ถึง:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'สำเนาถึง:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'สำเนาลับถึง:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'ถึง/สำเนาถึง/สำเนาลับถึง',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'รายการใหม่',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'ที่อยู่อีเมล',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'ขณะนี้สนับสนุนเฉพาะการแก้ไขที่อยู่ติดต่อเท่านั้น',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'ตัวกรอง',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'ชื่อ/ชื่อบัญชี',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'นามสกุล',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'ที่อยู่ติดต่อของฉัน',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'รายการส่งอีเมลของฉัน',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'ชื่อ',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'ไม่พบที่อยู่',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'บันทึกและเพิ่มในสมุดที่อยู่',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'ค้นหา',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'เลือกผู้รับอีเมล',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'สมุดที่อยู่',
    'LBL_EMAIL_REPORTS_TITLE' => 'รายงาน',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'คำเตือน! บัญชีขาออกที่คุณต้องการลบเชื่อมโยงอยู่กับบัญชีขาเข้าที่มีอยู่แล้ว คุณต้องการดำเนินการต่อหรือไม่',
    'LBL_EMAIL_ADDRESSES' => 'อีเมล',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'ที่อยู่อีเมล',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'ที่อยู่อีเมล',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'นำเข้าสู่ Sugar',
    'LBL_EMAIL_ASSIGNMENT' => 'การมอบหมาย',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'แนบ',
    'LBL_EMAIL_ATTACHMENT' => 'แนบ',
    'LBL_EMAIL_ATTACHMENTS' => 'จากระบบภายใน',
    'LBL_EMAIL_ATTACHMENTS2' => 'จากเอกสาร Sugar',
    'LBL_EMAIL_ATTACHMENTS3' => 'ไฟล์แนบของเทมเพลท',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'ไฟล์',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'เอกสาร',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'รวมไว้',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'ไม่สามารถอัปโหลดไฟล์แนบ',
    'LBL_REMOVING_ATTACHMENT' => 'กำลังย้ายไฟล์แนบออก...',
    'LBL_EMAIL_BCC' => 'สำเนาลับถึง',
    'LBL_EMAIL_CANCEL' => 'ยกเลิก',
    'LBL_EMAIL_CC' => 'สำเนาถึง',
    'LBL_EMAIL_CHARSET' => 'ชุดอักขระ',
    'LBL_EMAIL_CHECK' => 'ตรวจสอบอีเมล',
    'LBL_EMAIL_CHECKING_NEW' => 'ตรวจสอบอีเมลใหม่',
    'LBL_EMAIL_CHECKING_DESC' => 'โปรดรอสักครู่... <br><br>ถ้าเป็นการตรวจสอบอีเมลครั้งแรกสำหรับบัญชี อาจใช้เวลาสักครู่',
    'LBL_EMAIL_CLOSE' => 'ปิด',
    'LBL_EMAIL_COFFEE_BREAK' => 'กำลังตรวจสอบอีเมลใหม่ <br><br>บัญชีอีเมลที่มีขนาดใหญ่อาจใช้เวลานาน',
    'LBL_EMAIL_COMMON' => 'ทั่วไป',

    'LBL_EMAIL_COMPOSE' => 'อีเมล',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'โปรดป้อนผู้รับอีเมลนี้',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'เชื่อมโยงกับ',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'เนื้อหาอีเมลว่างเปล่า ต้องการส่งหรือไม่',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'อีเมลนี้ไม่มีหัวเรื่อง ต้องการส่งหรือไม่',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(ไม่มีหัวเรื่อง)',
    'LBL_EMAIL_COMPOSE_READ' => 'อ่านและเขียนอีเมล',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'ส่งจากบัญชีอีเมล',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'ตัวเลือก',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'โปรดป้อนที่อยู่อีเมลที่ถูกต้องสำหรับฟิลด์ถึง สำเนาถึง และสำเนาลับถึง',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'ยกเลิกอีเมลนี้หรือไม่',
    'LBL_EMAIL_CONFIRM_DELETE' => 'นำรายการเหล่านี้ออกจากสมุดที่อยู่หรือไม่',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'คุณแน่ใจหรือไม่ว่าต้องการลบลายเซ็นนี้',

    'LBL_EMAIL_CREATE_NEW' => '--สร้างเมื่อบันทึก--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'หลายรายการ',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'ว่างเปล่า',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'วันที่ส่งโดยผู้ส่ง',
    'LBL_EMAIL_DATE_RECEIVED' => 'วันที่ได้รับ',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'ระบุให้ผู้ใช้',
    'LBL_EMAIL_DATE_TODAY' => 'วันนี้',
    'LBL_EMAIL_DATE_YESTERDAY' => 'เมื่อวานนี้',
    'LBL_EMAIL_DD_TEXT' => 'อีเมลได้รับเลือกไว้',
    'LBL_EMAIL_DEFAULTS' => 'ค่าเริ่มต้น',
    'LBL_EMAIL_DELETE' => 'ลบ',
    'LBL_EMAIL_DELETE_CONFIRM' => 'ลบข้อความที่เลือกหรือไม่',
    'LBL_EMAIL_DELETE_SUCCESS' => 'ลบอีเมลสำเร็จแล้ว',
    'LBL_EMAIL_DELETING_MESSAGE' => 'กำลังลบข้อความ',
    'LBL_EMAIL_DETAILS' => 'รายละเอียด',
    'LBL_EMAIL_DISPLAY_MSG' => 'กำลังแสดงอีเมล {0} - {1} จาก {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'กำลังแสดงที่อยู่อีเมล {0} - {1} จาก {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'แก้ไขที่อยู่ติดต่อ',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'ระบบจะใช้เฉพาะที่อยู่หลักเมื่อทำงานกับที่อยู่ติดต่อ',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'แก้ไขรายการส่งอีเมล',

    'LBL_EMAIL_EMPTYING_TRASH' => 'กำลังล้างถังขยะ',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'กำลังลบเซิร์ฟเวอร์ขาออก',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'กำลังล้างไฟล์แคช',
    'LBL_EMAIL_EMPTY_MSG' => 'ไม่มีอีเมลที่จะแสดง',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'ไม่มีที่อยู่อีเมลที่จะแสดง',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'ชื่อโฟลเดอร์ต้องไม่ซ้ำกันและไม่ว่างเปล่า โปรดลองอีกครั้ง',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'ไม่สามารถลบโฟลเดอร์ โฟลเดอร์หรือรายการย่อยภายในโฟลเดอร์มีอีเมลหรือกล่องจดหมายเชื่อมโยงอยู่',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'ไม่สามารถบอกโฟลเดอร์ที่ต้องการจากบริบท โปรดลองอีกครั้ง',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'โปรดตรวจสอบการตั้งค่า',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'โปรดตรวจสอบว่าได้ป้อนนามสกุลแล้ว',
    'LBL_EMAIL_ERROR_DESC' => 'ตรวจพบข้อผิดพลาด: ',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'คุณไม่มีสิทธิ์เข้าถึงพื้นที่นี้ โปรดติดต่อผู้ดูแลไซต์เพื่อขอรับสิทธิ์เข้าถึง',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'ชื่อโฟลเดอร์ Sugar ต้องไม่ซ้ำกัน',
    'LBL_EMAIL_ERROR_EMPTY' => 'โปรดป้อนเกณฑ์การค้นหา',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'เกิดข้อผิดพลาด',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'มีรายชื่ออีเมลชื่อนี้แล้ว',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'นำข้อความออกจากเซิร์ฟเวอร์แล้ว',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'ข้อความอาจถูกนำออกจากเซิร์ฟเวอร์หรือถูกย้ายไปยังโฟลเดอร์อื่นแล้ว',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'เชื่อมต่อไปยังเซิร์ฟเวอร์อีเมลไม่สำเร็จ โปรดติดต่อผู้ดูแลระบบ',
    'LBL_EMAIL_ERROR_MOVE' => 'ขณะนี้ยังไม่สนับสนุนการย้ายอีเมลระหว่างเซิร์ฟเวอร์ และ/หรือบัญชี',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'เกิดข้อผิดพลาดในการย้าย',
    'LBL_EMAIL_ERROR_NAME' => 'ต้องระบุชื่อ',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'ต้องมีที่อยู่ "จาก" โปรดป้อนที่อยู่อีเมลที่ถูกต้อง',
    'LBL_EMAIL_ERROR_NO_FILE' => 'โปรดระบุไฟล์',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'ขณะนี้ยังไม่สนับสนุนการเปลี่ยนชื่อโฟลเดอร์ IMAP',
    'LBL_EMAIL_ERROR_SERVER' => 'ต้องระบุที่อยู่ของเซิร์ฟเวอร์อีเมล',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'อาจไม่ได้บันทึกบัญชีอีเมล',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'เกิดข้อผิดพลาดขณะสื่อสารกับเซิร์ฟเวอร์อีเมล',
    'LBL_EMAIL_ERROR_USER' => 'ต้องระบุชื่อล็อกอิน',
    'LBL_EMAIL_ERROR_PASSWORD' => 'ต้องระบุรหัสผ่าน',
    'LBL_EMAIL_ERROR_PORT' => 'ต้องระบุพอร์ตของเซิร์ฟเวอร์อีเมล',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'ต้องระบุโปรโตคอลของเซิร์ฟเวอร์',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'ต้องมีโฟลเดอร์ที่ตรวจสอบ',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'ต้องมีโฟลเดอร์ถังขยะ',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'ไม่มีข้อมูลนี้',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'ไม่ได้ระบุเซิร์ฟเวอร์อีเมลขาออกไว้',
    'LBL_EMAIL_FOLDERS' => 'โฟลเดอร์',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'ย้ายไปที่',
    'LBL_EMAIL_FOLDERS_ADD' => 'เพิ่ม',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'เพิ่มโฟลเดอร์ใหม่',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'เปลี่ยนชื่อโฟลเดอร์',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'บันทึก',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'เพิ่มโฟลเดอร์นี้ใน',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'ไม่สามารถเปลี่ยนแปลงโฟลเดอร์นี้',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'แน่ใจหรือไม่ว่าต้องการลบโฟลเดอร์นี้ กระบวนการนี้ไม่สามารถย้อนกลับได้ การลบโฟลเดอร์จะมีผลกับโฟลเดอร์ภายในทั้งหมด',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'ชื่อโฟลเดอร์ใหม่',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'โปรดเลือกโฟลเดอร์ก่อนดำเนินการนี้',
    'LBL_EMAIL_FOLDERS_TITLE' => 'การจัดการโฟลเดอร์',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'การใช้กลุ่ม',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'ระบุให้ทีม',
    'LBL_EMAIL_FORWARD' => 'ส่งต่อ',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => 'ดาวน์โหลดแล้ว [[count]] จาก [[total]] อีเมล',
    'LBL_EMAIL_FOUND' => 'พบ',
    'LBL_EMAIL_FROM' => 'จาก',
    'LBL_EMAIL_GROUP' => 'กลุ่ม',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'กลุ่ม',
    'LBL_EMAIL_HOME_FOLDER' => 'หน้าแรก',
    'LBL_EMAIL_HTML_RTF' => 'ส่ง HTML',
    'LBL_EMAIL_IE_DELETE' => 'กำลังลบบัญชีอีเมล',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'กำลังลบลายเซ็น',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'แน่ใจหรือไม่ว่าต้องการลบบัญชีอีเมลนี้',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'ลบสำเร็จแล้ว',
    'LBL_EMAIL_IE_SAVE' => 'กำลังบันทึกข้อมูลบัญชีอีเมล',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'กำลังนำเข้าอีเมล',
    'LBL_EMAIL_IMPORT_EMAIL' => 'นำเข้าสู่ Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'การตั้งค่าการนำเข้า',
    'LBL_EMAIL_INVALID' => 'ไม่ถูกต้อง',
    'LBL_EMAIL_LINK_RECORD' => 'คลิกที่นี่',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'เปลี่ยนชื่อรายการส่งอีเมล',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'ป้อนชื่อใหม่สำหรับรายการส่งอีเมลนี้',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'นำรายการเหล่านี้ออกจากรายการส่งอีเมลของคุณหรือไม่',
    'LBL_EMAIL_LOADING' => 'กำลังโหลด...',
    'LBL_EMAIL_MARK' => 'ทำเครื่องหมาย',
    'LBL_EMAIL_MARK_FLAGGED' => 'ว่าติดธงสถานะ',
    'LBL_EMAIL_MARK_READ' => 'ว่าอ่านแล้ว',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'ว่าไม่ได้ติดธงสถานะ',
    'LBL_EMAIL_MARK_UNREAD' => 'ว่ายังไม่ได้อ่าน',
    'LBL_EMAIL_ASSIGN_TO' => 'ระบุให้กับ',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'สร้างโฟลเดอร์',
    'LBL_EMAIL_MENU_COMPOSE' => 'เขียนไปยัง',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'ลบโฟลเดอร์',
    'LBL_EMAIL_MENU_EDIT' => 'แก้ไข',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'ล้างถังขยะ',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'ซิงโครไนซ์',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'ล้างไฟล์แคช',
    'LBL_EMAIL_MENU_REMOVE' => 'นำออก',
    'LBL_EMAIL_MENU_RENAME' => 'เปลี่ยนชื่อ',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'เปลี่ยนชื่อโฟลเดอร์',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'เปลี่ยนชื่อโฟลเดอร์',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'โปรดเลือกก่อนที่จะดำเนินการนี้',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'สร้างโฟลเดอร์ (ระยะไกลหรือใน Sugar)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'เก็บถาวรอีเมลเหล่านี้ไปยัง SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'ส่งอีเมลไปยังรายการส่งอีเมลที่เลือก',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'ส่งอีเมลถึงที่อยู่ติดต่อนี้',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'นำที่อยู่ติดต่อออก',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'ลบอีเมลเหล่านี้',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'ลบโฟลเดอร์ (ระยะไกลหรือใน Sugar)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'แก้ไขที่อยู่ติดต่อ',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'แก้ไขรายการส่งอีเมล',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'ล้างโฟลเดอร์ถังขยะทั้งหมดสำหรับบัญชีอีเมล',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'ทำเครื่องหมายอีเมลเหล่านี้ว่าติดธงสถานะ',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'ทำเครื่องหมายอีเมลเหล่านี้ว่าอ่านแล้ว',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'ทำเครื่องหมายอีเมลเหล่านี้ว่าไม่ได้ติดธงสถานะ',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'ทำเครื่องหมายอีเมลเหล่านี้ว่ายังไม่ได้อ่าน',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'นำรายการส่งอีเมลออก',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'เปลี่ยนชื่อโฟลเดอร์ (ระยะไกลหรือใน Sugar)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'ตอบกลับอีเมลเหล่านี้',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'ตอบกลับผู้รับทั้งหมดของอีเมลเหล่านี้',

    'LBL_EMAIL_MESSAGES' => 'ข้อความ',

    'LBL_EMAIL_ML_NAME' => 'ชื่อรายการ',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'ที่อยู่ในรายการที่เลือกไว้',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'ที่อยู่ในรายการที่ใช้ได้',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-คลิก</b> เพื่อเลือกหลายรายการ<br />(ผู้ใช้ Mac โปรดใช้ <b>CMD-คลิก</b>)',

    'LBL_EMAIL_NO' => 'ไม่',
    'LBL_EMAIL_NOT_SENT' => 'เกิดปัญหาในการส่งอีเมลคำขอ โปรดติดต่อผู้ดูแลระบบ',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'ไม่สามารถใส่ใน users_password_link ได้',

    'LBL_EMAIL_OK' => 'ตกลง',
    'LBL_EMAIL_ONE_MOMENT' => 'โปรดรอสักครู่...',
    'LBL_EMAIL_OPEN_ALL' => 'เปิดหลายข้อความ',
    'LBL_EMAIL_OPTIONS' => 'ตัวเลือก',
    'LBL_EMAIL_QUICK_COMPOSE' => 'เขียนแบบรวดเร็ว',
    'LBL_EMAIL_OPT_OUT' => 'เลือกออก',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'เลือกออกแล้วและไม่ถูกต้อง',
    'LBL_EMAIL_PAGE_AFTER' => 'จาก {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'เพจ',
    'LBL_EMAIL_PERFORMING_TASK' => 'ดำเนินการ',
    'LBL_EMAIL_PRIMARY' => 'หลัก',
    'LBL_EMAIL_PRINT' => 'พิมพ์',

    'LBL_EMAIL_QC_BUGS' => 'บัก',
    'LBL_EMAIL_QC_CASES' => 'เคส',
    'LBL_EMAIL_QC_LEADS' => 'ผู้สนใจ',
    'LBL_EMAIL_QC_CONTACTS' => 'ที่อยู่ติดต่อ',
    'LBL_EMAIL_QC_TASKS' => 'งาน',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'โอกาสทางการขาย',
    'LBL_EMAIL_QUICK_CREATE' => 'สร้างแบบด่วน',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'กำลังสร้างโฟลเดอร์ใหม่',
    'LBL_EMAIL_RELATE_TO' => 'เชื่อมโยง',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'ดูความสัมพันธ์',
    'LBL_EMAIL_RECORD' => 'ระเบียนอีเมล',
    'LBL_EMAIL_REMOVE' => 'นำออก',
    'LBL_EMAIL_REPLY' => 'ตอบกลับ',
    'LBL_EMAIL_REPLY_ALL' => 'ตอบกลับทั้งหมด',
    'LBL_EMAIL_REPLY_TO' => 'ตอบกลับ',
    'LBL_EMAIL_RETRIEVING_LIST' => 'กำลังเรียกรายการส่งอีเมล',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'กำลังเรียกข้อความ',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'กำลังเรียกระเบียนอีเมล',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'โปรดเลือกระเบียนอีเมลเพียงรายการเดียว',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'กลับไปที่โมดูลก่อนหน้าหรือไม่',
    'LBL_EMAIL_REVERT' => 'เปลี่ยนกลับ',
    'LBL_EMAIL_RELATE_EMAIL' => 'เชื่อมโยงอีเมล',

    'LBL_EMAIL_RULES_TITLE' => 'การจัดการกฎ',

    'LBL_EMAIL_SAVE' => 'บันทึก',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'บันทึกและตอบกลับ',
    'LBL_EMAIL_SAVE_DRAFT' => 'บันทึกแบบร่าง',

    'LBL_EMAIL_SEARCHING' => 'กำลังดำเนินการค้นหา',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'การค้นหาขั้นสูง',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'วันที่เริ่มต้น',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'วันที่สิ้นสุด',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'ข้อความเนื้อหา',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'ไม่มีผลลัพธ์ที่ตรงกับเกณฑ์การค้นหาของคุณ',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'ผลการค้นหา',
    'LBL_EMAIL_SEARCH_TITLE' => 'การค้นหาแบบง่าย',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'ค้นหาบัญชีอีเมล',

    'LBL_EMAIL_SELECT' => 'เลือก',

    'LBL_EMAIL_SEND' => 'ส่ง',
    'LBL_EMAIL_SENDING_EMAIL' => 'กำลังส่งอีเมล',

    'LBL_EMAIL_SETTINGS' => 'การตั้งค่า',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 แถว',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 คอลัมน์',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'สไตล์ของเลย์เอาต์',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'บัญชีอีเมล',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'ล้างฟอร์ม',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'นำเข้าอีเมลเมื่อดู',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'ตรวจสอบอีเมลใหม่',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'ใช้แผงแสดงตัวอย่าง',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'ใช้หน้าต่างป๊อปอัป',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'จำนวนอีเมลต่อเพจ',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'แก้ไขบัญชีอีเมล',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'โฟลเดอร์',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'จากที่อยู่',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'ที่อยู่ที่ส่งสำหรับการแจ้งเตือนทดสอบ:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'ถึงที่อยู่อีเมล',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'จากชื่อ',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'ที่อยู่ตอบกลับ',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'เต็มหน้าจอ',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'ซิงโครไนซ์บัญชีอีเมลทั้งหมด',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'ระบบส่งอีเมลไปยังที่อยู่อีเมลที่ระบุโดยใช้การตั้งค่าอีเมลขาออกที่กำหนดไว้แล้ว โปรดตรวจสอบว่าอีเมลนั้นส่งถึงปลายทางหรือไม่ เพื่อยืนยันว่าการตั้งค่าถูกต้อง',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'การดำเนินการนี้จะซิงโครไนซ์บัญชีอีเมลและเนื้อหาในบัญชี',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'ดำเนินการซิงโครไนซ์แบบเต็มหรือไม่\nบัญชีอีเมลขนาดใหญ่อาจใช้เวลาสักครู่',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'กดปุ่ม Shift หรือ Ctrl เพื่อเลือกหลายโฟลเดอร์',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'ทั่วไป',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'โฟลเดอร์กลุ่มที่ใช้ได้',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'สร้างโฟลเดอร์กลุ่ม',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'กำลังบันทึกโฟลเดอร์กลุ่ม',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'กำลังเรียกโฟลเดอร์กลุ่ม',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'แก้ไขโฟลเดอร์กลุ่ม',

    'LBL_EMAIL_SETTINGS_NAME' => 'ชื่อบัญชีอีเมล',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'เลือกจำนวนอีเมลต่อเพจในกล่องจดหมาย การตั้งค่านี้อาจต้องมีการรีเฟรชเพจเพื่อให้มีผล',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'กำลังเรียกบัญชีอีเมล',
    'LBL_EMAIL_SETTINGS_RULES' => 'กฎ',
    'LBL_EMAIL_SETTINGS_SAVED' => 'บันทึกการตั้งค่าแล้ว',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'คุณต้องโหลดเพจนี้ใหม่เพื่อให้การตั้งค่าใหม่มีผล',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'ส่งอีเมลแบบข้อความล้วนเท่านั้น',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'ใช้งาน',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'อีเมลต่อเพจ',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'แสดงแท็บที่ด้านล่าง',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'การตั้งค่าการแสดงผล',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'การตั้งค่า',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'แสดงการตั้งค่าขั้นสูง',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'โฟลเดอร์ผู้ใช้ที่ใช้ได้',
    'LBL_EMAIL_ERROR_PREPEND' => 'ข้อผิดพลาด:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'เซิร์ฟเวอร์อีเมลขาออกที่เลือกสำหรับบัญชีอีเมลที่ใช้ไม่ถูกต้อง ตรวจสอบการตั้งค่าหรือเลือกเซิร์ฟเวอร์อีเมลอื่นสำหรับบัญชีอีเมลนี้',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'เซิร์ฟเวอร์อีเมลขาออกไม่ได้รับการกำหนดค่าให้ส่งอีเมล โปรดกำหนดค่าเซิร์ฟเวอร์อีเมลขาออกหรือเลือกเซิร์ฟเวอร์อีเมลขาออกสำหรับบัญชีอีเมลที่คุณใช้ในการตั้งค่า >> บัญชีอีเมล',
    'LBL_EMAIL_SHOW_READ' => 'แสดงทั้งหมด',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'แสดงรายการที่ยังไม่ได้อ่านเท่านั้น',
    'LBL_EMAIL_SIGNATURES' => 'ลายเซ็น',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'สร้างลายเซ็น',
    'LBL_EMAIL_SIGNATURE_NAME' => 'ชื่อลายเซ็น',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'เนื้อหาลายเซ็น',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'แลกเปลี่ยนออนไลน์',
    'LBL_SMTPTYPE_GMAIL' => 'แอปที่มีความปลอดภัยน้อยกว่าใน Google',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'อื่นๆ',
    'LBL_EMAIL_AUTHORIZE' => 'อนุญาต',
    'LBL_EMAIL_AUTHORIZED' => 'อนุญาตแล้ว',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'ไม่อนุญาต',
    'LBL_EMAIL_AUTH_WARNING' => 'ผู้ดูแลระบบจะต้องกำหนดค่าเครื่องมือเชื่อมต่อ {0} ผ่าน ผู้ดูแลระบบ > เครื่องมือเชื่อมต่อ ก่อนที่จะสามารถสร้างบัญชีได้ คุณสามารถดูข้อมูลเพิ่มเติมได้ที่เอกสาร {1}',
    'LBL_EMAIL_AUTH_API_ERROR' => 'มีข้อผิดพลาดในการดึงข้อมูลเครื่องมือเชื่อมต่อ',
    'LBL_EMAIL_AUTH_FAILURE' => 'ความล้มเหลวในการอนุญาต',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'กรุณาให้อนุญาตบัญชีก่อนบันทึก',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'กรุณาให้อนุญาตบัญชีก่อนทำการทดสอบ',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'บัญชีไม่ได้รับอนุญาต',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[โฟลเดอร์ระยะไกล]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[โฟลเดอร์ Sugar]',
    'LBL_EMAIL_SUBJECT' => 'เรื่อง',
    'LBL_EMAIL_SUCCESS' => 'สำเร็จ',
    'LBL_EMAIL_SUGAR_FOLDER' => 'SugarFolder',
    'LBL_EMAIL_TEAMS' => 'ระบุให้ทีม',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'เนื้อหาของเทมเพลทอีเมลว่างเปล่า',
    'LBL_EMAIL_TEMPLATES' => 'เทมเพลท',
    'LBL_EMAIL_TEXT_FIRST' => 'เพจแรก',
    'LBL_EMAIL_TEXT_PREV' => 'เพจก่อนหน้า',
    'LBL_EMAIL_TEXT_NEXT' => 'เพจถัดไป',
    'LBL_EMAIL_TEXT_LAST' => 'เพจสุดท้าย',
    'LBL_EMAIL_TEXT_REFRESH' => 'รีเฟรช',
    'LBL_EMAIL_TO' => 'ถึง',
    'LBL_EMAIL_TOGGLE_LIST' => 'สลับรายการ',
    'LBL_EMAIL_VIEW' => 'ดู',
    'LBL_EMAIL_VIEWS' => 'มุมมอง',
    'LBL_EMAIL_VIEW_HEADERS' => 'แสดงส่วนหัว',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'ฉบับสำหรับพิมพ์',
    'LBL_EMAIL_VIEW_RAW' => 'แสดงอีเมลขั้นต้น',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'ไม่รองรับคุณลักษณะนี้เมื่อใช้กับ POP3',
    'LBL_DEFAULT_LINK_TEXT' => 'ข้อความลิงก์เริ่มต้น',
    'LBL_EMAIL_YES' => 'ใช่',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'ส่งอีเมลทดสอบ',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'ส่งอีเมลทดสอบแล้ว',


    'LBL_EMAIL_MESSAGE_NO' => 'ข้อความเลขที่',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'ส่งการนำเข้าแล้ว',
    'LBL_EMAIL_IMPORT_FAIL' => 'นำเข้าไม่สำเร็จเนื่องจากข้อความมีการนำเข้าแล้วหรือถูกลบออกจากเซิร์ฟเวอร์',

    'LBL_EMAILS_FROM' => 'อีเมลที่ส่งแล้ว',
    'LBL_EMAILS_RECEIVED' => 'อีเมลที่ได้รับ',
    'LBL_EMAIL_ADDRESSES_USED' => 'ที่อยู่อีเมลที่ใช้ในอีเมล',
    'LBL_EMAIL_ADDRESS' => 'ที่อยู่อีเมล',
    'LBL_FROM' => 'จาก',
    'LBL_TO' => 'ถึง',
    'LBL_CC' => 'สำเนาถึง',
    'LBL_BCC' => 'สำเนาลับถึง',

    'LBL_START_DATE' => 'วันที่เริ่มต้น',
    'LBL_END_DATE' => 'วันที่สิ้นสุด',
    'LBL_START' => 'เริ่มต้น',
    'LBL_END' => 'สิ้นสุด',
    'LBL_DATE_LINKED' => 'วันที่เชื่อมโยง',

    'LBL_LINK_NONE' => 'ไม่มี',
    'LBL_LINK_ALL' => 'ทั้งหมด',
    'LBL_LINK_RECORDS' => 'ระเบียน',
    'LBL_LINK_SELECT' => 'เลือก',
    'LBL_LINK_ACTIONS' => 'การดำเนินการ',
    'LBL_LINK_MORE' => 'เพิ่มเติม',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'ยืนยัน',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'คุณต้องการปิด #module# หรือไม่',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'ไม่ต้องแสดงข้อความนี้อีก: &nbsp;',
    'LBL_INVALID_FILE_EXTENSION' => 'นามสกุลไฟล์ไม่ถูกต้อง',
    'LBL_LIST_TEAM' => 'ทีม',
    'LBL_TEAM' => 'ทีม:',
    'LBL_TEAMS' => 'ทีม',
    'LBL_TEAM_SET_ID' => 'ID ชุดทีม',
    'LBL_TEAM_SET_SELECTED_ID' => 'ID ชุดทีมที่เลือกไว้',
    'LBL_TEAM_SET_SELECTED' => 'เลือกไว้',
    'LBL_TEAM_SET_ENABLE' => 'เปิดใช้สิทธิ์เพิ่มเติม',
    'LBL_TEAM_SET_DISABLE' => 'ปิดใช้สิทธิ์เพิ่มเติม',
    'LBL_TEAM_SET' => 'ชุดทีม',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'ทีมที่เลือก',
    'LBL_SEARCH_UNAVAILABLE' => 'ใช้การค้นหาไม่ได้ โปรดลองอีกครั้งในภายหลัง',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'ไม่ได้ระบุทีมหลักไว้',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'เกิดข้อผิดพลาดขณะพยายามนำ ID ทีมหลัก [{0}] ออกสำหรับโมดูล [{1}] ที่ใช้ ID [{2}]',
    'LBL_TEAM_ADD' => 'เพิ่มทีม',
    'LBL_TEAM_REMOVE' => 'นำทีมออก',
    'LBL_TEAM_PRIMARY' => 'ตั้งค่าเป็นทีมหลัก',

    'LBL_CLOSE_BUTTON_LABEL' => 'ปิด',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} ถูกทำเครื่องหมายว่า {{status}}',

    'LBL_FOCUS' => 'โฟกัส',

    'LBL_QUERY_VALID' => 'ถูกต้อง',
    'LBL_QUERY_ERROR' => 'ข้อผิดพลาด',
    'LBL_QUERY_CHILD' => 'การสืบค้นย่อยที่ถูกต้อง',
    'ERROR_EXAMINE_MSG' => 'โปรดตรวจสอบข้อความแสดงข้อผิดพลาดด้านล่าง:',
    'NO_QUERY_SELECTED' => 'รูปแบบข้อมูลที่คุณเลือกไม่มีการสืบค้นอยู่ โปรดเลือกการสืบค้นที่กำหนดเองสำหรับรูปแบบข้อมูลนี้',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'เกิดข้อผิดพลาด:',
    'ERR_AJAX_LOAD_FAILURE' => 'เกิดข้อผิดพลาดในการประมวลผลคำขอ โปรดลองอีกครั้งในภายหลัง',
    'ERR_AJAX_LOAD_FOOTER' => 'ถ้าปัญหานี้ยังคงอยู่ โปรดขอให้ผู้ดูแลระบบปิดใช้งาน Ajax สำหรับโมดูลนี้',
    'ERR_CREATING_FIELDS' => 'เกิดข้อผิดพลาดในการเติมฟิลด์รายละเอียดเพิ่มเติม: ',
    'ERR_CREATING_TABLE' => 'เกิดข้อผิดพลาดในการสร้างตาราง: ',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'อักขระคั่นทศนิยมต้องไม่เป็นอักขระเดียวกับอักขระตัวคั่นหลักพัน โปรดเปลี่ยนค่าใดค่าหนึ่ง',
    'ERR_DELETE_RECORD' => 'ต้องระบุเลขที่ระเบียนเพื่อลบที่อยู่ติดต่อ',
    'ERR_EXPORT_DISABLED' => 'การส่งออกถูกปิดใช้งานอยู่',
    'ERR_EXPORT_TYPE' => 'เกิดข้อผิดพลาดในการส่งออก ',
    'ERR_REPORTS_DISABLED_EXPORT' => 'การส่งออกรายงานถูกปิดใช้งาน',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'ผู้ใช้ที่เป็นผู้ดูแลระบบเท่านั้นที่สามารถส่งออกได้',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'รายงานใช้โมดูลที่ไม่มีการเข้าถึงการส่งออก',
    'ERR_REPORTS_EXPORT_OWNER' => 'รายงานใช้โมดูลที่ไม่มีเข้าถึงการส่งออกของเจ้าของ',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'รายงานใช้โมดูลที่มีการเข้าถึงที่จำกัดรายการ',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'รายงานใช้โมดูลที่มีการเข้าถึงที่จำกัดการดู',
    'ERR_REPORTS_ACCESS_DISABLED' => 'รายงานใช้โมดูลที่มีการเข้าถึงที่จำกัด',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'รายงานใช้ฟิลด์ที่มีการเข้าถึงที่จำกัด',
    'ERR_INVALID_AMOUNT' => 'โปรดป้อนจำนวนที่ถูกต้อง',
    'ERR_INVALID_DATE_FORMAT' => 'รูปแบบวันที่ต้องเป็น: ',
    'ERR_INVALID_DATE' => 'โปรดป้อนวันที่ที่ถูกต้อง',
    'ERR_INVALID_DAY' => 'โปรดป้อนวันที่ถูกต้อง',
    'ERR_INVALID_EMAIL_ADDRESS' => 'ที่อยู่อีเมลไม่ถูกต้อง',
    'ERR_INVALID_FILE_REFERENCE' => 'การอ้างอิงไฟล์ไม่ถูกต้อง',
    'ERR_INVALID_HOUR' => 'โปรดป้อนชั่วโมงที่ถูกต้อง',
    'ERR_INVALID_MONTH' => 'โปรดป้อนเดือนที่ถูกต้อง',
    'ERR_INVALID_TIME' => 'โปรดป้อนเวลาที่ถูกต้อง',
    'ERR_INVALID_YEAR' => 'โปรดป้อนเวลาเป็นเลข 4 หลักที่ถูกต้อง',
    'ERR_NEED_ACTIVE_SESSION' => 'ต้องมีเซสชันที่ใช้งานเพื่อส่งออกเนื้อหา',
    'ERR_NO_HEADER_ID' => 'คุณลักษณะนี้ไม่สามารถใช้ได้ในธีมนี้',
    'ERR_NOT_ADMIN' => 'ไม่มีสิทธิ์ในการเข้าถึงการดูแลระบบ',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'การจัดการรหัสผ่านมีให้ใช้งานใน<a href="%s" target="_blank">การตั้งค่าระบบ SugarCloud</a> เท่านั้น',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'กรุณาติดต่อผู้ดูแลระบบ Sugar ของคุณ ถ้าคุณต้องการทำการเปลี่ยนแปลงลงในช่องที่ตั้งค่าไว้ให้อ่านได้อย่างเดียวเท่านั้น',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'กรุณาไปที่<a href="{0}" target="_blank">การตั้งค่า SugarCloud</a> เพื่อทำการเปลี่ยนแปลงฟิลด์ที่ตั้งค่าไว้ให้อ่านได้อย่างเดียวเท่านั้น',
    'ERR_MISSING_REQUIRED_FIELDS' => 'ไม่มีข้อมูลในฟิลด์ที่ต้องระบุ',
    'ERR_INVALID_REQUIRED_FIELDS' => 'ฟิลด์ที่ต้องระบุไม่ถูกต้อง:',
    'ERR_INVALID_VALUE' => 'ค่าไม่ถูกต้อง:',
    'ERR_NO_SUCH_FILE' => 'ไม่มีไฟล์ในระบบ',
    'ERR_NO_SINGLE_QUOTE' => 'ไม่สามารถใช้เครื่องหมายอัญประกาศเดี่ยวสำหรับ ',
    'ERR_NOTHING_SELECTED' => 'โปรดเลือกก่อนที่จะดำเนินการต่อ',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'มีโอกาสทางการขายชื่อ %s แล้ว โปรดป้อนชื่ออื่นด้านล่างนี้',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'ไม่ได้ป้อนชื่อโอกาสทางการขาย โปรดป้อนชื่อโอกาสทางการขายด้านล่าง',
    'ERR_QUOTE_CONVERTED' => 'การเสนอราคานี้มีการแปลงเป็นโอกาสทางการขายแล้ว',
    'ERR_POTENTIAL_SEGFAULT' => 'ตรวจพบกรณีที่อาจเป็นข้อผิดพลาดของการแบ่งส่วน Apache โปรดแจ้งผู้ดูแลระบบเพื่อยืนยันปัญหานี้ และให้ผู้ดูแลระบบรายงานไปยัง SugarCRM',
    'ERR_SELF_REPORTING' => 'ผู้ใช้ไม่สามารถรายงานไปยังตนเอง',
    'ERR_SINGLE_QUOTE' => 'ไม่สนับสนุนอัญประกาศเดี่ยวสำหรับฟิลด์นี้ โปรดเปลี่ยนค่า',
    'ERR_SQS_NO_MATCH_FIELD' => 'ไม่มีรายการที่ตรงกันสำหรับฟิลด์: ',
    'ERR_SQS_NO_MATCH' => 'ไม่มีรายการที่ตรงกัน',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'โปรดระบุดัชนี &#39;key&#39; ในแอททริบิว displayParams สำหรับการกำหนดเมตะดาต้า',
    'ERR_EXISTING_PORTAL_USERNAME' => 'ข้อผิดพลาด: มีการมอบหมายชื่อพอร์ทัลให้กับที่อยู่ติดต่ออื่นแล้ว',
    'ERR_PORTAL_NAME_CHECK' => 'ไม่สามารถยืนยันว่าชื่อผู้ใช้ของพอร์ทัลไม่ซ้ำกัน',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'ค่าของฟิลด์ไม่สามารถใช้ได้กับค่าตำแหน่งทศนิยม',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'เกิดข้อผิดพลาดขณะพยายามบันทึกไปยังบัญชีภายนอก',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'เกิดข้อผิดพลาดขณะอัปโหลด โปรดตรวจสอบว่าไฟล์ที่อัปโหลดไม่ว่างเปล่า',
    'ERR_NO_DB' => 'ไม่สามารถเชื่อมต่อกับฐานข้อมูล โปรดดูที่ sugarcrm.log เพื่อดูรายละเอียด',
    'ERR_DB_FAIL' => 'ฐานข้อมูลทำงานล้มเหลว โปรดดูที่ sugarcrm.log เพื่อดูรายละเอียด',
    'ERR_EXTERNAL_API_403' => 'ไม่ได้รับอนุญาต ระบบไม่สนับสนุนไฟล์ประเภทนี้',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'ไม่มีโทเค็นการเข้าถึงด้วย OAuth',
    'ERR_DB_VERSION' => 'ไฟล์ Sugar CRM {0} จะต้องใช้กับฐานข้อมูล Sugar CRM {1} เท่านั้น',
    'ERR_DB_QUERY' => '{0}: การสืบค้นล้มเหลว: {1}',
    'ERR_UW_RETIRED' => 'วิซาร์ดการอัปเกรดไม่สามารถใช้ได้ในเวอร์ชันนี้',
    'ERR_NOT_CLOUD_INSTANCE' => 'อินสแตนซ์ Sugar นี้ไม่ได้เป็นทั้งอินสแตนซ์ SugarCloud และไม่ใช่การกำหนดค่าสำหรับ SugarCloud Insights',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'คุณไม่ได้รับอนุญาตให้สร้าง {moduleName} โปรดติดต่อผู้ดูแลระบบถ้าต้องการสิทธิ์เข้าถึง',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'ผู้ใช้ปัจจุบันไม่ได้รับอนุญาตให้เปลี่ยนการกำหนดค่า {moduleName}',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'ผู้ใช้ปัจจุบันไม่ได้รับอนุญาตให้เปลี่ยนการกำหนดค่า {moduleName}',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'คุณไม่ได้รับอนุญาตให้เพิ่ม {moduleName} เป็นรายการโปรด โปรดติดต่อผู้ดูแลระบบถ้าคุณต้องการสิทธิ์เข้าถึง',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'คุณไม่ได้รับอนุญาตให้สมัครรับข้อมูล {moduleName} โปรดติดต่อผู้ดูแลระบบถ้าต้องการสิทธิ์เข้าถึง',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'ไม่พบช่อง_ที่เกี่ยวข้องกับ_คอลัมน์_แผ่นงานใน payload',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'บทสรุป_คอลัมน์ไม่ใช่ข้อมูลประเภทอาเรย์',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'ไม่พบช่อง_ที่เกี่ยวข้องกับ_คอลัมน์_แผ่นงานใน payload',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'แถว_ข้อความท้ายหน้าไม่ใช่อาเรย์',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'ไม่พบช่อง_ที่เกี่ยวข้องกับ_ข้อความท้ายหน้าใน payload',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'คำขอของคุณล้มเหลวเนื่องจากข้อยกเว้นที่ไม่ทราบ',
    'EXCEPTION_FATAL_ERROR' => 'ไม่สามารถดำเนินการตามคำขอให้เสร็จสมบูรณ์ เนื่องจากเกิดข้อผิดพลาดร้ายแรง โปรดตรวจสอบล็อกเพื่อดูรายละเอียด',
    'EXCEPTION_NEED_LOGIN' => 'คุณต้องล็อกอินเพื่อดำเนินการนี้',
    'EXCEPTION_INVALID_TOKEN' => 'โทเค็นการตรวจสอบสิทธิ์ของคุณไม่ถูกต้อง',
    'EXCEPTION_NOT_AUTHORIZED' => 'คุณไม่ได้รับอนุญาตให้ดำเนินการนี้ โปรดติดต่อผู้ดูแลระบบถ้าต้องการสิทธิ์เข้าถึง',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'คุณไม่ได้รับอนุญาตให้ดูข้อมูล โปรดติดต่อผู้ดูแลระบบถ้าต้องการสิทธิ์เข้าถึง',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'คุณไม่สามารถเข้าถึงพอร์ทัลเนื่องจากบัญชีพอร์ทัลของคุณไม่อยู่ในสถานะใช้งาน โปรดติดต่อฝ่ายสนับสนุนลูกค้าถ้าต้องการสิทธิ์เข้าถึง',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'พอร์ทัลไม่ได้กำหนดค่าไว้อย่างถูกต้อง โปรดติดต่อผู้ดูแลระบบพอร์ทัลเพื่อขอความช่วยเหลือ',
    'EXCEPTION_NO_METHOD' => 'ไม่มีการสนับสนุนคำขอของคุณ ไม่พบเมทธอด HTTP ของคำขอสำหรับเส้นทางนี้',
    'EXCEPTION_NOT_FOUND' => 'ไม่พบทรัพยากรที่ขอ ไม่พบแฮนด์เลอร์สำหรับเส้นทางที่ระบุในคำขอ',
    'EXCEPTION_MISSING_PARAMTER' => 'ไม่มีพารามิเตอร์ที่ต้องระบุในคำขอของคุณ',
    'EXCEPTION_INVALID_PARAMETER' => 'พารามิเตอร์ในคำขอของคุณไม่ถูกต้อง',
    'EXCEPTION_REQUEST_FAILURE' => 'ไม่สามารถดำเนินการตามคำขอให้เสร็จสมบูรณ์',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'ข้อมูลเมตาหรือแฮชของผู้ใช้ไม่ตรงกับเซิร์ฟเวอร์ โปรดซิงค์เมตะดาต้าใหม่',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'คำขอของคุณใหญ่เกินไปที่จะประมวลผล',
    'EXCEPTION_EDIT_CONFLICT' => 'มีความขัดแย้งของการแก้ไข โปรดโหลดข้อมูลระเบียนอีกครั้ง',
    'EXCEPTION_METADATA_CONFLICT' => 'มีความขัดแย้งของเมตะดาต้า โปรดโหลดเมตะดาต้าอีกครั้ง',
    'EXCEPTION_CLIENT_OUTDATED' => 'ซอฟต์แวร์ของคุณเก่าเกินไป โปรดอัปเดตไคลเอนต์ก่อนที่จะพยายามเชื่อมต่ออีกครั้ง',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'เครื่องมือเชื่อมต่อหรือคำขอรวมระบบทำให้การตอบกลับล้มเหลว',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM อยู่ในโหมดบำรุงรักษา มีเพียงผู้ดูแลระบบเท่านั้นที่สามารถล็อกอิน โปรดติดต่อผู้ดูแลระบบเพื่อขอรายละเอียด',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'เซิร์ฟเวอร์ไม่สามารถประมวลผลคำขอของคุณ เนื่องจากไม่ว่างหรือไม่สามารถใช้งานได้ในขณะนี้',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'เครื่องมือค้นหาไม่พร้อมใช้งานชั่วคราว',
    'EXCEPTION_SEARCH_RUNTIME' => 'เกิดข้อผิดพลาดรันไทม์กับเครื่องมือค้นหา โปรดติดต่อผู้ดูแลระบบ',
    'EXCEPTION_INVALID_PLATFORM' => 'แพลตฟอร์มที่ระบุไม่ถูกต้อง',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'ฟิลด์ที่ล็อคโดยกระบวนการไม่สามารถแก้ไขได้',
    'EXCEPTION_MODULE_DISABLED' => 'โมดูลนี้ไม่เปิดใช้งานแก่ผู้ใช้ปัจจุบัน',
    'EXCEPTION_FIELD_DISABLED' => 'ฟิลด์นี้ไม่เปิดใช้งานแก่ผู้ใช้ปัจจุบัน',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'ลูกค้ารายนี้ไม่ได้รับอนุญาต',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'ไม่มีความสามารถในการอัปโหลดแพ็กเกจพร้อมใช้สำหรับประเภทใบอนุญาตของคุณ',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'พบเงื่อนไขเนื่องจากการทำงานล้มเหลวหรือข้อผิดพลาดทั่วไป ข้อยกเว้นนี้มีสาเหตุหลายอย่าง แต่โดยทั่วไปมักจะอยู่นอกขอบเขตของข้อยกเว้น API ที่เจาะจง',
    'EXCEPTION_FATAL_ERROR_DESC' => 'ไม่สามารถประมวลผลคำขอที่แสดง หรือมีข้อผิดพลาดกับการตอบกลับ โดยทั่วไปหมายถึงเกิดข้อผิดพลาดร้ายแรง และสามารถระบุการทำงานล้มเหลวที่เจาะจงได้ในล็อกของแอปพลิเคชัน',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'เวอร์ชันของ API ที่คุณใช้ไม่ถูกต้องสำหรับคำขอปัจจุบัน',
    'EXCEPTION_NEED_LOGIN_DESC' => 'ปลายทางที่ขอต้องการการตรวจสอบสิทธิ์ และผู้ใช้ที่ขอยังไม่ผ่านการตรวจสอบสิทธิ์',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'แสดงว่าโทเค็นการตรวจสอบสิทธิ์ที่แสดงกับคำขอนั้นไม่ถูกต้อง โดยทั่วไปกรณีนี้เกิดขึ้นเนื่องจากโทเค็นหมดอายุ แต่อาจเกิดจากกรณีที่โทเค็นมีรูปแบบไม่ถูกต้องหรือเป็นโทเค็นที่ไม่ถูกต้อง',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'แสดงว่าผู้ใช้ที่ขอไม่ได้รับอนุญาตให้ดำเนินการที่ขอ',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'บัญชีพอร์ทัลที่เชื่อมโยงกับผู้ใช้ที่ล็อกอินไม่มีสถานะใช้งานในขณะนี้ กรณีนี้ต้องอาศัยการดำเนินการจากฝ่ายสนับสนุนลูกค้า',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'แสดงว่าแอปพลิเคชันพอร์ทัลไม่ได้กำหนดค่าอย่างถูกต้องและไม่สามารถใช้งานได้ กรณีนี้ต้องอาศัยการดำเนินการจากผู้ดูแลระบบพอร์ทัล',
    'EXCEPTION_NO_METHOD_DESC' => 'อุปกรณ์ปลายทางไม่สนับสนุนประเภทคำขอ HTTP ที่ส่ง ซึ่งอาจเกิดขึ้นเมื่อมีการส่งคำขอ POST ไปยังอุปกรณ์ปลายทางที่กำหนดไว้สำหรับคำขอ GET เป็นต้น',
    'EXCEPTION_NOT_FOUND_DESC' => 'อุปกรณ์ปลายทางไม่พบทรัพยากรสำหรับคำขอ หรือไม่มีแฮนด์เลอร์สำหรับคำขอ',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'แสดงว่าอาจมีการแก้ไขระเบียนเกิดขึ้นพร้อมกัน และคำขอปัจจุบันในการแก้ไขระเบียนจะมีผลกับการแก้ไขระเบียนก่อนหน้านี้',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'แสดงว่าเมตะดาต้าของเซิร์ฟเวอร์ไม่ตรงกับเมตะดาต้าที่ไคลเอนต์ใช้งานอยู่ กรณีนี้อาจเกิดขึ้นหลังจากการเปลี่ยนการตั้งค่าระบบ การเปลี่ยนแปลงของโมดูลใน Studio หรือการใช้งานโมดูลใหม่ หรือการเปลี่ยนแปลงอื่นๆ ของระบบ',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'คำขอนี้ใหญ่เกินไปกว่าที่จะจัดการโดยเซิร์ฟเวอร์',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'แสดงว่าพารามิเตอร์ที่ต้องระบุของคำขอขาดหายไป',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'แสดงว่าพารามิเตอร์ที่ส่งในคำขอไม่ถูกต้อง',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'ไม่สามารถดำเนินการตามคำขอให้เสร็จสมบูรณ์',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'แสดงว่าไคลเอนต์ที่ใช้งาน API เก่าเกินไปและต้องอัปเดตก่อนที่จะใช้ API ได้ต่อไป',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'แสดงว่าคำขอที่ส่งผ่าน API ไปยังบริการอื่น อุปกรณ์ปลายทาง หรือ URI ทำงานล้มเหลวหรือไม่สามารถจัดการโดยเซิร์ฟเวอร์',
    'EXCEPTION_MAINTENANCE_DESC' => 'อินสแตนซ์ของ SugarCRM ที่ให้บริการ API อยู่ในโหมดบำรุงรักษา การเข้าถึง API ถูกจำกัดไว้เฉพาะผู้ดูแลระบบเท่านั้น',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'แสดงว่าเซิร์ฟเวอร์ไม่ว่าง โอเวอร์โหลด หรือหยุดทำงาน',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'แบ็คเอนด์ของเครื่องมือค้นหาไม่สามารถใช้ได้ในขณะนี้เนื่องจากปัญหาการเชื่อมต่อ โปรดยืนยันการเชื่อมต่อและการกำหนดค่าใน การดูแลระบบ->การค้นหา->ทดสอบ',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'เกิดข้อยกเว้นรันไทม์ใน SearchEngine โปรดดู sugarcrm.log เพื่อดูรายละเอียดเพิ่มเติม',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'แสดงว่าระบบไม่ทราบแพลตฟอร์มที่ระบุระหว่างการตรวจสอบสิทธิ์ จะต้องมีการเพิ่มแพลตฟอร์มที่กำหนดเองใน custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'ฟิลด์ที่ล็อคโดยกระบวนการที่ทำงานอยู่ไม่สามารถแก้ไขได้',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s ถูกล็อคโดยกระบวนการที่ทำงานอยู่ และไม่สามารถแก้ไขได้',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s ถูกล็อคโดยกระบวนการที่ทำงานอยู่ และไม่สามารถแก้ไขได้',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'โมดูลนี้ไม่เปิดใช้งานแก่ผู้ใช้ปัจจุบัน',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'ฟิลด์นี้ไม่เปิดใช้งานแก่ผู้ใช้ปัจจุบัน',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'ลูกค้ารายนี้ไม่ได้รับอนุญาต',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'มีไฟล์ชื่อเดียวกันนี้อยู่แล้วในระบบ',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'เกิดข้อผิดพลาดเนื่องจากไม่ได้กำหนด Timeperiod ไว้สำหรับวันที่ {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'TimePeriod นี้มีช่วงเวลาย่อยอยู่แล้ว',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'ช่วงเวลาย่อยต้องไม่มีช่วงเวลาย่อยภายใน',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'ไม่สามารถเรียกช่วงเวลาประเภท: {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'ไม่มีช่วงเวลาที่ใช้งานสำหรับการตั้งค่าปัจจุบัน',
    'LBL_CURRENT_TIMEPERIOD' => 'ช่วงเวลาปัจจุบัน',
    'LBL_PREVIOUS_TIMEPERIOD' => 'ช่วงเวลาก่อนหน้า',
    'LBL_NEXT_TIMEPERIOD' => 'ช่วงเวลาถัดไป',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'ก่อนหน้า,ปัจจุบัน,ถัดไป',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'คุณไม่สามารถลบระเบียนที่มีขั้นตอนการขายปิดอยู่',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'คุณไม่สามารถลบระเบียนที่มีสถานะการขายปิดอยู่',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'ระเบียนที่เลือกไว้อย่างน้อยหนึ่งรายการมีขั้นตอนการขายเป็นปิดโดยได้รับการขายหรือปิดโดยไม่ได้รับการขาย และไม่สามารถลบได้',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'ระเบียนที่เลือกไว้อย่างน้อยหนึ่งรายการมีสถานะปิดโดยได้รับการขายหรือปิดโดยไม่ได้รับการขาย และไม่สามารถลบได้',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'ระเบียนที่เลือกไว้อย่างน้อยหนึ่งรายการมีรายการบรรทัดรายได้ที่มีสถานะ ' .
        'ไม่สามารถลบรายการที่ปิดโดยได้รับการขายหรือปิดโดยไม่ได้รับการขาย',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'ระเบียนที่เลือกไว้อย่างน้อยหนึ่งรายการมีขั้นตอนการขายเป็นปิดโดยได้รับการขายหรือปิดโดยไม่ได้รับการขาย และไม่สามารถอัปเดตเป็นกลุ่มได้',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'ระเบียนที่เลือกไว้อย่างน้อยหนึ่งรายการมีสถานะปิดโดยได้รับการขายหรือปิดโดยไม่ได้รับการขาย และไม่สามารถอัปเดตเป็นกลุ่มได้',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'ระเบียนที่เลือกไว้อย่างน้อยหนึ่งรายการมีรายการบรรทัดรายได้ที่มีสถานะ ' .
        'รายการที่ปิดโดยได้รับการขายหรือปิดโดยไม่ได้รับการขายนั้นไม่สามารถอัปเดตเป็นกลุ่มได้',

    'LBL_ACCOUNT' => 'บัญชี',
    'LBL_OLD_ACCOUNT_LINK' => 'บัญชีเดิม',
    'LBL_ACCOUNTS' => 'บัญชี',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'กิจกรรม',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'ดูข้อมูลสรุป',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'ดูข้อมูลสรุป',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'เพิ่ม',
    'LBL_ADD_BUTTON' => 'เพิ่ม',
    'LBL_ADD_DASHLET_BUTTON' => 'เพิ่มส่วนข้อมูล',
    'LBL_ADD_DOCUMENT' => 'เพิ่มเอกสาร',
    'LBL_REPLACE_BUTTON' => 'แทนที่',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'เพิ่มในรายการเป้าหมาย',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'เพิ่มในรายการเป้าหมาย',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'คลิกเพื่อปิด',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'ปิด',
    'LBL_ADDITIONAL_DETAILS' => 'รายละเอียดเพิ่มเติม',
    'LBL_ADMIN' => 'การดูแลระบบ',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'เก็บถาวร',
    'LBL_ASSIGNED_TO_USER' => 'ระบุให้ผู้ใช้',
    'LBL_ASSIGNED_TO' => 'มอบหมายให้:',
    'LBL_BACK' => 'ย้อนกลับ',
    'LBL_BASE_RATE' => 'อัตราฐาน',
    'LBL_BILL_TO_ACCOUNT' => 'บัญชีที่เรียกเก็บเงิน',
    'LBL_BILL_TO_CONTACT' => 'ที่อยู่ติดต่อที่เรียกเก็บเงิน',
    'LBL_BILLING_ADDRESS' => 'ที่อยู่ที่เรียกเก็บเงิน',
    'LBL_QUICK_CREATE_TITLE' => 'สร้างแบบด่วน',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'บัก',
    'LBL_BY' => 'โดย',
    'LBL_CALLS' => 'การโทร',
    'LBL_CALL' => 'การโทร',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'ส่งอีเมลแคมเปญตามคิว',
    'LBL_SUBMIT_BUTTON_LABEL' => 'ส่ง',
    'LBL_CASE' => 'เคส',
    'LBL_CASES' => 'เคส',
    'LBL_MESSAGE' => 'ข้อความ',
    'LBL_MESSAGES' => 'ข้อความ',
    'LBL_ESCALATIONS' => 'การเพิ่มขึ้น',
    'LBL_ESCALATION' => 'การเพิ่มขึ้น',
    'LBL_DOCUSIGN_ENVELOPES' => 'ซอง DocuSign',
    'LBL_DOCUSIGN_ENVELOPE' => 'ซอง DocuSign',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'เลือกผู้รับที่ลงนาม',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'เปลี่ยนรหัสผ่าน',
    'LBL_CHANGE_BUTTON_LABEL' => 'เปลี่ยน',
    'LBL_CHANGE_BUTTON_TITLE' => 'เปลี่ยน',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'เลือกทั้งหมด',
    'LBL_CITY' => 'เมือง',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'ล้าง',
    'LBL_CLEAR_BUTTON_TITLE' => 'ล้าง',
    'LBL_CLEARALL' => 'ล้างทั้งหมด',
    'LBL_CLICK_TO_EDIT' => 'คลิกเพื่อแก้ไข',
    'LBL_CLOSE_BUTTON_TITLE' => 'ปิด',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'ปิดหน้าต่าง',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'ปิดทั้งหมด',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'ปิดทั้งหมด',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'ปิดและสร้างใหม่',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'ปิดและสร้างใหม่',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'คัดลอก URL ระเบียน',
    'LBL_OPEN_ITEMS' => 'รายการที่เปิด:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'เขียนอีเมล',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'อีเมล',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'เขียนอีเมล',
    'LBL_SEARCH_DROPDOWN_YES' => 'ใช่',
    'LBL_SEARCH_DROPDOWN_NO' => 'ไม่',
    'LBL_CONTACT_LIST' => 'รายการที่อยู่ติดต่อ',
    'LBL_CONTACT' => 'ที่อยู่ติดต่อ',
    'LBL_CONTACTS' => 'ที่อยู่ติดต่อ',
    'LBL_CONTRACTS' => 'สัญญา',
    'LBL_COUNTRY' => 'ประเทศ:',
    'LBL_RESET_BUTTON_LABEL' => 'รีเซ็ต',
    'LBL_CREATE_BUTTON_LABEL' => 'สร้าง',
    'LBL_CREATED_BY_USER' => 'สร้างโดยผู้ใช้',
    'LBL_CREATED_USER' => 'สร้างโดยผู้ใช้',
    'LBL_CREATED_ID' => 'สร้างโดย ID',
    'LBL_CREATED' => 'สร้างโดย',
    'LBL_CREATE_NEW_TARGET_LIST' => 'สร้างรายการเป้าหมายใหม่',
    'LBL_CURRENT_USER_FILTER' => 'รายการของฉัน:',
    'LBL_CURRENCY' => 'สกุลเงิน:',
    'LBL_CURRENCIES' => 'สกุลเงิน',
    'LBL_CURRENCY_NAME' => 'ชื่อสกุลเงิน',
    'LBL_CURRENCY_SYMBOL' => 'สัญลักษณ์สกุลเงิน',
    'LBL_CURRENCY_RATE' => 'อัตราฐาน:',
    'LBL_CURRENCY_ID' => 'ID สกุลเงิน',
    'LBL_DOCUMENTS' => 'เอกสาร',
    'LBL_DATE_ENTERED' => 'วันที่สร้าง:',
    'LBL_DATE_MODIFIED' => 'วันที่แก้ไข:',
    'LBL_ACTIVITY_MODIFIED' => 'แก้ไขแล้ว',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'แก้ไขแท็บภาพรวม',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'แก้ไขแท็บโมดูล',
    'LBL_EDIT_BUTTON' => 'แก้ไข',
    'LBL_DUPLICATE_BUTTON' => 'ทำซ้ำ',
    'LBL_DELETE_BUTTON' => 'ลบ',
    'LBL_DELETE' => 'ลบ',
    'LBL_DELETED' => 'ลบ',
    'LBL_DIRECT_REPORTS' => 'ผู้ใต้บังคับบัญชา',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'เสร็จสิ้น',
    'LBL_DONE_BUTTON_TITLE' => 'เสร็จสิ้น',
    'LBL_DST_NEEDS_FIXIN' => 'แอปพลิเคชันกำหนดให้ใช้การแก้ไขเวลาออมแสง โปรดไปที่ลิงก์ <a href="index.php?module=Administration&action=DstFix">ซ่อมแซม</a> ในคอนโซลการดูแลระบบ และใช้การแก้ไขเวลาออมแสง',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'แก้ไขเป็นรายการใหม่',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'แก้ไขเป็นรายการใหม่',
    'LBL_EDIT_IN_NEW_TAB' => 'แก้ไขในแท็บใหม่',
    'LBL_FAVORITES' => 'รายการโปรด',
    'LBL_FILTER' => 'ตัวกรอง',
    'LBL_DEFAULT_DATA_FILTER' => 'ตัวกรองข้อมูลเริ่มต้น',
    'LBL_FILTER_MENU_BY' => 'กรองเมนูตาม',
    'LBL_FILTER_SELECT_FIELD' => 'เลือกฟิลด์...',
    'LBL_FILTER_SELECT_OPERATOR' => 'เลือกโอเปอเรเตอร์...',
    'LBL_FILTER_CREATE_NEW' => 'สร้าง',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'สร้างตัวกรอง (ไม่ได้บันทึก)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(ไม่ได้บันทึก)',
    'LBL_FILTER_CREATE_FILTER' => 'สร้างตัวกรองใหม่',
    'LBL_FILTER_CLOSE_FILTER' => 'ปิดตัวกรอง',
    'LBL_FILTER_EDIT_FILTER' => 'แก้ไขตัวกรอง',
    'LBL_FILTER_ALL_RECORDS' => 'ระเบียนทั้งหมด',
    'TPL_FILTER_SAVE' => 'คุณสร้างตัวกรอง {{name}} สำเร็จแล้ว',
    'LBL_FILTER_BETWEEN_FROM' => 'จาก',
    'LBL_FILTER_BETWEEN_TO' => 'ถึง',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'วันที่เริ่มต้น',
    'LBL_FILTER_DATEBETWEEN_TO' => 'วันที่สิ้นสุด',
    'LBL_FOLLOWING' => 'ติดตามอยู่',
    'LBL_UNFOLLOW' => 'เลิกติดตาม',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'ดาวน์โหลด vCard',
    'LBL_EMPTY_VCARD' => 'โปรดเลือกไฟล์ vCard',
    'LBL_IMAGE' => 'รูปภาพ',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard ไม่มีฟิลด์ที่ต้องระบุทั้งหมดสำหรับโมดูลนี้',
    'LBL_VCARD_ERROR_FILESIZE' => 'ไฟล์ที่อัปโหลดมีขนาดเกินขีดจำกัด 30000 ไบต์ที่ระบุในฟอร์ม HTML',
    'LBL_VCARD_ERROR_DEFAULT' => 'เกิดข้อผิดพลาดในการอัปโหลดไฟล์ vCard',
    'TPL_IMPORT_VCARD_FAILURE' => 'ไม่สามารถสร้าง {{module}} จาก vCard',
    'LBL_IMPORT_VCARD' => 'นำเข้า vCard:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'นำเข้า vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'นำเข้า vCard',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'มุมมอง',
    'LBL_VIEW_BUTTON_TITLE' => 'มุมมอง',
    'LBL_VIEW_BUTTON' => 'มุมมอง',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'ส่งอีเมลเป็น PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'ส่งอีเมลเป็น PDF',
    'LBL_EMAIL' => 'อีเมล',
    'LBL_EMAILS' => 'อีเมล',
    'LBL_EMPLOYEES' => 'พนักงาน',
    'LBL_ENTER_DATE' => 'ป้อนวันที่',
    'LBL_EXPORT_ALL' => 'ส่งออกทั้งหมด',
    'LBL_EXPORT' => 'ส่งออก',
    'LBL_FAVORITES_FILTER' => 'รายการโปรดของฉัน:',
    'LBL_GLOBAL_SEARCH' => 'การค้นหาทั้งระบบ',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'ตัวกรองโมดูลการค้นหาทั้งระบบ',
    'LBL_GLOBAL_SEARCH_RUN' => 'เรียกใช้การค้นหาทั้งระบบ',
    'LBL_GO_BUTTON_LABEL' => 'เริ่ม',
    'LBL_GS_HELP' => 'ฟิลด์ในโมดูลนี้ที่ใช้ในการค้นหาจะปรากฏด้านบน ข้อความที่ไฮไลต์ตรงกับเกณฑ์การค้นหาของคุณ',
    'LBL_HIDE' => 'ซ่อน',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => 'นำเข้า',
    'LBL_IMPORT_STARTED' => 'เริ่มต้นการนำเข้าแล้ว: ',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'ต้องระบุตัวคั่นที่กำหนดเอง',
    'LBL_LAST_VIEWED' => 'ดูล่าสุด',
    'LBL_SELECTED_RECORDS' => 'เลือกไว้: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'แสดงเฉพาะ {{maxPillsDisplayed}} ระเบียน',
    'TPL_MORE_RECORDS' => 'เลือกไว้อีก {{recordsLeft}} ระเบียน',
    'TPL_RECORDS_SELECTED' => 'เลือกไว้ {{recordsLeft}} ระเบียน',
    'LBL_SHOW_LESS' => 'แสดงน้อยลง',
    'LBL_SHOW_MORE' => 'แสดงเพิ่มเติม',
    'LBL_SHOW_MORE_MODULE' => '{{{module}}} เพิ่มเติม...',
    'LBL_SHOW_MORE_RECENTS' => 'ใหม่กว่า...',
    'LBL_SHOW_LESS_RECENTS' => 'เก่ากว่า',
    'LBL_SHOW_MORE_RESULTS' => 'ผลการค้นหาเพิ่มเติม...',
    'TPL_SHOW_MORE_MODULE' => '{{{module}}} เพิ่มเติม...',
    'LBL_SHOW_MORE_GENERIC' => '{{name}} เพิ่มเติม...',
    'LBL_TODAYS_ACTIVITIES' => 'กิจกรรมวันนี้',
    'LBL_LEADS' => 'ผู้สนใจ',
    'LBL_LEAD' => 'ผู้สนใจ',
    'LBL_QUOTES_BILL_TO' => 'การเสนอราคา (เรียกเก็บเงิน)',
    'LBL_LESS' => 'น้อยลง',
    'LBL_CAMPAIGN' => 'แคมเปญ:',
    'LBL_CAMPAIGNS' => 'แคมเปญ',
    'LBL_CAMPAIGNLOG' => 'CampaignLog',
    'LBL_CAMPAIGN_CONTACT' => 'แคมเปญ',
    'LBL_CAMPAIGN_ID' => 'campaign_id',
    'LBL_THEME' => 'ธีม:',
    'LBL_THEME_PICKER' => 'สไตล์ของเพจ',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'คำเตือน: ไม่มีการสนับสนุน Internet Explorer 6 สำหรับธีมที่เลือกไว้ โปรดคลิกตกลงเพื่อเลือกต่อไป หรือยกเลิกเพื่อเลือกธีมอื่น',
    'LBL_FOUND_IN_RELEASE' => 'พบในรีลีส',
    'LBL_FIXED_IN_RELEASE' => 'แก้ไขในรีลีส',
    'LBL_LIST_ACCOUNT_NAME' => 'ชื่อบัญชี',
    'LBL_LIST_ASSIGNED_USER' => 'ผู้ใช้',
    'LBL_LIST_CONTACT_NAME' => 'ชื่อผู้ติดต่อ',
    'LBL_LIST_CONTACT_ROLE' => 'บทบาทของผู้ติดต่อ',
    'LBL_LIST_DATE_ENTERED' => 'วันที่สร้าง',
    'LBL_LIST_EMAIL' => 'อีเมล',
    'LBL_LIST_NAME' => 'ชื่อ',
    'LBL_LIST_OF' => 'จาก',
    'LBL_LIST_PHONE' => 'โทรศัพท์',
    'LBL_LIST_RELATED_TO' => 'เกี่ยวข้องกับ',
    'LBL_LIST_USER_NAME' => 'ชื่อผู้ใช้',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'คุณแน่ใจหรือไม่ว่าต้องการอัปเดตทั้งรายการ',
    'LBL_LISTVIEW_NO_SELECTED' => 'โปรดเลือกอย่างน้อย 1 ระเบียนเพื่อดำเนินการต่อ',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'โปรดเลือกอย่างน้อย 2 ระเบียนเพื่อดำเนินการต่อ',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'โปรดเลือกไม่เกิน 10 ระเบียนเพื่อดำเนินการต่อ',
    'LBL_LISTVIEW_ALL' => 'ทั้งหมด',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'ตรึงแนวคอลัมน์ 1',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'รายการซ้ำทั้งหมด',
    'LBL_LISTVIEW_NONE' => 'ยกเลิกการเลือกทั้งหมด',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'เลือกเพจนี้',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'เลือกทั้งหมด',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'ระเบียนที่เลือก',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'เลือกไว้: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'ล้างตัวเลือกทั้งหมด',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'เลือกระเบียนทั้งหมด',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'มีระเบียนมากกว่า {{num}} รายการในชุดผลลัพธ์ คุณเลือกระเบียน {{num}} รายการแรกไว้',
    'TPL_LISTVIEW_SELECTED' => 'คุณเลือกระเบียนทั้งหมด {{num}} รายการในชุดผลลัพธ์ไว้',
    'TPL_LISTVIEW_SELECTED_ONE' => 'คุณได้เลือก 1 ระเบียนในชุดผลลัพธ์',
    'TPL_LISTVIEW_SELECTED_ALL' => 'คุณเลือกระเบียนทั้งหมด {{num}} รายการในชุดผลลัพธ์ไว้',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'คุณเลือกระเบียนทั้ง {{num}} รายการในมุมมองนี้ {{link}} ในชุดผลลัพธ์',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'กำลังอัปเดต {{num}} จาก {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(เหลืออีกประมาณ {{time}} {{unit}})',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'การอัปเดตเป็นกลุ่มล้มเหลว กำลังเริ่มต้นการลองซ้ำ ({{num}} จาก {{total}})',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'การอัปเดตเป็นกลุ่มไม่สมบูรณ์ {{num}} ระเบียนไม่มีการเปลี่ยนแปลง',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'การอัปเดตเป็นกลุ่มไม่สมบูรณ์ {{num}} ระเบียนไม่มีการเปลี่ยนแปลง',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => 'การบันทึก{{remain}} ถูกละเลยเนื่องจากการอนุญาตหรือข้อผิดพลาด',
    'TPL_MASSUPDATE_SUCCESS' => 'อัปเดต {{num}} ระเบียนสำเร็จแล้ว',
    'TPL_MASSUPDATE_TITLE' => 'การอัปเดตเป็นกลุ่มสำหรับ {{module}}',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'กำลังลบ {{num}} จาก {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(เหลืออีกประมาณ {{time}} {{unit}})',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'การลบเป็นกลุ่มล้มเหลว กำลังเริ่มต้นการลองซ้ำ ({{num}} จาก {{total}})',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'การลบเป็นกลุ่มไม่สมบูรณ์ {{num}} ระเบียนไม่มีการเปลี่ยนแปลง',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'การลบเป็นกลุ่มไม่สมบูรณ์ {{num}} ระเบียนไม่มีการเปลี่ยนแปลง',
    'TPL_MASSDELETE_SUCCESS' => 'ลบ {{num}} ระเบียนสำเร็จแล้ว',
    'TPL_MASSDELETE_TITLE' => 'ลบเป็นกลุ่มสำหรับ {{module}}',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'กำลังเพิ่ม {{num}} จาก {{total}}',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(เหลืออีกประมาณ {{time}} {{unit}})',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'การเพิ่มเป็นกลุ่มไปยังรายการเป้าหมายล้มเหลว กำลังเริ่มต้นการลองซ้ำ ({{num}} จาก {{total}})',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'การเพิ่มเป็นกลุ่มไปยังรายการเป้าหมายไม่สมบูรณ์ ไม่ได้เพิ่ม {{num}} ระเบียน',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'การเพิ่มเป็นกลุ่มไปยังรายการเป้าหมายไม่สมบูรณ์ ไม่ได้เพิ่ม {{num}} ระเบียน',
    'TPL_MASSADDTOLIST_SUCCESS' => 'เพิ่ม {{num}} ระเบียนสำเร็จแล้ว',
    'TPL_MASSADDTOLIST_TITLE' => 'เพิ่มเป็นกลุ่มไปยังรายการเป้าหมายสำหรับ {{module}}',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'กำลังเชื่อมโยง {{num}} จาก {{total}}',
    'TPL_MASSLINK_DURATION_FORMAT' => '(เหลืออีกประมาณ {{time}} {{unit}})',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'การเชื่อมโยงเป็นกลุ่มล้มเหลว กำลังเริ่มต้นการลองซ้ำ ({{num}} จาก {{total}})',
    'TPL_MASSLINK_WARNING_CLOSE' => 'การเชื่อมโยงเป็นกลุ่มไม่สมบูรณ์ ไม่ได้เพิ่ม {{num}} ระเบียน',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'การเชื่อมโยงเป็นกลุ่มไม่สมบูรณ์ ไม่ได้เพิ่ม {{num}} ระเบียน',
    'TPL_MASSLINK_SUCCESS' => 'เชื่อมโยง {{num}} ระเบียนสำเร็จแล้ว',
    'TPL_MASSLINK_TITLE' => 'การเชื่อมโยงเป็นกลุ่มสำหรับ {{module}}',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'เลือก',
    'LBL_LISTVIEW_ACTIONS' => 'การดำเนินการ',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'เลือกระเบียนทั้งหมดในหน้านี้',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'ยกเลิกการเลือกระเบียนทั้งหมดในหน้านี้',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} จาก {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '{{num}} กำลังโหลด...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'คลิกเพื่อดูยอดรวม',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'จาก',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'รับหมายเลขหน้า',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'เดวิด',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'ลิฟวิงสโตน',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'ดร.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Code Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => 'โปรดเข้าสู่ระบบเพื่อเข้าถึงพื้นที่นี้',
    'LBL_LOGOUT' => 'ล็อกเอาต์',
    'LBL_FINISH_IMPERSONATING' => 'จบการแสดงบทบาท',
    'LBL_RESET_MFA' => 'รีเซ็ตการยืนยันตัวตนหลายปัจจัย',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}} คุณกำลังเลียนแบบ {{user}} อยู่ในขณะนี้',
    'LBL_PROFILE' => 'โปรไฟล์',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'จดหมายเวียน',
    'LBL_MASS_UPDATE' => 'การอัปเดตเป็นกลุ่ม',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'เลือกระเบียนทั้งหมดเพื่ออัปเดตเป็นกลุ่ม',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'รวมระเบียนที่อัปเดตเป็นกลุ่มเข้าด้วย',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'เพิ่มฟิลด์',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'นำฟิลด์ออก',
    'LBL_GENERATE_QUOTE' => 'สร้างการเสนอราคา',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'ไม่มีฟิลด์ที่ใช้ได้สำหรับการอัปเดตเป็นกลุ่ม',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'คำขออัปเดตเป็นกลุ่มของคุณได้รับการวางกำหนดการแล้ว',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'วันที่เริ่มบริการมีค่าเกินระยะวันที่สิ้นสุดการบริการ',
    'LBL_MASS_UPDATE_SUCCESS' => 'อัปเดตระเบียนทั้งหมดสำเร็จแล้ว',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'ระเบียนที่เลือกถูกเพิ่มในรายการเป้าหมาย <a href="{{listUrl}}">{{listName}}</a> แล้ว',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'คำขอเพิ่มระเบียนที่เลือกไปยังรายการเป้าหมาย <a href="{{listUrl}}">{{listName}}</a> ได้รับการวางกำหนดการแล้ว',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'การอัปเดตจะนำค่าต่อไปนี้ออก: ',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'ยกเลิกเพื่อเก็บค่าที่มีอยู่ไว้ ยืนยันเพื่อนำค่าออก',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'อีเมลหลักของการเลือกออก',
    'LBL_MEETINGS' => 'การประชุม',
    'LBL_MEETING' => 'การประชุม',
    'LBL_MEETING_GO_BACK' => 'กลับไปที่การประชุม',
    'LBL_MEMBERS' => 'สมาชิก',
    'LBL_MEMBER_OF' => 'สมาชิกของ',
    'LBL_MODIFIED_BY_USER' => 'แก้ไขโดยผู้ใช้',
    'LBL_MODIFIED_USER' => 'แก้ไขโดยผู้ใช้',
    'LBL_MODIFIED' => 'แก้ไขโดย',
    'LBL_MODIFIED_NAME' => 'แก้ไขโดย',
    'LBL_MODIFIED_ID' => 'แก้ไขโดย ID',
    'LBL_MORE' => 'เพิ่มเติม',
    'LBL_MORE_MODULES' => 'โมดูลเพิ่มเติม',
    'LBL_MORE_TABS' => 'แท็บเพิ่มเติม',
    'LBL_MULTIPLE_MODULES' => 'หลายโมดูล',
    'LBL_COUNT_MODULES' => '{{count}} โมดูล',
    'LBL_MY_ACCOUNT' => 'การตั้งค่าของฉัน',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'ค่าเริ่มต้นของระบบ',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'ค่าเริ่มต้นของผู้ใช้',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'บัญชีผู้ใช้',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'บัญชีกลุ่ม',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'ชื่อ',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'สร้าง',
    'LBL_NEW_BUTTON_TITLE' => 'สร้าง',
    'LBL_NEXT_BUTTON_LABEL' => 'ถัดไป',
    'LBL_NOTES' => 'บันทึก',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'เปิดทั้งหมด',
    'LBL_OPENALL_BUTTON_TITLE' => 'เปิดทั้งหมด',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'เปิดไปที่: ',
    'LBL_OPENTO_BUTTON_TITLE' => 'เปิดไปที่:',
    'LBL_OPEN_IN_NEW_TAB' => 'เปิดในแท็บใหม่',
    'LBL_OPPORTUNITIES' => 'โอกาสทางการขาย',
    'LBL_OPPORTUNITY_NAME' => 'ชื่อโอกาสทางการขาย',
    'LBL_OPPORTUNITY' => 'โอกาสทางการขาย',
    'LBL_OR' => 'หรือ',
    'LBL_LOWER_OR' => 'หรือ',
    'LBL_PANEL_ASSIGNMENT' => 'อื่นๆ',
    'LBL_PANEL_ADVANCED' => 'ข้อมูลเพิ่มเติม',
    'LBL_PANEL_BODY' => 'ภาพรวม',
    'LBL_PARENT_TYPE' => 'ประเภทหลัก',
    'LBL_RELATED_TYPE' => 'ประเภทที่เกี่ยวข้อง',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'ช่วง',
    'LBL_PICTURE_FILE' => 'อวาตาร์',
    'LBL_POSTAL_CODE' => 'รหัสไปรษณีย์:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'เมืองของที่อยู่หลัก:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'ประเทศของที่อยู่หลัก:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'รหัสไปรษณีย์ของที่อยู่หลัก:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'รัฐของที่อยู่หลัก:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'ถนนของที่อยู่หลัก 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'ถนนของที่อยู่หลัก 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'ถนนของที่อยู่หลัก:',
    'LBL_PRIMARY_ADDRESS' => 'ที่อยู่หลัก:',

    'LBL_BILLING_STREET' => 'ถนน:',
    'LBL_SHIPPING_STREET' => 'ถนน:',

    'LBL_PRODUCT_BUNDLES' => 'ชุดผลิตภัณฑ์',
    'LBL_PRODUCTS' => 'ผลิตภัณฑ์',
    'LBL_PROJECT_TASKS' => 'งานของโครงการ',
    'LBL_PRODUCT_TEMPLATES' => 'เทมเพลทผลิตภัณฑ์',
    'LBL_PROJECTS' => 'โครงการ',
    'LBL_PROSPECTS' => 'เป้าหมาย',
    'LBL_QUICK_CREATE_MENU' => 'เมนูสร้างแบบด่วน',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'สร้างโอกาสทางการขายจากการเสนอราคา',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'สร้างโอกาสทางการขายจากการเสนอราคา',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'กำลังสร้างโอกาสทางการขาย...',
    'LBL_QUOTES_SHIP_TO' => 'ที่อยู่จัดส่งของการเสนอราคา',
    'LBL_QUOTES' => 'การเสนอราคา',

    'LBL_FORECAST_WORKSHEETS' => 'เวิร์กชีทประมาณการ',
    'LBL_FORECAST_WORKSHEET' => 'เวิร์กชีทประมาณการ',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'เชิญ',
    'LBL_INVITED' => 'เชิญแล้ว',
    'LBL_RECOMMENDED_INVITES' => 'การเชิญที่แนะนำ',
    'LBL_INSTANCES' => 'อินสแตนซ์',
    'LBL_YOUR_INSTANCES' => 'อินสแตนซ์ของคุณ',
    'LBL_INSTANCE_USERS' => 'ผู้ใช้อินสแตนซ์',
    'LBL_SWITCH_INSTANCE' => 'สลับไปที่อินสแตนซ์นี้',
    'LBL_LAST_LOGIN' => 'ล็อกอินครั้งล่าสุด',
    'LBL_ENTER_EMAIL' => 'ป้อนอีเมลผู้รับเชิญ...',
    'LBL_INSTANCE_IN_USE' => 'อินสแตนซ์อยู่ระหว่างการใช้งาน',
    'LBL_INSTANCE_ACTIVE' => 'คุณใช้อินสแตนซ์นี้อยู่แล้ว!',
    'LBL_INSTANCE_INVITE_SENT' => 'ส่งคำเชิญไปที่',
    'LBL_INSTANCE_SWITCH_FAILED' => 'ไม่สามารถเปลี่ยนอินสแตนซ์',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'การเตือน',
    'LBL_REMINDERS_OVERDUE' => 'เกินกำหนด',
    'LBL_REMINDERS_UPCOMING' => 'กำลังจะมาถึง',
    'LBL_REMINDERS_NONE_FOUND' => 'ไม่พบการเตือน',
    'LBL_REMINDERS_FINISHED' => 'เสร็จสิ้น!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'เมตริกโอกาสทางการขาย',

    'LBL_SWEETSPOT' => 'จุดที่เหมาะสม',
    'LBL_SWEETSPOT_CONFIG' => 'แผงการกำหนดค่าจุดที่เหมาะสม',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'แป้นพิมพ์ลัด',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'ไม่สามารถอัปเดตการกำหนดค่า: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'การดำเนินการของจุดที่เหมาะสม',
    'LBL_SWEETSPOT_KEY' => 'คำหลัก',
    'LBL_SWEETSPOT_REMOVE' => 'การนำออก',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'แป้นพิมพ์ลัด',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'การดำเนินการ',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'ระเบียน',
    'LBL_SWEETSPOT_THEME' => 'ธีม',
    'LBL_SWEETSPOT_THEME_SELECT' => 'เลือกธีม',

    'LBL_RELATED' => 'เกี่ยวข้อง',
    'LBL_RELATED_INFORMATION' => 'ข้อมูลที่เกี่ยวข้อง',
    'LBL_RELATED_RECORDS' => '{{module}} ที่เกี่ยวข้อง',
    'LBL_REPORTS_TO' => 'ผู้บังคับบัญชา',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'แสดงว่าเป็นฟิลด์ที่ต้องระบุ',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'เสร็จสิ้น',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'บันทึกเป็น',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'บันทึกเป็น',
    'LBL_FULL_FORM_BUTTON_KEY' => 'L',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'ฟอร์มแบบเต็ม',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'ฟอร์มแบบเต็ม',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'บันทึกและสร้างใหม่',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'บันทึกและสร้างใหม่',
    'LBL_SAVE_OBJECT' => 'บันทึก {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'ค้นหา',
    'LBL_SEARCH_BUTTON_TITLE' => 'ค้นหา',
    'LBL_SEARCH' => 'ค้นหา',
    'LBL_SEARCH_TIPS' => 'กดปุ่มค้นหาหรือคลิก Enter เพื่อดูรายการที่ตรงกันทั้งหมด',
    'LBL_SEARCH_TIPS_2' => 'กดปุ่มค้นหาหรือคลิก Enter เพื่อดูรายการที่ตรงกันทั้งหมดสำหรับ',
    'LBL_SEARCH_MORE' => 'เพิ่มเติม',
    'LBL_SEE_ALL' => 'ดูทั้งหมด',
    'LBL_SEARCH_LOAD_MORE' => 'โหลดเพิ่มเติม',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'รูปแบบไฟล์ไม่ถูกต้อง สามารถอัปโหลดเฉพาะไฟล์รูปภาพเท่านั้น',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'ไม่สนับสนุนรูปแบบรูปภาพ {0} ในขณะนี้',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'เลือก',
    'LBL_SELECT_BUTTON_TITLE' => 'เลือก',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'เพิ่มทีม',
    'LBL_SELECT_TEAMS_TITLE' => 'เพิ่มทีม',
    'LBL_SELECT_APPEND_TEAMS' => 'ต่อท้ายทีม',
    'LBL_SELECT_APPEND_VALUES' => 'ต่อท้ายค่า',
    'LBL_SELECT_APPEND_TAGS' => 'ต่อท้ายแท็ก',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'เรียกดูเอกสาร',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'เรียกดูเอกสาร',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'เลือกที่อยู่ติดต่อ',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'เลือกที่อยู่ติดต่อ',
    'LBL_GRID_SELECTED_FILE' => 'ไฟล์ที่เลือก',
    'LBL_GRID_SELECTED_FILES' => 'ไฟล์ที่เลือก',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'เลือกจากรายงาน',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'เลือกรายงาน',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'เลือกผู้ใช้',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'เลือกผู้ใช้',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'ล้างการเลือก',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'ล้างการเลือก',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'ล้างการเลือก',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'ล้างการเลือก',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'เลือกไฟล์',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'เลือกไฟล์',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'ล้างไฟล์',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'ล้างไฟล์',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'เลือกผู้ใช้',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'เลือกผู้ใช้',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'ล้างข้อมูลผู้ใช้',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'ล้างข้อมูลผู้ใช้',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'เลือกบัญชี',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'เลือกบัญชี',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'ล้างบัญชี',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'ล้างบัญชี',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'เลือกแคมเปญ',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'เลือกแคมเปญ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'ล้างแคมเปญ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'ล้างแคมเปญ',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'เลือกที่อยู่ติดต่อ',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'เลือกที่อยู่ติดต่อ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'ล้างที่อยู่ติดต่อ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'ล้างที่อยู่ติดต่อ',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'เลือกทีม',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'เลือกทีม',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'ล้างข้อมูลทีม',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'ล้างข้อมูลทีม',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'ทรัพยากรที่ใช้ในการสร้างเพจนี้ (การสืบค้น, ไฟล์)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'วินาที',
    'LBL_SERVER_RESPONSE_TIME' => 'เวลาตอบสนองของเซิร์ฟเวอร์:',
    'LBL_SERVER_MEMORY_BYTES' => 'ไบต์',
    'LBL_SERVER_MEMORY_USAGE' => 'การใช้หน่วยความจำของเซิร์ฟเวอร์: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'การใช้งาน: - โมดูล: {0} - การดำเนินการ: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'การใช้งานหน่วยความจำสูงสุดของเซิร์ฟเวอร์: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'บัญชีที่ส่งสินค้า',
    'LBL_SHIP_TO_CONTACT' => 'ที่อยู่ติดต่อที่ส่งสินค้า',
    'LBL_SHIPPING_ADDRESS' => 'ที่อยู่ในการส่งสินค้า',
    'LBL_SHORTCUTS' => 'ทางลัด',
    'LBL_SHOW' => 'แสดง',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'รัฐ:',
    'LBL_STATUS_UPDATED' => 'อัปเดตสถานะของคุณสำหรับเหตุการณ์นี้แล้ว!',
    'LBL_STATUS_NOT_UPDATED' => 'ยังไม่ได้อัปเดตสถานะของคุณสำหรับเหตุการณ์นี้',
    'LBL_STATUS' => 'สถานะ:',
    'LBL_STREET' => 'ถนน',
    'LBL_SUBJECT' => 'เรื่อง',

    'LBL_INBOUNDEMAIL_ID' => 'ID อีเมลขาเข้า',
    'LBL_EAMP_ID' => 'การให้อนุญาต ID โทเค่น',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'สงวนลิขสิทธิ์<br />SugarCRM, Sugar และลูกบาศก์ 3-D เป็นเครื่องหมายการค้าจดทะเบียนของ SugarCRM Inc. ' .
        'ชื่อบริษัทและผลิตภัณฑ์อื่นๆ ทั้งหมดที่ใช้หรือปรากฏในผลิตภัณฑ์นี้อาจเป็นเครื่องหมายการค้าของ' .
        'บริษัทที่เกี่ยวข้องนั้นๆ',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'งานตามกำหนดการเสร็จสมบูรณ์แล้ว',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'งานตามกำหนดการทำงานสำเร็จแล้ว',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'เปิดใช้งานรายการบรรทัดรายได้ในอินสแตนซ์ Sugar ของคุณแล้ว',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'ขณะนี้มีการเปิดใช้งานรายการบรรทัดรายได้ในอินสแตนซ์ Sugar ของคุณ และข้อมูลโอกาสทางการขายที่มีอยู่ทั้งหมดได้รับการประมวลผลแล้ว ขณะนี้อินสแตนซ์ของคุณพร้อมที่จะใช้งานกับรายการบรรทัดรายได้แล้ว สำหรับข้อมูลเพิ่มเติมเกี่ยวกับการเปลี่ยนแปลงที่ทำขึ้น โปรดดูที่ {{doc_url}}

ขอแสดงความนับถือ SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'ขณะนี้โมดูลประมาณการพร้อมใช้งานกับโอกาสทางการขายในอินสแตนซ์ Sugar ของคุณแล้ว',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'โมดูลประมาณการในอินสแตนซ์ Sugar ของคุณสามารถใช้งานได้กับโอกาสทางการขายแล้ว ข้อมูลการคอมมิตประมาณการสำหรับรายการบรรทัดรายได้ก่อนหน้านี้ทั้งหมดถูกนำออกแล้ว และอินสแตนซ์นี้พร้อมสำหรับการสร้างและคอมมิตประมาณการกับโอกาสทางการขายแล้ว สำหรับข้อมูลเพิ่มเติมเกี่ยวกับการเปลี่ยนแปลงที่ทำขึ้น โปรดดูที่ {{doc_url}}

ขอแสดงความนับถือ SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'ขณะนี้รายการบรรทัดรายได้ถูกปิดใช้งานในอินสแตนซ์ Sugar ของคุณแล้ว',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'ขณะนี้รายการบรรทัดรายได้ถูกปิดใช้งานในอินสแตนซ์ Sugar ของคุณ และข้อมูลรายการบรรทัดรายได้ที่มีอยู่ทั้งหมดได้รับการประมวลผลแล้ว ขณะนี้อินสแตนซ์ของคุณพร้อมที่จะใช้งานกับโอกาสทางการขาย สำหรับข้อมูลเพิ่มเติมเกี่ยวกับการเปลี่ยนแปลงที่ทำขึ้น โปรดดูที่ {{doc_url}}

ขอแสดงความนับถือ SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'เอกสารการกำหนดค่าโอกาสทางการขาย',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'ล็อกอิน',
    'LBL_LOGIN_WELCOME_TO' => 'ยินดีต้อนรับสู่',
    'LBL_LOGIN_OPTIONS' => 'ตัวเลือก',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'ลืมรหัสผ่าน?',
    'LBL_LOGIN_SUBMIT' => 'ส่ง',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'ล็อกอินไม่สำเร็จหลายครั้งเกินไป',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'คุณสามารถล็อกอินอีกภายใน ',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'วัน',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 'ชั่วโมง',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'นาที',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'วินาที',
    'LBL_LOGIN_ADMIN_CALL' => 'โปรดติดต่อผู้ดูแลระบบ',
    'LBL_LOGIN_USERNAME' => 'ชื่อผู้ใช้',
    'LBL_LOGIN_PASSWORD' => 'รหัสผ่าน',
    'LBL_LOGGED_OUT' => 'คุณออกจากระบบแล้ว',
    'LBL_LOGIN_FORM_LABEL' => 'แสดงฟอร์มล็อกอิน',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'กลับไปหน้าล็อกอิน',
    'LBL_LOGIN_INACTIVE_USER' => 'ผู้ใช้งานที่มีสถานะไม่ใช้งาน',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'ผู้ใช้พอร์ทัลหรือผู้ใช้กลุ่มไม่สามารถล็อกอินได้',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'แดชบอร์ด',
    'LBL_SYNC' => 'ซิงค์',
    'LBL_TASKS' => 'งาน',
    'LBL_TEAMS_LINK' => 'ทีม',
    'LBL_THEME_COLOR' => 'สี',
    'LBL_THEME_FONT' => 'แบบอักษร',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'วางกำหนดการประชุม',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'วางกำหนดการประชุม',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'เก็บถาวรอีเมล',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'เก็บถาวรอีเมล',
    'LBL_UNAUTH_ADMIN' => 'ไม่มีสิทธิ์ในการเข้าถึงการดูแลระบบ',
    'LBL_UNDELETE_BUTTON_LABEL' => 'ยกเลิกการลบ',
    'LBL_UNDELETE_BUTTON_TITLE' => 'ยกเลิกการลบ',
    'LBL_UNDELETE_BUTTON' => 'ยกเลิกการลบ',
    'LBL_UNDELETE' => 'ยกเลิกการลบ',
    'LBL_UNSYNC' => 'ยกเลิกการซิงค์',
    'LBL_UPDATE' => 'อัปเดต',
    'LBL_UPDATES' => 'อัปเดต',
    'LBL_USER_LIST' => 'รายชื่อผู้ใช้',
    'LBL_USER_MENU' => 'เมนูผู้ใช้',
    'LBL_USERS_SYNC' => 'การซิงค์ของผู้ใช้',
    'LBL_USERS' => 'ผู้ใช้',
    'LBL_USER' => 'ผู้ใช้',
    'LBL_CURRENT_USER' => 'ผู้ใช้ปัจจุบัน',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'กำลังตรวจสอบรายการอีเมลที่มีอยู่...',
    'LBL_VERIFY_PORTAL_NAME' => 'กำลังตรวจสอบชื่อพอร์ทัลที่มีอยู่...',
    'LBL_VIEW_IMAGE' => 'ดู',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'พิมพ์เป็น PDF',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'พิมพ์เป็น PDF',

    'LBL_KBDOCUMENTS' => 'ฐานความรู้',
    'ERR_EMPTY_NODE_NAME' => 'คุณไม่สามารถเพิ่มหมวดหมู่โดยไม่มีชื่อ',


    'LNK_ABOUT' => 'เกี่ยวกับ',
    'LNK_ADVANCED_SEARCH' => 'การค้นหาขั้นสูง',
    'LNK_BASIC_SEARCH' => 'การค้นหาขั้นต้น',
    'LNK_SEARCH_NO_RESULTS' => 'ไม่พบผลลัพธ์',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'ดูผลลัพธ์ทั้งหมด',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'แสดงทั้งหมด',
    'LNK_CLOSE' => 'ปิด',
    'LBL_MODIFY_CURRENT_SEARCH' => 'แก้ไขการค้นหาปัจจุบัน',
    'LNK_SAVED_VIEWS' => 'ตัวเลือกเลย์เอาต์',
    'LNK_DELETE_ALL' => 'ลบทั้งหมด',
    'LNK_DELETE' => 'ลบ',
    'LNK_EDIT' => 'แก้ไข',
    'LNK_VIEW' => 'ดู',
    'LNK_GET_LATEST' => 'รับข้อมูลล่าสุด',
    'LNK_GET_LATEST_TOOLTIP' => 'แทนที่ด้วยเวอร์ชันล่าสุด',
    'LNK_HELP' => 'ความช่วยเหลือ',
    'LNK_CREATE' => 'สร้าง',
    'LNK_CREATE_WHEN_EMPTY' => 'สร้างระเบียนทันที',
    'LNK_LIST_END' => 'สิ้นสุด',
    'LNK_LIST_NEXT' => 'ถัดไป',
    'LNK_LIST_PREVIOUS' => 'ก่อนหน้า',
    'LNK_LIST_RETURN' => 'กลับไปที่รายการ',
    'LNK_LIST_START' => 'เริ่มต้น',
    'LNK_LOAD_SIGNED' => 'ลงชื่อ',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'แทนที่ด้วยเอกสารที่ลงชื่อ',
    'LNK_PRINT' => 'พิมพ์',
    'LNK_BACKTOTOP' => 'กลับไปที่ด้านบน',
    'LNK_REMOVE' => 'นำออก',
    'LNK_RESUME' => 'ทำงานต่อ',
    'LNK_VIEW_CHANGE_LOG' => 'ดูรายงาน Audit Log',
    'TPL_AUDIT_LOG_TITLE' => 'รายงาน Audit Log สำหรับ {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'คลิกเพื่อดูบันทึกการตรวจสอบที่อยู่อีเมล',
    'LBL_NO_SEARCH_RESULTS' => 'ไม่เจอผลลัพธ์การค้นหาของคุณ',
    'NTC_CLICK_BACK' => 'โปรดคลิกปุ่มย้อนกลับของเบราว์เซอร์และแก้ไขข้อผิดพลาด',
    'NTC_DATE_FORMAT' => '(yyyy-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(yyyy-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'คุณแน่ใจหรือไม่ว่าต้องการลบระเบียนที่เลือกไว้',
    'NTC_TEMPLATE_IS_USED' => 'เทมเพลทนี้มีการใช้งานในระเบียนการตลาดทางอีเมลอย่างน้อยหนึ่งรายการ คุณแน่ใจหรือไม่ว่าต้องการลบ',
    'NTC_TEMPLATES_IS_USED' => "เทมเพลทต่อไปนี้มีการใช้งานในระเบียนการตลาดทางอีเมล คุณแน่ใจหรือไม่ว่าต้องการลบ\n",
    'NTC_DELETE_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการลบระเบียนนี้',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'คุณแน่ใจหรือไม่ว่าต้องการลบ {0}',
    'LBL_METRIC_DELETE_WARNING' => 'ผู้ใช้ทุกคนได้รับการแชร์แท็บเมตริกนี้จะสูญเสียการเข้าถึงด้วย',
    'NTC_DELETE_CONFIRMATION_NUM' => 'คุณแน่ใจหรือไม่ว่าต้องการลบ ',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'คุณแน่ใจหรือไม่ว่าต้องการอัปเดต ',
    'NTC_DELETE_SELECTED_RECORDS' => ' ระเบียนที่เลือกไว้',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'ตัวกรองนี้จะถูกนำออกจากมุมมองทั้งหมด ซึ่งรวมถึงการกำหนดค่าข้อมูลสำหรับส่วนข้อมูล คุณแน่ใจหรือไม่ว่าต้องการลบตัวกรองนี้',
    'TPL_DELETE_FILTER_SUCCESS' => 'คุณลบตัวกรอง {{name}} แล้ว',
    'NTC_DELETE_SUCCESS' => 'คุณลบ {0} แล้ว',
    'NTC_UNLINK_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการยกเลิกการเชื่อมโยงระเบียนนี้',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'คุณแน่ใจหรือไม่ว่าต้องการยกเลิกการเชื่อมโยง {0}',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการยกเลิกการลิงก์ {0} การกระทำนี้จะเป็นการลบลิงก์ออกจากฟิลด์ผู้ติดต่อหลักอีกด้วย',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => 'ไม่สามารถยกเลิกลิงก์สำหรับ {0} ได้เพราะพวกเขาเป็นผู้ติดต่อหลักในเคสนี้ โปรดอัปเดตฟิลด์ผู้ติดต่อหลักก่อนที่จะยกเลิกลิงก์ระเบียน',
    'NTC_UNLINK_SUCCESS' => 'คุณเลิกเชื่อมโยง {0} แล้ว',
    'NTC_LOGIN_MESSAGE' => 'โปรดป้อนชื่อผู้ใช้และรหัสผ่าน',
    'NTC_NO_ITEMS_DISPLAY' => 'ไม่มี',
    'NTC_REMOVE_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการนำความสัมพันธ์นี้ออก ระบบจะนำออกเฉพาะความสัมพันธ์ โดยไม่ลบระเบียน',
    'NTC_REQUIRED' => 'แสดงว่าเป็นฟิลด์ที่ต้องระบุ',
    'NTC_SUPPORT_SUGARCRM' => 'สนับสนุนโครงการโอเพนซอร์สของ SugarCRM ด้วยการบริจาคผ่าน PayPal ทำได้รวดเร็ว ไม่มีค่าธรรมเนียม และปลอดภัย',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'ยินดีต้อนรับ',
    'NTC_YEAR_FORMAT' => '(yyyy)',
    'LOGIN_LOGO_ERROR' => 'โปรดแทนที่โลโก้ SugarCRM',
    'FATAL_LICENSE_ALTERED' => 'ใบอนุญาตของคุณถูกแก้ไขหลังจากการตรวจสอบครั้งล่าสุด',
    'ERROR_FULLY_EXPIRED' => "ใบอนุญาตของบริษัทคุณสำหรับ SugarCRM หมดอายุเป็นเวลามากกว่า 7 วันแล้วและจะต้องมีการอัปเดต มีเพียงผู้ดูแลระบบเท่านั้นที่สามารถล็อกอิน",
    'ERROR_LICENSE_EXPIRED' => "ใบอนุญาตของบริษัทคุณสำหรับ SugarCRM หมดอายุแล้ว และจะต้องมีการอัปเดต มีเพียงผู้ดูแลระบบเท่านั้นที่สามารถล็อกอิน",
    'WARN_LICENSE_EXPIRED' => "ใบอนุญาตของบริษัทคุณสำหรับ SugarCRM ใกล้หมดอายุแล้ว",
    'ERROR_LICENSE_VALIDATION' => "ใบอนุญาตของบริษัทคุณสำหรับ SugarCRM ต้องมีการตรวจสอบ มีเพียงผู้ดูแลระบบเท่านั้นที่สามารถล็อกอิน",
    'WARN_LICENSE_VALIDATION' => "ใบอนุญาตของบริษัทคุณสำหรับ SugarCRM จะเป็นต้องมีผ่านการตรวจสอบในเร็วๆ นี้",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>คำเตือน:</b> เบราว์เซอร์ของคุณอยู่ในมุมมองความเข้ากันได้กับ IE ซึ่งระบบไม่สนับสนุน',
    'WARN_LICENSE_SEATS' => 'คำเตือน: จำนวนผู้ใช้ที่ใช้งานเท่ากับจำนวนใบอนุญาตสูงสุดที่ใช้ได้แล้ว',
    'WARN_LICENSE_SEATS_MAXED' => 'คำเตือน: จำนวนผู้ใช้ที่ใช้งานเกินจำนวนใบอนุญาตสูงสุดที่ใช้ได้แล้ว',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'จำนวนผู้ใช้งานเกินขีดจำกัดจำนวนใบอนุญาต กรุณาติดต่อผู้ดูแลระบบของคุณ',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'มีเพียงผู้ดูแลระบบเท่านั้นที่สามารถลงชื่อเข้าใช้งานได้',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'จำนวนผู้ใช้ใบอนุญาตมีปริมาณถึงขีดจำกัดแล้ว ผู้ใช้ที่มีอยู่เท่านั้นที่จะสามารถลงชื่อเข้าใช้ได้',
    'WARN_ONLY_ADMINS' => 'มีเพียงผู้ดูแลระบบเท่านั้นที่สามารถลงชื่อเข้าใช้งานได้',
    'WARN_UNSAVED_CHANGES' => 'คุณกำลังจะออกจากระเบียนนี้โดยไม่บันทึกการเปลี่ยนแปลงที่ทำไว้กับระเบียน คุณแน่ใจหรือไม่ว่าต้องการออกจากระเบียนนี้',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'การรีเฟรชเบราว์เซอร์จะเป็นการปิดสายเรียกเข้า SugarLive หรือรอบการสนทนาที่คุณเปิดไว้โดยอัตโนมัติ การเปลี่ยนแปลงใด ๆ ที่ไม่ได้บันทึกไว้จะสูญหาย คุณต้องการดำเนินการต่อไปหรือไม่',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'คุณมีการเปลี่ยนแปลงที่ยังไม่ได้บันทึก คุณต้องการออกจากเพจและยกเลิกการเปลี่ยนแปลงหรือไม่',
    'LBL_MFA_RESET_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการรีเซ็ต <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">การยืนยันตนหลายปัจจัย</a>ของคุณ 
การกระทำนี้จะพาคุณออกจากระบบทันที และคุณจะต้องยืนยันตนโดยใช้แอปยืนยันตนในการเข้าระบบครั้งต่อไป',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'ยืนยันและเข้าระบบ',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'ส่วนข้อมูลหนึ่งหรือมากกว่าหนึ่งแห่งมีการเปลี่ยนแปลงที่ยังไม่ได้บันทึก',
    'LBL_NAVIGATE_TO_REPORTS' => 'คุณกำลังย้ายไปที่โมดูลรายงาน การเปลี่ยนแปลงในส่วนข้อมูลจะไม่ได้รับการบันทึก ต้องการดำเนินการต่อหรือไม่',
    'ERROR_NO_RECORD' => 'เกิดข้อผิดพลาดในการเรียกระเบียน ระเบียนนี้อาจะถูกลบแล้วหรือคุณไม่ได้รับอนุญาตให้ดู',
    'ERROR_TYPE_NOT_VALID' => 'ข้อผิดพลาด ประเภทไม่ถูกต้อง',
    'ERROR_MAX_FIELD_LENGTH' => 'ข้อผิดพลาด ความยาวสูงสุดของฟิลด์นี้คือ {{this}}',
    'ERROR_MIN_FIELD_LENGTH' => 'ข้อผิดพลาด ความยาวขั้นต่ำของฟิลด์นี้คือ {{this}}',
    'ERROR_EMAIL' => 'เกิดข้อผิดพลาด ที่อยู่อีเมลไม่ถูกต้อง: {{#each this}}{{{this}}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'เกิดข้อผิดพลาด ควรตั้งค่าที่อยู่อีเมลหลักอย่างน้อยหนึ่งรายการ',
    'ERROR_DUPLICATE_EMAIL' => 'เกิดข้อผิดพลาด ที่อยู่อีเมลซ้ำกัน: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'ข้อผิดพลาด ฟิลด์นี้เป็นฟิลด์ที่ต้องระบุ',
    'ERROR_MINVALUE' => 'ข้อผิดพลาด ค่าต่ำสุดของฟิลด์นี้คือ {{this}}',
    'ERROR_MAXVALUE' => 'ข้อผิดพลาด ค่าสูงสุดของฟิลด์นี้คือ {{this}}',
    'ERROR_IS_GREATER_THAN' => 'ข้อผิดพลาด ค่าของฟิลด์นี้ต้องมากกว่า {{this}}',
    'ERROR_IS_LESS_THAN' => 'ข้อผิดพลาด ค่าของฟิลด์นี้ต้องน้อยกว่า {{this}}',
    'ERROR_DATETIME' => 'ข้อผิดพลาด ฟิลด์นี้ต้องมีวันที่ที่ถูกต้อง',
    'ERROR_IS_BEFORE' => 'ข้อผิดพลาด วันที่ของฟิลด์นี้ต้องอยู่ก่อนวันที่ของฟิลด์ {{this}}',
    'ERROR_IS_AFTER' => 'ข้อผิดพลาด วันที่ของฟิลด์นี้ต้องอยู่หลังวันที่ของฟิลด์ {{this}}',
    'ERROR_TIME_IS_BEFORE' => 'ข้อผิดพลาด เวลาของฟิลด์นี้ต้องอยู่ก่อนถึงเวลาของฟิลด์ {{this}}',
    'ERROR_TIME_IS_AFTER' => 'ข้อผิดพลาด เวลาของฟิลด์นี้ต้องอยู่ก่อนถึงเวลาของฟิลด์ {{this}}',
    'ERROR_NUMBER' => 'ข้อผิดพลาด ฟิลด์นี้ต้องมีตัวเลขที่ถูกต้อง',
    'ERROR_INT' => 'ข้อผิดพลาด จำนวนเต็มไม่ถูกต้อง',
    'ERROR_URL' => 'มีข้อผิดพลาด URL ไม่ถูกต้อง',
    'ERROR_NO_BEAN' => 'ไม่สามารถเรียกบีน',
    'ERROR_ACCESS_MODULE' => 'คุณไม่มีสิทธิ์เข้าถึงโมดูลนี้',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'ไฟล์แนบนี้มีขนาดใหญ่เกินไป',
    'ERROR_UPLOAD_FAILED' => 'ข้อผิดพลาด ไม่สามารถอัปโหลดไฟล์นี้',
    'ERROR_UPLOAD_ACCESS_PD' => 'คุณไม่มีสิทธิ์ในการสร้าง [การกำหนดกระบวนการ] สำหรับโมดูลนี้',
    'ERROR_UPLOAD_ACCESS_BR' => 'คุณไม่มีสิทธิ์ในการสร้าง [กฎทางธุรกิจ] สำหรับโมดูลนี้',
    'ERROR_UPLOAD_ACCESS_ET' => 'คุณไม่มีสิทธิ์ในการสร้าง [เทมเพลตอีเมล] สำหรับโมดูลนี้',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'ข้อผิดพลาด คุณป้อนโอเปอเรเตอร์ที่ไม่สนับสนุน',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'ข้อผิดพลาด คุณป้อนโอเปอเรเตอร์ที่ไม่ถูกต้อง',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'ข้อผิดพลาด คุณป้อนตัวกรองที่ไม่ถูกต้อง',
    'ERROR_PA_UNSUPPORTED_FILE' => 'การนำเข้าล้มเหลว โปรดตรวจสอบล็อกของ Sugar เพื่อดูรายละเอียดเพิ่มเติม',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'การนำเข้าล้มเหลว ฟิลด์กลุ่มถูกล็อคบางส่วนในการกำหนดกระบวนการ' .
        ' ต้องปลดล็อคฟิลด์เหล่านี้ในการกำหนดกระบวนการ จึงจะสามารถอิมปอร์ตการกำหนดได้',
    'ERROR_EXP_DATE_LOW' => 'ข้อผิดพลาด วันที่หมดอายุต้องไม่อยู่ก่อนวันที่เผยแพร่',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'ข้อผิดพลาด สถานะอนุมัติต้องมีวันที่เผยแพร่',
    'ERROR_ACTIVE_DATE_EMPTY' => 'วันที่เผยแพร่ว่างเปล่า',
    'ERROR_ACTIVE_DATE_LOW' => 'ข้อผิดพลาด วันที่เผยแพร่ต้องอยู่หลังวันที่ปัจจุบัน',
    'LBL_DUP_MERGE' => 'ค้นหารายการซ้ำ',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'การตรวจสอบรายการซ้ำถูกปิดอยู่สำหรับ {{module}}',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'จัดการการสมัครรับข้อมูล',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'จัดการการสมัครรับข้อมูลสำหรับ ',
    'LBL_SUBSCRIBE' => 'สมัครรับข้อมูล',
    'LBL_UNSUBSCRIBE' => 'ยกเลิกการสมัคร',
    'LBL_CREATE_LINK_RECORD' => 'สร้างและเชื่อมโยงระเบียน',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'สร้างและเชื่อมโยงระเบียน',
    'LBL_LINK_FROM_REPORT_SUCCESS' => 'เชื่อมโยงแล้ว {{reportCount}} ระเบียน',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'ไม่มีระเบียนที่จะเชื่อมโยง',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'รายงานที่เลือกไว้ไม่ได้อ้างอิงประเภทโมดูลที่ถูกต้อง',
    'ERROR_EMPTY_LINK_MODULE' => 'โปรดเลือกความสัมพันธ์ก่อน',
    // Ajax status strings
    'LBL_LOADING' => 'กำลังโหลด...',
    'LBL_LOADING_NO_DOTS' => 'กำลังโหลด',
    'LBL_SEARCHING' => 'กำลังค้นหา...',
    'LBL_SEARCH_UNDERWAY' => 'กำลังค้นหา',
    'LBL_SAVING_LAYOUT' => 'กำลังบันทึกเลย์เอาต์...',
    'LBL_SAVED_LAYOUT' => 'บันทึกเลย์เอาต์แล้ว',
    'LBL_SAVED' => 'บันทึกแล้ว',
    'LBL_SAVING' => 'กำลังบันทึก',
    'LBL_FAILED' => 'ล้มเหลว!',
    'LBL_DISPLAY_COLUMNS' => 'แสดงคอลัมน์',
    'LBL_HIDE_COLUMNS' => 'ซ่อนคอลัมน์',
    'LBL_SEARCH_CRITERIA' => 'เกณฑ์การค้นหา',
    'LBL_SAVED_VIEWS' => 'มุมมองที่บันทึกไว้',
    'LBL_PROCESSING_REQUEST' => 'กำลังประมวลผล..',
    'LBL_REQUEST_PROCESSED' => 'เสร็จสิ้น',
    'LBL_AJAX_FAILURE' => 'Ajax ทำงานล้มเหลว',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'ค้นหา...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'การค้นหาที่บันทึกไว้',
    'LBL_SEARCH_POPULATE_ONLY' => 'ดำเนินการค้นหาโดยใช้ฟอร์มการค้นหาด้านบน',
    'LBL_SEARCH_NO_RESULTS' => 'ไม่พบผลลัพธ์สำหรับ ',
    'LBL_SEARCH_FOR' => 'ค้นหา ',
    'LBL_SEARCH_FOR_MORE' => 'ค้นหาเพิ่มเติม...',
    'LBL_SEARCH_SELECT' => 'เลือก...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'ค้นหาและเลือก...',
    'LBL_SEARCH_SELECT_MODULE' => 'เลือก {{module}}...',
    'LBL_DETAILVIEW' => 'มุมมองรายละเอียด',
    'LBL_LISTVIEW' => 'มุมมองรายการ',
    'LBL_EDITVIEW' => 'มุมมองแก้ไข',
    'LBL_SEARCHFORM' => 'ฟอร์มค้นหา',
    'LBL_SAVED_SEARCH_ERROR' => 'โปรดระบุชื่อสำหรับมุมมองนี้',
    'LBL_DISPLAY_LOG' => 'แสดงล็อก',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'สถานที่: ',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'คำอธิบาย: ',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'เริ่มต้น',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'คลิกตกลงเพื่อดูการโทรนี้ หรือคลิกยกเลิกเพื่อปิดข้อความ',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'คลิกตกลงเพื่อดูการประชุมนี้ หรือคลิกยกเลิกเพื่อปิดข้อความ',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'ไม่พบผลลัพธ์',
    'MSG_LIST_VIEW_NO_RESULTS' => 'ไม่พบผลลัพธ์สำหรับ <item1>',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'สร้าง <item1> เป็น <item2> ใหม่',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'ขณะนี้คุณไม่มีระเบียน <item1> บันทึกไว้ <item2> หรือ <item3> ทันที',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'ขณะนี้คุณไม่มีระเบียน <item1> บันทึกไว้ <item2> ทันที',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'คุณสามารถสร้าง <item1> จากรายการ <item2>. <item3> <item2>',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'เชิงบวก',
    'LBL_SENTIMENT_NEUTRAL' => 'ธรรมดา',
    'LBL_SENTIMENT_NEGATIVE' => 'เชิงลบ',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'ไม่มีการกำหนดค่าแท็บเมตริกใด ๆ',
    'LBL_NO_METRIC_VISIBLE' => 'ไม่มีแท็บเมตริกปรากฏให้เห็น',
    'LBL_MAKE_METRIC_VISIBLE' => 'เลือก "จัดระเบียบ" เพื่อทําให้แท็บเมตริกมองเห็นได้',
    'LBL_PLEASE_CONTACT_ADMIN' => 'โปรดติดต่อผู้ดูแลระบบของคุณ',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'คลิกที่นี่',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'เพิ่มในรายการโปรดของฉัน',
    'LBL_MARK_AS_FAVORITES' => 'ทำเครื่องหมายเป็นรายการโปรด',
    'LBL_CREATE_CONTACT' => 'สร้างที่อยู่ติดต่อ',
    'LBL_CREATE_NOTE' => 'สร้างบันทึก',
    'LBL_CREATE_OPPORTUNITY' => 'สร้างโอกาสทางการขาย',
    'LBL_SCHEDULE_CALL' => 'ล็อกการโทร',
    'LBL_SCHEDULE_CALL2' => 'การโทร',
    'LBL_SCHEDULE_MEETING' => 'วางกำหนดการประชุม',
    'LBL_SCHEDULE_MEETING2' => 'การประชุม',
    'LBL_CREATE_MESSAGE' => 'สร้างข้อความ',
    'LBL_CREATE_MESSAGE2' => 'ข้อความ',
    'LBL_CREATE_TASK' => 'สร้างงาน',
    'LBL_CREATE_TASK2' => 'งาน',
    'LBL_REMOVE_FROM_FAVORITES' => 'นำออกจากรายการโปรดของฉัน',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'บันทึก',
    'LBL_DOWNLOAD_ALL' => 'ดาวน์โหลดทั้งหมด',
    'LBL_DOWNLOAD_ONE' => 'ดาวน์โหลด',
    'LBL_ATTACHMENTS' => 'ไฟล์แนบ',
    'LBL_ADD_ATTACHMENT' => 'เรียกดู',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'สร้างฟอร์ม',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'บันทึกเว็บไปยังฟอร์มของผู้สนใจ',

    'LBL_PLEASE_SELECT' => 'โปรดเลือก',
    'LBL_REDIRECT_URL' => 'URL การเปลี่ยนเส้นทาง',
    'LBL_RELATED_CAMPAIGN' => 'แคมเปญที่เกี่ยวข้อง',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'เพิ่มฟิลด์ทั้งหมด',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'นำฟิลด์ทั้งหมดออก',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'รวมได้เฉพาะประเภทรูปภาพที่สนับสนุนต่อไปนี้: JPG, PNG',
    'LBL_REMOVE' => 'นำออก',
    'LBL_TRAINING' => 'การสนับสนุน',
    'ERR_DATABASE_CONN_DROPPED' => 'เกิดข้อผิดพลาดในการเรียกใช้การสืบค้น ฐานข้อมูลอาจตัดการเชื่อมต่อ โปรดรีเฟรชเพจนี้ คุณอาจต้องเริ่มต้นเว็บเซิร์ฟเวอร์ใหม่',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'เกิดข้อผิดพลาดในการตั้งค่า {0} ความสัมพันธ์: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'เปลี่ยนบริบทฐานข้อมูลเป็น',
    'ERR_MSSQL_WARNING' => 'คำเตือน:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'ไม่สามารถแยกวิเคราะห์รูปแบบ vCard',
    'ERR_VCARD_FILE_MISSING' => 'ไม่มีไฟล์ vcf',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'คำเตือน: ฟิลด์ [[field]] ไม่มีรายการที่แมปกันในไฟล์ [moduleDir] vardefs.php',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'ข้อผิดพลาด: ไฟล์ [[file]] ขาดหายไป ไม่สามารถสร้างเนื่องจากไม่พบไฟล์ HTML ที่ตรงกัน',
    'ERR_CANNOT_FIND_MODULE' => 'ข้อผิดพลาด: ไม่มีโมดูล [module]',
    'LBL_ALT_ADDRESS' => 'ที่อยู่อื่น:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'ข้อผิดพลาด: มีจำนวนอาร์กิวเมนต์ที่ไม่เท่ากันสำหรับอีลิเมนต์ &#39;key&#39; และ &#39;copy&#39; ในอาร์เรย์ displayParams',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'ไม่มีดัชนีในอาร์เรย์ displayParams สำหรับ: ',

    'LBL_DASHLET' => 'ส่วนข้อมูล',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'ตัวกรอง',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'รายการของฉันเท่านั้น',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'ชื่อเรื่อง',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'แสดงแถว',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'เชื่อมโยงกับระเบียนปัจจุบัน',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'ฟิลด์ที่เชื่อมโยง',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'ตรึงแนวคอลัมน์แรก',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'คุณแน่ใจหรือไม่ว่าต้องการนำส่วนข้อมูล Sugar ออก',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'คุณแน่ใจหรือไม่ว่าต้องการนำแถวนี้ออก',
    'LBL_MAXIMUM_OF' => 'จำนวนสูงสุด ',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => ' คอลัมน์สามารถแสดงผลได้',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'แดชบอร์ด',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'แดชบอร์ดของฉัน',
    'LBL_COLLAPSE_ALL' => 'ยุบทั้งหมด',
    'LBL_EXPAND_ALL' => 'ขยายทั้งหมด',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'แก้ไข',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'ดูรายงาน',
    'LBL_DASHLET_REFRESH_LABEL' => 'รีเฟรช',
    'LBL_DASHLET_REMOVE_LABEL' => 'นำออก',
    'LBL_DASHLET_DROP_HERE' => 'วางที่นี่',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'ปิด',
    'LBL_DASHLET_MAXIMIZE' => 'เปิด',
    'LBL_DASHLET_CONFIGURE' => 'กำหนดค่า',
    'LBL_DASHLET_TOGGLE' => 'เปิด/ปิด',
    'LBL_SIDEPANE_TOGGLE' => 'เปิด/ปิดช่องด้านข้าง',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'เรียกคืนส่วนข้อมูลเริ่มต้น',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'ไม่มีแดชบอร์ดใดได้รับการกำหนดค่า',
    'LBL_CREATE_DASHBOARD_LINK' => 'สร้างแดชบอร์ด',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'ความช่วยเหลือ',
    'LBL_HELPLET_TOGGLE' => 'เปิด/ปิด',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'โมดูล',
    'LBL_FACET_MODIFIED_BY_ME' => 'แก้ไขโดยฉัน',
    'LBL_FACET_CREATED_BY_ME' => 'สร้างโดยฉัน',
    'LBL_FACET_MY_FAVORITES' => 'รายการโปรดของฉัน',
    'LBL_FACET_ASSIGNED_TO_ME' => 'ระบุให้ฉัน',
    'LBL_FACET_NO_DATA' => 'ไม่มีข้อมูลสำหรับ Facet นี้',

    'LBL_DASHLET_LISTVIEW_NAME' => 'มุมมองรายการ',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'แสดงระเบียนจากโมดูลหนึ่งๆ ตามเกณฑ์ที่คุณกำหนด',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'มุมมองรายการคอนโซล',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'รายการระเบียนจากโมดูลเฉพาะที่เกี่ยวข้องกับระเบียนที่คุณกำลังดูอยู่ในคอนโซล',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'มุมมองระเบียน',
    'LBL_RELATED_RECORDS' => '{{module}} ที่เกี่ยวข้อง',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'แสดงระเบียนและระเบียนเกี่ยวข้องที่เลือกในแท็บ',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'ประเภทฐานระเบียน',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => '{{moduleSingular}} นี้',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'แท็บ',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'ตัวอย่างเลย์เอาต์พื้นฐาน',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'คำเตือน โมดูล {{numWord}} ({{num}}) เท่านั้นที่จะแสดงในแท็บ ' .
        'กรุณาลบหนึ่งโมดูลหรือมากกว่าก่อนที่จะเพิ่มโมดูลอื่น',
    'LBL_SIX' => 'หก', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'บันทึกความคิดเห็น',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'แสดงความเห็นสำหรับระเบียน',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'ไม่มีความคิดเห็นใดที่ใช้ได้',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'เพิ่ม',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'เพิ่มความคิดเห็น',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'ดูทั้งหมด',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'ไม่มีข้อมูล คุณไม่มีสิทธิ์เข้าถึงโมดูลเหล่านี้' .
    " \nโปรดอัปเดตหรือนำส่วนข้อมูลนี้ออก",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'ไม่มีข้อมูล คุณไม่มีสิทธิ์เข้าถึงโมดูลนี้' .
        " \nโปรดอัปเดตหรือนำส่วนข้อมูลนี้ออก",
    'TPL_DASHLET_MY_MODULE' => '{{module}} ของฉัน',
    'LBL_DASHLET_PICK_A_RECORD' => 'ไม่ได้เลือกแสดงระเบียนใด ๆ',
    'LBL_CONTENT_SEARCH_DASHLET' => 'ส่วนข้อมูลค้นหาเนื้อหา',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'วันนี้ให้ฉันช่วยอะไรคุณได้บ้าง {{username}}',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'คุณต้องการสร้างเคสหรือเปล่า',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'เมตริกโอกาสทางการขาย',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'เมตริคโอกาสทางการขายสำหรับบัญชีที่เกี่ยวข้อง',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'เลือกแคตตาล็อกผลิตภัณฑ์แบบรวดเร็ว',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'ทำรายการสิ่งของที่ถูกนำมาใช้ และผลิตภัณฑ์ที่ได้รับบันทึกเป็นรายการโปรดล่าสุด',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'ใช้ล่าสุด',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'รายการโปรด',

    'LBL_DASHBOARD_CREATE' => 'สร้างแดชบอร์ด',
    'LBL_DASHBOARD_DUPLICATE' => 'สร้างแดชบอร์ดที่เหมือนกัน',
    'LBL_DASHBOARD_DELETE' => 'ลบแดชบอร์ด',
    'LBL_PIN_TO_TOP' => 'ปักหมุดไว้ด้านบน',
    'LBL_PIN_TO_BOTTOM' => 'ปักหมุดไว้ด้านล่าง',
    'LBL_MANAGE_DASHBOARDS' => 'จัดการแดชบอร์ด',

    'LBL_DASHBOARD_CONFIG' => 'การกำหนดค่าแดชบอร์ด',
    'LBL_LIST_VIEW__NAME' => 'มุมมองแบบรายการ',
    'LBL_PIPELINE_VIEW_NAME' => 'มุมมองแบบแผ่นป้าย',
    'LBL_PIPELINE_VIEW_BTN' => 'มุมมองแบบแผ่นป้าย',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} โดย{{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'มุมมองแบบแผ่นป้ายไม่สามารถใช้งานได้',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'ไม่พบระเบียนในขณะนี้',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'สรุปเคส',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'ไทม์ไลน์',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'บันทึกและไฟล์แนบ',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'บันทึกและไฟล์แนบอยู่ในระเบียน',
    'LBL_DASHLET_PIPLINE_NAME' => 'กระบวนการขาย',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'ทวีตล่าสุด - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'ไม่มีแดชบอร์ดที่บันทึกไว้',

    'LBL_DNB_AND' => 'และ',
    'LBL_DNB_PRIM_NAME_DESC' => 'ข้อความที่บันทึกชื่อขององค์กรนี้',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'ตอบกลับ',
    'LBL_TWITTER_RETWEET' => 'ทวีตต่อ',
    'LBL_TWITTER_FAVORITE' => 'รายการโปรด',
    'LBL_TWITTER_FOLLOW' => 'ติดตาม',
    'LBL_TWITTER_DESCRIPTION' => 'ดูประวัติย่อและทวีต การทวีตต่อ และการตอบกลับทวีตของผู้ใช้ Twitter ที่ตรงกัน',
    'LBL_TWITTER_ID' => 'Twitter ID',
    'LBL_TWITTER_DISPLAY_ROWS' => 'แสดงแถว',
    'LBL_TWITTER_MY_ACCOUNT' => 'บัญชีของฉัน',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Tweet ที่มา:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'แหล่งข้อมูลเพื่อการเรียนรู้',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'การอบรมและใบรับรอง',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'ชุมชน SugarClub',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'เอกสารประกอบและความช่วยเหลือ',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'ตลาดแลกเปลี่ยน SugarOutfitters',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'การขายของแต่ละประเทศ',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'แสดงแผนภูมิการขายตามแผนที่ประเทศ',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'หมวดหมู่ฐานความรู้และบทความที่เผยแพร่',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'แสดงมุมมองแบบต้นไม้สำหรับหมวดหมู่ฐานความรู้และบทความที่เผยแพร่',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'การค้นหาฐานความรู้',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'แสดงมุมมองแบบต้นไม้ของบทความและหมวดหมู่ตามข้อมูลที่ได้รับการเผยแพร่',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'บทความที่เผยแพร่เป็นภาษาอื่นๆ',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'แสดงรายการบทความฐานความรู้ที่เผยแพร่และแปลเป็นภาษาต่างๆ',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'บทความฐานความรู้ที่เผยแพร่และเป็นประโยชน์มากที่สุด',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'แสดงบทความฐานความรู้ที่มีคนถูกใจและดูมากที่สุด',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} กรองตาม {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'ประโยชน์ของบทความ',
    'LBL_DASHLET_USEFULNESS_DESC' => 'แสดงแผนภูมิที่บอกว่าบทความฐานความรู้นั้นมีประโยชน์มากเพียงใด',

    'LBL_ADD_PAGE' => 'เพิ่มเพจ',
    'LBL_LOADING_PAGE' => 'กำลังโหลดเพจ โปรดรอสักครู่...',
    'LBL_SEARCH_RESULTS' => 'ผลการค้นหา',
    'LBL_SEARCH_RESULTS_FOR' => 'ผลการค้นหา: ',
    'LBL_SEARCH_HELP_TITLE' => 'เคล็ดลับการค้นหา',
    'LBL_SEARCH_RESULTS_FOUND' => 'พบผลการค้นหา',
    'LBL_SEARCH_RESULTS_TIME' => 'มิลลิวินาที',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'กระบวนการขายของฉัน',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "กระบวนการขายของทีม",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'แผนภูมิกระบวนการขาย',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'แสดงแผนภูมิกระบวนการขายปัจจุบัน',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'ไม่มีรูปภาพ',

    'LBL_MODULE' => 'โมดูล',
    'LBL_RELATIONSHIP' => 'ความสัมพันธ์',
    'LBL_SINGULAR_LABEL' => 'ป้ายกำกับรายการเดียว',
    'LBL_PLURAL_LABEL' => 'ป้ายกำกับหลายรายการ',
    'LBL_MODULE_DISPLAY' => 'แสดงผล',
    'LBL_MODULE_DISPLAY_TYPE' => 'ประเภทการแสดงผล',
    'LBL_MODULE_ICON' => 'ไอคอน',
    'LBL_MODULE_COLOR' => 'สีพื้นหลังของโมดูล',
    'LBL_LANGUAGE_SELECTOR' => 'ภาษา',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'การตั้งค่าโมดูล',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'บันทึกการตั้งค่าโมดูลแล้ว',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'คัดลอกที่อยู่จากด้านซ้าย:',
    'LBL_SAVE_AND_CONTINUE' => 'บันทึกและดำเนินการต่อ',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>การควบคุมโดยเลือกหลายรายการ</strong></p><ul><li>คลิกที่ค่าเพื่อเลือกแอททริบิว</li><li>Ctrl-คลิก&nbsp;เพื่อเลือกหลายรายการ ผู้ใช้ Mac ใช้ CMD-คลิก</li><li>ในการเลือกค่าทั้งหมดระหว่างสองแอททริบิว&nbsp; คลิกค่าแรก จากนั้นกด Shift-คลิกค่าสุดท้าย</li></ul><p><strong>ตัวเลือกการค้นหาและเลย์เอาต์ขั้นสูง</strong><br><br>ใช้ตัวเลือก <b>การค้นหาและเลย์เอาต์ที่บันทึกไว้</b> เพื่อบันทึกชุดของพารามิเตอร์การค้นหา และ/หรือเลย์เอาต์มุมมองรายการที่กำหนดเอง เพื่อให้ได้ผลการค้นหาที่ต้องการได้ในอนาคต คุณสามารถบันทึกการค้นหาและเลย์เอาต์ได้ไม่จำกัดจำนวน การค้นหาที่บันทึกทั้งหมดจะปรากฏตามชื่อในรายการการค้นหาที่บันทึกไว้ โดยมีการค้นหาที่บันทึกซึ่งโหลดล่าสุดอยู่ด้านบนสุดของรายการ <br><br>ในการปรับแต่งเลย์เอาต์ของมุมมองรายการ ให้ใช้ช่องซ่อนคอลัมน์และแสดงคอลัมน์เพื่อเลือกฟิลด์ที่จะแสดงในผลการค้นหา ตัวอย่างเช่น คุณสามารถดูหรือซ่อนรายละเอียด เช่น ชื่อระเบียน และผู้ใช้ที่ได้รับมอบหมาย และทีมที่ได้รับมอบหมายในผลการค้นหา ในการเพิ่มคอลัมน์ในมุมมองรายการ ให้เลือกฟิลด์จากรายการซ่อนคอลัมน์ และใช้ลูกศรซ้ายเพื่อย้ายไปยังรายการแสดงคอลัมน์ ในการนำคอลัมน์ออกจากมุมมองรายการ ให้เลือกคอลัมน์นั้นจากรายการแสดงคอลัมน์ และใช้ลูกศรขวาเพื่อย้ายไปยังรายการซ่อนคอลัมน์ <br><br>ถ้าคุณบันทึกการตั้งค่าเลย์เอาต์ คุณจะสามารถโหลดเลย์เอาต์นั้นได้ทุกเวลาเพื่อดูผลการค้นหาในเลย์เอาต์ที่กำหนดเอง<br><br>ในการบันทึกและอัปเดตการค้นหาและ/หรือเลย์เอาต์:<ol><li>ป้อนชื่อสำหรับผลการค้นหาในฟิลด์ <b>บันทึกการค้นหานี้เป็น</b> และคลิก <b>บันทึก</b> ชื่อดังกล่าวจะปรากฏในรายการการค้นหาที่บันทึก ติดกับปุ่ม <b>ล้าง</b></li><li>ในการดูการค้นหาที่บันทึก ให้เลือกการค้นหานั้นจากรายการการค้นหาที่บันทึก ผลการค้นหาจะปรากฏในมุมมองรายการ</li><li>ในการอัปเดตคุณสมบัติของการค้นหาที่บันทึก ให้เลือกการค้นหานั้นจากรายการ ป้อนเกณฑ์การค้นหาใหม่ และ/หรือ ตัวเลือกเลย์เอาต์ใหม่ในพื้นที่การค้นหาขั้นสูง และคลิก <b>อัปเดต</b> ถัดจาก <b>แก้ไขการค้นหาปัจจุบัน</b></li><li>ในการลบการค้นหาที่บันทึกไว้ ให้เลือกจากรายการการค้นหาที่บันทึก คลิก  <b>ลบ</b> ที่อยู่ถัดจาก <b>แก้ไขการค้นหาปัจจุบัน</b> จากนั้นคลิก <b>ตกลง</b> เพื่อยืนยันการลบ</li></ol><p><strong>เคล็ดลับ</strong><br><br>เมื่อใช้ % เป็นสัญลักษณ์การค้นหา คุณสามารถค้นหาในวงกว้างยิ่งขึ้น ตัวอย่างเช่น แทนที่จะค้นหาผลลัพธ์ที่เท่ากับ "Apples" คุณสามารถเปลี่ยนการค้นหาเป็น "Apples%" ซึ่งจะจับคู่กับผลลัพธ์ที่เริ่มต้นด้วยคำว่า Apples แต่มีอักขระอื่นด้วย</p>',

    //resource management
    'ERR_QUERY_LIMIT' => 'ข้อผิดพลาด: ถึงขีดจำกัดการสืบค้น $limit สำหรับโมดูล $module แล้ว',
    'ERROR_NOTIFY_OVERRIDE' => 'ข้อผิดพลาด: ต้องมีการแก้ไข ResourceObserver->notify()',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'ข้อผิดพลาด: ไม่สามารถสร้างการตรวจสอบ เนื่องจากไฟล์เมตะดาต้าว่างเปล่า หรือไม่มีไฟล์นี้อยู่',
    'ERR_MONITOR_NOT_CONFIGURED' => 'ข้อผิดพลาด: ไมได้กำหนดค่าการตรวจสอบสำหรับชื่อที่ขอ',
    'ERR_UNDEFINED_METRIC' => 'ข้อผิดพลาด: ไม่สามารถตั้งค่าสำหรับเมตริกที่ไม่ได้กำหนด',
    'ERR_STORE_FILE_MISSING' => 'ข้อผิดพลาด: ไม่พบไฟล์การใช้งานพื้นที่เก็บ',

    'LBL_MONITOR_ID' => 'ID การตรวจสอบ',
    'LBL_TEAM_ID' => 'ID ทีม',
    'LBL_SELECT_MODULE' => 'เลือกโมดูล:',
    'LBL_USER_ID' => 'ID ผู้ใช้',
    'LBL_MODULE_NAME' => 'ชื่อโมดูล',
    'LBL_MODULE_ALL' => 'ทั้งหมด',
    'LBL_ITEM_ID' => 'ID รายการ',
    'LBL_ITEM_SUMMARY' => 'ข้อมูลสรุปรายการ',
    'LBL_ACTION' => 'การดำเนินการ',
    'LBL_SESSION_ID' => 'ID เซสชัน',
    'LBL_BREADCRUMBSTACK_CREATED' => 'สร้าง BreadCrumbStack แล้วสำหรับ ID ผู้ใช้ {0}',
    'LBL_VISIBLE' => 'ระเบียนปรากฏ',
    'LBL_DATE_LAST_ACTION' => 'วันที่ของการดำเนินการล่าสุด',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'ข้อความ SQL',
    'LBL_QUERY_HASH' => 'แฮช SQL',
    'LBL_SEC_TOTAL' => 'จำนวนวินาทีทั้งหมด',
    'LBL_SEC_AVG' => 'จำนวนวินาทีเฉลี่ย',
    'LBL_RUN_COUNT' => 'จำนวนการสืบค้น',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'ที่อยู่ IP ของไคลเอนต์',
    'LBL_DATE_START' => 'วันที่เริ่มต้น',
    'LBL_ACTIVE' => 'เซสชันใช้งานอยู่',
    'LBL_ROUNDTRIPS' => 'จำนวนการดำเนินการ',
    'LBL_SECONDS' => 'จำนวนวินาทีที่ใช้งาน',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'รอบการรับส่งของฐานข้อมูล',
    'LBL_FILES_OPENED' => 'ไฟล์ที่เข้าถึง',
    'LBL_MEMORY_USAGE' => 'Memory Usage (bytes)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'กำลังโหลดเครื่องมือเชื่อมต่อ Twitter...',
    'LBL_TWITTER_DATA_EMPTY' => 'ไม่มีข้อมูลจาก Twitter',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'ปลั๊กอิน Sugar สำหรับ Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'รวมข้อมูลอีเมลและปฏิทินของ Sugar เข้ากับ Microsoft Outlook',
    'LBL_PLUGIN_WORD_NAME' => 'ปลั๊กอิน Sugar สำหรับ Word',
    'LBL_PLUGIN_WORD_DESC' => 'เติมข้อมูลโดยอัตโนมัติจาก SugarCRM ในจดหมายแบบฟอร์ม ไปรษณีย์ขายตรงและเอกสารอื่นๆ ใน Microsoft',
    'LBL_PLUGIN_EXCEL_NAME' => 'ปลั๊กอิน Sugar สำหรับ Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'รวม Sugar กับสเปรดชีทเพื่อให้มีการคำนวณเกณฑ์เมตริกสำคัญได้ดียิ่งขึ้น',
    'LBL_PLUGINS_TITLE' => 'ปลั๊กอิน Sugar สำหรับ Microsoft Office<sup>TM</sup>',
    'LBL_PLUGINS_DESC' => 'อ่านเกี่ยวกับคุณลักษณะของปลั๊กอินภายใน <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">เอกสารประกอบปลั๊กอิน</a>',

    'LBL_PLUGINS_LOTUS_TITLE' => 'ปลั๊กอิน Sugar สำหรับ Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'ปลั๊กอิน Sugar สำหรับ Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'รวม Sugar เข้ากับ Lotus Notes',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'ไม่อยู่ก่อน',
    'MSG_IS_MORE_THAN' => 'มากกว่า',
    'MSG_IS_LESS_THAN' => 'น้อยกว่า',
    'MSG_SHOULD_BE' => 'ควรเป็น',
    'MSG_OR_GREATER' => 'หรือมากกว่า',
    'MSG_EXCEEDS_MAXLEN' => 'เกินความยาวสูงสุดที่ระบุ ',

    'LBL_PORTAL_WELCOME_TITLE' => 'ยินดีต้อนรับสู่ Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal เป็นเฟรมเวิร์กที่ให้มุมมองแบบเรียลไทม์สำหรับเคส บัก จดหมายข่าว และอื่นๆ แก่ลูกค้า เป็นอินเทอร์เฟซภายนอกของ Sugar ซึ่งสามารถนำมาใช้ในเว็บไซต์ใดก็ได้ โปรดติดตามเพื่อพบกับคุณลักษณะการให้บริการด้วยตนเอง เช่น การจัดการโครงการและฟอรัมในรุ่นถัดไป',
    'LBL_LIST' => 'รายการ',
    'LBL_CREATE_CASE' => 'สร้างเคส',
    'LBL_CREATE_BUG' => 'สร้างบัก',
    'LBL_NO_RECORDS_FOUND' => '- พบ 0 ระเบียน -',

    'DATA_TYPE_DUE' => 'ครบกำหนด:',
    'DATA_TYPE_START' => 'เริ่มต้น:',
    'DATA_TYPE_SENT' => 'ส่ง:',
    'DATA_TYPE_MODIFIED' => 'Modified:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'จำนวน',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'รูปภาพออบเจกต์',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'เลือกวันที่',

    'LBL_VALIDATE_RANGE' => 'ไม่อยู่ในช่วงที่ถูกต้อง',
    'LBL_VALIDATE_URL' => 'ไม่ใช่ URL ที่ถูกต้อง',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'ทั้งหมด',

    'LBL_OPERATOR_IN_TEXT' => 'เป็นหนึ่งในรายการต่อไปนี้:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'ไม่ใช่หนึ่งในรายการต่อไปนี้:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'ข้อผิดพลาด: จำนวนอาร์เรย์ของพารามิเตอร์บีนไม่ตรงกับจำนวนอาร์เรย์ของผลลัพธ์',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'ข้อผิดพลาด: ไม่มีรายการแมปสำหรับโมดูล',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'ข้อผิดพลาด: ไม่สามารถเรียกข้อมูลสำหรับเครื่องมือเชื่อมต่อ {0} บริการนี้อาจไม่สามารถเข้าถึงได้ในขณะนี้ หรือการกำหนดค่าอาจไม่ถูกต้อง ข้อความแสดงข้อผิดพลาดของเครื่องมือเชื่อมต่อ: ({1})',
    'ERROR_CONNECTOR_CONFIGURE' => 'ไม่สามารถเรียกข้อมูล บริการอาจเข้าถึงไม่ได้ในขณะนี้ หรือการตั้งค่าอาจไม่ถูกต้อง',
    'LBL_CONNECT_TWITTER' => 'เชื่อมต่อกับ Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'ไม่พบไทม์ไลน์ที่ถูกต้องสำหรับ ID Twitter: ',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'กำหนดค่าเครื่องมือเชื่อมต่อ Twitter',
    'LBL_CONNECT_TEST_FAIL' => 'ข้อผิดพลาด: การกำหนดค่าของเครื่องมือเชื่อมต่ออาจไม่ถูกต้อง โปรดติดต่อผู้ดูแลระบบ',
    'LBL_CONFIGURE_TWITTER' => 'ติดต่อผู้ดูแลระบบเพื่อกำหนดค่า Twitter',
    'LBL_MERGE_CONNECTORS' => 'รับข้อมูล',
    'LBL_NO_DATA_AVAILABLE' => 'ไม่มีข้อมูล',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'คุณแน่ใจหรือไม่ว่าต้องการปิดใช้งานการรวมเครื่องมือเชื่อมต่อสำหรับโมดูลนี้',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'ไม่สามารถเชื่อมต่อกับเซิร์ฟเวอร์ Elastic',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'ไม่สามารถลบทีมร่วม',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'ไม่สามารถลบทีมส่วนตัว [{0}] จนกว่าจะลบผู้ใช้ [{1}]',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'คุณอาจปิดการใช้งาน Abobe Flash ไว้หรือใช้ Adobe Flash Player เวอร์ชันเก่า ในการรับ Flash Player เวอร์ชันล่าสุด โปรด<a href="http://www.adobe.com/go/getflashplayer/">คลิกที่นี่</a>',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'ชื่อ',
    'LBL_COLLECTION_PRIMARY' => 'หลัก',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'ฟิลด์ที่ต้องระบุว่างเปล่า',
    'LBL_COLLECTION_EXACT' => 'ตรงทั้งหมด',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'หากต้องการได้รับประสบการณ์ใช้งาน IIS/FastCGI sapi ที่ดีที่สุด ให้ตั้งค่า fastcgi.logging เป็น 0 ในไฟล์ php.ini',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'ระบุให้',
    'LBL_DESCRIPTION' => 'คำอธิบาย',
    'LBL_PRIMARY_CONTACT_NAME' => 'ผู้ติดต่อหลัก',
    'LBL_PRIMARY_CONTACT_ID' => 'ID ผู้ติดต่อหลัก',

    'LBL_NONE' => '-ไม่มี-',
    'LBL_YESTERDAY' => 'เมื่อวานนี้',
    'LBL_TODAY' => 'วันนี้',
    'LBL_TOMORROW' => 'พรุ่งนี้',
    'LBL_NEXT_WEEK' => 'สัปดาห์ถัดไป',
    'LBL_NEXT_MONDAY' => 'วันจันทร์ถัดไป',
    'LBL_NEXT_FRIDAY' => 'วันศุกร์ถัดไป',
    'LBL_TWO_WEEKS' => 'สองสัปดาห์',
    'LBL_NEXT_MONTH' => 'เดือนถัดไป',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'วันแรกของเดือนถัดไป',
    'LBL_THREE_MONTHS' => 'สามเดือน',
    'LBL_SIXMONTHS' => 'หกเดือน',
    'LBL_NEXT_YEAR' => 'ปีถัดไป',
    'LBL_FILTERED' => 'กรองแล้ว',

    //Datetimecombo fields
    'LBL_HOURS' => 'ชั่วโมง',
    'LBL_MINUTES' => 'นาที',
    'LBL_MERIDIEM' => 'เมอริเดียม',
    'LBL_DATE' => 'วันที่',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'รีเฟรชอัตโนมัติ',

    'LBL_DURATION_DAY' => 'วัน',
    'LBL_DURATION_HOUR' => 'ชั่วโมง',
    'LBL_DURATION_MINUTE' => 'นาที',
    'LBL_DURATION_DAYS' => 'วัน',
    'LBL_DURATION_HOURS' => 'ชั่วโมง',
    'LBL_DURATION_MINUTES' => 'นาที',
    'LBL_DURATION_SECONDS' => 'วินาที',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'เลือกเดือน',
    'LBL_ENTER_YEAR' => 'ป้อนปี',
    'LBL_ENTER_VALID_YEAR' => 'โปรดป้อนปีที่ถูกต้อง',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'โปรดป้อนหมายเลขโทรศัพท์ของสหรัฐอเมริกาเป็นตัวเลข และรวมรหัสพื้นที่',
    'LBL_CCP_NOT_INITIATED' => 'พยายามต่อสายโดยใช้ CCP ขณะที่ตัวแทนไม่ได้เข้าระบบ',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'ไม่สามารถเริ่มการโทรผ่าน CCP ได้',
    'LBL_CCP_DIALING_ERROR' => 'ไม่สามารถทำการโทรนี้ให้สมบูรณ์โดยการต่อสายได้',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'โปรดปิดรอบการสนทนาใน SugarLive ก่อนที่จะทำการโทรออก',

    //File write error label
    'ERR_FILE_WRITE' => 'ข้อผิดพลาด: ไม่สามารถเขียนข้อมูลในไฟล์ {0} โปรดตรวจสอบสิทธิ์ใช้งานของระบบและเว็บเซิร์ฟเวอร์',
    'ERR_FILE_NOT_FOUND' => 'ข้อผิดพลาด: ไม่สามารถโหลดไฟล์ {0} โปรดตรวจสอบสิทธิ์ใช้งานของระบบและเว็บเซิร์ฟเวอร์',

    'LBL_AND' => 'และ',
    'LBL_BEFORE' => 'ก่อน',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'อัปโหลดจากคอมพิวเตอร์',
    'LBL_SEARCH_EXTERNAL_API' => 'ไฟล์ในแหล่งข้อมูลภายนอก',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'อัปโหลดไปยังแหล่งภายนอก',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'ลิงก์จากแหล่งภายนอก',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'การรักษาความปลอดภัย',
    'LBL_SHARE_PRIVATE' => 'ส่วนตัว',
    'LBL_SHARE_COMPANY' => 'บริษัท',
    'LBL_SHARE_LINKABLE' => 'เชื่อมโยงได้',
    'LBL_SHARE_PUBLIC' => 'สาธารณะ',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'ฟีด RSS',
    'LBL_RSS_RECORDS_FOUND' => 'ระเบียนที่พบ',
    'ERR_RSS_INVALID_INPUT' => 'RSS เป็น input_type ที่ไม่ถูกต้อง',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS ไม่ใช่ response_type ที่ถูกต้องสำหรับเมทธอดนี้',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs ไม่รองรับรูปแบบไฟล์ที่คุณระบุ',

    'LBL_BLANK_VALUE' => '<ว่างเปล่า>',
    'LBL_EMPTY' => 'ว่างเปล่า',
    'LBL_IS_EMPTY' => 'ว่างเปล่า',
    'LBL_IS_NOT_EMPTY' => 'ไม่ว่างเปล่า',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '
"นี่คือตัวอย่างไฟล์นำเข้าซึ่งจะแสดงตัวอย่างของเนื้อหาไฟล์ที่คาดหมายและพร้อมสำหรับการนำเข้า"
"ไฟล์นี้เป็นไฟล์ .csv ที่คั่นด้วยเครื่องหมายจุลภาค ใช้เครื่องหมายอัญประกาศคู่ในการระบุฟิลด์"

"แถวส่วนหัวคือแถวบนสุดในไฟล์ และประกอบด้วยป้ายกำกับฟิลด์ตามที่จะเห็นในแอปพลิเคชัน"
"ป้ายกำกับเหล่านี้ใช้ในการแมปข้อมูลในไฟล์เข้ากับฟิลด์ในแอปพลิเคชัน"

"หมายเหตุ: ชื่อฐานข้อมูลนั้นสามารถใช้ในแถวส่วนหัวได้เช่นกัน ซึ่งจะเป็นประโยชน์เมื่อใช้เครื่องมือฐานข้อมูล phpMyAdmin หรือเครื่องมือฐานข้อมูลอื่นๆ เพื่อใช้จัดทำรายการข้อมูลที่ส่งออกและต้องการนำเข้า"
"ลำดับของคอลัมน์ไม่ใช่ส่วนสำคัญ เนื่องจากกระบวนการนำเข้าจะจับคู่ข้อมูลเข้ากับฟิลด์ที่ถูกต้องโดยดูจากแถวส่วนหัว"


"ในการใช้ไฟล์นี้เป็นเทมเพลท ให้ดำเนินการดังนี้:"
"1. นำแถวข้อมูลตัวอย่างออก"
"2. นำข้อความช่วยเหลือที่คุณอ่านอยู่ในขณะนี้ออก"
"3. ป้อนข้อมูลของคุณเองในแถวและคอลัมน์ที่ถูกต้อง"
"4. บันทึกไฟล์ไว้ในตำแหน่งที่กำหนดเองในระบบของคุณ"
"5. คลิกตัวเลือกนำเข้าจากเมนูการดำเนินการในแอปพลิเคชัน และเลือกไฟล์นี้เพื่ออัปโหลด"
   ',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'ID ผู้ใช้ที่ระบุ',
    'LBL_EXPORT_CREATED_BY' => 'สร้างโดย ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'แก้ไขโดย ID',
    'LBL_EXPORT_REPORTS_TO_ID' => 'ID ผู้บังคับบัญชา',
    'LBL_EXPORT_TEAM_ID' => 'ID ทีม',
    'LBL_EXPORT_TEAM_SET_ID' => 'ID ชุดทีม',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'ผู้ใช้ที่ระบุ',
    'LBL_EXPORT_FULL_NAME' => 'ชื่อเต็ม',
    'LBL_EXPORT_TEAM_NAME' => 'ทีม',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'กำลังนำทาง... ',

    'LBL_PENDING_NOTIFICATIONS' => 'การแจ้งเตือน',
    'LBL_ALT_ADD_TEAM_ROW' => 'เพิ่มแถวใหม่ของทีม',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'นำทีมออก',
    'LBL_ALT_SPOT_SEARCH' => 'การค้นหาเฉพาะจุด',
    'LBL_ALT_NOT_SORTED' => 'ยังไม่จัดเรียง',
    'LBL_ALT_SORT_DESC' => 'จัดเรียงจากมากไปน้อย',
    'LBL_ALT_SORT_ASC' => 'จัดเรียงจากน้อยไปมาก',
    'LBL_ALT_SORTABLE' => 'จัดเรียงได้',
    'LBL_ALT_NOT_SORTABLE' => 'จัดเรียงไม่ได้',
    'LBL_ALT_SORT' => 'จัดเรียง',
    'LBL_ALT_SHOW_OPTIONS' => 'แสดงตัวเลือก',
    'LBL_ALT_HIDE_OPTIONS' => 'ซ่อนตัวเลือก',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'ย้ายรายการที่เลือกไปยังรายการทางซ้าย',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'ย้ายรายการที่เลือกไปยังรายการทางขวา',
    'LBL_ALT_MOVE_COLUMN_UP' => 'ย้ายรายการที่เลือกขึ้นในลำดับของรายการที่แสดง',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'ย้ายรายการที่เลือกลงในลำดับของรายการที่แสดง',
    'LBL_ALT_INFO' => 'ข้อมูล',
    'MSG_DUPLICATE' => 'ระเบียน {0} ที่คุณต้องการสร้างอาจซ้ำกับระเบียน {0} ที่มีอยู่แล้ว ด้านล่างนี้เป็นรายชื่อของระเบียน {1} รายการที่มีชื่อคล้ายกัน<br>คลิกที่สร้าง {1} เพื่อสร้าง {0} ใหม่ต่อ หรือเลือก {0} ที่มีอยู่จากด้านล่าง',
    'MSG_SHOW_DUPLICATES' => 'ระเบียน {0} ที่คุณต้องการสร้างอาจซ้ำกับระเบียน {0} ที่มีอยู่แล้ว ด้านล่างนี้เป็นรายชื่อของระเบียน {1} ที่มีชื่อคล้ายกัน คุณสามารถคลิกบันทึก เพื่อสร้างระเบียน {0} นี้ต่อไป หรือคลิกยกเลิกเพื่อกลับสู่โมดูลโดยไม่สร้าง {0}',
    'LBL_EMAIL_TITLE' => 'ที่อยู่อีเมล',
    'LBL_EMAIL_OPT_TITLE' => 'ที่อยู่อีเมลที่เลือกออก',
    'LBL_EMAIL_INV_TITLE' => 'ที่อยู่อีเมลไม่ถูกต้อง',
    'LBL_EMAIL_PRIM_TITLE' => 'ที่อยู่อีเมลหลัก',
    'LBL_SELECT_ALL_TITLE' => 'เลือกทั้งหมด',
    'LBL_SELECT_THIS_ROW_TITLE' => 'เลือกแถวนี้',
    'LBL_TEAM_SELECTED_TITLE' => 'ทีมที่เลือก ',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'เลือกเพื่อกำหนดเป็นทีมหลัก',
    'LBL_TEAM_TBSELECTED_TITLE' => 'ทำเครื่องหมายทีมว่าเป็นการเลือกจากทีมแล้ว ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'ทำเครื่องหมายทีมนี้ว่าเป็นการเลือกจากทีม',
    'LBL_SEARCH_AND_SELECT' => 'ค้นหาและเลือก {{module}}',
    'TPL_SEARCH_AND_ADD' => 'ค้นหาและเพิ่ม {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'ข้อผิดพลาด: เกิดข้อผิดพลาดระหว่างการอัปโหลด รหัสข้อผิดพลาด: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'ข้อผิดพลาด: เกิดข้อผิดพลาดระหว่างการอัปโหลด รหัสข้อผิดพลาด: {0} - {1} upload_maxsize คือ {2} ',
    'UPLOAD_ERROR_HOME_TEXT' => 'ข้อผิดพลาด: เกิดข้อผิดพลาดระหว่างการอัปโหลดของคุณ โปรดติดต่อผู้ดูแลระบบเพื่อขอความช่วยเหลือ',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'ขนาดของการอัปโหลด ({0} ไบต์) เกินค่าสูงสุดที่อนุญาต: {1} ไบต์',
    'UPLOAD_REQUEST_ERROR' => 'เกิดข้อผิดพลาด โปรดรีเฟรชเพจและลองอีกครั้ง',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => 'แก้ไข',
    'LBL_ADD_BUTTON_LABEL' => 'เพิ่ม',
    'LBL_EDIT_BUTTON_TITLE' => 'แก้ไข',
    'LBL_REFRESH_BUTTON_LABEL' => 'รีเฟรช',
    'LBL_REFRESH_BUTTON_TITLE' => 'รีเฟรช',
    'LBL_DUPLICATE_BUTTON_KEY' => 'u',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'คัดลอก',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'คัดลอก',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'กำหนดการรายงาน',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'กำหนดการรายงาน',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'รายละเอียดรายงาน',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'รายละเอียดรายงาน',
    'LBL_DELETE_BUTTON_KEY' => 'd',
    'LBL_DELETE_BUTTON_LABEL' => 'ลบ',
    'LBL_DELETE_BUTTON_TITLE' => 'ลบ',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => 'บันทึก',
    'LBL_SAVE_BUTTON_TITLE' => 'บันทึก',
    'LBL_CANCEL_BUTTON_KEY' => 'l',
    'LBL_CANCEL_BUTTON_LABEL' => 'ยกเลิก',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'เพื่อหยุด',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'เพื่ออยู่ในเพจต่อไป',
    'LBL_CANCEL_BUTTON_TITLE' => 'ยกเลิก',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'แชร์',
    'LBL_SHARE_BUTTON_TITLE' => 'แชร์',
    'LBL_START_BUTTON_LABEL' => 'เริ่มต้น',
    'LBL_START_BUTTON_TITLE' => 'เริ่มต้น',
    'LBL_FINISH_BUTTON_LABEL' => 'เสร็จสิ้น',
    'LBL_FINISH_BUTTON_TITLE' => 'เสร็จสิ้น',
    'LBL_CONFIRM_BUTTON_LABEL' => 'ยืนยัน',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'เพื่อดำเนินการต่อ',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'ในการออกจากเพจและยกเลิกการเปลี่ยนแปลง',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'แป้นพิมพ์ลัด',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>ฟังก์ชันของฟอร์ม - Alt+</strong><br/> I = ed<b>I</b>t - แก้ไข (มุมมองรายละเอียด)<br/> U = d<b>U</b>plicate - ทำซ้ำ (มุมมองรายละเอียด)<br/> D = <b>D</b>elete - ลบ (มุมมองรายละเอียด)<br/> R = Sha<b>R</b>e - แชร์ (มุมมองรายละเอียด)<br/> A = s<b>A</b>ve - บันทึก (มุมมองแก้ไข)<br/> L = cance<b>L</b> - ยกเลิก (มุมมองแก้ไข) <br/><br/></p><p><strong>การค้นหาและการนำทาง - Alt+</strong><br/> 7 = การป้อนข้อมูลแรกในฟอร์มแก้ไข<br/> 8 = ลิงก์การค้นหาขั้นสูง<br/> 9 = อินพุตแรกของฟอร์มค้นหา<br/> 0 = อินพุตของการค้นหาแบบรวม<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'การเพิ่มขึ้น',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'แชร์',
    'TPL_RECORD_SHARE_SUBJECT' => 'Shared {{module}} {{name}} from {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'โปรดเช็คเอาต์ {{module}} {{name}} จาก {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'กำหนดอาร์เรย์ของเครื่องมือเชื่อมต่อใน {0} ไม่ถูกต้องหรือเป็นค่าว่างเปล่า และไม่สามารถใช้ได้',
    'LBL_PDF_VIEW' => 'ดาวน์โหลด PDF',
    'LBL_PDF_EMAIL' => 'ส่งอีเมลเป็น PDF',

    'ERR_SUHOSIN' => 'สตรีมการอัปโหลดถูกบล็อคโดย Suhosin โปรดเพิ่ม &quot;upload&quot; ใน suhosin.executor.include.whitelist (โปรดดู sugarcrm.log เพื่อดูข้อมูลเพิ่มเติม)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'ขณะนี้',
    'LBL_TIME_AGO_SECONDS' => 'ไม่ถึงนาทีที่ผ่านมา',
    'LBL_TIME_AGO_MINUTE' => 'ประมาณ 1 นาทีที่ผ่านมา',
    'LBL_TIME_AGO_MINUTES' => '{{this}} นาทีที่ผ่านมา',
    'LBL_TIME_AGO_HOUR' => 'ประมาณหนึ่งชั่วโมงที่ผ่านมา',
    'LBL_TIME_AGO_HOURS' => '{{this}} ชั่วโมงที่ผ่านมา',
    'LBL_TIME_AGO_DAY' => 'เมื่อวานนี้',
    'LBL_TIME_AGO_DAYS' => '{{this}} วันที่ผ่านมา',
    'LBL_TIME_AGO_YEAR' => 'มากกว่าหนึ่งปีที่ผ่านมา',
    'LBL_TIME_UNTIL_SECONDS' => 'ในเวลาไม่ถึงหนึ่งนาที',
    'LBL_TIME_UNTIL_MINUTE' => 'ในเวลาประมาณ 1 นาที',
    'LBL_TIME_UNTIL_MINUTES' => 'ในเวลา {{this}} นาที',
    'LBL_TIME_UNTIL_HOUR' => 'ในเวลาประมาณหนึ่งชั่วโมง',
    'LBL_TIME_UNTIL_HOURS' => 'ในเวลา {{this}} ชั่วโมง',
    'LBL_TIME_UNTIL_DAY' => 'พรุ่งนี้',
    'LBL_TIME_UNTIL_DAYS' => 'ในเวลา {{this}} วัน',
    'LBL_TIME_UNTIL_YEAR' => 'ในเวลามากกว่าหนึ่งปี',
    'LBL_TIME_RELATIVE' => 'โพสต์ {{relativetime}} เมื่อ {{date}} เวลา {{time}}',
    'LBL_LAST_TOUCHED' => 'แก้ไขล่าสุด {{relativetime}} เมื่อ {{date}} เวลา {{time}}',
    'LBL_LAST_COMMIT' => 'คำมั่นก่อนหน้า: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'ไม่มีข้อมูล',
    'LBL_DETAILVIEW_NO_RECORDS' => 'ไม่สามารถแสดงระเบียนในขณะนี้',
    'LBL_REFINE_LIST' => 'ปรับแต่งรายการ',
    'LBL_SEARCH_BY' => 'ค้นหาตาม',
    'LBL_PREVIEW' => 'ดูตัวอย่าง',
    'LBL_COLUMNS' => 'คอลัมน์',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'การแสดงตัวอย่างถูกปิด: ไม่มีข้อมูล',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'การแสดงตัวอย่างถูกปิด: ไม่มีสิทธิ์เข้าถึงระเบียน',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'การแสดงตัวอย่างถูกปิด: ไม่มีข้อมูล',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'การแสดงตัวอย่างถูกปิด: ในมุมมองเป็นระเบียนปัจจุบัน',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'การแสดงตัวอย่างถูกปิด: ระเบียนถูกนำออกหรือไม่มีสิทธิ์เข้าถึงระเบียน',
    'LBL_PREVIEW_PREVIOUS' => 'ดูตัวอย่างก่อนหน้านี้',
    'LBL_PREVIEW_NEXT' => 'ดูตัวอย่างถัดไป',
    'LBL_PREVIEW_CLOSE' => 'ปิดการดูตัวอย่าง',
    'LBL_STREAM_NO_RECORDS' => 'ไม่มีบันทึกของระเบียนในขณะนี้ โปรดเพิ่มบันทึกโดยคลิกที่ลิงก์เพิ่มบันทึก',
    'LBL_DUPLICATES_FOUND' => 'พบข้อมูลซ้ำ {{duplicateCount}} รายการ',
    'LBL_NO_DUPLICATES_FOUND' => 'ไม่พบข้อมูลซ้ำ',
    'LBL_RESET_DEFAULT_VIEW' => 'รีเซ็ตมุมมองเริ่มต้น',
    'LBL_RESET_DEFAULT_WIDTHS' => 'รีเซ็ตความกว้างเริ่มต้น',
    'LBL_TIMEZONE_UPDATED' => 'Sugar ได้อัปเดตเขตเวลาโปรไฟล์ของคุณให้ตรงกับเขตเวลาในเบราว์เซอร์แล้ว',
    'LBL_SUCCESS' => 'สำเร็จ',
    'LBL_ERROR' => 'ข้อผิดพลาด',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'ผสานรายการที่ซ้ำ',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'ต้องการดำเนินการต่อหรือไม่ ยกเลิกเพื่อล้มเลิกกระบวนการ ยืนยันเพื่อลบระเบียน',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'การดำเนินการนี้จะลบระเบียนต่อไปนี้:',
    'LBL_MERGE' => 'ผสาน',
    'TPL_MERGING_RECORDS' => 'ผสาน {{mergeCount}} ระเบียน',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'มีการส่งจำนวนระเบียนไม่ถูกต้อง ช่วงที่ถูกต้องคือตั้งแต่ {{minRecords}} ถึง {{maxRecords}} ระเบียน',
    'LBL_MERGE_NO_ACCESS' =>
        'คุณไม่มีสิทธิ์เข้าถึงเพื่อดำเนินการนี้ ต้องมีระเบียนที่แก้ไขได้อย่างน้อยหนึ่งระเบียน',
    'LBL_MERGE_LOCKED' => 'ระเบียนที่เลือกไว้บางรายการสำหรับการรวมมีฟิลด์ที่ถูกล็อคสำหรับการแก้ไขโดยกระบวนการ และไม่สามารถรวมได้ในขณะนี้',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'ไม่สามารถลบระเบียนที่เลือกไว้อย่างน้อยหนึ่งรายการ ' .
        'ระเบียนเหล่านี้ถูกนำออกจากรายการที่จะผสานแล้ว',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'ระบบจะไม่บันทึกการเปลี่ยนแปลงทั้งหมด เมื่อคุณเปลี่ยนเป็นระเบียนหลักใหม่ คุณแน่ใจหรือไม่ว่าต้องการเปลี่ยน',
    'LBL_MERGE_DUPLICATES_TITLE' => 'ผสานระเบียนที่เกี่ยวข้องกัน',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'ผสานแล้ว: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'ผสาน {{objectName}} ที่เกี่ยวข้องไม่สำเร็จ กำลังเริ่มต้นการดำเนินการใหม่ ({{num}} จาก {{total}})',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'ผสาน {{objectName}} ที่เกี่ยวข้องไม่สำเร็จ',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'การผสานระเบียนที่เกี่ยวข้องไม่สมบูรณ์ บางระเบียนยังไม่มีการผสาน',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'ไม่ได้ผสานระเบียนที่เกี่ยวข้องบางรายการอย่างถูกต้อง ยกเลิกเพื่อล้มเลิกกระบวนการ ยืนยันเพื่อผสานต่อไป',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} มีการผสานสำเร็จแล้ว ' .
        'เพิ่มระเบียนที่เกี่ยวข้องแล้ว {{total}} รายการ{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'ระเบียนที่เกี่ยวข้องทั้งหมดจะถูกย้ายไปยังระเบียนหลัก',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'คุณแน่ใจหรือไม่ว่าต้องการย้ายระเบียนนี้ออกจากการผสาน',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'นำระเบียนออกจากการผสาน',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'มีการส่งจำนวนระเบียนที่ไม่ถูกต้อง ช่วงที่ถูกต้องอยู่ระหว่าง 1 ถึง {{maxRecords}} ระเบียน',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'คู่ของชื่อผู้ใช้/รหัสผ่านที่ระบุไม่ถูกต้อง โปรดลองอีกครั้ง',
    'LBL_INVALID_CREDS_TITLE' => 'ข้อมูลประจำตัวไม่ถูกต้อง',
    'LBL_INVALID_GRANT' => 'โทเค็นของคุณไม่ถูกต้องหรือหมดอายุ โปรดล็อกอินอีกครั้ง',
    'LBL_INVALID_GRANT_TITLE' => 'โทเค็นหมดอายุแล้ว',
    'LBL_AUTH_FAILED' => 'การตรวจสอบสิทธิ์ไคลเอนต์ล้มเหลว',
    'LBL_AUTH_FAILED_TITLE' => 'ไคลเอนต์ไม่ถูกต้อง',
    'LBL_INVALID_REQUEST' => 'คำขอที่ส่งไม่ถูกต้องหรือมีรูปแบบไม่ถูกต้อง โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',
    'LBL_INVALID_REQUEST_TITLE' => 'คำขอไม่ถูกต้อง',
    'LBL_REQUEST_TIMEOUT' => 'เซิร์ฟเวอร์ไม่ตอบสนอง โปรดตรวจสอบการเชื่อมต่ออินเทอร์เน็ต',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'หมดเวลาของคำขอ: ',
    'LBL_UNAUTHORIZED' => 'ขออภัย ดูเหมือนคุณจะไม่ได้รับอนุญาตให้เข้าถึงทรัพยากรนี้',
    'LBL_UNAUTHORIZED_TITLE' => 'ไม่ได้รับอนุญาต',
    'LBL_RESOURCE_UNAVAILABLE' => 'ไม่มีทรัพยากรที่ใช้ได้',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'ห้ามใช้',
    'LBL_METHOD_NOT_ALLOWED' => 'ไม่สามารถใช้เมทธอด HTTP สำหรับทรัพยากรนี้ โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'ไม่สามารถใช้เมทธอดนี้',
    'LBL_PRECONDITION_MISSING' => 'ดำเนินการตามคำขอไม่สำเร็จ หรือพารามิเตอร์ขาดหายไปหรือไม่ถูกต้อง โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',
    'LBL_PRECONDITION_MISSING_TITLE' => 'ข้อผิดพลาด: ',
    'LBL_INVALID_412_RESPONSE' => 'คำขอทำงานไม่สำเร็จและทำให้แอปพลิเคชันใช้ไม่ได้ โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'ไม่ได้รับอนุญาตให้แก้ไขฟิลด์ {0} ในโมดูล: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'ไม่ได้รับอนุญาตให้ดำเนินการ "{0}" กับระเบียนนี้',
    'LBL_LOGIN_BUTTON_LABEL' => 'ล็อกอิน',
    'LBL_ACTIVITY_VIEW_TOUR' => 'ทัวร์ชมกิจกรรม',
    'LNK_TOUR' => 'ทัวร์',
    'LNK_MOBILE' => 'อุปกรณ์เคลื่อนที่',
    'LBL_FEEDBACK' => 'ฟีดแบ็ก',
    'LBL_SUPPORT' => 'การสนับสนุน',
    'LBL_LANGUAGE' => 'ภาษา / Sprache / Idioma',
    'LBL_LOADING_LANGUAGE' => 'โหลดชุดภาษา',
    'LBL_UPLOADING' => 'อัปโหลด',
    'LBL_UPLOADING_DOTS' => 'กำลังอัปโหลด...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'คุณแน่ใจหรือไม่ว่าต้องการลบรูปภาพนี้',
    'LBL_FILE_DELETE_CONFIRM' => 'คุณแน่ใจหรือไม่ว่าต้องการลบไฟล์นี้ ขั้นตอนนี้ไม่สามารถยกเลิกได้',
    'LBL_FILE_DELETED' => 'ลบไฟล์สำเร็จแล้ว',

    //theme roller
    'LBL_PORTAL_THEME' => 'ธีมของพอร์ทัล',
    'LBL_THEME_PREVIEW' => 'ดูตัวอย่างธีมของพอร์ทัล',
    'LBL_LOADING_PREVIEW' => 'กำลังโหลดตัวอย่าง',
    'LBL_RESET' => 'รีเซ็ต',
    'LBL_COLORS' => 'สี',
    'BorderColor' => 'สีเส้นขอบ',
    'NavigationBar' => 'แถบการนำทาง',
    'PrimaryButton' => 'ปุ่มหลัก',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'บันทึกและปรับใช้',
    'LBL_RESET_THEME_LNK' => 'เรียกคืนธีมเริ่มต้น',
    'LBL_RESET_THEME_MODAL_INFO' => 'คุณแน่ใจหรือไม่ว่าต้องการยกเลิกการปรับแต่งธีม และแทนที่ด้วยธีมเริ่มต้น',
    'LBL_RESET_THEME_PROCESS' => 'กำลังเรียกคืนธีมเริ่มต้น...',
    'LBL_SAVE_THEME_PROCESS' => 'กำลังบันทึกธีม...',

    // image loader
    'LBL_SELECT_PHOTO' => 'เลือกรูปภาพ',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'ฟังก์ชันประมาณการที่ดียิ่งขึ้นใน Sugar',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">ตั้งค่าพารามิเตอร์ประมาณการของคุณ</li><li class="fa fa-check">ติดตามการคาดการณ์การขายและสถานะของกระบวนการขายได้อย่างง่ายดาย</li><li class="fa fa-check">ประมาณการจากยอดขายที่คาดการณ์จากทีมขายของคุณ</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'ตั้งค่าพารามิเตอร์ประมาณการของคุณ',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">เลือกวันที่เริ่มต้นปีการเงิน</li><li class="fa fa-check">ตั้งค่างวดเวลาเป็นรายปีหรือรายไตรมาส</li><li class="fa fa-check">เลือกว่าจะแสดงงวดเวลาที่ผ่านมาแล้วและในอนาคตจำนวนเท่าใดในเวิร์กชีท</li><li class="fa fa-check">เลือกช่วงประมาณการเพื่อติดแท็กโอกาสทางการขายเป็นรวม ไม่รวม หรือข้อดี</li><li class="fa fa-check">เลือกสถานการณ์ประมาณการเพื่อระบุการประมาณการแบบเป็นไปได้ ดีที่สุด และแย่ที่สุด</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'จัดการการขายที่คาดการณ์ของทีมขาย',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">เลือกงวดเวลาเพื่อทบทวนการประมาณการ</li><li class="fa fa-check">ดูเวิร์กชีทของสมาชิกในทีมขาย และปรับเปลี่ยนประมาณการ</li><li class="fa fa-check">ดูการเตือนในเวิร์กชีทเมื่อสมาชิกในทีมขายคอมมิตประมาณการขายใหม่</li><li class="fa fa-check">บันทึกเวิร์กชีทประมาณการเป็นฉบับร่าง หรือคอมมิตประมาณการให้กับผู้จัดการของคุณ</li><li class="fa fa-check">ดูประวัติของการคอมมิตก่อนหน้า</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'จัดการการขายที่คาดการณ์ของทีมขาย',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">ดูแผนภูมิพาเรโตสำหรับการวิเคราะห์กระบวนการขายในการประมาณการของสมาชิกในทีมขายทั้งหมด</li><li class="fa fa-check">เลือกแสดงภาพการขายที่คาดการณ์ตามระดับเป็นไปได้ ดีที่สุด หรือแย่ที่สุด</li><li class="fa fa-check">ดูการขายที่คาดการณ์ และดูว่าใกล้จะได้โควตาของทีมเพียงใด</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'จัดการการขายที่คาดการณ์ของคุณเอง',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">เลือกงวดเวลาสำหรับการประมาณการของคุณ</li><li class="fa fa-check">ตรวจทานและแก้ไขแบบอินไลน์สำหรับจำนวนเงินและความเป็นไปได้ที่จะได้รับสำหรับการวิเคราะห์สถานการณ์ what-if อย่างรวดเร็ว</li><li class="fa fa-check">บันทึกเวิร์กชีทประมาณการเป็นฉบับร่างหรือคอมมิตไปยังผู้จัดการของคุณ</li><li class="fa fa-check">ดูประวัติของการคอมมิตก่อนหน้า</li><li class="fa fa-check">คอมมิตประมาณการไปยังผู้จัดการและดูประวัติของการคอมมิตก่อนหน้า</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'จัดการการขายที่คาดการณ์ของคุณเอง',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">ดูแผนภูมิพาเรโตสำหรับการวิเคราะห์กระบวนการขายในช่วงเวลาที่ผ่านมาสำหรับโอกาสทางการขายของคุณ</li><li class="fa fa-check">เลือกแสดงภาพการกระจายกระบวนการขายตามขั้นตอนการขายหรือความเป็นไปได้ที่จะได้รับ</li><li class="fa fa-check">ดูการขายที่คาดการณ์และดูว่าใกล้จะได้โควตาที่ได้รับมอบหมายเพียงใด</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'มีอะไรใหม่ใน Sugar',
    'LBL_TOUR_WATCH' => 'ดูว่ามีอะไรใหม่ใน Sugar',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="fa fa-check">ปรับปรุงรูปลักษณ์ใหม่ พร้อมด้วยธีมที่ทันสมัย</li><li class="fa fa-check">โมดูลประมาณการที่ดียิ่งขึ้น – มาพร้อมอินเทอร์เฟซผู้ใช้และการแสดงภาพข้อมูลใหม่ที่ใช้งานง่าย</li></ul>',
    'LBL_TOUR_VISIT' => 'เข้าสู่แอปพลิเคชันของเราเพื่อดูข้อมูลเพิ่มเติม',
    'LBL_TOUR_DONE' => 'ดำเนินการเสร็จแล้ว!',
    'LBL_TOUR_REFERENCE_1' => 'คุณสามารถอ้างอิง',
    'LBL_TOUR_REFERENCE_2' => 'ของเราผ่านลิงก์ "การสนับสนุน" ในเมนูโปรไฟล์',
    'LNK_TOUR_DOCUMENTATION' => 'เอกสารประกอบ',
    'LBL_TOUR_CALENDAR_URL_1' => 'คุณใช้ปฏิทินของ SugarCRM ร่วมกับแอปพลิเคชันของผู้ผลิตรายอื่น เช่น Microsoft Outlook หรือ Exchange หรือไม่ ถ้าใช่ คุณมี URL แล้ว ซึ่ง URL ใหม่ที่ปลอดภัยยิ่งกว่าเดิมนี้รวมคีย์ส่วนตัวที่จะช่วยป้องกันการเผยแพร่ปฏิทินของคุณโดยไม่ได้รับอนุญาตได้',
    'LBL_TOUR_CALENDAR_URL_2' => 'รับ URL ใหม่สำหรับปฏิทินที่แชร์ของคุณ',
    'LBL_TOUR_CUBE' => 'เข้าถึงแดชบอร์ดและสตรีมกิจกรรม',
    'LBL_TOUR_NAV_BAR' => 'เข้าถึงโมดูลทั้งหมดในเมนูการนำทางและดำเนินการต่างๆ',
    'LBL_TOUR_NOTIFICATIONS' => 'คลิกเพื่อดูการแจ้งเตือน',
    'LBL_TOUR_SEARCH' => 'เลือกอย่างน้อยหนึ่งโมดูลและค้นหา',
    'LBL_TOUR_AVATAR' => 'ดูรายละเอียดเพิ่มเติมเกี่ยวกับแอปพลิเคชันหรือล็อกเอาต์',
    'LBL_TOUR_ADD' => 'สร้างระเบียนจากที่นี่',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'คลิกเพื่อปิดหรือเปิดแผงข้อมูลอัจฉริยะ',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'เลือกเพื่อดูกิจกรรมหรือรายการระเบียน',
    'LBL_TOUR_LIST_FILTER1' => 'แถบตัวกรองช่วยให้สามารถค้นหาสำหรับโมดูลนี้',
    'LBL_TOUR_LIST_FILTER2' => 'เลือกตัวกรองที่กำหนดล่วงหน้าหรือสร้างใหม่',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'พิมพ์ที่นี่เพื่อค้นหาตามชื่อ',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'เลือกเพื่อแก้ไขแถวหรือแสดงตัวอย่างรายละเอียด',
    'LBL_TOUR_RECORD_ACTIONS' => 'ดำเนินการกับระเบียน',
    'LBL_TOUR_RECORD_SUBPANEL' => 'คลิกส่วนหัวเพื่อขยายและยุบแผงข้อมูลย่อย',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'สามารถอัปเดตชื่อระเบียนได้โดยตรง',
    'LBL_TOUR_RECORD_STATUS' => 'ดูสถานะระดับระเบียนที่นี่',
    'LBL_TOUR_RECORD_SHOWMORE' => 'คลิกเพื่อดูข้อมูลเพิ่มเติมสำหรับระเบียน',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'เลือกเพื่อดูกิจกรรมหรือระเบียนที่เกี่ยวข้อง',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'คลิกเพื่อแก้ไขแต่ละฟิลด์แบบอินไลน์',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'สร้างกลุ่มใหม่ของส่วนข้อมูล',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'กำหนดชื่อให้กับกลุ่มของส่วนข้อมูล',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'เลือกเพื่อนำส่วนข้อมูลออกหรือเปลี่ยนการตั้งค่า',
    'LBL_TOUR_INTRO' =>'<h4>ยินดีต้อนรับสู่ Sugar</h4> เราอยากแนะนำคุณให้รู้จักกับคุณลักษณะบางส่วน โปรดใช้ลูกศร < และ > ที่ด้านล่างของหน้าจอเพื่อทัวร์ชม<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">มีอะไรใหม่</a><p class="details">ดูการเปลี่ยนแปลงสำคัญระหว่างรุ่น</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">หาข้อมูลเพิ่มเติมเกี่ยวกับ Sugar</a><p class="details">แหล่งรวมอีเลิร์นนิงที่ครบครัน การฝึกอบรมในชั้นเรียนแบบสดและเสมือนจริง  เว็บมินาร์ และบทแนะนำผ่านวิดีโอ</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">รับการสนับสนุน</a><p class="details">ถ้าต้องการความช่วยเหลือ มีปัญหา หรือต้องการแนะนำวิธีปรับปรุงให้ Sugar ดียิ่งขึ้น</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'ดูรายการระเบียนและดำเนินการกับระเบียน',
    'LBL_TOUR_RECORD_INTRO' => 'ดูรายละเอียดในระเบียนนี้และดูข้อมูลทั้งหมดที่เกี่ยวข้อง',
    'LBL_TOUR_FORECAST_INTRO' => 'จัดการกระบวนการขายและประมาณการ',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'เลือกงวดเวลาเพื่อดูประมาณการสำหรับงวดนั้นๆ',
    'LBL_TOUR_FORECASTS_COMMITS' => 'คลิกเพื่อดูการคอมมิตก่อนหน้า',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'คลิกเพื่อแก้ไขข้อมูลแบบอินไลน์',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'ดูระยะห่างจากโควตา',
    'LBL_TOUR_FORECASTS_CHART' => 'ตรวจทานการกระจายของประมาณการ',
    'LBL_TOUR_TOUR' => 'เข้าสู่การทัวร์ได้ทุกเวลา',
    'LBL_TOUR_TAGS_ADD' => 'คลิกที่ฟิลด์แท็กเพื่อเพิ่มและนำแท็กออก',
    'LBL_TOUR_TAGS_DELETE' => 'ในการลบแท็ก ให้ใช้ปุ่ม Backspace หรือคลิกปุ่ม [X] ในแต่ละแท็ก',
    'LBL_TOUR_RECORD_SAVE' => 'เมื่อคุณพร้อม ให้คลิกบันทึก',


    'LBL_FUTURE' => 'อนาคต',
    'LBL_REQUIRED_FIELD' => 'ต้องระบุ',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'สินค้าในไลน์ที่เสนอราคาแล้ว',
    'LBL_DISCOUNT_TOTAL' => 'ยอดรวมส่วนลด',
    'LBL_DISCOUNT_PERCENT' => '% เปอร์เซ็นต์',
    'LBL_DISCOUNT_SELECT' => 'ระบุว่าส่วนลดเป็นจำนวนเปอร์เซ็นต์ หรือเป็นจำนวนคงที่',
    'LBL_TAX' => 'ภาษี',
    'LBL_SHIPPING' => 'การขนส่ง',
    'LBL_GRAND_TOTAL' => 'ยอดรวมทั้งหมด',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'ที่อยู่สำหรับเรียกเก็บเงินที่สร้างขึ้นโดยอัตโนมัติโดยโปรไฟล์บัญชี',
    'LBL_QLI_ADD_GROUP' => 'เพิ่มกลุ่ม',
    'LBL_QLI_COMMENT' => 'ความคิดเห็น',
    'LBL_SELECT_ACTION' => 'เลือกการดำเนินการ',
    'LBL_QLI_GROUP_NAME' => 'ชื่อกลุ่ม',
    'LBL_GROUP_TOTAL' => 'ยอดรวมของกลุ่ม',
    'LBL_ITEM_NAME' => 'สินค้าในไลน์',
    'LBL_QLI_DELETE' => 'คุณแน่ใจหรือไม่ว่าต้องการลบรายการในไลน์นี้',
    'LBL_QLI_COMMENT_DELETE' => 'คุณแน่ใจหรือไม่ว่าต้องการลบความคิดเห็นของรายการในไลน์นี้',
    'LBL_QLI_GROUP_DELETE' => 'คุณต้องการที่จะลบกลุ่ม {0} ใช่หรือไม่ สินค้าทุกรายการจะถูกเคลื่อนย้ายไปยังกลุ่มค่าเริ่มต้น',
    'LBL_QLI_GROUP_EMPTY' => 'ไม่มีสินค้าในไลน์ที่เสนอราคา',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'ตัวเลือก',
    'LBL_RELATED_MODULE' => '{{{this}}} ที่เกี่ยวข้อง',
    'LBL_RELATED_MODULE_PLURAL' => '{{{this}}} ที่เกี่ยวข้อง',
    'LBL_CREATE_MODULE' => 'สร้าง {{{this}}}',
    'LBL_EDIT' => 'แก้ไข {{{this}}}',
    'LBL_ASSOC' => 'เชื่อมโยง {{{this}}}',
    'LBL_ASSIGN' => 'เลือก {{{this}}}',
    'LBL_EDIT_RELATED' => 'แก้ไข {{{this}}} ที่เกี่ยวข้อง',
    'LBL_CREATE_RELATED' => 'สร้าง {{{this}}} ที่เกี่ยวข้อง',
    'LBL_ASSOC_EXISTING' => 'เชื่อมโยง {{{this}}} ที่มีอยู่',
    'LBL_SEARCH_ALL' => 'ค้นหา {{{this}}} ทั้งหมด...',
    'LBL_SEARCH_ALL_RECORDS' => 'ค้นหาระเบียนทั้งหมด...',
    'LBL_SEARCH_ALL_MODULES' => 'ค้นหาทั้งหมด',
    'LBL_OK' => 'ตกลง',
    'LBL_YES' => 'ใช่',
    'LBL_NO' => 'ไม่',
    'LBL_SHOW_NUMBERING' => 'แสดงหมายเลขขั้นตอน',
    'LBL_HIDE_NUMBERING' => 'ซ่อนหมายเลขขั้นตอน',
    'LBL_CALL_BUTTON' => 'การโทร',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'อีเมล',
    'LBL_HONEYPOT' => 'ถ้าคุณเป็นบุคคลจริง โปรดอย่ากรอกข้อมูลนี้',
    'LBL_LINK_BUTTON' => 'ลิงก์',
    'LBL_UNLINK_BUTTON' => 'เลิกเชื่อมโยง',
    'LBL_MAP_BUTTON' => 'แผนที่',
    'LBL_FILE_BUTTON' => 'ไฟล์',
    'LBL_URL_BUTTON' => 'เว็บ',
    'LBL_WARNING' => 'คำเตือน',
    'LBL_CONFIRM' => 'ยืนยัน',
    'LBL_CONFIRMATION_POPUP' => 'ป๊อปอัปยืนยัน',
    'LBL_NO_ACCESS' => '(ไม่มีสิทธิ์เข้าถึง)',
    'LBL_NO_ACCESS_LOWER' => 'ไม่มีสิทธิ์เข้าถึง',
    'LBL_NO_FIELD_ACCESS' => 'ไม่มีสิทธิ์เข้าถึง',
    'LBL_NO_LICENSE_ACCESS' => 'ต้องใช้ใบอนุญาต',
    'LBL_VALUE_ERASED' => 'ลบค่าแล้ว',
    'LBL_VALUE_ERASED_TOOLTIP' => 'ลบข้อมูลนี้ตามการร้องขอการคุ้มครองข้อมูลส่วนบุคคลแล้ว',
    'LBL_CREATE_RELATED_RECORD' => 'สร้างระเบียนที่เกี่ยวข้อง',
    'LBL_ASSOC_RELATED_RECORD' => 'เชื่อมโยงระเบียนที่มีอยู่',
    'LBL_CHOOSE_LINK' => 'เลือกประเภทลิงก์',
    'LBL_CHOOSE_PARENT_TYPE' => 'เลือกประเภทหลัก',
    'LBL_HOME' => 'หน้าแรก',
    'ERR_NO_DOCS' => 'ไม่มีเอกสารที่ใช้ได้',
    'ERR_NO_RECORDS_SELECTED' => 'คุณยังไม่ได้เลือกระเบียนเลย',
    'LBL_DELETING' => 'กำลังลบ...',
    'LBL_UNLINKING' => 'กำลังยกเลิกการเชื่อมโยง...',
    'LBL_UNLINKED' => 'เลิกเชื่อมโยงแล้ว',
    'LBL_LEGAL' => 'กฎหมาย',
    'LBL_UPCOMING' => 'กิจกรรมที่จะมาถึงของฉัน',
    'LBL_RECENTLY_UPDATED' => 'อัปเดตล่าสุด',
    'LBL_NOTES_SUBPANEL_TITLE' => 'บันทึก',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'การประชุม',
    'LBL_TASKS_SUBPANEL_TITLE' => 'งาน',
    'LBL_CALLS_SUBPANEL_TITLE' => 'การโทร',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'บัญชี',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'ติดต่อ',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'อีเมล',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'เวรทำงาน',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'รายการบรรทัดการเสนอราคา',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'ข้อยกเว้นเวรทำงาน',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'เอกสาร',
    'LBL_ESCALATIONS' => 'การเพิ่มขึ้น',
    'LBL_ESCALATED' => 'เพิ่มขึ้นแล้ว',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'การเพิ่มขึ้น',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'การเพิ่มขึ้นอื่น ๆ ที่เกี่ยวข้อง',
    'LBL_ESCALATIONS' => 'การเพิ่มขึ้น',
    'LNK_SETTINGS' => 'การตั้งค่า',
    'LBL_MOBILE_SUPPORT' => 'การสนับสนุน',
    'LBL_MOBILE_SHOW_MORE' => 'แสดงเพิ่มเติม...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'แสดงเพิ่มเติม...',
    'LBL_MOBILE_NO_RECORDS' => 'ไม่พบระเบียน',
    'LBL_MOBILE_SEARCH_TEAMS' => 'ค้นหาทีม...',
    'LBL_MOBILE_SELECT_TEAMS' => 'เลือกทีม',
    'LBL_MOBILE_WAIT' => 'โปรดรอสักครู่...',
    'LBL_MOBILE_LOGING_OUT' => 'โปรดรอขณะกำลังออกจากระบบ...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'ล็อกอินอีกครั้ง',
    'LBL_MOBILE_META_SYNC_FAILED' => 'ไม่สามารถซิงค์กับเซิร์ฟเวอร์',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'ไม่สามารถซิงค์กับเซิร์ฟเวอร์ ลองอีกครั้งหรือไม่',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'ความเป็นส่วนตัว ข้อกำหนด และเงื่อนไข',
    'LBL_MOBILE_APP_VERSION' => 'เวอร์ชันของแอป',
    'LBL_MOBILE_SERVER_VERSION' => 'เวอร์ชันของเซิร์ฟเวอร์',
    'LBL_MOBILE_SERVER_URL' => 'URL เซิร์ฟเวอร์',
    'LBL_MOBILE_PTR_PULL' => 'ดึงลงเพื่อรีเฟรช...',
    'LBL_MOBILE_PTR_RELEASE' => 'ปล่อยเพื่อรีเฟรช',
    'LBL_MOBILE_EDIT_REL' => 'แก้ไขความสัมพันธ์',
    'LBL_MOBILE_DESKTOP' => 'เวอร์ชันเดสก์ท็อป',
    'LBL_MOBILE_DELETE_CONFIRM' => 'คุณแน่ใจหรือไม่ว่าต้องการลบระเบียนนี้',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'คุณแน่ใจหรือไม่ว่าต้องการยกเลิกการเชื่อมโยงระเบียนนี้',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'คุณต้องการล็อกการโทรครั้งล่าสุดหรือไม่',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'เลือกผู้รับ',
    'LBL_MOBILE_CHOOSE_PHONE' => 'เลือกหมายเลขโทรศัพท์',
    'LBL_MOBILE_CHOOSE_URL' => 'เลือก URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'เลือกเอกสาร',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'เลือกสถานที่',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'ไม่มีการดำเนินการที่ใช้ได้',
    'LBL_MOBILE_FEEDBACK' => 'ฟีดแบ็ก',
    'LBL_MOBILE_DOC' => 'เอกสาร',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'เริ่มต้นดาวน์โหลดแล้ว: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'ดาวน์โหลดเสร็จสมบูรณ์: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'กำลังอัปโหลดไฟล์...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'อัปโหลดไฟล์สำเร็จแล้ว',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'กำลังเตรียมรูปภาพ...',
    'LBL_CLOSE_SAVE_BUTTON' => 'ปิดงานและบันทึก',
    'LBL_LATER' => 'ภายหลัง',
    'LBL_USE_HTTPS' => 'ใช้การเชื่อมต่อที่ปลอดภัย',
    'LBL_LOADING_FILES' => 'กำลังโหลดรายชื่อเอกสาร โปรดลองอีกครั้งในภายหลัง',
    'LBL_NEW_WEB_VERSION' => 'แอปพลิเคชันนี้มีเวอร์ชันใหม่ที่ใช้ได้ คุณต้องการอัปเดตหรือไม่',
    'LBL_SET_FONTSIZE' => 'ขนาดแบบอักษร',
    'LBL_FONTSIZE_TINY' => 'จิ๋ว',
    'LBL_FONTSIZE_SMALL' => 'เล็ก',
    'LBL_FONTSIZE_NORMAL' => 'ปกติ (เริ่มต้น)',
    'LBL_FONTSIZE_LARGE' => 'ใหญ่',
    'LBL_FONTSIZE_LARGER' => 'ใหญ่กว่า',
    'LBL_FONTSIZE_HUGE' => 'ใหญ่มาก',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'ใหญ่พิเศษ',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "การดาวน์โหลดล้มเหลว\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'เพิ่มเติม...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...น้อยลง',
    'LBL_OFFLINE_MODE' => 'โหมดออฟไลน์',
    'LBL_OFFLINE_DELETED' => 'ไม่พบระเบียน',
    'LBL_OFFLINE_DELETED_RELATED' => 'ไม่พบระเบียนที่เกี่ยวข้อง อาจถูกลบหรือยกเลิกการเชื่อมโยงแล้ว',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'การดาวน์โหลดระเบียนที่ได้รับมอบหมาย รายการโปรด และระเบียนที่ติดตามเพื่อเข้าถึงแบบออฟไลน์อาจใช้เวลาสักครู่ ขอแนะนำให้ใช้การเชื่อมต่อความเร็วสูง คุณต้องการดำเนินการต่อหรือไม่',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'คุณต้องการดาวน์โหลดระเบียนที่ได้รับมอบหมาย รายการโปรด และระเบียนที่ติดตามเพื่อเข้าถึงแบบออฟไลน์หรือไม่ ขอแนะนำให้ใช้การเชื่อมต่อความเร็วสูง เนื่องจากการดำเนินการนี้อาจใช้เวลา คุณสามารถดาวน์โหลดในภายหลังจากเมนูหลัก > ออฟไลน์',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'ดาวน์โหลดระเบียนสำเร็จแล้ว',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'ดาวน์โหลดระเบียนของคุณ...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'เกิดข้อผิดพลาดขณะดาวน์โหลดระเบียน',
    'LBL_OFFLINE_PREFETCHING' => 'กำลังโหลดระเบียน...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'กำลังโหลด {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'เหลือเวลาอีกประมาณ {{estimatedTime}}s...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => 'โหลด {{module}} เสร็จสมบูรณ์',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'กำลังล้างพื้นที่เก็บข้อมูล...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'การล้างข้อมูลเสร็จสมบูรณ์',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'คุณต้องการย้อนการเปลี่ยนแปลงนี้หรือไม่',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'การย้อนกลับเสร็จสมบูรณ์',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'ย้อนกลับไม่สำเร็จ',
    'LBL_OFFLINE_CLEAR_DB' => 'ล้างพื้นที่เก็บข้อมูล...',
    'LBL_OFFLINE_COMPACT_DB' => 'กระชับพื้นที่เก็บข้อมูล...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'การดำเนินการนี้จะลบระเบียนที่คุณไม่ได้เข้าถึงมาระยะหนึ่ง ต้องการดำเนินการต่อหรือไม่',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'คุณต้องการลบระเบียนทั้งหมดจากพื้นที่เก็บข้อมูลในระบบหรือไม่',
    'LNK_OFFLINE_SETTINGS' => 'ออฟไลน์',
    'LBL_OFFLINE_SETTINGS' => 'การตั้งค่าการดีบัก',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'ไม่มีการเปลี่ยนแปลงที่รอซิงโครไนซ์',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'มีการเปลี่ยนแปลงรอซิงโครไนซ์อยู่',
    'LBL_OFFLINE_STATUS_ONLINE' => 'อุปกรณ์ออนไลน์',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'อุปกรณ์ออฟไลน์',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'ไม่สามารถติดต่อเซิร์ฟเวอร์',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'การพยายามซิงโครไนซ์ล่าสุดล้มเหลว โปรดตรวจสอบล็อกการทำรายการ',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'อยู่ระหว่างการซิงโครไนซ์...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'ซิงโครไนซ์การทำรายการแล้ว',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'คุณแน่ใจหรือไม่ว่าต้องการปิดการสนับสนุนแบบออฟไลน์',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'คุณต้องการปิดการสนับสนุนออฟไลน์หรือไม่ การเปลี่ยนแปลงทั้งหมดที่รอซิงโครไนซ์จะสูญหายไป',
    'LBL_OFFLINE_ENABLED' => 'เปิดใช้งานโหมดออฟไลน์แล้ว',
    'LBL_OFFLINE_DISABLED' => 'ปิดใช้งานโหมดออฟไลน์แล้ว',
    'LBL_OFFLINE_STATS' => 'สถิติการเก็บข้อมูล',
    'LBL_OFFLINE_SERVER_FETCH' => 'กำลังเรียกจากเซิร์ฟเวอร์...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'มีคนแก้ไขระเบียนเดียวกันในเซิร์ฟเวอร์ โปรดยืนยันเพื่อผสานการเปลี่ยนแปลงโดยอัตโนมัติ หรือปฏิเสธเพื่อยกเลิกการเปลี่ยนแปลง',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'การพยายามซิงโครไนซ์ล่าสุด: {{ts}}',
    'LBL_ACTION_UPDATE' => 'อัปเดต',
    'LBL_ACTION_CREATE' => 'สร้าง',
    'LBL_ACTION_DELETE' => 'ลบ',
    'LBL_ACTION_LINK' => 'ลิงก์',
    'LBL_ACTION_UNLINK' => 'เลิกเชื่อมโยง',
    'LBL_ACTION_FAVORITE' => 'รายการโปรด',
    'LBL_ACTION_FOLLOW' => 'ติดตาม',
    'LBL_ACTION_CREATE_EXPLANATION' => 'สร้าง {{module}} "{{name}}" แล้ว',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'อัปเดต {{module}} "{{name}}" แล้ว',
    'LBL_ACTION_DELETE_EXPLANATION' => 'ลบ {{module}} "{{name}}" แล้ว',
    'LBL_ACTION_LINK_EXPLANATION' => 'เชื่อมโยง {{module}} "{{name}}" กับ {{relatedModule}} "{{relatedName}}" แล้ว',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'เลิกเชื่อมโยง {{module}} "{{name}}" จาก {{relatedModule}} "{{relatedName}}" แล้ว',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'ติดตาม {{module}} "{{name}}" อยู่',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'เลิกติดตาม {{module}} "{{name}}" แล้ว',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'เพิ่ม {{module}} "{{name}}" เป็นรายการโปรดแล้ว',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'นำ {{module}} "{{name}}" ออกจากรายการโปรดแล้ว',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'สร้าง {{module}} "{{name}}" ที่เกี่ยวข้องกับ {{relatedModule}} "{{relatedName}}" แล้ว',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'หลัก',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'เลือกออก',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'เข้าร่วม',
    'LBL_EMAIL_ACTION_SET_VALID' => 'ถูกต้อง',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'ไม่ถูกต้อง',
    'LBL_ROLLBACK_BUTTON' => 'ย้อนกลับ',
    'LBL_TX_LOG' => 'ล็อกการทำรายการ',
    'LBL_TX_LOG_DETAIL' => 'รายละเอียดการทำรายการ',
    'LBL_RECORD_DELETED' => '(ลบระเบียนแล้ว)',
    'LBL_NOT_AVAILABLE' => 'N/A',
    'LBL_FILE_SIZE' => 'ขนาดไฟล์',
    'LBL_FILE_SIZE_UNITS_B' => 'ไบต์',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'เลือกรายการ',
    'LBL_OFFLINE_DB_SIZE' => 'ขนาดฐานข้อมูล',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'ระเบียนต่อนาที',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'จำนวนรวมของระเบียน',
    'LBL_RECORD_NOT_FOUND' => 'ไม่พบระเบียน',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'ไม่พบระเบียนที่เกี่ยวข้อง',
    'LBL_NOT_AUTHORIZED' => 'คุณไม่ได้รับอนุญาตให้ดูระเบียนนี้',
    'LBL_MOBILE_PROCESSING_FILE' => 'กำลังเตรียมไฟล์...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'ซอฟต์แวร์ของผู้ผลิตรายอื่น',
    'LNK_TERMS_OF_USE' => 'ข้อกำหนดการใช้งาน',
    'LNK_PRIVACY_POLICY' => 'นโยบายความเป็นส่วนตัว',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'การเข้าสู่ระบบครั้งเดียว',
    'LBL_RECENTS' => 'รายการล่าสุด',
    'LBL_SHOWING_CACHED_DATA' => 'ไม่สามารถติดต่อเซิร์ฟเวอร์ ระบบกำลังแสดงข้อมูลล่าสุดที่ใช้ได้ ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'ปิด {{moduleSingular}} และบันทึก',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'แดชบอร์ดที่ระบุ',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Specific Module',
    'LBL_MOBILE_DEFAULT_VIEW' => 'หน้าจอเริ่มต้น',
    'LBL_MOBILE_DEFAULT_MODULE' => 'โมดูลที่เลือก',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'แดชบอร์ดที่เลือก',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'ส่วนข้อมูลที่เลือก',
    'LBL_ALL_DASHLETS' => 'ส่วนข้อมูลทั้งหมด',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'การค้นหาทั้งระบบ',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'พิมพ์ @ เพื่อพูดถึงผู้ใช้ พิมพ์ # เพื่ออ้างอิงระเบียน',
    'LBL_MOBILE_NEW_COMMENT' => 'ความคิดเห็นใหม่',
    'LBL_RECENTLY_VIEWED' => 'ดูล่าสุด',
    'LBL_FILE_STORED_LOCALLY' => 'ไฟล์ถูกนำเก็บไปยังพื้นที่จัดเก็บในเครื่องและจะทำการซิงค์เมื่ออุปกรณ์ออนไลน์',
    'LBL_IDM_USER_PROFILE_READONLY' => 'หากคุณต้องการเปลี่ยนฟิลด์ที่แก้ไขไม่ได้ กรุณาติดต่อผู้ดูแลระบบเพื่อแจ้งถึงการเปลี่ยนแปลงเหล่านี้',
    'LBL_ACTIVITY_POST' => '{{{value}}}บน{{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'ไม่มีความคิดเห็น',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'แสดงความคิดเห็น{{{commentsLeft}}} ถัดไป',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'ยุบ',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'การสร้างการยืนยันความคิดเห็น',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'บันทึกความคิดเห็นไม่สามารถเว้นว่างได้',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'ดาวน์โหลด PDF {{{pdfTemplateName}}}',

    'ERR_SYNC_FAILED' => 'ไม่สามารถซิงค์กับเซิร์ฟเวอร์',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'ไม่ได้รับอนุญาตให้เข้าถึง',
    'ERR_MOBILE_INVALID_CREDS' => 'ชื่อผู้ใช้หรือรหัสผ่านไม่ถูกต้อง',
    'ERR_MOBILE_SESSION_EXPIRED' => 'เซสชันของคุณหมดอายุแล้ว',
    'ERR_MOBILE_NOT_FOUND' => 'ไม่พบทรัพยากร',
    'ERR_MOBILE_TIMEOUT' => 'เซิร์ฟเวอร์ไม่ตอบสนอง',
    'ERR_MOBILE_CONNECTION_FAILED' => 'ไม่สามารถติดต่อเซิร์ฟเวอร์',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'ไม่มีการเชื่อมต่ออินเทอร์เน็ต',
    'ERR_MOBILE_INTERNAL' => 'ข้อผิดพลาดภายใน ({{{code}}}) โปรดลองอีกครั้งในภายหลัง',
    'ERR_MOBILE_VALIDATION' => 'ระเบียนไม่ถูกต้อง',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'รุ่นของเซิร์ฟเวอร์เข้ากันไม่ได้: {{{flavor}}} รุ่นที่ใช้ได้: {{{supportedFlavors}}}',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'เวอร์ชันของเซิร์ฟเวอร์เข้ากันไม่ได้: {{{version}}} เวอร์ชันที่ต้องการขั้นต่ำ: {{{minVersion}}}',
    'ERR_MOBILE_EMAIL' => 'ข้อผิดพลาด ที่อยู่อีเมลไม่ถูกต้อง',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'ไม่สนับสนุนเอกสารประเภทนี้',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'การตรวจสอบสิทธิ์ล้มเหลว',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'ไม่พบทรัพยากรที่ขอ',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'เกิดข้อผิดพลาดกับเซิร์ฟเวอร์ภายใน',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'ห้ามใช้',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'บริการไม่พร้อมใช้งาน',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'เกิดข้อผิดพลาดที่ไม่คาดหมาย',
    'ERR_MOBILE_UPLOAD' => 'เกิดข้อผิดพลาดระหว่างอัปโหลดไฟล์',
    'ERR_MOBILE_FILE_PROCESSING' => 'ข้อผิดพลาดของการประมวลผลไฟล์',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'พื้นที่เก็บข้อมูลของอุปกรณ์ใช้ไม่ได้',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'แอปนี้เก่าเกินไปและเข้ากันไม่ได้กับอินสแตนซ์ของ {{{brandName}}} ที่คุณกำลังเชื่อมต่อ คุณต้องการดาวน์โหลดเวอร์ชันใหม่จาก App Store หรือไม่',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'การกำหนดค่าเซิร์ฟเวอร์เปลี่ยนไป และจะต้องมีการโหลดซ้ำ ดำเนินการต่อหรือไม่',
    'ERR_MOBILE_CONFLICT' => 'มีคนแก้ไขระเบียนเดียวกันในเซิร์ฟเวอร์ โปรดยืนยันเพื่อผสานการเปลี่ยนแปลงโดยอัตโนมัติ หรือปฏิเสธเพื่อยกเลิกการเปลี่ยนแปลง',
    'ERR_MOBILE_METADATA_CHANGED' => 'การกำหนดค่าเซิร์ฟเวอร์มีการเปลี่ยนแปลง',
    'ERR_MOBILE_FILE_READ' => 'ไม่สามารถอ่านไฟล์',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'ไม่พบไฟล์',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'อ่านไฟล์ไม่ได้',
    'ERR_MOBILE_FILE_ABORTED' => 'การอ่านถูกล้มเลิก',
    'ERR_MOBILE_FILE_SECURITY' => 'ไฟล์ถูกล็อค',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'เวอร์ชันสำหรับอุปกรณ์เคลื่อนที่ไม่สนับสนุนฟังก์ชันการทำงานนี้ คุณต้องการเปิดเวอร์ชันสำหรับเดสก์ท็อปหรือไม่',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'ไฟล์มีขนาดใหญ่เกินไป ขนาดที่ใช้ได้สูงสุดคือ {{size}}',
    'ERR_OFFLINE' => 'เกิดข้อผิดพลาดออฟไลน์',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'ไม่สามารถเปิดพื้นที่เก็บข้อมูลในระบบ',
    'ERR_OFFLINE_STORAGE_CREATE' => 'ไม่สามารถสร้างพื้นที่เก็บข้อมูลในระบบ',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'ไม่สามารถสร้างพื้นที่เก็บข้อมูลในระบบ: คุณมีพื้นที่เก็บข้อมูลไม่เพียงพอ',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'คุณมีพื้นที่เก็บข้อมูลในระบบไม่เพียงพอ',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'การล้างข้อมูลฐานข้อมูลล้มเหลว',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'คุณมีพื้นที่ไม่เพียงพอสำหรับการเก็บข้อมูลออฟไลน์ ขอแนะนำให้ล้างข้อมูลในพื้นที่เก็บข้อมูล ขั้นตอนนี้อาจใช้เวลานานหลายนาที',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'ไม่สามารถเรียกระเบียนล่วงหน้าจากเซิร์ฟเวอร์',
    'ERR_OFFLINE_SYNC_ERROR' => 'ข้อผิดพลาดในการซิงโครไนซ์',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'เกิดความขัดแย้งในการซิงโครไนซ์',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'ไม่สามารถเรียกเวลาของเซิร์ฟเวอร์',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'ไม่สามารถเปิดใช้งานโหมดออฟไลน์ ไม่สามารถติดต่อเซิร์ฟเวอร์',
    'LBL_EXPORT_CSV' => 'ส่งออก CSV',
    'LBL_ERR_EXPORTING_CSV' => 'การส่งออกล้มเหลว',
    'LBL_ERR_EXPORT_ALL' => 'การเรียกคืนข้อมูลระเบียนที่เลือกไว้ล้มเหลว โปรดลองใหม่อีกครั้ง',
    'LBL_LIST_SETTINGS_RESTORE' => 'เรียกคืนค่าเริ่มต้น',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'เรียกคืนฟิลด์หรือไม่',
    'LBL_LIST_SETTINGS_TITLE' => 'เครื่องมือสร้างมุมมองรายการ',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'ฟิลด์ที่พร้อมใช้งาน',
    'LBL_LIST_SETTINGS_REMOVE' => 'นำออก',
    'LBL_LIST_SETTINGS_TEXT' => 'ลากฟิลด์ไปที่เครื่องมือสร้างมุมมองรายการ แล้วจัดตำแหน่งฟิลด์ใหม่เพื่อออกแบบมุมมองรายการของ {{moduleName}}',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'ต้องเพิ่มอย่างน้อยหนึ่งฟิลด์เข้าไปในเลย์เอาต์',
    'LBL_LIST_SETTINGS_EMPTY' => 'ไม่มีฟิลด์ที่พร้อมใช้งาน',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'ไม่มีฟิลด์ที่ตรงกัน',
    'LBL_LIST_FILTER' => 'ค้นหาฟิลด์',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'อีเมลไคลเอนต์',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'อีเมลไคลเอนต์จากภายนอก',
    'LBL_SUGAR_MOBILE_CLIENT' => 'อีเมลไคลเอนต์ Sugar',
    'LBL_OFFLINE_CAPABILITIES' => 'เปิดใช้งานคุณสมบัติออฟไลน์',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'ลบธุรกรรมไม่สำเร็จ',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'ลบธุรกรรมแล้ว',
    'LBL_SECURE_MODE' => 'เพิ่มประสิทธิภาพโหมดรักษาความปลอดภัย',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'เปิดใช้งานการตั้งค่านี้เพื่อซ่อนเนื้อหาของ Sugar Mobile เมื่อแอปทำงานในพื้นหลัง และเพื่อป้องกันการถ่ายภาพหน้าจอของแอปในทุกเวลา',
    'LBL_SECURE_MODE_IOS_TEXT' => 'เปิดใช้งานการตั้งค่านี้เพื่อซ่อนเนื้อหาของ Sugar Mobile เมื่อแอปทำงานในพื้นหลัง',
    'LBL_ALWAYS_OFFLINE_MODE' => 'โหมดออฟไลน์ตลอดเวลา',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'คุณกำลังใช้งานอยู่ในโหมดออฟไลน์ตลอดเวลา คุณต้องการเชื่อมต่ออีกครั้งหรือไม่',
    'LBL_RECONNECT' => 'เชื่อมต่ออีกครั้ง',
    'LBL_STAY_OFFLINE' => 'ออฟไลน์ต่อไป',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'โมดูลที่คุณกำลังพยายามเข้าถึงไม่พร้อมใช้งานใน Sugar Mobile',
    'LBL_MOBILE_RELEASE_NOTE' => 'บันทึกประจำรุ่น Sugar Mobile สำหรับ {{platform}}',
    'LBL_MOBILE_USER_GUIDE' => 'คู่มือผู้ใช้ Sugar Mobile สำหรับ {{platform}}',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'มีคำเหล่านี้',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'ไม่รวมคำเหล่านี้',
    'LBL_NOTIFICATIONS_CHANNEL' => 'อัปเดต',
    'LBL_APPLY_BUTTON_LABEL' => 'ใช้',
    'LBL_ACTION_CREATE_FAILURE' => "บันทึกระเบียนไม่สำเร็จ:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "อัปเดตระเบียนไม่สำเร็จ:\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'คำนวณฟิลด์ในเซิร์ฟเวอร์ไม่สำเร็จ',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'ฟิลด์ต่อไปนี้ไม่ถูกต้อง => {{{fields}}}',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>สำเร็จ</b> คุณสร้าง {{{module}}} สำเร็จแล้ว <a href="#{{{recordUrl}}}">"{{{recordName}}}"</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>สำเร็จ</b> คุณอัปเดตระเบียนสำเร็จแล้ว',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'รับข้อมูลจากเซิร์ฟเวอร์ไม่สำเร็จ',
    'LBL_ASSIGN_SUCCESS' => '<b>สำเร็จ</b> มอบหมายระเบียนให้ {{{userName}}} แล้ว',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'บันทึกอีเมลนี้เป็นร่างจดหมาย',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'บันทึกเป็นร่างจดหมาย',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'ละทิ้งอีเมล',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'หากคุณไม่บันทึกร่างจดหมาย คุณจะสูญเสียอีเมลฉบับนี้',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'เลือกลายเซ็น',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'เลือกเทมเพลตอีเมล',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'เทมเพลตจะเขียนทับทุกเนื้อหาที่อยู่ในอีเมลฉบับนี้ คุณแน่ใจหรือไม่ว่าต้องการใช้เทมเพลตนี้และเขียนทับเนื้อหา',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'เขียนอีเมล',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'อีเมลของคุณมีตัวแปรที่จะถูกแทนที่โดยใช้ค่าจากค่าที่ "เกี่ยวข้องกับ" ระเบียน โปรดยืนยันว่ามีการตั้งค่าที่ "เกี่ยวข้องกับ" ฟิลด์อย่างถูกต้อง',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'ไม่พบบัญชีอีเมลขาออก โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณ',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' และอีก {{{count}}}',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'เพิ่มอีเมล',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'พิมพ์ชื่อผู้ติดต่อหรืออีเมล',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (อีเมลใหม่)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'ตัวแปร',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'เทมเพลตอีเมล',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'เทมเพลตแคมเปญ',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'เทมเพลตเวิร์กโฟลว์',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'เทมเพลตระบบ',
    'LBL_FILTER_EDIT' => 'แก้ไขตัวกรอง',
    'LBL_FILTER_MY_FILTER' => 'ตัวกรองของฉัน',
    'LBL_FILTER_MY_FILTER_BY' => 'ตัวกรองของฉันตาม {{{filters}}}',
    'LBL_FILTER_SAVE' => 'บันทึกตัวกรอง',
    'LBL_SELECT_PARAM' => 'เลือก',
    'LBL_SELECT_MODULES' => 'เครื่องมือเลือกโมดูล',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'เลือกพารามิเตอร์เพิ่มเติม',
    'LBL_FILTER_TEMPORARY' => 'ตัวกรองชั่วคราว',
    'LBL_ERROR_FILE_UPLOAD' => 'อัปโหลดล้มเหลว {{{fieldLabel}}} ไฟล์ "{{{fileName}}}" {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">ดูระเบียนที่ล้มเหลว</a>',
    'LBL_FILE_UPLOAD_ONE' => 'กำลังบันทึกไฟล์...',
    'LBL_FILE_UPLOAD_MANY' => 'กำลังบันทึกไฟล์ {{{index}}} ใน {{{total}}}...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'การตั้งค่าการแจ้งเตือน',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'จัดการการแจ้งเตือนแบบพุชของคุณ',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "ควบคุมการแสดงการแจ้งเตือนโดยใช้การตั้งค่าการแจ้งเตือนของอุปกรณ์คุณ",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'งานที่มอบหมาย',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'รับการแจ้งเตือนเมื่อมีการมอบหมายระเบียนให้กับคุณ',
    'LBL_NOTIFICATION_MENTIONS' => 'การกล่าวถึง',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'รับการแจ้งเตือนเมื่อมีการกล่าวถึงคุณในบันทึกความคิดเห็น',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'ผู้ดูแลระบบยังไม่ได้เพิ่มฟิลด์บันทึกความคิดเห็นลงไปในเลย์เอาต์นี้ โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณ',
    'ERR_NO_PERMISSION_TITLE' => 'โปรดอนุญาตการเข้าถึง',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} ต้องมีการเข้าถึงกล้องถ่ายรูปเพื่อให้คุณสามารถแนบภาพถ่ายได้ โปรดอนุญาตการเข้าถึงกล้องถ่ายรูปในการตั้งค่าระบบ',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'การตั้งค่า',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'ระยะเวลา',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'เวลาที่เหลือ',
    'LBL_LIST_SUPPORT_EXPIRES' => 'หมดอายุ',
    'LBL_CASCADE_RLI_EDIT' => 'อัปเดตรายการบรรทัดรายได้ที่เปิดอยู่',
    'LBL_MOBILE_CALENDAR' => 'ปฏิทิน',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'ตั้งค่าปฏิทิน',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'วันแรกของสัปดาห์',
    'LBL_MOBILE_CALENDAR_MODULES' => 'กิจกรรมเพื่อแสดง',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}ชม.:{{{minutes}}} น.',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} นาฬิกา',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} น.',
    'LBL_MOBILE_CALENDAR_TODAY' => 'วันนี้',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => 'เพิ่ม {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'วางกำหนดการกิจกรรม',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'โปรดเปิดใช้งานอย่างน้อยหนึ่งประเภภทกิจกรรม',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'ทั้งวัน',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'โหลดปฏิทินล้มเหลว',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'การกระทำนี้ไม่พร้อมใช้งานใน Sugar Mobile คุณต้องการเปิดแอปพลิเคชันแทนหรือไม่',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'เลือกเทมเพลต',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'ผสาน',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'ผิดพลาด: ข้อมูล EXIF หายไปจากไฟล์ HEIC',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'ผิดพลาด: ความละเอียดภาพสูงเกินไป',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'ผิดพลาด: ไม่สามารถดำเนินการภาพได้',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'ผิดพลาด: แสดงภาพไปยังแคนวาสไม่สำเร็จ',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'ผิดพลาด: โหลดไฟล์เป็นภาพไม่สำเร็จ',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => 'เลือกแล้ว 1 รายการ',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => 'เลือกแล้ว {{{count}}} รายการ',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'เลือกทั้งหมด',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'คุณได้เลือก {{{count}}} ระเบียนในมุมมองนี้ ต้องการเลือกระเบียนทั้งหมดหรือไม่',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'เลือก {{{count}}} ระเบียน',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'คุณแน่ใจหรือไม่ว่าต้องการลบระเบียนที่เลือก',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'กำลังลบ… {{{count}}} ใน {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'ไม่พบอีเมลที่ถูกต้องในระเบียนที่เลือก',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'ลักษณะ',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'ใช้การตั้งค่าระบบ',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'สว่าง',
    'LBL_MOBILE_APP_THEME_DARK' => 'เข้ม',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'ชื่อไฟล์ใหม่',
    'LBL_ATTACHMENT_RENAME_MSG' => 'ตั้งชื่อไฟล์ใหม่',
    // Filters related
    'LBL_CREATED_BY_ME' => 'สร้างโดยตัวฉัน',
    'LBL_OPERATOR_ONE_OF' => 'เป็นหนึ่งใน',
    'LBL_OPERATOR_NOT_ONE_OF' => 'ไม่เป็นหนึ่งใน',
    'LBL_OPERATOR_CONTAINS' => 'ค่าใดค่าหนึ่งจาก',
    'LBL_OPERATOR_CONTAINS_WORD' => 'ประกอบด้วย',
    'LBL_OPERATOR_NOT_CONTAINS' => 'ไม่ใช่ค่าใดค่าหนึ่งจาก',
    'LBL_OPERATOR_EMPTY' => 'ว่างเปล่า',
    'LBL_OPERATOR_NOT_EMPTY' => 'ไม่ว่างเปล่า',
    'LBL_OPERATOR_MATCHES' => 'ตรงทั้งหมด',
    'LBL_OPERATOR_STARTS_WITH' => 'เริ่มต้นด้วย',
    'LBL_OPERATOR_EQUALS' => 'เท่ากับ',
    'LBL_OPERATOR_NOT_EQUALS' => 'ไม่เท่ากับ',
    'LBL_OPERATOR_GREATER_THAN' => 'มากกว่า',
    'LBL_OPERATOR_LESS_THAN' => 'น้อยกว่า',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'มากกว่าหรือเท่ากับ',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'น้อยกว่าหรือเท่ากับ',
    'LBL_OPERATOR_BETWEEN' => 'อยู่ระหว่าง',
    'LBL_OPERATOR_BEFORE' => 'ก่อน',
    'LBL_OPERATOR_AFTER' => 'หลัง',
    'LBL_OPERATOR_YESTERDAY' => 'เมื่อวานนี้',
    'LBL_OPERATOR_TODAY' => 'วันนี้',
    'LBL_OPERATOR_TOMORROW' => 'พรุ่งนี้',
    'LBL_OPERATOR_LAST_7_DAYS' => '7 วันที่ผ่านมา',
    'LBL_OPERATOR_NEXT_7_DAYS' => '7 วันถัดไป',
    'LBL_OPERATOR_LAST_30_DAYS' => '30 วันที่ผ่านมา',
    'LBL_OPERATOR_NEXT_30_DAYS' => '30 วันถัดไป',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'มากกว่า __ วันมาแล้ว',
    'LBL_OPERATOR_LAST_X_DAYS' => '__ วันที่ผ่านมา',
    'LBL_OPERATOR_NEXT_X_DAYS' => '__ วันถัดไป',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'มากกว่า __ วันในอนาคต',
    'LBL_OPERATOR_LAST_MONTH' => 'เดือนล่าสุด',
    'LBL_OPERATOR_THIS_MONTH' => 'เดือนนี้',
    'LBL_OPERATOR_NEXT_MONTH' => 'เดือนถัดไป',
    'LBL_OPERATOR_LAST_YEAR' => 'ปีล่าสุด',
    'LBL_OPERATOR_THIS_YEAR' => 'ปีนี้',
    'LBL_OPERATOR_NEXT_YEAR' => 'ปีถัดไป',
    'LBL_OPERATOR_IS' => 'เป็น',
    'LBL_OPERATOR_IS_NOT' => 'ไม่ใช่',
    'LBL_OPERATOR_AFTER_TODAY' => 'หลังจากวันนี้',
    'LBL_OPERATOR_BEFORE_TODAY' => 'ก่อนวันนี้',
    'LBL_ERROR_FILTER_EMPTY' => 'โปรดใส่เกณฑ์ตัวกรอง',
    'LBL_ADD_FILTER' => 'ใส่เกณฑ์ตัวกรอง',
    'LBL_FILTER_NAME' => 'ชื่อตัวกรอง',
    'LBL_FILTER_FIELD' => 'ฟิลด์',
    'LBL_FILTER_OPERATOR' => 'โอเปอเรเตอร์',
    'LBL_FILTER_VALUE' => 'ค่า',
    'LBL_FILTER_SYNC_TO_SERVER' => 'บันทึกลงในแอป Desktop',
    'LBL_FILTER_LOCAL' => 'ตัวกรองในระบบ',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'ยินดีต้อนรับสู่ {{{brandName}}}<br/><br/> เราจะขอแนะนำคุณลักษณะใหม่บางประการ...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'การนำทางของเมนูหลัก',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'การดำเนินการที่ใช้ได้ในแต่ละมุมมอง',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'การค้นหาระเบียนทั้งระบบ',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'กรองรายการเพื่อแสดงระเบียนรายการโปรดของฉัน',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'กรองรายการนี้เพื่อแสดงระเบียนที่ระบุให้ฉัน',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'ทำเครื่องหมายระเบียนเป็นรายการโปรด',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'กิจกรรมที่จะมาถึงของฉันเริ่มจากวันนี้',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'ระเบียนที่แก้ไขล่าสุด',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'การดำเนินการที่ใช้ได้กับระเบียน',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'หวังว่าคุณจะได้รับประโยชน์จากคุณลักษณะใหม่ๆ',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'นี่คือเมนูเสริม',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'ปิดเมนูเสริม',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'เลือกการดำเนินการที่เจาะจงเพื่อดูและดำเนินการ',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'นี่คือเมนูหลัก',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'ปิดเมนูหลัก',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'ดูโมดูลที่ต้องการ',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'ปรับแต่งแอปพลิเคชัน',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'เปิด Sugar ในเว็บเบราว์เซอร์',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'ดูโปรไฟล์ของคุณ',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'นี่คือเพจรายละเอียด',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'ข้อมูลที่สำคัญที่สุดเกี่ยวกับระเบียน',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'ดูข้อมูลเพิ่มเติมหรือแก้ไขระเบียน',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'การดำเนินการที่ใช้ได้กับระเบียน',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'ไปที่เพจก่อนหน้า',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'เข้าสู่การทัวร์ได้ทุกเวลา',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'ย้อนกลับ',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'คลิกเพื่อเปิดระเบียนที่เกี่ยวข้อง',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'ติดตาม/เลิกติดตามระเบียน',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'คลิกเพื่อขยายข้อมูลรายละเอียด',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'มุมมองเมนูหลัก',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'เมนูหลักจะเปิดที่ด้านซ้ายของหน้าจอ',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'มุมมองรายละเอียด',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'มุมมองรายละเอียดจะเปิดที่ด้านขวาของหน้าจอ',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'ใช้ลูกศรด้านล่างเพื่อทัวร์ชมส่วนต่างๆ ในองค์ประกอบหลักของเมนูนี้',

    'LBL_COMMENT_ADD' => 'ใส่ความคิดเห็น',
    'LBL_REQUIRED' => 'ต้องระบุ',
    'LBL_MORE_BUTTON' => 'เพิ่มเติม',
    'LBL_NO_OPTIONS' => 'ไม่มีตัวเลือกที่ใช้ได้',
    'LBL_TRY_AGAIN' => 'ลองใหม่อีกครั้ง',
    'LBL_NEW_RECORDS' => 'สร้างล่าสุด',
    'LBL_ASSIGNED_TO_ME' => '{{{module}}} ของฉัน',
    'LBL_LISTVIEW_FILTER_ALL' => '{{{module}}} ทังหมด',
    'LBL_UNFAVORITE' => 'เลิกโปรดปราณ',
    'LBL_ACTIVITY_CREATE' => 'สร้าง {{{record}}} {{{module}}} แล้ว',
    'LBL_ACTIVITY_UPDATE' => 'อัปเดต {{{changes}}} บน {{{record}}} {{{module}}} แล้ว',
    'LBL_ACTIVITY_LINK' => 'เชื่อมต่อ {{{relatedRecord}}} กับ {{{record}}} {{{module}}} แล้ว',
    'LBL_ACTIVITY_UNLINK' => 'เลิกเชื่อมต่อ {{{relatedRecord}}} จาก {{{record}}} {{{module}}} แล้ว',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} สำหรับ {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'ดาวน์โหลดข้อความบันทึกที่เกี่ยวข้อง...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'การตั้งค่าแดชบอร์ดได้รับการเปลี่ยนแปลง คุณต้องการโหลดใหม่อีกครั้งหรือไม่',
    'LBL_RECORDS' => 'ข้อความบันทึก',
    'LBL_DASHBOARDS' => 'แดชบอร์ด',
    'LBL_TEMPLATES' => 'เทมเพลท',
    'LBL_NON_TEMPLATES' => 'ไม่ใช่เทมเพลต',
    'LBL_IS_TEMPLATE' => 'เป็นเทมเพลท',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'ตัวเลือกของคุณมีเทมเพลทแดชบอร์ด ซึ่งไม่สามารถอัปเดตจํานวนมากได้ โปรดยกเลิกการเลือกเทมเพลทเพื่อดําเนินการต่อ',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'ตัวเลือกของคุณมีเทมเพลทแดชบอร์ด ซึ่งไม่สามารถอัปเดตจํานวนมากได้ โปรดลบเทมเพลทเพื่อดําเนินการต่อ',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'ค้นหา {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'เมนูหลัก',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'สร้างข้อความบันทึกใหม่ฉับพลัน',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'ปัดเพื่อดูตัวเลือกเพิ่มเติม',
    'LBL_DETAILS' => 'รายละเอียด',
    'LBL_DETAIL_RELATED' => 'เกี่ยวข้อง',
    'LBL_CREATE_RELATED_MODULE_WARN' => '{{module}} นี้ต้องใช้ {{relatedModule}} <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;> สร้างบันทึก {{relatedModule}} </a>',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'แก้ไขข้อความบันทึก',
    'LBL_OFFLINE_MENU_SETTINGS' => 'การตั้งค่าแบบออฟไลน์',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'การตั้งค่าแก้ไขจุดบกพร่อง',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'จำนวนวินาทีทั้งหมด',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'การดาวน์โหลดครั้งล่าสุด',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'ไม่สามารถดาวน์โหลดไฟล์ได้',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'การดาวน์โหลดแดชบอร์ดจากเซิร์ฟเวอร์ล้มเหลว',
    'ERR_FILTERS_FETCHING' => 'ไม่สามารถดึงตัวกรองของคุณมาได้',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'การเข้ารหัสลับพื้นที่เก็บข้อมูลระยะยาวล้มเหลว',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'กำลังเข้ารหัสข้อมูลออฟไลน์ การดำเนินการนี้อาจใช้เวลานานหลายนาที',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'การเข้ารหัสข้อมูลออฟไลน์เสร็จสมบูรณ์',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'คุณไม่มีสิทธิ์ในการเข้าถึงโมดูล {{{module}}}',
    'LBL_SKIP' => 'ข้าม',
    'LBL_CONTINUE' => 'ดำเนินการต่อ',
    'LBL_ENABLE' => 'เปิดใช้งาน',
    'LBL_MOBILE_TRIAL_UNTIL' => 'ทดลองจนถึง',
    'LBL_MOBILE_SDK_VERSION' => 'เวอร์ชัน SDK',
    'LBL_LOG_LEVEL' => 'ระดับล็อก',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'มีการกำหนดค่าการตั้งค่าการลงชื่อเข้าใช้',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'หมดระยะเวลาการทดลองใช้ของคุณแล้ว',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'เซิร์ฟเวอร์ไม่รองรับการเชื่อมต่อแบบปลอดภัย กรุณาปิดการเชื่อมต่อแบบปลอดภัย',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'เซิร์ฟเวอร์รองรับการเชื่อมต่อแบบปลอดภัย กรุณาเปิดการเชื่อมต่อแบบปลอดภัย',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'การเชื่อมต่อของคุณไม่ปลอดภัย กรุณาติดต่อผู้ดูแลระบบของคุณ',
    'LBL_LOGIN_SETTINGS_HEADER' => 'การตั้งค่าการลงชื่อเข้าใช้',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'ตั้งค่าอินสแตนซ์ {{{brandName}}} ของคุณ',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'เพื่อให้แอปทำงานได้ คุณจะต้องพิมพ์ URL ของอินสแตนซ์ {{{brandName}}} หากคุณไม่มี URL ของอินสแตนซ์นั้น ๆ กรุณาติดต่อผู้ดูแลระบบของคุณ',
    'LBL_FACEID' => 'ระบบ Face ID',
    'LBL_TOUCHID' => 'ระบบ Touch ID',
    'LBL_ENABLE_TOUCHID' => 'เปิดใช้งาน {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => 'ติดตั้ง {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'ลงชื่อเข้าใช้ด้วยนิ้วของคุณ',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "ยังไม่มีการติดตั้ง {{{biometryType}}} บนอุปกรณ์ของคุณ\n\nไปยังการตั้งค่าในอุปกรณ์ของคุณเพื่อติดตั้ง {{{biometryType}}} เมื่อทำการติดตั้งแล้ว ให้เปิดการใช้งาน {{{biometryType}}} สำหรับ {{{brandName}}} ในเมนูหลัก > การตั้งค่า",
    'LBL_TOUCH_ID_DISCLAIMER' => 'การใช้ {{{biometryType}}} กับ {{{brandName}}} จะช่วยให้คุณได้ใช้การระบุตัวตนทางชีวภาพแทนการใส่รหัสผ่านเพื่อเข้าถึง {{{brandName}}}',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'คุณต้องการดำเนินการ {{{biometryType}}} ต่อหรือไม่    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'กรอกรหัสผ่านของ {{{brandName}}} เพื่อเปิดการใช้งาน {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'ตั้งค่า',
    'LBL_MDM_CONFIRM_CHANGE' => 'มีการเปลี่ยนแปลงการกำหนดค่าแอปพลิเคชันจากตัวจัดการอุปกรณ์โทรศัพท์มือถือ กรุณาลงชื่อเข้าใช้ใหม่เพื่อใช้งานการเปลี่ยนแปลงนั้น ๆ',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'กรุณาให้สิทธิ์ {{{brandName}}} ในการเข้าถึงตำแหน่งของคุณผ่านทางการตั้งค่าอุปกรณ์ของคุณ',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'ไม่มีตำแหน่งปัจจุบัน',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "การค้นคืนตำแหน่งปัจจุบันใช้เวลานานเกินไป \nกรุณาลองใหม่อีกครั้ง",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'ไม่มีหมุดแสดงตำแหน่ง',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'พิกัดตำแหน่งไม่ถูกต้อง',
    'ERR_MOBILE_INVALID_PASSWORD' => 'รหัสผ่านไม่ถูกต้อง',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'แอปของคุณล้าสมัย และไม่สามารถใช้ได้กับอินสแตนซ์ของ {{{brandName}}} ที่คุณกำลังเชื่อมต่ออีกต่อไป คุณต้องการอัปเดตแอปหรือไม่',
    'LBL_MOBILE_BY' => 'โดย',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'ตัวกรองนี้ไม่พร้อมใช้งานในแบบออฟไลน์',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'ข้อความบันทึกแบบออฟไลน์',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'ดาวน์โหลดการตั้งค่าต่าง ๆ',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'ดาวน์โหลดข้อความบันทึกที่คุณได้รับมอบหมาย โปรดปราน และติดตาม เพื่อให้สามารถเข้าถึงได้แบบออฟไลน์ ทั้งนี้คุณสามารถอัปเดตการกำหนดค่าตามความต้องการต่าง ๆ ในการตั้งค่าออฟไลน์',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'ข้อความบันทึกของคุณเสร็จสิ้นกระบวนการดาวน์โหลดแล้ว ขณะนี้คุณสามารถเข้าถึงข้อมูลเหล่านั้นในโหมดออฟไลน์แล้ว',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "ข้อความบันทึกของคุณไม่ได้รับการดาวน์โหลดทั้งหมด \n คุณต้องการลองใหม่หรือไม่",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'ใช้ข้อมูลเซลลูลาร์',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'ไม่ดำเนินการตอนนี้',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'หยุดการดาวน์โหลดชั่วคราว และจะดาวน์โหลดอีกครั้งเมื่อคุณเปิดแอปครั้งต่อไป',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'กำลังดาวน์โหลด {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'อัปเดตข้อความบันทึกล่าสุด',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'กำลังรอการเชื่อมต่อ',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'หยุดชั่วคราว',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'กำลังหยุด',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'ดาวน์โหลด',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'หยุดชั่วคราว',
    'LBL_BULK_LOAD_BTN_RESUME' => 'ทำงานต่อ',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'ใช้การเชื่อมต่อ WiFi เท่านั้นในค่าเริ่มต้น',
    'LBL_NPS_RATING_MSG' => "คุณจะให้คะแนนประสบการณ์การใช้ {{{productName}}} อย่างไร",
    'LBL_NPS_THANKS_MSG' => 'ขอบคุณสำหรับคำติชม!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'คุณสะดวกที่จะให้คะแนนแอปที่ App Store หรือไม่',
    'LBL_NPS_NO_THANKS' => 'ไม่ ขอบคุณ',
    'LBL_NPS_NOT_NOW' => 'ไม่ใช่ตอนนี้',
    'LBL_NPS_RATE_NOW' => 'ให้คะแนนตอนนี้',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'เครือข่ายไม่พร้อมใช้งาน คุณยังสามารถใช้แอปขณะออฟไลน์ได้',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'การเปลี่ยนแปลงต่าง ๆ จะได้รับการซิงค์เมื่อคุณออนไลน์ <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>ดูรายละเอียด</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'มีข้อมูลที่ไม่ได้ซิงค์ กรุณาตรวจสอบ <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>บันทึกธุรกรรม</a>',
    'LBL_CONVERT' => 'แปลงค่า',
    'LBL_CONVERT_LEAD' => 'แปลงผู้สนใจ',
    'LBL_SEARCH_EXISTING_RECORD' => 'ค้นหา {{{this}}} ที่มีอยู่',
    'LBL_DUPLICATES_CHECK_FAILED' => 'การตรวจสอบซ้ำล้มเหลว',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'คุณต้องการย้ายกิจกรรมที่เกี่ยวข้องไปยังข้อมูลบันทึกผู้ติดต่อหรือไม่',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'คุณแปลงผู้สนใจ {{{name}}} สำเร็จแล้ว',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'ไม่พบข้อมูลซ้ำ',
    'ERR_LEAD_CONVERSION_FAIL' => 'การแปลงผู้สนใจล้มเหลว',
    'LBL_SELECT_DUPLICATE_RECORD' => 'เลือกจาก {{{modulePlural}}} ซ้ำ',
    'LBL_SELECTED_EXISTING_RECORD' => '{{{moduleSingular}}} ที่เลือก',
    'LBL_CREATED_NEW_RECORD' => 'สร้าง {{{moduleSingular}}} ใหม่แล้ว',
    'LBL_VO_BACK_BTN' => 'ปุ่มย้อนกลับ',
    'LBL_VO_HOME_BTN' => 'ปุ่มหน้าแรก',
    'LBL_VO_DASHBOARD_BTN' => 'ปุ่มแดชบอร์ด',
    'LBL_VO_SEARCH_BTN' => 'ปุ่มค้นหา',
    'LBL_VO_RIGHT_MENU_BTN' => 'ปุ่มเมนูด้านขวา',
    'LBL_VO_ADD_BTN' => 'เพิ่มปุ่ม',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'ส่วนลด',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'เลือกแอปแผนที่',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => '{{entityName}} ที่เลือกไว้มีค่าที่เกี่ยวข้อง: {{localizedFieldNames}} ยกเลิกเพื่อเก็บค่าที่มีอยู่แล้ว ยืนยันเพื่อเขียนทับด้วยค่าใหม่',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'เปิดใช้งานการเข้ารหัสข้อมูลแล้ว',
    'LBL_LEAD_ALREADY_CONVERTED' => 'ผู้สนใจที่เลือกได้รับการแปลงแล้ว',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'การกระทำนี้สามารถทำได้เมื่ออุปกรณ์ออนไลน์อยู่เท่านั้น',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'คุณแน่ใจหรือไม่ว่าต้องการสร้างโอกาสทางการขายจากการเสนอราคา',
    'LBL_TAG_ADD' => 'เพิ่มแท็ก',
    'LBL_TAG_ENTER_TAG_NAME' => 'ป้อนแท็ก',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'ไม่รองรับการกรองโดยใช้แท็กขณะที่อุปกรณ์กำลังออฟไลน์',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'แสดงความคิดเห็นทั้งหมด',
    'LBL_COMMENT_VIEW' => 'ดูความคิดเห็น',
    'LBL_PMSE_LABEL_DUEDATE' => 'วันที่ครบกำหนด',
    'LBL_PMSE_DUE' => 'ครบกำหนด',
    'LBL_PMSE_DUE_ON' => 'ครบกำหนดเมื่อ',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'โปรดสร้าง {{conversionParentModuleName}} ก่อน',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'ขาดระเบียนที่ต้องใช้: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'เลือกคุณภาพรูปภาพ รูปภาพจะได้รับการปรับขนาดให้เหมาะสมก่อนที่จะบันทึกลงในเวิร์ฟเวอร์ ค่าที่เลือกจะถูกนำมาใช้เป็นค่าเริ่มต้นสำหรับการกระทำที่คล้ายคลึงกันในอนาคต',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'กำลังคาดการณ์ขนาดไฟล์',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'ขนาดไฟล์ที่คาดการณ์คือ',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'คุณภาพรูปภาพ',
    'LBL_IMAGE_QUALITY_BEST' => 'ขนาดเดิม',
    'LBL_IMAGE_QUALITY_GOOD' => 'คุณภาพดี',
    'LBL_IMAGE_QUALITY_POOR' => 'ขนาดเล็ก',
    'LBL_IMAGE_QUALITY_BTN' => 'การบีอัด: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'ฟิลด์ที่ทำรายการใน {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'รีเซ็ตไปใช้ค่าเริ่มต้น',
    'LBL_LIST_NOT_ENOUGH' => 'โปรดติดตั้งฟิลด์ให้ทำงานอย่างน้อย 1 ฟิลด์',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'คุณต้องเข้าระบบและให้การอนุญาตต่าง ๆ เพื่อที่จะสามารถใช้งานอินสแตนซ์ SugarCRM ได้',
    'LBL_SELECTING_EXISTING_RECORD' => 'กำลังเลือก {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'กำลังสร้าง {{{moduleSingular}}} ใหม่',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'ขนาดรูปภาพ',
    'LBL_COPY_ADDRESS' => 'คัดลอกที่อยู่',
    'LBL_OPEN_IN' => 'เปิดใน',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'ไม่ได้เลือกไฟล์',
    'LBL_ATTACHMENT_ADD' => 'แนบ',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'แอปนี้ใช้คุ้กกี้',
    'LBL_USE_COOKIES_CONFIRM' => 'แอปพลิเคชันนี้ใช้คุ้กกี้เพื่อช่วยให้คุณได้ประสบการณ์ที่ดีกว่า ในการใช้งานแอปต่อหมายความว่าคุณยินยอมต่อการใช้งานคุ้กกี้ตามนโยบายความเป็นส่วนตัวของเรา',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'คุณกำลังใช้อินสแตนซ์ Sugar ที่สามารถใช้กันได้กับ Sugar Mobile ในการปล่อยตัวแอปสำหรับโทรศัพท์มือถือที่กำลังจะมีขึ้น โปรดสอบถามผู้ดูแลระบบของคุณเพื่อทำการอัปเกรด Sugar โดยเร็วที่สุด',
    'ERROR_TAG_NAME_INVALID' => 'ชื่อแท็กไม่สามารถประกอบด้วยตัวอักษร "{{{forbiddenChars}}}"',
    'ERROR_NO_TAGS_FOUND' => 'ไม่มีแท็กที่ตรงกับ "{{{searchQuery}}}" พร้อมใช้งาน',
    'ERR_PA_RECORD_INVALID' => 'ระเบียน {{{moduleName}}} มีค่าที่ไม่ถูกต้องหนึ่งหรือมากกว่าหนึ่งและไม่สามารถบันทึกได้ คุณต้องการแก้ไขระเบียนเพื่อทำการ {{{actionLabel}}} หรือไม่',
    'ERR_MOBILE_METADATA_RELOAD' => 'ผู้ดูแลได้เปลี่ยนแปลงการกำหนดค่าในอินซแตนซ์ Sugar ของคุณ โปรดกดปุ่ม ตกลง เพื่อซิงค์การกำหนดค่าแอปของคุณเข้ากับเซิร์ฟเวอร์',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'แอปพลิเคชันนี้ใช้คุกกี้',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'ทำเครื่องหมายเพื่อยินยอม (จำเป็น)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'แอปพลิเคชันนี้ใช้คุกกี้เพื่อช่วยให้ประสบการณ์ที่ดีกว่าแก่คุณ คุณยินยอมการใช้คุกกี้ตามที่ระบุใน <a href="{{href}}" target="_blank">นโยบายความเป็นส่วนตัว</a> ของเราโดยการดำเนินการใช้แอปพลิเคชันต่อไป',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'มุมมองระเบียนใช้สำหรับดูรายละเอียดของระเบียน',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'บันทึกใช้สำหรับการทำงานร่วมกับผู้ใช้พอร์ทัลอื่นๆ และตัวแทนการสนับสนุน',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'คลิกที่นี่เพื่อเพิ่มบันทึกในระเบียนนี้',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'คลิกที่ไอคอนเหล่านี้เพื่อดูรายละเอียดของบันทึกที่แนบมา',

    //for portal
    'LBL_PORTAL_HOME' => 'แดชบอร์ดหน้าหลัก',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'เคสที่เปิดทั้งหมด',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'เคสที่ได้รับการแก้ไขเมื่อเร็ว ๆ นี้',
    'LBL_PORTAL_SEARCH' => 'ค้นหาจากชื่อ, หมายเลข',
    'LBL_SIGNUP_BUTTON_LABEL' => 'สมัคร',
    'LBL_PORTAL_NO_EMAIL' => 'ไม่ได้รับอีเมลใช่ไหม',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'ลืมรหัสผ่าน',
    'LBL_PORTAL_FORGOT_USERNAME' => 'ลืมชื่อผู้ใช้',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'ใส่รหัสผ่านของคุณซ้ำสองครั้ง รหัสผ่านจะต้องตรงกัน',
    'LBL_PORTAL_RESET_PASSWORD' => 'รีเซ็ตรหัสผ่าน',
    'LBL_PORTAL_REENTER_PASSWORD' => 'ใส่รหัสผ่านอีกครั้ง',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'รหัสผ่านไม่ตรงกัน กรุณาใส่ใหม่อีกครั้ง',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'ดำเนินการรีเซ็ตรหัสผ่านของคุณเสร็จสมบูรณ์แล้ว',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'มีข้อผิดพลาดเกิดขึ้น โปรดสร้างรหัสผ่านใหม่และส่งคำขอรีเซ็ตรหัสผ่าน',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'ลงทะเบียน',
    'LBL_PORTAL_SIGNUP_TITLE' => 'ขอขอบคุณที่สมัครใช้งาน',
    'LBL_PORTAL_SIGNUP' => 'เราจะแจ้งให้คุณทราบหลังจากที่ยืนยันข้อมูลของคุณแล้ว',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'ชื่อ',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'นามสกุล',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'ชื่อผู้ใช้',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'ที่อยู่อีเมล',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (เลือกระบุได้)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'ประเทศ',
    'LBL_PORTAL_SIGNUP_STATE' => 'รัฐ',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'ชื่อบริษัท',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'ตำแหน่งงาน (เลือกระบุได้)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'รหัสผ่าน',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'ยืนยันรหัสผ่าน',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'ลืมล็อกอิน',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'ลืมรหัสผ่าน?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณเพื่อรีเซ็ตรหัสผ่าน',
    'LBL_PORTAL_LOGIN_USERNAME' => 'ชื่อผู้ใช้',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'รหัสผ่าน',
    'LBL_PORTAL_LOADING' => 'กำลังโหลด',
    'LBL_PORTAL_SAVING' => 'กำลังบันทึก',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'ไม่สามารถใช้เพจ',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "ขออภัย คุณลักษณะนี้ไม่สามารถใช้ได้ในขณะนี้",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'แสดงผลลัพธ์การสืบค้นสำหรับ "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'ไม่ได้รับอีเมลใช่ไหม',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'หากต้องการความช่วยเหลือหรือต้องการติดต่อเรา โปรดใช้ช่องทางดังต่อไปนี้: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'โทรศัพท์: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'อีเมล: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'เว็บ: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'คุณแน่ใจหรือไม่ว่าต้องการปิดการสนทนา',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'สร้างบันทึกหรือเพิ่มไฟล์แนบ',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'เพิ่มบันทึก',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'ล็อกอินไม่สำเร็จ โปรดลองใหม่อีกครั้ง',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'ข้อมูลประจำตัวไม่ถูกต้อง',
    'LBL_PORTAL_INVALID_GRANT' => 'เซสชันของคุณไม่ถูกต้องหรือหมดอายุ โปรดล็อกอินอีกครั้ง',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'เซสชันหมดอายุแล้ว',
    'LBL_PORTAL_AUTH_FAILED' => 'การตรวจสอบสิทธิ์ไคลเอนต์ล้มเหลว',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'ไคลเอนต์ไม่ถูกต้อง',
    'LBL_PORTAL_INVALID_REQUEST' => 'คำขอที่ส่งไม่ถูกต้องหรือมีรูปแบบไม่ถูกต้อง โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'คำขอไม่ถูกต้อง',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'คำขอหมดเวลาแล้ว',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'หมดเวลาของคำขอ',
    'LBL_PORTAL_UNAUTHORIZED' => 'ขออภัย ดูเหมือนคุณจะไม่ได้รับอนุญาตให้เข้าถึงทรัพยากรนี้',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'ไม่ได้รับอนุญาต',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'ไม่มีทรัพยากรที่ใช้ได้',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'ห้ามใช้',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'ไม่สามารถใช้เมทธอด HTTP สำหรับทรัพยากรนี้ โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'ไม่สามารถใช้เมทธอดนี้',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'ดำเนินการตามคำขอไม่สำเร็จ หรือพารามิเตอร์ขาดหายไปหรือไม่ถูกต้อง โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'ข้อผิดพลาด: ',
    'LBL_PORTAL_MIN_MODULES' => 'คุณต้องมีการเปิดใช้งานโมดูลเคส บัก หรือฐานความรู้เป็นอย่างต่ำเพื่อที่จะใช้แอปพลิเคชันนี้',
    'LBL_PORTAL_ERROR' => 'ข้อผิดพลาด',
    'LBL_PORTAL_ROUTE_ERROR' => 'มีปัญหาในการโหลดโมดูล โปรดลองอีกครั้งในภายหลังหรือติดต่อฝ่ายสนับสนุน',
    'LBL_PORTAL_OFFLINE' => 'ขออภัย แอปพลิเคชันไม่สามารถใช้ได้ในขณะนี้ โปรดติดต่อผู้ดูแลระบบของไซต์',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'เปลี่ยนรหัสผ่าน',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'ชื่อผู้ใช้นี้มีอยู่ในระบบแล้ว กรุณาส่งคำร้องการลืมรหัสผ่านหรือเลือกชื่อผู้ใช้ใหม่',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'อีเมลที่ให้มาไม่ถูกต้อง',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'รหัสผ่านไม่ตรงกัน',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'คอนโซลบริการ',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'ภาพรวม',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'เรียกคืนแดชบอร์ดเริ่มต้น',
    'LBL_UNTITLED' => 'ไม่ระบุชื่อ',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'ต่ออายุคอนโซล',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'ภาพรวม',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'ระยะ/สถานะ',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'ชื่อ/ชื่อบัญชี',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'แดชบอร์ดช่องทางการตลาดแบบบูรณาการ',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'ลูกค้า',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} เมื่อ {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'เบราว์เซอร์ของคุณไม่รองรับการใช้งาน SugarLive โปรดใช้ Google Chrome หรือ Mozilla Firefox',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'ระบบได้สร้าง <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> ขึ้นมาซึ่งมีรายละเอียดการสนทนาของคุณ',
    'LBL_OMNICHANNEL_SUBJECT' => 'หัวเรื่อง',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'คำอธิบาย',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'ข้อความแบบสรุปย่อ',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'การโทรแบบสรุปย่อ',
    'LBL_OMNICHANNEL_LINK_TO' => 'เชื่อมโยง {{fromModule}} ไปยัง {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'ลิงก์ไปยัง {{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'เชื่อมโยงแล้ว',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'เบราว์เซอร์ของคุณไม่รองรับการใช้งานการสนทนา โปรดใช้ Google Chrome หรือ Mozilla Firefox',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณเพื่อขอความช่วยเหลือ',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'เลย์เอาต์กำหนดค่า',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'โปรดทำการกำหนดค่า SugarLive ให้แล้วเสร็จก่อนที่จะทำการโทรออก',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'โปรดทำการกำหนดค่าเลย์เอาต์ SugarLive ให้แล้วเสร็จก่อนเปิด SugarLive',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'ตั้งให้ตัวคุณ "ออฟไลน์" ใน SugarLive ก่อนกำหนดค่าเลย์เอาต์ SugarLive',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'มุมมองกระทัดรัด',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'มุมมองแบบเต็ม',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'แดชบอร์ด BDR',
    'LBL_SALES_MANAGER_CONSOLE' => 'แดชบอร์ดผู้จัดการฝ่ายขาย',
    'LBL_SALES_REP_CONSOLE' => 'แดชบอร์ดตัวแทนฝ่ายขาย',
    'LBL_MARKETING_CONSOLE' => 'แดชบอร์ดการตลาด',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'แดชบอร์ดความสําเร็จของลูกค้า',
    'LBL_EXECUTIVE_CONSOLE' => 'แดชบอร์ดผู้บริหาร',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'กู้คืนแท็บให้เป็นค่าเริ่มต้น',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'แผนกำหนดค่าแบบสรุป',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'โปรไฟล์ผู้ใช้',
    'LBL_WIZ_COMPLETE_TITLE' => 'ติดตั้งเสร็จสมบูรณ์',
    'LBL_SETUP_COMPLETE_INFO' => 'เริ่มใช้ Sugar!',
    'LBL_SETUP_USER_INFO' => 'ตั้งค่าข้อมูลผู้ใช้ของคุณ',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'ใช้การตั้งค่าโลแคลของระบบ',
    'LBL_SETUP_USER_LOCALE_INFO' => 'ตั้งค่าเขตเวลา วันที่ และรูปแบบชื่อ',
    'LBL_WIZ_START_SUGAR' => 'เริ่มต้น Sugar',
    'LBL_WIZ_FIRST_NAME' => 'ชื่อ',
    'LBL_WIZ_LAST_NAME' => 'นามสกุล',
    'LBL_WIZ_EMAIL' => 'อีเมล',
    'LBL_WIZ_TIMEZONE' => 'เขตเวลา',
    'LBL_WIZ_TIMEFORMAT' => 'รูปแบบเวลา',
    'LBL_WIZ_DATE_FORMAT' => 'รูปแบบวันที่',
    'LBL_WIZ_NAME_FORMAT' => 'รูปแบบชื่อ',
    'LBL_SETUP_PROGRESS' => 'ความคืบหน้าของการตั้งค่า',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'การฝึกอบรมของ Sugar',
    'LBL_WIZ_DOCUMENTATION' => 'เอกสารประกอบ',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'ฐานความรู้',
    'LBL_WIZ_FORUMS' => 'ฟอรัม',
    'TPL_TIMEZONE_DIFFERENT' => 'เขตเวลาของเบราว์เซอร์ไม่ตรงกับเขตเวลาที่บันทึกไว้ {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'ปรับเขตเวลาของคุณ',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'การตั้งค่าโลแคล',
    'LBL_WIZ_EMAIL_SETTINGS' => 'การตั้งค่าอีเมล',
    'LBL_WIZ_IMPORT_DATA' => 'นำเข้าข้อมูล',
    'LBL_WIZ_CREATE_USERS' => 'สร้างผู้ใช้',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'การตั้งค่าระบบ',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Studio',

    'LBL_CSP_ERROR_MESSAGE' => 'ค่าที่คุณกรอกเป็นรูปแบบที่ไม่ได้รับการรับรอง หรือไม่เป็นที่ยอมรับ โปรดดูรายการค่าและรูปแบบที่ยอมรับได้ที่ <a href="{{linkToDocumentation}}" target="_blank">ระบบ</a> เอกสารประกอบ.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'เนื้อหานี้ยังไม่ได้รับการอนุมัติ โปรดอัปเดต <a href="{{linkToDocumentation}}" target="_blank">การตั้งค่านโยบายเพื่อความปลอดภัยของเนื้อหา</a>ในระบบคุณ',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'เนื้อหานี้ยังไม่ได้รับอนุมัติ โปรดขอให้ผู้ดูแลระบบทำการอัปเดต <a href="{{linkToDocumentation}}" target="_blank">การตั้งค่านโยบายเพื่อความปลอดภัยของเนื้อหา</a>ในระบบคุณ เมื่อการตั้งค่าได้รับการอัปเดตแล้ว คุณจะต้องรีเฟรชเบราว์เซอร์เพื่อให้การเปลี่ยนแปลงมีผลใช้งาน',

    // For password related labels
    'LBL_PASSWORD' => 'รหัสผ่าน',
    'LBL_CHANGE_YOUR_PASSWORD' => 'เปลี่ยนรหัสผ่านของคุณ',
    'LBL_PASSWORD_REQUIREMENTS' => 'ข้อกำหนดของรหัสผ่าน',
    'LBL_CURRENT_PASSWORD' => 'รหัสผ่านปัจจุบัน',
    'LBL_NEW_PASSWORD1' => 'รหัสผ่านใหม่',
    'LBL_NEW_PASSWORD2' => 'ยืนยันรหัสผ่าน',
    'LBL_PASSWORD_CHANGED' => 'คุณได้เปลี่ยนรหัสผ่านเรียบร้อยแล้ว',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'โปรดป้อนรหัสผ่านของคุณเพื่อยืนยัน',
    'ERR_ENTER_NEW_PASSWORD' => 'โปรดป้อนรหัสผ่านใหม่ของคุณ',
    'ERR_ENTER_OLD_PASSWORD' => 'โปรดป้อนรหัสผ่านปัจจุบันของคุณ',
    'ERR_REENTER_PASSWORDS' => 'รหัสผ่านไม่ตรงกัน',
    'ERR_PASSWORD_MISMATCH' => 'รหัสผ่านที่ป้อนไม่ตรงกับที่อยู่ในระบบ',
    'LBL_CANNOT_SEND_PASSWORD' => 'ไม่สามารถส่งรหัสผ่าน',
    'LBL_REQUEST_PASSWORD' => 'ขอรับรหัสผ่าน',
    'LBL_RESET_PASSWORD' => 'รีเซ็ตรหัสผ่าน',
    'LBL_RESET_PASSWORD_MESSAGE' => 'ใส่ชื่อผู้ใช้และเราจะส่งลิงก์ไปให้คุณรีเซ็ตรหัสผ่าน',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'กรุณาตรวจดูอีเมลของคุณ <br><br> เราได้ส่งคำแนะนำในการเปลี่ยนรหัสผ่านไปยังที่อยู่อีเมล
        ที่เรามีในไฟล์',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'ข้อผิดพลาด: มีปัญหาในการอัปเดตรหัสผ่านสำหรับผู้ใช้นี้',
    'LBL_INCORRECT_PASSWORD' => 'ข้อผิดพลาด: รหัสผ่านไม่ถูกต้อง',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'รหัสผ่านที่คุณป้อนไม่ตรงตามข้อกำหนดการใช้รหัสผ่าน โปรดลองอีกครั้ง',
    'LBL_PASSWORD_MIN_LENGTH' => 'ความยาวน้อยสุดคือ {0}',
    'LBL_PASSWORD_MAX_LENGTH' => 'ความยาวมากสุดคือ {0}',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'ต้องมีตัวอักษรพิมพ์ใหญ่หนึ่งตัว (A-Z)',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'ต้องมีตัวอักษรพิมพ์เล็กหนึ่งตัว (a-z)',
    'LBL_PASSWORD_ONE_NUMBER' => 'ต้องมีตัวเลขหนึ่งตัว (0-9)',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'ต้องมีอักขระพิเศษหนึ่งตัว (~!@#$%^&*()_+-={}|)',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'รหัสผ่านจะต้องไม่ตรงกับรูปแบบเอ็กซ์เพรสชันทั่วไป: {0}',

    'LBL_PREFERRED_LANGUAGE' => 'ภาษาที่ต้องการ:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'ไม่สามารถส่งอีเมลรีเซ็ตรหัสผ่านได้',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'เลือกรายงาน',
    'LBL_REPORT_AUTO_REFRESH' => 'รีเฟรชอัตโนมัติ',
    'LBL_REPORT_EDIT' => 'แก้ไขรายงานที่เลือก',
    'LBL_REFRESH_LIST_AND_CHART' => 'รีเฟรชรายการและชาร์ต',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'ไม่มีแผนภูมิที่พร้อมใช้งาน',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'รายงานนี้ไม่มีตัวกรองใด ๆ',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'คุณได้ซ่อนตัวกรองขณะรันไทม์เท่านั้น ดูตัวกรองขั้นสูง',
    'LBL_RUNTIME_FILTERS' => 'ตัวกรองแบบรันไทม์',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'วันที่ไม่ตรงกับรูปแบบวันที่ที่ต้องการ: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'ส่วนข้อมูลนี้ไม่มีตัวกรองแบบรันไทม์',
    'LBL_DASHBOARD_FILTER_GROUP' => 'ตัวกรองใหม่',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'คุณต้องเลือกอย่างน้อยหนึ่งค่า',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'รีเซ็ตไปยังตัวกรองค่าเริ่มต้น',
    'LBL_COPY_FILTER_SUMMARY' => 'คัดลอกตัวกรองฉบับย่อ',
    'LBL_APPLY_FILTERS' => 'ใช้',
    'LBL_REPORTS_FILTERS' => 'ตัวกรอง',
    'LBL_RUNTIME_FILTERS_INVALID' => 'ไม่สามารถใช้ตัวกรองขณะรันไทม์เพราะค่าไม่ถูกต้อง',
    'LBL_RUNTIME_FILTERS_COPIED' => 'ได้คัดลอกตัวกรองฉบับย่อเอาไว้ในคลิปบอร์ดของคุณแล้ว',
    'LBL_ADVANCED_FILTERS' => 'ตัวกรองขั้นสูง',
    'LBL_ADVANCED_OR_DESC' => 'รวมเข้าเมื่อตรงตามเงื่อนไขใด ๆ ก็ตาม',
    'LBL_ADVANCED_AND_DESC' => 'รวมเข้าเมื่อตรงตามเงื่อนไขทั้งหมด',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'นี่คือแบบตัวกรองเดิม',
    'LBL_AND_UPPERCASE' => 'และ',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'คุณสมบัตินี้ไม่พร้อมใช้งานในโหมดดูตัวอย่าง',
    'LBL_REPORT_DEFAULT_NAME' => 'รายงานไม่มีชื่อ',
    'LBL_REPORT_QUERY' => 'การสืบค้น',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'เกี่ยวข้องกับระเบียนปัจจุบัน',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'ฟิลด์ที่เชื่อมโยง',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'ฟิลด์ที่เชื่อมโยงไม่สามารถเว้นว่างได้',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'ไม่ได้เลือกรายงานใด',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'แผนภูมิเส้นใช้ไม่ได้กับรายงานนี้',
    'LBL_REPORT_DASHLET' => 'ส่วนข้อมูลรายงาน',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'ตารางข้อมูล',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'ตัวกรองแบบรันไทม์',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'ตัวอย่างตารางข้อมูล',
    'LBL_REPORTS_DASHLET_CHART' => 'แผนภูมิ',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'ตัวอย่างแผนภูมิ',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'ตัวอย่างตัวกรอง',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'รายงานที่เลือกไม่รองรับแผนภูมิ',
    'LBL_REPORTS_DASHLET_LABELS' => 'ป้ายกำกับ',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'แสดงจำนวนระเบียนทั้งหมด',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'ลำดับการเรียง',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'มุมมองที่เลือกของค่าเริ่มต้น',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'เรียงตามแผนภูมิหลัก',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'เรียงตามแผนภูมิรอง',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'ไม่มี {{module}} ที่เชื่อมต่อกับรายงานที่เลือก',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'ไม่สามารถใช้ได้กับประเภทรายงานนี้',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'คุณสมบัตินี้ใช้ได้กับแท็บแผนภูมิเท่านั้น',
    'LBL_REPORTS_CHART_TYPE' => 'ประเภทแผนภูมิ',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'ตำแหน่งค่าของแผนภูมิแท่ง',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'แสดงผลรวม',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'แสดงคำอธิบาย',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'แสดงป้ายกำกับแกน x',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'แสดงป้ายกำกับแกน x',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'จำกัดแถวที่แสดง',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'คุณไม่มีสิทธิ์ใช้งานตัวกรองแบบรันไทม์นี้',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'ไม่ทราบ',
    'ERR_HTTP_DEFAULT_TITLE' => 'เกิดข้อผิดพลาดที่ไม่ทราบสาเหตุ',
    'ERR_HTTP_DEFAULT_TEXT' => 'เกิดข้อผิดพลาดที่ไม่ทราบสาเหตุ',
    'ERR_HTTP_DEFAULT_ACTION' => 'กลับไปที่เพจก่อนหน้า',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'ข้อผิดพลาด: คำขอไม่ถูกต้อง',
    'ERR_HTTP_400_TEXT_LINE1' => 'เบราว์เซอร์ของคุณส่งคำขอที่เซิร์ฟเวอร์ไม่รองรับ',
    'ERR_HTTP_400_TEXT_LINE2' => 'โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณเพื่อขอรายละเอียดเพิ่มเติม',
    'ERR_HTTP_400_ACTION' => 'กลับไปที่เพจก่อนหน้า',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'ไม่มีข้อมูล',
    'ERR_HTTP_404_TEXT_LINE1' => 'ไม่มีเพจนี้ หรือคุณไม่มีสิทธิ์เข้าถึงเพจนี้',
    'ERR_HTTP_404_TEXT_LINE2' => 'โปรดลองอีกครั้ง ถ้ายังคงมีข้อผิดพลาดนี้อยู่ โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณ',
    'ERR_HTTP_404_ACTION' => 'กลับไปที่เพจก่อนหน้า',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 ข้อผิดพลาดภายในของเซิร์ฟเวอร์',
    'ERR_HTTP_500_TEXT_LINE1' => 'เซิร์ฟเวอร์พบข้อผิดพลาดและไม่สามารถดำเนินการตามคำขอให้สมบูรณ์',
    'ERR_HTTP_500_TEXT_LINE2' => 'โปรดลองอีกครั้ง ถ้ายังคงมีข้อผิดพลาดนี้อยู่ โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณ',
    'ERR_HTTP_500_ACTION' => 'โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 ข้อผิดพลาดภายในของเซิร์ฟเวอร์',
    'ERR_HTTP_502_TEXT_LINE1' => 'เซิร์ฟเวอร์พบข้อผิดพลาดชั่วคราวและไม่สามารถดำเนินการตามคำขอให้สมบูรณ์',
    'ERR_HTTP_502_TEXT_LINE2' => 'โปรดลองอีกครั้ง ถ้ายังคงมีข้อผิดพลาดนี้อยู่ โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณ',
    'ERR_HTTP_502_ACTION' => 'โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 ข้อผิดพลาดภายในของเซิร์ฟเวอร์',
    'ERR_HTTP_503_TEXT_LINE1' => 'เซิร์ฟเวอร์ไม่สามารถดำเนินการตามคำขอของคุณได้',
    'ERR_HTTP_503_TEXT_LINE2' => 'โปรดลองอีกครั้งในภายหลัง ถ้ายังคงมีข้อผิดพลาดนี้อยู่ โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณ',
    'ERR_HTTP_503_ACTION' => 'โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',

    'ERR_RENDER_FAILED_TITLE' => 'การแสดงมุมมองล้มเหลว',
    'ERR_RENDER_FAILED_MSG' => 'ไม่สามารถแสดงผลมุมมอง',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'การแสดงฟิลด์ล้มเหลว',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'ไม่สามารถแสดงผลฟิลด์ {0}',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'ไม่มีสิทธิ์เข้าถึง',
    'ERR_NO_VIEW_ACCESS_REASON' => 'คุณไม่มีสิทธิ์เข้าถึงเพจนี้',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'โปรดติดต่อผู้ดูแลระบบเพื่อขอรับสิทธิ์เข้าถึง',
    'ERR_NO_VIEW_ACCESS_MSG' => 'ติดต่อผู้ดูแลระบบผู้สนับสนุนของคุณเพื่อเข้าถึงมุมมองนี้สำหรับโมดูล {0}',

    'ERR_LAYOUT_RENDER_TITLE' => 'แสดงผลเลย์เอาต์ไม่สำเร็จ',
    'ERR_LAYOUT_RENDER_MSG' => 'ว้า เราไม่สามารถแสดงผลได้เลย โปรดลองอีกครั้งในภายหลังหรือติดต่อฝ่ายสนับสนุน',
    'ERR_INTERNAL_ERR_MSG' => 'ข้อผิดพลาดภายใน',
    'ERR_GENERIC_TITLE' => 'ข้อผิดพลาด',
    'ERR_CONTACT_TECH_SUPPORT' => 'โปรดติดต่อฝ่ายสนับสนุนด้านเทคนิค',

    'LBL_SYNCED_RECURRING_MSG' => 'คุณไม่สามารถแก้ไขระเบียนนี้เนื่องจากมีการซิงค์จากไคลเอนต์ภายนอก',
    'LBL_EXISTING' => 'มีอยู่',
    'LBL_PANEL_DEFAULT' => 'ค่าเริ่มต้น',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'การตอบสนองจากเซิร์ฟเวอร์ไม่ถูกต้อง',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'เกิดข้อผิดพลาดระหว่างการดำเนินการ AssignTo',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'คุณไม่สามารถเข้าถึง "{{name}}" ได้ กรุณาติดต่อผู้ดูแลระบบของคุณ',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'ปี {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} ไตรมาส {0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'การดำเนินการเพิ่มเติม',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'การเตือน',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'ไม่สนใจรายการซ้ำและบันทึก',
    'LBL_RESTORE' => 'รีเซ็ตเป็นค่าดั้งเดิม',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'ข้อมูลบันทึกที่ทำเครื่องหมายไว้เพื่อลบออก',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'ข้อความบันทึกที่แสดงอยู่เกี่ยวข้องกับการร้องขอการคุมครองข้อมูลส่วนบุคคลแก่ '
        . 'ลบข้อมูล',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'ฟีด RSS',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'ไม่พลาดข่าวสารล่าสุดด้วยการเพิ่มฟีด RSS หรือบล็อกภายนอก',
    'LBL_RSS_FEED_URL' => 'URL ของฟีด',
    'LBL_RSS_FEED_AUTHOR' => 'ผู้เขียน:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'จำนวนรายการที่จะแสดง',
    'LBL_ERR_LOADING_RSS_FEED' => 'ไม่สามารถโหลดฟีด RSS',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'รายการของฉัน',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'รายการของทีม',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'อนุญาตให้ผู้ใช้เพิ่มแอป Sugar ลงในแดชบอร์ด',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'ประวัติ',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'ส่วนข้อมูลประวัติจะแสดงการประชุมที่ถูกระงับ การโทรที่ล็อก อีเมลที่ได้รับ และอีเมลที่ส่ง',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'อีเมล',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'อีเมล',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'ประวัติของฉัน',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'ประวัติของทีม',
    'LBL_UNASSIGNED' => 'ไม่ได้ระบุ',
    'LBL_ARCHIVE_EMAIL' => 'เก็บถาวรอีเมล',
    'LBL_EMAIL_ARCHIVED' => 'การเก็บถาวรอีเมลแล้ว',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'สร้างอีเมลที่เก็บถาวร',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'กิจกรรมที่วางแผนไว้',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'ส่วนข้อมูลกิจกรรมที่วางแผนไว้จะแสดงการประชุมและการโทรที่วางกำหนดการไว้',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'วันนี้',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'อนาคต',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'กิจกรรมของฉัน',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'กิจกรรมของทีม',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'ระงับ',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'คุณแน่ใจหรือไม่ว่าต้องการทำเครื่องหมาย {0} เป็นปิด',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'งานที่มีสถานะใช้งาน',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'ส่วนข้อมูลงานที่มีสถานะใช้งานจะแสดงงานที่ครบกำหนดเดี๋ยวนี้ งานที่กำลังจะมาถึง และงานที่ต้องทำ',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'ครบกำหนดเดี๋ยวนี้',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'กำลังจะมาถึง',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'งานที่ต้องทำ',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'เสร็จสมบูรณ์',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'คุณแน่ใจหรือไม่ว่าต้องการปิด {0} โดยกำหนดว่าเสร็จสมบูรณ์',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'งานของฉัน',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'งานของทีม',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'มีอีเมลเพิ่มเติมในระเบียนที่คุณกำลังแก้ไข ขณะนี้ค่านี้เป็นค่าหลักและมีการเติมข้อมูลไว้ด้านล่าง',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'งานที่มีสถานะไม่ใช้งาน',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'ส่วนข้อมูลงานจะแสดงงานที่เลื่อนออกไปและงานที่เสร็จสมบูรณ์',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'เลื่อนออก',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'เสร็จสมบูรณ์',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'แก้ไขล่าสุด {{relativetime}} เมื่อ {{date}} เวลา {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'งานของฉัน',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'งานของทีม',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'เคสที่เปิดดูล่าสุด',

    'LBL_REPORT_DASHLET_TITLE_12' => 'เคสที่เปิดแยกตามผู้ใช้และสถานะ',
    'LBL_REPORT_DASHLET_TITLE_125' => 'เคสใหม่สร้างโดยศูนย์ธุรกิจเรียงตามสัปดาห์',
    'LBL_REPORT_DASHLET_TITLE_126' => 'เคสที่สร้างล่าสุด',
    'LBL_REPORT_DASHLET_TITLE_127' => 'เคสใหม่สร้างโดยลูกค้าเรียงตามสัปดาห์',
    'LBL_REPORT_DASHLET_TITLE_128' => 'เคสที่เปิดโดยลูกค้าตามความสำคัญ',
    'LBL_REPORT_DASHLET_TITLE_129' => 'เคสทั้งหมดที่ได้รับการแก้ไขโดยศูนย์ธุรกิจในเดือนนี้',
    'LBL_REPORT_DASHLET_TITLE_130' => 'เคสทั้งหมดที่ได้รับการแก้ไขโดยตัวแทนในเดือนนี้',
    'LBL_REPORT_DASHLET_TITLE_131' => 'รายการเคสที่ได้รับการแก้ไขเมื่อเร็ว ๆ นี้',
    'LBL_REPORT_DASHLET_TITLE_132' => 'เคสที่ได้รับการแก้ไขของฉันในเดือนนี้เรียงตามสัปดาห์',
    'LBL_REPORT_DASHLET_TITLE_133' => 'เคสที่ครบกำหนดวันนี้และเคสที่เกินกำหนดของฉัน',
    'LBL_REPORT_DASHLET_TITLE_134' => 'เคสทั้งหมดที่ครบกำหนดวันนี้และเคสที่เกินกำหนด',
    'LBL_REPORT_DASHLET_TITLE_135' => 'เคสที่เปิดอยู่ของฉันเรียงตามวันครบกำหนดติดตามผล',
    'LBL_REPORT_DASHLET_TITLE_136' => 'เคสที่เปิดอยู่ทั้งหมดเรียงตามวันครบกำหนดติดตามผล',
    'LBL_REPORT_DASHLET_TITLE_137' => 'เคสที่เปิดอยู่ของฉันเรียงตามสถานะ',
    'LBL_REPORT_DASHLET_TITLE_138' => 'เคสในสัปดาห์ที่แล้วของฉันเรียงตามสถานะ',
    'LBL_REPORT_DASHLET_TITLE_139' => 'สถานะงานที่เปิดไว้ซึ่งมอบหมายโดยฉัน',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP หรือ Old REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'เวิร์กโฟลว์ Sugar',
    'LBL_AUDIT_SUBJECT_USER' => 'ผู้ใช้',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web to Lead',

    //common chart strings
    'LBL_CHART' => 'แผนภูมิ',
    'LBL_CHART_NO_DATA' => 'ไม่มีข้อมูล',
    'LBL_CHART_LEGEND_CLOSE' => 'ซ่อนคำอธิบาย',
    'LBL_CHART_LEGEND_OPEN' => 'แสดงคำอธิบาย',
    'LBL_CHART_CONTROLS_CLOSE' => 'ซ่อนตัวควบคุม',
    'LBL_CHART_CONTROLS_OPEN' => 'แสดงตัวควบคุม',
    'LBL_CHART_UNDEFINED' => 'ไม่ได้กำหนด',
    'LBL_CHART_NO_LABEL' => 'ไม่ได้กำหนด',
    'LBL_CHART_AMOUNT' => 'จำนวน',
    'LBL_CHART_COUNT' => 'นับ',
    'LBL_CHART_PERCENT' => 'ร้อยละ',
    'LBL_CHART_GROUP' => 'กลุ่ม',
    'LBL_CHART_DATE' => 'วันที่',
    'LBL_CHART_KEY' => 'หลัก',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'ประเภทแผนภูมิ',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'แสดงชื่อ',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'แสดงผลรวม',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'แสดงป้ายกำกับแกน x',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'แสดงป้ายกำกับแกน y',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'วิธีแสดงเครื่องหมาย',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'ตัดเครื่องหมาย',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'แสดงเครื่องหมายซ้อนกัน',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'หมุนเครื่องหมาย',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'ตำแหน่งค่าของแผนภูมิแท่ง',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'ตัวเลือกการแสดงแผนภูมิแท่ง',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'เลื่อนได้',
    'LBL_CHART_CONFIG_STACK_DATA' => 'ซ้อนชุดข้อมูล',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'ซ่อนกลุ่มว่างเปล่า',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'ส่งแล้ว',
    'LBL_EMAIL_RECV' => 'ระเบียน',

    //record save
    'LBL_RECORD_SAVED' => 'บันทึกระเบียนแล้ว', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'คุณสร้าง {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a> สำเร็จแล้ว', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'คุณสร้าง {{moduleSingularLower}} สำเร็จแล้ว',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'คุณสร้างระเบียนนี้สำเร็จแล้ว แต่คุณไม่มีสิทธิ์เข้าถึงระเบียนนี้', // use when user has no access to the model
    'LBL_VALIDATING' => 'กำลังตรวจสอบ...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'สำเร็จ:',
    'LBL_ALERT_TITLE_WARNING' => 'คำเตือน:',
    'LBL_ALERT_TITLE_NOTICE' => 'ประกาศ:',
    'LBL_ALERT_TITLE_ERROR' => 'ข้อผิดพลาด:',
    'LBL_ALERT_TITLE_LOADING' => 'กำลังโหลด',
    'LBL_ALERT_NO_ACCESS' => 'คุณไม่สามารถเข้าถึงตัวกรองที่ใช้กับส่วนข้อมูลนี้ได้',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'ทำซ้ำแดชบอร์ดเพื่อกำหนดค่าส่วนข้อมูลนี้ด้วยตัวกรองของคุณเอง',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'เวอร์ชันของเบราว์เซอร์ไม่มีการสนับสนุนแล้ว หรือคุณกำลังใช้เบราว์เซอร์ที่ไม่สนับสนุน',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'แพลตฟอร์มที่สนับสนุน',
    'LBL_ALERT_CONFIRM_DELETE' => 'คุณแน่ใจหรือไม่ว่าต้องการลบรายการนี้',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'คุณแน่ใจหรือไม่ว่าต้องการลบรายการเหล่านี้',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'ระเบียนที่เลือกจะเขียนทับค่าต่อไปนี้: {{values}} ยกเลิกเพื่อเก็บค่าที่มีอยู่แล้ว ยืนยันเพื่อเขียนทับด้วยค่าใหม่',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => '{{moduleSingularLower}} ที่เลือกไว้มีค่าที่เกี่ยวข้อง: {{values}} ยกเลิกเพื่อเก็บค่าที่มีอยู่แล้ว ยืนยันเพื่อเขียนทับด้วยค่าใหม่',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'จาก:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'ถึง:',

    //organization chart
    'LBL_ORG_CHART' => 'แผนผังองค์กร',
    'LBL_ORG_CHART_DESC' => 'แสดงโครงสร้างพนักงานขององค์กร',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'สลับทิศทาง',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'แสดงโหนดทั้งหมด',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'ซูมให้พอดี',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'สรุปเคส',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'แสดงภาพรวมของเคสที่เกี่ยวข้อง',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'สรุป',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'เคสที่ปิดแล้ว',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'เคสที่เปิดอยู่',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'การขาย 10 อันดับแรก',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'แสดงการขายสิบอันดับแรกในแผนภูมิฟอง',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'รายการของฉัน',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "รายการของทีมของฉัน",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'ตัวกรองวันที่เริ่มต้น',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'ชุดข้อมูลเริ่มต้น',

    'LBL_PRODUCT_CATALOG_NAME' => 'แคตตาล็อกผลิตภัณฑ์',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'แคตตาล็อกผลิตภัณฑ์',
    'LBL_PRODUCT_CATALOG_DESC' => 'ดูและเพิ่มรายการจากแคตตาล็อกสินค้าของคุณ',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'ดูและเพิ่มรายการจากแคตตาล็อกสินค้าของคุณ',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} เมื่อ {{date}} เวลา {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'พิมพ์บันทึกหรือลากและวางไฟล์แนบ พิมพ์ @ เพื่อพูดถึงผู้ใช้ พิมพ์ # เพื่ออ้างอิงระเบียน',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'เพิ่มความคิดเห็นของคุณ&hellip; พิมพ์ @ เพื่อพูดถึงผู้ใช้ พิมพ์ # เพื่ออ้างอิงระเบียน',
    'LBL_ACTIVITY_STREAM' => 'สตรีมกิจกรรม',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'ไม่ได้เปิดใช้งานสตรีมกิจกรรม',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'ไม่ได้เปิดใช้งานสตรีมกิจกรรมไว้สำหรับโมดูลนี้',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'โพสต์เพิ่มเติม...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => ' ที่ ',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'สตรีมกิจกรรมของฉัน',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'ดูรายการกิจกรรมที่ดำเนินการกับระเบียน จากนั้นสร้างและโพสต์ความคิดเห็น',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'สตรีมกิจกรรมถูกปิดการใช้งาน',

    'LBL_DATA_VIEW' => 'มุมมองข้อมูล',
    'LBL_COMMENT' => 'ความคิดเห็น',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'เกิดข้อผิดพลาดขณะเชื่อมต่อกับเซิร์ฟเวอร์ โปรดลองอีกครั้ง',
    'ERR_RESOLVE_ERRORS' => 'โปรดแก้ไขข้อผิดพลาดก่อนที่จะดำเนินการต่อ',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'เพื่อให้สามารถอนุมัติได้ จะต้องกรอกข้อมูลลงในช่องว่างทั้งหมดที่จำเป็น อย่างไรก็ตาม คุณยังคงสามารถเลือกที่จะปฏิเสธข้อความบันทึกหรือดำเนินการต่อ',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'ในการที่จะปฏิเสธ/ดำเนินการต่อนั้น จะต้องกรอกข้อมูลลงในทุกช่องที่จำเป็น',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'รีเฟรชรายการ',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'รีเฟรชแผ่นป้าย',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'เพิ่มเติม',
    'LBL_TEXTAREA_LESS' => 'น้อยลง',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => 'ไฟล์แนบ {{module}}',
    'LBL_CREATE_ATTACHMENT' => 'สร้างไฟล์แนบ',
    'LBL_DASHLET_REFRESH' => 'รีเฟรช',
    'LBL_DASHLET_MOVE' => 'ย้าย',
    'LBL_DASHLET_CLOSE' => 'ปิด',

    'LBL_DASHLET_FORECAST_NAME' => 'ในประมาณการ',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'แผนภูมิแท่งของประมาณการ',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'แผนภูมิแท่งของประมาณการ',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'ประมาณการสำหรับ',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'แสดงแผนภูมิแท่งของประมาณการสำหรับงวดเวลาที่ระบุ',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'จัดกลุ่มตาม',
    'LBL_DASHLET_FORECASTS_DATASET' => 'ชุดข้อมูล',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'รายละเอียดประมาณการ',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'แสดงรายละเอียดประมาณการปัจจุบัน',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'ส่วนข้อมูลแผนภูมิของรายงานที่บันทึกไว้',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'แสดงแผนภูมิทั้งหมดจากรายงานที่บันทึกไว้',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'บทความที่เกี่ยวข้องที่เผยแพร่ไว้',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'แสดงรายการของบทความฐานความรู้ที่เกี่ยวข้องและมีการเผยแพร่ไว้',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'สรุปข้อมูลประวัติ',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'ประวัติเพิ่มเติม...',
    'LBL_RELATED_CONTACT' => 'ที่อยู่ติดต่อที่เกี่ยวข้อง',
    'LBL_MODULE_TYPE' => 'ประเภท',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'อีเมลถึง',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'อีเมลจาก',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'ไม่สามารถแสดงตัวอย่างโมดูลระบบเดิม',

    //SFA
    'LBL_BEST' => 'ดีที่สุด',
    'LBL_WORST' => 'แย่ที่สุด',
    'LBL_LIKELY' => 'ความเป็นไปได้',
    'LBL_BEST_FORECAST' => 'คำมั่นสัญญา (ดีที่สุด)',
    'LBL_WORST_FORECAST' => 'คำมั่นสัญญา (แย่ที่สุด)',
    'LBL_LIKELY_FORECAST' => 'คำมั่นสัญญา (ที่เป็นไปได้)',
    'LBL_BEST_ADJUSTED' => 'คำมั่นสัญญาที่แก้ไข (ดีที่สุด)',
    'LBL_WORST_ADJUSTED' => 'คำมั่นสัญญาที่แก้ไข (แย่ที่สุด)',
    'LBL_LIKELY_ADJUSTED' => 'คำมั่นสัญญาที่แก้ไข (ที่เป็นไปได้)',
    'LBL_AMOUNT_USDOLLAR' => 'จำนวนเงินที่แปลง',
    'LBL_OVERDUE' => 'เกินกำหนด',

    'LBL_PASSWORD_REQUEST_SENT' => 'ส่งคำขอของคุณแล้ว',
    'LBL_PASSWORD_REQUEST_ERROR' => 'เกิดปัญหาในการเรียกค่าผสมชื่อผู้ใช้และอีเมลของคุณ',

    'LBL_REMINDER_TITLE' => 'การเตือน',
    'LBL_CLICK_TO_DRILLDOWN' => 'คลิกเพื่อดูรายละเอียด',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'คุณไม่สามารถปิดใช้งานภาษาทั้งหมด',

    'LBL_UPDATE_CALC_FIELDS' => 'คำนวณค่าใหม่',

    //Optimistic Locking
    'LBL_YOU' => 'คุณ',
    'LBL_RESOLVE_CONFLICT' => 'แก้ไขข้อขัดแย้งสำหรับ {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'สำหรับข้อมูลเพิ่มเติม โปรดดูเอกสารประกอบของ {{{more_info_url}}} {{plural_module_name}} {{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'ไม่มีข้อมูล',
    'LBL_NEED_HELP' => 'ต้องการความช่วยเหลือเรื่องใหม่ ๆ หรือไม่',
    'LBL_NEW_CASE' => 'เคสใหม่',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'ส่วนข้อมูลความช่วยเหลือจะให้ข้อมูลที่เจาะจงเกี่ยวกับโมดูลที่คุณกำลังดู พร้อมด้วยลิงก์ไปยังเอกสารประกอบที่ตรงกัน (เช่น เอกสารประกอบของผู้สนใจ) ในคู่มือแอปพลิเคชันเพื่อดูข้อมูลเพิ่มเติม',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'ความช่วยเหลือของมุมมองรายการ',
    'LBL_HELP_RECORDS' => "มุมมองรายการของโมดูลจะแสดงระเบียนทั้งหมดที่เป็นไปตามเกณฑ์การค้นหาปัจจุบันและที่ผู้ใช้มีสิทธิ์เข้าถึง คุณสามารถดูรายละเอียดขั้นพื้นฐานของแต่ละระเบียนภายในคอลัมน์ฟิลด์ของมุมมองรายการ หรือคลิกชื่อระเบียนเพื่อเปิดมุมมองระเบียน",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'ความช่วยเหลือของมุมมองรายการ',
    'LBL_HELP_RECORD' => 'มุมมองระเบียนนี้จะให้ข้อมูลโดยละเอียดเกี่ยวกับแต่ละระเบียน ตลอดจนรายละเอียดของระเบียนที่เชื่อมโยงกัน

- แก้ไขฟิลด์ของระเบียนนี้โดยคลิกที่ฟิลด์แต่ละฟิลด์ หรือคลิกปุ่มแก้ไข
- ดูหรือแก้ไขลิงก์ไปยังระเบียนอื่นในแผงข้อมูลย่อย โดยสลับแผงข้อมูลด้านซ้ายล่างเป็น "มุมมองข้อมูล"
- โต้ตอบกับความคิดเห็นของผู้ใช้และดูประวัติการแก้ไขระเบียนโดยสลับแผงข้อมูลด้านซ้ายล่างเป็น "สตรีมกิจกรรม"
- ติดตามหรือเพิ่มระเบียนเป็นรายการโปรดโดยใช้ไอคอนทางขวาของชื่อระเบียน
- การดำเนินการอื่นๆ สามารถใช้ได้จากเมนูการดำเนินการแบบดรอปดาวน์ทางขวาของปุ่มแก้ไข',

    // create view
    'LBL_HELP_CREATE_TITLE' => 'การสร้าง {{module_name}}',
    'LBL_HELP_CREATE' => 'ในการสร้าง {{plural_module_name}}:
1. ระบุค่าสำหรับฟิลด์ตามต้องการ
 * ต้องกรอกข้อมูลในฟิลด์ที่มีเครื่องหมาย "จำเป็น" ก่อนที่จะบันทึก
 * คลิก "แสดงเพิ่มเติม" เพื่อแสดงฟิลด์อื่นๆ ถ้าจำเป็น
2. คลิก "บันทึก" เพื่อสิ้นสุดการแก้ไขระเบียนใหม่ และกลับไปที่มุมมองรายการ {{plural_module_name}}',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'ตรวจพบรายการที่อาจซ้ำซ้อนกัน',
    'LBL_HELP_DUPLICATE' => 'Sugar ตรวจพบว่าระเบียนที่คุณพยายามสร้างนั้นอาจมีอยู่แล้ว

ในการแก้ไขระเบียนที่มีอยู่แทนที่จะสร้างใหม่ ให้คลิก "เลือกและแก้ไข" ทางขวาของระเบียนที่ต้องการ ฟิลด์ว่างเปล่าทั้งหมดในระเบียนที่มีอยู่จะมีการเติมข้อมูลด้วยค่าที่คุณเพิ่งป้อน คลิก "บันทึก" เพื่อบันทึกการแก้ไขในระเบียนที่มีอยู่ดังกล่าว

แต่ถ้าคุณต้องการใช้ค่าที่เพิ่งป้อน แทนที่จะใช้ค่าในระเบียนที่มีอยู่ ให้คลิก "รีเซ็ตเป็นค่าดั้งเดิม" ค่าที่คุณป้อนไว้จะถูกนำมาใช้กับระเบียนที่มีอยู่ และขณะนี้คุณสามารถแก้ไขเพิ่มเติมและคลิก "บันทึก" เพื่อสิ้นสุดการแก้ไขระเบียนที่มีอยู่

ในการสร้างระเบียนใหม่โดยใช้ค่าที่คุณป้อนไว้ ให้คลิก "ไม่สนใจรายการซ้ำและบันทึก" ที่ด้านขวาบนของหน้าจอ',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'ไม่มีการตั้งค่าเซิร์ฟเวอร์ SMTP',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'ในการส่งการแจ้งเตือนการมอบหมายระเบียน จะต้องกำหนดค่าเซิร์ฟเวอร์ SMTP ไว้ใน {{emailSettingsUrl}}',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'การตั้งค่าอีเมล',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'รายงานคลังสินค้าใหม่พร้อมใช้งาน',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'รายงานคลังสินค้าใหม่พร้อมใช้งานใน ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'โมดูลรายงาน',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'รายงานเหล่านี้ได้รับการติดป้ายเป็น "รายงานคลังสินค้า" และสามารถกรองข้อมูลได้ รายงานต่าง ๆ จะได้รับการติดป้ายเป็น "การขายและการตลาด" "ลูกค้าสัมพันธ์" "ความเป็นส่วนตัวของข้อมูล" หรือ "การบริหาร" ทั้งนี้จัดเรียงตามเนื้อหารายงาน สำหรับข้อมูลเพิ่มเติม ให้ไปที่ ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'เอกสารประกอบ',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM ช่วยให้ผู้ใช้ที่มีความชำนาญสามารถดำเนินการบางอย่างโดยใช้แป้นพิมพ์ลัดเพื่อเพิ่มประสิทธิภาพในการทำงาน ตารางทางขวาอธิบายทางลัดที่ใช้ได้ พร้อมกับปุ่มกดและการดำเนินการของปุ่มนั้นๆ',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>ปุ่มที่สนับสนุน</h1><ul><li>อักขระตัวเลขและตัวอักษรทั้งหมดและสัญลักษณ์</li><li>shift, ctrl, alt, command, mod (ctrl ใน Windows/Linux และ command ใน Mac)</li><li>enter, esc, เว้นวรรค, แท็บ, pageup, pagedown, end, home, ins, del, backspace</li></ul><h1>คุณลักษณะที่สนับสนุน</h1><ul><li>ปุ่มผสม: ctrl+m</li><li>หลายปุ่ม: m,ctrl+m</li><li>ลำดับของปุ่ม: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'ทางลัดสำหรับทั้งระบบ',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'ทางลัดตามบริบท',
    'LBL_SHORTCUT_KEY_KEY' => 'คีย์',
    'LBL_SHORTCUT_FUNCTION' => 'ฟังก์ชัน',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Configure Contextual Shortcuts',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'ไม่มีทางลัดตามบริบทที่จะกำหนดค่า',
    'LBL_SHORTCUT_HELP' => 'แสดงเพจวิธีใช้ทางลัด',
    'LBL_SHORTCUT_QUICK_CREATE' => 'สลับเมนูสร้างอย่างรวดเร็ว',
    'LBL_SHORTCUT_SEARCH' => 'โฟกัสที่ฟิลด์ค้นหาทั้งระบบ',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'สลับแถบด้านข้าง',
    'LBL_SHORTCUT_CREATE_RECORD' => 'สร้างระเบียนใหม่',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'เลือกระเบียนถัดไปในรายการ',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'เลือกระเบียนก่อนหน้าในรายการ',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'เลื่อนรายการไปทางซ้าย',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'เลื่อนรายการไปทางขวา',
    'LBL_SHORTCUT_OPEN' => 'เปิดระเบียนที่เลือกไว้ในรายการ',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'แก้ไขระเบียนที่เลือกไว้ในรายการ',
    'LBL_SHORTCUT_RECORD_DELETE' => 'ลบระเบียน',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Exit out of list inline edit mode without saving',
    'LBL_SHORTCUT_RECORD_SAVE' => 'บันทึกระเบียน',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'ล้างการแก้ไขทั้งหมดในระเบียน',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'ทำเครื่องหมายระเบียนเป็นรายการโปรด',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'ติดตามระเบียน',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'แสดงตัวอย่างระเบียน',
    'LBL_SHORTCUT_MARK_SELECTED' => 'ทำเครื่องหมายระเบียนว่าเลือกไว้',
    'LBL_SHORTCUT_SELECT_ALL' => 'เลือกทั้งหมด',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'เปิดเมนูดรอปดาวน์สำหรับการดำเนินการเป็นกลุ่ม',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'โฟกัสที่ฟิลด์ตัวกรองรายการ',
    'LBL_SHORTCUT_FILTER_CREATE' => 'สร้างตัวกรองรายการใหม่',
    'LBL_SHORTCUT_FILTER_EDIT' => 'แก้ไขตัวกรองรายการปัจจุบัน',
    'LBL_SHORTCUT_FILTER_SHOW' => 'เปิดเมนูตัวกรองรายการ',
    'LBL_SHORTCUT_RECORD_EDIT' => 'แก้ไขระเบียน',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'เปิดระเบียนก่อนหน้า',
    'LBL_SHORTCUT_RECORD_NEXT' => 'เปิดระเบียนถัดไป',
    'LBL_SHORTCUT_COPY_RECORD' => 'คัดลอกระเบียนก่อนหน้า',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'เปิดเมนูดรอปดาวน์สำหรับการดำเนินการหลัก',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'ปิดลิ้นชัก',
    'LBL_SHORTCUT_FILTER_ADD' => 'เพิ่มเกณฑ์ในการกรอง',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'นำเกณฑ์สุดท้ายออกจากตัวกรอง',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'ปิดตัวกรอง',
    'LBL_SHORTCUT_FILTER_SAVE' => 'บันทึกตัวกรอง',
    'LBL_SHORTCUT_FILTER_DELETE' => 'ลบตัวกรอง',
    'LBL_SHORTCUT_FILTER_RESET' => 'รีเซ็ตตัวกรอง',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'เพิ่มแถว',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'นำแถวออก',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'ปิดการอัปเดตเป็นกลุ่ม',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'อัปเดตระเบียน',
    'LBL_CREATE_CATEGORY' => 'สร้าง <div class="btn-link" data-action="create-new">หมวดหมู่</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'ยืนยัน',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'ยกเลิก',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'เลือกรายการทั้งหมดในฟิลด์แบบเลือกหลายรายการ',
    'LBL_SHORTCUT_SWEETSPOT' => 'สลับแถบจุดที่เหมาะสม',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'ซ่อนแถบจุดที่เหมาะสม',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'บันทึกการกำหนดค่า',
    'LBL_SHORTCUT_RESTORE' => 'เรียกคืนค่าเริ่มต้น',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'เกิดข้อผิดพลาดขณะบันทึกแป้นพิมพ์ลัดที่กำหนดเองบนเซิร์ฟเวอร์ โปรดลองอีกครั้ง',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => 'การตั้งค่า {{module}}',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => 'บันทึกการกำหนดค่า {{module}} แล้ว',
    'LBL_CONFIG_BLOCKED_TITLE' => 'ข้อผิดพลาดของการกำหนดค่า {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} ไม่มีการกำหนดค่าใดๆ',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'ผู้ใช้ไม่มีสิทธิ์เข้าถึง {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'ผู้ใช้ไม่มีสิทธิ์เข้าถึงในการกำหนดค่า {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'การตั้งค่าฐานข้อมูลสำหรับ {{module}} ต้องได้รับการแก้ไข',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'ถึง',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'วันที่เริ่มต้นและสิ้นสุด',

    'LBL_CALENDAR_START_DATE' => 'วันที่เริ่มต้น',
    'LBL_CALENDAR_END_DATE' => 'วันที่สิ้นสุด',
    'LBL_CALENDAR_DURATION' => 'ระยะเวลา',
    'LBL_CALENDAR_RECURRENCE' => 'การเกิดซ้ำ',
    'LBL_CALENDAR_REMINDERS' => 'การเตือน',

    'LBL_CALENDAR_CUSTOM_DATE' => 'วันที่กำหนดเอง',
    'LBL_CALENDAR_REPEAT_TYPE' => 'ประเภทการเกิดซ้ำ',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'ช่วงเวลาการทำซ้ำ',
    'LBL_CALENDAR_REPEAT_DOW' => 'วันของสัปดาห์ที่เกิดซ้ำ',
    'LBL_CALENDAR_REPEAT_ON' => 'รายงานเมื่อ',
    'LBL_CALENDAR_REPEAT' => 'ซ้ำ',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'ซ้ำจนถึง',
    'LBL_CALENDAR_REPEAT_COUNT' => 'การเกิดซ้ำ',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'ตัวเลือกการเกิดซ้ำ',
    'LBL_CALENDAR_REPEAT_DAYS' => 'วันที่ของเดือน',
    'LBL_CALENDAR_REPEAT_MONTH' => 'เดือน',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'ลำดับการเกิดซ้ำ',
    'LBL_CALENDAR_REPEAT_UNIT' => 'หน่วยการเกิดซ้ำ',
    'TPL_REPEAT_INTERVAL' => 'ทุก {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'ชุดนี้ใช้ตัวเลือก "เปิดซ้ำ" ที่ไม่พร้อมใช้งานใน Sugar เนื่องจากชุดดังกล่าวถูกซิงค์มาจากไคลเอ็นต์ปฏิทิน โปรดแก้ไขชุดข้อมูลนี้ในโปรแกรมปฏิทินของคุณหากคุณต้องการทําซ้ําในวันที่ระบุ การแก้ไขชุดนี้ใน Sugar จะตั้งค่า "เปิดซ้ำ" เป็น "ไม่มี"<br><br>คุณต้องการดําเนินการต่อหรือไม่?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'การเปลี่ยนแปลงการเกิดซ้ำจะต้องกระทำโดยใช้ระเบียนแรกในชุด',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'กฎการเกิดซ้ำไม่ทำให้มีการสร้างกิจกรรม',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'ผู้เข้าร่วม',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'ปฏิเสธ',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'ไม่แน่นอน',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'ไม่ตอบ',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'ไม่มีกำหนดการ',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'มุมมองที่ใช้ได้',
    'LBL_CALENDAR_DASHLET_NAME' => 'เครื่องมือกำหนดปฏิทิน',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'มุมมองค่าเริ่มต้น',
    'LBL_CALENDAR_MY_CALENDARS' => 'ปฏิทินของฉัน',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'ผู้ใช้และปฏิทินทีม',
    'LBL_CALENDAR' => 'ปฏิทิน',

    'LBL_CALENDAR_DAY' => 'วัน',
    'LBL_CALENDAR_WEEK' => 'สัปดาห์',
    'LBL_CALENDAR_MONTH' => 'เดือน',
    'LBL_CALENDAR_YEAR' => 'ปี',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => 'ที่ 2',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => 'ที่ 3',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => 'ที่ 4',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => 'ที่ 5',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => 'ที่หก',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => 'ที่ 7',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => 'ที่ 8',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => 'ที่ 9',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => 'ที่ 10',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => 'ที่ 11',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => 'ที่ 12',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => 'ที่ 13',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => 'ที่ 14',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => 'ที่ 15',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => 'ที่ 16',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => 'ที่ 17',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => 'ที่ 18',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => 'ที่ 19',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => 'ที่ 20',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => 'ที่ 21',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => 'ที่ 22',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => 'ที่ 23',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => 'ที่ 24',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => 'ที่ 25',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => 'ที่ 26',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => 'ที่ 27',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => 'ที่ 28',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => 'ที่ 29',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => 'ที่ 30',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => 'ที่ 31',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => 'ที่ 32',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => 'ที่ 33',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => 'ที่ 34',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => 'ที่ 35',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => 'ที่ 36',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => 'ที่ 37',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => 'ที่ 38',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => 'ที่ 39',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => 'ที่ 40',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => 'ที่ 41',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => 'ที่ 42',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => 'ที่ 43',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => 'ที่ 44',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => 'ที่ 45',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => 'ที่ 46',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => 'ที่ 47',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => 'ที่ 48',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => 'ที่ 49',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => 'ที่ 50',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => 'ที่ 51',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => 'ที่ 52',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => 'ที่ 53',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => 'ที่ 54',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => 'ที่ 55',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => 'ที่ 56',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => 'ที่ 57',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => 'ที่ 58',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => 'ที่ 59',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => 'ที่ 60',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => 'ที่ 61',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => 'ที่ 62',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => 'ที่ 63',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => 'ที่ 64',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => 'ที่ 65',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => 'ที่ 66',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => 'ที่ 67',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => 'ที่ 68',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => 'ที่ 69',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => 'ที่ 70',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => 'ที่ 71',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => 'ที่ 72',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => 'ที่ 73',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => 'ที่ 74',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => 'ที่ 75',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => 'ที่ 76',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => 'ที่ 77',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => 'ที่ 78',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => 'ที่ 79',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => 'ที่ 80',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => 'ที่ 81',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => 'ที่ 82',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => 'ที่ 83',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => 'ที่ 84',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => 'ที่ 85',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => 'ที่ 86',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => 'ที่ 87',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => 'ที่ 88',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => 'ที่ 89',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => 'ที่ 90',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => 'ที่ 91',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => 'ที่ 92',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => 'ที่ 93',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => 'ที่ 94',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => 'ที่ 95',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => 'ที่ 96',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => 'ที่ 97',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => 'ที่ 98',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => 'ที่ 99',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'เกิดข้อผิดพลาดขณะเรียกกำหนดการ',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'บันทึกและส่งคำเชิญ',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'สถานะยอมรับ',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'กระบวนการ',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'แผงควบคุมย่อยกระบวนการจะแสดงเทมเพลทที่สามารถใช้ได้ภายใน SugarBPM',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'การกำหนดกระบวนการ',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'แผงควบคุมคำนิยามกระบวนการจะแสดงเทมเพลทที่สามารถใช้ได้ภายใน SugarBPM',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'สร้างการกำหนดกระบวนการ',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'นำเข้าการกำหนดกระบวนการ',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'กฎทางธุรกิจของกระบวนการ',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'แผงควบคุมย่อยกฎธุรกิจกระบวนการจะแสดงเทมเพลทที่สามารถใช้ได้ภายใน SugarBPM',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'สร้างกฎทางธุรกิจของกระบวนการ',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'นำเข้ากฎทางธุรกิจของกระบวนการ',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'เทมเพลทอีเมลของกระบวนการ',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'แผงควบคุมย่อยเทมเพลทอีเมล์กระบวนการจะแสดงเทมเพลทที่สามารถใช้ได้ภายใน SugarBPM',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'สร้างเทมเพลทอีเมลของกระบวนการ',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'นำเข้าเทมเพลทอีเมลของกระบวนการ',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'เมื่อพัฒนากระบวนการ/กฎทางธุรกิจ/เทมเพลทอีเมลในอินสแตนซ์อื่นของ Sugar เราขอแนะนำให้อินสแตนซ์นั้นเป็นโคลนที่เหมือนกันทั้งหมดของระบบที่ใช้งานจริง กระบวนการ/กฎทางธุรกิจ/เทมเพลทอีเมลที่สร้างในอินสแตนซ์อิสระของ Sugar อาจไม่ทำงานตามที่คาดหมายหลังจากนำเข้าเสร็จแล้ว กระบวนการ/กฎทางธุรกิจ/เทมเพลทอีเมลอาจอ้างอิงการเปลี่ยนแปลงที่เจาะจงในระดับ Studio หรือระดับแอปพลิเคชัน รวมถึง แต่ไม่จำกัดเพียงชื่อฟิลด์ที่กำหนดเอง ค่าดรอปดาวน์ ID ฐานข้อมูล เป็นต้น ถ้าค่าเหล่านี้ไม่ตรงกันทั้งหมดจากอินสแตนซ์ที่ใช้สร้างกระบวนการ/กฎทางธุรกิจ/เทมเพลทอีเมล คุณอาจต้องสร้างกระบวนการ/กฎทางธุรกิจ/เทมเพลทอีเมลด้วยตนเองในอินสแตนซ์เป้าหมาย',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'คุณยังต้องการดำเนินการนำเข้าต่อหรือไม่',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'คุณยังต้องการดำเนินการส่งออกต่อหรือไม่',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'ฟิลด์ดรอปดาวน์ต่อไปนี้ประกอบด้วยตัวเลือกที่ไม่ถูกต้อง',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'กิจกรรมที่รอดำเนินการแยกตามกระบวนการ',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'กิจกรรมที่รอดำเนินการ',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'กิจกรรมที่รอดำเนินการแยกตามกระบวนการ',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'กระบวนการทั้งหมด',
    'LBL_RECORD_DASHBOARD' => 'แดชบอร์ดระเบียน',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'ข้อมูลสรุปสถานะกระบวนการ',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'คำอธิบายสถานะกระบวนการ',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'อยู่ระหว่างดำเนินการ',
    'LBL_PMSE_COMPLETED_STATUS' => 'เสร็จสมบูรณ์',
    'LBL_PMSE_CANCELLED_STATUS' => 'ยกเลิก',
    'LBL_PMSE_TERMINATED_STATUS' => 'ยุติ',
    'LBL_PMSE_ERROR_STATUS' => 'ข้อผิดพลาด',
    'LBL_PMSE_SETTINGS' => 'การตั้งค่า SugarBPM',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการปิดใช้งานระเบียนนี้',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการเปิดใช้งานระเบียนนี้',
    'LBL_PRO_DELETE_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการลบระเบียนนี้',

    'LBL_PRO_ENABLE' => 'กำลังอัปเดต',
    'LBL_PRO_DISABLE' => 'กำลังอัปเดต',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'การกำหนดกระบวนการนี้ไม่สามารถลบได้ เนื่องจากมีกระบวนการที่รอดำเนินการทำงานอยู่',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} มีส่วนร่วมในกระบวนการ และอาจมีฟิลด์ที่ล็อคอยู่ ในการแก้ไขระเบียน ให้คลิกที่นี่ {{link}}',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'ฟิลด์นี้ถูกล็อคเนื่องจากเกี่ยวข้องกับกระบวนการที่ทำงานอยู่',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'ระเบียนนี้มีส่วนร่วมในกระบวนการและอาจมีฟิลด์ที่ล็อคอยู่',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'ศูนย์บริการธุรกิจ',
    'LBL_BUSINESS_CENTER_ID' => 'ID ศูนย์บริการธุรกิจ',
    'LBL_BUSINESS_CENTER_NAME' => 'ชื่อศูนย์บริการธุรกิจ',

    'LBL_PLIS_ACTIVITIES' => 'กิจกรรมการซื้อสินค้าในไลน์',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(แท็กใหม่)',
    'LBL_TAG_FETCH_ERROR' => 'เกิดข้อผิดพลาดขณะเรียกแท็ก',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'Sugar 7 ต้องใช้ Javascript โปรดเปิดใช้ Javascript ในเบราว์เซอร์ของคุณเพื่อใช้ Sugar 7',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'ไม่สามารถยกเลิกการซีเรียลไลซ์ข้อมูลที่ซีเรียลไลซ์แล้ว',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'ไม่สามารถยกเลิกการซีเรียลไลซ์ข้อมูลที่ซีเรียลไลซ์แล้ว เนื่องจากมีการอ้างอิงออบเจกต์หรือคลาส',

    'LBL_FIELD_TRIMMED' => 'ฟิลด์ถูกตัด เนื่องจากมีอักขระเกินจำนวนสูงสุด',
    'LBL_FIELDSIZE_OVERFLOW' => 'ฟิลด์มีอักขระเกินจำนวนสูงสุด',
    'LBL_TINYMCE_TARGET_SAME' => 'หน้าต่างเดียวกัน',
    'LBL_TINYMCE_TARGET_NEW' => 'หน้าต่างใหม่',

    'LBL_OUTBOUND_EMAILS' => 'การตั้งค่าอีเมล',
    'LBL_OUTBOUND_EMAIL' => 'การตั้งค่าอีเมล',

    'LBL_EMAIL_PARTICIPANTS' => 'ผู้มีส่วนร่วมในอีเมล',
    'LBL_EMAIL_PARTICIPANT' => 'ผู้มีส่วนร่วมในอีเมล',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'การคุ้มครองข้อมูลส่วนบุคคล (Data Privacy)',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'การคุ้มครองข้อมูลส่วนบุคคล (Data Privacy)',
    'LBL_DATAPRIVACY_VIEW_PII' => 'ดูข้อมูลส่วนตัว',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'ทำเครื่องหมายเพื่อลบออก',
    'LBL_DATAPRIVACY_FIELDNAME' => 'ช่องว่าง',
    'LBL_DATAPRIVACY_VALUE' => 'ค่า',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'เปลี่ยนแปลงโดย',
    'LBL_DATAPRIVACY_SOURCE' => 'ที่มา',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'การอัปเดตล่าสุด',
    'LBL_DATAPRIVACY_PII' => 'ข้อมูลส่วนตัว',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'ทำเครื่องหมายเพื่อลบออก',
    'TPL_DATAPRIVACY_PII_TITLE' => 'ข้อมูลส่วนตัวสำหรับ {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'เปลี่ยนเวลา',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'ข้อความ',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'คัดลอกไปยังคลิปบอร์ดของคุณ!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'ไม่สามารถคัดลอกไปยังคลิปบอร์ดได้',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'คัดลอกลิงก์ยืนยัน',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'ไทม์ไลน์',
    'LBL_NO_ACTIVITY' => 'ไม่มีกิจกรรม',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} ไทม์ไลน์',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'เพิ่มเติม',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'น้อยลง',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'ไทม์ไลน์จะแสดงระเบียนที่เกี่ยวข้องกับระเบียนปัจจุบันและเลือกการอัปเดตฟิลด์เมื่อเวลาผ่านไป',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'แสดงเพิ่มเติม...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'แสดงน้อยลง...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'ไม่มีข้อมูล',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'โมดูลไม่มีใบอนุญาต',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'การเป็นสมาชิกที่เปิดใช้งาน',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'สามารถเพิ่มส่วนข้อมูลสำหรับโมดูลต่าง ๆ ที่เชื่อมกับบัญชีเดียวเท่านั้น โปรดศึกษาเอกสาร <a href={{linkToDocumentation}}> การเป็นสมาชิกที่เปิดใช้งานส่วนข้อมูล</a>เพื่อรับข้อมูลเพิ่มเติม',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'แสดงการซื้อที่เป็นของบัญชีที่เชื่อมกันนี้:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'การเป็นสมาชิกที่เปิดใช้งานสำหรับบัญชีเฉพาะเจาะจง',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', ปริมาณ {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'รวม:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'ไม่มีการเป็นสมาชิกที่เปิดใช้งาน',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'ส่วนข้อมูลนี้ต้องใช้ {{module_name}} ในการทำงาน กรุณาแจ้งกับผู้ดูแลระบบเรื่องการเปิดใช้งาน {{module_name}}',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'ประวัติการสั่งซื้อ',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'การสั่งซื้อทั้งหมดของบัญชีเฉพาะเจาะจง',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'สามารถเพิ่มส่วนข้อมูลสำหรับโมดูลต่าง ๆ ที่เชื่อมกับบัญชีเดียวเท่านั้น โปรดศึกษาเอกสาร <a href={{linkToDocumentation}}> ส่วนข้อมูลประวัติการสั่งซื้อ</a>เพื่อรับข้อมูลเพิ่มเติม',
    'LBL_NO_PURCHASE_HISTORY' => 'ไม่มีการสั่งซื้อให้แสดง',
    'LBL_NO_PLIS' => 'ไม่มีสินค้าในไลน์ที่ซื้อมา',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'รวม',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'ปริมาณ',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'ส่วนข้อมูลนี้ต้องใช้ข้อมูลการสั่งซื้อและสินค้าในไลน์ที่สั่งซื้อมาเพื่อให้สามารถทำงานได้ โปรดแจ้งให้ผู้ดูแลระบบของคุณเปิดใช้งานการสั่งซื้อและสินค้าในไลน์ที่สั่งซื้อมา',
    'LBL_SEARCH_PURCHASE_NAME' => 'ค้นหาโดยชื่อการสั่งซื้อ...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'ใช้สตูดิโอเพื่อแก้ไขเลย์เอาต์มุมมองส่วนข้อมูลของระเบียนโดยไปที่ ' .
        'สตูดิโอ > {{module}} > เลย์เอาต์ > ส่วนข้อมูลมุมมองระเบียน <a href={{linkToStudio}}>แก้ไขในสตูดิโอ</a>',
    'LBL_SERVICE_LEVEL' => 'ระดับบริการ',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'เลขที่',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'การติดตามผล',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'ลำดับความสำคัญ/สถานะ',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'หัวข้อ/คำอธิบาย',

//Service Duration
    'LBL_SERVICE_DURATION' => 'ระยะการบริการ',
    'LBL_SERVICE_DURATION_VALUE' => 'ค่าระยะการบริการ',
    'LBL_SERVICE_DURATION_UNIT' => 'หน่วยระยะการบริการ',
    'LBL_LOCK_DURATION' => 'ระยะเวลาการล็อก',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'ไม่สามารถโหลด Amazon Connect CCP ได้ กรุณา' .
        'ตรวจสอบให้แน่ใจว่าคุณกำลังใช้ ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">เบราว์เซอร์ที่รองรับ</a> ' .
        'หากยังคงมีปัญหา กรุณาติดต่อผู้ดูแลระบบ Sugar ของคุณ',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'ผู้ดูแลระบบ Sugar ของคุณยังไม่ได้กำหนดค่าอินสแตนซ์สำหรับ Amazon Connect ของคุณ',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'ไม่สามารถสร้างการเชื่อมต่อกับ Amazon Connect กรุณาติดต่อผู้ดูแลระบบ Sugar ของคุณเพื่อขอรับความช่วยเหลือ',
    'LBL_OMNICHANNEL_UNKNOWN' => 'ไม่รู้จัก',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'ระบบลิ้นชัก',
    'LBL_CLOSE_FOCUS_DRAWER' => 'ระบบลิ้นชักปิด',
    'LBL_EXTERNAL_GUESTS' => 'ผู้เยี่ยมชมภายนอก',
    'LBL_MY_FAVORITE_TASKS' => 'งานโปรดของฉัน',
    'LBL_RECORD' => 'ระเบียน',

    'LBL_MY_TASKS' => 'งานของฉัน',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'หาฟิลด์ไม่พบ: {0} ในโมดูล: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'หาระเบียนที่มี{0}: {1} ในโมดูล: {2} ไม่พบ',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'หาความสัมพันธ์ที่ชื่อ: {0} ไม่พบ',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'มีการกรอกฐานข้อมูลของ id: {0} กับ {1}: {2} ในโมดูล: {3} อยู่แล้ว',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'ลบรายการข้อมูลแบบไม่ลบออกจากฐานข้อมูล (ด้วยธงที่ถูกลบ = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'พบระเบียนฐานข้อมูลหลายระเบียนสำหรับ {0} {1} ในโมดูล {2} ' .
        'กรุณาลบ หรืออัปเดตระเบียนที่ตรงกัน ระเบียนที่ตรงกัน: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'ดำเนินการครั้งถัดไป',
    'LBL_TIME_AWARE_TYPE' => 'ประเภท',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'ป้ายกำกับที่แสดง',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'เปิดมุมมองระเบียน',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'เพิ่ม',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'ไม่มีความช่วยเหลือในส่วนนี้',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'ฟังก์ชัน',
    'LBL_ACTIONBUTTON_FIELDS' => 'ฟิลด์',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'เลือกฟิลด์...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'ทบยอด',
    'LBL_ACTIONBUTTON_RELATED' => 'เกี่ยวข้อง',
    'LBL_ACTIONBUTTON_SAVE' => 'บันทึก',
    'LBL_ACTIONBUTTON_CANCEL' => 'ยกเลิก',
    'LBL_ACTIONBUTTON_R_MODULE' => 'โมดูลที่เกี่ยวข้อง',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'ฟิลด์ที่เกี่ยวข้อง',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'โมดูลทบยอด',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'ฟิลด์ทบยอด',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'ฟังก์ชันทบยอด',
    'LBL_ACTIONBUTTON_MINIMUM' => 'น้อยสุด',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'มากสุด',
    'LBL_ACTIONBUTTON_AVERAGE' => 'เฉลี่ย',
    'LBL_ACTIONBUTTON_SUM' => 'รวม',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'ระบุระเบียน',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'เขียนอีเมล',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'สร้างระเบียน',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'ผสานเอกสาร',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'เปิด Url',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'เรียกใช้รายงาน',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'อัปเดตระเบียน',
    'LBL_ACTIONBUTTON_ACTION' => 'การดำเนินการ',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'ระบุให้กับ',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'อีเมลถึง',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'ใช้ PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'เทมเพลท',
    'LBL_ACTIONBUTTON_MODULE' => 'โมดูล',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'การตั้งค่าหน้าจอแสดงผล',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'ประเภท',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'ดรอปดาวน์',
    'LBL_ACTIONBUTTON_BUTTON' => 'ปุ่ม',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'กลุ่มปุ่ม',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'แสดงป้ายกำกับในระเบียน',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'แสดงที่ส่วนหัว',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'ซ่อนการแก้ไข',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'แสดงบนส่วนหัวแดชบอร์ดโฟกัส',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'แดชบอร์ด',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'ส่วนหัวแดชบอร์ดโฟกัส',
    'LBL_ACTIONBUTTON_SIZE' => 'ขนาด',
    'LBL_ACTIONBUTTON_DEFAULT' => 'ค่าเริ่มต้น',
    'LBL_ACTIONBUTTON_SMALL' => 'เล็ก',
    'LBL_ACTIONBUTTON_LARGE' => 'ใหญ่',
    'LBL_ACTIONBUTTON_CALCULATED' => 'คำนวณ',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'แปลงเป็น PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'ผสานเอกสาร',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'ดูตัวอย่าง',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'คุณสมบัติ',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'ป้ายกำกับ',
    'LBL_ACTIONBUTTON_DESC' => 'ทูลทิป',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'แสดงป้ายกำกับ',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'แสดงไอคอน',
    'LBL_ACTIONBUTTON_SCHEME' => 'โครงสี',
    'LBL_ACTIONBUTTON_ICON' => 'ไอคอน',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'รายการที่อ้างอิง',
    'LBL_ACTIONBUTTON_DESIGN' => 'กำหนดค่าเลย์เอาต์',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'หยุดที่ข้อผิดพลาด',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'บันทึกอัตโนมัติ',
    'LBL_ACTIONBUTTON_CONFIG' => 'การกำหนดค่า',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'โปรดกำหนดค่า ปุ่มดำเนินการ ก่อนบันทึก',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'ปุ่มกำหนดค่า',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'สร้างอัตโนมัติ',
    'LBL_ACTIONBUTTON_LINK' => 'สร้างความสัมพันธ์ไปยังข้อมูลหลัก',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'คัดลอกค่าหลัก',
    'LBL_ACTIONBUTTON_PRESET' => 'ตั้งค่าฟิลด์',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'คัดลอกค่าฟิลด์จากข้อมูลหลัก',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'เลือก...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'จากฟิลด์หลัก ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'คุณแน่ใจหรือไม่ว่าต้องการลบปุ่มนี้',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'คุณแน่ใจหรือไม่ว่าต้องการลบการกระทำนี้',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'ข้อมูลการดำเนินการปุ่มไม่ถูกต้อง',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'โปรดเลือกโมดูลก่อนที่จะบันทึก',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'โปรดเลือกลิงก์ก่อนบันทึก หากไม่มีลิงก์ให้เลือก โปรดยกเลิกเครื่องหมายตัวเลือกลิงก์',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'โปรดเลือกระเบียนก่อนที่จะบันทึก',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'โปรดเลือกเทมเพลทก่อนที่จะบันทึก',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'หลัก',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'รอง',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'มหาสมุทร',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'ชมพู',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'กองทัพ',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'น้ำเงินอมเขียว',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'แปซิฟิก',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'เขียว',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'เหลือง',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'ส้ม',
    'LBL_ACTIONBUTTON_THEME_RED' => 'แดง',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'ปะการัง',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'ม่วง',
    'LBL_ACTIONBUTTON_FORMULA' => 'สูตร',
    'LBL_ACTIONBUTTON_ACTIONS' => 'การดำเนินการ',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'ข้อมูลปุ่มยืนยันผิดพลาด',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'ปุ่มจะต้องมีอย่างน้อยหนึ่งป้ายกำกับหรือหนึ่งชุดไอคอน',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'โปรดใส่ป้ายกำกับปุ่มที่ถูกต้อง',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'ไม่สามารถสร้างระเบียนได้เนื่องจากขาดค่าที่จำเป็น โปรดติดต่อผู้ดูแลระบบของคุณ',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'คุณจะต้องมีปุ่มสำหรับประเภทปุ่มนี้ที่ใช้งานอยู่อย่างน้อยสองปุ่ม',
    'LBL_ACTIONBUTTON_RECORD' => 'มุมมองระเบียน',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'เมนูกการดำเนินนการ',
    'LBL_ACTIONBUTTON_ORDER' => 'คำสั่ง',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'มุมมองรายการ',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'ส่วนหัวมุมมองระเบียน',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'ส่วนหัวส่วนข้อมูลมุมมองระเบียน',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'แผงข้อมูลย่อย',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'ผลที่ตามมาของงานทำให้เครื่องมือประสบความล้มเหลวในการกระทำการดังงต่อไปนี้: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'เพิ่มการกระทำ',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'ถอนการกระทำ',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'ผู้ใช้ปัจจุบัน',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'ผสานเอกสาร',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'ผสานเอกสารเป็น PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'ขนาดบริษัท',
    'LBL_HINT_COMPANY_INDUSTRY' => 'อุตสาหกรรม',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'แท็กอุตสาหกรรม',
    'LBL_HINT_COMPANY_LOCATION' => 'ที่ตั้งบริษัท',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'รายละเอียดบริษัท',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'ปีที่ก่อตั้ง',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Facebook บริษัท',
    'LBL_HINT_COMPANY_TWITTER' => 'Twitter บริษัท',
    'LBL_HINT_COMPANY_PIC' => 'โลโก้บริษัท',
    'LBL_HINT_CONTACT_PIC' => 'รูปภาพบริษัท',
    'LBL_HINT_COMPANY_WEBSITE' => 'เว็บไซต์บริษัท',
    'LBL_HINT_PHOTO' => 'ลิงก์รูปภาพ',
    'LBL_HINT_JOB_2' => 'งานที่ผ่านมา',
    'LBL_HINT_EDUCATION' => 'การศึกษา',
    'LBL_HINT_EDUCATION_2' => 'การศึกษาเพิ่มเติม',
    'LBL_HINT_TWITTER' => 'ลิงก์ Twitter',
    'LBL_HINT_FACEBOOK' => 'ลิงก์ Facebook',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'รหัส NAICS',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'รหัส SIC',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'สิ้นปีงบประมาณ',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'รายได้ต่อปี',
    'LBL_HINT_PHONE_1' => 'โทรศัพท์ 1',
    'LBL_HINT_PHONE_2' => 'โทรศัพท์ 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'ร่วมโต๊ะ',
    'LBL_HINT_FULL_NAME' => 'ชื่อเต็ม',
    'LBL_HINT_JOB_TITLE' => 'ตำแหน่งงาน',
    'LBL_HINT_OFFICE_PHONE' => 'โทรศัพท์ที่ทำงาน',
    'LBL_HINT_MOBILE_PHONE' => 'โทรศัพท์มือถือ',
    'LBL_HINT_OTHER_PHONE' => 'โทรศัพท์อื่น',
    'LBL_HINT_WEBSITE' => 'เว็บไซต์',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'คุณต้องการเขียนทับข้อมูลทั้งหมดในระเบียนนี้ด้วยข้อมูลใหม่ที่พบใน Sugar Hint หรือไม่',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'คุณต้องการเขียนทับ {{fieldName}} ที่มีอยู่ในระเบียนนี้ด้วย {{fieldName}} ใหม่ที่พบใน Sugar Hint หรือไม่',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'ข้อมูลทั้งหมดที่เกี่ยวข้องกับบัญชีจะถูกลบ คุณแน่ใจหรือไม่ว่าต้องการดำเนินการต่อ',
    'LBL_HINT_COMPANY_LOGO' => 'โลโก้',
    'LBL_HINT_CONTACTS_AVATAR' => 'รูปภาพ',
    'LBL_HINT_ACCOUNTSETS' => 'แท็กชุดบัญชีของ Sugar Hint',

    'LBL_HINT_LOADING' => 'กำลังโหลด ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'กำลังถอนการติดตั้ง Sugar Hint กรุณารอ',
    'LBL_HINT_VALUE_ERASED' => ' ลบค่าแล้ว ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'ลบข้อมูลนี้ตามการร้องขอการคุ้มครองข้อมูลส่วนบุคคลแล้ว',

    'LBL_HINT_UNINSTALL_TITLE' => 'โปรดเลือกหนึ่งในการถอนการติดตั้งจากตัวเลือกด้านล่างนี้:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'แพ็กเกจถอนการติดตั้ง Hint เท่านั้น',
    'LBL_HINT_UNINSTALL_FULL' => 'ถอนการติดตั้ง Hint สมบูรณ์',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'ตัวเลือกนี้จะนำ Hint MLP ออกไป และปิดการเป็นสมาชิกทั้งหมดที่ใช้งาน Sugar Hint Insights อยู่
    หากติดตั้ง Hint ใหม่จะเป็นการเปิดใช้งานการเป็นสมาชิกเองโดยอัตโนมัติ',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'ตัวเลือกนี้จะดำเนินการถอนการติดตั้ง Hint เต็มรูปแบบ รวมถึงการถอน MLP และลบการกำหนดค่าและข้อมูลการเป็นสมาชิกทั้งหมดด้วย',
    'LBL_HINT_UNINSTALL' => 'ถอนการติดตั้ง',
    'LBL_HINT_UNINSTALL_HEADER' => 'ถอนการติดตั้ง Sugar Hint',
    'LBL_HINT_CANCEL' => 'ยกเลิก',
    'LBL_HINT_UNINSTALL_WARNING1' => 'คำเตือน: โปรดเลือกตัวเลือกนี้ในกรณีที่คุณจะไม่ใช้งาน Hint อีกในอนาคตเท่านั้น
    ก่อนดำเนินการถอนการติดตั้ง โปรดสำรองฐานข้อมูล Sugar อย่างเต็มรูปแบบก่อน และตั้งให้ Sugar อยู่ในโหมดบำรุงรักษา ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'ดูที่ ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'คู่มือการบริหารจัดการ Sugar Hint ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'สำหรับรายละเอียดขั้นตอนการถอนการติดตั้ง',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'คุณแน่ใจหรือไม่ว่าต้องการถอนการติดตั้งแพ็กเกจ Sugar Hint อย่างเดียวเท่านั้น',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'คุณแน่ใจหรือไม่ว่าต้องการถอนการติดตั้ง Sugar Hint ทั้งหมด',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(โปรดทราบ: คุณจะไม่สามารถยกเลิกการกระทำนี้ได้)',

    'LBL_HINT_CONFIG_TITLE' => 'ฟิลด์ Sugar Hint',
    'LBL_HINT_NO_RESULTS_MSG' => 'ไม่พบผลลัพธ์',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'เลย์เอาต์แผงข้อมูลพื้นฐานของ Hint',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'บัญชี',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'ติดต่อ',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'ผู้สนใจ',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'เลย์เอาต์แผงข้อมูลขั้นสูง Hint',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'จัดตำแหน่งฟิลด์ใหม่โดยการลากและวางภายในส่วนเลย์เอาต์แผงข้อมูลของ Hint ข้างต้น',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'หากต้องการคำแนะนำแบบละเอียด พร้อมรายการฟิลด์เริ่มต้นต่าง ๆ โปรดไปที่ ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' เพื่อเรียกคืนการตั้งค่าเริ่มต้นสำหรับ ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'โมดูล',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'คุณแน่ใจหรือไม่ว่าต้องการกู้ข้อมูลกลับไปที่ค่าเริ่มต้นให้กับโมดูล {{module}}',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'คลิกที่นี่',
    'LBL_HINT_CONFIG_NAME' => 'คู่มือการบริหารจัดการ Hint',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'ฟิลด์',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'ฟิลด์ที่ได้รับการเพิ่มค่า',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'ส่วนนี้เป็นรายการฟิลด์ Hint และฟิลด์ Sugar ทั้งหมดที่เพิ่มค่าโดย Hint โดยฟิลด์ Hint จะมีเครื่องหมายดอกจัน (*) และจะแสดงอยู่ในแผลข้อมูล Hint ในกรณีที่ได้รับการเพิ่มค่าเท่านั้น',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'ชื่อฟิลด์',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'ฟิลด์ที่เพิ่มค่า',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'แสดงใน Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'แสดงในแผงข้อมูล Hint',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'ฟิลด์ Sugar เพิ่มเติม',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'ส่วนนี้แสดงรายการฟิลด์ Sugar ทั้งหมดที่ไม่ได้เพิ่มค่าโดย Hint',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'คำเตือน',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'คำเตือน: คุณกำลังจะซิงค์กับบริการ Sugar Hint Insights อีเมลสรุปที่กำลังอยู่ระหว่างการดำเนินการจะสูญหาย และข่าวสารที่มีอยู่จะถูกล้างออกจากส่วนข้อมูลเชิงลึก การแจ้งเตือนทุกชนิดจะกลับมาทำงานอีกครั้งเมื่อการซิงค์เสร็จสมบูรณ์',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'บริษัทแนะนำที่เกี่ยวข้องกับ {{_moduleSingular}} ของคุณมีรายชื่อตามด้านล่าง โปรดเลือกข้อมูลบริษัทเพื่อแสดง',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'ไม่ได้เลือกบัญชี',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'พบหลายอีเมล โปรดเลือกอีเมลเพื่อนำเข้า: ',

    'LBL_HINT_HELP_MESSAGE1' => 'Hint ไม่สามารถหาข้อมูลในระบบที่ตรงกับข้อมูลที่ป้อนเข้ามาได้',
    'LBL_HINT_HELP_MESSAGE2' => 'ชื่อและที่อยู่อีเมลของบุคคลจะสามารถหาผลลัพธ์ที่ดีที่สุดใน Hint ได้',
    'LBL_HINT_HELP_MESSAGE3' => 'url เว็บไซต์บริษัทจะสามารถหาผลลัพธ์ที่ดีที่สุดใน Hint ได้',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "ป้อนชื่อบริษัทหรือเว็บไซต์ของ {{_moduleSingular}} และ Hint จะค้นหาข้อมูลเพิ่มเติมให้",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "ป้อนที่อยู่อีเมลของ {{currentModule}} และ Hint จะค้นหาข้อมูลเพิ่มเติมให้",

    'LBL_HINT_HISTORY_NONE' => 'ไม่มีข้อมูลย้อนหลังให้ดู',
    'LBL_HINT_HISTORY_TITLE' => 'ประวัติกิจกรรม',

    'LBL_HINT_PREVIEW_TITLE' => 'การเพิ่มค่าข้อมูล',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'ใบอนุญาตบริการ Hint หมดอายุแล้ว โปรดติดต่อผู้ดูแลระบบ SugarCRM ของคุณเพื่อต่ออายุใบอนุญาตของคุณ',
    'LBL_HINT_PREVIEW_QUESTION' => 'อยากรู้ว่า Hint สามารถทำประโยชน์อะไรให้กับคุณและบริษัทของคุณได้บ้างใช่ไหม โปรดติดต่อผู้ดูแลระบบ SugarCRM ของคุณเพื่อเพิ่ม Hint',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'ไม่พบข้อมูลบัญชี',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'พบข้อมูลที่มีการเพิ่มค่า โปรดคลิกเพื่อบันทึกข้อมูลที่เพิ่มค่าทั้งหมดไว้ในระเบียนของคุณ',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'คลิกเพื่อบันทึกข้อมูลที่เพิ่มค่าลงไปในระเบียน',

    'LBL_HINT_CONTACTS_TITLE' => 'ผู้ติดต่อที่เกี่ยวข้อง',
    'LBL_HINT_CONTACTS_NONE' => 'ไม่มีผู้ติดต่อที่เกี่ยวข้อง',

    'LBL_HINT_NEWS' => 'ข่าวสาร',
    'LBL_HINT_GENERAL' => 'ทั่วไป',
    'LBL_HINT_ALL_NEWS' => 'ข่าวสารทั้งหมด',
    'LBL_HINT_FILTER_NEWS' => 'ตัวกรองข่าวสาร',
    'LBL_HINT_FINANCIAL_NEWS' => 'การเงิน',
    'LBL_HINT_PERSONNEL_NEWS' => 'ฝ่ายบุคคล',
    'LBL_HINT_PRESS_RELEASES' => 'ข่าวประชาสัมพันธ์',
    'LBL_HINT_OTHER_NEWS' => 'อื่น ๆ',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'ค้นหาบทความใหม่',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'ไม่มีข่าวสารให้อ่าน',
    'LBL_NEW_NOTIFICATIONS' => 'การแจ้งเตือนใหม่',
    'LBL_HINT_DASHLET_ALLOWED1' => 'คุณต้องมีใบอนุญาตใช้งาน Sugar Hint เพื่อเข้าดูส่วนข้อมูล Sugar Hint Insights
    โปรดสอบถามผู้ดูแลระบบของคุณเกี่ยวกับการขอใบอนุญาตใช้งาน Sugar Hint',

    'LBL_HINT_FOR' => 'สำหรับ',
    'LBL_HINT_WITH' => 'กับ',
    'LBL_HINT_SHOW_ME' => 'แสดงให้ฉัน: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'แจ้งฉันโดย: ',

    'LBL_NOTIFICATIONS_TITLE' => 'ศูนย์การตั้งค่า Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'คีย์ตัวเลือกการตั้งค่า',
    'LBL_HINT_PREFERENCES' => 'การตั้งค่า',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'ปิดใช้งานการลบ จำเป็นต้องใช้อย่างน้อยหนึ่งคำสั่งการตั้งค่า',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'ปิดใช้งานการเพิ่ม คุณได้ใช้คำสั่งการตั้งค่าถึงขีดจำกัดสูงสุดแล้ว',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'รวมในส่วนข้อมูล Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'เด้งขึ้นเป็นการแจ้งเตือนในเดสก์ท็อป',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'ต้องเปิดใช้งานการแจ้งเตือนในทุกเบราว์เซอร์ และในคอมพิวเตอร์เดสก์ท็อปทุกเครื่องเพื่อให้สามารถรับการแจ้งเตือนได้อย่างสม่ำเสมอ',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'บางเบราว์เซอร์ เช่น Internet Explorer จะไม่รองรับการแจ้งเตือน การแจ้งเตือนจะไม่สามารถใช้งานได้หากใช้เบราว์เซอร์ที่ไม่รองรับการแจ้งเตือน',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'ส่งอีเมลแบบทันทีเพื่อเตือนให้เห็นการแจ้งเตือนแต่ละรายการ',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'ส่งอีเมลสรุปรายวัน',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'ส่งอีเมลสรุปรายสัปดาห์',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'ไม่สามารถบันทึกค่าที่ต้องการได้ โปรดตรวจสอบการเชื่อมต่อของระบบและลองใหม่อีกครั้ง',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'ค่าในฟิลด์ที่ต้องระบุบางช่องหายไป โปรดตรวจสอบการตั้งค่าของคุณและดูให้แน่ใจว่าได้ใส่ข้อมูลลงในฟิลด์ที่ต้องระบุครบทุกช่อง',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'คุณกำลังจะเปิดใช้งานการแจ้งเตือนทางเบราว์เซอร์สำหรับ Sugar Hint Insights โปรดคลิก "ยืนยัน" เพื่อดำเนินการต่อ จากนั้นเบราว์เซอร์ของคุณจะขอสิทธิ์ในการรับการแจ้งเตือนกิจกรรมต่าง ๆ',
    'LBL_HINT_PUSH_ERROR' => 'มีการลงทะเบียนปลั๊กอินการแจ้งเตือนแบบพุชสำหรับ{{options.type}} โดยไม่มีการอ้างอิงใด ๆ ปลั๊กอินนี้จะไม่ทำงานตามที่คาดหวัง โปรดตรวจดูให้แน่ใจว่าคุณได้ให้เส้นทางไปยังไฟล์ผู้ทำงาน และวิธีสำหรับการบันทึกการเป็นสมาชิกในเซิร์ฟเวอร์',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'เปิดการแจ้งเตือน Hint สำหรับผู้ใช้ทุกคน',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'ปิดการแจ้งเตือน Hint สำหรับผู้ใช้ทุกคน',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'คำเตือน: การปิดการทำงานการแจ้งเตือนระหว่างการถอนการติดตั้ง Sugar Hint ล้มเหลว หากต้องการปิดการใช้งานการแจ้งเตือน โปรดติดตั้ง Sugar Hint 5.4.0 หรือรุ่นใหม่กว่า และดำเนินการถอนการติดตั้งให้สมบูรณ์โดยใช้โปรแกรมถอนการติดตั้ง Sugar Hint ที่ได้จากแผนกบริหารจัดการของ Sugar',
    'LBL_HINT_ENRICH_ALL' => 'เพิ่มค่าทั้งหมด',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'ต้องใช้ใบอนุญาตใช้งาน Hint',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'การกำหนดค่าแผนที่',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'เครื่องมือดูบันทึกจีโอโค้ด',
    'LBL_MAP_MAP' => 'แผนที่',
    'LBL_MAP_MAPS' => 'แผนที่',
    'LBL_MAP_GEOCODING_RECORD' => 'จีโอโค้ด',
    'LBL_MAP_GEOCODE_SUCCESS' => 'ทำจีโอโค้ดระเบียนสำเร็จแล้ว',
    'LBL_MAP_LATITUDE' => 'ละติจูด',
    'LBL_MAP_LONGITUDE' => 'ลองจิจูด',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'ค้นหาจากที่อยู่...',
    'LBL_MAP_ALREADY_GEOCODED' => 'มีการทำจีโอโค้ดระเบียนปัจจุบันแล้ว คุณแน่ใจหรือไม่ว่าต้องการเขียนทับจีโอโค้ดให้กับระเบียนนี้',
    'LBL_MAPS_MANUAL_GEOCODING' => 'จีโอโค้ดแบบกำหนดเอง',
    'LBL_MAP_POINT_COORDINATES' => 'จุดพิกัดแผนที่',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'การคำนวณเส้นทางที่มีประสิทธิภาพมากที่สุด...',
    'LBL_MAP_DIRECTIONS' => 'ทิศทาง',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'ทิศทางโดยเริ่มจากผู้ใช้ปัจจุบัน',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'ทิศทางโดยเริ่มจากระเบียน',
    'LBL_MAPS_RADIUS_INPUT' => 'รัศมี (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'ในรัศมีจากรหัสไปรษณีย์',
    'LBL_MAPS_DISTANCE' => 'ระยะทาง',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'รหัสไปรษณีย์',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'การกำหนดค่าไม่ถูกต้อง: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> ฟิลด์แผนที่ไม่ถูกต้อง',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'ประเภทแผนที่',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'ระดับการขยาย',
    'LBL_MAPS_DASHLET' => 'แผนที่',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'แสดงระเบียนที่มีจีโอโค้ดในแผนที่',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'แผนที่ไม่พร้อมให้บริการสำหรับโมดูลนี้ โปรดเปิดใช้งานแผนที่ในคอนโซลผู้ดูแลระบบ',
    'LBL_MAP_MODULES' => 'โมดูล',
    'LBL_MAP_FILTER_BY' => 'กรองตาม',
    'LBL_MAP_UNIT_TYPE' => 'ประเภทหน่วย',
    'LBL_MAP_UNIT_TYPE_MILES' => 'ไมล์',
    'LBL_MAP_UNIT_TYPE_KM' => 'กิโลเมตร',
    'LBL_MAP_ADDRESS' => 'ที่อยู่',
    'LBL_MAP_NO_STARTING_POINT' => 'จุดเริ่มต้นไม่ได้ทำจีโอโค้ด',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'ระเบียนจุดเริ่มต้นไม่ได้ทำจีโอโค้ด',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'บางระเบียนที่เลือกไม่ได้ทำจีโอโค้ด และจะไม่สามารถแสดงขึ้นในแผนที่ได้',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'ระเบียนไม่ได้ทำจีโอโค้ด',
    'LBL_MAPS_MODULE_FIELDS' => 'ฟิลด์โมดูล',
    'LBL_MAPS_SELECT_FIELD' => 'เลือกฟิลด์',
    'LBL_MAPS_RELATE_RECORD' => 'ระเบียนที่เกี่ยวข้อง',
    'LBL_MAPS_MAPPING_TYPE' => 'ประเภทแผนที่',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'ไม่มีระเบียนที่ทำจีโอโค้ด',
    'LBL_MAPS_ADDRESS' => 'ที่อยู่',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'ผู้ใช้ที่กำหนด',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'มุมมองข้างถนนไม่พร้อมให้บริการในจุดดังกล่าว',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> ระเบียนไม่พร้อมสำหรับการทำแผนที่ โปรดลบโมดูลออกจากรายการนี้',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'ปิด',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'ขยาย',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'บันทึกเป็น PDF',
    'LBL_MAPS_EMAIL_LINK' => 'ลิงก์อีเมล',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'คุณต้องมีระเบียนจีโอโค้ดอย่างน้อยหนึ่งระเบียน',
    'LBL_MAPS_GENERATING' => 'กำลังสร้างแผนที่',
    'LBL_MAPS_POINTS' => 'จุดแผนที่',
    'LBL_MAPS_POINT' => 'จุด',
    'LBL_MAPS_TRAVEL_DETAILS' => 'รายละเอียดการเดินทาง',
    'LBL_MAPS_TOTAL_DISTANCE' => 'ระยะทางทั้งหมด',
    'LBL_MAPS_TOTAL_DURATION' => 'ระยะเวลาทั้งหมด',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'ระยะเวลาทั้งหมดโดยไม่นับการจราจร',
    'LBL_MAPS_ITINERARY' => 'แผนการเดินทาง',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'ระยะทางการเดินทาง',
    'LBL_MAPS_TRAVEL_DURATION' => 'ระยะเวลาการเดินทาง',
    'LBL_MAPS_TRAVEL_STEPS' => 'ก้าว',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'คำเตือน',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Maps รองรับการปักหมุดสูงสุด 10 ตำแหน่งในแผนที่ที่แชร์ โปรดตรวจสอบตัวเลือกของคุณ',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'ต้องใช้ใบอนุญาตใช้งานแผนที่',
    'LBL_MAPS_SHARE_HELLO' => 'สวัสดี',
    'LBL_MAPS_SHARE_HEADER' => 'คุณได้ส่งคำขอ Bing map ในจุดพิกัดต่อไปนี้:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'URL ต่อไปนี้จะเปิดแผนที่ซึ่งมีจุดพิกัดตามที่แสดงอยู่ด้านบนใน Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'แสดงแผนที่ใน Bing Maps',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'ไม่พบเส้นทางสำหรับเวย์พอยต์ที่ให้มา',
    'LBL_MAPS_GEOCODE_STATUS' => 'สถานะจีโอโค้ด',
    'LBL_MAPS_GEOCODED' => 'จีโอโค้ด',
    'LBL_MAPS_NOT_GEOCODED' => 'ไม่ได้ระบุจีโอโค้ด',
    'LBL_MAPS_NOT_FOUND' => 'ที่อยู่ไม่ถูกต้อง',
    'LBL_MAPS_GEOCODING_FAILED' => 'การระบุจีโอโค้ดล้มเหลว',
    'LBL_MAPS_QUEUED' => 'อยู่ในคิว',
    'LBL_MAPS_REQUEUED' => 'อยู่ในคิวอีกครั้ง',
    'LBL_MAPS_RELATED_RECORD' => 'ระเบียนที่เกี่ยวข้อง',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'ดูรายงาน',
    'LBL_REPORT_DASHLET_DESC' => 'แสดงรายงานที่บันทึกไว้',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'รีเซ็ตค่าเริ่มต้นส่วนข้อมูล',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'รีเซ็ตไปยังค่าเริ่มต้นรายงาน',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'รีเฟรชผลลัพธ์',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'คัดลอกแผนภูมิไปยังคลิปบอร์ด',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'ดาวน์โหลดแผนภูมิ',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'มีการแก้ไขรายงานสำหรับส่วนข้อมูล {{label}} และได้รีเซ็ตส่วนข้อมูลไปยังการกำหนดค่าเริ่มต่น',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'คุณไม่มีสิทธิ์ใช้งานฟิลด์นี้',

    'LBL_INVALID_FORMULA' => 'สูตรไม่ถูกต้อง',
    'LBL_RETURN_TYPE_MISSMATCH' => 'ประเภทฟังก์ชันที่กลับมาไม่ตรงกัน',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'การพยากรณ์',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'โปรไฟล์ลูกค้าในอุดมคติ',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'คะแนนพยากรณ์เมื่อปิดสัปดาห์',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'ค่าการพยากรณ์',
    'LBL_AI_CONV_BIN_ACCURACY' => 'ความแม่นยำในการพยากรณ์ค่า bin',
    'LBL_AI_CONV_MULTIPLIER' => 'ตัวคูณการพยากรณ์',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ค่า ICP',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ความแม่นยำค่า ICP bin',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ตัวคูณ ICP',
    'LBL_AI_NEW' => 'ใหม่',
    'LBL_AI_ENTERED' => 'กรอก',
    'LBL_AI_CREATED' => 'สร้างแล้ว',
    'LBL_AI_WEEK' => 'สัปดาห์',
    'LBL_AI_MONTH' => 'เดือน',
    'LBL_AI_QUARTER' => 'ไตรมาส',
    'LBL_AI_BYWEEK' => 'ตามสัปดาห์',
    'LBL_AI_BYMONTH' => 'ตามเดือน',
    'LBL_AI_BYQUARTER' => 'ตามไตรมาส',
    'LBL_AI_WEEKTREND' => 'แนวโน้มรายสัปดาห์',
    'LBL_AI_MONTHLYTREND' => 'แนวโน้มรายเดือน',
    'LBL_AI_QUARTERTREND' => 'แนวโน้มรายไตรมาส',
    'LBL_AI_TREND' => 'แนวโน้มตาม',
    'LBL_AI_TRENDS' => 'แนวโน้มตาม',
    'LBL_AI_VELOCITY' => 'ความเร็ว',
    'LBL_AI_TOPX' => '{X} บน',
    'LBL_AI_TIMESPAN' => 'ระยะเวลาระหว่างขั้นตอน',
    'LBL_AI_BUSINESSTREND' => 'กับแนวโน้มธุรกิจ',
    'LBL_AI_SUGARINSIGHTINTRO' => 'ทำความรู้จัก Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights นำการวิเคราะห์เชิงปริมาณมาใช้เพื่อสร้างข้อมูลเชิงลึกใหม่ ๆ ที่เกี่ยวกับข้อมูล SugarCRM ของคุณ ที่ Sugar เรามักจะมองหาวิธีใหม่ ๆ ที่จะช่วยให้คุณได้รับประโยชน์สูงสุดจากข้อมูลของคุณ ทำการตัดสินใจอย่างชาญฉลาด และนี่เป็นเพียงจุดเริ่มต้นของความคาดหวังที่ Sugar Insights จะมอบให้คุณ',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights นำการวิเคราะห์เชิงปริมาณมาใช้เพื่อสร้างข้อมูลเชิงลึกใหม่ ๆ ที่เกี่ยวกับข้อมูล SugarCRM ของคุณ',
    'LBL_AI_FIRMO' => 'Firmographics',
    'LBL_AI_TOTALCOUNT' => 'จำนวนรวมของ',
    'LBL_AI_DAYSFROMLATESTACT' => 'วัน นับจากครั้งสุดท้าย',
    'LBL_AI_DAYSSINCE' => 'อายุ',
    'LBL_AI_FIELDISSET' => 'มีอยู่',
    'LBL_AI_CONTACTCOMPLETENESS' => 'ความสมบูรณ์ของข้อมูลการติดต่อ',
    'LBL_AI_CUTDATE' => 'ช่วงเวลาการพยากรณ์',
    'LBL_AI_FROMLASTCHANGE' => 'วัน นับจากการเปลี่ยนค่าฟีเจอร์ล่าสุด',
    'LBL_AI_CALLSHELD' => 'จํานวนการโทรทั้งหมด',
    'LBL_AI_CALLSPLANNED' => 'จํานวนการโทรทั้งหมดที่วางแผนไว้',
    'LBL_AI_OUTBOUNDCALLS' => 'จํานวนการโทรออกทั้งหมด',
    'LBL_AI_INBOUNDCALLS' => 'จํานวนการโทรเข้าทั้งหมด',
    'LBL_AI_AVGCALLDURATION' => 'ระยะเวลาเฉลี่ยของการโทร',
    'LBL_AI_EMAILSARCHIVED' => 'จํานวนอีเมลที่เก็บถาวรทั้งหมด',
    'LBL_AI_EMAILSREAD' => 'จำนวนอีเมลที่อ่านแล้วทั้งหมด',
    'LBL_AI_EMAILSSENT' => 'จำนวนอีเมลที่ส่งแล้ว',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'จํานวนระเบียนทั้งหมดที่วันที่ปิดที่คาดไว้ถูกเปลี่ยนเป็นวันอื่นในภายหลัง',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'จํานวนรวมของระเบียนที่วันที่ปิดที่คาดไว้ถูกเปลี่ยนเป็นวันที่เร็วกว่า',
    'LBL_AI_AMOUNTINCREASED' => 'โอกาสในการขายทั้งหมดที่จํานวนเงินเพิ่มขึ้น',
    'LBL_AI_AMOUNTDECREASED' => 'โอกาสในการขายทั้งหมดที่จํานวนเงินลดลง',

    // User last state
    'LBL_LAST_STATE' => 'สถานะสุดท้าย',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'ส่งไปยัง DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'ยกเลิกแก้ไขผู้รับ',
    'LBL_RECIPIENT_ROLE' => 'บทบาทผู้รับ',
    // Base sales stages
    'LBL_OPEN' => 'เปิด',
    'LBL_CLOSED_WON' => 'ปิดโดยได้รับการขาย',
    'LBL_CLOSED_LOST' => 'ปิดโดยไม่ได้รับการขาย',
    'LBL_KIOSK_ADD_FILES' => 'เพิ่มไฟล์',
    'LBL_KIOSK_ADD_DROP_FILES' => 'เพิ่มหรือวางไฟล์ที่นี่',
    'LBL_KIOSK_CANCEL' => 'ยกเลิก',
    'LBL_KIOSK_EDIT' => 'แก้ไข',
    'LBL_KIOSK_EMAIL' => 'อีเมล',
    'LBL_KIOSK_FILES_UPLOADING' => 'อัปโหลด',
    'LBL_KIOSK_FILES_ERROR' => 'ไม่สามารถอัปโหลดไฟล์แนบ',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'ไฟล์แนบมีขนาดใหญ่เกินไป',
    'LBL_KIOSK_FILTER_SEARCH' => 'ค้นหา',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'คีออสก์',
    'LBL_KIOSK_LANGUAGE' => 'ภาษา',
    'LBL_KIOSK_LAST_UPDATED' => 'การอัปเดตล่าสุด',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'มุมมอง',
    'LBL_KIOSK_MENU' => 'เมนู',
    'LBL_KIOSK_MOBILE_PHONE' => 'โทรศัพท์มือถือ',
    'LBL_KIOSK_MY_ACTIVITIES' => 'กิจกรรมของฉัน',
    'LBL_KIOSK_MY_PROFILE' => 'โปรไฟล์ของฉัน',
    'LBL_KIOSK_NAME' => 'ชื่อ',
    'LBL_KIOSK_OFFICE_PHONE' => 'โทรศัพท์ที่ทำงาน',
    'LBL_KIOSK_ORGANIZATION' => 'องค์กร',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'แถวต่อหน้า:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'ขับเคลื่อนโดย SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'บันทึกการเปลี่ยนแปลง',
    'LBL_KIOSK_SHOW_HIDE' => 'แสดง/ซ่อน',
    'LBL_KIOSK_SIGN_IN' => 'เข้าสู่ระบบ',
    'LBL_KIOSK_SIGN_OUT' => 'ออกจากระบบ',
    'LBL_KIOSK_SORT_BY' => 'เรียงตาม',
    'LBL_KIOSK_SUBMIT' => 'ส่ง',
    'LBL_KIOSK_TIMEZONE' => 'เขตเวลา',
    'LBL_KIOSK_ACTIVITY' => 'กิจกรรม',
    'LBL_KIOSK_NO_ACTIVITY' => 'ไม่มีกิจกรรมให้แสดง',
    'LBL_KIOSK_OLDEST_FIRST' => 'เก่าสุดก่อน',
    'LBL_KIOSK_NEWEST_FIRST' => 'ใหม่สุดก่อน',
    'LBL_KIOSK_SHOW_MORE' => 'แสดงเพิ่มเติม',
    'LBL_KIOSK_ADD_A_REPLY' => 'เพิ่มคำตอบกลับ',
    'LBL_KIOSK_REPLY_EMPTY' => 'ไม่สามารถเว้นคำตอบกลับให้ว่างไว้ได้',
    'LBL_KIOSK_NUM_MORE' => '{{num}} อื่น ๆ',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'ยินดีต้อนรับ',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'เข้าถึงทรัพยากรของคุณได้อย่างรวดเร็ว',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'ค้นหาเคส',
    'LBL_KIOSK_SHOW_ALL' => 'แสดงทั้งหมด',
    'LBL_KIOSK_404_TITLE' => 'เราไม่สามารถหาสิ่งนี้พบ',
    'LBL_KIOSK_TENANT_404_TITLE' => 'ไม่พบผู้เช่า',
    'LBL_KIOSK_404_MESSAGE' => 'คุณได้คลิกลิงก์ที่ถูกนําออก ลิงก์ที่ไม่พร้อมใช้งานชั่วคราว หรือคุณป้อน URL ที่ไม่ถูกต้อง',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'โปรดดูให้แน่ใจว่าคุณใช้ URL ที่ถูกต้อง หากต้องการการช่วยเหลือในอนาคต โปรดติดต่อฝ่ายสนับสนุน',
    'LBL_KIOSK_BACK_TO_HOME' => 'กลับไปที่หน้าหลัก',
    'LBL_KIOSK_ERROR_CODE' => '{code} ผิดพลาด: ',
    'LBL_KIOSK_401_TITLE' => 'ไม่ได้รับอนุญาต',
    'LBL_KIOSK_401_MESSAGE' => 'คุณไม่ได้รับอนุญาตให้ดูหน้านี้นี้',
    'LBL_KIOSK_403_TITLE' => 'ไม่ได้รับอนุญาต',
    'LBL_KIOSK_403_MESSAGE' => 'คุณไม่มีสิทธิ์เข้าถึงหน้านี้',
    'LBL_KIOSK_500_TITLE' => 'เซิร์ฟเวอร์ไม่ตอบสนอง',
    'LBL_KIOSK_500_MESSAGE' => 'มีบางอย่างผิดพลาดในส่วนของเรา',
    'LBL_KIOSK_GO_BACK' => 'ย้อนกลับ',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'พบบันทึกที่ซ้ํากัน',
    'LBL_KIOSK_ACCOUNT' => 'บัญชี',
    'LBL_KIOSK_STATUS' => 'สถานะ',
    'LBL_KIOSK_DEACTIVATE' => 'ปิดการใช้งาน',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'ผู้ใช้ถูกปิดการใช้งาน',
    'LBL_KIOSK_MANAGE_USERS' => 'จัดการผู้ใช้',
    'LBL_KIOSK_LAST_LOGIN' => 'ล็อกอินครั้งล่าสุด',
    'LBL_KIOSK_FIRST_NAME' => 'ชื่อ',
    'LBL_KIOSK_LAST_NAME' => 'นามสกุล',
    'LBL_KIOSK_ROLE' => 'บทบาท',
    'LBL_KIOSK_INVITE' => 'เชิญ',
    'LBL_KIOSK_SEND_INVITES' => 'ส่งคำเชิญ',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'ส่งคําเชิญเรียบร้อยแล้ว',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'ไม่ได้ส่งคําเชิญ',
    'LBL_KIOSK_REACTIVATE' => 'เปิดใช้งานอีกครั้ง',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'ผู้ใช้ถูกเปิดใช้งานอีกครั้ง',
    'LBL_KIOSK_RESET_PASSWORD' => 'รีเซ็ตรหัสผ่าน',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'ส่งอีเมลรีเซ็ตรหัสผ่านแล้ว',
    'LBL_KIOSK_USER_PROFILE' => 'โปรไฟล์ผู้ใช้',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'ผู้ใช้ของคุณถูกปิดใช้งาน โปรดติดต่อผู้ดูแลระบบของคุณ',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'กลับไปที่ล็อกอิน',
    'LBL_KIOSK_REVOKE_INVITATION' => 'เพิกถอนคําเชิญ',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'เพิกถอนคําเชิญเรียบร้อยแล้ว',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'ค้นหาและเลือก...',
    'LBL_KIOSK_NO_MATCHES' => 'ไม่พบรายการที่ตรงกัน',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'อัปเดตโปรไฟล์แล้ว',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'มีปัญหาในการอัปเดตโปรไฟล์',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'เอกสาร',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'ดู ค้นหา และดาวน์โหลดเอกสารที่แชร์ขาเข้าของคุณ',
    'LBL_KIOSK_CASES' => 'เคส',
    'LBL_KIOSK_CASES_DESC' => 'ดู ค้นหา และตอบกลับเคสและปัญหาที่แชร์กับคุณ',
    'LBL_KIOSK_DOWNLOAD' => 'ดาวน์โหลด',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'ดาวน์โหลดไฟล์สำเร็จแล้ว',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'เริ่มต้นใช้งาน',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'โปรดระบุชื่อและนามสกุลของคุณให้เราทราบ',
    'LBL_KIOSK_SAVE' => 'บันทึก',
    'LBL_KIOSK_SHARED' => 'แชร์แล้ว',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'ขอต้อนรับ {firstName} {lastInitial}',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'สีพื้นหลัง',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'URL ภาพพื้นหลัง',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'แนะนําให้เลือกรูปภาพที่มีขนาดไฟล์น้อยกว่า 400K',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'ประเภทพื้นหลัง',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'พื้นหลังหน้าหลัก',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'ธีม',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'สีหลักของธีม',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'ชื่อแอป',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'นี่คือชื่อแอปพลิเคชันของคุณซึ่งแสดงอยู่ถัดจากโลโก้ของคุณ',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'URL โลโก้แอป',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'แนะนําให้เลือกโลโก้ที่สามารถดูได้ดีที่สุดในที่ขนาดเล็ก (เช่น โปรไฟล์โซเชียลมีเดีย) ขอแนะนําให้มีขนาดไฟล์น้อยกว่า 200K',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'URL Favicon ของแอป',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'Favicon คือโลโก้ขนาดเล็กที่ปรากฏอยู่ข้างชื่อหน้าในแท็บเบราว์เซอร์',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'กิจกรรมมอบหมายใหม่อัตโนมัติที่เปิดอยู่',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'ถึงขีดจํากัดผู้ใช้แล้ว',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'คีย์ใบอนุญาตไม่ถูกต้อง',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'แอปพลิเคชันไม่ถูกต้อง',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'แอปพลิเคชันไม่ถูกต้อง',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'คีย์การตรวจสอบเสียหาย',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'ใบอนุญาตหมดอายุแล้ว',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'ข้อมูลที่หายไป',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'คีย์ตรวจสอบสูญหาย',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'ผู้ใช้สูญเสียการเข้าถึง',
    'LBL_DRI_WORKFLOW' => 'คู่มืออัจฉริยะ',
    'LBL_DRI_WORKFLOWS' => 'คู่มืออัจฉริยะ',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'คู่มืออัจฉริยะ เทมเพลตขั้นตอน',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'คู่มืออัจฉริยะ เทมเพลตขั้นตอน',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'คู่มืออัจฉริยะ เทมเพลต',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'คู่มืออัจฉริยะ เทมเพลตกิจกรรม',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'เทมเพลตกิจกรรม',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'เว็บฮุค',
    'LBL_CJ_WEBHOOKS' => 'เว็บฮุค Sugar Automate',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'กิจกรรมคู่มืออัจฉริยะปัจจุบันที่',
    'LBL_CJ_WEBHOOKS' => 'เว็บฮุค Sugar Automate',
    'LBL_CJ_WEBHOOK' => 'เว็บฮุค Sugar Automate',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'การดำเนินการ Sugar',
    'LBL_CJ_FORMS' => 'Smart Guide การดำเนินการ Sugar',
    'LBL_CJ_FORM' => 'Smart Guide การดำเนินการ Sugar',
    'LBL_DRI_SUBWORKFLOW' => 'คู่มืออัจฉริยะ ขั้นตอน',
    'LBL_DRI_SUBWORKFLOWS' => 'คู่มืออัจฉริยะ ขั้นตอน',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'คู่มืออัจฉริยะ เทมเพลตกิจกรรม',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'คู่มืออัจฉริยะ เทมเพลต',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'คู่มืออัจฉริยะ คำสั่ง',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'คู่มืออัจฉริยะ คำสั่งจริง',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'คู่มืออัจฉริยะ คะแนน',
    'LBL_CJ_MOMENTUM_POINTS' => 'คู่มืออัจฉริยะ จุดโมเมนตัม',
    'LBL_CJ_MOMENTUM_SCORE' => 'คู่มืออัจฉริยะ คะแนนโมเมนตัม',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'คู่มืออัจฉริยะ อนุญาตกิจกรรมโดย',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'คู่มืออัจฉริยะ ความคืบหน้า',
    'LBL_CJ_MOMENTUM_RATIO' => 'คู่มืออัจฉริยะ อัตราส่วนโมเมนตัม',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'คู่มืออัจฉริยะจุด',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'คู่มืออัจฉริยะ งาน',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'คู่มืออัจฉริยะ ประเภทกิจกรรมหลัก',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'คู่มืออัจฉริยะ บล็อกโดย',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'คู่มืออัจฉริยะ บล็อกโดยขั้นตอน',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'คู่มืออัจฉริยะ ID กิจกรรมหลัก',
    'LBL_START_NEXT_JOURNEY_ID' => 'เริ่มคู่มืออัจฉริยะ ID ถัดไป',
    'LBL_CJ_URL' => 'คู่มืออัจฉริยะ Url',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'คู่มืออัจฉริยะ กิจกรรมหลัก',
    'LBL_CJ_MOMENTUM_START_DATE' => 'คู่มืออัจฉริยะ วันที่เริ่มโมเมนตัม',
    'LBL_CJ_MOMENTUM_END_DATE' => 'คู่มืออัจฉริยะ วันที่สิ้นสุดโมเมนตัม',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'กำหนดค่าเลย์เอาต์วิดเจ็ต',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'กำหนดค่าเลย์เอาต์วิดเจ็ต',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'จำนวนสูงสุดของคู่มืออัจฉริยะจากเทมเพลตเดียวกัน',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'ใช้งาน',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'เก็บถาวร',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'แสดง',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'ซ่อน',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'โหมดแนวตั้ง',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'โหมดแนวนอน',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'ใบอนุญาตไม่ถูกต้อง',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} มอบหมายกิจกรรมคู่มืออัจฉริยะดังต่อไปนี้ให้แก่ {{assigned_user}}</p>
    <ul>{{activities}}</ul>
    
    <p>คุณสามารถตรวจสอบกิจกรรมนี้ได้ที่:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'ใบอนุญาตไม่ถูกต้อง',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'จำนวนผู้ใช้ถึงขีดจำกัดแล้ว คุณมีเวลา {{gracePeriodDays}} วันเพื่ออัปเกรดใบอนุญาต',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - กิจกรรมคู่มืออัจฉริยะที่ได้รับมอบหมาย',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'ผู้ใช้ Sugar Automate ของ {0} เกินขีดจำกัดแล้ว<br>
    <br>
    โปรดติดต่อ <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> เพื่อเพิ่มขีดจำกัดหรือลดจำนวนผู้ใช้โดยใช้ปลั๊กอิน',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'ถึงขีดจํากัดของผู้ใช้ Sugar Automate แล้ว',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'ใบอนุญาต Sugar Automate จะหมดอายุภายใน {0} วัน <br>
    <br>
    โปรดติดต่อ SugarCRM หรือพาร์ทเนอร์ Sugar ของคุณเพื่อต่ออายุและป้องกันไม่ให้การบริการติดขัด',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'ใบอนุญาต Sugar Automate กําลังจะหมดอายุ',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'ทดสอบเว็บฮุค',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide ความคืบหน้า',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'แสดงแผนภูมิวงกลม Sugar Automate "Smart Guide ความคืบหน้า"',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'แสดงการตอบสนองของเว็บฮุค',
    'LBL_DASHLET_SEND_LABEL' => 'ส่งคําขอ',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'มอบหมายให้กับ',
    'LBL_COMPLETE_BUTTON_TITLE' => 'เสร็จสมบูรณ์',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'ทำทุกงานให้สมบูรณ์',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'ลบขั้นตอน',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'เริ่มต้น',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'ใช้งานไม่ได้',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'เพิ่มขั้นตอน',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'มุมมอง',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'แก้ไขคู่มืออัจฉริยะ',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'ยกเลิก',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'เก็บถาวร',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'ยกเลิกการเก็บถาวร',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'กําหนดค่าเทมเพลต',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'เพิ่มงาน',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'วางกำหนดการประชุม',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'วางกำหนดการโทร',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'ในอนาคต',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'เกินกำหนดแล้ว',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'คือวันนี้',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'คือพรุ่งนี้',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการลบคู่มืออัจฉริยะนี้',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'คุณกำลังจะทำทุกงานให้สมบูรณ์ คุณแน่ใจหรือไม่ว่าต้องการดำเนินการต่อ',
    'LBL_CJ_BLOCK_BY' => 'คุณมีงานอ้างอิงที่ยังทำไม่เสร็จ: {{Name}} โปรดทำงานนี้ให้เสร็จก่อนทำงานทุกงานให้สมบูรณ์',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'คุณมีงานอ้างอิงที่ยังทำไม่เสร็จจำนวนมาก โปรดทำงานนี้ให้เสร็จก่อนทำงานทุกงานให้สมบูรณ์',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'คุณทำทุกงานให้สมบูรณ์สำเร็จแล้ว',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการเก็บถาวรให้กับคู่มืออัจฉริยะนี้',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'คุณแน่ใจหรือไม่ว่าต้องการยกเลิกการเก็บถาวรคู่มืออัจฉริยะนี้',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: คู่มืออัจฉริยะ (ลิ้นชักโฟกัส & คอนโซล)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'ดูคู่มืออัจฉริยะที่ใช้งานอยู่บนคอนโซลบริการ/การต่ออายุและแดชบอร์ดลิ้นชักโฟกัส',
    'LBL_CJ_PROCESSING_REQUEST' => 'กำลังดำเนินการ...',
    'LBL_CJ_SUCCESS' => 'คุณทำทุกงานให้สมบูรณ์สำเร็จแล้ว',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => 'ไม่ได้เปิดใช้งานโมดูล {module}',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'บันทึกการตั้งค่าการแสดงผลทั้งหมดแล้ว',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'คู่มืออัจฉริยะ โมเมนตัม',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'แสดงมาตรวัด Sugar Automate "คู่มืออัจฉริยะ โมเมนตัม"',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide ความคืบหน้า',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'แสดงแผนภูมิวงกลม Sugar Automate "Smart Guide ความคืบหน้า"',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'ไม่พบแบบแม่',
    'CJ_NOT_FOUND_EXCEPTION' => 'ไม่พบ {moduleName} กับ {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'คู่มืออัจฉริยะจะต้องสมบูรณ์หรือยกเลิกก่อนจัดเก็บถาวร',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate ไม่เปิดให้ใช้งานในใบนุญาต Sugar ปัจจุบัน',
    'LBL_ACTION_NOT_FOUND' => 'ไม่พบการกระทำ โปรดติดต่อผู้ดูแลระบบ',
    'LBL_CJ_SELECT_FIELD' => 'เลือกฟิลด์',
    'LBL_CJ_SELECT_OPERATOR' => 'เลือกโอเปอเรเตอร์',
    'LBL_CJ_SELECT_VALUE' => 'เลือกค่า',
    'LBL_CJ_ENTER_VALUE' => 'ป้อนค่า',
    'LBL_CJ_FORM_BATCH_TITLE' => 'กำลังบันทึกระเบียน',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'ตรวจพบ Smart Guides ที่ใช้งานอยู่...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'กำลังประมวลผลการกระทํา Sugar ที่ใช้งานอยู่...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'กำลังอัปเดต Smart Guides ที่ใช้งานอยู่...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'ระเบียนและ Smart Guides ที่เกี่ยวข้องได้รับการอัปเดตเรียบร้อยแล้ว',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'ไม่สามารถอัปเดต Smart Guide ที่เกี่ยวข้องได้ หากยังคงมีข้อผิดพลาดอยู่โปรดติดต่อผู้ดูแลระบบ Sugar ของคุณเพื่อขอความช่วยเหลือ',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'ไม่สามารถอัปเดต Smart Guide ที่เกี่ยวข้องได้ โปรดตรวจสอบ <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">logs</a> เพื่อวินิจฉัยข้อผิดพลาด',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => 'ได้เชื่อมโยง <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} เรียบร้อยแล้ว',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'มีปัญหาในการเชื่อมโยง <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} หากยังคงมีปัญหาอยู่โปรดตรวจสอบฝ่ายสนับสนุนของ Sugar',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => '{{modulePluralLower}} ถูกเชื่อมโยงสำเร็จแล้ว',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'มีปัญหาในการเชื่อมโยง {{modulePluralLower}} หากปัญหายังคงมีอยู่ โปรดติดต่อฝ่ายสนับสนุนของ Sugar',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'มีปัญหาในการเชื่อมโยง {{moduleSingularLower}} หากปัญหายังคงมีอยู่ โปรดติดต่อฝ่ายสนับสนุนของ Sugar',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'มี {{moduleSingularLower}} ชื่อ <a href="#{{module}}/{{id}}">{{name}}</a> ในขั้นตอน {{stage}} อยู่แล้ว',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'ได้เลือก {{moduleSingularLower}} ชื่อ <a href="#{{module}}/{{id}}">{{name}}</a> แล้ว',
    'LBL_CJ_ARCHIVED' => 'เก็บถาวร',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'เลือกเทมเพลต Smart Guide...',
    'LBL_ALL_SMART_GUIDES' => 'Smart Guide ทั้งหมด',
    'LBL_ACTIVE_SMART_GUIDES' => 'Smart Guide ที่ใช้งานอยู่',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Smart Guide ที่จัดเก็บถาวร',
    'LBL_VERTICAL_SCROLL_VIEW' => 'มุมมองแบบซ้อนแนวตั้ง',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'มุมมองแบบเลื่อนแนวนอน',
    'LBL_DRI_WORKFLOWS_FILTER' => 'ตัวกรอง',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'ไม่สามารถดำเนินการกระทำนี้ให้เสร็จสิ้นได้ ฟิลด์สถานะสำหรับโมดูลกิจกรรมนี้ถูกตั้งไว้เป็น "อ่านอย่างเดียว" เพื่อป้องกันการกระทำของ Smart Guide ที่เป็นการอัปเดตฟิลด์สถานะ',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'ไม่สามารถดำเนินการกระทำนี้ให้เสร็จสิ้นได้ ฟิลด์สถานะสำหรับโมดูลกิจกรรมนี้ และ/หรือโมดูลกิจกรรมย่อยถูกตั้งไว้เป็น "อ่านอย่างเดียว" เพื่อป้องกันการกระทำของ Smart Guide ที่เป็นการอัปเดตฟิลด์สถานะ',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'ฟิลด์สถานะสำหรับโมดูลกิจกรรมบางประเภทในคำแนะนำถูกตั้งค่าไว้เป็น "อ่านอย่างเดียว" กิจกรรมเหล่านี้จะไม่เปลี่ยนแปลงในการยกเลิกคำแนะนำ',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'คัดลอกไปยังคลิปบอร์ด',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'ลบรายการที่ทำซ้ำทั้งหมด',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'การตั้งค่าการทำซ้ำไม่ถูกต้อง',
    'ERROR_INTERVAL_INVALID' => 'ช่วงเวลาการทำซ้ำต้องอยู่ระหว่าง 1 ถึง 99',
    'LBL_RECURRENCE_ADD' => 'กำหนดค่า',
    'LBL_REPEAT_DAYS' => 'วันของเดือน',
    'LBL_REPEAT_END_TYPES' => 'ซ้ำ',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'ผู้นำทาง',
    'LBL_MOBILE_PDF_EMAIL' => 'อีเมล PDF {{{pdfTemplateName}}}',
    'LBL_MOBILE_EMAIL_SENDING' => 'กำลังส่ง',
    'LBL_MOBILE_EMAIL_SENT' => 'ส่งแล้ว',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'บันทึกอีเมลเป็นฉบับร่างแล้ว',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'เพิ่มไฟล์แนบ',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'อัปโหลดจากระบบ',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'เอกสาร Sugar',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'การแก้ไขที่คุณทำแก่ระเบียนนี้ได้เปลี่ยนแปลงมุมมอง',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'หมายเหตุการเปิดตัวแอป SugarCRM Mobile',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'คำแนะนำผู้ใช้แอป SugarCRM Mobile',
    'ERR_MOBILE_ROOTED' => 'ไม่สามารถใช้ Sugar Mobile บนอุปกรณ์มือถือที่รูทได้ โปรดเปิดแอปบนอุปกรณ์ที่ไม่ได้รูท',
    'LBL_VO_BUILD_ROUTE' => 'สร้างเส้นทาง',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'ตัวกรองระยะทางของฉัน',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'เอกสารจะถูกสร้างขึ้นในพื้นหลัง โปรดเปิดหน้าการผสานเอกสารเพื่อเข้าถึงไฟล์',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'ไม่สามารถรับเทมเพลต โปรดติดต่อผู้ดูแลระบบของคุณเพื่อขอความช่วยเหลือ',
    'LBL_MAP_ERROR_LOAD' => 'ไม่สามารถโหลดแผนที่ได้',
    'LBL_MAP_DISTANCE' => 'ระยะทาง',
    'LBL_SELECT_UNIT_TYPE' => 'ประเภทหน่วย',
    'LBL_MAPS_UNIT_MILES' => 'ไมล์',
    'LBL_MAPS_UNIT_KILOMETERS' => 'กิโลเมตร',
    'LBL_RADIUS' => 'รัศมี',
    'LBL_ZIP_CODE' => 'รหัสไปรษณีย์',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'เลือกที่อยู่',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'ไม่สามารถเลือกจีโอโค้ดจากที่อยู่:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'ระเบียนไม่ได้ทำจีโอโค้ด',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'ระเบียนไม่มีข้อมูลที่อยู่ คุณต้องการหาตำแหน่งระเบียนนี้ในแผนที่ด้วยตัวเองหรือไม่',
    'LBL_ERR_SHOW_ON_MAP' => 'เปิดแผนที่ในระเบียนที่เลือกล้มเหลว',
    'LBL_ERR_MISSING_ON_MAP' => 'ระเบียนบางรายการไม่มีข้อมูลที่อยู่และไม่ได้แสดงขึ้น',
    'LBL_MAPS_ROUTE' => 'เส้นทาง',
    'LBL_MAPS_PROVIDER' => 'แผนที่ Sugar',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'ไม่สามารถกำหนดตำแหน่งปัจจุบันได้',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'ระเบียนจำนวนสูงสุด {{{num}}} รายการสามารถรองรับการทำแผนที่ได้',
    'LBL_ALL_MODULES' => 'โมดูลทั้งหมด',
    'LBL_DRIVE_SHARE_LINK' => 'แชร์ลิงก์',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'โหลดล้มเหลว',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'ชื่อต้องไม่เว้นว่าง',
    'LBL_DRIVE_FOLDER_CREATED' => 'สร้างโฟลเดอร์แล้ว',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'สร้างโฟลเดอร์ล้มเหลว',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'อัปโหลดไฟล์ล้มเหลว',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'โปรดสร้างแฟ้มเส้นทางก่อน',
    'LBL_EDIT_ALL_RECURRENCES' => 'แก้ไขรายการที่เกิดซ้ำทั้งหมด',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'ไม่สามารถเปิดไฟล์ใน Dropbox ได้',
    'LBL_FILE_NOT_AVAILABLE' => 'ไม่สามารถเปิดไฟล์ได้',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'ทิศทาง',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'ไม่พบเส้นทางสำหรับเวย์พอยต์ที่ให้มา',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'ใกล้เคียง',
    'LBL_TAGS' => 'แท็ก',

    'LBL_CALLER_ID_SETTINGS' => 'การตั้งค่า ID ผู้โทร',
    'LBL_CALLER_ID_ENABLED' => 'เปิดใช้งาน ID ผู้โทร',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'เมื่อมีสายเรียกเข้า ชื่อของผู้ติดต่อหรือลูกค้าเป้าหมายที่ตรงกับหมายเลขโทรศัพท์จะปรากฏขึ้น',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'หากต้องการอนุญาตให้แอปบนอุปกรณ์เคลื่อนที่แสดง ID ผู้โทร ให้ทําตามขั้นตอนต่อไปนี้บนอุปกรณ์ของคุณ<br><br>1. เปิดการตั้งค่า iOS >โทรศัพท์> การบล็อกและการระบุการโทร<br>2. เปิดใช้งาน "{{{brandName}}}"',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'หากต้องการอนุญาตให้แอปบนอุปกรณ์เคลื่อนที่แสดง ID ผู้โทร ให้ทําตามขั้นตอนต่อไปนี้บนอุปกรณ์ของคุณ<br>1. เปิดการตั้งค่าแอป<br>2. ไปที่การอนุญาต<br>3. เปิดใช้งานการอนุญาตโทรศัพท์<br><br> หากต้องการตั้งค่าแอปพลิเคชันนี้เป็นตัวจัดการ ID ผู้โทรในค่าเริ่มต้น ให้ไปที่การตั้งค่าอุปกรณ์ของคุณ<br>1. ไปที่แอป<br>2. เลือกแอปเริ่มต้น<br>3. เลือก ID ผู้โทรและแอปสแปม<br>4. เลือกแอปพลิเคชันนี้เป็นตัวเลือกเริ่มต้น',
    'LBL_CALLER_ID_SYNC_HINT' => 'ตรวจสอบการเปลี่ยนแปลงข้อมูลติดต่อจากระเบียน (เช่น ผู้ติดต่อ ลูกค้าเป้าหมาย) ในอินสแตนซ์ Sugar ของคุณ',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'ไปที่การตั้งค่า',
    'LBL_CALLER_ID_SYNC' => 'ซิงค์ข้อมูลระเบียน',
    'LBL_CALLER_ID_NOT_ENABLED' => 'ID ผู้โทรจะต้องเปิดใช้งานอยู่ในการตั้งค่าระบบก่อนที่จะทำการซิงค์',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'เปิดใช้งาน',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'ทำในการตั้งค่าภายหลัง',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'แอปพลิเคชันนี้รองรับคุณสมบัติ Caller ID<br> เพื่อให้ได้ฟังก์ชันที่เหมาะสมของคุณสมบัตินี้ หลังจากกดปุ่มเปิดใช้งานคุณจะได้รับแจ้งให้อนุญาตสองรายการ<br> เพื่อให้แน่ใจว่าคุณลักษณะ ID ผู้โทรทํางานอย่างถูกต้อง คุณต้องให้สิทธิ์ในการจัดการการโทรและเลือกแอปพลิเคชันนี้เป็นแอปเริ่มต้นของตัวจัดการ ID ผู้โทร<br> หากคุณไม่ให้สิทธิ์ในการจัดการการโทรคุณจะไม่สามารถบันทึกการโทรจากแอปพลิเคชันได้',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'หากต้องการอนุญาตให้แอปบนอุปกรณ์เคลื่อนที่ SugarCRM แสดง ID ผู้โทร ให้ทําตามขั้นตอนต่อไปนี้บนอุปกรณ์ของคุณ<br><br>1. เปิดการตั้งค่า iOS >โทรศัพท์> การบล็อกและการระบุการโทร<br>2. เปิดใช้งานแอป',
    'LBL_MOBILE_LAST_SYNC' => 'ซิงค์ล่าสุด',
    'LBL_CALLER_ID_SYNCING' => 'ซิงค์กับเซิร์ฟเวอร์',
    'LBL_NEVER' => 'ไม่ต้องเลย',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} ไม่สามารถเว้นว่างได้',
    'LBL_ADD_RELATED_RECORD' => '{{{moduleSingular}}} ที่เกี่ยวข้อง',
    'LBL_CALLER_ID_NO_PERMISSION' => 'คุณไม่มีสิทธิ์ที่จําเป็นในการใช้ ID ผู้โทร โปรดติดต่อผู้ดูแลระบบของคุณ',
    'LBL_CALLER_ID_FETCHING' => 'กำลังซิงค์…',
    'LBL_CALLER_ID_FETCH_ALL' => 'ซิงค์ระเบียนทั้งหมดใหม่อีกครั้ง',
    'LBL_CALLER_ID_FETCH_NEW' => 'ตรวจหาการอัปเดตระเบียน',

    'LBL_SORT_BY' => 'เรียงตาม',
    'LBL_PRIMARY_SORT' => 'การจัดเรียงหลัก',
    'LBL_SECONDARY_SORT' => 'การจัดเรียงรอง',
    'LBL_OF' => 'จาก',
    'LBL_TABLE_FREEZE_FIRST' => 'ตรึงแนวคอลัมน์แรก',
    'LBL_TABLE_SETTINGS_TITLE' => 'ตัวเลือกมุมมองคอลัมน์',
    'LBL_TABLE_SETTINGS_NO_COL' => 'ต้องเลือกอย่างน้อยหนึ่งคอลัมน์',
    'LBL_TABLE_TOGGLER_INFO' => 'แสดงหรือซ่อนคอลัมน์แล้วลากไปยังลําดับที่คุณต้องการ',
    'LBL_RUNTIME_FILTERS_TITLE' => 'ตัวกรองแบบรันไทม์',
    'LBL_FILTER_CONDITION' => 'เลือกเงื่อนไข',
    'LBL_FILTER_VALUES' => 'ค่า',
    'LBL_TABLE_EXPAND' => 'ขยายทั้งหมด',
    'LBL_TABLE_COLLAPSE' => 'ยุบทั้งหมด',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'ข้อผิดพลาดของเซิร์ฟเวอร์ ไม่สามารถโหลดตัวกรองรันไทม์ที่เกี่ยวข้อง',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'การสมัครรับข้อมูลแบบพุชโมดูล Pub/Sub',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'การสมัครรับข้อมูลแบบพุชโมดูล Pub/Sub',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'แผง - ด้านบน',
    'panel_bottom' => 'แผง - ด้านล่าง',
    'tab_first' => 'แท็บ - อันดับแรก',
    'tab_last' => 'แท็บ - อันดับสุดท้าย',
];

$app_list_strings['activity_user_options'] = [
    '7' => '7 วันที่ผ่านมา',
    '30' => '30 วันที่ผ่านมา',
    '90' => 'ไตรมาสล่าสุด',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'วันนี้',
    'future' => 'อนาคต',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'ใช่',
    'group' => 'ไม่',
];

$app_list_strings['history_filter_options'] = [
    7 => '7 วันที่ผ่านมา',
    30 => '30 วันที่ผ่านมา',
    90 => 'ไตรมาสล่าสุด',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'ใช่',
    'group' => 'ไม่',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'ใช่',
    'group' => 'ไม่',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'ใช่',
    '0' => 'ไม่',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'ไตรมาสนี้',
    'next' => 'ไตรมาสถัดไป',
    'year' => 'ปีนี้',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'ระเบียนของฉัน',
    'group' => 'จัดกลุ่มระเบียน',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'กระบวนการขายของฉัน',
    'group' => 'กระบวนการขายของทีม',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'ประมาณการของฉัน',
    'group' => 'ประมาณการของทีม',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'โอกาสทางการขาย',
    'RevenueLineItems' => 'บรรทัดรายการโอกาสทางการขายและรายได้',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'วันที่ปิดล่าสุด',
    'earliest' => 'วันที่ปิดแรกสุด',
];

$app_list_strings['moduleList']['Library'] = 'ห้องสมุด';
$app_list_strings['moduleListSingular']['Library'] = 'ห้องสมุด';
$app_list_strings['library_type'] = ['Books' => 'หนังสือ', 'Music' => 'ดนตรี', 'DVD' => 'DVD', 'Magazines' => 'วารสาร'];
$app_list_strings['moduleList']['EmailAddresses'] = 'ที่อยู่อีเมล';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'ที่อยู่อีเมล';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'ร่าง',
    'in-review' => 'ระหว่างตรวจทาน',
    'approved' => 'อนุมัติ',
    'published' => 'เผยแพร่',
    'expired' => 'หมดอายุ',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--การดำเนินการของผู้ดูแลระบบ--',
        'Create New Tag' => 'สร้างแท็กใหม่',
        'Delete Tag' => 'ลบแท็ก',
        'Rename Tag' => 'เปลี่ยนชื่อแท็ก',
        'Move Selected Articles' => 'ย้ายบทความที่เลือก',
        'Apply Tags On Articles' => 'ใช้แท็กกับบทความ',
        'Delete Selected Articles' => 'ลบบทความที่เลือก',
    ];

$app_list_strings['moduleList']['Words'] = 'คำ';
$app_list_strings['moduleListSingular']['Words'] = 'คำ';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'สร้างบทความ';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'อาบูดาบี',
    'ADEN' => 'เอเดน',
    'AFGHANISTAN' => 'อัฟกานิสถาน',
    'ALBANIA' => 'แอลเบเนีย',
    'ALGERIA' => 'แอลจีเรีย',
    'AMERICAN SAMOA' => 'อเมริกันซามัว',
    'ANDORRA' => 'อันดอร์รา',
    'ANGOLA' => 'แองโกลา',
    'ANTARCTICA' => 'แอนตาร์กติกา',
    'ANTIGUA' => 'แอนติกา',
    'ARGENTINA' => 'อาร์เจนตินา',
    'ARMENIA' => 'อาร์เมเนีย',
    'ARUBA' => 'อารูบา',
    'AUSTRALIA' => 'ออสเตรเลีย',
    'AUSTRIA' => 'ออสเตรีย',
    'AZERBAIJAN' => 'อาเซอร์ไบจัน',
    'BAHAMAS' => 'บาฮามาส',
    'BAHRAIN' => 'บาห์เรน',
    'BANGLADESH' => 'บังกลาเทศ',
    'BARBADOS' => 'บาร์เบโดส',
    'BELARUS' => 'เบลารุส',
    'BELGIUM' => 'เบลเยียม',
    'BELIZE' => 'เบลีซ',
    'BENIN' => 'เบนิน',
    'BERMUDA' => 'เบอร์มิวดา',
    'BHUTAN' => 'ภูฏาน',
    'BOLIVIA' => 'โบลิเวีย',
    'BOSNIA' => 'บอสเนีย',
    'BOTSWANA' => 'บอตสวานา',
    'BOUVET ISLAND' => 'เกาะบูเวต์',
    'BRAZIL' => 'บราซิล',
    'BRITISH ANTARCTICA TERRITORY' => 'บริติชแอนตาร์กติกเทร์ริทอรี',
    'BRITISH INDIAN OCEAN TERRITORY' => 'บริติชอินเดียนโอเชียนเทร์ริทอรี',
    'BRITISH VIRGIN ISLANDS' => 'หมู่เกาะบริติชเวอร์จิน',
    'BRITISH WEST INDIES' => 'บริติชอินเดียตะวันตก',
    'BRUNEI' => 'บรูไน',
    'BULGARIA' => 'บัลแกเรีย',
    'BURKINA FASO' => 'บูร์กินาฟาโซ',
    'BURUNDI' => 'บุรุนดี',
    'CAMBODIA' => 'กัมพูชา',
    'CAMEROON' => 'แคเมอรูน',
    'CANADA' => 'แคนาดา',
    'CANAL ZONE' => 'เขตคลอง',
    'CANARY ISLAND' => 'เกาะคานารี',
    'CAPE VERDI ISLANDS' => 'หมู่เกาะเคปเวิร์ด',
    'CAYMAN ISLANDS' => 'หมู่เกาะเคย์แมน',
    'CEVLON' => 'ซีลอน',
    'CHAD' => 'ชาด',
    'CHANNEL ISLAND UK' => 'หมู่เกาะแชนเนล สหราชอาณาจักร',
    'CHILE' => 'ชิลี',
    'CHINA' => 'จีน',
    'CHRISTMAS ISLAND' => 'เกาะคริสต์มาส',
    'COCOS (KEELING) ISLAND' => 'เกาะโคโคส (คีลิง)',
    'COLOMBIA' => 'โคลัมเบีย',
    'COMORO ISLANDS' => 'หมู่เกาะคอโมโรส',
    'CONGO' => 'คองโก',
    'CONGO KINSHASA' => 'คองโกกินชาซา',
    'COOK ISLANDS' => 'หมู่เกาะคุก',
    'COSTA RICA' => 'คอสตาริกา',
    'CROATIA' => 'โครเอเชีย',
    'CUBA' => 'คิวบา',
    'CURACAO' => 'คูราเคา',
    'CYPRUS' => 'ไซปรัส',
    'CZECH REPUBLIC' => 'สาธารณรัฐเช็ก',
    'DAHOMEY' => 'ดาโฮมีย์',
    'DENMARK' => 'เดนมาร์ก',
    'DJIBOUTI' => 'จิบูตี',
    'DOMINICA' => 'โดมินิกา',
    'DOMINICAN REPUBLIC' => 'สาธารณรัฐโดมินิกัน',
    'DUBAI' => 'ดูไบ',
    'ECUADOR' => 'เอกวาดอร์',
    'EGYPT' => 'อียิปต์',
    'EL SALVADOR' => 'เอลซัลวาดอร์',
    'EQUATORIAL GUINEA' => 'อิเควทอเรียลกินี',
    'ESTONIA' => 'เอสโตเนีย',
    'ETHIOPIA' => 'เอธิโอเปีย',
    'FAEROE ISLANDS' => 'หมู่เกาะแฟโร',
    'FALKLAND ISLANDS' => 'หมู่เกาะฟอล์กแลนด์',
    'FIJI' => 'ฟิจิ',
    'FINLAND' => 'ฟินแลนด์',
    'FRANCE' => 'ฝรั่งเศส',
    'FRENCH GUIANA' => 'เฟรนช์เกียนา',
    'FRENCH POLYNESIA' => 'เฟรนช์โปลินีเซีย',
    'GABON' => 'กาบอง',
    'GAMBIA' => 'แกมเบีย',
    'GEORGIA' => 'จอร์เจีย',
    'GERMANY' => 'เยอรมนี',
    'GHANA' => 'กานา',
    'GIBRALTAR' => 'ยิบรอลตาร์',
    'GREECE' => 'กรีซ',
    'GREENLAND' => 'กรีนแลนด์',
    'GUADELOUPE' => 'กวาเดอลูป',
    'GUAM' => 'กวม',
    'GUATEMALA' => 'กัวเตมาลา',
    'GUINEA' => 'กินี',
    'GUYANA' => 'กายอานา',
    'HAITI' => 'เฮติ',
    'HONDURAS' => 'ฮอนดูรัส',
    'HONG KONG' => 'ฮ่องกง',
    'HUNGARY' => 'ฮังการี',
    'ICELAND' => 'ไอซ์แลนด์',
    'IFNI' => 'IFNI',
    'INDIA' => 'อินเดีย',
    'INDONESIA' => 'อินโดนีเซีย',
    'IRAN' => 'อิหร่าน',
    'IRAQ' => 'อิรัก',
    'IRELAND' => 'ไอร์แลนด์',
    'ISRAEL' => 'อิสราเอล',
    'ITALY' => 'อิตาลี',
    'IVORY COAST' => 'ไอวอรีโคสต์',
    'JAMAICA' => 'จาเมกา',
    'JAPAN' => 'ญี่ปุ่น',
    'JORDAN' => 'จอร์แดน',
    'KAZAKHSTAN' => 'คาซัคสถาน',
    'KENYA' => 'เคนยา',
    'KOREA' => 'เกาหลี',
    'KOREA, SOUTH' => 'เกาหลีใต้',
    'KUWAIT' => 'คูเวต',
    'KYRGYZSTAN' => 'คีร์กีซสถาน',
    'LAOS' => 'ลาว',
    'LATVIA' => 'ลัตเวีย',
    'LEBANON' => 'เลบานอน',
    'LEEWARD ISLANDS' => 'หมู่เกาะลีเวิร์ด',
    'LESOTHO' => 'เลโซโท',
    'LIBYA' => 'ลิเบีย',
    'LIECHTENSTEIN' => 'ลิกเตนสไตน์',
    'LITHUANIA' => 'ลิทัวเนีย',
    'LUXEMBOURG' => 'ลักเซมเบิร์ก',
    'MACAO' => 'มาเก๊า',
    'MACEDONIA' => 'มาซิโดเนีย',
    'MADAGASCAR' => 'มาดากัสการ์',
    'MALAWI' => 'มาลาวี',
    'MALAYSIA' => 'มาเลเซีย',
    'MALDIVES' => 'มัลดีฟส์',
    'MALI' => 'มาลี',
    'MALTA' => 'มอลตา',
    'MARTINIQUE' => 'มาร์ตินีก',
    'MAURITANIA' => 'มอริเตเนีย',
    'MAURITIUS' => 'มอริเชียส',
    'MELANESIA' => 'เมลานีเซีย',
    'MEXICO' => 'เม็กซิโก',
    'MOLDOVIA' => 'มอลโดวา',
    'MONACO' => 'โมนาโก',
    'MONGOLIA' => 'มองโกเลีย',
    'MOROCCO' => 'โมร็อกโก',
    'MOZAMBIQUE' => 'โมซัมบิก',
    'MYANAMAR' => 'พม่า',
    'NAMIBIA' => 'นามิเบีย',
    'NEPAL' => 'เนปาล',
    'NETHERLANDS' => 'เนเธอร์แลนด์',
    'NETHERLANDS ANTILLES' => 'เนเธอร์แลนด์แอนทิลลิส',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'เขตเป็นกลางของเนเธอร์แลนด์แอนทิลลิส',
    'NEW CALADONIA' => 'นิวแคลิโดเนีย',
    'NEW HEBRIDES' => 'นิวเฮบริดีส์',
    'NEW ZEALAND' => 'นิวซีแลนด์',
    'NICARAGUA' => 'นิการากัว',
    'NIGER' => 'ไนเจอร์',
    'NIGERIA' => 'ไนจีเรีย',
    'NORFOLK ISLAND' => 'เกาะนอร์ฟอล์ก',
    'NORWAY' => 'นอร์เวย์',
    'OMAN' => 'โอมาน',
    'OTHER' => 'อื่นๆ',
    'PACIFIC ISLAND' => 'หมู่เกาะแปซิฟิก',
    'PAKISTAN' => 'ปากีสถาน',
    'PANAMA' => 'ปานามา',
    'PAPUA NEW GUINEA' => 'ปาปัวนิวกินี',
    'PARAGUAY' => 'ปารากวัย',
    'PERU' => 'เปรู',
    'PHILIPPINES' => 'ฟิลิปปินส์',
    'POLAND' => 'โปแลนด์',
    'PORTUGAL' => 'โปรตุเกส',
    'PORTUGUESE TIMOR' => 'ติมอร์โปรตุเกส',
    'PUERTO RICO' => 'เปอร์โตริโก',
    'QATAR' => 'กาตาร์',
    'REPUBLIC OF BELARUS' => 'สาธารณรัฐเบลารุส',
    'REPUBLIC OF SOUTH AFRICA' => 'สาธารณรัฐแอฟริกาใต้',
    'REUNION' => 'เรอูนียง',
    'ROMANIA' => 'โรมาเนีย',
    'RUSSIA' => 'รัสเซีย',
    'RWANDA' => 'รวันดา',
    'RYUKYU ISLANDS' => 'หมู่เกาะริวกิว',
    'SABAH' => 'ซาบาห์',
    'SAN MARINO' => 'ซานมาริโน',
    'SAUDI ARABIA' => 'ซาอุดีอาระเบีย',
    'SENEGAL' => 'เซเนกัล',
    'SERBIA' => 'เซอร์เบีย',
    'SEYCHELLES' => 'เซเชลส์',
    'SIERRA LEONE' => 'เซียร์ราลีโอน',
    'SINGAPORE' => 'สิงคโปร์',
    'SLOVAKIA' => 'สโลวะเกีย',
    'SLOVENIA' => 'สโลวีเนีย',
    'SOMALILIAND' => 'โซมาเลีย',
    'SOUTH AFRICA' => 'แอฟริกาใต้',
    'SOUTH YEMEN' => 'เยเมนใต้',
    'SPAIN' => 'สเปน',
    'SPANISH SAHARA' => 'สแปนิชสะฮารา',
    'SRI LANKA' => 'ศรีลังกา',
    'ST. KITTS AND NEVIS' => 'เซนต์คิตส์และเนวิส',
    'ST. LUCIA' => 'เซนต์ลูเซีย',
    'SUDAN' => 'ซูดาน',
    'SURINAM' => 'ซูรินาเม',
    'SW AFRICA' => 'แอฟริกาตะวันตกเฉียงใต้',
    'SWAZILAND' => 'สวาซิแลนด์',
    'SWEDEN' => 'สวีเดน',
    'SWITZERLAND' => 'สวิตเซอร์แลนด์',
    'SYRIA' => 'ซีเรีย',
    'TAIWAN' => 'ไต้หวัน',
    'TAJIKISTAN' => 'ทาจิกิสถาน',
    'TANZANIA' => 'แทนซาเนีย',
    'THAILAND' => 'ไทย',
    'TONGA' => 'ตองกา',
    'TRINIDAD' => 'ตรินิแดด',
    'TUNISIA' => 'ตูนิเซีย',
    'TURKEY' => 'ตุรกี',
    'UGANDA' => 'ยูกันดา',
    'UKRAINE' => 'ยูเครน',
    'UNITED ARAB EMIRATES' => 'สหรัฐอาหรับเอมิเรตส์',
    'UNITED KINGDOM' => 'สหราชอาณาจักร',
    'UPPER VOLTA' => 'วอลตาตอนบน',
    'URUGUAY' => 'อุรุกวัย',
    'US PACIFIC ISLAND' => 'หมู่เกาะแปซิฟิกของสหรัฐอเมริกา',
    'US VIRGIN ISLANDS' => 'หมู่เกาะเวอร์จินของสหรัฐอเมริกา',
    'USA' => 'สหรัฐอเมริกา',
    'UZBEKISTAN' => 'อุซเบกิสถาน',
    'VANUATU' => 'วานูอาตู',
    'VATICAN CITY' => 'นครรัฐวาติกัน',
    'VENEZUELA' => 'เวเนซุเอลา',
    'VIETNAM' => 'เวียดนาม',
    'WAKE ISLAND' => 'เกาะเวก',
    'WEST INDIES' => 'อินเดียตะวันตก',
    'WESTERN SAHARA' => 'สะฮาราตะวันตก',
    'YEMEN' => 'เยเมน',
    'ZAIRE' => 'ซาอีร์',
    'ZAMBIA' => 'แซมเบีย',
    'ZIMBABWE' => 'ซิมบับเว',
];

$app_list_strings['state_dom'] = [
    'AL' => 'แอละแบมา',
    'AK' => 'อะแลสกา',
    'AZ' => 'แอริโซนา',
    'AR' => 'อาร์คันซอ',
    'CA' => 'แคลิฟอร์เนีย',
    'CO' => 'โคโลราโด',
    'CT' => 'คอนเน็คติคัต',
    'DE' => 'เดลาแวร์',
    'DC' => 'ดิสตริกต์ออฟโคลัมเบีย',
    'FL' => 'ฟลอริดา',
    'GA' => 'จอร์เจีย',
    'HI' => 'ฮาวาย',
    'ID' => 'ไอดาโฮ',
    'IL' => 'อิลลินอยส์',
    'IN' => 'อินดิแอนา',
    'IA' => 'ไอโอวา',
    'KS' => 'แคนซัส',
    'KY' => 'เคนทักกี',
    'LA' => 'ลุยเซียนา',
    'ME' => 'เมน',
    'MD' => 'แมรีแลนด์',
    'MA' => 'แมสซาชูเสตส์',
    'MI' => 'มิชิแกน',
    'MN' => 'มินนิโซตา',
    'MS' => 'มิสซิสซิปปี',
    'MO' => 'มิสซูรี',
    'MT' => 'มอนแทนา',
    'NE' => 'เนบราสกา',
    'NV' => 'เนวาดา',
    'NH' => 'นิวแฮมป์เชียร์',
    'NJ' => 'นิวเจอร์ซีย์',
    'NM' => 'นิวเม็กซิโก',
    'NY' => 'นิวยอร์ก',
    'NC' => 'นอร์ทแคโรไลนา',
    'ND' => 'นอร์ทดาโกตา',
    'OH' => 'โอไฮโอ',
    'OK' => 'โอคลาโฮมา',
    'OR' => 'ออริกอน',
    'PA' => 'เพนซิลเวเนีย',
    'RI' => 'โรดไอส์แลนด์',
    'SC' => 'เซาท์แคโรไลนา',
    'SD' => 'เซาท์ดาโกตา',
    'TN' => 'เทนเนสซี',
    'TX' => 'เท็กซัส',
    'UT' => 'ยูทาห์',
    'VT' => 'เวอร์มอนท์',
    'VA' => 'เวอร์จิเนีย ',
    'WA' => 'วอชิงตัน',
    'WV' => 'เวสต์เวอร์จิเนีย',
    'WI' => 'วิสคอนซิน',
    'WY' => 'ไวโอมิง',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (ไต้หวันและฮ่องกง)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS ซิริลลิก)',
    'CP1252' => 'CP1252 (MS ยุโรปตะวันตกและสหรัฐอเมริกา)',
    'EUC-CN' => 'EUC-CN (จีนประยุกต์ GB2312)',
    'EUC-JP' => 'EUC-JP (Unix ญี่ปุ่น)',
    'EUC-KR' => 'EUC-KR (เกาหลี)',
    'EUC-TW' => 'EUC-TW (ไต้หวัน)',
    'ISO-2022-JP' => 'ISO-2022-JP (ญี่ปุ่น)',
    'ISO-2022-KR' => 'ISO-2022-KR (เกาหลี)',
    'ISO-8859-1' => 'ISO-8859-1 (ยุโรปตะวันตกและสหรัฐอเมริกา)',
    'ISO-8859-2' => 'ISO-8859-2 (ยุโรปกลางและตะวันออก)',
    'ISO-8859-3' => 'ISO-8859-3 (ละติน 3)',
    'ISO-8859-4' => 'ISO-8859-4 (ละติน 4)',
    'ISO-8859-5' => 'ISO-8859-5 (ซิริลลิก)',
    'ISO-8859-6' => 'ISO-8859-6 (อาหรับ)',
    'ISO-8859-7' => 'ISO-8859-7 (กรีก)',
    'ISO-8859-8' => 'ISO-8859-8 (ฮีบรู)',
    'ISO-8859-9' => 'ISO-8859-9 (ละติน 5)',
    'ISO-8859-10' => 'ISO-8859-10 (ละติน 6)',
    'ISO-8859-13' => 'ISO-8859-13 (ละติน 7)',
    'ISO-8859-14' => 'ISO-8859-14 (ละติน 8)',
    'ISO-8859-15' => 'ISO-8859-15 (ละติน 9)',
    'KOI8-R' => 'KOI8-R (ซิริลลิกรัสเซีย)',
    'KOI8-U' => 'KOI8-U (ซิริลลิกยูเครน)',
    'SJIS' => 'SJIS (MS ญี่ปุ่น)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'แอฟริกา/แอลเจียร์',
    'Africa/Luanda' => 'แอฟริกา/Luanda',
    'Africa/Porto-Novo' => 'แอฟริกา/Porto-Novo',
    'Africa/Gaborone' => 'แอฟริกา/Gaborone',
    'Africa/Ouagadougou' => 'แอฟริกา/Ouagadougou',
    'Africa/Bujumbura' => 'แอฟริกา/Bujumbura',
    'Africa/Douala' => 'แอฟริกา/Douala',
    'Atlantic/Cape_Verde' => 'แอตแลนติก/Cape_Verde',
    'Africa/Bangui' => 'แอฟริกา/Bangui',
    'Africa/Ndjamena' => 'แอฟริกา/Ndjamena',
    'Indian/Comoro' => 'อินเดีย/Comoro',
    'Africa/Kinshasa' => 'แอฟริกา/Kinshasa',
    'Africa/Lubumbashi' => 'แอฟริกา/Lubumbashi',
    'Africa/Brazzaville' => 'แอฟริกา/Brazzaville',
    'Africa/Abidjan' => 'แอฟริกา/Abidjan',
    'Africa/Djibouti' => 'แอฟริกา/จิบูตี',
    'Africa/Cairo' => 'แอฟริกา/ไคโร',
    'Africa/Malabo' => 'แอฟริกา/Malabo',
    'Africa/Asmera' => 'แอฟริกา/Asmera',
    'Africa/Addis_Ababa' => 'แอฟริกา/Addis_Ababa',
    'Africa/Libreville' => 'แอฟริกา/Libreville',
    'Africa/Banjul' => 'แอฟริกา/Banjul',
    'Africa/Accra' => 'แอฟริกา/อักกรา',
    'Africa/Conakry' => 'แอฟริกา/Conakry',
    'Africa/Bissau' => 'แอฟริกา/บิสเซา',
    'Africa/Nairobi' => 'แอฟริกา/ไนโรบี',
    'Africa/Maseru' => 'แอฟริกา/Maseru',
    'Africa/Monrovia' => 'แอฟริกา/Monrovia',
    'Africa/Tripoli' => 'แอฟริกา/ตริโปลี',
    'Indian/Antananarivo' => 'อินเดีย/Antananarivo',
    'Africa/Blantyre' => 'แอฟริกา/Blantyre',
    'Africa/Bamako' => 'แอฟริกา/Bamako',
    'Africa/Nouakchott' => 'แอฟริกา/Nouakchott',
    'Indian/Mauritius' => 'อินเดีย/มอริเชียส',
    'Indian/Mayotte' => 'อินเดีย/มายอต',
    'Africa/Casablanca' => 'แอฟริกา/คาซาบลังกา',
    'Africa/El_Aaiun' => 'แอฟริกา/El_Aaiun',
    'Africa/Maputo' => 'แอฟริกา/Maputo',
    'Africa/Windhoek' => 'แอฟริกา/วินด์ฮุก',
    'Africa/Niamey' => 'แอฟริกา/Niamey',
    'Africa/Lagos' => 'แอฟริกา/Lagos',
    'Indian/Reunion' => 'อินเดีย/เรอูนียง',
    'Africa/Kigali' => 'แอฟริกา/Kigali',
    'Atlantic/St_Helena' => 'แอตแลนติก/เซนต์เฮเลนา',
    'Africa/Sao_Tome' => 'แอฟริกา/เซาตูเม',
    'Africa/Dakar' => 'แอฟริกา/ดาการ์',
    'Indian/Mahe' => 'อินเดีย/Mahe',
    'Africa/Freetown' => 'แอฟริกา/ฟรีทาวน์',
    'Africa/Mogadishu' => 'แอฟริกา/Mogadishu',
    'Africa/Johannesburg' => 'แอฟริกา/โจฮันเนสเบิร์ก',
    'Africa/Khartoum' => 'แอฟริกา/Khartoum',
    'Africa/Mbabane' => 'แอฟริกา/Mbabane',
    'Africa/Dar_es_Salaam' => 'แอฟริกา/Dar_es_Salaam',
    'Africa/Lome' => 'แอฟริกา/Lome',
    'Africa/Tunis' => 'แอฟริกา/Tunis',
    'Africa/Kampala' => 'แอฟริกา/Kampala',
    'Africa/Lusaka' => 'แอฟริกา/Lusaka',
    'Africa/Harare' => 'แอฟริกา/Harare',
    'Antarctica/Casey' => 'แอนตาร์กติกา/Casey',
    'Antarctica/Davis' => 'แอนตาร์กติกา/Davis',
    'Antarctica/Mawson' => 'แอนตาร์กติกา/Mawson',
    'Indian/Kerguelen' => 'อินเดีย/Kerguelen',
    'Antarctica/DumontDUrville' => 'แอนตาร์กติกา/DumontDUrville',
    'Antarctica/Syowa' => 'แอนตาร์กติกา/Syowa',
    'Antarctica/Vostok' => 'แอนตาร์กติกา/Vostok',
    'Antarctica/Rothera' => 'แอนตาร์กติกา/Rothera',
    'Antarctica/Palmer' => 'แอนตาร์กติกา/Palmer',
    'Antarctica/McMurdo' => 'แอนตาร์กติกา/McMurdo',
    'Asia/Kabul' => 'เอเชีย/Kabul',
    'Asia/Yerevan' => 'เอเชีย/เยเรวาน',
    'Asia/Baku' => 'เอเชีย/บากู',
    'Asia/Bahrain' => 'เอเชีย/บาห์เรน',
    'Asia/Dhaka' => 'เอเชีย/ธากา',
    'Asia/Thimphu' => 'เอเชีย/ทิมพู',
    'Indian/Chagos' => 'อินเดีย/Chagos',
    'Asia/Brunei' => 'เอเชีย/บรูไน',
    'Asia/Rangoon' => 'เอเชีย/ย่างกุ้ง',
    'Asia/Phnom_Penh' => 'เอเชีย/พนมเปญ',
    'Asia/Beijing' => 'เอเชีย/ปักกิ่ง',
    'Asia/Harbin' => 'เอเชีย/ฮาร์บิน',
    'Asia/Shanghai' => 'เอเชีย/เซี่ยงไฮ้',
    'Asia/Chongqing' => 'เอเชีย/ฉงชิ่ง',
    'Asia/Urumqi' => 'เอเชีย/อุรุมชี',
    'Asia/Kashgar' => 'เอเชีย/แคชการ์',
    'Asia/Hong_Kong' => 'เอเชีย/ฮ่องกง',
    'Asia/Taipei' => 'เอเชีย/ไทเป',
    'Asia/Macau' => 'เอเชีย/มาเก๊า',
    'Asia/Nicosia' => 'เอเชีย/นิโคเซีย',
    'Asia/Tbilisi' => 'เอเชีย/ทบิลิซิ',
    'Asia/Dili' => 'เอเชีย/ดิลี',
    'Asia/Calcutta' => 'เอเชีย/กัลกัตตา',
    'Asia/Jakarta' => 'เอเชีย/จาการ์ตา',
    'Asia/Pontianak' => 'เอเชีย/ปอนติอานัค',
    'Asia/Makassar' => 'เอเชีย/มาคาสซาร์',
    'Asia/Jayapura' => 'เอเชีย/ชัยปุระ',
    'Asia/Tehran' => 'เอเชีย/เตหะราน',
    'Asia/Baghdad' => 'เอเชีย/แบกแดด',
    'Asia/Jerusalem' => 'เอเชีย/เยรูซาเล็ม',
    'Asia/Tokyo' => 'เอเชีย/โตเกียว',
    'Asia/Amman' => 'เอเชีย/อัมมาน',
    'Asia/Almaty' => 'เอเชีย/อัลมาตี',
    'Asia/Qyzylorda' => 'เอเชีย/Qyzylorda',
    'Asia/Aqtobe' => 'เอเชีย/Aqtobe',
    'Asia/Aqtau' => 'เอเชีย/Aqtau',
    'Asia/Oral' => 'เอเชีย/Oral',
    'Asia/Bishkek' => 'เอเชีย/Bishkek',
    'Asia/Seoul' => 'เอเชีย/โซล',
    'Asia/Pyongyang' => 'เอเชีย/เปียงยาง',
    'Asia/Kuwait' => 'เอเชีย/คูเวต',
    'Asia/Vientiane' => 'เอเชีย/เวียงจันทน์',
    'Asia/Beirut' => 'เอเชีย/เบรุต',
    'Asia/Kuala_Lumpur' => 'เอเชีย/กัวลาลัมเปอร์',
    'Asia/Kuching' => 'เอเชีย/กูชิง',
    'Indian/Maldives' => 'อินเดีย/มัลดีฟส์',
    'Asia/Hovd' => 'เอเชีย/Hovd',
    'Asia/Ulaanbaatar' => 'เอเชีย/อูลานบาตอร์',
    'Asia/Choibalsan' => 'เอเชีย/Choibalsan',
    'Asia/Katmandu' => 'เอเชีย/กาฐมาณฑุ',
    'Asia/Muscat' => 'เอเชีย/มัสกัต',
    'Asia/Karachi' => 'เอเชีย/การาจี',
    'Asia/Gaza' => 'เอเชีย/กาซา',
    'Asia/Manila' => 'เอเชีย/มะนิลา',
    'Asia/Qatar' => 'เอเชีย/กาตาร์',
    'Asia/Riyadh' => 'เอเชีย/ริยาดห์',
    'Asia/Singapore' => 'เอเชีย/สิงคโปร์',
    'Asia/Colombo' => 'เอเชีย/โคลัมโบ',
    'Asia/Damascus' => 'เอเชีย/ดามัสกัส',
    'Asia/Dushanbe' => 'เอเชีย/ดูชานเบ',
    'Asia/Bangkok' => 'เอเชีย/กรุงเทพฯ',
    'Asia/Ashgabat' => 'เอเชีย/อาชกาบัต',
    'Asia/Dubai' => 'เอเชีย/ดูไบ',
    'Asia/Samarkand' => 'เอเชีย/ซามาร์คานด์',
    'Asia/Tashkent' => 'เอเชีย/ทาชเคนต์',
    'Asia/Saigon' => 'เอเชีย/ไซ่ง่อน',
    'Asia/Aden' => 'เอเชีย/เอเดน',
    'Australia/Darwin' => 'ออสเตรเลีย/ดาร์วิน',
    'Australia/Perth' => 'ออสเตรเลีย/เพิร์ท',
    'Australia/Brisbane' => 'ออสเตรเลีย/บริสเบน',
    'Australia/Lindeman' => 'ออสเตรเลีย/Lindeman',
    'Australia/Adelaide' => 'ออสเตรเลีย/แอดิเลด',
    'Australia/Hobart' => 'ออสเตรเลีย/โฮบาร์ต',
    'Australia/Currie' => 'ออสเตรเลีย/Currie',
    'Australia/Melbourne' => 'ออสเตรเลีย/เมลเบิร์น',
    'Australia/Sydney' => 'ออสเตรเลีย/ซิดนีย์',
    'Australia/Broken_Hill' => 'ออสเตรเลีย/Broken_Hill',
    'Indian/Christmas' => 'อินเดีย/คริสต์มาส',
    'Pacific/Rarotonga' => 'แปซิฟิก/Rarotonga',
    'Indian/Cocos' => 'อินเดีย/Cocos',
    'Pacific/Fiji' => 'แปซิฟิก/ฟิจิ',
    'Pacific/Gambier' => 'แปซิฟิก/แกมเบียร์',
    'Pacific/Marquesas' => 'แปซิฟิก/มาร์เคซัส',
    'Pacific/Tahiti' => 'แปซิฟิก/ตาฮิติ',
    'Pacific/Guam' => 'แปซิฟิก/กวม',
    'Pacific/Tarawa' => 'แปซิฟิก/ตาระวา',
    'Pacific/Enderbury' => 'แปซิฟิก/Enderbury',
    'Pacific/Kiritimati' => 'แปซิฟิก/Kiritimati',
    'Pacific/Saipan' => 'แปซิฟิก/ไซปัน',
    'Pacific/Majuro' => 'แปซิฟิก/มาจูโร',
    'Pacific/Kwajalein' => 'แปซิฟิก/Kwajalein',
    'Pacific/Truk' => 'แปซิฟิก/Truk',
    'Pacific/Ponape' => 'แปซิฟิก/Ponape',
    'Pacific/Kosrae' => 'แปซิฟิก/Kosrae',
    'Pacific/Nauru' => 'แปซิฟิก/นาอูรู',
    'Pacific/Noumea' => 'แปซิฟิก/Noumea',
    'Pacific/Auckland' => 'แปซิฟิก/โอ๊คแลนด์',
    'Pacific/Chatham' => 'แปซิฟิก/Chatham',
    'Pacific/Niue' => 'แปซิฟิก/นีอูเอ',
    'Pacific/Norfolk' => 'แปซิฟิก/นอร์ฟอล์ก',
    'Pacific/Palau' => 'แปซิฟิก/ปาเลา',
    'Pacific/Port_Moresby' => 'แปซิฟิก/พอร์ตมอร์สบี',
    'Pacific/Pitcairn' => 'แปซิฟิก/พิตแคร์น',
    'Pacific/Pago_Pago' => 'แปซิฟิก/ปาโกปาโก',
    'Pacific/Apia' => 'แปซิฟิก/อาปีอา',
    'Pacific/Guadalcanal' => 'แปซิฟิก/Guadalcanal',
    'Pacific/Fakaofo' => 'แปซิฟิก/Fakaofo',
    'Pacific/Tongatapu' => 'แปซิฟิก/Tongatapu',
    'Pacific/Funafuti' => 'แปซิฟิก/ฟูนะฟูตี',
    'Pacific/Johnston' => 'แปซิฟิก/จอห์นสตัน',
    'Pacific/Midway' => 'แปซิฟิก/มิดเวย์',
    'Pacific/Wake' => 'แปซิฟิก/เวก',
    'Pacific/Efate' => 'แปซิฟิก/Efate',
    'Pacific/Wallis' => 'แปซิฟิก/วอลลิส',
    'Europe/London' => 'ยุโรป/ลอนดอน',
    'Europe/Dublin' => 'ยุโรป/ดับลิน',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'ยุโรป/Tirane',
    'Europe/Andorra' => 'ยุโรป/อันดอร์รา',
    'Europe/Vienna' => 'ยุโรป/เวียนนา',
    'Europe/Minsk' => 'ยุโรป/มินสก์',
    'Europe/Brussels' => 'ยุโรป/บรัสเซลส์',
    'Europe/Sofia' => 'ยุโรป/โซเฟีย',
    'Europe/Prague' => 'ยุโรป/ปราก',
    'Europe/Copenhagen' => 'ยุโรป/โคเปนเฮเกน',
    'Atlantic/Faeroe' => 'แอตแลนติก/แฟโร',
    'America/Danmarkshavn' => 'อเมริกา/Danmarkshavn',
    'America/Scoresbysund' => 'อเมริกา/Scoresbysund',
    'America/Godthab' => 'อเมริกา/Godthab',
    'America/Thule' => 'อเมริกา/Thule',
    'Europe/Tallinn' => 'ยุโรป/ทาลลินน์',
    'Europe/Helsinki' => 'ยุโรป/เฮลซิงกิ',
    'Europe/Paris' => 'ยุโรป/ปารีส',
    'Europe/Berlin' => 'ยุโรป/เบอร์ลิน',
    'Europe/Gibraltar' => 'ยุโรป/ยิบรอลตาร์',
    'Europe/Athens' => 'ยุโรป/เอเธนส์',
    'Europe/Budapest' => 'ยุโรป/บูดาเปสต์',
    'Atlantic/Reykjavik' => 'แอตแลนติก/เรคยาวิก',
    'Europe/Rome' => 'ยุโรป/โรม',
    'Europe/Riga' => 'ยุโรป/ริกา',
    'Europe/Vaduz' => 'ยุโรป/วาดุซ',
    'Europe/Vilnius' => 'ยุโรป/วิลนีอุส',
    'Europe/Luxembourg' => 'ยุโรป/ลักเซมเบิร์ก',
    'Europe/Malta' => 'ยุโรป/มอลตา',
    'Europe/Chisinau' => 'ยุโรป/คีซีเนา',
    'Europe/Monaco' => 'ยุโรป/โมนาโก',
    'Europe/Amsterdam' => 'ยุโรป/อัมสเตอร์ดัม',
    'Europe/Oslo' => 'ยุโรป/ออสโล',
    'Europe/Warsaw' => 'ยุโรป/วอร์ซอ',
    'Europe/Lisbon' => 'ยุโรป/ลิสบอน',
    'Atlantic/Azores' => 'แอตแลนติก/อะโซร์ส',
    'Atlantic/Madeira' => 'แอตแลนติก/มาเดรา',
    'Europe/Bucharest' => 'ยุโรป/บูคาเรสต์',
    'Europe/Kaliningrad' => 'ยุโรป/คาลินินกราด',
    'Europe/Moscow' => 'ยุโรป/มอสโก',
    'Europe/Samara' => 'ยุโรป/ซามารา',
    'Asia/Yekaterinburg' => 'เอเชีย/Yekaterinburg',
    'Asia/Omsk' => 'เอเชีย/Omsk',
    'Asia/Novosibirsk' => 'เอเชีย/Novosibirsk',
    'Asia/Krasnoyarsk' => 'เอเชีย/Krasnoyarsk',
    'Asia/Irkutsk' => 'เอเชีย/Irkutsk',
    'Asia/Yakutsk' => 'เอเชีย/ยาคุตสค์',
    'Asia/Vladivostok' => 'เอเชีย/วลาดิวอสต็อค',
    'Asia/Sakhalin' => 'เอเชีย/Sakhalin',
    'Asia/Magadan' => 'เอเชีย/Magadan',
    'Asia/Kamchatka' => 'เอเชีย/Kamchatka',
    'Asia/Anadyr' => 'เอเชีย/Anadyr',
    'Europe/Belgrade' => 'ยุโรป/เบลเกรด',
    'Europe/Madrid' => 'ยุโรป/มาดริด',
    'Africa/Ceuta' => 'แอฟริกา/เซวตา',
    'Atlantic/Canary' => 'แอตแลนติก/คานารี',
    'Europe/Stockholm' => 'ยุโรป/สตอกโฮล์ม',
    'Europe/Zurich' => 'ยุโรป/ซูริค',
    'Europe/Istanbul' => 'ยุโรป/อิสตันบูล',
    'Europe/Kiev' => 'ยุโรป/เคียฟ',
    'Europe/Uzhgorod' => 'ยุโรป/Uzhgorod',
    'Europe/Zaporozhye' => 'ยุโรป/Zaporozhye',
    'Europe/Simferopol' => 'ยุโรป/Simferopol',
    'America/New_York' => 'อเมริกา/นิวยอร์ก',
    'America/Chicago' => 'อเมริกา/ชิคาโก',
    'America/North_Dakota/Center' => 'อเมริกา/นอร์ทดาโกตา/ส่วนกลาง',
    'America/Denver' => 'อเมริกา/เดนเวอร์',
    'America/Los_Angeles' => 'อเมริกา/ลอสแองเจลิส',
    'America/Juneau' => 'อเมริกา/จูโน',
    'America/Yakutat' => 'อเมริกา/Yakutat',
    'America/Anchorage' => 'อเมริกา/แองเคอเรจ',
    'America/Nome' => 'อเมริกา/โนม',
    'America/Adak' => 'อเมริกา/Adak',
    'Pacific/Honolulu' => 'แปซิฟิก/โฮโนลูลู',
    'America/Phoenix' => 'อเมริกา/ฟินิกซ์',
    'America/Boise' => 'อเมริกา/บอยซี',
    'America/Indiana/Indianapolis' => 'อเมริกา/อินดีแอนา/อินเดียแนโพลิส',
    'America/Indiana/Marengo' => 'อเมริกา/อินดีแอนา/Marengo',
    'America/Indiana/Knox' => 'อเมริกา/อินดีแอนา/น็อกซ์',
    'America/Indiana/Vevay' => 'อเมริกา/อินดีแอนา/Vevay',
    'America/Kentucky/Louisville' => 'อเมริกา/เคนทักกี/หลุยส์วิลล์',
    'America/Kentucky/Monticello' => 'อเมริกา/เคนทักกี/Monticello',
    'America/Detroit' => 'อเมริกา/ดีทรอยต์',
    'America/Menominee' => 'อเมริกา/Menominee',
    'America/St_Johns' => 'อเมริกา/เซนต์จอห์นส์',
    'America/Goose_Bay' => 'อเมริกา/กูซเบย์',
    'America/Halifax' => 'อเมริกา/แฮลิแฟกซ์',
    'America/Glace_Bay' => 'อเมริกา/เกลซเบย์',
    'America/Montreal' => 'อเมริกา/มอนทรีอัล',
    'America/Toronto' => 'อเมริกา/โทรอนโต',
    'America/Thunder_Bay' => 'อเมริกา/ธันเดอร์เบย์',
    'America/Nipigon' => 'อเมริกา/Nipigon',
    'America/Rainy_River' => 'อเมริกา/Rainy_River',
    'America/Winnipeg' => 'อเมริกา/วินนิเพก',
    'America/Regina' => 'อเมริกา/ริไจนา',
    'America/Swift_Current' => 'อเมริกา/Swift_Current',
    'America/Edmonton' => 'อเมริกา/เอดมันตัน',
    'America/Vancouver' => 'อเมริกา/แวนคูเวอร์',
    'America/Dawson_Creek' => 'อเมริกา/Dawson_Creek',
    'America/Pangnirtung' => 'อเมริกา/Pangnirtung',
    'America/Iqaluit' => 'อเมริกา/Iqaluit',
    'America/Coral_Harbour' => 'อเมริกา/Coral_Harbour',
    'America/Rankin_Inlet' => 'อเมริกา/Rankin_Inlet',
    'America/Cambridge_Bay' => 'อเมริกา/Cambridge_Bay',
    'America/Yellowknife' => 'อเมริกา/Yellowknife',
    'America/Inuvik' => 'อเมริกา/Inuvik',
    'America/Whitehorse' => 'อเมริกา/Whitehorse',
    'America/Dawson' => 'อเมริกา/Dawson',
    'America/Cancun' => 'อเมริกา/แคนคูน',
    'America/Merida' => 'อเมริกา/Merida',
    'America/Monterrey' => 'อเมริกา/มอนเทอร์เรย์',
    'America/Mexico_City' => 'อเมริกา/เม็กซิโกซิตี',
    'America/Chihuahua' => 'อเมริกา/ชิวาวา',
    'America/Hermosillo' => 'อเมริกา/เอร์โมซีโย',
    'America/Mazatlan' => 'อเมริกา/Mazatlan',
    'America/Tijuana' => 'อเมริกา/ติฮัวนา',
    'America/Anguilla' => 'อเมริกา/แองกวิลลา',
    'America/Antigua' => 'อเมริกา/แอนติกา',
    'America/Nassau' => 'อเมริกา/แนสซอ',
    'America/Barbados' => 'อเมริกา/บาร์เบโดส',
    'America/Belize' => 'อเมริกา/เบลีซ',
    'Atlantic/Bermuda' => 'แอตแลนติก/เบอร์มิวดา',
    'America/Cayman' => 'อเมริกา/เคย์แมน',
    'America/Costa_Rica' => 'อเมริกา/คอสตาริกา',
    'America/Havana' => 'อเมริกา/ฮาวานา',
    'America/Dominica' => 'อเมริกา/โดมินิกา',
    'America/Santo_Domingo' => 'อเมริกา/ซานโตโดมิงโก',
    'America/El_Salvador' => 'อเมริกา/เอลซัลวาดอร์',
    'America/Grenada' => 'อเมริกา/เกรเนดา',
    'America/Guadeloupe' => 'อเมริกา/กวาเดอลูป',
    'America/Guatemala' => 'อเมริกา/กัวเตมาลา',
    'America/Port-au-Prince' => 'อเมริกา/ปอร์โตแปรงซ์',
    'America/Tegucigalpa' => 'อเมริกา/เตกูซิกัลปา',
    'America/Jamaica' => 'อเมริกา/จาเมกา',
    'America/Martinique' => 'อเมริกา/มาร์ตินีก',
    'America/Montserrat' => 'อเมริกา/มอนต์เซอร์รัต',
    'America/Managua' => 'อเมริกา/มานากัว',
    'America/Panama' => 'อเมริกา/ปานามา',
    'America/Puerto_Rico' => 'อเมริกา/เปอร์โตริโก',
    'America/St_Kitts' => 'อเมริกา/เซนต์คิตส์',
    'America/St_Lucia' => 'อเมริกา/เซนต์ลูเซีย',
    'America/Miquelon' => 'อเมริกา/มีเกอลง',
    'America/St_Vincent' => 'อเมริกา/เซนต์วินเซนต์',
    'America/Grand_Turk' => 'อเมริกา/แกรนด์เติร์ก',
    'America/Tortola' => 'อเมริกา/Tortola',
    'America/St_Thomas' => 'อเมริกา/เซนต์ทอมัส',
    'America/Argentina/Buenos_Aires' => 'อเมริกา/อาร์เจนตินา/บัวโนสไอเรส',
    'America/Argentina/Cordoba' => 'อเมริกา/อาร์เจนตินา/คอร์โดบา',
    'America/Argentina/Tucuman' => 'อเมริกา/อาร์เจนตินา/Tucuman',
    'America/Argentina/La_Rioja' => 'อเมริกา/อาร์เจนตินา/La_Rioja',
    'America/Argentina/San_Juan' => 'อเมริกา/อาร์เจนตินา/ซันฮวน',
    'America/Argentina/Jujuy' => 'อเมริกา/อาร์เจนตินา/Jujuy',
    'America/Argentina/Catamarca' => 'อเมริกา/อาร์เจนตินา/Catamarca',
    'America/Argentina/Mendoza' => 'อเมริกา/อาร์เจนตินา/เมนโดซา',
    'America/Argentina/Rio_Gallegos' => 'อเมริกา/อาร์เจนตินา/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'อเมริกา/อาร์เจนตินา/Ushuaia',
    'America/Aruba' => 'อเมริกา/อารูบา',
    'America/La_Paz' => 'อเมริกา/ลาปาซ',
    'America/Noronha' => 'อเมริกา/Noronha',
    'America/Belem' => 'อเมริกา/Belem',
    'America/Fortaleza' => 'อเมริกา/Fortaleza',
    'America/Recife' => 'อเมริกา/Recife',
    'America/Araguaina' => 'อเมริกา/Araguaina',
    'America/Maceio' => 'อเมริกา/Maceio',
    'America/Bahia' => 'อเมริกา/Bahia',
    'America/Sao_Paulo' => 'อเมริกา/เซาเปาโล',
    'America/Campo_Grande' => 'อเมริกา/Campo_Grande',
    'America/Cuiaba' => 'อเมริกา/Cuiaba',
    'America/Porto_Velho' => 'อเมริกา/Porto_Velho',
    'America/Boa_Vista' => 'อเมริกา/Boa_Vista',
    'America/Manaus' => 'อเมริกา/Manaus',
    'America/Eirunepe' => 'อเมริกา/Eirunepe',
    'America/Rio_Branco' => 'อเมริกา/Rio_Branco',
    'America/Santiago' => 'อเมริกา/ซันติอาโก',
    'Pacific/Easter' => 'แปซิฟิก/อีสเตอร์',
    'America/Bogota' => 'อเมริกา/โบโกตา',
    'America/Curacao' => 'อเมริกา/คูราเคา',
    'America/Guayaquil' => 'อเมริกา/Guayaquil',
    'Pacific/Galapagos' => 'แปซิฟิก/กาลาปากอส',
    'Atlantic/Stanley' => 'แอตแลนติก/สแตนลีย์',
    'America/Cayenne' => 'อเมริกา/กาแยน',
    'America/Guyana' => 'อเมริกา/กายอานา',
    'America/Asuncion' => 'อเมริกา/อะซุนซิออง',
    'America/Lima' => 'อเมริกา/ลิมา',
    'Atlantic/South_Georgia' => 'แอตแลนติก/เซาท์จอร์เจีย',
    'America/Paramaribo' => 'อเมริกา/ปารามาริโบ',
    'America/Port_of_Spain' => 'อเมริกา/Port_of_Spain',
    'America/Montevideo' => 'อเมริกา/มอนเตวิเดโอ',
    'America/Caracas' => 'อเมริกา/คารากัส',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'รายการโปรด';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'รายการโปรด';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Contacts',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'คำขอ',
    2 => 'การเข้าถึง',
    3 => 'ไม่ถูกต้อง',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'ผู้ใช้ Sugar',
    'support_portal' => 'พอร์ทัลการสนับสนุน',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'แคมเปญ',
    'email' => 'อีเมล',
    'workflow' => 'เวิร์กโฟลว์',
    'system' => 'ระบบ',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'แคมเปญ',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'แคมเปญ',
    'email' => 'อีเมล',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'เอกสารประกอบ',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'สองช่วง',
    'show_buckets' => 'สามช่วง',
    'show_custom_buckets' => 'ช่วงที่กำหนดเอง',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'ปีที่อ้างอิงจากวันที่',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'รายปี (งวดย่อยรายไตรมาส)',
    'Quarter' => 'รายไตรมาส (งวดย่อยรายเดือน)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'รายการบรรทัดรายได้',
    'Opportunities' => 'โอกาสทางการขาย',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'ใช่',
    'no' => 'ไม่',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'การเตือน',
    'information' => 'ข้อมูล',
    'other' => 'อื่นๆ',
    'success' => 'สำเร็จ',
    'warning' => 'คำเตือน',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'GET',
    'PUT' => 'PUT',
    'DELETE' => 'ลบ',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'ด้วยตนเอง',
    '5' => 'ทุก 5 นาที',
    '15' => 'ทุก 15 นาที',
    '30' => 'ทุก 30 นาที',
    '60' => 'ทุกชั่วโมง',
];

$app_list_strings['moduleList']['KBDocuments'] = 'เอกสารฐานความรู้';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'เอกสารฐานความรู้';
$app_list_strings['moduleList']['KBContents'] = 'ฐานความรู้';
$app_list_strings['moduleListSingular']['KBContents'] = 'บทความฐานความรู้';
$app_list_strings['moduleList']['KBArticles'] = 'บทความฐานความรู้';
$app_list_strings['moduleListSingular']['KBArticles'] = 'บทความฐานความรู้';
$app_list_strings['moduleList']['KBContentTemplates'] = 'เทมเพลทฐานความรู้';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'เทมเพลทฐานความรู้';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'ไฟล์ที่รวม';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'ไฟล์ที่รวม';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'เลค',
    'USD' => 'ดอลลาร์',
    'AFN' => 'อัฟกานี',
    'ARS' => 'เปโซ',
    'AWG' => 'กิลเดอร์',
    'AUD' => 'ดอลลาร์',
    'AZN' => 'มานัตใหม่',
    'BSD' => 'ดอลลาร์',
    'BBD' => 'ดอลลาร์',
    'BYR' => 'รูเบิล',
    'EUR' => 'ยูโร',
    'BZD' => 'ดอลลาร์',
    'BMD' => 'ดอลลาร์',
    'BOB' => 'โบลิเบียโน',
    'BAM' => 'มาร์คที่เปลี่ยนแปลงได้',
    'BWP' => 'ปูลา',
    'BGN' => 'เลฟ',
    'BRL' => 'เรียล',
    'GBP' => 'ปอนด์',
    'BND' => 'ดอลลาร์',
    'KHR' => 'เรียล',
    'CAD' => 'ดอลลาร์',
    'KYD' => 'ดอลลาร์',
    'CLP' => 'เปโซ',
    'CNY' => 'หยวนเหรินหมินปี้',
    'COP' => 'เปโซ',
    'CRC' => 'โคลน',
    'HRK' => 'คูนา',
    'CUP' => 'เปโซ',
    'CZK' => 'โครูนา',
    'DKK' => 'โครน',
    'DOP' => 'เปโซ',
    'XCD' => 'ดอลลาร์',
    'EGP' => 'ปอนด์',
    'SVC' => 'โคลอน',
    'EEK' => 'ครูนี',
    'FKP' => 'ปอนด์',
    'FJD' => 'ดอลลาร์',
    'GHC' => 'ซีดี',
    'GIP' => 'ปอนด์',
    'GTQ' => 'เกตซัล',
    'GGP' => 'ปอนด์',
    'GYD' => 'ดอลลาร์',
    'HNL' => 'เลมปีรา',
    'HKD' => 'ดอลลาร์',
    'HUF' => 'โฟรินท์',
    'ISK' => 'โครนา',
    'INR' => 'รูปี',
    'IDR' => 'รูเปีย',
    'IRR' => 'รีอัล',
    'IMP' => 'ปอนด์',
    'ILS' => 'เชเกลใหม่',
    'JMD' => 'ดอลลาร์',
    'JPY' => 'เยน',
    'JEP' => 'ปอนด์',
    'KZT' => 'เตงเก',
    'KPW' => 'วอน',
    'KRW' => 'วอน',
    'KGS' => 'ซอม',
    'LAK' => 'กีบ',
    'LVL' => 'ลาติ',
    'LBP' => 'ปอนด์',
    'LRD' => 'ดอลลาร์',
    'CHF' => 'ฟรังก์สวิตเซอร์แลนด์',
    'LTL' => 'ลิไต',
    'MKD' => 'ดีนาร์',
    'MYR' => 'ริงกิต',
    'MUR' => 'รูปี',
    'MXN' => 'เปโซ',
    'MNT' => 'ทูกรุก',
    'MZN' => 'เมตีกาล',
    'NAD' => 'ดอลลาร์',
    'NPR' => 'รูปี',
    'ANG' => 'กิลเดอร์',
    'NZD' => 'ดอลลาร์',
    'NIO' => 'กอร์โดบา',
    'NGN' => 'ไนร่า',
    'NOK' => 'โครน',
    'OMR' => 'รีอัล',
    'PKR' => 'รูปี',
    'PAB' => 'บัลโบอา',
    'PYG' => 'กวารานี',
    'PEN' => 'นีโว โซล',
    'PHP' => 'เปโซ',
    'PLN' => 'ซวอตี',
    'QAR' => 'รีอัล',
    'RON' => 'ลิวใหม่',
    'RUB' => 'รูเบิล',
    'SHP' => 'ปอนด์',
    'SAR' => 'ริยาล',
    'RSD' => 'ดีนาร์',
    'SCR' => 'รูปี',
    'SGD' => 'ดอลลาร์',
    'SBD' => 'ดอลลาร์',
    'SOS' => 'ชิลลิง',
    'ZAR' => 'แรนด์',
    'LKR' => 'รูปี',
    'SEK' => 'โครนา',
    'SRD' => 'ดอลลาร์',
    'SYP' => 'ปอนด์',
    'TWD' => 'ดอลลาร์ใหม่',
    'THB' => 'บาท',
    'TTD' => 'ดอลลาร์',
    'TRY' => 'ลีร์',
    'TRL' => 'ลีร์',
    'TVD' => 'ดอลลาร์',
    'UAH' => 'ฮรีฟเนีย',
    'UYU' => 'เปโซ',
    'UZS' => 'ซอม',
    'VEF' => 'บอลวาร์ โฟร์ติ',
    'VND' => 'ดง',
    'YER' => 'รีอัล',
    'ZWD' => 'ดอลลาร์ซิมบับเว',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'สูงมาก',
    '4' => 'สูง',
    '3' => 'ธรรมดา',
    '2' => 'ต่ำ',
    '1' => 'ต่ำมาก',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'ไม่มี',
    'future' => 'ค่าปัจจุบัน',
    'old' => 'ค่าเดิม',
    'both' => 'ค่าเดิมและค่าปัจจุบัน',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'รายการที่พบครั้งเดียว',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'กำลังประมวลผล',
    'error' => 'ข้อผิดพลาด',
    'success' => 'สำเร็จ',
    'canceled' => 'ยกเลิก',
    'document_load' => 'กำลังโหลดเทมเพลท',
    'tags_extract' => 'กำลังสกัดแท็ก',
    'tags_validate' => 'กำลังตรวจสอบแท็ก',
    'data_retrieving' => 'กำลังเรียกข้อมูล',
    'serialize_document' => 'กำลังใส่เอกสารกลับเข้าด้วยกัน',
    'send_document' => 'กำลังส่งเอกสารให้คุณ',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'ผสาน',
    'convert' => 'ผสาน PDF',
    'multimerge' => 'ผสานหลายไฟล์',
    'multimerge_convert' => 'ผสาน PDF หลายไฟล์',
    'labelsgenerate' => 'สร้างป้ายกำกับ',
    'labelsgenerate_convert' => 'สร้างป้ายกำกับ PDF',
    'excel' => 'ผสาน Excel',
    'excel_convert' => 'แปลงผสาน Excel',
    'presentation' => 'ผสาน PowerPoint',
    'presentation_convert' => 'PowerPoint ผสาน PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'บัญชีของฉัน',
    'favorites' => 'บัญชีโปรด',
    'tags' => 'บัญชีที่ติดแท็ก',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'ข่าวสารทั้งหมด',
    'General' => 'ทั่วไป',
    'Finance' => 'การเงิน',
    'People' => 'ฝ่ายบุคคล',
    'Press Releases' => 'ข่าวประชาสัมพันธ์',
    'Other' => 'อื่น ๆ',
];

$app_strings['LBL_OWNERS'] = 'เจ้าของ';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Cloud Drive';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'ส่วนข้อมูลบูรณาการ Cloud Drive';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'คัดลอกลิงก์';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'ดาวน์โหลด';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'สร้างเอกสาร Sugar';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'ไม่สามารถดาวน์โหลดไฟล์นี้ได้';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'ไม่ปรากฏส่วนข้อมูลคลาวด์';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'สร้างเอกสาร Sugar แล้ว';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'ส่งไปยัง DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign ไม่พร้อมใช้งานจากตําแหน่งที่ตั้งนี้';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'การผสานเอกสารเป็น Word/Excel/PowerPoint ไม่พร้อมใช้งานจากตําแหน่งนี้';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'ผสานเอกสารไม่พร้อมใช้งานจากตําแหน่งนี้';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'ผสานเอกสารไปยัง PDF ไม่พร้อมใช้งานจากตําแหน่งนี้';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'ระบบจะอัปโหลดไฟล์ที่ลงนามของคุณที่นี่เฉพาะกรณีที่คุณได้รับอนุญาตให้อัปโหลดในตําแหน่งนี้';
$app_strings['LBL_DOC_MERGE_TO'] = 'ผสานเอกสารไปยัง';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'ไฟล์ของฉัน';
$app_strings['LBL_SHARED_WITH_ME'] = 'แชร์กับฉัน';
$app_strings['LBL_CLOUD_PROVIDER'] = 'ผู้ให้บริการคลาวด์';

$app_list_strings['drive_types'] = [
    'google' => 'Google ไดร์ฟ',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'ไดร์ฟ Dropbox',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'แชร์กับฉัน';
$app_strings['LBL_MY_FILES'] = 'ไฟล์ของฉัน';
$app_strings['LBL_UPLOAD_FILE'] = 'อัปโหลดไฟล์';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'ไม่พบโฟลเดอร์';
$app_strings['LBL_CREATE_FOLDER'] = 'สร้างโฟลเดอร์';
$app_strings['LBL_LOAD_MORE'] = 'โหลดเพิ่มเติม...';
$app_strings['LBL_NEW_FOLDER'] = 'โฟลเดอร์ใหม่';
$app_strings['LBL_FOLDER_NAME'] = 'ชื่อโฟลเดอร์: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'คุณไม่มีสิทธิ์กระทำการนี้ในเส้นทางปัจจุบัน';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'คุณไม่มีสิทธิ์ไปยังเส้นทางปัจจุบัน';
$app_strings['LBL_FILE_UPLOADED'] = 'อัปโหลดไฟล์แล้ว';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'เนื่องจากไฟล์ของคุณมีขนาดใหญ่การอัปโหลดจะใช้เวลาสักครู่';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'ระเบียนเอกสารหนึ่งฉบับหรือมากกว่านั้นไม่มีไฟล์แนบ โปรดแนบไฟล์ไปที่ระเบียนแล้วลองใหม่อีกครั้ง หรือซิงค์ระเบียนแต่ละฉบับกับไฟล์';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'ไม่พบการเชื่อมต่อกับ Google...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'ไม่พบการเชื่อมต่อกับ Microsoft...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'ไม่พบการเชื่อมต่อกับ Dropbox...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'การซิงค์กับ OneDrive อาจใช้เวลาสักครู่';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'คุณแน่ใจหรือไม่ว่าต้องการลบไฟล์นี้';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'อัปโหลด OneDrive สมบูรณ์แล้ว';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' อัปโหลดเสร็จสมบูรณ์แล้ว';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'เกิดข้อผิดพลาดขณะโหลดเส้นทาง';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'มีข้อผิดพลาดเกิดขึ้นเพราะไฟล์เสียหาย';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'เอกสาร <i>"{{documentName}}"</i> ได้รับการบันทึกไปยังคลาวด์ไดร์ฟ และเพิ่มไปยังโมดูลเอกสาร';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'คุณไม่มีสิทธิ์ลบไฟล์นี้';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'คุณไม่มีสิทธิ์ลบแฟ้มนี้';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'คุณไม่มีสิทธิ์อัปโหลดไฟล์ไปยังตําแหน่งนี้';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'คุณไม่มีสิทธิ์สร้างแแฟ้มไปยังตําแหน่งนี้';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'ไม่สามารถสร้างโฟลเดอร์ในตําแหน่งนี้';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'ไม่สามารถอัปโหลดไฟล์ในตําแหน่งนี้';
$app_strings['LBL_SITES'] = 'ไซต์';
$app_strings['LBL_SHARED'] = 'แชร์แล้ว';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'สร้างลิงก์แล้ว คลิกปุ่มเพื่อคัดลอกลิงก์ไปยังคลิปบอร์ดของคุณ';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'คัดลอกไปยังคลิปบอร์ด';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-ว่าง-',
    'Exact' => 'ตรงทั้งหมด',
    'Null_address_components' => 'องค์ประกอบที่อยู่หนึ่งหรือมากกว่าหนึ่งองค์ประกอบว่างเปล่า',
    'Invalid_address' => 'ที่อยู่ไม่ถูกต้อง, ส่งคืนเซิร์ฟเวอร์ผิดพลาด',
    'Invalid_server_response_not_XML' => 'การตอบกลับเซิร์ฟเวอร์ไม่ถูกต้อง, ไม่ใช่ XML',
    'Invalid_address_no_location' => 'ที่อยู่ไม่ถูกต้อง, ส่งคืนเซิร์ฟเวอร์ไม่มีตำแหน่ง',
    'Ambiguous_address' => 'ที่อยู่คลุมเคลือ, ตรงกับหลายรายการ',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'ถนน',
    'a' => 'เสาอากาศ',
    'rd' => 'ถนนมืด',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'อังกฤษ (US)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'นิวยอร์ก (EST)'],
    ['pst', 'ลอสแอนเจลีส (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['ใหม่', 'ใหม่'],
    ['ระบุแล้ว', 'ระบุแล้ว'],
    ['ปิด', 'ปิด'],
    ['อินพุตที่รอดำเนินการ', 'อินพุตที่รอดำเนินการ'],
    ['ถูกปฏิเสธ', 'ถูกปฏิเสธ'],
    ['ซ้ำ', 'ซ้ำ'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['การดูแลระบบ', 'การดูแลระบบ'],
    ['ผลิตภัณฑ์', 'ผลิตภัณฑ์'],
    ['ผู้ใช้', 'ผู้ใช้'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'สูง'],
    ['P2', 'ปานกลาง'],
    ['P3', 'ต่ำ'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['ผู้ใช้', 'ผู้ใช้'],
    ['ผู้ดูแลระบบ ผู้ใช้', 'ผู้ดูแลระบบ'],
    ['ผู้จัดการบัญชี, ผู้ใช้', 'ผู้จัดการบัญชี'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['30_วัน_ที่ผ่านมา', '30 วันที่ผ่านมา'],
    ['90_วัน_ที่ผ่านมา', '90 วันที่ผ่านมา'],
    ['ปี_นี้', 'ปีที่ผ่านมา'],
    ['กำหนดเอง', 'ช่วงที่กำหนดเอง'],
    ['ทั้งหมด', 'ทั้งหมด'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['ค่าเริ่มต้น', 'ค่าเริ่มต้น'],
    ['สี', 'สีทึบ'],
    ['Url', 'รูปภาพที่กำหนดเอง'],
];
