<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'Svenska',
    'moduleList' => [
        'Home' => 'Hem',
        'Contacts' => 'Kontakter',
        'Accounts' => 'Organisationer',
        'Opportunities' => 'Affärsmöjligheter',
        'Cases' => 'Ärenden',
        'Notes' => 'Anteckningar',
        'Calls' => 'Telefonsamtal',
        'Emails' => 'Email',
        'Meetings' => 'Möten',
        'Tasks' => 'Uppgifter',
        'Calendar' => 'Kalender',
        'Leads' => 'Leads',
        'Currencies' => 'Valutor',
        'Contracts' => 'Kontrakt',
        'Quotes' => 'Offerter',
        'Products' => 'Produkter',
        'WebLogicHooks' => 'Web Logic Hooks',
        'ProductCategories' => 'Produktkategorier',
        'ProductTypes' => 'Produkttyper',
        'ProductTemplates' => 'Produktkatalog',
        'ProductBundles' => 'Produktpaket',
        'ProductBundleNotes' => 'Anteckningar för produktpaket',
        'Reports' => 'Rapporter',
        'Forecasts' => 'Prognoser',
        'ForecastWorksheets' => 'Prognosark',
        'ForecastManagerWorksheets' => 'Prognoschef arbetsark',
        'VisualPipeline' => 'Visuell pipeline',
        'ConsoleConfiguration' => 'Konsolkonfiguration',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'Offerter',
        'Teams' => 'Team',
        'TeamNotices' => 'Team notiser',
        'Manufacturers' => 'Tillverkare',
        'Activities' => 'Aktiviteter',
        'Comments' => 'Kommentarer',
        'Subscriptions' => 'Prenumerationer',
        'Bugs' => 'Buggar',
        'Feeds' => 'RSS',
        'iFrames' => 'Mina sajter',
        'TimePeriods' => 'Tidsperioder',
        'TaxRates' => 'Momssatser',
        'ContractTypes' => 'Kontraktstyper',
        'Schedulers' => 'Schemaläggare',
        'Project' => 'Projekt',
        'ProjectTask' => 'Projektuppgifter',
        'Campaigns' => 'Kampanjer',
        'CampaignLog' => 'Kampanjlogg',
        'CampaignTrackers' => 'Kampanj tracker',
        'Documents' => 'Dokument',
        'DocumentRevisions' => 'Dokumentrevisioner',
        'Connectors' => '"Connectors"',
        'Notifications' => 'Meddelanden',
        'Sync' => 'Synka',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => 'Externa användare',
        'ReportMaker' => 'Enterprise rapporter',
        'DataSets' => 'Datumformat',
        'CustomQueries' => 'Special frågor',
        'pmse_Inbox' => 'Processer',
        'pmse_Project' => 'Processdefinition',
        'pmse_Business_Rules' => 'Affärsprocessregler',
        'pmse_Emails_Templates' => 'Processemailmallar',
        'BusinessCenters' => 'Affärscenter',
        'Shifts' => 'Skift',
        'ShiftExceptions' => 'Skiftundantag',
        'Purchases' => 'Köp',
        'PurchasedLineItems' => 'Köpta poster',
        'MobileDevices' => 'Mobila enheter',
        'PushNotifications' => 'Pushaviseringar',
        'Escalations' => 'Eskaleringar',
        'DocumentTemplates' => 'Dokumentmallar',
        'DocumentMerges' => 'Dokumentkopplingar',
        'CloudDrivePaths' => 'Drivrutinsvägar för moln',
        'WorkFlow' => 'Arbetsflöden definitioner:',
        'EAPM' => 'Externa Konton',
        'Worksheet' => 'Arbetsark',
        'Users' => 'Användare',
        'Employees' => 'Anställda',
        'Administration' => 'Administration',
        'ACLRoles' => 'Roller',
        'InboundEmail' => 'Inkommande email',
        'Releases' => 'Releaser',
        'Prospects' => 'Mål',
        'Queues' => 'Köer',
        'EmailMarketing' => 'Emailutskick',
        'EmailTemplates' => 'Emailmallar',
        'SNIP' => 'Email Arkivering',
        'ProspectLists' => 'Mållistor',
        'SavedSearch' => 'Sparade sökningar',
        'UpgradeWizard' => 'Uppgraderingsguide',
        'Trackers' => 'Trackers',
        'TrackerPerfs' => 'Trackerprestanda',
        'TrackerSessions' => 'Trackersessioner',
        'TrackerQueries' => 'Trackerfrågor',
        'FAQ' => 'Frågor och svar',
        'Newsletters' => 'Nyhetsbrev',
        'SugarFavorites' => 'Favoriter',
        'PdfManager' => 'PdfManager',
        'DataArchiver' => 'Dataarkiverare',
        'ArchiveRuns' => 'Arkivkörningar',

        'OAuthKeys' => 'OAuth-konsumentnycklar',
        'OAuthTokens' => 'OAuth-tokens',
        'Filters' => 'Filter:',
        'UserSignatures' => 'E-signaturer',
        'Shippers' => 'Leverantörer',
        'Styleguide' => 'Stilguide',
        'Feedbacks' => 'Feedback',
        'Tags' => 'Taggar',
        'Categories' => 'Kategorier',
        'Dashboards' => 'Dashboards',
        'OutboundEmail' => 'E-postinställningar',
        'EmailParticipants' => 'E-deltagare',
        'DataPrivacy' => 'Datasekretess',
        'ReportSchedules' => 'Rapportscheman',
        'CommentLog' => 'Kommentarslogg',
        'Holidays' => 'Semester',
        'ChangeTimers' => 'Ändra timers',
        'Metrics' => 'Mätvärden',
        'Messages' => 'Meddelanden',
        'Audit' => 'Granskning',
        'RevenueLineItems' => 'Intäktsposter',
        'DocuSignEnvelopes' => 'DocuSign-kuvert',
        'Geocode' => 'Geokod',
        'DRI_Workflows' => 'Smart Guide',
        'DRI_Workflow_Task_Templates' => 'Smart Guide aktivitetsmallar',
        'DRI_SubWorkflows' => 'Smart Guide etapper',
        'DRI_Workflow_Templates' => 'Smart Guide mallar',
        'CJ_WebHooks' => 'Sugar Automate Webhook',
        'CJ_Forms' => 'Sugar-åtgärder i Smart Guide',
        'DRI_SubWorkflow_Templates' => 'Smart Guide mallar för etapper',
        'PubSub_ModuleEvent_PushSubs' => 'Push-prenumerationer för pub-/sub-modulhändelse',
    ],

    'moduleIconList' => [
        'Home' => 'He',
        'Contacts' => 'Ko',
        'Accounts' => 'Ko',
        'Opportunities' => 'Mö',
        'Cases' => 'Ärenden',
        'Notes' => 'Anteckningar',
        'Calls' => 'Telefonsamtal',
        'Emails' => 'Ep',
        'Meetings' => 'Mö',
        'Tasks' => 'Uppgift',
        'Calendar' => 'Ka',
        'Leads' => 'Le',
        'Currencies' => 'Va',
        'Contracts' => 'Ko',
        'Quotes' => 'An',
        'Products' => 'Pr',
        'WebLogicHooks' => 'WL',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'PT',
        'ProductTemplates' => 'PM',
        'ProductBundles' => 'PP',
        'ProductBundleNotes' => 'PP',
        'Reports' => 'Ra',
        'Forecasts' => 'Pr',
        'ForecastWorksheets' => 'PK',
        'ForecastManagerWorksheets' => 'PH',
        'Quotas' => 'Fo',
        'VisualPipeline' => 'VR',
        'ConsoleConfiguration' => 'KK',
        'SugarLive' => 'Su',
        'Teams' => 'Te',
        'TeamNotices' => 'TM',
        'Manufacturers' => 'Ti',
        'Activities' => 'Ak',
        'Comments' => 'Ko',
        'Subscriptions' => 'Pr',
        'Bugs' => 'Bu',
        'Feeds' => 'In',
        'iFrames' => 'iF',
        'TimePeriods' => 'TP',
        'TaxRates' => 'SS',
        'ContractTypes' => 'KT',
        'Schedulers' => 'Sc',
        'Project' => 'Pr',
        'ProjectTask' => 'PU',
        'Campaigns' => 'Kampanjer',
        'CampaignLog' => 'KL',
        'CampaignTrackers' => 'KS',
        'Documents' => 'Do',
        'DocumentRevisions' => 'DR',
        'Connectors' => 'Ko',
        'Notifications' => 'Me',
        'Sync' => 'Sy',
        'HintAccountsets' => 'Hi',
        'HintNotificationTargets' => 'Hi',
        'HintNewsNotifications' => 'Hi',
        'HintEnrichFieldConfigs' => 'Hi',
        'ExternalUsers' => 'EA',
        'ReportMaker' => 'RS',
        'DataSets' => 'DS',
        'CustomQueries' => 'AF',
        'pmse_Inbox' => 'In',
        'pmse_Project' => 'Pr',
        'pmse_Business_Rules' => 'FR',
        'pmse_Emails_Templates' => 'EM',
        'BusinessCenters' => 'BC',
        'Shifts' => 'Sk',
        'ShiftExceptions' => 'SU',
        'Purchases' => 'Kö',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'Mo',
        'PushNotifications' => 'Pu',
        'Escalations' => 'Es',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'AF',
        'EAPM' => 'EA',
        'Worksheet' => 'Ka',
        'Users' => 'An',
        'Employees' => 'An',
        'Administration' => 'Ad',
        'ACLRoles' => 'Ro',
        'InboundEmail' => 'IE',
        'Releases' => 'Ve',
        'Prospects' => 'Pr',
        'Queues' => 'Kö',
        'EmailMarketing' => 'EM',
        'EmailTemplates' => 'EM',
        'SNIP' => 'Kl',
        'ProspectLists' => 'PL',
        'SavedSearch' => 'SS',
        'UpgradeWizard' => 'UG',
        'Trackers' => 'Sp',
        'TrackerPerfs' => 'SU',
        'TrackerSessions' => 'SS',
        'TrackerQueries' => 'SF',
        'FAQ' => 'VF',
        'Newsletters' => 'Ny',
        'SugarFavorites' => 'Fa',
        'PdfManager' => 'PH',
        'DataArchiver' => 'DA',
        'ArchiveRuns' => 'AK',
        'OAuthKeys' => 'ON',
        'OAuthTokens' => 'OT',
        'Filters' => 'Fi',
        'UserSignatures' => 'AS',
        'Shippers' => 'Le',
        'Styleguide' => 'St',
        'Feedbacks' => 'Fe',
        'Tags' => 'Ta',
        'Categories' => 'Ka',
        'Dashboards' => 'Paneler',
        'OutboundEmail' => 'UE',
        'EmailParticipants' => 'ED',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'RS',
        'CommentLog' => 'KL',
        'Holidays' => 'He',
        'ChangeTimers' => 'ÄT',
        'Metrics' => 'Me',
        'Messages' => 'Me',
        'Audit' => 'Re',
        'RevenueLineItems' => 'IP',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'Ge',
        'DRI_Workflows' => 'AF',
        'DRI_Workflow_Task_Templates' => 'AUM',
        'DRI_SubWorkflows' => 'SA',
        'DRI_Workflow_Templates' => 'AM',
        'CJ_WebHooks' => 'WH',
        'CJ_Forms' => 'Fo',
        'DRI_SubWorkflow_Templates' => 'SAM',
        'Library' => 'Bi',
        'EmailAddresses' => 'EA',
        'Words' => 'Or',
        'Sugar_Favorites' => 'Fa',
        'KBDocuments' => 'KB',
        'KBContents' => 'KB',
        'KBArticles' => 'KB',
        'KBContentTemplates' => 'KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'IF',
    ],

    'moduleListSingular' => [
        'Home' => 'Hem',
        'Dashboards' => 'Dashboard',
        'Styleguide' => 'Stilguide',
        'Contacts' => 'Kontakt',
        'Accounts' => 'Konto',
        'Opportunities' => 'Affärsmöjlighet',
        'Cases' => 'Ärende',
        'Notes' => 'Anteckning',
        'Calls' => 'Telefonsamtal',
        'Emails' => 'Email',
        'Meetings' => 'Möte',
        'Tasks' => 'Uppgift',
        'Calendar' => 'Kalender',
        'Leads' => 'Möjlig kund',
        'Manufacturers' => 'Tillverkare',
        'VisualPipeline' => 'VisualPipeline',
        'ConsoleConfiguration' => 'Konsolkonfiguration',
        'MobileDevices' => 'Mobil enhet',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'Kontrakt',
        'Quotes' => 'Offert',
        'Products' => 'Produkt',
        'ProductCategories' => 'Produktkategori',
        'ProductBundles' => 'Produktpaket',
        'ProductBundleNotes' => 'Anteckningar för produktpaket',
        'RevenueLineItems' => 'Intäktspost',
        'WebLogicHooks' => 'Web Logic Hook',
        'Reports' => 'Rapport',
        'Forecasts' => 'Prognos',
        'ForecastWorksheets' => 'Prognosark',
        'ForecastManagerWorksheets' => 'Prognoschef arbetsark',
        'Quotas' => 'Budget',
        'Teams' => 'Lag',
        'TeamNotices' => 'Team notis',
        'Activities' => 'Aktivitet',
        'ActivityStream' => 'Aktivitetsström',
        'Bugs' => 'Bugg',
        'Feeds' => 'RSS',
        'iFrames' => 'Mina sajter',
        'TimePeriods' => 'Tidperiod',
        'TaxRates' => 'Skattesats',
        'ContractTypes' => 'Kontraktstyp',
        'Schedulers' => 'Schemaläggare',
        'Campaigns' => 'Kampanj',
        'CampaignLog' => 'Kampanjlogg',
        'Project' => 'Projekt',
        'ProjectTask' => 'Projektuppgift',
        'Prospects' => 'Mål',
        'ProspectLists' => 'Lista targets',
        'CampaignTrackers' => 'Kampanj Spårare',
        'Documents' => 'Dokument',
        'DocumentRevisions' => 'Dokumentrevision',
        'Connectors' => '"Connector"',
        'Notifications' => 'Meddelanden',
        'Sync' => 'Synka',
        'PdfManager' => 'PdfManager',
        'DataArchiver' => 'Dataarkiverare',
        'ArchiveRuns' => 'Arkivkörningar',
        'ExternalUsers' => 'Extern användare',
        'ReportMaker' => 'SweetReport',
        'DataSets' => 'Dataformat',
        'CustomQueries' => 'Anpassad sökning',
        'pmse_Inbox' => 'Process',
        'pmse_Project' => 'Processdefinition',
        'pmse_Business_Rules' => 'Affärsprocessregel',
        'pmse_Emails_Templates' => 'Processemailmall',
        'BusinessCenters' => 'Affärscenter',
        'Shifts' => 'Skift',
        'ShiftExceptions' => 'Växla undantag',
        'Purchases' => 'Köp',
        'PurchasedLineItems' => 'Köpt post',
        'PushNotifications' => 'Pushavisering',
        'Escalations' => 'Eskalering',
        'DocumentTemplates' => 'Dokumentmall',
        'DocumentMerges' => 'Dokumentsammanslagning',
        'CloudDrivePaths' => 'Drivrutinsvägar för moln',
        'WorkFlow' => 'Arbetsflöde',
        'EAPM' => 'Externt Konto',
        'Worksheet' => 'Arbetsark',
        'Users' => 'Användare',
        'SugarFavorites' => 'SugarFavorites',
        'Employees' => 'Anställd',
        'Administration' => 'Administration',
        'ACLRoles' => 'Roll',
        'InboundEmail' => 'Inkommande email',
        'Releases' => 'Release',
        'Queues' => 'Kö',
        'EmailMarketing' => 'Emailutskick',
        'EmailTemplates' => 'Emailmall',
        'SNIP' => 'Email Arkivering',
        'SavedSearch' => 'Sparade sökningar',
        'UpgradeWizard' => 'Uppgraderingsguide',
        'Trackers' => 'Tracker',
        'TrackerPerfs' => 'Trackerprestanda',
        'TrackerSessions' => 'Trackersessioner',
        'TrackerQueries' => 'Trackersökningar',
        'FAQ' => 'Frågor och svar',
        'Newsletters' => 'Nyhetsbrev',
        'OAuthKeys' => 'OAuth Konsumentnyckel',
        'OAuthTokens' => 'OAuth-token',
        'Filters' => 'Filter',
        'Comments' => 'Kommentera',
        'CommentLog' => 'Kommentarslogg',
        'Currencies' => 'Valuta',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'Produkttyp',
        'Shippers' => 'Fraktleverantör',
        'Subscriptions' => 'Prenumeration',
        'UserSignatures' => 'E-signatur',
        'Feedbacks' => 'Feedback',
        'Tags' => 'Tagg',
        'Categories' => 'Kategori',
        'OutboundEmail' => 'E-postinställning',
        'EmailParticipants' => 'E-deltagare',
        'DataPrivacy' => 'Datasekretess',
        'ReportSchedules' => 'Rapportschema',
        'Holidays' => 'Semester',
        'ChangeTimers' => 'Ändra timer',
        'Metrics' => 'Mätvärde',
        'Messages' => 'Meddelande',
        'Audit' => 'Granskning',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => 'Geokod',
        'DRI_Workflows' => 'Smart Guide',
        'DRI_Workflow_Task_Templates' => 'Smart Guide Aktivitetsmallar',
        'DRI_SubWorkflows' => 'Smart Guide etapp',
        'DRI_Workflow_Templates' => 'Smart Guide mall',
        'CJ_WebHooks' => 'Sugar Automate Webhook',
        'CJ_Forms' => 'Sugar-åtgärd i Smart Guide',
        'DRI_SubWorkflow_Templates' => 'Smart Guide etappmall',
        'PubSub_ModuleEvent_PushSubs' => 'Push-prenumeration för pub-/sub-modulhändelse',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'Ja',
        '2' => 'Nej',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'Nej',
        1 => 'Ja',
    ],

    'notifications_status_dom' => [
        0 => 'Oläst',
        1 => 'Läs',
    ],

    'optout_dom' => [
        '' => '-ingen-',
        'false' => 'Nej',
        'true' => 'Ja',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'Analytiker',
        'Competitor' => 'Konkurent',
        'Customer' => 'Kund',
        'Integrator' => 'Integratör',
        'Investor' => 'Investerare',
        'Partner' => 'Partner',
        'Press' => 'Press',
        'Prospect' => 'Kandidat',
        'Reseller' => 'Återförsäljare',
        'Other' => 'Annan',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'Kläder',
        'Banking' => 'Bank',
        'Biotechnology' => 'Bioteknik',
        'Chemicals' => 'Kemikalier',
        'Communications' => 'Kommunikation',
        'Construction' => 'Bygg',
        'Consulting' => 'Konsulting',
        'Education' => 'Utbildning',
        'Electronics' => 'Elektriker',
        'Energy' => 'Energi',
        'Engineering' => 'Ingenjörsarbete',
        'Entertainment' => 'Underhållning',
        'Environmental' => 'Miljö',
        'Finance' => 'Finans',
        'Government' => 'Regering',
        'Healthcare' => 'Sjukvård',
        'Hospitality' => 'Gästfrihet',
        'Insurance' => 'Försäkring',
        'Machinery' => 'Maskin',
        'Manufacturing' => 'Tillverkning',
        'Media' => 'Media',
        'Not For Profit' => 'Välgörenhet',
        'Recreation' => 'Rekreation',
        'Retail' => 'Detaljhandel',
        'Shipping' => 'Sjöfart',
        'Technology' => 'Teknik',
        'Telecommunications' => 'Telekommunikation',
        'Transportation' => 'Transport',
        'Utilities' => 'Verktyg',
        'Other' => 'Annan',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF och CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'Diagram',
        'Data Table' => 'Datatabell',
        'Chart and Data Table' => 'Diagram och datatabell',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'Pågår',
        'Completed' => 'Klar',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'Inkommande',
        'Outbound' => 'Utgående',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'Chatt',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'Nivå 1',
        'T2' => 'Nivå 2',
        'T3' => 'Nivå 3',
        'T4' => 'Nivå 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nej',
        'Completed' => 'Genomförd',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'Framtid',
        'Active' => 'Aktiv',
        'Past' => 'Dåtid',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon-innehåll',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'Självgenererad',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'Cold call',
        'Existing Customer' => 'Existerande kund',
        'Self Generated' => 'Självgenererad',
        'Employee' => 'Anställd',
        'Partner' => 'Partner',
        'Public Relations' => 'PR',
        'Direct Mail' => 'Postutskick',
        'Conference' => 'Konferans',
        'Trade Show' => 'Mässa',
        'Web Site' => 'Webbsida',
        'Word of mouth' => 'Mun till mun',
        'Email' => 'Email',
        'Campaign' => 'Kampanj',
        'Support Portal User Registration' => 'Portal Support Användaregistrering',
        'Other' => 'Annan',
    ],
    'metric_status_dom' => [
        'Inactive' => 'Inaktiv',
        'Active' => 'Aktiva',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'Befintlig verksamhet',
        'New Business' => 'Ny verksamhet',
    ],
    'taxrate_status_dom' => [
        'Active' => 'Aktiva',
        'Inactive' => 'Inaktiv',
    ],
    'roi_type_dom' => [
        'Revenue' => 'Intäkt',
        'Investment' => 'Investering',
        'Expected_Revenue' => 'Förväntad intäkt',
        'Budget' => 'Budget',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'Primär beslutsfattare',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primär beslutsfattare',
        'Business Decision Maker' => 'Beslutsfattare för affär',
        'Business Evaluator' => 'Utvärderare',
        'Technical Decision Maker' => 'Teknisk beslutsfattare',
        'Technical Evaluator' => 'Teknisk utredare',
        'Executive Sponsor' => 'Exekutiv sponsor',
        'Influencer' => 'Påverkar',
        'Other' => 'Annan',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'Aktiva',
        'Inactive' => 'Inaktiv',
    ],

    'shipper_status_dom' => [
        'Active' => 'Aktiva',
        'Inactive' => 'Inaktiv',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'Primär kontakt',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'Primär kontakt',
        'Alternate Contact' => 'Alternativ kontakt',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'Bredvid fältvärde',
        'field_on_top' => 'Ovanför fältvärde',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'Netto 15',
        'Net 30' => 'Netto 30',
    ],
    'sales_stage_default_key' => 'Prospektering',
    'fts_type' => [
        'Elastic' => 'elasticsearch',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'Prospektering',
        'Qualification' => 'Kvalificering',
        'Needs Analysis' => 'Kräver analys',
        'Value Proposition' => 'Kvalificera budget',
        'Id. Decision Makers' => 'Identifiera beslutsfattare',
        'Perception Analysis' => 'Analyserar uppfattningar',
        'Proposal/Price Quote' => 'Förslag/Offert',
        'Negotiation/Review' => 'Förhandling',
        'Closed Won' => 'Stängd Vunnen',
        'Closed Lost' => 'Stängd förlorad',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'Ny',
        'In Progress' => 'Pågår',
        'Closed Won' => 'Stängd Vunnen',
        'Closed Lost' => 'Stängd förlorad',
        'Converted to Quote' => 'Konverterad till offert',
    ],
    'sales_status_dom' => [
        'New' => 'Ny',
        'In Progress' => 'Pågår',
        'Closed Won' => 'Stängd Vunnen',
        'Closed Lost' => 'Stängd förlorad',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'Inkludera',
        'exclude' => 'Utesluta',
    ],
    'commit_stage_dom' => [
        'include' => 'Inkludera',
        'upside' => 'Ovansida',
        'exclude' => 'Utesluta',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'Inkludera',
        'upside' => 'Ovansida',
        'exclude' => 'Utesluta',
    ],

    'in_total_group_stages' => [
        'Draft' => 'Utkast',
        'Negotiation' => 'Förhandling',
        'Delivered' => 'Levererad',
        'On Hold' => 'Avvaktas',
        'Confirmed' => 'Konfirmerad',
        'Closed Accepted' => 'Stängd accepterad',
        'Closed Lost' => 'Stängd förlorad',
        'Closed Dead' => 'Stängd död',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'Telefonsamtal',
        'Meeting' => 'Möte',
        'Task' => 'Uppgift',
        'Email' => 'Email',
        'Note' => 'Anteckning',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'Hr.',
        'Ms.' => 'Ms.',
        'Mrs.' => 'Frk.',
        'Dr.' => 'Dr.',
        'Prof.' => 'Prof.',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'Ingen',
        60 => '1 minut före',
        300 => '5 minuter före',
        600 => '10 minuter före',
        900 => '15 minuter före',
        1800 => '30 minuter före',
        3600 => '1 timme före',
        7200 => '2 timmar före',
        10800 => '3 timmar före',
        18000 => '5 timmar före',
        86400 => '1 dag före',
        ],

        'task_priority_default' => 'Medel',
        'task_priority_dom' => [
        'High' => 'Hög',
        'Medium' => 'Medel',
        'Low' => 'Låg',
        ],
        'task_status_default' => 'Ej påbörjad',
        'task_status_dom' => [
        'Not Started' => 'Ej påbörjad',
        'In Progress' => 'Pågår',
        'Completed' => 'Genomfört',
        'Pending Input' => 'Avvaktande',
        'Deferred' => 'Uppskjutet',
        'Not Applicable' => 'Inte tillämplig',
        ],
        'meeting_status_default' => 'Planerat',
        'meeting_status_dom' => [
        'Planned' => 'Schemalagd',
        'Held' => 'Genomförd',
        'Not Held' => 'Inställt',
        'Deferred' => 'Uppskjutet',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'Annan',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'Planerat',
        'call_status_dom' => [
        'Planned' => 'Schemalagt',
        'In Progress' => 'Pågår',
        'Held' => 'Avslutat',
        'Not Held' => 'Inställt',
        'Deferred' => 'Uppskjutet',
        ],
        'call_direction_default' => 'Utgående',
        'call_direction_dom' => [
        'Inbound' => 'Inkommande',
        'Outbound' => 'Utgående',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'Ny',
        'Assigned' => 'Tilldelad',
        'In Process' => 'I kö?',
        'Converted' => 'Konverterad',
        'Recycled' => 'Återanvänd',
        'Dead' => 'Död',
        ],
        'gender_list' => [
        'male' => 'Man',
        'female' => 'Kvinna',
        'other' => 'Övrigt',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'Ny',
        'case_status_dom' => [
        'New' => 'Ny',
        'Assigned' => 'Tilldelad',
        'Closed' => 'Stängd',
        'Pending Input' => 'Avvaktande',
        'Rejected' => 'Avslag',
        'Duplicate' => 'Duplicera',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'Hög',
        'P2' => 'Medel',
        'P3' => 'Låg',
        ],
        'user_type_dom' => [
        'RegularUser' => 'Vanlig användare',
        'Administrator' => 'Administratör',
        ],
        'user_type_bool_dom' => [
            false => 'Vanlig användare',
            true => 'Administratör',
        ],
        'user_type_group_bool_dom' => [
            true => 'Gruppanvändare',
        ],
        'user_type_portal_bool_dom' => [
            true => 'Portal API-användare',
        ],
        'license_type_dom' => [
        'CURRENT' => 'Aktuell produkt',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar försäljning',
        ],
        'user_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'employee_status_dom' => [
        'Active' => 'Aktiv',
        'Terminated' => 'Slutat',
        'Leave of Absence' => 'Tjänstledig',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'project_task_priority_options' => [
        'High' => 'Hög',
        'Medium' => 'Medel',
        'Low' => 'Låg',
        ],
        'project_task_priority_default' => 'Medel',

        'project_task_status_options' => [
        'Not Started' => 'Ej påbörjad',
        'In Progress' => 'Pågår',
        'Completed' => 'Genomfört',
        'Pending Input' => 'Avvaktande',
        'Deferred' => 'Uppskjutet',
        ],
        'project_task_utilization_options' => [
        '0' => 'inga',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'Utkast',
        'In Review' => 'Under granskning',
        'Published' => 'Publicerat',
        ],
        'project_status_default' => 'Utkast',

        'project_duration_units_dom' => [
        'Days' => 'Dagar',
        'Hours' => 'Timmar',
        ],

        'project_priority_options' => [
        'High' => 'Hög',
        'Medium' => 'Medel',
        'Low' => 'Låg',
        ],
        'project_priority_default' => 'Medel',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Organisationer',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'Konto',
        'Opportunities' => 'Affärsmöjlighet',
        'Cases' => 'Ärende',
        'Leads' => 'Möjlig kund',
        'Contacts' => 'Kontakter', // cn (11/22/2005) added to support Emails
        'Products' => 'Produkt',
        'Quotes' => 'Offert',
        'Bugs' => 'Bugg',
        'Project' => 'Projekt',

        'Prospects' => 'Mål',
        'ProjectTask' => 'Projektuppgift',

        'Tasks' => 'Uppgift',
        'KBContents' => 'Kunskapsbas',
        'Notes' => 'Anteckning',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Opportunities' => 'Affärsmöjlighet',
        'Tasks' => 'Uppgift',
        'ProductTemplates' => 'Produktkatalog',
        'Quotes' => 'Offert',
        'Products' => 'Produkt',
        'Contracts' => 'Kontrakt',
        'Emails' => 'Email',

        'Bugs' => 'Bugg',
        'Project' => 'Projekt',
        'ProjectTask' => 'Projektuppgift',
        'Prospects' => 'Mål',
        'Cases' => 'Ärende',
        'Leads' => 'Möjlig kund',

        'Meetings' => 'Möte',
        'Calls' => 'Telefonsamtal',
        'KBContents' => 'Kunskapsbas',
        'PurchasedLineItems' => 'Köpt post',
        'Purchases' => 'Köp',
        'Escalations' => 'Eskalering',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Employees' => 'Anställd',
        'Leads' => 'Möjlig kund',
        'Prospects' => 'Mål',
        'Users' => 'Användare',
        ],

        'parent_type_display' => [
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Tasks' => 'Uppgift',
        'Opportunities' => 'Affärsmöjlighet',
        'Products' => 'Produkt',
        'Quotes' => 'Offert',

        'Bugs' => 'Buggar',
        'Cases' => 'Ärende',
        'Leads' => 'Möjlig kund',

        'Project' => 'Projekt',
        'ProjectTask' => 'Projektuppgift',

        'Prospects' => 'Mål',
        'KBContents' => 'Kunskapsbas',
        'Notes' => 'Anteckning',
        'PurchasedLineItems' => 'Köpt post',
        'Purchases' => 'Köp',
        'Escalations' => 'Eskalering',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'Ärende',
        ],

        'product_status_default_key' => 'Skickad',
        'product_status_quote_key' => 'Offerter',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'Offererad',
        'Orders' => 'Beställd',
        'Ship' => 'Levererad',
        ],
        'active_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        'Retired' => 'Kasserad',
        ],
        'appearance_options' => [
        'system_default' => 'Använd systeminställning',
        'light' => 'Ljus',
        'dark' => 'Mörk',
        ],


        'pricing_formula_default_key' => 'Fast',
        'pricing_formula_dom' => [
        'Fixed' => 'Fast pris',
        'ProfitMargin' => 'Vinstmarginal',
        'PercentageMarkup' => 'Påslag på kostnad',
        'PercentageDiscount' => 'Rabatt på listpris',
        'IsList' => 'Samma som listpris',
        ],
        'product_template_status_dom' => [
        'Available' => 'I lager',
        'Unavailable' => 'Ej i lager',
        ],
        'tax_class_dom' => [
        'Taxable' => 'Moms',
        'Non-Taxable' => 'Ej moms',
        ],
        'support_term_dom' => [
        '+6 months' => 'Sex månader',
        '+1 year' => 'Ett år',
        '+2 years' => 'Två år',
        ],

        'quote_type_dom' => [
        'Quotes' => 'Offert',
        'Orders' => 'Ordning',
        ],
        'default_quote_stage_key' => 'Utkast',
        'quote_stage_dom' => [
        'Draft' => 'Utkast',
        'Negotiation' => 'Förhandling',
        'Delivered' => 'Levererad',
        'On Hold' => 'Avvaktas',
        'Confirmed' => 'Konfirmerad',
        'Closed Accepted' => 'Stängd accepterad',
        'Closed Lost' => 'Stängd förlorad',
        'Closed Dead' => 'Stängd död',
        ],
        'default_order_stage_key' => 'Avvaktar',
        'order_stage_dom' => [
        'Pending' => 'Avvaktar',
        'Confirmed' => 'Konfirmerad',
        'On Hold' => 'Avvaktas',
        'Shipped' => 'Levererad',
        'Cancelled' => 'Avbruten',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'Primär beslutsfattare',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primär beslutsfattare',
        'Business Decision Maker' => 'Beslutsfattare för affär',
        'Business Evaluator' => 'Utvärderare',
        'Technical Decision Maker' => 'Teknisk beslutsfattare',
        'Technical Evaluator' => 'Teknisk utredare',
        'Executive Sponsor' => 'Exekutiv sponsor',
        'Influencer' => 'Påverkar',
        'Other' => 'Annan',
        ],
        'layouts_dom' => [
        'Standard' => 'Offert',
        'Invoice' => 'Faktura',
        ],
        'issue_priority_default_key' => 'Medel',
        'issue_priority_dom' => [
        'Urgent' => 'Brådskande',
        'High' => 'Hög',
        'Medium' => 'Medel',
        'Low' => 'Låg',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'Accepterat',
        'Duplicate' => 'Duplicera',
        'Closed' => 'Stängd',
        'Out of Date' => 'Utgånget datum',
        'Invalid' => 'Ogiltig',
        ],

        'issue_status_default_key' => 'Ny',
        'issue_status_dom' => [
        'New' => 'Ny',
        'Assigned' => 'Tilldelad',
        'Closed' => 'Stängd',
        'Pending' => 'Avvaktar',
        'Rejected' => 'Avslag',
        ],

        'bug_priority_default_key' => 'Medel',
        'bug_priority_dom' => [
        'Urgent' => 'Brådskande',
        'High' => 'Hög',
        'Medium' => 'Medel',
        'Low' => 'Låg',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'Accepterat',
        'Duplicate' => 'Duplicera',
        'Fixed' => 'Fast',
        'Out of Date' => 'Utgånget datum',
        'Invalid' => 'Ogiltig',
        'Later' => 'Senare',
        ],
        'bug_status_default_key' => 'Ny',
        'bug_status_dom' => [
        'New' => 'Ny',
        'Assigned' => 'Tilldelad',
        'Closed' => 'Stängd',
        'Pending' => 'Avvaktar',
        'Rejected' => 'Avslag',
        ],
        'bug_type_default_key' => 'Bugg',
        'bug_type_dom' => [
        'Defect' => 'Fel',
        'Feature' => 'Önskemål',
        ],
        'case_type_dom' => [
        'Administration' => 'Administration',
        'Product' => 'Produkt',
        'User' => 'Användare',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Webb',
        'InboundEmail' => 'Email',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Webb',
        'InboundEmail' => 'E-post',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        'Phone' => 'Telefon',
        'Chat' => 'Chatt',
        'Chatbot' => 'Chatbot',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'Begäran om datasekretesspolicy',
        'Send Personal Information being processed' => 'Skickade personuppgifter behandlas',
        'Rectify Information' => 'Korrigera information',
        'Request to Erase Information' => 'Begäran om att radera information',
        'Export Information' => 'Exportera information',
        'Restrict Processing' => 'Begränsa behandling',
        'Object to Processing' => 'Föremål för behandling',
        'Consent to Process' => 'Samtycke till behandling',
        'Withdraw Consent' => 'Återkalla samtycke',
        'Other' => 'Övrigt',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'Företagsmeddelanden',
        'Marketing Communications by company' => 'Marknadskommunikation för företag',
        'Marketing Communications by partners' => 'Marknadskommunikation av partners',
        ],
        'dataprivacy_status_default_key' => 'Öppna',
        'dataprivacy_status_dom' => [
        'Open' => 'Öppna',
        'Closed' => 'Genomförd',
        'Rejected' => 'Avvisad',
        ],
        'dataprivacy_priority_default_key' => 'Låg',
        'dataprivacy_priority_dom' => [
        'Low' => 'Låg',
        'Medium' => 'Medel',
        'High' => 'Hög',
        ],
        'business_day_status_dom' => [
        'Open' => 'Öppet',
        'Open 24 Hours' => 'Öppet 24 timmar',
        'Closed' => 'Stängt',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'Organisationer',
        'Activities' => 'Aktiviteter',
        'Bug Tracker' => 'Buggtracker',
        'Calendar' => 'Kalender',
        'Calls' => 'Telefonsamtal',
        'Campaigns' => 'Kampanjer',
        'Cases' => 'Ärenden',
        'Contacts' => 'Kontakter',
        'Currencies' => 'Valutor',
        'Dashboard' => 'Diagram',
        'Documents' => 'Dokument',
        'Emails' => 'Email',
        'Feeds' => 'Strömmar',
        'Forecasts' => 'Prognoser',
        'Help' => 'Hjälp',
        'Home' => 'Hem',
        'Leads' => 'Leads',
        'Meetings' => 'Möten',
        'Notes' => 'Anteckningar',
        'Opportunities' => 'Affärsmöjligheter',
        'Outlook Plugin' => 'Outlook plugin',
        'Product Catalog' => 'Produktkatalog',
        'Products' => 'Produkter',
        'RevenueLineItems' => 'Intäktsposter',
        'Projects' => 'Projekt',
        'Quotes' => 'Offerter',
        'Releases' => 'Releaser',
        'RSS' => 'RSS',
        'Studio' => 'Studio',
        'Upgrade' => 'Uppgradera',
        'Users' => 'Användare',
        'OutboundEmail' => 'E-postinställningar',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'Under planering',
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        'Complete' => 'Färdig',
        'In Queue' => 'I kö',
        'Sending' => 'Skickar',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'Telefonförsäljning',
        'Mail' => 'Email',
        'Email' => 'Email',
        'Print' => 'Skriv ut',
        'Web' => 'Webb',
        'Radio' => 'Radio',
        'Television' => 'TV',
        'NewsLetter' => 'Nyhetsbrev',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'Veckovis',
        'Monthly' => 'Månadsvis',
        'Quarterly' => 'Kvartalsvis',
        'Annually' => 'Årsvis',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'Januari',
        '2' => 'Februari',
        '3' => 'Mars',
        '4' => 'April',
        '5' => 'Maj',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'Augusti',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'December',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'Jan',
        '2' => 'Feb',
        '3' => 'Mar',
        '4' => 'Apr',
        '5' => 'Maj',
        '6' => 'Jun',
        '7' => 'Jul',
        '8' => 'Aug',
        '9' => 'Sep',
        '10' => 'Okt',
        '11' => 'Nov',
        '12' => 'Dec',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'Söndag',
        '2' => 'Måndag',
        '3' => 'Tisdag',
        '4' => 'Onsdag',
        '5' => 'Torsdag',
        '6' => 'Fredag',
        '7' => 'Lördag',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'Sön',
        '2' => 'Mån',
        '3' => 'Tis',
        '4' => 'Ons',
        '5' => 'Tor',
        '6' => 'Fre',
        '7' => 'Lör',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'Sö',
        '2' => 'Må',
        '3' => 'Ti',
        '4' => 'On',
        '5' => 'To',
        '6' => 'Fr',
        '7' => 'Lö',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'Sön',
        '1' => 'Mån',
        '2' => 'Tis',
        '3' => 'Ons',
        '4' => 'Tor',
        '5' => 'Fre',
        '6' => 'Lör',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'am',
        'pm' => 'pm',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => 'Rader och kolumner',
        'summary' => 'Sammanfattning',
        'detailed_summary' => 'Summering med detaljer',
        'Matrix' => 'Matris',
        ],


        'dom_email_types' => [
        'out' => 'Skickat',
        'archived' => 'Arkiverad',
        'draft' => 'Utkast',
        'inbound' => 'Inkommande',
        'campaign' => 'Kampanj',
        ],
        'dom_email_status' => [
        'archived' => 'Arkiverad',
        'closed' => 'Stängd',
        'draft' => 'I utkast',
        'read' => 'Läs',
        'replied' => 'Svarade',
        'sent' => 'Skickat',
        'send_error' => 'Fel vid skicka',
        'unread' => 'Oläst',
        ],
        'dom_email_archived_status' => [
        'archived' => 'Arkiverad',
        ],

        'dom_email_server_type' => ['' => '--Ingen--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--Ingen--',
        'createcase' => 'Skapa ärende',
        'bounce' => 'Studshantering',
        ],
        'dom_email_distribution' => ['' => '--Ingen--',
        'direct' => 'Direkt tilldelning',
        'roundRobin' => 'Round Robin',
        'leastBusy' => 'Minst upptagna',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'Round Robin',
        'leastBusy' => 'Minst upptagna',
        'none' => 'Inget',
        ],
        'dom_email_errors' => [1 => 'Välj endast en användare vid direkt tilldelning av poster.',
        2 => 'Du måste tilldela Endast markerade poster vid tilldening av poster via direkt tilldelning.',
        ],
        'dom_email_bool' => ['bool_true' => 'Ja',
        'bool_false' => 'Nej',
        ],
        'dom_int_bool' => [1 => 'Ja',
        0 => 'Nej',
        ],
        'dom_switch_bool' => ['on' => 'Ja',
        'off' => 'Nej',
        '' => 'Nej',],

        'dom_email_link_type' => ['sugar' => 'Sugar-emailklient',
        'mailto' => 'Extern emailklient'],


        'dom_email_editor_option' => ['' => 'Standard-emailformat',
        'html' => 'HTML-email',
        'plain' => 'Endast text'],

        'schedulers_times_dom' => ['not run' => 'Exekveringstid passerad, Ej Exekverad',
        'ready' => 'Klar',
        'in progress' => 'Pågår',
        'failed' => 'Misslyckades',
        'completed' => 'Genomfört',
        'no curl' => 'Ej körd: Ingen cURL finns',
        ],

        'dom_email_states' => [
        'Draft' => 'Utkast',
        'Archived' => 'Arkiverad',
        ],

        'dom_email_direction' => [
        'Unknown' => 'Okänd',
        'Outbound' => 'Utgående',
        'Inbound' => 'Inkommande',
        'Internal' => 'Intern',
        ],

        'scheduler_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],

        'scheduler_period_dom' => [
        'min' => 'Minuter',
        'hour' => 'Timmar',
        ],
        'forecast_type_dom' => [
        'Direct' => 'Direkt',
        'Rollup' => 'Rollup',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'Marknad',
        'Knowledge Base' => 'Kunskapsbas',
        'Sales' => 'Säljsida',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'Marknadsföringsmaterial',
        'Product Brochures' => 'Produktbroschyrer',
        'FAQ' => 'Frågor och svar',
        ],

        'document_status_dom' => [
        'Active' => 'Aktiv',
        'Draft' => 'Utkast',
        'FAQ' => 'Frågor och svar',
        'Expired' => 'Utgången',
        'Under Review' => 'Under granskning',
        'Pending' => 'Avvaktar',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'Samman',
        'eula' => 'EULA',
        'nda' => 'NDA',
        'license' => 'Licensavtal',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'Acceptera',
        'decline' => 'Avböj',
        'tentative' => 'Preliminärt',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'Accepterat',
        'decline' => 'Avböj',
        'tentative' => 'Preliminärt',
        'none' => 'Ingen',
        ],
        'dataset_output_default_dom' => [
        'table' => 'Tabell',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'Enkel modul',
        'Multi Module' => 'Multimodul',
        ],
        'report_align_dom' => [
        'left' => 'Vänster',
        'center' => 'Centrum',
        'right' => 'Höger',
        ],

        'width_type_dom' => [
        '%' => 'Procent (%)',
        'px' => 'Pixlar (px)',
        ],
        'report_color_dom' => [
        '' => 'Standard',
        'black' => 'Svart',
        'green' => 'Grön',
        'blue' => 'Blå',
        'red' => 'Röd',
        'white' => 'Vit',
        'DarkGreen' => 'Mörkgrön',
        'LightGray' => 'Ljusgrå',
        'DodgerBlue' => 'Mörkblå',
        'LightBlue' => 'Ljusblå',
        ],
        'font_size_dom' => [
        '-5' => 'Mindre (-5)',
        '-4' => 'Mindre (-4)',
        '-3' => 'Mindre (-3)',
        '-2' => 'Mindre (-2)',
        '-1' => 'Mindre (-1)',
        'Default' => 'Standard',
        '1' => 'Större (+1)',
        '2' => 'Större (+2)',
        '3' => 'Större (+3)',
        '4' => 'Större (+4)',
        '5' => 'Större (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'Huvudfråga',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'Visa',
//  'Group By' => 'Group By',
        'Calculation' => 'Beräkning',
        ],
        'query_display_type_dom' => [
        'Default' => 'Standard',
        'Custom' => 'Anpassad',
        'Hidden' => 'Dold',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'Dag',
        'Week' => 'Vecka',
        'Month' => 'Månad',
        'Quarter' => 'Kvartal',
        'Year' => 'År',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'Nu',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'SUMMA',
        'AVG' => 'MEDEL',
        'COUNT' => 'Antal',
        'STDDEV' => 'Standardavvikelse',
        'VARIANCE' => 'Varians',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'Standard fält',
        'Time' => 'Tidsintervall',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'Rader (Y-axeln)',
        'Columns' => 'Kolumner (X-axeln)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'Summa (totalt)',
        'AVG' => 'Medel',
        'MAX' => 'Max',
        'MIN' => 'Minimum',
        'COUNT' => 'Antal',
        'STDDEV' => 'Standardavvikelse',
        'VARIANCE' => 'Varians',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'Standard',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'Miniräknare',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'Fält',
        'Value' => 'Värde',
        'Group' => 'Grupp',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'Kolumn',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'Inaktiverad',
        'Enabled' => 'Aktiverad',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'Normal',
        'Scalar' => 'Skalär',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'Text',
        'Accounting' => 'Bokföring',
        'Date' => 'Datum:',
        'Datetime' => 'Datum och tid',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'År',
        'Quarter' => 'Kvartal',
        'Month' => 'Månad',
        'Week' => 'Vecka',
        'Day' => 'Dag',
        ],
        'dataset_style_dom' => [
        'normal' => 'Normal',
        'bold' => 'Fet',
        'italic' => 'Kursiv',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) Plus',
        '-' => '(-) Minus',
        '*' => '(X) Multiplicerat med',
        '/' => '(/) Dividerat med',
        ],
        'wflow_type_dom' => [
        'Normal' => 'När posten sparas',
        'Time' => 'Efter en bestämd tid',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Är',
        'in' => 'Är en av',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'Är en av',
        'not_in' => 'Är inte en av',
        ],
        'cselect_type_dom' => [
        'Equals' => 'Lika med',
        'Does not Equal' => 'Inte lika med',
        ],
        'dselect_type_dom' => [
        'Equals' => 'Lika med',
        'Less Than' => 'Mindre än',
        'More Than' => 'Störe än',
        'Does not Equal' => 'Är inte lika',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'Ja',
        'bool_false' => 'Nej',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'Lika med',
        ],
        'tselect_type_dom' => [
        '0' => '0 timmar',
        '14440' => '4 timmar',
        '28800' => '8 timmar',
        '43200' => '12 timmar',
        '86400' => '1 dag',
        '172800' => '2 dagar',
        '259200' => '3 dagar',
        '345600' => '4 dagar',
        '432000' => '5 dagar',
        '604800' => '1 vecka',
        '1209600' => '2 veckor',
        '1814400' => '3 veckor',
        '2592000' => '30 dagar',
        '5184000' => '60 dagar',
        '7776000' => '90 dagar',
        '10368000' => '120 dagar',
        '12960000' => '150 dagar',
        '15552000' => '180 dagar',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'är mer än',
        'Less Than' => 'är mindre än',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'Email',
        'Invite' => 'Bjud in',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'Normalt meddelande',
        'Custom Template' => 'Anpassad Mall',
        'System Default' => 'Systemstandard',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'Aktuell användare',
        'rel_user' => 'Relaterad användare',
        'rel_user_custom' => 'Relaterad kundanvändare',
        'specific_team' => 'Specifikt team',
        'specific_role' => 'Specifik roll',
        'specific_user' => 'Specifik användare',
        ],
        'wflow_array_type_dom' => [
        'future' => 'Nytt värde',
        'past' => 'Gammalt värde',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'Användare',
        'Manager' => "Användarens chef",
        ],
        'wflow_address_type_dom' => [
        'to' => 'Till:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'Till:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        'invite_only' => '(Bjud endast in)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'Till:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'Uppdatera post',
        'update_rel' => 'Uppdatera relaterad post',
        'new' => 'Ny post',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'Triggat datum',
        'Existing Value' => 'Existerande värde',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'Standard alternativ',
        'Advanced' => 'Avancerade alternativ',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'Tilldelad användare för utlösta objekt',
        'modified_user_id' => 'Användare som senast modifierade det utlösta objektet',
        'created_by' => 'Användare som skapade det utlösta objektet',
        'current_user' => 'Inloggad användare',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'Nuvarande Team för utlöst objekt',
        'team_set_id' => 'Aktuella lagets uppsättning av utlösta poster',
        'current_team' => 'Inloggade användarens team',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'Flytta dropdown tillbaka till',
        'advance' => 'Flytta dropdown fram till',
        ],
        'wflow_record_type_dom' => [
        'All' => 'Nya och existerande poster',
        'New' => 'Endast nya poster',
        'Update' => 'Endast existerande poster',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'Alla relaterade',
        //'first' => 'The first related',
        'filter' => 'Filtrera relaterade',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'alla relaterade',
        'any' => 'någon relaterad',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'Meddelande sedan Åtgärd',
        'actions_alerts' => 'Åtgärd sedan Meddelande'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'Ingen',
        'Daily' => 'Daglig',
        'Weekly' => 'Veckovis',
        'Monthly' => 'Månadsvis',
        'Yearly' => 'Årsvis',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'Dagar',
        'Weekly' => 'vecka(or)',
        'Monthly' => 'månad(er)',
        'Yearly' => 'år',
        ],

        'repeat_end_types' => [
        'Until' => 'Tills',
        'Occurrences' => 'Förekomster',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'Ingen',
        'Each' => 'Varje',
        'On' => 'På',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'första',
        'second' => 'andra',
        'third' => 'tredje',
        'fourth' => 'fjärde',
        'fifth' => 'femte',
        'last' => 'sista',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'Söndag',
        'Mon' => 'Måndag',
        'Tue' => 'Tisdag',
        'Wed' => 'Onsdag',
        'Thu' => 'Torsdag',
        'Fri' => 'Fredag',
        'Sat' => 'Lördag',
        'Day' => 'Dag',
        'WD' => 'Veckodag',
        'WE' => 'Helgdag',
        ],

        'duration_dom' => [
        '' => 'Ingen',
        '900' => '15 minuter',
        '1800' => '30 minuter',
        '2700' => '45 minuter',
        '3600' => '1 timme',
        '5400' => '1.5 timme',
        '7200' => '2 timmar',
        '10800' => '3 timmar',
        '21600' => '6 timmar',
        '86400' => '1 dag',
        '172800' => '2 dagar',
        '259200' => '3 dagar',
        '604800' => '1 vecka',
        ],
        'repeat_month_dom' => [
        '1' => 'Januari',
        '2' => 'Februari',
        '3' => 'Mars',
        '4' => 'April',
        '5' => 'Maj',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'Augusti',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'December',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'Standard',
        'seed' => 'Seed',
        'exempt_domain' => 'Suppression List - By Domain',
        'exempt_address' => 'Suppression List - By Email Address',
        'exempt' => 'Dämpningslista - efter ID',
        'test' => 'Test [Alt+T]',
        ],
        'currency_status_dom' => [
        'Active' => 'Aktiva',
        'Inactive' => 'Inaktiv',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'Aktiv',
        'inactive' => 'Inaktiv',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'Meddelande skickade/försökt skicka',
        'send error' => 'Studsade meddelanden, andra',
        'invalid email' => 'Studsade meddelanden, ogiltig email',
        'link' => 'Klickat via länk',
        'viewed' => 'Öppnade meddelanden',
        'removed' => 'Önskar ej utskick',
        'lead' => 'Skapade leads',
        'contact' => 'Skapade kontakter',
        'blocked' => 'Stoppad av emailadress eller domän',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'Kontakter',
        'Users' => 'Användare',
        'Prospects' => 'Mål',
        'Leads' => 'Leads',
        'Accounts' => 'Organisationer',
        ],
        'merge_operators_dom' => [
        'like' => 'Innehåller',
        'exact' => 'Exakt',
        'start' => 'Startar med',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'Ja',
        'false' => 'Nej',
        'required' => 'Obligatoriskt',
        ],

        'fts_field_config' => [
        '0' => 'Inaktiverad',
        '2' => 'Sökbar',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'Inaktiverad',
        1 => 'Aktiverad',
        2 => 'I filter',
        3 => 'Standardvalt filter',
        4 => 'Endast filter',
        ],

        'navigation_paradigms' => [
        'm' => 'Moduler',
        'gm' => 'Grupperade moduler',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'Ej påbörjad',
        'inprogress' => 'Pågår',
        'signed' => 'Signerat',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'Månadsvis',
        'quarterly' => 'Kvartalsvis',
        'halfyearly' => 'Halvårsvis',
        'yearly' => 'Årsvis',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 dag',
        '3' => '3 dagar',
        '5' => '5 dagar',
        '7' => '1 vecka',
        '14' => '2 veckor',
        '21' => '3 veckor',
        '31' => '1 månad',
        ],
        'projects_priority_options' => [
        'high' => 'Hög',
        'medium' => 'Medel',
        'low' => 'Låg',
        ],

        'projects_status_options' => [
        'notstarted' => 'Ej påbörjad',
        'inprogress' => 'Pågår',
        'completed' => 'Genomfört',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'Expandera "Legend"',
        'collapselegend' => 'Dra ihop "Legend"',
        'clickfordrilldown' => 'Klicka för "Drilldown"',
        'drilldownoptions' => '"Drill Down" alternativ',
        'detailview' => 'Detaljerad vy...',
        'piechart' => 'Pajdiagram',
        'groupchart' => 'Gruppdiagram',
        'stackedchart' => 'Stapeldiagram',
        'barchart' => 'Bar graf',
        'horizontalbarchart' => 'Horisontell bar graf',
        'linechart' => 'Linjediagram',
        'noData' => 'Ingen data tillgänglig',
        'print' => 'Skriv ut',
        'pieWedgeName' => 'sektioner',
        ],
        'chart_types' => [
        'hBarF' => 'Horisontellt fält (staplat)',
        'hGBarF' => 'Horisontellt fält (grupperat)',
        'vBarF' => 'Vertikalt fält (staplat)',
        'vGBarF' => 'Vertikalt fält (grupperat)',
        'pieF' => 'Pie',
        'funnelF' => 'Funnel',
        'lineF' => 'Line',
        'donutF' => 'Donut',
        'treemapF' => 'Treemap',
        ],
        'd3_value_placement' => [
        '0' => 'Ingen',
        '1' => 'Standard',
        'start' => 'Start',
        'middle' => 'Mellan',
        'end' => 'Slut',
        'top' => 'Topp',
        'total' => 'Totalt',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'Tratt',
        'hbar' => 'Horisontell list',
        ],
        'release_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'email_settings_for_ssl' => [
        '0' => 'Ingen',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Mindre säkra Google-appar',
        'exchange' => 'Utbyte',
        'other' => 'Annat',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'Annan',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'Enkelt citationstecken (&#39;)',
        '"' => 'Dubbelt citationstecken (")',
        '' => 'Ingen',
        'other' => 'Annan:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => 'l',
        'other' => 'Annan:',
        ],
        'link_target_dom' => [
        '_blank' => 'Nytt fönster',
        '_self' => 'Samma fönster',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'Auto-refresha inte',
        '30' => 'Var 30e sekund',
        '60' => 'Varje minut',
        '180' => 'Var 3e minut',
        '300' => 'Var 5e minut',
        '600' => 'Var 10e minut',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'Ingen',
        '15' => 'Varje 15. minuter',
        '30' => 'Varje 30. minuter',
        '45' => 'Varje 45. minuter',
        '60' => 'Varje timme',
        '120' => 'Varje 2 timmar',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'Aldrig',
        '30' => 'Var 30e sekund',
        '60' => 'Varje minut',
        '180' => 'Var 3e minut',
        '300' => 'Var 5e minut',
        '600' => 'Var 10e minut',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'Ingen',
        '1' => 'Varje 1 minut',
        '5' => 'Varje 5 minuter',
        '10' => 'Varje 10 minuter',
        '15' => 'Varje 15. minuter',
        '30' => 'Varje 30. minuter',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'Lika med',
        'not_equal' => 'Inte på',
        'greater_than' => 'Efter',
        'less_than' => 'Före',
        'last_7_days' => 'Senaste 7 dagarna',
        'next_7_days' => 'Kommande 7 dagarna',
        'last_30_days' => 'Senaste 30 dagarna',
        'next_30_days' => 'Kommande 30 dagarna',
        'last_month' => 'Senaste månaden',
        'this_month' => 'Den här månaden',
        'next_month' => 'Kommande månad',
        'last_year' => 'Senaste året',
        'this_year' => 'Det här året',
        'next_year' => 'Det här året',
        'between' => 'Mellan',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'Senaste året',
        'last_month' => 'Senaste månaden',
        'last_30_days' => 'Senaste 30 dagarna',
        'last_7_days' => 'Senaste 7 dagarna',
        'this_month' => 'Den här månaden',
        'this_year' => 'Det här året',
        'next_7_days' => 'Kommande 7 dagarna',
        'next_30_days' => 'Kommande 30 dagarna',
        'next_month' => 'Kommande månad',
        'next_year' => 'Det här året',
        ],
        'numeric_range_search_dom' => [
        '=' => 'Lika med',
        'not_equal' => 'Inte lika med',
        'greater_than' => 'Större än',
        'greater_than_equals' => 'Större Eller Lika Med',
        'less_than' => 'Mindre än',
        'less_than_equals' => 'Mindre Eller Lika Med',
        'between' => 'Mellan',
        ],

        'filter_checkbox_dom' => [
        0 => 'Falsk',
        1 => 'Sant',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'Vunnit',
        'lost' => 'Förlorad',
        'active' => 'Aktiv',
        ],

        'sweetspot_theme_options' => [
        'default' => 'Standard',
        'light' => 'Ljus',
        'dark' => 'Mörk',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'Flytta',
        'donothing' => 'Gör ingenting',
        ],
        'processes_auto_save_interval' => [
        0 => 'Aldrig',
        30000 => 'Var 30:e sekund',
        60000 => 'Varje minut',
        120000 => 'Varannan minut',
        180000 => 'Var tredje minut',
        240000 => 'Var fjärde minut',
        300000 => 'Var femte minut',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nej',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'I prognos',
        'sales_stage' => 'Säljnivå',
        'probability' => 'Sannolikhet',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'Summa',
        'best' => 'Bästa',
        'worst' => 'Värsta',
        ],
        'webLogicHookList' => [
        'after_save' => 'Efter spara',
        'after_delete' => 'Efter radera',
        'after_relationship_add' => 'Efter addera relation',
        'after_relationship_delete' => 'Efter radera relation',
        'after_login' => 'Efter inloggning',
        'after_logout' => 'Efter utloggning',
        'after_login_failed' => 'Efter inloggning misslyckades',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'Aktiverad',
        'INACTIVE' => 'Inaktiverad',
        ],
        'dashboard_view_name_list' => [
        'record' => 'Post',
        'records' => 'Lista',
        'activities' => 'Aktivitetsström',
        'multi-line' => 'Lista med flera linjer',
        'omnichannel' => 'Omnichannel',
        'home' => 'Home',
        'focus' => 'Fokustilldragare',
        ],
        'metric_context_list' => [
        'service_console' => 'Servicekonsol',
        'renewals_console' => 'Förnyelsekonsol',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'Varje timme',
        '21600' => 'Var 6: e timme',
        '43200' => 'Var 12: e timme',
        '86400' => 'Daglig',
        '604800' => 'Veckovis',
        '1209600' => 'Varannan vecka',
        '2419200' => 'Var 4: e vecka',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'År',
        'month' => 'Månad(er)',
        'day' => 'Dag(ar)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'Ledighet',
        'event' => 'Händelse',
        'other' => 'Övrigt',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'Datum (Senaste {{module}})',
        'start_date:asc' => 'Datum (Första {{module}})',
        'total_revenue:desc' => 'Pris (Högsta totalbelopp)',
        'total_revenue:asc' => 'Pris (Lägsta totalbelopp)',
        ],
        'calendar_type_list' => [
        'main' => 'Kalendercenter',
        ],
        'calendar_views_options' => [
        'day' => 'Dag',
        'week' => 'Vecka',
        'workWeek' => 'Arbetsvecka',
        'expandedMonth' => 'Månad',
        'agenda' => 'Agenda',
        'timeline' => 'Tidslinje',
        'monthSchedule' => 'Schemaläggare',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'Skapad',
        'completed' => 'Genomförd',
        'declined' => 'Avböjd',
        'delivered' => 'Levererad',
        'sent' => 'Skickad',
        'signed' => 'Signerad',
        'voided' => 'Annullerad',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'Visa lista över potentiella mottagare',
        'dont_show' => 'Visa inte potentiella mottagare',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'Undertecknare',
        'carbon_copy' => 'Tittare (kopia)',
        'certified_delivery' => 'Tittare (certifierad leverans)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'Standard',
        'color' => 'Färg',
        'image' => 'Bild',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'Förkortning',
        'icon' => 'Ikon',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'Pil nedåt',
        'sicon-chevron-left' => 'Chevron vänster',
        'sicon-check' => 'Check',
        'sicon-clock' => 'Klocka',
        'sicon-dashboard-default' => 'Standard för instrumentpanelen',
        'sicon-dashboard' => 'Instrumentpanel',
        'sicon-edit' => 'Redigera',
        'sicon-caret-down' => 'Caret ner',
        'sicon-folder' => 'Mappar',
        'sicon-info' => 'Info',
        'sicon-kebab' => 'Kebab',
        'sicon-link' => 'Länk',
        'sicon-list' => 'Lista',
        'sicon-logout' => 'Logout',
        'sicon-minus' => 'Minus',
        'sicon-folder-open' => 'Öppna mapp',
        'sicon-plus-sm' => 'Plus Sm',
        'sicon-refresh' => 'Uppdatera',
        'sicon-plus' => 'Plus',
        'sicon-settings' => 'Inställningar',
        'sicon-arrow-right-double' => 'Pil höger dubbel',
        'sicon-reports' => 'Rapporter',
        'sicon-user' => 'Användare',
        'sicon-upload' => 'Ladda upp',
        'sicon-user-group' => 'Användargrupp',
        'sicon-arrow-left-double' => 'Pil vänster dubbel',
        'sicon-chevron-up' => 'Chevron upp',
        'sicon-caret-up' => 'Caret upp',
        'sicon-star-fill' => 'Star Fill',
        'sicon-download' => 'Ladda ner',
        'sicon-close' => 'Stäng',
        'sicon-tile-view' => 'Rutvy',
        'sicon-list-view' => 'Listvy',
        'sicon-thumbs-down' => 'Tummen ner',
        'sicon-warning-circle' => 'Varningscirkel',
        'sicon-phone' => 'Telefon',
        'sicon-email' => 'E-post',
        'sicon-document' => 'Dokument',
        'sicon-note' => 'Anteckning',
        'sicon-preview' => 'Förhandsgranska',
        'sicon-copy' => 'Kopiera',
        'sicon-launch' => 'Starta',
        'sicon-lock' => 'Lås',
        'sicon-arrow-top-right' => 'Pil uppe till höger',
        'sicon-full-screen' => 'Helskärm',
        'sicon-full-screen-exit' => 'Avsluta helskärmsläge',
        'sicon-expand-left' => 'Expandera åt vänster',
        'sicon-expand-right' => 'Expandera åt höger',
        'sicon-focus-drawer' => 'Focus Drawer',
        'sicon-ban' => 'Ban',
        'sicon-thumbs-up' => 'Tummen upp',
        'sicon-search' => 'Sök',
        'sicon-calendar' => 'Kalender',
        'sicon-calendar-lg' => 'Kalender Lg',
        'sicon-mobile-lg' => 'Mobil Lg',
        'sicon-star-fill-lg' => 'Star Fill Lg',
        'sicon-star-outline-lg' => 'Star Outline Lg',
        'sicon-reset-lg' => 'Återställ Lg',
        'sicon-exchange-lg' => 'Utbyte Lg',
        'sicon-help-lg' => 'Hjälp Lg',
        'sicon-close-lg' => 'Stäng Lg',
        'sicon-plus-lg' => 'Plus Lg',
        'sicon-shortcuts-lg' => 'Genvägar Lg',
        'sicon-search-lg' => 'Sök Lg',
        'sicon-email-lg' => 'E-post Lg',
        'sicon-note-lg' => 'Anteckning Lg',
        'sicon-document-lg' => 'Dokument Lg',
        'sicon-add-dashlet-lg' => 'Lägg till Dashlet Lg',
        'sicon-collapse-lg' => 'Dra ihop Lg',
        'sicon-hamburger-lg' => 'Hamburger Lg',
        'sicon-pin-fill-lg' => 'Pin Fill Lg',
        'sicon-expand-lg' => 'Utöka alla Lg',
        'sicon-copy-lg' => 'Kopia Lg',
        'sicon-dashboard-lg' => 'Instrumentpanel Lg',
        'sicon-star-outline' => 'Star Outline',
        'sicon-reset' => 'Återställ',
        'sicon-unlink' => 'Ta bort länken',
        'sicon-phone-lg' => 'Telefon Lg',
        'sicon-attach' => 'Bifoga',
        'sicon-case-lg' => 'Ärende Lg',
        'sicon-arrow-right-lg' => 'Pil höger lg',
        'sicon-check-circle-lg' => 'Kontrollera Cirkel Lg',
        'sicon-text-formatting' => 'Textformatering',
        'sicon-check-circle' => 'Kontrollera cirkeln',
        'sicon-upload-lg' => 'Ladda upp Lg',
        'sicon-flag-lg' => 'Flagga Lg',
        'sicon-studio-lg' => 'Studio Lg',
        'sicon-contact-lg' => 'Kontakt Lg',
        'sicon-edit-lg' => 'Redigera Lg',
        'sicon-arrow-left' => 'Pil vänster',
        'sicon-reply-all' => 'Svara alla',
        'sicon-message-lg' => 'Meddelande Lg',
        'sicon-info-lg' => 'Info Lg',
        'sicon-error-lg' => 'Fel Lg',
        'sicon-check-circle-line-lg' => 'Kontrollera Circle Line Lg',
        'sicon-warning-line-lg' => 'Varningslinje Lg',
        'sicon-arrow-up' => 'Pil upp',
        'sicon-arrow-right' => 'Pil höger',
        'sicon-nodes' => 'Noder',
        'sicon-hide' => 'Dölj',
        'sicon-help' => 'Hjälp',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'Meddelande',
        'sicon-sugar-predict-lg' => 'Sugar Förutsäga Lg',
        'sicon-sugar-predict' => 'Suger förutsäga',
        'sicon-opportunity-lg' => 'Möjlighet Lg',
        'sicon-lead-lg' => 'Lead Lg',
        'sicon-account-lg' => 'Konto Lg',
        'sicon-user-sm' => 'Användare Sm',
        'sicon-quote-lg' => 'Citat Lg',
        'sicon-equal' => 'Lika med',
        'sicon-slicers-xl' => 'Slicers Xl',
        'sicon-escalation-lg' => 'Upptrappning Lg',
        'sicon-add-circle-lg' => 'Lägg till Circle Lg',
        'sicon-add-line-lg' => 'Lägg till linje Lg',
        'sicon-add-target-lg' => 'Lägg till mål Lg',
        'sicon-help-circle-lg' => 'Hjälp cirkel Lg',
        'sicon-divide-line-lg' => 'Dela linje Lg',
        'sicon-string' => 'Sträng',
        'sicon-filter' => 'Filter',
        'sicon-number' => 'Antal',
        'sicon-format-lg' => 'Format Lg',
        'sicon-insights-lg' => 'Insikter Lg',
        'sicon-invalid-circle-lg' => 'Ogiltig cirkel Lg',
        'sicon-layout-xl' => 'Layout Xl',
        'sicon-layout-lg' => 'Layout Lg',
        'sicon-multiply-line-lg' => 'Multiplicera linje Lg',
        'sicon-redo-lg' => 'Gör om Lg',
        'sicon-refresh-lg' => 'Uppdatera Lg',
        'sicon-undo-lg' => 'Ångra Lg',
        'sicon-activity-feed-xl' => 'Aktivitetsflöde Xl',
        'sicon-chevron-left-xl' => 'Chevron vänster',
        'sicon-close-xl' => 'Stäng Xl',
        'sicon-kebab-lg' => 'Kebab Lg',
        'sicon-insights-xl' => 'Insikter Lg',
        'sicon-hide-lg' => 'Dölj Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => 'Kommentar Xl',
        'sicon-share-lg' => 'Dela Lg',
        'sicon-trash' => 'Skräp',
        'sicon-launch-lg' => 'Starta Lg',
        'sicon-thumbs-up-lg' => 'Tummen upp Lg',
        'sicon-thumbs-down-lg' => 'Tummen ner Lg',
        'sicon-warning-lg' => 'Varning Lg',
        'sicon-wizard-circle-xl' => 'Wizard cirkel Xl',
        'sicon-bell-cross-lg' => 'Bell Cross Lg',
        'sicon-bell-lg' => 'Klocka Lg',
        'sicon-daily-lg' => 'Daglig Lg',
        'sicon-cloud-download-lg' => 'Cloud Ladda ner Lg',
        'sicon-unlock' => 'Lås upp',
        'sicon-news-lg' => 'Nyheter Lg',
        'sicon-weekly-lg' => 'Veckans Lg',
        'sicon-knowledgebase-xl' => 'Kunskapsbas Xl',
        'sicon-remove' => 'Radera',
        'sicon-chevron-down' => 'Chevron ner',
        'sicon-slicers-lg' => 'Slicers Xl',
        'sicon-save-lg' => 'Spara Lg',
        'sicon-info-circle-lg' => 'Info Cirkel Lg',
        'sicon-chevron-right' => 'Chevron Höger',
        'sicon-warning-circle-lg' => 'Varningscirkel',
        'sicon-right-paren-line-lg' => 'Höger Paren linje Lg',
        'sicon-comment-lg' => 'Kommentar Lg',
        'sicon-target-lg' => 'Mål Lg',
        'sicon-subtract-line-lg' => 'Subtrahera linje Lg',
        'sicon-settings-lg' => 'Inställningar Lg',
        'sicon-left-paren-line-lg' => 'Vänster paren linje Lg',
        'sicon-preview-lg' => 'Förhandsgranska Lg',
        'sicon-thumbs-down-line-lg' => 'Tummen ner linje Lg',
        'sicon-thumbs-up-line-lg' => 'Tummen upp linje Lg',
        'sicon-send-lg' => 'Skicka Lg',
        'sicon-contact-xl' => 'Kontakt Xl',
        'sicon-wizard-circle-line-xl' => 'Wizard cirkellinje Xl',
        'sicon-trash-lg' => 'Papperskorgen Lg',
        'sicon-pin-lg' => 'Fäst Lg',
        'sicon-clock-lg' => 'Klocka Lg',
        'sicon-comment-line-xl' => 'Kommentarsrad xl',
        'sicon-dropdown-editor' => 'Rullgardinsredigerare',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'Bugg',
        'sicon-catalog' => 'Katalog',
        'sicon-cloud' => 'Moln',
        'sicon-config-api' => 'Konfigurera Api',
        'sicon-config-nav' => 'Konfigurera Nav',
        'sicon-connectors' => 'Kopplingar',
        'sicon-contracts' => 'Kontrakt',
        'sicon-currencies' => 'Valutor',
        'sicon-diagnostics' => 'Diagnostik',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'Emailkampanjer',
        'sicon-email-inbound' => 'Inkommande e-post',
        'sicon-email-queue' => 'E-postkö',
        'sicon-forecasts' => 'Prognoser',
        'sicon-display-modules' => 'Visningsmoduler',
        'sicon-email-contacts' => 'Emailkontakter',
        'sicon-import' => 'Importera',
        'sicon-log-viewer' => 'Loggvisare',
        'sicon-lab' => 'Labb',
        'sicon-map-pin' => 'Kartnål',
        'sicon-manufacturers' => 'Tillverkare',
        'sicon-update' => 'Uppdatera',
        'sicon-content-security' => 'Innehållssäkerhet',
        'sicon-module-builder' => 'Modulbyggare',
        'sicon-languages' => 'Språk',
        'sicon-module-loader' => 'Modulladdare',
        'sicon-oauth-key' => 'Oauth-nyckel',
        'sicon-password-mgmt' => 'Lösenord Mgmt',
        'sicon-opportunities' => 'Möjligheter',
        'sicon-upgrade' => 'Uppgradera',
        'sicon-portal' => 'Portal',
        'sicon-product-types' => 'Produkttyper',
        'sicon-quotes' => 'Citat',
        'sicon-relate-fields' => 'Relatera fält',
        'sicon-repair' => 'Reparera',
        'sicon-role-mgmt' => 'Roll Mgmt',
        'sicon-scheduler' => 'Schemaläggare',
        'sicon-shippers' => 'Speditör',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'Webblogik',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'Skattesats',
        'sicon-team-mgmt' => 'Team Mgmt',
        'sicon-team-perm' => 'Team Perm',
        'sicon-tracker' => 'Tracker',
        'sicon-workflow' => 'Arbetsflöde',
        'sicon-mask' => 'Mask',
        'sicon-mask-disabled' => 'Mask inaktiverad',
        'sicon-email-archive' => 'E-post arkiv',
        'sicon-mobile' => 'Mobil',
        'sicon-archive' => 'Arkiv',
        'sicon-automate-scroll' => 'Vertikal rullningsvy',
        'sicon-automate-stacked' => 'Horisontell rullningsvy',
        'sicon-pdf-manager' => 'PdfManager',
        'sicon-my-sites' => 'Mina webbplatser',
        'sicon-cloud-insights' => 'Cloud insikter',
        'sicon-sugar-logo-24' => 'Sugar Logo 24',
        'sicon-sugar-logo-16' => 'Sugar Logo 16',
        'sicon-task-lg' => 'Uppgift Lg',
        'sicon-web-lg' => 'Webb Lg',
        'sicon-events-lg' => 'Events Lg',
        'sicon-sugar-logo-12' => 'Sugar Logo 12',
        'sicon-tag' => 'Tagg',
        'sicon-tag-lg' => 'Tagg Lg',
        'sicon-bell-lg-line' => 'Bell Lg linje',
        'sicon-matrix-xxl' => 'Matrix Xxl',
        'sicon-advanced-filter' => 'Avancerade filter',
        'sicon-rows-and-columns-xxl' => 'Rader och kolumner xxl',
        'sicon-summation-details-xxl' => 'Summeringdetaljer Xxl',
        'sicon-summation-xxl' => 'Summering Xxl',
        'sicon-lock-lg' => 'Lås Lg',
        'sicon-csv-file-xxl' => 'Csv Fil Xxl',
        'sicon-logo-linkedin' => 'Logotyp Linkedin',
        'sicon-briefcase' => 'Portfölj',
        'sicon-car-front' => 'Bilfront',
        'sicon-airplane' => 'Flygplan',
        'sicon-laptop' => 'Laptop',
        'sicon-logo-instagram' => 'Logotyp Instagram',
        'sicon-single-bed' => 'Enkelsäng',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'Logotyp Snapchat',
        'sicon-video-lg' => 'Video Lg',
        'sicon-reply' => 'Svara',
        'sicon-subtract' => 'Subtrahera',
        'sicon-arrow-up-circle-line' => 'Pil upp cirkellinje',
        'sicon-asterisk' => 'Asterisk',
        'sicon-dot-circle-o-lg' => 'Punktcirkel O Lg',
        'sicon-forward' => 'Vidarebefodra',
        'sicon-video' => 'Video',
        'sicon-gavel' => 'Klubba',
        'sicon-login' => 'Logga in',
        'sicon-pdf-file-xxl' => 'Pdf-fil xxl',
        'sicon-login-lg' => 'Logga in Lg',
        'sicon-cloud-download-xl' => 'Cloud nerladdning Xl',
        'sicon-campaigns-lg' => 'Kampanjer Lg',
        'sicon-customer-journey-stages-lg' => 'Kundens färdetapper Lg',
        'sicon-role-mgmt-lg' => 'Roll Mgmt Lg',
        'sicon-default-module-lg' => 'Standardmodul Lg',
        'sicon-quoted-line-items-lg' => 'Offert på radobjekt Lg',
        'sicon-projects-lg' => 'Projekt Lg',
        'sicon-process-business-rules-lg' => 'Process för affärsregler Lg',
        'sicon-process-email-templates-lg' => 'Preocess för affärsmallar Lg',
        'sicon-processes-lg' => 'Processer Lg',
        'sicon-process-definitions-lg' => 'Processdefinitioner Lg',
        'sicon-target-lists-lg' => 'Mållistor Lg',
        'sicon-purchased-line-items-lg' => 'Köpta radartiklar Lg',
        'sicon-user-group-lg' => 'Användargrupp Lg',
        'sicon-revenue-line-items-lg' => 'Intäkter radartiklar Lg',
        'sicon-business-centers-lg' => 'Affärscenter Lg',
        'sicon-logo-fb-simple' => 'Logotyp Fb Enkel',
        'sicon-forecasts-lg' => 'Prognoser Lg',
        'sicon-contracts-lg' => 'Kontrakt Lg',
        'sicon-purchase-lg' => 'Köp Lg',
        'sicon-sugar-live-lg' => 'Suger Live Lg',
        'sicon-customer-journey-lg' => 'Kundens resa Lg',
        'sicon-data-privacy-lg' => 'Datasekretess Lg',
        'sicon-home-lg' => 'Hem Lg',
        'sicon-data-table' => 'Datatabell',
        'sicon-medical-clipboard-lg' => 'Medicinsk Clipboard Lg',
        'sicon-privacy-lg' => 'Sekretess Lg',
        'sicon-marketplace' => 'Marketplace',
        'sicon-marketplace-lg' => 'Marketplace Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => 'Casino Lg',
        'sicon-jacuzzi-lg' => 'Jacuzzi Lg',
        'sicon-scissors-lg' => 'Sax Lg',
        'sicon-storage-lg' => 'Förvaring Lg',
        'sicon-fan-lg' => 'Fläkt Lg',
        'sicon-medicine-lg' => 'Medicin Lg',
        'sicon-plant-lg' => 'Växt Lg',
        'sicon-telescope-lg' => 'Teleskop Lg',
        'sicon-smart-phone-lg' => 'Smartphone Lg',
        'sicon-coffee-lg' => 'Kaffe Lg',
        'sicon-martini-lg' => 'Martini Lg',
        'sicon-cocktail-lg' => 'Cocktail Lg',
        'sicon-stadium-lg' => 'Stadion Lg',
        'sicon-fire-lg' => 'Eld Lg',
        'sicon-window-lg' => 'Fönster Lg',
        'sicon-lotus-lg' => 'Lotus Lg',
        'sicon-windmill-lg' => 'Väderkvarn Lg',
        'sicon-spades-lg' => 'Spader Lg',
        'sicon-hearts-lg' => 'Hjärter Lg',
        'sicon-diamonds-lg' => 'Ruter Lg',
        'sicon-clubs-lg' => 'Ruter Lg',
        'sicon-skull-lg' => 'Skalle Lg',
        'sicon-send' => 'Skicka',
        'sicon-world-lg' => 'Värld Lg',
        'sicon-airplane-lg' => 'Flygplan Lg',
        'sicon-planet-lg' => 'Planet Lg',
        'sicon-trainer-lg' => 'Tränare Lg',
        'sicon-calculator-lg' => 'Kalkylator Lg',
        'sicon-tv-lg' => 'TV Lg',
        'sicon-video-player-lg' => 'Videospelare Lg',
        'sicon-media-player-lg' => 'Mediaspelare Lg',
        'sicon-decentralize-lg' => 'Decentralisera Lg',
        'sicon-statistics-lg' => 'Statistik Lg',
        'sicon-virus-lg' => 'Virus Lg',
        'sicon-shield-lg' => 'Sköld Lg',
        'sicon-plug-lg' => 'Plugg Lg',
        'sicon-shuttle-lg' => 'Skyttel Lg',
        'sicon-soundwave-lg' => 'Ljudvåg Lg',
        'sicon-graph-lg' => 'Graf Lg',
        'sicon-playlist-lg' => 'Spellista Lg',
        'sicon-voice-recognition-lg' => 'Röstigenkänning Lg',
        'sicon-machine-learning-lg' => 'Maskininlärning Lg',
        'sicon-bed-lg' => 'Säng Lg',
        'sicon-blueprint-lg' => 'Ritning Lg',
        'sicon-content-delivery-lg' => 'Innehållsleverans Lg',
        'sicon-questionnaire-lg' => 'Frågeformulär Lg',
        'sicon-presentation-lg' => 'Presentation Lg',
        'sicon-organic-lg' => 'Ekologisk Lg',
        'sicon-transactions-lg' => 'Transaktioner Lg',
        'sicon-wand-lg' => 'Trollstav Lg',
        'sicon-bin-lg' => 'Papperskorg Lg',
        'sicon-sync-lg' => 'Synkronisera Lg',
        'sicon-external-authentication-lg' => 'Extern autentisering Lg',
        'sicon-tracking-activity-lg' => 'Spårningsaktivitet Lg',
        'sicon-account' => 'Konto',
        'sicon-meetings-lg' => 'Möten Lg',
        'sicon-stacked' => 'Horisontellt delad vy',
        'sicon-sidebyside' => 'Vertikalt delad vy',
        ],

        'module_colors_dom' => [
        'army' => 'Armé',
        'coral' => 'Korall',
        'green' => 'Grön',
        'orange' => 'Orange',
        'ocean' => 'Hav',
        'pacific' => 'Stilla havet',
        'pink' => 'Rosa',
        'purple' => 'Lila',
        'red' => 'Röd',
        'teal' => 'Teal',
        'yellow' => 'Gul',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'Ny',
        'In Progress' => 'Pågår',
        'Closed' => 'Stängd',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'Inaktivitet',
        'Lack of Progress' => 'Bristande framsteg',
        'Customer-Imposed Deadline' => 'Deadline fastställd av kund',
        'Account at Risk' => 'Konto i riskzonen',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'Begärd av kund',
        'Internally Requested' => 'Begärd internt',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'Ärende',
        'Bugs' => 'Bugg',
        'Accounts' => 'Konto',
        'Opportunities' => 'Möjlighet',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'Positiv',
        'Negative' => 'Negativ',
        'Neutral' => 'Neutral',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'Inte sannolikt',
        '02_less_likely' => 'Mindre sannolikt',
        '03_neutral' => 'Neutralt',
        '04_more_likely' => 'Mer sannolikt',
        '05_very_likely' => 'Mycket sannolikt',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'Matchar inte kunder',
        '02_no_match' => '',
        '01_matches_customers' => 'Matchar kunder',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'Lead',
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Cases' => 'Ärende',
        'Opportunities' => 'Möjlighet',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'Ej påbörjad',
        'in_progress' => 'Pågår',
        'completed' => 'Genomfört',
        'cancelled' => 'Avbruten',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'Inget',
        'create' => 'Vid skapande',
        'stage_start' => 'Vid etappstart',
        'previous_activity_completed' => 'Tidigare slutförd aktivitet',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'Aktuell användare',
        'parent_assignee' => 'Överordnad uppdragstagare',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'Dagar från skapade',
        'days_from_stage_started' => 'Dagar från etappstart',
        'days_from_previous_activity_completed' => 'Dagar från föregående slutförd aktivitet',
        'days_from_parent_date_field' => 'Dagar från överordnat datumfält',
        'days_from_specific_activity_completed' => 'Dagar från att specifik aktivitet har slutförts',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'När den skapades',
        'stage_started' => 'När etappenstartade',
        'previous_activity_completed' => 'När föregående aktivitet har slutförts',
        'parent_date_field' => 'På överordnat datumfält',
        'specific_activity_completed' => 'Specifik aktivitet slutförd',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'Absolut',
        'Percentage' => 'Procent',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'Kundens uppgift',
        'milestone' => 'Milstolpe',
        'internal_task' => 'Intern uppgift',
        'agency_task' => 'Byråns uppgift',
        'automatic_task' => 'Automatisk uppgift',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'Uppgift',
        'Calls' => 'Telefonsamtal',
        'Meetings' => 'Möte',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'Inget',
        'create' => 'Vid skapande',
        'stage_start' => 'På etappstart',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'Ärva',
        'current_user' => 'Nuvarande användare',
        'parent_assignee' => 'Överordnad uppdragstagare',
        'user' => 'Användare',
        'team' => 'Team',
        'user_team' => 'Användare & Team',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'Ärva',
        'none' => 'Inget',
        'create' => 'Vid skapande',
        'stage_start' => 'På scenstart',
        'previous_activity_completed' => 'Tidigare slutförd aktivitet',
        'specific_activity_completed' => 'Specifik aktivitet slutförd',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'Ej påbörjad',
        'in_progress' => 'Pågår',
        'not_completed' => 'Inte slutfört',
        'completed' => 'Genomförd',
        'cancelled' => 'Avbruten',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'Redigera etapp',
        'stage_add_task_button' => 'Skapa uppgift',
        'stage_add_meeting_button' => 'Schemalägg möte',
        'stage_add_call_button' => 'Schemalägg telefonsamtal',
        'stage_delete_button' => 'Radera etapp',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'Lägg till uppgift',
        'activity_add_sub_meeting_button' => 'Schemalägg möte',
        'activity_add_sub_call_button' => 'Schemalägg telefonsamtal',
        'activity_not_applicable_button' => 'Inte tillämplig',
        'activity_delete_button' => 'Radera',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'Uppsättningen är inte tillämplig',
        'remove_open_activities' => 'Ta bort öppna aktiviteter',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'Standard',
        'custom' => 'Anpassad',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'FÅ',
        'POST' => 'POST',
        'PUT' => 'STÄLLA',
        'PATCH' => 'LAPPA',
        'DELETE' => 'RADERA',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'Hoppa över begäran',
        'json' => 'JSON',
        'http_query' => 'HTTP-fråga',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'Ej respons',
        'json' => 'JSON',
        'http_query' => 'HTTP-fråga',
        'text' => 'Klartext',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'Innan skapandet',
        'after_create' => 'Efter skapandet',
        'before_in_progress' => 'Innan pågående',
        'after_in_progress' => 'Efter pågående',
        'before_completed' => 'Innan den är klar',
        'after_completed' => 'Efter avslutad',
        'before_not_applicable' => 'Innan det inte är tillämpligt',
        'after_not_applicable' => 'Efter ej tillämpligt',
        'before_delete' => 'Innan borttagning',
        'after_delete' => 'Efter borttagning',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Skicka Smart Guide Information',
        'custom_body' => 'Skicka anpassad inläggstext',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'Pågår',
        'completed' => 'Genomförd',
        'not_applicable' => 'Inte tillämplig',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'Visa register',
        'create_record' => 'Skapa register',
        'update_record' => 'Uppdatera register',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'Skapa register automatiskt',
        'manual_create' => 'Skapa register manuellt',
        'automatic_update' => 'Uppdatera register automatiskt',
        'manual_update' => 'Uppdatera register manuellt',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Smart Guide mall',
        'DRI_SubWorkflow_Templates' => 'Etappmallar',
        'DRI_Workflow_Task_Templates' => 'Aktivitetsmallar',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'Ja',
        'no' => 'Nej',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'Hållen',
        'Not Held' => 'Genomfördes inte',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'Hållen',
        'Not Held' => 'Genomfördes inte',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'Genomförd',
        'Not Applicable' => 'Inte tillämplig',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Smart Guide mall',
        'DRI_SubWorkflow_Templates' => 'Etappmall',
        'DRI_Workflow_Task_Templates' => 'Aktivitetsmall',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'Uppgift',
        'Meetings' => 'Möte',
        'Calls' => 'Telefonsamtal',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'Aktuell uppgift',
        'Calls' => 'Aktuellt samtal',
        'Meetings' => 'Aktuellt möte',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'Specifik användare',
        'specific_contacts' => 'Specifika kontakter',
        'related_parent_users' => 'Relaterade överordnade användare',
        'related_parent_contacts' => 'Relaterade överordnade kontakter',
        'add_all_contacts_from_parent' => 'Lägg till alla kontakter från överordnad',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'Användare',
        'specific_contacts' => 'Kontakter',
        'related_parent_users' => 'Användare',
        'related_parent_contacts' => 'Kontakter',
        'add_all_contacts_from_parent' => 'Kontakter',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'Minut(er)',
        'hours' => 'Timm(e/ar)',
        'days' => 'Dag(ar)',
        'months' => 'Månad(er)',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'Dag(ar)',
        'months' => 'Månad(er)',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'Fast datum',
        'relative' => 'Relativt datum',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'Användare i aktuellt skift',
        'teams' => 'Teams',
        'roles' => 'Roller',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide till Sugar-åtgärd',
        'sugar_action_to_smart_guide' => 'Sugar-åtgärd till Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide-etapp',
        'Smart Guide Activities' => 'Smart Guide-aktiviteter',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'Genomfört',
        'cancelled' => 'Avbruten',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'Pågår',
        'completed' => 'Genomfört',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'Pågår',
        'completed' => 'Genomfört',
        'not_applicable' => 'Inte tillämplig',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'Markera alla aktiviteter som Genomförda',
        'mark_all_not_applicable' => 'Markera alla ofullständiga aktiviteter som Ej tillämpliga',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'USA (Oregon) [us-west-2]',
        'ca-central-1' => 'Kanada (centrala) [ca-central-1]',
        'ap-southeast-1' => 'Asien och Stillahavsområdet (Singapore) [ap-southeast-1]',
        'ap-southeast-2' => 'Asien och Stillahavsområdet (Sydney) [ap-southeast-2]',
        'eu-central-1' => 'Europa (Frankfurt) [eu-central-1]',
        'eu-west-2' => 'Europa (London) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'Post header', // Studio editing of record views
    'LBL_RECORD_BODY' => 'Visitkort', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'Vis flera', // Studio editing of record views
    'LBL_FAVORITE' => 'Favorit', // Record view header panel element
    'LBL_FOLLOW' => 'Följ', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'Följ Länk',
    'LBL_TOGGLE_VISIBILITY' => 'Växla Synlighet', // Record view header panel element
    'LBL_ACTIVITIES' => 'Aktivitetsström',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar och 3-D-kuben är registrerade varumärken för SugarCRM Inc. ' .
        'Alla andra företags- och produktnamn som används eller förekommer i denna produkt kan vara varumärken tillhörande ' .
        'SugarCRM®, Sugar Enterprise™ och Sugar™ är varumärken som tillhör SugarCRM Inc.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ och Sugar™ är varumärken som tillhör SugarCRM Inc.',
    'LBL_SEND_INVITE' => 'Skicka invite',
    'LBL_INVITEES' => 'Gäster',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'Gästen kommer inte att få din inbjudan',
    'LBL_SELECT_ACTION_LABEL' => 'Välj åtgärd',
    'LBL_TOGGLE_DRAWER' => 'Växla Drawer',
    'LBL_TOUR_NEXT' => 'Nästa',
    'LBL_TOUR_SKIP' => 'Hoppa Över',
    'LBL_TOUR_BACK' => 'Tillbaka',
    'LBL_TOUR_CLOSE' => 'Stäng',
    'LBL_TOUR_BTN_DONE' => 'Klar',
    'LBL_TOUR_TAKE_TOUR' => 'Ta rundturen',
    'LBL_TOUR_FULL_TOUR' => 'Full tour',
    'LBL_TOUR_MODULE' => 'Ta en tour på den här sidan',
    'LBL_TOUR_END_TOUR' => 'Avsluta touren',
    'LBL_TOUR_OVERVIEW' => 'Sidöversikt',
    'LBL_TOUR_REVISIT' => 'Klicka här för att visa turnén när som helst.',
    'LBL_MY_AREA_LINKS' => 'Mina platslänkar:' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Att få luft' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'Välkommen' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'Avancerad sökning' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'Fler Detaljer' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'Redigera Inline' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'Visa' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Sök' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'Sök...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'Radera' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'Lägg till' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'Kolumn' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 Kolumner' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 Kolumner' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Avancerad sökning' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'Lägg till' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'Visa/Dölj' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'Radera' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'Lägg till' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'Rensa' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'Radera' /*for 508 compliance fix*/,
    'LBL_ADD' => 'Lägg till' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'Företagslogotyp' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'Kalender' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'Ett rullgardinsvärde som du valt ändrade layouten för din postvy. ' .
        'Värdena rensas för de fält som döljs i den här nya layouten. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'Öppen',
    'LBL_SIDEBAR_NAV_CLOSE' => 'Stäng',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}}-meny',
    'LBL_GOTO_SUGARCRM_COM' => 'Gå till SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'huvudsaklig modulnavigering',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'toggle underpanel',

    'LBL_ADVANCED' => 'Advancerad',
    'LBL_BASIC' => 'Grundläggande',
    'LBL_MODULE_FILTER' => 'Filtrera',
    'LBL_CONNECTORS_POPUPS' => 'Connectors Popups',
    'LBL_CLOSEINLINE' => 'Stäng',
    'LBL_EDITINLINE' => 'Redigera',
    'LBL_VIEWINLINE' => 'Visa',
    'LBL_INFOINLINE' => 'Info',
    'LBL_POWERED_BY_SUGARCRM' => 'Drivs av SugarCRM',
    'LBL_PRINT' => 'Skriv ut',
    'LBL_HELP' => 'Hjälp',
    'LBL_TOUR' => 'Rundtur',
    'LBL_TOUR_LINK' => 'Ta en tour på den här sidan',
    'LBL_MOBILE' => 'Mobil',
    'LBL_ID_FF_SELECT' => 'Välj',
    'DEFAULT' => 'Grundläggande',
    'LBL_SORT' => 'Sortera',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Lägg till server...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'Aktivera SMTP över SSL eller TLS',
    'LBL_NO_ACTION' => 'Det finns ingen handling med det namnet',
    'LBL_NO_DATA' => 'Inget data',
    'LBL_NOT_APPLICABLE' => 'Inte tillämplig',
    'LBL_ROUTING_ADD_RULE' => 'Lägg till regel...',
    'LBL_ROUTING_ALL' => 'Alla',
    'LBL_ROUTING_ANY' => 'Någon',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'Avbryt',
    'LBL_ROUTING_BUTTON_SAVE' => 'Spara regel',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'Kopiera email',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Radera Sugar objekt',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Radera fil',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'Radera epost',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'Vidarebefodra email',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'Flagga email',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'Markera som läst',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Markera som oläst',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'Flytta email',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'Genomför följande åtgärder',
    'LBL_ROUTING_ACTIONS_REPLY' => 'Svarsadress',

    'LBL_ROUTING_CHECK_RULE' => "Ett fel upptäcktes:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'Var god verifiera att alla fält är markerade.',
    'LBL_ROUTING_CONFIRM_DELETE' => "Är du säker på att du vill ta bort den här regeln? Det går inte att ångra.",

    'LBL_ROUTING_FLAGGED' => 'flagga satt',
    'LBL_ROUTING_FORM_DESC' => 'Sparade regler är aktiva direkt.',
    'LBL_ROUTING_FW' => 'VB:',
    'LBL_ROUTING_LIST_TITLE' => 'Regler',
    'LBL_ROUTING_MATCH' => 'om',
    'LBL_ROUTING_MATCH_2' => 'följande villkor är uppfyllda:',
    'LBL_NOTIFICATIONS' => 'Meddelanden',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'CC',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'Meddelandetext',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'Från',
    'LBL_ROUTING_MATCH_NAME' => 'Ämne',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'Hög prioritet',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Normal prioritet',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Låg prioritet',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'Till',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'Innehåller',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'Innehåller inte',

    'LBL_ROUTING_NAME' => 'Regelnamn',
    'LBL_ROUTING_NEW_NAME' => 'Ny regel',
    'LBL_ROUTING_ONE_MOMENT' => 'Var god vänta...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Originalmeddelande följer.',
    'LBL_ROUTING_RE' => 'SV:',
    'LBL_ROUTING_SAVING_RULE' => 'Sparar regel',
    'LBL_ROUTING_SUB_DESC' => 'Markerade regler är aktiva. Klicka på namnet för att redigera.',
    'LBL_ROUTING_TO' => 'till',
    'LBL_ROUTING_TO_ADDRESS' => 'till adress',
    'LBL_ROUTING_WITH_TEMPLATE' => 'med mall',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'Du har redan värden i telefon och adress fälten. För att skriva över dessa med telefon/adress för kontot du har valt, klicka "OK". För att behålla de nuvarande värdena, klicka "Avbryt".',
    'LBL_DROP_HERE' => '[Släpp här]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'Redigera',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Sätt Gmail standard',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'Namn',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Utgående emailserver',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'Mail transfer agent',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'Använd SMTP autentifiering',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP lösenord',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP port',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP server',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'Använd SSL vid uppkoppling',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP användarnamn',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Default',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Varning: Du har glömt att fylla i användarnamn och lösenord för utgående emailkonto.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP Användarnamn krävs',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP Lösenord krävs',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'Inställningar för emailkonto',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'Emailservern protokoll av typen POP3 kommer inte att supportas i nästa version. Endast IMAP kommer att supporteras.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'Sätt upp Emailkonton för att visa inkommande email från dina emailkonton.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Ange SMTP-server information för att använda utgående email i Emailkonton.',
    'LBL_EMAIL_ADD' => 'Lägg till email',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Lägg till',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Rensa',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'Till:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Cc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Bcc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'Till/Cc/Bcc',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'Ny lista',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'Mailadress',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Endast redigering av kontakter är möjligt för tillfället.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filter',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'Förnamn',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Efternamn',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'Mina kontakter',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'Min emaillista',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'Namn',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'Inga adresser hittades',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Spara & lägg till i adressboken',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Sök',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Välj poster i adressboken',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Adressbok',
    'LBL_EMAIL_REPORTS_TITLE' => 'Rapporter',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'Varning! Det utgående kontot du försöker radera är associerat med ett existerande ingående konto. Är det säker på att vill fortsätta?',
    'LBL_EMAIL_ADDRESSES' => 'Email',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'Emailadress',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'Emailadresser',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Importera till Sugar',
    'LBL_EMAIL_ASSIGNMENT' => 'Tilldelning',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Bifoga',
    'LBL_EMAIL_ATTACHMENT' => 'Bifoga',
    'LBL_EMAIL_ATTACHMENTS' => 'Från datorn',
    'LBL_EMAIL_ATTACHMENTS2' => 'Från Sugar Documents',
    'LBL_EMAIL_ATTACHMENTS3' => 'Mallbilagor',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'Fil',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Dokument',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Inbäddad',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'Bilaga misslyckades att ladda upp',
    'LBL_REMOVING_ATTACHMENT' => 'Raderar bilaga...',
    'LBL_EMAIL_BCC' => 'BCC',
    'LBL_EMAIL_CANCEL' => 'Avbryt',
    'LBL_EMAIL_CC' => 'CC',
    'LBL_EMAIL_CHARSET' => 'Teckenuppsättning',
    'LBL_EMAIL_CHECK' => 'Kontrollera email',
    'LBL_EMAIL_CHECKING_NEW' => 'Kontrollera ny email',
    'LBL_EMAIL_CHECKING_DESC' => 'Kontrollerar ny email. <br><br>Om detta är första kontrollen för emailkontot, kan det ta en liten stund.',
    'LBL_EMAIL_CLOSE' => 'Stäng',
    'LBL_EMAIL_COFFEE_BREAK' => 'Kontrollerar ny email. <br><br>Stora emailkonton kan ta väldigt lång tid.',
    'LBL_EMAIL_COMMON' => 'Vanlig',

    'LBL_EMAIL_COMPOSE' => 'Email',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Var god ange mottagare för emailmeddelandet.',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'Associera med',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'Emailmeddelandet saknar text. Skicka ändå?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'Emailmeddelandet saknar Ämne. Skicka ändå?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(saknar ämne)',
    'LBL_EMAIL_COMPOSE_READ' => 'Läs & skapa email',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Skicka från emailkonto',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'Alternativ',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Var god skriv in giltiga emailadresser i Till-, CC-, och BCC-fälten',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'Ta bort det här emailmeddelandet?',
    'LBL_EMAIL_CONFIRM_DELETE' => 'Ta bort dessa poster från din adressbok?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'Är du säker på att du vill radera denna signatur?',

    'LBL_EMAIL_CREATE_NEW' => '--Skapa vid spara--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Multipla',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Tom',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Datum sänt av avsändaren',
    'LBL_EMAIL_DATE_RECEIVED' => 'Mottagardatum',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'Tilldelad till användare',
    'LBL_EMAIL_DATE_TODAY' => 'Idag',
    'LBL_EMAIL_DATE_YESTERDAY' => 'Igår',
    'LBL_EMAIL_DD_TEXT' => 'email vald.',
    'LBL_EMAIL_DEFAULTS' => 'Standard',
    'LBL_EMAIL_DELETE' => 'Radera',
    'LBL_EMAIL_DELETE_CONFIRM' => 'Radera valda meddelanden?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'Emailmeddande raderat.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'Raderar meddelande',
    'LBL_EMAIL_DETAILS' => 'Detaljer',
    'LBL_EMAIL_DISPLAY_MSG' => 'Visar email {0} - {1} av {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'Visar emailadress(er) {0} - {1} av {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'Redigera kontakt',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Endast den primära adressen kommer att användas vid arbete med kontakter.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'Redigera emaillistan',

    'LBL_EMAIL_EMPTYING_TRASH' => 'Töm papperskorgen',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'Raderar utgående server',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'Tömmer cache filer',
    'LBL_EMAIL_EMPTY_MSG' => 'Inga emailadresser visas.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'Ingen emailadress att visa.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'Katalognamn måste vara unikt och ej tomt. Var god försök igen.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'Kan inte radera katalogen. Katalogen eller underkatalogen har en mailbox associerad till den.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'Kan inte hitta den föreslagna mappen från sammanhanget. Försök igen.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Var god kontrollera dina inställningar.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Var god kontrollera att du skrev in ett efternamn.',
    'LBL_EMAIL_ERROR_DESC' => 'Fel upptäcktes:',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'Du har inte tillträde till detta område. Kontakta din administratör för att få tillträde.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugar katalognamn måste vara unika.',
    'LBL_EMAIL_ERROR_EMPTY' => 'Var god fyll i sökkriterie.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'Ett fel har uppstått.',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'En emaillista med det namnet finns redan',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Meddelande raderat från servern.',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'Meddelandet är borttaget från servern eller flyttat till en annan mapp.',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'Misslyckades att koppla upp mot servern. Var god kontakta din administratör',
    'LBL_EMAIL_ERROR_MOVE' => 'Flytt av email mellan servrar och/eller emailkonton stödjs ej för tillfället.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'Fel vid flytt',
    'LBL_EMAIL_ERROR_NAME' => 'Namn är obligatoriskt',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'Avsändaradress är obligatoriskt',
    'LBL_EMAIL_ERROR_NO_FILE' => 'Vänligen ange en fil',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'Att ändra namn på IMAP katalog stödjs ej för tillfället.',
    'LBL_EMAIL_ERROR_SERVER' => 'En emailserveradress krävs.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'Emailkontot har inte sparats.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'Ett fel uppstod vid kommunicering med emailservern.',
    'LBL_EMAIL_ERROR_USER' => 'Inloggningsnamn är obligatoriskt.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'Lösenord är obligatoriskt.',
    'LBL_EMAIL_ERROR_PORT' => 'Emailserverport är obligatoriskt.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'Serverprotokoll är obligatoriskt.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'Kontrollerad mapp krävs.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'Papperskorgsmapp krävs.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'Informationen är ej tillgänglig',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'Ingen utgående emailserver specificerad.',
    'LBL_EMAIL_FOLDERS' => 'Mappar',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'Flytta till',
    'LBL_EMAIL_FOLDERS_ADD' => 'Lägg till',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Lägg till ny katalog',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Döp om katalog',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Lägg till ny gruppkatalog',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Lägg till katalogen i',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'Denna katalog kan inte ändras',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'Är du säker på att du vill radera den här katalogen? Detta kan ej ångras.\nRaderandet av katalogen kommer påverka alla underliggande kataloger.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'Ny katalog.',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Var god välj en katalog innan du genomför denna åtgärd.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'Sugar kataloghantering.',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Användargrupp',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'Tilldela till team',
    'LBL_EMAIL_FORWARD' => 'Vidarebefodra',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => '[[count]] av [[total] email nerladdade',
    'LBL_EMAIL_FOUND' => 'Hittade',
    'LBL_EMAIL_FROM' => 'Från',
    'LBL_EMAIL_GROUP' => 'grupp',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'Grupp',
    'LBL_EMAIL_HOME_FOLDER' => 'Hem',
    'LBL_EMAIL_HTML_RTF' => 'Skicka HTML',
    'LBL_EMAIL_IE_DELETE' => 'Radera emailkonto',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'Raderar signatur',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'Är du säker på att du vill radera emailkontot?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Radering genomförd.',
    'LBL_EMAIL_IE_SAVE' => 'Sparar emailkontots information',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'Importera email',
    'LBL_EMAIL_IMPORT_EMAIL' => 'Importera till Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'Importera inställningar',
    'LBL_EMAIL_INVALID' => 'Ogiltig',
    'LBL_EMAIL_LINK_RECORD' => 'Klicka här',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'Döp om emaillistan',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'Sätt ett namn på emaillistan',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'Ta bort dessa poster från din emaillista?',
    'LBL_EMAIL_LOADING' => 'Laddar...',
    'LBL_EMAIL_MARK' => 'Markera',
    'LBL_EMAIL_MARK_FLAGGED' => 'Som flaggat',
    'LBL_EMAIL_MARK_READ' => 'Som läst',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'Som oflaggat',
    'LBL_EMAIL_MARK_UNREAD' => 'Som oläst',
    'LBL_EMAIL_ASSIGN_TO' => 'Tilldela till',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'Skapa katalog',
    'LBL_EMAIL_MENU_COMPOSE' => 'Skapa till',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Radera katalog',
    'LBL_EMAIL_MENU_EDIT' => 'Redigera',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Töm papperskorgen',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Synkronisera',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Töm cache filer',
    'LBL_EMAIL_MENU_REMOVE' => 'Ta bort',
    'LBL_EMAIL_MENU_RENAME' => 'Döp om',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Döp om katalog',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Döper om katalog',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Var god gör ett urval innan du kan genomföra denna åtgärd.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Skapa en katalog (fjärrstyrt eller i Sugar)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'Arkivera dessa emailmeddelanden till SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'Skicka email till valda emaillistor',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'Skicka email till kontakten',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Radera kontakten',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'Radera dessa emailmeddelanden',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Radera katalogen (fjärrstyrt eller i Sugar)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Redigera en kontakt',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Redigera en emaillista',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Tömmer alla papperskorgar för dina emailkonton',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'Markera dessa email som flaggade',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'Markera dessa emailmeddelanden som lästa',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'Markera dessa email som oflaggade',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'Markera dessa emailmeddelanden som olästa',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Radera emaillistor',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Byt namn på en katalog (fjärrstyrt eller från Sugar)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'Svara dessa emailmeddelande(n)',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'Svara alla mottagare för dessa emailmeddelanden',

    'LBL_EMAIL_MESSAGES' => 'meddelanden',

    'LBL_EMAIL_ML_NAME' => 'Listnamn',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'Valda listadresser',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'Tillgängliga listadresser',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-Klick</b> för att välja flera<br />(Mac användare använd <b>CMD-Click</b>)',

    'LBL_EMAIL_NO' => 'Nej',
    'LBL_EMAIL_NOT_SENT' => 'Systemet kan inte processa din begäran. Var snäll och kontakta din system administratör',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'Kunde inte sätta in i users_password_link.',

    'LBL_EMAIL_OK' => 'OK',
    'LBL_EMAIL_ONE_MOMENT' => 'Ett ögonblick...',
    'LBL_EMAIL_OPEN_ALL' => 'Öppna flera meddelanden',
    'LBL_EMAIL_OPTIONS' => 'Alternativ',
    'LBL_EMAIL_QUICK_COMPOSE' => 'Snabb skapa',
    'LBL_EMAIL_OPT_OUT' => 'Önskar ej utskick',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Bortvald och Ogiltig',
    'LBL_EMAIL_PAGE_AFTER' => 'av {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'Sida',
    'LBL_EMAIL_PERFORMING_TASK' => 'Genomför uppgift',
    'LBL_EMAIL_PRIMARY' => 'Primär',
    'LBL_EMAIL_PRINT' => 'Skriv ut',

    'LBL_EMAIL_QC_BUGS' => 'Bugg',
    'LBL_EMAIL_QC_CASES' => 'Ärende',
    'LBL_EMAIL_QC_LEADS' => 'Möjlig kund',
    'LBL_EMAIL_QC_CONTACTS' => 'Kontakt',
    'LBL_EMAIL_QC_TASKS' => 'Uppgift',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'Affärsmöjlighet',
    'LBL_EMAIL_QUICK_CREATE' => 'Snabbskapa',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'Återuppbygger kataloger',
    'LBL_EMAIL_RELATE_TO' => 'Relatera',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'Se relationer',
    'LBL_EMAIL_RECORD' => 'Emailmeddelanden',
    'LBL_EMAIL_REMOVE' => 'Radera',
    'LBL_EMAIL_REPLY' => 'Svara',
    'LBL_EMAIL_REPLY_ALL' => 'Svara alla',
    'LBL_EMAIL_REPLY_TO' => 'Svara till',
    'LBL_EMAIL_RETRIEVING_LIST' => 'Tar emot emaillista',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Tar emot meddelande',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'Mottager emailmeddelanden',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Var snäll och välj endast ett emailmeddelande',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'Återgå till tidigare modul?',
    'LBL_EMAIL_REVERT' => 'Återgå',
    'LBL_EMAIL_RELATE_EMAIL' => 'Relatera email',

    'LBL_EMAIL_RULES_TITLE' => 'Regelhantering',

    'LBL_EMAIL_SAVE' => 'Spara',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'Spara & svara',
    'LBL_EMAIL_SAVE_DRAFT' => 'Spara utkast',

    'LBL_EMAIL_SEARCHING' => 'Genomför sökning',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'Avancerad sökning',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'Från datum',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Till datum',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'Meddelandetext',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'Inget resultat matchade det valda sökkriteriet',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Sökresultat',
    'LBL_EMAIL_SEARCH_TITLE' => 'Enkel sök',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'Sök emailkonto',

    'LBL_EMAIL_SELECT' => 'Välj',

    'LBL_EMAIL_SEND' => 'Skicka',
    'LBL_EMAIL_SENDING_EMAIL' => 'Skickar email',

    'LBL_EMAIL_SETTINGS' => 'Inställningar',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 rader',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 kolumner',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'Layout stil',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'Emailkonton',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Rensa formulär',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'Importera email i samband med visning',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Hämta ny email',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Använd förhandsvisningspanelen',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Använd pop-up fönster',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'Antal emailmeddelanden per sida',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'Redigera emailkonto',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'Mappar',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'Från adress',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'Emailadress för testmeddelanden:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'Till emailadress',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'Från namn',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Svara till address',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Fullskärm',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Synkronisera alla emailkonton',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'Ett email skickades till angiven emailadress med hjälp av utgående serverinställningar. Se till att emailet togs emot och att inställningarna är korrekta.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Denna åtgärd kommer synkronisera alla emailkonton och deras innehåll.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'Genomföra en full synkronisering?\nStora emailkonton kan ta några minuter.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Håll nere shift eller ctrl för att markera multipla mappar.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'Allmänt',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Tillgängliga gruppkataloger',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Skapa gruppkataloger',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Spara gruppkataloger',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Hämtar gruppkatalog',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Redigera gruppkatalog',

    'LBL_EMAIL_SETTINGS_NAME' => 'Namn',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Dessa inställningar kan kräva att sidan uppdateras för att de ska aktiveras.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'Hämtar emailkonto',
    'LBL_EMAIL_SETTINGS_RULES' => 'Regler',
    'LBL_EMAIL_SETTINGS_SAVED' => 'Inställningarna har sparats.\n\nDu måste ladda om sidan för att inställningarna ska börja gälla.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'Du måste ladda om sidan för att de nya inställningarna ska börja gälla.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'Skicka email i oformaterad text',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Aktiva emailkonton',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'Antal emailmeddelanden per sida',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'Placera flikar längst ned',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Visuella inställningar',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Inställningar',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Visa avancerad',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Tillgängliga kataloger',
    'LBL_EMAIL_ERROR_PREPEND' => 'Fel:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'Den utgående emailservern du valt för kontot är felaktig. Kontrollera inställningarna eller använd en annan emailserver för emailkontot.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'Det finns ingen utgående emailserver konfigurerad. Var snäll och konfigurera en utgående emailserver eller välj en befintlig emailserver för kontot du använder i Inställningar >> Emailkonto.',
    'LBL_EMAIL_SHOW_READ' => 'Visa alla',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Visa endast olästa',
    'LBL_EMAIL_SIGNATURES' => 'Signaturer',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'Skapa signatur',
    'LBL_EMAIL_SIGNATURE_NAME' => 'Signatur namn',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'Signaturinnehåll',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Mindre säkra Google-appar',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'Annan',
    'LBL_EMAIL_AUTHORIZE' => 'Auktorisera',
    'LBL_EMAIL_AUTHORIZED' => 'Auktoriserad',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'Ej auktoriserad',
    'LBL_EMAIL_AUTH_WARNING' => 'En administratör måste konfigurera {0} Samordnare via Admin > Samordnare innan du kan konfigurera detta konto. För ytterligare information, se dokumentationen {1}.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'Fel vid hämtning av konnektorinformation',
    'LBL_EMAIL_AUTH_FAILURE' => 'Auktoriseringsfel.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'Auktorisera kontot innan du sparar.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'Auktorisera kontot innan du testar.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'Kontot är inte auktoriserat',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Fjärrkataloger ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugar katalog ]',
    'LBL_EMAIL_SUBJECT' => 'Ämne',
    'LBL_EMAIL_SUCCESS' => 'Genomfört',
    'LBL_EMAIL_SUGAR_FOLDER' => 'Sugarkatalog',
    'LBL_EMAIL_TEAMS' => 'Tilldela till team',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'Emailmallen är tom',
    'LBL_EMAIL_TEMPLATES' => 'Mallar',
    'LBL_EMAIL_TEXT_FIRST' => 'Första sidan',
    'LBL_EMAIL_TEXT_PREV' => 'Föregående sida',
    'LBL_EMAIL_TEXT_NEXT' => 'Nästa sida',
    'LBL_EMAIL_TEXT_LAST' => 'Sista sidan',
    'LBL_EMAIL_TEXT_REFRESH' => 'Uppdatera',
    'LBL_EMAIL_TO' => 'Till',
    'LBL_EMAIL_TOGGLE_LIST' => 'Dölj /  Visa lista',
    'LBL_EMAIL_VIEW' => 'Visa',
    'LBL_EMAIL_VIEWS' => 'Vyer',
    'LBL_EMAIL_VIEW_HEADERS' => 'Visa header',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'Utskriftsvänlig version',
    'LBL_EMAIL_VIEW_RAW' => 'Visa källa',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'Den här funktionen stöds inte om du använder POP3.',
    'LBL_DEFAULT_LINK_TEXT' => 'Standard länk-text.',
    'LBL_EMAIL_YES' => 'Ja',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Skicka ett test meddelande',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Test meddelande skickat',


    'LBL_EMAIL_MESSAGE_NO' => 'Meddelande nummer',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'Import utförd',
    'LBL_EMAIL_IMPORT_FAIL' => 'Importen har avslutats eftersom emailmeddelandet redan är importerat eller borttaget från servern',

    'LBL_EMAILS_FROM' => 'E-postmeddelanden skickade',
    'LBL_EMAILS_RECEIVED' => 'Mottagna e-postmeddelanden',
    'LBL_EMAIL_ADDRESSES_USED' => 'E-postadresser används i e-postmeddelanden',
    'LBL_EMAIL_ADDRESS' => 'E-postadress',
    'LBL_FROM' => 'Från',
    'LBL_TO' => 'Till',
    'LBL_CC' => 'CC',
    'LBL_BCC' => 'BCC',

    'LBL_START_DATE' => 'Startdatum',
    'LBL_END_DATE' => 'Slutdatum',
    'LBL_START' => 'Start',
    'LBL_END' => 'Slut',
    'LBL_DATE_LINKED' => 'Anslutningsdatum',

    'LBL_LINK_NONE' => 'Ingen',
    'LBL_LINK_ALL' => 'Alla',
    'LBL_LINK_RECORDS' => 'Poster',
    'LBL_LINK_SELECT' => 'Välj',
    'LBL_LINK_ACTIONS' => 'Händelser',
    'LBL_LINK_MORE' => 'Mer',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'Bekräfta:',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'Vill du fortsätta stänga denna #mnodule#?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'Visa inte detta meddelande i framtiden:',
    'LBL_INVALID_FILE_EXTENSION' => 'Ogiltig Fil Expansion',
    'LBL_LIST_TEAM' => 'Lag',
    'LBL_TEAM' => 'Lag:',
    'LBL_TEAMS' => 'Teams',
    'LBL_TEAM_SET_ID' => 'Team ID',
    'LBL_TEAM_SET_SELECTED_ID' => 'Valt teams start-ID',
    'LBL_TEAM_SET_SELECTED' => 'Valda',
    'LBL_TEAM_SET_ENABLE' => 'Aktivera ytterligare behörigheter',
    'LBL_TEAM_SET_DISABLE' => 'Inaktivera ytterligare behörigheter',
    'LBL_TEAM_SET' => 'Team',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'Valda team',
    'LBL_SEARCH_UNAVAILABLE' => 'Sökning otillgänglig, vänligen försök igen senare.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'Inget primärt team är valt',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'Fel det går ej att ta bort primärt team [{0}] för [{1}] modulen med id [{2}]',
    'LBL_TEAM_ADD' => 'Lägga till Team',
    'LBL_TEAM_REMOVE' => 'Ta bort Team',
    'LBL_TEAM_PRIMARY' => 'Ange som primärt team',

    'LBL_CLOSE_BUTTON_LABEL' => 'Stäng',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} markerade som {{status}}.',

    'LBL_FOCUS' => 'Fokus',

    'LBL_QUERY_VALID' => 'Giltig',
    'LBL_QUERY_ERROR' => 'Fel!',
    'LBL_QUERY_CHILD' => 'Giltig underfråga',
    'ERROR_EXAMINE_MSG' => 'Kontrollera felmeddelandet nedan:',
    'NO_QUERY_SELECTED' => 'Det dataformat du har valt innehåller inte en query. Vänligen välj en custom query för det här dataformatet.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'Ett fel har uppstått:',
    'ERR_AJAX_LOAD_FAILURE' => 'Ett fel uppstod under behandlingen av din begärand, vänligen försök igen senare.',
    'ERR_AJAX_LOAD_FOOTER' => 'Om ett fel består, vänligen be din administratör avaktivera Ajax för den här modulen.',
    'ERR_CREATING_FIELDS' => 'Fel vid ifyllande av fält för ytterligare detaljer:',
    'ERR_CREATING_TABLE' => 'Fel vid skapande av tabell:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'Decimaltalsseparatorn kan inte vara samma tecken som för tusentalsseparatorn.

 Vänligen ändra värdena.',
    'ERR_DELETE_RECORD' => 'Ett objektnummer måste specificeras för att radera kontakten.',
    'ERR_EXPORT_DISABLED' => 'Exporter avaktiverade',
    'ERR_EXPORT_TYPE' => 'Fel vid export',
    'ERR_REPORTS_DISABLED_EXPORT' => 'Rapportexport har inaktiverats',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'Endast administratörsanvändare kan exportera',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'Rapporten använder moduler utan exportåtkomst',
    'ERR_REPORTS_EXPORT_OWNER' => 'Rapporten använder moduler med åtkomst för ägarexport',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'Rapporten använder moduler med begränsad åtkomst för listor',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'Rapporten använder moduler med begränsad åtkomst för visning',
    'ERR_REPORTS_ACCESS_DISABLED' => 'Rapporten använder moduler med begränsad åtkomst',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'Rapporten använder fält med begränsad åtkomst',
    'ERR_INVALID_AMOUNT' => 'Var god fyll i en giltig summa.',
    'ERR_INVALID_DATE_FORMAT' => 'Datumformatet måste vara:',
    'ERR_INVALID_DATE' => 'Vad god fyll i ett giltigt datum.',
    'ERR_INVALID_DAY' => 'Var god fyll i en giltig dag',
    'ERR_INVALID_EMAIL_ADDRESS' => 'inte en giltig emailadress.',
    'ERR_INVALID_FILE_REFERENCE' => 'Ogiltig filreferens',
    'ERR_INVALID_HOUR' => 'Var god fyll i en giltig timme.',
    'ERR_INVALID_MONTH' => 'Var god fyll i en giltig månad.',
    'ERR_INVALID_TIME' => 'Var god fyll i en giltig tid.',
    'ERR_INVALID_YEAR' => 'Skriv in ett giltigt fyrsiffrigt år.',
    'ERR_NEED_ACTIVE_SESSION' => 'Det krävs en aktiv session för att exportera innehållet.',
    'ERR_NO_HEADER_ID' => 'Den här funktionen är inte tillgänglig i det här temat.',
    'ERR_NOT_ADMIN' => 'Obehörig åtkomst till administrationen.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'Lösenordshantering är endast tillgänglig i <a href="%s" target="_blank">Inställningar för SugarCloud</a>.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'Vänligen kontakta din Sugar-administratör om du vill ändra i fälten som bara kan läsas.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'Öppna <a href="{0}" target="_blank">Inställningar för SugarCloud</a> för att göra ändringar i skrivskyddade fält.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'Saknar obligatoriskt fält:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'Felaktigt obligatoriskt fält:',
    'ERR_INVALID_VALUE' => 'Ogiltigt värde:',
    'ERR_NO_SUCH_FILE' => 'Filen existerar inte i systemet',
    'ERR_NO_SINGLE_QUOTE' => 'Kan inte använda enkelt citationstecken för',
    'ERR_NOTHING_SELECTED' => 'Vänligen gör ett urval innan du fortsätter.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'En affärsmöjlighet med namnet %s finns redan. Var god välj ett annat namn nedan.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'Inget namn för affärsmöjligheten fylldes i. Var god fyll i ett namn på affärsmöjligheten nedan.',
    'ERR_QUOTE_CONVERTED' => 'Denna offert har redan omvandlats till en affärsmöjligheten.',
    'ERR_POTENTIAL_SEGFAULT' => 'Ett potentiellt Apache segmentation fault upptäcktes.  Vänligen meddela din systemadministratör för att bekräfta problemet och rapportera det till SugarCRM.',
    'ERR_SELF_REPORTING' => 'En användare kan inte rapportera till sig själv.',
    'ERR_SINGLE_QUOTE' => 'Kan inte använda enkelt citationstecken för det här fältet. Vänligen ändra värdet.',
    'ERR_SQS_NO_MATCH_FIELD' => 'Ingen matchning för fältet:',
    'ERR_SQS_NO_MATCH' => 'Ingen matchning',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Vänligen definiera &#39;key&#39; index i displayParams attributet för Meta-Data definitionen',
    'ERR_EXISTING_PORTAL_USERNAME' => 'Error: Portalnamnet är redan tilldelad till en annan kontakt.',
    'ERR_PORTAL_NAME_CHECK' => 'Det går inte att kontrollera att Portal användarnamn är unikt',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'Fältvärdet har inte tillräckligt noggrannhet',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'Ett fel uppstod under försöket att spara till externt konto.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'Ett fel uppstod under uppladdningen. Vänligen se till att filen du försöker ladda upp inte är tom.',
    'ERR_NO_DB' => 'Kunde ej koppla upp mot databasen. Var god se sugarcrm.log för detaljer',
    'ERR_DB_FAIL' => 'Databas fel. Var god se sugarcrm.log för detaljer',
    'ERR_EXTERNAL_API_403' => 'Åtkomst Nekad. Stödjer ej filtypen.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth Access Token saknas.',
    'ERR_DB_VERSION' => 'Sugar CRM {0} Filer Ska Endast Användas Med Sugar CRM {1} Databas.',
    'ERR_DB_QUERY' => '{0}: sökfråga misslyckades: {1}',
    'ERR_UW_RETIRED' => 'Upgrade Wizard är inte tillgänglig i den här versionen.',
    'ERR_NOT_CLOUD_INSTANCE' => 'Denna instans av Sugar är antingen ingen SugarCloud-instans eller är inte konfigurerad för SugarCloud Insights.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'Du har inte behörighet att skapa {moduleName}. Kontakta din administratör om du behöver åtkomst.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'Nuvarande användaren inte rätt att ändra {module} konfigurationsinställningar',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'Nuvarande användaren har inte rätt att ändra {moduleName} konfigurationsinställningar',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'Du har inte behörighet att skapa en favorit {moduleName}. Kontakta administratören om du behöver tillgång.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'Du har inte behörighet att prenumerera på {moduleName}. Kontakta administratören om du behöver tillgång.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'worksheet_columns_related_fields hittades inte i nyttolast',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns är inte en matris',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'summary_columns_related_fields hittades inte i nyttolast',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows är inte en matris',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rows_related_fields hittades inte i nyttolast',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'Din begäran misslyckades av ett okänt undantag.',
    'EXCEPTION_FATAL_ERROR' => 'Din begäran misslyckades att fullföljas. Ett fatalt fel uppstod. Se loggar för fler detaljer.',
    'EXCEPTION_NEED_LOGIN' => 'Du måste logga in för att utföra den här handlingen.',
    'EXCEPTION_INVALID_TOKEN' => 'Din autentiseringstoken är ogiltig.',
    'EXCEPTION_NOT_AUTHORIZED' => 'Du har inte behörighet att utföra den här handlingen. Kontakta din administratör om du behöver åtkomst.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'Du har inte behörighet att se data. Kontakta din administratör om du behöver åtkomst.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'Du kan inte nå Portal för ditt portal konto är felaktigt. Vänligen kontakta kundservice om du behöver åtkomst.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'Portal är inte konfigurerad rätt. Kontakta din Portal Administratör för hjälp.',
    'EXCEPTION_NO_METHOD' => 'Din begäran stöds inte. Kunde inte hitta HTTP metoden av din begäran för den här pathen.',
    'EXCEPTION_NOT_FOUND' => 'Din begärda resurs hittades inte. Kunde inte hitta hanterare för den path som specificerades i din begäran.',
    'EXCEPTION_MISSING_PARAMTER' => 'En nödvändig parameter missades i din begäran.',
    'EXCEPTION_INVALID_PARAMETER' => 'En parameter i din begäran var ogiltig.',
    'EXCEPTION_REQUEST_FAILURE' => 'Din begäran misslyckades att fullföljas.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'Din metadata eller användare hash matchade inte servern. Vänligen synkronisera din metadata.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'Din begäran är för stor att hantera.',
    'EXCEPTION_EDIT_CONFLICT' => 'Redigera konflikt, vänligen ladda postdata.',
    'EXCEPTION_METADATA_CONFLICT' => 'Metadata konflikt, vänligen ladda om metadata.',
    'EXCEPTION_CLIENT_OUTDATED' => 'Programvaran är för gammal, uppdatera din klient innan du försöker ansluta igen.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'En anslutning eller en integrationsförfrågan kom fram, men misslyckades.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM är i underhållsläge. Endast administratörer kan logga in. Kontakta administratören för mer information.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'Servern kan inte hantera din förfrågan just nu, eftersom den är upptagen eller otillgänglig.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'Sökmotorn är tillfälligt otillgänglig.',
    'EXCEPTION_SEARCH_RUNTIME' => 'Ett fel uppstod vid körning av sökmotorn. Kontakta din systemadministratör.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'Ett fält som är låst av en process kan inte redigeras.',
    'EXCEPTION_MODULE_DISABLED' => 'Denna modul är inaktiverad för den aktuella användaren.',
    'EXCEPTION_FIELD_DISABLED' => 'Detta fält är inaktiverat för den aktuella användaren.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'Den här klienten är inte tillåten',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'Möjligheten att ladda upp paket är inte tillgänglig för din licenstyp',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'Ett tillstånd inträffade på grund av ett allmänt fel eller misstag. Skälen för undantaget intervall men generellt faller utanför ramen för en mer specifik undantags API.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'Begäran kunde inte bearbetas som presenteras eller det fanns ett fel med svaret. Detta innebär i allmänhet ett allvarligt fel inträffat och att den specifika fel kan identifieras i programloggen.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'Den version av API som du använder är inte korrekt för den aktuella begäran.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'Den begärda endpoint kräver verifiering och den begärande konsumenten har ännu inte verifierats.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'Anger att autentisering token presenteras med begäran är ogiltig. Detta händer i allmänhet på grund av den token som löper ut, men kan också bero på att token är missbildad eller är felaktig.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'Indikerar att den begärda konsumenten inte har rätt att utföra den begärda åtgärden.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'Portalen med konto kopplat till den inloggade användaren är inte aktiv. Detta kräver åtgärder av kundsupport.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'Indikerar att portal ansökan inte är korrekt konfigurerad och kan inte användas. Detta kräver åtgärder frånportaladministratören.',
    'EXCEPTION_NO_METHOD_DESC' => 'Slutpunkten stöder inte typen HTTP-begäran som görs. Detta kan hända när en POST begäran görs till en slutpunkt konstruerad för en GET-begäran till exempel.',
    'EXCEPTION_NOT_FOUND_DESC' => 'Slutpunkten kunde inte hitta en resurs för ansökan eller inte har en hanterare för begäran.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'Anger att det kan ha funnits parallella ändringar i en post och den aktuella begäran att redigera posten skulle påverka en tidigare redigering av posten.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'Anger att metadata på servern inte matchar metadata klienten använder för tillfället. Detta kan inträffa efter en ändring av systeminställningar, ändringar av moduler i Studio eller användning av nya moduler, bland annat systemförändringar.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'Begäran är för stor för att hanteras av servern.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'Obligatorisk parameter för begäran saknas.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'Indikerar en parameter skickat i begäran är ogiltig.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'Begäran misslyckades.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'Indikerar att kunden som konsumerar API är inaktuell och måste uppdateras innan ytterligare konsumtion av API kan ske.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'Indikerar att en begäran gjord via API:et till en annan tjänst, slutpunkt eller URI har misslyckats eller inte kunde hanteras av servern.',
    'EXCEPTION_MAINTENANCE_DESC' => 'Den instans av SugarCRM som som betjänar API är i underhållsläge. Tillgång till API är begränsad till endast administratörer.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'Indikerar att servern är upptagen, överbelastad eller nere.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'Sökmotorns backend är tillfälligt otillgänglig på grund av ett anslutningsfel. Kontrollera din anslutning och konfiguration i Admin->sök->test.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'Ett körtidsfel uppstod i SearchEngine. Se sugarcrm.log för mer information.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'Ett fält som för närvarande är låst av pågående process kan inte redigeras.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s är låst av en pågående process och kan inte redigeras.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s är låst av en pågående process och kan inte redigeras.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'Denna modul är inaktiverad för den aktuella användaren.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'Detta fält är inaktiverat för den aktuella användaren.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'Den här klienten är inte tillåten',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'En fil med samma namn existerar redan i systemet.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'Fel Tidsperiod odefinierat för datum {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'Denna tidsperiod har redan underperioder',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'Undertidsperioder kan inte ha underperioder',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'Det gick inte att hämta någon Tidsperioder typ: {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'Inga aktiva tidsperioder för aktuella inställningar.',
    'LBL_CURRENT_TIMEPERIOD' => 'Aktuell tidsperiod',
    'LBL_PREVIOUS_TIMEPERIOD' => 'Föregående tidsperiod',
    'LBL_NEXT_TIMEPERIOD' => 'Nästa tidsperiod',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'Tidigare, Nuvarande, Nästa',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'Du kan inte radera objekt som har en stängd säljfas.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'Du kan inte radera objekt som har en stängd säljfas.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'En eller flera av de valda objekten har en säljfas som är antingen stängd vunnen eller stängd förlorad, och dessa objekt kan därför inte raderas.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'En eller flera av de valda objekten har en säljfas som är antingen stängd vunnen eller stängd förlorad, och dessa objekt kan därför inte raderas.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'Organisation',
    'LBL_OLD_ACCOUNT_LINK' => 'Gamla organisationer',
    'LBL_ACCOUNTS' => 'Organisationer',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Aktiviteter',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Se sammanställning',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Se sammanställning [ALT+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Lägg till [Alt+A]',
    'LBL_ADD_BUTTON' => 'Lägg till',
    'LBL_ADD_DASHLET_BUTTON' => 'Lägg till dashlet',
    'LBL_ADD_DOCUMENT' => 'Lägg till dokument',
    'LBL_REPLACE_BUTTON' => 'Byt ut',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Lägg till i mållista',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Lägg till i mållista',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Klicka för stäng',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Stäng',
    'LBL_ADDITIONAL_DETAILS' => 'Ytterligare detaljer',
    'LBL_ADMIN' => 'Admin',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'Arkiv',
    'LBL_ASSIGNED_TO_USER' => 'Tilldelad till användare',
    'LBL_ASSIGNED_TO' => 'Tilldelad till:',
    'LBL_BACK' => 'Tillbaka',
    'LBL_BASE_RATE' => 'Basräntan',
    'LBL_BILL_TO_ACCOUNT' => 'Fakturera organisation',
    'LBL_BILL_TO_CONTACT' => 'Fakturera kontakt',
    'LBL_BILLING_ADDRESS' => 'Faktureringsadress',
    'LBL_QUICK_CREATE_TITLE' => 'Snabbskapa',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'Buggar',
    'LBL_BY' => 'av',
    'LBL_CALLS' => 'Telefonsamtal',
    'LBL_CALL' => 'Telefonsamtal',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Skicka köade kampanjmail',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Spara',
    'LBL_CASE' => 'Ärende',
    'LBL_CASES' => 'Ärenden',
    'LBL_MESSAGE' => 'Meddelande',
    'LBL_MESSAGES' => 'Meddelanden',
    'LBL_ESCALATIONS' => 'Upptrappningar',
    'LBL_ESCALATION' => 'Eskalering',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign-kuvert',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign-kuvert',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'Välj signeringsmottagare',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'Ändra lösenord',
    'LBL_CHANGE_BUTTON_LABEL' => 'Ändra',
    'LBL_CHANGE_BUTTON_TITLE' => 'Ändra [Alt+G]',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Kryssa i alla',
    'LBL_CITY' => 'Stad',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Rensa',
    'LBL_CLEAR_BUTTON_TITLE' => 'Rensa [Alt+C]',
    'LBL_CLEARALL' => 'Rensa alla',
    'LBL_CLICK_TO_EDIT' => 'Klicka för att redigera',
    'LBL_CLOSE_BUTTON_TITLE' => 'Stäng',
    'LBL_CLOSE_BUTTON_KEY' => 'C',
    'LBL_CLOSE_WINDOW' => 'Stäng fönster',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Stäng alla',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Stäng alla [Alt+I]',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Stäng och skapa ny',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Stäng och skapa ny',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'Kopiera postens URL',
    'LBL_OPEN_ITEMS' => 'Öppna Objekt:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Skriv email',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'E-post',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Skriv email',
    'LBL_SEARCH_DROPDOWN_YES' => 'Ja',
    'LBL_SEARCH_DROPDOWN_NO' => 'Nej',
    'LBL_CONTACT_LIST' => 'Kontaktlista',
    'LBL_CONTACT' => 'Kontakt',
    'LBL_CONTACTS' => 'Kontakter',
    'LBL_CONTRACTS' => 'Kontrakt',
    'LBL_COUNTRY' => 'Land:',
    'LBL_RESET_BUTTON_LABEL' => 'Återställ',
    'LBL_CREATE_BUTTON_LABEL' => 'Skapa',
    'LBL_CREATED_BY_USER' => 'Skapad av användare',
    'LBL_CREATED_USER' => 'Skapad av användare',
    'LBL_CREATED_ID' => 'Skapad av ID',
    'LBL_CREATED' => 'Skapad av',
    'LBL_CREATE_NEW_TARGET_LIST' => 'Skapa ny mållista',
    'LBL_CURRENT_USER_FILTER' => 'Endast mina tilldelade:',
    'LBL_CURRENCY' => 'Valuta:',
    'LBL_CURRENCIES' => 'Valutor',
    'LBL_CURRENCY_NAME' => 'Valutanamn',
    'LBL_CURRENCY_SYMBOL' => 'Valutasymbol',
    'LBL_CURRENCY_RATE' => 'Valutakurs',
    'LBL_CURRENCY_ID' => 'Valuta ID',
    'LBL_DOCUMENTS' => 'Dokument',
    'LBL_DATE_ENTERED' => 'Skapat datum',
    'LBL_DATE_MODIFIED' => 'Senast redigerad:',
    'LBL_ACTIVITY_MODIFIED' => 'Ändrades',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'Redigera översiktsflik',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'Redigera modulflikar',
    'LBL_EDIT_BUTTON' => 'Redigera',
    'LBL_DUPLICATE_BUTTON' => 'Duplicera',
    'LBL_DELETE_BUTTON' => 'Radera',
    'LBL_DELETE' => 'Radera',
    'LBL_DELETED' => 'Raderad',
    'LBL_DIRECT_REPORTS' => 'Direktrapporter',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Klar',
    'LBL_DONE_BUTTON_TITLE' => 'Klar [Alt+X]',
    'LBL_DST_NEEDS_FIXIN' => 'Den här applikationen behöver en sommartidsfix för att användas.  Vänligen gå till<a href="index.php?module=Administration&action=DstFix">Repair</a> länken i adminkonsollen och lägg till sommartidsinställningsfixen.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Editera som ny',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Editera som ny',
    'LBL_EDIT_IN_NEW_TAB' => 'Redigera i ny flik',
    'LBL_FAVORITES' => 'Favoriter',
    'LBL_FILTER' => 'Filter',
    'LBL_DEFAULT_DATA_FILTER' => 'Standarddatafilter',
    'LBL_FILTER_MENU_BY' => 'Filtrera Meny',
    'LBL_FILTER_SELECT_FIELD' => 'Välj fält...',
    'LBL_FILTER_SELECT_OPERATOR' => 'Välj operatör...',
    'LBL_FILTER_CREATE_NEW' => 'Skapa',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'Bygg filter (osparade)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(Osparade)',
    'LBL_FILTER_CREATE_FILTER' => 'Skapa nytt filter',
    'LBL_FILTER_CLOSE_FILTER' => 'Stäng filtret',
    'LBL_FILTER_EDIT_FILTER' => 'Redigera filter',
    'LBL_FILTER_ALL_RECORDS' => 'Alla poster',
    'TPL_FILTER_SAVE' => 'Du skapat filtret {{name}}.',
    'LBL_FILTER_BETWEEN_FROM' => 'Från',
    'LBL_FILTER_BETWEEN_TO' => 'Till',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'Startdatum',
    'LBL_FILTER_DATEBETWEEN_TO' => 'Slutdatum',
    'LBL_FOLLOWING' => 'Följer',
    'LBL_UNFOLLOW' => 'Sluta följa',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'Ladda ner vCard',
    'LBL_EMPTY_VCARD' => 'Vänligen välj vCard fil',
    'LBL_IMAGE' => 'Bild',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard har inte alla obligatoriska fält för denna modul.',
    'LBL_VCARD_ERROR_FILESIZE' => 'Den uppladdade filen överskrider 30000 bytes storleksgräns som anges i HTML-formuläret.',
    'LBL_VCARD_ERROR_DEFAULT' => 'Det uppstod ett fel vid uppladdning vCard-filen.',
    'TPL_IMPORT_VCARD_FAILURE' => 'Det gick inte att skapa {{module}} från vCard',
    'LBL_IMPORT_VCARD' => 'Importera vCard',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'Importera vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'Importera vCard [Alt+I]',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'Visa',
    'LBL_VIEW_BUTTON_TITLE' => 'Visa [Alt+V]',
    'LBL_VIEW_BUTTON' => 'Visa',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'Emaila som PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'Emaila som PDF',
    'LBL_EMAIL' => 'Email',
    'LBL_EMAILS' => 'Email',
    'LBL_EMPLOYEES' => 'Anställda',
    'LBL_ENTER_DATE' => 'Fyll i datum',
    'LBL_EXPORT_ALL' => 'Exportera alla',
    'LBL_EXPORT' => 'Exportera',
    'LBL_FAVORITES_FILTER' => 'Mina favoriter:',
    'LBL_GLOBAL_SEARCH' => 'Global Sök',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'Globalt sök modul filter',
    'LBL_GLOBAL_SEARCH_RUN' => 'Kör globalt sök',
    'LBL_GO_BUTTON_LABEL' => 'Kör',
    'LBL_GS_HELP' => 'Fälten i den här modulen användes i sökvillkoret ovanför. Den markerade texten matchar ditt sökkritere.',
    'LBL_HIDE' => 'Dölj',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => 'Importera',
    'LBL_IMPORT_STARTED' => 'Import startad:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Måste specificera en avgränsare',
    'LBL_LAST_VIEWED' => 'Senast visade',
    'LBL_SELECTED_RECORDS' => 'Vald: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Endast {{maxPillsDisplayed}} poster visas.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} till poster markerade.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} poster valda.',
    'LBL_SHOW_LESS' => 'Visa Mindre',
    'LBL_SHOW_MORE' => 'Visa mer',
    'LBL_SHOW_MORE_MODULE' => 'Fler',
    'LBL_SHOW_MORE_RECENTS' => 'Fler Sentida...',
    'LBL_SHOW_LESS_RECENTS' => 'Mindre Sentida...',
    'LBL_SHOW_MORE_RESULTS' => 'Fler sökresultat...',
    'TPL_SHOW_MORE_MODULE' => 'Fler {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => 'Mer {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => 'Aktiviteter idag',
    'LBL_LEADS' => 'Leads',
    'LBL_LEAD' => 'Möjlig kund',
    'LBL_QUOTES_BILL_TO' => 'Offerter (fakturera till)',
    'LBL_LESS' => 'mindre',
    'LBL_CAMPAIGN' => 'Kampanj:',
    'LBL_CAMPAIGNS' => 'Kampanjer',
    'LBL_CAMPAIGNLOG' => 'Kampanjlogg',
    'LBL_CAMPAIGN_CONTACT' => 'Kampanjer',
    'LBL_CAMPAIGN_ID' => 'campaign_id',
    'LBL_THEME' => 'Tema:',
    'LBL_THEME_PICKER' => 'Sid tema',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Varning: Internet Explorer 6 stöds inte av valt tema. Klicka på OK för att välja det ändå och Avbryt för att välja ett annat tema.',
    'LBL_FOUND_IN_RELEASE' => 'Funnen i release',
    'LBL_FIXED_IN_RELEASE' => 'Fixad i release',
    'LBL_LIST_ACCOUNT_NAME' => 'Organisationsnamn',
    'LBL_LIST_ASSIGNED_USER' => 'Användare',
    'LBL_LIST_CONTACT_NAME' => 'Kontaktnamn',
    'LBL_LIST_CONTACT_ROLE' => 'Kontaktroll',
    'LBL_LIST_DATE_ENTERED' => 'Datum skapat',
    'LBL_LIST_EMAIL' => 'Email',
    'LBL_LIST_NAME' => 'Namn',
    'LBL_LIST_OF' => 'av',
    'LBL_LIST_PHONE' => 'Telefon',
    'LBL_LIST_RELATED_TO' => 'Relaterad till',
    'LBL_LIST_USER_NAME' => 'Användarnamn',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'Är du säker på att du vill uppdatera hela listan?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Vänligen välj minst en post för att fortsätta.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Vänligen välj minst två poster för att fortsätta.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Vänligen merkera mindre än 10 poster för att fortsätta.',
    'LBL_LISTVIEW_ALL' => 'Alla',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'Frys kolumn 1',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'Alla dubbletter',
    'LBL_LISTVIEW_NONE' => 'Ingen',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Den här sidan',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Alla poster',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Valda poster',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Vald: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'Rensa alla markeringar.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'Välj alla poster',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'Det finns fler än {{num}} poster i resultatet. Du har valt den första {{num}} poster.',
    'TPL_LISTVIEW_SELECTED' => 'Du har valt {{num}} poster ur resultatet.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'Du har markerat 1 post i resultatuppsättningen.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'Du har valt alla {{num}} poster i resultatet.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'Du har valt alla {{num}} poster i resultatet. {{link}} i datamängden.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'Uppdaterar {{num}} av {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(om {{time}} {{unit}} kvar)',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'Massuppdatering misslyckades. Initiera nytt försök ({{num}} av {{totalt}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'Massuppdatering ofullständig. {{num}} post(er) är oförändrade.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'Massuppdatering ofullständig. {{num}} post(er) är oförändrade.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} post(er) ignorerades på grund av behörigheter eller fel.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} post(er) har uppdaterats.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} Massuppdatering',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'Raderar {{num}} av {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(om {{time}} {{unit}} kvar)',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'Massradera misslyckades. Initiera nytt försök ({{num}} av {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'Massradera ofullständig. {{num}} post(er) kvar.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'Massradera ofullständig. {{num}} post(er) kvar.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} post(er) har raderats.',
    'TPL_MASSDELETE_TITLE' => '{{module}} Massradera',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'Lägga till {{num}} av {{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(om {{time}} {{unit}} kvar)',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'Mass tillägg på Target List misslyckades. Initiera nytt försök ({{num}} av {{totalt}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'Mass tillägg på Target List ofullständig. {{num}} postar inte lagt till.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'Mass tillägg på target list ofullständig. {{num}} postar inte lagt till.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} poster lagts till.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} Mass tilllägg på target list',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'Länka {{num}} av {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(om {{time}} {{unit}} kvar)',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'Mass länk misslyckades. Initiera nytt försök ({{num}} av {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'Mass Link ofullständig. {{num}} poster inte lagt till.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'Mass Link ofullständig. {{num}} poster inte lagt till.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} poster kopplades framgångsrikt.',
    'TPL_MASSLINK_TITLE' => '{{module}} Masslänk',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'Välj',
    'LBL_LISTVIEW_ACTIONS' => 'Händelser',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'Markera alla poster på denna sida',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'Avmarkera alla poster på denna sida',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} av {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '{{num}} av läses in...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'Klicka för total',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'av',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'Hämta antal sidor',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'John',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Doe',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Mr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Kodapa av högsta rang',
    'LBL_LOGIN_TO_ACCESS' => 'Vänligen logga in för att få tillträde till detta område.',
    'LBL_LOGOUT' => 'Logga ut',
    'LBL_FINISH_IMPERSONATING' => 'Avsluta imitation',
    'LBL_RESET_MFA' => 'Återställ multifaktorautentisering',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, du imiterar för närvarande {{user}}.',
    'LBL_PROFILE' => 'Profil',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'Sammanfoga email',
    'LBL_MASS_UPDATE' => 'Massuppdatering',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'Välj alla poster för massuppdatering',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'Inkludera post i massuppdatering',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'Lägg till fält',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'Ta bort fält',
    'LBL_GENERATE_QUOTE' => 'Generera offert',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'Det finns inga fält tillgängliga för Mass Update operationen',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'Din begäran om mass uppdateringen är planerat.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'Startdatum för tjänsten ligger efter slutdatum för tjänsten',
    'LBL_MASS_UPDATE_SUCCESS' => 'Alla poster har uppdaterats.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'Valda poster lades till <a href="{{listUrl}}">{{listName}}</a> mållista.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'Din begäran om att lägga valda poster till <a href="{{listUrl}}">{{listName}}</a> mållista är planerat.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'Uppdateringen kommer att ta bort följande värden:',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'Avbryt för att behålla befintliga värden. Bekräfta för att ta bort värdena.',
    'LBL_OPT_OUT_FLAG_PRIMARY' => '"Opt out" primär email',
    'LBL_MEETINGS' => 'Möten',
    'LBL_MEETING' => 'Möte',
    'LBL_MEETING_GO_BACK' => 'Gå tillbaka till mötet',
    'LBL_MEMBERS' => 'Medlemmar',
    'LBL_MEMBER_OF' => 'Medlem av',
    'LBL_MODIFIED_BY_USER' => 'Redigerad av användare',
    'LBL_MODIFIED_USER' => 'Ändrad av användare',
    'LBL_MODIFIED' => 'Redigerad av',
    'LBL_MODIFIED_NAME' => 'Ändrad av namn',
    'LBL_MODIFIED_ID' => 'Ändrad av ID',
    'LBL_MORE' => 'mer',
    'LBL_MORE_MODULES' => 'Flera moduler',
    'LBL_MORE_TABS' => 'Fler flikar',
    'LBL_MULTIPLE_MODULES' => 'Flera moduler',
    'LBL_COUNT_MODULES' => '{{count}} moduler',
    'LBL_MY_ACCOUNT' => 'Mitt konto',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'systemets standard',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'användar standard',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'användarkonto',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'gruppkonto',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'Namn',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Skapa',
    'LBL_NEW_BUTTON_TITLE' => 'Skapa [Alt+N]',
    'LBL_NEXT_BUTTON_LABEL' => 'Nästa',
    'LBL_NOTES' => 'Anteckningar',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Öppna alla',
    'LBL_OPENALL_BUTTON_TITLE' => 'Öppna alla [Alt+O}',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Öppna till:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Öppna till: [Alt+T]',
    'LBL_OPEN_IN_NEW_TAB' => 'Öppna i ny flik',
    'LBL_OPPORTUNITIES' => 'Affärsmöjligheter',
    'LBL_OPPORTUNITY_NAME' => 'Namn på affärsmöjlighet:',
    'LBL_OPPORTUNITY' => 'Affärsmöjlighet',
    'LBL_OR' => 'Eller',
    'LBL_LOWER_OR' => 'eller',
    'LBL_PANEL_ASSIGNMENT' => 'Annat',
    'LBL_PANEL_ADVANCED' => 'Mer information',
    'LBL_PANEL_BODY' => 'Översikt',
    'LBL_PARENT_TYPE' => 'Föräldertyp',
    'LBL_RELATED_TYPE' => 'Relaterad typ',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'Fas',
    'LBL_PICTURE_FILE' => 'Bild',
    'LBL_POSTAL_CODE' => 'Postnummer:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'Primär adress stad:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'Primär adress land:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'Primär adress postnummer:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Primär stat/län:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Primär gatuadress 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Primär gatuadress 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Primär gatuadress:',
    'LBL_PRIMARY_ADDRESS' => 'Primär adress:',

    'LBL_BILLING_STREET' => 'Gata:',
    'LBL_SHIPPING_STREET' => 'Gata:',

    'LBL_PRODUCT_BUNDLES' => 'Bundlade produkter',
    'LBL_PRODUCTS' => 'Produkter',
    'LBL_PROJECT_TASKS' => 'Projektuppgifter',
    'LBL_PRODUCT_TEMPLATES' => 'Produkt mallar',
    'LBL_PROJECTS' => 'Projekt',
    'LBL_PROSPECTS' => 'Mål',
    'LBL_QUICK_CREATE_MENU' => 'Quick Create Meny',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Skapa affärsmöjlighet från offert',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Skapa affärsmöjlighet från offert [Alt+O]',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'Skapar Möjlighet...',
    'LBL_QUOTES_SHIP_TO' => 'Offerter skickas till',
    'LBL_QUOTES' => 'Offerter',

    'LBL_FORECAST_WORKSHEETS' => 'Prognosark',
    'LBL_FORECAST_WORKSHEET' => 'Prognosark',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'Inbjuda',
    'LBL_INVITED' => 'Inbjuden',
    'LBL_RECOMMENDED_INVITES' => 'Rekommenderade inbjudna',
    'LBL_INSTANCES' => 'Instanser',
    'LBL_YOUR_INSTANCES' => 'Dina instanser',
    'LBL_INSTANCE_USERS' => 'instans användare',
    'LBL_SWITCH_INSTANCE' => 'Växla till denna instans',
    'LBL_LAST_LOGIN' => 'senaste inloggning',
    'LBL_ENTER_EMAIL' => 'Ange den inbjudnes email...',
    'LBL_INSTANCE_IN_USE' => 'Instans används',
    'LBL_INSTANCE_ACTIVE' => 'Du använder redan denna instans!',
    'LBL_INSTANCE_INVITE_SENT' => 'Inbjudan skickats till',
    'LBL_INSTANCE_SWITCH_FAILED' => 'Det gick inte att byta instanser',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'Påminnelser',
    'LBL_REMINDERS_OVERDUE' => 'Försenade',
    'LBL_REMINDERS_UPCOMING' => 'Kommande',
    'LBL_REMINDERS_NONE_FOUND' => 'Inga påminnelser hittades.',
    'LBL_REMINDERS_FINISHED' => 'Klart!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'Affärsmöjlighet Metrics',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'Sweet Spot-kontrollpanel',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'Snabbtangenter',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'Det gick inte att uppdatera konfigurationsinställningar: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'Sweet Spot-åtgärder',
    'LBL_SWEETSPOT_KEY' => 'Nyckelord',
    'LBL_SWEETSPOT_REMOVE' => 'Ta bort åtgärd',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'Snabbtangenter',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'Händelser',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'Poster',
    'LBL_SWEETSPOT_THEME' => 'Tema',
    'LBL_SWEETSPOT_THEME_SELECT' => 'Välj tema',

    'LBL_RELATED' => 'Relaterad',
    'LBL_RELATED_INFORMATION' => 'Relaterad information',
    'LBL_RELATED_RECORDS' => 'Relaterad {{module}}',
    'LBL_REPORTS_TO' => 'Rapporterar till',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'Indikerar obligatoriskt fält',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Klart',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Spara som',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Spara som [Alt+A]',
    'LBL_FULL_FORM_BUTTON_KEY' => 'F',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Fullt formulär',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Fullt formulär [Alt+F]',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Spara & skapa ny',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Spara & skapa ny [Alt+V]',
    'LBL_SAVE_OBJECT' => 'Spara {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Sök',
    'LBL_SEARCH_BUTTON_TITLE' => 'Sök [Alt+Q]',
    'LBL_SEARCH' => 'Sök',
    'LBL_SEARCH_TIPS' => 'Vänligen tryck på sökknappen eller tryck på enter för att få en exakt träff för dem.',
    'LBL_SEARCH_TIPS_2' => 'Vänligen tryck på sökknappen eller tryck på enter för att få en exakt träff för',
    'LBL_SEARCH_MORE' => 'mer',
    'LBL_SEE_ALL' => 'Visa alla',
    'LBL_SEARCH_LOAD_MORE' => 'LAST MERA',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Ogiltigt filformat, endast bildfiler kan laddas upp.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'Bildformat {0} stöds inte längre.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Välj',
    'LBL_SELECT_BUTTON_TITLE' => 'Välj [Alt+T]',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'Lägg till team',
    'LBL_SELECT_TEAMS_TITLE' => 'Lägg till team [Alt+Z]',
    'LBL_SELECT_APPEND_TEAMS' => 'Bifoga Team(s)',
    'LBL_SELECT_APPEND_VALUES' => 'Bifoga värden',
    'LBL_SELECT_APPEND_TAGS' => 'Lägg till tagg(ar)',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Bläddra bland dokument',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Bläddra bland dokument [Alt+B]',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Välj kontakt',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Välj kontakt [Alt+T]',
    'LBL_GRID_SELECTED_FILE' => 'vald fil',
    'LBL_GRID_SELECTED_FILES' => 'valda filer',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Välj från rapporter',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Välj rapporter',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Välj användare',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Välj användare [Alt+U]',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Rensa Val',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Rensa Val',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Rensa Val',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Rensa Val',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Välj fil',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Välj fil',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Rensa Fil',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Rensa Fil',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Välj användare',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Välj användare',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Rensa Användare',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Rensa Användare',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Välj organisation',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Välj organisation',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Rensa Organisation',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Rensa Organisation',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Välj Kampanj',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Välj Kampanj',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Rensa Kampanj',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Rensa Kampanj',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'Välj kontakt',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'Välj kontakt',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Rensa Kontakt',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Rensa Kontakt',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Välj Team',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Välj Team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Rensa Team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Rensa Team',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Resurser som använts för att skapa den här sidan (queries, files)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'sekunder.',
    'LBL_SERVER_RESPONSE_TIME' => 'Server svarstid:',
    'LBL_SERVER_MEMORY_BYTES' => 'bytes',
    'LBL_SERVER_MEMORY_USAGE' => 'Använt Serverminne: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Användning:  - modul: {0} - action: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Maximal minnesanvändning, server: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'Leverera till konto',
    'LBL_SHIP_TO_CONTACT' => 'Leverera till kontakt',
    'LBL_SHIPPING_ADDRESS' => 'Leveransadress',
    'LBL_SHORTCUTS' => 'Genvägar',
    'LBL_SHOW' => 'Visa',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'Stat:',
    'LBL_STATUS_UPDATED' => 'Din status för detta event har blivit uppdaterad!',
    'LBL_STATUS_NOT_UPDATED' => 'Din status för detta event har blivit uppdaterad.',
    'LBL_STATUS' => 'Status:',
    'LBL_STREET' => 'Gata',
    'LBL_SUBJECT' => 'Ämne',

    'LBL_INBOUNDEMAIL_ID' => 'Inkommande emailid',
    'LBL_EAMP_ID' => 'Autentiseringstoken-ID',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'Med ensamrätt.<br />SugarCRM, Sugar och 3-D-kuben är registrerade varumärken för SugarCRM Inc. ' .
        'Alla andra företags- och produktnamn som används eller förekommer i denna produkt kan vara varumärken tillhörande ' .
        'respektive företag de associeras med.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'Schemalagt jobb är klart',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'Det schemalagda jobbet har framgångrikt körts',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'Intäktsposter är nu tillgängliga i din Sugarinstans',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Revenue Line Items are now enabled in your Sugar instance, and all existing Opportunity data has been processed. Your instance is now ready to be used with Revenue Line Items. For more information about the changes which have been made, please refer to the {{doc_url}}.<br /><br />Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'Prognosmodulen är nu redo för att användas med Möjligheter i din Sugarinstans',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'The Forecasts module in your Sugar instance is now available for use with opportunities. All previous Revenue Line Item forecast commit data has been removed, and the instance is ready for forecasts to be created and committed with opportunities. For more information about the changes which have been made, please refer to the {{doc_url}}.<br /><br />Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Intäktsposter är nu inaktiverade i din Sugarinstans',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Revenue line Items are now disabled in your Sugar instance, and all existing Revenue Line Item data has been processed. Your instance is now ready to be used with Opportunities. For more information about the changes which have been made, please refer to the {{doc_url}}.<br /><br />Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'Dokumentation för Affärsmöjlighetskonfiguration',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'Logga In',
    'LBL_LOGIN_WELCOME_TO' => 'Välkommen till',
    'LBL_LOGIN_OPTIONS' => 'Alternativ',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'Glömt ditt lösenord?',
    'LBL_LOGIN_SUBMIT' => 'Skicka',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'För många misslyckade inloggningsförsök.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'Du kan pröva att logga in igen',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'dagar.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 't.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'min.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'sek.',
    'LBL_LOGIN_ADMIN_CALL' => 'Var god kontakta system administratören.',
    'LBL_LOGIN_USERNAME' => 'Användarnamn',
    'LBL_LOGIN_PASSWORD' => 'Lösenord',
    'LBL_LOGGED_OUT' => 'Du har blivit utloggad.',
    'LBL_LOGIN_FORM_LABEL' => 'Visa inloggningsformulär',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'Tillbaka till inloggning',
    'LBL_LOGIN_INACTIVE_USER' => 'Inaktiv användare',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'Grupp eller Portal användare kan inte logga in.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'Hem',
    'LBL_SYNC' => 'Synk',
    'LBL_TASKS' => 'Uppgifter',
    'LBL_TEAMS_LINK' => 'Team',
    'LBL_THEME_COLOR' => 'Färg',
    'LBL_THEME_FONT' => 'Font',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'Schemalägg möte',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'Schemalägg möte',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'Arkivera email',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'Arkivera email',
    'LBL_UNAUTH_ADMIN' => 'Obehörig åtkomst till administrationen',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Ångra radera',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Ångra radera [Alt + D]',
    'LBL_UNDELETE_BUTTON' => 'Ångra radera',
    'LBL_UNDELETE' => 'Ångra radera',
    'LBL_UNSYNC' => 'Ångra synkronisering',
    'LBL_UPDATE' => 'Uppdatera',
    'LBL_UPDATES' => 'Uppdateringar',
    'LBL_USER_LIST' => 'Användarlista',
    'LBL_USER_MENU' => 'Användarmeny',
    'LBL_USERS_SYNC' => 'Synkronisering av användare',
    'LBL_USERS' => 'Användare',
    'LBL_USER' => 'Användare',
    'LBL_CURRENT_USER' => 'Aktuell användare',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'Söker efter befintliga mail entry...',
    'LBL_VERIFY_PORTAL_NAME' => 'Söker efter befintliga portalnamn...',
    'LBL_VIEW_IMAGE' => 'visa',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'Skriv ut som PDF',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'Skriv ut som PDF [Alt+P]',

    'LBL_KBDOCUMENTS' => 'Kunskapsbas',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'Om',
    'LNK_ADVANCED_SEARCH' => 'Avancerad sökning',
    'LNK_BASIC_SEARCH' => 'Vanlig sökning',
    'LNK_SEARCH_NO_RESULTS' => 'Inga resultat hittades',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'Visa alla resultat',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Visa alla',
    'LNK_CLOSE' => 'Stäng',
    'LBL_MODIFY_CURRENT_SEARCH' => 'Redigera aktuell sökning',
    'LNK_SAVED_VIEWS' => 'Sparade sökningar & layout',
    'LNK_DELETE_ALL' => 'radera alla',
    'LNK_DELETE' => 'radera',
    'LNK_EDIT' => 'redigera',
    'LNK_VIEW' => 'visa',
    'LNK_GET_LATEST' => 'Hämta senaste',
    'LNK_GET_LATEST_TOOLTIP' => 'Ersätt med nyaste versionen',
    'LNK_HELP' => 'Hjälp',
    'LNK_CREATE' => 'Skapa',
    'LNK_CREATE_WHEN_EMPTY' => 'Skapa nytt protokoll nu.',
    'LNK_LIST_END' => 'Slut',
    'LNK_LIST_NEXT' => 'Nästa',
    'LNK_LIST_PREVIOUS' => 'Föregående',
    'LNK_LIST_RETURN' => 'Återgå till Lista',
    'LNK_LIST_START' => 'Start',
    'LNK_LOAD_SIGNED' => 'Signera',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'Ersätt med signerat dokument',
    'LNK_PRINT' => 'Skriv ut',
    'LNK_BACKTOTOP' => 'Tillbaka till toppen',
    'LNK_REMOVE' => 'radera',
    'LNK_RESUME' => 'Återuppta',
    'LNK_VIEW_CHANGE_LOG' => 'Visa granskningsloggen',
    'TPL_AUDIT_LOG_TITLE' => 'Granskningslogg för {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'Klicka för att visa e-postadress granskningslogg',
    'LBL_NO_SEARCH_RESULTS' => 'Inga resultat hittades för din sökning',
    'NTC_CLICK_BACK' => 'Var god klicka på tillbakaknappen i webbläsaren för att åtgärda problemet.',
    'NTC_DATE_FORMAT' => '[åååå-mm-dd]',
    'NTC_DATE_TIME_FORMAT' => '[åååå-mm-dd 24:00]',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'Är du säker på att du vill radera de valda posterna?',
    'NTC_TEMPLATE_IS_USED' => 'Denna mall används i åtminstone en emailmarknads post. Är du säker på att du vill ta bort den?',
    'NTC_TEMPLATES_IS_USED' => "Följande mallar används i emailmarknadsposter. Är du säker på att du vill ta bort dem?\n",
    'NTC_DELETE_CONFIRMATION' => 'Är du säker på att du vill radera posten?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'Är du säker på att du vill ta bort {0}?',
    'LBL_METRIC_DELETE_WARNING' => 'Alla användare denna mätvärdesflik har delats med kommer också förlora åtkomst.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'Är du säker på att du vill radera',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'Är du säker på att du vill uppdatera',
    'NTC_DELETE_SELECTED_RECORDS' => 'valda poster?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'Filtret kommer att tas bort från alla vyer; detta kan omfatta konfigurationsdata för dashlets. Är du säker på att du vill ta bort det här filtret?',
    'TPL_DELETE_FILTER_SUCCESS' => 'Du tog bort filtret {{name}}.',
    'NTC_DELETE_SUCCESS' => 'Du tog bort {0}.',
    'NTC_UNLINK_CONFIRMATION' => 'Är du säker på att du vill ta bort länken för denna post?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'Är du säker på att du vill ta bort länken till {0}?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'Är du säker på att du vill ta bort länken till {0}? Detta tar även bort dem från ärendets primära kontaktfält.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => '{0} kan inte avlänkas eftersom de är den primära kontakten i det här ärende. Uppdatera fältet primär kontakt innan du tar bort länken till denna post.',
    'NTC_UNLINK_SUCCESS' => 'Du tar bort länken till {0}.',
    'NTC_LOGIN_MESSAGE' => 'Var god fyll i ditt användarnamn och lösenord:',
    'NTC_NO_ITEMS_DISPLAY' => 'inga',
    'NTC_REMOVE_CONFIRMATION' => 'Är du säker på att du vill ta bort relationen?',
    'NTC_REQUIRED' => 'Indikerar obligatoriskt fält',
    'NTC_SUPPORT_SUGARCRM' => 'Stöd SugarCRM:s open source projekt med en donation genom PayPal - det är snabbt, gratis och säkert!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'Välkommen',
    'NTC_YEAR_FORMAT' => '(åååå)',
    'LOGIN_LOGO_ERROR' => 'Var god ersätt SugarCRM:s logotyper.',
    'FATAL_LICENSE_ALTERED' => 'Er licens har ändrats sedan ni senast validerade den.',
    'ERROR_FULLY_EXPIRED' => "Ditt företags licens för SugarCRM gick ut för mer än 30 dagar sedan och måste uppdateras. Endast administratörer kan logga in.",
    'ERROR_LICENSE_EXPIRED' => "Ditt företags licenser för SugarCRM måste uppdateras. Endast administratörer kan logga in.",
    'WARN_LICENSE_EXPIRED' => "Ditt företags licens för SugarCRM upphör snart.",
    'ERROR_LICENSE_VALIDATION' => "Ditt företags licenser för SugarCRM måste valideras. Endast administratörer kan logga in",
    'WARN_LICENSE_VALIDATION' => "Ditt företags licens för SugarCRM måste valideras snart.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => 'Varning: Din webbläsare är i IE-kompatibilitet vy som inte stöds.',
    'WARN_LICENSE_SEATS' => 'Varning: Antalet aktiva användare är redan max antal tillåtet av licensen.',
    'WARN_LICENSE_SEATS_MAXED' => 'Varning: Antalet aktiva använd överskrider max antalet som licensen tillåter.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'Antalet aktiva användare överskrider antalet licenser gränser. Kontakta din administratör.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'Endast administratörer kan logga in.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'Gränsen för användarens licensantal har nåtts. Endast befintliga användare kan logga in.',
    'WARN_ONLY_ADMINS' => 'Endast administratörer kan logga in.',
    'WARN_UNSAVED_CHANGES' => 'Du håller på att stänga denna post utan att spara dina ändringar. Är du säker på att du vill lämna denna post?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'När du uppdaterar webbläsaren stängs alla SugarLive-samtals- eller chatt-sessioner som du har öppnat automatiskt och alla sparade ändringar kommer att försvinna. Vill du fortsätta?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'Du har ändringar som inte sparats. Är du säker på att du vill lämna sidan och ignorera ändringarna?',
    'LBL_MFA_RESET_CONFIRMATION' => 'Vill du verkligen återställa din <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">multifaktorsautentisering</a>?
Om du genomför denna åtgärd kommer du att loggas ut omedelbart och du kommer behöva autentisera dig med hjälp av autentiseringsappen nästa gång du loggar in.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'Bekräfta och logga ut',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'En eller flera dashlets har osparade ändringar. Är du säker på att du vill stänga lådan?',
    'LBL_NAVIGATE_TO_REPORTS' => 'Du flyttar till modulen Rapporter. Dina ändringar av dashlet sparas inte. Fortsätta?',
    'ERROR_NO_RECORD' => 'Fel vid hämtande av post. Posten är raderad eller så har du inte behörighet att visa den.',
    'ERROR_TYPE_NOT_VALID' => 'Error. Den här typen är inte godkänd.',
    'ERROR_MAX_FIELD_LENGTH' => 'Fel. Maxlängden av fältet är {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'Fel. Minimilängden av fältet är {{this}}.',
    'ERROR_EMAIL' => 'Fel. Ogiltig Email Adress:  {{#each this}}{{this}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'Fel. Minst en primär adress bör fastställas.',
    'ERROR_DUPLICATE_EMAIL' => 'Fel. Dubblett av emailadress: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'Fel. Det här fältet är nödvändigt.',
    'ERROR_MINVALUE' => 'Fel. Minsta tillåtna värdet i det här fältet är {{this}}.',
    'ERROR_MAXVALUE' => 'Fel. Högsta tillåtna värdet i det här fältet är {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'Fel. Värdet på detta fält måste vara större än {{this}}.',
    'ERROR_IS_LESS_THAN' => 'Fel. Värdet på detta fält måste vara mindre än {{this}}.',
    'ERROR_DATETIME' => 'Fel. Fältet kräver ett giltigt datum.',
    'ERROR_IS_BEFORE' => 'Fel. Datumet för detta fält kan inte vara efter datum för {{this}} fält.',
    'ERROR_IS_AFTER' => 'Fel. Datumet för detta fält kan inte vara före datum för {{this}} fält.',
    'ERROR_TIME_IS_BEFORE' => 'Fel. Datumet för detta fält måste var före datum för {{this}} fält.',
    'ERROR_TIME_IS_AFTER' => 'Fel. Tiden för detta fält måste var efter tiden för {{this}} fält.',
    'ERROR_NUMBER' => 'Fel. Detta fält kräver ett giltigt nummer.',
    'ERROR_INT' => 'Fel. Ogiltigt heltal.',
    'ERROR_URL' => 'Fel. Ogiltig URL.',
    'ERROR_NO_BEAN' => 'Misslyckades att få bean.',
    'ERROR_ACCESS_MODULE' => 'Du har inte tillgång till denna modul.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'Fel. Bilagan är för stor.',
    'ERROR_UPLOAD_FAILED' => 'Fel. Filen gick inte att ladda upp.',
    'ERROR_UPLOAD_ACCESS_PD' => 'Du har inte behörighet att skapa [processdefinitioner] för denna modul.',
    'ERROR_UPLOAD_ACCESS_BR' => 'Du har inte behörighet att skapa [affärsregler] för denna modul.',
    'ERROR_UPLOAD_ACCESS_ET' => 'Du har inte behörighet att skapa [emailmallar] för denna modul.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'Fel. Du har angett en operatör som inte stöds.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'Fel. Du har angett en ogiltig operatör.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'Fel. Du har angett ett ogiltigt filter.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Importen misslyckades. Kontrollera Sugar-loggen för mer information.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'Importen misslyckades. Ett gruppfält är delvis låst i processdefinitionen.' .
        ' Dessa fält måste låsas upp i processdefinitionen för att definitionen ska importeras.',
    'ERROR_EXP_DATE_LOW' => 'Fel. Utgångsdatum kan inte ligga före publiceringsdatum.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'Fel. Godkänd status kräver publiceringsdatum.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'Fältet Publiceringsdatum är tomt.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'Hitta kopior',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'Dubbelpostkontroll är avstängd för {{module}}.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'Hantera prenumerationer',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Hantera prenumerationer för',
    'LBL_SUBSCRIBE' => 'Prenumerera',
    'LBL_UNSUBSCRIBE' => 'Ta bort från listan',
    'LBL_CREATE_LINK_RECORD' => 'Skapa och länka posten',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'Skapa och länka posten',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} poster är nu kopplade.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'Inga poster att länka.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'Denna rapport bygger inte på rätt modul.',
    'ERROR_EMPTY_LINK_MODULE' => 'Välj relationen först.',
    // Ajax status strings
    'LBL_LOADING' => 'Laddar...',
    'LBL_LOADING_NO_DOTS' => 'Laddar',
    'LBL_SEARCHING' => 'Söker...',
    'LBL_SEARCH_UNDERWAY' => 'Söker',
    'LBL_SAVING_LAYOUT' => 'Sparar layout...',
    'LBL_SAVED_LAYOUT' => 'Layouten har sparats.',
    'LBL_SAVED' => 'Sparad',
    'LBL_SAVING' => 'Sparar',
    'LBL_FAILED' => 'Misslyckades!',
    'LBL_DISPLAY_COLUMNS' => 'Visa kolumner',
    'LBL_HIDE_COLUMNS' => 'Dölj kolumner',
    'LBL_SEARCH_CRITERIA' => 'Sökkriterier',
    'LBL_SAVED_VIEWS' => 'Sparade vyer',
    'LBL_PROCESSING_REQUEST' => 'Bearbetar...',
    'LBL_REQUEST_PROCESSED' => 'Klar',
    'LBL_AJAX_FAILURE' => 'Ajax fel',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'Sök...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Sparade sökningar',
    'LBL_SEARCH_POPULATE_ONLY' => 'Genomför en sökning genom att använda sökformuläret ovan',
    'LBL_SEARCH_NO_RESULTS' => 'Inga resultat hittades för',
    'LBL_SEARCH_FOR' => 'Sök efter',
    'LBL_SEARCH_FOR_MORE' => 'Sök för mer...',
    'LBL_SEARCH_SELECT' => 'Välj...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'Sök och välj...',
    'LBL_SEARCH_SELECT_MODULE' => 'Välj {{module}}...',
    'LBL_DETAILVIEW' => 'Detaljerad vy',
    'LBL_LISTVIEW' => 'Listvy',
    'LBL_EDITVIEW' => 'Redigerings vy',
    'LBL_SEARCHFORM' => 'Sökformulär',
    'LBL_SAVED_SEARCH_ERROR' => 'Var god sätt ett namn för denna vy.',
    'LBL_DISPLAY_LOG' => 'Visa logg',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Plats',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Beskrivning',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'startar',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'Klicka OK för att visa samtalet eller klicka Cancel för att ta bort det här meddelandet.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'Klicka OK för att visa mötet eller klicka Cancel för att ta bort det här meddelandet.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'Inga resultat hittades.',
    'MSG_LIST_VIEW_NO_RESULTS' => 'Inga resultat hittades för',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Skapa som ny',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'Du har inga <item1> poster sparade. <item2> eller <item3> en nu.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'Du har inga <item1> poster sparade. <item2> en nu.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'Du kan skala från en .list',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'Positiv',
    'LBL_SENTIMENT_NEUTRAL' => 'Neutral',
    'LBL_SENTIMENT_NEGATIVE' => 'Negativ',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'Ingen mätvärdesflik konfigurerad',
    'LBL_NO_METRIC_VISIBLE' => 'Inga måttenhetsflikar synliga',
    'LBL_MAKE_METRIC_VISIBLE' => 'Välj "organisera" för att göra måttflikar synliga',
    'LBL_PLEASE_CONTACT_ADMIN' => 'Kontakta din administratör',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'Klicka här',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Lägg till i mina favoriter',
    'LBL_MARK_AS_FAVORITES' => 'Markera som favorit',
    'LBL_CREATE_CONTACT' => 'Skapa kontakt',
    'LBL_CREATE_NOTE' => 'Skapa anteckning',
    'LBL_CREATE_OPPORTUNITY' => 'Skapa affärsmöjlighet',
    'LBL_SCHEDULE_CALL' => 'Schemalägg telefonsamtal',
    'LBL_SCHEDULE_CALL2' => 'Samtal',
    'LBL_SCHEDULE_MEETING' => 'Schemalägg möte',
    'LBL_SCHEDULE_MEETING2' => 'Möte',
    'LBL_CREATE_MESSAGE' => 'Skapa meddelande',
    'LBL_CREATE_MESSAGE2' => 'Meddelande',
    'LBL_CREATE_TASK' => 'Skapa uppgift',
    'LBL_CREATE_TASK2' => 'Uppgift',
    'LBL_REMOVE_FROM_FAVORITES' => 'Ta bort från mina favoiriter',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'Anteckning',
    'LBL_DOWNLOAD_ALL' => 'Ladda ner alla',
    'LBL_DOWNLOAD_ONE' => 'Ladda ner',
    'LBL_ATTACHMENTS' => 'Bilagor',
    'LBL_ADD_ATTACHMENT' => 'Bläddra',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Generera formulär',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Spara Webb till Lead formulär',

    'LBL_PLEASE_SELECT' => 'Var god välj',
    'LBL_REDIRECT_URL' => 'Omdirigera URL',
    'LBL_RELATED_CAMPAIGN' => 'Relaterad kampanj',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Lägg till alla fält',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Ta bort alla fält',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Endast bilagor i form av bilder kan infogas.',
    'LBL_REMOVE' => 'Radera',
    'LBL_TRAINING' => 'Träning',
    'ERR_DATABASE_CONN_DROPPED' => 'Fel vid körningen av frågan. Möjligen har din databas tappat kommunikationen. Vänligen ladda om sidan, du kan behöva starta om din webserver',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'Fel inställning {0} relation: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'Ändrade databas till',
    'ERR_MSSQL_WARNING' => 'Varning:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'Det gick inte att tolka vCard-format',
    'ERR_VCARD_FILE_MISSING' => 'vcf-fil saknas',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Varning: fältet [[field]] har ingen mappad post i  [moduleDir] vardefs.php filen',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Fel: Filen [[file]] saknas.  Omöjligt att skapa, eftersom ingen matchande HTML fil hittades.',
    'ERR_CANNOT_FIND_MODULE' => 'Error: Modulen [module] existerar inte.',
    'LBL_ALT_ADDRESS' => 'Annan adress:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Fel: Det är ett ojämnt antal argument för &#39;key&#39; och &#39;copy&#39; elementen i displayParams array.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Saknat index i displayParams Array för:',

    'LBL_DASHLET' => 'Dashlet',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filter',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Endast mina tilldelade objekt',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Titel',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Visa rader',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'Relatera till aktuell post',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'Kopplat fält',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'Frys första kolumnen',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'Är du säker på att du vill radera Sugardashleten?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'Är du säker på att du vill ta bort raden?',
    'LBL_MAXIMUM_OF' => 'Maximalt av',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => 'kolumner kan visas.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'Instrumentpanel',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'Min Dashboard',
    'LBL_COLLAPSE_ALL' => 'Dra ihop alla',
    'LBL_EXPAND_ALL' => 'Utöka alla',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'Redigera',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'Visa rapport',
    'LBL_DASHLET_REFRESH_LABEL' => 'Uppdatera',
    'LBL_DASHLET_REMOVE_LABEL' => 'Radera',
    'LBL_DASHLET_DROP_HERE' => 'Släpp här',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'Stäng',
    'LBL_DASHLET_MAXIMIZE' => 'Öppna',
    'LBL_DASHLET_CONFIGURE' => 'Konfigurera',
    'LBL_DASHLET_TOGGLE' => 'Öppna/Stäng',
    'LBL_SIDEPANE_TOGGLE' => 'Öppna/stäng sidopanelen',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'Återställ standardlayout',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'Ingen instrumentpanel är konfigurerad',
    'LBL_CREATE_DASHBOARD_LINK' => 'Skapa instrumentpanel',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'Hjälp',
    'LBL_HELPLET_TOGGLE' => 'Öppna/Stäng',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'Moduler',
    'LBL_FACET_MODIFIED_BY_ME' => 'Modifierad av mig',
    'LBL_FACET_CREATED_BY_ME' => 'Skapad av mig',
    'LBL_FACET_MY_FAVORITES' => 'Mina favoriter',
    'LBL_FACET_ASSIGNED_TO_ME' => 'Tilldelad till mig',
    'LBL_FACET_NO_DATA' => 'Inga data för denna aspekt.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'Listvy',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'Listar poster från en viss modul enligt kriterier som du definierar.',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'Konsollistvy',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'Listar poster från en viss modul som hör samman med posten som du visar i konsolen.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'Postvy',
    'LBL_RELATED_RECORDS' => 'Relaterad {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'Visar en post och (valfritt) relaterade poster i flikar.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'Basposttyp',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'Denna {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'Flikar',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'Förhandsvisning av grundlayout',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'Varning, endast {{numWord}} ({{num}})-moduler kan visas i flikar. ' .
        'Ta bort en eller flera moduler innan du lägger till fler.',
    'LBL_SIX' => 'sex', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'Kommentarslogg',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'Visa kommentarer för en post',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'Inga kommentarer tillgängliga',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'Lägg till',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'Lägg till kommentar',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'Se alla',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'Data är inte tillgängliga. Du har inte behörighet att komma åt dessa moduler.' .
    " \nVar vänlig uppdatera eller ta bort denna dashlet.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'Mina {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'Ingen post vald för visning',
    'LBL_CONTENT_SEARCH_DASHLET' => 'Innehållssökning för dashlet',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'Vad kan vi hjälpa dig med idag, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'Vill du skapa ett ärende?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'Affärsmöjlighet Metrics',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'Möjlighetsvärden för relaterat konto.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'Snabburval ur produktkatalogen',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'Lista nyligen använda föremål och produkter sparade som favoriter',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'Nyligen använda',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'Favoriter',

    'LBL_DASHBOARD_CREATE' => 'Skapa Dashboard',
    'LBL_DASHBOARD_DUPLICATE' => 'Duplicera Dashboard',
    'LBL_DASHBOARD_DELETE' => 'Ta bort Dashboard',
    'LBL_PIN_TO_TOP' => 'Fäst överst',
    'LBL_PIN_TO_BOTTOM' => 'Fäst nederst',
    'LBL_MANAGE_DASHBOARDS' => 'Hantera instrumentpaneler',

    'LBL_DASHBOARD_CONFIG' => 'Konfiguration av instrumentpanel',
    'LBL_LIST_VIEW__NAME' => 'Listvy',
    'LBL_PIPELINE_VIEW_NAME' => 'Brickvy',
    'LBL_PIPELINE_VIEW_BTN' => 'Brickvy',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} efter {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'Brickvy är inte aktiverad',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'Inga poster hittades vid denna tidpunkt.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'Case sammandrag',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'Tidslinje',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'Noter & Bilagor',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'Noter & Bilagor hör till posten',
    'LBL_DASHLET_PIPLINE_NAME' => 'Pipeline',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'Senaste Tweets - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'Inga sparade Dashboards',

    'LBL_DNB_AND' => 'och',
    'LBL_DNB_PRIM_NAME_DESC' => 'Text registrering et namn för denna organisation',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'Svara',
    'LBL_TWITTER_RETWEET' => 'Retweet',
    'LBL_TWITTER_FAVORITE' => 'Favorit',
    'LBL_TWITTER_FOLLOW' => 'Följ',
    'LBL_TWITTER_DESCRIPTION' => 'Se att matcha Twitter-användares bio och tweets, retweets och svara på tweets',
    'LBL_TWITTER_ID' => 'Twitter-ID',
    'LBL_TWITTER_DISPLAY_ROWS' => 'Visa rader',
    'LBL_TWITTER_MY_ACCOUNT' => 'Mitt konto',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Twitter källa:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'Utbildningsresurser',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'Utbildning och certifiering',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub-forum',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'Dokumentation och support',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters Marketplace',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'Försäljning per land',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'Visar försäljnings diagrammet efter landkarta.',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'Kunskapsbaskategorier och publicerade artiklar',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'Kunskapsdatabassökning',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'Visa en sökbar trädvy över publicerade kunskapsbasartiklar och kategorier.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'Publicerade artiklar på andra språk',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'Mest användbara publicerade kunskapsbasartiklar',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'Visar de mest populära och visade kunskapsbasartiklarna',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} filtrerat efter {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'Användbarhet för artiklar',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'Lägg till sida',
    'LBL_LOADING_PAGE' => 'Laddar sidan, var god vänta...',
    'LBL_SEARCH_RESULTS' => 'Sökresultat',
    'LBL_SEARCH_RESULTS_FOR' => 'Sökresultat för: ',
    'LBL_SEARCH_HELP_TITLE' => 'Söktips',
    'LBL_SEARCH_RESULTS_FOUND' => 'Sökresultat Hittade',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'Min pipeline',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "Mitt teams Pipeline",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'Försäljningsförloppet diagram',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'Visar aktuellt pipelinediagram.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'Ingen bild',

    'LBL_MODULE' => 'Modul',
    'LBL_RELATIONSHIP' => 'Relation',
    'LBL_SINGULAR_LABEL' => 'Singulär etikett',
    'LBL_PLURAL_LABEL' => 'Plural etikett',
    'LBL_MODULE_DISPLAY' => 'Visa',
    'LBL_MODULE_DISPLAY_TYPE' => 'Visningstyp',
    'LBL_MODULE_ICON' => 'Ikon',
    'LBL_MODULE_COLOR' => 'Modulens bakgrundsfärg',
    'LBL_LANGUAGE_SELECTOR' => 'Språk',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'Inställningar för modul',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'Modulinställningarna har sparats.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Kopiera adress från vänster:',
    'LBL_SAVE_AND_CONTINUE' => 'Spara och fortsätt',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Flervalsboxar</strong></p><ul><li>Klicka på värdena för att välja ett attrbut.</li><li>Ctrl-klick för att välja fler. Mac användare, använd CMD-klick.</li><li>För att välja alla värden mellan två attribut,  klicka på värdet håll sedan nere shift för att slutligen klicka på det sista värdet.</li></ul><p><strong>Advancerad Sökning & Utseende</strong><br><br>Genom att använda alternativet<b>Sparade Sökningar</b>, har du möjlighet att spara en uppsättning sökparametrar tillsammans med ett anpassat utseende av Listvyn, för att framöver snabbt och enkelt kunna utföra den aktuella sökningen. Du har möjlighet att spara ett valfritt antal sökningar tillsammans med anpassade Listvyer. Alla sparade sökningar finns tillgängliga vid namn i listan för Sparade Sökningar, med den sista använda sökningar tillgänglig överst i listan.<br><br>För att anpassa utseendet av Listvyn, använd boxarna Dölj Kolumner, samt Visa Kolumner, för att välja de kolumner som skall visas tillsammans med dina sökresultat. Som exempel har du möjlighet att visa eller dölja detaljer, så som objektets namn, tilldelad användare, eller tilldelat team. För att lägga till en kolumn i Listvyn, välj det önskade fältet i listan Dölj Kolumner och klicka sedan på vänsterpilen för att flytta kolumnen över till listan Visa Kolumner. För att ta bort en kolumn ur Listvyn, välj aktuell kolumn i listan Visa Kolumner och använd sedan högerpilen för att flytta över den till listan Dölj Kolumner.<br><br>Om du väljer att spara inställningarna för utseendet kommer de att kunna visas i framtiden tillsammans med det aktuella sökresultatet..<br><br>För att spara och uppdatera en sökning och/eller utseende:<ol><li>Skriv ett namn för sökresultatet i fältet <b>Spara sökning som</b> och klicka därefter på <b>Spara</b>. Namnet för sökningen visas nu i den närliggande listan över Sparade Sökningar bredvid knappen <b>Rensa</b>.</li><li>För att visa en sparad sökning, välj den från listan Sparade Sökningar. Sökresultatet kommer då att visas i Listvyn.</li><li>För att uppdara inställningarna för en sparad sökning, välj den önskade sökningen från listan, ändra önskade parametrar och/eller utseende och klicka sedan på <b>Uppdatera</b> bredvid <b>Modifiera Aktuell Sökning</b>.</li><li>För att ta bort en sparad sökning, välj från listan Sparade Sökningar och klicka sedan på <b>Ta Bort</b> bredvid <b>Modifiera Aktuell Sökning</b>, och sedan på <b>OK</b>  för att bekräfta borttagningen.</li></ol>',

    //resource management
    'ERR_QUERY_LIMIT' => 'Error: Query limit för $limit är överskriden för $module modul.',
    'ERROR_NOTIFY_OVERRIDE' => 'Error: ResourceObserver->notify() måste överskuggas.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'Error: Kunde inte skapa monitor för metadatafilen är tom eller filen finns inte.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'Error: Det finns ingen monitor konfigurerad för det efterfrågade namnet',
    'ERR_UNDEFINED_METRIC' => 'Error: Kan inte sätta värde på odefinerade metrics',
    'ERR_STORE_FILE_MISSING' => 'Error: Kan inte hitta Store implementationsfil',

    'LBL_MONITOR_ID' => 'Monitor ID',
    'LBL_TEAM_ID' => 'Lag-ID',
    'LBL_SELECT_MODULE' => 'Välj modul',
    'LBL_USER_ID' => 'Användar ID',
    'LBL_MODULE_NAME' => 'Modulnamn',
    'LBL_MODULE_ALL' => 'Alla',
    'LBL_ITEM_ID' => 'Sak Id',
    'LBL_ITEM_SUMMARY' => 'Sak-sammanfattning',
    'LBL_ACTION' => 'Aktivitet',
    'LBL_SESSION_ID' => 'Sessionsid',
    'LBL_BREADCRUMBSTACK_CREATED' => '"BreadCrumbStack" skapad för användarid {0}',
    'LBL_VISIBLE' => 'Post synlig of Last Action',
    'LBL_DATE_LAST_ACTION' => 'Datum för senaste händelsen',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL-Text',
    'LBL_QUERY_HASH' => 'SQL-Hash',
    'LBL_SEC_TOTAL' => 'Sekunder totalt',
    'LBL_SEC_AVG' => 'Sekunder medel',
    'LBL_RUN_COUNT' => 'Antal frågor',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'Klient IP adress',
    'LBL_DATE_START' => 'Startdatum',
    'LBL_ACTIVE' => 'Aktiv session',
    'LBL_ROUNDTRIPS' => 'Antal funktioner',
    'LBL_SECONDS' => 'Aktiva sekunder',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'Databas tur/retur',
    'LBL_FILES_OPENED' => 'Visade filer',
    'LBL_MEMORY_USAGE' => 'Minnesanvändning (bytes)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'Laddar Twitter "connector"...',
    'LBL_TWITTER_DATA_EMPTY' => 'Inget data tillgängligt från Twitter',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Sugar Plug-In för Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Integrera Sugars email- och kalenderinformation med Microsoft Outlook.',
    'LBL_PLUGIN_WORD_NAME' => 'Sugar Plug-In för Word',
    'LBL_PLUGIN_WORD_DESC' => 'Fyll automatiskt i information från SugarCRM till brev, direkt mail och andra Microsoft dokument.',
    'LBL_PLUGIN_EXCEL_NAME' => 'Sugar Plug-In for Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'Integrera Sugar med kalkylblad för bättre analys av nyckel data.',
    'LBL_PLUGINS_TITLE' => 'Sugar Plug-ins för Microsoft OfficeTM',
    'LBL_PLUGINS_DESC' => 'Läs mer om plugin funktioner i <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">Plug-Ins Documentation</a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Sugar Plug-ins för Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'Sugar Plug-in För Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'Integrera Sugar med Lotus Notes.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'är inte före',
    'MSG_IS_MORE_THAN' => 'är mer än',
    'MSG_IS_LESS_THAN' => 'är mindre än',
    'MSG_SHOULD_BE' => 'ska vara',
    'MSG_OR_GREATER' => 'eller större',
    'MSG_EXCEEDS_MAXLEN' => 'överskrider maximal angiven längd ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Välkommen till Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal är ett ramverk som förser real-tids vyer av ärenden, buggar & nyhetsbrev med mera till kunder. Detta är ett extert fasad-interface till Sugar som kan distribueras inom vilken websida som helst. Stanna kvar för mer kund self-service egenskaper som Projekt Management och Forum i våra kommande releaser.',
    'LBL_LIST' => 'Lista',
    'LBL_CREATE_CASE' => 'Skapa ärende',
    'LBL_CREATE_BUG' => 'Skapa bugg',
    'LBL_NO_RECORDS_FOUND' => '- 0 Poster hittade -',

    'DATA_TYPE_DUE' => 'Förfaller:',
    'DATA_TYPE_START' => 'Start:',
    'DATA_TYPE_SENT' => 'Skickat:',
    'DATA_TYPE_MODIFIED' => 'Ändrad',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Räkna',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'objektbild',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'Välj datum',

    'LBL_VALIDATE_RANGE' => 'är inte inom angivet intervall',
    'LBL_VALIDATE_URL' => 'är inte en giltig URL',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'Alla',

    'LBL_OPERATOR_IN_TEXT' => 'är en av följande:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'är inte en av följande:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Fel: List parametrarna stämmer inte överens med resultat listan.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Fel: Inga kopplingar för modul.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Fel: Kan ej hämta data för {0} "connector". Servicen är antingen inte tillgänglig eller konfigurationsinställningarna är felaktiga. "Connector" fel meddelande: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'Det gick inte att hämta data. Tjänsten kan för närvarande vara otillgängliga eller konfigurationsinställningarna kan vara ogiltig.',
    'LBL_CONNECT_TWITTER' => 'Anslut till Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'Kan inte hitta giltigt tidsplan för Twitter-ID:',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'Konfigurera Twitter Connector',
    'LBL_CONNECT_TEST_FAIL' => 'Fel: Connector konfigurationsinställningarna kan vara ogiltigt. Kontakta administratören.',
    'LBL_CONFIGURE_TWITTER' => 'Kontakta administratören för att konfigurera Twitter',
    'LBL_MERGE_CONNECTORS' => 'Hämta data',
    'LBL_NO_DATA_AVAILABLE' => 'Inga data tillgängliga.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'Är du säker på att du vill inaktivera "connector" integration för denna modul?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Det gick inte att ansluta till Elastic server',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'Du kan inte ta bort ett global team. Avbryter',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'Det här privata teamet [{0}] kan inte raderas förrän användare [{1}] är raderad.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'Du har antingen Adobe Flash avstäng eller använder en gammal version av Adobe Flash Player. För att hämta senaste versionen av Flash Player, <a href="http://www.adobe.com/go/getflashplayer/">klicka här</a>.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'Namn',
    'LBL_COLLECTION_PRIMARY' => 'Primär',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'Obligatoriskt fält tomt',
    'LBL_COLLECTION_EXACT' => 'Exakt',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'För en optimal upplevelse använd IIS/FastCGI sapi, sätt fastcgi.loggin till 0 i din php.ini fil.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'Tilldelad till',
    'LBL_DESCRIPTION' => 'Beskrivning',
    'LBL_PRIMARY_CONTACT_NAME' => 'Primär kontakt',
    'LBL_PRIMARY_CONTACT_ID' => 'Primär kontakt-ID',

    'LBL_NONE' => '-ingen-',
    'LBL_YESTERDAY' => 'Igår',
    'LBL_TODAY' => 'idag',
    'LBL_TOMORROW' => 'imorgon',
    'LBL_NEXT_WEEK' => 'nästa vecka',
    'LBL_NEXT_MONDAY' => 'nästa måndag',
    'LBL_NEXT_FRIDAY' => 'nästa fredag',
    'LBL_TWO_WEEKS' => 'två veckor',
    'LBL_NEXT_MONTH' => 'nästa månad',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'första dagen nästa månad',
    'LBL_THREE_MONTHS' => 'tre månader',
    'LBL_SIXMONTHS' => 'sex månader',
    'LBL_NEXT_YEAR' => 'nästa år',
    'LBL_FILTERED' => 'Filtrerad',

    //Datetimecombo fields
    'LBL_HOURS' => 'Timmar',
    'LBL_MINUTES' => 'Minuter',
    'LBL_MERIDIEM' => 'Meridiem',
    'LBL_DATE' => 'Datum',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Automatisk uppdatering',

    'LBL_DURATION_DAY' => 'dag',
    'LBL_DURATION_HOUR' => 'timme',
    'LBL_DURATION_MINUTE' => 'minut',
    'LBL_DURATION_DAYS' => 'dagar',
    'LBL_DURATION_HOURS' => 'timmar',
    'LBL_DURATION_MINUTES' => 'minuter',
    'LBL_DURATION_SECONDS' => 'sekunder',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'Välj månad',
    'LBL_ENTER_YEAR' => 'Fyll i år',
    'LBL_ENTER_VALID_YEAR' => 'Vänligen fyll i ett giltigt år',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'Vänligen fyll i ett telefonnummer inklusive riktnummer med siffror.',
    'LBL_CCP_NOT_INITIATED' => 'Försöker ringa med CCP medan agent inte har loggat in.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'Kunde inte initiera samtal via CCP.',
    'LBL_CCP_DIALING_ERROR' => 'Detta samtal kan inte slutföras som det slagits.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'Stäng alla chattsessioner i SugarLive innan du ringer ett utgående samtal.',

    //File write error label
    'ERR_FILE_WRITE' => 'Fel: Kunde inte skriva file {0}. Vänligen kolla system och webserver behörigheter',
    'ERR_FILE_NOT_FOUND' => 'Fel: Kunde inte ladda file {0}. Vänligen kolla system och webserver behörigheter',

    'LBL_AND' => 'Och',
    'LBL_BEFORE' => 'Före',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'Uppladdat Från Din Dator',
    'LBL_SEARCH_EXTERNAL_API' => 'Fil från Extern Källa',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'Ladda upp till extern källa',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'Länk från extern källa',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'Säkerhet',
    'LBL_SHARE_PRIVATE' => 'Privat',
    'LBL_SHARE_COMPANY' => 'Företag',
    'LBL_SHARE_LINKABLE' => 'Möjlig att länka',
    'LBL_SHARE_PUBLIC' => 'Publik',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS-flöde',
    'LBL_RSS_RECORDS_FOUND' => 'protokoll hittade',
    'ERR_RSS_INVALID_INPUT' => 'RSS är inte giltig input_type',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS är inte giltig response_type för den här metoden',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs stödjer inte filformatet du tillhandahåller.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'Tom',
    'LBL_IS_EMPTY' => 'Är tom',
    'LBL_IS_NOT_EMPTY' => 'Är inte tom',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '"This is a sample import file which provides an example of the expected contents of a file that is ready for import."<br />"The file is a comma-delimited .csv file, using double-quotes as the field qualifier."<br /><br />"The header row is the top-most row in the file and contains the field labels as you would see them in the application."<br />"These labels are used for mapping the data in the file to the fields in the application."<br /><br />"Notes: The database names could also be used in the header row. This is useful when you are using phpMyAdmin or another database tool to provide an exported list of data to import."<br />"The column order is not critical as the import process matches the data to the appropriate fields based on the header row."<br /><br /><br />"To use this file as a template, do the following:"<br />"1. Remove the sample rows of data"<br />"2. Remove the help text that you are reading right now"<br />"3. Input your own data into the appropriate rows and columns"<br />"4. Save the file to a known location on your system"<br />"5. Click on the Import option from the Actions menu in the application and choose the file to upload"',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'Tilldelad Användar ID',
    'LBL_EXPORT_CREATED_BY' => 'Skapad av ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'Ändrad av ID',
    'LBL_EXPORT_REPORTS_TO_ID' => 'Rapporterar till ID:',
    'LBL_EXPORT_TEAM_ID' => 'Lag-ID',
    'LBL_EXPORT_TEAM_SET_ID' => 'Team Set ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Tilldelad användare',
    'LBL_EXPORT_FULL_NAME' => 'Hela namnet',
    'LBL_EXPORT_TEAM_NAME' => 'Teams',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navigerar...',

    'LBL_PENDING_NOTIFICATIONS' => 'Meddelanden',
    'LBL_ALT_ADD_TEAM_ROW' => 'Lägg till ny team rad',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'Radera team',
    'LBL_ALT_SPOT_SEARCH' => 'Spot Sök',
    'LBL_ALT_NOT_SORTED' => 'Inte sorterat',
    'LBL_ALT_SORT_DESC' => 'Sorterat Minskande',
    'LBL_ALT_SORT_ASC' => 'Sorterat Ökande',
    'LBL_ALT_SORTABLE' => 'Sorterbar',
    'LBL_ALT_NOT_SORTABLE' => 'Ej sorterbar',
    'LBL_ALT_SORT' => 'Sortera',
    'LBL_ALT_SHOW_OPTIONS' => 'Visa Alternativ',
    'LBL_ALT_HIDE_OPTIONS' => 'Dölj Alternativ',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'Flytta markerad anmälan till vänstra listan',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Flytta markerad anmälan till högra listan',
    'LBL_ALT_MOVE_COLUMN_UP' => 'Flytta markerad anmälan uppåt i den visade listordningen',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'Flytta markerad anmälan neråt i den visade listordningen',
    'LBL_ALT_INFO' => 'Information',
    'MSG_DUPLICATE' => '{0} protokollet du försöker skapa kan vara en dubbelpost av ett {0} protokoll som redan existerar. {1} protokoll som innehåller liknande namn finns listade nedanför.<br>Klicka Skapa {1} för at fortsätta skapa {0}, eller välj existerande {0} listad nedanför.',
    'MSG_SHOW_DUPLICATES' => '{0} protokollet du försöker skapa kan vara en dubbelpost av ett {0} protokoll som redan existerar. {1} protokoll som innehåller liknande namn finns listade nedanför. Klicka Spara för att fortsätta skapa det här nya {0}, eller klicka Avbryt för att återvända till modulen utan att skapat {0}.',
    'LBL_EMAIL_TITLE' => 'emailadress',
    'LBL_EMAIL_OPT_TITLE' => 'bortvald emailadress',
    'LBL_EMAIL_INV_TITLE' => 'ogiltig emailadress',
    'LBL_EMAIL_PRIM_TITLE' => 'primär emailadress',
    'LBL_SELECT_ALL_TITLE' => 'Välj alla',
    'LBL_SELECT_THIS_ROW_TITLE' => 'Välj den här raden',
    'LBL_TEAM_SELECTED_TITLE' => 'Valda Teams',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Välj för att göra det här teamet primär',
    'LBL_TEAM_TBSELECTED_TITLE' => 'Team markerade som team-baserade har valts ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'Markera detta team som Team-baserade som valts',
    'LBL_SEARCH_AND_SELECT' => 'Sök och välj {{module}}',
    'TPL_SEARCH_AND_ADD' => 'Sök och lägg till {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'FEL: Fel uppstod under uppladdning. Error code: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'FEL: Fel uppstod under uppladdning. Error code: {0} - {1}. upload_maxsize är {2}',
    'UPLOAD_ERROR_HOME_TEXT' => 'FEL: Fel uppstod under uppladdningen, vänligen kontakta administratören för hjälp.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'Storleken för Uppladdningen ({0} bytes) Överskred Maximalt Tillåtna: {1} bytes',
    'UPLOAD_REQUEST_ERROR' => 'Ett fel har inträffat. Uppdatera din sida och försök igen.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => 'Redigera',
    'LBL_ADD_BUTTON_LABEL' => 'Lägg till',
    'LBL_EDIT_BUTTON_TITLE' => 'Redigera [Alt+E]',
    'LBL_REFRESH_BUTTON_LABEL' => 'Uppdatera',
    'LBL_REFRESH_BUTTON_TITLE' => 'Uppdatera',
    'LBL_DUPLICATE_BUTTON_KEY' => 'u',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Duplicera',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Duplicera [Alt+U]',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'Rapportscheman',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'Rapportscheman',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'Rapportdetaljer',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'Rapportdetaljer',
    'LBL_DELETE_BUTTON_KEY' => 'd',
    'LBL_DELETE_BUTTON_LABEL' => 'Radera',
    'LBL_DELETE_BUTTON_TITLE' => 'Radera [Alt+D]',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => 'Spara',
    'LBL_SAVE_BUTTON_TITLE' => 'Spara [Alt+S]',
    'LBL_CANCEL_BUTTON_KEY' => 'l',
    'LBL_CANCEL_BUTTON_LABEL' => 'Avbryt',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'att sluta.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'att stanna på sidan.',
    'LBL_CANCEL_BUTTON_TITLE' => 'Avbryt [Alt+X]',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'Dela',
    'LBL_SHARE_BUTTON_TITLE' => 'Dela',
    'LBL_START_BUTTON_LABEL' => 'Start',
    'LBL_START_BUTTON_TITLE' => 'Start',
    'LBL_FINISH_BUTTON_LABEL' => 'Avsluta',
    'LBL_FINISH_BUTTON_TITLE' => 'Avsluta',
    'LBL_CONFIRM_BUTTON_LABEL' => 'Bekräfta',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'för att fortsätta.',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'att lämna sidan och ignorera ändringar.',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Kortkommandon',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Form Funktionalitet - Alt+</strong><br/> I = red<b>I</b>gera (detaljvy)<br/> U = d<b>U</b>plicate (detaljvy)<br/> R = <b>R</b>adera (detaljvy)<br/> L = De<b>L</b>a (detaljvy)<br/> A = sp<b>A</b>ra (editview)<br/> L = annul<b>L</b>era (editview) <br/><br/></p><p><strong>Sök och Navigation  - Alt+</strong><br/> 7 = första ingång på Edit formulär<br/> 8 = Avancerad sök länk<br/> 9 = Första Sökformulär ingång<br/> 0 = Unified sök ingång<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'Eskalera',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'Dela',
    'TPL_RECORD_SHARE_SUBJECT' => 'Delad {{module}} {{name}} från {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'Vänligen kolla {{module}} {{name}} från {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'connector matrisen i {0} är definierad felaktigt eller är tom och kan inte användas.',
    'LBL_PDF_VIEW' => 'Ladda ner PDF',
    'LBL_PDF_EMAIL' => 'Emaila PDF',

    'ERR_SUHOSIN' => 'Uppladdnings stream är blockerad av Sushosin, vänligen lägg till "upload" till suhosin.executor.include.whitelist (Se sugarcrm.log för mer information)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'precis nu',
    'LBL_TIME_AGO_SECONDS' => 'mindre än en minut sedan',
    'LBL_TIME_AGO_MINUTE' => 'ungefär en minut sedan',
    'LBL_TIME_AGO_MINUTES' => '{{this}} minuter sedan',
    'LBL_TIME_AGO_HOUR' => 'ungefär en timme sedan',
    'LBL_TIME_AGO_HOURS' => '{{this}} timmar sedan',
    'LBL_TIME_AGO_DAY' => 'Igår',
    'LBL_TIME_AGO_DAYS' => '{{this}} dagar sedan',
    'LBL_TIME_AGO_YEAR' => 'över ett år sedan',
    'LBL_TIME_UNTIL_SECONDS' => 'på mindre än en minut',
    'LBL_TIME_UNTIL_MINUTE' => 'inom ungefär en minut',
    'LBL_TIME_UNTIL_MINUTES' => 'inom {{this}} minuter',
    'LBL_TIME_UNTIL_HOUR' => 'om en timme',
    'LBL_TIME_UNTIL_HOURS' => 'inom {{this}} timmar',
    'LBL_TIME_UNTIL_DAY' => 'imorgon',
    'LBL_TIME_UNTIL_DAYS' => 'inom {{this}} dagar',
    'LBL_TIME_UNTIL_YEAR' => 'i över ett år',
    'LBL_TIME_RELATIVE' => 'Publicerad {{relativetime}} den {{date}} klockan {{time}}',
    'LBL_LAST_TOUCHED' => 'Senast rörde {{relativetime}} på {{date}} på {{time}}',
    'LBL_LAST_COMMIT' => 'Senaste förpliktelsen: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'Inga protokoll hittades just nu.',
    'LBL_DETAILVIEW_NO_RECORDS' => 'Det här protokollet kunde inte renderas just nu.',
    'LBL_REFINE_LIST' => 'Förfina lista',
    'LBL_SEARCH_BY' => 'Sök med',
    'LBL_PREVIEW' => 'Förhandsgranska',
    'LBL_COLUMNS' => 'Kolumner',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'Förhandsvy inaktiv: Uppgift saknas',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'Förhandsvy inaktiv: Ingen tillgång till posten',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'Förhandsvy inaktiv: Uppgift saknas',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'Förhandsvy: Med tanke på aktuell post',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'Förhandsvy inaktiv: Post raderad bort eller ingen tillgång till posten',
    'LBL_PREVIEW_PREVIOUS' => 'Förhandsgranska föregående',
    'LBL_PREVIEW_NEXT' => 'Förhandsgranska nästa',
    'LBL_PREVIEW_CLOSE' => 'Förhandsgranska Stäng',
    'LBL_STREAM_NO_RECORDS' => 'Det här protokollet har inte anteckningar just nu. Vänligen lägg till anteckning genom att klicka på lägg till anteckningsknappen.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} dubbletter hittades.',
    'LBL_NO_DUPLICATES_FOUND' => 'Inga kopior hittades.',
    'LBL_RESET_DEFAULT_VIEW' => 'Återställ till standardvy',
    'LBL_RESET_DEFAULT_WIDTHS' => 'Återställ till standardvidd',
    'LBL_TIMEZONE_UPDATED' => 'Sugar har uppdaterat din tidszon för användarprofil så att den matchar din webbläsares tidszon',
    'LBL_SUCCESS' => 'Success',
    'LBL_ERROR' => 'Error',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'Hantera kopior',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'Vill du fortsätta? Avbryt för att avbryta. Bekräfta att radera poster.',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'Denna åtgärd kommer att radera följande rad(er):',
    'LBL_MERGE' => 'Slå ihop',
    'TPL_MERGING_RECORDS' => 'Slå samman {{mergeCount}} poster',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'Ogiltigt antal poster passerat. Giltiga värden är från {{minRecords}} till {{maxRecords}} poster.',
    'LBL_MERGE_NO_ACCESS' =>
        'Du har inte tillgång att utföra den här åtgärden. Minst en post måste vara redigerbar.',
    'LBL_MERGE_LOCKED' => 'Några av de poster som har valts för sammanfogning innehåller fält som är låst för redigering av en process och kan inte sammanfogas vid denna tid.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'Alla ändringar kommer att kasseras när du växlar till en ny primär post. Är du säker på att du vill byta?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'Slå ihop Relaterade poster',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'Sammanslagen: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'Slå ihop relaterad {{objectName}} misslyckades. Initiera nytt försök ({{num}} av {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'Slå ihop relaterad {{objectName}} misslyckades.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'Slå ihop av relaterade poster ofullständig. Vissa poster är fortfarande inte sammanslagen.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'Några relaterade poster har inte sammanfoga ordentligt. Avbryt för att avbryta. Bekräfta för att fortsätta sammanfogning.',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'Alla relaterade poster kommer att flyttas till den primära posten.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'Är du säker på att du vill ta bort denna post från sammanfogning?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'Ta bort post från sammanfogning',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'Ogiltigt antal poster. Giltigt intervall är från 1 till {{maxRecords}} poster.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'Användarnamnet/lösenord kombinationen du uppgav är felaktig, vänligen försök igen.',
    'LBL_INVALID_CREDS_TITLE' => 'Fel Inloggningsuppgifter',
    'LBL_INVALID_GRANT' => 'Din token är ogiltig eller har gått ut. Vänligen logga in igen.',
    'LBL_INVALID_GRANT_TITLE' => 'Token har gått ut',
    'LBL_AUTH_FAILED' => 'Klient autentiseringen misslyckades',
    'LBL_AUTH_FAILED_TITLE' => 'Felaktig klient',
    'LBL_INVALID_REQUEST' => 'Begäran som gjordes är ogiltig eller felutformad. Vänligen kontakta teknisk support.',
    'LBL_INVALID_REQUEST_TITLE' => 'Ogiltig begäran',
    'LBL_REQUEST_TIMEOUT' => 'Servern svarar inte. Kontrollera din Internetanslutning.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'Begäran timeout: ',
    'LBL_UNAUTHORIZED' => 'Tyvärr, det verkar som om du inte har behörighet att få tillgång till den här resursen.',
    'LBL_UNAUTHORIZED_TITLE' => 'Obehörig',
    'LBL_RESOURCE_UNAVAILABLE' => 'Resursen är inte tillgänglig',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'Förbjuden',
    'LBL_METHOD_NOT_ALLOWED' => 'HTTP metoden är inte tillåten för den här resursen. Vänligen kontakta teknisk support.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'Metod inte tillåten',
    'LBL_PRECONDITION_MISSING' => 'Begäran misslyckades, eller, saknade/ogiltig parameter. Vänligen kontakta teknisk support.',
    'LBL_PRECONDITION_MISSING_TITLE' => 'Fel:',
    'LBL_INVALID_412_RESPONSE' => 'En begäran misslyckas vilket gör programmet oanvändbart. Kontakta teknisk support.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'Inte tillåtet att redigera fältet {0} i modul: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'Inte tillåtet att utföra åtgärden "{0}" på denna post',
    'LBL_LOGIN_BUTTON_LABEL' => 'Logga In',
    'LBL_ACTIVITY_VIEW_TOUR' => 'Aktivitet View Tour',
    'LNK_TOUR' => 'Rundtur',
    'LNK_MOBILE' => 'Mobil',
    'LBL_FEEDBACK' => 'Feedback',
    'LBL_SUPPORT' => 'Support',
    'LBL_LANGUAGE' => 'Språk',
    'LBL_LOADING_LANGUAGE' => 'Laddar språkpaket',
    'LBL_UPLOADING' => 'Laddar Upp',
    'LBL_UPLOADING_DOTS' => 'Laddar upp ...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'Är du säker på att du vill ta bort den här bilden?',
    'LBL_FILE_DELETE_CONFIRM' => 'Är du säker på att du vill radera denna fil? Detta går inte att ångra.',
    'LBL_FILE_DELETED' => 'Fil har tagits bort',

    //theme roller
    'LBL_PORTAL_THEME' => 'Tema Portal',
    'LBL_THEME_PREVIEW' => 'Förhandsgranskning av portaltema',
    'LBL_LOADING_PREVIEW' => 'Laddar Förhandsvisning',
    'LBL_RESET' => 'Återställ',
    'LBL_COLORS' => 'Färger',
    'BorderColor' => 'Kantfärg',
    'NavigationBar' => 'Navigeringsfältet',
    'PrimaryButton' => 'Primär knapp',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'Spara & publicera',
    'LBL_RESET_THEME_LNK' => 'Återställ standard tema',
    'LBL_RESET_THEME_MODAL_INFO' => 'Är du säker på att du vill kasta dina tema anpassningar och ersätta med standardtemat?',
    'LBL_RESET_THEME_PROCESS' => 'Återställa standardtema...',
    'LBL_SAVE_THEME_PROCESS' => 'Sparar tema...',

    // image loader
    'LBL_SELECT_PHOTO' => 'Välj ett foto',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Förbättrad prognos funktionalitet i Sugar',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Start dina prognosparametrar</li><li class="icon-ok">Enkelt spåra din beräknade försäljning och pipeline status</li><li class="icon-ok">Prognos baserad på förväntad försäljning från ditt säljteam</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'Setup dina prognosparametrar',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Välj räkenskapsår startdatum</li><li class="icon-ok">Konfigurera tidsperioder vara antingen årligen eller kvartalsvis</li><li class="icon-ok">Bestäm hur många tidigare och framtida tidsperiod måste vara synlig i kalkylbladet</li><li class="icon-ok">Välj prognos intervaller för att märka Affärsmöjligheter som Inkludera, Exkludera eller Upside</li><li class="icon-ok">Välj Prognos scenarier för att identifiera Troligt, Bäst och Värst prognos</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'Hantera ditt säljteams prognostiserade försäljning',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Välj den tidsperiod för att se över prognos</li><li class="icon-ok">Granska ditt sälj teammedlemmarnas arbetsark och erbjuda justerade prognoser</li><li class="icon-ok">Se varning på arbetsblad när ett säljteam medlem uppdaterar en ny commit i prognos arbetsarket</li><li class="icon-ok">Spara prognos arbetsarket som ett utkast eller commit prognosen till din chef</li><li class="icon-ok">Visa historik över tidigare commits</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'Hantera ditt säljteams prognostiserade försäljning',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Visa Pareto diagram för pipeline analys genom alla dina säljteammedlemmarnas prognoser</li><li class="icon-ok">Välj att visualisera beräknade försäljningen med Sannolikt, Bäst eller Värst prognos</li><li class="icon-ok">Visa olika försäljninger och hur nära du är att nå ditt teams budget</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'Hantera din förväntad försäljning',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Välja tidsperiod för din prognos</li><li class="icon-ok">Granska och in-line redigera belopp och Vinn Sannolikhet för en snabb vad-händer-om analys</li><li class="icon-ok">Spara prognos arbetsarket som ett utkast eller commit prognosen till din chef</li><li class="icon-ok">Visa historik över tidigare commits</li><li class="icon-ok">Commita prognos till chef och visa historik över tidigare commits</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'Hantera din förväntade försäljning',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Visa Pareto diagram för pipeline analys över tid för dina affärsmöjligheter</li><li class="icon-ok">Välj att visualisera pipeline distribution från försäljningsfas eller Vinn Sannolikhet</li><li class="icon-ok">Visa sannolik försäljning och hur nära du är att nå din tilldelad budget</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Vad är nytt i Sugar',
    'LBL_TOUR_WATCH' => 'Titta på Nyheter i Sugar',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="icon-ok">IFörbättrad utseendet - nu med ett nytt modernt tema. </li><li class="icon-ok">Förbättrad Prognoser modul - nu med intuitivt användargränssnitt och nya datavisualisering</li></ul>',
    'LBL_TOUR_VISIT' => 'För mer information besök vår applikation',
    'LBL_TOUR_DONE' => 'Du är klar!',
    'LBL_TOUR_REFERENCE_1' => 'Du kan alltid referera vår',
    'LBL_TOUR_REFERENCE_2' => 'via länken "Support" under profilmenyn.',
    'LNK_TOUR_DOCUMENTATION' => 'dokumentation',
    'LBL_TOUR_CALENDAR_URL_1' => 'Vill du dela din SugarCRM kalender med 3: e parts applikationer, till exempel Microsoft Outlook eller Exchange? Om så är fallet, har du en ny webbadress. Denna nya, säkrare URL innehåller en personlig nyckel som kommer att förhindra obehörig publicering av din kalender.',
    'LBL_TOUR_CALENDAR_URL_2' => 'Hämta din nya delad kalender URL.',
    'LBL_TOUR_CUBE' => 'Få access till Dashboards och aktiviteter',
    'LBL_TOUR_NAV_BAR' => 'Få tillgång till alla moduler i navigationsmenyn',
    'LBL_TOUR_NOTIFICATIONS' => 'Klicka för att se meddelanden',
    'LBL_TOUR_SEARCH' => 'Välj en eller flera moduler och sök',
    'LBL_TOUR_AVATAR' => 'Få mer information om programmet eller logga ut',
    'LBL_TOUR_ADD' => 'Skapa en post härifrån',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'Klicka för att stänga eller öppna iintelligence pane',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'Välj att se aktiviteter eller lista med poster',
    'LBL_TOUR_LIST_FILTER1' => 'Filter bar gör det möjligt söka efter denna modul',
    'LBL_TOUR_LIST_FILTER2' => 'Välj förinställt filter eller skapa nya',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'Skriv här för att söka utifrån namn',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'Välj att redigera raden eller förhandsgranska detaljer',
    'LBL_TOUR_RECORD_ACTIONS' => 'Vidta åtgärder på posten',
    'LBL_TOUR_RECORD_SUBPANEL' => 'Klicka på sidhuvudet för att visa och dölja underpanelen',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'Postens namn kan uppdateras på plats',
    'LBL_TOUR_RECORD_STATUS' => 'Hitta post nivå status här',
    'LBL_TOUR_RECORD_SHOWMORE' => 'Klicka för att se mer data för posten',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'Välj att se aktiviteter eller relaterade poster',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'Klicka för att redigera varje fält inline',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'Skapa nya grupper av dashlets',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'Tilldela ett namn till gruppen av dashlets',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'Välj att ta bort dashlet eller ändra inställningar',
    'LBL_TOUR_INTRO' =>'<h4>Välkommen till Sugar!</h4> Vi skulle vilja visa dig några av funktionerna här i Sugar. Använd pilarna < och > längst ned på skärmen för att ta en rundtur.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">Nytt</a><p class="details">Få reda på de viktigaste förändringarna mellan utgåvor.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Läs mer om Sugar</a><p class="details">Ett omfattande bibliotek med e-lärande, live och virtuell klassrumsutbildning, webbseminarier och handledningsvideor.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">Få support</a><p class="details">Behöver du hjälp, har ett problem eller vill ge förslag på hur Sugar kan förbättras?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'Visa en lista över poster och vidta åtgärder för poster.',
    'LBL_TOUR_RECORD_INTRO' => 'Se detaljer om denna post och se alla uppgifter om det.',
    'LBL_TOUR_FORECAST_INTRO' => 'Hantera pipeline och prognos.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'Välj en tidsperiod för att se motsvarande prognos',
    'LBL_TOUR_FORECASTS_COMMITS' => 'Klicka för att se tidigare commits',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'Klicka för att redigera uppgifter inline',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'Review avståndet till budget',
    'LBL_TOUR_FORECASTS_CHART' => 'Review Prognos fördelning',
    'LBL_TOUR_TOUR' => 'Ta en rundtur när som helst',
    'LBL_TOUR_TAGS_ADD' => 'Klicka på fältet Taggar om du vill lägga till och ta bort taggar',
    'LBL_TOUR_TAGS_DELETE' => 'För att radera en tagg, använd backsteg eller klicka [X] på varje tagg',
    'LBL_TOUR_RECORD_SAVE' => 'När du är klar, klicka på Spara',


    'LBL_FUTURE' => 'Framtiden',
    'LBL_REQUIRED_FIELD' => 'Obligatoriskt',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'Offererad radartikel',
    'LBL_DISCOUNT_TOTAL' => 'Total rabatt',
    'LBL_DISCOUNT_PERCENT' => '% Procent',
    'LBL_DISCOUNT_SELECT' => 'Bestämmer om rabatten är en procentsats eller ett schablonbelopp',
    'LBL_TAX' => 'Skatt',
    'LBL_SHIPPING' => 'Frakt',
    'LBL_GRAND_TOTAL' => 'Totalsumma',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'Automatiskt fylla i faktureringsadress från kontoprofil',
    'LBL_QLI_ADD_GROUP' => 'Lägga till en grupp',
    'LBL_QLI_COMMENT' => 'Kommentar',
    'LBL_SELECT_ACTION' => 'Välj åtgärd',
    'LBL_QLI_GROUP_NAME' => 'Gruppnamn',
    'LBL_GROUP_TOTAL' => 'Gruppsumma',
    'LBL_ITEM_NAME' => 'Radartikel',
    'LBL_QLI_DELETE' => 'Är du säker på att du vill ta bort denna radartikel?',
    'LBL_QLI_COMMENT_DELETE' => 'Är du säker på att du vill ta bort denna radartikelkommentar?',
    'LBL_QLI_GROUP_DELETE' => 'Vill du verkligen ta bort grupp {0}? Alla objekten kommer att flyttas till standardgrupp.',
    'LBL_QLI_GROUP_EMPTY' => 'Ingen offererad radartikel',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'Valfritt',
    'LBL_RELATED_MODULE' => 'Relaterad {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'Relaterad {{{this}}}',
    'LBL_CREATE_MODULE' => 'Skapa {{{this}}}',
    'LBL_EDIT' => 'Redigera {{{this}}}',
    'LBL_ASSOC' => 'Länk {{{this}}}',
    'LBL_ASSIGN' => 'Välj {{{this}}}',
    'LBL_EDIT_RELATED' => 'Uppdatera {{{this}}}',
    'LBL_CREATE_RELATED' => 'Skapa Relaterad {{{this}}}',
    'LBL_ASSOC_EXISTING' => 'Länk Existerande {{{this}}}',
    'LBL_SEARCH_ALL' => 'Sök alla {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'Sök igenom alla poster...',
    'LBL_SEARCH_ALL_MODULES' => 'Sök alla',
    'LBL_OK' => 'OK',
    'LBL_YES' => 'Ja',
    'LBL_NO' => 'Nej',
    'LBL_SHOW_NUMBERING' => 'Visa etappnumrering',
    'LBL_HIDE_NUMBERING' => 'Dölj etappnumrering',
    'LBL_CALL_BUTTON' => 'Samtal',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'Email',
    'LBL_HONEYPOT' => 'Om du är en verklig person fylla inte i detta.',
    'LBL_LINK_BUTTON' => 'Länk',
    'LBL_UNLINK_BUTTON' => 'Ta bort länken',
    'LBL_MAP_BUTTON' => 'Karta',
    'LBL_FILE_BUTTON' => 'Fil',
    'LBL_URL_BUTTON' => 'Webb',
    'LBL_WARNING' => 'Varning',
    'LBL_CONFIRM' => 'Bekräfta',
    'LBL_CONFIRMATION_POPUP' => 'Popupfönster för bekräftelse',
    'LBL_NO_ACCESS' => '(Ingen tillgång)',
    'LBL_NO_ACCESS_LOWER' => 'Ingen tillgång',
    'LBL_NO_FIELD_ACCESS' => 'Ingen tillgång',
    'LBL_NO_LICENSE_ACCESS' => 'Licens krävs',
    'LBL_VALUE_ERASED' => 'Värdet raderades',
    'LBL_VALUE_ERASED_TOOLTIP' => 'Den här informationen raderas via datasekretessbegäran',
    'LBL_CREATE_RELATED_RECORD' => 'Skapa Relaterad Post',
    'LBL_ASSOC_RELATED_RECORD' => 'Länk till befintlig post',
    'LBL_CHOOSE_LINK' => 'Välj Länktyp',
    'LBL_CHOOSE_PARENT_TYPE' => 'Välj Huvud Typ',
    'LBL_HOME' => 'Hem',
    'ERR_NO_DOCS' => 'Inga dokument tillgängliga',
    'ERR_NO_RECORDS_SELECTED' => 'Du har inte valt några poster.',
    'LBL_DELETING' => 'Raderar...',
    'LBL_UNLINKING' => 'Tar bort länken...',
    'LBL_UNLINKED' => 'Olänkad',
    'LBL_LEGAL' => 'Juridisk',
    'LBL_UPCOMING' => 'Mina kommande event',
    'LBL_RECENTLY_UPDATED' => 'Nyligen uppdaterade',
    'LBL_NOTES_SUBPANEL_TITLE' => 'Anteckningar',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'Möten',
    'LBL_TASKS_SUBPANEL_TITLE' => 'Uppgifter',
    'LBL_CALLS_SUBPANEL_TITLE' => 'Telefonsamtal',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'Konton',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'Kontakter',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'Email',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'Skift',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'Produkter',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'Skiftundantag',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'Dokument',
    'LBL_ESCALATIONS' => 'Eskaleringar',
    'LBL_ESCALATED' => 'Har eskalerats',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'Eskaleringar',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'Andra relaterade eskaleringar',
    'LBL_ESCALATIONS' => 'Eskaleringar',
    'LNK_SETTINGS' => 'Inställningar',
    'LBL_MOBILE_SUPPORT' => 'Support',
    'LBL_MOBILE_SHOW_MORE' => 'Visa fler ...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'Visa fler ...',
    'LBL_MOBILE_NO_RECORDS' => 'Inga poster funna',
    'LBL_MOBILE_SEARCH_TEAMS' => 'Sök efter team...',
    'LBL_MOBILE_SELECT_TEAMS' => 'Välj team',
    'LBL_MOBILE_WAIT' => 'Var god vänta...',
    'LBL_MOBILE_LOGING_OUT' => 'Var god vänta medan du loggar ut ...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'Ny inloggning',
    'LBL_MOBILE_META_SYNC_FAILED' => 'Det går inte att synkronisera med servern.',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'Det går inte att synkronisera med servern. Försöka igen?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'Sekretess, Regler, & Villkor',
    'LBL_MOBILE_APP_VERSION' => 'Appversion',
    'LBL_MOBILE_SERVER_VERSION' => 'Serverversion',
    'LBL_MOBILE_SERVER_URL' => 'Server-URL',
    'LBL_MOBILE_PTR_PULL' => 'Dra ner för att uppdatera',
    'LBL_MOBILE_PTR_RELEASE' => 'Släpp för att uppdatera...',
    'LBL_MOBILE_EDIT_REL' => 'Redigera Relation',
    'LBL_MOBILE_DESKTOP' => 'Skrivbordsversion',
    'LBL_MOBILE_DELETE_CONFIRM' => 'Är du säker på att du vill radera posten?',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'Är du säker på att du vill ta bort länken för denna post?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'Vill du logga ditt senaste samtal?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'Välj mottagare',
    'LBL_MOBILE_CHOOSE_PHONE' => 'Välj telefonnummer',
    'LBL_MOBILE_CHOOSE_URL' => 'Välj URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'Välj dokument',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'Välj plats',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'Inga åtgärder Tillgängliga',
    'LBL_MOBILE_FEEDBACK' => 'Feedback',
    'LBL_MOBILE_DOC' => 'Dokument',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'Nedladdning startat: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'Nedladdning färdig: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'Ladda upp fil ...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'Fil uppladdad',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'Förbereder bild...',
    'LBL_CLOSE_SAVE_BUTTON' => 'Stäng uppgift och spara',
    'LBL_LATER' => 'Senare',
    'LBL_USE_HTTPS' => 'Använda en säker anslutning',
    'LBL_LOADING_FILES' => 'Laddar fortfarande dokumentlista. Försök gärna igen senare',
    'LBL_NEW_WEB_VERSION' => 'En ny version av det här programmet är tillgänglig. Vill du uppdatera?',
    'LBL_SET_FONTSIZE' => 'Fontstorlek',
    'LBL_FONTSIZE_TINY' => 'Mycket liten',
    'LBL_FONTSIZE_SMALL' => 'Liten',
    'LBL_FONTSIZE_NORMAL' => 'Normal (standard)',
    'LBL_FONTSIZE_LARGE' => 'Stor',
    'LBL_FONTSIZE_LARGER' => 'Större',
    'LBL_FONTSIZE_HUGE' => 'Enorm',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'Extra enorm',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "Download failed\r\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'Mer...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...Mindre',
    'LBL_OFFLINE_MODE' => 'Offlineläge',
    'LBL_OFFLINE_DELETED' => 'Post hittades inte.',
    'LBL_OFFLINE_DELETED_RELATED' => 'Relaterad post hittades inte. Den er förmodligen raderad eller olänkad.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'Nedladdning av dina tilldelade, favoriter och följde poster för offlineåtkomst kan ta tid att slutföra. En snabb anslutning rekommenderas. Vill du fortsätta?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'Vill du att dina tilldelade, favoriter och följde poster ska laddas ned nu för offline tillgång? En snabb anslutning rekommenderas eftersom denna operation kan ta lite tid. Du kan ladda ner senare från Huvudmeny> Offline.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'Poster laddats ner med framgång',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'Ladda ner dina poster...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'Fel under nedladdning av poster',
    'LBL_OFFLINE_PREFETCHING' => 'Laddar poster...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'Laddar {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'Tid kvar är ungefär {{estimatedTime}}er...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => 'Nedladdning av {{module}} färdig',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'Rengöring av lagring...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'Rengöring klar',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'Vill du backa denna förändring?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'Rollback färdig',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'Rollback misslyckades',
    'LBL_OFFLINE_CLEAR_DB' => 'Rensa Storage ......',
    'LBL_OFFLINE_COMPACT_DB' => 'Kompakt Storage ...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'Denna åtgärd kommer att radera poster som du inte har haft tillgång till på ett tag. Gå vidare?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'Vill du ta bort alla poster från den lokala lagringsplatsen?',
    'LNK_OFFLINE_SETTINGS' => 'Offline',
    'LBL_OFFLINE_SETTINGS' => 'Debug inställningar',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'Inga ändringar i avvaktan synkronisering.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'Förändringar är anhängiga synkronisering.',
    'LBL_OFFLINE_STATUS_ONLINE' => 'Device är online.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'Device är offline.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'Det går inte att nå servern.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'Senaste synkroniseringsförsök misslyckades. Kontrollera transaktionsloggen.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'Synkronisering pågår ...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'Transaktionen synkroniserad.',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'Är du säker på att du vill slå på offline support?',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'Vill du stänga av offline support? Alla ändringar i avvaktan synkroniseringen kommer att gå förlorade.',
    'LBL_OFFLINE_ENABLED' => 'Offlineläge aktiverat',
    'LBL_OFFLINE_DISABLED' => 'Offlineläge inaktiv',
    'LBL_OFFLINE_STATS' => 'Lagrings statistik',
    'LBL_OFFLINE_SERVER_FETCH' => 'Hämtar från servern ...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'Någon har redigerat samma post på servern. Bekräfta att automatiskt slå ihop dina ändringar eller avvisa för att kasta dem.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'Senaste synkroniseringsförsöket => {{ts}}',
    'LBL_ACTION_UPDATE' => 'UPPDATERING',
    'LBL_ACTION_CREATE' => 'SKAPA',
    'LBL_ACTION_DELETE' => 'RADERA',
    'LBL_ACTION_LINK' => 'LÄNK',
    'LBL_ACTION_UNLINK' => 'AVLÄNKA',
    'LBL_ACTION_FAVORITE' => 'FAVORIT',
    'LBL_ACTION_FOLLOW' => 'FÖLJ',
    'LBL_ACTION_CREATE_EXPLANATION' => 'Skapad {{module}} &#39;{{name}}&#39;',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'Uppdaterad {{module}} &#39;{{name}}&#39;',
    'LBL_ACTION_DELETE_EXPLANATION' => 'Raderad {{module}} &#39;{{name}}&#39;',
    'LBL_ACTION_LINK_EXPLANATION' => 'Länkad {{module}} &#39;{{name}}&#39; till {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'Olänkad {{module}} &#39;{{name}}&#39; från {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'Följde {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'Unfollowed {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'Favoriserad {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'Unfavorited {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'Skapad {{module}} &#39;{{name}}&#39; relaterad till {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'Primär',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'Önskar ej utskick',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'Gå med',
    'LBL_EMAIL_ACTION_SET_VALID' => 'Giltig',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'Ogiltig',
    'LBL_ROLLBACK_BUTTON' => 'Ångra',
    'LBL_TX_LOG' => 'Transaktionsförteckning',
    'LBL_TX_LOG_DETAIL' => 'Transaktions Detalj',
    'LBL_RECORD_DELETED' => '(Post raderad)',
    'LBL_NOT_AVAILABLE' => 'N/A',
    'LBL_FILE_SIZE' => 'Filstorlek',
    'LBL_FILE_SIZE_UNITS_B' => 'Bytes',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'Välj objekter',
    'LBL_OFFLINE_DB_SIZE' => 'Databasstorlek',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'Poster per modul',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'Totalt antal poster',
    'LBL_RECORD_NOT_FOUND' => 'Post hittades inte.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'Relaterad post kunde inte hittas.',
    'LBL_NOT_AUTHORIZED' => 'Du har inte behörighet att se den här posten.',
    'LBL_MOBILE_PROCESSING_FILE' => 'Preparerar filen...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'Tredjepartsprogramvara',
    'LNK_TERMS_OF_USE' => 'Villkor för användning',
    'LNK_PRIVACY_POLICY' => 'Integritetspolicy',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'Enkel inloggning',
    'LBL_RECENTS' => 'Senaste',
    'LBL_SHOWING_CACHED_DATA' => 'Det går inte att nå servern. Visar senaste uppgifterna ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'Stäng {{moduleSingular}} och spara',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'Specifik panel',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Specifik modul',
    'LBL_MOBILE_DEFAULT_VIEW' => 'Startskärm',
    'LBL_MOBILE_DEFAULT_MODULE' => 'Vald modul',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'Vald panel',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'Vald dashlet',
    'LBL_ALL_DASHLETS' => 'Alla dashlets',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'Global Sök',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Skriv @ för att nämna en användare. Skriv # för att referera till en post.',
    'LBL_MOBILE_NEW_COMMENT' => 'Ny kommentar',
    'LBL_RECENTLY_VIEWED' => 'Senast visade',
    'LBL_FILE_STORED_LOCALLY' => 'Filen lagras på lokal lagring och synkroniseras när enheten är online.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'Om du vill ändra vissa fält som inte kan redigeras, kontakta administratören för att meddela dessa ändringar.',
    'LBL_ACTIVITY_POST' => '{{{value}}}på {{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'Ingen kommentar',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'Visa nästa {{{commentsLeft}}} kommentarer',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'Minska',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'Bekräfta att kommentar skapats',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'Kommentarsloggen kan inte vara tom',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'Ladda ner {{{pdfTemplateName}}} PDF',

    'ERR_SYNC_FAILED' => 'Det går inte att synkronisera med servern.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'Tillgång ej tillåten.',
    'ERR_MOBILE_INVALID_CREDS' => 'Ogiltigt användarnamn eller lösenord.',
    'ERR_MOBILE_SESSION_EXPIRED' => 'Din session gått ut.',
    'ERR_MOBILE_NOT_FOUND' => 'Resursen hittades inte.',
    'ERR_MOBILE_TIMEOUT' => 'Servern svarar inte.',
    'ERR_MOBILE_CONNECTION_FAILED' => 'Det går inte att nå servern.',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'Internet-anslutning är inte tillgänglig.',
    'ERR_MOBILE_INTERNAL' => 'Internt fel ({{{code}}}). Vänligen försök senare.',
    'ERR_MOBILE_VALIDATION' => 'Post är ogiltig',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'Oförenligt server flavor: {{{flavor}}}. Supported flavors: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'Oförenligt serverversion: {{{version}}}. Minimum erforderliga version: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'Fel. Ogiltig emailadress.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'Denna typ dokument stöds inte.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'Autentisering misslyckades.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'Efterfrågad tillgång hittades inte.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'Internt serverfel.',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'Förbjuden.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'Service otillgänglig.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'Ett oväntat fel har uppstått.',
    'ERR_MOBILE_UPLOAD' => 'Fel vid filuppladdning',
    'ERR_MOBILE_FILE_PROCESSING' => 'Fil bearbetningsfel',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'Device förvaring är inte tillgänglig',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'Din app är föråldrad och är inte längre förenlig med den {{{brandName}}} instans du ansluter till. Vill du ladda ner den nya versionen från App Store?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'Server konfiguration har förändrats och omladdning krävs. Gå vidare?',
    'ERR_MOBILE_CONFLICT' => 'Någon har redigerat samma post på servern. Bekräfta att automatiskt slå ihop dina ändringar eller avvisa för att kasta dem.',
    'ERR_MOBILE_METADATA_CHANGED' => 'Server konfiguration har ändrats.',
    'ERR_MOBILE_FILE_READ' => 'Det gick inte att läsa filen',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'Filen hittades inte',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'Filen är inte läsbar',
    'ERR_MOBILE_FILE_ABORTED' => 'Läs operationen avbröts',
    'ERR_MOBILE_FILE_SECURITY' => 'Filen är låst',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'Mobil versionen stöder inte den här funktionen. Vill du öppna den stationära versionen?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'Filen är för stor. Högsta tillåtna storlek är {{size}}',
    'ERR_OFFLINE' => 'Offline fel',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'Det gick inte att öppna lokal lagring',
    'ERR_OFFLINE_STORAGE_CREATE' => 'Det gick inte att skapa lokal lagring',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'Det gick inte att skapa lokal lagring: du har slut om plats.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'Du har slut om plats för lokal lagring.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'Databas sanering misslyckades',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'Du har ingen mer plats för offline-förvaring. Lagringssanering rekommenderas. Det kan ta några minuter.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'Det gick inte att prefetch poster från servern',
    'ERR_OFFLINE_SYNC_ERROR' => 'Synkroniserings fel',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'Synkroniserings konflikt',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'Det gick inte att få servertid',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'Kunde inte aktivera offline-läge. Det går inte att nå servern.',
    'LBL_EXPORT_CSV' => 'Exportera CSV',
    'LBL_ERR_EXPORTING_CSV' => 'Exportering misslyckades',
    'LBL_ERR_EXPORT_ALL' => 'Hämtandet av data för de valda uppgifterna misslyckades, försök igen',
    'LBL_LIST_SETTINGS_RESTORE' => 'Återställ till standard',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'Återställ fält?',
    'LBL_LIST_SETTINGS_TITLE' => 'Listvy byggare',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'Tillgängliga fält',
    'LBL_LIST_SETTINGS_REMOVE' => 'Ta bort',
    'LBL_LIST_SETTINGS_TEXT' => 'Dra fält till listvy byggaren och arrangera om dem för att designa {{moduleName}} listvyn.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'Minst ett fält måste läggas till i layouten.',
    'LBL_LIST_SETTINGS_EMPTY' => 'Inga tillgängliga fält',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'Inga matchande fält hittades',
    'LBL_LIST_FILTER' => 'Fältsökning',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'Mailklient',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'Extern emailklient',
    'LBL_SUGAR_MOBILE_CLIENT' => 'E-postklient för Sugar',
    'LBL_OFFLINE_CAPABILITIES' => 'Aktivera offlineförmågor',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'Raderandet av transaktionen misslyckades.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'Transaktionen raderades.',
    'LBL_SECURE_MODE' => 'Förbättrat säkerhetsläge',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'Aktivera denna inställning för att gömma innehållet av Sugar Mobile när appen är i bakgrunden och för att förhindra att skärmdumpar av appen kan tas.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'Aktivera denna inställning för att gömma innehållet för Sugar Mobile när appen är i bakgrunden.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'Alltid offlineläge',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'Du jobbar i Alltid offlineläge. Vill du koppla upp dig igen?',
    'LBL_RECONNECT' => 'Återkoppla',
    'LBL_STAY_OFFLINE' => 'Stanna offline',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'Modulen du försöker få tillgång till är inte tillgänglig på Sugar Mobile.',
    'LBL_MOBILE_RELEASE_NOTE' => 'Sugar Mobile för {{platform}} Release notes',
    'LBL_MOBILE_USER_GUIDE' => 'Sugar Mobile för {{platform}} Användarguide',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'innehåller de här orden',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'innehåller inte de här orden',
    'LBL_NOTIFICATIONS_CHANNEL' => 'Uppdateringar',
    'LBL_APPLY_BUTTON_LABEL' => 'Tillämpa',
    'LBL_ACTION_CREATE_FAILURE' => "Det gick inte att spara posten: {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "Det gick inte att uppdatera posten: {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'Misslyckades att läsa fältberäkningar på servern.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'Följande fält är ogiltiga: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>Succé.</b> Du skapade {{{module}}}<a href="#{{{recordUrl}}}">"{{{recordName}}}".</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>Succé.</b> Du uppdaterade posten',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'Misslyckades att ta emot mejldata från servern.',
    'LBL_ASSIGN_SUCCESS' => '<b>Succé.</b> Posten har blivit tilldelad till {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'Spara detta mejl som ett utkast?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'Spara som utkast',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'Ta bort mejl',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'Om du inte sparar ditt utkast kommer du förlora detta mejl.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'Välj signatur',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'Välj mejlmall',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'Mallen kommer skriva över allt innehåll i detta mejl. Är du säker på att du vill använda denna mall och skriva över innehållet?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'Skriv email',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'Ditt mejl innehåller variabler som kommer ersättas med värden från den Relaterade till posten. Bekräfta att det Relaterade till fältet är korrekt inställt innan du skickar.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'Ingen utgående mejlkonto hittats. Kontakta din Sugar administratör.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' och {{{count}}} till',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'Lägg till en mejl',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'Skriv in ett kontaktnamn eller en mejladress',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (nytt mejl)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'Variabler',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'Emailmallar',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'Kampanjmallar',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'Arbetsflödesmallar',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'Systemmallar',
    'LBL_FILTER_EDIT' => 'Redigera filter',
    'LBL_FILTER_MY_FILTER' => 'Mina filter',
    'LBL_FILTER_MY_FILTER_BY' => 'Mina filter av {{{filters}}}',
    'LBL_FILTER_SAVE' => 'Spara filter',
    'LBL_SELECT_PARAM' => 'Välj',
    'LBL_SELECT_MODULES' => 'Modul väljare',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'Välj ytterligare parametrar',
    'LBL_FILTER_TEMPORARY' => 'Temporärt filter',
    'LBL_ERROR_FILE_UPLOAD' => 'Det gick inte att ladda upp {{{fieldLabel}}}-filen "{{{fileName}}}". {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">Se misslyckad post</a>',
    'LBL_FILE_UPLOAD_ONE' => 'Sparar fil...',
    'LBL_FILE_UPLOAD_MANY' => 'Sparar fil {{{index}}} a {{{total}}}...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'Notifikationsinställningar',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'Hantera dina pushnotifikationer',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "Kontrollera hur notifikationer kommer upp med hjälp av din enhets notifikationsinställningar.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'Uppgifter',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'Få en notifikation när uppgifter tilldelas till dig.',
    'LBL_NOTIFICATION_MENTIONS' => 'Benämningar',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'Få notifikationer när du nämns i kommentarer.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'Kommentarsfältet har inte lagts till i denna layout av en administratör. Kontakta din Sugar administratör.',
    'ERR_NO_PERMISSION_TITLE' => 'Vänligen tillåt åtkomst',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} behöver tillgång till kameran så att du kan bifoga foton. Tillåt kameratillgång i systeminställningarna.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'Inställningar',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'Varaktighet',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'Tid kvar',
    'LBL_LIST_SUPPORT_EXPIRES' => 'Utgår',
    'LBL_CASCADE_RLI_EDIT' => 'Uppdatera öppna intäktsposter',
    'LBL_MOBILE_CALENDAR' => 'Kalender',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'Kalenderinställningar',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'Dag som startar veckan',
    'LBL_MOBILE_CALENDAR_MODULES' => 'Händelser att visa',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}t:{{{minutes}}}min',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} Tim',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} Min',
    'LBL_MOBILE_CALENDAR_TODAY' => 'Idag',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => 'Lägg till {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'Schemalägg en aktivitet',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'Aktivera minst en aktivitetstyp.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'Hela dagen',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'Laddningen av kalendern misslyckades.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'Denna aktion är inte tillgänglig i Sugar Mobile. Vill du öppna desktopapplikationen istället?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'Välj mall',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'Slå ihop',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'Fel: EXIF-data saknas i HEIC-fil',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'Fel: Bildupplösning är för hög',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'Fel: Kan inte behandla bilden',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'Fel: Misslyckades att omvandla bilden till duk',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'Fel: Misslyckades att ladda filen som en bild',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1 artikel vald',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} artiklar valda',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'Välj alla',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'Du har valt {{{count}}} poster i denna vy. Välj alla poster?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'Välj {{{count}}} poster',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'Är du säker på att du vill radera de valda posterna?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'Raderar…{{{count}}} av {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'Ingen giltig mejladress funnen i de valda posterna',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'Utseende',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'Använd systeminställning',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'Ljus',
    'LBL_MOBILE_APP_THEME_DARK' => 'Mörk',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'Nytt filnamn',
    'LBL_ATTACHMENT_RENAME_MSG' => 'Byt namn på fil',
    // Filters related
    'LBL_CREATED_BY_ME' => 'Skapad av mig',
    'LBL_OPERATOR_ONE_OF' => 'är en av',
    'LBL_OPERATOR_NOT_ONE_OF' => 'är inte en av',
    'LBL_OPERATOR_CONTAINS' => 'är en av',
    'LBL_OPERATOR_CONTAINS_WORD' => 'innehåller',
    'LBL_OPERATOR_NOT_CONTAINS' => 'är inte en av',
    'LBL_OPERATOR_EMPTY' => 'är tom',
    'LBL_OPERATOR_NOT_EMPTY' => 'är inte tom',
    'LBL_OPERATOR_MATCHES' => 'matchar exakt',
    'LBL_OPERATOR_STARTS_WITH' => 'börjar med',
    'LBL_OPERATOR_EQUALS' => 'är lika med',
    'LBL_OPERATOR_NOT_EQUALS' => 'är inte lika med',
    'LBL_OPERATOR_GREATER_THAN' => 'är större än',
    'LBL_OPERATOR_LESS_THAN' => 'är mindre än',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'är större än eller lika med',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'är mindre än eller lika med',
    'LBL_OPERATOR_BETWEEN' => 'är mellan',
    'LBL_OPERATOR_BEFORE' => 'före',
    'LBL_OPERATOR_AFTER' => 'efter',
    'LBL_OPERATOR_YESTERDAY' => 'igår',
    'LBL_OPERATOR_TODAY' => 'idag',
    'LBL_OPERATOR_TOMORROW' => 'imorgon',
    'LBL_OPERATOR_LAST_7_DAYS' => 'senaste 7 dagarna',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'närmaste 7 dagarna',
    'LBL_OPERATOR_LAST_30_DAYS' => 'senaste 30 dagarna',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'närmaste 30 dagarna',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'Över __ dagar sedan',
    'LBL_OPERATOR_LAST_X_DAYS' => 'Senaste __ dagarna',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'Kommande __ dagarna',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'Om fler än __ dagar',
    'LBL_OPERATOR_LAST_MONTH' => 'senaste månaden',
    'LBL_OPERATOR_THIS_MONTH' => 'denna månad',
    'LBL_OPERATOR_NEXT_MONTH' => 'nästa månad',
    'LBL_OPERATOR_LAST_YEAR' => 'senaste året',
    'LBL_OPERATOR_THIS_YEAR' => 'detta år',
    'LBL_OPERATOR_NEXT_YEAR' => 'nästa år',
    'LBL_OPERATOR_IS' => 'är',
    'LBL_OPERATOR_IS_NOT' => 'är inte',
    'LBL_OPERATOR_AFTER_TODAY' => 'efter idag',
    'LBL_OPERATOR_BEFORE_TODAY' => 'före idag',
    'LBL_ERROR_FILTER_EMPTY' => 'Lägg till filterkriterier.',
    'LBL_ADD_FILTER' => 'Lägg till kriterier',
    'LBL_FILTER_NAME' => 'Filternamn',
    'LBL_FILTER_FIELD' => 'Fält',
    'LBL_FILTER_OPERATOR' => 'Operator',
    'LBL_FILTER_VALUE' => 'Värde',
    'LBL_FILTER_SYNC_TO_SERVER' => 'Spara till skrivbordsapp',
    'LBL_FILTER_LOCAL' => 'Lokalt filter',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'Välkommen till{{{brandName}}}.<br/><br/> Låt oss lyfta fram en del nya funktioner...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'Huvudmeny navigation.',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'Tillgängliga åtgärder per vy.',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'Global sökning efter poster.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'Filtrera listan för att visa mina favorit poster.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'Filtrera listan för att visa poster som tilldelats mig.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'Markera posten som favorit.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'Mina kommande evenemang med start i dag.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'Senaste modifierade poster.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'Tillgängliga åtgärder på en post.',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'Njut av alla nya funktioner!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'Detta är ett plus-menyn.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'Stäng plus menyn.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'Välj den särskilda åtgärder för att se för att utföra.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'Detta är hemmenyn.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'Stäng hemmenyn.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'Visa en särskild modul.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'Anpassa programmet.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'Öppna Sugar i webbläsaren.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'Visa din profil.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'Detta är detaljsidan.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'Den viktigaste informationen om en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'Se ytterligare information eller redigera en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'Tillgängliga åtgärder på en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'Gå till föregående sida.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'Ta en rundtur när som helst.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'Gå tillbaka.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'Klicka för att öppna en relaterad post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'Follow/Unfollow en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'Klicka för att expandera detaljerad information.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'Huvudmenyvy',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'Huvudmenyn öppnas på vänster sida av skärmen.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'Detaljerad vy',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'Den detaljerade vyn öppnas på höger sida av skärmen.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'Använd pilarna längst ner för en snabbtur av nyckelkomponenterna för den här menyn.',

    'LBL_COMMENT_ADD' => 'Lägg till en kommentar',
    'LBL_REQUIRED' => 'Obligatorisk',
    'LBL_MORE_BUTTON' => 'Mer',
    'LBL_NO_OPTIONS' => 'Inga alternativ tillgängliga',
    'LBL_TRY_AGAIN' => 'Försök igen',
    'LBL_NEW_RECORDS' => 'Nyligen skapad',
    'LBL_ASSIGNED_TO_ME' => 'Min {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'Alla {{{module}}}',
    'LBL_UNFAVORITE' => 'Ta bort från favoriter',
    'LBL_ACTIVITY_CREATE' => 'Skapade {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => 'Updaterade {{{changes}}} på {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => 'Länkad {{{relatedRecord}}} till {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => 'Inte länkad {{{relatedRecord}}} från {{{record}}} {{{module}}}',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} för {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'Ladda ner relaterade poster...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'Konfigurationen för din översikt har ändrats. Vill du ladda upp den på nytt?',
    'LBL_RECORDS' => 'Poster',
    'LBL_DASHBOARDS' => 'Översikter',
    'LBL_TEMPLATES' => 'Mallar',
    'LBL_NON_TEMPLATES' => 'Icke mallar',
    'LBL_IS_TEMPLATE' => 'Är mall',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'Ditt val innehåller kontrollpanel-mallar, som inte går att massuppdatera. Avmarkera mallar för att fortsätta.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'Ditt val innehåller kontrollpanel-mallar, som inte går att massradera. Avmarkera mallar för att fortsätta.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'Sök {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'Huvudmeny',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'Skapa snabbt en ny post',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'Svep för fler alternativ',
    'LBL_DETAILS' => 'Detaljer',
    'LBL_DETAIL_RELATED' => 'Relaterade',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'Den här {{module}} kräver en {{relatedModule}}. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>Skapa en {{relatedModule}} post</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'Redigera posten',
    'LBL_OFFLINE_MENU_SETTINGS' => 'Offline inställningar',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'Inställningar för avsökning',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'Totalt antal poster',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'Senaste nedladdningen',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'Misslyckades att ladda ner filen.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'Misslyckades att ladda upp översikterna från servern',
    'ERR_FILTERS_FETCHING' => 'Misslyckades att hämta dina filter',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'Misslyckades att kryptera lokal lagring',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'Krypterar data offline. Detta kan ta flera minuter.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'Kryptering av data offline har slutförts.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'Du har inte åtkomst till {{{module}}} modul.',
    'LBL_SKIP' => 'Hoppa över',
    'LBL_CONTINUE' => 'Fortsätt',
    'LBL_ENABLE' => 'Aktivera',
    'LBL_MOBILE_TRIAL_UNTIL' => 'Utvärderingsperiod fram tills',
    'LBL_MOBILE_SDK_VERSION' => 'SDK Version',
    'LBL_LOG_LEVEL' => 'Loggnivå',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'Inställningarna för inloggning har konfigurerats på nytt.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'Din utvärderingsperiod har förfallit.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'Servern stöder inte säker anslutning. Inaktivera säker anslutning.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'Servern stöder säker anslutning. Aktivera säker anslutning.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'Din anslutning är inte säker. Kontakta din administratör.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'Inställningar för inloggning',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'Ställ in din {{{brandName}}} instans',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'Du måste skriva in URL: en för {{{brandName}}} instansen, för att appen ska fungera. Kontakta din administratör om du inte har instansens URL.',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => 'Touch ID',
    'LBL_ENABLE_TOUCHID' => 'Enable {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => 'Setup {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'Logga in genom att använda ditt finger',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} is not set up on your device. \n\nGo to your device settings to set up {{{biometryType}}}. Once set up, enable {{{biometryType}}} for {{{brandName}}} in Main Menu > Settings.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'Using {{{biometryType}}} with {{{brandName}}} will allow you to use your biometric identifier instead of entering your password to access {{{brandName}}}.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'Would you like to proceed with {{{biometryType}}}?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'Enter {{{brandName}}} Password to Enable {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'Installera',
    'LBL_MDM_CONFIRM_CHANGE' => 'Applikationens konfiguration har ändrats av mobilenhetens ägare. Vänligen logga in på nytt för att tillämpa ändringarna.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'Vänligen ge {{{brandName}}} tillgång till din plats via enhetens inställningar.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'Aktuell plats är inte tillgänglig',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "Current location retrieval timed out. \nPlease try again.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'Platsens platsmärken är inte tillgängliga',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'Platsens koordinater är ogiltiga',
    'ERR_MOBILE_INVALID_PASSWORD' => 'Ogiltigt lösenord.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'Din app är föråldrad och är inte längre kompatibel med {{{brandName}}} instansen som du ansluter till. Vill du uppdatera den?',
    'LBL_MOBILE_BY' => 'Av',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'Det här filtret är inte tillgängligt offline',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'Offline poster',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'Ladda ner inställningar',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'Ladda ner din tilldelade, favorit och följ poster för offline åtkomst. Du kan uppdatera dina preferenser i inställningarna för offline.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'Your records have finished downloading. You can now access them in offline mode.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "Not all your records were downloaded.\n Do you want to try again?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'Använd mobildata',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'Inte just nu',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'Nedladdningen är pausad och kommer att återupptas när du öppnar appen på nytt.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'Laddar ner {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'Uppdatera de senaste posterna',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'Väntar på anslutning',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'Pausad',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'Stoppad',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'Ladda ner',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'Pausa',
    'LBL_BULK_LOAD_BTN_RESUME' => 'Återuppta',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'Endast Wifi-anslutning används som standard',
    'LBL_NPS_RATING_MSG' => "How would you rate your \n{{{productName}}} experience?",
    'LBL_NPS_THANKS_MSG' => 'Tack för din återkoppling!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'Skulle du kunna tänka dig att betygssätta den på App Store?',
    'LBL_NPS_NO_THANKS' => 'Nej, tack',
    'LBL_NPS_NOT_NOW' => 'Inte nu',
    'LBL_NPS_RATE_NOW' => 'Betygsätt nu',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'Nätverket är inte tillgängligt. Du kan fortfarande använda appen när du är offline',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'Dina ändringar kommer att synkroniseras när du är online. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>Se detaljer</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'Det finns data som inte har synkroniserats. Kontrollera <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>transaktionsloggen</a>',
    'LBL_CONVERT' => 'Konvertera',
    'LBL_CONVERT_LEAD' => 'Konvertera Lead',
    'LBL_SEARCH_EXISTING_RECORD' => 'Sök befintlig {{{this}}}',
    'LBL_DUPLICATES_CHECK_FAILED' => 'Kontroll av dubbletter misslyckades',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'Vill du flytta relaterade aktiviteter till kontaktposten?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'Du lyckades att konvertera lead {{{name}}}',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'Inga dubbletter hittades.',
    'ERR_LEAD_CONVERSION_FAIL' => 'Lead-konvertering misslyckades',
    'LBL_SELECT_DUPLICATE_RECORD' => 'Välj från dubblett {{{modulePlural}}}',
    'LBL_SELECTED_EXISTING_RECORD' => 'Vald {{{moduleSingular}}}',
    'LBL_CREATED_NEW_RECORD' => 'Skapade ny {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => 'Tillbaka knapp',
    'LBL_VO_HOME_BTN' => 'Hem knapp',
    'LBL_VO_DASHBOARD_BTN' => 'Översiktsknapp',
    'LBL_VO_SEARCH_BTN' => 'Sök knapp',
    'LBL_VO_RIGHT_MENU_BTN' => 'Höger menyknapp',
    'LBL_VO_ADD_BTN' => 'Lägg till knapp',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'Rabatt',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'Välj en mappningsapp',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'De utvalda {{entityName}} har relaterade värden: {{localizedFieldNames}}. Avbryt för att behålla befintliga värden. Bekräfta för att skriva över med nya värden.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'Datakryptering är aktiverad.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'Vald affärsmöjlighet har redan konverterats.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'Den här åtgärden är endast tillgänglig när enheten är online',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'Är du säker på att du vill skapa en affärsmöjlighet från offerten?',
    'LBL_TAG_ADD' => 'Lägg till tagg',
    'LBL_TAG_ENTER_TAG_NAME' => 'Ange tagg',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'Filtrering efter taggar stöds inte när enheten är offline.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'Visa hela kommentaren',
    'LBL_COMMENT_VIEW' => 'Visa en kommentar',
    'LBL_PMSE_LABEL_DUEDATE' => 'Förfallodatum',
    'LBL_PMSE_DUE' => 'Förfaller',
    'LBL_PMSE_DUE_ON' => 'Förfaller den',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'Skapa {{conversionParentModuleName}} först',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'Saknar krävda poster: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'Välj bildkvalitet. Bilden ändras i enlighet med detta innan den sparas på servern. Det valda värdet kommer att användas som standard för alla liknande operationer i framtiden.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'Uppskattar filstorlek...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'Den uppskattade filstorleken är',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'Bildkvalitet',
    'LBL_IMAGE_QUALITY_BEST' => 'Originalstorlek',
    'LBL_IMAGE_QUALITY_GOOD' => 'God kvalitet',
    'LBL_IMAGE_QUALITY_POOR' => 'Liten storlek',
    'LBL_IMAGE_QUALITY_BTN' => 'Kompression: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'Lista fält på {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'Återställ till standard',
    'LBL_LIST_NOT_ENOUGH' => 'Välj minst 1 aktivt fält.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'Du måste logga in och acceptera behörigheter för att kunna arbeta med SugarCRM-instans.',
    'LBL_SELECTING_EXISTING_RECORD' => 'Väljer {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'Skapar ny {{{moduleSingular}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'Bildstorlek',
    'LBL_COPY_ADDRESS' => 'Kopiera adress',
    'LBL_OPEN_IN' => 'Öppna i',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'Ingen fil vald.',
    'LBL_ATTACHMENT_ADD' => 'Bifoga',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'Denna app använder cookies',
    'LBL_USE_COOKIES_CONFIRM' => 'Denna applikation använder cookies för att hjälpa dig få en bättre upplevelse. Genom att fortsätta ger du samtycke till användandet av cookies i enlighet med vår sekretesspolicy.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'Du använder en Sugar-instans som inte är kompatibel med Sugar Mobile i en kommande mobilversion. Be din administratör att uppgradera Sugar så snart som möjligt.',
    'ERROR_TAG_NAME_INVALID' => 'Taggnamn kan inte innehålla "{{{forbiddenChars}}}" tecken',
    'ERROR_NO_TAGS_FOUND' => 'Inga befintliga taggar matchar "{{{searchQuery}}}"',
    'ERR_PA_RECORD_INVALID' => 'Posten {{{moduleName}}} har ett eller flera ogiltiga värden och kan inte sparas. Vill du redigera posten för att utföra åtgärden {{{actionLabel}}}?',
    'ERR_MOBILE_METADATA_RELOAD' => 'En administratör har gjort konfigurationsändringar i din Sugar-instans. Tryck på OK för att synkronisera appens konfiguration med servern.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'Denna applikation använder kakor',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'Kryssa i för att acceptera (obligatoriskt)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'Denna applikation använder kakor för att hjälpa dig få en bättre upplevelse. Genom att fortsätta ger du samtycke till användandet av kakor i enlighet med vår <a href="{{href}}" target="_blank">sekretesspolicy</a>.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'Post vyn tillåter dig att se detaljer om en post.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Anteckningar låter dig samarbeta med andra portalanvändare och support representanter.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'Klicka här för att lägga till en kommentar till denna post.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'Klicka på ikonerna för att visa information om bifogade anteckningar.',

    //for portal
    'LBL_PORTAL_HOME' => 'Startinstrumentpanel',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'Alla öppna ärenden',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'Nyligen lösta ärenden',
    'LBL_PORTAL_SEARCH' => 'Sök på namn, nummer',
    'LBL_SIGNUP_BUTTON_LABEL' => 'Registrera Dig',
    'LBL_PORTAL_NO_EMAIL' => 'Fick du ingen e-post?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'Glömt lösenord',
    'LBL_PORTAL_FORGOT_USERNAME' => 'Glömt användarnamn',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'Ange ditt lösenord två gånger. Lösenorden måste matcha.',
    'LBL_PORTAL_RESET_PASSWORD' => 'Återställ lösenord',
    'LBL_PORTAL_REENTER_PASSWORD' => 'Ange lösenord igen',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'Lösenorden matchar inte, var god ange igen',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'Ditt lösenord har återställts.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'Ett fel inträffade. Var god initiera en ny begäran om återställning av lösenord.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'Registrerar',
    'LBL_PORTAL_SIGNUP_TITLE' => 'Tack för att du registrerade dig',
    'LBL_PORTAL_SIGNUP' => 'Vi kommer att informera dig efter vi har bekräftat din information.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'Förnamn',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'Efternamn',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'Användarnamn',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'E-postadress',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (valfri)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'Land',
    'LBL_PORTAL_SIGNUP_STATE' => 'Region',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'Företagsnamn',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'Jobbtitel (frivilligt)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'Lösenord',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'Bekräfta lösenord',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'Glömt inloggning',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'Glöm lösenord?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'Kontakta din Sugar Admin för att återställa ditt lösenord.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'Användarnamn',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'Lösenord',
    'LBL_PORTAL_LOADING' => 'Laddar',
    'LBL_PORTAL_SAVING' => 'Sparar',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'Sidan är inte tillgänglig',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "Tyvärr, den här funktionen är inte tillgänglig just nu.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'Visa sökresultat för "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'Fick du ingen e-post?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'För assistans, eller för att kontakta oss, var god använd något av följande: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'Telefon: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'E-post: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'Webb: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'Är du säker på att du vill stänga chatten?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'Skapa anteckning eller bifoga bilaga',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'Lägg till en anteckning',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'Din inloggning lyckades inte. Var god och försök igen.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'Fel Inloggningsuppgifter',
    'LBL_PORTAL_INVALID_GRANT' => 'Din session har gått ut. Logga in igen.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'Sessionen har gått ut',
    'LBL_PORTAL_AUTH_FAILED' => 'Klient autentiseringen misslyckades',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'Felaktig Klient',
    'LBL_PORTAL_INVALID_REQUEST' => 'Begäran som gjordes är ogiltig eller felutformad. Vänligen kontakta teknisk support.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'Ogiltig Begäran',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'Begäran avbröts pga time out',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'Begäran timeout',
    'LBL_PORTAL_UNAUTHORIZED' => 'Tyvärr, det verkar som om du inte har behörighet att få tillgång till den här resursen.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'HTTP Fel: Obehörig',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'Resursen är inte tillgänglig.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'HTTP Error: Förbjuden',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'HTTP metoden är inte tillåten för den här resursen. Vänligen kontakta teknisk support.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP Fel: Metod Inte Tillåten',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'Begäran misslyckades, eller, saknade/ogiltig parameter. Vänligen kontakta teknisk support.',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'HTTP Fel:',
    'LBL_PORTAL_MIN_MODULES' => 'Som minst, måste du har Cases, Bugs eller Knowledge Base modul aktiverad för att använda den här applikationen.',
    'LBL_PORTAL_ERROR' => 'Fel',
    'LBL_PORTAL_ROUTE_ERROR' => 'Problem med laddning av modul. Försök igen senare eller kontakta support.',
    'LBL_PORTAL_OFFLINE' => 'Tyvärr är applikationen inte tillgänglig just nu. Vänligen kontakta site administratören.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'Ändra lösenord',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'Användarnamnet är redan registrerat i systemet. Begär antingen ett glömt lösenord eller välj ett annat användarnamn.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'Den uppgivna e-postadressen är ogiltig.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'Lösenorden stämmer ej överens.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'Servicekonsol',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'Översikt',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'Återställ standardpanelen',
    'LBL_UNTITLED' => 'Saknar titel',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'Konsol för förnyelse',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'Översikt',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'Stadium / status',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'Namn / kontonamn',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'Omnichannel Dashboard',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'Kund',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} vid {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'Din webbläsare har inte stöd för SugarLive. Vänligen använd Google Chrome eller Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'En <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> har skapats som innehåller information om din konversation.',
    'LBL_OMNICHANNEL_SUBJECT' => 'Ämne',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'Beskrivning',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'Sammanfattning av meddelande',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'Sammanfattning av samtal',
    'LBL_OMNICHANNEL_LINK_TO' => 'Länk {{fromModule}} till {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'Länk till {{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'Länkad',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'Din webbläsare har inte stöd för chatt. Vänligen använd Google Chrome eller Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Vänligen kontakta din Sugaradministratör för att få hjälp.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'Konfigurera layout',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'Slutför konfigureringen av SugarLive innan du ringer ett utgående samtal.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'Slutför konfigurationen av SugarLive-layouten innan du öppnar SugarLive.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'Ställ dig själv på "Offline" i SugarLive innan du konfigurerar SugarLive-layouten.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'Kompakt vy',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'Full vy',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR Dashboard',
    'LBL_SALES_MANAGER_CONSOLE' => 'Kontrollpanel för försäljningschef',
    'LBL_SALES_REP_CONSOLE' => 'Kontrollpanel för försäljningsrepresentant',
    'LBL_MARKETING_CONSOLE' => 'Kontrollpanel för marknadsföring',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'Kontrollpanel för kundframgång',
    'LBL_EXECUTIVE_CONSOLE' => 'Kontrollpanel för chefer',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'Återställ tab till standard',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'Konfigurera sammanfattningspanelen',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'Användarinformation',
    'LBL_WIZ_COMPLETE_TITLE' => 'Installationen är klar',
    'LBL_SETUP_COMPLETE_INFO' => 'Börja använda Sugar!',
    'LBL_SETUP_USER_INFO' => 'Ställ in din användarinformation',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'Datum-, tid- och namninställningar',
    'LBL_SETUP_USER_LOCALE_INFO' => 'Välj tidszon, datum och namnformat',
    'LBL_WIZ_START_SUGAR' => 'Starta Sugar',
    'LBL_WIZ_FIRST_NAME' => 'Förnamn',
    'LBL_WIZ_LAST_NAME' => 'Efternamn',
    'LBL_WIZ_EMAIL' => 'Email',
    'LBL_WIZ_TIMEZONE' => 'Tidszon',
    'LBL_WIZ_TIMEFORMAT' => 'Tidsformat',
    'LBL_WIZ_DATE_FORMAT' => 'Datumformat',
    'LBL_WIZ_NAME_FORMAT' => 'Namnformat',
    'LBL_SETUP_PROGRESS' => 'Inställningsförlopp',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugarutbildning',
    'LBL_WIZ_DOCUMENTATION' => 'Dokumentation',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'Kunskapsbas',
    'LBL_WIZ_FORUMS' => 'Forum',
    'TPL_TIMEZONE_DIFFERENT' => 'Din webbläsares tidszon matchar inte din sparade tidszon. {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'Justera din tidszon.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'Lokala inställningar',
    'LBL_WIZ_EMAIL_SETTINGS' => 'Emailinställningar',
    'LBL_WIZ_IMPORT_DATA' => 'Importera Data',
    'LBL_WIZ_CREATE_USERS' => 'Skapa Användare',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'Systeminställningar',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Studio',

    'LBL_CSP_ERROR_MESSAGE' => 'Värdena som du har angett stöds inte eller uppfyller inte det acceptabla formatet. För en lista över acceptabla fältvärden och format, se <a href="{{linkToDocumentation}}" target="_blank">Systemdokumentationen</a>.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'Detta innehåll har inte godkänts. Uppdatera systemets <a href="{{linkToDocumentation}}" target="_blank">Inställningar för innehållssäkerhetspolicy</a>.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'Detta innehåll har inte godkänts. Be din administratör att uppdatera systemets <a href="{{linkToDocumentation}}" target="_blank">Inställningar för innehållssäkerhetspolicy</a>. När inställningarna har uppdaterats måste du uppdatera din webbläsare för att ändringarna ska träda i kraft.',

    // For password related labels
    'LBL_PASSWORD' => 'Lösenord',
    'LBL_CHANGE_YOUR_PASSWORD' => 'Ändra ditt lösenord',
    'LBL_PASSWORD_REQUIREMENTS' => 'Lösenordskrav',
    'LBL_CURRENT_PASSWORD' => 'Nuvarande lösenord',
    'LBL_NEW_PASSWORD1' => 'Nytt lösenord',
    'LBL_NEW_PASSWORD2' => 'Bekräfta lösenord',
    'LBL_PASSWORD_CHANGED' => 'Du har ändrat ditt lösenord',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'Var god fyll i din lösenords verifiering.',
    'ERR_ENTER_NEW_PASSWORD' => 'Var god fyll i ditt nya lösenord.',
    'ERR_ENTER_OLD_PASSWORD' => 'Var god att ange ditt nuvarande lösenord.',
    'ERR_REENTER_PASSWORDS' => 'Lösenorden måste matcha.',
    'ERR_PASSWORD_MISMATCH' => 'Lösenordet stämmer inte överens med lösenordet i vårt system.',
    'LBL_CANNOT_SEND_PASSWORD' => 'Kan inte skicka lösenord',
    'LBL_REQUEST_PASSWORD' => 'Begär lösenord',
    'LBL_RESET_PASSWORD' => 'Återställ lösenord',
    'LBL_RESET_PASSWORD_MESSAGE' => 'Ange ditt användarnamn så skickar vi en länk för att återställa ditt lösenord.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Kontrollera din e-post <br><br> Vi har skickat instruktioner för återställande av lösenordet till e-postadressen vi har registrerat.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'Fel: Det gick inte att uppdatera lösenordet för denna användare.',
    'LBL_INCORRECT_PASSWORD' => 'Fel: Felaktigt lösenord.',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'Lösenordet du angav uppfyller inte lösenordskriterierna. Försök igen.',
    'LBL_PASSWORD_MIN_LENGTH' => 'Minimal längd är {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'Maximal längd är {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'Måste innehålla en stor bokstav (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'Måste innehålla en liten bokstav (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'Måste innehålla en siffra (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'Måste innehålla ett specialtecken (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'Lösenordet får inte matcha mönstret för det reguljära uttrycket: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'Språkinställning:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'Kunde inte skicka e-post för återställning av lösenord.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'Välj en rapport',
    'LBL_REPORT_AUTO_REFRESH' => 'Uppdatera automatiskt',
    'LBL_REPORT_EDIT' => 'Redigera vald rapport',
    'LBL_REFRESH_LIST_AND_CHART' => 'Uppdatera lista och diagram',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'Inget diagram tillgängligt.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'Denna rapport innehåller inga filter.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'Du har endast gömt körtidsfilter, se avancerade filter.',
    'LBL_RUNTIME_FILTERS' => 'Filter för körningstid',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'Datumet matchar inte användarens önskade datumformat: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'Denna dashlet har inga filter för körningstid',
    'LBL_DASHBOARD_FILTER_GROUP' => 'Nytt filter',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'Du måste välja minst ett värde.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'Återställ till standardfilter',
    'LBL_COPY_FILTER_SUMMARY' => 'Kopiera filtersummering',
    'LBL_APPLY_FILTERS' => 'Tillämpa',
    'LBL_REPORTS_FILTERS' => 'Filter',
    'LBL_RUNTIME_FILTERS_INVALID' => 'Körtidsfilter kan inte appliceras på grund av ogiltiga värden',
    'LBL_RUNTIME_FILTERS_COPIED' => 'Filtersummeringen har kopierats till dina urklipp.',
    'LBL_ADVANCED_FILTERS' => 'Avancerade filter',
    'LBL_ADVANCED_OR_DESC' => 'Inkludera när NÅGOT villkor är uppfyllt',
    'LBL_ADVANCED_AND_DESC' => 'Inkludera när ALLA villkor är uppfyllda',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'Detta är ett originaldesignat filter',
    'LBL_AND_UPPERCASE' => 'OCH',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'Denna funktion är inte tillgänglig i Förhandsgranskningsläge',
    'LBL_REPORT_DEFAULT_NAME' => 'Ej namngiven rapport',
    'LBL_REPORT_QUERY' => 'Förfrågan',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'Relaterad till aktuell post',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'Länkat fält',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'Länkat fält kan inte vara tomt',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'Ingen rapport vald.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'Linjediagram är inte kompatibelt med denna rapport',
    'LBL_REPORT_DASHLET' => 'Rapportera Dashlet',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'Datatabell',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'Filter för körningstid',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'Förhandsgranskning av datatabell',
    'LBL_REPORTS_DASHLET_CHART' => 'Diagram',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'Förhandsgranskning av diagram',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'Förhandsgranskning av filter',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'Den valda rapporten stöder inte ett diagram.',
    'LBL_REPORTS_DASHLET_LABELS' => 'Etiketter',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'Visa totalt antal poster',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'Sorteringsordning',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'Standardvald vy',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'Primär diagramsorteringsordning',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'Sekundär diagramsorteringsordning',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'Ingen {{module}} länkar till vald rapport',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'Ej tillgänglig för denna rapporttyp',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'Den här funktionen är endast tillgänglig på diagramfliken',
    'LBL_REPORTS_CHART_TYPE' => 'Diagramtyp',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'Värdesetikettplacering i stapeldiagram',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'Visa total',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'Visa legend',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Visa etikett för x-axel',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Visa etikett för y-axel',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Gräns för visade rader',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'Du har inte behörighet att använda dessa körningsfilter.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'Okänd',
    'ERR_HTTP_DEFAULT_TITLE' => 'Okänt Fel',
    'ERR_HTTP_DEFAULT_TEXT' => 'Okänt fel.',
    'ERR_HTTP_DEFAULT_ACTION' => 'Gå tillbaka till föregående sida.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'Fel: Ogiltig begäran',
    'ERR_HTTP_400_TEXT_LINE1' => 'Din webbläsare skickade en begäran som servern inte kunde förstå.',
    'ERR_HTTP_400_TEXT_LINE2' => 'Vänligen kontakta din Sugaradministratör för ytterligare detaljer.',
    'ERR_HTTP_400_ACTION' => 'Gå tillbaka till föregående sida.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'HTTP: 404 Not Found',
    'ERR_HTTP_404_TEXT_LINE1' => 'Sidan finns inte eller du har inte behörighet att komma till denna sida.',
    'ERR_HTTP_404_TEXT_LINE2' => 'Försök igen. Om felet kvarstår, kontakta Sugar-administratören.',
    'ERR_HTTP_404_ACTION' => 'Gå tillbaka till föregående sida.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 Internt serverfel',
    'ERR_HTTP_500_TEXT_LINE1' => 'Servern påträffade ett fel och kunde inte slutföra din begäran.',
    'ERR_HTTP_500_TEXT_LINE2' => 'Försök igen. Om felet kvarstår, kontakta Sugar-administratören.',
    'ERR_HTTP_500_ACTION' => 'Vänligen kontakta teknisk support.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 Internt serverfel',
    'ERR_HTTP_502_TEXT_LINE1' => 'Servern påträffade ett fel och kunde inte slutföra din begäran.',
    'ERR_HTTP_502_TEXT_LINE2' => 'Försök igen. Om felet kvarstår, kontakta administratören Sugar.',
    'ERR_HTTP_502_ACTION' => 'Kontakta teknisk support.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 Internt serverfel',
    'ERR_HTTP_503_TEXT_LINE1' => 'Servern är inte tillgänglig för att slutföra din begäran.',
    'ERR_HTTP_503_TEXT_LINE2' => 'Försök igen. Om felet kvarstår, kontakta Sugar-administratören.',
    'ERR_HTTP_503_ACTION' => 'Kontakta teknisk support.',

    'ERR_RENDER_FAILED_TITLE' => 'Renderingsvisning Misslyckande',
    'ERR_RENDER_FAILED_MSG' => 'Misslyckades att rendera visning',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'Fältrendering misslyckades',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'Kunde inte rendera {0} fältet.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'Åtkomst Nekad',
    'ERR_NO_VIEW_ACCESS_REASON' => 'Du har inte behörighet till den här sidan.',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'Kontakta administratören för att begära tillgång.',
    'ERR_NO_VIEW_ACCESS_MSG' => 'Kontakta din Support Administratör för att få tillgång till visningen för {0} modulen.',

    'ERR_LAYOUT_RENDER_TITLE' => 'Layout rendering misslyckades',
    'ERR_LAYOUT_RENDER_MSG' => 'Oops! Vi kunde inte rendera någonting. Försök igen senare eller kontakta support',
    'ERR_INTERNAL_ERR_MSG' => 'Internt Fel',
    'ERR_GENERIC_TITLE' => 'Fel',
    'ERR_CONTACT_TECH_SUPPORT' => 'Vänligen kontakta teknisk support.',

    'LBL_SYNCED_RECURRING_MSG' => 'Du kan inte redigera det här protokollet eftersom det var synkat med en extern klient',
    'LBL_EXISTING' => 'Existerar',
    'LBL_PANEL_DEFAULT' => 'Standard',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'Dålig respons från servern',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'Fel uppstod under AssignTo.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'Du har inte tillgång till {{name}}". Kontakta din administratör.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'År {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} K{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'Fler åtgärder',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'Varna',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'Ignorera Duplicera och Spara',
    'LBL_RESTORE' => 'Återställ till original',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'Poster som markerats för radering',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'Visar poster som är relaterade till en datasekretessbegäran att '
        . 'Radera information.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS-flöde',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'Håll dig uppdaterad genom att lägga till ett externt RSS- eller blogg-flöde.',
    'LBL_RSS_FEED_URL' => 'Flödes-URL',
    'LBL_RSS_FEED_AUTHOR' => 'Författare:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'Antalet poster att visa',
    'LBL_ERR_LOADING_RSS_FEED' => 'Fel när RSS-flödet laddades',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'Mina Objekt',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'Team Objekter',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'Tillåter användare att lägga till Sugar-appar i en instrumentpanel',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'Historik',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'Historik-dashleten visar gångna möten, loggade samtal, samt mottagna och skickade email.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'Email',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'Email',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'Min historik',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'Team historik',
    'LBL_UNASSIGNED' => 'Ej tilldelad',
    'LBL_ARCHIVE_EMAIL' => 'Arkivera Email',
    'LBL_EMAIL_ARCHIVED' => 'Email arkiverat',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'Skapa arkiverad e-post',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'Planerade aktiviteter',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'Dashleten &#39;Planerade aktiviteter&#39; visar schemalagda möten och samtal.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'Idag',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'Framtiden',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'Mina aktiviteter',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'Team Aktiviteter',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'Genomförd',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'Är du säker på att du vill markera {0} som stängt?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'Aktiva uppgifter',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Dashleten &#39;Aktiva uppgifter&#39; visar aktuella, kommande och att-göra-uppgifter.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'Förfaller nu',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'Kommande',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'Att göra',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'Genomfört',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'Är du säker på att du vill stänga {0} som avslutad?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mina uppgifter',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team uppgifter',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'Det fanns ytterligare en email på den post du ändrar. Det är nu den primära och har sparats nedan.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'Inaktiva uppgifter',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Dashlet &#39;Uppgifter&#39; visar uppskjutna och avslutade uppgifter.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'Uppskjutet',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'Genomfört',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'senast ändrad {{relativetime}} på {{date}} vid {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mina uppgifter',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team uppgifter',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'Ärenden jag sett nyligen',

    'LBL_REPORT_DASHLET_TITLE_12' => 'Öppna ärenden per användare per status',
    'LBL_REPORT_DASHLET_TITLE_125' => 'Nya ärenden per affärscenter per vecka',
    'LBL_REPORT_DASHLET_TITLE_126' => 'Nyligen skapade ärenden',
    'LBL_REPORT_DASHLET_TITLE_127' => 'Nya ärenden per kundnivå per vecka',
    'LBL_REPORT_DASHLET_TITLE_128' => 'Öppna ärenden per kundnivå och prioritet',
    'LBL_REPORT_DASHLET_TITLE_129' => 'Totalt antal ärenden avgjorda denna månad per affärscenter',
    'LBL_REPORT_DASHLET_TITLE_130' => 'Totalt antal ärenden avgjorda denna månad per agent',
    'LBL_REPORT_DASHLET_TITLE_131' => 'Lista över nyligen avgjorda ärenden',
    'LBL_REPORT_DASHLET_TITLE_132' => 'Mina avgjorda ärenden denna månad per vecka',
    'LBL_REPORT_DASHLET_TITLE_133' => 'Mina ärenden som förfaller idag och redan förfallna',
    'LBL_REPORT_DASHLET_TITLE_134' => 'Alla ärenden som förfaller idag och redan förfallna',
    'LBL_REPORT_DASHLET_TITLE_135' => 'Mina öppna ärenden per uppföljningsdatum',
    'LBL_REPORT_DASHLET_TITLE_136' => 'Alla öppna ärenden per uppföljningsdatum',
    'LBL_REPORT_DASHLET_TITLE_137' => 'Mina öppna ärenden per status',
    'LBL_REPORT_DASHLET_TITLE_138' => 'Mina ärenden förra veckan per status',
    'LBL_REPORT_DASHLET_TITLE_139' => 'Status för öppna ärenden som tilldelats av mig',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP eller Old REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron-jobb',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar Arbetsflöde',
    'LBL_AUDIT_SUBJECT_USER' => 'Användare',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Webb för Lead',

    //common chart strings
    'LBL_CHART' => 'Graf',
    'LBL_CHART_NO_DATA' => 'Inga data tillgängliga.',
    'LBL_CHART_LEGEND_CLOSE' => 'Göm legend',
    'LBL_CHART_LEGEND_OPEN' => 'Visa legend',
    'LBL_CHART_CONTROLS_CLOSE' => 'Göm kontroller',
    'LBL_CHART_CONTROLS_OPEN' => 'Visa kontroller',
    'LBL_CHART_UNDEFINED' => 'Odefinierad',
    'LBL_CHART_NO_LABEL' => 'Odefinierad',
    'LBL_CHART_AMOUNT' => 'Mängd',
    'LBL_CHART_COUNT' => 'Antal',
    'LBL_CHART_PERCENT' => 'Procent',
    'LBL_CHART_GROUP' => 'Grupp',
    'LBL_CHART_DATE' => 'Datum',
    'LBL_CHART_KEY' => 'Nyckel',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'Graftyp',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'Visa titel',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'Visa total',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Visa ettikett för x-axel',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Visa ettikett för y-axel',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'Tick-visningsmetoder',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'Radbyt automatiskt ticks',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'Samla ihop ticks',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'Rotera ticks',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'Värdesetikettplacering i stapeldiagram',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'Visningsalternativ för stapeldiagram',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'Tillåt skrollning',
    'LBL_CHART_CONFIG_STACK_DATA' => 'Stackdataserier',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'Dälj tomma grupper',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'skickat',
    'LBL_EMAIL_RECV' => 'mottagna',

    //record save
    'LBL_RECORD_SAVED' => 'Post sparas.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'Du har skapat med framgång {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a>.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'Du skapat {{moduleSingularLower}}.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'Du skapat denna post, men du har inte behörighet att komma åt denna post.', // use when user has no access to the model
    'LBL_VALIDATING' => 'Verifierar ...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'Success:',
    'LBL_ALERT_TITLE_WARNING' => 'Varning:',
    'LBL_ALERT_TITLE_NOTICE' => 'Observera:',
    'LBL_ALERT_TITLE_ERROR' => 'Fel:',
    'LBL_ALERT_TITLE_LOADING' => 'Laddar',
    'LBL_ALERT_NO_ACCESS' => 'Du har inte tillgång till filtret som tillämpas på denna dashlet.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'Duplicera instrumentpanelen för att konfigurera denna dashlet med ditt eget filter.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'Din browser version stöds inte längre, eller du använder en webbläsare som inte stöds.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'Plattformar som stöds',
    'LBL_ALERT_CONFIRM_DELETE' => 'Är du säker på att du vill ta bort denna artikel?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'Är du säker på att du vill ta bort dessa artiklar?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'Den valda posten kommer att skriva över följande värden: {{values}}. Avbryt för att behålla befintliga värden. Bekräfta för att skriva över med nya värden.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'De utvalda {{moduleSingularLower}} har relaterade värden: {{values}}. Avbryt för att behålla befintliga värden. Bekräfta för att skriva över med nya värden.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'Från:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'Till:',

    //organization chart
    'LBL_ORG_CHART' => 'Organisationsschema',
    'LBL_ORG_CHART_DESC' => 'Visar medarbetare strukturen i organisationen.',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'Växla orientering',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'Visa alla noder',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'Zoom för att passa',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'Case sammandrag',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'Visar en översikt av relaterade Cases.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'Sammanfattning',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'Avslutade ärenden',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'Öppna ärenden',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'Försäljningar, Topp 10',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'Displayer top tio intäktsposter i ett bubble diagram.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'Mina Intäktsposter',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "Mitt Teams Intäktsposter",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'Standard datum filter',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'Standard dataset',

    'LBL_PRODUCT_CATALOG_NAME' => 'Produktkatalog',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'Produktkatalog',
    'LBL_PRODUCT_CATALOG_DESC' => 'Visa och lägga till artiklar från din produktkatalog.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'Visa och lägga till artiklar från din produktkatalog.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} på {{date}} vid {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Skriv en anteckning eller dra och släpp en bilaga. Skriv @ för att nämna en användare. Skriv # för att referera till en post.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'Lägg till din kommentar ... Skriv @ för att nämna en användare. Skriv # för att referera till en post.',
    'LBL_ACTIVITY_STREAM' => 'Aktivitetsström',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'Activity Stream är inte aktiverat',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'Activity Stream är inte aktiverat för den här modulen',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'Flera poster...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'på',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'Min Activity Stream',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'Visa en lista med aktiviteter som utförs på poster och skapa och skriva kommentarer.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'Activity Streams is disabled',

    'LBL_DATA_VIEW' => 'Datavy',
    'LBL_COMMENT' => 'Kommentera',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'Det uppstod ett fel vid anslutning till servern. Försök igen.',
    'ERR_RESOLVE_ERRORS' => 'Vänligen åtgärda eventuella fel innan du fortsätter.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'Alla obligatoriska fält måste vara ifyllda för att du ska kunna godkänna; men, du kan fortfarande avvisa eller dirigera den här posten.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'Alla de obligatoriska fälten måste vara ifyllda, för att man ska kunna avvisa eller dirigera.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'Uppdatera listan',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'Uppdatera plattor',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'mer',
    'LBL_TEXTAREA_LESS' => 'mindre',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} bilagor',
    'LBL_CREATE_ATTACHMENT' => 'Skapa bilagor',
    'LBL_DASHLET_REFRESH' => 'Uppdatera',
    'LBL_DASHLET_MOVE' => 'Flytta',
    'LBL_DASHLET_CLOSE' => 'Stäng',

    'LBL_DASHLET_FORECAST_NAME' => 'I prognos',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'Prognosdiagram',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Prognos Stapeldiagram',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'Prognos för',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'Visar prognosdiagram för en specifik tidsperiod',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'Gruppera enligt',
    'LBL_DASHLET_FORECASTS_DATASET' => 'Datamängd',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'Prognos detaljer',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'Visar aktuella prognos detaljer.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'Sparade Rapporter-dashlet',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'Visar alla diagram från en sparad rapport.',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'Publicerade relaterade artiklar',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'Historik sammandrag',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'Mera historik...',
    'LBL_RELATED_CONTACT' => 'Relaterad Kontakt',
    'LBL_MODULE_TYPE' => 'Typ',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'Email till',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'Email från',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'Legacy moduler inte kan förhandsvisas',

    //SFA
    'LBL_BEST' => 'Bästa',
    'LBL_WORST' => 'Värsta',
    'LBL_LIKELY' => 'Sannolikt',
    'LBL_BEST_FORECAST' => 'Förpliktelse (bäst)',
    'LBL_WORST_FORECAST' => 'Förpliktelse (sämst)',
    'LBL_LIKELY_FORECAST' => 'Förpliktelse (sannolik)',
    'LBL_BEST_ADJUSTED' => 'Justerad förpliktelse (bäst)',
    'LBL_WORST_ADJUSTED' => 'Justerad förpliktelse (sämst)',
    'LBL_LIKELY_ADJUSTED' => 'Justerad förpliktelse (sannolik)',
    'LBL_AMOUNT_USDOLLAR' => 'Konverterad belopp',
    'LBL_OVERDUE' => 'Försenade',

    'LBL_PASSWORD_REQUEST_SENT' => 'Din begäran har skickats.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'Det gick inte att hitta din kombination av användarnamn och email.',

    'LBL_REMINDER_TITLE' => 'Påminnelse',
    'LBL_CLICK_TO_DRILLDOWN' => 'Klicka för drill down',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'Du kan inte inaktivera alla språk.',

    'LBL_UPDATE_CALC_FIELDS' => 'Räkna om värden',

    //Optimistic Locking
    'LBL_YOU' => 'Du',
    'LBL_RESOLVE_CONFLICT' => 'Lösa problemet för {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'För mer information, se {{{more_info_url}}} dokumentation för {{plural_module_name}}{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'Inga data tillgängliga',
    'LBL_NEED_HELP' => 'Behöver du hjälp med något nytt?',
    'LBL_NEW_CASE' => 'Nytt ärende',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'Hjälp dashlet ger specifik information avseende modulen du för närvarande visar tillsammans med en länk till motsvarande dokumentation (t.ex. Leads dokumentation) i programguiden för mer information.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'Hjälp för listvy',
    'LBL_HELP_RECORDS' => "En moduls listvy visas alla poster som uppfyller de aktuella sökkriterier och för vilka användare som har tillgång till den. Du kan visa grundläggande information om varje post inom fältkolumnerna i listvyn eller klicka på postens namn för att öppna postens översikt.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'Post Översikt Hjälp',
    'LBL_HELP_RECORD' => 'Detta posts vy ger grundlig information om en enskild post samt vissa uppgifter om de poster som är kopplade till den. - Redigera denna postens fält genom att klicka ett enskilt fält eller på knappen Redigera. - Visa eller ändra länkar till andra poster i underpanelerna genom att växla den nedre vänstra rutan till "Data View". - Interagera med användarkommentarer och se poständringshistorik genom att växla den nedre vänstra rutan till "Activity Stream". - Följ eller favorite denna post med hjälp av ikonerna till höger om postens namn. - Ytterligare åtgärder finns i dropdown menyn Åtgärder till höger om knappen Redigera.',

    // create view
    'LBL_HELP_CREATE_TITLE' => 'Skapa {{module_name}}',
    'LBL_HELP_CREATE' => 'För att skapa {{plural_module_name}}: 
1. Lägg in de värden i de fält som önskas. 
- Fält markerade "Obligatorisk" måste fyllas i innan du sparar. 
- Klicka på "Visa mer" för att visa ytterligare fält. 
2. Klicka på "Spara" för att spara den nya posten och återgå till listvyn för {{plural_module_name}}.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'Potentiell dubblett upptäckts',
    'LBL_HELP_DUPLICATE' => 'Sugar har upptäckt att den post du försöker skapa redan kan finnas. För att ändra en befintlig post i stället för att skapa en ny, klicka på "Välj och redigera" till höger om den önskade posten. Eventuella tomma fält på den befintliga posten ska fyllas i med de värden du just har angett. Klicka på "Spara" för att göra dessa ändringar i den befintliga posten. Om du istället vill använda de värden du just har satt in i stället för värdena på den befintliga posten, klicka på "Återställ till original". Värdena du angav kommer sedan att tillämpas på den befintliga posten, och du kan nu ge några ytterligare ändringar och klicka på "Spara" för att slutföra ändringar i den befintliga posten. För att skapa en ny post med hjälp av de värden som du har angett, klicka på "Ignorera Duplicate och spara" längst upp till höger på skärmen.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'SMTP Serverinställningar saknas',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'För att skicka postuppdrag meddelanden behöver du en SMTP-server konfigurerad i {{emailSettingsUrl}}.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'Emailinställningar',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'Nya lagerrapporter tillgängliga',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'Nya lagerrapporter finns tillgängliga i din ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'Rapport modul',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'De är taggade som "lagerrapport" och kan filtreras. Rapporter är även taggade som "Försäljning och Marknadsföring", "Kundtjänst", "Datasekretess" eller "Administrativ" baserat på innehållet. För mer information, se ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'dokumentation',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM göra det möjligt för avancerade användare att snabbt utföra vissa uppgifter med kortkommandon för att öka produktiviteten. Tabellerna till höger beskriver tillgängliga genvägar tillsammans med nycklarna och de åtgärder de utför.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>Stödnycklar</h1> <ul><li>alla alfanumeriska tecken och symboler</li> <li>shift, ctrl, alt, kommando, mod (ctrl i Windows/Linux och kommando i mobila luftkonditioneringsanläggningar)</li> <li>in, esc, utrymme, flikar, PgUp, PgDn, Home, Back Ins, Del, Backsteg</li></ul> <h1>Funktioner som stöds</h1> <ul><li>Nyckelkombination: ctrl + m</li> <li>flera nycklar: m, ctrl + m</li> <li>nyckelordningsföljd: m en</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'Globala genvägar',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'Kontextuella genvägar',
    'LBL_SHORTCUT_KEY_KEY' => 'Nyckel',
    'LBL_SHORTCUT_FUNCTION' => 'Funktion',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Konfigurera kontextuella genvägar',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'Inga kontextuella genvägar att konfigurera',
    'LBL_SHORTCUT_HELP' => 'Visa genvägars hjälp sida',
    'LBL_SHORTCUT_QUICK_CREATE' => 'Växla i snabb skapa menyn',
    'LBL_SHORTCUT_SEARCH' => 'Fokusera på globala sökfält',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'Växla sidomenyn',
    'LBL_SHORTCUT_CREATE_RECORD' => 'Skapa ny post',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'Välj nästa post i listan',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'Välj föregående post på listan',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'Scroll listan till vänster',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'Scroll listan till höger',
    'LBL_SHORTCUT_OPEN' => 'Öppna markerade poster på listan',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'Redigera markerad post på listan',
    'LBL_SHORTCUT_RECORD_DELETE' => 'Radera post',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Exit ur listans inline redigeringsläge utan att spara',
    'LBL_SHORTCUT_RECORD_SAVE' => 'Spara post',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'Rensa ut alla ändringar i posten',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'Markera post som favorit',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'Följ post',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'Förhandsgranska posten',
    'LBL_SHORTCUT_MARK_SELECTED' => 'Markera posten som vald',
    'LBL_SHORTCUT_SELECT_ALL' => 'Välj alla',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'Öppna massaktion rullgardinsmenyn',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'Fokus på listans filterfält',
    'LBL_SHORTCUT_FILTER_CREATE' => 'Skapa en ny lista med filter',
    'LBL_SHORTCUT_FILTER_EDIT' => 'Redigera nuvarande listfilter',
    'LBL_SHORTCUT_FILTER_SHOW' => 'Öppna listans filtermenyn',
    'LBL_SHORTCUT_RECORD_EDIT' => 'Redigera posten',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'Öppna föregående post',
    'LBL_SHORTCUT_RECORD_NEXT' => 'Öppna nästa post',
    'LBL_SHORTCUT_COPY_RECORD' => 'Kopiera nuvarande post',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'Öppna primära åtgärden rullgardinsmenyn',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'Stäng låda',
    'LBL_SHORTCUT_FILTER_ADD' => 'Lägg ytterligare kriterier för att filtrera',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'Ta bort sista kriterierna från filtret',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'Stäng filtret',
    'LBL_SHORTCUT_FILTER_SAVE' => 'Spara filtret',
    'LBL_SHORTCUT_FILTER_DELETE' => 'Radera filtret',
    'LBL_SHORTCUT_FILTER_RESET' => 'Återställ filter',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'Lägg till rad',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'Ta bort rad',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'Stäng massa uppdatering',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'Uppdatera poster',
    'LBL_CREATE_CATEGORY' => 'Skapa en <div class="btn-link" data-action="create-new"> Kategori</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'Bekräfta',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'Avbryt',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'Markera alla objekt i en flervalsfält',
    'LBL_SHORTCUT_SWEETSPOT' => 'Växla Sweet Spot-fältet',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'Dölj Sweet Spot-fältet',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'Spara konfigurationen',
    'LBL_SHORTCUT_RESTORE' => 'Återställ till standard',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'Ett fel uppstod när anpassade kortkommandon sparades på servern. Försök igen.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}} Inställningar',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}} konfigurationsinställningar har sparats.',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} Konfigurationsfel',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} har inga konfigurationsinställningar',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'Användaren har inte åtkomst till {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'Användaren har inte åtkomst till att konfigurera {{module}} inställningarna',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'Databasinställningarna för {{module}} behöver fixas',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'till',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'Start & Slutdatum',

    'LBL_CALENDAR_START_DATE' => 'Startdatum',
    'LBL_CALENDAR_END_DATE' => 'Slutdatum',
    'LBL_CALENDAR_DURATION' => 'Varaktighet',
    'LBL_CALENDAR_RECURRENCE' => 'Upprepning',
    'LBL_CALENDAR_REMINDERS' => 'Påminnelser',

    'LBL_CALENDAR_CUSTOM_DATE' => 'Anpassade datum',
    'LBL_CALENDAR_REPEAT_TYPE' => 'Upprepningstyp',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'Upprepningsintervall',
    'LBL_CALENDAR_REPEAT_DOW' => 'Repetera på Dag i Veckan',
    'LBL_CALENDAR_REPEAT_ON' => 'Upprepa den',
    'LBL_CALENDAR_REPEAT' => 'Upprepa',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'Repetera Ända Till',
    'LBL_CALENDAR_REPEAT_COUNT' => 'Förekomster av upprepning',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'Upprepa Selector',
    'LBL_CALENDAR_REPEAT_DAYS' => 'Dag(ar) per månad',
    'LBL_CALENDAR_REPEAT_MONTH' => 'Månad(er) på året',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'Upprepa ordningstal',
    'LBL_CALENDAR_REPEAT_UNIT' => 'Upprepa enhet',
    'TPL_REPEAT_INTERVAL' => 'Varje {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'Den här serien använder ett Upprepa den-alternativ som inte är tillgängligt i Sugar eftersom serien synkroniserades från en kalenderklient. Redigera den här serien i din kalenderklient om du vill fortsätta att upprepa på ett specifikt datum. Om du redigerar den här serien i Sugar ställs Upprepa den in till Aldrig.<br><br>Vill du fortsätta?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'Återkommande ändringar måste göras på den första posten i serien.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'Återkommande regler leder inte till en händelse som genereras.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'Deltar',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'Avböjt',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'Preliminärt',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'Inget svar',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'Schema otillgängligt',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'Tillgängliga vyer',
    'LBL_CALENDAR_DASHLET_NAME' => 'Schemaläggare för kalender',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'Standardvy',
    'LBL_CALENDAR_MY_CALENDARS' => 'Mina kalendrar',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'Användar- och gruppkalendrar',
    'LBL_CALENDAR' => 'Kalender',

    'LBL_CALENDAR_DAY' => 'dag',
    'LBL_CALENDAR_WEEK' => 'vecka',
    'LBL_CALENDAR_MONTH' => 'månad',
    'LBL_CALENDAR_YEAR' => 'år',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92:a',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98:e',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99:e',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'Fel uppstod vid hämtande av schema.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'Spara och Skicka Inbjudan',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'Acceptera status',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'Processer',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'Process-dashleten visar mallarna som kan användas i SugarBPM.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'Processdefinitioner',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'Processdefinitions-dashleten visar mallarna som kan användas i SugarBPM.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'Skapa Processdefinitioner',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'Importera Processdefinitioner',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'Affärsregelprocesser',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'Processaffärsregler-dashleten visar vilka mallar som kan användas i SugarBPM.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'Skapa Affärsregelprocess',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'Importera Affärsregelprocesser',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'Processemailmallar',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'Dashleten för process-e-postmallar visar mallarna som kan användas i SugarBPM.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'Skapa Processemailmall',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'Importera Processemailmallar',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'När du utvecklar processer, affärsregler eller emailmallar i en annan instans av Sugar rekommenderar vi starkt att använda en exakt klon av ditt produktionssystem. Processer, affärsregler och emailmallar som byggts i en enskild version av Sugar kan fungera dåligt när de väl importeras. Processer, affärsregler och emailmallar kan förlita sig på specifika Studio- eller applikationsförändringar som egna fältnamn, menyalternativ, databas-IDn, etc. Om dessa värden inte är identiska med instansen där processen, affärsregeln eller emailmallen byggdes kan du behöva bygga om processen, affärsregeln eller emailmallen i din målinstans.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'Vill du ändå gå vidare med importeringen?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'Vill du ändå gå vidare med exporteringen?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'Följande rullgardinsfält innehåller ogiltiga alternativ',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'Pågående aktiviteter efter process',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'Pågående aktiviteter',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'Pågående aktiviteter efter process',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'Alla Processer',
    'LBL_RECORD_DASHBOARD' => 'Instrumentpanel för poster',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'Sammanfattad processstatus',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'Processstatusbeskrivning',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'Pågår',
    'LBL_PMSE_COMPLETED_STATUS' => 'Genomfört',
    'LBL_PMSE_CANCELLED_STATUS' => 'Avbruten',
    'LBL_PMSE_TERMINATED_STATUS' => 'Slutat',
    'LBL_PMSE_ERROR_STATUS' => 'Error',
    'LBL_PMSE_SETTINGS' => 'SugarBPM-inställningar',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'Är du säker på att du vill inaktivera den här posten?',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'Är du säker på att du vill aktivera den här posten?',
    'LBL_PRO_DELETE_CONFIRMATION' => 'Är du säker påa tt du vill radera posten?',

    'LBL_PRO_ENABLE' => 'Uppdaterar',
    'LBL_PRO_DISABLE' => 'Uppdaterar',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} deltar i en process och kan innehålla vissa låsta fält. Om du vill redigera posten, klicka här {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'Detta fält är låst eftersom det engageras i en körande process.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'Posten deltar i en process och kan innehålla vissa låsta fält.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'Affärscenter',
    'LBL_BUSINESS_CENTER_ID' => 'Affärscenter ID',
    'LBL_BUSINESS_CENTER_NAME' => 'Affärscenter namn',

    'LBL_PLIS_ACTIVITIES' => 'Aktiviteter för köpta poster',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(Ny tagg)',
    'LBL_TAG_FETCH_ERROR' => 'Ett fel uppstod vid hämtning av taggar.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'SugarCRM kräver javascript. Vänligen akivera javascript för att fortsätta använda SugarCRM.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'Den serialiserade datan kunde ej avserialiseras',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'Den serialiserade datan kunde ej avserialieras eftersom den innehåller referenser till objekt eller klasser',

    'LBL_FIELD_TRIMMED' => 'Fältet trimmades på grund av att det överskred teckengränsen.',
    'LBL_FIELDSIZE_OVERFLOW' => 'Fältet överskrider högsta tillåtna teckengränsen.',
    'LBL_TINYMCE_TARGET_SAME' => 'Samma fönster',
    'LBL_TINYMCE_TARGET_NEW' => 'Nytt fönster',

    'LBL_OUTBOUND_EMAILS' => 'E-postinställningar',
    'LBL_OUTBOUND_EMAIL' => 'E-postinställning',

    'LBL_EMAIL_PARTICIPANTS' => 'E-deltagare',
    'LBL_EMAIL_PARTICIPANT' => 'E-deltagare',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'Datasekretess',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'Datasekretess',
    'LBL_DATAPRIVACY_VIEW_PII' => 'Se personlig information',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'Markera för att radera',
    'LBL_DATAPRIVACY_FIELDNAME' => 'Fält',
    'LBL_DATAPRIVACY_VALUE' => 'Värde',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'Ändrad av',
    'LBL_DATAPRIVACY_SOURCE' => 'Källa',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'Senast uppdaterad',
    'LBL_DATAPRIVACY_PII' => 'Personlig information',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'Markera för att radera',
    'TPL_DATAPRIVACY_PII_TITLE' => 'Personlig information för {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'Ändra timers',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'Meddelanden',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'Kopierad till urklipp!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'Kunde inte kopieras till urklipp',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'Kopiera bekräftelselänk',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'Tidslinje',
    'LBL_NO_ACTIVITY' => 'Ingen aktivitet',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} Tidslinje',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'Mer',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'Mindre',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'Tidslinjen visar den aktuella postens relaterade poster och utvalda fältuppdateringar över tid.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'Visa fler ...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'Visa Mindre...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'Inga data tillgängliga',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'Modulen är inte licensierad.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'Aktiva prenumerationer',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'Denna dashlet går bara att lägga till för moduler som länkar till ett enda konto. Se dokumentationen <a href={{linkToDocumentation}}>Aktiv prenumerationsdashlet</a> för ytterligare information.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'Visa inköp som hör samman med detta länkade konto:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'Aktiva prenumerationer för ett specifikt konto.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', kvantitet {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'Totalt:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'Inga aktiva prenumerationer',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'Denna instrumentpanel kräver {{module_name}} för att fungera. Kontakta din administratör om att aktivera {{module_name}}.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'Köphistorik',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'Alla köp för ett specifikt konto.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'Denna dashlet går bara att lägga till för moduler som länkar till ett enda konto. Se dokumentationen <a href={{linkToDocumentation}} target="_blank">Köphistorikdashlet</a> för mer information.',
    'LBL_NO_PURCHASE_HISTORY' => 'Inga köp att visa',
    'LBL_NO_PLIS' => 'Inga köpta poster',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'Totalt',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'Kvantitet',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'Denna dashlet kräver Köp och Köpta poster för att fungera. Prata med din administratör om att aktivera Köp och Köpta postera.',
    'LBL_SEARCH_PURCHASE_NAME' => 'Söker efter Inköpsnamn...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'Använd Studio för att redigera layouten för dashlet-vyn genom att gå till ' .
        'Studio > {{module}} > Layouter > Inspelningsvy instrumentpanel. <a href={{linkToStudio}}>Redigera i Studio</a>.',
    'LBL_SERVICE_LEVEL' => 'Servicenivå',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'Antal',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'Följ upp',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'Prioritet/Status',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'Ämne/beskrivning',

//Service Duration
    'LBL_SERVICE_DURATION' => 'Servicevaraktighet',
    'LBL_SERVICE_DURATION_VALUE' => 'Värde servicevaraktighet',
    'LBL_SERVICE_DURATION_UNIT' => 'Servicevaraktighet enhet',
    'LBL_LOCK_DURATION' => 'Varaktighet för lås',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Amazon Connect CCP kunde inte laddas. Vänligen' .
        'säkerställ att du använder en ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">webbläsare som stöds</a>. ' .
        'Om problemet kvarstår ska du kontakta din Sugar-administratör.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Din Sugar-administratör har inte konfigurerat din instans för Amazon Connect.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Kunde inte etablera anslutning med Amazon Connect. Kontakta din Sugar-administratör för att få hjälp.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'Okänd',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'Fokuslåda',
    'LBL_CLOSE_FOCUS_DRAWER' => 'Stäng fokuslåda',
    'LBL_EXTERNAL_GUESTS' => 'Externa gäster',
    'LBL_MY_FAVORITE_TASKS' => 'Mina favorituppgifter',
    'LBL_RECORD' => 'Register',

    'LBL_MY_TASKS' => 'Mina uppgifter',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'Kunde inte hitta fältet: {0} i modulen: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'Kunde inte hitta posten {0}: {1} i modulen: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'Kunde inte hitta en relation med namnet: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'En databasinmatning med id: {0}, med {1}: {2} i modulen: {3} finns redan',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'mjuk borttagen (med borttagen flagga = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'Hittade flera databasposter för {0} {1} i modulen {2}. ' .
        'Ta bort eller uppdatera de matchande posterna i enlighet med detta. Matchande poster: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'Nästa körning',
    'LBL_TIME_AWARE_TYPE' => 'Typ',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean-ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'Visa etikett',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'Öppna postvy',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'Lägg till',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'Hjälp är inte tillgänglig',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'Funktioner',
    'LBL_ACTIONBUTTON_FIELDS' => 'Fält',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'Välj fält...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Sammanställ',
    'LBL_ACTIONBUTTON_RELATED' => 'Relaterad',
    'LBL_ACTIONBUTTON_SAVE' => 'Spara',
    'LBL_ACTIONBUTTON_CANCEL' => 'Avbryt',
    'LBL_ACTIONBUTTON_R_MODULE' => 'Relaterad modul',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'Relaterade fält',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'Sammanställningsmodul',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'Sammanställningsfält',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'Sammanställningsfunktion',
    'LBL_ACTIONBUTTON_MINIMUM' => 'Min',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'Max',
    'LBL_ACTIONBUTTON_AVERAGE' => 'Medel',
    'LBL_ACTIONBUTTON_SUM' => 'Summa',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'Tilldela post',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'Skriv e-postmeddelande',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'Skapa post',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Dok-sammanslagning',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'Öppna Url',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'Kör rapport',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'Uppdatera post',
    'LBL_ACTIONBUTTON_ACTION' => 'Åtgärd',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'Tilldela till',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'E-post till',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'Använd PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'Mall',
    'LBL_ACTIONBUTTON_MODULE' => 'Modul',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'Visuella inställningar',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'Typ',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'Rullgardinsmeny',
    'LBL_ACTIONBUTTON_BUTTON' => 'Knapp',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'Knappgrupp',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'Visa namn på post',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'Visa i rubriken',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'Dölj vid redigering',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'Visa på sidhuvud för fokusinstrumentpanel',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'Instrumentpanel',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'Sidhuvud för fokusinstrumentpanel',
    'LBL_ACTIONBUTTON_SIZE' => 'Storlek',
    'LBL_ACTIONBUTTON_DEFAULT' => 'Standard',
    'LBL_ACTIONBUTTON_SMALL' => 'Liten',
    'LBL_ACTIONBUTTON_LARGE' => 'Stor',
    'LBL_ACTIONBUTTON_CALCULATED' => 'Beräknad',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'Konvertera till PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Sammanfoga dokument',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'Förhandsgranska',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'Egenskaper',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'Etikett',
    'LBL_ACTIONBUTTON_DESC' => 'Verktygstips',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'Visa etikett',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'Visa ikon',
    'LBL_ACTIONBUTTON_SCHEME' => 'Färgschema',
    'LBL_ACTIONBUTTON_ICON' => 'Ikon',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'Beroende',
    'LBL_ACTIONBUTTON_DESIGN' => 'Layoutkonfiguration',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'Stoppa vid fel',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'Spara automatiskt',
    'LBL_ACTIONBUTTON_CONFIG' => 'Konfigurera',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'Konfigurera åtgärdsknappen innan du sparar.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'Konfigurera knappar',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'Skapa automatiskt',
    'LBL_ACTIONBUTTON_LINK' => 'Skapa relation till moder',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'Kopiera överordnade värden',
    'LBL_ACTIONBUTTON_PRESET' => 'Ange fältvärde(n)',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'Kopiera fältvärde(n) från moder',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'Välj...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'Från överordnat fält ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'Är du säker på att du vill ta bort denna knapp?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'Är du säker på att du vill ta bort denna åtgärd?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'Ogiltig data för åtgärdsknapp',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'Välj en modul innan du sparar.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'Välj en länk innan du sparar. Om det inte finns någon länk avmarkerar du länkalternativet.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'Välj en post innan du sparar.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'Välj en mall innan du sparar.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'Primär',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'Sekundär',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'Hav',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'Rosa',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'Armé',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'Kricka',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'Stilla',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'Grön',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'Gul',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'Orange',
    'LBL_ACTIONBUTTON_THEME_RED' => 'Röd',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'Korall',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'Lila',
    'LBL_ACTIONBUTTON_FORMULA' => 'Formel',
    'LBL_ACTIONBUTTON_ACTIONS' => 'Åtgärder',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'Fel vid validering av knappdata.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'Knappar måste ha minst en etikett eller en ikonuppsättning.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'Ange en giltig knappetikett.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'Det gick inte att skapa posten då nödvändiga värden saknas. Kontakta administratör.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'Du måste ha minst två aktiva knappar för denna knapptyp.',
    'LBL_ACTIONBUTTON_RECORD' => 'Postvyer',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'Åtgärdsmenyer',
    'LBL_ACTIONBUTTON_ORDER' => 'Ordning',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'Listvy',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'Rubrik för postvy',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'Dashletrubrik för postvy',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'Underpaneler',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'Motorn som utför uppgiftssekvenser misslyckades med att utföra följande åtgärder: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'Lägg till en åtgärd',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'Ta bort denna åtgärd',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'Aktuell användare',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'Doc Merge',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'Doc Merge till PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'Företagsstorlek',
    'LBL_HINT_COMPANY_INDUSTRY' => 'Industri',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'Industritaggar',
    'LBL_HINT_COMPANY_LOCATION' => 'Företagets plats',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'Företagsbeskrivning',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'Grundat år',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Företagets Facebook',
    'LBL_HINT_COMPANY_TWITTER' => 'Företagets Twitter',
    'LBL_HINT_COMPANY_PIC' => 'Företagets logotyp',
    'LBL_HINT_CONTACT_PIC' => 'Kontaktbild',
    'LBL_HINT_COMPANY_WEBSITE' => 'Företagets hemsida',
    'LBL_HINT_PHOTO' => 'Fotolänk',
    'LBL_HINT_JOB_2' => 'Föregående jobb',
    'LBL_HINT_EDUCATION' => 'Utbildning',
    'LBL_HINT_EDUCATION_2' => 'Ytterligare utbildning',
    'LBL_HINT_TWITTER' => 'Twitter-länk',
    'LBL_HINT_FACEBOOK' => 'Facebook-länk',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS-kod',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC-kod',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'Räkenskapsårets slut',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'Årsintäkt',
    'LBL_HINT_PHONE_1' => 'Telefon 1',
    'LBL_HINT_PHONE_2' => 'Telefon 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'Sammanfoga tabell',
    'LBL_HINT_FULL_NAME' => 'Fullständigt namn',
    'LBL_HINT_JOB_TITLE' => 'Befattning',
    'LBL_HINT_OFFICE_PHONE' => 'Kontorstelefon',
    'LBL_HINT_MOBILE_PHONE' => 'Mobil',
    'LBL_HINT_OTHER_PHONE' => 'Annan telefon',
    'LBL_HINT_WEBSITE' => 'Webbplats',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'Vill du skriva över befintlig data för denna post med ny data som hittades i Sugar Hint?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'Vill du skriva över befintlig {{fieldName}} för den här posten med ny {{fieldName}} som hittades i Sugar Hint?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'Alla kontorelaterade data kommer att tas bort. Vill du fortsätta?',
    'LBL_HINT_COMPANY_LOGO' => 'Logotyp',
    'LBL_HINT_CONTACTS_AVATAR' => 'Foto',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint-kontouppsättningars taggar',

    'LBL_HINT_LOADING' => 'Laddar ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Avinstallerar Sugar Hint, vänta',
    'LBL_HINT_VALUE_ERASED' => ' Värdet raderat ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'Den här informationen raderades via datasekretessbegäran',

    'LBL_HINT_UNINSTALL_TITLE' => 'Välj en av alternativen för avinstallering nedan:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Avinstallera enbart Hint-paketet',
    'LBL_HINT_UNINSTALL_FULL' => 'Avinstallera Hint helt',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'Detta alternativ kommer att ta bort Hint MLP och avaktivera alla aktiva prenumerationer till Sugar Hint Insights.
    Om Hint återinstalleras kommer prenumerationerna att återaktiveras automatiskt.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'Med detta alternativ avinstalleras Hint helt och hållet, inklusive borttagning av MLP och radering av all konfigurations- och prenumerationsinformation.',
    'LBL_HINT_UNINSTALL' => 'Avinstallera',
    'LBL_HINT_UNINSTALL_HEADER' => 'Avinstallera Sugar Hint',
    'LBL_HINT_CANCEL' => 'Avbryt',
    'LBL_HINT_UNINSTALL_WARNING1' => 'VARNING: Använd bara detta alternativ om du inte avser att använda Hint igen i framtiden.    Innan du avinstallerar ska du göra en fullständig säkerhetskopia av din Sugar-databas och sätta Sugar i underhållsläge. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'Se ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint-administrationsguide ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'för mer information om avinstalleringen.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Vill du verkligen avinstallera endast Sugar Hint-paketet?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Vill du verkligen avinstallera Sugar Hint helt?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(OBS: DENNA ÅTGÄRD KAN INTE ÅNGRAS)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint-fält',
    'LBL_HINT_NO_RESULTS_MSG' => 'Inga resultat hittades.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'Baslayout för Hint-panel',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'Konton',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'Kontakter',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'Leads',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'Utvidgad layout för Hint-panel',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'Ordna om fälten genom att dra och släppa dem i Hint-panelens layout ovan.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'För detaljerade anvisningar och en lista över standardfält, se ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' för att återställa standardinställningar för ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'modulen.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'Vill du verkligen återställa {{module}}-modulen till standardinställningarna?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'Klicka här',
    'LBL_HINT_CONFIG_NAME' => 'Hint-administrationsguide.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'Fält',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'Berikade fält',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'I detta avsnitt finns alla Hint-fält och Sugar-fält som berikas med Hint. Hint-fält har markerats med en asterisk (*) och kan endast visas i Hint-panelen om de har berikats.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'Fältnamn',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'Berikat fält',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Visa i Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Visa i Hint-panel',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'Ytterligare Sugar-fält',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'I detta avsnitt finns alla Sugar-fält som inte berikas av Hint.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'Varning',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'Varning: Du håller på att synkronisera med Sugar Hint Insights-tjänsten. E-postsammanfattningar som ligger och väntar kommer att försvinna och befintliga nyheter kommer att tas bort från Insights-dashlet. Alla typer av aviseringar kommer att återupptas efter att synkroniseringen är klar.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'Föreslagna företag baserat på din {{_moduleSingular}} visas nedan. Välj den företagsdata som ska visas.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'Inget konto valt',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'Flera e-postmeddelanden hittades, välj vilka e-postmeddelanden som ska importeras: ',

    'LBL_HINT_HELP_MESSAGE1' => 'Med den data som angetts har Hint inte kunnat hitta någon matchning i systemet.',
    'LBL_HINT_HELP_MESSAGE2' => 'De bästa resultaten i Hint får du med en persons namn och e-postadress.',
    'LBL_HINT_HELP_MESSAGE3' => 'De bästa resultaten i Hint får du med företagets webbadress.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "Ange ditt {{_moduleSingular}}s företagsnamn eller webbplats, så kommer Hint att söka efter ytterligare data.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "Ange din {{currentModule}}s e-postadress, så kommer Hint att söka efter ytterligare data.",

    'LBL_HINT_HISTORY_NONE' => 'Inga data tillgängliga för historikvy',
    'LBL_HINT_HISTORY_TITLE' => 'Aktivitetshistorik',

    'LBL_HINT_PREVIEW_TITLE' => 'Berika data',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Din licens för Hint-tjänsten har utgått. Kontakta din SugarCRM-administratör för att förnya din licens.',
    'LBL_HINT_PREVIEW_QUESTION' => 'Vill du se vad Hint kan göra för dig och ditt företag? Kontakta din SugarCRM-administratör för att lägga till Hint.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'Kontoinformationen hittades inte',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'Berikad data hittades – klicka för att spara all berikad data till din post.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'Klicka för att spara berikad data till din post.',

    'LBL_HINT_CONTACTS_TITLE' => 'Relaterade kontakter',
    'LBL_HINT_CONTACTS_NONE' => 'Inga relaterade kontakter',

    'LBL_HINT_NEWS' => 'Nyheter',
    'LBL_HINT_GENERAL' => 'Allmänt',
    'LBL_HINT_ALL_NEWS' => 'Alla nyheter',
    'LBL_HINT_FILTER_NEWS' => 'Filtrera nyheter',
    'LBL_HINT_FINANCIAL_NEWS' => 'Ekonomi',
    'LBL_HINT_PERSONNEL_NEWS' => 'Personal',
    'LBL_HINT_PRESS_RELEASES' => 'Pressreleaser',
    'LBL_HINT_OTHER_NEWS' => 'Övrigt',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'Sök efter nyhetsartiklar',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'Inga nyheter tillgängliga',
    'LBL_NEW_NOTIFICATIONS' => 'Nya meddelanden',
    'LBL_HINT_DASHLET_ALLOWED1' => 'Du måste ha en Sugar Hint-licens för att se Sugar Hint Insights-dashlet.
    Ta upp frågan om att skaffa en Sugar Hint-licens med din administratör.',

    'LBL_HINT_FOR' => 'För',
    'LBL_HINT_WITH' => 'med',
    'LBL_HINT_SHOW_ME' => 'Visa: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'Meddela mig genom: ',

    'LBL_NOTIFICATIONS_TITLE' => 'Inställningscentrum för Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'Preferensalternativsnyckel',
    'LBL_HINT_PREFERENCES' => 'Inställningar',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'Radera avaktiverat, minst en preferensförklaring krävs',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'Lägga till avaktiverat, du har nått maximalt antal tillåtna preferensförklaringar',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Inkludera i Sugar Hint Insights-dashlet',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'Popup som skrivbordsavisering',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'Aviseringar måste vara aktiverade på alla webbläsare och alla datorer för att aviseringarna ska komma fram.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Vissa webbläsare, som Internet Explorer, stöder inte aviseringar. Aviseringar kan inte aktiveras när man använder en webbläsare som inte stöder aviseringar.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'Skicka ett omedelbart e-postmeddelande för varje avisering',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'Skicka en e-postsammanfattning per dag',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'Skicka en e-postsammanfattning per vecka',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'Inställningarna kan inte sparas. Kontrollera systemanslutningen och försök igen.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'Vissa obligatoriska fält saknar ett värde. Kontrollera dina inställningar och se till att alla obligatoriska fält är ifyllda.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'Du håller på att aktivera webbläsaraviseringar för SugarHint Insights. Klicka på Bekräfta för att fortsätta. Din webbläsare frågar sedan efter ditt tillstånd att skicka aviseringar.',
    'LBL_HINT_PUSH_ERROR' => 'Ett plugin-programm för push-aviseringar har registrerats för {{options.type}} utan dess beroenden. Plugin-programmet kommer inte fungera som avsett. Se till att du anger en sökväg till arbetsfilen och en metod för att spara prenumerationen på servern.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'Sätt PÅ Hint-aviseringar för alla användare',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'Stäng AV Hint-aviseringar för alla användare',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'VARNING: Det gick inte att avaktivera aviseringarna under avinstallationen av Sugar Hint. För att avaktivera aviseringar, installera Sugar Hint 5.4.0 eller högre och avinstallera helt med Sugar Hint Uninstaller som finns i administrationsdelen av Sugar.',
    'LBL_HINT_ENRICH_ALL' => 'Utveckla alla',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'Tipslicens krävs',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'Konfiguration av kartor',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'Loggvisare för geokoder',
    'LBL_MAP_MAP' => 'Karta',
    'LBL_MAP_MAPS' => 'Kartor',
    'LBL_MAP_GEOCODING_RECORD' => 'Geokod',
    'LBL_MAP_GEOCODE_SUCCESS' => 'Posten har geokodats utan problem.',
    'LBL_MAP_LATITUDE' => 'Latitud',
    'LBL_MAP_LONGITUDE' => 'Longitud',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'Sök efter adress...',
    'LBL_MAP_ALREADY_GEOCODED' => 'Den aktuella posten har redan geokodats. Vill du verkligen skriva över geokodningen för den här posten?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'Manuell geokodning',
    'LBL_MAP_POINT_COORDINATES' => 'Koordinater för kartpunkter',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'Beräknar bästa resväg...',
    'LBL_MAP_DIRECTIONS' => 'Vägbeskrivning',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'Vägbeskrivning som startar från aktuell användare',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'Vägbeskrivning som startar från denna post',
    'LBL_MAPS_RADIUS_INPUT' => 'Radie (0–250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'i en radie från postnumret',
    'LBL_MAPS_DISTANCE' => 'Distans',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'Postnummer',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'Ogiltig konfiguration: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong>-fältkartläggningar är ogiltiga.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'Karttyp',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'Zoomnivå',
    'LBL_MAPS_DASHLET' => 'Kartor',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'Visar geokodad(e) post(er) på kartan.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'Kartor är inte tillgängligt för denna modul. Aktivera Kartor i admin-konsolen.',
    'LBL_MAP_MODULES' => 'Modul',
    'LBL_MAP_FILTER_BY' => 'Filtrera efter',
    'LBL_MAP_UNIT_TYPE' => 'Enhetstyp',
    'LBL_MAP_UNIT_TYPE_MILES' => 'Engelska mil',
    'LBL_MAP_UNIT_TYPE_KM' => 'Kilometer',
    'LBL_MAP_ADDRESS' => 'Adress',
    'LBL_MAP_NO_STARTING_POINT' => 'Startpunkten har inte geokodats.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'Startpunktsposten har inte geokodats.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'Vissa av de poster som valt är inte geokodade och kommer inte att visas på kartan.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'Post(er) har inte geokodats.',
    'LBL_MAPS_MODULE_FIELDS' => 'Modulfält',
    'LBL_MAPS_SELECT_FIELD' => 'Välj fält',
    'LBL_MAPS_RELATE_RECORD' => 'Relaterad post',
    'LBL_MAPS_MAPPING_TYPE' => 'Kartläggningstyp',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'Inga geokodade poster',
    'LBL_MAPS_ADDRESS' => 'Adress',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'Tilldelad användare',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'Gatuvy är inte tillgängligt för den angivna punkten',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong>-poster gäller inte för kartläggning. Ta bort modulen från listan.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'Stäng',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'Expandera',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'Spara som PDF',
    'LBL_MAPS_EMAIL_LINK' => 'E-postlänk',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'Du måste ha minst en geokodad post.',
    'LBL_MAPS_GENERATING' => 'Genererar karta...',
    'LBL_MAPS_POINTS' => 'Kartpunkter',
    'LBL_MAPS_POINT' => 'Punkt',
    'LBL_MAPS_TRAVEL_DETAILS' => 'Reseinformation',
    'LBL_MAPS_TOTAL_DISTANCE' => 'Total distans',
    'LBL_MAPS_TOTAL_DURATION' => 'Total tid',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'Total tid utan trafik',
    'LBL_MAPS_ITINERARY' => 'Resplan',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'Reseavstånd',
    'LBL_MAPS_TRAVEL_DURATION' => 'Restid',
    'LBL_MAPS_TRAVEL_STEPS' => 'Steg',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'Varningar',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Maps stöder max. 10 nålmarkeringar på en delad karta. Se över dina val.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'Maps-licens krävs',
    'LBL_MAPS_SHARE_HELLO' => 'Hej,',
    'LBL_MAPS_SHARE_HEADER' => 'Du har frågat efter en Bing karta för följande punkter:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'Följande URL kommer öppna en karta som innehåller ovanstående punkter på Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Visa karta på Bing Maps',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'Ingen rutt hittades för de vägpunkter som angetts.',
    'LBL_MAPS_GEOCODE_STATUS' => 'Geokodstatus',
    'LBL_MAPS_GEOCODED' => 'Geokodad',
    'LBL_MAPS_NOT_GEOCODED' => 'Inte geokodad',
    'LBL_MAPS_NOT_FOUND' => 'Ogiltig adress',
    'LBL_MAPS_GEOCODING_FAILED' => 'Geokodning misslyckades',
    'LBL_MAPS_QUEUED' => 'Köad',
    'LBL_MAPS_REQUEUED' => 'Återköad',
    'LBL_MAPS_RELATED_RECORD' => 'Relaterad post',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'Visa rapport',
    'LBL_REPORT_DASHLET_DESC' => 'Visa en sparad rapport',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'Återställ till Dashlet-standard',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'Återställ till rapportstandard',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'Uppdatera resultat',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'Kopiera diagram till Urklipp',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'Ladda ner diagram',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'Rapporten för dashlet- {{label}} redigerades och dashlet har återställts till standardkonfigurationen.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'Du har inte behörighet att använda detta fält.',

    'LBL_INVALID_FORMULA' => 'Ogiltig Formel',
    'LBL_RETURN_TYPE_MISSMATCH' => 'Funktionens returtyp matchar inte',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'Förutsägelse',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'Ideal kundprofil',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'Stäng prediktionspoäng för veckan',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'Prediktionsvärde',
    'LBL_AI_CONV_BIN_ACCURACY' => 'Prediktionsnoggrannhet Bin',
    'LBL_AI_CONV_MULTIPLIER' => 'Prediktionsmultiplikator',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP-värde',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP-noggrannhet Bin',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP-multiplikator',
    'LBL_AI_NEW' => 'Ny',
    'LBL_AI_ENTERED' => 'Angiven',
    'LBL_AI_CREATED' => 'Skapad',
    'LBL_AI_WEEK' => 'Vecka',
    'LBL_AI_MONTH' => 'Månad',
    'LBL_AI_QUARTER' => 'Kvartal',
    'LBL_AI_BYWEEK' => 'efter vecka',
    'LBL_AI_BYMONTH' => 'efter månad',
    'LBL_AI_BYQUARTER' => 'efter kvartal',
    'LBL_AI_WEEKTREND' => 'Veckotrend',
    'LBL_AI_MONTHLYTREND' => 'Månadstrend',
    'LBL_AI_QUARTERTREND' => 'Kvartalstrend',
    'LBL_AI_TREND' => 'Trend efter',
    'LBL_AI_TRENDS' => 'Trender efter',
    'LBL_AI_VELOCITY' => 'Hastighet',
    'LBL_AI_TOPX' => 'Topp {X}',
    'LBL_AI_TIMESPAN' => 'Tidsspann mellan etapperna -',
    'LBL_AI_BUSINESSTREND' => 'med affärstrender',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Vi presenterar Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights använder kvantitativ analys för att generera nya insikter i dina SugarCRM-data. På Sugar söker vi alltid efter nya sätt att hjälpa dig få ut mest möjligt av dina data, ta välgrundade beslut, och detta är bara början till vad vi hoppas att kunna erbjuda med Sugar Insights.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights använder kvantitativ analys för att generera nya insikter i dina SugarCRM-data.',
    'LBL_AI_FIRMO' => 'Företagsdemografi',
    'LBL_AI_TOTALCOUNT' => 'Totalsumma på',
    'LBL_AI_DAYSFROMLATESTACT' => 'Dagar sedan förra',
    'LBL_AI_DAYSSINCE' => 'ålder',
    'LBL_AI_FIELDISSET' => 'finns',
    'LBL_AI_CONTACTCOMPLETENESS' => 'Fullständig kontaktinformation',
    'LBL_AI_CUTDATE' => 'Prognosperiod',
    'LBL_AI_FROMLASTCHANGE' => 'Dagar sedan den senaste ändringen av funktionsvärde',
    'LBL_AI_CALLSHELD' => 'Totalt antal gjorda samtal',
    'LBL_AI_CALLSPLANNED' => 'Totalt antal planerade samtal',
    'LBL_AI_OUTBOUNDCALLS' => 'Totalt antal utgående samtal',
    'LBL_AI_INBOUNDCALLS' => 'Totalt antal inkommande samtal',
    'LBL_AI_AVGCALLDURATION' => 'Genomsnittlig samtalslängd',
    'LBL_AI_EMAILSARCHIVED' => 'Totalt antal arkiverade e-postmeddelanden',
    'LBL_AI_EMAILSREAD' => 'Totalt antal lästa e-postmeddelanden',
    'LBL_AI_EMAILSSENT' => 'Totalt antal skickade e-postmeddelanden',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'Totalt antal poster där förväntat stängningsdatum har ändrats till ett senare datum',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'Totalt antal poster där förväntat stängningsdatum har ändrats till ett tidigare datum',
    'LBL_AI_AMOUNTINCREASED' => 'Totalt antal affärsmöjligheter där beloppet har ökat',
    'LBL_AI_AMOUNTDECREASED' => 'Totalt antal affärsmöjligheter där beloppet har minskat',

    // User last state
    'LBL_LAST_STATE' => 'Senaste tillstånd',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'Skicka till DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'Avbryt redigera mottagare',
    'LBL_RECIPIENT_ROLE' => 'Mottagarroll',
    // Base sales stages
    'LBL_OPEN' => 'Öppen',
    'LBL_CLOSED_WON' => 'Stängd Vunnen',
    'LBL_CLOSED_LOST' => 'Stängd förlorad',
    'LBL_KIOSK_ADD_FILES' => 'Lägg till filer',
    'LBL_KIOSK_ADD_DROP_FILES' => 'Lägg till eller släpp filer här',
    'LBL_KIOSK_CANCEL' => 'Avbryt',
    'LBL_KIOSK_EDIT' => 'Redigera',
    'LBL_KIOSK_EMAIL' => 'E-post',
    'LBL_KIOSK_FILES_UPLOADING' => 'Laddar upp',
    'LBL_KIOSK_FILES_ERROR' => 'Bilaga kunde inte laddas upp',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'Bilagan är för stor',
    'LBL_KIOSK_FILTER_SEARCH' => 'Sök',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'Kiosk',
    'LBL_KIOSK_LANGUAGE' => 'Språk',
    'LBL_KIOSK_LAST_UPDATED' => 'Senast uppdaterad',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'Visa',
    'LBL_KIOSK_MENU' => 'Meny',
    'LBL_KIOSK_MOBILE_PHONE' => 'Mobiltelefon',
    'LBL_KIOSK_MY_ACTIVITIES' => 'Mina aktiviteter',
    'LBL_KIOSK_MY_PROFILE' => 'Min profil',
    'LBL_KIOSK_NAME' => 'Namn',
    'LBL_KIOSK_OFFICE_PHONE' => 'Kontorstelefon',
    'LBL_KIOSK_ORGANIZATION' => 'Organisation',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'Rader per sida:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'Drivs av SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'Spara ändringar',
    'LBL_KIOSK_SHOW_HIDE' => 'Visa/Dölj',
    'LBL_KIOSK_SIGN_IN' => 'Logga In',
    'LBL_KIOSK_SIGN_OUT' => 'Logga ut',
    'LBL_KIOSK_SORT_BY' => 'Sortera efter',
    'LBL_KIOSK_SUBMIT' => 'Skicka in',
    'LBL_KIOSK_TIMEZONE' => 'Tidszon',
    'LBL_KIOSK_ACTIVITY' => 'Aktivitet',
    'LBL_KIOSK_NO_ACTIVITY' => 'Ingen aktivitet att visa',
    'LBL_KIOSK_OLDEST_FIRST' => 'Äldsta först',
    'LBL_KIOSK_NEWEST_FIRST' => 'Nyaste först',
    'LBL_KIOSK_SHOW_MORE' => 'Visa mer',
    'LBL_KIOSK_ADD_A_REPLY' => 'Lägg till ett svar',
    'LBL_KIOSK_REPLY_EMPTY' => 'Svaret kan inte lämnas tomt.',
    'LBL_KIOSK_NUM_MORE' => '{{num}} fler',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'Välkommen',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'Få snabb åtkomst till dina resurser.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'Sök ärenden',
    'LBL_KIOSK_SHOW_ALL' => 'Visa alla',
    'LBL_KIOSK_404_TITLE' => 'Vi hittade inte detta',
    'LBL_KIOSK_TENANT_404_TITLE' => 'Innehavare hittades inte',
    'LBL_KIOSK_404_MESSAGE' => 'Du har klickat på en länk som har tagits bort, är tillfälligt otillgänglig eller så har du angett en ogiltig webbadress.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'Se till att du har rätt URL. Kontakta supporten om du vill ha mer hjälp.',
    'LBL_KIOSK_BACK_TO_HOME' => 'Tillbaka till start',
    'LBL_KIOSK_ERROR_CODE' => '{code} Fel: ',
    'LBL_KIOSK_401_TITLE' => 'Obehörig',
    'LBL_KIOSK_401_MESSAGE' => 'Du är inte behörig att visa denna sida.',
    'LBL_KIOSK_403_TITLE' => 'Obehörig',
    'LBL_KIOSK_403_MESSAGE' => 'Du har inte åtkomst till att visa denna sida.',
    'LBL_KIOSK_500_TITLE' => 'Servern svarar inte',
    'LBL_KIOSK_500_MESSAGE' => 'Det uppstod ett fel hos oss.',
    'LBL_KIOSK_GO_BACK' => 'Gå tillbaka',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'Dublettpost hittades',
    'LBL_KIOSK_ACCOUNT' => 'Konto',
    'LBL_KIOSK_STATUS' => 'Status',
    'LBL_KIOSK_DEACTIVATE' => 'Inaktivera',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'Användaren har inaktiverats',
    'LBL_KIOSK_MANAGE_USERS' => 'Hantera användare',
    'LBL_KIOSK_LAST_LOGIN' => 'Senaste inloggning',
    'LBL_KIOSK_FIRST_NAME' => 'Förnamn',
    'LBL_KIOSK_LAST_NAME' => 'Efternamn',
    'LBL_KIOSK_ROLE' => 'Roll',
    'LBL_KIOSK_INVITE' => 'Inbjudan',
    'LBL_KIOSK_SEND_INVITES' => 'Skicka inbjudning(ar)',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'Inbjudning(ar) har skickats',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'Inbjudning(ar) skickades inte',
    'LBL_KIOSK_REACTIVATE' => 'Återaktivera',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'Användaren har återaktiverats',
    'LBL_KIOSK_RESET_PASSWORD' => 'Återställ lösenord',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'E-postmeddelande om återställning av lösenord har skickats',
    'LBL_KIOSK_USER_PROFILE' => 'Användarprofil',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'Din användare har inaktiverats. Kontakta din administratör.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'Tillbaka till inloggning',
    'LBL_KIOSK_REVOKE_INVITATION' => 'Återkalla inbjudan',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'Inbjudan har återkallats',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'Sök och välj...',
    'LBL_KIOSK_NO_MATCHES' => 'Inga träffar hittades',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'Profilen har uppdaterats.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'Fel vid uppdatering av profil.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'Dokument',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'Visa, sök och ladda ner dina inkommande delade dokument.',
    'LBL_KIOSK_CASES' => 'Ärenden',
    'LBL_KIOSK_CASES_DESC' => 'Visa, sök och svara på ärenden som delas med dig.',
    'LBL_KIOSK_DOWNLOAD' => 'Ladda ner',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'Filen har laddats ner',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'Komma igång',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'Ange ditt för- och efternamn så att vi kan ge dig bättre hjälp.',
    'LBL_KIOSK_SAVE' => 'Spara',
    'LBL_KIOSK_SHARED' => 'Delad',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'Välkommen, {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'Bakgrundsfärg',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'URL till bakgrundsbild',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'Det rekommenderas att välja en bild med en filstorlek som är mindre än 400K.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'Bakgrundstyp',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'Bakgrund på startsida',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'Tema',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'Primär temafärg',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'Appnamn',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'Detta är titeln på din applikation och visas bredvid din logotyp.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'URL till applogotyp',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'Vi rekommenderar att du väljer en logotyp som är anpassad efter små storlekar (t.ex. profiler i sociala medier). Därutöver bör filstorleken vara mindre än 200 kB.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'URL till app-favoritikon',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'En favoritikon är en liten logotyp intill sidtiteln på en webbläsarflik.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'Tilldela öppna aktiviteter automatiskt',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'Användargränsen har nåtts',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'Ogiltig licenstyp',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'Ogiltig applikation',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'Ogiltig applikation',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'Korrupt valideringsnyckel',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'Licensen har upphört att gälla',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'Information saknas',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'Valideringsnyckel saknas',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'Åtkomst för användare saknas',
    'LBL_DRI_WORKFLOW' => 'Smart Guide',
    'LBL_DRI_WORKFLOWS' => 'Smart Guider',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Smart Guide etappmall',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Smart Guide etappmallar',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Smart Guide mall',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Smart Guide Aktivitetsmallar',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'Mall för aktivitet',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'Webhook',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Webhook',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'Aktuell aktivitet i Smart Guide på',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Web Hooks',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate Webhook',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar-åtgärder',
    'LBL_CJ_FORMS' => 'Sugar-åtgärder i Smart Guide',
    'LBL_CJ_FORM' => 'Sugar-åtgärd i Smart Guide',
    'LBL_DRI_SUBWORKFLOW' => 'Smart Guide etapp',
    'LBL_DRI_SUBWORKFLOWS' => 'Smart Guide etapper',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Smart Guide aktivitetsmallar',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Smart Guide mallar',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Smart Guide order',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Smart Guide faktisk order',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Smart Guide poäng',
    'LBL_CJ_MOMENTUM_POINTS' => 'Smart Guide Momentumpoäng',
    'LBL_CJ_MOMENTUM_SCORE' => 'Smart Guide Momentumpoäng',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Smart Guide Tillåt aktivitet av',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Smart Guide Progress',
    'LBL_CJ_MOMENTUM_RATIO' => 'Smart Guide Momentum Ratio',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Smart Guide Poäng',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Smart Guide uppgift',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Smart Guide överordnad aktivitetstyp',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Smart Guide blockerad av',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'Smart Guide blockerad av etapper',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Smart Guide överordnad aktivitets-Id',
    'LBL_START_NEXT_JOURNEY_ID' => 'Starta nästa Smart Guide Id',
    'LBL_CJ_URL' => 'Smart Guide url',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Är Smart Guide överordnad aktivitet',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Smart Guide Startdatum för Momentum',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Smart Guide slutdatum för Momentum',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'Widget Layoutkonfiguration',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'Widget Layoutkonfiguration',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'Maximalt antal Smart Guider från samma mall',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'Aktiv',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'Arkiverad',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'Visa',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'Dölj',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'Vertikalt läge',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'Horisontellt läge',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ogiltig licens',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} har tilldelat följande aktiviteter i Smart Guid till {{assigned_user}}.</p>
    <ul>{{activities}}</ul>
    
    <p>Du kan granska dessa aktiviteter på:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ogiltig licens',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'Användargränsen har uppnåtts, du har {{gracePeriodDays}} dagar på dig att uppgradera licensen.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - Tilldelade Smart Guide-aktiviteter',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Din Sugar Automate-användargräns på {0} har överskridits<br>
    <br>
    Kontakta <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> för att höja användargränsen eller minska antalet användare som använder plugin-programmet.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate användargräns uppnådd',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Din Sugar Automate-licens upphör att gälla om {0} dagar. <br>
    <br>
    Kontakta SugarCRM eller din Sugar-partner för att förnya och förhindra avbrott i tjänsten.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate-licensen är på väg att löpa ut',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'Testa Webhook',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide Progress',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Visar Sugar Automate "Smart Guide Progress"-cirkeldiagrammet.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'Visar Webhook-svaret',
    'LBL_DASHLET_SEND_LABEL' => 'Skicka förfrågan',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'Tilldela till',
    'LBL_COMPLETE_BUTTON_TITLE' => 'Slutför',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'Slutför alla uppgifter',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'Radera etapp',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'Start',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'Inte tillämplig',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'Lägg till etapp',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'Visa',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Redigera Smart Guide',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'Avbryt',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'Arkiv',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'Arkivera inte',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'Konfigurera mall',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'Lägg till uppgift',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'Schemalägg möte',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'Schemalägg telefonsamtal',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'är i framtiden',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'är försenad',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'är idag',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'är imorgon',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'Är du säker på att du vill avbryta den här Smart Guide?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'Du håller på att slutföra alla uppgifter. Är du säker på att du vill fortsätta?',
    'LBL_CJ_BLOCK_BY' => 'Du har en olöst, beroende uppgift: {{Name}}. Slutför denna uppgift innan du slutför alla uppgifter.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'Du har flera olösta, beroende uppgifter. Slutför dessa uppgifter innan du slutför alla uppgifter.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'Du har slutfört alla uppgifter',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'Är du säker på att du vill arkivera den här Smarta Guide?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'Är du säker på att du vill icke arkivera den här Smart Guide?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Smarta guider (fokus drawers och konsol)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'Visa aktiva smarta guider på instrumentpanelerna för service-/förnyelsekonsolen och focus drawer.',
    'LBL_CJ_PROCESSING_REQUEST' => 'Bearbetar..',
    'LBL_CJ_SUCCESS' => 'Du har slutfört alla uppgifter',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module} modulen är inte aktiverad',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'Alla skärminställningar sparas.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Momentum för Smart Guide',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Visar Sugar Automate \\"Smart Guide Progress\\". gauge chart.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide Progress',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Visar cirkeldiagrammet Sugar Automate "Smart Guide Progress".',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'Kunde inte hitta överordnande',
    'CJ_NOT_FOUND_EXCEPTION' => 'Kunde inte hitta {moduleName} med {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'Smart Guide måste fyllas i eller avbrytas innan arkivering',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate är inte aktiverat i nuvarande Sugar Licens',
    'LBL_ACTION_NOT_FOUND' => 'Åtgärd hittades inte, kontakta systemadministratören',
    'LBL_CJ_SELECT_FIELD' => 'Välj fält',
    'LBL_CJ_SELECT_OPERATOR' => 'Välj operatör',
    'LBL_CJ_SELECT_VALUE' => 'Välj värde',
    'LBL_CJ_ENTER_VALUE' => 'Ange värde',
    'LBL_CJ_FORM_BATCH_TITLE' => 'Sparar post',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'Aktiva smarta guider har upptäckts...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'Bearbetar aktiva sugar-åtgärder...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'Uppdaterar aktiva smarta guider...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'Posten och tillhörande smart guides har uppdaterats.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'En tillhörande smart guide uppdaterades inte. Kontakta din Sugar-administratör för hjälp om problemet kvarstår.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'En tillhörande smart guide uppdaterades inte. Granska <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">loggarna</a> för att felsöka felet.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => '<a href="#{{module}}/{{id}}">{{name}}</a>{{moduleSingularLower}} har kopplats.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'Det gick inte att koppla <a href="#{{module}}/{{id}}">{{name}}</a>{{moduleSingularLower}}. Kontakta Sugar-supporten om felet kvarstår.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => '{{modulePluralLower}} har kopplats.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'Det gick inte att koppla {{modulePluralLower}}. Kontakta Sugar-supporten om felet kvarstår.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'Det gick inte att koppla {{moduleSingularLower}}. Kontakta Sugar-supporten om felet kvarstår.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'Det finns redan en {{moduleSingularLower}} med namnet <a href="#{{module}}/{{id}}">{{name}}</a> i {{stage}}-etappen.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'En {{moduleSingularLower}} med namnet <a href="#{{module}}/{{id}}">{{name}}</a> har redan valts.',
    'LBL_CJ_ARCHIVED' => 'Arkiverad',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Välj Smart Guide-mall...',
    'LBL_ALL_SMART_GUIDES' => 'Alla Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => 'Aktiva Smart Guides',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Arkiverade Smart Guides',
    'LBL_VERTICAL_SCROLL_VIEW' => 'Vertikalt staplad vy',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'Horisontell rullningsvy',
    'LBL_DRI_WORKFLOWS_FILTER' => 'Filter',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'Den här åtgärden kan inte slutföras. Statusfältet för denna aktivitetsmodul är inställt på "skrivskyddad", vilket förhindrar alla Smart Guide-åtgärder som uppdaterar statusfältet.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'Den här åtgärden kan inte slutföras. Statusfältet för denna aktivitets- och/eller underaktivitetsmodul är inställt på "skrivskyddad", vilket förhindrar alla Smart Guide-åtgärder som uppdaterar statusfältet.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'Statusfältet för vissa aktiviteters moduler i guiden är inställt på "skrivskyddad", dessa aktiviteter kommer att förbli oförändrade när guiden avbryts.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'Kopierad till urklipp.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'Radera alla upprepningar',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'Ogiltiga upprepningsinställningar',
    'ERROR_INTERVAL_INVALID' => 'Upprepningsintervall måste vara mellan 1 och 99',
    'LBL_RECURRENCE_ADD' => 'Konfigurera',
    'LBL_REPEAT_DAYS' => 'Dag(ar) per månad',
    'LBL_REPEAT_END_TYPES' => 'Upprepa',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'Navigeringsleverantör',
    'LBL_MOBILE_PDF_EMAIL' => 'E-posta {{{pdfTemplateName}}}-PDF',
    'LBL_MOBILE_EMAIL_SENDING' => 'Skickar',
    'LBL_MOBILE_EMAIL_SENT' => 'Skickad',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'E-post har sparats som utkast.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'Lägg till bilaga',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'Ladda upp från lokalt',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar-dokument',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'En redigering du gjorde i denna post har ändrat vyn.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'Versionsmeddelanden för SugarCRM Mobile-app',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'Användarguide för SugarCRM Mobile-app',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile kan inte användas på en rotad mobil enhet. Öppna appen på en orotad enhet.',
    'LBL_VO_BUILD_ROUTE' => 'Skapa rutt',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'Mitt distansfilter',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'Dokumentet kommer att skapas i bakgrunden. Öppna sidan Dokumentsammanslagningar för att få åtkomst till filen.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'Kunde inte hämta mallen. Kontakta din administratör för att få hjälp.',
    'LBL_MAP_ERROR_LOAD' => 'Kan inte läsa in karta',
    'LBL_MAP_DISTANCE' => 'Distans',
    'LBL_SELECT_UNIT_TYPE' => 'Enhetstyp',
    'LBL_MAPS_UNIT_MILES' => 'Mil',
    'LBL_MAPS_UNIT_KILOMETERS' => 'Kilometer',
    'LBL_RADIUS' => 'Radie',
    'LBL_ZIP_CODE' => 'Postnummer',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'Välj adress',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'Kan inte skapa geokod från adress:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'Posten har inte geokodats.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'Posten innehåller ingen adressdata. Vill du hitta denna post på kartan manuellt?',
    'LBL_ERR_SHOW_ON_MAP' => 'Kunde inte öppna karta för valda poster.',
    'LBL_ERR_MISSING_ON_MAP' => 'Vissa poster saknar adressdata och visas inte',
    'LBL_MAPS_ROUTE' => 'Dirigera',
    'LBL_MAPS_PROVIDER' => 'Sugar Maps',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'Kunde inte bestämma aktuell plats.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'Högst {{{num}}} poster stöds för kartläggning.',
    'LBL_ALL_MODULES' => 'Alla moduler',
    'LBL_DRIVE_SHARE_LINK' => 'Dela en länk',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'Kunde inte läsa in filer.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'Namn måste fyllas i',
    'LBL_DRIVE_FOLDER_CREATED' => 'Mappen har skapats.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'Kunde inte skapa en mapp.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'Kunde inte ladda upp en fil.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'Skapa en rotmapp först',
    'LBL_EDIT_ALL_RECURRENCES' => 'Redigera alla upprepningar',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'Det går inte att öppna filen i Dropbox',
    'LBL_FILE_NOT_AVAILABLE' => 'Det går inte att öppna filen',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'Anvisningar',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'Ingen rutt hittades för de vägpunkter som angetts',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'I närheten',
    'LBL_TAGS' => 'Taggar',

    'LBL_CALLER_ID_SETTINGS' => 'Inställningar för nummerpresentatör',
    'LBL_CALLER_ID_ENABLED' => 'Nummerpresentatör har aktiverats',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'Vid inkommande samtal visas namnet på kontakten eller ett lead som matchar telefonnumret.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'Om du vill att mobilappen ska visa nummerpresentatörer följer du dessa steg på din enhet:<br><br>1. Öppna iOS-inställningarna > Telefon > Samtalsblockering och identifiering.<br>2. Aktivera "{{{brandName}}}".',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'Om du vill att mobilappen ska visa nummerpresentatörer följer du dessa steg på din enhet:<br>1. Öppna appinställningarna.<br>2. Gå till Behörigheter.<br>3. Aktivera behörigheten Telefon.<br><br> Om du vill ange detta program som standardhanterare av nummerpresentatör går du till dina enhetsinställningar.<br>1. Navigera till Appar.<br>2. Välj standardappar.<br>3. Välj appen Nummerpresentatör och skräppost.<br>4. Välj detta program som standardalternativ.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Kolla efter ändringar i kontaktinformation i poster (t.ex. Kontakter, Leads) i din Sugar-instans.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'Gå till Inställningar',
    'LBL_CALLER_ID_SYNC' => 'Synkronisera postdata',
    'LBL_CALLER_ID_NOT_ENABLED' => 'Nummerpresentatör måste aktiveras i systeminställningarna innan synkronisering.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'Aktivera',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'Senare i inställningarna',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'Detta program stöder funktionen Nummerpresentatör.<br> För att denna funktion ska fungera korrekt kommer du att uppmanas att bevilja två behörigheter när du har tryckt på aktiveringsknappen.<br> För att säkerställa att funktionen Nummerpresentatör fungerar korrekt måste du bevilja behörighet att hantera samtal och välja detta program som standardhanterare av Nummerpresentatör.<br> Om du inte beviljar behörigheten att hantera samtal kommer du inte heller kunna logga samtal som görs från programmet.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'Om du vill att SugarCRM-mobilappen ska visa nummerpresentatörer följer du dessa steg på din enhet:<br><br>1. Öppna iOS-inställningarna > Telefon > Samtalsblockering och identifiering.<br>2. Aktivera app.',
    'LBL_MOBILE_LAST_SYNC' => 'Senaste synkronisering',
    'LBL_CALLER_ID_SYNCING' => 'Synkroniserar med servern.',
    'LBL_NEVER' => 'Aldrig',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} måste fyllas i.',
    'LBL_ADD_RELATED_RECORD' => 'Relaterad {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => 'Du har inte de behörigheter som krävs för att använda nummerpresentatör. Kontakta din administratör.',
    'LBL_CALLER_ID_FETCHING' => 'Synkroniserar…',
    'LBL_CALLER_ID_FETCH_ALL' => 'Synkronisera alla poster igen',
    'LBL_CALLER_ID_FETCH_NEW' => 'Sök efter postuppdateringar',

    'LBL_SORT_BY' => 'Sortera efter',
    'LBL_PRIMARY_SORT' => 'Primär sortering',
    'LBL_SECONDARY_SORT' => 'Sekundär sortering',
    'LBL_OF' => 'av',
    'LBL_TABLE_FREEZE_FIRST' => 'Frys första kolumnen',
    'LBL_TABLE_SETTINGS_TITLE' => 'Alternativ för kolumnvy',
    'LBL_TABLE_SETTINGS_NO_COL' => 'Minst en kolumn måste väljas.',
    'LBL_TABLE_TOGGLER_INFO' => 'Visa eller dölj kolumner och dra dem till din önskade ordning.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'Filter för körningstid',
    'LBL_FILTER_CONDITION' => 'Välj villkor',
    'LBL_FILTER_VALUES' => 'Värden',
    'LBL_TABLE_EXPAND' => 'Utöka alla',
    'LBL_TABLE_COLLAPSE' => 'Dra ihop alla',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'Serverfel. Det gick inte att läsa in relevanta filter för körningstid.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Push-prenumerationer för pub-/sub-modulhändelse',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Push-prenumeration för pub-/sub-modulhändelse',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'Panel - Överst',
    'panel_bottom' => 'Panel - Nederst',
    'tab_first' => 'Flik - Först',
    'tab_last' => 'Flik - Sist',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'Senaste 7 dagarna',
    '30' => 'Senaste 30 dagarna',
    '90' => 'Senaste kvartalet',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'Idag',
    'future' => 'Framtiden',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nej',
];

$app_list_strings['history_filter_options'] = [
    7 => 'Senaste 7 dagarna',
    30 => 'Senaste 30 dagarna',
    90 => 'Senaste kvartalet',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nej',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nej',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'Ja',
    '0' => 'Nej',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'Det här kvartalet',
    'next' => 'Nästa kvartal',
    'year' => 'Det här året',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'Mina poster',
    'group' => 'Grupposter',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'Min pipeline',
    'group' => 'Mitt Teams Pipeline',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'Min Prognos',
    'group' => 'Mitt teams prognos',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'Affärsmöjligheter',
    'RevenueLineItems' => 'Affärsmöjligheter och Intäktsposter',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'Senaste avslutsdatumet',
    'earliest' => 'Tidigaste avslutsdatumet',
];

$app_list_strings['moduleList']['Library'] = 'Bibliotek';
$app_list_strings['moduleListSingular']['Library'] = 'Bibliotek';
$app_list_strings['library_type'] = ['Books' => 'Bok', 'Music' => 'Musik', 'DVD' => 'DVD', 'Magazines' => 'Tidningar'];
$app_list_strings['moduleList']['EmailAddresses'] = 'Emailadress';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'Emailadress';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'Utkast',
    'in-review' => 'Under granskning',
    'approved' => 'Godkänd',
    'published' => 'Publicerat',
    'expired' => 'Utgången',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--Admin funktioner--',
        'Create New Tag' => 'Skapa en ny märkning',
        'Delete Tag' => 'Radera märkning',
        'Rename Tag' => 'Döp om märkning',
        'Move Selected Articles' => 'Flytta valda artiklar',
        'Apply Tags On Articles' => 'Applicera märkning på artiklar',
        'Delete Selected Articles' => 'Radera valda artiklar',
    ];

$app_list_strings['moduleList']['Words'] = 'Ord';
$app_list_strings['moduleListSingular']['Words'] = 'Ord';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Skapa artikel';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DHABI',
    'ADEN' => 'ADEN',
    'AFGHANISTAN' => 'AFGHANISTAN',
    'ALBANIA' => 'ALBANIA',
    'ALGERIA' => 'ALGERIA',
    'AMERICAN SAMOA' => 'AMERICAN SAMOA',
    'ANDORRA' => 'ANDORRA',
    'ANGOLA' => 'ANGOLA',
    'ANTARCTICA' => 'ANTARCTICA',
    'ANTIGUA' => 'ANTIGUA',
    'ARGENTINA' => 'ARGENTINA',
    'ARMENIA' => 'ARMENIA',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => 'AUSTRALIA',
    'AUSTRIA' => 'AUSTRIA',
    'AZERBAIJAN' => 'AZERBAIJAN',
    'BAHAMAS' => 'BAHAMAS',
    'BAHRAIN' => 'BAHRAIN',
    'BANGLADESH' => 'BANGLADESH',
    'BARBADOS' => 'BARBADOS',
    'BELARUS' => 'VITRYSSLAND',
    'BELGIUM' => 'BELGIEN',
    'BELIZE' => 'BELIZE',
    'BENIN' => 'BENIN',
    'BERMUDA' => 'BERMUDA',
    'BHUTAN' => 'BHUTAN',
    'BOLIVIA' => 'BOLIVIA',
    'BOSNIA' => 'BOSNIEN',
    'BOTSWANA' => 'BOTSWANA',
    'BOUVET ISLAND' => 'BOUVETÖN',
    'BRAZIL' => 'BRASILIEN',
    'BRITISH ANTARCTICA TERRITORY' => 'BRITTISKA TERRITORIET I ANTARKTIS',
    'BRITISH INDIAN OCEAN TERRITORY' => 'BRITTISKA INDISKA OCEANÖARNA',
    'BRITISH VIRGIN ISLANDS' => 'BRITTISKA JUNGFRUÖARNA',
    'BRITISH WEST INDIES' => 'BRITTISKA VÄSTINDIEN',
    'BRUNEI' => 'BRUNEI',
    'BULGARIA' => 'BULGARIEN',
    'BURKINA FASO' => 'BURKINA FASO',
    'BURUNDI' => 'BURUNDI',
    'CAMBODIA' => 'KAMBODJA',
    'CAMEROON' => 'KAMERUN',
    'CANADA' => 'KANADA',
    'CANAL ZONE' => 'KANALZONEN',
    'CANARY ISLAND' => 'KANARIEÖARNA',
    'CAPE VERDI ISLANDS' => 'KAP VERDIÖARNA',
    'CAYMAN ISLANDS' => 'CAYMANÖARNA',
    'CEVLON' => 'CEYLON',
    'CHAD' => 'CHAD',
    'CHANNEL ISLAND UK' => 'KANALÖN UK',
    'CHILE' => 'CHILE',
    'CHINA' => 'KINA',
    'CHRISTMAS ISLAND' => 'JULÖN',
    'COCOS (KEELING) ISLAND' => 'COCOS (KEELING)-ÖN',
    'COLOMBIA' => 'COLOMBIA',
    'COMORO ISLANDS' => 'KOMORERNA',
    'CONGO' => 'CONGO',
    'CONGO KINSHASA' => 'KONGO-KINSHASA',
    'COOK ISLANDS' => 'COOKÖARNA',
    'COSTA RICA' => 'COSTA RICA',
    'CROATIA' => 'KROATIEN',
    'CUBA' => 'KUBA',
    'CURACAO' => 'CURACAO',
    'CYPRUS' => 'CYPERN',
    'CZECH REPUBLIC' => 'TJECKIEN',
    'DAHOMEY' => 'DAHOMEY',
    'DENMARK' => 'DANMARK',
    'DJIBOUTI' => 'DJIBOUTI',
    'DOMINICA' => 'DOMINICA',
    'DOMINICAN REPUBLIC' => 'DOMINIKANSKA REPUBLIKEN',
    'DUBAI' => 'DUBAI',
    'ECUADOR' => 'ECUADOR',
    'EGYPT' => 'EGYPTEN',
    'EL SALVADOR' => 'EL SALVADOR',
    'EQUATORIAL GUINEA' => 'EKVATORIALA GUINEA',
    'ESTONIA' => 'ESTLAND',
    'ETHIOPIA' => 'ETHIOPIEN',
    'FAEROE ISLANDS' => 'FÄRÖARNA',
    'FALKLAND ISLANDS' => 'FALKLANDSÖARNA',
    'FIJI' => 'FIJI',
    'FINLAND' => 'FINLAND',
    'FRANCE' => 'FRANKRIKE',
    'FRENCH GUIANA' => 'FRANSKA GUYANA',
    'FRENCH POLYNESIA' => 'FRANSKA POLYNESIEN',
    'GABON' => 'GABON',
    'GAMBIA' => 'GAMBIA',
    'GEORGIA' => 'GEORGIEN',
    'GERMANY' => 'TYSKLAND',
    'GHANA' => 'GHANA',
    'GIBRALTAR' => 'GIBRALTAR',
    'GREECE' => 'GREKLAND',
    'GREENLAND' => 'GRÖNLAND',
    'GUADELOUPE' => 'GUADELOUPE',
    'GUAM' => 'GUAM',
    'GUATEMALA' => 'GUATEMALA',
    'GUINEA' => 'GUINEA',
    'GUYANA' => 'GUYANA',
    'HAITI' => 'HAITI',
    'HONDURAS' => 'HONDURAS',
    'HONG KONG' => 'HONGKONG',
    'HUNGARY' => 'UNGERN',
    'ICELAND' => 'ISLAND',
    'IFNI' => 'IFNI',
    'INDIA' => 'INDIEN',
    'INDONESIA' => 'INDONESIEN',
    'IRAN' => 'IRAN',
    'IRAQ' => 'IRAQ',
    'IRELAND' => 'IRLAND',
    'ISRAEL' => 'ISRAEL',
    'ITALY' => 'ITALIEN',
    'IVORY COAST' => 'ELFENBENSKUSTEN',
    'JAMAICA' => 'JAMAICA',
    'JAPAN' => 'JAPAN',
    'JORDAN' => 'JORDANIEN',
    'KAZAKHSTAN' => 'KAZAKSTAN',
    'KENYA' => 'KENYA',
    'KOREA' => 'KOREA',
    'KOREA, SOUTH' => 'KOREA, SYD',
    'KUWAIT' => 'KUWAIT',
    'KYRGYZSTAN' => 'KIRGIZISTAN',
    'LAOS' => 'LAOS',
    'LATVIA' => 'LETTAND',
    'LEBANON' => 'LIBANON',
    'LEEWARD ISLANDS' => 'LEEWARDÖARNA',
    'LESOTHO' => 'LESOTHO',
    'LIBYA' => 'LIBYEN',
    'LIECHTENSTEIN' => 'LIECHTENSTEIN',
    'LITHUANIA' => 'LITAUEN',
    'LUXEMBOURG' => 'LUXEMBURG',
    'MACAO' => 'MACAO',
    'MACEDONIA' => 'MAKEDONIEN',
    'MADAGASCAR' => 'MADAGASKAR',
    'MALAWI' => 'MALAWI',
    'MALAYSIA' => 'MALAYSIA',
    'MALDIVES' => 'MALDIVERNA',
    'MALI' => 'MALI',
    'MALTA' => 'MALTA',
    'MARTINIQUE' => 'MARTINIQUE',
    'MAURITANIA' => 'MAURETANIEN',
    'MAURITIUS' => 'MAURITIUS',
    'MELANESIA' => 'MELANESIEN',
    'MEXICO' => 'MEXIKO',
    'MOLDOVIA' => 'MOLDAVIEN',
    'MONACO' => 'MONACO',
    'MONGOLIA' => 'MONGOLIET',
    'MOROCCO' => 'MAROCKO',
    'MOZAMBIQUE' => 'MOÇAMBIQUE',
    'MYANAMAR' => 'MYANAMAR',
    'NAMIBIA' => 'NAMIBIA',
    'NEPAL' => 'NEPAL',
    'NETHERLANDS' => 'NEDERLÄNDERNA',
    'NETHERLANDS ANTILLES' => 'NEDERLÄNDSKA ANTILLERNA',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'NEDERLÄNDSKA ANTILLERNA, NEUTRALA ZONEN',
    'NEW CALADONIA' => 'NYA KALEDONIEN',
    'NEW HEBRIDES' => 'NYA HEBRIDERNA',
    'NEW ZEALAND' => 'NYA ZEELAND',
    'NICARAGUA' => 'NICARAGUA',
    'NIGER' => 'NIGER',
    'NIGERIA' => 'NIGERIA',
    'NORFOLK ISLAND' => 'NORFOLKÖN',
    'NORWAY' => 'NORGE',
    'OMAN' => 'OMAN',
    'OTHER' => 'ANNAT',
    'PACIFIC ISLAND' => 'STILLAHAVSÖARNA',
    'PAKISTAN' => 'PAKISTAN',
    'PANAMA' => 'PANAMA',
    'PAPUA NEW GUINEA' => 'PAPUA NYA GUINEA',
    'PARAGUAY' => 'PARAGUAY',
    'PERU' => 'PERU',
    'PHILIPPINES' => 'FILIPPINERNA',
    'POLAND' => 'POLEN',
    'PORTUGAL' => 'PORTUGAL',
    'PORTUGUESE TIMOR' => 'PORTUGISISKA TIMOR',
    'PUERTO RICO' => 'PUERTO RICO',
    'QATAR' => 'QATAR',
    'REPUBLIC OF BELARUS' => 'VITRYSSLAND',
    'REPUBLIC OF SOUTH AFRICA' => 'SYDAFRIKA',
    'REUNION' => 'REUNION',
    'ROMANIA' => 'RUMÄNIEN',
    'RUSSIA' => 'RYSSLAND',
    'RWANDA' => 'RWANDA',
    'RYUKYU ISLANDS' => 'RYUKYUÖARNA',
    'SABAH' => 'SABAH',
    'SAN MARINO' => 'SAN MARINO',
    'SAUDI ARABIA' => 'SAUDIARABIEN',
    'SENEGAL' => 'SENEGAL',
    'SERBIA' => 'SERBIEN',
    'SEYCHELLES' => 'SEYCHELLERNA',
    'SIERRA LEONE' => 'SIERRA LEONE',
    'SINGAPORE' => 'SINGAPORE',
    'SLOVAKIA' => 'SLOVAKIEN',
    'SLOVENIA' => 'SLOVENIEN',
    'SOMALILIAND' => 'SOMALILAND',
    'SOUTH AFRICA' => 'SYDAFRIKA',
    'SOUTH YEMEN' => 'SÖDRA YEMEN',
    'SPAIN' => 'SPANIEN',
    'SPANISH SAHARA' => 'SPANSKA SAHARA',
    'SRI LANKA' => 'SRI LANKA',
    'ST. KITTS AND NEVIS' => 'ST KITTS OCH NEVIS',
    'ST. LUCIA' => 'ST. LUCIA',
    'SUDAN' => 'SUDAN',
    'SURINAM' => 'SURINAM',
    'SW AFRICA' => 'SW AFRIKA',
    'SWAZILAND' => 'SWAZILAND',
    'SWEDEN' => 'SVERIGE',
    'SWITZERLAND' => 'SCHWEIZ',
    'SYRIA' => 'SYRIEN',
    'TAIWAN' => 'TAIWAN',
    'TAJIKISTAN' => 'TADZJIKISTAN',
    'TANZANIA' => 'TANZANIA',
    'THAILAND' => 'THAILAND',
    'TONGA' => 'TONGA',
    'TRINIDAD' => 'TRINIDAD',
    'TUNISIA' => 'TUNISIEN',
    'TURKEY' => 'TURKIET',
    'UGANDA' => 'UGANDA',
    'UKRAINE' => 'UKRAINA',
    'UNITED ARAB EMIRATES' => 'FÖRENADE ARABEMIRATEN',
    'UNITED KINGDOM' => 'STORBRITANNIEN',
    'UPPER VOLTA' => 'ÖVRE VOLTA',
    'URUGUAY' => 'URUGUAY',
    'US PACIFIC ISLAND' => 'AMERIKANSKA STILLAHAVSÖARNA',
    'US VIRGIN ISLANDS' => 'AMERIKANSKA JUNGFRUÖARNA',
    'USA' => 'USA',
    'UZBEKISTAN' => 'UZBEKISTAN',
    'VANUATU' => 'VANUATU',
    'VATICAN CITY' => 'VATIKANSTATEN',
    'VENEZUELA' => 'VENEZUELA',
    'VIETNAM' => 'VIETNAM',
    'WAKE ISLAND' => 'WAKEÖN',
    'WEST INDIES' => 'VÄSTINDIEN',
    'WESTERN SAHARA' => 'VÄSTSAHARA',
    'YEMEN' => 'YEMEN',
    'ZAIRE' => 'ZAIRE',
    'ZAMBIA' => 'ZAMBIA',
    'ZIMBABWE' => 'ZIMBABWE',
];

$app_list_strings['state_dom'] = [
    'AL' => 'Alabama',
    'AK' => 'Alaska',
    'AZ' => 'Arizona',
    'AR' => 'Arkansas',
    'CA' => 'Kalifornien',
    'CO' => 'Colorado',
    'CT' => 'Connecticut',
    'DE' => 'Delaware',
    'DC' => 'District Of Columbia',
    'FL' => 'Florida',
    'GA' => 'Georgia',
    'HI' => 'Hawaii',
    'ID' => 'Idaho',
    'IL' => 'Illinois',
    'IN' => 'Indiana',
    'IA' => 'Iowa',
    'KS' => 'Kansas',
    'KY' => 'Kentucky',
    'LA' => 'Louisiana',
    'ME' => 'Maine',
    'MD' => 'Maryland',
    'MA' => 'Massachusetts',
    'MI' => 'Michigan',
    'MN' => 'Minnesota',
    'MS' => 'Mississippi',
    'MO' => 'Missouri',
    'MT' => 'Montana',
    'NE' => 'Nebraska',
    'NV' => 'Nevada',
    'NH' => 'New Hampshire',
    'NJ' => 'New Jersey',
    'NM' => 'New Mexico',
    'NY' => 'New York',
    'NC' => 'North Carolina',
    'ND' => 'North Dakota',
    'OH' => 'Ohio',
    'OK' => 'Oklahoma',
    'OR' => 'Oregon',
    'PA' => 'Pennsylvania',
    'RI' => 'Rhode Island',
    'SC' => 'South Carolina',
    'SD' => 'South Dakota',
    'TN' => 'Tennessee',
    'TX' => 'Texas',
    'UT' => 'Utah',
    'VT' => 'Vermont',
    'VA' => 'Virginia',
    'WA' => 'Washington',
    'WV' => 'West Virginia',
    'WI' => 'Wisconsin',
    'WY' => 'Wyoming',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (Taiwan och Hongkong)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS Kyrilliskt)',
    'CP1252' => 'CP1252 (MS Västeuropeiskt & US)',
    'EUC-CN' => 'EUC-CN (Förenklad kinesiska GB2312)',
    'EUC-JP' => 'EUC-JP (Unix Japanskt)',
    'EUC-KR' => 'EUC-KR (Koreanskt)',
    'EUC-TW' => 'EUC-TW (Taiwanesiskt)',
    'ISO-2022-JP' => 'ISO-2022-JP (Japanskt)',
    'ISO-2022-KR' => 'ISO-2022-KR (Koreanskt)',
    'ISO-8859-1' => 'ISO-8859-1 (Västeuropa och US)',
    'ISO-8859-2' => 'ISO-8859-2 (Central- och östeuropeiskt)',
    'ISO-8859-3' => 'ISO-8859-3 (Latinskt 3)',
    'ISO-8859-4' => 'ISO-8859-4 (Latinskt 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Kyrilliskt)',
    'ISO-8859-6' => 'ISO-8859-6 (Arabiskt)',
    'ISO-8859-7' => 'ISO-8859-7 (Grekiskt)',
    'ISO-8859-8' => 'ISO-8859-8 (Hebreiskt)',
    'ISO-8859-9' => 'ISO-8859-9 (Latinskt 5)',
    'ISO-8859-10' => 'ISO-8859-10 (Latinskt 6)',
    'ISO-8859-13' => 'ISO-8859-13 (Latinskt 7)',
    'ISO-8859-14' => 'ISO-8859-14 (Latinskt 8)',
    'ISO-8859-15' => 'ISO-8859-15 (Latinskt 9)',
    'KOI8-R' => 'KOI8-R (Kyrilliskt, Ryskt)',
    'KOI8-U' => 'KOI8-U (Kyrilliskt, Ukrainskt)',
    'SJIS' => 'SJIS (MS Japanskt)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Afrika/Alger',
    'Africa/Luanda' => 'Afrika/Luanda',
    'Africa/Porto-Novo' => 'Afrika/Porto-Novo',
    'Africa/Gaborone' => 'Afrika/Gaborone',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Douala' => 'Afrika/Douala',
    'Atlantic/Cape_Verde' => 'Atlanten/Kap_Verde',
    'Africa/Bangui' => 'Afrika/Bangui',
    'Africa/Ndjamena' => 'Afrika/Ndjamena',
    'Indian/Comoro' => 'Indiska/Komoriska',
    'Africa/Kinshasa' => 'Afrika/Kinshasa',
    'Africa/Lubumbashi' => 'Afrika/Lubumbashi',
    'Africa/Brazzaville' => 'Afrika/Brazzaville',
    'Africa/Abidjan' => 'Afrika/Abidjan',
    'Africa/Djibouti' => 'Afrika/Djibouti',
    'Africa/Cairo' => 'Afrika/Kairo',
    'Africa/Malabo' => 'Afrika/Malabo',
    'Africa/Asmera' => 'Afrika/Asmera',
    'Africa/Addis_Ababa' => 'Afrika/Addis_Ababa',
    'Africa/Libreville' => 'Afrika/Libreville',
    'Africa/Banjul' => 'Afrika/Banjul',
    'Africa/Accra' => 'Afrika/Accra',
    'Africa/Conakry' => 'Afrika/Conakry',
    'Africa/Bissau' => 'Afrika/Bissau',
    'Africa/Nairobi' => 'Afrika/Nairobi',
    'Africa/Maseru' => 'Afrika/Maseru',
    'Africa/Monrovia' => 'Afrika/Monrovia',
    'Africa/Tripoli' => 'Afrika/Tripoli',
    'Indian/Antananarivo' => 'Indiska/Antananarivo',
    'Africa/Blantyre' => 'Afrika/Blantyre',
    'Africa/Bamako' => 'Afrika/Bamako',
    'Africa/Nouakchott' => 'Afrika/Nouakchott',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indiska/Mayotte',
    'Africa/Casablanca' => 'Afrika/Casablanca',
    'Africa/El_Aaiun' => 'Afrika/El_Aaiun',
    'Africa/Maputo' => 'Afrika/Maputo',
    'Africa/Windhoek' => 'Afrika/Windhoek',
    'Africa/Niamey' => 'Afrika/Niamey',
    'Africa/Lagos' => 'Afrika/Lagos',
    'Indian/Reunion' => 'Indiska/Reunion',
    'Africa/Kigali' => 'Afrika/Kigali',
    'Atlantic/St_Helena' => 'Atlanten/St_Helena',
    'Africa/Sao_Tome' => 'Afrika/Sao_Tome',
    'Africa/Dakar' => 'Afrika/Dakar',
    'Indian/Mahe' => 'Indiska/Mahe',
    'Africa/Freetown' => 'Afrika/Freetown',
    'Africa/Mogadishu' => 'Afrika/Mogadishu',
    'Africa/Johannesburg' => 'Afrika/Johannesburg',
    'Africa/Khartoum' => 'Afrika/Khartoum',
    'Africa/Mbabane' => 'Afrika/Mbabane',
    'Africa/Dar_es_Salaam' => 'Afrika/Dar_es_Salaam',
    'Africa/Lome' => 'Afrika/Lome',
    'Africa/Tunis' => 'Afrika/Tunis',
    'Africa/Kampala' => 'Afrika/Kampala',
    'Africa/Lusaka' => 'Afrika/Lusaka',
    'Africa/Harare' => 'Afrika/Harare',
    'Antarctica/Casey' => 'Antarktis/Casey',
    'Antarctica/Davis' => 'Antarktis/Davis',
    'Antarctica/Mawson' => 'Antarktis/Mawson',
    'Indian/Kerguelen' => 'Indiska/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antarktis/DumontDUrville',
    'Antarctica/Syowa' => 'Antarktis/Syowa',
    'Antarctica/Vostok' => 'Antarktis/Vostok',
    'Antarctica/Rothera' => 'Antarktis/Rothera',
    'Antarctica/Palmer' => 'Antarktis/Palmer',
    'Antarctica/McMurdo' => 'Antarktis/McMurdo',
    'Asia/Kabul' => 'Asien/Kabul',
    'Asia/Yerevan' => 'Asien/Yerevan',
    'Asia/Baku' => 'Asien/Baku',
    'Asia/Bahrain' => 'Asien/Bahrain',
    'Asia/Dhaka' => 'Asien/Dhaka',
    'Asia/Thimphu' => 'Asien/Thimphu',
    'Indian/Chagos' => 'Indiska/Chagos',
    'Asia/Brunei' => 'Asien/Brunei',
    'Asia/Rangoon' => 'Asien/Rangoon',
    'Asia/Phnom_Penh' => 'Asien/Phnom_Penh',
    'Asia/Beijing' => 'Asien/Beijing',
    'Asia/Harbin' => 'Asien/Harbin',
    'Asia/Shanghai' => 'Asien/Shanghai',
    'Asia/Chongqing' => 'Asien/Chongqing',
    'Asia/Urumqi' => 'Asien/Urumqi',
    'Asia/Kashgar' => 'Asien/Kashgar',
    'Asia/Hong_Kong' => 'Asien/Hong_Kong',
    'Asia/Taipei' => 'Asien/Taipei',
    'Asia/Macau' => 'Asien/Macau',
    'Asia/Nicosia' => 'Asien/Nicosia',
    'Asia/Tbilisi' => 'Asien/Tbilisi',
    'Asia/Dili' => 'Asien/Dili',
    'Asia/Calcutta' => 'Asien/Calcutta',
    'Asia/Jakarta' => 'Asien/Jakarta',
    'Asia/Pontianak' => 'Asien/Pontianak',
    'Asia/Makassar' => 'Asien/Makassar',
    'Asia/Jayapura' => 'Asien/Jayapura',
    'Asia/Tehran' => 'Asien/Tehran',
    'Asia/Baghdad' => 'Asien/Baghdad',
    'Asia/Jerusalem' => 'Asien/Jerusalem',
    'Asia/Tokyo' => 'Asien/Tokyo',
    'Asia/Amman' => 'Asien/Amman',
    'Asia/Almaty' => 'Asien/Almaty',
    'Asia/Qyzylorda' => 'Asien/Qyzylorda',
    'Asia/Aqtobe' => 'Asien/Aqtobe',
    'Asia/Aqtau' => 'Asien/Aqtau',
    'Asia/Oral' => 'Asien/Oral',
    'Asia/Bishkek' => 'Asien/Bishkek',
    'Asia/Seoul' => 'Asien/Seoul',
    'Asia/Pyongyang' => 'Asien/Pyongyang',
    'Asia/Kuwait' => 'Asien/Kuwait',
    'Asia/Vientiane' => 'Asien/Vientiane',
    'Asia/Beirut' => 'Asien/Beirut',
    'Asia/Kuala_Lumpur' => 'Asien/Kuala_Lumpur',
    'Asia/Kuching' => 'Asien/Kuching',
    'Indian/Maldives' => 'Indiska/Maldives',
    'Asia/Hovd' => 'Asien/Hovd',
    'Asia/Ulaanbaatar' => 'Asien/Ulan-bator',
    'Asia/Choibalsan' => 'Asien/Choibalsan',
    'Asia/Katmandu' => 'Asien/Katmandu',
    'Asia/Muscat' => 'Asien/Muscat',
    'Asia/Karachi' => 'Asien/Karachi',
    'Asia/Gaza' => 'Asien/Gaza',
    'Asia/Manila' => 'Asien/Manila',
    'Asia/Qatar' => 'Asien/Qatar',
    'Asia/Riyadh' => 'Asien/Riyadh',
    'Asia/Singapore' => 'Asien/Singapore',
    'Asia/Colombo' => 'Asien/Colombo',
    'Asia/Damascus' => 'Asien/Damascus',
    'Asia/Dushanbe' => 'Asien/Dushanbe',
    'Asia/Bangkok' => 'Asien/Bangkok',
    'Asia/Ashgabat' => 'Asien/Ashgabat',
    'Asia/Dubai' => 'Asien/Dubai',
    'Asia/Samarkand' => 'Asien/Samarkand',
    'Asia/Tashkent' => 'Asien/Tashkent',
    'Asia/Saigon' => 'Asien/Saigon',
    'Asia/Aden' => 'Asien/Aden',
    'Australia/Darwin' => 'Australien/Darwin',
    'Australia/Perth' => 'Australien/Perth',
    'Australia/Brisbane' => 'Australien/Brisbane',
    'Australia/Lindeman' => 'Australien/Lindeman',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Hobart' => 'Australien/Hobart',
    'Australia/Currie' => 'Australien/Currie',
    'Australia/Melbourne' => 'Australien/Melbourne',
    'Australia/Sydney' => 'Australien/Sydney',
    'Australia/Broken_Hill' => 'Australien/Broken_Hill',
    'Indian/Christmas' => 'Indiska/Christmas',
    'Pacific/Rarotonga' => 'Stilla havet/Rarotonga',
    'Indian/Cocos' => 'Indiska/Cocos',
    'Pacific/Fiji' => 'Stilla havet/Fiji',
    'Pacific/Gambier' => 'Stilla havet/Gambier',
    'Pacific/Marquesas' => 'Stilla havet/Marquesas',
    'Pacific/Tahiti' => 'Stilla havet/Tahiti',
    'Pacific/Guam' => 'Stilla havet/Guam',
    'Pacific/Tarawa' => 'Stilla havet/Tarawa',
    'Pacific/Enderbury' => 'Stilla havet/Enderbury',
    'Pacific/Kiritimati' => 'Stilla havet/Kiritimati',
    'Pacific/Saipan' => 'Stilla havet/Saipan',
    'Pacific/Majuro' => 'Stilla havet/Majuro',
    'Pacific/Kwajalein' => 'Stilla havet/Kwajalein',
    'Pacific/Truk' => 'Stilla havet/Truk',
    'Pacific/Ponape' => 'Stilla havet/Ponape',
    'Pacific/Kosrae' => 'Stilla havet/Kosrae',
    'Pacific/Nauru' => 'Stilla havet/Nauru',
    'Pacific/Noumea' => 'Stilla havet/Noumea',
    'Pacific/Auckland' => 'Stilla havet/Auckland',
    'Pacific/Chatham' => 'Stilla havet/Chatham',
    'Pacific/Niue' => 'Stilla havet/Niue',
    'Pacific/Norfolk' => 'Stilla havet/Norfolk',
    'Pacific/Palau' => 'Stilla havet/Palau',
    'Pacific/Port_Moresby' => 'Stilla havet/Port_Moresby',
    'Pacific/Pitcairn' => 'Stilla havet/Pitcairn',
    'Pacific/Pago_Pago' => 'Stilla havet/Pago_Pago',
    'Pacific/Apia' => 'Stilla havet/Apia',
    'Pacific/Guadalcanal' => 'Stilla havet/Guadalcanal',
    'Pacific/Fakaofo' => 'Stilla havet/Fakaofo',
    'Pacific/Tongatapu' => 'Stilla havet/Tongatapu',
    'Pacific/Funafuti' => 'Stilla havet/Funafuti',
    'Pacific/Johnston' => 'Stilla havet/Johnston',
    'Pacific/Midway' => 'Stilla havet/Midway',
    'Pacific/Wake' => 'Stilla havet/Wake',
    'Pacific/Efate' => 'Stilla havet/Efate',
    'Pacific/Wallis' => 'Stilla havet/Wallis',
    'Europe/London' => 'Europa/London',
    'Europe/Dublin' => 'Europa/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'EET',
    'Europe/Andorra' => 'Europa/Andorra',
    'Europe/Vienna' => 'Europa/Wien',
    'Europe/Minsk' => 'Europa/Minsk',
    'Europe/Brussels' => 'Europa/Bryssel',
    'Europe/Sofia' => 'Europa/Sofia',
    'Europe/Prague' => 'Europa/Prag',
    'Europe/Copenhagen' => 'Europa/Köpenhamn',
    'Atlantic/Faeroe' => 'Atlanten/Färöarna',
    'America/Danmarkshavn' => 'Amerika/Danmarkshavn',
    'America/Scoresbysund' => 'Amerika/Scoresbysund',
    'America/Godthab' => 'Amerika/Godthab',
    'America/Thule' => 'Amerika/Thule',
    'Europe/Tallinn' => 'Europa/Tallinn',
    'Europe/Helsinki' => 'Europa/Helsinki',
    'Europe/Paris' => 'Europa/Paris',
    'Europe/Berlin' => 'Europa/Berlin',
    'Europe/Gibraltar' => 'Europa/Gibraltar',
    'Europe/Athens' => 'Europa/Aten',
    'Europe/Budapest' => 'Europa/Budapest',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Europe/Rome' => 'Europa/Rom',
    'Europe/Riga' => 'Europa/Riga',
    'Europe/Vaduz' => 'Europa/Vaduz',
    'Europe/Vilnius' => 'Europa/Vilnius',
    'Europe/Luxembourg' => 'Europa/Luxemburg',
    'Europe/Malta' => 'Europa/Malta',
    'Europe/Chisinau' => 'Europa/Chisinau',
    'Europe/Monaco' => 'Europa/Monaco',
    'Europe/Amsterdam' => 'Europa/Amsterdam',
    'Europe/Oslo' => 'Europa/Oslo',
    'Europe/Warsaw' => 'Europa/Warszawa',
    'Europe/Lisbon' => 'Europa/Lissabon',
    'Atlantic/Azores' => 'Atlanten/Azorerna',
    'Atlantic/Madeira' => 'Atlanten/Madeira',
    'Europe/Bucharest' => 'Europa/Bukarest',
    'Europe/Kaliningrad' => 'Europa/Kaliningrad',
    'Europe/Moscow' => 'Europa/Moskva',
    'Europe/Samara' => 'Europa/Samara',
    'Asia/Yekaterinburg' => 'Asien/Yekaterinburg',
    'Asia/Omsk' => 'Asien/Omsk',
    'Asia/Novosibirsk' => 'Asien/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asien/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asien/Irkutsk',
    'Asia/Yakutsk' => 'Asien/Yakutsk',
    'Asia/Vladivostok' => 'Asien/Vladivostok',
    'Asia/Sakhalin' => 'Asien/Sakhalin',
    'Asia/Magadan' => 'Asien/Magadan',
    'Asia/Kamchatka' => 'Asien/Kamchatka',
    'Asia/Anadyr' => 'Asien/Anadyr',
    'Europe/Belgrade' => 'Europa/Belgrad',
    'Europe/Madrid' => 'Europa/Madrid',
    'Africa/Ceuta' => 'Afrika/Ceuta',
    'Atlantic/Canary' => 'Atlanten/Kanarieöarna',
    'Europe/Stockholm' => 'Europa/Stockholm',
    'Europe/Zurich' => 'Europa/Zürich',
    'Europe/Istanbul' => 'Europa/Istanbul',
    'Europe/Kiev' => 'Europa/Kiev',
    'Europe/Uzhgorod' => 'Europa/Uzhgorod',
    'Europe/Zaporozhye' => 'Europa/Zaporozhye',
    'Europe/Simferopol' => 'Europa/Simferopol',
    'America/New_York' => 'Amerika/New_York',
    'America/Chicago' => 'Amerika/Chicago',
    'America/North_Dakota/Center' => 'Amerika/North_Dakota/Center',
    'America/Denver' => 'Amerika/Denver',
    'America/Los_Angeles' => 'Amerika/Los_Angeles',
    'America/Juneau' => 'Amerika/Juneau',
    'America/Yakutat' => 'Amerika/Yakutat',
    'America/Anchorage' => 'Amerika/Anchorage',
    'America/Nome' => 'Amerika/Nome',
    'America/Adak' => 'Amerika/Adak',
    'Pacific/Honolulu' => 'Stilla havet/Honolulu',
    'America/Phoenix' => 'Amerika/Phoenix',
    'America/Boise' => 'Amerika/Boise',
    'America/Indiana/Indianapolis' => 'Amerika/Indiana/Indianapolis',
    'America/Indiana/Marengo' => 'Amerika/Indiana/Marengo',
    'America/Indiana/Knox' => 'Amerika/Indiana/Knox',
    'America/Indiana/Vevay' => 'Amerika/Indiana/Vevay',
    'America/Kentucky/Louisville' => 'Amerika/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'Amerika/Kentucky/Monticello',
    'America/Detroit' => 'Amerika/Detroit',
    'America/Menominee' => 'Amerika/Menominee',
    'America/St_Johns' => 'Amerika/St_Johns',
    'America/Goose_Bay' => 'Amerika/Goose_Bay',
    'America/Halifax' => 'Amerika/Halifax',
    'America/Glace_Bay' => 'Amerika/Glace_Bay',
    'America/Montreal' => 'Amerika/Montreal',
    'America/Toronto' => 'Amerika/Toronto',
    'America/Thunder_Bay' => 'Amerika/Thunder_Bay',
    'America/Nipigon' => 'Amerika/Nipigon',
    'America/Rainy_River' => 'Amerika/Rainy_River',
    'America/Winnipeg' => 'Amerika/Winnipeg',
    'America/Regina' => 'Amerika/Regina',
    'America/Swift_Current' => 'Amerika/Swift_Current',
    'America/Edmonton' => 'Amerika/Edmonton',
    'America/Vancouver' => 'Amerika/Vancouver',
    'America/Dawson_Creek' => 'Amerika/Dawson_Creek',
    'America/Pangnirtung' => 'Amerika/Pangnirtung',
    'America/Iqaluit' => 'Amerika/Iqaluit',
    'America/Coral_Harbour' => 'Amerika/Coral_Harbour',
    'America/Rankin_Inlet' => 'Amerika/Rankin_Inlet',
    'America/Cambridge_Bay' => 'Amerika/Cambridge_Bay',
    'America/Yellowknife' => 'Amerika/Yellowknife',
    'America/Inuvik' => 'Amerika/Inuvik',
    'America/Whitehorse' => 'Amerika/Whitehorse',
    'America/Dawson' => 'Amerika/Dawson',
    'America/Cancun' => 'Amerika/Cancun',
    'America/Merida' => 'Amerika/Merida',
    'America/Monterrey' => 'Amerika/Monterrey',
    'America/Mexico_City' => 'Amerika/Mexico_City',
    'America/Chihuahua' => 'Amerika/Chihuahua',
    'America/Hermosillo' => 'Amerika/Hermosillo',
    'America/Mazatlan' => 'Amerika/Mazatlan',
    'America/Tijuana' => 'Amerika/Tijuana',
    'America/Anguilla' => 'Amerika/Anguilla',
    'America/Antigua' => 'Amerika/Antigua',
    'America/Nassau' => 'Amerika/Nassau',
    'America/Barbados' => 'Amerika/Barbados',
    'America/Belize' => 'Amerika/Belize',
    'Atlantic/Bermuda' => 'Atlanten/Bermuda',
    'America/Cayman' => 'Amerika/Cayman',
    'America/Costa_Rica' => 'Amerika/Costa_Rica',
    'America/Havana' => 'Amerika/Havana',
    'America/Dominica' => 'Amerika/Dominica',
    'America/Santo_Domingo' => 'Amerika/Santo_Domingo',
    'America/El_Salvador' => 'Amerika/El_Salvador',
    'America/Grenada' => 'Amerika/Grenada',
    'America/Guadeloupe' => 'Amerika/Guadeloupe',
    'America/Guatemala' => 'Amerika/Guatemala',
    'America/Port-au-Prince' => 'Amerika/Port-au-Prince',
    'America/Tegucigalpa' => 'Amerika/Tegucigalpa',
    'America/Jamaica' => 'Amerika/Jamaica',
    'America/Martinique' => 'Amerika/Martinique',
    'America/Montserrat' => 'Amerika/Montserrat',
    'America/Managua' => 'Amerika/Managua',
    'America/Panama' => 'Amerika/Panama',
    'America/Puerto_Rico' => 'Amerika/Puerto_Rico',
    'America/St_Kitts' => 'Amerika/St_Kitts',
    'America/St_Lucia' => 'Amerika/St_Lucia',
    'America/Miquelon' => 'Amerika/Miquelon',
    'America/St_Vincent' => 'Amerika/St_Vincent',
    'America/Grand_Turk' => 'Amerika/Grand_Turk',
    'America/Tortola' => 'Amerika/Tortola',
    'America/St_Thomas' => 'Amerika/St_Thomas',
    'America/Argentina/Buenos_Aires' => 'Amerika/Argentina/Buenos_Aires',
    'America/Argentina/Cordoba' => 'Amerika/Argentina/Cordoba',
    'America/Argentina/Tucuman' => 'Amerika/Argentina/Tucuman',
    'America/Argentina/La_Rioja' => 'Amerika/Argentina/La_Rioja',
    'America/Argentina/San_Juan' => 'Amerika/Argentina/San_Juan',
    'America/Argentina/Jujuy' => 'Amerika/Argentina/Jujuy',
    'America/Argentina/Catamarca' => 'Amerika/Argentina/Catamarca',
    'America/Argentina/Mendoza' => 'Amerika/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'Amerika/Argentina/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'Amerika/Argentina/Ushuaia',
    'America/Aruba' => 'Amerika/Aruba',
    'America/La_Paz' => 'Amerika/La_Paz',
    'America/Noronha' => 'Amerika/Noronha',
    'America/Belem' => 'Amerika/Belem',
    'America/Fortaleza' => 'Amerika/Fortaleza',
    'America/Recife' => 'Amerika/Recife',
    'America/Araguaina' => 'Amerika/Araguaina',
    'America/Maceio' => 'Amerika/Maceio',
    'America/Bahia' => 'Amerika/Bahia',
    'America/Sao_Paulo' => 'Amerika/Sao_Paulo',
    'America/Campo_Grande' => 'Amerika/Campo_Grande',
    'America/Cuiaba' => 'Amerika/Cuiaba',
    'America/Porto_Velho' => 'Amerika/Porto_Velho',
    'America/Boa_Vista' => 'Amerika/Boa_Vista',
    'America/Manaus' => 'Amerika/Manaus',
    'America/Eirunepe' => 'Amerika/Eirunepe',
    'America/Rio_Branco' => 'Amerika/Rio_Branco',
    'America/Santiago' => 'Amerika/Santiago',
    'Pacific/Easter' => 'Stilla havet/Easter',
    'America/Bogota' => 'Amerika/Bogota',
    'America/Curacao' => 'Amerika/Curacao',
    'America/Guayaquil' => 'Amerika/Guayaquil',
    'Pacific/Galapagos' => 'Stilla havet/Galapagos',
    'Atlantic/Stanley' => 'Atlanten/Stanley',
    'America/Cayenne' => 'Amerika/Cayenne',
    'America/Guyana' => 'Amerika/Guyana',
    'America/Asuncion' => 'Amerika/Asuncion',
    'America/Lima' => 'Amerika/Lima',
    'Atlantic/South_Georgia' => 'Atlanten/South_Georgia',
    'America/Paramaribo' => 'Amerika/Paramaribo',
    'America/Port_of_Spain' => 'Amerika/Port_of_Spain',
    'America/Montevideo' => 'Amerika/Montevideo',
    'America/Caracas' => 'Amerika/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'Favoriter';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'Favorit';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Kontakter',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'Begäran',
    2 => 'Åtkomst',
    3 => 'Ogiltig',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugaranvändare',
    'support_portal' => 'Support Portal',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'Kampanj',
    'email' => 'Email',
    'workflow' => 'Arbetsflöde',
    'system' => 'System',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'Kampanj',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'Kampanj',
    'email' => 'Email',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'Dokumentation',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'Två intervall',
    'show_buckets' => 'Tre intervall',
    'show_custom_buckets' => 'Anpassade intervall',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'Datum baserat år',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'Årlig (Kvartals delperioder)',
    'Quarter' => 'Kvartalsvis (Månatlig delperioder)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'Intäktsposter',
    'Opportunities' => 'Affärsmöjligheter',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'Ja',
    'no' => 'Nej',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'Varna',
    'information' => 'Info',
    'other' => 'Annan',
    'success' => 'Genomfört',
    'warning' => 'Varning',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'GET',
    'PUT' => 'PUT',
    'DELETE' => 'RADERA',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'Manuelt',
    '5' => 'Var 5e minut',
    '15' => 'Varje 15 minuter',
    '30' => 'Varje 30 minuter',
    '60' => 'Varje timme',
];

$app_list_strings['moduleList']['KBDocuments'] = 'Kunskapsbas';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'Kunskapsbas';
$app_list_strings['moduleList']['KBContents'] = 'Kunskapsbas';
$app_list_strings['moduleListSingular']['KBContents'] = 'Kunskapsbasartikel';
$app_list_strings['moduleList']['KBArticles'] = 'Kunskapsbasartikel';
$app_list_strings['moduleListSingular']['KBArticles'] = 'Kunskapsbasartikel';
$app_list_strings['moduleList']['KBContentTemplates'] = 'Kunskapsbasmall';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'Kunskapsbasmall';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'Inbäddade filer';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'Inbäddad fil';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leke',
    'USD' => 'Dollars',
    'AFN' => 'Afghanis',
    'ARS' => 'Pesos',
    'AWG' => 'Guilders',
    'AUD' => 'Dollars',
    'AZN' => 'New Manats',
    'BSD' => 'Dollars',
    'BBD' => 'Dollars',
    'BYR' => 'Rubles',
    'EUR' => 'Euro',
    'BZD' => 'Dollars',
    'BMD' => 'Dollars',
    'BOB' => 'Bolivianos',
    'BAM' => 'Convertible Marka',
    'BWP' => 'Pulas',
    'BGN' => 'Leva',
    'BRL' => 'Reais',
    'GBP' => 'Pounds',
    'BND' => 'Dollars',
    'KHR' => 'Riels',
    'CAD' => 'Dollars',
    'KYD' => 'Dollars',
    'CLP' => 'Pesos',
    'CNY' => 'Yuan Renminbi',
    'COP' => 'Pesos',
    'CRC' => 'ColÃ³n',
    'HRK' => 'Kuna',
    'CUP' => 'Pesos',
    'CZK' => 'Koruny',
    'DKK' => 'Kroner',
    'DOP' => 'Pesos',
    'XCD' => 'Dollars',
    'EGP' => 'Pounds',
    'SVC' => 'Colones',
    'EEK' => 'Krooni',
    'FKP' => 'Pounds',
    'FJD' => 'Dollars',
    'GHC' => 'Cedis',
    'GIP' => 'Pounds',
    'GTQ' => 'Quetzales',
    'GGP' => 'Pounds',
    'GYD' => 'Dollars',
    'HNL' => 'Lempiras',
    'HKD' => 'Dollars',
    'HUF' => 'Forint',
    'ISK' => 'Kronur',
    'INR' => 'Rupees',
    'IDR' => 'Rupiahs',
    'IRR' => 'Rials',
    'IMP' => 'Pounds',
    'ILS' => 'New Shekels',
    'JMD' => 'Dollars',
    'JPY' => 'Yen',
    'JEP' => 'Pounds',
    'KZT' => 'Tenge',
    'KPW' => 'Won',
    'KRW' => 'Won',
    'KGS' => 'Soms',
    'LAK' => 'Kips',
    'LVL' => 'Lati',
    'LBP' => 'Pounds',
    'LRD' => 'Dollars',
    'CHF' => 'Switzerland Francs',
    'LTL' => 'Litai',
    'MKD' => 'Denars',
    'MYR' => 'Ringgits',
    'MUR' => 'Rupees',
    'MXN' => 'Pesos',
    'MNT' => 'Tugriks',
    'MZN' => 'Meticais',
    'NAD' => 'Dollars',
    'NPR' => 'Rupees',
    'ANG' => 'Guilders',
    'NZD' => 'Dollars',
    'NIO' => 'Cordobas',
    'NGN' => 'Nairas',
    'NOK' => 'Krone',
    'OMR' => 'Rials',
    'PKR' => 'Rupees',
    'PAB' => 'Balboa',
    'PYG' => 'Guarani',
    'PEN' => 'Nuevos Soles',
    'PHP' => 'Pesos',
    'PLN' => 'Zlotych',
    'QAR' => 'Rials',
    'RON' => 'New Lei',
    'RUB' => 'Rubles',
    'SHP' => 'Pounds',
    'SAR' => 'Riyals',
    'RSD' => 'Dinars',
    'SCR' => 'Rupees',
    'SGD' => 'Dollars',
    'SBD' => 'Dollars',
    'SOS' => 'Shillings',
    'ZAR' => 'Rand',
    'LKR' => 'Rupees',
    'SEK' => 'Kronor',
    'SRD' => 'Dollars',
    'SYP' => 'Pounds',
    'TWD' => 'New Dollars',
    'THB' => 'Baht',
    'TTD' => 'Dollars',
    'TRY' => 'Lira',
    'TRL' => 'Liras',
    'TVD' => 'Dollars',
    'UAH' => 'Hryvnia',
    'UYU' => 'Pesos',
    'UZS' => 'Sums',
    'VEF' => 'Bolivares Fuertes',
    'VND' => 'Dong',
    'YER' => 'Rials',
    'ZWD' => 'Zimbabwe Dollars',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'Mycket hög',
    '4' => 'Hög',
    '3' => 'Neutral',
    '2' => 'Låg',
    '1' => 'Mycket låg',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'Ingen',
    'future' => 'Aktuellt värde',
    'old' => 'Gammalt värde',
    'both' => 'Aktuella och gamla värden',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Enkel träff',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'Bearbetar',
    'error' => 'Fel',
    'success' => 'Klart',
    'canceled' => 'Har avbrutits',
    'document_load' => 'Laddar mall',
    'tags_extract' => 'Extrahera taggar',
    'tags_validate' => 'Validerar taggar',
    'data_retrieving' => 'Hämtar data',
    'serialize_document' => 'Sätta ihop dokumentet igen',
    'send_document' => 'Dokumentet skickas till dig',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'Slå ihop',
    'convert' => 'PDF-sammanslagning',
    'multimerge' => 'Multisammanslagning',
    'multimerge_convert' => 'Multisammanslagning av PDF',
    'labelsgenerate' => 'Generera etiketter',
    'labelsgenerate_convert' => 'Genererar etiketter PDF',
    'excel' => 'Excel-sammanslagning',
    'excel_convert' => 'Exel-sammanslagningskonvertering',
    'presentation' => 'PowerPoint-sammanslagning',
    'presentation_convert' => 'PowerPoint-sammanslagning PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'Mina konton',
    'favorites' => 'Favoritkonton',
    'tags' => 'Taggade konton',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'Alla nyheter',
    'General' => 'Allmänt',
    'Finance' => 'Ekonomi',
    'People' => 'Personal',
    'Press Releases' => 'Pressreleaser',
    'Other' => 'Övrigt',
];

$app_strings['LBL_OWNERS'] = 'Ägare';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Molnlagring';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'Dashlet för molnlagringsintegrering';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'Kopiera länk';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'Ladda ner';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Skapa Sugar-dokument';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'Det gick inte att ladda ner den här filen';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'Cloud-dashlet finns inte';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar-dokument skapat';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'Skicka till DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign är inte tillgängligt från denna plats.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'Dok-sammanslagning till Word/Excel/PowerPoint är inte tillgängligt från den här platsen';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'Dok-sammanslagning till DocuSign är inte tillgängligt från den här platsen';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'Dok-sammanslagning till PDF är inte tillgängligt från den här platsen';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'Din signerade fil laddas endast upp här om du har behörighet att ladda upp till den här platsen.';
$app_strings['LBL_DOC_MERGE_TO'] = 'Dokumentsammanslagning till';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'Mina filer';
$app_strings['LBL_SHARED_WITH_ME'] = 'Delas med mig';
$app_strings['LBL_CLOUD_PROVIDER'] = 'Molnleverantör';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'Delade med mig';
$app_strings['LBL_MY_FILES'] = 'Mina filer';
$app_strings['LBL_UPLOAD_FILE'] = 'Ladda upp fil';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'Mappen hittades inte';
$app_strings['LBL_CREATE_FOLDER'] = 'Skapa mapp';
$app_strings['LBL_LOAD_MORE'] = 'Läs in mer...';
$app_strings['LBL_NEW_FOLDER'] = 'Ny mapp';
$app_strings['LBL_FOLDER_NAME'] = 'Mappnamn: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'Du har inte tillstånd att göra det på den nuvarande vägen.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'Du har inte tillstånd att gå på den nuvarande vägen.';
$app_strings['LBL_FILE_UPLOADED'] = 'Filen har laddats upp.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'På grund av filens stora storlek kommer uppladdningen att ta en stund.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'En eller flera dokumentposter har ingen bifogad fil. Bifoga filer till posterna och försök igen eller synkronisera specifika poster till filer individuellt.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Ingen anslutning till Google hittades...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Ingen anslutning till Microsoft hittades...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Ingen anslutning till Dropbox hittades...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'Synkronisering med OneDrive kan ta en stund';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'Är du säker på att du vill radera denna fil?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDriveuppladdning är färdig.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' har laddats upp.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'Fel vid laddning av sökvägar.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'Ett fel har uppstått eftersom filen är skadad.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'Dokumentet <i>"{{documentName}}"</i> har sparats på din molndrivenhet och lagts till i dokumentmodulen.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'Du har inte behörighet att radera denna fil.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'Du har inte behörighet att radera denna mapp.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'Du har inte behörighet att ladda upp filer till denna plats.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'Du har inte behörighet att skapa en mapp på denna plats.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'Det går inte att skapa mappar på denna plats.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'Det går inte att ladda upp filer till denna plats.';
$app_strings['LBL_SITES'] = 'Platser';
$app_strings['LBL_SHARED'] = 'Delad';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'Länken har skapats. Klicka på knappen för att kopiera länken till urklipp.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'Kopiera till urklipp';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-tom-',
    'Exact' => 'Exakt',
    'Null_address_components' => 'En eller flera adresskomponenter är tomma',
    'Invalid_address' => 'Ogiltig adress, servern svarade med Falaktigt',
    'Invalid_server_response_not_XML' => 'Ogiltig serverrespons, inte XML',
    'Invalid_address_no_location' => 'Ogiltig adress, ingen plats kunde hämtas från servern',
    'Ambiguous_address' => 'Tvetydig adress, flera matchningar',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'Gatuvy',
    'a' => 'Satellitvy',
    'rd' => 'Mörk gatuvy',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'Engelska (USA)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'New York (EST)'],
    ['pst', 'Los Angeles (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['Ny', 'Ny'],
    ['Tilldelad', 'Tilldelad'],
    ['Stängd', 'Stängd'],
    ['I väntan på inmatning', 'I väntan på inmatning'],
    ['Avvisad', 'Avvisad'],
    ['Duplicerad', 'Duplicerad'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['Administration', 'Administration'],
    ['Produkt', 'Produkt'],
    ['Användare', 'Användare'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'Hög'],
    ['P2', 'Medel'],
    ['P3', 'Låg'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['användare', 'Användare'],
    ['admin,användare', 'Admin'],
    ['kontoansvarig,användare', 'Kontoansvarig'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', 'Senaste 30 dagarna'],
    ['last_90_days', 'Senaste 90 dagarna'],
    ['this_year', 'Senaste året'],
    ['anpassad', 'Anpassat intervall'],
    ['alla', 'Alla'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['Standard', 'Standard'],
    ['Färg', 'Enfärgad'],
    ['Url', 'Anpassad bild'],
];
