<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'Engels (VS)',
    'moduleList' => [
        'Home' => 'Start',
        'Contacts' => 'Contactpersonen',
        'Accounts' => 'Organisaties',
        'Opportunities' => 'Opportunities',
        'Cases' => 'Cases',
        'Notes' => 'Notities',
        'Calls' => 'Telefoongesprekken',
        'Emails' => 'E-mail',
        'Meetings' => 'Afspraken',
        'Tasks' => 'Taken',
        'Calendar' => 'Agenda',
        'Leads' => 'Leads',
        'Currencies' => 'Valutas',
        'Contracts' => 'Contracten',
        'Quotes' => 'Offertes',
        'Products' => 'Geoffreerde producten',
        'WebLogicHooks' => 'Web Logic Hooks',
        'ProductCategories' => 'Productcategorieën',
        'ProductTypes' => 'Producttypes',
        'ProductTemplates' => 'Productcatalogus',
        'ProductBundles' => 'Productbundels',
        'ProductBundleNotes' => 'Notities productbundel',
        'Reports' => 'Rapporten',
        'Forecasts' => 'Forecasts',
        'ForecastWorksheets' => 'Forecastwerkbladen',
        'ForecastManagerWorksheets' => 'Management Forecastwerkbladen',
        'VisualPipeline' => 'Visuele pijplijn',
        'ConsoleConfiguration' => 'Configuratie console',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'Quotas',
        'Teams' => 'Teams',
        'TeamNotices' => 'Teamberichten',
        'Manufacturers' => 'Fabrikanten',
        'Activities' => 'Activiteiten',
        'Comments' => 'Opmerkingen',
        'Subscriptions' => 'Abonnementen',
        'Bugs' => 'Bugs',
        'Feeds' => 'RSS',
        'iFrames' => 'Mijn Sites',
        'TimePeriods' => 'Perioden',
        'TaxRates' => 'BTW-tarief',
        'ContractTypes' => 'Contractvormen',
        'Schedulers' => 'Taakplanners',
        'Project' => 'Projecten',
        'ProjectTask' => 'Project Taken',
        'Campaigns' => 'Campagnes',
        'CampaignLog' => 'Campagne log',
        'CampaignTrackers' => 'Campagne trackers',
        'Documents' => 'Documenten',
        'DocumentRevisions' => 'Documentrevisie',
        'Connectors' => 'Connectoren',
        'Notifications' => 'Notificaties',
        'Sync' => 'Synchronisatie',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'Doelen HintMelding',
        'HintNewsNotifications' => 'MeldingenHintNieuws',
        'HintEnrichFieldConfigs' => 'VeldConfigHintVerrijken',
        'ExternalUsers' => 'Externe gebruikers',
        'ReportMaker' => 'Geavanceerde rapporten',
        'DataSets' => 'Data formaten',
        'CustomQueries' => 'Custom queries',
        'pmse_Inbox' => 'Processen',
        'pmse_Project' => 'Procesdefinities',
        'pmse_Business_Rules' => 'Proces bedrijfsregels',
        'pmse_Emails_Templates' => 'Process E-mail Templates',
        'BusinessCenters' => 'Zakencentra',
        'Shifts' => 'Ploegen',
        'ShiftExceptions' => 'Uitzonderingen ploeg',
        'Purchases' => 'Aankopen',
        'PurchasedLineItems' => 'Aangeschafte regelitems',
        'MobileDevices' => 'Mobiele apparaten',
        'PushNotifications' => 'Pushmeldingen',
        'Escalations' => 'Escalaties',
        'DocumentTemplates' => 'Documentsjablonen',
        'DocumentMerges' => 'Samenvoegingen document',
        'CloudDrivePaths' => 'Cloudaandrijfpaden',
        'WorkFlow' => 'Workflow Definities',
        'EAPM' => 'Externe Accounts',
        'Worksheet' => 'Werkblad',
        'Users' => 'Gebruikers',
        'Employees' => 'Medewerker',
        'Administration' => 'Beheer',
        'ACLRoles' => 'Rollen',
        'InboundEmail' => 'Inkomende e-mail instellingen',
        'Releases' => 'Releases',
        'Prospects' => 'Targets',
        'Queues' => 'Wachtrijen',
        'EmailMarketing' => 'E-mailmarketing',
        'EmailTemplates' => 'E-mailsjablonen',
        'SNIP' => 'E-mail Archivering',
        'ProspectLists' => 'Targetlijsten',
        'SavedSearch' => 'Opgeslagen Zoekopdrachten',
        'UpgradeWizard' => 'Upgradewizard',
        'Trackers' => 'Trackers',
        'TrackerPerfs' => 'Tracker Performance',
        'TrackerSessions' => 'Tracker Sessies',
        'TrackerQueries' => 'Tracker query&#39;s',
        'FAQ' => 'FAQ',
        'Newsletters' => 'Nieuwsbrieven',
        'SugarFavorites' => 'Favorieten',
        'PdfManager' => 'PDF beheerder',
        'DataArchiver' => 'Data-archiveriing',
        'ArchiveRuns' => 'Archief wordt uitgevoerd',

        'OAuthKeys' => 'OAuth consumentsleutels',
        'OAuthTokens' => 'OAuth tokens',
        'Filters' => 'Filters',
        'UserSignatures' => 'E-mailhandtekeningen',
        'Shippers' => 'Vervoerders',
        'Styleguide' => 'Styleguide',
        'Feedbacks' => 'Feedback',
        'Tags' => 'Tags',
        'Categories' => 'Categorieën',
        'Dashboards' => 'Dashboards',
        'OutboundEmail' => 'E-mailinstellingen',
        'EmailParticipants' => 'E-maildeelnemers',
        'DataPrivacy' => 'Gegevensprivacy',
        'ReportSchedules' => 'Schema&#39;s rapporteren',
        'CommentLog' => 'Opmerkingenlog',
        'Holidays' => 'Vakanties',
        'ChangeTimers' => 'Timers veranderen',
        'Metrics' => 'Statistieken',
        'Messages' => 'Berichten',
        'Audit' => 'Auditeren',
        'RevenueLineItems' => 'Omzetregelitems',
        'DocuSignEnvelopes' => 'DocuSign Enveloppen',
        'Geocode' => 'Geocodering',
        'DRI_Workflows' => 'Slimme gidsen',
        'DRI_Workflow_Task_Templates' => 'Activiteitensjablonen voor slimme gids',
        'DRI_SubWorkflows' => 'Slimme gids-fasen',
        'DRI_Workflow_Templates' => 'Slimme gids-sjablonen',
        'CJ_WebHooks' => 'Webhooks van Sugar Automate',
        'CJ_Forms' => 'Acties Sugar Smart Guide',
        'DRI_SubWorkflow_Templates' => 'Fasensjablonen voor slimme gidsen',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub-module aanmeldingen gebeurtenissen pushen',
    ],

    'moduleIconList' => [
        'Home' => 'Ho',
        'Contacts' => 'Cont',
        'Accounts' => 'Acc',
        'Opportunities' => 'Op',
        'Cases' => 'Cs',
        'Notes' => 'Nt',
        'Calls' => 'Te',
        'Emails' => 'E-m',
        'Meetings' => 'Afs',
        'Tasks' => 'Ta',
        'Calendar' => 'Ag',
        'Leads' => 'Le',
        'Currencies' => 'Va',
        'Contracts' => 'Contr',
        'Quotes' => 'Of',
        'Products' => 'Pr',
        'WebLogicHooks' => 'WLH',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'PT',
        'ProductTemplates' => 'PS',
        'ProductBundles' => 'PB',
        'ProductBundleNotes' => 'OPB',
        'Reports' => 'Ra',
        'Forecasts' => 'Fo',
        'ForecastWorksheets' => 'FW',
        'ForecastManagerWorksheets' => 'MFW',
        'Quotas' => 'Fo',
        'VisualPipeline' => 'VP',
        'ConsoleConfiguration' => 'CC',
        'SugarLive' => 'SL',
        'Teams' => 'Te',
        'TeamNotices' => 'TB',
        'Manufacturers' => 'Fa',
        'Activities' => 'Act',
        'Comments' => 'Re',
        'Subscriptions' => 'Ab',
        'Bugs' => 'Bu',
        'Feeds' => 'Fe',
        'iFrames' => 'iF',
        'TimePeriods' => 'Pe',
        'TaxRates' => 'BT',
        'ContractTypes' => 'CT',
        'Schedulers' => 'Ta',
        'Project' => 'Pr',
        'ProjectTask' => 'PT',
        'Campaigns' => 'Ca',
        'CampaignLog' => 'CL',
        'CampaignTrackers' => 'CT',
        'Documents' => 'Do',
        'DocumentRevisions' => 'DR',
        'Connectors' => 'Co',
        'Notifications' => 'Me',
        'Sync' => 'Sy',
        'HintAccountsets' => 'Hi',
        'HintNotificationTargets' => 'DMH',
        'HintNewsNotifications' => 'NH',
        'HintEnrichFieldConfigs' => 'CVVH',
        'ExternalUsers' => 'EG',
        'ReportMaker' => 'RG',
        'DataSets' => 'DS',
        'CustomQueries' => 'AQ',
        'pmse_Inbox' => 'PI',
        'pmse_Project' => 'PP',
        'pmse_Business_Rules' => 'PZR',
        'pmse_Emails_Templates' => 'PE-mS',
        'BusinessCenters' => 'ZC',
        'Shifts' => 'Pl',
        'ShiftExceptions' => 'UP',
        'Purchases' => 'Aa',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'MA',
        'PushNotifications' => 'PM',
        'Escalations' => 'Es',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'Cd',
        'WorkFlow' => 'WF',
        'EAPM' => 'EA',
        'Worksheet' => 'WB',
        'Users' => 'Ge',
        'Employees' => 'Me',
        'Administration' => 'Ad',
        'ACLRoles' => 'ACLR ',
        'InboundEmail' => 'IE',
        'Releases' => 'Re',
        'Prospects' => 'Pr',
        'Queues' => 'Wa',
        'EmailMarketing' => 'EM',
        'EmailTemplates' => 'ES',
        'SNIP' => 'SNIP',
        'ProspectLists' => 'PL',
        'SavedSearch' => 'OZ',
        'UpgradeWizard' => 'UW',
        'Trackers' => 'Tr',
        'TrackerPerfs' => 'TP',
        'TrackerSessions' => 'TS',
        'TrackerQueries' => 'TQ',
        'FAQ' => 'VV',
        'Newsletters' => 'Ni',
        'SugarFavorites' => 'SF',
        'PdfManager' => 'PM',
        'DataArchiver' => 'GA',
        'ArchiveRuns' => 'AU',
        'OAuthKeys' => 'OS',
        'OAuthTokens' => 'OT',
        'Filters' => 'Fi',
        'UserSignatures' => 'GH',
        'Shippers' => 'Ex',
        'Styleguide' => 'St',
        'Feedbacks' => 'FeB',
        'Tags' => 'Ta',
        'Categories' => 'Ca',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'UE',
        'EmailParticipants' => 'ED',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'GR',
        'CommentLog' => 'RL',
        'Holidays' => 'Va',
        'ChangeTimers' => 'TV',
        'Metrics' => 'St',
        'Messages' => 'Be',
        'Audit' => 'Au',
        'RevenueLineItems' => 'OR',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'Ge',
        'DRI_Workflows' => 'DRIW',
        'DRI_Workflow_Task_Templates' => 'WTS',
        'DRI_SubWorkflows' => 'SW',
        'DRI_Workflow_Templates' => 'WS',
        'CJ_WebHooks' => 'WH',
        'CJ_Forms' => 'CJF',
        'DRI_SubWorkflow_Templates' => 'SWS',
        'Library' => 'Bi',
        'EmailAddresses' => 'E-mA',
        'Words' => 'Wo',
        'Sugar_Favorites' => 'SF',
        'KBDocuments' => 'KBD',
        'KBContents' => 'KB',
        'KBArticles' => 'KBA',
        'KBContentTemplates' => 'KBIS',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'IB',
    ],

    'moduleListSingular' => [
        'Home' => 'Start',
        'Dashboards' => 'Dashboard',
        'Styleguide' => 'Styleguide',
        'Contacts' => 'Persoon',
        'Accounts' => 'Organisatie',
        'Opportunities' => 'Opportunity',
        'Cases' => 'Case',
        'Notes' => 'Notitie',
        'Calls' => 'Telefoongesprek',
        'Emails' => 'E-mailadres',
        'Meetings' => 'Afspraak',
        'Tasks' => 'Taak',
        'Calendar' => 'Agenda',
        'Leads' => 'Lead',
        'Manufacturers' => 'Fabrikant',
        'VisualPipeline' => 'Visuele pijplijn',
        'ConsoleConfiguration' => 'Configuratie console',
        'MobileDevices' => 'Mobiel apparaat',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'Contract',
        'Quotes' => 'Offerte',
        'Products' => 'Geoffreerd product',
        'ProductCategories' => 'Productcategorie',
        'ProductBundles' => 'Productbundel',
        'ProductBundleNotes' => 'Notitie productbundel',
        'RevenueLineItems' => 'Opportunityregel',
        'WebLogicHooks' => 'Web Logic Hook',
        'Reports' => 'Rapport',
        'Forecasts' => 'Forecast',
        'ForecastWorksheets' => 'Forecastwerkblad',
        'ForecastManagerWorksheets' => 'Management Forecastwerkblad',
        'Quotas' => 'Quota',
        'Teams' => 'Team',
        'TeamNotices' => 'Teambericht',
        'Activities' => 'Activiteit',
        'ActivityStream' => 'Activity Stream',
        'Bugs' => 'Bug',
        'Feeds' => 'RSS',
        'iFrames' => 'Mijn Sites',
        'TimePeriods' => 'Periode',
        'TaxRates' => 'BTW percentage:',
        'ContractTypes' => 'Contractvorm',
        'Schedulers' => 'Taakplanner',
        'Campaigns' => 'Campagne',
        'CampaignLog' => 'Campagne log',
        'Project' => 'Project',
        'ProjectTask' => 'Projecttaak',
        'Prospects' => 'Target',
        'ProspectLists' => 'Targetlijst',
        'CampaignTrackers' => 'Campagne tracker',
        'Documents' => 'Document',
        'DocumentRevisions' => 'Documentrevisie',
        'Connectors' => 'Connector',
        'Notifications' => 'Notificatie',
        'Sync' => 'Synchronisatie',
        'PdfManager' => 'PDF beheerder',
        'DataArchiver' => 'Data-archiveriing',
        'ArchiveRuns' => 'Archief wordt uitgevoerd',
        'ExternalUsers' => 'Externe gebruiker',
        'ReportMaker' => 'Geavanceerd Rapport',
        'DataSets' => 'Data formaat',
        'CustomQueries' => 'Custom query:',
        'pmse_Inbox' => 'Proces',
        'pmse_Project' => 'Procesdefinitie',
        'pmse_Business_Rules' => 'Proces bedrijfsregel',
        'pmse_Emails_Templates' => 'Process E-mail Template',
        'BusinessCenters' => 'Zakencentrum',
        'Shifts' => 'Ploeg',
        'ShiftExceptions' => 'Uitzonderingen ploeg',
        'Purchases' => 'Aankoop',
        'PurchasedLineItems' => 'Aangeschaft regelitem',
        'PushNotifications' => 'Pushmelding',
        'Escalations' => 'Escalatie',
        'DocumentTemplates' => 'Documentsjabloon',
        'DocumentMerges' => 'Document samenvoegen',
        'CloudDrivePaths' => 'Cloudaandrijfpad',
        'WorkFlow' => 'Workflow',
        'EAPM' => 'Externe Account',
        'Worksheet' => 'Werkblad',
        'Users' => 'Gebruiker',
        'SugarFavorites' => 'SugarFavorieten',
        'Employees' => 'Medewerker',
        'Administration' => 'Beheer',
        'ACLRoles' => 'Rol',
        'InboundEmail' => 'Inkomende e-mail instellingen',
        'Releases' => 'Release',
        'Queues' => 'Wachtrij',
        'EmailMarketing' => 'E-mailmarketing',
        'EmailTemplates' => 'E-mailsjabloon',
        'SNIP' => 'E-mail Archivering',
        'SavedSearch' => 'Opgeslagen zoekopdracht',
        'UpgradeWizard' => 'Upgradewizard',
        'Trackers' => 'Tracker',
        'TrackerPerfs' => 'Tracker Performance',
        'TrackerSessions' => 'Trackersessie',
        'TrackerQueries' => 'Tracker Query',
        'FAQ' => 'FAQ',
        'Newsletters' => 'Nieuwsbrief',
        'OAuthKeys' => 'Sleutel OAuth consument',
        'OAuthTokens' => 'API OAuth Token',
        'Filters' => 'Filteren',
        'Comments' => 'Commentaar',
        'CommentLog' => 'Opmerkingenlog',
        'Currencies' => 'Valuta',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'Producttype',
        'Shippers' => 'Vervoerder',
        'Subscriptions' => 'Abonnement',
        'UserSignatures' => 'E-mailhandtekening',
        'Feedbacks' => 'Feedback',
        'Tags' => 'Tag',
        'Categories' => 'Categorie',
        'OutboundEmail' => 'E-mailinstelling',
        'EmailParticipants' => 'E-maildeelnemer',
        'DataPrivacy' => 'Gegevensprivacy',
        'ReportSchedules' => 'Schema rapporteren',
        'Holidays' => 'Vakantie',
        'ChangeTimers' => 'Timer veranderen',
        'Metrics' => 'Statistieken',
        'Messages' => 'Bericht',
        'Audit' => 'Auditeren',
        'DocuSignEnvelopes' => 'DocuSignEnvelop',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'Doelen HintMelding',
        'HintNewsNotifications' => 'MeldingenHintNieuws',
        'HintEnrichFieldConfigs' => 'VeldConfigHintVerrijken',
        'Geocode' => 'Geocodering',
        'DRI_Workflows' => 'Slimme gids',
        'DRI_Workflow_Task_Templates' => 'Activiteitensjabloon voor slimme gidsen',
        'DRI_SubWorkflows' => 'Slimme gids-fase',
        'DRI_Workflow_Templates' => 'Slimme gids-sjabloon',
        'CJ_WebHooks' => 'Webhook van Sugar Automate',
        'CJ_Forms' => 'Actie Sugar Smart Guide',
        'DRI_SubWorkflow_Templates' => 'Fasensjabloon voor slimme gidsen',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub-module aanmelding gebeurtenissen pushen',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'Ja',
        '2' => 'Nee',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'Nee',
        1 => 'Ja',
    ],

    'notifications_status_dom' => [
        0 => 'Ongelezen',
        1 => 'Gelezen',
    ],

    'optout_dom' => [
        '' => '-geen-',
        'false' => 'Nee',
        'true' => 'Ja',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'Analist',
        'Competitor' => 'Concurrent',
        'Customer' => 'Klant',
        'Integrator' => 'Integreerder',
        'Investor' => 'Investeerder',
        'Partner' => 'Partner',
        'Press' => 'Pers',
        'Prospect' => 'Verwachting',
        'Reseller' => 'Wederverkoper',
        'Other' => 'Anders',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'Kleding',
        'Banking' => 'Banken',
        'Biotechnology' => 'Biotechnologie',
        'Chemicals' => 'Chemisch',
        'Communications' => 'Communicatie',
        'Construction' => 'Bouw',
        'Consulting' => 'Advies',
        'Education' => 'Onderwijs',
        'Electronics' => 'Electronica',
        'Energy' => 'Energie',
        'Engineering' => 'Techniek',
        'Entertainment' => 'Amusement',
        'Environmental' => 'Milieu',
        'Finance' => 'Financiën',
        'Government' => 'Overheid',
        'Healthcare' => 'Gezondheidszorg',
        'Hospitality' => 'Horeca',
        'Insurance' => 'Verzekeringen',
        'Machinery' => 'Machinebouw',
        'Manufacturing' => 'Productie',
        'Media' => 'Media',
        'Not For Profit' => 'Non-Profit',
        'Recreation' => 'Recreatie',
        'Retail' => 'Detailhandel',
        'Shipping' => 'Scheepvaart',
        'Technology' => 'Technologie',
        'Telecommunications' => 'Telecommunicatie',
        'Transportation' => 'Transport',
        'Utilities' => 'Nutsbedrijven',
        'Other' => 'Anders',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF en CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'Grafiek',
        'Data Table' => 'Datatabel',
        'Chart and Data Table' => 'Grafiek en gegevenstabel',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'In bewerking',
        'Completed' => 'Afgerond',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'Inkomend',
        'Outbound' => 'Uitgaand',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'Chat',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'Niveau 1',
        'T2' => 'Niveau 2',
        'T3' => 'Niveau 3',
        'T4' => 'Niveau 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nee',
        'Completed' => 'Voltooid',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'Toekomst',
        'Active' => 'Actief',
        'Past' => 'Verleden',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'Zelf gegenereerd',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'Cold Call',
        'Existing Customer' => 'Bestaande klant',
        'Self Generated' => 'Zelf gegenereerd',
        'Employee' => 'Medewerker',
        'Partner' => 'Partner',
        'Public Relations' => 'Public Relations',
        'Direct Mail' => 'Direct mail',
        'Conference' => 'Conferentie',
        'Trade Show' => 'Beurs',
        'Web Site' => 'Website',
        'Word of mouth' => 'Mond tot mond',
        'Email' => 'E-mailadres',
        'Campaign' => 'Campagne',
        'Support Portal User Registration' => 'Support Portal Gebruikers Registratie',
        'Other' => 'Anders',
    ],
    'metric_status_dom' => [
        'Inactive' => 'Inactief',
        'Active' => 'Actief',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'Huidig bedrijf',
        'New Business' => 'Nieuw bedrijf',
    ],
    'taxrate_status_dom' => [
        'Active' => 'Actief',
        'Inactive' => 'Inactief',
    ],
    'roi_type_dom' => [
        'Revenue' => 'Opbrengst',
        'Investment' => 'Investering',
        'Expected_Revenue' => 'Verwachte opbrengst',
        'Budget' => 'Budget',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'Primaire besluitvormer',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primaire besluitvormer',
        'Business Decision Maker' => 'Zakelijke Beslisser',
        'Business Evaluator' => 'Zakelijke Evaluator',
        'Technical Decision Maker' => 'Technische Beslisser',
        'Technical Evaluator' => 'Technische Evaluator',
        'Executive Sponsor' => 'Eindverantwoordelijke',
        'Influencer' => 'Beïnvloeder',
        'Other' => 'Anders',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'Actief',
        'Inactive' => 'Inactief',
    ],

    'shipper_status_dom' => [
        'Active' => 'Actief',
        'Inactive' => 'Inactief',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'Primaire contactpersoon',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'Primaire contactpersoon',
        'Alternate Contact' => 'Alternatief contactpersoon',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'Naast veldwaarde',
        'field_on_top' => 'Boven veldwaarde',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'Netto 15',
        'Net 30' => 'Netto 30',
    ],
    'sales_stage_default_key' => 'Prospectie',
    'fts_type' => [
        'Elastic' => 'ElasticSearch',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'Prospectie',
        'Qualification' => 'Kwalificatie',
        'Needs Analysis' => 'Behoeftenanalyse',
        'Value Proposition' => 'Waardepropositie',
        'Id. Decision Makers' => 'Identificatie van beslissers',
        'Perception Analysis' => 'Perceptie Analyse',
        'Proposal/Price Quote' => 'Voorstel/Offerte',
        'Negotiation/Review' => 'Onderhandeling/Beoordeling',
        'Closed Won' => 'Afgesloten - Gewonnen',
        'Closed Lost' => 'Afgesloten - Verloren',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'Nieuw',
        'In Progress' => 'In Bewerking',
        'Closed Won' => 'Afgesloten - Gewonnen',
        'Closed Lost' => 'Afgesloten - Verloren',
        'Converted to Quote' => 'Geconverteerd naar Offerte',
    ],
    'sales_status_dom' => [
        'New' => 'Nieuw',
        'In Progress' => 'In Bewerking',
        'Closed Won' => 'Afgesloten - Gewonnen',
        'Closed Lost' => 'Afgesloten - Verloren',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'Meenemen',
        'exclude' => 'Uitsluiten',
    ],
    'commit_stage_dom' => [
        'include' => 'Meenemen',
        'upside' => 'Upside',
        'exclude' => 'Uitsluiten',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'Meenemen',
        'upside' => 'Upside',
        'exclude' => 'Uitsluiten',
    ],

    'in_total_group_stages' => [
        'Draft' => 'Concept',
        'Negotiation' => 'In onderhandeling',
        'Delivered' => 'Afgeleverd',
        'On Hold' => 'Uitgesteld',
        'Confirmed' => 'Bevestigd',
        'Closed Accepted' => 'Afgesloten - Geaccepteerd',
        'Closed Lost' => 'Afgesloten - Verloren',
        'Closed Dead' => 'Afgesloten - Geen resultaat',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'Telefoongesprek',
        'Meeting' => 'Afspraak',
        'Task' => 'Taak',
        'Email' => 'E-mailadres',
        'Note' => 'Notitie',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'Dhr.',
        'Ms.' => 'Mej.',
        'Mrs.' => 'Mevr.',
        'Dr.' => 'Dr.',
        'Prof.' => 'Prof.',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'Geen',
        60 => '1 minuut ervoor',
        300 => '5 minuten ervoor',
        600 => '10 minuten ervoor',
        900 => '15 minuten ervoor',
        1800 => '30 minuten ervoor',
        3600 => '1 uur ervoor',
        7200 => '2 uur ervoor',
        10800 => '3 uur ervoor',
        18000 => '5 uur ervoor',
        86400 => '1 dag ervoor',
        ],

        'task_priority_default' => 'Middel',
        'task_priority_dom' => [
        'High' => 'Hoog',
        'Medium' => 'Middel',
        'Low' => 'Laag',
        ],
        'task_status_default' => 'Niet gestart',
        'task_status_dom' => [
        'Not Started' => 'Niet gestart',
        'In Progress' => 'In Bewerking',
        'Completed' => 'Afgerond',
        'Pending Input' => 'Wacht op input',
        'Deferred' => 'Uitgesteld',
        'Not Applicable' => 'Niet van toepassing',
        ],
        'meeting_status_default' => 'Gepland',
        'meeting_status_dom' => [
        'Planned' => 'Gepland',
        'Held' => 'Gehouden',
        'Not Held' => 'Niet gehouden',
        'Deferred' => 'Uitgesteld',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'Anders',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'Gepland',
        'call_status_dom' => [
        'Planned' => 'Gepland',
        'In Progress' => 'In Bewerking',
        'Held' => 'Gehouden',
        'Not Held' => 'Niet gehouden',
        'Deferred' => 'Uitgesteld',
        ],
        'call_direction_default' => 'Uitgaand',
        'call_direction_dom' => [
        'Inbound' => 'Inkomend',
        'Outbound' => 'Uitgaand',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'Nieuw',
        'Assigned' => 'Toegewezen',
        'In Process' => 'In behandeling',
        'Converted' => 'Geconverteerd',
        'Recycled' => 'Hergebruikt/Opnieuw',
        'Dead' => 'Geen resultaat',
        ],
        'gender_list' => [
        'male' => 'Man',
        'female' => 'Vrouw',
        'other' => 'Anders',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'Nieuw',
        'case_status_dom' => [
        'New' => 'Nieuw',
        'Assigned' => 'Toegewezen',
        'Closed' => 'Afgesloten',
        'Pending Input' => 'Wacht op input',
        'Rejected' => 'Afgewezen',
        'Duplicate' => 'Dupliceren',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'Hoog',
        'P2' => 'Middel',
        'P3' => 'Laag',
        ],
        'user_type_dom' => [
        'RegularUser' => 'Reguliere Gebruiker',
        'Administrator' => 'Administrator',
        ],
        'user_type_bool_dom' => [
            false => 'Reguliere gebruiker',
            true => 'Beheerder',
        ],
        'user_type_group_bool_dom' => [
            true => 'Groepsgebruiker',
        ],
        'user_type_portal_bool_dom' => [
            true => 'Gebruiker Portal API',
        ],
        'license_type_dom' => [
        'CURRENT' => 'Huidige product',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'Actief',
        'Inactive' => 'Inactief',
        ],
        'employee_status_dom' => [
        'Active' => 'Actief',
        'Terminated' => 'Uit dienst',
        'Leave of Absence' => 'Met verlof',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'Actief',
        'Inactive' => 'Inactief',
        ],
        'project_task_priority_options' => [
        'High' => 'Hoog',
        'Medium' => 'Middel',
        'Low' => 'Laag',
        ],
        'project_task_priority_default' => 'Middel',

        'project_task_status_options' => [
        'Not Started' => 'Niet gestart',
        'In Progress' => 'In Bewerking',
        'Completed' => 'Afgerond',
        'Pending Input' => 'Wacht op input',
        'Deferred' => 'Uitgesteld',
        ],
        'project_task_utilization_options' => [
        '0' => 'geen',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'Concept',
        'In Review' => 'Ter beoordeling',
        'Published' => 'Gepubliceerd',
        ],
        'project_status_default' => 'Concept',

        'project_duration_units_dom' => [
        'Days' => 'Dagen',
        'Hours' => 'Uren',
        ],

        'project_priority_options' => [
        'High' => 'Hoog',
        'Medium' => 'Middel',
        'Low' => 'Laag',
        ],
        'project_priority_default' => 'Middel',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Organisaties',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'Account',
        'Opportunities' => 'Opportunity',
        'Cases' => 'Casus',
        'Leads' => 'Lead',
        'Contacts' => 'Contactpersonen', // cn (11/22/2005) added to support Emails
        'Products' => 'Geoffreerd product',
        'Quotes' => 'Offerte',
        'Bugs' => 'Bug',
        'Project' => 'Project',

        'Prospects' => 'Target',
        'ProjectTask' => 'Projecttaak',

        'Tasks' => 'Taak',
        'KBContents' => 'Knowledge Base',
        'Notes' => 'Opmerking',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'Account',
        'Contacts' => 'Persoon',
        'Opportunities' => 'Opportunity',
        'Tasks' => 'Taak',
        'ProductTemplates' => 'Productcatalogus',
        'Quotes' => 'Offerte',
        'Products' => 'Geoffreerd product',
        'Contracts' => 'Contract',
        'Emails' => 'E-mailadres',

        'Bugs' => 'Bug',
        'Project' => 'Project',
        'ProjectTask' => 'Projecttaak',
        'Prospects' => 'Target',
        'Cases' => 'Case',
        'Leads' => 'Lead',

        'Meetings' => 'Afspraak',
        'Calls' => 'Telefoongesprek',
        'KBContents' => 'Knowledge Base',
        'PurchasedLineItems' => 'Aangeschaft regelitem',
        'Purchases' => 'Aankoop',
        'Escalations' => 'Escalatie',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'Account',
        'Contacts' => 'Persoon',
        'Employees' => 'Medewerker',
        'Leads' => 'Lead',
        'Prospects' => 'Target',
        'Users' => 'Gebruiker',
        ],

        'parent_type_display' => [
        'Accounts' => 'Account',
        'Contacts' => 'Persoon',
        'Tasks' => 'Taak',
        'Opportunities' => 'Opportunity',
        'Products' => 'Geoffreerd product',
        'Quotes' => 'Offerte',

        'Bugs' => 'Bugs',
        'Cases' => 'Case',
        'Leads' => 'Lead',

        'Project' => 'Project',
        'ProjectTask' => 'Projecttaak',

        'Prospects' => 'Target',
        'KBContents' => 'Knowledge Base',
        'Notes' => 'Opmerking',
        'PurchasedLineItems' => 'Aangeschaft regelitem',
        'Purchases' => 'Aankoop',
        'Escalations' => 'Escalatie',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'Case',
        ],

        'product_status_default_key' => 'Ship',
        'product_status_quote_key' => 'Offertes',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'Geoffreerd',
        'Orders' => 'Besteld',
        'Ship' => 'Verzonden',
        ],
        'active_status_dom' => [
        'Active' => 'Actief',
        'Inactive' => 'Inactief',
        'Retired' => 'Verouderd',
        ],
        'appearance_options' => [
        'system_default' => 'Systeeminstelling gebruiken',
        'light' => 'Licht',
        'dark' => 'Donker',
        ],


        'pricing_formula_default_key' => 'Fixed',
        'pricing_formula_dom' => [
        'Fixed' => 'Vaste prijs',
        'ProfitMargin' => 'Winstmarge',
        'PercentageMarkup' => 'Winstopslag',
        'PercentageDiscount' => 'Korting over prijslijst',
        'IsList' => 'Zelfde als prijslijst',
        ],
        'product_template_status_dom' => [
        'Available' => 'Op Voorraad',
        'Unavailable' => 'Niet op voorraad',
        ],
        'tax_class_dom' => [
        'Taxable' => 'Belastbaar',
        'Non-Taxable' => 'Onbelastbaar',
        ],
        'support_term_dom' => [
        '+6 months' => '6 maanden',
        '+1 year' => 'Eén jaar',
        '+2 years' => 'Twee jaren',
        ],

        'quote_type_dom' => [
        'Quotes' => 'Offerte',
        'Orders' => 'Volgorde',
        ],
        'default_quote_stage_key' => 'Concept',
        'quote_stage_dom' => [
        'Draft' => 'Concept',
        'Negotiation' => 'In onderhandeling',
        'Delivered' => 'Afgeleverd',
        'On Hold' => 'Uitgesteld',
        'Confirmed' => 'Bevestigd',
        'Closed Accepted' => 'Afgesloten - Geaccepteerd',
        'Closed Lost' => 'Afgesloten - Verloren',
        'Closed Dead' => 'Afgesloten - Geen resultaat',
        ],
        'default_order_stage_key' => 'Niet toegewezen',
        'order_stage_dom' => [
        'Pending' => 'Niet toegewezen',
        'Confirmed' => 'Bevestigd',
        'On Hold' => 'Uitgesteld',
        'Shipped' => 'Verzonden',
        'Cancelled' => 'Geannuleerd',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'Primaire besluitvormer',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primaire besluitvormer',
        'Business Decision Maker' => 'Zakelijke Beslisser',
        'Business Evaluator' => 'Zakelijke Evaluator',
        'Technical Decision Maker' => 'Technische Beslisser',
        'Technical Evaluator' => 'Technische Evaluator',
        'Executive Sponsor' => 'Eindverantwoordelijke',
        'Influencer' => 'Beïnvloeder',
        'Other' => 'Anders',
        ],
        'layouts_dom' => [
        'Standard' => 'Offerte',
        'Invoice' => 'Pro-forma Factuur',
        ],
        'issue_priority_default_key' => 'Middel',
        'issue_priority_dom' => [
        'Urgent' => 'Spoedeisend',
        'High' => 'Hoog',
        'Medium' => 'Middel',
        'Low' => 'Laag',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'Geaccepteerd',
        'Duplicate' => 'Dupliceren',
        'Closed' => 'Afgesloten',
        'Out of Date' => 'Verlopen',
        'Invalid' => 'Ongeldig',
        ],

        'issue_status_default_key' => 'Nieuw',
        'issue_status_dom' => [
        'New' => 'Nieuw',
        'Assigned' => 'Toegewezen',
        'Closed' => 'Afgesloten',
        'Pending' => 'Niet toegewezen',
        'Rejected' => 'Afgewezen',
        ],

        'bug_priority_default_key' => 'Middel',
        'bug_priority_dom' => [
        'Urgent' => 'Spoedeisend',
        'High' => 'Hoog',
        'Medium' => 'Middel',
        'Low' => 'Laag',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'Geaccepteerd',
        'Duplicate' => 'Dupliceren',
        'Fixed' => 'Fixed',
        'Out of Date' => 'Verlopen',
        'Invalid' => 'Ongeldig',
        'Later' => 'Later',
        ],
        'bug_status_default_key' => 'Nieuw',
        'bug_status_dom' => [
        'New' => 'Nieuw',
        'Assigned' => 'Toegewezen',
        'Closed' => 'Afgesloten',
        'Pending' => 'Niet toegewezen',
        'Rejected' => 'Afgewezen',
        ],
        'bug_type_default_key' => 'Bug',
        'bug_type_dom' => [
        'Defect' => 'Defect',
        'Feature' => 'Feature',
        ],
        'case_type_dom' => [
        'Administration' => 'Beheer',
        'Product' => 'Product',
        'User' => 'Gebruiker',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'E-mailadres',
        'Twitter' => 'Twitter',
        'Portal' => 'Portaal',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'E-mailadres',
        'Twitter' => 'Twitter',
        'Portal' => 'Portaal',
        'Phone' => 'Telefoon',
        'Chat' => 'Chat',
        'Chatbot' => 'Chatbot',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'Verzoek om beleid privacygegevens',
        'Send Personal Information being processed' => 'Persoonsgegevens worden verwerkt',
        'Rectify Information' => 'Informatie corrigeren',
        'Request to Erase Information' => 'Verzoek om informatie te wissen',
        'Export Information' => 'Informatie exporteren',
        'Restrict Processing' => 'Verwerken beperken',
        'Object to Processing' => 'Niet akkoord met verwerking',
        'Consent to Process' => 'Akkoord met verwerking',
        'Withdraw Consent' => 'Toestemming intrekken',
        'Other' => 'Anders',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'Zakelijke communicatie',
        'Marketing Communications by company' => 'Marketingcommunicatie door bedrijf',
        'Marketing Communications by partners' => 'Marketingcommunicatie door partners',
        ],
        'dataprivacy_status_default_key' => 'Maximaliseren',
        'dataprivacy_status_dom' => [
        'Open' => 'Maximaliseren',
        'Closed' => 'Afgerond',
        'Rejected' => 'Afgewezen',
        ],
        'dataprivacy_priority_default_key' => 'Laag',
        'dataprivacy_priority_dom' => [
        'Low' => 'Laag',
        'Medium' => 'Medium',
        'High' => 'Hoog',
        ],
        'business_day_status_dom' => [
        'Open' => 'Open',
        'Open 24 Hours' => 'Open 24 uur',
        'Closed' => 'Gesloten',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'Organisaties',
        'Activities' => 'Activiteiten',
        'Bug Tracker' => 'Bug Tracker',
        'Calendar' => 'Agenda',
        'Calls' => 'Telefoongesprekken',
        'Campaigns' => 'Campagnes',
        'Cases' => 'Cases',
        'Contacts' => 'Contactpersonen',
        'Currencies' => 'Valutas',
        'Dashboard' => 'Dashboard',
        'Documents' => 'Documenten',
        'Emails' => 'E-mail',
        'Feeds' => 'Nieuwsfeeds',
        'Forecasts' => 'Forecasts',
        'Help' => 'Help',
        'Home' => 'Start',
        'Leads' => 'Leads',
        'Meetings' => 'Afspraken',
        'Notes' => 'Notities',
        'Opportunities' => 'Opportunities',
        'Outlook Plugin' => 'Outlook Plugin',
        'Product Catalog' => 'Productcatalogus',
        'Products' => 'Geoffreerde producten',
        'RevenueLineItems' => 'Opportunityregels',
        'Projects' => 'Projecten',
        'Quotes' => 'Offertes',
        'Releases' => 'Releases',
        'RSS' => 'RSS',
        'Studio' => 'Studio',
        'Upgrade' => 'Upgrade',
        'Users' => 'Gebruikers',
        'OutboundEmail' => 'E-mailinstellingen',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'Planning',
        'Active' => 'Actief',
        'Inactive' => 'Inactief',
        'Complete' => 'Compleet',
        'In Queue' => 'In de wachtrij',
        'Sending' => 'Bezig met verzenden',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'Telesales',
        'Mail' => 'Post',
        'Email' => 'E-mailadres',
        'Print' => 'Afdrukken',
        'Web' => 'Web',
        'Radio' => 'Keuzerondje',
        'Television' => 'Televisie',
        'NewsLetter' => 'Nieuwsbrief',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'Wekelijks',
        'Monthly' => 'Maandelijks',
        'Quarterly' => 'Elk kwartaal',
        'Annually' => 'Jaarlijks',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'Januari',
        '2' => 'Februari',
        '3' => 'Maart',
        '4' => 'April',
        '5' => 'Mei',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'Augustus',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'December',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'Jan',
        '2' => 'Feb',
        '3' => 'Mrt',
        '4' => 'Apr',
        '5' => 'Mei',
        '6' => 'Jun',
        '7' => 'Jul',
        '8' => 'Aug',
        '9' => 'Sep',
        '10' => 'Okt',
        '11' => 'Nov',
        '12' => 'Dec',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'Zondag',
        '2' => 'Maandag',
        '3' => 'Dinsdag',
        '4' => 'Woensdag',
        '5' => 'Donderdag',
        '6' => 'Vrijdag',
        '7' => 'Zaterdag',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'Zon',
        '2' => 'Maa',
        '3' => 'Din',
        '4' => 'Woe',
        '5' => 'Don',
        '6' => 'Vrij',
        '7' => 'Zat',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'Zo',
        '2' => 'Ma',
        '3' => 'Di',
        '4' => 'Woe',
        '5' => 'Do',
        '6' => 'Vrij',
        '7' => 'Za',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'Zon',
        '1' => 'Maa',
        '2' => 'Din',
        '3' => 'Woe',
        '4' => 'Don',
        '5' => 'Vrij',
        '6' => 'Zat',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'am',
        'pm' => 'pm',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => 'Rijen en kolommen',
        'summary' => 'Totalen',
        'detailed_summary' => 'Totalen met details',
        'Matrix' => 'Matrix',
        ],


        'dom_email_types' => [
        'out' => 'Verzonden',
        'archived' => 'Gearchiveerd',
        'draft' => 'Concept',
        'inbound' => 'Inkomend',
        'campaign' => 'Campagne',
        ],
        'dom_email_status' => [
        'archived' => 'Gearchiveerd',
        'closed' => 'Afgesloten',
        'draft' => 'Concept',
        'read' => 'Gelezen',
        'replied' => 'Beantwoord',
        'sent' => 'Verzonden',
        'send_error' => 'Verzendfout',
        'unread' => 'Ongelezen',
        ],
        'dom_email_archived_status' => [
        'archived' => 'Gearchiveerd',
        ],

        'dom_email_server_type' => ['' => '--Geen--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--Geen--',
        'createcase' => 'Nieuwe case',
        'bounce' => 'Bounce Handling',
        ],
        'dom_email_distribution' => ['' => '--Geen--',
        'direct' => 'Direct Toewijzen',
        'roundRobin' => 'Round-Robin',
        'leastBusy' => 'Minst Bezet',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'Round-Robin',
        'leastBusy' => 'Minst Bezet',
        'none' => 'Geen',
        ],
        'dom_email_errors' => [1 => 'Selecteer maximaal 1 gebruiker tijdens het rechtstreeks toewijzen van items.',
        2 => 'Alleen geselecteerde items kunt u toewijzen tijdens het rechtstreeks toewijzen van items.',
        ],
        'dom_email_bool' => ['bool_true' => 'Ja',
        'bool_false' => 'Nee',
        ],
        'dom_int_bool' => [1 => 'Ja',
        0 => 'Nee',
        ],
        'dom_switch_bool' => ['on' => 'Ja',
        'off' => 'Nee',
        '' => 'Nee',],

        'dom_email_link_type' => ['sugar' => 'SugarCRM E-mail Client',
        'mailto' => 'Externe E-mail Client'],


        'dom_email_editor_option' => ['' => 'Standaard E-mail Format',
        'html' => 'HTML E-mail',
        'plain' => 'Platte tekst E-mail'],

        'schedulers_times_dom' => ['not run' => 'De aanvangsttijd ligt in het verleden, taak niet uitgevoerd.',
        'ready' => 'Gereed',
        'in progress' => 'In Bewerking',
        'failed' => 'Mislsukt',
        'completed' => 'Afgerond',
        'no curl' => 'Niet Uitgevoerd: Geen cURL beschikbaar',
        ],

        'dom_email_states' => [
        'Draft' => 'Concept',
        'Archived' => 'Gearchiveerd',
        ],

        'dom_email_direction' => [
        'Unknown' => 'Onbekend',
        'Outbound' => 'Uitgaand',
        'Inbound' => 'Inkomend',
        'Internal' => 'Intern',
        ],

        'scheduler_status_dom' => [
        'Active' => 'Actief',
        'Inactive' => 'Inactief',
        ],

        'scheduler_period_dom' => [
        'min' => 'Minuten',
        'hour' => 'Uren',
        ],
        'forecast_type_dom' => [
        'Direct' => 'Direct',
        'Rollup' => 'Samenstellen',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'Marketing',
        'Knowledge Base' => 'Knowledge Base',
        'Sales' => 'Verkoop',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'Marketingmateriaal',
        'Product Brochures' => 'Productbrochures',
        'FAQ' => 'FAQ',
        ],

        'document_status_dom' => [
        'Active' => 'Actief',
        'Draft' => 'Concept',
        'FAQ' => 'FAQ',
        'Expired' => 'Verlopen',
        'Under Review' => 'Onder revisie',
        'Pending' => 'Niet toegewezen',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'Mail samenvoegen',
        'eula' => 'EULA',
        'nda' => 'NDA',
        'license' => 'Licentieovereenkomst',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'Accepteer',
        'decline' => 'Afwijzen',
        'tentative' => 'Onder voorbehoud',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'Geaccepteerd',
        'decline' => 'Afgewezen',
        'tentative' => 'Onder voorbehoud',
        'none' => 'Geen',
        ],
        'dataset_output_default_dom' => [
        'table' => 'Tabel',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'Enkele Module',
        'Multi Module' => 'Meer Modules',
        ],
        'report_align_dom' => [
        'left' => 'Links',
        'center' => 'Midden',
        'right' => 'Rechts',
        ],

        'width_type_dom' => [
        '%' => 'Procent (%)',
        'px' => 'Pixels (px)',
        ],
        'report_color_dom' => [
        '' => 'Standaard',
        'black' => 'Zwart',
        'green' => 'Groen',
        'blue' => 'Blauw',
        'red' => 'Rood',
        'white' => 'Wit',
        'DarkGreen' => 'Donkergroen',
        'LightGray' => 'Lichtgrijs',
        'DodgerBlue' => 'Donkerblauw',
        'LightBlue' => 'Lichtblauw',
        ],
        'font_size_dom' => [
        '-5' => 'Kleiner (-5)',
        '-4' => 'Kleiner (-4)',
        '-3' => 'Kleiner (-3)',
        '-2' => 'Kleiner (-2)',
        '-1' => 'Kleiner (-1)',
        'Default' => 'Standaard',
        '1' => 'Groter (+1)',
        '2' => 'Groter (+2)',
        '3' => 'Groter (+3)',
        '4' => 'Groter (+4)',
        '5' => 'Groter (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'Hoofdquery',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'Tonen',
//  'Group By' => 'Group By',
        'Calculation' => 'Berekening',
        ],
        'query_display_type_dom' => [
        'Default' => 'Standaard',
        'Custom' => 'Aangepast',
        'Hidden' => 'Verborgen',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'Dag',
        'Week' => 'Week',
        'Month' => 'Maand',
        'Quarter' => 'Kwartaal',
        'Year' => 'Jaar',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'Nu',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'SOM',
        'AVG' => 'GEM',
        'COUNT' => 'Aantal',
        'STDDEV' => 'Standaard Deviatie',
        'VARIANCE' => 'Variantie',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'Standaard veld',
        'Time' => 'Tijdsinterval',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'Rijen (Y-As)',
        'Columns' => 'Kolommen (X-As)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'Som (Totaal)',
        'AVG' => 'Gemiddelde',
        'MAX' => 'Maximum',
        'MIN' => 'Minimum',
        'COUNT' => 'Aantal',
        'STDDEV' => 'Standaard Deviatie',
        'VARIANCE' => 'Variantie',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'Standaard',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'Berekenen',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'Veld',
        'Value' => 'Waarde',
        'Group' => 'Groep',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'Kolom',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'Uitgeschakeld',
        'Enabled' => 'Ingeschakeld',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'Normaal',
        'Scalar' => 'Scalair',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'Tekst',
        'Accounting' => 'Boekhoudkundig',
        'Date' => 'Datum:',
        'Datetime' => 'Datum tijd',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'Jaar',
        'Quarter' => 'Kwartaal',
        'Month' => 'Maand',
        'Week' => 'Week',
        'Day' => 'Dag',
        ],
        'dataset_style_dom' => [
        'normal' => 'Normaal',
        'bold' => 'Vet',
        'italic' => 'Schuin',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) Plus',
        '-' => '(-) Min',
        '*' => '(X) Vermenigvuldigd met',
        '/' => '(/) Gedeeld door',
        ],
        'wflow_type_dom' => [
        'Normal' => 'Wanneer het record opgeslagen wordt',
        'Time' => 'Na een bepaalde tijd',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Is',
        'in' => 'Is één van',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'Is één van',
        'not_in' => 'Is niet één van',
        ],
        'cselect_type_dom' => [
        'Equals' => 'Gelijk aan',
        'Does not Equal' => 'Ongelijk aan',
        ],
        'dselect_type_dom' => [
        'Equals' => 'Gelijk aan',
        'Less Than' => 'Kleiner dan',
        'More Than' => 'Meer dan',
        'Does not Equal' => 'Is niet gelijk aan',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'Ja',
        'bool_false' => 'Nee',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'Gelijk aan',
        ],
        'tselect_type_dom' => [
        '0' => '0 uur',
        '14440' => '4 uren',
        '28800' => '8 uren',
        '43200' => '12 uren',
        '86400' => '1 dag',
        '172800' => '2 dagen',
        '259200' => '3 dagen',
        '345600' => '4 dagen',
        '432000' => '5 dagen',
        '604800' => '1 week',
        '1209600' => '2 weken',
        '1814400' => '3 weken',
        '2592000' => '30 dagen',
        '5184000' => '60 dagen',
        '7776000' => '90 dagen',
        '10368000' => '120 dagen',
        '12960000' => '150 dagen',
        '15552000' => '180 dagen',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'was meer dan',
        'Less Than' => 'is kleiner dan',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'E-mailadres',
        'Invite' => 'Uitnodigen',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'Normaal Bericht',
        'Custom Template' => 'Aangepaste sjabloon',
        'System Default' => 'Standaardinstelling',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'Huidige gebruikers',
        'rel_user' => 'Gerelateerde gebruikers',
        'rel_user_custom' => 'Gerelateerde aangepaste gebruiker',
        'specific_team' => 'Specifiek team',
        'specific_role' => 'Specifieke rol',
        'specific_user' => 'Specifieke gebruiker',
        ],
        'wflow_array_type_dom' => [
        'future' => 'Nieuwe Waarde',
        'past' => 'Oude Waarde',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'Gebruiker',
        'Manager' => "Manager van de gebruiker",
        ],
        'wflow_address_type_dom' => [
        'to' => 'Aan:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'Aan:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        'invite_only' => '(Alleen uitnodigen)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'Aan:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'Record bijwerken',
        'update_rel' => 'Gerelateerd record bijwerken',
        'new' => 'Nieuw record',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'Getriggerde datum',
        'Existing Value' => 'Bestaande waarde',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'Standaard opties',
        'Advanced' => 'Geavanceerde opties',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'Gebruiker toegewezen aan getriggerd record',
        'modified_user_id' => 'Gebruiker die getriggerd record het laatste heeft gewijzigd',
        'created_by' => 'Gebruiker die getriggerde records heeft gemaakt',
        'current_user' => 'Ingelogde gebruiker',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'Huidig team van getriggerd record',
        'team_set_id' => 'Huidige Team Set van geactiveerde Record',
        'current_team' => 'Team van ingelogde gebruiker',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'Beweeg dropdown achteruit met',
        'advance' => 'Beweeg dropdown vooruit met',
        ],
        'wflow_record_type_dom' => [
        'All' => 'Nieuwe en bijgewerkte records',
        'New' => 'Alleen nieuwe records',
        'Update' => 'Alleen bijgewerkte records',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'Alle gerelateerde',
        //'first' => 'The first related',
        'filter' => 'Filter gerelateerde',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'Alle gerelateerde',
        'any' => 'Elke gerelateerde',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'Meldingen dan acties',
        'actions_alerts' => 'Acties dan meldingen'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'Geen',
        'Daily' => 'Dagelijks',
        'Weekly' => 'Wekelijks',
        'Monthly' => 'Maandelijks',
        'Yearly' => 'Jaarlijks',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'Dagen',
        'Weekly' => 'We(e)k(en)',
        'Monthly' => 'Maand(en)',
        'Yearly' => 'Ja(a)r(en)',
        ],

        'repeat_end_types' => [
        'Until' => 'Tot',
        'Occurrences' => 'Resultaten',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'Geen',
        'Each' => 'Elke',
        'On' => 'Op de',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'eerste',
        'second' => 'tweede',
        'third' => 'derde',
        'fourth' => 'vierde',
        'fifth' => 'vijfde',
        'last' => 'laatste',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'Zondag',
        'Mon' => 'Maandag',
        'Tue' => 'Dinsdag',
        'Wed' => 'Woensdag',
        'Thu' => 'Donderdag',
        'Fri' => 'Vrijdag',
        'Sat' => 'Zaterdag',
        'Day' => 'Dag',
        'WD' => 'Werkdag',
        'WE' => 'Weekend',
        ],

        'duration_dom' => [
        '' => 'Geen',
        '900' => '15 minuten',
        '1800' => '30 minuten',
        '2700' => '45 minuten',
        '3600' => '1 uur',
        '5400' => '1,5 uur',
        '7200' => '2 uren',
        '10800' => '3 uren',
        '21600' => '6 uren',
        '86400' => '1 dag',
        '172800' => '2 dagen',
        '259200' => '3 dagen',
        '604800' => '1 week',
        ],
        'repeat_month_dom' => [
        '1' => 'Januari',
        '2' => 'Februari',
        '3' => 'Maart',
        '4' => 'April',
        '5' => 'Mei',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'Augustus',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'December',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'Standaard',
        'seed' => 'Seed',
        'exempt_domain' => 'Suppression List - Per Domein',
        'exempt_address' => 'Suppression List - Per E-mailadres',
        'exempt' => 'Suppression List - Per Id',
        'test' => 'Test [ALT+T]',
        ],
        'currency_status_dom' => [
        'Active' => 'Actie',
        'Inactive' => 'Inactief',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'Actief',
        'inactive' => 'Inactief',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'Berichten verstuurd/gepoogd',
        'send error' => 'Bounced, reden onbekend',
        'invalid email' => 'Bounced, ongeldig e-mailadres',
        'link' => 'Link aangeklikt',
        'viewed' => 'E-mail bekeken',
        'removed' => 'Afgemeld',
        'lead' => 'Leads aangemaakt',
        'contact' => 'Personen aangemaakt',
        'blocked' => 'Suppressed per adres of domein',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'Contactpersonen',
        'Users' => 'Gebruikers',
        'Prospects' => 'Targets',
        'Leads' => 'Leads',
        'Accounts' => 'Organisaties',
        ],
        'merge_operators_dom' => [
        'like' => 'Bevat',
        'exact' => 'Exact',
        'start' => 'Begint met',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'Ja',
        'false' => 'Nee',
        'required' => 'Vereist',
        ],

        'fts_field_config' => [
        '0' => 'Uitgeschakeld',
        '2' => 'Doorzoekbaar',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'Uitgeschakeld',
        1 => 'Ingeschakeld',
        2 => 'In filter',
        3 => 'Standaard geselecteerd filter',
        4 => 'Alleen filter',
        ],

        'navigation_paradigms' => [
        'm' => 'Modules',
        'gm' => 'Gegroepeerde modules',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'Niet gestart',
        'inprogress' => 'In Bewerking',
        'signed' => 'Ondertekend',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'Maandelijks',
        'quarterly' => 'Elk kwartaal',
        'halfyearly' => 'Half jaarlijks',
        'yearly' => 'Jaarlijks',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 Dag',
        '3' => '3 Dagen',
        '5' => '5 Dagen',
        '7' => '1 Week',
        '14' => '2 Weken',
        '21' => '3 Weken',
        '31' => '1 Maand',
        ],
        'projects_priority_options' => [
        'high' => 'Hoog',
        'medium' => 'Middel',
        'low' => 'Laag',
        ],

        'projects_status_options' => [
        'notstarted' => 'Niet gestart',
        'inprogress' => 'In Bewerking',
        'completed' => 'Afgerond',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'Legenda uitvouwen',
        'collapselegend' => 'Legenda samenvouwen',
        'clickfordrilldown' => 'Klik om in te zoomen',
        'drilldownoptions' => 'Zoom opties',
        'detailview' => 'Meer details...',
        'piechart' => 'Taartdiagram',
        'groupchart' => 'Groep tabel',
        'stackedchart' => 'Stapeldiagram',
        'barchart' => 'Balkgrafiek',
        'horizontalbarchart' => 'Horizontale balkgrafiek',
        'linechart' => 'Lijngrafiek',
        'noData' => 'Gegevens niet beschikbaar',
        'print' => 'Afdrukken',
        'pieWedgeName' => 'Secties',
        ],
        'chart_types' => [
        'hBarF' => 'Horizontale balk (gestapeld)',
        'hGBarF' => 'Horizontale balk (gegroepeerd)',
        'vBarF' => 'Verticale balk (gestapeld)',
        'vGBarF' => 'Verticale balk (gegroepeerd)',
        'pieF' => 'Cirkel',
        'funnelF' => 'Trechter',
        'lineF' => 'Regel',
        'donutF' => 'Donut',
        'treemapF' => 'Boomdiagram',
        ],
        'd3_value_placement' => [
        '0' => 'Geen',
        '1' => 'Standaard',
        'start' => 'Startdatum',
        'middle' => 'Midden',
        'end' => 'Einde',
        'top' => 'Boven',
        'total' => 'Totaal',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'Trechter',
        'hbar' => 'Horizontale staaf',
        ],
        'release_status_dom' => [
        'Active' => 'Actief',
        'Inactive' => 'Inactief',
        ],
        'email_settings_for_ssl' => [
        '0' => 'Geen',
        '1' => 'TLS',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange online',
        'outlook' => 'Outlook',
        'google' => 'Google minder veilige apps',
        'exchange' => 'Exchange',
        'other' => 'Anders',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange online',
        'other' => 'Anders',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'Enkele Quote (&#39;)',
        '"' => 'Dubbele Quote (")',
        '' => 'Geen',
        'other' => 'Anders:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'Anders:',
        ],
        'link_target_dom' => [
        '_blank' => 'Nieuw venster',
        '_self' => 'Zelfde venster',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'Geen auto-refresh',
        '30' => 'Elke 30 seconden',
        '60' => 'Elke minuut',
        '180' => 'Elke 3 minuten',
        '300' => 'Elke 5 minuten',
        '600' => 'Elke 10 minuten',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'Geen',
        '15' => 'Iedere 15 minuten',
        '30' => 'Iedere 30 minuten',
        '45' => 'Iedere 45 minuten',
        '60' => 'Ieder uur',
        '120' => 'Elke 2 uur',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'Nooit',
        '30' => 'Elke 30 seconden',
        '60' => 'Elke minuut',
        '180' => 'Elke 3 minuten',
        '300' => 'Elke 5 minuten',
        '600' => 'Elke 10 minuten',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'Geen',
        '1' => 'Elke minuut',
        '5' => 'Elke 5 minuten',
        '10' => 'Elke 10 minuten',
        '15' => 'Iedere 15 minuten',
        '30' => 'Iedere 30 minuten',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'Gelijk aan',
        'not_equal' => 'Niet op',
        'greater_than' => 'Na',
        'less_than' => 'Voor',
        'last_7_days' => 'Afgelopen 7 dagen',
        'next_7_days' => 'Volgende 7 dagen',
        'last_30_days' => 'Afgelopen 30 dagen',
        'next_30_days' => 'Komende 30 dagen',
        'last_month' => 'Vorige maand',
        'this_month' => 'Huidige maand',
        'next_month' => 'Volgende maand',
        'last_year' => 'Vorig jaar',
        'this_year' => 'Huidig jaar',
        'next_year' => 'Volgend jaar',
        'between' => 'Tussen',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'Vorig jaar',
        'last_month' => 'Vorige maand',
        'last_30_days' => 'Afgelopen 30 dagen',
        'last_7_days' => 'Afgelopen 7 dagen',
        'this_month' => 'Huidige maand',
        'this_year' => 'Huidig jaar',
        'next_7_days' => 'Volgende 7 dagen',
        'next_30_days' => 'Komende 30 dagen',
        'next_month' => 'Volgende maand',
        'next_year' => 'Volgend jaar',
        ],
        'numeric_range_search_dom' => [
        '=' => 'Gelijk aan',
        'not_equal' => 'Ongelijk aan',
        'greater_than' => 'Groter dan',
        'greater_than_equals' => 'Groter dan of gelijk aan',
        'less_than' => 'Kleiner dan',
        'less_than_equals' => 'Kleiner dan of gelijk aan',
        'between' => 'Tussen',
        ],

        'filter_checkbox_dom' => [
        0 => 'Onwaar',
        1 => 'Waar',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'Gewonnen',
        'lost' => 'Verloren',
        'active' => 'Actief',
        ],

        'sweetspot_theme_options' => [
        'default' => 'Standaard',
        'light' => 'Licht',
        'dark' => 'Donker',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'Verplaatsen',
        'donothing' => 'Doe niets',
        ],
        'processes_auto_save_interval' => [
        0 => 'Nooit',
        30000 => 'Elke 30 seconden',
        60000 => 'Elke minuut',
        120000 => 'Elke 2 minuten',
        180000 => 'Elke 3 minuten',
        240000 => 'Elke 4 minuten',
        300000 => 'Elke 5 minuten',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nee',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'Meenemen in forecast',
        'sales_stage' => 'Verkoopstadium',
        'probability' => 'Waarschijnlijkheid',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'Meest waarschijnlijk',
        'best' => 'Beste',
        'worst' => 'Slechtste',
        ],
        'webLogicHookList' => [
        'after_save' => 'Na opslag',
        'after_delete' => 'Na verwijderen',
        'after_relationship_add' => 'Na toevoegen relatie',
        'after_relationship_delete' => 'Na verwijderen relatie',
        'after_login' => 'Na inloggen',
        'after_logout' => 'Na uitloggen',
        'after_login_failed' => 'Na mislukte inlog poging',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'Ingeschakeld',
        'INACTIVE' => 'Uitgeschakeld',
        ],
        'dashboard_view_name_list' => [
        'record' => 'Record',
        'records' => 'Lijst',
        'activities' => 'Activity Stream',
        'multi-line' => 'Lijst met meerdere regels',
        'omnichannel' => 'Meerkanaals',
        'home' => 'Home',
        'focus' => 'Focus drawer',
        ],
        'metric_context_list' => [
        'service_console' => 'Serviceconsole',
        'renewals_console' => 'Vernieuwingenconsole',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'Elk uur',
        '21600' => 'Elke 6 uren',
        '43200' => 'Elke 12 uren',
        '86400' => 'Dagelijks',
        '604800' => 'Wekelijks',
        '1209600' => 'Elke 2 weken',
        '2419200' => 'Elke 4 weken',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'Jaar',
        'month' => 'Maand(en)',
        'day' => 'Dag(en)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'Tijd uit',
        'event' => 'Gebeurtenis',
        'other' => 'Anders',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'Datum (laatste {{module}})',
        'start_date:asc' => 'Datum (eerste {{module}})',
        'total_revenue:desc' => 'Prijs (hoogste totaal)',
        'total_revenue:asc' => 'Prijs (laagste totaal)',
        ],
        'calendar_type_list' => [
        'main' => 'Midden agenda',
        ],
        'calendar_views_options' => [
        'day' => 'Dag',
        'week' => 'Week',
        'workWeek' => 'Werkweek',
        'expandedMonth' => 'Maand',
        'agenda' => 'Agenda',
        'timeline' => 'Tijdlijn',
        'monthSchedule' => 'Planner',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'Aangemaakt',
        'completed' => 'Afgerond',
        'declined' => 'Afgewezen',
        'delivered' => 'Afgeleverd',
        'sent' => 'Verzonden',
        'signed' => 'Ondertekend',
        'voided' => 'Ongeldig gemaakt',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'Lijst met potentiële ontvangers weergeven',
        'dont_show' => 'Potentiële ontvangers niet tonen',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'Ondertekenaar',
        'carbon_copy' => 'Kijker (carbon copy)',
        'certified_delivery' => 'Kijker (gecertificeerde levering)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'Standaard',
        'color' => 'Kleur',
        'image' => 'Afbeelding',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'Afkorting',
        'icon' => 'Icoon',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'Pijl-omlaag',
        'sicon-chevron-left' => 'Punthaak naar links',
        'sicon-check' => 'Checken',
        'sicon-clock' => 'Klok',
        'sicon-dashboard-default' => 'Standaard dashboard',
        'sicon-dashboard' => 'Dashboard',
        'sicon-edit' => 'Bewerken',
        'sicon-caret-down' => 'Inlasteken-omlaag',
        'sicon-folder' => 'Map',
        'sicon-info' => 'Info',
        'sicon-kebab' => 'Kebab',
        'sicon-link' => 'Link',
        'sicon-list' => 'Lijst',
        'sicon-logout' => 'Uitloggen',
        'sicon-minus' => 'Minus',
        'sicon-folder-open' => 'Map open',
        'sicon-plus-sm' => 'Plus Sm',
        'sicon-refresh' => 'Vernieuwen',
        'sicon-plus' => 'Plus',
        'sicon-settings' => 'Instellingen',
        'sicon-arrow-right-double' => 'Dubbele pijl naar rechts',
        'sicon-reports' => 'Rapporten',
        'sicon-user' => 'Gebruiker',
        'sicon-upload' => 'Uploaden',
        'sicon-user-group' => 'Gebruikersgroep',
        'sicon-arrow-left-double' => 'Dubbele pijl naar links',
        'sicon-chevron-up' => 'Punthaak-omhoog',
        'sicon-caret-up' => 'Inlasteken-omhoog',
        'sicon-star-fill' => 'Vullen van sterren',
        'sicon-download' => 'Downloaden',
        'sicon-close' => 'Sluiten',
        'sicon-tile-view' => 'Tegelweergave',
        'sicon-list-view' => 'Lijstweergave',
        'sicon-thumbs-down' => 'Duim-omlaag',
        'sicon-warning-circle' => 'Waarschuwingscirkel',
        'sicon-phone' => 'Telefoon',
        'sicon-email' => 'E-mail',
        'sicon-document' => 'Document',
        'sicon-note' => 'Notitie',
        'sicon-preview' => 'Voorvertoning',
        'sicon-copy' => 'Kopiëren',
        'sicon-launch' => 'Starten',
        'sicon-lock' => 'Vergrendelen',
        'sicon-arrow-top-right' => 'Pijl naar rechtsboven',
        'sicon-full-screen' => 'Volledig scherm',
        'sicon-full-screen-exit' => 'Volledig scherm verlaten',
        'sicon-expand-left' => 'Links uitvouwen',
        'sicon-expand-right' => 'Rechts uitvouwen',
        'sicon-focus-drawer' => 'Focus Drawer',
        'sicon-ban' => 'Uitsluiten',
        'sicon-thumbs-up' => 'Duim-omhoog',
        'sicon-search' => 'Zoeken',
        'sicon-calendar' => 'Agenda',
        'sicon-calendar-lg' => 'Agenda Lg',
        'sicon-mobile-lg' => 'Mobiel Lg',
        'sicon-star-fill-lg' => 'Vullen van sterren Lg',
        'sicon-star-outline-lg' => 'Contour van sterren Lg',
        'sicon-reset-lg' => 'Resetten Lg',
        'sicon-exchange-lg' => 'Exchange Lg',
        'sicon-help-lg' => 'Hulp Lg',
        'sicon-close-lg' => 'Sluiten Lg',
        'sicon-plus-lg' => 'Plus Lg',
        'sicon-shortcuts-lg' => 'Sneltoetsen Lg',
        'sicon-search-lg' => 'Zoeken Lg',
        'sicon-email-lg' => 'E-mail Lg',
        'sicon-note-lg' => 'Notitie Lg',
        'sicon-document-lg' => 'Document Lg',
        'sicon-add-dashlet-lg' => 'Dashlet toevoegen Lg',
        'sicon-collapse-lg' => 'Inklappen Lg',
        'sicon-hamburger-lg' => 'Hamburger Lg',
        'sicon-pin-fill-lg' => 'Pin vullen Lg',
        'sicon-expand-lg' => 'Uitklappen Lg',
        'sicon-copy-lg' => 'Kopiëren Lg',
        'sicon-dashboard-lg' => 'Dashboard Lg',
        'sicon-star-outline' => 'Contour van sterren',
        'sicon-reset' => 'Resetten',
        'sicon-unlink' => 'Loskoppelen',
        'sicon-phone-lg' => 'Telefoon Lg',
        'sicon-attach' => 'Bijvoegen',
        'sicon-case-lg' => 'Case Lg',
        'sicon-arrow-right-lg' => 'Pijl naar rechts Lg',
        'sicon-check-circle-lg' => 'Cirkel aanvinken Lg',
        'sicon-text-formatting' => 'Tekstopmaak',
        'sicon-check-circle' => 'Cirkel aanvinken Lg',
        'sicon-upload-lg' => 'Uploaden Lg',
        'sicon-flag-lg' => 'Met een vlaggetje markeren Lg',
        'sicon-studio-lg' => 'Studio Lg',
        'sicon-contact-lg' => 'Contacten Lg',
        'sicon-edit-lg' => 'Bewerken Lg',
        'sicon-arrow-left' => 'Pijl naar links',
        'sicon-reply-all' => 'Allen beantwoorden',
        'sicon-message-lg' => 'Bericht Lg',
        'sicon-info-lg' => 'Info Lg',
        'sicon-error-lg' => 'Fout Lg',
        'sicon-check-circle-line-lg' => 'Cirkelregel checken Lg',
        'sicon-warning-line-lg' => 'Waarschuwingsregel Lg',
        'sicon-arrow-up' => 'Pijl-omhoog',
        'sicon-arrow-right' => 'Pijl naar rechts',
        'sicon-nodes' => 'Knooppunten',
        'sicon-hide' => 'Verbergen',
        'sicon-help' => 'Hulp',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'Bericht',
        'sicon-sugar-predict-lg' => 'Sugar Predict Lg',
        'sicon-sugar-predict' => 'Sugar Predict',
        'sicon-opportunity-lg' => 'Opportunity Lg',
        'sicon-lead-lg' => 'Lead Lg',
        'sicon-account-lg' => 'Account Lg',
        'sicon-user-sm' => 'Gebruiker Sm',
        'sicon-quote-lg' => 'Offerte Lg',
        'sicon-equal' => 'Gelijk',
        'sicon-slicers-xl' => 'Slicers Xl',
        'sicon-escalation-lg' => 'Escalatie Lg',
        'sicon-add-circle-lg' => 'Cirkel toevoegen Lg',
        'sicon-add-line-lg' => 'Regel toevoegen Lg',
        'sicon-add-target-lg' => 'Target toevoegen Lg',
        'sicon-help-circle-lg' => 'Helpcirkel Lg',
        'sicon-divide-line-lg' => 'Regel delen Lg',
        'sicon-string' => 'Tekenreeks',
        'sicon-filter' => 'Filter',
        'sicon-number' => 'Nummer',
        'sicon-format-lg' => 'Indeling Lg',
        'sicon-insights-lg' => 'Inzichten Lg',
        'sicon-invalid-circle-lg' => 'Ongeldige cirkel Lg',
        'sicon-layout-xl' => 'Lay-out Xl',
        'sicon-layout-lg' => 'Lay-out Lg',
        'sicon-multiply-line-lg' => 'Vermenigvuldigingsregel Lg',
        'sicon-redo-lg' => 'Opnieuw Lg',
        'sicon-refresh-lg' => 'Vernieuwen Lg',
        'sicon-undo-lg' => 'Ongedaan maken Lg',
        'sicon-activity-feed-xl' => 'Activiteitenfeed Xl',
        'sicon-chevron-left-xl' => 'Punthaak naar links Xl',
        'sicon-close-xl' => 'Sluiten Xl',
        'sicon-kebab-lg' => 'Kebab Lg',
        'sicon-insights-xl' => 'Inzichten Xl',
        'sicon-hide-lg' => 'Verbergen Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => 'Opmerking Xl',
        'sicon-share-lg' => 'Delen Lg',
        'sicon-trash' => 'Prullenbak',
        'sicon-launch-lg' => 'Lanceren Lg',
        'sicon-thumbs-up-lg' => 'Duim-omhoog Lg',
        'sicon-thumbs-down-lg' => 'Duim-omlaag Lg',
        'sicon-warning-lg' => 'Waarschuwing Lg',
        'sicon-wizard-circle-xl' => 'Assistentcirkel Xl',
        'sicon-bell-cross-lg' => 'Klokkenkruis Lg',
        'sicon-bell-lg' => 'Klok Lg',
        'sicon-daily-lg' => 'Dagelijks Lg',
        'sicon-cloud-download-lg' => 'Clouddownload Lg',
        'sicon-unlock' => 'Ontgrendelen',
        'sicon-news-lg' => 'Nieuws Lg',
        'sicon-weekly-lg' => 'Wekelijks Lg',
        'sicon-knowledgebase-xl' => 'Kennisbank Xl',
        'sicon-remove' => 'Verwijderen',
        'sicon-chevron-down' => 'Punthaak-omlaag',
        'sicon-slicers-lg' => 'Slicers Lg',
        'sicon-save-lg' => 'Opslaan Lg',
        'sicon-info-circle-lg' => 'Infocirkel Lg',
        'sicon-chevron-right' => 'Punthaak naar rechts',
        'sicon-warning-circle-lg' => 'Waarschuwingscirkel Lg',
        'sicon-right-paren-line-lg' => 'Regel van rechterhaakje Lg',
        'sicon-comment-lg' => 'Opmerking Lg',
        'sicon-target-lg' => 'Target Lg',
        'sicon-subtract-line-lg' => 'Regel van aftrekken Lg',
        'sicon-settings-lg' => 'Instellingen Lg',
        'sicon-left-paren-line-lg' => 'Regel van linkerhaakje Lg',
        'sicon-preview-lg' => 'Voorvertoning Lg',
        'sicon-thumbs-down-line-lg' => 'Regel van duim-omlaag Lg',
        'sicon-thumbs-up-line-lg' => 'Regel van duim-omhoog Lg',
        'sicon-send-lg' => 'Sturen Lg',
        'sicon-contact-xl' => 'Contact Xl',
        'sicon-wizard-circle-line-xl' => 'Regel van assistentcirkel Xl',
        'sicon-trash-lg' => 'Prullenbak Lg',
        'sicon-pin-lg' => 'Pin Lg',
        'sicon-clock-lg' => 'Klok Lg',
        'sicon-comment-line-xl' => 'Opmerkingsregel Xl',
        'sicon-dropdown-editor' => 'Dropdown-editor',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'Bug',
        'sicon-catalog' => 'Catalogus',
        'sicon-cloud' => 'Cloud',
        'sicon-config-api' => 'Config Api',
        'sicon-config-nav' => 'Config Nav',
        'sicon-connectors' => 'Connectoren',
        'sicon-contracts' => 'Contracten',
        'sicon-currencies' => 'Valuta&#39;s',
        'sicon-diagnostics' => 'Statistieken',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'E-mailcampagne',
        'sicon-email-inbound' => 'Inkomende e-mails',
        'sicon-email-queue' => 'Wachtrij voor e-mails',
        'sicon-forecasts' => 'Forecasts',
        'sicon-display-modules' => 'Weergavemodules',
        'sicon-email-contacts' => 'E-mail-contacten',
        'sicon-import' => 'Importeren',
        'sicon-log-viewer' => 'Log Viewer',
        'sicon-lab' => 'Lab',
        'sicon-map-pin' => 'Kaartpin',
        'sicon-manufacturers' => 'Fabrikanten',
        'sicon-update' => 'Updaten',
        'sicon-content-security' => 'Contentbeveiliging',
        'sicon-module-builder' => 'Modulebouwer',
        'sicon-languages' => 'Talen',
        'sicon-module-loader' => 'Modulelader',
        'sicon-oauth-key' => 'OAuth-sleutel',
        'sicon-password-mgmt' => 'Wachtwoord Mgmt',
        'sicon-opportunities' => 'Opportunities',
        'sicon-upgrade' => 'Upgraden',
        'sicon-portal' => 'Portaal',
        'sicon-product-types' => 'Producttypen',
        'sicon-quotes' => 'Offertes',
        'sicon-relate-fields' => 'Soortgelijke velden',
        'sicon-repair' => 'Repareren',
        'sicon-role-mgmt' => 'Rol Mgmt',
        'sicon-scheduler' => 'Planner',
        'sicon-shippers' => 'Expediteurs',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'Web Logic',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'Btw-tarieven',
        'sicon-team-mgmt' => 'Team Mgmt',
        'sicon-team-perm' => 'Team Perm',
        'sicon-tracker' => 'Tracker',
        'sicon-workflow' => 'Workflow',
        'sicon-mask' => 'Masker',
        'sicon-mask-disabled' => 'Masker uitgeschakeld',
        'sicon-email-archive' => 'E-mail-archief',
        'sicon-mobile' => 'Mobiel',
        'sicon-archive' => 'Archiveren',
        'sicon-automate-scroll' => 'Verticale scrollweergave',
        'sicon-automate-stacked' => 'Horizontale scrollweergave',
        'sicon-pdf-manager' => 'Pdf-beheerder',
        'sicon-my-sites' => 'Mijn sites',
        'sicon-cloud-insights' => 'Cloudinzichten',
        'sicon-sugar-logo-24' => 'Sugar-logo 24',
        'sicon-sugar-logo-16' => 'Sugar-logo 16',
        'sicon-task-lg' => 'Taak Lg',
        'sicon-web-lg' => 'Web Lg',
        'sicon-events-lg' => 'Gebeurtenissen Lg',
        'sicon-sugar-logo-12' => 'Sugar-logo 12',
        'sicon-tag' => 'Tag',
        'sicon-tag-lg' => 'Tag Lg',
        'sicon-bell-lg-line' => 'Klokregel Lg',
        'sicon-matrix-xxl' => 'Matrix Xxl',
        'sicon-advanced-filter' => 'Geavanceerd filter',
        'sicon-rows-and-columns-xxl' => 'Rijen en kolommen Xxl',
        'sicon-summation-details-xxl' => 'Totaalgegevens Xxl',
        'sicon-summation-xxl' => 'Totaal Xxl',
        'sicon-lock-lg' => 'Vergrendelen Lg',
        'sicon-csv-file-xxl' => 'Csv-bestand Xxl',
        'sicon-logo-linkedin' => 'Linkedin-logo',
        'sicon-briefcase' => 'Aktetas',
        'sicon-car-front' => 'Voorkant van auto',
        'sicon-airplane' => 'Vliegtuig',
        'sicon-laptop' => 'Laptop',
        'sicon-logo-instagram' => 'Instagram-logo',
        'sicon-single-bed' => 'Eenpersoonsbed',
        'sicon-tiktok' => 'TikTok',
        'sicon-logo-snapchat' => 'Snapchat-logo',
        'sicon-video-lg' => 'Video Lg',
        'sicon-reply' => 'Beantwoorden',
        'sicon-subtract' => 'Aftrekken',
        'sicon-arrow-up-circle-line' => 'Cirkelregel met pijl-omhoog',
        'sicon-asterisk' => 'Sterretje',
        'sicon-dot-circle-o-lg' => 'Puntcirkel 0 Lg',
        'sicon-forward' => 'Doorsturen',
        'sicon-video' => 'Video',
        'sicon-gavel' => 'Hamer',
        'sicon-login' => 'Inloggen',
        'sicon-pdf-file-xxl' => 'Pdf-bestand Xxl',
        'sicon-login-lg' => 'Inloggen Lg',
        'sicon-cloud-download-xl' => 'Clouddownload Xl',
        'sicon-campaigns-lg' => 'Campagnes Lg',
        'sicon-customer-journey-stages-lg' => 'Fasen in klantreis Lg',
        'sicon-role-mgmt-lg' => 'Rol Mgmt Lg',
        'sicon-default-module-lg' => 'Standaard module Lg',
        'sicon-quoted-line-items-lg' => 'Geoffreerde regelitems Lg',
        'sicon-projects-lg' => 'Projecten Lg',
        'sicon-process-business-rules-lg' => 'Proces bedrijfsregels Lg',
        'sicon-process-email-templates-lg' => 'Proces e-mailsjablonen Lg',
        'sicon-processes-lg' => 'Processen Lg',
        'sicon-process-definitions-lg' => 'Procesdefinities Lg',
        'sicon-target-lists-lg' => 'Targetlijsten Lg',
        'sicon-purchased-line-items-lg' => 'Aangeschafte regelitems Lg',
        'sicon-user-group-lg' => 'Gebruikersgroep Lg',
        'sicon-revenue-line-items-lg' => 'Omzetregelitems Lg',
        'sicon-business-centers-lg' => 'Businesscentra Lg',
        'sicon-logo-fb-simple' => 'Simpel Fb-logo',
        'sicon-forecasts-lg' => 'Forecasts Lg',
        'sicon-contracts-lg' => 'Contracten Lg',
        'sicon-purchase-lg' => 'Aankoop Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'Klantreis Lg',
        'sicon-data-privacy-lg' => 'Gegevensprivacy Lg',
        'sicon-home-lg' => 'Home Lg',
        'sicon-data-table' => 'Datatabel Lg',
        'sicon-medical-clipboard-lg' => 'Medisch klembord Lg',
        'sicon-privacy-lg' => 'Privacy Lg',
        'sicon-marketplace' => 'Marktplaats',
        'sicon-marketplace-lg' => 'Marktplaats Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => 'Casino Lg',
        'sicon-jacuzzi-lg' => 'Jacuzzi Lg',
        'sicon-scissors-lg' => 'Schaar Lg',
        'sicon-storage-lg' => 'Opslag Lg',
        'sicon-fan-lg' => 'Ventilator Lg',
        'sicon-medicine-lg' => 'Medicijn Lg',
        'sicon-plant-lg' => 'Plant Lg',
        'sicon-telescope-lg' => 'Telescoop Lg',
        'sicon-smart-phone-lg' => 'Smartphone Lg',
        'sicon-coffee-lg' => 'Koffie Lg',
        'sicon-martini-lg' => 'Martini Lg',
        'sicon-cocktail-lg' => 'Cocktail Lg',
        'sicon-stadium-lg' => 'Stadion Lg',
        'sicon-fire-lg' => 'Brand Lg',
        'sicon-window-lg' => 'Raam Lg',
        'sicon-lotus-lg' => 'Lotus Lg',
        'sicon-windmill-lg' => 'Windmolen Lg',
        'sicon-spades-lg' => 'Schoppen Lg',
        'sicon-hearts-lg' => 'Harten Lg',
        'sicon-diamonds-lg' => 'Ruiten Lg',
        'sicon-clubs-lg' => 'Klaveren Lg',
        'sicon-skull-lg' => 'Schedel Lg',
        'sicon-send' => 'Sturen',
        'sicon-world-lg' => 'Wereld Lg',
        'sicon-airplane-lg' => 'Vliegtuig Lg',
        'sicon-planet-lg' => 'Planeet Lg',
        'sicon-trainer-lg' => 'Trainer Lg',
        'sicon-calculator-lg' => 'Rekenmachine Lg',
        'sicon-tv-lg' => 'Tv Lg',
        'sicon-video-player-lg' => 'Videospeler Lg',
        'sicon-media-player-lg' => 'Mediaspeler Lg',
        'sicon-decentralize-lg' => 'Decentraliseren Lg',
        'sicon-statistics-lg' => 'Statistieken Lg',
        'sicon-virus-lg' => 'Virus Lg',
        'sicon-shield-lg' => 'Schild Lg',
        'sicon-plug-lg' => 'Stekker Lg',
        'sicon-shuttle-lg' => 'Shuttle Lg',
        'sicon-soundwave-lg' => 'Geluidsgolf Lg',
        'sicon-graph-lg' => 'Grafiek Lg',
        'sicon-playlist-lg' => 'Playlist Lg',
        'sicon-voice-recognition-lg' => 'Spraakherkenning Lg',
        'sicon-machine-learning-lg' => 'Machine learning Lg',
        'sicon-bed-lg' => 'Bed Lg',
        'sicon-blueprint-lg' => 'Blauwdruk Lg',
        'sicon-content-delivery-lg' => 'Contentlevering Lg',
        'sicon-questionnaire-lg' => 'Vragenlijst Lg',
        'sicon-presentation-lg' => 'Presentatie Lg',
        'sicon-organic-lg' => 'Organisch Lg',
        'sicon-transactions-lg' => 'Transacties Lg',
        'sicon-wand-lg' => 'Toverstok Lg',
        'sicon-bin-lg' => 'Prullenbak Lg',
        'sicon-sync-lg' => 'Synchroniseren Lg',
        'sicon-external-authentication-lg' => 'Externe authenticatie Lg',
        'sicon-tracking-activity-lg' => 'Activiteit volgen Lg',
        'sicon-account' => 'Account',
        'sicon-meetings-lg' => 'Afspraken Lg',
        'sicon-stacked' => 'Horizontaal gesplitste weergave',
        'sicon-sidebyside' => 'Verticaal gesplitste weergave',
        ],

        'module_colors_dom' => [
        'army' => 'Leger',
        'coral' => 'Koraal',
        'green' => 'Groen',
        'orange' => 'Oranje',
        'ocean' => 'Oceaan',
        'pacific' => 'Stille Oceaan',
        'pink' => 'Roze',
        'purple' => 'Paars',
        'red' => 'Rood',
        'teal' => 'Beige',
        'yellow' => 'Geel',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'Nieuw',
        'In Progress' => 'In Bewerking',
        'Closed' => 'Gesloten',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'Inactiviteit',
        'Lack of Progress' => 'Te weinig voortgang',
        'Customer-Imposed Deadline' => 'Door de klant opgelegde deadline',
        'Account at Risk' => 'Account dat risico loopt',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'Klant verzocht',
        'Internally Requested' => 'Intern verzocht',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'Casus',
        'Bugs' => 'Bug',
        'Accounts' => 'Account',
        'Opportunities' => 'Opportunity',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'Positief',
        'Negative' => 'Negatief',
        'Neutral' => 'Neutraal',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'Niet waarschijnlijk',
        '02_less_likely' => 'Minder waarschijnlijk',
        '03_neutral' => 'Neutraal',
        '04_more_likely' => 'Waarschijnlijker',
        '05_very_likely' => 'Heel waarschijnlijk',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'Komt niet overeen met klanten',
        '02_no_match' => '',
        '01_matches_customers' => 'Komt overeen met klanten',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'Lead',
        'Accounts' => 'Account',
        'Contacts' => 'Contact',
        'Cases' => 'Case',
        'Opportunities' => 'Opportunity',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'Niet gestart',
        'in_progress' => 'In bewerking',
        'completed' => 'Afgerond',
        'cancelled' => 'Geannuleerd',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'Geen',
        'create' => 'Bij Maken',
        'stage_start' => 'Bij starten van fase',
        'previous_activity_completed' => 'Vorige activiteit voltooid',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'Huidige gebruiker',
        'parent_assignee' => 'Bovenliggende toegewezen gebruiker',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'Dagen na het maken',
        'days_from_stage_started' => 'Dagen nadat fase is gestart',
        'days_from_previous_activity_completed' => 'Dagen nadat vorige activiteit voltooid is',
        'days_from_parent_date_field' => 'Dagen na bovenliggend datumveld',
        'days_from_specific_activity_completed' => 'Dagen nadat specifieke activiteit voltooid is',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'Datum van maken',
        'stage_started' => 'Startdatum van fase',
        'previous_activity_completed' => 'Datum waarop de vorige activiteit afgerond is',
        'parent_date_field' => 'Op bovenliggend datumveld',
        'specific_activity_completed' => 'Specifieke activiteit voltooid',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'Absoluut',
        'Percentage' => 'Percentage',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'Klanttaak',
        'milestone' => 'Mijlpaal',
        'internal_task' => 'Interne taak',
        'agency_task' => 'Agentschap-taak',
        'automatic_task' => 'Automatische taak',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'Taak',
        'Calls' => 'Gesprek',
        'Meetings' => 'Afspraak',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '3',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'Geen',
        'create' => 'Bij Maken',
        'stage_start' => 'Bij starten van fase',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'Overnemen',
        'current_user' => 'Huidige gebruiker',
        'parent_assignee' => 'Bovenliggende toegewezen gebruiker',
        'user' => 'Gebruiker',
        'team' => 'Team',
        'user_team' => 'Gebruiker en team',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'Overnemen',
        'none' => 'Geen',
        'create' => 'Bij Maken',
        'stage_start' => 'Bij starten van fase',
        'previous_activity_completed' => 'Vorige activiteit voltooid',
        'specific_activity_completed' => 'Specifieke activiteit voltooid',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'Niet gestart',
        'in_progress' => 'In bewerking',
        'not_completed' => 'Niet voltooid',
        'completed' => 'Voltooid',
        'cancelled' => 'Geannuleerd',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'Fase bewerken',
        'stage_add_task_button' => 'Taak maken',
        'stage_add_meeting_button' => 'Afspraak maken',
        'stage_add_call_button' => 'Gesprek plannen',
        'stage_delete_button' => 'Fase verwijderen',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'Taak toevoegen',
        'activity_add_sub_meeting_button' => 'Afspraak maken',
        'activity_add_sub_call_button' => 'Gesprek plannen',
        'activity_not_applicable_button' => 'Niet van toepassing',
        'activity_delete_button' => 'Verwijderen',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'Niet van toepassing instellen',
        'remove_open_activities' => 'Open activiteiten verwijderen',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'Standaard',
        'custom' => 'Aangepast',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'VERKRIJGEN',
        'POST' => 'POSTEN',
        'PUT' => 'PLAATSEN',
        'PATCH' => 'PATCHEN',
        'DELETE' => 'VERWIJDEREN',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'Verzoek overslaan',
        'json' => 'JSON',
        'http_query' => 'HTTP-query',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'Geen respons',
        'json' => 'JSON',
        'http_query' => 'HTTP-query',
        'text' => 'Platte tekst',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'Vóór het maken',
        'after_create' => 'Na het maken',
        'before_in_progress' => 'Vóór In bewerking',
        'after_in_progress' => 'Na In bewerking',
        'before_completed' => 'Vóór voltooid',
        'after_completed' => 'Na voltooid',
        'before_not_applicable' => 'Vóór niet van toepassing',
        'after_not_applicable' => 'Na niet van toepassing',
        'before_delete' => 'Vóór verwijderen',
        'after_delete' => 'Na verwijderen',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Slimme gids-informatie sturen',
        'custom_body' => 'Aangepaste tekst van post sturen',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'In Bewerking',
        'completed' => 'Afgerond',
        'not_applicable' => 'Niet van toepassing',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'Record bekijken',
        'create_record' => 'Record maken',
        'update_record' => 'Record updaten',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'Record automatisch maken',
        'manual_create' => 'Record handmatig maken',
        'automatic_update' => 'Record automatisch updaten',
        'manual_update' => 'Record handmatig updaten',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Slimme gids-sjabloon',
        'DRI_SubWorkflow_Templates' => 'Fasesjabloon',
        'DRI_Workflow_Task_Templates' => 'Activiteitssjabloon',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'Ja',
        'no' => 'Nee',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'Gehouden',
        'Not Held' => 'Niet vastgehouden',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'Gehouden',
        'Not Held' => 'Niet vastgehouden',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'Afgerond',
        'Not Applicable' => 'Niet van toepassing',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Slimme gids-sjabloon',
        'DRI_SubWorkflow_Templates' => 'Fasesjabloon',
        'DRI_Workflow_Task_Templates' => 'Activiteitssjabloon',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'Taak',
        'Meetings' => 'Afspraak',
        'Calls' => 'Gesprek',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'Huidige taak',
        'Calls' => 'Huidig gesprek',
        'Meetings' => 'Huidige afspraak',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'Specifieke gebruikers',
        'specific_contacts' => 'Specifieke contacten',
        'related_parent_users' => 'Gerelateerde bovenliggende gebruikers',
        'related_parent_contacts' => 'Gerelateerde bovenliggende contacten',
        'add_all_contacts_from_parent' => 'Alle contacten van bovenliggende entiteit toevoegen',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'Gebruikers',
        'specific_contacts' => 'Contacten',
        'related_parent_users' => 'Gebruikers',
        'related_parent_contacts' => 'Contacten',
        'add_all_contacts_from_parent' => 'Contacten',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'Minuut/minuten',
        'hours' => 'Uur',
        'days' => 'Dag(en)',
        'months' => 'Maand(en)',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'Dag(en)',
        'months' => 'Maand(en)',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'Vaste datum',
        'relative' => 'Relatieve datum',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'Gebruikers',
        'teams' => 'Teams',
        'roles' => 'Rollen',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Actie Smart Guide naar Sugar',
        'sugar_action_to_smart_guide' => 'Sugar actie naar Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Fase Smart Guide',
        'Smart Guide Activities' => 'Activiteiten Smart Guide',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'Voltooid',
        'cancelled' => 'Geannuleerd',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'In bewerking',
        'completed' => 'Voltooid',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'In bewerking',
        'completed' => 'Voltooid',
        'not_applicable' => 'Niet van toepassing',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'Alle activiteiten markeren als voltooid',
        'mark_all_not_applicable' => 'Alle onvoltooide activiteiten markeren als Niet van toepassing',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'Verenigde Staten (Oregon) [us-west-2]',
        'ca-central-1' => 'Canada (Centraal) [ca-central-1]',
        'ap-southeast-1' => 'Zuidoost-Azië (Singapore) [ap-southeast-1]',
        'ap-southeast-2' => 'Zuidoost-Azië (Sydney) [ap-zuidoost-2]',
        'eu-central-1' => 'Europa (Frankfurt) [eu-central-1]',
        'eu-west-2' => 'Europa (Londen) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'Record Koptitel', // Studio editing of record views
    'LBL_RECORD_BODY' => 'Visitekaartje', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'Toon meer', // Studio editing of record views
    'LBL_FAVORITE' => 'Favoriet', // Record view header panel element
    'LBL_FOLLOW' => 'Volgen', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'Volg koppeling',
    'LBL_TOGGLE_VISIBILITY' => 'Toon zichtbaarheid', // Record view header panel element
    'LBL_ACTIVITIES' => 'Activity Stream',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar en de 3-D kubus zijn geregistreerde handelsmerken van SugarCRM Inc. ' .
        'Alle andere bedrijfs- en productnamen die in dit product verschijnen, kunnen handelsmerken zijn van de' .
        'SugarCRM®, Sugar Enterprise™ en Sugar™ zijn handelsmerken van SugarCRM Inc.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ en Sugar™ zijn handelsmerken van SugarCRM Inc.',
    'LBL_SEND_INVITE' => 'Stuur uitnodiging',
    'LBL_INVITEES' => 'Genodigden',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'Gast ontvangt uw uitnodiging niet',
    'LBL_SELECT_ACTION_LABEL' => 'Selecteer actie',
    'LBL_TOGGLE_DRAWER' => 'Drawer in/uitschakelen',
    'LBL_TOUR_NEXT' => 'Volgende',
    'LBL_TOUR_SKIP' => 'Overslaan',
    'LBL_TOUR_BACK' => 'Terug',
    'LBL_TOUR_CLOSE' => 'Sluiten',
    'LBL_TOUR_BTN_DONE' => 'Klaar',
    'LBL_TOUR_TAKE_TOUR' => 'Volg de rondleiding',
    'LBL_TOUR_FULL_TOUR' => 'Volledige rondleiding',
    'LBL_TOUR_MODULE' => 'Rondleiding voor deze pagina',
    'LBL_TOUR_END_TOUR' => 'Beëindig de rondleiding',
    'LBL_TOUR_OVERVIEW' => 'Pagina overzicht',
    'LBL_TOUR_REVISIT' => 'Klik hier om de begeleiding te tonen.',
    'LBL_MY_AREA_LINKS' => 'My area links:' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Lucht krijgen' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'Welkom' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'Geavanceerd zoeken' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'In detail' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'Inline bewerken' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'Tonen' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Zoeken' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'Zoeken...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'Verwijder' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'Toevoegen' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'Kolom' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 Kolommen' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 Kolommen' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Geavanceerd zoeken' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'Toevoegen' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'Verbergen/Tonen' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'Verwijderen' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'Toevoegen' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'Wissen' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'Verwijderen' /*for 508 compliance fix*/,
    'LBL_ADD' => 'Toevoegen' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'Organisatie logo' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'Agenda' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'Een vervolgkeuzewaarde die u hebt geselecteerd, heeft de lay-out van uw recordweergave gewijzigd. ' .
        'Velden die zijn verborgen in deze nieuwe lay-out, hebben hun waarden gewist. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'Openen',
    'LBL_SIDEBAR_NAV_CLOSE' => 'Sluiten',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}}-menu',
    'LBL_GOTO_SUGARCRM_COM' => 'Ga naar SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'navigatie hoofdmodule',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'subpaneel wisselen',

    'LBL_ADVANCED' => 'Geavanceerd',
    'LBL_BASIC' => 'Basis',
    'LBL_MODULE_FILTER' => 'Filteren op...',
    'LBL_CONNECTORS_POPUPS' => 'Connectors pop-up&#39;s',
    'LBL_CLOSEINLINE' => 'Sluiten',
    'LBL_EDITINLINE' => 'Wijzigen',
    'LBL_VIEWINLINE' => 'Tonen',
    'LBL_INFOINLINE' => 'Info',
    'LBL_POWERED_BY_SUGARCRM' => 'Powered by SugarCRM',
    'LBL_PRINT' => 'Afdrukken',
    'LBL_HELP' => 'Help',
    'LBL_TOUR' => 'Rondleiding',
    'LBL_TOUR_LINK' => 'Rondleiding voor deze pagina',
    'LBL_MOBILE' => 'Mobiel',
    'LBL_ID_FF_SELECT' => 'Selecteer',
    'DEFAULT' => 'Basis',
    'LBL_SORT' => 'Sorteer',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Toevoegen server...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'SMTP over SSL of TLS inschakelen',
    'LBL_NO_ACTION' => 'Deze actie is onbekend.',
    'LBL_NO_DATA' => 'Geen gegevens',
    'LBL_NOT_APPLICABLE' => 'Niet van toepassing',
    'LBL_ROUTING_ADD_RULE' => 'Voeg regel toe',
    'LBL_ROUTING_ALL' => 'Minstens',
    'LBL_ROUTING_ANY' => 'Willekeurig',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'Annuleren',
    'LBL_ROUTING_BUTTON_SAVE' => 'Regel opslaan',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'Kopieer e-mail',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Verwijder Sugar Object',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Verwijder bestand',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'Verwijder e-mail',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'E-mail doorsturen',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'Markeer e-mail',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'Markeer als gelezen',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Markeer als ongelezen',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'Verplaats e-mail',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'Onderneem de volgende stappen',
    'LBL_ROUTING_ACTIONS_REPLY' => 'E-mail beantwoorden',

    'LBL_ROUTING_CHECK_RULE' => "Foutmelding:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'Bevestig a.u.b. dat alle velden gemarkeerd zijn',
    'LBL_ROUTING_CONFIRM_DELETE' => "Weet u zeker dat u deze regel wilt verwijderen? Deze bewerking kan niet ongedaan gemaakt worden.",

    'LBL_ROUTING_FLAGGED' => 'Markeer set',
    'LBL_ROUTING_FORM_DESC' => 'Opgeslagen regels zijn direct actief.',
    'LBL_ROUTING_FW' => 'FW:',
    'LBL_ROUTING_LIST_TITLE' => 'Regels',
    'LBL_ROUTING_MATCH' => 'Als aan',
    'LBL_ROUTING_MATCH_2' => 'van de volgende voorwaarden wordt voldaan:',
    'LBL_NOTIFICATIONS' => 'Notificaties',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'CC',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'Inhoud',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'Van',
    'LBL_ROUTING_MATCH_NAME' => 'Onderwerp',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'Hoge prioriteit',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Normale prioriteit',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Lage prioriteit',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'Aan',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'Bevat',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'Bevat niet',

    'LBL_ROUTING_NAME' => 'Regelnaam',
    'LBL_ROUTING_NEW_NAME' => 'Nieuwe regel',
    'LBL_ROUTING_ONE_MOMENT' => 'Moment a.u.b. ...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Origineel bericht volgt',
    'LBL_ROUTING_RE' => 'RE:',
    'LBL_ROUTING_SAVING_RULE' => 'Regel wordt opgeslagen',
    'LBL_ROUTING_SUB_DESC' => 'Aangevinkte regels zijn actief. Klik op naam om te wijzigen.',
    'LBL_ROUTING_TO' => 'aan',
    'LBL_ROUTING_TO_ADDRESS' => 'naar adres',
    'LBL_ROUTING_WITH_TEMPLATE' => 'met sjabloon',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'Er zijn reeds waarden opgeslagen voor de "telefoon" en "adres" velden. Om deze waarden te overschrijven met de volgende telefoon- en adresgegevens van de geselecteerde organisatie, klik op "OK". Om de huidige waarden te behouden, klik op "annuleren".',
    'LBL_DROP_HERE' => '[Hier neerzetten]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'Wijzigen',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Gmail&#153; standaardinstellingen voorvullen',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'Naam',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Eigenschappen uitgaande mailserver',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'Mail transfer agent',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'Gebruik SMTP authenticatie?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP wachtwoord',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP poort',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP Server',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'Gebruik SSL voor de verbinding',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP gebruikersnaam',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Standaard',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Waarschuwing: Gebruikersnaam en wachtwoord ontbreken voor het uitgaande e-mailaccount.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP gebruikersnaam vereist',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP wachtwoord vereist',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'E-mailaccountbeheer',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'Mailserver protocol van het type POP3 wordt niet ondersteund in de volgende release. Alleen IMAP wordt dan nog ondersteund.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'Stel een e-mailaccount in om inkomende e-mails van uw e-mailaccount te bekijken.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Voer SMTP mailserver informatie in om gebruik te maken van uitgaande e-mail in e-mailaccounts.',
    'LBL_EMAIL_ADD' => 'Voeg e-mailadres toe',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Klaar',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Wissen',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'Aan:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Cc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Bcc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'Aan/Cc/Bcc',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'Nieuwe lijst',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'E-mailadres',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Alleen het bewerken van een persoon wordt nu ondersteund.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filteren',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'Voornaam/Organisatienaam',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Achternaam',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'Mijn personen',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'Mijn mailinglijsten',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'Naam',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'Geen adressen gevonden',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Opslaan & toevoegen aan adresboek',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Zoeken',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Selecteer e-mailontvangers',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Adresboek',
    'LBL_EMAIL_REPORTS_TITLE' => 'Rapporten',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'Waarschuwing! Het uitgaande account dat u probeert te verwijderen is gekoppeld aan een bestaand inkomend account. Weet u zeker dat u wilt doorgaan?',
    'LBL_EMAIL_ADDRESSES' => 'E-mailadres(sen)',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'E-mailadres',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'E-mailadressen',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Importeer in Sugar',
    'LBL_EMAIL_ASSIGNMENT' => 'Taak',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Bijlage toevoegen',
    'LBL_EMAIL_ATTACHMENT' => 'Toevoegen',
    'LBL_EMAIL_ATTACHMENTS' => 'Van lokale systeem',
    'LBL_EMAIL_ATTACHMENTS2' => 'Uit Sugar Documenten',
    'LBL_EMAIL_ATTACHMENTS3' => 'Sjabloon bijlagen',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'Bestand',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Document',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Bijgesloten',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'Bijlage toevoegen is mislukt',
    'LBL_REMOVING_ATTACHMENT' => 'Bijlage wordt verwijderd...',
    'LBL_EMAIL_BCC' => 'BCC',
    'LBL_EMAIL_CANCEL' => 'Annuleren',
    'LBL_EMAIL_CC' => 'CC',
    'LBL_EMAIL_CHARSET' => 'Tekenset',
    'LBL_EMAIL_CHECK' => 'Controleer e-mail',
    'LBL_EMAIL_CHECKING_NEW' => 'Controleren op nieuwe e-mail',
    'LBL_EMAIL_CHECKING_DESC' => 'Een moment geduld alstublieft...<br><br>Als de e-mailaccount voor het eerst gecontroleerd wordt, kan het wat langer duren.',
    'LBL_EMAIL_CLOSE' => 'Sluiten',
    'LBL_EMAIL_COFFEE_BREAK' => 'Er wordt gecontroleerd op nieuwe e-mail.<br><br>Bij grote e-mailaccounts kan dit aanzienlijk veel tijd kosten.',
    'LBL_EMAIL_COMMON' => 'Algemeen',

    'LBL_EMAIL_COMPOSE' => 'E-mail opstellen',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Geef a.u.b. (een) ontvanger(s) op voor deze e-mail',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'Koppelen met',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'Deze e-mail bevat geen tekst. Toch versturen?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'Deze e-mail heeft geen onderwerp. Toch versturen?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(geen onderwerp)',
    'LBL_EMAIL_COMPOSE_READ' => 'Lezen & opstellen e-mail',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Verzend vanaf e-mailaccount',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'Opties',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Geef a.u.b. geldige e-mailadressen op voor de velden Aan, CC en BCC',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'Deze e-mail verwijderen?',
    'LBL_EMAIL_CONFIRM_DELETE' => 'Items verwijderen uit uw adresboek?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'Weet u zeker dat u deze handtekening wilt verwijderen?',

    'LBL_EMAIL_CREATE_NEW' => '--Maken bij opslaan--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Meerdere',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Leeg',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Verzenddatum',
    'LBL_EMAIL_DATE_RECEIVED' => 'Ontvangstdatum',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'Toegewezen aan',
    'LBL_EMAIL_DATE_TODAY' => 'Vandaag',
    'LBL_EMAIL_DATE_YESTERDAY' => 'Gisteren',
    'LBL_EMAIL_DD_TEXT' => 'e-mail(s) geselecteerd.',
    'LBL_EMAIL_DEFAULTS' => 'Standaard',
    'LBL_EMAIL_DELETE' => 'Verwijderen',
    'LBL_EMAIL_DELETE_CONFIRM' => 'Verwijder geselecteerde berichten?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'E-mail succesvol verwijderd.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'Bericht wordt verwijderd',
    'LBL_EMAIL_DETAILS' => 'Details',
    'LBL_EMAIL_DISPLAY_MSG' => 'Tonen e-mail(s) {0} - {1} of {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'Tonen e-mailadres(sen) {0} - {1} of {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'Persoon wijzigen',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Alleen het primaire adres wordt gebruikt bij personen.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'Bewerken mailinglijst',

    'LBL_EMAIL_EMPTYING_TRASH' => 'Prullenbak wordt geleegd',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'Uitgaande server wordt verwijderd',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'Cache files worden opgeschoond',
    'LBL_EMAIL_EMPTY_MSG' => 'Er kunnen geen e-mails worden weergegeven.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'Er kunnen geen e-mailadressen worden weergegeven.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'De naam van de folder moet uniek zijn en mag niet leeg zijn. Probeer nogmaals a.u.b.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'De map kan niet verwijderd worden. In de map, of in eventuele onderliggende mappen, bevinden zich nog e-mailberichten.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'Kan de juiste map niet bepalen in de huidige context. Probeer nog eens.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Check uw instellingen a.u.b.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Zorg er a.u.b. voor dat u een achternaam invoert.',
    'LBL_EMAIL_ERROR_DESC' => 'Foutmelding(en):',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'U heeft geen toegang tot dit onderdeel. Neem contact op met uw site administrator om toegang te verkrijgen.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Map-namen moeten uniek zijn.',
    'LBL_EMAIL_ERROR_EMPTY' => 'Voer a.u.b. enkele zoekcriteria in.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'Er heeft zich een fout voorgedaan',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'Een e-maillijst met die naam bestaat al',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Bericht verwijderd van de server',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'Het bericht is verwijderd van de server of verplaatst naar een andere folder',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'Verbinding met de e-mailserver mislukt. Neem a.u.b. contact op met de administrator',
    'LBL_EMAIL_ERROR_MOVE' => 'Verplaatsen van e-mail tussen servers en/of e-mailaccounts wordt nu niet ondersteund.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'Fout tijdens verplaatsen',
    'LBL_EMAIL_ERROR_NAME' => 'Een naam is vereist.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'Van adres is vereist. Vul a.u.b. een geldig e-mailadres in.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'Er is geen bestand opgegeven.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'Het hernoemen van een IMAP folder wordt nu niet ondersteund',
    'LBL_EMAIL_ERROR_SERVER' => 'Een mailserver adres is vereist.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'Uw e-mailaccount is mogelijk niet opgeslagen.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'Er is een fout opgetreden bij de communicatie met de mailserver.',
    'LBL_EMAIL_ERROR_USER' => 'Een inlognaam is vereist.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'Een wachtwoord is vereist.',
    'LBL_EMAIL_ERROR_PORT' => 'Een mailserver poort is vereist.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'Een server protocol is vereist',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'Gevolgde map is vereist.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'Prullenbak map is vereist.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'Deze informatie is niet beschikbaar',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'Er is geen uitgaande mailserver opgegeven.',
    'LBL_EMAIL_FOLDERS' => 'Folders',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'Verplaatsen naar',
    'LBL_EMAIL_FOLDERS_ADD' => 'Toevoegen',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Voeg nieuwe map toe',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Map hernoemen',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Opslaan',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Voeg deze map toe aan',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'Deze map kan niet worden veranderd',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'Weet u zeker dat u deze map wilt verwijderen?\nDit proces kan niet ongedaan gemaakt worden.\nOnderliggende mappen worden ook verwijderd.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'Nieuwe map',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Selecteer een map voordat u deze actie uitvoert.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'Mappenbeheer',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Gebruikt groep',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'Toewijzen aan team',
    'LBL_EMAIL_FORWARD' => 'Doorsturen',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => '[[count]] van [[total]] e-mails opgehaald',
    'LBL_EMAIL_FOUND' => 'Gevonden',
    'LBL_EMAIL_FROM' => 'Van',
    'LBL_EMAIL_GROUP' => 'groep',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'Groep',
    'LBL_EMAIL_HOME_FOLDER' => 'Start',
    'LBL_EMAIL_HTML_RTF' => 'Verzenden HTML',
    'LBL_EMAIL_IE_DELETE' => 'Mailaccount wordt verwijderd',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'Handtekening wordt verwijderd',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'weet u zeker dat u deze mailaccount wilt verwijderen?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Succesvol verwijderd.',
    'LBL_EMAIL_IE_SAVE' => 'Informatie van mailaccount wordt opgeslagen',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'E-mail wordt geïmporteerd...',
    'LBL_EMAIL_IMPORT_EMAIL' => 'Importeer in Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'Importeer instellingen',
    'LBL_EMAIL_INVALID' => 'Ongeldig',
    'LBL_EMAIL_LINK_RECORD' => 'Klik hier',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'Hernoem mailinglijst',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'Voer een nieuwe naam in voor deze mailinglijst',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'Deze boekingen verwijderen uit uw mailinglijsten?',
    'LBL_EMAIL_LOADING' => 'Laden...',
    'LBL_EMAIL_MARK' => 'Markeer',
    'LBL_EMAIL_MARK_FLAGGED' => 'Als gemarkeerd',
    'LBL_EMAIL_MARK_READ' => 'Als gelezen',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'Als ongemarkeerd',
    'LBL_EMAIL_MARK_UNREAD' => 'Als ongelezen',
    'LBL_EMAIL_ASSIGN_TO' => 'Toewijzen aan',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'Nieuwe map',
    'LBL_EMAIL_MENU_COMPOSE' => 'Opstellen aan',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Verwijder map',
    'LBL_EMAIL_MENU_EDIT' => 'Wijzigen',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Prullenbak legen',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Synchroniseer',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Opschonen cache-bestanden',
    'LBL_EMAIL_MENU_REMOVE' => 'Verwijderen',
    'LBL_EMAIL_MENU_RENAME' => 'Hernoemen',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Map hernoemen',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Map wordt hernoemd',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Maak een selectie a.u.b. voordat u deze handeling uitvoert.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Een map aanmaken (remote of in Sugar)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'Archiveer deze e-mail(s) naar SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'E-mail geselecteerde mailinglijsten',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'E-mail deze persoon',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Een persoon verwijderen',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'Deze e-mail(s) verwijderen',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Verwijder een map (remote of in Sugar)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Een persoon wijzigen',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Een mailinglijst wijzigen',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Leegt alle prullenbak-mappen voor uw mailaccounts',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'Markeer deze e-mails met een vlaggetje',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'Markeer berichten als gelezen',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'Verwijder markering',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'Markeer deze e-mail(s) als ongelezen',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Mailinglijsten verwijderen',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Map naam wijzigen (remote of in Sugar)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'Deze e-mail(s) beantwoorden',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'Alle ontvangers van deze e-mail(s) beantwoorden',

    'LBL_EMAIL_MESSAGES' => 'berichten',

    'LBL_EMAIL_ML_NAME' => 'Naam noteren',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'Geselecteerde adreslijst',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'Beschikbare adreslijst(en)',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-Klik</b> om meerdere items te selecteren<br />(Voor Mac gebruikers: <b>CMD-Klik</b>)',

    'LBL_EMAIL_NO' => 'Nee',
    'LBL_EMAIL_NOT_SENT' => 'Het systeem is niet in staat dit verzoek te verwerken. Neem a.u.b. contact op met de systeem administrator.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'Kon geen users_password_link invoegen.',

    'LBL_EMAIL_OK' => 'OK',
    'LBL_EMAIL_ONE_MOMENT' => 'Een moment geduld a.u.b...',
    'LBL_EMAIL_OPEN_ALL' => 'Open meerdere berichten',
    'LBL_EMAIL_OPTIONS' => 'Opties',
    'LBL_EMAIL_QUICK_COMPOSE' => 'Snel opstellen',
    'LBL_EMAIL_OPT_OUT' => 'Afgemeld voor mail',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Afgemeld en ongeldig',
    'LBL_EMAIL_PAGE_AFTER' => 'van {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'Pagina',
    'LBL_EMAIL_PERFORMING_TASK' => 'Taak wordt uitgevoerd',
    'LBL_EMAIL_PRIMARY' => 'Primair',
    'LBL_EMAIL_PRINT' => 'Afdrukken',

    'LBL_EMAIL_QC_BUGS' => 'Bug',
    'LBL_EMAIL_QC_CASES' => 'Casus',
    'LBL_EMAIL_QC_LEADS' => 'Lead',
    'LBL_EMAIL_QC_CONTACTS' => 'Contactpersoon',
    'LBL_EMAIL_QC_TASKS' => 'Taak',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'Mogelijkheid',
    'LBL_EMAIL_QUICK_CREATE' => 'Snel aanmaken',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'Mappen worden ververst',
    'LBL_EMAIL_RELATE_TO' => 'Relateren',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'Bekijk Relaties',
    'LBL_EMAIL_RECORD' => 'E-mailrecord',
    'LBL_EMAIL_REMOVE' => 'Verwijderen',
    'LBL_EMAIL_REPLY' => 'Beantwoorden',
    'LBL_EMAIL_REPLY_ALL' => 'Allen beantwoorden',
    'LBL_EMAIL_REPLY_TO' => 'Beantwoorden aan',
    'LBL_EMAIL_RETRIEVING_LIST' => 'Ophalen e-maillijst',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Bericht wordt opgehaald',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'E-mailrecord wordt opgehaald',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Selecteer a.u.b. slechts 1 e-mailrecord',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'Terug naar de vorige module?',
    'LBL_EMAIL_REVERT' => 'Ongedaan maken',
    'LBL_EMAIL_RELATE_EMAIL' => 'Relateer e-mail',

    'LBL_EMAIL_RULES_TITLE' => 'Managementregel',

    'LBL_EMAIL_SAVE' => 'Opslaan',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'Opslaan & beantwoorden',
    'LBL_EMAIL_SAVE_DRAFT' => 'Concept opslaan',

    'LBL_EMAIL_SEARCHING' => 'Zoekopdracht uitvoeren',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'Geavanceerd zoeken',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'Vanaf',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Tot',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'Hoofdtekst',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'Geen resultaten gevonden bij uw zoekcriteria',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Zoekresultaten',
    'LBL_EMAIL_SEARCH_TITLE' => 'Normale zoekopdracht',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'Doorzoeken e-mailaccount',

    'LBL_EMAIL_SELECT' => 'Selecteer',

    'LBL_EMAIL_SEND' => 'Verzenden',
    'LBL_EMAIL_SENDING_EMAIL' => 'E-mail wordt verzonden',

    'LBL_EMAIL_SETTINGS' => 'Instellingen',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 Rijen',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 Kolommen',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'Layout Stijl',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'E-mailaccounts',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Formulier wissen',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'Importeer e-mail tijdens bekijken',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Check op nieuwe e-mail',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Gebruik voorvertoningsvenster',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Gebruik pop-up-venster',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'Aantal e-mails per pagina',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'Wijzig e-mailaccount',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'Mappen',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'Van adres',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'E-mailadres voor testmelding:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'Aan e-mailadres',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'Van naam',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Beantwoorden aan adres',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Volledig scherm',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Synchroniseer alle mailaccounts',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'Er is een e-mail verzonden naar het opgegeven e-mailadres gebruikmakend van de opgegeven instellingen voor uitgaande e-mail. Controleer of de instellingen correct zijn door te kijken of het bericht is aangekomen.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Deze actie zorgt voor een volledige synchronisatie van de e-mailaccounts en hun inhoud.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'Wilt u een volledige synchronisatie doen?\nBij grote e-mailaccounts kan dit een paar minuten duren.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Klik op de Shift-toets of de Ctrl-toets om meerdere folders te selecteren.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'Algemeen',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Beschikbare groepsfolders',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Nieuwe groepsfolders',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Groepsfolders worden opgeslagen',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Groepsfolder wordt opgehaald',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Groepsfolder wijzigen',

    'LBL_EMAIL_SETTINGS_NAME' => 'Mailaccount naam',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Selecteer het aantal e-mails per pagina voor de inbox. Mogelijk moet de pagina ververst worden om de instellingen te activeren.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'Mailaccount wordt opgehaald',
    'LBL_EMAIL_SETTINGS_RULES' => 'Regels',
    'LBL_EMAIL_SETTINGS_SAVED' => 'De instellingen zijn opgeslagen.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'Herlaad de pagina om de nieuwe instellingen te activeren.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'E-mail verzenden zonder opmaak (platte tekst)',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Actief',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'E-mails per pagina',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'Plaats tabs onderaan',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Visuele instellingen',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Voorkeuren',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Toon geavanceerde opties',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Beschikbare gebruikersfolders',
    'LBL_EMAIL_ERROR_PREPEND' => 'Fout tijdens versturen e-mail:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'De geselecteerde uitgaande e-mailserver die u voor het mail account gebruikt is ongeldig. Controleer de instellingen of selecteer een andere e-mailserver voor het e-mailaccount.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'Een uitgaande e-mailserver is niet geconfigureerd voor uitgaande e-mail van het e-mailaccount die u gebruikt. Selecteer of configureer een uitgaande e-mailserver voor de e-mailaccount in Instellingen >> E-mailacount.',
    'LBL_EMAIL_SHOW_READ' => 'Toon alles',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Toon alleen ongelezen',
    'LBL_EMAIL_SIGNATURES' => 'Handtekeningen',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'Nieuwe handtekening',
    'LBL_EMAIL_SIGNATURE_NAME' => 'Naam handtekening',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'Inhoud handtekening',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange online',
    'LBL_SMTPTYPE_GMAIL' => 'Google minder veilige apps',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'Overige gegevens',
    'LBL_EMAIL_AUTHORIZE' => 'Autoriseren',
    'LBL_EMAIL_AUTHORIZED' => 'Geautoriseerd',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'Niet geautoriseerd',
    'LBL_EMAIL_AUTH_WARNING' => 'Een beheerder moet de {0} Connector configureren via Beheer > Connectors voordat u dit account kunt configureren. Raadpleeg voor meer informatie de {1} documentatie.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'Fout tijdens ophalen connectorinformatie',
    'LBL_EMAIL_AUTH_FAILURE' => 'Autorisatiefout.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'Autoriseer het account voordat u het opslaat.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'Autoriseer het account voordat u het test.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'Account niet geautoriseerd',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Externe mappen ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugar mappen ]',
    'LBL_EMAIL_SUBJECT' => 'Onderwerp',
    'LBL_EMAIL_SUCCESS' => 'Succes',
    'LBL_EMAIL_SUGAR_FOLDER' => 'SugarFolder',
    'LBL_EMAIL_TEAMS' => 'Toewijzen aan teams',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'De inhoud van de e-mailsjabloon is leeg',
    'LBL_EMAIL_TEMPLATES' => 'Sjablonen',
    'LBL_EMAIL_TEXT_FIRST' => 'Eerste pagina',
    'LBL_EMAIL_TEXT_PREV' => 'Vorige pagina',
    'LBL_EMAIL_TEXT_NEXT' => 'Volgende pagina',
    'LBL_EMAIL_TEXT_LAST' => 'Laatste pagina',
    'LBL_EMAIL_TEXT_REFRESH' => 'Vernieuwen',
    'LBL_EMAIL_TO' => 'Aan',
    'LBL_EMAIL_TOGGLE_LIST' => 'Toon lijst',
    'LBL_EMAIL_VIEW' => 'Bekijk',
    'LBL_EMAIL_VIEWS' => 'Overzichten',
    'LBL_EMAIL_VIEW_HEADERS' => 'Toon Koppen',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'Printversie',
    'LBL_EMAIL_VIEW_RAW' => 'Toon onbewerkte e-mail',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'Deze functie wordt niet ondersteund bij gebruik met POP3.',
    'LBL_DEFAULT_LINK_TEXT' => 'Standaard link tekst.',
    'LBL_EMAIL_YES' => 'Ja',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Test e-mail verzenden',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Test e-mail verzonden',


    'LBL_EMAIL_MESSAGE_NO' => 'Bericht Nee',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'Importeren geslaagd',
    'LBL_EMAIL_IMPORT_FAIL' => 'Het importeren is niet gelukt omdat of het bericht al geïmporteerd is of al verwijderd is van de server.',

    'LBL_EMAILS_FROM' => 'Verzonden e-mails',
    'LBL_EMAILS_RECEIVED' => 'Ontvangen e-mails',
    'LBL_EMAIL_ADDRESSES_USED' => 'E-mailadressen die zijn gebruikt in e-mails',
    'LBL_EMAIL_ADDRESS' => 'E-mailadres',
    'LBL_FROM' => 'Van',
    'LBL_TO' => 'Aan',
    'LBL_CC' => 'CC',
    'LBL_BCC' => 'BCC',

    'LBL_START_DATE' => 'Startdatum',
    'LBL_END_DATE' => 'Einddatum',
    'LBL_START' => 'Starten',
    'LBL_END' => 'Einde',
    'LBL_DATE_LINKED' => 'Datum gekoppeld',

    'LBL_LINK_NONE' => 'Geen',
    'LBL_LINK_ALL' => 'Alle',
    'LBL_LINK_RECORDS' => 'Records',
    'LBL_LINK_SELECT' => 'Selecteer',
    'LBL_LINK_ACTIONS' => 'Acties',
    'LBL_LINK_MORE' => 'Meer',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'Bevestig',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'Wilt u deze #module# sluiten?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'Geef dit bericht in de toekomst niet weer:',
    'LBL_INVALID_FILE_EXTENSION' => 'Foutieve bestandsextensie',
    'LBL_LIST_TEAM' => 'Team',
    'LBL_TEAM' => 'Team:',
    'LBL_TEAMS' => 'Teams',
    'LBL_TEAM_SET_ID' => 'Team Set ID',
    'LBL_TEAM_SET_SELECTED_ID' => 'Geselecteerde teamset-ID',
    'LBL_TEAM_SET_SELECTED' => 'Geselecteerd',
    'LBL_TEAM_SET_ENABLE' => 'Extra machtigingen inschakelen',
    'LBL_TEAM_SET_DISABLE' => 'Extra machtigingen uitschakelen',
    'LBL_TEAM_SET' => 'Team ingesteld',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'Geselecteerde teams',
    'LBL_SEARCH_UNAVAILABLE' => 'Zoeken niet beschikbaar, probeert u het later nogmaals a.u.b.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'Geen primair team gespecificeerd',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'Fout bij het verwijderen van het primaire team ID [{0}] van [{1}] module met ID [{2}]',
    'LBL_TEAM_ADD' => 'Voeg team toe',
    'LBL_TEAM_REMOVE' => 'Verwijder team',
    'LBL_TEAM_PRIMARY' => 'Stel in als primair team',

    'LBL_CLOSE_BUTTON_LABEL' => 'Sluiten',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} marked as {{status}}.',

    'LBL_FOCUS' => 'Focus',

    'LBL_QUERY_VALID' => 'Geldig',
    'LBL_QUERY_ERROR' => 'Fout!',
    'LBL_QUERY_CHILD' => 'Geldige sub-query',
    'ERROR_EXAMINE_MSG' => 'Controleer a.u.b. de foutmelding hieronder:',
    'NO_QUERY_SELECTED' => 'Het gekozen formaat bevat geen query. Kies a. u. b. een custom query voor dit formaat.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'Er is een fout opgetreden:',
    'ERR_AJAX_LOAD_FAILURE' => 'Er is een fout opgetreden, probeer het later nogmaals.',
    'ERR_AJAX_LOAD_FOOTER' => 'Als de fout zich blijft voordoen, laat dan uw administrator Ajax voor deze module uitschakelen.',
    'ERR_CREATING_FIELDS' => 'Foutmelding bij het invullen van aanvullende detail velden:',
    'ERR_CREATING_TABLE' => 'Foutmelding bij het maken van de tabel:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'Het decimaalteken mag niet gelijk zijn aan het scheidingsteken voor 1000-tallen.

Gelieve een van de waardes te wijzigen.',
    'ERR_DELETE_RECORD' => 'U dient een recordnummer op te geven om dit contact te verwijderen',
    'ERR_EXPORT_DISABLED' => 'Exports uitgeschakeld.',
    'ERR_EXPORT_TYPE' => 'Fout tijdens exporteren',
    'ERR_REPORTS_DISABLED_EXPORT' => 'Rapporten exporteren is uitgeschakeld',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'Alleen gebruikers die beheerder zijn, kunnen exporteren',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'Rapport gebruikt modules zonder toegang tot Exporteren',
    'ERR_REPORTS_EXPORT_OWNER' => 'Rapport gebruikt modules met toegang tot Eigenaar exporteren',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'Rapport gebruikt modules met toegang tot Beperkt weergeven',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'Rapport gebruikt modules met toegang tot Beperkt bekijken',
    'ERR_REPORTS_ACCESS_DISABLED' => 'Rapport gebruikt modules met beperkte toegang',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'Rapport gebruikt velden met beperkte toegang',
    'ERR_INVALID_AMOUNT' => 'Voer a.u.b. een geldig bedrag in.',
    'ERR_INVALID_DATE_FORMAT' => 'Het datum formaat moet zijn:',
    'ERR_INVALID_DATE' => 'Voer a.u.b. een geldige datum in.',
    'ERR_INVALID_DAY' => 'Voer a.u.b. een geldige dag in.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'geen geldig e-mailadres.',
    'ERR_INVALID_FILE_REFERENCE' => 'Ongeldige bestandsreferentie',
    'ERR_INVALID_HOUR' => 'Voer a.u.b. een geldig uur in.',
    'ERR_INVALID_MONTH' => 'Voer a.u.b. een geldige maand in.',
    'ERR_INVALID_TIME' => 'Voer a.u.b. een geldige tijd in.',
    'ERR_INVALID_YEAR' => 'Voer a.u.b. een geldig 4 cijferig jaartal in.',
    'ERR_NEED_ACTIVE_SESSION' => 'Om de inhoud te exporteren is een actieve sessie vereist.',
    'ERR_NO_HEADER_ID' => 'Deze functie is niet beschikbaar in dit thema',
    'ERR_NOT_ADMIN' => 'Ongeoorloofde toegang tot beheer.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'Wachtwoordbeheer is alleen beschikbaar in <a href="%s" target="_blank">SugarCloudinstellingen</a>.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'Neem contact op met uw Sugar-beheerder als u veranderingen wilt doorvoeren in alleen-lezen velden.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'Open de <a href="{0}" target="_blank">SugarCloud instellingen</a>om veranderingen door te voeren van alleen-lezen velden.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'Vereiste velden ontbreken:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'Ongeldig vereist veld:',
    'ERR_INVALID_VALUE' => 'Ongeldige waarde:',
    'ERR_NO_SUCH_FILE' => 'Bestand bestaat niet op het systeem',
    'ERR_NO_SINGLE_QUOTE' => 'U kunt geen gebruik maken van enkelvoudig aanhalingsteken voor',
    'ERR_NOTHING_SELECTED' => 'Maak een selectie voor u doorgaat.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'Er bestaat al een opportunity met de naam %s. Geef a.u.b. een andere naam voor de opportunity in.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'Er is geen opportunitynaam ingevuld. Voer a.u.b. een naam voor deze opportunity in.',
    'ERR_QUOTE_CONVERTED' => 'Deze offerte is al geconverteerd naar een opportunity',
    'ERR_POTENTIAL_SEGFAULT' => 'Een potentiële &#39;Apache segmentation fault&#39; is gedetecteerd. Neem contact op met de administrator om het probleem te bevestigen. Laat deze het probleem doorgeven aan SugarCRM.',
    'ERR_SELF_REPORTING' => 'Een gebruiker kan niet naar zichzelf rapporteren.',
    'ERR_SINGLE_QUOTE' => 'Het enkelvoudige aanhalingsteken kan niet gebruikt worden voor dit veld. Verander a.u.b. de waarde.',
    'ERR_SQS_NO_MATCH_FIELD' => 'Geen overeenkomst op veld:',
    'ERR_SQS_NO_MATCH' => 'Geen overeenkomsten',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Please specify &#39;key&#39; index in displayParams attribute for the Meta-Data definition',
    'ERR_EXISTING_PORTAL_USERNAME' => 'Fout: Portal naam is reeds toegekend aan een ander persoon.',
    'ERR_PORTAL_NAME_CHECK' => 'Niet mogelijk om te controleren of de gebruikersnaam voor portal uniek is',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'Veldwaarde komt niet overeen met de bijbehorende nauwkeurigheid',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'Er is een fout opgetreden bij het opslaan van de externe account.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'Er is een fout opgetreden bij het uploaden. Zorg ervoor dat het bestand dat u wilt uploaden is niet leeg is.',
    'ERR_NO_DB' => 'Kan niet verbinden met de database. Kijk in de sugarcrm.log voor details.',
    'ERR_DB_FAIL' => 'Database falen. Kijk in de sugarcrm.log voor details.',
    'ERR_EXTERNAL_API_403' => 'Toegang geweigerd. Bestandstype wordt niet ondersteund.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth Access Token ontbreekt.',
    'ERR_DB_VERSION' => 'Sugar CRM {0} bestanden mogen alleen gebruikt worden in combinatie met een Sugar CRM {1} database.',
    'ERR_DB_QUERY' => '{0}: query failed: {1}',
    'ERR_UW_RETIRED' => 'Upgrade wizard is niet beschikbaar in deze versie.',
    'ERR_NOT_CLOUD_INSTANCE' => 'Deze versie van Sugar is geen SugarCloud-versie of is niet geconfigureerd voor SugarCloud Insights.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'U bent niet geautoriseerd om {moduleName} aan te maken. Neem contact op met uw administrator om toegang te krijgen.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'Huidige gebruiker heeft geen rechten om de {moduleName} configuratie instellingen te wijzigen.',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'Huidige gebruiker heeft geen rechten om de {moduleName} configuratie instellingen te wijzigen.',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'U heeft geen rechten om {moduleName} favoriet te maken. Neem contact op met uw administrator om toegang te krijgen.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'U heeft geen rechten om {moduleName} te volgen. Neem contact op met uw administrator om toegang te krijgen.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet-columns is geen matrix',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'worksheet_columns_related_fields niet gevonden in uitbetalingslading',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns is geen matrix',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'summary_columns_related_fields niet gevonden in uitbetalingslading',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows is geen matrix',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rows_related_fields niet gevonden in uitbetalingslading',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'Door een onbekende uitzondering is uw request mislukt.',
    'EXCEPTION_FATAL_ERROR' => 'Een fatale uitzondering heeft plaatsgevonden, waardoor uw request niet uitgevoerd kon worden. Kijk voor meer details in het logbestand.',
    'EXCEPTION_NEED_LOGIN' => 'U dient ingelogd te zijn om deze actie te kunnen uitvoeren.',
    'EXCEPTION_INVALID_TOKEN' => 'Uw authenticatie token is ongeldig.',
    'EXCEPTION_NOT_AUTHORIZED' => 'U bent niet geautoriseerd om deze handeling uit te voeren. Neem contact op met uw administrator om toegang te krijgen.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'U hebt geen toestemming om gegevens te bekijken. Neem contact op met uw beheerder als u toegang nodig hebt.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'U heeft geen toegang tot de portal omdat uw portal account inactief is. Neem contact op met customer support om toegang te krijgen.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'Portal is niet juist ingesteld. Neem contact op met uw portal administrator voor assistentie.',
    'EXCEPTION_NO_METHOD' => 'Uw request wordt niet ondersteund. Kon niet de HTTP methode voor uw verzoek op dit pad vinden.',
    'EXCEPTION_NOT_FOUND' => 'Your requested resource was not found.  Could not find a handler for the path specified in the request.',
    'EXCEPTION_MISSING_PARAMTER' => 'Een vereiste parameter in uw request ontbrak.',
    'EXCEPTION_INVALID_PARAMETER' => 'Een parameter in uw request was ongeldig.',
    'EXCEPTION_REQUEST_FAILURE' => 'Uw request kon niet worden voltooid.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'Uw metadata of user hash stemt niet overeen met de server. Synchroniseer a.u.b. uw metadata opnieuw.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'Uw request is te groot om uit te voeren.',
    'EXCEPTION_EDIT_CONFLICT' => 'Conflict tijdens wijzigen. Laad de bestandsgegevens opnieuw.',
    'EXCEPTION_METADATA_CONFLICT' => 'Conflict met metadata. Laad de metadata opnieuw.',
    'EXCEPTION_CLIENT_OUTDATED' => 'Uw software is verouderd. Update uw &#39;client&#39; voor u opnieuw contact maakt.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'A connector or an integration request resulted in a failed response.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM is in onderhoudsmodus. Alleen administrators kunnen inloggen. Neem contact op met uw administrator voor meer informatie.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'The server cannot process your request because it is busy or unavailable at this time.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'Search engine is temporarily unavailable.',
    'EXCEPTION_SEARCH_RUNTIME' => 'Er is een zoekmachine Runtime-fout opgetreden. Neem contact op met uw systeembeheerder.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'Een veld dat is vergrendeld door een proces kan niet worden bewerkt.',
    'EXCEPTION_MODULE_DISABLED' => 'Deze module is uitgeschakeld voor de huidige gebruiker.',
    'EXCEPTION_FIELD_DISABLED' => 'Dit veld is uitgeschakeld voor de huidige gebruiker.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'Deze client is niet toegestaan',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'De mogelijkheid om pakketten te uploaden is niet beschikbaar voor uw licentietype',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'Er is een fout opgetreden. De oorzaak voor deze uitzondering wisselt, maar valt over het algemeen buiten het bereik van een meer specifieke API uitzondering.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'Het request kon niet zoals aangeboden behandeld worden of er was een fout met het antwoord. Dit betekent over het algemeen dat er een fatale fout is opgetreden en dat de specifieke fout teruggevonden kan worden in het logboek.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'De versie van de API die u gebruikt is onjuist voor het huidige request.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'De benaderde endpoint vereist authenticatie en de consumer die het verzoek indiende is niet geauthenticeerd.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'Geeft aan dat het authenticatie token dat met het verzoek is meegestuurd ongeldig is. Dit komt over het algemeen doordat het token velopen is, maar kan ook ontstaan door een misvormd of onjuist token.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'Geeft aan dat de consumer die de request uitvoert niet geautoriseerd is om de gevraagde actie uit te voeren.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'De portal account behorende bij de ingelogde gebruiker is niet actief. Dit vereist actie aan de kant van customer support.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'Geeft aan dat de portal applicatie niet juist is geconfigureerd en niet gebruikt kan worden. dit vereist actie aan de kant van de portal administrator.',
    'EXCEPTION_NO_METHOD_DESC' => 'De endpoint ondersteund niet het type HTTP request die gemaakt wordt. Dit kan gebeuren als een POST request gemaakt wordt naar een endpoint ontworpen voor bijvoorbeeld een GET request.',
    'EXCEPTION_NOT_FOUND_DESC' => 'The endpoint could not locate a resource for the request or does not have a handler for the request.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'Geeft aan dat er mogelijk gelijktijdige aanpassingen zijn gemaakt aan een record en dat het huidige request om het record aan te passen de voorgaande aanpassingen zou kunnen beïnvloeden.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'Geeft aan dat de metadata op de server ongelijk is aan de metadata van de client. Dit kan ontstaan na een wijziging in de systeeminstellingen, veranderingen in de (studio)modules of een uitrol van nieuwe modules en andere systeemwijzigingen.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'Het request is te groot om door de server afgehandeld te worden.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'Geeft aan dat een vereiste parameter in het request ontbreekt.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'Geeft aan dat een parameter in het request ongeldig is.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'Het request kon niet worden voltooid.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'Geeft aan dat de client die de API benaderd out-of-date is en moet geupdate worden voordat verdere benadering van de API plaats kan vinden.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'Indicates that a request made through the API to another service, endpoint or URI  has failed or could not be handled by the server.',
    'EXCEPTION_MAINTENANCE_DESC' => 'De instantie van SugarCRM waaraan de API gekoppeld is, is in onderhoudsmodus. Toegang tot de API is beperkt tot administrators.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'Indicates that the server is busy, overloaded or down.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'The search engine backend is currently unavailable due to a connection issue. Verify connectivity and configuration in Admin->search->test.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'A runtime exception occured in SearchEngine. See sugarcrm.log for more details.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'Een veld dat momenteel is vergrendeld door een actief proces kan niet worden bewerkt.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s is vergrendeld door een actief proces en kan niet worden bewerkt.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s zijn vergrendeld door een actief proces en kunnen niet worden vergrendeld.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'Deze module is uitgeschakeld voor de huidige gebruiker.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'Dit veld is uitgeschakeld voor de huidige gebruiker.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'Deze client is niet toegestaan',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'Een bestand met dezelfde naam bestaat al in het systeem.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'Fout! Periode niet gedefinieerd voor datum {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'Deze periode heeft al subperiode',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'Subperiodes kunnen geen subperiodes bevatten',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'Geen periodes gevonden van het type: {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'Geen actieve perioden voor de huidige instellingen.',
    'LBL_CURRENT_TIMEPERIOD' => 'Huidige periode',
    'LBL_PREVIOUS_TIMEPERIOD' => 'Voorgaande periode',
    'LBL_NEXT_TIMEPERIOD' => 'Volgende periode',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'Voorgaande, huidige, volgende',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'Je kunt geen records verwijderen met een &#39;gesloten&#39; verkoopstadium.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'Je kunt geen records verwijderen met een &#39;gesloten&#39; verkoop status.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'Eén of meerdere geselecteerde records heeft het verkoop stadium Gewonnen of Verloren en kan niet worden verwijderd.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'Eén of meerdere geselecteerde records heeft de status Gewonnen of Verloren en kan niet worden verwijderd.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'Organisatie',
    'LBL_OLD_ACCOUNT_LINK' => 'Oude organisatie',
    'LBL_ACCOUNTS' => 'Organisaties',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Activiteiten',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Bekijk samenvatting',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Bekijk samenvatting [Alt+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Toevoegen [ALT+A]',
    'LBL_ADD_BUTTON' => 'Toevoegen',
    'LBL_ADD_DASHLET_BUTTON' => 'Dashlet toevoegen',
    'LBL_ADD_DOCUMENT' => 'Document toevoegen',
    'LBL_REPLACE_BUTTON' => 'Vervangen',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Voeg toe aan targetlijst',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Voeg toe aan targetlijst',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Klik om te sluiten',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Sluiten',
    'LBL_ADDITIONAL_DETAILS' => 'Aanvullende gegevens',
    'LBL_ADMIN' => 'Admin',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'Archiveer',
    'LBL_ASSIGNED_TO_USER' => 'Toegewezen aan',
    'LBL_ASSIGNED_TO' => 'Toegewezen aan:',
    'LBL_BACK' => 'Terug',
    'LBL_BASE_RATE' => 'Basiskoers',
    'LBL_BILL_TO_ACCOUNT' => 'Factuur aan organisatie',
    'LBL_BILL_TO_CONTACT' => 'Factuur aan persoon',
    'LBL_BILLING_ADDRESS' => 'Factuuradres',
    'LBL_QUICK_CREATE_TITLE' => 'Quick Create',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'Bugs',
    'LBL_BY' => 'door',
    'LBL_CALLS' => 'Telefoongesprekken',
    'LBL_CALL' => 'Telefoongesprek',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Verzend de e-mailcampagne in de wachtrij',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Opslaan',
    'LBL_CASE' => 'Case',
    'LBL_CASES' => 'Cases',
    'LBL_MESSAGE' => 'Bericht',
    'LBL_MESSAGES' => 'Berichten',
    'LBL_ESCALATIONS' => 'Escalaties',
    'LBL_ESCALATION' => 'Escalatie',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign Enveloppen',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign Envelop',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'Ondertekenaar ontvangers selecteren',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'Verander wachtwoord',
    'LBL_CHANGE_BUTTON_LABEL' => 'Wijzig',
    'LBL_CHANGE_BUTTON_TITLE' => 'Wijzig',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Selecteer alles',
    'LBL_CITY' => 'Plaats',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Wissen',
    'LBL_CLEAR_BUTTON_TITLE' => 'Wissen',
    'LBL_CLEARALL' => 'Wis alles',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => 'Sluiten',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'Venster sluiten',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Sluit alle',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Sluit alle [ALT+I]',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Sluiten en nieuw(e) maken',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Sluiten en nieuw(e) maken',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'Record-URL kopiëren',
    'LBL_OPEN_ITEMS' => 'Open Items:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'E-mail opstellen',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'E-mail',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Nieuwe e-mail [Alt+E]',
    'LBL_SEARCH_DROPDOWN_YES' => 'Ja',
    'LBL_SEARCH_DROPDOWN_NO' => 'Nee',
    'LBL_CONTACT_LIST' => 'Personen',
    'LBL_CONTACT' => 'Persoon',
    'LBL_CONTACTS' => 'Personen',
    'LBL_CONTRACTS' => 'Contracten',
    'LBL_COUNTRY' => 'Land:',
    'LBL_RESET_BUTTON_LABEL' => 'Resetten',
    'LBL_CREATE_BUTTON_LABEL' => 'Aanmaken',
    'LBL_CREATED_BY_USER' => 'Aangemaakt door gebruiker',
    'LBL_CREATED_USER' => 'Aangemaakt door gebruiker',
    'LBL_CREATED_ID' => 'Aangemaakt door ID',
    'LBL_CREATED' => 'Aangemaakt door',
    'LBL_CREATE_NEW_TARGET_LIST' => 'Nieuwe targetlijst',
    'LBL_CURRENT_USER_FILTER' => 'Mijn items:',
    'LBL_CURRENCY' => 'Valuta:',
    'LBL_CURRENCIES' => 'Valuta',
    'LBL_CURRENCY_NAME' => 'Valutanaam',
    'LBL_CURRENCY_SYMBOL' => 'Valutasymbool',
    'LBL_CURRENCY_RATE' => 'Valutakoers',
    'LBL_CURRENCY_ID' => 'Valuta ID',
    'LBL_DOCUMENTS' => 'Documenten',
    'LBL_DATE_ENTERED' => 'Datum aangemaakt:',
    'LBL_DATE_MODIFIED' => 'Datum gewijzigd:',
    'LBL_ACTIVITY_MODIFIED' => 'Gewijzigd',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'Tabblad Overzicht bewerken',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'Tabbladen Module bewerken',
    'LBL_EDIT_BUTTON' => 'Wijzigen',
    'LBL_DUPLICATE_BUTTON' => 'Dupliceren',
    'LBL_DELETE_BUTTON' => 'Verwijderen',
    'LBL_DELETE' => 'Verwijderen',
    'LBL_DELETED' => 'Verwijderd',
    'LBL_DIRECT_REPORTS' => 'Ondergeschikten',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Gereed',
    'LBL_DONE_BUTTON_TITLE' => 'Klaar',
    'LBL_DST_NEEDS_FIXIN' => 'Voor deze applicatie is het nodig dat de zomertijd fix wordt toegepast. Ga naar de <a href="index.php?module=Administration&action=DstFix">repareer</a> link in het beheer en voer de zomertijd fix uit.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Wijzig als nieuw',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Wijzig als nieuw',
    'LBL_EDIT_IN_NEW_TAB' => 'Bewerken in nieuw tabblad',
    'LBL_FAVORITES' => 'Favorieten',
    'LBL_FILTER' => 'Filteren',
    'LBL_DEFAULT_DATA_FILTER' => 'Default Data Filter',
    'LBL_FILTER_MENU_BY' => 'Filter menu op',
    'LBL_FILTER_SELECT_FIELD' => 'Selecteer veld...',
    'LBL_FILTER_SELECT_OPERATOR' => 'Selecteer operator...',
    'LBL_FILTER_CREATE_NEW' => 'Aanmaken',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'Build-filter (niet-opgeslagen)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(Niet-opgeslagen)',
    'LBL_FILTER_CREATE_FILTER' => 'Nieuw filter aanmaken',
    'LBL_FILTER_CLOSE_FILTER' => 'Sluit filter',
    'LBL_FILTER_EDIT_FILTER' => 'Filter bewerken',
    'LBL_FILTER_ALL_RECORDS' => 'Alle records',
    'TPL_FILTER_SAVE' => 'U heeft het filter {{name}} succesvol aangemaakt.',
    'LBL_FILTER_BETWEEN_FROM' => 'Van',
    'LBL_FILTER_BETWEEN_TO' => 'Tot',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'Startdatum',
    'LBL_FILTER_DATEBETWEEN_TO' => 'Einddatum',
    'LBL_FOLLOWING' => 'Volgen',
    'LBL_UNFOLLOW' => 'Ontvolgen',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'Download vCard',
    'LBL_EMPTY_VCARD' => 'Selecteer a.u.b. een vCard bestand',
    'LBL_IMAGE' => 'Afbeelding',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard bevat niet alle vereiste velden voor deze module.',
    'LBL_VCARD_ERROR_FILESIZE' => 'Het bestand is groter dan de 30000 bytes limiet die opgegevens is in het HTML form.',
    'LBL_VCARD_ERROR_DEFAULT' => 'Er is een fout opgetreden tijdens het uploaden van de vCard.',
    'TPL_IMPORT_VCARD_FAILURE' => 'Niet gelukt om {{module}} aan te maken van de vCard',
    'LBL_IMPORT_VCARD' => 'Importeer vCard:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'Importeer vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'Importeer vCard',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'Bekijk',
    'LBL_VIEW_BUTTON_TITLE' => 'Bekijken',
    'LBL_VIEW_BUTTON' => 'Bekijk',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'E-mail als PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'E-mail als PDF',
    'LBL_EMAIL' => 'E-mail',
    'LBL_EMAILS' => 'E-mails',
    'LBL_EMPLOYEES' => 'Personeel',
    'LBL_ENTER_DATE' => 'Voer datum in',
    'LBL_EXPORT_ALL' => 'Alles exporteren',
    'LBL_EXPORT' => 'Exporteren',
    'LBL_FAVORITES_FILTER' => 'Mijn favorieten:',
    'LBL_GLOBAL_SEARCH' => 'Algemeen zoeken',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'Global Search Module Filter',
    'LBL_GLOBAL_SEARCH_RUN' => 'Voer Global Search uit',
    'LBL_GO_BUTTON_LABEL' => 'Gaan',
    'LBL_GS_HELP' => 'De velden in deze module, gebruikt tijdens het zoeken, worden bovenin getoond. De gemarkeerde tekst komt overeen met uw zoekcriteria.',
    'LBL_HIDE' => 'Verbergen',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => 'Importeren',
    'LBL_IMPORT_STARTED' => 'Import gestart:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Moet een custom scheidingsteken opgeven.',
    'LBL_LAST_VIEWED' => 'Laatst bekeken',
    'LBL_SELECTED_RECORDS' => 'Selected: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'Toon minder',
    'LBL_SHOW_MORE' => 'Toon meer',
    'LBL_SHOW_MORE_MODULE' => 'Meer {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'Meer recente...',
    'LBL_SHOW_LESS_RECENTS' => 'Minder recente...',
    'LBL_SHOW_MORE_RESULTS' => 'More search results...',
    'TPL_SHOW_MORE_MODULE' => 'Meer {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => 'Meer {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => 'Activiteiten van vandaag',
    'LBL_LEADS' => 'Leads',
    'LBL_LEAD' => 'Lead',
    'LBL_QUOTES_BILL_TO' => 'Offertes (factureren aan)',
    'LBL_LESS' => 'minder',
    'LBL_CAMPAIGN' => 'Campagne:',
    'LBL_CAMPAIGNS' => 'Campagnes',
    'LBL_CAMPAIGNLOG' => 'Campagne Log',
    'LBL_CAMPAIGN_CONTACT' => 'Campagnes',
    'LBL_CAMPAIGN_ID' => 'campagne ID',
    'LBL_THEME' => 'Thema:',
    'LBL_THEME_PICKER' => 'Pagina opmaak',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Waarschuwing: Internet Explorer 6 wordt niet ondersteund voor het geselecteerde thema. Klik op OK om toch te selecteren of annuleren om een ander thema te selecteren',
    'LBL_FOUND_IN_RELEASE' => 'Gevonden in release',
    'LBL_FIXED_IN_RELEASE' => 'Opgelost in release',
    'LBL_LIST_ACCOUNT_NAME' => 'Organisatienaam',
    'LBL_LIST_ASSIGNED_USER' => 'Toegewezen aan',
    'LBL_LIST_CONTACT_NAME' => 'Contactpersoon',
    'LBL_LIST_CONTACT_ROLE' => 'Rol persoon',
    'LBL_LIST_DATE_ENTERED' => 'Datum aangemaakt',
    'LBL_LIST_EMAIL' => 'E-mail',
    'LBL_LIST_NAME' => 'Naam',
    'LBL_LIST_OF' => 'van',
    'LBL_LIST_PHONE' => 'Telefoon',
    'LBL_LIST_RELATED_TO' => 'Gerelateerd aan',
    'LBL_LIST_USER_NAME' => 'Gebruikersnaam',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'Weet u het zeker dat u de gehele lijst wilt bijwerken?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Kies a.u.b. ten minste 1 record om door te kunnen gaan.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Kies a.u.b. tenminste 2 records om door te kunnen gaan.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Kies a.u.b. minder dan 10 records om door te kunnen gaan.',
    'LBL_LISTVIEW_ALL' => 'Alle',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'Bevries kolom 1',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'Alle duplicaten',
    'LBL_LISTVIEW_NONE' => 'Geen',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Huidige pagina',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Complete lijst',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Geselecteerde records',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Geselecteerd:',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'Alle selecties verwijderen.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'Selecteer alle records',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'Het resultaat bevat meer dan {{num}} records. U heeft de eerste {{num}} records geselecteerd.',
    'TPL_LISTVIEW_SELECTED' => 'U heeft {{num}} record(s) geselecteerd in deze weergave.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'U heeft 1 record geselecteerd in de resultatenset.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'U heeft alle {{num}} records geselecteerd van het zoekresultaat.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'U heeft alle {{num}} records geselecteerd in deze weergave. {{link}} in de zoekresultaten.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'Bijwerken {{num}} van {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(resterende tijd ±{{time}} {{unit}})',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'Massaal wijzigen mislukt. Nieuwe poging ({{num}} van {{total}}) wordt gestart.',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'Massaal wijzigen onvolledig. {{num}} records ongewijzigd gebleven.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'Massaal wijzigen onvolledig. {{num}} records ongewijzigd gebleven.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} record(s) werd(en) genegeerd wegens rechten of fouten.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} records zijn succesvol bijgewerkt.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} massaal bijwerken',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'Verwijderen {{num}} van {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(resterende tijd ±{{time}} {{unit}})',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'Massaal verwijderen mislukt. Nieuwe poging ({{num}} van {{total}}) wordt gestart.',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'Massaal verwijderen onvolledig. {{num}} records niet verwijderd',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'Massaal verwijderen onvolledig. {{num}} records niet verwijderd.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} records succesvol verwijderd.',
    'TPL_MASSDELETE_TITLE' => '{{module}} massaal verwijderen',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'Toevoegen {{num}} van {{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(resterende tijd ±{{time}} {{unit}})',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'Massaal toevoegen aan targetlijst mislukt. Nieuwe poging wordt gestart ({{num}} van {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'Massaal toevoegen aan targetlijst onvolledig. {{num}} records niet toegevoegd.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'Massaal toevoegen aan targetlijst onvolledig. {{num}} records niet toegevoegd.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} records succesvol toegevoegd.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} Massaal toevoegen aan targetlijst',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'Koppelen: {{num}} van {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(resterende tijd ±{{time}} {{unit}})',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'Massal koppelen mislukt. Nieuwe poging wordt gestart ({{num}} van {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'Massaal koppelen onvolledig. {{num}} records niet toegevoegd.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'Massaal koppelen onvolledig. {{num}} records niet toegevoegd.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} records zijn succesvol gekoppeld.',
    'TPL_MASSLINK_TITLE' => '{{module}} massaal koppelen',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'Selecteer',
    'LBL_LISTVIEW_ACTIONS' => 'Acties',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'Selecteer alle records op deze pagina',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'Deselecteer alle records op deze pagina',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} van {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '{{num}} van laden...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'Klik voor totaal',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'van',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'Aantal pagina&#39;s ophalen',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'David',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Livingstone',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Dr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Code Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => 'Meld u a.u.b. aan om toegang tot dit gebied te krijgen',
    'LBL_LOGOUT' => 'Uitloggen',
    'LBL_FINISH_IMPERSONATING' => 'Impersonatie afronden',
    'LBL_RESET_MFA' => 'Meerfactorauthenticatie resetten',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, u doet zich momenteel voor als {{user}}.',
    'LBL_PROFILE' => 'Profiel',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'Mail samenvoegen',
    'LBL_MASS_UPDATE' => 'Massaal wijzigen',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'Selecteer alle records voor de massa-update',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'Sluit record in voor massa-update',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'Veld toevoegen',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'Verwijder veld',
    'LBL_GENERATE_QUOTE' => 'Genereer offerte',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'Er zijn geen velden beschikbaar om en masse bij te werken',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'Uw request voor massaal wijzigen staat gepland.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'Startdatum service overschrijdt einddatum service',
    'LBL_MASS_UPDATE_SUCCESS' => 'Alle records zijn succesvol bijgewerkt',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'Geselecteerde records werden toegevoegd aan de <a href="{{listUrl}}">{{listName}}</a> targetlijst.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'Uw request om de gekozen records aan de <a href="{{listUrl}}">{{listName}}</a> targetlijst toe te voegen, staat gepland.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'De actie zal de volgende waardes verwijderen:',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'Bestaande waarden zullen vervangen worden door lege waarden. Wilt u doorgaan?',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'Primaire e-mail afmelden',
    'LBL_MEETINGS' => 'Afspraken',
    'LBL_MEETING' => 'Afspraak',
    'LBL_MEETING_GO_BACK' => 'Ga terug naar de afspraak',
    'LBL_MEMBERS' => 'Leden',
    'LBL_MEMBER_OF' => 'Lid van',
    'LBL_MODIFIED_BY_USER' => 'Gewijzigd door gebruiker',
    'LBL_MODIFIED_USER' => 'Gewijzigd door gebruiker',
    'LBL_MODIFIED' => 'Gewijzigd door',
    'LBL_MODIFIED_NAME' => 'Gewijzigd door',
    'LBL_MODIFIED_ID' => 'Gewijzigd door ID',
    'LBL_MORE' => 'Meer',
    'LBL_MORE_MODULES' => 'Meer modules',
    'LBL_MORE_TABS' => 'Meer tabbladen',
    'LBL_MULTIPLE_MODULES' => 'Meerdere modules',
    'LBL_COUNT_MODULES' => '{{count}} modules',
    'LBL_MY_ACCOUNT' => 'Mijn instellingen',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'systeemstandaard',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'gebruikersstandaard',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'gebruikersaccount',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'groepsaccount',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'Naam',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Aanmaken',
    'LBL_NEW_BUTTON_TITLE' => 'Aanmaken',
    'LBL_NEXT_BUTTON_LABEL' => 'Volgende',
    'LBL_NOTES' => 'Notities',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Open alle',
    'LBL_OPENALL_BUTTON_TITLE' => 'Open alle',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Open in:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Open in:',
    'LBL_OPEN_IN_NEW_TAB' => 'Openen in nieuw tabblad',
    'LBL_OPPORTUNITIES' => 'Opportunities',
    'LBL_OPPORTUNITY_NAME' => 'Opportunitynaam',
    'LBL_OPPORTUNITY' => 'Mogelijkheid',
    'LBL_OR' => 'OF',
    'LBL_LOWER_OR' => 'of',
    'LBL_PANEL_ASSIGNMENT' => 'Overige gegevens',
    'LBL_PANEL_ADVANCED' => 'Meer informatie',
    'LBL_PANEL_BODY' => 'Overzicht',
    'LBL_PARENT_TYPE' => 'Type bovenliggend',
    'LBL_RELATED_TYPE' => 'Gerelateerd type',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'Fase',
    'LBL_PICTURE_FILE' => 'Afbeelding',
    'LBL_POSTAL_CODE' => 'Postcode:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'Primair adres - plaats:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'Primair adres - land:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'Primair adres - postcode:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Primair adres - provincie:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Primair adres - straat 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Primair adres - straat 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Primair adres - straat:',
    'LBL_PRIMARY_ADDRESS' => 'Primair adres:',

    'LBL_BILLING_STREET' => 'Straat:',
    'LBL_SHIPPING_STREET' => 'Straat:',

    'LBL_PRODUCT_BUNDLES' => 'Productbundels',
    'LBL_PRODUCTS' => 'Producten',
    'LBL_PROJECT_TASKS' => 'Projecttaken',
    'LBL_PRODUCT_TEMPLATES' => 'Product Templates',
    'LBL_PROJECTS' => 'Projecten',
    'LBL_PROSPECTS' => 'Targets',
    'LBL_QUICK_CREATE_MENU' => 'Quick Create menu',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Offerte omzetten naar opportunity',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Offerte omzetten naar opportunity',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'Opportunity aanmaken...',
    'LBL_QUOTES_SHIP_TO' => 'Afleveradres',
    'LBL_QUOTES' => 'Offertes',

    'LBL_FORECAST_WORKSHEETS' => 'Forecastwerkbladen',
    'LBL_FORECAST_WORKSHEET' => 'Forecastwerkblad',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'Uitnodigen',
    'LBL_INVITED' => 'Uitgenodigd',
    'LBL_RECOMMENDED_INVITES' => 'Aanbevolen genodigden',
    'LBL_INSTANCES' => 'Instanties',
    'LBL_YOUR_INSTANCES' => 'Uw instanties',
    'LBL_INSTANCE_USERS' => 'Gebruikers van de instantie',
    'LBL_SWITCH_INSTANCE' => 'Schakel over naar deze instantie',
    'LBL_LAST_LOGIN' => 'Laatste login',
    'LBL_ENTER_EMAIL' => 'Voer e-mail voor genodigde in...',
    'LBL_INSTANCE_IN_USE' => 'Instantie in gebruik',
    'LBL_INSTANCE_ACTIVE' => 'U gebruikt deze instantie al!',
    'LBL_INSTANCE_INVITE_SENT' => 'Uitnodiging gestuurd naar',
    'LBL_INSTANCE_SWITCH_FAILED' => 'Wisselen van instantie mislukt',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'Herinneringen',
    'LBL_REMINDERS_OVERDUE' => 'Achterstallig',
    'LBL_REMINDERS_UPCOMING' => 'Opkomend',
    'LBL_REMINDERS_NONE_FOUND' => 'Geen herinneringen gevonden.',
    'LBL_REMINDERS_FINISHED' => 'Gereed!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'Opportunity cijfers',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'Sweet Spot Configuratiepaneel',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'Hotkeys',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'Kon configuratievoorkeuren niet bijwerken: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'Sweet Spot Actie',
    'LBL_SWEETSPOT_KEY' => 'Trefwoord',
    'LBL_SWEETSPOT_REMOVE' => 'Actie verwijderen',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'Hotkeys',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'Acties',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'Records',
    'LBL_SWEETSPOT_THEME' => 'Thema',
    'LBL_SWEETSPOT_THEME_SELECT' => 'Thema selecteren',

    'LBL_RELATED' => 'Gerelateerd',
    'LBL_RELATED_INFORMATION' => 'Gerelateerde informatie',
    'LBL_RELATED_RECORDS' => 'Gerelateerd aan {{module}}',
    'LBL_REPORTS_TO' => 'Rapporteert aan:',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'Geeft een vereist veld aan',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Gereed',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Opslaan als',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Opslaan als',
    'LBL_FULL_FORM_BUTTON_KEY' => 'F',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Volledig formulier',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Volledig formulier',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Opslaan en nieuw(e) aanmaken',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Opslaan en nieuw(e) aanmaken',
    'LBL_SAVE_OBJECT' => 'Opslaan {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Zoeken',
    'LBL_SEARCH_BUTTON_TITLE' => 'Zoeken',
    'LBL_SEARCH' => 'Zoeken',
    'LBL_SEARCH_TIPS' => 'Klik op de zoeken knop of geef enter om een exacte overeenkomst te krijgen.',
    'LBL_SEARCH_TIPS_2' => 'Klik op de zoeken knop of geef enter om een exacte overeenkomst te krijgen voor',
    'LBL_SEARCH_MORE' => 'meer',
    'LBL_SEE_ALL' => 'Alles bekijken',
    'LBL_SEARCH_LOAD_MORE' => 'LAAD MEER',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Verkeerd bestandsformaat, alleen afbeeldingen kunnen worden geüpload.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'Afbeeldingsformat {0} wordt niet langer ondersteund.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Selecteer',
    'LBL_SELECT_BUTTON_TITLE' => 'Selecteren',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'Team(s) toevoegen',
    'LBL_SELECT_TEAMS_TITLE' => 'Team(s) toevoegen',
    'LBL_SELECT_APPEND_TEAMS' => 'Team(s) toevoegen',
    'LBL_SELECT_APPEND_VALUES' => 'Waarde(n) toevoegen',
    'LBL_SELECT_APPEND_TAGS' => 'Tag(s) toevoegen',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Documenten doorbladeren',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Documenten doorbladeren',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Selecteer persoon',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Selecteer persoon',
    'LBL_GRID_SELECTED_FILE' => 'Geselecteerd bestand',
    'LBL_GRID_SELECTED_FILES' => 'Geselecteerde bestanden',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Selecteer uit rapporten',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Selecteer rapporten',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Selecteer gebruiker',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Selecteer gebruiker',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Selectie wissen',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Selectie wissen',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Selectie wissen',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Selectie wissen',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Bestand selecteren',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Bestand selecteren',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Bestand wissen',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Bestand wissen',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Selecteer gebruiker',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Selecteer gebruiker',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Wis gebruiker',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Wis gebruiker',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Kies organisatie',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Kies organisatie',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Wis organisatie',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Wis organisatie',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Selecteer campagne',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Selecteer campagne',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Wis campagne',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Wis campagne',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'Selecteer persoon',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'Selecteer Persoop',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Wis persoon',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Wis persoon',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Selecteer team',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Selecteer team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Wis team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Wis team',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Items gebruikt om deze pagina te maken (queries, bestanden)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'seconden.',
    'LBL_SERVER_RESPONSE_TIME' => 'Server responstijd:',
    'LBL_SERVER_MEMORY_BYTES' => 'bytes',
    'LBL_SERVER_MEMORY_USAGE' => 'Geheugengebruik server: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Gebruik: - module: {0} - actie: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Server piekgeheugengebruik: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'Verzenden naar organisatie',
    'LBL_SHIP_TO_CONTACT' => 'Verzenden naar persoon',
    'LBL_SHIPPING_ADDRESS' => 'Verzendadres',
    'LBL_SHORTCUTS' => 'Sneltoetsen',
    'LBL_SHOW' => 'Toon',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'Provincie:',
    'LBL_STATUS_UPDATED' => 'Uw status voor deze gebeurtenis is bijgewerkt!',
    'LBL_STATUS_NOT_UPDATED' => 'Uw status voor dit evenement is niet bijgewerkt.',
    'LBL_STATUS' => 'Status:',
    'LBL_STREET' => 'Straat',
    'LBL_SUBJECT' => 'Onderwerp',

    'LBL_INBOUNDEMAIL_ID' => 'Inkomende e-mail ID',
    'LBL_EAMP_ID' => 'Token-ID authenticatie',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'Alle rechten voorbehouden.<br />SugarCRM, Sugar en de 3-D kubus zijn geregistreerde handelsmerken van SugarCRM Inc. ' .
        'Alle andere bedrijfs- en productnamen die in dit product verschijnen, kunnen handelsmerken zijn van de' .
        'respectievelijke bedrijven waar zij aan zijn gekoppeld.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'Geplande taak voltooid',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'De geplande taak werd uitgevoerd',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'Opbrengstregelitems zijn nu geactiveerd in uw Sugar exemplaar',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Revenue Line Items are now enabled in your Sugar instance, and all existing Opportunity data has been processed. Your instance is now ready to be used with Revenue Line Items. For more information about the changes which have been made, please refer to the {{doc_url}}.<br /><br />Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'De module Forecasts is nu klaar voor gebruik met opportuniteiten in uw Sugar exemplaar',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'The Forecasts module in your Sugar instance is now available for use with opportunities. All previous Revenue Line Item forecast commit data has been removed, and the instance is ready for forecasts to be created and committed with opportunities. For more information about the changes which have been made, please refer to the {{doc_url}}.<br /><br />Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Opbrengstregelitems zijn nu gedeactiveerd in uw Sugar exemplaar',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Revenue line Items are now disabled in your Sugar instance, and all existing Revenue Line Item data has been processed. Your instance is now ready to be used with Opportunities. For more information about the changes which have been made, please refer to the {{doc_url}}.<br /><br />Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'Configuratiedocumentatie Opportuniteiten',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'Inloggen',
    'LBL_LOGIN_WELCOME_TO' => 'Welkom bij',
    'LBL_LOGIN_OPTIONS' => 'Opties',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'Wachtwoord vergeten?',
    'LBL_LOGIN_SUBMIT' => 'Verzenden',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'Teveel mislukte inlogpogingen.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'U kunt opnieuw proberen in te loggen in',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'dagen.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 'u.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'min.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'sec.',
    'LBL_LOGIN_ADMIN_CALL' => 'Gelieve contact op te nemen met de administator.',
    'LBL_LOGIN_USERNAME' => 'Gebruikersnaam',
    'LBL_LOGIN_PASSWORD' => 'Wachtwoord',
    'LBL_LOGGED_OUT' => 'U bent uitgelogd.',
    'LBL_LOGIN_FORM_LABEL' => 'Toon inlogformulier',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'Terug naar aanmelden',
    'LBL_LOGIN_INACTIVE_USER' => 'Inactieve gebruiker',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'Portaal of groepsgebruiker kan niet aanmelden.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'Home',
    'LBL_SYNC' => 'Synchroniseren',
    'LBL_TASKS' => 'Taken',
    'LBL_TEAMS_LINK' => 'Teams',
    'LBL_THEME_COLOR' => 'Kleur',
    'LBL_THEME_FONT' => 'Font',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'Plan een afspraak',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'Plan een afspraak',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'E-mail archiveren',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'E-mail archiveren',
    'LBL_UNAUTH_ADMIN' => 'Ongeautoriseerde toegang tot beheer',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Verwijderen ongedaan maken',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Verwijderen ongedaan maken',
    'LBL_UNDELETE_BUTTON' => 'Verwijderen ongedaan maken',
    'LBL_UNDELETE' => 'Verwijderen ongedaan maken',
    'LBL_UNSYNC' => 'Niet synchroniseren',
    'LBL_UPDATE' => 'Bijwerken',
    'LBL_UPDATES' => 'Updates',
    'LBL_USER_LIST' => 'Gebruikers',
    'LBL_USER_MENU' => 'Gebruikersmenu',
    'LBL_USERS_SYNC' => 'Gebruiker synchroniseren',
    'LBL_USERS' => 'Gebruikers',
    'LBL_USER' => 'Gebruiker',
    'LBL_CURRENT_USER' => 'Huidige gebruiker',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'Controleren of e-mailadres reeds bestaat...',
    'LBL_VERIFY_PORTAL_NAME' => 'Controleren of portalnaam reeds bestaat...',
    'LBL_VIEW_IMAGE' => 'bekijk',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'Afdrukken als PDF',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'Afdrukken als PDF',

    'LBL_KBDOCUMENTS' => 'Knowledge Base',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'Over ons',
    'LNK_ADVANCED_SEARCH' => 'Geavanceerd zoeken',
    'LNK_BASIC_SEARCH' => 'Basis zoeken',
    'LNK_SEARCH_NO_RESULTS' => 'Geen resultaten gevonden.',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'Toon alle resultaten',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Toon alles',
    'LNK_CLOSE' => 'Sluiten',
    'LBL_MODIFY_CURRENT_SEARCH' => 'Wijzig huidige zoekopdracht',
    'LNK_SAVED_VIEWS' => 'Layout instellingen',
    'LNK_DELETE_ALL' => 'verwijder alles',
    'LNK_DELETE' => 'verwijderen',
    'LNK_EDIT' => 'wijzigen',
    'LNK_VIEW' => 'bekijk',
    'LNK_GET_LATEST' => 'Haal nieuwste',
    'LNK_GET_LATEST_TOOLTIP' => 'Vervang door laatste versie',
    'LNK_HELP' => 'Help',
    'LNK_CREATE' => 'Aanmaken',
    'LNK_CREATE_WHEN_EMPTY' => 'Maak nu een nieuw record aan.',
    'LNK_LIST_END' => 'Einde',
    'LNK_LIST_NEXT' => 'Volgende',
    'LNK_LIST_PREVIOUS' => 'Vorige',
    'LNK_LIST_RETURN' => 'Ga terug naar lijst',
    'LNK_LIST_START' => 'Start',
    'LNK_LOAD_SIGNED' => 'Teken',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'Vervang door gesigneerd document',
    'LNK_PRINT' => 'Afdrukken',
    'LNK_BACKTOTOP' => 'Terug naar boven',
    'LNK_REMOVE' => 'verwijderen',
    'LNK_RESUME' => 'Hervatten',
    'LNK_VIEW_CHANGE_LOG' => 'Auditlogboek bekijken',
    'TPL_AUDIT_LOG_TITLE' => 'Auditlogboek voor {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'Klik om het auditlog van het e-mailadres te bekijken',
    'LBL_NO_SEARCH_RESULTS' => 'Er zijn geen resultaten gevonden voor uw zoekopdracht',
    'NTC_CLICK_BACK' => 'Klikt u a.u.b. op de &#39;terug&#39; knop in uw browser en los het probleem op.',
    'NTC_DATE_FORMAT' => '(jjjj-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(jjjj-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'Weet je zeker dat je de geselecteerde records wilt verwijderen?',
    'NTC_TEMPLATE_IS_USED' => 'De sjabloon is gebruikt in tenminste één e-mailmarketingrecord. Weet u zeker dat u het wilt verwijderen?',
    'NTC_TEMPLATES_IS_USED' => "De volgende sjablonen worden gebruikt in e-mailmarketingrecord. Weet u zeker dat u ze wilt verwijderen?",
    'NTC_DELETE_CONFIRMATION' => 'Weet u zeker dat u dit record wilt verwijderen?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'Weet u zeker dat u de {0} wilt verwijderen?',
    'LBL_METRIC_DELETE_WARNING' => 'Alle gebruikers waar dit tabblad met statistieken mee is gedeeld, verliezen ook hun toegang.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'Weet u zeker dat u verder wil gaan met het verwijderen van de',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'Weet u zeker dat u verder wil gaan met het wijzigen van de',
    'NTC_DELETE_SELECTED_RECORDS' => 'geselecteerde record(s)?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'Dit filter wordt verwijderd van alle weergaven; Dit heeft mogelijk effect op de configuratie van dashlets. Weet u zeker dat u dit filter wilt verwijderen?',
    'TPL_DELETE_FILTER_SUCCESS' => 'U heeft het filter {{name}} verwijderd.',
    'NTC_DELETE_SUCCESS' => 'U heeft het {0} verwijderd.',
    'NTC_UNLINK_CONFIRMATION' => 'Weet u zeker dat u deze koppeling ongedaan wilt maken?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'Weet u zeker dat u de relatie met {0} wilt verwijderen?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'Weet u zeker dat u de {0} wilt ontkoppelen? Daardoor wordt deze ook uit het veld Primaire contactpersoon van de case verwijderd.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => 'De {0} kan niet worden ontkoppeld omdat deze de primaire contactpersoon is van deze case. Werk het veld Primaire contactpersoon bij voordat u deze record ontkoppelt.',
    'NTC_UNLINK_SUCCESS' => 'U heeft het {0} ontkoppeld.',
    'NTC_LOGIN_MESSAGE' => 'Eerst inloggen a.u.b.',
    'NTC_NO_ITEMS_DISPLAY' => 'geen',
    'NTC_REMOVE_CONFIRMATION' => 'Weet u zeker dat u deze koppeling wilt verwijderen?<br>Alleen de relatie wordt verwijderd. Het record zal niet worden verwijderd.',
    'NTC_REQUIRED' => 'Geeft een vereist veld aan',
    'NTC_SUPPORT_SUGARCRM' => 'Steun het SugarCRM open source project met een donatie via Paypal - snel, gratis en veilig!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'Welkom',
    'NTC_YEAR_FORMAT' => '(jjjj)',
    'LOGIN_LOGO_ERROR' => 'Vervang a.u.b. de SugarCRM logo&#39;s.',
    'FATAL_LICENSE_ALTERED' => 'Je licentie is gewijzigd sinds de laatste keer dat je het hebt gevalideerd.',
    'ERROR_FULLY_EXPIRED' => "Uw bedrijfslicentie voor SugarCRM is meer dan 7 dagen geleden verstreken en moet worden bijgewerkt. Alleen admins kunnen inloggen.",
    'ERROR_LICENSE_EXPIRED' => "Uw bedrijfslicentie voor SugarCRM moet worden bijgewerkt. Alleen admins kunnen inloggen.",
    'WARN_LICENSE_EXPIRED' => "Uw licentie voor SugarCRM verloopt binnenkort.",
    'ERROR_LICENSE_VALIDATION' => "Uw bedrijfslicentie voor SugarCRM moet worden gevalideerd. Alleen admins kunnen inloggen.",
    'WARN_LICENSE_VALIDATION' => "Uw bedrijfslicentie voor SugarCRM moet binnenkort worden gevalideerd.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>Waarschuwing:</b> Uw browser ingesteld op  &#39;IE compatibility view&#39;. Dit wordt niet ondersteund.',
    'WARN_LICENSE_SEATS' => 'Waarschuwing: Het aantal actieve gebruikers is al gelijk aan het maximale aantal toegestane licenties.',
    'WARN_LICENSE_SEATS_MAXED' => 'Waarschuwing: Het aantal actieve gebruikers is hoger dan het maximale aantal toegestane licenties.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'Aantal actieve gebruikers overschrijdt Licentielimiet. Neem contact op met uw beheerder.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'Alleen admins kunnen inloggen.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'De gebruikerslicentielimiet is bereikt. Alleen bestaande gebruikers kunnen inloggen.',
    'WARN_ONLY_ADMINS' => 'Alleen admins kunnen inloggen.',
    'WARN_UNSAVED_CHANGES' => 'U staat op het punt om het record te verlaten zonder de wijzigingen op te slaan. Weet u zeker dat u dit wil?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Door de browser te vernieuwen, worden alle SugarLive oproepen of chatsessies die u geopend hebt automatisch gesloten en gaan alle niet-opgeslagen veranderingen verloren. Wilt u doorgaan?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'Niet alle wijzigingen zijn opgeslagen. Weet u zeker dat u de pagina wilt verlaten en de wijzigingen wilt negeren?',
    'LBL_MFA_RESET_CONFIRMATION' => 'Weet u zeker dat u uw <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">meerfactorauthenticatie</a> wilt resetten? 
Als u dit doet, wordt u direct afgemeld en moet u opnieuw authenticeren met de authenticatie-app als u weer wilt aanmelden.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'Bevestigen & afmelden',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'Een of meer dashlets bevatten niet-opgeslagen veranderingen. Weet u zeker dat u de lade wilt sluiten?',
    'LBL_NAVIGATE_TO_REPORTS' => 'U gaat nu naar de rapportagemodule. Uw wijzigingen aan het dashlet worden niet opgeslagen. Wilt u doorgaan?',
    'ERROR_NO_RECORD' => 'Fout bij het ophalen van het record. Het record is verwijderd of u heeft geen autorisatie om het te bekijken.',
    'ERROR_TYPE_NOT_VALID' => 'Fout. Dit type is niet geldig.',
    'ERROR_MAX_FIELD_LENGTH' => 'Fout. De maximale lengte van dit veld is {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'Fout. De minimale lengte van dit veld is {{this}}.',
    'ERROR_EMAIL' => 'Fout. Ongeldig e-mailadres: {{#each this}}{{this}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'Fout. Er moet minimaal één primair adres opgegeven worden.',
    'ERROR_DUPLICATE_EMAIL' => 'Fout. Duplicaat e-mailadres: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'Fout. Dit veld is vereist.',
    'ERROR_MINVALUE' => 'Fout. De minimale waarde van dit veld is {{this}}.',
    'ERROR_MAXVALUE' => 'Fout. De maximale waarde van dit veld is {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'Fout. De waarde van dit veld moet groter zijn dan {{this}}.',
    'ERROR_IS_LESS_THAN' => 'Fout. De waarde van dit veld moet kleiner zijn dan {{this}}.',
    'ERROR_DATETIME' => 'Fout. Dit veld vereist een geldige datum.',
    'ERROR_IS_BEFORE' => 'Fout. De datum van dit veld kan niet liggen na de datum van het veld {{this}}.',
    'ERROR_IS_AFTER' => 'Fout. De datum van dit veld kan niet liggen voor de datum van het veld {{this}}.',
    'ERROR_TIME_IS_BEFORE' => 'Fout. De tijd van dit veld kan niet liggen na de datum van het veld {{this}}.',
    'ERROR_TIME_IS_AFTER' => 'Fout. De tijd van dit veld moet na de datum van het veld {{this}} liggen.',
    'ERROR_NUMBER' => 'Fout. Dit veld vereist een geldige waarde.',
    'ERROR_INT' => 'Fout. Ongeldige integer.',
    'ERROR_URL' => 'Fout. Ongeldige URL.',
    'ERROR_NO_BEAN' => 'Kon geen bean krijgen.',
    'ERROR_ACCESS_MODULE' => 'U heeft geen toegang tot deze module.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'Error. De bijlage is te groot.',
    'ERROR_UPLOAD_FAILED' => 'Error. Het bestand kon niet worden geüpload.',
    'ERROR_UPLOAD_ACCESS_PD' => 'U bent niet gemachtigd om voor deze module [process definitions] te maken.',
    'ERROR_UPLOAD_ACCESS_BR' => 'U bent niet gemachtigd om voor deze module [business rules] te maken.',
    'ERROR_UPLOAD_ACCESS_ET' => 'U bent niet gemachtigd om voor deze module [email templates] te maken.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'Fout. U hebt een niet-ondersteunde operator ingevoerd.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'Fout. U hebt een ongeldige operator ingevoerd.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'Fout. U hebt een ongeldige ingevoerd.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'Importeren mislukt. Een groepsveld is gedeeltelijk geblokkeerd in de procesdefinitie.' .
        ' Deze velden moeten zijn ontgrendeld in de procesdefinitie om de definitie te kunnen importeren.',
    'ERROR_EXP_DATE_LOW' => 'Fout. Vervaldatum kan niet voor de publicatiedatum liggen.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'Fout. De status Goedgekeurd vereist een datum van publicatie.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'De publicatiedatum is leeg.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'Zoek duplicaten',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'Duplicatencontrole is uitgeschakeld voor {{module}}.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'Beheer abonnementen',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Beheer abonnementen voor',
    'LBL_SUBSCRIBE' => 'Abonneren',
    'LBL_UNSUBSCRIBE' => 'Afmelden',
    'LBL_CREATE_LINK_RECORD' => 'Maak en koppel record',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'Maak en koppel record',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} records zijn gekoppeld.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'Geen records om te koppelen.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'Her gekozen rapport is niet gebaseerd op het juiste module type.',
    'ERROR_EMPTY_LINK_MODULE' => 'Selecteer a.u.b. de relatie eerst.',
    // Ajax status strings
    'LBL_LOADING' => 'Laden...',
    'LBL_LOADING_NO_DOTS' => 'Bezig met laden',
    'LBL_SEARCHING' => 'Zoeken...',
    'LBL_SEARCH_UNDERWAY' => 'Zoeken',
    'LBL_SAVING_LAYOUT' => 'Layout opslaan...',
    'LBL_SAVED_LAYOUT' => 'Layout is opgeslagen.',
    'LBL_SAVED' => 'Opgeslagen',
    'LBL_SAVING' => 'Opslaan',
    'LBL_FAILED' => 'Mislukt!',
    'LBL_DISPLAY_COLUMNS' => 'Weergegeven kolommen',
    'LBL_HIDE_COLUMNS' => 'Verborgen kolommen',
    'LBL_SEARCH_CRITERIA' => 'Zoekcriteria',
    'LBL_SAVED_VIEWS' => 'Opgeslagen views',
    'LBL_PROCESSING_REQUEST' => 'Verwerken..',
    'LBL_REQUEST_PROCESSED' => 'Gereed',
    'LBL_AJAX_FAILURE' => 'Ajax falen',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'Zoeken...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Opgeslagen zoekcriteria',
    'LBL_SEARCH_POPULATE_ONLY' => 'Zoeken met bovenstaande zoekcriteria',
    'LBL_SEARCH_NO_RESULTS' => 'Geen resultaten gevonden voor',
    'LBL_SEARCH_FOR' => 'Zoek naar',
    'LBL_SEARCH_FOR_MORE' => 'Zoeken naar meer...',
    'LBL_SEARCH_SELECT' => 'Selecteer...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'Zoeken en selecteren...',
    'LBL_SEARCH_SELECT_MODULE' => 'Kies {{module}}...',
    'LBL_DETAILVIEW' => 'Detailweergave',
    'LBL_LISTVIEW' => 'Lijstweergave',
    'LBL_EDITVIEW' => 'Wijzig weergave',
    'LBL_SEARCHFORM' => 'Zoeken',
    'LBL_SAVED_SEARCH_ERROR' => 'Geef a.u.b. deze weergave een naam.',
    'LBL_DISPLAY_LOG' => 'Bekijk log',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Locatie:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Beschrijving:',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'begint om',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'Klik op OK om deze oproep te bekijken of klik op Annuleren om dit bericht te laten verdwijnen.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'Klik op OK om deze bijeenkomst te bekijken of klik op Annuleren om dit bericht te laten verdwijnen.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'Geen resultaten gevonden.',
    'MSG_LIST_VIEW_NO_RESULTS' => 'Geen resultaten gevonden voor',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Maak als een nieuw',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'U heeft geen gegevens opgeslagen. Maak <item2> gegevens aan of <item3> gegevens nu.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'U heeft geen records opgeslagen. Maak nu een <item2> record aan.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'You can create <item1> from a <item2>. <item3> <item2> list.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'Positief',
    'LBL_SENTIMENT_NEUTRAL' => 'Neutraal',
    'LBL_SENTIMENT_NEGATIVE' => 'Negatief',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'Geen tabbladen met statistieken geconfigureerd',
    'LBL_NO_METRIC_VISIBLE' => 'Geen metrische tabbladen zichtbaar',
    'LBL_MAKE_METRIC_VISIBLE' => 'Kies &#39;organiseren&#39; om metrische tabbladen zichtbaar te maken',
    'LBL_PLEASE_CONTACT_ADMIN' => 'Gelieve contact op te nemen met uw beheerder',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'Klik hier',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Voeg toe aan mijn favorieten',
    'LBL_MARK_AS_FAVORITES' => 'Markeer als favoriet',
    'LBL_CREATE_CONTACT' => 'Persoon aanmaken',
    'LBL_CREATE_NOTE' => 'Notitie aanmaken',
    'LBL_CREATE_OPPORTUNITY' => 'Opportunity aanmaken',
    'LBL_SCHEDULE_CALL' => 'Plan telefoongesprek',
    'LBL_SCHEDULE_CALL2' => 'Telefoongesprek',
    'LBL_SCHEDULE_MEETING' => 'Plan afspraak',
    'LBL_SCHEDULE_MEETING2' => 'Afspraak',
    'LBL_CREATE_MESSAGE' => 'Bericht opstellen',
    'LBL_CREATE_MESSAGE2' => 'Bericht',
    'LBL_CREATE_TASK' => 'Taak aanmaken',
    'LBL_CREATE_TASK2' => 'Taak',
    'LBL_REMOVE_FROM_FAVORITES' => 'Verwijder uit mijn favorieten',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'Notitie',
    'LBL_DOWNLOAD_ALL' => 'Alle downloaden',
    'LBL_DOWNLOAD_ONE' => 'Downloaden',
    'LBL_ATTACHMENTS' => 'Bijlagen',
    'LBL_ADD_ATTACHMENT' => 'Bladeren',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Genereer formulier',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Web-to-lead-formulier opslaan',

    'LBL_PLEASE_SELECT' => 'Kies a.u.b.',
    'LBL_REDIRECT_URL' => 'Redirect URL',
    'LBL_RELATED_CAMPAIGN' => 'Gerelateerde campagne',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Voeg alle velden toe',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Verwijder alle velden',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Alleen de volgende afbeeldingstypes kunnen worden ingebed: JPG, PNG.',
    'LBL_REMOVE' => 'Verwijder',
    'LBL_TRAINING' => 'Ondersteuning',
    'ERR_DATABASE_CONN_DROPPED' => 'Fout tijdens uitvoeren van query. Mogelijk is er geen verbinding met de database. Ververs deze pagina en herstart eventueel uw web-server.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'Error setting {0} relationship: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'Database context veranderd naar',
    'ERR_MSSQL_WARNING' => 'Waarschuwing:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'vCard format parsen is mislukt',
    'ERR_VCARD_FILE_MISSING' => 'vcf bestand ontbreekt',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Waarschuwing: Veld [[field]] is niet of onjuiste gedefinieerd in [moduleDir] vardefs.php bestand',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Fout: Bestand [[file]] mist. Bestand kan niet aangemaakt worden daar er geen overeenkomstig HTML bestand gevonden is.',
    'ERR_CANNOT_FIND_MODULE' => 'Fout: Module [module] bestaat niet.',
    'LBL_ALT_ADDRESS' => 'Ander adres:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Fout: Er is een ongelijk aantal argumenten voor de &#39;key&#39; en &#39;copy&#39; elementen in de displayParams array.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Index in displayParams Array ontbreekt voor:',

    'LBL_DASHLET' => 'Dashlet',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filters',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Alleen mijn Items',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Titel',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Rijen weergeven',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'Koppel aan huidige record',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'Gekoppeld veld',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'Eerste kolom bevriezen',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'Weet u het zeker dat u dit dashlet wilt verwijderen?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'Weet u zeker dat u de rij wilt verwijderen?',
    'LBL_MAXIMUM_OF' => 'Maximum van&nbsp;',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => '&nbsp;kolommen kunnen getoond worden.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'Dashboard',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'Mijn dashboard',
    'LBL_COLLAPSE_ALL' => 'Alles inklappen',
    'LBL_EXPAND_ALL' => 'Alles uitklappen',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'Wijzig',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'Rapport bekijken',
    'LBL_DASHLET_REFRESH_LABEL' => 'Vernieuwen',
    'LBL_DASHLET_REMOVE_LABEL' => 'Verwijder',
    'LBL_DASHLET_DROP_HERE' => 'Plaats hier',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'Minimaliseren',
    'LBL_DASHLET_MAXIMIZE' => 'Maximaliseren',
    'LBL_DASHLET_CONFIGURE' => 'Configureer',
    'LBL_DASHLET_TOGGLE' => 'Kies zichtbaarheid dashboard',
    'LBL_SIDEPANE_TOGGLE' => 'Zijpaneel openen/sluiten',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'Standaard dashlets herstellen',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'Geen dashboard geconfigureerd',
    'LBL_CREATE_DASHBOARD_LINK' => 'Maak dashboard',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'Hulp',
    'LBL_HELPLET_TOGGLE' => 'Openen/Sluiten',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'Modules',
    'LBL_FACET_MODIFIED_BY_ME' => 'Modified by Me',
    'LBL_FACET_CREATED_BY_ME' => 'Aangemaakt door mij',
    'LBL_FACET_MY_FAVORITES' => 'Mijn favorieten',
    'LBL_FACET_ASSIGNED_TO_ME' => 'Assigned to Me',
    'LBL_FACET_NO_DATA' => 'No data for this facet.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'Lijstweergave',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'Tonen van records toegewezen aan u',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'Lijstweergave console',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'Geeft records van een bepaalde module weer die betrekking hebben op de record die u bekijkt in de console.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'Recordweergave',
    'LBL_RELATED_RECORDS' => 'Gerelateerd aan {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'Geeft een record en mogelijk bijbehorende records weer in tabbladen.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'Type basis record',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'Deze {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'Tabbladen',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'Voorvertoning basis layout',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'Waarschuwing, alleen de modules {{numWord}} ({{num}}) mogen in tabbladen worden weergegeven. ' .
        'Verwijder een of meerdere modules voordat u nieuwe toevoegt.',
    'LBL_SIX' => 'zes', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'Comment Log',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'Geeft de opmerkingen weer voor een record',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'Geen opmerkingen beschikbaar',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'Toevoegen',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'Opmerking toevoegen',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'Alle bekijken',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'Gegevens niet beschikbaar. U heeft geen toestemming om toegang te krijgen tot deze modules.' .
    " \nGelieve deze dashlet bij te werken of te verwijderen.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'Mijn {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'Geen record geselecteerd voor weergave',
    'LBL_CONTENT_SEARCH_DASHLET' => 'Dashlet content zoeken',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'Waar kunnen we u vandaag mee helpen, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'Wilt u een case aanmaken?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'Opportunity cijfers',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'Opportunitymetriek voor soortgelijk account.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'Productcatalogus Snel kiezen',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'Geeft recentelijk gebruikte items en producten weer die zijn opgeslagen als favorieten',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'Recentelijk gebruikt',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'Favorieten',

    'LBL_DASHBOARD_CREATE' => 'Maak dashboard',
    'LBL_DASHBOARD_DUPLICATE' => 'Dashboard kopiëren',
    'LBL_DASHBOARD_DELETE' => 'Dashboard verwijderen',
    'LBL_PIN_TO_TOP' => 'Boven vastmaken',
    'LBL_PIN_TO_BOTTOM' => 'Onder vastmaken',
    'LBL_MANAGE_DASHBOARDS' => 'Dashboards beheren',

    'LBL_DASHBOARD_CONFIG' => 'Database Configuratie',
    'LBL_LIST_VIEW__NAME' => 'Lijstweergave',
    'LBL_PIPELINE_VIEW_NAME' => 'Tegelweergave',
    'LBL_PIPELINE_VIEW_BTN' => 'Tegelweergave',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} op {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'Tegelweergave is niet ingeschakeld',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'Er werden nu geen gegevens gevonden.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'Samenvatting van Cases',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'Tijdlijn',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'Bijlagen',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'Notities & bijlagen behoren bij het record',
    'LBL_DASHLET_PIPLINE_NAME' => 'Pijplijn',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'Recente Tweets - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'Geen opgeslagen dashboards',

    'LBL_DNB_AND' => 'en',
    'LBL_DNB_PRIM_NAME_DESC' => 'Bevat de naam van deze organisatie',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'Beantwoord',
    'LBL_TWITTER_RETWEET' => 'Retweet',
    'LBL_TWITTER_FAVORITE' => 'Favoriet',
    'LBL_TWITTER_FOLLOW' => 'Volgen',
    'LBL_TWITTER_DESCRIPTION' => 'Bekijk de biografie en tweets van de bijbehorende Twitter gebruiker. Retweet en reageer op tweets.',
    'LBL_TWITTER_ID' => 'Twitter-ID',
    'LBL_TWITTER_DISPLAY_ROWS' => 'Rijen weergeven',
    'LBL_TWITTER_MY_ACCOUNT' => 'Mijn account',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Bron-Tweet:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'Trainingsmiddelen',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'Training & certificering',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub community',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'Documentatie & ondersteuning',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'Marktplaats SugarOutfitters',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'Verkopen per land',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'Toon de verkoopdiagram mbv de landkaart',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'Categorieën & gepubliceerde artikelen kennisbasis',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'Knowledge Base zoeken',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'Geeft een doorzoekbare boomweergave weer van gepubliceerde kennisbasisartikelen en categorieën.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'Gepubliceerde artikelen in andere talen',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'Meest nuttige gepubliceerde kennisdatabankartikelen',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'Geeft de artikelen uit de kennisbasis weer die de meeste likes hebben gekregen en het meest bekeken zijn',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} gefilterd op {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'Nuttigheid van artikelen',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'Pagina toevoegen',
    'LBL_LOADING_PAGE' => 'Pagina laden, a.u.b. wachten...',
    'LBL_SEARCH_RESULTS' => 'Zoekresultaten',
    'LBL_SEARCH_RESULTS_FOR' => 'Zoekresultaten voor: ',
    'LBL_SEARCH_HELP_TITLE' => 'Zoektips',
    'LBL_SEARCH_RESULTS_FOUND' => 'Gevonden zoekresultaten',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'Mijn pijplijn',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "Pijplijn van mijn team",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'Grafiek verkooppijplijn',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'Toont huidige pijplijngrafiek.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'Geen afbeelding',

    'LBL_MODULE' => 'Module',
    'LBL_RELATIONSHIP' => 'Relaties',
    'LBL_SINGULAR_LABEL' => 'Enkel label',
    'LBL_PLURAL_LABEL' => 'Meervoudig label',
    'LBL_MODULE_DISPLAY' => 'Weergave',
    'LBL_MODULE_DISPLAY_TYPE' => 'Weergavetype',
    'LBL_MODULE_ICON' => 'Icoon',
    'LBL_MODULE_COLOR' => 'Achtergrondkleur van module',
    'LBL_LANGUAGE_SELECTOR' => 'Taal',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'Module-instellingen',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'De module-instellingen zijn opgeslagen.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Kopieer het linker adres:',
    'LBL_SAVE_AND_CONTINUE' => 'Opslaan en verder',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Werken met multiselect-velden</strong></p><ul><li>Klik op de waarden om er een te selecteren.</li><li>Houdt Ctrl ingedrukt om meerdere waarden te selecteren. Bij Mac gebruik CMD.</li><li>Om alle waarden tussen twee waarden te kiezen,&nbsp; klik dan eerst op de eerste waarde en vervolgens met shift op de laatste waarde.</li></ul><p><strong>Geavanceerde zoek- en weergave-opties</strong><br><br>Door gebruik te maken van de <b>Opgeslagen zoekcriteria</b>, kunt u een voorgedefinieerde zoekopdracht en/of aangepaste list view opslaan om snel de gewenste zoekresultaten op te kunnen vragen. U kunt een onbeperkt aantal persoonlijke opgeslagen zoekopdrachten aanmaken. Alle opgeslagen zoekopdrachten worden getoond op naam in de lijst met opgeslagen zoekcriteria, waarbij de laatst opgeslagen zoekopdracht bovenaan staat.<br><br>Om de weergave in de lijstweergave aan te passen, maakt u gebruik van de layout instellingen. Gebruik de kolommen &#39;Weergegeven kolommen&#39; en &#39;Verborgen kolommen&#39; om een keuze te maken welke velden getoond worden in de zoekresultaten. U kunt bijvoorbeeld gegevens verbergen als bestandsnaam, toegewezen gebruiker en team. Om een kolom toe te voegen aan de lijstweergave, selecteert u het veld in de lijst met &#39;verborgen kolommen&#39; en gebruikt u de linker pijl om het veld te verplaatsen naar de &#39;weergegeven kolommen&#39;. Om een uit de weergave te verwijderen, selecteert u het veld in de lijst met &#39;weergegeven kolommen&#39; en klik u op de rechter pijl m het veld te verplaatsen naar de &#39;verborgen kolommen&#39;.<br><br>Als u de layout instellingen opslaat als opgeslagen zoekopdracht, kunt u deze weergave ten alle tijde opvragen.<br><br>Om een zoekopdracht op te slaan en/of bij te werken:<ol><li>Voer een naam in voor de zoekopdracht in het veld <b>Bewaar zoekopdracht als</b> en klik op <b>Opslaan</b>. De naam wordt nu getoond in het veld opgeslagen zoekcriteria, nabij de knop <b>Wissen</b> knop.</li><li>Om een opgeslagen zoekopdracht op te vragen, selecteert u deze in de lijst met opgeslagen zoekcriteria. De zoekresultaten worden direct opgevraagd en getoond in de List View.</li><li>Om de eigenschappen van een opgeslagen zoekopdracht bij te werken, selecteert u deze vanuit de lijst met opgeslagen zoekcriteria. Vervolgens past u de zoekopdracht en/of weergave aan in de geavanceerde zoekdracht en klikt u op <b>Bijwerken</b> bij <b>Wijzig huidige zoekopdracht</b>.</li><li>Om een opgeslagen zoekopdracht te verwijderen, selecteert u deze in de lijst met opgeslagen zoekcriteria. Vervolgens klikt u op <b>Verwijderen</b> bij <b>Wijzig huidige zoekdracht</b>. U moet nu uw actie bevestigen.</li></ol><p><strong>Tips</strong><br><br>Door gebruik te maken van het %-teken als wildcard, kunt u uw zoekopdracht uitbreiden. Als u bijvoorbeeld niet zoekt met "CRM", maar met "%CRM%", zult u resultaten krijgen waarin CRM voorkomt eventueel met andere karakters voorkomen. Bijvoorbeeld zoals SugarCRM.</p>',

    //resource management
    'ERR_QUERY_LIMIT' => 'Fout: Query limiet van $limit bereikt voor module $module bereikt.',
    'ERROR_NOTIFY_OVERRIDE' => 'Fout: ResourceObserver->notify() is een &#39;override&#39; nodig.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'Fout: Unable to create monitor because metadata file is empty or file does not exist.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'Fout: There is no monitor configured for requested name.',
    'ERR_UNDEFINED_METRIC' => 'Fout: Niet mogelijk een waarde toe te kennen aan een ongedefinieerde metriek.',
    'ERR_STORE_FILE_MISSING' => 'Fout: Kan Store implementation bestand niet vinden',

    'LBL_MONITOR_ID' => 'Monitor ID',
    'LBL_TEAM_ID' => 'Team-ID',
    'LBL_SELECT_MODULE' => 'Kies een module',
    'LBL_USER_ID' => 'Gebruiker ID',
    'LBL_MODULE_NAME' => 'Modulenaam',
    'LBL_MODULE_ALL' => 'Alle',
    'LBL_ITEM_ID' => 'Item ID',
    'LBL_ITEM_SUMMARY' => 'Item samenvatting',
    'LBL_ACTION' => 'Actie',
    'LBL_SESSION_ID' => 'Sessie ID',
    'LBL_BREADCRUMBSTACK_CREATED' => 'BreadCrumbStack gemaakt voor gebruiker id {0}',
    'LBL_VISIBLE' => 'Zichtbaar record',
    'LBL_DATE_LAST_ACTION' => 'Datum van laatste actie',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL Tekst',
    'LBL_QUERY_HASH' => 'SQL Hash',
    'LBL_SEC_TOTAL' => 'Totaal aantal seconden',
    'LBL_SEC_AVG' => 'Gemiddeld aantal seconden',
    'LBL_RUN_COUNT' => 'Query telling',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'Klanten IP adres',
    'LBL_DATE_START' => 'Startdatum',
    'LBL_ACTIVE' => 'Actieve sessie',
    'LBL_ROUNDTRIPS' => 'Aantal acties',
    'LBL_SECONDS' => 'Seconden actief',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'Database retour',
    'LBL_FILES_OPENED' => 'Aangesproken bestanden',
    'LBL_MEMORY_USAGE' => 'Geheugengebruik (bytes)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'Twitter Connector wordt geladen...',
    'LBL_TWITTER_DATA_EMPTY' => 'Geen gegevens beschikbaar van Twitter',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Sugar Plug-in voor Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Integreer Sugar e-mail en agenda-informatie met Microsoft Outlook.',
    'LBL_PLUGIN_WORD_NAME' => 'Sugar Plug-in voor Word',
    'LBL_PLUGIN_WORD_DESC' => 'Vul brieven, e-mail en andere Microsoft-documenten met informatie vanuit Sugar',
    'LBL_PLUGIN_EXCEL_NAME' => 'Sugar Plug-in voor Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'Intergreer Sugar met spreadsheets voor een betere analyse van de belangrijkste statistieken',
    'LBL_PLUGINS_TITLE' => 'Sugar Plug-ins voor Microsoft Office <sup>TM</sup>',
    'LBL_PLUGINS_DESC' => 'Lees meer over de plug-in functies in de  <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">Plug-In Documentatie</a>&#39;',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Sugar Plug-ins voor Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'Sugar Plug-in voor Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'Integreer Sugar met Lotus Notes.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'is niet voor',
    'MSG_IS_MORE_THAN' => 'is meer dan',
    'MSG_IS_LESS_THAN' => 'is minder dan',
    'MSG_SHOULD_BE' => 'zou worden',
    'MSG_OR_GREATER' => 'of groter',
    'MSG_EXCEEDS_MAXLEN' => 'overschrijdt de max gespecificeerde lengte ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Welkom bij Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal is een framework die real-time inzicht geeft in Cases, Bugs, Nieuwsbrieven etc. aan klanten. Het is een externe interface voor Sugar die kan worden geïmplementeerd in elke website. In de toekomst zullen er meer features worden toegevoegd als Project Management en Forums.',
    'LBL_LIST' => 'Lijst',
    'LBL_CREATE_CASE' => 'Case aanmaken',
    'LBL_CREATE_BUG' => 'Bug aanmaken',
    'LBL_NO_RECORDS_FOUND' => '- 0 gevonden records -',

    'DATA_TYPE_DUE' => 'Vervalt:',
    'DATA_TYPE_START' => 'Start:',
    'DATA_TYPE_SENT' => 'Verzonden:',
    'DATA_TYPE_MODIFIED' => 'Gewijzigd:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Aantal',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'objectafbeelding',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'Kies datum',

    'LBL_VALIDATE_RANGE' => 'valt niet binnen het geldige bereik',
    'LBL_VALIDATE_URL' => 'is geen geldige URL',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'Alle',

    'LBL_OPERATOR_IN_TEXT' => 'is een van de volgende:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'is niet een van de volgende:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Fout: Array count van de bean-parameter komt niet overeen met de Array count in de results.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Fout: &#39;Mapping entry&#39; voor module ontbreekt.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Fout: Kan geen data ophalen voor {0} Connector. De service kan tijdelijk niet toegankelijk zijn of de instellingen kunnen foutief geconfigureerd zijn. Connector foutmelding: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'Data ophalen mislukt. De dienst kan op dit moment niet toegankelijk zijn of de configuratie is onjuist.',
    'LBL_CONNECT_TWITTER' => 'Verbind met Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'Kan geen geldige tijdlijn vinden voor Twitter ID:',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'Configureer Twitter connector',
    'LBL_CONNECT_TEST_FAIL' => 'Fout: de instellingen van de connector zijn mogelijk onjuist. Neem contact op met uw administrator.',
    'LBL_CONFIGURE_TWITTER' => 'Neem contact op met uw administrator om Twitter correct in te stellen',
    'LBL_MERGE_CONNECTORS' => 'Haal data',
    'LBL_NO_DATA_AVAILABLE' => 'Geen gegevens beschikbaar.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'Weet u zeker dat u de connector integratie voor deze module wilt uitschakelen?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Verbinding met elastic server kon niet tot stand gebracht worden',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'Sorry, u kunt het &#39;Global team&#39; niet verwijderen.',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'Dit privé-team [{0}] kan niet worden verwijderd, totdat de gebruiker [{1}] is verwijderd.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'Waarschijnlijk is uw Flash Player uitgeschakeld of heeft u een oude versie van Adobe&#39;s Flash Player. Schakel de Flash Player in of <a href="http://www.adobe.com/go/getflashplayer/">download de nieuwste Flash Player hier</a>.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'Naam',
    'LBL_COLLECTION_PRIMARY' => 'Primair',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'Leeg vereist veld',
    'LBL_COLLECTION_EXACT' => 'Collectie',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'Voor een optimale ervaring met IIS/FastCGI sapi, zet fastcgui.logging op 0 in uw php.ini file.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'Toegewezen aan',
    'LBL_DESCRIPTION' => 'Beschrijving',
    'LBL_PRIMARY_CONTACT_NAME' => 'Primaire contactpersoon',
    'LBL_PRIMARY_CONTACT_ID' => 'ID primaire contactpersoon',

    'LBL_NONE' => '--Geen--',
    'LBL_YESTERDAY' => 'gisteren',
    'LBL_TODAY' => 'vandaag',
    'LBL_TOMORROW' => 'morgen',
    'LBL_NEXT_WEEK' => 'volgende week',
    'LBL_NEXT_MONDAY' => 'volgende week maandag',
    'LBL_NEXT_FRIDAY' => 'volgende week vrijdag',
    'LBL_TWO_WEEKS' => 'twee weken',
    'LBL_NEXT_MONTH' => 'volgende maand',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'de eerste dag van de volgende maand',
    'LBL_THREE_MONTHS' => 'drie maanden',
    'LBL_SIXMONTHS' => 'zes maanden',
    'LBL_NEXT_YEAR' => 'Volgend jaar',
    'LBL_FILTERED' => 'Gefilterd',

    //Datetimecombo fields
    'LBL_HOURS' => 'Uren',
    'LBL_MINUTES' => 'Minuten',
    'LBL_MERIDIEM' => 'Meridiem',
    'LBL_DATE' => 'Datum',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Automatisch vernieuwen',

    'LBL_DURATION_DAY' => 'dag',
    'LBL_DURATION_HOUR' => 'uur',
    'LBL_DURATION_MINUTE' => 'minuut',
    'LBL_DURATION_DAYS' => 'dagen',
    'LBL_DURATION_HOURS' => 'uren',
    'LBL_DURATION_MINUTES' => 'minuten',
    'LBL_DURATION_SECONDS' => 'seconden',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'Kies maand',
    'LBL_ENTER_YEAR' => 'Geef jaar op',
    'LBL_ENTER_VALID_YEAR' => 'Geef een geldig jaartal op',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'Voer een numerieke U.S. telefoonnummer in, inclusief netnummer.',
    'LBL_CCP_NOT_INITIATED' => 'Probeert in te bellen met CCP terwijl agent niet is aangemeld.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'Kan oproep niet starten via CCP.',
    'LBL_CCP_DIALING_ERROR' => 'Deze oproep kan niet worden voltooid als uitgevoerd.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'Sluit eventuele chatsessies in SugarLive voordat u een uitgaande oproep doet.',

    //File write error label
    'ERR_FILE_WRITE' => 'Fout: Kon bestand {0} niet schrijven. Controleer systeem en webserver permissies.',
    'ERR_FILE_NOT_FOUND' => 'Fout: Kan bestand {0} niet laden. Controleer systeem en webserver permissies.',

    'LBL_AND' => 'En',
    'LBL_BEFORE' => 'Voor',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'Upload van uw computer',
    'LBL_SEARCH_EXTERNAL_API' => 'Bestand op een externe bron',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'Uploaden naar externe bron',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'Koppelen van externe bron',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'Beveiliging',
    'LBL_SHARE_PRIVATE' => 'Privé',
    'LBL_SHARE_COMPANY' => 'Bedrijf',
    'LBL_SHARE_LINKABLE' => 'Te linken',
    'LBL_SHARE_PUBLIC' => 'Publiek',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS Feed',
    'LBL_RSS_RECORDS_FOUND' => 'record(s) gevonden',
    'ERR_RSS_INVALID_INPUT' => 'RSS is geen geldig input_type',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS is geen geldig response_type voor deze methode',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs biedt geen ondersteuning voor het bestandsformaat dat u heeft opgegeven',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'Leeg',
    'LBL_IS_EMPTY' => 'Is leeg',
    'LBL_IS_NOT_EMPTY' => 'Is niet leeg',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '"Dit is een voorbeeld importbestand met voorbeeld inhoud van een bestand gereed voor import."<br />"Het bestand is met komma&#39;s gescheiden .csv, met als tekstscheidingsteken dubbele aanhalingstekens". "De koprij is de bovenste rij in het bestand en bevat de veldnamen zoals u ze aantreft in de applicatie." "Deze veldnamen worden gebruikt om gegevens te mappen in het bestand met de velden in de applicatie." "Let op: ook de databasenamen kunnen worden gebruikt als rijkop. Dit is zinvol als u phpMyAdmin of een andere databasetool gebruikt om een exportbestand te maken voor import." "De kolomvolgorde is niet belangrijk omdat tijdens het importproces de gegevens worden gematcht met het overeenkomstige veld gebaseerd op de koprij." "Om dit bestand als een sjabloon te gebruiken volgt u de volgende stappen:"<br />"1. Verwijder de rijen met voorbeeldgegevens"<br />"2. Verwijder de helptekst die u nu leest"<br />"3. Voer uw gegevens in de betreffende rijen en kolommen"<br />"4. Bewaar het bestand op een bekende locatie op uw systeem"<br />"5. Klik op de Import optie via het Actiemenu in de applicatie en selecteer het bestand om te uploaden"',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'Toegewezen aan ID',
    'LBL_EXPORT_CREATED_BY' => 'Aangemaakt door ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'Gewijzigd door ID',
    'LBL_EXPORT_REPORTS_TO_ID' => 'Rapporteert aan ID',
    'LBL_EXPORT_TEAM_ID' => 'Team-ID',
    'LBL_EXPORT_TEAM_SET_ID' => 'Team Set ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Toegewezen aan',
    'LBL_EXPORT_FULL_NAME' => 'Volledige naam:',
    'LBL_EXPORT_TEAM_NAME' => 'Teams',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navigeren...',

    'LBL_PENDING_NOTIFICATIONS' => 'Notificaties',
    'LBL_ALT_ADD_TEAM_ROW' => 'Teamrij toevoegen',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'Team verwijderen',
    'LBL_ALT_SPOT_SEARCH' => 'Spot Zoekopdracht',
    'LBL_ALT_NOT_SORTED' => 'Niet gesorteerd',
    'LBL_ALT_SORT_DESC' => 'Aflopend sorteren',
    'LBL_ALT_SORT_ASC' => 'Oplopend sorteren',
    'LBL_ALT_SORTABLE' => 'Sorteerbaar',
    'LBL_ALT_NOT_SORTABLE' => 'Niet sorteerbaar',
    'LBL_ALT_SORT' => 'Sorteren',
    'LBL_ALT_SHOW_OPTIONS' => 'Toon opties',
    'LBL_ALT_HIDE_OPTIONS' => 'Verberg opties',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'Verplaats de selectie naar de linker lijst',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Verplaats de selectie naar de rechter lijst',
    'LBL_ALT_MOVE_COLUMN_UP' => 'Verplaats de selectie naar boven in de getoonde lijstvolgorde',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'Verplaats de selectie naar beneden in de getoonde lijstvolgorde',
    'LBL_ALT_INFO' => 'Informatie',
    'MSG_DUPLICATE' => 'Het {0} record dat u gaat aanmaken zou een duplicaat kunnen zijn van een bestaand {0} record. {1} records met vergelijkbare namen worden hieronder weergegeven. Klik op <br>Nieuw<br> {1} om verder te gaan deze nieuwe {0} te maken of selecteer hieronder een bestaand record {0}.',
    'MSG_SHOW_DUPLICATES' => 'Het {0} record dat u gaat aanmaken zou een duplicaat kunnen zijn van een bestaand {0} record. {1} records met vergelijkbare namen worden hieronder weergegeven.  Klik op <br>Opslaan {1} om verder te gaan deze nieuwe {0} te maken of klik op <br>Annuleren<br> om terug te gaan naar de module zonder de {0} aan te maken.',
    'LBL_EMAIL_TITLE' => 'e-mailadres',
    'LBL_EMAIL_OPT_TITLE' => 'afgemeld e-mailadres',
    'LBL_EMAIL_INV_TITLE' => 'ongeldig e-mailadres',
    'LBL_EMAIL_PRIM_TITLE' => 'primair e-mailadres',
    'LBL_SELECT_ALL_TITLE' => 'Selecteer alles',
    'LBL_SELECT_THIS_ROW_TITLE' => 'Selecteer deze rij',
    'LBL_TEAM_SELECTED_TITLE' => 'Geselecteerd team',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Selecteer om dit team primair te maken',
    'LBL_TEAM_TBSELECTED_TITLE' => 'Team gemarkeerd als geselecteerd op teambasis',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'Dit team markeren als geselecteerd op teambasis',
    'LBL_SEARCH_AND_SELECT' => 'Zoek en selecteer {{module}}',
    'TPL_SEARCH_AND_ADD' => 'Zoeken en toevoegen {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'FOUT: Fout tijdens uploaden. Foutcode: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'FOUT: Fout tijdens uploaden. Foutcode: {0} - {1}. De upload_maxsize is {2}',
    'UPLOAD_ERROR_HOME_TEXT' => 'Fout tijdens uploaden, neem a.u.b. contact op met uw administrator.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'Uploadgrootte ({0} bytes) groter dan toegestane maximum: {1} bytes',
    'UPLOAD_REQUEST_ERROR' => 'Een fout is opgetreden. Ververs uw pagina en probeer opnieuw.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'E',
    'LBL_EDIT_BUTTON_LABEL' => 'Wijzigen',
    'LBL_ADD_BUTTON_LABEL' => 'Toevoegen',
    'LBL_EDIT_BUTTON_TITLE' => 'Wijzigen',
    'LBL_REFRESH_BUTTON_LABEL' => 'Vernieuwen',
    'LBL_REFRESH_BUTTON_TITLE' => 'Vernieuwen',
    'LBL_DUPLICATE_BUTTON_KEY' => 'U',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Kopiëren',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Kopiëren',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'Schema&#39;s rapporteren',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'Schema&#39;s rapporteren',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'Rapport details',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'Rapport details',
    'LBL_DELETE_BUTTON_KEY' => 'D',
    'LBL_DELETE_BUTTON_LABEL' => 'Verwijderen',
    'LBL_DELETE_BUTTON_TITLE' => 'Verwijderen',
    'LBL_SAVE_BUTTON_KEY' => 'S',
    'LBL_SAVE_BUTTON_LABEL' => 'Opslaan',
    'LBL_SAVE_BUTTON_TITLE' => 'Opslaan',
    'LBL_CANCEL_BUTTON_KEY' => 'X',
    'LBL_CANCEL_BUTTON_LABEL' => 'Annuleren',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'om te stoppen.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'om op de pagina te blijven.',
    'LBL_CANCEL_BUTTON_TITLE' => 'Annuleren',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'Delen',
    'LBL_SHARE_BUTTON_TITLE' => 'Delen',
    'LBL_START_BUTTON_LABEL' => 'Start',
    'LBL_START_BUTTON_TITLE' => 'Start',
    'LBL_FINISH_BUTTON_LABEL' => 'Gereed',
    'LBL_FINISH_BUTTON_TITLE' => 'Gereed',
    'LBL_CONFIRM_BUTTON_LABEL' => 'Akkoord',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'om door te gaan.',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'om de pagina te verlaten en wijzigingen te negeren.',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Sneltoetsen',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Form Functionality - Alt+</strong><br/> I = aanpass<b>I</b>ng (detailview)<br/> U = d<b>U</b>plicaat (detailview)<br/> D = verwij<b>D</b>er (detailview)<br/> R = Sha<b>R</b>e (detailview)<br/> A = opsl<b>A</b>an (editview)<br/> L = annu<b>L</b>eer (editview) <br/><br/></p><p><strong>Zoeken en navigeren  - Alt+</strong><br/> 7 = eerste veld op editscherm<br/> 8 = Geavanceerd zoeken<br/> 9 = eerste veld op zoekscherm<br/> 0 = globaal zoeken<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'Escaleren',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'Delen',
    'TPL_RECORD_SHARE_SUBJECT' => 'Gedeeld {{module}} {{name}} vanuit {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'Please checkout {{module}} {{name}} from {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'connectormatrix in {0} werd incorrect gedefinieerd of is leeg en kon niet worden gebruikt.',
    'LBL_PDF_VIEW' => 'PDF downloaden',
    'LBL_PDF_EMAIL' => 'E-mail PDF',

    'ERR_SUHOSIN' => 'Upload stream wordt geblokkeerd door Suhosin, voeg &quot;upload&quot; aan suhosin.executor.include.whitelist toe (Zie sugarcrm.log voor meer informatie)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'Nu',
    'LBL_TIME_AGO_SECONDS' => 'Minder dan een minuut geleden',
    'LBL_TIME_AGO_MINUTE' => 'Ongeveer een minuut geleden',
    'LBL_TIME_AGO_MINUTES' => '{{this}} minuten geleden',
    'LBL_TIME_AGO_HOUR' => 'ongeveer een uur geleden',
    'LBL_TIME_AGO_HOURS' => '{{this}} uur geleden',
    'LBL_TIME_AGO_DAY' => 'gisteren',
    'LBL_TIME_AGO_DAYS' => '{{this}} dagen geleden',
    'LBL_TIME_AGO_YEAR' => 'meer dan een jaar geleden',
    'LBL_TIME_UNTIL_SECONDS' => 'binnen een minuut',
    'LBL_TIME_UNTIL_MINUTE' => 'over ongeveer 1 minuut',
    'LBL_TIME_UNTIL_MINUTES' => 'over {{this}} minuten',
    'LBL_TIME_UNTIL_HOUR' => 'over ongeveer een uur',
    'LBL_TIME_UNTIL_HOURS' => 'over {{this}} uren',
    'LBL_TIME_UNTIL_DAY' => 'morgen',
    'LBL_TIME_UNTIL_DAYS' => 'over {{this}} dagen',
    'LBL_TIME_UNTIL_YEAR' => 'meer dan een jaar',
    'LBL_TIME_RELATIVE' => 'Geplaatst {{relativetime}} op {{date}} om {{time}}',
    'LBL_LAST_TOUCHED' => 'Laats aangeraakt {{relativetime}} op {{date}} om {{time}}',
    'LBL_LAST_COMMIT' => 'Laatste commitment: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'Geen geldige waarden gevonden',
    'LBL_DETAILVIEW_NO_RECORDS' => 'Dit &#39;record&#39; kon nu niet aangemaakt worden.',
    'LBL_REFINE_LIST' => 'Verfijn lijst',
    'LBL_SEARCH_BY' => 'Zoek op',
    'LBL_PREVIEW' => 'Voorvertoning',
    'LBL_COLUMNS' => 'Kolommen',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'Voorvertoning uitgeschakeld: Geen gegevens beschikbaar',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'Voorvertoning uitgeschakeld: Geen toegang tot record',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'Voorvertoning uitgeschakeld: Geen gegevens beschikbaar',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'Voorvertoning uitgeschakeld: Record wordt reeds weergegeven',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'Voorvertoning uitgeschakeld: record verwijderd of geen toegang tot record',
    'LBL_PREVIEW_PREVIOUS' => 'Voorbeeld vorige',
    'LBL_PREVIEW_NEXT' => 'Voorbeeld volgende',
    'LBL_PREVIEW_CLOSE' => 'Voorbeeld sluiten',
    'LBL_STREAM_NO_RECORDS' => 'Dit &#39;record&#39; heeft geen bijbehorende notities. Voeg een notitie toe door op de &#39;voeg notitie toe&#39; knop te klikken.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} duplicaten gevonden.',
    'LBL_NO_DUPLICATES_FOUND' => 'Geen duplicaten gevonden.',
    'LBL_RESET_DEFAULT_VIEW' => 'Standaardweergave herstellen',
    'LBL_RESET_DEFAULT_WIDTHS' => 'Standaardbreedte herstellen',
    'LBL_TIMEZONE_UPDATED' => 'Sugar heeft de tijdzone van uw gebruikersprofiel geüpdatet zodat deze overeenkomt met de tijdzone van uw browser',
    'LBL_SUCCESS' => 'Geslaagd!',
    'LBL_ERROR' => 'Error',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'Duplicaten samenvoegen',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'Wilt u doorgaan? Annuleer om af te breken. Bevestig om records te verwijderen.',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'De volgende records zullen verwijderd worden:',
    'LBL_MERGE' => 'Samenvoegen',
    'TPL_MERGING_RECORDS' => '{{mergeCount}} records worden samengevoegd',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'Ongeldig aantal records gekozen. Het toegestane aantal is  {{minRecords}} tot maximaal {{maxRecords}} records.',
    'LBL_MERGE_NO_ACCESS' =>
        'U heeft geen rechten om deze actie uit te voeren. Er moet minimaal 1 record aanpasbaar zijn.',
    'LBL_MERGE_LOCKED' => 'Sommige geselecteerde records voor samenvoegen bevatten velden die zijn vergrendeld voor bewerking door een proces en kunnen momenteel niet worden samengevoegd.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'U staat op het punt om te wisselen van record zonder de wijzigingen op te slaan die u heeft gemaakt. Alle wijzigingen zullen verloren gaan.. Weet u zeker dat u door wilt gaan?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'Voeg gerelateerde records samen',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'Samengevoegd: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'Samenvoegen gerelateerd {{objectName}} mislukt. Nieuwe poging wordt gestart ({{num}} van {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'Samenvoegen gerelateerd {{objectName}} mislukt.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'Samenvoegen gerelateerde records onvolledig. Enkele records blijven bestaan.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'Samenvoegen gerelateerde records onvolledig. Annuleer om af te breken. Bevestig om door te gaan.',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'Alle gekoppelde records zullen verplaatst worden naar het primaire record.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'Weet u zeker dat u dit record niet mee wil nemen om het samen te voegen.',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'Verwijder records van samenvoegen',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'Ongeldig aantal records geslaagd. Het geldig bereik is van 1 tot {{maxRecords}} records.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'De combinatie van gebruikersnaam/wachtwoord is ongeldig, probeer nogmaals.',
    'LBL_INVALID_CREDS_TITLE' => 'Ongeldige inloggegevens',
    'LBL_INVALID_GRANT' => 'Uw &#39;token&#39; is ongeldig. Log opnieuw in.',
    'LBL_INVALID_GRANT_TITLE' => '&#39;Token&#39; verlopen',
    'LBL_AUTH_FAILED' => 'Client-verificatie mislukt.',
    'LBL_AUTH_FAILED_TITLE' => 'Ongeldige Client',
    'LBL_INVALID_REQUEST' => 'The request made is invalid or malformed. Neem contact op met technische ondersteuning.',
    'LBL_INVALID_REQUEST_TITLE' => 'Ongeldig verzoek',
    'LBL_REQUEST_TIMEOUT' => 'Er kan niet worden verbonden met de server. Controleer uw internetverbinding.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'Aanvraag onderbroken:',
    'LBL_UNAUTHORIZED' => 'Het spijt ons, maar het lijkt erop dat u geen toegang heeft tot deze bron.',
    'LBL_UNAUTHORIZED_TITLE' => 'Niet geautoriseerd',
    'LBL_RESOURCE_UNAVAILABLE' => 'Bron niet beschikbaar.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'Verboden',
    'LBL_METHOD_NOT_ALLOWED' => 'HTTP method not allowed for this resource. Neem contact op met technische ondersteuning.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'Method Not Allowed',
    'LBL_PRECONDITION_MISSING' => 'Request failure, or, missing/invalid parameter. Neem contact op met technische ondersteuning.',
    'LBL_PRECONDITION_MISSING_TITLE' => 'Fout:',
    'LBL_INVALID_412_RESPONSE' => 'A request is failing that makes the application unusable. Please contact technical support.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'Het is niet toegestaan om het veld {0} te wijzigen in module: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'Het is niet toegestaan om de actie: "{0}" op dit record uit te voeren.',
    'LBL_LOGIN_BUTTON_LABEL' => 'Inloggen',
    'LBL_ACTIVITY_VIEW_TOUR' => 'Activity View Tour',
    'LNK_TOUR' => 'Tour',
    'LNK_MOBILE' => 'Mobiel',
    'LBL_FEEDBACK' => 'Feedback',
    'LBL_SUPPORT' => 'Ondersteuning',
    'LBL_LANGUAGE' => 'Taal',
    'LBL_LOADING_LANGUAGE' => 'Taalpakket aan het laden',
    'LBL_UPLOADING' => 'Uploading',
    'LBL_UPLOADING_DOTS' => 'Uploading...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'Weet u zeker dat u deze afbeelding wilt verwijderen?',
    'LBL_FILE_DELETE_CONFIRM' => 'Weet u zeker dat u dit bestand wilt verwijderen? Deze handeling kan niet ongedaan gemaakt worden.',
    'LBL_FILE_DELETED' => 'Bestand is met succes verwijderd',

    //theme roller
    'LBL_PORTAL_THEME' => 'Thema van de portal',
    'LBL_THEME_PREVIEW' => 'Voorvertoning thema portaal',
    'LBL_LOADING_PREVIEW' => 'Voorvertoning laden',
    'LBL_RESET' => 'Resetten',
    'LBL_COLORS' => 'Kleuren',
    'BorderColor' => 'Randkleur',
    'NavigationBar' => 'Navigatiebalk',
    'PrimaryButton' => 'Primaire knop',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'Opslaan & Inzetten',
    'LBL_RESET_THEME_LNK' => 'Herstel standaard thema',
    'LBL_RESET_THEME_MODAL_INFO' => 'U staat op het punt om uw aangepaste thema te overschrijven met het standaard thema. Doorgaan?',
    'LBL_RESET_THEME_PROCESS' => 'Herstellen van standaard thema...',
    'LBL_SAVE_THEME_PROCESS' => 'Opslaan van thema...',

    // image loader
    'LBL_SELECT_PHOTO' => 'Selecteer een foto',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Verbeterde forecast functionaliteit in SugarCRM',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Stel je forecasting parameters in</li><li class="icon-ok">Volg eenvoudig je pijplijn</li><li class="icon-ok"> Forecast gebaseerd op verwachte verkoop van het sales team</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'Stel je forecasting parameters in',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Kies de startdatum van het fiscale jaar</li><li class="icon-ok">Stel de periodes in: jaarlijks of kwartaallijks</li><li class="icon-ok">Kies hoeveel historische en toekomstige periodes zichtbaar moeten zijn</li><li class="icon-ok">Kies het bereik van de forecast</li><li class="icon-ok">Kies forecast scenarios om meest waarschijnlijke, meest gunstig of minst gunstige forecast te tonen</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'Beheer de geprojecteerde verkoop van uw Sales Team',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Kies de periode om de forecast te herzien</li><li class="icon-ok">Bekijk de werkbladen van uw Sales Team medewerkers en geef een voorstel voor een herziene forecasts</li><li class="icon-ok">Krijg een melding als een Sales Team medewerker een nieuwe forecast commit</li><li class="icon-ok">Sla het forecastwerkblad tijdelijk op of commit de forecast naar je manager</li><li class="icon-ok">Bekijk de historie van eerder ingediende forecasts</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'Beheer de geprojecteerde verkoop van uw Sales Team',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Bekijk de Pareto diagram voor pijplijn analyse over de forecasts van al uw sales team leden</li><li class="icon-ok">Kies om de geprojecteerde verkoop te tonen volgens meest waarschijnlijke, meest gunstige en slechtste scenario</li><li class="icon-ok">Bekijk uw geprojecteerde verkoop en hoe dicht u bent bij het bereiken van het doel</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'Beheer je eigen geprojecteerde verkoop',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Kies de periode voor uw forecasts</li><li class="icon-ok">Pas waardes aan, voor een snelle scenario-analyse (what-if analyse)</li><li class="icon-ok">Sla forecastwerkbladen tijdelijk op of stuur deze door naar uw manager</li><li class="icon-ok">Bekijk eerder ingediende forecasts</li><li class="icon-ok">Dien uw forecast in bij uw manager en bekijk eerder ingediende forecasts</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'Beheer je eigen geprojecteerde verkoop',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Bekijk de Pareto diagram voor een pijplijn analyse over uw Opportunities</li><li class="icon-ok">Geef uw pijplijn verdeling grafisch weer op basis van Verkoopstadium of Waarschijnlijkheid</li><li class="icon-ok">Bekijk verwachte verkoop en hoe dicht u bent bij het behalen van uw doel</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Wat is er <b>nieuw</b> in Sugar',
    'LBL_TOUR_WATCH' => 'Kijk wat er nieuw is in Sugar',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="icon-ok">Verbeterde look en feel – Nu met een nieuw modern thema.</li><li class="icon-ok">Verbeterde Forecasts module – nu met intuïtieve gebruikersweergave en nieuwe data visualisatie</li></ul>',
    'LBL_TOUR_VISIT' => 'Bezoek onze applicatie voor meer informatie',
    'LBL_TOUR_DONE' => 'U bent klaar!',
    'LBL_TOUR_REFERENCE_1' => 'U kunt altijd refereren naar onze',
    'LBL_TOUR_REFERENCE_2' => 'door de "Support" link onder het profielmenu te selecteren',
    'LNK_TOUR_DOCUMENTATION' => 'documentatie',
    'LBL_TOUR_CALENDAR_URL_1' => 'Deelt u uw SugarCRM agenda met applicaties van derden, zoals Microsoft Outlook of Exchange? Zo ja, dan heeft u een nieuwe URL. Deze veiligere URL bevat een persoonlijke toegangssleutel, welke onbevoegde publicatie van uw agenda voorkomt.',
    'LBL_TOUR_CALENDAR_URL_2' => 'Haal hier uw nieuwe gedeelde agenda URL op.',
    'LBL_TOUR_CUBE' => 'Toegang dashboards en Activity Stream',
    'LBL_TOUR_NAV_BAR' => 'Toegang tot alle modules via het navigatiemenu en voer acties uit',
    'LBL_TOUR_NOTIFICATIONS' => 'Klik om notificaties te bekijken',
    'LBL_TOUR_SEARCH' => 'Selecteer één of meer modules en zoek',
    'LBL_TOUR_AVATAR' => 'Bekijk meer details over de appplicatie of meld u af',
    'LBL_TOUR_ADD' => 'Maak vanaf hier een nieuw record aan',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'Klik om het intelligende pane te openen of te sluiten',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'Kies om activiteiten of de lijst met records te zien',
    'LBL_TOUR_LIST_FILTER1' => 'De filterbalk maakt zoeken mogelijk voor deze module',
    'LBL_TOUR_LIST_FILTER2' => 'Kies een voorgedefinieerd filter of maak een nieuw filter aan',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'Type hier om te zoeken op naam',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'Kies om de rij weergave of voorvertoning aan te passen',
    'LBL_TOUR_RECORD_ACTIONS' => 'Voer acties uit op het record',
    'LBL_TOUR_RECORD_SUBPANEL' => 'Click on header to expand and collapse subpanel',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'De naam van het record kan direct aangepast worden',
    'LBL_TOUR_RECORD_STATUS' => 'Hier vind u de status van het record',
    'LBL_TOUR_RECORD_SHOWMORE' => 'Klik om meer gegevens van het record te tonen',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'Kies om de activiteiten of gerelateerde records te tonen',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'Klik om elk veld in-line aan te passen',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'Maak een nieuwe groep van dashlets aan',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'Kies een naam voor de groep van dashlets',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'Kies om het dashlet te verwijderen of de instellingen te wijzigen',
    'LBL_TOUR_INTRO' =>'<h4>Welkom bij Sugar</h4> We willen graag enkele functies met u doornemen. Gebruik de < and > pijlen onder aan het scherm voor een rondleiding.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">Wat is er nieuw?</a><p class="details">Kom de belangrijkste wijzigingen tussen releases te weten.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a
href="http://university.sugarcrm.com/" target="_blank">Kom meer te weten over Sugar</a><p class="details">Een uitgebreide bibliotheek van eLearning, live- en virtuele klaslokaaltraining, webinars en video&#39;s.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">Ontvang hulp</a><p class="details">Hulp nodig, een speciale vraag of heeft u suggesties om Sugar te verbeteren?</p></div></li></ul> ',
    'LBL_TOUR_LIST_INTRO' => 'Bekijk een lijst van records en voer acties uit.',
    'LBL_TOUR_RECORD_INTRO' => 'Bekijk de details van dit record en bekijk alle gerelateerde data.',
    'LBL_TOUR_FORECAST_INTRO' => 'Beheer de pijplijn en forecast.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'Kies een periode om de bijbehorende forecast te bekijken',
    'LBL_TOUR_FORECASTS_COMMITS' => 'Klik om de eerdere commits te bekijken',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'Klik om de gegevens in-line aan te passen',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'Bekijk de afstand tot het doel',
    'LBL_TOUR_FORECASTS_CHART' => 'Bekijk de spreiding van de forecast',
    'LBL_TOUR_TOUR' => 'Keer terug naar de tour',
    'LBL_TOUR_TAGS_ADD' => 'Click the tags field to add and remove tags',
    'LBL_TOUR_TAGS_DELETE' => 'To delete a tag, use backspace or click the [X] button on each tag',
    'LBL_TOUR_RECORD_SAVE' => 'Once you are ready, click Save',


    'LBL_FUTURE' => 'Toekomst',
    'LBL_REQUIRED_FIELD' => 'Vereist',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'Geoffreerd regelitem',
    'LBL_DISCOUNT_TOTAL' => 'Korting totaal',
    'LBL_DISCOUNT_PERCENT' => '% Procent',
    'LBL_DISCOUNT_SELECT' => 'Bepaalt of de korting een percentage is of een vast bedrag',
    'LBL_TAX' => 'Btw',
    'LBL_SHIPPING' => 'Verzendkosten',
    'LBL_GRAND_TOTAL' => 'Eindtotaal',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'Factuuradres automatisch invullen vanuit profiel account',
    'LBL_QLI_ADD_GROUP' => 'Een groep toevoegen',
    'LBL_QLI_COMMENT' => 'Opmerking',
    'LBL_SELECT_ACTION' => 'Selecteer actie',
    'LBL_QLI_GROUP_NAME' => 'Groepsnaam',
    'LBL_GROUP_TOTAL' => 'Groepstotaal',
    'LBL_ITEM_NAME' => 'Regelitem',
    'LBL_QLI_DELETE' => 'Weet u zeker dat u dit regelitem wilt verwijderen?',
    'LBL_QLI_COMMENT_DELETE' => 'Weet u zeker dat u deze regelitemopmerking wilt verwijderen?',
    'LBL_QLI_GROUP_DELETE' => 'Weet u zeker dat u groep {0} wilt verwijderen? Alle items moeten naar de standaard groep worden verplaatst.',
    'LBL_QLI_GROUP_EMPTY' => 'Geen geoffreerd regelitem',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'Optioneel',
    'LBL_RELATED_MODULE' => 'Gerelateerd aan {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'Gerelateerd aan {{{this}}}',
    'LBL_CREATE_MODULE' => 'Maak {{{this}}} aan',
    'LBL_EDIT' => 'Wijzig {{{this}}}',
    'LBL_ASSOC' => 'Associeer {{{this}}}',
    'LBL_ASSIGN' => 'Selecteer {{{this}}}',
    'LBL_EDIT_RELATED' => 'Wijzig gerelateerde {{{this}}}',
    'LBL_CREATE_RELATED' => 'Maak gerelateerde {{{this}}} aan',
    'LBL_ASSOC_EXISTING' => 'Koppel bestaand {{{this}}}',
    'LBL_SEARCH_ALL' => 'Doorzoek alle {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'Zoek alle records...',
    'LBL_SEARCH_ALL_MODULES' => 'Zoek alle',
    'LBL_OK' => 'Akkoord',
    'LBL_YES' => 'Ja',
    'LBL_NO' => 'Nee',
    'LBL_SHOW_NUMBERING' => 'Fasenummering weergeven',
    'LBL_HIDE_NUMBERING' => 'Fasenummering verbergen',
    'LBL_CALL_BUTTON' => 'Telefoongesprek',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'E-mail',
    'LBL_HONEYPOT' => 'Als u een echt persoon bent, vul dit dan niet in.',
    'LBL_LINK_BUTTON' => 'Link',
    'LBL_UNLINK_BUTTON' => 'Koppeling verwijderen',
    'LBL_MAP_BUTTON' => 'Map',
    'LBL_FILE_BUTTON' => 'Bestand',
    'LBL_URL_BUTTON' => 'Web',
    'LBL_WARNING' => 'Waarschuwing',
    'LBL_CONFIRM' => 'Bevestig',
    'LBL_CONFIRMATION_POPUP' => 'Bevestigingspop-up',
    'LBL_NO_ACCESS' => '(Geen toegang)',
    'LBL_NO_ACCESS_LOWER' => 'Geen toegang',
    'LBL_NO_FIELD_ACCESS' => 'Geen toegang',
    'LBL_NO_LICENSE_ACCESS' => 'Vergunning verplicht',
    'LBL_VALUE_ERASED' => 'Waarde gewist',
    'LBL_VALUE_ERASED_TOOLTIP' => 'Deze informatie werd gewist via gegevensaanvraag privacy',
    'LBL_CREATE_RELATED_RECORD' => 'Maak gerelateerd record aan',
    'LBL_ASSOC_RELATED_RECORD' => 'Koppel bestaand record',
    'LBL_CHOOSE_LINK' => 'Kies koppel type',
    'LBL_CHOOSE_PARENT_TYPE' => 'Kies Parent Type',
    'LBL_HOME' => 'Start',
    'ERR_NO_DOCS' => 'Geen documenten beschikbaar',
    'ERR_NO_RECORDS_SELECTED' => 'U heeft geen records geselecteerd.',
    'LBL_DELETING' => 'Verwijderen...',
    'LBL_UNLINKING' => 'Ontkoppelen...',
    'LBL_UNLINKED' => 'Ontkoppeld',
    'LBL_LEGAL' => 'Legal',
    'LBL_UPCOMING' => 'Mijn toekomstige activiteiten',
    'LBL_RECENTLY_UPDATED' => 'Recent vernieuwd',
    'LBL_NOTES_SUBPANEL_TITLE' => 'Notities',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'Afspraken',
    'LBL_TASKS_SUBPANEL_TITLE' => 'Taken',
    'LBL_CALLS_SUBPANEL_TITLE' => 'Telefoongesprekken',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'Accounts',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'Contactpersonen',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'E-mails',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'Ploegen',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'Geoffreerde producten',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'Uitzonderingen ploeg',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'Documenten',
    'LBL_ESCALATIONS' => 'Escalaties',
    'LBL_ESCALATED' => 'Geëscaleerd',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'Escalaties',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'Andere gerelateerde escalaties',
    'LBL_ESCALATIONS' => 'Escalaties',
    'LNK_SETTINGS' => 'Instellingen',
    'LBL_MOBILE_SUPPORT' => 'Ondersteuning',
    'LBL_MOBILE_SHOW_MORE' => 'Toon meer...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'Toon meer...',
    'LBL_MOBILE_NO_RECORDS' => 'Geen records gevonden',
    'LBL_MOBILE_SEARCH_TEAMS' => 'Zoek teams...',
    'LBL_MOBILE_SELECT_TEAMS' => 'Selecteer teams',
    'LBL_MOBILE_WAIT' => 'Een moment geduld aub...',
    'LBL_MOBILE_LOGING_OUT' => 'Een moment geduld terwijl u uitgelogd wordt...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'Opnieuw inloggen',
    'LBL_MOBILE_META_SYNC_FAILED' => 'Synchronisatie met de server mislukt.',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'Synchronisatie met de server mislukt. Opnieuw proberen?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'Privacy, Terms, & Conditions',
    'LBL_MOBILE_APP_VERSION' => 'Versie van de app',
    'LBL_MOBILE_SERVER_VERSION' => 'Versie van der server',
    'LBL_MOBILE_SERVER_URL' => 'Server URL:',
    'LBL_MOBILE_PTR_PULL' => 'Pull-down om te verversen...',
    'LBL_MOBILE_PTR_RELEASE' => 'Loslaten om te verversen...',
    'LBL_MOBILE_EDIT_REL' => 'Relatie bewerken',
    'LBL_MOBILE_DESKTOP' => 'Desktopversie',
    'LBL_MOBILE_DELETE_CONFIRM' => 'Weet u zeker dat u dit record wilt verwijderen?',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'Weet u zeker dat u deze koppeling ongedaan wilt maken?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'Wilt u uw laatste telefoongesprek opslaan?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'Kies ontvanger',
    'LBL_MOBILE_CHOOSE_PHONE' => 'Kies mobiel nummer',
    'LBL_MOBILE_CHOOSE_URL' => 'Kies URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'Kies document',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'Kies locatie',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'Geen acties beschikbaar',
    'LBL_MOBILE_FEEDBACK' => 'Feedback',
    'LBL_MOBILE_DOC' => 'Document',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'Download gestart: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'Download voltooid: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'Uploaden van bestand...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'Bestand met succes upgeload',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'Voorbereiden van afbeelding...',
    'LBL_CLOSE_SAVE_BUTTON' => 'Taak sluiten en opslaan',
    'LBL_LATER' => 'Later',
    'LBL_USE_HTTPS' => 'Maak gebruik van beveiligde verbinding',
    'LBL_LOADING_FILES' => 'Bezig met laden van lijst. Probeer later opnieuw.',
    'LBL_NEW_WEB_VERSION' => 'Er is een nieuwe versie van SugarCRM Mobile beschikbaar. Wilt u de update uitvoeren?',
    'LBL_SET_FONTSIZE' => 'Tekstgrootte',
    'LBL_FONTSIZE_TINY' => 'Erg klein',
    'LBL_FONTSIZE_SMALL' => 'Klein',
    'LBL_FONTSIZE_NORMAL' => 'Normaal (standaard)',
    'LBL_FONTSIZE_LARGE' => 'Groot',
    'LBL_FONTSIZE_LARGER' => 'Groter',
    'LBL_FONTSIZE_HUGE' => 'Extra groot',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'Enorm',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "Download mislukt\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'Meer...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...minder',
    'LBL_OFFLINE_MODE' => 'Offline modus',
    'LBL_OFFLINE_DELETED' => 'Gegevens niet gevonden...',
    'LBL_OFFLINE_DELETED_RELATED' => 'Gekoppeld record niet gevonden. Waarschijnlijk verwijderd of niet langer gekoppeld.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'Het downloaden van gegevens (toegewezen aan, favoriet en gevolgd) voor offline toegang kan enige tijd is beslag nemen. Een snelle verbinding wordt aanbevolen. Wilt u nu doorgaan?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'Wenst u de gegevens die aan u zijn toegewezen, gemarkeerd zijn als  favoriet of gevolgd downloaden voor offline toegang? Een snelle verbinding wordt aanbevolen, omdat deze actie enige tijd in beslag kan nemen. U kunt dit later downloaden vanuit het hoofdmenu > offline.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'Gegevens zijn succesvol gedownload',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'Download uw gegevens...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'Fout tijdens downloaden van gegevens',
    'LBL_OFFLINE_PREFETCHING' => 'Laden van gegevens....',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'Laden {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'Resterende tijd ± {{estimatedTime}}s...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => '{{module}} laden voltooid',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'Opschonen opslag...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'Opschonen voltooid',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'Wilt u deze wijziging ongedaan maken?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'Ongedaan maken voltooid',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'Ongedaan maken mislukt',
    'LBL_OFFLINE_CLEAR_DB' => 'Opslag opschonen...',
    'LBL_OFFLINE_COMPACT_DB' => 'Comprimeer opslag...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'Deze actie zal records verwijderen die u al enige tijd niet heeft opgevraagd. Doorgaan?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'Wilt u alle records in uw locale opslag verwijderen?',
    'LNK_OFFLINE_SETTINGS' => 'Offline',
    'LBL_OFFLINE_SETTINGS' => 'Debug settings',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'Geen wijzigingen in afwachting van synchronisatie.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'Wijzigingen in afwachting van synchronisatie.',
    'LBL_OFFLINE_STATUS_ONLINE' => 'Apparaat is online.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'Apparaat is offline.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'Server kan niet worden bereikt.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'Laatste synchronisatie mislukt. Bekijk transactie log.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'Bezig met synchronisatie...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'Gesynchoniseerd.',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'Weet u zeker dat u offline ondersteuning wilt inschakelen?',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'Wilt u offline ondersteuning uitschakelen? Niet gesynchroniseerde wijzigingen vervallen.',
    'LBL_OFFLINE_ENABLED' => 'Offline ondersteuning ingeschakeld.',
    'LBL_OFFLINE_DISABLED' => 'Offline ondersteuning uitgeschakeld.',
    'LBL_OFFLINE_STATS' => 'Opslag statistieken',
    'LBL_OFFLINE_SERVER_FETCH' => 'Ophalen van server...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'Iemand heeft hetzelfde record aangepast op de server. Bevestig om automatisch samen te voegen of annuleer uw wijzingen.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'Laatste synchronisatie poging: {{ts}}',
    'LBL_ACTION_UPDATE' => 'BIJWERKEN',
    'LBL_ACTION_CREATE' => 'AANMAKEN',
    'LBL_ACTION_DELETE' => 'VERWIJDER',
    'LBL_ACTION_LINK' => 'KOPPEL',
    'LBL_ACTION_UNLINK' => 'ONTKOPPEL',
    'LBL_ACTION_FAVORITE' => 'FAVORIET',
    'LBL_ACTION_FOLLOW' => 'VOLGEN',
    'LBL_ACTION_CREATE_EXPLANATION' => '{{module}} "{{name}}" aangemaakt',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'Bijgewerkt: {{module}} "{{name}}"',
    'LBL_ACTION_DELETE_EXPLANATION' => 'Verwijderd: {{module}} "{{name}}"',
    'LBL_ACTION_LINK_EXPLANATION' => 'Relatie gelegd tussen {{module}} "{{name}}" en {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'Relatie verbroken tussen {{module}} "{{name}}" en {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'Volgen {{module}} "{{name}}"',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'Ontvolgen {{module}} "{{name}}"',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'Favoriet {{module}} "{{name}}"',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'Niet langer favoriet {{module}} "{{name}}"',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => '{{module}} "{{name}}" aangemaakt gerelateerd met {{relatedModule}} "{{relatedName}}"',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'Primair',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'Afmelden',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'Opt-in',
    'LBL_EMAIL_ACTION_SET_VALID' => 'Geldig',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'Ongeldig',
    'LBL_ROLLBACK_BUTTON' => 'Ongedaan maken',
    'LBL_TX_LOG' => 'Transactielogboek',
    'LBL_TX_LOG_DETAIL' => 'Transactiegegevens',
    'LBL_RECORD_DELETED' => '(Record verwijderd)',
    'LBL_NOT_AVAILABLE' => 'niet beschikbaar',
    'LBL_FILE_SIZE' => 'Bestandsgrootte',
    'LBL_FILE_SIZE_UNITS_B' => 'Bytes',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'Kies items',
    'LBL_OFFLINE_DB_SIZE' => 'Database grootte',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'Records per module',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'Totaal aantal records',
    'LBL_RECORD_NOT_FOUND' => 'Record niet gevonden.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'Gerelateerd record niet gevonden.',
    'LBL_NOT_AUTHORIZED' => 'U bent niet bevoegd om dit record te bekijken',
    'LBL_MOBILE_PROCESSING_FILE' => 'Preparing file...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'Software van derden',
    'LNK_TERMS_OF_USE' => 'Terms of Use',
    'LNK_PRIVACY_POLICY' => 'Privacy Policy',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'Single Sign-On',
    'LBL_RECENTS' => 'Recents',
    'LBL_SHOWING_CACHED_DATA' => 'Unable to reach the server. Showing latest available data ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'Close {{moduleSingular}} and save',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'Specific Dashboard',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Specific Module',
    'LBL_MOBILE_DEFAULT_VIEW' => 'Start Screen',
    'LBL_MOBILE_DEFAULT_MODULE' => 'Selected Module',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'Selected Dashboard',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'Selected Dashlet',
    'LBL_ALL_DASHLETS' => 'All Dashlets',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'Algemeen zoeken',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Type @ om een gebruiker te noemen. Type # om te verwijzen naar een record.',
    'LBL_MOBILE_NEW_COMMENT' => 'New comment',
    'LBL_RECENTLY_VIEWED' => 'Laatst bekeken',
    'LBL_FILE_STORED_LOCALLY' => 'Bestand is opgeslagen op lokale opslag en zal worden gesynchroniseerd zodra het apparaat online is.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'Neem contact op met de Beheerder om veranderingen door te geven als u bepaalde velden wilt veranderen die niet bewerkt kunnen worden.',
    'LBL_ACTIVITY_POST' => '{{{value}}} op {{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'Geen opmerking',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'De volgende {{{commentsLeft}}} opmerkingen tonen',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'Inklappen',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'Aanmaken onderwerp bevestigen',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'Opmerkingenlogboek mag niet leeg zijn',
    'LBL_MOBILE_PDF_DOWNLOAD' => '{{{pdfTemplateName}}} PDF downloaden',

    'ERR_SYNC_FAILED' => 'Synchronisatie met de server mislukt.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'Geen toegang.',
    'ERR_MOBILE_INVALID_CREDS' => 'Ongeldige gebruikersnaam of wachtwoord',
    'ERR_MOBILE_SESSION_EXPIRED' => 'Uw sessie is verlopen.',
    'ERR_MOBILE_NOT_FOUND' => 'Bron niet gevonden',
    'ERR_MOBILE_TIMEOUT' => 'Server reageert niet.',
    'ERR_MOBILE_CONNECTION_FAILED' => 'Kan de server niet bereiken',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'Internetverbinding niet beschikbaar',
    'ERR_MOBILE_INTERNAL' => 'Internal error ({{{code}}}). Probeer het later opnieuw.',
    'ERR_MOBILE_VALIDATION' => 'Record is ongeldig',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'Incompatible server flavor: {{{flavor}}}. Supported flavors: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'Incompatible server version: {{{version}}}. Minimum required version: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'Fout! Ongeldig e-mailadres.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'Dit documenttype wordt niet ondersteund.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'Authenticatie mislukt.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'Opgevraagde bron niet gevonden',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'Internal server error.',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'Verboden.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'Dienst onbeschikbaar.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'Een onverwachte fout is opgetreden',
    'ERR_MOBILE_UPLOAD' => 'Fout tijdens uploaden bestand',
    'ERR_MOBILE_FILE_PROCESSING' => 'Fout bij behandelen bestand',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'Opslagmedium is niet beschikbaar',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'Uw app is verouderd en is niet geschikt voor de {{{brandName}}} omgeving waar u verbinding mee probeert te krijgen. Wilt u de nieuwe versie van de App Store downloaden?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'Server configuratie is gewijzigd, herladen noodzakelijk. Uitvoeren?',
    'ERR_MOBILE_CONFLICT' => 'Iemand heeft hetzelfde record aangepast op de server. Bevestig om automatisch samen te voegen of annuleer uw wijzigingen.',
    'ERR_MOBILE_METADATA_CHANGED' => 'Server configratie gewijzigd.',
    'ERR_MOBILE_FILE_READ' => 'Bestand kon niet worden gelezen',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'Bestand niet gevonden',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'Bestand niet leesbaar',
    'ERR_MOBILE_FILE_ABORTED' => 'Leesactie geannuleerd',
    'ERR_MOBILE_FILE_SECURITY' => 'Bestand is niet toegankelijk',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'Mobiele versie ondersteund deze functionaliteit niet. Wilt u de desktop versie openen?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'Bestand is te groot. Maximum toegestane grootte is {{size}}',
    'ERR_OFFLINE' => 'Offline fout',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'Lokale opslag kon niet worden geopend',
    'ERR_OFFLINE_STORAGE_CREATE' => 'Lokale opslag kon niet worden aangemaakt',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'Lokale opslag niet aangemaakt: er is onvoldoende ruimte.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'Er is onvoldoende ruimte op de lokale opslag.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'Opschonen van database mislukt',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'Er is onvoldoende ruimte beschikbaar voor offline opslag. Opschonen gegevens wordt aanbevolen. Dit kan enkele minuten duren.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'Failed to prefetch records from server',
    'ERR_OFFLINE_SYNC_ERROR' => 'Synchronisatiefout',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'Synchronisatieconflict',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'Server time niet beschikbaar',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'Kon offline modus niet activeren. Kan server niet bereiken.',
    'LBL_EXPORT_CSV' => 'Exporteer CSV',
    'LBL_ERR_EXPORTING_CSV' => 'Exporteren mislukt',
    'LBL_ERR_EXPORT_ALL' => 'Gegevens ophalen voor geselecteerde records mislukt, probeer het opnieuw',
    'LBL_LIST_SETTINGS_RESTORE' => 'Standaardinstellingen herstellen',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'Velden terugzetten?',
    'LBL_LIST_SETTINGS_TITLE' => 'Lijstweergavebouwer',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'Beschikbare velden',
    'LBL_LIST_SETTINGS_REMOVE' => 'Verwijderen',
    'LBL_LIST_SETTINGS_TEXT' => 'Sleep velden naar de lijstweergavebouwer en deel ze in om de lijstweergave {{moduleName}} vorm te geven.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'Minimaal één veld moet aan de indeling zijn toegevoegd.',
    'LBL_LIST_SETTINGS_EMPTY' => 'Geen beschikbare velden',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'Geen overeenkomende velden gevonden',
    'LBL_LIST_FILTER' => 'Veld zoeken',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'E-mail client',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'Externe e-mail client',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar e-mail client',
    'LBL_OFFLINE_CAPABILITIES' => 'Offline mogelijkheden inschakelen',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'Transactie verwijderen mislukt.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'Transactie verwijderd.',
    'LBL_SECURE_MODE' => 'Verbeterde beveiligingsmodus',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'Schakel deze instelling in om de inhoud van Sugar Mobile te verbergen als de app op de achtergrond draait en om schermafbeeldingen van de app tegen te gaan.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'Schakel deze instelling in om de inhoud van Sugar Mobile te verbergen als de app op de achtergrond draait.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'Modus Altijd offline',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'U werkt in de modus Altijd offline. Wilt u opnieuw verbinden?',
    'LBL_RECONNECT' => 'Opnieuw verbinden',
    'LBL_STAY_OFFLINE' => 'Offline blijven',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'De module die u probeert te openen is niet beschikbaar in Sugar Mobile.',
    'LBL_MOBILE_RELEASE_NOTE' => 'Releasekennisgevingen Sugar Mobile voor {{platform}}',
    'LBL_MOBILE_USER_GUIDE' => 'Handleiding Sugar Mobile voor {{platform}}',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'deze woorden bevatten',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'deze woorden uitsluiten',
    'LBL_NOTIFICATIONS_CHANNEL' => 'Updates',
    'LBL_APPLY_BUTTON_LABEL' => 'Toepassen',
    'LBL_ACTION_CREATE_FAILURE' => "Record opslaan is mislukt:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "Record updaten is mislukt:\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'Oplossen veldberekeningen op server mislukt.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'De volgende velden zijn ongeldig: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>Gelukt.</b> U hebt met succes de {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}" aangemaakt.</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>Gelukt.</b> U hebt met succes de record bijgewerkt',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'E-mailgegevens ophalen van server mislukt.',
    'LBL_ASSIGN_SUCCESS' => '<b>Gelukt.</b> De record is toegewezen aan {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'Deze e-mail opslaan als concept?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'Opslaan als concept',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'E-mail verwijderen',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'U verliest deze e-mail als u geen concept opslaat.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'Handtekening selecteren',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'E-mailsjabloon selecteren',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'Het sjabloon overschrijft alle inhoud van deze e-mail. Weet u zeker dat u dit sjabloon wilt gebruiken en content wilt overschrijven?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'E-mail opstellen',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'Uw e-mail bevat variabelen die zullen worden vervangen door variabelen uit de record Gerelateerd aan. Controleer of het veld Gerelateerd aan goed is ingesteld voordat u verzendt.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'Geen uitgaand e-mailaccount gevonden. Neem contact op met uw Sugar-beheerder.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' en nog {{{count}}}',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'Voeg een e-mailadres toe',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'Voer de naam of het e-mailadres van een contactpersoon toe',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (Nieuwe e-mail)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'Variabelen',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'E-mailsjablonen',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'Campagnesjablonen',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'Workflowsjablonen',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'Systeemsjablonen',
    'LBL_FILTER_EDIT' => 'Filter bewerken',
    'LBL_FILTER_MY_FILTER' => 'Mijn filter',
    'LBL_FILTER_MY_FILTER_BY' => 'Mijn filter op {{{filters}}}',
    'LBL_FILTER_SAVE' => 'Sla filter op',
    'LBL_SELECT_PARAM' => 'Selecteer',
    'LBL_SELECT_MODULES' => 'Moduleselectie',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'Selecteer aanvullende parameter',
    'LBL_FILTER_TEMPORARY' => 'Tijdelijk filter',
    'LBL_ERROR_FILE_UPLOAD' => 'Uploaden {{{fieldLabel}}} bestand &#39;{{{fileName}}}&#39; mislukt. {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">Mislukte record bekijken</a>',
    'LBL_FILE_UPLOAD_ONE' => 'Bestand opslaan...',
    'LBL_FILE_UPLOAD_MANY' => 'Bestand {{{index}}} van {{{total}}} opslaan...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'Meldingsinstellingen',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'Beheer uw pushmeldingen',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "Geef aan hoe meldingen verschijnen volgens de meldingsinstellingen van uw apparaat.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'Toewijzingen',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'Ontvang meldingen als records aan u zijn toegewezen.',
    'LBL_NOTIFICATION_MENTIONS' => 'Vermeldingen',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'Ontvang meldingen als u wordt vermeldt in de invoer van het opmerkingenlogboek.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'Het veld Opmerkingenlogboek is niet door een beheerder toegevoegd aan deze indeling. Neem contact op met uw Sugar-beheer.',
    'ERR_NO_PERMISSION_TITLE' => 'Geef toegang',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} heeft toegang tot de camera nodig zodat u foto&#39;s kunt bijvoegen. Geef de camera toegang in de systeeminstellingen.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'Instellingen',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'Duur',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'Tijd over',
    'LBL_LIST_SUPPORT_EXPIRES' => 'Vervalt op',
    'LBL_CASCADE_RLI_EDIT' => 'Open omzetregels bijwerken',
    'LBL_MOBILE_CALENDAR' => 'Agenda',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'Instellingen agenda',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'Startdag van de week',
    'LBL_MOBILE_CALENDAR_MODULES' => 'Weer te geven gebeurtenissen',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}h:{{{minutes}}} min',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} Uur',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} Min',
    'LBL_MOBILE_CALENDAR_TODAY' => 'Vandaag',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => '{{{moduleName}}} toevoegen',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'Plan een activiteit',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'Schakel minimaal één type gebeurtenis in.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'Gehele dag',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'Agenda&#39;s laden mislukt.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'Deze actie is niet beschikbaar in Sugar Mobile. Wilt u dan de desktopapplicatie openen?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'Kies sjabloon',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'Samenvoegen',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'Fout: EXIF-gegevens ontbreken in het HEIC-bestand',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'Fout: De afbeeldingsresolutie is te hoog',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'Fout: Kan de afbeelding niet verwerken',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'Fout: Afbeelding renderen naar canvas is mislukt',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'Fout: Bestand als afbeelding laden mislukt',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1 Onderdeel geselecteerd',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} Onderdelen geselecteerd',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'Selecteer alles',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'U hebt {{{count}}} records geselecteerd in deze weergave. Alle records selecteren?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'Selecteer {{{count}}} records',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'Weet u zeker dat u de geselecteerde record(s) wilt verwijderen?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'Verwijderen… {{{count}}} van de {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'Geen geldig e-mailadres gevonden in de geselecteerde records',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'Uiterlijk',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'Systeeminstelling gebruiken',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'Licht',
    'LBL_MOBILE_APP_THEME_DARK' => 'Donker',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'Nieuwe bestandsnaam',
    'LBL_ATTACHMENT_RENAME_MSG' => 'Bestand nieuwe naam geven',
    // Filters related
    'LBL_CREATED_BY_ME' => 'Aangemaakt door mij',
    'LBL_OPERATOR_ONE_OF' => 'is één van',
    'LBL_OPERATOR_NOT_ONE_OF' => 'is geen van de',
    'LBL_OPERATOR_CONTAINS' => 'is een van de',
    'LBL_OPERATOR_CONTAINS_WORD' => 'bevat',
    'LBL_OPERATOR_NOT_CONTAINS' => 'is geen van de',
    'LBL_OPERATOR_EMPTY' => 'is leeg',
    'LBL_OPERATOR_NOT_EMPTY' => 'is niet leeg',
    'LBL_OPERATOR_MATCHES' => 'komt overeen met',
    'LBL_OPERATOR_STARTS_WITH' => 'begint met',
    'LBL_OPERATOR_EQUALS' => 'is gelijk aan',
    'LBL_OPERATOR_NOT_EQUALS' => 'is ongelijk aan',
    'LBL_OPERATOR_GREATER_THAN' => 'is groter dan',
    'LBL_OPERATOR_LESS_THAN' => 'is kleiner dan',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'is groter of gelijk aan',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'is kleiner of gelijk aan',
    'LBL_OPERATOR_BETWEEN' => 'ligt tussen',
    'LBL_OPERATOR_BEFORE' => 'voor',
    'LBL_OPERATOR_AFTER' => 'na',
    'LBL_OPERATOR_YESTERDAY' => 'gisteren',
    'LBL_OPERATOR_TODAY' => 'vandaag',
    'LBL_OPERATOR_TOMORROW' => 'morgen',
    'LBL_OPERATOR_LAST_7_DAYS' => 'afgelopen 7 dagen',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'komende 7 dagen',
    'LBL_OPERATOR_LAST_30_DAYS' => 'afgelopen 30 dagen',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'komende 30 dagen',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'Meer dan __ dagen geleden',
    'LBL_OPERATOR_LAST_X_DAYS' => 'Afgelopen __ dagen',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'Komende __ dagen',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'Meer dan __ dagen in de toekomst',
    'LBL_OPERATOR_LAST_MONTH' => 'afgelopen maand',
    'LBL_OPERATOR_THIS_MONTH' => 'deze maand',
    'LBL_OPERATOR_NEXT_MONTH' => 'volgende maand',
    'LBL_OPERATOR_LAST_YEAR' => 'afgelopen jaar',
    'LBL_OPERATOR_THIS_YEAR' => 'dit jaar',
    'LBL_OPERATOR_NEXT_YEAR' => 'volgend jaar',
    'LBL_OPERATOR_IS' => 'is',
    'LBL_OPERATOR_IS_NOT' => 'is niet',
    'LBL_OPERATOR_AFTER_TODAY' => 'na vandaag',
    'LBL_OPERATOR_BEFORE_TODAY' => 'voor vandaag',
    'LBL_ERROR_FILTER_EMPTY' => 'Voeg filtercriteria toe.',
    'LBL_ADD_FILTER' => 'Criteria toevoegen',
    'LBL_FILTER_NAME' => 'Filternaam',
    'LBL_FILTER_FIELD' => 'Veld',
    'LBL_FILTER_OPERATOR' => 'Aanbieder',
    'LBL_FILTER_VALUE' => 'Waarde',
    'LBL_FILTER_SYNC_TO_SERVER' => 'Opgeslagen in desktopapp',
    'LBL_FILTER_LOCAL' => 'Lokaal filter',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'Welkom bij {{{brandName}}}.<br /><br />Laat ons enkele nieuwe features toelichten...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'Hoofdmenu navigatie',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'Beschikbare acties per weergave',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'Global search voor records',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'Filter de lijst op mijn favoriete records.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'Filter de lijst op de records die aan mij zijn toegewezen.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'Markeer record als favoriet.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'Gebeurtenissen die vandaag beginnen.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'Meest recent aangepaste records.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'Beschikbare handelingen bij een record.',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'Veel plezier met alle nieuwe features!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'Dit het plus menu.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'Sluit het plus menu.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'Selecteer een actie om de uitvoering te zien.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'Dit het hoofdmenu.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'Sluit het hoofdmenu.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'Bekijk een specifieke module.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'Pas de applicatie aan.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'Open Sugar in de (web)browser.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'Bekijk je profiel.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'De is de detailpagina.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'De belangrijkste informatie van een record.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'Bekijk extra informatie or pas een record aan.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'Beschikbare acties bij een record.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'Ga naar de vorige pagina.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'De Tour is op elk moment beschikbaar.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'Ga terug.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'Klik om een gerelateerd record te openen.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'Volg / Ontvolg een record',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'Klik voor meer informatie.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'Hoofd Menu View',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'Het hoofd menu opent zich aan de linkerzijde van je scherm.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'Detailweergave',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'De Detail View opent zich aan de rechterzijde van je scherm.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'Gebruik onderstaande pijlen voor een quick tour met de meest belangrijke componenten van dit menu.',

    'LBL_COMMENT_ADD' => 'Een opmerking toevoegen',
    'LBL_REQUIRED' => 'Verplicht',
    'LBL_MORE_BUTTON' => 'Meer',
    'LBL_NO_OPTIONS' => 'Geen opties beschikbaar',
    'LBL_TRY_AGAIN' => 'Probeer opnieuw',
    'LBL_NEW_RECORDS' => 'Laatst aangemaakt',
    'LBL_ASSIGNED_TO_ME' => 'Mijn {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'Alle {{{module}}}',
    'LBL_UNFAVORITE' => 'Niet langer favoriet',
    'LBL_ACTIVITY_CREATE' => '{{{record}}} {{{module}}} aangemaakt',
    'LBL_ACTIVITY_UPDATE' => '{{{changes}}} bijgewerkt op {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => '{{{relatedRecord}}} gekoppeld aan {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => '{{{relatedRecord}}} niet langer gekoppeld aan {{{record}}} {{{module}}}',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} voor {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'Bijbehorende records downloaden...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'De configuratie van uw dashboard is veranderd. Wilt u deze opnieuw laden?',
    'LBL_RECORDS' => 'Records',
    'LBL_DASHBOARDS' => 'Dashboards',
    'LBL_TEMPLATES' => 'Sjablonen',
    'LBL_NON_TEMPLATES' => 'Geen sjablonen',
    'LBL_IS_TEMPLATE' => 'Is sjabloon',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'Uw selectie bevat dashboardsjablonen die niet massaal kunnen worden bijgewerkt. Maak de selectie van sjablonen ongedaan om door te gaan.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'Uw selectie bevat dashboardsjablonen die niet massaal kunnen worden verwijderd. Maak de selectie van sjablonen ongedaan om door te gaan.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'Zoek {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'Hoofdmenu',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'Snel nieuw record aanmaken',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'Veeg voor meer opties',
    'LBL_DETAILS' => 'Details',
    'LBL_DETAIL_RELATED' => 'Gerelateerd',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'Deze {{module}} vereist een {{relatedModule}}. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>Maak een {{relatedModule}} record</a> aan.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'Wijzig record',
    'LBL_OFFLINE_MENU_SETTINGS' => 'Offline instellingen',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'Debug instellingen',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'Totaal aantal records',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'Laatste download',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'Kan het bestand niet downloaden.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'Kon dashboards niet laden van server',
    'ERR_FILTERS_FETCHING' => 'Kon uw filters niet ophalen',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'Coderen lokale opslag mislukt',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'Offline gegevens coderen. Dit kan enkele minuten in beslag nemen.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'Offline gegevenscodering voltooid.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'U hebt geen toegang tot module {{{module}}}.',
    'LBL_SKIP' => 'Overslaan',
    'LBL_CONTINUE' => 'Doorgaan',
    'LBL_ENABLE' => 'Inschakelen',
    'LBL_MOBILE_TRIAL_UNTIL' => 'Proef tot',
    'LBL_MOBILE_SDK_VERSION' => 'SDK versie',
    'LBL_LOG_LEVEL' => 'Logniveau',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'Aanmeldinstellingen zijn opnieuw geconfigureerd.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'Uw proefperiode is verlopen.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'Server ondersteunt geen beveiligde verbinding. Schakel de beveiligde verbinding uit.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'Server ondersteunt beveiligde verbinding. Schakel de beveiligde verbinding in.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'Uw verbinding is niet veilig. Neem contact op met uw beheerder.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'Aanmeldinstellingen',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'Stel uw exemplaar van {{{brandName}}} in',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'Om de app te doen werken, moet u de URL van dit exemplaar van {{{brandName}}} invoeren. Neem contact op met uw beheerder indien u deze URL niet hebt.',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => 'Touch ID',
    'LBL_ENABLE_TOUCHID' => '{{{biometryType}}} inschakelen',
    'LBL_SETUP_TOUCHID' => '{{{biometryType}}} configureren',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'Aanmelden met uw vingerafdruk',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} is niet ingesteld op uw apparaat. \n\nGa naar uw apparaatinstellingen om {{{biometryType}}} te configureren. Na configuratie schakelt u {{{biometryType}}} voor {{{brandName}}} in via Hoofdmenu > Instellingen.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'Als u {{{biometryType}}} met {{{brandName}}} gebruikt, kunt u uw biometrische identificatie gebruiken in plaats van uw wachtwoord om aan te melden bij {{{brandName}}}.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'Wilt u doorgaan met {{{biometryType}}}?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'Voer het wachtwoord voor {{{brandName}}} in om {{{biometryType}}} in te schakelen',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'Configuratie',
    'LBL_MDM_CONFIRM_CHANGE' => 'Configuratie applicatie is gewijzigd vanuit Mobile Device Manager. Meld u opnieuw aan om veranderingen door te voeren.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'Geef {{{brandName}}} toegang tot uw locatie via uw apparaatinstellingen.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'Huidige locatie is niet beschikbaar',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "Time-out huidige locatie ophalen.\nProbeer het later opnieuw.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'Plaatsmarkeringen locatie zijn niet beschikbaar',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'Coördinaten locatie zijn ongeldig',
    'ERR_MOBILE_INVALID_PASSWORD' => 'Ongeldig wachtwoord.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'Uw app is verouderd en is niet geschikt voor de {{{brandName}}} omgeving waar u verbinding mee probeert te krijgen. Wilt u deze bijwerken?',
    'LBL_MOBILE_BY' => 'Door',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'Dit filter is offline niet beschikbaar',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'Offline records',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'Instellingen downloaden',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'Download uw toegewezen, favoriete en toegestane records voor offline toegang. U kunt uw voorkeuren wijzigen in de offline instellingen.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'Uw records zijn gedownload. U kunt ze openen in de offline modus.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "Niet al uw records zijn gedownload.\nWilt u het opnieuw proberen?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'Mobiele gegevens gebruiken',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'Nu niet',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'De download is gepauzeerd en wordt weer hervat zodra u de app opnieuw opent.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => '{{{module}}} downloaden: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'Nieuwste records bijwerken',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'Wacht op verbinding',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'Gepauzeerd',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'Stoppen',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'Downloaden',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'Pauzeren',
    'LBL_BULK_LOAD_BTN_RESUME' => 'Hervatten',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'Alleen WiFi-verbinding wordt standaard gebruikt',
    'LBL_NPS_RATING_MSG' => "Hoe beoordeelt u uw \n{{{productName}}} ervaring?",
    'LBL_NPS_THANKS_MSG' => 'Bedankt voor uw feedback!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'Wilt u een beoordeling achterlaten in de App Store?',
    'LBL_NPS_NO_THANKS' => 'Nee, bedankt',
    'LBL_NPS_NOT_NOW' => 'Niet nu',
    'LBL_NPS_RATE_NOW' => 'Nu beoordelen',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'Netwerk is niet beschikbaar. U kunt de app blijven gebruiken terwijl u offline bent',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'Uw veranderingen worden geynchroniseerd als u online bent. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>Details bekijken</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'Er zijn ongesynchroniseerde gegevens. Bekijk het <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>transactielogboek</a>',
    'LBL_CONVERT' => 'Converteren',
    'LBL_CONVERT_LEAD' => 'Lead converteren',
    'LBL_SEARCH_EXISTING_RECORD' => '{{{this}}} bestaande zoeken',
    'LBL_DUPLICATES_CHECK_FAILED' => 'Controle op dubbelen mislukt',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'Wilt u soortgelijke activiteiten naar het contactrecord verplaatsen?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'U hebt de lead {{{name}}} met succes geconverteerd',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'Geen duplicaten gevonden.',
    'ERR_LEAD_CONVERSION_FAIL' => 'Leadconversie mislukt',
    'LBL_SELECT_DUPLICATE_RECORD' => 'Selecteren uit duplicaat {{{modulePlural}}}',
    'LBL_SELECTED_EXISTING_RECORD' => '{{{moduleSingular}}} geselecteerd',
    'LBL_CREATED_NEW_RECORD' => 'Nieuwe {{{moduleSingular}}} aangemaakt',
    'LBL_VO_BACK_BTN' => 'Terugknop',
    'LBL_VO_HOME_BTN' => 'Startknop',
    'LBL_VO_DASHBOARD_BTN' => 'Dashboardknop',
    'LBL_VO_SEARCH_BTN' => 'Zoekknop',
    'LBL_VO_RIGHT_MENU_BTN' => 'Rechter menuknop',
    'LBL_VO_ADD_BTN' => 'Knop toevoegen',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'Korting',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'Selecteer een toewijzingsapp',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'De geselecteerde {{entityName}} bevat gekoppelde waardes: {{localizedFieldNames}}. Annuleer om de huidige waarden te behouden. Bevestig om door nieuwe waarden te overschrijven.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'Gegevenscodering is ingeschakeld.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'Geselecteerde lead is reeds geconverteerd.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'Deze actie is alleen beschikbaar als het apparaat online is',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'Weet u zeker dat u een Opportunity wilt maken van de Offerte?',
    'LBL_TAG_ADD' => 'Tag toevoegen',
    'LBL_TAG_ENTER_TAG_NAME' => 'Tag invoeren',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'Filteren op tags wordt niet ondersteund als het apparaat offline is.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'Gehele opmerking tonen',
    'LBL_COMMENT_VIEW' => 'Een opmerking bekijken',
    'LBL_PMSE_LABEL_DUEDATE' => 'Vervaldatum',
    'LBL_PMSE_DUE' => 'Vervalt',
    'LBL_PMSE_DUE_ON' => 'Vervalt op',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'Maak eerst {{conversionParentModuleName}} aan',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'Ontbrekende verplichte records: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'Kies de beeldkwaliteit. Het formaat van de afbeelding wordt daarmee gewijzigd voordat het wordt opgeslagen op de server. De geselecteerde waarde wordt in de toekomst als standaard gebruikt voor alle soortgelijke handelingen.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'Bestandsgrootte schatten...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'De verwachte bestandsgrootte is',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'Beeldkwaliteit',
    'LBL_IMAGE_QUALITY_BEST' => 'Origineel formaat',
    'LBL_IMAGE_QUALITY_GOOD' => 'Goede kwaliteit',
    'LBL_IMAGE_QUALITY_POOR' => 'Klein formaat',
    'LBL_IMAGE_QUALITY_BTN' => 'Compressie: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'Velden weergeven op {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'Reset naar standaard',
    'LBL_LIST_NOT_ENOUGH' => 'Stel minimaal 1 actief veld in.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'U moet aanmelden en machtigingen accepteren om te kunnen werken met het exemplaar van SugarCRM.',
    'LBL_SELECTING_EXISTING_RECORD' => 'Selecteer {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'Maak nieuwe {{{moduleSingular}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'Afbeeldingsgrootte',
    'LBL_COPY_ADDRESS' => 'Adres kopiëren',
    'LBL_OPEN_IN' => 'Openen in',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'Geen bestand geselecteerd.',
    'LBL_ATTACHMENT_ADD' => 'Bijvoegen',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'Deze app gebruikt cookies',
    'LBL_USE_COOKIES_CONFIRM' => 'Deze applicatie gebruikt cookies om u een betere ervaring te kunnen bieden. Door verder te gaan, gaat u akkoord met het gebruik van cookies in overeenstemming met ons privacybeleid.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'U gebruikt een exemplaar van Sugar dat niet compatibel is met Sugar Mobile in een aankomende mobiele release. Vraag uw beheerder zo spoedig mogelijk te upgraden naar Sugar.',
    'ERROR_TAG_NAME_INVALID' => 'Tagnaam mag geen "{{{forbiddenChars}}}" tekens bevatten',
    'ERROR_NO_TAGS_FOUND' => 'Er zijn geen tags beschikbaar die overeenkomen met "{{{searchQuery}}}"',
    'ERR_PA_RECORD_INVALID' => '{{{moduleName}}} record bevat een of meerdere ongeldige waardes en kan niet worden opgeslagen. Wilt u de record bewerken om de actie {{{actionLabel}}} uit te voeren?',
    'ERR_MOBILE_METADATA_RELOAD' => 'Een beheerder heeft configuratiewijzigingen doorgevoerd in uw exemplaar van Sugar. Druk op OK om de configuratie van uw app te synchroniseren met de server.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'Deze applicatie gebruikt cookies',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'Selecteer om te accepteren (verplicht)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'Deze applicatie gebruikt cookies om u een betere ervaring te kunnen bieden. Door verder te gaan, gaat u akkoord met het gebruik van cookies in overeenstemming met ons <a href="{{href}}" target="_blank">privacybeleid</a>.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'De Record View toont gedetailleerde gegevens van het record.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Notes stelt u instaat om samen te werken met andere portal-gebruikers en support-medewerkers.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'Klik hier om een notitie aan dit record toe te voegen.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'Klik op deze icoontjes om de details van de bijgesloten notities te bekijken.',

    //for portal
    'LBL_PORTAL_HOME' => 'Home Dashboard',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'Alle openstaande cases',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'Recentelijk opgeloste cases',
    'LBL_PORTAL_SEARCH' => 'Zoek volgens Naam, Nummer',
    'LBL_SIGNUP_BUTTON_LABEL' => 'Aanmelden',
    'LBL_PORTAL_NO_EMAIL' => 'Geen e-mail ontvangen?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'Wachtwoord vergeten',
    'LBL_PORTAL_FORGOT_USERNAME' => 'Gebruikersnaam vergeten',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'Voer uw wachtwoord tweemaal in. De wachtwoorden moeten overeenkomen.',
    'LBL_PORTAL_RESET_PASSWORD' => 'Reset Wachtwoord',
    'LBL_PORTAL_REENTER_PASSWORD' => 'Wachtwoord opnieuw invoeren',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'Wachtwoorden komen niet overeen, probeer het opnieuw',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'Uw wachtwoord is met succes gereset.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'Er trad een fout op. Stuur een nieuw verzoek om uw wachtwoord te resetten.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'Registreren',
    'LBL_PORTAL_SIGNUP_TITLE' => 'Bedankt voor het aanmelden',
    'LBL_PORTAL_SIGNUP' => 'We zullen u informeren wanneer we uw gegevens hebben bevestigd.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'Voornaam',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'Achternaam',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'Gebruikersnaam',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'E-mailadres',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (optioneel)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'Land',
    'LBL_PORTAL_SIGNUP_STATE' => 'Provincie',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'Organisatienaam',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'Functie (optioneel)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'Wachtwoord',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'Bevestig wachtwoord',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'Aanmeldgegevens vergeten',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'Wachtwoord vergeten?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'Neem contact op met uw Sugar beheerder om uw wachtwoord te resetten.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'Gebruikersnaam',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'Wachtwoord',
    'LBL_PORTAL_LOADING' => 'Bezig met laden',
    'LBL_PORTAL_SAVING' => 'Opslaan',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'Pagina niet beschikbaar',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "Het spijt ons, maar deze feature is op dit moment niet beschikbaar.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'Laat resultaten zien voor "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'Geen e-mail ontvangen?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'Voor hulp of om contact met ons op te nemen, gebruikt u het volgende: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'Telefoonnummer: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'E-mailadres: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'Web: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'Weet u zeker dat u de chat wilt sluiten?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'Nieuwe Notitie of Bijlage',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'Voeg een notitie toe',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'Uw aanmelding was niet succesvol. Probeer het opnieuw.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'Invalid Credentials',
    'LBL_PORTAL_INVALID_GRANT' => 'Uw sessie is vervallen. Log opnieuw in.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'Sessie vervallen',
    'LBL_PORTAL_AUTH_FAILED' => 'Client-verificatie mislukt.',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'Ongeldige Client',
    'LBL_PORTAL_INVALID_REQUEST' => 'The request made is invalid or malformed. Neem contact op met technische ondersteuning.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'Ongeldig verzoek',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'Voor het verzoek is een time-out opgetreden.',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'Verzoek time-out',
    'LBL_PORTAL_UNAUTHORIZED' => 'Het spijt ons, maar het lijkt erop dat u geen toegang heeft tot deze bron.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'HTTP Error: Niet geautoriseerd.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'Bron niet beschikbaar.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'HTTP Error: Forbidden',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'HTTP method not allowed for this resource. Neem contact op met technische ondersteuning.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP Error: Method Not Allowed',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'Request failure, or, missing/invalid parameter. Neem contact op met technische ondersteuning.',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'HTTP Error:',
    'LBL_PORTAL_MIN_MODULES' => 'U dient minimaal de cases, bugs of knowledge base module ingeschakeld hebben om deze applicatie te gebruiken.',
    'LBL_PORTAL_ERROR' => 'Fout',
    'LBL_PORTAL_ROUTE_ERROR' => 'Probleem bij het laden van de module. Probeer het later weer of neem contact op met ondersteuning.',
    'LBL_PORTAL_OFFLINE' => 'Helaas, de applicatie is op dit moment niet beschikbaar. Neem contact op met de &#39;site administrator&#39;.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'Verander wachtwoord',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'Gebruikersnaam is reeds geregistreerd in het systeem. Vraag een nieuw wachtwoord aan of selecteer een andere gebruikersnaam.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'Het ingevoerde e-mailadres is ongeldig.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'De wachtwoorden komen niet overeen.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'Serviceconsole',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'Overzicht',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'Standaard dashboard herstellen',
    'LBL_UNTITLED' => 'Zonder titel',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'Vernieuwingenconsole',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'Overzicht',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'Fase/Status',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'Naam/Accountnaam',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'Dashboard Omnichannel',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'Klant',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} om {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'Uw browser wordt niet ondersteund voor SugarLive. Gebruik Google Chrome of Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'Er is een <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> aangemaakt met de details van uw gesprek.',
    'LBL_OMNICHANNEL_SUBJECT' => 'Onderwerp',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'Beschrijving',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'Samenvatting bericht',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'Samenvatting oproep',
    'LBL_OMNICHANNEL_LINK_TO' => 'Koppel {{fromModule}} aan {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'Koppeling naar {{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'Gekoppeld',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'Uw browser wordt niet ondersteund voor chatten. Gebruik Google Chrome of Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Neem contact op met uw Sugar Administrator voor hulp.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'Layout configureren',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'Voltooi de configuratie van SugarLive voordat u een uitgaande oproep doet.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'Voltooi de configuratie van de layout van SugarLive voordat u het opent in SugarLive.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'Zet uzelf op "Offline" in SugarLive voordat u de layout van SugarLive configureert.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'Compacte weergave',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'Volledige weergave',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR-dashboard',
    'LBL_SALES_MANAGER_CONSOLE' => 'Dashboard voor verkoopmanagers',
    'LBL_SALES_REP_CONSOLE' => 'Dashboard voor verkoopmedewerkers',
    'LBL_MARKETING_CONSOLE' => 'Marketingdashboard',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'Dashboard voor klantsucces',
    'LBL_EXECUTIVE_CONSOLE' => 'Dashboard voor leidinggevenden',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'Tabblad naar standaard resetten',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'Samenvattingspaneel configureren',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'Gebruikersprofiel',
    'LBL_WIZ_COMPLETE_TITLE' => 'Setup voltooid',
    'LBL_SETUP_COMPLETE_INFO' => 'Begin Sugar te gebruiken!',
    'LBL_SETUP_USER_INFO' => 'Stel uw gebruikersprofiel in',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'Lokale gebruikersinstellingen',
    'LBL_SETUP_USER_LOCALE_INFO' => 'Stel uw tijdszone, datum en format voor namen in.',
    'LBL_WIZ_START_SUGAR' => 'Start Sugar',
    'LBL_WIZ_FIRST_NAME' => 'Voornaam',
    'LBL_WIZ_LAST_NAME' => 'Achternaam',
    'LBL_WIZ_EMAIL' => 'E-mail',
    'LBL_WIZ_TIMEZONE' => 'Tijdzone',
    'LBL_WIZ_TIMEFORMAT' => 'Tijdweergave',
    'LBL_WIZ_DATE_FORMAT' => 'Datumweergave',
    'LBL_WIZ_NAME_FORMAT' => 'Standaard naamweergave',
    'LBL_SETUP_PROGRESS' => 'Voortgang van setup',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar Training',
    'LBL_WIZ_DOCUMENTATION' => 'Documentatie',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'Knowledge Base',
    'LBL_WIZ_FORUMS' => 'Fora',
    'TPL_TIMEZONE_DIFFERENT' => 'De tijdzone van uw browser komt niet overeen met uw opgeslagen tijdzone. {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'Pas uw tijdzone aan.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'Lokale Instellingen',
    'LBL_WIZ_EMAIL_SETTINGS' => 'E-mailinstellingen',
    'LBL_WIZ_IMPORT_DATA' => 'Importeer Data',
    'LBL_WIZ_CREATE_USERS' => 'Gebruikers aanmaken',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'Systeeminstellingen',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Studio',

    'LBL_CSP_ERROR_MESSAGE' => 'De waarde die u hebt ingevoerd, wordt niet ondersteund of komt niet overeen met het geaccepteerde format. Voor een lijst met geaccepteerde waarden en formats raadpleegt u de <a href="{{linkToDocumentation}}" target="_blank">Systeemdocumentatie</a>.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'Deze content is niet goedgekeurd. Werk de <a href="{{linkToDocumentation}}" target="_blank">Instellingen van het contentbeveiligingsbeleid</a> van uw systeem bij.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'De content is niet goedgekeurd. Vraag uw beheerder de <a href="{{linkToDocumentation}}" target="_blank">Instellingen van het contentbeveiligingsbeleid</a> van uw systeem bij. Once the settings have been updated, you will need to refresh your browser for the changes to take effect.',

    // For password related labels
    'LBL_PASSWORD' => 'Wachtwoord',
    'LBL_CHANGE_YOUR_PASSWORD' => 'Wijzig uw wachtwoord',
    'LBL_PASSWORD_REQUIREMENTS' => 'Wachtwoordvereisten',
    'LBL_CURRENT_PASSWORD' => 'Huidig wachtwoord',
    'LBL_NEW_PASSWORD1' => 'Nieuw wachtwoord',
    'LBL_NEW_PASSWORD2' => 'Bevestig wachtwoord',
    'LBL_PASSWORD_CHANGED' => 'U heeft uw wachtwoord gewijzigd',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'Vul uw nieuwe wachtwoord ter bevestiging in.',
    'ERR_ENTER_NEW_PASSWORD' => 'Vul uw nieuwe wachtwoord in.',
    'ERR_ENTER_OLD_PASSWORD' => 'Vul uw oude wachtwoord in.',
    'ERR_REENTER_PASSWORDS' => 'De wachtwoorden moeten overeenkomen.',
    'ERR_PASSWORD_MISMATCH' => 'Het ingevoerde wachtwoord is onjuist.',
    'LBL_CANNOT_SEND_PASSWORD' => 'Kan geen wachtwoord sturen',
    'LBL_REQUEST_PASSWORD' => 'Vraag wachtwoord aan',
    'LBL_RESET_PASSWORD' => 'Reset Wachtwoord',
    'LBL_RESET_PASSWORD_MESSAGE' => 'Voer uw gebruikersnaam in, dan zullen wij u een link sturen om uw wachtwoord te resetten.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Controleer uw e-mail.<br><br>We hebben instructies voor het resetten van uw wachtwoord naar het e-mailadres gestuurd dat bij ons bekend is.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'Fout: Er was een probleem bij het wijzigen van het wachtwoord voor deze gebruiker.',
    'LBL_INCORRECT_PASSWORD' => 'Fout: Onjuist wachtwoord.',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'Het ingevoerde wachtwoord voldoet niet aan de eisen voor een wachtwoord. Probeer het nogmaals.',
    'LBL_PASSWORD_MIN_LENGTH' => 'Minimale lengte is {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'Maximale lengte is {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'Moet een hoofdletter bevatten (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'Moet een kleine letter bevatten (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'Moet een nummer bevatten (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'Moet een speciaal teken bevatten (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'Het wachtwoord mag niet overeenkomen met het reguliere uitdrukkingspatroon: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'Taalvoorkeur:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'Kon e-mail voor resetten wachtwoord niet verzenden.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'Kies een rapport',
    'LBL_REPORT_AUTO_REFRESH' => 'Ververs automatisch',
    'LBL_REPORT_EDIT' => 'Pas het gekozen rapport aan',
    'LBL_REFRESH_LIST_AND_CHART' => 'Lijst en grafiek vernieuwen',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'Geen grafiek beschikbaar.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'Dit rappot bevat geen filters.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'U hebt alleen verborgen uitvoertijdfilters, zie geavanceerde filteres.',
    'LBL_RUNTIME_FILTERS' => 'Runtime filters',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'De datum komt niet overeen met de gewenste datumnotatie van de gebruiker: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'Deze dashlet heeft geen runtime filters',
    'LBL_DASHBOARD_FILTER_GROUP' => 'Nieuw filter',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'U moet minimaal één waarde selecteren.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'Terug naar de standaard filters',
    'LBL_COPY_FILTER_SUMMARY' => 'Samenvatting filter kopiëren',
    'LBL_APPLY_FILTERS' => 'Toepassen',
    'LBL_REPORTS_FILTERS' => 'Filters',
    'LBL_RUNTIME_FILTERS_INVALID' => 'Uitvoertijd filters kan niet worden toegepast vanwege ongeldige waarden',
    'LBL_RUNTIME_FILTERS_COPIED' => 'De samenvatting van het filter is gekopieerd naar uw klembord.',
    'LBL_ADVANCED_FILTERS' => 'Geavanceerde filters',
    'LBL_ADVANCED_OR_DESC' => 'Insluiten als aan ÉÉN voorwaarde is voldaan',
    'LBL_ADVANCED_AND_DESC' => 'Insluiten als aan ALLE voorwaarden is voldaan',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'Dit is een origineel designfilter',
    'LBL_AND_UPPERCASE' => 'EN',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'Deze functie is niet beschikbaar in de Voorbeeldmodus',
    'LBL_REPORT_DEFAULT_NAME' => 'Rapport zonder titel',
    'LBL_REPORT_QUERY' => 'Query',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'Gekoppeld aan huidige record',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'Gekoppeld veld',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'Gekoppeld veld mag niet leeg zijn',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'Geen rapport geselecteerd.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'Lijndiagram is niet compatibel met dit rapport',
    'LBL_REPORT_DASHLET' => 'Rapport dashlet',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'Datatabel',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'Runtime filters',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'Voorbeeld gegevenstabel',
    'LBL_REPORTS_DASHLET_CHART' => 'Grafiek',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'Voorbeeld grafiek',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'Voorvertoning filter',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'Het geselecteerde rapport ondersteunt geen grafiek.',
    'LBL_REPORTS_DASHLET_LABELS' => 'Labels',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'Toon totaal aantal records',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'Sorteervolgorde',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'Standaard geselecteerd filter',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'Primaire sorteervolgorde grafiek',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'Secundaire sorteervolgorde grafiek',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'Nr. {{module}} koppelt naar geselecteerd rapport',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'Niet beschikbaar voor dit rapporttype',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'Deze functie is alleen beschikbaar op het tabblad grafiek',
    'LBL_REPORTS_CHART_TYPE' => 'Grafiektype',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'Locatie staafdiagramwaarde',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'Totaal weergeven',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'Legenda tonen',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'X-as-label tonen',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Y-as-label tonen',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Weergavelimiet voor rijen',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'U heeft geen rechten om deze uitvoertijdfilters te gebruiken.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'Onbekend',
    'ERR_HTTP_DEFAULT_TITLE' => 'Onbekende fout',
    'ERR_HTTP_DEFAULT_TEXT' => 'Onbekende fout',
    'ERR_HTTP_DEFAULT_ACTION' => 'Ga terug naar de vorige pagina.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'Fout: Ongeldig verzoek',
    'ERR_HTTP_400_TEXT_LINE1' => 'Uw browser heeft een verzoek verzonden dat de server niet kon begrijpen.',
    'ERR_HTTP_400_TEXT_LINE2' => 'Neem contact op met uw Sugar Administrator voor meer informatie.',
    'ERR_HTTP_400_ACTION' => 'Ga terug naar de vorige pagina.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'Gegevens niet beschikbaar',
    'ERR_HTTP_404_TEXT_LINE1' => 'Pagina bestaat niet of u heeft geen toegang tot deze pagina.',
    'ERR_HTTP_404_TEXT_LINE2' => 'Probeer het opnieuw. Als de fout zich blijft voordoen, neem contact op met uw Sugar-beheerder.',
    'ERR_HTTP_404_ACTION' => 'Ga terug naar de vorige pagina.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 Interne serverfout',
    'ERR_HTTP_500_TEXT_LINE1' => 'De server heeft een fout aangetroffen en kan uw verzoek niet voltooien.',
    'ERR_HTTP_500_TEXT_LINE2' => 'Probeer het opnieuw. Als de fout zich blijft voordoen, neem contact op met uw Sugar-beheerder.',
    'ERR_HTTP_500_ACTION' => 'Neem contact op met technische ondersteuning.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 interne serverfout',
    'ERR_HTTP_502_TEXT_LINE1' => 'Er trad een tijdelijke fout op in de server, waardoor uw verzoek niet kon worden voltooid.',
    'ERR_HTTP_502_TEXT_LINE2' => 'Probeer het opnieuw. Als de fout zich blijft voordoen, neem dan contact op met uw Sugar systeembeheerder.',
    'ERR_HTTP_502_ACTION' => 'Neem contact op met technische ondersteuning.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 interne serverfout',
    'ERR_HTTP_503_TEXT_LINE1' => 'De server is niet bereikbaar om uw aanvraag te voltooien.',
    'ERR_HTTP_503_TEXT_LINE2' => 'Probeer het later opnieuw. Als de fout zich blijft voordoen, neem dan contact op met uw Sugar systeembeheerder.',
    'ERR_HTTP_503_ACTION' => 'Neem contact op met technische ondersteuning.',

    'ERR_RENDER_FAILED_TITLE' => 'Weergave opbouwen mislukt',
    'ERR_RENDER_FAILED_MSG' => 'Het opbouwen van een weergave is mislukt',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'Opbouwen veldweergave mislukt',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'Opbouwen weergave van {0} veld mislukt.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'Toegang geweigerd',
    'ERR_NO_VIEW_ACCESS_REASON' => 'U heeft geen toegang tot deze pagina',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'Neem contact op met uw administrator voor toegang.',
    'ERR_NO_VIEW_ACCESS_MSG' => 'Neem contact op met uw administrator om toegang te krijgen tot de weergave van de {0} module.',

    'ERR_LAYOUT_RENDER_TITLE' => 'Opbouwen van layoutweergave mislukt',
    'ERR_LAYOUT_RENDER_MSG' => 'Oeps! Er kon geen weergave opgebouwd worden. Probeer het later opnieuw of neem contact op met support.',
    'ERR_INTERNAL_ERR_MSG' => 'Interne fout',
    'ERR_GENERIC_TITLE' => 'Fout',
    'ERR_CONTACT_TECH_SUPPORT' => 'Neem contact op met technische ondersteuning.',

    'LBL_SYNCED_RECURRING_MSG' => 'Dit records kunt u niet aanpassen, omdat het gesynchroniseerd is uit een extern programma.',
    'LBL_EXISTING' => 'Bestaand',
    'LBL_PANEL_DEFAULT' => 'Standaard',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'Ongeldig antwoord van de server',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'Fout opgetreden tijdens AssignTo-actie.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'U heeft geen toegang tot"{{name}}". Neem contact op met uw administrator.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'Jaar {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'Meer Acties',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'Waarschuwing',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'Negeer duplicaat en sla op',
    'LBL_RESTORE' => 'Herstel naar origineel',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'Records die zijn gemarkeerd voor verwijdering',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'Geeft records weer die zijn gekoppeld aan een verzoek om privacygegevens aan '
        . 'Informatie wissen.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS Feed',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'Blijf up-to-date door een externe RSS of Blog Feed toe te voegen.',
    'LBL_RSS_FEED_URL' => 'Feed URL',
    'LBL_RSS_FEED_AUTHOR' => 'Auteur:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'Aantal weer te geven items',
    'LBL_ERR_LOADING_RSS_FEED' => 'Failed loading RSS Feed',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'Mijn items',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'Items van team',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'Hiermee kunnen gebruikers Sugar-apps toevoegen aan een dashboard',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'Geschiedenis',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'Het &#39;Historie dashlet&#39; toont gehouden meetings, gehouden telefoongesprekken, ontvangen e-mails en verzonden e-mails.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'E-mail',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'E-mails',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'Mijn geschiedenis',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'Geschiedenis van het team',
    'LBL_UNASSIGNED' => 'Niet toegewezen',
    'LBL_ARCHIVE_EMAIL' => 'E-mail archiveren',
    'LBL_EMAIL_ARCHIVED' => 'E-mail gearchiveerd',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'Gearchiveerde e-mail aanmaken',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'Geplande activiteiten',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'Het &#39;Geplande Activiteiten&#39; dashlet toont de geplande meetings en telefoongesprekken.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'Vandaag',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'Toekomst',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'Mijn activiteiten',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'Activiteiten van team',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'Gehouden',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'Weet u zeker dat u {0} als gesloten wilt markeren?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'Openstaande taken',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Het opstaande taken dashlet toont de taken die nog gedaan moeten worden.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'Verstrijkt nu',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'Opkomend',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'Te doen',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'Afgerond',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'Weet u zeker dat u de {0} als voltooid wilt markeren?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mijn taken',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Taken van team',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'Er was een extra e-mailadres gekoppeld aan het record dat u aan het bewerken bent. Het is nu ingesteld als primair en wordt hieronder getoond.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'Inactieve taken',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Het taken dashlet toont uitgestelde en voltooide taken.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'Uitgesteld',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'Afgerond',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'laatst bijgewerkt {{relativetime}} op {{date}} om {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mijn taken',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Taken van team',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'Mijn recentelijk bekeken cases',

    'LBL_REPORT_DASHLET_TITLE_12' => 'Open cases door gebruiker op status',
    'LBL_REPORT_DASHLET_TITLE_125' => 'Nieuwe cases op zakelijk centrum op week',
    'LBL_REPORT_DASHLET_TITLE_126' => 'Recentelijk aangemaakte cases',
    'LBL_REPORT_DASHLET_TITLE_127' => 'Nieuwe cases op zaaklaag op week',
    'LBL_REPORT_DASHLET_TITLE_128' => 'Open cases op klantlaag en prioriteit',
    'LBL_REPORT_DASHLET_TITLE_129' => 'Totaal cases opgelost deze maand op zakelijk centrum',
    'LBL_REPORT_DASHLET_TITLE_130' => 'Totaal cases opgelost deze maand op agent',
    'LBL_REPORT_DASHLET_TITLE_131' => 'Lijst met recentelijk opgeloste cases',
    'LBL_REPORT_DASHLET_TITLE_132' => 'Mijn cases deze maand opgelost op week',
    'LBL_REPORT_DASHLET_TITLE_133' => 'Mijn cases vandaag en te laat',
    'LBL_REPORT_DASHLET_TITLE_134' => 'Alle cases vandaag en te laat',
    'LBL_REPORT_DASHLET_TITLE_135' => 'Mijn open cases op opvolgingsdatum',
    'LBL_REPORT_DASHLET_TITLE_136' => 'Alle open cases op opvolgingsdatum',
    'LBL_REPORT_DASHLET_TITLE_137' => 'Mijn open cases op status',
    'LBL_REPORT_DASHLET_TITLE_138' => 'Mijn cases afgelopen week op status',
    'LBL_REPORT_DASHLET_TITLE_139' => 'Status open taken die aan mij zijn toegewezen',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP of oude REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar Workflow',
    'LBL_AUDIT_SUBJECT_USER' => 'Gebruiker',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web naar lead',

    //common chart strings
    'LBL_CHART' => 'Grafiek',
    'LBL_CHART_NO_DATA' => 'Geen gegevens gevonden.',
    'LBL_CHART_LEGEND_CLOSE' => 'Verberg legenda',
    'LBL_CHART_LEGEND_OPEN' => 'Toon legenda',
    'LBL_CHART_CONTROLS_CLOSE' => 'Verberg opties',
    'LBL_CHART_CONTROLS_OPEN' => 'Toon opties',
    'LBL_CHART_UNDEFINED' => 'Niet ingegeven',
    'LBL_CHART_NO_LABEL' => 'Niet gedefinieerd',
    'LBL_CHART_AMOUNT' => 'Bedrag',
    'LBL_CHART_COUNT' => 'Aantal',
    'LBL_CHART_PERCENT' => 'Percentage',
    'LBL_CHART_GROUP' => 'Groep',
    'LBL_CHART_DATE' => 'Datum',
    'LBL_CHART_KEY' => 'Sleutel',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'Grafiek type',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'Toon titel',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'Totaal weergeven',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Toon x-as label',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Toon y-as label',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'Weergavemethodes selecteren',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'Maatstreepje teruglopen',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'Maatstreepje verspringen',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'Maatstreepje roteren',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'Locatie staafdiagramwaarde',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'Weergaveopties staafdiagram',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'Scrollen toelaten',
    'LBL_CHART_CONFIG_STACK_DATA' => 'Gegevenreeksen stapelen',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'Lege groepen verbergen',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'verzonden',
    'LBL_EMAIL_RECV' => 'rec',

    //record save
    'LBL_RECORD_SAVED' => 'Record opgeslagen.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'U heeft {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a> succesvol aangemaakt.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'U hebt met succes de {{moduleSingularLower}} aangemaakt.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'U heeft het record aangemaakt, maar u heeft geen toegang om het record te bekijken.', // use when user has no access to the model
    'LBL_VALIDATING' => 'Valideren...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'Succes:',
    'LBL_ALERT_TITLE_WARNING' => 'Waarschuwing:',
    'LBL_ALERT_TITLE_NOTICE' => 'Melding:',
    'LBL_ALERT_TITLE_ERROR' => 'Fout:',
    'LBL_ALERT_TITLE_LOADING' => 'Bezig met laden',
    'LBL_ALERT_NO_ACCESS' => 'U hebt geen toegang tot het toegepaste filter in deze dashlet.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'Kopieer het dashboard om deze dashlet te configureren met uw eigen filter.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => '(De versie van) uw browser wordt niet (langer) ondersteund.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'Ondersteunde platforms',
    'LBL_ALERT_CONFIRM_DELETE' => 'Weet u zeker dat u dit item wilt verwijderen?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'Weet u zeker dat u deze items wilt verwijderen?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'Het geselecteerde record bevat op dit moment de volgende gerelateerde waardes: {{values}}. Klik op "Bevestig" om de waarden te kopiëren. Klik op "Annuleren" om de huidige waarden te behouden.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'De gekozen {{moduleSingularLower}} heeft gekoppelde waardes: {{values}}. Annuleer om de huidige waarden te behouden. Bevestig om de waarden te overschrijven met de nieuwe waarden.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'Oorspronkelijk:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'Nieuw:',

    //organization chart
    'LBL_ORG_CHART' => 'Organogram',
    'LBL_ORG_CHART_DESC' => 'Toont de personele structuur van uw organisatie.',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'Toon orientatie',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'Toon alle nodes',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'Passend maken',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'Case samenvatting',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'Toont een overzicht van de gerelateerde cases.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'Samenvatting',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'Gesloten cases',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'Openstaande cases',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'Top 10 opportunities',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'Toont de top tien opportunities in een bellendiagram.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'Mijn opportunities',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "Opportunities van mijn team",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'Standaard datum filter',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'Standaard dataset',

    'LBL_PRODUCT_CATALOG_NAME' => 'Productcatalogus',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'Productcatalogus',
    'LBL_PRODUCT_CATALOG_DESC' => 'Bekijk items en voeg items toe vanuit uw productcatalogus.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'Bekijk items en voeg items toe vanuit uw productcatalogus.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} op {{date}} om {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Type een notitie of sleep een bijlage naar het veld. Type @ om een gebruiker te vermelden. Type # om te refereren aan een record.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'Regeer hier... Type @ om een gebruiker te vermelden. Type # om te refereren aan een record.',
    'LBL_ACTIVITY_STREAM' => 'Activity Stream',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'Activity Stream is niet ingeschakeld',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'Activity Stream is niet ingesteld voor deze module',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'Toon meer posts...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'op',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'Mijn Activity Stream',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'Toont een lijst met alle activiteiten bij records en plaats commentaar hierop.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'Activity Streams zijn uitgeschakeld',

    'LBL_DATA_VIEW' => 'Data View',
    'LBL_COMMENT' => 'Commentaar',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'Er kon geen verbinding met de server gemaakt worden. Probeer het a.u.b. opnieuw.',
    'ERR_RESOLVE_ERRORS' => 'Los eventuele fouten op voordat u verder gaat.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'Om goed te keuren, moeten alle verplichte velden zijn ingevuld. U kunt dit record echter nog wel weigeren of herleiden.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'Alle verplichte velden moeten zijn ingevuld om te weigeren/herleiden.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'Lijst vernieuwen',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'Tegels vernieuwen',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'meer',
    'LBL_TEXTAREA_LESS' => 'minder',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} bijlagen',
    'LBL_CREATE_ATTACHMENT' => 'Bijlage aanmaken',
    'LBL_DASHLET_REFRESH' => 'Vernieuwen',
    'LBL_DASHLET_MOVE' => 'Verplaats',
    'LBL_DASHLET_CLOSE' => 'Sluit',

    'LBL_DASHLET_FORECAST_NAME' => 'Forecast',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'Forecast staafdiagram',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Forecast staafdiagram',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'Forecast voor',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'Toont de forecast staafdiagram voor een specifieke periode',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'Groeperen op',
    'LBL_DASHLET_FORECASTS_DATASET' => 'Dataset',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'Details voorspellen',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'Toon huidige forecast details.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'Opgeslagen rapportagediagrammen dashlet',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'Toont het diagram van een opgeslagen rapport.',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'Gepubliceerde soortgelijke artikelen',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'Samenvatting historie',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'Meer historie...',
    'LBL_RELATED_CONTACT' => 'Gekoppeld contact',
    'LBL_MODULE_TYPE' => 'Type',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'E-mail aan',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'E-mail van',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'Geen voorvertoning voor historische modules.',

    //SFA
    'LBL_BEST' => 'Beste',
    'LBL_WORST' => 'Slechtste',
    'LBL_LIKELY' => 'Meest waarschijnlijk',
    'LBL_BEST_FORECAST' => 'Commitment (beste)',
    'LBL_WORST_FORECAST' => 'Commitment (slechtste)',
    'LBL_LIKELY_FORECAST' => 'Commitment (waarschijnlijk)',
    'LBL_BEST_ADJUSTED' => 'Gewijzigde commitment (beste)',
    'LBL_WORST_ADJUSTED' => 'Gewijzigde commitment (slechtste)',
    'LBL_LIKELY_ADJUSTED' => 'Gewijzigde commitment (waarschijnlijk)',
    'LBL_AMOUNT_USDOLLAR' => 'Bedrag',
    'LBL_OVERDUE' => 'Achterstallig',

    'LBL_PASSWORD_REQUEST_SENT' => 'Uw verzoek is ingediend.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'De door u ingevoerde combinatie van gebruikersnaam en e-mail is onjuist.',

    'LBL_REMINDER_TITLE' => 'Herinnering',
    'LBL_CLICK_TO_DRILLDOWN' => 'Klik om in te zoomen',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'U kunt niet alle talen uitschakelen.',

    'LBL_UPDATE_CALC_FIELDS' => 'Herbereken waarden',

    //Optimistic Locking
    'LBL_YOU' => 'U',
    'LBL_RESOLVE_CONFLICT' => 'Los conflict op voor {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'Voor meer informatie, kijk dan {{{more_info_url}}} in de documentatie voor {{plural_module_name}}.{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'Geen gegevens beschikbaar',
    'LBL_NEED_HELP' => 'Hulp met iets nieuws nodig?',
    'LBL_NEW_CASE' => 'Nieuwe case',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'Het help dashlet geeft specifieke informatie behorend bij de module die u bekijkt, in combinatie met een sneltoets naar de bijbehorende documentatie (bijv. Leads documentatie) in de engelstalige handleiding voor meer informatie.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'Hulp lijstweergave',
    'LBL_HELP_RECORDS' => "De List View van een module toont alle records die voldoen aan de opgegeven zoekcriteria en waar de gebruiker toegang tot heeft. U kunt de basisgegevens van elk record zien in de kolommen van de lijstweergave of de Record View openen door op de naam van het record te klikken.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'Recordweergave Hulp',
    'LBL_HELP_RECORD' => 'Deze Record View biedt gedetailleerde informatie over een individueel record als ook enkele gegevens over de gekoppelde records.

- Pas de gegevens aan door op een individueel veld of op de Wijzigen knop te klikken.
- Bekijk of pas koppelingen met andere records aan in de subpanels door de "Data View" in te schakelen in het paneel linksonder.
- Maak en bekijk opmerkingen van gebruikers en de wijzigingshistorie door "Activity Stream" in te schakelen in het paneel linksonder.
- Volg of maak het record favoriet door gebruik te maken van de icoontjes rechts naast de naam van het record.
- Extra acties zijn beschikbaar via het dropdown actie menu rechts naast de Wijzigen knop.',

    // create view
    'LBL_HELP_CREATE_TITLE' => 'Aanmaken {{module_name}}',
    'LBL_HELP_CREATE' => 'Om {{plural_module_name}} aan te maken:
1. Voer de gewenste gegevens in.
 * Velden die "vereist" zijn, moeten ingevuld zijn voordat het record opgeslagen kan worden.
 * Klik op "Toon meer" om extra velden te tonen.
2. Klik op "Opslaan" om het record op te slaan en terug te keren naar de {{plural_module_name}} list view.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'Mogelijk duplicaat gevonden',
    'LBL_HELP_DUPLICATE' => 'Sugar heeft gesignaleerd dat het record dat u probeert aan te maken, mogelijk al bestaat.

Om een bestaand record aan te passen in plaats van een nieuw record aan te maken, klik op "Selecteer en pas aan" - rechterzijde van het gewenste record. Lege velden van het bestaande record zullen gevuld worden met de waarden die u reeds ingevuld heeft. Klik op "Opslaan" om de wijzigingen door te voeren aan het bestaande record.

Als u, in plaats daarvan, de waarden wilt gebruiken die u zojuist heeft ingevoerd in plaats van de waarden van het bestaande record: klik dan op "Herstel naar origineel". De waarden die u heeft ingevoerd zullen dan toegepast worden op het bestaande record en u kunt vervolgens additionele wijzingen doorvoeren en klikken op "Opslaan" om de aanpassingen aan het oorspronkelijke record door te voeren.

Om een nieuw record aan te maken op basis van de door u ingevoerde waarden, klikt u op "Negeer duplicaat en sla op" - rechtsbovenaan het scherm.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'SMTP Server instellingen ontbreken',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'Om meldingen bij toewijzen te versturen, dient een SMTP server ingesteld te zijn in {{emailSettingsUrl}}.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'E-mailinstellingen',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'Nieuwe voorraadrapporten beschikbaar',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'Er zijn nieuwe voorraadrapporten beschikbaar in uw ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'Rapport module',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'Deze zijn getagd als "Voorraadrapport" en kunnen worden gefilterd. Rapporten zijn ook getagd als "Verkoop en marketing", "Klantenservice", "Gegevensprivacy" of "Administratief", op basis van de content. Raadpleeg voor meer informatie de ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'documentatie',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM stelt gebruikers in staat om snel bepaalde taken uit te voeren met toetsenbord sneltoetsen. De tabellen aan de rechterzijde beschrijven de beschikbare sneltoetsen met de toetsen en acties die ze uitvoeren.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>Ondersteunde tekens</h1><ul><li>alle alfanumerieke tekens en symbolen</li><li>shift, ctrl, alt, command, mod (ctrl voor Windows/Linux en command voor Macs)</li><li>enter, esc, space, tab, pageup, pagedown, end, home, ins, del, backspace</li></ul><h1>Ondersteunde functies</h1><ul><li>Toetscombinatie: ctrl+m</li><li>Meerdere toetsen: m,ctrl+m</li><li>Toetsvolgorde: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'Algemene sneltoetsen',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'Contextuele sneltoetsen',
    'LBL_SHORTCUT_KEY_KEY' => 'Sleutel',
    'LBL_SHORTCUT_FUNCTION' => 'Functie',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Contextuele snelkoppelingen configureren',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'Geen contextuele snelkoppelingen te configureren',
    'LBL_SHORTCUT_HELP' => 'Toon help sneltoetsen',
    'LBL_SHORTCUT_QUICK_CREATE' => 'Toon het quick create menu',
    'LBL_SHORTCUT_SEARCH' => 'Ga naar global search veld',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'Toon sidecar',
    'LBL_SHORTCUT_CREATE_RECORD' => 'Nieuw record aanmaken',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'Kies volgend record uit de lijst',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'Kies vorig record uit de lijst',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'Scroll lijst naar links',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'Scroll lijst naar rechts',
    'LBL_SHORTCUT_OPEN' => 'Open gekozen record in de lijst',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'Wijzig gekozen record in de lijst',
    'LBL_SHORTCUT_RECORD_DELETE' => 'Verwijder record',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Sluit inline edit modus zonder op te slaan',
    'LBL_SHORTCUT_RECORD_SAVE' => 'Sla record op',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'Wis alle wijzigingen aan het record',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'markeer record als favoriet',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'Volg record',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'Voorvertoning van record',
    'LBL_SHORTCUT_MARK_SELECTED' => 'Markeer record als geselecteerd',
    'LBL_SHORTCUT_SELECT_ALL' => 'Selecteer alles',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'Open actie menu',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'Ga naar filter veld',
    'LBL_SHORTCUT_FILTER_CREATE' => 'Een nieuwe lijstfilter aanmaken',
    'LBL_SHORTCUT_FILTER_EDIT' => 'Pas huidig filter aan',
    'LBL_SHORTCUT_FILTER_SHOW' => 'Open filter menu',
    'LBL_SHORTCUT_RECORD_EDIT' => 'Wijzig record',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'Open voorgaande record',
    'LBL_SHORTCUT_RECORD_NEXT' => 'Open volgende record',
    'LBL_SHORTCUT_COPY_RECORD' => 'Kopieer huidig record',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'Open primaire actiemenu',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'Sluit drawer',
    'LBL_SHORTCUT_FILTER_ADD' => 'Voeg extra zoekcriteria toe',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'Verwijder laatste zoekcriterium',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'Sluit filter',
    'LBL_SHORTCUT_FILTER_SAVE' => 'Sla filter op',
    'LBL_SHORTCUT_FILTER_DELETE' => 'Verwijder filter',
    'LBL_SHORTCUT_FILTER_RESET' => 'Wis filter',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'Voeg rij toe',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'Verwijder rij',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'Sluit massaal wijzigen',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'Records bijwerken',
    'LBL_CREATE_CATEGORY' => 'Maak een <div class="btn-link" data-action="create-new">categorie</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'Bevestig',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'Annuleer',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'Selecteer alle items in een meervoudig selectieveld',
    'LBL_SHORTCUT_SWEETSPOT' => 'Het Sweet Spot-diagram in-/uitschakelen',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'Het Sweet Spot-diagram verbergen',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'Configuratie opslaan',
    'LBL_SHORTCUT_RESTORE' => 'Standaardinstellingen herstellen',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'Er is een fout opgetreden tijdens het opslaan van aangepaste sneltoetsen op de server. Probeer het opnieuw.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}} instellingen',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}} configuratie settings zijn opgeslagen.',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} Configuratie Error',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} heeft geen configuratie-instellingen',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'Gebruiker heeft geen toegang tot {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'Gebruiker heeft geen toegang om {{module}} instellingen te configureren',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'Database settings for {{module}} need to be fixed',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'tot',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'Begin & Einddatum',

    'LBL_CALENDAR_START_DATE' => 'Begindatum',
    'LBL_CALENDAR_END_DATE' => 'Einddatum',
    'LBL_CALENDAR_DURATION' => 'Duur',
    'LBL_CALENDAR_RECURRENCE' => 'Herhaling',
    'LBL_CALENDAR_REMINDERS' => 'Herinneringen',

    'LBL_CALENDAR_CUSTOM_DATE' => 'Aangepaste datum',
    'LBL_CALENDAR_REPEAT_TYPE' => 'Herhaling Type',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'Herhaling aantal',
    'LBL_CALENDAR_REPEAT_DOW' => 'Herhaling op deze dagen per week',
    'LBL_CALENDAR_REPEAT_ON' => 'Herhaal op',
    'LBL_CALENDAR_REPEAT' => 'Herhalen',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'Herhalen tot',
    'LBL_CALENDAR_REPEAT_COUNT' => 'Aantal herhalingen',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'Selectie herhalen',
    'LBL_CALENDAR_REPEAT_DAYS' => 'Dag(en) van de maand',
    'LBL_CALENDAR_REPEAT_MONTH' => 'Maand(en) van het jaar',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'Ordinaal herhalen',
    'LBL_CALENDAR_REPEAT_UNIT' => 'Eenheid herhalen',
    'TPL_REPEAT_INTERVAL' => 'Elke {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'Deze serie maakt gebruik van een optie Herhalen op die niet beschikbaar is in Sugar omdat de serie is gesynchroniseerd vanuit een agendaclient. Bewerk deze serie in uw agendaclient als u deze op een specifieke datum wilt blijven herhalen. Als u deze serie in Sugar bewerkt, wordt Herhalen op ingesteld als Niet.<br><br>Wilt u doorgaan?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'Aanpassingen kunnen alleen worden uitgevoerd op het eerste record van de serie.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'Herhalingsregels leiden niet tot het genereren van een evenement.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'Aanwezig',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'Afgewezen',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'Onder voorbehoud',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'Geen antwoord',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'Agenda niet beschikbaar',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'Beschikbare weergaves',
    'LBL_CALENDAR_DASHLET_NAME' => 'Agendaplanner',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'Standaard weergave',
    'LBL_CALENDAR_MY_CALENDARS' => 'Mijn agenda&#39;s',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'Gebruikers- en teamagenda&#39;s',
    'LBL_CALENDAR' => 'Agenda',

    'LBL_CALENDAR_DAY' => 'dag',
    'LBL_CALENDAR_WEEK' => 'week',
    'LBL_CALENDAR_MONTH' => 'maand',
    'LBL_CALENDAR_YEAR' => 'jaar',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18de',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98ste',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99ste',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'Error occurred while retrieving schedule.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'Bewaar en verstuur uitnodiging(en)',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'Acceptatiestatus',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'Processen',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'Het Processen dashlet toont de templates voor het gebruik in SugarBPM.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'Procesdefinities',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'Het Procesdefinities dashlet toont de templates voor het gebruik in SugarBPM.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'Nieuwe Process Definitie',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'Import Process Definities',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'Proces bedrijfsregels',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'Het Procesbedrijfsregels dashlet toont de templates voor het gebruik in SugarBPM.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'Nieuwe Process Business Rule',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'Import Process Business Rules',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'Process E-mail Templates',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'Het Procese-mailtemplates dashlet toont de templates voor het gebruik in SugarBPM.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'Nieuw Process E-mail Template',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'Import Process E-mail Templates',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'When developing processes/business rules/email templates in another instance of Sugar, we strongly recommend that the instance is an exact clone of your production system. Processes/business rules/email templates built in an independent instance of Sugar may not function as desired after importing completes. Processes/business rules/email templates may rely on specific Studio or application-level changes including but not limited to custom field names, dropdown values, database IDs, etc. If these values are not identical from the instance where the process/business rule/email template was built, you may need to manually rebuild the process/business rule/email template in your target instance.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'Would you still like to proceed with this import?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'Would you still like to proceed with this export?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'De volgende vervolgkeuzevelden bevatten ongeldige opties',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'Wachtend op Activiteiten per Process',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'Wachtend op Activiteiten',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'Wachtend op Activiteiten per Process',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'All Processes',
    'LBL_RECORD_DASHBOARD' => 'Record dashboard',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'Process Status Summary',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'Process Status Description',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'In Progress',
    'LBL_PMSE_COMPLETED_STATUS' => 'Completed',
    'LBL_PMSE_CANCELLED_STATUS' => 'Cancelled',
    'LBL_PMSE_TERMINATED_STATUS' => 'Terminated',
    'LBL_PMSE_ERROR_STATUS' => 'Error',
    'LBL_PMSE_SETTINGS' => 'Instellingen SugarBPM',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'Are you sure you want to disable this record?',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'Are you sure you want to enable this record?',
    'LBL_PRO_DELETE_CONFIRMATION' => 'Are you sure you want to delete this record?',

    'LBL_PRO_ENABLE' => 'Updating',
    'LBL_PRO_DISABLE' => 'Updating',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} neemt deel aan een proces en kan enkele vergrendelde velden bevatten. Klik hier {{link}} om dit record te bewerken.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'Dit veld is vergrendeld omdat het is betrokken bij een lopend proces.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'Dit record is betrokken bij een proces en kan vergrendelde velden bevatten.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'Zakelijk centrum',
    'LBL_BUSINESS_CENTER_ID' => 'ID zakelijk centrum',
    'LBL_BUSINESS_CENTER_NAME' => 'Naam zakelijk centrum',

    'LBL_PLIS_ACTIVITIES' => 'Activiteiten aangeschafte regelitems',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(New Tag)',
    'LBL_TAG_FETCH_ERROR' => 'An error has occurred while retrieving tags.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'SugarCRM requires javascript. Please enable javascript to continue using SugarCRM.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'Serienummers van gegevens konden niet ongedaan worden gemaakt',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'Serienummers van gegevens konden niet ongedaan worden gemaakt omdat deze verwijzingen bevatten naar objecten of klassen',

    'LBL_FIELD_TRIMMED' => 'Veld was uitgedund door overschrijding van het maximale aantal tekens.',
    'LBL_FIELDSIZE_OVERFLOW' => 'Veld overschrijdt maximaal aantal tekens.',
    'LBL_TINYMCE_TARGET_SAME' => 'Zelfde venster',
    'LBL_TINYMCE_TARGET_NEW' => 'Nieuw venster',

    'LBL_OUTBOUND_EMAILS' => 'E-mailinstellingen',
    'LBL_OUTBOUND_EMAIL' => 'E-mailinstelling',

    'LBL_EMAIL_PARTICIPANTS' => 'E-maildeelnemers',
    'LBL_EMAIL_PARTICIPANT' => 'E-maildeelnemer',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'Gegevensprivacy',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'Gegevensprivacy',
    'LBL_DATAPRIVACY_VIEW_PII' => 'Persoonsgegevens bekijken',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'Markeren voor wissen',
    'LBL_DATAPRIVACY_FIELDNAME' => 'Veld',
    'LBL_DATAPRIVACY_VALUE' => 'Waarde',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'Gewijzigd door',
    'LBL_DATAPRIVACY_SOURCE' => 'Bron',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'Laatst bijwijzigd',
    'LBL_DATAPRIVACY_PII' => 'Persoonsgegevens',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'Markeren voor wissen',
    'TPL_DATAPRIVACY_PII_TITLE' => 'Persoonsgegevens voor {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'Timers veranderen',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'Berichten',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'Naar uw klembord gekopieerd!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'Kon niet naar uw klembord kopiëren',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'Link kopieerbevestiging',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'Tijdlijn',
    'LBL_NO_ACTIVITY' => 'Geen activiteit',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => 'Tijdlijn {{moduleSingular}}',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'Meer',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'Minder',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'Op de tijdlijn worden de gerelateerde records van de huidige record weergegeven en worden veldupdates in de loop van de tijd geselecteerd.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'Toon meer...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'Toon minder...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'Geen gegevens beschikbaar',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'Module bevat geen licentie.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'Actieve abonnementen',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'De dashlet kan alleen worden toegevoegd voor modules die gekoppeld zijn aan één enkel account. Raadpleeg de documentatie van de <a href={{linkToDocumentation}}>dashlet Actieve abonnemente</a> voor meer informatie.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'Aankopen tonen die tot dit gekoppelde account toebehoren:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'Actieve abonnementen voor een specifiek account.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', hoeveelheid {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'Totaal:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'Geen actieve abonnementen',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'Voor deze dashlet moet {{module_name}} functioneren. Praat met uw beheerder over het inschakelen van {{module_name}}.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'Aankoopgeschiedenis',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'Alle aankopen voor een specifiek account.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'Deze dashlet kan alleen worden toegevoegd aan modules die naar één enkel account koppelen. Raadpleeg de documentatie van de <a href={{linkToDocumentation}} target="_blank">dashlet Aankoopgeschiedenis</a> voor meer informatie.',
    'LBL_NO_PURCHASE_HISTORY' => 'Geen weer te geven aankopen',
    'LBL_NO_PLIS' => 'Geen aangeschafte regelitems',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'Totaal',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'Hoeveelheid',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'Deze dashlet heeft Aankopen en Aangeschafte regelitems nodig om te functioneren. Raadpleeg uw beheerder voor het inschakelen van Aankopen en Aangeschafte regelitems.',
    'LBL_SEARCH_PURCHASE_NAME' => 'Zoeken op Naam aankoop...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'Gebruik Studio om de lay-out van de dashlet weergave van het record te bewerken door te gaan naar ' .
        'Studio > {{module}} > Layouts > Recordweergave dashlet. <a href={{linkToStudio}}>Bewerken in Studio</a>.',
    'LBL_SERVICE_LEVEL' => 'Serviceniveau',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'Nummer',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'Opvolging',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'Prioriteit/Status',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'Onderwerp/Beschrijving',

//Service Duration
    'LBL_SERVICE_DURATION' => 'Onderhoudsduur',
    'LBL_SERVICE_DURATION_VALUE' => 'Waarde onderhoudsduur',
    'LBL_SERVICE_DURATION_UNIT' => 'Eenheid onderhoudsduur',
    'LBL_LOCK_DURATION' => 'Vergrendelingsduur',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'De Amazon Connect CCP kon niet laden.' .
        'zorg ervoor dat u een ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">ondersteunde browser</a>. ' .
        'Neem contact op met uw Sugar-beheerder als dit probleem aanhoudt.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Uw Sugar-beheerder heeft uw exemplaar niet geconfigureerd voor Amazon Connect.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Kon geen verbinding maken met Amazon Connect. Neem contact op met uw Sugar-beheerder voor hulp.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'Onbekend',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'Focus drawer',
    'LBL_CLOSE_FOCUS_DRAWER' => 'Focus drawer sluiten',
    'LBL_EXTERNAL_GUESTS' => 'Externe gasten',
    'LBL_MY_FAVORITE_TASKS' => 'Mijn favoriete taken',
    'LBL_RECORD' => 'Record',

    'LBL_MY_TASKS' => 'Mijn taken',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'Kon veld {0} niet vinden in module: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'Kon geen record vinden met {0}: {1} in module: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'Kon geen relatie vinden met de naam: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'Een database-invoer met Id: {0}, met {1}: {2} in module: {3} bestaat reeds',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'zacht verwijderd (met verwijderde vlag = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'Meerdere databaserecords gevonden voor {0} {1} in module {2}. ' .
        'Verwijder de bijbehorende records of werk deze bij. Bijbehorende records: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'Volgende uitvoer',
    'LBL_TIME_AWARE_TYPE' => 'Type',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean-ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'Weergavelabel',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'Recordweergave openen',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'Toevoegen',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'Hulp niet beschikbaar',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'Functies',
    'LBL_ACTIONBUTTON_FIELDS' => 'Velden',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'Selecteer veld...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Samenstellen',
    'LBL_ACTIONBUTTON_RELATED' => 'Gerelateerd',
    'LBL_ACTIONBUTTON_SAVE' => 'Opslaan',
    'LBL_ACTIONBUTTON_CANCEL' => 'Annuleren',
    'LBL_ACTIONBUTTON_R_MODULE' => 'Related Module',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'Soortgelijke velden',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'Roll-upmodule',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'Roll-upvelden',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'Roll-upfunctie',
    'LBL_ACTIONBUTTON_MINIMUM' => 'Min',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'Max',
    'LBL_ACTIONBUTTON_AVERAGE' => 'Gemiddeld',
    'LBL_ACTIONBUTTON_SUM' => 'Som',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'Record toewijzen',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'E-mail opstellen',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'Record aanmaken',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Doc samenvoegen',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'URL openen',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'Rapport uitvoeren',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'Record bijwerken',
    'LBL_ACTIONBUTTON_ACTION' => 'Actie',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'Toewijzen aan',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'E-mail aan',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'PMSE gebruiken',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'Sjabloon',
    'LBL_ACTIONBUTTON_MODULE' => 'Module',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'Weergave-instellingen',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'Type',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'Vervolgkeuze',
    'LBL_ACTIONBUTTON_BUTTON' => 'Knop',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'Knopgroep',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'Label weergeven in record',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'Weergeven in kop',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'Verbergen bij bewerken',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'Weergave op koptekst focusdashboard',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'Dashboard',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'Koptekst focusdashboard',
    'LBL_ACTIONBUTTON_SIZE' => 'Formaat',
    'LBL_ACTIONBUTTON_DEFAULT' => 'Standaard',
    'LBL_ACTIONBUTTON_SMALL' => 'Klein',
    'LBL_ACTIONBUTTON_LARGE' => 'Groot',
    'LBL_ACTIONBUTTON_CALCULATED' => 'Berekend',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'Converteren naar pdf',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Doc samenvoegen',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'Voorvertoning',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'Eigenschappen',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'Label',
    'LBL_ACTIONBUTTON_DESC' => 'Tooltip',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'Label tonen',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'Pictogram tonen',
    'LBL_ACTIONBUTTON_SCHEME' => 'Kleurschema',
    'LBL_ACTIONBUTTON_ICON' => 'Pictogram',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'Afhankelijk',
    'LBL_ACTIONBUTTON_DESIGN' => 'Configuratie layout',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'Stoppen bij fout',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'Automatisch opslaan',
    'LBL_ACTIONBUTTON_CONFIG' => 'Config',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'Configureer uw actieknop voordat u opslaat.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'Knoppen configureren',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'Automatisch aanmaken',
    'LBL_ACTIONBUTTON_LINK' => 'Relatie met bovenliggend maken',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'Bovenliggende waarden kopiëren',
    'LBL_ACTIONBUTTON_PRESET' => 'Veldwaarde(n) instellen',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'Veldwaarde(n) kopiëren van bovenliggend',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'Kies...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'Van bovenliggend veld ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'Weet u zeker dat u deze knop wilt verwijderen?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'Weet u zeker dat u deze actie wilt verwijderen?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'Ongeldige gegevens actieknop',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'Selecteer een module voordat u opslaat.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'Selecteer een koppeling voordat u opslaat. Als er geen koppeling beschikbaar is, deselecteert u de koppelingsoptie.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'Selecteer een record voordat u opslaat.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'Selecteer een sjabloon voordat u opslaat.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'Primair',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'Secundair',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HogeZichtb',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'Oceaan',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'Roze',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'Leger',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'Beige',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'Zee',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'Groen',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'Geel',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'Oranje',
    'LBL_ACTIONBUTTON_THEME_RED' => 'Rood',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'Koraal',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'Paars',
    'LBL_ACTIONBUTTON_FORMULA' => 'Formule',
    'LBL_ACTIONBUTTON_ACTIONS' => 'Acties',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'Fout tijdens valideren knopgegevens.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'Knoppen moeten minimaal een label of pictogramset bevatten.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'Voer een geldig label voor de knop in.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'De record kon niet worden aangemaakt vanwege ontbrekende verplichte waarden. Neem contact op met uw beheerder.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'U moet minimaal twee actieve knoppen hebben voor dit type knop.',
    'LBL_ACTIONBUTTON_RECORD' => 'Recordweergaves',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'Actiemenu&#39;s',
    'LBL_ACTIONBUTTON_ORDER' => 'Order',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'Lijstweergave',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'Koptekst recordweergave',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'Koptekst recordweergave dashlet',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'Subpanelen',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'De engine voor de uitvoering van de taakvolgorde heeft de volgende acties niet kunnen uitvoeren: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'Voeg een actie toe',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'Verwijder deze actie',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'Huidige gebruiker',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'Doc samenvoegen',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'Doc samenvoegen naar pdf',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'Bedrijfsgrootte',
    'LBL_HINT_COMPANY_INDUSTRY' => 'Industrie',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'Industrietags',
    'LBL_HINT_COMPANY_LOCATION' => 'Bedrijfslocatie',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'Beschrijving bedrijf',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'Jaar opgericht',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Facebook bedrijf',
    'LBL_HINT_COMPANY_TWITTER' => 'Twitter bedrijf',
    'LBL_HINT_COMPANY_PIC' => 'Bedrijfslogo',
    'LBL_HINT_CONTACT_PIC' => 'Foto contactpersoon',
    'LBL_HINT_COMPANY_WEBSITE' => 'Bedrijfswebsite',
    'LBL_HINT_PHOTO' => 'Link foto',
    'LBL_HINT_JOB_2' => 'Vorige baan',
    'LBL_HINT_EDUCATION' => 'Opleiding',
    'LBL_HINT_EDUCATION_2' => 'Aanvullende opleiding',
    'LBL_HINT_TWITTER' => 'Link Twitter',
    'LBL_HINT_FACEBOOK' => 'Link Facebook',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS code',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC code',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'Einde FY',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'Jaaromzet',
    'LBL_HINT_PHONE_1' => 'Tel. 1',
    'LBL_HINT_PHONE_2' => 'Tel. 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'Tabel samenvoegen',
    'LBL_HINT_FULL_NAME' => 'Volledige naam',
    'LBL_HINT_JOB_TITLE' => 'Naam functie',
    'LBL_HINT_OFFICE_PHONE' => 'Telefoon (werk)',
    'LBL_HINT_MOBILE_PHONE' => 'Mobiel',
    'LBL_HINT_OTHER_PHONE' => 'Andere tel.',
    'LBL_HINT_WEBSITE' => 'Website',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'Wilt u alle bestaande gegevens van dit record overschrijven door de nieuwe gegevens die in Sugar Hint zijn gevonden?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'Wilt u de bestaande {{fieldName}} van deze record overschrijven door de nieuwe {{fieldName}}, gevonden in Sugar Hint?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'Alle accountgerelateerde gegevens worden verwijderd. Weet u zeker dat u wilt doorgaan ?',
    'LBL_HINT_COMPANY_LOGO' => 'Beeldmerk',
    'LBL_HINT_CONTACTS_AVATAR' => 'Foto',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint accountsets tags',

    'LBL_HINT_LOADING' => 'Laden ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Sugar Hint deïnstalleren, een ogenblik',
    'LBL_HINT_VALUE_ERASED' => ' Waarde gewist ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'Deze informatie werd gewist via gegevensaanvraag privacy',

    'LBL_HINT_UNINSTALL_TITLE' => 'Selecteer een van de deïnstallatiemogelijkheden hieronder:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Alleen Hint-pakket deïnstalleren',
    'LBL_HINT_UNINSTALL_FULL' => 'Hint compleet deïnstalleren',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'Met deze optie wordt de Hint MLP verwijderd en alle actieve abonnementen op Sugar Hint Insights.
    Herinstallatie van Hint heractiveert automatisch abonnementen.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'Deze optie voert een volledige deïnstallatie uit van Hint, waaronder verwijdering van de MLP en verwijdering van alle configuratie- en abonnementsgegevens.',
    'LBL_HINT_UNINSTALL' => 'De-installeer',
    'LBL_HINT_UNINSTALL_HEADER' => 'Deïnstalleer Sugar Hint',
    'LBL_HINT_CANCEL' => 'Annuleren',
    'LBL_HINT_UNINSTALL_WARNING1' => 'WAARSCHUWING: Kies deze optie alleen als u Hint in de toekomst niet meer wilt gebruiken.
    Voordat u deïnstalleert, voert u een volledige back-up uit van uw Sugar-database en zet u Sugar in onderhoudsmodus. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'Zie de ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint-Administratiegids ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'voor informatie over het deïnstallatieproces.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Weet u zeker dat u alleen het Sugar Hint-pakket wilt deïnstalleren?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Weet u zeker dat u Sugar Hint in zijn geheel wilt deïnstalleren?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(LET OP: U KUNT DIT NIET ONGEDAAN MAKEN)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint velden',
    'LBL_HINT_NO_RESULTS_MSG' => 'Geen resultaten gevonden.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'Basis Hint-paneelindeling',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'Accounts',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'Contactpersonen',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'Leads',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'Uitgebreide Hint-paneelindeling',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'Deel de velden opnieuw in door ze hierboven te slepen naar de Hint-paneelindeling.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'Voor meer instructies en een lijst met standaardvelden raadpleegt u de ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' om de standaardinstellingen terug te zetten ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'van de module.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'Weet u zeker dat u de standaardwaarden van de module {{mmodule}} terug wilt zetten?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'Klik hier',
    'LBL_HINT_CONFIG_NAME' => 'Hint-Administratiegids.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'Velden',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'Verrijkte velden',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'In dit deel staan alle Hint-velden en de Sugar-velden die zijn verrijkt door Hint. Hint-velden zijn gemarkeerd met een sterretje (*) en kunnen alleen in het Hint-paneel worden getoond als ze verrijkt zijn.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'Veldnaam',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'Veld verrijken',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Tonen in Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Tonen in Hint-paneel',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'Aanvullende Sugar-velden',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'In dit deel staan alle Sugar-velden die niet zijn verrijkt door Hint.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'Waarschuwing',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'Let op: U staat op het punt te synchroniseren met de Sugar Hint Insights-service. Eventuele in behandeling zijn de samenvattingen via e-mail gaan verloren en bestaad nieuws wordt uit de Insights-dashlet verwijderd. Meldingen van alle soorten worden hervat nadat de synchronisatie is voltooid.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'Voorgestelde bedrijven die betrekking hebben op uw {{_moduleSingular}} staan hieronder. Selecteer weer te geven bedrijfsgegevens.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'Er is geen account geselecteerd',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'Meerdere e-mails gevonden, selecteer te importeren e-mails: ',

    'LBL_HINT_HELP_MESSAGE1' => 'Op basis van de ingevoerde gegevens kon Hint geen overeenkomst vinden in het systeem.',
    'LBL_HINT_HELP_MESSAGE2' => 'De beste resultaten in Hint kunnen worden gevonden met de naam en het e-mailadres van een persoon.',
    'LBL_HINT_HELP_MESSAGE3' => 'De beste resultaten in Hint kunnen worden gevonden met de Url van de bedrijfswebsite.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "Voer de bedrijfsnaam van uw {{_moduleSingular}} in, dan zal Hint zoeken naar aanvullende gegevens.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "Voer het e-mailadres van uw {{currentModule}} in, dan zal Hint zoeken naar aanvullende gegevens.",

    'LBL_HINT_HISTORY_NONE' => 'Geen gegevens beschikbaar voor historische weergave',
    'LBL_HINT_HISTORY_TITLE' => 'Activiteitgeschiedenis',

    'LBL_HINT_PREVIEW_TITLE' => 'Gegevensverrijking',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'De licentie voor uw SugarCRM Hint-service is verlopen. Neem contact op met uw SugarCRM-beheerder om uw licentie te verlengen.',
    'LBL_HINT_PREVIEW_QUESTION' => 'Wilt u zien wat SugarCRM Hint kan doen voor u en uw bedrijf? Neem contact op met uw SugarCRM-beheer om Hint toe te voegen.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'Accountgegevens niet gevonden',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'Verrijkte gegevens gevonden - klik om alle verrijkte gegevens op te slaan in uw record.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'Klik om verrijkte gegevens op te slaan in uw record.',

    'LBL_HINT_CONTACTS_TITLE' => 'Gerelateerde Contactpersonen',
    'LBL_HINT_CONTACTS_NONE' => 'Geen gerelateerde Contactpersonen',

    'LBL_HINT_NEWS' => 'Nieuws',
    'LBL_HINT_GENERAL' => 'Algemeen',
    'LBL_HINT_ALL_NEWS' => 'Alle Nieuws',
    'LBL_HINT_FILTER_NEWS' => 'Nieuws filteren',
    'LBL_HINT_FINANCIAL_NEWS' => 'Financieel',
    'LBL_HINT_PERSONNEL_NEWS' => 'Personeel',
    'LBL_HINT_PRESS_RELEASES' => 'Persberichten',
    'LBL_HINT_OTHER_NEWS' => 'Anders',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'Nieuwsartikelen zoeken',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'Geen nieuws beschikbaar',
    'LBL_NEW_NOTIFICATIONS' => 'Nieuwe meldingen',
    'LBL_HINT_DASHLET_ALLOWED1' => 'U hebt een Sugar Hint-licentie nodig om de Sugar Hint Insights dashlet te bekijken.
    Vraag uw beheerder naar een Sugar Hint-licentie.',

    'LBL_HINT_FOR' => 'Voor',
    'LBL_HINT_WITH' => 'met',
    'LBL_HINT_SHOW_ME' => 'Toon me: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'Licht me in door: ',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insights Voorkeurencentrum',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'Voorkeur-optietoets',
    'LBL_HINT_PREFERENCES' => 'Voorkeuren',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'Uitgeschakeld verwijderen, minimaal één voorkeursverklaring vereist',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'Uitgeschakeld toevoegen, u hebt het maximumaantal voorkeursverklaringen bereikt',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Opnemen in Sugar Hint Insights dashlet',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'Pop-up als desktopmelding',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'Meldingen moeten zijn ingeschakeld in alle browsers en op alle desktopcomputers om consistent meldingen te ontvangen.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Bepaalde browsers, zoals Internet Explorer, ondersteunen meldingen niet. Meldingen kunnen niet worden ingeschakeld als u een browser gebriukt die geen meldingen ondersteunt.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'Onmiddellijk e-mailmelding sturen voor elke melding',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'Een dagelijkse samenvatting sturen per e-mail',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'Een wekelijkse samenvatting sturen per e-mail',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'Voorkeuren konden niet worden opgeslagen. Controleer uw systeemverbinding en probeer het opnieuw.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'In bepaalde verplichte velden ontbreekt een waarde. Controleer uw voorkeuren en contrroleer of alle verplichte velden zijn ingevuld.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'U staat op het punt browsermeldingen in te schakelen voor Sugar Hint Insights. Klik op Bevestigen om door te gaan. Uw browser vraagt u vervolgens om toestemming voor het ontvangen van meldingen.',
    'LBL_HINT_PUSH_ERROR' => 'De plug-in Pusmeldingen is geregistreerd voor {{options.type}} zonder afhankelijkheden. De plug-in werkt niet zoals bedoeld. Controleer of u een pad naar het werkbestand hebt opgegeven en een methode voor het opslaan van het abonnement op de server.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'Schakel Hint-meldingen IN voor alle gebruikers',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'Schakel Hint-meldingen UIT voor alle gebruikers',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'WAARSCHUWING: Meldingen uitschakelen tijdens deïnstallatie van Sugar Hint mislukt. Om meldingen uit te schakelen, installeert u Sugar Hint 5.4.0 of hoger en voert u een volledige deïnstallatie uit d. m. v. de Sugar Hint Uninstaller, welke te vinden is in het deel Beheer van Sugar.',
    'LBL_HINT_ENRICH_ALL' => 'Alle verrijken',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'Licentie hint vereist',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'Configuratie Kaarten',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'Geocoder logviewer',
    'LBL_MAP_MAP' => 'Kaart',
    'LBL_MAP_MAPS' => 'Kaarten',
    'LBL_MAP_GEOCODING_RECORD' => 'Geocodering',
    'LBL_MAP_GEOCODE_SUCCESS' => 'Geocodering record succesvol verlopen.',
    'LBL_MAP_LATITUDE' => 'Lengtegraad',
    'LBL_MAP_LONGITUDE' => 'Breedtegraad',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'Zoeken op adres...',
    'LBL_MAP_ALREADY_GEOCODED' => 'Gecodering huidige record reeds voltooid. Weet u zeker dat u de geocodering van deze record wilt overschrijven?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'Handmatige geocodering',
    'LBL_MAP_POINT_COORDINATES' => 'Coördinaten kaartpunt',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'De optimale route berekenen...',
    'LBL_MAP_DIRECTIONS' => 'Richtingen',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'Richtingen, beginnend vanaf huidige gebruiker',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'Richtingen, beginnend vanaf deze record',
    'LBL_MAPS_RADIUS_INPUT' => 'Straal (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'In een straal van postcode',
    'LBL_MAPS_DISTANCE' => 'Afstand',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'Postcode',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'Ongeldige config.: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> veldtoewijzingen is ongeldig.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'Type kaart',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'Zoomniveau',
    'LBL_MAPS_DASHLET' => 'Kaarten',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'Geeft record(s) met geocodering aan op kaart.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'Kaaarten is niet beschikbaar voor deze module. Schakel het in het Beheerconsole in.',
    'LBL_MAP_MODULES' => 'Module',
    'LBL_MAP_FILTER_BY' => 'Filter op',
    'LBL_MAP_UNIT_TYPE' => 'Type eenheid',
    'LBL_MAP_UNIT_TYPE_MILES' => 'Mijl',
    'LBL_MAP_UNIT_TYPE_KM' => 'Kilometer',
    'LBL_MAP_ADDRESS' => 'Adres',
    'LBL_MAP_NO_STARTING_POINT' => 'Startpunt bevat geen geocodering.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'Record startpunt bevat geen geocodering.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'Bepaalde geselecteerde records bevatten geen geocodering en worden niet weergegeven op de kaart.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'Record(s) bevatten geen geocodering.',
    'LBL_MAPS_MODULE_FIELDS' => 'Modulevelden',
    'LBL_MAPS_SELECT_FIELD' => 'Selecteer veld',
    'LBL_MAPS_RELATE_RECORD' => 'Gerelateerde record',
    'LBL_MAPS_MAPPING_TYPE' => 'Type toewijzing',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'Geen records met geocodering',
    'LBL_MAPS_ADDRESS' => 'Adres',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'Toegewezen gebruiker',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'Straatweergave is niet beschikbaar voor opgegeven punt',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> records kunnen niet in kaart worden gebruikt. Verwijder de module uit de lijst.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'Sluiten',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'Uitklappen',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'Opslaan als PDF',
    'LBL_MAPS_EMAIL_LINK' => 'Link e-mailen',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'U moet minimaal één record met geocodering hebben.',
    'LBL_MAPS_GENERATING' => 'Kaart genereren...',
    'LBL_MAPS_POINTS' => 'Kaartpunten',
    'LBL_MAPS_POINT' => 'Punt',
    'LBL_MAPS_TRAVEL_DETAILS' => 'Reisgegevens',
    'LBL_MAPS_TOTAL_DISTANCE' => 'Totale afstand',
    'LBL_MAPS_TOTAL_DURATION' => 'Totale duur',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'Totale duur zonder verkeer',
    'LBL_MAPS_ITINERARY' => 'Reisgegevens',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'Reisafstand',
    'LBL_MAPS_TRAVEL_DURATION' => 'Reisduur',
    'LBL_MAPS_TRAVEL_STEPS' => 'Stappen',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'Waarschuwingen',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Maps ondersteunt maximaal 10 punten op een gedeelde kaart. Controleer uw selectie.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'Maps-licentie vereist',
    'LBL_MAPS_SHARE_HELLO' => 'Hallo,',
    'LBL_MAPS_SHARE_HEADER' => 'U hebt een Bingkaart opgevraagd voor de volgende punten:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'De volgende url opent een kaart met voornoemde punten op Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Kaart tonen op Bing Maps',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'Er is geen route gevonden voor de opgegeven waypoints.',
    'LBL_MAPS_GEOCODE_STATUS' => 'Status geocodering',
    'LBL_MAPS_GEOCODED' => 'Geocodering',
    'LBL_MAPS_NOT_GEOCODED' => 'Niet geocodeerd',
    'LBL_MAPS_NOT_FOUND' => 'Ongeldig adres',
    'LBL_MAPS_GEOCODING_FAILED' => 'Geocodering mislukt',
    'LBL_MAPS_QUEUED' => 'In wachtrij',
    'LBL_MAPS_REQUEUED' => 'Opnieuw in de wachtrij',
    'LBL_MAPS_RELATED_RECORD' => 'Gerelateerde record',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'Rapport bekijken',
    'LBL_REPORT_DASHLET_DESC' => 'Een opgeslagen rapport weergeven',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'Terugzetten naar Dashlet standaardwaarden',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'Terugzetten naar Dashlet standaardwaarden',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'Resultaten vernieuwen',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'Grafiek kopiëren naar klembord',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'Grafiek downloaden',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'Het rapport voor de dashlet {{label}} is bewerkt en de dashlet is teruggezet naar de standaardconfiguratie.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'U heeft geen rechten om dit veld te gebruiken.',

    'LBL_INVALID_FORMULA' => 'Ongeldige formule',
    'LBL_RETURN_TYPE_MISSMATCH' => 'Retourtype functie komt niet overeen',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'Voorspelling',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'Profiel ideale klant',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'Voorspellingsscores week sluiten',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'Voorspellingswaarde',
    'LBL_AI_CONV_BIN_ACCURACY' => 'Nauwkeurigheid voorspelling prullenbak',
    'LBL_AI_CONV_MULTIPLIER' => 'Vermenigvuldiging voorspelling',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP-waarde',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'Nauwkeurigheid ICP-prullenbak',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'Vermenigvuldiging ICP',
    'LBL_AI_NEW' => 'Nieuw',
    'LBL_AI_ENTERED' => 'Ingevoerd',
    'LBL_AI_CREATED' => 'Laatst geïmporteerd',
    'LBL_AI_WEEK' => 'Week',
    'LBL_AI_MONTH' => 'Maand',
    'LBL_AI_QUARTER' => 'Kwartaal',
    'LBL_AI_BYWEEK' => 'per week',
    'LBL_AI_BYMONTH' => 'per maand',
    'LBL_AI_BYQUARTER' => 'per kwartaal',
    'LBL_AI_WEEKTREND' => 'Wekelijkse trend',
    'LBL_AI_MONTHLYTREND' => 'Maandelijkse trend',
    'LBL_AI_QUARTERTREND' => 'Kwartaaltrend',
    'LBL_AI_TREND' => 'Trend door',
    'LBL_AI_TRENDS' => 'Trends door',
    'LBL_AI_VELOCITY' => 'Snelheid',
    'LBL_AI_TOPX' => 'Top {X}',
    'LBL_AI_TIMESPAN' => 'Tijdspanne tussen fasen -',
    'LBL_AI_BUSINESSTREND' => 'met zakelijke trends',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Maak kennis met Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights maakt gebruik van kwantitatieve analyse om nieuwe inzichten in uw SugarCRM-gegevens te genereren. Bij Sugar zijn we altijd op zoek naar nieuwe manieren om u te helpen het meeste uit uw gegevens te halen, weloverwogen beslissingen te nemen, en dit is nog maar het begin van wat we hopen te bieden met Sugar Insights.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights maakt gebruik van kwantitatieve analyse om nieuwe inzichten in uw SugarCRM-gegevens te genereren.',
    'LBL_AI_FIRMO' => 'Firmographics',
    'LBL_AI_TOTALCOUNT' => 'Totaal aantal',
    'LBL_AI_DAYSFROMLATESTACT' => 'Dagen sinds de laatste',
    'LBL_AI_DAYSSINCE' => 'leeftijd',
    'LBL_AI_FIELDISSET' => 'bestaat',
    'LBL_AI_CONTACTCOMPLETENESS' => 'Volledigheid contactgegevens',
    'LBL_AI_CUTDATE' => 'Voorspellingsperiode',
    'LBL_AI_FROMLASTCHANGE' => 'Dagen na de laatste wijziging van de functiewaarde',
    'LBL_AI_CALLSHELD' => 'Totaal aantal gehouden gesprekken',
    'LBL_AI_CALLSPLANNED' => 'Totaal aantal geplande gesprekken',
    'LBL_AI_OUTBOUNDCALLS' => 'Totaal aantal uitgaande gesprekken',
    'LBL_AI_INBOUNDCALLS' => 'Totaal aantal inkomende oproepen',
    'LBL_AI_AVGCALLDURATION' => 'Gemiddelde duur van de gesprekken',
    'LBL_AI_EMAILSARCHIVED' => 'Totaal aantal gearchiveerde e-mails',
    'LBL_AI_EMAILSREAD' => 'Totaal aantal gelezen e-mails',
    'LBL_AI_EMAILSSENT' => 'Totaal aantal verzonden e-mails',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'Totaal aantal records waarbij de verwachte sluitingsdatum is gewijzigd naar een latere datum',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'Totaal aantal records waarbij de verwachte sluitingsdatum is gewijzigd in een eerdere datum',
    'LBL_AI_AMOUNTINCREASED' => 'Totaal aantal mogelijkheden waarin het bedrag is toegenomen',
    'LBL_AI_AMOUNTDECREASED' => 'Totaal aantal mogelijkheden waarin het bedrag is afgenomen',

    // User last state
    'LBL_LAST_STATE' => 'Laatste status',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'Stuur naar DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'Bewerken ontvanger annuleren',
    'LBL_RECIPIENT_ROLE' => 'Rol ontvanger',
    // Base sales stages
    'LBL_OPEN' => 'Openen',
    'LBL_CLOSED_WON' => 'Afgesloten, gewonnen',
    'LBL_CLOSED_LOST' => 'Afgesloten, verloren',
    'LBL_KIOSK_ADD_FILES' => 'Bestanden toevoegen',
    'LBL_KIOSK_ADD_DROP_FILES' => 'Voeg hier bestanden toe of sleep ze hier naartoe',
    'LBL_KIOSK_CANCEL' => 'Annuleren',
    'LBL_KIOSK_EDIT' => 'Wijzigen',
    'LBL_KIOSK_EMAIL' => 'E-mailadres',
    'LBL_KIOSK_FILES_UPLOADING' => 'Uploaden',
    'LBL_KIOSK_FILES_ERROR' => 'Bijlage toevoegen is mislukt',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'Bijlage is te groot',
    'LBL_KIOSK_FILTER_SEARCH' => 'Zoeken',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'Kiosk',
    'LBL_KIOSK_LANGUAGE' => 'Taal',
    'LBL_KIOSK_LAST_UPDATED' => 'Laatst bijgewerkt op',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'Bekijken',
    'LBL_KIOSK_MENU' => 'Menu',
    'LBL_KIOSK_MOBILE_PHONE' => 'Mobiele telefoon',
    'LBL_KIOSK_MY_ACTIVITIES' => 'Mijn activiteiten',
    'LBL_KIOSK_MY_PROFILE' => 'Mijn profiel',
    'LBL_KIOSK_NAME' => 'Naam',
    'LBL_KIOSK_OFFICE_PHONE' => 'Telefoon kantoor',
    'LBL_KIOSK_ORGANIZATION' => 'Organisatie',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'Rijen per pagina:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'Aangedreven door SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'Wijzigingen opslaan',
    'LBL_KIOSK_SHOW_HIDE' => 'Tonen/verbergen',
    'LBL_KIOSK_SIGN_IN' => 'Aanmelden',
    'LBL_KIOSK_SIGN_OUT' => 'Afmelden',
    'LBL_KIOSK_SORT_BY' => 'Sorteren op',
    'LBL_KIOSK_SUBMIT' => 'Verzenden',
    'LBL_KIOSK_TIMEZONE' => 'Tijdszone',
    'LBL_KIOSK_ACTIVITY' => 'Activiteit',
    'LBL_KIOSK_NO_ACTIVITY' => 'Geen activiteit om weer te geven',
    'LBL_KIOSK_OLDEST_FIRST' => 'Oudste eerst',
    'LBL_KIOSK_NEWEST_FIRST' => 'Nieuwste eerst',
    'LBL_KIOSK_SHOW_MORE' => 'Toon meer',
    'LBL_KIOSK_ADD_A_REPLY' => 'Voeg een antwoord toe',
    'LBL_KIOSK_REPLY_EMPTY' => 'Antwoord kan niet leeg worden gelaten.',
    'LBL_KIOSK_NUM_MORE' => 'nog {{num}}',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'Welkom',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'Krijg snel toegang tot uw bronnen.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'Zoek cases',
    'LBL_KIOSK_SHOW_ALL' => 'Alles weergeven',
    'LBL_KIOSK_404_TITLE' => 'Het is niet gelukt deze te vinden',
    'LBL_KIOSK_TENANT_404_TITLE' => 'Onderliggend niet gevonden',
    'LBL_KIOSK_404_MESSAGE' => 'U hebt op een link geklikt die verwijderd of tijdelijk niet beschikbaar is, of u heeft een ongeldige URL ingevoerd.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'Zorg ervoor dat u de juiste URL heeft. Neem voor verdere hulp contact op met de ondersteuning.',
    'LBL_KIOSK_BACK_TO_HOME' => 'Terug naar startpagina',
    'LBL_KIOSK_ERROR_CODE' => '{code} Fout: ',
    'LBL_KIOSK_401_TITLE' => 'Niet geautoriseerd',
    'LBL_KIOSK_401_MESSAGE' => 'U bent niet bevoegd om deze pagina te bekijken.',
    'LBL_KIOSK_403_TITLE' => 'Niet geautoriseerd',
    'LBL_KIOSK_403_MESSAGE' => 'U heeft geen toegang om deze pagina te bekijken.',
    'LBL_KIOSK_500_TITLE' => 'Server reageert niet',
    'LBL_KIOSK_500_MESSAGE' => 'Er is iets misgegaan aan onze kant.',
    'LBL_KIOSK_GO_BACK' => 'Ga terug',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'Dubbele record gevonden',
    'LBL_KIOSK_ACCOUNT' => 'Account',
    'LBL_KIOSK_STATUS' => 'Status',
    'LBL_KIOSK_DEACTIVATE' => 'Uitschakelen',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'Gebruiker is gedeactiveerd',
    'LBL_KIOSK_MANAGE_USERS' => 'Gebruikers beheren',
    'LBL_KIOSK_LAST_LOGIN' => 'Laatste login',
    'LBL_KIOSK_FIRST_NAME' => 'Voornaam',
    'LBL_KIOSK_LAST_NAME' => 'Achternaam',
    'LBL_KIOSK_ROLE' => 'Rol',
    'LBL_KIOSK_INVITE' => 'Uitnodigen',
    'LBL_KIOSK_SEND_INVITES' => 'Uitnodiging(en) verzenden',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'Uitnodiging(en) succesvol verzonden',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'Uitnodiging(en) niet verzonden',
    'LBL_KIOSK_REACTIVATE' => 'Opnieuw activeren',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'Gebruiker is opnieuw geactiveerd',
    'LBL_KIOSK_RESET_PASSWORD' => 'Reset Wachtwoord',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'E-mail met wachtwoord opnieuw instellen verzonden',
    'LBL_KIOSK_USER_PROFILE' => 'Gebruikersprofiel',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'Uw gebruiker is gedeactiveerd. Neem contact op met uw beheerder.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'Terug naar login',
    'LBL_KIOSK_REVOKE_INVITATION' => 'Uitnodiging intrekken',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'Uitnodiging ingetrokken',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'Zoeken en selecteren...',
    'LBL_KIOSK_NO_MATCHES' => 'Geen overeenkomsten gevonden',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'Profiel is bijgewerkt.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'Fout tijdens bijwerken profiel.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'Onderwerp: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'Documenten',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'Bekijk, zoek en download uw inkomende gedeelde documenten.',
    'LBL_KIOSK_CASES' => 'Cases',
    'LBL_KIOSK_CASES_DESC' => 'Bekijk, zoek en beantwoord cases die met u zijn gedeeld.',
    'LBL_KIOSK_DOWNLOAD' => 'Downloaden',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'Bestand succesvol gedownload',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'Aan de slag',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'Om u beter van dienst te kunnen zijn, verzoeken wij u uw voor- en achternaam door te geven.',
    'LBL_KIOSK_SAVE' => 'Opslaan',
    'LBL_KIOSK_SHARED' => 'Gedeeld',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'Welkom {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'Achtergrondkleur',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'URL van achtergrondafbeelding',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'Het wordt aanbevolen om een afbeelding te kiezen met een bestandsgrootte van minder dan 400K.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'Type achtergrond',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'Startachtergrond',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'Thema',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'Primaire themakleur',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'Naam app',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'Dit is de titel van uw aanvraag en deze wordt naast uw logo weergegeven.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'URL applogo',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'Het wordt aanbevolen om een logo te kiezen dat het beste zichtbaar is in kleine formaten (bijv. profielen op sociale media). Het wordt ook aanbevolen om een bestandsgrootte van minder dan 200K te hebben.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'URL Favicon-app',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'Een favicon is een klein logo dat naast de paginatitel in een browsertabblad verschijnt.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'Automatisch open activiteiten toewijzen',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'Gebruikerslimiet bereikt',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'Ongeldige licentiesleutel',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'Ongeldige toepassing',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'Ongeldige toepassing',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'Beschadigde validatiesleutel',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'Licentie verlopen',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'Ontbrekende informatie',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'Ontbrekende validatiesleutel',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'Gebruiker zonder toegang',
    'LBL_DRI_WORKFLOW' => 'Slimme gids',
    'LBL_DRI_WORKFLOWS' => 'Slimme gidsen',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Fasensjabloon voor slimme gidsen',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Fasensjablonen voor slimme gidsen',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Slimme gids-sjabloon',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Activiteitssjabloon voor slimme gidsen',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'Activiteitssjablonen',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'Webhooks',
    'LBL_CJ_WEBHOOKS' => 'Webhooks van Sugar Automate',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'Huidige slimme gids-activiteit op',
    'LBL_CJ_WEBHOOKS' => 'Webhooks van Sugar Automate',
    'LBL_CJ_WEBHOOK' => 'Webhook van Sugar Automate',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar-acties',
    'LBL_CJ_FORMS' => 'Acties Sugar Smart Guide',
    'LBL_CJ_FORM' => 'Actie Sugar Smart Guide',
    'LBL_DRI_SUBWORKFLOW' => 'Slimme gids-fase',
    'LBL_DRI_SUBWORKFLOWS' => 'Slimme gids-fasen',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Activiteitensjablonen voor slimme gids',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Slimme gids-sjablonen',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Slimme gids-volgorde',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Actuele volgorde van slimme gids',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Slimme gids-score',
    'LBL_CJ_MOMENTUM_POINTS' => 'Momentumpunten van slimme gids',
    'LBL_CJ_MOMENTUM_SCORE' => 'Momentumscore van slimme gidsen',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Slimme gids-activiteit toestaan van',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Slimme gids-vooruitgang',
    'LBL_CJ_MOMENTUM_RATIO' => 'Momentumverhouding van slimme gids',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Slimme gids-punten',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Slimme gids-taak',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Bovenliggend activiteitstype van slimme gids',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Slimme gids geblokkeerd door',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'Slimme gids geblokkeerd door fasen',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Bovenliggende activiteitstype-ID van slimme gids',
    'LBL_START_NEXT_JOURNEY_ID' => 'Volgende slimme gids-ID starten',
    'LBL_CJ_URL' => 'Slimme gids-URL',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Is bovenliggend activiteitstype van slimme gids',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Startdatum van slimme gids-momentum',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Einddatum van slimme gids-momentum',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'Configuratie van widget-indeling',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'Configuratie van widget-indeling',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'Maximaal aantal slimme gidsen van hetzelfde sjabloon',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'Actief',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'Gearchiveerd',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'Tonen',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'Verbergen',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'Verticale modus',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'Horizontale modus',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ongeldige licentie',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} heeft de volgende slimme gids-activiteiten toegewezen aan {{assigned_user}}.</p>
    <ul>{{activities}}</ul>
    
    <p>U kunt deze activiteiten bekijken op:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ongeldige licentie',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'De gebruikerslimiet is bereikt, u heeft {{gracePeriodDays}} dagen om de licentie te upgraden.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - Toegewezen slimme gids-activiteiten',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Uw Sugar Automate-gebruikerslimiet van {0} is overschreden<br>
    <br>
    Neem contact op met <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> om de gebruikerslimiet te verhogen of het aantal gebruikers dat de plug-in gebruikt, te verminderen.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'De gebruikerslimiet van Sugar Automate is bereikt',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Uw Sugar Automate-licentie verloopt over {0} dagen. <br>
    <br>
    Neem contact op met SugarCRM of uw Sugar-partner om de licentie te verlengen en onderbreking van de service te voorkomen.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'De Sugar Automate-licentie verloopt binnenkort',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'Webhook testen',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Voortgang Smart Guide',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Geeft het cirkeldiagram &#39;Voortgang Smart Guide&#39; van Sugar Automate weer.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'Toont de Webhook-reactie',
    'LBL_DASHLET_SEND_LABEL' => 'Aanvraag sturen',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'Mij toewijzen',
    'LBL_COMPLETE_BUTTON_TITLE' => 'Voltooien',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'Alle taken voltooien',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'Fase verwijderen',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'Starten',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'Niet van toepassing',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'Fase toevoegen',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'Bekijken',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Slimme gids bewerken',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'Annuleren',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'Archiveren',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'Dearchiveren',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'Sjabloon configureren',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'Taak toevoegen',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'Afspraak maken',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'Gesprek plannen',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'is in de toekomst',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'is laat',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'is vandaag',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'is morgen',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'Weet u zeker dat u deze slimme gids wilt annuleren?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'U staat op het punt om alle taken te voltooien. Weet u zeker dat u wilt doorgaan?',
    'LBL_CJ_BLOCK_BY' => 'U heeft een onopgeloste, afhankelijke taak: {{Name}}. Voltooi deze taak voordat u Alle taken voltooit.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'U heeft meerdere onopgeloste, afhankelijke taken. Voltooi deze taken voordat u Alle taken voltooit.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'U heeft alle taken voltooid',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'Weet u zeker dat u deze slimme gids wilt archiveren?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'Weer u zeker dat u deze slimme gids wilt de-archiveren?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Slimme gidsen (Focus Drawers en console)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'Bekijk actieve slimme gidsen over de service/vernieuwingen-console en de Focus Drawer-dashboards.',
    'LBL_CJ_PROCESSING_REQUEST' => 'Verwerken...',
    'LBL_CJ_SUCCESS' => 'U heeft alle taken voltooid',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module}-module is niet ingeschakeld',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'Alle weergave-instellingen zijn opgeslagen.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Momentum van slimme gids',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Toont het meterdiagram &#39;Slimme gids-momentum&#39; van Sugar Automate.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Voortgang Smart Guide',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Geeft het cirkeldiagram "Voortgang Smart Guide" van Sugar Automate weer.',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'Kan bovenliggende niet vinden',
    'CJ_NOT_FOUND_EXCEPTION' => 'Kan {moduleName} niet vinden met {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'De slimme gids moet voltooid of geannuleerd worden voordat u de gids kunt archiveren',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate is niet ingeschakeld in de huidige Sugar-licentie',
    'LBL_ACTION_NOT_FOUND' => 'Actie is niet gevonden. Neem contact op met de systeembeheerder',
    'LBL_CJ_SELECT_FIELD' => 'Selecteer veld',
    'LBL_CJ_SELECT_OPERATOR' => 'Selecteer Operator',
    'LBL_CJ_SELECT_VALUE' => 'Selecteer waarde',
    'LBL_CJ_ENTER_VALUE' => 'Waarde invoeren',
    'LBL_CJ_FORM_BATCH_TITLE' => 'Record opslaan',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'Actieve slimme gidsen gedetecteerd...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'Actieve sugar-acties verwerken...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'Actieve slimme gidsen bijwerken...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'De record en bijbehorende Smart Guides zijn bijgewerkt.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'Een bijbehorende slimme gids kan niet worden bijgewerkt. Als de fout aanhoudt, neem dan contact op met uw Sugar-beheerder voor hulp.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'Een bijbehorende slimme gids kan niet worden bijgewerkt. Bekijk de <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">Logboeken</a> om de fout op te lossen.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => 'De <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} is met succes gekoppeld.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'Er is een probleem met het koppelen van de <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}}. Als het probleem zich blijft voordoen, neem dan contact op met Sugar support.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => 'De {{modulePluralLower}} is gekoppeld.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'Er was een probleem met het koppelen van de {{modulePluralLower}}. Als het probleem zich blijft voordoen, neem dan contact op met Sugar support.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'Er was een probleem met het koppelen van de {{moduleSingularLower}}. Als het probleem zich blijft voordoen, neem dan contact op met Sugar support.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'Er is al een {{moduleSingularLower}} genaamd <a href="#{{module}}/{{id}}">{{name}}</a> In de fase {{stage}}.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'Een {{moduleSingularLower}} genaamd <a href="#{{module}}/{{id}}">{{name}}</a> is al geselecteerd.',
    'LBL_CJ_ARCHIVED' => 'Gearchiveerd',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Sjabloon Smart Guide selecteren...',
    'LBL_ALL_SMART_GUIDES' => 'Alle Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => 'Actieve Smart Guides',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Gearchiveerde Smart Guides',
    'LBL_VERTICAL_SCROLL_VIEW' => 'Verticaal gestapelde weergave',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'Horizontale scrollweergave',
    'LBL_DRI_WORKFLOWS_FILTER' => 'Filter',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'Deze actie kan niet worden voltooid. Het statusveld voor de module van deze activiteiten is ingesteld op "alleen lezen", wat eventuele Smart Guide-acties verhindert die het statusveld bijwerken.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'Deze actie kan niet worden voltooid. Het statusveld voor de modules van deze activiteiten en/of subactiviteiten is ingesteld op "alleen lezen", wat eventuele Smart Guide-acties verhindert die het statusveld bijwerken.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'Het veld Status voor sommige modules van activiteiten in de gids is ingesteld op "alleen-lezen", deze activiteiten blijven ongewijzigd bij het annuleren van de gids.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'Naar klembord gekopieerd.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'Alle herhaalde afspraken verwijderen',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'Ongeldige instellingen voor herhaalde afspraken',
    'ERROR_INTERVAL_INVALID' => 'Het herhalingsinterval moet tussen 1 en 99 zijn',
    'LBL_RECURRENCE_ADD' => 'Configureren',
    'LBL_REPEAT_DAYS' => 'Dag(en) van de maand',
    'LBL_REPEAT_END_TYPES' => 'Herhalen',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'Navigatieprovider',
    'LBL_MOBILE_PDF_EMAIL' => '{{{pdfTemplateName}}}-PDF e-mailen',
    'LBL_MOBILE_EMAIL_SENDING' => 'Verzenden',
    'LBL_MOBILE_EMAIL_SENT' => 'Verzonden',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'E-mail is opgeslagen als concept.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'Bijlage toevoegen',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'Uploaden vanuit lokaal',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar-document',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'Een bewerking die u aan deze record heeft gemaakt, heeft deze weergave gewijzigd.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'Releasekennisgevingen voor de app van SugarCRM Mobile',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'Handleiding voor SugarCRM Mobile',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile kan niet gebruikt worden op een geroot mobiel apparaat. Open de app op een apparaat dat niet geroot is.',
    'LBL_VO_BUILD_ROUTE' => 'Bouwroute',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'Mijn afstand-filter',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'Het document wordt op de achtergrond gegenereerd. Open de pagina Samenvoegingen van documenten om het bestand te openen.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'Sjabloon ophalen is mislukt. Neem contact op met uw beheerder voor hulp.',
    'LBL_MAP_ERROR_LOAD' => 'Kan kaart niet laden',
    'LBL_MAP_DISTANCE' => 'Afstand',
    'LBL_SELECT_UNIT_TYPE' => 'Type eenheid',
    'LBL_MAPS_UNIT_MILES' => 'Mijl',
    'LBL_MAPS_UNIT_KILOMETERS' => 'Kilometer',
    'LBL_RADIUS' => 'Radius',
    'LBL_ZIP_CODE' => 'Postcode',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'Adres kiezen',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'Kan geen geocode maken van adres:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'Record bevat geen geocodering.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'De record bevat geen adresgegevens. Wilt u deze record handmatig op de kaart vinden?',
    'LBL_ERR_SHOW_ON_MAP' => 'Kan de kaart niet openen voor de geselecteerde records.',
    'LBL_ERR_MISSING_ON_MAP' => 'Sommige records bevatten geen adresgegevens en worden niet weergegeven',
    'LBL_MAPS_ROUTE' => 'Route',
    'LBL_MAPS_PROVIDER' => 'Sugar-kaarten',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'Kan de huidige locatie niet bepalen.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'Maximaal {{{num}}} records kunnen in kaart gebracht worden.',
    'LBL_ALL_MODULES' => 'Alle modules',
    'LBL_DRIVE_SHARE_LINK' => 'Een link delen',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'Bestanden laden is mislukt.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'Naam kan niet leeg zijn',
    'LBL_DRIVE_FOLDER_CREATED' => 'Map is gemaakt.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'Een map maken is mislukt.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'Een bestand uploaden is mislukt.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'Maak eerst een hoofdmap',
    'LBL_EDIT_ALL_RECURRENCES' => 'Wijzig alle herhaalde afspraken',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'Bestand kan niet worden geopend in Dropbox',
    'LBL_FILE_NOT_AVAILABLE' => 'Bestand kan niet worden geopend',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'Richtingen',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'Er is geen route gevonden voor de opgegeven waypoints',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'Dichtbij',
    'LBL_TAGS' => 'Tags',

    'LBL_CALLER_ID_SETTINGS' => 'Instellingen beller-ID',
    'LBL_CALLER_ID_ENABLED' => 'Beller-ID ingeschakeld',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'Bij inkomende oproepen wordt de naam van de contactpersoon of lead weergegeven die overeenkomt met het telefoonnummer.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'Als u wilt dat de mobiele app beller-ID&#39;s weergeeft, volgt u deze stappen op uw apparaat:<br><br>1. Open iOS-instellingen > telefoon- > oproepblokkering en identificatie.<br>2. Schakel "{{{brandName}}}" in.',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'Als u wilt dat de mobiele app beller-ID&#39;s weergeeft, volgt u deze stappen op uw apparaat:<br>1. Open de app-instellingen.<br>2. Ga naar Machtigingen.<br>3. Schakel de telefoonmachtiging in.<br><br> Als u deze toepassing wilt instellen als de standaard beller-ID-handler, gaat u naar uw apparaatinstellingen.<br>1. Navigeer naar Apps.<br>2. Kies standaard-apps.<br>3. Kies Beller-ID en spam-app.<br>4. Selecteer deze applicatie als de standaardoptie.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Controleer op wijzigingen in contactgegevens uit records (bijvoorbeeld Contactpersonen, Potentiële klanten) in uw Sugar-instantie.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'Ga naar Instellingen',
    'LBL_CALLER_ID_SYNC' => 'Recordgegevens synchroniseren',
    'LBL_CALLER_ID_NOT_ENABLED' => 'Beller-id moet zijn ingeschakeld in de systeeminstellingen voordat de synchronisatie plaatsvindt.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'Inschakelen',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'Later in de instellingen',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'Deze applicatie ondersteunt de functie Beller-ID.<br> Voor een goede werking van deze functie wordt u na het indrukken van de knop Inschakelen gevraagd om twee machtigingen te verlenen.<br> Om ervoor te zorgen dat de functie Beller-ID correct werkt, moet u toestemming verlenen om oproepen te beheren en deze toepassing selecteren als de standaard beller-ID-handler.<br> Als u geen toestemming geeft om oproepen te beheren, kunt u ook geen oproepen registreren die vanuit de toepassing zijn gemaakt.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'Om de SugarCRM mobiele app toe te staan beller-ID&#39;s weer te geven, volgt u deze stappen op uw apparaat:<br><br>1. Open iOS-instellingen > telefoon- > oproepblokkering en identificatie.<br>2. App inschakelen.',
    'LBL_MOBILE_LAST_SYNC' => 'Laatste synchronisatie',
    'LBL_CALLER_ID_SYNCING' => 'Synchroniseren met server.',
    'LBL_NEVER' => 'Nooit',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} mag niet leeg zijn.',
    'LBL_ADD_RELATED_RECORD' => 'Gerelateerd aan {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => 'U beschikt niet over de vereiste machtigingen om de beller-id te gebruiken. Neem contact op met uw beheerder.',
    'LBL_CALLER_ID_FETCHING' => 'Synchroniseren…',
    'LBL_CALLER_ID_FETCH_ALL' => 'Alle records opnieuw synchroniseren',
    'LBL_CALLER_ID_FETCH_NEW' => 'Controleren op recordupdates',

    'LBL_SORT_BY' => 'Sorteren op',
    'LBL_PRIMARY_SORT' => 'Primair sorteren',
    'LBL_SECONDARY_SORT' => 'Secundair sorteren',
    'LBL_OF' => 'van',
    'LBL_TABLE_FREEZE_FIRST' => 'Eerste kolom bevriezen',
    'LBL_TABLE_SETTINGS_TITLE' => 'Opties voor kolomweergave',
    'LBL_TABLE_SETTINGS_NO_COL' => 'Er moet ten minste één kolom zijn geselecteerd.',
    'LBL_TABLE_TOGGLER_INFO' => 'Toon of verberg kolommen en sleep ze in de gewenste volgorde.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'Runtime filters',
    'LBL_FILTER_CONDITION' => 'Selecteer Conditie',
    'LBL_FILTER_VALUES' => 'Waarden',
    'LBL_TABLE_EXPAND' => 'Alles uitklappen',
    'LBL_TABLE_COLLAPSE' => 'Alles inklappen',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'Serverfout. Relevante runtimefilters kunnen niet worden geladen.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Pub/Sub-module aanmeldingen gebeurtenissen pushen',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Pub/Sub-module aanmelding gebeurtenissen pushen',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'Paneel - bovenaan',
    'panel_bottom' => 'Paneel - onderaan',
    'tab_first' => 'Tabblad - eerste',
    'tab_last' => 'Tabblad - laatste',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'Afgelopen 7 dagen',
    '30' => 'Afgelopen 30 dagen',
    '90' => 'Vorig kwartaal',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'Vandaag',
    'future' => 'Toekomst',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nee',
];

$app_list_strings['history_filter_options'] = [
    7 => 'Afgelopen 7 dagen',
    30 => 'Afgelopen 30 dagen',
    90 => 'Vorig kwartaal',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nee',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nee',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'Ja',
    '0' => 'Nee',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'Huidige kwartaal',
    'next' => 'Volgend kwartaal',
    'year' => 'Huidig jaar',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'My Records',
    'group' => 'Group Records',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'Mijn Salesfunnel',
    'group' => 'De salesfunnel van mijn team',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'Mijn forecast',
    'group' => 'Forecast van mijn team',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'Opportunities',
    'RevenueLineItems' => 'Opportunities and Revenue Line Items',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'Latest Close Date',
    'earliest' => 'Earliest Close Date',
];

$app_list_strings['moduleList']['Library'] = 'Bibliotheek';
$app_list_strings['moduleListSingular']['Library'] = 'Bibliotheek';
$app_list_strings['library_type'] = ['Books' => 'Boek', 'Music' => 'Muziek', 'DVD' => 'DVD', 'Magazines' => 'Tijdschriften'];
$app_list_strings['moduleList']['EmailAddresses'] = 'E-mailadres:';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'E-mailadres:';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'Concept',
    'in-review' => 'Ter beoordeling',
    'approved' => 'Approved',
    'published' => 'Gepubliceerd',
    'expired' => 'Verlopen',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--Beheeracties--',
        'Create New Tag' => 'Nieuwe tag aanmaken',
        'Delete Tag' => 'Verwijder tag',
        'Rename Tag' => 'Hernoem tag',
        'Move Selected Articles' => 'Verplaats geselecteerde artikelen',
        'Apply Tags On Articles' => 'Koppel tags aan artikelen',
        'Delete Selected Articles' => 'Verwijder geselecteerde artikelen',
    ];

$app_list_strings['moduleList']['Words'] = 'Woorden';
$app_list_strings['moduleListSingular']['Words'] = 'Woord';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Artikel aanmaken';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DHABI',
    'ADEN' => 'ADEN',
    'AFGHANISTAN' => 'AFGHANISTAN',
    'ALBANIA' => 'ALBANIE',
    'ALGERIA' => 'ALGERIJE',
    'AMERICAN SAMOA' => 'AMERIKAANS SAMOA',
    'ANDORRA' => 'ANDORRA',
    'ANGOLA' => 'ANGOLA',
    'ANTARCTICA' => 'ANTARCTICA',
    'ANTIGUA' => 'ANTIGUA',
    'ARGENTINA' => 'ARGENTINIE',
    'ARMENIA' => 'ARMENIE',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => 'AUSTRALIE',
    'AUSTRIA' => 'OOSTENRIJK',
    'AZERBAIJAN' => 'AZERBEIDZJAN',
    'BAHAMAS' => 'BAHAMA&#39;S',
    'BAHRAIN' => 'BAHREIN',
    'BANGLADESH' => 'BANGLADESH',
    'BARBADOS' => 'BARBADOS',
    'BELARUS' => 'WIT-RUSLAND',
    'BELGIUM' => 'BELGIË',
    'BELIZE' => 'BELIZE',
    'BENIN' => 'BENIN',
    'BERMUDA' => 'BERMUDA',
    'BHUTAN' => 'BHUTAN',
    'BOLIVIA' => 'BOLIVIE',
    'BOSNIA' => 'BOSNIË',
    'BOTSWANA' => 'BOTSWANA',
    'BOUVET ISLAND' => 'BOUVET EILAND',
    'BRAZIL' => 'BRAZILIË',
    'BRITISH ANTARCTICA TERRITORY' => 'BRITS GEBIED IN ANTARTICA',
    'BRITISH INDIAN OCEAN TERRITORY' => 'BRITS GEBIED IN INDISCHE OCEAAN',
    'BRITISH VIRGIN ISLANDS' => 'BRITSE MAAGDEN EILANDEN',
    'BRITISH WEST INDIES' => 'BRITS WEST INDIË',
    'BRUNEI' => 'BRUNEI',
    'BULGARIA' => 'BULGARIJE',
    'BURKINA FASO' => 'BURKINA FASO',
    'BURUNDI' => 'BURUNDI',
    'CAMBODIA' => 'CAMBODJA',
    'CAMEROON' => 'KAMEROEN',
    'CANADA' => 'CANADA',
    'CANAL ZONE' => 'KANAALZONE',
    'CANARY ISLAND' => 'CANARISCHE EILANDEN',
    'CAPE VERDI ISLANDS' => 'KAAPVERDIË',
    'CAYMAN ISLANDS' => 'CAYMAN EILANDEN',
    'CEVLON' => 'CEVLON',
    'CHAD' => 'TSJAAD',
    'CHANNEL ISLAND UK' => 'KANAALEILANDEN',
    'CHILE' => 'CHILI',
    'CHINA' => 'CHINA',
    'CHRISTMAS ISLAND' => 'CHRISTMASEILAND',
    'COCOS (KEELING) ISLAND' => 'COCOS (KEELING) EILAND',
    'COLOMBIA' => 'COLOMBIA',
    'COMORO ISLANDS' => 'COMORO EILANDEN',
    'CONGO' => 'CONGO',
    'CONGO KINSHASA' => 'CONGO-KINSHASA',
    'COOK ISLANDS' => 'COOK EILANDEN',
    'COSTA RICA' => 'COSTA RICA',
    'CROATIA' => 'KROATIË',
    'CUBA' => 'CUBA',
    'CURACAO' => 'CURAÇAO',
    'CYPRUS' => 'CYPRUS',
    'CZECH REPUBLIC' => 'TSJECHIË',
    'DAHOMEY' => 'DAHOMEY',
    'DENMARK' => 'DENEMARKEN',
    'DJIBOUTI' => 'DJIBOUTI',
    'DOMINICA' => 'DOMINICA',
    'DOMINICAN REPUBLIC' => 'DOMINICAANSE REPUBLIEK',
    'DUBAI' => 'DUBAI',
    'ECUADOR' => 'ECUADOR',
    'EGYPT' => 'EGYPTE',
    'EL SALVADOR' => 'EL SALVADOR',
    'EQUATORIAL GUINEA' => 'EQUATORIAAL GUINEA',
    'ESTONIA' => 'ESTLAND',
    'ETHIOPIA' => 'ETHIOPIË',
    'FAEROE ISLANDS' => 'FAEROER EILANDEN',
    'FALKLAND ISLANDS' => 'FALKLAND EILANDEN',
    'FIJI' => 'FIJI',
    'FINLAND' => 'FINLAND',
    'FRANCE' => 'FRANKRIJK',
    'FRENCH GUIANA' => 'FRANS-GUYANA',
    'FRENCH POLYNESIA' => 'FRANS POLYNESIË',
    'GABON' => 'GABON',
    'GAMBIA' => 'GAMBIA',
    'GEORGIA' => 'GEORGIË',
    'GERMANY' => 'DUITSLAND',
    'GHANA' => 'GHANA',
    'GIBRALTAR' => 'GIBRALTAR',
    'GREECE' => 'GRIEKENLAND',
    'GREENLAND' => 'GROENLAND',
    'GUADELOUPE' => 'GUADELOUPE',
    'GUAM' => 'GUAM',
    'GUATEMALA' => 'GUATEMALA',
    'GUINEA' => 'GUINEE',
    'GUYANA' => 'GUYANA',
    'HAITI' => 'HAÏTI',
    'HONDURAS' => 'HONDURAS',
    'HONG KONG' => 'HONG KONG',
    'HUNGARY' => 'HONGARIJE',
    'ICELAND' => 'IJSLAND',
    'IFNI' => 'IFNI',
    'INDIA' => 'INDIA',
    'INDONESIA' => 'INDONESIË',
    'IRAN' => 'IRAN',
    'IRAQ' => 'IRAK',
    'IRELAND' => 'IERLAND',
    'ISRAEL' => 'ISRAËL',
    'ITALY' => 'ITALIË',
    'IVORY COAST' => 'IVOORKUST',
    'JAMAICA' => 'JAMAICA',
    'JAPAN' => 'JAPAN',
    'JORDAN' => 'JORDANIË',
    'KAZAKHSTAN' => 'KAZACHSTAN',
    'KENYA' => 'KENIA',
    'KOREA' => 'KOREA',
    'KOREA, SOUTH' => 'ZUID-KOREA',
    'KUWAIT' => 'KUWEIT',
    'KYRGYZSTAN' => 'KIRGIZIË',
    'LAOS' => 'LAOS',
    'LATVIA' => 'LETLAND',
    'LEBANON' => 'LIBANON',
    'LEEWARD ISLANDS' => 'NEDERLANDSE ANTILLEN',
    'LESOTHO' => 'LESOTHO',
    'LIBYA' => 'LIBIË',
    'LIECHTENSTEIN' => 'LIECHTENSTEIN',
    'LITHUANIA' => 'LITOUWEN',
    'LUXEMBOURG' => 'LUXEMBURG',
    'MACAO' => 'MACAO',
    'MACEDONIA' => 'MACEDONIË',
    'MADAGASCAR' => 'MADAGASCAR',
    'MALAWI' => 'MALAWI',
    'MALAYSIA' => 'MALEISIË',
    'MALDIVES' => 'MALADIVEN',
    'MALI' => 'MALI',
    'MALTA' => 'MALTA',
    'MARTINIQUE' => 'MARTINIQUE',
    'MAURITANIA' => 'MAURITANIË',
    'MAURITIUS' => 'MAURITIUS',
    'MELANESIA' => 'MELANESIE',
    'MEXICO' => 'MEXICO',
    'MOLDOVIA' => 'MOLDAVIË',
    'MONACO' => 'MONACO',
    'MONGOLIA' => 'MONGOLIË',
    'MOROCCO' => 'MAROKKO',
    'MOZAMBIQUE' => 'MOZAMBIQUE',
    'MYANAMAR' => 'MYANMAR',
    'NAMIBIA' => 'NAMIBIË',
    'NEPAL' => 'NEPAL',
    'NETHERLANDS' => 'NEDERLAND',
    'NETHERLANDS ANTILLES' => 'NEDERLANDSE ANTILLEN',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'NEDERLANDSE ANTILLEN NEUTRALE ZONE',
    'NEW CALADONIA' => 'NIEUW CALEDONIË',
    'NEW HEBRIDES' => 'NIEUW HEBRIDEN',
    'NEW ZEALAND' => 'NIEUW ZEELAND',
    'NICARAGUA' => 'NICARAGUA',
    'NIGER' => 'NIGER',
    'NIGERIA' => 'NIGERIA',
    'NORFOLK ISLAND' => 'NORFOLK EILANDEN',
    'NORWAY' => 'NOORWEGEN',
    'OMAN' => 'OMAN',
    'OTHER' => 'OVERIG',
    'PACIFIC ISLAND' => 'PACIFIC EILANDEN',
    'PAKISTAN' => 'PAKISTAN',
    'PANAMA' => 'PANAMA',
    'PAPUA NEW GUINEA' => 'PAPOEA-NIEUW-GUINEA',
    'PARAGUAY' => 'PARAGUAY',
    'PERU' => 'PERU',
    'PHILIPPINES' => 'FILIPIJNEN',
    'POLAND' => 'POLEN',
    'PORTUGAL' => 'PORTUGAL',
    'PORTUGUESE TIMOR' => 'PORTUGEES-TIMOR',
    'PUERTO RICO' => 'PUERTO RICO',
    'QATAR' => 'QATAR',
    'REPUBLIC OF BELARUS' => 'REPUBLIEK BELARUS (WIT-RUSLAND)',
    'REPUBLIC OF SOUTH AFRICA' => 'REPUBLIEK ZUID AFRIKA',
    'REUNION' => 'REUNION',
    'ROMANIA' => 'ROEMENIË',
    'RUSSIA' => 'RUSLAND',
    'RWANDA' => 'RWANDA',
    'RYUKYU ISLANDS' => 'RYUKYU-EILANDEN',
    'SABAH' => 'SABAH',
    'SAN MARINO' => 'SAN MARINO',
    'SAUDI ARABIA' => 'SAOEDI ARABIË',
    'SENEGAL' => 'SENEGAL',
    'SERBIA' => 'SERVIË',
    'SEYCHELLES' => 'SEYCHELLEN',
    'SIERRA LEONE' => 'SIËRRA LEONE',
    'SINGAPORE' => 'SINGAPORE',
    'SLOVAKIA' => 'SLOWAKIJE',
    'SLOVENIA' => 'SLOVENIË',
    'SOMALILIAND' => 'SOMALILAND',
    'SOUTH AFRICA' => 'ZUID AFRIKA',
    'SOUTH YEMEN' => 'ZUID-JEMEN',
    'SPAIN' => 'SPANJE',
    'SPANISH SAHARA' => 'SPAANSE-SAHARA',
    'SRI LANKA' => 'SRI LANKA',
    'ST. KITTS AND NEVIS' => 'ST. KITTS EN NEVIS',
    'ST. LUCIA' => 'ST. LUCIA',
    'SUDAN' => 'SUDAN',
    'SURINAM' => 'SURINAME',
    'SW AFRICA' => 'ZUIDWEST-AFRIKA',
    'SWAZILAND' => 'SWAZILAND',
    'SWEDEN' => 'ZWEDEN',
    'SWITZERLAND' => 'ZWITSERLAND',
    'SYRIA' => 'SYRIË',
    'TAIWAN' => 'TAIWAN',
    'TAJIKISTAN' => 'TADZIKISTAN',
    'TANZANIA' => 'TANZANIA',
    'THAILAND' => 'THAILAND',
    'TONGA' => 'TONGA',
    'TRINIDAD' => 'TRINIDAD',
    'TUNISIA' => 'TUNISIË',
    'TURKEY' => 'TURKIJE',
    'UGANDA' => 'OEGANDA',
    'UKRAINE' => 'OEKRAINE',
    'UNITED ARAB EMIRATES' => 'VERENIGDE ARABISCHE EMIRATEN',
    'UNITED KINGDOM' => 'VERENIGD KONINKRIJK',
    'UPPER VOLTA' => 'UPPER VOLTA',
    'URUGUAY' => 'URUGUAY',
    'US PACIFIC ISLAND' => 'US PACIFIC ISLAND',
    'US VIRGIN ISLANDS' => 'AMERIKAANSE MAAGDENEILANDEN',
    'USA' => 'VERENIGDE STATEN',
    'UZBEKISTAN' => 'OEZBEKISTAN',
    'VANUATU' => 'VANUATU',
    'VATICAN CITY' => 'VATICAANSTAD',
    'VENEZUELA' => 'VENEZUELA',
    'VIETNAM' => 'VIETNAM',
    'WAKE ISLAND' => 'WAKE ISLAND',
    'WEST INDIES' => 'WEST INDIES',
    'WESTERN SAHARA' => 'WESTELIJKE SAHARA',
    'YEMEN' => 'YEMEN',
    'ZAIRE' => 'ZAÏRE',
    'ZAMBIA' => 'ZAMBIA',
    'ZIMBABWE' => 'ZIMBABWE',
];

$app_list_strings['state_dom'] = [
    'AL' => 'Alabama',
    'AK' => 'Alaska',
    'AZ' => 'Arizona',
    'AR' => 'Arkansas',
    'CA' => 'Californië',
    'CO' => 'Colorado',
    'CT' => 'Connecticut',
    'DE' => 'Delaware',
    'DC' => 'District Of Columbia',
    'FL' => 'Florida',
    'GA' => 'Georgia',
    'HI' => 'Hawaii',
    'ID' => 'Idaho',
    'IL' => 'Illinois',
    'IN' => 'Indiana',
    'IA' => 'Iowa',
    'KS' => 'Kansas',
    'KY' => 'Kentucky',
    'LA' => 'Louisiana',
    'ME' => 'Maine',
    'MD' => 'Maryland',
    'MA' => 'Massachusetts',
    'MI' => 'Michigan',
    'MN' => 'Minnesota',
    'MS' => 'Mississippi',
    'MO' => 'Missouri',
    'MT' => 'Montana',
    'NE' => 'Nebraska',
    'NV' => 'Nevada',
    'NH' => 'New Hampshire',
    'NJ' => 'New Jersey',
    'NM' => 'New Mexico',
    'NY' => 'New York',
    'NC' => 'North Carolina',
    'ND' => 'North Dakota',
    'OH' => 'Ohio',
    'OK' => 'Oklahoma',
    'OR' => 'Oregon',
    'PA' => 'Pennsylvania',
    'RI' => 'Rhode Island',
    'SC' => 'South Carolina',
    'SD' => 'South Dakota',
    'TN' => 'Tennessee',
    'TX' => 'Texas',
    'UT' => 'Utah',
    'VT' => 'Vermont',
    'VA' => 'Virginia',
    'WA' => 'Washington',
    'WV' => 'West Virginia',
    'WI' => 'Wisconsin',
    'WY' => 'Wyoming',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (Taiwan and Hong-Kong)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS Cyrillisch)',
    'CP1252' => 'CP1252 (MS West-Europa & VS)',
    'EUC-CN' => 'EUC-CN (Vereenvoudigd Chinees GB2312)',
    'EUC-JP' => 'EUC-JP (Unix Japans)',
    'EUC-KR' => 'EUC-KR (Koreaans)',
    'EUC-TW' => 'EUC-TW (Taiwanees)',
    'ISO-2022-JP' => 'ISO-2022-JP (Japans)',
    'ISO-2022-KR' => 'ISO-2022-KR (Koreaans)',
    'ISO-8859-1' => 'ISO-8859-1 (West-Europa & VS)',
    'ISO-8859-2' => 'ISO-8859-2 (Centraal en Oost-Europa)',
    'ISO-8859-3' => 'ISO-8859-3 (Latijn 3)',
    'ISO-8859-4' => 'ISO-8859-4 (Latijn 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Cyrillisch)',
    'ISO-8859-6' => 'ISO-8859-6 (Arabisch)',
    'ISO-8859-7' => 'ISO-8859-7 (Grieks)',
    'ISO-8859-8' => 'ISO-8859-8 (Hebreews)',
    'ISO-8859-9' => 'ISO-8859-9 (Latijn 5)',
    'ISO-8859-10' => 'ISO-8859-10 (Latijn 6)',
    'ISO-8859-13' => 'ISO-8859-13 (Latijn 7)',
    'ISO-8859-14' => 'ISO-8859-14 (Latijn 8)',
    'ISO-8859-15' => 'ISO-8859-15 (Latijn 9)',
    'KOI8-R' => 'KOI8-R (Cyrillisch Russisch)',
    'KOI8-U' => 'KOI8-U (Cyrillisch Oekrains)',
    'SJIS' => 'SJIS (MS Japans)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Afrika/Algiers',
    'Africa/Luanda' => 'Afrika/Luanda',
    'Africa/Porto-Novo' => 'Afrika/Porto-Novo',
    'Africa/Gaborone' => 'Afrika/Gaborone',
    'Africa/Ouagadougou' => 'Afrika/Ouagadougou',
    'Africa/Bujumbura' => 'Afrika/Bujumbura',
    'Africa/Douala' => 'Afrika/Douala',
    'Atlantic/Cape_Verde' => 'Atlantisch/Cape_Verde',
    'Africa/Bangui' => 'Afrika/Bangui',
    'Africa/Ndjamena' => 'Afrika/Ndjamena',
    'Indian/Comoro' => 'Indisch/Comoro',
    'Africa/Kinshasa' => 'Afrika/Kinshasa',
    'Africa/Lubumbashi' => 'Afrika/Lubumbashi',
    'Africa/Brazzaville' => 'Afrika/Brazzaville',
    'Africa/Abidjan' => 'Afrika/Abidjan',
    'Africa/Djibouti' => 'Afrika/Djibouti',
    'Africa/Cairo' => 'Afrika/Cairo',
    'Africa/Malabo' => 'Afrika/Malabo',
    'Africa/Asmera' => 'Afrika/Asmera',
    'Africa/Addis_Ababa' => 'Afrika/Addis_Ababa',
    'Africa/Libreville' => 'Afrika/Libreville',
    'Africa/Banjul' => 'Afrika/Banjul',
    'Africa/Accra' => 'Afrika/Accra',
    'Africa/Conakry' => 'Afrika/Conakry',
    'Africa/Bissau' => 'Afrika/Bissau',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Lagos' => 'Africa/Lagos',
    'Indian/Reunion' => 'Indian/Reunion',
    'Africa/Kigali' => 'Africa/Kigali',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Dakar' => 'Africa/Dakar',
    'Indian/Mahe' => 'Indian/Mahe',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Harare' => 'Africa/Harare',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Indian/Chagos' => 'Indisch/Chagos',
    'Asia/Brunei' => 'Azië/Brunei',
    'Asia/Rangoon' => 'Azië/Rangoon',
    'Asia/Phnom_Penh' => 'Azië/Phnom_Penh',
    'Asia/Beijing' => 'Azië/Beijing',
    'Asia/Harbin' => 'Azië/Harbin',
    'Asia/Shanghai' => 'Azië/Shanghai',
    'Asia/Chongqing' => 'Azië/Chongqing',
    'Asia/Urumqi' => 'Azië/Urumqi',
    'Asia/Kashgar' => 'Azië/Kashgar',
    'Asia/Hong_Kong' => 'Azië/Hong_Kong',
    'Asia/Taipei' => 'Azië/Taipei',
    'Asia/Macau' => 'Azië/Macau',
    'Asia/Nicosia' => 'Azië/Nicosia',
    'Asia/Tbilisi' => 'Azië/Tbilisi',
    'Asia/Dili' => 'Azië/Dili',
    'Asia/Calcutta' => 'Azië/Calcutta',
    'Asia/Jakarta' => 'Azië/Jakarta',
    'Asia/Pontianak' => 'Azië/Pontianak',
    'Asia/Makassar' => 'Azië/Makassar',
    'Asia/Jayapura' => 'Azië/Jayapura',
    'Asia/Tehran' => 'Azië/Teheran',
    'Asia/Baghdad' => 'Azië/Baghdad',
    'Asia/Jerusalem' => 'Azië/Jeruzalem',
    'Asia/Tokyo' => 'Azië/Tokyo',
    'Asia/Amman' => 'Azië/Amman',
    'Asia/Almaty' => 'Azië/Almaty',
    'Asia/Qyzylorda' => 'Azië/Qyzylorda',
    'Asia/Aqtobe' => 'Azië/Aqtobe',
    'Asia/Aqtau' => 'Azië/Aqtau',
    'Asia/Oral' => 'Azië/Oral',
    'Asia/Bishkek' => 'Azië/Bishkek',
    'Asia/Seoul' => 'Azië/Seoul',
    'Asia/Pyongyang' => 'Azië/Pyongyang',
    'Asia/Kuwait' => 'Azië/Kuwait',
    'Asia/Vientiane' => 'Azië/Vientiane',
    'Asia/Beirut' => 'Azië/Beirut',
    'Asia/Kuala_Lumpur' => 'Azië/Kuala_Lumpur',
    'Asia/Kuching' => 'Azië/Kuching',
    'Indian/Maldives' => 'Indisch/Maldiven',
    'Asia/Hovd' => 'Azië/Hovd',
    'Asia/Ulaanbaatar' => 'Azië/Ulaanbaatar',
    'Asia/Choibalsan' => 'Azië/Choibalsan',
    'Asia/Katmandu' => 'Azië/Katmandu',
    'Asia/Muscat' => 'Azië/Muscat',
    'Asia/Karachi' => 'Azië/Karachi',
    'Asia/Gaza' => 'Azië/Gaza',
    'Asia/Manila' => 'Azië/Manila',
    'Asia/Qatar' => 'Azië/Qatar',
    'Asia/Riyadh' => 'Azië/Riyadh',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Saigon' => 'Asia/Saigon',
    'Asia/Aden' => 'Asia/Aden',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Sydney' => 'Australia/Sydney',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Indian/Christmas' => 'Indian/Christmas',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Indian/Cocos' => 'Indian/Cocos',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Truk' => 'Pacific/Truk',
    'Pacific/Ponape' => 'Pacific/Ponape',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Johnston' => 'Pacific/Johnston',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'Europe/London' => 'Europa/Londen',
    'Europe/Dublin' => 'Europa/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'Europa/Tirane',
    'Europe/Andorra' => 'Europa/Andorra',
    'Europe/Vienna' => 'Europa/Wenen',
    'Europe/Minsk' => 'Europa/Minsk',
    'Europe/Brussels' => 'Europa/Brussel',
    'Europe/Sofia' => 'Europa/Sofia',
    'Europe/Prague' => 'Europa/Praag',
    'Europe/Copenhagen' => 'Europa/Copenhagen',
    'Atlantic/Faeroe' => 'Atlantic/Faeroe',
    'America/Danmarkshavn' => 'Amerika/Danmarkshavn',
    'America/Scoresbysund' => 'Amerika/Scoresbysund',
    'America/Godthab' => 'Amerika/Godthab',
    'America/Thule' => 'Amerika/Thule',
    'Europe/Tallinn' => 'Europa/Tallinn',
    'Europe/Helsinki' => 'Europa/Helsinki',
    'Europe/Paris' => 'Europa/Parijs',
    'Europe/Berlin' => 'Europa/Berlijn',
    'Europe/Gibraltar' => 'Europa/Gibraltar',
    'Europe/Athens' => 'Europa/Athene',
    'Europe/Budapest' => 'Europa/Budapest',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Europe/Rome' => 'Europa/Rome',
    'Europe/Riga' => 'Europa/Riga',
    'Europe/Vaduz' => 'Europa/Vaduz',
    'Europe/Vilnius' => 'Europa/Vilnius',
    'Europe/Luxembourg' => 'Europa/Luxemburg',
    'Europe/Malta' => 'Europa/Malta',
    'Europe/Chisinau' => 'Europa/Chisinau',
    'Europe/Monaco' => 'Europa/Monaco',
    'Europe/Amsterdam' => 'Europa/Amsterdam',
    'Europe/Oslo' => 'Europa/Oslo',
    'Europe/Warsaw' => 'Europa/Warschau',
    'Europe/Lisbon' => 'Europa/Lisabon',
    'Atlantic/Azores' => 'Atlantic/Azoren',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Europe/Bucharest' => 'Europa/Bucharest',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Samara' => 'Europe/Samara',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Madrid' => 'Europe/Madrid',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Zurich' => 'Europe/Zurich',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'America/New_York' => 'America/New_York',
    'America/Chicago' => 'America/Chicago',
    'America/North_Dakota/Center' => 'America/North_Dakota/Center',
    'America/Denver' => 'America/Denver',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Juneau' => 'America/Juneau',
    'America/Yakutat' => 'America/Yakutat',
    'America/Anchorage' => 'America/Anchorage',
    'America/Nome' => 'America/Nome',
    'America/Adak' => 'America/Adak',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'America/Phoenix' => 'Amerika/Phoenix',
    'America/Boise' => 'Amerika/Boise',
    'America/Indiana/Indianapolis' => 'Amerika/Indiana/Indianapolis',
    'America/Indiana/Marengo' => 'Amerika/Indiana/Marengo',
    'America/Indiana/Knox' => 'Amerika/Indiana/Knox',
    'America/Indiana/Vevay' => 'Amerika/Indiana/Vevay',
    'America/Kentucky/Louisville' => 'Amerika/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'Amerika/Kentucky/Monticello',
    'America/Detroit' => 'Amerika/Detroit',
    'America/Menominee' => 'Amerika/Menominee',
    'America/St_Johns' => 'Amerika/St_Johns',
    'America/Goose_Bay' => 'Amerika/Goose_Bay',
    'America/Halifax' => 'Amerika/Halifax',
    'America/Glace_Bay' => 'Amerika/Glace_Bay',
    'America/Montreal' => 'Amerika/Montreal',
    'America/Toronto' => 'Amerika/Toronto',
    'America/Thunder_Bay' => 'Amerika/Thunder_Bay',
    'America/Nipigon' => 'Amerika/Nipigon',
    'America/Rainy_River' => 'Amerika/Rainy_River',
    'America/Winnipeg' => 'Amerika/Winnipeg',
    'America/Regina' => 'Amerika/Regina',
    'America/Swift_Current' => 'Amerika/Swift_Current',
    'America/Edmonton' => 'Amerika/Edmonton',
    'America/Vancouver' => 'Amerika/Vancouver',
    'America/Dawson_Creek' => 'Amerika/Dawson_Creek',
    'America/Pangnirtung' => 'Amerika/Pangnirtung',
    'America/Iqaluit' => 'Amerika/Iqaluit',
    'America/Coral_Harbour' => 'Amerika/Coral_Harbour',
    'America/Rankin_Inlet' => 'Amerika/Rankin_Inlet',
    'America/Cambridge_Bay' => 'Amerika/Cambridge_Bay',
    'America/Yellowknife' => 'Amerika/Yellowknife',
    'America/Inuvik' => 'Amerika/Inuvik',
    'America/Whitehorse' => 'Amerika/Whitehorse',
    'America/Dawson' => 'Amerika/Dawson',
    'America/Cancun' => 'Amerika/Cancun',
    'America/Merida' => 'Amerika/Merida',
    'America/Monterrey' => 'Amerika/Monterrey',
    'America/Mexico_City' => 'Amerika/Mexico_City',
    'America/Chihuahua' => 'Amerika/Chihuahua',
    'America/Hermosillo' => 'Amerika/Hermosillo',
    'America/Mazatlan' => 'Amerika/Mazatlan',
    'America/Tijuana' => 'Amerika/Tijuana',
    'America/Anguilla' => 'Amerika/Anguilla',
    'America/Antigua' => 'Amerika/Antigua',
    'America/Nassau' => 'Amerika/Nassau',
    'America/Barbados' => 'Amerika/Barbados',
    'America/Belize' => 'Amerika/Belize',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'America/Cayman' => 'Amerika/Cayman',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Havana' => 'America/Havana',
    'America/Dominica' => 'America/Dominica',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Jamaica' => 'America/Jamaica',
    'America/Martinique' => 'America/Martinique',
    'America/Montserrat' => 'America/Montserrat',
    'America/Managua' => 'America/Managua',
    'America/Panama' => 'America/Panama',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/Miquelon' => 'America/Miquelon',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Tortola' => 'America/Tortola',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/La_Paz' => 'America/La_Paz',
    'America/Noronha' => 'America/Noronha',
    'America/Belem' => 'America/Belem',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Recife' => 'America/Recife',
    'America/Araguaina' => 'America/Araguaina',
    'America/Maceio' => 'America/Maceio',
    'America/Bahia' => 'America/Bahia',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Manaus' => 'America/Manaus',
    'America/Eirunepe' => 'Amerika/Eirunepe',
    'America/Rio_Branco' => 'Amerika/Rio_Branco',
    'America/Santiago' => 'Amerika/Santiago',
    'Pacific/Easter' => 'Pacific/Easter',
    'America/Bogota' => 'Amerika/Bogota',
    'America/Curacao' => 'Amerika/Curacao',
    'America/Guayaquil' => 'Amerika/Guayaquil',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'America/Cayenne' => 'Amerika/Cayenne',
    'America/Guyana' => 'Amerika/Guyana',
    'America/Asuncion' => 'Amerika/Asuncion',
    'America/Lima' => 'Amerika/Lima',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'America/Paramaribo' => 'Amerika/Paramaribo',
    'America/Port_of_Spain' => 'Amerika/Port_of_Spain',
    'America/Montevideo' => 'Amerika/Montevideo',
    'America/Caracas' => 'Amerika/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'Favorieten';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'Favoriet';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google Docs',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Contacten',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'Verzoek',
    2 => 'Toegang',
    3 => 'Ongeldig',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Toegewezen aan',
    'support_portal' => 'Supportportaal',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'Campagne',
    'email' => 'E-mailadres',
    'workflow' => 'Workflow',
    'system' => 'Systeem',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'Campagne',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'Campagne',
    'email' => 'E-mailadres',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'Documentatie',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'Twee bereiken',
    'show_buckets' => 'Drie bereiken',
    'show_custom_buckets' => 'Custom bereik',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'Datumgebaseerd jaar',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'Jaarlijks (subperiodes per kwartaal)',
    'Quarter' => 'Kwartaallijks (subperiodes per maand)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'Opportunityregels',
    'Opportunities' => 'Opportunities',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'Ja',
    'no' => 'Nee',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'Waarschuwing',
    'information' => 'Info',
    'other' => 'Anders',
    'success' => 'Succes',
    'warning' => 'Waarschuwing',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'GET',
    'PUT' => 'PUT',
    'DELETE' => 'VERWIJDER',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'Handmatig',
    '5' => 'Elke 5 minuten',
    '15' => 'Elke 15 minuten',
    '30' => 'Elke 30 minuten',
    '60' => 'Elk uur',
];

$app_list_strings['moduleList']['KBDocuments'] = 'Knowledge Base';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'Knowledge Base';
$app_list_strings['moduleList']['KBContents'] = 'Knowledge Base';
$app_list_strings['moduleListSingular']['KBContents'] = 'Kennisbasisartikel';
$app_list_strings['moduleList']['KBArticles'] = 'Knowledge Base Artikel';
$app_list_strings['moduleListSingular']['KBArticles'] = 'Knowledge Base Artikel';
$app_list_strings['moduleList']['KBContentTemplates'] = 'Sjabloon kennisdatabank';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'Sjabloon kennisdatabank';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'Ingesloten bestanden';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'Ingesloten bestand';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leke',
    'USD' => 'Dollars',
    'AFN' => 'Afghani&#39;s',
    'ARS' => 'Pesos',
    'AWG' => 'Guldens',
    'AUD' => 'Dollars',
    'AZN' => 'Nieuw Manats',
    'BSD' => 'Dollars',
    'BBD' => 'Dollars',
    'BYR' => 'Roebels',
    'EUR' => 'Euro',
    'BZD' => 'Dollars',
    'BMD' => 'Dollars',
    'BOB' => 'Boliviano&#39;s',
    'BAM' => 'Convertibele Marka',
    'BWP' => 'Pulas',
    'BGN' => 'Leva',
    'BRL' => 'Reais',
    'GBP' => 'Ponden',
    'BND' => 'Dollars',
    'KHR' => 'Riels',
    'CAD' => 'Dollars',
    'KYD' => 'Dollars',
    'CLP' => 'Peso&#39;s',
    'CNY' => 'Yuan Renminbi',
    'COP' => 'Peso&#39;s',
    'CRC' => 'Colón',
    'HRK' => 'Kuna',
    'CUP' => 'Peso&#39;s',
    'CZK' => 'Koruny',
    'DKK' => 'Kronen',
    'DOP' => 'Peso&#39;s',
    'XCD' => 'Dollars',
    'EGP' => 'Ponden',
    'SVC' => 'Colones',
    'EEK' => 'Krooni',
    'FKP' => 'Ponden',
    'FJD' => 'Dollars',
    'GHC' => 'Cedis',
    'GIP' => 'Ponden',
    'GTQ' => 'Quetzales',
    'GGP' => 'Ponden',
    'GYD' => 'Dollars',
    'HNL' => 'Lempira&#39;s',
    'HKD' => 'Dollars',
    'HUF' => 'Forint',
    'ISK' => 'Kronen',
    'INR' => 'Roepies',
    'IDR' => 'Rupiahs',
    'IRR' => 'Rials',
    'IMP' => 'Ponden',
    'ILS' => 'Nieuwe sikkels',
    'JMD' => 'Dollars',
    'JPY' => 'Yen',
    'JEP' => 'Ponden',
    'KZT' => 'Tenge',
    'KPW' => 'Gewonnen',
    'KRW' => 'Gewonnen',
    'KGS' => 'Soms',
    'LAK' => 'Kips',
    'LVL' => 'Lati',
    'LBP' => 'Ponden',
    'LRD' => 'Dollars',
    'CHF' => 'Zwitserland, Franken',
    'LTL' => 'Litai',
    'MKD' => 'Denars',
    'MYR' => 'Ringgits',
    'MUR' => 'Roepies',
    'MXN' => 'Peso&#39;s',
    'MNT' => 'Tugriks',
    'MZN' => 'Meticais',
    'NAD' => 'Dollars',
    'NPR' => 'Roepies',
    'ANG' => 'Guldens',
    'NZD' => 'Dollars',
    'NIO' => 'Cordobas',
    'NGN' => 'Nairas',
    'NOK' => 'Kroon',
    'OMR' => 'Rials',
    'PKR' => 'Roepies',
    'PAB' => 'Balboa',
    'PYG' => 'Guarani',
    'PEN' => 'Nuevos Soles',
    'PHP' => 'Peso&#39;s',
    'PLN' => 'Zloty',
    'QAR' => 'Rials',
    'RON' => 'Nieuwe Lei',
    'RUB' => 'Roebels',
    'SHP' => 'Ponden',
    'SAR' => 'Riyalen',
    'RSD' => 'Dinars',
    'SCR' => 'Roepies',
    'SGD' => 'Dollars',
    'SBD' => 'Dollars',
    'SOS' => 'Shillings',
    'ZAR' => 'Rand',
    'LKR' => 'Roepies',
    'SEK' => 'Kronen',
    'SRD' => 'Dollars',
    'SYP' => 'Ponden',
    'TWD' => 'Nieuwe Dollars',
    'THB' => 'Baht',
    'TTD' => 'Dollars',
    'TRY' => 'Lire',
    'TRL' => 'Lira&#39;s',
    'TVD' => 'Dollars',
    'UAH' => 'Hryvnia',
    'UYU' => 'Peso&#39;s',
    'UZS' => 'Bedragen',
    'VEF' => 'Bolivares Fuertes',
    'VND' => 'Dong',
    'YER' => 'Rials',
    'ZWD' => 'Zimbabwaanse dollar',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'Zeer hoog',
    '4' => 'Hoog',
    '3' => 'Neutraal',
    '2' => 'Laag',
    '1' => 'Zeer laag',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'Geen',
    'future' => 'Huidige waarde',
    'old' => 'Oude waarde',
    'both' => 'Huidige en oude waarden',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Single-Hit',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'Verwerken',
    'error' => 'Fout',
    'success' => 'Geslaagd',
    'canceled' => 'Geannuleerd',
    'document_load' => 'Sjabloon laden',
    'tags_extract' => 'Tags extraheren',
    'tags_validate' => 'Tags valideren',
    'data_retrieving' => 'Gegevens ophalen',
    'serialize_document' => 'Het document weer in elkaar zetten',
    'send_document' => 'Het document naar u sturen',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'Samenvoegen',
    'convert' => 'Pdf samenvoegen',
    'multimerge' => 'Meerdere samenvoegen',
    'multimerge_convert' => 'Meerdere pdf&#39;s samenvoegen',
    'labelsgenerate' => 'Labels genereren',
    'labelsgenerate_convert' => 'Pdf labels genereren',
    'excel' => 'Excel samenvoegen',
    'excel_convert' => 'Samenvoeging Excel converteren',
    'presentation' => 'PowerPoint samenvoegen',
    'presentation_convert' => 'PowerPoint samenvoegen in pdf',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'Mijn accounts',
    'favorites' => 'Favoriete accounts',
    'tags' => 'Getagde accounts',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'Alle nieuws',
    'General' => 'Algemeen',
    'Finance' => 'Financieel',
    'People' => 'Personeel',
    'Press Releases' => 'Persberichten',
    'Other' => 'Overige gegevens',
];

$app_strings['LBL_OWNERS'] = 'Eigenaars';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Cloud Drive';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'Integratiedashlet Cloud Drive';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'Link kopiëren';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'Downloaden';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Sugar Document aanmaken';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'Kan dit bestand niet downloaden';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'Cloud dashlet niet aanwezig';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar-document aangemaakt';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'Stuur naar DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign is niet beschikbaar vanaf deze locatie.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'Documenten samenvoegen naar Word/Excel/PowerPoint is niet beschikbaar vanaf deze locatie';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'Documenten samenvoegen naar DocuSign is niet beschikbaar vanaf deze locatie';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'Documenten samenvoegen naar PDF is niet beschikbaar vanaf deze locatie';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'Uw ondertekende bestand wordt hier alleen geüpload als u toestemming heeft om op deze locatie te uploaden.';
$app_strings['LBL_DOC_MERGE_TO'] = 'Doc samenvoegen naar';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'Mijn bestanden';
$app_strings['LBL_SHARED_WITH_ME'] = 'Gedeeld met mij';
$app_strings['LBL_CLOUD_PROVIDER'] = 'Cloud-aanbieder';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'Gedeeld met mij';
$app_strings['LBL_MY_FILES'] = 'Mijn bestanden';
$app_strings['LBL_UPLOAD_FILE'] = 'Geüpload bestand';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'Map niet gevonden';
$app_strings['LBL_CREATE_FOLDER'] = 'Map aanmaken';
$app_strings['LBL_LOAD_MORE'] = 'Meer laden...';
$app_strings['LBL_NEW_FOLDER'] = 'Nieuwe map';
$app_strings['LBL_FOLDER_NAME'] = 'Naam map: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'U hebt geen toestemming om dat te doen op het huidige pad.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'U hebt geen toestemming om het huidige pad op te gaan.';
$app_strings['LBL_FILE_UPLOADED'] = 'Het bestand is geüpload.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'Vanwege de grote omvang van uw bestand duurt het uploaden een tijdje.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'Een of meer documentrecords hebben geen bijlage. Voeg bestanden toe aan de records en probeer het opnieuw of synchroniseer afzonderlijke specifieke records met bestanden.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Verbinding met Google niet gevonden...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Verbinding met Microsoft niet gevonden...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Verbinding met Dropbox niet gevonden...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'Synchronisatie met OneDrive kan een tijdje duren';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'Weet u zeker dat u dit bestand wilt verwijderen?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'Upload OneDrive is voltooid.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' is met succes geüpload.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'Fout tijdens laden paden.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'Er is een fout opgetreden omdat het bestand corrupt is.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'Het document <i>"{{documentName}}"</i> is opgeslagen op uw cloud drive en is toegevoegd aan de module Documenten.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'U heeft geen rechten om dit bestand te verwijderen.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'U heeft geen rechten om deze map te verwijderen.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'U heeft geen machtigingen om bestanden naar deze locatie te uploaden.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'U heeft geen machtigingen om een map op deze locatie te maken.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'Op deze locatie kunnen geen mappen worden gemaakt.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'Er kunnen geen bestanden naar deze locatie worden geüpload.';
$app_strings['LBL_SITES'] = 'Sites';
$app_strings['LBL_SHARED'] = 'Gedeeld';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'Link aangemaakt. Klik op de knop om de link naar uw klembord te kopiëren.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'Kopiëren naar klembord';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-leeg-',
    'Exact' => 'Precies',
    'Null_address_components' => 'Een of meerdere adrescomponenten zijn leeg',
    'Invalid_address' => 'Ongeldig adres, server retourneerde Fout',
    'Invalid_server_response_not_XML' => 'Ongeldige serverrespons, geen XML',
    'Invalid_address_no_location' => 'Ongeldig adres, server retourneerde geen locatie',
    'Ambiguous_address' => 'Dubbelzinnig adres, meerdere resultaten',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'Weg',
    'a' => 'Lucht',
    'rd' => 'Weg, donker',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '3',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'Engels (VS)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'New York (EST)'],
    ['pst', 'Los Angeles (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['Nieuw', 'Nieuw'],
    ['Toegewezen', 'Toegewezen'],
    ['Gesloten', 'Gesloten'],
    ['Wacht op input', 'Wacht op input'],
    ['Afgewezen', 'Afgewezen'],
    ['Dupliceren', 'Dupliceren'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['Beheer', 'Beheer'],
    ['Product', 'Product'],
    ['Gebruiker', 'Gebruiker'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'Hoog'],
    ['P2', 'Middel'],
    ['P3', 'Laag'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['gebruiker', 'Gebruiker'],
    ['admin,gebruiker', 'Beheer'],
    ['accountmanager, gebruiker', 'Accountmanager'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', 'Afgelopen 30 dagen'],
    ['last_90_days', 'Afgelopen 90 dagen'],
    ['this_year', 'Vorig jaar'],
    ['aangepast', 'Aangepast bereik'],
    ['alle', 'Alle'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['Standaard', 'Standaard'],
    ['Kleur', 'Effen kleur'],
    ['Url', 'Aangepaste afbeelding'],
];
