<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'Amerikansk Engelsk',
    'moduleList' => [
        'Home' => 'Hjem',
        'Contacts' => 'Kontakter',
        'Accounts' => 'Bedrifter',
        'Opportunities' => 'Muligheter',
        'Cases' => 'Saker',
        'Notes' => 'Noteringer',
        'Calls' => 'Oppringninger',
        'Emails' => 'E-post',
        'Meetings' => 'Møter',
        'Tasks' => 'Oppgaver',
        'Calendar' => 'Kalender',
        'Leads' => 'Emner',
        'Currencies' => 'Valuta',
        'Contracts' => 'Kontrakter',
        'Quotes' => 'Tilbud',
        'Products' => 'Produkter',
        'WebLogicHooks' => 'Web Logic Hooks',
        'ProductCategories' => 'Produktkategorier',
        'ProductTypes' => 'Produkttyper',
        'ProductTemplates' => 'Produktkatalog',
        'ProductBundles' => 'Produktpakker',
        'ProductBundleNotes' => 'Produktpakkenotater',
        'Reports' => 'Rapporter',
        'Forecasts' => 'Prognoser',
        'ForecastWorksheets' => 'Arbeidsplan for Prognoser',
        'ForecastManagerWorksheets' => 'Arbeidsflate for prognoser',
        'VisualPipeline' => 'Visuell pipeline',
        'ConsoleConfiguration' => 'Konsollkonfigurasjon',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'Budsjetter',
        'Teams' => 'Grupper',
        'TeamNotices' => 'Gruppemeldinger',
        'Manufacturers' => 'Produsenter',
        'Activities' => 'Aktiviteter',
        'Comments' => 'Kommentarer',
        'Subscriptions' => 'Abonnement',
        'Bugs' => 'Feil',
        'Feeds' => 'Nyhetsmatinger',
        'iFrames' => 'Mine portaler',
        'TimePeriods' => 'Tidsperioder',
        'TaxRates' => 'Skattesatser',
        'ContractTypes' => 'Kontraktstyper',
        'Schedulers' => 'Planleggere',
        'Project' => 'Prosjekter',
        'ProjectTask' => 'Prosjektoppgaver',
        'Campaigns' => 'Kampanjer',
        'CampaignLog' => 'Kampanjelogg',
        'CampaignTrackers' => 'Kampanjesporing',
        'Documents' => 'Dokumenter',
        'DocumentRevisions' => 'Dokumentrevisjoner',
        'Connectors' => 'Connectors',
        'Notifications' => 'Varsler',
        'Sync' => 'Synkronisér',
        'HintAccountsets' => 'HintKontosett',
        'HintNotificationTargets' => 'HintVarselMål',
        'HintNewsNotifications' => 'HintNyheterVarsler',
        'HintEnrichFieldConfigs' => 'HintUtvidFeltKonfigurasjoner',
        'ExternalUsers' => 'Eksterne brukere',
        'ReportMaker' => 'Virksomhetsrapporter',
        'DataSets' => 'Dataformater',
        'CustomQueries' => 'Tilpassede forespørsler',
        'pmse_Inbox' => 'Prosesser',
        'pmse_Project' => 'Prosessdefinisjoner',
        'pmse_Business_Rules' => 'Prosess forretning regel',
        'pmse_Emails_Templates' => 'E-postmalprosess',
        'BusinessCenters' => 'Forretningssentre',
        'Shifts' => 'Skift',
        'ShiftExceptions' => 'Skiftunntak',
        'Purchases' => 'Kjøp',
        'PurchasedLineItems' => 'Kjøpte varelinjer',
        'MobileDevices' => 'Mobileenheter',
        'PushNotifications' => 'Push-varslinger',
        'Escalations' => 'Opptrappinger',
        'DocumentTemplates' => 'Dokumentmaler',
        'DocumentMerges' => 'Dokumentsammenflettinger',
        'CloudDrivePaths' => 'Skydriverstier',
        'WorkFlow' => 'Workflow-definisjoner:',
        'EAPM' => 'Eksterne konto',
        'Worksheet' => 'Regneark',
        'Users' => 'Brukere',
        'Employees' => 'Ansatte',
        'Administration' => 'Administrering',
        'ACLRoles' => 'Roller',
        'InboundEmail' => 'Innstillinger for innkommende e-post',
        'Releases' => 'Utsendelser',
        'Prospects' => 'Prospekter',
        'Queues' => 'Køer',
        'EmailMarketing' => 'E-postmarkedsføring',
        'EmailTemplates' => 'E-postmaler',
        'SNIP' => 'Epost-arkivering',
        'ProspectLists' => 'Mållister',
        'SavedSearch' => 'Lagret søk',
        'UpgradeWizard' => 'Lad opp hjelp',
        'Trackers' => 'Sporinger',
        'TrackerPerfs' => 'Tracker egenskaper',
        'TrackerSessions' => 'Følgeøkter',
        'TrackerQueries' => 'Tracker forespørsler',
        'FAQ' => 'Ofte stilte spørsmål',
        'Newsletters' => 'Nyhetsbrev',
        'SugarFavorites' => 'Favoritter',
        'PdfManager' => 'PdfManager',
        'DataArchiver' => 'Dataarkiv',
        'ArchiveRuns' => 'Arkivkjøringer',

        'OAuthKeys' => 'OAuthKeys',
        'OAuthTokens' => 'OAuth-tokener',
        'Filters' => 'Filtere',
        'UserSignatures' => 'E-postsignaturer',
        'Shippers' => 'Avsenderleverandører',
        'Styleguide' => 'Stilguide',
        'Feedbacks' => 'Tilbakemelding',
        'Tags' => 'Etiketter',
        'Categories' => 'Kategorier',
        'Dashboards' => 'Hjem',
        'OutboundEmail' => 'E-post-innstillinger',
        'EmailParticipants' => 'E-postdeltakere',
        'DataPrivacy' => 'Personvern for data',
        'ReportSchedules' => 'Rapportplaner',
        'CommentLog' => 'Kommentarlogg',
        'Holidays' => 'Ferier',
        'ChangeTimers' => 'Endre timere',
        'Metrics' => 'Metrikk',
        'Messages' => 'Meldinger',
        'Audit' => 'Revidere',
        'RevenueLineItems' => 'Omsetningsposter',
        'DocuSignEnvelopes' => 'DocuSign omslag',
        'Geocode' => 'Geokoding',
        'DRI_Workflows' => 'Smart Guides',
        'DRI_Workflow_Task_Templates' => 'Aktivitetsmaler for Smart Guide',
        'DRI_SubWorkflows' => 'Smart Guide-faser',
        'DRI_Workflow_Templates' => 'Smart Guide-maler',
        'CJ_WebHooks' => 'Sugar Automate Web Hooks',
        'CJ_Forms' => 'Smart Guide Sugar-handlinger',
        'DRI_SubWorkflow_Templates' => 'Fasemaler for Smart Guide',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub Module Event Push-abonnementer',
    ],

    'moduleIconList' => [
        'Home' => 'Hjem',
        'Contacts' => 'Kontakter',
        'Accounts' => 'Kontoer',
        'Opportunities' => 'Muligheter',
        'Cases' => 'Saker',
        'Notes' => 'Notater',
        'Calls' => 'Samtaler',
        'Emails' => 'E-poster',
        'Meetings' => 'Møter',
        'Tasks' => 'Oppgaver',
        'Calendar' => 'Kalender',
        'Leads' => 'Leads',
        'Currencies' => 'Valutaer',
        'Contracts' => 'Kontrakter',
        'Quotes' => 'Pristilbud',
        'Products' => 'Produkter',
        'WebLogicHooks' => 'WL',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'Produkttyper',
        'ProductTemplates' => 'Produktmaler',
        'ProductBundles' => 'Produktpakker',
        'ProductBundleNotes' => 'PB',
        'Reports' => 'Rapporter',
        'Forecasts' => 'Prognoser',
        'ForecastWorksheets' => 'ForecastWorksheets',
        'ForecastManagerWorksheets' => 'FM',
        'Quotas' => 'Budsjett',
        'VisualPipeline' => 'VP',
        'ConsoleConfiguration' => 'CC',
        'SugarLive' => 'Søn',
        'Teams' => 'Teams',
        'TeamNotices' => 'TN',
        'Manufacturers' => 'Produsenter',
        'Activities' => 'Aktiviteter',
        'Comments' => 'Kommentarer',
        'Subscriptions' => 'Abonnementer',
        'Bugs' => 'Feil',
        'Feeds' => 'Feeder',
        'iFrames' => 'iFrames',
        'TimePeriods' => 'TP',
        'TaxRates' => 'TR',
        'ContractTypes' => 'CT',
        'Schedulers' => 'Planleggere',
        'Project' => 'Prosjekt',
        'ProjectTask' => 'PT',
        'Campaigns' => 'Kampagner',
        'CampaignLog' => 'CL',
        'CampaignTrackers' => 'CT',
        'Documents' => 'Dokumenter',
        'DocumentRevisions' => 'DR',
        'Connectors' => 'Konnektorer',
        'Notifications' => 'Varslinger',
        'Sync' => 'Synk',
        'HintAccountsets' => 'Hi',
        'HintNotificationTargets' => 'Hi',
        'HintNewsNotifications' => 'Hi',
        'HintEnrichFieldConfigs' => 'Hi',
        'ExternalUsers' => 'EU',
        'ReportMaker' => 'AR',
        'DataSets' => 'DF',
        'CustomQueries' => 'CQ',
        'pmse_Inbox' => 'Pr',
        'pmse_Project' => 'PD',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE',
        'BusinessCenters' => 'BC',
        'Shifts' => 'Skift',
        'ShiftExceptions' => 'SE',
        'Purchases' => 'Kjøp',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'Mo',
        'PushNotifications' => 'Pu',
        'Escalations' => 'Opptrappinger',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'SD',
        'WorkFlow' => 'WD',
        'EAPM' => 'EA',
        'Worksheet' => 'Arbeidsark',
        'Users' => 'Brukere',
        'Employees' => 'Ansatte',
        'Administration' => 'Administrasjon',
        'ACLRoles' => 'Ro',
        'InboundEmail' => 'IE',
        'Releases' => 'Versjoner',
        'Prospects' => 'Prospekter',
        'Queues' => 'Køer',
        'EmailMarketing' => 'EM',
        'EmailTemplates' => 'ET',
        'SNIP' => 'EA',
        'ProspectLists' => 'TL',
        'SavedSearch' => 'SS',
        'UpgradeWizard' => 'UW',
        'Trackers' => 'Sporere',
        'TrackerPerfs' => 'TP',
        'TrackerSessions' => 'TS',
        'TrackerQueries' => 'TQ',
        'FAQ' => 'Vanlige spørsmål',
        'Newsletters' => 'Nyhetsbrev',
        'SugarFavorites' => 'Fa',
        'PdfManager' => 'PM',
        'DataArchiver' => 'DA',
        'ArchiveRuns' => 'AR',
        'OAuthKeys' => 'OC',
        'OAuthTokens' => 'OT',
        'Filters' => 'Filtre',
        'UserSignatures' => 'ES',
        'Shippers' => 'Forsendere',
        'Styleguide' => 'Stilguide',
        'Feedbacks' => 'Tilbakemeldinger',
        'Tags' => 'Etiketter',
        'Categories' => 'Kategorier',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'ES',
        'EmailParticipants' => 'EP',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'RS',
        'CommentLog' => 'CL',
        'Holidays' => 'Ferier',
        'ChangeTimers' => 'CT',
        'Metrics' => 'Metrikk',
        'Messages' => 'Meldinger',
        'Audit' => 'Revisjon',
        'RevenueLineItems' => 'RL',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'Geokode',
        'DRI_Workflows' => 'SG',
        'DRI_Workflow_Task_Templates' => 'SG',
        'DRI_SubWorkflows' => 'SG',
        'DRI_Workflow_Templates' => 'SG',
        'CJ_WebHooks' => 'SA',
        'CJ_Forms' => 'SG',
        'DRI_SubWorkflow_Templates' => 'SG',
        'Library' => 'Bibliotek',
        'EmailAddresses' => 'EA',
        'Words' => 'Ord',
        'Sugar_Favorites' => 'Fa',
        'KBDocuments' => 'KB',
        'KBContents' => 'KB',
        'KBArticles' => 'KB',
        'KBContentTemplates' => 'KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'EF',
    ],

    'moduleListSingular' => [
        'Home' => 'Hjem',
        'Dashboards' => 'Hjem',
        'Styleguide' => 'Stilguide',
        'Contacts' => 'Kontakt',
        'Accounts' => 'Konto',
        'Opportunities' => 'Salgsmulighet',
        'Cases' => 'Sak',
        'Notes' => 'Notat',
        'Calls' => 'Opringning:',
        'Emails' => 'E-postadresse',
        'Meetings' => 'Møte',
        'Tasks' => 'Oppgave',
        'Calendar' => 'Kalender',
        'Leads' => 'Lead',
        'Manufacturers' => 'Produsent',
        'VisualPipeline' => 'VisualPipeline',
        'ConsoleConfiguration' => 'ConsoleConfiguration',
        'MobileDevices' => 'Mobilenhet',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'Kontrakt',
        'Quotes' => 'Tilbud',
        'Products' => 'Produkt',
        'ProductCategories' => 'Produktkategori',
        'ProductBundles' => 'Produktpakke',
        'ProductBundleNotes' => 'Produktpakkenotat',
        'RevenueLineItems' => 'Omsetningspost',
        'WebLogicHooks' => 'Web Logic Hook',
        'Reports' => 'Rapport',
        'Forecasts' => 'Prognose',
        'ForecastWorksheets' => 'Forcast-arbeidsplan',
        'ForecastManagerWorksheets' => 'Arbeidsflate for prognoser',
        'Quotas' => 'Budsjett',
        'Teams' => 'Gruppe',
        'TeamNotices' => 'Gruppemelding',
        'Activities' => 'Aktivitet',
        'ActivityStream' => 'Aktivitetstrøm',
        'Bugs' => 'Feil',
        'Feeds' => 'Nyhetsmatinger',
        'iFrames' => 'Mine portaler',
        'TimePeriods' => 'Tidsperiode',
        'TaxRates' => 'Skatteprosent',
        'ContractTypes' => 'Kontraktstype',
        'Schedulers' => 'Planlegger',
        'Campaigns' => 'Kampanje',
        'CampaignLog' => 'Kampanjelogg',
        'Project' => 'Prosjekt',
        'ProjectTask' => 'Prosjektoppgave',
        'Prospects' => 'Mål',
        'ProspectLists' => 'Målliste',
        'CampaignTrackers' => 'Kampanje Tracker',
        'Documents' => 'Dokument',
        'DocumentRevisions' => 'Dokumentrevisjon',
        'Connectors' => 'Connector',
        'Notifications' => 'Varsling',
        'Sync' => 'Synkronisér',
        'PdfManager' => 'PdfManager',
        'DataArchiver' => 'Dataarkiv',
        'ArchiveRuns' => 'Arkivkjøringer',
        'ExternalUsers' => 'Ekstern bruker',
        'ReportMaker' => 'Avanserte rapporter',
        'DataSets' => 'Dataformat',
        'CustomQueries' => 'Tilpasset forespørsel:',
        'pmse_Inbox' => 'Prosess',
        'pmse_Project' => 'Prosessdefinisjoner',
        'pmse_Business_Rules' => 'Prosess Forretnings regel',
        'pmse_Emails_Templates' => 'Process Email Mal',
        'BusinessCenters' => 'Forretningssenter',
        'Shifts' => 'Skift',
        'ShiftExceptions' => 'Skiftunntak',
        'Purchases' => 'Kjøp',
        'PurchasedLineItems' => 'Kjøpt varelinje',
        'PushNotifications' => 'Push-varsling',
        'Escalations' => 'Opptrapping',
        'DocumentTemplates' => 'Dokumentmal',
        'DocumentMerges' => 'Dokumentsammenfletting',
        'CloudDrivePaths' => 'Skydriversti',
        'WorkFlow' => 'Arbeidsflyt',
        'EAPM' => 'Ekstern konto',
        'Worksheet' => 'Regneark',
        'Users' => 'Bruker',
        'SugarFavorites' => 'Sugar Favoritter',
        'Employees' => 'Medarbeider',
        'Administration' => 'Administrering',
        'ACLRoles' => 'Rolle',
        'InboundEmail' => 'Innstillinger for innkommende e-post',
        'Releases' => 'Utgivelse',
        'Queues' => 'Kø',
        'EmailMarketing' => 'E-postmarkedsføring',
        'EmailTemplates' => 'E-post mal',
        'SNIP' => 'Epost-arkivering',
        'SavedSearch' => 'Lagret søk',
        'UpgradeWizard' => 'Lad opp hjelp',
        'Trackers' => 'Følger',
        'TrackerPerfs' => 'Tracker egenskaper',
        'TrackerSessions' => 'Tracker økter',
        'TrackerQueries' => 'Tracker forespørsel',
        'FAQ' => 'Ofte stilte spørsmål',
        'Newsletters' => 'Nyhetsbrev',
        'OAuthKeys' => 'OAuth-forbrukernøkkel',
        'OAuthTokens' => 'OAuth-token',
        'Filters' => 'Filter',
        'Comments' => 'Kommentar',
        'CommentLog' => 'Kommentarlogg',
        'Currencies' => 'Valuta',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'Produkttype',
        'Shippers' => 'Avsenderleverandør',
        'Subscriptions' => 'Abonnement',
        'UserSignatures' => 'E-postsignatur',
        'Feedbacks' => 'Tilbakemelding',
        'Tags' => 'Tag',
        'Categories' => 'Kategori',
        'OutboundEmail' => 'E-post-innstilling',
        'EmailParticipants' => 'E-postdeltaker',
        'DataPrivacy' => 'Personvern for data',
        'ReportSchedules' => 'Rapportplan',
        'Holidays' => 'Ferie',
        'ChangeTimers' => 'Endre timer',
        'Metrics' => 'Metrikk',
        'Messages' => 'Melding',
        'Audit' => 'Revidere',
        'DocuSignEnvelopes' => 'DocuSignOmslag',
        'HintAccountsets' => 'HintKontosett',
        'HintNotificationTargets' => 'HintVarselMål',
        'HintNewsNotifications' => 'HintNyheterVarsler',
        'HintEnrichFieldConfigs' => 'HintUtvidFeltKonfigurasjoner',
        'Geocode' => 'Geokoding',
        'DRI_Workflows' => 'Smart Guide',
        'DRI_Workflow_Task_Templates' => 'Mal for Smart Guide-aktivitet',
        'DRI_SubWorkflows' => 'Smart Guide-fase',
        'DRI_Workflow_Templates' => 'Mal for Smart Guide',
        'CJ_WebHooks' => 'Sugar Automate Web Hook',
        'CJ_Forms' => 'Smart Guide Sugar-handling',
        'DRI_SubWorkflow_Templates' => 'Fasemal for Smart Guide',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub Module Event Push-abonnement',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'Ja',
        '2' => 'Nei',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'Nei',
        1 => 'Ja',
    ],

    'notifications_status_dom' => [
        0 => 'Ulest',
        1 => 'Lest',
    ],

    'optout_dom' => [
        '' => '-ingen-',
        'false' => 'Nei',
        'true' => 'Ja',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'Analytiker',
        'Competitor' => 'Konkurrent',
        'Customer' => 'Kunde',
        'Integrator' => 'Integrator',
        'Investor' => 'Investor',
        'Partner' => 'Partner',
        'Press' => 'Presse',
        'Prospect' => 'Prospekt',
        'Reseller' => 'Distributør',
        'Other' => 'Andre',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'Tøy',
        'Banking' => 'Banktjenester',
        'Biotechnology' => 'Bioteknologi',
        'Chemicals' => 'Kjemi',
        'Communications' => 'Kommunikasjon',
        'Construction' => 'Bygg',
        'Consulting' => 'Rådgivning',
        'Education' => 'Utdanning',
        'Electronics' => 'Elektronikk',
        'Energy' => 'Energi',
        'Engineering' => 'Ingeniør',
        'Entertainment' => 'Underholdning',
        'Environmental' => 'Miljø',
        'Finance' => 'Finans',
        'Government' => 'Regjering',
        'Healthcare' => 'Helse',
        'Hospitality' => 'Reiseliv',
        'Insurance' => 'Forsikring',
        'Machinery' => 'Maskin',
        'Manufacturing' => 'Produksjon',
        'Media' => 'Media',
        'Not For Profit' => 'Pro bono',
        'Recreation' => 'Sport og fritid',
        'Retail' => 'Handel',
        'Shipping' => 'Skipsfart',
        'Technology' => 'Teknologi',
        'Telecommunications' => 'Telekommunikasjon',
        'Transportation' => 'Transport',
        'Utilities' => 'Gass og vann',
        'Other' => 'Andre',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF og CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'Diagram',
        'Data Table' => 'Datatabell',
        'Chart and Data Table' => 'Diagram og datatabell',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'Pågår',
        'Completed' => 'Fullført',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'Inngående',
        'Outbound' => 'Utgående',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'Chat',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'Lag 1',
        'T2' => 'Lag 2',
        'T3' => 'Lag 3',
        'T4' => 'Lag 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nei',
        'Completed' => 'Fullført',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'Fremtid',
        'Active' => 'Aktiv',
        'Past' => 'Tidligere',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'Selv-generert',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'Cold call',
        'Existing Customer' => 'Eksisterende kunde',
        'Self Generated' => 'Selv-generert',
        'Employee' => 'Medarbeider',
        'Partner' => 'Partner',
        'Public Relations' => 'PR',
        'Direct Mail' => 'Direktepost',
        'Conference' => 'Konferanse',
        'Trade Show' => 'Varemesse',
        'Web Site' => 'Webside',
        'Word of mouth' => 'Jungeltelegrafen',
        'Email' => 'E-postadresse',
        'Campaign' => 'Kampanje',
        'Support Portal User Registration' => 'Support Portal Brukerregistrering',
        'Other' => 'Andre',
    ],
    'metric_status_dom' => [
        'Inactive' => 'Inaktiv',
        'Active' => 'Aktiv',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'Eksisterende virksomhet',
        'New Business' => 'Ny virksomhet',
    ],
    'taxrate_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
    ],
    'roi_type_dom' => [
        'Revenue' => 'Omsetning',
        'Investment' => 'Investering',
        'Expected_Revenue' => 'Forventede inntekter',
        'Budget' => 'Budsjett',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'Primær beslutningstaker',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primær beslutningstaker',
        'Business Decision Maker' => 'Bedriftens beslutningstaker',
        'Business Evaluator' => 'Bedrifts evaluator',
        'Technical Decision Maker' => 'Teknisk beslutningstaker',
        'Technical Evaluator' => 'Teknisk evaluator',
        'Executive Sponsor' => 'Utøvende sponsor',
        'Influencer' => 'Påvirker',
        'Other' => 'Andre',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
    ],

    'shipper_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'Primærkontakt',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'Primærkontakt',
        'Alternate Contact' => 'Alternativ kontaktperson',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'Ved siden av feltverdi',
        'field_on_top' => 'Over feltverdi',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'Netto 15',
        'Net 30' => 'Netto 30',
    ],
    'sales_stage_default_key' => 'Prospektering',
    'fts_type' => [
        'Elastic' => 'ElastiskSøk',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'Prospektering',
        'Qualification' => 'Kvalifisering',
        'Needs Analysis' => 'Behovsanalyse',
        'Value Proposition' => 'Verdimålsetning',
        'Id. Decision Makers' => 'Id. Beslutningstakere',
        'Perception Analysis' => 'Oppfatnings analyse',
        'Proposal/Price Quote' => 'Forslag/Pris tilbud',
        'Negotiation/Review' => 'Forhandling/Gjennomgang',
        'Closed Won' => 'Lukket Vunnet',
        'Closed Lost' => 'Lukket Mistet',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'Ny',
        'In Progress' => 'Under utførelse',
        'Closed Won' => 'Lukket Vunnet',
        'Closed Lost' => 'Lukket Mistet',
        'Converted to Quote' => 'Konvertert til tilbud',
    ],
    'sales_status_dom' => [
        'New' => 'Ny',
        'In Progress' => 'Under utførelse',
        'Closed Won' => 'Lukket Vunnet',
        'Closed Lost' => 'Lukket Mistet',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'Inkluder',
        'exclude' => 'Ekskluder',
    ],
    'commit_stage_dom' => [
        'include' => 'Inkluder',
        'upside' => 'Opp',
        'exclude' => 'Ekskluder',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'Inkluder',
        'upside' => 'Opp',
        'exclude' => 'Ekskluder',
    ],

    'in_total_group_stages' => [
        'Draft' => 'Utkast',
        'Negotiation' => 'Forhandling',
        'Delivered' => 'Levert',
        'On Hold' => 'På vent',
        'Confirmed' => 'Bekreftet',
        'Closed Accepted' => 'Lukket Akseptert',
        'Closed Lost' => 'Lukket Mistet',
        'Closed Dead' => 'Lukket Inaktiv',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'Opringning:',
        'Meeting' => 'Møte',
        'Task' => 'Oppgave',
        'Email' => 'E-postadresse',
        'Note' => 'Notat',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'Hr.',
        'Ms.' => 'Frk.',
        'Mrs.' => 'Fru.',
        'Dr.' => 'Dr.',
        'Prof.' => 'Prof.',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'Ingen',
        60 => '1 minutt Før',
        300 => '5 minutter Før',
        600 => '10 Minutter Før',
        900 => '15 Minutter Før',
        1800 => '30 Minutter Før',
        3600 => '1 Time Før',
        7200 => '2 Timer Før',
        10800 => '3 timer Før',
        18000 => '5 Timer Før',
        86400 => '1 Dag Før',
        ],

        'task_priority_default' => 'Medium',
        'task_priority_dom' => [
        'High' => 'Høy',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'task_status_default' => 'Ikke begynt',
        'task_status_dom' => [
        'Not Started' => 'Ikke begynt',
        'In Progress' => 'Under utførelse',
        'Completed' => 'Fullført',
        'Pending Input' => 'Venter på informasjon',
        'Deferred' => 'Utsatt',
        'Not Applicable' => 'Ikke aktuelt',
        ],
        'meeting_status_default' => 'Planlagt',
        'meeting_status_dom' => [
        'Planned' => 'Planlagt',
        'Held' => 'Avholdt',
        'Not Held' => 'Kansellert',
        'Deferred' => 'Utsatt',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'Andre',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'Planlagt',
        'call_status_dom' => [
        'Planned' => 'Planlagt',
        'In Progress' => 'Under utførelse',
        'Held' => 'Avholdt',
        'Not Held' => 'Kansellert',
        'Deferred' => 'Utsatt',
        ],
        'call_direction_default' => 'Utgående',
        'call_direction_dom' => [
        'Inbound' => 'Inngående',
        'Outbound' => 'Utgående',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'Ny',
        'Assigned' => 'Tildelt',
        'In Process' => 'I kø?',
        'Converted' => 'Konvertert',
        'Recycled' => 'Gjenvunnet',
        'Dead' => 'Inaktiviv',
        ],
        'gender_list' => [
        'male' => 'Mann',
        'female' => 'Kvinne',
        'other' => 'Annet',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'Ny',
        'case_status_dom' => [
        'New' => 'Ny',
        'Assigned' => 'Tildelt',
        'Closed' => 'Lukket',
        'Pending Input' => 'Venter på informasjon',
        'Rejected' => 'Avvist',
        'Duplicate' => 'Dupliser',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'Høy',
        'P2' => 'Medium',
        'P3' => 'Lav',
        ],
        'user_type_dom' => [
        'RegularUser' => 'Vanlig bruker',
        'Administrator' => 'Administrator',
        ],
        'user_type_bool_dom' => [
            false => 'Vanlig bruker',
            true => 'Administrator',
        ],
        'user_type_group_bool_dom' => [
            true => 'Gruppebruker',
        ],
        'user_type_portal_bool_dom' => [
            true => 'Portal API-bruker',
        ],
        'license_type_dom' => [
        'CURRENT' => 'Gjeldende produkt',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Passiv',
        ],
        'employee_status_dom' => [
        'Active' => 'Aktiv',
        'Terminated' => 'Avsluttet',
        'Leave of Absence' => 'Permisjon',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'Aktive',
        'Inactive' => 'Inaktiv',
        ],
        'project_task_priority_options' => [
        'High' => 'Høy',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'project_task_priority_default' => 'Medium',

        'project_task_status_options' => [
        'Not Started' => 'Ikke begynt',
        'In Progress' => 'Under utførelse',
        'Completed' => 'Fullført',
        'Pending Input' => 'Venter på informasjon',
        'Deferred' => 'Utsatt',
        ],
        'project_task_utilization_options' => [
        '0' => 'ingen',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'Utkast',
        'In Review' => 'Under gjennomgang',
        'Published' => 'Publisert',
        ],
        'project_status_default' => 'Utkast',

        'project_duration_units_dom' => [
        'Days' => 'Dager',
        'Hours' => 'Timer',
        ],

        'project_priority_options' => [
        'High' => 'Høy',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'project_priority_default' => 'Medium',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Bedrifter',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'Konto',
        'Opportunities' => 'Muligheter',
        'Cases' => 'Sak',
        'Leads' => 'Lead',
        'Contacts' => 'Kontakter', // cn (11/22/2005) added to support Emails
        'Products' => 'Produkt',
        'Quotes' => 'Tilbud',
        'Bugs' => 'Feil',
        'Project' => 'Prosjekt',

        'Prospects' => 'Mål',
        'ProjectTask' => 'Prosjektoppgave',

        'Tasks' => 'Oppgave',
        'KBContents' => 'KB-dokumenter',
        'Notes' => 'Notat',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Opportunities' => 'Muligheter',
        'Tasks' => 'Oppgave',
        'ProductTemplates' => 'Produktkatalog',
        'Quotes' => 'Tilbud',
        'Products' => 'Produkt',
        'Contracts' => 'Kontrakt',
        'Emails' => 'E-postadresse',

        'Bugs' => 'Feil',
        'Project' => 'Prosjekt',
        'ProjectTask' => 'Prosjektoppgave',
        'Prospects' => 'Mål',
        'Cases' => 'Sak',
        'Leads' => 'Lead',

        'Meetings' => 'Møte',
        'Calls' => 'Opringning:',
        'KBContents' => 'KB-dokumenter',
        'PurchasedLineItems' => 'Kjøpt varelinje',
        'Purchases' => 'Kjøp',
        'Escalations' => 'Opptrapping',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Employees' => 'Medarbeider',
        'Leads' => 'Emne',
        'Prospects' => 'Mål',
        'Users' => 'Bruker',
        ],

        'parent_type_display' => [
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Tasks' => 'Oppgave',
        'Opportunities' => 'Muligheter',
        'Products' => 'Produkt',
        'Quotes' => 'Tilbud',

        'Bugs' => 'Feil',
        'Cases' => 'Sak',
        'Leads' => 'Lead',

        'Project' => 'Prosjekt',
        'ProjectTask' => 'Prosjektoppgave',

        'Prospects' => 'Mål',
        'KBContents' => 'KB-dokumenter',
        'Notes' => 'Notat',
        'PurchasedLineItems' => 'Kjøpt varelinje',
        'Purchases' => 'Kjøp',
        'Escalations' => 'Opptrapping',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'Sak',
        ],

        'product_status_default_key' => 'Sendt',
        'product_status_quote_key' => 'Tilbud',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'Tilbudsført',
        'Orders' => 'Bestilt',
        'Ship' => 'Sendt',
        ],
        'active_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        'Retired' => 'Avviklet',
        ],
        'appearance_options' => [
        'system_default' => 'Bruk systeminnstilling',
        'light' => 'Lys',
        'dark' => 'Mørk',
        ],


        'pricing_formula_default_key' => 'Fast',
        'pricing_formula_dom' => [
        'Fixed' => 'Fastpris',
        'ProfitMargin' => 'Profittmargin',
        'PercentageMarkup' => 'Markup over kostnad',
        'PercentageDiscount' => 'Rabatt fra listen',
        'IsList' => 'Samme som listen',
        ],
        'product_template_status_dom' => [
        'Available' => 'På lager',
        'Unavailable' => 'Ikke på lager',
        ],
        'tax_class_dom' => [
        'Taxable' => 'Skattepliktig',
        'Non-Taxable' => 'Ikke- skattepliktig',
        ],
        'support_term_dom' => [
        '+6 months' => '6 måneder',
        '+1 year' => '1 år',
        '+2 years' => '2 år',
        ],

        'quote_type_dom' => [
        'Quotes' => 'Tilbud',
        'Orders' => 'Ordre',
        ],
        'default_quote_stage_key' => 'Utkast',
        'quote_stage_dom' => [
        'Draft' => 'Utkast',
        'Negotiation' => 'Forhandling',
        'Delivered' => 'Levert',
        'On Hold' => 'På vent',
        'Confirmed' => 'Bekreftet',
        'Closed Accepted' => 'Lukket Akseptert',
        'Closed Lost' => 'Lukket Mistet',
        'Closed Dead' => 'Lukket Inaktiv',
        ],
        'default_order_stage_key' => 'Ventende',
        'order_stage_dom' => [
        'Pending' => 'Ventende',
        'Confirmed' => 'Bekreftet',
        'On Hold' => 'På vent',
        'Shipped' => 'Sendt',
        'Cancelled' => 'Kansellert',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'Primær beslutningstaker',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primær beslutningstaker',
        'Business Decision Maker' => 'Bedriftens beslutningstaker',
        'Business Evaluator' => 'Bedrifts evaluator',
        'Technical Decision Maker' => 'Teknisk beslutningstaker',
        'Technical Evaluator' => 'Teknisk evaluator',
        'Executive Sponsor' => 'Utøvende sponsor',
        'Influencer' => 'Påvirker',
        'Other' => 'Andre',
        ],
        'layouts_dom' => [
        'Standard' => 'Tilbud',
        'Invoice' => 'Regning',
        ],
        'issue_priority_default_key' => 'Medium',
        'issue_priority_dom' => [
        'Urgent' => 'Haster',
        'High' => 'Høy',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'Godtatt',
        'Duplicate' => 'Dupliser',
        'Closed' => 'Lukket',
        'Out of Date' => 'Foreldet',
        'Invalid' => 'Ugyldig',
        ],

        'issue_status_default_key' => 'Ny',
        'issue_status_dom' => [
        'New' => 'Ny',
        'Assigned' => 'Tildelt',
        'Closed' => 'Lukket',
        'Pending' => 'Ventende',
        'Rejected' => 'Avvist',
        ],

        'bug_priority_default_key' => 'Medium',
        'bug_priority_dom' => [
        'Urgent' => 'Haster',
        'High' => 'Høy',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'Godtatt',
        'Duplicate' => 'Dupliser',
        'Fixed' => 'Fast',
        'Out of Date' => 'Foreldet',
        'Invalid' => 'Ugyldig',
        'Later' => 'Senere',
        ],
        'bug_status_default_key' => 'Ny',
        'bug_status_dom' => [
        'New' => 'Ny',
        'Assigned' => 'Tildelt',
        'Closed' => 'Lukket',
        'Pending' => 'Ventende',
        'Rejected' => 'Avvist',
        ],
        'bug_type_default_key' => 'Feil',
        'bug_type_dom' => [
        'Defect' => 'Defekt',
        'Feature' => 'Funksjon',
        ],
        'case_type_dom' => [
        'Administration' => 'Administrering',
        'Product' => 'Produkt',
        'User' => 'Bruker',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'E-postadresse',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'E-postadresse',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        'Phone' => 'Telefon',
        'Chat' => 'Chat',
        'Chatbot' => 'Chatbot',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'Forespørsel om Datasikkerhetspolitikk',
        'Send Personal Information being processed' => 'Sende personlige opplysninger behandles',
        'Rectify Information' => 'Korrigere informasjon',
        'Request to Erase Information' => 'Forespørsel om å slette informasjon',
        'Export Information' => 'Eksporter informasjon',
        'Restrict Processing' => 'Begrense behandling',
        'Object to Processing' => 'Objektet til behandling',
        'Consent to Process' => 'Samtykke til behandling',
        'Withdraw Consent' => 'Trekke samtykke',
        'Other' => 'Andre',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'Forretningskommunikasjon',
        'Marketing Communications by company' => 'Markedskommunikasjon av selskapet',
        'Marketing Communications by partners' => 'Markedskommunikasjon av partnere',
        ],
        'dataprivacy_status_default_key' => 'Åpne',
        'dataprivacy_status_dom' => [
        'Open' => 'Åpne',
        'Closed' => 'Fullført',
        'Rejected' => 'Avvist',
        ],
        'dataprivacy_priority_default_key' => 'Lav',
        'dataprivacy_priority_dom' => [
        'Low' => 'Lav',
        'Medium' => 'Medium',
        'High' => 'Høy',
        ],
        'business_day_status_dom' => [
        'Open' => 'Åpen',
        'Open 24 Hours' => 'Åpen 24 timer',
        'Closed' => 'Lukket',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'Bedrifter',
        'Activities' => 'Aktiviteter',
        'Bug Tracker' => 'Feilfølging',
        'Calendar' => 'Kalender',
        'Calls' => 'Oppringninger',
        'Campaigns' => 'Kampanjer',
        'Cases' => 'Saker',
        'Contacts' => 'Kontakter',
        'Currencies' => 'Valuta',
        'Dashboard' => 'Instrumentpanel',
        'Documents' => 'Dokumenter',
        'Emails' => 'E-post',
        'Feeds' => 'Strømmer',
        'Forecasts' => 'Prognoser',
        'Help' => 'Hjelp',
        'Home' => 'Hjem',
        'Leads' => 'Emner',
        'Meetings' => 'Møter',
        'Notes' => 'Noteringer',
        'Opportunities' => 'Muligheter',
        'Outlook Plugin' => 'Outlook-programtillegg',
        'Product Catalog' => 'Produktkatalog',
        'Products' => 'Produkter',
        'RevenueLineItems' => 'Omsetning linjeelementer',
        'Projects' => 'Prosjekter',
        'Quotes' => 'Tilbud',
        'Releases' => 'Utsendelser',
        'RSS' => 'Nyhetsmatinger',
        'Studio' => 'Studio',
        'Upgrade' => 'Oppgradér',
        'Users' => 'Brukere',
        'OutboundEmail' => 'E-post-innstillinger',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'Planlegging',
        'Active' => 'Aktiv',
        'Inactive' => 'Passiv',
        'Complete' => 'Komplett',
        'In Queue' => 'I kø',
        'Sending' => 'Sender',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'Telesalg',
        'Mail' => 'Post',
        'Email' => 'E-postadresse',
        'Print' => 'Skriv ut',
        'Web' => 'Web',
        'Radio' => 'Radio',
        'Television' => 'TV',
        'NewsLetter' => 'Nyhetsbrev',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'Ukentlig',
        'Monthly' => 'Månedlig',
        'Quarterly' => 'Kvartalsvis',
        'Annually' => 'Årlig',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'Januar',
        '2' => 'Februar',
        '3' => 'Mars',
        '4' => 'April',
        '5' => 'Mai',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'August',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'Desember',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'Jan',
        '2' => 'Feb',
        '3' => 'Mar',
        '4' => 'Apr',
        '5' => 'Mai',
        '6' => 'Jun',
        '7' => 'Jul',
        '8' => 'Aug',
        '9' => 'Sep',
        '10' => 'Okt',
        '11' => 'Nov',
        '12' => 'Des',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'Søndag',
        '2' => 'Mandag',
        '3' => 'Tirsdag',
        '4' => 'Onsdag',
        '5' => 'Torsdag',
        '6' => 'Fredag',
        '7' => 'Lørdag',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'Søn',
        '2' => 'Man',
        '3' => 'Tirs',
        '4' => 'Ons',
        '5' => 'Tors',
        '6' => 'Fre',
        '7' => 'Lør',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'Søn',
        '2' => 'Man',
        '3' => 'Tir',
        '4' => 'Ons',
        '5' => 'Tor',
        '6' => 'Fre',
        '7' => 'Lør',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'Søn',
        '1' => 'Man',
        '2' => 'Tirs',
        '3' => 'Ons',
        '4' => 'Tors',
        '5' => 'Fre',
        '6' => 'Lør',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'am',
        'pm' => 'pm',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => 'Rader og kolonner',
        'summary' => 'Sammendrag',
        'detailed_summary' => 'Summering med detaljer',
        'Matrix' => 'Matrix',
        ],


        'dom_email_types' => [
        'out' => 'Sendt',
        'archived' => 'Arkivert',
        'draft' => 'Utkast',
        'inbound' => 'Inngående',
        'campaign' => 'Kampanje',
        ],
        'dom_email_status' => [
        'archived' => 'Arkivert',
        'closed' => 'Lukket',
        'draft' => 'I utkast',
        'read' => 'Lest',
        'replied' => 'Svart',
        'sent' => 'Sendt',
        'send_error' => 'Mislykket sending',
        'unread' => 'Ulest',
        ],
        'dom_email_archived_status' => [
        'archived' => 'Arkivert',
        ],

        'dom_email_server_type' => ['' => '--Ingen--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--Ingen--',
        'createcase' => 'Opprett sak',
        'bounce' => 'Bounce håndtering',
        ],
        'dom_email_distribution' => ['' => '--Ingen--',
        'direct' => 'Direkte tildeling',
        'roundRobin' => 'Round-Robin',
        'leastBusy' => 'MInst opptatt',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'Round-Robin',
        'leastBusy' => 'MInst opptatt',
        'none' => 'Ingen',
        ],
        'dom_email_errors' => [1 => 'Velg kun en bruker når du benytter Direkte tildeling av poster.',
        2 => 'Du må tildele kun avkryssede poster når du benytter Dirkete tildeling av poster.',
        ],
        'dom_email_bool' => ['bool_true' => 'Ja',
        'bool_false' => 'Nei',
        ],
        'dom_int_bool' => [1 => 'Ja',
        0 => 'Nei',
        ],
        'dom_switch_bool' => ['on' => 'Ja',
        'off' => 'Nei',
        '' => 'Nei',],

        'dom_email_link_type' => ['sugar' => 'Sugar email klient',
        'mailto' => 'Ekstern email klient'],


        'dom_email_editor_option' => ['' => 'Standard e-post format',
        'html' => 'HTML E-post',
        'plain' => 'Plain e-post tekst'],

        'schedulers_times_dom' => ['not run' => 'Tidligere Run Time, ikke utført',
        'ready' => 'Klar',
        'in progress' => 'Under utførelse',
        'failed' => 'Mislyktes',
        'completed' => 'Fullført',
        'no curl' => 'Ikke kjørt: Ingen cURL tilgjengelig',
        ],

        'dom_email_states' => [
        'Draft' => 'Utkast',
        'Archived' => 'Arkivert',
        ],

        'dom_email_direction' => [
        'Unknown' => 'Ukjent',
        'Outbound' => 'Utgående',
        'Inbound' => 'Inngående',
        'Internal' => 'Intern',
        ],

        'scheduler_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Passiv',
        ],

        'scheduler_period_dom' => [
        'min' => 'Minutter',
        'hour' => 'Timer',
        ],
        'forecast_type_dom' => [
        'Direct' => 'Direkte',
        'Rollup' => 'Rollup',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'Markedsføring',
        'Knowledge Base' => 'Kunnskapsbase',
        'Sales' => 'Salgsside',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'Markedsmateriell',
        'Product Brochures' => 'Produktark',
        'FAQ' => 'Ofte stilte spørsmål',
        ],

        'document_status_dom' => [
        'Active' => 'Aktiv',
        'Draft' => 'Utkast',
        'FAQ' => 'Ofte stilte spørsmål',
        'Expired' => 'Foreldet',
        'Under Review' => 'Til vurdering',
        'Pending' => 'Ventende',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'E-post-fusjon',
        'eula' => 'Lisensavtale for sluttbruker',
        'nda' => 'NDA',
        'license' => 'Lisensavtale',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'Aksepter',
        'decline' => 'Avslå',
        'tentative' => 'Tentativ',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'Godtatt',
        'decline' => 'Avslått',
        'tentative' => 'Tentativ',
        'none' => 'Ingen',
        ],
        'dataset_output_default_dom' => [
        'table' => 'Tabell',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'Singel modul',
        'Multi Module' => 'Multi modul',
        ],
        'report_align_dom' => [
        'left' => 'Venstre',
        'center' => 'Midten',
        'right' => 'Høyre',
        ],

        'width_type_dom' => [
        '%' => 'Prosent (%)',
        'px' => 'Piksler (px)',
        ],
        'report_color_dom' => [
        '' => 'Forhåndsinnstilt',
        'black' => 'Sort',
        'green' => 'Grønn',
        'blue' => 'Blå',
        'red' => 'Rød',
        'white' => 'Hvit',
        'DarkGreen' => 'Mørkegrønn',
        'LightGray' => 'Lysegrå',
        'DodgerBlue' => 'Mørkeblå',
        'LightBlue' => 'Lyseblå',
        ],
        'font_size_dom' => [
        '-5' => 'Mindre (-5)',
        '-4' => 'Mindre (-4)',
        '-3' => 'Mindre (-3)',
        '-2' => 'Mindre (-2)',
        '-1' => 'Mindre (-1)',
        'Default' => 'Forhåndsinnstilt',
        '1' => 'Større (+1)',
        '2' => 'Større (+2)',
        '3' => 'Større (+3)',
        '4' => 'Større (+4)',
        '5' => 'Større (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'Hovedforespørsel',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'Visning',
//  'Group By' => 'Group By',
        'Calculation' => 'Beregning',
        ],
        'query_display_type_dom' => [
        'Default' => 'Forhåndsinnstilt',
        'Custom' => 'Tilpasset',
        'Hidden' => 'Skjult',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'Dag',
        'Week' => 'Uke',
        'Month' => 'Måned',
        'Quarter' => 'Kvartal',
        'Year' => 'År',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'Nå',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'Sum',
        'AVG' => 'Gjennomsnittlig',
        'COUNT' => 'Tell',
        'STDDEV' => 'Standard avvik',
        'VARIANCE' => 'Avvik',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'Standard felt',
        'Time' => 'Tidsintervall',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'Rekker (Y-akse)',
        'Columns' => 'Kolonner (X-akse)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'Sum (Total)',
        'AVG' => 'Gjennomsnitt',
        'MAX' => 'Maksimalt',
        'MIN' => 'Minimalt',
        'COUNT' => 'Tell',
        'STDDEV' => 'Standard avvik',
        'VARIANCE' => 'Avvik',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'Standard',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'Matte kalk.',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'Felt',
        'Value' => 'Verdi',
        'Group' => 'Gruppe',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'Kolonne',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'Deaktivert',
        'Enabled' => 'Aktivert',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'Normal',
        'Scalar' => 'Skala',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'Tekst',
        'Accounting' => 'Regnskap',
        'Date' => 'Dato',
        'Datetime' => 'Datotid',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'År',
        'Quarter' => 'Kvartal',
        'Month' => 'Måned',
        'Week' => 'Uke',
        'Day' => 'Dag',
        ],
        'dataset_style_dom' => [
        'normal' => 'Normal',
        'bold' => 'Fet',
        'italic' => 'Kursiv',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) Pluss',
        '-' => '(-) Minus',
        '*' => '(x) Ganger med',
        '/' => '(/) Delt på',
        ],
        'wflow_type_dom' => [
        'Normal' => 'Når posten ble lagret',
        'Time' => 'Etter at tiden utløper',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Er',
        'in' => 'Er en av',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'Er en av',
        'not_in' => 'Er ikke en av',
        ],
        'cselect_type_dom' => [
        'Equals' => 'Jevnbyrdige',
        'Does not Equal' => 'Er ikke jevnbyrdige',
        ],
        'dselect_type_dom' => [
        'Equals' => 'Jevnbyrdige',
        'Less Than' => 'Mindre enn',
        'More Than' => 'Mer enn',
        'Does not Equal' => 'Er ikke lik',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'Ja',
        'bool_false' => 'Nei',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'Jevnbyrdige',
        ],
        'tselect_type_dom' => [
        '0' => '0 timer',
        '14440' => '4 timer',
        '28800' => '8 timer',
        '43200' => '12 timer',
        '86400' => '1 dag',
        '172800' => '2 dager',
        '259200' => '3 dager',
        '345600' => '4 dager',
        '432000' => '5 dager',
        '604800' => '1 uke',
        '1209600' => '2 uker',
        '1814400' => '3 uker',
        '2592000' => '30 dager',
        '5184000' => '60 dager',
        '7776000' => '90 dager',
        '10368000' => '120 dager',
        '12960000' => '150 dager',
        '15552000' => '180 dager',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'var mer enn',
        'Less Than' => 'er mindre enn',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'E-postadresse',
        'Invite' => 'Invitere',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'Normal beskjed',
        'Custom Template' => 'Tilpasset mal',
        'System Default' => 'Forhåndsinnstillinger for system',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'Nåværende brukere',
        'rel_user' => 'Relaterte brukere',
        'rel_user_custom' => 'Relatert tilpasset bruker',
        'specific_team' => 'Spesifikk team',
        'specific_role' => 'Spesifikk rolle',
        'specific_user' => 'Spesifikk bruker',
        ],
        'wflow_array_type_dom' => [
        'future' => 'Ny verdi',
        'past' => 'Gammel verdi',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'Bruker',
        'Manager' => "Brukers manager",
        ],
        'wflow_address_type_dom' => [
        'to' => 'Til:',
        'cc' => 'Kopi:',
        'bcc' => 'Blindkopi:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'Til:',
        'cc' => 'Kopi:',
        'bcc' => 'Blindkopi:',
        'invite_only' => '(Inviter kun)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'Til:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'Oppdater post',
        'update_rel' => 'Oppdater relatert post',
        'new' => 'Ny post',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'Utløst dato',
        'Existing Value' => 'Eksisterende verdi',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'Grunnleggende alternativer',
        'Advanced' => 'Avanserte innstillinger',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'Bruker tildelt til utløst post',
        'modified_user_id' => 'Bruker som sist endret utløst post',
        'created_by' => 'Bruker som opprettet utløst post',
        'current_user' => 'Innlogget bruker',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'Team fra innlogget bruker',
        'team_set_id' => 'Nåværende gruppesett av utløste poster',
        'current_team' => 'Nåværende team på utløst post',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'Flytt dropdown tilbake med',
        'advance' => 'Flytt dropdown fremover med',
        ],
        'wflow_record_type_dom' => [
        'All' => 'Nye og oppdaterte poster',
        'New' => 'Kun nye poster',
        'Update' => 'Kun oppdaterte poster',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'Alle relaterte',
        //'first' => 'The first related',
        'filter' => 'Filter relaterte',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'Alle relaterte',
        'any' => 'Andre relaterte',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'Varsler deretter Handlinger',
        'actions_alerts' => 'Handlinger og deretter varsel'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'Ingen',
        'Daily' => 'Daglig',
        'Weekly' => 'Ukentlig',
        'Monthly' => 'Månedlig',
        'Yearly' => 'Årlig',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'Dager',
        'Weekly' => 'Uke(r)',
        'Monthly' => 'Måned(er)',
        'Yearly' => 'År',
        ],

        'repeat_end_types' => [
        'Until' => 'Til',
        'Occurrences' => 'Forekomster',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'Ingen',
        'Each' => 'Hver',
        'On' => 'På den/det',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'første',
        'second' => 'andre',
        'third' => 'tredje',
        'fourth' => 'fjerde',
        'fifth' => 'femte',
        'last' => 'siste',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'Søndag',
        'Mon' => 'Mandag',
        'Tue' => 'Tirsdag',
        'Wed' => 'Onsdag',
        'Thu' => 'Torsdag',
        'Fri' => 'Fredag',
        'Sat' => 'Lørdag',
        'Day' => 'Dag',
        'WD' => 'Ukedag',
        'WE' => 'Dag i helg',
        ],

        'duration_dom' => [
        '' => 'Ingen',
        '900' => '15 minutter',
        '1800' => '30 minutter',
        '2700' => '45 minutter',
        '3600' => '1 time',
        '5400' => '1.5 time',
        '7200' => '2 timer',
        '10800' => '3 timer',
        '21600' => '6 timer',
        '86400' => '1 dag',
        '172800' => '2 dager',
        '259200' => '3 dager',
        '604800' => '1 uke',
        ],
        'repeat_month_dom' => [
        '1' => 'Januar',
        '2' => 'Februar',
        '3' => 'Mars',
        '4' => 'April',
        '5' => 'Mai',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'August',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'Desember',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'Forhåndsinnstilt',
        'seed' => 'Seed',
        'exempt_domain' => 'Suppression Liste - Etter domene',
        'exempt_address' => 'Suppression Liste - Etter E-post adresse',
        'exempt' => 'Suppression Liste - Etter ID',
        'test' => 'Test [Alt+T]',
        ],
        'currency_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'Aktiv',
        'inactive' => 'Passiv',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'Melding sent/forsøkt',
        'send error' => 'Returnerte meldinger, andre',
        'invalid email' => 'Returnerte meldinger, ugyldig adresse',
        'link' => 'Click-thru-lenke',
        'viewed' => 'Vist melding',
        'removed' => 'Reservert seg',
        'lead' => 'Emner opprettet',
        'contact' => 'Kontakter ble opprettet',
        'blocked' => 'Blokkert av adresse eller domene',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'Kontakter',
        'Users' => 'Brukere',
        'Prospects' => 'Prospekter',
        'Leads' => 'Emner',
        'Accounts' => 'Bedrifter',
        ],
        'merge_operators_dom' => [
        'like' => 'Inneholder',
        'exact' => 'Nøyaktig',
        'start' => 'Begynner med',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'Ja',
        'false' => 'Nei',
        'required' => 'Avkrevd',
        ],

        'fts_field_config' => [
        '0' => 'Deaktivert',
        '2' => 'Søkbar',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'Deaktivert',
        1 => 'Aktivert',
        2 => 'I filter',
        3 => 'Standard filter valgt',
        4 => 'Kun filter',
        ],

        'navigation_paradigms' => [
        'm' => 'Moduler',
        'gm' => 'Grupperte moduler',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'Ikke begynt',
        'inprogress' => 'Under utførelse',
        'signed' => 'Signert',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'Månedlig',
        'quarterly' => 'Kvartalsvis',
        'halfyearly' => 'Halvårlig',
        'yearly' => 'Årlig',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 dag',
        '3' => '3 dager',
        '5' => '5 dager',
        '7' => '1 uke',
        '14' => '2 uker',
        '21' => '3 uker',
        '31' => '1 måned',
        ],
        'projects_priority_options' => [
        'high' => 'Høy',
        'medium' => 'Medium',
        'low' => 'Lav',
        ],

        'projects_status_options' => [
        'notstarted' => 'Ikke begynt',
        'inprogress' => 'Under utførelse',
        'completed' => 'Fullført',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'Utvid oversikt',
        'collapselegend' => 'Skjul oversikt',
        'clickfordrilldown' => 'Klikk for detaljoversikt',
        'drilldownoptions' => 'Alternativer i detaljoversikt',
        'detailview' => 'Flere detaljer...',
        'piechart' => 'Kakediagramm',
        'groupchart' => 'Gruppediagramm',
        'stackedchart' => 'Stablet diagramm',
        'barchart' => 'Stolpediagramm',
        'horizontalbarchart' => 'Horisontalt stolpediagramm',
        'linechart' => 'Linjediagramm',
        'noData' => 'Data ikke tilgjengelig',
        'print' => 'Skriv ut',
        'pieWedgeName' => 'seksjoner',
        ],
        'chart_types' => [
        'hBarF' => 'Horisontal linje (stablet)',
        'hGBarF' => 'Horisontal linje (gruppert)',
        'vBarF' => 'Vertikal linje (stablet)',
        'vGBarF' => 'Vertikal linje (gruppert)',
        'pieF' => 'Kake',
        'funnelF' => 'Trakt',
        'lineF' => 'Linje',
        'donutF' => 'Smultring',
        'treemapF' => 'Trekart',
        ],
        'd3_value_placement' => [
        '0' => 'Ingen',
        '1' => 'Forhåndsinnstilt',
        'start' => 'Start',
        'middle' => 'Middels',
        'end' => 'Slutt',
        'top' => 'Topp',
        'total' => 'Totalt',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'Trakt',
        'hbar' => 'Horisontal bom',
        ],
        'release_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Passiv',
        ],
        'email_settings_for_ssl' => [
        '0' => 'Ingen',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Google mindre sikre apper',
        'exchange' => 'Exchange',
        'other' => 'Annet',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'Annet',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'Singel anførselstegn(&#39;)',
        '"' => 'Dobbel anførselstegn (")',
        '' => 'Ingen',
        'other' => 'Annet:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '/',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'Annet:',
        ],
        'link_target_dom' => [
        '_blank' => 'Nytt vindu',
        '_self' => 'Samme vindu',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'Ikke auto-refresh',
        '30' => 'Hvert 30. sekund',
        '60' => 'Hvert 1. minutt',
        '180' => 'Hvert 3. minutt',
        '300' => 'Hvert 5. minutt',
        '600' => 'Hvert 10. minutt',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'Ingen',
        '15' => 'Hvert 15. minutt',
        '30' => 'Hvert 30. minutt',
        '45' => 'Hvert 45. minutt',
        '60' => 'Hver time',
        '120' => 'Hver 2. time',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'Aldri',
        '30' => 'Hvert 30. sekund',
        '60' => 'Hvert 1. minutt',
        '180' => 'Hvert 3. minutt',
        '300' => 'Hvert 5. minutt',
        '600' => 'Hvert 10. minutt',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'Ingen',
        '1' => 'Hvert 1. minutt',
        '5' => 'Hvert 5. minutt',
        '10' => 'Hvert 10. minutt',
        '15' => 'Hvert 15. minutt',
        '30' => 'Hvert 30. minutt',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'Jevnbyrdige',
        'not_equal' => 'Ikke på',
        'greater_than' => 'Etter',
        'less_than' => 'Før',
        'last_7_days' => 'Siste 7 dager',
        'next_7_days' => 'Neste 7 dager',
        'last_30_days' => 'Siste 30 dager',
        'next_30_days' => 'Neste 30 dager',
        'last_month' => 'Siste måned',
        'this_month' => 'Denne måneden',
        'next_month' => 'Neste måned',
        'last_year' => 'Forrige år',
        'this_year' => 'Dette år',
        'next_year' => 'Dette år',
        'between' => 'Er imellom',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'Forrige år',
        'last_month' => 'Siste måned',
        'last_30_days' => 'Siste 30 dager',
        'last_7_days' => 'Siste 7 dager',
        'this_month' => 'Denne måneden',
        'this_year' => 'Dette år',
        'next_7_days' => 'Neste 7 dager',
        'next_30_days' => 'Neste 30 dager',
        'next_month' => 'Neste måned',
        'next_year' => 'Dette år',
        ],
        'numeric_range_search_dom' => [
        '=' => 'Jevnbyrdige',
        'not_equal' => 'Er ikke jevnbyrdige',
        'greater_than' => 'Større enn',
        'greater_than_equals' => 'Større enn eller lik med',
        'less_than' => 'Mindre enn',
        'less_than_equals' => 'Mindre enn eller lik med',
        'between' => 'Er imellom',
        ],

        'filter_checkbox_dom' => [
        0 => 'Falsk',
        1 => 'Sann',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'Vunnet',
        'lost' => 'Mistet',
        'active' => 'Aktiv',
        ],

        'sweetspot_theme_options' => [
        'default' => 'Forhåndsinnstilt',
        'light' => 'Lys',
        'dark' => 'Mørk',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'Flytt',
        'donothing' => 'Ikke gjør noe',
        ],
        'processes_auto_save_interval' => [
        0 => 'Aldri',
        30000 => 'Hvert 30. sekund',
        60000 => 'Hvert 1. minutt',
        120000 => 'Hvert 2. minutt',
        180000 => 'Hvert 3. minutt',
        240000 => 'Hvert 4. minutt',
        300000 => 'Hvert 5. minutt',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nei',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'I prognose',
        'sales_stage' => 'Salgsfase',
        'probability' => 'Sannsynlighet',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'Mengde',
        'best' => 'Beste',
        'worst' => 'Verst',
        ],
        'webLogicHookList' => [
        'after_save' => 'Etter lagre',
        'after_delete' => 'Etter slett',
        'after_relationship_add' => 'Etter forbindelse er lagt til',
        'after_relationship_delete' => 'Etter forbindelse er slettet',
        'after_login' => 'Etter innlogging',
        'after_logout' => 'Etter utlogging',
        'after_login_failed' => 'Etter at innlogging feilet',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'Aktivert',
        'INACTIVE' => 'Deaktivert',
        ],
        'dashboard_view_name_list' => [
        'record' => 'Post',
        'records' => 'Liste',
        'activities' => 'Aktivitetstrøm',
        'multi-line' => 'Liste over flere linjer',
        'omnichannel' => 'Flere kanaler',
        'home' => 'Home',
        'focus' => 'Fokusskuff',
        ],
        'metric_context_list' => [
        'service_console' => 'Servicekonsoll',
        'renewals_console' => 'Fornyelser-konsoll',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'Hver time',
        '21600' => 'Hver sjette time',
        '43200' => 'Hver tolvte time',
        '86400' => 'Daglig',
        '604800' => 'Ukentlig',
        '1209600' => 'Hver andre uke',
        '2419200' => 'Hver fjerde uke',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'År',
        'month' => 'Måned(er)',
        'day' => 'Dag(er)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'Tid av',
        'event' => 'Hendelse',
        'other' => 'Andre',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'Dato (forrige {{module}})',
        'start_date:asc' => 'Dato (første {{module}})',
        'total_revenue:desc' => 'Pris (høyest total)',
        'total_revenue:asc' => 'Pris (lavest total)',
        ],
        'calendar_type_list' => [
        'main' => 'Kalendersenter',
        ],
        'calendar_views_options' => [
        'day' => 'Dag',
        'week' => 'Uke',
        'workWeek' => 'Arbeidsuke',
        'expandedMonth' => 'Måned',
        'agenda' => 'Agenda',
        'timeline' => 'Tidslinje',
        'monthSchedule' => 'Planlegger',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'Opprettet',
        'completed' => 'Fullført',
        'declined' => 'Avslått',
        'delivered' => 'Levert',
        'sent' => 'Sendt',
        'signed' => 'Signert',
        'voided' => 'Ugyldiggjort',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'Vis liste over potensielle mottakere',
        'dont_show' => 'Ikke vis potensielle mottakere',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'Signerer',
        'carbon_copy' => 'Viewer (Karbonkopi)',
        'certified_delivery' => 'Viewer (sertifisert levering)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'Vanlig',
        'color' => 'Farge',
        'image' => 'Bilde',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'Forkortelse',
        'icon' => 'Ikon',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'Pil ned',
        'sicon-chevron-left' => 'Vinkeltegn venstre',
        'sicon-check' => 'Sjekk',
        'sicon-clock' => 'Klokke',
        'sicon-dashboard-default' => 'Standard dashboard',
        'sicon-dashboard' => 'Dashboard',
        'sicon-edit' => 'Rediger',
        'sicon-caret-down' => 'Mellomromstegn ned',
        'sicon-folder' => 'Mappe',
        'sicon-info' => 'Info',
        'sicon-kebab' => 'Kebab',
        'sicon-link' => 'Lenke',
        'sicon-list' => 'Liste',
        'sicon-logout' => 'Logg ut',
        'sicon-minus' => 'Minus',
        'sicon-folder-open' => 'Mappe er åpen',
        'sicon-plus-sm' => 'Pluss Sm',
        'sicon-refresh' => 'Oppdater',
        'sicon-plus' => 'Pluss',
        'sicon-settings' => 'Innstillinger',
        'sicon-arrow-right-double' => 'Pil høyre dobbel',
        'sicon-reports' => 'Rapporter',
        'sicon-user' => 'Bruker',
        'sicon-upload' => 'Last opp',
        'sicon-user-group' => 'Brukergruppe',
        'sicon-arrow-left-double' => 'Pil venstre dobbel',
        'sicon-chevron-up' => 'Vinkeltegn opp',
        'sicon-caret-up' => 'Mellomromstegn opp',
        'sicon-star-fill' => 'Stjernefyll',
        'sicon-download' => 'Last ned',
        'sicon-close' => 'Lukk',
        'sicon-tile-view' => 'Flisvisning',
        'sicon-list-view' => 'Listevisning',
        'sicon-thumbs-down' => 'Tommel ned',
        'sicon-warning-circle' => 'Advarselssirkel',
        'sicon-phone' => 'Telefon',
        'sicon-email' => 'E-post',
        'sicon-document' => 'Dokument',
        'sicon-note' => 'Notat',
        'sicon-preview' => 'Forhåndsvisning',
        'sicon-copy' => 'Kopier',
        'sicon-launch' => 'Start',
        'sicon-lock' => 'Lås',
        'sicon-arrow-top-right' => 'Pil øverst til høyre',
        'sicon-full-screen' => 'Fullskjerm',
        'sicon-full-screen-exit' => 'Avslutt fullskjerm',
        'sicon-expand-left' => 'Utvid til venstre',
        'sicon-expand-right' => 'Utvid til høyre',
        'sicon-focus-drawer' => 'Fokusskuff',
        'sicon-ban' => 'Forbud',
        'sicon-thumbs-up' => 'Tommel opp',
        'sicon-search' => 'Søke',
        'sicon-calendar' => 'Kalender',
        'sicon-calendar-lg' => 'Kalender Lg',
        'sicon-mobile-lg' => 'Mobil Lg',
        'sicon-star-fill-lg' => 'Stjernefyll Lg',
        'sicon-star-outline-lg' => 'Stjerneoversikt Lg',
        'sicon-reset-lg' => 'Tilbakestill Lg',
        'sicon-exchange-lg' => 'Utveksling Lg',
        'sicon-help-lg' => 'Hjelp Lg',
        'sicon-close-lg' => 'Lukk Lg',
        'sicon-plus-lg' => 'Pluss Lg',
        'sicon-shortcuts-lg' => 'Snarveier Lg',
        'sicon-search-lg' => 'Søk Lg',
        'sicon-email-lg' => 'E-post Lg',
        'sicon-note-lg' => 'Notat Lg',
        'sicon-document-lg' => 'Dokument Lg',
        'sicon-add-dashlet-lg' => 'Legg Dashlet Lg',
        'sicon-collapse-lg' => 'Skjul Lg',
        'sicon-hamburger-lg' => 'Hamburger Lg',
        'sicon-pin-fill-lg' => 'Feste til fyll Lg',
        'sicon-expand-lg' => 'Utvid Lg',
        'sicon-copy-lg' => 'Kopier Lg',
        'sicon-dashboard-lg' => 'Dashboard Lg',
        'sicon-star-outline' => 'Stjerneoversikt',
        'sicon-reset' => 'Tilbakestille',
        'sicon-unlink' => 'Fjerne lenke',
        'sicon-phone-lg' => 'Telefon Lg',
        'sicon-attach' => 'Feste',
        'sicon-case-lg' => 'Sak Lg',
        'sicon-arrow-right-lg' => 'Pil høyre Lg',
        'sicon-check-circle-lg' => 'Sjekk sirkel Lg',
        'sicon-text-formatting' => 'Formatering av tekst',
        'sicon-check-circle' => 'Sjekk sirkel',
        'sicon-upload-lg' => 'Last opp Lg',
        'sicon-flag-lg' => 'Flagg Lg',
        'sicon-studio-lg' => 'Studio Lg',
        'sicon-contact-lg' => 'Kontakt Lg',
        'sicon-edit-lg' => 'Redigere Lg',
        'sicon-arrow-left' => 'Pil venstre',
        'sicon-reply-all' => 'Svar til alle',
        'sicon-message-lg' => 'Melding Lg',
        'sicon-info-lg' => 'Info Lg',
        'sicon-error-lg' => 'Feil Lg',
        'sicon-check-circle-line-lg' => 'Sjekk sirkellinje Lg',
        'sicon-warning-line-lg' => 'Advarselslinje Lg',
        'sicon-arrow-up' => 'Pil opp',
        'sicon-arrow-right' => 'Pil høyre',
        'sicon-nodes' => 'Noder',
        'sicon-hide' => 'Skjul',
        'sicon-help' => 'Hjelp',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'Melding',
        'sicon-sugar-predict-lg' => 'Sugar prediksjon Lg',
        'sicon-sugar-predict' => 'Sugar prediksjon',
        'sicon-opportunity-lg' => 'Mulighet Lg',
        'sicon-lead-lg' => 'Emne Lg',
        'sicon-account-lg' => 'Konto Lg',
        'sicon-user-sm' => 'Bruker Sm',
        'sicon-quote-lg' => 'Tilbud Lg',
        'sicon-equal' => 'Lik',
        'sicon-slicers-xl' => 'Slicere Xl',
        'sicon-escalation-lg' => 'Eskalering Lg',
        'sicon-add-circle-lg' => 'Legg til sirkel Lg',
        'sicon-add-line-lg' => 'Legg til linje Lg',
        'sicon-add-target-lg' => 'Legg til mål Lg',
        'sicon-help-circle-lg' => 'Hjelpesirkel Lg',
        'sicon-divide-line-lg' => 'Delelinje Lg',
        'sicon-string' => 'Streng',
        'sicon-filter' => 'Filter',
        'sicon-number' => 'Nummer',
        'sicon-format-lg' => 'Format Lg',
        'sicon-insights-lg' => 'Innsikt Lg',
        'sicon-invalid-circle-lg' => 'Ugyldig sirkel Lg',
        'sicon-layout-xl' => 'Oppsett Xl',
        'sicon-layout-lg' => 'Oppsett Lg',
        'sicon-multiply-line-lg' => 'Multiplisere linje Lg',
        'sicon-redo-lg' => 'Gjøre om Lg',
        'sicon-refresh-lg' => 'Oppdater Lg',
        'sicon-undo-lg' => 'Angre Lg',
        'sicon-activity-feed-xl' => 'Aktivitetsfeed Xl',
        'sicon-chevron-left-xl' => 'Vinkeltegn venstre Xl',
        'sicon-close-xl' => 'Lukk Xl',
        'sicon-kebab-lg' => 'Kebab Lg',
        'sicon-insights-xl' => 'Innsikt Xl',
        'sicon-hide-lg' => 'Skjul Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => 'Kommentar Xl',
        'sicon-share-lg' => 'Del Lg',
        'sicon-trash' => 'Søppel',
        'sicon-launch-lg' => 'Lansering Lg',
        'sicon-thumbs-up-lg' => 'Tommel opp Lg',
        'sicon-thumbs-down-lg' => 'Tommelen ned Lg',
        'sicon-warning-lg' => 'Advarsel Lg',
        'sicon-wizard-circle-xl' => 'Veiviser sirkel Xl',
        'sicon-bell-cross-lg' => 'Bell Cross Lg',
        'sicon-bell-lg' => 'Bell Lg',
        'sicon-daily-lg' => 'Daglig Lg',
        'sicon-cloud-download-lg' => 'Cloud Last ned Lg',
        'sicon-unlock' => 'Låse opp',
        'sicon-news-lg' => 'Nyheter Lg',
        'sicon-weekly-lg' => 'Ukentlig Lg',
        'sicon-knowledgebase-xl' => 'Kunnskapsbase Xl',
        'sicon-remove' => 'Fjern',
        'sicon-chevron-down' => 'Vinkeltegn nedover',
        'sicon-slicers-lg' => 'Slicers Lg',
        'sicon-save-lg' => 'Lagre Lg',
        'sicon-info-circle-lg' => 'Info sirkel Lg',
        'sicon-chevron-right' => 'Vinkeltegn høyre',
        'sicon-warning-circle-lg' => 'Advarselssirkel Lg',
        'sicon-right-paren-line-lg' => 'Høyre overordnet linje Lg',
        'sicon-comment-lg' => 'Kommentar Lg',
        'sicon-target-lg' => 'Mål Lg',
        'sicon-subtract-line-lg' => 'Trekklinje Lg',
        'sicon-settings-lg' => 'Innstillinger Lg',
        'sicon-left-paren-line-lg' => 'Venstre overordnet linje Lg',
        'sicon-preview-lg' => 'Forhåndsvisning Lg',
        'sicon-thumbs-down-line-lg' => 'Tommel ned linje Lg',
        'sicon-thumbs-up-line-lg' => 'Tommel opp linje Lg',
        'sicon-send-lg' => 'Send Lg',
        'sicon-contact-xl' => 'Kontakt Xl',
        'sicon-wizard-circle-line-xl' => 'Veiviser sirkellinje Xl',
        'sicon-trash-lg' => 'Søppel Lg',
        'sicon-pin-lg' => 'Feste Lg',
        'sicon-clock-lg' => 'Klokke Lg',
        'sicon-comment-line-xl' => 'Kommentar Linje Xl',
        'sicon-dropdown-editor' => 'Nedtrekks-meny',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'Feil',
        'sicon-catalog' => 'Katalog',
        'sicon-cloud' => 'Sky',
        'sicon-config-api' => 'Konfigurer Api',
        'sicon-config-nav' => 'Konfigurer Nav',
        'sicon-connectors' => 'Kontakter',
        'sicon-contracts' => 'Kontrakter',
        'sicon-currencies' => 'Valutaer',
        'sicon-diagnostics' => 'Diagnostikk',
        'sicon-sugar-club' => 'Sugar-klubb',
        'sicon-email-campaign' => 'E-post-kampanje',
        'sicon-email-inbound' => 'Innkommende e-post',
        'sicon-email-queue' => 'E-postkø',
        'sicon-forecasts' => 'Prognoser',
        'sicon-display-modules' => 'Vis moduler',
        'sicon-email-contacts' => 'E-postkontakter',
        'sicon-import' => 'Importer',
        'sicon-log-viewer' => 'Loggvisning',
        'sicon-lab' => 'Lab',
        'sicon-map-pin' => 'Feste kart',
        'sicon-manufacturers' => 'Produsenter',
        'sicon-update' => 'Oppdater',
        'sicon-content-security' => 'Sikkerhet for innhold',
        'sicon-module-builder' => 'Modul-bygger',
        'sicon-languages' => 'Språk',
        'sicon-module-loader' => 'Modul-opplaster',
        'sicon-oauth-key' => 'Oauth-nøkkel',
        'sicon-password-mgmt' => 'Passord Mgmt',
        'sicon-opportunities' => 'Muligheter',
        'sicon-upgrade' => 'Oppgradér',
        'sicon-portal' => 'Portal',
        'sicon-product-types' => 'Produkttyper',
        'sicon-quotes' => 'Tilbud',
        'sicon-relate-fields' => 'Relater felt',
        'sicon-repair' => 'Reparere',
        'sicon-role-mgmt' => 'Rolle Mgmt',
        'sicon-scheduler' => 'Planlegger',
        'sicon-shippers' => 'Avsendere',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'Web Logic',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'Skattesatser',
        'sicon-team-mgmt' => 'Team Mgmt',
        'sicon-team-perm' => 'Team Perm',
        'sicon-tracker' => 'Tracker',
        'sicon-workflow' => 'Arbeidsflyt',
        'sicon-mask' => 'Maske',
        'sicon-mask-disabled' => 'Maske deaktivert',
        'sicon-email-archive' => 'E-postarkiv',
        'sicon-mobile' => 'Mobil',
        'sicon-archive' => 'Arkiv',
        'sicon-automate-scroll' => 'Vertikal rullevisning',
        'sicon-automate-stacked' => 'Horisontal rullevisning',
        'sicon-pdf-manager' => 'Pdf Manager',
        'sicon-my-sites' => 'Mine portaler',
        'sicon-cloud-insights' => 'Cloud Insights',
        'sicon-sugar-logo-24' => 'Sugar logo 24',
        'sicon-sugar-logo-16' => 'Sugar logo 16',
        'sicon-task-lg' => 'Oppgave Lg',
        'sicon-web-lg' => 'Web Lg',
        'sicon-events-lg' => 'Hendelser Lg',
        'sicon-sugar-logo-12' => 'Sugar logo 12',
        'sicon-tag' => 'Tag',
        'sicon-tag-lg' => 'Tag Lg',
        'sicon-bell-lg-line' => 'Bell Lg-linjen',
        'sicon-matrix-xxl' => 'Matrise Xxl',
        'sicon-advanced-filter' => 'Avansert filter',
        'sicon-rows-and-columns-xxl' => 'Rader og kolonner Xxl',
        'sicon-summation-details-xxl' => 'Oppsummeringsdetaljer Xxl',
        'sicon-summation-xxl' => 'Oppsummering Xxl',
        'sicon-lock-lg' => 'Lås Lg',
        'sicon-csv-file-xxl' => 'CSV-fil Xxl',
        'sicon-logo-linkedin' => 'Logo Linkedin',
        'sicon-briefcase' => 'Dokumentmappe',
        'sicon-car-front' => 'Bilfront',
        'sicon-airplane' => 'Fly',
        'sicon-laptop' => 'Bærbar datamaskin',
        'sicon-logo-instagram' => 'Logo Instagram',
        'sicon-single-bed' => 'Enkeltseng',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'Logo Snapchat',
        'sicon-video-lg' => 'Video Lg',
        'sicon-reply' => 'Svare',
        'sicon-subtract' => 'Trekke fra',
        'sicon-arrow-up-circle-line' => 'Pil opp sirkellinje',
        'sicon-asterisk' => 'Stjerne',
        'sicon-dot-circle-o-lg' => 'Dot Circle O Lg',
        'sicon-forward' => 'Videresend',
        'sicon-video' => 'Video',
        'sicon-gavel' => 'Gavel',
        'sicon-login' => 'Pålogging',
        'sicon-pdf-file-xxl' => 'Pdf-fil Xxl',
        'sicon-login-lg' => 'Pålogging Lg',
        'sicon-cloud-download-xl' => 'Skynedlasting Lg',
        'sicon-campaigns-lg' => 'Kampanjer Lg',
        'sicon-customer-journey-stages-lg' => 'Fase i kundereisen Lg',
        'sicon-role-mgmt-lg' => 'Rolle Mgmt Lg',
        'sicon-default-module-lg' => 'Standard modul Lg',
        'sicon-quoted-line-items-lg' => 'Tilbuds linjeelementer Lg',
        'sicon-projects-lg' => 'Prosjekter Lg',
        'sicon-process-business-rules-lg' => 'Behandle bedriftsregler Lg',
        'sicon-process-email-templates-lg' => 'Behandle e-postmaler Lg',
        'sicon-processes-lg' => 'Prosesser Lg',
        'sicon-process-definitions-lg' => 'Prosess-definisjoner Lg',
        'sicon-target-lists-lg' => 'Mållister Lg',
        'sicon-purchased-line-items-lg' => 'Kjøpte linjeelementer Lg',
        'sicon-user-group-lg' => 'Brukergruppe Lg',
        'sicon-revenue-line-items-lg' => 'Omsetning linjeelementer Lg',
        'sicon-business-centers-lg' => 'Forretningssentre Lg',
        'sicon-logo-fb-simple' => 'Logo Fb enkel',
        'sicon-forecasts-lg' => 'Prognoser Lg',
        'sicon-contracts-lg' => 'Kontrakter Lg',
        'sicon-purchase-lg' => 'Kjøp Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'Kundereise Lg',
        'sicon-data-privacy-lg' => 'Personvern for data Lg',
        'sicon-home-lg' => 'Hjem Lg',
        'sicon-data-table' => 'Datatabell',
        'sicon-medical-clipboard-lg' => 'Medisinsk utklippstavle Lg',
        'sicon-privacy-lg' => 'Personvern Lg',
        'sicon-marketplace' => 'Markedsplass',
        'sicon-marketplace-lg' => 'Markedsplass Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => 'Casino Lg',
        'sicon-jacuzzi-lg' => 'Jacuzzi Lg',
        'sicon-scissors-lg' => 'Saks Lg',
        'sicon-storage-lg' => 'Lagring Lg',
        'sicon-fan-lg' => 'Vifte Lg',
        'sicon-medicine-lg' => 'Medisin Lg',
        'sicon-plant-lg' => 'Plante Lg',
        'sicon-telescope-lg' => 'Teleskop Lg',
        'sicon-smart-phone-lg' => 'Smarttelefon Lg',
        'sicon-coffee-lg' => 'Kaffe Lg',
        'sicon-martini-lg' => 'Martini Lg',
        'sicon-cocktail-lg' => 'Cocktail Lg',
        'sicon-stadium-lg' => 'Stadion Lg',
        'sicon-fire-lg' => 'Brann Lg',
        'sicon-window-lg' => 'Vindu Lg',
        'sicon-lotus-lg' => 'Lotus Lg',
        'sicon-windmill-lg' => 'Vindmølle Lg',
        'sicon-spades-lg' => 'Spar Lg',
        'sicon-hearts-lg' => 'Hjerter Lg',
        'sicon-diamonds-lg' => 'Diamanter Lg',
        'sicon-clubs-lg' => 'Klubber Lg',
        'sicon-skull-lg' => 'Hodeskalle Lg',
        'sicon-send' => 'Send',
        'sicon-world-lg' => 'Verden Lg',
        'sicon-airplane-lg' => 'Fly Lg',
        'sicon-planet-lg' => 'Planet Lg',
        'sicon-trainer-lg' => 'Trener Lg',
        'sicon-calculator-lg' => 'Kalkulator Lg',
        'sicon-tv-lg' => 'TV Lg',
        'sicon-video-player-lg' => 'Videospiller Lg',
        'sicon-media-player-lg' => 'Mediespiller Lg',
        'sicon-decentralize-lg' => 'Desentralisere Lg',
        'sicon-statistics-lg' => 'Statistikk Lg',
        'sicon-virus-lg' => 'Virus Lg',
        'sicon-shield-lg' => 'Skjold Lg',
        'sicon-plug-lg' => 'Plugg Lg',
        'sicon-shuttle-lg' => 'Skyttelbuss Lg',
        'sicon-soundwave-lg' => 'Soundwave Lg',
        'sicon-graph-lg' => 'Graf Lg',
        'sicon-playlist-lg' => 'Spilleliste Lg',
        'sicon-voice-recognition-lg' => 'Stemmegjenkjenning Lg',
        'sicon-machine-learning-lg' => 'Maskinlæring Lg',
        'sicon-bed-lg' => 'Seng Lg',
        'sicon-blueprint-lg' => 'Blåkopi Lg',
        'sicon-content-delivery-lg' => 'Levering av innhold Lg',
        'sicon-questionnaire-lg' => 'Spørreskjema Lg',
        'sicon-presentation-lg' => 'Presentasjon Lg',
        'sicon-organic-lg' => 'Organisk Lg',
        'sicon-transactions-lg' => 'Transaksjoner Lg',
        'sicon-wand-lg' => 'Tryllestav Lg',
        'sicon-bin-lg' => 'Bin Lg',
        'sicon-sync-lg' => 'Synkroniser Lg',
        'sicon-external-authentication-lg' => 'Ekstern godkjenning Lg',
        'sicon-tracking-activity-lg' => 'Sporingsaktivitet Lg',
        'sicon-account' => 'Konto',
        'sicon-meetings-lg' => 'Møter Lg',
        'sicon-stacked' => 'Horisontal delingsvisning',
        'sicon-sidebyside' => 'Vertikal delingsvisning',
        ],

        'module_colors_dom' => [
        'army' => 'Militær',
        'coral' => 'Korall',
        'green' => 'Grønn',
        'orange' => 'Oransje',
        'ocean' => 'Hav',
        'pacific' => 'Stillehavet',
        'pink' => 'Rosa',
        'purple' => 'Lilla',
        'red' => 'Rød',
        'teal' => 'Blågrønn',
        'yellow' => 'Gul',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'Ny',
        'In Progress' => 'Pågår',
        'Closed' => 'Lukket',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'Inaktivitet',
        'Lack of Progress' => 'Manglende fremdrift',
        'Customer-Imposed Deadline' => 'Kundepålagt tidsfrist',
        'Account at Risk' => 'Konto i fare',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'Kundeetterspurt',
        'Internally Requested' => 'Internt etterspurt',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'Sak',
        'Bugs' => 'Feil',
        'Accounts' => 'Konto',
        'Opportunities' => 'Mulighet',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'Positiv',
        'Negative' => 'Negativ',
        'Neutral' => 'Nøytral',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'Usannsynlig',
        '02_less_likely' => 'Mindre sannsynlig',
        '03_neutral' => 'Nøytral',
        '04_more_likely' => 'Mer sannsynlig',
        '05_very_likely' => 'Sannsynlig',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'Samsvarer ikke med kunder',
        '02_no_match' => '',
        '01_matches_customers' => 'Samsvarer med kunder',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'Emne',
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Cases' => 'Sak',
        'Opportunities' => 'Mulighet',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'Ikke begynt',
        'in_progress' => 'Pågår',
        'completed' => 'Fullført',
        'cancelled' => 'Kansellert',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'Ingen',
        'create' => 'På Opprett',
        'stage_start' => 'På startfase',
        'previous_activity_completed' => 'Forrige aktivitet fullført',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'Gjeldende bruker',
        'parent_assignee' => 'Overordnet stedfortreder',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'Dager fra opprettet',
        'days_from_stage_started' => 'Dager fra fasen startet',
        'days_from_previous_activity_completed' => 'Dager fra tidligere fullført aktivitet',
        'days_from_parent_date_field' => 'Dager fra overordnet datofelt',
        'days_from_specific_activity_completed' => 'Dager fra spesifikk aktivitet fullført',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'Når opprettet',
        'stage_started' => 'Når fasen startet',
        'previous_activity_completed' => 'Når forrige aktivitet er fullført',
        'parent_date_field' => 'På overordnet datofelt',
        'specific_activity_completed' => 'Spesifikk aktivitet fullført',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'Absolutt',
        'Percentage' => 'Prosent',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'Kundens oppgave',
        'milestone' => 'Milepæl',
        'internal_task' => 'Intern oppgave',
        'agency_task' => 'Byråets oppgave',
        'automatic_task' => 'Automatisk oppgave',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'Oppgave',
        'Calls' => 'Samtale',
        'Meetings' => 'Møte',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'Ingen',
        'create' => 'På Opprett',
        'stage_start' => 'På startfase',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'Arve',
        'current_user' => 'Gjeldende bruker',
        'parent_assignee' => 'Overordnet stedfortreder',
        'user' => 'Bruker',
        'team' => 'Team',
        'user_team' => 'Bruker og team',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'Arve',
        'none' => 'Ingen',
        'create' => 'På Opprett',
        'stage_start' => 'På startfase',
        'previous_activity_completed' => 'Forrige aktivitet fullført',
        'specific_activity_completed' => 'Spesifikk aktivitet fullført',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'Ikke begynt',
        'in_progress' => 'Pågår',
        'not_completed' => 'Ikke fullført',
        'completed' => 'Fullført',
        'cancelled' => 'Kansellert',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'Rediger fase',
        'stage_add_task_button' => 'Opprett oppgave',
        'stage_add_meeting_button' => 'Planlegg møte',
        'stage_add_call_button' => 'Planlegg samtale',
        'stage_delete_button' => 'Slett fase',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'Legg til oppgave',
        'activity_add_sub_meeting_button' => 'Planlegg møte',
        'activity_add_sub_call_button' => 'Planlegg samtale',
        'activity_not_applicable_button' => 'Ikke aktuelt',
        'activity_delete_button' => 'Slette',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'Angi gjelder ikke',
        'remove_open_activities' => 'Fjern åpne aktiviteter',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'Standard',
        'custom' => 'Tilpasset',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'FÅ',
        'POST' => 'POST',
        'PUT' => 'PUT',
        'PATCH' => 'OPPDATERING',
        'DELETE' => 'SLETTE',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'Hopp over forespørsel',
        'json' => 'JSON',
        'http_query' => 'HTTP-spørring',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'Ingen respons',
        'json' => 'JSON',
        'http_query' => 'HTTP-spørring',
        'text' => 'Vanlig tekst',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'Før du oppretter',
        'after_create' => 'Etter oppretting',
        'before_in_progress' => 'Før pågår',
        'after_in_progress' => 'Etter pågår',
        'before_completed' => 'Før fullført',
        'after_completed' => 'Etter fullført',
        'before_not_applicable' => 'Før ikke aktuelt',
        'after_not_applicable' => 'Etter ikke aktuelt',
        'before_delete' => 'Før slett',
        'after_delete' => 'Etter slett',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Sende informasjon om Smart Guide',
        'custom_body' => 'Send tilpasset innlegg',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'Pågår',
        'completed' => 'Fullført',
        'not_applicable' => 'Ikke aktuelt',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'Vis oppføring',
        'create_record' => 'Opprett oppføring',
        'update_record' => 'Oppdater oppføring',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'Opprette oppføring automatisk',
        'manual_create' => 'Opprette oppføring manuelt',
        'automatic_update' => 'Oppdater oppføringen automatisk',
        'manual_update' => 'Oppdatere oppføringen manuelt',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Mal for Smart Guide',
        'DRI_SubWorkflow_Templates' => 'Fasemal',
        'DRI_Workflow_Task_Templates' => 'Aktivitetsmal',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'Ja',
        'no' => 'Nei',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'Holdt',
        'Not Held' => 'Ikke holdt',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'Holdt',
        'Not Held' => 'Ikke holdt',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'Fullført',
        'Not Applicable' => 'Ikke aktuelt',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Mal for Smart Guide',
        'DRI_SubWorkflow_Templates' => 'Fasemal',
        'DRI_Workflow_Task_Templates' => 'Aktivitetsmal',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'Oppgave',
        'Meetings' => 'Møte',
        'Calls' => 'Telefonsamtale',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'Gjeldende oppgave',
        'Calls' => 'Gjeldende samtale',
        'Meetings' => 'Gjeldende møte',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'Spesifikke brukere',
        'specific_contacts' => 'Spesifikke kontakter',
        'related_parent_users' => 'Relaterte overordnede brukere',
        'related_parent_contacts' => 'Relaterte overordnede kontakter',
        'add_all_contacts_from_parent' => 'Legge til alle kontakter fra overordnede',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'Brukere',
        'specific_contacts' => 'Kontaker',
        'related_parent_users' => 'Brukere',
        'related_parent_contacts' => 'Kontaker',
        'add_all_contacts_from_parent' => 'Kontaker',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'Minutt(er)',
        'hours' => 'Time(r)',
        'days' => 'Dag(er)',
        'months' => 'Måned(er)',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'Dag(er)',
        'months' => 'Måned(er)',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'Fast dato',
        'relative' => 'Relativ dato',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'Brukere',
        'teams' => 'Grupper',
        'roles' => 'Roller',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide til Sugar-handlinger',
        'sugar_action_to_smart_guide' => 'Sugar-handling til Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide-fase',
        'Smart Guide Activities' => 'Smart Guide-aktiviteter',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'Fullført',
        'cancelled' => 'Kansellert',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'Pågår',
        'completed' => 'Fullført',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'Pågår',
        'completed' => 'Fullført',
        'not_applicable' => 'Ikke aktuelt',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'Merk alle aktiviteter som fullført',
        'mark_all_not_applicable' => 'Merk alle ufullstendige aktiviteter som Ikke aktuelt',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'USA (Oregon) [us-west-2]',
        'ca-central-1' => 'Canada (sentralt) [ca-central-1]',
        'ap-southeast-1' => 'Stillehavs-Asia (Singapore) [ap-southeast-1]',
        'ap-southeast-2' => 'Stillehavs-Asia (Sydney) [ap-southeast-2]',
        'eu-central-1' => 'Europa (Frankfurt) [eu-central-1]',
        'eu-west-2' => 'Europa (London) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'Post Topptekst', // Studio editing of record views
    'LBL_RECORD_BODY' => 'Visittkort', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'Vis Mer', // Studio editing of record views
    'LBL_FAVORITE' => 'Favoritt', // Record view header panel element
    'LBL_FOLLOW' => 'Følg', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'Følg link',
    'LBL_TOGGLE_VISIBILITY' => 'Bytte mellom visning', // Record view header panel element
    'LBL_ACTIVITIES' => 'Aktivitetstrøm',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar og 3-D kuben er registrerte varemerker for SugarCRM Inc. ' .
        'Alle andre selskaps- og produktnavn som brukes eller vises i dette produktet kan være varemerker for de ' .
        'SugarCRM®, Sugar Enterprise™ og Sugar™ er varemerker som tilhører SugarCRM Inc.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ og Sugar™ er varemerker for SugarCRM Inc.',
    'LBL_SEND_INVITE' => 'Send invitasjon',
    'LBL_INVITEES' => 'Inviterte',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'Gjest får ikke invitasjonen din',
    'LBL_SELECT_ACTION_LABEL' => 'Velg handling',
    'LBL_TOGGLE_DRAWER' => 'Veksle skuff',
    'LBL_TOUR_NEXT' => 'Neste',
    'LBL_TOUR_SKIP' => 'Hopp over',
    'LBL_TOUR_BACK' => 'Tilbake',
    'LBL_TOUR_CLOSE' => 'Lukk',
    'LBL_TOUR_BTN_DONE' => 'Ferdig',
    'LBL_TOUR_TAKE_TOUR' => 'Ta omvisningen',
    'LBL_TOUR_FULL_TOUR' => 'Full innføring',
    'LBL_TOUR_MODULE' => 'Innføring av denne siden',
    'LBL_TOUR_END_TOUR' => 'Avslutt innføringen',
    'LBL_TOUR_OVERVIEW' => 'Side oversikt',
    'LBL_TOUR_REVISIT' => 'Klikk her for å vise innføringen til enhver tid.',
    'LBL_MY_AREA_LINKS' => 'Mine område-lenker:' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Skaffer luft' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'Velkommen' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'Avansert Søk' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'Flere Detaljer' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'Redigér' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'Vis' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Søk' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'Søk...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'Fjern' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'Legg til' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'Kolonne' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 Kolonner' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 Kolonner' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Avansert Søk' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'Tilføy' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'Skjul/Vis' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'Slett' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'Tilføy' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'Fjern' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'Fjern' /*for 508 compliance fix*/,
    'LBL_ADD' => 'Tilføy' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'Bedriftslogo' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'Kalender' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'En nedtrekksverdi du valgte endret din Record View-layout. ' .
        'Felt skjult i denne nye layouten har fjernet verdiene sine. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'Åpne',
    'LBL_SIDEBAR_NAV_CLOSE' => 'Lukk',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} meny',
    'LBL_GOTO_SUGARCRM_COM' => 'Gå til SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'navigasjon i hovedmodul',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'vis/skjul delpanel',

    'LBL_ADVANCED' => 'Avansert',
    'LBL_BASIC' => 'Grunnleggende',
    'LBL_MODULE_FILTER' => 'Filtrér Etter',
    'LBL_CONNECTORS_POPUPS' => 'Kobling-popups',
    'LBL_CLOSEINLINE' => 'Lukk',
    'LBL_EDITINLINE' => 'Rediger',
    'LBL_VIEWINLINE' => 'Vis',
    'LBL_INFOINLINE' => 'Info',
    'LBL_POWERED_BY_SUGARCRM' => 'Utviklet av SugarCRM',
    'LBL_PRINT' => 'Skriv ut',
    'LBL_HELP' => 'Hjelp',
    'LBL_TOUR' => 'Aktivitet-visning',
    'LBL_TOUR_LINK' => 'Innføring av denne siden',
    'LBL_MOBILE' => 'Mobil',
    'LBL_ID_FF_SELECT' => 'Velg',
    'DEFAULT' => 'Grunnleggende',
    'LBL_SORT' => 'Sorter',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Legg til server...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'Aktiver SMTP over SSL eller TLS?',
    'LBL_NO_ACTION' => 'Det er ingen handling med det navnet.',
    'LBL_NO_DATA' => 'Ingen data',
    'LBL_NOT_APPLICABLE' => 'Ikke aktuelt',
    'LBL_ROUTING_ADD_RULE' => 'Legg til regel',
    'LBL_ROUTING_ALL' => 'Alle',
    'LBL_ROUTING_ANY' => 'Enhver',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'Avbryt',
    'LBL_ROUTING_BUTTON_SAVE' => 'Lagre regel',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'Kopiér e-post',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Slett Sugar-objekt',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Slett fil',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'Slett e-post',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'Videresend e-post',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'Merk e-post',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'Merk som lest',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Merk som ulest',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'Flytt e-post',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'Utfør følgende',
    'LBL_ROUTING_ACTIONS_REPLY' => 'Besvar e-post',

    'LBL_ROUTING_CHECK_RULE' => "Oppdaget en feil:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'Kontrollér at alle felt er merket.',
    'LBL_ROUTING_CONFIRM_DELETE' => "Vil du slette denne regelen? Kan ikke omgjøres.",

    'LBL_ROUTING_FLAGGED' => 'Flaggruppe',
    'LBL_ROUTING_FORM_DESC' => 'Lagrede regler gjelder umiddelbart.',
    'LBL_ROUTING_FW' => 'VS:',
    'LBL_ROUTING_LIST_TITLE' => 'Regler',
    'LBL_ROUTING_MATCH' => 'Hvis',
    'LBL_ROUTING_MATCH_2' => 'av følgende betingelser oppfylles:',
    'LBL_NOTIFICATIONS' => 'Varsler',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'Kopi',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'Brødtekst',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'Fra',
    'LBL_ROUTING_MATCH_NAME' => 'Emne',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'Høy prioritet',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Normal prioritet',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Lav prioritet',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'Til',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'Inneholder',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'Inneholder ikke',

    'LBL_ROUTING_NAME' => 'Regelnavn',
    'LBL_ROUTING_NEW_NAME' => 'Ny regel',
    'LBL_ROUTING_ONE_MOMENT' => 'Vennligst vent...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Opprinnelig melding følger.',
    'LBL_ROUTING_RE' => 'Vedr.:',
    'LBL_ROUTING_SAVING_RULE' => 'Lagrer regel',
    'LBL_ROUTING_SUB_DESC' => 'Merkede regler er aktive. Klikk navn for å redigere.',
    'LBL_ROUTING_TO' => 'til',
    'LBL_ROUTING_TO_ADDRESS' => 'tiladresse',
    'LBL_ROUTING_WITH_TEMPLATE' => 'med mal',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'Du har for øyeblikket verdier i telefonnummer- og adresse feltene i skjemaet ditt. For å overskrive disse verdiene med telefonnummer/adresse fra kontoen du har valgt, klikk \\"OK\\". For å beholde de nåvärende verdiene, klikk \\"Cancel\\".',
    'LBL_DROP_HERE' => '[Slipp her]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'Rediger',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Startverdier for Gmail',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'Navn',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Utgående e-postserver',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'E-postagent',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'Bruke SMTP-autentisering?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP-passord',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP-port',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP-server',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'Bruke SSL ved oppkobling',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP-brukernavn',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Standard',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Advarsel: Mangler brukernavn og passord for utgående e-post konto.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP brukernavn er påkrevd',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP passord er obligatorisk',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'E-postkontohåndtering',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'Mail Server Protokoll av typen POP3 vil ikke bli støttet i neste versjon. Bare IMAP vil bli støttet.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'Sett opp e-post kontoer for å vise innkommende e-postmeldinger fra dine e-postkontoer.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Angi SMTP e-postserver  for utgående e-post fra e-postkontoer.',
    'LBL_EMAIL_ADD' => 'Legg til e-post',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Legg til',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Slett',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'Til:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Kopi:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Bcc',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'Til/Kopi/Blindkopi',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'Ny liste',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'E-postadresse',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Bare kontaktredigering kan brukes nå.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filter',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'Fornavn',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Etternavn',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'Mine kontakter',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'Mine distribusjonslister',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'Navn',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'Fant ingen adresser',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Lagre og legg til i adressebok',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Søk',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Velg adresser',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Adresser',
    'LBL_EMAIL_REPORTS_TITLE' => 'Rapporter',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'Advarsel! Den utgående kontoen du prøver å slette er knyttet til en eksisterende innkommende konto. Er du sikker på at du vil fortsette?',
    'LBL_EMAIL_ADDRESSES' => 'E-postadresse',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'E-postadresse',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'E-postadresser',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Importere til Sugar',
    'LBL_EMAIL_ASSIGNMENT' => 'Tildeling',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Filvedlegg til e-post',
    'LBL_EMAIL_ATTACHMENT' => 'Vedlegg',
    'LBL_EMAIL_ATTACHMENTS' => 'Vedlegg filer',
    'LBL_EMAIL_ATTACHMENTS2' => 'Vedlegg Sugar-dokumenter',
    'LBL_EMAIL_ATTACHMENTS3' => 'Malvedlegg',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'Fil',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Dokument',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Vedlagt',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'Vedlegg mislyktes i å laste opp',
    'LBL_REMOVING_ATTACHMENT' => 'Fjerner vedlegg...',
    'LBL_EMAIL_BCC' => 'Blindkopi',
    'LBL_EMAIL_CANCEL' => 'Avbryt',
    'LBL_EMAIL_CC' => 'Kopi',
    'LBL_EMAIL_CHARSET' => 'Tegnsett',
    'LBL_EMAIL_CHECK' => 'Kontrollér e-post',
    'LBL_EMAIL_CHECKING_NEW' => 'Let etter ny e-post',
    'LBL_EMAIL_CHECKING_DESC' => 'Leter etter nye e-postmeldinger. <br><br>Hvis det er første gangen du utfører denne handlingen, kan det ta litt tid.',
    'LBL_EMAIL_CLOSE' => 'Lukk',
    'LBL_EMAIL_COFFEE_BREAK' => 'Leter etter nye e-postmedlinger. <br><br>Store e-postkontoer kan ta lengre tid å laste opp.',
    'LBL_EMAIL_COMMON' => 'Felles',

    'LBL_EMAIL_COMPOSE' => 'E-postadresse',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Angi mottager(e) av denne meldingen.',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'Knytt til',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'Meldingen inneholder ikke brødtekst. Vil du sende likevel?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'Meldingen mangler emne. Vil du sende likevel?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(intet emne)',
    'LBL_EMAIL_COMPOSE_READ' => 'Les og skriv e-post',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Send fra e-postkonto',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'Valg',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Angi gyldig e-postadresse i Til, Kopi og Blindkopi',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'Vil du fjerne denne meldingen?',
    'LBL_EMAIL_CONFIRM_DELETE' => 'Vil du fjerne disse fra adresseboken din?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'Er du sikker på at du vil slette denne signaturen?',

    'LBL_EMAIL_CREATE_NEW' => '--Opprett ved lagring--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Flere',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Tom',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Dato aendt av avsender',
    'LBL_EMAIL_DATE_RECEIVED' => 'Dato for mottakelse',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'Tildelt bruker',
    'LBL_EMAIL_DATE_TODAY' => 'I dag',
    'LBL_EMAIL_DATE_YESTERDAY' => 'I går',
    'LBL_EMAIL_DD_TEXT' => 'melding(er) valgt.',
    'LBL_EMAIL_DEFAULTS' => 'Startverdier',
    'LBL_EMAIL_DELETE' => 'Slett',
    'LBL_EMAIL_DELETE_CONFIRM' => 'Vil du slette valgte meldinger?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'E-post ble slettet.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'Sletter melding',
    'LBL_EMAIL_DETAILS' => 'Detaljer',
    'LBL_EMAIL_DISPLAY_MSG' => 'Viser e-postmelding(er) {0} - {1} av {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'Viser e-postadresse(r) {0} - {1} av {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'Redigér kontakt',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Bare hovedadressen brukes i forbindelse med Kontakter.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'Redigér mottagerliste',

    'LBL_EMAIL_EMPTYING_TRASH' => 'Tømmer søppel',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'Sletter utgående server',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'Fjerner cache-filer.',
    'LBL_EMAIL_EMPTY_MSG' => 'Ingen e-postmeldinger å vise.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'Ingen e-postadresser å vise.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'Mappenavnet må være unikt og kan ikke være blankt. Vennligst prøv igjen.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'Denne mappen kan ikke slettes. Enten har mappen eller en undermappe en e-postkonto knyttet til seg.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'Den ønskede mappen kan ikke bli funnet utifra sammenhengen. Vennligst prøv igjen.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Vennligst sjekk dine innstillinger.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Vennligst oppgi et etternavn.',
    'LBL_EMAIL_ERROR_DESC' => 'Programmet oppdaget feil:',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'Trenger du aksess til dette området. Kontakt Administrator.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugar-mappenavn må være unike.',
    'LBL_EMAIL_ERROR_EMPTY' => 'Vennligst oppgi søkekriterier.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'Det oppsto en feil',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'En e-postliste med dette navnet finnes allerede',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Meldingen ble slettet fra serveren.',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'Meldingen har enten blitt slettet fra serveren eller flyttet til en annen mappe.',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'Tilkobling til e-postserveren mislyktes. Vennligst kontakt din administrator.',
    'LBL_EMAIL_ERROR_MOVE' => 'Det er for øyeblikket ikke mulig å flytte e-post mellom servere eller e-postkontoer.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'En feil oppsto ved flytting',
    'LBL_EMAIL_ERROR_NAME' => 'Vennligst oppgi et navn.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'Vennligst oppgi en avsenderadresse.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'Vennligst oppgi et filnavn.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'Det er for øyeblikket ikke mulig å omdøpe IMAP-mapper.',
    'LBL_EMAIL_ERROR_SERVER' => 'Oppgi en e-posttjeneradresse.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'E-postkontoen ble troligvis ikke lagret.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'En feil oppsto ved tilkobling til e-postserveren.',
    'LBL_EMAIL_ERROR_USER' => 'Vennligst oppgi et brukernavn.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'Vennligst oppgi et passord.',
    'LBL_EMAIL_ERROR_PORT' => 'Vennligst oppgi en serverport.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'Vennligst oppgi en serverprotokoll.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'Vennligst oppgi en overvåket mappe',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'Vennligst oppgi en søppelmappe',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'Denne informasjonen er ikke tilgjenngelig for øyeblikket.',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'Ingen utgående e-postserver spesifisert.',
    'LBL_EMAIL_FOLDERS' => 'Mapper',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'Flytt til',
    'LBL_EMAIL_FOLDERS_ADD' => 'Legg til',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Legg til ny mappe',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Endre mappenavn',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Legg til ny gruppemappe',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Legg til denne mappen i',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'Denne mappen kan ikke endres',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'Er du sikker på at du vil slette denne mappen?\nDenne handlingen kan ikke angres.\nVed å slette en mappe påvirker du alle underliggende mapper.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'Ny mappe',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Vennligst velg en mappe før du utfører denne handlingen.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'Sugar-mappe administrasjon',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Brukergruppe',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'Tildel til team',
    'LBL_EMAIL_FORWARD' => 'Videresend',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => 'Nedlasted[[count]] av [[total]] e-post',
    'LBL_EMAIL_FOUND' => 'Funnet',
    'LBL_EMAIL_FROM' => 'Fra',
    'LBL_EMAIL_GROUP' => 'gruppe',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'Gruppe',
    'LBL_EMAIL_HOME_FOLDER' => 'Hjem',
    'LBL_EMAIL_HTML_RTF' => 'Send HTML',
    'LBL_EMAIL_IE_DELETE' => 'Slett e-postkonto',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'Sletter signatur',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'Er du sikker på at du vil slette denne e-postkontoen?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Sletting utført.',
    'LBL_EMAIL_IE_SAVE' => 'Lagrer informasjon om e-postkonto',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'Importerer e-post',
    'LBL_EMAIL_IMPORT_EMAIL' => 'Importér til Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'Importer innstillinger',
    'LBL_EMAIL_INVALID' => 'Ugyldig',
    'LBL_EMAIL_LINK_RECORD' => 'Klikk her',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'Gi nytt navn til e-postliste',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'Oppgi et nytt navn for e-postliste',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'Vil du slette disse oppføringene i e-postlisten?',
    'LBL_EMAIL_LOADING' => 'Laster...',
    'LBL_EMAIL_MARK' => 'Markér',
    'LBL_EMAIL_MARK_FLAGGED' => 'Som merket',
    'LBL_EMAIL_MARK_READ' => 'Som lest',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'Som umerket',
    'LBL_EMAIL_MARK_UNREAD' => 'Som ulest',
    'LBL_EMAIL_ASSIGN_TO' => 'Tildel til',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'Opprett mappe',
    'LBL_EMAIL_MENU_COMPOSE' => 'Sett sammen til',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Slett mappe',
    'LBL_EMAIL_MENU_EDIT' => 'Rediger',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Tøm søppel',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Synkronisér',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Fjern cache- filer',
    'LBL_EMAIL_MENU_REMOVE' => 'Fjern',
    'LBL_EMAIL_MENU_RENAME' => 'Gi nytt navn',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Endre mappenavn',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Endrer mappenavn',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Foreta et valg før du utfører operasjonen.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Opprett en mappe (fjerntliggende eller i Sugar)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'Arkiver disse meldingene i SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'Send melding til valgte adresselister',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'Send melding til denne kontakten',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Fjern en kontakt',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'Fjern denne/disse meldingen(e)',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Fjern en mappe (fjerntliggende eller i Sugar)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Redigér en kontakt',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Redigér en e-postliste',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Tømmer papirkurvmappene for alle dine e-postkontoer',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'Merk disse som valgt',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'Merk disse som lest',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'Opphev merking av disse',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'Merk disse som ulest',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Fjerner meldingslister',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Endre mappenavn (fjerntliggende eller i Sugar)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'Besvar disse meldingene',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'Svar alle mottagerne av disse e-postmeldingene',

    'LBL_EMAIL_MESSAGES' => 'meldinger',

    'LBL_EMAIL_ML_NAME' => 'Listenavn',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'Valgte listeadresser',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'Tilgjengelige listeadresser',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-Click</b> for å velge flere<br />(Mac-brukere bruker <b>CMD-Click</b>)',

    'LBL_EMAIL_NO' => 'Nei',
    'LBL_EMAIL_NOT_SENT' => 'Systemet kan ikke behandle forespørselen. Vennligst kontakt systemadministrator.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'Kunne ikke sette inn users_password_link.',

    'LBL_EMAIL_OK' => 'OK',
    'LBL_EMAIL_ONE_MOMENT' => 'Vent litt...',
    'LBL_EMAIL_OPEN_ALL' => 'Åpne flere meldinger',
    'LBL_EMAIL_OPTIONS' => 'Valg',
    'LBL_EMAIL_QUICK_COMPOSE' => 'Oversettelse fra engelsk til norsk (bokmål)<br />Hurtig komponer',
    'LBL_EMAIL_OPT_OUT' => 'Reserverte seg',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Opted Out og ugyldig',
    'LBL_EMAIL_PAGE_AFTER' => 'av {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'Side',
    'LBL_EMAIL_PERFORMING_TASK' => 'Utfører oppgave',
    'LBL_EMAIL_PRIMARY' => 'Primær',
    'LBL_EMAIL_PRINT' => 'Skriv ut',

    'LBL_EMAIL_QC_BUGS' => 'Bug',
    'LBL_EMAIL_QC_CASES' => 'Sak',
    'LBL_EMAIL_QC_LEADS' => 'Lead',
    'LBL_EMAIL_QC_CONTACTS' => 'Kontakt',
    'LBL_EMAIL_QC_TASKS' => 'Oppgave',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'Mulighet',
    'LBL_EMAIL_QUICK_CREATE' => 'Quick Create',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'Gjenoppbygger mapper',
    'LBL_EMAIL_RELATE_TO' => 'Knytt til',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'Vis forhold',
    'LBL_EMAIL_RECORD' => 'E-post registrering',
    'LBL_EMAIL_REMOVE' => 'Fjern',
    'LBL_EMAIL_REPLY' => 'Svar',
    'LBL_EMAIL_REPLY_ALL' => 'Svar til alle',
    'LBL_EMAIL_REPLY_TO' => 'Svar til',
    'LBL_EMAIL_RETRIEVING_LIST' => 'Henter e-postliste',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Henter melding',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'Henter e-post oppføringen',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Vennligst velg en e-post oppføring',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'Tilbake til forrige modul?',
    'LBL_EMAIL_REVERT' => 'Gå tilbake',
    'LBL_EMAIL_RELATE_EMAIL' => 'Relater e-post',

    'LBL_EMAIL_RULES_TITLE' => 'Regelbehandling',

    'LBL_EMAIL_SAVE' => 'Lagre',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'Lagre & besvar',
    'LBL_EMAIL_SAVE_DRAFT' => 'Lagre utkast',

    'LBL_EMAIL_SEARCHING' => 'Utfører søk',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'Utvidet søk',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'Fra-dato',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Til-dato',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'Brødtekst',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'Dine søkekriterier ga ingen funn.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Søkeresultater',
    'LBL_EMAIL_SEARCH_TITLE' => 'Enkelt søk',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'Søk e-postkonto',

    'LBL_EMAIL_SELECT' => 'Velg',

    'LBL_EMAIL_SEND' => 'Send',
    'LBL_EMAIL_SENDING_EMAIL' => 'Sender e-post',

    'LBL_EMAIL_SETTINGS' => 'Innstillinger',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 rader',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 kolonner',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'Utformingstype',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'E-postkontoer',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Tøm skjema',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'Importér e-post ved oversyn',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Let etter ny e-post',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Bruk forhåndsvisningsramme',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Bruk sprettoppvindu',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'Antall e-poster pr side',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'Redigér e-postkonto',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'Mapper',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'Fra-adresse',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'E-postadresse for test melding:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'Til e-postadresse',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'Avsendernavn',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Svar til adresse',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Hele skjermen',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Synkronisér alle e-postkontoer',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'En e-post ble sendt til den oppgitte e-postadresse i henhold til angitte utgående e-post-innstillinger. Vennligst sjekk om e-posten ble mottatt for å kontrollere at innstillingene er riktige.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Ved å utføre denne handlingen vil alle mapper og innholdet synkroniseres.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'Vil du utføre en fullstendig synkronisering?\nStore e-postkontoer kan ta lang tid å gjennomføre.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Klikk på Shift knappen eller Ctrl knappen for å velge flere mapper',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'Generell',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Tilgjengelige gruppemapper',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Opprett gruppemapper',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Lagrer gruppemapper',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Henter gruppemappe',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Redigér gruppemappe',

    'LBL_EMAIL_SETTINGS_NAME' => 'Navn',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Velg antall e-poster som skal vises per side i Innboksen. Du må kanskje oppdatere siden for å vise endringene.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'Henter e-postkonto',
    'LBL_EMAIL_SETTINGS_RULES' => 'Regler',
    'LBL_EMAIL_SETTINGS_SAVED' => 'Innstillingene har blitt lagret.\n\nDu må oppdatere siden for at innstillingene skal tre i kraft.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'Du må laste siden på nytt for at de nye innstillingene skal tre i kraft.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'Send som vanlig tekst',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Aktive e-postkontoer',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'Antall meldinger pr side',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'Plassér arkfaner nederst',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Visuelle innstillinger',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Preferanser',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Vis avanserte valg',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Tilgjengelige brukermapper',
    'LBL_EMAIL_ERROR_PREPEND' => 'Feil:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'Den utgående e-postserver som er valgt for den e-postkontoen du bruker er ugyldig. Sjekk innstillingene eller velg en annen mail server for e-postkontoen.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'Utgående e-postserver er ikke konfigurert til å sende e-post. Vennligst konfigurer en utgående e-postserver eller velg en utgående e-postserver for e-postkonto som du bruker i Innstillinger >> Mail konto.',
    'LBL_EMAIL_SHOW_READ' => 'Vis alle',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Vis bare uleste',
    'LBL_EMAIL_SIGNATURES' => 'Signaturer',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'Opprett signatur',
    'LBL_EMAIL_SIGNATURE_NAME' => 'Signaturnavn',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'Signaturinnhold',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Google mindre sikre apper',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'Annen',
    'LBL_EMAIL_AUTHORIZE' => 'Godkjenn',
    'LBL_EMAIL_AUTHORIZED' => 'Godkjent',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'Ikke godkjent',
    'LBL_EMAIL_AUTH_WARNING' => 'En administrator må konfigurere {0} Connector via Admin > Connectors før du kan sette opp denne kontoen. For mer informasjon, se {1}-dokumentasjonen.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'Feil ved henting av Connector-informasjon',
    'LBL_EMAIL_AUTH_FAILURE' => 'Godkjenningsfeil.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'Godkjenn kontoen før du lagrer.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'Godkjenn kontoen før testing.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'Konto ikke godkjent',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Fjerntliggende mapper ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugar-mapper]',
    'LBL_EMAIL_SUBJECT' => 'Emne',
    'LBL_EMAIL_SUCCESS' => 'Vellykket',
    'LBL_EMAIL_SUGAR_FOLDER' => 'SugarMappe',
    'LBL_EMAIL_TEAMS' => 'Tilknytt gruppe',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'E-postmal innholdet er tomt',
    'LBL_EMAIL_TEMPLATES' => 'Maler',
    'LBL_EMAIL_TEXT_FIRST' => 'Første side',
    'LBL_EMAIL_TEXT_PREV' => 'Forrige side',
    'LBL_EMAIL_TEXT_NEXT' => 'Neste side',
    'LBL_EMAIL_TEXT_LAST' => 'Siste side',
    'LBL_EMAIL_TEXT_REFRESH' => 'Oppdatér',
    'LBL_EMAIL_TO' => 'Til',
    'LBL_EMAIL_TOGGLE_LIST' => 'Vippeliste',
    'LBL_EMAIL_VIEW' => 'Oversyn',
    'LBL_EMAIL_VIEWS' => 'Oppsett',
    'LBL_EMAIL_VIEW_HEADERS' => 'Vis overskrifter',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'Utskriftsversjon',
    'LBL_EMAIL_VIEW_RAW' => 'Vis utkast på e-post',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'Funksjonen støttes ikke ved bruk av POP3.',
    'LBL_DEFAULT_LINK_TEXT' => 'Startverdi link tekst.',
    'LBL_EMAIL_YES' => 'Ja',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Send test e-post',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Test e-post sendt',


    'LBL_EMAIL_MESSAGE_NO' => 'Melding nummer',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'Import passert',
    'LBL_EMAIL_IMPORT_FAIL' => 'Importering mislykket på grunn av at meldingen enten er importert allerede, eller slettet fra server',

    'LBL_EMAILS_FROM' => 'Sendte e-poster',
    'LBL_EMAILS_RECEIVED' => 'Mottatte e-poster',
    'LBL_EMAIL_ADDRESSES_USED' => 'E-postadresser brukt i e-poster',
    'LBL_EMAIL_ADDRESS' => 'E-postadresse',
    'LBL_FROM' => 'Fra',
    'LBL_TO' => 'Til',
    'LBL_CC' => 'Kopi',
    'LBL_BCC' => 'Blindkopi',

    'LBL_START_DATE' => 'Startdato',
    'LBL_END_DATE' => 'Sluttdato',
    'LBL_START' => 'Start',
    'LBL_END' => 'Slutt',
    'LBL_DATE_LINKED' => 'Dato koblet',

    'LBL_LINK_NONE' => 'Ingen',
    'LBL_LINK_ALL' => 'Alle',
    'LBL_LINK_RECORDS' => 'Poster',
    'LBL_LINK_SELECT' => 'Velg',
    'LBL_LINK_ACTIONS' => 'Handlinger',
    'LBL_LINK_MORE' => 'Mer',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'Bekreft:',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'Ønsker du å lukke denne #module#?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'Ikke vis denne meldingen i fremtiden:',
    'LBL_INVALID_FILE_EXTENSION' => 'Ugyldig filtype',
    'LBL_LIST_TEAM' => 'Gruppe',
    'LBL_TEAM' => 'Gruppe:',
    'LBL_TEAMS' => 'Grupper',
    'LBL_TEAM_SET_ID' => 'Team sett ID',
    'LBL_TEAM_SET_SELECTED_ID' => 'Valg gruppesett-ID',
    'LBL_TEAM_SET_SELECTED' => 'Valgt',
    'LBL_TEAM_SET_ENABLE' => 'Aktiver flere tillatelser',
    'LBL_TEAM_SET_DISABLE' => 'Deaktiver flere tillatelser',
    'LBL_TEAM_SET' => 'Team sett',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'Valgte grupper',
    'LBL_SEARCH_UNAVAILABLE' => 'Søk ikke tilgjengelig, vennligst forsøk igjen senere.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'Primært team ikke spesifisert',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'Feil ved forsøk å fjerne primær team ID [{0}] for [{1}] modul med ID [{2}]',
    'LBL_TEAM_ADD' => 'Legg til team',
    'LBL_TEAM_REMOVE' => 'Fjern team',
    'LBL_TEAM_PRIMARY' => 'Angi som primært team',

    'LBL_CLOSE_BUTTON_LABEL' => 'Lukk',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} merket som {{status}}.',

    'LBL_FOCUS' => 'Fokus',

    'LBL_QUERY_VALID' => 'Gyldig',
    'LBL_QUERY_ERROR' => 'Feil!',
    'LBL_QUERY_CHILD' => 'Gyldig underspørsmål',
    'ERROR_EXAMINE_MSG' => 'Vennligst undersøk den følgende meldingen:',
    'NO_QUERY_SELECTED' => 'Informasjon du har valgt inneholder intet spørsmål. Vennligst velg et spørsmål for dette dataformatet.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'En feil har oppstått:',
    'ERR_AJAX_LOAD_FAILURE' => 'Noe gikk galt under prosesseringen av din forespørsel, vennligst forsøk igjen senere.',
    'ERR_AJAX_LOAD_FOOTER' => 'Hvis denne feilen ikke forsvinner, så be din Administrator om å slå av Ajax på denne modulen',
    'ERR_CREATING_FIELDS' => 'Feil ved utfylling av tilleggsinformasjonsfelt:',
    'ERR_CREATING_TABLE' => 'Mislykket oppretting av tabell:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'Desimalseparatoren kan ikke bruke de samme tegnene som tusendelsseparatoren.

 Vennligst velg andre verdier.',
    'ERR_DELETE_RECORD' => 'Du må oppgi postens nummer for å slette kontoen.',
    'ERR_EXPORT_DISABLED' => 'Eksport deaktivert.',
    'ERR_EXPORT_TYPE' => 'Feil ved eksportering',
    'ERR_REPORTS_DISABLED_EXPORT' => 'Eksport av rapporter er deaktivert',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'Kun administratorbrukere kan eksportere',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'Rapport bruker moduler uten eksporttilgang',
    'ERR_REPORTS_EXPORT_OWNER' => 'Rapport bruker moduler med eiereksporttilgang',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'Rapport bruker moduler med listebegrenset tilgang',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'Rapport bruker moduler med visningsbegrenset tilgang',
    'ERR_REPORTS_ACCESS_DISABLED' => 'Rapport bruker moduler med begrenset tilgang',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'Rapport bruker felt med begrenset tilgang',
    'ERR_INVALID_AMOUNT' => 'Angi et gyldig beløp.',
    'ERR_INVALID_DATE_FORMAT' => 'Datoformatet må være:',
    'ERR_INVALID_DATE' => 'Angi en gyldig dato.',
    'ERR_INVALID_DAY' => 'Angi en gyldig dag.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'er ikke en gyldig e-postadresse.',
    'ERR_INVALID_FILE_REFERENCE' => 'Ugyldig filreferanse',
    'ERR_INVALID_HOUR' => 'Angi et gyldig klokkeslett.',
    'ERR_INVALID_MONTH' => 'Angi en gyldig måned.',
    'ERR_INVALID_TIME' => 'Angi et gyldig tidspunkt.',
    'ERR_INVALID_YEAR' => 'Bruk firesifret årstall.',
    'ERR_NEED_ACTIVE_SESSION' => 'En aktiv sesjon er påkrevet for å eksportere innhold.',
    'ERR_NO_HEADER_ID' => 'Dette valget er ikke tilgjengelig i dette temaet.',
    'ERR_NOT_ADMIN' => 'Ulovlig adgang til administrasjon.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'Passordadministrering er kun tilgjengelig i <a href="%s" target="_blank">SugarCloud-innstillinger</a>.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'Kontakt Sugar-administrator hvis du ønsker å endre skrivebeskyttede felt.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'Få tilgang til <a href="{0}" target="_blank">SugarCloud-innstillinger</a> for å gjøre endringer i skrivebeskyttede felt.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'Du må fylle ut felt:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'Ugyldig påkrevet felt.',
    'ERR_INVALID_VALUE' => 'Ugyldig verdi:',
    'ERR_NO_SUCH_FILE' => 'Filen finnes ikke på systemet',
    'ERR_NO_SINGLE_QUOTE' => 'Kan ikke bruke enkle anførselstegn for ',
    'ERR_NOTHING_SELECTED' => 'Foreta et valg før du fortsetter.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'En mulighet med navnet %s finnes allerede. Vennligst angi et annet navn nedenfor.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'Et mulighetsnavn ble ikke angitt. Vennligst oppgi et mulighetsnavn herunder.',
    'ERR_QUOTE_CONVERTED' => 'Dette tilbudet er allerede konvertert til en salgsmulighet',
    'ERR_POTENTIAL_SEGFAULT' => 'En mulig Apachefeil ble oppdaget. Vennligst ta kontakt med din administrator for å bekrefte problemet og for hjelp til å rapportere til SugarCRM.',
    'ERR_SELF_REPORTING' => 'Brukeren kan ikke rapportere til seg selv.',
    'ERR_SINGLE_QUOTE' => 'Enkeltspørsmål er ikke støttet på dette feltet. Vennligst velg et annen område.',
    'ERR_SQS_NO_MATCH_FIELD' => 'Ingen treff for feltet:',
    'ERR_SQS_NO_MATCH' => 'Ingen treff',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Vennligst spesifiser "nøkkel" indeks i displayParams attributt for Meta-Data definisjonen.',
    'ERR_EXISTING_PORTAL_USERNAME' => 'Feil: Portal Navnet er allerde tildelt en annen kontakt.',
    'ERR_PORTAL_NAME_CHECK' => 'Kan ikke bekrefte at Portal brukernavn er unikt',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'Verdiene i feltene er ikke kompatible med presisjonsverdi',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'En feil oppstod ved forsøk på å lagre til den eksterne kontoen.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'Det oppstod en feil ved opplasting. Sørg for at filen du laster opp, er ikke tom.',
    'ERR_NO_DB' => 'Kunne ikke koble til databasen. Vennligst referer til sugarcrm.log for detaljer.',
    'ERR_DB_FAIL' => 'Database feil. Vennligst referer til sugarcrm.log for detaljer.',
    'ERR_EXTERNAL_API_403' => 'Tillatelse avvist. Filtypen støttes ikke.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth Access Token mangler.',
    'ERR_DB_VERSION' => 'Sugar CRM {0} filer kan bare brukes med en Sugar CRM {1} Database.',
    'ERR_DB_QUERY' => '{0}: spørring mislyktes: {1}',
    'ERR_UW_RETIRED' => 'Oppgrader Wizard er ikke tilgjengelig i denne versjonen.',
    'ERR_NOT_CLOUD_INSTANCE' => 'Denne forekomsten av Sugar er enten ikke en SugarCloud-forekomst eller ikke konfigurert for SugarCloud Insights.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'Du er ikke autorisert til å opprette  {moduleName}. Kontakt administratoren hvis du trenger tilgang.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'Nåværende bruker ikke autorisert til å endre {moduleName} konfigurasjonsinnstillinger',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'Nåværende bruker ikke autorisert til å endre {moduleName} konfigurasjonsinnstillinger',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'Du er ikke autorisert til å lage favoritt {moduleName}. Kontakt administratoren hvis du trenger tilgang.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'Du er ikke autorisert til å abonnere på {moduleName}. Kontakt administratoren hvis du trenger tilgang.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'worksheet_columns_related_fields ikke funnet i nyttelast',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns er ikke en tabell',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'worksheet_columns_related_fields ikke funnet i nyttelast',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows er ikke en tabell',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rows_related_fields ikke funnet i nyttelast',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'Forespørselen mislyktes på grunn av et ukjent unntak.',
    'EXCEPTION_FATAL_ERROR' => 'Forespørselen ble ikke fullført. En fatal feil oppstod. Sjekk loggene for flere detaljer.',
    'EXCEPTION_NEED_LOGIN' => 'Du må være logget inn for å utføre denne handlingen.',
    'EXCEPTION_INVALID_TOKEN' => 'Din autentiserings token er ugyldig.',
    'EXCEPTION_NOT_AUTHORIZED' => 'Du er ikke autorisert til å utføre denne handlingen. Kontakt administratoren hvis du trenger tilgang.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'Du er ikke autorisert til å vise data. Kontakt administratoren hvis du trenger tilgang.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'Du kan ikke få tilgang til portalen fordi din portalkonto er inaktiv. Vennligst kontakt kundeservice dersom du trenger tilgang.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'Portalen er ikke riktig konfigurert. Kontakt din Portal Administrator for å få hjelp.',
    'EXCEPTION_NO_METHOD' => 'Din forespørsel ble ikke støttet. Kunne ikke finne HTTP-metoden av din forespørsel for denne banen.',
    'EXCEPTION_NOT_FOUND' => 'Din forespurte ressurs ble ikke funnet. Kunne ikke finne et behandlingsprogram for banen som er angitt i forespørselen.',
    'EXCEPTION_MISSING_PARAMTER' => 'Et nødvendig parameter i din forespørsel manglet.',
    'EXCEPTION_INVALID_PARAMETER' => 'Et parameter i forespørselen var ugyldig.',
    'EXCEPTION_REQUEST_FAILURE' => 'Din forespørsel ble ikke fullført.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'Din metadata eller bruker-hash samsvarte ikke med serveren. Vennligst synkronisert din metadata.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'Din forespørsel er for stor til å prosessere.',
    'EXCEPTION_EDIT_CONFLICT' => 'Rediger konflikt, vennligst oppdater post data.',
    'EXCEPTION_METADATA_CONFLICT' => 'Metadata konflikt, vennligst oppdater metadata.',
    'EXCEPTION_CLIENT_OUTDATED' => 'Programvaren er gått ut på dato, vennligst oppdater din klient før du prøver å koble til igjen.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'En connector eller en integrert forespørsel resulterte i en mislykket respons.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM er i vedlikeholdsmodus. Kun administratorer kan logge inn. Ta kontakt med din administrator for detaljer.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'Serveren kan ikke behandle forespørselen din fordi den er opptatt eller utilgjengelig for øyeblikket.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'Søkemotoren er midlertidig utilgjengelig.',
    'EXCEPTION_SEARCH_RUNTIME' => 'En gjennomkjøringsfeil oppsto i søkemotoren. Ta kontakt med systemadministratoren din.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'Et felt som er låst av en prosess kan ikke redigeres.',
    'EXCEPTION_MODULE_DISABLED' => 'Denne modulen er deaktivert for nåværende bruker.',
    'EXCEPTION_FIELD_DISABLED' => 'Dette feltet er deaktivert for nåværende bruker.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'Denne klienten er ikke tillatt',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'Muligheten til å laste opp pakker er ikke tilgjengelig for din lisenstype',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'En tilstand oppstod på grunn av en generell svikt eller feil. Årsakene til dette unntakets rekkevidde, faller generelt utenfor rammen av en mer spesifikk API unntak.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'Forespørselen kan ikke behandles som presentert, eller det var en feil med responsen. Dette betyr vanligvis at en fatal feil oppstod, og at den spesifikke svikt kan identifiseres i programloggen.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'Den versjonen av API du bruker, er ikke riktig for den gjeldende forespørselen.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'Det forespurte endepunkt krever godkjenning og forbrukeren har ennå ikke godkjent.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'Indikerer at godkjennings token presentert ved forespørselen er ugyldig. Dette skjer som regel på grunn av at token utløper, men kan også være fordi token er misformet eller er feil.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'Indikerer at den forespurte forbrukeren ikke er autorisert til å utføre den forespurte handlingen.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'Portalkontoen som er tilknyttet den påloggede brukeren er ikke aktiv. Dette krever handling fra kundesupport.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'Indikerer at portalprogrammet ikke er riktig konfigurert, og kan ikke brukes. Dette krever handling fra portaladministrator.',
    'EXCEPTION_NO_METHOD_DESC' => 'Endepunktet støtter ikke HTTP-forespørseltypen som blir gjort. Dette kan for eksempel skje når en POST forespørsel blir gjort til et endepunkt designet for en GET-forespørsel.',
    'EXCEPTION_NOT_FOUND_DESC' => 'Endepunktet kan ikke finne en ressurs for forespørselen eller har ikke et behandlingsprogram for forespørselen.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'Indikerer at det kan ha vært parallelle endringer av en post, og den nåværende forespørselen om å redigere posten ville påvirke en tidligere redigering av posten.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'Viser at metadata på serveren ikke samsvarer med metadata klienten bruker for øyeblikket. Dette kan skje etter en endring i systeminnstillingene, endringer i moduler i Studio eller utplassering av nye moduler, blant andre systemendringer.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'Forespørselen er for store til å bli håndtert av serveren.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'Indikerer et nødvendig parameter for forespørselen mangler.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'Indikerer et parameter sendt inn der forespørselen er ugyldig.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'Forespørselen ble ikke fullført.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'Indikerer at klienten som forbruker API er utdatert og må oppdateres før ytterligere forbruk av API kan finne sted.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'Indikerer at en forespørsel gjort gjennom API-en til en annen tjeneste, sluttpunkt eller URI mislyktes og kunne ikke håndteres av serveren.',
    'EXCEPTION_MAINTENANCE_DESC' => 'Instansen av SugarCRM som er server for API er i vedlikeholdsmodus. Tilgang til API er begrenset til kun administratorer.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'Indikerer at serveren er opptatt, overbelastet eller nede.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'Søkemotorens backend er for øyeblikket utilgjengelig på grunn av et tilkoblingsproblem. Bekreft tilkoblingen og konfigurasjonen under Admin->Søk->Test.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'Et kjøreunntak oppsto i SearchEngine. Se sugarcrm.log for mer informasjon.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'Et felt som er låst av en prosess som kjører kan ikke redigeres.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s er låst av en prosess som kjører og kan ikke redigeres.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s er låst av en prosess som kjører, og kan ikke redigeres.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'Denne modulen er deaktivert for nåværende bruker.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'Dette feltet er deaktivert for nåværende bruker.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'Denne klienten er ikke tillatt',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'En fil med samme navn finnes allerede i systemet.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'Feil Tidsperiode udefinert for datoen {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'Denne Tidsperiode har allerede delperioder',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'Under tidsperioder kan ikke ha delperioder',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'Kan ikke hente noen tidsperioder av typen: {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'Ingen aktive tidsperioder for gjeldende innstillinger.',
    'LBL_CURRENT_TIMEPERIOD' => 'Nåværende tidsperiode',
    'LBL_PREVIOUS_TIMEPERIOD' => 'Forrige tidsperiode',
    'LBL_NEXT_TIMEPERIOD' => 'Neste tidsperiode',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'Forrige, Nåværende, Neste',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'Du kan ikke slette poster med lukkede salgsfaser.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'Du kan ikke slette poster med lukkede salgsstatuser.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'Én eller flere av de valgte postene har en salgsfase som Lukket vunnet eller Lukket tapt og kan ikke slettes.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'Én eller flere av de valgte postene har en salgsstatus som Lukket vunnet eller Lukket tapt og kan ikke slettes.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'Bedrift',
    'LBL_OLD_ACCOUNT_LINK' => 'Gammel bedrift',
    'LBL_ACCOUNTS' => 'Bedrifer',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Aktiviteter',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Vis sammendrag',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Vis sammendrag [Alt+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Tilføy [Alt+A]',
    'LBL_ADD_BUTTON' => 'Tilføy',
    'LBL_ADD_DASHLET_BUTTON' => 'Legg til dashlet',
    'LBL_ADD_DOCUMENT' => 'Tilføy dokument',
    'LBL_REPLACE_BUTTON' => 'Erstatt',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Legg til i målliste',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Legg til i målliste',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Klikk for å lukke',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Lukk',
    'LBL_ADDITIONAL_DETAILS' => 'Tilleggsinformasjon',
    'LBL_ADMIN' => 'Administrator',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'Arkiv',
    'LBL_ASSIGNED_TO_USER' => 'Tildelt bruker',
    'LBL_ASSIGNED_TO' => 'Tildelt:',
    'LBL_BACK' => 'Tilbake',
    'LBL_BASE_RATE' => 'Grunnlagsrente',
    'LBL_BILL_TO_ACCOUNT' => 'Faktura til kunde',
    'LBL_BILL_TO_CONTACT' => 'Faktura til kontakt',
    'LBL_BILLING_ADDRESS' => 'Fakturaadresse',
    'LBL_QUICK_CREATE_TITLE' => 'Opprett Raskt',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'Feil',
    'LBL_BY' => 'ved',
    'LBL_CALLS' => 'Oppringninger',
    'LBL_CALL' => 'Oppringning',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Send kampanjemeldinger som står i kø',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Send',
    'LBL_CASE' => 'Sak',
    'LBL_CASES' => 'Saker',
    'LBL_MESSAGE' => 'Melding',
    'LBL_MESSAGES' => 'Meldinger',
    'LBL_ESCALATIONS' => 'Opptrappinger',
    'LBL_ESCALATION' => 'Opptrapping',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign omslag',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign omslag',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'Velg mottakere for underskriver',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'Endre passord',
    'LBL_CHANGE_BUTTON_LABEL' => 'Endre',
    'LBL_CHANGE_BUTTON_TITLE' => 'Endre [Alt+G]',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Merk alle',
    'LBL_CITY' => 'By',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Tøm',
    'LBL_CLEAR_BUTTON_TITLE' => 'Tøm [Alt+C]',
    'LBL_CLEARALL' => 'Tøm alle',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => 'Lukk',
    'LBL_CLOSE_BUTTON_KEY' => 'C',
    'LBL_CLOSE_WINDOW' => 'Lukk vindu',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Lukk alle',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Lukk alle [Alt+I]',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Lukk og opprett ny',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Lukk og opprett ny',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'Kopier register-URL',
    'LBL_OPEN_ITEMS' => 'Åpne elementer:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Skriv e-post',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'E-post',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Skriv e-post [Alt+L]',
    'LBL_SEARCH_DROPDOWN_YES' => 'Ja',
    'LBL_SEARCH_DROPDOWN_NO' => 'Nei',
    'LBL_CONTACT_LIST' => 'Kontaktliste',
    'LBL_CONTACT' => 'Kontakt',
    'LBL_CONTACTS' => 'Kontakter',
    'LBL_CONTRACTS' => 'Kontrakter',
    'LBL_COUNTRY' => 'Land:',
    'LBL_RESET_BUTTON_LABEL' => 'Tilbakestill',
    'LBL_CREATE_BUTTON_LABEL' => 'Opprett',
    'LBL_CREATED_BY_USER' => 'Opprettet av bruker:',
    'LBL_CREATED_USER' => 'Opprettet av bruker',
    'LBL_CREATED_ID' => 'Opprettet av Id:',
    'LBL_CREATED' => 'Opprettet av',
    'LBL_CREATE_NEW_TARGET_LIST' => 'Opprett ny mål liste',
    'LBL_CURRENT_USER_FILTER' => 'Mine elementer:',
    'LBL_CURRENCY' => 'Valuta:',
    'LBL_CURRENCIES' => 'Valuta',
    'LBL_CURRENCY_NAME' => 'Valuta navn',
    'LBL_CURRENCY_SYMBOL' => 'Valutategn',
    'LBL_CURRENCY_RATE' => 'Valutakurs',
    'LBL_CURRENCY_ID' => 'Valuta ID',
    'LBL_DOCUMENTS' => 'Dokumenter',
    'LBL_DATE_ENTERED' => 'Opprettet dato:',
    'LBL_DATE_MODIFIED' => 'Sist endret:',
    'LBL_ACTIVITY_MODIFIED' => 'Endret',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'Rediger Oversikt-fane',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'Rediger Modul-faner',
    'LBL_EDIT_BUTTON' => 'Rediger',
    'LBL_DUPLICATE_BUTTON' => 'Dupliser',
    'LBL_DELETE_BUTTON' => 'Slett',
    'LBL_DELETE' => 'Slett',
    'LBL_DELETED' => 'Slett',
    'LBL_DIRECT_REPORTS' => 'Direkterapporter',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Ferdig',
    'LBL_DONE_BUTTON_TITLE' => 'Utført [Alt+X]',
    'LBL_DST_NEEDS_FIXIN' => 'Programmet krever sommertid for å brukes. Gå til <a href="index.php?module=Administration&action=DstFix">Reparer</a>-lenken i administrasjonskonsollen og bruk sommertid.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Rediger som ny',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Rediger som ny',
    'LBL_EDIT_IN_NEW_TAB' => 'Rediger i ny fane',
    'LBL_FAVORITES' => 'Favoritter',
    'LBL_FILTER' => 'Filter',
    'LBL_DEFAULT_DATA_FILTER' => 'Standard datafilter',
    'LBL_FILTER_MENU_BY' => 'Filtrér Menyen Etter',
    'LBL_FILTER_SELECT_FIELD' => 'Velg felt',
    'LBL_FILTER_SELECT_OPERATOR' => 'Velg operatør',
    'LBL_FILTER_CREATE_NEW' => 'Opprett',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'Konstruer filter (ikke lagret)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(Ikke lagret)',
    'LBL_FILTER_CREATE_FILTER' => 'Opprett nytt filter',
    'LBL_FILTER_CLOSE_FILTER' => 'Lukk filter',
    'LBL_FILTER_EDIT_FILTER' => 'Rediger filter',
    'LBL_FILTER_ALL_RECORDS' => 'Alle poster',
    'TPL_FILTER_SAVE' => 'Du lykkes i å skape filteret {{name}}.',
    'LBL_FILTER_BETWEEN_FROM' => 'Fra',
    'LBL_FILTER_BETWEEN_TO' => 'Til',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'Start dato',
    'LBL_FILTER_DATEBETWEEN_TO' => 'Slutt dato',
    'LBL_FOLLOWING' => 'Følger',
    'LBL_UNFOLLOW' => 'Slutt å følge',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'Last ned vCard',
    'LBL_EMPTY_VCARD' => 'Vennligst velg en vCard fil',
    'LBL_IMAGE' => 'Bilde',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard har ikke alle de nødvendige feltene for denne modulen.',
    'LBL_VCARD_ERROR_FILESIZE' => 'Den opplastede filen overstiger 30 000 bytes størrelsesbegrensningen som ble spesifisert i HTML-skjemaet.',
    'LBL_VCARD_ERROR_DEFAULT' => 'Det oppstod en feil ved opplasting av vCard filen.',
    'TPL_IMPORT_VCARD_FAILURE' => 'Kunne ikke opprette {{module}} fra vCard',
    'LBL_IMPORT_VCARD' => 'Importer vCard',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'Importer vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'Importer vCard [Alt + I]',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'Vis',
    'LBL_VIEW_BUTTON_TITLE' => 'Vis [Alt+V]',
    'LBL_VIEW_BUTTON' => 'Vis',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'Send e-post som PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'Send e-post som PDF [Alt+M]',
    'LBL_EMAIL' => 'E-postadresse',
    'LBL_EMAILS' => 'E-post',
    'LBL_EMPLOYEES' => 'Ansatte',
    'LBL_ENTER_DATE' => 'Skriv dato',
    'LBL_EXPORT_ALL' => 'Eksportér alle',
    'LBL_EXPORT' => 'Eksportér',
    'LBL_FAVORITES_FILTER' => 'Mine favoritter:',
    'LBL_GLOBAL_SEARCH' => 'Globalt Søk',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'Globalt søk modul filter',
    'LBL_GLOBAL_SEARCH_RUN' => 'Kjør Globalt søk',
    'LBL_GO_BUTTON_LABEL' => 'Gå',
    'LBL_GS_HELP' => 'Feltene i denne modulen som brukes i dette søket vises over. Den markerte teksten møter dine søkekriteria.',
    'LBL_HIDE' => 'Skjul',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => 'Importer',
    'LBL_IMPORT_STARTED' => 'Importering ble startet:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Oppgi skilletegn.',
    'LBL_LAST_VIEWED' => 'Sist vist',
    'LBL_SELECTED_RECORDS' => 'Valg: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'Vis Mindre',
    'LBL_SHOW_MORE' => 'Vis Mer',
    'LBL_SHOW_MORE_MODULE' => 'Flere {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'Flere brukte',
    'LBL_SHOW_LESS_RECENTS' => 'Færre brukte',
    'LBL_SHOW_MORE_RESULTS' => 'Flere søketreff …',
    'TPL_SHOW_MORE_MODULE' => 'Flere {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => 'Mer {{name}} …',
    'LBL_TODAYS_ACTIVITIES' => 'Dagens aktiviteter',
    'LBL_LEADS' => 'Emner',
    'LBL_LEAD' => 'Lead',
    'LBL_QUOTES_BILL_TO' => 'Sitater (regne til)',
    'LBL_LESS' => 'mindre',
    'LBL_CAMPAIGN' => 'Kampanje:',
    'LBL_CAMPAIGNS' => 'Kampanje',
    'LBL_CAMPAIGNLOG' => 'KampanjeLogg',
    'LBL_CAMPAIGN_CONTACT' => 'Kampanjer',
    'LBL_CAMPAIGN_ID' => 'campaign_id',
    'LBL_THEME' => 'Tema:',
    'LBL_THEME_PICKER' => 'Sidestil',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Advarsel: Internet Explorer 6 støttes ikke for det valgte temaet. Klikk OK for å velge det likevel, eller Avbryt for å velge et annet tema.',
    'LBL_FOUND_IN_RELEASE' => 'Funnet ved utsendelse',
    'LBL_FIXED_IN_RELEASE' => 'Ordnet ved utsendelse',
    'LBL_LIST_ACCOUNT_NAME' => 'Kundenavn',
    'LBL_LIST_ASSIGNED_USER' => 'Bruker',
    'LBL_LIST_CONTACT_NAME' => 'Kontaktens navn',
    'LBL_LIST_CONTACT_ROLE' => 'Kontaktens rolle',
    'LBL_LIST_DATE_ENTERED' => 'Opprettet dato',
    'LBL_LIST_EMAIL' => 'E-postadresse',
    'LBL_LIST_NAME' => 'Navn',
    'LBL_LIST_OF' => 'av',
    'LBL_LIST_PHONE' => 'Telefon',
    'LBL_LIST_RELATED_TO' => 'Tilknyttet',
    'LBL_LIST_USER_NAME' => 'Brukernavn',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'Vil du virkelig oppdatere hele listen?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Velg minst én post før du fortsetter.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Velg minst 2 poster før du fortsetter.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Velg mindre enn 10 poster før du fortsetter',
    'LBL_LISTVIEW_ALL' => 'Alle',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'Frys spalte 1',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'Alle duplikater',
    'LBL_LISTVIEW_NONE' => 'Ingen',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Denne siden',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Alle poster',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Valgte poster',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Valg: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'Fjern alle valg.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'Velg alle poster',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'Det er mer enn {{num}} poster i resultatsettet. Du har valgt den første {{num}} poster.',
    'TPL_LISTVIEW_SELECTED' => 'Du har valgt {{num}} postene i resultatsettet.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'Du har valgt 1 oppføring i resultatsettet.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'Du har valgt alle {{num}} postene i resultatsettet.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'Du har valgt alle {{num}} poster i denne visningen. {{link}} i resultatsettet.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'Oppdaterer {{num}} av {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(ca {{time}} {{unit}} gjenstår)',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'Masseoppdatering mislyktes. Starte nytt forsøk ({{num}} av {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'Masseoppdatering ufullstendig.{{num}} post(er) forblir uendret.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'Masseoppdatering ufullstendig.{{num}} post(er) forblir uendret.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} post(er) ble oversett på grunn av tillatelse eller feil.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} post(er) ble oppdatert riktig.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} Masseoppdatering',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'Sletter {{num}} av {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(ca {{time}} {{unit}} igjen)',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'Masseoppdatering mislyktes. Starte nytt forsøk ({{num}} av {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'Massesletting ufullstendig. {{num}} post(er) gjenstår.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'Massesletting ufullstendig. {{num}} post(er) gjenstår.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} post(er) ble slettet.',
    'TPL_MASSDELETE_TITLE' => '{{module}} Massesletting',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'Legger til {{num}} av {{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(ca {{time}} {{unit}} gjenstår)',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'Massetillegg til Mål Listen mislyktes. Starte nytt forsøk ({{num}} av {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'Massetillegg til Mål Listen er ufullstendig. {{num}} poster ikke lagt til.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'Massetillegg til Mål Listen er ufullstendig. {{num}} poster ikke lagt til.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} poster ble lagt til.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} Massetillegg til Mål Listen.',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'Linker {{num}} av {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(ca {{time}} {{unit}} gjenstår)',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'Masselink mislyktes. Starte nytt forsøk ({{num}} av {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'Massekobling ufullstendig. {{num}} poster ikke lagt til.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'Massekobling ufullstendig. {{num}} poster ikke lagt til.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} poster ble koblet med hell.',
    'TPL_MASSLINK_TITLE' => '{{module}} Massekobling',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'Velg',
    'LBL_LISTVIEW_ACTIONS' => 'Handlinger',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'Velger alle oppføringer på denne siden',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'Velger bort alle oppføringer på denne siden',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} av {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '{{num}} av laster...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'Klikk for total',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'av',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'Få antall sider',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'Ukjent',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Person',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Hr',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Code Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => 'Logg inn for å få tilgang til dette området',
    'LBL_LOGOUT' => 'Logg ut',
    'LBL_FINISH_IMPERSONATING' => 'Fullfør imitasjon',
    'LBL_RESET_MFA' => 'Tilbakestill flerfaktorautentisering',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, du etterligner for øyeblikket {{user}}.',
    'LBL_PROFILE' => 'Profil',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'E-postfusjonering',
    'LBL_MASS_UPDATE' => 'Masseoppdatering',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'Velg alle innlegg for masseoppdatering',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'Inkluder innlegg i masseoppdatering',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'Legg til felt',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'Fjern felt',
    'LBL_GENERATE_QUOTE' => 'Opprett tilbud',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'Det er ingen felter tilgjengelig for Masseoppdaterings-operasjonen',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'Din forespørsel om masse oppdatering har blitt planlagt.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'Servicestartdato overskrider servicesluttdato',
    'LBL_MASS_UPDATE_SUCCESS' => 'Alle poster ble oppdatert riktig.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'Valgte poster ble lagt til <a href="{{listUrl}}">{{listName}}</a> mål listen.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'Din forespørsel om å legge til valgte poster til <a href="{{listUrl}}">{{listName}}</a> mål listen er planlagt',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'Oppdateringen vil fjerne følgende verdier:',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'Avbryt for å beholde eksisterende verdier. Bekreft for å fjerne verdier.',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'Velg bort primær e-post',
    'LBL_MEETINGS' => 'Møter',
    'LBL_MEETING' => 'Møte',
    'LBL_MEETING_GO_BACK' => 'Gå tilbake til møtet',
    'LBL_MEMBERS' => 'Medlemmer',
    'LBL_MEMBER_OF' => 'Medlem av',
    'LBL_MODIFIED_BY_USER' => 'Endret av bruker',
    'LBL_MODIFIED_USER' => 'Endret av bruker',
    'LBL_MODIFIED' => 'Endret av',
    'LBL_MODIFIED_NAME' => 'Endret av navm',
    'LBL_MODIFIED_ID' => 'Endret av Id',
    'LBL_MORE' => 'mer',
    'LBL_MORE_MODULES' => 'Flere moduler',
    'LBL_MORE_TABS' => 'Flere faner',
    'LBL_MULTIPLE_MODULES' => 'Flere moduler',
    'LBL_COUNT_MODULES' => '{{count}} moduler',
    'LBL_MY_ACCOUNT' => 'Min konto',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'systemstandard',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'brukerstandard',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'brukerkonto',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'gruppekonto',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'Navn',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Opprett',
    'LBL_NEW_BUTTON_TITLE' => 'Opprett',
    'LBL_NEXT_BUTTON_LABEL' => 'Neste',
    'LBL_NOTES' => 'Notater',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Åpne alle',
    'LBL_OPENALL_BUTTON_TITLE' => 'Åpne alle [Alt+O]',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Åpne til:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Åpne til: [Alt+T]',
    'LBL_OPEN_IN_NEW_TAB' => 'Åpne i ny fane',
    'LBL_OPPORTUNITIES' => 'Muligheter',
    'LBL_OPPORTUNITY_NAME' => 'Mulighetsnavn',
    'LBL_OPPORTUNITY' => 'Mulighet',
    'LBL_OR' => 'ELLER',
    'LBL_LOWER_OR' => 'eller',
    'LBL_PANEL_ASSIGNMENT' => 'Annen',
    'LBL_PANEL_ADVANCED' => 'Mer informasjon',
    'LBL_PANEL_BODY' => 'Oversikt',
    'LBL_PARENT_TYPE' => 'Overordnet type',
    'LBL_RELATED_TYPE' => 'Relatert type',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'Fase',
    'LBL_PICTURE_FILE' => 'Bilde',
    'LBL_POSTAL_CODE' => 'Postnummer:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'By (hovedadresse):',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'Land (hovedadresse):',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'Postnummer (hovedadresse):',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Poststed (hovedadresse):',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Hovedadr.: Gate 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Hovedadr.: Gate 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Gateadresse (hovedadresse):',
    'LBL_PRIMARY_ADDRESS' => 'Hovedadresse:',

    'LBL_BILLING_STREET' => 'Vei:',
    'LBL_SHIPPING_STREET' => 'Vei:',

    'LBL_PRODUCT_BUNDLES' => 'Produktpakker',
    'LBL_PRODUCTS' => 'Produkter',
    'LBL_PROJECT_TASKS' => 'Prosjektoppgaver',
    'LBL_PRODUCT_TEMPLATES' => 'Produktmaler',
    'LBL_PROJECTS' => 'Prosjekter',
    'LBL_PROSPECTS' => 'Mål',
    'LBL_QUICK_CREATE_MENU' => 'Hurtig lag meny',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Opprett mulighet fra Tilbud',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Opprett mulighet fra Tilbud[Alt+O]',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'Oppretter mulighet ...',
    'LBL_QUOTES_SHIP_TO' => 'Tilbud sendes til',
    'LBL_QUOTES' => 'Tilbud',

    'LBL_FORECAST_WORKSHEETS' => 'Prognose regneark',
    'LBL_FORECAST_WORKSHEET' => 'Prognose regneark',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'Invitere',
    'LBL_INVITED' => 'Inviterte',
    'LBL_RECOMMENDED_INVITES' => 'Anbefalte inviterte',
    'LBL_INSTANCES' => 'Instanser',
    'LBL_YOUR_INSTANCES' => 'Dine instanser',
    'LBL_INSTANCE_USERS' => 'Brukers instanser',
    'LBL_SWITCH_INSTANCE' => 'Bytt til denne instanse',
    'LBL_LAST_LOGIN' => 'siste innlogging',
    'LBL_ENTER_EMAIL' => 'Skriv inn invitertes e-post...',
    'LBL_INSTANCE_IN_USE' => 'Instansen er i bruk',
    'LBL_INSTANCE_ACTIVE' => 'Du bruker allerede denne instanse!',
    'LBL_INSTANCE_INVITE_SENT' => 'Invitasjon er sendt til',
    'LBL_INSTANCE_SWITCH_FAILED' => 'Kunne ikke bytte instanser',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'Påminnelser',
    'LBL_REMINDERS_OVERDUE' => 'Forfalt',
    'LBL_REMINDERS_UPCOMING' => 'Kommende',
    'LBL_REMINDERS_NONE_FOUND' => 'Ingen påminnelser funnet.',
    'LBL_REMINDERS_FINISHED' => 'Ferdig!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'Salgsmulighet Metrics',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'Sweet Spot-konfigurasjonspanel',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'Snarveier',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'Kunne ikke oppdatere konfigurasjonspreferansene: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'Sweet Spot-handling',
    'LBL_SWEETSPOT_KEY' => 'Nøkkelord',
    'LBL_SWEETSPOT_REMOVE' => 'Fjern handling',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'Snarveier',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'Handlinger',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'Poster',
    'LBL_SWEETSPOT_THEME' => 'Tema',
    'LBL_SWEETSPOT_THEME_SELECT' => 'Velg tema',

    'LBL_RELATED' => 'Relatert',
    'LBL_RELATED_INFORMATION' => 'Relatert informasjon',
    'LBL_RELATED_RECORDS' => 'Relatert {{module}}',
    'LBL_REPORTS_TO' => 'rapporterer til',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'Felt som må fylles ut',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Utført',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Lagre som',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Lagre som [Alt+A]',
    'LBL_FULL_FORM_BUTTON_KEY' => 'F',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Fullstendig skjema',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Fullstendig skjema [Alt+F]',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Lagre & opprett ny',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Lagre & opprett ny [Alt+V]',
    'LBL_SAVE_OBJECT' => 'Lagre {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Søk',
    'LBL_SEARCH_BUTTON_TITLE' => 'Søk [Alt+Q]',
    'LBL_SEARCH' => 'Søk',
    'LBL_SEARCH_TIPS' => 'Trykk søkeknappen eller linjeskift for å finne et eksakt treff for dem.',
    'LBL_SEARCH_TIPS_2' => 'Trykk søkeknappen eller linjeskift for å finne et eksakt treff for',
    'LBL_SEARCH_MORE' => 'mer',
    'LBL_SEE_ALL' => 'Se alle',
    'LBL_SEARCH_LOAD_MORE' => 'LAST FLERE',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Ugyldig filformat, kun bilde-fil kan lastes opp.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'Bilde format {0} er ikke lenger støttet.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Velg',
    'LBL_SELECT_BUTTON_TITLE' => 'Velg [Alt+T]',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'Legg til team',
    'LBL_SELECT_TEAMS_TITLE' => 'Legg til team [Alt+Z]',
    'LBL_SELECT_APPEND_TEAMS' => 'Tilføy team',
    'LBL_SELECT_APPEND_VALUES' => 'Tilføy verdier',
    'LBL_SELECT_APPEND_TAGS' => 'Legg ved tag(s)',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Bla i dokumenter',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Bla i dokumenter [Alt+B]',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Velg kontakt',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Velg kontakt [Alt+T]',
    'LBL_GRID_SELECTED_FILE' => 'valgt fil',
    'LBL_GRID_SELECTED_FILES' => 'valgte filer',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Valgt fra rapporter',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Valgte rapporter',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Velg bruker',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Velg bruker [Alt+U]',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Fjern valg',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Fjern valg',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Fjern valg',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Fjern valg',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Velg Fil',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Velg Fil',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Fjern fil',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Fjern fil',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Velg Bruker',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Velg Bruker',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Fjern bruker',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Fjern bruker',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Velg Konto',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Velg Konto',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Fjern konto',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Fjern konto',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Velg kampanje',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Velg kampanje',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Fjern kampanje',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Fjern kampanje',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'Velg Kontakt',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'Velg Kontakt',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Fjern kontakt',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Fjern kontakt',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Velg team',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Velg team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Fjern team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Fjern team',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Ressurser som denne siden settes sammen av (queries, filer)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'sekunder.',
    'LBL_SERVER_RESPONSE_TIME' => 'Svartid på server:',
    'LBL_SERVER_MEMORY_BYTES' => 'bytes',
    'LBL_SERVER_MEMORY_USAGE' => 'Minneforbruk Server: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Forbruk: - modul: {0} - action: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Minnebruk ved serverhøydepunkt: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'Send til bedrift',
    'LBL_SHIP_TO_CONTACT' => 'Send til kontakt',
    'LBL_SHIPPING_ADDRESS' => 'Leveringsadresse',
    'LBL_SHORTCUTS' => 'Snarveier',
    'LBL_SHOW' => 'Vis',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'Poststed:',
    'LBL_STATUS_UPDATED' => 'Din status for denne hendelsen ble  oppdatert.',
    'LBL_STATUS_NOT_UPDATED' => 'Din status for denne hendelsen ble ikke oppdatert.',
    'LBL_STATUS' => 'Status:',
    'LBL_STREET' => 'Gate',
    'LBL_SUBJECT' => 'Emne',

    'LBL_INBOUNDEMAIL_ID' => 'Innkommende e-post ID',
    'LBL_EAMP_ID' => 'Godkjenningstoken-ID',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'Alle rettigheter reservert. <br /> SugarCRM, Sugar og 3-D kuben er registrerte varemerker for SugarCRM Inc. ' .
        'Alle andre selskaps- og produktnavn som brukes eller vises i dette produktet kan være varemerker for de ' .
        'respektive selskapene som de er tilknyttet til.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'Planlagt jobb fullført',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'Den planlagte jobben er kjørt',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'Omsetningsposter er nå aktivert i din Sugar-instans',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Omsetningsposter er nå aktivert i din Sugar-instans, og alle eksisterende Mulighet-data er behandlet. Instansen din er nå klar til å brukes med omsetningsposter. For mer informasjon om de utførte endringene, se {{doc_url}}.

Vennlig hilsen,
SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'Prognosemodulen er nå klar for bruke med Muligheter i din Sugar-instans',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'Prognosemodulen i Sugar-instansen din er nå tilgjengelig for bruk med muligheter. Alle tidligere bundede prognosedata for omsetningsposter er fjernet, og instansen er klar for å opprette prognoser som bindes til muligheter. For mer informasjon om endringene, se {{doc_url}}.

Vennlig hilsen,
SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Omsetningspostene er nå deaktivert i Sugar-instansen din',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Omsetningsposter er nå deaktivert i Sugar-instansen din, og alle eksisterende data for omsetningsposter er behandlet. Instansen din er nå klar for å brukes med muligheter. For mer informasjon om endringene som er gjort, se {{doc_url}}.

Vennlig hilsen,
SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'Dokumentasjon for mulighetskonfigurasjon',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'Logg inn',
    'LBL_LOGIN_WELCOME_TO' => 'Velkommen til',
    'LBL_LOGIN_OPTIONS' => 'Alternativer',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'Glemt Passord?',
    'LBL_LOGIN_SUBMIT' => 'Send inn',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'For mange mislykkede innloggingsforsøk.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'Du kan prøve å logge inn på nytt om',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'dager.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 't.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'min.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'sek.',
    'LBL_LOGIN_ADMIN_CALL' => 'Vennligst kontakt systemadministrator.',
    'LBL_LOGIN_USERNAME' => 'Brukernavn',
    'LBL_LOGIN_PASSWORD' => 'Passord',
    'LBL_LOGGED_OUT' => 'Du er logget ut.',
    'LBL_LOGIN_FORM_LABEL' => 'Vis innloggings skjema',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'Gå tilbake til innlogging',
    'LBL_LOGIN_INACTIVE_USER' => 'Inaktiv bruker',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'Portal- eller gruppebruker kan ikke logge på.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'Hjem',
    'LBL_SYNC' => 'Synk',
    'LBL_TASKS' => 'Oppgaver',
    'LBL_TEAMS_LINK' => 'Team',
    'LBL_THEME_COLOR' => 'Farge',
    'LBL_THEME_FONT' => 'Skrifttype',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'Planlegg møte',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'Planlegg møte',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'Arkivér e-post',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'Arkivér e-post [Alt+K]',
    'LBL_UNAUTH_ADMIN' => 'Ulovlig tilgang til administrasjon',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Opphev fjerning',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Opphev fjerning [Alt+D]',
    'LBL_UNDELETE_BUTTON' => 'Opphev fjerning',
    'LBL_UNDELETE' => 'Opphev fjerning',
    'LBL_UNSYNC' => 'Opphev synkronisering',
    'LBL_UPDATE' => 'Oppdater',
    'LBL_UPDATES' => 'Oppdateringer',
    'LBL_USER_LIST' => 'Brukerliste',
    'LBL_USER_MENU' => 'Bruker meny',
    'LBL_USERS_SYNC' => 'Brukersynkronisering',
    'LBL_USERS' => 'Brukere',
    'LBL_USER' => 'Bruker',
    'LBL_CURRENT_USER' => 'Gjeldende bruker',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'Sjekker eksisterende e-post tilgang',
    'LBL_VERIFY_PORTAL_NAME' => 'Sjekker eksisterende portalnavn...',
    'LBL_VIEW_IMAGE' => 'vis',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'Skriv ut som PDF',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'Skriv ut som PDF [Alt+P]',

    'LBL_KBDOCUMENTS' => 'KB-dokumenter',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'Om',
    'LNK_ADVANCED_SEARCH' => 'Utvidet søk',
    'LNK_BASIC_SEARCH' => 'Enkelt søk',
    'LNK_SEARCH_NO_RESULTS' => 'Ingen resultater funnet.',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'Vis alle resultater',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Vis Alle',
    'LNK_CLOSE' => 'lukk',
    'LBL_MODIFY_CURRENT_SEARCH' => 'Endre nåværende søk',
    'LNK_SAVED_VIEWS' => 'Lagret søk & utforming',
    'LNK_DELETE_ALL' => 'slett alle',
    'LNK_DELETE' => 'slett',
    'LNK_EDIT' => 'endre',
    'LNK_VIEW' => 'visning',
    'LNK_GET_LATEST' => 'Hent nyeste',
    'LNK_GET_LATEST_TOOLTIP' => 'Erstatt med nyeste versjon',
    'LNK_HELP' => 'Hjelp',
    'LNK_CREATE' => 'Opprett',
    'LNK_CREATE_WHEN_EMPTY' => 'Opprett en oppføring nå.',
    'LNK_LIST_END' => 'Slutten',
    'LNK_LIST_NEXT' => 'Neste',
    'LNK_LIST_PREVIOUS' => 'Forrige',
    'LNK_LIST_RETURN' => 'Tilbake til liste',
    'LNK_LIST_START' => 'Start',
    'LNK_LOAD_SIGNED' => 'Signer',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'Erstatt med signert dokument',
    'LNK_PRINT' => 'Skriv ut',
    'LNK_BACKTOTOP' => 'Tilbake til topp',
    'LNK_REMOVE' => 'rem',
    'LNK_RESUME' => 'Gjenoppta',
    'LNK_VIEW_CHANGE_LOG' => 'Vis revisjonslogg',
    'TPL_AUDIT_LOG_TITLE' => 'Revisjonslogg for {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'Klikk for å vise e-postadresses overvåkingslogg',
    'LBL_NO_SEARCH_RESULTS' => 'Ingen resultater funnet for søket ditt',
    'NTC_CLICK_BACK' => 'Klikk Tilbake-knappen i nettleseren og rett feilen.',
    'NTC_DATE_FORMAT' => '(åååå-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(åååå-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'Vil du virkelig slette de valgte postene?',
    'NTC_TEMPLATE_IS_USED' => 'Malen brukes i minst en e-post markedsføringspost. Er du sikker på at du vil slette den?',
    'NTC_TEMPLATES_IS_USED' => "Disse malen brukes i e-post markedsføringsposter. Er du sikker på at du vil slette den?",
    'NTC_DELETE_CONFIRMATION' => 'Vil du virkelig slette denne posten?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'Er du sikker på at du vil slette {0}?',
    'LBL_METRIC_DELETE_WARNING' => 'Brukere denne metriske fanen er delt med vil også miste tilgang.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'Vil du virkelig slette',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'Vil du virkelig oppdatere',
    'NTC_DELETE_SELECTED_RECORDS' => 'valgte poster?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'Dette filter vil bli fjernet fra alle visninger, dette kan inkludere datakonfigurasjoner for dashlets. Er du sikker på at du vil slette dette filter?',
    'TPL_DELETE_FILTER_SUCCESS' => 'Du slettet filteret {{name}}.',
    'NTC_DELETE_SUCCESS' => 'Du slettet {0}.',
    'NTC_UNLINK_CONFIRMATION' => 'Er du sikker på at du vil koble fra denne posten?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'Er du sikker på at du vil koble fra {0}?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'Er du sikker på at du vil fjerne {0}? Dette vil også fjerne dem fra sakens primære kontaktfelt.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => '{0} kan ikke fjernes fordi de er den primære kontakten i denne saken. Oppdater feltet Primær kontakt før du fjerner dette innlegget.',
    'NTC_UNLINK_SUCCESS' => 'Du frakoblet {0}.',
    'NTC_LOGIN_MESSAGE' => 'Skriv brukernavn og passord:',
    'NTC_NO_ITEMS_DISPLAY' => 'ingen',
    'NTC_REMOVE_CONFIRMATION' => 'Vil du virkelig fjerne denne forbindelsen?',
    'NTC_REQUIRED' => 'Felt som må fylles ut',
    'NTC_SUPPORT_SUGARCRM' => 'Support the SugarCRM open source project with a donation through PayPal - it&#39;s fast, free and secure!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'Velkommen',
    'NTC_YEAR_FORMAT' => '(åååå)',
    'LOGIN_LOGO_ERROR' => 'Erstatt SugarCRM-logoene.',
    'FATAL_LICENSE_ALTERED' => 'Din lisens har blitt forandret siden forrige gang du validerte den.',
    'ERROR_FULLY_EXPIRED' => "Din bedrifts lisens for å bruke SugarCRM utgikk for mer enn 30 dager siden og trenger en oppdatering. Kun admin kan logge inn.",
    'ERROR_LICENSE_EXPIRED' => "Din bedrifts lisens for å bruke SugarCRM trenger å bli oppdatert. Kun admin kan logge inn",
    'WARN_LICENSE_EXPIRED' => "Din bedrifts lisens for SugarCRM utløper snart.",
    'ERROR_LICENSE_VALIDATION' => "Din bedrifts lisens for å bruke SugarCRM trenger å bli godkjent. Kun admin kan logge inn",
    'WARN_LICENSE_VALIDATION' => "Din bedrifts lisens for SugarCRM må valideres snart.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => 'Advarsel: Nettleseren din er i IE kompatibilitet visning som ikke er støttet.',
    'WARN_LICENSE_SEATS' => 'Advarsel: Antall aktive brukere er allerede tilsvarende maksimalt antall tillatte lisenser.',
    'WARN_LICENSE_SEATS_MAXED' => 'Advarsel: Antall aktive brukere er allerede tilsvarende maksimalt antall tillatte lisenser.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'Antall aktive brukere overskrider lisensantallgrenser. Kontakt systemansvarlig.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'Bare administratorer kan logge inn.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'Brukerlisenstallgrensen er nådd. Bare eksisterende brukere kan logge inn.',
    'WARN_ONLY_ADMINS' => 'Bare administratorer kan logge inn.',
    'WARN_UNSAVED_CHANGES' => 'Du er i ferd med å forlate denne posten uten å lagre eventuelle endringer du har gjort. Er du sikker på at du vil forlate denne posten?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Oppdatering av nettleseren vil automatisk lukke alle SugarLive-anrops- eller chatøkter du har åpen, og alle ulagrede endringer vil gå tapt. Ønsker du å fortsette?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'Du har ulagrede endringer. Er du sikker på at du vil forlate siden og forkaste endringene?',
    'LBL_MFA_RESET_CONFIRMATION' => 'Er du sikker på at du vil tilbakestille <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank"> flerfaktorautentisering </a>?
Hvis du utfører denne handlingen, logger du deg ut umiddelbart, og du må autentisere ved hjelp av autentiseringsappen neste gang du logger på.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'Bekreft og logg ut',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'En eller flere små streker har ulagrede endringer. Er du sikker på at du vil lukke skuffen?',
    'LBL_NAVIGATE_TO_REPORTS' => 'Du flytter til rapportmodulen. Endringene til dashlet vil ikke bli lagret. Fortsett?',
    'ERROR_NO_RECORD' => 'En feil oppsto ved henting av fil. Denne oppføringen kan ha blitt slettet eller så har du ikke tilgang til å vise filen.',
    'ERROR_TYPE_NOT_VALID' => 'Error. Denne typen er ikke gyldig.',
    'ERROR_MAX_FIELD_LENGTH' => 'Feil. Maks lengde på dette feltet er {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'Feil. Minstelengde på dette feltet er {{this}}.',
    'ERROR_EMAIL' => 'Feil. Ugylding epostadresse: {{#each this}}{{this}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'Feil. Minst én primær adresse skal noteres.',
    'ERROR_DUPLICATE_EMAIL' => 'Feil. Duplikat E-postadresse: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'Feil. Dette feltet er obligatorisk.',
    'ERROR_MINVALUE' => 'Feil. Minimumverdi i dette feltet er {{this}}.',
    'ERROR_MAXVALUE' => 'Feil. Maksimumverdi i dette feltet er {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'Feil. Verdien av dette feltet må være større enn {{this}}.',
    'ERROR_IS_LESS_THAN' => 'Feil. Verdien av dette feltet må være mindre enn {{this}}.',
    'ERROR_DATETIME' => 'Feil. Dette felt krever en gyldig dato.',
    'ERROR_IS_BEFORE' => 'Feil. Datoen for dette feltet kan ikke være etter datoen for {{this}} feltet.',
    'ERROR_IS_AFTER' => 'Feil. Datoen for dette feltet kan ikke være før datoen for {{this}} feltet.',
    'ERROR_TIME_IS_BEFORE' => 'Feil: Klokkeslettet for dette feltet må være før klokkeslettet for {{this}} feltet.',
    'ERROR_TIME_IS_AFTER' => 'Feil: Klokkeslettet for dette feltet må være etter klokkeslettet for {{this}} feltet.',
    'ERROR_NUMBER' => 'Feil. Dette felt kever et gyldig nummer.',
    'ERROR_INT' => 'Feil: Ugyldig heltall.',
    'ERROR_URL' => 'Feil. Ugyldig URL.',
    'ERROR_NO_BEAN' => 'Fikk ikke tak i bean.',
    'ERROR_ACCESS_MODULE' => 'Du har ikke tilgang til denne modul.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'Vedlegget er for stort.',
    'ERROR_UPLOAD_FAILED' => 'Feil. Filen ble ikke lastet opp.',
    'ERROR_UPLOAD_ACCESS_PD' => 'Du har ikke tillatelse til å opprette [process definitions] for denne modulen.',
    'ERROR_UPLOAD_ACCESS_BR' => 'Du har ikke tillatelse til å opprette [business rules] for denne modulen.',
    'ERROR_UPLOAD_ACCESS_ET' => 'Du har ikke tillatelse til å opprette [email templates] for denne modulen.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'Feil. Du anga en ikke støttet operatør.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'Feil. Du anga en ugyldig operatør.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'Feil. Du anga et ugyldig filter.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'Importen mislyktes. Et grupperingsfelt er delvis låst i prosessdefinisjonen.' .
        ' Disse feltene må låses i prosessdefinisjonen for at definisjonen skal importeres.',
    'ERROR_EXP_DATE_LOW' => 'Feil. Utløpsdatoen kan ikke være før publiseringsdatoen.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'Feil. Godkjentstatusen krever en publiseringsdato.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'Publiseringsdatoen er tom.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'Finn dubletter',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'Duplikatkontroll er deaktivert for {{module}}.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'Behandle abonnementer',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Behandle abonnementer for',
    'LBL_SUBSCRIBE' => 'Abonnér',
    'LBL_UNSUBSCRIBE' => 'Avslutt abonnement',
    'LBL_CREATE_LINK_RECORD' => 'Opprett og koble post',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'Opprett og koble post',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} poster har blitt koblet.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'Ingen poster å koble.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'Rapporten valgt er ikke basert på den riktige modultype.',
    'ERROR_EMPTY_LINK_MODULE' => 'Vennligst velg forholdet først.',
    // Ajax status strings
    'LBL_LOADING' => 'Laster...',
    'LBL_LOADING_NO_DOTS' => 'Laster inn',
    'LBL_SEARCHING' => 'Søker...',
    'LBL_SEARCH_UNDERWAY' => 'Søker …',
    'LBL_SAVING_LAYOUT' => 'Lagrer oppsett...',
    'LBL_SAVED_LAYOUT' => 'Oppsettet er lagret.',
    'LBL_SAVED' => 'Lagret',
    'LBL_SAVING' => 'Lagrer',
    'LBL_FAILED' => 'Mislyktes!',
    'LBL_DISPLAY_COLUMNS' => 'Vis kolonner',
    'LBL_HIDE_COLUMNS' => 'Skjul kolonner',
    'LBL_SEARCH_CRITERIA' => 'Søkekriterier',
    'LBL_SAVED_VIEWS' => 'Lagrede oppsett',
    'LBL_PROCESSING_REQUEST' => 'Arbeider...',
    'LBL_REQUEST_PROCESSED' => 'Ferdig',
    'LBL_AJAX_FAILURE' => 'Ajax feil',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'Søk...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Lagrede søk',
    'LBL_SEARCH_POPULATE_ONLY' => 'Utfør søk med søkeskjemaet ovenfor.',
    'LBL_SEARCH_NO_RESULTS' => 'Ingen resultater funnet for',
    'LBL_SEARCH_FOR' => 'Søk etter',
    'LBL_SEARCH_FOR_MORE' => 'Søk etter flere...',
    'LBL_SEARCH_SELECT' => 'Velg...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'Søk og velg …',
    'LBL_SEARCH_SELECT_MODULE' => 'Velg {{module}}...',
    'LBL_DETAILVIEW' => 'Detaljert',
    'LBL_LISTVIEW' => 'Liste',
    'LBL_EDITVIEW' => 'Redigering',
    'LBL_SEARCHFORM' => 'Søkeskjema',
    'LBL_SAVED_SEARCH_ERROR' => 'Angi et navn for dette oppsettet.',
    'LBL_DISPLAY_LOG' => 'Lis logg',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Sted:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Beskrivelse:',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'starter',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'Klikk OK for å se denne samtalen eller klikk Avbryt for å avbryte denne meldingen.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'Klikk OK for å se dette møtet eller klikk Avbryt for å avbryte denne meldingen.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'Ingen resultater.',
    'MSG_LIST_VIEW_NO_RESULTS' => 'ingen resultater for',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Opprett som ny',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'Du har for øyeblikket ingen oppføringer lagret.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'Du har for øyeblikket ingen <item1>-poster lagret. <item2> en nå.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'Du kan opprette <item1> fra en <item2>. <item3> <item2>-liste.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'Positiv',
    'LBL_SENTIMENT_NEUTRAL' => 'Nøytral',
    'LBL_SENTIMENT_NEGATIVE' => 'Negativ',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'Ingen metriske faner konfigurert',
    'LBL_NO_METRIC_VISIBLE' => 'Ingen metriske faner er synlige',
    'LBL_MAKE_METRIC_VISIBLE' => 'Velg «organiser» for å gjøre metriske faner synlige',
    'LBL_PLEASE_CONTACT_ADMIN' => 'Vennligst kontakt administratoren',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'Klikk her',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Legg til mine favoritter',
    'LBL_MARK_AS_FAVORITES' => 'Merk som favoritt',
    'LBL_CREATE_CONTACT' => 'Opprett kontakt',
    'LBL_CREATE_NOTE' => 'Opprett notat',
    'LBL_CREATE_OPPORTUNITY' => 'Opprett mulighet',
    'LBL_SCHEDULE_CALL' => 'Opprett oppringning',
    'LBL_SCHEDULE_CALL2' => 'Telefonsamtale',
    'LBL_SCHEDULE_MEETING' => 'Opprett møte',
    'LBL_SCHEDULE_MEETING2' => 'Møte',
    'LBL_CREATE_MESSAGE' => 'Opprett melding',
    'LBL_CREATE_MESSAGE2' => 'Beskjed',
    'LBL_CREATE_TASK' => 'Opprett oppgave',
    'LBL_CREATE_TASK2' => 'Oppgave',
    'LBL_REMOVE_FROM_FAVORITES' => 'Fjern fra Mine favoritter',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'Melding',
    'LBL_DOWNLOAD_ALL' => 'Last ned alle',
    'LBL_DOWNLOAD_ONE' => 'Last ned',
    'LBL_ATTACHMENTS' => 'Vedlegg',
    'LBL_ADD_ATTACHMENT' => 'Bla gjennom',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Lag skjema',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Lagre web til leadblankett',

    'LBL_PLEASE_SELECT' => 'Velg',
    'LBL_REDIRECT_URL' => 'Tilknyttet URL',
    'LBL_RELATED_CAMPAIGN' => 'Beslektet kampanje',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Bruk alle feltene',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Fjern alle feltene',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Bare bildevedlegg kan legges inn.',
    'LBL_REMOVE' => 'Fjern',
    'LBL_TRAINING' => 'Opplæring',
    'ERR_DATABASE_CONN_DROPPED' => 'En feil oppsto ved gjennomføring av forespørsel. Kanskje kan din database ha kuttet tilkoblingen. Vennligst oppdater denne siden, og eventuelt gjør en omstart på webserveren.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'Feil innstilling {0} forhold: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'Endret databasekontekst til',
    'ERR_MSSQL_WARNING' => 'Advarsel:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'Klarte ikke å tolke vCard format',
    'ERR_VCARD_FILE_MISSING' => 'vcf fil mangler',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Advarsel: feltet [[field]] har ikke en avbildet oppføring i filen [moduleDir] vardefs.php',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Feil: Filen [[file]] mangler. Kunne ikke opprettes fordi ingen korresponderende HTML-fil ble funnet.',
    'ERR_CANNOT_FIND_MODULE' => 'Error: Modulen eksisterer ikke',
    'LBL_ALT_ADDRESS' => 'Annen adresse:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Error: There are an unequal number of arguments for the &#39;key&#39; and &#39;copy&#39; elements in the displayParams array.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Missing index in displayParams Array for:',

    'LBL_DASHLET' => 'Dashlet',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filtre',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Kun mine ting',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Tittel',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Vis rader',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'Relatert til nåværende post',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'Koblet felt',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'Frys første spalte',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'Er du sikker på at du vil gjerne Dashlet?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'Er du sikker på at du vil fjerne rekken?',
    'LBL_MAXIMUM_OF' => 'Maksimalt av',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => 'kolonner kan vises.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'Hjem',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'Mitt Dashboard',
    'LBL_COLLAPSE_ALL' => 'Forminsk alle',
    'LBL_EXPAND_ALL' => 'Forstørr alle',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'Rediger',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'Vis rapport',
    'LBL_DASHLET_REFRESH_LABEL' => 'Oppdater',
    'LBL_DASHLET_REMOVE_LABEL' => 'Fjern',
    'LBL_DASHLET_DROP_HERE' => 'Dropp her',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'Lukk',
    'LBL_DASHLET_MAXIMIZE' => 'Åpen',
    'LBL_DASHLET_CONFIGURE' => 'Konfigurer',
    'LBL_DASHLET_TOGGLE' => 'Åpne/Lukke',
    'LBL_SIDEPANE_TOGGLE' => 'Åpne/lukke siderute',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'Gjenopprett vanlige dashlets',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'Ingen dashbord konfigurert',
    'LBL_CREATE_DASHBOARD_LINK' => 'Opprett dashbord',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'Hjelp',
    'LBL_HELPLET_TOGGLE' => 'Åpne/Lukke',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'Moduler',
    'LBL_FACET_MODIFIED_BY_ME' => 'Modifisert av meg',
    'LBL_FACET_CREATED_BY_ME' => 'Opprettet av meg',
    'LBL_FACET_MY_FAVORITES' => 'Mine favoritter',
    'LBL_FACET_ASSIGNED_TO_ME' => 'Tildelt meg',
    'LBL_FACET_NO_DATA' => 'Ingen data for denne fasetten.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'Listevisning',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'Lister poster fra en bestemt modul i henhold til kriteriene du definerer.',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'Konsollistevisning',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'Lister opp registre fra en spesifikk modul som er relatert til registeret du viser i konsollen.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'Registervisning',
    'LBL_RELATED_RECORDS' => 'Relatert {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'Viser et register og valgfrie relaterte registre i faner.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'Grunnregistertype',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'Denne {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'Faner',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'Grunnleggende forhåndsvisning av layout',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'Advarsel, kun {{numWord}} ({{num}}) moduler kan vises i faner. ' .
        'Fjern en eller flere moduler før nye legges til.',
    'LBL_SIX' => 'seks', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'Kommentarlogg',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'Viser kommentarer for et register',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'Ingen kommentarer tilgjengelig',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'Legg til',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'Legg til kommentar',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'Vis alle',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'Data ikke tilgjengelig. Du har ikke tillatelse til å få tilgang til disse modulene.' .
    " \nOppdater eller fjern denne dashleten.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'Min {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'Ingen register valgt for visning',
    'LBL_CONTENT_SEARCH_DASHLET' => 'Innholdssøk liten strek',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'Hva kan vi hjelpe deg med i dag, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'Vil du opprette en sak?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'Salgsmulighet Metrics',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'Mulighetsmetrikk for tilhørende konto.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'Hurtigvalg produktkatalog',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'Lister nylig brukte elementer og produkter som er lagret i Favoritter',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'Nylig brukt',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'Favoritter',

    'LBL_DASHBOARD_CREATE' => 'Opprett Dashboard',
    'LBL_DASHBOARD_DUPLICATE' => 'Dupliser Dashboard',
    'LBL_DASHBOARD_DELETE' => 'Slett instrumentpanel',
    'LBL_PIN_TO_TOP' => 'Fest til topp',
    'LBL_PIN_TO_BOTTOM' => 'Fest til bunn',
    'LBL_MANAGE_DASHBOARDS' => 'Administrere dashbord',

    'LBL_DASHBOARD_CONFIG' => 'Dashbordkonfigurasjon',
    'LBL_LIST_VIEW__NAME' => 'Listevisning',
    'LBL_PIPELINE_VIEW_NAME' => 'Flisvisning',
    'LBL_PIPELINE_VIEW_BTN' => 'Flisvisning',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} etter {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'Flisvisning er ikke aktivert',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'Ingen poster ble funnet på dette tidspunkt.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'Sakssammendrag',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'Tidslinje',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'Notater & vedlegg',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'Notater & vedlegg tilhører denne posten',
    'LBL_DASHLET_PIPLINE_NAME' => 'Pipeline',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'Siste Tweets - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'Ingen lagrede dashboards',

    'LBL_DNB_AND' => 'og',
    'LBL_DNB_PRIM_NAME_DESC' => 'Tekstregistrerer et navn på denne organisasjonen',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'Svar',
    'LBL_TWITTER_RETWEET' => 'Retweet',
    'LBL_TWITTER_FAVORITE' => 'Favoritt',
    'LBL_TWITTER_FOLLOW' => 'Følg',
    'LBL_TWITTER_DESCRIPTION' => 'Se matchende brukers twitter bio og tweets, retweets, og svar på tweets',
    'LBL_TWITTER_ID' => 'Twitter ID',
    'LBL_TWITTER_DISPLAY_ROWS' => 'Vis rader',
    'LBL_TWITTER_MY_ACCOUNT' => 'Min konto',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Kilde Tweet:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'Læringsressurser',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'Opplæring og sertifisering',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub Community',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'Dokumentasjon og støtte',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters markedsplass',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'Salg etter Land',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'Viser salgslistene etter landsoversikt.',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'Kunnskapsbasekategorier og publiserte artikler',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'Kunnskapsbasesøk',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'Viser en søkbar trevisning av publiserte kunnskapsbaseartikler og kategorier.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'Publiserte artikler på andre språk',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'Mest nyttige publiserte kunnskapsbaseartikler',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'Viser de mest likte og viste artiklene i kunnskapsbasen',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} filtrert av {{label}} «{{value}}»',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'Nyttighet for artikler',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'Legg til side',
    'LBL_LOADING_PAGE' => 'Laster side, vent litt...',
    'LBL_SEARCH_RESULTS' => 'Søkeresultater',
    'LBL_SEARCH_RESULTS_FOR' => 'Søketreff for: ',
    'LBL_SEARCH_HELP_TITLE' => 'Jobber med flervalg og lagrede søk',
    'LBL_SEARCH_RESULTS_FOUND' => 'Søkeresultater funnet',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'Mitt salgsforløp',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "Min gruppes salgforløp",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'Diagram for salgsforløp',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'Viser nåværende salgsforløpsdiagram.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'Intet bilde',

    'LBL_MODULE' => 'Modul',
    'LBL_RELATIONSHIP' => 'Relasjon',
    'LBL_SINGULAR_LABEL' => 'Enkelt-etikett',
    'LBL_PLURAL_LABEL' => 'Flertalls-etikett',
    'LBL_MODULE_DISPLAY' => 'Vis',
    'LBL_MODULE_DISPLAY_TYPE' => 'Vis type',
    'LBL_MODULE_ICON' => 'Ikon',
    'LBL_MODULE_COLOR' => 'Modul bakgrunnsfarge',
    'LBL_LANGUAGE_SELECTOR' => 'Språk',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'Modulinnstillinger',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'Modulinnstillingene er lagret.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Kopiér adresse fra venstre:',
    'LBL_SAVE_AND_CONTINUE' => 'Lagre og fortsett',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Multiselect controls</strong></p><ul><li>Click on the values to select an attribute.</li><li>Ctrl-click to select multiple. Mac users use CMD-click.</li><li>To select all values between two attributes,  click first value and then shift-click last value.</li></ul><p><strong>Advanced Search & Layout Options</strong><br><br>Using the <b>Saved Search & Layout</b> option, you can save a set of search parameters and/or a custom List View layout in order to quickly obtain the desired search results in the future. You can save an unlimited number of custom searches and layouts. All saved searches appear by name in the Saved Searches list, with the last loaded saved search appearing at the top of the list.<br><br>To customize the List View layout, use the Hide Columns and Display Columns boxes to select which fields to display in the search results. For example, you can view or hide details such as the record name, and assigned user, and assigned team in the search results. To add a column to List View, select the field from the Hide Columns list and use the left arrow to move it to the Display Columns list. To remove a column from List View, select it from the Display Columns list and use the right arrow to move it to the Hide Columns list.<br><br>If you save layout settings, you will be able to load them at any time to view the search results in the custom layout.<br><br>To save and update a search and/or layout:<ol><li>Enter a name for the search results in the <b>Save this search as</b> field and click <b>Save</b>.The name now displays in the Saved Searches list adjacent to the <b>Clear</b> button.</li><li>To view a saved search, select it from the Saved Searches list. The search results are displayed in the List View.</li><li>To update the properties of a saved search, select the saved search from the list, enter the new search criteria and/or layout options in the Advanced Search area, and click <b>Update</b> next to <b>Modify Current Search</b>.</li><li>To delete a saved search, select it in the Saved Searches list, click <b>Delete</b> next to <b>Modify Current Search</b>, and then click <b>OK</b> to confirm the deletion.</li></ol>',

    //resource management
    'ERR_QUERY_LIMIT' => 'Feil: Spørregrensen på $limit er nådd for modulen $module.',
    'ERROR_NOTIFY_OVERRIDE' => 'Feil: ResourceObserver->notify() needs to be overridden.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'Feil: Kan ikke opprette monitor fordi metadata- filen enten er tom, eller eksistere ikke.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'Feil: Det er ingen monitor konfigurert for ønsket navn',
    'ERR_UNDEFINED_METRIC' => 'Feil: Kan ikke sette verdi for udefinert måledata.',
    'ERR_STORE_FILE_MISSING' => 'Feil: Kan ikke finne gjennomføringsfilen for lagring.',

    'LBL_MONITOR_ID' => 'Skjerm-ID',
    'LBL_TEAM_ID' => 'Gruppeidentifikasjon:',
    'LBL_SELECT_MODULE' => 'Velg en modul:',
    'LBL_USER_ID' => 'Bruker Id',
    'LBL_MODULE_NAME' => 'Modul navn',
    'LBL_MODULE_ALL' => 'Alle',
    'LBL_ITEM_ID' => 'Objekt ID',
    'LBL_ITEM_SUMMARY' => 'Objekt oppsummering',
    'LBL_ACTION' => 'Handling',
    'LBL_SESSION_ID' => 'Session ID',
    'LBL_BREADCRUMBSTACK_CREATED' => 'BreadCrumbStack opprettet for bruker ID {0}',
    'LBL_VISIBLE' => 'Synlige oppøringer',
    'LBL_DATE_LAST_ACTION' => 'Dato for siste handling',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL tekst',
    'LBL_QUERY_HASH' => 'SQL Hash',
    'LBL_SEC_TOTAL' => 'Totalt antall sekunder',
    'LBL_SEC_AVG' => 'Gjennomsnittlig antall sekunder',
    'LBL_RUN_COUNT' => 'Antall spørsmål',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'Klientens IP Adresse',
    'LBL_DATE_START' => 'Start datoen',
    'LBL_ACTIVE' => 'Session Aktiv',
    'LBL_ROUNDTRIPS' => 'Antall handlinger',
    'LBL_SECONDS' => 'Sekunder Aktiv',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'Database tur-retur',
    'LBL_FILES_OPENED' => 'Filer hentet',
    'LBL_MEMORY_USAGE' => 'Minnebruk (bytes)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'Laster inn Twitter kobling ...',
    'LBL_TWITTER_DATA_EMPTY' => 'Ingen data tilgjengelig fra Twitter',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Sugar plug-in for Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Integrer Sugar e-post og kalenderinformasjon med Microsoft Outlook.',
    'LBL_PLUGIN_WORD_NAME' => 'Sugar plug-in for Word',
    'LBL_PLUGIN_WORD_DESC' => 'Automatisk utfylle informasjon fra SugarCRM i skjemabrev, DM og andre Microsoft-dokumenter.',
    'LBL_PLUGIN_EXCEL_NAME' => 'Sugar plug-in for Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'Integrer Sugar med regneark for bedre analyse av viktige beregninger.',
    'LBL_PLUGINS_TITLE' => 'Sugar plug-ins for Microsoft OfficeTM',
    'LBL_PLUGINS_DESC' => 'Les om plug-in funksjoner i <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">Plug-Ins dokumentasjon</a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'SugarCRM Plug-in for Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'SugarCRM Plug-in for Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'Integrer SugarCRM med Lotus Notes.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'Er ikke tidligere',
    'MSG_IS_MORE_THAN' => 'er mer enn',
    'MSG_IS_LESS_THAN' => 'er mindre enn',
    'MSG_SHOULD_BE' => 'skal være',
    'MSG_OR_GREATER' => 'eller større',
    'MSG_EXCEEDS_MAXLEN' => 'overskrider angitt maksimal lengde ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Velkommen til Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal er et rammeverk som gir en real- time visning av saker, feil & nyhetsbrev til kunder. Dette er et eksternt grensesnitt til Sugar som kan bli distribuert til enhver nettside. Følg med for mer customer self services features som prosjekter, Management og forums i våre fremtidige utgivelser.',
    'LBL_LIST' => 'Liste',
    'LBL_CREATE_CASE' => 'Opprett sak',
    'LBL_CREATE_BUG' => 'Opprett feil',
    'LBL_NO_RECORDS_FOUND' => '-0 registreringer funnet-',

    'DATA_TYPE_DUE' => 'Passende:',
    'DATA_TYPE_START' => 'start',
    'DATA_TYPE_SENT' => 'sendt',
    'DATA_TYPE_MODIFIED' => 'Endret:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Tell',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'Objektbilde',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'Velg dato',

    'LBL_VALIDATE_RANGE' => 'Er ikke innenfor gyldig område',
    'LBL_VALIDATE_URL' => 'er ikke en gyldig URL',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'Alle',

    'LBL_OPERATOR_IN_TEXT' => 'er en av følgende:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'er ikke en av følgende:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Feil: Array antall av "bean" parametre stemmer ikke overens med Array sum av resultatene.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Feil: Manglende stedsangivelse for modulen.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Feil: Kan ikke hente data for {0} tilknytting. Tjenesten kan nå være utilgjengelige eller konfigureringsinnstillingene kan være ugyldige. Feilmelding for tilknytting: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'Kan ikke hente data. Tjenesten kan for tiden være utilgjengelige eller konfigurasjonsinnstillingene kan være ugyldig.',
    'LBL_CONNECT_TWITTER' => 'Koble til Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'Kan ikke finne en gyldig tidslinje for Twitter ID:',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'Konfigurer Twitter kontakt',
    'LBL_CONNECT_TEST_FAIL' => 'Feil: Kontakt konfigurasjonsinnstillingene kan være ugyldig. Ta kontakt med administratoren.',
    'LBL_CONFIGURE_TWITTER' => 'Kontakt din administrator for å konfigurere Twitter',
    'LBL_MERGE_CONNECTORS' => 'Hent data',
    'LBL_NO_DATA_AVAILABLE' => 'Ingen data tilgjengelig.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'Er du sikker på at du vil deaktivere tilknyttingsintegrering for denne modulen?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Klarte ikke å koble til Elastic server',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'Beklager, du kan ikke slette det globale team. Avbryter',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'Dette private team [{0}] ikke kan slettes før brukeren [{1}] er slettet.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'Du må enten ha Abobe Flash slått av eller bruke en eldre versjon av Adobe Flash Player. For å få den nyeste versjon av Flash Player,<a href="http://www.adobe.com/go/getflashplayer/">klikk her</a>.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'Navn',
    'LBL_COLLECTION_PRIMARY' => 'Primær',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'Tomme obligatorisk felt',
    'LBL_COLLECTION_EXACT' => 'Eksakt',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'For den optimale bruken av IIS/FastCGI sapi, angi fastcgi.logging til 0 i php.ini-filen.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'Tildelt',
    'LBL_DESCRIPTION' => 'Beskrivelse',
    'LBL_PRIMARY_CONTACT_NAME' => 'Primærkontakt',
    'LBL_PRIMARY_CONTACT_ID' => 'Primærkontakt-ID',

    'LBL_NONE' => '-ingen-',
    'LBL_YESTERDAY' => 'i går',
    'LBL_TODAY' => 'i dag',
    'LBL_TOMORROW' => 'i morgen',
    'LBL_NEXT_WEEK' => 'neste uke',
    'LBL_NEXT_MONDAY' => 'neste mandag',
    'LBL_NEXT_FRIDAY' => 'neste fredag',
    'LBL_TWO_WEEKS' => 'to uker',
    'LBL_NEXT_MONTH' => 'neste måned',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'første dag i neste måned',
    'LBL_THREE_MONTHS' => 'tre måneder',
    'LBL_SIXMONTHS' => 'seks måneder',
    'LBL_NEXT_YEAR' => 'Neste år',
    'LBL_FILTERED' => 'Filtrert',

    //Datetimecombo fields
    'LBL_HOURS' => 'Timer',
    'LBL_MINUTES' => 'Minutter',
    'LBL_MERIDIEM' => 'Meridiem',
    'LBL_DATE' => 'Dato',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Auto-refresh',

    'LBL_DURATION_DAY' => 'dag',
    'LBL_DURATION_HOUR' => 'time',
    'LBL_DURATION_MINUTE' => 'minutt',
    'LBL_DURATION_DAYS' => 'dager',
    'LBL_DURATION_HOURS' => 'timer',
    'LBL_DURATION_MINUTES' => 'minutter',
    'LBL_DURATION_SECONDS' => 'sekunder',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'Velg måned',
    'LBL_ENTER_YEAR' => 'Skriv År',
    'LBL_ENTER_VALID_YEAR' => 'Skriv inn et gyldig år',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'Vennligst skriv inn en numerisk amerikansk telefonnummer, inkludert retningsnummer.',
    'LBL_CCP_NOT_INITIATED' => 'Forsøkte å ringe med CCP mens agent ikke har logget på.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'Kan ikke initiere anrop via CCP.',
    'LBL_CCP_DIALING_ERROR' => 'Denne anropet kan ikke fullføres som ringt.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'Lukk alle chat-økter i SugarLive før du foretar et utgående samtale.',

    //File write error label
    'ERR_FILE_WRITE' => 'Feil: Kunne ikke skrive filen {0}. Vennligst sjekk system-og web server tillatelser.',
    'ERR_FILE_NOT_FOUND' => 'Feil: Kunne ikke laste opp filen {0}. Vennligst sjekk system-og web server tillatelser.',

    'LBL_AND' => 'Og',
    'LBL_BEFORE' => 'Før',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'Last opp fra datamaskinen',
    'LBL_SEARCH_EXTERNAL_API' => 'Fil på ekstern kilde',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'Last opp til ekstern kilde',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'Link fra ekstern kilde',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'Sikkerhet',
    'LBL_SHARE_PRIVATE' => 'Privat',
    'LBL_SHARE_COMPANY' => 'Firma',
    'LBL_SHARE_LINKABLE' => 'Kobles sammen',
    'LBL_SHARE_PUBLIC' => 'Offentlig',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS-strøm',
    'LBL_RSS_RECORDS_FOUND' => 'post(er) funnet',
    'ERR_RSS_INVALID_INPUT' => 'RSS er ikke en gyldig input_type',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS er ikke en gyldig response_type for denne metoden',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs støtter ikke filformatet du oppga.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'Tom',
    'LBL_IS_EMPTY' => 'Er tom',
    'LBL_IS_NOT_EMPTY' => 'Er ikke tom',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '"Dette er et eksempel på en importfil som gir et eksempel på det forventede innholdet i en fil som er klar for import." "Filen er en kommaseparert .csv-fil, med doble anførselstegn som feltindetifikatorer." "Overskriftsraden er den øverste raden i filen, og inneholder feltetikettene slik du vil se dem i programmet." "Disse etikettene brukes for å koble dataene i filen til feltene i applikasjonen." "Merk: Databasenavnene kan også brukes i overskriftsraden. Dette er nyttig når du bruker phpMyAdmin eller et annet databaseverktøy for å gi en eksportert liste over data som skal importeres." "Kolonnerekkefølgen er ikke viktig da importprosessen kobler dataene til de aktuelle feltene basert på overskriftsraden." "For å bruke denne filen som en mal, gjør du følgende:" "1. ​​Fjern eksempelradene med data" "2. Fjern hjelpeteksten som du leser akkurat nå" "3. Putt inn dine egne data i de aktuelle radene og kolonnene" " 4. Lagre filen på et kjent sted på systemet" "5. Klikk på Import i handlingsmenyen i programmet og velg filen som skal lastes opp"',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'Tildelt Bruker-ID',
    'LBL_EXPORT_CREATED_BY' => 'Opprettet Av ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'Endret av ID',
    'LBL_EXPORT_REPORTS_TO_ID' => 'Rapporterer til ID',
    'LBL_EXPORT_TEAM_ID' => 'Gruppe-ID',
    'LBL_EXPORT_TEAM_SET_ID' => 'Team sett ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Tildelt Bruker',
    'LBL_EXPORT_FULL_NAME' => 'Fullt Navn',
    'LBL_EXPORT_TEAM_NAME' => 'Grupper',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navigerer...',

    'LBL_PENDING_NOTIFICATIONS' => 'Varsler',
    'LBL_ALT_ADD_TEAM_ROW' => 'Legg til ny team-rad',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'Fjern team',
    'LBL_ALT_SPOT_SEARCH' => 'Punktsøk',
    'LBL_ALT_NOT_SORTED' => 'Ikke sortert',
    'LBL_ALT_SORT_DESC' => 'Sortert Synkende',
    'LBL_ALT_SORT_ASC' => 'Sortert Stigende',
    'LBL_ALT_SORTABLE' => 'Sorterbar',
    'LBL_ALT_NOT_SORTABLE' => 'Kan ikke sorteres',
    'LBL_ALT_SORT' => 'Sortér',
    'LBL_ALT_SHOW_OPTIONS' => 'Vis Valg',
    'LBL_ALT_HIDE_OPTIONS' => 'Skjul Valg',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'Flytt det valgte element til listen til venstre',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Flytt det valgte element til listen til høyre',
    'LBL_ALT_MOVE_COLUMN_UP' => 'Flytt det valgte element oppover i listen',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'Flytt det valgte element nedover i listen',
    'LBL_ALT_INFO' => 'Informasjon',
    'MSG_DUPLICATE' => 'Den {0} oppføring du er i ferd med å skape kan være et duplikat av en {0} oppføring som allerede eksisterer. {1} poster som inneholder lignende navn er oppført nedenfor.<br />Klikk Opprett {1} for å fortsette å lage denne nye {0}, eller velge en eksisterende {0} listet nedenfor.',
    'MSG_SHOW_DUPLICATES' => 'Den {0} oppføring du er i ferd med å skape kan være et duplikat av en {0} oppføring som allerede eksisterer. {1} oppføringer som inneholder lignende navn er oppført nedenfor. Klikk Lagre for å fortsette å lage denne nye {0}, eller klikk Avbryt for å gå tilbake til modulen uten å skape den {0}.',
    'LBL_EMAIL_TITLE' => 'Epost-adresse',
    'LBL_EMAIL_OPT_TITLE' => 'Bortvalgt epostadresse',
    'LBL_EMAIL_INV_TITLE' => 'Ugyldig epostadresse',
    'LBL_EMAIL_PRIM_TITLE' => 'Primær epostadresse',
    'LBL_SELECT_ALL_TITLE' => 'Velg alle',
    'LBL_SELECT_THIS_ROW_TITLE' => 'Velg denne rad',
    'LBL_TEAM_SELECTED_TITLE' => 'Valgt Team',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Velg for å gjøre dette team det primære',
    'LBL_TEAM_TBSELECTED_TITLE' => 'Gruppe merket som gruppebasert valgt ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'Merk dette teamet som gruppebasert valgt',
    'LBL_SEARCH_AND_SELECT' => 'Søk og Velg {{module}}',
    'TPL_SEARCH_AND_ADD' => 'Søk etter og legg til {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'FEIL: Det oppstod en feil under opplastingen. Feilkode: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'FEIL: Det oppstod en feil under opplastingen. Feilkode: {0} - {1}. upload_maxsize er {2}',
    'UPLOAD_ERROR_HOME_TEXT' => 'FEIL: Det oppstod en feil under opplastingen, vennligst be om assistanse fra en administrator.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'Størrelsen på opplastingen ({0} bytes) er større en maks tillatt størrelse: {1} bytes',
    'UPLOAD_REQUEST_ERROR' => 'Det har oppstått en feil. Vennligst oppdater siden og prøv igjen.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'E',
    'LBL_EDIT_BUTTON_LABEL' => 'Rediger',
    'LBL_ADD_BUTTON_LABEL' => 'Legg til',
    'LBL_EDIT_BUTTON_TITLE' => 'Rediger',
    'LBL_REFRESH_BUTTON_LABEL' => 'Oppdater',
    'LBL_REFRESH_BUTTON_TITLE' => 'Oppdater',
    'LBL_DUPLICATE_BUTTON_KEY' => 'U',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Dublett',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Dublett [Alt+U]',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'Rapportplaner',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'Rapportplaner',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'Rapportdetaljer',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'Rapportdetaljer',
    'LBL_DELETE_BUTTON_KEY' => 'D',
    'LBL_DELETE_BUTTON_LABEL' => 'Slett',
    'LBL_DELETE_BUTTON_TITLE' => 'Slett [Alt+D]',
    'LBL_SAVE_BUTTON_KEY' => 'S',
    'LBL_SAVE_BUTTON_LABEL' => 'Lagre',
    'LBL_SAVE_BUTTON_TITLE' => 'Lagre [Alt+S]',
    'LBL_CANCEL_BUTTON_KEY' => 'X',
    'LBL_CANCEL_BUTTON_LABEL' => 'Avbryt',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'å stoppe.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'å bli på siden.',
    'LBL_CANCEL_BUTTON_TITLE' => 'Avbryt [Alt+X]',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'Del',
    'LBL_SHARE_BUTTON_TITLE' => 'Del',
    'LBL_START_BUTTON_LABEL' => 'Start',
    'LBL_START_BUTTON_TITLE' => 'Start',
    'LBL_FINISH_BUTTON_LABEL' => 'Ferdig',
    'LBL_FINISH_BUTTON_TITLE' => 'Ferdig',
    'LBL_CONFIRM_BUTTON_LABEL' => 'Bekreft',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'for å fortsette.',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'for å forlate siden og forkaste endringer.',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Tastatur-snarveier',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Form Functionality - Alt+</strong><br/> I = ed<b>I</b>t (detailview)<br/> U = d<b>U</b>plicate (detailview)<br/> D = <b>D</b>elete (detailview)<br/> A = s<b>A</b>ve (editview)<br/> L = cance<b>L</b> (editview) <br/><br/></p><p><strong>Search and Navigation  - Alt+</strong><br/> 7 = first input on Edit form<br/> 8 = Advanced Search link<br/> 9 = First Search Form input<br/> 0 = Unified search input<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'Trapp opp',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'Del',
    'TPL_RECORD_SHARE_SUBJECT' => 'Delt {{module}} {{name}} fra {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'Vennligst kontroller {{module}} {{name}} fra {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'connector array i {0} har blitt definert feil eller er tom og kunne ikke benyttes.',
    'LBL_PDF_VIEW' => 'Last ned PDF',
    'LBL_PDF_EMAIL' => 'Send PDF via epost',

    'ERR_SUHOSIN' => 'Opplastingsstrømmen er blokkert av Suhosin, vennligst legg til "upload" til suhosin.executor.include.whitelist (Se sugarcrm.log for mer informasjon)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'akkurat nå',
    'LBL_TIME_AGO_SECONDS' => 'under et minutt siden',
    'LBL_TIME_AGO_MINUTE' => 'omtrent 1 minutt siden',
    'LBL_TIME_AGO_MINUTES' => '{{this}} minutter siden',
    'LBL_TIME_AGO_HOUR' => 'omtrent en time siden',
    'LBL_TIME_AGO_HOURS' => '{{this}} timer siden',
    'LBL_TIME_AGO_DAY' => 'i går',
    'LBL_TIME_AGO_DAYS' => '{{this}} dager siden',
    'LBL_TIME_AGO_YEAR' => 'over et år siden',
    'LBL_TIME_UNTIL_SECONDS' => 'Om mindre enn ett minutt.',
    'LBL_TIME_UNTIL_MINUTE' => 'Om ca. ett minutt.',
    'LBL_TIME_UNTIL_MINUTES' => 'i {{this}} minutt',
    'LBL_TIME_UNTIL_HOUR' => 'Om ca. en time',
    'LBL_TIME_UNTIL_HOURS' => 'i {{this}} time',
    'LBL_TIME_UNTIL_DAY' => 'i morgen',
    'LBL_TIME_UNTIL_DAYS' => 'i {{this}} dager',
    'LBL_TIME_UNTIL_YEAR' => 'om over ett år',
    'LBL_TIME_RELATIVE' => 'Postet {{relativetime}} på {{date}} klokken {{time}}',
    'LBL_LAST_TOUCHED' => 'Sist berørt {{relativetime}} på {{date}} på {{time}}',
    'LBL_LAST_COMMIT' => 'Siste forpliktelse: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'Ingen poster ble funnet denne gang.',
    'LBL_DETAILVIEW_NO_RECORDS' => 'Denne posten kunne ikke gjengis på dette tidspunktet.',
    'LBL_REFINE_LIST' => 'Avgrens listen',
    'LBL_SEARCH_BY' => 'Søk etter',
    'LBL_PREVIEW' => 'Forhåndsvisning',
    'LBL_COLUMNS' => 'Kolonner',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'Forhåndsvisning deaktivert: Ingen data tilgjengelig',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'Forhåndsvisning deaktivert: Ingen tilgang til posten',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'Forhåndsvisning deaktivert: Ingen data tilgjengelig',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'Forhåndsvisning deaktivert: I visning som gjeldende post',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'Forhåndsvisning deaktivert: Post fjernet eller ingen tilgang til posten',
    'LBL_PREVIEW_PREVIOUS' => 'Forhåndsvis forrige',
    'LBL_PREVIEW_NEXT' => 'Forhåndsvis neste',
    'LBL_PREVIEW_CLOSE' => 'Lukk forhåndsvisning',
    'LBL_STREAM_NO_RECORDS' => 'Denne posten har ingen merknader på dette tidspunktet. Vennligst legge til et notat ved å klikke på Legg til notat-linken.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} duplikater funnet.',
    'LBL_NO_DUPLICATES_FOUND' => 'Ingen duplikater funnet.',
    'LBL_RESET_DEFAULT_VIEW' => 'Tilbakestill standardvisning',
    'LBL_RESET_DEFAULT_WIDTHS' => 'Tilbakestill standardbredder',
    'LBL_TIMEZONE_UPDATED' => 'Sugar har oppdatert tidssonen for brukerprofilen din slik at den samsvarer med nettleserens tidssone',
    'LBL_SUCCESS' => 'Vellykket',
    'LBL_ERROR' => 'Feil',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'Slå sammen dubletter',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'Ønsker du å fortsette? Kansellere for å avbryte. Bekreft for å slette poster.',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'Denne handlingen vil slette følgende posten(er):',
    'LBL_MERGE' => 'Slå sammen',
    'TPL_MERGING_RECORDS' => 'Slå sammen {{mergeCount}} poster',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'Ugyldig antall poster passert. Gyldige verdier er fra {{minRecords}} til {{maxRecords}} poster.',
    'LBL_MERGE_NO_ACCESS' =>
        'Du har ikke tilgang til å utføre denne handlingen. Minst én post må være redigerbar.',
    'LBL_MERGE_LOCKED' => 'Noen av postene merket for fletting inneholder felt som er låst for redigering av en prosess, og kan ikke flettes sammen på dette tidspunktet.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'Alle endringer vil bli forkastet når du bytter til en ny primærpost. Er du sikker på at du vil bytte?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'Slå sammen relaterte poster',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'Slått sammen: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'Fletting av relaterte {{objectName}} feilet. Starte nytt forsøk ({{num}} av {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'Fletting av relaterte {{objectName}} feilet.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'Fletting av relaterte poster ufullstendig. Noen poster forbli uflettet.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'Noen relaterte poster flettet ikke ordentlig. Kanseller for å avbryte. Bekreft for å fortsette flettingen.',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'Alle relaterte poster vil bli flyttet til Primær posten.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'Er du sikker på at du vil fjerne denne posten fra flettingen?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'Fjern posten fra flettingen',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'Ugyldig antall poster ble godkjent. Gyldig område er fra 1 til {{maxRecords}} poster.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'Brukernavnet og/eller passordet er galt, vennligst forsøk igjen.',
    'LBL_INVALID_CREDS_TITLE' => 'Ugyldige påloggingsopplysninger',
    'LBL_INVALID_GRANT' => 'Din påloggingskapsel har utløpt eller er ugyldig. Vennligst logg inn på nytt.',
    'LBL_INVALID_GRANT_TITLE' => 'Påloggingskapselen har utløpt',
    'LBL_AUTH_FAILED' => 'Klient-autentisering feilet.',
    'LBL_AUTH_FAILED_TITLE' => 'Ugyldig klient',
    'LBL_INVALID_REQUEST' => 'Forespørselen er ugyldig eller feil. Vennligst ta kontakt med teknisk support.',
    'LBL_INVALID_REQUEST_TITLE' => 'Ugyldig forespøsel',
    'LBL_REQUEST_TIMEOUT' => 'Serveren svarer ikke. Kontroller Internett-tilkoblingen din.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'Tidsavbrudd for forespørsel: ',
    'LBL_UNAUTHORIZED' => 'Beklager, men det ser som at du er uautorisert for tilgang til denne ressurs.',
    'LBL_UNAUTHORIZED_TITLE' => 'Uautorisert',
    'LBL_RESOURCE_UNAVAILABLE' => 'Ressurs ikke tilgjengelig.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'Forbudt',
    'LBL_METHOD_NOT_ALLOWED' => 'HTTP-metoden er ikke tillatt for denne ressurs. Vennligst ta kontakt med teknisk support.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'Metoden ikke tillatt',
    'LBL_PRECONDITION_MISSING' => 'Forespørselssvikt, eller mangler/feil parameter. Vennligst ta kontakt med teknisk support',
    'LBL_PRECONDITION_MISSING_TITLE' => 'Feil:',
    'LBL_INVALID_412_RESPONSE' => 'En forespørsel mislykkes som gjør programmet ubrukelig. Ta kontakt med teknisk support.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'Ikke tillatt å endre felt {0} i modul: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'Ikke tillatt å utføre handling "{0}" på denne posten',
    'LBL_LOGIN_BUTTON_LABEL' => 'Logg inn',
    'LBL_ACTIVITY_VIEW_TOUR' => 'Aktivitets Visnings Tour',
    'LNK_TOUR' => 'Omvisning',
    'LNK_MOBILE' => 'Mobil',
    'LBL_FEEDBACK' => 'Tilbakemelding',
    'LBL_SUPPORT' => 'Support',
    'LBL_LANGUAGE' => 'Språk',
    'LBL_LOADING_LANGUAGE' => 'Laster språkpakke',
    'LBL_UPLOADING' => 'Laster opp',
    'LBL_UPLOADING_DOTS' => 'Laster opp ...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'Er du sikker på at du vil slette dette bilde?',
    'LBL_FILE_DELETE_CONFIRM' => 'Er du sikker på at du vil slette denne filen? Dette kan ikke gjøres om.',
    'LBL_FILE_DELETED' => 'Filen ble slettet',

    //theme roller
    'LBL_PORTAL_THEME' => 'Tema for Portal',
    'LBL_THEME_PREVIEW' => 'Forhåndsvisning av portaltema',
    'LBL_LOADING_PREVIEW' => 'Laster forhåndsvisning',
    'LBL_RESET' => 'Tilbakestill',
    'LBL_COLORS' => 'Farger',
    'BorderColor' => 'Kant farger',
    'NavigationBar' => 'Navigasjonssøyle',
    'PrimaryButton' => 'Primær knapp',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'Lagre & Distribuer',
    'LBL_RESET_THEME_LNK' => 'Gjenopprett standard tema',
    'LBL_RESET_THEME_MODAL_INFO' => 'Er du sikker på at du vil forkaste tema tilpasninger og erstatte med standard tema?',
    'LBL_RESET_THEME_PROCESS' => 'Gjenopprette standardtema ...',
    'LBL_SAVE_THEME_PROCESS' => 'Lagrer tema ...',

    // image loader
    'LBL_SELECT_PHOTO' => 'Velg et bilde',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Forbedret prognoser funksjonalitet i Sugar',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => 'Sett opp dine prognoseparametere <br /><br />Enkel sporig av anslått salg og pipeline <br /><br />Prognose basert på salgsprognosen fra ditt salgsteam',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'Sett opp dine prognoseparametere',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => 'Velg regnskapsår startdato<br /><br />Sett opp tidsperioder for å være enten årlig eller kvartalsvis<br /><br />Bestem hvor mange fortid og fremtid tidsperioder som må være synlig i regnearket<br /><br />Velg prognose variabler for å tagge Salgsmuligheter som Inkluder, Ekskluder eller Upside<br /><br />Velg prognose scenarier for å identifisere Sannsynlig, Best og Verst',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'Behandle salgsteamets salgsprognose',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => 'Velg tidsperiode for å gjennomgå prognosen<br /><br />Se gjennom ditt salgsteam medlemmers regneark og gi justerte prognoser<br /><br />Se varsel på regnearket når et salgsteam medlem forplikter til en ny prognose<br /><br />Lagre prognose regnearket som et utkast eller forplikt prognosen til din leder<br /><br />Vis historie av tidligere forpliktelser',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'Behandle salgsteamets salgsprognose',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => 'Se Pareto diagrammet for pipelineanalyse på tvers av alle salgsteammedlemmenes prognoser<br /><br />Velg å visualisere salgsprognosen etter Sannsynlig, Best eller Verst<br /><br />Vis anslått salg og hvor nær du er til å oppnå ditt teams budsjett',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'Administrer dine egne salgsprognoser',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Velg tidsperioden for din prognose</li><li class="icon-ok">Gjennomgå og in-line redigere beløp og Vinn Sannsynlighet for en rask hva-hvis-analyse</li><li class="icon-ok">Lagre prognose regnearket som et utkast eller forplikt prognosen til din leder</li><li class="icon-ok">Vis historie av tidligere forpliktelser</li><li class="icon-ok">Forplikt prognosen til leder og se historie av tidligere forpliktelser</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'Administrer dine egne salgsprognoser',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Vis Pareto diagram for pipeline analyse over tid for dine muligheter</li><li class="icon-ok">Velg å visualisere pipeline fordeling etter salgsfase eller Vinn Sannsynlighet</li><li class="icon-ok">Vis anslått salg og hvor nær du er å oppnå ditt tildelte budsjett</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Hva er nytt i Sugar',
    'LBL_TOUR_WATCH' => 'Se hva som er nytt i Sugar',
    'LBL_TOUR_FEATURES_670' => 'Forbedret utseende og følelse - nå med et nytt moderne tema. Forbedret Prognoser modul - nå med intuitive brukergrensesnitt og ny datavisualisering',
    'LBL_TOUR_VISIT' => 'For mer informasjon vennligst besøk vår applikasjon',
    'LBL_TOUR_DONE' => 'Du er ferdig!',
    'LBL_TOUR_REFERENCE_1' => 'Du kan alltid referere vår',
    'LBL_TOUR_REFERENCE_2' => 'gjennom "Support" linken under profilmenyen.',
    'LNK_TOUR_DOCUMENTATION' => 'dokumentasjon',
    'LBL_TOUR_CALENDAR_URL_1' => 'Deler du SugarCRM kalender med tredje parts programmer, for eksempel Microsoft Outlook eller Exchange? Hvis så, har du en ny nettadresse. Denne nye, sikrere URL inkluderer en personlig nøkkel som vil hindre uautorisert publisering av kalenderen.',
    'LBL_TOUR_CALENDAR_URL_2' => 'Hent din nye felles kalenders URL.',
    'LBL_TOUR_CUBE' => 'Åpne kontrollpaneler og aktivitetsstrøm',
    'LBL_TOUR_NAV_BAR' => 'Åpne modulene I navigasjonsmenyen og utfør handlinger',
    'LBL_TOUR_NOTIFICATIONS' => 'Klikk for å se varslinger',
    'LBL_TOUR_SEARCH' => 'Velg en eller flere moduler og søk',
    'LBL_TOUR_AVATAR' => 'Få mer informasjon om programmet eller Logg ut',
    'LBL_TOUR_ADD' => 'Lag en post herfra',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'Klikk for å lukke eller åpne intelligence ruten',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'Velg å se aktiviteter eller liste over poster',
    'LBL_TOUR_LIST_FILTER1' => 'Filter bar muliggjør søk for denne modulen',
    'LBL_TOUR_LIST_FILTER2' => 'Velg forhåndsdefinert filter eller opprette ny',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'Skriv inn her for å søke basert på navn',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'Velg å redigere raden eller forhåndsvise detaljer',
    'LBL_TOUR_RECORD_ACTIONS' => 'Utfør handlinger på den posten',
    'LBL_TOUR_RECORD_SUBPANEL' => 'Klikk på overskriften for å utvide og å skjule underpanelet',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'Postens navn kan bli oppdatert på plass',
    'LBL_TOUR_RECORD_STATUS' => 'Finn postens nivåstatus her',
    'LBL_TOUR_RECORD_SHOWMORE' => 'Klikk for å se flere data på posten',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'Velg å se aktiviteter eller relaterte poster',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'Klikk for å redigere hvert felt inline',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'Opprett nye grupper av Dashlets',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'Tilordne et navn til gruppen av Dashlets',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'Velg å fjerne Dashlet eller endre innstillinger',
    'LBL_TOUR_INTRO' =>'<h4>Velkommen til Sugar</h4> Vi ønsker å gå gjennom noen av funksjonene.  Bruk piltastene < og > nederst på skjermen for å få en omvisning.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">Hva er nytt</a><p class="details">Les om de viktigste endringen mellom utgivelser.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Lær mer om Sugar</a><p class="details">Et omfattende bibliotek med e-opplæring, live og virtuelle klasserom, webinarer og videoopplæring.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">Få støtte</a><p class="details">Trenger du hjelp, har et problem eller ønsker å foreslå hvordan vi kan gjøre Sugar bedre?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'Se en liste over poster og utfør handlinger på poster.',
    'LBL_TOUR_RECORD_INTRO' => 'Se detaljer på denne posten og se alle data relatert til det.',
    'LBL_TOUR_FORECAST_INTRO' => 'Administrer pipeline og prognose.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'Velg en tidsperiode for å se den tilsvarende prognosen',
    'LBL_TOUR_FORECASTS_COMMITS' => 'Klikk for å se tidligere forpliktelser',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'Klikk for å redigere data inline',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'Gjennomgå avstand til budsjett',
    'LBL_TOUR_FORECASTS_CHART' => 'Gjennomgå prognose distribusjon',
    'LBL_TOUR_TOUR' => 'Tilgang til Tour når som helst',
    'LBL_TOUR_TAGS_ADD' => 'Klikk på tagfeltet for å legge til og fjerne tags',
    'LBL_TOUR_TAGS_DELETE' => 'For å slette en tag, bruk backspace eller klikk på [X]-knappen på hver tag',
    'LBL_TOUR_RECORD_SAVE' => 'Når du er klar, klikk på Lagre',


    'LBL_FUTURE' => 'Fremtid',
    'LBL_REQUIRED_FIELD' => 'Obligatorisk',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'Tilbudsført linjeelement',
    'LBL_DISCOUNT_TOTAL' => 'Total rabatt',
    'LBL_DISCOUNT_PERCENT' => '% prosent',
    'LBL_DISCOUNT_SELECT' => 'Bestemmer om rabatten er en prosentdel eller flatt beløp',
    'LBL_TAX' => 'Skatt',
    'LBL_SHIPPING' => 'Frakt',
    'LBL_GRAND_TOTAL' => 'Totalsum',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'Fyll automatisk ut betalingsadresse fra kontoprofil',
    'LBL_QLI_ADD_GROUP' => 'Legg til en gruppe',
    'LBL_QLI_COMMENT' => 'Kommentar',
    'LBL_SELECT_ACTION' => 'Velg handling',
    'LBL_QLI_GROUP_NAME' => 'Gruppenavn',
    'LBL_GROUP_TOTAL' => 'Gruppetotal',
    'LBL_ITEM_NAME' => 'Linjeelement',
    'LBL_QLI_DELETE' => 'Er du sikker på at du vil slette dette linjeelementet?',
    'LBL_QLI_COMMENT_DELETE' => 'Er du sikker på at du vil slette denne linjeelementkommentaren?',
    'LBL_QLI_GROUP_DELETE' => 'Vil du virkelig slette gruppen {0}? Alle elementer flyttes til standardgruppen.',
    'LBL_QLI_GROUP_EMPTY' => 'Intet tilbudt linjeelement',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'Valgfri',
    'LBL_RELATED_MODULE' => 'Relatert {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'Relatert {{{this}}}',
    'LBL_CREATE_MODULE' => 'Opprett {{{this}}}',
    'LBL_EDIT' => 'Rediger {{{this}}}',
    'LBL_ASSOC' => 'Koble {{{this}}}',
    'LBL_ASSIGN' => 'Velg {{{this}}}',
    'LBL_EDIT_RELATED' => 'Rediger relatert {{{this}}}',
    'LBL_CREATE_RELATED' => 'Opprett relatert {{{this}}}',
    'LBL_ASSOC_EXISTING' => 'Koble eksisterende {{{this}}}',
    'LBL_SEARCH_ALL' => 'Søk alle {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'Søk alle poster...',
    'LBL_SEARCH_ALL_MODULES' => 'Søk alle',
    'LBL_OK' => 'OK',
    'LBL_YES' => 'Ja',
    'LBL_NO' => 'Nei',
    'LBL_SHOW_NUMBERING' => 'Vis fasenummerering',
    'LBL_HIDE_NUMBERING' => 'Skjul fasenummerering',
    'LBL_CALL_BUTTON' => 'Samtale',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'E-postadresse',
    'LBL_HONEYPOT' => 'Hvis du er en ekte person, fyller du ikke ut dette.',
    'LBL_LINK_BUTTON' => 'Lenke',
    'LBL_UNLINK_BUTTON' => 'Fjern',
    'LBL_MAP_BUTTON' => 'Kart',
    'LBL_FILE_BUTTON' => 'Fil',
    'LBL_URL_BUTTON' => 'Web',
    'LBL_WARNING' => 'Advarsel',
    'LBL_CONFIRM' => 'Bekreft',
    'LBL_CONFIRMATION_POPUP' => 'Popup-bekreftelse',
    'LBL_NO_ACCESS' => '(Ingen adgang)',
    'LBL_NO_ACCESS_LOWER' => 'Ingen adgang',
    'LBL_NO_FIELD_ACCESS' => 'Ingen tilgang',
    'LBL_NO_LICENSE_ACCESS' => 'Lisens kreves',
    'LBL_VALUE_ERASED' => 'Verdi slettet',
    'LBL_VALUE_ERASED_TOOLTIP' => 'Denne informasjonen ble slettet via forespørsel om personvern',
    'LBL_CREATE_RELATED_RECORD' => 'Opprett relatert post',
    'LBL_ASSOC_RELATED_RECORD' => 'Koble eksisterende post',
    'LBL_CHOOSE_LINK' => 'Velg koblingstype',
    'LBL_CHOOSE_PARENT_TYPE' => 'Velg hovedtype',
    'LBL_HOME' => 'Hjem',
    'ERR_NO_DOCS' => 'Ingen dokumenter tilgjengelig',
    'ERR_NO_RECORDS_SELECTED' => 'Du har ikke valgt noen poster.',
    'LBL_DELETING' => 'Sletter...',
    'LBL_UNLINKING' => 'Fjerner...',
    'LBL_UNLINKED' => 'Fjernet',
    'LBL_LEGAL' => 'Juridisk',
    'LBL_UPCOMING' => 'Mine kommende hendelser',
    'LBL_RECENTLY_UPDATED' => 'Nylig oppdatert',
    'LBL_NOTES_SUBPANEL_TITLE' => 'Notater',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'Møter',
    'LBL_TASKS_SUBPANEL_TITLE' => 'Oppgaver',
    'LBL_CALLS_SUBPANEL_TITLE' => 'Samtaler',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'Kontoer',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'Kontaker',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'E-poster',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'Skift',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'Produkter',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'Skiftunntak',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'Dokumenter',
    'LBL_ESCALATIONS' => 'Opptrappinger',
    'LBL_ESCALATED' => 'Trappet opp',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'Opptrappinger',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'Andre relaterte opptrappinger',
    'LBL_ESCALATIONS' => 'Opptrappinger',
    'LNK_SETTINGS' => 'Innstillinger',
    'LBL_MOBILE_SUPPORT' => 'Support',
    'LBL_MOBILE_SHOW_MORE' => 'Vis mer...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'Vis mer...',
    'LBL_MOBILE_NO_RECORDS' => 'Ingen poster funnet',
    'LBL_MOBILE_SEARCH_TEAMS' => 'Søk i team...',
    'LBL_MOBILE_SELECT_TEAMS' => 'Velg team',
    'LBL_MOBILE_WAIT' => 'Vennligst vent...',
    'LBL_MOBILE_LOGING_OUT' => 'Vennligst vent på utlogging...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'Logg inn på nytt',
    'LBL_MOBILE_META_SYNC_FAILED' => 'Kan ikke synkronisere med serveren.',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'Kan ikke synkronisere med serveren. Prøv på nytt?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'Personvern, vilkår og betingelser',
    'LBL_MOBILE_APP_VERSION' => 'App versjon',
    'LBL_MOBILE_SERVER_VERSION' => 'Server versjon',
    'LBL_MOBILE_SERVER_URL' => 'Server-URL',
    'LBL_MOBILE_PTR_PULL' => 'Trekk ned for å oppdatere ...',
    'LBL_MOBILE_PTR_RELEASE' => 'Slipp for å oppdatere...',
    'LBL_MOBILE_EDIT_REL' => 'Rediger relasjon',
    'LBL_MOBILE_DESKTOP' => 'Desktop versjon',
    'LBL_MOBILE_DELETE_CONFIRM' => 'Er du sikker på at du vil slette denne posten?',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'Er du sikker på at du vil koble fra denne posten?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'Hvordan vil du loggføre din seneste samtale?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'Velg mottaker',
    'LBL_MOBILE_CHOOSE_PHONE' => 'Velg telefonnummer',
    'LBL_MOBILE_CHOOSE_URL' => 'Velg URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'Velg dokument',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'Velg beliggenhet',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'Ingen handlinger tilgjengelig',
    'LBL_MOBILE_FEEDBACK' => 'Tilbakemelding',
    'LBL_MOBILE_DOC' => 'Dokument',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'Nedlasting startet: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'Nedlasting fullført: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'Laster opp fil....',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'Fil lastet opp',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'Forbereder bilde...',
    'LBL_CLOSE_SAVE_BUTTON' => 'Lukk oppgave og lagre',
    'LBL_LATER' => 'Senere',
    'LBL_USE_HTTPS' => 'Bruk sikker tilkobling',
    'LBL_LOADING_FILES' => 'Laster fortsatt dokumentlisten. Vennligst prøv igjen senere',
    'LBL_NEW_WEB_VERSION' => 'En ny versjon av dette programmet er tilgjengelig. Har du lyst til å oppdatere?',
    'LBL_SET_FONTSIZE' => 'Font størrelse',
    'LBL_FONTSIZE_TINY' => 'Veldig liten',
    'LBL_FONTSIZE_SMALL' => 'Liten',
    'LBL_FONTSIZE_NORMAL' => 'Normal (standard)',
    'LBL_FONTSIZE_LARGE' => 'Stor',
    'LBL_FONTSIZE_LARGER' => 'Veldig stor',
    'LBL_FONTSIZE_HUGE' => 'Enorm',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'Ekstra enorm',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "Download failed\r\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'Mer...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...Mindre',
    'LBL_OFFLINE_MODE' => 'Offline modus',
    'LBL_OFFLINE_DELETED' => 'Post ikke funnet.',
    'LBL_OFFLINE_DELETED_RELATED' => 'Relatert post ikke funnet. Den er trolig slettet eller frakoblet.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'Nedlasting av dine tildelte, favoritter og fulgte poster for offline tilgang kan ta litt tid å fullføre. En rask tilkobling anbefales. Vil du fortsette?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'Ønsker du at dine tildelte, favoritt og fulgte poster skal bli lastet ned nå for frakoblet tilgang? En rask tilkobling anbefales da denne operasjonen kan ta litt tid. Du kan laste ned senere fra Main Menu> Frakoblet.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'Poster lastet ned',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'Last ned dine poster...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'Feil ved nedlasting av poster',
    'LBL_OFFLINE_PREFETCHING' => 'Laster poster...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'Laster {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'Tiden som gjenstår er ca {{estimatedTime}}s...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => 'Laster {{module}} fullført',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'Opprydding av lagring ...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'Opprydding fullført',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'Ønsker du å tilbakeføre denne endringen?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'Tilbakeføring fullført',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'Kunne ikke tilbakestille',
    'LBL_OFFLINE_CLEAR_DB' => 'Tøm lagringsplass...',
    'LBL_OFFLINE_COMPACT_DB' => 'Kompakt lagring...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'Denne handlingen vil slette poster du ikke har brukt på en stund. Fortsette?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'Ønsker du å slette alle poster fra lokal lagring?',
    'LNK_OFFLINE_SETTINGS' => 'Offline',
    'LBL_OFFLINE_SETTINGS' => 'Feilsøke instillinger',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'Ingen endringer i påvente av synkronisering.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'Endringer som venter på synkronisering.',
    'LBL_OFFLINE_STATUS_ONLINE' => 'Enheten er online.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'Enheten er offline.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'Får ikke kontakt med serveren.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'Siste synkroniseringsforsøk mislyktes. Kontroller transaksjonslogg.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'Synkronisering pågår ...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'Transaksjonen synkronisert.',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'Er du sikker på at du vil slå på offline-støtte?',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'Ønsker du å slå av offline-støtte? Alle endringer i påvente synkronisering vil gå tapt.',
    'LBL_OFFLINE_ENABLED' => 'Offline modus aktivert',
    'LBL_OFFLINE_DISABLED' => 'Offline modus deaktivert',
    'LBL_OFFLINE_STATS' => 'Lagrings statistikk',
    'LBL_OFFLINE_SERVER_FETCH' => 'Henter fra server ...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'Noen har redigert den samme posten på serveren. Bekreft for å auto-flette dine endringer eller avvise å forkaste dem.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'Siste synkroniseringsforsøk: {{ts}}',
    'LBL_ACTION_UPDATE' => 'OPPDATER',
    'LBL_ACTION_CREATE' => 'SKAP',
    'LBL_ACTION_DELETE' => 'SLETT',
    'LBL_ACTION_LINK' => 'KOBLE',
    'LBL_ACTION_UNLINK' => 'FJERN KOBLING',
    'LBL_ACTION_FAVORITE' => 'FAVORITT',
    'LBL_ACTION_FOLLOW' => 'FØLG',
    'LBL_ACTION_CREATE_EXPLANATION' => 'Opprettet {{module}} "{{name}}"',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'Oppdaterte {{module}} "{{name}}"',
    'LBL_ACTION_DELETE_EXPLANATION' => 'Slettet {{module}} "{{name}}"',
    'LBL_ACTION_LINK_EXPLANATION' => 'Koblet {{module}} "{{name}}" til {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'Fjernet kobling {{module}} "{{name}}" fra {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'Fulgte {{module}} "{{name}}"',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'Fjerne følge {{module}} "{{name}}"',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'Favoriserte {{module}} "{{name}}"',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'Fjerne favorisering {{module}} "{{name}}"',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'Opprettet {{module}} "{{name}}" relatert til {{relatedModule}} "{{relatedName}}"',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'Primær',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'Opt-out',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'Opt-in',
    'LBL_EMAIL_ACTION_SET_VALID' => 'Gyldig',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'Ugyldig',
    'LBL_ROLLBACK_BUTTON' => 'Tilbakeføring',
    'LBL_TX_LOG' => 'Transaksjonslogg',
    'LBL_TX_LOG_DETAIL' => 'Transaksjonsdetalj',
    'LBL_RECORD_DELETED' => '(Post slettet)',
    'LBL_NOT_AVAILABLE' => 'N/A',
    'LBL_FILE_SIZE' => 'Filstørrelse',
    'LBL_FILE_SIZE_UNITS_B' => 'Bytes',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'Velge elementer',
    'LBL_OFFLINE_DB_SIZE' => 'Database størrelse',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'Poster per modul',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'Totalt antall poster',
    'LBL_RECORD_NOT_FOUND' => 'Post ikke funnet.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'Relatert post ikke funnet.',
    'LBL_NOT_AUTHORIZED' => 'Du er ikke autorisert til å se denne posten.',
    'LBL_MOBILE_PROCESSING_FILE' => 'Forbereder filen …',
    'LNK_THIRD_PARTY_SOFTWARE' => 'Tredjeparts programvare',
    'LNK_TERMS_OF_USE' => 'Tjenestevilkår',
    'LNK_PRIVACY_POLICY' => 'Personvern',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'Enkel pålogging',
    'LBL_RECENTS' => 'Nylige',
    'LBL_SHOWING_CACHED_DATA' => 'Kunne ikke nå serveren. Viser den nyeste tilgjengelige dataen ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'Lukk {{moduleSingular}} og lagre',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'Bestemt instrumentpanel',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Bestemt modul',
    'LBL_MOBILE_DEFAULT_VIEW' => 'Startskjerm',
    'LBL_MOBILE_DEFAULT_MODULE' => 'Valgt modul',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'Valgt instrumentpanel',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'Valgt dashlet',
    'LBL_ALL_DASHLETS' => 'Alle dashlets',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'Globalt Søk',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Skriv inn @ for å nevne en bruker. Skriv inn # for å referere til en post.',
    'LBL_MOBILE_NEW_COMMENT' => 'Ny kommentar',
    'LBL_RECENTLY_VIEWED' => 'Nylig viste',
    'LBL_FILE_STORED_LOCALLY' => 'Fil er lagret på lokal lagring og vil synkroniseres så enheten er online.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'Hvis du ønsker å endre visse felt som ikke er redigerbare, kontakt administratoren din for å varsle om disse endringene.',
    'LBL_ACTIVITY_POST' => '{{{value}}}på {{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'Ingen kommentar',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'Vis neste {{{commentsLeft}}} kommentarer',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'Slå sammen',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'Bekreft kommentaropprettelse',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'Kommentarlogg kan ikke være tom',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'Last ned {{{pdfTemplateName}}} PDF',

    'ERR_SYNC_FAILED' => 'Kan ikke synkronisere med serveren.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'Tilgang ikke autorisert.',
    'ERR_MOBILE_INVALID_CREDS' => 'Ugyldig brukernavn eller passord.',
    'ERR_MOBILE_SESSION_EXPIRED' => 'Økten er utløpt.',
    'ERR_MOBILE_NOT_FOUND' => 'Ressurs ikke funnet.',
    'ERR_MOBILE_TIMEOUT' => 'Server svarer ikke.',
    'ERR_MOBILE_CONNECTION_FAILED' => 'Kan ikke nå server.',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'Internetforbindelse utilgjengelig.',
    'ERR_MOBILE_INTERNAL' => 'Intern feil ({{{code}}}). Vennligst prøv igjen senere.',
    'ERR_MOBILE_VALIDATION' => 'Posten er ugyldig',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'Uforenlig server variant: {{{flavor}}}. Støttede varianter:  {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'Uforenlig server versjon: {{{version}}}. Minimum nødvendig versjon: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'Feil. Ugyldig e-postadresse.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'Denne dokumenttypen er ikke støttet.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'Autentisering mislyktes.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'Forespurte ressurs ble ikke funnet.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'Intern server feil.',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'Forbudt.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'Tjenesten er ikke tilgjengelig.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'Det har oppstått en uventet feil.',
    'ERR_MOBILE_UPLOAD' => 'Feil under opplasting',
    'ERR_MOBILE_FILE_PROCESSING' => 'Filbehandlings feil',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'Enhets lagring er utilgjengelig',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'Din app er utdatert og er ikke lenger kompatibel med {{{brandName}}} instansen du er koblet til. Ønsker du å laste ned den nye versjonen fra App Store?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'Server konfigurasjon er endret og reload er nødvendig. Fortsette?',
    'ERR_MOBILE_CONFLICT' => 'Noen har redigert den samme posten på serveren. Bekreft for å auto-flette dine endringer eller avvise å forkaste dem.',
    'ERR_MOBILE_METADATA_CHANGED' => 'Server konfigurasjon er endret.',
    'ERR_MOBILE_FILE_READ' => 'Kunne ikke lese filen',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'Finner ikke filen',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'Fil ikke lesbar',
    'ERR_MOBILE_FILE_ABORTED' => 'Les operasjonen ble avbrutt',
    'ERR_MOBILE_FILE_SECURITY' => 'Fil er låst',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'Mobile-versjonen støtter ikke denne funksjonaliteten. Ønsker du å åpne desktop-versjonen?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'Filen er for stor. Maksimal tillatt størrelse er {{size}}',
    'ERR_OFFLINE' => 'Offline feil',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'Kunne ikke åpne lokal lagring',
    'ERR_OFFLINE_STORAGE_CREATE' => 'Klarte ikke å opprette lokal lagring',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'Klarte ikke å opprette lokal lagring: du har gått tom for plass.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'Du har gått tom for plass for lokal lagring.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'Database opprydding mislyktes',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'Du har gått tom for plass til offline lagring. Opprydding av oppbevaring anbefales. Dette kan ta flere minutter.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'Klarte ikke å forhåndshente poster fra serveren',
    'ERR_OFFLINE_SYNC_ERROR' => 'Synkronisering feil',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'synkroniseringskonflikt',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'Klarte ikke å få server tid',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'Kunne ikke aktivere offline-modus. Kunne ikke nå serveren.',
    'LBL_EXPORT_CSV' => 'Eksporter CSV',
    'LBL_ERR_EXPORTING_CSV' => 'Eksport mislyktes',
    'LBL_ERR_EXPORT_ALL' => 'Kunne ikke hente data for valgte poster. Prøv på nytt.',
    'LBL_LIST_SETTINGS_RESTORE' => 'Gjenopprett standarder',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'Gjenopprette felt?',
    'LBL_LIST_SETTINGS_TITLE' => 'Listevisningsbygger',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'Mulige felt',
    'LBL_LIST_SETTINGS_REMOVE' => 'Fjern',
    'LBL_LIST_SETTINGS_TEXT' => 'Dra felt inn i listevisningsbyggeren og omorganiser dem for å designe {{moduleName}}-listevisningen.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'Minst ett felt må legges til i oppsettet.',
    'LBL_LIST_SETTINGS_EMPTY' => 'Ingen ledige felt',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'Ingen passende felt foreligger',
    'LBL_LIST_FILTER' => 'Feltsøk',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'E-post-klient',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'Ekstern e-postklient',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar e-postklient',
    'LBL_OFFLINE_CAPABILITIES' => 'Aktiver frakoblet funksjonalitet',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'Kunne ikke slette transaksjon.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'Transaksjonen er slettet.',
    'LBL_SECURE_MODE' => 'Forsterket sikkerhetsmodus',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'Aktiver denne innstillingen for å skjule innholdet i Sugar Mobile når appen er i bakgrunnen og for å forhindre skjermbilder av appen når som helst.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'Aktiver denne innstillingen for å skjule innholdet i Sugar Mobile når appen er i bakgrunnen.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'Alltid frakoblet modus',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'Du jobber i alltid frakoblet modus. Vil du koble til på nytt?',
    'LBL_RECONNECT' => 'Koble til på nytt',
    'LBL_STAY_OFFLINE' => 'Forbli frakoblet',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'Modulen du prøver å få tilgang til er ikke tilgjengelig på Sugar Mobile.',
    'LBL_MOBILE_RELEASE_NOTE' => 'Versjonsnotater for Sugar Mobile for {{platform}}',
    'LBL_MOBILE_USER_GUIDE' => 'Brukerveilening for Sugar Mobile for {{platform}}',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'inneholder disse ordene',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'inneholder ikke disse ordene',
    'LBL_NOTIFICATIONS_CHANNEL' => 'Oppdateringer',
    'LBL_APPLY_BUTTON_LABEL' => 'Bruk',
    'LBL_ACTION_CREATE_FAILURE' => "Kunne ikke lagre posten':\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "Kunne ikke oppdatere posten':\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'Kunne ikke løse feltberegninger på serveren.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'Følgende felt er ugyldige: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>Fullført.</b> Du har opprettet {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}".</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>Fullført.</b> Du har oppdatert posten',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'Kunne ikke hente e-postdata fra serveren.',
    'LBL_ASSIGN_SUCCESS' => '<b>Fullført.</b> Oppføringen er tildelt {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'Vil du lagre denne e-posten som et utkast?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'Lagre som utkast',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'Forkast e-post',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'Hvis du ikke lagrer utkastet, mister du denne e-posten.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'Velg signatur',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'Velg e-postmal',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'Malen vil overskrive alt innholdet i denne e-posten. Er du sikker på at du vil bruke denne malen og overskrive innhold?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'Skriv e-post',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'E-posten din inneholder variabler som vil bli erstattet med verdier fra Relatert til-posten. Vennligst bekreft at Relatert til-feltet er riktig angitt før du sender.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'Finner ingen utgående e-postkonto. Ta kontakt med Sugar-administratoren din.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' og {{{count}}} flere',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'Legg til e-post',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'Skriv inn kontaktnavn eller e-post',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (Ny e-post)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'Variabler',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'E-postmaler',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'Kampanjemaler',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'Arbeidsflytmaler',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'Systemmaler',
    'LBL_FILTER_EDIT' => 'Rediger filter',
    'LBL_FILTER_MY_FILTER' => 'Mitt filter',
    'LBL_FILTER_MY_FILTER_BY' => 'Mitt filter av {{{filters}}}',
    'LBL_FILTER_SAVE' => 'Lagre filter',
    'LBL_SELECT_PARAM' => 'Velg',
    'LBL_SELECT_MODULES' => 'Modulvelger',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'Velg ytterligere parameter',
    'LBL_FILTER_TEMPORARY' => 'Midlertidig filter',
    'LBL_ERROR_FILE_UPLOAD' => 'Kunne ikke laste opp {{{fieldLabel}}} filen "{{{fileName}}}". {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">Se mislykket post</a>',
    'LBL_FILE_UPLOAD_ONE' => 'Lagrer fil ...',
    'LBL_FILE_UPLOAD_MANY' => 'Lagrer fil {{{index}}} av {{{total}}} ...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'Varslingsinntillinger',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'Administrer push-varslene dine',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "Kontroller hvordan varsler vises ved å bruke enhetens varslingsinnstillinger.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'Tildelinger',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'Motta varsler når poster blir tildelt deg.',
    'LBL_NOTIFICATION_MENTIONS' => 'Omtaler',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'Motta varsler når du er omtalt i kommentarloggoppføringer.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'Kommentarlogg-feltet er ikke lagt til denne layouten av en administrator. Ta kontakt med Sugar-administratoren din.',
    'ERR_NO_PERMISSION_TITLE' => 'Gi tilgang',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} trenger kameratilgang slik at du kan legge ved bilder. Tillat kameratilgang i systeminnstillingene.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'Innstillinger',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'Varighet',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'Gjenstående tid',
    'LBL_LIST_SUPPORT_EXPIRES' => 'Utgår',
    'LBL_CASCADE_RLI_EDIT' => 'Oppdater åpne omsetningsposter',
    'LBL_MOBILE_CALENDAR' => 'Kalender',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'Kalenderinnstillinger',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'Ukestart i dag',
    'LBL_MOBILE_CALENDAR_MODULES' => 'Hendelser som skal vises',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}t:{{{minutes}}} min',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} timer',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} min',
    'LBL_MOBILE_CALENDAR_TODAY' => 'I dag',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => 'Legg til {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'Planlegg en aktivitet',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'Aktiver minst én hendelsestype.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'Hele dagen',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'Kunne ikke laste inn kalendre.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'Denne handlingen kan ikke benyttes i Sugar Mobile. Vil du åpne skrivebordsapplikasjonen i stedet?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'Velg mal',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'Slå sammen',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'Feil: EXIF-data mangler fra HEIC-fil',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'Feil: Bildeoppløsningen er for stor',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'Feil: Kan ikke behandle bildet',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'Feil: Kunne ikke gjengi bildet til lerret',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'Feil: Kunne ikke laste filen som bilde',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1 objekt er valgt',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} valgte objekter',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'Velg alle',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'Du har valgt {{{count}}} poster i denne visningen. Velg alle poster?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'Velg {{{count}}} poster',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'Er du sikker på at du vil slette valgte post(er)?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'Sletter … {{{count}}} av {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'Ingen gyldig e-post finnes i de valgte postene',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'Utseende',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'Bruk systeminnstilling',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'Lys',
    'LBL_MOBILE_APP_THEME_DARK' => 'Mørk',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'Nytt filnavn',
    'LBL_ATTACHMENT_RENAME_MSG' => 'Rediger filnavn',
    // Filters related
    'LBL_CREATED_BY_ME' => 'Opprettet av meg',
    'LBL_OPERATOR_ONE_OF' => 'er en av',
    'LBL_OPERATOR_NOT_ONE_OF' => 'er ikke en av',
    'LBL_OPERATOR_CONTAINS' => 'er noe av',
    'LBL_OPERATOR_CONTAINS_WORD' => 'innholder',
    'LBL_OPERATOR_NOT_CONTAINS' => 'er ikke noe av',
    'LBL_OPERATOR_EMPTY' => 'er tom',
    'LBL_OPERATOR_NOT_EMPTY' => 'er ikke tom',
    'LBL_OPERATOR_MATCHES' => 'stemmer nøyaktig overens',
    'LBL_OPERATOR_STARTS_WITH' => 'begynner med',
    'LBL_OPERATOR_EQUALS' => 'er lik',
    'LBL_OPERATOR_NOT_EQUALS' => 'er ikke lik',
    'LBL_OPERATOR_GREATER_THAN' => 'er mer enn',
    'LBL_OPERATOR_LESS_THAN' => 'er mindre enn',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'er større enn eller lik',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'er mindre enn eller lik',
    'LBL_OPERATOR_BETWEEN' => 'er mellom',
    'LBL_OPERATOR_BEFORE' => 'før',
    'LBL_OPERATOR_AFTER' => 'etter',
    'LBL_OPERATOR_YESTERDAY' => 'i går',
    'LBL_OPERATOR_TODAY' => 'i dag',
    'LBL_OPERATOR_TOMORROW' => 'i morgen',
    'LBL_OPERATOR_LAST_7_DAYS' => 'siste 7 dager',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'neste 7 dager',
    'LBL_OPERATOR_LAST_30_DAYS' => 'siste 30 dager',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'neste 30 dager',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'For mer enn __ dager siden',
    'LBL_OPERATOR_LAST_X_DAYS' => 'Siste __ dager',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'Neste __ dager',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'Mer enn __ dager i fremtiden',
    'LBL_OPERATOR_LAST_MONTH' => 'forrige måned',
    'LBL_OPERATOR_THIS_MONTH' => 'denne måneden',
    'LBL_OPERATOR_NEXT_MONTH' => 'neste måned',
    'LBL_OPERATOR_LAST_YEAR' => 'i fjor',
    'LBL_OPERATOR_THIS_YEAR' => 'i år',
    'LBL_OPERATOR_NEXT_YEAR' => 'neste år',
    'LBL_OPERATOR_IS' => 'er',
    'LBL_OPERATOR_IS_NOT' => 'er ikke',
    'LBL_OPERATOR_AFTER_TODAY' => 'etter i dag',
    'LBL_OPERATOR_BEFORE_TODAY' => 'før i dag',
    'LBL_ERROR_FILTER_EMPTY' => 'Legg til filterkriterier.',
    'LBL_ADD_FILTER' => 'Legg til filterkriterier',
    'LBL_FILTER_NAME' => 'Filternavn',
    'LBL_FILTER_FIELD' => 'Felt',
    'LBL_FILTER_OPERATOR' => 'Operatør',
    'LBL_FILTER_VALUE' => 'Verdi',
    'LBL_FILTER_SYNC_TO_SERVER' => 'Lagre til Desktop-appen',
    'LBL_FILTER_LOCAL' => 'Lokalt filter',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'Velkommen til {{{brandName}}}.<br/><br/> Tillat oss å fremheve noen nye funksjoner...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'Hovedmeny navigasjon.',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'Tilgjengelige handlinger per visning.',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'Globalt søk etter poster.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'Filtrere listen for å vise mine favorittposter.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'Filtrere listen for å vise poster som er tildelt meg.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'Markere posten som en favoritt.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'Mine kommende hendelser som starter i dag.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'Mest nylig endret poster.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'Tilgjengelige handlinger på en post.',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'Nyt alle de nye funksjonene!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'Dette er pluss menyen.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'Lukk pluss menyen.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'Velg den spesifikke handlingen å vise for å utføre.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'Dette er hjem menyen.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'Lukk hjem menyen.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'Se på et bestemt modul.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'Tilpass programmet.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'Åpne Sugar i nettleseren.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'Se profilen din.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'Dette er detaljsiden.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'Den viktigste informasjonen om en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'Se tilleggsinformasjon eller redigere en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'Tilgjengelige handlinger på en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'Gå til forrige side.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'Få tilgang til innføring når som helst.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'Gå tilbake.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'Klikk for åpne en relatert post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'Følg / slutt å følge en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'Klikk for å utvide en detaljinformasjon.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'Hovedmenyvisning.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'Hovedmenyen åpnes på venstre side av skjermen.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'Detaljert',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'Detaljvisningen åpnes på høyre side av skjermen.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'Bruk pilene nedenfor for en rask innføring av nøkkelkomponentene i menyen.',

    'LBL_COMMENT_ADD' => 'Legg til kommentar',
    'LBL_REQUIRED' => 'Obligatorisk',
    'LBL_MORE_BUTTON' => 'Mer',
    'LBL_NO_OPTIONS' => 'Ingen tilgjengelige alternativer',
    'LBL_TRY_AGAIN' => 'Prøv igjen',
    'LBL_NEW_RECORDS' => 'Nylig opprettet',
    'LBL_ASSIGNED_TO_ME' => 'Min {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'Alle {{{module}}}',
    'LBL_UNFAVORITE' => 'Fjern favoritt',
    'LBL_ACTIVITY_CREATE' => 'Opprettet {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => 'Oppdatert {{{changes}}} på {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => 'Koblet {{{relatedRecord}}} "{{{record}}}" til {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => 'Fjernet kobling {{{relatedRecord}}} "{{{record}}}" til {{{module}}}',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} for {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'Last ned relaterte poster...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'Dashboardkonfigurasjonen er endret. Vil du laste på nytt?',
    'LBL_RECORDS' => 'Poster',
    'LBL_DASHBOARDS' => 'Dashbord',
    'LBL_TEMPLATES' => 'Maler',
    'LBL_NON_TEMPLATES' => 'Ikke maler',
    'LBL_IS_TEMPLATE' => 'Er mal',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'Utvalget ditt inneholder dashbordmaler, som ikke kan masseoppdateres. Fjern merket for maler for å fortsette.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'Utvalget ditt inneholder dashbordmaler, som ikke kan masseslettes. Fjern merket for maler for å fortsette.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'Søk {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'Hovedmeny',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'Opprett raskt ny post',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'Sveip for flere alternativer',
    'LBL_DETAILS' => 'Detaljer',
    'LBL_DETAIL_RELATED' => 'Relatert',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'Denne {{module}} krever en {{relatedModule}}. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>oppretter en {{relatedModule}} -post</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'Rediger post',
    'LBL_OFFLINE_MENU_SETTINGS' => 'Offline-innstillinger',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'Feilsøke innstillinger',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'Totalt antall poster',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'Siste nedlasting',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'Kan ikke laste ned filen.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'Kan ikke laste inn oversikter fra server',
    'ERR_FILTERS_FETCHING' => 'Kan ikke hente filtre',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'Kunne ikke kryptere lokal lagring',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'Krypterer frakoblede data. Dette kan ta flere minutter.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'Frakoblet datakryptering fullført.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'Du har ikke tilgang til {{{module}}}-modulen.',
    'LBL_SKIP' => 'Hopp over',
    'LBL_CONTINUE' => 'Fortsett',
    'LBL_ENABLE' => 'Aktivér',
    'LBL_MOBILE_TRIAL_UNTIL' => 'Prøve til',
    'LBL_MOBILE_SDK_VERSION' => 'SDK-versjon',
    'LBL_LOG_LEVEL' => 'Loggnivå',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'Påloggingsinnstillinger har blitt konfigurert på nytt.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'Prøveperioden er utløpt.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'Serveren støtter ikke sikker tilkobling. Deaktiver sikker tilkobling.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'Serveren støtter ikke sikker tilkobling. Deaktiver sikker tilkobling.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'Tilkoblingen er ikke sikker. Kontakt systemansvarlig.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'Påloggingsinnstillinger',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'Sette opp din {{{brandName}}} -forekomst',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'For at appen skal fungere må du skrive inn nettadressen til forekomsten av {{{brandName}}} . Hvis du ikke har forekomst-URL, kontakt systemansvarlig.',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => 'Kontakt-ID',
    'LBL_ENABLE_TOUCHID' => 'Enable {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => 'Setup {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'Logg på ved å bruke fingeren',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} is not set up on your device. \n\nGo to your device settings to set up {{{biometryType}}}. Once set up, enable {{{biometryType}}} for {{{brandName}}} in Main Menu > Settings.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'Using {{{biometryType}}} with {{{brandName}}} will allow you to use your biometric identifier instead of entering your password to access {{{brandName}}}.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'Would you like to proceed with {{{biometryType}}}?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'Enter {{{brandName}}} Password to Enable {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'Oppsett',
    'LBL_MDM_CONFIRM_CHANGE' => 'Programkonfigurasjon er endret fra Mobile Device Manager. Logg på igjen for å anvende endringer.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'Gi {{{brandName}}} tilgang til din plassering via enhetens innstillinger.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'Nåværende plassering er ikke tilgjengelig',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "Current location retrieval timed out. \nPlease try again.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'Stedplasseringsmerker er ikke tilgjengelig',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'Stedkoordinater er ugyldige',
    'ERR_MOBILE_INVALID_PASSWORD' => 'Ugyldig passord.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'Din app er utdatert og er ikke lenger kompatibel med {{{brandName}}}-forekomsten du er koblet til. Ønsker du å laste ned den nye versjonen fra App Store?',
    'LBL_MOBILE_BY' => 'Av',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'Dette filteret er ikke tilgjengelig frakoblet',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'Frakoblede poster',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'Nedlastingsinnstillinger',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'Last ned dine tilordnede, favoritt og fulgte poster for tilgang frakoblet. Du kan oppdatere preferansene dine i offlineinnstillinger.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'Your records have finished downloading. You can now access them in offline mode.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "Not all your records were downloaded.\n Do you want to try again?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'Bruk mobildata',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'Ikke akkurat nå',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'Nedlasting er satt på pause og vil starte opp igjen når du åpner appen igjen.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'Laster ned {{{module}}} {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'Oppdater nyeste poster',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'Venter på tilkobling',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'Satt på pause',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'Stopper',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'Last ned',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'Pause',
    'LBL_BULK_LOAD_BTN_RESUME' => 'Gjenoppta',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'Kun WiFi-tilkobling brukes som standard',
    'LBL_NPS_RATING_MSG' => "How would you rate your \n{{{productName}}} experience?",
    'LBL_NPS_THANKS_MSG' => 'Takk for din tilbakemelding!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'Vil du gi det en vurdering i App Store?',
    'LBL_NPS_NO_THANKS' => 'Nei takk',
    'LBL_NPS_NOT_NOW' => 'Ikke nå',
    'LBL_NPS_RATE_NOW' => 'Vurder nå',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'Nettverket er ikke tilgjengelig. Du kan fortsatt bruke appen mens du er frakoblet',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'Endringene dine vil bli synkronisert når du er frakoblet. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>Se detaljer</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'Det er usynkroniserte data. Kontroller <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>-transaksjonslogg</a>',
    'LBL_CONVERT' => 'Konverter',
    'LBL_CONVERT_LEAD' => 'Konverter emne',
    'LBL_SEARCH_EXISTING_RECORD' => 'Søk etter eksisterende {{{this}}}',
    'LBL_DUPLICATES_CHECK_FAILED' => 'Duplikaterkontroll mislyktes',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'Vil du flytte beslektede aktiviteter til kontaktoppføringen?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'Du konverterte emne med hell {{{name}}}',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'Ingen duplikater funnet.',
    'ERR_LEAD_CONVERSION_FAIL' => 'Emnekonvertering mislyktes',
    'LBL_SELECT_DUPLICATE_RECORD' => 'Velg fra duplikat {{{modulePlural}}}',
    'LBL_SELECTED_EXISTING_RECORD' => 'Valgt {{{moduleSingular}}}',
    'LBL_CREATED_NEW_RECORD' => 'Opprettet ny {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => 'Tilbake-knapp',
    'LBL_VO_HOME_BTN' => 'Hjem-knapp',
    'LBL_VO_DASHBOARD_BTN' => 'Dashboard-knapp',
    'LBL_VO_SEARCH_BTN' => 'Søk-knapp',
    'LBL_VO_RIGHT_MENU_BTN' => 'Høyre menyknapp',
    'LBL_VO_ADD_BTN' => 'Legg til knapp',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'Rabatt',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'Velge en tilordningsapp',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'De valgte {{entityName}} har relaterte verdier: {{localizedFieldNames}}. Avbryt for å beholde eksisterende verdier. Bekreft for å overskrive med nye verdier.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'Datakryptering er aktivert.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'Valgt leder er allerede konvertert.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'Denne handlingen er kun tilgjengelig når enheten er online',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'Er du sikker på at du vil fjerne denne muligheten fra det valgte tilbudet?',
    'LBL_TAG_ADD' => 'Legg til merke',
    'LBL_TAG_ENTER_TAG_NAME' => 'Angi merke',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'Filtrering etter merker støttes ikke mens enheten er frakoblet.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'Vis hele kommentaren',
    'LBL_COMMENT_VIEW' => 'Vis en kommentar',
    'LBL_PMSE_LABEL_DUEDATE' => 'Passende dato',
    'LBL_PMSE_DUE' => 'Forfaller',
    'LBL_PMSE_DUE_ON' => 'Forfaller',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'Opprett {{conversionParentModuleName}} først',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'Mangler nødvendige registre: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'Velg bildekvalitet. Størrelsen på bildet vil bli endret før lagring til serveren. Valgt verdi vil bli brukt som standard for lignende videre operasjoner.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'Beregner filstørrelse...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'Beregnet filstørrelse er',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'Bildekvalitet',
    'LBL_IMAGE_QUALITY_BEST' => 'Opprinnelig størrelse',
    'LBL_IMAGE_QUALITY_GOOD' => 'God kvalitet',
    'LBL_IMAGE_QUALITY_POOR' => 'Liten størrelse',
    'LBL_IMAGE_QUALITY_BTN' => 'Komprimering: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'Listefelt på {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'Tilbakestill til standard',
    'LBL_LIST_NOT_ENOUGH' => 'Angi minst 1 aktiv felt.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'Du må logge på og godta tillatelser for å kunne jobbe med SugarCRM-instans.',
    'LBL_SELECTING_EXISTING_RECORD' => 'Velger {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'Oppretter ny {{{moduleSingular}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'Bildestørrelse',
    'LBL_COPY_ADDRESS' => 'Kopier adresse',
    'LBL_OPEN_IN' => 'Åpen i',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'Ingen fil valgt.',
    'LBL_ATTACHMENT_ADD' => 'Fest',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'Denne appen bruker informasjonskapsler',
    'LBL_USE_COOKIES_CONFIRM' => 'Denne appen bruker informasjonskapsler for å bidra til å gi deg en bedre opplevelse. Ved å fortsette samtykker du til bruk av informasjonskapsler i samsvar med vår personvernerklæring.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'Du bruker en Sugar-instans som ikke vil være kompatibel med Sugar Mobile i en kommende mobilutgivelse. Be administratoren om å oppgradere Sugar så snart som mulig.',
    'ERROR_TAG_NAME_INVALID' => 'Merkenavn kan ikke inneholde "{{{forbiddenChars}}}" tegn',
    'ERROR_NO_TAGS_FOUND' => 'Ingen merke tilgjengelig som samsvarer med "{{{searchQuery}}}"',
    'ERR_PA_RECORD_INVALID' => '{{{moduleName}}}-register har èn eller flere ugyldige verdier og kan ikke lagres. Ønsker du å endre registret for å utføre {{{actionLabel}}}-handling?',
    'ERR_MOBILE_METADATA_RELOAD' => 'En admin har gjort konfigurasjonsendringer i Sugar-instansen din. Trykk OK for å synkronisere appens konfigurasjon med serveren.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'Denne applikasjonen bruker informasjonskapsler',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'Sjekk for å godta (kreves)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'Denne applikasjonen bruker informasjonskapsler for å bidra til å gi deg en bedre opplevelse. Ved å fortsette samtykker du til bruk av informasjonskapsler i samsvar med vår <a href="{{href}}" target="_blank">personvernerklæring</a>.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'Post visningen tillater deg å se detaljene for en post.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Med Notes kan du samarbeide med andre portalbrukere og support representanter.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'Klikk her for å legge til et notat til denne posten.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'Klikk på disse ikonene for å vise detaljene i vedlagte notater.',

    //for portal
    'LBL_PORTAL_HOME' => 'Hjem dashbord',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'Alle åpne saker',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'Nylig løste saker',
    'LBL_PORTAL_SEARCH' => 'Søk ved navn, nummer',
    'LBL_SIGNUP_BUTTON_LABEL' => 'Registrér',
    'LBL_PORTAL_NO_EMAIL' => 'Fikk du ikke en e-post?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'Glemt passord',
    'LBL_PORTAL_FORGOT_USERNAME' => 'Glemt brukernavn',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'Skriv inn passordet ditt to ganger. Passord stemmer ikke overens.',
    'LBL_PORTAL_RESET_PASSWORD' => 'Tilbakestill passord',
    'LBL_PORTAL_REENTER_PASSWORD' => 'Skriv inn passord på nytt',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'Passord stemmer ikke overens, oppgi på nytt',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'Passordene dine er tilbakestilte.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'En feil oppstod. Initier en ny passordtilbakestillingsforespørsel.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'Registrering',
    'LBL_PORTAL_SIGNUP_TITLE' => 'Takk for at du registrerte deg',
    'LBL_PORTAL_SIGNUP' => 'Vi informerer deg etter at vi bekrefter detaljene dine.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'Fornavn',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'Etternavn',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'Brukernavn',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'E-postadresse',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (valgfritt)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'Land',
    'LBL_PORTAL_SIGNUP_STATE' => 'Fylke',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'Firmanavn',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'Jobbtittel (valgfritt)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'Passord',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'Bekreft passord',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'Glemt pålogging',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'Glemt passord?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'Du må kontakte din Sugar-administrator for å tilbakestille passordet.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'Brukernavn',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'Passord',
    'LBL_PORTAL_LOADING' => 'Laster inn',
    'LBL_PORTAL_SAVING' => 'Lagrer',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'Siden er ikke tilgjengelig',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "Vi beklager, men denne funksjonen er for øyeblikket ikke tilgjengelig.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'Vis søkeresultater for "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'Fikk du ikke en e-post?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'For hjelp, eller for å kontakte oss, bruk et av følgende: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'Telefonnummer: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'E-post: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'Web: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'Er du sikker på at du vil lukke chatten?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'Opprett notat eller vedlegg',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'Legg til et notat',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'Påloggingen var ikke vellykket. Prøv igjen.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'Gal påloggingsinformasjon',
    'LBL_PORTAL_INVALID_GRANT' => 'Økten din er utløpt. Logg på igjen.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'Økt utløpt',
    'LBL_PORTAL_AUTH_FAILED' => 'Klient-autentisering feilet.',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'Ugyldig klient',
    'LBL_PORTAL_INVALID_REQUEST' => 'Forespørselen er ugyldig eller feil. Vennligst ta kontakt med teknisk support.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'Ugyldig forespøsel',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'Forespørselen utløp på tid.',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'Forespørsel tidsutløp',
    'LBL_PORTAL_UNAUTHORIZED' => 'Beklager, men det ser som at du er uautorisert for tilgang til denne ressursen.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'HTTP Error: 401 Unauthorized',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'Ressurs ikke tilgjengelig.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'HTTP Error: 403 Forbidden',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'HTTP-metoden er ikke tillatt for denne ressursen. Vennligst ta kontakt med teknisk support.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP Error: 405 Method Not Allowed',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'Forespørselssvikt, eller mangler/feil parameter. Vennligst ta kontakt med teknisk support',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'HTTP Error: 412',
    'LBL_PORTAL_MIN_MODULES' => 'Som et minimum må du ha Saker, Bugs eller Kunnskapsbase-modulen aktivert for å bruke dette programmet.',
    'LBL_PORTAL_ERROR' => 'Feil',
    'LBL_PORTAL_ROUTE_ERROR' => 'Problemet ved lasting av modulen. Vennligst prøv igjen senere, eller kontakt support.',
    'LBL_PORTAL_OFFLINE' => 'Sorry, programmet er ikke tilgjengelig for øyeblikket. Vennligst kontakt administrator.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'Endre passord',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'Brukernavnet er allerede registrert i systemet. Be enten om et glemt passord eller velg et annet brukernavn.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'E-posten som ble oppgitt er ugyldig.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'Passordene stemmer ikke overens.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'Servicekonsoll',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'Oversikt',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'Gjenopprett standard instrumentpanel',
    'LBL_UNTITLED' => 'Uten tittel',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'Fornyelser-konsoll',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'Oversikt',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'Trinn/status',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'Navn/kontonavn',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'Instrumentpanel i flere kanaler',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'Kunde',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} ved {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'Nettleseren din støtter ikke SugarLive. Bruk Google Chrome eller Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'En <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> har blitt opprettet som inneholder detaljene for samtalen din.',
    'LBL_OMNICHANNEL_SUBJECT' => 'Emne',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'Beskrivelse',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'Meldingssammendrag',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'Anropssammendrag',
    'LBL_OMNICHANNEL_LINK_TO' => 'Koble {{fromModule}} til {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'Link til {{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'Koblet',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'Nettleseren din støtter ikke chat. Bruk Google Chrome eller Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Ta kontakt med Sugar-administratoren din for assistanse.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'Konfigurer oppsett',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'Fullfør konfigurering av SugarLive før du foretar en utgående samtale.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'Fullfør konfigurering av SugarLive-oppsettet før SugarLive åpnes.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'Sett deg selv til "Frakoblet" i SugarLive før du konfigurerer SugarLive-oppsettet.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'Kompakt visning',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'Full visning',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR-dashboard',
    'LBL_SALES_MANAGER_CONSOLE' => 'Salgssjefdashbord',
    'LBL_SALES_REP_CONSOLE' => 'Dashbord for salgsrepresentanter',
    'LBL_MARKETING_CONSOLE' => 'Markedsføringsdashbord',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'Dashbord for kundesuksess',
    'LBL_EXECUTIVE_CONSOLE' => 'Sjefsdashbord',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'Gjennopprett fane til standard',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'Konfigurer sammendragspanel',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'Brukerprofil',
    'LBL_WIZ_COMPLETE_TITLE' => 'Oppsettet er fullført',
    'LBL_SETUP_COMPLETE_INFO' => 'Begynn å bruke Sugar!',
    'LBL_SETUP_USER_INFO' => 'Angi brukerinformasjon',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'Lokale innstillinger',
    'LBL_SETUP_USER_LOCALE_INFO' => 'Angi tidssone, dato- og navneformat',
    'LBL_WIZ_START_SUGAR' => 'Start Sugar',
    'LBL_WIZ_FIRST_NAME' => 'Fornavn',
    'LBL_WIZ_LAST_NAME' => 'Etternavn',
    'LBL_WIZ_EMAIL' => 'E-postadresse',
    'LBL_WIZ_TIMEZONE' => 'Tidssone',
    'LBL_WIZ_TIMEFORMAT' => 'Tidsformat',
    'LBL_WIZ_DATE_FORMAT' => 'Datoformat',
    'LBL_WIZ_NAME_FORMAT' => 'Forhåndsinnstilt navneformat',
    'LBL_SETUP_PROGRESS' => 'Oppsettsfremgang',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar Opplæring',
    'LBL_WIZ_DOCUMENTATION' => 'Dokumentasjon',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'Kunnskapsbase',
    'LBL_WIZ_FORUMS' => 'Forumer',
    'TPL_TIMEZONE_DIFFERENT' => 'Din nettlesers tidssone samsvarer ikke med den lagrede tidssone {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'Tilpass din tidssone.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'Lokale innstillinger',
    'LBL_WIZ_EMAIL_SETTINGS' => 'E-post-innstillinger',
    'LBL_WIZ_IMPORT_DATA' => 'Importer data',
    'LBL_WIZ_CREATE_USERS' => 'Opprett brukere',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'System-innstillinger',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Studio',

    'LBL_CSP_ERROR_MESSAGE' => 'Verdien(e) du har angitt støttes ikke eller møter ikke det godtatte formatet. For en liste over godtatte feltverdier og formater, henvis til <a href="{{linkToDocumentation}}" target="_blank"> system</a>dokumentasjon.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'Dette innholdet har ikke blitt godkjent. Oppdater systems <a href="{{linkToDocumentation}}" target="_blank"> retningslinjeinnstillinger for innholdsikkerhet</a>.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'Dette innholdet har ikke blitt godkjent. Be din administrator om å oppdatere systemets <a href="{{linkToDocumentation}}" target="_blank">retningslinjeinnstillinger for innholdsikkerhet</a>. Når innstillingene har blitt oppdatert må du oppdatere nettleseren for at endringene tres i kraft.',

    // For password related labels
    'LBL_PASSWORD' => 'Passord',
    'LBL_CHANGE_YOUR_PASSWORD' => 'Endre passordet ditt',
    'LBL_PASSWORD_REQUIREMENTS' => 'Passordkrav',
    'LBL_CURRENT_PASSWORD' => 'Nåværende passord',
    'LBL_NEW_PASSWORD1' => 'Nytt passord',
    'LBL_NEW_PASSWORD2' => 'Bekreft passord',
    'LBL_PASSWORD_CHANGED' => 'Du har endret passordet ditt',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'Vennligst skriv inn passord bekreftelse.',
    'ERR_ENTER_NEW_PASSWORD' => 'Vennligst skriv inn ditt nye passord.',
    'ERR_ENTER_OLD_PASSWORD' => 'Vennligst skriv inn nåværende passord.',
    'ERR_REENTER_PASSWORDS' => 'Passordene må stemme overens.',
    'ERR_PASSWORD_MISMATCH' => 'Passord angitt samsvarer ikke med det i vårt system.',
    'LBL_CANNOT_SEND_PASSWORD' => 'Kan ikke sende passord',
    'LBL_REQUEST_PASSWORD' => 'Be om passord',
    'LBL_RESET_PASSWORD' => 'Tilbakestill passord',
    'LBL_RESET_PASSWORD_MESSAGE' => 'Skriv inn brukernavnet ditt og vi sender deg en lenke for å tilbakestille passordet ditt.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Sjekk e-posten din <br><br> Vi har sendt instruksjoner for tilbakestilling av passord til e-postadressen vi har registrert.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'Feil: Det oppstod et problem med å oppdatere passordet for denne brukeren.',
    'LBL_INCORRECT_PASSWORD' => 'Feil: Ugyldig passord.',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'Passordet du skrev oppfyller ikke kravene til passord. Vennligst prøv igjen.',
    'LBL_PASSWORD_MIN_LENGTH' => 'Minimal lengde er {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'Maksimal lengde er {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'Må inneholde én stor bokstav (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'Må inneholde én liten bokstav (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'Må inneholde ett tall (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'Må inneholde ett spesialtegn (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'Passordet må ikke stemme overens med det vanlige uttrykksmønsteret: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'Innstilling for språk:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'Kunne ikke sende e-post med tilbakestilling av passord.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'Velg en rapport',
    'LBL_REPORT_AUTO_REFRESH' => 'Auto oppdater',
    'LBL_REPORT_EDIT' => 'Rediger valgte rapport',
    'LBL_REFRESH_LIST_AND_CHART' => 'Oppdater liste og tabell',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'Intet diagram er tilgjengelig.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'Denne rapporten inneholder ingen filtre.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'Du har bare skjulte kjøretidsfiltre, se avanserte filtre.',
    'LBL_RUNTIME_FILTERS' => 'Kjøretidsfiltre',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'Datoen samsvarer ikke med brukerens foretrukne datoformat: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'Denne dashleten har ingen kjøretidsfiltre',
    'LBL_DASHBOARD_FILTER_GROUP' => 'Nytt filter',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'Du må ha valgt minst én verdi.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'Tilbakestill til startfiltre',
    'LBL_COPY_FILTER_SUMMARY' => 'Kopier filtersammendrag',
    'LBL_APPLY_FILTERS' => 'Bruk',
    'LBL_REPORTS_FILTERS' => 'Filtre',
    'LBL_RUNTIME_FILTERS_INVALID' => 'Kjøretidsfiltre kan ikke brukes på grunn av ugyldige verdier',
    'LBL_RUNTIME_FILTERS_COPIED' => 'Filtersammendraget har blitt kopiert til utklippstavlen.',
    'LBL_ADVANCED_FILTERS' => 'Avanserte filtre',
    'LBL_ADVANCED_OR_DESC' => 'Ta med hvis MINST ÉN betingelse er oppfylt',
    'LBL_ADVANCED_AND_DESC' => 'Ta med hvis alle betingelser er oppfylt',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'Dette er et originalt designfilter',
    'LBL_AND_UPPERCASE' => 'OG',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'Denne funksjonen kan ikke brukes i forhåndsvisningsmodus',
    'LBL_REPORT_DEFAULT_NAME' => 'Rapport uten navn',
    'LBL_REPORT_QUERY' => 'Forespørsel',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'Relatert til nåværende post',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'Koblet felt',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'Koblet felt kan ikke være tomt',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'Ingen rapport valgt.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'Linjediagram er ikke kompatibelt med denne rapporten',
    'LBL_REPORT_DASHLET' => 'Rapport-dashlet',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'Datatabell',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'Kjøretidsfiltre',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'Forhåndsvisning av datatabell',
    'LBL_REPORTS_DASHLET_CHART' => 'Diagram',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'Forhåndsvisning av diagram',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'Forhåndsvisning av filter',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'Den valgte rapporten støtter ikke et diagram.',
    'LBL_REPORTS_DASHLET_LABELS' => 'Etiketter',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'Vis totalt antall poster',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'Sorteringsrekkefølge',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'Valgt standardvisning',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'Primær sorteringsrekkefølge for diagram',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'Sekundær sorteringsrekkefølge for diagram',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'Ingen {{module}} koblinger til valgt rapport',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'Ikke tilgjengelig for denne rapporttypen',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'Denne funksjonen er bare tilgjengelig i kategorien diagram',
    'LBL_REPORTS_CHART_TYPE' => 'Diagramtype',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'Verdiplassering for søylediagram',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'Vis total',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'Vis oversikt',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Vis x-akseetikett',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Vis y-akseetikett',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Grense for visning av rader',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'Du har ikke tillatelse til å bruke disse kjøretidsfiltrene.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'Ukjent',
    'ERR_HTTP_DEFAULT_TITLE' => 'Ukjent feil',
    'ERR_HTTP_DEFAULT_TEXT' => 'Ukjent feil.',
    'ERR_HTTP_DEFAULT_ACTION' => 'Gå tilbake til forrige side.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'Feil: Ugyldig forespørsel',
    'ERR_HTTP_400_TEXT_LINE1' => 'Nettleseren din sendte en forespørsel som serveren ikke kunne forstå.',
    'ERR_HTTP_400_TEXT_LINE2' => 'Ta kontakt med Sugar-administratoren din for mer informasjon.',
    'ERR_HTTP_400_ACTION' => 'Gå tilbake til forrige side.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'HTTP: 404 Not Found',
    'ERR_HTTP_404_TEXT_LINE1' => 'Siden finnes ikke eller du mangler tilgang til siden.',
    'ERR_HTTP_404_TEXT_LINE2' => 'Prøv på nytt. Hvis feilen vedvarer, kontakt Sugar-administratoren din.',
    'ERR_HTTP_404_ACTION' => 'Gå tilbake til forrige side.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 intern serverfeil',
    'ERR_HTTP_500_TEXT_LINE1' => 'En serverfeil oppsto og forespørselen din kunne ikke utføres.',
    'ERR_HTTP_500_TEXT_LINE2' => 'Prøv på nytt. Hvis feilen vedvarer, kontakt Sugar-administratoren din.',
    'ERR_HTTP_500_ACTION' => 'Vennligst kontakt teknisk support.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 intern serverfeil',
    'ERR_HTTP_502_TEXT_LINE1' => 'En midlertidig serverfeil oppsto og forespørselen din kunne ikke utføres.',
    'ERR_HTTP_502_TEXT_LINE2' => 'Prøv på nytt. Hvis feilen vedvarer, kontakt Sugar-administratoren din.',
    'ERR_HTTP_502_ACTION' => 'Ta kontakt med teknisk støtte.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 intern serverfeil',
    'ERR_HTTP_503_TEXT_LINE1' => 'Serveren er ikke tilgjengelig for å fullføre forespørselen.',
    'ERR_HTTP_503_TEXT_LINE2' => 'Prøv på nytt senere. Hvis feilen vedvarer, kontakt Sugar-administratoren din.',
    'ERR_HTTP_503_ACTION' => 'Ta kontakt med teknisk støtte.',

    'ERR_RENDER_FAILED_TITLE' => 'Vis generert feilet',
    'ERR_RENDER_FAILED_MSG' => 'Vi mislyktes i å generere et utseende',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'Felt-generering mislyktes',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'Ikke i stand til å vise feltet {0}.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'Ingen tilgang',
    'ERR_NO_VIEW_ACCESS_REASON' => 'Du har ikke tillatelse til å få tilgang til denne siden.',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'Kontakt administratoren for å be om tilgang.',
    'ERR_NO_VIEW_ACCESS_MSG' => 'Kontakt din supportadministrator for å få tilgang til denne visningen av {0}-modulen.',

    'ERR_LAYOUT_RENDER_TITLE' => 'Gjengivelse av utseende feilet',
    'ERR_LAYOUT_RENDER_MSG' => 'Oops! Vi klarer ikke å gjengi noenting. Vennligst forsøk igjen senere eller kontakt support.',
    'ERR_INTERNAL_ERR_MSG' => 'Intern feil',
    'ERR_GENERIC_TITLE' => 'Feil',
    'ERR_CONTACT_TECH_SUPPORT' => 'Vennligst kontakt teknisk support.',

    'LBL_SYNCED_RECURRING_MSG' => 'Du kan ikke endre denne oppføringen da den var synkronisert inn fra en ekstern klient.',
    'LBL_EXISTING' => 'Eksisterende',
    'LBL_PANEL_DEFAULT' => 'Standard',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'Dårlig svar fra serveren',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'En feil oppsto under TildelTil-handlingen.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'Du har ikke tilgang til {{name}}. Ta kontakt med din administrator.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'År {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'Flere handlinger',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'Varsel',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'Ignorer duplikater og lagre',
    'LBL_RESTORE' => 'Tilbakestille til opprinnelige',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'Poster merket for sletting',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'Viser poster relatert til en personvernforespørsel til '
        . 'Slett informasjon.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS-strøm',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'Hold deg oppdatert ved å legge til en ekstern RSS- eller bloggstrøm.',
    'LBL_RSS_FEED_URL' => 'Strøm-URL',
    'LBL_RSS_FEED_AUTHOR' => 'Forfatter:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'Antall elementer å vise',
    'LBL_ERR_LOADING_RSS_FEED' => 'Kunne ikke laste RSS mating',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'Mine elementer',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'Team elementer',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'Lar brukere legge til Sugar Apps i et dashbord',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'Historikk',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'Historie dashlet viser møter avholdt, samtaler logget, e-post mottatt og e-poster som er sendt.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'E-postadresse',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'E-poster',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'Min historikk',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'Team historikk',
    'LBL_UNASSIGNED' => 'Ikke tilordnet',
    'LBL_ARCHIVE_EMAIL' => 'Arkivér e-post',
    'LBL_EMAIL_ARCHIVED' => 'E-post arkivert',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'Opprett arkivert e-post',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'Planlagte aktiviteter',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'Planlagte aktiviteter dashlet viser planlagte møter og samtaler.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'I dag',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'Fremtid',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'Mine aktiviteter',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'Team aktiviteter',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'Avholdt',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'Er du sikker på at du vil markere {0} som lukket?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'Aktive oppgaver',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Aktive oppgaver dashlet viser med frist nå, kommende og dagens oppgaver.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'Frist nå',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'Kommende',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'Skal gjøre',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'Fullført',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'Er du sikker på at du vil lukke {0} som fullført?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mine oppgaver',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team oppgaver',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'Det var en ekstra e-post på posten du endrer. Det er nå den primære og er lagt til nedenfor.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'Inaktive oppgaver',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Oppgave dashlet viser utsatt og fullførte oppgaver.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'Utsatt',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'Fullført',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'sist oppdatert {{relativetime}} på {{date}} på {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mine oppgaver',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team oppgaver',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'Mine nylig viste saker',

    'LBL_REPORT_DASHLET_TITLE_12' => 'Åpne saker av bruker etter status',
    'LBL_REPORT_DASHLET_TITLE_125' => 'Nye saker for forretningssenter etter uke',
    'LBL_REPORT_DASHLET_TITLE_126' => 'Nylig opprettede saker',
    'LBL_REPORT_DASHLET_TITLE_127' => 'Nye saker for kundeklasse etter uke',
    'LBL_REPORT_DASHLET_TITLE_128' => 'Åpne saker etter kundeklasse og prioritet',
    'LBL_REPORT_DASHLET_TITLE_129' => 'Antall saker løst denne måneden etter forretningssenter',
    'LBL_REPORT_DASHLET_TITLE_130' => 'Antall saker løst denne måneden etter agent',
    'LBL_REPORT_DASHLET_TITLE_131' => 'Liste over nylig løste saker',
    'LBL_REPORT_DASHLET_TITLE_132' => 'Mine saker løst denne månedene etter uke',
    'LBL_REPORT_DASHLET_TITLE_133' => 'Mine saker som skal inn i dag og som er forsinket',
    'LBL_REPORT_DASHLET_TITLE_134' => 'Alle saker som skal inn i dag og som er forsinket',
    'LBL_REPORT_DASHLET_TITLE_135' => 'Mine åpne saker etter oppfølgingsdato',
    'LBL_REPORT_DASHLET_TITLE_136' => 'Alle åpne saker etter oppfølgingsdato',
    'LBL_REPORT_DASHLET_TITLE_137' => 'Mine åpne saker etter status',
    'LBL_REPORT_DASHLET_TITLE_138' => 'Mine saker siste uke etter status',
    'LBL_REPORT_DASHLET_TITLE_139' => 'Status for åpne oppgaver tilordnet av meg',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP or Old REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron-jobb',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logikkrok',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar-arbeidsflyt',
    'LBL_AUDIT_SUBJECT_USER' => 'Bruker',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web til emne',

    //common chart strings
    'LBL_CHART' => 'Diagram',
    'LBL_CHART_NO_DATA' => 'Ingen data tilgjengelig.',
    'LBL_CHART_LEGEND_CLOSE' => 'Skjul oversikt',
    'LBL_CHART_LEGEND_OPEN' => 'Vis oversikt',
    'LBL_CHART_CONTROLS_CLOSE' => 'Skjul kontrollene',
    'LBL_CHART_CONTROLS_OPEN' => 'Vi kontrollene',
    'LBL_CHART_UNDEFINED' => 'Udefinert',
    'LBL_CHART_NO_LABEL' => 'Udefinert',
    'LBL_CHART_AMOUNT' => 'Beløp',
    'LBL_CHART_COUNT' => 'Tall',
    'LBL_CHART_PERCENT' => 'Prosent',
    'LBL_CHART_GROUP' => 'Gruppe',
    'LBL_CHART_DATE' => 'Dato',
    'LBL_CHART_KEY' => 'Nøkkel',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'Diagramtype',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'Vis tittel',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'Vis total',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Vis x-akseetikett',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Vis y-akseetikett',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'Visningsmetoder for haker',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'Automatisk radbrytning for haker',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'Samle haker',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'Roter haker',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'Verdiplassering for søylediagrammer',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'Visningsalternativer for søylediagrammer',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'Tillatt rulling',
    'LBL_CHART_CONFIG_STACK_DATA' => 'Samle dataserier',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'Skjul tomme grupper',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'sendt',
    'LBL_EMAIL_RECV' => 'mottatt',

    //record save
    'LBL_RECORD_SAVED' => 'Post lagret.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'Du lyktes i å opprette {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a>.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'Du opprettet {{moduleSingularLower}}.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'Du opprettet denne posten, men du har ikke tillatelse til å få tilgang til denne posten.', // use when user has no access to the model
    'LBL_VALIDATING' => 'Godkjenner...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'Suksess:',
    'LBL_ALERT_TITLE_WARNING' => 'Advarsel:',
    'LBL_ALERT_TITLE_NOTICE' => 'Merknad:',
    'LBL_ALERT_TITLE_ERROR' => 'Feil:',
    'LBL_ALERT_TITLE_LOADING' => 'Laster inn',
    'LBL_ALERT_NO_ACCESS' => 'Du har ikke tilgang til filteret brukt på denne dashleten.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'Dupliser dashbordet for å konfigurere denne dashleten med ditt eget filter.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'Din nettleser-versjon støttes ikke lenger, eller du bruker en nettleser som ikke støttes.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'Støttede plattformer',
    'LBL_ALERT_CONFIRM_DELETE' => 'Er du sikker på at du vil slette dette elementet?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'Er du sikker på at du vil slette disse elementene?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'Den valgte posten vil overskrive følgende verdier: {{values}}. Avbryt for å beholde eksisterende verdier. Bekreft for å overskrive med nye verdier.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'De valgte {{moduleSingularLower}} har relaterte verdier: {{values}}. Avbryt for å beholde eksisterende verdier. Bekreft for å overskrive med nye verdier.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'Fra:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'Til:',

    //organization chart
    'LBL_ORG_CHART' => 'Organisasjonskart',
    'LBL_ORG_CHART_DESC' => 'Viser medarbeider-strukturen i organisasjonen.',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'Veksle orientering',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'Vis alle nodes',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'Zoom for å tilpasse',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'Saks sammendrag',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'Viser en oversikt over relaterte saker.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'Oppsummering',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'Lukkede saker',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'Åpne saker',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'Topp 10 Salgs inntektsposter',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'Viser Topp 10 omsetningsposter i et boblediagram.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'Mine omsetningsposter',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "Mitt teams omsetningsposter",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'Standard dato filter',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'Standard datasett',

    'LBL_PRODUCT_CATALOG_NAME' => 'Produktkatalog',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'Produktkatalog',
    'LBL_PRODUCT_CATALOG_DESC' => 'Vis og legg til elementer fra produktkatalogen din.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'Vis og legg til elementer fra produktkatalogen din.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} på {{date}} på {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Skriv et notat eller dra og slippe et vedlegg. Skriv @ for å nevne en bruker. Skriv inn # for å referere til en post.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'Legg inn din kommentar... Skriv inn @ for å nevne en bruker. Skriv inn # for å referere til en post.',
    'LBL_ACTIVITY_STREAM' => 'Aktivitetstrøm',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'Aktivitetstrøm er ikke aktivert',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'Aktivitetstrøm er ikke aktivert for denne modulen',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'Flere poster...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'på',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'Min Aktivitetstrøm',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'Se på liste over aktiviteter utført på poster og opprett og legge inn kommentarer.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'Activity Streams is disabled',

    'LBL_DATA_VIEW' => 'Datavisning',
    'LBL_COMMENT' => 'Kommentar',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'Det oppstod en feil under tilkobling til serveren. Vennligst prøv igjen.',
    'ERR_RESOLVE_ERRORS' => 'Vennligst løs eventuelle feil før du fortsetter.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'For å godkjenne må alle nødvendige felt være fylt inn; men du kan fortsatt avvise eller distribuere denne posten.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'For å avvise/rute må alle obligatoriske felt fylles inn.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'Oppdater liste',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'Oppdater fliser',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'mer',
    'LBL_TEXTAREA_LESS' => 'mindre',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} vedlegg',
    'LBL_CREATE_ATTACHMENT' => 'OPprett vedlegg',
    'LBL_DASHLET_REFRESH' => 'Oppdater',
    'LBL_DASHLET_MOVE' => 'Flytt',
    'LBL_DASHLET_CLOSE' => 'Lukk',

    'LBL_DASHLET_FORECAST_NAME' => 'I prognose',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'Prognose Stolpediagram',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Prognose Stolpediagram',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'Prognose for',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'Viser prognose stolpediagrammet for en bestemt tidsperiode',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'Gruppér etter:',
    'LBL_DASHLET_FORECASTS_DATASET' => 'Datasett',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'Prognose detaljer',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'Viser nåværende prognose detaljer.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'Lagrede rapporters diagram Dashlet',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'Viser hvilken som helst diagram fra en lagret rapport.',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'Publiserte relaterte artikler',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'Sammendrag av historikk',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'Mer historikk...',
    'LBL_RELATED_CONTACT' => 'Relatert kontakt',
    'LBL_MODULE_TYPE' => 'Type',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'E-post til',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'E-post fra',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'Legat moduler kan ikke forhåndsvises',

    //SFA
    'LBL_BEST' => 'Beste',
    'LBL_WORST' => 'Verst',
    'LBL_LIKELY' => 'Sannsynlig',
    'LBL_BEST_FORECAST' => 'Forpliktelse (best)',
    'LBL_WORST_FORECAST' => 'Forpliktelse (verst)',
    'LBL_LIKELY_FORECAST' => 'Forpliktelse (sannsynlig)',
    'LBL_BEST_ADJUSTED' => 'Justert forpliktelse (best)',
    'LBL_WORST_ADJUSTED' => 'Justert forpliktelse (verst)',
    'LBL_LIKELY_ADJUSTED' => 'Justert forpliktelse (sannsynlig)',
    'LBL_AMOUNT_USDOLLAR' => 'Omregnet beløp',
    'LBL_OVERDUE' => 'Forfalt',

    'LBL_PASSWORD_REQUEST_SENT' => 'Din forespørsel er sendt.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'Det oppstod et problem ved å hente brukernavn og e-post kombinasjon.',

    'LBL_REMINDER_TITLE' => 'Påminnelse',
    'LBL_CLICK_TO_DRILLDOWN' => 'Klikk for detaljoversikt',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'Du kan ikke deaktivere alle språk.',

    'LBL_UPDATE_CALC_FIELDS' => 'Omberegne verdier',

    //Optimistic Locking
    'LBL_YOU' => 'Du',
    'LBL_RESOLVE_CONFLICT' => 'Løs konflikt for {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'For mer informasjon, se {{{more_info_url}}} {{plural_module_name}} dokumentasjon. {{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'Ingen data tilgjengelig',
    'LBL_NEED_HELP' => 'Trenger du hjelp med noe nytt?',
    'LBL_NEW_CASE' => 'Ny sak',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'Hjelp dashlet gir spesifikk informasjon knyttet til modulen du ser på i øyeblikket sammen med en link til den tilsvarende dokumentasjon (f.eks Emner-dokumentasjon) i programguiden for mer informasjon.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'Listevisning Hjelp',
    'LBL_HELP_RECORDS' => "En moduls listevisning viser alle poster møter de gjeldende søkekriterier og hvilke brukere som har tilgang. Du kan se på detaljene for hver post innenfor felt kolonnene i listevisning eller klikk postens navn for å åpne postvisningen.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'Postvisning Hjelp',
    'LBL_HELP_RECORD' => 'Denne postvisningen gir grundig informasjon om en individuell post samt noen detaljer av postene den er knyttet til. - Rediger denne postens felt ved å klikke på et enkelt felt eller Rediger-knappen. - Vis eller endre lenker til andre poster i underpanelet ved å veksling nedre venstre rute til "Data View". - Samhandle med brukerkommentarer og vis postendringshistorie ved å veksling nedre venstre rute til "Aktivitetstrøm". - Følg eller favoriser denne posten ved hjelp av ikonene til høyre for postens navn. - Ytterligere tiltak er tilgjengelig i rullegardinmenyen Handlings menyen til høyre for Rediger-knappen.',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}} opprettelse',
    'LBL_HELP_CREATE' => 'For å opprette {{plural_module_name}}: 
1. Legg inn verdier i feltene som ønsket. 
- Felt som er merket "Obligatorisk" må oppdateres før du lagrer. 
- Klikk "Vis mer" for å avsløre flere felt hvis det er nødvendig. 
2. Klikk "Lagre" for å sluttføre den nye posten og gå tilbake til {{plural_module_name}}: listevisning.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'Potensielle duplikater oppdaget',
    'LBL_HELP_DUPLICATE' => 'Sugar har oppdaget at posten du prøver å skape kanskje allerede eksisterer. Hvis du vil endre en eksisterende post i stedet for å lage en ny en, klikker du på "Velg og redigere" til høyre for den aktuelle posten. De tomme feltene på den eksisterende posten vil bli fylt på med de verdiene du nettopp har angitt. Klikk på "Lagre" for å spare disse endringene til den eksisterende posten. Hvis du i stedet ønsker å bruke de verdiene du nettopp har skrevet inn i stedet for verdiene på den eksisterende posten, klikk på "Tilbakestill til original". De verdiene du tastet inn vil da bli brukt til den eksisterende posten, og du kan nå legge til flere endringer og klikk "Lagre" for å sluttføre modifikasjoner på eksisterende posten. For å opprette en ny posten ved å bruke de verdiene du har skrevet inn, klikk på "Ignorer duplikater og Lagre" øverst til høyre på skjermen.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'Manglende SMTP server innstillinger',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'For å sende posttildelings-varslinger, må en SMTP-server konfigureres i {{emailSettingsUrl}}.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'E-post-innstillinger',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'Nye lagerrapporter tilgjengelige',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'Nye lagerraporter er tilgjengelige i din ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'Rapportmodul',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'De er merket som"Stock" og kan filtreres. Rapporter er også merket som "Salg og markedsføring", "Kundeservice", "Personvern" eller "Administrativ" basert på innholdet. Hvis du vil ha mer informasjon, se ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'dokumentasjon',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM gjør det mulig avanserte brukere å raskt utføre visse oppgaver med hurtigtaster for å øke produktiviteten. Tabellene på høyre beskrive tilgjengelige snarveier sammen med nøkler og handlingene de utfører.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>Støttede nøkler</h1> <ul><li>alle alfanumeriske tegn og symboler</li> <li>shift, ctrl, alt, command, mod (ctrl i Windows/Linux og command i Mac)</li> <li>enter, esc, mellomrom, tab, pageup, pagedown, end, home, ins, del, tilbake</li></ul> <h1>Støttede funksjoner</h1> <ul><li>Tastekombinasjon: ctrl+m</li> <li>Flere nøkler: m, ctrl + m</li> <li>Nøkkelsekvens: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'Globale snarveier',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'Kontekstuelle snarveier',
    'LBL_SHORTCUT_KEY_KEY' => 'Nøkkel',
    'LBL_SHORTCUT_FUNCTION' => 'Funksjon',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Konfigurer innholdsrettede snarveier',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'Ingen innholdsrettede snarveier å konfigurere',
    'LBL_SHORTCUT_HELP' => 'Vis snarveiers hjelpeside',
    'LBL_SHORTCUT_QUICK_CREATE' => 'Veksle raskt i opprette menyen',
    'LBL_SHORTCUT_SEARCH' => 'Fokus på global søkefelt',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'Veksle i sidepanelet',
    'LBL_SHORTCUT_CREATE_RECORD' => 'Opprett ny post',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'Velg neste post fra listen',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'Velg forrige post på listen',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'Bla listen til venstre',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'Bla listen til høyre',
    'LBL_SHORTCUT_OPEN' => 'Åpne valgte posten på listen',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'Rediger valgte posten på listen',
    'LBL_SHORTCUT_RECORD_DELETE' => 'Slett posten',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Avslutt ut av listen inline redigeringsmodus uten å lagre',
    'LBL_SHORTCUT_RECORD_SAVE' => 'Lagre posten',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'Rens ut eventuelle endringer i posten',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'Marker posten som favoritt',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'Følg posten',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'Forhåndsvis posten',
    'LBL_SHORTCUT_MARK_SELECTED' => 'Marker posten som valgt',
    'LBL_SHORTCUT_SELECT_ALL' => 'Velg alle',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'Åpne masseaksjon rullegardinmeny',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'Fokus på liste filterfelt',
    'LBL_SHORTCUT_FILTER_CREATE' => 'Opprett et nytt listefilter',
    'LBL_SHORTCUT_FILTER_EDIT' => 'Rediger nåværende listefilter',
    'LBL_SHORTCUT_FILTER_SHOW' => 'Åpne liste filtermenyen',
    'LBL_SHORTCUT_RECORD_EDIT' => 'Rediger posten',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'Åpne forrige post',
    'LBL_SHORTCUT_RECORD_NEXT' => 'Åpne neste post',
    'LBL_SHORTCUT_COPY_RECORD' => 'Kopier nåværende post',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'Åpne primærhandling rullemenyen',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'Lukk skuff',
    'LBL_SHORTCUT_FILTER_ADD' => 'Legg til flere kriterier å filtrere',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'Fjern siste kriterier fra filter',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'Lukk filter',
    'LBL_SHORTCUT_FILTER_SAVE' => 'Lagre filter',
    'LBL_SHORTCUT_FILTER_DELETE' => 'Slett filter',
    'LBL_SHORTCUT_FILTER_RESET' => 'Tilbakestill filter',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'Legg til rad',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'Fjern rad',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'Lukk masse oppdatering',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'Oppdater poster',
    'LBL_CREATE_CATEGORY' => 'Opprett en <div class="btn-link" data-action="create-new">kategori</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'Bekreft:',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'Avbryt',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'Velg alle elementene i et flervalgsfelt',
    'LBL_SHORTCUT_SWEETSPOT' => 'Veksle Sweet Spot-søylen',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'Skjul Sweet Spot-søylen',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'Lagre konfigurasjon',
    'LBL_SHORTCUT_RESTORE' => 'Gjenopprett standard',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'Det oppstod en feil under lagring av egendefinerte hurtigtaster på serveren. Prøv på nytt.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}}-innstillinger',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}}-konfigurasjonsinnstillingene er lagret.',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} konfigurasjonsfeil',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} har ingen konfigurasjonsinnstillinger',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'Brukeren har ikke tilgang til {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'Brukeren har ikke tilgang til å konfigurere innstillingene for {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'Databaseinnstillinger for {{module}} må ordnes',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} – {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} – {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'til',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'Start- og sluttdato',

    'LBL_CALENDAR_START_DATE' => 'Startdato',
    'LBL_CALENDAR_END_DATE' => 'Avslutningsdato',
    'LBL_CALENDAR_DURATION' => 'Varighet',
    'LBL_CALENDAR_RECURRENCE' => 'Gjentakelse',
    'LBL_CALENDAR_REMINDERS' => 'Vis påminnelse?',

    'LBL_CALENDAR_CUSTOM_DATE' => 'Egendefinert dato',
    'LBL_CALENDAR_REPEAT_TYPE' => 'Gjentakelsestype',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'Gjentakelsesintervall',
    'LBL_CALENDAR_REPEAT_DOW' => 'Gjenta på visse ukedager',
    'LBL_CALENDAR_REPEAT_ON' => 'Gjenta den',
    'LBL_CALENDAR_REPEAT' => 'Gjenta',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'Gjenta Til',
    'LBL_CALENDAR_REPEAT_COUNT' => 'Gjentakelsesforekomster',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'Gjenta velger',
    'LBL_CALENDAR_REPEAT_DAYS' => 'Dag(er) i måneden',
    'LBL_CALENDAR_REPEAT_MONTH' => 'Måned(er) i året',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'Gjenta ordenstall',
    'LBL_CALENDAR_REPEAT_UNIT' => 'Gjenta enhet',
    'TPL_REPEAT_INTERVAL' => 'Hver {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'Denne serien bruker et Gjenta den-alternativ som ikke er tilgjengelig i Sugar fordi serien ble synkronisert fra en kalenderklient. Rediger denne serien i kalenderklienten hvis du vil fortsette å gjenta på en bestemt dato. Hvis du redigerer denne serien i Sugar, settes Gjenta den til Ingen.<br><br>Har du lyst til å fortsette?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'Gjentakelsesendringer må gjøres med den første posten i serien.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'Regelmessighetsregler resulterer ikke i generering av en hendelser.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'Deltar',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'Avslått',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'Tentativ',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'Ingen svar',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'Arbeidsplanen er utilgjengelig',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'Tilgjengelige visninger',
    'LBL_CALENDAR_DASHLET_NAME' => 'Kalenderplanlegger',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'Standard visning',
    'LBL_CALENDAR_MY_CALENDARS' => 'Mine kalendre',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'Bruker- og teamkalendre',
    'LBL_CALENDAR' => 'Kalender',

    'LBL_CALENDAR_DAY' => 'dag',
    'LBL_CALENDAR_WEEK' => 'uke',
    'LBL_CALENDAR_MONTH' => 'måned',
    'LBL_CALENDAR_YEAR' => 'år',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => 'Andre',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => 'Tredje',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => 'Fjerde',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => 'Femte',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => 'Sjette',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => 'Syvende',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => 'Åttende',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => 'Niende',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => 'Tiende',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => 'Ellevte',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => 'Tolvte',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => 'Trettende',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99.',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'En feil oppsto ved henting av arbeidsplanen.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'Lagre og send invitasjoner',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'Godta status',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'Prosesser',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'Prosesser-dashleten viser malene som kan brukes i SugarBPM.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'Prosessdefinisjoner',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'Prosessdefinisjoner-dashleten viser malene som kan brukes i SugarBPM.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'Opprett prosessdefinisjon',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'Importer prosessdefinisjoner',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'Prosess forretning regel',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'Prosessforretningsregler-dashleten viser malene som kan brukes i SugarBPM.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'Opprett bedriftsregelprosess',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'Importer bedriftsregelprosesser',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'E-postmalprosess',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'Prosess-e-postmaler-dashleten viser malene som kan brukes i SugarBPM.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'Opprett e-postmalprosess',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'Importer e-postmalprosess',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'Når du utvikler maler for prosesser/bedriftsregler/e-post i en annen Sugar-instans, anbefaler vi på det sterkeste at instansen er en nøyaktig klone av produksjonssystemet ditt. Maler for prosesser/bedriftsregler/e-post som er bygd i en uavhengig Sugar-instans fungerer kanskje ikke som ønsket etter importeringen er fullført. Maler for prosesser/bedriftsregler/e-post kan lite på bestemte studio- eller programnivåendringer inkludert, men ikke begrenset til, tilpassede feltnavn, rullegardinverdier, database-ID-er osv. Hvis disse verdiene ikke er identiske fra instansen hvor malen for prosesser/bedriftsregler/e-post ble bygd, må du kanskje måtte manuelt oppbygge malen for prosesser/bedriftsregler/e-post i målinstansen.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'Vil du fortsette med denne importeringen?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'Vil du fortsette med denne eksporteringen?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'De følgende rullegardinfeltene inneholder ugyldige alternativer',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'Pågående aktiviteter etter prosess',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'Pågående aktiviteter',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'Pågående aktiviteter etter prosess',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'Alle prosesser',
    'LBL_RECORD_DASHBOARD' => 'Registerdashbord',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'Sammendrag av prosesstatus',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'Beskrivelse av prosesstatus',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'Under utførelse',
    'LBL_PMSE_COMPLETED_STATUS' => 'Fullført',
    'LBL_PMSE_CANCELLED_STATUS' => 'Kansellert',
    'LBL_PMSE_TERMINATED_STATUS' => 'Avsluttet',
    'LBL_PMSE_ERROR_STATUS' => 'Feil',
    'LBL_PMSE_SETTINGS' => 'SugarBPM-innstillinger',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'Er du sikker på at du vil deaktivere denne posten?',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'Er du sikker på at du vil aktivere denne posten?',
    'LBL_PRO_DELETE_CONFIRMATION' => 'Er du sikker på at du vil slette denne registreringen?',

    'LBL_PRO_ENABLE' => 'Oppdaterer',
    'LBL_PRO_DISABLE' => 'Oppdaterer',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} deltar i en prosess, og kan inneholde noen låste felt. For å redigere posten, klikker du her {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'Dette feltet er låst fordi det er involvert i en prosess som kjører.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'Denne posten deltar i en prosess, og kan inneholde noen låste felt.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'Forretningssenter',
    'LBL_BUSINESS_CENTER_ID' => 'Forretningssenter-ID',
    'LBL_BUSINESS_CENTER_NAME' => 'Navn på forretningssenter',

    'LBL_PLIS_ACTIVITIES' => 'Kjøpte varelinjeaktiviteter',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(Ny tag)',
    'LBL_TAG_FETCH_ERROR' => 'En feil oppsto under henting av tags.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'Sugar 7 krever Javascript. Aktiver Javascript i nettleseren for å bruke Sugar 7.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'Serieomkodet data kunne ikke avserieomkodes',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'Serieomkodet data kunne avserieomkodes fordi den inneholder referanser til objekter eller klasser',

    'LBL_FIELD_TRIMMED' => 'Feltet ble kuttet fordi det overskred grensen for maksimale tegn.',
    'LBL_FIELDSIZE_OVERFLOW' => 'Feltet overskrider grensen for maksimalt antall tegn.',
    'LBL_TINYMCE_TARGET_SAME' => 'Samme vindu',
    'LBL_TINYMCE_TARGET_NEW' => 'Nytt vindu',

    'LBL_OUTBOUND_EMAILS' => 'E-post-innstillinger',
    'LBL_OUTBOUND_EMAIL' => 'E-post-innstilling',

    'LBL_EMAIL_PARTICIPANTS' => 'E-postdeltakere',
    'LBL_EMAIL_PARTICIPANT' => 'E-postdeltaker',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'Personvern for data',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'Personvern for data',
    'LBL_DATAPRIVACY_VIEW_PII' => 'Vis personlig informasjon',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'Merk for å slette',
    'LBL_DATAPRIVACY_FIELDNAME' => 'Felt',
    'LBL_DATAPRIVACY_VALUE' => 'Verdi',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'Endret av',
    'LBL_DATAPRIVACY_SOURCE' => 'Kilde',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'Sist oppdatert',
    'LBL_DATAPRIVACY_PII' => 'Personlig informasjon',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'Merk for å slette',
    'TPL_DATAPRIVACY_PII_TITLE' => 'Personlig informasjon for {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'Endre timere',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'Meldinger',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'Kopiert til utklippstavlen!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'Kunne ikke kopiere til utklippstavlen',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'Kopier bekreftelseskobling',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'Tidslinje',
    'LBL_NO_ACTIVITY' => 'Ingen aktivitet',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} Tidslinje',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'Mer',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'Mindre',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'Tidslinje viser den gjeldende postens relaterte oppføringer og velger feltoppdateringer over tid.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'Vis mer ...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'Vis mindre ...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'Ingen data tilgjengelig',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'Modulen er ikke lisensiert.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'Aktive abonnement',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'Denne dashleten kan kun legges til for moduler som lenker til en enkelt konto. Se <a href={{linkToDocumentation}}>Aktive abonnement-dashlet</a> dokumentasjonen for mer informasjon.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'Vis kjøp som tilhører denne tilknyttede kontoen:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'Aktive abonnement for en spesifikk konto.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', antall {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'Total:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'Ingen aktive abonnement',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'Denne dashleten krever {{module_name}} for å fungere. Snakk med administratoren din om å aktivere {{module_name}}.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'Kjøpshistorikk',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'Alle kjøp for en spesifikk konto.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'Denne dashleten kan kun legges til for moduler som lenker til en enkelt konto. Se <a href={{linkToDocumentation}}>Kjøpshistorikk-dashlet</a> dokumentasjonen for mer informasjon.',
    'LBL_NO_PURCHASE_HISTORY' => 'Ingen kjøp å vise',
    'LBL_NO_PLIS' => 'Ingen kjøpte varelinjer',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'Totalt',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'Antall',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'Denne dashleten krever kjøp og kjøpte varelinjer for å fungere. Snakk med administratoren din om å aktivere kjøp og kjøpte varelinjer.',
    'LBL_SEARCH_PURCHASE_NAME' => 'Søk etter kjøpsnavn ...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'Bruk Studio for å redigere visningslayout ved å gå til ' .
        'Studio > {{module}} > Layouts > Registrer dahsletvisning. <a href={{linkToStudio}}>Rediger i Studio</a>.',
    'LBL_SERVICE_LEVEL' => 'Servicenivå',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'Nummer',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'Oppfølging',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'Prioritet/status',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'Emne/beskrivelse',

//Service Duration
    'LBL_SERVICE_DURATION' => 'Servicevarighet',
    'LBL_SERVICE_DURATION_VALUE' => 'Servicevarighetsverdi',
    'LBL_SERVICE_DURATION_UNIT' => 'Servicevarighetsenhet',
    'LBL_LOCK_DURATION' => 'Låsvarighet',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Amazon Connect CCP kunne ikke laste. Sørg for' .
        'at du bruker en ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">støttet nettleser</a>. ' .
        'Hvis problemet vedvarer, kontakt din Sugar-administrator.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Din Sugar-administrator har ikke konfigurert din hendelse for Amazon Connect.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Kan ikke etablere forbindelse med Amazon Connect. Kontakt din Sugar-administrator for assistanse.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'Ukjent',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'Fokusskuff',
    'LBL_CLOSE_FOCUS_DRAWER' => 'Lukk fokusskuffe',
    'LBL_EXTERNAL_GUESTS' => 'Eksterne gjester',
    'LBL_MY_FAVORITE_TASKS' => 'Mine favorittoppgaver',
    'LBL_RECORD' => 'Oppføring',

    'LBL_MY_TASKS' => 'Mine oppgaver',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'Kunne ikke finne felt: {0} i modul: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'Kunne ikke finne register med {0}: {1} i modul: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'Kunne ikke finne en relasjon med navn: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'En databaseoppføring av id: {0}, med {1}: {2} i modul: {3} eksisterer allerede',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'myk slettet (med slettet flagg = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'Fant flere databaseregistre for {0} {1} på modul {2}. ' .
        'Fjern eller oppdater matchende registre deretter. Matchende registre: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'Neste kjøring',
    'LBL_TIME_AWARE_TYPE' => 'Type',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean-ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'Vis etikett',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'Åpne innleggvisning',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'Legg til',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'Hjelp ikke tilgjengelig',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'Funksjoner',
    'LBL_ACTIONBUTTON_FIELDS' => 'Felt',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'Velg felt...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Rollup',
    'LBL_ACTIONBUTTON_RELATED' => 'Relatert',
    'LBL_ACTIONBUTTON_SAVE' => 'Lagre',
    'LBL_ACTIONBUTTON_CANCEL' => 'Avbryt',
    'LBL_ACTIONBUTTON_R_MODULE' => 'Relatert modul',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'Relaterte felt',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'Rollup modul',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'Rollup felt',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'Rollup funksjon',
    'LBL_ACTIONBUTTON_MINIMUM' => 'Min',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'Maks',
    'LBL_ACTIONBUTTON_AVERAGE' => 'Gjennomsnitt',
    'LBL_ACTIONBUTTON_SUM' => 'Sum',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'Tildel innlegg',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'Skriv e-post',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'Opprett innlegg',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Dokumentfletting',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'Åpne URL',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'Begynn rapport',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'Oppdater innlegg',
    'LBL_ACTIONBUTTON_ACTION' => 'Handling',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'Tildel til',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'Send e-post til',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'Bruk PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'Mal',
    'LBL_ACTIONBUTTON_MODULE' => 'Modul',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'Skjerminnstillinger',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'Type',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'Nedtrekksmeny',
    'LBL_ACTIONBUTTON_BUTTON' => 'Knapp',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'Knappgruppe',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'Vis etikett på oppføring',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'Vis i overskrift',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'Skjul på Rediger',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'Vis på toppteksten på dashbordet for fokus',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'Instrumentpanel',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'Topptekst for dashbord for fokus',
    'LBL_ACTIONBUTTON_SIZE' => 'Størrelse',
    'LBL_ACTIONBUTTON_DEFAULT' => 'Vanlig',
    'LBL_ACTIONBUTTON_SMALL' => 'Liten',
    'LBL_ACTIONBUTTON_LARGE' => 'Stor',
    'LBL_ACTIONBUTTON_CALCULATED' => 'Regnet ut',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'Konverter til PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Dokumentfletting',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'Forhåndsvisning',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'Egenskaper',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'Etikett',
    'LBL_ACTIONBUTTON_DESC' => 'Tooltip',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'Vis etikett',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'Vis ikon',
    'LBL_ACTIONBUTTON_SCHEME' => 'Fargevalg',
    'LBL_ACTIONBUTTON_ICON' => 'Ikon',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'Avhengig',
    'LBL_ACTIONBUTTON_DESIGN' => 'Oppsettkonfigurasjon',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'Stopp ved feil',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'Automatisk lagring',
    'LBL_ACTIONBUTTON_CONFIG' => 'Konfigurasjon',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'Vennligst konfigurer Action-knappen før du lagrer.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'Konfigurer knapper',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'Opprett automatisk',
    'LBL_ACTIONBUTTON_LINK' => 'Opprett relasjon til overordnet',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'Kopier parent-verdier',
    'LBL_ACTIONBUTTON_PRESET' => 'Angi feltverdi(er)',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'Kopier feltverdi(er) fra overordnet',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'Velg...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'Fra parent-felt ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'Er du sikker på at du vil slette denne knappen?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'Er du sikker på at du vil slette denne handlingen?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'Ugyldige handlingsknappdata',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'Velg en modul før du lagrer.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'Velg en link før du lagrer. Hvis ingen link er tilgjengelig, fjerner du merket for koblingsalternativet.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'Velg et innlegg før du lagrer.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'Velg en mal før du lagrer.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'Primær',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'Sekundær',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'Havblå',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'Pink',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'Militær',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'Blågrønn',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'Stillehavet',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'Grønn',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'Gul',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'Oransje',
    'LBL_ACTIONBUTTON_THEME_RED' => 'Rød',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'Korall',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'Lilla',
    'LBL_ACTIONBUTTON_FORMULA' => 'Formel',
    'LBL_ACTIONBUTTON_ACTIONS' => 'Handlinger',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'Det oppsto feil ved validering av knappdata.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'Knappene må ha minst en etikett eller et ikon.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'Vennligst skriv inn en gyldig knappetikett.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'Oppføringen kunne ikke opprettes på grunn av manglende nødvendige verdier. Kontakt administratoren din.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'Du må ha minst to aktive knapper for denne knappetypen.',
    'LBL_ACTIONBUTTON_RECORD' => 'Oppføringsvisninger',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'Handlingsmenyer',
    'LBL_ACTIONBUTTON_ORDER' => 'Ordre',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'Listevisning',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'Postvisning topptekst',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'Registervisning topptekst',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'Underpaneler',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'Oppgavesekvensutførelsesmotoren kunne ikke utføre følgende handlinger: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'Legg til en handling',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'Fjern denne handlingen',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'Gjeldende bruker',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'Dokumentfletting',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'Dokumentfletting til PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'Firmastørrelse',
    'LBL_HINT_COMPANY_INDUSTRY' => 'Bransje',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'Bransjeetiketter',
    'LBL_HINT_COMPANY_LOCATION' => 'Firmasete',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'Firmabeskrivelse',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'År grunnlagt',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Firma Facebook',
    'LBL_HINT_COMPANY_TWITTER' => 'Firma Twitter',
    'LBL_HINT_COMPANY_PIC' => 'Firma logo',
    'LBL_HINT_CONTACT_PIC' => 'Kontaktbilde',
    'LBL_HINT_COMPANY_WEBSITE' => 'Firmanettsted',
    'LBL_HINT_PHOTO' => 'Fotolenke',
    'LBL_HINT_JOB_2' => 'Tidligere jobber',
    'LBL_HINT_EDUCATION' => 'Utdanning',
    'LBL_HINT_EDUCATION_2' => 'Ytterligere utdanning',
    'LBL_HINT_TWITTER' => 'Twitter lenke',
    'LBL_HINT_FACEBOOK' => 'Facebook lenke',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS-kode',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'Bransjekode',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'FY ende',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'Årlig omsetning',
    'LBL_HINT_PHONE_1' => 'Telefon 1',
    'LBL_HINT_PHONE_2' => 'Telefon 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'Forbind tabell',
    'LBL_HINT_FULL_NAME' => 'Fullt navn',
    'LBL_HINT_JOB_TITLE' => 'Jobbtittel',
    'LBL_HINT_OFFICE_PHONE' => 'Telefonnummer til kontor',
    'LBL_HINT_MOBILE_PHONE' => 'Mobil',
    'LBL_HINT_OTHER_PHONE' => 'Andre telefonnumre',
    'LBL_HINT_WEBSITE' => 'Nettsted',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'Vil du overskrive alle eksisterende data for denne posten med de nye dataene som finnes i Sugar Hint?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'Vil du overskrive den eksisterende {{fieldName}} for denne posten med nye {{fieldName}} som finnes i Sugar Hint?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'Alle kontorelaterte data vil bli fjernet. Er du sikker på at du vil fortsette?',
    'LBL_HINT_COMPANY_LOGO' => 'Logo',
    'LBL_HINT_CONTACTS_AVATAR' => 'Foto',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint Kontosettetiketter',

    'LBL_HINT_LOADING' => 'Laster ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Avinnstallerer Sugar Hint, vent litt',
    'LBL_HINT_VALUE_ERASED' => ' Verdi slettet ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'Denne informasjonen ble slettet via forespørsel om personvern',

    'LBL_HINT_UNINSTALL_TITLE' => 'Velg et av alternativene for deinstallering nedenfor:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Deinstaller kun hintpakken',
    'LBL_HINT_UNINSTALL_FULL' => 'Deinstaller hint fullstendig',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'Dette alternativet vil fjerne hint MLP og deaktivere alle aktive abonnementer på Sugar Hint Insights.
     Å installere Hint på nytt vil automatisk reaktivere abonnementer.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'Dette alternativet vil foreta en fullstendig deinstallasjon av hint, inkludert fjerning av MLP og sletting all informasjon om konfigurasjon og abonnementer.',
    'LBL_HINT_UNINSTALL' => 'Avinstaller',
    'LBL_HINT_UNINSTALL_HEADER' => 'Avinnstaller Sugar Hint',
    'LBL_HINT_CANCEL' => 'Avbryt',
    'LBL_HINT_UNINSTALL_WARNING1' => 'ADVARSEL: Velg dette alternativet kun dersom du ikke ønsker å bruke Hint igjen i fremtiden.
    Foreta en fullstendig sikkerhetskopiering av din Sugar-database og sett Sugar i vedlikeholdsmodus før du foretar deinstallasjon. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'Se ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Administrasjonsguide for Sugar Hint ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'for informasjon om deinstallasjonsprosessen.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Er du sikker på at du vil avinstallere kun Sugar Hint-pakken?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Er du sikker på at du vil avinstallere Sugar Hint helt?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(MERK: DU KAN IKKE OMGJØRE DENNE HANDLINGEN)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint-felter',
    'LBL_HINT_NO_RESULTS_MSG' => 'Ingen resultater funnet.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'Grunnleggende hint-panellayout',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'Kontoer',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'Kontakter',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'Emner',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'Utvidet hint-panellayout',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'Omarbeid feltene ved å dra og slippe disse i avsnittene i hint-panellayouten ovenfor.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'For detaljerte instruksjoner og en liste over standard felt, se ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' for å gjenopprette standardinnstillingene for ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'modulen.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'Er du sikker på at du vil gjenopprette standardverdiene for {{module}} modulen?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'Klikk her',
    'LBL_HINT_CONFIG_NAME' => 'Hint administrasjonsveiledning.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'Felt',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'Utvidede felt',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'Dette avsnittet angir alle Hint-felt og Sugar-felt som utfylles av Hint. Hint-felt er merket med en asterisk (*) og kan bare vises i Hint-panelet dersom de er utfylt.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'Feltnavn',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'Utfyll felt',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Vis i Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Vis i Hint-panel',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'Ytterligere Sugar-felt',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'Dette avsnittet angir alle Sugar-felt som ikke er utfylt med Hint.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'Advarsel',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'Forsiktig: Du er i ferd med å synkronisere med Sugar Hint Insights-tjenesten. Eventuelle ventende e-postsammendrag-historier vil gå tapt, og eksisterende nyheter vil bli fjernet fra Insights-kontrollpanelet. Varsler av alle typer gjenopptas etter at synkroniseringen er fullført.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'Foreslåtte selskaper tilknyttet din {{_moduleSingular}} er oppført nedenfor. Angi firmainformasjon for visning.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'Ingen konto er valgt',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'Flere e-poster funnet, velg e-poster for import: ',

    'LBL_HINT_HELP_MESSAGE1' => 'Basert på dataene som ble lagt inn, klarte ikke Hint å finne treff i systemet.',
    'LBL_HINT_HELP_MESSAGE2' => 'De beste resultatene i Hint finner du med en persons navn og e-postadresse.',
    'LBL_HINT_HELP_MESSAGE3' => 'De beste resultatene i Hint kan finnes med selskapets nettstedsurl.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "Skriv inn firmanavnet eller nettstedet til {{_moduleSingular}}, og Hint vil søke etter ytterligere data.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "Skriv inn e-postadressen til {{currentModule}} og hint vil søke etter ytterligere data.",

    'LBL_HINT_HISTORY_NONE' => 'Ingen tilgjengelige data for historisk visning',
    'LBL_HINT_HISTORY_TITLE' => 'Aktivitetslogg',

    'LBL_HINT_PREVIEW_TITLE' => 'Datautfyllelse',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Lisensen for Hint-tjenesten din har utløpt. Kontakt SugarCRM-administratoren din for å fornye lisensen.',
    'LBL_HINT_PREVIEW_QUESTION' => 'Vil du se hva Hint kan gjøre for deg og din bedrift? Kontakt SugarCRM-administratoren din for å legge til Hint.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'Finner ikke kontoinformasjon',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'Utfylte data funnet - klikk for å lagre alle utfylte data til din oppføring.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'Klikk for å lagre utfylte data til din oppføring.',

    'LBL_HINT_CONTACTS_TITLE' => 'Tilknyttede kontakter',
    'LBL_HINT_CONTACTS_NONE' => 'Ingen tilknyttede kontakter',

    'LBL_HINT_NEWS' => 'Nyheter',
    'LBL_HINT_GENERAL' => 'Generelt',
    'LBL_HINT_ALL_NEWS' => 'Alle nyheter',
    'LBL_HINT_FILTER_NEWS' => 'Filtrere nyheter',
    'LBL_HINT_FINANCIAL_NEWS' => 'Økonomi',
    'LBL_HINT_PERSONNEL_NEWS' => 'Personell',
    'LBL_HINT_PRESS_RELEASES' => 'Pressemeldinger',
    'LBL_HINT_OTHER_NEWS' => 'Annet',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'Søk i nyhetsartikler',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'Ingen tilgjengelige nyheter',
    'LBL_NEW_NOTIFICATIONS' => 'Nye varsler',
    'LBL_HINT_DASHLET_ALLOWED1' => 'Du må ha en Sugar Hint-lisens for å se Sugar Hint Insights-oversikten.
     Spør administratoren din om å få en Sugar Hint-lisens.',

    'LBL_HINT_FOR' => 'For',
    'LBL_HINT_WITH' => 'med',
    'LBL_HINT_SHOW_ME' => 'Vis meg: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'Varsle meg innen: ',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insights preferansesenter',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'Nøkkel for preferansealternativer',
    'LBL_HINT_PREFERENCES' => 'Preferanser',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'Slett deaktiverte, minst en preferanseerklæring påkrevd',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'Legg til deaktivert, du har nådd maksimumsantallet for preferanseerklæringer',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Ta med i kontrollpanelet for Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'Sprettoppvindu som skrivebordvarsel',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'Varsler må være aktivert på alle nettlesere og på alle stasjonære PCer for å motta varsler forskriftsmessig.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Enkelte nettlesere, som Internet Explorer, støtter ikke varsler. Varsler kan ikke aktiveres ved bruk av en nettleser som ikke støtter varsler.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'Send umiddelbar e-postmelding for hvert varsel',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'Send en daglig e-postoversikt',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'Send en ukentlig e-postoversikt',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'Preferanser kunne ikke lagres. Sjekk systemforbindelsen din og prøv igjen.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'Enkelte påkrevde felt mangler en verdi. Sjekk preferansene dine og påse at alle påkrevde felt er utfylt.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'Du er i ferd med å aktivere nettleservarsler for Sugar Hint Insights. Klikk på Bekreft for å fortsette. Nettleseren din vil da be deg om tillatelse for å motta varslingshendelser.',
    'LBL_HINT_PUSH_ERROR' => 'Programvareutvidelsen for pushvarsler er registrert for {{options.type}} uten avhengighet. Programvareutvidelsen vil ikke fungere som tiltenkt, så påse at du tilbyr en bane til arbeidsfilen og en metode for lagring av abonnementet på serveren.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'Slå PÅ hintvarsler for alle brukere',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'Slå AV hintvarsler for alle brukere',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'ADVARSEL: Kunne ikke deaktivere varsler under avinstallering av Sugar Hint. For å deaktivere varsler, installer Sugar Hint 5.4.0 eller nyere og utfør en fullstendig avinstallering ved å bruke Sugar Hint Uninstaller som finnes i administrasjonsdelen av Sugar.',
    'LBL_HINT_ENRICH_ALL' => 'Berik alle',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'Hintlisens påkrevd',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'Kartkonfigurasjon',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'Geokoder loggvisning',
    'LBL_MAP_MAP' => 'Kart',
    'LBL_MAP_MAPS' => 'Kart',
    'LBL_MAP_GEOCODING_RECORD' => 'Geokoding',
    'LBL_MAP_GEOCODE_SUCCESS' => 'Vellykket geokoding av oppføring.',
    'LBL_MAP_LATITUDE' => 'Breddegrad',
    'LBL_MAP_LONGITUDE' => 'Lengdegrad',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'Søk etter adresse...',
    'LBL_MAP_ALREADY_GEOCODED' => 'Aktuell oppføring har allerede geokoding. Er du sikker på at du vil overskrive geokoding for denne oppføringen?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'Manuell geokoding',
    'LBL_MAP_POINT_COORDINATES' => 'Kartpunktkoordinater',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'Beregner optimal rute...',
    'LBL_MAP_DIRECTIONS' => 'Retningslinjer',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'Retningslinjer med start fra aktuell bruker',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'Retningslinjer med start fra denne oppføringen',
    'LBL_MAPS_RADIUS_INPUT' => 'Radius (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'innenfor en radius fra postnummer',
    'LBL_MAPS_DISTANCE' => 'Avstand',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'Postnummer',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'Ugyldig konfigurasjon: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> feltkartlegginger er ugyldig.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'Karttype',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'Zoomnivå',
    'LBL_MAPS_DASHLET' => 'Kart',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'Viser oppføring(er) med geokoding på kart.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'Kart er ikke tilgjengelig for denne modulen. Aktiver dette i administratorkonsollen.',
    'LBL_MAP_MODULES' => 'Modul',
    'LBL_MAP_FILTER_BY' => 'Filtrer etter',
    'LBL_MAP_UNIT_TYPE' => 'Enhetstype',
    'LBL_MAP_UNIT_TYPE_MILES' => 'Mil',
    'LBL_MAP_UNIT_TYPE_KM' => 'Kilometer',
    'LBL_MAP_ADDRESS' => 'Adresse',
    'LBL_MAP_NO_STARTING_POINT' => 'Startpunkt har ingen geokoding.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'Startpunktoppføring er uten geokoding.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'Enkelte utvalgte oppføringer er uten geokoding og vises ikke på kartet.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'Oppføring(er) er uten geokoding.',
    'LBL_MAPS_MODULE_FIELDS' => 'Modul felt',
    'LBL_MAPS_SELECT_FIELD' => 'Velg felt',
    'LBL_MAPS_RELATE_RECORD' => 'Tilknyttet oppføring',
    'LBL_MAPS_MAPPING_TYPE' => 'Kartleggingstype',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'Ingen oppføringer med geokoding',
    'LBL_MAPS_ADDRESS' => 'Adresse',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'Tildelt bruker',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'Gatesidevisning er ikke tilgjengelig for gitt punkt',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> oppføringer er ikke gyldige for kartlegging. Fjern modulen fra listen.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'Lukk',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'Utvid',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'Lagre som PDF',
    'LBL_MAPS_EMAIL_LINK' => 'E-postlenke',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'Du må ha minst en oppføring med geokoding.',
    'LBL_MAPS_GENERATING' => 'Genererer kart...',
    'LBL_MAPS_POINTS' => 'Kartpunkter',
    'LBL_MAPS_POINT' => 'Punkt',
    'LBL_MAPS_TRAVEL_DETAILS' => 'Reiseinformasjon',
    'LBL_MAPS_TOTAL_DISTANCE' => 'Samlet avstand',
    'LBL_MAPS_TOTAL_DURATION' => 'Samlet varighet',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'Samlet varighet uten trafikk',
    'LBL_MAPS_ITINERARY' => 'Veibeskrivelse',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'Kjørestrekning',
    'LBL_MAPS_TRAVEL_DURATION' => 'Reisevarighet',
    'LBL_MAPS_TRAVEL_STEPS' => 'Trinn',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'Advarsler',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Maps støtter maksimum 10 posisjonspunkter på et delt kart. Gjennomgå ditt utvalg.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'Kartlisens påkrevd',
    'LBL_MAPS_SHARE_HELLO' => 'Hei,',
    'LBL_MAPS_SHARE_HEADER' => 'Du har bedt om et Bing-kart for følgende punkter:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'Følgende URL vil åpne et kart som inneholder punktene ovenfor på Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Vis kartet i Bing Maps',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'Ingen rute ble funnet for veipunktene som er oppgitt.',
    'LBL_MAPS_GEOCODE_STATUS' => 'Geokodestatus',
    'LBL_MAPS_GEOCODED' => 'Geokodet',
    'LBL_MAPS_NOT_GEOCODED' => 'Ikke geokodet',
    'LBL_MAPS_NOT_FOUND' => 'Ugyldig adresse',
    'LBL_MAPS_GEOCODING_FAILED' => 'Geokoding mislyktes',
    'LBL_MAPS_QUEUED' => 'I kø',
    'LBL_MAPS_REQUEUED' => 'Satt tilbake i køen',
    'LBL_MAPS_RELATED_RECORD' => 'Tilknyttet oppføring',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'Vis rapport',
    'LBL_REPORT_DASHLET_DESC' => 'Vis en lagret rappport',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'Tilbakestill til Dashlet-standarder',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'Tilbakestill til rapportstandarder',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'Oppdater rapportresultater',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'Kopier diagram til utklippstavle',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'Last ned diagram',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'Rapporten for dashlet- {{label}} ble redigert, og dashleten er tilbakestilt til standard konfigurasjon.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'Du har ikke tillatelse til å bruke dette feltet.',

    'LBL_INVALID_FORMULA' => 'Ugyldig formel',
    'LBL_RETURN_TYPE_MISSMATCH' => 'Funksjonens returtype samsvarer ikke',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'Prognose',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'Optimal kundeprofil',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'Lukk ukeprediksjonspoeng',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'Prediksjonsverdi',
    'LBL_AI_CONV_BIN_ACCURACY' => 'Prediksjonsbin nøyaktighet',
    'LBL_AI_CONV_MULTIPLIER' => 'Prediksjonsmultiplikator',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP-verdi',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP Bin-nøyaktighet',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP-multiplikator',
    'LBL_AI_NEW' => 'Ny',
    'LBL_AI_ENTERED' => 'Angitt',
    'LBL_AI_CREATED' => 'Opprettet',
    'LBL_AI_WEEK' => 'Uke',
    'LBL_AI_MONTH' => 'Måned',
    'LBL_AI_QUARTER' => 'Kvartal',
    'LBL_AI_BYWEEK' => 'etter uke',
    'LBL_AI_BYMONTH' => 'etter måned',
    'LBL_AI_BYQUARTER' => 'etter kvartal',
    'LBL_AI_WEEKTREND' => 'Ukentlig trend',
    'LBL_AI_MONTHLYTREND' => 'Månedlig trend',
    'LBL_AI_QUARTERTREND' => 'Kvartalstrend',
    'LBL_AI_TREND' => 'Trend etter',
    'LBL_AI_TRENDS' => 'Trender etter',
    'LBL_AI_VELOCITY' => 'Hastighet',
    'LBL_AI_TOPX' => 'Topp {X}',
    'LBL_AI_TIMESPAN' => 'Tidsintervall mellom faser -',
    'LBL_AI_BUSINESSTREND' => 'med forretningstrender',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Vi introduserer Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights benytter kvantitativ analyse for å generere ny innsikt i SugarCRM-dataene dine. Hos Sugar er vi alltid på utkikk etter nye måter å hjelpe deg med å få mest mulig ut av dataene dine, ta informerte beslutninger, og dette er bare begynnelsen på det vi håper å tilby med Sugar Insights.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights benytter kvantitativ analyse for å generere ny innsikt i SugarCRM-dataene dine.',
    'LBL_AI_FIRMO' => 'Firmografikk',
    'LBL_AI_TOTALCOUNT' => 'Totalt antall',
    'LBL_AI_DAYSFROMLATESTACT' => 'Dager siden siste',
    'LBL_AI_DAYSSINCE' => 'alder',
    'LBL_AI_FIELDISSET' => 'eksisterer',
    'LBL_AI_CONTACTCOMPLETENESS' => 'Fullstendighet av kontaktinformasjon',
    'LBL_AI_CUTDATE' => 'Prediksjonsperiode',
    'LBL_AI_FROMLASTCHANGE' => 'Dager fra siste funksjonsverdiendring',
    'LBL_AI_CALLSHELD' => 'Totalt antall samtaler avholdt',
    'LBL_AI_CALLSPLANNED' => 'Totalt antall samtaler planlagt',
    'LBL_AI_OUTBOUNDCALLS' => 'Totalt antall utgående samtaler',
    'LBL_AI_INBOUNDCALLS' => 'Totalt antall innkommende samtaler',
    'LBL_AI_AVGCALLDURATION' => 'Gjennomsnittlig varighet av samtaler',
    'LBL_AI_EMAILSARCHIVED' => 'Totalt antall arkiverte e-poster',
    'LBL_AI_EMAILSREAD' => 'Totalt antall leste e-poster',
    'LBL_AI_EMAILSSENT' => 'Totalt antall sendte e-poster',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'Totalt antall poster der forventet lukkingsdato endres til en senere dato',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'Totalt antall poster der forventet lukkingsdato endres til en tidligere dato',
    'LBL_AI_AMOUNTINCREASED' => 'Totalt antall muligheter der beløpet økte',
    'LBL_AI_AMOUNTDECREASED' => 'Totalt antall muligheter der beløpet ble redusert',

    // User last state
    'LBL_LAST_STATE' => 'Siste tilstand',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'Send til DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'Avbryt redigering av mottaker',
    'LBL_RECIPIENT_ROLE' => 'Mottakerens rolle',
    // Base sales stages
    'LBL_OPEN' => 'Åpen',
    'LBL_CLOSED_WON' => 'Lukket Vunnet',
    'LBL_CLOSED_LOST' => 'Lukket Mistet',
    'LBL_KIOSK_ADD_FILES' => 'Legg til filer',
    'LBL_KIOSK_ADD_DROP_FILES' => 'Legg til eller slipp filer her',
    'LBL_KIOSK_CANCEL' => 'Avbryt',
    'LBL_KIOSK_EDIT' => 'Rediger',
    'LBL_KIOSK_EMAIL' => 'E-post',
    'LBL_KIOSK_FILES_UPLOADING' => 'Laster opp',
    'LBL_KIOSK_FILES_ERROR' => 'Vedlegg mislyktes i å laste opp',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'Vedlegg er for stort',
    'LBL_KIOSK_FILTER_SEARCH' => 'Søk',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'Kiosk',
    'LBL_KIOSK_LANGUAGE' => 'Språk',
    'LBL_KIOSK_LAST_UPDATED' => 'Sist oppdatert',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'Vis',
    'LBL_KIOSK_MENU' => 'Meny',
    'LBL_KIOSK_MOBILE_PHONE' => 'Mobiltelefon',
    'LBL_KIOSK_MY_ACTIVITIES' => 'Mine aktiviteter',
    'LBL_KIOSK_MY_PROFILE' => 'Min profil',
    'LBL_KIOSK_NAME' => 'Navn',
    'LBL_KIOSK_OFFICE_PHONE' => 'Telefonnummer til kontor',
    'LBL_KIOSK_ORGANIZATION' => 'Organisasjon',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'Rader per side:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'Utviklet av SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'Lagre endringer',
    'LBL_KIOSK_SHOW_HIDE' => 'Vis/skjul',
    'LBL_KIOSK_SIGN_IN' => 'Logg inn',
    'LBL_KIOSK_SIGN_OUT' => 'Logg av',
    'LBL_KIOSK_SORT_BY' => 'Sorter etter',
    'LBL_KIOSK_SUBMIT' => 'Send inn',
    'LBL_KIOSK_TIMEZONE' => 'Tidssone',
    'LBL_KIOSK_ACTIVITY' => 'Aktivitet',
    'LBL_KIOSK_NO_ACTIVITY' => 'Ingen aktivitet å vise',
    'LBL_KIOSK_OLDEST_FIRST' => 'Eldste først',
    'LBL_KIOSK_NEWEST_FIRST' => 'Nyeste først',
    'LBL_KIOSK_SHOW_MORE' => 'Vis mer',
    'LBL_KIOSK_ADD_A_REPLY' => 'Legg til et svar',
    'LBL_KIOSK_REPLY_EMPTY' => 'Svaret kan ikke stå tomt.',
    'LBL_KIOSK_NUM_MORE' => '{{num}} mer',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'Velkommen',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'Få rask tilgang til ressursene dine.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'Søk i saker',
    'LBL_KIOSK_SHOW_ALL' => 'Vis alle',
    'LBL_KIOSK_404_TITLE' => 'Vi kunne ikke finne dette',
    'LBL_KIOSK_TENANT_404_TITLE' => 'Finner ikke leietaker',
    'LBL_KIOSK_404_MESSAGE' => 'Du har klikket på en kobling som er fjernet, er midlertidig utilgjengelig, eller du har angitt en ugyldig URL-adresse.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'Kontroller at du har riktig nettadresse. For ytterligere hjelp, vennligst kontakt kundeservice.',
    'LBL_KIOSK_BACK_TO_HOME' => 'Tilbake til hjem',
    'LBL_KIOSK_ERROR_CODE' => '{code} feil: ',
    'LBL_KIOSK_401_TITLE' => 'Uautorisert',
    'LBL_KIOSK_401_MESSAGE' => 'Du er ikke autorisert til å se denne siden.',
    'LBL_KIOSK_403_TITLE' => 'Uautorisert',
    'LBL_KIOSK_403_MESSAGE' => 'Du har ikke tillatelse til å vise denne siden.',
    'LBL_KIOSK_500_TITLE' => 'Server svarer ikke',
    'LBL_KIOSK_500_MESSAGE' => 'Noe gikk galt fra vår side.',
    'LBL_KIOSK_GO_BACK' => 'Gå tilbake',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'Duplisert post funnet',
    'LBL_KIOSK_ACCOUNT' => 'Konto',
    'LBL_KIOSK_STATUS' => 'Status',
    'LBL_KIOSK_DEACTIVATE' => 'Deaktiver',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'Brukeren er deaktivert',
    'LBL_KIOSK_MANAGE_USERS' => 'Administrer brukere',
    'LBL_KIOSK_LAST_LOGIN' => 'Siste innlogging',
    'LBL_KIOSK_FIRST_NAME' => 'Fornavn',
    'LBL_KIOSK_LAST_NAME' => 'Etternavn',
    'LBL_KIOSK_ROLE' => 'Rolle',
    'LBL_KIOSK_INVITE' => 'Inviter',
    'LBL_KIOSK_SEND_INVITES' => 'Send invitasjon(er)',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'Invitasjon(er) er sendt',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'Invitasjon(er) ikke sendt',
    'LBL_KIOSK_REACTIVATE' => 'Aktiver på nytt',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'Brukeren er aktivert på nytt',
    'LBL_KIOSK_RESET_PASSWORD' => 'Tilbakestill passord',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'E-post med tilbakestilling av passord sendt',
    'LBL_KIOSK_USER_PROFILE' => 'Brukerprofil',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'Brukeren din er deaktivert. Kontakt administrator.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'Tilbake til innlogging',
    'LBL_KIOSK_REVOKE_INVITATION' => 'Trekk tilbake invitasjon',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'Invitasjon trukket tilbake',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'Søk og velg …',
    'LBL_KIOSK_NO_MATCHES' => 'Ingen treff',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'Profilen er oppdatert.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'Feil ved oppdatering av profilen.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'Dokumenter',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'Vis, søk i og last ned innkommende delte dokumenter.',
    'LBL_KIOSK_CASES' => 'Saker',
    'LBL_KIOSK_CASES_DESC' => 'Vis, søk i og svar på saker som er delt med deg.',
    'LBL_KIOSK_DOWNLOAD' => 'Last ned',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'Fil lastet ned',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'Komme i gang',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'For bedre å hjelpe deg vennligst oppgi ditt for- og etternavn.',
    'LBL_KIOSK_SAVE' => 'Lagre',
    'LBL_KIOSK_SHARED' => 'Delt',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'Velkommen {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'Bakgrunnsfarge',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'URL-adresse for bakgrunnsbilde',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'Det er anbefalt å velge et bilde med en filstørrelse på mindre enn 400K.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'Bakgrunnstype',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'Hjemmebakgrunn',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'Tema',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'Primær temafarge',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'Appnavn',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'Dette er tittelen på applikasjonen og vises ved siden av logoen din.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'URL-adresse for applogo',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'Det er anbefalt å velge en logo som er best synlig i små størrelser (f.eks. profiler på sosiale medier). Det anbefales også å ha en filstørrelse mindre enn 200K.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'URL-adresse for appfavorittikon',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'Et favorittikon er en liten logo som vises ved siden av sidetittelen i en nettleserfane.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'Automatisk tilordne åpne aktiviteter på nytt',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'Brukergrense er nådd',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'Ugyldig lisensnøkkel',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'Ugyldig søknad',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'Ugyldig søknad',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'Korrupt valideringsnøkkel',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'Lisensen er utløpt',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'Manglende info',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'Manglende valideringsnøkkel',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'Bruker mangler tilgang',
    'LBL_DRI_WORKFLOW' => 'Smart Guide',
    'LBL_DRI_WORKFLOWS' => 'Smart Guides',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Fasemal for Smart Guide',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Fasemaler for Smart Guide',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Mal for Smart Guide',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Mal for Smart Guide-aktivitet',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'Aktivitetsmaler',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'Web Hooks',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Web Hooks',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'Nåværende Smart Guide-aktivitet på',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Web Hooks',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate Web Hook',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar-handlinger',
    'LBL_CJ_FORMS' => 'Smart Guide Sugar-handlinger',
    'LBL_CJ_FORM' => 'Smart Guide Sugar-handling',
    'LBL_DRI_SUBWORKFLOW' => 'Smart Guide-fase',
    'LBL_DRI_SUBWORKFLOWS' => 'Smart Guide-faser',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Aktivitetsmaler for Smart Guide',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Smart Guide-maler',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Bestilling av Smart Guide',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Smart Guide Faktisk bestilling',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Smart Guide-score',
    'LBL_CJ_MOMENTUM_POINTS' => 'Smart Guide Momentum-poeng',
    'LBL_CJ_MOMENTUM_SCORE' => 'Smart Guide Momentum-score',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Smart Guide Tillat aktivitet etter',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Smart Guide-fremdrift',
    'LBL_CJ_MOMENTUM_RATIO' => 'Smart Guide Momentum-rangering',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Smart Guide-poeng',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Smart Guide-oppgave',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Aktivitetstype for Smart Guide for overordnede',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Smart Guide blokkert av',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'Smart Guide blokkert av stadier',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Smart Guide aktivitets-ID for overordnet',
    'LBL_START_NEXT_JOURNEY_ID' => 'Start neste Smart Guide-ID',
    'LBL_CJ_URL' => 'Smart Guide-URL',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Er Smart Guide for overordnet aktivitet',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Startdato for Smart Guide Momentum',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Smart Guide Momentum sluttdato',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'Konfigurasjon av widgetoppsett',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'Konfigurasjon av widgetoppsett',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'Maksimalt antall smarte hjelpelinjer fra samme mal',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'Aktive e-postkontoer',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'Arkivert',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'Vis',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'Skjul',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'Vertikal modus',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'Vannrett modus',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ugyldig lisens',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} har tilordnet følgende Smart Guide-aktiviteter til {{assigned_user}}.</p>
    <ul>{{activities}}</ul>
    
    <p>Du kan se gjennom disse aktivitetene på:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ugyldig lisens',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'Brukergrensen er nådd, du har {{gracePeriodDays}} dager på deg til å oppgradere lisensen.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - Tilordnede Smart Guide-aktiviteter',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Din Sugar Automate brukergrense på {0} er overskredet<br>
    <br>
    Ta kontakt med <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> for å heve brukergrensen eller redusere antall brukere som bruker pluginet.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate brukergrensen nådd',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Sugar Automate-lisensen din utløper om {0} dager. <br>
    <br>
    Ta kontakt med SugarCRM eller din Sugar Partner for å fornye og forhindre avbrudd i tjenesten.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate-lisensen er i ferd med å utløpe',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'Test Webhook',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide-fremdrift',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Viser Sugar Automates sektordiagram "Smart Guide Progress".',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'Viser Webhook-svaret',
    'LBL_DASHLET_SEND_LABEL' => 'Send forespørsel',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'Tilordne meg',
    'LBL_COMPLETE_BUTTON_TITLE' => 'Fullfør',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'Fullfør alle oppgaver',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'Slett fase',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'Start',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'Ikke aktuelt',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'Legg til fase',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'Vis',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Rediger Smart Guide',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'Avbryt',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'Arkiv',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'Ikke arkiver',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'Konfigurer mal',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'Legg til oppgave',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'Opprette møte',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'Planlegge samtale',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'er i fremtiden',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'er forsinket',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'er i dag',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'er i morgen',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'Er du sikker på at du vil avbryte Smart Guide?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'Du er i ferd med å fullføre alle oppgaver. Er du sikker på at du vil fortsette?',
    'LBL_CJ_BLOCK_BY' => 'Du har en uløst, avhengig oppgave: {{Name}}. Fullfør denne oppgaven før du fullfører alle oppgaver.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'Du har flere uløste, avhengige oppgaver. Fullfør disse oppgavene før du fullfører alle oppgaver.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'Du har fullført alle oppgaver',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'Er du sikker på at du vil arkivere Smart Guide?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'Er du sikker på at du vil fjerne arkiveringen av Smart Guide?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Smart Guides (Fokus-skuffer og konsoll)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'Vis aktive smarte hjelpelinjer på dashbord for service/fornyelseskonsoll og fokusskuff.',
    'LBL_CJ_PROCESSING_REQUEST' => 'Arbeider...',
    'LBL_CJ_SUCCESS' => 'Du har fullført alle oppgaver',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module} modulen er ikke aktivert',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'Alle skjerminnstillinger lagres.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Smart Guide Momentum',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Viser målerdiagrammet "Smart Guide Momentum" Sugar-automatisering.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide-fremdrift',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Viser Sugar Automates sektordiagram "Smart Guide Progress".',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'Kunne ikke finne overordnet',
    'CJ_NOT_FOUND_EXCEPTION' => 'Kunne ikke finne {moduleName} med {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'Smar Guide må fullføres eller avbrytes før arkivering',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate er ikke aktivert i gjeldende Sugar-lisens',
    'LBL_ACTION_NOT_FOUND' => 'Handling ikke funnet, kontakt systemadministrator',
    'LBL_CJ_SELECT_FIELD' => 'Velg felt',
    'LBL_CJ_SELECT_OPERATOR' => 'Velg operatør',
    'LBL_CJ_SELECT_VALUE' => 'Velg verdi',
    'LBL_CJ_ENTER_VALUE' => 'Skriv verdi',
    'LBL_CJ_FORM_BATCH_TITLE' => 'Lagre post',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'Aktive smartveiledninger oppdaget ...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'Behandler aktive sugar-handlinger ...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'Oppdaterer aktive smarte veiledninger ...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'Posten og tilhørende smarte veiledninger har blitt oppdatert.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'En tilknyttet smartveiledning har ikke oppdatert. Hvis feilen vedvarer, kan du kontakte Sugar-administratoren din for å få hjelp.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'En tilknyttet smartveiledning har ikke oppdatert. Vennligst se gjennom <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">Logger</a> for å feilsøke feilen.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => '<a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} har blitt koblet.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'Det oppsto et problem som knyttet til <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}}. Hvis problemet vedvarer, kan du kontakte kundestøtte for Sugar.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => '{{modulePluralLower}} har blitt koblet.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'Det oppsto et problem som knyttet til {{modulePluralLower}}. Hvis problemet vedvarfer, kan du kontakte kundestøtte for Sugar.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'Det oppsto et problem som knyttet til {{moduleSingularLower}}. Hvis problemet vedvarer, kan du kontakte kundestøtte for Sugar.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'Det finnes allerede en {{moduleSingularLower}} navngitt <a href="#{{module}}/{{id}}">{{name}}</a> i den {{stage}} fasen.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'En {{moduleSingularLower}} kalt <a href="#{{module}}/{{id}}">{{name}}</a> er allerede valgt.',
    'LBL_CJ_ARCHIVED' => 'Arkivert',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Velg Smart Guide-mal ...',
    'LBL_ALL_SMART_GUIDES' => 'Alle Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => 'Aktive Smart Guides',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Arkiverte Smart Guides',
    'LBL_VERTICAL_SCROLL_VIEW' => 'Vertikal stablet visning',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'Horisontal rullevisning',
    'LBL_DRI_WORKFLOWS_FILTER' => 'Filter',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'Denne handlingen kan ikke fullføres. Statusfeltet for denne aktivitetens modul er satt til "kun les", noe som forhindrer alle Smart Guide-handlinger som oppdaterer statusfeltet.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'Denne handlingen kan ikke fullføres. Statusfeltet for modulene til denne aktiviteten og/eller underaktivitetene er satt til "kun les", noe som forhindrer alle Smart Guide-handlinger som oppdaterer statusfeltet.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'Statusfeltet for noen av aktivitetsmodulene i guiden er satt til "kun les", disse aktivitetene vil forbli uendret ved avbrytelse av guiden.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'Kopiert til utklippstavle.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'Slett alle gjentakelser',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'Ugyldige gjentakelsesinnstillinger',
    'ERROR_INTERVAL_INVALID' => 'Gjentakelsesintervall må være mellom 1 og 99',
    'LBL_RECURRENCE_ADD' => 'Konfigurer',
    'LBL_REPEAT_DAYS' => 'Dag(er) i måneden',
    'LBL_REPEAT_END_TYPES' => 'Gjenta',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'Navigasjonsleverandør',
    'LBL_MOBILE_PDF_EMAIL' => 'E-post {{{pdfTemplateName}}} PDF',
    'LBL_MOBILE_EMAIL_SENDING' => 'Sender',
    'LBL_MOBILE_EMAIL_SENT' => 'Sendt',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'E-post lagret som utkast.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'Legg til vedlegg',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'Last opp fra lokal',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar-dokument',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'En nedtrekksverdi du valgte endret din Record View-layout. ',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'Versjonsnotater for SugarCRM Mobile',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'Brukerveiledning for SugarCRM Mobille App',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile kan ikke brukes på en rutet mobilenhet. Åpne åpen på urootet enhet.',
    'LBL_VO_BUILD_ROUTE' => 'Bygg rute',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'Mitt avstandsfilter',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'Dokumentet vil bli generert i bakgrunn. Åpne dokumentsammenslåingssiden for å få tilgang til filen.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'Kunne ikke hente mal. Kontakt administratoren din for assistanse.',
    'LBL_MAP_ERROR_LOAD' => 'Kan ikke laste kart',
    'LBL_MAP_DISTANCE' => 'Avstand',
    'LBL_SELECT_UNIT_TYPE' => 'Enhetstype',
    'LBL_MAPS_UNIT_MILES' => 'Mil',
    'LBL_MAPS_UNIT_KILOMETERS' => 'Kilometer',
    'LBL_RADIUS' => 'Radius',
    'LBL_ZIP_CODE' => 'Postnummer',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'Velg adresse',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'Kan ikke opprette geokode fra adresse:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'Post ble ikke geokodet.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'Post inneholder ikke adressedata. Vil du lokalisere denne posten på kartet manuelt?',
    'LBL_ERR_SHOW_ON_MAP' => 'Kunne ikke åpne kart for valgte poster.',
    'LBL_ERR_MISSING_ON_MAP' => 'Noen poster mangler adressedata og vises ikke',
    'LBL_MAPS_ROUTE' => 'Videresend',
    'LBL_MAPS_PROVIDER' => 'Sugar-kart',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'Kunne ikke fastlå gjeldende plassering.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'Maksimum {{{num}}} logger støttes for kartlegging.',
    'LBL_ALL_MODULES' => 'Alle moduler',
    'LBL_DRIVE_SHARE_LINK' => 'Del en lenke',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'Kunne ikke laste filer.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'Navn kan ikke være tomt',
    'LBL_DRIVE_FOLDER_CREATED' => 'Mappe opprettet.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'Kunne ikke opprette en mappe.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'Kunne ikke laste opp en fil.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'Opprett en rotmappe først',
    'LBL_EDIT_ALL_RECURRENCES' => 'Rediger alle gjentakelser',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'Fil kan ikke åpnes i Dropbox',
    'LBL_FILE_NOT_AVAILABLE' => 'Fil kan ikke åpnes',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'Retningslinjer',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'Ingen rute ble funnet for veipunktene som er oppgitt',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'I nærheten',
    'LBL_TAGS' => 'Etiketter',

    'LBL_CALLER_ID_SETTINGS' => 'Innstillinger for anrops-ID',
    'LBL_CALLER_ID_ENABLED' => 'Anrops-ID aktivert',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'Ved innkommende samtaler vises navnet på kontakten eller kundeemnet som samsvarer med telefonnummeret.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'Hvis du vil at mobilappen skal kunne vise oppringer-ID-er, følger du disse trinnene på enheten:<br><br>1. Åpne iOS-innstillinger > telefon > anropsblokkering og identifikasjon.<br>2. Aktiver "{{{brandName}}}".',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'Hvis du vil at mobilappen skal kunne vise oppringer-ID-er, følger du disse trinnene på enheten:<br>1. Åpne appinnstillingene.<br>2. Gå til Tillatelser.<br>3. Aktiver telefontillatelsen.<br><br> For å angi dette programmet som standard anrops-ID-behandler gå til enhetsinnstillingene.<br>1. Naviger til Apper.<br>2. Velg standardapper.<br>3. Velg Anrops-ID og spam-app.<br>4. Velg dette programmet som standardalternativ.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Se etter endringer i kontaktinformasjon fra oppføringer (f.eks. kontakter, kundeemner) i Sugar-forekomsten.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'Gå til Innstillinger',
    'LBL_CALLER_ID_SYNC' => 'Synkroniser postdata',
    'LBL_CALLER_ID_NOT_ENABLED' => 'Anrops-Id må være aktivert i systeminnstillingene før synkronisering.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'Aktivér',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'Senere i innstillingene',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'Denne applikasjonen støtter anrops-ID-funksjonen.<br> For at denne funksjonen skal fungere riktig, etter at du har trykket på aktiveringsknappen, blir du bedt om å gi to tillatelser.<br> For å sikre at anrops-ID-funksjonen fungerer som den skal må du gi tillatelse til å administrere samtaler og velge dette programmet som standard anrops-ID-behandler.<br> Hvis du ikke gir tillatelse til å administrere samtaler, vil du heller ikke kunne logge anrop fra applikasjonen.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'Hvis du vil at SugarCRM-mobilappen skal kunne vise oppringer-ID-er, følger du disse trinnene på enheten:<br><br>1. Åpne iOS-innstillinger > telefon > anropsblokkering og identifikasjon.<br>2. Aktiver app.',
    'LBL_MOBILE_LAST_SYNC' => 'Siste synkronisering',
    'LBL_CALLER_ID_SYNCING' => 'Synkronisering med server.',
    'LBL_NEVER' => 'Aldri',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} kan ikke være tom.',
    'LBL_ADD_RELATED_RECORD' => 'Relatert {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => 'Du har ikke de nødvendige tillatelsene til å bruke oppringer-ID. Kontakt systemansvarlig.',
    'LBL_CALLER_ID_FETCHING' => 'Synkroniserer …',
    'LBL_CALLER_ID_FETCH_ALL' => 'Synkroniser alle poster på nytt',
    'LBL_CALLER_ID_FETCH_NEW' => 'Se etter postoppdateringer',

    'LBL_SORT_BY' => 'Sorter etter',
    'LBL_PRIMARY_SORT' => 'Primærsortering',
    'LBL_SECONDARY_SORT' => 'Sekundærsortering',
    'LBL_OF' => 'av',
    'LBL_TABLE_FREEZE_FIRST' => 'Frys første spalte',
    'LBL_TABLE_SETTINGS_TITLE' => 'Alternativer for spaltevisning',
    'LBL_TABLE_SETTINGS_NO_COL' => 'Minst én spalte må være valgt.',
    'LBL_TABLE_TOGGLER_INFO' => 'Vis eller skjul spalter, og dra dem til ønsket rekkefølge.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'Kjøretidsfiltre',
    'LBL_FILTER_CONDITION' => 'Velg tilstand',
    'LBL_FILTER_VALUES' => 'Verdier',
    'LBL_TABLE_EXPAND' => 'Utvid alle',
    'LBL_TABLE_COLLAPSE' => 'Forminsk alle',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'Server feil. Kunne ikke laste inn relevante kjøretidsfiltre.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Pub/Sub Module Event Push-abonnementer',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Pub/Sub Module Event Push-abonnement',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'Panel - Topp',
    'panel_bottom' => 'Panel - Bunn',
    'tab_first' => 'Fane - Først',
    'tab_last' => 'Fane - Siste',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'Siste 7 dager',
    '30' => 'Siste 30 dager',
    '90' => 'Forrige kvartal',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'I dag',
    'future' => 'Fremtid',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nei',
];

$app_list_strings['history_filter_options'] = [
    7 => 'Siste 7 dager',
    30 => 'Siste 30 dager',
    90 => 'Forrige kvartal',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nei',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nei',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'Ja',
    '0' => 'Nei',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'Dette kvartalet',
    'next' => 'Neste kvartal',
    'year' => 'Dette år',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'Mine poster',
    'group' => 'Gruppeposter',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'Min salgstrakt',
    'group' => 'Mitt teams Pipeline',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'Min Prognose',
    'group' => 'Mitt teams prognoser',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'Muligheter',
    'RevenueLineItems' => 'Muligheter og omsetningsposter',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'Seneste Lukke Dato',
    'earliest' => 'Tidligst Lukke Dato',
];

$app_list_strings['moduleList']['Library'] = 'Bibliotek';
$app_list_strings['moduleListSingular']['Library'] = 'Bibliotek';
$app_list_strings['library_type'] = ['Books' => 'Bok', 'Music' => 'Musikk', 'DVD' => 'DVD', 'Magazines' => 'Blader'];
$app_list_strings['moduleList']['EmailAddresses'] = 'E-postadresse';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'E-postadresse';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'Utkast',
    'in-review' => 'Under gjennomgang',
    'approved' => 'Godkjent',
    'published' => 'Publisert',
    'expired' => 'Foreldet',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--Admin Handlinger--',
        'Create New Tag' => 'Opprett ny tag',
        'Delete Tag' => 'Slett tag',
        'Rename Tag' => 'Fjern tag',
        'Move Selected Articles' => 'Flytt valgte artikler',
        'Apply Tags On Articles' => 'Påfør tags til artiklene',
        'Delete Selected Articles' => 'Slett valgte artikler',
    ];

$app_list_strings['moduleList']['Words'] = 'Ord';
$app_list_strings['moduleListSingular']['Words'] = 'Ord';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Opprett artikkel';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DHABI',
    'ADEN' => 'ADEN',
    'AFGHANISTAN' => 'AFGHANISTAN',
    'ALBANIA' => 'ALBANIA',
    'ALGERIA' => 'ALGERIE',
    'AMERICAN SAMOA' => 'AMERIKANSK SAMOA',
    'ANDORRA' => 'ANDORRA',
    'ANGOLA' => 'ANGOLA',
    'ANTARCTICA' => 'ANTARKTIS',
    'ANTIGUA' => 'ANTIGUA',
    'ARGENTINA' => 'ARGENTINA',
    'ARMENIA' => 'ARMENIA',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => 'AUSTRALIA',
    'AUSTRIA' => 'ØSTERRIKE',
    'AZERBAIJAN' => 'ASERBAJDSJAN',
    'BAHAMAS' => 'BAHAMAS',
    'BAHRAIN' => 'BAHRAIN',
    'BANGLADESH' => 'BANGLADESH',
    'BARBADOS' => 'BARBADOS',
    'BELARUS' => 'HVITERUSSLAND',
    'BELGIUM' => 'BELGIA',
    'BELIZE' => 'BELIZE',
    'BENIN' => 'BENIN',
    'BERMUDA' => 'BERMUDA',
    'BHUTAN' => 'BHUTAN',
    'BOLIVIA' => 'BOLIVIA',
    'BOSNIA' => 'BOSNIA',
    'BOTSWANA' => 'BOTSWANA',
    'BOUVET ISLAND' => 'BOUVETØYA',
    'BRAZIL' => 'BRASIL',
    'BRITISH ANTARCTICA TERRITORY' => 'BRITISK ANTARKTISK TERRITORIUM',
    'BRITISH INDIAN OCEAN TERRITORY' => 'BRITISK INDISK HAVTERRITORIE',
    'BRITISH VIRGIN ISLANDS' => 'DE BRITISKE JOMFRUØYENE',
    'BRITISH WEST INDIES' => 'BRITISK VESTINDIA',
    'BRUNEI' => 'BRUNEI',
    'BULGARIA' => 'BULGARIA',
    'BURKINA FASO' => 'BURKINA FASO',
    'BURUNDI' => 'BURUNDI',
    'CAMBODIA' => 'KAMBODSJA',
    'CAMEROON' => 'KAMERUN',
    'CANADA' => 'CANADA',
    'CANAL ZONE' => 'KANALSONEN',
    'CANARY ISLAND' => 'KANARIØYNENE',
    'CAPE VERDI ISLANDS' => 'KAPP VERDE-ØYENE',
    'CAYMAN ISLANDS' => 'CAYMANØYENE',
    'CEVLON' => 'CEYLON',
    'CHAD' => 'CHAD',
    'CHANNEL ISLAND UK' => 'CHANNEL ISLAND UK',
    'CHILE' => 'CHILE',
    'CHINA' => 'KINA',
    'CHRISTMAS ISLAND' => 'JULEØYA',
    'COCOS (KEELING) ISLAND' => 'COCOS (KEELING) ØYA',
    'COLOMBIA' => 'COLOMBIA',
    'COMORO ISLANDS' => 'COMORENE',
    'CONGO' => 'KONGO',
    'CONGO KINSHASA' => 'KONGO KINSHASA',
    'COOK ISLANDS' => 'COOK ØYA',
    'COSTA RICA' => 'COSTA RICA',
    'CROATIA' => 'KROATSIA',
    'CUBA' => 'CUBA',
    'CURACAO' => 'CURACAO',
    'CYPRUS' => 'KYPROS',
    'CZECH REPUBLIC' => 'TSJEKKIA',
    'DAHOMEY' => 'DAHOMEY',
    'DENMARK' => 'DANMARK',
    'DJIBOUTI' => 'DJIBOUTI',
    'DOMINICA' => 'DOMINICA',
    'DOMINICAN REPUBLIC' => 'DEN DOMINIKANSKE REPUBLIKK',
    'DUBAI' => 'DUBAI',
    'ECUADOR' => 'ECUADOR',
    'EGYPT' => 'EGYPT',
    'EL SALVADOR' => 'EL SALVADOR',
    'EQUATORIAL GUINEA' => 'EKVATORIAL-GUINEA',
    'ESTONIA' => 'ESTLAND',
    'ETHIOPIA' => 'ETIOPIA',
    'FAEROE ISLANDS' => 'FÆRØENE',
    'FALKLAND ISLANDS' => 'FALKLANDSØYENE',
    'FIJI' => 'FIJI',
    'FINLAND' => 'FINLAND',
    'FRANCE' => 'FRANKRIKE',
    'FRENCH GUIANA' => 'FRANSK GUYANA',
    'FRENCH POLYNESIA' => 'FRANSK POLYNESIA',
    'GABON' => 'GABON',
    'GAMBIA' => 'GAMBIA',
    'GEORGIA' => 'GEORGIA',
    'GERMANY' => 'TYSKLAND',
    'GHANA' => 'GHANA',
    'GIBRALTAR' => 'GIBRALTAR',
    'GREECE' => 'HELLAS',
    'GREENLAND' => 'GRØNLAND',
    'GUADELOUPE' => 'GUADELOUPE',
    'GUAM' => 'GUAM',
    'GUATEMALA' => 'GUATEMALA',
    'GUINEA' => 'GUINEA',
    'GUYANA' => 'GUYANA',
    'HAITI' => 'HAITI',
    'HONDURAS' => 'HONDURAS',
    'HONG KONG' => 'HONG KONG',
    'HUNGARY' => 'UNGARN',
    'ICELAND' => 'ISLAND',
    'IFNI' => 'IFNI',
    'INDIA' => 'INDIA',
    'INDONESIA' => 'INDONESIA',
    'IRAN' => 'IRAN',
    'IRAQ' => 'IRAK',
    'IRELAND' => 'IRLAND',
    'ISRAEL' => 'ISRAEL',
    'ITALY' => 'ITALIA',
    'IVORY COAST' => 'ELFENBENS KYSTEN',
    'JAMAICA' => 'JAMAICA',
    'JAPAN' => 'JAPAN',
    'JORDAN' => 'JORDAN',
    'KAZAKHSTAN' => 'KASAKHSTAN',
    'KENYA' => 'KENYA',
    'KOREA' => 'KOREA',
    'KOREA, SOUTH' => 'KOREA, SØR',
    'KUWAIT' => 'KUWAIT',
    'KYRGYZSTAN' => 'KIRGISISTAN',
    'LAOS' => 'LAOS',
    'LATVIA' => 'LATVIA',
    'LEBANON' => 'LIBANON',
    'LEEWARD ISLANDS' => 'LEEWARDØYENE',
    'LESOTHO' => 'LESOTHO',
    'LIBYA' => 'LIBYA',
    'LIECHTENSTEIN' => 'LIECHTENSTEIN',
    'LITHUANIA' => 'LITAUEN',
    'LUXEMBOURG' => 'LUXEMBOURG',
    'MACAO' => 'MACAU',
    'MACEDONIA' => 'MAKEDONIA',
    'MADAGASCAR' => 'MADAGASKAR',
    'MALAWI' => 'MALAWI',
    'MALAYSIA' => 'MALAYSIA',
    'MALDIVES' => 'MALDIVENE',
    'MALI' => 'MALI',
    'MALTA' => 'MALTA',
    'MARTINIQUE' => 'MARTINIQUE',
    'MAURITANIA' => 'MAURI',
    'MAURITIUS' => 'MAURITIUS',
    'MELANESIA' => 'MELANESIA',
    'MEXICO' => 'MEXICO',
    'MOLDOVIA' => 'MOLDOVA',
    'MONACO' => 'MONACO',
    'MONGOLIA' => 'MONGOLIA',
    'MOROCCO' => 'MAROKKO',
    'MOZAMBIQUE' => 'MOSAMBIK',
    'MYANAMAR' => 'MYANMAR',
    'NAMIBIA' => 'NAMIBIA',
    'NEPAL' => 'NEPAL',
    'NETHERLANDS' => 'NEDERLAND',
    'NETHERLANDS ANTILLES' => 'NEDERLAND ANTILLES',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'NEDERLAND ANTILLES NØYTRAL SONE',
    'NEW CALADONIA' => 'NY-CALEDONIA',
    'NEW HEBRIDES' => 'NY-HEBRIDENE',
    'NEW ZEALAND' => 'NEW ZEALAND',
    'NICARAGUA' => 'NICARAGUA',
    'NIGER' => 'NIGER',
    'NIGERIA' => 'NIGERIA',
    'NORFOLK ISLAND' => 'NORFOLK ØYA',
    'NORWAY' => 'NORGE',
    'OMAN' => 'OMAN',
    'OTHER' => 'ANNET',
    'PACIFIC ISLAND' => 'STILLEHAVSØYA',
    'PAKISTAN' => 'PAKISTAN',
    'PANAMA' => 'PANAMA',
    'PAPUA NEW GUINEA' => 'PAPUA NEW GUINEA',
    'PARAGUAY' => 'PARAGUAY',
    'PERU' => 'PERU',
    'PHILIPPINES' => 'FILLIPINENE',
    'POLAND' => 'POLEN',
    'PORTUGAL' => 'PORTUGAL',
    'PORTUGUESE TIMOR' => 'PORTUGISISK TIMOR',
    'PUERTO RICO' => 'PUERTO RICO',
    'QATAR' => 'QATAR',
    'REPUBLIC OF BELARUS' => 'REPUBLIKKEN HVITERUSSLAND',
    'REPUBLIC OF SOUTH AFRICA' => 'REPUBLIKKEN SØR-AFRIKA',
    'REUNION' => 'REUNION',
    'ROMANIA' => 'ROMANIA',
    'RUSSIA' => 'RUSSLAND',
    'RWANDA' => 'RWANDA',
    'RYUKYU ISLANDS' => 'RYUKYU-ØYENE',
    'SABAH' => 'SABAH',
    'SAN MARINO' => 'SAN MARINO',
    'SAUDI ARABIA' => 'AUDI ARABIA',
    'SENEGAL' => 'SENEGAL',
    'SERBIA' => 'SERBIA',
    'SEYCHELLES' => 'SEYCHELLENE',
    'SIERRA LEONE' => 'SIERRA LEONE',
    'SINGAPORE' => 'SINGAPOR',
    'SLOVAKIA' => 'SLOVAKIA',
    'SLOVENIA' => 'SLOVENIA',
    'SOMALILIAND' => 'SOMALIA',
    'SOUTH AFRICA' => 'SØR-AFRIKA',
    'SOUTH YEMEN' => 'SØR-YEMEN',
    'SPAIN' => 'SPANIA',
    'SPANISH SAHARA' => 'SPANSK SAHARA',
    'SRI LANKA' => 'SRI LANKA',
    'ST. KITTS AND NEVIS' => 'ST. KITTS OG NEVIS',
    'ST. LUCIA' => 'ST. LUCIA',
    'SUDAN' => 'SUDAN',
    'SURINAM' => 'SURINAM',
    'SW AFRICA' => 'SW AFRIKA',
    'SWAZILAND' => 'SWAZILAND',
    'SWEDEN' => 'SVERIGE',
    'SWITZERLAND' => 'SVEITS',
    'SYRIA' => 'SYRIA',
    'TAIWAN' => 'TAIWAN',
    'TAJIKISTAN' => 'TADSJIKISTAN',
    'TANZANIA' => 'TANZANIA',
    'THAILAND' => 'THAILAND',
    'TONGA' => 'TONGA',
    'TRINIDAD' => 'TRINIDAD',
    'TUNISIA' => 'TUNIS',
    'TURKEY' => 'TYRKIA',
    'UGANDA' => 'UGANDA',
    'UKRAINE' => 'UKRAINA',
    'UNITED ARAB EMIRATES' => 'FORENTE ARABISKE EMIRATER',
    'UNITED KINGDOM' => 'STORBRITANNIA',
    'UPPER VOLTA' => 'ØVRE VOLTA',
    'URUGUAY' => 'URUGUAY',
    'US PACIFIC ISLAND' => 'US STILLEHAVS ØYA',
    'US VIRGIN ISLANDS' => 'DE AMERIKANSKE JOMFRUØYENE',
    'USA' => 'USA',
    'UZBEKISTAN' => 'USBEKISTAN',
    'VANUATU' => 'VANUATU',
    'VATICAN CITY' => 'VATIKANET',
    'VENEZUELA' => 'VENEZUELA',
    'VIETNAM' => 'VIETNAM',
    'WAKE ISLAND' => 'WAKE ØYA',
    'WEST INDIES' => 'VESTINDIA',
    'WESTERN SAHARA' => 'VEST SAHARA',
    'YEMEN' => 'YEMEN',
    'ZAIRE' => 'ZAIRE',
    'ZAMBIA' => 'ZAMBIA',
    'ZIMBABWE' => 'ZIMBABWE',
];

$app_list_strings['state_dom'] = [
    'AL' => 'Alabama',
    'AK' => 'Alaska',
    'AZ' => 'Arizona',
    'AR' => 'Arkansas',
    'CA' => 'California',
    'CO' => 'Colorado',
    'CT' => 'Connecticut',
    'DE' => 'Delaware',
    'DC' => 'Distriktet Columbia',
    'FL' => 'Florida',
    'GA' => 'Georgia',
    'HI' => 'Hawaii',
    'ID' => 'Idaho',
    'IL' => 'Illinois',
    'IN' => 'Indiana',
    'IA' => 'Iowa',
    'KS' => 'Kansas',
    'KY' => 'Kentucky',
    'LA' => 'Louisiana',
    'ME' => 'Maine',
    'MD' => 'Maryland',
    'MA' => 'Massachusetts',
    'MI' => 'Michigan',
    'MN' => 'Minnesota',
    'MS' => 'Mississippi',
    'MO' => 'Missouri',
    'MT' => 'Montana',
    'NE' => 'Nebraska',
    'NV' => 'Nevada',
    'NH' => 'New Hampshire',
    'NJ' => 'New Jersey',
    'NM' => 'New Mexico',
    'NY' => 'New York',
    'NC' => 'North Carolina',
    'ND' => 'North Dakota',
    'OH' => 'Ohio',
    'OK' => 'Oklahoma',
    'OR' => 'Oregon',
    'PA' => 'Pennsylvania',
    'RI' => 'Rhode Island',
    'SC' => 'South Carolina',
    'SD' => 'South Dakota',
    'TN' => 'Tennessee',
    'TX' => 'Texas',
    'UT' => 'Utah',
    'VT' => 'Vermont',
    'VA' => 'Virginia',
    'WA' => 'Washington',
    'WV' => 'West Virginia',
    'WI' => 'Wisconsin',
    'WY' => 'Wyoming',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (Taiwano g Hong Kong)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS Cyrillic)',
    'CP1252' => 'CP1252 (MS Vest Europeisk & US)',
    'EUC-CN' => 'EUC-CN (Forenklet Kinesisk GB2312)',
    'EUC-JP' => 'EUC-JP (Unix Japansk)',
    'EUC-KR' => 'EUC-KR (Koreansk)',
    'EUC-TW' => 'EUC-TW (Taiwansk)',
    'ISO-2022-JP' => 'ISO-2022-JP (Japansk)',
    'ISO-2022-KR' => 'ISO-2022-KR (Koreansk)',
    'ISO-8859-1' => 'ISO-8859-1 (Vest Europeisk og US)',
    'ISO-8859-2' => 'ISO-8859-2 (Central and Øst Europeisk)',
    'ISO-8859-3' => 'ISO-8859-3 (Latin 3)',
    'ISO-8859-4' => 'ISO-8859-4 (Latin 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Cyrillic)',
    'ISO-8859-6' => 'ISO-8859-6 (Arabisk)',
    'ISO-8859-7' => 'ISO-8859-7 (Gresk)',
    'ISO-8859-8' => 'ISO-8859-8 (Hebraisk)',
    'ISO-8859-9' => 'ISO-8859-9 (Latin 5)',
    'ISO-8859-10' => 'ISO-8859-10 (Latin 6)',
    'ISO-8859-13' => 'ISO-8859-13 (Latin 7)',
    'ISO-8859-14' => 'ISO-8859-14 (Latin 8)',
    'ISO-8859-15' => 'ISO-8859-15 (Latin 9)',
    'KOI8-R' => 'KOI8-R (Cyrillic Russisk)',
    'KOI8-U' => 'KOI8-U (Cyrillic Ukrainsk)',
    'SJIS' => 'SJIS (MS Japanesisk)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Afrika/Algiers',
    'Africa/Luanda' => 'Afrika/Luanda',
    'Africa/Porto-Novo' => 'Afrika/Porto-Novo',
    'Africa/Gaborone' => 'Afrika/Gaborone',
    'Africa/Ouagadougou' => 'Afrika/Ouagadougou',
    'Africa/Bujumbura' => 'Afrika/Bujumbura',
    'Africa/Douala' => 'Afrika/Douala',
    'Atlantic/Cape_Verde' => 'Atlantiske/Kapp_Verde',
    'Africa/Bangui' => 'Afrika/Bangui',
    'Africa/Ndjamena' => 'Afrika/Ndjamena',
    'Indian/Comoro' => 'Indiske/Comoro',
    'Africa/Kinshasa' => 'Afrika/Kinshasa',
    'Africa/Lubumbashi' => 'Afrika/Lubumbashi',
    'Africa/Brazzaville' => 'Afrika/Brazzaville',
    'Africa/Abidjan' => 'Afrika/Abidjan',
    'Africa/Djibouti' => 'Afrika/Djibouti',
    'Africa/Cairo' => 'Afrika/Kairo',
    'Africa/Malabo' => 'Afrika/Malabo',
    'Africa/Asmera' => 'Afrika/Asmera',
    'Africa/Addis_Ababa' => 'Afrika/Addis_Ababa',
    'Africa/Libreville' => 'Afrika/Libreville',
    'Africa/Banjul' => 'Afrika/Banjul',
    'Africa/Accra' => 'Afrika/Accra',
    'Africa/Conakry' => 'Afrika/Conakry',
    'Africa/Bissau' => 'Afrika/Bissau',
    'Africa/Nairobi' => 'Afrika/Nairobi',
    'Africa/Maseru' => 'Afrika/Maseru',
    'Africa/Monrovia' => 'Afrika/Nomrovia',
    'Africa/Tripoli' => 'Afrika/Tripoli',
    'Indian/Antananarivo' => 'Indiske/Antananarivo',
    'Africa/Blantyre' => 'Afrika/Blantyre',
    'Africa/Bamako' => 'Afrika/Bamako',
    'Africa/Nouakchott' => 'Afrika/Nouakchott',
    'Indian/Mauritius' => 'Indiske/Mauritius',
    'Indian/Mayotte' => 'Indiske/Mayotte',
    'Africa/Casablanca' => 'Afrika/Casablanca',
    'Africa/El_Aaiun' => 'Afrika/El_Aaiun',
    'Africa/Maputo' => 'Afrika/Maputo',
    'Africa/Windhoek' => 'Afrika/Windhoek',
    'Africa/Niamey' => 'Afrika/Niamey',
    'Africa/Lagos' => 'Afrika/Lagos',
    'Indian/Reunion' => 'Indiske/Reunion',
    'Africa/Kigali' => 'Afrika/Kigali',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Africa/Sao_Tome' => 'Afrika/Sao_Tome',
    'Africa/Dakar' => 'Afrika/Dakar',
    'Indian/Mahe' => 'Indiske/Mahe',
    'Africa/Freetown' => 'Afrika/Freetown',
    'Africa/Mogadishu' => 'Afrika/Mogadishu',
    'Africa/Johannesburg' => 'Afrika/Johannesburg',
    'Africa/Khartoum' => 'Afrika/Khartoum',
    'Africa/Mbabane' => 'Afrika/Mbabane',
    'Africa/Dar_es_Salaam' => 'Afrika/Dar_es_Salaam',
    'Africa/Lome' => 'Afrika/Lome',
    'Africa/Tunis' => 'Afrika/Tunis',
    'Africa/Kampala' => 'Afrika/Kampala',
    'Africa/Lusaka' => 'Afrika/Lusaka',
    'Africa/Harare' => 'Afrika/Harare',
    'Antarctica/Casey' => 'Antarktis/Casey',
    'Antarctica/Davis' => 'Antarktis/Davis',
    'Antarctica/Mawson' => 'Antarktis/Mawson',
    'Indian/Kerguelen' => 'Indiske/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antarktis/DumontDUrville',
    'Antarctica/Syowa' => 'Antarktis/Syowa',
    'Antarctica/Vostok' => 'Antarktis/Vostok',
    'Antarctica/Rothera' => 'Antarktis/Rothera',
    'Antarctica/Palmer' => 'Antarktis/Palmer',
    'Antarctica/McMurdo' => 'Antarktis/McMurdo',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Indian/Chagos' => 'Indiske/Chagos',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Rangoon' => 'Asia/Rangoon',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Beijing' => 'Asia/Beijing',
    'Asia/Harbin' => 'Asia/Harbin',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Chongqing' => 'Asia/Chongqing',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Kashgar' => 'Asia/Kashgar',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Calcutta' => 'Asia/Calcutta',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Indian/Maldives' => 'Indiske/Maldives',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Katmandu' => 'Asia/Katmandu',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damaskus',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Saigon' => 'Asia/Saigon',
    'Asia/Aden' => 'Asia/Aden',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Sydney' => 'Australia/Sydney',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Indian/Christmas' => 'Indiske/Juleøya',
    'Pacific/Rarotonga' => 'Stillehavet/Rarotonga',
    'Indian/Cocos' => 'Indiske/Cocos',
    'Pacific/Fiji' => 'Stillehavet/Fiji',
    'Pacific/Gambier' => 'Stillehavet/Gambier',
    'Pacific/Marquesas' => 'Stillehavet/Marquesas',
    'Pacific/Tahiti' => 'Stillehavet/Tahiti',
    'Pacific/Guam' => 'Stillehavet/Guam',
    'Pacific/Tarawa' => 'Stillehavet/Tarawa',
    'Pacific/Enderbury' => 'Stillehavet/Enderbury',
    'Pacific/Kiritimati' => 'Stillehavet/Kiritimati',
    'Pacific/Saipan' => 'Stillehavet/Saipan',
    'Pacific/Majuro' => 'Stillehavet/Majuro',
    'Pacific/Kwajalein' => 'Stillehavet/Kwajalein',
    'Pacific/Truk' => 'Stillehavet/Truk',
    'Pacific/Ponape' => 'Stillehavet/Ponape',
    'Pacific/Kosrae' => 'Stillehavet/Kosrae',
    'Pacific/Nauru' => 'Stillehavet/Nauru',
    'Pacific/Noumea' => 'Stillehavet/Noumea',
    'Pacific/Auckland' => 'Stillehavet/Auckland',
    'Pacific/Chatham' => 'Stillehavet/Chatham',
    'Pacific/Niue' => 'Stillehavet/Niue',
    'Pacific/Norfolk' => 'Stillehavet/Norfolk',
    'Pacific/Palau' => 'Stillehavet/Palau',
    'Pacific/Port_Moresby' => 'Stillehavet/Port_Moresby',
    'Pacific/Pitcairn' => 'Stillehavet/Pitcairn',
    'Pacific/Pago_Pago' => 'Stillehavet/Pago_Pago',
    'Pacific/Apia' => 'Stillehavet/Apia',
    'Pacific/Guadalcanal' => 'Stillehavet/Guadalcanal',
    'Pacific/Fakaofo' => 'Stillehavet/Fakaofo',
    'Pacific/Tongatapu' => 'Stillehavet/Tongatapu',
    'Pacific/Funafuti' => 'Stillehavet/Funafuti',
    'Pacific/Johnston' => 'Stillehavet/Johnston',
    'Pacific/Midway' => 'Stillehavet/Midway',
    'Pacific/Wake' => 'Stillehavet/Wake',
    'Pacific/Efate' => 'Stillehavet/Efate',
    'Pacific/Wallis' => 'Stillehavet/Wallis',
    'Europe/London' => 'Europa/London',
    'Europe/Dublin' => 'Europa/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'Europa/Tirane',
    'Europe/Andorra' => 'Europa/Andorra',
    'Europe/Vienna' => 'Europa/Vienna',
    'Europe/Minsk' => 'Europa/Minsk',
    'Europe/Brussels' => 'Europa/Brussels',
    'Europe/Sofia' => 'Europa/Sofia',
    'Europe/Prague' => 'Europa/Prague',
    'Europe/Copenhagen' => 'Europa/Copenhagen',
    'Atlantic/Faeroe' => 'Atlantic/Faeroe',
    'America/Danmarkshavn' => 'Amerika/Danmarkshavn',
    'America/Scoresbysund' => 'Amerika/Scoresbysund',
    'America/Godthab' => 'Amerika/Godthab',
    'America/Thule' => 'Amerika/Thule',
    'Europe/Tallinn' => 'Europa/Tallinn',
    'Europe/Helsinki' => 'Europa/Helsinki',
    'Europe/Paris' => 'Europa/Paris',
    'Europe/Berlin' => 'Europa/Berlin',
    'Europe/Gibraltar' => 'Europa/Gibraltar',
    'Europe/Athens' => 'Europa/Athens',
    'Europe/Budapest' => 'Europa/Budapest',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Europe/Rome' => 'Europa/Rome',
    'Europe/Riga' => 'Europa/Riga',
    'Europe/Vaduz' => 'Europa/Vaduz',
    'Europe/Vilnius' => 'Europa/Vilnius',
    'Europe/Luxembourg' => 'Europa/Luxembourg',
    'Europe/Malta' => 'Europa/Malta',
    'Europe/Chisinau' => 'Europa/Chisinau',
    'Europe/Monaco' => 'Europa/Monaco',
    'Europe/Amsterdam' => 'Europa/Amsterdam',
    'Europe/Oslo' => 'Europa/Oslo',
    'Europe/Warsaw' => 'Europa/Warsaw',
    'Europe/Lisbon' => 'Europa/Lisbon',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Europe/Bucharest' => 'Europa/Bucharest',
    'Europe/Kaliningrad' => 'Europa/Kaliningrad',
    'Europe/Moscow' => 'Europa/Moscow',
    'Europe/Samara' => 'Europa/Samara',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Europe/Belgrade' => 'Europa/Belgrade',
    'Europe/Madrid' => 'Europa/Madrid',
    'Africa/Ceuta' => 'Afrika/Ceuta',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Europe/Stockholm' => 'Europa/Stockholm',
    'Europe/Zurich' => 'Europa/Zurich',
    'Europe/Istanbul' => 'Europa/Istanbul',
    'Europe/Kiev' => 'Europa/Kiev',
    'Europe/Uzhgorod' => 'Europa/Uzhgorod',
    'Europe/Zaporozhye' => 'Europa/Zaporozhye',
    'Europe/Simferopol' => 'Europa/Simferopol',
    'America/New_York' => 'Amerika/New_York',
    'America/Chicago' => 'Amerika/Chicago',
    'America/North_Dakota/Center' => 'Amerika/North_Dakota/Center',
    'America/Denver' => 'Amerika/Denver',
    'America/Los_Angeles' => 'Amerika/Los_Angeles',
    'America/Juneau' => 'Amerika/Juneau',
    'America/Yakutat' => 'Amerika/Yakutat',
    'America/Anchorage' => 'Amerika/Anchorage',
    'America/Nome' => 'Amerika/Nome',
    'America/Adak' => 'Amerika/Adak',
    'Pacific/Honolulu' => 'Stillehavet/Honolulu',
    'America/Phoenix' => 'Amerika/Phoenix',
    'America/Boise' => 'Amerika/Boise',
    'America/Indiana/Indianapolis' => 'Amerika/Indiana/Indianapolis',
    'America/Indiana/Marengo' => 'Amerika/Indiana/Marengo',
    'America/Indiana/Knox' => 'Amerika/Indiana/Knox',
    'America/Indiana/Vevay' => 'Amerika/Indiana/Vevay',
    'America/Kentucky/Louisville' => 'Amerika/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'Amerika/Kentucky/Monticello',
    'America/Detroit' => 'Amerika/Detroit',
    'America/Menominee' => 'Amerika/Menominee',
    'America/St_Johns' => 'Amerika/St_Johns',
    'America/Goose_Bay' => 'Amerika/Goose_Bay',
    'America/Halifax' => 'Amerika/Halifax',
    'America/Glace_Bay' => 'Amerika/Glace_Bay',
    'America/Montreal' => 'Amerika/Montreal',
    'America/Toronto' => 'Amerika/Toronto',
    'America/Thunder_Bay' => 'Amerika/Thunder_Bay',
    'America/Nipigon' => 'Amerika/Nipigon',
    'America/Rainy_River' => 'Amerika/Rainy_River',
    'America/Winnipeg' => 'Amerika/Winnipeg',
    'America/Regina' => 'Amerika/Regina',
    'America/Swift_Current' => 'Amerika/Swift_Current',
    'America/Edmonton' => 'Amerika/Edmonton',
    'America/Vancouver' => 'Amerika/Vancouver',
    'America/Dawson_Creek' => 'Amerika/Dawson_Creek',
    'America/Pangnirtung' => 'Amerika/Pangnirtung',
    'America/Iqaluit' => 'Amerika/Iqaluit',
    'America/Coral_Harbour' => 'Amerika/Coral_Harbour',
    'America/Rankin_Inlet' => 'Amerika/Rankin_Inlet',
    'America/Cambridge_Bay' => 'Amerika/Cambridge_Bay',
    'America/Yellowknife' => 'Amerika/Yellowknife',
    'America/Inuvik' => 'Amerika/Inuvik',
    'America/Whitehorse' => 'Amerika/Whitehorse',
    'America/Dawson' => 'Amerika/Dawson',
    'America/Cancun' => 'Amerika/Cancun',
    'America/Merida' => 'Amerika/Merida',
    'America/Monterrey' => 'Amerika/Monterrey',
    'America/Mexico_City' => 'Amerika/Mexico_City',
    'America/Chihuahua' => 'Amerika/Chihuahua',
    'America/Hermosillo' => 'Amerika/Hermosillo',
    'America/Mazatlan' => 'Amerika/Mazatlan',
    'America/Tijuana' => 'Amerika/Tijuana',
    'America/Anguilla' => 'Amerika/Anguilla',
    'America/Antigua' => 'Amerika/Antigua',
    'America/Nassau' => 'Amerika/Nassau',
    'America/Barbados' => 'Amerika/Barbados',
    'America/Belize' => 'Amerika/Belize',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'America/Cayman' => 'Amerika/Cayman',
    'America/Costa_Rica' => 'Amerika/Costa_Rica',
    'America/Havana' => 'Amerika/Havana',
    'America/Dominica' => 'Amerika/Dominica',
    'America/Santo_Domingo' => 'Amerika/Santo_Domingo',
    'America/El_Salvador' => 'Amerika/El_Salvador',
    'America/Grenada' => 'Amerika/Grenada',
    'America/Guadeloupe' => 'Amerika/Guadeloupe',
    'America/Guatemala' => 'Amerika/Guatemala',
    'America/Port-au-Prince' => 'Amerika/Port-au-Prince',
    'America/Tegucigalpa' => 'Amerika/Tegucigalpa',
    'America/Jamaica' => 'Amerika/Jamaica',
    'America/Martinique' => 'Amerika/Martinique',
    'America/Montserrat' => 'Amerika/Montserrat',
    'America/Managua' => 'Amerika/Managua',
    'America/Panama' => 'Amerika/Panama',
    'America/Puerto_Rico' => 'Amerika/Puerto_Rico',
    'America/St_Kitts' => 'Amerika/St_Kitts',
    'America/St_Lucia' => 'Amerika/St_Lucia',
    'America/Miquelon' => 'Amerika/Miquelon',
    'America/St_Vincent' => 'Amerika/St_Vincent',
    'America/Grand_Turk' => 'Amerika/Grand_Turk',
    'America/Tortola' => 'Amerika/Tortola',
    'America/St_Thomas' => 'Amerika/St_Thomas',
    'America/Argentina/Buenos_Aires' => 'Amerika/Argentina/Buenos_Aires',
    'America/Argentina/Cordoba' => 'Amerika/Argentina/Cordoba',
    'America/Argentina/Tucuman' => 'Amerika/Argentina/Tucuman',
    'America/Argentina/La_Rioja' => 'Amerika/Argentina/La_Rioja',
    'America/Argentina/San_Juan' => 'Amerika/Argentina/San_Juan',
    'America/Argentina/Jujuy' => 'Amerika/Argentina/Jujuy',
    'America/Argentina/Catamarca' => 'Amerika/Argentina/Catamarca',
    'America/Argentina/Mendoza' => 'Amerika/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'Amerika/Argentina/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'Amerika/Argentina/Ushuaia',
    'America/Aruba' => 'Amerika/Aruba',
    'America/La_Paz' => 'Amerika/La_Paz',
    'America/Noronha' => 'Amerika/Noronha',
    'America/Belem' => 'Amerika/Belem',
    'America/Fortaleza' => 'Amerika/Fortaleza',
    'America/Recife' => 'Amerika/Recife',
    'America/Araguaina' => 'Amerika/Araguaina',
    'America/Maceio' => 'Amerika/Maceio',
    'America/Bahia' => 'Amerika/Bahia',
    'America/Sao_Paulo' => 'Amerika/Sao_Paulo',
    'America/Campo_Grande' => 'Amerika/Campo_Grande',
    'America/Cuiaba' => 'Amerika/Cuiaba',
    'America/Porto_Velho' => 'Amerika/Porto_Velho',
    'America/Boa_Vista' => 'Amerika/Boa_Vista',
    'America/Manaus' => 'Amerika/Manaus',
    'America/Eirunepe' => 'Amerika/Eirunepe',
    'America/Rio_Branco' => 'Amerika/Rio_Branco',
    'America/Santiago' => 'Amerika/Santiago',
    'Pacific/Easter' => 'Stillehavet/Påskeøya',
    'America/Bogota' => 'Amerika/Bogota',
    'America/Curacao' => 'Amerika/Curacao',
    'America/Guayaquil' => 'Amerika/Guayaquil',
    'Pacific/Galapagos' => 'Stillehavet/Galapagos',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'America/Cayenne' => 'Amerika/Cayenne',
    'America/Guyana' => 'Amerika/Guyana',
    'America/Asuncion' => 'Amerika/Asuncion',
    'America/Lima' => 'Amerika/Lima',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'America/Paramaribo' => 'Amerika/Paramaribo',
    'America/Port_of_Spain' => 'Amerika/Port_of_Spain',
    'America/Montevideo' => 'Amerika/Montevideo',
    'America/Caracas' => 'Amerika/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'Favoritter';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'Favoritt';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Kontakter',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Disk',
];
$app_list_strings['token_status'] = [
    1 => 'Forespørsel',
    2 => 'Tilgang',
    3 => 'Ugyldig',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugar Bruker',
    'support_portal' => 'Supportportal',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'Kampanje',
    'email' => 'E-postadresse',
    'workflow' => 'Arbeidsflyt',
    'system' => 'System',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'Kampanje',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'Kampanje',
    'email' => 'E-postadresse',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'Dokumentasjon',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'To intervaller',
    'show_buckets' => 'Tre intervaller',
    'show_custom_buckets' => 'Egendefinerte intervaller',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'Datoen basert på år',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'Årlig (Kvartalsvis under-periode)',
    'Quarter' => 'Kvartalsvis (Månedlig under-periode)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'Omsetning linjeelementer',
    'Opportunities' => 'Muligheter',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'Ja',
    'no' => 'Nei',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'Varsel',
    'information' => 'Info',
    'other' => 'Andre',
    'success' => 'Vellykket',
    'warning' => 'Advarsel',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'FÅ',
    'PUT' => 'PUT',
    'DELETE' => 'SLETT',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'Manuellt',
    '5' => 'Hvert 5. minutt',
    '15' => 'Hvert 15. minutt',
    '30' => 'Hvert 30. minutt',
    '60' => 'Hver time',
];

$app_list_strings['moduleList']['KBDocuments'] = 'Kunnskapsbase';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'Kunnskapsbase';
$app_list_strings['moduleList']['KBContents'] = 'KB-dokumenter';
$app_list_strings['moduleListSingular']['KBContents'] = 'Kunnskapsbaseartikkel';
$app_list_strings['moduleList']['KBArticles'] = 'Kunnskapsbase-artikkel';
$app_list_strings['moduleListSingular']['KBArticles'] = 'Kunnskapsbase-artikkel';
$app_list_strings['moduleList']['KBContentTemplates'] = 'Kunnskapsbasemal';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'Kunnskapsbasemal';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'Vedlagte filer';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'Vedlagt fil';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'ДИН.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leke',
    'USD' => 'Dollar',
    'AFN' => 'Afghanis',
    'ARS' => 'Pesos',
    'AWG' => 'Gylden',
    'AUD' => 'Dollar',
    'AZN' => 'Nye Manats',
    'BSD' => 'Dollar',
    'BBD' => 'Dollar',
    'BYR' => 'Rubler',
    'EUR' => 'Euro',
    'BZD' => 'Dollar',
    'BMD' => 'Dollar',
    'BOB' => 'Bolivianos',
    'BAM' => 'Convertible Marka',
    'BWP' => 'Pulas',
    'BGN' => 'Leva',
    'BRL' => 'Reais',
    'GBP' => 'Pund',
    'BND' => 'Dollar',
    'KHR' => 'Riels',
    'CAD' => 'Dollar',
    'KYD' => 'Dollar',
    'CLP' => 'Pesos',
    'CNY' => 'Yuan Renminbi',
    'COP' => 'Pesos',
    'CRC' => 'Colón',
    'HRK' => 'Kuna',
    'CUP' => 'Pesos',
    'CZK' => 'Koruny',
    'DKK' => 'Kroner',
    'DOP' => 'Pesos',
    'XCD' => 'Dollar',
    'EGP' => 'Pund',
    'SVC' => 'Colones',
    'EEK' => 'Krooni',
    'FKP' => 'Pund',
    'FJD' => 'Dollar',
    'GHC' => 'Cedis',
    'GIP' => 'Pund',
    'GTQ' => 'Quetzales',
    'GGP' => 'Pund',
    'GYD' => 'Dollar',
    'HNL' => 'Lempiras',
    'HKD' => 'Dollar',
    'HUF' => 'Forint',
    'ISK' => 'Kronur',
    'INR' => 'Rupi',
    'IDR' => 'Rupiah',
    'IRR' => 'Rial',
    'IMP' => 'Pund',
    'ILS' => 'Nye sekel',
    'JMD' => 'Dollar',
    'JPY' => 'Yen',
    'JEP' => 'Pund',
    'KZT' => 'Tenge',
    'KPW' => 'Vunnet',
    'KRW' => 'Vunnet',
    'KGS' => 'Somer',
    'LAK' => 'Kips',
    'LVL' => 'Lati',
    'LBP' => 'Pund',
    'LRD' => 'Dollar',
    'CHF' => 'Sveitsiske franc',
    'LTL' => 'Litai',
    'MKD' => 'Denarer',
    'MYR' => 'Ringgit',
    'MUR' => 'Rupi',
    'MXN' => 'Pesos',
    'MNT' => 'Tugrik',
    'MZN' => 'Meticais',
    'NAD' => 'Dollar',
    'NPR' => 'Rupi',
    'ANG' => 'Gylden',
    'NZD' => 'Dollar',
    'NIO' => 'Cordobas',
    'NGN' => 'Nairas',
    'NOK' => 'Krone',
    'OMR' => 'Rial',
    'PKR' => 'Rupi',
    'PAB' => 'Balboa',
    'PYG' => 'Guarani',
    'PEN' => 'Nuevos såler',
    'PHP' => 'Pesos',
    'PLN' => 'Zlotych',
    'QAR' => 'Rial',
    'RON' => 'Nye lei',
    'RUB' => 'Rubler',
    'SHP' => 'Pund',
    'SAR' => 'Riyal',
    'RSD' => 'Dinarer',
    'SCR' => 'Rupi',
    'SGD' => 'Dollar',
    'SBD' => 'Dollar',
    'SOS' => 'Shilling',
    'ZAR' => 'Rand',
    'LKR' => 'Rupi',
    'SEK' => 'Kroner',
    'SRD' => 'Dollar',
    'SYP' => 'Pund',
    'TWD' => 'Nye dollar',
    'THB' => 'Baht',
    'TTD' => 'Dollar',
    'TRY' => 'Lire',
    'TRL' => 'Lirer',
    'TVD' => 'Dollar',
    'UAH' => 'Hryvnia',
    'UYU' => 'Pesos',
    'UZS' => 'Sum',
    'VEF' => 'Bolivares Fuertes',
    'VND' => 'Dong',
    'YER' => 'Rial',
    'ZWD' => 'Zimbabwe dollar',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'Veldig høy',
    '4' => 'Høy',
    '3' => 'Nøytral',
    '2' => 'Lav',
    '1' => 'Veldig lav',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'Ingen',
    'future' => 'Gjeldende verdi',
    'old' => 'Gammel verdi',
    'both' => 'Nåværende og gamle verdier',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Enkelttreff',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'Behandler',
    'error' => 'Feil',
    'success' => 'Suksess',
    'canceled' => 'Avbrutt',
    'document_load' => 'Laste mal',
    'tags_extract' => 'Hente ut etiketter',
    'tags_validate' => 'Validere etiketter',
    'data_retrieving' => 'Hente data',
    'serialize_document' => 'Sette dokumentet sammen igjen',
    'send_document' => 'Sende dokumentet til deg',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'Flett sammen',
    'convert' => 'PDF-sammenfletting',
    'multimerge' => 'Multisammenfletting',
    'multimerge_convert' => 'Multisammenflettings-PDF',
    'labelsgenerate' => 'Generer etiketter',
    'labelsgenerate_convert' => 'Generer etikett-PDF',
    'excel' => 'Excel-sammenfletting',
    'excel_convert' => 'Konverter Excel-sammenfletting',
    'presentation' => 'PowerPoint-sammenfletting',
    'presentation_convert' => 'PowerPoint Merge PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'Mine kontoer',
    'favorites' => 'Favorittkontoer',
    'tags' => 'Taggede kontoer',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'Alle nyheter',
    'General' => 'Generelt',
    'Finance' => 'Økonomi',
    'People' => 'Personell',
    'Press Releases' => 'Pressemeldinger',
    'Other' => 'Annet',
];

$app_strings['LBL_OWNERS'] = 'Eiere';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Skydisk';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'Skydisk dashlet for integrering';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'Kopier lenke';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'Last ned';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Opprett Sugar-dokument';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'Kunne ikke laste ned denne filen';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'Sky dashlet foreligger ikke';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar-dokument opprettet';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'Send til DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign er ikke tilgjengelig fra denne plasseringen.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'Dokumentfletting til Word/Excel/PowerPoint er ikke tilgjengelig fra denne plasseringen';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'Dokumentfletting til DocuSign er ikke tilgjengelig fra denne plasseringen';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'Dokumentfletting til PDF er ikke tilgjengelig fra denne plasseringen';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'Den signerte filen lastes bare opp her hvis du har tillatelse til å laste opp på denne plasseringen.';
$app_strings['LBL_DOC_MERGE_TO'] = 'Dokumentfletting til';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'Mine filer';
$app_strings['LBL_SHARED_WITH_ME'] = 'Delt med meg';
$app_strings['LBL_CLOUD_PROVIDER'] = 'Skyleverandør';

$app_list_strings['drive_types'] = [
    'google' => 'Google Disk',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'Delt med meg';
$app_strings['LBL_MY_FILES'] = 'Mine filer';
$app_strings['LBL_UPLOAD_FILE'] = 'Last opp fil';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'Mappe ikke funnet';
$app_strings['LBL_CREATE_FOLDER'] = 'Opprett mappe';
$app_strings['LBL_LOAD_MORE'] = 'Last mer...';
$app_strings['LBL_NEW_FOLDER'] = 'Ny mappe';
$app_strings['LBL_FOLDER_NAME'] = 'Mappenavn: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'Du har ikke tillatelse til å gjøre det på den gjeldende banen.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'Du har ikke tillatelse til å gå på den gjeldende banen.';
$app_strings['LBL_FILE_UPLOADED'] = 'Filen er lastet opp.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'På grunn av den store størrelsen på filen din, vil opplastingen ta en stund.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'En eller flere dokumentlogger har ikke en vedlagt fil. Legg ved filer til loggene og prøv igjen, eller synkroniser spesifikke logger med filer individuelt.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Forbindelse med Google ikke funnet...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Forbindelse med Microsoft ikke funnet...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Fant ikke forbindelse med Dropbox ...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'Synkronisering med OneDrive kan ta en stund';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'Er du sikker på at du vil slette denne filen?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDrive-opplastingen er fullført.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' har blitt lastet opp.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'Feil under lasting av baner.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'Det har oppstått en feil fordi filen er skadet.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'Dokumentet <i>"{{documentName}}"</i> er lagret i skystasjonen din, og lagt til Dokumenter-modulen.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'Du har ikke tillatelse til å slette denne filen.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'Du har ikke tillatelse til å slette denne mappen.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'Du har ikke tillatelse til å laste opp filer til denne plasseringen.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'Du har ikke tillatelse til å opprette en mappe i denne plasseringen.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'Mapper kan ikke opprettes i denne plasseringen.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'Filer kan ikke lastes opp til denne plasseringen.';
$app_strings['LBL_SITES'] = 'Nettsteder';
$app_strings['LBL_SHARED'] = 'Delt';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'Lenke opprettet. Klikk på knappen for å kopiere lenken til utklippstavlen.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'Kopier til utklippstavle';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-tom-',
    'Exact' => 'Eksakt',
    'Null_address_components' => 'En eller flere tomme adressekomponenter',
    'Invalid_address' => 'Ugyldig adresse, server returnerte feil',
    'Invalid_server_response_not_XML' => 'Ugyldig serverrespons, ikke XML',
    'Invalid_address_no_location' => 'Ugyldig adresse, server returnerte ingen lokalisering',
    'Ambiguous_address' => 'Uklar adresse, flere samsvar',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'Vei',
    'a' => 'Luft',
    'rd' => 'Mørk vei',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'Engelsk (US)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'New York (EST)'],
    ['pst', 'Los Angeles (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['Ny', 'Ny'],
    ['Tildelt', 'Tildelt'],
    ['Lukket', 'Lukket'],
    ['Venter på informasjon', 'Venter på informasjon'],
    ['Avvist', 'Avvist'],
    ['Dupliser', 'Dupliser'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['Administrasjon', 'Administrasjon'],
    ['Produkt', 'Produkt'],
    ['Bruker', 'Bruker'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'Høy'],
    ['P2', 'Medium'],
    ['P3', 'Lav'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['bruker', 'Bruker'],
    ['admin, bruker', 'Administrator'],
    ['kontoadministrator, bruker', 'Kontoadministrator'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', 'Siste 30 dager'],
    ['last_90_days', 'Siste 90 dager'],
    ['this_year', 'Forrige år'],
    ['tilpasset', 'Egendefinert intervall'],
    ['alle', 'Alle'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['Standard', 'Standard'],
    ['Farge', 'Heltrukket farge'],
    ['Url', 'Egendefinert bilde'],
];
