<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'US angļu',
    'moduleList' => [
        'Home' => 'Sākums',
        'Contacts' => 'Kontaktpersonas',
        'Accounts' => 'Uzņēmumi',
        'Opportunities' => 'Iespējas',
        'Cases' => 'Pieteikumi',
        'Notes' => 'Piezīmes',
        'Calls' => 'Zvani',
        'Emails' => 'E-pasti',
        'Meetings' => 'Tikšanās',
        'Tasks' => 'Uzdevumi',
        'Calendar' => 'Kalendārs',
        'Leads' => 'Interesenti',
        'Currencies' => 'Valūtas',
        'Contracts' => 'Līgumi',
        'Quotes' => 'Piedāvājumi',
        'Products' => 'Piedāvājuma rindas',
        'WebLogicHooks' => 'Web Logic Hooks',
        'ProductCategories' => 'Produktu kategorijas',
        'ProductTypes' => 'Produktu tipi',
        'ProductTemplates' => 'Produktu katalogs',
        'ProductBundles' => 'Produktu pakas',
        'ProductBundleNotes' => 'Produktu pakas piezīmes',
        'Reports' => 'Atskaites',
        'Forecasts' => 'Prognozes',
        'ForecastWorksheets' => 'Prognožu darblapas',
        'ForecastManagerWorksheets' => 'Prognožu menedžera darblapas',
        'VisualPipeline' => 'Vizuālā piltuve',
        'ConsoleConfiguration' => 'Konsoles konfigurācija',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'Kvotas',
        'Teams' => 'Darba grupas',
        'TeamNotices' => 'Darba grupas ziņojumi',
        'Manufacturers' => 'Ražotāji',
        'Activities' => 'Darbības',
        'Comments' => 'Komentāri',
        'Subscriptions' => 'Abonementi',
        'Bugs' => 'Kļūdas',
        'Feeds' => 'RSS barotnes',
        'iFrames' => 'Manas vietnes',
        'TimePeriods' => 'Laika periodi',
        'TaxRates' => 'Nodokļa likmes',
        'ContractTypes' => 'Līgumu veidi',
        'Schedulers' => 'Plānotāji',
        'Project' => 'Projekti',
        'ProjectTask' => 'Projekta uzdevumi',
        'Campaigns' => 'Kampaņas',
        'CampaignLog' => 'Kampaņas žurnāls',
        'CampaignTrackers' => 'Kampaņas sekotāji',
        'Documents' => 'Dokumenti',
        'DocumentRevisions' => 'Dokumenta versijas',
        'Connectors' => 'Konektori',
        'Notifications' => 'Paziņojumi',
        'Sync' => 'Sinhronizācija',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => 'Ārējie lietotāji',
        'ReportMaker' => 'Izvērstās atskaites',
        'DataSets' => 'Datu formāts',
        'CustomQueries' => 'Pielāgotie vaicājumi',
        'pmse_Inbox' => 'Procesi',
        'pmse_Project' => 'Procesu definīcijas',
        'pmse_Business_Rules' => 'Procesa biznesa lomas',
        'pmse_Emails_Templates' => 'Procesa e-pasta sagataves',
        'BusinessCenters' => 'Biznesa centri',
        'Shifts' => 'Maiņas',
        'ShiftExceptions' => 'Maiņas izņēmumi',
        'Purchases' => 'Pirkumi',
        'PurchasedLineItems' => 'Iegādātie produkti',
        'MobileDevices' => 'Mobilās ierīces',
        'PushNotifications' => 'Pašpiegādes paziņojumi',
        'Escalations' => 'Eskalācijas',
        'DocumentTemplates' => 'Dokumenta veidnes',
        'DocumentMerges' => 'Dokumentu sapludināšanas',
        'CloudDrivePaths' => 'Mākoņa diska ceļi',
        'WorkFlow' => 'Darbplūsmu definīcijas',
        'EAPM' => 'Ārējais konts',
        'Worksheet' => 'Darblapa',
        'Users' => 'Lietotāji',
        'Employees' => 'Darbinieki',
        'Administration' => 'Administrēšana',
        'ACLRoles' => 'Lomas',
        'InboundEmail' => 'Grupas Pasta konts',
        'Releases' => 'Laidieni',
        'Prospects' => 'Mērķi',
        'Queues' => 'Rindas',
        'EmailMarketing' => 'E-pasta mārketings',
        'EmailTemplates' => 'E-pasta veidnes',
        'SNIP' => 'E-pasta arhivēšana',
        'ProspectLists' => 'Mērķu saraksts',
        'SavedSearch' => 'Saglabātie meklējumi',
        'UpgradeWizard' => 'Atjauninājuma vednis',
        'Trackers' => 'Sekotāji',
        'TrackerPerfs' => 'Sekotāja veiktspēja',
        'TrackerSessions' => 'Sekotāja sesijas',
        'TrackerQueries' => 'Sekotāja vaicājumi',
        'FAQ' => 'BUJ',
        'Newsletters' => 'Biļeteni',
        'SugarFavorites' => 'Favorīti',
        'PdfManager' => 'PDF pārvaldnieks',
        'DataArchiver' => 'Datu arhivētājs',
        'ArchiveRuns' => 'Arhīvs darbojas',

        'OAuthKeys' => 'OAuth patērētāja atslēgas',
        'OAuthTokens' => 'OAuth atslēgas',
        'Filters' => 'Filtri',
        'UserSignatures' => 'E-pasta paraksti',
        'Shippers' => 'Piegādātāji',
        'Styleguide' => 'Styleguide',
        'Feedbacks' => 'Atsauksmes',
        'Tags' => 'Birkas',
        'Categories' => 'Kategorijas',
        'Dashboards' => 'Instrumentu paneļi',
        'OutboundEmail' => 'E-pasta iestatījumi',
        'EmailParticipants' => 'E-pasta dalībnieki',
        'DataPrivacy' => 'Datu privātums',
        'ReportSchedules' => 'Pārskatu grafiki',
        'CommentLog' => 'Komentāru žurnāls',
        'Holidays' => 'Brīvdienas',
        'ChangeTimers' => 'Mainīt taimerus',
        'Metrics' => 'Metrika',
        'Messages' => 'Ziņojumi',
        'Audit' => 'Audits',
        'RevenueLineItems' => 'Ieņēmumu posteņi',
        'DocuSignEnvelopes' => 'DocuSign aploksnes',
        'Geocode' => 'Ģeokods',
        'DRI_Workflows' => 'Smart Guides',
        'DRI_Workflow_Task_Templates' => 'Smart Guide aktivitātes veidnes',
        'DRI_SubWorkflows' => 'Smart Guide posmi',
        'DRI_Workflow_Templates' => 'Smart Guide veidnes',
        'CJ_WebHooks' => 'Sugar Automate tīmekļa pārtvērēji',
        'CJ_Forms' => 'Smart Guide Sugar darbības',
        'DRI_SubWorkflow_Templates' => 'Smart Guide posma veidnes',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub moduļa notikumu pašpiegādes abonementi',
    ],

    'moduleIconList' => [
        'Home' => 'Sā',
        'Contacts' => 'Ko',
        'Accounts' => 'Uz',
        'Opportunities' => 'Da',
        'Cases' => 'Pt',
        'Notes' => 'Pz',
        'Calls' => 'Zv',
        'Emails' => 'Ep',
        'Meetings' => 'Ti',
        'Tasks' => 'Uz',
        'Calendar' => 'Ka',
        'Leads' => 'In',
        'Currencies' => 'Va',
        'Contracts' => 'Ko',
        'Quotes' => 'Pi',
        'Products' => 'PR',
        'WebLogicHooks' => 'WL',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'PT',
        'ProductTemplates' => 'PV',
        'ProductBundles' => 'PP',
        'ProductBundleNotes' => 'PP',
        'Reports' => 'At',
        'Forecasts' => 'Pr',
        'ForecastWorksheets' => 'PD',
        'ForecastManagerWorksheets' => 'PM',
        'Quotas' => 'Fo',
        'VisualPipeline' => 'VP',
        'ConsoleConfiguration' => 'KK',
        'SugarLive' => 'Su',
        'Teams' => 'Dg',
        'TeamNotices' => 'DZ',
        'Manufacturers' => 'Ra',
        'Activities' => 'Da',
        'Comments' => 'Ko',
        'Subscriptions' => 'Ab',
        'Bugs' => 'Kļ',
        'Feeds' => 'RS',
        'iFrames' => 'MS',
        'TimePeriods' => 'LP',
        'TaxRates' => 'NL',
        'ContractTypes' => 'LT',
        'Schedulers' => 'Gr',
        'Project' => 'Pr',
        'ProjectTask' => 'PU',
        'Campaigns' => 'Ka',
        'CampaignLog' => 'KŽ',
        'CampaignTrackers' => 'KS',
        'Documents' => 'Do',
        'DocumentRevisions' => 'DV',
        'Connectors' => 'Ko',
        'Notifications' => 'Pa',
        'Sync' => 'Si',
        'HintAccountsets' => 'Hi',
        'HintNotificationTargets' => 'Hi',
        'HintNewsNotifications' => 'Hi',
        'HintEnrichFieldConfigs' => 'Hi',
        'ExternalUsers' => 'ĀL',
        'ReportMaker' => 'AV',
        'DataSets' => 'DK',
        'CustomQueries' => 'PV',
        'pmse_Inbox' => 'Pr',
        'pmse_Project' => 'PD',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE',
        'BusinessCenters' => 'BC',
        'Shifts' => 'Ma',
        'ShiftExceptions' => 'MI',
        'Purchases' => 'Pi',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'Mo',
        'PushNotifications' => 'Pa',
        'Escalations' => 'Es',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'DP',
        'EAPM' => 'EA',
        'Worksheet' => 'Da',
        'Users' => 'Li',
        'Employees' => 'Da',
        'Administration' => 'Ad',
        'ACLRoles' => 'Lo',
        'InboundEmail' => 'IE',
        'Releases' => 'La',
        'Prospects' => 'Pk',
        'Queues' => 'Ri',
        'EmailMarketing' => 'EM',
        'EmailTemplates' => 'EV',
        'SNIP' => 'EA',
        'ProspectLists' => 'MS',
        'SavedSearch' => 'SM',
        'UpgradeWizard' => 'AV',
        'Trackers' => 'Se',
        'TrackerPerfs' => 'SV',
        'TrackerSessions' => 'SS',
        'TrackerQueries' => 'SP',
        'FAQ' => 'BU',
        'Newsletters' => 'Bi',
        'SugarFavorites' => 'Fa',
        'PdfManager' => 'PM',
        'DataArchiver' => 'DA',
        'ArchiveRuns' => 'AD',
        'OAuthKeys' => 'OC',
        'OAuthTokens' => 'OT',
        'Filters' => 'Fi',
        'UserSignatures' => 'LP',
        'Shippers' => 'No',
        'Styleguide' => 'St',
        'Feedbacks' => 'At',
        'Tags' => 'Bi',
        'Categories' => 'Ka',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'IE',
        'EmailParticipants' => 'ED',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'AG',
        'CommentLog' => 'KŽ',
        'Holidays' => 'Br',
        'ChangeTimers' => 'MT',
        'Metrics' => 'Me',
        'Messages' => 'Zi',
        'Audit' => 'Au',
        'RevenueLineItems' => 'IP',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'Ģe',
        'DRI_Workflows' => 'SG',
        'DRI_Workflow_Task_Templates' => 'SG',
        'DRI_SubWorkflows' => 'SG',
        'DRI_Workflow_Templates' => 'SG',
        'CJ_WebHooks' => 'SA',
        'CJ_Forms' => 'SG',
        'DRI_SubWorkflow_Templates' => 'SG',
        'Library' => 'Bi',
        'EmailAddresses' => 'EA',
        'Words' => 'Vā',
        'Sugar_Favorites' => 'Iz',
        'KBDocuments' => 'KB',
        'KBContents' => 'KB',
        'KBArticles' => 'KB',
        'KBContentTemplates' => 'KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'IF',
    ],

    'moduleListSingular' => [
        'Home' => 'Sākums',
        'Dashboards' => 'Instrumentu panelis',
        'Styleguide' => 'Styleguide',
        'Contacts' => 'Kontaktpersona',
        'Accounts' => 'Uzņēmums',
        'Opportunities' => 'Iespēja',
        'Cases' => 'Pieteikums',
        'Notes' => 'Piezīme',
        'Calls' => 'Zvans',
        'Emails' => 'Jebkāds e-pasts',
        'Meetings' => 'Tikšanās',
        'Tasks' => 'Uzdevums',
        'Calendar' => 'Kalendārs',
        'Leads' => 'Interesents',
        'Manufacturers' => 'Ražotājs',
        'VisualPipeline' => 'Vizuālā piltuve',
        'ConsoleConfiguration' => 'Konsoles konfigurācija',
        'MobileDevices' => 'Mobilā ierīce',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'Līgums',
        'Quotes' => 'Piedāvājums',
        'Products' => 'Piedāvājuma rinda',
        'ProductCategories' => 'Produktu kategorija',
        'ProductBundles' => 'Produktu paka',
        'ProductBundleNotes' => 'Produktu pakas piezīme',
        'RevenueLineItems' => 'Ieņēmumu postenis',
        'WebLogicHooks' => 'Web Logic Hook',
        'Reports' => 'Atskaite',
        'Forecasts' => 'Prognoze',
        'ForecastWorksheets' => 'Prognozes darblapa',
        'ForecastManagerWorksheets' => 'Prognožu menedžera darblapa',
        'Quotas' => 'Kvota',
        'Teams' => 'Darba grupa',
        'TeamNotices' => 'Darba grupas ziņojums',
        'Activities' => 'Darbības',
        'ActivityStream' => 'Darbības',
        'Bugs' => 'Kļūda',
        'Feeds' => 'RSS barotnes',
        'iFrames' => 'Manas vietnes',
        'TimePeriods' => 'Laika posms',
        'TaxRates' => 'Nodokļa likme',
        'ContractTypes' => 'Līguma veids',
        'Schedulers' => 'Plānotājs',
        'Campaigns' => 'Kampaņa',
        'CampaignLog' => 'Kampaņas žurnāls',
        'Project' => 'Projekts',
        'ProjectTask' => 'Projekta uzdevums',
        'Prospects' => 'Mērķis',
        'ProspectLists' => 'Mērķu saraksts',
        'CampaignTrackers' => 'Kampaņas sekotājs',
        'Documents' => 'Dokuments',
        'DocumentRevisions' => 'Dokumenta versija',
        'Connectors' => 'Konektors',
        'Notifications' => 'Paziņojums',
        'Sync' => 'Sinhronizācija',
        'PdfManager' => 'PDF pārvaldnieks',
        'DataArchiver' => 'Datu arhivētājs',
        'ArchiveRuns' => 'Arhīvs darbojas',
        'ExternalUsers' => 'Ārējais lietotājs',
        'ReportMaker' => ' Izvērstā atskaite',
        'DataSets' => 'Datu formāts',
        'CustomQueries' => 'Pielāgots vaicājums',
        'pmse_Inbox' => 'Process',
        'pmse_Project' => 'Procesu definīcijas',
        'pmse_Business_Rules' => 'Procesa biznesa lomas',
        'pmse_Emails_Templates' => 'E-pasta šablona apstrāde',
        'BusinessCenters' => 'Biznesa centrs',
        'Shifts' => 'Maiņa',
        'ShiftExceptions' => 'Maiņas izņēmumi',
        'Purchases' => 'Pirkums',
        'PurchasedLineItems' => 'Iegādātais produkts',
        'PushNotifications' => 'Pašpiegādes paziņojums',
        'Escalations' => 'Eskalācija',
        'DocumentTemplates' => 'Dokumenta veidne',
        'DocumentMerges' => 'Dokumentu sapludināšana',
        'CloudDrivePaths' => 'Mākoņa diska ceļš',
        'WorkFlow' => 'Darbplūsma',
        'EAPM' => 'Ārējais konts',
        'Worksheet' => 'Darblapa',
        'Users' => 'Lietotājs',
        'SugarFavorites' => 'Sugar Favorīti',
        'Employees' => 'Darbinieks',
        'Administration' => 'Administrēšana',
        'ACLRoles' => 'Loma',
        'InboundEmail' => 'Grupas Pasta konts',
        'Releases' => 'Laidiens',
        'Queues' => 'Rinda',
        'EmailMarketing' => 'E-pasta mārketings',
        'EmailTemplates' => 'E-pasta veidne',
        'SNIP' => 'E-pasta arhivēšana',
        'SavedSearch' => 'Saglabātais meklējums',
        'UpgradeWizard' => 'Atjauninājuma vednis',
        'Trackers' => 'Sekotājs',
        'TrackerPerfs' => 'Sekotāja veiktspēja',
        'TrackerSessions' => 'Sekotāja sesija',
        'TrackerQueries' => 'Sekotāja vaicājums',
        'FAQ' => 'BUJ',
        'Newsletters' => 'Biļetens',
        'OAuthKeys' => 'OAuth patērētāja atslēga',
        'OAuthTokens' => 'OAuth atslēga',
        'Filters' => 'Filtrs',
        'Comments' => 'Komentārs',
        'CommentLog' => 'Komentāru žurnāls',
        'Currencies' => 'Valūta',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'Produkta veids',
        'Shippers' => 'Piegādātājs',
        'Subscriptions' => 'Pierakstīšanās',
        'UserSignatures' => 'E-pasta paraksts',
        'Feedbacks' => 'Atsauksme',
        'Tags' => 'Birka',
        'Categories' => 'Kategorija',
        'OutboundEmail' => 'E-pasta iestatījums',
        'EmailParticipants' => 'E-pasta dalībnieks',
        'DataPrivacy' => 'Datu privātums',
        'ReportSchedules' => 'Pārskata grafiks',
        'Holidays' => 'Brīvdiena',
        'ChangeTimers' => 'Mainīt taimeri',
        'Metrics' => 'Metrisks',
        'Messages' => 'Ziņojums',
        'Audit' => 'Audits',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => 'Ģeokods',
        'DRI_Workflows' => 'Smart Guide',
        'DRI_Workflow_Task_Templates' => 'Smart Guide aktivitātes veidne',
        'DRI_SubWorkflows' => 'Smart Guide posms',
        'DRI_Workflow_Templates' => 'Smart Guide veidne',
        'CJ_WebHooks' => 'Sugar Automate tīmekļa pārtvērējs',
        'CJ_Forms' => 'Smart Guide Sugar darbība',
        'DRI_SubWorkflow_Templates' => 'Smart Guide posma veidne',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub moduļa notikumu pašpiegādes abonements',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'Jā',
        '2' => 'Nē',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'Nē',
        1 => 'Jā',
    ],

    'notifications_status_dom' => [
        0 => 'Nelasīts',
        1 => 'Izlasīts',
    ],

    'optout_dom' => [
        '' => '-Nav norādīts-',
        'false' => 'Nē',
        'true' => 'Jā',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'Analītiķis',
        'Competitor' => 'Konkurents',
        'Customer' => 'Klients',
        'Integrator' => 'Integrators',
        'Investor' => 'Investors',
        'Partner' => 'Partneris',
        'Press' => 'Prese',
        'Prospect' => 'Potenciāls klients',
        'Reseller' => 'Izplatītājs',
        'Other' => 'Cits',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'Apģērbi',
        'Banking' => 'Banku pakalpojumi',
        'Biotechnology' => 'Biotehnoloģija',
        'Chemicals' => 'Ķīmiskā rūpniecība',
        'Communications' => 'Komunikācijas',
        'Construction' => 'Celtniecība',
        'Consulting' => 'Konsultācijas',
        'Education' => 'Izglītība',
        'Electronics' => 'Elektronika',
        'Energy' => 'Enerģētika',
        'Engineering' => 'Inženierija',
        'Entertainment' => 'Izklaide',
        'Environmental' => 'Vides aizsardzība',
        'Finance' => 'Finanses',
        'Government' => 'Valdība',
        'Healthcare' => 'Veselības aprūpe',
        'Hospitality' => 'Izmitināšana',
        'Insurance' => 'Apdrošināšana',
        'Machinery' => 'Mašīnbūve',
        'Manufacturing' => 'Ražošana',
        'Media' => 'Mēdiji',
        'Not For Profit' => 'Bezpeļņas organizācija',
        'Recreation' => 'Rehabilitācija',
        'Retail' => 'Mazumtirdzniecība',
        'Shipping' => 'Piegādes pakalpojumi',
        'Technology' => 'Tehnoloģijas',
        'Telecommunications' => 'Telekomunikācijas',
        'Transportation' => 'Transports',
        'Utilities' => 'Komunālie pakalpojumi',
        'Other' => 'Cits',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF un CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'Diagramma',
        'Data Table' => 'Datu tabula',
        'Chart and Data Table' => 'Diagramma un datu tabula',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'Procesā',
        'Completed' => 'Pabeigts',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'Ienākošs',
        'Outbound' => 'Izejošs',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'Tērzēšana',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'Līmenis 1',
        'T2' => 'Līmenis 2',
        'T3' => 'Līmenis 3',
        'T4' => 'Līmenis 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'Jā',
        'No' => 'Nē',
        'Completed' => 'Pabeigts',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'Nākotnē',
        'Active' => 'Aktīvs',
        'Past' => 'Pagātnē',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'Pašģenerēts',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'Darījuma zvans',
        'Existing Customer' => 'Esošs klients',
        'Self Generated' => 'Pašģenerēts',
        'Employee' => 'Darbinieks',
        'Partner' => 'Partneris',
        'Public Relations' => 'Sabiedriskās attiecības',
        'Direct Mail' => 'Tiešais pasts',
        'Conference' => 'Konference',
        'Trade Show' => 'Nozares izstāde',
        'Web Site' => 'Mājaslapa',
        'Word of mouth' => 'Mutiska rekomendācija',
        'Email' => 'Jebkāds e-pasts',
        'Campaign' => 'Kampaņa',
        'Support Portal User Registration' => 'Atbalsta portāla lietotāja reģistrācija',
        'Other' => 'Cits',
    ],
    'metric_status_dom' => [
        'Inactive' => 'Neaktīvs',
        'Active' => 'Aktīvs',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'Esošs uzņēmums',
        'New Business' => 'Jauns uzņēmums',
    ],
    'taxrate_status_dom' => [
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
    ],
    'roi_type_dom' => [
        'Revenue' => 'Ieņēmumi',
        'Investment' => 'Investīcija',
        'Expected_Revenue' => 'Paredzamie ieņēmumi',
        'Budget' => 'Budžets',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'Galvenais lēmumu pieņēmējs',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Galvenais lēmumu pieņēmējs',
        'Business Decision Maker' => 'Biznesa lēmumpieņēmējs',
        'Business Evaluator' => 'Biznesa novērtētājs',
        'Technical Decision Maker' => 'Tehniskais lēmumpieņēmējs',
        'Technical Evaluator' => 'Tehniskais vērtētājs',
        'Executive Sponsor' => 'Vadošais sponsors',
        'Influencer' => 'Ietekmētājs',
        'Other' => 'Cits',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
    ],

    'shipper_status_dom' => [
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'Galvenā kontaktpersona',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'Galvenā kontaktpersona',
        'Alternate Contact' => 'Alternatīvā kontaktpersona',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'Blakus lauka vērtība',
        'field_on_top' => 'Augšējā lauka vērtība',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => '15 dienas',
        'Net 30' => '30 dienas',
    ],
    'sales_stage_default_key' => 'Izpēte',
    'fts_type' => [
        'Elastic' => 'Elastīgā meklēšana',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'Izpēte',
        'Qualification' => 'Kvalifikācija',
        'Needs Analysis' => 'Nepieciešama analīze',
        'Value Proposition' => 'Vērtības piedāvājums',
        'Id. Decision Makers' => 'Lēmumpieņēmēju identificēšana',
        'Perception Analysis' => 'Uztveres analīze',
        'Proposal/Price Quote' => 'Ierosinājums/Cenas piedāvājums',
        'Negotiation/Review' => 'Pārrunas/Caurskate',
        'Closed Won' => 'Slēgts',
        'Closed Lost' => 'Aizvērts bez panākumiem',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'Jauns',
        'In Progress' => 'Procesā',
        'Closed Won' => 'Slēgts',
        'Closed Lost' => 'Aizvērts bez panākumiem',
        'Converted to Quote' => 'Konvertēt uz piedāvājumu',
    ],
    'sales_status_dom' => [
        'New' => 'Jauns',
        'In Progress' => 'Procesā',
        'Closed Won' => 'Slēgts',
        'Closed Lost' => 'Aizvērts bez panākumiem',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'Iekļaut',
        'exclude' => 'Neiekļaut',
    ],
    'commit_stage_dom' => [
        'include' => 'Iekļaut',
        'upside' => 'Augšup',
        'exclude' => 'Neiekļaut',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'Iekļaut',
        'upside' => 'Augšup',
        'exclude' => 'Neiekļaut',
    ],

    'in_total_group_stages' => [
        'Draft' => 'Uzmetums',
        'Negotiation' => 'Pārrunu procesā',
        'Delivered' => 'Piegādāts',
        'On Hold' => 'Apturēts',
        'Confirmed' => 'Apstiprināts',
        'Closed Accepted' => 'Aizvērts - akceptēts',
        'Closed Lost' => 'Aizvērts bez panākumiem',
        'Closed Dead' => 'Aizvērts - bezcerīgs',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'Zvans',
        'Meeting' => 'Tikšanās',
        'Task' => 'Uzdevums',
        'Email' => 'Jebkāds e-pasts',
        'Note' => 'Piezīme',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'A. god.',
        'Ms.' => 'Ļ. cien.',
        'Mrs.' => 'Ļ. cien.',
        'Dr.' => 'Dr.',
        'Prof.' => 'Prof.',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'Neviens',
        60 => '1 minūti pirms',
        300 => '5 minūtes pirms',
        600 => '10 minūtes pirms',
        900 => '15 minūtes pirms',
        1800 => '30 minūtes pirms',
        3600 => '1 stundu pirms',
        7200 => '2 stundas pirms',
        10800 => '3 stundas pirms',
        18000 => '5 stundas pirms',
        86400 => '1 dienu pirms',
        ],

        'task_priority_default' => 'Vidējs',
        'task_priority_dom' => [
        'High' => 'Augsta',
        'Medium' => 'Vidējs',
        'Low' => 'Zema',
        ],
        'task_status_default' => 'Nav sākts',
        'task_status_dom' => [
        'Not Started' => 'Nav sākts',
        'In Progress' => 'Procesā',
        'Completed' => 'Pabeigts',
        'Pending Input' => 'Gaida ievadi',
        'Deferred' => 'Atlikts',
        'Not Applicable' => 'Nav piemērojams',
        ],
        'meeting_status_default' => 'Plānots',
        'meeting_status_dom' => [
        'Planned' => 'Ieplānots',
        'Held' => 'Noticis',
        'Not Held' => 'Atcelts',
        'Deferred' => 'Atlikts',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'Cits',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'Plānots',
        'call_status_dom' => [
        'Planned' => 'Ieplānots',
        'In Progress' => 'Procesā',
        'Held' => 'Noticis',
        'Not Held' => 'Atcelts',
        'Deferred' => 'Atlikts',
        ],
        'call_direction_default' => 'Izejošs',
        'call_direction_dom' => [
        'Inbound' => 'Ienākošs',
        'Outbound' => 'Izejošs',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'Jauns',
        'Assigned' => 'Nodots',
        'In Process' => 'Procesā',
        'Converted' => 'Konvertēts',
        'Recycled' => 'Atkārtotā procesā',
        'Dead' => 'Izbeigts',
        ],
        'gender_list' => [
        'male' => 'Vīrietis',
        'female' => 'Sieviete',
        'other' => 'Cits',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'Jauns',
        'case_status_dom' => [
        'New' => 'Jauns',
        'Assigned' => 'Nodota',
        'Closed' => 'Aizvērts',
        'Pending Input' => 'Gaida ievadi',
        'Rejected' => 'Noraidīts',
        'Duplicate' => 'Dubultot',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'Augsta',
        'P2' => 'Vidējs',
        'P3' => 'Zema',
        ],
        'user_type_dom' => [
        'RegularUser' => 'Parasts lietotājs',
        'Administrator' => 'Administrators',
        ],
        'user_type_bool_dom' => [
            false => 'Parasts lietotājs',
            true => 'Administrators',
        ],
        'user_type_group_bool_dom' => [
            true => 'Grupas lietotājs',
        ],
        'user_type_portal_bool_dom' => [
            true => 'Portāla API lietotājs',
        ],
        'license_type_dom' => [
        'CURRENT' => 'Pašreizējais produkts',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
        ],
        'employee_status_dom' => [
        'Active' => 'Aktīvs',
        'Terminated' => 'Pārtrauktas darba attiecības',
        'Leave of Absence' => 'Atvaļinājumā',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
        ],
        'project_task_priority_options' => [
        'High' => 'Augsta',
        'Medium' => 'Vidējs',
        'Low' => 'Zema',
        ],
        'project_task_priority_default' => 'Vidējs',

        'project_task_status_options' => [
        'Not Started' => 'Nav sākts',
        'In Progress' => 'Procesā',
        'Completed' => 'Pabeigts',
        'Pending Input' => 'Gaida ievadi',
        'Deferred' => 'Atlikts',
        ],
        'project_task_utilization_options' => [
        '0' => 'neviens',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'Uzmetums',
        'In Review' => 'Vērtēšanā',
        'Published' => 'Nopublicēts',
        ],
        'project_status_default' => 'Uzmetums',

        'project_duration_units_dom' => [
        'Days' => 'Dienas',
        'Hours' => 'Stundas',
        ],

        'project_priority_options' => [
        'High' => 'Augsta',
        'Medium' => 'Vidējs',
        'Low' => 'Zema',
        ],
        'project_priority_default' => 'Vidējs',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Uzņēmumi',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'Uzņēmums',
        'Opportunities' => 'Iespēja',
        'Cases' => 'Pieteikums',
        'Leads' => 'Interesents',
        'Contacts' => 'Kontaktpersonas', // cn (11/22/2005) added to support Emails
        'Products' => 'Piedāvājuma rinda',
        'Quotes' => 'Piedāvājums',
        'Bugs' => 'Kļūda',
        'Project' => 'Projekts',

        'Prospects' => 'Mērķis',
        'ProjectTask' => 'Projekta uzdevums',

        'Tasks' => 'Uzdevums',
        'KBContents' => 'Zināšanu bāze',
        'Notes' => 'Piezīme',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'Uzņēmums',
        'Contacts' => 'Kontaktpersona',
        'Opportunities' => 'Iespēja',
        'Tasks' => 'Uzdevums',
        'ProductTemplates' => 'Produktu katalogs',
        'Quotes' => 'Piedāvājums',
        'Products' => 'Piedāvājuma rinda',
        'Contracts' => 'Līgums',
        'Emails' => 'Jebkāds e-pasts',

        'Bugs' => 'Kļūda',
        'Project' => 'Projekts',
        'ProjectTask' => 'Projekta uzdevums',
        'Prospects' => 'Mērķis',
        'Cases' => 'Pieteikums',
        'Leads' => 'Interesents',

        'Meetings' => 'Tikšanās',
        'Calls' => 'Zvans',
        'KBContents' => 'Zināšanu bāze',
        'PurchasedLineItems' => 'Iegādātais produkts',
        'Purchases' => 'Pirkums',
        'Escalations' => 'Eskalācija',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'Klients',
        'Contacts' => 'Kontakts',
        'Employees' => 'Darbinieks',
        'Leads' => 'Interesents',
        'Prospects' => 'Mērķis',
        'Users' => 'Lietotājs',
        ],

        'parent_type_display' => [
        'Accounts' => 'Uzņēmums',
        'Contacts' => 'Kontaktpersona',
        'Tasks' => 'Uzdevums',
        'Opportunities' => 'Iespēja',
        'Products' => 'Piedāvājuma rinda',
        'Quotes' => 'Piedāvājums',

        'Bugs' => 'Kļūdas',
        'Cases' => 'Pieteikums',
        'Leads' => 'Interesents',

        'Project' => 'Projekts',
        'ProjectTask' => 'Projekta uzdevums',

        'Prospects' => 'Mērķis',
        'KBContents' => 'Zināšanu bāze',
        'Notes' => 'Piezīme',
        'PurchasedLineItems' => 'Iegādātais produkts',
        'Purchases' => 'Pirkums',
        'Escalations' => 'Eskalācija',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'Pieteikums',
        ],

        'product_status_default_key' => 'Nosūtīts',
        'product_status_quote_key' => 'Piedāvājumi',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'Piedāvāts',
        'Orders' => 'Pasūtīts',
        'Ship' => 'Piegādāts',
        ],
        'active_status_dom' => [
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
        'Retired' => 'Devies pensijā',
        ],
        'appearance_options' => [
        'system_default' => 'Izmantot sistēmas iestatījumus',
        'light' => 'Gaišs',
        'dark' => 'Tumšs',
        ],


        'pricing_formula_default_key' => 'Fiksēts',
        'pricing_formula_dom' => [
        'Fixed' => 'Fiksēta cena',
        'ProfitMargin' => 'Peļņas daļa',
        'PercentageMarkup' => 'Uzcenojums pašizmaksai',
        'PercentageDiscount' => 'Atlaide no kataloga cenas',
        'IsList' => 'Kataloga cena',
        ],
        'product_template_status_dom' => [
        'Available' => 'Ir noliktāvā',
        'Unavailable' => 'Nav pieejams',
        ],
        'tax_class_dom' => [
        'Taxable' => 'Ar nodokļiem',
        'Non-Taxable' => 'Bez nodokļiem',
        ],
        'support_term_dom' => [
        '+6 months' => '6 mēneši',
        '+1 year' => '1 gads',
        '+2 years' => '2 gadi',
        ],

        'quote_type_dom' => [
        'Quotes' => 'Piedāvājums',
        'Orders' => 'Secība',
        ],
        'default_quote_stage_key' => 'Uzmetums',
        'quote_stage_dom' => [
        'Draft' => 'Uzmetums',
        'Negotiation' => 'Pārrunu procesā',
        'Delivered' => 'Piegādāts',
        'On Hold' => 'Apturēts',
        'Confirmed' => 'Apstiprināts',
        'Closed Accepted' => 'Aizvērts - akceptēts',
        'Closed Lost' => 'Aizvērts bez panākumiem',
        'Closed Dead' => 'Aizvērts - bezcerīgs',
        ],
        'default_order_stage_key' => 'Nepabeigta',
        'order_stage_dom' => [
        'Pending' => 'Nepabeigta',
        'Confirmed' => 'Apstiprināts',
        'On Hold' => 'Apturēts',
        'Shipped' => 'Piegādāts',
        'Cancelled' => 'Atcelts',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'Galvenais lēmumu pieņēmējs',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Galvenais lēmumu pieņēmējs',
        'Business Decision Maker' => 'Biznesa lēmumpieņēmējs',
        'Business Evaluator' => 'Biznesa novērtētājs',
        'Technical Decision Maker' => 'Tehniskais lēmumpieņēmējs',
        'Technical Evaluator' => 'Tehniskais vērtētājs',
        'Executive Sponsor' => 'Vadošais sponsors',
        'Influencer' => 'Ietekmētājs',
        'Other' => 'Cits',
        ],
        'layouts_dom' => [
        'Standard' => 'Piedāvājums',
        'Invoice' => 'Rēķins',
        ],
        'issue_priority_default_key' => 'Vidējs',
        'issue_priority_dom' => [
        'Urgent' => 'Steidzami',
        'High' => 'Augsta',
        'Medium' => 'Vidējs',
        'Low' => 'Zema',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'Apstiprināts',
        'Duplicate' => 'Dublicēt',
        'Closed' => 'Aizvērts',
        'Out of Date' => 'Novecojis',
        'Invalid' => 'Nederīgs',
        ],

        'issue_status_default_key' => 'Jauns',
        'issue_status_dom' => [
        'New' => 'Jauns',
        'Assigned' => 'Nodota',
        'Closed' => 'Aizvērts',
        'Pending' => 'Nepabeigta',
        'Rejected' => 'Noraidīts',
        ],

        'bug_priority_default_key' => 'Vidējs',
        'bug_priority_dom' => [
        'Urgent' => 'Steidzami',
        'High' => 'Augsta',
        'Medium' => 'Vidēja',
        'Low' => 'Zema',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'Apstiprināts',
        'Duplicate' => 'Dublicēt',
        'Fixed' => 'Fiksēts',
        'Out of Date' => 'Novecojis',
        'Invalid' => 'Nederīgs',
        'Later' => 'Atiekams',
        ],
        'bug_status_default_key' => 'Jauns',
        'bug_status_dom' => [
        'New' => 'Jauns',
        'Assigned' => 'Nodots',
        'Closed' => 'Aizvērts',
        'Pending' => 'Nepabeigts',
        'Rejected' => 'Noraidīts',
        ],
        'bug_type_default_key' => 'Kļūda',
        'bug_type_dom' => [
        'Defect' => 'Defekts',
        'Feature' => 'Funkcija',
        ],
        'case_type_dom' => [
        'Administration' => 'Administrēšana',
        'Product' => 'Produkts',
        'User' => 'Lietotājs',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'Iekšējs',
        'Forum' => 'Forums',
        'Web' => 'Tīmeklis',
        'InboundEmail' => 'Jebkāds e-pasts',
        'Twitter' => 'Twitter',
        'Portal' => 'Portāls',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'Iekšējais',
        'Forum' => 'Forums',
        'Web' => 'Tīmeklis',
        'InboundEmail' => 'E-pasts',
        'Twitter' => 'Twitter',
        'Portal' => 'Portāls',
        'Phone' => 'Tālrunis',
        'Chat' => 'Tērzēšana',
        'Chatbot' => 'Tērzēšanas bots',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'Datu privātuma politikas pieprasījums',
        'Send Personal Information being processed' => 'Sūtīt apstrādāto personisko informāciju',
        'Rectify Information' => 'Koriģēt informāciju',
        'Request to Erase Information' => 'Pieprasīt informācijas dzēšanu',
        'Export Information' => 'Eksportēt informāciju',
        'Restrict Processing' => 'Ierobežot apstrādi',
        'Object to Processing' => 'Iebilst pret apstrādi',
        'Consent to Process' => 'Piekrišana apstrādei',
        'Withdraw Consent' => 'Atsaukt piekrišanu',
        'Other' => 'Cits',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'Biznesa sakari',
        'Marketing Communications by company' => 'Uzņēmuma mārketinga sakari',
        'Marketing Communications by partners' => 'Partneru mārketinga sakari',
        ],
        'dataprivacy_status_default_key' => 'Atvērt',
        'dataprivacy_status_dom' => [
        'Open' => 'Atvērt',
        'Closed' => 'Pabeigts',
        'Rejected' => 'Noraidīts',
        ],
        'dataprivacy_priority_default_key' => 'Zema',
        'dataprivacy_priority_dom' => [
        'Low' => 'Zema',
        'Medium' => 'Vidēja',
        'High' => 'Augsta',
        ],
        'business_day_status_dom' => [
        'Open' => 'Atvērts',
        'Open 24 Hours' => 'Atvērts 24 stundas',
        'Closed' => 'Slēgts',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'Uzņēmumi',
        'Activities' => 'Darbības',
        'Bug Tracker' => 'Kļūdu sekotājs',
        'Calendar' => 'Kalendārs',
        'Calls' => 'Zvani',
        'Campaigns' => 'Kampaņas',
        'Cases' => 'Pieteikumi',
        'Contacts' => 'Kontaktpersonas',
        'Currencies' => 'Valūtas',
        'Dashboard' => 'Darbavieta',
        'Documents' => 'Dokumenti',
        'Emails' => 'E-pasti',
        'Feeds' => 'Barotnes',
        'Forecasts' => 'Prognozes',
        'Help' => 'Palīdzība',
        'Home' => 'Sākums',
        'Leads' => 'Interesenti',
        'Meetings' => 'Tikšanās',
        'Notes' => 'Piezīmes',
        'Opportunities' => 'Iespējas',
        'Outlook Plugin' => 'Outlook spraudnis',
        'Product Catalog' => 'Produktu katalogs',
        'Products' => 'Piedāvājuma rindas',
        'RevenueLineItems' => 'Ieņēmumu posteņi',
        'Projects' => 'Projekti',
        'Quotes' => 'Piedāvājumi',
        'Releases' => 'Laidieni',
        'RSS' => 'RSS barotnes',
        'Studio' => 'Studio',
        'Upgrade' => 'Atjaunināšana',
        'Users' => 'Lietotāji',
        'OutboundEmail' => 'E-pasta iestatījumi',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'Plānošanā',
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
        'Complete' => 'Pabeigts',
        'In Queue' => 'Rindā',
        'Sending' => 'Izsūtīšanā',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'Pārdošana pa telefonu',
        'Mail' => 'Pasts',
        'Email' => 'Jebkāds e-pasts',
        'Print' => 'Drukāt',
        'Web' => 'Tīmeklis',
        'Radio' => 'Radio',
        'Television' => 'Televīzija',
        'NewsLetter' => 'Biļetens',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'SAŅEMT',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'nedēļā',
        'Monthly' => 'Ikmēneša',
        'Quarterly' => 'Reizi ceturksnī',
        'Annually' => 'Reizi gadā',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'Janvāris',
        '2' => 'Februāris',
        '3' => 'Marts',
        '4' => 'Aprīlis',
        '5' => 'Maijs',
        '6' => 'Jūnijs',
        '7' => 'Jūlijs',
        '8' => 'Augusts',
        '9' => 'Septembris',
        '10' => 'Oktobris',
        '11' => 'Novembris',
        '12' => 'Decembris',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'Jan',
        '2' => 'Feb',
        '3' => 'Mar',
        '4' => 'Apr',
        '5' => 'Maijs',
        '6' => 'Jūn',
        '7' => 'Jūl',
        '8' => 'Aug',
        '9' => 'Sep',
        '10' => 'Okt',
        '11' => 'Nov',
        '12' => 'Dec',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'Svētdiena',
        '2' => 'Pirmdiena',
        '3' => 'Otrdiena',
        '4' => 'Trešdiena',
        '5' => 'Ceturtdiena',
        '6' => 'Piektdiena',
        '7' => 'Sestdiena',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'Sv',
        '2' => 'Pi',
        '3' => 'Ot',
        '4' => 'Tr',
        '5' => 'Ce',
        '6' => 'Pie',
        '7' => 'Se',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'Sv',
        '2' => 'Pr',
        '3' => 'Ot',
        '4' => 'Tr',
        '5' => 'Ce',
        '6' => 'Pie',
        '7' => 'Se',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'Sv',
        '1' => 'Pi',
        '2' => 'Ot',
        '3' => 'Tr',
        '4' => 'Ce',
        '5' => 'Pie',
        '6' => 'Se',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'no rīta',
        'pm' => 'pēcpusdienā',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'No rīta',
        'PM' => 'Pēcpusdienā',
        ],

        'dom_report_types' => [
        'tabular' => 'Rindas un kolonnas',
        'summary' => 'Summarizācija',
        'detailed_summary' => 'Summarizācija ar detaļām',
        'Matrix' => 'Matrica',
        ],


        'dom_email_types' => [
        'out' => 'Izsūtīts',
        'archived' => 'Arhivēts',
        'draft' => 'Uzmetums',
        'inbound' => 'Ienākošs',
        'campaign' => 'Kampaņa',
        ],
        'dom_email_status' => [
        'archived' => 'Arhivēts',
        'closed' => 'Aizvērts',
        'draft' => 'Sagatavošanā',
        'read' => 'Izlasīts',
        'replied' => 'Atbildēts',
        'sent' => 'Izsūtīts',
        'send_error' => 'Nosūtīšanas kļūda',
        'unread' => 'Nelasīts',
        ],
        'dom_email_archived_status' => [
        'archived' => 'Arhivēts',
        ],

        'dom_email_server_type' => ['' => '--Nav--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--Nav--',
        'createcase' => 'Jauns pieteikums',
        'bounce' => 'Noraidītiem ziņojumiem',
        ],
        'dom_email_distribution' => ['' => '--Nav--',
        'direct' => 'Tiešā piešķiršana',
        'roundRobin' => 'Viens-visiem',
        'leastBusy' => 'Mazāk aizņemtajiem',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'Viens-visiem',
        'leastBusy' => 'Mazāk aizņemtajiem',
        'none' => 'Neviens',
        ],
        'dom_email_errors' => [1 => 'Var izvēlēties tikai 1 lietotāju, ja izmantojat tiešo piešķiršanu.',
        2 => 'Jāpiešķir tikai atzīmētie ieraksti, kad tieši piešķiriet ierakstus',
        ],
        'dom_email_bool' => ['bool_true' => 'Jā',
        'bool_false' => 'Nē',
        ],
        'dom_int_bool' => [1 => 'Jā',
        0 => 'Nē',
        ],
        'dom_switch_bool' => ['on' => 'Jā',
        'off' => 'Nē',
        '' => 'Nē',],

        'dom_email_link_type' => ['sugar' => 'SugarCRM E-pasta klients',
        'mailto' => 'Ārējs E-pasta klients'],


        'dom_email_editor_option' => ['' => 'Noklusētais E-pasta formāts',
        'html' => 'HTML E-pasts',
        'plain' => 'Atklāta teksta E-pasts'],

        'schedulers_times_dom' => ['not run' => 'Izpildes laiks pagājis, nav izpildīts',
        'ready' => 'Gatavs',
        'in progress' => 'Procesā',
        'failed' => 'Neveiksmīgi',
        'completed' => 'Pabeigts',
        'no curl' => 'Nav palaists: nav pieejams cURL',
        ],

        'dom_email_states' => [
        'Draft' => 'Uzmetums',
        'Archived' => 'Arhivēts',
        ],

        'dom_email_direction' => [
        'Unknown' => 'Nezināms',
        'Outbound' => 'Izejošs',
        'Inbound' => 'Ienākošs',
        'Internal' => 'Iekšējais',
        ],

        'scheduler_status_dom' => [
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
        ],

        'scheduler_period_dom' => [
        'min' => 'Minūtes',
        'hour' => 'Stundas',
        ],
        'forecast_type_dom' => [
        'Direct' => 'Tiešs',
        'Rollup' => 'Apkopojums',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'Mārketings',
        'Knowledge Base' => 'Zināšanu bāze',
        'Sales' => 'Pārdošana',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'Mārketinga materiāli',
        'Product Brochures' => 'Produktu brošūras',
        'FAQ' => 'BUJ',
        ],

        'document_status_dom' => [
        'Active' => 'Aktīvs',
        'Draft' => 'Uzmetums',
        'FAQ' => 'BUJ',
        'Expired' => 'Izbeidzies',
        'Under Review' => 'Caurskatē',
        'Pending' => 'Nepabeigts',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'Pasta sapludināšana',
        'eula' => 'EULA līgums',
        'nda' => 'NDA līgums',
        'license' => 'Licences līgums',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'Apstiprināt',
        'decline' => 'Noraidīt',
        'tentative' => 'Nekonkrēti',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'Apstiprināts',
        'decline' => 'Noraidīts',
        'tentative' => 'Nekonkrēti',
        'none' => 'Neviens',
        ],
        'dataset_output_default_dom' => [
        'table' => 'Tabula',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'Viens modulis',
        'Multi Module' => 'Vairāki moduļi',
        ],
        'report_align_dom' => [
        'left' => 'Pa kreisi',
        'center' => 'Centrā',
        'right' => 'Pa labi',
        ],

        'width_type_dom' => [
        '%' => 'Procenti(%)',
        'px' => 'Pikseļi(px)',
        ],
        'report_color_dom' => [
        '' => 'Noklusētā',
        'black' => 'Melna',
        'green' => 'Zaļa',
        'blue' => 'Zila',
        'red' => 'Sarkana',
        'white' => 'Balta',
        'DarkGreen' => 'Tumši zaļa',
        'LightGray' => 'Gaiši pelēka',
        'DodgerBlue' => 'Tumši zila',
        'LightBlue' => 'Gaiši zila',
        ],
        'font_size_dom' => [
        '-5' => 'Mazāks (-5)',
        '-4' => 'Mazāks (-4)',
        '-3' => 'Mazāks (-3)',
        '-2' => 'Mazāks (-2)',
        '-1' => 'Mazāks (-1)',
        'Default' => 'Noklusētā',
        '1' => 'Lielāks (+1)',
        '2' => 'Lielāks (+2)',
        '3' => 'Lielāks (+3)',
        '4' => 'Lielāks (+4)',
        '5' => 'Lielāks (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'Pamata vaicājums',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'Attēlojums',
//  'Group By' => 'Group By',
        'Calculation' => 'Aprēķins',
        ],
        'query_display_type_dom' => [
        'Default' => 'Noklusētā',
        'Custom' => 'Pielāgots',
        'Hidden' => 'Slēpts',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'Diena',
        'Week' => 'Nedēļa',
        'Month' => 'Mēnesis',
        'Quarter' => 'Ceturksnis',
        'Year' => 'Gads',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'Tagad',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'SUMMA',
        'AVG' => 'VID.',
        'COUNT' => 'Skaits',
        'STDDEV' => 'Standartnovirze',
        'VARIANCE' => 'Dispersija',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'Lauks',
        'Time' => 'Laika intervāls',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'Rindas(Y-Ass)',
        'Columns' => 'Kolonnas(X-Ass)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'Summa (Kopā)',
        'AVG' => 'Vidējs',
        'MAX' => 'Maksimums',
        'MIN' => 'Minimums',
        'COUNT' => 'Skaits',
        'STDDEV' => 'Standartnovirze',
        'VARIANCE' => 'Dispersija',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'Standarta',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'Matemātisks aprēķins',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'Lauks',
        'Value' => 'Vērtība',
        'Group' => 'Grupa',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'Kolonna',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'Izslēgts',
        'Enabled' => 'Aktivizēts',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'Parasts',
        'Scalar' => 'Skalārs',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'Teksts',
        'Accounting' => 'Aprēķins',
        'Date' => 'Datums',
        'Datetime' => 'Datums/laiks',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'Gads',
        'Quarter' => 'Ceturksnis',
        'Month' => 'Mēnesis',
        'Week' => 'Nedēļa',
        'Day' => 'Diena',
        ],
        'dataset_style_dom' => [
        'normal' => 'Parasts',
        'bold' => 'Treknraksts',
        'italic' => 'Slīpraksts',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) Plus',
        '-' => '(-) Mīnuss',
        '*' => '(X) Reizināt ar',
        '/' => '(/) Dalīt ar',
        ],
        'wflow_type_dom' => [
        'Normal' => 'Kad ieraksts saglabāts',
        'Time' => 'Pēc noteikta laika',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Ir',
        'in' => 'viens no',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'viens no',
        'not_in' => 'nav viens no',
        ],
        'cselect_type_dom' => [
        'Equals' => 'Vienāds ar',
        'Does not Equal' => 'nav vienādi',
        ],
        'dselect_type_dom' => [
        'Equals' => 'Vienāds ar',
        'Less Than' => 'Mazāk kā',
        'More Than' => 'Vairāk kā',
        'Does not Equal' => 'Nav vienāds',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'Jā',
        'bool_false' => 'Nē',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'Vienāds ar',
        ],
        'tselect_type_dom' => [
        '0' => '0 stundas',
        '14440' => '4 stundas',
        '28800' => '8 stundas',
        '43200' => '12 stundas',
        '86400' => '1 diena',
        '172800' => '2 dienas',
        '259200' => '3 dienas',
        '345600' => '4 dienas',
        '432000' => '5 dienas',
        '604800' => '1 nedēļa',
        '1209600' => '2 nedēļas',
        '1814400' => '3 nedēļas',
        '2592000' => '30 dienas',
        '5184000' => '60 dienas',
        '7776000' => '90 dienas',
        '10368000' => '120 dienas',
        '12960000' => '150 dienas',
        '15552000' => '180 dienas',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'bija vairāk kā',
        'Less Than' => 'ir mazāk par',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'Jebkāds e-pasts',
        'Invite' => 'Uzaicinājums',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'Parasts ziņojums',
        'Custom Template' => 'Pielāgota veidne',
        'System Default' => 'Sistēmas noklusējums',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'Pašreizējie lietotāji',
        'rel_user' => 'Saistītie lietotāji',
        'rel_user_custom' => 'Saistītais pielāgotais lietotājs',
        'specific_team' => 'Noteikta darba grupa',
        'specific_role' => 'Noteikta loma',
        'specific_user' => 'Noteikts lietotājs',
        ],
        'wflow_array_type_dom' => [
        'future' => 'Jaunā vērtība',
        'past' => 'Vecā vērtība',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'Lietotājs',
        'Manager' => "Lietotāju pārvaldnieks",
        ],
        'wflow_address_type_dom' => [
        'to' => 'Kam:',
        'cc' => 'Kopija:',
        'bcc' => 'Slēptā kopija:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'Kam:',
        'cc' => 'Kopija:',
        'bcc' => 'Slēptā kopija:',
        'invite_only' => '(Tikai ar ielūgumiem)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'Kam:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'Atjaunināt ierakstu',
        'update_rel' => 'Atjaunināt saistīto ierakstu',
        'new' => 'Jauns ieraksts',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'Trigerētais datums',
        'Existing Value' => 'Esošā vērtība',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'Pamatiespējas',
        'Advanced' => 'Paplašinātas iespējas',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'Lietotājs, kam piešķirts ieraksts',
        'modified_user_id' => 'Lietotājs, kas pēdējais modificēja ierakstu',
        'created_by' => 'Lietotājs, kas izveidoja ierakstu',
        'current_user' => 'Pašreizējais lietotājs',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'Ieraksta darba grupa',
        'team_set_id' => 'Ieraksta Pašreizējā darba grupas kopa',
        'current_team' => 'Pašreizējā lietotāja darba grupa',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'Pārlikt nolaižamo izvēlni atpakaļ par',
        'advance' => 'Pārlikt nolaižamo izvēlni uz priekšu par',
        ],
        'wflow_record_type_dom' => [
        'All' => 'Jauni un esoši ieraksti',
        'New' => 'Tikai jaunie ieraksti',
        'Update' => 'Tikai atjauninātie ieraksti',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'Visi saistītie',
        //'first' => 'The first related',
        'filter' => 'Filtrēti saistītie',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'visi saistītie',
        'any' => 'jebkurš saistītais',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'Brīdinājums pēc tam darbība',
        'actions_alerts' => 'Darbība pēc tam brīdinājums'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'Neviens',
        'Daily' => 'dienā',
        'Weekly' => 'nedēļā',
        'Monthly' => 'Ikmēneša',
        'Yearly' => 'Reizi gadā',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'Dienas',
        'Weekly' => 'nedēļa(as)',
        'Monthly' => 'mēnesis(ši)',
        'Yearly' => 'gads(i)',
        ],

        'repeat_end_types' => [
        'Until' => 'Līdz',
        'Occurrences' => 'Parādīšanās',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'Nav',
        'Each' => 'Katrs',
        'On' => 'Precīzi',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'pirmais',
        'second' => 'otrais',
        'third' => 'trešais',
        'fourth' => 'ceturtais',
        'fifth' => 'piektais',
        'last' => 'pēdējais',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'Svētdiena',
        'Mon' => 'Pirmdiena',
        'Tue' => 'Otrdiena',
        'Wed' => 'Trešdiena',
        'Thu' => 'Ceturtdiena',
        'Fri' => 'Piektdiena',
        'Sat' => 'Sestdiena',
        'Day' => 'Diena',
        'WD' => 'Nedēļas diena',
        'WE' => 'Nedēļas nogales diena',
        ],

        'duration_dom' => [
        '' => 'Neviens',
        '900' => '15 minūtes',
        '1800' => '30 minūtes',
        '2700' => '45 minūtes',
        '3600' => '1 stunda',
        '5400' => '1.5 stundas',
        '7200' => '2 stundas',
        '10800' => '3 stundas',
        '21600' => '6 stundas',
        '86400' => '1 diena',
        '172800' => '2 dienas',
        '259200' => '3 dienas',
        '604800' => '1 nedēļa',
        ],
        'repeat_month_dom' => [
        '1' => 'Janvāris',
        '2' => 'Februāris',
        '3' => 'Marts',
        '4' => 'Aprīlis',
        '5' => 'Maijs',
        '6' => 'Jūnijs',
        '7' => 'Jūlijs',
        '8' => 'Augusts',
        '9' => 'Septembris',
        '10' => 'Oktobris',
        '11' => 'Novembris',
        '12' => 'Decembris',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'Noklusētā',
        'seed' => 'Izsēts',
        'exempt_domain' => 'Noklusētais saraksts pēc domēna',
        'exempt_address' => 'Noklusētais saraksts pēc e-pasta adreses',
        'exempt' => 'Noklusētais saraksts pēc ID',
        'test' => 'Tests',
        ],
        'currency_status_dom' => [
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'Aktīvs',
        'inactive' => 'Neaktīvs',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'Ziņa nosūtīta/mēģināta nosūtīt',
        'send error' => 'Noraidītie ziņojumi, cits',
        'invalid email' => 'Noraidītie ziņojumi, nederīga e-pasta adrese',
        'link' => 'Click-thru saite',
        'viewed' => 'Apskatīta ziņa',
        'removed' => 'Nelieto',
        'lead' => 'Interesenti izveidoti',
        'contact' => 'Kontaktpersonas izveidotas',
        'blocked' => 'Noklusēts pēc adreses vai domēna',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'Kontaktpersonas',
        'Users' => 'Lietotāji',
        'Prospects' => 'Mērķi',
        'Leads' => 'Interesenti',
        'Accounts' => 'Uzņēmumi',
        ],
        'merge_operators_dom' => [
        'like' => 'Satur',
        'exact' => 'Tieša sakritība',
        'start' => 'Sākas ar',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'Jā',
        'false' => 'Nē',
        'required' => 'Obligāts',
        ],

        'fts_field_config' => [
        '0' => 'Izslēgts',
        '2' => 'Meklēšanai pieejams',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'Izslēgts',
        1 => 'Aktivizēts',
        2 => 'Iekļaut filtrā',
        3 => 'Noklusētais atlasītais filtrs',
        4 => 'Filtrēt tikai',
        ],

        'navigation_paradigms' => [
        'm' => 'Moduļi',
        'gm' => 'Grupēti moduļi',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'Nav sākts',
        'inprogress' => 'Procesā',
        'signed' => 'Parakstīts',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'Ikmēneša',
        'quarterly' => 'Reizi ceturksnī',
        'halfyearly' => 'Reizi pusgadā',
        'yearly' => 'Reizi gadā',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 diena',
        '3' => '3 dienas',
        '5' => '5 dienas',
        '7' => '1 nedēļa',
        '14' => '2 nedēļas',
        '21' => '3 nedēļas',
        '31' => '1 mēnesis',
        ],
        'projects_priority_options' => [
        'high' => 'Augsta',
        'medium' => 'Vidējs',
        'low' => 'Zema',
        ],

        'projects_status_options' => [
        'notstarted' => 'Nav sākts',
        'inprogress' => 'Procesā',
        'completed' => 'Pabeigts',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'Izvērst apzīmējumus',
        'collapselegend' => 'Savērst apzīmējumus',
        'clickfordrilldown' => 'Uzklikšķināt, lai skatītu detalizētu informāciju',
        'drilldownoptions' => 'Nolaižamās izvēlnes iespējas',
        'detailview' => 'Vairāk informācijas...',
        'piechart' => 'Sektoru diagramma',
        'groupchart' => 'Grupu diagramma',
        'stackedchart' => 'Grēdu diagramma',
        'barchart' => 'Joslu diagramma',
        'horizontalbarchart' => 'Horizontāla joslu diagramma',
        'linechart' => 'Līniju diagramma',
        'noData' => 'Dati nav pieejami',
        'print' => 'Drukāt',
        'pieWedgeName' => 'sekcijas',
        ],
        'chart_types' => [
        'hBarF' => 'Horizontāla josla (grēdota)',
        'hGBarF' => 'Horizontāla josla (grupēta)',
        'vBarF' => 'Vertikāla josla (grēdota)',
        'vGBarF' => 'Vertikāla josla (grupēta)',
        'pieF' => 'Sektoru',
        'funnelF' => 'Piltuve',
        'lineF' => 'Līnija',
        'donutF' => 'Gredzenveida',
        'treemapF' => 'Kokveida karte',
        ],
        'd3_value_placement' => [
        '0' => 'Neviens',
        '1' => 'Noklusētā',
        'start' => 'Uzsākts',
        'middle' => 'Vidus',
        'end' => 'Beigas',
        'top' => 'Augša',
        'total' => 'Kopā',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'Piltuve',
        'hbar' => 'Horizontāla josla',
        ],
        'release_status_dom' => [
        'Active' => 'Aktīvs',
        'Inactive' => 'Neaktīvs',
        ],
        'email_settings_for_ssl' => [
        '0' => 'Neviens',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Google mazāk drošas lietotnes',
        'exchange' => 'Exchange',
        'other' => 'Cits',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'Cits',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'Parastas pēdiņas ($#39;)',
        '"' => 'Dubultas pēdiņas (")',
        '' => 'Neviens',
        'other' => 'Cits:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'Cits:',
        ],
        'link_target_dom' => [
        '_blank' => 'Jauns logs',
        '_self' => 'Esošais logs',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'Neatjaunot',
        '30' => 'Ik pēc 30 sekundēm',
        '60' => 'Ik pēc 1 minūtes',
        '180' => 'Ik pēc 3 minūtēm',
        '300' => 'Ik pēc 5 minūtēm',
        '600' => 'Ik pēc 10 minūtēm',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'Neviens',
        '15' => 'Ik pēc 15 minūtēm',
        '30' => 'Ik pēc 30 minūtēm',
        '45' => 'Ik pēc 45 minūtēm',
        '60' => 'Reizi stundā',
        '120' => 'Reizi 2 stundās',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'Nekad',
        '30' => 'Ik pēc 30 sekundēm',
        '60' => 'Ik pēc 1 minūtes',
        '180' => 'Ik pēc 3 minūtēm',
        '300' => 'Ik pēc 5 minūtēm',
        '600' => 'Ik pēc 10 minūtēm',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'Neviens',
        '1' => 'Ik pēc 1 minūtes',
        '5' => 'Ik pēc 5 minūtēm',
        '10' => 'Ik pēc 10 minūtēm',
        '15' => 'Ik pēc 15 minūtēm',
        '30' => 'Ik pēc 30 minūtēm',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'Vienāds ar',
        'not_equal' => 'Nav On',
        'greater_than' => 'Pēc',
        'less_than' => 'Pirms',
        'last_7_days' => 'Pēdējās 7 dienās',
        'next_7_days' => 'Nākošās 7 dienās',
        'last_30_days' => 'Pēdējās 30 dienās',
        'next_30_days' => 'Nākošās 30 dienās',
        'last_month' => 'Pēdējā mēnesī',
        'this_month' => 'Šajā mēnesī',
        'next_month' => 'Nākošā mēnesī',
        'last_year' => 'Pēdējā gadā',
        'this_year' => 'Šajā gadā',
        'next_year' => 'Nākošā gadā',
        'between' => 'Ir starp',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'Pēdējā gadā',
        'last_month' => 'Pēdējā mēnesī',
        'last_30_days' => 'Pēdējās 30 dienās',
        'last_7_days' => 'Pēdējās 7 dienās',
        'this_month' => 'Šajā mēnesī',
        'this_year' => 'Šajā gadā',
        'next_7_days' => 'Nākošās 7 dienās',
        'next_30_days' => 'Nākošās 30 dienās',
        'next_month' => 'Nākošā mēnesī',
        'next_year' => 'Nākošā gadā',
        ],
        'numeric_range_search_dom' => [
        '=' => 'Vienāds ar',
        'not_equal' => 'nav vienādi',
        'greater_than' => 'Lielāks kā',
        'greater_than_equals' => 'Lielāks vai vienāds ar',
        'less_than' => 'Mazāk kā',
        'less_than_equals' => 'Mazāks vai vienāds ar',
        'between' => 'Ir starp',
        ],

        'filter_checkbox_dom' => [
        0 => 'Nepareizi',
        1 => 'Pareizi',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'Iegūts',
        'lost' => 'Zaudēts',
        'active' => 'Aktīvs',
        ],

        'sweetspot_theme_options' => [
        'default' => 'Noklusētā',
        'light' => 'Gaišs',
        'dark' => 'Tumšs',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'Pārvietot',
        'donothing' => 'Nedarīt neko',
        ],
        'processes_auto_save_interval' => [
        0 => 'Nekad',
        30000 => 'Ik pēc 30 sekundēm',
        60000 => 'Ik pēc 1 minūtes',
        120000 => 'Ik pēc 2 minūtēm',
        180000 => 'Ik pēc 3 minūtēm',
        240000 => 'Ik pēc 4 minūtēm',
        300000 => 'Ik pēc 5 minūtēm',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'Jā',
        'No' => 'Nē',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'Iekļaut prognozē',
        'sales_stage' => 'Pārdošanas posms',
        'probability' => 'Varbūtība',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'Ticamākā',
        'best' => 'Labākā',
        'worst' => 'Sliktākā',
        ],
        'webLogicHookList' => [
        'after_save' => 'Pēc saglabāšanas',
        'after_delete' => 'Pēc dzēšanas',
        'after_relationship_add' => 'Pēc sakaru pievienošanas',
        'after_relationship_delete' => 'Pēc sakaru dzēšanas',
        'after_login' => 'Pēc pieteikšanās',
        'after_logout' => 'Pēc atteikšanās',
        'after_login_failed' => 'Pēc neveiksmīgas pieteikšanās',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'Aktivizēts',
        'INACTIVE' => 'Izslēgts',
        ],
        'dashboard_view_name_list' => [
        'record' => 'Ieraksts',
        'records' => 'Saraksts',
        'activities' => 'Darbību plūsma',
        'multi-line' => 'Daudzrindu saraksts',
        'omnichannel' => 'Daudzkanālu',
        'home' => 'Home',
        'focus' => 'Fokusa panelis',
        ],
        'metric_context_list' => [
        'service_console' => 'Servisa konsole',
        'renewals_console' => 'Atjaunojumu konsole',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'Stundā',
        '21600' => 'Reizi 6 stundās',
        '43200' => 'Reizi 12 stundās',
        '86400' => 'Katru dienu',
        '604800' => 'Katru nedēļu',
        '1209600' => 'Reizi 2 nedēļās',
        '2419200' => 'Reizi 4 nedēļās',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'Gads(i)',
        'month' => 'Mēnesis(ši)',
        'day' => 'Diena(s)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'Ārpus darba laika',
        'event' => 'Notikums',
        'other' => 'Cits',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'Datums (Pēdējais {{module}})',
        'start_date:asc' => 'Datums (Pirmais {{module}})',
        'total_revenue:desc' => 'Cena (Visaugstākā, kopējā)',
        'total_revenue:asc' => 'Cena (Viszemākā, kopējā)',
        ],
        'calendar_type_list' => [
        'main' => 'Kalendāra centrs',
        ],
        'calendar_views_options' => [
        'day' => 'Diena',
        'week' => 'Nedēļa',
        'workWeek' => 'Darba nedēļa',
        'expandedMonth' => 'Mēnesis',
        'agenda' => 'Darba kārtība',
        'timeline' => 'Laika josla',
        'monthSchedule' => 'Plānotājs',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'Izveidots',
        'completed' => 'Pabeigts',
        'declined' => 'Noraidīts',
        'delivered' => 'Piegādāts',
        'sent' => 'Nosūtīts',
        'signed' => 'Parakstīts',
        'voided' => 'Anulēts',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'Parādīt potenciālo saņēmēju sarakstu',
        'dont_show' => 'Nerādīt potenciālos saņēmējus',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'Parakstītājs',
        'carbon_copy' => 'Skatītājs (kopija)',
        'certified_delivery' => 'Skatītājs (Sertificēta piegāde)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'Noklusētais',
        'color' => 'Krāsa',
        'image' => 'Attēls',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'Saīsinājums',
        'icon' => 'Ikona',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'Bultiņa uz leju',
        'sicon-chevron-left' => 'Skujiņa pa kreisi',
        'sicon-check' => 'Pārbaudīt',
        'sicon-clock' => 'Pulkstenis',
        'sicon-dashboard-default' => 'Informācijas paneļa noklusējums',
        'sicon-dashboard' => 'Instrumentu panelis',
        'sicon-edit' => 'Rediģēt',
        'sicon-caret-down' => 'Kursors uz leju',
        'sicon-folder' => 'Mape',
        'sicon-info' => 'Informācija',
        'sicon-kebab' => 'Kebabs',
        'sicon-link' => 'Saite',
        'sicon-list' => 'Saraksts',
        'sicon-logout' => 'Iziet',
        'sicon-minus' => 'Mīnus',
        'sicon-folder-open' => 'Mape atvērta',
        'sicon-plus-sm' => 'Plus Sm',
        'sicon-refresh' => 'Atsvaidzināt',
        'sicon-plus' => 'Plus',
        'sicon-settings' => 'Iestatījumi',
        'sicon-arrow-right-double' => 'Bultiņa pa labi dubultā',
        'sicon-reports' => 'Atskaites',
        'sicon-user' => 'Lietotājs',
        'sicon-upload' => 'Augšupielādēt',
        'sicon-user-group' => 'Lietotāju grupa',
        'sicon-arrow-left-double' => 'Bultiņa pa kreisi dubultā',
        'sicon-chevron-up' => 'Skujiņa uz augšu',
        'sicon-caret-up' => 'Kursors uz augšu',
        'sicon-star-fill' => 'Aizpildīta zvaigznīte',
        'sicon-download' => 'Lejupielādēt',
        'sicon-close' => 'Aizvērt',
        'sicon-tile-view' => 'Mozaīkas skatījums',
        'sicon-list-view' => 'Saraksta skatījums',
        'sicon-thumbs-down' => 'Īkšķi uz leju',
        'sicon-warning-circle' => 'Brīdinājuma aplis',
        'sicon-phone' => 'Tālrunis',
        'sicon-email' => 'E-pasts',
        'sicon-document' => 'Dokuments',
        'sicon-note' => 'Piezīme',
        'sicon-preview' => 'Priekšskatījums',
        'sicon-copy' => 'Kopēt',
        'sicon-launch' => 'Sākt',
        'sicon-lock' => 'Aizslēgt',
        'sicon-arrow-top-right' => 'Augšējā bultiņa pa labi',
        'sicon-full-screen' => 'Pilnekrāns',
        'sicon-full-screen-exit' => 'Iziet no pilnekrāna',
        'sicon-expand-left' => 'Izvērst pa kreisi',
        'sicon-expand-right' => 'Izvērst pa labi',
        'sicon-focus-drawer' => 'Fokusa atvilktne',
        'sicon-ban' => 'Aizliegums',
        'sicon-thumbs-up' => 'Īkšķi uz augšu',
        'sicon-search' => 'Meklēt',
        'sicon-calendar' => 'Kalendārs',
        'sicon-calendar-lg' => 'Kalendārs Lg',
        'sicon-mobile-lg' => 'Mobilais Lg',
        'sicon-star-fill-lg' => 'Aizpildīta zvaigznīte Lg',
        'sicon-star-outline-lg' => 'Zvagznītes kontūra Lg',
        'sicon-reset-lg' => 'Atiestatīt Lg',
        'sicon-exchange-lg' => 'Apmaiņa Lg',
        'sicon-help-lg' => 'Palīdzība Lg',
        'sicon-close-lg' => 'Aizvērt Lg',
        'sicon-plus-lg' => 'Plus Lg',
        'sicon-shortcuts-lg' => 'Saīsnes Lg',
        'sicon-search-lg' => 'Meklē Lg',
        'sicon-email-lg' => 'E-pasts Lg',
        'sicon-note-lg' => 'Piezīme Lg',
        'sicon-document-lg' => 'Dokuments Lg',
        'sicon-add-dashlet-lg' => 'Pievienot informācijas lauku Lg',
        'sicon-collapse-lg' => 'Savērst Lg',
        'sicon-hamburger-lg' => 'Hamburger Lg',
        'sicon-pin-fill-lg' => 'Aizpildīta piespraudes zīme Lg',
        'sicon-expand-lg' => 'Izvērst Lg',
        'sicon-copy-lg' => 'Kopēt Lg',
        'sicon-dashboard-lg' => 'Informācijas panelis Lg',
        'sicon-star-outline' => 'Zvagznītes kontūra',
        'sicon-reset' => 'Atiestatīt',
        'sicon-unlink' => 'Noņemt',
        'sicon-phone-lg' => 'Tālrunis Lg',
        'sicon-attach' => 'Pievienot',
        'sicon-case-lg' => 'Pieteikums Lg',
        'sicon-arrow-right-lg' => 'Bultiņa pa labi Lg',
        'sicon-check-circle-lg' => 'Aplis ar atzīmi Lg',
        'sicon-text-formatting' => 'Teksta formatējums',
        'sicon-check-circle' => 'Aplis ar atzīmi',
        'sicon-upload-lg' => 'Augšupielāde Lg',
        'sicon-flag-lg' => 'Karogs Lg',
        'sicon-studio-lg' => 'Studija Lg',
        'sicon-contact-lg' => 'Kontaktpersona Lg',
        'sicon-edit-lg' => 'Rediģēt Lg',
        'sicon-arrow-left' => 'Bultiņa pa kreisi',
        'sicon-reply-all' => 'Atbildēt visiem',
        'sicon-message-lg' => 'Ziņojums Lg',
        'sicon-info-lg' => 'Informācija Lg',
        'sicon-error-lg' => 'Kļūda Lg',
        'sicon-check-circle-line-lg' => 'Apļa ar atzīmi kontūra Lg',
        'sicon-warning-line-lg' => 'Brīdinājuma līnija Lg',
        'sicon-arrow-up' => 'Bultiņa uz augšu',
        'sicon-arrow-right' => 'Bultiņa pa labi',
        'sicon-nodes' => 'Mezgli',
        'sicon-hide' => 'Slēpt',
        'sicon-help' => 'Palīdzība',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'Ziņojums',
        'sicon-sugar-predict-lg' => 'Sugar prognoze Lg',
        'sicon-sugar-predict' => 'Sugar prognoze',
        'sicon-opportunity-lg' => 'Darījums Lg',
        'sicon-lead-lg' => 'Interesents Lg',
        'sicon-account-lg' => 'Klients Lg',
        'sicon-user-sm' => 'Lietotājs Sm',
        'sicon-quote-lg' => 'Piedāvājums Lg',
        'sicon-equal' => 'Vienāds ar',
        'sicon-slicers-xl' => 'Datu griezumi Xl',
        'sicon-escalation-lg' => 'Eskalācija Lg',
        'sicon-add-circle-lg' => 'Pievienot apli Lg',
        'sicon-add-line-lg' => 'Pievienot līniju Lg',
        'sicon-add-target-lg' => 'Pievienot mērķi Lg',
        'sicon-help-circle-lg' => 'Palīdzības aplis Lg',
        'sicon-divide-line-lg' => 'Sadalījuma līnija Lg',
        'sicon-string' => 'Virkne',
        'sicon-filter' => 'Filtrs',
        'sicon-number' => 'Numurs',
        'sicon-format-lg' => 'Formāts Lg',
        'sicon-insights-lg' => 'Insights Lg',
        'sicon-invalid-circle-lg' => 'Nederīgs aplis Lg',
        'sicon-layout-xl' => 'Izkārtojums Xl',
        'sicon-layout-lg' => 'Izkārtojums Lg',
        'sicon-multiply-line-lg' => 'Reizināšanas līnija Lg',
        'sicon-redo-lg' => 'Atcelt atsaukšanu Lg',
        'sicon-refresh-lg' => 'Atsvaidzināt Lg',
        'sicon-undo-lg' => 'Atsaukt Lg',
        'sicon-activity-feed-xl' => 'Aktivitātes plūsma Xl',
        'sicon-chevron-left-xl' => 'Skujiņa pa kreisi Xl',
        'sicon-close-xl' => 'Aizvērt Xl',
        'sicon-kebab-lg' => 'Kebabs Lg',
        'sicon-insights-xl' => 'Insights Xl',
        'sicon-hide-lg' => 'Slēpt Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => 'Komentārs Xl',
        'sicon-share-lg' => 'Kopīgot Lg',
        'sicon-trash' => 'Atkritne',
        'sicon-launch-lg' => 'Sākt Lg',
        'sicon-thumbs-up-lg' => 'Īkšķi uz augšu Lg',
        'sicon-thumbs-down-lg' => 'Īkšķi uz leju Lg',
        'sicon-warning-lg' => 'Brīdinājums Lg',
        'sicon-wizard-circle-xl' => 'Vedņa aplis Xl',
        'sicon-bell-cross-lg' => 'Zvans ar krustu Lg',
        'sicon-bell-lg' => 'Zvans Lg',
        'sicon-daily-lg' => 'Ikdienas Lg',
        'sicon-cloud-download-lg' => 'Mākoņa lejupielāde Lg',
        'sicon-unlock' => 'Atbloķēt',
        'sicon-news-lg' => 'Jaunumi Lg',
        'sicon-weekly-lg' => 'Nedēļas Lg',
        'sicon-knowledgebase-xl' => 'Zināšanu bāze Xl',
        'sicon-remove' => 'Noņemt',
        'sicon-chevron-down' => 'Skujiņa uz leju',
        'sicon-slicers-lg' => 'Datu griezumi Lg',
        'sicon-save-lg' => 'Saglabāt Lg',
        'sicon-info-circle-lg' => 'Informācijas aplis Lg',
        'sicon-chevron-right' => 'Skujiņa pa labi',
        'sicon-warning-circle-lg' => 'Brīdinājuma aplis Lg',
        'sicon-right-paren-line-lg' => 'Labās iekavas līnija Lg',
        'sicon-comment-lg' => 'Komentārs Lg',
        'sicon-target-lg' => 'Mērķis Lg',
        'sicon-subtract-line-lg' => 'Atņemšanas līnija Lg',
        'sicon-settings-lg' => 'Iestatījumi Lg',
        'sicon-left-paren-line-lg' => 'Kreisās iekavas līnija Lg',
        'sicon-preview-lg' => 'Priekšskatījums Lg',
        'sicon-thumbs-down-line-lg' => 'Īkšķu uz leju līnija Lg',
        'sicon-thumbs-up-line-lg' => 'Īkšķu uz augšu līnija Lg',
        'sicon-send-lg' => 'Sūtīt Lg',
        'sicon-contact-xl' => 'Kontaktpersona Xl',
        'sicon-wizard-circle-line-xl' => 'Vedņa apļa līnija Xl',
        'sicon-trash-lg' => 'Atkritne Lg',
        'sicon-pin-lg' => 'Piespraudes zīme Lg',
        'sicon-clock-lg' => 'Pulkstenis Lg',
        'sicon-comment-line-xl' => 'Komentāru rinda Xl',
        'sicon-dropdown-editor' => 'Nolaižamās izvēlnes redaktors',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'Kļūda',
        'sicon-catalog' => 'Katalogs',
        'sicon-cloud' => 'Mākonis',
        'sicon-config-api' => 'Konfigurēt Api',
        'sicon-config-nav' => 'Konfigurēt Nav',
        'sicon-connectors' => 'Konektori',
        'sicon-contracts' => 'Līgumi',
        'sicon-currencies' => 'Valūtas',
        'sicon-diagnostics' => 'Diagnostikas',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'E-pasta kampaņa',
        'sicon-email-inbound' => 'Ienākošais e-pasts',
        'sicon-email-queue' => 'E-pastu rinda',
        'sicon-forecasts' => 'Prognozes',
        'sicon-display-modules' => 'Rādīt moduļus',
        'sicon-email-contacts' => 'E-pasta kontaktpersonas',
        'sicon-import' => 'Importēt',
        'sicon-log-viewer' => 'Žurnāla pārlūks',
        'sicon-lab' => 'Lab',
        'sicon-map-pin' => 'Kartes piespraudes zīme',
        'sicon-manufacturers' => 'Ražotāji',
        'sicon-update' => 'Atjaunināt',
        'sicon-content-security' => 'Satura drošība',
        'sicon-module-builder' => 'Moduļu veidotājs',
        'sicon-languages' => 'Valodas',
        'sicon-module-loader' => 'Moduļa ielādētājs',
        'sicon-oauth-key' => 'Oauth atslēga',
        'sicon-password-mgmt' => 'Paroļu pārvaldība',
        'sicon-opportunities' => 'Darījumi',
        'sicon-upgrade' => 'Atjaunināšana',
        'sicon-portal' => 'Portāls',
        'sicon-product-types' => 'Produktu tipi',
        'sicon-quotes' => 'Piedāvājumi',
        'sicon-relate-fields' => 'Saistītie lauki',
        'sicon-repair' => 'Salabot',
        'sicon-role-mgmt' => 'Lomu pārvaldība',
        'sicon-scheduler' => 'Plānotājs',
        'sicon-shippers' => 'Nosūtītāji',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'Tīmekļa loģika',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'Nodokļa likmes',
        'sicon-team-mgmt' => 'Darba grup pārvaldība',
        'sicon-team-perm' => 'Darba grupas atļauja',
        'sicon-tracker' => 'Sekotājs',
        'sicon-workflow' => 'Darbplūsma',
        'sicon-mask' => 'Maska',
        'sicon-mask-disabled' => 'Maska atspējota',
        'sicon-email-archive' => 'E-pasta arhīvs',
        'sicon-mobile' => 'Mobilais tālrunis',
        'sicon-archive' => 'Arhīvs',
        'sicon-automate-scroll' => 'Vertikālais ritināšanas skats',
        'sicon-automate-stacked' => 'Horizontālais ritināšanas skats',
        'sicon-pdf-manager' => 'Pdf pārvaldnieks',
        'sicon-my-sites' => 'Manas vietnes',
        'sicon-cloud-insights' => 'Cloud Insights',
        'sicon-sugar-logo-24' => 'Sugar Logo 24',
        'sicon-sugar-logo-16' => 'Sugar Logo 16',
        'sicon-task-lg' => 'Uzdevums Lg',
        'sicon-web-lg' => 'Tīmeklis Lg',
        'sicon-events-lg' => 'Notikumi Lg',
        'sicon-sugar-logo-12' => 'Sugar Logo 12',
        'sicon-tag' => 'Birka',
        'sicon-tag-lg' => 'Birka Lg',
        'sicon-bell-lg-line' => 'Zvana Lg līnija',
        'sicon-matrix-xxl' => 'Matrica Xxl',
        'sicon-advanced-filter' => 'Paplašināts filtrs',
        'sicon-rows-and-columns-xxl' => 'Rindas un kolonnas Xxl',
        'sicon-summation-details-xxl' => 'Summēšanas informācija Xxl',
        'sicon-summation-xxl' => 'Summēšana Xxl',
        'sicon-lock-lg' => 'Bloķēšana Lg',
        'sicon-csv-file-xxl' => 'Csv fails Xxl',
        'sicon-logo-linkedin' => 'Logo Linkedin',
        'sicon-briefcase' => 'Portfelis',
        'sicon-car-front' => 'Automašīnas priekšpuse',
        'sicon-airplane' => 'Lidmašīna',
        'sicon-laptop' => 'Klēpjdators',
        'sicon-logo-instagram' => 'Logo Instagram',
        'sicon-single-bed' => 'Vienguļamā gulta',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'Logo Snapchat',
        'sicon-video-lg' => 'Video Lg',
        'sicon-reply' => 'Atbildēt',
        'sicon-subtract' => 'Atņemt',
        'sicon-arrow-up-circle-line' => 'Bultiņa uz augšu riņķa līnija',
        'sicon-asterisk' => 'Zvaigznīte',
        'sicon-dot-circle-o-lg' => 'Punkts aplī O Lg',
        'sicon-forward' => 'Pārsūtīt',
        'sicon-video' => 'Video',
        'sicon-gavel' => 'Āmurs',
        'sicon-login' => 'Pieteikšanās',
        'sicon-pdf-file-xxl' => 'Pdf fails Xxl',
        'sicon-login-lg' => 'Pierakstīšanās Lg',
        'sicon-cloud-download-xl' => 'Mākoņa lejupielāde Xl',
        'sicon-campaigns-lg' => 'Kampaņas Lg',
        'sicon-customer-journey-stages-lg' => 'Klienta ceļa posmi Lg',
        'sicon-role-mgmt-lg' => 'Lomu pārvaldība Lg',
        'sicon-default-module-lg' => 'Noklusējuma modulis Lg',
        'sicon-quoted-line-items-lg' => 'Piedāvājuma rindas Lg',
        'sicon-projects-lg' => 'Projekti Lg',
        'sicon-process-business-rules-lg' => 'Procesa biznesa lomas Lg',
        'sicon-process-email-templates-lg' => 'Procesa e-pasta sagataves Lg',
        'sicon-processes-lg' => 'Procesi Lg',
        'sicon-process-definitions-lg' => 'Procesu definīcijas Lg',
        'sicon-target-lists-lg' => 'Mērķu saraksti Lg',
        'sicon-purchased-line-items-lg' => 'Iegādātie produkti Lg',
        'sicon-user-group-lg' => 'Lietotāju grupa Lg',
        'sicon-revenue-line-items-lg' => 'Ieņēmumu posteņi Lg',
        'sicon-business-centers-lg' => 'Biznesa centri Lg',
        'sicon-logo-fb-simple' => 'Logo Fb vienkāršs',
        'sicon-forecasts-lg' => 'Prognozes Lg',
        'sicon-contracts-lg' => 'Kontaktpersonas Lg',
        'sicon-purchase-lg' => 'Pirkums Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'Klienta ceļš Lg',
        'sicon-data-privacy-lg' => 'Datu privātums Lg',
        'sicon-home-lg' => 'Sākums Lg',
        'sicon-data-table' => 'Datu tabula',
        'sicon-medical-clipboard-lg' => 'Medicīniskā starpliktuve Lg',
        'sicon-privacy-lg' => 'Privātums Lg',
        'sicon-marketplace' => 'Tirgus',
        'sicon-marketplace-lg' => 'Tirgus Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => 'Kazino Lg',
        'sicon-jacuzzi-lg' => 'Džakuzi Lg',
        'sicon-scissors-lg' => 'Šķēres Lg',
        'sicon-storage-lg' => 'Krātuve Lg',
        'sicon-fan-lg' => 'Ventilators Lg',
        'sicon-medicine-lg' => 'Medicīna Lg',
        'sicon-plant-lg' => 'Augs Lg',
        'sicon-telescope-lg' => 'Teleskops Lg',
        'sicon-smart-phone-lg' => 'Viedtālrunis Lg',
        'sicon-coffee-lg' => 'Kafija Lg',
        'sicon-martini-lg' => 'Martini Lg',
        'sicon-cocktail-lg' => 'Kokteilis Lg',
        'sicon-stadium-lg' => 'Stadions Lg',
        'sicon-fire-lg' => 'Uguns Lg',
        'sicon-window-lg' => 'Logs Lg',
        'sicon-lotus-lg' => 'Lotoss Lg',
        'sicon-windmill-lg' => 'Vējdzirnavas Lg',
        'sicon-spades-lg' => 'Pīķi Lg',
        'sicon-hearts-lg' => 'Erceni Lg',
        'sicon-diamonds-lg' => 'Kāravi Lg',
        'sicon-clubs-lg' => 'Kreiči Lg',
        'sicon-skull-lg' => 'Galvaskauss Lg',
        'sicon-send' => 'Sūtīt',
        'sicon-world-lg' => 'Pasaule Lg',
        'sicon-airplane-lg' => 'Lidmašīna Lg',
        'sicon-planet-lg' => 'Planēta Lg',
        'sicon-trainer-lg' => 'Treneris Lg',
        'sicon-calculator-lg' => 'Kalkulators Lg',
        'sicon-tv-lg' => 'TV Lg',
        'sicon-video-player-lg' => 'Video atskaņotājs Lg',
        'sicon-media-player-lg' => 'Multivides atskaņotājs Lg',
        'sicon-decentralize-lg' => 'Decentralizēt Lg',
        'sicon-statistics-lg' => 'Statistika Lg',
        'sicon-virus-lg' => 'Vīruss Lg',
        'sicon-shield-lg' => 'Vairogs Lg',
        'sicon-plug-lg' => 'Spraudnis Lg',
        'sicon-shuttle-lg' => 'Šatls Lg',
        'sicon-soundwave-lg' => 'Skaņas viļņi Lg',
        'sicon-graph-lg' => 'Grafiks Lg',
        'sicon-playlist-lg' => 'Atskaņošanas saraksts Lg',
        'sicon-voice-recognition-lg' => 'Balss atpazīšana Lg',
        'sicon-machine-learning-lg' => 'Mašīnmācīšanās Lg',
        'sicon-bed-lg' => 'Gulta Lg',
        'sicon-blueprint-lg' => 'Rasējums Lg',
        'sicon-content-delivery-lg' => 'Satura piegāde Lg',
        'sicon-questionnaire-lg' => 'Anketa Lg',
        'sicon-presentation-lg' => 'Prezentācija Lg',
        'sicon-organic-lg' => 'Organiskais Lg',
        'sicon-transactions-lg' => 'Transakcijas Lg',
        'sicon-wand-lg' => 'Nūjiņa Lg',
        'sicon-bin-lg' => 'Tvertne Lg',
        'sicon-sync-lg' => 'Sinhronizācija Lg',
        'sicon-external-authentication-lg' => 'Ārējā autentifikācija Lg',
        'sicon-tracking-activity-lg' => 'Izsekošanas aktivitāte Lg',
        'sicon-account' => 'Klients',
        'sicon-meetings-lg' => 'Tikšanās Lg',
        'sicon-stacked' => 'Horizontāli sadalīts skats',
        'sicon-sidebyside' => 'Vertikāli sadalīts skats',
        ],

        'module_colors_dom' => [
        'army' => 'Armija',
        'coral' => 'Koraļkrāsas',
        'green' => 'Zaļš',
        'orange' => 'Oranžs',
        'ocean' => 'Okeāns',
        'pacific' => 'Klusā okeāna',
        'pink' => 'Rozā',
        'purple' => 'Purpura',
        'red' => 'Sarkans',
        'teal' => 'Zilganzaļš',
        'yellow' => 'Dzeltens',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'Jauns',
        'In Progress' => 'Procesā',
        'Closed' => 'Slēgts',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'Neaktivitāte',
        'Lack of Progress' => 'Nav progresa',
        'Customer-Imposed Deadline' => 'Klienta noteikts termiņš',
        'Account at Risk' => 'Uzņēmums ir apdraudēts',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'Klienta pieprasīts',
        'Internally Requested' => 'Iekšēji pieprasīts',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'Pieteikums',
        'Bugs' => 'Kļūda',
        'Accounts' => 'Uzņēmums',
        'Opportunities' => 'Darījums',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'Pozitīvs',
        'Negative' => 'Negatīvs',
        'Neutral' => 'Neitrāls',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'Nav ticams',
        '02_less_likely' => 'Mazāk ticams',
        '03_neutral' => 'Neitrāls',
        '04_more_likely' => 'Vairāk ticams',
        '05_very_likely' => 'Ļoti ticams',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'Nesakrīt ar klientiem',
        '02_no_match' => '',
        '01_matches_customers' => 'Sakrīt ar klientiem',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'Interesents',
        'Accounts' => 'Klients',
        'Contacts' => 'Kontaktpersona',
        'Cases' => 'Pieteikums',
        'Opportunities' => 'Darījums',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'Nav sākts',
        'in_progress' => 'Procesā',
        'completed' => 'Pabeigts',
        'cancelled' => 'Atcelts',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'Nav',
        'create' => 'Izveides laikā',
        'stage_start' => 'Posma sākšanas laikā',
        'previous_activity_completed' => 'Iepriekšējā aktivitāte pabeigta',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'Pašreizējais lietotājs',
        'parent_assignee' => 'Priekšteča pilnvarotais',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'Dienas no izveides',
        'days_from_stage_started' => 'Dienas no posma sākuma',
        'days_from_previous_activity_completed' => 'Dienas no iepriekšējās aktivitātes pabeigšanas',
        'days_from_parent_date_field' => 'Dienas no priekšteča datuma lauka',
        'days_from_specific_activity_completed' => 'Dienas no konkrētas aktivitātes pabeigšanas',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'Kad izveidots',
        'stage_started' => 'Kad sākās posms',
        'previous_activity_completed' => 'Kad iepriekšējā aktivitāte tika pabeigta',
        'parent_date_field' => 'Priekšteča datuma laukā',
        'specific_activity_completed' => 'Konkrēta aktivitāte pabeigta',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'Absolūts',
        'Percentage' => 'Procenti',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'Klienta uzdevums',
        'milestone' => 'Atskaites punkts',
        'internal_task' => 'Iekšējais uzdevums',
        'agency_task' => 'Aģentūras uzdevums',
        'automatic_task' => 'Automātiskais uzdevums',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'Uzdevums',
        'Calls' => 'Zvans',
        'Meetings' => 'Tikšanās',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'Nav',
        'create' => 'Izveides laikā',
        'stage_start' => 'Posma sākšanas laikā',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'Pārmantot',
        'current_user' => 'Pašreizējais lietotājs',
        'parent_assignee' => 'Priekšteča pilnvarotais',
        'user' => 'Lietotājs',
        'team' => 'Darba grupa',
        'user_team' => 'Lietotājs un darba grupa',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'Pārmantot',
        'none' => 'Nav',
        'create' => 'Izveides laikā',
        'stage_start' => 'Posma sākšanas laikā',
        'previous_activity_completed' => 'Iepriekšējā aktivitāte pabeigta',
        'specific_activity_completed' => 'Konkrēta aktivitāte pabeigta',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'Nav sākts',
        'in_progress' => 'Procesā',
        'not_completed' => 'Nav pabeigts',
        'completed' => 'Pabeigts',
        'cancelled' => 'Atcelts',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'Rediģēt posmu',
        'stage_add_task_button' => 'Izveidot uzdevumu',
        'stage_add_meeting_button' => 'Ieplānot tikšanos',
        'stage_add_call_button' => 'Ieplānot zvanu',
        'stage_delete_button' => 'Dzēst posmu',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'Pievienot uzdevumu',
        'activity_add_sub_meeting_button' => 'Ieplānot tikšanos',
        'activity_add_sub_call_button' => 'Ieplānot zvanu',
        'activity_not_applicable_button' => 'Nav piemērojams',
        'activity_delete_button' => 'Dzēst',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'Komplekts nav piemērojams',
        'remove_open_activities' => 'Noņemt atvērtās aktivitātes',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'Noklusējuma',
        'custom' => 'Pielāgot',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'SAŅEMT',
        'POST' => 'SŪTĪT',
        'PUT' => 'IEVIETOT',
        'PATCH' => 'PATCH',
        'DELETE' => 'DZĒST',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'Izlaist pieprasījumu',
        'json' => 'JSON',
        'http_query' => 'HTTP vaicājums',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'Nav atbildes',
        'json' => 'JSON',
        'http_query' => 'HTTP vaicājums',
        'text' => 'Vienkāršs teksts',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'Pirms izveides',
        'after_create' => 'Pēc izveides',
        'before_in_progress' => 'Pirms procesa',
        'after_in_progress' => 'Pēc procesa',
        'before_completed' => 'Pirms pabeigšanas',
        'after_completed' => 'Pēc pabeigšanas',
        'before_not_applicable' => 'Pirms nav piemērojams',
        'after_not_applicable' => 'Pēc nav piemērojams',
        'before_delete' => 'Pirms dzēšanas',
        'after_delete' => 'Pēc dzēšanas',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Sūtt Smart Guide informāciju',
        'custom_body' => 'Sūtīt pielāgotu publikācijas tekstu',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'Procesā',
        'completed' => 'Pabeigts',
        'not_applicable' => 'Nav piemērojams',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'Skatīt ierakstu',
        'create_record' => 'Izveidot ierakstu',
        'update_record' => 'Atjaunināt ierakstu',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'Automātiski izveidot ierakstu',
        'manual_create' => 'Manuāli izveidot ierakstu',
        'automatic_update' => 'Automātiski atjaunināt ierakstu',
        'manual_update' => 'Manuāli atjaunināt ierakstu',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Smart Guide veidne',
        'DRI_SubWorkflow_Templates' => 'Posma veidne',
        'DRI_Workflow_Task_Templates' => 'Aktivitātes veidne',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'Jā',
        'no' => 'Nē',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'Noticis',
        'Not Held' => 'Netika īstenots',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'Noticis',
        'Not Held' => 'Netika īstenots',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'Pabeigts',
        'Not Applicable' => 'Nav piemērojams',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Smart Guide veidne',
        'DRI_SubWorkflow_Templates' => 'Posma veidne',
        'DRI_Workflow_Task_Templates' => 'Aktivitātes veidne',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'Uzdevums',
        'Meetings' => 'Tikšanās',
        'Calls' => 'Zvans',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'Pašreizējais uzdevums',
        'Calls' => 'Pašreizējais zvans',
        'Meetings' => 'Pašreizējā tikšanās',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'Noteikti lietotāji',
        'specific_contacts' => 'Noteiktas kontaktpersonas',
        'related_parent_users' => 'Saistītie priekšteču lietotāji',
        'related_parent_contacts' => 'Saistītās priekšteču kontaktpersonas',
        'add_all_contacts_from_parent' => 'Pievienot visas kontaktpersonas no priekšteča',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'Lietotāji',
        'specific_contacts' => 'Kontaktpersonas',
        'related_parent_users' => 'Lietotāji',
        'related_parent_contacts' => 'Kontaktpersonas',
        'add_all_contacts_from_parent' => 'Kontaktpersonas',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'Minūte(s)',
        'hours' => 'Stunda(s)',
        'days' => 'Diena(s)',
        'months' => 'Mēnesis(ši)',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'Diena(s)',
        'months' => 'Mēnesis(ši)',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'Fiksēts datums',
        'relative' => 'Relatīvs datums',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'Lietotāji',
        'teams' => 'Darba grupas',
        'roles' => 'Lomas',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide Sugar darbībai',
        'sugar_action_to_smart_guide' => 'Sugar darbība Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide posms',
        'Smart Guide Activities' => 'Smart Guide aktivitātes',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'Pabeigts',
        'cancelled' => 'Atcelts',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'Procesā',
        'completed' => 'Pabeigts',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'Procesā',
        'completed' => 'Pabeigts',
        'not_applicable' => 'Nav piemērojams',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'Atzīmēt visas aktivitātes kā Pabeigtas',
        'mark_all_not_applicable' => 'Atzīmēt visas nepabeigtās aktivitātes kā Nav piemērojams',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'Amerikas Savienotās Valstis (Oregona) [us-west-2]',
        'ca-central-1' => 'Kanāda (Centrālā) [ca-central-1]',
        'ap-southeast-1' => 'Āzijas un Klusā okeāna reģions (Singapūra) [ap-southeast-1]',
        'ap-southeast-2' => 'Āzijas un Klusā okeāna reģions (Sidneja) [ap-southeast-2]',
        'eu-central-1' => 'Eiropa (Frankfurte) [eu-central-1]',
        'eu-west-2' => 'Eiropa (Londona) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'Ieraksta galvene', // Studio editing of record views
    'LBL_RECORD_BODY' => 'Vizītkarte', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'Rādīt vairāk', // Studio editing of record views
    'LBL_FAVORITE' => 'Favorīts', // Record view header panel element
    'LBL_FOLLOW' => 'Sekot', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'Sekot saitei',
    'LBL_TOGGLE_VISIBILITY' => 'Pārslēgt redzamību', // Record view header panel element
    'LBL_ACTIVITIES' => 'Darbības',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar un 3-D kubs ir SugarCRM Inc. reģistrētas preču zīmes. ' .
        'Visi citi uzņēmumu un produktu nosaukumi, kas tiek izmantoti vai parādās šajā produktā, var būt preču zīmes, ' .
        'SugarCRM ®, Sugar Enterprise™ un Sugar™ ir SugarCRM Inc. preču zīmes.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ un Sugar™ ir SugarCRM Inc preču zīmes.',
    'LBL_SEND_INVITE' => 'Sūtīt ielūgumu',
    'LBL_INVITEES' => 'Viesi',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'Viesis nesaņems jūsu uzaicinājumu',
    'LBL_SELECT_ACTION_LABEL' => 'Izvēlieties darbību',
    'LBL_TOGGLE_DRAWER' => 'Pārslēgt',
    'LBL_TOUR_NEXT' => 'Nākamais',
    'LBL_TOUR_SKIP' => 'Izlaist',
    'LBL_TOUR_BACK' => 'Atpakaļ',
    'LBL_TOUR_CLOSE' => 'Aizvērt',
    'LBL_TOUR_BTN_DONE' => 'Pabeigts',
    'LBL_TOUR_TAKE_TOUR' => 'Iepazīties',
    'LBL_TOUR_FULL_TOUR' => 'Pilnā apskate',
    'LBL_TOUR_MODULE' => 'Šīs lapas apskate',
    'LBL_TOUR_END_TOUR' => 'apskates beigas',
    'LBL_TOUR_OVERVIEW' => 'Lapas apskats',
    'LBL_TOUR_REVISIT' => 'Uzklikšķiniet šeit lai apskatītu tūri jebkurā laikā.',
    'LBL_MY_AREA_LINKS' => 'Manas apgabala saites:' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Iet gaisā' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'Sveiki' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'Izvērstā meklēšana' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'Sīkāk' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'Rediģēt iekļauto' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'Apskatīt' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Meklēt' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'Meklēt...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'Noņemt' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'Pievienot' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => '1. kolonna' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2. kolonna' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 kolonas' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Izvērstā meklēšana' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'Pievienot' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'Slēpt/Rādīt' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'Dzēst' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'Pievienot' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'Notīrīt' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'Noņemt' /*for 508 compliance fix*/,
    'LBL_ADD' => 'Pievienot' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'Uzņēmuma logo' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'Kalendārs' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'Jūsu atlasītā nolaižamā vērtība mainīja jūsu ieraksta skata izkārtojumu. ' .
        'Šajā jaunajā izkārtojumā paslēpto lauku vērtības ir notīrītas. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'Atvērt',
    'LBL_SIDEBAR_NAV_CLOSE' => 'Aizvērt',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} izvēlne',
    'LBL_GOTO_SUGARCRM_COM' => 'Dodieties uz SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'galvenā moduļa navigācija',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'pārslēgt apakšpaneli',

    'LBL_ADVANCED' => 'Uzlabots',
    'LBL_BASIC' => 'Pamata',
    'LBL_MODULE_FILTER' => 'Filtrēt pēc',
    'LBL_CONNECTORS_POPUPS' => 'Savienojumu uznirstošie logi',
    'LBL_CLOSEINLINE' => 'Aizvērt',
    'LBL_EDITINLINE' => 'Rediģēt',
    'LBL_VIEWINLINE' => 'apskatīt',
    'LBL_INFOINLINE' => 'Informācija',
    'LBL_POWERED_BY_SUGARCRM' => 'Nodrošina SugarCRM',
    'LBL_PRINT' => 'Drukāt',
    'LBL_HELP' => 'Palīdzība',
    'LBL_TOUR' => 'Tūre',
    'LBL_TOUR_LINK' => 'Šīs lapas apskate',
    'LBL_MOBILE' => 'Mobilais tālrunis',
    'LBL_ID_FF_SELECT' => 'Atzīmēt',
    'DEFAULT' => 'Pamata',
    'LBL_SORT' => 'Kārtot',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Pievienot serveri...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'Aktivizēt STMP pa SSL vai TLS?',
    'LBL_NO_ACTION' => 'Nav darbības ar tādu nosaukumu.',
    'LBL_NO_DATA' => 'Dati nav atrasti',
    'LBL_NOT_APPLICABLE' => 'Nav piemērojams',
    'LBL_ROUTING_ADD_RULE' => 'Pievienot likumu',
    'LBL_ROUTING_ALL' => 'vismaz',
    'LBL_ROUTING_ANY' => 'jebkurš',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'Atcelt',
    'LBL_ROUTING_BUTTON_SAVE' => 'Saglabāt likumu',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'Kopēt pastu',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Dzēst Sugar objektu',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Dzēst failu',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'Dzēst e-pastu',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'Pārsūtīt e-pastu',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'Atzīmēt e-pastu',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'Atzīmēt kā lasītu',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Atzīmēt kā nelasītu',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'Pārvietot e-pastu',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'Izpildīt sekojošas darbības',
    'LBL_ROUTING_ACTIONS_REPLY' => 'Atbildēt uz e-pastu',

    'LBL_ROUTING_CHECK_RULE' => "Atrasta kļūda:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'Pārbaudiet visus atzīmētos laukus.',
    'LBL_ROUTING_CONFIRM_DELETE' => "Vai tiešām vēlies dzēst šo likumu? Darbība ir neatgriezeniska",

    'LBL_ROUTING_FLAGGED' => 'karogs uzlikts',
    'LBL_ROUTING_FORM_DESC' => 'Saglabātie likumi uzreiz ir aktīvi.',
    'LBL_ROUTING_FW' => 'FW:',
    'LBL_ROUTING_LIST_TITLE' => 'Likumi',
    'LBL_ROUTING_MATCH' => 'Ja',
    'LBL_ROUTING_MATCH_2' => 'no sekojošajiem nosacījumiem izpildās:',
    'LBL_NOTIFICATIONS' => 'Paziņojumi',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'Kopija',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'Ziņojuma teksts',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'No',
    'LBL_ROUTING_MATCH_NAME' => 'Temats',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'Augsta prioritāte',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Vidēja prioritāte',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Zema prioritāte',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'Uz',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'Satur',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'Nesatur',

    'LBL_ROUTING_NAME' => 'Likuma nosaukums',
    'LBL_ROUTING_NEW_NAME' => 'Jauns likums',
    'LBL_ROUTING_ONE_MOMENT' => 'Uzgaidiet, lūdzu...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Oriģinālais ziņojums sekojošs',
    'LBL_ROUTING_RE' => 'RE:',
    'LBL_ROUTING_SAVING_RULE' => 'Saglabā likumu',
    'LBL_ROUTING_SUB_DESC' => 'Pārbaudītie likumi ir aktīvi. Klikšķiniet uz nosaukuma, lai rediģētu.',
    'LBL_ROUTING_TO' => 'uz',
    'LBL_ROUTING_TO_ADDRESS' => 'uz adresei',
    'LBL_ROUTING_WITH_TEMPLATE' => 'ar sagatavi',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'Šis ieraksts patreiz satur vērtības laukos - Darba tālrunis un Adrese. Lai pārrakstītu šīs vērtības ar sekojošu Darba tālruni un adresi no atlasītā uzņēmuma, klikšķini "Labi". Lai paturētu patreizējās vērtības, klikšķini "Atcelt".',
    'LBL_DROP_HERE' => '[Nomest šeit]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'Rediģēt',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Prefill Gmail&#153; Defaults',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'Nosaukums',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Izejošā e-pasta servera īpašības',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'Pasta pārsūtīšanas aģents',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'Lietot SMTP autentifikāciju?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP parole',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP ports',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP serveris',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'Lietot SSL, kad pieslēdzas',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP lietotāja vārds',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Noklusētais',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Brīdinājums: Nav norādīts lietotājvārds un parole izejošā pasta kontam',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'Nepieciešams SMTP lietotājvārds',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'Nepieciešama SMTP parole',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'E-pasta kontu pārvaldība',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'E-pasta servera POP3 protokols netiks atbalstīts nākamajā laidienā. Tiks atbalstīts tikai IMAP.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'Iestatiet pasta kontus, lai redzētu ienākošos e-pastus no jūsu e-pasta kontiem',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Ievadiet SMTP pasta servera informāciju, kuru izmantot izejošajiem e-pastiem Pasta Kontos.',
    'LBL_EMAIL_ADD' => 'Pievienot e-pastu',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Gatavs',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Notīrīt',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'Uz:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Kopija:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Slēptā kopija:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'Kam/Kopija/Slēptā kopija',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'Jauns saraksts',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'E-pasta adrese',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Pašlaik ir iespējama tikai kontaktpersonas rediģēšana.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filtrs',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'Vārds/Uzņēmuma nosaukums',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Uzvārds',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'Manas kontaktpersonas',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'Mani e-pasta adrešu saraksti',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'Nosaukums',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'Adreses nav atrastas',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Saglabāt un pievienot adrešu grāmatai',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Meklēt',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Atzīmēt e-pasta saņēmējus',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Adrešu grāmata',
    'LBL_EMAIL_REPORTS_TITLE' => 'Atskaites',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'Brīdinājums! Izejošais konts, kuru mēģinat dzēst, ir sasaistīts ar esošu ienākošo kontu. Vai vēlaties turpināt?',
    'LBL_EMAIL_ADDRESSES' => 'E-pasts',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'E-pasta adrese',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'E-pasta adreses',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Importēt Sugar',
    'LBL_EMAIL_ASSIGNMENT' => 'Piešķīrums',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Pievienot',
    'LBL_EMAIL_ATTACHMENT' => 'Pielikums',
    'LBL_EMAIL_ATTACHMENTS' => 'No lokālās sistēmas',
    'LBL_EMAIL_ATTACHMENTS2' => 'No Sugar dokumentiem',
    'LBL_EMAIL_ATTACHMENTS3' => 'Veidņu pielikumi',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'Fails',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Dokuments',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Iegultie',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'Neizdevās augšupielādēt pielikumu',
    'LBL_REMOVING_ATTACHMENT' => 'Noņemu pielikumu...',
    'LBL_EMAIL_BCC' => 'Slēptā kopija',
    'LBL_EMAIL_CANCEL' => 'Atcelt',
    'LBL_EMAIL_CC' => 'Kopija',
    'LBL_EMAIL_CHARSET' => 'Rakstu zīmes',
    'LBL_EMAIL_CHECK' => 'Pārbaudīt pastu',
    'LBL_EMAIL_CHECKING_NEW' => 'Pārbauda jaunos e-pastus',
    'LBL_EMAIL_CHECKING_DESC' => 'Uzgaidiet, lūdzu... <br><br>Ja tā ir pirmā e-pastu pārbaude, tas var aizņemt kādu laiku.',
    'LBL_EMAIL_CLOSE' => 'Aizvērt',
    'LBL_EMAIL_COFFEE_BREAK' => 'Pārbauda jaunos e-pastus. <br><br>Lieliem e-pasta kontiem tas var aizņemt ievērojamu laiku.',
    'LBL_EMAIL_COMMON' => 'Kopīgs',

    'LBL_EMAIL_COMPOSE' => 'E-pasts',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Lūdzu ievadiet e-pasta saņēmēju(us)',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'Attiecināt uz',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'E-pasta ziņojums ir tukšs. Vai tomēr sūtīt?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'E-pasta temats nav aizpildīts. Vai tomērt sūtīt?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(bez temata)',
    'LBL_EMAIL_COMPOSE_READ' => 'Lasīt un veidot e-pastu',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Sūtīt no pasta konta',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'Iespējas',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Ievadiet derīgu e-pasta adresi laukos - Kam, Kopija un Slēptā kopija',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'Vai atcelt šo e-pastu?',
    'LBL_EMAIL_CONFIRM_DELETE' => 'Vai vēlies izņemt šos ierakstus no Jūsu adrešu grāmatas?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'Vai tiešām vēlies dzēst šo parakstu?',

    'LBL_EMAIL_CREATE_NEW' => '--Izveidot saglabāšanas laikā--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Vairāki',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Tukšs',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Sūtītāja nosūtītais datums',
    'LBL_EMAIL_DATE_RECEIVED' => 'Saņemtais datums',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'Piešķirts lietotājam',
    'LBL_EMAIL_DATE_TODAY' => 'Šodien',
    'LBL_EMAIL_DATE_YESTERDAY' => 'Vakar',
    'LBL_EMAIL_DD_TEXT' => 'e-pasts(i) izvēlēts(i).',
    'LBL_EMAIL_DEFAULTS' => 'Noklusējumi',
    'LBL_EMAIL_DELETE' => 'Dzēst',
    'LBL_EMAIL_DELETE_CONFIRM' => 'Vai dzēst atzīmētos ziņojumus?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'e-pasts veiksmīgi izdzēsts.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'Dzēš ziņojumu',
    'LBL_EMAIL_DETAILS' => 'Detaļas',
    'LBL_EMAIL_DISPLAY_MSG' => 'E-pasta attēlošana {0} - {1} no {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'E-pasta adreses(šu) attēlošana {0} - {1} no {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'Rediģēt kontaktpersonu',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Darbam ar kontaktpersonām tiks izmantota tikai primārā adrese.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'Rediģēt adresātu sarakstu',

    'LBL_EMAIL_EMPTYING_TRASH' => 'Iztīra miskasti',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'Izejošā servera dzēšana',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'Kešfailu tīrīšana',
    'LBL_EMAIL_EMPTY_MSG' => 'Nav e-pastu, ko attēlot.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'Nav e-pasta adrešu, ko attēlot.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'Kataloga nosaukumam jābūt unikālam, un tas nedrīkst būt tukšs. Lūdzu mēģiniet vēlreiz.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'Nevar izdzēst katalogu. Katalogam vai tā pēctecim ir sasaistīti e-pasti vai pastkastes.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'Nevar noteikt paredzēto katalogu pēc konteksta. Mēģiniet vēlreiz.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Lūdzu pārbaudiet savus iestatījumus.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Lūdzu pārliecinieties, vai Jūs ievadījāt uzvārdu.',
    'LBL_EMAIL_ERROR_DESC' => 'Atklātas kļūdas: ',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'Jums nav piekļuves tiesību šim apgabalam. Sazinieties ar vietnes administratoru, lai iegūtu piekļuvi.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugar kataloga vārdiem jābūt unikāliem.',
    'LBL_EMAIL_ERROR_EMPTY' => 'Lūdzu ievadīt kādu meklēšanas kritēriju.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'Notikusi kļūda',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'E-pasta saraksts ar tādu nosaukumu jau eksistē',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Ziņa izņemta no servera',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'Ziņa izņemta no servera vai pārvietota uz citu katalogu.',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'Savienojums ar pasta serveri neizdevās. Lūdzu sazinieties ar administratoru',
    'LBL_EMAIL_ERROR_MOVE' => 'E-pasta pārvietošana starp serveriem un/vai pasta kontiem šobrīd nav pieejama.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'Pārvietot kļūdu',
    'LBL_EMAIL_ERROR_NAME' => 'Nepieciešams lietotāja vārds.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'Sūtītāja adrese ir obligāta. Norādiet derīgu e-pasta adresi.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'Lūdzu sagādājiet failu.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'IMAP kataloga nosaukuma mainīšana šobrīd nav pieejama.',
    'LBL_EMAIL_ERROR_SERVER' => 'Nepieciešama pasta servera adrese.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'Pasta kontu nevar saglabāt.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'Notikusi kļūda, sazinoties ar pasta serveri.',
    'LBL_EMAIL_ERROR_USER' => 'Nepieciešams lietotāja vārds.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'Nepieciešama parole.',
    'LBL_EMAIL_ERROR_PORT' => 'Nepieciešams pasta servera ports.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'Nepieciešams servera protokols.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'Ir jānorāda Monitorētais katalogs',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'Nepieciešams miskastes katalogs.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'Informācija nav pieejama',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'Nav norādīts izejošais pasta serveris.',
    'LBL_EMAIL_FOLDERS' => 'Mapes',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'Pārvietot uz',
    'LBL_EMAIL_FOLDERS_ADD' => 'Pievienot',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Pievienot jaunu katalogu',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Mainīt kataloga nosaukumu',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Saglabāt',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Pievienot šo katalogu',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'Šo katalogu nevar izmainīt',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'Vai tiešām vēlaties dzēst šo katalogu?\nProcess ir neatgriežams.\nKataloga dzēšana tiks attiecināta uz visiem tajā esošajiem katalogiem.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'Jauns kataloga nosaukums',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Pirms šīs darbības veikšanas izvēlieties katalogu.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'Kataloga pārvaldība',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Lieto grupu',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'Attiecināms uz darba grupu',
    'LBL_EMAIL_FORWARD' => 'Pārsūtīt',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => 'Lejuplādēti [[count]] no [[total]] e-pastiem',
    'LBL_EMAIL_FOUND' => 'Atrasts',
    'LBL_EMAIL_FROM' => 'No',
    'LBL_EMAIL_GROUP' => 'grupa',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'Grupa',
    'LBL_EMAIL_HOME_FOLDER' => 'Sākums',
    'LBL_EMAIL_HTML_RTF' => 'Sūtīt HTML',
    'LBL_EMAIL_IE_DELETE' => 'Pasta konta dzēšana',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'Paraksta dzēšana',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'Vai tiešām vēlaties dzēst šo e-pasta kontu?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Veiksmīgi izdzēsts.',
    'LBL_EMAIL_IE_SAVE' => 'Pasta konta informācijas saglabāšana',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'E-pasta importēšana',
    'LBL_EMAIL_IMPORT_EMAIL' => 'Importēt uz Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'Importēt iestatījumus',
    'LBL_EMAIL_INVALID' => 'Nederīgs',
    'LBL_EMAIL_LINK_RECORD' => 'Spiediet šeit',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'Mainīt adresātu saraksta nosaukumu',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'Ievadīt jaunu nosaukumu šim adresātu sarakstam',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'Vai vēlies izņemt šos ierakstus no Jūsu adresātu saraksta?',
    'LBL_EMAIL_LOADING' => 'Notiek ielāde ...',
    'LBL_EMAIL_MARK' => 'Atzīmēt',
    'LBL_EMAIL_MARK_FLAGGED' => 'Kā iezīmēts',
    'LBL_EMAIL_MARK_READ' => 'Kā izlasīts',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'Kā neiezīmēts',
    'LBL_EMAIL_MARK_UNREAD' => 'Kā neizlasīts',
    'LBL_EMAIL_ASSIGN_TO' => 'Piešķirt',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'Izveidot katalogu',
    'LBL_EMAIL_MENU_COMPOSE' => 'Izveidot',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Dzēst katalogu',
    'LBL_EMAIL_MENU_EDIT' => 'Rediģēt',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Iztīrīt miskasti',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Sinhronizēt',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Iztīrīt keša failus',
    'LBL_EMAIL_MENU_REMOVE' => 'Noņemt',
    'LBL_EMAIL_MENU_RENAME' => 'Pārsaukt',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Pārsaukt katalogu',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Kataloga pārsaukšana',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Lūdzu veiciet izvēli pirms mēģināt veikt šo darbību.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Izveidot katalogu (attālināti vai Sugar sistēmā)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'Arhivēt šo/šos e-pastu(us) uz SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'Sūtīt sekojošajiem adresātu sarakstiem',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'Sūtīt e-pastu kontaktpersonai',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Noņemt kontaktpersonu',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'Dzēst šo/šos e-pastu(us)',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Dzēst katalogu (attālināti vai Sugar sistēmā)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Rediģēt kontaktpersonu',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Rediģēt adresātu sarakstu',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Iztukšot visus atkritumu katalogus saviem pasta kontiem',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'Atzīmēt šo/šos e-pastu(us), kā atzīmētus',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'Atzīmēt šo/šos e-pastu(us) kā izlasītus',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'Atzīmēt šo/šos e-pastu(us) kā neatzīmētus',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'Atzīmēt šo/šos e-pastu(us) kā nelasītus',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Izņemt adresātu sarakstus',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Pārsaukt katalogu (attālināti vai Sugar sistēmā)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'Atbildēt uz šo/šiem e-pastu(tiem)',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'Atbildēt visiem šī e-pasta saņēmējiem',

    'LBL_EMAIL_MESSAGES' => 'ziņojumi',

    'LBL_EMAIL_ML_NAME' => 'Saraksta nosaukums',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'Izvēlētās saraksta adreses',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'Pieejamās saraksta adreses',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-Click</b>, lai izvēlētos vairākus<br />(Mac lietotājiem jāizmanto <b>CMD-Click</b>)',

    'LBL_EMAIL_NO' => 'No',
    'LBL_EMAIL_NOT_SENT' => 'Radusies problēma ar pieprasījuma e-pasta sūtīšanu. Lūdzu sazinieties ar sistēmas administratoru.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'Neizdevās ievietot laukā users_password_link.',

    'LBL_EMAIL_OK' => 'Labi',
    'LBL_EMAIL_ONE_MOMENT' => 'Uzgaidiet, lūdzu...',
    'LBL_EMAIL_OPEN_ALL' => 'Atvērt vairākas ziņas',
    'LBL_EMAIL_OPTIONS' => 'E-pasta apstrādes iespējas',
    'LBL_EMAIL_QUICK_COMPOSE' => 'Ātrā izveide',
    'LBL_EMAIL_OPT_OUT' => 'Nelieto',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Nelieto vai nederīgs',
    'LBL_EMAIL_PAGE_AFTER' => 'no {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'lapa',
    'LBL_EMAIL_PERFORMING_TASK' => 'Izpilda uzdevumu',
    'LBL_EMAIL_PRIMARY' => 'Primārs',
    'LBL_EMAIL_PRINT' => 'Drukāt',

    'LBL_EMAIL_QC_BUGS' => 'Kļūda',
    'LBL_EMAIL_QC_CASES' => 'Pieteikums',
    'LBL_EMAIL_QC_LEADS' => 'Interesents',
    'LBL_EMAIL_QC_CONTACTS' => 'Kontaktpersona',
    'LBL_EMAIL_QC_TASKS' => 'Uzdevums',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'Iespēja',
    'LBL_EMAIL_QUICK_CREATE' => 'Ātrā izveide',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'Katalogu pārģenerēšana',
    'LBL_EMAIL_RELATE_TO' => 'Attiecas uz',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'Apskatīt saites',
    'LBL_EMAIL_RECORD' => 'E-pasta ieraksts',
    'LBL_EMAIL_REMOVE' => 'Noņemt',
    'LBL_EMAIL_REPLY' => 'Atbildēt',
    'LBL_EMAIL_REPLY_ALL' => 'Atbildēt visiem',
    'LBL_EMAIL_REPLY_TO' => 'Atbildēt-uz',
    'LBL_EMAIL_RETRIEVING_LIST' => 'E-pasta saraksta iegūšana',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Ziņojuma iegūšana',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'E-pasta ieraksta iegūšana',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Lūdzu izvēlieties tikai vienu e-pasta ierakstu',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'Atgriezties uz iepriekšējo moduli?',
    'LBL_EMAIL_REVERT' => 'Atgriezt atpakaļ',
    'LBL_EMAIL_RELATE_EMAIL' => 'Saistītais e-pasts',

    'LBL_EMAIL_RULES_TITLE' => 'Likumu pārvaldība',

    'LBL_EMAIL_SAVE' => 'Saglabāt',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'Saglabāt un atbildēt',
    'LBL_EMAIL_SAVE_DRAFT' => 'Saglabāt sagatavi',

    'LBL_EMAIL_SEARCHING' => 'Veic meklēšanu',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'Paplašinātā meklēšana',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'Datums no',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Datums līdz',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'Pamatteksts',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'Nav rezultātu, kuri atbilstu Jūsu meklēšanas kritērijiem',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Meklēšanas rezultāti',
    'LBL_EMAIL_SEARCH_TITLE' => 'Vienkārša meklēšana',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'Meklēt e-pasta kontu',

    'LBL_EMAIL_SELECT' => 'Izvēlēties',

    'LBL_EMAIL_SEND' => 'Nosūtīt',
    'LBL_EMAIL_SENDING_EMAIL' => 'Sūta e-pastu',

    'LBL_EMAIL_SETTINGS' => 'Uzstādījumi',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 rindas',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 kolonas',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'Izkārtojuma stils',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'E-pasta konti',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Notīrīt formu',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'Importēt e-pastus atbilstoši skatam',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Pārbaudīt jaunu pastu',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Izmanto priekšskatījuma rūti',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Izmantot uznirstošo logu',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'E-pastu skaits lapā',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'Rediģēt pasta kontu',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'Mapes',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'No adreses:',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'E-pasta adrese testa paziņojumam:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'Uz e-pasta adresi',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'Saņemts no',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Atbildēt uz adresi',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Pilnekrāns',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Sinhronizēt visus pasta kontus',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'E-pasts aizsūtīts uz norādīto adresi, izmantojot piedāvātos izejošā pasta iestatījumus. Lūdzu pārbaudiet, vai e-pasts tika saņemts, lai pārbaudītu vai iestatījumi ir pareizi.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Veicot šo darbību, tiks sinhronizēti pasta konti un to saturs.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'Vai vēlaties veikt pilnu sinhronizāciju?\nApjomīgi pasta konti var aizņemt vairākas minūtes.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Nospiediet Shift pogu vai Ctrl pogu, lai izvēlētos vairākus katalogus.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'Vispārīgi',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Pieejamie grupas katalogi',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Izveidot grupas katalogus',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Grupas katalogu saglabāšana',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Grupas kataloga izgūšana',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Rediģēt grupas katalogu',

    'LBL_EMAIL_SETTINGS_NAME' => 'Pasta konta nosaukums:',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Norādiet e-pastu skaitu Iesūtnes lapā. Šim iestatījumam nepieciešams lapas atjauninājums, lai tas stātos spēkā.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'Pasta konta izgūšana',
    'LBL_EMAIL_SETTINGS_RULES' => 'Likumi',
    'LBL_EMAIL_SETTINGS_SAVED' => 'Iestatījumi ir saglabāti.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'Jums ir jāpārlādē lapa, lai jaunie iestatījumi stātos spēkā.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'E-pastus sūtīt tikai vienkāršā tekstā',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Aktīvs',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'E-pastu skaits lapā',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'Novietot cilnes lejā',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Vizuālie iestatījumi',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Izvēles',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Parādīt uzlabotu',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Pieejamie lietotāja katalogi',
    'LBL_EMAIL_ERROR_PREPEND' => 'Kļūda.',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'Ārējais pasta serveris, kas izvēlēts izmantotajam pasta kontam, ir nederīgs. Pārbaudiet iestatījumus vai izvēlieties citu pasta serveri pasta kontam.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'Izejošais pasta serveris nav nokonfigurēts, lai sūtītu e-pastus. Nokonfigurējiet izejošā pasta serveri vai izvēlieties izejošā pasta serveri kontam, kuru izmantojat, Iestatījumi >> Pasta Konts.',
    'LBL_EMAIL_SHOW_READ' => 'Parādīt visu',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Rādīt tikai nelasīto',
    'LBL_EMAIL_SIGNATURES' => 'Paraksti',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'Izveidot parakstu',
    'LBL_EMAIL_SIGNATURE_NAME' => 'Paraksta vārds',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'Paraksta teksts',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Google mazāk drošas lietotnes',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! pasts',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'Cits',
    'LBL_EMAIL_AUTHORIZE' => 'Autorizēt',
    'LBL_EMAIL_AUTHORIZED' => 'Autorizēts',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'Nav autorizēts',
    'LBL_EMAIL_AUTH_WARNING' => 'Administratoram ir jākonfigurē {0} konektors sadaļā Administrators > Konektori, tikai pēc tam jūs varēsiet iestatīt šo kontu. Plašāku inforāciju skatiet {1} dokumentācijā.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'Kļūda, izgūstot konektora informāciju',
    'LBL_EMAIL_AUTH_FAILURE' => 'Autorizācijas kļūme.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'Pirms saglabāšanas autorizējiet uzņēmumu.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'Pirms testēšanas autorizējiet uzņēmumu.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'Uzņēmums nav autorizēts',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Attālinātie katalogi ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugar katalogi ]',
    'LBL_EMAIL_SUBJECT' => 'Temats',
    'LBL_EMAIL_SUCCESS' => 'Veiksmīgi',
    'LBL_EMAIL_SUGAR_FOLDER' => 'Sugar katalogs',
    'LBL_EMAIL_TEAMS' => 'Attiecināms uz darba grupām',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'E-pasta veidnes teksts ir tukšs',
    'LBL_EMAIL_TEMPLATES' => 'Veidnes',
    'LBL_EMAIL_TEXT_FIRST' => 'Pirmā lapa',
    'LBL_EMAIL_TEXT_PREV' => 'Iepriekšējā lapa',
    'LBL_EMAIL_TEXT_NEXT' => 'Nākošā lapa',
    'LBL_EMAIL_TEXT_LAST' => 'Pēdējā lapa',
    'LBL_EMAIL_TEXT_REFRESH' => 'Atjaunot',
    'LBL_EMAIL_TO' => 'Kam',
    'LBL_EMAIL_TOGGLE_LIST' => 'Ieslēgt sarakstu',
    'LBL_EMAIL_VIEW' => 'Skatījums',
    'LBL_EMAIL_VIEWS' => 'Skatījumi',
    'LBL_EMAIL_VIEW_HEADERS' => 'Attēlot galveni',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'Drukājama versija',
    'LBL_EMAIL_VIEW_RAW' => 'Attēlot neapstrādātu e-pastu',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'Iespēja netiek atbalstīta, ja to lieto ar POP3.',
    'LBL_DEFAULT_LINK_TEXT' => 'Noklusētais saites teksts.',
    'LBL_EMAIL_YES' => 'Jā',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Sūtīt testa e-pastu',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Testa e-pasts aizsūtīts',


    'LBL_EMAIL_MESSAGE_NO' => 'Ziņojums nr.',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'Importēšana pabeigta',
    'LBL_EMAIL_IMPORT_FAIL' => 'Importēšana neveiksmīga. Ziņojums jau ir importēts vai izdzēsts no servera.',

    'LBL_EMAILS_FROM' => 'Nosūtītie epasti',
    'LBL_EMAILS_RECEIVED' => 'Saņemtie epasti',
    'LBL_EMAIL_ADDRESSES_USED' => 'E-pastos izmantotās e-pasta adreses',
    'LBL_EMAIL_ADDRESS' => 'E-pasta adrese',
    'LBL_FROM' => 'No',
    'LBL_TO' => 'Kam',
    'LBL_CC' => 'Kopija',
    'LBL_BCC' => 'Slēptā kopija',

    'LBL_START_DATE' => 'Sākuma datums',
    'LBL_END_DATE' => 'Beigu datums',
    'LBL_START' => 'Sākums',
    'LBL_END' => 'Beigas',
    'LBL_DATE_LINKED' => 'Saistītais datums',

    'LBL_LINK_NONE' => 'Neviens',
    'LBL_LINK_ALL' => 'Viss',
    'LBL_LINK_RECORDS' => 'Ieraksti',
    'LBL_LINK_SELECT' => 'Izvēlēties',
    'LBL_LINK_ACTIONS' => 'Darbības',
    'LBL_LINK_MORE' => 'Vairāk',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'Apstiprināt',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'Vai vēlaties aizvērt šo #module#?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'Turpmāk nerādīt šo ziņu:',
    'LBL_INVALID_FILE_EXTENSION' => 'Nederīgs faila paplašinājums',
    'LBL_LIST_TEAM' => 'Darba grupa',
    'LBL_TEAM' => 'Darba grupa:',
    'LBL_TEAMS' => 'Darba grupas',
    'LBL_TEAM_SET_ID' => 'Darba grupu kopas ID',
    'LBL_TEAM_SET_SELECTED_ID' => 'Izvēlētās darba grupas noteiktais ID',
    'LBL_TEAM_SET_SELECTED' => 'Atzīmēti',
    'LBL_TEAM_SET_ENABLE' => 'Iespējot papildu atļaujas',
    'LBL_TEAM_SET_DISABLE' => 'Atspējot papildu atļaujas',
    'LBL_TEAM_SET' => 'Darba grupu kopa',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'Atlasītās komandas',
    'LBL_SEARCH_UNAVAILABLE' => 'Meklēšana nav pieejama. Lūdzu mēģiniet vēlāk.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'Nav norādīta galvenā darba grupa',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'Kļūda, mēģinot izņemt primāro darba grupu id [{0}] priekš moduļa [{1}] ar id [{2}]',
    'LBL_TEAM_ADD' => 'Pievienot&nbsp; Darba grupu',
    'LBL_TEAM_REMOVE' => 'Noņemt darba grupu',
    'LBL_TEAM_PRIMARY' => 'Iestatīt kā galveno darba grupu',

    'LBL_CLOSE_BUTTON_LABEL' => 'Aizvērt',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} atzīmēts ar {{status}}.',

    'LBL_FOCUS' => 'Fokuss',

    'LBL_QUERY_VALID' => 'Derīgs',
    'LBL_QUERY_ERROR' => 'Kļūda!',
    'LBL_QUERY_CHILD' => 'Pareizs apakšvaicājums',
    'ERROR_EXAMINE_MSG' => 'Lūdzu pārbaudiet, zemāk esošo kļūdas ziņojumu:',
    'NO_QUERY_SELECTED' => 'Datu formāts, kuru izvēlējāties, nesatur vaicājumu. Lūdzu izvēlieties pielāgoto vaicājumu šim datu formātam.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'Notikusi kļūda:',
    'ERR_AJAX_LOAD_FAILURE' => 'Apstrādājot jūsu pieprasījumu notikusi kļūda, vēlāk mēģini vēlreiz.',
    'ERR_AJAX_LOAD_FOOTER' => 'Ja kļūda atkārtojas, palūdziet administratoru, lai deaktivizē Ajax šim modulim',
    'ERR_CREATING_FIELDS' => 'Kļūda aizpildot papildus informācijas laukus:',
    'ERR_CREATING_TABLE' => 'Kļūda veidojot tabulu:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'Decimālais atdalītājs nevar būt tāds pats kā tūkstošu atdalītājs. 

  Lūdzu nomainiet to vērtības.',
    'ERR_DELETE_RECORD' => 'Lai dzēstu kontaktpersonu, jānorāda ieraksta numurs.',
    'ERR_EXPORT_DISABLED' => 'Eksporta funkcija izslēgta',
    'ERR_EXPORT_TYPE' => 'Kļūdas eksportēšana',
    'ERR_REPORTS_DISABLED_EXPORT' => 'Atskaišu eksportēšana ir atspējota',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'Eksportēt var tikai administratora lietotāji',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'Atskaitē tiek izmantoti moduļi bez eksporta piekļuves',
    'ERR_REPORTS_EXPORT_OWNER' => 'Atskaitē tiek izmantoti moduļi ar īpašnieka eksporta piekļuvi',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'Atskaitē tiek izmantoti moduļi ar Ierobežotā saraksta piekļuvi',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'Atskaitē tiek izmantoti moduļi ar Ierobežotā skata piekļuvi',
    'ERR_REPORTS_ACCESS_DISABLED' => 'Atskaitē tiek izmantoti moduļi ar ierobežotu piekļuvi',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'Atskaitē tiek izmantoti lauki ar ierobežotu piekļuvi',
    'ERR_INVALID_AMOUNT' => 'Ievadiet derīgu daudzumu',
    'ERR_INVALID_DATE_FORMAT' => 'Datuma formātam jābūt:',
    'ERR_INVALID_DATE' => 'Ievadiet derīgu datumu.',
    'ERR_INVALID_DAY' => 'Ievadiet derīgu dienu.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'nederīga e-pasta adrese.',
    'ERR_INVALID_FILE_REFERENCE' => 'Nederīga faila atsauce',
    'ERR_INVALID_HOUR' => 'Ievadiet derīgu stundu.',
    'ERR_INVALID_MONTH' => 'Ievadiet derīgu mēnesi.',
    'ERR_INVALID_TIME' => 'Ievadiet derīgu laiku.',
    'ERR_INVALID_YEAR' => 'Ievadiet derīgu 4 zīmju skaitli gadam.',
    'ERR_NEED_ACTIVE_SESSION' => 'Lai eksportētu saturu, nepieciešama aktīva sesija.',
    'ERR_NO_HEADER_ID' => 'Šajā motīvā šī iespēja nav pieejama.',
    'ERR_NOT_ADMIN' => 'Neautorizēta piekļuve administratora funkcijām.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'Paroles pārvaldība ir pieejama tikai <a href="%s" target="_blank">SugarCloud iestatījumos</a>.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'Ja vēlaties veikt izmaiņas tikai lasāmajos laukos, sazinieties ar savu Sugar administratoru.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'Piekļūstiet <a href="{0}" target="_blank">SugarCloud iestatījumiem</a>, lai veiktu izmaiņas tikai lasāmajos laukos.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'Nav pieejams obligātais lauks:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'Nederīgs obligātais lauks',
    'ERR_INVALID_VALUE' => 'Nederīga vērtība:',
    'ERR_NO_SUCH_FILE' => 'Šāda faila nav jūsu sistēmā',
    'ERR_NO_SINGLE_QUOTE' => 'Nevar lietot vienu pēdiņu/apostrofu priekš',
    'ERR_NOTHING_SELECTED' => 'Pirms turpināt veiciet izvēli.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'Iespēja ar nosaukumu %s jau eksistē. Zemāk ievadi citu vārdu.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'Nav ievadīts iespējas nosaukums.  Zemāk ievadi iespējas nosaukumu.',
    'ERR_QUOTE_CONVERTED' => 'Šis Piedāvājums jau ir konvertēts uz Iespēju',
    'ERR_POTENTIAL_SEGFAULT' => 'Iespējams, konstatēta Apache segmentācijas kļūda.  Lūdzu, informējiet sistēmas administratoru, lai viņš par to varētu paziņot SugarCRM izstrādātājiem.',
    'ERR_SELF_REPORTING' => 'Lietotājs nevar būt tiešais vadītājs pats sev.',
    'ERR_SINGLE_QUOTE' => 'Apostrofa/vienas pēdiņas lietošana šai laukā nav atļauta.  Lietojiet citu simbolu.',
    'ERR_SQS_NO_MATCH_FIELD' => 'Nav atbilstības šim laukam:',
    'ERR_SQS_NO_MATCH' => 'Nav atbilstības',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Meta-data definīcijā atribūtam displayParams norādiet  $#39;key$#39; indeksu',
    'ERR_EXISTING_PORTAL_USERNAME' => 'Kļūda. Portāla nosaukums jau ir piesaistīts citam kontaktam.',
    'ERR_PORTAL_NAME_CHECK' => 'Nevar pārbaudīt vai Portāla lietotāja vārds ir unikāls',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'Lauka vērtība nav pabeidzama ar pareizo vērtību',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'Notikusi kļūda mēģinot saglabāt ārējo kontu.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'Notika kļūda augšuplādējot. Lūdzu pārliecinieties vai augšuplādējamais fails nav tukšs.',
    'ERR_NO_DB' => 'Nevar savienoties ar datubāzi. Aplūkojiet failu sugarcrm.log detalizētai informācijai.',
    'ERR_DB_FAIL' => 'Datubāzes atteikums. Lūdzu aplūkojiet failu sugarcrm.log, detalizētam apskatam.',
    'ERR_EXTERNAL_API_403' => 'Atļauja liegta. Faila tips nav atbalstīts.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth Access Tokens nav pieejams.',
    'ERR_DB_VERSION' => 'Sugar CRM {0} failus var izmantot tikai kopā ar  Sugar CRM {1} datubāzi.',
    'ERR_DB_QUERY' => '{0}: vaicājums neizdevās: {1}',
    'ERR_UW_RETIRED' => 'atjauninājumu vednis šajā versijā nav pieejams',
    'ERR_NOT_CLOUD_INSTANCE' => 'Šī Sugar instance vai nu nav SugarCloud instance, vai nav konfigurēta izmantošanai ar SugarCloud Insights.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'Jums nav tiesību veidot {moduleName}. Sazinieties ar administratoru ja jums ir nepieciešama piekļuve.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'Pašreizējais lietotājs nav pilnvarots izmainīt {moduleName} konfigurācijas iestatījumus',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'Pašreizējais lietotājs nav pilnvarots izmainīt {moduleName} konfigurācijas iestatījumus',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'Jums nav piekļuves izlases {moduleName}. Ja nepieciešama piekļuve, sazinieties ar administratoru.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'Jums nav tiesību parakstīties uz moduli {moduleName}. Sazinieties ar sistēmas administratoru, ja jums ir nepieciešama piekļuve.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'worksheet_columns_related_fields netika atrasti pieprasījumā',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns nav masīvā',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'summary_columns_related_fields netika atrasti pieprasījumā',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows nav masīvā',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rows_related_fields netika atrasti pieprasījumā',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'Pieprasījums neizdevās nezināmas kļūdas dēļ.',
    'EXCEPTION_FATAL_ERROR' => 'Jūsu pieprasījumu neizdevās izpildīt. Notika fatāla kļūda. Apskaties žurnālus papildus informācijai.',
    'EXCEPTION_NEED_LOGIN' => 'Jums ir jāpiesakās lai izpildītu šo darbību.',
    'EXCEPTION_INVALID_TOKEN' => 'Jūsu autentifikācijas atslēga ir nederīga',
    'EXCEPTION_NOT_AUTHORIZED' => 'Jums nav tiesību izpildīt šo darbību. Sazinieties ar administratoru, ja jums ir nepieciešama piekļuve.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'Jums nav atļaujas skatīt datus. Sazinieties ar administratoru, ja jums nepieciešama piekļuve.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'Jūs nevariet piekļūt Portālam, jo jūsu portāla lietotāja konts ir neaktīvs. Sazinieties ar lietotāju atbalstu, ja ir nepieciešama piekļuve.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'Portāls nav pareizi nokonfigurēts. Sazinieties ar portāla administratoru lai saņemtu palīdzību.',
    'EXCEPTION_NO_METHOD' => 'Jūsu pieprasījums netiek nodrošināts. Norādītajā ceļā nav atrodama  HTTP metode jūsu pieprasījumam.',
    'EXCEPTION_NOT_FOUND' => 'Jūsu pieprasītais resurs nav atrodams. Norādītajā ceļā nav atrodama pieprasījuma apstrādes funkcija.',
    'EXCEPTION_MISSING_PARAMTER' => 'Jūsu pieprasījumā trūkst obligāta parametra.',
    'EXCEPTION_INVALID_PARAMETER' => 'Parametrs jūsu pieprasījumā nav derīgs.',
    'EXCEPTION_REQUEST_FAILURE' => 'Jūsu pieprasījumu neizdevās izpildīt.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'Jūsu metadati vai lietotāja hash nesakrīt ar serveri. Lūdzu atkārtoti sinhronizējiet metadatus.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'Jūsu pieprasījums ir par lielu lai to apstrādātu.',
    'EXCEPTION_EDIT_CONFLICT' => 'Rediģēšanas konflikts, lūdzu pārlādējiet ieraksta datus.',
    'EXCEPTION_METADATA_CONFLICT' => 'Metadatu konflikts, pārlādējiet metadatus.',
    'EXCEPTION_CLIENT_OUTDATED' => 'Jūsu programmatūra ir novecojusi, lūdzu atjauniniet pirms mēģiniet pieslēgties no jauna.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'Savienotājā vai integrācijas pieprasījums izraisīja neveiksmīgu atbildi.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM darbojas uzturēšanas režīmā. Tikai administratori var pieteikties sistēmā. Lai saņemtu papildus informāciju sazinieties ar administratoru.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'Serveris nevar apstrādāt jūsu pieprasījumu, jo šajā laikā ir aizņemts vai nav pieejams.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'Meklētājprogramma uz laiku nav pieejama.',
    'EXCEPTION_SEARCH_RUNTIME' => 'Atgadījusies meklēšanas dziņa izpildlaika kļūda. Sazinieties ar savu sistēmas administratoru.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'Nevar rediģēt procesa nobloķētu laiku.',
    'EXCEPTION_MODULE_DISABLED' => 'Šis modulis ir atslēgts pašreizējam lietotājam.',
    'EXCEPTION_FIELD_DISABLED' => 'Šis lauks ir atslēgts pašreizējam lietotājam.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'Šis klients nav atļauts',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'Iespēja augšupielādēt pakotnes nav pieejama jūsu licences tipam',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'Nosacījums, radās vispārīgas kļūmes vai kļūdas dēļ. Šā izņēmuma iemesli var būt dažādi, taču parasti neietilpst konkrētā API izņēmumā.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'Pieprasījumu neizdevās apstrādāt, jo radās kļūda ar atbildi. Tas parasti nozīmē, ka radusies fatāla kļūda, un ka konkrēto kļūmi var identificēt lietojumprogrammu žurnālā.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'Jūsu izmantotā API versija nav pareiza pašreizējam pieprasījumam.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'Pieprasītajam galapunktam ir nepieciešama autentifikācija, un pieprasījumu veikušais lietotājs vēl nav autentificējis.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'Norāda, ka ar pieprasījumu piestādītā atzīme ir nederīga. Tas parasti notiek sakarā ar atzīmes termiņa beigām, bet varētu būt arī tāpēc,, ka atzīme ir slikti izveidota vai nav pareiza.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'Norāda, ka pieprasītajam lietotājam nav pilnvaru veikt pieprasīto darbību.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'Portāla konts, kas saistīts ar pieteijušos lietotāju, pašlaik nav aktīvs. Nepieciešama rīcība no klientu atbalsta dienesta puses.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'Norāda, ka portāla lietojumprogramma nav pareizi konfigurēta un nevar tikt izmantota. Nepieciešama darbība no portāla administratora puses.',
    'EXCEPTION_NO_METHOD_DESC' => 'Šis galapunkts neatbalsta pieprasīto HTTP pieprasījuma tipu. Tā var notikt, ja, piemēram, NOSŪTĪŠANAS pieprasījums tiek veikts galapunktā, kas paredzēts pieprasījuma SAŅEMŠANAI.',
    'EXCEPTION_NOT_FOUND_DESC' => 'Galapunkts nevarēja atrast resursu pieprasījumam, vai arī nav apdarinātāja pieprasījumam.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'Norāda, ka var būt vienlaicīgi ieraksta rediģējumi un pašreizējais ieraksta rediģēšanas pieprasījums ietekmēs ieraksta iepriekšējo rediģējumu.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'Norāda, ka metadati serverī neatbilst metadatiem, ko klients pašlaik izmanto. Tas varētu notikt pēc sistēmas iestatījumu nomaiņas, pēc moduļu izmaiņām studijā, vai pēc jaunu moduļu ieviešanas citu sistēmas izmaiņu starpā.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'Pieprasījums ir pārāk liels, lai to varētu apstrādāt serveris.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'Norāda, ka pieprasījumā trūkst obligātā parametra.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'Norāda, ka pieprasījumā nosūtītais parametrs nav derīgs.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'Pieprasījumu neizdevās pabeigt.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'Norāda, ka klients, kas patērē API, ir novecojis un ir jāatjaunina pirms turpmākas API izmantošanas.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'Norāda, ka pieprasījumu, kas tika veikts, izmantojot cita pakalpojuma API, galapunktu vai URI, nav izdevies, vai arī serveris to nevarēja apstrādāt.',
    'EXCEPTION_MAINTENANCE_DESC' => 'SugarCRM versija, kas apkalpo API, ir apkopes režīmā. API piekļuve ir ierobežota tikai administratoriem.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'Norāda, ka serveris ir aizņemts, pārslogots vai nestrādā.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'Meklētājprogrammas papildu procesors šobrīd nav pieejams savienojuma problēmu dēļ. Pārbaudiet savienojumu un konfigurāciju Admin-> meklēšana-> tests.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'Meklētājprogrammā radās izpildlaika izņēmums. Skatīt sugarcrm.log, lai saņemtu sīkāku informāciju.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'Nevar rediģēt lauku, ko ir nobloķējis notiekošs process.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s ir nobloķējis notiekošs process, un to nevar rediģēt.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s ir nobloķējis notiekošs process, un tos nevar rediģēt.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'Šis modulis ir atslēgts pašreizējam lietotājam.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'Šis lauks ir atslēgts pašreizējam lietotājam.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'Šis klients nav atļauts',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'Fails ar tādu pašu nosaukumu jau sistēmā eksistē.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'Kļūda, laika periods nav nodefinēts datumam {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'Šim laika periodam jau ir apakšperiodi',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'Pakārtotiem laika periodiem nevar būt apakšperiodu',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'Nevar ielādēt nevienu laika periodu ar tipu: {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'Nav aktīvu laika posmu pašreizējiem iestatījumiem.',
    'LBL_CURRENT_TIMEPERIOD' => 'Tekošais laika periods',
    'LBL_PREVIOUS_TIMEPERIOD' => 'Iepriekšējais laika periods',
    'LBL_NEXT_TIMEPERIOD' => 'Nākošais laika periods',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'Iepriekšējais,Tekošais,Nākošais',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'Ierakstus ar slēgtu pārdošanas posmu nevar izdzēst.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'Ierakstus ar slēgtu pārdošanas posmu nevar izdzēst.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'Vienam vai vairākiem no atzīmētajiem ierakstiem ir slēgts pārdošanas posms un to nevar dzēst.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'Vienam vai vairākiem no atzīmētajiem ierakstiem ir slēgts statuss un to nevar dzēst.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'Uzņēmums',
    'LBL_OLD_ACCOUNT_LINK' => 'Vecais konts.',
    'LBL_ACCOUNTS' => 'Uzņēmumi',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Darbības',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Apskatīt kopsavilkumu',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Apskatīt kopsavilkumu [Alt+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Pievienot',
    'LBL_ADD_BUTTON' => 'Pievienot',
    'LBL_ADD_DASHLET_BUTTON' => 'Pievienot informācijas lauku',
    'LBL_ADD_DOCUMENT' => 'Pievienot dokumentu',
    'LBL_REPLACE_BUTTON' => 'Aizstāt',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Pievienot mērķu sarakstam',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Pievienot mērķu sarakstam',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Klikšķiniet, lai aizvērtu',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Aizvērt',
    'LBL_ADDITIONAL_DETAILS' => 'Papildus detaļas',
    'LBL_ADMIN' => 'Administrators',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'Arhīvs',
    'LBL_ASSIGNED_TO_USER' => 'Piešķirts lietotājam',
    'LBL_ASSIGNED_TO' => 'Piešķirts lietotājam',
    'LBL_BACK' => 'Atpakaļ',
    'LBL_BASE_RATE' => 'Bāzes valūtas kurss',
    'LBL_BILL_TO_ACCOUNT' => 'Rēķins uzņēumam',
    'LBL_BILL_TO_CONTACT' => 'Rēķins kontaktpersonai',
    'LBL_BILLING_ADDRESS' => 'Norēķinu adrese',
    'LBL_QUICK_CREATE_TITLE' => 'Ātrā izveide',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'Kļūdas',
    'LBL_BY' => 'kas',
    'LBL_CALLS' => 'Zvani',
    'LBL_CALL' => 'Zvans',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Izsūtīt rindā esošos kampaņu e-pastus',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Apstiprināt',
    'LBL_CASE' => 'Iespēja',
    'LBL_CASES' => 'Pieteikumi',
    'LBL_MESSAGE' => 'Ziņojums',
    'LBL_MESSAGES' => 'Ziņojumi',
    'LBL_ESCALATIONS' => 'Eskalācijas',
    'LBL_ESCALATION' => 'Eskalācija',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign aploksnes',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign aploksne',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'Atlasīt parakstītāja saņēmējus',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'Mainīt paroli',
    'LBL_CHANGE_BUTTON_LABEL' => 'Mainīt',
    'LBL_CHANGE_BUTTON_TITLE' => 'Mainīt',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Atzīmēt visu',
    'LBL_CITY' => 'Pilsēta',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Notīrīt',
    'LBL_CLEAR_BUTTON_TITLE' => 'Notīrīt',
    'LBL_CLEARALL' => 'Notīrīt visu',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => 'Aizvērt',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'Aizvērt logu',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Aizvērt visu',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Aizvērt visu',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Aizvērt un veidot jaunu',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Aizvērt un veidot jaunu',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'Kopēt ieraksta URL',
    'LBL_OPEN_ITEMS' => 'Atvērtie ieraksti:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Rakstīt e-pastu',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'E-pasts',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Rakstīt e-pastu',
    'LBL_SEARCH_DROPDOWN_YES' => 'Jā',
    'LBL_SEARCH_DROPDOWN_NO' => 'Nē',
    'LBL_CONTACT_LIST' => 'Kontaktpersonu saraksts',
    'LBL_CONTACT' => 'Kontaktpersona',
    'LBL_CONTACTS' => 'Kontaktpersonas',
    'LBL_CONTRACTS' => 'Līgumi',
    'LBL_COUNTRY' => 'Valsts:',
    'LBL_RESET_BUTTON_LABEL' => 'Atiestatīt',
    'LBL_CREATE_BUTTON_LABEL' => 'Jauns',
    'LBL_CREATED_BY_USER' => 'Izveidoja',
    'LBL_CREATED_USER' => 'Izveidoja',
    'LBL_CREATED_ID' => 'Izveidoja',
    'LBL_CREATED' => 'Izveidoja',
    'LBL_CREATE_NEW_TARGET_LIST' => 'Izveidot jaunu Mērķu sarakstu',
    'LBL_CURRENT_USER_FILTER' => 'Mani ieraksti:',
    'LBL_CURRENCY' => 'Valūta:',
    'LBL_CURRENCIES' => 'Valūtas',
    'LBL_CURRENCY_NAME' => 'Valūtas nosaukums',
    'LBL_CURRENCY_SYMBOL' => 'Valūtas simbols',
    'LBL_CURRENCY_RATE' => 'Bāzes valūtas kurss:',
    'LBL_CURRENCY_ID' => 'Valūtas ID',
    'LBL_DOCUMENTS' => 'Dokumenti',
    'LBL_DATE_ENTERED' => 'Izveides datums:',
    'LBL_DATE_MODIFIED' => 'Modificēšanas datums:',
    'LBL_ACTIVITY_MODIFIED' => 'Modificēts',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'Redigēt apskata cilni',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'Rediģēt moduļa cilnes',
    'LBL_EDIT_BUTTON' => 'Rediģēt',
    'LBL_DUPLICATE_BUTTON' => 'Dublicēt',
    'LBL_DELETE_BUTTON' => 'Dzēst',
    'LBL_DELETE' => 'Dzēst',
    'LBL_DELETED' => 'Dzēsts',
    'LBL_DIRECT_REPORTS' => 'Tiešās atskaites',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Pabeigt',
    'LBL_DONE_BUTTON_TITLE' => 'Pabeigts',
    'LBL_DST_NEEDS_FIXIN' => 'Lietojumprogramma pieprasa vasaras laika salabošanu. Dodies uz <a href="index.php?module=Administration&action=DstFix">Salabot</a> saiti Administrēšanas konsolē un veic Vasaras laika salabošanu',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Rediģēt kā jaunu',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Rediģēt kā jaunu',
    'LBL_EDIT_IN_NEW_TAB' => 'Rediģē jaunā cilnē',
    'LBL_FAVORITES' => 'Favorīti',
    'LBL_FILTER' => 'Filtrs',
    'LBL_DEFAULT_DATA_FILTER' => 'Noklusējuma datu filtrs',
    'LBL_FILTER_MENU_BY' => 'Filtrēt izvēlni pēc',
    'LBL_FILTER_SELECT_FIELD' => 'Atlasīt lauku...',
    'LBL_FILTER_SELECT_OPERATOR' => 'Atlasiet operatoru...',
    'LBL_FILTER_CREATE_NEW' => 'Izveidot jaunu',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'Izveidot filtru (nav saglabāts)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(Nav saglabāts)',
    'LBL_FILTER_CREATE_FILTER' => 'Izveidot jaunu filtru',
    'LBL_FILTER_CLOSE_FILTER' => 'Aizvērt filtru',
    'LBL_FILTER_EDIT_FILTER' => 'Rediģēt filtru',
    'LBL_FILTER_ALL_RECORDS' => 'Visi ieraksti',
    'TPL_FILTER_SAVE' => 'Jūs veiksmīgi izveidojāt filtru {{name}}.',
    'LBL_FILTER_BETWEEN_FROM' => 'No',
    'LBL_FILTER_BETWEEN_TO' => 'Kam',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'Sākuma datums',
    'LBL_FILTER_DATEBETWEEN_TO' => 'Beigu datums',
    'LBL_FOLLOWING' => 'Seko',
    'LBL_UNFOLLOW' => 'Atteikties',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'Lejupielādēt .vcf',
    'LBL_EMPTY_VCARD' => 'Izvēlieties vCard failu',
    'LBL_IMAGE' => 'Attēls',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard nesatur visus laukus ka ir nepieciešami modulim.',
    'LBL_VCARD_ERROR_FILESIZE' => 'Augšupielādes fails pārsniedz 30000 baitu izmēra limitu kas tika norādīts HTML formā.',
    'LBL_VCARD_ERROR_DEFAULT' => 'Notika kļūda ielādējot vCard failu.',
    'TPL_IMPORT_VCARD_FAILURE' => 'Kļūda veidojot {{module}} no vCard',
    'LBL_IMPORT_VCARD' => 'Importēt vCard:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'Importēt vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'Importēt vCard',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'Apskatīt',
    'LBL_VIEW_BUTTON_TITLE' => 'Apskatīt',
    'LBL_VIEW_BUTTON' => 'Apskatīt',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'E-pasts PDF formātā',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'E-pasts PDF formātā',
    'LBL_EMAIL' => 'E-pasts',
    'LBL_EMAILS' => 'E-pasti',
    'LBL_EMPLOYEES' => 'Darbinieki',
    'LBL_ENTER_DATE' => 'Izveidots',
    'LBL_EXPORT_ALL' => 'Eksportēt visu',
    'LBL_EXPORT' => 'Eksportēt',
    'LBL_FAVORITES_FILTER' => 'Mani favorīti:',
    'LBL_GLOBAL_SEARCH' => 'Globālā meklēšana',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'Globālās meklēšanas muduļu filtrs',
    'LBL_GLOBAL_SEARCH_RUN' => 'Sākt globālo meklēšanu',
    'LBL_GO_BUTTON_LABEL' => 'Iet uz',
    'LBL_GS_HELP' => 'Lauki šajā modulī, kuri izmantoti šajā meklēšanā parādās augšā, Atzīmētais teksts atbilst jūsu meklēšanas kritērijiem.',
    'LBL_HIDE' => 'Paslēpt',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => 'Importēt',
    'LBL_IMPORT_STARTED' => 'Importēšana uzsākta:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Jānorāda pielāgots lauku atdalītājs.',
    'LBL_LAST_VIEWED' => 'Pēdējā apskate',
    'LBL_SELECTED_RECORDS' => 'Atlasīti: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'Rādīt mazāk',
    'LBL_SHOW_MORE' => 'Rādīt vairāk',
    'LBL_SHOW_MORE_MODULE' => 'Vairāk {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'Vairāk neseno...',
    'LBL_SHOW_LESS_RECENTS' => 'Mazāk neseno',
    'LBL_SHOW_MORE_RESULTS' => 'Vairāk meklēšanas rezultātu...',
    'TPL_SHOW_MORE_MODULE' => 'Vēl {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => 'Vairāk {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => 'Šodienas darbības',
    'LBL_LEADS' => 'Interesenti',
    'LBL_LEAD' => 'Interesents',
    'LBL_QUOTES_BILL_TO' => 'Piedāvājumi (norēķinu adrese)',
    'LBL_LESS' => 'mazāk',
    'LBL_CAMPAIGN' => 'Kampaņa:',
    'LBL_CAMPAIGNS' => 'Kampaņas',
    'LBL_CAMPAIGNLOG' => 'Kampaņas Žurnāls',
    'LBL_CAMPAIGN_CONTACT' => 'Kampaņas',
    'LBL_CAMPAIGN_ID' => 'campaign_id',
    'LBL_THEME' => 'Motīvs:',
    'LBL_THEME_PICKER' => 'Lapas stils',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Brīdinājums: Internet Explorer 6 neatbalsta izvēlēto motīvu. Nospiest Labi, lai to izvēlētos, vai Atcelt, lai izvēlētos citu tēmu.',
    'LBL_FOUND_IN_RELEASE' => 'Atrasta laidienā:',
    'LBL_FIXED_IN_RELEASE' => 'Izlabota laidienā:',
    'LBL_LIST_ACCOUNT_NAME' => 'Uzņēmuma nosaukums',
    'LBL_LIST_ASSIGNED_USER' => 'Piešķirts lietotājam',
    'LBL_LIST_CONTACT_NAME' => 'Kontaktpersonas vārds',
    'LBL_LIST_CONTACT_ROLE' => 'Kontaktpersonas loma',
    'LBL_LIST_DATE_ENTERED' => 'Izveides datums',
    'LBL_LIST_EMAIL' => 'E-pasts',
    'LBL_LIST_NAME' => 'Nosaukums',
    'LBL_LIST_OF' => 'no',
    'LBL_LIST_PHONE' => 'Tālrunis',
    'LBL_LIST_RELATED_TO' => 'Atteicas uz',
    'LBL_LIST_USER_NAME' => 'Lietotāja vārds',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'Vai jūs esat pārliecināts, ka vēlaties atjaunināt visu sarakstu?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Lūdzu, izvēlieties vismaz vienu ierakstu, ko apstrādāt.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Lūdzu, izvēlieties vismaz divus ierakstus, ko apstrādāt.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Lūdzu izvēlieties mazāk par 10 ierakstiem, ko apstrādāt.',
    'LBL_LISTVIEW_ALL' => 'Visi',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'Iesaldēt 1. kolonnu',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'Visi diplikāti',
    'LBL_LISTVIEW_NONE' => 'Neatzīmēt visu',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Atzīmēt šo lapu',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Atzīmēt visu',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Atzīmētie ieraksti',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Atlasīti: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'Notīrīt visu atzīmēto.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'Atzīmēt visus ierakstus',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'Te ir vairāk kā {{num}} ierakstu. Jūs atzīmējāt pirmos {{num}} ierakstus.',
    'TPL_LISTVIEW_SELECTED' => 'Jūs atzīmējāt {{num}} ierakstus.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'Jūs atzīmējāt 1 ierakstu rezultātu kopā.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'Jūs atzīmējāt visus {{num}} ierakstus.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'Jūs atzīmējāt visus {{num}} ierakstus šajā skatā. {{link}} ierakstos.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'Atjaunina {{num}} no {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(palika aptuveni {{time}} {{unit}})',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'Masveida atjaunināšana neveiksmīga. Veiciet jaunu mēģinājumu ({{num}} no {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'Masveida atjaunināšana nepabeigta. {{num}} ieraksti palika neizmainīti.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'Masveida atjaunināšana nepabeigta. {{num}} ieraksti palika neizmainīti.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} ieraksts(-i) tika ignorēts(-i) tiesību vai kļūdu dēļ.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} ieraksti tika atjaunināti veiksmīgi.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} Masveida atkjaunināšana',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'Dzēš {{num}} no {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(palika aptuveni {{time}} {{unit}})',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'Masveida dzēšana neveiksmīga. Veiciet jaunu mēģinājumu ({{num}} no {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'Masveida dzēšana nepabeigta. {{num}} ieraksti nav izdzēsti.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'Masveida dzēšana nepabeigta. {{num}} ieraksti nav izdzēsti.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} ieraksti tika veiksmīgi izdzēsti.',
    'TPL_MASSDELETE_TITLE' => '{{module}} Masveida dzēšana',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'Pievieno {{num}} no {{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(palika aptuveni {{time}} {{unit}})',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'Pievienošana mērķu sarakstam neizdevās. Sāk mēģinājumu ({{num}} no {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'Nepilnīga pievienošana mērķu sarakstam. {{num}} ieraksti nav pievienoti.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'Nepilnīga pievienošana mērķu sarakstam. {{num}} ieraksti nav pievienoti.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} ieraksti veiksmīgi pievienoti.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} pievienošana mērķu sarakstam',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'Sasaista {{num}} no {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(palika aptuveni {{time}} {{unit}})',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'Masu sasaistē kļūda. Iniciējiet jaunu mēģinājumu ({{num}} no {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'Masu sasaiste nav pilnīga. {{num}} ieraksti nav pievienoti.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'Masu sasaiste nav pilnīga. {{num}} ieraksti nav pievienoti.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} ieraksti veiksmīgi sasaistīti.',
    'TPL_MASSLINK_TITLE' => '{{module}} masu piesaiste',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'Izvēlēties',
    'LBL_LISTVIEW_ACTIONS' => 'Darbības',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'Atlasīt visus ierakstus šajā lapā',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'Dzēst visus ierakstus šajā lapā',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} no {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => 'Ielādes {{num}}...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'Noklikšķiniet, lai atvērtu visu',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'no',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'Saņemt lapu skaitu',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'Jānis',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Bērziņš',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Dr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Kods Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => 'Lūdzu ieejiet sistēmā, lai piekļūtu šim apgabalam.',
    'LBL_LOGOUT' => 'Iziet',
    'LBL_FINISH_IMPERSONATING' => 'Pabeigt impersonalizāciju',
    'LBL_RESET_MFA' => 'Atiestatīt vairāku faktoru autentifikāciju',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, jūs šobrīd impersonalizējat {{user}}.',
    'LBL_PROFILE' => 'Profils',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'Pasta sapludināšana',
    'LBL_MASS_UPDATE' => 'Masveida izmaiņas',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'Atlasīt visus ierakstus masveida atjaunināšanai',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'Iekļaut ierakstu masveida atjaunināšanā',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'Pievienot lauku',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'Noņemt lauku',
    'LBL_GENERATE_QUOTE' => 'Ģenerēt Piedāvājumu',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'Masveida izmaiņu operācijai nav pieejamu lauku.',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'Jūsu pieprasījums masveida atjaunināšanai ir ieplānots.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'Pakalpojuma sākuma datums pārsniedz pakalpojuma beigu datumu',
    'LBL_MASS_UPDATE_SUCCESS' => 'Visi ieraksti atjaunināti veiksmīgi.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'Atzīmētie ieraksti tiks pievienoti mērķu sarakstam <a href="{{listUrl}}">{{listName}}</a>.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'Jūsu pieprasījums pievienot atzīmētos ierakstus mērķu sarakstam <a href="{{listUrl}}">{{listName}}</a> ir ieplānots.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'Sekojošiem atribūtiem ir tukšas vērtības::',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'Esošās vērtības tiks aizvietotas ar tukšām vērtībām. Vai vēlaties turpināt?',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'Izvēlēties primāro e-pastu',
    'LBL_MEETINGS' => 'Tikšanās',
    'LBL_MEETING' => 'Tikšanās',
    'LBL_MEETING_GO_BACK' => 'Atgriezties tikšanās ierakstā',
    'LBL_MEMBERS' => 'Dalībnieki',
    'LBL_MEMBER_OF' => 'Dalībnieks:',
    'LBL_MODIFIED_BY_USER' => 'Modificēja',
    'LBL_MODIFIED_USER' => 'Modificēja',
    'LBL_MODIFIED' => 'Modificēja',
    'LBL_MODIFIED_NAME' => 'Modificēja',
    'LBL_MODIFIED_ID' => 'Modificēja',
    'LBL_MORE' => 'vairāk',
    'LBL_MORE_MODULES' => 'Vairāk moduļu',
    'LBL_MORE_TABS' => 'Vairāk ciļņu',
    'LBL_MULTIPLE_MODULES' => 'Vairāki moduļi',
    'LBL_COUNT_MODULES' => '{{count}} moduļi',
    'LBL_MY_ACCOUNT' => 'Mani uzstādījumi',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'sistēmas noklusējums',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'lietotāja noklusējums',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'lietotāja konts',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'grupas konts',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'Vārds',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Izveidot',
    'LBL_NEW_BUTTON_TITLE' => 'Izveidot',
    'LBL_NEXT_BUTTON_LABEL' => 'Nākamais',
    'LBL_NOTES' => 'Piezīmes',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Atvērt visu',
    'LBL_OPENALL_BUTTON_TITLE' => 'Atvērt visu',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Atvērt No:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Atvērt No:',
    'LBL_OPEN_IN_NEW_TAB' => 'Atvērt jaunā cilnē',
    'LBL_OPPORTUNITIES' => 'Iespējas',
    'LBL_OPPORTUNITY_NAME' => 'Iespējas nosaukums',
    'LBL_OPPORTUNITY' => 'Iespēja',
    'LBL_OR' => 'VAI',
    'LBL_LOWER_OR' => 'vai',
    'LBL_PANEL_ASSIGNMENT' => 'Cits:',
    'LBL_PANEL_ADVANCED' => 'Vairāk informācijas',
    'LBL_PANEL_BODY' => 'Pārskats',
    'LBL_PARENT_TYPE' => 'Priekšteča tips',
    'LBL_RELATED_TYPE' => 'Saistītais tips',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'Diapazons:',
    'LBL_PICTURE_FILE' => 'Attēls',
    'LBL_POSTAL_CODE' => 'Pasta indekss:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'Pamatadrese - pilsēta:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'Pamatadrese - valsts:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'Pamatadrese - pasta indekss:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Pamatadrese - novads:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Pamatadrese - Iela 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Pamatadrese - Iela 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Pamatadrese - iela:',
    'LBL_PRIMARY_ADDRESS' => 'Pamatadrese:',

    'LBL_BILLING_STREET' => 'Iela:',
    'LBL_SHIPPING_STREET' => 'Iela:',

    'LBL_PRODUCT_BUNDLES' => 'Produktu pakas',
    'LBL_PRODUCTS' => 'Produkti',
    'LBL_PROJECT_TASKS' => 'Projekta uzdevumi',
    'LBL_PRODUCT_TEMPLATES' => 'Produktu sagataves',
    'LBL_PROJECTS' => 'Projekti',
    'LBL_PROSPECTS' => 'Mērķi',
    'LBL_QUICK_CREATE_MENU' => 'Ātrās izveides izvēlne',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Izveidot iespēju no piedāvājuma',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Izveidot iespēju no piedāvājuma',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'Izveido darījumu...',
    'LBL_QUOTES_SHIP_TO' => 'Piedāvājumus iesniegt:',
    'LBL_QUOTES' => 'Piedāvājumi',

    'LBL_FORECAST_WORKSHEETS' => 'Prognožu darblapas',
    'LBL_FORECAST_WORKSHEET' => 'Prognozes darblapa',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'Ielūgt',
    'LBL_INVITED' => 'Ielūgts',
    'LBL_RECOMMENDED_INVITES' => 'Ieteicams uzaicināt',
    'LBL_INSTANCES' => 'Instances',
    'LBL_YOUR_INSTANCES' => 'Jūsu Instances',
    'LBL_INSTANCE_USERS' => 'Instances Lietotāji',
    'LBL_SWITCH_INSTANCE' => 'Pārslēgties uz šo instanci',
    'LBL_LAST_LOGIN' => 'pēdējā pieteikšanās',
    'LBL_ENTER_EMAIL' => 'Ievadiet uzaicinātā epastu ...',
    'LBL_INSTANCE_IN_USE' => 'Lietošanā esošās instances',
    'LBL_INSTANCE_ACTIVE' => 'Jūs pašreiz lietojat šo instanci!',
    'LBL_INSTANCE_INVITE_SENT' => 'Ielūgums nosūtīts uz',
    'LBL_INSTANCE_SWITCH_FAILED' => 'Kļūda pārslēdzot instances',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'Atgādinājumi',
    'LBL_REMINDERS_OVERDUE' => 'Nokavēts',
    'LBL_REMINDERS_UPCOMING' => 'Gaidāms',
    'LBL_REMINDERS_NONE_FOUND' => 'Atgādinājumi netika atrasti.',
    'LBL_REMINDERS_FINISHED' => 'Pabeigts!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'Iespējas Metrikas',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'Sweet Spot konfigurācijas panelis',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'Aktivizējošās pogas',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'Neizdevās atjaunināt konfigurācijas preferences: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'Sweet Spot darbība',
    'LBL_SWEETSPOT_KEY' => 'Atslēgvārds',
    'LBL_SWEETSPOT_REMOVE' => 'Noņemt darbību',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'Aktivizējošās pogas',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'Darbības',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'Ieraksti',
    'LBL_SWEETSPOT_THEME' => 'Tēma',
    'LBL_SWEETSPOT_THEME_SELECT' => 'Izvēlēties tēmu',

    'LBL_RELATED' => 'Saistīts',
    'LBL_RELATED_INFORMATION' => 'Saistītā informācija',
    'LBL_RELATED_RECORDS' => 'Saistīts {{module}}',
    'LBL_REPORTS_TO' => 'Ziņo',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'Norāda obligāti aizpildāmu lauku',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Izdarīts',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Saglabāt kā',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Saglabāt kā',
    'LBL_FULL_FORM_BUTTON_KEY' => 'L',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Pilna ekrānforma',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Pilna ekrānforma',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Saglabāt un veidot jaunu',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Saglabāt un veidot jaunu',
    'LBL_SAVE_OBJECT' => 'Saglabāt {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Meklēt',
    'LBL_SEARCH_BUTTON_TITLE' => 'Meklēt',
    'LBL_SEARCH' => 'Meklēt',
    'LBL_SEARCH_TIPS' => 'Klikšķiniet meklēšana pogu vai spiediet ievades taustiņu, lai iegūtu tiešu atbilstību ar tiem.',
    'LBL_SEARCH_TIPS_2' => 'Klikšķiniet meklēšana pogu vai spiediet ievades taustiņu, lai iegūtu tiešu atbilstību ar',
    'LBL_SEARCH_MORE' => 'vairāk',
    'LBL_SEE_ALL' => 'Skatīt visu',
    'LBL_SEARCH_LOAD_MORE' => 'IELĀDĒT VAIRĀK',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Nederīgs faila formāts. Tikai attēla faili var tikt augšuplādēti.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'Attēla formāts {0} vairs netiek atbalstīts.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Izvēlēties',
    'LBL_SELECT_BUTTON_TITLE' => 'Izvēlēties',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'Pievienot darba grupu(as)',
    'LBL_SELECT_TEAMS_TITLE' => 'Pievienot darba grupu(as)',
    'LBL_SELECT_APPEND_TEAMS' => 'Pievienot Darba Grupu(as)',
    'LBL_SELECT_APPEND_VALUES' => 'Pievienot vērtības',
    'LBL_SELECT_APPEND_TAGS' => 'Pievienot birku(as)',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Pārlūkot dokumentus',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Pārlūkot dokumentus',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Izvēlēties kontaktpersonu',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Izvēlēties kontaktpersonu',
    'LBL_GRID_SELECTED_FILE' => 'izvēlētais fails',
    'LBL_GRID_SELECTED_FILES' => 'izvēlētie faili',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Izvēlēties no atskaitēm',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Izvēlēties atskaites',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Izvēlēties lietotāju',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Izvēlēties lietotāju',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Notīrīt laukus',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Notīrīt laukus',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Notīrīt atlasi',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Notīrīt atlasi',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Izvēlēties failu [Alt+F]',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Izvēlieties failu:',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Notīrīt failu',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Notīrīt failu',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Izvēlēties lietotāju',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Izvēlēties lietotāju',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Notīrīt lietotāju',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Notīrīt lietotāju',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Izvēlēties uzņēmumu [Alt+A]',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Izvēlēties uzņēmumu',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Notīrīt uzņēmumu',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Notīrīt uzņēmumu',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Izvēlēties kampaņu',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Izvēlēties kampaņu',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Notīrīt kampaņu',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Notīrīt kampaņu',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'Izvēlēties kontaktpersonu [Alt+C]',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'Atzīmēt kontaktpersonu',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Notīrīt kontaktpersonu',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Notīrīt kontaktpersonu',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Izvēlēties darba grupu',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Izvēlēties darba grupu',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Notīrīt darba grupu',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Notīrīt darba grupu',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Šīs lapas atainošanā izmantotie servera resursi (SQL pieprasījumi un faili)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'sekundes.',
    'LBL_SERVER_RESPONSE_TIME' => 'Servera reakcijas laiks:',
    'LBL_SERVER_MEMORY_BYTES' => 'baiti',
    'LBL_SERVER_MEMORY_USAGE' => 'Servera atmiņas lietojums: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Lietojums: - modulis: {0} - darbība: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Atmiņas izmantošana pie servera maksimālās noslodzes: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'Piegādāt klientam',
    'LBL_SHIP_TO_CONTACT' => 'Piegādāt kontaktpersonai',
    'LBL_SHIPPING_ADDRESS' => 'Piegādes adrese',
    'LBL_SHORTCUTS' => 'Saīsnes',
    'LBL_SHOW' => 'Parādīt',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'Novads:',
    'LBL_STATUS_UPDATED' => 'Jūsu statuss šim notikumam ir izmainīts!',
    'LBL_STATUS_NOT_UPDATED' => 'Jūsu statuss šim notikumam nav atjaunināts.',
    'LBL_STATUS' => 'Statuss',
    'LBL_STREET' => 'Iela',
    'LBL_SUBJECT' => 'Temats',

    'LBL_INBOUNDEMAIL_ID' => 'Ienākošā e-pasta ID',
    'LBL_EAMP_ID' => 'Autentifikācijas marķiera ID',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'Visas tiesības aizsargātas.<br />SugarCRM, Sugar un 3-D kubs ir SugarCRM Inc. reģistrētas preču zīmes. ' .
        'Visi citi uzņēmumu un produktu nosaukumi, kas tiek izmantoti vai parādās šajā produktā, var būt preču zīmes, ' .
        'kas pieder atbilstošiem uzņēmumiem, ar kuriem tie ir saistīti.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'Ieplānotais darbs izpildīts',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'Ieplānotais darbs ir veiksmīgi palaists',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'Ieņēmumu rindu modulis tagad ir iespējots jūsu Sugar instancē',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Ieņēmumu posteņu rindas tagad ir aktivētas jūsu Sugar instancē, un visi esošo Iespēju dati tiks apstrādāti. Jūsu instancē tagad var izmantot Ieņēmumu posteņu rindas. Vairāk informācijas par veiktajām izmaiņām skatiet {{doc_url}}.<br /><br />Ar cieņu, SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'Plānošanas mudulis tagad ir gatavs darbam ar pārdošanas iespējām jusu Sugar instancē',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'Plānošanas modulis jūsu instancē, tagad ir izmantojams kopā ar pārdošanas Iespējām. Visas iepriekš iesniegtās ieņēmumu posteņu rindu prognozes ir noņemtas un instance ir gatava prognožu veidošanai un iesniegšanai pamatojoties uz pārdošanas iespējām. Vairāk informācijas par veiktajām izmaiņām skatiet {{doc_url}}.<br /><br />Ar cieņu, SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Ieņēmumu rindu modulis tagad ir atspējots jūsu Sugar instancē',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Ieņēmumu posteņu rindas ir atspējotas jūsu Sugar instancē un visi esošie ieņēmumu posteņu rindu dati tiks apstrādāti. Jūsu instance ir gatava darbam ar pārdošanas Iespējām. Vairāk informācijas par veiktajām izmaiņām skatiet {{doc_url}}.<br /><br />Ar cieņu, SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'Iespēju konfigurēšanas dokumentācija',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'Pieteikšanās',
    'LBL_LOGIN_WELCOME_TO' => 'Sveicināti',
    'LBL_LOGIN_OPTIONS' => 'Izvēles',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'Aizmirsāt paroli?',
    'LBL_LOGIN_SUBMIT' => 'Apstiprināt',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'Pārāk daudz neveiksmīgu pieteikšanās mēģinājumu.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'Jūs variet mēģināt pieteikties atkal pēc',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'dienām.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 'st.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'min.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'sek.',
    'LBL_LOGIN_ADMIN_CALL' => 'Sazinieties ar sistēmas administratoru',
    'LBL_LOGIN_USERNAME' => 'Lietotājvārds',
    'LBL_LOGIN_PASSWORD' => 'Parole',
    'LBL_LOGGED_OUT' => 'Jūs esat izrakstījies.',
    'LBL_LOGIN_FORM_LABEL' => 'Parādīt pieteikšanās formu',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'Atgriezties pie pieteikšanās',
    'LBL_LOGIN_INACTIVE_USER' => 'Neaktīvs lietotājs',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'Portāla vai grupas lietotājs nevar pieteikties.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'Instrumentu panelis',
    'LBL_SYNC' => 'Sinhronizācija',
    'LBL_TASKS' => 'Uzdevumi',
    'LBL_TEAMS_LINK' => 'Darba grupas',
    'LBL_THEME_COLOR' => 'Krāsa',
    'LBL_THEME_FONT' => 'Fonts',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'Ieplānot tikšanos',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'Ieplānot tikšanos',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'Arhivēt e-pastu',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'Arhivēt e-pastu',
    'LBL_UNAUTH_ADMIN' => 'Neautorizēta piekļuve administratora funkcijām',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Atsaukt dzēšanu',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Atsaukt dzēšanu',
    'LBL_UNDELETE_BUTTON' => 'Atsaukt dzēšanu',
    'LBL_UNDELETE' => 'Reversēt dzēšanu',
    'LBL_UNSYNC' => 'Atcelt sinhronizēšanu',
    'LBL_UPDATE' => 'Atjaunināt',
    'LBL_UPDATES' => 'Atjauninājumi',
    'LBL_USER_LIST' => 'Lietotāju saraksts',
    'LBL_USER_MENU' => 'Lietotāja izvēlne',
    'LBL_USERS_SYNC' => 'Lietotāju sinhronizēšana',
    'LBL_USERS' => 'Lietotāji',
    'LBL_USER' => 'Lietotājs',
    'LBL_CURRENT_USER' => 'Pašreizējais lietotājs',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'Esošā e-pasta ieraksta pārbaudīšana...',
    'LBL_VERIFY_PORTAL_NAME' => 'Esošā portāla nosaukuma pārbaudīšana...',
    'LBL_VIEW_IMAGE' => 'Apskatīt',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'Izdrukāt PDF formātā',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'Izdrukāt PDF formātā',

    'LBL_KBDOCUMENTS' => 'Zināšanu bāze',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'Par produktu',
    'LNK_ADVANCED_SEARCH' => 'Paplašinātā meklēšana',
    'LNK_BASIC_SEARCH' => 'Pamatmeklēšana',
    'LNK_SEARCH_NO_RESULTS' => 'Rezultāti nav atrasti.',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'Aplūkot visus rezultātus',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Parādīt visu',
    'LNK_CLOSE' => 'aizvērt',
    'LBL_MODIFY_CURRENT_SEARCH' => 'Modificēt pašreizējo meklējumu',
    'LNK_SAVED_VIEWS' => 'Izkārtojuma iespējas',
    'LNK_DELETE_ALL' => 'dzēst visu',
    'LNK_DELETE' => 'dzēst',
    'LNK_EDIT' => 'rediģēt',
    'LNK_VIEW' => 'skatīt',
    'LNK_GET_LATEST' => 'Iegūt jaunāko',
    'LNK_GET_LATEST_TOOLTIP' => 'Aizvietot ar jaunāko versiju',
    'LNK_HELP' => 'Palīdzība',
    'LNK_CREATE' => 'Izveidot',
    'LNK_CREATE_WHEN_EMPTY' => 'Ieveidpt jaunu ierakstu',
    'LNK_LIST_END' => 'Beigas',
    'LNK_LIST_NEXT' => 'Nākamais',
    'LNK_LIST_PREVIOUS' => 'Iepriekšējais',
    'LNK_LIST_RETURN' => 'Atgriezties sarakstā',
    'LNK_LIST_START' => 'Sākt',
    'LNK_LOAD_SIGNED' => 'Parakstīt',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'Aizvietot ar parakstītu dokumentu',
    'LNK_PRINT' => 'Drukāt',
    'LNK_BACKTOTOP' => 'Atpakaļ uz augšu',
    'LNK_REMOVE' => 'noņemt',
    'LNK_RESUME' => 'Atsākt',
    'LNK_VIEW_CHANGE_LOG' => 'Skatīt audita žurnālu',
    'TPL_AUDIT_LOG_TITLE' => 'Audita žurnāls vienumam {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'Klikšķiniet, lai skatītu e-pasta adreses audita žurnālu',
    'LBL_NO_SEARCH_RESULTS' => 'Jūsu meklēšanai netika atrasts neviens rezultāts',
    'NTC_CLICK_BACK' => 'Klikšķiniet pārlūka pogu &amp;amp;#39;Back&amp;amp;#39; un izlabojiet kļūdu.',
    'NTC_DATE_FORMAT' => '(yyyy-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(gggg-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'Vai tiešām vēlaties dzēst izvēlēto(s) ierakstu(s)?',
    'NTC_TEMPLATE_IS_USED' => 'Veidni lieto vismaz viens e-pasta ieraksts. Vai tiešām vēlaties to dzēst?',
    'NTC_TEMPLATES_IS_USED' => "Sekojošas veidnes ir izmantotas e-pasta mārketinga ierakstos. Vai tiešām vēlies tās dzēst?",
    'NTC_DELETE_CONFIRMATION' => 'Vai tiešām vēlaties dzēst šo ierakstu?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'Vai tiešām vēlaties dzēst {0}?',
    'LBL_METRIC_DELETE_WARNING' => 'Visi lietotāji, ar kuriem šī metrikas cilne tika koplietota, arī zaudēs piekļuvi.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'Vai tiešām vēlaties dzēst',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'Vai tiešām vēlaties izmainīt',
    'NTC_DELETE_SELECTED_RECORDS' => 'izvēlēto(s) ierakstu(s)?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'Šis filtrs tiks izņemts no visiem skatiem; tas var saturēt informatīvo ziņojumu konfigurācijas datus. Vai tiešām vēlaties izdzēst šo filtru?',
    'TPL_DELETE_FILTER_SUCCESS' => 'Jūs izdzēsāt filtru {{name}}.',
    'NTC_DELETE_SUCCESS' => 'Jūs izdzēsāt {0}.',
    'NTC_UNLINK_CONFIRMATION' => 'Vai tiešām vēlaties atvienot šo ierakstu?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'Vai tiešām vēlies noņemt {0}?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'Vai tiešām vēlaties atvienot {0}? Tas tos noņems arī no pieteikuma lauka Primārā kontaktpersona.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => '{0} nevar atvienot, jo tie ir primārās kontaktpersonas šajā pieteikumā. Pirms šī ieraksta atvienošanas atjauniniet lauku Primārā kontaktpersona.',
    'NTC_UNLINK_SUCCESS' => 'Jūs atvienojāt',
    'NTC_LOGIN_MESSAGE' => 'Lūdzu ievadiet lietotāja vārdu un paroli.',
    'NTC_NO_ITEMS_DISPLAY' => 'neviens',
    'NTC_REMOVE_CONFIRMATION' => 'Vai tiešām vēlaties noņemt šo relāciju? Tiks noņemta tikai relācija. Ieraksts netiks izdzēsts.',
    'NTC_REQUIRED' => 'Norāda obligāti aizpildāmu lauku',
    'NTC_SUPPORT_SUGARCRM' => 'Varat atbalstīt SugarCRM atvērtā koda projektu ar ziedojumu, izmantojot PayPal maksājumu sistēmu - tas ir ātri, bezmaksas un droši!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'Sveiki',
    'NTC_YEAR_FORMAT' => '(gggg)',
    'LOGIN_LOGO_ERROR' => 'Lūdzu, aizvietojiet SugarCRM logo attēlus.',
    'FATAL_LICENSE_ALTERED' => 'Jūsu licence ir mainīta kopš pēdējās validācijas.',
    'ERROR_FULLY_EXPIRED' => "Jūsu uzņēmuma SugarCRM licence ir beigusies jau vairāk kā 7 dienas un tā jāatjaunina. Tikai administrators varēs pieslēgties sistēmai.",
    'ERROR_LICENSE_EXPIRED' => "Jūsu uzņēmuma SugarCRM licence ir jāatjaunina. Tikai administrators varēs pieslēgties sistēmai.",
    'WARN_LICENSE_EXPIRED' => "Jūsu uzņēmuma licencei drīz beigsies derīguma termiņš.",
    'ERROR_LICENSE_VALIDATION' => "Jūsu uzņēmuma SugarCRM licence ir jāvalidē. Tikai administrators varēs pieslēgties sistēmai.",
    'WARN_LICENSE_VALIDATION' => "Jūsu uzņēmuma SugarCRM licencei drīz būs nepieciešama validēšana.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>Uzmanību:</b> Jūsu pārlūks darbojas IE compatibility skatā, kas netiek atbalstīts.',
    'WARN_LICENSE_SEATS' => 'Brīdinājums: Atļautais lietotāju skaits jau ir sasniedzis maksimumu. Visas licenzes ir izmantotas.',
    'WARN_LICENSE_SEATS_MAXED' => 'Brīdinājums: Aktīvo lietotāju skaits pārsniedz pieļaujamo licenžu skaitu.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'Aktīvo lietotāju skaits pārsniedz licenču skaita limitus. Lūdzu, sazinieties ar administratoru.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'Ierakstīties var tikai administratori.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'Ir sasniegts lietotāju licenču skaita limits. Ierakstīties var tikai esošie lietotāji.',
    'WARN_ONLY_ADMINS' => 'Ierakstīties var tikai administratori.',
    'WARN_UNSAVED_CHANGES' => 'Ieraksta atstāšana bez izmaiņu saglabāšanas. Vai tiešām vēlaties atstāt ierakstu?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Pārlūkprogrammas atsvaidzināšana automātiski aizvērs visas atvērtās SugarLive zvana vai tērzēšanas sesijas, un visas nesaglabātās izmaiņas tiks zaudētas. Vai vēlaties turpināt?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'Jums ir nesaglabātas izmaiņas. Vai tiešām vēlaties pamest lapu nesaglabājot izmaiņas?',
    'LBL_MFA_RESET_CONFIRMATION' => 'Vai tiešām vēlaties atiestatīt <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">vairāku faktoru autentifikāciju</a>? 
Veicot šo darbību, jūs nekavējoties iziesiet, un nākamajā reizē jums būs jāveic autentifikācija, izmantojot autentifikācijas lietotni.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'Apstiprināt un iziet',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'Vienam vai vairākiem dašletiem ir nesaglabātas izmaiņas. Vai tiešām vēlaties aizvērt dokumentu sastādītāju?',
    'LBL_NAVIGATE_TO_REPORTS' => 'Jūs pārslēdzaties uz atskaišu moduli. Jūsu veiktās izmaiņas netiks saglabātas. Vai turpināt?',
    'ERROR_NO_RECORD' => 'Kļūda atgriežot ierakstu. Šis ieraksts ir vai nu jau dzēsts vai arī jums nav piekļuves tiesību.',
    'ERROR_TYPE_NOT_VALID' => 'Kļūda. Šis tips nav derīgs.',
    'ERROR_MAX_FIELD_LENGTH' => 'Kļūda. Šī lauka maksimālais garums ir {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'Kļūda. Šī lauka minimālais garums ir {{this}}.',
    'ERROR_EMAIL' => 'Kļūda. Nederīga e-pasta adrese: {{#each this}}{{this}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'Kļūda. Jānorāda vismaz viena primārā adrese.',
    'ERROR_DUPLICATE_EMAIL' => 'Kļūda. E-pasta adreses dublikāts: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'Kļūda. Šis lauks ir obligāts.',
    'ERROR_MINVALUE' => 'Kļūda. Šī lauka minimālā vērtība ir {{this}}.',
    'ERROR_MAXVALUE' => 'Kļūda. Šī lauka maksimālā vērtība ir  {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'Kļūda. Šī lauka vērtībai jābūt lielākai par {{this}}.',
    'ERROR_IS_LESS_THAN' => 'Kļūda. Šī lauka vērtībai jābūt mazākai par {{this}}.',
    'ERROR_DATETIME' => 'Kļūda. Šajā laukā jānorāda derīgs datums.',
    'ERROR_IS_BEFORE' => 'Error. The date of this field can not be after date of {{this}} field.',
    'ERROR_IS_AFTER' => 'Error. The date of this field can not be before date of {{this}} field.',
    'ERROR_TIME_IS_BEFORE' => 'Kļūda. Šā lauka laikam ir jābūt pirms {{this}} lauka laika.',
    'ERROR_TIME_IS_AFTER' => 'Kļūda. Šā lauka laikam ir jābūt pēc {{this}} lauka laika.',
    'ERROR_NUMBER' => 'Kļūda. Šim laukam ir nepieciešams pareizs numurs.',
    'ERROR_INT' => 'Kļūda. Nederīgs vesels skaitlis.',
    'ERROR_URL' => 'Kļūda. Nederīgs URL.',
    'ERROR_NO_BEAN' => 'Neizdevās iegūt bean',
    'ERROR_ACCESS_MODULE' => 'Jums nav pieejas tiesību šim modulim.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'Kļūda. Pielikums ir pārāk liels.',
    'ERROR_UPLOAD_FAILED' => 'Kļūda. Neizdevās ielādēt failu.',
    'ERROR_UPLOAD_ACCESS_PD' => 'Jums nav atļaujas izveidot [procesa definīcijas] šim modulim.',
    'ERROR_UPLOAD_ACCESS_BR' => 'Jums nav atļaujas izveidot [biznesa noteikumi] šim modulim.',
    'ERROR_UPLOAD_ACCESS_ET' => 'Jums nav atļaujas izveidot [e-pasta šablonus] šim modulim.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'Kļūda. Esat ievadījis neatbalstītu operatoru.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'Kļūda. Esat ievadījis nederīgu operatoru.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'Kļūda. Esat ievadījis nederīgu filtru.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'Importēšana neizdevās. Grupas lauks ir daļēji bloķēts procesa definīcijā.' .
        ' Šie lauki ir jāatbloķē procesa definīcijā, lai varētu importēt definīciju.',
    'ERROR_EXP_DATE_LOW' => 'Kļūda. Beigu datums nevar būt pirms publicēšanas datuma.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'Kļūda. Apstiprinātajam statusam nepieciešams publicēšanas datums.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'Publicēšanas datums ir tukšs.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'Atrast dublikātus',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => '{{module}} ir atspējota dublikātu pārbaude.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'Pārvaldīt abonementus',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Pārvaldīt abonementus priekš',
    'LBL_SUBSCRIBE' => 'Pierakstīties',
    'LBL_UNSUBSCRIBE' => 'Atsaukt abonēšanu',
    'LBL_CREATE_LINK_RECORD' => 'Izveidot un Piesaistīt ierakstu.',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'Izveidot un Piesaistīt ierakstu.',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} ieraksti ir piesaistīti.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'Nav ieraksti ko piesaistīt.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'Izvēlētā atskaites nav veidota uz atbilstoša veida moduļa.',
    'ERROR_EMPTY_LINK_MODULE' => 'Vispirms atlasiet saiti.',
    // Ajax status strings
    'LBL_LOADING' => 'Notiek ielāde ...',
    'LBL_LOADING_NO_DOTS' => 'Ielāde',
    'LBL_SEARCHING' => 'Meklē ...',
    'LBL_SEARCH_UNDERWAY' => 'Meklē',
    'LBL_SAVING_LAYOUT' => 'Saglabā izkārtojumu ...',
    'LBL_SAVED_LAYOUT' => 'Izkārtojums saglabāts.',
    'LBL_SAVED' => 'Saglabāts',
    'LBL_SAVING' => 'Saglabā',
    'LBL_FAILED' => 'Kļūda!',
    'LBL_DISPLAY_COLUMNS' => 'Rādīt kolonnas',
    'LBL_HIDE_COLUMNS' => 'Paslēpt kolonnas',
    'LBL_SEARCH_CRITERIA' => 'Meklēšanas kritēriji',
    'LBL_SAVED_VIEWS' => 'Saglabātie skatījumi',
    'LBL_PROCESSING_REQUEST' => 'Apstrādā...',
    'LBL_REQUEST_PROCESSED' => 'Izdarīts',
    'LBL_AJAX_FAILURE' => 'Ajax kļūda',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'Meklēt...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Saglabātie meklējumi',
    'LBL_SEARCH_POPULATE_ONLY' => 'Veiciet meklēšanu, izmantojot augstāk esošo meklēšanas formu',
    'LBL_SEARCH_NO_RESULTS' => 'Rezultāti netika atrasti',
    'LBL_SEARCH_FOR' => 'Meklēt',
    'LBL_SEARCH_FOR_MORE' => 'Meklēt vairāk...',
    'LBL_SEARCH_SELECT' => 'Atlasīt...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'Meklēt un atlasīt...',
    'LBL_SEARCH_SELECT_MODULE' => 'Atlasīt moduli {{module}}...',
    'LBL_DETAILVIEW' => 'Detalizēts skatījums',
    'LBL_LISTVIEW' => 'Saraksta skats',
    'LBL_EDITVIEW' => 'Rediģēt skatījumu',
    'LBL_SEARCHFORM' => 'Mekēšanas forma',
    'LBL_SAVED_SEARCH_ERROR' => 'Lūdzu ievadiet šī skatījuma nosaukumu.',
    'LBL_DISPLAY_LOG' => 'Rādīt žurnālu',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Novietojums:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Apraksts:',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'sāknē',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'Klikšķiniet OK, lai apskatītu šo zvanu, vai klikšķiniet Atcelt, lai atmestu šo ziņojumu.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'Klikšķiniet OK, lai apskatītu tikšanos vai klikšķiniet Atcelt, lai atmestu šo ziņojumu.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'Rezultāti nav atrasti.',
    'MSG_LIST_VIEW_NO_RESULTS' => 'Nav atrasti rezultāti priekš',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Izveidot kā jaunu',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'Jums pašreiz nav saglabātu ierakstu. <item2> vai <item3> tagad.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'Jums pašlaik nav saglabāts neviens ieraksts.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'Jūs variet izveidot <item1> no <item2>. <item3> <item2> saraksta.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'Pozitīvs',
    'LBL_SENTIMENT_NEUTRAL' => 'Neitrāls',
    'LBL_SENTIMENT_NEGATIVE' => 'Negatīvs',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'Nav konfigurētas metrikas cilnes',
    'LBL_NO_METRIC_VISIBLE' => 'Nav redzamas metrikas cilnes',
    'LBL_MAKE_METRIC_VISIBLE' => 'Izvēlieties "organizēt", lai metrikas cilnes būtu redzamas',
    'LBL_PLEASE_CONTACT_ADMIN' => 'Sazinieties ar savu administratoru',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'Klikšķināt šeit',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Pievienot maniem favorītiem',
    'LBL_MARK_AS_FAVORITES' => 'Atzīmēt kā favorītu',
    'LBL_CREATE_CONTACT' => 'Izveidot kontaktpersonu',
    'LBL_CREATE_NOTE' => 'Izveidot piezīmi',
    'LBL_CREATE_OPPORTUNITY' => 'Izveidot iespēju',
    'LBL_SCHEDULE_CALL' => 'Ieplānot zvanu',
    'LBL_SCHEDULE_CALL2' => 'Zvans',
    'LBL_SCHEDULE_MEETING' => 'Ieplānot tikšanos',
    'LBL_SCHEDULE_MEETING2' => 'Tikšanās',
    'LBL_CREATE_MESSAGE' => 'Izveidot ziņojumu',
    'LBL_CREATE_MESSAGE2' => 'Ziņojums',
    'LBL_CREATE_TASK' => 'Izveidot uzdevumu',
    'LBL_CREATE_TASK2' => 'Uzdevums',
    'LBL_REMOVE_FROM_FAVORITES' => 'Izņemt no Maniem favorītiem',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'Piezīme',
    'LBL_DOWNLOAD_ALL' => 'Lejupielādēt visu',
    'LBL_DOWNLOAD_ONE' => 'Lejupielādēt',
    'LBL_ATTACHMENTS' => 'Pielikumi',
    'LBL_ADD_ATTACHMENT' => 'Pārlūkot',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Ģenerēt formu',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Saglabāt "No tīmekļa uz interesentu" formu',

    'LBL_PLEASE_SELECT' => 'Lūdzu izvēlieties',
    'LBL_REDIRECT_URL' => 'Novirzīt URL',
    'LBL_RELATED_CAMPAIGN' => 'Saistītā kampaņa',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Pievienot visus laukus',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Izņemt visus laukus',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Var iebūvēt tikai attēla tipa pielikumu',
    'LBL_REMOVE' => 'Noņemt',
    'LBL_TRAINING' => 'Atbalsts',
    'ERR_DATABASE_CONN_DROPPED' => 'Kļūda izpildot vaicājumu. Iespējams, ka datubāze pārtrauca savienojumu. Lūdzu atjaunot lapu vai pārstartējiet tīmekļa serveri.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'Kļūda uzstādot {0} relāciju uz: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'Datubāzes konteksts ir izmainīts uz',
    'ERR_MSSQL_WARNING' => 'Brīdinājums:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'Neizdevās parsēt vCard formātu',
    'ERR_VCARD_FILE_MISSING' => 'iztrūkst vcf fails',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Brīdinājums: laukā [[field]] nav kartētais ieraksts [moduleDir] vardefs.php failā',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Kļūda: Fails [[file]] nav pieejams. Izveidot nav iespējams, jo netika atrasts atbilstošs HTML fails.',
    'ERR_CANNOT_FIND_MODULE' => 'Kļūda: Modulis [module] neeksistē.',
    'LBL_ALT_ADDRESS' => 'Cita adrese:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Kļūda: Neatbilstošs argumentu skaits &amp;amp;#39;atslēgai&amp;amp;#39;un &amp;amp;#39;kopēšanas&amp;amp;#39; elementiem attēlotajā parametru masīvā.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'displayParams masīvā nav atrasts indekss:',

    'LBL_DASHLET' => 'Dašlets',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filtri',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Tikai mani ieraksti',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Virsraksts',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Rādīt ierakstus',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'Piesaistīt dotajam ierakstam',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'Saistītais lauks',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'Iesaldēt pirmo kolonnu',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'Vai tiešām vēlaties noņemt dašletu?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'Vai tiešām vēlaties noņemt rindu?',
    'LBL_MAXIMUM_OF' => 'Maksimums no',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => 'kolonna var parādīt.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'Instrumentu panelis',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'Mans instrumentu panelis',
    'LBL_COLLAPSE_ALL' => 'Savērst visus',
    'LBL_EXPAND_ALL' => 'Izvērst visus',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'Rediģēt',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'Visas atskaiti',
    'LBL_DASHLET_REFRESH_LABEL' => 'Atjaunot',
    'LBL_DASHLET_REMOVE_LABEL' => 'Izņemt',
    'LBL_DASHLET_DROP_HERE' => 'Nomest šeit',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'Aizvērt',
    'LBL_DASHLET_MAXIMIZE' => 'Atvērt',
    'LBL_DASHLET_CONFIGURE' => 'Konfigurēt',
    'LBL_DASHLET_TOGGLE' => 'Pārslēgt instrumentu paneļa redzamību',
    'LBL_SIDEPANE_TOGGLE' => 'Atvērt/aizvērt sānu paneli',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'Atjaunot noklusējuma informācijas laukus',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'Neviens instrumentu panelis nav konfigurēts',
    'LBL_CREATE_DASHBOARD_LINK' => 'Izveidot informācijas paneli',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'Palīdzība',
    'LBL_HELPLET_TOGGLE' => 'Atvērt/aizvērt',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'Moduļi',
    'LBL_FACET_MODIFIED_BY_ME' => 'Pārveidoju es',
    'LBL_FACET_CREATED_BY_ME' => 'Izveidoju es',
    'LBL_FACET_MY_FAVORITES' => 'Mani favorīti',
    'LBL_FACET_ASSIGNED_TO_ME' => 'Piešķirts man',
    'LBL_FACET_NO_DATA' => 'Nav datu par šo aspektu.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'Mans saraksta skatījums',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'Jums piesaistīto ierakstu saraksts',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'Konsoles saraksta skatījums',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'Uzskaita konkrēta moduļa ierakstus, kas ir saistīti ar ierakstu, kur aplūkojat konsolē.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'Ieraksta skats',
    'LBL_RELATED_RECORDS' => 'Saistīts {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'Parāda ierakstu un pēc izvēles saistītos ierakstus cilnēs.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'Ieraksta pamattips',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'Šis {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'Cilnes',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'Galvenā izkārtojuma priekšskatījums',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'Brīdinājums, tikai {{numWord}} ({{num}}) moduļus var parādīt cilnēs. ' .
        'Pirms citu moduļu pievienošanas izdzēsiet vienu vai vairākus moduļus.',
    'LBL_SIX' => 'seši', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'Komentāru žurnāls',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'Parāda komentārus ierakstam',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'Komentāri nav pieejami',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'Pievienot',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'Pievienot komentāru',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'Skatīt visu',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'Dati nav pieejami. Jums nav atļaujas piekļūt šiem moduļiem.' .
    " \nLūdzu, atjauniniet vai noņemiet šo informācijas lauku.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'Mani {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'Parādīšanai nav atlasīts neviens ieraksts',
    'LBL_CONTENT_SEARCH_DASHLET' => 'Satura meklēšanas dašlets',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'Kā mēs Jums šodien varam palīdzēt, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'Vai vēlaties izveidot pieteikumu?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'Iespēju metrikas',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'Darījuma rādītāji saistītajam klientam.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'Ātrā izvēle no produktu kataloga',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'Nesen izmantoto vienumu un produktu saraksti, kas saglabāti izlasē',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'Nesen izmantots',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'Izlase',

    'LBL_DASHBOARD_CREATE' => 'Izveidot informācijas paneli',
    'LBL_DASHBOARD_DUPLICATE' => 'Dublēt informācijas paneli',
    'LBL_DASHBOARD_DELETE' => 'Dzēsr informācijas paneli',
    'LBL_PIN_TO_TOP' => 'Piespraust augšā',
    'LBL_PIN_TO_BOTTOM' => 'Piepraust apakšā',
    'LBL_MANAGE_DASHBOARDS' => 'Pārvaldīt instrumentu paneļus',

    'LBL_DASHBOARD_CONFIG' => 'Informācijas paneļa konfigurācija',
    'LBL_LIST_VIEW__NAME' => 'Saraksta skatījums',
    'LBL_PIPELINE_VIEW_NAME' => 'Mozaīkas skatījums',
    'LBL_PIPELINE_VIEW_BTN' => 'Mozaīkas skatījums',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} pēc {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'Mozaīkas skatījums nav iespējots',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'Tagad netika atrasts  neviens ieraksts.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'Pieteikumu kopsavilkums',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'Laika josla',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'Piezīmes un pielikumi',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'Piezīmes & Pielikumi pieder ierakstam',
    'LBL_DASHLET_PIPLINE_NAME' => 'Piltuve',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'Nesenie tvīti - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'Nav saglabātu instrumentu paneļu',

    'LBL_DNB_AND' => 'un',
    'LBL_DNB_PRIM_NAME_DESC' => 'Teksts, kas fiksē šīs organizācijas nosaukumu',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'Atbildēt',
    'LBL_TWITTER_RETWEET' => 'Atkārtots ieraksts',
    'LBL_TWITTER_FAVORITE' => 'Favorīts',
    'LBL_TWITTER_FOLLOW' => 'Sekot',
    'LBL_TWITTER_DESCRIPTION' => 'Skatīt atbilstošu twitter lietotāju bio un ierakstus, atkārtotus ierakstus un atbildēt uz ierakstiem',
    'LBL_TWITTER_ID' => 'Twitter ID',
    'LBL_TWITTER_DISPLAY_ROWS' => 'Rādīt rindas',
    'LBL_TWITTER_MY_ACCOUNT' => 'Mans konts',
    'LBL_TWITTER_NAME' => '„Twitter”',
    'LBL_TWITTER_SOURCE' => 'Avota ieraksts:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'Mācību resursi',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'Apmācība un sertifikācija',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub kopiena',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'Dokumentācija un atbalsts',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters tirgus',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'Pārdošana pēc valsts',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'Parāda pārdošanas diagrammu valstu kartē',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'Zināšanu bāzes kategorijas un publicētie raksti',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'Meklēšana zināšanu bāzē',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'Parāda zināšanu bāzes publicēto rakstu un kategoriju koka skatījumu, kurā var veikt meklēšanu.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'Publicētie raksti citās valodās',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'Noderīgākie publicētie zināšanu bāzes raksti',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'Attēlo populārākos un biežāk apskatītos zināšanu bāzes rakstus',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} filtrēts pēc {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'Lietderība rakstiem',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'Pievienot lapu',
    'LBL_LOADING_PAGE' => 'Notiek lapas ielāde. Lūdzu uzgaidiet...',
    'LBL_SEARCH_RESULTS' => 'Meklēšanas rezultāti',
    'LBL_SEARCH_RESULTS_FOR' => 'Meklēšanas rezultāti: ',
    'LBL_SEARCH_HELP_TITLE' => 'Meklēšanas padomi',
    'LBL_SEARCH_RESULTS_FOUND' => 'Atrasti meklēšanas rezultāti',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'Mana piltuve',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "Manas darba grupas piltuve",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'Pārdošanas piltuves diagramma',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'Parāda pašreizējās piltuves diagrammu.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'Nav attēla',

    'LBL_MODULE' => 'Modulis',
    'LBL_RELATIONSHIP' => 'Relācija',
    'LBL_SINGULAR_LABEL' => 'Vienskaitļa etiķete',
    'LBL_PLURAL_LABEL' => 'Daudzskaitļa etiķete',
    'LBL_MODULE_DISPLAY' => 'Parādīt',
    'LBL_MODULE_DISPLAY_TYPE' => 'Displeja tips',
    'LBL_MODULE_ICON' => 'Ikona',
    'LBL_MODULE_COLOR' => 'Moduļa fona krāsa',
    'LBL_LANGUAGE_SELECTOR' => 'Valoda',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'Moduļa iestatījumi',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'Moduļa iestatījumi ir saglabāti.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Kopēt adresi no kreisās puses:',
    'LBL_SAVE_AND_CONTINUE' => 'Saglabāt un turpināt',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Izvēles vadības</strong></p><ul><li>Uzspiest uz vērtībām, lai izvēlētos atribūtu.</li><li>Ctrl-click&nbsp;lai&nbsp;izvēlētos vairākus. Mac lietotājiem izmantojiet CMD-click.</li><li>Lai izvēlētos visas vērtības starp diviem atribūtiem,&nbsp; uzklikšķiniet uz pirmo vērtību&nbsp;un tad spiediet shift un pēdējo vērtību.</li></ul><p><strong>Izvērstās meklēšanas un izkārtojuma iespējas</strong><br><br>Lietojot <b>saglabāto meklēšanas un izkārtojuma</b> opciju, var saglabāt meklējamos parametrus un/vai pielāgoto saraksta skata izkārtojumu, lai ātri iegūtu vēlamos meklēšanas rezultātus turpmāk. Jūs varat glabāt neierobežotu meklēšanas un izkārtojumu skaitu. Visi saglabātie rezultāti tiks attēloti pēc nosaukuma saglabāto meklējumu sarakstā, kurā pēdējais ielādētais saglabātais meklējums parādās saraksta augšdaļā.<br><br>Lai pielāgotu saraksta skata izkārtojumu, izmantojiet lodziņus Paslēpt kolonas un Parādīt kolonas, lai izvēlētos, kurus laukus attēlot meklēšanas rezultātos. Piemēram, Jūs varat apskatīt paslēpto informāciju, piemēram, ieraksta nosaukums, pievienotie lietotāji, pievienotās darba grupas meklēšanas rezultātos. Lai pievienotu kolonu saraksta skatam, jāizvēlas lauks no paslēpto kolonu saraksta un jāizmanto kreisā bultiņa, lai to pārvietotu uz Parādīto kolonu sarakstu. Lai izņemtu kolonu no saraksta skata, tā ir jāizvēlas no Parādīto kolonu saraksta un jāizmanto labā bultiņa, lai to pārvietotu uz paslēpto kolonu sarakstu.<br><br>Ja saglabāsit izkārtojuma iestatījumus, tos varēsit ielādēt jebkurā laikā, lai apskatītu meklēšanas rezultātus pielāgotajā izkārtojumā.<br><br>Lai saglabātu un uzlabotu meklēšanu un/vai izkārtojumu:<ol><li>Ievadīt meklējamo nosaukumu laukā <b>Saglabāt meklēšanu kā</b> un piespiediet <b>Saglabāt</b>.Nosaukums tagad ir redzams saglabāto meklējumu sarakstā blakus pogai <b>Notīrīt</b>.</li><li>Lai apskatītu saglabāto meklēšanu, tā jāizvēlas no saglabāto meklēšanu saraksta. Meklēšanas rezultāti ir parādīti Saraksta skatā.</li><li>Lai uzlabotu saglabāto meklējumu iespējas, jāizvēlas saglabātās meklēšanas forma no saraksta, jāievada jauns meklēšanas kritērijs un/vai izkārtojuma iespējas paplašinātajā meklēšanas apgabalā, un jāspiež <b>Uzlabot</b>, kas atrodas blakus <b>Modificēt pašreizējo meklēšanu</b>.</li><li>Lai dzēstu saglabāto meklēšanu, tā ir jāizvēlas saglabāto meklējumu sarakstā, jāspiež <b>Dzēst</b>, kas atrodas blakus <b>Modificēt pašreizējo meklēšanu</b>, un jāspiež <b>OK</b>, lai apstiprinātu dzēšanu.</li></ol><p><strong>Padomi</strong><br><br>Lietojot % kā aizstājējzīmes operatoru, meklēšanu var padarīt pārskatāmāku. Piemēram, tā vietā, lai meklētu rezultātus, kas atbilst "Apples", var nomainīt meklēšanu uz "Apples%", kas atlasīs visus rezultātus, kas sākas ar vārdu Apples, bet var saturēt arī citus simbolus.</p>',

    //resource management
    'ERR_QUERY_LIMIT' => 'Kļūda: vaicājuma ierobežojums $limit sasniegts modulī $module.',
    'ERROR_NOTIFY_OVERRIDE' => 'Kļūda: ResourceObserver->notify() ir jāignorē.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'Kļūda: Nevar izveidot monitoru, jo metadatu fails ir tukšs vai neeksistē.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'Kļūda: Norādītajam vārdam nav nokonfigurēts monitors',
    'ERR_UNDEFINED_METRIC' => 'Kļūda: Nenodefinētai metrikai nevar uzstādīt vērtību',
    'ERR_STORE_FILE_MISSING' => 'Kļūda: Nevar atrast glabājamo implementācijas failu',

    'LBL_MONITOR_ID' => 'Monitora Id',
    'LBL_TEAM_ID' => 'Darba grupas ID:',
    'LBL_SELECT_MODULE' => 'Izvēlieties moduli',
    'LBL_USER_ID' => 'Lietotāja ID',
    'LBL_MODULE_NAME' => 'Moduļa nosaukums',
    'LBL_MODULE_ALL' => 'Visi',
    'LBL_ITEM_ID' => 'Ieraksta Id',
    'LBL_ITEM_SUMMARY' => 'Ieraksta kopsavilkums',
    'LBL_ACTION' => 'Darbība',
    'LBL_SESSION_ID' => 'Sesijas Id',
    'LBL_BREADCRUMBSTACK_CREATED' => 'BreadCrumbStack izveidots lietotājam ar id {0}',
    'LBL_VISIBLE' => 'Ieraksts redzams',
    'LBL_DATE_LAST_ACTION' => 'Pēdējās darbības datums',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL teksts',
    'LBL_QUERY_HASH' => 'SQL Hash',
    'LBL_SEC_TOTAL' => 'Sekundes kopā',
    'LBL_SEC_AVG' => 'Sekundes vidēji',
    'LBL_RUN_COUNT' => 'Vaicājumu skaits',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'Klienta IP Adrese',
    'LBL_DATE_START' => 'Sākuma datums',
    'LBL_ACTIVE' => 'Aktīvs',
    'LBL_ROUNDTRIPS' => 'Darbību skaits',
    'LBL_SECONDS' => 'Sekundes aktīvsgg',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'Datubāzes caurskates',
    'LBL_FILES_OPENED' => 'Faili, kuriem piekļūts',
    'LBL_MEMORY_USAGE' => 'Izmantotā atmiņa (baiti)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'Ielādē Twitter savienotāju...',
    'LBL_TWITTER_DATA_EMPTY' => 'No Twitter dati nav pieejami',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Sugar spraudnis priekš Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Integrēt Sugar e-pastu un kalendāra informāciju ar Microsoft Outlook',
    'LBL_PLUGIN_WORD_NAME' => 'Sugar spraudnis priekš Word',
    'LBL_PLUGIN_WORD_DESC' => 'Automātiski izplatīt informāciju no SugarCRM uz formas vēstulēm, sūtīt pastu un citus Microsoft dokumentus.',
    'LBL_PLUGIN_EXCEL_NAME' => 'Sugar spraudnis priekš Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'Integrēt Sugar ar izklājlapām, labākai atslēgu metrikas analīzei.',
    'LBL_PLUGINS_TITLE' => 'Sugar spraudņi priekš Microsoft Office<sup>TM</sup>',
    'LBL_PLUGINS_DESC' => 'Lasīt par spraudņu iespējām <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">Spraudņu Dokumentācijā</a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Sugar spraudņi priekš Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'Sugar spraudnis priekš Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'Integrēt Sugar ar Lotus Notes.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'nav pirms',
    'MSG_IS_MORE_THAN' => 'vairāk kā',
    'MSG_IS_LESS_THAN' => 'ir mazāk par',
    'MSG_SHOULD_BE' => 'vajadzētu būt',
    'MSG_OR_GREATER' => 'vai vairāk',
    'MSG_EXCEEDS_MAXLEN' => 'pārsniedz norādīto maksimālo garumu ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Sveicināti Sugar Portālā 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal ir karkass, kurš piedāvā reālā laika pieteikumu skatījumu, nepilnības, ziņas utt. klientiem. Tas ir ārējais Sugar interfeiss, kuru var attēlot ar jebkurā tīmekļa lapā. Sekojiet līdzi vairākām klientu  pašapkalpošanās servisa iespējām tādām, kā Projektu pārvaldība un forumi, mūsu nākamajos laidienos.',
    'LBL_LIST' => 'Saraksts',
    'LBL_CREATE_CASE' => 'Izveidot pieteikumu',
    'LBL_CREATE_BUG' => 'Pieteikt kļūdu',
    'LBL_NO_RECORDS_FOUND' => '- Nav atrasti ieraksti -',

    'DATA_TYPE_DUE' => 'Dēļ:',
    'DATA_TYPE_START' => 'Sākt:',
    'DATA_TYPE_SENT' => 'Nosūtīts:',
    'DATA_TYPE_MODIFIED' => 'Modificēts:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Skaits',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'objekta attēls',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'Izvēlēties datumu',

    'LBL_VALIDATE_RANGE' => 'nav derīgā intervālā',
    'LBL_VALIDATE_URL' => 'nav derīgs vietrādis URL',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'Viss',

    'LBL_OPERATOR_IN_TEXT' => 'Viens no sekojošajiem:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'Nav viens no sekojošajiem:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Kļūda: Masīvu skaits bean parametrā nesakrīt ar masīvu skaitu rezultātā.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Kļūda: Moduļa kartēšanas ieraksts nav pieejams.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Kļūda: Nav iespējams saņemt datus {0} savienotājam. Serviss pagaidām var būt nepieejams vai konfigurācijas uzstādījumi var būt nederīgi. Savienotāja kļūdas ziņojums: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'Nevar izgūt datus. Serviss pašreiz nav pieejams vai arī ir nederīgi konfigurācijas iestatījumi.',
    'LBL_CONNECT_TWITTER' => 'Pievienot Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'Can not find valid timeline for Twitter ID:',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'Konfigurēt „Twitter” savienotāju',
    'LBL_CONNECT_TEST_FAIL' => 'Kļūda: Savienotāja konfigurācijas iestatījumi var būt nederīgi. Sazinieties ar administratoru.',
    'LBL_CONFIGURE_TWITTER' => 'Sazinieties ar Administratoru lai pareizi nokonfigurētu Twitter',
    'LBL_MERGE_CONNECTORS' => 'Iegūt datus',
    'LBL_NO_DATA_AVAILABLE' => 'Dati nav pieejami.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'Vai tiešām vēlies deaktivizēt savienotāja integrāciju šim modulim?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Neizdevās izveidot savienojumu ar Elastic serveri',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'Globālā darba grupa nevar tikt dzēsta.',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'Privātā darba grupa [{0}] nevar tikt dzēsta kamēr lietotājs [{1}] nav izdzēsts.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'Vai nu Jums ir izslēgts Adobe Flash vai arī Jūs lietojiet vecāku Adobe Flash Player versiju. Lai iegūtu jaunāko Flash Player versiju, <a href="http://www.adobe.com/go/getflashplayer/">spied šeit</a>.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'Nosaukums',
    'LBL_COLLECTION_PRIMARY' => 'Primārs',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'Tukšs obligātais lauks',
    'LBL_COLLECTION_EXACT' => 'Precīzs',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'Optimālai IIS/FastCGI sapi lietošanai php.ini datnē parametram fastcgi.logging uzstādiet vērtību 0.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'Piešķirts lietotājam',
    'LBL_DESCRIPTION' => 'Apraksts',
    'LBL_PRIMARY_CONTACT_NAME' => 'Galvenā kontaktpersona',
    'LBL_PRIMARY_CONTACT_ID' => 'Galvenās kontaktpersonas ID',

    'LBL_NONE' => '--Neviens--',
    'LBL_YESTERDAY' => 'Vakar',
    'LBL_TODAY' => 'šodien',
    'LBL_TOMORROW' => 'rīt',
    'LBL_NEXT_WEEK' => 'nākamnedēļ',
    'LBL_NEXT_MONDAY' => 'nākošajā pirmdienā',
    'LBL_NEXT_FRIDAY' => 'nākošajā piektdienā',
    'LBL_TWO_WEEKS' => 'divas nedēļas',
    'LBL_NEXT_MONTH' => 'nākamajā mēnesī',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'Nakošā mēneša pirmā diena',
    'LBL_THREE_MONTHS' => 'trīs mēneši',
    'LBL_SIXMONTHS' => 'seši mēneši',
    'LBL_NEXT_YEAR' => 'Nākamajā gadā',
    'LBL_FILTERED' => 'Filtrēti',

    //Datetimecombo fields
    'LBL_HOURS' => 'Stundas',
    'LBL_MINUTES' => 'Minūtes',
    'LBL_MERIDIEM' => 'Dienas vidus',
    'LBL_DATE' => 'Datums',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Automātiski atjaunot',

    'LBL_DURATION_DAY' => 'diena',
    'LBL_DURATION_HOUR' => 'stundas',
    'LBL_DURATION_MINUTE' => 'minūte',
    'LBL_DURATION_DAYS' => 'dienas',
    'LBL_DURATION_HOURS' => 'stundas',
    'LBL_DURATION_MINUTES' => 'minūtes',
    'LBL_DURATION_SECONDS' => 'sekundes',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'Izvēlēties mēnesi',
    'LBL_ENTER_YEAR' => 'Ievadiet gadu',
    'LBL_ENTER_VALID_YEAR' => 'Lūdzu ievadiet derīgu gadu',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'Lūdzu ievadiet ciparu U.S. tālruņa numuru, ieskaitot apgabala kodu.',
    'LBL_CCP_NOT_INITIATED' => 'Mēģinājums sastādīt numuru, izmantojot CCP, kamēr aģents nav pierakstījies.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'Nevar iniciēt zvanu, izmantojot CCP.',
    'LBL_CCP_DIALING_ERROR' => 'Šo zvanu nevar pabeigt kā sastādītu.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'Pirms izejošā zvana veikšanas aizveriet visas tērzēšanas sesijas SugarLive.',

    //File write error label
    'ERR_FILE_WRITE' => 'Kļūda: Nevar ierakstīt failā {0}. Lūdzu pārbaudiet sistēmas un tīmekļa servera atļaujas.',
    'ERR_FILE_NOT_FOUND' => 'Kļūda: Nevar ielādēt failu {0}. Lūdzu pārbaudiet sistēmas un tīmekļa servera pieejas tiesības.',

    'LBL_AND' => 'un',
    'LBL_BEFORE' => 'Pirms',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'Augšuplādēt no sava datora',
    'LBL_SEARCH_EXTERNAL_API' => 'Fails no ārējā avota',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'Augšupielādēt uz ārējo avotu',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'Pievienot no ārējā avota',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'Drošība',
    'LBL_SHARE_PRIVATE' => 'Privāts',
    'LBL_SHARE_COMPANY' => 'Uzņēmums:',
    'LBL_SHARE_LINKABLE' => 'Sasaistāms',
    'LBL_SHARE_PUBLIC' => 'Publisks',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS barotne',
    'LBL_RSS_RECORDS_FOUND' => 'atrasts(i) ieraksts(i)',
    'ERR_RSS_INVALID_INPUT' => 'RSS nav derīgs ievades tips (input_type)',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS nav derīgs atbildes tips(respone_type) šai metodei',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs neatbalsta ievadīto faila formātu.',

    'LBL_BLANK_VALUE' => '<Blank>',
    'LBL_EMPTY' => 'Tukšs',
    'LBL_IS_EMPTY' => 'Ir tukšs',
    'LBL_IS_NOT_EMPTY' => 'Nav tukšs',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '
"Šis ir importa faila paraugs, kurš piedāvā piemēru faila saturam, kurš ir gatavs importēšanai." "Faila formāts ir ar paplašinājumu .csv, kurš izmanto dubultās pēdiņas, lauku noteikšanai." "Galvenes rinda ir pirmā rinda failā un satur lauka iezīmes, kā redzams lietotnē." "Šīs iezīmes lieto, kartējot datus no faila uz lietojumprogrammas laukiem." "Piezīmes: Arī datubāzes lauku nosaukumus var lietot galvenes rindā. Tas noder gadījumos, kad tiek lietots phpMyAdmin vai cits datubāzes rīks, lai varētu importēt eksportēto datu sarakstu." "Kolonu secība nav tik nozīmīga, jo importēšanas procesā lauki tiek sakārtoti, balstoties uz galvenes rindu." "Lai lietotu failu kā veidni, veic sekojošas darbības:" "1.Izņemiet ierakstu parauga rindas" "2. Izņemiet palīdzības tekstu, kuru šobrīd lasāt" "3. Ievadiet savus datus paredzētajās rindās un kolonās" "4. Saglabājiet failus savā sistēmā, jums zināmā vietā" "5. Nospiediet uz importēšanas iespējas, kura atrodas darbību izvēlnē lietotnē, un izvēlieties failu, kuru augšuplādēt"   ',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'Piešķirts lietotājam ID',
    'LBL_EXPORT_CREATED_BY' => 'Izveidoja ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'Modificētāja ID',
    'LBL_EXPORT_REPORTS_TO_ID' => 'Vadītāja ID:',
    'LBL_EXPORT_TEAM_ID' => 'Darba grupas ID',
    'LBL_EXPORT_TEAM_SET_ID' => 'Darba grupu kopas ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Piešķirtais lietotājs',
    'LBL_EXPORT_FULL_NAME' => 'Pilns vārds',
    'LBL_EXPORT_TEAM_NAME' => 'Darba grupas',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navigācija...',

    'LBL_PENDING_NOTIFICATIONS' => 'Paziņojumi',
    'LBL_ALT_ADD_TEAM_ROW' => 'Pievienot jaunu darba grupu',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'Izņemt darba grupu',
    'LBL_ALT_SPOT_SEARCH' => 'Vietas meklēšana',
    'LBL_ALT_NOT_SORTED' => 'Nav sašķirots',
    'LBL_ALT_SORT_DESC' => 'Sakārtots dilstošā secībā',
    'LBL_ALT_SORT_ASC' => 'Sakārtots augošā secībā',
    'LBL_ALT_SORTABLE' => 'Šķirojams',
    'LBL_ALT_NOT_SORTABLE' => 'Nav šķirojams',
    'LBL_ALT_SORT' => 'Kārtot',
    'LBL_ALT_SHOW_OPTIONS' => 'Rādīt iespējas',
    'LBL_ALT_HIDE_OPTIONS' => 'Slēpt iespējas',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'Pārvietot atzīmēto ierakstu uz sarakstu kreisajā pusē',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Pārvietot atzīmēto ieraksu uz sarakstu labajā pusē',
    'LBL_ALT_MOVE_COLUMN_UP' => 'Pārvietot izvēlēto ierakstu augšā attēlotajā sarakstā',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'Pārvietot izvēlēto ierakstu lejā attēlotajā sarakstā',
    'LBL_ALT_INFO' => 'Informācija',
    'MSG_DUPLICATE' => '{0} ieraksts, kuru vēlies izveidot, iespējams ir dublikāts jau esošam ierakstam {0}. {1} ieraksti ar līdzīgu nosaukumu ir izkārtoti zemāk<br>Klikšķini Izveidot {1} , lai turpinātu veidot šo jauno  {0}, vai klikšķiniet uz esošu {0} izkārtotu zemāk.',
    'MSG_SHOW_DUPLICATES' => '{0} ieraksts, kuru vēlies izveidot, iespējams ir dublikāts jau esošam ierakstam {0}. {1} ieraksti ar līdzīgu nosaukumu ir uzskaitīti zemāk. Spiediet Saglabāt, lai turpinātu veidot šo jauno {0}, vai spiediet Atcelt, lai atgrieztos modulī, neveidojot {0}.',
    'LBL_EMAIL_TITLE' => 'e-pasta adrese',
    'LBL_EMAIL_OPT_TITLE' => 'nederīgās e-pasta adreses',
    'LBL_EMAIL_INV_TITLE' => 'nederīga e-pasta adrese',
    'LBL_EMAIL_PRIM_TITLE' => 'Primārā e-pasta adrese',
    'LBL_SELECT_ALL_TITLE' => 'Izvēlēties visu',
    'LBL_SELECT_THIS_ROW_TITLE' => 'Izvēlēties šo ierakstu',
    'LBL_TEAM_SELECTED_TITLE' => 'Darba grupa izvēlēta',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Izvēlieties, lai padarītu šo darba grupu par primāro',
    'LBL_TEAM_TBSELECTED_TITLE' => 'Darba grupa ir atzīmēta kā izvēlētā darba grupa ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'Atzīmējiet šo darba grupu kā izvēlēto darba grupu',
    'LBL_SEARCH_AND_SELECT' => 'Meklēt un atlasīt {{module}}',
    'TPL_SEARCH_AND_ADD' => 'Meklēt un pievienot {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'KĻŪDA: Kļūda augšupielādes laikā. Kļūdas kods: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'KĻŪDA: Kļūda augšupielādes laikā. Kļūdas kods: {0} - {1}.  upload_maxsize ir {2}',
    'UPLOAD_ERROR_HOME_TEXT' => 'KĻŪDA: Kļūda augšupielādes laikā, pēc palīdzības lūdzu griezieties pie administratora.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'Ielādes izmērs ({0} baiti) pārsniedz maksimāli atļauto: {1} baitus',
    'UPLOAD_REQUEST_ERROR' => 'Notika kļūda. Atjauniniet laupu un mēģiniet vēlreiz.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => 'Rediģēt',
    'LBL_ADD_BUTTON_LABEL' => 'Pievienot',
    'LBL_EDIT_BUTTON_TITLE' => 'Rediģēt',
    'LBL_REFRESH_BUTTON_LABEL' => 'Atsvaidzināt',
    'LBL_REFRESH_BUTTON_TITLE' => 'Atsvaidzināt',
    'LBL_DUPLICATE_BUTTON_KEY' => 'U',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Dublicēt',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Dublicēt',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'Atskaišu grafiki',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'Atskaišu grafiki',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'Atskaites informācija',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'Atskaites informācija',
    'LBL_DELETE_BUTTON_KEY' => 'D',
    'LBL_DELETE_BUTTON_LABEL' => 'Dzēst',
    'LBL_DELETE_BUTTON_TITLE' => 'Dzēst',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => 'Saglabāt',
    'LBL_SAVE_BUTTON_TITLE' => 'Saglabāt',
    'LBL_CANCEL_BUTTON_KEY' => 'l',
    'LBL_CANCEL_BUTTON_LABEL' => 'Atcelt',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'lai pārtrauktu.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'lai paliktu lapā.',
    'LBL_CANCEL_BUTTON_TITLE' => 'Atcelt',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'Koplietot',
    'LBL_SHARE_BUTTON_TITLE' => 'Koplietot',
    'LBL_START_BUTTON_LABEL' => 'Sākt',
    'LBL_START_BUTTON_TITLE' => 'Sākt',
    'LBL_FINISH_BUTTON_LABEL' => 'Pabeigt',
    'LBL_FINISH_BUTTON_TITLE' => 'Pabeigt',
    'LBL_CONFIRM_BUTTON_LABEL' => 'Labi',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'lai turpinātu.',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'lai pamestu lapu un atceltu izmaiņas',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Īsinājumtaustiņi',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Formas funkcionalitāte - Alt+</strong><br/> I = red<b>i<b>ģēt (detalizēts skatījums)<br/> U = d<b>u<b>blēt (detalizēts skatījums)<br/> D = <b>D<b>zēst (detalizēts skatījums)<br/> R = Kop<3>l<3>ietot (detalizēts skatījums)<br/> A = s<3>a<3>glabāt (rediģēšanas skatījums)<br/> L = atcel<3>t<3> (rediģēšanas skatījums) <br/><br/></p><p><strong>Meklēšana un navigācija  - Alt+</strong><br/> 7 = Pirmā ievade rediģēšanas formā<br/> 8 = Uzlabotās meklēšanas saite<br/> 9 = Pirmā meklēšanas formas ievade<br/> 0 = Vienotās meklēšanas ievade<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'Eskalēt',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'Koplietot',
    'TPL_RECORD_SHARE_SUBJECT' => 'Koplietotais {{module}} {{name}} no {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'Lūdzu pārbaudiett {{module}} {{name}} no {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'savienotāju masīvs {0} ir nodefinēts nekorekti vai ir tukšs un nevar tikt izmantots.',
    'LBL_PDF_VIEW' => 'Lejupielādēt PDF',
    'LBL_PDF_EMAIL' => 'Sūtīt e-pastu ar PDF',

    'ERR_SUHOSIN' => 'Suhosin ir bloķējis plūsmas ielādi, suhosin.executor.include.whitelist pievienojiet &quot;upload&quot;(Vairāk informācijas sugarcrm.log failā)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'tagad',
    'LBL_TIME_AGO_SECONDS' => 'mazāk kā pirms minūtes',
    'LBL_TIME_AGO_MINUTE' => 'apmēram pirms 1 minūtes',
    'LBL_TIME_AGO_MINUTES' => 'pirms {{this}} minūtēm',
    'LBL_TIME_AGO_HOUR' => 'apmēram pirms stundas',
    'LBL_TIME_AGO_HOURS' => 'pirms {{this}} stundām',
    'LBL_TIME_AGO_DAY' => 'vakar',
    'LBL_TIME_AGO_DAYS' => 'pirms {{this}} dienām',
    'LBL_TIME_AGO_YEAR' => 'vairāk kā pirms gada',
    'LBL_TIME_UNTIL_SECONDS' => 'mazāk kā minīte',
    'LBL_TIME_UNTIL_MINUTE' => 'minūtes laikā',
    'LBL_TIME_UNTIL_MINUTES' => '{{this}} minūtēs',
    'LBL_TIME_UNTIL_HOUR' => 'stundas laikā',
    'LBL_TIME_UNTIL_HOURS' => '{{this}} stundās',
    'LBL_TIME_UNTIL_DAY' => 'rīt',
    'LBL_TIME_UNTIL_DAYS' => '{{this}} dienas',
    'LBL_TIME_UNTIL_YEAR' => 'vairāk par gadu',
    'LBL_TIME_RELATIVE' => 'Nosūtīts {{relativetime}} - {{date}} - {{time}}',
    'LBL_LAST_TOUCHED' => 'Pēdējo reizi pieskārās {{relativetime}} {{date}} plkst. {{time}}',
    'LBL_LAST_COMMIT' => 'Pēdējā iesniegšana: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'Šajā laikā nav neviena ieraksta.',
    'LBL_DETAILVIEW_NO_RECORDS' => 'Pašlaik šo ierakstu nevar apstrādāt.',
    'LBL_REFINE_LIST' => 'Uzlabot sarakstu',
    'LBL_SEARCH_BY' => 'Meklēt pēc',
    'LBL_PREVIEW' => 'Priekšapskate',
    'LBL_COLUMNS' => 'Kolonnas',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'Priekšskatījums atslēgts: Dati nav pieejami',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'Priekšskatījums atslēgts: Nav piekļuves tiesību',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'Priekšskatījums atslēgts: Dati nav pieejami',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'Priekšskatījums atspējots: Tiek aplūkots kā pašreizējais ieraksts',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'Priekšskatījums atslēgts: Ieraksts ir izņemts vai nav piekļuves tiesību',
    'LBL_PREVIEW_PREVIOUS' => 'Skatīt iepriekšējo',
    'LBL_PREVIEW_NEXT' => 'Skatīt nākamo',
    'LBL_PREVIEW_CLOSE' => 'Aizvērt priekšskatījumu',
    'LBL_STREAM_NO_RECORDS' => 'Šim ierakstam pagaidām nav piezīmju. Pievienojiet piezīmi spiežot uz saites pievienot piezīmi.',
    'LBL_DUPLICATES_FOUND' => 'Atrasti {{duplicateCount}} dublikāti.',
    'LBL_NO_DUPLICATES_FOUND' => 'Dublikāti nav atrasti.',
    'LBL_RESET_DEFAULT_VIEW' => 'Uzlikt noklusēto skatu',
    'LBL_RESET_DEFAULT_WIDTHS' => 'Uzlikt noklusēto platumu',
    'LBL_TIMEZONE_UPDATED' => 'Sugar ir atjauninājis jūsu lietotāja profila laika joslu, lai tā atbilstu jūsu pārlūkprogrammas laika joslai',
    'LBL_SUCCESS' => 'Veiksmīgi',
    'LBL_ERROR' => 'Kļūda',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'Sapludināt',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'Vai vēlaties turpināt?',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'Šī darbība dzēsīs sekojošus ierakstus:',
    'LBL_MERGE' => 'Sapludināt',
    'TPL_MERGING_RECORDS' => 'Sapludina {{mergeCount}} Ierakstus',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'Nederīgs ierakstu skaits. Derīgs ierakstu skaits ir intervālā no {{minRecords}} līdz {{maxRecords}}.',
    'LBL_MERGE_NO_ACCESS' =>
        'Jums nav pieejas tiesību lai veiktu šo darbību',
    'LBL_MERGE_LOCKED' => 'Daži apvienošanai izvēlētie ieraksti satur laukus, ko process ir nobloķējis rediģēšanai, un tos šobrīd nevar apvienot.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'Jūs izmainījāt primāro ierakstu nesaglabājot veiktās izmaiņas. visas veiktās izmaiņas pazudīs. Vai vēlaties turpināt?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'Sapludināt pakārtotos ierakstus',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'Sapludināts: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'Pakārtoto {{objectName}} sapludināšana neizdevās. Sāk mēģinājumu ({{num}} no {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'Pakārtoto  {{objectName}} sapludināšana neizdevās.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'Nepilnīga pakārtoto ierakstu sapludināšana. Daži palikuši nesapludināti.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'Nepilnīga pakārtoto ierakstu sapludināšana. Daži palikuši nesapludināti. Vai vēlaties turpināt?',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'Visi saistītie ieraksti tiks pārvietoti uz primāro ierakstu.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'Vai tiešām vēlaties izņemt šo ierakstu no apvienošanas?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'Izņemt ierakstu no sapludināšanas',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'Nederīgs iesniegto ierakstu skaits. Derīgais diapazons ir no 1 līdz {{maxRecords}} ierakstiem.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'Norādītā lietotājvārda un paroles kombinācija nav pareiza, mēģiniet vēlreiz.',
    'LBL_INVALID_CREDS_TITLE' => 'Nederīgi pieslēgšanās dati',
    'LBL_INVALID_GRANT' => 'Jūsu atslēga nav derīga vai beidzies tās derīguma termiņš. Lūdzu piesakieties vēlreiz.',
    'LBL_INVALID_GRANT_TITLE' => 'Atslēgai ir beidzies derīguma termiņš',
    'LBL_AUTH_FAILED' => 'Lietotāja autentifikācija neveiksmīga.',
    'LBL_AUTH_FAILED_TITLE' => 'Nederīgs klients',
    'LBL_INVALID_REQUEST' => 'Veiktais pieprasījums ir nederīga vai sabojāts. Lūdzu, sazinieties ar tehnisko atbalstu.',
    'LBL_INVALID_REQUEST_TITLE' => 'Nederīgs pieprasījums',
    'LBL_REQUEST_TIMEOUT' => 'Serveris neatbild. Pārbaudiet savu interneta savienojumu.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'Pieprasījuma noildze: ',
    'LBL_UNAUTHORIZED' => 'Mēs atvainojamies, bet šķiet jums nav tiesību piekļūt šim resursam.',
    'LBL_UNAUTHORIZED_TITLE' => 'Neautorizēts',
    'LBL_RESOURCE_UNAVAILABLE' => 'Resurss nav pieejams.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'Aizliegts',
    'LBL_METHOD_NOT_ALLOWED' => 'HTTP metode nav atļauta šim resursam. Lūdzu, sazinieties ar tehnisko atbalstu.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'Metode nav atļauta',
    'LBL_PRECONDITION_MISSING' => 'Pieprasījuma kļūda vai neesošs/nederīgs parametrs.  Lūdzu, sazinieties ar tehnisko atbalstu.',
    'LBL_PRECONDITION_MISSING_TITLE' => 'Kļūda:',
    'LBL_INVALID_412_RESPONSE' => 'Pieprasījums neizdodas, kas padara lietotni neizmantojamu. Sazinieties ar tehniskā atbalsta dienestu.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'Nav atļauts rediģēt lauku  {0} modulī: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'Nav atļauts veikt darbību "{0}" šim ierakstam',
    'LBL_LOGIN_BUTTON_LABEL' => 'Pieteikšanās',
    'LBL_ACTIVITY_VIEW_TOUR' => 'Darbību apskates tūre',
    'LNK_TOUR' => 'Tūre',
    'LNK_MOBILE' => 'Mobilais tālrunis',
    'LBL_FEEDBACK' => 'Atsauksme',
    'LBL_SUPPORT' => 'Atbalsts',
    'LBL_LANGUAGE' => 'Valoda',
    'LBL_LOADING_LANGUAGE' => 'Ielādē valodas paku',
    'LBL_UPLOADING' => 'Augšupielādē',
    'LBL_UPLOADING_DOTS' => 'Augšupielādē...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'Vai tiešām vēlaties dzēst šo attēlu?',
    'LBL_FILE_DELETE_CONFIRM' => 'Vai tiešām vēlaties dzēst šo failu. Šo darbību nevarēs atcelt.',
    'LBL_FILE_DELETED' => 'Fails veiksmīgi dzēsts',

    //theme roller
    'LBL_PORTAL_THEME' => 'Portāla tēma',
    'LBL_THEME_PREVIEW' => 'Portāla tēmas priekšskatījums',
    'LBL_LOADING_PREVIEW' => 'Ielādē Priekšskatījumu',
    'LBL_RESET' => 'Atiestatīt',
    'LBL_COLORS' => 'Krāsas',
    'BorderColor' => 'Rāmja krāsa',
    'NavigationBar' => 'Navigācijas josla',
    'PrimaryButton' => 'Primārā poga',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'Saglabāt un izvietot',
    'LBL_RESET_THEME_LNK' => 'Atjaunot noklusējuma tēmu',
    'LBL_RESET_THEME_MODAL_INFO' => 'Jūs taisāties izdzēst savu tēmu aizstājot to ar noklusējuma tēmu',
    'LBL_RESET_THEME_PROCESS' => 'Atjauno noklusējuma tēmu ...',
    'LBL_SAVE_THEME_PROCESS' => 'Saglabā tēmu ...',

    // image loader
    'LBL_SELECT_PHOTO' => 'Atzīmējiet fotogrāfiju',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Sugar uzlabotā prognozēšanas funkcionalitāte',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Setup your forecasting parameters</li><li class="icon-ok">Easily track projected sales and pipeline health</li><li class="icon-ok">Forecast based on projected sales from your sales team</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'Iestatīt prognozes parametrus',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Choose fiscal year start date</li><li class="icon-ok">Setup Time Periods to be either yearly or quarterly</li><li class="icon-ok">Decide how many past and future Time Periods need to be visible in the worksheet</li><li class="icon-ok">Select forecast ranges to tag Opportunities as Include, Exclude or Upside</li><li class="icon-ok">Select forecast scenarios to identify Likely, Best and Worst forecast</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'Manage your Sales Team&#39;s Projected Sales',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Select the Time Period to review forecast</li><li class="icon-ok">View your sales team members’ worksheets and provide adjusted forecasts</li><li class="icon-ok">See alert on worksheet when a sales team member commits a new forecast</li><li class="icon-ok">Save forecast worksheet as a draft version or commit forecast to your manager</li><li class="icon-ok">View history of previous commits</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'Manage your Sales Team&#39;s Projected Sales',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">View Pareto chart for pipeline analysis across all your sales team members&#39; forecasts</li><li class="icon-ok">Choose to visualize projected sales by Likely, Best or Worst forecast</li><li class="icon-ok">View projected sales and how close you are to make your team quota</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'Pārvaldiet savu Plānoto pārdošanu apjomu',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Select the Time Period for your forecast</li><li class="icon-ok">Review and in-line edit amounts and Win Probability for a quick what-if analysis</li><li class="icon-ok">Save forecast worksheet as a draft version or commit forecast to your manager</li><li class="icon-ok">View history of previous commits</li><li class="icon-ok">Commit Forecast to Manager and view History of previous Commits</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'Pārvaldiet savu Plānoto pārdošanu apjomu',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">View Pareto chart for pipeline analysis over time for your Opportunities</li><li class="icon-ok">Choose to visualize pipeline distribution by Sales Stage or Win Probability</li><li class="icon-ok">View projected sales and how close you are to make your assigned quota</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Kas jauns Sugar',
    'LBL_TOUR_WATCH' => 'Skatīties kas jauns Sugar',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="icon-ok">Uzlabotais izskats – tagad ar jaunu saskarnes noformējuma tēmu.</li><li class="icon-ok">Uzlabotais Prognožu modulis – tagad ar intuitīvu lietotāja saskarni un jaunu datu vizualizāciju</li></ul>',
    'LBL_TOUR_VISIT' => 'Lai iepazītos ar sīkāku informāciju, apmeklējiet mūsu lietojumprogrammu',
    'LBL_TOUR_DONE' => 'Jūs esat pabeidzis.',
    'LBL_TOUR_REFERENCE_1' => 'Jūs vienmēr varat atsaukties uz mūsu',
    'LBL_TOUR_REFERENCE_2' => 'caur "Support" saiti zem profila izvēlnes.',
    'LNK_TOUR_DOCUMENTATION' => 'dokumentācija',
    'LBL_TOUR_CALENDAR_URL_1' => 'Vai jūs mēdzat sinhronizēt savu SugarCRM kalendāru ar citām programmām, piemēram ar Microsoft Outlook vai Exchange? Ja jā, tad jums ir jauns URL. Šis jaunais, drošākais URL iekļauj personīgo atslēgu, kura neļaus neautorizētu jūsu kalendāra publicēšanu.',
    'LBL_TOUR_CALENDAR_URL_2' => 'Saņemt savu kopīgotā kalendāra URL.',
    'LBL_TOUR_CUBE' => 'Piekļūstiet instrumentu paneļiem un aktivitāšu plūsmām.',
    'LBL_TOUR_NAV_BAR' => 'Piekļūstiet visiem moduļiem navigācijas izvēlnē un veiciet darbības.',
    'LBL_TOUR_NOTIFICATIONS' => 'Klikšķiniet, lai apskatītu paziņojumus.',
    'LBL_TOUR_SEARCH' => 'Atlasiet vienu vai vairākus moduļus un meklējiet.',
    'LBL_TOUR_AVATAR' => 'Iegūstiet vairāk informācijas par lietojumprogrammu vai izrakstieties no sistēmas.',
    'LBL_TOUR_ADD' => 'Izveidojiet ierakstu šeit.',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'Klikšķiniet, lai aizvērtu vai atvērtu inteliģences paneli.',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'Izvēlieties, lai aplūkotu aktivitātes vai ierakstu sarakstu.',
    'LBL_TOUR_LIST_FILTER1' => 'Filtra josla ļauj veikt meklēšanu šajā modulī.',
    'LBL_TOUR_LIST_FILTER2' => 'Izvēlieties iepriekš definētu filtru vai veidojiet jaunu.',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'Rakstiet šeit, lai meklētu pēc vārda.',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'Izvēlieties, lai rediģētu rindu vai aplūkotu detaļas.',
    'LBL_TOUR_RECORD_ACTIONS' => 'Veiciet darbības ar ierakstu',
    'LBL_TOUR_RECORD_SUBPANEL' => 'Uzklikšķiniet uz virsraksta, lai izvērstu vai sakļautu apakšpaneli',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'Šajā vietā var atjaunināt ieraksta nosaukumu',
    'LBL_TOUR_RECORD_STATUS' => 'Ieraksta statuss redzams šeit',
    'LBL_TOUR_RECORD_SHOWMORE' => 'Klikšķiniet lai aplūkotu ieraksta papildus informāciju',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'Izvēlies lai redzētu  aktivitātes vai saistītos ierakstus',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'Klikšķini lai rediģētu katru lauku formā',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'Veidot jaunas Dašletu grupas',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'Piešķirt nosaukumu Dašletu grupai',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'Izvēlies lai izņemtu Dašletu vai izmainītu iestatījumus.',
    'LBL_TOUR_INTRO' =>'<h4>Sveicināti „Sugar”!</h4> Vēlamies iepazīstināt ar dažām iespējām. Lietojiet ekrāna apakšā redzamās bultiņas (< un >), lai iepazītos ar lapu.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">Kas jauns?</a><p class="details">Iepazīstieties ar galvenajām atšķirībām starp versijām.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Uzziniet vairāk par „Sugar”!</a><p class="details">Vispārēja e-apmācību bibliotēka, tiešas un virtuālas apmācības klasē, tīmekļsemināri un videopamācības.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">Saņemiet atbalstu!</a><p class="details">Vajadzīga palīdzība? Ir kāda problēma, vai vēlaties padarīt „Sugar” labāku?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'Aplūkot ierakstu sarakstu un veikt darbības ar ierakstiem.',
    'LBL_TOUR_RECORD_INTRO' => 'Aplūko ieraksta informāciju un visus ar ierakstu saistītos datus.',
    'LBL_TOUR_FORECAST_INTRO' => 'Pārvaldīt piltuvi un prognozes.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'Izvēlies laika periodu lai aplūkotu atbilstošo prognozi',
    'LBL_TOUR_FORECASTS_COMMITS' => 'Klikšķini lai redzētu iepriekšējos iesniegumus',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'Klikšķini lai rediģētu datus formā',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'Apskatiet atlikumu līdz kvotai',
    'LBL_TOUR_FORECASTS_CHART' => 'Apskatiet prognožu izvietojumu',
    'LBL_TOUR_TOUR' => 'Piekļūstiet tūrei jebkurā laikā',
    'LBL_TOUR_TAGS_ADD' => 'Uzklikšķiniet birku laukā, lai pievienotu un noņemtu birkas',
    'LBL_TOUR_TAGS_DELETE' => 'Lai dzēstu birku, izmantot taustiņu backspace, vai uzklikšķiniet uz pogas [X] katrai birkai',
    'LBL_TOUR_RECORD_SAVE' => 'Kad esat gatavs, uzklikšķiniet uz Saglabāt',


    'LBL_FUTURE' => 'Nākotnē',
    'LBL_REQUIRED_FIELD' => 'Obligāts',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'Piedāvājuma rindas vienums',
    'LBL_DISCOUNT_TOTAL' => 'Atlaide kopā',
    'LBL_DISCOUNT_PERCENT' => '% procenti',
    'LBL_DISCOUNT_SELECT' => 'Nosaka, vai atlaide tiek piemērota procentuāli vai kā fiksēta summa',
    'LBL_TAX' => 'Nodoklis',
    'LBL_SHIPPING' => 'Piegāde',
    'LBL_GRAND_TOTAL' => 'Kopsumma',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'Automātiski aizpildīt norēķinu adresi no klienta profila',
    'LBL_QLI_ADD_GROUP' => 'Pievienot grupu',
    'LBL_QLI_COMMENT' => 'Komentārs',
    'LBL_SELECT_ACTION' => 'Izvēlieties darbību',
    'LBL_QLI_GROUP_NAME' => 'Grupas nosaukums',
    'LBL_GROUP_TOTAL' => 'Grupas kopsumma',
    'LBL_ITEM_NAME' => 'Rindas vienums',
    'LBL_QLI_DELETE' => 'Vai tiešām vēlaties dzēst šo rindas vienumu?',
    'LBL_QLI_COMMENT_DELETE' => 'Vai tiešām vēlaties dzēst šo rindas vienuma komentāru?',
    'LBL_QLI_GROUP_DELETE' => 'Vai tiešām vēlaties dzēst grupu {0}? Visi vienumi tiks pārvietoti uz noklusējuma grupu.',
    'LBL_QLI_GROUP_EMPTY' => 'Nav piedāvājuma rindas vienuma',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'Neobligāts',
    'LBL_RELATED_MODULE' => 'Saistīts {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'Saistīts {{{this}}}',
    'LBL_CREATE_MODULE' => 'Izveidot {{{this}}}',
    'LBL_EDIT' => 'Rediģēt {{{this}}}',
    'LBL_ASSOC' => 'Asociēt {{{this}}}',
    'LBL_ASSIGN' => 'Atlasīt {{{this}}}',
    'LBL_EDIT_RELATED' => 'Rediģēt saistīto {{{this}}}',
    'LBL_CREATE_RELATED' => 'Izveidot saistīto {{{this}}}',
    'LBL_ASSOC_EXISTING' => 'Asociēt esošu {{{this}}}',
    'LBL_SEARCH_ALL' => 'Meklēt visus {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'Meklē visus ierakstus...',
    'LBL_SEARCH_ALL_MODULES' => 'Meklēt visus',
    'LBL_OK' => 'Labi',
    'LBL_YES' => 'Jā',
    'LBL_NO' => 'Nē',
    'LBL_SHOW_NUMBERING' => 'Rādīt posmu numerāciju',
    'LBL_HIDE_NUMBERING' => 'Slēpt posmu numerāciju',
    'LBL_CALL_BUTTON' => 'Zvans',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'E-pasts',
    'LBL_HONEYPOT' => 'Jā jūs esat īsts cilvēks neaizpildiet šo.',
    'LBL_LINK_BUTTON' => 'Saite',
    'LBL_UNLINK_BUTTON' => 'Noņemt',
    'LBL_MAP_BUTTON' => 'Kartēt',
    'LBL_FILE_BUTTON' => 'Fails',
    'LBL_URL_BUTTON' => 'Tīmeklis',
    'LBL_WARNING' => 'Brīdinājums',
    'LBL_CONFIRM' => 'Apstiprināt',
    'LBL_CONFIRMATION_POPUP' => 'Apstiprinājuma uznirstošais logs',
    'LBL_NO_ACCESS' => '(Nav pieejas)',
    'LBL_NO_ACCESS_LOWER' => 'Lietotājam nav piekļuves ierakstam',
    'LBL_NO_FIELD_ACCESS' => 'Nav piekļuves',
    'LBL_NO_LICENSE_ACCESS' => 'Nepieciešama licence',
    'LBL_VALUE_ERASED' => 'Vērtība izdzēsta',
    'LBL_VALUE_ERASED_TOOLTIP' => 'Šī informācija tika izdzēsta, izmantojot datu privātuma piepresījumu',
    'LBL_CREATE_RELATED_RECORD' => 'Izveidot saistītu ierakstu',
    'LBL_ASSOC_RELATED_RECORD' => 'Piesaistīt esošu ierakstu',
    'LBL_CHOOSE_LINK' => 'Izvēlieties saites veidu',
    'LBL_CHOOSE_PARENT_TYPE' => 'Izvēlieties vecāka tipu',
    'LBL_HOME' => 'Sākums',
    'ERR_NO_DOCS' => 'Dokumenti nav pieejami',
    'ERR_NO_RECORDS_SELECTED' => 'Jūs neesat atzīmējis nevienu ierakstu',
    'LBL_DELETING' => 'Dzēš...',
    'LBL_UNLINKING' => 'Noņem ...',
    'LBL_UNLINKED' => 'Noņemts',
    'LBL_LEGAL' => 'Legāls',
    'LBL_UPCOMING' => 'Mani gaidāmie notikumi',
    'LBL_RECENTLY_UPDATED' => 'Nesen atjaunināts',
    'LBL_NOTES_SUBPANEL_TITLE' => 'Piezīmes',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'Tikšanās',
    'LBL_TASKS_SUBPANEL_TITLE' => 'Uzdevumi',
    'LBL_CALLS_SUBPANEL_TITLE' => 'Zvani',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'Uzņēmumi',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'Kontakti',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'E-pasti',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'Maiņas',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'Piedāvājuma rindas',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'Maiņas izņēmumi',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'Dokumenti',
    'LBL_ESCALATIONS' => 'Eskalācijas',
    'LBL_ESCALATED' => 'Eskalēts',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'Eskalācijas',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'Citas saistītās eskalācijas',
    'LBL_ESCALATIONS' => 'Eskalācijas',
    'LNK_SETTINGS' => 'Uzstādījumi',
    'LBL_MOBILE_SUPPORT' => 'Atbalsts',
    'LBL_MOBILE_SHOW_MORE' => 'Rādīt vairāk...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'Rādīt vairāk...',
    'LBL_MOBILE_NO_RECORDS' => 'Ieraksti netika atrasti',
    'LBL_MOBILE_SEARCH_TEAMS' => 'Meklē darba grupas...',
    'LBL_MOBILE_SELECT_TEAMS' => 'Izvēlēties darba grupas',
    'LBL_MOBILE_WAIT' => 'Lūdzu uzgaidiet...',
    'LBL_MOBILE_LOGING_OUT' => 'Uzgaidiet kamēr notiek atteikšanās ...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'Atkārtoti pieteikties',
    'LBL_MOBILE_META_SYNC_FAILED' => 'Nevar sinhronizēties ar servei. Atkārtot?',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'Nevar sinhronizēties ar serveri. Atkārtot?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'Privātums, noteikumu & nosacījumi',
    'LBL_MOBILE_APP_VERSION' => 'Lietotnes versija',
    'LBL_MOBILE_SERVER_VERSION' => 'Servera versija',
    'LBL_MOBILE_SERVER_URL' => 'Servera URL',
    'LBL_MOBILE_PTR_PULL' => 'Lejupielādēt lai atjauninātu ...',
    'LBL_MOBILE_PTR_RELEASE' => 'Atbrīvot lai atjauninātu ...',
    'LBL_MOBILE_EDIT_REL' => 'Rediģēt relāciju',
    'LBL_MOBILE_DESKTOP' => 'Darbvirsmas versija',
    'LBL_MOBILE_DELETE_CONFIRM' => 'Vai tiešām vēlaties dzēst šo ierakstu?',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'Vai tiešām vēlaties atvienot šo ierakstu?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'Varbūt vēlaties reģistrēt pēdējo zvanu?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'Izvēlieties saņēmēju',
    'LBL_MOBILE_CHOOSE_PHONE' => 'Izvēlieties tālruņa numuru',
    'LBL_MOBILE_CHOOSE_URL' => 'Izvēlieties URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'Izvēlieties dokumentu',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'Izvēlieties vietu',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'Darbības nav pieejamas',
    'LBL_MOBILE_FEEDBACK' => 'Atsauksme',
    'LBL_MOBILE_DOC' => 'Dokuments',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'Lejupielāde sākta: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'Lejupielāde pabeigta: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'Augšupielādē failu...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'Fails veiksmīgi augšupielādēts',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'Sagatavo attēlu...',
    'LBL_CLOSE_SAVE_BUTTON' => 'Aizvērt uzdevumu un saglabāt',
    'LBL_LATER' => 'Vēlāk',
    'LBL_USE_HTTPS' => 'Lietot rošu savienojumu',
    'LBL_LOADING_FILES' => 'Joprojām tiek lādēt dokumentu saraksts. Mēģiniet vēlāk vēlreiz',
    'LBL_NEW_WEB_VERSION' => 'Pieejama jauna SugarCRM Mobile versija. Vai vēlaties atjaunināt?',
    'LBL_SET_FONTSIZE' => 'Fonta izmērs',
    'LBL_FONTSIZE_TINY' => 'Sīks',
    'LBL_FONTSIZE_SMALL' => 'Mazs',
    'LBL_FONTSIZE_NORMAL' => 'Normāls',
    'LBL_FONTSIZE_LARGE' => 'Liels',
    'LBL_FONTSIZE_LARGER' => 'Lielāks',
    'LBL_FONTSIZE_HUGE' => 'Milzīgs',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'Īpaši liels',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "Neizdevās lejupielādēt\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'Vairāk...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...Mazāk',
    'LBL_OFFLINE_MODE' => 'Bezsaistes režīms',
    'LBL_OFFLINE_DELETED' => 'Ieraksts nav atrasts.',
    'LBL_OFFLINE_DELETED_RELATED' => 'Saistītais ieraksts nav atrasts. Iespējams dzēsts vai atvienots.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'Jums piešķirto, izvēlēto un sekojamo ierakstu lejupielāde piekļuvei bezsaistē var aizņemt ilgu laiku. Ieteicams ātrs pieslēgums. Vai vēlaties turpināt?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'Vai vēlaties, lai Jums piešķirtie, izvēlētie un sekojamie ieraksti tagad tikti lejupielādēti piekļuvei bezsaistē? Šai darbībai ir ieteicams ātrs pieslēgums, jo šī operācija var aizņemt kādu laiku. Jūs varat lejupielādēt vēlāk, dodoties uz Galvenā izvēlne > bezsaistē.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'Ieraksti veiksmīgi lejupielādēti',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'Ielādē savus ierakstus...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'Kļūda ielādējot ierakstus',
    'LBL_OFFLINE_PREFETCHING' => 'Ielādē ierakstus...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'Ielādē {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'Atlikušais laiks ir apmēram {{estimatedTime}}...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => '{{module}} ielāde pabeigta',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'Tīra glabātuvi...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'Tīrīšana pabeigta',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'Vai vēlaties atcelt šo izmaiņu?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'Izmaiņu atcelšana pabeigta',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'Izmaiņu atcelšana neizdevās',
    'LBL_OFFLINE_CLEAR_DB' => 'Iztukšo glabātuvi...',
    'LBL_OFFLINE_COMPACT_DB' => 'Saspiež glabātuvi...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'This action will delete records you haven&#39;t accessed in a while. Proceed?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'Vai vēlaties izdzēst visus ierakstus no lokālās atmiņas?',
    'LNK_OFFLINE_SETTINGS' => 'Bezsaiste',
    'LBL_OFFLINE_SETTINGS' => 'Atkļūdošanas iestatījumi',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'Nav izmaiņu ko ko sinhronizēt.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'Izmaiņas gaida sinhronizāciju',
    'LBL_OFFLINE_STATUS_ONLINE' => 'Iekārta ir tiešsaistē.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'Iekārta nav tiešsaistē.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'Nevar sazināties ar serveri',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'Pēdējās sinhronizēšanas mēģinājums neizdevās. Pārbaudiet darbību žurnālu.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'Notiek sinhronizācija ...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'Transakcija sinhronizēta.',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'Vai tiešām vēlaties ieslēgt bezsaistes atbalstu?',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'Vai vēlaties izslēgt bezsaistes atbalstu? Tiks zaudētas visas izmaiņas, kas gaida sinhronizāciju.',
    'LBL_OFFLINE_ENABLED' => 'Aktivizēts bezsaistes režīms',
    'LBL_OFFLINE_DISABLED' => 'Bezsaistes režīms atslēgts',
    'LBL_OFFLINE_STATS' => 'Glbātuves statistika',
    'LBL_OFFLINE_SERVER_FETCH' => 'Ielādē no servera...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'Kāds ir rediģējis to pašu ierakstu serverī. Apstipriniet, lai automātiski sapludinātu izmaiņas, vai noraidiet, lai tās atceltu.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'Pēdējais sinhronizācijas mēģinājums: {{ts}}',
    'LBL_ACTION_UPDATE' => 'ATJAUNINĀT',
    'LBL_ACTION_CREATE' => 'IZVEIDOT',
    'LBL_ACTION_DELETE' => 'DZĒST',
    'LBL_ACTION_LINK' => 'SAITE',
    'LBL_ACTION_UNLINK' => 'NOŅEMT SAITI',
    'LBL_ACTION_FAVORITE' => 'IZLASE',
    'LBL_ACTION_FOLLOW' => 'SEKOT',
    'LBL_ACTION_CREATE_EXPLANATION' => 'Izveidots {{module}} &#39;{{name}}&#39;',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'Atjaunināts {{module}} &#39;{{name}}&#39;',
    'LBL_ACTION_DELETE_EXPLANATION' => 'Dzēsts {{module}} &#39;{{name}}&#39;',
    'LBL_ACTION_LINK_EXPLANATION' => 'Piesaistīts {{module}} &#39;{{name}}&#39; pie {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'Atvienots {{module}} &#39;{{name}}&#39; no {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'Followed {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'Unfollowed {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'Favorited {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'Unfavorited {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'Created {{module}} &#39;{{name}}&#39; related to {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'Primārs',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'Opt-out',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'Pieteikties',
    'LBL_EMAIL_ACTION_SET_VALID' => 'Derīgs',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'Nederīgs',
    'LBL_ROLLBACK_BUTTON' => 'Atgriezt atpakaļ',
    'LBL_TX_LOG' => 'Transakciju žurnāls',
    'LBL_TX_LOG_DETAIL' => 'Transakcijas detaļas',
    'LBL_RECORD_DELETED' => '(Ieraksts dzēsts)',
    'LBL_NOT_AVAILABLE' => 'N/A',
    'LBL_FILE_SIZE' => 'Faila izmērs',
    'LBL_FILE_SIZE_UNITS_B' => 'Baiti',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'Izvēlieties ierakstus',
    'LBL_OFFLINE_DB_SIZE' => 'Datubāzes izmērs',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'Ierakstu skaits modulī',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'Kopējais ierakstu skaits',
    'LBL_RECORD_NOT_FOUND' => 'Ieraksts nav atrasts.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'Saistītais ieraksts nav atrasts',
    'LBL_NOT_AUTHORIZED' => 'Jums nav tiesību aplūkot šo ierakstu',
    'LBL_MOBILE_PROCESSING_FILE' => 'Sagatavo failu...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'Trešo pušu programmatūra',
    'LNK_TERMS_OF_USE' => 'Lietošanas noteikumi',
    'LNK_PRIVACY_POLICY' => 'Privātuma politika',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'Vienotā pierakstīšanās',
    'LBL_RECENTS' => 'Jaunākie',
    'LBL_SHOWING_CACHED_DATA' => 'Nevar sasniegt serveri. Rāda jaunākos pieejamos datus ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'Aizvērt {{moduleSingular}} un saglabāt',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'Īpašs informācijas panelis',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Specifisks modulis',
    'LBL_MOBILE_DEFAULT_VIEW' => 'Sākuma ekrāns',
    'LBL_MOBILE_DEFAULT_MODULE' => 'Izvēlētais modulis',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'Izvēlētais informācijas panelis',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'Izvēlētais informācijas lauks',
    'LBL_ALL_DASHLETS' => 'Visi informācijas lauki',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'Globālā meklēšana',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Ievadiet @, lai pieminētu lietotāju. Ievadiet #, lai atsauktos uz ierakstu.',
    'LBL_MOBILE_NEW_COMMENT' => 'Jauns komentārs',
    'LBL_RECENTLY_VIEWED' => 'Pēdējā apskate',
    'LBL_FILE_STORED_LOCALLY' => 'Fails ir saglabāts vietējā krātuvē, un tas tiks sinhronizēts, tiklīdz ierīce būs tiešsaistē.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'Ja vēlaties mainīt kādus nerediģējamus laukus, sazinieties ar administratoru, lai informētu par šīm izmaiņām.',
    'LBL_ACTIVITY_POST' => '{{{value}}}saitē {{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'Nav komentāru',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'Parādīt nākamos {{{commentsLeft}}} komentārus',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'Savērst',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'Apstiprināt komentāra izveidi',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'Komentāru žurnāls nevar būt tukšs',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'Lejupielādēt {{{pdfTemplateName}}} PDF',

    'ERR_SYNC_FAILED' => 'Nevar sinhronizēties ar serveri.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'Pieeja nav autorizēta',
    'ERR_MOBILE_INVALID_CREDS' => 'Nederīgs lietotājvārds vai parole',
    'ERR_MOBILE_SESSION_EXPIRED' => 'Jūsu sesijai beidzies derīguma laiks',
    'ERR_MOBILE_NOT_FOUND' => 'Resurss nav atrasts',
    'ERR_MOBILE_TIMEOUT' => 'Serveris neatbild',
    'ERR_MOBILE_CONNECTION_FAILED' => 'Nevar sasniegt serveri',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'Nav interneta pieslēguma',
    'ERR_MOBILE_INTERNAL' => 'Iekšēja kļūda ({{{code}}}). Mēģiniet vēlāk vēlreiz.',
    'ERR_MOBILE_VALIDATION' => 'Nederīgs ieraksts',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'Nesaderīgs servera veids: {{{flavor}}}',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'Nesaderīga servera versijaa: {{{version}}}',
    'ERR_MOBILE_EMAIL' => 'Kļūda. Nederīga e-pasta adrese.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'Šo dokumenta veidu neatbalsta.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'Autentificēšanās kļūda.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'Pieprasītais resurs nav atrasts.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'Iekšēja servera kļūda.',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'Aizliegts.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'Serviss nav pieejams',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'Notika negaidīta kļūda.',
    'ERR_MOBILE_UPLOAD' => 'Kļūda faila augšupielādes laikā',
    'ERR_MOBILE_FILE_PROCESSING' => 'Faila apstrādes kļūda',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'Iekārtas glabātuve nav pieejama',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'Jūsu programma ir novecojusi un vairs nav saderīga ar SugarCRM instanci, kurai jūs pieslēdzaties. Vai vēlaties lejupielādēt jaunu programmas versiju no App Store?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'Servera konfigurācija ir mainījusies, un ir nepieciešams pārlādēt. Vai turpināt?',
    'ERR_MOBILE_CONFLICT' => 'Kāds ir rediģējis to pašu ierakstu serverī. Apstipriniet, lai automātiski sapludinātu izmaiņas, vai noraidiet, lai tās atceltu.',
    'ERR_MOBILE_METADATA_CHANGED' => 'Servera konfigurācija ir izmainīta.',
    'ERR_MOBILE_FILE_READ' => 'Kļūda nolasot failu',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'Fails nav atrasts',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'Fails nav nolasāms',
    'ERR_MOBILE_FILE_ABORTED' => 'Lasīšanas operacīja tika pārtraukta',
    'ERR_MOBILE_FILE_SECURITY' => 'Fails ir bloķēts',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'Mobilā versija neatbalsta šo funkcionalitāti. Vai vēlaties atvērt desktop versiju?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'Fails ir pārāk liels. Maksimālais atļautais izmērs ir {{size}}',
    'ERR_OFFLINE' => 'Bezsaistes kļūda',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'Neizdevās atvērt lokālo atmiņu',
    'ERR_OFFLINE_STORAGE_CREATE' => 'Neizdevās izveidot lokālo atmiņu',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'Failed to create local storage: you&#39;ve run out of space.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'You&#39;ve run out of space for local storage.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'Datu bāzes tīrīšana neizdevās',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'Jums vairs nav vietas bezsaistes krātuvei. Ieteicams iztīrīt krātuvi. Tas var aizņemt vairākas minūtes.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'Neizdevās priekšienest ierakstus no servera',
    'ERR_OFFLINE_SYNC_ERROR' => 'Sinhronizācijas kļūda',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'Sinhronizācijas konflikts',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'Neizdevās iegūt servera laiku',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'Neizdevās iespējot bezsaistes režīmu. Nevar sasniegt serveri.',
    'LBL_EXPORT_CSV' => 'Eksportēt CSV',
    'LBL_ERR_EXPORTING_CSV' => 'Eksportēšana neizdevās',
    'LBL_ERR_EXPORT_ALL' => 'Neizdevās ienest atlasīto ierakstu datus. Mēģiniet vēlreiz',
    'LBL_LIST_SETTINGS_RESTORE' => 'Atjaunot noklusējuma iestatījumus',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'Atjaunot laukus?',
    'LBL_LIST_SETTINGS_TITLE' => 'Sarakstu skata veidotājs',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'Pieejamie lauki',
    'LBL_LIST_SETTINGS_REMOVE' => 'Noņemt',
    'LBL_LIST_SETTINGS_TEXT' => 'Velciet laukus saraksta skata veidotājā un pārkārtojiet tos, lai izveidotu {{moduleName}} saraksta skatu.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'Izkārtojumam ir jāpievieno vismaz viens lauks.',
    'LBL_LIST_SETTINGS_EMPTY' => 'Nav pieejamu lauku',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'Nav atrasts neviens atbilstošs lauks',
    'LBL_LIST_FILTER' => 'Lauka meklēšana',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'E-pasta klients',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'Ārējs E-pasta klients',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar E-pasta klients',
    'LBL_OFFLINE_CAPABILITIES' => 'Iespējot bezsaistes iespējas',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'Transakcijas dzēšana neizdevās.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'Transakcija izdzēsta.',
    'LBL_SECURE_MODE' => 'Uzlabots drošības režīms',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'Iespējojiet šo iestatījumu, lai paslēptu Sugar Mobile saturu, kad lietotne darbojas fonā, un jebkurā laikā neļautu lietotnes ekrānuzņēmumus.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'Iespējot šo iestatījumu, lai paslēptu Sugar Mobile saturu, kad lietotne darbojas fonā.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'Režīms vienmēr bezsaistē',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'Jūs strādājat režīmā Vienmēr bezsaistē. Vai vēlaties atkārtoti izveidot savienojumu?',
    'LBL_RECONNECT' => 'Atkārtoti izveidot savienojumu',
    'LBL_STAY_OFFLINE' => 'Palikt bezsaistē',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'Modulis, kuram mēģināt piekļūt, Sugar Mobile nav pieejams.',
    'LBL_MOBILE_RELEASE_NOTE' => 'Sugar Mobile platformas {{platform}} izlaiduma piezīmēm',
    'LBL_MOBILE_USER_GUIDE' => 'Sugar Mobile platformas {{platform}} lietotāja pamācībai',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'ar šiem vārdiem',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'izņemot šos vārdus',
    'LBL_NOTIFICATIONS_CHANNEL' => 'Atjauninājumi',
    'LBL_APPLY_BUTTON_LABEL' => 'Pielietot',
    'LBL_ACTION_CREATE_FAILURE' => "Neizdevās saglabāt ierakstu:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "Neizdevās atjaunināt ierakstu:\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'Neizdevās atrisināt lauku kalkulācijas serverī.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'Tālāk norādītie lauki ir nederīgi: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>Izdevās.</b> Jūs veiksmīgi izveidojāt {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}".</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>Izdevās.</b> Jūs veiksmīgi atjauninājāt ierakstu',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'Neizdevās iegūt e-pasta datus no servera.',
    'LBL_ASSIGN_SUCCESS' => '<b>Izdevās.</b> Ieraksts ir piešķirts {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'Saglabāt e-pastu kā uzmetumu?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'Saglabāt kā uzmetumu',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'Atmest e-pastu',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'Ja nesaglabāsiet melnrakstu, jūs zaudēsiet šo e-pastu.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'Atlasīt parakstu',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'Atlasīt e-pasta veidni',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'Veidne pārrakstīs visu šajā e-pasta ziņojumā esošo saturu. Vai tiešām vēlaties izmantot šo veidni un pārrakstīt saturu?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'Rakstīt e-pastu',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'Jūsu e-pastā ir ietverti mainīgie, kas tiks aizstāti, izmantojot vērtības no ieraksta Saistīts ar. Pirms nosūtīšanas, pārbaudiet, vai lauks Saistīts ir iestatīts pareizi.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'Nav atrasts neviens izejošā e-pasta konts. Sazinieties ar savu Sugar administratoru.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' un vēl {{{count}}}',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'Pievienot e-pastu',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'Ierakstiet kontaktpersonas vārdu vai e-pasta adresi',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (Jauns e-pasts)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'Mainīgie',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'E-pasta veidnes',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'Kampaņas veidnes',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'Darba plūsmas veidnes',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'Sistēmas veidnes',
    'LBL_FILTER_EDIT' => 'Rediģēt filtru',
    'LBL_FILTER_MY_FILTER' => 'Mans filtrs',
    'LBL_FILTER_MY_FILTER_BY' => 'Mans filtrs pēc {{{filters}}}',
    'LBL_FILTER_SAVE' => 'Saglabāt filtru',
    'LBL_SELECT_PARAM' => 'Atlasīt',
    'LBL_SELECT_MODULES' => 'Moduļa selektors',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'Atlasīt papildu parametru',
    'LBL_FILTER_TEMPORARY' => 'Pagaidu filtrs',
    'LBL_ERROR_FILE_UPLOAD' => 'Neizdevās augšupielādēt {{{fieldLabel}}} failu "{{{fileName}}}". {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">Skatīt neizdevušos ierakstu</a>',
    'LBL_FILE_UPLOAD_ONE' => 'Saglabā failu...',
    'LBL_FILE_UPLOAD_MANY' => 'Saglabā failu {{{index}}} no {{{total}}}...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'Paziņojumu iestatījumi',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'Pārvaldīt jūsu pašpiegādes paziņojumus',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "Pārvaldiet paziņojumu rādīšanu, izmantojot ierīces paziņojumu iestatījumus.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'Piešķīrumi',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'Saņemt paziņojumus, kad jums tiek piešķirti ieraksti.',
    'LBL_NOTIFICATION_MENTIONS' => 'Pieminējumi',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'Saņemt paziņojumus, kad esat pieminēts komentāru žurnāla ierakstos.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'Administrators šim izkārtojumam nav pievienojis komentāru žurnāla lauku. Sazinieties ar savu Sugar administratoru.',
    'ERR_NO_PERMISSION_TITLE' => 'Atļaut piekļuvi',
    'ERR_NO_CAMERA_PERMISSION_MSG' => 'Lai jūs varētu pievienot fotoattēlus, {{{brandName}}} ir nepieciešama piekļuve kamerai. Sistēmas iestatījumos atļaujiet piekļuvi kamerai.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'Iestatījumi',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'Ilgums',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'Atlikušais laiks',
    'LBL_LIST_SUPPORT_EXPIRES' => 'Termiņš beidzas',
    'LBL_CASCADE_RLI_EDIT' => 'Atjauniniet atvērtos ieņēmumu posteņus',
    'LBL_MOBILE_CALENDAR' => 'Kalendārs',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'Kalendāra iestatījumi',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'Nedēļas sākuma diena',
    'LBL_MOBILE_CALENDAR_MODULES' => 'Parādāmie notikumi',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}h:{{{minutes}}} min.',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} st.',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} min.',
    'LBL_MOBILE_CALENDAR_TODAY' => 'Šodien',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => 'Pievienot {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'Ieplānot aktivitāti',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'Iespējojiet vismaz vienu notikuma veidu.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'Visa diena',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'Neizdevās ielādēt kalendārus.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'Šī darbība nav pieejama Sugar Mobile. Vai tā vietā vēlaties atvērt darbvirsmas lietotni?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'Atlasīt veidni',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'Sapludināt',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'Kļūda: nav EXIF datu no HEIC faila',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'Kļūda: Attēla izšķirtspēja pārāk augsta',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'Kļūda: Nevar apstrādāt attēlu',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'Kļūda: Neizdevās atveidot attēlu uz audekla',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'Kļūda: Neizdevās ielādēt failu kā attēlu',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1 vienums atlasīts',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} vienumi atlasīti',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'Atlasīt visu',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'Šajā skatā atlasījāt {{{count}}} ierakstus. Vai atlasīt visus ierakstus?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'Atlasīt {{{count}}} ierakstus',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'Vai tiešām vēlaties dzēst atlasīto(s) ierakstu(s)?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'Dzēš… {{{count}}} no {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'Atlasītajos ierakstos nav atrasts neviens derīgs e-pasts',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'Izskats',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'Izmantot sistēmas iestatījumus',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'Gaišs',
    'LBL_MOBILE_APP_THEME_DARK' => 'Tumšs',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'Jauns faila nosaukums',
    'LBL_ATTACHMENT_RENAME_MSG' => 'Pārdēvēt failu',
    // Filters related
    'LBL_CREATED_BY_ME' => 'Izveidoju es',
    'LBL_OPERATOR_ONE_OF' => 'ir viens no',
    'LBL_OPERATOR_NOT_ONE_OF' => 'nav viens no',
    'LBL_OPERATOR_CONTAINS' => 'ir viens no',
    'LBL_OPERATOR_CONTAINS_WORD' => 'satur',
    'LBL_OPERATOR_NOT_CONTAINS' => 'nav viens no',
    'LBL_OPERATOR_EMPTY' => 'ir tukšs',
    'LBL_OPERATOR_NOT_EMPTY' => 'nav tukšs',
    'LBL_OPERATOR_MATCHES' => 'tieši sakrīt',
    'LBL_OPERATOR_STARTS_WITH' => 'sākas ar',
    'LBL_OPERATOR_EQUALS' => 'ir vienāds ar',
    'LBL_OPERATOR_NOT_EQUALS' => 'nav vienāds ar',
    'LBL_OPERATOR_GREATER_THAN' => 'ir lielāks par',
    'LBL_OPERATOR_LESS_THAN' => 'ir mazāk par',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'ir lielāks vai vienāds ar',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'ir mazāks vai vienāds ar',
    'LBL_OPERATOR_BETWEEN' => 'ir starp',
    'LBL_OPERATOR_BEFORE' => 'pirms',
    'LBL_OPERATOR_AFTER' => 'pēc',
    'LBL_OPERATOR_YESTERDAY' => 'vakar',
    'LBL_OPERATOR_TODAY' => 'šodien',
    'LBL_OPERATOR_TOMORROW' => 'rīt',
    'LBL_OPERATOR_LAST_7_DAYS' => 'pēdējās 7 dienas',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'nākamās 7 dienas',
    'LBL_OPERATOR_LAST_30_DAYS' => 'pēdējās 30 dienas',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'nākamās 30 dienas',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'Vairāk nekā pirms __ dienām',
    'LBL_OPERATOR_LAST_X_DAYS' => 'Pēdējās __ dienas',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'Nākamās __ dienas',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'Vairāk nekā __ dienas nākotnē',
    'LBL_OPERATOR_LAST_MONTH' => 'pagājušais mēnesis',
    'LBL_OPERATOR_THIS_MONTH' => 'šomēnes',
    'LBL_OPERATOR_NEXT_MONTH' => 'nākamajā mēnesī',
    'LBL_OPERATOR_LAST_YEAR' => 'pagājušais gads',
    'LBL_OPERATOR_THIS_YEAR' => 'šis gads',
    'LBL_OPERATOR_NEXT_YEAR' => 'nākamais gads',
    'LBL_OPERATOR_IS' => 'ir',
    'LBL_OPERATOR_IS_NOT' => 'nav',
    'LBL_OPERATOR_AFTER_TODAY' => 'pēc šodienas',
    'LBL_OPERATOR_BEFORE_TODAY' => 'pirms šodienas',
    'LBL_ERROR_FILTER_EMPTY' => 'Pievienojiet filtra kritērijus.',
    'LBL_ADD_FILTER' => 'Pievienot kritēriju',
    'LBL_FILTER_NAME' => 'Filtra nosaukums',
    'LBL_FILTER_FIELD' => 'Lauks',
    'LBL_FILTER_OPERATOR' => 'Operators',
    'LBL_FILTER_VALUE' => 'Vērtība',
    'LBL_FILTER_SYNC_TO_SERVER' => 'Saglabāt darbvirsmas lietotnē',
    'LBL_FILTER_LOCAL' => 'Lokālais filtrs',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'Sveicam SugarCRM.<br/><br/> Ļaujiet parādīt dažas jaunas iespējas ...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'Galvenās izvēlnes navigācija.',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'Sarakstos pieejamās darbības.',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'Ierakstu globālā meklēšana.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'Saraksta filtrs lai rādītu favorītos ierakstus.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'Saraksta filtrs lai rādītu man piešķirtos ierakstus.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'Atzīmē ierakstu kā favorītu',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'Mani gaidāmie notikumi sākot no šodienas.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'Visnesenāk modificētie ieraksti.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'Ierakstam pieejamās darbības',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'Izbaudiet visas jaunās iespējas!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'Šī ir plus izvēlne.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'Aizvērt plus izvēlni.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'Norādiet konkrētu darbību sarakstam ko izpildīt.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'Šī ir pamata izvēlne.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'Aizvērt pamata izvēlni.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'Skatīt konkrētu moduli.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'Pielāgot aplikāciju.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'Atvērt Sugar interneta pārlūkā.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'Skatīt savu profilu.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'Šī ir detalizētas informācijas lapa.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'Vissvarīgākā informācija par ierakstu.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'Skatīt papildus informāciju vai rediģēt ierakstu.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'Ierakstam pieejamās darbības',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'Iet uz iepriekšējo lapu.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'Piekļūstiet iepazīšanās tūrei jebkurā laikā.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'Atpakaļ.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'Spiediet lai atvērtu saistīto ierakstu.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'Sekot/Nesekot ierakstam.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'Spiediet lai atvērtu papildus informāciju.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'Galvenās izvēlnes skats.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'Galvenā izvēlne atveras ekrāna kreisajā pusē.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'Detalizēts skatījums',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'Detaļu skatā atver labajā ekrāna pusē.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'Izmantojiet šīs bultiņas, lai ātri apskatītu izvēlnes galvenās sastāvdaļas.',

    'LBL_COMMENT_ADD' => 'Pievienot komentāru',
    'LBL_REQUIRED' => 'Obligāts',
    'LBL_MORE_BUTTON' => 'Vairāk',
    'LBL_NO_OPTIONS' => 'Opcijas nav pieejamas',
    'LBL_TRY_AGAIN' => 'Mēģināt vēlreiz',
    'LBL_NEW_RECORDS' => 'Nesen izveidots',
    'LBL_ASSIGNED_TO_ME' => 'Mans {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'Visi {{{module}}}',
    'LBL_UNFAVORITE' => 'Nevēlams',
    'LBL_ACTIVITY_CREATE' => 'Izveidots {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => 'Atjaunināts {{{changes}}} uz {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => 'Saistīts {{{relatedRecord}}} ar {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => 'Atsaistīts {{{relatedRecord}}} no {{{record}}} {{{module}}}',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} priekš {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'Lejupielādēt saistītos ierakstus...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'Jūsu informācijas paneļa konfigurācija ir mainīta. Vai vēlaties pārlādēt?',
    'LBL_RECORDS' => 'Ieraksti',
    'LBL_DASHBOARDS' => 'Informācijas paneļi',
    'LBL_TEMPLATES' => 'Veidnes',
    'LBL_NON_TEMPLATES' => 'Nav veidnes',
    'LBL_IS_TEMPLATE' => 'Ir veidne',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'Jūsu atlasē ir instrumentu paneļa veidnes, kuras nevar masveidā atjaunināt. Lūdzu, noņemiet atlasi veidnēm, lai turpinātu.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'Jūsu atlasē ir instrumentu paneļa veidnes, kuras nevar masveidā izdzēst. Lūdzu, noņemiet atlasi veidnēm, lai turpinātu.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'Meklēt {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'Galvenā izvēlne',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'Ātri izveidot jaunu ierakstu',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'Velciet, lai redzētu papildu iespējas',
    'LBL_DETAILS' => 'Papildinformācija',
    'LBL_DETAIL_RELATED' => 'Saistītais',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'Šim {{module}} nepieciešams {{relatedModule}}. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>Izveidot {{relatedModule}} ierakstu</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'Rediģēt ierakstu',
    'LBL_OFFLINE_MENU_SETTINGS' => 'Bezsaistes iestatījumi',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'Atkļūdošanas iestatījumi',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'Kopā ieraksti',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'Pēdējā lejupielāde',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'Šo failu nevar lejupielādēt.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'Neizdevās no servera lejupielādēt informācijas paneļus',
    'ERR_FILTERS_FETCHING' => 'Nevar ienest jūsu filtrus',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'Neizdevās nošifrēt lokālo atmiņu',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'Bezsaistes datu šifrēšana. Tas var aizņemt vairākas minūtes.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'Bezsaistes datu šifrēšana pabeigta.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'Jums nav piekļuves {{{module}}} modulim.',
    'LBL_SKIP' => 'Izlaist',
    'LBL_CONTINUE' => 'Turpināt',
    'LBL_ENABLE' => 'Iespējot',
    'LBL_MOBILE_TRIAL_UNTIL' => 'Izmēģinājumversija līdz',
    'LBL_MOBILE_SDK_VERSION' => 'SDK versija',
    'LBL_LOG_LEVEL' => 'Reģistrācijas līmenis',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'Pieteikšanās iestatījumi ir pārkonfigurēti.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'Jūsu bezmaksas izmēģinājuma periods ir beidzies.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'Serveris neatbalsta drošu savienojumu. Lūdzu, izslēdziet drošu savienojumu.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'Serveris atbalsta drošu savienojumu. Lūdzu, ieslēdziet drošu savienojumu.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'Jūsu savienojums nav drošs. Sazinieties ar administratoru.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'Pieteikšanās iestatījumi',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'Iestatīt {{{brandName}}} instanci',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'Lai lietotne darbotos, ir jāievada {{{brandName}}} instances URL. Ja jums nav instances URL, lūdzu, sazinieties ar administratoru.',
    'LBL_FACEID' => 'Sejas ID',
    'LBL_TOUCHID' => 'Pirksta nospieduma ID',
    'LBL_ENABLE_TOUCHID' => 'Iespējot {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => 'Uzstādīt {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'Pieteikties, izmantojot savu pirkstu',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} nav uzstādīts jūsu ierīcē. \n\nDodieties uz savas ierīces iestatījumiem, lai uzstādītu {{{biometryType}}}. Kad tas ir izdarīts, iespējojiet {{{brandName}}} {{{biometryType}}} sadaļā Galvenā izvēlne > Iestatījumi.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'Izmantojot {{{biometryType}}} ar {{{brandName}}}, jūs varat izmantot savu biometrisko identifikatoru, tā vietā lai ievadītu paroli piekļuvei {{{brandName}}}.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'Vai vēlaties turpināt ar {{{biometryType}}}?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'Ievadiet {{{brandName}}} paroli, lai iespējotu {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'Iestatīšana',
    'LBL_MDM_CONFIRM_CHANGE' => 'Lietotnes konfigurācija ir izmainīta no mobilo ierīču pārvaldnieka. Lai saglabātu izmaiņas, lūdzu, piesakieties vēlreiz.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'Lūdzu, sniedziet {{{brandName}}} piekļuvi jūsu atrašanās vietai, izmantojot jūsu iestatījumus.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'Pašreizējā atrašanās vieta nav pieejama',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "Pašreizējās atrašanās vietas izgūšanai iestājies noilgums. \nLūdzu, mēģiniet vēlreiz.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'Atrašanās vietas atzīmes nav pieejamas',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'Atrašanās vietas koordinātas ir nederīgas',
    'ERR_MOBILE_INVALID_PASSWORD' => 'Nederīga parole.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'Jūsu lietotne ir novecojusi un vairs nav saderīga ar {{{brandName}}} instanci, kurai esiet pieslēdzies. Vai vēlaties to atjaunināt?',
    'LBL_MOBILE_BY' => 'Ar',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'Šis filtrs tiešsaistē nav pieejams',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'Bezsaistes ieraksti',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'Lejupielādes iestatījumi',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'Lejupielādējiet savus piešķirtos, izlasē ietvertos un sekotos ierakstus bezsaistes piekļuvei. Savas preferences varat atjaunināt bezsaistes iestatījumos.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'Jūsu ierakstu lejupielāde ir pabeigta. Tagad varat tiem piekļūt bezsaistes režīmā.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "Netika lejupielādēti visi jūsu ieraksti.\n Vai vēlaties mēģināt vēlreiz?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'Izmantot mobilos datus',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'Ne tagad',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'Lejupielāde ir apturēta, un tā atsāksies, vēlreiz atverot lietotni.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'Lejupielādē {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'Atjaunināt jaunākos ierakstus',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'Gaida savienojuma izveidošanu',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'Apturēts',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'Apturēšana',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'Lejupielāde',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'Pauze',
    'LBL_BULK_LOAD_BTN_RESUME' => 'Atsākt',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'Tikai Wi--Fi savienojums tiek izmantots pēc noklusējuma',
    'LBL_NPS_RATING_MSG' => "Kā jūs vērtētu savu \n{{{productName}}} pieredzi?",
    'LBL_NPS_THANKS_MSG' => 'Pateicamies par atsauksmēm!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'Varbūt jūs varētu to novērtēt lietotnē App Store?',
    'LBL_NPS_NO_THANKS' => 'Nē, paldies',
    'LBL_NPS_NOT_NOW' => 'Ne tagad',
    'LBL_NPS_RATE_NOW' => 'Vērtēt tagad',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'Tīkls nav pieejams. Šo lietotni joprojām varat lietot bezsaistē',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'Veiktās izmaiņas tiks saglabātas, kad būsiet tiešsaistē. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>Skatiet papildinformāciju</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'Ir nesaglabāti dati. Lūdzu, pārbaudiet <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>transakciju žurnālu</a>',
    'LBL_CONVERT' => 'Konvertēt',
    'LBL_CONVERT_LEAD' => 'Konvertēt interesentu',
    'LBL_SEARCH_EXISTING_RECORD' => 'Meklēt esošo {{{this}}}',
    'LBL_DUPLICATES_CHECK_FAILED' => 'Dublikātu pārbaude neizdevās',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'Vai vēlaties pārvietot saistītās aktivitātes uz kontaktpersonu ierakstu?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'Jūs veiksmīgi konvertējāt interesentu {{{name}}}',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'Dublikāti nav atrasti.',
    'ERR_LEAD_CONVERSION_FAIL' => 'Interesenta konvertēšana neizdevās',
    'LBL_SELECT_DUPLICATE_RECORD' => 'Atlasīt no dublikāta {{{modulePlural}}}',
    'LBL_SELECTED_EXISTING_RECORD' => 'Atlasīts {{{moduleSingular}}}',
    'LBL_CREATED_NEW_RECORD' => 'Izveidots jauns {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => 'Poga Atpakaļ',
    'LBL_VO_HOME_BTN' => 'Poga Sākums',
    'LBL_VO_DASHBOARD_BTN' => 'Poga Informācijas panelis',
    'LBL_VO_SEARCH_BTN' => 'Poga Meklēt',
    'LBL_VO_RIGHT_MENU_BTN' => 'Labā izvēlnes poga',
    'LBL_VO_ADD_BTN' => 'Pievienot pogu',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'Atlaide',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'Atlasiet kartēšanas lietotni',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'Atlasītajam {{entityName}} ir saistītās vērtības: {{localizedFieldNames}}. Atceliet, lai saglabātu esošās vērtības. Apstipriniet, lai pārrakstītu ar jaunajām vērtībām.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'Datu šifrēšana ir iespējota.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'Atlasītais interesents jau ir konvertēts.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'Šī darbība ir pieejama tikai tad, kad ierīce ir tiešsaistē',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'Vai jūs vēlaties izveidot darījumu no piedāvājuma?',
    'LBL_TAG_ADD' => 'Pievienot birku',
    'LBL_TAG_ENTER_TAG_NAME' => 'Ievadiet birku',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'Filtrēšana pēc birkām netiek atbalstīta, kamēr ierīce ir bezsaistē.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'Parādīt visu komentāru',
    'LBL_COMMENT_VIEW' => 'Skatīt komentāru',
    'LBL_PMSE_LABEL_DUEDATE' => 'Izpildes datums',
    'LBL_PMSE_DUE' => 'Līdz',
    'LBL_PMSE_DUE_ON' => 'Izpildīt līdz',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'Vispirms izveidojiet {{conversionParentModuleName}}',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'Trūkst obligāto ierakstu: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'Izvēlieties attēla kvalitāti. Pirms saglabāšanas serverī attēla izmērs tiks attiecīgi mainīts. Atlasītā vērtība tiks izmantota kā noklusējums visām līdzīgām darbībām nākotnē.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'Novērtē faila izmēru...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'Faila aptuvenais izmērs ir',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'Attēla kvalitāte',
    'LBL_IMAGE_QUALITY_BEST' => 'Oriģinālais izmērs',
    'LBL_IMAGE_QUALITY_GOOD' => 'Laba kvalitāte',
    'LBL_IMAGE_QUALITY_POOR' => 'Mazs izmērs',
    'LBL_IMAGE_QUALITY_BTN' => 'Saspiešana: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'Uzskaitīt laukus modulī {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'Atiestatīt uz noklusējuma iestatījumiem',
    'LBL_LIST_NOT_ENOUGH' => 'Iestatiet vismaz 1 aktīvo lauku.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'Jums ir jāpierakstās un jāpieņem atļaujas, lai varētu strādāt ar SugarCRM instanci.',
    'LBL_SELECTING_EXISTING_RECORD' => 'Atlasa moduli {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'Izveido jaunu moduli {{{moduleSingular}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'Attēla izmērs',
    'LBL_COPY_ADDRESS' => 'Kopēt adresi',
    'LBL_OPEN_IN' => 'Atvērt',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'Faili nav atlasīti.',
    'LBL_ATTACHMENT_ADD' => 'Pievienot',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'Šī lietotne izmanto sīkdatnes',
    'LBL_USE_COOKIES_CONFIRM' => 'Šī lietotne izmanto sīkdatnes, lai palīdzētu nodrošināt jums labāku pieredzi. Turpinot jūs piekrītat sīkdatņu izmantošanai saskaņā ar mūsu privātuma politiku.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'Jūs izmantojat Sugar instanci, kas nebūs saderīga ar Sugar Mobile nākamo mobilo versiju. Palūdziet administratoram pēc iespējas ātrāk jaunināt Sugar.',
    'ERROR_TAG_NAME_INVALID' => 'Birkas nosaukums nevar saturēt "{{{forbiddenChars}}}" rakstzīmes',
    'ERROR_NO_TAGS_FOUND' => 'Nav pieejamas birkas, kas atbilst "{{{searchQuery}}}"',
    'ERR_PA_RECORD_INVALID' => 'Moduļa {{{moduleName}}} ierakstā ir viena vai vairākas nederīgas vērtības, un to nevar saglabāt. Vai vēlaties rediģēt ierakstu, lai varētu veikt {{{actionLabel}}} darbību?',
    'ERR_MOBILE_METADATA_RELOAD' => 'Administrators ir veicis konfigurācijas izmaiņas jūsu Sugar instancē. Piespiediet Labi, lai sinhronizētu lietotnes konfigurāciju ar serveri.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'Šī lietotne izmanto sīkdatnes',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'Atzīmējiet, lai piekristu (Obligāti)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'Šī lietotne izmanto sīkdatnes, lai palīdzētu nodrošināt jums labāku pieredzi. Turpinot jūs piekrītat sīkdatņu izmantošanai saskaņā ar mūsu <a href="{{href}}" target="_blank">privātuma politiku</a>.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'Ieraksta skatījums ļauj aplūkot detalizētu ieraksta informāciju.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Piezīmes ļauj sadarboties ar citiem portāla lietotājiem un atbalsta pārstāvjiem.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'Klikšķiniet šeit lai ierakstam pievienotu piezīmi.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'Klikšķini uz šīm ikonām lai aplūkotu pievienoto piezīmju detaļas.',

    //for portal
    'LBL_PORTAL_HOME' => 'Sāķuma instrumentu panelis',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'Visi atvērtie pieteikumi',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'Nesen atrisinātie pieteikumi',
    'LBL_PORTAL_SEARCH' => 'Meklēt pēc vārda, numura',
    'LBL_SIGNUP_BUTTON_LABEL' => 'Reģistrēties',
    'LBL_PORTAL_NO_EMAIL' => 'Vai nesaņēmāt e-pastu?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'Aizmirsāt paroli',
    'LBL_PORTAL_FORGOT_USERNAME' => 'Aizmirstāt lietotājvārdu',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'Ievadiet savu paroli divas reizes. Parolēm ir jāsakrīt.',
    'LBL_PORTAL_RESET_PASSWORD' => 'Atiestatīt paroli',
    'LBL_PORTAL_REENTER_PASSWORD' => 'Atkārtoti ievadīt paroli',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'Paroles nesakrīt, ievadiet vēlreiz',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'Jūsu parole ir veiksmīgi atiestatīta.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'Radusies kļūda. Iesniedziet jaunas paroles atiestatīšanas pieprasījumu.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'Reģistrēšanās',
    'LBL_PORTAL_SIGNUP_TITLE' => 'Paldies, ka reģistrējāties',
    'LBL_PORTAL_SIGNUP' => 'Mēs jūs informēsim pēc jūsu informācijas apstiprināšanas.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'Vārds',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'Uzvārds',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'Lietotājvārds',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'E-pasta adrese',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (neobligāts)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'Valsts',
    'LBL_PORTAL_SIGNUP_STATE' => 'Novads',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'Uzņēmuma nosaukums',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'Amats (neobligāts)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'Parole',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'Apstiprināt paroli',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'Aizmirsāt pieteikšanās informāciju',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'Aizmirsi paroli?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'Sazinieties ar savu Sugar administratoru, lai atiestatītu paroli.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'Lietotājvārds',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'Parole',
    'LBL_PORTAL_LOADING' => 'Ielāde',
    'LBL_PORTAL_SAVING' => 'Saglabā',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'Lapa nav pieejama',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "Piedodiet, bet šī iespēja pašlaik nav pieejama.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'Parādīt meklēšanu rezultātu "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'Vai nesaņēmāt e-pastu?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'Lai saņemtu palīdzību vai sazinātos ar mums, izmantojiet kādu no šiem variantiem: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'Tālrunis: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'E-pasts: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'Tīmekļa vietne: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'Vai tiešām vēlaties aizvērt tērzēšanu?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'Izveidot piezīmi vai pievienot pielikumu',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'Pievienot piezīmi',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'Jūsu pieteikšanās nebija veiksmīga. Mēģiniet vēlreiz.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'Nederīgi pieslēgšanās dati',
    'LBL_PORTAL_INVALID_GRANT' => 'Jūsu sesijai ir beidzies derīguma termiņš. Lūdzu piesakieties vēlreiz.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'Sesijai beidzies derīguma termiņš',
    'LBL_PORTAL_AUTH_FAILED' => 'Lietotāja autentifikācija neizdevās',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'Nederīgs klients',
    'LBL_PORTAL_INVALID_REQUEST' => 'Veiktais pieprasījums ir nederīga vai sabojāts. Lūdzu, sazinieties ar tehnisko atbalstu.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'Nederīgs pieprasījums',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'Pieprasījumam iestājies noilgums.',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'Pieprasījuma noildze',
    'LBL_PORTAL_UNAUTHORIZED' => 'Mēs atvainojamies, bet šķiet jums nav tiesību piekļūt šim resursam.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'HTTP Kļūda: Nav atļaujas',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'Resurss nav pieejams.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'HTTP Kļūda: Aizliegts',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'HTTP metode nav atļauta šim resursam. Lūdzu, sazinieties ar tehnisko atbalstu.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP kļūda: Metode nav atļauta',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'Pieprasījuma kļūda vai neesošs/nederīgs parametrs.  Lūdzu, sazinieties ar tehnisko atbalstu.',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'HTTP kļūda:',
    'LBL_PORTAL_MIN_MODULES' => 'Kā minimums ir jābūt aktivētam Pieprasījumu, Kļūdu vai Zināšanu bāzes modulim lai aktivētu šo aplikāciju.',
    'LBL_PORTAL_ERROR' => 'Kļūda',
    'LBL_PORTAL_ROUTE_ERROR' => 'Problēma ielādējot moduli. Mēģiniet vēlreiz vēlāk vai sazinieties ar tehnisko atbalstu.',
    'LBL_PORTAL_OFFLINE' => 'Piedodiet bet aplikācija pašlaik nav pieejama. Lūdzu sazinieties ar vietnes administratoru.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'Mainīt paroli',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'Lietotājvārds jau ir reģistrēts sistēmā. Pieprasiet aizmirsto paroli vai atlasiet citu lietotājvārdu.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'Norādītais e-pasts nav derīgs.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'Paroles neatbilst.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'Servisa konsole',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'Pārskats',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'Atjaunot noklusējuma informācijas paneli',
    'LBL_UNTITLED' => 'Bez nosaukuma',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'Atjaunojumu konsole',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'Apskats',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'Posms/Statuss',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'Nosaukums/Uzņēmuma nosaukums',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'Daudzkanālu instrumentu panelis',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'Klients',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} plkst. {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'Jūsu pārlūks nav atbalstīts SugarLive. Izmantojiet Google Chrome vai Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'Tika izveidots <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a>, kas satur informāciju no jūsu sarunas.',
    'LBL_OMNICHANNEL_SUBJECT' => 'Temats',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'Apraksts',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'Ziņojumu kopsavilkums',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'Zvana kopsavilkums',
    'LBL_OMNICHANNEL_LINK_TO' => 'Saite {{fromModule}} uz {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'Saite uz {{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'Piesaistīts',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'Jūsu pārlūks nav atbalstīts tērzēšanai. Izmantojiet Google Chrome vai Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Lai saņemtu palīdzību, sazinieties ar Sugar administratoru.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'Konfigurēt izkārtojumu',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'Pirms izejošā zvana veikšanas pabeidziet SugarLive konfigurēšanu.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'Pirms SugarLive atvēršanas pabeidziet SugarLive izkārtojuma konfigurēšanu.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'Pirms SugarLive SugarLive izkārtojuma konfigurēšanas iestatiet sev SugarLive stāvokli "Bezsaistē".',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'Kompakts skats',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'Pilns skats',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR instrumentu panelis',
    'LBL_SALES_MANAGER_CONSOLE' => 'Pārdošanas vadītāja instrumentu panelis',
    'LBL_SALES_REP_CONSOLE' => 'Pārdošanas pārstāvja instrumentu panelis',
    'LBL_MARKETING_CONSOLE' => 'Mārketinga instrumentu panelis',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'Klientu panākumu instrumentu panelis',
    'LBL_EXECUTIVE_CONSOLE' => 'Vadības instrumentu panelis',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'Atjaunot cilni pēc noklusējuma',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'Konfigurēt kopsavilkuma paneli',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'Lietotāja profils',
    'LBL_WIZ_COMPLETE_TITLE' => 'Iestatīšana pabeigta',
    'LBL_SETUP_COMPLETE_INFO' => 'Sākt lietot Sugar!',
    'LBL_SETUP_USER_INFO' => 'Iestatiet savu lietotāja informāciju',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'Lokalizācijas iestatījumi',
    'LBL_SETUP_USER_LOCALE_INFO' => 'Iestatiet laika zonu, datumu un vārda formātu',
    'LBL_WIZ_START_SUGAR' => 'Sākt Sugar',
    'LBL_WIZ_FIRST_NAME' => 'Vārds',
    'LBL_WIZ_LAST_NAME' => 'Uzvārds',
    'LBL_WIZ_EMAIL' => 'E-pasts',
    'LBL_WIZ_TIMEZONE' => 'Laika zona',
    'LBL_WIZ_TIMEFORMAT' => 'Laika formāts',
    'LBL_WIZ_DATE_FORMAT' => 'Datuma formāts',
    'LBL_WIZ_NAME_FORMAT' => 'Vārda attēlošanas formāts',
    'LBL_SETUP_PROGRESS' => 'Iestatīšanas progress',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar apmācības',
    'LBL_WIZ_DOCUMENTATION' => 'Dokumentācija',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'Zināšanu bāze',
    'LBL_WIZ_FORUMS' => 'Forums',
    'TPL_TIMEZONE_DIFFERENT' => 'Jūsu pārlūka laika zona nesakrīt ar jūsu saglabāto laika zonu {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'Pielāgojiet savu laika zonu.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'Lokalizācijas iestatījumi',
    'LBL_WIZ_EMAIL_SETTINGS' => 'E-pasta iestatījumi',
    'LBL_WIZ_IMPORT_DATA' => 'Importēt datus',
    'LBL_WIZ_CREATE_USERS' => 'Veidot lietotājus',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'Sistēmas iestatījumi',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Studio',

    'LBL_CSP_ERROR_MESSAGE' => 'Jūsu ievadītā vērtība(s) nav atbalstīta vai neatbilst pieļaujamajam formātam. Sarakstu ar lauka pieļaujamajām vērtībām un formātiem skatiet <a href="{{linkToDocumentation}}" target="_blank">System</a> dokumentāciju.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'Šis saturs nav apstiprināts. Atjauniniet savas sistēmas <a href="{{linkToDocumentation}}" target="_blank">Satura drošības politikas iestatījumus</a>.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'Šis saturs nav apstiprināts. Palūdziet administratoram atjaunināt jūsu sistēmas <a href="{{linkToDocumentation}}" target="_blank">Satura drošības politikas iestatījumus</a>. Pēc iestatījumu atjaunināšanas jums būs jāatsvaidzina pārlūkprogramma, lai izmaiņas stātos spēkā.',

    // For password related labels
    'LBL_PASSWORD' => 'Parole',
    'LBL_CHANGE_YOUR_PASSWORD' => 'Nomainiet paroli',
    'LBL_PASSWORD_REQUIREMENTS' => 'Paroles prasības',
    'LBL_CURRENT_PASSWORD' => 'Pašreizējā parole',
    'LBL_NEW_PASSWORD1' => 'Jauna parole',
    'LBL_NEW_PASSWORD2' => 'Apstiprināt paroli',
    'LBL_PASSWORD_CHANGED' => 'Jūs veiksmīgi nomainījāt paroli',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'Ievadiet paroles apstiprinājumu.',
    'ERR_ENTER_NEW_PASSWORD' => 'Ievadiet jauno paroli.',
    'ERR_ENTER_OLD_PASSWORD' => 'Ievadiet veco paroli.',
    'ERR_REENTER_PASSWORDS' => 'Parolēm ir jāsakrīt.',
    'ERR_PASSWORD_MISMATCH' => 'Ievadītā parole neatbilst sistēmā sagabātajai',
    'LBL_CANNOT_SEND_PASSWORD' => 'Nevar nosūtīt paroli',
    'LBL_REQUEST_PASSWORD' => 'Pieprasīt paroli',
    'LBL_RESET_PASSWORD' => 'Atiestatīt paroli',
    'LBL_RESET_PASSWORD_MESSAGE' => 'Ievadiet savu lietotājvārdu, un mēs nosūtīsim jums saiti paroles atiestatīšanai.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Pārbaudiet savu e-pastu <br><br> Mēs nosūtījām norādījumus par paroles atiestatīšanu uz e-pasta adresi
        kas ir mūsu reģistrā.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'Kļūda: Radās problēma, atjauninot paroli šim lietotājam.',
    'LBL_INCORRECT_PASSWORD' => 'Kļūda: Nepareiza parole.',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'Ievadītā parole neatbilst paroles prasībām. Mēģiniet vēlreiz.',
    'LBL_PASSWORD_MIN_LENGTH' => 'Minimālais garums ir {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'Maksimālais garums ir {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'Parolē jābūt vismaz vienam lielajam burtam (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'Parolē jābūt vismaz vienam mazajam burtam (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'Parolē jābūt vismaz vienam ciparam (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'Jābūt vienam īpašajam simbolam (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'Parole nedrīkst sakrist ar regulārās izteiksmes šablonu: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'Valodas izvēle:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'Nevarēja nosūtīt paroles atiestatīšanas e-pastu.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'Izvēlieties atskaiti',
    'LBL_REPORT_AUTO_REFRESH' => 'Automātiska atjaunināšana',
    'LBL_REPORT_EDIT' => 'Labot izvēlēto atskaiti',
    'LBL_REFRESH_LIST_AND_CHART' => 'Atsvaidzināt sarakstu un diagrammu',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'Diagrammas nav pieejamas.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'Šajā atskaitē nav neviena filtra.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'Jums ir paslēpti tikai izpildes laika filtri, skatiet paplašinātos filtrus.',
    'LBL_RUNTIME_FILTERS' => 'Izpildlaika filtri',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'Datums neatbilst lietotāja vēlamajam datuma formātam: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'Šajā informācijas laukā nav izpildlaika filtru',
    'LBL_DASHBOARD_FILTER_GROUP' => 'Jauns filtrs',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'Jums ir nepieciešama vismaz viena atlasīta vērtība.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'Atiestatīt uz noklusējuma filtriem',
    'LBL_COPY_FILTER_SUMMARY' => 'Kopēt filtra kopsavilkumu',
    'LBL_APPLY_FILTERS' => 'Pielietot',
    'LBL_REPORTS_FILTERS' => 'Filtri',
    'LBL_RUNTIME_FILTERS_INVALID' => 'Nederīgu vērtību dēļ nevar piemērot izpildlaika filtrus',
    'LBL_RUNTIME_FILTERS_COPIED' => 'Filtra kopsavilkums ir nokopēts starpliktuvē.',
    'LBL_ADVANCED_FILTERS' => 'Paplašinātie filtri',
    'LBL_ADVANCED_OR_DESC' => 'Iekļaut, kad ir izpildīts JEBKURŠ nosacījums',
    'LBL_ADVANCED_AND_DESC' => 'Iekļaut, kad ir izpildīti VISI nosacījumi',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'Šis ir oriģināla dizaina filtrs',
    'LBL_AND_UPPERCASE' => 'UN',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'Šī funkcija nav pieejama priekšskatījuma režīmā',
    'LBL_REPORT_DEFAULT_NAME' => 'Atskaite bez nosaukuma',
    'LBL_REPORT_QUERY' => 'Vaicājums',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'Piesaistīts dotajam ierakstam',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'Saistītais lauks',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'Saistītais lauks nevar būt tukšs',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'Nav atlasītu atskaišu.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'Līniju diagramma nav saderīga ar šo atskaiti',
    'LBL_REPORT_DASHLET' => 'Atskaites dašlets',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'Datu tabula',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'Izpildlaika filtri',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'Datu tabulas priekšskatījums',
    'LBL_REPORTS_DASHLET_CHART' => 'Diagramma',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'Diagrammas priekšskatījums',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'Filtra priekšskatījums',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'Atlasītā atskaite neatbalsta diagrammu.',
    'LBL_REPORTS_DASHLET_LABELS' => 'Etiķetes',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'Rādīt kopējo ierakstu skaitu',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'Šķirošanas secība',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'Noklusētais atlasītais skats',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'Primārā diagrammas šķirošanas secība',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'Sekundārā diagrammas šķirošanas secība',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'Neviens {{module}} nav saistīts ar atlasīto atskaiti',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'Nav pieejams šim atskaites tipam',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'Šī funkcija ir pieejama tikai diagrammas cilnē',
    'LBL_REPORTS_CHART_TYPE' => 'Diagrammas veids',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'Joslu diagrammas vērtību novietojums',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'Rādīt kopsummu',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'Rādīt leģendu',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Rādīt x-ass etiķeti',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Rādīt y-ass etiķeti',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Rindu parādīšanas ierobežojums',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'Jums nav atļauts lietot šos izpildlaika filtrus.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'Nezināms',
    'ERR_HTTP_DEFAULT_TITLE' => 'Nezināma kļūda',
    'ERR_HTTP_DEFAULT_TEXT' => 'Nezināma kļūda.',
    'ERR_HTTP_DEFAULT_ACTION' => 'Atgriezties iepriekšējā lapā.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'Kļūda: Nederīgs pieprasījums',
    'ERR_HTTP_400_TEXT_LINE1' => 'Jūsu pārlūks nosūtīja pieprasījumu, kuru serveris nevarēja saprast.',
    'ERR_HTTP_400_TEXT_LINE2' => 'Lai iegūtu sīkāku informāciju,, sazinieties ar Sugar administratoru.',
    'ERR_HTTP_400_ACTION' => 'Atgriezties iepriekšējā lapā.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'HTTP: 404 Not Found',
    'ERR_HTTP_404_TEXT_LINE1' => 'Šāda lapa neeksistē vai Jums nav atļaujas piekļūt šai lapai.',
    'ERR_HTTP_404_TEXT_LINE2' => 'Mēģiniet vēlreiz. Ja kļūda nav novērsta, sazinieties ar savu Sugar administratoru.',
    'ERR_HTTP_404_ACTION' => 'Atgriezties iepriekšējā lapā.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 Servera iekšējā kļūda',
    'ERR_HTTP_500_TEXT_LINE1' => 'Serverī ir radusies kļūda, tādēļ tas nevarēja izpildīt Jūsu pieprasījumu.',
    'ERR_HTTP_500_TEXT_LINE2' => 'Mēģiniet vēlreiz. Ja kļūda nav novērsta, sazinieties ar savu Sugar administratoru.',
    'ERR_HTTP_500_ACTION' => 'Lūdzu sazinieties ar tehnisko atbalstu.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 Servera iekšējā kļūda',
    'ERR_HTTP_502_TEXT_LINE1' => 'Serverī ir radusies pagaidu kļūda, tādēļ tas nevarēja izpildīt Jūsu pieprasījumu.',
    'ERR_HTTP_502_TEXT_LINE2' => 'Mēģiniet vēlreiz. Ja kļūda nav novērsta, sazinieties ar savu Sugar administratoru.',
    'ERR_HTTP_502_ACTION' => 'Sazinieties ar tehnisko atbalstu.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 Servera iekšējā kļūda',
    'ERR_HTTP_503_TEXT_LINE1' => 'Serveris nav pieejams jūsu pieprasījuma pabeigšanai.',
    'ERR_HTTP_503_TEXT_LINE2' => 'Mēģiniet vēlāk vēlreiz. Ja kļūda nav novērsta, sazinieties ar savu Sugar administratoru.',
    'ERR_HTTP_503_ACTION' => 'Sazinieties ar tehnisko atbalstu.',

    'ERR_RENDER_FAILED_TITLE' => 'Neveiksmīga skata veidošana',
    'ERR_RENDER_FAILED_MSG' => 'Neizdevās izveidot skatu',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'Neveiksmīga lauka veidošana',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'Neizdevās izveidot {0} lauku.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'Pekļuve liegta',
    'ERR_NO_VIEW_ACCESS_REASON' => 'Jums nav atļauts piekļūt šai lapai.',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'Sazinieties ar administratoru lai pieprasītu piekļuvi.',
    'ERR_NO_VIEW_ACCESS_MSG' => 'Sazinieties ar savu atbalsta administratoru lai iegūtu piekļuvi šim skatam modulī {0}.',

    'ERR_LAYOUT_RENDER_TITLE' => 'Neveiksmīga izkārtojuma veidošana',
    'ERR_LAYOUT_RENDER_MSG' => 'Oops! Neizdevās neko izveidot. Lūdzu mēģiniet vēlāk vai sazinieties ar atbalstu.',
    'ERR_INTERNAL_ERR_MSG' => 'Ieksējā kļuda',
    'ERR_GENERIC_TITLE' => 'Kļūda',
    'ERR_CONTACT_TECH_SUPPORT' => 'Lūdzu sazinieties ar tehnisko atbalstu.',

    'LBL_SYNCED_RECURRING_MSG' => 'Jūs nevariet rediģēt šo ierakstu, jo tas ir sinhronizāts no ārējas sistēmas.',
    'LBL_EXISTING' => 'Esošais',
    'LBL_PANEL_DEFAULT' => 'Noklusētais',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'Slikta atilde no servera',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'Radās kļūda piešķiršanas darbībā.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'Jums nav piekļuves tiesību modulim „{{name}}”. Sazinieties ar Administratoru.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'Gads {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'Vairāk darbību',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'Brīdinājums',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'Ignorēt dublikātus un saglabāt',
    'LBL_RESTORE' => 'Atiestatīt uz oriģinālu',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'Dzēšanai atzīmēti ieraksti',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'Parāda ierakstus, kuri saistīti ar datu privātuma pieprasījumu '
        . 'Dzēst informāciju.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS barotne',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'Esiet informēts pievienojot ārējo RSS vai emuāru barotnes.',
    'LBL_RSS_FEED_URL' => 'Barotnes URL',
    'LBL_RSS_FEED_AUTHOR' => 'Autors:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'Rādāmo ierakstu skaits',
    'LBL_ERR_LOADING_RSS_FEED' => 'Kļūda, ielādējot RSS barotni',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'Mana vēsture',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'Grupas vēsture',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'Ļauj lietotājiem pievienot Sugar lietotnes uz paneļa',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'Vēsture',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'Vēstures Dašlets attēlo veiktās tikšanās, veiktos zvanus, nosūtītos un saņemtos epastus.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'E-pasts',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'E-pasti',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'Mana vēsture',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'Grupas vēsture',
    'LBL_UNASSIGNED' => 'Nepiešķirts',
    'LBL_ARCHIVE_EMAIL' => 'Arhivēt E-pastu [Alt+K]',
    'LBL_EMAIL_ARCHIVED' => 'E-pasts arhivēts',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'Izveidot arhivēto e-pastu',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'Ieplānotās aktivitātes',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'Ieplānoto aktivitāšu dašlets attēlo ieplānotās tikšanās un zvanus.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'Šodien',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'Nākotnē',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'Mana vēsture',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'Grupas vēsture',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'Noticis',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'Vai tiešām vēlaties atzīmēt {0} kā slēgtus?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'Aktīvie uzdevumi',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Aktīvo uzdevumu dašlets rāda uzdevumus, kas jāizpilda tagad, gaidāmos uzdevumus un veicamos uzdevumus.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'Izpildīt tagad',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'Gaidāms',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'Veicamie darbi',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'Pabeigts',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'Vai tiešām vēlaties atzīmēt {0} kā pabeigtus?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mani uzdevumi',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Darba grupas uzdevumi',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'Jūsu modificējamajā ierakstā bija papildu e-pasts. Tas tagad ir galvenais un ir aizpildīts zemāk.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'Neaktīvi uzdevumi',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Uzdevumu dašlets rāda atceltos un pabeigtos uzdevumus.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'Atlikts',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'Pabeigts',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'pēdējo reizi modificēts {{relativetime}} {{date}} plkst. {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mani uzdevumi',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Darba grupas uzdevumi',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'Mani nesen apskatītie pieteikumi',

    'LBL_REPORT_DASHLET_TITLE_12' => 'Atvērtie pieteikumi pēc lietotāja un statusa',
    'LBL_REPORT_DASHLET_TITLE_125' => 'Jauni pieteikumi pēc biznesa centra un pēc nedēļas',
    'LBL_REPORT_DASHLET_TITLE_126' => 'Nesen izveidotie pieteikumi',
    'LBL_REPORT_DASHLET_TITLE_127' => 'Jauni pieteikumi pēc klientu līmeņa un pēc nedēļas',
    'LBL_REPORT_DASHLET_TITLE_128' => 'Atvērtie pieteikumi pēc klientu līmeņa un prioritātes',
    'LBL_REPORT_DASHLET_TITLE_129' => 'Kopā atrisinātie pieteikumi šajā mēnesī pēc biznesa centra',
    'LBL_REPORT_DASHLET_TITLE_130' => 'Kopā atrisinātie pieteikumi šajā mēnesī pēc aģenta',
    'LBL_REPORT_DASHLET_TITLE_131' => 'Nesen atrisināto pieteikumu saraksts',
    'LBL_REPORT_DASHLET_TITLE_132' => 'Mani atrisinātie pieteikumi šajā mēnesī pēc nedēļas',
    'LBL_REPORT_DASHLET_TITLE_133' => 'Mani pieteikumi ar izpildes termiņu šodien un ar nokavētu termiņu',
    'LBL_REPORT_DASHLET_TITLE_134' => 'Visi pieteikumi ar izpildes termiņu šodien un ar nokavētu termiņu',
    'LBL_REPORT_DASHLET_TITLE_135' => 'Mani atvērtie pieteikumi pēc turpmāko darbību datuma',
    'LBL_REPORT_DASHLET_TITLE_136' => 'Visi atvērtie pieteikumi pēc turpmāko darbību datuma',
    'LBL_REPORT_DASHLET_TITLE_137' => 'Mani atvērtie pieteikumi pēc statusa',
    'LBL_REPORT_DASHLET_TITLE_138' => 'Mani pieteikumi pagājušajā nedēļā pēc statusa',
    'LBL_REPORT_DASHLET_TITLE_139' => 'Manis uzdoto atvērto uzdevumu statuss',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC lietotāja saskarne',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP vai vecs REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron uzdevums',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar darbplūsma',
    'LBL_AUDIT_SUBJECT_USER' => 'Liietotājs',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web to Lead',

    //common chart strings
    'LBL_CHART' => 'Diagramma',
    'LBL_CHART_NO_DATA' => 'Dati nav atrasti.',
    'LBL_CHART_LEGEND_CLOSE' => 'Slēpt leģendu',
    'LBL_CHART_LEGEND_OPEN' => 'Parādīt leģendu',
    'LBL_CHART_CONTROLS_CLOSE' => 'Slēpt kontroles',
    'LBL_CHART_CONTROLS_OPEN' => 'Rādīt kontroles',
    'LBL_CHART_UNDEFINED' => 'Nenoteikts',
    'LBL_CHART_NO_LABEL' => 'Nenoteikts',
    'LBL_CHART_AMOUNT' => 'Summa',
    'LBL_CHART_COUNT' => 'Skaits',
    'LBL_CHART_PERCENT' => 'Procenti',
    'LBL_CHART_GROUP' => 'Grupa',
    'LBL_CHART_DATE' => 'Datums',
    'LBL_CHART_KEY' => 'Atslēga',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'Diagrammas veids',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'Rādīt virsrakstu',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'Rādīt kopsummu',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Rādīt x-asses etiķeti',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Rādīt y-asses etiķeti',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'Punktu attēlošanas veidi',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'Apvilkti punkti',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'Lēkājoši punkti',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'Apgriezti punkti',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'Joslu diagrammas vērtību novietojumu',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'Joslu diagrammas attēlojuma opcijas',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'Atļaut ritināt',
    'LBL_CHART_CONFIG_STACK_DATA' => 'Steka datu sērija',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'Paslēpt tukšās grupas',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'nosūtīts',
    'LBL_EMAIL_RECV' => 'ier',

    //record save
    'LBL_RECORD_SAVED' => 'Ieraksts saglabāts.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'Jūs veiksmīgi izveidojāt {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a>.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'Jūs veiksmīgi izveidojāt {{moduleSingularLower}}.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'Jūs veiksmīgi izveidojāt ierakstu, taču jums nav atļaujas piekļuvei šim ierakstam.', // use when user has no access to the model
    'LBL_VALIDATING' => 'Validē...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'Veiksmīgi:',
    'LBL_ALERT_TITLE_WARNING' => 'Brīdinājums:',
    'LBL_ALERT_TITLE_NOTICE' => 'Paziņojums:',
    'LBL_ALERT_TITLE_ERROR' => 'Kļūda:',
    'LBL_ALERT_TITLE_LOADING' => 'Ielādē ...',
    'LBL_ALERT_NO_ACCESS' => 'Jums nav piekļuves filtram, kas ir izmantots šim informācijas laukam.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'Dublējiet informācijas paneli, lai konfigurētu šo informācijas lauku ar savu filtru.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'Jūsu pārlūkprogrammas versija vairs netiek atbalstīta vai Jūs izmantojat neatbalstītu pārlūkprogrammu.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'Atbalstītās platformas',
    'LBL_ALERT_CONFIRM_DELETE' => 'Vai tiešām vēlaties dzēst šo vienumu?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'Vai tiešām vēlaties dzēst šos vienumus?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'Atlasītais ieraksts pārrakstīs sekojošas vērtības: {{values}}. Klikšķini "Atcelt", lai saglabātu pašreizējās vērtības. Klikšķini "Apstiprināt", lai pārrakstītu ar jaunām vērtībām.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'Atlasītajam {{moduleSingularLower}} ir saistītās vērtības: {{values}}. Atcelt, lai saglabātu esošās vērtības. Apstipriniet, lai pārrakstītu ar jaunajām vērtībām.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'No:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'Kam:',

    //organization chart
    'LBL_ORG_CHART' => 'Organizācijas diagramma',
    'LBL_ORG_CHART_DESC' => 'Attēlo organizācijas darbinieku struktūru',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'Pārslēgt orientāciju',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'Parādīt visus mezglus',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'Tālummainīt, lai ietilptu',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'Pieteikumu kopsavilkums',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'Attēlo saistīto Pieteikumu apskatu.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'Kopsavilkums',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'Aizvērtie pieteikumi',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'Atvērtie pieteikumi',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'Top 10 Pārdošanas iespējas',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'Attēlo 10 labākas iespējas burbuļu diagrammā.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'Manas Iespējas',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "Manas darba grupas iespējas",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'Noklusētais datuma filtrs',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'Noklusētā datu kopa.',

    'LBL_PRODUCT_CATALOG_NAME' => 'Produktu katalogs',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'Produktu katalogs',
    'LBL_PRODUCT_CATALOG_DESC' => 'Skatīt un pievienot vienumus no jūsu Produktu kataloga.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'Skatīt un pievienot vienumus no jūsu Produktu kataloga.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} {{date}} plkst. {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Ievadiet piezīmi vai velciet un nometiet pielikumu. Ievadiet @, lai paziņotu lietotājam. Ievadiet #, lai atsauktos uz ierakstu.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'Pievienojiet savu komentārut&hellip; Ievadiet @ lai paziņotu lietotājam. Ievadiet  # lai atsauktos uz ierakstu.',
    'LBL_ACTIVITY_STREAM' => 'Darbību plūsma',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'Darbību plūsma nav aktivizēta',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'Darbības plūsma nav iespējota šim modulim',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'Vairāk iesūtījumu...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'on',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'Mana aktivitāšu plūsma',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'Skatīt ar ierakstiem veikto darbību sarakstu, izveidot un publicēt komentārus.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'Darbību plūsmas ir atspējotas',

    'LBL_DATA_VIEW' => 'Datu skatījums',
    'LBL_COMMENT' => 'Komentārs',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'kļūda pieslēdzoties serverim. Mēģiniet vēlreiz..',
    'ERR_RESOLVE_ERRORS' => 'Pirms turpināt, izlabojiet kļūdas',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'Lai apstiprinātu, visiem obligātajiem laukiem jābūt aizpildītiem; tomēr jūs joprojām varat noraidīt vai pārsūtīt šo ierakstu.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'Lai noraidītu/pārsūtītu, visiem obligātajiem laukiem jābūt aizpildītiem.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'Atjaunināt sarakstu',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'Atsvaidzināt mozaīku',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'vairāk',
    'LBL_TEXTAREA_LESS' => 'mazāk',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} pielikumi',
    'LBL_CREATE_ATTACHMENT' => 'Izveidot pielikumu',
    'LBL_DASHLET_REFRESH' => 'Atjaunot',
    'LBL_DASHLET_MOVE' => 'Pārvietot',
    'LBL_DASHLET_CLOSE' => 'Aizvērt',

    'LBL_DASHLET_FORECAST_NAME' => 'Prognoze',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'Prognozes diagramma',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Prognozes Pareto diagramma',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'Prognoze priekš',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'Parāda Prognoze joslu diagrammu noteiktam laika periodam',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'Grupēt pēc',
    'LBL_DASHLET_FORECASTS_DATASET' => 'Datu kopa',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'Prognozes detalizēta informācija',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'attēlo pašreizējā prognozes detaļas.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'Saglabāto atskaišu diagrammu informatīvie lauciņi',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'Paāda jebkuru diagrammas no saglabātās atskaites.',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'Publicētie saistītie raksti',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'Vēsturiskais apkopojums',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'Vairāk vēstures...',
    'LBL_RELATED_CONTACT' => 'Saistītā kontaktpersona',
    'LBL_MODULE_TYPE' => 'Veids',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'E-pasts kam',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'E-pasts no',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'Mantotos moduļus nevar priekšskatīt',

    //SFA
    'LBL_BEST' => 'Labākā',
    'LBL_WORST' => 'Sliktākā',
    'LBL_LIKELY' => 'Ticamākā',
    'LBL_BEST_FORECAST' => 'Iesniegšana (labākā)',
    'LBL_WORST_FORECAST' => 'Iesniegšana (sliktākā)',
    'LBL_LIKELY_FORECAST' => 'Iesniegšana (ticamākā)',
    'LBL_BEST_ADJUSTED' => 'Koriģēta iesniegšana (labākā)',
    'LBL_WORST_ADJUSTED' => 'Koriģēta iesniegšana (sliktākā)',
    'LBL_LIKELY_ADJUSTED' => 'Koriģēta iesniegšana (ticamākā)',
    'LBL_AMOUNT_USDOLLAR' => 'Summa',
    'LBL_OVERDUE' => 'Nokavēts',

    'LBL_PASSWORD_REQUEST_SENT' => 'Jūsu pieprasījumu ir nosūtīts.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'Problēma izgūstot jūsu lietotājvārdu un epastu.',

    'LBL_REMINDER_TITLE' => 'Atgādinājums',
    'LBL_CLICK_TO_DRILLDOWN' => 'Spiediet lai izvērstu',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'Jūs nevariet atspējot visas valodas.',

    'LBL_UPDATE_CALC_FIELDS' => 'Pārrēķināt vērtības',

    //Optimistic Locking
    'LBL_YOU' => 'Jūs',
    'LBL_RESOLVE_CONFLICT' => 'Atrisināt konfliktu ar {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'Lai uzzinātu vairāk, skat. moduļa „{{{more_info_url}}}{{plural_module_name}}” dokumentāciju.{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'Dati nav pieejami',
    'LBL_NEED_HELP' => 'Nepieciešama palīdzība ar kaut ko jaunu?',
    'LBL_NEW_CASE' => 'Jauns pieteikums',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'Palīdzības informatīvais lauciņš sniedz konkrētu informāciju, kas attiecas uz moduli, kuru pašlaik apskatāt, kopā ar saiti uz atbilstošo dokumentāciju (piemēram, potenciālo klientu dokumentācija) programmas rokasgrāmatā kā papildinformāciju.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'Saraksta skatījuma režīma palīdzība',
    'LBL_HELP_RECORDS' => "Moduļa saraksta skatījuma režīmā tiek parādīti visi ieraksti, kas atbilst pašreizējās meklēšanas kritērijiem un kuriem lietotāji var piekļūt. Ir iespējams apskatīt pamatinformāciju par katru ierakstu saraksta skatījuma režīma lauku kolonnās vai arī var uzklikšķināt uz ieraksta nosaukuma, lai atvērtu ierakstu skatījuma režīmu.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'Ieraksta skata palīgs',
    'LBL_HELP_RECORD' => 'Šis ieraksta skats sniedz pilnīgu informāciju par katru ierakstu un nedaudz informācijas par saistītajiem ierakstiem.

- Ierakstu var rediģēt, klikšķinot uz noteikta lauka vai spiežot pogu "Rediģēt".
- Skatīt vai rediģēt saites uz citiem ierakstiem var, ieslēdzot apakšpaneli Datu skatījumā.
- Mijiedarboties ar lietotāju komentāriem un apskatīt ierakstu izmaiņu vēsturi var, ieslēdzot apakšpaneli darbību plūsmas skatā.
- Sekot šim ierakstam vai pievienot to favorītiem var, klikšķinot uz ikonām blakus ieraksta nosaukumam.
- Papildu komandas ir pieejams izvēlnē pa labi no pogas "Rediģēt".',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}} izveide',
    'LBL_HELP_CREATE' => 'Lai izveidotu moduli „{{plural_module_name}}”:
1. Ievadiet atbilstošos laukos prasītās vērtības.
 * Pirms saglabāšanas ir jāaizpilda lauki, kuri ir atzīmēti kā obligāti.
 * Ja nepieciešams redzēt papildu laukus, spiediet „Rādīt vairāk”.
2. Spiediet „Saglabāt”, lai pabeigtu ieraksta izveidi un atgrieztos moduļa „{{plural_module_name}}” sarakstā.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'Noteikts iespējams dublikāts',
    'LBL_HELP_DUPLICATE' => 'Sugar ir noskaidrojis, ka ieraksts, kuru mēģināt izveidot, jau pastāv. 

Lai modificētu esošu ierakstu, nevis izveidojotu jaunu, uzklikšķiniet uz "Atlasīt un rediģēt", kas atrodas pa labi no vajadzīgā ierakstu. Jebkuri tukšie lauki esošajā ierakstā tiks aizpildīti ar vērtībām, kuras tikko ievadījāt. Uzklikšķiniet uz "Saglabāt", lai veiktu šīs izmaiņas esošajā ierakstā. 

Ja tā vietā vēlaties izmantot vērtības, ko tikko ievadījāt, nevis tās, kas ir esošajā ierakstā, uzklikšķiniet uz "Atieststīt uz oriģinālu". Ievadītās vērtības tiks piemērotas esošajam ierakstam, un jūs tagad var veikt jebkādas papildu izmaiņas, uzklikšķiniet uz "Saglabāt", lai pabeigtu esošā ieraksta izmaiņas. 

Lai izveidotu jaunu ierakstu, izmantojot ievadītās vērtības, uzklikšķiniet uz "Ignorēt dublikātu un saglabāt" ekrāna augšējā labajā stūrī.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'Nav norādīti SMTP servera uzstādījumi',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'Lai sūtītu notifikācijas par piešķirto ierakstu ir jānokonfigurē SMTP serveris {{emailSettingsUrl}}.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'E-pasta iestatījumi',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'Pieejami jauni pārskati par krājumiem',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'Pieejami jauni pārskati par pozīcijām, kas nav krājumos, jūsu ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'Pārskatu modulī',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'Tie ir atzīmēti kā "Pārskats par krājumiem", un tos var filtrēt. Pārskati ir atzīmēti arī kā "Pārdošana un mārketings", "Klientu apkalpošana", "Datu privātums" vai "Administratīvie procesi", pamatojoties uz saturu. Lai saņemtu plašāku informāciju, skatiet ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'dokumentāciju',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM sniedz iespēju pieredzējušiem lietotājiem ātri veikt noteiktus uzdevumus, izmantojot tastatūras saīsnes, lai paaugstinātu produktivitāti. Tabulās labajā pusē aprakstīti pieejamie īsceļi kopā ar taustiņiem un to darbību.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>Atbalstītie taustiņi</h1><ul><li>visi burtcipari un simboli</li><li>shift, ctrl, alt, command, mod (ctrl sistēmā Windows/Linux un command sistēmā Macs)</li><li>enter, esc, space, tab, pageup, pagedown, end, home, ins, del, backspace</li></ul><h1>Atbalstītās funkcijas</h1><ul><li>Taustiņu kombinācija: ctrl+m</li><li>Vairāki taustiņi: m,ctrl+m</li><li>Taustiņu secība: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'Globālie īsceļi',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'Konteksta īsceļi',
    'LBL_SHORTCUT_KEY_KEY' => 'Atslēga',
    'LBL_SHORTCUT_FUNCTION' => 'Funkcija',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Konfigurēt konteksta īsceļus',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'Nav konteksta īsceļu, ko konfigurēt',
    'LBL_SHORTCUT_HELP' => 'Parādīt saīsņu palīdzības lapu.',
    'LBL_SHORTCUT_QUICK_CREATE' => 'Pārslēgt ātrās izveides izvēlni.',
    'LBL_SHORTCUT_SEARCH' => 'Pievērsiet uzmanību globālās meklēšanas laukam.',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'Ieslēgt sānjoslu',
    'LBL_SHORTCUT_CREATE_RECORD' => 'Izveidot jaunu ierakstu',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'Ņemt nākošo no saraksta',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'Ņemt iepriekšējo no saraksta',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'Rullēt pa kreisi',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'Rullēt pa labi',
    'LBL_SHORTCUT_OPEN' => 'Atver sarakstā  atzīmēto ierakstu',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'Atver labošanai sarakstā  atzīmēto ierakstu',
    'LBL_SHORTCUT_RECORD_DELETE' => 'Dzēst ierakstu',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Iziet no rediģēšanas režīma sarakstā bez saglabāšanas',
    'LBL_SHORTCUT_RECORD_SAVE' => 'Saglabāt ierakstu',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'Atcelt jebkādas izmaiņas ierakstā',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'Atzīmēt ierakstu kā favorītu',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'Sekot ierakstam',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'Apskatīt ierakstu',
    'LBL_SHORTCUT_MARK_SELECTED' => 'Atzīmēt ierakstu kā izvēlētu',
    'LBL_SHORTCUT_SELECT_ALL' => 'Izvēlēties visu',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'Atvērt masu darbību nolaižamo izvēlni',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'Pievērsiet uzmanību saraksta filtra laukam',
    'LBL_SHORTCUT_FILTER_CREATE' => 'Izveidot jaunu saraksta filtru',
    'LBL_SHORTCUT_FILTER_EDIT' => 'Rediģēt aktīvo saraksta filtru',
    'LBL_SHORTCUT_FILTER_SHOW' => 'Atvērt saraksta filtru izvēlni',
    'LBL_SHORTCUT_RECORD_EDIT' => 'Rediģēt ierakstu',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'Atvērt iepriekšējo ierakstu',
    'LBL_SHORTCUT_RECORD_NEXT' => 'Atvērt nākamo ierakstu',
    'LBL_SHORTCUT_COPY_RECORD' => 'Kopēt pašreizējo ierakstu',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'Atvērt primāro darbību izvēlni',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'Aizvērt atvilkni',
    'LBL_SHORTCUT_FILTER_ADD' => 'Pievienot papildus kritēriju filtram',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'Noņemt pēdējo filtra kritēriju',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'Aizvērt filtru',
    'LBL_SHORTCUT_FILTER_SAVE' => 'Saglabāt filtru',
    'LBL_SHORTCUT_FILTER_DELETE' => 'Dzēst filtru',
    'LBL_SHORTCUT_FILTER_RESET' => 'Atiestatīt filtru',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'Pievienot rindu',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'Noņemt rindu',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'Aizvērt masveida izmaiņas',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'Atjaunināt ierakstu',
    'LBL_CREATE_CATEGORY' => 'Izveidot <div class="btn-link" data-action="create-new">kategoriju</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'Apstiprināt',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'Atcelt',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'Multi-izvēlēties laukā atlasiet visus vienumus',
    'LBL_SHORTCUT_SWEETSPOT' => 'Pārslēgt Sweet Spot joslu.',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'Slēpt Sweet Spot bar',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'Saglabāt konfigurāciju',
    'LBL_SHORTCUT_RESTORE' => 'Atjaunot noklusējuma iestatījumus',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'Pielāgoto taustiņu kombināciju saglabāšanas laikā radās kļūda. Mēģiniet vēlreiz.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}} iestatījumi',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}} konfigurācijas iestatījumi tika saglabāti.',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} konfigurācijas kļūda',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} nav nekādu konfigurācijas iestatījumu',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'Lietotājam nav pieeja tiesību modulim {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'Lietotājam nav tiesību konfigurēt {{module}} moduļa iestatījumus',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'Datu bāzes iestādījumus modulim {{module}} nepieciešams salabot',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'līdz',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'Sākuma & Beigu datums',

    'LBL_CALENDAR_START_DATE' => 'Sākuma datums',
    'LBL_CALENDAR_END_DATE' => 'Beigu datums',
    'LBL_CALENDAR_DURATION' => 'Ilgums',
    'LBL_CALENDAR_RECURRENCE' => 'Atkārtošanās',
    'LBL_CALENDAR_REMINDERS' => 'Atgādinājumi',

    'LBL_CALENDAR_CUSTOM_DATE' => 'Pielāgot datumu',
    'LBL_CALENDAR_REPEAT_TYPE' => 'Atkārtošanās veids',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'Atkārtošanās intervāls',
    'LBL_CALENDAR_REPEAT_DOW' => 'Atkārtot noteiktās nedēļas dienās',
    'LBL_CALENDAR_REPEAT_ON' => 'Atkārtot',
    'LBL_CALENDAR_REPEAT' => 'Atkārtot',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'Atkārtot kamēr',
    'LBL_CALENDAR_REPEAT_COUNT' => 'Atkārtojumu skaits',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'Atkārtot selektoru',
    'LBL_CALENDAR_REPEAT_DAYS' => 'Mēneša diena(s)',
    'LBL_CALENDAR_REPEAT_MONTH' => 'Gada mēnesis(-i)',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'Atkārtot pēc kārtas',
    'LBL_CALENDAR_REPEAT_UNIT' => 'Atkārtot elementu',
    'TPL_REPEAT_INTERVAL' => 'Katrs {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'Šajā sērijā tiek izmantota opcija Atkārtot, kas nav pieejama Sugar, jo sērija tika sinhronizēta no kalendāra klienta. Ja vēlaties, lai šī sērija tiktu atkārtota noteiktā datumā, rediģējiet šo sēriju savā kalendāra klientā. Rediģējot šo sēriju programmā Sugar, opcija Atkārtot tiks iestatīta uz Nav.<br><br>Vai vēlaties turpināt?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'Atkārtotu notikumu izmaiņas jāveic pirmajā atkārtojumu notikumā.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'Atkārtošanās noteikumu ievērošana nenozīmē, ka tiek izveidots notikums.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'Piedalīšos',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'Noraidīts',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'Nekonkrēts',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'Nav atbildes',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'Kalendārs nav pieejams',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'Pieejamie skatījumi',
    'LBL_CALENDAR_DASHLET_NAME' => 'Kalendāra plānotājs',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'Noklusējuma skatījums',
    'LBL_CALENDAR_MY_CALENDARS' => 'Mani kalendāri',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'Lietotāja un darba grupas kalendāri',
    'LBL_CALENDAR' => 'Kalendārs',

    'LBL_CALENDAR_DAY' => 'diena',
    'LBL_CALENDAR_WEEK' => 'nedēļa',
    'LBL_CALENDAR_MONTH' => 'mēnesis',
    'LBL_CALENDAR_YEAR' => 'gads',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99.',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'Kļūda saņemot kalendāru.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'Saglabāt un sūtīt ielūgumus',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'Apstiprināt statusu',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'Procesi',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'Procesu informācijas laukā tiek parādītas veidnes, ko var izmantot SugarBPM.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'Procesu definīcijas',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'Procesu definīciju informācijas laukā tiek parādītas veidnes, ko var izmantot SugarBPM.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'Izveidot proces definīciju',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'Importēt procesa definīciju',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'Procesa biznesa lomas',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'Procesu biznesa noteikumu informācijas laukā tiek parādītas veidnes, ko var izmantot SugarBPM.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'Izveidot procesa biznesa lomu',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'Importēt procesa biznesa lomas',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'Procesa e-pasta sagataves',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'Procesu e-pasta veidņu informācijas laukā tiek parādītas veidnes, ko var izmantot SugarBPM.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'Izveidot procesa e-pasta sagatavi',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'Importēt procesa e-pasta sagataves',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'Izstrādājot procesus/biznesa noteikumus/e-pasta veidnes citā Sugar eksemplārā, mēs iesakām, lai eksemplārs būtu ir precīzs jūsu ražošanas sistēmas klons. Procesi/biznesa noteikumi/e-pasta veidnes, kas izveidotas neatkarīgā Sugar eksemplārā, var nedarboties vēlamajā veidā pēc importēšanas pabeigšanas. Procesi/biznesa noteikumi/e-pasta veidnes var balstīties uz konkrētām Studio vai lietojumprogrammas līmeņa izmaiņām, ieskaitot, bet neaprobežojoties ar pielāgoto lauku nosaukumiem, nolaižamā saraksta vērtībām, datu bāzes ID utt. Ja šīs vērtības nav identiskas eksemplāram, kur tika izveidoti procesi/biznesa noteikumi/e-pasta veidnes, jums var būt nepieciešams manuāli pārveidot procesu/biznesa noteikumu/e-pasta veidņu mērķa eksemplāru.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'Vai tomēr vēlaties turpināt šo importēšanu?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'Vai tomēr vēlaties turpināt šo eksportēšanu?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'Šādos nolaižamajos laukos ir nederīgas opcijas',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'Gaidošās darbības pēc procesa',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'Gaidošās darbības',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'Gaidošās darbības pēc procesa',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'Visi procesi',
    'LBL_RECORD_DASHBOARD' => 'Ierakstu instrumentu panelis',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'Procesa statusa kopsavilkums',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'Procesa statusa apraksts',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'Procesā',
    'LBL_PMSE_COMPLETED_STATUS' => 'Pabeigts',
    'LBL_PMSE_CANCELLED_STATUS' => 'Atcelts',
    'LBL_PMSE_TERMINATED_STATUS' => 'Pārtraukts',
    'LBL_PMSE_ERROR_STATUS' => 'Kļūda',
    'LBL_PMSE_SETTINGS' => 'SugarBPM iestatījumi',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'Vai tiešām vēlaties atspējot šo ierakstu?',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'Vai tiešām vēlaties iespējot šo ierakstu?',
    'LBL_PRO_DELETE_CONFIRMATION' => 'Vai tiešām vēlaties dzēst šo ierakstu?',

    'LBL_PRO_ENABLE' => 'Atjaunina',
    'LBL_PRO_DISABLE' => 'Atjaunina',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} piedalās procesā un var saturēt dažus bloķētus laukus. Lai rediģētu ierakstu, uzklikšķiniet šeit {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'Šis lauks ir bloķēts, jo tas ir iesaistīts notiekošā procesā.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'Šis ieraksts ir iesaistīts procesā un var saturēt dažus bloķētus laukus.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'Biznesa centrs',
    'LBL_BUSINESS_CENTER_ID' => 'Biznesa centra ID',
    'LBL_BUSINESS_CENTER_NAME' => 'Biznesa centra nosaukums',

    'LBL_PLIS_ACTIVITIES' => 'Iegādāto produktu darbības',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(Jauna birka)',
    'LBL_TAG_FETCH_ERROR' => 'Radusies kļūda, izgūstot birkas.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'SugarCRM nepieciešams javascript. Lūdzu iespējojiet javascript lai turpinātu lietot SugarCRM.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'Sērializētos datus nevarēja atserializēt',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'Sērializētos datus nevarēja atserializēt, jo tajos ir atsauces uz objektiem vai klasēm',

    'LBL_FIELD_TRIMMED' => 'Lauks tika apgriezts, jo tika pārsniegts maksimālais simbolu limits.',
    'LBL_FIELDSIZE_OVERFLOW' => 'Lauks pārsniedz maksimāli pieļaujamo simbolu skaitu.',
    'LBL_TINYMCE_TARGET_SAME' => 'Esošais logs',
    'LBL_TINYMCE_TARGET_NEW' => 'Jauns logs',

    'LBL_OUTBOUND_EMAILS' => 'E-pasta iestatījumi',
    'LBL_OUTBOUND_EMAIL' => 'E-pasta iestatījums',

    'LBL_EMAIL_PARTICIPANTS' => 'E-pasta dalībnieki',
    'LBL_EMAIL_PARTICIPANT' => 'E-pasta dalībnieks',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'Datu privātums',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'Datu privātums',
    'LBL_DATAPRIVACY_VIEW_PII' => 'Skatīt personisko informāciju',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'Atzīmēt dzēšanai',
    'LBL_DATAPRIVACY_FIELDNAME' => 'Lauks',
    'LBL_DATAPRIVACY_VALUE' => 'Vērtība',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'Izmainīja',
    'LBL_DATAPRIVACY_SOURCE' => 'Avots',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'Pēdējoreiz atjaunināts',
    'LBL_DATAPRIVACY_PII' => 'Personiskā informācija',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'Atzīmēt dzēšanai',
    'TPL_DATAPRIVACY_PII_TITLE' => 'Personiskā informācija, paredzēta {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'Mainīt taimerus',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'Ziņojumi',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'Nokopēts jūsu starpliktuvē!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'Nevarēja nokopēt jūsu starpliktuvē',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'Kopēt apstiprinājuma saiti',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'Laika josla',
    'LBL_NO_ACTIVITY' => 'Nav darbības',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} laika josla',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'Vairāk',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'Mazāk',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'Laika josla parāda pašreizējā ieraksta saistītos ierakstus un laika gaitā atlasa lauka atjauninājumus.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'Rādīt vairāk...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'Rādīt mazāk...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'Dati nav pieejami',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'Modulis nav licencēts.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'Aktīvie abonementi',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'Šo informācijas lauku var pievienot tikai moduļiem, kas ir saistīti ar atsevišķu uzņēmumu. Plašāku informāciju skatiet dokumentācijā <a href={{linkToDocumentation}}>Aktīvo abonementu informācijas lauks</a>.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'Parādīt pirkumus, kas attiecas uz šo saistīto uzņēmumu:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'Aktīvie abonementi konkrētam uzņēmumam.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', daudzums {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'Kopā:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'Nav aktīvu abonementu',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'Lai šis dašlets varētu darboties, ir nepieciešams modulis {{module_name}}. Sazinieties ar savu administratoru par moduļa {{module_name}} iespējošanu.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'Pirkumu vēsture',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'Visi pirkumi konkrētajam uzņēmumam.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'Šo informācijas lauku var pievienot tikai moduļiem, kas ir saistīti ar atsevišķu uzņēmumu. Plašāku informāciju skatiet dokumentācijā <a href={{linkToDocumentation}} target="_blank">Pirkumu vēstures informācijas lauks</a>.',
    'LBL_NO_PURCHASE_HISTORY' => 'Nav pirkumu, ko parādīt',
    'LBL_NO_PLIS' => 'Nav iegādāto produktu',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'Kopā',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'Daudzums',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'Šim informācijas laukam, lai tas varētu darboties, ir nepieciešami pirkumi un iegādātie produkti. Vaicājiet savam administratoram par pirkumu un iegādāto produktu iespējošanu.',
    'LBL_SEARCH_PURCHASE_NAME' => 'Meklēt pēc pirkuma nosaukuma...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'Izmantojiet Studio, lai mainītu ieraksta skatījuma informatīvā lauka izkārtojumu, dodoties uz ' .
        'Studio > {{module}} > Izkārtojumi > Ieraksta skata dašlets. <a href={{linkToStudio}}>Rediģēt Studio</a>.',
    'LBL_SERVICE_LEVEL' => 'Apkalpošanas līmenis',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'Skaits',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'Turpmākās darbības',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'Prioritāte/Statuss',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'Temats/Apraksts',

//Service Duration
    'LBL_SERVICE_DURATION' => 'Pakalpojuma ilgums',
    'LBL_SERVICE_DURATION_VALUE' => 'Pakalpojuma ilguma vērtība',
    'LBL_SERVICE_DURATION_UNIT' => 'Pakalpojuma ilguma mērvienība',
    'LBL_LOCK_DURATION' => 'Bloķēšanas ilgums',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Amazon Connect CCP neizdevās ielādēt. Lūdzu,' .
        'pārliecinieties, ka izmantojat ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">atbalstītais pārlūks</a>. ' .
        'Ja problēma nav novērsta, sazinieties ar savu Sugar administratoru.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Jūsu Sugar administrators nav konfigurējis jūsu instanci Amazon Connect.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Nevar izveidot savienojumu ar Amazon Connect. Vaicājiet palīdzību savam Sugar administratoram.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'Nezināms',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'Fokusa panelis',
    'LBL_CLOSE_FOCUS_DRAWER' => 'Aizvērt fokusa paneli',
    'LBL_EXTERNAL_GUESTS' => 'Ārējie viesi',
    'LBL_MY_FAVORITE_TASKS' => 'Mani izvēlētie uzdevumi',
    'LBL_RECORD' => 'Ieraksts',

    'LBL_MY_TASKS' => 'Mani uzdevumi',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'Neizdevās atrast lauku: {0} modulī: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'Neizdevās atrast ierakstu ar {0}: {1} modulī: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'Neizdevās atrast saikni ar nosaukumu: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'Datu bāzes ieraksts ar id: {0}, ar {1}: {2} modulī: {3} jau ir',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'atjaunojami izdzēsts (ar dzēšanas karodziņu = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'Atrasti vairāki datu bāzes ieraksti attiecībā uz {0} {1} modulī {2}. ' .
        'Izdzēsiet vai atjauniniet sakrītošos ierakstus attiecīgi. Sakrītošie ieraksti: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'Nākamā izpilde',
    'LBL_TIME_AWARE_TYPE' => 'Veids',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'Attēlošanas etiķete',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'Atvērt ieraksta skatu',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'Pievienot',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'Palīdzība nav pieejama',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'Funkcijas',
    'LBL_ACTIONBUTTON_FIELDS' => 'Lauki',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'Atlasīt lauku...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Apkopojums',
    'LBL_ACTIONBUTTON_RELATED' => 'Saistīts',
    'LBL_ACTIONBUTTON_SAVE' => 'Saglabāt',
    'LBL_ACTIONBUTTON_CANCEL' => 'Atcelt',
    'LBL_ACTIONBUTTON_R_MODULE' => 'Saistītais modulis',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'Saistītie lauki',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'Apkopojuma modulis',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'Apkopojuma lauki',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'Apkopojuma funkcija',
    'LBL_ACTIONBUTTON_MINIMUM' => 'Min.',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'Maks.',
    'LBL_ACTIONBUTTON_AVERAGE' => 'Vidējs',
    'LBL_ACTIONBUTTON_SUM' => 'Summa',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'Piešķirt ierakstu',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'Rakstīt e-pastu',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'Izveidot ierakstu',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Dokumentu sapludināšana',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'Atvērt Url',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'Izpildīt atskaiti',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'Atjaunināt ierakstu',
    'LBL_ACTIONBUTTON_ACTION' => 'Darbība',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'Piešķirt',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'E-pasts kam',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'Izmantot PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'Veidne',
    'LBL_ACTIONBUTTON_MODULE' => 'Modulis',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'Displeja iestatījumi',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'Veids',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'Nolaižamā',
    'LBL_ACTIONBUTTON_BUTTON' => 'Poga',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'Pogu grupa',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'Parādīt etiķeti uz ieraksta',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'Attēlot galvenē',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'Slēpt rediģēšanas laikā',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'Rādīt fokusa informācijas paneļa galvenē',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'Instrumentu panelis',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'Fokusa informācijas paneļa galvene',
    'LBL_ACTIONBUTTON_SIZE' => 'Izmērs',
    'LBL_ACTIONBUTTON_DEFAULT' => 'Noklusējuma',
    'LBL_ACTIONBUTTON_SMALL' => 'Mazs',
    'LBL_ACTIONBUTTON_LARGE' => 'Liels',
    'LBL_ACTIONBUTTON_CALCULATED' => 'Aprēķināts',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'Konvertēt uz PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Dokumentu sapludināšana',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'Priekšskatījums',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'Īpašības',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'Etiķete',
    'LBL_ACTIONBUTTON_DESC' => 'Padoms',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'Parādīt etiķeti',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'Parādīt ikonu',
    'LBL_ACTIONBUTTON_SCHEME' => 'Krāsu shēma',
    'LBL_ACTIONBUTTON_ICON' => 'Ikona',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'Atkarīgs',
    'LBL_ACTIONBUTTON_DESIGN' => 'Izkārtojuma konfigurācija',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'Apturēt kļūdas gadījumā',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'Automātiskā saglabāšana',
    'LBL_ACTIONBUTTON_CONFIG' => 'Konfigurācija',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'Konfigurējiet ActionButton pirms saglabāšanas.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'Konfigurēt pogas',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'Automātiski izveidot',
    'LBL_ACTIONBUTTON_LINK' => 'Izveidot relāciju ar priekšteci',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'Kopēt vecākvērtības',
    'LBL_ACTIONBUTTON_PRESET' => 'Iestatīt lauka vērtību(as)',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'Kopēt lauka vērtību(as) no priekšteča',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'Atlasīt...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'No vecāklauka ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'Vai tiešām vēlaties dzēst šo pogu?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'Vai tiešām vēlaties dzēst šo darbību?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'Darbības pogas nederīgi dati',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'Atlasiet moduli pirms saglabāšanas.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'Atlasiet saiti pirms saglabāšanas. Ja saite nav pieejama, noņemiet atzīmi no saites opcijas.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'Atlasiet ierakstu pirms saglabāšanas.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'Atlasiet veidni pirms saglabāšanas.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'Primārs',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'Sekundārs',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'Okeāns',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'Rozā',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'Armija',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'Zilganzaļš',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'Klusā okeāna',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'Zaļš',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'Dzeltens',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'Oranžs',
    'LBL_ACTIONBUTTON_THEME_RED' => 'Sarkans',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'Koraļkrāsas',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'Purpura',
    'LBL_ACTIONBUTTON_FORMULA' => 'Formula',
    'LBL_ACTIONBUTTON_ACTIONS' => 'Darbības',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'Pogas datu validēšanas kļūda.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'Pogām ir jābūt iestatītai vismaz etiķetei vai ikonai.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'Ievadiet derīgu pogas etiķeti.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'Ierakstu nevarēja izveidot, jo nav nepieciešamo vērtību. Sazinieties ar administratoru.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'Jums ir jābūt vismaz divām aktīvām šāda veida pogām.',
    'LBL_ACTIONBUTTON_RECORD' => 'Ieraksta skati',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'Darbību izvēlnes',
    'LBL_ACTIONBUTTON_ORDER' => 'Secība',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'Saraksta skats',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'Ieraksta skata galvene',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'Ieraksta skata informācijas lauka galvene',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'Apakšpaneļi',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'Uzdevumu secības izpildes dzinējam neizdevās izpildīt šādas darbības: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'Pievienot darbību',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'Noņemt šo darbību',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'Pašreizējais lietotājs',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'Dokumentu sapludināšana',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'Dokumentu sapludināšana uz PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'Uzņēmuma izmērs',
    'LBL_HINT_COMPANY_INDUSTRY' => 'Nozare',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'Nozares birkas',
    'LBL_HINT_COMPANY_LOCATION' => 'Uzņēmuma atrašanās vieta',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'Uzņēmuma apraksts',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'Dibināšanas gads',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Uzņēmums Facebook',
    'LBL_HINT_COMPANY_TWITTER' => 'Uzņēmums Twitter',
    'LBL_HINT_COMPANY_PIC' => 'Uzņēmuma logo',
    'LBL_HINT_CONTACT_PIC' => 'Kontaktpersonas fotoattēls',
    'LBL_HINT_COMPANY_WEBSITE' => 'Uzņēmuma tīmekļa vietne',
    'LBL_HINT_PHOTO' => 'Fotoattēla saite',
    'LBL_HINT_JOB_2' => 'Iepriekšējie darbi',
    'LBL_HINT_EDUCATION' => 'Izglītība',
    'LBL_HINT_EDUCATION_2' => 'Papildu izglītība',
    'LBL_HINT_TWITTER' => 'Twitter saite',
    'LBL_HINT_FACEBOOK' => 'Facebook saite',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS kods',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC kods',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'FG beigas',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'Gada ienākumi',
    'LBL_HINT_PHONE_1' => 'Tālrunis 1',
    'LBL_HINT_PHONE_2' => 'Tālrunis 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'Pievienot tabulu',
    'LBL_HINT_FULL_NAME' => 'Pilns vārds',
    'LBL_HINT_JOB_TITLE' => 'Amata nosaukums',
    'LBL_HINT_OFFICE_PHONE' => 'Darba tālrunis',
    'LBL_HINT_MOBILE_PHONE' => 'Mobilais tālrunis',
    'LBL_HINT_OTHER_PHONE' => 'Cits tālrunis',
    'LBL_HINT_WEBSITE' => 'Vietne',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'Vai vēlaties pārrakstīt visus šī ieraksta esošos datus ar jaunajiem datiem, kas atrodami Sugar Hint?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'Vai vēlaties pārrakstīt esošo {{fieldName}} šim ierakstam ar jaunu {{fieldName}}, kas atrodams Sugar Hint?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'Visi ar uzņēmumu saistītie dati tiks noņemti. Vai tiešām vēlaties turpināt?',
    'LBL_HINT_COMPANY_LOGO' => 'Logotips',
    'LBL_HINT_CONTACTS_AVATAR' => 'Foto',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint Accountsets birkas',

    'LBL_HINT_LOADING' => 'Ielāde ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Atinstalē Sugar Hint, lūdzu, uzgaidiet',
    'LBL_HINT_VALUE_ERASED' => ' Vērtība izdzēsta ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'Šī informācija tika izdzēsta, izmantojot datu privātuma pieprasījumu',

    'LBL_HINT_UNINSTALL_TITLE' => 'Lūdzu, atlasiet vienu no tālāk norādītajām atinstalēšanas opcijām:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Atinstalēt tikai Hint pakotnes',
    'LBL_HINT_UNINSTALL_FULL' => 'Atinstalēt Hint pilnībā',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'Šī opcija noņems Hint MLP un atspējos visus aktīvos Sugar Hint Insights abonementus.
    Pārinstalējot Hint, abonementi tiks automātiski atkārtoti aktivizēti.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'Šī opcija veikts Hint pilnu atinstalēšanu, tostarp MLP noņemšanu un visas konfigurācijas un abonēšanas informācijas dzēšanu.',
    'LBL_HINT_UNINSTALL' => 'Atinstalēt',
    'LBL_HINT_UNINSTALL_HEADER' => 'Atinstalēt Sugar Hint',
    'LBL_HINT_CANCEL' => 'Atcelt',
    'LBL_HINT_UNINSTALL_WARNING1' => 'BRĪDINĀJUMS: izvēlieties šo opciju tikai tad, ja turpmāk vairs neplānojat izmantot Hint.
    Pirms atinstalēšanas pabeidziet pilnu Sugar datu bāzes dublējumu un iestatiet Sugar uzturēšanas režīmā. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'Skatiet ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint administratora rokasgrāmatā ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'informāciju par atinstalēšanas procesu.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Vai tiešām vēlaties atinstalēt tikai Sugar Hint pakotni?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Vai tiešām vēlaties pilnībā atinstalēt Sugar Hint?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(PIEZĪME: ŠO DARBĪBU NEVARAT ATSAUKT)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint lauki',
    'LBL_HINT_NO_RESULTS_MSG' => 'Rezultāti nav atrasti.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'Hint paneļa pamata izkārtojums',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'Uzņēmumi',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'Kontaktpersonas',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'Interesenti',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'Hint paneļa paplašināts izkārtojums',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'Pārkārtojiet laukus, velkot un nometot iepriekš norādītajās Hint paneļa izkārtojuma sadaļās.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'Detalizētus norādījumus un noklusējuma lauku sarakstu skatiet ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' lai atjaunotu noklusējuma iestatījumus priekš ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'moduļa.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'Vai tiešām vēlaties atjaunot moduļa {{module}} noklusējuma iestatījumus?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'Spiediet šeit',
    'LBL_HINT_CONFIG_NAME' => 'Hint administratora rokasgrāmata.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'Lauki',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'Bagātināti lauki',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'Šajā sadaļā ir uzskaitīti visi Hint lauki un Sugar lauki, kurus bagātina Hint. Hint lauki ir atzīmēti ar zvaigznīti (*), un tos var parādīt Hint panelī tikai tad, ja tie ir bagātināti.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'Lauka nosaukums',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'Bagātināts lauks',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Parādīt Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Parādīt Hint panelī',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'Papildu Sugar lauki',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'Šajā sadaļā ir uzskaitīti visi Sugar lauki, kas nav bagātināti ar Hint.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'Brīdinājums',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'Uzmanību: Jūs grasāties sinhronizēt ar pakalpojumu Sugar Hint Insights. Visi neapstiprinātie e-pasta īssavilkuma stāsti tiks zaudēti, un esošās ziņas tiks notīrītas no Insights informācijas lauka. Visu veidu paziņojumi tiks atsākti pēc sinhronizācijas pabeigšanas.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'Tālāk ir norādīti ieteiktie uzņēmumi, kas ir saistīti ar jūsu {{_moduleSingular}}. Atlasiet uzņēmuma datus, ko parādīt.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'Nav atlasīts uzņēmums',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'Atrasti vairāki e-pasti, atlasiet importējamos e-pastus: ',

    'LBL_HINT_HELP_MESSAGE1' => 'Pamatojoties uz ievadītajiem datiem, Hint nevarēja atrast atbilstību sistēmā.',
    'LBL_HINT_HELP_MESSAGE2' => 'Labākos rezultātus Hint var atrast, izmantojot personas vārdu un e-pasta adresi.',
    'LBL_HINT_HELP_MESSAGE3' => 'Labākos rezultātus Hint var atrast ar uzņēmuma tīmekļa vietnes url.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "Ievadiet {{_moduleSingular}} uzņēmuma nosaukumu vai tīmekļa vietni, un Hint atradīs papildu datus.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "Ievadiet {{currentModule}} e-pasta adresi, un Hint atradīs papildu datus.",

    'LBL_HINT_HISTORY_NONE' => 'Vēsturiskajam skatam nav pieejami dati',
    'LBL_HINT_HISTORY_TITLE' => 'Darbību vēsture',

    'LBL_HINT_PREVIEW_TITLE' => 'Datu bagātināšana',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Jūsu Hint pakalpojuma licencei ir beidzies termiņš. Sazinieties ar savu SugarCRM administratoru, lai atjaunotu licenci.',
    'LBL_HINT_PREVIEW_QUESTION' => 'Vai vēlaties uzzināt, ko Hint var darīt jūsu un jūsu uzņēmuma labā? Sazinieties ar savu SugarCRM administratoru, lai pievienotu Hint.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'Uzņēmuma informācija nav atrasta',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'Atrasti bagātinātie dati — uzklikšķiniet, lai saglabātu visus bagātinātos datus savā ierakstā.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'Uzklikšķiniet, lai saglabātu bagātinātos datus savā ierakstā.',

    'LBL_HINT_CONTACTS_TITLE' => 'Saistītās kontaktpersonas',
    'LBL_HINT_CONTACTS_NONE' => 'Nav saistīto kontaktpersonu',

    'LBL_HINT_NEWS' => 'Ziņas',
    'LBL_HINT_GENERAL' => 'Vispārīgi',
    'LBL_HINT_ALL_NEWS' => 'Visas ziņas',
    'LBL_HINT_FILTER_NEWS' => 'Filtrēt ziņas',
    'LBL_HINT_FINANCIAL_NEWS' => 'Finanšu',
    'LBL_HINT_PERSONNEL_NEWS' => 'Personāla',
    'LBL_HINT_PRESS_RELEASES' => 'Preses relīzes',
    'LBL_HINT_OTHER_NEWS' => 'Cits',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'Meklēt ziņu rakstus',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'Ziņas nav pieejamas',
    'LBL_NEW_NOTIFICATIONS' => 'Jauni paziņojumi',
    'LBL_HINT_DASHLET_ALLOWED1' => 'Lai varētu skatīt Sugar Hint Insights informācijas lauku, jums ir jābūt Sugar Hint licencei.
    Jautājiet savam administratoram par Sugar Hint licences iegūšanu.',

    'LBL_HINT_FOR' => 'Priekš',
    'LBL_HINT_WITH' => 'ar',
    'LBL_HINT_SHOW_ME' => 'Rādīt man: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'Informēt mani pa: ',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insights preferenču centrs',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'Preferenču opciju taustiņš',
    'LBL_HINT_PREFERENCES' => 'Preferences',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'Dzēšana ir atspējota, ir nepieciešams vismaz viens preferenču paziņojums',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'Pievienošana ir atspējota, jūs sasniedzāt maksimālo preferenču paziņojumu skaitu',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Iekļaut Sugar Hint Insights informācijas laukā',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'Uznirstošais logs kā darbvirsmas paziņojums',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'Lai pastāvīgi saņemtu paziņojumus, paziņojumi ir jāiespējo visās pārlūkprogrammās un visās darbvirsmās.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Dažas pārlūkprogrammas, piemēram, Internet Explorer, neatbalsta paziņojumus. Paziņojumus nevar iespējot, ja izmantojat pārlūkprogrammu, kas neatbalsta paziņojumus.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'Nosūtīt tūlītēju e-pasta brīdinājumu par katru paziņojumu',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'Sūtīt ikdienas e-pasta īssavilkumu',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'Sūtīt nedēļas e-pasta īssavilkumu',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'Preferences nevarēja saglabāt. Pārbaudiet sistēmas savienojumu un mēģiniet vēlreiz.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'Dažos obligātajos laukos nav vērtības. Lūdzu, pārbaudiet savas preferences un pārliecinieties, ka ir aizpildīti visi obligātie lauki.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'Jūs grasāties iespējot pārlūkprogrammas paziņojumus pakalpojumam Sugar Hint Insights. Uzklikšķiniet uz Apstiprināt, lai turpinātu. Pēc tam jūsu pārlūkprogramma lūgs jums atļauju paziņojumu notikumu saņemšanai.',
    'LBL_HINT_PUSH_ERROR' => 'Pašpiegādes paziņojumu spraudnis ir reģistrēts priekš {{options.type}} bez tā atkarīgajiem laukiem. Spraudnis nedarbosies kā paredzēts. Obligāti norādiet ceļu uz darbinieka failu un abonementa saglabāšanas metodi serverī.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'IZSLĒGT Hint paziņojumus visiem lietotājiem',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'IESLĒGT Hint paziņojumus visiem lietotājiem',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'BRĪDINĀJUMS: Sugar Hint atinstalēšanas laikā neizdevās atspējot paziņojumus. Lai atspējotu paziņojumus, instalējiet Sugar Hint 5.4.0 vai jaunāku versiju un veiciet pilnīgu atinstalēšanu, izmantojot Sugar Hint atinstalētāju, kas atrodas Sugar sadaļā Administrēšana.',
    'LBL_HINT_ENRICH_ALL' => 'Bagātināt visu',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'Nepieciešama Hint licence',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'Karšu konfigurācija',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'Ģeokodētāja žurnāla skatītājs',
    'LBL_MAP_MAP' => 'Karte',
    'LBL_MAP_MAPS' => 'Kartes',
    'LBL_MAP_GEOCODING_RECORD' => 'Ģeokods',
    'LBL_MAP_GEOCODE_SUCCESS' => 'Ieraksts ir veiksmīgi ģeokodēts.',
    'LBL_MAP_LATITUDE' => 'Platums',
    'LBL_MAP_LONGITUDE' => 'Garums',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'Meklēt pēc adreses...',
    'LBL_MAP_ALREADY_GEOCODED' => 'Pašreizējais ieraksts jau ir ģeokodēts. Vai tiešām vēlaties pārrakstīt šī ieraksta ģeokodējumu?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'Manuālā ģeokodēšana',
    'LBL_MAP_POINT_COORDINATES' => 'Kartes punkta koordinātas',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'Notiek optimālā maršruta aprēķināšana...',
    'LBL_MAP_DIRECTIONS' => 'Norādījumi',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'Norādījumi, sākot no pašreizējā lietotāja',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'Norādījumi, sākot no šā ieraksta',
    'LBL_MAPS_RADIUS_INPUT' => 'Rādiuss (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'rādiusā no pasta indeksa',
    'LBL_MAPS_DISTANCE' => 'Attālums',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'Pasta indekss',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'Nederīga konfigurācija: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> lauka kartēšana ir nederīga.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'Kartes tips',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'Tālummaiņas līmenis',
    'LBL_MAPS_DASHLET' => 'Kartes',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'Parāda ģeokodēto ierakstu(s) kartē.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'Kartes šim modulim nav pieejamas. Lūdzu, iespējojiet to administratora konsolē.',
    'LBL_MAP_MODULES' => 'Modulis',
    'LBL_MAP_FILTER_BY' => 'Filtrēt pēc',
    'LBL_MAP_UNIT_TYPE' => 'Mērvienības veids',
    'LBL_MAP_UNIT_TYPE_MILES' => 'Jūdzes',
    'LBL_MAP_UNIT_TYPE_KM' => 'Kilometri',
    'LBL_MAP_ADDRESS' => 'Adrese',
    'LBL_MAP_NO_STARTING_POINT' => 'Sākuma punkts nav ģeokodēts.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'Sākuma punkta ieraksts nav ģeokodēts.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'Daži no atlasītajiem ierakstiem nav ģeokodēti un netiks parādīti kartē.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'Ieraksts(i) nav ģeokodēts.',
    'LBL_MAPS_MODULE_FIELDS' => 'Moduļu lauki',
    'LBL_MAPS_SELECT_FIELD' => 'Atlasīt lauku',
    'LBL_MAPS_RELATE_RECORD' => 'Saistītais ieraksts',
    'LBL_MAPS_MAPPING_TYPE' => 'Kartēšanas tips',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'Nav ģeokodētu ierakstu',
    'LBL_MAPS_ADDRESS' => 'Adrese',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'Piešķirtais lietotājs',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'Ielas sānu skats dotajam punktam nav pieejams',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> ieraksti nav derīgi kartēšanai. Lūdzu, izņemiet moduli no saraksta.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'Aizvērt',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'Izvērst',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'Saglabāt kā PDF',
    'LBL_MAPS_EMAIL_LINK' => 'E-pasta saite',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'Jums ir jābūt vismaz vienam ģeokodētam ierakstam.',
    'LBL_MAPS_GENERATING' => 'Ģenerē karti...',
    'LBL_MAPS_POINTS' => 'Kartes punkti',
    'LBL_MAPS_POINT' => 'Punkts',
    'LBL_MAPS_TRAVEL_DETAILS' => 'Informācija par braucienu',
    'LBL_MAPS_TOTAL_DISTANCE' => 'Kopējais attālums',
    'LBL_MAPS_TOTAL_DURATION' => 'Kopējais ilgums',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'Kopējas ilgums bez trafika',
    'LBL_MAPS_ITINERARY' => 'Maršruts',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'Brauciena attālums',
    'LBL_MAPS_TRAVEL_DURATION' => 'Brauciena ilgums',
    'LBL_MAPS_TRAVEL_STEPS' => 'Soļi',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'Brīdinājumi',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing kartes atbalsta ne vairāk kā 10 punktus koplietotā kartē. Lūdzu, pārskatiet savu izvēli.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'Nepieciešama kartes licence',
    'LBL_MAPS_SHARE_HELLO' => 'Sveiki,',
    'LBL_MAPS_SHARE_HEADER' => 'Jūs pieprasījāt Bing karti šādiem punktiem:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'Šis vietrādis URL atvērs karti, kurā būs iepriekš minētie punkti pakalpojumā Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Parādīt karti pakalpojumā Bing Maps',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'Nav atrasts maršruts norādītajiem pieturas punktiem.',
    'LBL_MAPS_GEOCODE_STATUS' => 'Ģeokoda statuss',
    'LBL_MAPS_GEOCODED' => 'Ģeokodēts',
    'LBL_MAPS_NOT_GEOCODED' => 'Nav ģeokodēts',
    'LBL_MAPS_NOT_FOUND' => 'Nederīga adrese',
    'LBL_MAPS_GEOCODING_FAILED' => 'Ģeokodēšana neizdevās',
    'LBL_MAPS_QUEUED' => 'Rindā',
    'LBL_MAPS_REQUEUED' => 'Atgriezts rindā',
    'LBL_MAPS_RELATED_RECORD' => 'Saistītais ieraksts',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'Skatīt atskaiti',
    'LBL_REPORT_DASHLET_DESC' => 'Parādīt saglabāto atskaiti',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'Atiestatīt uz dašleta noklusējuma iestatījumiem',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'Atiestatīt uz atskaites noklusējuma iestatījumiem',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'Atsvaidzināt rezultātus',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'Kopēt diagrammu starpliktuvē',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'Lejupielādēt diagrammu',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'Dašleta {{label}} atskaite tika rediģēta, un dašlets ir atiestatīts uz noklusējuma konfigurāciju.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'Jums nav atļauts lietot šo lauku.',

    'LBL_INVALID_FORMULA' => 'Nederīga formula',
    'LBL_RETURN_TYPE_MISSMATCH' => 'Funkcijas atgriešanas veids neatbilst',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'Prognoze',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'Ideāls klienta profils',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'Aizvērt nedēļas prognozes rādītājus',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'Prognozes vērtība',
    'LBL_AI_CONV_BIN_ACCURACY' => 'Prognozes tvertnes precizitāte',
    'LBL_AI_CONV_MULTIPLIER' => 'Prognozes daudzkāršotājs',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP vērtība',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP tvertnes precizitāte',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP daudzkāršotājs',
    'LBL_AI_NEW' => 'Jauns',
    'LBL_AI_ENTERED' => 'Ievadīts',
    'LBL_AI_CREATED' => 'Izveidots',
    'LBL_AI_WEEK' => 'Nedēļa',
    'LBL_AI_MONTH' => 'Mēnesis',
    'LBL_AI_QUARTER' => 'Ceturksnis',
    'LBL_AI_BYWEEK' => 'pēc nedēļas',
    'LBL_AI_BYMONTH' => 'pēc mēneša',
    'LBL_AI_BYQUARTER' => 'pēc ceturkšņa',
    'LBL_AI_WEEKTREND' => 'Nedēļas tendence',
    'LBL_AI_MONTHLYTREND' => 'Mēneša tendence',
    'LBL_AI_QUARTERTREND' => 'Ceturkšņa tendence',
    'LBL_AI_TREND' => 'Tendence pēc',
    'LBL_AI_TRENDS' => 'Tendences pēc',
    'LBL_AI_VELOCITY' => 'Ātrums',
    'LBL_AI_TOPX' => 'Augšējie {X}',
    'LBL_AI_TIMESPAN' => 'Laika posms starp posmiem -',
    'LBL_AI_BUSINESSTREND' => 'ar biznesa tendencēm',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Piedāvājam Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights izmanto kvantitatīvo analīzi, lai ģenerētu jaunus ieskatus jūsu SugarCRM datos. Uzņēmumā Sugar mēs vienmēr meklējam jaunus veidus, kā palīdzēt jums maksimāli izmantot savus datus, pieņemt apzinātus lēmumus, un tas ir tikai sākums tam, ko mēs ceram piedāvāt ar Sugar Insights.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights izmanto kvantitatīvo analīzi, lai ģenerētu jaunus ieskatus jūsu SugarCRM datos.',
    'LBL_AI_FIRMO' => 'Firmogrāfija',
    'LBL_AI_TOTALCOUNT' => 'Kopējais skaits',
    'LBL_AI_DAYSFROMLATESTACT' => 'Dienas kopš pēdējā',
    'LBL_AI_DAYSSINCE' => 'vecums',
    'LBL_AI_FIELDISSET' => 'pastāv',
    'LBL_AI_CONTACTCOMPLETENESS' => 'Kontaktinformācijas pilnīgums',
    'LBL_AI_CUTDATE' => 'Prognozes periods',
    'LBL_AI_FROMLASTCHANGE' => 'Dienas no funkcijas vērtības pēdējās maiņas',
    'LBL_AI_CALLSHELD' => 'Kopējais veikto zvanu skaits',
    'LBL_AI_CALLSPLANNED' => 'Kopējais plānoto zvanu skaits',
    'LBL_AI_OUTBOUNDCALLS' => 'Kopējais izejošo zvanu skaits',
    'LBL_AI_INBOUNDCALLS' => 'Kopējais ienākošo zvanu skaits',
    'LBL_AI_AVGCALLDURATION' => 'Vidējais zvanu ilgums',
    'LBL_AI_EMAILSARCHIVED' => 'Kopējais arhivēto e-pasta ziņojumu skaits',
    'LBL_AI_EMAILSREAD' => 'Kopējais izlasīto e-pasta ziņojumu skaits',
    'LBL_AI_EMAILSSENT' => 'Kopējais nosūtīto e-pasta ziņojumu skaits',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'Kopējais ierakstu skaits, kuriem plānotais slēgšanas datums ir mainīts uz vēlāku datumu',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'Kopējais ierakstu skaits, kuriem plānotais slēgšanas datums ir mainīts uz agrāku datumu',
    'LBL_AI_AMOUNTINCREASED' => 'Kopējie darījumi, kuru summa ir palielinājusies',
    'LBL_AI_AMOUNTDECREASED' => 'Kopējie darījumi, kuru summa ir samazinājusies',

    // User last state
    'LBL_LAST_STATE' => 'Pēdējais stāvoklis',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'Nosūtīt uz DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'Atcelt saņēmēja rediģēšanu',
    'LBL_RECIPIENT_ROLE' => 'Saņēmēja loma',
    // Base sales stages
    'LBL_OPEN' => 'Atvērt',
    'LBL_CLOSED_WON' => 'Aizvērts-noslēgts',
    'LBL_CLOSED_LOST' => 'Aizvērts-zaudēts',
    'LBL_KIOSK_ADD_FILES' => 'Pievienot failus',
    'LBL_KIOSK_ADD_DROP_FILES' => 'Pievienot vai nomest failus šeit',
    'LBL_KIOSK_CANCEL' => 'Atcelt',
    'LBL_KIOSK_EDIT' => 'Rediģēt',
    'LBL_KIOSK_EMAIL' => 'E-pasts',
    'LBL_KIOSK_FILES_UPLOADING' => 'Augšupielādē',
    'LBL_KIOSK_FILES_ERROR' => 'Neizdevās augšupielādēt pielikumu',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'Pielikums ir pārāk liels',
    'LBL_KIOSK_FILTER_SEARCH' => 'Meklēt',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'Kiosks',
    'LBL_KIOSK_LANGUAGE' => 'Valoda',
    'LBL_KIOSK_LAST_UPDATED' => 'Pēdējoreiz atjaunināts',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'Skats',
    'LBL_KIOSK_MENU' => 'Izvēlne',
    'LBL_KIOSK_MOBILE_PHONE' => 'Mobilais tālrunis',
    'LBL_KIOSK_MY_ACTIVITIES' => 'Manas darbības',
    'LBL_KIOSK_MY_PROFILE' => 'Mans profils',
    'LBL_KIOSK_NAME' => 'Nosaukums',
    'LBL_KIOSK_OFFICE_PHONE' => 'Biroja tālrunis',
    'LBL_KIOSK_ORGANIZATION' => 'Organizācija',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'Rindas vienā lapā:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'Nodrošina SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'Saglabāt izmaiņas',
    'LBL_KIOSK_SHOW_HIDE' => 'Rādīt/Paslēpt',
    'LBL_KIOSK_SIGN_IN' => 'Pieteikties',
    'LBL_KIOSK_SIGN_OUT' => 'Izrakstīties',
    'LBL_KIOSK_SORT_BY' => 'Šķirot pēc',
    'LBL_KIOSK_SUBMIT' => 'Iesniegt',
    'LBL_KIOSK_TIMEZONE' => 'Laika josla',
    'LBL_KIOSK_ACTIVITY' => 'Darbība',
    'LBL_KIOSK_NO_ACTIVITY' => 'Nav darbības, ko parādīt',
    'LBL_KIOSK_OLDEST_FIRST' => 'Vecākais pirmais',
    'LBL_KIOSK_NEWEST_FIRST' => 'Jaunākais pirmais',
    'LBL_KIOSK_SHOW_MORE' => 'Rādīt vairāk',
    'LBL_KIOSK_ADD_A_REPLY' => 'Pievienot atbildi',
    'LBL_KIOSK_REPLY_EMPTY' => 'Atbildi nevar atstāt tukšu.',
    'LBL_KIOSK_NUM_MORE' => 'vēl {{num}}',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'Sveiki',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'Ātri piekļūstiet saviem resursiem.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'Meklēt pieteikumus',
    'LBL_KIOSK_SHOW_ALL' => 'Parādīt visu',
    'LBL_KIOSK_404_TITLE' => 'Mēs to nevarējām atrast',
    'LBL_KIOSK_TENANT_404_TITLE' => 'Nomnieks nav atrasts',
    'LBL_KIOSK_404_MESSAGE' => 'Jūs uzklikšķinājāt uz saites, kas ir noņemta, īslaicīgi nav pieejama, vai ievadījāt nederīgu vietrādi URL.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'Lūdzu, pārliecinieties, vai jums ir pareizais URL. Lai saņemtu papildu palīdzību, lūdzu, sazinieties ar atbalsta dienestu.',
    'LBL_KIOSK_BACK_TO_HOME' => 'Atpakaļ uz sākumu',
    'LBL_KIOSK_ERROR_CODE' => '{code} Kļūda: ',
    'LBL_KIOSK_401_TITLE' => 'Neautorizēts',
    'LBL_KIOSK_401_MESSAGE' => 'Jums nav tiesību aplūkot šo lapu.',
    'LBL_KIOSK_403_TITLE' => 'Neautorizēts',
    'LBL_KIOSK_403_MESSAGE' => 'Jums nav piekļuves šīs lapas apskatei.',
    'LBL_KIOSK_500_TITLE' => 'Serveris neatbild',
    'LBL_KIOSK_500_MESSAGE' => 'Mūsu pusē kaut kas nogāja greizi.',
    'LBL_KIOSK_GO_BACK' => 'Atpakaļ',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'Atrasts ieraksta dublikāts',
    'LBL_KIOSK_ACCOUNT' => 'Uzņēmums',
    'LBL_KIOSK_STATUS' => 'Statuss',
    'LBL_KIOSK_DEACTIVATE' => 'Deaktivizēt',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'Lietotājs ir deaktivizēts',
    'LBL_KIOSK_MANAGE_USERS' => 'Pārvaldīt lietotājus',
    'LBL_KIOSK_LAST_LOGIN' => 'Pēdējā pieteikšanās',
    'LBL_KIOSK_FIRST_NAME' => 'Vārds',
    'LBL_KIOSK_LAST_NAME' => 'Uzvārds',
    'LBL_KIOSK_ROLE' => 'Loma',
    'LBL_KIOSK_INVITE' => 'Uzaicināt',
    'LBL_KIOSK_SEND_INVITES' => 'Sūtīt uzaicinājumu(s)',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'Uzaicinājums(i) ir veiksmīgi nosūtīts(i)',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'Uzaicinājums(i) nav nosūtīts(i)',
    'LBL_KIOSK_REACTIVATE' => 'Atkārtoti aktivizēt',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'Lietotājs ir atkārtoti aktivizēts',
    'LBL_KIOSK_RESET_PASSWORD' => 'Atiestatīt paroli',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'Nosūtīts paroles atiestatīšanas e-pasts',
    'LBL_KIOSK_USER_PROFILE' => 'Lietotāja profils',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'Jūsu lietotājs ir deaktivizēts. Lūdzu, sazinieties ar administratoru.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'Atpakaļ uz pieteikšanos',
    'LBL_KIOSK_REVOKE_INVITATION' => 'Atsaukt uzaicinājumu',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'Uzaicinājums ir veiksmīgi atsaukts',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'Meklēt un atlasīt...',
    'LBL_KIOSK_NO_MATCHES' => 'Nav atrasta neviena atbilstība',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'Profils ir atjaunināts.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'Kļūda, atjauninot profilu.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'ATB.: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'Dokumenti',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'Skatiet, meklējiet un lejupielādējiet ienākošos koplietotos dokumentus.',
    'LBL_KIOSK_CASES' => 'Pieteikumi',
    'LBL_KIOSK_CASES_DESC' => 'Skatiet, meklējiet un atbildiet uz pieteikumiem, kas ar jums ir kopīgoti.',
    'LBL_KIOSK_DOWNLOAD' => 'Lejupielādēt',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'Faili veiksmīgi lejupielādēti',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'Darba sākšana',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'Lai jums labāk palīdzētu, lūdzu, norādiet mums savu vārdu un uzvārdu.',
    'LBL_KIOSK_SAVE' => 'Saglabāt',
    'LBL_KIOSK_SHARED' => 'Koplietots',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'Sveiki, {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'Fona krāsa',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'Fona attēla URL',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'Ieteicams izvēlēties attēlu, kura faila izmērs ir mazāks par 400K.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'Fona tips',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'Sākuma ekrāna fons',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'Tēma',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'Tēmas galvenā krāsa',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'Lietotnes nosaukums',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'Šis ir jūsu lietotnes nosaukums, un tas ir redzams blakus jūsu logotipam.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'Lietotnes logotipa URL',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'Ieteicams izvēlēties tādu logotipu, kas ir vislabāk skatāms mazos izmēros (piemēram, sociālo tīklu profili). Ieteicams arī, lai faila izmērs būtu mazāks par 200K.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'Lietotnes ikonas URL',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'Ikona ir mazs logotips, kas pārlūkprogrammas cilnē ir redzams blakus lapas virsrakstam.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'Atvērto aktivitāšu automātiska atkārtota piešķiršana',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'Sasniegts lietotāja ierobežojums',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'Nederīga licences atslēga',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'Nederīgs pieteikums',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'Nederīgs pieteikums',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'Bojāta validācijas atslēga',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'Licences derīguma termiņš ir beidzies',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'Trūkst informācijas',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'Trūkst validācijas atslēgas',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'Lietotājam nav piekļuves',
    'LBL_DRI_WORKFLOW' => 'Smart Guide',
    'LBL_DRI_WORKFLOWS' => 'Smart Guides',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Smart Guide posma veidne',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Smart Guide posma veidnes',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Smart Guide veidne',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Smart Guide aktivitātes veidne',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'Aktivitātes veidnes',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'Tīmekļa pārtvērēji',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate tīmekļa pārtvērēji',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'Pašreizējā Smart Guide aktivitāte',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate tīmekļa pārtvērēji',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate tīmekļa pārtvērējs',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar darbības',
    'LBL_CJ_FORMS' => 'Smart Guide Sugar darbības',
    'LBL_CJ_FORM' => 'Smart Guide Sugar darbība',
    'LBL_DRI_SUBWORKFLOW' => 'Smart Guide posms',
    'LBL_DRI_SUBWORKFLOWS' => 'Smart Guide posmi',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Smart Guide aktivitātes veidnes',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Smart Guide veidnes',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Smart Guide secība',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Smart Guide faktiskā secība',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Smart Guide vērtējums',
    'LBL_CJ_MOMENTUM_POINTS' => 'Smart Guide impulsa punkti',
    'LBL_CJ_MOMENTUM_SCORE' => 'Smart Guide impulsa vērtējums',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Smart Guide ļauj veikt darbības ar',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Smart Guide progress',
    'LBL_CJ_MOMENTUM_RATIO' => 'Smart Guide impulsa attiecība',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Smart Guide punkti',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Smart Guide uzdevums',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Smart Guide priekšteča aktivitātes veids',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Smart Guide bloķēts pēc',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'Smart Guide bloķēts pēc posmiem',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Smart Guide priekšteča aktivitātes Id',
    'LBL_START_NEXT_JOURNEY_ID' => 'Sākt nākamo Smart Guide Id',
    'LBL_CJ_URL' => 'Smart Guide Url',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Ir Smart Guide priekšteča aktivitāte',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Smart Guide impulsa sākuma datums',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Smart Guide impulsa beigu datums',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'Logrīka izkārtojuma konfigurācija',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'Logrīka izkārtojuma konfigurācija',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'Maksimālais Smart Guides skaits no vienas veidnes',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'Aktīvs',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'Arhivēts',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'Parādīt',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'Paslēpt',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'Vertikālais režīms',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'Horizontālais režīms',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Nederīga licence',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} piešķīra šādas Smart Guide aktivitātes lietotājam {{assigned_user}}.</p>
    <ul>{{activities}}</ul>
    
    <p>Jūs varat pārskatīt šīs aktivitātes šeit:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Nederīga licence',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'Lietotāju limits ir sasniegts, jums ir {{gracePeriodDays}} dienas, lai jauninātu licenci.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - piešķirtās Smart Guide aktivitātes',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Jūsu Sugar Automate lietotāju limits {0} ir pārsniegts<br>
    <br>
    Lūdzu, sazinieties ar <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a>, lai palielinātu lietotāju limitu vai samazinātu to lietotāju skaitu, kas lieto šo spraudni.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate lietotāju limits sasniegts',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Jūsu Sugar Automate licences derīguma termiņš beigsies pēc {0} dienām. <br>
    <br>
    Lūdzu, sazinieties ar SugarCRM vai savu Sugar partneri, lai atjaunotu un novērstu pakalpojuma pārtraukšanu.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate licences derīguma termiņš drīz beigsies',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'Pārbaudīt tīmekļa pārtvērēju',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide progress',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Parāda Sugar Automate "Smart Guide Progress" sektoru diagrammu.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'Parāda tīmekļa pārtvērēja atbildi',
    'LBL_DASHLET_SEND_LABEL' => 'Sūtīt pieprasījumu',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'Piešķirt man',
    'LBL_COMPLETE_BUTTON_TITLE' => 'Pabeigt',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'Pabeigt visus uzdevumus',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'Dzēst posmu',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'Sākt',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'Nav piemērojams',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'Pievienot posmu',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'Skats',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Rediģēt Smart Guide',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'Atcelt',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'Arhīvs',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'Atarhivēt',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'Konfigurēt veidni',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'Pievienot uzdevumu',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'Ieplānot tikšanos',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'Ieplānot zvanu',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'ir nākotnē',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'ir nokavēts',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'ir šodien',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'ir rīt',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'Vai tiešām vēlaties atcelt šo Smart Guide?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'Jūs gatavojaties pabeigt visus uzdevumus. Vai tiešām vēlaties turpināt?',
    'LBL_CJ_BLOCK_BY' => 'Jums ir neatrisināts, atkarīgais uzdevums: {{Name}}. Pabeidziet šo uzdevumu pirms visu uzdevumu pabeigšanas.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'Jums ir vairāki neatrisināti atkarīgie uzdevumi. Pabeidziet šos uzdevumus pirms visu uzdevumu pabeigšanas.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'Jūs veiksmīgi pabeidzāt visus uzdevumus',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'Vai tiešām vēlaties arhivēt šo Smart Guide?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'Vai tiešām vēlaties atarhivēt šo Smart Guide?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Smart Guides (Fokusa atvilktnes un konsole)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'Skatiet aktīvos Smart Guides, kas atrodas pakalpojumu/atjaunojumu konsoles un fokusa atvilktnes informācijas paneļos.',
    'LBL_CJ_PROCESSING_REQUEST' => 'Apstrādā..',
    'LBL_CJ_SUCCESS' => 'Jūs veiksmīgi pabeidzāt visus uzdevumus',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module} modulis nav iespējots',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'Visi displeja iestatījumi ir saglabāti.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Smart Guide impulss',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Parāda Sugar Automate "Smart Guide impulss" kontūru diagrammu.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide progress',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Parāda Sugar Automate "Smart Guide Progress" sektoru diagrammu.',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'Nevarēja atrast priekšteci',
    'CJ_NOT_FOUND_EXCEPTION' => 'Nevarēju atrast {moduleName} ar {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'Pirms arhivēšanas Smart Guide ir jāpabeidz vai jāatceļ',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate nav iespējots pašreizējā Sugar licencē',
    'LBL_ACTION_NOT_FOUND' => 'Darbība nav atrasta, sazinieties ar sistēmas administratoru',
    'LBL_CJ_SELECT_FIELD' => 'Atlasīt lauku',
    'LBL_CJ_SELECT_OPERATOR' => 'Atlasīt operatoru',
    'LBL_CJ_SELECT_VALUE' => 'Atlasīt vērtību',
    'LBL_CJ_ENTER_VALUE' => 'Ievadīt vērtību',
    'LBL_CJ_FORM_BATCH_TITLE' => 'Saglabā ierakstu',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'Atklāti aktīvie smart guides...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'Apstrādā aktīvās sugar darbības...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'Atjaunina aktīvos smart guides...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'Ieraksts un saistītie smart guides ir veiksmīgi atjaunināti.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'Saistīto smart guide neizdevās atjaunināt. Ja kļūda joprojām pastāv, sazinieties ar savu Sugar administratoru, lai saņemtu palīdzību.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'Saistīto smart guide neizdevās atjaunināt. Pārskatiet <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">žurnālus</a>, lai uzzinātu par kļūdas novēršanu.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => '<a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} ir veiksmīgi piesaistīts.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'Radās problēma ar <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} piesaistīšanu. Ja problēma joprojām pastāv, sazinieties ar Sugar atbalsta dienestu.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => 'Modulis {{modulePluralLower}} tika veiksmīgi sasaistīts.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'Radās problēma ar {{modulePluralLower}} piesaistīšanu. Ja problēma joprojām pastāv, sazinieties ar Sugar atbalsta dienestu.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'Radās problēma ar {{moduleSingularLower}} piesaistīšanu. Ja problēma joprojām pastāv, sazinieties ar Sugar atbalsta dienestu.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'Jau ir {{moduleSingularLower}} ar nosaukumu <a href="#{{module}}/{{id}}">{{name}}</a> {{stage}} posmā.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => '{{moduleSingularLower}} ar nosaukumu <a href="#{{module}}/{{id}}">{{name}}</a> jau ir atlasīts.',
    'LBL_CJ_ARCHIVED' => 'Arhivēts',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Atlasīt Smart Guide veidni...',
    'LBL_ALL_SMART_GUIDES' => 'Visi Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => 'Aktīvie Smart Guides',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Arhivētie Smart Guides',
    'LBL_VERTICAL_SCROLL_VIEW' => 'Vertikāls grēdots skats',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'Horizontālais ritināšanas skats',
    'LBL_DRI_WORKFLOWS_FILTER' => 'Filtrs',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'Šo darbību nevar pabeigt. Šo aktivitāšu moduļa lauks Statuss ir iestatīts uz "tikai lasāms", novēršot jebkādas Smart Guide darbības, kas atjaunina statusa lauku.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'Šo darbību nevar pabeigt. Šo aktivitāšu un/vai apakšaktivitāšu moduļu lauks Statuss ir iestatīts uz "tikai lasāms", novēršot jebkādas Smart Guide darbības, kas atjaunina statusa lauku.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'Dažu aktivitāšu moduļu lauks Statuss ceļvedī ir iestatīts uz "tikai lasāms", šīs aktivitātes paliks nemainīgas pēc ceļveža atcelšanas.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'Nokopēts starpliktuvē.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'Dzēst visus atkārtojumus',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'Nederīgi atkārtojumu iestatījumi',
    'ERROR_INTERVAL_INVALID' => 'Atkārtošanas intervālam jābūt no 1 līdz 99',
    'LBL_RECURRENCE_ADD' => 'Konfigurēt',
    'LBL_REPEAT_DAYS' => 'Mēneša diena(s)',
    'LBL_REPEAT_END_TYPES' => 'Atkārtot',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'Navigācijas nodrošinātājs',
    'LBL_MOBILE_PDF_EMAIL' => 'Sūtīt uz e-pastu {{{pdfTemplateName}}} PDF',
    'LBL_MOBILE_EMAIL_SENDING' => 'Sūta',
    'LBL_MOBILE_EMAIL_SENT' => 'Nosūtīts',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'E-pasts saglabāts kā uzmetums.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'Pievienot pielikumu',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'Augšupielādēt no lokālā',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar dokumenta',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'Jūsu veiktais šī ieraksta rediģējums mainīja šo skatu.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'SugarCRM Mobile lietotnes izlaiduma piezīmes',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'SugarCRM Mobile lietotnes lietotāja pamācība',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile nevar izmantot nedrošā mobilajā ierīcē. Atveriet lietotni drošā ierīcē.',
    'LBL_VO_BUILD_ROUTE' => 'Izveidot maršrutu',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'Mans attāluma filtrs',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'Dokuments tiks ģenerēts fonā. Lai piekļūtu failam, atveriet lapu Dokumentu sapludināšana.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'Neizdevās iegūt veidni. Sazinieties ar savu administratoru, lai saņemtu palīdzību.',
    'LBL_MAP_ERROR_LOAD' => 'Nevar ielādēt karti',
    'LBL_MAP_DISTANCE' => 'Attālums',
    'LBL_SELECT_UNIT_TYPE' => 'Mērvienības veids',
    'LBL_MAPS_UNIT_MILES' => 'Jūdzes',
    'LBL_MAPS_UNIT_KILOMETERS' => 'Kilometri',
    'LBL_RADIUS' => 'Rādiuss',
    'LBL_ZIP_CODE' => 'Pasta indekss',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'Izvēlēties adresi',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'Nevar izveidot ģeokodu no adreses:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'Ieraksts nav ģeokodēts.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'Ieraksts nesatur nekādus adreses datus. Vai vēlaties manuāli atrast šo ierakstu kartē?',
    'LBL_ERR_SHOW_ON_MAP' => 'Neizdevās atvērt karti atlasītajiem ierakstiem.',
    'LBL_ERR_MISSING_ON_MAP' => 'Dažiem ierakstiem nav adreses datu, un tie netiek rādīti',
    'LBL_MAPS_ROUTE' => 'Maršruts',
    'LBL_MAPS_PROVIDER' => 'Sugar kartes',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'Nevarēja noteikt pašreizējo atrašanās vietu.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'Kartēšanai tiek atbalstīti ne vairāk kā {{{num}}} ieraksti.',
    'LBL_ALL_MODULES' => 'Visi moduļi',
    'LBL_DRIVE_SHARE_LINK' => 'Kopīgot saiti',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'Neizdevās ielādēt failus.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'Nosaukums nedrīkst būt tukšs',
    'LBL_DRIVE_FOLDER_CREATED' => 'Mape izveidota.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'Neizdevās izveidot mapi.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'Neizdevās augšupielādēt failu.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'No sākuma izveidojiet saknes mapi',
    'LBL_EDIT_ALL_RECURRENCES' => 'Rediģēt visus atkārtojumus',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'Failu nevar atvērt pakalpojumā Dropbox',
    'LBL_FILE_NOT_AVAILABLE' => 'Failu nevar atvērt',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'Norādījumi',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'Nav atrasts maršruts norādītajiem pieturas punktiem',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'Tuvumā',
    'LBL_TAGS' => 'Birkas',

    'LBL_CALLER_ID_SETTINGS' => 'Zvanītāja ID iestatījumi',
    'LBL_CALLER_ID_ENABLED' => 'Zvanītāja ID ir iespējots',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'Ienākošajos zvanos tiek parādīts tās kontaktpersonas vai interesenta vārds, kas atbilst tālruņa numuram.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'Lai atļautu mobilajai lietotnei rādīt zvanītāja ID, savā ierīcē veiciet tālāk norādītās darbības.<br><br>1. Atveriet iOS iestatījumus > Tālrunis > Zvanu bloķēšana un identifikācija.<br>2. Iespējojiet "{{{brandName}}}".',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'Lai atļautu mobilajai lietotnei rādīt zvanītāja ID, savā ierīcē veiciet tālāk norādītās darbības.<br>1. Atveriet lietotnes iestatījumus.<br>2. Dodieties uz sadaļu Atļaujas.<br>3. Iespējojiet tālruņa atļauju.<br><br> Lai iestatītu šo lietotni kā noklusējuma zvanītāja ID apstrādātāju, dodieties uz ierīces iestatījumiem.<br>1. Pārejiet uz sadaļu Lietotnes.<br>2. Izvēlieties noklusējuma lietotnes.<br>3. Izvēlieties zvanītāja ID un surogātpasta lietotni.<br>4. Atlasiet šo lietotni kā noklusējuma opciju.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Pārbaudiet, vai jūsu Sugar instancē nav mainīta kontaktinformācija no ierakstiem (piemēram, kontaktpersonām, interesentiem).',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'Dodieties uz Iestatījumiem',
    'LBL_CALLER_ID_SYNC' => 'Sinhronizēt ieraksta datus',
    'LBL_CALLER_ID_NOT_ENABLED' => 'Pirms sinhronizācijas sistēmas iestatījumos ir jābūt iespējotam zvanītāja Id.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'Iespējot',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'Vēlāk iestatījumos',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'Šī lietotne atbalsta zvanītāja ID funkciju.<br> Lai šī funkcija darbotos pareizi, pēc iespējošanas pogas nospiešanas jums tiks piedāvāts piešķirt divas atļaujas.<br> Lai nodrošinātu, ka zvanītāja ID funkcija darbojas pareizi, jums ir jāpiešķir atļauja zvanu pārvaldīšanai un jāatlasa šī lietotne kā noklusējuma zvanītāja ID apstrādātājs.<br> Ja nepiešķirsiet atļauju zvanu pārvaldīšanai, jūs arī nevarēsiet reģistrēt zvanus, kas veikti no lietotnes.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'Lai atļautu SugarCRM mobilajai lietotnei rādīt zvanītāja ID, savā ierīcē veiciet tālāk norādītās darbības.<br><br>1. Atveriet iOS iestatījumus > Tālrunis > Zvanu bloķēšana un identifikācija.<br>2. Iespējojiet lietotni.',
    'LBL_MOBILE_LAST_SYNC' => 'Pēdējā sinhronizācija',
    'LBL_CALLER_ID_SYNCING' => 'Sinhronizācija ar serveri.',
    'LBL_NEVER' => 'Nekad',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} nevar būt tukšs.',
    'LBL_ADD_RELATED_RECORD' => 'Saistīts {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => 'Jums nav nepieciešamo atļauju, lai varētu izmantotu zvanītāja ID. Lūdzu, sazinieties ar administratoru.',
    'LBL_CALLER_ID_FETCHING' => 'Sinhronizē…',
    'LBL_CALLER_ID_FETCH_ALL' => 'Atkārtoti sinhronizēt visus ierakstus',
    'LBL_CALLER_ID_FETCH_NEW' => 'Pārbaudiet, vai nav ierakstu atjauninājumu',

    'LBL_SORT_BY' => 'Šķirot pēc',
    'LBL_PRIMARY_SORT' => 'Primārā šķirošana',
    'LBL_SECONDARY_SORT' => 'Sekundārā šķirošana',
    'LBL_OF' => 'no',
    'LBL_TABLE_FREEZE_FIRST' => 'Iesaldēt pirmo kolonnu',
    'LBL_TABLE_SETTINGS_TITLE' => 'Kolonnas skata opcijas',
    'LBL_TABLE_SETTINGS_NO_COL' => 'Ir jāatlasa vismaz viena kolonna.',
    'LBL_TABLE_TOGGLER_INFO' => 'Parādiet vai paslēpiet kolonnas un ievelciet tās vēlamajā secībā.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'Izpildlaika filtri',
    'LBL_FILTER_CONDITION' => 'Atlasīt nosacījumu',
    'LBL_FILTER_VALUES' => 'Vērtības',
    'LBL_TABLE_EXPAND' => 'Izvērst visus',
    'LBL_TABLE_COLLAPSE' => 'Savērst visus',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'Servera kļūda. Nevarēja ielādēt atbilstošos izpildlaika filtrus.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Pub/Sub moduļa notikumu pašpiegādes abonementi',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Pub/Sub moduļa notikumu pašpiegādes abonements',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'Panelis - augšā',
    'panel_bottom' => 'Panelis - apakšā',
    'tab_first' => 'Cilne - pirmā',
    'tab_last' => 'Cilne - pēdējā',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'Pēdējās 7 dienās',
    '30' => 'Pēdējās 30 dienās',
    '90' => 'Pēdējā ceturksnī',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'Šodien',
    'future' => 'Nākotnē',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'Jā',
    'group' => 'Nē',
];

$app_list_strings['history_filter_options'] = [
    7 => 'Pēdējās 7 dienās',
    30 => 'Pēdējās 30 dienās',
    90 => 'Pēdējā ceturksnī',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'Jā',
    'group' => 'Nē',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'Jā',
    'group' => 'Nē',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'Jā',
    '0' => 'Nē',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'Šajā ceturksnī',
    'next' => 'Nākamajā ceturksnī',
    'year' => 'Šajā gadā',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'Mani ieraksti',
    'group' => 'Grupas ieraksti',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'Mana piltuve',
    'group' => 'Manas darba grupas piltuve',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'Manas prognozes',
    'group' => 'Manas grupas progrnozes',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'Iespējas',
    'RevenueLineItems' => 'Iespējas un Ieņēmumu posteņu rindas',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'Vēlākais slēgšans datums',
    'earliest' => 'Agrākais slēgšanas datums',
];

$app_list_strings['moduleList']['Library'] = 'Bibliotēka';
$app_list_strings['moduleListSingular']['Library'] = 'Bibliotēka';
$app_list_strings['library_type'] = ['Books' => 'Grāmata', 'Music' => 'Mūzika', 'DVD' => 'DVD', 'Magazines' => 'Žurnāli'];
$app_list_strings['moduleList']['EmailAddresses'] = 'E-pasta adrese';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'E-pasta adrese';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'Uzmetums',
    'in-review' => 'Vērtēšanā',
    'approved' => 'Apstiprināts',
    'published' => 'Nopublicēts',
    'expired' => 'Izbeidzies',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--Administrēšanas darbības--',
        'Create New Tag' => 'Izveidot jaunu birku',
        'Delete Tag' => 'Dzēst birku',
        'Rename Tag' => 'Pārsaukt birku',
        'Move Selected Articles' => 'Pārvietot atlasītos rakstus',
        'Apply Tags On Articles' => 'Piemērot birkas rakstiem',
        'Delete Selected Articles' => 'Izdzēst atlasītos rakstus',
    ];

$app_list_strings['moduleList']['Words'] = 'Vārdi';
$app_list_strings['moduleListSingular']['Words'] = 'Vārds';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Izveidot rakstu';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DHABI',
    'ADEN' => 'ADEN',
    'AFGHANISTAN' => 'AFGHANISTAN',
    'ALBANIA' => 'ALBANIA',
    'ALGERIA' => 'ALGERIA',
    'AMERICAN SAMOA' => 'AMERICAN SAMOA',
    'ANDORRA' => 'ANDORRA',
    'ANGOLA' => 'ANGOLA',
    'ANTARCTICA' => 'ANTARCTICA',
    'ANTIGUA' => 'ANTIGUA',
    'ARGENTINA' => 'ARGENTINA',
    'ARMENIA' => 'ARMENIA',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => 'AUSTRALIA',
    'AUSTRIA' => 'AUSTRIA',
    'AZERBAIJAN' => 'AZERBAIJAN',
    'BAHAMAS' => 'BAHAMAS',
    'BAHRAIN' => 'BAHRAIN',
    'BANGLADESH' => 'BANGLADESH',
    'BARBADOS' => 'BARBADOS',
    'BELARUS' => 'BELARUS',
    'BELGIUM' => 'BELGIUM',
    'BELIZE' => 'BELIZE',
    'BENIN' => 'BENIN',
    'BERMUDA' => 'BERMUDA',
    'BHUTAN' => 'BHUTAN',
    'BOLIVIA' => 'BOLIVIA',
    'BOSNIA' => 'BOSNIA',
    'BOTSWANA' => 'BOTSWANA',
    'BOUVET ISLAND' => 'BOUVET ISLAND',
    'BRAZIL' => 'BRAZIL',
    'BRITISH ANTARCTICA TERRITORY' => 'BRITISH ANTARCTICA TERRITORY',
    'BRITISH INDIAN OCEAN TERRITORY' => 'BRITISH INDIAN OCEAN TERRITORY',
    'BRITISH VIRGIN ISLANDS' => 'BRITISH VIRGIN ISLANDS',
    'BRITISH WEST INDIES' => 'BRITISH WEST INDIES',
    'BRUNEI' => 'BRUNEI',
    'BULGARIA' => 'BULGARIA',
    'BURKINA FASO' => 'BURKINA FASO',
    'BURUNDI' => 'BURUNDI',
    'CAMBODIA' => 'CAMBODIA',
    'CAMEROON' => 'CAMEROON',
    'CANADA' => 'CANADA',
    'CANAL ZONE' => 'CANAL ZONE',
    'CANARY ISLAND' => 'CANARY ISLAND',
    'CAPE VERDI ISLANDS' => 'CAPE VERDI ISLANDS',
    'CAYMAN ISLANDS' => 'CAYMAN ISLANDS',
    'CEVLON' => 'CEILONA',
    'CHAD' => 'CHAD',
    'CHANNEL ISLAND UK' => 'CHANNEL ISLAND UK',
    'CHILE' => 'CHILE',
    'CHINA' => 'CHINA',
    'CHRISTMAS ISLAND' => 'CHRISTMAS ISLAND',
    'COCOS (KEELING) ISLAND' => 'COCOS (KEELING) ISLAND',
    'COLOMBIA' => 'COLOMBIA',
    'COMORO ISLANDS' => 'COMORO ISLANDS',
    'CONGO' => 'CONGO',
    'CONGO KINSHASA' => 'CONGO KINSHASA',
    'COOK ISLANDS' => 'COOK ISLANDS',
    'COSTA RICA' => 'COSTA RICA',
    'CROATIA' => 'CROATIA',
    'CUBA' => 'CUBA',
    'CURACAO' => 'CURACAO',
    'CYPRUS' => 'CYPRUS',
    'CZECH REPUBLIC' => 'CZECH REPUBLIC',
    'DAHOMEY' => 'DAHOMEY',
    'DENMARK' => 'DENMARK',
    'DJIBOUTI' => 'DJIBOUTI',
    'DOMINICA' => 'DOMINICA',
    'DOMINICAN REPUBLIC' => 'DOMINICAN REPUBLIC',
    'DUBAI' => 'DUBAI',
    'ECUADOR' => 'ECUADOR',
    'EGYPT' => 'EGYPT',
    'EL SALVADOR' => 'EL SALVADOR',
    'EQUATORIAL GUINEA' => 'EQUATORIAL GUINEA',
    'ESTONIA' => 'ESTONIA',
    'ETHIOPIA' => 'ETHIOPIA',
    'FAEROE ISLANDS' => 'FAEROE ISLANDS',
    'FALKLAND ISLANDS' => 'FALKLAND ISLANDS',
    'FIJI' => 'FIJI',
    'FINLAND' => 'FINLAND',
    'FRANCE' => 'FRANCE',
    'FRENCH GUIANA' => 'FRENCH GUIANA',
    'FRENCH POLYNESIA' => 'FRENCH POLYNESIA',
    'GABON' => 'GABON',
    'GAMBIA' => 'GAMBIA',
    'GEORGIA' => 'GEORGIA',
    'GERMANY' => 'GERMANY',
    'GHANA' => 'GHANA',
    'GIBRALTAR' => 'GIBRALTAR',
    'GREECE' => 'GREECE',
    'GREENLAND' => 'GREENLAND',
    'GUADELOUPE' => 'GUADELOUPE',
    'GUAM' => 'GUAM',
    'GUATEMALA' => 'GUATEMALA',
    'GUINEA' => 'GUINEA',
    'GUYANA' => 'GUYANA',
    'HAITI' => 'HAITI',
    'HONDURAS' => 'HONDURAS',
    'HONG KONG' => 'HONG KONG',
    'HUNGARY' => 'HUNGARY',
    'ICELAND' => 'ICELAND',
    'IFNI' => 'IFNI',
    'INDIA' => 'INDIA',
    'INDONESIA' => 'INDONESIA',
    'IRAN' => 'IRAN',
    'IRAQ' => 'IRAQ',
    'IRELAND' => 'IRELAND',
    'ISRAEL' => 'ISRAEL',
    'ITALY' => 'ITALY',
    'IVORY COAST' => 'IVORY COAST',
    'JAMAICA' => 'JAMAICA',
    'JAPAN' => 'JAPAN',
    'JORDAN' => 'JORDAN',
    'KAZAKHSTAN' => 'KAZAKHSTAN',
    'KENYA' => 'KENYA',
    'KOREA' => 'KOREA',
    'KOREA, SOUTH' => 'KOREA, SOUTH',
    'KUWAIT' => 'KUWAIT',
    'KYRGYZSTAN' => 'KYRGYZSTAN',
    'LAOS' => 'LAOS',
    'LATVIA' => 'LATVIA',
    'LEBANON' => 'LEBANON',
    'LEEWARD ISLANDS' => 'LEEWARD ISLANDS',
    'LESOTHO' => 'LESOTHO',
    'LIBYA' => 'LIBYA',
    'LIECHTENSTEIN' => 'LIECHTENSTEIN',
    'LITHUANIA' => 'LITHUANIA',
    'LUXEMBOURG' => 'LUXEMBOURG',
    'MACAO' => 'MACAO',
    'MACEDONIA' => 'MACEDONIA',
    'MADAGASCAR' => 'MADAGASCAR',
    'MALAWI' => 'MALAWI',
    'MALAYSIA' => 'MALAYSIA',
    'MALDIVES' => 'MALDIVES',
    'MALI' => 'MALI',
    'MALTA' => 'MALTA',
    'MARTINIQUE' => 'MARTINIQUE',
    'MAURITANIA' => 'MAURITANIA',
    'MAURITIUS' => 'MAURITIUS',
    'MELANESIA' => 'MELANESIA',
    'MEXICO' => 'MEXICO',
    'MOLDOVIA' => 'MOLDOVIA',
    'MONACO' => 'MONACO',
    'MONGOLIA' => 'MONGOLIA',
    'MOROCCO' => 'MOROCCO',
    'MOZAMBIQUE' => 'MOZAMBIQUE',
    'MYANAMAR' => 'MYANAMAR',
    'NAMIBIA' => 'NAMIBIA',
    'NEPAL' => 'NEPAL',
    'NETHERLANDS' => 'NETHERLANDS',
    'NETHERLANDS ANTILLES' => 'NETHERLANDS ANTILLES',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'NETHERLANDS ANTILLES NEUTRAL ZONE',
    'NEW CALADONIA' => 'NEW CALADONIA',
    'NEW HEBRIDES' => 'NEW HEBRIDES',
    'NEW ZEALAND' => 'NEW ZEALAND',
    'NICARAGUA' => 'NICARAGUA',
    'NIGER' => 'NIGER',
    'NIGERIA' => 'NIGERIA',
    'NORFOLK ISLAND' => 'NORFOLK ISLAND',
    'NORWAY' => 'NORWAY',
    'OMAN' => 'OMAN',
    'OTHER' => 'OTHER',
    'PACIFIC ISLAND' => 'PACIFIC ISLAND',
    'PAKISTAN' => 'PAKISTAN',
    'PANAMA' => 'PANAMA',
    'PAPUA NEW GUINEA' => 'PAPUA NEW GUINEA',
    'PARAGUAY' => 'PARAGUAY',
    'PERU' => 'PERU',
    'PHILIPPINES' => 'PHILIPPINES',
    'POLAND' => 'POLAND',
    'PORTUGAL' => 'PORTUGAL',
    'PORTUGUESE TIMOR' => 'PORTUGUESE TIMOR',
    'PUERTO RICO' => 'PUERTO RICO',
    'QATAR' => 'QATAR',
    'REPUBLIC OF BELARUS' => 'REPUBLIC OF BELARUS',
    'REPUBLIC OF SOUTH AFRICA' => 'REPUBLIC OF SOUTH AFRICA',
    'REUNION' => 'REUNION',
    'ROMANIA' => 'ROMANIA',
    'RUSSIA' => 'RUSSIA',
    'RWANDA' => 'RWANDA',
    'RYUKYU ISLANDS' => 'RYUKYU ISLANDS',
    'SABAH' => 'SABAH',
    'SAN MARINO' => 'SAN MARINO',
    'SAUDI ARABIA' => 'SAUDI ARABIA',
    'SENEGAL' => 'SENEGAL',
    'SERBIA' => 'SERBIA',
    'SEYCHELLES' => 'SEYCHELLES',
    'SIERRA LEONE' => 'SIERRA LEONE',
    'SINGAPORE' => 'SINGAPORE',
    'SLOVAKIA' => 'SLOVAKIA',
    'SLOVENIA' => 'SLOVENIA',
    'SOMALILIAND' => 'SOMALILIAND',
    'SOUTH AFRICA' => 'SOUTH AFRICA',
    'SOUTH YEMEN' => 'SOUTH YEMEN',
    'SPAIN' => 'SPAIN',
    'SPANISH SAHARA' => 'SPANISH SAHARA',
    'SRI LANKA' => 'SRI LANKA',
    'ST. KITTS AND NEVIS' => 'ST. KITTS AND NEVIS',
    'ST. LUCIA' => 'ST. LUCIA',
    'SUDAN' => 'SUDAN',
    'SURINAM' => 'SURINAM',
    'SW AFRICA' => 'SW AFRICA',
    'SWAZILAND' => 'SWAZILAND',
    'SWEDEN' => 'SWEDEN',
    'SWITZERLAND' => 'SWITZERLAND',
    'SYRIA' => 'SYRIA',
    'TAIWAN' => 'TAIWAN',
    'TAJIKISTAN' => 'TAJIKISTAN',
    'TANZANIA' => 'TANZANIA',
    'THAILAND' => 'THAILAND',
    'TONGA' => 'TONGA',
    'TRINIDAD' => 'TRINIDAD',
    'TUNISIA' => 'TUNISIA',
    'TURKEY' => 'TURKEY',
    'UGANDA' => 'UGANDA',
    'UKRAINE' => 'UKRAINE',
    'UNITED ARAB EMIRATES' => 'UNITED ARAB EMIRATES',
    'UNITED KINGDOM' => 'UNITED KINGDOM',
    'UPPER VOLTA' => 'UPPER VOLTA',
    'URUGUAY' => 'URUGUAY',
    'US PACIFIC ISLAND' => 'US PACIFIC ISLAND',
    'US VIRGIN ISLANDS' => 'US VIRGIN ISLANDS',
    'USA' => 'USA',
    'UZBEKISTAN' => 'UZBEKISTAN',
    'VANUATU' => 'VANUATU',
    'VATICAN CITY' => 'VATICAN CITY',
    'VENEZUELA' => 'VENEZUELA',
    'VIETNAM' => 'VIETNAM',
    'WAKE ISLAND' => 'WAKE ISLAND',
    'WEST INDIES' => 'WEST INDIES',
    'WESTERN SAHARA' => 'WESTERN SAHARA',
    'YEMEN' => 'YEMEN',
    'ZAIRE' => 'ZAIRE',
    'ZAMBIA' => 'ZAMBIA',
    'ZIMBABWE' => 'ZIMBABWE',
];

$app_list_strings['state_dom'] = [
    'AL' => 'Alabama',
    'AK' => 'Alaska',
    'AZ' => 'Arizona',
    'AR' => 'Arkansas',
    'CA' => 'California',
    'CO' => 'Colorado',
    'CT' => 'Connecticut',
    'DE' => 'Delaware',
    'DC' => 'District Of Columbia',
    'FL' => 'Florida',
    'GA' => 'Georgia',
    'HI' => 'Hawaii',
    'ID' => 'Idaho',
    'IL' => 'Illinois',
    'IN' => 'Indiana',
    'IA' => 'Iowa',
    'KS' => 'Kansas',
    'KY' => 'Kentucky',
    'LA' => 'Louisiana',
    'ME' => 'Maine',
    'MD' => 'Maryland',
    'MA' => 'Massachusetts',
    'MI' => 'Michigan',
    'MN' => 'Minnesota',
    'MS' => 'Mississippi',
    'MO' => 'Missouri',
    'MT' => 'Montana',
    'NE' => 'Nebraska',
    'NV' => 'Nevada',
    'NH' => 'New Hampshire',
    'NJ' => 'New Jersey',
    'NM' => 'New Mexico',
    'NY' => 'New York',
    'NC' => 'North Carolina',
    'ND' => 'North Dakota',
    'OH' => 'Ohio',
    'OK' => 'Oklahoma',
    'OR' => 'Oregon',
    'PA' => 'Pennsylvania',
    'RI' => 'Rhode Island',
    'SC' => 'South Carolina',
    'SD' => 'South Dakota',
    'TN' => 'Tennessee',
    'TX' => 'Texas',
    'UT' => 'Utah',
    'VT' => 'Vermont',
    'VA' => 'Virginia',
    'WA' => 'Washington',
    'WV' => 'West Virginia',
    'WI' => 'Wisconsin',
    'WY' => 'Wyoming',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (Taivāna un Honkonga)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS Cyrillic)',
    'CP1252' => 'CP1252 (MS Rietumeiropa un ASV)',
    'EUC-CN' => 'EUC-CN (Vienkāršotā ķīniešu valoda GB2312)',
    'EUC-JP' => 'EUC-JP (Unix japāņu)',
    'EUC-KR' => 'EUC-KR (korejiešu)',
    'EUC-TW' => 'EUC-TW (taivāniešu)',
    'ISO-2022-JP' => 'ISO-2022-JP (japāņu)',
    'ISO-2022-KR' => 'ISO-2022-KR (korejiešu)',
    'ISO-8859-1' => 'ISO-8859-1 (Rietumeiropa un ASV)',
    'ISO-8859-2' => 'ISO-8859-2 (Centrālā un Austrumeiropa)',
    'ISO-8859-3' => 'ISO-8859-3 (latīņu 3)',
    'ISO-8859-4' => 'ISO-8859-4 (latīņu 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Cyrillic)',
    'ISO-8859-6' => 'ISO-8859-6 (arābu)',
    'ISO-8859-7' => 'ISO-8859-7 (grieķu)',
    'ISO-8859-8' => 'ISO-8859-8 (ivrits)',
    'ISO-8859-9' => 'ISO-8859-9 (latīņu 5)',
    'ISO-8859-10' => 'ISO-8859-10 (latīņu 6)',
    'ISO-8859-13' => 'ISO-8859-13 (latīņu 7)',
    'ISO-8859-14' => 'ISO-8859-14 (latīņu 8)',
    'ISO-8859-15' => 'ISO-8859-15 (latīņu 9)',
    'KOI8-R' => 'KOI8-R (Cyrillic krievu)',
    'KOI8-U' => 'KOI8-U (Cyrillic ukraiņu)',
    'SJIS' => 'SJIS (MS japāņu)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Douala' => 'Africa/Douala',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Indian/Comoro' => 'Indian/Comoro',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Asmera' => 'Africa/Asmera',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Lagos' => 'Africa/Lagos',
    'Indian/Reunion' => 'Indian/Reunion',
    'Africa/Kigali' => 'Africa/Kigali',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Dakar' => 'Africa/Dakar',
    'Indian/Mahe' => 'Indian/Mahe',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Harare' => 'Africa/Harare',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Indian/Chagos' => 'Indian/Chagos',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Rangoon' => 'Asia/Rangoon',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Beijing' => 'Asia/Beijing',
    'Asia/Harbin' => 'Asia/Harbin',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Chongqing' => 'Asia/Chongqing',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Kashgar' => 'Asia/Kashgar',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Calcutta' => 'Asia/Calcutta',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Indian/Maldives' => 'Indian/Maldives',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Katmandu' => 'Asia/Katmandu',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Saigon' => 'Asia/Saigon',
    'Asia/Aden' => 'Asia/Aden',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Sydney' => 'Australia/Sydney',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Indian/Christmas' => 'Indian/Christmas',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Indian/Cocos' => 'Indian/Cocos',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Truk' => 'Pacific/Truk',
    'Pacific/Ponape' => 'Pacific/Ponape',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Johnston' => 'Pacific/Johnston',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'Europe/London' => 'Europe/London',
    'Europe/Dublin' => 'Europe/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Brussels' => 'Europe/Brussels',
    'Europe/Sofia' => 'Europe/Sofia',
    'Europe/Prague' => 'Europe/Prague',
    'Europe/Copenhagen' => 'Europe/Copenhagen',
    'Atlantic/Faeroe' => 'Atlantic/Faeroe',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Godthab' => 'America/Godthab',
    'America/Thule' => 'America/Thule',
    'Europe/Tallinn' => 'Europe/Tallinn',
    'Europe/Helsinki' => 'Europe/Helsinki',
    'Europe/Paris' => 'Europe/Paris',
    'Europe/Berlin' => 'Europe/Berlin',
    'Europe/Gibraltar' => 'Europe/Gibraltar',
    'Europe/Athens' => 'Europe/Athens',
    'Europe/Budapest' => 'Europe/Budapest',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Europe/Rome' => 'Europe/Rome',
    'Europe/Riga' => 'Europe/Riga',
    'Europe/Vaduz' => 'Europe/Vaduz',
    'Europe/Vilnius' => 'Europe/Vilnius',
    'Europe/Luxembourg' => 'Europe/Luxembourg',
    'Europe/Malta' => 'Europe/Malta',
    'Europe/Chisinau' => 'Europe/Chisinau',
    'Europe/Monaco' => 'Europe/Monaco',
    'Europe/Amsterdam' => 'Europe/Amsterdam',
    'Europe/Oslo' => 'Europe/Oslo',
    'Europe/Warsaw' => 'Europe/Warsaw',
    'Europe/Lisbon' => 'Europe/Lisbon',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Europe/Bucharest' => 'Europe/Bucharest',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Samara' => 'Europe/Samara',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Madrid' => 'Europe/Madrid',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Zurich' => 'Europe/Zurich',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'America/New_York' => 'America/New_York',
    'America/Chicago' => 'America/Chicago',
    'America/North_Dakota/Center' => 'America/North_Dakota/Center',
    'America/Denver' => 'America/Denver',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Juneau' => 'America/Juneau',
    'America/Yakutat' => 'America/Yakutat',
    'America/Anchorage' => 'America/Anchorage',
    'America/Nome' => 'America/Nome',
    'America/Adak' => 'America/Adak',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'America/Phoenix' => 'America/Phoenix',
    'America/Boise' => 'America/Boise',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Detroit' => 'America/Detroit',
    'America/Menominee' => 'America/Menominee',
    'America/St_Johns' => 'America/St_Johns',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Halifax' => 'America/Halifax',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Montreal' => 'America/Montreal',
    'America/Toronto' => 'America/Toronto',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Nipigon' => 'America/Nipigon',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Regina' => 'America/Regina',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Edmonton' => 'America/Edmonton',
    'America/Vancouver' => 'America/Vancouver',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Coral_Harbour' => 'America/Coral_Harbour',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Yellowknife' => 'America/Yellowknife',
    'America/Inuvik' => 'America/Inuvik',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Dawson' => 'America/Dawson',
    'America/Cancun' => 'America/Cancun',
    'America/Merida' => 'America/Merida',
    'America/Monterrey' => 'America/Monterrey',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Tijuana' => 'America/Tijuana',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Nassau' => 'America/Nassau',
    'America/Barbados' => 'America/Barbados',
    'America/Belize' => 'America/Belize',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'America/Cayman' => 'America/Cayman',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Havana' => 'America/Havana',
    'America/Dominica' => 'America/Dominica',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Jamaica' => 'America/Jamaica',
    'America/Martinique' => 'America/Martinique',
    'America/Montserrat' => 'America/Montserrat',
    'America/Managua' => 'America/Managua',
    'America/Panama' => 'America/Panama',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/Miquelon' => 'America/Miquelon',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Tortola' => 'America/Tortola',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/La_Paz' => 'America/La_Paz',
    'America/Noronha' => 'America/Noronha',
    'America/Belem' => 'America/Belem',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Recife' => 'America/Recife',
    'America/Araguaina' => 'America/Araguaina',
    'America/Maceio' => 'America/Maceio',
    'America/Bahia' => 'America/Bahia',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Manaus' => 'America/Manaus',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santiago' => 'America/Santiago',
    'Pacific/Easter' => 'Pacific/Easter',
    'America/Bogota' => 'America/Bogota',
    'America/Curacao' => 'America/Curacao',
    'America/Guayaquil' => 'America/Guayaquil',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'America/Cayenne' => 'America/Cayenne',
    'America/Guyana' => 'America/Guyana',
    'America/Asuncion' => 'America/Asuncion',
    'America/Lima' => 'America/Lima',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Montevideo' => 'America/Montevideo',
    'America/Caracas' => 'America/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'Favorīti';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'Favorīts';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google kontakti',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'Pieprasīts',
    2 => 'Piekļuve',
    3 => 'Nederīgs',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugar lietotājs',
    'support_portal' => 'Atbalsta portāls',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'Kampaņa',
    'email' => 'Jebkāds e-pasts',
    'workflow' => 'Darbplūsma',
    'system' => 'Sistēma',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'Kampaņa',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'Kampaņa',
    'email' => 'Jebkāds e-pasts',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'Dokumentācija',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'Divi diapazoni',
    'show_buckets' => 'Trīs diapazoni',
    'show_custom_buckets' => 'Pielāgotie diapazoni',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'Kalendāra gads',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'Ikgadējs (ar kvartālu apakšperiodiem)',
    'Quarter' => 'Kvartāla (ar mēneša apakšperiodiem )',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'Ieņēmumu posteņi',
    'Opportunities' => 'Iespējas',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'Jā',
    'no' => 'Nē',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'Brīdinājums',
    'information' => 'Informācija',
    'other' => 'Cits',
    'success' => 'Veiksmīgi',
    'warning' => 'Brīdinājums',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'SŪTĪT',
    'GET' => 'SAŅEMT',
    'PUT' => 'IEVIETOT',
    'DELETE' => 'DZĒST',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'Manuāli',
    '5' => 'Ik pēc 5 minūtēm',
    '15' => 'Ik pēc 15 minūtēm',
    '30' => 'Ik pēc 30 minūtēm',
    '60' => 'Ik pēc stundas',
];

$app_list_strings['moduleList']['KBDocuments'] = 'Zināšanu Bāzes dokuments';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'Zināšanu Bāzes dokuments';
$app_list_strings['moduleList']['KBContents'] = 'Zināšanu bāze';
$app_list_strings['moduleListSingular']['KBContents'] = 'Zināšanu bāzes raksts';
$app_list_strings['moduleList']['KBArticles'] = 'Zināšanu bāzes raksts';
$app_list_strings['moduleListSingular']['KBArticles'] = 'Zināšanu bāzes raksts';
$app_list_strings['moduleList']['KBContentTemplates'] = 'Zināšanu bāzes veidnis';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'Zināšanu bāzes veidnis';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'Iegultie faili';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'Iegultais fails';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Leks',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leki',
    'USD' => 'Dolāri',
    'AFN' => 'Afgāns',
    'ARS' => 'Peso',
    'AWG' => 'Guldeņi',
    'AUD' => 'Dolāri',
    'AZN' => 'Jaunie manati',
    'BSD' => 'Dolāri',
    'BBD' => 'Dolāri',
    'BYR' => 'Rubļi',
    'EUR' => 'Eiro',
    'BZD' => 'Dolāri',
    'BMD' => 'Dolāri',
    'BOB' => 'Boliviano',
    'BAM' => 'Konvertējama marka',
    'BWP' => 'Pulas',
    'BGN' => 'Leva',
    'BRL' => 'Reāli',
    'GBP' => 'Mārciņas',
    'BND' => 'Dolāri',
    'KHR' => 'Riēli',
    'CAD' => 'Dolāri',
    'KYD' => 'Dolāri',
    'CLP' => 'Peso',
    'CNY' => 'Ķīnas juaņas',
    'COP' => 'Peso',
    'CRC' => 'ColÃ³n',
    'HRK' => 'Kuna',
    'CUP' => 'Peso',
    'CZK' => 'Čehijas kronas',
    'DKK' => 'Kronas',
    'DOP' => 'Peso',
    'XCD' => 'Dolāri',
    'EGP' => 'Mārciņas',
    'SVC' => 'Koloni',
    'EEK' => 'Igaunijas kronas',
    'FKP' => 'Mārciņas',
    'FJD' => 'Dolāri',
    'GHC' => 'Cedis',
    'GIP' => 'Mārciņas',
    'GTQ' => 'Kvetsali',
    'GGP' => 'Mārciņas',
    'GYD' => 'Dolāri',
    'HNL' => 'Lempiras',
    'HKD' => 'Dolāri',
    'HUF' => 'Forinti',
    'ISK' => 'Islandes kronas',
    'INR' => 'Rūpijas',
    'IDR' => 'Indonēzijas rūpijas',
    'IRR' => 'Riāli',
    'IMP' => 'Mārciņas',
    'ILS' => 'Jaunie šekeļi',
    'JMD' => 'Dolāri',
    'JPY' => 'Jēnas',
    'JEP' => 'Mārciņas',
    'KZT' => 'Tenge',
    'KPW' => 'Vona',
    'KRW' => 'Vona',
    'KGS' => 'Somi',
    'LAK' => 'Kipi',
    'LVL' => 'Lati',
    'LBP' => 'Mārciņas',
    'LRD' => 'Dolāri',
    'CHF' => 'Šveices franki',
    'LTL' => 'Liti',
    'MKD' => 'Denāri',
    'MYR' => 'Ringiti',
    'MUR' => 'Rūpijas',
    'MXN' => 'Peso',
    'MNT' => 'Tugriki',
    'MZN' => 'Metikali',
    'NAD' => 'Dolāri',
    'NPR' => 'Rūpijas',
    'ANG' => 'Guldeņi',
    'NZD' => 'Dolāri',
    'NIO' => 'Kordobas',
    'NGN' => 'Nairas',
    'NOK' => 'Krona',
    'OMR' => 'Riāli',
    'PKR' => 'Rūpijas',
    'PAB' => 'Balboa',
    'PYG' => 'Gvarani',
    'PEN' => 'Jaunie soli',
    'PHP' => 'Peso',
    'PLN' => 'Zloti',
    'QAR' => 'Riāli',
    'RON' => 'Jaunās lejas',
    'RUB' => 'Rubļi',
    'SHP' => 'Mārciņas',
    'SAR' => 'Riāli',
    'RSD' => 'Dināri',
    'SCR' => 'Rūpijas',
    'SGD' => 'Dolāri',
    'SBD' => 'Dolāri',
    'SOS' => 'Šiliņi',
    'ZAR' => 'Rands',
    'LKR' => 'Rūpijas',
    'SEK' => 'Zviedru krona',
    'SRD' => 'Dolāri',
    'SYP' => 'Mārciņas',
    'TWD' => 'Jaunie dolāri',
    'THB' => 'Bati',
    'TTD' => 'Dolāri',
    'TRY' => 'Lira',
    'TRL' => 'Liras',
    'TVD' => 'Dolāri',
    'UAH' => 'Grivnas',
    'UYU' => 'Peso',
    'UZS' => 'Sumi',
    'VEF' => 'Venecuēlas bolivāri',
    'VND' => 'Dongs',
    'YER' => 'Riāli',
    'ZWD' => 'Zimbabves dolāri',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'Ļoti augsts',
    '4' => 'Augsts',
    '3' => 'Neitrāls',
    '2' => 'Zems',
    '1' => 'Ļoti zems',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'Nav',
    'future' => 'Pašreizējā vērtība',
    'old' => 'Vecā vērtība',
    'both' => 'Pašreizējā un vecā vērtība',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Viena soļa',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'Apstrāde',
    'error' => 'Kļūda',
    'success' => 'Veiksmīgi',
    'canceled' => 'Atcelts',
    'document_load' => 'Veidnes ielāde',
    'tags_extract' => 'Birku izgūšana',
    'tags_validate' => 'Birku validācija',
    'data_retrieving' => 'Datu izguve',
    'serialize_document' => 'Dokumenta salikšana',
    'send_document' => 'Dokumenta nosūtīšana jums',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'Sapludināt',
    'convert' => 'PDF sapludināšana',
    'multimerge' => 'Vairāku sapludināšana',
    'multimerge_convert' => 'Sapludināt vairākus PDF',
    'labelsgenerate' => 'Ģenerēt etiķetes',
    'labelsgenerate_convert' => 'Ģenerēt etiķetes PDF',
    'excel' => 'Excel sapludināšana',
    'excel_convert' => 'Excel sapludināšanas konvertēšana',
    'presentation' => 'PowerPoint sapludināšana',
    'presentation_convert' => 'PowerPoint sapludināšana PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'Mani uzņēmumi',
    'favorites' => 'Izlases uzņēmumi',
    'tags' => 'Uzņēmumi ar birku',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'Visas ziņas',
    'General' => 'Vispārīgi',
    'Finance' => 'Finanšu',
    'People' => 'Personāla',
    'Press Releases' => 'Preses relīzes',
    'Other' => 'Cits',
];

$app_strings['LBL_OWNERS'] = 'Īpašnieki';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Mākoņa disks';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'Mākoņa diska integrācijas informācijas lauks';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'Kopēt saiti';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'Lejupielādēt';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Izveidot Sugar dokumentu';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'Šo failu nevar lejupielādēt';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'Nav mākoņa informācijas lauka';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar dokuments izveidots';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'Nosūtīt uz DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign nav pieejams no šīs atrašanās vietas.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'Dokumentu sapludināšana programmā Word/Excel/PowerPoint nav pieejama no šīs atrašanās vietas';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'Dokumentu sapludināšana uz DocuSign nav pieejams no šīs atrašanās vietas';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'Dokumentu sapludināšana uz PDF nav pieejams no šīs atrašanās vietas';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'Jūsu parakstītais fails tiks augšupielādēts šeit tikai tad, ja jums ir atļauja augšupielādēt šajā atrašanās vietā.';
$app_strings['LBL_DOC_MERGE_TO'] = 'Dokumentu sapludināšana uz';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'Mani faili';
$app_strings['LBL_SHARED_WITH_ME'] = 'Koplietots ar mani';
$app_strings['LBL_CLOUD_PROVIDER'] = 'Mākoņa pakalpojumu sniedzējs';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox disks',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'Koplietots ar mani';
$app_strings['LBL_MY_FILES'] = 'Mani faili';
$app_strings['LBL_UPLOAD_FILE'] = 'Augšupielādēt failu';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'Mape nav atrasta';
$app_strings['LBL_CREATE_FOLDER'] = 'Izveidot mapi';
$app_strings['LBL_LOAD_MORE'] = 'Ielādēt vairāk...';
$app_strings['LBL_NEW_FOLDER'] = 'Jauna mape';
$app_strings['LBL_FOLDER_NAME'] = 'Mapes nosaukums: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'Pašreizējā ceļā jums nav atļaujas to darīt.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'Jums nav atļaujas iet pa pašreizējo ceļu.';
$app_strings['LBL_FILE_UPLOADED'] = 'Fails ir augšupielādēts.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'Faila lielā izmēra dēļ augšupielāde prasīs kādu laiku.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'Vienam vai vairākiem dokumenta ierakstiem nav pievienota faila. Pievienojiet ierakstiem failus un mēģiniet vēlreiz vai atsevišķi sinhronizējiet konkrētus ierakstus ar failiem.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Savienojums ar Google nav atrasts...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Savienojums ar Microsoft nav atrasts...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Savienojums ar Dropbox nav atrasts...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'Sinhronizācija ar OneDrive var aizņemt kādu laiku';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'Vai tiešām vēlaties dzēst šo failu?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDrive augšupielādē ir pabeigta.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' ir veiksmīgi augšupielādēts.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'Kļūda, ielādējot ceļus.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'Ir radusies kļūda, jo fails ir bojāts.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'Dokuments <i>"{{documentName}}"</i> ir saglabāts jūsu mākoņa diskā un pievienots Dokumentu modulim.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'Jums nav atļauts dzēst šo failu.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'Jums nav atļauts dzēst šo mapi.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'Jums nav atļauts augšupielādēt failus šajā atrašanās vietā.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'Jums nav atļauts izvedot mapi šajā atrašanās vietā.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'Šajā atrašanās vietā nevar izveidot mapes.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'Failus nevar augšupielādēt šajā atrašanās vietā.';
$app_strings['LBL_SITES'] = 'Vietnes';
$app_strings['LBL_SHARED'] = 'Koplietots';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'Saite izveidota. Noklikšķiniet uz pogas, lai kopētu saiti starpliktuvē.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'Kopēt starpliktuvē';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-tukšs-',
    'Exact' => 'Tieši',
    'Null_address_components' => 'Viens vai vairāki adreses komponenti ir tukši',
    'Invalid_address' => 'Nederīga adrese, serveris atgrieza vērtību Nepatiess',
    'Invalid_server_response_not_XML' => 'Nederīga servera atbilde, nav XML',
    'Invalid_address_no_location' => 'Nederīga adrese, serveris neatgrieza atrašanās vietu',
    'Ambiguous_address' => 'Neskaidra adrese, vairākas atbilstības',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'Ceļš',
    'a' => 'Gaisa',
    'rd' => 'Tumšs ceļš',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'Angļu (ASV)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'Ņujorka (est)'],
    ['pst', 'Losandželosa (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['Jauns', 'Jauns'],
    ['Piešķirts', 'Piešķirts'],
    ['Slēgts', 'Slēgts'],
    ['Gaida ievadi', 'Gaida ievadi'],
    ['Noraidīts', 'Noraidīts'],
    ['Dublēt', 'Dublēt'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['Administrēšana', 'Administrēšana'],
    ['Produkts', 'Produkts'],
    ['Liietotājs', 'Liietotājs'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'Augsts'],
    ['P2', 'Vidējs'],
    ['P3', 'Zems'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['lietotājs', 'Lietotājs'],
    ['administrators, lietotājs', 'Administrators'],
    ['konta pārvaldnieks,lietotājs', 'Konta pārvaldnieks'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['pēdējās_30_dienas', 'Pēdējās 30 dienas'],
    ['pēdejās_90_dienas', 'Pēdējās 90 dienas'],
    ['šo_gad', 'Pagājušais gads'],
    ['pielāgot', 'Pielāgots diapazons'],
    ['viss', 'Viss'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['Noklusējuma', 'Noklusējuma'],
    ['Krāsa', 'Vienkrāsains'],
    ['Url', 'Pielāgot attēlu'],
];
