<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => '영어(미국)',
    'moduleList' => [
        'Home' => '홈',
        'Contacts' => '연락처',
        'Accounts' => '거래처',
        'Opportunities' => '영업기회',
        'Cases' => '사례 목록',
        'Notes' => '노트',
        'Calls' => '전화 목록',
        'Emails' => '이메일',
        'Meetings' => '회의 목록',
        'Tasks' => '업무내역',
        'Calendar' => '캘린더',
        'Leads' => '관심고객',
        'Currencies' => '통화',
        'Contracts' => '계약목록',
        'Quotes' => '견적 목록',
        'Products' => '견적 상품 목록',
        'WebLogicHooks' => '웹 논리 후크',
        'ProductCategories' => '상품 범주',
        'ProductTypes' => '상품 유형목록',
        'ProductTemplates' => '상품 책자',
        'ProductBundles' => '제품 번들',
        'ProductBundleNotes' => '제품 번들 참고',
        'Reports' => '보고서',
        'Forecasts' => '예측치',
        'ForecastWorksheets' => '예측 워크시트',
        'ForecastManagerWorksheets' => '예측 관리자 워크시트',
        'VisualPipeline' => '비주얼 파이프라인',
        'ConsoleConfiguration' => '콘솔 설정',
        'SugarLive' => 'SugarLive',
        'Quotas' => '견적',
        'Teams' => '팀',
        'TeamNotices' => '팀 알림',
        'Manufacturers' => '제조자',
        'Activities' => '활동내역',
        'Comments' => '의견',
        'Subscriptions' => '구독',
        'Bugs' => '결함',
        'Feeds' => 'RSS',
        'iFrames' => '내 사이트',
        'TimePeriods' => '시간 및 분기',
        'TaxRates' => '세율',
        'ContractTypes' => '계약 유형',
        'Schedulers' => '일정 관리',
        'Project' => '프로젝트',
        'ProjectTask' => '프로젝트 과제',
        'Campaigns' => '캠페인 목록',
        'CampaignLog' => '캠페인 일지',
        'CampaignTrackers' => '캠페인 추적',
        'Documents' => '문서 목록',
        'DocumentRevisions' => '문서 개정',
        'Connectors' => '연결기',
        'Notifications' => '알림',
        'Sync' => '일치화',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => '외부 사용자',
        'ReportMaker' => '상위 보고서',
        'DataSets' => '데이터형식',
        'CustomQueries' => '고객 문의사항 목록',
        'pmse_Inbox' => '프로세스',
        'pmse_Project' => '프로세스 정의',
        'pmse_Business_Rules' => '프로세스 비즈니스 규칙',
        'pmse_Emails_Templates' => '공정 이메일 템플릿',
        'BusinessCenters' => '업무 센터',
        'Shifts' => '교대',
        'ShiftExceptions' => '교대 예외',
        'Purchases' => '구매',
        'PurchasedLineItems' => '구매한 라인아이템',
        'MobileDevices' => '모바일 장치',
        'PushNotifications' => '푸시 알림',
        'Escalations' => '에스컬레이션',
        'DocumentTemplates' => '문서 템플릿',
        'DocumentMerges' => '문서 병합',
        'CloudDrivePaths' => '클라우드 드라이브 경로',
        'WorkFlow' => '작업흐름 정의',
        'EAPM' => '외부 계정',
        'Worksheet' => '워크시트',
        'Users' => '사용자',
        'Employees' => '직원목록:',
        'Administration' => '관리자',
        'ACLRoles' => '역할',
        'InboundEmail' => '그룹 메일 계정',
        'Releases' => '발매',
        'Prospects' => '목표고객 목록',
        'Queues' => '대기',
        'EmailMarketing' => '이메일 마케팅 관리',
        'EmailTemplates' => '이메일 템플릿',
        'SNIP' => '이메일 보관',
        'ProspectLists' => '목표고객 목록',
        'SavedSearch' => '저장된 검색결과 관리',
        'UpgradeWizard' => '업그레이드 마법사',
        'Trackers' => '추적장치',
        'TrackerPerfs' => '추적 수행',
        'TrackerSessions' => '추적 세션',
        'TrackerQueries' => '추적 문의',
        'FAQ' => '자주묻는질문',
        'Newsletters' => '뉴스레터',
        'SugarFavorites' => '즐겨찾기',
        'PdfManager' => 'PDF 관리',
        'DataArchiver' => '데이터 아카이버',
        'ArchiveRuns' => '아카이브 실행',

        'OAuthKeys' => 'OAuth Key 인증',
        'OAuthTokens' => '인증 표시',
        'Filters' => '필터',
        'UserSignatures' => '이메일 서명',
        'Shippers' => '배송자',
        'Styleguide' => '스타일 가이드',
        'Feedbacks' => '피드백',
        'Tags' => '태그',
        'Categories' => '범주',
        'Dashboards' => '대시보드',
        'OutboundEmail' => '이메일 설정',
        'EmailParticipants' => '이메일 참가자',
        'DataPrivacy' => '데이터 프라이버시',
        'ReportSchedules' => '보고서 일정',
        'CommentLog' => '의견 로그',
        'Holidays' => '공휴일',
        'ChangeTimers' => '타이머 변경',
        'Metrics' => '측정 항목',
        'Messages' => '메세지',
        'Audit' => '회계감사',
        'RevenueLineItems' => '매출 라인 품목',
        'DocuSignEnvelopes' => 'DocuSign 봉투',
        'Geocode' => '지오코드',
        'DRI_Workflows' => 'Smart Guides',
        'DRI_Workflow_Task_Templates' => 'Smart Guide 활동 템플릿',
        'DRI_SubWorkflows' => 'Smart Guide 단계',
        'DRI_Workflow_Templates' => 'Smart Guide 템플릿',
        'CJ_WebHooks' => 'Sugar Automate 웹훅',
        'CJ_Forms' => 'Smart Guide Sugar 액션',
        'DRI_SubWorkflow_Templates' => 'Smart Guide 단계 템플릿',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub 모듈 이벤트 푸시 구독',
    ],

    'moduleIconList' => [
        'Home' => '홈',
        'Contacts' => '연락',
        'Accounts' => '계정',
        'Opportunities' => '영업',
        'Cases' => '사례',
        'Notes' => '메모',
        'Calls' => '전화',
        'Emails' => '이메일',
        'Meetings' => '회의',
        'Tasks' => '작업',
        'Calendar' => '달력',
        'Leads' => '관심심',
        'Currencies' => '화폐',
        'Contracts' => '계약',
        'Quotes' => '견적',
        'Products' => '제품',
        'WebLogicHooks' => '웹로직',
        'ProductCategories' => 'PG',
        'ProductTypes' => '상품유형',
        'ProductTemplates' => '상품템플릿',
        'ProductBundles' => '상품묶음',
        'ProductBundleNotes' => '상품묶음노트',
        'Reports' => '보고',
        'Forecasts' => '예상',
        'ForecastWorksheets' => '예상워크시트',
        'ForecastManagerWorksheets' => '예상관리워크시트',
        'Quotas' => 'FO',
        'VisualPipeline' => '비주얼파이프라인',
        'ConsoleConfiguration' => '콘솔설정',
        'SugarLive' => 'SugarLive',
        'Teams' => '팀팀',
        'TeamNotices' => '팀공지',
        'Manufacturers' => '제조자',
        'Activities' => '활동',
        'Comments' => '의견',
        'Subscriptions' => '구독',
        'Bugs' => '버그',
        'Feeds' => '피드',
        'iFrames' => '아이프레임',
        'TimePeriods' => '기간',
        'TaxRates' => '세율',
        'ContractTypes' => '계약유형',
        'Schedulers' => '일정관리',
        'Project' => '프로젝트',
        'ProjectTask' => '프로젝트과제',
        'Campaigns' => '캠페인',
        'CampaignLog' => 'CL',
        'CampaignTrackers' => '캠페인추적기',
        'Documents' => '문서서',
        'DocumentRevisions' => '문서개정',
        'Connectors' => '연결기',
        'Notifications' => '알림',
        'Sync' => '동기화',
        'HintAccountsets' => 'Hint계정설정',
        'HintNotificationTargets' => 'Hint알림대상',
        'HintNewsNotifications' => 'Hint뉴스알림',
        'HintEnrichFieldConfigs' => 'Hint보강필드구성',
        'ExternalUsers' => '외부사용자',
        'ReportMaker' => '보고서만들기',
        'DataSets' => '데이터세트',
        'CustomQueries' => '고객문의사항',
        'pmse_Inbox' => 'pmse편지함',
        'pmse_Project' => 'pmse프로젝트',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE비즈니스규칙',
        'BusinessCenters' => 'BC',
        'Shifts' => '교대',
        'ShiftExceptions' => '교대예외',
        'Purchases' => '구매',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => '모바일장치',
        'PushNotifications' => '푸시알림',
        'Escalations' => '에스컬레이션',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => '워크플로',
        'EAPM' => 'EAPM',
        'Worksheet' => '워크시트',
        'Users' => '사용자',
        'Employees' => '직원',
        'Administration' => '관리',
        'ACLRoles' => 'ACL역할',
        'InboundEmail' => '수신이메일',
        'Releases' => '릴리즈',
        'Prospects' => '전망',
        'Queues' => '대기',
        'EmailMarketing' => '이메일마케팅',
        'EmailTemplates' => '이메일템플릿',
        'SNIP' => 'SNIP',
        'ProspectLists' => '잠재고객목록',
        'SavedSearch' => '저장된검색',
        'UpgradeWizard' => '업그레이드마법사',
        'Trackers' => '추적기',
        'TrackerPerfs' => '추적기수행',
        'TrackerSessions' => 'TS',
        'TrackerQueries' => '추적기문의',
        'FAQ' => 'FAQ',
        'Newsletters' => '뉴스레터',
        'SugarFavorites' => 'Sugar즐겨찾기',
        'PdfManager' => 'PDF관리',
        'DataArchiver' => '데이터아카이버',
        'ArchiveRuns' => '아카이브실행',
        'OAuthKeys' => '인증키',
        'OAuthTokens' => '인증토큰',
        'Filters' => '필터',
        'UserSignatures' => '사용자서명',
        'Shippers' => '배송자',
        'Styleguide' => '스타일가이드',
        'Feedbacks' => '피드백',
        'Tags' => '태그',
        'Categories' => '범주',
        'Dashboards' => 'Ds',
        'OutboundEmail' => '발신이메일',
        'EmailParticipants' => '이메일참가자',
        'DataPrivacy' => '데이터 프라이버시',
        'ReportSchedules' => '보고일정',
        'CommentLog' => '의견로그',
        'Holidays' => '휴일',
        'ChangeTimers' => '타이머 변경',
        'Metrics' => '측정항목',
        'Messages' => '메시지',
        'Audit' => '감사',
        'RevenueLineItems' => '매출라인아이템',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => '지오코드',
        'DRI_Workflows' => 'DRI워크플로',
        'DRI_Workflow_Task_Templates' => 'DRI 워크플로 과제 템플릿',
        'DRI_SubWorkflows' => 'DRI서브워크플로',
        'DRI_Workflow_Templates' => 'DRI 워크플로 템플릿',
        'CJ_WebHooks' => 'CJ웹훅',
        'CJ_Forms' => 'CJ폼',
        'DRI_SubWorkflow_Templates' => 'DRI 서브워크플로 템플릿',
        'Library' => '라이브러리',
        'EmailAddresses' => '이메일주소',
        'Words' => '단어',
        'Sugar_Favorites' => 'Sugar즐겨찾기',
        'KBDocuments' => 'KB문서',
        'KBContents' => 'KB콘텐츠',
        'KBArticles' => 'KB조항',
        'KBContentTemplates' => 'KB콘텐츠템플릿',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => '임베드파일',
    ],

    'moduleListSingular' => [
        'Home' => '홈',
        'Dashboards' => '대시보드',
        'Styleguide' => '스타일 가이드',
        'Contacts' => '연락처',
        'Accounts' => '거래처',
        'Opportunities' => '예비고객',
        'Cases' => '사례',
        'Notes' => '메모',
        'Calls' => '전화상담',
        'Emails' => '다른 이메일:',
        'Meetings' => '회의',
        'Tasks' => '과제',
        'Calendar' => '캘린더',
        'Leads' => '관심고객:',
        'Manufacturers' => '제조자',
        'VisualPipeline' => '비주얼파이프라인',
        'ConsoleConfiguration' => '콘솔설정',
        'MobileDevices' => '모바일 장치',
        'SugarLive' => 'SugarLive',
        'Contracts' => '계약',
        'Quotes' => '견적',
        'Products' => '견적 라인아이템',
        'ProductCategories' => '상품 범주',
        'ProductBundles' => '제품 번들',
        'ProductBundleNotes' => '제품 번들 참고',
        'RevenueLineItems' => '매출라인 품목',
        'WebLogicHooks' => '상품 범주',
        'Reports' => '보고서',
        'Forecasts' => '예상',
        'ForecastWorksheets' => '예상기획 워크시트',
        'ForecastManagerWorksheets' => '예측 관리자 워크시트',
        'Quotas' => '견적',
        'Teams' => '팀:',
        'TeamNotices' => '팀 알림',
        'Activities' => '예정된 활동',
        'ActivityStream' => '활동내역',
        'Bugs' => '버그',
        'Feeds' => 'RSS',
        'iFrames' => '내 사이트',
        'TimePeriods' => '기간',
        'TaxRates' => '세율',
        'ContractTypes' => '계약 유형',
        'Schedulers' => '일정 관리',
        'Campaigns' => '캠페인',
        'CampaignLog' => '캠페인 일지',
        'Project' => '프로젝트',
        'ProjectTask' => '프로젝트 과제',
        'Prospects' => '목표고객',
        'ProspectLists' => '목표고객 목록',
        'CampaignTrackers' => '캠페인 추적',
        'Documents' => '문서',
        'DocumentRevisions' => '문서 개정',
        'Connectors' => '연결기',
        'Notifications' => '알림',
        'Sync' => '동기화',
        'PdfManager' => 'PDF 관리',
        'DataArchiver' => '데이터 아카이버',
        'ArchiveRuns' => '아카이브 실행',
        'ExternalUsers' => '외부 사용자',
        'ReportMaker' => ' 상위 보고서',
        'DataSets' => '데이타 형식',
        'CustomQueries' => '고객 문의사항',
        'pmse_Inbox' => '프로세스',
        'pmse_Project' => '프로세스 정의',
        'pmse_Business_Rules' => '프로세스 비즈니스 규칙',
        'pmse_Emails_Templates' => '이메일 템플릿 프로세스',
        'BusinessCenters' => '업무 센터',
        'Shifts' => '교대',
        'ShiftExceptions' => '교대 예외',
        'Purchases' => '구매',
        'PurchasedLineItems' => '구매한 라인아이템',
        'PushNotifications' => '푸시 알림',
        'Escalations' => '에스컬레이션',
        'DocumentTemplates' => '문서 템플릿',
        'DocumentMerges' => '문서 병합',
        'CloudDrivePaths' => '클라우드 드라이브 경로',
        'WorkFlow' => '작업흐름',
        'EAPM' => '외부 계정',
        'Worksheet' => '워크시트',
        'Users' => '사용자',
        'SugarFavorites' => 'Sugar즐겨찾기',
        'Employees' => '직원',
        'Administration' => '관리자',
        'ACLRoles' => '역할:',
        'InboundEmail' => '그룹 메일 계정',
        'Releases' => '발매:',
        'Queues' => '대기',
        'EmailMarketing' => '이메일 마케팅 관리',
        'EmailTemplates' => '이메일 템플릿',
        'SNIP' => '이메일 보관',
        'SavedSearch' => '저장된 검색결과',
        'UpgradeWizard' => '업그레이드 마법사',
        'Trackers' => '추적기',
        'TrackerPerfs' => '추적 수행',
        'TrackerSessions' => '추적 세션',
        'TrackerQueries' => '추적기 문의사항',
        'FAQ' => '자주묻는질문',
        'Newsletters' => '뉴스레터',
        'OAuthKeys' => '소비자키 인증',
        'OAuthTokens' => '권한 표시',
        'Filters' => '필터',
        'Comments' => '의견',
        'CommentLog' => '의견 로그',
        'Currencies' => '화폐',
        'ProductTemplates' => 'Product',
        'ProductTypes' => '제품 유형',
        'Shippers' => '배송자',
        'Subscriptions' => '구독',
        'UserSignatures' => '이메일 서명',
        'Feedbacks' => '피드백',
        'Tags' => '태그',
        'Categories' => '범주',
        'OutboundEmail' => '이메일 설정',
        'EmailParticipants' => '이메일 참가자',
        'DataPrivacy' => '데이터 프라이버시',
        'ReportSchedules' => '보고서 일정',
        'Holidays' => '공휴일',
        'ChangeTimers' => '타이머 변경',
        'Metrics' => '미터법',
        'Messages' => '메세지',
        'Audit' => '회계감사',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => '지오코드',
        'DRI_Workflows' => 'Smart Guide',
        'DRI_Workflow_Task_Templates' => 'Smart Guide 활동 템플릿',
        'DRI_SubWorkflows' => 'Smart Guide 단계',
        'DRI_Workflow_Templates' => 'Smart Guide 템플릿',
        'CJ_WebHooks' => 'Sugar Automate 웹훅',
        'CJ_Forms' => 'Smart Guide Sugar 액션',
        'DRI_SubWorkflow_Templates' => 'Smart Guide 단계 템플릿',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub 모듈 이벤트 푸시 구독',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => '예',
        '2' => '아니요',
    ],

    'checkbox_massupdate_dom' => [
        0 => '아니요',
        1 => '예',
    ],

    'notifications_status_dom' => [
        0 => '읽지않음',
        1 => '읽음',
    ],

    'optout_dom' => [
        '' => '-없음-',
        'false' => '아니요',
        'true' => '예',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => '분석가',
        'Competitor' => '경쟁업체',
        'Customer' => '고객',
        'Integrator' => '통합자',
        'Investor' => '투자자',
        'Partner' => '협력자',
        'Press' => '누르기',
        'Prospect' => '전망',
        'Reseller' => '재판매자',
        'Other' => '기타',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => '의류 및 패션',
        'Banking' => '은행',
        'Biotechnology' => '생명공학',
        'Chemicals' => '석유화학',
        'Communications' => '정보통신',
        'Construction' => '건설',
        'Consulting' => '컨설팅',
        'Education' => '교육',
        'Electronics' => '전자',
        'Energy' => '자원',
        'Engineering' => '엔지니어링',
        'Entertainment' => '엔터테인먼트',
        'Environmental' => '환경',
        'Finance' => '금융',
        'Government' => '정부',
        'Healthcare' => '의료 및 보건',
        'Hospitality' => '복지',
        'Insurance' => '보험',
        'Machinery' => '기계',
        'Manufacturing' => '제조',
        'Media' => '신문/방송',
        'Not For Profit' => '비영리',
        'Recreation' => '레크리에이션',
        'Retail' => '유통',
        'Shipping' => '물류/운송',
        'Technology' => '기술',
        'Telecommunications' => '통신',
        'Transportation' => '교통',
        'Utilities' => '공공사업',
        'Other' => '기타',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF 및 CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => '차트',
        'Data Table' => '데이터 표',
        'Chart and Data Table' => '차트 및 데이터 표',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => '진행 중',
        'Completed' => '완료',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => '인바운드',
        'Outbound' => '아웃바운드',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => '채팅',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => '1단계',
        'T2' => '2단계',
        'T3' => '3단계',
        'T4' => '4단계',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => '예',
        'No' => '아니요',
        'Completed' => '완료',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => '미래',
        'Active' => '활성',
        'Past' => '과거',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => '자가 생성됨',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => '방문판매',
        'Existing Customer' => '기존고객',
        'Self Generated' => '자가 생성됨',
        'Employee' => '직원',
        'Partner' => '협력자',
        'Public Relations' => '광고 및 홍보',
        'Direct Mail' => 'DM 우편',
        'Conference' => '컨퍼런스',
        'Trade Show' => '무역 박람회',
        'Web Site' => '웹사이트',
        'Word of mouth' => '입소문',
        'Email' => '이메일',
        'Campaign' => '캠페인',
        'Support Portal User Registration' => '사용자 지원 포털 등록',
        'Other' => '기타',
    ],
    'metric_status_dom' => [
        'Inactive' => '비활성',
        'Active' => '활성',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => '기존 비즈니스',
        'New Business' => '새로운 비즈니스',
    ],
    'taxrate_status_dom' => [
        'Active' => '작동중',
        'Inactive' => '비활성화',
    ],
    'roi_type_dom' => [
        'Revenue' => '매출',
        'Investment' => '투자',
        'Expected_Revenue' => '예상 매출',
        'Budget' => '예산',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => '주요 의사 결정자',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => '주요 의사 결정자',
        'Business Decision Maker' => '사업 결정권자',
        'Business Evaluator' => '사업 평가자',
        'Technical Decision Maker' => '실무 결정권자',
        'Technical Evaluator' => '실무 평가자',
        'Executive Sponsor' => '임원 지지자',
        'Influencer' => '영향권자',
        'Other' => '기타',
    ],

    'manufacturer_status_dom' => [
        'Active' => '작동중',
        'Inactive' => '비활성화',
    ],

    'shipper_status_dom' => [
        'Active' => '작동중',
        'Inactive' => '비활성화',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => '주요 연락처',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => '주요 연락처',
        'Alternate Contact' => '부 연락처',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => '필드 값 이하',
        'field_on_top' => '필드 값 이상',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => '격주',
        'Net 30' => '매월',
    ],
    'sales_stage_default_key' => '예측',
    'fts_type' => [
        'Elastic' => '유동적인 검색',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => '예측',
        'Qualification' => '자격조건',
        'Needs Analysis' => '수요분석',
        'Value Proposition' => '초기영업',
        'Id. Decision Makers' => '결정권자확인',
        'Perception Analysis' => '고객요구분석',
        'Proposal/Price Quote' => '제안및견적',
        'Negotiation/Review' => '협상 및 검토',
        'Closed Won' => '계약 성공',
        'Closed Lost' => '계약실패',
    ],
    'sales_status_with_quote_dom' => [
        'New' => '신규',
        'In Progress' => '진행중',
        'Closed Won' => '계약 성공',
        'Closed Lost' => '계약실패',
        'Converted to Quote' => '견적으로 전환되었습니다',
    ],
    'sales_status_dom' => [
        'New' => '신규',
        'In Progress' => '진행중',
        'Closed Won' => '계약 성공',
        'Closed Lost' => '계약실패',
    ],

    'commit_stage_binary_dom' => [
        'include' => '포함',
        'exclude' => '불포함',
    ],
    'commit_stage_dom' => [
        'include' => '포함',
        'upside' => '긍정적인 면',
        'exclude' => '불포함',
    ],

    'commit_stage_custom_dom' => [
        'include' => '포함',
        'upside' => '긍정적인 면',
        'exclude' => '불포함',
    ],

    'in_total_group_stages' => [
        'Draft' => '초안',
        'Negotiation' => '제안및교섭',
        'Delivered' => '전달',
        'On Hold' => '보류',
        'Confirmed' => '확인',
        'Closed Accepted' => '계약성공',
        'Closed Lost' => '계약실패',
        'Closed Dead' => '계약만료',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => '전화상담',
        'Meeting' => '회의',
        'Task' => '과제',
        'Email' => '이메일',
        'Note' => '메모',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'Mr.',
        'Ms.' => 'Ms.',
        'Mrs.' => 'Mrs.',
        'Dr.' => '박사',
        'Prof.' => '교수',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => '없음',
        60 => '1 분 전에',
        300 => '5 분 전에',
        600 => '10 분 전에',
        900 => '15 분 전에',
        1800 => '30 분 전',
        3600 => '1 시간 전에',
        7200 => '2 시간 전에',
        10800 => '3 시간 전에',
        18000 => '5 시간 전에',
        86400 => '1일 전',
        ],

        'task_priority_default' => '보통',
        'task_priority_dom' => [
        'High' => '높음',
        'Medium' => '보통',
        'Low' => '낮음',
        ],
        'task_status_default' => '시작하지 않았음',
        'task_status_dom' => [
        'Not Started' => '시작 전',
        'In Progress' => '진행중',
        'Completed' => '완료',
        'Pending Input' => '응답대기',
        'Deferred' => '연기',
        'Not Applicable' => '해당 사항 없음',
        ],
        'meeting_status_default' => '계획됨',
        'meeting_status_dom' => [
        'Planned' => '예정',
        'Held' => '완료',
        'Not Held' => '취소',
        'Deferred' => '연기됨',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => '기타',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => '계획됨',
        'call_status_dom' => [
        'Planned' => '예정',
        'In Progress' => '진행 중',
        'Held' => '완료',
        'Not Held' => '취소',
        'Deferred' => '연기됨',
        ],
        'call_direction_default' => '발신',
        'call_direction_dom' => [
        'Inbound' => '수신',
        'Outbound' => '발신',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => '신규',
        'Assigned' => '배정완료',
        'In Process' => '진행중',
        'Converted' => '변환됨',
        'Recycled' => '재할당',
        'Dead' => '만료됨',
        ],
        'gender_list' => [
        'male' => '남성',
        'female' => '여성',
        'other' => '기타',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => '신규',
        'case_status_dom' => [
        'New' => '신규',
        'Assigned' => '배정',
        'Closed' => '완료',
        'Pending Input' => '응답대기',
        'Rejected' => '거부',
        'Duplicate' => '복사하기',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => '높음',
        'P2' => '보통',
        'P3' => '낮음',
        ],
        'user_type_dom' => [
        'RegularUser' => '일반사용자',
        'Administrator' => '관리자',
        ],
        'user_type_bool_dom' => [
            false => '일반사용자',
            true => '관리자',
        ],
        'user_type_group_bool_dom' => [
            true => '그룹사용자',
        ],
        'user_type_portal_bool_dom' => [
            true => '포탈 API 사용자',
        ],
        'license_type_dom' => [
        'CURRENT' => '현재 제품',
        'SUGAR_SERVE' => 'Sugar 제공',
        'SUGAR_SELL' => 'Sugar 판매',
        ],
        'user_status_dom' => [
        'Active' => '작동중',
        'Inactive' => '중지',
        ],
        'employee_status_dom' => [
        'Active' => '작동중',
        'Terminated' => '퇴사',
        'Leave of Absence' => '휴직중',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => '야후!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => '작동중',
        'Inactive' => '중지',
        ],
        'project_task_priority_options' => [
        'High' => '높음',
        'Medium' => '보통',
        'Low' => '낮음',
        ],
        'project_task_priority_default' => '보통',

        'project_task_status_options' => [
        'Not Started' => '시작하지 않았음',
        'In Progress' => '진행중',
        'Completed' => '완료',
        'Pending Input' => '응답대기',
        'Deferred' => '연기',
        ],
        'project_task_utilization_options' => [
        '0' => '없음',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => '초안',
        'In Review' => '검토 중',
        'Published' => '발표 완료',
        ],
        'project_status_default' => '초안',

        'project_duration_units_dom' => [
        'Days' => '일자',
        'Hours' => '시',
        ],

        'project_priority_options' => [
        'High' => '높음',
        'Medium' => '보통',
        'Low' => '낮음',
        ],
        'project_priority_default' => '보통',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => '거래처',
        'record_type_display' => [
        '' => '',
        'Accounts' => '거래처',
        'Opportunities' => '예비고객',
        'Cases' => '사례',
        'Leads' => '관심고객:',
        'Contacts' => '연락처', // cn (11/22/2005) added to support Emails
        'Products' => '견적 라인아이템',
        'Quotes' => '견적',
        'Bugs' => '버그',
        'Project' => '프로젝트',

        'Prospects' => '목표고객',
        'ProjectTask' => '프로젝트 과제',

        'Tasks' => '과제',
        'KBContents' => '지식 기반',
        'Notes' => '메모',
        ],

        'record_type_display_notes' => [
        'Accounts' => '거래처',
        'Contacts' => '연락처',
        'Opportunities' => '예비고객',
        'Tasks' => '과제',
        'ProductTemplates' => '제품 카탈로그',
        'Quotes' => '견적',
        'Products' => '견적 라인아이템',
        'Contracts' => '계약',
        'Emails' => '다른 이메일:',

        'Bugs' => '버그',
        'Project' => '프로젝트',
        'ProjectTask' => '프로젝트 과제',
        'Prospects' => '목표고객',
        'Cases' => '사례',
        'Leads' => '관심고객:',

        'Meetings' => '회의',
        'Calls' => '전화상담',
        'KBContents' => '지식 기반',
        'PurchasedLineItems' => '구매한 라인아이템',
        'Purchases' => '구매',
        'Escalations' => '에스컬레이션',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => '거래처',
        'Contacts' => '연락처',
        'Employees' => '직원',
        'Leads' => '관심고객',
        'Prospects' => '목표고객',
        'Users' => '사용자',
        ],

        'parent_type_display' => [
        'Accounts' => '거래처',
        'Contacts' => '연락처',
        'Tasks' => '업무',
        'Opportunities' => '예비고객',
        'Products' => '견적 라인아이템',
        'Quotes' => '견적',

        'Bugs' => '버그',
        'Cases' => '사례',
        'Leads' => '관심고객',

        'Project' => '프로젝트',
        'ProjectTask' => '프로젝트 과제',

        'Prospects' => '목표고객',
        'KBContents' => '지식 베이스',
        'Notes' => '메모',
        'PurchasedLineItems' => '구매한 라인아이템',
        'Purchases' => '구매',
        'Escalations' => '에스컬레이션',
        ],

        'changetimer_parent_type' => [
        'Cases' => '사례',
        ],

        'product_status_default_key' => '배송',
        'product_status_quote_key' => '견적',
        'product_status_dom' => [
        '' => '',
        'Quotes' => '견적완료',
        'Orders' => '주문완료',
        'Ship' => '배송완료',
        ],
        'active_status_dom' => [
        'Active' => '작동중',
        'Inactive' => '중지',
        'Retired' => '은퇴',
        ],
        'appearance_options' => [
        'system_default' => '시스템 설정 사용',
        'light' => '밝음',
        'dark' => '어두움',
        ],


        'pricing_formula_default_key' => '고정',
        'pricing_formula_dom' => [
        'Fixed' => '정가',
        'ProfitMargin' => '이윤 차액',
        'PercentageMarkup' => '경비 대비 이윤',
        'PercentageDiscount' => '목록으로부터 할인',
        'IsList' => '목록과 동일',
        ],
        'product_template_status_dom' => [
        'Available' => '재고있음',
        'Unavailable' => '재고없음',
        ],
        'tax_class_dom' => [
        'Taxable' => '과세품목',
        'Non-Taxable' => '면세품',
        ],
        'support_term_dom' => [
        '+6 months' => '6개월',
        '+1 year' => '1년',
        '+2 years' => '2년',
        ],

        'quote_type_dom' => [
        'Quotes' => '견적',
        'Orders' => '주문',
        ],
        'default_quote_stage_key' => '초안',
        'quote_stage_dom' => [
        'Draft' => '임시 보관',
        'Negotiation' => '제안및교섭',
        'Delivered' => '전달',
        'On Hold' => '대기',
        'Confirmed' => '확인',
        'Closed Accepted' => '계약성공',
        'Closed Lost' => '계약실패',
        'Closed Dead' => '계약만료',
        ],
        'default_order_stage_key' => '보류중',
        'order_stage_dom' => [
        'Pending' => '보류중',
        'Confirmed' => '확인',
        'On Hold' => '대기',
        'Shipped' => '배송완료',
        'Cancelled' => '취소',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => '주요 의사 결정자',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => '주요 의사 결정자',
        'Business Decision Maker' => '사업 결정권자',
        'Business Evaluator' => '사업 평가자',
        'Technical Decision Maker' => '실무 결정권자',
        'Technical Evaluator' => '실무 평가자',
        'Executive Sponsor' => '임원 지지자',
        'Influencer' => '영향권자',
        'Other' => '기타',
        ],
        'layouts_dom' => [
        'Standard' => '견적',
        'Invoice' => '청구서',
        ],
        'issue_priority_default_key' => '보통',
        'issue_priority_dom' => [
        'Urgent' => '긴급',
        'High' => '높음',
        'Medium' => '보통',
        'Low' => '낮음',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => '수락',
        'Duplicate' => '복사하기',
        'Closed' => '완료',
        'Out of Date' => '기간만료',
        'Invalid' => '무효',
        ],

        'issue_status_default_key' => '신규',
        'issue_status_dom' => [
        'New' => '신규',
        'Assigned' => '배정',
        'Closed' => '완료',
        'Pending' => '보류중',
        'Rejected' => '거부',
        ],

        'bug_priority_default_key' => '보통',
        'bug_priority_dom' => [
        'Urgent' => '긴급',
        'High' => '높음',
        'Medium' => '보통',
        'Low' => '낮음',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => '수락',
        'Duplicate' => '복사하기',
        'Fixed' => '고정',
        'Out of Date' => '기간만료',
        'Invalid' => '무효',
        'Later' => '추후처리',
        ],
        'bug_status_default_key' => '신규',
        'bug_status_dom' => [
        'New' => '신규',
        'Assigned' => '배정',
        'Closed' => '완료',
        'Pending' => '보류중',
        'Rejected' => '거부',
        ],
        'bug_type_default_key' => '버그',
        'bug_type_dom' => [
        'Defect' => '결함',
        'Feature' => '특징',
        ],
        'case_type_dom' => [
        'Administration' => '관리',
        'Product' => '제품',
        'User' => '사용자',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => '내부',
        'Forum' => '포럼',
        'Web' => '웹',
        'InboundEmail' => '다른 이메일:',
        'Twitter' => '트위터',
        'Portal' => '포탈',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => '내부',
        'Forum' => '포럼',
        'Web' => '웹',
        'InboundEmail' => '이메일',
        'Twitter' => '트위터',
        'Portal' => '포탈',
        'Phone' => '전화번호',
        'Chat' => '채팅',
        'Chatbot' => '챗봇',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => '데이터 프라이버시 정책 요청',
        'Send Personal Information being processed' => '처리 중인 개인 정보 전송',
        'Rectify Information' => '정보 수정',
        'Request to Erase Information' => '정보 삭제 요청',
        'Export Information' => '정보 내보내기',
        'Restrict Processing' => '처리 제한',
        'Object to Processing' => '처리 거절',
        'Consent to Process' => '처리 동의',
        'Withdraw Consent' => '동의 철회',
        'Other' => '기타',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => '비즈니스 커뮤니케이션',
        'Marketing Communications by company' => '회사의 마케팅 커뮤니케이션',
        'Marketing Communications by partners' => '파트너 별 마케팅 커뮤니케이션',
        ],
        'dataprivacy_status_default_key' => '오픈',
        'dataprivacy_status_dom' => [
        'Open' => '오픈',
        'Closed' => '완료',
        'Rejected' => '거부',
        ],
        'dataprivacy_priority_default_key' => '낮음',
        'dataprivacy_priority_dom' => [
        'Low' => '낮음',
        'Medium' => '보통',
        'High' => '높음',
        ],
        'business_day_status_dom' => [
        'Open' => '운영',
        'Open 24 Hours' => '24시간 운영',
        'Closed' => '종료',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => '거래처',
        'Activities' => '활동내역',
        'Bug Tracker' => '오류 추적',
        'Calendar' => '캘린더',
        'Calls' => '전화 목록',
        'Campaigns' => '캠페인 목록',
        'Cases' => '사례 목록',
        'Contacts' => '연락처',
        'Currencies' => '통화목록',
        'Dashboard' => '대시보드',
        'Documents' => '문서 목록',
        'Emails' => '이메일',
        'Feeds' => '피드(Feeds)',
        'Forecasts' => '예상',
        'Help' => '도움말',
        'Home' => '홈',
        'Leads' => '관심고객목록',
        'Meetings' => '회의 목록',
        'Notes' => '노트',
        'Opportunities' => '영업기회',
        'Outlook Plugin' => '아웃룩 플러그인',
        'Product Catalog' => '제품 카탈로그',
        'Products' => '견적 라인아이템',
        'RevenueLineItems' => '매출 품목',
        'Projects' => '프로젝트 목록',
        'Quotes' => '견적 목록',
        'Releases' => '발매',
        'RSS' => 'RSS',
        'Studio' => '작업실',
        'Upgrade' => '업그레이드',
        'Users' => '사용자',
        'OutboundEmail' => '이메일 설정',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => '기획',
        'Active' => '작동중',
        'Inactive' => '중지',
        'Complete' => '완료',
        'In Queue' => '대기중',
        'Sending' => '전송',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => '전화영업',
        'Mail' => 'DM 우편',
        'Email' => '다른 이메일:',
        'Print' => '출력하기',
        'Web' => '웹',
        'Radio' => '라디오광고',
        'Television' => 'Tv광고',
        'NewsLetter' => '뉴스레터',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => '주별',
        'Monthly' => '월별',
        'Quarterly' => '분기별',
        'Annually' => '연도별',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => '1월',
        '2' => '2월',
        '3' => '3월',
        '4' => '4월',
        '5' => '5월',
        '6' => '6월',
        '7' => '7월',
        '8' => '8월',
        '9' => '9월',
        '10' => '10월',
        '11' => '11월',
        '12' => '12월',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => '1월',
        '2' => '2월',
        '3' => '3월',
        '4' => '4월',
        '5' => '5월',
        '6' => '6월',
        '7' => '7월',
        '8' => '8월',
        '9' => '9월',
        '10' => '10월',
        '11' => '11월',
        '12' => '12월',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => '일요일',
        '2' => '월요일',
        '3' => '화요일',
        '4' => '수요일',
        '5' => '목요일',
        '6' => '금요일',
        '7' => '토요일',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => '일',
        '2' => '월',
        '3' => '화',
        '4' => '수',
        '5' => '목',
        '6' => '금',
        '7' => '토',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => '일',
        '2' => '월',
        '3' => '화',
        '4' => '수',
        '5' => '목',
        '6' => '금',
        '7' => '토',
        ],
        'dom_cal_day_of_week' => [
        '0' => '일',
        '1' => '월',
        '2' => '화',
        '3' => '수',
        '4' => '목',
        '5' => '금',
        '6' => '토',
        ],
        'dom_meridiem_lowercase' => [
        'am' => '오전',
        'pm' => '오후',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => '행렬',
        'summary' => '요약',
        'detailed_summary' => '설명 및 요약',
        'Matrix' => '매트릭스',
        ],


        'dom_email_types' => [
        'out' => '전송',
        'archived' => '보관됨',
        'draft' => '임시 보관',
        'inbound' => '수신',
        'campaign' => '캠페인',
        ],
        'dom_email_status' => [
        'archived' => '보관됨',
        'closed' => '완료',
        'draft' => '임시저장됨',
        'read' => '읽음',
        'replied' => '답장발송됨',
        'sent' => '전송',
        'send_error' => '전송 오류',
        'unread' => '읽지않음',
        ],
        'dom_email_archived_status' => [
        'archived' => '보관됨',
        ],

        'dom_email_server_type' => ['' => '--없음--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--없음--',
        'createcase' => '신규 사례 추가하기',
        'bounce' => '반송 처리',
        ],
        'dom_email_distribution' => ['' => '--없음--',
        'direct' => '바로 지정',
        'roundRobin' => '라운드로빈',
        'leastBusy' => '최저 사용',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => '라운드로빈',
        'leastBusy' => '최저 사용',
        'none' => '없음',
        ],
        'dom_email_errors' => [1 => '아이템 바로 지정시 한 사용자만을 선택하십시오.',
        2 => '아이템 바로 지정시 반드시 확인된 아이템만을 지정할수 있습니다.',
        ],
        'dom_email_bool' => ['bool_true' => '예',
        'bool_false' => '아니요',
        ],
        'dom_int_bool' => [1 => '예',
        0 => '아니요',
        ],
        'dom_switch_bool' => ['on' => '예',
        'off' => '아니요',
        '' => '아니요',],

        'dom_email_link_type' => ['sugar' => 'Sugar 이메일 고객',
        'mailto' => '외부 이메일 고객'],


        'dom_email_editor_option' => ['' => '초기설정 이메일 형식',
        'html' => 'HTML 이메일',
        'plain' => '플레인 텍스트 이메일'],

        'schedulers_times_dom' => ['not run' => '실행되지 않음',
        'ready' => '준비',
        'in progress' => '진행중',
        'failed' => '실패',
        'completed' => '완료',
        'no curl' => '사용가능한 cURL 없음',
        ],

        'dom_email_states' => [
        'Draft' => '임시 보관',
        'Archived' => '보관됨',
        ],

        'dom_email_direction' => [
        'Unknown' => '알 수 없음',
        'Outbound' => '아웃바운드',
        'Inbound' => '인바운드',
        'Internal' => '내부',
        ],

        'scheduler_status_dom' => [
        'Active' => '작동중',
        'Inactive' => '중지',
        ],

        'scheduler_period_dom' => [
        'min' => '분',
        'hour' => '시',
        ],
        'forecast_type_dom' => [
        'Direct' => '다이렉트',
        'Rollup' => '롤업',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => '마케팅',
        'Knowledge Base' => '지식 베이스',
        'Sales' => '영업',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => '홍보 자료',
        'Product Brochures' => '브로슈어',
        'FAQ' => '자주묻는질문',
        ],

        'document_status_dom' => [
        'Active' => '작동중',
        'Draft' => '임시 보관',
        'FAQ' => '자주묻는질문',
        'Expired' => '기간 만료됨',
        'Under Review' => '검토중',
        'Pending' => '보류중',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => '우편 통합',
        'eula' => '소프트웨어 사용자 라이선스 동의서(EULA)',
        'nda' => '기술정보 비밀유지 동의서(NDA)',
        'license' => '라이센스 동의서',
        ],
        'dom_meeting_accept_options' => [
        'accept' => '동의합니다.',
        'decline' => '거절합니다',
        'tentative' => '예정',
        ],
        'dom_meeting_accept_status' => [
        'accept' => '수락',
        'decline' => '거절',
        'tentative' => '예정',
        'none' => '없음',
        ],
        'dataset_output_default_dom' => [
        'table' => '표',
        ],
        'report_maker_status_dom' => [
        'Single Module' => '단일 모듈',
        'Multi Module' => '복합 모듈',
        ],
        'report_align_dom' => [
        'left' => '왼쪽',
        'center' => '중앙',
        'right' => '오른쪽',
        ],

        'width_type_dom' => [
        '%' => '퍼센트 (%)',
        'px' => '픽셀 (px)',
        ],
        'report_color_dom' => [
        '' => '초기 설정',
        'black' => '검정색',
        'green' => '녹색',
        'blue' => '파란색',
        'red' => '빨간색',
        'white' => '흰색',
        'DarkGreen' => '적녹색',
        'LightGray' => '밝은 회색',
        'DodgerBlue' => '진청색',
        'LightBlue' => '하늘색',
        ],
        'font_size_dom' => [
        '-5' => '작게 (-5)',
        '-4' => '작게 (-4)',
        '-3' => '작게 (-3)',
        '-2' => '작게 (-2)',
        '-1' => '작게 (-1)',
        'Default' => '초기 설정',
        '1' => '크게 (+1)',
        '2' => '크게 (+2)',
        '3' => '크게 (+3)',
        '4' => '크게 (+4)',
        '5' => '크게 (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => '메인 쿼리',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => '표시(Display)',
//  'Group By' => 'Group By',
        'Calculation' => '계산(Calcuation)',
        ],
        'query_display_type_dom' => [
        'Default' => '초기 설정',
        'Custom' => '사용자 지정',
        'Hidden' => '숨겨짐',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => '일',
        'Week' => '주',
        'Month' => '월',
        'Quarter' => '분기',
        'Year' => '년',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => '현재',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => '합계',
        'AVG' => '평균',
        'COUNT' => '횟수',
        'STDDEV' => '표준 편차',
        'VARIANCE' => '격차(Variance)',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => '기본 필드',
        'Time' => '시간 간격',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => '가로열 (Y-Axis)',
        'Columns' => '세로열 (X-Axis)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => '합계',
        'AVG' => '평균',
        'MAX' => '최대',
        'MIN' => '최소',
        'COUNT' => '횟수',
        'STDDEV' => '표준 편차',
        'VARIANCE' => '격차(Variance)',
        ],
        'query_calc_type_dom' => [
        'Standard' => '표준',
//  'Sub-Query' => 'Sub Query',
        'Math' => '수학 계산',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => '필드',
        'Value' => '가치',
        'Group' => '그룹',
        ],


        'dataset_layout_type_dom' => [
        'Column' => '열',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => '중지',
        'Enabled' => '작동',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => '보통',
        'Scalar' => '스칼라',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => '텍스트',
        'Accounting' => '회계',
        'Date' => '날짜',
        'Datetime' => '날짜시간',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => '년',
        'Quarter' => '분기',
        'Month' => '월',
        'Week' => '주',
        'Day' => '일',
        ],
        'dataset_style_dom' => [
        'normal' => '보통',
        'bold' => '볼드',
        'italic' => '이탤릭체',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) 더하기',
        '-' => '(-) 빼기',
        '*' => '(X) 곱하기',
        '/' => '(/) 나누기',
        ],
        'wflow_type_dom' => [
        'Normal' => '레코드가 저장될 때',
        'Time' => '시간이 경과한 후',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Is',
        'in' => '다음중 하나',
        ],
        'mselect_multi_type_dom' => [
        'in' => '다음중 하나',
        'not_in' => '다음중 하나가 아님',
        ],
        'cselect_type_dom' => [
        'Equals' => '동일',
        'Does not Equal' => '동일하지 않음',
        ],
        'dselect_type_dom' => [
        'Equals' => '동일',
        'Less Than' => '더 적음',
        'More Than' => '보다 많음',
        'Does not Equal' => '같지 않음',
        ],
        'bselect_type_dom' => [
        'bool_true' => '예',
        'bool_false' => '아니요',
        ],
        'bopselect_type_dom' => [
        'Equals' => '동일',
        ],
        'tselect_type_dom' => [
        '0' => '0 시간',
        '14440' => '4 시간',
        '28800' => '8 시간',
        '43200' => '12 시간',
        '86400' => '1 일',
        '172800' => '2  일',
        '259200' => '3  일',
        '345600' => '4  일',
        '432000' => '5  일',
        '604800' => '1 주',
        '1209600' => '2 주',
        '1814400' => '3 주',
        '2592000' => '30 일',
        '5184000' => '60 일',
        '7776000' => '90 일',
        '10368000' => '120 일',
        '12960000' => '150 일',
        '15552000' => '180 일',
        ],
        'dtselect_type_dom' => [
        'More Than' => '보다 많습니다',
        'Less Than' => '다음보다 적습니다',
        ],
        'wflow_alert_type_dom' => [
        'Email' => '다른 이메일:',
        'Invite' => '초대',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => '기본 메세지',
        'Custom Template' => '고객 템플릿',
        'System Default' => '시스템 초기설정',
        ],
        'wflow_user_type_dom' => [
        'current_user' => '현재 사용자',
        'rel_user' => '관련된 사용자',
        'rel_user_custom' => '관련된 사용자 정의 사용자',
        'specific_team' => '특정 팀',
        'specific_role' => '특정 역할',
        'specific_user' => '특정 사용자',
        ],
        'wflow_array_type_dom' => [
        'future' => '새 가치',
        'past' => '예전 가치',
        ],
        'wflow_relate_type_dom' => [
        'Self' => '사용자',
        'Manager' => "사용자의 상급자",
        ],
        'wflow_address_type_dom' => [
        'to' => '수신자',
        'cc' => '참조',
        'bcc' => '숨은 참조',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => '수신자',
        'cc' => '참조',
        'bcc' => '숨은 참조',
        'invite_only' => '초대만',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => '수신자',
        ],
        'wflow_action_type_dom' => [
        'update' => '레코드 업데이트',
        'update_rel' => '관련 레코드 업데이트',
        'new' => '신규 레코드',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => '실행 날짜(Triggered Date)',
        'Existing Value' => '기존 값',
        ],
        'wflow_set_type_dom' => [
        'Basic' => '기본 선택항목',
        'Advanced' => '고급 선택사항',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => '레코드의 할당된 사용자',
        'modified_user_id' => '레코드의 마지막 수정자',
        'created_by' => '레코드의 생성자',
        'current_user' => '로그인 사용자',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => '레코드의 현재 팀',
        'team_set_id' => '현재 팀 세트의 트리거 기록',
        'current_team' => '로그인 사용자의 팀',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => '드롭다운을 거꾸로 이동 ',
        'advance' => '드롭다운은 앞으로 이동 ',
        ],
        'wflow_record_type_dom' => [
        'All' => '신규와 업데이트된 레코드 모두',
        'New' => '신규 레코드만',
        'Update' => '업데이트된 레코드만',
        ],
        'wflow_rel_type_dom' => [
        'all' => '전체 관련',
        //'first' => 'The first related',
        'filter' => '필터 관련',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => '전체 관련',
        'any' => '관련된 (Any)',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => '알림 후 액션',
        'actions_alerts' => '액션 후 알림'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => '없음',
        'Daily' => '매일',
        'Weekly' => '매주',
        'Monthly' => '매월',
        'Yearly' => '매년',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => '일',
        'Weekly' => '주',
        'Monthly' => '월',
        'Yearly' => '년',
        ],

        'repeat_end_types' => [
        'Until' => '까지',
        'Occurrences' => '발생횟수',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => '없음',
        'Each' => '각',
        'On' => '다음에서',
        ],

        'repeat_ordinal_dom' => [
        'first' => '1 순위',
        'second' => '2 순위',
        'third' => '3 순위',
        'fourth' => '4 순위',
        'fifth' => '5 순위',
        'last' => '이외',
        ],

        'repeat_unit_dom' => [
        'Sun' => '일요일',
        'Mon' => '월요일',
        'Tue' => '화요일',
        'Wed' => '수요일',
        'Thu' => '목요일',
        'Fri' => '금요일',
        'Sat' => '토요일',
        'Day' => '일',
        'WD' => '평일',
        'WE' => '주말',
        ],

        'duration_dom' => [
        '' => '없음',
        '900' => '15분',
        '1800' => '30분',
        '2700' => '45분',
        '3600' => '1시간',
        '5400' => '1시간반',
        '7200' => '2시간',
        '10800' => '3시간',
        '21600' => '6시간',
        '86400' => '1 일',
        '172800' => '2  일',
        '259200' => '3  일',
        '604800' => '1 주',
        ],
        'repeat_month_dom' => [
        '1' => '1월',
        '2' => '2월',
        '3' => '3월',
        '4' => '4월',
        '5' => '5월',
        '6' => '6월',
        '7' => '7월',
        '8' => '8월',
        '9' => '9월',
        '10' => '10월',
        '11' => '11월',
        '12' => '12월',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => '초기 설정',
        'seed' => '신규할당(Seed)',
        'exempt_domain' => '거부 목록 - 도메인',
        'exempt_address' => '거부 목록 - 이메일주소',
        'exempt' => '거부 목록 - 고유번호',
        'test' => '테스트',
        ],
        'currency_status_dom' => [
        'Active' => '작동중',
        'Inactive' => '비활성화',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => '작동중',
        'inactive' => '중지',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => '메시지 전송/시도',
        'send error' => '반송 메시지, 기타',
        'invalid email' => '반송 메시지, 유효하지 않은 이메일',
        'link' => '링크확인',
        'viewed' => '수신확인 메시지',
        'removed' => '이탈됨',
        'lead' => '관심고객 새로 만들기',
        'contact' => '신규 연락처 생성완료',
        'blocked' => '거부목록에 포함된 주소',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => '연락처',
        'Users' => '사용자',
        'Prospects' => '목표고객 목록',
        'Leads' => '관심고객목록',
        'Accounts' => '거래처',
        ],
        'merge_operators_dom' => [
        'like' => '포함',
        'exact' => '정확히',
        'start' => '다음과 시작',
        ],

        'custom_fields_importable_dom' => [
        'true' => '예',
        'false' => '아니요',
        'required' => '필수항목',
        ],

        'fts_field_config' => [
        '0' => '중지',
        '2' => '검색 가능',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => '중지',
        1 => '작동',
        2 => '필터',
        3 => '초기설정된 필터',
        4 => '필터만',
        ],

        'navigation_paradigms' => [
        'm' => '모듈',
        'gm' => '그룹화된 모듈',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => '시작하지 않았음',
        'inprogress' => '진행중',
        'signed' => '서명함',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => '매월',
        'quarterly' => '매분기',
        'halfyearly' => '반년마다',
        'yearly' => '매년',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 일',
        '3' => '3 일',
        '5' => '5 일',
        '7' => '1 주',
        '14' => '2주',
        '21' => '3 주',
        '31' => '1 달',
        ],
        'projects_priority_options' => [
        'high' => '높음',
        'medium' => '보통',
        'low' => '낮음',
        ],

        'projects_status_options' => [
        'notstarted' => '시작하지 않았음',
        'inprogress' => '진행중',
        'completed' => '완료',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => '범례 열기',
        'collapselegend' => '범례 접기',
        'clickfordrilldown' => '드릴다운',
        'drilldownoptions' => '드릴다운 옵션',
        'detailview' => '더보기',
        'piechart' => '원형 도표',
        'groupchart' => '그룹 도표',
        'stackedchart' => '누적 도표',
        'barchart' => '막대 도표',
        'horizontalbarchart' => '수평 막대 도표',
        'linechart' => '줄 도표',
        'noData' => '사용가능한 데이터가 없습니다.',
        'print' => '출력하기',
        'pieWedgeName' => '부분',
        ],
        'chart_types' => [
        'hBarF' => '수평 막대 (스택)',
        'hGBarF' => '수평 막대 (그룹화)',
        'vBarF' => '수직 막대 (스택)',
        'vGBarF' => '수직 막대 (그룹화)',
        'pieF' => '원형',
        'funnelF' => '깔때기형',
        'lineF' => '줄',
        'donutF' => '도넛',
        'treemapF' => '트리맵',
        ],
        'd3_value_placement' => [
        '0' => '없음',
        '1' => '초기 설정',
        'start' => '시작',
        'middle' => '중간',
        'end' => '완료',
        'top' => '상단',
        'total' => '합계',
        ],
        'pipeline_chart_dom' => [
        'fun' => '깔때기형',
        'hbar' => '수평 막대',
        ],
        'release_status_dom' => [
        'Active' => '작동중',
        'Inactive' => '중지',
        ],
        'email_settings_for_ssl' => [
        '0' => '없음',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => '아웃룩',
        'google' => 'Google Less Secure Apps',
        'exchange' => '교환',
        'other' => '기타',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => '기타',
        ],
        'import_enclosure_options' => [
        '&#39;' => '작은 따옴표',
        '"' => '큰 따옴표',
        '' => '없음',
        'other' => '기타',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => '기타',
        ],
        'link_target_dom' => [
        '_blank' => '새창으로이동',
        '_self' => '동일페이지이동',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => '사용하지않음',
        '30' => '매 30초마다',
        '60' => '매 1분마다',
        '180' => '매 3분마다',
        '300' => '매 5분마다',
        '600' => '매 10분마다',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => '없음',
        '15' => '매 15분',
        '30' => '매 30분',
        '45' => '매 45분',
        '60' => '매 시',
        '120' => '매 2시간',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => '사용하지않음',
        '30' => '매 30초마다',
        '60' => '1분마다',
        '180' => '3분마다',
        '300' => '5분마다',
        '600' => '10분마다',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => '없음',
        '1' => '1분 간격',
        '5' => '매 5분',
        '10' => '10분 간격',
        '15' => '15분 간격',
        '30' => '30분 간격',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => '동일',
        'not_equal' => 'Not On',
        'greater_than' => '후',
        'less_than' => '전',
        'last_7_days' => '지난 7일',
        'next_7_days' => '다음 7일',
        'last_30_days' => '지난 30일',
        'next_30_days' => '다음 30일',
        'last_month' => '지난 달',
        'this_month' => '이번 달',
        'next_month' => '다음달',
        'last_year' => '작년',
        'this_year' => '올해',
        'next_year' => '내년',
        'between' => '중간',
        ],
        'date_range_operator_dom' => [
        'last_year' => '작년',
        'last_month' => '지난 달',
        'last_30_days' => '지난 30일',
        'last_7_days' => '지난 7일',
        'this_month' => '이번 달',
        'this_year' => '올해',
        'next_7_days' => '다음 7일',
        'next_30_days' => '다음 30일',
        'next_month' => '다음달',
        'next_year' => '내년',
        ],
        'numeric_range_search_dom' => [
        '=' => '동일',
        'not_equal' => '동일하지 않음',
        'greater_than' => '다음보다 더 큼',
        'greater_than_equals' => '같거나 큰',
        'less_than' => '더 적음',
        'less_than_equals' => '같거나 작은',
        'between' => '중간',
        ],

        'filter_checkbox_dom' => [
        0 => '아니오',
        1 => '예',
        ],

        'opportunity_metrics_dom' => [
        'won' => '획득 성공',
        'lost' => '획득 실패',
        'active' => '작동중',
        ],

        'sweetspot_theme_options' => [
        'default' => '초기 설정',
        'light' => '밝음',
        'dark' => '어두움',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => '이동',
        'donothing' => '없음',
        ],
        'processes_auto_save_interval' => [
        0 => '사용하지 않음',
        30000 => '매 30초마다',
        60000 => '매 1분마다',
        120000 => '매 2분마다',
        180000 => '매 3분마다',
        240000 => '매 4분마다',
        300000 => '매 5분마다',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => '예',
        'No' => '아니오',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => '예측에 포함',
        'sales_stage' => '영업단계',
        'probability' => '가능성',
        ],
        'forecasts_options_dataset' => [
        'likely' => '가능성',
        'best' => '최고',
        'worst' => '최하',
        ],
        'webLogicHookList' => [
        'after_save' => '저장후',
        'after_delete' => '삭제후',
        'after_relationship_add' => '관계 추가후',
        'after_relationship_delete' => '관계 삭제후',
        'after_login' => '로그인후',
        'after_logout' => '로그아웃후',
        'after_login_failed' => '로그인 실패후',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => '작동',
        'INACTIVE' => '중지',
        ],
        'dashboard_view_name_list' => [
        'record' => '기록',
        'records' => '목록',
        'activities' => '활동흐름',
        'multi-line' => '다중 회선 목록',
        'omnichannel' => 'Omnichannel',
        'home' => 'Home',
        'focus' => '포커스 서랍',
        ],
        'metric_context_list' => [
        'service_console' => '서비스 콘솔',
        'renewals_console' => '콘솔 갱신',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => '시간당',
        '21600' => '매 6시간',
        '43200' => '매 12시간',
        '86400' => '매일',
        '604800' => '매주',
        '1209600' => '2주마다',
        '2419200' => '4주마다',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => '년',
        'month' => '월',
        'day' => '일',
        ],
        'shift_exception_type_dom' => [
        'time_off' => '휴가',
        'event' => '행사',
        'other' => '기타',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => '날짜 (마지막 {{module}})',
        'start_date:asc' => '날짜 (첫 {{module}})',
        'total_revenue:desc' => '가격 (최고 합계)',
        'total_revenue:asc' => '가격 (최저 합계)',
        ],
        'calendar_type_list' => [
        'main' => '캘린더 센터',
        ],
        'calendar_views_options' => [
        'day' => '일',
        'week' => '주',
        'workWeek' => '작업 주간',
        'expandedMonth' => '월',
        'agenda' => '어젠다',
        'timeline' => '타임라인',
        'monthSchedule' => '일정 관리',
        ],
        'docusign_envelope_status_list' => [
        'created' => '생성 완료',
        'completed' => '완료',
        'declined' => '거부',
        'delivered' => '전달',
        'sent' => '전송',
        'signed' => '서명함',
        'voided' => '무효',
        ],
        'docusign_recipient_selection_list' => [
        'show' => '가능한 수신자 목록 표시',
        'dont_show' => '가능한 수신자 표시하지 않기',
        ],
        'docusign_recipient_type_list' => [
        'signer' => '서명자',
        'carbon_copy' => '뷰어(카본 카피)',
        'certified_delivery' => '뷰어(인증 전달)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => '기본설정',
        'color' => '색',
        'image' => '이미지',
        ],
        'module_display_type_dom' => [
        'abbreviation' => '약어',
        'icon' => '아이콘',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => '아래 화살표',
        'sicon-chevron-left' => '왼쪽 꺾쇠',
        'sicon-check' => '체크',
        'sicon-clock' => '시계',
        'sicon-dashboard-default' => '대시보드 기본값',
        'sicon-dashboard' => '대시보드',
        'sicon-edit' => '편집',
        'sicon-caret-down' => '아래방향 삼각형',
        'sicon-folder' => '폴더',
        'sicon-info' => '정보',
        'sicon-kebab' => '케밥',
        'sicon-link' => '링크',
        'sicon-list' => '목록',
        'sicon-logout' => '로그아웃',
        'sicon-minus' => '마이너스',
        'sicon-folder-open' => '폴더 열기',
        'sicon-plus-sm' => '플러스 Sm',
        'sicon-refresh' => '새로고침',
        'sicon-plus' => '플러스',
        'sicon-settings' => '설정',
        'sicon-arrow-right-double' => '오른쪽 화살표 더블',
        'sicon-reports' => '보고서',
        'sicon-user' => '사용자',
        'sicon-upload' => '전송',
        'sicon-user-group' => '사용자 그룹',
        'sicon-arrow-left-double' => '왼쪽 화살표 더블',
        'sicon-chevron-up' => '위쪽 꺾쇠',
        'sicon-caret-up' => '윗방향 삼각형',
        'sicon-star-fill' => '채운 별',
        'sicon-download' => '다운로드',
        'sicon-close' => '닫기',
        'sicon-tile-view' => '타일 보기',
        'sicon-list-view' => '목록 보기',
        'sicon-thumbs-down' => '엄지손가락 아래',
        'sicon-warning-circle' => '원형 경고',
        'sicon-phone' => '전화번호',
        'sicon-email' => '이메일',
        'sicon-document' => '문서',
        'sicon-note' => '메모',
        'sicon-preview' => '미리 보기',
        'sicon-copy' => '중복',
        'sicon-launch' => '시작',
        'sicon-lock' => '자물쇠',
        'sicon-arrow-top-right' => '오른쪽 상단 화살표',
        'sicon-full-screen' => '전체 화면',
        'sicon-full-screen-exit' => '전체 화면 종료',
        'sicon-expand-left' => '왼쪽 확장',
        'sicon-expand-right' => '오른쪽 확장',
        'sicon-focus-drawer' => '포커스 서랍',
        'sicon-ban' => '차단',
        'sicon-thumbs-up' => '엄지 척',
        'sicon-search' => '검색',
        'sicon-calendar' => '캘린더',
        'sicon-calendar-lg' => '캘릭더 Lg',
        'sicon-mobile-lg' => '모바일 Lg',
        'sicon-star-fill-lg' => '채운 별 Lg',
        'sicon-star-outline-lg' => '빈 별 Lg',
        'sicon-reset-lg' => '재설정 Lg',
        'sicon-exchange-lg' => '교환 Lg',
        'sicon-help-lg' => '도움말 Lg',
        'sicon-close-lg' => '닫기 Lg',
        'sicon-plus-lg' => '더하기 Lg',
        'sicon-shortcuts-lg' => '단축키 Lg',
        'sicon-search-lg' => '검색 Lg',
        'sicon-email-lg' => '이메일 Lg',
        'sicon-note-lg' => '노트 Lg',
        'sicon-document-lg' => '문서 Lg',
        'sicon-add-dashlet-lg' => '대시렛 추가 Lg',
        'sicon-collapse-lg' => '축소 Lg',
        'sicon-hamburger-lg' => '햄버거 Lg',
        'sicon-pin-fill-lg' => '채운 핀 Lg',
        'sicon-expand-lg' => '확장 Lg',
        'sicon-copy-lg' => '복사 Lg',
        'sicon-dashboard-lg' => '대시보드 Lg',
        'sicon-star-outline' => '빈 별',
        'sicon-reset' => '재설정',
        'sicon-unlink' => '제거',
        'sicon-phone-lg' => '전화 Lg',
        'sicon-attach' => '첨부하기',
        'sicon-case-lg' => '케이스 Lg',
        'sicon-arrow-right-lg' => '오른쪽 화살표 Lg',
        'sicon-check-circle-lg' => '원형 체크 Lg',
        'sicon-text-formatting' => '텍스트 포맷팅',
        'sicon-check-circle' => '원형 체크',
        'sicon-upload-lg' => '업로드 Lg',
        'sicon-flag-lg' => '깃발 Lg',
        'sicon-studio-lg' => '스튜디오 Lg',
        'sicon-contact-lg' => '연락처 Lg',
        'sicon-edit-lg' => '편집 Lg',
        'sicon-arrow-left' => '왼쪽 화살표',
        'sicon-reply-all' => '전체 답장하기',
        'sicon-message-lg' => '메시지 Lg',
        'sicon-info-lg' => '정보 Lg',
        'sicon-error-lg' => '오류 Lg',
        'sicon-check-circle-line-lg' => '원형 체크 라인 Lg',
        'sicon-warning-line-lg' => '경고 라인 Lg',
        'sicon-arrow-up' => '위쪽 화살표',
        'sicon-arrow-right' => '오른쪽 화살표',
        'sicon-nodes' => '노드',
        'sicon-hide' => '숨김',
        'sicon-help' => '도움말',
        'sicon-twitter' => '트위터',
        'sicon-message' => '메세지',
        'sicon-sugar-predict-lg' => 'Sugar Predict Lg',
        'sicon-sugar-predict' => 'Sugar Predict',
        'sicon-opportunity-lg' => '영업기회 Lg',
        'sicon-lead-lg' => '관심고객 Lg',
        'sicon-account-lg' => '계정 Lg',
        'sicon-user-sm' => '사용자 Sm',
        'sicon-quote-lg' => '견적 Lg',
        'sicon-equal' => '동일',
        'sicon-slicers-xl' => '슬라이서 Xl',
        'sicon-escalation-lg' => '에스컬레이션 Lg',
        'sicon-add-circle-lg' => '원형 추가 Lg',
        'sicon-add-line-lg' => '라인 추가 Lg',
        'sicon-add-target-lg' => '대상 추가 Lg',
        'sicon-help-circle-lg' => '원형 도움말 Lg',
        'sicon-divide-line-lg' => '라인 분할 Lg',
        'sicon-string' => '스트링',
        'sicon-filter' => '필터',
        'sicon-number' => '숫자',
        'sicon-format-lg' => '포맷 Lg',
        'sicon-insights-lg' => '인사이트 Lg',
        'sicon-invalid-circle-lg' => '무효 원형 Lg',
        'sicon-layout-xl' => '지면 배치 Xl',
        'sicon-layout-lg' => '레이아웃 Lg',
        'sicon-multiply-line-lg' => '곱셈 라인 Lg',
        'sicon-redo-lg' => '다시 실행 Lg',
        'sicon-refresh-lg' => '새로 고침 Lg',
        'sicon-undo-lg' => '실행 취소 Lg',
        'sicon-activity-feed-xl' => '활동 피드 Xl',
        'sicon-chevron-left-xl' => '왼쪽 꺾쇠 Xl',
        'sicon-close-xl' => '닫기 Xl',
        'sicon-kebab-lg' => '케밥 Lg',
        'sicon-insights-xl' => '인사이트 Xl',
        'sicon-hide-lg' => '숨김 Lg',
        'sicon-kebab-xl' => '케밥 Xl',
        'sicon-comment-xl' => '의견 Xl',
        'sicon-share-lg' => '공유 Lg',
        'sicon-trash' => '휴지통',
        'sicon-launch-lg' => '시작 Lg',
        'sicon-thumbs-up-lg' => '엄지손가락 위 Lg',
        'sicon-thumbs-down-lg' => '엄지손가락 아래 Lg',
        'sicon-warning-lg' => '경고 Lg',
        'sicon-wizard-circle-xl' => '마법사 원형 Xl',
        'sicon-bell-cross-lg' => '벨 크로스 Lg',
        'sicon-bell-lg' => '벨 Lg',
        'sicon-daily-lg' => '데일리 Lg',
        'sicon-cloud-download-lg' => '클라우드 다운로드 Lg',
        'sicon-unlock' => '저장되지 않은 변경사항',
        'sicon-news-lg' => '뉴스 Lg',
        'sicon-weekly-lg' => '주간 Lg',
        'sicon-knowledgebase-xl' => '지식 베이스 Xl',
        'sicon-remove' => '제거',
        'sicon-chevron-down' => '아래쪽 꺾쇠',
        'sicon-slicers-lg' => '슬라이서 Lg',
        'sicon-save-lg' => '저장 Lg',
        'sicon-info-circle-lg' => '정보 원형 Lg',
        'sicon-chevron-right' => '오른쪽 꺾쇠',
        'sicon-warning-circle-lg' => '원형 경고 Lg',
        'sicon-right-paren-line-lg' => '오른쪽 소괄호 라인 Lg',
        'sicon-comment-lg' => '의견 Lg',
        'sicon-target-lg' => '목표고객 Lg',
        'sicon-subtract-line-lg' => '빼기 라인 Lg',
        'sicon-settings-lg' => '설정 Lg',
        'sicon-left-paren-line-lg' => '왼쪽 소괄호 라인 Lg',
        'sicon-preview-lg' => '미리 보기 Lg',
        'sicon-thumbs-down-line-lg' => '엄지손가락 아래 라인 Lg',
        'sicon-thumbs-up-line-lg' => '엄지손가락 위 라인 Lg',
        'sicon-send-lg' => '전송 Lg',
        'sicon-contact-xl' => '연락처 Xl',
        'sicon-wizard-circle-line-xl' => '마법사 원형 라인 Xl',
        'sicon-trash-lg' => '휴지통 Lg',
        'sicon-pin-lg' => '핀 Lg',
        'sicon-clock-lg' => '시계 Lg',
        'sicon-comment-line-xl' => '의견 라인 Xl',
        'sicon-dropdown-editor' => '드롭다운 편집기',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => '오류',
        'sicon-catalog' => '카탈로그',
        'sicon-cloud' => '클라우드',
        'sicon-config-api' => '구성 API',
        'sicon-config-nav' => '구성 탐색',
        'sicon-connectors' => '연결기',
        'sicon-contracts' => '계약',
        'sicon-currencies' => '통화',
        'sicon-diagnostics' => '진단',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => '이메일 캠페인',
        'sicon-email-inbound' => '이메일 인바운드',
        'sicon-email-queue' => '대기 이메일',
        'sicon-forecasts' => '예상',
        'sicon-display-modules' => '모듈 전시',
        'sicon-email-contacts' => '이메이르 연락처',
        'sicon-import' => '자료 가져오기',
        'sicon-log-viewer' => '로그 뷰어',
        'sicon-lab' => '랩',
        'sicon-map-pin' => '지도 핀',
        'sicon-manufacturers' => '제조자',
        'sicon-update' => '업데이트',
        'sicon-content-security' => '콘텐츠 보안',
        'sicon-module-builder' => '모듈 빌더',
        'sicon-languages' => '언어',
        'sicon-module-loader' => '모듈 로더',
        'sicon-oauth-key' => '인증 키',
        'sicon-password-mgmt' => '비밀번호 관리',
        'sicon-opportunities' => '영업기회',
        'sicon-upgrade' => '업그레이드',
        'sicon-portal' => '포탈',
        'sicon-product-types' => '상품 유형',
        'sicon-quotes' => '견적',
        'sicon-relate-fields' => '필드 연결',
        'sicon-repair' => '수리',
        'sicon-role-mgmt' => '역할 관리',
        'sicon-scheduler' => '일정 관리',
        'sicon-shippers' => '배송자',
        'sicon-studio' => '작업실',
        'sicon-web-logic' => '웹 로직',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => '세율',
        'sicon-team-mgmt' => '팀 관리',
        'sicon-team-perm' => '팀 Perm',
        'sicon-tracker' => '추적기',
        'sicon-workflow' => '작업흐름',
        'sicon-mask' => '마스크',
        'sicon-mask-disabled' => '마스크 비활성',
        'sicon-email-archive' => '이메일 아카이브',
        'sicon-mobile' => '휴대폰',
        'sicon-archive' => '보관하기',
        'sicon-automate-scroll' => '세로 스크롤 보기',
        'sicon-automate-stacked' => '가로 스크롤 보기',
        'sicon-pdf-manager' => 'PDF 관리자',
        'sicon-my-sites' => '내 사이트',
        'sicon-cloud-insights' => '클라우드 인사이트',
        'sicon-sugar-logo-24' => 'Sugar 로고 24',
        'sicon-sugar-logo-16' => 'Sugar 로고 16',
        'sicon-task-lg' => '태스크 Lg',
        'sicon-web-lg' => '웹 Lg',
        'sicon-events-lg' => '이벤트 Lg',
        'sicon-sugar-logo-12' => 'Sugar 로고 12',
        'sicon-tag' => '태그',
        'sicon-tag-lg' => '태그 Lg',
        'sicon-bell-lg-line' => '벨 Lg 라인',
        'sicon-matrix-xxl' => '매트릭스 Xxl',
        'sicon-advanced-filter' => '고급 필터',
        'sicon-rows-and-columns-xxl' => '행렬 Xxl',
        'sicon-summation-details-xxl' => '요약 세부정보 Xxl',
        'sicon-summation-xxl' => '요약 Xxl',
        'sicon-lock-lg' => '자물쇠 Lg',
        'sicon-csv-file-xxl' => 'CSV 파일 Xxl',
        'sicon-logo-linkedin' => '로고 링크드인',
        'sicon-briefcase' => '서류가방',
        'sicon-car-front' => '자동차 전면',
        'sicon-airplane' => '비행기',
        'sicon-laptop' => '노트북',
        'sicon-logo-instagram' => '로고 인스타그램',
        'sicon-single-bed' => '싱글 베드',
        'sicon-tiktok' => '틱톡',
        'sicon-logo-snapchat' => '로고 스냅챗',
        'sicon-video-lg' => '비디오 Lg',
        'sicon-reply' => '답장하기',
        'sicon-subtract' => '빼기',
        'sicon-arrow-up-circle-line' => '위쪽 화살표 원형 라인',
        'sicon-asterisk' => '별표(*)',
        'sicon-dot-circle-o-lg' => '도트 원형 O Lg',
        'sicon-forward' => '전달',
        'sicon-video' => '영상',
        'sicon-gavel' => '망치',
        'sicon-login' => '로그인',
        'sicon-pdf-file-xxl' => 'PDF 파일 Xxl',
        'sicon-login-lg' => '로그인 Lg',
        'sicon-cloud-download-xl' => '클라우드 다운로드 Xl',
        'sicon-campaigns-lg' => '캠페인 Lg',
        'sicon-customer-journey-stages-lg' => '고객 여정 단계 Lg',
        'sicon-role-mgmt-lg' => '역할 관리 Lg',
        'sicon-default-module-lg' => '기본 모듈 Lg',
        'sicon-quoted-line-items-lg' => '견적 라인아이템 Lg',
        'sicon-projects-lg' => '프로젝트 Lg',
        'sicon-process-business-rules-lg' => '프로세스 비즈니스 규칙 Lg',
        'sicon-process-email-templates-lg' => '프로세스 이메일 템플릿 Lg',
        'sicon-processes-lg' => '프로세스 Lg',
        'sicon-process-definitions-lg' => '프로세스 정의 Lg',
        'sicon-target-lists-lg' => '목표고객 목록 Lg',
        'sicon-purchased-line-items-lg' => '구매한 라인아이템 Lg',
        'sicon-user-group-lg' => '사용자 그룹 Lg',
        'sicon-revenue-line-items-lg' => '매출 라인아이템 Lg',
        'sicon-business-centers-lg' => '비즈니스 센터 Lg',
        'sicon-logo-fb-simple' => '로고 Fb 심플',
        'sicon-forecasts-lg' => '예상 Lg',
        'sicon-contracts-lg' => '계약 Lg',
        'sicon-purchase-lg' => '구매 Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => '고객 여정 Lg',
        'sicon-data-privacy-lg' => '데이터 프라이버시 Lg',
        'sicon-home-lg' => '홈 Lg',
        'sicon-data-table' => '데이터 표',
        'sicon-medical-clipboard-lg' => '의학 클립보드 Lg',
        'sicon-privacy-lg' => '프라이버시 Lg',
        'sicon-marketplace' => '시장',
        'sicon-marketplace-lg' => '시장 Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => '카지노 Lg',
        'sicon-jacuzzi-lg' => '자쿠지 Lg',
        'sicon-scissors-lg' => '가위 Lg',
        'sicon-storage-lg' => '저장소 Lg',
        'sicon-fan-lg' => '팬 Lg',
        'sicon-medicine-lg' => '의학 Lg',
        'sicon-plant-lg' => '플랜트 Lg',
        'sicon-telescope-lg' => '망원경 Lg',
        'sicon-smart-phone-lg' => '스마트폰 Lg',
        'sicon-coffee-lg' => '커피 Lg',
        'sicon-martini-lg' => '마티니 Lg',
        'sicon-cocktail-lg' => '칵테일 Lg',
        'sicon-stadium-lg' => '스타디움 Lg',
        'sicon-fire-lg' => '불 Lg',
        'sicon-window-lg' => '창문 Lg',
        'sicon-lotus-lg' => '연꽃 Lg',
        'sicon-windmill-lg' => '풍차 Lg',
        'sicon-spades-lg' => '스페이드 Lg',
        'sicon-hearts-lg' => '하트 Lg',
        'sicon-diamonds-lg' => '다이아몬드 Lg',
        'sicon-clubs-lg' => '클로버 Lg',
        'sicon-skull-lg' => '해골 Lg',
        'sicon-send' => '전송',
        'sicon-world-lg' => '세계 Lg',
        'sicon-airplane-lg' => '비행기 Lg',
        'sicon-planet-lg' => '행성 Lg',
        'sicon-trainer-lg' => '트레이너 Lg',
        'sicon-calculator-lg' => '계산기 Lg',
        'sicon-tv-lg' => 'TV Lg',
        'sicon-video-player-lg' => '비디오 플레이어 Lg',
        'sicon-media-player-lg' => '미디어 플레이어 Lg',
        'sicon-decentralize-lg' => '탈중앙화 Lg',
        'sicon-statistics-lg' => '통계 Lg',
        'sicon-virus-lg' => '바이러스 Lg',
        'sicon-shield-lg' => '쉴드 Lg',
        'sicon-plug-lg' => '플러그 Lg',
        'sicon-shuttle-lg' => '셔틀 Lg',
        'sicon-soundwave-lg' => '사운드웨이브 Lg',
        'sicon-graph-lg' => '그래프 Lg',
        'sicon-playlist-lg' => '플레이리스트 Lg',
        'sicon-voice-recognition-lg' => '음성 인식 Lg',
        'sicon-machine-learning-lg' => '머신 러닝 Lg',
        'sicon-bed-lg' => '침대 Lg',
        'sicon-blueprint-lg' => '청사진 Lg',
        'sicon-content-delivery-lg' => '콘텐츠 전송 Lg',
        'sicon-questionnaire-lg' => '설문지 Lg',
        'sicon-presentation-lg' => '프레젠테이션 Lg',
        'sicon-organic-lg' => '유기농 Lg',
        'sicon-transactions-lg' => '거래 Lg',
        'sicon-wand-lg' => '지팡이 Lg',
        'sicon-bin-lg' => '통 Lg',
        'sicon-sync-lg' => '동기화 Lg',
        'sicon-external-authentication-lg' => '외부 인증 Lg',
        'sicon-tracking-activity-lg' => '추적 활동 Lg',
        'sicon-account' => '거래처',
        'sicon-meetings-lg' => '회의 Lg',
        'sicon-stacked' => '수평 분할 보기',
        'sicon-sidebyside' => '수직 분할 보기',
        ],

        'module_colors_dom' => [
        'army' => '군대',
        'coral' => '코럴',
        'green' => '녹색',
        'orange' => '오렌지',
        'ocean' => '바다',
        'pacific' => '태평양',
        'pink' => '핑크',
        'purple' => '보라',
        'red' => '빨강',
        'teal' => '청록',
        'yellow' => '노랑',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => '신규',
        'In Progress' => '진행 중',
        'Closed' => '완료',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => '비활동',
        'Lack of Progress' => '진행 부족',
        'Customer-Imposed Deadline' => '고객이 정한 기한',
        'Account at Risk' => '위험에 처한 거래처',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => '고객 요청함',
        'Internally Requested' => '내부 요청함',
        ],
        'parent_type_display_escalations' => [
        'Cases' => '사례',
        'Bugs' => '오류',
        'Accounts' => '거래처',
        'Opportunities' => '영업기회',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => '긍정',
        'Negative' => '부정',
        'Neutral' => '중간',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => '가능성이 없음',
        '02_less_likely' => '가능성이 낮음',
        '03_neutral' => '중간',
        '04_more_likely' => '가능성이 높음',
        '05_very_likely' => '가능성이 매우 높음',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => '고객과 일치하지 않음',
        '02_no_match' => '',
        '01_matches_customers' => '고객과 일치',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => '관심고객',
        'Accounts' => '거래처',
        'Contacts' => '연락처',
        'Cases' => '사례',
        'Opportunities' => '영업기회',
        ],
        'dri_workflows_state_list' => [
        'not_started' => '시작하지 않았음',
        'in_progress' => '진행 중',
        'completed' => '완료',
        'cancelled' => '취소됨',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => '없음',
        'create' => '생성 중',
        'stage_start' => '단계 시작 중',
        'previous_activity_completed' => '이전 활동 완료됨',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => '현 사용자',
        'parent_assignee' => '상위 피할당자',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => '생성 후 일수',
        'days_from_stage_started' => '단계 시작 후 일수',
        'days_from_previous_activity_completed' => '이전 활동 완료 후 일수',
        'days_from_parent_date_field' => '상위 날짜 필드 후 일수',
        'days_from_specific_activity_completed' => '특정 활동 완료 후 일수',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => '생성 시',
        'stage_started' => '단계 시작 시',
        'previous_activity_completed' => '이전 활동 완료 시',
        'parent_date_field' => '상위 날짜 필드에서',
        'specific_activity_completed' => '특정 활동 완료됨',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => '절대값',
        'Percentage' => '백분율',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => '고객 업무',
        'milestone' => '이정표',
        'internal_task' => '내부 업무',
        'agency_task' => '에이전시 업무',
        'automatic_task' => '자동 업무',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => '작업',
        'Calls' => '전화',
        'Meetings' => '회의',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => '없음',
        'create' => '생성 중',
        'stage_start' => '단계 시작 중',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => '상속',
        'current_user' => '현 사용자',
        'parent_assignee' => '상위 피할당자',
        'user' => '사용자',
        'team' => '담당부서',
        'user_team' => '사용자 및 팀',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => '상속',
        'none' => '없음',
        'create' => '생성 중',
        'stage_start' => '단계 시작 중',
        'previous_activity_completed' => '이전 활동 완료됨',
        'specific_activity_completed' => '특정 활동 완료됨',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => '시작하지 않았음',
        'in_progress' => '진행 중',
        'not_completed' => '완료되지 않음',
        'completed' => '완료',
        'cancelled' => '취소됨',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => '단계 편집',
        'stage_add_task_button' => '작업 추가하기',
        'stage_add_meeting_button' => '회의일정',
        'stage_add_call_button' => '전화 일정잡기',
        'stage_delete_button' => '단계 삭제',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => '업무 추가',
        'activity_add_sub_meeting_button' => '회의일정',
        'activity_add_sub_call_button' => '전화 일정잡기',
        'activity_not_applicable_button' => '해당 사항 없음',
        'activity_delete_button' => '삭제',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => '설정 적용 불가',
        'remove_open_activities' => '열린 활동 삭제',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => '기본설정',
        'custom' => '사용자 지정',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => '받기',
        'POST' => '게시',
        'PUT' => '올리기',
        'PATCH' => 'PATCH',
        'DELETE' => '삭제하기',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => '요청 건너뛰기',
        'json' => 'JSON',
        'http_query' => 'HTTP 쿼리',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => '응답 없음',
        'json' => 'JSON',
        'http_query' => 'HTTP 쿼리',
        'text' => '단순 문장',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => '생성 전',
        'after_create' => '생성 후',
        'before_in_progress' => '진행중 전',
        'after_in_progress' => '진행중 후',
        'before_completed' => '완료함 전',
        'after_completed' => '완료함 후',
        'before_not_applicable' => '적용 불가 전',
        'after_not_applicable' => '적용 불가 후',
        'before_delete' => '삭제 전',
        'after_delete' => '삭제후',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Smart Guide 정보 전송',
        'custom_body' => '사용자 정의 게시물 본문 전송',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => '진행 중',
        'completed' => '완료',
        'not_applicable' => '해당 사항 없음',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => '레코드 보기',
        'create_record' => '기록 만들기',
        'update_record' => '기록 업데이트',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => '레코드 자동 생성',
        'manual_create' => '레코드 수동 생성',
        'automatic_update' => '레코드 자동 업데이트',
        'manual_update' => '레코드 수동 업데이트',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Smart Guide 템플릿',
        'DRI_SubWorkflow_Templates' => '단계 템플릿',
        'DRI_Workflow_Task_Templates' => '활동 템플릿',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => '예',
        'no' => '아니요',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => '개최',
        'Not Held' => '시작되지 않음',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => '개최',
        'Not Held' => '시작되지 않음',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => '완료',
        'Not Applicable' => '해당 사항 없음',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Smart Guide 템플릿',
        'DRI_SubWorkflow_Templates' => '단계 템플릿',
        'DRI_Workflow_Task_Templates' => '활동 템플릿',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => '작업',
        'Meetings' => '회의',
        'Calls' => '전화',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => '현재 업무',
        'Calls' => '현재 통화',
        'Meetings' => '현재 회의',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => '특정 사용자',
        'specific_contacts' => '특정 연락처',
        'related_parent_users' => '관련 상위 사용자',
        'related_parent_contacts' => '관련 상위 연락처',
        'add_all_contacts_from_parent' => '모든 상위 연락처 추가',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => '사용자',
        'specific_contacts' => '연락처',
        'related_parent_users' => '사용자',
        'related_parent_contacts' => '연락처',
        'add_all_contacts_from_parent' => '연락처',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => '분',
        'hours' => '시',
        'days' => '일',
        'months' => '월',
        ],
        'cj_relative_date_type_list' => [
        'days' => '일',
        'months' => '월',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => '지정일',
        'relative' => '상대적 날짜',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => '사용자',
        'teams' => '팀',
        'roles' => '역할',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide→Sugar 액션',
        'sugar_action_to_smart_guide' => 'Sugar 액션→Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide 단계',
        'Smart Guide Activities' => 'Smart Guide 활동',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => '완료',
        'cancelled' => '취소',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => '진행 중',
        'completed' => '완료',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => '진행 중',
        'completed' => '완료',
        'not_applicable' => '해당 사항 없음',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => '모든 활동을 완료됨으로 표시',
        'mark_all_not_applicable' => '모든 미완료 활동을 해당 사항 없음으로 표시',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => '미국(오리건주)[us-west-2]',
        'ca-central-1' => '캐나다(중부)[ca-central-1]',
        'ap-southeast-1' => '아시아 태평양(싱가포르)[ap-southeast-1]',
        'ap-southeast-2' => '아시아 태평양(시드니)[ap-southeast-2]',
        'eu-central-1' => '유럽(프랑크푸르트)[eu-central-1]',
        'eu-west-2' => '유럽(런던)[eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => '머릿글 기록하기', // Studio editing of record views
    'LBL_RECORD_BODY' => '명함', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => '더 보기', // Studio editing of record views
    'LBL_FAVORITE' => '즐겨찾기', // Record view header panel element
    'LBL_FOLLOW' => '팔로잉', // Record view header panel element
    'LBL_FOLLOW_LINK' => '링크 팔로잉',
    'LBL_TOGGLE_VISIBILITY' => '토글 가시성', // Record view header panel element
    'LBL_ACTIVITIES' => '액티비티 스트림',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar 및 3-D 큐브는 SugarCRM Inc. 등록상표입니다. ' .
        '이 제품에 사용되거나 나타난 모든 여타 기업 및 상품명은 ' .
        'SugarCRM®, Sugar Enterprise™, Sugar™는 SugarCRM Inc.의 상표입니다.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™, Sugar™는 SugarCRM Inc의 상표입니다.',
    'LBL_SEND_INVITE' => '초대하기',
    'LBL_INVITEES' => '게스트',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => '손님이 당신의 초대를 받지 않습니다.',
    'LBL_SELECT_ACTION_LABEL' => '액션 선택',
    'LBL_TOGGLE_DRAWER' => '토글 서랍',
    'LBL_TOUR_NEXT' => '다음',
    'LBL_TOUR_SKIP' => '생략',
    'LBL_TOUR_BACK' => '뒤로',
    'LBL_TOUR_CLOSE' => '완료',
    'LBL_TOUR_BTN_DONE' => '완료',
    'LBL_TOUR_TAKE_TOUR' => '둘러보기',
    'LBL_TOUR_FULL_TOUR' => '전체 둘러보기',
    'LBL_TOUR_MODULE' => '페이지 둘러보기',
    'LBL_TOUR_END_TOUR' => '둘러보기 끝내기',
    'LBL_TOUR_OVERVIEW' => '페이지 전체보기',
    'LBL_TOUR_REVISIT' => '언제든지 투어를 표시하려면 여기를 클릭하십시오.',
    'LBL_MY_AREA_LINKS' => 'My area links:' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Getting Air' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => '환영합니다' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => '고급 검색' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => '세부정보' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => '바로 수정' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => '보기' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => '검색' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => '검색중' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => '제거' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => '추가' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => '1열' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2열' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3열' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => '고급 검색' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => '추가' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => '접기/열기' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => '삭제' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => '추가' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => '지움' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => '제거' /*for 508 compliance fix*/,
    'LBL_ADD' => '추가' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => '회사 로고' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => '캘린더' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => '선택한 드롭다운 값으로 인해 기록 보기 레이아웃이 변경되었습니다.' .
        '새 레이아웃에서 숨겨진 필드 값은 삭제됩니다.',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => '최대화',
    'LBL_SIDEBAR_NAV_CLOSE' => '닫기',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} 메뉴',
    'LBL_GOTO_SUGARCRM_COM' => 'SugarCRM.com 이동',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => '메인 모듈 탐색',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => '서브 전환',

    'LBL_ADVANCED' => '고급',
    'LBL_BASIC' => '기본',
    'LBL_MODULE_FILTER' => '다음 조건으로 필터됨',
    'LBL_CONNECTORS_POPUPS' => '접속창 열기',
    'LBL_CLOSEINLINE' => '닫기',
    'LBL_EDITINLINE' => '수정',
    'LBL_VIEWINLINE' => '보기',
    'LBL_INFOINLINE' => '정보',
    'LBL_POWERED_BY_SUGARCRM' => 'SugarCRM 제공',
    'LBL_PRINT' => '인쇄하기',
    'LBL_HELP' => '도움말',
    'LBL_TOUR' => '둘러보기',
    'LBL_TOUR_LINK' => '이 페이지 둘러보기',
    'LBL_MOBILE' => '휴대폰',
    'LBL_ID_FF_SELECT' => '선택하기',
    'DEFAULT' => '기본',
    'LBL_SORT' => '정열',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => '이메일전송서버추가',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'SMTP서버를 SSL 혹은 TLS중에 선택해주십시오',
    'LBL_NO_ACTION' => '올바르지 않은 주소입니다.',
    'LBL_NO_DATA' => '자료가 없습니다.',
    'LBL_NOT_APPLICABLE' => '해당 사항 없음',
    'LBL_ROUTING_ADD_RULE' => '역할 추가',
    'LBL_ROUTING_ALL' => '최소한',
    'LBL_ROUTING_ANY' => '모든',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => '취소',
    'LBL_ROUTING_BUTTON_SAVE' => '저장',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => '메일 복제',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'SugarCRM 개체 삭제하기',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => '파일 삭제하기',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => '이메일 삭제하기',
    'LBL_ROUTING_ACTIONS_FORWARD' => '이메일 보내기',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => '이메일 플래그 표시',
    'LBL_ROUTING_ACTIONS_MARK_READ' => '읽음 표시',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => '읽지 않음 표시',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => '이메일 이동',
    'LBL_ROUTING_ACTIONS_PEFORM' => '다음 액션을 실행합니다.',
    'LBL_ROUTING_ACTIONS_REPLY' => '이메일에 답장',

    'LBL_ROUTING_CHECK_RULE' => "장애가 감지되었습니다.",
    'LBL_ROUTING_CHECK_RULE_DESC' => '표시된 모든 필드를 확인하십시오.',
    'LBL_ROUTING_CONFIRM_DELETE' => "이 역할을 삭제하시겠습니까?<br/> 삭제된 역할은 복구될 수 없습니다.",

    'LBL_ROUTING_FLAGGED' => '플래그 설정',
    'LBL_ROUTING_FORM_DESC' => '저장된 역할은 즉시 실행됩니다.',
    'LBL_ROUTING_FW' => 'FW:',
    'LBL_ROUTING_LIST_TITLE' => '역할',
    'LBL_ROUTING_MATCH' => '만약',
    'LBL_ROUTING_MATCH_2' => '다음의 조건이 맞습니다.',
    'LBL_NOTIFICATIONS' => '알림',
    'LBL_ROUTING_MATCH_CC_ADDR' => '참조',
    'LBL_ROUTING_MATCH_DESCRIPTION' => '본문 내용',
    'LBL_ROUTING_MATCH_FROM_ADDR' => '발신인',
    'LBL_ROUTING_MATCH_NAME' => '주제',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => '중요도 상',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => '중요도 중',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => '중요도 하',
    'LBL_ROUTING_MATCH_TO_ADDR' => '수신인',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => '포함',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => '포함하지 않습니다.',

    'LBL_ROUTING_NAME' => '역할 이름',
    'LBL_ROUTING_NEW_NAME' => '신규 역할',
    'LBL_ROUTING_ONE_MOMENT' => '잠시만 기다리십시오.',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => '원(Original) 메세지가 나옵니다.',
    'LBL_ROUTING_RE' => 'RE:',
    'LBL_ROUTING_SAVING_RULE' => '역할 저장중입니다.',
    'LBL_ROUTING_SUB_DESC' => '선택된 역할은 실행중입니다. 편집하려면 이름을 클릭하십시오.',
    'LBL_ROUTING_TO' => '수신자',
    'LBL_ROUTING_TO_ADDRESS' => '주소로',
    'LBL_ROUTING_WITH_TEMPLATE' => '템플릿과 함께',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => '이 레코드는 사무실 전화번호와 주소 값을 가지고 있습니다. 이 값을 선택한 거래처의 사무실 번호와 주소로 덮어쓰려면 &#39;예&#39;를 클릭하십시오. 지금 값을를 유지하려면 취소를 클릭하십시오.',
    'LBL_DROP_HERE' => '여기에 내리기',
    'LBL_EMAIL_ACCOUNTS_EDIT' => '수정',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Prefill Gmail&#153; 기본',
    'LBL_EMAIL_ACCOUNTS_NAME' => '이름',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => '발신 메일 서버 소유권',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => '메일 운반 대행',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'SMTP 인증을 사용하시겠습니까?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP 비밀번호',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP 포트',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP 서버',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => '연결시 SSL를 사용하십시오.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP 사용자명',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => '기본',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => '경고: 발신 메일 계정의 분실된 사용자명과 비밀번호',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP 사용자명이 필요합니다.',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP 비밀번호가 필요합니다.',
    'LBL_EMAIL_ACCOUNTS_TITLE' => '메일 계정 관리',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'POP3는 지원하지 않습니다. IMAP만 지원됩니다.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => '귀하의 이메일 계정으로부터 수신 이메일을 보기위한 메일 계정을 설정합니다.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => '메일계정에서 발신 이메일을 위해 사용할 SMTP메일 서버를 입력합니다.',
    'LBL_EMAIL_ADD' => '이메일 추가',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => '완료',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => '비우기',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => '수신인',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => '참조',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => '숨은 참조',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => '수신인/참조/숨은참조',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => '신규 목록',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => '이메일 주소',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => '오직 연락처 편집만 지원됩니다.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => '필터',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => '이름/거래처명',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => '성',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => '내 연락처',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => '내 우편 목록',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => '이름',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => '발견된 주소가 없습니다.',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => '저장후 주소록에 추가',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => '검색',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => '이메일 수신인 선택',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => '주소록',
    'LBL_EMAIL_REPORTS_TITLE' => '보고서',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => '경고! 삭제하려는 발신계정이 기존 수신 계정과 관련되어 있습니다. 계속 하시겠습니까?',
    'LBL_EMAIL_ADDRESSES' => '이메일',
    'LBL_EMAIL_ADDRESS_PRIMARY' => '이메일 주소',
    'LBL_EMAIL_ADDRESSES_TITLE' => '이메일 주소',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'SugarCRM으로 가져오기',
    'LBL_EMAIL_ASSIGNMENT' => '과제',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => '첨부하기',
    'LBL_EMAIL_ATTACHMENT' => '첨부하기',
    'LBL_EMAIL_ATTACHMENTS' => '내 컴퓨터의 문서 첨부하기',
    'LBL_EMAIL_ATTACHMENTS2' => 'SugarCRM의 문서 첨부하기',
    'LBL_EMAIL_ATTACHMENTS3' => '템플릿 첨부',
    'LBL_EMAIL_ATTACHMENTS_FILE' => '파일',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => '문서',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => '삽입된',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => '첨부문서 업로드가 실패했습니다.',
    'LBL_REMOVING_ATTACHMENT' => '첨부 파일 제거…',
    'LBL_EMAIL_BCC' => '숨은 참조',
    'LBL_EMAIL_CANCEL' => '취소',
    'LBL_EMAIL_CC' => '참조',
    'LBL_EMAIL_CHARSET' => '문자 설정',
    'LBL_EMAIL_CHECK' => '메일 확인',
    'LBL_EMAIL_CHECKING_NEW' => '신규 이메일 확인',
    'LBL_EMAIL_CHECKING_DESC' => '잠시만 기다려주십시오.<br />메일 계정을 처음 확인할 때 약간의 시간이 소요될수 있습니다.',
    'LBL_EMAIL_CLOSE' => '닫기',
    'LBL_EMAIL_COFFEE_BREAK' => '신규 이메일을 확인중입니다.<br />대용량 메일 계정은 상당한 시간이 걸릴수 있습니다.',
    'LBL_EMAIL_COMMON' => '보통',

    'LBL_EMAIL_COMPOSE' => '이메일',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => '이 이메일의 수신자를 입력하십시오.',
    'LBL_EMAIL_COMPOSE_LINK_TO' => '다음과 관련',
    'LBL_EMAIL_COMPOSE_NO_BODY' => '이 이메일의 본문이 비어있습니다. 전송하시겠습니까?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => '이 이메일에는 제목이 없습니다. 전송하시겠습니까?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '제목없음',
    'LBL_EMAIL_COMPOSE_READ' => '읽고 이메일 작성하기',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => '메일 계정으로부터 전송하기',
    'LBL_EMAIL_COMPOSE_OPTIONS' => '선택사항',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => '수신인, 참조, 숨은참조 필드에 유효한 이메일 주소를 입력하십시오.',

    'LBL_EMAIL_CONFIRM_CLOSE' => '이 이메일을 버리시겠습니까?',
    'LBL_EMAIL_CONFIRM_DELETE' => '주소록에서 이 항목들을 제거하시겠습니까?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => '이 서명을 삭제하시겠습니까?',

    'LBL_EMAIL_CREATE_NEW' => '생성하여 저장',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => '복합',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => '비어있음',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => '보낸이에 의해 보낸 날짜',
    'LBL_EMAIL_DATE_RECEIVED' => '수신 날짜',
    'LBL_EMAIL_ASSIGNED_TO_USER' => '담당자',
    'LBL_EMAIL_DATE_TODAY' => '오늘',
    'LBL_EMAIL_DATE_YESTERDAY' => '어제',
    'LBL_EMAIL_DD_TEXT' => '이메일이 선택되었습니다.',
    'LBL_EMAIL_DEFAULTS' => '초기설정',
    'LBL_EMAIL_DELETE' => '삭제',
    'LBL_EMAIL_DELETE_CONFIRM' => '선택된 메세지를 삭제하시겠습니까?',
    'LBL_EMAIL_DELETE_SUCCESS' => '이메일이 성공적으로 삭제되었습니다.',
    'LBL_EMAIL_DELETING_MESSAGE' => '메세지 삭제중입니다.',
    'LBL_EMAIL_DETAILS' => '세부사항',
    'LBL_EMAIL_DISPLAY_MSG' => '이메일 {0} - {1} of {2} 표시하기',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => '이메일 주소 {0} - {1} of {2} 표시하기',

    'LBL_EMAIL_EDIT_CONTACT' => '연락처 편집하기',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => '연락처 활성시 기본 주소가 사용됩니다.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => '우편 목록 편집하기',

    'LBL_EMAIL_EMPTYING_TRASH' => '휴지통 지우기',
    'LBL_EMAIL_DELETING_OUTBOUND' => '발신 서버 삭제중입니다.',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => '캐시 파일을 비우는 중입니다.',
    'LBL_EMAIL_EMPTY_MSG' => '표시할 이메일이 없습니다.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => '표시할 이메일 주소가 없습니다.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => '폴더명은 중복될 수 없으며 비워져 있을 수Blank) 없습니다. 다시 시도해주십시오.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => '폴더를 삭제할수 없습니다. 폴더나 그 하위 폴더가 관련된 이메일이나 우편함을 가지고 있습니다.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => '문맥에서 의도된 폴더를 결정할수 없습니다. 다시 시도해주십시오.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => '설정을 확인해 주십시오.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => '성을 기입했는지 확인해 주십시오.',
    'LBL_EMAIL_ERROR_DESC' => '장애가 감지되었습니다:',
    'LBL_EMAIL_DELETE_ERROR_DESC' => '접속권한이 없습니다. 접속하려면 관리자에 문의하십시오.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => '폴더명은 중복될 수 없습니다.',
    'LBL_EMAIL_ERROR_EMPTY' => '검색 범주를 입력하십시오',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => '오류가 발생했습니다.',
    'LBL_EMAIL_ERROR_LIST_NAME' => '그 이름의 이메일 목록이 이미 존재합니다.',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => '서버로부터 메세지가 제거되었습니다.',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => '서버로부터 메세지가 제거되었거나 다른 폴더로 이동했습니다.',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => '메일 서버로의 연결이 실패했습니다. 관리자에 문의하십시오.',
    'LBL_EMAIL_ERROR_MOVE' => '서버와 메일 계정사이의 이메일 이동이 지원되지 않습니다.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => '이동 오류',
    'LBL_EMAIL_ERROR_NAME' => '이름이 필요합니다.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => '발신자 주소가 필요합니다. 유효한 이메일 주소를 입력하십시오.',
    'LBL_EMAIL_ERROR_NO_FILE' => '파일을 입력하십시오.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'IMAP 폴더 이름바꾸기가 지원되지 않습니다.',
    'LBL_EMAIL_ERROR_SERVER' => '메일 서버 주소가 필요합니다.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => '메일 계정이 저장되지 않았을수 있습니다.',
    'LBL_EMAIL_ERROR_TIMEOUT' => '메일 서버와 대화중 오류가 발생했습니다.',
    'LBL_EMAIL_ERROR_USER' => '로그인명이 필요합니다.',
    'LBL_EMAIL_ERROR_PASSWORD' => '비밀번호가 필요합니다.',
    'LBL_EMAIL_ERROR_PORT' => '메일 서버포트가 필요합니다.',
    'LBL_EMAIL_ERROR_PROTOCOL' => '서버 통신규약이 필요합니다.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => '모니터된 폴더가 필요합니다.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => '휴지통 폴더가 필요합니다.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => '사용할수 없는 정보입니다.',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => '명시된 발신메일이 없습니다.',
    'LBL_EMAIL_FOLDERS' => '폴더',
    'LBL_EMAIL_FOLDERS_ACTIONS' => '다음으로 이동',
    'LBL_EMAIL_FOLDERS_ADD' => '추가',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => '신규 폴더 추가',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => '폴더 이름 바꾸기',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => '저장',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => '이 폴더를 다음에 추가합니다.',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => '이 폴더는 변경할 수 없습니다.',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => '이 폴더를 정말 삭제하시겠습니까? 이 요청은 번복될수 없습니다. 폴더와 하위폴더도 삭제됩니다.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => '신규 폴더명',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => '실행전 폴더를 선택하십시오.',
    'LBL_EMAIL_FOLDERS_TITLE' => '폴더 관리',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => '사용중인 그룹',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => '지정 팀',
    'LBL_EMAIL_FORWARD' => '전달',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => '[[total]] 이메일 중 [[count]] 다운로드됨',
    'LBL_EMAIL_FOUND' => '발견되었습니다.',
    'LBL_EMAIL_FROM' => '발신자',
    'LBL_EMAIL_GROUP' => '그룹',
    'LBL_EMAIL_UPPER_CASE_GROUP' => '그룹',
    'LBL_EMAIL_HOME_FOLDER' => '홈',
    'LBL_EMAIL_HTML_RTF' => 'HTML 보내기',
    'LBL_EMAIL_IE_DELETE' => '메일 계정을 삭제중입니다.',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => '서명을 삭제중입니다.',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => '이 메일 계정을 삭제하시겠습니까?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => '성공적으로 삭제되었습니다.',
    'LBL_EMAIL_IE_SAVE' => '메일계정 정보 저장중입니다.',
    'LBL_EMAIL_IMPORTING_EMAIL' => '이메일 가져오기 중입니다.',
    'LBL_EMAIL_IMPORT_EMAIL' => 'SugarCRM으로 가져오기',
    'LBL_EMAIL_IMPORT_SETTINGS' => '가져오기 설정',
    'LBL_EMAIL_INVALID' => '유효하지 않음',
    'LBL_EMAIL_LINK_RECORD' => '여기를 클릭하십시오',
    'LBL_EMAIL_LIST_RENAME_TITLE' => '우편 목록 이름 바꾸기',
    'LBL_EMAIL_LIST_RENAME_DESC ' => '우편 목록을 위한 신규 이름을 입력하십시오.',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => '우편목록에서 이 항목들을 제거하시겠습니까?',
    'LBL_EMAIL_LOADING' => '로딩중입니다.',
    'LBL_EMAIL_MARK' => '표시',
    'LBL_EMAIL_MARK_FLAGGED' => '플래그 됨',
    'LBL_EMAIL_MARK_READ' => '읽음',
    'LBL_EMAIL_MARK_UNFLAGGED' => '플래그 취소됨',
    'LBL_EMAIL_MARK_UNREAD' => '읽지 않음',
    'LBL_EMAIL_ASSIGN_TO' => '할당',

    'LBL_EMAIL_MENU_ADD_FOLDER' => '신규 폴더 만들기',
    'LBL_EMAIL_MENU_COMPOSE' => '다음에 작성',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => '폴더 삭제하기',
    'LBL_EMAIL_MENU_EDIT' => '수정',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => '휴지통 비우기',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => '일치화(Sync)',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => '캐시 파일 비우기',
    'LBL_EMAIL_MENU_REMOVE' => '제거하기',
    'LBL_EMAIL_MENU_RENAME' => '이름 변경',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => '폴더 이름변경하기',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => '폴더 이름변경중입니다.',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => '이 작업 시도전 선택을 하십시오.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => '신규 폴더를 만들기',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => '이 이메일을 SugarCRM에 보관',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => '우편목록에 선택된 이메일',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => '이 연락처에 이메일 보내기',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => '연락처 제거하기',
    'LBL_EMAIL_MENU_HELP_DELETE' => '이 이메일 삭제하기',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => '폴더를 삭제합니다. ( Sugar안 또는 밖에서)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => '연락처 편집하기',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => '우편 목록 편집하기',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => '귀하의 메일계정을 위한 휴지통폴더를 비웁니다.',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => '이 이메일에 플래그 표시합니다.',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => '이메일 읽음 표시',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => '플래그해제 이메일 표시',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => '읽지않은 이메일 표시',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => '우편목록 제거합니다.',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => '폴더명을 변경합니다. ( Sugar안 또는 밖에서)',
    'LBL_EMAIL_MENU_HELP_REPLY' => '이 이메일에 답장하기',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => '이 이메일의 모든 수신자에 답장합니다.',

    'LBL_EMAIL_MESSAGES' => '메세지',

    'LBL_EMAIL_ML_NAME' => '목록명',
    'LBL_EMAIL_ML_ADDRESSES_1' => '선택된 주소 목록',
    'LBL_EMAIL_ML_ADDRESSES_2' => '사용가능한 주소 목록',

    'LBL_EMAIL_MULTISELECT' => 'Ctrl-Click 으로 복합선택',

    'LBL_EMAIL_NO' => '아니오',
    'LBL_EMAIL_NOT_SENT' => '시스템이 귀하의 요청을 진행할수 없습니다. 관리자에 문의하십시오.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'users_password_link에 삽입할 수 없습니다.',

    'LBL_EMAIL_OK' => '확인',
    'LBL_EMAIL_ONE_MOMENT' => '잠시만 기다려 주십시오.',
    'LBL_EMAIL_OPEN_ALL' => '복합 메세지 열기',
    'LBL_EMAIL_OPTIONS' => '선택사항',
    'LBL_EMAIL_QUICK_COMPOSE' => '빠른 작성',
    'LBL_EMAIL_OPT_OUT' => '수신거부',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => '수신거부 & 유효하지 않음',
    'LBL_EMAIL_PAGE_AFTER' => '/ {0}',
    'LBL_EMAIL_PAGE_BEFORE' => '페이지',
    'LBL_EMAIL_PERFORMING_TASK' => '작업을 실행중입니다.',
    'LBL_EMAIL_PRIMARY' => '기본',
    'LBL_EMAIL_PRINT' => '출력',

    'LBL_EMAIL_QC_BUGS' => '오류',
    'LBL_EMAIL_QC_CASES' => '사례',
    'LBL_EMAIL_QC_LEADS' => '관심고객',
    'LBL_EMAIL_QC_CONTACTS' => '연락처',
    'LBL_EMAIL_QC_TASKS' => '작업',
    'LBL_EMAIL_QC_OPPORTUNITIES' => '영업기회',
    'LBL_EMAIL_QUICK_CREATE' => '빠른 만들기',

    'LBL_EMAIL_REBUILDING_FOLDERS' => '폴더 다시만들기',
    'LBL_EMAIL_RELATE_TO' => '관련',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => '관계 보기',
    'LBL_EMAIL_RECORD' => '이메일 기록',
    'LBL_EMAIL_REMOVE' => '제거하기',
    'LBL_EMAIL_REPLY' => '답장하기',
    'LBL_EMAIL_REPLY_ALL' => '전체 답장하기',
    'LBL_EMAIL_REPLY_TO' => '다음에 답장',
    'LBL_EMAIL_RETRIEVING_LIST' => '이메일 목록 복구',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => '메세지 복구중입니다.',
    'LBL_EMAIL_RETRIEVING_RECORD' => '이메일 기록 복구중입니다.',
    'LBL_EMAIL_SELECT_ONE_RECORD' => '하나의 이메일 레코드를 선택하십시오.',
    'LBL_EMAIL_RETURN_TO_VIEW' => '이전 모듈로 돌아가시겠습니까?',
    'LBL_EMAIL_REVERT' => '되돌아가기',
    'LBL_EMAIL_RELATE_EMAIL' => '관련 이메일',

    'LBL_EMAIL_RULES_TITLE' => '규칙 관리',

    'LBL_EMAIL_SAVE' => '저장하기',
    'LBL_EMAIL_SAVE_AND_REPLY' => '저장후 답장',
    'LBL_EMAIL_SAVE_DRAFT' => '임시 보관함에 저장',

    'LBL_EMAIL_SEARCHING' => '검색 실행중입니다.',
    'LBL_EMAIL_SEARCH_ADVANCED' => '고급 검색',
    'LBL_EMAIL_SEARCH_DATE_FROM' => '시작 날짜',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => '완료 날짜',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => '본문',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => '귀하의 검색 조건에 일치하는 결과가 없습니다.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => '검색 결과',
    'LBL_EMAIL_SEARCH_TITLE' => '간단 검색',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => '이메일 계정 검색',

    'LBL_EMAIL_SELECT' => '선택',

    'LBL_EMAIL_SEND' => '전송',
    'LBL_EMAIL_SENDING_EMAIL' => '이메일 전송중입니다.',

    'LBL_EMAIL_SETTINGS' => '설정',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 줄',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 세로열',
    'LBL_EMAIL_SETTINGS_LAYOUT' => '레이아웃 스타일',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => '메일 계정',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => '양식 비우기',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => '이메일 보기후 가져오기',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => '신규 메일 확인하기',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => '미리보기 판 사용하기',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => '팝업창 사용하기',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => '이메일 페이지당 번호넣기',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => '이메일 계정 편집하기',
    'LBL_EMAIL_SETTINGS_FOLDERS' => '폴더',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => '발신자 주소',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => '테스트를 위한 이메일 주소',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => '수신자 이메일 주소',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => '발신자명',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => '답장 주소',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => '전체 화면',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => '전체 메일계정 일치화',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => '입력된 메일 설정을 사용한 특정 이메일 주소로 이메일이 전송되었습니다. 설정이 올바른지 확인하기 위한 이메일이 수신되었는지 확인하십시오.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => '이 작업의 실행은 메일 계정과 관련 내용을 일치화(Sync)합니다.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => '대용량 메일 계정의 전체 일치화(Sync) 실행은 수 분이 소요될수 있습니다.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => '복수 폴더 선택은 쉬프트키를 누르거나 컨트롤 키를 누르십시오.',
    'LBL_EMAIL_SETTINGS_GENERAL' => '일반',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => '사용가능한 그룹폴더',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => '신규 그룹폴더 만들기',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => '그룹폴더 저장중입니다.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => '그룹폴더 복구중입니다.',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => '그룹폴더 편집합니다.',

    'LBL_EMAIL_SETTINGS_NAME' => '메일 계정명',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => '편지함의 페이지별 이메일 번호를 선택하십시오. 이 설정을 실행하려면 페이지 새로고침이 필요할 수 있습니다.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => '메일 계정 복구중입니다.',
    'LBL_EMAIL_SETTINGS_RULES' => '역할',
    'LBL_EMAIL_SETTINGS_SAVED' => '설정이 저장되었습니다. 새로운 설정을 실행하려면 이 페이지를 다시 시작하십시오.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => '새로운 설정을 시작하려면 페이지를 다시 시작하십시오.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => '텍스트(Text)로 이메일 보내기',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => '활성',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => '페이지당 이메일수',
    'LBL_EMAIL_SETTINGS_TAB_POS' => '탭을 아래에 둡니다',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => '시각 설정',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => '우선권',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => '미리 보기',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => '사용가능한 사용자 폴더',
    'LBL_EMAIL_ERROR_PREPEND' => '오류',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => '사용중인 메일 계정을 위해 선택된 발신 메일 서버가 유효하지 않습니다. 설정을 확인하거나 메일 계정의 다른 메일 서버를 선택하십시오.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => '발신 메일 서버가 이메일 전송을 위해 구성되지 않았습니다. 발신 메일 서버를 구성하거나 설정-메일 계정에서 이용중인 메일 계정을 위한 발신계정 설정을 선택하십시오.',
    'LBL_EMAIL_SHOW_READ' => '전체 보기',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => '읽지 않은 메일 보기',
    'LBL_EMAIL_SIGNATURES' => '서명',
    'LBL_EMAIL_SIGNATURE_CREATE' => '서명 만들기',
    'LBL_EMAIL_SIGNATURE_NAME' => '서명 이름',
    'LBL_EMAIL_SIGNATURE_TEXT' => '서명 원문',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Google Less-Secure Apps',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! 메일',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => '기타',
    'LBL_EMAIL_AUTHORIZE' => '승인',
    'LBL_EMAIL_AUTHORIZED' => '승인 완료',
    'LBL_EMAIL_NOT_AUTHORIZED' => '미승인',
    'LBL_EMAIL_AUTH_WARNING' => '이 계정을 설정하려면 관리자가 관리자 > 커넥터를 통해 {0} 커넥터를 구성해야 합니다. 자세한 내용은 {1} 문서를 참조하십시오.',
    'LBL_EMAIL_AUTH_API_ERROR' => '커넥터 정보 검색 오류',
    'LBL_EMAIL_AUTH_FAILURE' => '인증 실패.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => '저장하기 전에 계정을 승인하십시오.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => '시험 전에 계정을 승인하십시오.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => '미승인 계정',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ 원격 폴더 ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ SugarCRM 폴더 ]',
    'LBL_EMAIL_SUBJECT' => '제목',
    'LBL_EMAIL_SUCCESS' => '성공',
    'LBL_EMAIL_SUGAR_FOLDER' => 'SugarCRM 폴더',
    'LBL_EMAIL_TEAMS' => '지정 팀',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => '이메일 템플릿 본문이 비어있습니다.',
    'LBL_EMAIL_TEMPLATES' => '템플릿',
    'LBL_EMAIL_TEXT_FIRST' => '첫 페이지',
    'LBL_EMAIL_TEXT_PREV' => '이전 페이지',
    'LBL_EMAIL_TEXT_NEXT' => '다음 페이지',
    'LBL_EMAIL_TEXT_LAST' => '마지막 페이지',
    'LBL_EMAIL_TEXT_REFRESH' => '새로고침',
    'LBL_EMAIL_TO' => '수신자',
    'LBL_EMAIL_TOGGLE_LIST' => '토글 목록',
    'LBL_EMAIL_VIEW' => '보기',
    'LBL_EMAIL_VIEWS' => '보기',
    'LBL_EMAIL_VIEW_HEADERS' => '머리글 표시하기',
    'LBL_EMAIL_VIEW_PRINTABLE' => '출력할수 있는 버전',
    'LBL_EMAIL_VIEW_RAW' => '원 이메일 표시하기',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => '이 기능을 POP3와 사용시 지원되지 않습니다.',
    'LBL_DEFAULT_LINK_TEXT' => '기본 링크 문자',
    'LBL_EMAIL_YES' => '예',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => '테스트 이메일 전송합니다.',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => '테스트 이메일이 전송되었습니다.',


    'LBL_EMAIL_MESSAGE_NO' => '아니오 메세지',
    'LBL_EMAIL_IMPORT_SUCCESS' => '가져오기가 성공했습니다.',
    'LBL_EMAIL_IMPORT_FAIL' => '이미 가져온 메세지이거나 서버에서 삭제되어 가져오기가 실패했습니다.',

    'LBL_EMAILS_FROM' => '전송된 이메일',
    'LBL_EMAILS_RECEIVED' => '수신한 이메일',
    'LBL_EMAIL_ADDRESSES_USED' => '이메일에서 사용되는 이메일 주소',
    'LBL_EMAIL_ADDRESS' => '이메일 주소:',
    'LBL_FROM' => '발신인',
    'LBL_TO' => '수신인',
    'LBL_CC' => '참조',
    'LBL_BCC' => '숨은 참조',

    'LBL_START_DATE' => '시작 날짜',
    'LBL_END_DATE' => '종료 날짜',
    'LBL_START' => '시작',
    'LBL_END' => '마지막',
    'LBL_DATE_LINKED' => '날짜 연결됨',

    'LBL_LINK_NONE' => '없음',
    'LBL_LINK_ALL' => '전부',
    'LBL_LINK_RECORDS' => '자료',
    'LBL_LINK_SELECT' => '선택하기',
    'LBL_LINK_ACTIONS' => '메뉴',
    'LBL_LINK_MORE' => '더보기',
    'LBL_CLOSE_ACTIVITY_HEADER' => '확인',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => '#module#모듈을 정말로 닫겠습니까?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => '이 메세지를 다음에 표시하지 않습니다.',
    'LBL_INVALID_FILE_EXTENSION' => '올바르지 않은 파일확장자명입니다.',
    'LBL_LIST_TEAM' => '담당부서',
    'LBL_TEAM' => '팀:',
    'LBL_TEAMS' => '팀',
    'LBL_TEAM_SET_ID' => '팀 설정 ID',
    'LBL_TEAM_SET_SELECTED_ID' => '선택된 부서 ID를 지정하십시오.',
    'LBL_TEAM_SET_SELECTED' => '선택 됨',
    'LBL_TEAM_SET_ENABLE' => '추가 권한 활성화',
    'LBL_TEAM_SET_DISABLE' => '추가 권한 비활성화',
    'LBL_TEAM_SET' => '팀 설정',
    'LBL_TEAM_SET_SELECTED_TEAMS' => '선택된 부서',
    'LBL_SEARCH_UNAVAILABLE' => '검색기능을 사용할수 없습니다. 나중에 다시 시도해주십시오.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => '명시된 기본 팀이 없습니다.',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => '아이디 [{2}] 모듈 [{1}] 에 대한 기본팀 아이디 [{0}] 제거를 시도하는 중 오류가 발생했습니다.',
    'LBL_TEAM_ADD' => '팀&nbsp;추가',
    'LBL_TEAM_REMOVE' => '팀 제거하기',
    'LBL_TEAM_PRIMARY' => '기본팀으로 설정',

    'LBL_CLOSE_BUTTON_LABEL' => '닫기',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}}가 {{status}}로 표시.',

    'LBL_FOCUS' => '초점',

    'LBL_QUERY_VALID' => '유효한',
    'LBL_QUERY_ERROR' => '오류!',
    'LBL_QUERY_CHILD' => '유효한 하위 쿼리',
    'ERROR_EXAMINE_MSG' => '아래 메세지를 조사하십시오.',
    'NO_QUERY_SELECTED' => '선택하신 데이터 형식은 쿼리를 포함하지 않습니다. 이 데이터 형식을 위한 쿼리를 선택하십시오.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => '다음과 같은 문제가 발생하였습니다.',
    'ERR_AJAX_LOAD_FAILURE' => '요청하신 작업을 처리하는 중에 문제가 발생하였습니다. 나중에 다시 시도해 주십시오.',
    'ERR_AJAX_LOAD_FOOTER' => '이 문제가 계속 발생하면, 관리자에게 연락하여 이 모듈의 ajax 기능을 중지하도록 요청하십시오.',
    'ERR_CREATING_FIELDS' => '상세 필드를 생성하는 중에 문제가 발생했습니다.',
    'ERR_CREATING_TABLE' => '테이블을 생성하는 중에 문제가 발생했습니다.',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => '소수점 분리와 같은 기호를 천단의 분리 기호로 사용할수 없습니다. 값을 변경하십시오.',
    'ERR_DELETE_RECORD' => '연락처를 삭제하려면 자료번호를 반드시 포함하여야합니다.',
    'ERR_EXPORT_DISABLED' => '보내기가 중지되었습니다.',
    'ERR_EXPORT_TYPE' => '오류 수출',
    'ERR_REPORTS_DISABLED_EXPORT' => '보고서 내보내기가 비활성화되었습니다',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => '관리자만 내보낼 수 있습니다',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => '보고서가 내보내기 액세스 권한 없는 모듈을 사용합니다',
    'ERR_REPORTS_EXPORT_OWNER' => '보고서가 소유자 내보내기 액세스 권한이 있는 모듈을 사용합니다',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => '보고서가 목록 제한 액세스가 가능한 모듈을 사용합니다',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => '보고서가 보기 제한된 액세스가 가능한 모듈을 사용합니다',
    'ERR_REPORTS_ACCESS_DISABLED' => '보고서가 액세스가 제한된 모듈을 사용합니다',
    'ERR_REPORTS_FIELDS_RESTRICTED' => '보고서가 액세스가 제한된 필드를 사용합니다',
    'ERR_INVALID_AMOUNT' => '올바른 금액을 입력해주십시오.',
    'ERR_INVALID_DATE_FORMAT' => '날짜 형식은 다음과 같아야합니다:',
    'ERR_INVALID_DATE' => '올바른 날짜형식을 입력해주십시오.',
    'ERR_INVALID_DAY' => '올바른 일자형식을 입력해주십시오.',
    'ERR_INVALID_EMAIL_ADDRESS' => '올바르지 않은 이메일 주소입니다.',
    'ERR_INVALID_FILE_REFERENCE' => '유효하지 않은 파일 참조',
    'ERR_INVALID_HOUR' => '올바른 시간을 입력해주십시오.',
    'ERR_INVALID_MONTH' => '올바른 월을 입력해주십시오.',
    'ERR_INVALID_TIME' => '올바른 시간을 입력해주십시오.',
    'ERR_INVALID_YEAR' => '4자리 년도를 입력해주십시오.',
    'ERR_NEED_ACTIVE_SESSION' => '작동중인 세션의 내용물 보내기가 필요합니다.',
    'ERR_NO_HEADER_ID' => '현재 항목은 선택된 테마에서는 작동하지 않습니다.',
    'ERR_NOT_ADMIN' => '관리자모드 접속 승인이 필요합니다.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        '비밀번호 관리는 <a href="%s" target="_blank"> SugarCloud 설정</a>에서만 사용 가능합니다.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => '읽기 전용 필드를 변경하려면 Sugar 관리자에게 문의하십시오.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => '<a href="{0}" target="_blank">SugarCloud 설정</a>에 접근하여 읽기 전용 필드를 수정하십시오.',
    'ERR_MISSING_REQUIRED_FIELDS' => '다음의 필수 항목을 입력하셔합니다:',
    'ERR_INVALID_REQUIRED_FIELDS' => '올바르지 않은 필수 항목을 입력하셨습니다:',
    'ERR_INVALID_VALUE' => '올바르지 않은 값을 입력하셨습니다:',
    'ERR_NO_SUCH_FILE' => '시스템에 파일이 존재하지 않습니다.',
    'ERR_NO_SINGLE_QUOTE' => '다음 항목은 따옴표를 입력할 수 없습니다:',
    'ERR_NOTHING_SELECTED' => '선택항목을 먼저 골라주십시오.',
    'ERR_OPPORTUNITY_NAME_DUPE' => '영업기회  %s 가 이미 존재합니다. 다른 이름을 입력해주십시오.',
    'ERR_OPPORTUNITY_NAME_MISSING' => '영업기회명을 입력하지 않았습니다. 영업기회명을 입력해주십시오.',
    'ERR_QUOTE_CONVERTED' => '견적이 이미 영업기회로 변환되었습니다.',
    'ERR_POTENTIAL_SEGFAULT' => '치명적인 문제가 발생하였습니다. 귀사의 CRM관리자에게 연락하여 SugarCRM 본사와 문제를 해결해주십시오(ERR_POTENTIAL_SEGFAULT).',
    'ERR_SELF_REPORTING' => '사용자는 자신을 보고자로 지정할 수 없습니다.',
    'ERR_SINGLE_QUOTE' => '선택한 항목은 따옴표를 허용하지 않습니다. 다른 값을 입력해주십시오.',
    'ERR_SQS_NO_MATCH_FIELD' => '다음 항목이 일치하지 않습니다:',
    'ERR_SQS_NO_MATCH' => '일치하는 항목이 없습니다.',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'displayParams에 &#39; 키 &#39;인덱스를 지정하십시오 메타 데이터 정의에 대한 속성',
    'ERR_EXISTING_PORTAL_USERNAME' => '오류. 포탈명이 이미 다른 연락처에 지정되었습니다.',
    'ERR_PORTAL_NAME_CHECK' => '포탈사용자명의 고유성을 확인할수 없습니다.',
    'ERR_COMPATIBLE_PRECISION_VALUE' => '필드 가치가 정밀 가치와 적합하지 않습니다.',
    'ERR_EXTERNAL_API_SAVE_FAIL' => '외부계정에 저장 시도중 오류가 발생했습니다.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => '파일 업로드중 문제가 발생했습니다. 빈파일이 아닌지 확인하여 주십시오.',
    'ERR_NO_DB' => '데이터베이스에 연결할 수 없습니다. 자세한 내용은 sugarcrm.log 파일을 확인하여 주십시오.',
    'ERR_DB_FAIL' => '데이터베이스를 처리하는 중 문제가 발생했습니다. 자세한 내용은 sugarcrm.log 파일을 확인하여 주십시오.',
    'ERR_EXTERNAL_API_403' => '파일권한이 없습니다. 선택된 파일 형식은 지원되지 않습니다.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth 액세스 토큰이 없습니다.',
    'ERR_DB_VERSION' => 'Sugar CRM 0 파일은 오직 Sugar CRM 1 데이터베이스와 함께 사용될수 있습니다.',
    'ERR_DB_QUERY' => '요청이 실패하였습니다.',
    'ERR_UW_RETIRED' => '이 버전에서는 마법사 업그레이드가 불가능합니다.',
    'ERR_NOT_CLOUD_INSTANCE' => 'Sugar의 이 인스턴스는 SugarCloud 인스턴스가 아니거나 SugarCloud 인사이트용으로 구성되어있지 않습니다.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => '모듈 생성 권한이 없습니다. 접속하시려면 관리자에 문의하십시오.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => '현 사용자는 구성설정을 변경할 수 없습니다.',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => '현 사용자는 구성설정을 변경할 수 없습니다.',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => '{모듈 명} 즐겨찾기를 할 수 있는 권한이 없습니다. 액세스가 필요한 경우 관리자에게 문의하십시오.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => '{모듈 명}에 가입 할 수 있는 권한이 없습니다. 액세스가 필요한 경우 관리자에게 문의하십시오.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => '페이로드에서 worksheet_columns_related_fields를 찾을 수 없습니다',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns는 배열이 아닙니다',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => '페이로드에서 summary_columns_related_fields를 찾을 수 없습니다.',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows는 배열이 아닙니다.',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rows_related_fields가 페이로드에 없습니다.',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => '귀하의 요청이 알수없는 예외사항으로 실패하였습니다.',
    'EXCEPTION_FATAL_ERROR' => '귀하의 요청을 완료할수 없습니다. 치명적 오류가 발생했습니다. 더 자세한 사항은 로그를 확인하십시오',
    'EXCEPTION_NEED_LOGIN' => '이 액션을 실행하려면 로그인을 해야합니다.',
    'EXCEPTION_INVALID_TOKEN' => '사용자 인증암호가 유효하지 않습니다.',
    'EXCEPTION_NOT_AUTHORIZED' => '이 액션의 실행 권한이 없습니다. 접속하려면 관리자에 문의하십시오.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => '데이터를 볼 수 있는 권한이 없습니다. 액세스가 필요한 경우 관리자에게 문의하십시오.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => '현재 포털계정이 비활성화되었기 때문에 접속이 불가능합니다. 귀사의 CRM관리자에게 문의해주십시오.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => '포탈 생성이 완료되지 않았습니다. 도움을 받으려면 포탈관리자에 문의하십시오.',
    'EXCEPTION_NO_METHOD' => '귀하의 요청은 지원되지 않습니다. 요청하신 HTTP 방식을 찾을수 없습니다.',
    'EXCEPTION_NOT_FOUND' => '요청하신 자원이 발견되지 않았습니다. 요청된 경로의 취급자(Handler)를 찾을수 없습니다.',
    'EXCEPTION_MISSING_PARAMTER' => '요청 내용중 필수항목 조건이 없습니다.',
    'EXCEPTION_INVALID_PARAMETER' => '귀하의 요청 조건이 유효하지 않습니다.',
    'EXCEPTION_REQUEST_FAILURE' => '귀하의 요청이 실패하였습니다.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => '귀하의 메타데이터또는 사용자 해쉬가 서버와 맞지 않습니다. 메타데이터를 다시 일치화(Sync) 하십시오.',
    'EXCEPTION_REQUEST_TOO_LARGE' => '귀하의 요청이 너무 커서 완료할 수 없습니다.',
    'EXCEPTION_EDIT_CONFLICT' => '충돌을 수정한 후 다시 로딩하십시오.',
    'EXCEPTION_METADATA_CONFLICT' => '메타데이터가 충돌합니다. 다시 로딩하십시오.',
    'EXCEPTION_CLIENT_OUTDATED' => '귀하의 소프트웨어가 만료되었습니다. 클라이언트(Client)를 업데이트한 후 다시 시도하십시오.',
    'EXCEPTION_CONNECTOR_RESPONSE' => '커넥터 또는 통합 요청 실패 응답 결과.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM이 관리모드이며 관리자만 로그인할수 있습니다. 자세한 사항은 CRM관리자에게 문의하십시오.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => '현재 서버가 사용량이 많거나 이용 불가하여 요청을 처리할 수 없습니다.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => '잠시 검색 엔진을 이용할 수 없습니다.',
    'EXCEPTION_SEARCH_RUNTIME' => '검색 엔진 런타임 오류가 발생했습니다. 시스템 관리자에 문의하십시오.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => '프로세스에 의해 락(lock)이 된 필드는 편집할 수 없습니다.',
    'EXCEPTION_MODULE_DISABLED' => '이 모듈은 현재 사용자가 사용할 수 없습니다.',
    'EXCEPTION_FIELD_DISABLED' => '이 필드는 현재 사용자가 사용할 수 없습니다.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => '이 클라이언트는 허용되지 않습니다.',
    'EXCEPTION_MODULELOADER_UPLOAD' => '패키지 업로드 기능은 귀하의 라이선스 유형에서 사용할 수 없습니다',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => '일반적인 고장이나 오류로 인해 문제가 발생했습니다. 원인은 예외적인 범위의 경우이지만, 일반적으로 더 구체적인 API 예외의 범위에 속합니다.',
    'EXCEPTION_FATAL_ERROR_DESC' => '제시된 요청을 처리할 수 없거나 응답에 오류가 발생했습니다. 이것은 일반적으로 치명적인 오류가 발생 및 특정 오류가 응용 프로그램 로그에서 식별할 수 있다는 것을 의미합니다.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => '사용중인 API의 버전은 현재 요청이 올바르지 않습니다.',
    'EXCEPTION_NEED_LOGIN_DESC' => '요청된 끝점은 인증을 필요로 하며 요청하신 소비자께서는 아직 인증되지 않았습니다.',
    'EXCEPTION_INVALID_TOKEN_DESC' => '요청과 함께 제공되는 인증 토큰이 유효하지 않음을 나타냅니다. 이것은 일반적으로 만료되는 토큰으로 인해 발생하지만 토큰이 잘못되었거나 올바르지 않을 수 있습니다.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => '요청하신 소비자가 요청된 작업을 수행 할 수 있는 권한이 부여되지 않았음을 나타냅니다.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => '사용자의 로깅과 관련된 포털 계정은 현재 활성화되어 있지 않습니다. 이 고객 지원 부분에 대한 조치가 필요합니다.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => '포탈 응용프로그램이 적절하게 구성되지 않아 사용될 수 없다는 것을 나타냅니다. 이 포털 관리자 부분에 대한 조치가 필요합니다.',
    'EXCEPTION_NO_METHOD_DESC' => '끝점이 만들어지는 HTTP 요청 유형을 지원하지 않습니다. POST 요청이 예를 들어, GET 요청을 위해 설계된 ,끝점에 만들어질 때 이 문제가 발생할 수 있습니다.',
    'EXCEPTION_NOT_FOUND_DESC' => '끝점은 요청에 대한 리소스를 찾을 수 없거나 요청에 대한 처리가 없습니다.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => '이 기록이 일어나는 동시에 편집되었을 수 있으므로 기록을 편집할 수 있는 현재의 요청이 기록의 이전 편집에 영향을 미친다는 것을 나타냅니다.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => '메타데이터 서버는 클라이언트가 현재 사용하고 있어 메타 데이터와 일치하지 않는 것을 나타냅니다. 이 시스템 설정과 Studio에서 모듈을 변경 또는 기타 시스템 변경 중 새로운 모듈의 배포를 변경한 후 발생할 수 있습니다.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => '요청은 서버에서 처리하기에 너무 큽니다.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => '요청이 필요한 매개 변수가 누락되었음을 나타냅니다.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => '요청에서 전송된 매개 변수가 유효하지 않음을 나타냅니다.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => '요청을 완료하지 못했습니다.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'API를 소비하는 클라이언트가 최신이며, API의 추가 소비가 일어날 수 있기 전에 업데이트를 해야 한다는 것을 나타냅니다.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'API를 통해 다른 서비스, 엔드 포인트나  URI에 전송된 요청이 실패하거나 서버가 처리 할 수없음을 나타냅니다.',
    'EXCEPTION_MAINTENANCE_DESC' => 'API를 제공하는 SugarCRM의 인스턴스는 유지 관리 모드에 있습니다. API에 대한 액세스는 관리자에게만 제한됩니다.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => '서버가 사용량이 많거나 과부하 또는 다운된 상태입니다.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => '연결 문제가 있어 검색 엔진 백엔드를 현재 이용할 수 없습니다. 관리->검색->테스트에서 연결성 및 환경구성을 확인하십시오.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => '검색 엔진에 런타임 예외가 발생했습니다. 자세한 내용은 sugarcrm.log를 참조하세요.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => '현재 실행중인 프로세스에 의해 잠긴 필드는 편집될 수 없습니다.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s는 실행중인 프로세스에 의해 락 (lock)이 되어 편집할 수 없습니다.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s는 실행중인 프로세스에 의해 잠겨있으며 편집할 수 없습니다.',
    'EXCEPTION_MODULE_DISABLED_DESC' => '이 모듈은 현재 사용자가 사용할 수 없습니다.',
    'EXCEPTION_FIELD_DISABLED_DESC' => '이 필드는 현재 사용자가 사용할 수 없습니다.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => '이 클라이언트는 허용되지 않습니다.',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => '같은 이름의 파일이 존재합니다.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => '오류: 날짜의 기간이 정의되지 않았습니다.',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => '이 기간은 이미 하위기간을 가지고 있습니다.',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => '하위 기간은 다른 하위기간을 가질수 없습니다.',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => '{0}형식의 기간을 가질수 없습니다.',
    'ERR_NO_ACTIVE_TIMEPERIOD' => '현재 설정을 위한 활성 기간이 없습니다.',
    'LBL_CURRENT_TIMEPERIOD' => '현재 기간',
    'LBL_PREVIOUS_TIMEPERIOD' => '이전 기간',
    'LBL_NEXT_TIMEPERIOD' => '다음 기간',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => '이전, 현재, 다음',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => '당신은 닫힌 판매 단계가 기록을 삭제할 수 없습니다.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => '당신은 판매 완료 상태가 기록을 삭제할 수 없습니다.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => '선택된 레코드 중 하나 이상이 닫힌 원 또는 닫힘 잃어버린 판매 스테이지를 가지며, 삭제 될 수 없다.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => '선택된 기록 중 하나 또는 이상이 승인이나 비승인의 상태를 지니며 삭제될 수 없습니다.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => '거래처',
    'LBL_OLD_ACCOUNT_LINK' => '이전 거래처',
    'LBL_ACCOUNTS' => '거래처',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => '활동내역',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => '요약보기',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => '요약보기',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => '추가하기',
    'LBL_ADD_BUTTON' => '추가하기',
    'LBL_ADD_DASHLET_BUTTON' => '대쉬릿 추가하기',
    'LBL_ADD_DOCUMENT' => '문서 추가하기',
    'LBL_REPLACE_BUTTON' => '대체',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => '잠재고객으로 추가하기',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => '잠재고객으로 추가하기',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => '창닫기',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => '닫기',
    'LBL_ADDITIONAL_DETAILS' => '세부정보',
    'LBL_ADMIN' => '관리자모드',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => '보관하기',
    'LBL_ASSIGNED_TO_USER' => '담당자에게 할당됨',
    'LBL_ASSIGNED_TO' => '할당된 담당자:',
    'LBL_BACK' => '뒤로',
    'LBL_BASE_RATE' => '기본율',
    'LBL_BILL_TO_ACCOUNT' => '거래처에 청구',
    'LBL_BILL_TO_CONTACT' => '연락처에 청구',
    'LBL_BILLING_ADDRESS' => '청구지 주소',
    'LBL_QUICK_CREATE_TITLE' => '빠른 추가',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{{module}}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => '결함',
    'LBL_BY' => 'by',
    'LBL_CALLS' => '전화',
    'LBL_CALL' => '전화',
    'LBL_CAMPAIGNS_SEND_QUEUED' => '대기중 캠페인 이메일 전송합니다.',
    'LBL_SUBMIT_BUTTON_LABEL' => '제출',
    'LBL_CASE' => '사례',
    'LBL_CASES' => '사례',
    'LBL_MESSAGE' => '메세지',
    'LBL_MESSAGES' => '메세지',
    'LBL_ESCALATIONS' => '에스컬레이션',
    'LBL_ESCALATION' => '에스컬레이션',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign 봉투',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign 봉투',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => '서명자 수신인 선택',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => '비밀번호 변경',
    'LBL_CHANGE_BUTTON_LABEL' => '변경하기',
    'LBL_CHANGE_BUTTON_TITLE' => '변경하기',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => '모두 선택하기',
    'LBL_CITY' => '시',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => '지우기',
    'LBL_CLEAR_BUTTON_TITLE' => '지우기',
    'LBL_CLEARALL' => '전체 선택취소',
    'LBL_CLICK_TO_EDIT' => '클릭하여편집',
    'LBL_CLOSE_BUTTON_TITLE' => '닫기',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => '창닫기',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => '전체 닫기',
    'LBL_CLOSEALL_BUTTON_TITLE' => '전체 닫기',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => '저장하고 새 정보 입력하기',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => '저장하고 새 정보 입력하기',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => '레코드 URL 복사',
    'LBL_OPEN_ITEMS' => '열린 아이템:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => '이메일 작성하기',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => '이메일',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => '이메일 작성하기',
    'LBL_SEARCH_DROPDOWN_YES' => '예',
    'LBL_SEARCH_DROPDOWN_NO' => '아니요',
    'LBL_CONTACT_LIST' => '연락처 목록',
    'LBL_CONTACT' => '연락처',
    'LBL_CONTACTS' => '연락처',
    'LBL_CONTRACTS' => '연락처',
    'LBL_COUNTRY' => '국가:',
    'LBL_RESET_BUTTON_LABEL' => '재설정',
    'LBL_CREATE_BUTTON_LABEL' => '만들기',
    'LBL_CREATED_BY_USER' => '생성자',
    'LBL_CREATED_USER' => '생성자',
    'LBL_CREATED_ID' => '생성 ID',
    'LBL_CREATED' => '생성자',
    'LBL_CREATE_NEW_TARGET_LIST' => '신규 목표목록 생성하기',
    'LBL_CURRENT_USER_FILTER' => '내 관련자료:',
    'LBL_CURRENCY' => '통화',
    'LBL_CURRENCIES' => '통화',
    'LBL_CURRENCY_NAME' => '통화기호',
    'LBL_CURRENCY_SYMBOL' => '통화 기호',
    'LBL_CURRENCY_RATE' => '기준 금리:',
    'LBL_CURRENCY_ID' => '통화 ID',
    'LBL_DOCUMENTS' => '문서',
    'LBL_DATE_ENTERED' => '생성일자:',
    'LBL_DATE_MODIFIED' => '수정일자:',
    'LBL_ACTIVITY_MODIFIED' => '수정됨',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => '개요 탭 편집',
    'LBL_EDIT_MODULE_TABS_BUTTON' => '모듈 탭 편집',
    'LBL_EDIT_BUTTON' => '수정하기',
    'LBL_DUPLICATE_BUTTON' => '복제하기',
    'LBL_DELETE_BUTTON' => '삭제하기',
    'LBL_DELETE' => '삭제하기',
    'LBL_DELETED' => '삭제',
    'LBL_DIRECT_REPORTS' => '직접 보고서(Direct Report)',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => '완료하기',
    'LBL_DONE_BUTTON_TITLE' => '완료하기',
    'LBL_DST_NEEDS_FIXIN' => '현재 시스템에 일광절약시간을 적용하셔야 합니다. 다음 <a href=index.php?module=Administration&action=DstFix >링크</a>를 클릭하여 일광절약시간을 바르게 적용해주십시오.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => '신규 편집하기',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => '신규 편집하기',
    'LBL_EDIT_IN_NEW_TAB' => '새로운 탭에서 편집하기',
    'LBL_FAVORITES' => '즐겨찾기목록',
    'LBL_FILTER' => '필터',
    'LBL_DEFAULT_DATA_FILTER' => '기본값 델타 필터',
    'LBL_FILTER_MENU_BY' => '다음에 의한 메뉴 필터',
    'LBL_FILTER_SELECT_FIELD' => '필드를 선택하십시오',
    'LBL_FILTER_SELECT_OPERATOR' => '작업자를 선택하십시오',
    'LBL_FILTER_CREATE_NEW' => '만들기',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => '빌드 필터(저장되지 않음)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(저장되지 않음)',
    'LBL_FILTER_CREATE_FILTER' => '새 필터 생성',
    'LBL_FILTER_CLOSE_FILTER' => '필터 닫기',
    'LBL_FILTER_EDIT_FILTER' => '필터 편집',
    'LBL_FILTER_ALL_RECORDS' => '전체 기록',
    'TPL_FILTER_SAVE' => '성공적으로 필터 {{name}} 만들었습니다.',
    'LBL_FILTER_BETWEEN_FROM' => '발신인',
    'LBL_FILTER_BETWEEN_TO' => '수신인',
    'LBL_FILTER_DATEBETWEEN_FROM' => '시작일',
    'LBL_FILTER_DATEBETWEEN_TO' => '완료일',
    'LBL_FOLLOWING' => '팔로잉',
    'LBL_UNFOLLOW' => '팔로잉 취소',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => '다운로드',
    'LBL_EMPTY_VCARD' => 'vCard 파일을 선택하십시오',
    'LBL_IMAGE' => '이미지',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard이 모듈에 필요한 모든 필드를 가지고 있지 않습니다.',
    'LBL_VCARD_ERROR_FILESIZE' => '업로드된 파일은 HTML 양식에 지정된 30000 바이트 크기 한계를 초과합니다.',
    'LBL_VCARD_ERROR_DEFAULT' => 'vCard 파일을 업로드하는 중에 오류가 발생했습니다.',
    'TPL_IMPORT_VCARD_FAILURE' => 'vCard를에서 {{module}} 만들 수 없습니다',
    'LBL_IMPORT_VCARD' => 'vCard 가져오기:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'vCard 가져오기',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'vCard 가져오기',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => '보기',
    'LBL_VIEW_BUTTON_TITLE' => '보기',
    'LBL_VIEW_BUTTON' => '보기',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'PDF 이메일',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'PDF 이메일',
    'LBL_EMAIL' => '이메일',
    'LBL_EMAILS' => '이메일',
    'LBL_EMPLOYEES' => '직원관리',
    'LBL_ENTER_DATE' => '입력 날짜',
    'LBL_EXPORT_ALL' => '전체자료 내보내기',
    'LBL_EXPORT' => '자료 내보내기',
    'LBL_FAVORITES_FILTER' => '내 즐겨찾기 목록:',
    'LBL_GLOBAL_SEARCH' => '글로벌 검색',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => '글로벌 검색 모듈 필터',
    'LBL_GLOBAL_SEARCH_RUN' => '글로벌 검색 실행',
    'LBL_GO_BUTTON_LABEL' => '이동하기',
    'LBL_GS_HELP' => '이 모듈의 필드는 위에 보이는 검색에 사용되었습니다. 강조된 문자는 검색 조건에 일치합니다.',
    'LBL_HIDE' => '숨김',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => '자료 가져오기',
    'LBL_IMPORT_STARTED' => 'Import Started:',
    'LBL_MISSING_CUSTOM_DELIMITER' => '구분자를 반드시 선택하셔야합니다.',
    'LBL_LAST_VIEWED' => '최근에 본 항목',
    'LBL_SELECTED_RECORDS' => '선택됨: ',
    'TPL_MAX_PILLS_DISPLAYED' => '{{maxPillsDisplayed}} 레코드만표시됩니다.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} 추가 레코드가 선택되었습니다.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} 레코드가 선택되었습니다.',
    'LBL_SHOW_LESS' => '메뉴 접기',
    'LBL_SHOW_MORE' => '더보기',
    'LBL_SHOW_MORE_MODULE' => '더 보기',
    'LBL_SHOW_MORE_RECENTS' => '더 최근 사용 ...',
    'LBL_SHOW_LESS_RECENTS' => '보다 적은 최근 사용 ...',
    'LBL_SHOW_MORE_RESULTS' => '더 많은 검색 결과...',
    'TPL_SHOW_MORE_MODULE' => '더 많은 {{module}}…',
    'LBL_SHOW_MORE_GENERIC' => '추가 {{name}}…',
    'LBL_TODAYS_ACTIVITIES' => '오늘의 활동',
    'LBL_LEADS' => '관심고객',
    'LBL_LEAD' => '관심고객',
    'LBL_QUOTES_BILL_TO' => '견적서(청구지주소)',
    'LBL_LESS' => '덜',
    'LBL_CAMPAIGN' => '캠페인',
    'LBL_CAMPAIGNS' => '캠페인',
    'LBL_CAMPAIGNLOG' => '캠페인 로그',
    'LBL_CAMPAIGN_CONTACT' => '캠페인',
    'LBL_CAMPAIGN_ID' => '캠페인 ID',
    'LBL_THEME' => '테마:',
    'LBL_THEME_PICKER' => '페이지 스타일',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => '경고: 선택하신 테마는 인터넷 익스플로어 6버전을 지원하지 않습니다. 그래도 진행하시려면 확인을 눌러주시고 아니면 취소후 다른 테마를 선택해주십시오.',
    'LBL_FOUND_IN_RELEASE' => '릴리즈에서 발견하였습니다.',
    'LBL_FIXED_IN_RELEASE' => '릴리즈에서 수정되었습니다.',
    'LBL_LIST_ACCOUNT_NAME' => '거래처명',
    'LBL_LIST_ASSIGNED_USER' => '담당자',
    'LBL_LIST_CONTACT_NAME' => '연락처명',
    'LBL_LIST_CONTACT_ROLE' => '연락처 역할',
    'LBL_LIST_DATE_ENTERED' => '생성일자',
    'LBL_LIST_EMAIL' => '이메일',
    'LBL_LIST_NAME' => '이름',
    'LBL_LIST_OF' => '/',
    'LBL_LIST_PHONE' => '전화번호',
    'LBL_LIST_RELATED_TO' => '관련된 자료',
    'LBL_LIST_USER_NAME' => '사용자명',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => '선택된 모든 레코드를 변경하겠습니까?',
    'LBL_LISTVIEW_NO_SELECTED' => '한개 이상의 레코드를 선택해주십시오.',
    'LBL_LISTVIEW_TWO_REQUIRED' => '두개 이상의 레코드를 선택해주십시오.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => '10개 이하의 레코드를 선택해주십시오.',
    'LBL_LISTVIEW_ALL' => '전체',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => '열 1 고정',
    'LBL_DUPECHECK_FILTER_DEFAULT' => '모든 중복 레코드',
    'LBL_LISTVIEW_NONE' => '모든선택취소',
    'LBL_LISTVIEW_OPTION_CURRENT' => '현재페이지 선택하기',
    'LBL_LISTVIEW_OPTION_ENTIRE' => '전체 선택하기',
    'LBL_LISTVIEW_OPTION_SELECTED' => '선택된 레코드',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => '선택됨: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => '전체 선택을 지웁니다.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => '모든 기록을 선택합니다',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => '00이상의 기록이 이 결과에 설정되어있습니다. 첫 00레코드를 선택하였습니다. 선택사항을 삭제하십시오.',
    'TPL_LISTVIEW_SELECTED' => '결과집합에서{{num}} 레코드를선택했습니다.',
    'TPL_LISTVIEW_SELECTED_ONE' => '결과 집합에서 기록 1개를 선택했습니다.',
    'TPL_LISTVIEW_SELECTED_ALL' => '모든 00레코드를 선택했습니다. 선택을 해제하십시오.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => '이 창의 모든 00레코드를 선택했습니다. 결과 설정의 모든 레코드를 선택하십시오.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => '{{num}}/{{total}} 업데이트 중',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(about {{time}} {{unit}} left)',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => '대량 업데이트가 실패했습니다. 00개의 레코드가 변경되지 않았습니다.',
    'TPL_MASSUPDATE_WARNING_CLOSE' => '대량 업데이트가 완료되지 않았습니다. 00개의 레코드가 변경되지 않았습니다.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => '대량 업데이트가 완료되지 않았습니다. 00개의 레코드가 변경되지 않았습니다.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} 레코드가 허가 또는 오류로 인해 무시되었습니다.',
    'TPL_MASSUPDATE_SUCCESS' => '00개의 레코드가 성공적으로 업데이트 되었습니다.',
    'TPL_MASSUPDATE_TITLE' => '전체 업데이트',
    'TPL_MASSDELETE_PROGRESS_STATUS' => '{{num}}/{{total}} 삭제 중',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(about {{time}} {{unit}} left) ( defined in ./include/language/ko_KR.lang.php )',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => '대량 삭제가 실패했습니다. 새로 시도합니다.',
    'TPL_MASSDELETE_WARNING_CLOSE' => '대량 삭제가 완료되지 않았습니다. 00개의 레코드가 남아있습니다.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => '대량 삭제가 완료되지 않았습니다. 00개의 레코드가 남아있습니다.',
    'TPL_MASSDELETE_SUCCESS' => '레코드가 성공적으로 삭제되었습니다.',
    'TPL_MASSDELETE_TITLE' => '전체 삭제',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => '추가중',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(about {{time}} {{unit}} left)',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => '목표목록에 대량추가하기가 실패했습니다. 신규 추가 시도중',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => '목표목록에 대량추가하기가 실패했습니다. 00개의 기록이 추가되지 않았습니다.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => '목표목록에 대량추가하기가 완료되지 않았습니다.  00개의 기록이 추가되지 않았습니다.',
    'TPL_MASSADDTOLIST_SUCCESS' => '00개의 레코드가 성공적으로 추가되었습니다.',
    'TPL_MASSADDTOLIST_TITLE' => '목표목록에 대량추가하기',
    'TPL_MASSLINK_PROGRESS_STATUS' => '{{total}} 의 {{num}} 연결.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(약 {{time}} {{unit}} 왼쪽)',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => '매스 링크에 실패했습니다. ({{total}} 의 {{num}}) 새로운 시도를 시작합니다.',
    'TPL_MASSLINK_WARNING_CLOSE' => '매스 링크가 불안전합니다. {{num}} 기록이 추가되지 않습니다.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => '매스 링크가 불안전합니다. {{num}} 기록이 추가되지 않습니다.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} 레코드가 성공적으로 연결되었습니다.',
    'TPL_MASSLINK_TITLE' => '{{module}} 매스 링크',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => '선택하기',
    'LBL_LISTVIEW_ACTIONS' => '액션',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => '이 페이지의 모든 기록 선택',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => '이 페이지의 모든 기록 선택 취소',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '전체 {{total}} 중 {{num}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '{{num}}개 로드 중...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => '클릭하여 전체보기',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => '/',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => '페이지 수 가져오기',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => '길동',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => '홍',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Dr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Code Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => '이 페이지를 열기 위해서는 로그인이 필요합니다.',
    'LBL_LOGOUT' => '로그아웃',
    'LBL_FINISH_IMPERSONATING' => '가장 완료',
    'LBL_RESET_MFA' => '다단계 인증 재설정',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, 현재 {{user}} 사용자를 가장하고 있습니다.',
    'LBL_PROFILE' => '개인 프로필',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => '메일머지',
    'LBL_MASS_UPDATE' => '전체 수정하기',
    'LBL_MASS_UPDATE_ALL_RECORDS' => '모든 기록 선택해 대량 업데이트',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => '대량 업데이트에 기록 포함',
    'LBL_MASS_UPDATE_ADD_FIELD' => '필드추가',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => '제거된 필드',
    'LBL_GENERATE_QUOTE' => '견적 생성하기',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => '대량 수정할 항목이 선택되지 않았습니다.',
    'LBL_MASS_UPDATE_JOB_QUEUED' => '귀하의 전체 업데이트 일정이 설정되었습니다.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => '서비스 시작 일자가 서비스 종료 일자 이후입니다.',
    'LBL_MASS_UPDATE_SUCCESS' => '전체 레코드가 성공적으로 업데이트되었습니다.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => '목표목록에 추가할 레코드를 선택하십시오.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => '요청하신 레코드의 목표목록 추가가 스케줄링되었습니다.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => '값이 입력되지 않았습니다.',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => '존재하는 값이 사라집니다. 계속하시겠습니까?',
    'LBL_OPT_OUT_FLAG_PRIMARY' => '수신거부된 기본 이메일 주소',
    'LBL_MEETINGS' => '회의',
    'LBL_MEETING' => '회의',
    'LBL_MEETING_GO_BACK' => '회의로 돌아가기',
    'LBL_MEMBERS' => '구성원들',
    'LBL_MEMBER_OF' => '다음의 구성원',
    'LBL_MODIFIED_BY_USER' => '수정자',
    'LBL_MODIFIED_USER' => '수정자',
    'LBL_MODIFIED' => '수정자',
    'LBL_MODIFIED_NAME' => '수정자',
    'LBL_MODIFIED_ID' => '수정자 ID',
    'LBL_MORE' => '더보기',
    'LBL_MORE_MODULES' => '더 많은 모듈',
    'LBL_MORE_TABS' => '더 많은 탭',
    'LBL_MULTIPLE_MODULES' => '다중 모듈',
    'LBL_COUNT_MODULES' => '{{count}}개 모듈',
    'LBL_MY_ACCOUNT' => '내 설정보기',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => '시스템 초기설정',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => '사용자 초기설정',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => '사용자 계정',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => '그룹 계정',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => '이름',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => '신규자료 추가하기',
    'LBL_NEW_BUTTON_TITLE' => '신규자료 추가하기',
    'LBL_NEXT_BUTTON_LABEL' => '다음',
    'LBL_NOTES' => '메모',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => '모두열기',
    'LBL_OPENALL_BUTTON_TITLE' => '모두열기',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Open To:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Open To:',
    'LBL_OPEN_IN_NEW_TAB' => '새로운 탭으로 열기',
    'LBL_OPPORTUNITIES' => '영업기회',
    'LBL_OPPORTUNITY_NAME' => '영업기회명',
    'LBL_OPPORTUNITY' => '영업기회',
    'LBL_OR' => '또는',
    'LBL_LOWER_OR' => '또는',
    'LBL_PANEL_ASSIGNMENT' => '기타',
    'LBL_PANEL_ADVANCED' => '추가정보',
    'LBL_PANEL_BODY' => '전체 개요',
    'LBL_PARENT_TYPE' => '상위 유형',
    'LBL_RELATED_TYPE' => '관련된 자료 유형',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => '범위',
    'LBL_PICTURE_FILE' => '사진',
    'LBL_POSTAL_CODE' => '우편번호:',
    'LBL_PRIMARY_ADDRESS_CITY' => '시:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => '국가:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => '기본 주소지 우편번호:',
    'LBL_PRIMARY_ADDRESS_STATE' => '기본 주소 도:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => '나머지주소2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => '기본 주소 나머지주소3:',
    'LBL_PRIMARY_ADDRESS_STREET' => '기본 주소 나머지주소:',
    'LBL_PRIMARY_ADDRESS' => '기본 주소:',

    'LBL_BILLING_STREET' => '청구지 주소:',
    'LBL_SHIPPING_STREET' => '배송지주소:',

    'LBL_PRODUCT_BUNDLES' => '제품 번들',
    'LBL_PRODUCTS' => '제품',
    'LBL_PROJECT_TASKS' => '프로젝트 과제',
    'LBL_PRODUCT_TEMPLATES' => '제품 템플릿',
    'LBL_PROJECTS' => '프로젝트',
    'LBL_PROSPECTS' => '대상',
    'LBL_QUICK_CREATE_MENU' => '빠른 메뉴 생성',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => '견적에서 신규 영업기회 추가하기',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => '견적에서 신규 영업기회 추가하기',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => '신규 영업기회를 만들고 있습니다...',
    'LBL_QUOTES_SHIP_TO' => '견적을 다음으로 옮깁니다.',
    'LBL_QUOTES' => '견적',

    'LBL_FORECAST_WORKSHEETS' => '예측 워크시트',
    'LBL_FORECAST_WORKSHEET' => '예측 워크시트',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => '초대',
    'LBL_INVITED' => '초대되었습니다.',
    'LBL_RECOMMENDED_INVITES' => '추천된 초대자 목록',
    'LBL_INSTANCES' => '인스턴스',
    'LBL_YOUR_INSTANCES' => '귀하의 인스턴스',
    'LBL_INSTANCE_USERS' => '인스턴스 사용자 목록',
    'LBL_SWITCH_INSTANCE' => '이 인스턴스로 전환',
    'LBL_LAST_LOGIN' => '마지막 로그인',
    'LBL_ENTER_EMAIL' => '초대자 이메일을 입력하십시오.',
    'LBL_INSTANCE_IN_USE' => '사용중인 인스턴스',
    'LBL_INSTANCE_ACTIVE' => '이 인스턴스를 이미 사용중입니다.',
    'LBL_INSTANCE_INVITE_SENT' => '에 초대장을 보냅니다.',
    'LBL_INSTANCE_SWITCH_FAILED' => '인스턴스 변경이 실패했습니다.',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => '미리알림',
    'LBL_REMINDERS_OVERDUE' => '기한초과',
    'LBL_REMINDERS_UPCOMING' => '곧 다가옴',
    'LBL_REMINDERS_NONE_FOUND' => '미리알림이 발견되지 않았습니다.',
    'LBL_REMINDERS_FINISHED' => '종료되었습니다.',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => '영업기회 매트릭스(Metrics)',

    'LBL_SWEETSPOT' => '스위트 스폿',
    'LBL_SWEETSPOT_CONFIG' => '스위트 스폿 환경구성 패널',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => '단축키',
    'LBL_SWEETSPOT_CONFIG_ERR' => '환경구성 속성 업데이트 실패: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => '스위트 스폿 실행',
    'LBL_SWEETSPOT_KEY' => '키워드',
    'LBL_SWEETSPOT_REMOVE' => '실행 삭제',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => '단축키',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => '영업',
    'LBL_SWEETSPOT_RECORDS_SECTION' => '자료',
    'LBL_SWEETSPOT_THEME' => '테마:',
    'LBL_SWEETSPOT_THEME_SELECT' => '주제 선택',

    'LBL_RELATED' => '관련',
    'LBL_RELATED_INFORMATION' => '관련된 정보',
    'LBL_RELATED_RECORDS' => '관련 {{module}}',
    'LBL_REPORTS_TO' => '보고할 상급자',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => '필수항목입니다.',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => '완료',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => '다음이름으로 저장',
    'LBL_SAVE_AS_BUTTON_TITLE' => '다음이름으로 저장',
    'LBL_FULL_FORM_BUTTON_KEY' => 'L',
    'LBL_FULL_FORM_BUTTON_LABEL' => '전체화면으로 작성하기',
    'LBL_FULL_FORM_BUTTON_TITLE' => '전체화면으로 작성하기',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => '저장 후 새 자료입력',
    'LBL_SAVE_NEW_BUTTON_TITLE' => '저장 후 새 자료입력',
    'LBL_SAVE_OBJECT' => '저장 {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => '검색하기',
    'LBL_SEARCH_BUTTON_TITLE' => '검색하기',
    'LBL_SEARCH' => '검색:',
    'LBL_SEARCH_TIPS' => '정확히 일치하는 정보를 검색하려면 검색버튼을 누르거나 엔터버튼을 누르십시오',
    'LBL_SEARCH_TIPS_2' => '정확히 일치하는 정보를 검색하려면 검색버튼을 누르거나 엔터버튼을 누르십시오',
    'LBL_SEARCH_MORE' => '더보기',
    'LBL_SEE_ALL' => '전체보기',
    'LBL_SEARCH_LOAD_MORE' => 'LOAD 추가',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => '올바르지 않은 형식입니다. 이미지 파일만 가능합니다.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => '{0}이미지 형식이 더이상 지원되지 않습니다.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => '기존자료 선택하기',
    'LBL_SELECT_BUTTON_TITLE' => '기존자료 선택하기',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => '팀 추가하기',
    'LBL_SELECT_TEAMS_TITLE' => '팀 추가하기',
    'LBL_SELECT_APPEND_TEAMS' => '팀 추가하기',
    'LBL_SELECT_APPEND_VALUES' => '추가 값(들)',
    'LBL_SELECT_APPEND_TAGS' => 'Append 태그',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => '문서확인하기',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => '문서확인하기',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => '연락처 선택하기',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => '연락처 선택하기',
    'LBL_GRID_SELECTED_FILE' => '선택된 파일',
    'LBL_GRID_SELECTED_FILES' => '선택된 파일목록',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => '보고서를 선택하십시오',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => '보고서를 선택하십시오',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => '사용자 선택하기',
    'LBL_SELECT_USER_BUTTON_TITLE' => '사용자 선택하기',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => '선택을 비웁니다.',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => '선택을 비웁니다.',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => '선택을 비웁니다.',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => '선택을 비웁니다.',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => '파일 선택하기',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => '파일 선택하기',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => '파일을 비웁니다.',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => '파일을 비웁니다.',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => '사용자 선택하기',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => '사용자 선택하기',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => '사용자를 비웁니다.',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => '사용자를 비웁니다.',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => '거래처 선택하기',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => '거래처 선택하기',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => '거래처를 비웁니다.',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => '거래처를 비웁니다.',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => '캠페인 선택하기',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => '캠페인 선택하기',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => '캠페인을 비웁니다.',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => '캠페인을 비웁니다.',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => '연락처 선택하기',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => '연락처 선택하기',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => '연락처를 비웁니다.',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => '연락처를 비웁니다.',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => '부서 선택하기',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => '부서 선택하기',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => '팀을 비웁니다.',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => '팀을 비웁니다.',
    'LBL_SERVER_RESPONSE_RESOURCES' => '이 페이지를 생성하는 사용된 자원들(queries, files)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => '초.',
    'LBL_SERVER_RESPONSE_TIME' => '서버 반응 시간:',
    'LBL_SERVER_MEMORY_BYTES' => '바이트',
    'LBL_SERVER_MEMORY_USAGE' => '사용된 서버 메모리: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => '사용자: - 모듈: {0} - 액션: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => '최대 사용된 서버 메모리: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => '거래처로 배송',
    'LBL_SHIP_TO_CONTACT' => '연락처로 배송',
    'LBL_SHIPPING_ADDRESS' => '배송지주소',
    'LBL_SHORTCUTS' => '단축키',
    'LBL_SHOW' => '보기',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => '도:',
    'LBL_STATUS_UPDATED' => '당신의 상태가 변경되었습니다.',
    'LBL_STATUS_NOT_UPDATED' => '이벤트에 대한 사용자의 상태가 업데이트 되지 않았습니다.',
    'LBL_STATUS' => '상태:',
    'LBL_STREET' => '동:',
    'LBL_SUBJECT' => '제목',

    'LBL_INBOUNDEMAIL_ID' => '수신 이메일 ID',
    'LBL_EAMP_ID' => '인증 토큰 ID',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        '판권 소유.<br />SugarCRM, Sugar 및 3-D 큐브는 SugarCRM Inc. 등록 상표입니다. ' .
        '이 제품에 사용되거나 등장하는 모든 기업 및 상품명은 ' .
        '상품과 관련된 각 기업의 상표일 수 있습니다.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => '예약된 작업 완료',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => '예약 된 작업이 성공적으로 실행',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => '매출 품목은 지금 당신의 설탕 인스턴스에서 활성화',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => '매출 품목은 이제 설탕 인스턴스에서 사용할 수 있으며, 기존의 모든 기회 데이터가 처리되었습니다.인스턴스는 이제 수익 품목으로 사용할 준비가. 변경된 사항에 대한 자세한 내용은 {{doc_url}}를 참조하십시오. 감사합니다, 슈가 CRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => '예측 모듈이 슈가 인스턴스에서 사용  준비 중',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => '슈가 인스턴스의 예측 모듈은  현재 사용할 수 있습니다. 이전의 모든 영업선 항목 예측 커밋 데이터는 제거되고, 인스턴스는 예측을 만들고  확약할 준비가되어 있습니다. 변경된 사항에 대한 자세한 내용은 {{doc_url}}를 참조하십시오. 감사합니다, 슈가CRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => '영업선 항목이 현재  슈가 인스턴스에서 비활성화',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => '영업선 항목이 현재  슈가 인스턴스에서 비활성화되었고, 모든 현재의 영업선 항목은 처리되었습니다. 인스턴스가 현재 사용 준비 중입니다. 변경된 사항에 대한 자세한 내용은 {{doc_url}}를 참조하십시오. 감사합니다, 슈가CRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => '환경설정 파일',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => '로그인',
    'LBL_LOGIN_WELCOME_TO' => '환영합니다.',
    'LBL_LOGIN_OPTIONS' => '선택항목',
    'LBL_LOGIN_FORGOT_PASSWORD' => '비밀번호를 분실했습니까?',
    'LBL_LOGIN_SUBMIT' => '제출',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => '로그인 시도 실패 횟수 초과',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => '나중에 다시 로그인을 시도하십시오',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => '일',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => '시',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => '분',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => '초',
    'LBL_LOGIN_ADMIN_CALL' => '시스템 관리자에 문의하십시오',
    'LBL_LOGIN_USERNAME' => '사용자명',
    'LBL_LOGIN_PASSWORD' => '비밀번호:',
    'LBL_LOGGED_OUT' => '로그아웃되었습니다.',
    'LBL_LOGIN_FORM_LABEL' => '로그인 양식 보기',
    'LBL_RETURN_TO_LOGIN_PAGE' => '로그인으로 돌아가기',
    'LBL_LOGIN_INACTIVE_USER' => '비활성 사용자',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => '포털 또는 그룹 사용자가 로그인 할 수 없습니다.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => '대시보드',
    'LBL_SYNC' => '동기화',
    'LBL_TASKS' => '작업',
    'LBL_TEAMS_LINK' => '팀 링크',
    'LBL_THEME_COLOR' => '색',
    'LBL_THEME_FONT' => '폰트',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => '회의 예약',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => '회의 예약',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => '이메일 발송기록하기',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => '이메일 발송기록하기',
    'LBL_UNAUTH_ADMIN' => '관리자모드 접속 승인이 필요합니다.',
    'LBL_UNDELETE_BUTTON_LABEL' => '삭제 취소',
    'LBL_UNDELETE_BUTTON_TITLE' => '삭제 취소',
    'LBL_UNDELETE_BUTTON' => '삭제 취소',
    'LBL_UNDELETE' => '삭제 취소',
    'LBL_UNSYNC' => '동기화 취소',
    'LBL_UPDATE' => '변경저장하기',
    'LBL_UPDATES' => '업데이트',
    'LBL_USER_LIST' => '사용자 목록',
    'LBL_USER_MENU' => '사용자 메뉴',
    'LBL_USERS_SYNC' => '사용자 일치화',
    'LBL_USERS' => '사용자',
    'LBL_USER' => '사용자',
    'LBL_CURRENT_USER' => '현 사용자',
    'LBL_VERIFY_EMAIL_ADDRESS' => '기존 이메일 항목을 확인중입니다.',
    'LBL_VERIFY_PORTAL_NAME' => '기존 포탈명을 확인중입니다.',
    'LBL_VIEW_IMAGE' => '이미지 보기',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'PDF로 출력하기',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'PDF로 출력하기',

    'LBL_KBDOCUMENTS' => '지식 기반',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'SugarCRM 정보',
    'LNK_ADVANCED_SEARCH' => '고급검색',
    'LNK_BASIC_SEARCH' => '기본검색',
    'LNK_SEARCH_NO_RESULTS' => '검색결과가 없습니다.',
    'LNK_SEARCH_FTS_VIEW_ALL' => '전체검색 결과보기',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => '전체보기',
    'LNK_CLOSE' => '닫기',
    'LBL_MODIFY_CURRENT_SEARCH' => '현재 검색 조건 수정하기',
    'LNK_SAVED_VIEWS' => '표시항목옵션',
    'LNK_DELETE_ALL' => '전체삭제',
    'LNK_DELETE' => '삭제',
    'LNK_EDIT' => '수정',
    'LNK_VIEW' => '보기',
    'LNK_GET_LATEST' => '최신자료',
    'LNK_GET_LATEST_TOOLTIP' => '최신자료로 변경하기',
    'LNK_HELP' => '도움말',
    'LNK_CREATE' => '추가하기',
    'LNK_CREATE_WHEN_EMPTY' => '지금 신규기록 만들기',
    'LNK_LIST_END' => '마지막',
    'LNK_LIST_NEXT' => '다음',
    'LNK_LIST_PREVIOUS' => '이전',
    'LNK_LIST_RETURN' => '목록으로',
    'LNK_LIST_START' => '처음',
    'LNK_LOAD_SIGNED' => '서명하기',
    'LNK_LOAD_SIGNED_TOOLTIP' => '서명된 문서로 변경하기',
    'LNK_PRINT' => '인쇄하기',
    'LNK_BACKTOTOP' => '맨처음으로',
    'LNK_REMOVE' => '제거',
    'LNK_RESUME' => '재개',
    'LNK_VIEW_CHANGE_LOG' => '감사 로그 보기',
    'TPL_AUDIT_LOG_TITLE' => '{{{name}}}의 감사 로그',
    'LBL_AUDIT_EMAIL_TOOLTIP' => '이메일 주소 감사 로그를 보려면 클릭하십시오',
    'LBL_NO_SEARCH_RESULTS' => '귀하의 검색 결과를 찾을 수 없습니다',
    'NTC_CLICK_BACK' => '브라우저 뒤로 버튼을 클릭하여 오류를 수정하십시오.',
    'NTC_DATE_FORMAT' => '(연도-월-일)',
    'NTC_DATE_TIME_FORMAT' => '(연도-월-일 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => '선택하신 레코드를 정말 삭제하시겠습니까?',
    'NTC_TEMPLATE_IS_USED' => '현재 선택하신 탬플릿이 캠페인에서 사용중입니다. 정말 삭제하시겠습니까?',
    'NTC_TEMPLATES_IS_USED' => "현재 선택하신 탬플릿이 캠페인에서 사용중입니다. 정말 삭제하시겠습니까?",
    'NTC_DELETE_CONFIRMATION' => '선택하신 레코드를 정말 삭제하시겠습니까?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => '{0}을 삭제하시겠습니까?',
    'LBL_METRIC_DELETE_WARNING' => '이 측정 항목 탭을 공유받은 사용자는 액세스 권한을 잃게 됩니다.',
    'NTC_DELETE_CONFIRMATION_NUM' => '다음 레코드를 정말 삭제하시겠습니까?',
    'NTC_UPDATE_CONFIRMATION_NUM' => '다음 레코드를 정말 수정하시겠습니까?',
    'NTC_DELETE_SELECTED_RECORDS' => 'selected record(s)?',
    'LBL_DELETE_FILTER_CONFIRMATION' => '이 필터는 모든 보기에서 제거됩니다; 이 대시렛창(dashlets)의 데이터 구성을 포함할 수 있습니다. 필터를 삭제하시겠습니까?',
    'TPL_DELETE_FILTER_SUCCESS' => '필터 {{name}}을 삭제하였습니다.',
    'NTC_DELETE_SUCCESS' => '삭제했습니다 {0}.',
    'NTC_UNLINK_CONFIRMATION' => '링크을 삭제하시겠습니까?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => '{0}을 해제하시겠습니까?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => '{0} 연결을 해제하시겠습니까? 그러면 사례의 주요 연락처 필드에서도 제거됩니다.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => '{0}은(는) 이 사례의 주요 연락처이므로 연결을 해제할 수 없습니다. 이 기록의 연결을 해제하기 전에 기본 연락처 필드를 업데이트하십시오.',
    'NTC_UNLINK_SUCCESS' => '링크을 삭제했습니다.',
    'NTC_LOGIN_MESSAGE' => '사용자 아이디와 비밀번호를 입력해주십시오.',
    'NTC_NO_ITEMS_DISPLAY' => '없음',
    'NTC_REMOVE_CONFIRMATION' => '관계를 정말 삭제하시겠습니까? 관계를 삭제해도 레코드는 지워지지 않습니다.',
    'NTC_REQUIRED' => '아이디가 필요한 항목',
    'NTC_SUPPORT_SUGARCRM' => 'SugarCRM이 여러분의 비즈니스에 도움이 되셨나요? 그렇다면 SugarCRM 오픈소스 프로젝트에 도움을 주십시오. 여러분의 도움은 더 좋은 제품을 만드는데 활용됩니다. PayPal을 통해 도움을 주실 수 있습니다.',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => '환영합니다',
    'NTC_YEAR_FORMAT' => '(연도)',
    'LOGIN_LOGO_ERROR' => 'SugarCRM 로고를 대체하십시오.',
    'FATAL_LICENSE_ALTERED' => '귀하의 라이센스가 마지막 인증 이후에 변경되었습니다.',
    'ERROR_FULLY_EXPIRED' => "라이센스 사용기간이 만료된지 일주일이 지났습니다. 라이센스 갱신이 필요합니다. 현재 관리자만 접속가능합니다.",
    'ERROR_LICENSE_EXPIRED' => "라이센스 갱신이 필요합니다. 현재 관리자만 접속가능합니다.",
    'WARN_LICENSE_EXPIRED' => "귀사의 라이센스가 곧 만료됩니다.",
    'ERROR_LICENSE_VALIDATION' => "라이센스 갱신이 필요합니다. 현재 관리자만 접속가능합니다.",
    'WARN_LICENSE_VALIDATION' => "귀사의 SugarCRM라이센스를 빠른 시일내에 확인(Valication)하신시오.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '경고: 귀하의 브라우저가 지원되지 않는 호환성(IE compatibility) 모드로 설정되어 있습니다.',
    'WARN_LICENSE_SEATS' => '경고: 적용된 라이센스의 최대 허용 사용자 수를 초과하였습니다. 라이센스로 갱신이 필요합니다.',
    'WARN_LICENSE_SEATS_MAXED' => '경고: 라이센스가 허용하는 사용자 수를 초과하였습니다.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        '활성 사용자 수가 라이센스 수 제한을 초과합니다. 관리자에게 문의하십시오.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => '관리자만 로그인할 수 있습니다.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        '사용자 라이센스 수 한도에 도달했습니다. 기존 사용자만 로그인 할 수 있습니다.',
    'WARN_ONLY_ADMINS' => '관리자만 로그인할 수 있습니다.',
    'WARN_UNSAVED_CHANGES' => '입력한 정보를 저장하지 않은 상태에서 페이지를 이동하려합니다. 자료를 잃어버릴 수 있습니다. 정말 이동하시겠습니까?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => '이 브라우저를 새로고침하면 현재 열린 SugarLive 통화나 채팅 세션이 모두 자동으로 종료되며 저장하지 않은 변경 사항을 잃게 됩니다. 계속하시겠습니까?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => '저장되지 않은 변경 사항이 있습니다. 변경 사항을 취소하고 페이지를 벗어나시겠습니까?',
    'LBL_MFA_RESET_CONFIRMATION' => '<a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">다중 인증</a>을 재설정하시겠습니까?
이 작업을 수행하면 즉시 로그아웃되며 다음에 로그인할 때 인증 앱을 사용하여 인증해야 합니다.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => '확인 및 로그아웃',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => '1개 이상의 Dashlet에 저장되지 않은 변경사항이 있습니다. 서랍을 닫으시겠습니까?',
    'LBL_NAVIGATE_TO_REPORTS' => '보고서 모듈로 이동하고 있습니다. 대시렛창(dashlet)에 대한 변경 사항이 저장되지 않습니다. 계속하시겠습니까?',
    'ERROR_NO_RECORD' => '자료를 가져오기를 실패하였습니다. 이 자료는 지워졌거나 읽기권한이 변경된 상태일 수 있습니다.',
    'ERROR_TYPE_NOT_VALID' => '에러. 형식이 올바르지 않습니다.',
    'ERROR_MAX_FIELD_LENGTH' => '오류,이 필드의 최대허용 길이는',
    'ERROR_MIN_FIELD_LENGTH' => '오류, 이 필드의 최저허용 길이는',
    'ERROR_EMAIL' => '오류. 유효하지 않은 이메일 주소',
    'ERROR_PRIMARY_EMAIL' => '오류. 최소 하나의 기본주소가 설정되어야 합니다.',
    'ERROR_DUPLICATE_EMAIL' => '오류. 중복 이메일 주소',
    'ERROR_FIELD_REQUIRED' => '오류. 이 필드는 필수항목입니다.',
    'ERROR_MINVALUE' => '오류. 이 필드의 최저 허용 값은',
    'ERROR_MAXVALUE' => '오류. 이 필드의 최대 허용 값은',
    'ERROR_IS_GREATER_THAN' => '에러. 필드의 값이 {{this}} 보다는 더 커야합니다.',
    'ERROR_IS_LESS_THAN' => '에러. 필드의 값이 {{this}} 보다는 더 적어야 합니다.',
    'ERROR_DATETIME' => '오류. 올바르지 않은 날짜형식을 입력하셨습니다.',
    'ERROR_IS_BEFORE' => '오류. 필드의 날짜가 ..필드의 날짜보다 뒤일수 없습니다.',
    'ERROR_IS_AFTER' => '오류. 필드의 날짜가 ..필드의 날짜보다 전일수 없습니다.',
    'ERROR_TIME_IS_BEFORE' => '에러. 이 필드의 시간은 {{this}} 필드의 이전이어야 합니다.',
    'ERROR_TIME_IS_AFTER' => '에러. 이 필드의 시간은 {{this}} 필드의 이후이어야 합니다.',
    'ERROR_NUMBER' => '유효한 숫자를 입력하십시오.',
    'ERROR_INT' => '에러. 유효하지 않은 정수.',
    'ERROR_URL' => '오류. 잘못된 URL.',
    'ERROR_NO_BEAN' => '값 획득 실패',
    'ERROR_ACCESS_MODULE' => '이 모듈에 접근할수 없습니다.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => '오류가 발생했습니다. 첨부 파일이 너무 큽니다.',
    'ERROR_UPLOAD_FAILED' => '오류가 발생했습니다. 이 파일은 업로드하지 못했습니다.',
    'ERROR_UPLOAD_ACCESS_PD' => '이 모듈에 대한 [프로세스 정의]를 생성할 권한이 없습니다.',
    'ERROR_UPLOAD_ACCESS_BR' => '이 모듈에 대한 [비즈니스 규칙]을 생성할 권한이 없습니다.',
    'ERROR_UPLOAD_ACCESS_ET' => '이 모듈에 대한 [이메일 템플릿]을 생성할 권한이 없습니다.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => '오류. 지원되지 않는 연산자를 입력하셨습니다.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => '오류. 유효하지 않은 연산자를 입력하셨습니다.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => '오류. 유효하지 않은 필터를 입력하셨습니다.',
    'ERROR_PA_UNSUPPORTED_FILE' => '가져오지못했습니다. 자세한내용을보려면 Sugar 로그를참조하십시오.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => '가져오지 못했습니다. 프로세스 정의의 그룹 필드가 일부 잠겨 있습니다.' .
        ' 정의를 가져오려면 프로세스 정의에서 이 필드들의 잠금 해제를 해야 합니다.',
    'ERROR_EXP_DATE_LOW' => '오류. 만료 일자를 발매 일자 이전으로 설정할 수 없습니다.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => '오류. 승인된 상태에는 게시일이 필요합니다.',
    'ERROR_ACTIVE_DATE_EMPTY' => '게시 날짜가 비었습니다.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => '중복된 레코드 찾기',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => '중복 확인은 {{module}}에 대해 사용할 수 없습니다.',
    'LBL_MANAGE_SUBSCRIPTIONS' => '구독 관리',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Manage Subscriptions for',
    'LBL_SUBSCRIBE' => '구독하기',
    'LBL_UNSUBSCRIBE' => '구독취소하기',
    'LBL_CREATE_LINK_RECORD' => '신규 생성후 레코드에연결',
    'LBL_CREATE_LINK_BUTTON_LABEL' => '신규 생성후 레코드에연결',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} 기록이 연결되어 있습니다.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => '연결하는 기록이 없습니다.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => '선택한 보고서가 올바른 모듈 유형을 기반으로 하고 있지 않습니다.',
    'ERROR_EMPTY_LINK_MODULE' => '관련된 관계를 먼저 선택하십시오.',
    // Ajax status strings
    'LBL_LOADING' => '잠시만 기다려주십시오.',
    'LBL_LOADING_NO_DOTS' => '로딩중입니다.',
    'LBL_SEARCHING' => '검색중입니다...',
    'LBL_SEARCH_UNDERWAY' => '검색 중',
    'LBL_SAVING_LAYOUT' => '레이아웃 저장중 ...',
    'LBL_SAVED_LAYOUT' => '레이아웃이 저장되었습니다.',
    'LBL_SAVED' => '저장되었습니다.',
    'LBL_SAVING' => '저장중',
    'LBL_FAILED' => '실패하였습니다!',
    'LBL_DISPLAY_COLUMNS' => '표시 항목',
    'LBL_HIDE_COLUMNS' => '숨겨진 항목',
    'LBL_SEARCH_CRITERIA' => '검색 조건',
    'LBL_SAVED_VIEWS' => '저장된 화면',
    'LBL_PROCESSING_REQUEST' => '처리중 ...',
    'LBL_REQUEST_PROCESSED' => '완료됨',
    'LBL_AJAX_FAILURE' => '로딩실패',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => '검색중',
    'LBL_SAVED_SEARCH_SHORTCUT' => '저장된 검색옵션',
    'LBL_SEARCH_POPULATE_ONLY' => '위의 검색 기능을 사용해 검색을 실시합니다.',
    'LBL_SEARCH_NO_RESULTS' => '결과가 없습니다.',
    'LBL_SEARCH_FOR' => '검색',
    'LBL_SEARCH_FOR_MORE' => '더 검색합니다.',
    'LBL_SEARCH_SELECT' => '선택하기',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => '검색 및 선택 중...',
    'LBL_SEARCH_SELECT_MODULE' => '{{module}} 선택',
    'LBL_DETAILVIEW' => '상세화면',
    'LBL_LISTVIEW' => '목록보기',
    'LBL_EDITVIEW' => '수정화면',
    'LBL_SEARCHFORM' => '검색양식',
    'LBL_SAVED_SEARCH_ERROR' => '이 화면의 이름을 입력하십시오.',
    'LBL_DISPLAY_LOG' => '변경레코드보기',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => '장소:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => '상세정보:',
    'MSG_JS_ALERT_MTG_REMINDER_START' => '시작중',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => '확인을 눌러 현재 예약된 전화를 확인하거나 취소를 눌러 이 메세지를 지웁니다.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => '확인을 눌러 현재 예약된 회의를 확인하거나 취소를 눌러 이 메세지를 지웁니다.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => '검색된 자료가 없습니다.',
    'MSG_LIST_VIEW_NO_RESULTS' => '<item1>로 검색된 자료가 없습니다.',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => '<item1>을 새 <item2>로 추가하기',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => '현재 저장된 레코드가 없습니다. <item2> 혹은 <item3> 를 이용하여 레코드를 등록해주십시오.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => '현재 저장된 기록이 없습니다. 지금 한 개의 기록이 있습니다.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => '당신은에서 만들 수 있습니다. 목록.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => '긍정',
    'LBL_SENTIMENT_NEUTRAL' => '중간',
    'LBL_SENTIMENT_NEGATIVE' => '부정',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => '구성된 측정 항목 탭 없음',
    'LBL_NO_METRIC_VISIBLE' => '표시 가능 측정 항목 탭 없음',
    'LBL_MAKE_METRIC_VISIBLE' => '측정 항목 탭을 표시하려면 “구성”을 선택합니다',
    'LBL_PLEASE_CONTACT_ADMIN' => '관리자에게 문의하십시오',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => '여기를 클릭',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => '내 즐겨찾기에 추가',
    'LBL_MARK_AS_FAVORITES' => '즐겨찾기로 표시',
    'LBL_CREATE_CONTACT' => '연락처 추가하기',
    'LBL_CREATE_NOTE' => '메모 추가하기',
    'LBL_CREATE_OPPORTUNITY' => '영업기회 추가하기',
    'LBL_SCHEDULE_CALL' => '전화일정',
    'LBL_SCHEDULE_CALL2' => '전화',
    'LBL_SCHEDULE_MEETING' => '회의일정',
    'LBL_SCHEDULE_MEETING2' => '회의',
    'LBL_CREATE_MESSAGE' => '메시지 생성',
    'LBL_CREATE_MESSAGE2' => '메세지',
    'LBL_CREATE_TASK' => '작업 추가하기',
    'LBL_CREATE_TASK2' => '작업',
    'LBL_REMOVE_FROM_FAVORITES' => '내 즐겨찾기에서 삭제',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => '메모',
    'LBL_DOWNLOAD_ALL' => '모두 다운로드',
    'LBL_DOWNLOAD_ONE' => '다운로드',
    'LBL_ATTACHMENTS' => '첨부',
    'LBL_ADD_ATTACHMENT' => '검색',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => '웹투리드 폼 만들기',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => '웹투리드 폼으로 저장하기',

    'LBL_PLEASE_SELECT' => '선택해 주십시오',
    'LBL_REDIRECT_URL' => '이동될 페이지 주소',
    'LBL_RELATED_CAMPAIGN' => '관련된 캠페인',
    'LBL_ADD_ALL_LEAD_FIELDS' => '모든 항목 추가',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => '모든 항목 삭제',
    'LBL_ONLY_IMAGE_ATTACHMENT' => '이미지만 첨부 가능합니다.',
    'LBL_REMOVE' => '삭제',
    'LBL_TRAINING' => '슈가CRM 고객지원',
    'ERR_DATABASE_CONN_DROPPED' => '데이터베이스를 실행하는중에 문제가 발생했습니다. 페이지를 새로고침 해주십시오. 만약 데이터베이스 접속이 끊어진 경우 서버를 재가동 시켜주십시오.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => '오류 설정 {0} 관계{1}',
    'ERR_MSSQL_DB_CONTEXT' => '데이터베이스 context를 다음으로 변경합니다:',
    'ERR_MSSQL_WARNING' => '경고:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => '전자명함의 구문해석을 실패했습니다.',
    'ERR_VCARD_FILE_MISSING' => 'vcf파일이 없습니다.',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => '경고: [[field]] 항목이 다음파일에 정의되지 않았습니다. [moduleDir] vardefs.php 파일을 확인해주십시오.',
    'ERR_CANNOT_CREATE_METADATA_FILE' => '에러: [[file]] 파일이 없습니다. 해당 HTML파일을 찾을 수 없어 생성할 수 없습니다.',
    'ERR_CANNOT_FIND_MODULE' => '에러: [module] 모듈이 존재하지 않습니다.',
    'LBL_ALT_ADDRESS' => '다른 주:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => '오류 : 키 와 displayParams 배열의  복사 요소에 대한 인수의 불평등 수 있습니다.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => '대한 displayParams 배열의 인덱스를 누락:',

    'LBL_DASHLET' => '대쉬릿',
    'LBL_DASHLET_CONFIGURE_FILTERS' => '필터',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => '내 관련자료만',
    'LBL_DASHLET_CONFIGURE_TITLE' => '제목',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => '가로열 표시',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => '현재 기록 관련',
    'LBL_DASHLET_CONFIGURE_LINKED' => '연결 필드',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => '첫 열 고정',

    'LBL_REMOVE_DASHLET_CONFIRM' => '대쉬릿을 제거하시겠습니까?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => '행을 삭제하시겠습니까?',
    'LBL_MAXIMUM_OF' => '최대의',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => '행이 표시될 수 있습니다',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => '대시보드',
    'LBL_DEFAULT_DASHBOARD_TITLE' => '내 대시보드',
    'LBL_COLLAPSE_ALL' => '전체 접기',
    'LBL_EXPAND_ALL' => '전체 확장',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => '편집하기',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => '보고서 보기',
    'LBL_DASHLET_REFRESH_LABEL' => '새로고침',
    'LBL_DASHLET_REMOVE_LABEL' => '제거',
    'LBL_DASHLET_DROP_HERE' => '여기에 끌어서 내립니다.',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => '최소화',
    'LBL_DASHLET_MAXIMIZE' => '최대화',
    'LBL_DASHLET_CONFIGURE' => '구성',
    'LBL_DASHLET_TOGGLE' => '열기/닫기',
    'LBL_SIDEPANE_TOGGLE' => '작업창 열기/닫기',
    'LBL_RESTORE_DEFAULT_DASHLETS' => '기본 대쉬릿 복원',
    'LBL_NO_DASHBOARD_CONFIGURED' => '구성된 대시보드 없음',
    'LBL_CREATE_DASHBOARD_LINK' => '대시보드 만들기',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => '도움말',
    'LBL_HELPLET_TOGGLE' => '열기/닫기',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => '모듈',
    'LBL_FACET_MODIFIED_BY_ME' => '내가 수정함',
    'LBL_FACET_CREATED_BY_ME' => '본인에 의해 생성',
    'LBL_FACET_MY_FAVORITES' => '내 즐겨찾기 목록:',
    'LBL_FACET_ASSIGNED_TO_ME' => '나에게 할당됨',
    'LBL_FACET_NO_DATA' => '이 측면에 대한 데이터 없음.',

    'LBL_DASHLET_LISTVIEW_NAME' => '목록보기',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => '지정된 분류대로 특정 모듈의 기록을 표시합니다.',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => '콘솔 목록 보기',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => '콘솔에서 보고 있는 레코드와 관련된 특정 모듈의 레코드 목록입니다.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => '레코드 보기',
    'LBL_RELATED_RECORDS' => '관련 {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => '탭에 레코드 및 선택적으로 관련된 레코드 표시.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => '기본 레코드 유형',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => '이 {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => '탭',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => '기본 레이아웃 미리보기',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => '경고, 오직 {{numWord}} ({{num}}) 모듈만이 탭에 표시될 수 있습니다. ' .
        '다른 것을 추가하기 전에 하나 또는 그 이상의 모듈을 제거하십시오.',
    'LBL_SIX' => '6', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => '코멘트 로그',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => '레코드를 위해 코멘트 표시',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => '사용 가능한 코멘트가 없음',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => '추가하기',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => '코멘트 추가하기',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => '모두 보기',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => '데이터를 사용할 수 없습니다. 이러한 모듈에 액세스할 수 있는 권한이 없습니다.' .
    " \n이 대쉬릿을 업데이트하거나 제거하십시오.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => '내 {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => '표시를 위해 선택된 레코드가 없음',
    'LBL_CONTENT_SEARCH_DASHLET' => '콘텐츠 검색 Dashlet',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => '{{username}} 님, 오늘은 무엇을 도와드릴까요?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => '사례를 만드시겠습니까?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => '영업기회 매트릭스(Metrics)',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => '관련 거래처의 영업기회 메트릭스',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => '제품 카탈로그 빠른 추천',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => '최근에 사용된 항목 및 즐겨찾기로 저장된 제품 나열',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => '최근 사용',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => '즐겨찾기',

    'LBL_DASHBOARD_CREATE' => '대시보드 만들기',
    'LBL_DASHBOARD_DUPLICATE' => '대시보드 복사',
    'LBL_DASHBOARD_DELETE' => '대시보드 삭제',
    'LBL_PIN_TO_TOP' => '상단에 고정',
    'LBL_PIN_TO_BOTTOM' => '하단에 고정',
    'LBL_MANAGE_DASHBOARDS' => '대시보드 관리',

    'LBL_DASHBOARD_CONFIG' => '대시보드 구성',
    'LBL_LIST_VIEW__NAME' => '목록 보기',
    'LBL_PIPELINE_VIEW_NAME' => '타일 보기',
    'LBL_PIPELINE_VIEW_BTN' => '타일 보기',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{fieldName}}의 {{module}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => '타일 보기는 가능하지 않음',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => '기록을 이 시간에 찾을 수 없습니다.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => '사례 요약',
    'LBL_DASHLET_ITERACTIONS_NAME' => '타임라인',
    'LBL_DASHLET_ATTACHMENTS_NAME' => '메모와 첨부문서',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => '레코드의 메모와 첨부문서',
    'LBL_DASHLET_PIPLINE_NAME' => '파이프라인',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => '최근 트윗',

    'LBL_DASHBOARD_NO_RECORDS' => '저장된 대시보드가 없습니다.',

    'LBL_DNB_AND' => '및',
    'LBL_DNB_PRIM_NAME_DESC' => '이 단체에 대한 이름의 텍스트 기록',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => '답장하기',
    'LBL_TWITTER_RETWEET' => '리트윗',
    'LBL_TWITTER_FAVORITE' => '즐겨찾기',
    'LBL_TWITTER_FOLLOW' => '팔로우',
    'LBL_TWITTER_DESCRIPTION' => '관련 트위터사용자의 바이오와 트위트, 리트윗, 그리고 대답과 트위트를 봅니다.',
    'LBL_TWITTER_ID' => '트위터 아이디',
    'LBL_TWITTER_DISPLAY_ROWS' => '줄 표시',
    'LBL_TWITTER_MY_ACCOUNT' => '내 계정',
    'LBL_TWITTER_NAME' => '트위터',
    'LBL_TWITTER_SOURCE' => '소스 트윗 :',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => '학습 자료',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => '교육 및 인증',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub 커뮤니티',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => '문서 및 지원',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters 마켓플레이스',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => '국가별 영업차트',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => '국가별 영업차트 표시',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => '기술자료범주및게시된문서',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => '지식 기반 검색',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => '게시된 지식기반 조항 및 범주의 검색 가능한 트리 보기를 표시합니다.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => '게시된문서(다른언어)',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => '게시된 지식 기반 기사 중 가장 유용한 내용',
    'LBL_DASHLET_MOST_USEFUL_DESC' => '지식 베이스 기사 중 가장 인기있고 많이 읽은 것을 보여줍니다',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} filtered by {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => '기사의 유용성',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => '페이지 추가하기',
    'LBL_LOADING_PAGE' => '로딩중입니다. 잠시만 기다려주십시오.',
    'LBL_SEARCH_RESULTS' => '검색된 결과',
    'LBL_SEARCH_RESULTS_FOR' => '다음에 대한 검색 결과: ',
    'LBL_SEARCH_HELP_TITLE' => '검색',
    'LBL_SEARCH_RESULTS_FOUND' => '검색된 결과를 찾았습니다.',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => '내 파이프라인',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "내 부서의 파이프라인",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => '세일즈 파이프라인 차트',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => '현재 파이프라인 차트를 표시',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => '이미지 없음',

    'LBL_MODULE' => '모듈',
    'LBL_RELATIONSHIP' => '관계',
    'LBL_SINGULAR_LABEL' => '단수 라벨',
    'LBL_PLURAL_LABEL' => '복수 라벨',
    'LBL_MODULE_DISPLAY' => '표시(Display)',
    'LBL_MODULE_DISPLAY_TYPE' => '전시 유형',
    'LBL_MODULE_ICON' => '아이콘',
    'LBL_MODULE_COLOR' => '모듈 배경 색상',
    'LBL_LANGUAGE_SELECTOR' => '언어',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => '모듈 설정',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => '모듈 설정이 저장되었습니다.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => '왼쪽주소복사:',
    'LBL_SAVE_AND_CONTINUE' => '저장 후 다음 자료로 계속하기',

    'LBL_SEARCH_HELP_TEXT' => '다수 선택 조종법<br />특성(Attribute) 선택을 위해 값을 선택합니다.<br />다수 선택을 위한 컨드롤키를 클릭합니다. Mac 사용자는 CMD클릭을 사용하십시오.<br />두 특성 사이의 모는 값을 선택하려면 첫 값을 선택후 마지막 값을 쉬프트키로 클릭하십시오.<br /><br />고급검색과 레이아웃 선택<br />고급검색과 레이아웃 설정을 통해 자주 사용하는 검색 조건과 검색 결과 목록보기 레이아웃을 저장하여 자주 사용하는 검색조건을 빠르게 실행하고 결과를 조회할 수 있습니다. 고급검색과 레이아웃 저장의 횟수에는 제약이 없습니다. 모든 저장된 검색은 목록의 상위에 나타나는 마지막으로 저장된 검색과 함께 검색 목록에 이름에 따라 나타납니다. <br /><br />목록보기 레이아웃를 변경하려면 어느 필드가 검색결과에 표시될지 선택할 세로열 숨기기와 세로열 상자 표시를 사용합니다. 예를 들면 검색결과의 기록명과 담당자 그리고 담당팀과 같은 세부사항을 보거나 숨길수 있습니다. 목록보기에 세로열을 추가하려면 세로열 숨기기목록에서 필드를 선택하여 왼쪽 화살표를 사용해 세로열 표시 목록으로 이동할수 있습니다. 제거하시려면 세로열 표시 목록에서 선택하여 오른쪽 화살표을 사용해 세로열 숨기기 목록으로 이동하십시오.<br />레이아웃 설정을 저장했다면 검색결과를 보기위한 레이아웃에 항상 받을수 있습니다.<br /><br />검색 레이아웃를 저장후 업데이트하려면<br />1. &#39;이 검색을 다음으로 저장&#39; 필드에서 검색결과를 위한 이름을 입력한뒤 저장 버튼을 클릭합니다. 이제 이름은 비우기 버튼에 인접한 저장된 검색목록에 표시됩니다.<br />2. 저장된 검색을 보려면 저장된 검색목록에서 선택합니다. 검색 결과가 목록보기에 나타납니다.<br />3. 저장된 검색의 소유권을 업데이트하려면 저장 검색 목록에서 선택한후 &#39;현 검색 수정&#39; 옆의 삭제버튼을 클릭하고 삭제를 확인하기위한 네 버튼을 클릭합니다.',

    //resource management
    'ERR_QUERY_LIMIT' => '오류: $module 모듈에 대한 쿼리 제한 $limit에 도달했습니다.',
    'ERROR_NOTIFY_OVERRIDE' => '오류. 자원 관찰자-무효화 필요를 알립니다.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => '오류. metadata파일이 비었거나 파일이 존재하지 않아 모니터를 만들수 없습니다.',
    'ERR_MONITOR_NOT_CONFIGURED' => '오류. 요청한 이름으로 구성된 모니터가 없습니다.',
    'ERR_UNDEFINED_METRIC' => '오류: 정의되지 않은 Metric은 값을 설정할 수 없습니다.',
    'ERR_STORE_FILE_MISSING' => '오류:스토어 실행 파일을 찾을수 없습니다.',

    'LBL_MONITOR_ID' => '모니터 Id',
    'LBL_TEAM_ID' => '팀 ID',
    'LBL_SELECT_MODULE' => '모듈 선택:',
    'LBL_USER_ID' => '사용자 Id',
    'LBL_MODULE_NAME' => '모듈명',
    'LBL_MODULE_ALL' => '모든',
    'LBL_ITEM_ID' => '아이템 Id',
    'LBL_ITEM_SUMMARY' => '아이템 개요',
    'LBL_ACTION' => '액션',
    'LBL_SESSION_ID' => '세션 Id',
    'LBL_BREADCRUMBSTACK_CREATED' => '사용자 id {0}를 위해 생성된 BreadCrumbStack',
    'LBL_VISIBLE' => '보기가능한 기록',
    'LBL_DATE_LAST_ACTION' => '마지막 액션 날짜',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL 문자',
    'LBL_QUERY_HASH' => 'SQL 해시',
    'LBL_SEC_TOTAL' => '보조 합계(Total Seconds)',
    'LBL_SEC_AVG' => '평균 보조(Average Seconds)',
    'LBL_RUN_COUNT' => '문의사항 합계',

    //Tracker Sessions
    'LBL_CLIENT_IP' => '고객 IP 주소',
    'LBL_DATE_START' => '시작 날짜',
    'LBL_ACTIVE' => '활성 세션',
    'LBL_ROUNDTRIPS' => '액션 개수 합계',
    'LBL_SECONDS' => '초단위 활성(Seconds Active)',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => '데이터베이스 라운드트립(Roudntrips)',
    'LBL_FILES_OPENED' => '파일에 접속되었습니다.',
    'LBL_MEMORY_USAGE' => '메모리 사용(바이트)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => '트위터 커넥터로부터 로딩중입니다.',
    'LBL_TWITTER_DATA_EMPTY' => '트위터로부터의 사용가능한 데이터가 없습니다.',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Outlook을 위한 SugarCRM 플러그인',
    'LBL_PLUGIN_OUTLOOK_DESC' => '이메일, 작업, 회의 업로드가 가능한 아웃록용 SugarCRM 플러그인',
    'LBL_PLUGIN_WORD_NAME' => 'Word를 위한 SugarCRM 플러그인',
    'LBL_PLUGIN_WORD_DESC' => '마이크로소프트 워드로 SugarCRM의 레코드를 자동 입력하기 위한 플러그인',
    'LBL_PLUGIN_EXCEL_NAME' => 'Excel을 위한 SugarCRM 플러그인',
    'LBL_PLUGIN_EXCEL_DESC' => '보다 많은 분석이 가능한 엑셀 스프레드시트용 SugarCRM 플러그인',
    'LBL_PLUGINS_TITLE' => 'Microsoft Office<sup>TM</sup>를 위한 SugarCRM 플러그인',
    'LBL_PLUGINS_DESC' => '플러그인 문서안의 플러그인 기능을 참조하십시오.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Lotus Notes<sup>TM</sup>를 위한 SugarCRM 플러그인',
    'LBL_PLUGIN_LOTUS_NAME' => 'Lotus Notes를 위한 SugarCRM 플러그인',
    'LBL_PLUGIN_LOTUS_DESC' => 'Lotus Notes용 SugarCRM 플러그인',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => '전에 아닙니다.',
    'MSG_IS_MORE_THAN' => '다음보다 더 많습니다.',
    'MSG_IS_LESS_THAN' => '다음보다 적습니다.',
    'MSG_SHOULD_BE' => '반드시',
    'MSG_OR_GREATER' => '혹은 더 큽니다.',
    'MSG_EXCEEDS_MAXLEN' => '지정된 최대 길이를 초과합니다. ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Sugar Portal 5.1.0에 오신것을 환영합니다.',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal은 귀사의 고객에게 사례, 버그의 진행상황을 고객에게 실기간으로 제공할 수 있는 대고객 인터페이스입니다. 향후 릴리즈 될 프로젝트 관리와 포럼과 같은 셀프서비스 포탈 기능도 지켜봐주십시오.',
    'LBL_LIST' => '목록',
    'LBL_CREATE_CASE' => '사례 만들기',
    'LBL_CREATE_BUG' => '버그 만들기',
    'LBL_NO_RECORDS_FOUND' => '- 발견된 자료가 없습니다 -',

    'DATA_TYPE_DUE' => '예정일자:',
    'DATA_TYPE_START' => '시작일자:',
    'DATA_TYPE_SENT' => '발송일자:',
    'DATA_TYPE_MODIFIED' => '수정일자:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => '합계',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => '오브젝트 이미지',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => '날짜를 선택합니다.',

    'LBL_VALIDATE_RANGE' => '유효한 범위안에 없습니다.',
    'LBL_VALIDATE_URL' => '유효하지 않은 URL',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => '전체',

    'LBL_OPERATOR_IN_TEXT' => '다음중 하나입니다.',
    'LBL_OPERATOR_NOT_IN_TEXT' => '다음중 하나가 아닙니다.',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => '오류:bean 변수의 배열합계가 결과와 일치하지 않습니다.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => '오류:모듈을 위한 배치 항목이 없습니다.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => '오류. 0 커넥터의 데이터를 복구할수 없습니다. 현재 접속할수 없는 서비스이거나 구성설정이 유효하지 않습니다. 연결 오류 메세지 1',
    'ERROR_CONNECTOR_CONFIGURE' => '데이터를 받을수 없습니다. 이 서비스가 현재 불가하거나 구성설정이 유효하지 않을수 있습니다.',
    'LBL_CONNECT_TWITTER' => '트위터에 연결',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => '트위터 ID에 대해 유효한 타임 라인을 찾을 수 없습니다',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => '트위터 커넥터 구성',
    'LBL_CONNECT_TEST_FAIL' => '오류. 커넥터 구성설정이 유효하지 않을수 있습니다. 관리자에 문의하십시오.',
    'LBL_CONFIGURE_TWITTER' => '트위터 구성을 관리자에 문의하십시오.',
    'LBL_MERGE_CONNECTORS' => '데이터가져오기',
    'LBL_NO_DATA_AVAILABLE' => '이용 가능한 데이터 없음',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => '이 모듈의 커넥터를 중지하시겠습니까?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => '융통성있는 서버에 연결하지 못했습니다',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => '글로벌 팀은 삭제할 수 없습니다.',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => '이 개인팀 0 은 사용자 1이 삭제될때까지 삭제될 수 없습니다.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => '어도비 플래시(Abobe Flash)가 활성상태가 아니거나 이전 버전을 사용중입니다. 최신버전을 받으시려면,  <a href= http://www.adobe.com/go/getflashplayer/ >여기를 클릭하십시오</a>.',
    //Collection Field
    'LBL_COLLECTION_NAME' => '이름',
    'LBL_COLLECTION_PRIMARY' => '기본',
    'ERROR_MISSING_COLLECTION_SELECTION' => '비어있는 필수항목 필드',
    'LBL_COLLECTION_EXACT' => '일치',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'For optimal experience using IIS/FastCGI sapi 로 최상의 사용경험을 위해서는 귀하의  php.ini 파일에 fastcgi.logging 를 0으로 설정하십시오.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => '담당자',
    'LBL_DESCRIPTION' => '설명',
    'LBL_PRIMARY_CONTACT_NAME' => '주요 연락처',
    'LBL_PRIMARY_CONTACT_ID' => '주요 연락처 ID',

    'LBL_NONE' => '-없음-',
    'LBL_YESTERDAY' => '어제',
    'LBL_TODAY' => '오늘',
    'LBL_TOMORROW' => '내일',
    'LBL_NEXT_WEEK' => '다음주',
    'LBL_NEXT_MONDAY' => '다음 월요일',
    'LBL_NEXT_FRIDAY' => '다음 금요일',
    'LBL_TWO_WEEKS' => '2주',
    'LBL_NEXT_MONTH' => '다음달',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => '다음달 1일',
    'LBL_THREE_MONTHS' => '3개월',
    'LBL_SIXMONTHS' => '6개월',
    'LBL_NEXT_YEAR' => '내년',
    'LBL_FILTERED' => '필터사용됨',

    //Datetimecombo fields
    'LBL_HOURS' => '시',
    'LBL_MINUTES' => '분',
    'LBL_MERIDIEM' => '정오',
    'LBL_DATE' => '날짜',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => '자동 새로고침',

    'LBL_DURATION_DAY' => '일',
    'LBL_DURATION_HOUR' => '시',
    'LBL_DURATION_MINUTE' => '분',
    'LBL_DURATION_DAYS' => '일',
    'LBL_DURATION_HOURS' => '시',
    'LBL_DURATION_MINUTES' => '분',
    'LBL_DURATION_SECONDS' => '초',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => '월을 선택하십시오.',
    'LBL_ENTER_YEAR' => '연도를 입력하십시오.',
    'LBL_ENTER_VALID_YEAR' => '유효한 연도를 입력하십시오',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => '지역번호를 포함한 미국 전화번호 숫자를 입력하십시오.',
    'LBL_CCP_NOT_INITIATED' => '에이전트가 로그인하지 않은 상태에서 CCP로 전화를 거는 중입니다.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'CCP로 통화를 시작할 수 없습니다.',
    'LBL_CCP_DIALING_ERROR' => '이 통화는 전화가 연결된 상태로 완료할 수 없습니다.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'SugarLive 채팅 세션을 모두 닫은 뒤 아웃바운드 통화를 시작해 주십시오.',

    //File write error label
    'ERR_FILE_WRITE' => '오류:파일을 덮어쓰지 못했습니다. 시스템과 웹서버 허용을 확인하십시오.',
    'ERR_FILE_NOT_FOUND' => '오류:파일을 전송하지 못했습니다. 시스템과 웹서버 허용을 확인하십시오.',

    'LBL_AND' => '그리고',
    'LBL_BEFORE' => '전',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => '귀하의 컴퓨터로부터 전송합니다.',
    'LBL_SEARCH_EXTERNAL_API' => '외부 출처 파일',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => '외부 출처로 업로드',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => '외부 출처의 링크',
    'LBL_EXTERNAL_SECURITY_LEVEL' => '보안',
    'LBL_SHARE_PRIVATE' => '개인',
    'LBL_SHARE_COMPANY' => '회사',
    'LBL_SHARE_LINKABLE' => '링크 할수 있음',
    'LBL_SHARE_PUBLIC' => '공개',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS 공지',
    'LBL_RSS_RECORDS_FOUND' => '기록이 발견되었습니다.',
    'ERR_RSS_INVALID_INPUT' => 'RSS 는 유효한 입력 형식이 아닙니다.',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS 는 이 방법을 위한 유효한 응답형식이 아닙니다.',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => '구글 문서는 입력하신 파일 형식을 지원하지 않습니다.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => '비어 있음',
    'LBL_IS_EMPTY' => '비어있습니다.',
    'LBL_IS_NOT_EMPTY' => '비어있지 않습니다.',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => 'This is a sample import file which provides an example of the expected contents of a file that is ready for import.<br />The file is a comma-delimited .csv file, using double-quotes as the field qualifier.<br /><br />The header row is the top-most row in the file and contains the field labels as you would see them in the application.<br />These labels are used for mapping the data in the file to the fields in the application.<br /><br />Notes: The database names could also be used in the header row. This is useful when you are using phpMyAdmin or another database tool to provide an exported list of data to import.<br />The column order is not critical as the import process matches the data to the appropriate fields based on the header row.<br /><br /><br />To use this file as a template, do the following:<br />1. Remove the sample rows of data <br /> 2. Remove the help text that you are reading right now<br />3. Input your own data into the appropriate rows and columns<br/>4. Save the file to a known location on your system<br />5. Click on the Import option from the Actions menu in the application and choose the file to upload',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => '담당자 ID',
    'LBL_EXPORT_CREATED_BY' => '생성자 ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'ID에 따른 수정',
    'LBL_EXPORT_REPORTS_TO_ID' => 'ID에 보고',
    'LBL_EXPORT_TEAM_ID' => '팀 ID',
    'LBL_EXPORT_TEAM_SET_ID' => '팀 설정 ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => '담당자',
    'LBL_EXPORT_FULL_NAME' => '전체 이름',
    'LBL_EXPORT_TEAM_NAME' => '팀',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navigating...',

    'LBL_PENDING_NOTIFICATIONS' => '알림',
    'LBL_ALT_ADD_TEAM_ROW' => '신규 팀 추가하기',
    'LBL_ALT_REMOVE_TEAM_ROW' => '팀 제거하기',
    'LBL_ALT_SPOT_SEARCH' => '부분 검색',
    'LBL_ALT_NOT_SORTED' => '정렬되지 않음',
    'LBL_ALT_SORT_DESC' => '내림차순 분류',
    'LBL_ALT_SORT_ASC' => '올림차순 분류',
    'LBL_ALT_SORTABLE' => '정렬 가능',
    'LBL_ALT_NOT_SORTABLE' => '정렬 불가',
    'LBL_ALT_SORT' => '분류',
    'LBL_ALT_SHOW_OPTIONS' => '선택항목 보이기',
    'LBL_ALT_HIDE_OPTIONS' => '선택항목 숨기기',
    'LBL_ALT_MOVE_COLUMN_LEFT' => '선택된 항목을 왼쪽의 목록으로 이동합니다.',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => '선택된 항목을 오른쪽의 목록으로 이동합니다.',
    'LBL_ALT_MOVE_COLUMN_UP' => '나열된 목록 순서에서 선택된 항목을 위로 이동합니다.',
    'LBL_ALT_MOVE_COLUMN_DOWN' => '나열된 목록 순서에서 선택된 항목을 아래로 이동합니다.',
    'LBL_ALT_INFO' => '정보',
    'MSG_DUPLICATE' => '생성하려는 {0} 레코드는 기존 레코드와 중복될 수 있습니다. {1} 레코드가 아래 나열된 이름과 유사한 이름을 포함합니다. 신규 {0}을 생성하려면 {1}만들기를 클릭하거나 아래 나열된 기존 {0} 을 선택하십시오.',
    'MSG_SHOW_DUPLICATES' => '생성하려는 {0} 레코드는 기존 레코드와 중복될 수 있습니다. {1} 레코드가 아래 나열된 이름과 유사한 이름을 포함합니다. 신규 {0}을 생성하려면 {1}만들기를 클릭하거나 메뉴로 돌아가려면 취소 버튼을 클릭하십시오.',
    'LBL_EMAIL_TITLE' => '이메일 주소',
    'LBL_EMAIL_OPT_TITLE' => '수신거부 이메일 주소',
    'LBL_EMAIL_INV_TITLE' => '유효하지 않은 이메일 주소',
    'LBL_EMAIL_PRIM_TITLE' => '기본 이메일 주소',
    'LBL_SELECT_ALL_TITLE' => '전체 선택',
    'LBL_SELECT_THIS_ROW_TITLE' => '이 가로열(Row)을 선택합니다.',
    'LBL_TEAM_SELECTED_TITLE' => '선택된  팀',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => '이팀을 기본으로 설정하기위해 선택합니다.',
    'LBL_TEAM_TBSELECTED_TITLE' => '부서 기반 선택됨',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => '부서 기반 선택하기',
    'LBL_SEARCH_AND_SELECT' => '검색 및 선택 {{module}}',
    'TPL_SEARCH_AND_ADD' => '{{module}} 검색 및 추가',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => '오류: 전송중 오류가 발생했습니다. 오류 코드 {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => '오류: 업로드중 오류가 발생했습니다. 오류 코드: {0} - {1}. upload_maxsize 크기: {2}',
    'UPLOAD_ERROR_HOME_TEXT' => '오류: 전송중 오류가 발생했습니다. 도움을 위해 관리자에 문의하십시오.',
    'UPLOAD_MAXIMUM_EXCEEDED' => '업로드 ({0} 바이트) 초과 허용 최대의 크기: {1} bytes',
    'UPLOAD_REQUEST_ERROR' => '오류가 발생했습니다. 페이지를 재시작한 후 다시 시도해주십시오.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => '편집',
    'LBL_ADD_BUTTON_LABEL' => '추가하기',
    'LBL_EDIT_BUTTON_TITLE' => '편집',
    'LBL_REFRESH_BUTTON_LABEL' => '새로고침',
    'LBL_REFRESH_BUTTON_TITLE' => '새로고침',
    'LBL_DUPLICATE_BUTTON_KEY' => 'u',
    'LBL_DUPLICATE_BUTTON_LABEL' => '중복',
    'LBL_DUPLICATE_BUTTON_TITLE' => '중복',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => '보고서 일정',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => '보고서 일정',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => '보고서 세부내용',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => '보고서 세부내용',
    'LBL_DELETE_BUTTON_KEY' => 'd',
    'LBL_DELETE_BUTTON_LABEL' => '삭제',
    'LBL_DELETE_BUTTON_TITLE' => '삭제',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => '저장',
    'LBL_SAVE_BUTTON_TITLE' => '저장',
    'LBL_CANCEL_BUTTON_KEY' => 'l',
    'LBL_CANCEL_BUTTON_LABEL' => '취소',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => '멈춤',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => '이 페이지에 머무름',
    'LBL_CANCEL_BUTTON_TITLE' => '취소',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => '나누기',
    'LBL_SHARE_BUTTON_TITLE' => '나누기',
    'LBL_START_BUTTON_LABEL' => '시작',
    'LBL_START_BUTTON_TITLE' => '시작',
    'LBL_FINISH_BUTTON_LABEL' => '완료',
    'LBL_FINISH_BUTTON_TITLE' => '완료',
    'LBL_CONFIRM_BUTTON_LABEL' => '확인',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => '계속',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => '이 페이지를 종료하며 변경내용을 취소',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => '키보드 단축키',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '형식 기능키 - Alt+<br />I=편집(세부보기)<br />U=중복(세부보기)<br />D=삭제(세부보기)<br />A=저장(세부보기)<br />L=취소(세부보기)<br />검색과 탐색-Alt+<br />7= 편집 양식에 첫 입력<br />8=고급검색 링크<br />9=첫 검색 양식 입력<br />0=통일된 검색입력',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => '에스컬레이션',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => '나누기',
    'TPL_RECORD_SHARE_SUBJECT' => '공유',
    'TPL_RECORD_SHARE_BODY' => '모듈을 확인하십시오.',

    'ERR_CONNECTOR_NOT_ARRAY' => '0의 커넥터 할당이 알맞지 않게 정의되었거나 비어있어 사용할수 없습니다.',
    'LBL_PDF_VIEW' => 'PDF 다운로드하기',
    'LBL_PDF_EMAIL' => 'PDF 이메일보내기',

    'ERR_SUHOSIN' => '수호신에 의해 전송 흐름이 차단되었습니다. suhosin.executor.include.whitelist 에 전송 기능을 추가하십시오',

    //for sidecar
    'LBL_TIME_AGO_NOW' => '지금',
    'LBL_TIME_AGO_SECONDS' => '1분이 지나지 않음',
    'LBL_TIME_AGO_MINUTE' => '약 1분 전',
    'LBL_TIME_AGO_MINUTES' => '~분 전',
    'LBL_TIME_AGO_HOUR' => '약 1시간 전',
    'LBL_TIME_AGO_HOURS' => '~시간 전',
    'LBL_TIME_AGO_DAY' => '어제',
    'LBL_TIME_AGO_DAYS' => '~일 전',
    'LBL_TIME_AGO_YEAR' => '1년여 전',
    'LBL_TIME_UNTIL_SECONDS' => '약 1분 미만',
    'LBL_TIME_UNTIL_MINUTE' => '약 1 분',
    'LBL_TIME_UNTIL_MINUTES' => '{{this}} 분',
    'LBL_TIME_UNTIL_HOUR' => '약 한시간',
    'LBL_TIME_UNTIL_HOURS' => '{{this}} 시간',
    'LBL_TIME_UNTIL_DAY' => '내일',
    'LBL_TIME_UNTIL_DAYS' => '{{this}} 날',
    'LBL_TIME_UNTIL_YEAR' => '1년 이상',
    'LBL_TIME_RELATIVE' => '~일 ~시에 올림',
    'LBL_LAST_TOUCHED' => '마지막 연결',
    'LBL_LAST_COMMIT' => '마지막 기여: ',
    'LBL_LISTVIEW_NO_RECORDS' => '이용 가능한 데이터 없음',
    'LBL_DETAILVIEW_NO_RECORDS' => '이 레코드는 현재 표시할 수 없습니다.',
    'LBL_REFINE_LIST' => '교정 목록',
    'LBL_SEARCH_BY' => '검색인',
    'LBL_PREVIEW' => '미리 보기',
    'LBL_COLUMNS' => '세로줄(열)',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => '미리보기 불가. 데이터가 없습니다.',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => '미리보기 불가. 레코드에 접근이 불가능합니다',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => '미리보기 불가. 데이터가 없습니다.',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => '미리보기 불가. 현재 레코드 보는중',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => '미리보기 불가. 기록이 제거되었거나 레코드에 접근이 블가능합니다',
    'LBL_PREVIEW_PREVIOUS' => '이전 항목 미리보기',
    'LBL_PREVIEW_NEXT' => '다음 항목 미리보기',
    'LBL_PREVIEW_CLOSE' => '미리보기 닫기',
    'LBL_STREAM_NO_RECORDS' => '이 레코드는 관련된 메모가 없습니다.  메모 추가하기 링크를 클릭하여 메모를 추가하십시오.',
    'LBL_DUPLICATES_FOUND' => '중복 레코드 발견',
    'LBL_NO_DUPLICATES_FOUND' => '발견된 복제 없음.',
    'LBL_RESET_DEFAULT_VIEW' => '기본보기를 재설정',
    'LBL_RESET_DEFAULT_WIDTHS' => '기본 폭을 재설정',
    'LBL_TIMEZONE_UPDATED' => 'Sugar가 브라우저 시간대와 일치하도록 사용자 프로필 시간대를 업데이트했습니다.',
    'LBL_SUCCESS' => '성공',
    'LBL_ERROR' => '오류',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => '병합하기',
    'LBL_MERGE_DUPLICATES_PROCEED' => '계속하시겠습니까?',
    'LBL_MERGE_DUPLICATES_CONFIRM' => '이 액셔은 다음 레코드를 삭제합니다.',
    'LBL_MERGE' => '병합하기',
    'TPL_MERGING_RECORDS' => '레코드 병합',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        '유효하지 않은 슈의 레코드가 통과되었습니다. 유효한 범위는 {{minRecords}} 에서 {{maxRecords}}까지 입니다.',
    'LBL_MERGE_NO_ACCESS' =>
        '이 액션수행의 접근 권한이 없습니다.',
    'LBL_MERGE_LOCKED' => '병합을 위해 선택된 일부 레코드는 편집을 위해 잠긴 필드를 포함하고 있으며 프로세스에 의해 현재 병합할 수 없습니다.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        '변경사항을 반영하지 않고 주 레코드를 저장합니다. 모든 변경사항이 사라집니다. 계속하시겠습니까?',
    'LBL_MERGE_DUPLICATES_TITLE' => '관련 레코드 병합',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => '병합완료: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        '관련된 모듈 병합 실패. 신규 시도중',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        '관련된 모듈 병합 실패',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        '병합이 완료되지 않았습니다. 일부 레코드가 병합 전의 상태로 남아있습니다.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        '병합이 완료되지 않았습니다. 일부 레코드가 병합 전의 상태로 남아있습니다. 계속하시겠습니까?',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        '모든 관련 기록은 기본 기록으로 이동합니다.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        '병합에서 이 기록을 삭제하시겠습니까?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => '병합에서 기록을 제거합니다',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => '유효하지 않은 레코드 수가 통과되었음. 유효 범위는 1에서 {{maxRecords}} 까지의 레코드입니다.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => '입력된 사용자명과 비밀번호가 맞지 않습니다. 다시 시도해 주십시오.',
    'LBL_INVALID_CREDS_TITLE' => '유효하지 않은 증명서',
    'LBL_INVALID_GRANT' => '귀하의 암호는 유효하지 않거나 만료되었습니다. 다시 접속해 주십시오.',
    'LBL_INVALID_GRANT_TITLE' => '암호 만료',
    'LBL_AUTH_FAILED' => '고객 승인 실패',
    'LBL_AUTH_FAILED_TITLE' => '유효하지 않은 고객',
    'LBL_INVALID_REQUEST' => '요청 사항은 유효하지 않거나 잘못 생성되었습니다. 관리자에 문의하십시오.',
    'LBL_INVALID_REQUEST_TITLE' => '유효하지 않은 요청',
    'LBL_REQUEST_TIMEOUT' => '서버가 응답하지 않습니다. 인터넷 연결을 확인해 보세요.',
    'LBL_REQUEST_TIMEOUT_TITLE' => '요청 시간 초과: ',
    'LBL_UNAUTHORIZED' => '죄송합니다. 이 자원에 접속권한이 없습니다.',
    'LBL_UNAUTHORIZED_TITLE' => '접속권한이 없음',
    'LBL_RESOURCE_UNAVAILABLE' => '자원이 사용불가능합니다.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => '금지됨',
    'LBL_METHOD_NOT_ALLOWED' => '요청한 자원에 대해 HTTP 방식이 불가능 합니다. 관리자에 문의하십시오.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => '사용불가능',
    'LBL_PRECONDITION_MISSING' => '요청이 실패되었거나 조건이 잘못되었습니다. 관리자에 문의하십시오.',
    'LBL_PRECONDITION_MISSING_TITLE' => '오류',
    'LBL_INVALID_412_RESPONSE' => '응용프로그램이 적용될 수 없도록 요청이 실패 중입니다. 기술 지원 부서와 연락하십시오.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => '필드 {0} 모듈에서 편집을 사용할 수 없습니다: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => '이 레코드에서 액션의 실행이 허가되지 않습니다.',
    'LBL_LOGIN_BUTTON_LABEL' => '로그인',
    'LBL_ACTIVITY_VIEW_TOUR' => '활동 보기',
    'LNK_TOUR' => '둘러보기',
    'LNK_MOBILE' => '휴대폰',
    'LBL_FEEDBACK' => '피드백',
    'LBL_SUPPORT' => '지원',
    'LBL_LANGUAGE' => '언어',
    'LBL_LOADING_LANGUAGE' => '언어 로딩중',
    'LBL_UPLOADING' => '전송중',
    'LBL_UPLOADING_DOTS' => '업로드 중...',
    'LBL_IMAGE_DELETE_CONFIRM' => '이 이미지를 삭제하시겠습니까?',
    'LBL_FILE_DELETE_CONFIRM' => '이 파일을 삭제하시겠습니까? 삭제후 복구는 불가능합니다.',
    'LBL_FILE_DELETED' => '파일이 성공적으로 삭제되었습니다.',

    //theme roller
    'LBL_PORTAL_THEME' => '포탈 테마',
    'LBL_THEME_PREVIEW' => '포탈 테마 미리보기',
    'LBL_LOADING_PREVIEW' => '미리보기를 로딩중입니다.',
    'LBL_RESET' => '재설정',
    'LBL_COLORS' => '색',
    'BorderColor' => '테두리 색상',
    'NavigationBar' => '탐색 바',
    'PrimaryButton' => '메인버튼',
    'LBL_SAVE_AND_DEPLOY_BTN' => '저장 및 배치',
    'LBL_RESET_THEME_LNK' => '기본 테마 재저장',
    'LBL_RESET_THEME_MODAL_INFO' => '사용자 정의 테마가 지워지고 기본 테마로 변경됩니다.',
    'LBL_RESET_THEME_PROCESS' => '기본 테마를 재저장중입니다.',
    'LBL_SAVE_THEME_PROCESS' => '테마를 저장중입니다.',

    // image loader
    'LBL_SELECT_PHOTO' => '사진을 선택합니다.',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Sugar에서의 강화된 예측 기능성',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '예측 변수를 설정하십시오.<br />프로젝트 영업과 예측 상태를 쉽게 확인합니다.<br />소속 영업팀의 프로젝트 영업에 기반한 예측',
    'LBL_TOUR_SCREEN_2_TITLE_670' => '귀하의 예측 변수를 설정하십시오.',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '시작 회계연도를 선택하십시오.<br />연도별 또는 분기별 기간을 설정하십시오.<br />워크시트에 표시될 기간을 선택하십시오.<br />Select forecast ranges to tag Opportunities as Include, Exclude or Upside.<br />가능(Likely), 최고(Best), 최하(Worst)로 구분된 예측 시나리오를 선택하십시오.',
    'LBL_TOUR_SCREEN_3_TITLE_670' => '귀하 소속팀의 프로젝트 영업을 관리합니다.',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '예측 리뷰를 위한 기간을 선택하십시오.<br />귀하 팀 구성원의 워크시트를 보고 예측을 조정하여 팀 구성원에게 보냅니다.<br />영업팀 구성원이 새로운 예측을 커밋(Commit)하면 워크시트의 알림을 확인합니다.<br />예측 워크시트를 임시(Draft)로 저장하거나 보고자에 커밋(Commit)합니다.<br />과거 커밋된 내역을 봅니다.',
    'LBL_TOUR_SCREEN_4_TITLE_670' => '귀하 소속팀의 프로젝트 영업을 관리합니다.',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '귀하의 영업팀 구성원들의 예측 파이프라인 분석을 위한 파레토 도표를 봅니다<br />프로젝트 영업을 가능, 최고 또는 최하로 구분하여 표시합니다<br />영업 현황이 귀하의 팀 쿼터에 얼마나 가까이 있는지 달성 가능성을 예측합니다.',
    'LBL_TOUR_SCREEN_5_TITLE_670' => '본인의 프로젝트 영업을 관리합니다.',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '귀하의 예측 분기를 선택합니다<br />예측을 리뷰하고 금액과 수주 가능성 (Win Probability)dmf  인라인(inline) 수정합니다.<br />예측 워크시트를 임시(Draft)로 저장하거나 보고자에 커밋(Commit)합니다.<br />과거 커밋된 내역을 봅니다.<br />예측을 보고자에게 커밋(Commit)하고 지난 커밋 내역을 봅니다.',
    'LBL_TOUR_SCREEN_6_TITLE_670' => '본인의 프로젝트 영업을 관리합니다.',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '귀하의 파이프라인 분석을 위한 파레토 도표를 봅니다.<br />영업단계 혹은 수주 가능성에 의한 파이프라인 시각화를 선택하십시오.<br />영업 현황이 귀하의 쿼터에 얼마나 가까이 있는지 달성 가능성을 예측합니다.',
    'LBL_TOUR_WELCOME' => 'SugarCRM에 오신걸 환영합니다.',
    'LBL_TOUR_WATCH' => '새로운 기능 확인하기',
    'LBL_TOUR_FEATURES_670' => '새로운 UX, 강화된 예측 모듈, 사용자와 레코드의 연결',
    'LBL_TOUR_VISIT' => '더 많은 정보를 확인하시려면 SugarCRM을 방문해 주십시오.',
    'LBL_TOUR_DONE' => '모두 마쳤습니다!',
    'LBL_TOUR_REFERENCE_1' => '더 자세한 정보를 확인하시려면',
    'LBL_TOUR_REFERENCE_2' => '고객지원 메뉴를 클릭하여 주십시오.',
    'LNK_TOUR_DOCUMENTATION' => '자료',
    'LBL_TOUR_CALENDAR_URL_1' => '캘린더의 일정을 아웃룩 혹은 익스체인지서버와 같은 3rd 파티 어플리케이션과 공유하십니까? 그렇다면 새로운 URL을 이용해주십시오. 새로운 URL은 더욱 보안된 개인키 정보를 가지고 있어 더욱 안전합니다.',
    'LBL_TOUR_CALENDAR_URL_2' => '캘린더 공유 URL 가져오기',
    'LBL_TOUR_CUBE' => '대시보드와 활동 흐름에 접근하기',
    'LBL_TOUR_NAV_BAR' => '네비게이션 메뉴의 모든 모듈에 액세스 후 액션을 실행합니다.',
    'LBL_TOUR_NOTIFICATIONS' => '알림보기를 클릭하십시오.',
    'LBL_TOUR_SEARCH' => '하나 이상의 모듈 선택후 검색합니다.',
    'LBL_TOUR_AVATAR' => '어플리케이션이나 로그아웃에 관한 상세설명 보기',
    'LBL_TOUR_ADD' => '신규 레코드 생성하기',
    'LBL_TOUR_LIST_INT_TOGGLE' => '클릭하여 닫거나 열 수 있습니다.',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => '활동이나 레코드 목록 보기를 선택합니다.',
    'LBL_TOUR_LIST_FILTER1' => '이 모듈 검색을 위한 필터바를 활성화합니다.',
    'LBL_TOUR_LIST_FILTER2' => '미리 정해진 필터를 선택하거나 새로 만들기를 합니다.',
    'LBL_TOUR_LIST_FILTER_SEARCH' => '이름에 근거한 검색을 위해 이곳에 입력합니다.',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => '레코드 편집이나 세부사항 미리보기를 위해 선택합니다.',
    'LBL_TOUR_RECORD_ACTIONS' => '레코드에 액셔을 실행합니다.',
    'LBL_TOUR_RECORD_SUBPANEL' => '헤더를 클릭하여 서브패널을 확장하고 붕괴하십시오',
    'LBL_TOUR_RECORD_INLINEEDIT' => '레코드명을 수정할 수 있습니다.',
    'LBL_TOUR_RECORD_STATUS' => '레코드의 레벨 상태를 이곳에서 검색합니다.',
    'LBL_TOUR_RECORD_SHOWMORE' => '레코드의 세부 데이터를 보려면 클릭하십시오.',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => '활동이나 관련된 레코드 보기를 선택합니다.',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => '각 필드를 인라인으로 편집하려면 클릭하십시오.',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => '대쉬릿 신규그룹 만들기',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => '대쉬릿 그룹명을 지정합니다.',
    'LBL_TOUR_RECORD_DASHLETCOG' => '대쉬릿을 삭제하거나 설정변경을 하려면 선택하십시오.',
    'LBL_TOUR_INTRO' =>'<h4>Sugar 시작</h4> 몇 가지 기능을 안내해 드리고 싶습니다. 둘러보려면 화면 하단에 있는 < 및 > 화살표를 사용하십시오.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">새로운 소식</a><p class="details">각 릴리즈의 주요 변경 사항을 알아보십시오.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Sugar 에 대해 자세히 알아보기</a><p class="details">e러닝, 라이브 및 가상 강의실 교육, 웹 세미나 및 비디오 사용 지침서로 구성된 강력한 라이브러리입니다.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">지원 받기</a><p class="details">도움이 필요하십니까?  문의 사항이나 Sugar 에 대한 제안이 있으십니까?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => '이 레코드의 세부사항 보기와 모든 관련된 데이터를 봅니다.',
    'LBL_TOUR_RECORD_INTRO' => '이 레코드의 세부사항보기와 모든 관련된 데이터를 봅니다.',
    'LBL_TOUR_FORECAST_INTRO' => '파이프라인과 예측을 관리합니다.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => '예측을 보려면 기간을 선택하십시오.',
    'LBL_TOUR_FORECASTS_COMMITS' => '이전 커밋을 보려면 클릭하십시오.',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => '데이터 인라인을 편집하려면 클릭하십시오.',
    'LBL_TOUR_FORECASTS_PROGRESS' => '쿼터 둘러보기',
    'LBL_TOUR_FORECASTS_CHART' => '예측 분배 둘러보기',
    'LBL_TOUR_TOUR' => '언제든지 둘러보기에 접근',
    'LBL_TOUR_TAGS_ADD' => '태그 필드를 클릭하여 태그를 추가 및 삭제하십시오',
    'LBL_TOUR_TAGS_DELETE' => '태그를 삭제하려면, 백스페이스를 이용하거나 각각의 태그에 있는 [X] 버튼을 클릭하십시오',
    'LBL_TOUR_RECORD_SAVE' => '일단 준비되면 저장을 클릭하십시오',


    'LBL_FUTURE' => '미래',
    'LBL_REQUIRED_FIELD' => '필수항목',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => '견적 라인아이템',
    'LBL_DISCOUNT_TOTAL' => '할인 합계',
    'LBL_DISCOUNT_PERCENT' => '% 퍼센트',
    'LBL_DISCOUNT_SELECT' => '할인이 백분율 또는 고정 금액인지 결정',
    'LBL_TAX' => '세금',
    'LBL_SHIPPING' => '물류/운송',
    'LBL_GRAND_TOTAL' => '최종 합계',
    'LBL_QUOTES_POPULATE_ADDRESS' => '계정 프로필에서 청구 주소 자동 채우기',
    'LBL_QLI_ADD_GROUP' => '그룹 추가하기',
    'LBL_QLI_COMMENT' => '의견',
    'LBL_SELECT_ACTION' => '액션 선택',
    'LBL_QLI_GROUP_NAME' => '그룹명',
    'LBL_GROUP_TOTAL' => '그룹 합계',
    'LBL_ITEM_NAME' => '라인 항목',
    'LBL_QLI_DELETE' => '이 라인 항목을 삭제하시겠습니까?',
    'LBL_QLI_COMMENT_DELETE' => '이 라인 항목 의견을 삭제하시겠습니까?',
    'LBL_QLI_GROUP_DELETE' => '{0} 그룹을 정말로 삭제 하시겠습니까? 모든 항목이 기본 그룹으로 이동됩니다.',
    'LBL_QLI_GROUP_EMPTY' => '견적 라인아이템 없음',
    // end of: Quotes related

    'LBL_OPTIONAL' => '선택가능',
    'LBL_RELATED_MODULE' => '관련',
    'LBL_RELATED_MODULE_PLURAL' => '관련',
    'LBL_CREATE_MODULE' => '새로 만들기',
    'LBL_EDIT' => '편집하기',
    'LBL_ASSOC' => '관련된',
    'LBL_ASSIGN' => '{{{this}}}선택',
    'LBL_EDIT_RELATED' => '{{{this}}}관련 편집하기',
    'LBL_CREATE_RELATED' => '{{{this}}}관련 생성하기',
    'LBL_ASSOC_EXISTING' => '기존{{{this}}}와 관련',
    'LBL_SEARCH_ALL' => '모든 검색 {{{this}}}',
    'LBL_SEARCH_ALL_RECORDS' => '모든 레코드를 검색 ...',
    'LBL_SEARCH_ALL_MODULES' => '모두 검색',
    'LBL_OK' => '예',
    'LBL_YES' => '예',
    'LBL_NO' => '아니요',
    'LBL_SHOW_NUMBERING' => '단계 번호 매기기 보기',
    'LBL_HIDE_NUMBERING' => '단계 번호 매기기 숨김',
    'LBL_CALL_BUTTON' => '전화',
    'LBL_SMS_BUTTON' => '문자',
    'LBL_EMAIL_BUTTON' => '이메일',
    'LBL_HONEYPOT' => '실제(Real) 사용자는 이곳에 입력하지 마십시오.',
    'LBL_LINK_BUTTON' => '링크',
    'LBL_UNLINK_BUTTON' => '제거',
    'LBL_MAP_BUTTON' => '지도',
    'LBL_FILE_BUTTON' => '파일',
    'LBL_URL_BUTTON' => '웹',
    'LBL_WARNING' => '경고:',
    'LBL_CONFIRM' => '확인',
    'LBL_CONFIRMATION_POPUP' => '확인 팝업',
    'LBL_NO_ACCESS' => '접속할수 없습니다.',
    'LBL_NO_ACCESS_LOWER' => '레코드에접근 불가한 사용자',
    'LBL_NO_FIELD_ACCESS' => '접근 금지',
    'LBL_NO_LICENSE_ACCESS' => '라이센스 필요',
    'LBL_VALUE_ERASED' => '값 삭제',
    'LBL_VALUE_ERASED_TOOLTIP' => '이 정보는 데이터 프라이버시 요청을 통해 삭제되었습니다.',
    'LBL_CREATE_RELATED_RECORD' => '관련 기록 생성하기',
    'LBL_ASSOC_RELATED_RECORD' => '기존 기록과 연결됩니다.',
    'LBL_CHOOSE_LINK' => '연결 형식을 선택하십시오',
    'LBL_CHOOSE_PARENT_TYPE' => '상위 유형을 선택하십시오.',
    'LBL_HOME' => '홈',
    'ERR_NO_DOCS' => '가능한 문서가 없습니다.',
    'ERR_NO_RECORDS_SELECTED' => '선택하신 기록이 없습니다.',
    'LBL_DELETING' => '삭제중입니다.',
    'LBL_UNLINKING' => '제거중입니다.',
    'LBL_UNLINKED' => '제거되었습니다.',
    'LBL_LEGAL' => '합법',
    'LBL_UPCOMING' => '내 다가오는 일정목록',
    'LBL_RECENTLY_UPDATED' => '최신 업데이트',
    'LBL_NOTES_SUBPANEL_TITLE' => '노트:',
    'LBL_MEETINGS_SUBPANEL_TITLE' => '회의',
    'LBL_TASKS_SUBPANEL_TITLE' => '작업',
    'LBL_CALLS_SUBPANEL_TITLE' => '전화',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => '거래처',
    'LBL_CONTACTS_SUBPANEL_TITLE' => '연락처',
    'LBL_EMAILS_SUBPANEL_TITLE' => '이메일',
    'LBL_SHIFTS_SUBPANEL_TITLE' => '교대',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => '견적 라인아이템',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => '교대 예외',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => '문서',
    'LBL_ESCALATIONS' => '에스컬레이션',
    'LBL_ESCALATED' => '에스컬레이션 완료',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => '에스컬레이션',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => '기타 관련 에스컬레이션',
    'LBL_ESCALATIONS' => '에스컬레이션',
    'LNK_SETTINGS' => '설정',
    'LBL_MOBILE_SUPPORT' => '지원',
    'LBL_MOBILE_SHOW_MORE' => '더 보기',
    'LBL_MOBILE_SHOW_MORE_TOP' => '더 보기',
    'LBL_MOBILE_NO_RECORDS' => '발견된 자료가 없습니다 -',
    'LBL_MOBILE_SEARCH_TEAMS' => '검색 팀 ...',
    'LBL_MOBILE_SELECT_TEAMS' => '팀 선택',
    'LBL_MOBILE_WAIT' => '잠시만 기다려주십시오.',
    'LBL_MOBILE_LOGING_OUT' => '로그아웃중입니다.',
    'LBL_MOBILE_RELOGIN_BUTTON' => '재로그인',
    'LBL_MOBILE_META_SYNC_FAILED' => '서버와 일치화(Sync)가 불가능합니다. 재시도 하시겠습니까?',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => '서버와 일치화(Sync)가 불가능합니다. 재시도 하시겠습니까?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => '개인정보보호 약관',
    'LBL_MOBILE_APP_VERSION' => '어플리케이션 버전',
    'LBL_MOBILE_SERVER_VERSION' => '서버 버전',
    'LBL_MOBILE_SERVER_URL' => '서버 URL',
    'LBL_MOBILE_PTR_PULL' => '아래로 내려 새로고치기',
    'LBL_MOBILE_PTR_RELEASE' => '릴리즈하여 새로고치기',
    'LBL_MOBILE_EDIT_REL' => '관계 편집하기',
    'LBL_MOBILE_DESKTOP' => '데스크탑 버전',
    'LBL_MOBILE_DELETE_CONFIRM' => '이 레코드를 삭제하시겠습니까?',
    'LBL_MOBILE_UNLINK_CONFIRM' => '이 레코드를 삭제하시겠습니까?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => '최근 통화를 기록하시겠습니까?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => '수신자를 선택하십시오.',
    'LBL_MOBILE_CHOOSE_PHONE' => '전화번호를 선택하십시오.',
    'LBL_MOBILE_CHOOSE_URL' => 'URL을 선택하십시오',
    'LBL_MOBILE_CHOOSE_DOC' => '문서를 선택하십시오',
    'LBL_MOBILE_CHOOSE_LOCATION' => '위치를 선택하십시오',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => '가능한 액션이 없습니다.',
    'LBL_MOBILE_FEEDBACK' => '피드백',
    'LBL_MOBILE_DOC' => '문서',
    'LBL_MOBILE_DOWNLOAD_STARTED' => '다운로드 시작했습니다.',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => '다운로드가 완료되었습니다.',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => '파일을 업로드중입니다.',
    'LBL_MOBILE_UPLOAD_SUCCESS' => '파일이 성공적으로 업로드 되었습니다.',
    'LBL_MOBILE_PROCESSING_IMAGE' => '이미지를 준비중입니다.',
    'LBL_CLOSE_SAVE_BUTTON' => '닫기 작업 및 저장',
    'LBL_LATER' => '추후처리',
    'LBL_USE_HTTPS' => '보안 연결을 사용하십시오',
    'LBL_LOADING_FILES' => '아직 문서 목록을 로드 중입니다. 나중에 다시 시도해 주십시오',
    'LBL_NEW_WEB_VERSION' => 'SugarCRM의 새 모바일 버전을 사용할 수 있습니다. 업데이트 하시겠습니까?',
    'LBL_SET_FONTSIZE' => '폰트 크기',
    'LBL_FONTSIZE_TINY' => '작은',
    'LBL_FONTSIZE_SMALL' => '작은',
    'LBL_FONTSIZE_NORMAL' => '보통 (기본값)',
    'LBL_FONTSIZE_LARGE' => '큰',
    'LBL_FONTSIZE_LARGER' => '큰',
    'LBL_FONTSIZE_HUGE' => '거대한',
    'LBL_FONTSIZE_EXTRA_HUGE' => '추가 거대한',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "다운로드 실패 {{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => '더보기',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '축소보기 ...',
    'LBL_OFFLINE_MODE' => '오프라인 모드',
    'LBL_OFFLINE_DELETED' => '기록은 찾을 수 없습니다. 아마도 삭제되었습니다.',
    'LBL_OFFLINE_DELETED_RELATED' => '관련 기록을 찾을 수 없습니다. 아마 삭제되었거나 연결이 해제되었습니다.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => '지정하고, 즐겨 찾기에 추가하고, 오프라인 액세스에 대한 기록을 열어 다운로드하려면 완료하는 데 약간의 시간이 걸릴 수 있습니다. 빠른 연결을 권장합니다. 계속 진행하시겠습니까?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => '지정하고, 즐겨 찾기에 등록하고, 그 다음 기록은 오프라인 액세스를 위해 지금 다운로드하시겠습니까? 이 작업은 약간의 시간이 걸릴 수 있으므로 빠른 연결을 권장합니다. 메인 메뉴> 오프라인에서 나중에 다운로드할 수 있습니다.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => '기록이 성공적으로 다운로드되었습니다',
    'LBL_OFFLINE_PREFETCH_ACTION' => '기록을 다운로드 중...',
    'LBL_OFFLINE_PREFETCH_ERROR' => '기록을 다운로드하는 동안 오류발생',
    'LBL_OFFLINE_PREFETCHING' => '기록 로딩 중…',
    'LBL_OFFLINE_PREFETCHING_MODULE' => '{{module}} {{progressValue}} 로딩 중...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => '남은 시간은 약 {{estimatedTime}}입니다 ...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => '로드 {{module}} 완료',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => '저장소 정리 중…',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => '정리 완료',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => '이 변경을 롤백하시겠습니까?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => '롤백 완료',
    'LBL_OFFLINE_ROLLBACK_FAILED' => '롤백 실패',
    'LBL_OFFLINE_CLEAR_DB' => '저장소 삭제…',
    'LBL_OFFLINE_COMPACT_DB' => '저장소 압축…',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => '이 작업은 한 동안 액세스하지 않은 기록을 삭제합니다. 계속하시겠습니까?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => '로컬 저장소에서 모든 기록을 삭제하시겠습니까?',
    'LNK_OFFLINE_SETTINGS' => '오프라인',
    'LBL_OFFLINE_SETTINGS' => '디버그 설정',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => '동기화 보류중인 변경 사항이 없습니다.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => '변경 사항은 동기화 대기 중입니다.',
    'LBL_OFFLINE_STATUS_ONLINE' => '장치가 온라인 상태입니다.',
    'LBL_OFFLINE_STATUS_OFFLINE' => '장치가 오프라인 상태입니다.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => '서버에 연결할 수 없습니다.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => '마지막 동기화 시도가 실패했습니다. 트랜잭션 로그를 확인하십시오.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => '진행중인 동기화 ...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => '트랜잭션이 동기화됩니다.',
    'LBL_OFFLINE_ENABLE_PROMPT' => '오프라인 지원을 설정하시겠습니까?',
    'LBL_OFFLINE_DISABLE_PROMPT' => '오프라인 지원 기능을 해제하시겠습니까? 동기화중인 모든 변경 내용이 손실됩니다.',
    'LBL_OFFLINE_ENABLED' => '사용 오프라인 모드',
    'LBL_OFFLINE_DISABLED' => '오프라인 모드 비활성화',
    'LBL_OFFLINE_STATS' => '저장소 통계',
    'LBL_OFFLINE_SERVER_FETCH' => '서버에서 가져오는 중 ...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => '누군가가 서버에서 같은 기록을 편집했습니다. 변경 내용을 자동으로 병합을 확인하거나 취소하려면 거부합니다.',
    'LBL_OFFLINE_LAST_SYNC_TS' => '마지막 동기화 시도 => {{ts}}',
    'LBL_ACTION_UPDATE' => '목표의 필드 업데이트',
    'LBL_ACTION_CREATE' => '만들기',
    'LBL_ACTION_DELETE' => '삭제하기',
    'LBL_ACTION_LINK' => '링크',
    'LBL_ACTION_UNLINK' => '링크 해제',
    'LBL_ACTION_FAVORITE' => '즐겨찾기',
    'LBL_ACTION_FOLLOW' => '팔로우',
    'LBL_ACTION_CREATE_EXPLANATION' => '{{module}} &#39;{{name}}&#39; 만들기',
    'LBL_ACTION_UPDATE_EXPLANATION' => '{{module}} &#39;{{name}}&#39; 업데이트하기',
    'LBL_ACTION_DELETE_EXPLANATION' => '{{module}} &#39;{{name}}&#39; 삭제하기',
    'LBL_ACTION_LINK_EXPLANATION' => '{{module}} &#39;{{name}}&#39;를 {{relatedModule}} &#39;{{relatedName}}&#39; 링크하기',
    'LBL_ACTION_UNLINK_EXPLANATION' => '{{module}} &#39;{{name}}&#39;를 {{relatedModule}} &#39;{{relatedName}}&#39;에서 링크 해제하기',
    'LBL_ACTION_FOLLOW_EXPLANATION' => '{{module}} => &#39;{{name}}&#39;팔로우하기',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => '{{module}} => &#39;{{name}}&#39; 팔로우하지 않기',
    'LBL_ACTION_FAVORITE_EXPLANATION' => '즐겨찾기 {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => '비 즐겨찾기 {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => '{{module}} &#39;{{name}}&#39; 만들기는 {{relatedModule}} &#39;{{relatedName}}&#39;와 관련됩니다',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => '기본',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => '수신거부',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => '수신허용',
    'LBL_EMAIL_ACTION_SET_VALID' => '유효',
    'LBL_EMAIL_ACTION_SET_INVALID' => '유효하지 않음',
    'LBL_ROLLBACK_BUTTON' => '롤백',
    'LBL_TX_LOG' => '트랜잭션 로그',
    'LBL_TX_LOG_DETAIL' => '트랜잭션 세부 사항',
    'LBL_RECORD_DELETED' => '(기록 삭제)',
    'LBL_NOT_AVAILABLE' => 'N/A',
    'LBL_FILE_SIZE' => '파일 크기',
    'LBL_FILE_SIZE_UNITS_B' => '바이트',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => '항목 선택',
    'LBL_OFFLINE_DB_SIZE' => '데이터베이스 크기',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => '모듈 당 기록',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => '기록 총수',
    'LBL_RECORD_NOT_FOUND' => '기록을 찾을 수 없습니다.',
    'LBL_RELATED_RECORD_NOT_FOUND' => '관련 기록을 찾을 수 없습니다.',
    'LBL_NOT_AUTHORIZED' => '당신은이 기록을 볼 수있는 권한이 없습니다.',
    'LBL_MOBILE_PROCESSING_FILE' => '파일을 준비 중 ...',
    'LNK_THIRD_PARTY_SOFTWARE' => '타사 소프트웨어',
    'LNK_TERMS_OF_USE' => '이용 약관',
    'LNK_PRIVACY_POLICY' => '개인 정보 보호 정책',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => '단일 사인 온 (SSO)',
    'LBL_RECENTS' => '최근 검색',
    'LBL_SHOWING_CACHED_DATA' => '서버에 도달할 수 없었습니다. 최근 이용 가능한 데이터 표시 ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => '{{moduleSingular}} 닫고 저장',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => '특정한 대시보드',
    'LBL_MOBILE_SPECIFIC_MODULE' => '특정한 모듈',
    'LBL_MOBILE_DEFAULT_VIEW' => '시작 화면',
    'LBL_MOBILE_DEFAULT_MODULE' => '선택된 모듈',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => '선택된 대시보드',
    'LBL_MOBILE_DEFAULT_DASHLET' => '선택된 대시렛',
    'LBL_ALL_DASHLETS' => '전체 대시렛',
    'LBL_MOBILE_GLOBAL_SEARCH' => '세계전체 검색',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => '@ 입력하여 사용자를 언급하십시오. # 입력하여 레코드를 참조하십시오.',
    'LBL_MOBILE_NEW_COMMENT' => '새로운 코멘트',
    'LBL_RECENTLY_VIEWED' => '최근에 본 항목',
    'LBL_FILE_STORED_LOCALLY' => '파일이 로컬 저장소에 저장되며 장치가 온라인에 연결되면 동기화가 이루어집니다.',
    'LBL_IDM_USER_PROFILE_READONLY' => '편집할 수 없는 특정 값을 변경하고 싶으신 경우, 관리자에게 연락해 변경 사항을 남겨주세요.',
    'LBL_ACTIVITY_POST' => '{{{link}}}의 {{{value}}}',
    'LBL_COMMENTLOG_EMPTY' => '의견 없음',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => '다음 {{{commentsLeft}}} 의견 보기',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => '접힘',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => '의견 생성 확인',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => '의견 로그는 비워둘 수 없습니다',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'PDF {{{pdfTemplateName}}} 다운로드',

    'ERR_SYNC_FAILED' => '서버와 동일화가 불가능합니다.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => '접속이 불가능합니다.',
    'ERR_MOBILE_INVALID_CREDS' => '유효하지 않은 사용자명 또는 비밀번호',
    'ERR_MOBILE_SESSION_EXPIRED' => '귀하의 세션이 만료되었습니다.',
    'ERR_MOBILE_NOT_FOUND' => '자료가 발견되지 않았습니다.',
    'ERR_MOBILE_TIMEOUT' => '서버가 응답하지 않습니다.',
    'ERR_MOBILE_CONNECTION_FAILED' => '서버에 연결할 수 없습니다.',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => '인터넷 연결이 불가능합니다.',
    'ERR_MOBILE_INTERNAL' => '내부 오류 <코드>. 나중에 다시 시도해주십시오.',
    'ERR_MOBILE_VALIDATION' => '기록이 유효하지 않습니다.',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => '호환되지 않는 서버 플레이버:<플레이버>. 지원되는 플레이버<지원되는 플레이버>.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => '호환되지 않는 서버 버전 : <버전>. 최소 요구되는 버전:<최소 버전>',
    'ERR_MOBILE_EMAIL' => '오류. 유효하지 않은 이메일 주소입니다.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => '이 문서 형식은 지원되지 않습니다.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => '인증이 실패했습니다.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => '요청된 자료가 발견되지 않았습니다.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => '내부 서버 오류',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => '금지되어 있습니다.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => '서비스가 불가능합니다.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => '예상치 못한 오류가 발생했습니다.',
    'ERR_MOBILE_UPLOAD' => '파일 업로드중 오류',
    'ERR_MOBILE_FILE_PROCESSING' => '파일 처리 오류',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => '장치 저장소가 유효하지 않습니다.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => '귀하의 어플리케이션의 버전이 연결중인 SugarCRM과 호환되지 않습니다. 어플리케이션 스토어에서 새로운 버전을 다운로드 받으시겠습니까?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => '서버 구성 변경 및 재로드가 필요합니다. 계속하시겠습니까?',
    'ERR_MOBILE_CONFLICT' => '누군가가 서버에서 같은 기록을 편집했습니다. 변경 내용을 자동으로 병합을 확인하거나 취소하려면 거부합니다.',
    'ERR_MOBILE_METADATA_CHANGED' => '서버 구성이 변경되었습니다.',
    'ERR_MOBILE_FILE_READ' => '파일을 읽을 수 없습니다',
    'ERR_MOBILE_FILE_NOT_FOUND' => '파일을 찾을 수 없습니다',
    'ERR_MOBILE_FILE_NOT_READABLE' => '파일을 읽을 수 없습니다',
    'ERR_MOBILE_FILE_ABORTED' => '읽기 작업이 중단되었습니다',
    'ERR_MOBILE_FILE_SECURITY' => '파일이 잠겨 있습니다',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => '모바일 버전은 이 기능을 지원하지 않습니다. 데스크탑 버전을 여시겠습니까?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => '파일이 너무 큽니다. 최대 허용 크기는 {{size}}',
    'ERR_OFFLINE' => '오프라인 오류',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => '로컬 저장소를 열 수 없습니다',
    'ERR_OFFLINE_STORAGE_CREATE' => '로컬 저장소를 만들 수 없습니다',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => '로컬 저장소를 만들 수 없습니다 : 공간이 부족합니다.',
    'ERR_OFFLINE_OUT_OF_SPACE' => '로컬 저장 공간이 부족합니다.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => '데이터베이스 정리 실패',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => '오프라인 스토리지를 위한 공간이 부족합니다. 스토리지 정리를 권장합니다. 몇 분 정도 걸릴 수 있습니다.',
    'ERR_OFFLINE_PREFETCH_FAILED' => '서버에서 프리 페치 기록 실패',
    'ERR_OFFLINE_SYNC_ERROR' => '동기화 오류',
    'ERR_OFFLINE_SYNC_CONFLICT' => '동기화 충돌',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => '서버 시간을 가져오는 데 실패했습니다',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => '오프라인 모드 활성화에 실패했습니다. 서버에 도달할 수 없습니다.',
    'LBL_EXPORT_CSV' => 'CSV 내보내기',
    'LBL_ERR_EXPORTING_CSV' => '내보내기 실패',
    'LBL_ERR_EXPORT_ALL' => '선택한 보고서에서 데이터를 가져오지 못했습니다. 다시 시도하십시오.',
    'LBL_LIST_SETTINGS_RESTORE' => '기본값 복원',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => '기본값을 복원할까요?',
    'LBL_LIST_SETTINGS_TITLE' => '목록 보기 편집기',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => '사용가능한 필드',
    'LBL_LIST_SETTINGS_REMOVE' => '제거',
    'LBL_LIST_SETTINGS_TEXT' => '필드를 목록 보기 편집기에 드래그하고 재구성하여 {{moduleName}} 목록 보기를 설정하십시오.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => '필드 최소 하나가 레이아웃에 추가되어야 합니다.',
    'LBL_LIST_SETTINGS_EMPTY' => '사용가능한 필드 없음',
    'LBL_LIST_SETTINGS_NO_MATCHING' => '일치하는 필드 찾을 수 없음',
    'LBL_LIST_FILTER' => '필드 검색',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => '이메일 고객',
    'LBL_DEFAULT_SYSTEM_CLIENT' => '외부 이메일 고객',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar 이메일 고객',
    'LBL_OFFLINE_CAPABILITIES' => '오프라인 기능 켜기',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => '거래 삭제 실패.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => '거래 삭제 완료.',
    'LBL_SECURE_MODE' => '강화 보안 모드',
    'LBL_SECURE_MODE_ANDROID_TEXT' => '앱이 백그라운드에 있을 때 Sugar Mobile의 콘텐츠를 숨기고 언제든지 앱의 스크린샷을 찍는 것을 방지하려면 이 설정을 활성화하십시오.',
    'LBL_SECURE_MODE_IOS_TEXT' => '앱이 백그라운드에 있을 때 Sugar Mobile의 콘텐츠를 숨기려면 이 설정을 활성화하십시오.',
    'LBL_ALWAYS_OFFLINE_MODE' => '항상 오프라인 모드',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => '항상 오프라인 모드에서 작업 중입니다. 다시 연결하시겠습니까?',
    'LBL_RECONNECT' => '다시 연결',
    'LBL_STAY_OFFLINE' => '오프라인 유지',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => '현재 접속하려는 모듈은 Sugar Mobile에서 이용할 수 없습니다.',
    'LBL_MOBILE_RELEASE_NOTE' => '{{platform}}용 Sugar Mobile 릴리스 노트',
    'LBL_MOBILE_USER_GUIDE' => '{{platform}}용 Sugar Mobile 사용자 가이드',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => '이 단어를 포함',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => '이 단어 제외',
    'LBL_NOTIFICATIONS_CHANNEL' => '업데이트',
    'LBL_APPLY_BUTTON_LABEL' => '적용',
    'LBL_ACTION_CREATE_FAILURE' => "기록 저장 실패:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "기록 업데이트 실패:\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => '서버에서 필드 계산을 해결하지 못했습니다.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => '다음 필드 유효하지 않음: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>성공.</b> {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}"</a> 만들기에 성공했습니다.',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>성공.</b> 레코드를 업데이트했습니다',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => '서버에서 이메일 데이터를 가져오지 못했습니다.',
    'LBL_ASSIGN_SUCCESS' => '<b>성공.</b> 레코드가 {{{userName}}}에게 할당되었습니다.',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => '이 이메일을 초안으로 저장하시겠습니까?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => '초안으로 저장',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => '이메일 삭제',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => '초안을 저장하지 않으면 이 이메일은 삭제됩니다.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => '서명 선택',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => '이메일 템플릿 선택',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => '템플릿은 이 이메일의 모든 내용을 덮어씁니다. 이 템플릿을 사용하고 내용을 덮어씁니까?',
    'LBL_MOBILE_EMAIL_COMPOSE' => '이메일 작성',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => '이메일에 관련(Related To) 레코드 값을 사용하여 교체 가능한 변수가 있습니다. 전송 전 관련 필드가 올바르게 설정되어 있는지 확인하십시오.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => '발신 이메일 계정을 찾을 수 없습니다. Sugar 관리자에게 문의하십시오.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' 및 {{{count}}}개',
    'LBL_RECEPIENTS_EMAIL_ADD' => '이메일 추가',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => '연락처 이름 또는 이메일을 입력하세요',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}}(새 이메일)',
    'LBL_TEMPLATE_HAS_VARIABLES' => '변수',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => '이메일 템플릿',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => '캠페인 템플릿',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => '작업흐름 템플릿',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => '시스템 템플릿',
    'LBL_FILTER_EDIT' => '필터 편집',
    'LBL_FILTER_MY_FILTER' => '내 필터',
    'LBL_FILTER_MY_FILTER_BY' => '내 필터: {{{filters}}}',
    'LBL_FILTER_SAVE' => '필터 저장',
    'LBL_SELECT_PARAM' => '선택',
    'LBL_SELECT_MODULES' => '모듈 선택기',
    'LBL_SELECT_ADDITIONAL_PARAMS' => '추가 매개변수 선택',
    'LBL_FILTER_TEMPORARY' => '임시 필터',
    'LBL_ERROR_FILE_UPLOAD' => '{{{fieldLabel}}} 파일 "{{{fileName}}}" 업로드 실패. {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">실패한 레코드 보기</a>',
    'LBL_FILE_UPLOAD_ONE' => '파일 저장 중...',
    'LBL_FILE_UPLOAD_MANY' => '{{{index}}}/{{{total}}} 파일 저장 중...',
    'LNK_NOTIFICATIONS_SETTINGS' => '알림 설정',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => '푸시 알림 관리',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "장치 알림 설정에서 알림 표시 방식을 제어합니다.",
    'LBL_NOTIFICATION_ASSIGMENTS' => '배정',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => '레코드가 배정되면 알림을 받습니다.',
    'LBL_NOTIFICATION_MENTIONS' => '멘션',
    'LBL_NOTIFICATION_MENTIONS_DSC' => '의견 로그 항목에서 멘션되면 알림을 받습니다.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => '관리자가 의견 로그 필드를 이 레이아웃에 추가하지 않았습니다. Sugar 관리자에게 문의하십시오.',
    'ERR_NO_PERMISSION_TITLE' => '접속을 허용하십시오',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}}에서 사진을 첨부하려면 카메라 접근 권한이 필요합니다. 시스템 설정에서 카메라 접근을 허용하십시오.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => '설정',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => '지속',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => '남은 시간',
    'LBL_LIST_SUPPORT_EXPIRES' => '만료',
    'LBL_CASCADE_RLI_EDIT' => '열린 수익 라인 항목 업데이트',
    'LBL_MOBILE_CALENDAR' => '캘린더',
    'LBL_MOBILE_CALENDAR_SETTINGS' => '캘린더 설정',
    'LBL_MOBILE_CALENDAR_WEEK_START' => '주 시작일',
    'LBL_MOBILE_CALENDAR_MODULES' => '표시할 이벤트',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}시간:{{{minutes}}}분',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}}시간',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}}분',
    'LBL_MOBILE_CALENDAR_TODAY' => '오늘',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => '{{{moduleName}}} 추가',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => '활동 일정 관리',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => '이벤트 유형 최소 하나를 활성화하십시오.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => '종일',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => '캘린더를 불러오지 못했습니다.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => '이 작업은 Sugar Mobile에서 할 수 없습니다. 데스크탑 애플리케이션을 여시겠습니까?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => '템플릿 선택',
    'LBL_DOC_MERGES_ACTION_MERGE' => '병합',
    'LBL_ERROR_IMAGE_NO_EXIF' => '오류: HEIC 파일에 EXIF 데이터 누락',
    'LBL_ERROR_IMAGE_TOO_BIG' => '오류: 이미지 해상도 너무 높음',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => '오류: 이미지 처리 불가',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => '오류: 이미지를 캔버스에 렌더링하지 못함',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => '오류: 파일을 이미지로 불러오지 못함',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1개 항목 선택됨',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}}개 항목 선택됨',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => '모두 선택',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => '이 보기에서 레코드 {{{count}}}개를 선택했습니다. 모든 레코드를 선택하겠습니까?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => '레코드 {{{count}}}개 선택',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => '선택하신 레코드를 정말 삭제하시겠습니까?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => '삭제 중… {{{count}}}/{{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => '선택한 레코드에서 유효한 이메일을 찾을 수 없습니다.',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => '외관',
    'LBL_MOBILE_APP_THEME_SYSTEM' => '시스템 설정 사용',
    'LBL_MOBILE_APP_THEME_LIGHT' => '밝음',
    'LBL_MOBILE_APP_THEME_DARK' => '어두움',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => '신규 파일 이름',
    'LBL_ATTACHMENT_RENAME_MSG' => '파일 이름 변경',
    // Filters related
    'LBL_CREATED_BY_ME' => '내가 생성함',
    'LBL_OPERATOR_ONE_OF' => '다음 중 하나',
    'LBL_OPERATOR_NOT_ONE_OF' => '다음 중 하나가 아님',
    'LBL_OPERATOR_CONTAINS' => '중의 하나입니다',
    'LBL_OPERATOR_CONTAINS_WORD' => '포함',
    'LBL_OPERATOR_NOT_CONTAINS' => '중의 하나가 아닙니다',
    'LBL_OPERATOR_EMPTY' => '비어 있음',
    'LBL_OPERATOR_NOT_EMPTY' => '비어 있지 않음',
    'LBL_OPERATOR_MATCHES' => '정확히 일치합니다',
    'LBL_OPERATOR_STARTS_WITH' => '다음으로 시작',
    'LBL_OPERATOR_EQUALS' => '동일합니다',
    'LBL_OPERATOR_NOT_EQUALS' => '동일하지 않습니다',
    'LBL_OPERATOR_GREATER_THAN' => '다음보다 큽니다',
    'LBL_OPERATOR_LESS_THAN' => '다음보다 적습니다.',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => '보다 크거나 동일합니다',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => '보다 적거나 동일합니다',
    'LBL_OPERATOR_BETWEEN' => '사이에 있습니다',
    'LBL_OPERATOR_BEFORE' => '이전',
    'LBL_OPERATOR_AFTER' => '이후',
    'LBL_OPERATOR_YESTERDAY' => '어제',
    'LBL_OPERATOR_TODAY' => '오늘',
    'LBL_OPERATOR_TOMORROW' => '내일',
    'LBL_OPERATOR_LAST_7_DAYS' => '최근 7일',
    'LBL_OPERATOR_NEXT_7_DAYS' => '향후 7일',
    'LBL_OPERATOR_LAST_30_DAYS' => '최근 30일',
    'LBL_OPERATOR_NEXT_30_DAYS' => '향후 30일',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => '__일 전',
    'LBL_OPERATOR_LAST_X_DAYS' => '지난 __일',
    'LBL_OPERATOR_NEXT_X_DAYS' => '다음 __일',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => '향후 __일 이상',
    'LBL_OPERATOR_LAST_MONTH' => '지난 달',
    'LBL_OPERATOR_THIS_MONTH' => '이번 달',
    'LBL_OPERATOR_NEXT_MONTH' => '다음 달',
    'LBL_OPERATOR_LAST_YEAR' => '작년',
    'LBL_OPERATOR_THIS_YEAR' => '금년',
    'LBL_OPERATOR_NEXT_YEAR' => '내년',
    'LBL_OPERATOR_IS' => '는',
    'LBL_OPERATOR_IS_NOT' => '가 아닙니다',
    'LBL_OPERATOR_AFTER_TODAY' => '오늘 이후',
    'LBL_OPERATOR_BEFORE_TODAY' => '오늘 이전',
    'LBL_ERROR_FILTER_EMPTY' => '필터 기준을 추가하십시오.',
    'LBL_ADD_FILTER' => '기준 추가',
    'LBL_FILTER_NAME' => '이름 필터',
    'LBL_FILTER_FIELD' => '필드',
    'LBL_FILTER_OPERATOR' => '연산자',
    'LBL_FILTER_VALUE' => '값',
    'LBL_FILTER_SYNC_TO_SERVER' => '데스크톱 앱에 저장',
    'LBL_FILTER_LOCAL' => '로컬 필터',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => '새로운 기능을 소개합니다.',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => '메인 메뉴 찾기',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => '모든 창(View)에서 사용 가능한 액션',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => '레코드 글로벌 검색',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => '내 즐겨찾기 레코드만 검색합니다.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => '내 레코드만 검색합니다.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => '즐겨찾기로 표시합니다.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => '오늘 내 활동',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => '최근 수정된 레코드',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => '레코드에서 사용 가능한 액션',
    'LBL_MOBILE_TUTORIAL_HOME_END' => '새로운 기능을 즐기십시오.',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => '플러스 메뉴입니다.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => '플러스 메뉴를 닫습니다.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => '실행할 액션을 선택하십시오.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => '홈 메뉴입니다.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => '홈 메뉴를 닫습니다.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => '특정 모듈보기',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => '어플리케이션 맞춤화',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => '웹브라우저에서 SugarCRM을 엽니다.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => '귀하의 프로필을 보십시오.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => '상세정보 페이지입니다.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => '레코드의 가장 중요한 정보',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => '추가 정보를 보거나 레코드를 편집합니다.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => '가능한 액션목록',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => '이전 페이지로 돌아갑니다.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => '언제든지 액세스 투어.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => '뒤로 이동합니다.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => '관련 기록을 열기 위해 클릭하십시오.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => '기록 유지/삭제하기.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => '상세 정보를 확장하기 위해 클릭하십시오.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => '메인 메뉴보기.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => '메인 메뉴는 화면의 왼쪽에 열립니다.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => '상세보기',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => '상세보기 화면의 오른쪽에 열립니다.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => '이 메뉴의 주요 구성 요소를 둘러보기 위해 아래 화살표를 사용하십시오.',

    'LBL_COMMENT_ADD' => '의견 추가하기',
    'LBL_REQUIRED' => '필수항목',
    'LBL_MORE_BUTTON' => '더보기',
    'LBL_NO_OPTIONS' => '옵션 없음',
    'LBL_TRY_AGAIN' => '다시 시도',
    'LBL_NEW_RECORDS' => '최근 생성 항목',
    'LBL_ASSIGNED_TO_ME' => '내 {{module}}',
    'LBL_LISTVIEW_FILTER_ALL' => '모든 {{{module}}}',
    'LBL_UNFAVORITE' => '즐겨찾기 해제',
    'LBL_ACTIVITY_CREATE' => '생성된 {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => '{{{record}}} {{{module}}}에 {{{changes}}} 업데이트 됨',
    'LBL_ACTIVITY_LINK' => '{{{record}}} {{{module}}}에 {{{relatedRecord}}} 연결 됨',
    'LBL_ACTIVITY_UNLINK' => '{{{record}}} {{{module}}}에서 {{{relatedRecord}}} 링크 해제됨',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{parentModule}}에 대한 {{relationship}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => '관련 기록 다운로드...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => '대시 보드 구성이 변경되었습니다. 다시 로드하시겠습니까?',
    'LBL_RECORDS' => '기록',
    'LBL_DASHBOARDS' => '대시보드',
    'LBL_TEMPLATES' => '템플릿',
    'LBL_NON_TEMPLATES' => '비템플릿',
    'LBL_IS_TEMPLATE' => '템플릿여부',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => '선택 항목에는 대량 업데이트가 불가능한 대시보드 템플릿이 포함되어 있습니다. 계속하려면 템플릿 선택을 취소하세요.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => '선택 항목에는 대량 삭제가 불가능한 대시보드 템플릿이 포함되어 있습니다. 계속하려면 템플릿 선택을 취소하세요.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => '검색 {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => '메인 메뉴',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => '간단히 새로운 기록 생성',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => '다른 옵션을 보려면 스와이프',
    'LBL_DETAILS' => '세부사항',
    'LBL_DETAIL_RELATED' => '관련',
    'LBL_CREATE_RELATED_MODULE_WARN' => '이 {{module}}에는 {{relatedModule}}이 (가) 필요합니다. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>{{relatedModule}} 레코드를 만들기</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => '기록 편집',
    'LBL_OFFLINE_MENU_SETTINGS' => '오프라인 설정',
    'LBL_OFFLINE_DEBUG_SETTINGS' => '디버그 설정',
    'LBL_OFFLINE_TOTAL_RECORDS' => '최종 기록',
    'LBL_OFFLINE_LAST_DOWNLOAD' => '마지막 다운로드',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => '파일을 다운로드할 수 없습니다.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => '서버에서 대시보드 불러오기 실패',
    'ERR_FILTERS_FETCHING' => '필터를 가져올 수 없습니다',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => '로컬 저장소를 암호화할 수 없습니다',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => '오프라인 데이터 암호화 중. 몇 분 걸릴 것입니다.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => '오프라인 데이터 암호화가 완료되었습니다.',
    'ERR_ACCESS_SPECIFIC_MODULE' => '{{{module}}} 모듈에 접근할 수 없습니다.',
    'LBL_SKIP' => '생략',
    'LBL_CONTINUE' => '계속합니다.',
    'LBL_ENABLE' => '작동',
    'LBL_MOBILE_TRIAL_UNTIL' => '트라이얼 기한',
    'LBL_MOBILE_SDK_VERSION' => 'SDK 버전',
    'LBL_LOG_LEVEL' => '접속 단계',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => '로그인 설정이 다시 구성되었습니다.',
    'LBL_TRIAL_PERIOD_EXPIRED' => '트라이얼 기간이 만료되었습니다.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => '서버가 보안 연결을 지원하지 않습니다. 보안 연결을 해제하십시오.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => '서버는 보안 연결을 지원합니다. 보안 연결을 켜십시오.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => '연결이 안전하지 않습니다. 관리자에게 문의하십시오.',
    'LBL_LOGIN_SETTINGS_HEADER' => '로그인 설정',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => '{{{brandName}}} 인스턴스 설정',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => '앱이 작동하려면 {{{brandName}} 인스턴스의 URL을 입력해야 합니다. 인스턴스 URL이 없으면 관리자에게 문의하십시오.',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => '터치 ID',
    'LBL_ENABLE_TOUCHID' => '켜기 {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => '설정 {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => '손가락으로 터치해서 로그인',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} 설정이 장치에 활성화되지 않았습니다.\n\n장치 설정에서 {{{biometryType}}} 설정을 하십시오. 설정 이후에는 메인 메뉴 > 설정에서 {{{brandName}}}의 {{{biometryType}}} 활성화를 하여 주십시오.",
    'LBL_TOUCH_ID_DISCLAIMER' => '{{{brandName}}}의 {{{biometryType}}} 사용시 {{{brandName}}} 액세스할 때 패스워드 대신 생체 인식수단을 활용합니다.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => '{{{biometryType}}}(으)로 계속하시겠습니까?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => '{{{brandName}}} 패스워드를 입력하여 {{{biometryType}}} 활성화를 하십시오',
    'LBL_SETUPBUDDY_HEADER_TITLE' => '설정',
    'LBL_MDM_CONFIRM_CHANGE' => '어플리케이션 구성이 모바일 장치 관리자에서 변경되었습니다. 변경 사항을 적용하려면 다시 로그인하십시오.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => '기기 설정을 통해 {{{brandName}}}에 내 위치에 대한 접근 권한을 허가하십시오.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => '현재 위치를 이용할 수 없습니다.',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "현재 장소 불러오기 시간이 지났습니다. 다시 시도해 주십시오.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => '위치 아이콘을 사용할 수 없습니다.',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => '위치 좌표가 잘못되었습니다.',
    'ERR_MOBILE_INVALID_PASSWORD' => '유효하지 않은 비밀번호입니다.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => '귀하의 어플리케이션의 버전이 연결중인 SugarCRM과 호환되지 않습니다. 업데이트하시겠습니까?',
    'LBL_MOBILE_BY' => '의한',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => '이 필터는 오프라인 모드에서 이용 불가능합니다.',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => '오프라인 레코드',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => '설정 다운로드',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => '오프라인 액세스를 위해 지정하고, 즐겨 찾기에 등록한, 후속 레코드를 다운로드하십시오. 오프라인 설정에서 사용자 선호를 업데이트 할 수 있습니다.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => '기록 다운로드가 종료되었습니다. 오프라인 모드에서 접속 가능합니다.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "모든 기록을 다운로드하지 못했습니다. 다시 시도하겠습니까?",
    'LBL_BULK_LOAD_USE_CELLULAR' => '셀룰러 데이터 사용',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => '나중에',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => '다운로드가 일시 중지되었으며 앱을 다시 열면 다시 시작됩니다.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => '{{{module}}} 다운로드 중: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => '최신 레코드 업데이트',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => '연결 대기 중',
    'LBL_BULK_LOAD_STATUS_PAUSED' => '일시 중지됨',
    'LBL_BULK_LOAD_STATUS_STOPPING' => '중지 중',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => '다운로드',
    'LBL_BULK_LOAD_BTN_PAUSE' => '일시 중지',
    'LBL_BULK_LOAD_BTN_RESUME' => '다시 시작',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => '기본적으로 WiFi 연결에서 만 사용됩니다.',
    'LBL_NPS_RATING_MSG' => "{{{productName}}} 평가를 해 주시겠습니까?",
    'LBL_NPS_THANKS_MSG' => '감사합니다!',
    'LBL_NPS_APPSTORE_RATE_MSG' => '앱 스토어에서 평가해 주시겠습니까?',
    'LBL_NPS_NO_THANKS' => '앱 스토어에서 평가해 주시겠습니까?',
    'LBL_NPS_NOT_NOW' => '나중에',
    'LBL_NPS_RATE_NOW' => '지금 평가하기',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => '네트워크를 사용할 수 없습니다. 오프라인에서도 앱을 사용할 수 있습니다.',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => '온라인 상태일 때 변경 사항이 동기화됩니다. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>자세히 보기</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => '동기화되지 않은 데이터가 있습니다. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>트랜잭션 로그를</a> 확인하십시오.',
    'LBL_CONVERT' => '변환',
    'LBL_CONVERT_LEAD' => '리드 변환',
    'LBL_SEARCH_EXISTING_RECORD' => '기존 {{{this}}} 검색',
    'LBL_DUPLICATES_CHECK_FAILED' => '중복 검사 실패',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => '관련 활동을 연락처 기록으로 이동하시겠습니까?',
    'LBL_LEAD_CONVERSION_SUCCESS' => '{{{name}}}리드를 성공적으로 변환했습니다.',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => '중복이 없습니다.',
    'ERR_LEAD_CONVERSION_FAIL' => '리드 변환 실패',
    'LBL_SELECT_DUPLICATE_RECORD' => '중복 {{{modulePlural}}}에서 선택',
    'LBL_SELECTED_EXISTING_RECORD' => '선택된 {{{moduleSingular}}}',
    'LBL_CREATED_NEW_RECORD' => '생성된 새 {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => '뒤로 버튼',
    'LBL_VO_HOME_BTN' => '홈 버튼',
    'LBL_VO_DASHBOARD_BTN' => '대시 보드 버튼',
    'LBL_VO_SEARCH_BTN' => '검색 버튼',
    'LBL_VO_RIGHT_MENU_BTN' => '오른쪽 메뉴 버튼',
    'LBL_VO_ADD_BTN' => '추가 버튼',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => '할인',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => '매핑 앱 선택',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => '선택한 {{entityName}}는 다음 값 {{localizedFieldNames}}과 관련이 있습니다. 기존 값을 유지하려면 취소합니다. 새 값으로 덮어 쓰기를 확인합니다.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => '데이터 암호화가 활성화되었습니다.',
    'LBL_LEAD_ALREADY_CONVERTED' => '선택한 관심고객은 이미 전환되었습니다.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => '장치가 온라인 상태일 때만 가능한 액션입니다.',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => '견적에서 영업기회를 생성하시겠습니까?',
    'LBL_TAG_ADD' => '태그 추가',
    'LBL_TAG_ENTER_TAG_NAME' => '태그 입력',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => '태그별 필터링은 장치가 오프라인 상태일 때 지원되지 않습니다.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => '전체 코멘트 보기',
    'LBL_COMMENT_VIEW' => '코멘트 보기',
    'LBL_PMSE_LABEL_DUEDATE' => '마감일',
    'LBL_PMSE_DUE' => '업무 만기일자',
    'LBL_PMSE_DUE_ON' => '만기일',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => '먼저 {{conversionParentModuleName}}을 생성하십시오',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => '필요 기록 누락: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => '이미지 품질을 선택하십시오. 이미지 크기가 조정된 뒤 서버에 저장됩니다. 선택한 값은 앞으로 비슷한 모든 작업의 기본값으로 사용될 것입니다.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => '파일 크기 예측 중...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => '예측된 파일 크기는',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => '이미지 품질',
    'LBL_IMAGE_QUALITY_BEST' => '원본 크기',
    'LBL_IMAGE_QUALITY_GOOD' => '고품질',
    'LBL_IMAGE_QUALITY_POOR' => '작은 크기',
    'LBL_IMAGE_QUALITY_BTN' => '압축: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => '{{module}}의 목록 필드',
    'LBL_LIST_RESET_FIELDS' => '기본값으로 재설정',
    'LBL_LIST_NOT_ENOUGH' => '활성 필드를 최소 1개 설정해 주십시오.',
    'LBL_LOGIN_PERMISSION_ABORTED' => '로그인하여 권한을 수락해야만 SugarCRM 인스턴스로 작업 가능합니다.',
    'LBL_SELECTING_EXISTING_RECORD' => '{{{moduleSingular}}} 선택',
    'LBL_CREATING_NEW_RECORD' => '새 {{{moduleSingular}}} 생성',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => '이미지 크기',
    'LBL_COPY_ADDRESS' => '주소 복사',
    'LBL_OPEN_IN' => '열기',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => '선택한 파일이 없습니다.',
    'LBL_ATTACHMENT_ADD' => '첨부하기',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => '이 앱은 쿠키를 사용합니다',
    'LBL_USE_COOKIES_CONFIRM' => '이 어플리케이션은 더 나은 경험을 제공하기 위한 목적으로 쿠키를 사용합니다. 계속 진행하면 귀하는 당사 개인정보 정책에 따른 쿠키 사용을 동의하게 됩니다.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => '추후 모바일 릴리스에서 Sugar Mobile과 호환되지 않는 Sugar 인스턴스를 사용 중입니다. 관리자에게 요청하여 Sugar를 가능한 빨리 업그레이드하십시오.',
    'ERROR_TAG_NAME_INVALID' => '태그 이름은 "{{{forbiddenChars}}}” 문자를 포함할 수 없습니다',
    'ERROR_NO_TAGS_FOUND' => '"{{{searchQuery}}}” 일치 태그 없음',
    'ERR_PA_RECORD_INVALID' => '{{{moduleName}}} 기록에는 유효하지 않은 값이 하나 이상 있어 저장할 수 없습니다. 기록을 편집하여 {{{actionLabel}}} 액션을 수행하시겠습니까?',
    'ERR_MOBILE_METADATA_RELOAD' => '관리자가 귀하의 Sugar 인스턴스 설정을 변경했습니다. 확인을 눌러 앱 설정과 서버를 동기화하십시오.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => '이 어플리케이션은 쿠키를 사용합니다',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => '수락을 체크해주십시오 (필수)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => '이 어플리케이션은 더 나은 경험을 제공하기 위한 목적으로 쿠키를 사용합니다. 계속 진행하면 귀하는 당사 <a href="{{href}}" target="_blank">개인정보 정책</a>에 따른 쿠키 사용을 동의하게 됩니다.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => '레코드 보기는 해당 레코드의 상세내용까지 볼수 있습니다.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => '메모는 다른 포탈사용자와 지원자와 공동작업을 가능하게합니다.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => '이 레코드에 노트를 추가하려면 이곳을 클릭하십시오.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => '첨부된 메모의 세부사항을 보려면 이 아이콘을 클릭하십시오.',

    //for portal
    'LBL_PORTAL_HOME' => '홈 대시보드',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => '모든 열린 사례목록',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => '최근 해결된 사례 목록',
    'LBL_PORTAL_SEARCH' => '이름과 번호로 검색',
    'LBL_SIGNUP_BUTTON_LABEL' => '가입하기',
    'LBL_PORTAL_NO_EMAIL' => '이메일을 받지 못하셨습니까?',
    'LBL_PORTAL_FORGOT_PASSWORD' => '비밀번호를 분실하셨습니까',
    'LBL_PORTAL_FORGOT_USERNAME' => '사용자명을 분실하셨습니까',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => '비밀번호를 두 번 입력하십시오. 비밀번호는 반드시 일치해야 합니다.',
    'LBL_PORTAL_RESET_PASSWORD' => '비밀번호 재설정',
    'LBL_PORTAL_REENTER_PASSWORD' => '비밀번호 재입력',
    'LBL_PORTAL_PASSWORD_MISMATCH' => '비밀번호가 일치하지 않습니다. 다시 입력해주십시오',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => '귀하의 비밀번호가 성공적으로 재설정 되었습니다',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => '에러가 발생했습니다. 새로운 비밀번호 재설정을 요청해 주십시오.',
    'LBL_PORTAL_SIGNUP_PROCESS' => '등록중',
    'LBL_PORTAL_SIGNUP_TITLE' => '가입해주셔서 감사합니다',
    'LBL_PORTAL_SIGNUP' => '귀하의 세부사항을 확인한 후 알려드릴 것입니다.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => '이름',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => '성',
    'LBL_PORTAL_SIGNUP_USER_NAME' => '사용자명',
    'LBL_PORTAL_SIGNUP_EMAIL' => '이메일 주소',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (선택사항)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => '국가:',
    'LBL_PORTAL_SIGNUP_STATE' => '도:',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => '회사명',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => '직급',
    'LBL_PORTAL_SIGNUP_PASSWORD' => '비밀번호',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => '비밀번호 확인',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => '로그인 분실',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => '비밀번호를 분실하셨습니까?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => '비밀번호 재설정을 위해서는 Sugar 관리자에 문의하십시오.',
    'LBL_PORTAL_LOGIN_USERNAME' => '사용자명:',
    'LBL_PORTAL_LOGIN_PASSWORD' => '비밀번호:',
    'LBL_PORTAL_LOADING' => '로딩중',
    'LBL_PORTAL_SAVING' => '저장중',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => '사용이 불가능한 페이지입니다.',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "죄송합니다. 이 기능은 현재 사용이 불가능합니다.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => '<요청>한 검색결과를 표시합니다.',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => '이메일을 받지 못하셨습니까?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => '도움이 필요하거나 저희에게 연락하시려면 다음의 방법 중 한 가지를 사용하십시오: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => '전화번호: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => '이메일: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => '웹: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => '채팅을 종료하시겠습니까?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => '새 메모 생성 혹은 첨부 추가하기',
    'LBL_PORTAL_NEW_NOTE_BTN' => '메모 추가',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => '귀하의 로그인이 실패했습니다. 다시 시도해 주십시오.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => '유효하지 않은 증명서',
    'LBL_PORTAL_INVALID_GRANT' => '세션이 만료되었습니다. 다시 로그인하십시오.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => '세션 종료',
    'LBL_PORTAL_AUTH_FAILED' => '고객 승인 실패',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => '유효하지 않은 고객',
    'LBL_PORTAL_INVALID_REQUEST' => '요청하는 사항은 유효하지 않거나 잘못 생성되었습니다. 관리자에 문의하십시오.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => '유효하지 않은 요청',
    'LBL_PORTAL_REQUEST_TIMEOUT' => '요청 시간이 지났습니다.',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => '요청 시간초과',
    'LBL_PORTAL_UNAUTHORIZED' => '죄송합니다. 이 자원에 접속권한이 없습니다.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'HTTP 오류: 401 접속권한 없음',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => '자원이 사용불가능합니다.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'HTTP 오류: 403 금지됨',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => '이 요청은 HTTP를 통한 실행이 허용되지 않습니다. 관리자에 문의하십시오.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP 오류: 허용되지 않음',
    'LBL_PORTAL_PRECONDITION_MISSING' => '요청이 실패되었거나 조건이 바르지 않습니다. 관리자에 문의하십시오.',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'HTTP 오류: 412',
    'LBL_PORTAL_MIN_MODULES' => '이 어플리케이션을 사용하기 위해서는 사례, 버그 또는 지식 모듈이 필요합니다',
    'LBL_PORTAL_ERROR' => '오류',
    'LBL_PORTAL_ROUTE_ERROR' => '모듈 로딩 문제입니다. 나중에 다시 시도하거나 관리자에 문의하십시오.',
    'LBL_PORTAL_OFFLINE' => '죄송합니다. 이 어플리케이션은 현재 사용이 불가능합니다. 관리자에 문의하십시오.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => '비밀번호 변경하기',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => '사용자명이 이미 시스템에 등록되어 있습니다. 비밀번호 분실 요청을 하시거나 다른 사용자명을 선택하십시오.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => '제공된 이메일이 유효하지 않습니다.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => '비밀번호가 일치하지 않습니다.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => '서비스 콘솔',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => '개요',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => '기본 대시보드 복원',
    'LBL_UNTITLED' => '제목 없음',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => '콘솔 갱신',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => '개요',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => '단계/상태',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => '이름/계정명',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => '옴니채널 대시보드',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => '소비자',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{Time}}의 {{type}} {{direction}} {{identifier}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => '이 브라우저는 SugarLive를 지원하지 않습니다. Google Chrome이나 Mozilla Firefox를 사용하세요.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => '대화 내역이 포함된 <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a>가 생성되었습니다.',
    'LBL_OMNICHANNEL_SUBJECT' => '제목',
    'LBL_OMNICHANNEL_DESCRIPTION' => '설명',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => '메시지 요약',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => '통화 요약',
    'LBL_OMNICHANNEL_LINK_TO' => '{{fromModule}}을(를) {{toModule}}에 연결',
    'LBL_OMNICHANNEL_LINK_RECORD' => '{{module}}에 연결',
    'LBL_OMNICHANNEL_LINKED' => '연결됨',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => '이 브라우저는 채팅을 지원하지 않습니다. Google Chrome이나 Mozilla Firefox를 사용하세요.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Sugar 관리자에게 연락하여 도움을 청하십시오.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => '레이아웃 설정',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'SugarLive 설정을 완료한 뒤 아웃바운드 통화를 시작하십시오.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'SugarLive 레이아웃 설정을 완료한 뒤 SugarLive를 열어 주십시오.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'SugarLive에서 상태를 "오프라인"으로 설정한 뒤 SugarLive 레이아웃을 설정해 주십시오.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => '간단히 보기',
    'LBL_OMNICHANNEL_FULL_VIEW' => '전체 보기',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR 대시보드',
    'LBL_SALES_MANAGER_CONSOLE' => '영업 관리자 대시보드',
    'LBL_SALES_REP_CONSOLE' => '영업 담당자 대시보드',
    'LBL_MARKETING_CONSOLE' => '마케팅 대시보드',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => '고객 성공 대시보드',
    'LBL_EXECUTIVE_CONSOLE' => '경영진 대시보드',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => '탭을 기본값으로 복원',
    'LBL_CONFIGURE_SUMMARY_PANEL' => '요약 패널 설정',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => '사용자 프로필',
    'LBL_WIZ_COMPLETE_TITLE' => '설정 완료',
    'LBL_SETUP_COMPLETE_INFO' => 'SugarCRM 사용을 시작합니다.',
    'LBL_SETUP_USER_INFO' => '사용자 정보를 설정하십시오.',
    'LBL_WIZ_USER_LOCALE_TITLE' => '사용자 현지 설정',
    'LBL_SETUP_USER_LOCALE_INFO' => '시간대, 날짜와 형식명을 설정하십시오.',
    'LBL_WIZ_START_SUGAR' => 'Sugar를 시작합니다.',
    'LBL_WIZ_FIRST_NAME' => '이름',
    'LBL_WIZ_LAST_NAME' => '성',
    'LBL_WIZ_EMAIL' => '이메일',
    'LBL_WIZ_TIMEZONE' => '시간대',
    'LBL_WIZ_TIMEFORMAT' => '시간 형식:',
    'LBL_WIZ_DATE_FORMAT' => '날짜 형식:',
    'LBL_WIZ_NAME_FORMAT' => '이름 형식',
    'LBL_SETUP_PROGRESS' => '설정 처리',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar 트레이닝',
    'LBL_WIZ_DOCUMENTATION' => '문서화',
    'LBL_WIZ_KNOWLEDGE_BASE' => '지식',
    'LBL_WIZ_FORUMS' => '포럼',
    'TPL_TIMEZONE_DIFFERENT' => '귀하의 브라우저 시간대가 SugarCRM에 설정된 시간대와 일치하지 않습니다.',
    'LBL_TIMEZONE_DIFFERENT_LINK' => '시간대를 조정하십시오.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => '현지 설정',
    'LBL_WIZ_EMAIL_SETTINGS' => '이메일 설정',
    'LBL_WIZ_IMPORT_DATA' => '데이터가져오기',
    'LBL_WIZ_CREATE_USERS' => '신규 사용자 만들기',
    'LBL_WIZ_APPLICATION_SETTINGS' => '시스템 설정',
    'LBL_WIZ_CONFIGURE_APPLICATION' => '작업실',

    'LBL_CSP_ERROR_MESSAGE' => '입력한 값이 지원되지 않거나 허용되는 형식에 맞지 않습니다. 허용되는 필드 값 및 형식 목록은 <a href="{{linkToDocumentation}}" target="_blank">시스템</a> 문서를 참조하십시오.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => '이 콘텐츠는 승인되지 않았습니다. 시스템의 <a href="{{linkToDocumentation}}" target="_blank">콘텐츠 보안 정책 설정</a>을 업데이트하십시오.',
    'LBL_CSP_ERROR_MESSAGE_USER' => '이 콘텐츠는 승인되지 않았습니다. 관리자에게 요청해 시스템의 <a href="{{linkToDocumentation}}" target="_blank">콘텐츠 보안 정책 설정</a>을 업데이트하십시오. 설정이 업데이트되면, 사용자는 브라우저를 새로고침하여야 변경 사항이 반영됩니다.',

    // For password related labels
    'LBL_PASSWORD' => '비밀번호:',
    'LBL_CHANGE_YOUR_PASSWORD' => '비밀번호 변경',
    'LBL_PASSWORD_REQUIREMENTS' => '비밀번호 필수사항',
    'LBL_CURRENT_PASSWORD' => '현재 비밀번호',
    'LBL_NEW_PASSWORD1' => '새 비밀번호',
    'LBL_NEW_PASSWORD2' => '비밀번호 확인',
    'LBL_PASSWORD_CHANGED' => '비밀번호가 성공적으로 변경되었습니다',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => '비밀번호 확인을 입력하십시오',
    'ERR_ENTER_NEW_PASSWORD' => '새 비밀번호를 입력하십시오',
    'ERR_ENTER_OLD_PASSWORD' => '현재 비밀번호를 입력하십시오',
    'ERR_REENTER_PASSWORDS' => '비밀번호가 일치해야 합니다.',
    'ERR_PASSWORD_MISMATCH' => '입력된 비밀번호가 시스템과 일치하지 앖습니다.',
    'LBL_CANNOT_SEND_PASSWORD' => '비밀번호를 보낼수 없습니다.',
    'LBL_REQUEST_PASSWORD' => '비밀번호 요청',
    'LBL_RESET_PASSWORD' => '비밀번호 재설정',
    'LBL_RESET_PASSWORD_MESSAGE' => '사용자명을 입력하면 저희가 귀하의 비밀번호를 재설정할 수 있는 링크를 보내드릴 것입니다.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => '이메일을 확인해 주십시오<br><br> 비밀번호 재설정 지침을 저희가 보유한 파일에 있는 이메일 주소로
        발송했습니다.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => '오류 :이 사용자에 대한 암호를 업데이트하는 데 문제가 발생했습니다.',
    'LBL_INCORRECT_PASSWORD' => '오류 : 잘못된 암호를 입력하였습니다.',
    'LBL_PASSWORD_ENFORCE_TITLE' => '입력한 비밀번호가 요구사항에 맞지 않습니다. 다시 시도해 주십시오.',
    'LBL_PASSWORD_MIN_LENGTH' => '최소 길이는 {0} 입니다.',
    'LBL_PASSWORD_MAX_LENGTH' => '최대 길이는 {0} 입니다.',
    'LBL_PASSWORD_ONE_UPPERCASE' => '하나의 대문자를 반드시 포함해야 합니다(A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => '하나의 소문자를 반드시 포함해야 합니다(a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => '하나의 숫자를 반드시 포함해야 합니다(0~9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => '하나의 특수문자를 반드시 포함해야 합니다(~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => '비밀번호는 정규식 패턴 {0} 과 일치해서는 안됩니다.',

    'LBL_PREFERRED_LANGUAGE' => '언어 설정:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => '비밀번호 재설정 이메일을 보낼 수 없습니다.',

    //Saved Reports
    'LBL_REPORT_SELECT' => '보고서 선택',
    'LBL_REPORT_AUTO_REFRESH' => '자동 새로 고침',
    'LBL_REPORT_EDIT' => '선택한 보고서 편집',
    'LBL_REFRESH_LIST_AND_CHART' => '목록 및 차트 새로고침',
    'LBL_NO_CHART_REPORT_AVAILABLE' => '이용 가능한 차트 없음.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => '이 보고서에는 필터가 포함되어 있지 않습니다.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => '숨겨진 런타임 필터만 있습니다. 고급 필터를 참조하십시오.',
    'LBL_RUNTIME_FILTERS' => '런타임 필터',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => '날짜가 사용자가 선호하는 날짜 형식과 일치하지 않음:',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => '이 대시렛에는 런타임 필터가 없습니다.',
    'LBL_DASHBOARD_FILTER_GROUP' => '새 필터',
    'LBL_RUNTIME_FILTER_LIMITATION' => '값을 적어도 하나 선택해야 합니다.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => '기본 필터로 재설정',
    'LBL_COPY_FILTER_SUMMARY' => '필터 요약 복사',
    'LBL_APPLY_FILTERS' => '적용',
    'LBL_REPORTS_FILTERS' => '필터',
    'LBL_RUNTIME_FILTERS_INVALID' => '값이 유효하지 않아 런타임 필터를 적용할 수 없습니다.',
    'LBL_RUNTIME_FILTERS_COPIED' => '필터 요약이 클립보드에 복사되었습니다.',
    'LBL_ADVANCED_FILTERS' => '고급 필터',
    'LBL_ADVANCED_OR_DESC' => '여하한 조건이 충족될 때 포함',
    'LBL_ADVANCED_AND_DESC' => '모든 조건이 충족될 때 포함',
    'LBL_ORIGINAL_DESIGN_FILTER' => '이것은 오리지널 디자인 필터입니다',
    'LBL_AND_UPPERCASE' => '그리고',
    'LBL_REPORTS_PREVIEW_LIMITATION' => '이 기능은 미리보기 모드에서 이용 불가능합니다',
    'LBL_REPORT_DEFAULT_NAME' => '제목 없는 보고서',
    'LBL_REPORT_QUERY' => '문의',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => '현재 레코드 관련',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => '연결 필드',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => '연결 필드는 비워 둘 수 없습니다',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => '선택한 보고서가 없습니다.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => '라인 차트는 이 보고서와 호환되지 않습니다',
    'LBL_REPORT_DASHLET' => '보고서 대쉬릿',
    'LBL_REPORTS_DASHLET_DATATABLE' => '데이터 표',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => '런타임 필터',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => '데이터 표 미리보기',
    'LBL_REPORTS_DASHLET_CHART' => '차트',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => '차트 미리보기',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => '필터 미리보기',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => '선택한 보고서는 차트를 지원하지 않습니다.',
    'LBL_REPORTS_DASHLET_LABELS' => '라벨',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => '총 레코드 수 표시',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => '정렬 순서',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => '초기 선택된 보기',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => '최우선 차트 정렬 순서',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => '차선 차트 정렬 순서',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => '선택한 보고서에 대한 {{module}} 링크 없음',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => '이 보고서 유형에는 사용할 수 없음',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => '이 기능은 차트 탭에서만 이용 가능',
    'LBL_REPORTS_CHART_TYPE' => '차트 유형',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => '바 차트 값 배치',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => '전체 표시',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => '범례 표시',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'X축 레이블 표시',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Y축 레이블 표시',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => '행 표시 제한',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => '이 런타임 필터를 사용할 권한이 없습니다.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => '알수 없음',
    'ERR_HTTP_DEFAULT_TITLE' => '알수 없는 오류',
    'ERR_HTTP_DEFAULT_TEXT' => '알수 없는 오류',
    'ERR_HTTP_DEFAULT_ACTION' => '이전 페이지로 돌아갑니다.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => '오류 : 잘못된 요청',
    'ERR_HTTP_400_TEXT_LINE1' => '브라우저가 서버가 이해할 수없는 요청을 보냈습니다.',
    'ERR_HTTP_400_TEXT_LINE2' => '자세한 내용은 해당 설탕 관리자에게 문의하십시오.',
    'ERR_HTTP_400_ACTION' => '다시 이전 페이지로 이동합니다.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'HTTP: 404 발견되지 않음',
    'ERR_HTTP_404_TEXT_LINE1' => '페이지가 존재하지 않거나 이 페이지에 대한 엑세스 권한이 없습니다',
    'ERR_HTTP_404_TEXT_LINE2' => '다시 시도 하십시오. 오류가 계속되면 슈가 관리자에 문의해 주십시오.',
    'ERR_HTTP_404_ACTION' => '이전 페이지로 돌아갑니다.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 내부 서부 오류',
    'ERR_HTTP_500_TEXT_LINE1' => '서버에 오류가 발생하여 귀하의 요청을 완료할 수 없었습니다.',
    'ERR_HTTP_500_TEXT_LINE2' => '다시 시도 하십시오. 오류가 계속되면 슈가 관리자에 문의해 주십시오.',
    'ERR_HTTP_500_ACTION' => '관리자에 문의하십시오.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 내부 서버 오류',
    'ERR_HTTP_502_TEXT_LINE1' => '서버에 잠시 오류가 발생하여 귀하의 요청을 완료할 수 없습니다.',
    'ERR_HTTP_502_TEXT_LINE2' => '다시 시도 하십시오. 오류가 계속되면 Sugar 관리자에 문의하십시오.',
    'ERR_HTTP_502_ACTION' => '기술 지원에 문의하십시오.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 내부 서버 오류',
    'ERR_HTTP_503_TEXT_LINE1' => '서버가 사용자의 요청을 완료할 수 없습니다.',
    'ERR_HTTP_503_TEXT_LINE2' => '다시 시도 하십시오. 오류가 계속되면 Sugar 관리자에 문의하십시오.',
    'ERR_HTTP_503_ACTION' => '기술 지원에 문의하십시오.',

    'ERR_RENDER_FAILED_TITLE' => '보기 제공 실패',
    'ERR_RENDER_FAILED_MSG' => '보기 제공 실패',
    'ERR_RENDER_FIELD_FAILED_TITLE' => '필드 제공 실패',
    'ERR_RENDER_FIELD_FAILED_MSG' => '필드 제공 불가',

    'ERR_NO_VIEW_ACCESS_TITLE' => '접속 거부',
    'ERR_NO_VIEW_ACCESS_REASON' => '이 페이지에 접근할수 없습니다.',
    'ERR_NO_VIEW_ACCESS_ACTION' => '접근을 위해서는 관리자에 문의하십시오.',
    'ERR_NO_VIEW_ACCESS_MSG' => '이 모듈보기에 접속하려면 지원관리자에 문의하십시오.',

    'ERR_LAYOUT_RENDER_TITLE' => '레이아웃 제공 실패',
    'ERR_LAYOUT_RENDER_MSG' => '저런! 지금은 보기가 불가능합니다. 나중에 다시 시도하시거나 CRM관리자에게 문의하십시오.',
    'ERR_INTERNAL_ERR_MSG' => '내부 오류',
    'ERR_GENERIC_TITLE' => '오류',
    'ERR_CONTACT_TECH_SUPPORT' => '관리자에 문의하십시오.',

    'LBL_SYNCED_RECURRING_MSG' => '이 레코드는 외부 클라이언트와 연결되어 있어 편집할 수 없습니다.',
    'LBL_EXISTING' => '이미 존재함',
    'LBL_PANEL_DEFAULT' => '기본설정',
    'ERR_BAD_RESPONSE_FROM_SERVER' => '서버로부터 응답이 없습니다.',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'AssignTo action 동안 오류가 발생했습니다.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => '"{{name}}"의 접속권한이 없습니다. 관리자에게 문의하십시오.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => '연',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '분기',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => '추가 작업',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => '알림',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => '중복 무시하고 저장',
    'LBL_RESTORE' => '기본으로 재설정',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => '삭제된 것으로 표시된 기록',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => '데이터 프라이버시 요청과 관련된 기록을 표시합니다.'
        . '정보 삭제.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS 피드',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => '외부 RSS 또는 블로그 피드를 추가하여 최신 정보를 얻을 수있습니다.',
    'LBL_RSS_FEED_URL' => '피드 URL',
    'LBL_RSS_FEED_AUTHOR' => '저자 :',
    'LBL_RSS_FEED_ENTRIES_COUNT' => '항목 수',
    'LBL_ERR_LOADING_RSS_FEED' => 'RSS 피드 로딩 실패',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => '내 연혁',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => '팀 내역',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => '사용자가 대시보드에 Sugar 앱을 추가할 수 있습니다.',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => '히스토리(History)',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => '이 대쉬릿은 회의, 전화, 수신 이메일 그리고 발신 이메일 내역을 표시합니다.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => '이메일',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => '이메일 목록',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => '내 기록내역',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => '팀 기록내역',
    'LBL_UNASSIGNED' => '미지정',
    'LBL_ARCHIVE_EMAIL' => '아카이브 이메일',
    'LBL_EMAIL_ARCHIVED' => '이메일 보관',
    'LBL_CREATE_ARCHIVED_EMAIL' => '보관 이메일 새로 만들기',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => '예정된 활동',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => '예정된 활동 대쉬릿은 계획된 회의와 전화를 표시합니다.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => '오늘',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => '미래',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => '내 활동',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => '팀 활동',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => '개최',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => '종료된 {0}을 표시하시겠습니까?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => '진행중인 작업',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => '진행중인 작업 대쉬릿은 계획중이거나 완료일이 다가오는 업무를 표시합니다.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => '기한 지남',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => '기한 다가옴',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => '작업 목록',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => '완료',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => '완료된 {0}를 종료하시겠습니까?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => '내 과제 목록',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => '팀 작업',
    'LBL_LIST_REMOVE_EMAIL_INFO' => '변경 중인 기록에 추가 이메일이 있었습니다. 현재 1차적인 것들이며 아래에 덧붙여졌습니다.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => '유효하지 않은 과제',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => '작업 대쉬릿은 연기되거나 완료된 작업을 표시합니다.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => '연기',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => '완료',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => '마지막 수정 {{relativetime}} on {{date}} at {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => '내 과제 목록',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => '팀 작업',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => '나의 최근 본 사례들',

    'LBL_REPORT_DASHLET_TITLE_12' => '상태별 사용자로 사례 열기',
    'LBL_REPORT_DASHLET_TITLE_125' => '주별 업무 센터의 새로운 사례',
    'LBL_REPORT_DASHLET_TITLE_126' => '최근 만들어진 사례',
    'LBL_REPORT_DASHLET_TITLE_127' => '주별 고객 등급으로 새로운 사례',
    'LBL_REPORT_DASHLET_TITLE_128' => '고객 등급 및 우선 순위별 사례 열기',
    'LBL_REPORT_DASHLET_TITLE_129' => '업무 센터별 이번 달에 해결된 전체 사례',
    'LBL_REPORT_DASHLET_TITLE_130' => '에이전트별 이번 달에 해결된 전체 사례',
    'LBL_REPORT_DASHLET_TITLE_131' => '최근 해결된 사례들의 목록',
    'LBL_REPORT_DASHLET_TITLE_132' => '주별 이번 달에 해결된 나의 사례',
    'LBL_REPORT_DASHLET_TITLE_133' => '나의 사례가 금일 만료 및 만료일 도과함',
    'LBL_REPORT_DASHLET_TITLE_134' => '모든 사례가 금일 만료 및 만료일 도과함',
    'LBL_REPORT_DASHLET_TITLE_135' => '후속 조치 일자별 나의 열린 사례',
    'LBL_REPORT_DASHLET_TITLE_136' => '후속 조치 일자별 모든 열린 사례',
    'LBL_REPORT_DASHLET_TITLE_137' => '상대별 나의 열린 사례',
    'LBL_REPORT_DASHLET_TITLE_138' => '상태별 지난 주 나의 사례',
    'LBL_REPORT_DASHLET_TITLE_139' => '내가 할당한 열린 작업 상태',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP 또는 이전 REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => '크론 작업',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => '로직 후크',
    'LBL_AUDIT_SUBJECT_MARKETO' => '마케토',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => '슈가 워크 플로우',
    'LBL_AUDIT_SUBJECT_USER' => '사용자',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => '리드할 웹',

    //common chart strings
    'LBL_CHART' => '차트',
    'LBL_CHART_NO_DATA' => '이용 가능한 데이터 없음',
    'LBL_CHART_LEGEND_CLOSE' => '범례 숨기기',
    'LBL_CHART_LEGEND_OPEN' => '범례 표시',
    'LBL_CHART_CONTROLS_CLOSE' => '컨트롤 숨기기',
    'LBL_CHART_CONTROLS_OPEN' => '컨트롤 표시',
    'LBL_CHART_UNDEFINED' => '정의되지 않은',
    'LBL_CHART_NO_LABEL' => '정의되지 않음',
    'LBL_CHART_AMOUNT' => '수량',
    'LBL_CHART_COUNT' => '개',
    'LBL_CHART_PERCENT' => '퍼센트',
    'LBL_CHART_GROUP' => '그룹',
    'LBL_CHART_DATE' => '날짜',
    'LBL_CHART_KEY' => '키',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => '차트 유형',
    'LBL_CHART_CONFIG_SHOW_TITLE' => '제목 표시',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => '전체 표시',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => '쇼 X 축 레이블',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => '확대 Y 축 레이블',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => '진드기 디스플레이 메서드',
    'LBL_CHART_CONFIG_TICK_WRAP' => '랩 틱',
    'LBL_CHART_CONFIG_TICK_STAGGER' => '파상 배치 진드기',
    'LBL_CHART_CONFIG_TICK_ROTATE' => '회전 틱',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => '바 차트 값 배치',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => '막대 차트 표시 옵션',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => '스크롤 허용',
    'LBL_CHART_CONFIG_STACK_DATA' => '스택 데이터 계열',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => '빈 그룹을 숨기기',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => '이메일이 전송되었습니다.',
    'LBL_EMAIL_RECV' => 'rec',

    //record save
    'LBL_RECORD_SAVED' => '기록이 저장되었습니다.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => '성공적으로 생성하였습니다 {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a>.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => '성공적으로 {{moduleSingularLower}}를 만들었습니다.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => '성공적으로 이 기록을 생성하지만, 이 기록을 액세스할 수 있는 권한이 없습니다.', // use when user has no access to the model
    'LBL_VALIDATING' => '확인중',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => '성공',
    'LBL_ALERT_TITLE_WARNING' => '경고',
    'LBL_ALERT_TITLE_NOTICE' => '알림보기를 클릭하십시오.',
    'LBL_ALERT_TITLE_ERROR' => '오류',
    'LBL_ALERT_TITLE_LOADING' => '로딩중입니다.',
    'LBL_ALERT_NO_ACCESS' => '이 대시렛에 적용된 필터에 액세스할 수 없습니다.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => '대시보드를 복제하여 귀하의 필터로 이 대시렛을 설정하십시오.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => '귀하의 브라우저 버젼이 더이상 지원되지 않거나 지원되지 않는 브라우져입니다.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => '지원되는 플랫폼',
    'LBL_ALERT_CONFIRM_DELETE' => '이 아이템을 삭제하시겠습니까?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => '이 아이템들을 삭제하시겠습니까?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => '선택된 레코드는 다음의 관련된 값을 포함합니다. 이 값을 레코드에 복제하려면 확인 버튼을 클릭합니다. 현재 값을 유지하려면 취소 버튼을 클릭합니다.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => '선택한 {{moduleSingularLower}}는 다음의 값: {{values}}과 관련이 있습니다. 기존 값을 유지하려면 취소합니다. 새 값으로 덮어 쓰기를 확인합니다.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => '보낸 사람 :',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => '까지 :',

    //organization chart
    'LBL_ORG_CHART' => '조직 차트',
    'LBL_ORG_CHART_DESC' => '조직의 구성원 구조를 보여줍니다.',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => '토글 오리엔테이션',
    'LBL_ORG_CHART_TOOLTIP_NODES' => '모든 노드를 보여줍니다.',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => '화면에 맞게 확대',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => '사례 요약',
    'LBL_CASE_SUMMARY_CHART_DESC' => '관련 사례의 개요 보기',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => '개요',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => '종료된 사례목록',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => '열린 사례목록',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => '상위 10 영업기회의 매출 라인아이템',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => '상위 10개 영업기회의 매출 라인아이템 버블차트로 보기',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => '내 매출 라인아이템',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "내 팀의 매출 라인아이템",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => '기본 데이터 필터',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => '기본 데이터 세트',

    'LBL_PRODUCT_CATALOG_NAME' => '제품 카탈로그',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => '제품 카탈로그',
    'LBL_PRODUCT_CATALOG_DESC' => '제품 카탈로그에서 항목을 보고 추가합니다.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => '제품 카탈로그에서 항목을 보고 추가합니다.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} {{date}}자 {{time}}시',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => '노트를 작성하거나 첨부 파일을 가져옵니다. @ 다음에 멘션(Mention) 을 작성합니다. # 를 입력하여 참고할 기록을 추가합니다.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => '의견을 추가하십시오. @ 다음에 멘션(Mention)을 작성합니다. # 를 입력하여 레코드를 참고(Reference)합니다.',
    'LBL_ACTIVITY_STREAM' => '활동흐름',
    'LBL_ACTIVITY_STREAM_DISABLED' => '활동흐름이 비활성 상태입니다.',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => '액티비티 스트림이 이 모듈에 대해 활성화되지 않습니다',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => '포스트 더 보기',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => '에',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => '내 활동 스트림',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => '레코드에 수행된 활동 목록을 표시하고 코멘트를 생성하고 게시하십시오.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => '활동 스트림이 비활성화되었습니다',

    'LBL_DATA_VIEW' => '데이터보기',
    'LBL_COMMENT' => '의견',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => '서버 연결중 오류가 발생했습니다. 다시 시도해주십시오.',
    'ERR_RESOLVE_ERRORS' => '진행전 오류를 해결하십시오.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => '승인하려면 필수 입력란을 모두 작성해야합니다. 그러나 이 기록을 거부하거나 전달할 수 있습니다.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => '거부/전달하려면 모든 필수 입력란을 작성해야합니다.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => '목록 새로고침',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => '타일 새로고침',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => '더보기',
    'LBL_TEXTAREA_LESS' => '축소 보기',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '첨부',
    'LBL_CREATE_ATTACHMENT' => '첨부하기',
    'LBL_DASHLET_REFRESH' => '새로고침',
    'LBL_DASHLET_MOVE' => '이동',
    'LBL_DASHLET_CLOSE' => '닫기',

    'LBL_DASHLET_FORECAST_NAME' => '예측 내용',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => '예측 막대형 차트',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => '예측 파레토 차트',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => '에 대한 예측',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => '특정 시간 동안의 예측 내용을 막대 차트로 표시합니다',
    'LBL_DASHLET_FORECASTS_GROUPBY' => '다음에 따른 그룹',
    'LBL_DASHLET_FORECASTS_DATASET' => '데이터세트',
    'LBL_DASHLET_FORECASTS_DETAILS' => '예측 세부사항',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => '현재 예측 세부사항을 보여줍니다',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => '저장된 보고서 차트 대쉬릿',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => '저장된 보고서의 차트를 봅니다.',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => '게시된관련문서',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => '기록 요약',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => '더 많은 기록을 ...',
    'LBL_RELATED_CONTACT' => '관련 문의',
    'LBL_MODULE_TYPE' => '유형',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => '에 이메일',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => '에서 이메일',
    'LBL_PREVIEW_BWC_TOOLTIP' => '레거시 모듈은 미리보기될 수 없습니다',

    //SFA
    'LBL_BEST' => '최고',
    'LBL_WORST' => '최하',
    'LBL_LIKELY' => '예상',
    'LBL_BEST_FORECAST' => '기여(최고)',
    'LBL_WORST_FORECAST' => '기여(최악)',
    'LBL_LIKELY_FORECAST' => '기여(예상)',
    'LBL_BEST_ADJUSTED' => '조정된 기여(최고)',
    'LBL_WORST_ADJUSTED' => '조정된 기여(최악)',
    'LBL_LIKELY_ADJUSTED' => '조정된 기여(예상)',
    'LBL_AMOUNT_USDOLLAR' => '금액',
    'LBL_OVERDUE' => '만료',

    'LBL_PASSWORD_REQUEST_SENT' => '귀하의 요청이 제출되었습니다.',
    'LBL_PASSWORD_REQUEST_ERROR' => '사용자명과 이메일을 받는데 문제가 발생했습니다.',

    'LBL_REMINDER_TITLE' => '미리알림',
    'LBL_CLICK_TO_DRILLDOWN' => '드릴다운 클릭',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => '모든 언어를 비활성화할 수 없습니다.',

    'LBL_UPDATE_CALC_FIELDS' => '값을 다시 계산합니다',

    //Optimistic Locking
    'LBL_YOU' => '여러분',
    'LBL_RESOLVE_CONFLICT' => '{{name}}에 대해 충돌을 해결합니다',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => '자세한 내용은 문서{{{more_info_url}}} {{plural_module_name}} 을 참조하십시오. {{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => '이용 가능한 데이터 없음',
    'LBL_NEED_HELP' => '새 사항에 도움이 필요하십니까?',
    'LBL_NEW_CASE' => '신규 사례',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => '도움말 대쉬렛 창은 더 많은 정보를 위한 응용 프로그램 가이드에서 해당 문서(예를 들어 잠재 고객 문서)로 링크와 함께 여러분이 최근에 보던 모듈과 관련된 특정정보를 제공합니다.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => '목록 도움말',
    'LBL_HELP_RECORDS' => "모듈의 목록보기는 사용자가 액세스할 수있는 현재의 검색 기준과 맞는 모든 기록을 표시합니다. 목록보기의 필드 열에서 각 기록의 기본 세부 정보를 보거나 기록보기를 열기 위해 기록의 이름을 클릭할 수 있습니다.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => '기록보기 도움말',
    'LBL_HELP_RECORD' => '이 기록보기는 개인 기록뿐 아니라 링크된 기록의 일부 세부 사항에 대한 철저한 정보를 제공합니다. - 개인 필드 또는 편집 버튼을 클릭하여 이 기록의 필드를 편집합니다. -보기 또는 아래 왼쪽 창에  데이터보기 를 전환하여 서브 패널에 있는 다른 기록에 대한 링크를 수정합니다. - 사용자 의견의 상호 작용 및 아래 왼쪽 창에  작업 스트림 을 전환하여 기록의 변경 내용을 볼 수 있습니다. - 기록명의 오른쪽에 아이콘을 사용하여 이 기록을 따르거나 즐겨찾기를 합니다. - 추가 작업은 편집 버튼의 오른쪽에 있는 드롭 다운 동작 메뉴에서 사용할 수 있습니다.',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}}만들기',
    'LBL_HELP_CREATE' => '{{plural_module_name}} 만들기:
1.원하는필드에대한값을 지정합니다.
* 필수”로표시된필드는저장하기전에완료해야합니다. 
* 필요한경우추가필드를노출하려면“더보기”를클릭합니다. 
2.“저장하기”를 클릭하여 새 기록을 완성하고 {{plural_module_name}} 목록보기로돌아갑니다.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => '발견된 잠재 중복',
    'LBL_HELP_DUPLICATE' => 'Sugar은 만들려고 하는 기록이 이미 존재한다는 것을 발견했습니다. 오히려 새로 만드는 것보다 기존 기록을 수정하려면 원하는 기록의 오른쪽에  선택 및 편집 을 클릭합니다.기존 레코드에 빈 필드는 입력한 값으로 채워집니다. 기존 기록에 이러한 변경 작업을 수행하기 위해 저장 을 클릭합니다. 대신, 기존 기록의 값을 방금 입력한 값을 사용하고자 하는 경우, 원본 재설정 을 클릭합니다. 입력 값은 기존 기록에 적용되고, 지금 추가 변경을 할수 있으며 기존 기록에 대한 수정을 완료하기 위해  저장 을 클릭할 수 있습니다. 입력한 값을 사용하여 새 기록을 만들려면 화면 상단 오른쪽에있는  중복 및 저장 무시 를 클릭합니다.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => '누락된 SMTP 서버 설정',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => '기록 할당 알림을 보내려면 SMTP 서버는 {{emailSettingsUrl}}에서 구성해야합니다.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => '이메일 설정',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => '새로운 주식 보고서 사용 가능',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => '새로운 주식 보고서 사용 가능:',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => '보고서 모듈',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => '"주식 보고서"로 태그가 지정되어 필터링할 수 있습니다. 보고서는 컨텐츠를 기반으로 "영업 및 마케팅", "고객 서비스", "데이터 개인 정보", "관리"로 태그도 지정됩니다. 자세한 내용은',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => '자료',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM은 파워 유저의 생산성 향상을 위해 키보드 단축키로 특정한 작업을 빠르게 수행할 수 있도록 만들었습니다. 오른쪽의 표에서 관련 키와 효능에과 함께 사용 가능한 단축기를 확인해 보세요.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>지원 키</h1><ul><li>모든 영문, 숫자 및 기호</li><li>shift, ctrl, alt, command, mod (Windows/Linux의 ctrl, Mac의 command)</li><li>enter, esc, space, tab, pageup, pagedown, end, home, ins, del, backspace</li></ul><h1>지원 기능</h1><ul><li>키 조합: ctrl+m</li><li>복수 키: m,ctrl+m</li><li>키 시퀀스: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => '글로벌 바로가기',
    'LBL_CONTEXTUAL_SHORTCUTS' => '상황별 바로가기',
    'LBL_SHORTCUT_KEY_KEY' => '키',
    'LBL_SHORTCUT_FUNCTION' => '기능',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => '상황별 구성 바로가기',
    'LBL_SHORTCUT_CONFIG_DISABLED' => '구성할 &#39;상황별 바로가기&#39;가 없음',
    'LBL_SHORTCUT_HELP' => '단축키 도움 페이지 보여주기',
    'LBL_SHORTCUT_QUICK_CREATE' => '빠른 생성 메뉴',
    'LBL_SHORTCUT_SEARCH' => '글로벌 검색 필드에 집중',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => '사이드바 토글',
    'LBL_SHORTCUT_CREATE_RECORD' => '새로운 기록 생성',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => '목록에서 다음 기록 선택',
    'LBL_SHORTCUT_NAVIGATE_UP' => '목록에서 이전의 기록 선택',
    'LBL_SHORTCUT_SCROLL_LEFT' => '목록을 왼쪽으로 스크롤',
    'LBL_SHORTCUT_SCROLL_RIGHT' => '목록을 오른쪽으로 스크롤',
    'LBL_SHORTCUT_OPEN' => '목록에서 선택된 기록 열기',
    'LBL_SHORTCUT_EDIT_SELECTED' => '목록에서 선택된 기록 편집',
    'LBL_SHORTCUT_RECORD_DELETE' => '기록 삭제',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => '저장하지 않고 목록 인라인 편집에서 빠져나오기',
    'LBL_SHORTCUT_RECORD_SAVE' => '기록 저장',
    'LBL_SHORTCUT_RECORD_CANCEL' => '기록 변경 제거',
    'LBL_SHORTCUT_FAVORITE_RECORD' => '즐겨찾기로 기록 표시',
    'LBL_SHORTCUT_FOLLOW_RECORD' => '기록 팔로우',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => '기록 미리보기',
    'LBL_SHORTCUT_MARK_SELECTED' => '선택된 기록 표시',
    'LBL_SHORTCUT_SELECT_ALL' => '모두 선택',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => '매스 작업 드롭다운 메뉴 열기',
    'LBL_SHORTCUT_FILTER_SEARCH' => '목록 필터 필드 포커스온',
    'LBL_SHORTCUT_FILTER_CREATE' => '새로운 목록 필터 생성',
    'LBL_SHORTCUT_FILTER_EDIT' => '현재 목록 필터 열기',
    'LBL_SHORTCUT_FILTER_SHOW' => '목록 필터 메뉴 열기',
    'LBL_SHORTCUT_RECORD_EDIT' => '기록 편집',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => '이전 기록 열기',
    'LBL_SHORTCUT_RECORD_NEXT' => '다음 기록 열기',
    'LBL_SHORTCUT_COPY_RECORD' => '현재 레코드 복사',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => '주요 작업 드롭다운 메뉴 열기',
    'LBL_SHORTCUT_CLOSE_DRAWER' => '드로어 닫기',
    'LBL_SHORTCUT_FILTER_ADD' => '필터에 추가적인 범주 추가',
    'LBL_SHORTCUT_FILTER_REMOVE' => '필터에서 마지막 범주 제거',
    'LBL_SHORTCUT_FILTER_CLOSE' => '필터 닫기',
    'LBL_SHORTCUT_FILTER_SAVE' => '필터 저장',
    'LBL_SHORTCUT_FILTER_DELETE' => '필터 삭제',
    'LBL_SHORTCUT_FILTER_RESET' => '필터 재설정',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => '열 추가',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => '열 제거',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => '매스 업데이트 닫기',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => '업데이트 기록',
    'LBL_CREATE_CATEGORY' => '<div class="btn-link" data-action="create-new">category</div> 생성',
    'LBL_SHORTCUT_ALERT_CONFIRM' => '확인',
    'LBL_SHORTCUT_ALERT_CANCEL' => '취소',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => '다중 선택 필드에서 전체 항목 선택',
    'LBL_SHORTCUT_SWEETSPOT' => '스윗 스폿 바 토글 전환',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => '스윗 스폿 바 숨기기',
    'LBL_SHORTCUT_SAVE_CONFIG' => '구성사항 저장',
    'LBL_SHORTCUT_RESTORE' => '기본값으로 복원',
    'LBL_SHORTCUT_CONFIG_ERROR' => '서버에서 사용자 지정 단축 키를 저장하는 동안 오류가 발생했습니다. 다시 시도 하십시오.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}} 설정',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}} 구성 설정이 저장되었습니다.',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} 구성 오류',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}}은 구성 설정이 없습니다',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => '사용자에게 액세스 권한이없는 {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => '사용자는 {{module}} 설정을 구성 할 수 액세스 할 수 없습니다',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => '{{module}} 고정 될 필요를위한 데이터베이스 설정',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => '~',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => '시작 및 종료 날짜',

    'LBL_CALENDAR_START_DATE' => '시작 날짜',
    'LBL_CALENDAR_END_DATE' => '종료 날짜',
    'LBL_CALENDAR_DURATION' => '지속',
    'LBL_CALENDAR_RECURRENCE' => '재발생',
    'LBL_CALENDAR_REMINDERS' => '미리 알림',

    'LBL_CALENDAR_CUSTOM_DATE' => '사용자 정의 일자',
    'LBL_CALENDAR_REPEAT_TYPE' => '반복 유형',
    'LBL_CALENDAR_REPEAT_INTERVAL' => '간격을 반복',
    'LBL_CALENDAR_REPEAT_DOW' => '요일에 반복',
    'LBL_CALENDAR_REPEAT_ON' => 'Repeat On',
    'LBL_CALENDAR_REPEAT' => '반복',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => '때까지 반복',
    'LBL_CALENDAR_REPEAT_COUNT' => '반복 발생',
    'LBL_CALENDAR_REPEAT_SELECTOR' => '반복 지정',
    'LBL_CALENDAR_REPEAT_DAYS' => '일',
    'LBL_CALENDAR_REPEAT_MONTH' => '연중 월',
    'LBL_CALENDAR_REPEAT_ORDINAL' => '순위별 반복',
    'LBL_CALENDAR_REPEAT_UNIT' => '단위별 반복',
    'TPL_REPEAT_INTERVAL' => '{{repeatIntervalValue}} {{repeatTypeValue}}마다',
    'LBL_UNSUPPORTED_RRULE' => '이 시리즈는 시리즈가 캘린더 클라이언트에서 동기화되었으므로 Sugar에서는 사용할 수 없는 Repeat On 옵션을 사용합니다. 특정 날짜에 이 시리즈를 계속 반복하려면 캘린더 클라이언트에서 이 시리즈를 편집하세요. Sugar에서 이 시리즈를 편집하면 Repeat On이 없음으로 설정됩니다.<br><br>계속하시겠습니까?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => '되풀이 변화는 시리즈의 첫 번째 레코드를 사용해야합니다.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => '반복 규칙은 이벤트를 신규로 생성하지 않습니다.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => '출석',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => '거부',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => '임시',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => '답글 없음',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => '사용할 수없는 일정',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => '사용 가능한 보기',
    'LBL_CALENDAR_DASHLET_NAME' => '캘린더 일정',
    'LBL_CALENDAR_DEFAULT_VIEW' => '기본 보기',
    'LBL_CALENDAR_MY_CALENDARS' => '내 캘린더',
    'LBL_CALENDAR_OTHER_CALENDARS' => '사용자 및 팀 캘린더',
    'LBL_CALENDAR' => '캘린더',

    'LBL_CALENDAR_DAY' => '일',
    'LBL_CALENDAR_WEEK' => '주',
    'LBL_CALENDAR_MONTH' => '월',
    'LBL_CALENDAR_YEAR' => '년',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61st',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98일',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99일',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => '일정을 검색하는 동안 오류 발생.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => '저장하고 초대 보내기',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => '상태 수락',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => '프로세스',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => '프로세스 대쉬렛으로 SugarBPM에 사용된 템플릿을 보여줍니다.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => '프로세스 정의',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => '프로세스 정의 대쉬렛으로 SugarBPM에 사용된 템플릿을 보여줍니다.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => '프로세스 정의 만들기',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => '가져 오기 프로세스 정의',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => '프로세스 비즈니스 규칙',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => '프로세스 비즈니스 규칙 대쉬렛으로 SugarBPM에 사용된 템플릿을 보여줍니다.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => '프로세스 업무 규칙 생성',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => '가져 오기 프로세스 비즈니스 규칙',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => '프로세스 이메일 템플릿',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => '프로세스 이메일 템플릿 대쉬렛으로 SugarBPM에 사용된 템플릿을 보여줍니다.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => '프로세스 이메일 템플릿 만들기',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => '가져 오기 프로세스 이메일 템플릿',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => '다른 Sugar 인스턴스에서 프로세스/비즈니스 규칙/이메일 템플릿을 개발할 때, 인스턴스가 귀하의 생산 시스템의 정확한 복제가 되도록 할 것을 강력히 권장합니다. Sugar의 독립 인스턴스 내 구축된 프로세스/비즈니스 규칙/이메일 템플릿은 완료 사항을 들여오기 한 후에는 바라는 대로 기능하지 못합니다. 프로세스/비즈니스 규칙/이메일 템플릿은 특정 스튜디오 또는 애플리케이션 수준의 변경에 따라 달라질 수 있으며, 이에는 사용자 정의 필드 이름, 드롭다운 값, 데이터베이스 ID 등을 포함하나 이에 국한하지 않습니다. 만일 이러한 값들이 프로세스/비즈니스 규칙/이메일 템플릿이 구축된 인스턴스와 동일하지 않는 경우, 대상 인스턴스에 프로세스/비즈니스 규칙/이메일 템플릿을 수동으로 재구축해야 할 수도 있습니다.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => '정말 이 들여오기를 이용하여 진행하시겠습니까?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => '정말 이 내보내기를 이용하여 진행하시겠습니까?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => '다음의 드롭다운 필드에 유효하지 않은 옵션이 포함되어 있음',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => '프로세스에 의한 보류 활동',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => '보류 활동',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => '프로세스에 의한 보류 활동',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => '모든 프로세스',
    'LBL_RECORD_DASHBOARD' => '기록 대시보드',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => '프로세스 상태 요약',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => '프로세스 상태 설명',

    'LBL_PMSE_IN_PROGESS_STATUS' => '진행 중',
    'LBL_PMSE_COMPLETED_STATUS' => '완료',
    'LBL_PMSE_CANCELLED_STATUS' => '취소',
    'LBL_PMSE_TERMINATED_STATUS' => '종료',
    'LBL_PMSE_ERROR_STATUS' => '오류',
    'LBL_PMSE_SETTINGS' => 'SugarBPM 설정',

    'LBL_PRO_DISABLE_CONFIRMATION' => '이 기록을 해제 하시겠습니까?',
    'LBL_PRO_ENABLE_CONFIRMATION' => '이 기록을 활성화하시겠습니까?',
    'LBL_PRO_DELETE_CONFIRMATION' => '이 기록을 삭제 하시겠습니까?',

    'LBL_PRO_ENABLE' => '업데이트',
    'LBL_PRO_DISABLE' => '업데이트',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}}가 프로세스의 일부로 진행중이며 일부 잠긴 필드를 포함할 수 있습니다. 기록을 편집하려면, {{link}}를 클릭하십시오.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => '이 필드는 현재 실행중인 프로세스에 연관되어 있으므로 잠겨 있습니다.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => '이 기록은 프로세스의 일부로 진행중이며 일부 잠긴 필드를 포함할 수 있습니다.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => '업무 센터',
    'LBL_BUSINESS_CENTER_ID' => '업무 센터 ID',
    'LBL_BUSINESS_CENTER_NAME' => '업무 센터 이름',

    'LBL_PLIS_ACTIVITIES' => '구매한 라인아이템 활동',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(새로운 태그)',
    'LBL_TAG_FETCH_ERROR' => '태그를 가져오는 동안 오류가 발생했습니다.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => '슈가 CRM은 자바 스크립트를 필요로합니다. 슈가 CRM을 계속 사용하려면 자바 스크립트 (JavaScript)를 설치해주십시오.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => '데이터 직렬화를 취소할 수 없습니다',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => '데이터에 개체 또는 클래스에 대한 참조가 포함되어 있어서 데이터 직렬화를 취소할 수 없습니다',

    'LBL_FIELD_TRIMMED' => '최대 문자 한도를 초과하여 필드를 줄였습니다.',
    'LBL_FIELDSIZE_OVERFLOW' => '필드가 최대 문자수 제한을 초과합니다.',
    'LBL_TINYMCE_TARGET_SAME' => '같은 창',
    'LBL_TINYMCE_TARGET_NEW' => '새 창',

    'LBL_OUTBOUND_EMAILS' => '이메일 설정',
    'LBL_OUTBOUND_EMAIL' => '이메일 설정',

    'LBL_EMAIL_PARTICIPANTS' => '이메일 참가자',
    'LBL_EMAIL_PARTICIPANT' => '이메일 참가자',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => '데이터 프라이버시',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => '데이터 프라이버시',
    'LBL_DATAPRIVACY_VIEW_PII' => '데이터 프라이버시',
    'LBL_DATAPRIVACY_MARKFORERASE' => '삭제하기로 표시',
    'LBL_DATAPRIVACY_FIELDNAME' => '필드',
    'LBL_DATAPRIVACY_VALUE' => '값',
    'LBL_DATAPRIVACY_CHANGED_BY' => '변경됨',
    'LBL_DATAPRIVACY_SOURCE' => '소스',
    'LBL_DATAPRIVACY_CHANGE_DATE' => '마지막 업데이트',
    'LBL_DATAPRIVACY_PII' => '개인 정보',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => '삭제하기로 표시',
    'TPL_DATAPRIVACY_PII_TITLE' => '{{{name}}}의 개인 정보',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => '타이머 변경',
    'LBL_MESSAGES_SUBPANEL_TITLE' => '메시지',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => '클립보드에 복사되었습니다!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => '클립보드에 복사할 수 없습니다',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => '확인 링크 복사',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => '타임라인',
    'LBL_NO_ACTIVITY' => '활동 없음',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} 타임라인',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => '더보기',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => '간단히 보기',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => '타임라인에는 현재 기록의 관련 기록과 시간 경과에 따른 선택 필드 업데이트가 표시됩니다.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => '더 보기...',
    'LBL_COMMENT_LOG_SHOW_LESS' => '메뉴 접기...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => '사용 가능한 일자가 없음',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => '모듈 라이센스가 없습니다.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => '구독 활성화',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => '이 대쉬릿은 단일 계정에 연결된 모듈에만 추가할 수 있습니다. 자세한 내용은 <a href={{linkToDocumentation}}>활성 구독 대쉬릿</a> 문서를 참조하십시오.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => '이 연결된 계정에 속하는 구매 표시:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => '특정 계정의 구독을 활성화합니다.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', 재고 {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => '합계:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => '활성화된 구독 없음',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => '이 대시렛이 작동하려면 {{module_name}}이(가) 필요합니다. {{module_name}}을(를) 활성화하려면 관리자와 연락하세요.',
    'LBL_PURCHASE_HISTORY_DASHLET' => '구매 내역',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => '특정 계정의 모든 구매.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => '이 대쉬릿은 단일 계정에 연결된 모듈에만 추가할 수 있습니다. 자세한 내용은 <a href={{linkToDocumentation}} target="_blank">구매 내역 대쉬릿</A> 문서를 참조하십시오.',
    'LBL_NO_PURCHASE_HISTORY' => '표시할 구매가 없음',
    'LBL_NO_PLIS' => '구매한 라인아이템 없음',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => '합계',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => '수량',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => '이 대쉬릿이 작동하려면 구매 및 구매한 라인아이템이 필요합니다. 관리자에게 구매 및 구매한 라인아이템 활성화에 대해 문의하십시오.',
    'LBL_SEARCH_PURCHASE_NAME' => '구매명으로 검색...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => '다음으로 이동하여 레코드 보기 대시렛 레이아웃을 편집할 수 있도록 Studio를 사용하십시오.' .
        'Studio > {{module}} > 레이아웃 > 기록 보기 대시렛. <a href={{linkToStudio}}>Studio에서 편집하기</a>.',
    'LBL_SERVICE_LEVEL' => '서비스 수준',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => '숫자',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => '후속 조치',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => '우선순위/상태',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => '제목/설명',

//Service Duration
    'LBL_SERVICE_DURATION' => '서비스 기간',
    'LBL_SERVICE_DURATION_VALUE' => '서비스 기간 값',
    'LBL_SERVICE_DURATION_UNIT' => '서비스 기간 단위',
    'LBL_LOCK_DURATION' => '잠금 기간',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Amazon Connect CCP를 로드할 수 없습니다.' .
        '사용하시는지 확인해 주십시오' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">지원되는 브라우저</a>.' .
        '문제가 지속되면 Sugar 관리자에게 문의하십시오.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Sugar 관리자가 Amazon Connect에 대한 인스턴스를 구성하지 않았습니다.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Amazon Connect와 연결할 수 없습니다. 도움이 필요하시면 Sugar 관리자에게 문의하십시오.',
    'LBL_OMNICHANNEL_UNKNOWN' => '알 수 없음',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => '포커스 서랍',
    'LBL_CLOSE_FOCUS_DRAWER' => '포커스 서랍 닫기',
    'LBL_EXTERNAL_GUESTS' => '외부 게스트',
    'LBL_MY_FAVORITE_TASKS' => '내 즐겨찾는 작업',
    'LBL_RECORD' => '기록',

    'LBL_MY_TASKS' => '내 작업',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => '필드 찾을 수 없음: {0} (모듈 {1})',
    'LBL_INTEGRATE_INVALID_PARAM' => '{0}의 레코드 찾을 수 없음: {1} (모듈 {2})',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => '다음 이름의 관계를 찾을 수 없음: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => '데이터베이스 엔트리 ID: {0} 및 {1}: {2} (모듈 {3}) 이미 존재',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => '소프트 삭제 (삭제 플래그 = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => '모듈 {2}에서 {0} {1}에 대한 여러 데이터베이스 레코드를 찾았습니다. ' .
        '일치하는 레코드를 제거하거나 업데이트하십시오. 일치하는 레코드: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => '다음 실행',
    'LBL_TIME_AWARE_TYPE' => '유형',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => '라벨 표시',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => '기록 보기 열기',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => '추가하기',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => '도움말 사용 불가',
    'LBL_ACTIONBUTTON_FUNCTIONS' => '기능',
    'LBL_ACTIONBUTTON_FIELDS' => '필드',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => '필드 선택...',
    'LBL_ACTIONBUTTON_ROLLUP' => '롤업',
    'LBL_ACTIONBUTTON_RELATED' => '관련',
    'LBL_ACTIONBUTTON_SAVE' => '저장',
    'LBL_ACTIONBUTTON_CANCEL' => '취소',
    'LBL_ACTIONBUTTON_R_MODULE' => '연관 모듈',
    'LBL_ACTIONBUTTON_R_FIELDS' => '관련 필드',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => '모듈 롤업',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => '필드 롤업',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => '기능 롤업',
    'LBL_ACTIONBUTTON_MINIMUM' => '최소',
    'LBL_ACTIONBUTTON_MAXIMUM' => '최대',
    'LBL_ACTIONBUTTON_AVERAGE' => '평균',
    'LBL_ACTIONBUTTON_SUM' => '합계',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => '기록 할당',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => '이메일 작성',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => '기록 만들기',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => '문서 병합',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'URL 열기',
    'LBL_ACTIONBUTTON_RUN_REPORT' => '보고서 실행',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => '기록 업데이트',
    'LBL_ACTIONBUTTON_ACTION' => '액션',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => '할당',
    'LBL_ACTIONBUTTON_EMAIL_TO' => '에 이메일',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'PMSE 사용',
    'LBL_ACTIONBUTTON_TEMPLATE' => '템플릿',
    'LBL_ACTIONBUTTON_MODULE' => '모듈',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => '화면 설정',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => '유형',
    'LBL_ACTIONBUTTON_DROPDOWN' => '드롭다운',
    'LBL_ACTIONBUTTON_BUTTON' => '버튼',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => '버튼 그룹',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => '기록에 레이블 표시',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => '헤더에 표시',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => '편집 시 숨기기',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => '포커스 대시보드 헤더에 표시',
    'LBL_ACTIONBUTTON_DASHBOARD' => '대시보드',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => '포커스 대시보드 헤더',
    'LBL_ACTIONBUTTON_SIZE' => '크기',
    'LBL_ACTIONBUTTON_DEFAULT' => '기본설정',
    'LBL_ACTIONBUTTON_SMALL' => '작은',
    'LBL_ACTIONBUTTON_LARGE' => '큰',
    'LBL_ACTIONBUTTON_CALCULATED' => '계산됨',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'PDF로 변환',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => '문서 병합',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => '미리 보기',
    'LBL_ACTIONBUTTON_PROPERTIES' => '소유권',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => '라벨',
    'LBL_ACTIONBUTTON_DESC' => '툴팁',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => '라벨 표시',
    'LBL_ACTIONBUTTON_SHOW_ICON' => '아이콘 표시',
    'LBL_ACTIONBUTTON_SCHEME' => '색 구성표',
    'LBL_ACTIONBUTTON_ICON' => '아이콘',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => '의존',
    'LBL_ACTIONBUTTON_DESIGN' => '레이아웃 구성',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => '오류 발생 시 중지',
    'LBL_ACTIONBUTTON_AUTOSAVE' => '자동 저장',
    'LBL_ACTIONBUTTON_CONFIG' => '구성',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => '액션버튼 설정 후 저장해 주십시오.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => '버튼 구성',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => '자동 생성',
    'LBL_ACTIONBUTTON_LINK' => '상위와의 관계 만들기',
    'LBL_ACTIONBUTTON_COPY_PARENT' => '상위 값 복사',
    'LBL_ACTIONBUTTON_PRESET' => '필드 값 설정',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => '상위로부터 필드 값 복사',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => '선택...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => '상위 필드에서',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => '이 버튼을 삭제하시겠습니까?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => '이 액션을 삭제하시겠습니까?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => '잘못된 작업 버튼 데이터',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => '저장 전 모듈을 선택하십시오.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => '저장 전 링크를 선택하십시오. 사용 가능한 링크가 없으면 링크 옵션 선택을 취소하십시오.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => '저장 전 기록을 선택하십시오.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => '저장 전 템플릿을 선택하십시오.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => '주요',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => '보조',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => '바다',
    'LBL_ACTIONBUTTON_THEME_PINK' => '핑크',
    'LBL_ACTIONBUTTON_THEME_ARMY' => '밀리터리',
    'LBL_ACTIONBUTTON_THEME_TEAL' => '청록',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => '태평양',
    'LBL_ACTIONBUTTON_THEME_GREEN' => '녹색',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => '노랑',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => '오렌지',
    'LBL_ACTIONBUTTON_THEME_RED' => '빨강',
    'LBL_ACTIONBUTTON_THEME_CORAL' => '코럴',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => '보라',
    'LBL_ACTIONBUTTON_FORMULA' => '포뮬러',
    'LBL_ACTIONBUTTON_ACTIONS' => '액션',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => '버튼 데이터 인증 오류.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => '버튼에는 라벨이나 아이콘 세트가 최소 하나 있어야 합니다.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => '유효한 버튼 라벨을 입력해 주십시오.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => '필수 값이 누락되어 기록을 생성할 수 없었습니다. 관리자에게 연락하십시오.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => '이 버튼 유형에는 활성화 버튼 최소 두 개가 있어야 합니다.',
    'LBL_ACTIONBUTTON_RECORD' => '기록 보기',
    'LBL_ACTIONBUTTON_ACTION_MENU' => '액션 메뉴',
    'LBL_ACTIONBUTTON_ORDER' => '주문',
    'LBL_ACTIONBUTTON_LIST_VIEW' => '목록 보기',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => '기록 보기 헤더',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => '기록 보기 대시렛 헤더',
    'LBL_ACTIONBUTTON_SUBPANELS' => '하위 패널',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => '작업 순서 실행 엔진이 다음 작업을 실행하지 못했습니다.',
    'LBL_ACTIONBUTTON_ADD_ACTION' => '액션 추가',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => '이 액션 제거',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => '현 사용자',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => '문서 병합',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'PDF로 문서 병합',

    //hint
    'LBL_HINT_COMPANY_SIZE' => '회사 규모',
    'LBL_HINT_COMPANY_INDUSTRY' => '산업',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => '산업 태그',
    'LBL_HINT_COMPANY_LOCATION' => '회사 위치',
    'LBL_HINT_COMPANY_DESCRIPTION' => '회사 설명',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => '설립 연도',
    'LBL_HINT_COMPANY_FACEBOOK' => '회사 Facebook',
    'LBL_HINT_COMPANY_TWITTER' => '회사 Twitter',
    'LBL_HINT_COMPANY_PIC' => '회사 로고',
    'LBL_HINT_CONTACT_PIC' => '연락처 사진',
    'LBL_HINT_COMPANY_WEBSITE' => '회사 웹사이트',
    'LBL_HINT_PHOTO' => '사진 링크',
    'LBL_HINT_JOB_2' => '이전 작업',
    'LBL_HINT_EDUCATION' => '교육',
    'LBL_HINT_EDUCATION_2' => '추가 교육',
    'LBL_HINT_TWITTER' => 'Twitter 링크',
    'LBL_HINT_FACEBOOK' => 'Facebook 링크',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS 코드',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC 코드',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => '회계연도 종료',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => '연 수익',
    'LBL_HINT_PHONE_1' => '전화 1',
    'LBL_HINT_PHONE_2' => '전화 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => '표 병합',
    'LBL_HINT_FULL_NAME' => '전체 이름',
    'LBL_HINT_JOB_TITLE' => '직책',
    'LBL_HINT_OFFICE_PHONE' => '사무실 전화번호',
    'LBL_HINT_MOBILE_PHONE' => '휴대폰',
    'LBL_HINT_OTHER_PHONE' => '기타 전화번호',
    'LBL_HINT_WEBSITE' => '웹사이트',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'Sugar Hint에서 찾은 새 데이터로 이 레코드의 기존 데이터를 모두 덮어쓰시겠습니까?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'Sugar Hint에서 찾은 새 {{fieldName}}(으)로 이 레코드의 기존 {{fieldName}}을(를) 덮어쓰시겠습니까?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => '모든 계정 관련 데이터가 삭제됩니다. 계속하시겠습니까?',
    'LBL_HINT_COMPANY_LOGO' => '로고',
    'LBL_HINT_CONTACTS_AVATAR' => '사진',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint 계정 세트 태그',

    'LBL_HINT_LOADING' => '로딩 중...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Sugar Hint를 삭제 중입니다. 기다려 주십시오',
    'LBL_HINT_VALUE_ERASED' => '값 삭제',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => '이 정보는 데이터 프라이버시 요청을 통해 삭제되었습니다.',

    'LBL_HINT_UNINSTALL_TITLE' => '아래에서 삭제 옵션 중 하나를 선택하십시오.',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Hint 패키지만 삭제',
    'LBL_HINT_UNINSTALL_FULL' => 'Hint를 완전히 삭제',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => '이 옵션을 선택하면 Hint MLP가 삭제되고 Sugar Hint Insights에 대한 모든 활성 구독이 비활성화됩니다.
    Hint를 재설치하면 자동으로 구독을 재활성화합니다.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => '이 옵션은 MLP의 삭제와 모든 구성 및 구독 정보의 삭제를 포함하여 Hint의 전체 삭제를 수행합니다.',
    'LBL_HINT_UNINSTALL' => '설치해제',
    'LBL_HINT_UNINSTALL_HEADER' => 'Sugar Hint 삭제',
    'LBL_HINT_CANCEL' => '취소',
    'LBL_HINT_UNINSTALL_WARNING1' => '주의: 이 옵션은 Hint를 앞으로 사용하지 않을 예정일 때만 선택해 주십시오.
    삭제 전 Sugar 데이터베이스를 모두 백업하고 Sugar를 유지관리 모드로 변환해 주십시오.',
    'LBL_HINT_UNINSTALL_WARNING2' => '확인:',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint 관리 가이드', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => '(삭제 진행 과정 정보)',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Sugar Hint 패키지만 삭제하시겠습니까?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Sugar Hint를 완전히 삭제하시겠습니까?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(참고: 이 작업은 실행 취소할 수 없습니다.)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint 필드',
    'LBL_HINT_NO_RESULTS_MSG' => '검색결과가 없습니다.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => '기본 Hint 패널 레이아웃',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => '거래처',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => '연락처',
    'LBL_HINT_CONFIG_TAB_LEADS' => '관심고객',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => '확장된 Hint 패널 레이아웃',
    'LBL_HINT_CONFIG_DIR_PAR1' => '위의 Hint 패널 레이아웃 섹션 내에서 끌어 놓아 필드를 다시 정렬합니다.',
    'LBL_HINT_CONFIG_DIR_PAR2' => '자세한 지침 및 기본 필드 목록은 다음 참조:',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => '이 링크를 사용해 기본 설정 복구',
    'LBL_HINT_CONFIG_MODULE_TEXT' => '모듈',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => '{{module}} 모듈의 기본값으로 복구하시겠습니까?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => '여기를 클릭하십시오',
    'LBL_HINT_CONFIG_NAME' => 'Hint 관리 가이드.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => '필드',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => '보강된 필드',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => '이 섹션에는 Hint로 보강된 모든 Hint 필드와 Sugar 필드가 나열되어 있습니다. Hint 필드는 별표(*)로 표시되며, 보강된 경우 Hint 패널에만 표시됩니다.',
    'LBL_HINT_CONFIG_FIELD_NAME' => '필드명',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => '필드 보강',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Hint에서 표시',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Hint 패널에서 표시',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => '추가 Sugar 필드',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => '이 섹션에는 Hint로 보강되지 않은 모든 Sugar 필드가 표시되어 있습니다.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => '경고',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => '주의: Sugar Hint Insights 서비스와 동기화하려고 합니다. 보류 중인 모든 이메일 다이제스트 스토리가 손실되고 기존 뉴스가 Insights 대쉬릿에서 삭제됩니다. 동기화가 완료되면 모든 유형의 알림이 다시 시작됩니다.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => '{{_moduleSingular}}과(와) 관련된 추천 회사가 아래에 나열되어 있습니다. 표시할 회사 데이터를 선택합니다.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => '선택한 계정 없음',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => '여러 이메일을 찾았습니다. 가져올 이메일을 선택하십시오.',

    'LBL_HINT_HELP_MESSAGE1' => '입력한 데이터에 따라 Hint는 시스템에서 일치하는 항목을 찾지 못했습니다.',
    'LBL_HINT_HELP_MESSAGE2' => 'Hint의 가장 좋은 결과는 사람 이름과 이메일 주소로 찾을 수 있습니다.',
    'LBL_HINT_HELP_MESSAGE3' => 'Hint의 가장 좋은 결과는 회사 웹사이트 URL로 찾을 수 있습니다.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "{{_moduleSingular}}의 회사 이름이나 웹사이트를 입력하면 Hint에서 추가 데이터가 검색됩니다.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "{{currentModule}}의 이메일 주소를 입력하면 Hint에서 추가 데이터가 검색됩니다.",

    'LBL_HINT_HISTORY_NONE' => '내역 보기에 사용할 수 있는 데이터 없음',
    'LBL_HINT_HISTORY_TITLE' => '활동 내역',

    'LBL_HINT_PREVIEW_TITLE' => '데이터 보강',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Hint 서비스 라이센스가 만료되었습니다. 라이센스를 갱신하려면 SugarCRM 관리자에게 문의하십시오.',
    'LBL_HINT_PREVIEW_QUESTION' => 'Hint로 여러분과 회사가 얻을 수 있는 이익을 알고 싶으십니까? SugarCRM 관리자에게 문의하여 Hint를 추가하십시오.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => '계정 정보 찾을 수 없음',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => '보강된 데이터 검색됨 - 클릭하여 보강된 데이터 모두를 레코드에 저장합니다.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => '클릭하여 보강된 데이터를 레코드에 저장합니다.',

    'LBL_HINT_CONTACTS_TITLE' => '관련 연락처',
    'LBL_HINT_CONTACTS_NONE' => '관련 연락처 없음',

    'LBL_HINT_NEWS' => '뉴스',
    'LBL_HINT_GENERAL' => '일반',
    'LBL_HINT_ALL_NEWS' => '모든 뉴스',
    'LBL_HINT_FILTER_NEWS' => '뉴스 필터',
    'LBL_HINT_FINANCIAL_NEWS' => '금융',
    'LBL_HINT_PERSONNEL_NEWS' => '직원',
    'LBL_HINT_PRESS_RELEASES' => '보도자료',
    'LBL_HINT_OTHER_NEWS' => '기타',
    'LBL_HINT_NEWS_PLACEHOLDER' => '뉴스 기사 검색',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => '뉴스 없음',
    'LBL_NEW_NOTIFICATIONS' => '새 알림',
    'LBL_HINT_DASHLET_ALLOWED1' => 'Sugar Hint Insights 대쉬릿을 보려면 Sugar Hint 라이선스가 있어야 합니다.
    Sugar Hint 라이선스 획득 방법은 관리자에게 문의하십시오.',

    'LBL_HINT_FOR' => '대상',
    'LBL_HINT_WITH' => '및',
    'LBL_HINT_SHOW_ME' => '보기:',
    'LBL_HINT_NOTIFY_ME_BY' => '알림 방법:',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insights 설정 센터',
    'LBL_NOTIFICATIONS_KEY_TITLE' => '설정 옵션 키',
    'LBL_HINT_PREFERENCES' => '우선권',
    'LBL_HINT_MINIMUM_PREFERENCES' => '삭제할 수 없습니다. 기본 설정 선언이 최소 하나 필요합니다.',
    'LBL_HINT_MAXIMUM_PREFERENCES' => '추가할 수 없습니다. 기본 설정 선언 수가 최대입니다.',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Sugar Hint Insights 대쉬릿에 포함',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => '바탕화면 알림으로 팝업 표시',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => '알림을 지속적으로 수신하려면 모든 브라우저와 모든 데스크톱 컴퓨터에서 알림을 활성화해야 합니다.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Internet Explorer와 같은 일부 브라우저에서는 알림을 지원하지 않습니다. 알림을 지원하지 않는 브라우저를 사용하면 알림을 활성화할 수 없습니다.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => '각 알림에 대해 즉시 이메일 알림 전송',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => '매일 이메일 다이제스트 전송',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => '매주 이메일 다이제스트 전송',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => '설정을 저장할 수 없습니다. 시스템 연결을 확인하고 다시 시도하십시오.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => '일부 필수 필드에 값이 없습니다. 설정을 확인하고 모든 필수 필드가 입력되었는지 확인하십시오.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'Sugar Hint Insights의 브라우저 알림을 활성화하려고 합니다. 계속하려면 확인을 클릭하십시오. 그러면 브라우저에서 알림 이벤트 수신을 허용할 수 있는 권한을 요청합니다.',
    'LBL_HINT_PUSH_ERROR' => '푸시 알림 플러그인이 의존성 없이 {{options.type}}에 등록되었습니다. 플러그인이 의도대로 작동하지 않을 것입니다. 워커 파일에 경로와 서버에 구독을 저장하는 방법을 제공해야 합니다.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => '모든 사용자에 대한 Hint 알림 켜기',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => '모든 사용자에 대한 Hint 알림 끄기',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => '경고: Sugar Hint를 제거하는 동안 알림을 비활성화하지 못했습니다. 알림을 비활성화하려면 Sugar Hint 5.4.0 이상을 설치하고 Sugar의 관리 섹션에 있는 Hint Uninstaller를 사용하여 전체 Sugar 제거를 수행하십시오.',
    'LBL_HINT_ENRICH_ALL' => '모두 보강',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'Hint 라이선스 필요',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => '지도 구성',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => '지오코더 로그 뷰어',
    'LBL_MAP_MAP' => '지도',
    'LBL_MAP_MAPS' => '맵',
    'LBL_MAP_GEOCODING_RECORD' => '지오코드',
    'LBL_MAP_GEOCODE_SUCCESS' => '기록 지오코딩에 성공했습니다.',
    'LBL_MAP_LATITUDE' => '위도',
    'LBL_MAP_LONGITUDE' => '경도',
    'LBL_MAP_SEARCH_BY_ADDRESS' => '주소로 검색...',
    'LBL_MAP_ALREADY_GEOCODED' => '현재 기록이 이미 지오코딩되어 있습니다. 이 기록의 지오코딩을 덮어쓰시겠습니까?',
    'LBL_MAPS_MANUAL_GEOCODING' => '수동 지오코딩',
    'LBL_MAP_POINT_COORDINATES' => '맵 지점 좌표',
    'LBL_MAP_CALCULATING_DIRECTIONS' => '최적 경로 계산 중...',
    'LBL_MAP_DIRECTIONS' => '지시',
    'LBL_MAP_DIRECTIONS_FROM_USER' => '현재 사용자에서 시작하는 방향',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => '이 레코드에서 시작하는 방향',
    'LBL_MAPS_RADIUS_INPUT' => '반경(0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => '우편번호 기준 반경',
    'LBL_MAPS_DISTANCE' => '거리',
    'LBL_MAPS_CENTER_ZIP_CODE' => '우편번호',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => '잘못된 구성:',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> 필드 매핑이 잘못되었습니다.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => '지도 유형',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => '확대 레벨',
    'LBL_MAPS_DASHLET' => '맵',
    'LBL_MAPS_DASHLET_DESCRIPTION' => '지도에 지오코딩된 기록을 표시합니다.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => '이 모듈에는 지도를 사용할 수 없습니다. 관리 콘솔에서 활성화하십시오.',
    'LBL_MAP_MODULES' => '모듈',
    'LBL_MAP_FILTER_BY' => '필터 기준',
    'LBL_MAP_UNIT_TYPE' => '단위 유형',
    'LBL_MAP_UNIT_TYPE_MILES' => '마일',
    'LBL_MAP_UNIT_TYPE_KM' => '킬로미터',
    'LBL_MAP_ADDRESS' => '주소',
    'LBL_MAP_NO_STARTING_POINT' => '지오코딩되지 않은 시작점입니다.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => '시작점 기록이 지오코딩되지 않았습니다.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => '선택한 기록 중 일부가 지오코딩되지 않았으며 지도에 표시되지 않습니다.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => '기록이 지오코딩되지 않습니다.',
    'LBL_MAPS_MODULE_FIELDS' => '모듈 필드',
    'LBL_MAPS_SELECT_FIELD' => '필드 선택',
    'LBL_MAPS_RELATE_RECORD' => '관련 기록',
    'LBL_MAPS_MAPPING_TYPE' => '지도 유형',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => '지오코딩된 기록 없음',
    'LBL_MAPS_ADDRESS' => '주소',
    'LBL_MAPS_ASSIGNED_USER_NAME' => '할당된 사용자',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => '지정된 지점에 거리 사이드 보기를 사용할 수 없습니다',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> 기록은 매핑에 유효하지 않습니다. 목록에서 모듈을 제거하십시오.',
    'LBL_MAPS_CLOSE_TOOLTIP' => '닫기',
    'LBL_MAPS_EXPAND_TOOLTIP' => '확장',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'PDF로 저장',
    'LBL_MAPS_EMAIL_LINK' => '이메일 링크',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => '지오코드 기록이 최소 하나 있어야 합니다.',
    'LBL_MAPS_GENERATING' => '지도 생성 중...',
    'LBL_MAPS_POINTS' => '지도 지점',
    'LBL_MAPS_POINT' => '포인트',
    'LBL_MAPS_TRAVEL_DETAILS' => '이동 정보',
    'LBL_MAPS_TOTAL_DISTANCE' => '총 거리',
    'LBL_MAPS_TOTAL_DURATION' => '총 기간',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => '트래픽 없는 총 기간',
    'LBL_MAPS_ITINERARY' => '여정',
    'LBL_MAPS_TRAVEL_DISTANCE' => '이동 거리',
    'LBL_MAPS_TRAVEL_DURATION' => '이동 기간',
    'LBL_MAPS_TRAVEL_STEPS' => '단계',
    'LBL_MAPS_TRAVEL_WARNINGS' => '경고',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing 지도는 공유 지도에서 최대 10개의 핀포인트를 지원합니다. 선택 사항을 검토하십시오.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => '지도 라이선스 필요',
    'LBL_MAPS_SHARE_HELLO' => '안녕하세요.',
    'LBL_MAPS_SHARE_HEADER' => '다음 지점에 대한 Bing 지도를 요청하셨습니다.',
    'LBL_MAPS_SHARE_OPEN_URL' => '다음 URL에서 Bing Maps에서 위 지점이 포함된 지도가 열립니다.',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Bing Maps에 지도 표시',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => '제공된 웨이포인트에 대한 경로를 찾을 수 없습니다.',
    'LBL_MAPS_GEOCODE_STATUS' => '지오코드 상태',
    'LBL_MAPS_GEOCODED' => '지오코드 완료',
    'LBL_MAPS_NOT_GEOCODED' => '지오코딩되지 않음',
    'LBL_MAPS_NOT_FOUND' => '잘못된 주소',
    'LBL_MAPS_GEOCODING_FAILED' => '지오코딩 실패',
    'LBL_MAPS_QUEUED' => '대기',
    'LBL_MAPS_REQUEUED' => '재대기',
    'LBL_MAPS_RELATED_RECORD' => '관련 기록',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => '보고서 보기',
    'LBL_REPORT_DASHLET_DESC' => '저장된 보고서 표시',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => '대쉬릿 기본값으로 재설정',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => '보고서 기본값으로 재설정',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => '보고서 결과 새로고침',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => '차트를 클립보드로 복사',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => '차트 다운로드',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => '대쉬릿 {{label}} 보고서가 편집되었으며 해당 대쉬릿이 기본 구성으로 재설정되었습니다.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => '이 필드를 사용할 권한이 없습니다.',

    'LBL_INVALID_FORMULA' => '잘못된 포뮬러',
    'LBL_RETURN_TYPE_MISSMATCH' => '함수 반환 유형이 일치하지 않습니다',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => '예측',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => '이상적 고객 프로필',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => '마감 주간 예측 점수',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => '예측 값',
    'LBL_AI_CONV_BIN_ACCURACY' => '예측 빈 정확도',
    'LBL_AI_CONV_MULTIPLIER' => '예측 승수',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP 값',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP 빈 정확도',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP 승수',
    'LBL_AI_NEW' => '신규',
    'LBL_AI_ENTERED' => '입력됨',
    'LBL_AI_CREATED' => '생성 완료',
    'LBL_AI_WEEK' => '주',
    'LBL_AI_MONTH' => '월',
    'LBL_AI_QUARTER' => '분기',
    'LBL_AI_BYWEEK' => '주별',
    'LBL_AI_BYMONTH' => '월별',
    'LBL_AI_BYQUARTER' => '분기별',
    'LBL_AI_WEEKTREND' => '주별 추세',
    'LBL_AI_MONTHLYTREND' => '월별 추세',
    'LBL_AI_QUARTERTREND' => '분기별 추세',
    'LBL_AI_TREND' => '추세 기준',
    'LBL_AI_TRENDS' => '추세 기준',
    'LBL_AI_VELOCITY' => '속도',
    'LBL_AI_TOPX' => '상위 {X}',
    'LBL_AI_TIMESPAN' => '단계 간 시간 간격 -',
    'LBL_AI_BUSINESSTREND' => '비즈니스 추세 포함',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Sugar Insights를 소개합니다!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights는 정량적 분석을 활용하여 SugarCRM 데이터에 대한 새로운 통찰을 생성합니다. Sugar는 항상 데이터를 최대한 활용하고 정보에 입각한 결정을 내리는 데 도움이 되는 새로운 방법을 찾고 있으며, 이는 Sugar Insights로 제공하고자 하는 기능의 시작에 불과합니다.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights는 정량적 분석을 활용하여 SugarCRM 데이터에 대한 새로운 통찰을 생성합니다.',
    'LBL_AI_FIRMO' => '기업학',
    'LBL_AI_TOTALCOUNT' => '총 수',
    'LBL_AI_DAYSFROMLATESTACT' => '일(마지막 다음 날짜 이후)',
    'LBL_AI_DAYSSINCE' => '연령',
    'LBL_AI_FIELDISSET' => '존재함',
    'LBL_AI_CONTACTCOMPLETENESS' => '연락처 정보의 완전성',
    'LBL_AI_CUTDATE' => '예측 기간',
    'LBL_AI_FROMLASTCHANGE' => '일 경과(마지막 특징 값 변경 후)',
    'LBL_AI_CALLSHELD' => '총 보유 통화 수',
    'LBL_AI_CALLSPLANNED' => '총 계획된 통화 수',
    'LBL_AI_OUTBOUNDCALLS' => '총 아웃바운드 통화 수',
    'LBL_AI_INBOUNDCALLS' => '총 인바운드 통화 수',
    'LBL_AI_AVGCALLDURATION' => '평균 통화 시간',
    'LBL_AI_EMAILSARCHIVED' => '총 보관된 이메일 수',
    'LBL_AI_EMAILSREAD' => '총 읽은 이메일 수',
    'LBL_AI_EMAILSSENT' => '총 전송한 이메일 수',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => '예상 마감일이 이후 날짜로 변경된 총 기록 수',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => '예상 마감일이 이전 날짜로 변경된 총 기록 수',
    'LBL_AI_AMOUNTINCREASED' => '금액이 증가한 총 영업기회',
    'LBL_AI_AMOUNTDECREASED' => '금액이 감소한 총 영업기회',

    // User last state
    'LBL_LAST_STATE' => '마지막 상태',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'DocuSign에 전송',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => '수신자 편집 취소',
    'LBL_RECIPIENT_ROLE' => '수신인 역할',
    // Base sales stages
    'LBL_OPEN' => '최대화',
    'LBL_CLOSED_WON' => '계약 성공',
    'LBL_CLOSED_LOST' => '계약 실패',
    'LBL_KIOSK_ADD_FILES' => '파일 추가',
    'LBL_KIOSK_ADD_DROP_FILES' => '여기에 파일 추가 또는 드롭',
    'LBL_KIOSK_CANCEL' => '취소',
    'LBL_KIOSK_EDIT' => '편집',
    'LBL_KIOSK_EMAIL' => '이메일',
    'LBL_KIOSK_FILES_UPLOADING' => '업로드 중',
    'LBL_KIOSK_FILES_ERROR' => '첨부파일 업로드 실패',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => '첨부파일이 너무 큽니다',
    'LBL_KIOSK_FILTER_SEARCH' => '검색',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => '키오스크',
    'LBL_KIOSK_LANGUAGE' => '언어',
    'LBL_KIOSK_LAST_UPDATED' => '마지막 업데이트',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => '보기',
    'LBL_KIOSK_MENU' => '메뉴',
    'LBL_KIOSK_MOBILE_PHONE' => '휴대전화',
    'LBL_KIOSK_MY_ACTIVITIES' => '활동',
    'LBL_KIOSK_MY_PROFILE' => '프로필',
    'LBL_KIOSK_NAME' => '이름',
    'LBL_KIOSK_OFFICE_PHONE' => '사무실 전화번호',
    'LBL_KIOSK_ORGANIZATION' => '조직',
    'LBL_KIOSK_PAGINATION_FOOTER' => '페이지당 행 수:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'SugarCRM 제공',
    'LBL_KIOSK_SAVE_CHANGES' => '변경 저장하기',
    'LBL_KIOSK_SHOW_HIDE' => '표시/숨기기',
    'LBL_KIOSK_SIGN_IN' => '접속',
    'LBL_KIOSK_SIGN_OUT' => '로그아웃',
    'LBL_KIOSK_SORT_BY' => '정렬',
    'LBL_KIOSK_SUBMIT' => '제출',
    'LBL_KIOSK_TIMEZONE' => '시간대',
    'LBL_KIOSK_ACTIVITY' => '활동',
    'LBL_KIOSK_NO_ACTIVITY' => '표시할 활동 없음',
    'LBL_KIOSK_OLDEST_FIRST' => '오래된 순',
    'LBL_KIOSK_NEWEST_FIRST' => '최신순',
    'LBL_KIOSK_SHOW_MORE' => '더 보기',
    'LBL_KIOSK_ADD_A_REPLY' => '회신 추가',
    'LBL_KIOSK_REPLY_EMPTY' => '회신은 비워둘 수 없습니다.',
    'LBL_KIOSK_NUM_MORE' => '{{num}} 더 보기',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => '환영합니다',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => '리소스에 빠르게 액세스할 수 있습니다.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => '사례 검색',
    'LBL_KIOSK_SHOW_ALL' => '모두 보기',
    'LBL_KIOSK_404_TITLE' => '찾을 수 없음',
    'LBL_KIOSK_TENANT_404_TITLE' => '테넌트를 찾을 수 없습니다',
    'LBL_KIOSK_404_MESSAGE' => '삭제되었거나, 일시적으로 사용할 수 없는 링크를 클릭했거나, 잘못된 URL을 입력했습니다.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'URL이 올바른지 확인하십시오.추가 지원이 필요하시면 지원팀에 문의하십시오.',
    'LBL_KIOSK_BACK_TO_HOME' => '홈으로',
    'LBL_KIOSK_ERROR_CODE' => '{code} 오류: ',
    'LBL_KIOSK_401_TITLE' => '비인증',
    'LBL_KIOSK_401_MESSAGE' => '이 페이지를 볼 권한이 없습니다.',
    'LBL_KIOSK_403_TITLE' => '비인증',
    'LBL_KIOSK_403_MESSAGE' => '이 페이지를 볼 액세스 권한이 없습니다.',
    'LBL_KIOSK_500_TITLE' => '서버가 응답하지 않음',
    'LBL_KIOSK_500_MESSAGE' => '저희 쪽에서 문제가 발생했습니다.',
    'LBL_KIOSK_GO_BACK' => '뒤로',
    'LBL_KIOSK_DUPLICATE_ERROR' => '중복된 기록이 발견됨',
    'LBL_KIOSK_ACCOUNT' => '계정',
    'LBL_KIOSK_STATUS' => '상태',
    'LBL_KIOSK_DEACTIVATE' => '비활성화됨',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => '사용자가 비활성화되었습니다',
    'LBL_KIOSK_MANAGE_USERS' => '사용자 관리',
    'LBL_KIOSK_LAST_LOGIN' => '마지막 로그인',
    'LBL_KIOSK_FIRST_NAME' => '이름',
    'LBL_KIOSK_LAST_NAME' => '성',
    'LBL_KIOSK_ROLE' => '역할',
    'LBL_KIOSK_INVITE' => '초대',
    'LBL_KIOSK_SEND_INVITES' => '초대 전송',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => '초대를 성공적으로 전송 완료했습니다.',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => '초대 전송되지 않음',
    'LBL_KIOSK_REACTIVATE' => '재활성화',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => '사용자가 다시 활성화되었습니다',
    'LBL_KIOSK_RESET_PASSWORD' => '비밀번호 재설정',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => '비밀번호 재설정 이메일 전송됨',
    'LBL_KIOSK_USER_PROFILE' => '사용자 프로필',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => '사용자가 비활성화되었습니다. 관리자에게 문의하세요.',
    'LBL_KIOSK_BACK_TO_LOGIN' => '로그인으로 돌아가기',
    'LBL_KIOSK_REVOKE_INVITATION' => '초대 취소',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => '초대가 취소되었습니다',
    'LBL_KIOSK_SEARCH_AND_SELECT' => '검색 및 선택 중...',
    'LBL_KIOSK_NO_MATCHES' => '일치하는 결과가 없습니다',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => '프로필이 업데이트되었습니다.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => '프로필을 업데이트하는 중 오류가 발생했습니다.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => '문서',
    'LBL_KIOSK_DOCUMENTS_DESC' => '들어온 공유 문서를 보고, 검색하고, 다운로드할 수 있습니다.',
    'LBL_KIOSK_CASES' => '사례',
    'LBL_KIOSK_CASES_DESC' => '공유된 사례를 보고, 검색하고, 회신할 수 있습니다.',
    'LBL_KIOSK_DOWNLOAD' => '다운로드',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => '파일 다운로드 성공',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => '시작하기',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => '더 나은 지원을 위해 성함을 알려주십시오.',
    'LBL_KIOSK_SAVE' => '저장',
    'LBL_KIOSK_SHARED' => '공유됨',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => '{lastInitial}{firstName} 님, 환영합니다.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => '배경색',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => '배경 이미지 URL',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => '파일 크기가 400K 미만인 이미지를 선택하는 것이 좋습니다.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => '배경 유형',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => '홈 배경',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => '테마',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => '기본 테마 색상',
    'LBL_KIOSK_CONFIG_APP_NAME' => '앱 이름',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => '이것은 애플리케이션 제목이며 로고 옆에 표시됩니다.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => '앱 로고 URL',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => '작은 크기(예: 소셜 미디어 프로필)에서 가장 잘 보이는 로고를 선택하는 것이 좋습니다. 또한 파일 크기가 200K 미만인 것이 좋습니다.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => '앱 파비콘 URL',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => '파비콘은 브라우저 탭의 페이지 제목 옆에 나타나는 작은 로고입니다.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => '열린 활동 자동 재할당',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => '사용자 한도 도달함',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => '유효하지 않은 라이선스 키',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => '유효하지 않은 애플리케이션',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => '유효하지 않은 애플리케이션',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => '검증 키 손상',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => '라이선스 만료됨',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => '정보 누락',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => '검증 키 누락',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => '사용자 액세스 누락',
    'LBL_DRI_WORKFLOW' => 'Smart Guide',
    'LBL_DRI_WORKFLOWS' => 'Smart Guides',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Smart Guide 단계 템플릿',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Smart Guide 단계 템플릿',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Smart Guide 템플릿',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Smart Guide 활동 템플릿',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => '활동 템플릿',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => '웹훅',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate 웹훅',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => '현재 Smart Guide 활동',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate 웹훅',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate 웹훅',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar 액션',
    'LBL_CJ_FORMS' => 'Smart Guide Sugar 액션',
    'LBL_CJ_FORM' => 'Smart Guide Sugar 액션',
    'LBL_DRI_SUBWORKFLOW' => 'Smart Guide 단계',
    'LBL_DRI_SUBWORKFLOWS' => 'Smart Guide 단계',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Smart Guide 활동 템플릿',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Smart Guide 템플릿',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Smart Guide 주문',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Smart Guide 실제 주문',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Smart Guide 점수',
    'LBL_CJ_MOMENTUM_POINTS' => 'Smart Guide 모멘텀 포인트',
    'LBL_CJ_MOMENTUM_SCORE' => 'Smart Guide 모멘텀 점수',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Smart Guide 활동 허용자',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Smart Guide 진행도',
    'LBL_CJ_MOMENTUM_RATIO' => 'Smart Guide 모멘텀 비율',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Smart Guide 포인트',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Smart Guide 업무',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Smart Guide 상위 활동 형식',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Smart Guide 차단자',
    'LBL_CJ_BLOCKED_BY_STAGES' => '단계에서 차단된 Smart Guide',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Smart Guide 상위 활동 ID',
    'LBL_START_NEXT_JOURNEY_ID' => '다음 Smart Guide ID 시작',
    'LBL_CJ_URL' => 'Smart Guide URL',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Smart Guide 상위 활동',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Smart Guide 모멘텀 시작일',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Smart Guide 모멘텀 종료일',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => '위젯 레이아웃 구성',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => '위젯 레이아웃 구성',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => '동일한 템플릿의 최대 Smart Guide 수',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => '활성',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => '보관됨',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => '보기',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => '숨김',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => '수직 모드',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => '수평 모드',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => '유효하지 않은 라이선스',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} 님이 {{assigned_user}} 님에게 다음 Smart Guide 활동을 할당했습니다.</p>
    <ul>{{activities}}</ul>
    
    <p>활동 검토:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => '유효하지 않은 라이선스',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => '사용자 한도에 도달했습니다. 라이선스를 업그레이드할 수 있는 기간은 {{gracePeriodDays}}일입니다.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - 할당된 Smart Guide 활동',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Sugar Automate 사용자 한도인 {0}명이 초과되었습니다<br>
    <br>
    플러그인 사용자 수를 늘리거나 줄이려면 <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a>에 문의하십시오.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate 사용자 한도 도달함',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Sugar Automate 라이선스가 {0}일 후 만료됩니다. <br>
    <br>
    SugarCRM 또는 귀하의 Sugar Partner에게 문의하여 갱신하고 서비스 중단을 방지하십시오.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate 라이선스가 곧 만료됩니다',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => '웹훅 테스트',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide 진행도',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Sugar Automate "Smart Guide 진행도" 파이 차트를 표시합니다.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => '웹훅 응답을 표시합니다',
    'LBL_DASHLET_SEND_LABEL' => '요청 보내기',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => '본인 할당',
    'LBL_COMPLETE_BUTTON_TITLE' => '완료',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => '모든 작업 완료',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => '단계 삭제',
    'LBL_START_CYCLE_BUTTON_TITLE' => '시작',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => '해당 사항 없음',
    'LBL_ADD_STAGE_BUTTON_TITLE' => '단계 추가',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => '보기',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => '스마트 가이드 편집',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => '취소',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => '보관하기',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => '보관 취소',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => '템플릿 구성',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => '업무 추가',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => '회의일정',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => '전화 일정잡기',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => '미래입니다',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => '기한이 지났습니다',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => '오늘입니다',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => '내일입니다',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => '이 Smart Guide를 취소할까요?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => '이제 모든 작업을 완료할 것입니다. 진행하겠습니까?',
    'LBL_CJ_BLOCK_BY' => '해결되지 않은 {{Name}} 종속 작업이 있습니다. 이 작업을 완료한 뒤 모든 작업을 완료하십시오.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => '해결되지 않은 종속 작업이 여러 개 있습니다. 이 작업을 완료한 뒤 모든 작업을 완료하십시오.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => '모든 작업을 완료했습니다',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => '이 Smart Guide를 보관할까요?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => '이 Smart Guide를 보관 취소할까요?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Smart Guide(포커스 서랍 및 콘솔)',
    'LBL_CJ_AS_A_DASHLET_DESC' => '서비스/갱신 콘솔 및 포커스 서랍 대시보드에서 활성 Smart Guide를 봅니다.',
    'LBL_CJ_PROCESSING_REQUEST' => '처리 중...',
    'LBL_CJ_SUCCESS' => '모든 작업을 완료했습니다',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module} 모듈이 활성화되지 않았습니다',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => '모든 표시 설정이 저장됩니다.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Smart Guide 모멘텀',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Sugar Automate "Smart Guide Momentum" 게이지 차트를 표시합니다.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide 진행도',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Sugar Automate "Smart Guide 진행도" 원형 도표를 표시합니다.',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => '상위를 찾을 수 없음',
    'CJ_NOT_FOUND_EXCEPTION' => '{data} 포함 {moduleName} 찾을 수 없음',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => '보관 전 Smart Guide를 완료하거나 취소해야 합니다',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => '현재 Sugar 라이선스에서는 Sugar Automate가 활성화되어 있지 않습니다',
    'LBL_ACTION_NOT_FOUND' => '액션을 찾을 수 없습니다. 시스템 관리자에게 연락하십시오',
    'LBL_CJ_SELECT_FIELD' => '필드 선택',
    'LBL_CJ_SELECT_OPERATOR' => '운영자 선택',
    'LBL_CJ_SELECT_VALUE' => '값 선택',
    'LBL_CJ_ENTER_VALUE' => '값 입력',
    'LBL_CJ_FORM_BATCH_TITLE' => '기록 저장',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => '활성 스마트 가이드 감지됨...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => '활성 Sugar 액션 처리 중...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => '활성 스마트 가이드 업데이트 중...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => '레코드 및 관련 Smart Guide가 성공적으로 업데이트되었습니다.',
    'LBL_CJ_FORM_BATCH_FAILURE' => '관련 스마트 가이드가 업데이트되지 않았습니다. 오류가 계속되면 Sugar 관리자에게 도움을 요청하세요.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => '관련 스마트 가이드가 업데이트되지 않았습니다. <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">로그</a>를 검토하여 오류를 해결하십시오.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => '<a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} 성공적으로 연결.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => '<a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} 연결 중 문제 발생. 문제가 지속되면 Sugar 지원팀에 문의하세요.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => '{{modulePluralLower}} 성공적으로 연결.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => '{{modulePluralLower}} 연결 중 문제 발생. 문제가 지속되면 Sugar 지원팀에 문의하세요.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => '{{moduleSingularLower}} 연결 중 문제 발생. 문제가 지속되면 Sugar 지원팀에 문의하세요.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => '{{stage}} 단계에 이미 <a href="#{{module}}/{{id}}">{{name}}</a> 이름의 {{moduleSingularLower}} 존재.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => '이미 <a href="#{{module}}/{{id}}">{{name}}</a> 이름의 {{moduleSingularLower}} 선택됨.',
    'LBL_CJ_ARCHIVED' => '보관됨',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Smart Guide 템플릿 선택...',
    'LBL_ALL_SMART_GUIDES' => '모든 Smart Guide',
    'LBL_ACTIVE_SMART_GUIDES' => '활성 Smart Guide',
    'LBL_ARCHIVED_SMART_GUIDES' => '보관된 Smart Guide',
    'LBL_VERTICAL_SCROLL_VIEW' => '수직 스택 보기',
    'LBL_HORIZONTAL_SCROLL_VIEW' => '가로 스크롤 보기',
    'LBL_DRI_WORKFLOWS_FILTER' => '필터',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => '이 작업은 완료할 수 없습니다. 이 활동 모듈의 상태 필드가 "읽기 전용"으로 설정되어 있어 상태 필드를 업데이트하는 Smart Guide 작업을 수행할 수 없습니다.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => '이 작업은 완료할 수 없습니다. 이 활동 및/또는 하위 활동 모듈의 상태 필드가 "읽기 전용"으로 설정되어 있어 상태 필드를 업데이트하는 Smart Guide 작업을 수행할 수 없습니다.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => '가이드 내 일부 활동 모듈의 상태 필드가 "읽기 전용"으로 설정되어 있어, 이러한 활동은 가이드 취소 시 변경되지 않은 상태로 유지됩니다.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => '클립보드에 복사되었습니다.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => '모든 반복일정 삭제',
    'ERROR_RECURRENCE_EVENT_PARAMS' => '반복일정 설정 무효',
    'ERROR_INTERVAL_INVALID' => '반복 간격은 1에서 99 사이여야 합니다',
    'LBL_RECURRENCE_ADD' => '구성',
    'LBL_REPEAT_DAYS' => '일/월',
    'LBL_REPEAT_END_TYPES' => '반복',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => '내비게이션 제공자',
    'LBL_MOBILE_PDF_EMAIL' => '{{{pdfTemplateName}}} PDF 이메일로 전공',
    'LBL_MOBILE_EMAIL_SENDING' => '전송 중',
    'LBL_MOBILE_EMAIL_SENT' => '전송 완료',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => '이메일이 초안으로 저장되었습니다.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => '첨부파일 추가',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => '로컬에서 업로드',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar 문서',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => '선택한 드롭다운 값으로 인해 기록 보기 레이아웃이 변경되었습니다.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'SugarCRM 모바일 앱 출시 노트',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'SugarCRM 모바일 앱 사용자 가이드',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile은 루팅된 모바일 장치에 사용할 수 없습니다. 루팅되지 않은 장치에서 앱을 여십시오.',
    'LBL_VO_BUILD_ROUTE' => '경로 생성',
    'LBL_FILTER_MY_DISTANCE_FILTER' => '거리 필터',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => '문서는 백그라운드에서 생성됩니다. 문서 병합 페이지를 열어 파일에 접근합니다.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => '템플릿을 가져오지 못했습니다. 관리자에게 도움을 요청하십시오.',
    'LBL_MAP_ERROR_LOAD' => '맵 로드 실패',
    'LBL_MAP_DISTANCE' => '거리',
    'LBL_SELECT_UNIT_TYPE' => '단위 유형',
    'LBL_MAPS_UNIT_MILES' => '마일',
    'LBL_MAPS_UNIT_KILOMETERS' => '킬로미터',
    'LBL_RADIUS' => '반경',
    'LBL_ZIP_CODE' => '우편번호',
    'LBL_MOBILE_CHOOSE_ADDRESS' => '주소 선택',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => '{{{address}} 주소에서 지오코드를 생성할 수 없습니다',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => '기록이 지오코딩되지 않았습니다.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => '기록에 주소 데이터가 포함되어 있지 않습니다. 지도에서 이 기록을 수동으로 찾으시겠습니까?',
    'LBL_ERR_SHOW_ON_MAP' => '선택한 기록의 지도를 열지 못했습니다.',
    'LBL_ERR_MISSING_ON_MAP' => '일부 기록은 주소 데이터가 누락되어 표시되지 않습니다',
    'LBL_MAPS_ROUTE' => '경로',
    'LBL_MAPS_PROVIDER' => 'Sugar Maps',
    'LBL_MAPS_CURRENT_LOC_ERROR' => '현재 위치를 확인할 수 없습니다.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => '매핑에는 최대 {{{num}}개의 기록이 지원됩니다.',
    'LBL_ALL_MODULES' => '전체 모듈',
    'LBL_DRIVE_SHARE_LINK' => '링크 공유',
    'LBL_DRIVE_LOAD_FILES_ERROR' => '파일을 불러오지 못했습니다.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => '이름은 비워둘 수 없습니다',
    'LBL_DRIVE_FOLDER_CREATED' => '폴더가 생성되었습니다.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => '폴더를 생성하지 못했습니다.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => '파일을 업로드하지 못했습니다.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => '먼저 루트 폴더를 생성하십시오',
    'LBL_EDIT_ALL_RECURRENCES' => '모든 반복일정 편집하기',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'Dropbox에서 파일을 열 수 없습니다.',
    'LBL_FILE_NOT_AVAILABLE' => '파일을 열 수 없음',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => '지시',
    'LBL_MAPS_ROUTE_NOT_FOUND' => '제공된 웨이포인트에 대한 경로를 찾을 수 없습니다',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => '근처',
    'LBL_TAGS' => '태그',

    'LBL_CALLER_ID_SETTINGS' => '발신자 ID 설정',
    'LBL_CALLER_ID_ENABLED' => '발신자 ID 활성화됨',
    'LBL_CALLER_ID_ENABLED_TEXT' => '걸려오는 전화에는 전화번호와 일치하는 연락처 또는 관심고객의 이름이 표시됩니다.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => '모바일 앱이 발신자 ID를 표시하도록 허용하려면 기기에서 다음 단계를 따르세요.<br><br>1. iOS 설정 > 전화 > 통화 차단 및 식별을 엽니다.<br>2. "{{{brandName}}}" 활성화합니다.',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => '모바일 앱이 발신자 ID를 표시하도록 허용하려면 기기에서 다음 단계를 따르세요.<br>1. 앱 설정을 엽니다.<br>2. 권한으로 이동합니다.<br>3. 통화 권한을 활성화합니다.<br><br>이 애플리케이션을 기본 발신자 ID 핸들러로 설정하려면 장치 설정으로 이동하세요.<br>1. 앱으로 이동합니다.<br>2. 기본 앱을 선택합니다.<br>3. 발신자 ID 및 스팸 앱을 선택합니다.<br>4. 이 애플리케이션을 기본 옵션으로 선택합니다.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Sugar 인스턴스의 기록(예: 연락처, 관심고객)에서 연락처 정보가 변경되었는지 확인하십시오.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => '설정으로 이동',
    'LBL_CALLER_ID_SYNC' => '기록 데이터 동기화',
    'LBL_CALLER_ID_NOT_ENABLED' => '동기화 전 시스템 설정에서 발신자 ID를 활성화해야 합니다.',
    'LBL_CALLER_ID_SETUP_ENABLE' => '활성화',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => '나중에 설정에서',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => '이 애플리케이션은 발신자 ID 기능을 지원합니다.<br>이 기능이 제대로 작동하도록, 활성화 버튼을 누른 후 두 가지 권한을 부여하라는 메시지가 표시됩니다.<br>발신자 ID 기능이 제대로 작동하도록 하려면 통화를 관리할 권한을 부여하고 이 애플리케이션을 기본 발신자 ID 핸들러로 선택해야 합니다.<br>통화 관리 권한을 부여하지 않으면 애플리케이션에서 걸려온 통화도 기록할 수 없습니다.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'SugarCRM 모바일 앱이 발신자 ID를 표시하도록 허용하려면 기기에서 다음 단계를 따르세요.<br><br>1. iOS 설정 > 전화 > 통화 차단 및 식별을 엽니다.<br>2. 앱을 활성화합니다.',
    'LBL_MOBILE_LAST_SYNC' => '마지막 동기화',
    'LBL_CALLER_ID_SYNCING' => '서버와 동기화 중입니다.',
    'LBL_NEVER' => '사용하지 않음',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} 비워 둘 수 없음.',
    'LBL_ADD_RELATED_RECORD' => '관련 {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => '발신자 ID를 사용에 필요한 권한이 없습니다. 관리자에게 문의하세요.',
    'LBL_CALLER_ID_FETCHING' => '동기화 중...',
    'LBL_CALLER_ID_FETCH_ALL' => '모든 기록 다시 동기화',
    'LBL_CALLER_ID_FETCH_NEW' => '기록 업데이트 확인',

    'LBL_SORT_BY' => '정렬',
    'LBL_PRIMARY_SORT' => '최우선 정렬',
    'LBL_SECONDARY_SORT' => '차선 정렬',
    'LBL_OF' => '/',
    'LBL_TABLE_FREEZE_FIRST' => '첫 열 고정',
    'LBL_TABLE_SETTINGS_TITLE' => '컬럼 보기 옵션',
    'LBL_TABLE_SETTINGS_NO_COL' => '열을 하나 이상 선택해야 합니다.',
    'LBL_TABLE_TOGGLER_INFO' => '열을 표시하거나 숨기고 원하는 순서로 드래그합니다.',
    'LBL_RUNTIME_FILTERS_TITLE' => '런타임 필터',
    'LBL_FILTER_CONDITION' => '조건 선택',
    'LBL_FILTER_VALUES' => '가치',
    'LBL_TABLE_EXPAND' => '전체 확장',
    'LBL_TABLE_COLLAPSE' => '전체 접기',
    'LBL_RUNTIME_FILTERS_DEFAULT' => '서버 오류입니다. 관련 런타임 필터를 로드할 수 없습니다.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Pub/Sub 모듈 이벤트 푸시 구독',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Pub/Sub 모듈 이벤트 푸시 구독',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => '패널 - 상단',
    'panel_bottom' => '패널 - 하단',
    'tab_first' => '탭 - 처음',
    'tab_last' => '탭 - 마지막',
];

$app_list_strings['activity_user_options'] = [
    '7' => '지난 7일',
    '30' => '지난 30일',
    '90' => '지난 분기',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => '오늘',
    'future' => '미래',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => '예',
    'group' => '아니요',
];

$app_list_strings['history_filter_options'] = [
    7 => '지난 7일',
    30 => '지난 30일',
    90 => '지난 분기',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => '예',
    'group' => '아니요',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => '예',
    'group' => '아니요',
];

$app_list_strings['list_visibility_options'] = [
    '1' => '예',
    '0' => '아니요',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => '이번 분기',
    'next' => '다음 분기',
    'year' => '올해',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => '내 레코드',
    'group' => '그룹 레코드',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => '내 파이프라인',
    'group' => '내 팀의 파이프라인',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => '내 예측',
    'group' => '내 팀의 예측',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => '영업기회',
    'RevenueLineItems' => '기회와 수익 품목',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => '최신 닫기 날짜',
    'earliest' => '최초 종료일',
];

$app_list_strings['moduleList']['Library'] = '자료실';
$app_list_strings['moduleListSingular']['Library'] = '자료실';
$app_list_strings['library_type'] = ['Books' => '책', 'Music' => '음악', 'DVD' => 'DVD', 'Magazines' => '잡지'];
$app_list_strings['moduleList']['EmailAddresses'] = '이메일 주소:';
$app_list_strings['moduleListSingular']['EmailAddresses'] = '이메일 주소:';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => '임시 보관',
    'in-review' => '검토 중',
    'approved' => '승인됨',
    'published' => '발표 완료',
    'expired' => '기간 만료됨',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--관리자 액션--',
        'Create New Tag' => '신규 태그 만들기',
        'Delete Tag' => '태그 삭제하기',
        'Rename Tag' => '태그 이름 고치기',
        'Move Selected Articles' => '선택한 기사 이동',
        'Apply Tags On Articles' => '태그를 기사에 적용',
        'Delete Selected Articles' => '선택된 기사 삭제',
    ];

$app_list_strings['moduleList']['Words'] = '단어';
$app_list_strings['moduleListSingular']['Words'] = '단어';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = '신규지식 만들기';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => '아부다비',
    'ADEN' => '아덴',
    'AFGHANISTAN' => '아프가니스탄',
    'ALBANIA' => '알바니아',
    'ALGERIA' => '알제리아',
    'AMERICAN SAMOA' => '미국령 사모아',
    'ANDORRA' => '안도라',
    'ANGOLA' => '앙골라',
    'ANTARCTICA' => '남극대륙',
    'ANTIGUA' => '안티과',
    'ARGENTINA' => '아르헨티나',
    'ARMENIA' => '아르메니아',
    'ARUBA' => '아루바',
    'AUSTRALIA' => '호주',
    'AUSTRIA' => '오스트리아',
    'AZERBAIJAN' => '아제르바이잔',
    'BAHAMAS' => '바하마',
    'BAHRAIN' => '바레인',
    'BANGLADESH' => '방글라데시',
    'BARBADOS' => '바베이도스',
    'BELARUS' => '벨라루스',
    'BELGIUM' => '벨기에',
    'BELIZE' => '벨리즈',
    'BENIN' => '베닌',
    'BERMUDA' => '버뮤다',
    'BHUTAN' => '부탄',
    'BOLIVIA' => '볼리비아',
    'BOSNIA' => '보스니아',
    'BOTSWANA' => '보츠와나',
    'BOUVET ISLAND' => '부벳 제도',
    'BRAZIL' => '브라질',
    'BRITISH ANTARCTICA TERRITORY' => '영국령 남극지역',
    'BRITISH INDIAN OCEAN TERRITORY' => '영국령 인도양 지역',
    'BRITISH VIRGIN ISLANDS' => '영국령 버진 아일랜드',
    'BRITISH WEST INDIES' => '영국령 서인도 제도',
    'BRUNEI' => '브루나이',
    'BULGARIA' => '불가리아',
    'BURKINA FASO' => '부르키나 파소',
    'BURUNDI' => '브룬디',
    'CAMBODIA' => '캄보디아',
    'CAMEROON' => '카메룬',
    'CANADA' => '캐나다',
    'CANAL ZONE' => '파나마 운하',
    'CANARY ISLAND' => '카나리아 제도',
    'CAPE VERDI ISLANDS' => '케이프 베르디 제도',
    'CAYMAN ISLANDS' => '케이맨 제도',
    'CEVLON' => '세브론',
    'CHAD' => '차드',
    'CHANNEL ISLAND UK' => '채널 제도',
    'CHILE' => '칠레',
    'CHINA' => '중국',
    'CHRISTMAS ISLAND' => '크리스마스 섬',
    'COCOS (KEELING) ISLAND' => '코코스 제도',
    'COLOMBIA' => '콜롬비아',
    'COMORO ISLANDS' => '코모로 제도',
    'CONGO' => '콩고',
    'CONGO KINSHASA' => '콩공 킨샤사',
    'COOK ISLANDS' => '쿡 제도',
    'COSTA RICA' => '코스타리카',
    'CROATIA' => '크로아티아',
    'CUBA' => '쿠바',
    'CURACAO' => '쿠라사우 섬',
    'CYPRUS' => '사이프러스',
    'CZECH REPUBLIC' => '체크 공화국',
    'DAHOMEY' => '다오메이',
    'DENMARK' => '덴마크',
    'DJIBOUTI' => '지부티',
    'DOMINICA' => '도미니카',
    'DOMINICAN REPUBLIC' => '도미니카 공화국',
    'DUBAI' => '두바이',
    'ECUADOR' => '에콰도르',
    'EGYPT' => '이집트',
    'EL SALVADOR' => '엘 살바도르',
    'EQUATORIAL GUINEA' => '적도 기니',
    'ESTONIA' => '에스토니아',
    'ETHIOPIA' => '에티오피아',
    'FAEROE ISLANDS' => '페로 제도',
    'FALKLAND ISLANDS' => '포클랜드 제도',
    'FIJI' => '피지',
    'FINLAND' => '핀란드',
    'FRANCE' => '프랑스',
    'FRENCH GUIANA' => '프랑스령 기아나',
    'FRENCH POLYNESIA' => '프랑스령 폴리네시아',
    'GABON' => '가봉',
    'GAMBIA' => '감비다',
    'GEORGIA' => '조지아',
    'GERMANY' => '독일',
    'GHANA' => '가나',
    'GIBRALTAR' => '지브롤터',
    'GREECE' => '그리스',
    'GREENLAND' => '그린랜드',
    'GUADELOUPE' => '과들루프',
    'GUAM' => '괌',
    'GUATEMALA' => '과테말라',
    'GUINEA' => '기니',
    'GUYANA' => '가이아나',
    'HAITI' => '하이티',
    'HONDURAS' => '오두라스',
    'HONG KONG' => '홍콩',
    'HUNGARY' => '헝가리',
    'ICELAND' => '아이슬랜드',
    'IFNI' => '이프니',
    'INDIA' => '인도',
    'INDONESIA' => '인도네시아',
    'IRAN' => '이란',
    'IRAQ' => '이라크',
    'IRELAND' => '아일랜드',
    'ISRAEL' => '이스라엘',
    'ITALY' => '이탈리아',
    'IVORY COAST' => '코트디부아르',
    'JAMAICA' => '자메이카',
    'JAPAN' => '일본',
    'JORDAN' => '요르단',
    'KAZAKHSTAN' => '카자흐스탄',
    'KENYA' => '켄냐',
    'KOREA' => '한국',
    'KOREA, SOUTH' => '대한민국',
    'KUWAIT' => '쿠웨이트',
    'KYRGYZSTAN' => '키르기스스탄',
    'LAOS' => '라오스',
    'LATVIA' => '라트비아',
    'LEBANON' => '레바논',
    'LEEWARD ISLANDS' => '리워드 제도',
    'LESOTHO' => '레소토',
    'LIBYA' => '리비야',
    'LIECHTENSTEIN' => '리히텐슈타인',
    'LITHUANIA' => '리투아니아',
    'LUXEMBOURG' => '룩셈부르크',
    'MACAO' => '마카오',
    'MACEDONIA' => '마케도니아',
    'MADAGASCAR' => '마다가스카르',
    'MALAWI' => '말라위',
    'MALAYSIA' => '말레이시아',
    'MALDIVES' => '몰디브',
    'MALI' => '말리',
    'MALTA' => '몰타',
    'MARTINIQUE' => '마르티니크',
    'MAURITANIA' => '모리타니아',
    'MAURITIUS' => '모리셔스',
    'MELANESIA' => '멜라네시아',
    'MEXICO' => '멕시코',
    'MOLDOVIA' => '몰도비아',
    'MONACO' => '모나코',
    'MONGOLIA' => '몽골',
    'MOROCCO' => '모로코',
    'MOZAMBIQUE' => '모잠비크',
    'MYANAMAR' => '미얀마',
    'NAMIBIA' => '나미비아',
    'NEPAL' => '네팔',
    'NETHERLANDS' => '네델란드',
    'NETHERLANDS ANTILLES' => '네델란드령 앤틸리스',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => '네델란드령 앤틸리스 중립지역',
    'NEW CALADONIA' => '뉴 칼레도니아',
    'NEW HEBRIDES' => '뉴 헤브리디스',
    'NEW ZEALAND' => '뉴질랜드',
    'NICARAGUA' => '니카라과',
    'NIGER' => '니제르',
    'NIGERIA' => '나이지리아',
    'NORFOLK ISLAND' => '노퍽 섬',
    'NORWAY' => '노르웨이',
    'OMAN' => '오만',
    'OTHER' => '기타',
    'PACIFIC ISLAND' => '태평양 신탁통치 군도',
    'PAKISTAN' => '파키스탄',
    'PANAMA' => '파나마',
    'PAPUA NEW GUINEA' => '파푸아뉴기니',
    'PARAGUAY' => '파라과이',
    'PERU' => '페루',
    'PHILIPPINES' => '필리핀',
    'POLAND' => '폴란드',
    'PORTUGAL' => '포르투칼',
    'PORTUGUESE TIMOR' => '포르투갈령 티모르',
    'PUERTO RICO' => '푸에르토리코',
    'QATAR' => '카타르',
    'REPUBLIC OF BELARUS' => '벨라루스 공화국',
    'REPUBLIC OF SOUTH AFRICA' => '남아프리카 공화국',
    'REUNION' => '레위니옹',
    'ROMANIA' => '루마니아',
    'RUSSIA' => '러시아',
    'RWANDA' => '르완다',
    'RYUKYU ISLANDS' => '류큐 열도',
    'SABAH' => '사바',
    'SAN MARINO' => '산 마리노',
    'SAUDI ARABIA' => '사우디아라비아',
    'SENEGAL' => '세네갈',
    'SERBIA' => '세르비아',
    'SEYCHELLES' => '세이셸',
    'SIERRA LEONE' => '시에라리온',
    'SINGAPORE' => '싱가포르',
    'SLOVAKIA' => '슬로바키아',
    'SLOVENIA' => '슬로베니아',
    'SOMALILIAND' => '소마릴리안',
    'SOUTH AFRICA' => '남아프리카',
    'SOUTH YEMEN' => '남 예멘',
    'SPAIN' => '스페인',
    'SPANISH SAHARA' => '스페인령 사하라',
    'SRI LANKA' => '스리랑카',
    'ST. KITTS AND NEVIS' => '세인트키츠와 네비스',
    'ST. LUCIA' => '세인트루시아',
    'SUDAN' => '수단',
    'SURINAM' => '수리남',
    'SW AFRICA' => '남서 아프리카',
    'SWAZILAND' => '스와질랜드',
    'SWEDEN' => '스웨덴',
    'SWITZERLAND' => '스위스',
    'SYRIA' => '시리아',
    'TAIWAN' => '대만',
    'TAJIKISTAN' => '타지키스탄',
    'TANZANIA' => '탄자니아',
    'THAILAND' => '태국',
    'TONGA' => '통가',
    'TRINIDAD' => '트리니다드',
    'TUNISIA' => '튀니지아',
    'TURKEY' => '터키',
    'UGANDA' => '우간다',
    'UKRAINE' => '우크라이나',
    'UNITED ARAB EMIRATES' => '아랍에미리트',
    'UNITED KINGDOM' => '영국',
    'UPPER VOLTA' => '오트볼타',
    'URUGUAY' => '우르과이',
    'US PACIFIC ISLAND' => '미국령 태평양 신탁통치 군도',
    'US VIRGIN ISLANDS' => '미국령 버진 제도',
    'USA' => '미국',
    'UZBEKISTAN' => '우즈베키스탄',
    'VANUATU' => '바누아투',
    'VATICAN CITY' => '바티칸시티',
    'VENEZUELA' => '베네수엘라',
    'VIETNAM' => '베트남',
    'WAKE ISLAND' => '웨이크섬',
    'WEST INDIES' => '서인도 제도',
    'WESTERN SAHARA' => '서부 사하라',
    'YEMEN' => '예멘',
    'ZAIRE' => '자이르',
    'ZAMBIA' => '잠비아',
    'ZIMBABWE' => '짐바브웨',
];

$app_list_strings['state_dom'] = [
    'AL' => '앨라배마',
    'AK' => '알래스카',
    'AZ' => '애리조나',
    'AR' => '아칸소',
    'CA' => '캘리포니아',
    'CO' => '콜로라도',
    'CT' => '코네티컷',
    'DE' => '델라웨어',
    'DC' => '콜롬비아 특별구',
    'FL' => '플로리다',
    'GA' => '조지아',
    'HI' => '하와이',
    'ID' => '아이다 호',
    'IL' => '일리노이',
    'IN' => '인디애나',
    'IA' => '아이오와',
    'KS' => '캔자스',
    'KY' => '켄터키',
    'LA' => '루이지애나',
    'ME' => '메인',
    'MD' => '메릴랜드',
    'MA' => '매사 추세 츠',
    'MI' => '미시간',
    'MN' => '미네소타',
    'MS' => '미시시피',
    'MO' => '미주리',
    'MT' => '몬태나',
    'NE' => '네브라스카',
    'NV' => '네바다',
    'NH' => '뉴 햄프셔',
    'NJ' => '뉴저지',
    'NM' => '뉴 멕시코',
    'NY' => '뉴욕',
    'NC' => '노스 캐롤라이나',
    'ND' => '노스 다코타',
    'OH' => '오하이오',
    'OK' => '오클라호마',
    'OR' => '오레곤',
    'PA' => '펜실베니아',
    'RI' => '로드 아일랜드',
    'SC' => '사우스 캐롤라이나',
    'SD' => '사우스 다코타',
    'TN' => '테네시',
    'TX' => '텍사스',
    'UT' => '유타',
    'VT' => '버몬트',
    'VA' => '버지니아',
    'WA' => '워싱턴',
    'WV' => '웨스트 버지니아',
    'WI' => '위스콘신',
    'WY' => '와이오밍',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (대만과 홍콩)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS 키릴)',
    'CP1252' => 'CP1252 (MS 서유럽과 미국)',
    'EUC-CN' => 'EUC-CN (단순중국어 GB2312)',
    'EUC-JP' => 'EUC-JP (Unix 일본)',
    'EUC-KR' => 'EUC-KR (한국어)',
    'EUC-TW' => 'EUC-TW (대만어)',
    'ISO-2022-JP' => 'ISO-2022-JP (일본어)',
    'ISO-2022-KR' => 'ISO-2022-KR (한국어)',
    'ISO-8859-1' => 'ISO-8859-1 (서부유럽과 미국)',
    'ISO-8859-2' => 'ISO-8859-2 (중앙과 동유럽)',
    'ISO-8859-3' => 'ISO-8859-3 (라틴 3)',
    'ISO-8859-4' => 'ISO-8859-4 (라틴 4)',
    'ISO-8859-5' => 'ISO-8859-5 (키릴)',
    'ISO-8859-6' => 'ISO-8859-6 (아랍어)',
    'ISO-8859-7' => 'ISO-8859-7 (그리스어)',
    'ISO-8859-8' => 'ISO-8859-8 (헤브루)',
    'ISO-8859-9' => 'ISO-8859-9 (라틴 5)',
    'ISO-8859-10' => 'ISO-8859-10 (라틴 6)',
    'ISO-8859-13' => 'ISO-8859-13 (라틴 7)',
    'ISO-8859-14' => 'ISO-8859-14 (라틴 8)',
    'ISO-8859-15' => 'ISO-8859-15 (라틴 9)',
    'KOI8-R' => 'KOI8-R (키릴 러시아어)',
    'KOI8-U' => 'KOI8-U (키릴 우크라이나어)',
    'SJIS' => 'SJIS (MS 일본어)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => '아프리카/알제',
    'Africa/Luanda' => '아프리카/루안다',
    'Africa/Porto-Novo' => '아프리카/포르토노보',
    'Africa/Gaborone' => '아프리카/가보로네',
    'Africa/Ouagadougou' => '아프리카/와가두구',
    'Africa/Bujumbura' => '아프리카 부줌부라',
    'Africa/Douala' => '아프리카/두알라',
    'Atlantic/Cape_Verde' => '대서양/카보베르데',
    'Africa/Bangui' => '아프리카/방기',
    'Africa/Ndjamena' => '아프리카/은자메나',
    'Indian/Comoro' => '인도/코모로',
    'Africa/Kinshasa' => '아프리카/킨샤사',
    'Africa/Lubumbashi' => '아프리카/루붐바시',
    'Africa/Brazzaville' => '아프리카/브라자빌',
    'Africa/Abidjan' => '아프리카/아비장',
    'Africa/Djibouti' => '아프리카/지부티',
    'Africa/Cairo' => '아프리카/카이로',
    'Africa/Malabo' => '아프리카/말라보',
    'Africa/Asmera' => '아프리카/아스메라',
    'Africa/Addis_Ababa' => '아프리카/아디스아바바',
    'Africa/Libreville' => '아프리카/리브르빌',
    'Africa/Banjul' => '아프리카/반줄',
    'Africa/Accra' => '아프리카/아크라',
    'Africa/Conakry' => '아프리카/코나크리',
    'Africa/Bissau' => '아프리카/비사우',
    'Africa/Nairobi' => '아프리카/나이로비',
    'Africa/Maseru' => '아프리카/마세루',
    'Africa/Monrovia' => '아프리카/먼로비아',
    'Africa/Tripoli' => '아프리카/트리폴리',
    'Indian/Antananarivo' => '인도/안타나나리보',
    'Africa/Blantyre' => '아프리카/블랜타이어',
    'Africa/Bamako' => '아프리카/바마코',
    'Africa/Nouakchott' => '아프리카/뉴악쇼트',
    'Indian/Mauritius' => '인도/모리셔스',
    'Indian/Mayotte' => '인도/마요트',
    'Africa/Casablanca' => '아프리카/카사블랑카',
    'Africa/El_Aaiun' => '아프리카/엘아이운',
    'Africa/Maputo' => '아프리카/마푸토',
    'Africa/Windhoek' => '아프리카/비트후크',
    'Africa/Niamey' => '아프리카/니아메',
    'Africa/Lagos' => '아프리카/라고스',
    'Indian/Reunion' => '인도/레위니옹',
    'Africa/Kigali' => '아프리카/키갈리',
    'Atlantic/St_Helena' => '대서양/세인트헬레나',
    'Africa/Sao_Tome' => '아프리카/상투메',
    'Africa/Dakar' => '아프리카/다카르',
    'Indian/Mahe' => '인도/마에',
    'Africa/Freetown' => '아프리카/프리타운',
    'Africa/Mogadishu' => '아프리카/모가디슈',
    'Africa/Johannesburg' => '아프리카/요하네스버그',
    'Africa/Khartoum' => '아프리카/카르툼',
    'Africa/Mbabane' => '아프리카/음바바네',
    'Africa/Dar_es_Salaam' => '아프리카/다레살람',
    'Africa/Lome' => '아프리카/로메',
    'Africa/Tunis' => '아프리카/튀니스',
    'Africa/Kampala' => '아프리카/캄팔라',
    'Africa/Lusaka' => '아프리카/루사카',
    'Africa/Harare' => '아프리카/하라레',
    'Antarctica/Casey' => '남극대륙/케이시',
    'Antarctica/Davis' => '남극대륙/데이비스',
    'Antarctica/Mawson' => '남극대륙/모슨',
    'Indian/Kerguelen' => '인도/케르겔렌',
    'Antarctica/DumontDUrville' => '남극대륙/듀몽빌',
    'Antarctica/Syowa' => '남극대륙/시오와',
    'Antarctica/Vostok' => '남극대륙/보스토크',
    'Antarctica/Rothera' => '남극대륙/로테라',
    'Antarctica/Palmer' => '남극대륙/파머',
    'Antarctica/McMurdo' => '남극대륙/맥머드',
    'Asia/Kabul' => '아시아/카불',
    'Asia/Yerevan' => '아시아/Y예레반',
    'Asia/Baku' => '아시아/바쿠',
    'Asia/Bahrain' => '아시아/바레인',
    'Asia/Dhaka' => '아시아/다카',
    'Asia/Thimphu' => '아시아/팀푸',
    'Indian/Chagos' => '인도/차고스',
    'Asia/Brunei' => '아시아/브루나이',
    'Asia/Rangoon' => '아시아/양곤',
    'Asia/Phnom_Penh' => '아시아/프놈펜',
    'Asia/Beijing' => '아시아/B베이징',
    'Asia/Harbin' => '아시아/하얼빈',
    'Asia/Shanghai' => '아시아/상하이',
    'Asia/Chongqing' => '아시아/충칭',
    'Asia/Urumqi' => '아시아/Urumqi',
    'Asia/Kashgar' => '아시아/카슈가르',
    'Asia/Hong_Kong' => '아시아/홍콩',
    'Asia/Taipei' => '아시아/타이페이',
    'Asia/Macau' => '아시아/마카오',
    'Asia/Nicosia' => '아시아/니코시아',
    'Asia/Tbilisi' => '아시아/트빌리시',
    'Asia/Dili' => '아시아/딜리',
    'Asia/Calcutta' => '아시아/캘커다',
    'Asia/Jakarta' => '아시아/자카르타',
    'Asia/Pontianak' => '아시아/폰트아나크',
    'Asia/Makassar' => '아시아/마카사르',
    'Asia/Jayapura' => '아시아/자야푸라',
    'Asia/Tehran' => '아시아/테헤란',
    'Asia/Baghdad' => '아시아/바그다드',
    'Asia/Jerusalem' => '아시아/예루살렘',
    'Asia/Tokyo' => '아시아/도쿄',
    'Asia/Amman' => '아시아/암만',
    'Asia/Almaty' => '아시아/알마티',
    'Asia/Qyzylorda' => '아시아/키질로다',
    'Asia/Aqtobe' => '아시아/악토베',
    'Asia/Aqtau' => '아시아/아크타우',
    'Asia/Oral' => '아시아/오랄',
    'Asia/Bishkek' => '아시아/비슈케크',
    'Asia/Seoul' => '아시아/서울',
    'Asia/Pyongyang' => '아시아/평양',
    'Asia/Kuwait' => '아시아/쿠웨이트',
    'Asia/Vientiane' => '아시아/비엔티엔',
    'Asia/Beirut' => '아시아/베이루트',
    'Asia/Kuala_Lumpur' => '아시아/쿠알라룸프',
    'Asia/Kuching' => '아시아/쿠칭',
    'Indian/Maldives' => '인도/몰디브',
    'Asia/Hovd' => '아시아/Hovd',
    'Asia/Ulaanbaatar' => '아시아/울란바토르',
    'Asia/Choibalsan' => '아시아/치오발산',
    'Asia/Katmandu' => '아시아/카트만두',
    'Asia/Muscat' => '아시아/무스카트',
    'Asia/Karachi' => '아시아/카라티',
    'Asia/Gaza' => '아시아/가자',
    'Asia/Manila' => '아시아/마닐라',
    'Asia/Qatar' => '아시아/카타르',
    'Asia/Riyadh' => '아시아/리야드',
    'Asia/Singapore' => '아시아/싱가포르',
    'Asia/Colombo' => '아시아/콜롬보',
    'Asia/Damascus' => '아시아/다마스쿠스',
    'Asia/Dushanbe' => '아시아/두샨베',
    'Asia/Bangkok' => '아시아/B방콕',
    'Asia/Ashgabat' => '아시아/아스가바트',
    'Asia/Dubai' => '아시아/두바이',
    'Asia/Samarkand' => '아시아/사마르칸트',
    'Asia/Tashkent' => '아시아/타슈켄트',
    'Asia/Saigon' => '아시아/사이공',
    'Asia/Aden' => '아시아/아덴',
    'Australia/Darwin' => '호주/다윈',
    'Australia/Perth' => '호주/퍼스',
    'Australia/Brisbane' => '호주/브리스번',
    'Australia/Lindeman' => '호주/린드먼',
    'Australia/Adelaide' => '호주/아델레이드',
    'Australia/Hobart' => '호주/호바트',
    'Australia/Currie' => '호주/큐리',
    'Australia/Melbourne' => '호주/멜번',
    'Australia/Sydney' => '호주/시드니',
    'Australia/Broken_Hill' => '호주/브로큰힐',
    'Indian/Christmas' => '인도/크리스마스',
    'Pacific/Rarotonga' => '태평양/라로통가',
    'Indian/Cocos' => '인도/코코스',
    'Pacific/Fiji' => '태평양/피지',
    'Pacific/Gambier' => '태평양/갬비어 제도',
    'Pacific/Marquesas' => '태평양/마키저스 제도',
    'Pacific/Tahiti' => '태평양/타히티',
    'Pacific/Guam' => '태평양/괌',
    'Pacific/Tarawa' => '태평양/타라와',
    'Pacific/Enderbury' => '태평양/엔더베리',
    'Pacific/Kiritimati' => '태평양/키르티마티',
    'Pacific/Saipan' => '태평양/사이판',
    'Pacific/Majuro' => '태평양/마주로',
    'Pacific/Kwajalein' => '태평양/콰절린',
    'Pacific/Truk' => '태평양/투르프제도',
    'Pacific/Ponape' => '태평양/포나페제도',
    'Pacific/Kosrae' => '태평양/코스레',
    'Pacific/Nauru' => '태평양/나우루',
    'Pacific/Noumea' => '태평양/누메아',
    'Pacific/Auckland' => '태평양/오클랜드',
    'Pacific/Chatham' => '태평양/체텀제도',
    'Pacific/Niue' => '태평양/니우에',
    'Pacific/Norfolk' => '태평양/노퍽',
    'Pacific/Palau' => '태평양/팔라우',
    'Pacific/Port_Moresby' => '태평양/포트 모즈비',
    'Pacific/Pitcairn' => '태평양/핏케어섬',
    'Pacific/Pago_Pago' => '태평양/파고파고',
    'Pacific/Apia' => '태평양/아피아',
    'Pacific/Guadalcanal' => '태평양/과달카날섬',
    'Pacific/Fakaofo' => '태평양/파카오포',
    'Pacific/Tongatapu' => '태평양/통가타푸',
    'Pacific/Funafuti' => '태평양/푸나푸티',
    'Pacific/Johnston' => '태평양/존스톤',
    'Pacific/Midway' => '태평양/미드웨이 제도',
    'Pacific/Wake' => '태평양/웨이크',
    'Pacific/Efate' => '태평양/에파트',
    'Pacific/Wallis' => '태평양/월리스',
    'Europe/London' => '유럽/런던',
    'Europe/Dublin' => '유럽/더블린',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => '유럽/티라나',
    'Europe/Andorra' => '유럽/안도라',
    'Europe/Vienna' => '유럽/비엔나',
    'Europe/Minsk' => '유럽/민스크',
    'Europe/Brussels' => '유럽/브러셀',
    'Europe/Sofia' => '유럽/소피아',
    'Europe/Prague' => '유럽/프라하',
    'Europe/Copenhagen' => '유럽 코펜하겐',
    'Atlantic/Faeroe' => '대서양/페로제도',
    'America/Danmarkshavn' => '아메리카/덴마크스하운',
    'America/Scoresbysund' => '아메리카/스콜스비선드',
    'America/Godthab' => '아메리카/고트합',
    'America/Thule' => '아메리카/툴리',
    'Europe/Tallinn' => '유럽/탈린',
    'Europe/Helsinki' => '유럽/헬싱키',
    'Europe/Paris' => '유럽/파리',
    'Europe/Berlin' => '유럽/베를린',
    'Europe/Gibraltar' => '유럽/지브롤터',
    'Europe/Athens' => '유럽/아테네',
    'Europe/Budapest' => '유럽/부다페스트',
    'Atlantic/Reykjavik' => '대서양/레이캬비크',
    'Europe/Rome' => '유럽/로마',
    'Europe/Riga' => '유럽/리가',
    'Europe/Vaduz' => '유럽/바두츠',
    'Europe/Vilnius' => '유럽/빌뉴스',
    'Europe/Luxembourg' => '유럽/룩셈부르크',
    'Europe/Malta' => '유럽/몰타',
    'Europe/Chisinau' => '유럽/키시나우',
    'Europe/Monaco' => '유럽/모나코',
    'Europe/Amsterdam' => '유럽/암스테르담',
    'Europe/Oslo' => '유럽/오슬로',
    'Europe/Warsaw' => '유럽/바르샤바',
    'Europe/Lisbon' => '유럽/리스본',
    'Atlantic/Azores' => '대서양/아조레스 제도',
    'Atlantic/Madeira' => '대서양/마데이라 제도',
    'Europe/Bucharest' => '유럽/부카레스트',
    'Europe/Kaliningrad' => '유럽/칼리닌그라드',
    'Europe/Moscow' => '유럽/모스크바',
    'Europe/Samara' => '유럽/사마라',
    'Asia/Yekaterinburg' => '아시아/예카테린부르크',
    'Asia/Omsk' => '아시아/옴스크',
    'Asia/Novosibirsk' => '아시아/노보시비르스크',
    'Asia/Krasnoyarsk' => '아시아/크라스노야르스크',
    'Asia/Irkutsk' => '아시아/이르쿠츠크',
    'Asia/Yakutsk' => '아시아/야쿠츠크',
    'Asia/Vladivostok' => '아시아/블라디보스토크',
    'Asia/Sakhalin' => '아시아/사할린',
    'Asia/Magadan' => '아시아/아바단',
    'Asia/Kamchatka' => '아시아/캄차카',
    'Asia/Anadyr' => '아시아/아나디리',
    'Europe/Belgrade' => '유럽/벨그라드',
    'Europe/Madrid' => '유럽/마드리드',
    'Africa/Ceuta' => '아프리카/세우타',
    'Atlantic/Canary' => '대서양/카나리아 제도',
    'Europe/Stockholm' => '유럽/스톡홀름',
    'Europe/Zurich' => '유럽/취리히',
    'Europe/Istanbul' => '유럽/이스탄불',
    'Europe/Kiev' => '유럽/키에프',
    'Europe/Uzhgorod' => '유럽/노브고로트',
    'Europe/Zaporozhye' => '유럽/자포로제',
    'Europe/Simferopol' => '유럽/심페로폴',
    'America/New_York' => '아메리카/뉴욕',
    'America/Chicago' => '아메리카/시카고',
    'America/North_Dakota/Center' => '아메리카/다코타/센터',
    'America/Denver' => '아메리카/덴버',
    'America/Los_Angeles' => '아메리카/로스엔젤리스',
    'America/Juneau' => '아메리카/주노',
    'America/Yakutat' => '아메리카/야쿠타트',
    'America/Anchorage' => '아메리카/앵커리지',
    'America/Nome' => '아메리카/놈',
    'America/Adak' => '아메리카/아다크',
    'Pacific/Honolulu' => '태평양/호놀룰루',
    'America/Phoenix' => '아메리카/피닉스',
    'America/Boise' => '아메리카/보이시',
    'America/Indiana/Indianapolis' => '아메리카/인디애나/인디애나폴리스',
    'America/Indiana/Marengo' => '아메리카/인디애나/마렝고',
    'America/Indiana/Knox' => '아메리카/인디애나/녹스',
    'America/Indiana/Vevay' => '아메리카/인디애나/비베이',
    'America/Kentucky/Louisville' => '아메리카/켄터기/루이스빌',
    'America/Kentucky/Monticello' => '아메리카/켄터기/모니첼로',
    'America/Detroit' => '아메리카/디트로이트',
    'America/Menominee' => '아메리카/메노미니',
    'America/St_Johns' => '아메리카/세인트루이스',
    'America/Goose_Bay' => '아메리카/구스베이',
    'America/Halifax' => '아메리카/헬리팩스',
    'America/Glace_Bay' => '아메리카/글레이스베이',
    'America/Montreal' => '아메리카/몬트리올',
    'America/Toronto' => '아메리카/토론토',
    'America/Thunder_Bay' => '아메리카/선더베이',
    'America/Nipigon' => '아메리카/니피곤',
    'America/Rainy_River' => '아메리카/레이니 강',
    'America/Winnipeg' => '아메리카/위니펙',
    'America/Regina' => '아메리카/레지나',
    'America/Swift_Current' => '아메리카/스위프트_커렌트',
    'America/Edmonton' => '아메리타/에드몬턴',
    'America/Vancouver' => '아메리카/벤쿠버',
    'America/Dawson_Creek' => '아메리카/도슨 크릭',
    'America/Pangnirtung' => '아메리카/팡니르텅',
    'America/Iqaluit' => '아메리카/이카루이트',
    'America/Coral_Harbour' => '아메리카/코랄하버',
    'America/Rankin_Inlet' => '아메리카/란킨인렛',
    'America/Cambridge_Bay' => '아메리카/캠프리지베이',
    'America/Yellowknife' => '아메리카/옐로나이프',
    'America/Inuvik' => '아메리카/이누비크',
    'America/Whitehorse' => '아메리카/화이트호스',
    'America/Dawson' => '아메리카/도슨',
    'America/Cancun' => '아메리카/칸쿤',
    'America/Merida' => '아메리카/메리다',
    'America/Monterrey' => '아메리카/몬테레이',
    'America/Mexico_City' => '아메리카/멕시코 시티',
    'America/Chihuahua' => '아메리카/치와와',
    'America/Hermosillo' => '아메리카/에르모시오',
    'America/Mazatlan' => '아메리카/마사틀란',
    'America/Tijuana' => '아메리카/티후아나',
    'America/Anguilla' => '아메리카/앵귈라',
    'America/Antigua' => '아메리카/안티구아',
    'America/Nassau' => '아메리카/나사우',
    'America/Barbados' => '아메리카/바베이도스',
    'America/Belize' => '아메리카/벨리즈',
    'Atlantic/Bermuda' => '대서양/버뮤다',
    'America/Cayman' => '아메리카/케이만',
    'America/Costa_Rica' => '아메리카/코스타리카',
    'America/Havana' => '아메리카/하바나',
    'America/Dominica' => '아메리카/도미니카',
    'America/Santo_Domingo' => '아메리카/산타도밍고',
    'America/El_Salvador' => '아메리카/엘살바도르',
    'America/Grenada' => '아메리카/그레나다',
    'America/Guadeloupe' => '아메리카/과들루프',
    'America/Guatemala' => '아메리카/과테말란',
    'America/Port-au-Prince' => '아메리카/포르토프랭스',
    'America/Tegucigalpa' => '아메리카/테구시갈파',
    'America/Jamaica' => '아메리카/자메이카',
    'America/Martinique' => '아메리카/마르티니크',
    'America/Montserrat' => '아메리카/몬세라트',
    'America/Managua' => '아메리카/마나구아',
    'America/Panama' => '아메리카/파나마',
    'America/Puerto_Rico' => '아메리카/푸에르토리코',
    'America/St_Kitts' => '아메리카/세인트 키츠',
    'America/St_Lucia' => '아메리카/세인트루시아',
    'America/Miquelon' => '아메리카/미클롱',
    'America/St_Vincent' => '아메리카/세인트빈센트',
    'America/Grand_Turk' => '아메리카/그랜드 투르크',
    'America/Tortola' => '아메리카/토르톨라',
    'America/St_Thomas' => '아메리카/세인트토마스',
    'America/Argentina/Buenos_Aires' => '아메리카/아르헨티나/부에노스아이레스',
    'America/Argentina/Cordoba' => '아메리카/아르헨티나/코르도바',
    'America/Argentina/Tucuman' => '아메리카/아르헨티나/투구만',
    'America/Argentina/La_Rioja' => '아메리카/아르헨티나/라리오하',
    'America/Argentina/San_Juan' => '아메리카/아르헨티나/산후안',
    'America/Argentina/Jujuy' => '아메리카/아르헨티나/주주이',
    'America/Argentina/Catamarca' => '아메리카/아르헨티나/카타마르카',
    'America/Argentina/Mendoza' => '아메리카/아르헨티나/멘도사',
    'America/Argentina/Rio_Gallegos' => '아메리카/아르헨티나/리오 갈레고스',
    'America/Argentina/Ushuaia' => '아메리카/아르헨티나/우슈아이아',
    'America/Aruba' => '아메리카/아루바',
    'America/La_Paz' => '아메리카/라파즈',
    'America/Noronha' => '아메리카/노로냐',
    'America/Belem' => '아메리카/벨렘',
    'America/Fortaleza' => '아메리카/포르탈레자',
    'America/Recife' => '아메리카/레시페',
    'America/Araguaina' => '아메리카/아라과이나',
    'America/Maceio' => '아메리카/마세이오',
    'America/Bahia' => '아메리카/바이아',
    'America/Sao_Paulo' => '아메리카/상파울로',
    'America/Campo_Grande' => '아메리카/캄푸그란데',
    'America/Cuiaba' => '아메리카/쿠이아바',
    'America/Porto_Velho' => '아메리카/포르트벨류',
    'America/Boa_Vista' => '아메리카/보아비스타',
    'America/Manaus' => '아메리카/마나우스',
    'America/Eirunepe' => '아메리카/이루네페',
    'America/Rio_Branco' => '아메리카/리오 브랑코',
    'America/Santiago' => '아메리카/산티아고',
    'Pacific/Easter' => '태평양/이스터',
    'America/Bogota' => '아메리카/보고타',
    'America/Curacao' => '아메리카/쿠라사우',
    'America/Guayaquil' => '아메리카/과야킬',
    'Pacific/Galapagos' => '태평양/갈라파고스',
    'Atlantic/Stanley' => '대서양/스탠기',
    'America/Cayenne' => '아메이카/카옌',
    'America/Guyana' => '아메리카/가이아나',
    'America/Asuncion' => '아메리카/아순시온',
    'America/Lima' => '아메리카/리마',
    'Atlantic/South_Georgia' => '대서양/사우스 조지아',
    'America/Paramaribo' => '아메리카/파라마리보',
    'America/Port_of_Spain' => '아메리카/포트오브스페인',
    'America/Montevideo' => '아메리카/몬테비디오',
    'America/Caracas' => '아메리카/카라카스',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = '즐겨찾기';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = '즐겨찾기';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM 스마트 클라우드',
    'Google' => '구글',
    'Box' => 'Box.net',
    'Twitter' => '트위터',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => '구글 연락처',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google 드라이브',
];
$app_list_strings['token_status'] = [
    1 => '요청',
    2 => '접속',
    3 => '무효',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugar사용자',
    'support_portal' => '포탈 지원',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => '캠페인',
    'email' => '다른 이메일:',
    'workflow' => '작업흐름',
    'system' => '시스템',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => '캠페인',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => '캠페인',
    'email' => '다른 이메일:',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => '문서화',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => '2 범위',
    'show_buckets' => '3 범위',
    'show_custom_buckets' => '맞춤 범위',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => '연도순',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => '매년(분기별 하위 기간)',
    'Quarter' => '분기',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => '매출 품목',
    'Opportunities' => '영업기회',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => '예',
    'no' => '아니요',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => '알림',
    'information' => '정보',
    'other' => '기타',
    'success' => '성공',
    'warning' => '경고:',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => '게시',
    'GET' => '받기',
    'PUT' => '올리기',
    'DELETE' => '삭제하기',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => '수동으로',
    '5' => '매 5분마다',
    '15' => '15분 간격',
    '30' => '30분 간격',
    '60' => '매 시간',
];

$app_list_strings['moduleList']['KBDocuments'] = '지식';
$app_list_strings['moduleListSingular']['KBDocuments'] = '지식';
$app_list_strings['moduleList']['KBContents'] = '지식 기반';
$app_list_strings['moduleListSingular']['KBContents'] = '지식 기반 문서';
$app_list_strings['moduleList']['KBArticles'] = '지식기반 조항';
$app_list_strings['moduleListSingular']['KBArticles'] = '지식기반 조항';
$app_list_strings['moduleList']['KBContentTemplates'] = '지식 기반 템플릿';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = '지식 기반 템플릿';
$app_list_strings['moduleList']['EmbeddedFiles'] = '임베드된 파일';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = '임베드된 파일';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => '렉',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'П',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Албански лек',
    'USD' => '달러',
    'AFN' => '아프가니스탄',
    'ARS' => '페소',
    'AWG' => '길더',
    'AUD' => '달러',
    'AZN' => '뉴 마나트',
    'BSD' => '달러',
    'BBD' => '달러',
    'BYR' => '루블',
    'EUR' => '유로',
    'BZD' => '달러',
    'BMD' => '달러',
    'BOB' => '볼리비아노',
    'BAM' => '컨버터블 마카',
    'BWP' => '풀라스',
    'BGN' => '레바',
    'BRL' => '헤알',
    'GBP' => '파운드',
    'BND' => '달러',
    'KHR' => '리엘스',
    'CAD' => '달러',
    'KYD' => '달러',
    'CLP' => '페소',
    'CNY' => '위안',
    'COP' => '페소',
    'CRC' => '콜론',
    'HRK' => '쿠나',
    'CUP' => '페소',
    'CZK' => '코루니',
    'DKK' => '크로네',
    'DOP' => '페소',
    'XCD' => '달러',
    'EGP' => '파운드',
    'SVC' => '콜로네',
    'EEK' => '크로니',
    'FKP' => '파운드',
    'FJD' => '달러',
    'GHC' => '세디스',
    'GIP' => '파운드',
    'GTQ' => '케찰',
    'GGP' => '파운드',
    'GYD' => '달러',
    'HNL' => '렘피라',
    'HKD' => '달러',
    'HUF' => '포린트',
    'ISK' => '크로눌르',
    'INR' => '루피',
    'IDR' => '루피아',
    'IRR' => '리알',
    'IMP' => '파운드',
    'ILS' => '뉴 셰켈',
    'JMD' => '달러',
    'JPY' => '엔',
    'JEP' => '파운드',
    'KZT' => '텡게',
    'KPW' => '획득 성공',
    'KRW' => '획득 성공',
    'KGS' => '솜스',
    'LAK' => '킵스',
    'LVL' => '라티',
    'LBP' => '파운드',
    'LRD' => '달러',
    'CHF' => '스위스 프랑',
    'LTL' => '리타이',
    'MKD' => '디나르',
    'MYR' => '링깃',
    'MUR' => '루피',
    'MXN' => '페소',
    'MNT' => '투그리크',
    'MZN' => '메티칼',
    'NAD' => '달러',
    'NPR' => '루피',
    'ANG' => '길더',
    'NZD' => '달러',
    'NIO' => '코르도바',
    'NGN' => '나이라',
    'NOK' => '크로네',
    'OMR' => '리알',
    'PKR' => '루피',
    'PAB' => '발보아',
    'PYG' => '구아라니',
    'PEN' => '누에보 솔',
    'PHP' => '페소',
    'PLN' => '즐로티크',
    'QAR' => '리알',
    'RON' => '뉴 레이',
    'RUB' => '루블',
    'SHP' => '파운드',
    'SAR' => '리얄',
    'RSD' => '디나르',
    'SCR' => '루피',
    'SGD' => '달러',
    'SBD' => '달러',
    'SOS' => '실링',
    'ZAR' => '랜드',
    'LKR' => '루피',
    'SEK' => '크로노',
    'SRD' => '달러',
    'SYP' => '파운드',
    'TWD' => '뉴 달러',
    'THB' => '바트',
    'TTD' => '달러',
    'TRY' => '리라',
    'TRL' => '리라스',
    'TVD' => '달러',
    'UAH' => '흐리브냐',
    'UYU' => '페소',
    'UZS' => '섬',
    'VEF' => '볼리바르 푸에르테',
    'VND' => '동',
    'YER' => '리알',
    'ZWD' => '짐바브웨 달러',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => '매우 높음',
    '4' => '높음',
    '3' => '중간',
    '2' => '낮음',
    '1' => '매우 낮음',
];
$app_list_strings['process_et_field_type'] = [
    'none' => '없음',
    'future' => '현재 값',
    'old' => '이전 값',
    'both' => '현재 및 이전 값',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => '단일 히트',
];

$app_list_strings['merge_status_list'] = [
    'processing' => '진행중',
    'error' => '오류',
    'success' => '성공',
    'canceled' => '취소됨',
    'document_load' => '템플릿 불러오는 중',
    'tags_extract' => '태그 추출 중',
    'tags_validate' => '태그 검증 중',
    'data_retrieving' => '데이터 검색 중',
    'serialize_document' => '문서 다시 병합 중',
    'send_document' => '귀하에게 문서 전송 중',
];

$app_list_strings['merge_type_list'] = [
    'merge' => '병합',
    'convert' => 'PDF 병합',
    'multimerge' => '다중 병합',
    'multimerge_convert' => 'PDF 다중 병합',
    'labelsgenerate' => '레이블 생성',
    'labelsgenerate_convert' => '레이블 PDF 생성',
    'excel' => 'Excel 병합',
    'excel_convert' => 'Excel 병합 변환',
    'presentation' => 'PowerPoint 병합',
    'presentation_convert' => 'PowerPoint 병합 PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => '내 계정',
    'favorites' => '즐겨찾는 계정',
    'tags' => '태그된 계정',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => '모든 뉴스',
    'General' => '일반',
    'Finance' => '금융',
    'People' => '직원',
    'Press Releases' => '보도자료',
    'Other' => '기타',
];

$app_strings['LBL_OWNERS'] = '소유자';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = '클라우드 드라이브';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = '클라우드 드라이브 통합 대쉬릿';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = '링크 복사';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = '다운로드';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Sugar 문서 생성';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = '이 파일을 다운로드할 수 없습니다';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = '클라우드 대쉬릿이 존재하지 않습니다';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar 문서 생성 완료';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'DocuSign에 전송';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = '이 위치에서는 DocuSign을 사용할 수 없습니다.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = '이 위치에서는 워드/엑셀/파워포인트로 문서 병합을 사용할 수 없습니다.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = '이 위치에서는 DocuSign으로 문서 병합을 사용할 수 없습니다.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = '이 위치에서는 PDF로 문서 병합을 사용할 수 없습니다.';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = '서명된 파일은 이 위치에 업로드할 권한이 있는 경우에만 여기에 업로드됩니다.';
$app_strings['LBL_DOC_MERGE_TO'] = '문서 병합';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = '내 파일';
$app_strings['LBL_SHARED_WITH_ME'] = '나에게 공유됨';
$app_strings['LBL_CLOUD_PROVIDER'] = '클라우드 제공업체';

$app_list_strings['drive_types'] = [
    'google' => 'Google 드라이브',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox 드라이브',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = '나에게 공유됨';
$app_strings['LBL_MY_FILES'] = '내 파일';
$app_strings['LBL_UPLOAD_FILE'] = '파일 업로드';
$app_strings['LBL_FOLDER_NOT_FOUND'] = '폴더 발견되지 않음';
$app_strings['LBL_CREATE_FOLDER'] = '폴더 만들기';
$app_strings['LBL_LOAD_MORE'] = '더 불러오기...';
$app_strings['LBL_NEW_FOLDER'] = '새 폴더';
$app_strings['LBL_FOLDER_NAME'] = '폴더명: ';
$app_strings['LBL_PERMISSION_ERROR'] = '현재 경로에서 해당 작업을 할 권한이 없습니다.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = '현재 경로에서 이동할 권한이 없습니다.';
$app_strings['LBL_FILE_UPLOADED'] = '파일이 업로드되었습니다.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = '파일 크기가 커서 업로드에 시간이 걸릴 수 있습니다.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = '하나 이상의 문서 기록에 첨부 파일이 없습니다. 기록에 파일을 첨부하고 다시 시도하거나, 특정 기록을 파일과 개별적으로 동기화하십시오.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Google과의 연결을 찾을 수 없습니다...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Microsoft와의 연결을 찾을 수 없습니다...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Dropbox 연결을 찾을 수 없습니다...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'OneDrive 동기화에 시간이 걸릴 수 있습니다';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = '이 파일을 삭제하시겠습니까?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDrive 업로드가 완료되었습니다.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = '업로드되었습니다.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = '경로 로드 중 오류.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = '파일이 손상되어 오류가 발생했습니다.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = '<i>"{{documentName}}"</i> 문서가 클라우드 드라이브에 저장되었으며 문서 모듈에 추가되었습니다.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = '이 파일을 삭제할 권한이 없습니다.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = '이 폴더를 삭제할 권한이 없습니다.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = '이 위치에 파일을 업로드할 권한이 없습니다.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = '이 위치에 폴더를 만들 권한이 없습니다.';
$app_strings['LBL_NO_FOLDER_CREATE'] = '이 위치에는 폴더를 만들 수 없습니다.';
$app_strings['LBL_NO_FILE_UPLOAD'] = '이 위치에는 파일을 업로드할 수 없습니다.';
$app_strings['LBL_SITES'] = '사이트';
$app_strings['LBL_SHARED'] = '공유됨';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = '링크가 생성되었습니다. 버튼을 클릭하여 클립보드에 링크를 복사합니다.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = '클립보드로 복사';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-빈칸-',
    'Exact' => '일치',
    'Null_address_components' => '주소 구성 요소가 하나 이상 비어 있습니다',
    'Invalid_address' => '잘못된 주소, 서버가 False 반환',
    'Invalid_server_response_not_XML' => '잘못된 서버 응답, XML 아님',
    'Invalid_address_no_location' => '잘못된 주소, 서버에서 위치 반환하지 않음',
    'Ambiguous_address' => '모호한 주소, 일치 여러 개',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => '도로',
    'a' => '상공',
    'rd' => '밤 도로',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', '영어(US)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['동부 표준시', '뉴욕(EST)'],
    ['태평양 표준시', '로스앤젤레스(PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['신규', '신규'],
    ['배정됨', '배정됨'],
    ['완료됨', '완료됨'],
    ['응답대기', '응답대기'],
    ['거부됨', '거부됨'],
    ['복사', '복사'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['관리', '관리'],
    ['제품', '제품'],
    ['사용자', '사용자'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', '높음'],
    ['P2', '보통'],
    ['P3', '낮음'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['사용자', '사용자'],
    ['관리자, 사용자', '관리자'],
    ['계정 매니저,사용자', '계정 매니저'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', '지난 30일'],
    ['last_90_days', '지난 90일'],
    ['올해', '작년'],
    ['커스텀', '사용자정의 범위'],
    ['전체', '전체'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['기본', '기본'],
    ['색', '단일 컬러'],
    ['Url', '사용자 지정 이미지'],
];
