<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'Japanese',
    'moduleList' => [
        'Home' => 'ホーム',
        'Contacts' => '取引先担当者',
        'Accounts' => '取引先',
        'Opportunities' => '商談',
        'Cases' => 'ケース',
        'Notes' => 'メモ',
        'Calls' => '電話',
        'Emails' => 'Eメール',
        'Meetings' => '会議',
        'Tasks' => 'タスク',
        'Calendar' => 'カレンダー',
        'Leads' => 'リード',
        'Currencies' => '通貨',
        'Contracts' => '契約',
        'Quotes' => '見積',
        'Products' => '見積済商品',
        'WebLogicHooks' => 'WEBロジックフック',
        'ProductCategories' => '商品カテゴリ',
        'ProductTypes' => '商品タイプ',
        'ProductTemplates' => '商品カタログ',
        'ProductBundles' => '製品バンドル',
        'ProductBundleNotes' => '製品バンドルノート',
        'Reports' => 'レポート',
        'Forecasts' => '売上予測',
        'ForecastWorksheets' => '売上予測ワークシート',
        'ForecastManagerWorksheets' => '売上予測マネージャワークシート',
        'VisualPipeline' => 'ビジュアルパイプライン',
        'ConsoleConfiguration' => 'コンソール設定',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'ノルマ',
        'Teams' => 'チーム',
        'TeamNotices' => 'チームへの連絡一覧',
        'Manufacturers' => '製造元',
        'Activities' => 'アクティビティ',
        'Comments' => 'コメント',
        'Subscriptions' => '購読',
        'Bugs' => 'バグトラッカー',
        'Feeds' => 'RSSフィード',
        'iFrames' => '私のサイト',
        'TimePeriods' => '期間',
        'TaxRates' => '税率',
        'ContractTypes' => '契約タイプ',
        'Schedulers' => 'スケジューラー',
        'Project' => 'プロジェクト',
        'ProjectTask' => 'プロジェクトタスク',
        'Campaigns' => 'キャンペーン',
        'CampaignLog' => 'キャンペーンログ',
        'CampaignTrackers' => 'キャンペーントラッカー',
        'Documents' => 'ドキュメント',
        'DocumentRevisions' => 'ドキュメントの版',
        'Connectors' => 'コネクタ',
        'Notifications' => '通知',
        'Sync' => '同期',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => '外部ユーザー',
        'ReportMaker' => 'エンタープライズレポート',
        'DataSets' => 'データフォーマット',
        'CustomQueries' => 'カスタムクエリ',
        'pmse_Inbox' => 'プロセス',
        'pmse_Project' => 'プロセス定義',
        'pmse_Business_Rules' => 'プロセスビジネスルール',
        'pmse_Emails_Templates' => 'プロセスEメールテンプレート',
        'BusinessCenters' => 'ビジネスセンター',
        'Shifts' => 'シフト',
        'ShiftExceptions' => 'シフトの例外',
        'Purchases' => '購入',
        'PurchasedLineItems' => '購入商品',
        'MobileDevices' => 'モバイルデバイス',
        'PushNotifications' => 'プッシュ通知',
        'Escalations' => 'エスカレーション',
        'DocumentTemplates' => 'ドキュメントのテンプレート',
        'DocumentMerges' => 'ドキュメントマージ',
        'CloudDrivePaths' => 'クラウドドライブパス',
        'WorkFlow' => 'ワークフロー:',
        'EAPM' => '外部アカウント',
        'Worksheet' => 'ワークシート',
        'Users' => 'ユーザ',
        'Employees' => '従業員',
        'Administration' => '管理',
        'ACLRoles' => '役割',
        'InboundEmail' => 'グループEメールアカウント',
        'Releases' => 'リリース',
        'Prospects' => 'ターゲット',
        'Queues' => 'キュー',
        'EmailMarketing' => 'Eメールマーケティング',
        'EmailTemplates' => 'Eメールテンプレート',
        'SNIP' => 'Eメールアーカイブ',
        'ProspectLists' => 'ターゲットリスト一覧',
        'SavedSearch' => '保存された検索',
        'UpgradeWizard' => 'アップグレードウィザード',
        'Trackers' => 'トラッカー',
        'TrackerPerfs' => 'パフォーマンストラッカー',
        'TrackerSessions' => 'セッショントラッカー',
        'TrackerQueries' => 'トラッカークエリ',
        'FAQ' => 'FAQ',
        'Newsletters' => 'ニュースレター',
        'SugarFavorites' => 'お気に入り',
        'PdfManager' => 'PDF設定',
        'DataArchiver' => 'データアーカイバー',
        'ArchiveRuns' => 'アーカイブ実行回数',

        'OAuthKeys' => 'OAuthコンシューマキー',
        'OAuthTokens' => 'OAuthトークン',
        'Filters' => 'フィルタ',
        'UserSignatures' => 'メール署名',
        'Shippers' => '運送会社',
        'Styleguide' => 'スタイルガイド',
        'Feedbacks' => 'フィードバック',
        'Tags' => 'タグ',
        'Categories' => 'カテゴリ',
        'Dashboards' => 'ダッシュボード',
        'OutboundEmail' => 'メール設定',
        'EmailParticipants' => 'メール参加者',
        'DataPrivacy' => 'データプライバシー',
        'ReportSchedules' => 'レポートスケジュール',
        'CommentLog' => 'コメントログ',
        'Holidays' => '休日',
        'ChangeTimers' => 'タイマー変更',
        'Metrics' => 'メトリックス',
        'Messages' => 'メッセージ',
        'Audit' => '監査',
        'RevenueLineItems' => '商談品目',
        'DocuSignEnvelopes' => 'DocuSignエンベロープ',
        'Geocode' => 'ジオコード',
        'DRI_Workflows' => 'スマートガイド',
        'DRI_Workflow_Task_Templates' => 'スマートガイドアクティビティテンプレート',
        'DRI_SubWorkflows' => 'スマートガイドステージ',
        'DRI_Workflow_Templates' => 'スマートガイドテンプレート',
        'CJ_WebHooks' => 'Sugar Automate ウェブフック',
        'CJ_Forms' => 'Smart Guide Sugarアクション',
        'DRI_SubWorkflow_Templates' => 'スマートガイドステージテンプレート',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Subモジュールのイベントプッシュサブスクリプション',
    ],

    'moduleIconList' => [
        'Home' => 'ホーム',
        'Contacts' => '取引先担当者',
        'Accounts' => '取引先',
        'Opportunities' => '商談',
        'Cases' => 'ケース',
        'Notes' => 'メモ',
        'Calls' => '電話',
        'Emails' => 'Eメール',
        'Meetings' => '会議',
        'Tasks' => 'タスク',
        'Calendar' => '会議',
        'Leads' => 'リード',
        'Currencies' => '通貨',
        'Contracts' => '契約',
        'Quotes' => '見積',
        'Products' => '商品',
        'WebLogicHooks' => 'WEBロジックフック',
        'ProductCategories' => 'PG',
        'ProductTypes' => '商品タイプ',
        'ProductTemplates' => '商品テンプレート',
        'ProductBundles' => '製品バンドル',
        'ProductBundleNotes' => '製品バンドル',
        'Reports' => 'レポート',
        'Forecasts' => '売上予測',
        'ForecastWorksheets' => '売上予測ワークシート',
        'ForecastManagerWorksheets' => '売上予測管理ワークシート',
        'Quotas' => 'Fo',
        'VisualPipeline' => 'ビジュアルパイプライン',
        'ConsoleConfiguration' => 'コンソール設定',
        'SugarLive' => 'SugarLive',
        'Teams' => 'チーム',
        'TeamNotices' => 'チームへの連絡',
        'Manufacturers' => '製造元',
        'Activities' => 'アクティビティ',
        'Comments' => 'コメント',
        'Subscriptions' => 'サブスクリプション',
        'Bugs' => 'バグ',
        'Feeds' => 'フィード',
        'iFrames' => 'iFrame',
        'TimePeriods' => '期間',
        'TaxRates' => '税率',
        'ContractTypes' => '契約タイプ',
        'Schedulers' => 'スケジューラー',
        'Project' => 'プロジェクト',
        'ProjectTask' => 'プロジェクトタスク',
        'Campaigns' => 'キャンペーン',
        'CampaignLog' => 'キャンペーンログ',
        'CampaignTrackers' => 'キャンペーントラッカー',
        'Documents' => 'ドキュメント',
        'DocumentRevisions' => 'ドキュメントの版',
        'Connectors' => 'コネクタ',
        'Notifications' => '通知',
        'Sync' => '同期',
        'HintAccountsets' => 'Hintアカウントセット',
        'HintNotificationTargets' => 'Hint通知対象',
        'HintNewsNotifications' => 'Hintニュース通知',
        'HintEnrichFieldConfigs' => 'Hintエンリッチフィールド設定',
        'ExternalUsers' => '外部ユーザー',
        'ReportMaker' => 'レポートメーカー',
        'DataSets' => 'データセット',
        'CustomQueries' => 'カスタムクエリ',
        'pmse_Inbox' => 'pmse受信箱',
        'pmse_Project' => 'pmseプロジェクト',
        'pmse_Business_Rules' => 'pmseビジネスルール',
        'pmse_Emails_Templates' => 'pmse Eメールテンプレート',
        'BusinessCenters' => 'BC',
        'Shifts' => 'シフト',
        'ShiftExceptions' => 'シフトの例外',
        'Purchases' => '購入',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'モバイルデバイス',
        'PushNotifications' => 'プッシュ通知',
        'Escalations' => 'エスカレーション',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'ワークフロー',
        'EAPM' => 'EAPM',
        'Worksheet' => 'ワークシート',
        'Users' => 'ユーザー',
        'Employees' => '従業員',
        'Administration' => '管理',
        'ACLRoles' => 'ACLの役割',
        'InboundEmail' => 'インバウンドEメール',
        'Releases' => 'リリース',
        'Prospects' => '見込み客',
        'Queues' => 'キュー',
        'EmailMarketing' => 'Eメールマーケティング',
        'EmailTemplates' => 'Eメールテンプレート',
        'SNIP' => 'SNIP',
        'ProspectLists' => 'ターゲットリスト',
        'SavedSearch' => '保存済検索',
        'UpgradeWizard' => 'アップグレードウィザード',
        'Trackers' => 'トラッカー',
        'TrackerPerfs' => 'パフォーマンストラッカー',
        'TrackerSessions' => 'セッショントラッカー',
        'TrackerQueries' => 'トラッカークエリ',
        'FAQ' => 'FAQ',
        'Newsletters' => 'ニュースレター',
        'SugarFavorites' => 'お気に入り',
        'PdfManager' => 'PDFマネージャー',
        'DataArchiver' => 'データアーカイバー',
        'ArchiveRuns' => 'アーカイブ実行回数',
        'OAuthKeys' => 'OAuthキー',
        'OAuthTokens' => 'OAuthトークン',
        'Filters' => 'フィルター',
        'UserSignatures' => 'ユーザーの署名',
        'Shippers' => '運送会社',
        'Styleguide' => 'スタイルガイド',
        'Feedbacks' => 'フィードバック',
        'Tags' => 'タグ',
        'Categories' => 'カテゴリー',
        'Dashboards' => 'Ds',
        'OutboundEmail' => '送信Eメール',
        'EmailParticipants' => 'メール参加者',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'レポートスケジュール',
        'CommentLog' => 'コメントログ',
        'Holidays' => '休日',
        'ChangeTimers' => 'タイマー変更',
        'Metrics' => 'メトリクス',
        'Messages' => 'メッセージ',
        'Audit' => '監査',
        'RevenueLineItems' => '商談品目',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'ジオコード',
        'DRI_Workflows' => 'DRIワークフロー',
        'DRI_Workflow_Task_Templates' => 'DRIワークフロータスクテンプレート',
        'DRI_SubWorkflows' => 'DRIサブワークフロー',
        'DRI_Workflow_Templates' => 'DRIワークフローテンプレート',
        'CJ_WebHooks' => 'CJウェブフック',
        'CJ_Forms' => 'CJフォーム',
        'DRI_SubWorkflow_Templates' => 'DRIサブワークフローテンプレート',
        'Library' => 'ライブラリ',
        'EmailAddresses' => 'Eメールアドレス',
        'Words' => 'ワード',
        'Sugar_Favorites' => 'お気に入り',
        'KBDocuments' => 'KBドキュメント',
        'KBContents' => 'KBコンテンツ',
        'KBArticles' => 'KB記事',
        'KBContentTemplates' => 'KBコンテンツテンプレート',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => '埋め込みファイル',
    ],

    'moduleListSingular' => [
        'Home' => 'ホーム',
        'Dashboards' => 'ダッシュボード',
        'Styleguide' => 'スタイルガイド',
        'Contacts' => '取引先担当者',
        'Accounts' => '取引先',
        'Opportunities' => '商談',
        'Cases' => 'ケース',
        'Notes' => 'メモ',
        'Calls' => '電話',
        'Emails' => 'Eメール',
        'Meetings' => '会議',
        'Tasks' => 'タスク',
        'Calendar' => 'カレンダー',
        'Leads' => 'リード',
        'Manufacturers' => '製造元',
        'VisualPipeline' => 'VisualPipeline',
        'ConsoleConfiguration' => 'コンソール設定',
        'MobileDevices' => 'モバイルデバイス',
        'SugarLive' => 'SugarLive',
        'Contracts' => '契約',
        'Quotes' => '見積',
        'Products' => '見積済商品',
        'ProductCategories' => '商品カテゴリ',
        'ProductBundles' => '製品バンドル',
        'ProductBundleNotes' => '製品バンドルノート',
        'RevenueLineItems' => '商談品目',
        'WebLogicHooks' => 'WEBロジックフック',
        'Reports' => 'レポート',
        'Forecasts' => '売上予測',
        'ForecastWorksheets' => '売上予測ワークシート',
        'ForecastManagerWorksheets' => '売上予測マネージャーワークシート',
        'Quotas' => 'ノルマ',
        'Teams' => 'チーム',
        'TeamNotices' => 'チームへの連絡',
        'Activities' => 'アクティビティ',
        'ActivityStream' => '活動',
        'Bugs' => 'バグトラッカー',
        'Feeds' => 'RSSフィード',
        'iFrames' => '私のサイト',
        'TimePeriods' => '期間',
        'TaxRates' => '税率',
        'ContractTypes' => '契約タイプ',
        'Schedulers' => 'スケジューラー',
        'Campaigns' => 'キャンペーン',
        'CampaignLog' => 'キャンペーンログ',
        'Project' => 'プロジェクト',
        'ProjectTask' => 'プロジェクトタスク',
        'Prospects' => 'ターゲット',
        'ProspectLists' => 'ターゲット一覧',
        'CampaignTrackers' => 'キャンペーントラッカー',
        'Documents' => 'ドキュメント',
        'DocumentRevisions' => 'ドキュメント版数',
        'Connectors' => 'コネクタ',
        'Notifications' => '通知',
        'Sync' => '同期',
        'PdfManager' => 'PDF設定',
        'DataArchiver' => 'データアーカイバー',
        'ArchiveRuns' => 'アーカイブ実行回数',
        'ExternalUsers' => '外部ユーザー',
        'ReportMaker' => ' エンタープライズレポート',
        'DataSets' => 'データフォーマット',
        'CustomQueries' => 'カスタムクエリ',
        'pmse_Inbox' => 'プロセス',
        'pmse_Project' => 'プロセス定義',
        'pmse_Business_Rules' => 'プロセスビジネス定義',
        'pmse_Emails_Templates' => 'プロセスEメールテンプレート',
        'BusinessCenters' => 'ビジネスセンター',
        'Shifts' => 'シフト',
        'ShiftExceptions' => 'シフトの例外',
        'Purchases' => '購入',
        'PurchasedLineItems' => '購入商品',
        'PushNotifications' => 'プッシュ通知',
        'Escalations' => 'エスカレーション',
        'DocumentTemplates' => 'ドキュメントのテンプレート',
        'DocumentMerges' => 'ドキュメントマージ',
        'CloudDrivePaths' => 'クラウドドライブパス',
        'WorkFlow' => 'ワークフロー',
        'EAPM' => '外部アカウント',
        'Worksheet' => 'ワークシート',
        'Users' => 'アサイン先',
        'SugarFavorites' => 'お気に入り',
        'Employees' => '従業員',
        'Administration' => '管理',
        'ACLRoles' => '役割',
        'InboundEmail' => 'グループEメールアカウント',
        'Releases' => 'リリース',
        'Queues' => 'メールキュー',
        'EmailMarketing' => 'Eメールマーケティング',
        'EmailTemplates' => 'Eメールテンプレート',
        'SNIP' => 'Eメールアーカイブ',
        'SavedSearch' => '保存された検索',
        'UpgradeWizard' => 'アップグレードウィザード',
        'Trackers' => 'トラッカー',
        'TrackerPerfs' => 'パフォーマンストラッカー',
        'TrackerSessions' => 'トラッカーセッション',
        'TrackerQueries' => 'トラッカークエリ',
        'FAQ' => 'FAQ',
        'Newsletters' => 'ニュースレター',
        'OAuthKeys' => 'OAuth コンシューマキー',
        'OAuthTokens' => 'OAuthトークン',
        'Filters' => '絞り込み',
        'Comments' => 'コメント',
        'CommentLog' => 'コメントログ',
        'Currencies' => '通貨',
        'ProductTemplates' => 'Product',
        'ProductTypes' => '商品タイプ',
        'Shippers' => '発送元',
        'Subscriptions' => '購読',
        'UserSignatures' => 'メール署名',
        'Feedbacks' => 'フィードバック',
        'Tags' => 'タグ',
        'Categories' => 'カテゴリ',
        'OutboundEmail' => 'メール設定',
        'EmailParticipants' => 'メール参加者',
        'DataPrivacy' => 'データプライバシー',
        'ReportSchedules' => 'レポートスケジュール',
        'Holidays' => '休日',
        'ChangeTimers' => 'タイマー変更',
        'Metrics' => 'メトリック',
        'Messages' => 'メッセージ',
        'Audit' => '監査',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => 'ジオコード',
        'DRI_Workflows' => 'スマートガイド',
        'DRI_Workflow_Task_Templates' => 'スマートガイドアクティビティテンプレート',
        'DRI_SubWorkflows' => 'スマートガイドステージ',
        'DRI_Workflow_Templates' => 'スマートガイドテンプレート',
        'CJ_WebHooks' => 'Sugar Automate ウェブフック',
        'CJ_Forms' => 'Smart Guide Sugarアクション',
        'DRI_SubWorkflow_Templates' => 'スマートガイドステージテンプレート',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Subモジュールのイベントプッシュサブスクリプション',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'はい',
        '2' => 'いいえ',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'いいえ',
        1 => 'はい',
    ],

    'notifications_status_dom' => [
        0 => '未読',
        1 => '既読',
    ],

    'optout_dom' => [
        '' => '-なし-',
        'false' => 'いいえ',
        'true' => 'はい',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'アナリスト',
        'Competitor' => '競合他社',
        'Customer' => '顧客',
        'Integrator' => 'インテグレーター',
        'Investor' => '投資家',
        'Partner' => 'パートナー',
        'Press' => 'プレス',
        'Prospect' => '見込み顧客',
        'Reseller' => 'リセラー',
        'Other' => 'その他',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'アパレル',
        'Banking' => '銀行業',
        'Biotechnology' => 'バイオテクノロジー',
        'Chemicals' => '化学薬品',
        'Communications' => '通信',
        'Construction' => '建設',
        'Consulting' => 'コンサルティング',
        'Education' => '教育',
        'Electronics' => '電子機器',
        'Energy' => 'エネルギー',
        'Engineering' => '工学',
        'Entertainment' => '娯楽',
        'Environmental' => '環境',
        'Finance' => 'ファイナンス',
        'Government' => '政府',
        'Healthcare' => '健康管理',
        'Hospitality' => 'ホスピタリティ',
        'Insurance' => '保険',
        'Machinery' => '機械',
        'Manufacturing' => '製造',
        'Media' => 'メディア',
        'Not For Profit' => '非営利',
        'Recreation' => 'レジャー',
        'Retail' => '小売り',
        'Shipping' => '配送',
        'Technology' => '技術',
        'Telecommunications' => '電気通信',
        'Transportation' => '輸送',
        'Utilities' => '公共',
        'Other' => 'その他',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF および CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'チャート',
        'Data Table' => 'データテーブル',
        'Chart and Data Table' => 'チャートとデータテーブル',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => '進行中',
        'Completed' => '完了',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => '受信',
        'Outbound' => '送信',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'チャット',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => '層 1',
        'T2' => '層 2',
        'T3' => '層 3',
        'T4' => '層 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'はい',
        'No' => 'いいえ',
        'Completed' => '完了',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => '将来',
        'Active' => 'アクティブ',
        'Past' => '過去',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => '自家生成',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => '電話勧誘',
        'Existing Customer' => '既存の顧客',
        'Self Generated' => '自家生成',
        'Employee' => '従業員',
        'Partner' => 'パートナー',
        'Public Relations' => '広報',
        'Direct Mail' => 'ダイレクトメール',
        'Conference' => '会議',
        'Trade Show' => '展示会',
        'Web Site' => 'ウェブサイト',
        'Word of mouth' => '口コミ',
        'Email' => 'Eメール',
        'Campaign' => 'キャンペーン',
        'Support Portal User Registration' => 'サポートポータルユーザ登録',
        'Other' => 'その他',
    ],
    'metric_status_dom' => [
        'Inactive' => '非アクティブ',
        'Active' => 'アクティブ',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => '既存ビジネス',
        'New Business' => '新規ビジネス',
    ],
    'taxrate_status_dom' => [
        'Active' => 'アクティブ',
        'Inactive' => 'アクティブでない',
    ],
    'roi_type_dom' => [
        'Revenue' => '収益',
        'Investment' => '投資',
        'Expected_Revenue' => '売上予算',
        'Budget' => '予算',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => '主要な意思決定者',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => '主要な意思決定者',
        'Business Decision Maker' => '事業意思決定者',
        'Business Evaluator' => '事業評価担当者',
        'Technical Decision Maker' => '技術の意思決定者',
        'Technical Evaluator' => '技術評価担当者',
        'Executive Sponsor' => '重役出資者',
        'Influencer' => '影響を与える人',
        'Other' => 'その他',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'アクティブ',
        'Inactive' => 'アクティブでない',
    ],

    'shipper_status_dom' => [
        'Active' => 'アクティブ',
        'Inactive' => '非アクティブ',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => '主な連絡窓口',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => '主な連絡窓口',
        'Alternate Contact' => '代わりの問い合わせ先',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'フィールド値の横',
        'field_on_top' => 'フィールド値の上',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => '15日支払い',
        'Net 30' => '30日支払い',
    ],
    'sales_stage_default_key' => '引き合い',
    'fts_type' => [
        'Elastic' => '拡張検索',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => '引き合い',
        'Qualification' => '見込み',
        'Needs Analysis' => 'ニーズ分析',
        'Value Proposition' => '提案中',
        'Id. Decision Makers' => '意思決定者確認中',
        'Perception Analysis' => '顧客評価中',
        'Proposal/Price Quote' => '最終提案/見積中',
        'Negotiation/Review' => '交渉/見直し',
        'Closed Won' => '完了',
        'Closed Lost' => '失注',
    ],
    'sales_status_with_quote_dom' => [
        'New' => '新規',
        'In Progress' => '進行中',
        'Closed Won' => '完了',
        'Closed Lost' => '失注',
        'Converted to Quote' => '見積もりに変換',
    ],
    'sales_status_dom' => [
        'New' => '新規',
        'In Progress' => '進行中',
        'Closed Won' => '完了',
        'Closed Lost' => '失注',
    ],

    'commit_stage_binary_dom' => [
        'include' => '含む',
        'exclude' => '除く',
    ],
    'commit_stage_dom' => [
        'include' => '含む',
        'upside' => '上部',
        'exclude' => '除く',
    ],

    'commit_stage_custom_dom' => [
        'include' => '含む',
        'upside' => '上部',
        'exclude' => '除く',
    ],

    'in_total_group_stages' => [
        'Draft' => 'ドラフト',
        'Negotiation' => '交渉',
        'Delivered' => '出荷済み',
        'On Hold' => '保留中',
        'Confirmed' => '確認済み',
        'Closed Accepted' => '受領完了',
        'Closed Lost' => '失注',
        'Closed Dead' => '非商談',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => '電話',
        'Meeting' => '会議',
        'Task' => 'タスク',
        'Email' => 'Eメール',
        'Note' => 'メモ',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => '様',
        'Ms.' => '様',
        'Mrs.' => '様',
        'Dr.' => '様',
        'Prof.' => '先生',
        'Mx.' => '様',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'なし',
        60 => '1分前',
        300 => '5分前',
        600 => '10分前',
        900 => '15分前',
        1800 => '30分前',
        3600 => '1時間前',
        7200 => '2時間前',
        10800 => '3時間前',
        18000 => '5時間前',
        86400 => '1日前',
        ],

        'task_priority_default' => '中',
        'task_priority_dom' => [
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'task_status_default' => '開始していません',
        'task_status_dom' => [
        'Not Started' => '開始していません',
        'In Progress' => '進行中',
        'Completed' => '完了',
        'Pending Input' => '保留中',
        'Deferred' => '延期',
        'Not Applicable' => '該当なし',
        ],
        'meeting_status_default' => '計画済み',
        'meeting_status_dom' => [
        'Planned' => 'スケジュール済み',
        'Held' => '保留中',
        'Not Held' => 'キャンセル済み',
        'Deferred' => '延期',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'その他',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => '計画済み',
        'call_status_dom' => [
        'Planned' => 'スケジュール済み',
        'In Progress' => '進行中',
        'Held' => '保留中',
        'Not Held' => 'キャンセル済み',
        'Deferred' => '延期',
        ],
        'call_direction_default' => '送信',
        'call_direction_dom' => [
        'Inbound' => '受信',
        'Outbound' => '送信',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => '新規',
        'Assigned' => 'アサイン済み',
        'In Process' => '進行中',
        'Converted' => 'コンバート済み',
        'Recycled' => '再利用済み',
        'Dead' => 'デッド',
        ],
        'gender_list' => [
        'male' => '男性',
        'female' => '女性',
        'other' => 'その他',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => '新規',
        'case_status_dom' => [
        'New' => '新規',
        'Assigned' => 'アサイン済み',
        'Closed' => '完了',
        'Pending Input' => '保留中',
        'Rejected' => '拒否',
        'Duplicate' => '複製',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => '高',
        'P2' => '中',
        'P3' => '低',
        ],
        'user_type_dom' => [
        'RegularUser' => '一般ユーザ',
        'Administrator' => '管理者',
        ],
        'user_type_bool_dom' => [
            false => '一般ユーザ',
            true => '管理者',
        ],
        'user_type_group_bool_dom' => [
            true => 'グループユーザ',
        ],
        'user_type_portal_bool_dom' => [
            true => 'ポータルAPIユーザ',
        ],
        'license_type_dom' => [
        'CURRENT' => '現在の製品',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'アクティブ',
        'Inactive' => '非アクティブ',
        ],
        'employee_status_dom' => [
        'Active' => 'アクティブ',
        'Terminated' => '終了',
        'Leave of Absence' => '休職',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'アクティブ',
        'Inactive' => '非アクティブ',
        ],
        'project_task_priority_options' => [
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'project_task_priority_default' => '中',

        'project_task_status_options' => [
        'Not Started' => '開始していません',
        'In Progress' => '進行中',
        'Completed' => '完了',
        'Pending Input' => '保留中',
        'Deferred' => '延期',
        ],
        'project_task_utilization_options' => [
        '0' => 'なし',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'ドラフト',
        'In Review' => 'レビュー中',
        'Published' => '公開済み',
        ],
        'project_status_default' => 'ドラフト',

        'project_duration_units_dom' => [
        'Days' => '日間',
        'Hours' => '時間',
        ],

        'project_priority_options' => [
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'project_priority_default' => '中',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => '取引先',
        'record_type_display' => [
        '' => '',
        'Accounts' => '取引先',
        'Opportunities' => '商談',
        'Cases' => 'ケース',
        'Leads' => 'リード',
        'Contacts' => '取引先担当者', // cn (11/22/2005) added to support Emails
        'Products' => '見積済商品',
        'Quotes' => '見積',
        'Bugs' => 'バグトラッカー',
        'Project' => 'プロジェクト',

        'Prospects' => 'ターゲット',
        'ProjectTask' => 'プロジェクトタスク',

        'Tasks' => 'タスク',
        'KBContents' => 'ナレッジベース',
        'Notes' => 'メモ',
        ],

        'record_type_display_notes' => [
        'Accounts' => '取引先',
        'Contacts' => '取引先担当者',
        'Opportunities' => '商談',
        'Tasks' => 'タスク',
        'ProductTemplates' => '商品カタログ',
        'Quotes' => '見積',
        'Products' => '見積済商品',
        'Contracts' => '契約',
        'Emails' => 'Eメール',

        'Bugs' => 'バグトラッカー',
        'Project' => 'プロジェクト',
        'ProjectTask' => 'プロジェクトタスク',
        'Prospects' => 'ターゲット',
        'Cases' => 'ケース',
        'Leads' => 'リード',

        'Meetings' => '会議',
        'Calls' => '電話',
        'KBContents' => 'ナレッジベース',
        'PurchasedLineItems' => '購入商品',
        'Purchases' => '購入',
        'Escalations' => 'エスカレーション',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => '取引先',
        'Contacts' => '取引先担当者',
        'Employees' => '従業員',
        'Leads' => 'リード',
        'Prospects' => 'ターゲット',
        'Users' => 'ユーザ',
        ],

        'parent_type_display' => [
        'Accounts' => '取引先',
        'Contacts' => '取引先担当者',
        'Tasks' => 'タスク',
        'Opportunities' => '商談',
        'Products' => '見積済商品',
        'Quotes' => '見積',

        'Bugs' => 'バグトラッカー',
        'Cases' => 'ケース',
        'Leads' => 'リード',

        'Project' => 'プロジェクト',
        'ProjectTask' => 'プロジェクトタスク',

        'Prospects' => 'ターゲット',
        'KBContents' => 'ナレッジベース',
        'Notes' => 'メモ',
        'PurchasedLineItems' => '購入商品',
        'Purchases' => '購入',
        'Escalations' => 'エスカレーション',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'ケース',
        ],

        'product_status_default_key' => '発送済',
        'product_status_quote_key' => 'Quotes',
        'product_status_dom' => [
        '' => '',
        'Quotes' => '見積完了',
        'Orders' => '注文完了',
        'Ship' => '出荷完了',
        ],
        'active_status_dom' => [
        'Active' => 'アクティブ',
        'Inactive' => '非アクティブ',
        'Retired' => '退職',
        ],
        'appearance_options' => [
        'system_default' => 'システム設定を使用する',
        'light' => '明るい',
        'dark' => '暗い',
        ],


        'pricing_formula_default_key' => '修理済み',
        'pricing_formula_dom' => [
        'Fixed' => '固定価格',
        'ProfitMargin' => '利益率',
        'PercentageMarkup' => '積み上げ率',
        'PercentageDiscount' => '値下げ率',
        'IsList' => '表示価格と同じ',
        ],
        'product_template_status_dom' => [
        'Available' => '在庫あり',
        'Unavailable' => '在庫切れ',
        ],
        'tax_class_dom' => [
        'Taxable' => '課税',
        'Non-Taxable' => '非課税',
        ],
        'support_term_dom' => [
        '+6 months' => '6カ月',
        '+1 year' => '1年',
        '+2 years' => '2年',
        ],

        'quote_type_dom' => [
        'Quotes' => '見積',
        'Orders' => '順番',
        ],
        'default_quote_stage_key' => 'ドラフト',
        'quote_stage_dom' => [
        'Draft' => 'ドラフト',
        'Negotiation' => '交渉',
        'Delivered' => '出荷済み',
        'On Hold' => '保留中',
        'Confirmed' => '確認済み',
        'Closed Accepted' => '受領完了',
        'Closed Lost' => '失注',
        'Closed Dead' => '非商談',
        ],
        'default_order_stage_key' => '保留',
        'order_stage_dom' => [
        'Pending' => '保留',
        'Confirmed' => '確認済み',
        'On Hold' => '保留中',
        'Shipped' => '出荷完了',
        'Cancelled' => 'キャンセル済み',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => '主要な意思決定者',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => '主要な意思決定者',
        'Business Decision Maker' => '事業意思決定者',
        'Business Evaluator' => '事業評価担当者',
        'Technical Decision Maker' => '技術の意思決定者',
        'Technical Evaluator' => '技術評価担当者',
        'Executive Sponsor' => '重役出資者',
        'Influencer' => '影響を与える人',
        'Other' => 'その他',
        ],
        'layouts_dom' => [
        'Standard' => '見積',
        'Invoice' => '請求書',
        ],
        'issue_priority_default_key' => '中',
        'issue_priority_dom' => [
        'Urgent' => '緊急',
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => '受領',
        'Duplicate' => '複製',
        'Closed' => '完了',
        'Out of Date' => '期限切れ',
        'Invalid' => '無効',
        ],

        'issue_status_default_key' => '新規',
        'issue_status_dom' => [
        'New' => '新規',
        'Assigned' => 'アサイン済み',
        'Closed' => '完了',
        'Pending' => '保留',
        'Rejected' => '拒否',
        ],

        'bug_priority_default_key' => '中',
        'bug_priority_dom' => [
        'Urgent' => '緊急',
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => '受領',
        'Duplicate' => '複製',
        'Fixed' => '修理済み',
        'Out of Date' => '期限切れ',
        'Invalid' => '無効',
        'Later' => '後で',
        ],
        'bug_status_default_key' => '新規',
        'bug_status_dom' => [
        'New' => '新規',
        'Assigned' => 'アサイン済み',
        'Closed' => '完了',
        'Pending' => '保留',
        'Rejected' => '拒否',
        ],
        'bug_type_default_key' => 'バグトラッカー',
        'bug_type_dom' => [
        'Defect' => '不具合',
        'Feature' => '仕様',
        ],
        'case_type_dom' => [
        'Administration' => '管理',
        'Product' => '商品',
        'User' => 'アサイン先',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => '社内',
        'Forum' => 'フォーラム',
        'Web' => 'Web',
        'InboundEmail' => 'Eメール',
        'Twitter' => 'Twitter',
        'Portal' => 'ポータル',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => '内部',
        'Forum' => 'フォーラム',
        'Web' => 'Web',
        'InboundEmail' => 'Eメール',
        'Twitter' => 'Twitter',
        'Portal' => 'ポータル',
        'Phone' => '電話',
        'Chat' => 'チャット',
        'Chatbot' => 'チャット BOT',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'データプライバシーポリシーの要求',
        'Send Personal Information being processed' => '処理中の個人情報を送信',
        'Rectify Information' => '情報を修正',
        'Request to Erase Information' => '情報を消去する要求',
        'Export Information' => '情報をエクスポート',
        'Restrict Processing' => '処理を制限',
        'Object to Processing' => '処理に反対',
        'Consent to Process' => '処理に同意',
        'Withdraw Consent' => '同意を取り消す',
        'Other' => 'その他',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'ビジネス通信',
        'Marketing Communications by company' => '会社によるマーケティング通信',
        'Marketing Communications by partners' => 'パートナーによるマーケティング通信',
        ],
        'dataprivacy_status_default_key' => '開く',
        'dataprivacy_status_dom' => [
        'Open' => '開く',
        'Closed' => '完了',
        'Rejected' => '拒否',
        ],
        'dataprivacy_priority_default_key' => '低',
        'dataprivacy_priority_dom' => [
        'Low' => '低',
        'Medium' => '中',
        'High' => '高',
        ],
        'business_day_status_dom' => [
        'Open' => '営業',
        'Open 24 Hours' => '24時間営業',
        'Closed' => '閉店',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => '取引先',
        'Activities' => 'アクティビティ',
        'Bug Tracker' => 'バグトラッカー',
        'Calendar' => 'カレンダー',
        'Calls' => '電話',
        'Campaigns' => 'キャンペーン',
        'Cases' => 'ケース',
        'Contacts' => '取引先担当者',
        'Currencies' => '通貨',
        'Dashboard' => 'ダッシュボード',
        'Documents' => 'ドキュメント',
        'Emails' => 'Eメール',
        'Feeds' => 'RSSフィード',
        'Forecasts' => '売上予測',
        'Help' => 'ヘルプ',
        'Home' => 'ホーム',
        'Leads' => 'リード',
        'Meetings' => '会議',
        'Notes' => 'メモ',
        'Opportunities' => '商談',
        'Outlook Plugin' => 'Outlookプラグイン',
        'Product Catalog' => '商品カタログ',
        'Products' => '見積済商品',
        'RevenueLineItems' => '商談品目',
        'Projects' => 'プロジェクト',
        'Quotes' => '見積',
        'Releases' => 'リリース',
        'RSS' => 'RSSフィード',
        'Studio' => 'スタジオ',
        'Upgrade' => 'アップグレード',
        'Users' => 'ユーザ',
        'OutboundEmail' => 'メール設定',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => '企画立案',
        'Active' => 'アクティブ',
        'Inactive' => '非アクティブ',
        'Complete' => '完了',
        'In Queue' => 'キュー待ち',
        'Sending' => '送信中',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => '電話営業',
        'Mail' => 'ダイレクトメール',
        'Email' => 'Eメール',
        'Print' => '印刷',
        'Web' => 'Web',
        'Radio' => 'ラジオ',
        'Television' => 'テレビ',
        'NewsLetter' => 'ニュースレター',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => '1週間ごと',
        'Monthly' => '毎月',
        'Quarterly' => '毎四半期',
        'Annually' => '毎年',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => '1月',
        '2' => '2月',
        '3' => '3月',
        '4' => '4月',
        '5' => '5月',
        '6' => '6月',
        '7' => '7月',
        '8' => '8月',
        '9' => '9月',
        '10' => '10月',
        '11' => '11月',
        '12' => '12月',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => '1月',
        '2' => '2月',
        '3' => '3月',
        '4' => '4月',
        '5' => '5月',
        '6' => '6月',
        '7' => '7月',
        '8' => '8月',
        '9' => '9月',
        '10' => '10月',
        '11' => '11月',
        '12' => '12月',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => '日曜日',
        '2' => '月曜日',
        '3' => '火曜日',
        '4' => '水曜日',
        '5' => '木曜日',
        '6' => '金曜日',
        '7' => '土曜日',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => '日',
        '2' => '月',
        '3' => '火',
        '4' => '水',
        '5' => '木',
        '6' => '金',
        '7' => '土',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => '日',
        '2' => '月',
        '3' => '火',
        '4' => '水',
        '5' => '木',
        '6' => '金',
        '7' => '土',
        ],
        'dom_cal_day_of_week' => [
        '0' => '日',
        '1' => '月',
        '2' => '火',
        '3' => '水',
        '4' => '木',
        '5' => '金',
        '6' => '土',
        ],
        'dom_meridiem_lowercase' => [
        'am' => '午前',
        'pm' => '午後',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => '表形式レポート',
        'summary' => '集計レポート',
        'detailed_summary' => '詳細集計レポート',
        'Matrix' => 'マトリックスレポート',
        ],


        'dom_email_types' => [
        'out' => '送信済み',
        'archived' => '保存',
        'draft' => 'ドラフト',
        'inbound' => '受信',
        'campaign' => 'キャンペーン',
        ],
        'dom_email_status' => [
        'archived' => '保存',
        'closed' => '完了',
        'draft' => 'ドラフト',
        'read' => '既読',
        'replied' => '返信済み',
        'sent' => '送信済み',
        'send_error' => '送信エラー',
        'unread' => '未読',
        ],
        'dom_email_archived_status' => [
        'archived' => '保存',
        ],

        'dom_email_server_type' => ['' => '--なし--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--なし--',
        'createcase' => 'ケース作成',
        'bounce' => 'バウンス処理',
        ],
        'dom_email_distribution' => ['' => '--なし--',
        'direct' => 'ユーザを直接アサイン',
        'roundRobin' => 'ユーザを均等にアサイン',
        'leastBusy' => '稼働の低いユーザにアサイン',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'ユーザを均等にアサイン',
        'leastBusy' => '稼働の低いユーザにアサイン',
        'none' => 'なし',
        ],
        'dom_email_errors' => [1 => '直接アサインの場合はユーザは1人のみ選択してください。',
        2 => '直接アサインの場合はチェックされたアイテムのみアサインしてください。',
        ],
        'dom_email_bool' => ['bool_true' => 'はい',
        'bool_false' => 'いいえ',
        ],
        'dom_int_bool' => [1 => 'はい',
        0 => 'いいえ',
        ],
        'dom_switch_bool' => ['on' => 'はい',
        'off' => 'いいえ',
        '' => 'いいえ',],

        'dom_email_link_type' => ['sugar' => 'Sugar Eメールクライアント',
        'mailto' => '外部Eメールクライアント'],


        'dom_email_editor_option' => ['' => 'デフォルトEメールフォーマット',
        'html' => 'HTML Eメール',
        'plain' => 'テキストEメール'],

        'schedulers_times_dom' => ['not run' => '実行時刻を経過、未実施',
        'ready' => '準備完了',
        'in progress' => '進行中',
        'failed' => '失敗',
        'completed' => '完了',
        'no curl' => '未実施: cURLライブラリなし',
        ],

        'dom_email_states' => [
        'Draft' => 'ドラフト',
        'Archived' => '保存',
        ],

        'dom_email_direction' => [
        'Unknown' => '不明',
        'Outbound' => 'アウトバウンド',
        'Inbound' => 'インバウンド',
        'Internal' => '内部',
        ],

        'scheduler_status_dom' => [
        'Active' => 'アクティブ',
        'Inactive' => '非アクティブ',
        ],

        'scheduler_period_dom' => [
        'min' => '分',
        'hour' => '時間',
        ],
        'forecast_type_dom' => [
        'Direct' => 'ダイレクト',
        'Rollup' => 'ロールアップ',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'マーケティング',
        'Knowledge Base' => 'ナレッジベース',
        'Sales' => '営業',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'マーケティング資料',
        'Product Brochures' => '製品パンフレット',
        'FAQ' => 'FAQ',
        ],

        'document_status_dom' => [
        'Active' => 'アクティブ',
        'Draft' => 'ドラフト',
        'FAQ' => 'FAQ',
        'Expired' => '期限切れ',
        'Under Review' => 'レビュー中',
        'Pending' => '保留',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'メールマージ',
        'eula' => '使用許諾契約書',
        'nda' => '秘密保持契約',
        'license' => 'ライセンス契約',
        ],
        'dom_meeting_accept_options' => [
        'accept' => '許可',
        'decline' => '不参加',
        'tentative' => '保留',
        ],
        'dom_meeting_accept_status' => [
        'accept' => '受領',
        'decline' => '不参加',
        'tentative' => '保留',
        'none' => 'なし',
        ],
        'dataset_output_default_dom' => [
        'table' => '表',
        ],
        'report_maker_status_dom' => [
        'Single Module' => '単体モジュール',
        'Multi Module' => '複数モジュール',
        ],
        'report_align_dom' => [
        'left' => '左',
        'center' => '中央',
        'right' => '右',
        ],

        'width_type_dom' => [
        '%' => 'パーセント（%）',
        'px' => 'ピクセル（px）',
        ],
        'report_color_dom' => [
        '' => 'デフォルト',
        'black' => 'ブラック',
        'green' => 'グリーン',
        'blue' => 'ブルー',
        'red' => 'レッド',
        'white' => 'ホワイト',
        'DarkGreen' => 'ダークグリーン',
        'LightGray' => 'ライトグレー',
        'DodgerBlue' => 'ドジャーブルー',
        'LightBlue' => 'ライトブルー',
        ],
        'font_size_dom' => [
        '-5' => '小 (-5)',
        '-4' => '小 (-4)',
        '-3' => '小 (-3)',
        '-2' => '小 (-2)',
        '-1' => '小 (-1)',
        'Default' => 'デフォルト',
        '1' => '大 (+1)',
        '2' => '大 (+2)',
        '3' => '大 (+3)',
        '4' => '大 (+4)',
        '5' => '大 (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'メインクエリ',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => '表示',
//  'Group By' => 'Group By',
        'Calculation' => '計算',
        ],
        'query_display_type_dom' => [
        'Default' => 'デフォルト',
        'Custom' => 'カスタム',
        'Hidden' => '非表示',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => '日',
        'Week' => '週',
        'Month' => '月',
        'Quarter' => '四半期',
        'Year' => '年',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => '今',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => '合計',
        'AVG' => '平均',
        'COUNT' => '計算',
        'STDDEV' => '標準偏差',
        'VARIANCE' => '平方偏差',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => '標準フィールド',
        'Time' => '時間間隔',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => '行 (Y軸)',
        'Columns' => '列 (X軸)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => '合計 (総計)',
        'AVG' => '平均',
        'MAX' => '最大値',
        'MIN' => '最小値',
        'COUNT' => '計算',
        'STDDEV' => '標準偏差',
        'VARIANCE' => '平方偏差',
        ],
        'query_calc_type_dom' => [
        'Standard' => '標準',
//  'Sub-Query' => 'Sub Query',
        'Math' => '数値計算',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'フィールド',
        'Value' => '値',
        'Group' => 'グループ',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'カラム',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => '無効',
        'Enabled' => '有効',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => '標準',
        'Scalar' => '数量',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'テキスト',
        'Accounting' => '会計',
        'Date' => '日付',
        'Datetime' => '日時',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => '年',
        'Quarter' => '四半期',
        'Month' => '月',
        'Week' => '週',
        'Day' => '日',
        ],
        'dataset_style_dom' => [
        'normal' => '標準',
        'bold' => 'ボールド',
        'italic' => 'イタリック',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) 足す',
        '-' => '(-) 引く',
        '*' => '(X) 掛ける',
        '/' => '(/) 割る',
        ],
        'wflow_type_dom' => [
        'Normal' => '記録保存時',
        'Time' => '時間経過後',
        ],
        'mselect_type_dom' => [
        'Equals' => '次の値と一致する',
        'in' => '含まれる',
        ],
        'mselect_multi_type_dom' => [
        'in' => '含まれる',
        'not_in' => '次のいずれの値とも一致しない',
        ],
        'cselect_type_dom' => [
        'Equals' => '等しい',
        'Does not Equal' => '等しくない',
        ],
        'dselect_type_dom' => [
        'Equals' => '等しい',
        'Less Than' => 'より少ない',
        'More Than' => 'より大きい',
        'Does not Equal' => '等しくない',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'はい',
        'bool_false' => 'いいえ',
        ],
        'bopselect_type_dom' => [
        'Equals' => '等しい',
        ],
        'tselect_type_dom' => [
        '0' => '0時間',
        '14440' => '4時間',
        '28800' => '8時間',
        '43200' => '12時間',
        '86400' => '1日',
        '172800' => '2日',
        '259200' => '3日',
        '345600' => '4日',
        '432000' => '5日',
        '604800' => '1週間',
        '1209600' => '2週間',
        '1814400' => '3週間',
        '2592000' => '30日',
        '5184000' => '60日',
        '7776000' => '90日',
        '10368000' => '120日',
        '12960000' => '150日',
        '15552000' => '180日',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'より大きかった',
        'Less Than' => 'は次より小さい',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'Eメール',
        'Invite' => '招待',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => '通常メッセージ',
        'Custom Template' => 'カスタムテンプレート',
        'System Default' => 'システムデフォルト',
        ],
        'wflow_user_type_dom' => [
        'current_user' => '既存ユーザ',
        'rel_user' => '関連ユーザ',
        'rel_user_custom' => '関連カスタムユーザ',
        'specific_team' => '特定チーム',
        'specific_role' => '特定役割',
        'specific_user' => '特定ユーザ',
        ],
        'wflow_array_type_dom' => [
        'future' => '新しい値',
        'past' => '以前の値',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'アサイン先',
        'Manager' => "ユーザの上司",
        ],
        'wflow_address_type_dom' => [
        'to' => 'To:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'To:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        'invite_only' => '(招待された人のみ)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'To:',
        ],
        'wflow_action_type_dom' => [
        'update' => '記録を更新',
        'update_rel' => '関連記録を更新',
        'new' => '新規記録',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'トリガー日',
        'Existing Value' => '既存値',
        ],
        'wflow_set_type_dom' => [
        'Basic' => '基本オプション',
        'Advanced' => '拡張オプション',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'トリガーレコードにアサインされたユーザ',
        'modified_user_id' => 'トリガーレコードを最後に編集したユーザ',
        'created_by' => 'トリガーレコードを作成したユーザ',
        'current_user' => 'ログインユーザ',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'トリガーレコードの現在のチーム',
        'team_set_id' => 'トリガーレコードをセットしたチーム',
        'current_team' => 'ログインユーザのチーム',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => '後に移動',
        'advance' => '前に移動',
        ],
        'wflow_record_type_dom' => [
        'All' => '新規/既存レコード',
        'New' => '新規レコードのみ',
        'Update' => '既存レコードのみ',
        ],
        'wflow_rel_type_dom' => [
        'all' => '関連すべて',
        //'first' => 'The first related',
        'filter' => 'フィルタに関連',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'すべてに関連',
        'any' => 'いずれかに関連',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => '通知後実行',
        'actions_alerts' => '実行後通知'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'なし',
        'Daily' => '1日ごと',
        'Weekly' => '1週間ごと',
        'Monthly' => '毎月',
        'Yearly' => '年次',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => '日',
        'Weekly' => '週',
        'Monthly' => '月',
        'Yearly' => '年',
        ],

        'repeat_end_types' => [
        'Until' => '終了日',
        'Occurrences' => '繰り返す間隔',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => '未設定',
        'Each' => '毎',
        'On' => '曜日',
        ],

        'repeat_ordinal_dom' => [
        'first' => '1回目',
        'second' => '2回目',
        'third' => '3回目',
        'fourth' => '4回目',
        'fifth' => '5回目',
        'last' => '最後',
        ],

        'repeat_unit_dom' => [
        'Sun' => '日曜日',
        'Mon' => '月曜日',
        'Tue' => '火曜日',
        'Wed' => '水曜日',
        'Thu' => '木曜日',
        'Fri' => '金曜日',
        'Sat' => '土曜日',
        'Day' => '日',
        'WD' => '平日',
        'WE' => '週末',
        ],

        'duration_dom' => [
        '' => 'なし',
        '900' => '15分',
        '1800' => '30分',
        '2700' => '45分',
        '3600' => '1時間',
        '5400' => '1.5時間',
        '7200' => '2時間',
        '10800' => '3時間',
        '21600' => '6時間',
        '86400' => '1日',
        '172800' => '2日',
        '259200' => '3日',
        '604800' => '1週間',
        ],
        'repeat_month_dom' => [
        '1' => '1月',
        '2' => '2月',
        '3' => '3月',
        '4' => '4月',
        '5' => '5月',
        '6' => '6月',
        '7' => '7月',
        '8' => '8月',
        '9' => '9月',
        '10' => '10月',
        '11' => '11月',
        '12' => '12月',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'デフォルト',
        'seed' => 'シード',
        'exempt_domain' => '禁止リスト - 禁止ドメイン',
        'exempt_address' => '禁止リスト - 禁止Eメールアドレス',
        'exempt' => '禁止リスト - 禁止ID',
        'test' => 'テスト',
        ],
        'currency_status_dom' => [
        'Active' => 'アクティブ',
        'Inactive' => '非アクティブ',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'アクティブ',
        'inactive' => '非アクティブ',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => '送信実行済み',
        'send error' => '送信エラー: 他',
        'invalid email' => '送信エラー: 無効アドレス',
        'link' => 'リンクからクリック',
        'viewed' => '閲覧済み',
        'removed' => 'メール送信除外',
        'lead' => 'リード作成済み',
        'contact' => '取引先担当者作成済み',
        'blocked' => 'Eメールアドレスまたはドメインで禁止',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => '取引先担当者',
        'Users' => 'ユーザ',
        'Prospects' => 'ターゲット',
        'Leads' => 'リード',
        'Accounts' => '取引先',
        ],
        'merge_operators_dom' => [
        'like' => '次の値を含む',
        'exact' => '正確に一致',
        'start' => '以下で始まる',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'はい',
        'false' => 'いいえ',
        'required' => '必須',
        ],

        'fts_field_config' => [
        '0' => '無効',
        '2' => '検索可能',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => '無効',
        1 => '有効',
        2 => 'フィルタ内',
        3 => 'デフォルトの選択済みフィルタ',
        4 => 'フィルタのみ',
        ],

        'navigation_paradigms' => [
        'm' => 'モジュール',
        'gm' => 'グループモジュール',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => '開始していません',
        'inprogress' => '進行中',
        'signed' => 'サイン済み',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => '毎月',
        'quarterly' => '毎四半期',
        'halfyearly' => '毎半期',
        'yearly' => '年次',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1日',
        '3' => '3日',
        '5' => '5日',
        '7' => '1週間',
        '14' => '2週間',
        '21' => '3週間',
        '31' => '1カ月',
        ],
        'projects_priority_options' => [
        'high' => '高',
        'medium' => '中',
        'low' => '低',
        ],

        'projects_status_options' => [
        'notstarted' => '開始していません',
        'inprogress' => '進行中',
        'completed' => '完了',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => '凡例を表示',
        'collapselegend' => '凡例を閉じる',
        'clickfordrilldown' => 'クリックしてドリルダウン',
        'drilldownoptions' => 'ドリルダウンオプション',
        'detailview' => '詳細...',
        'piechart' => '円グラフ',
        'groupchart' => 'グループグラフ',
        'stackedchart' => '積み重ねグラフ',
        'barchart' => '縦棒グラフ',
        'horizontalbarchart' => '横棒グラフ',
        'linechart' => '線グラフ',
        'noData' => 'データがありません',
        'print' => '印刷',
        'pieWedgeName' => 'セクション',
        ],
        'chart_types' => [
        'hBarF' => '横方向バー（積み上げ）',
        'hGBarF' => '横方向バー（グループ）',
        'vBarF' => '縦方向バー（積み上げ）',
        'vGBarF' => '縦方向バー（グループ）',
        'pieF' => '円',
        'funnelF' => 'ファンネル',
        'lineF' => 'ライン',
        'donutF' => 'ドーナツ',
        'treemapF' => 'ツリーマップ',
        ],
        'd3_value_placement' => [
        '0' => 'なし',
        '1' => 'デフォルト',
        'start' => '開始',
        'middle' => 'ミドル',
        'end' => 'リピート終了',
        'top' => 'トップ',
        'total' => '合計',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'ファンネル',
        'hbar' => '横方向バー',
        ],
        'release_status_dom' => [
        'Active' => 'アクティブ',
        'Inactive' => '非アクティブ',
        ],
        'email_settings_for_ssl' => [
        '0' => 'なし',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Google 安全性の低いアプリ',
        'exchange' => 'Exchange',
        'other' => 'その他',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'その他',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'シングルクォート(&amp;amp;#39;)',
        '"' => 'ダブルクォート(")',
        '' => 'なし',
        'other' => 'その他:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'その他:',
        ],
        'link_target_dom' => [
        '_blank' => '新規ウインドウ',
        '_self' => '同じウインドウ',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => '自動更新なし',
        '30' => '30秒ごと',
        '60' => '1分ごと',
        '180' => '3分ごと',
        '300' => '5分ごと',
        '600' => '10分ごと',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'なし',
        '15' => '15分毎',
        '30' => '30分毎',
        '45' => '45分毎',
        '60' => '1時間毎',
        '120' => '2時間毎',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'なし',
        '30' => '30秒ごと',
        '60' => '1分ごと',
        '180' => '3分ごと',
        '300' => '5分ごと',
        '600' => '10分ごと',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'なし',
        '1' => '1分ごと',
        '5' => '5分ごと',
        '10' => '10分ごと',
        '15' => '15分毎',
        '30' => '30分毎',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => '等しい',
        'not_equal' => '次の値と一致しない',
        'greater_than' => '以降',
        'less_than' => '以前',
        'last_7_days' => '過去7日間',
        'next_7_days' => '翌7日間',
        'last_30_days' => '過去30日間',
        'next_30_days' => '翌30日間',
        'last_month' => '昨月',
        'this_month' => '今月',
        'next_month' => '翌月',
        'last_year' => '昨年',
        'this_year' => '今年',
        'next_year' => '翌年',
        'between' => '次の範囲内',
        ],
        'date_range_operator_dom' => [
        'last_year' => '昨年',
        'last_month' => '昨月',
        'last_30_days' => '過去30日間',
        'last_7_days' => '過去7日間',
        'this_month' => '今月',
        'this_year' => '今年',
        'next_7_days' => '翌7日間',
        'next_30_days' => '翌30日間',
        'next_month' => '翌月',
        'next_year' => '翌年',
        ],
        'numeric_range_search_dom' => [
        '=' => '等しい',
        'not_equal' => '等しくない',
        'greater_than' => 'より大きい',
        'greater_than_equals' => '以上',
        'less_than' => 'より少ない',
        'less_than_equals' => '以下',
        'between' => '次の範囲内',
        ],

        'filter_checkbox_dom' => [
        0 => '不正解',
        1 => '正解',
        ],

        'opportunity_metrics_dom' => [
        'won' => '受注',
        'lost' => '失注',
        'active' => 'アクティブ',
        ],

        'sweetspot_theme_options' => [
        'default' => 'デフォルト',
        'light' => '明るい',
        'dark' => '暗い',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => '移動',
        'donothing' => '何もしない',
        ],
        'processes_auto_save_interval' => [
        0 => 'なし',
        30000 => '30秒ごと',
        60000 => '1分ごと',
        120000 => '2分ごと',
        180000 => '3分ごと',
        240000 => '4分ごと',
        300000 => '5分ごと',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'はい',
        'No' => 'いいえ',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => '売上予測中',
        'sales_stage' => '商談ステージ',
        'probability' => '確度',
        ],
        'forecasts_options_dataset' => [
        'likely' => '達成可能',
        'best' => 'ベスト',
        'worst' => 'ワースト',
        ],
        'webLogicHookList' => [
        'after_save' => '保存後',
        'after_delete' => '削除後',
        'after_relationship_add' => '関連追加後',
        'after_relationship_delete' => '関連削除後',
        'after_login' => 'ログイン後',
        'after_logout' => 'ログアウト後',
        'after_login_failed' => 'ログイン失敗後',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => '有効',
        'INACTIVE' => '無効',
        ],
        'dashboard_view_name_list' => [
        'record' => 'レコード',
        'records' => 'リスト',
        'activities' => 'アクティビティ ストリーム',
        'multi-line' => 'マルチラインリスト',
        'omnichannel' => 'オムニチャネル',
        'home' => 'Home',
        'focus' => 'フォーカス ドロワ',
        ],
        'metric_context_list' => [
        'service_console' => 'サービスコンソール',
        'renewals_console' => 'コンソールの更新',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => '時間ごと',
        '21600' => '6 時間ごと',
        '43200' => '12 時間ごと',
        '86400' => '日ごと',
        '604800' => '週ごと',
        '1209600' => '2 週間ごと',
        '2419200' => '4 週間ごと',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => '年',
        'month' => '月',
        'day' => '日',
        ],
        'shift_exception_type_dom' => [
        'time_off' => '休暇',
        'event' => 'イベント',
        'other' => 'その他',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => '日付 (最後の {{module}})',
        'start_date:asc' => '日付 (最初 {{module}})',
        'total_revenue:desc' => '価格 (最高合計)',
        'total_revenue:asc' => '価格 (最低合計)',
        ],
        'calendar_type_list' => [
        'main' => 'カレンダーセンター',
        ],
        'calendar_views_options' => [
        'day' => '日',
        'week' => '週',
        'workWeek' => '勤務週',
        'expandedMonth' => '月',
        'agenda' => 'アジェンダ',
        'timeline' => 'タイムライン',
        'monthSchedule' => 'スケジューラー',
        ],
        'docusign_envelope_status_list' => [
        'created' => '作成済み',
        'completed' => '完了',
        'declined' => '拒否',
        'delivered' => '提出済み',
        'sent' => '送信済み',
        'signed' => 'サイン済み',
        'voided' => '無効',
        ],
        'docusign_recipient_selection_list' => [
        'show' => '潜在的な受信者のリストを表示する',
        'dont_show' => '潜在的な受信者を表示しない',
        ],
        'docusign_recipient_type_list' => [
        'signer' => '署名者',
        'carbon_copy' => 'ビューア（カーボンコピー）',
        'certified_delivery' => 'ビューア（配信証明）',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'デフォルト',
        'color' => '色',
        'image' => '画像',
        ],
        'module_display_type_dom' => [
        'abbreviation' => '略称',
        'icon' => 'アイコン',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => '下矢印',
        'sicon-chevron-left' => 'シェブロン左',
        'sicon-check' => 'チェック',
        'sicon-clock' => '時計',
        'sicon-dashboard-default' => 'ダッシュボードのデフォルト',
        'sicon-dashboard' => 'ダッシュボード',
        'sicon-edit' => '編集',
        'sicon-caret-down' => 'キャレット下',
        'sicon-folder' => 'フォルダ',
        'sicon-info' => '情報',
        'sicon-kebab' => 'ケバブ',
        'sicon-link' => 'リンク',
        'sicon-list' => 'リスト',
        'sicon-logout' => 'ログアウト',
        'sicon-minus' => 'マイナス',
        'sicon-folder-open' => 'フォルダーオープン',
        'sicon-plus-sm' => 'プラス Sm',
        'sicon-refresh' => '更新',
        'sicon-plus' => 'プラス',
        'sicon-settings' => '設定',
        'sicon-arrow-right-double' => '二重右矢印',
        'sicon-reports' => 'レポート',
        'sicon-user' => 'ユーザー',
        'sicon-upload' => 'アップロード',
        'sicon-user-group' => 'ユーザーグループ',
        'sicon-arrow-left-double' => '二重左矢印',
        'sicon-chevron-up' => 'シェブロン上',
        'sicon-caret-up' => 'キャレット上',
        'sicon-star-fill' => 'スターフィル',
        'sicon-download' => 'ダウンロード',
        'sicon-close' => '閉じる',
        'sicon-tile-view' => 'タイルビュー',
        'sicon-list-view' => 'リストビュー',
        'sicon-thumbs-down' => '却下',
        'sicon-warning-circle' => '警告サークル',
        'sicon-phone' => '電話',
        'sicon-email' => 'メールアドレス',
        'sicon-document' => 'ドキュメント',
        'sicon-note' => 'メモ',
        'sicon-preview' => 'プレビュー',
        'sicon-copy' => 'コピー',
        'sicon-launch' => '開始',
        'sicon-lock' => 'ロック',
        'sicon-arrow-top-right' => '右上矢印',
        'sicon-full-screen' => '全画面表示',
        'sicon-full-screen-exit' => '全画面表示終了',
        'sicon-expand-left' => '左に展開',
        'sicon-expand-right' => '右に展開',
        'sicon-focus-drawer' => 'フォーカスドロワー',
        'sicon-ban' => '禁止',
        'sicon-thumbs-up' => '承認',
        'sicon-search' => '検索',
        'sicon-calendar' => 'カレンダー',
        'sicon-calendar-lg' => 'カレンダー Lg',
        'sicon-mobile-lg' => 'モバイル Lg',
        'sicon-star-fill-lg' => 'スターフィル Lg',
        'sicon-star-outline-lg' => 'スターアウトライン Lg',
        'sicon-reset-lg' => 'リセット Lg',
        'sicon-exchange-lg' => '交換 Lg',
        'sicon-help-lg' => 'ヘルプ Lg',
        'sicon-close-lg' => '閉じる Lg',
        'sicon-plus-lg' => 'プラス Lg',
        'sicon-shortcuts-lg' => 'ショートカット Lg',
        'sicon-search-lg' => '検索 Lg',
        'sicon-email-lg' => 'メール Lg',
        'sicon-note-lg' => 'メモ Lg',
        'sicon-document-lg' => 'ドキュメント Lg',
        'sicon-add-dashlet-lg' => 'ダッシュレットを追加 Lg',
        'sicon-collapse-lg' => '折りたたむ Lg',
        'sicon-hamburger-lg' => 'ハンバーガー Lg',
        'sicon-pin-fill-lg' => 'ピン留め Lg',
        'sicon-expand-lg' => '展開 Lg',
        'sicon-copy-lg' => 'コピー Lg',
        'sicon-dashboard-lg' => 'ダッシュボード Lg',
        'sicon-star-outline' => 'スターアウトライン',
        'sicon-reset' => 'リセット',
        'sicon-unlink' => 'リンク解除',
        'sicon-phone-lg' => '電話 Lg',
        'sicon-attach' => '添付',
        'sicon-case-lg' => 'ケース Lg',
        'sicon-arrow-right-lg' => '右矢印 Lg',
        'sicon-check-circle-lg' => 'チェックサークル Lg',
        'sicon-text-formatting' => 'テキストの書式設定',
        'sicon-check-circle' => 'チェックサークル',
        'sicon-upload-lg' => 'アップロード Lg',
        'sicon-flag-lg' => 'フラグ Lg',
        'sicon-studio-lg' => 'スタジオ Lg',
        'sicon-contact-lg' => '取引先担当者 Lg',
        'sicon-edit-lg' => '編集 Lg',
        'sicon-arrow-left' => '左矢印',
        'sicon-reply-all' => 'すべて返信',
        'sicon-message-lg' => 'メッセージ Lg',
        'sicon-info-lg' => '情報 Lg',
        'sicon-error-lg' => 'エラー Lg',
        'sicon-check-circle-line-lg' => 'チェックサークルライン Lg',
        'sicon-warning-line-lg' => '警告ライン Lg',
        'sicon-arrow-up' => '上矢印',
        'sicon-arrow-right' => '右矢印',
        'sicon-nodes' => 'ノード',
        'sicon-hide' => '非表示',
        'sicon-help' => 'ヘルプ',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'メッセージ',
        'sicon-sugar-predict-lg' => 'Sugar Predict Lg',
        'sicon-sugar-predict' => 'Sugar Predict',
        'sicon-opportunity-lg' => '商談 Lg',
        'sicon-lead-lg' => 'リード Lg',
        'sicon-account-lg' => 'アカウント Lg',
        'sicon-user-sm' => 'ユーザー Sm',
        'sicon-quote-lg' => '見積 Lg',
        'sicon-equal' => '等しい',
        'sicon-slicers-xl' => 'スライサー Xl',
        'sicon-escalation-lg' => 'エスカレーション Lg',
        'sicon-add-circle-lg' => 'サークルを追加 Lg',
        'sicon-add-line-lg' => 'ラインを追加 Lg',
        'sicon-add-target-lg' => 'ターゲットを追加 Lg',
        'sicon-help-circle-lg' => 'ヘルプサークル Lg',
        'sicon-divide-line-lg' => '分割ラインLg',
        'sicon-string' => 'ストリング',
        'sicon-filter' => 'フィルター',
        'sicon-number' => '番号',
        'sicon-format-lg' => 'フォーマット Lg',
        'sicon-insights-lg' => 'インサイト Lg',
        'sicon-invalid-circle-lg' => '無効なサークル Lg',
        'sicon-layout-xl' => 'レイアウト Xl',
        'sicon-layout-lg' => 'レイアウト Lg',
        'sicon-multiply-line-lg' => '乗算ライン Lg',
        'sicon-redo-lg' => 'やり直す Lg',
        'sicon-refresh-lg' => '更新 Lg',
        'sicon-undo-lg' => '元に戻す Lg',
        'sicon-activity-feed-xl' => 'アクティビティフィード Xl',
        'sicon-chevron-left-xl' => 'シェブロン左 Xl',
        'sicon-close-xl' => '閉じる Xl',
        'sicon-kebab-lg' => 'ケバブ Lg',
        'sicon-insights-xl' => 'インサイト Xl',
        'sicon-hide-lg' => '非表示 Lg',
        'sicon-kebab-xl' => 'ケバブ Xl',
        'sicon-comment-xl' => 'コメント Xl',
        'sicon-share-lg' => '共有 Lg',
        'sicon-trash' => 'ゴミ箱',
        'sicon-launch-lg' => '開始 Lg',
        'sicon-thumbs-up-lg' => '承認 Lg',
        'sicon-thumbs-down-lg' => '却下 Lg',
        'sicon-warning-lg' => '警告 Lg',
        'sicon-wizard-circle-xl' => 'ウィザードサークル Xl',
        'sicon-bell-cross-lg' => 'ベルクロス Lg',
        'sicon-bell-lg' => 'ベル Lg',
        'sicon-daily-lg' => 'デイリー Lg',
        'sicon-cloud-download-lg' => 'クラウドダウンロード Lg',
        'sicon-unlock' => 'ロック解除',
        'sicon-news-lg' => 'ニュース Lg',
        'sicon-weekly-lg' => 'ウィークリー Lg',
        'sicon-knowledgebase-xl' => 'ナレッジベース Xl',
        'sicon-remove' => '削除',
        'sicon-chevron-down' => 'シェブロン下',
        'sicon-slicers-lg' => 'スライサー Lg',
        'sicon-save-lg' => '保存 Lg',
        'sicon-info-circle-lg' => '情報サークル Lg',
        'sicon-chevron-right' => 'シェブロン右',
        'sicon-warning-circle-lg' => '警告サークル Lg',
        'sicon-right-paren-line-lg' => '右丸括弧ライン Lg',
        'sicon-comment-lg' => 'コメント Lg',
        'sicon-target-lg' => 'ターゲット Lg',
        'sicon-subtract-line-lg' => '引算ライン Lg',
        'sicon-settings-lg' => '設定 Lg',
        'sicon-left-paren-line-lg' => '左丸括弧ライン Lg',
        'sicon-preview-lg' => 'レビュー Lg',
        'sicon-thumbs-down-line-lg' => '却下ライン Lg',
        'sicon-thumbs-up-line-lg' => '承認ライン Lg',
        'sicon-send-lg' => '送信 Lg',
        'sicon-contact-xl' => '取引先担当者 Xl',
        'sicon-wizard-circle-line-xl' => 'ウィザードサークルライン Xl',
        'sicon-trash-lg' => 'ゴミ箱 Lg',
        'sicon-pin-lg' => 'ピン留め Lg',
        'sicon-clock-lg' => '時計 Lg',
        'sicon-comment-line-xl' => 'コメントライン Xl',
        'sicon-dropdown-editor' => 'ドロップダウンエディタ',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'バグ',
        'sicon-catalog' => 'カタログ',
        'sicon-cloud' => 'クラウド',
        'sicon-config-api' => '構成 API',
        'sicon-config-nav' => '構成 Nav',
        'sicon-connectors' => 'コネクタ',
        'sicon-contracts' => '契約',
        'sicon-currencies' => '通貨',
        'sicon-diagnostics' => '分析',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'メールキャンペーン',
        'sicon-email-inbound' => '受信メール',
        'sicon-email-queue' => 'メールキュー',
        'sicon-forecasts' => '売上予測',
        'sicon-display-modules' => 'モジュールを表示',
        'sicon-email-contacts' => '取引先担当者にメール',
        'sicon-import' => 'インポート',
        'sicon-log-viewer' => 'ログビューア',
        'sicon-lab' => 'ラボ',
        'sicon-map-pin' => 'マップピン',
        'sicon-manufacturers' => '製造元',
        'sicon-update' => '更新',
        'sicon-content-security' => 'コンテンツセキュリティ',
        'sicon-module-builder' => 'モジュールビルダー',
        'sicon-languages' => '言語',
        'sicon-module-loader' => 'モジュールローダー',
        'sicon-oauth-key' => 'OAuthキー',
        'sicon-password-mgmt' => 'パスワード管理',
        'sicon-opportunities' => '商談',
        'sicon-upgrade' => 'アップグレード',
        'sicon-portal' => 'ポータル',
        'sicon-product-types' => '商品タイプ',
        'sicon-quotes' => '見積',
        'sicon-relate-fields' => 'フィールドを関連付ける',
        'sicon-repair' => '修復',
        'sicon-role-mgmt' => 'ロール管理',
        'sicon-scheduler' => 'スケジューラ―',
        'sicon-shippers' => '運送会社',
        'sicon-studio' => 'スタジオ',
        'sicon-web-logic' => 'ウェブロジック',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => '税率',
        'sicon-team-mgmt' => 'チーム管理',
        'sicon-team-perm' => 'チーム 永続',
        'sicon-tracker' => 'トラッカー',
        'sicon-workflow' => 'ワークフロー',
        'sicon-mask' => 'マスク',
        'sicon-mask-disabled' => 'マスク無効',
        'sicon-email-archive' => 'メールのアーカイブ',
        'sicon-mobile' => '携帯',
        'sicon-archive' => 'アーカイブ',
        'sicon-automate-scroll' => '垂直スクロールを表示',
        'sicon-automate-stacked' => '水平スクロールを表示',
        'sicon-pdf-manager' => 'PDFマネージャー',
        'sicon-my-sites' => 'マイサイト',
        'sicon-cloud-insights' => 'クラウドインサイト',
        'sicon-sugar-logo-24' => 'Sugar ロゴ 24',
        'sicon-sugar-logo-16' => 'Sugar ロゴ 16',
        'sicon-task-lg' => 'タスク Lg',
        'sicon-web-lg' => 'ウェブ Lg',
        'sicon-events-lg' => 'イベント Lg',
        'sicon-sugar-logo-12' => 'Sugar ロゴ 12',
        'sicon-tag' => 'タグ',
        'sicon-tag-lg' => 'タグ Lg',
        'sicon-bell-lg-line' => 'ベル Lg ライン',
        'sicon-matrix-xxl' => 'マトリックス Xxl',
        'sicon-advanced-filter' => '高度なフィルター',
        'sicon-rows-and-columns-xxl' => '表形式レポート Xxl',
        'sicon-summation-details-xxl' => '合計の詳細 Xxl',
        'sicon-summation-xxl' => '合計 Xxl',
        'sicon-lock-lg' => 'ロック Lg',
        'sicon-csv-file-xxl' => 'CSVファイル Xxl',
        'sicon-logo-linkedin' => 'ロゴ Linkedin',
        'sicon-briefcase' => 'ブリーフケース',
        'sicon-car-front' => '車のフロント',
        'sicon-airplane' => '飛行機',
        'sicon-laptop' => 'ラップトップ',
        'sicon-logo-instagram' => 'ロゴ Instagram',
        'sicon-single-bed' => 'シングルベッド',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'ロゴ Snapchat',
        'sicon-video-lg' => '動画 Lg',
        'sicon-reply' => '返信',
        'sicon-subtract' => '引く',
        'sicon-arrow-up-circle-line' => '上矢印サークルライン',
        'sicon-asterisk' => 'アスタリスク',
        'sicon-dot-circle-o-lg' => 'ドットサークルO Lg',
        'sicon-forward' => '転送',
        'sicon-video' => '動画',
        'sicon-gavel' => 'ガベル',
        'sicon-login' => 'ログイン',
        'sicon-pdf-file-xxl' => 'PDFファイル Xxl',
        'sicon-login-lg' => 'ログイン Lg',
        'sicon-cloud-download-xl' => 'クラウドダウンロード Xl',
        'sicon-campaigns-lg' => 'キャンペーン Lg',
        'sicon-customer-journey-stages-lg' => 'カスタマージャーニーステージ Lg',
        'sicon-role-mgmt-lg' => 'ロール管理 Lg',
        'sicon-default-module-lg' => 'デフォルトモジュール Lg',
        'sicon-quoted-line-items-lg' => '見積済商品',
        'sicon-projects-lg' => 'プロジェクト Lg',
        'sicon-process-business-rules-lg' => 'プロセスビジネスルール Lg',
        'sicon-process-email-templates-lg' => 'プロセスメールテンプレート Lg',
        'sicon-processes-lg' => 'プロセス Lg',
        'sicon-process-definitions-lg' => 'プロセス定義 Lg',
        'sicon-target-lists-lg' => 'ターゲットリスト Lg',
        'sicon-purchased-line-items-lg' => '購入商品 Lg',
        'sicon-user-group-lg' => 'ユーザーグループ Lg',
        'sicon-revenue-line-items-lg' => '商談品目 Lg',
        'sicon-business-centers-lg' => 'ビジネスセンター Lg',
        'sicon-logo-fb-simple' => 'ロゴ FBシンプル',
        'sicon-forecasts-lg' => '売上予測 Lg',
        'sicon-contracts-lg' => '契約 Lg',
        'sicon-purchase-lg' => '購入 Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'カスタマージャーニー Lg',
        'sicon-data-privacy-lg' => 'データプライバシー Lg',
        'sicon-home-lg' => 'ホーム Lg',
        'sicon-data-table' => 'データテーブル',
        'sicon-medical-clipboard-lg' => '医療クリップボード Lg',
        'sicon-privacy-lg' => 'プライバシー Lg',
        'sicon-marketplace' => 'マーケットプレイス',
        'sicon-marketplace-lg' => 'マーケットプレイス Lg',
        'sicon-blockquote-lg' => 'ブロック見積 Lg',
        'sicon-casino-lg' => 'カジノ Lg',
        'sicon-jacuzzi-lg' => 'ジャグジー Lg',
        'sicon-scissors-lg' => 'はさみ Lg',
        'sicon-storage-lg' => 'ストレージ Lg',
        'sicon-fan-lg' => 'ファン Lg',
        'sicon-medicine-lg' => '薬 Lg',
        'sicon-plant-lg' => '工場 Lg',
        'sicon-telescope-lg' => '望遠鏡 Lg',
        'sicon-smart-phone-lg' => 'スマートフォン Lg',
        'sicon-coffee-lg' => 'コーヒー Lg',
        'sicon-martini-lg' => 'マルティーニ Lg',
        'sicon-cocktail-lg' => 'カクテル Lg',
        'sicon-stadium-lg' => 'スタジアム Lg',
        'sicon-fire-lg' => '火 Lg',
        'sicon-window-lg' => 'ウィンドウ Lg',
        'sicon-lotus-lg' => 'ロータス Lg',
        'sicon-windmill-lg' => '風車 Lg',
        'sicon-spades-lg' => 'スペード Lg',
        'sicon-hearts-lg' => 'ハート Lg',
        'sicon-diamonds-lg' => 'ダイヤモンド Lg',
        'sicon-clubs-lg' => 'クラブ Lg',
        'sicon-skull-lg' => 'スカル Lg',
        'sicon-send' => '送信',
        'sicon-world-lg' => 'ワールド Lg',
        'sicon-airplane-lg' => '飛行機 Lg',
        'sicon-planet-lg' => 'プラネット Lg',
        'sicon-trainer-lg' => 'トレーナー Lg',
        'sicon-calculator-lg' => '電卓 Lg',
        'sicon-tv-lg' => 'テレビ Lg',
        'sicon-video-player-lg' => 'ビデオプレーヤー Lg',
        'sicon-media-player-lg' => 'メディアプレーヤー Lg',
        'sicon-decentralize-lg' => '分散化 Lg',
        'sicon-statistics-lg' => '統計 Lg',
        'sicon-virus-lg' => 'ウイルス Lg',
        'sicon-shield-lg' => 'シールド Lg',
        'sicon-plug-lg' => 'プラグ Lg',
        'sicon-shuttle-lg' => 'シャトル Lg',
        'sicon-soundwave-lg' => 'サウンドウェーブ Lg',
        'sicon-graph-lg' => 'グラフ Lg',
        'sicon-playlist-lg' => 'プレイリスト Lg',
        'sicon-voice-recognition-lg' => '音声認識 Lg',
        'sicon-machine-learning-lg' => '機械学習 Lg',
        'sicon-bed-lg' => 'ベッド Lg',
        'sicon-blueprint-lg' => 'ブループリント Lg',
        'sicon-content-delivery-lg' => 'コンテンツ配信 Lg',
        'sicon-questionnaire-lg' => 'アンケート Lg',
        'sicon-presentation-lg' => 'プレゼンテーション Lg',
        'sicon-organic-lg' => '有機 Lg',
        'sicon-transactions-lg' => 'トランザクション Lg',
        'sicon-wand-lg' => 'ワンド Lg',
        'sicon-bin-lg' => 'ビン Lg',
        'sicon-sync-lg' => '同期 Lg',
        'sicon-external-authentication-lg' => '外部認証 Lg',
        'sicon-tracking-activity-lg' => '追跡アクティビティ Lg',
        'sicon-account' => 'アカウント',
        'sicon-meetings-lg' => '会議 Lg',
        'sicon-stacked' => '水平分割を表示',
        'sicon-sidebyside' => '垂直分割を表示',
        ],

        'module_colors_dom' => [
        'army' => 'アーミー',
        'coral' => 'コーラル',
        'green' => 'グリーン',
        'orange' => 'オレンジ',
        'ocean' => 'オーシャン',
        'pacific' => 'パシフィック',
        'pink' => 'ピンク',
        'purple' => 'パープル',
        'red' => 'レッド',
        'teal' => 'ティール',
        'yellow' => 'イエロー',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => '新規',
        'In Progress' => '進行中',
        'Closed' => '完了',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => '非アクティブ',
        'Lack of Progress' => '進捗状況の不足',
        'Customer-Imposed Deadline' => '顧客負担の締め切り',
        'Account at Risk' => 'リスクのあるアカウント',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'お客様がリクエストしました',
        'Internally Requested' => '内部でリクエスト済み',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'ケース',
        'Bugs' => 'バグ',
        'Accounts' => 'アカウント',
        'Opportunities' => '商談',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => '肯定的',
        'Negative' => '否定的',
        'Neutral' => '中立',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => '可能性はない',
        '02_less_likely' => '可能性は低い',
        '03_neutral' => 'どちらでもない',
        '04_more_likely' => '可能性は高い',
        '05_very_likely' => '可能性は非常に高い',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => '顧客と一致しません',
        '02_no_match' => '',
        '01_matches_customers' => '顧客と一致します',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'リード',
        'Accounts' => 'アカウント',
        'Contacts' => '取引先担当者',
        'Cases' => 'ケース',
        'Opportunities' => '商談',
        ],
        'dri_workflows_state_list' => [
        'not_started' => '開始していません',
        'in_progress' => '進行中',
        'completed' => '完了',
        'cancelled' => 'キャンセル済み',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => '未設定',
        'create' => '作成で',
        'stage_start' => 'ステージ開始で',
        'previous_activity_completed' => '前のアクティビティが完了しました',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => '現在のユーザー',
        'parent_assignee' => '親担当者',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => '作成からの日数',
        'days_from_stage_started' => 'ステージ開始からの日数',
        'days_from_previous_activity_completed' => '前のアクティビティの完了からの日数',
        'days_from_parent_date_field' => '親日付フィールドからの日数',
        'days_from_specific_activity_completed' => '特定のアクティビティの完了からの日数',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => '作成時',
        'stage_started' => 'ステージ開始時',
        'previous_activity_completed' => '前のアクティビティが完了したとき',
        'parent_date_field' => '親の日付フィールドで',
        'specific_activity_completed' => '特定のアクティビティが完了しました',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => '絶対',
        'Percentage' => '割合',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => '顧客タスク',
        'milestone' => 'マイルストーン',
        'internal_task' => '内部タスク',
        'agency_task' => 'エージェンシータスク',
        'automatic_task' => '自動タスク',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'タスク',
        'Calls' => '通話',
        'Meetings' => '会議',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => '未設定',
        'create' => '作成で',
        'stage_start' => 'ステージ開始で',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => '継承',
        'current_user' => '現在のユーザー',
        'parent_assignee' => '親担当者',
        'user' => 'ユーザー',
        'team' => 'チーム',
        'user_team' => 'ユーザーおよびチーム',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => '継承',
        'none' => '未設定',
        'create' => '作成で',
        'stage_start' => 'ステージ開始で',
        'previous_activity_completed' => '前のアクティビティが完了しました',
        'specific_activity_completed' => '特定のアクティビティが完了しました',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => '開始していません',
        'in_progress' => '進行中',
        'not_completed' => '未完了',
        'completed' => '完了',
        'cancelled' => 'キャンセル済み',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'ステージを編集',
        'stage_add_task_button' => 'タスクを作成',
        'stage_add_meeting_button' => '会議をスケジュール',
        'stage_add_call_button' => '通話をスケジュール',
        'stage_delete_button' => 'ステージを削除',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'タスクを追加',
        'activity_add_sub_meeting_button' => '会議をスケジュール',
        'activity_add_sub_call_button' => '通話をスケジュール',
        'activity_not_applicable_button' => '該当なし',
        'activity_delete_button' => '削除',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => '該当なしを設定',
        'remove_open_activities' => 'オープンアクティビティを削除',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'デフォルト',
        'custom' => 'カスタム',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => '取得',
        'POST' => '投稿',
        'PUT' => '置く',
        'PATCH' => 'パッチ',
        'DELETE' => '削除',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'リクエストをスキップ',
        'json' => 'JSON',
        'http_query' => 'HTTP クエリ',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => '応答なし',
        'json' => 'JSON',
        'http_query' => 'HTTP クエリ',
        'text' => 'プレーンテキスト',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => '作成前',
        'after_create' => '作成後',
        'before_in_progress' => '進行中の前',
        'after_in_progress' => '進行中の後',
        'before_completed' => '完了前',
        'after_completed' => '完了後',
        'before_not_applicable' => '該当なしの前',
        'after_not_applicable' => '該当なしの後',
        'before_delete' => '削除前',
        'after_delete' => '削除後',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'スマートガイド情報を送信',
        'custom_body' => 'カスタム投稿本文を送信',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => '進行中',
        'completed' => '完了',
        'not_applicable' => '該当なし',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'レコードを表示',
        'create_record' => 'レコードを作成',
        'update_record' => 'レコードを更新',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'レコードを自動的に作成',
        'manual_create' => 'レコードを手動で作成',
        'automatic_update' => 'レコードを自動的に更新',
        'manual_update' => 'レコードを手動で更新',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'スマートガイドテンプレート',
        'DRI_SubWorkflow_Templates' => 'ステージテンプレート',
        'DRI_Workflow_Task_Templates' => 'アクティビティテンプレート',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'はい',
        'no' => 'いいえ',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => '保留中',
        'Not Held' => '未待機',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => '保留中',
        'Not Held' => '未待機',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => '完了',
        'Not Applicable' => '非適用',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'スマートガイドテンプレート',
        'DRI_SubWorkflow_Templates' => 'ステージテンプレート',
        'DRI_Workflow_Task_Templates' => 'アクティビティテンプレート',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'タスク',
        'Meetings' => '会議',
        'Calls' => '通話',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => '現在のタスク',
        'Calls' => '現在の通話',
        'Meetings' => '現在の会議',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => '特定ユーザー',
        'specific_contacts' => '特定の取引先担当者',
        'related_parent_users' => '関連する親ユーザー',
        'related_parent_contacts' => '関連する親取引先担当者',
        'add_all_contacts_from_parent' => '親からのすべての取引先担当者を追加',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'ユーザー',
        'specific_contacts' => '取引先担当者',
        'related_parent_users' => 'ユーザー',
        'related_parent_contacts' => '取引先担当者',
        'add_all_contacts_from_parent' => '取引先担当者',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => '分',
        'hours' => '時間',
        'days' => '日',
        'months' => '月',
        ],
        'cj_relative_date_type_list' => [
        'days' => '日',
        'months' => '月',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => '固定の日付',
        'relative' => '相対日付',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'ユーザー',
        'teams' => 'チーム',
        'roles' => '役割',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart GuideからSugarアクションへ',
        'sugar_action_to_smart_guide' => 'SugarアクションからSmart Guideへ',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guideステージ',
        'Smart Guide Activities' => 'Smart Guideアクティビティ',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => '完了',
        'cancelled' => 'キャンセル済み',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => '進行中',
        'completed' => '完了',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => '進行中',
        'completed' => '完了',
        'not_applicable' => '非適用',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'アクティビティをすべて完了にする',
        'mark_all_not_applicable' => '完了していないアクティビティをすべて未適用にする',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => '米国（オレゴン）[us-west-2]',
        'ca-central-1' => 'カナダ（中部）[ca-central-1]',
        'ap-southeast-1' => 'アジア太平洋（シンガポール）[ap-southeast-1]',
        'ap-southeast-2' => 'アジア太平洋（シドニー）[ap-southeast-2]',
        'eu-central-1' => 'ヨーロッパ（フランクフルト）[eu-central-1]',
        'eu-west-2' => 'ヨーロッパ（ロンドン）[eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'レコードヘッダー', // Studio editing of record views
    'LBL_RECORD_BODY' => '名刺', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'さらに表示', // Studio editing of record views
    'LBL_FAVORITE' => 'お気に入り', // Record view header panel element
    'LBL_FOLLOW' => 'フォロー', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'リンクをフォローする',
    'LBL_TOGGLE_VISIBILITY' => '表示/非表示', // Record view header panel element
    'LBL_ACTIVITIES' => 'アクティビティストリーム',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM、Sugarおよび3-DキューブはSugarCRM Inc. の登録商標です。 ' .
        'この製品に使用される、または出現するその他すべての会社名および製品名は ' .
        'SugarCRM®、Sugar Enterprise™ および Sugar™ は、SugarCRM 社の商標です。',
    'LBL_TRADEMARK2' => 'SugarCRM ®、Sugar Enterprise™、およびSugarは™、SugarCRM Inc.の商標です。',
    'LBL_SEND_INVITE' => '招待を送る',
    'LBL_INVITEES' => '参加者',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'ゲストには招待状は送信されません',
    'LBL_SELECT_ACTION_LABEL' => 'アクション選択',
    'LBL_TOGGLE_DRAWER' => '開く/閉じる',
    'LBL_TOUR_NEXT' => '次へ',
    'LBL_TOUR_SKIP' => 'スキップ',
    'LBL_TOUR_BACK' => '前へ',
    'LBL_TOUR_CLOSE' => '完了',
    'LBL_TOUR_BTN_DONE' => '完了',
    'LBL_TOUR_TAKE_TOUR' => 'ツアーを実施',
    'LBL_TOUR_FULL_TOUR' => 'フルツアー',
    'LBL_TOUR_MODULE' => 'このページをツアーする',
    'LBL_TOUR_END_TOUR' => 'ツアーを終了',
    'LBL_TOUR_OVERVIEW' => 'ページ概観',
    'LBL_TOUR_REVISIT' => 'いつでもここをクリックしてツアーを表示する',
    'LBL_MY_AREA_LINKS' => '私のエリアリンク:' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Airを取得中' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'ようこそ' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => '詳細検索' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => '詳細情報' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => '編集' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => '閲覧' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => '検索' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => '検索...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => '削除' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => '追加' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => '列' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2列' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3列' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => '詳細検索' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => '追加' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => '非表示/表示' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => '削除' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => '追加' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'クリア' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'はずす' /*for 508 compliance fix*/,
    'LBL_ADD' => '追加' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => '会社ロゴ' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'カレンダー' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => '選択したドロップダウンの値によって、レコードビューのレイアウトが変更されました。' .
        'この新しいレイアウトで非表示になったフィールドの値はクリアされます。',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => '開く',
    'LBL_SIDEBAR_NAV_CLOSE' => '閉じる',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} メニュー',
    'LBL_GOTO_SUGARCRM_COM' => 'SugarCRM.com に移動',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'メインモジュールのナビゲーション',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'サブパネルの切り替え',

    'LBL_ADVANCED' => '高度な設定',
    'LBL_BASIC' => '基本設定',
    'LBL_MODULE_FILTER' => '絞る',
    'LBL_CONNECTORS_POPUPS' => 'コネクタポップアップ',
    'LBL_CLOSEINLINE' => '完了',
    'LBL_EDITINLINE' => '編集',
    'LBL_VIEWINLINE' => '閲覧',
    'LBL_INFOINLINE' => 'Info',
    'LBL_POWERED_BY_SUGARCRM' => 'Powered by SugarCRM',
    'LBL_PRINT' => '印刷',
    'LBL_HELP' => 'ヘルプ',
    'LBL_TOUR' => 'アクティビティビューのツアー',
    'LBL_TOUR_LINK' => 'このページの紹介',
    'LBL_MOBILE' => 'モバイル',
    'LBL_ID_FF_SELECT' => '選択',
    'DEFAULT' => 'ベーシック',
    'LBL_SORT' => 'ソート',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'サーバを追加...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'SMTP over SSL/TLS の設定',
    'LBL_NO_ACTION' => 'アクションがありません。',
    'LBL_NO_DATA' => 'データなし',
    'LBL_NOT_APPLICABLE' => '該当なし',
    'LBL_ROUTING_ADD_RULE' => 'ルールを追加',
    'LBL_ROUTING_ALL' => 'すべて含む',
    'LBL_ROUTING_ANY' => 'いずれかを含む',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'キャンセル',
    'LBL_ROUTING_BUTTON_SAVE' => '保存',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => '次のフォルダへメールをコピー',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Sugarオブジェクトを削除',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'ファイルを削除',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'Eメールを削除',
    'LBL_ROUTING_ACTIONS_FORWARD' => '次のアドレスへEメールを転送',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'Eメールにフラグをつける',
    'LBL_ROUTING_ACTIONS_MARK_READ' => '既読にする',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => '未読にする',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => '次のフォルダへEメールを移動',
    'LBL_ROUTING_ACTIONS_PEFORM' => '以下のアクションを実行',
    'LBL_ROUTING_ACTIONS_REPLY' => '次のテンプレートを使用してEメールに返信',

    'LBL_ROUTING_CHECK_RULE' => "エラーが見つかりました:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'すべてのフィールドがマークされているかを確認してください。',
    'LBL_ROUTING_CONFIRM_DELETE' => "このルールを本当に削除しますか？<br />この操作は取り消しできません。",

    'LBL_ROUTING_FLAGGED' => 'が指定されている',
    'LBL_ROUTING_FORM_DESC' => '保存されたルールはすぐに有効になります。',
    'LBL_ROUTING_FW' => 'FW:',
    'LBL_ROUTING_LIST_TITLE' => 'ルール',
    'LBL_ROUTING_MATCH' => 'もし',
    'LBL_ROUTING_MATCH_2' => '以下の条件が合致:',
    'LBL_NOTIFICATIONS' => '通知',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'CC',
    'LBL_ROUTING_MATCH_DESCRIPTION' => '本文',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'From',
    'LBL_ROUTING_MATCH_NAME' => '件名',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => '高優先度',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => '中優先度',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => '低優先度',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'To',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => '次の値を含む',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'に次の内容を含まない',

    'LBL_ROUTING_NAME' => 'ルール名',
    'LBL_ROUTING_NEW_NAME' => '新ルール',
    'LBL_ROUTING_ONE_MOMENT' => 'しばらくお待ちください...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => '以下はオリジナルのメッセージです。',
    'LBL_ROUTING_RE' => 'RE:',
    'LBL_ROUTING_SAVING_RULE' => 'ルールを保存中',
    'LBL_ROUTING_SUB_DESC' => 'チェックされたルールは有効です。編集するには名前をクリックしてください。',
    'LBL_ROUTING_TO' => 'から',
    'LBL_ROUTING_TO_ADDRESS' => '送信先アドレス',
    'LBL_ROUTING_WITH_TEMPLATE' => 'テンプレートと共に',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => '会社電話、および住所情報の各フィールドがすでに入力されています。取引先に登録された情報で上書きする場合はOKボタンを、そうでない場合はキャンセルボタンをクリックしてください。',
    'LBL_DROP_HERE' => '[ここへドロップ]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => '編集',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Gmail &#153; のデフォルト設定を埋め込む',
    'LBL_EMAIL_ACCOUNTS_NAME' => '名前',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => '送信メールサーバ',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'メール送信エージェント',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'SMTP認証を使用',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTPパスワード',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTPポート',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTPサーバ',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => '接続時にSSLを使用',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTPユーザ名',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'デフォルト',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => '警告: 送信アカウントのユーザ名とパスワードがありません。',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTPのユーザ名が必要です',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTPのパスワードが必要です',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'メールアカウント管理',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'メールサーバプロトコルのPOP3は次バージョンではサポートされません。IMAPのみがサポートされます。',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'メールアカウントを設定してお使いの各種 Eメールアカウントの受信Eメールを表示します。',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => '各種メールアカウントでEメールの送信に使用する SMTP メールサーバーを指定してください。',
    'LBL_EMAIL_ADD' => 'Eメールを追加',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => '完了',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'クリア',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'To:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Cc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Bcc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'To/Cc/Bcc',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'リストを追加',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'Eメール',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => '今回は取引先担当者の編集のみサポートされます。',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => '絞り込み',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => '名',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => '姓',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => '私の取引先担当者',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => '私のメーリングリスト',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => '名前',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'アドレスが見つかりません',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => '保存してアドレス帳に追加',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => '検索',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Eメールの宛先を選択',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'アドレス帳',
    'LBL_EMAIL_REPORTS_TITLE' => 'レポート',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => '警告: 削除しようとしている送信アカウントは受信アカウントに紐付いています。本当に継続してよいですか？',
    'LBL_EMAIL_ADDRESSES' => 'Eメールアドレス',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'Eメール',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'Eメールアドレス',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Sugarへインポート',
    'LBL_EMAIL_ASSIGNMENT' => 'アサイン先',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'メールに添付',
    'LBL_EMAIL_ATTACHMENT' => '添付',
    'LBL_EMAIL_ATTACHMENTS' => 'ローカルファイル',
    'LBL_EMAIL_ATTACHMENTS2' => 'Sugarドキュメント',
    'LBL_EMAIL_ATTACHMENTS3' => 'テンプレート添付ファイル',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'ファイル',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'ドキュメント',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => '埋め込み',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => '添付はアップロードに失敗',
    'LBL_REMOVING_ATTACHMENT' => '添付ファイルを削除中...',
    'LBL_EMAIL_BCC' => 'BCC',
    'LBL_EMAIL_CANCEL' => 'キャンセル',
    'LBL_EMAIL_CC' => 'CC',
    'LBL_EMAIL_CHARSET' => '文字コードセット',
    'LBL_EMAIL_CHECK' => 'Eメール確認',
    'LBL_EMAIL_CHECKING_NEW' => '新着Eメールをチェック',
    'LBL_EMAIL_CHECKING_DESC' => '新規メールをチェック中。<br><br>これが最初のチェックの場合、時間がかかることがあります。',
    'LBL_EMAIL_CLOSE' => '完了',
    'LBL_EMAIL_COFFEE_BREAK' => '新規Eメールをチェック中。<br><br>大量にメールがある場合は時間がかかることがあります。',
    'LBL_EMAIL_COMMON' => '共通',

    'LBL_EMAIL_COMPOSE' => 'Eメール作成',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'このEメールの受信者を指定してください。',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'を関連付ける',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'このEメールには本文がありません。送信しますか？',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'このEメールには件名がありません。送信しますか？',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(題名なし)',
    'LBL_EMAIL_COMPOSE_READ' => '読んでEメールを作成',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'メールアカウントから送信',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'オプション',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'To、CC、BCC欄に正しいEメールアドレスを入力してください。',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'このEメールを破棄しますか？',
    'LBL_EMAIL_CONFIRM_DELETE' => 'これらのエントリをアドレス帳からはずしますか？',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'このシグネチャを削除しますか？',

    'LBL_EMAIL_CREATE_NEW' => '--保存時に作成--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => '複数',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'なし',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => '送信者が送信した日',
    'LBL_EMAIL_DATE_RECEIVED' => '受信日',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'アサイン先',
    'LBL_EMAIL_DATE_TODAY' => '今日',
    'LBL_EMAIL_DATE_YESTERDAY' => '昨日',
    'LBL_EMAIL_DD_TEXT' => 'Eメールが選択されました。',
    'LBL_EMAIL_DEFAULTS' => 'デフォルト',
    'LBL_EMAIL_DELETE' => '削除',
    'LBL_EMAIL_DELETE_CONFIRM' => '選択したメッセージを削除しますか？',
    'LBL_EMAIL_DELETE_SUCCESS' => 'Eメールは削除されました。',
    'LBL_EMAIL_DELETING_MESSAGE' => 'メッセージを削除しています',
    'LBL_EMAIL_DETAILS' => '詳細',
    'LBL_EMAIL_DISPLAY_MSG' => '{2} 件中 {0} - {1} のEメールを表示中',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => '{2} 中の {0} - {1} のEメールアドレスを表示中',

    'LBL_EMAIL_EDIT_CONTACT' => '取引先担当者を編集',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => '取引先担当者に対して適用する場合は、主となる住所が使用されます。',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'メーリングリストを編集',

    'LBL_EMAIL_EMPTYING_TRASH' => 'ゴミ箱を空にしています',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'アウトバウンド用メールサーバを削除',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'キャッシュファイルを削除',
    'LBL_EMAIL_EMPTY_MSG' => '表示するEメールがありません。',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => '表示するEメールアドレスがありません。',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'フォルダ名はユニークで空白以外である必要があります。',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'フォルダを削除できません。メールボックスが、当該フォルダかそのサブフォルダと紐づいています。',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => '状況から意図されたフォルダを決定することができません。再度試してください。',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => '設定を確認してください。',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => '姓を入力しているかを確認してください。',
    'LBL_EMAIL_ERROR_DESC' => 'エラーが見つかりました:',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'この操作を行う権限を持っていません。サイト管理者に連絡してください。',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugarフォルダの名前はユニークである必要があります。',
    'LBL_EMAIL_ERROR_EMPTY' => '検索条件を入力してください。',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'エラーが発生しました。',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'その名前のEメールリストは既に存在します。',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'サーバからメッセージが削除されました。',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'メッセージはサーバから削除されるか異なるフォルダに移動されます。',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'メールサーバへの接続に失敗しました。サーバ管理者に連絡してください。',
    'LBL_EMAIL_ERROR_MOVE' => 'Eメールやメールアカウントをサーバ間で移動することはサポートされていません。',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => '移動エラー',
    'LBL_EMAIL_ERROR_NAME' => '名前は必須です。',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'Fromアドレスが必要です。',
    'LBL_EMAIL_ERROR_NO_FILE' => 'ファイルを提供してください。',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'IMAPフォルダの名前を変えることはサポートされていません。',
    'LBL_EMAIL_ERROR_SERVER' => 'メールサーバのアドレスは必須です。',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'このメールアカウントはまだ保存されていません。',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'メールサーバとの通信中に問題が発生しました。',
    'LBL_EMAIL_ERROR_USER' => 'ユーザ名は必須です。',
    'LBL_EMAIL_ERROR_PASSWORD' => 'パスワードは必須です。',
    'LBL_EMAIL_ERROR_PORT' => 'メールサーバのポート番号は必須です。',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'サーバのプロトコルは必須です。',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => '監視フォルダは必須です。',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'ゴミ箱フォルダは必須です。',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'この情報は有効ではありません。',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => '送信用のサーバが指定されていません。',
    'LBL_EMAIL_FOLDERS' => 'フォルダ',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'へ移動',
    'LBL_EMAIL_FOLDERS_ADD' => '追加',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => '新たなフォルダを追加',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'フォルダの名前を変更',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => '保存',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'このフォルダに追加',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'このフォルダは変更できません',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'このフォルダを本当に削除しますか？この処理は取り消しできません。フォルダの削除は、そのフォルダに含まれるすべてのフォルダも削除します。',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => '新しいフォルダ',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'このアクションを実行する前にフォルダを選択してください。',
    'LBL_EMAIL_FOLDERS_TITLE' => 'フォルダ管理',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'グループを使用する',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'チームへアサイン',
    'LBL_EMAIL_FORWARD' => '転送',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => '[[total]] 件中 [[count]] 件のEメールをダウンロードしました。',
    'LBL_EMAIL_FOUND' => '検出',
    'LBL_EMAIL_FROM' => 'From',
    'LBL_EMAIL_GROUP' => 'グループ',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'グループ',
    'LBL_EMAIL_HOME_FOLDER' => 'ホーム',
    'LBL_EMAIL_HTML_RTF' => 'HTMLを送信',
    'LBL_EMAIL_IE_DELETE' => 'メールアカウントを削除中',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'シグネチャを削除中',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'このメールアカウントを削除してよいですか？',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => '削除しました。',
    'LBL_EMAIL_IE_SAVE' => 'メールアカウントの情報を保存しています。',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'Eメールを取り込んでいます',
    'LBL_EMAIL_IMPORT_EMAIL' => 'Sugarへインポート',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'インポート設定',
    'LBL_EMAIL_INVALID' => '無効',
    'LBL_EMAIL_LINK_RECORD' => 'ここをクリック',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'メーリングリストの名前を変更',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'このメーリングリストの新しい名前を入力してください。',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'メーリングリストからこれらのエントリをはずしますか？',
    'LBL_EMAIL_LOADING' => '読み込み中...',
    'LBL_EMAIL_MARK' => 'マーク',
    'LBL_EMAIL_MARK_FLAGGED' => 'フラグをつける',
    'LBL_EMAIL_MARK_READ' => '既読とする',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'フラグをはずす',
    'LBL_EMAIL_MARK_UNREAD' => '未読とする',
    'LBL_EMAIL_ASSIGN_TO' => 'アサイン先',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'フォルダを追加',
    'LBL_EMAIL_MENU_COMPOSE' => 'このアドレス宛にメールを作成',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'フォルダを削除',
    'LBL_EMAIL_MENU_EDIT' => '編集',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'ゴミ箱を空にする',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => '同期',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'キャッシュファイルを削除',
    'LBL_EMAIL_MENU_REMOVE' => '削除',
    'LBL_EMAIL_MENU_RENAME' => '名前を変更',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'フォルダをリネーム',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'フォルダの名前を変更中',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'この操作を試みる前に選択してください。',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'フォルダを作成(リモートまたはSugarで)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'このEメールをSugarへ保存',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => '選択されたメーリングリストにEメールを送信',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => '取引先担当者にEメールを送信',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => '取引先担当者をはずす',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'これらのEメールを削除',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'フォルダを削除(リモートまたはSugarで)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => '取引先担当者を編集',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'メーリングリストを編集',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'アカウントのすべてのゴミ箱フォルダを空にする',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'これらのEメールにフラグをつける',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'これらのEメールを既読にする',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'これらのEメールのフラグを外す',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'これらのEメールを未読にする',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'メーリングリストをはずす',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'フォルダをリネームする（リモートまたはSugarで）',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'これらのEメールに返信する',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'これらのEメールのすべての受信に返信する',

    'LBL_EMAIL_MESSAGES' => 'メッセージ',

    'LBL_EMAIL_ML_NAME' => 'メーリングリスト名',
    'LBL_EMAIL_ML_ADDRESSES_1' => '選択されたメーリングリストアドレス',
    'LBL_EMAIL_ML_ADDRESSES_2' => '有効なメーリングリストアドレス',

    'LBL_EMAIL_MULTISELECT' => '複数選択するために<b>Ctrlを押しながらクリック</b>してください<br />(Macユーザは<b>CMDを押しながらクリック</b>)',

    'LBL_EMAIL_NO' => 'いいえ',
    'LBL_EMAIL_NOT_SENT' => 'システムはリクエストを処理できません。システム管理者に問い合わせてください。',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'users_password_linkに挿入できませんでした。',

    'LBL_EMAIL_OK' => 'OK',
    'LBL_EMAIL_ONE_MOMENT' => 'しばらくお待ちください...',
    'LBL_EMAIL_OPEN_ALL' => '複数のメッセージを開く',
    'LBL_EMAIL_OPTIONS' => 'オプション',
    'LBL_EMAIL_QUICK_COMPOSE' => 'クイック作成',
    'LBL_EMAIL_OPT_OUT' => 'メール送信除外',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => '送信除外かつ無効なEメール',
    'LBL_EMAIL_PAGE_AFTER' => '{0} 中',
    'LBL_EMAIL_PAGE_BEFORE' => 'ページ',
    'LBL_EMAIL_PERFORMING_TASK' => 'タスクを実行中',
    'LBL_EMAIL_PRIMARY' => 'メインアドレス',
    'LBL_EMAIL_PRINT' => '印刷',

    'LBL_EMAIL_QC_BUGS' => 'バグトラッカー',
    'LBL_EMAIL_QC_CASES' => 'ケース',
    'LBL_EMAIL_QC_LEADS' => 'リード',
    'LBL_EMAIL_QC_CONTACTS' => '取引先担当者',
    'LBL_EMAIL_QC_TASKS' => 'タスク',
    'LBL_EMAIL_QC_OPPORTUNITIES' => '商談',
    'LBL_EMAIL_QUICK_CREATE' => 'クイック作成',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'フォルダを再構築中',
    'LBL_EMAIL_RELATE_TO' => '関連付け',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => '関連を参照',
    'LBL_EMAIL_RECORD' => 'Eメールレコード',
    'LBL_EMAIL_REMOVE' => '削除',
    'LBL_EMAIL_REPLY' => '返信',
    'LBL_EMAIL_REPLY_ALL' => 'すべての返信',
    'LBL_EMAIL_REPLY_TO' => '返信',
    'LBL_EMAIL_RETRIEVING_LIST' => 'Eメーリングリストを取得中',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'メッセージ',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'Eメールを取得',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Eメールは１つだけ選択してください',
    'LBL_EMAIL_RETURN_TO_VIEW' => '直前のモジュールへ戻りますか？',
    'LBL_EMAIL_REVERT' => '戻す',
    'LBL_EMAIL_RELATE_EMAIL' => '関連Eメール',

    'LBL_EMAIL_RULES_TITLE' => 'ルール管理',

    'LBL_EMAIL_SAVE' => '保存',
    'LBL_EMAIL_SAVE_AND_REPLY' => '保存して返信',
    'LBL_EMAIL_SAVE_DRAFT' => 'ドラフト保存',

    'LBL_EMAIL_SEARCHING' => '検索を実行中',
    'LBL_EMAIL_SEARCH_ADVANCED' => '詳細検索',
    'LBL_EMAIL_SEARCH_DATE_FROM' => '以下の指定日以降',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => '以下の指定日まで',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => '本文テキスト',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => '検索条件に合致する結果はありません。',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => '検索結果',
    'LBL_EMAIL_SEARCH_TITLE' => '基本検索',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'Eメールアカウントを検索',

    'LBL_EMAIL_SELECT' => '選択',

    'LBL_EMAIL_SEND' => '送信',
    'LBL_EMAIL_SENDING_EMAIL' => 'Eメールを送信中',

    'LBL_EMAIL_SETTINGS' => '設定',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2行',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3列',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'レイアウトスタイル',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'メールアカウント',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'クリア',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => '閲覧時にEメールをインポート',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => '新着メールをチェック',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'プレビューペインを使用',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'ポップアップウィンドウを使用',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'ページごとに表示するEメールの数',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'メールアカウントの編集',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'フォルダ',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => '送信元アドレス',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'テスト通知のためのEメールアドレス:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => '宛先のEメールアドレス',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => '送信者名',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => '返信先アドレス',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'フルスクリーン',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'すべてのアカウントを同期',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => '設定された送信サーバ情報に基づいてEメールが指定された宛先に送信されました。Eメールが正しく送信され、サーバ情報が正しいことを確認してください。',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => '実行するとすべてのアカウントで内容が同期されます。',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'すべてのアカウントに対する同期を実行しますか？多くのアカウントがある場合は多少時間がかかります。',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'シフトキーかコントロールキーを押して複数フォルダを選択してください。',
    'LBL_EMAIL_SETTINGS_GENERAL' => '一般',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => '利用できるグループフォルダ',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'グループフォルダを作成',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'グループフォルダを保存中',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'グループフォルダを検索中',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'グループフォルダを編集',

    'LBL_EMAIL_SETTINGS_NAME' => 'アカウント名',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'これらの設定を有効にするには画面のリフレッシュが必要',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'アカウントを取得中',
    'LBL_EMAIL_SETTINGS_RULES' => 'ルール',
    'LBL_EMAIL_SETTINGS_SAVED' => '設定が保存されました。\n\n新たな設定を有効にするにはページをリロードする必要があります。',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => '新しい設定を有効にするにはページをリロードする必要があります。',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'テキストで送信',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => '有効なアカウント',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'ページごとに表示するEメールの数',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'タブを下部に表示',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => '表示設定',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => '初期設定',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => '拡張オプションを表示',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => '利用できるユーザフォルダ',
    'LBL_EMAIL_ERROR_PREPEND' => 'エラーメール:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => '利用中のメールアカウントで指定された送信サーバが正しくありません。設定を確認するか、別の送信サーバを選択してください。',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => '利用中のメールアカウントの送信サーバが設定されていません。送信サーバを選択するか、新たに追加してください。',
    'LBL_EMAIL_SHOW_READ' => 'すべてを表示',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => '未読のみ表示',
    'LBL_EMAIL_SIGNATURES' => '署名',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'シグネチャを作成',
    'LBL_EMAIL_SIGNATURE_NAME' => 'シグネチャ名',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'シグネチャ本文',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Google 安全性の低いアプリ',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo!メール',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'その他',
    'LBL_EMAIL_AUTHORIZE' => '承認',
    'LBL_EMAIL_AUTHORIZED' => '承認済み',
    'LBL_EMAIL_NOT_AUTHORIZED' => '未承認',
    'LBL_EMAIL_AUTH_WARNING' => '管理者は、このアカウントを設定する前に、[管理] > [コネクタ]で {0} コネクタを設定する必要があります。詳細については、{1} ドキュメントを参照してください。',
    'LBL_EMAIL_AUTH_API_ERROR' => 'コネクタ情報の取得エラー',
    'LBL_EMAIL_AUTH_FAILURE' => '承認失敗。',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => '保存する前にアカウントを承認してください。',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'テストを実施する前にアカウントを承認してください。',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'アカウント未承認',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ リモートフォルダ ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugarフォルダ ]',
    'LBL_EMAIL_SUBJECT' => '件名',
    'LBL_EMAIL_SUCCESS' => '成功',
    'LBL_EMAIL_SUGAR_FOLDER' => 'Sugarフォルダ',
    'LBL_EMAIL_TEAMS' => 'チームへアサイン',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'Eメールのテンプレート本文が空白です。',
    'LBL_EMAIL_TEMPLATES' => 'テンプレート',
    'LBL_EMAIL_TEXT_FIRST' => '最初のページ',
    'LBL_EMAIL_TEXT_PREV' => '前のページ',
    'LBL_EMAIL_TEXT_NEXT' => '次のページ',
    'LBL_EMAIL_TEXT_LAST' => '最後のページ',
    'LBL_EMAIL_TEXT_REFRESH' => '更新',
    'LBL_EMAIL_TO' => 'To',
    'LBL_EMAIL_TOGGLE_LIST' => 'リストを切替',
    'LBL_EMAIL_VIEW' => '閲覧',
    'LBL_EMAIL_VIEWS' => 'ビュー一覧',
    'LBL_EMAIL_VIEW_HEADERS' => 'ヘッダを表示',
    'LBL_EMAIL_VIEW_PRINTABLE' => '印刷可能バージョン',
    'LBL_EMAIL_VIEW_RAW' => 'Eメールの元データを表示',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'この機能はPOP3を使用する場合はサポートされません。',
    'LBL_DEFAULT_LINK_TEXT' => 'デフォルトリンクテキスト',
    'LBL_EMAIL_YES' => 'はい',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'テストEメールの送信',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'テストEメール送信済み',


    'LBL_EMAIL_MESSAGE_NO' => 'メッセージNo',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'インポートに成功しました',
    'LBL_EMAIL_IMPORT_FAIL' => 'インポートに失敗しました。対象メッセージはすでにインポート済みかサーバから削除されています。',

    'LBL_EMAILS_FROM' => 'Eメールは送られました',
    'LBL_EMAILS_RECEIVED' => 'Eメール受領',
    'LBL_EMAIL_ADDRESSES_USED' => 'Eメールで使用されるEメール アドレス',
    'LBL_EMAIL_ADDRESS' => 'Eメールアドレス',
    'LBL_FROM' => '差出人',
    'LBL_TO' => '宛先',
    'LBL_CC' => 'CC',
    'LBL_BCC' => 'BCC',

    'LBL_START_DATE' => '開始日',
    'LBL_END_DATE' => '終了日',
    'LBL_START' => '開始',
    'LBL_END' => '終了',
    'LBL_DATE_LINKED' => 'リンクされた日付',

    'LBL_LINK_NONE' => 'なし',
    'LBL_LINK_ALL' => 'すべての',
    'LBL_LINK_RECORDS' => 'レコード',
    'LBL_LINK_SELECT' => '選択',
    'LBL_LINK_ACTIONS' => 'アクション',
    'LBL_LINK_MORE' => '追加',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'はい',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'この #module# を閉じてよいですか？',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'このメッセージを今後表示しない:',
    'LBL_INVALID_FILE_EXTENSION' => '不正な拡張子',
    'LBL_LIST_TEAM' => 'チーム',
    'LBL_TEAM' => 'チーム:',
    'LBL_TEAMS' => 'チーム',
    'LBL_TEAM_SET_ID' => 'チームセットID',
    'LBL_TEAM_SET_SELECTED_ID' => '選択したチームセット ID',
    'LBL_TEAM_SET_SELECTED' => '選択済み',
    'LBL_TEAM_SET_ENABLE' => '追加のパーミッションを有効化',
    'LBL_TEAM_SET_DISABLE' => '追加のパーミッションを無効化',
    'LBL_TEAM_SET' => 'チームセット',
    'LBL_TEAM_SET_SELECTED_TEAMS' => '選択したチーム',
    'LBL_SEARCH_UNAVAILABLE' => '検索は利用できません。もう一度後でお試しください。',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => '主チームが設定されていません。',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => '[{1}] モジュールのID [{2}] の主チーム [{0}] をはずしている途中でエラーが発生しました。',
    'LBL_TEAM_ADD' => 'チームを追加',
    'LBL_TEAM_REMOVE' => 'チームを削除',
    'LBL_TEAM_PRIMARY' => '主要チームに設定',

    'LBL_CLOSE_BUTTON_LABEL' => '閉じる',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} はマークされました {{status}}.',

    'LBL_FOCUS' => 'フォーカス',

    'LBL_QUERY_VALID' => '有効',
    'LBL_QUERY_ERROR' => 'エラー!',
    'LBL_QUERY_CHILD' => '有効なサブクエリ',
    'ERROR_EXAMINE_MSG' => '以下のエラーメッセージを参照してください:',
    'NO_QUERY_SELECTED' => '選択したデータフォーマットにはクエリがありません。カスタムクエリを選択してください。',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'エラーが発生しました。',
    'ERR_AJAX_LOAD_FAILURE' => '要求のプロセス時にエラーが発生しました。後で再度実施してみてください。',
    'ERR_AJAX_LOAD_FOOTER' => 'エラーが発生し続ける場合は、このモジュールのAJAXを無効にするように管理者に依頼してください',
    'ERR_CREATING_FIELDS' => '詳細情報フィールドに入力する際にエラーがありました:',
    'ERR_CREATING_TABLE' => 'テーブルを作成する際にエラーがありました:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => '小数点記号と桁区切り記号に同じ文字を指定することはできません。いずれかの値を変更してください。',
    'ERR_DELETE_RECORD' => '取引先担当者を削除するにはレコード番号を指定する必要があります。',
    'ERR_EXPORT_DISABLED' => 'エクスポートを無効',
    'ERR_EXPORT_TYPE' => 'エクスポート中にエラー',
    'ERR_REPORTS_DISABLED_EXPORT' => 'レポートのエクスポートが無効になっています',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => '管理者ユーザーのみエクスポートできます',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'レポートでエクスポートにアクセスできないモジュールが使用されています',
    'ERR_REPORTS_EXPORT_OWNER' => 'レポートで所有者によるエクスポートにアクセスできるモジュールが使用されています',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'レポートでリストへのアクセスが制限されたモジュールが使用されています',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'レポートでビューへのアクセスが制限されたモジュールが使用されています',
    'ERR_REPORTS_ACCESS_DISABLED' => 'レポートでアクセスが制限されたモジュールが使用されています',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'レポートでアクセスが制限されたフィールドが使用されています',
    'ERR_INVALID_AMOUNT' => '有効な数字を入力してください',
    'ERR_INVALID_DATE_FORMAT' => '有効日付フォーマット:',
    'ERR_INVALID_DATE' => '有効な日を入力してください',
    'ERR_INVALID_DAY' => '有効な曜日を入力してください',
    'ERR_INVALID_EMAIL_ADDRESS' => '無効なEメールアドレスです',
    'ERR_INVALID_FILE_REFERENCE' => '不正なファイル参照',
    'ERR_INVALID_HOUR' => '有効な時間を入力してください',
    'ERR_INVALID_MONTH' => '有効な月を入力してください',
    'ERR_INVALID_TIME' => '有効な日時を入力してください',
    'ERR_INVALID_YEAR' => '有効な年を4桁で入力してください',
    'ERR_NEED_ACTIVE_SESSION' => 'コンテンツのエクスポートにはアクティブなセッションが必要です。',
    'ERR_NO_HEADER_ID' => 'この機能はこのテーマでは利用できません。',
    'ERR_NOT_ADMIN' => '管理エリアへのアクセスが認められていません。',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'パスワード管理は <a href="%s" target="_blank">SugarCloud設定</a> でのみ使用可能です。',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => '読み取り専用フィールドを変更したい場合は、Sugar管理者に問い合わせてください。',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => '読み取り専用フィールドに変更を加えるには、<a href="{0}" target="_blank">SugarCloud 設定</a> にアクセスしてください。',
    'ERR_MISSING_REQUIRED_FIELDS' => '必須フィールドが見つかりません:',
    'ERR_INVALID_REQUIRED_FIELDS' => '必須フィールドが不正です:',
    'ERR_INVALID_VALUE' => '不正な値:',
    'ERR_NO_SUCH_FILE' => 'システムにファイルが存在しません。',
    'ERR_NO_SINGLE_QUOTE' => 'シングルクォーテーションマークは使用できません:',
    'ERR_NOTHING_SELECTED' => '実行する前に選択してください。',
    'ERR_OPPORTUNITY_NAME_DUPE' => '%s の名前の商談は既に存在します。別の名前を使用してください。',
    'ERR_OPPORTUNITY_NAME_MISSING' => '商談名が入力されていません。商談名を入力してください。',
    'ERR_QUOTE_CONVERTED' => 'この見積は既に商談に変更されました。',
    'ERR_POTENTIAL_SEGFAULT' => '潜在的なApacheの例外が発見されました。この問題をシステム管理者に報告し、さらに、システム管理者からSugarCRM社へ報告してください。',
    'ERR_SELF_REPORTING' => '自分自身に報告できません',
    'ERR_SINGLE_QUOTE' => 'このフィールドではシングルクォーテーションマークは使用できません。値を変更してください。',
    'ERR_SQS_NO_MATCH_FIELD' => 'フィールドにマッチしません:',
    'ERR_SQS_NO_MATCH' => 'マッチしません',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Meta-Data定義用のdisplayParam属性中の「key」インデックスを指定してください',
    'ERR_EXISTING_PORTAL_USERNAME' => 'エラー: ポータル名はすでに他の取引先担当者にアサインされています。',
    'ERR_PORTAL_NAME_CHECK' => 'ポータルのユーザー名が独自のものであるかを確認できません',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'フィールドの値は、有効桁数値として適切ではありません。',
    'ERR_EXTERNAL_API_SAVE_FAIL' => '外部アカウントに保存中にエラーが発生しました。',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'アップロード中にエラーが発生しました。アップロード中のファイルが空白でないことを確認してください。',
    'ERR_NO_DB' => 'データベースに接続できません。詳細はsugarcrm.logを参照ください。',
    'ERR_DB_FAIL' => 'データベースのエラー: 詳細はsugarcrm.logを参照ください。',
    'ERR_EXTERNAL_API_403' => 'パーミッションがありません。ファイルタイプがサポートされていません。',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuthアクセストークンがありません。',
    'ERR_DB_VERSION' => 'Sugar CRM バージョン{0}のファイルはSugar CRM バージョン{1}のデータベースのみ使用できます。',
    'ERR_DB_QUERY' => '{0}: クエリ失敗: {1}',
    'ERR_UW_RETIRED' => 'アップグレードウィザードはこのバージョンにはありません。',
    'ERR_NOT_CLOUD_INSTANCE' => 'このSugarのインスタンスは、SugarCloudインスタンスではないか、またはSugarCloud Insights用に構成されていません。',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'あなたは{moduleName}モジュールを作成する権限がありません。権限が必要場合、管理者にご連絡ください。',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => '現在のユーザーは{moduleName}設定を変更する許可がありません。',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => '現在のユーザーは{moduleName}設定を変更する許可がありません。',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'お気に入りの{moduleName}に権限がありません。アクセスが必要でしたら管理者に連絡してください。',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'お気に入りの{moduleName}を登録する権限がありません。アクセスが必要でしたら管理者に連絡してください。',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'ペイロードにworksheet_columns_related_fieldsが存在しません',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columnsは配列ではありません',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'ペイロードにsummary_columns_related_fieldsが存在しません',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rowsは配列ではありません',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'ペイロードにfooter_rows_related_fieldsが存在しません',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => '不明の例外エラーでリクエストができませんでした。',
    'EXCEPTION_FATAL_ERROR' => 'リクエストが完了できませんでした。fatalエラーが発生しました。詳細はログを確認してください。',
    'EXCEPTION_NEED_LOGIN' => 'この操作を行うため、ログインする必要があります。',
    'EXCEPTION_INVALID_TOKEN' => '認証トークンが無効です。',
    'EXCEPTION_NOT_AUTHORIZED' => 'あなたはこの操作を行う権限がありません。権限が必要の場合システム管理者へご連絡ください。',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'データを表示する権限がありません。権限が必要な場合は、管理者に連絡してください。',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'あなたはポータルアカウントは未アクティブのためアクセスできません。アクセスが必要の場合カスタマーサポートまでご連絡ください。',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'ポータルの設定はまだ完了しておりません。ポータル管理者にご連絡ください。',
    'EXCEPTION_NO_METHOD' => 'あなたのリクエストはサポートしません。リクエストしたパスにHTTPメソッドを見つかりません。',
    'EXCEPTION_NOT_FOUND' => 'リクエストしたリソースを見つかりません。リクエストしたパスにハンドラを見つかりません。',
    'EXCEPTION_MISSING_PARAMTER' => 'リクエストの中に必要なパラメータがありません。',
    'EXCEPTION_INVALID_PARAMETER' => 'リクエストの中に無効のパラメータがあります。',
    'EXCEPTION_REQUEST_FAILURE' => 'リクエストを完了できませんでした。',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'メタデータもしくはユーザハッシュがサーバーと一致しませんでした。メタデータを再同期してください。',
    'EXCEPTION_REQUEST_TOO_LARGE' => '実行するリクエストが長過ぎます。',
    'EXCEPTION_EDIT_CONFLICT' => '編集が競合しています。レコードデータをリロードしてください。',
    'EXCEPTION_METADATA_CONFLICT' => 'メタデータが競合しています。メタデータをリロードしてください。',
    'EXCEPTION_CLIENT_OUTDATED' => 'ソフトウェアが古くなっています。再接続する前にクライアントをアップデートしてください。',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'コネクタまたはインテグレーションリクエストができませんでした。',
    'EXCEPTION_MAINTENANCE' => 'SugarCRMはメンテナンスモードです。管理者のみログインできます。詳細については管理者に連絡してください。',
    'EXCEPTION_SERVICE_UNAVAILABLE' => '現時点でビジーまたは使用不可能であるため、サーバーは要求を処理できません。',
    'EXCEPTION_SEARCH_UNAVAILABLE' => '検索エンジンは一時的に利用できません。',
    'EXCEPTION_SEARCH_RUNTIME' => '検索エンジンのランタイム エラーが発生しました。システム管理者に問い合わせてください。',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'プロセスによりロックされているフィールドは編集できません。',
    'EXCEPTION_MODULE_DISABLED' => 'このモジュールは、現在のユーザには無効です。',
    'EXCEPTION_FIELD_DISABLED' => 'このフィールドは、現在のユーザには無効です。',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'このクライアントは許可されていません',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'ご利用のライセンスタイプでは、パッケージのアップロード機能は使用できません',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => '一般的な失敗もしくはエラーにより条件が発生しました。この除外範囲の理由は、一般的により具体的なAPI除外の範囲外であることです。',
    'EXCEPTION_FATAL_ERROR_DESC' => 'リクエストはレスポンスにエラーが生じた事により処理されませんでした。これは一般的に致命的なエラーが起こった事を意味しますが、アプリケーションログにより特定の障害を確認できます。',
    'EXCEPTION_INCORRECT_VERSION_DESC' => '使用しているAPIのバージョンは、現在のリクエストに対して正確ではありません。',
    'EXCEPTION_NEED_LOGIN_DESC' => '要求されたエンドポイントが認証を必要とし、コンシューマのリクエストはまだ認証されていません。',
    'EXCEPTION_INVALID_TOKEN_DESC' => '要求を提示する認証トークンが無効であることを示します。これは一般的に期限切れトークンにより起こりますが、トークンが不正か正しくない可能性があります。',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'リクエストされたコンシューマーは、要求されたアクションを実行する権限がないことを示しています。',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'ログインユーザーと関連付けられているポータルアカウントは現在アクティブではありません。カスタマーサポートへのアクションが必要です。',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'ポータルアプリケーションが正しく設定されていなく、使用できないことを示しています。これはポータル管理者側でのアクションを必要とします。',
    'EXCEPTION_NO_METHOD_DESC' => 'エンドポイントはこのHTTPリクエストタイプをサポートしていません。これは例えばGETリクエストのためのエンドポイントがPOSTリクエストとしてなされた時に起こる可能性があります。',
    'EXCEPTION_NOT_FOUND_DESC' => 'エンドポイントはこのリクエストのリソースを見つける事ができなかったか、リクエストのハンドラーがありません。',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'レコードの同時編集があった可能性があり、レコードを編集する現在のリクエストが以前のレコード編集に影響を与える事を示しています。',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'サーバー上のメタデータは、クライアントが現在使用しているメタデータと一致していないことを示しています。これは、システムの設定変更、Studio内のモジュールへの変更、または他のシステム変更のうち、新しいモジュールの展開や変更後に発生する可能性があります。',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'リクエストはこのサーバーで処理するには大きすぎます。',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'リクエストの必須パラメータが未入力であることを示しています。',
    'EXCEPTION_INVALID_PARAMETER_DESC' => '送られたリクエストのパラメータが無効であることを示しています。',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'リクエストは完了できませんでした。',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => '顧客の使用するAPIが古いものであり、APIを更に使用する前にアップデートする必要があることを示します。',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => '別のサービス、終端へのAPI経由のリクエストがなされたか、またはURIが故障しているか、サーバで処理することができなかったことを示します。',
    'EXCEPTION_MAINTENANCE_DESC' => 'SugarCRMのAPI用インスタンスはメンテナンスモードです。APIへのアクセスは管理者のみに制限されています。',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'サーバーがビジー状態、オーバー ロードまたはダウンしていることを示します。',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => '検索エンジンのバックエンドは接続の問題のため現在利用できません。接続と管理-> 検索-> テストの設定を確認します。',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'サーチ エンジンでランタイム例外が発生しました。詳細については、sugarcrm.log を参照してください。',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => '実行中のプロセスにより現在ロックされているフィールドは編集できません。',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s は実行中のプロセスによりロックされており、編集できません。',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s は実行中のプロセスによりロックされており、編集できません。',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'このモジュールは、現在のユーザには無効です。',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'このフィールドは、現在のユーザには無効です。',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'このクライアントは許可されていません',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => '名称の同じファイルがシステムに存在します。',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'エラー　期間が不明確です 日付{0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'この期間は既にサブピリオドがあります',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'サブピリオドはサブピリオドを持つ事はできません',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => '{0}のタイプの期間を検索できません',
    'ERR_NO_ACTIVE_TIMEPERIOD' => '現在の設定にはアクティブな期間がありません。',
    'LBL_CURRENT_TIMEPERIOD' => '現在の期間',
    'LBL_PREVIOUS_TIMEPERIOD' => '以前の期間',
    'LBL_NEXT_TIMEPERIOD' => '次の期間',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => '以前、現在、次',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'クローズされたセールスステージのレコードを削除することはできません。',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'クローズされたセールスステージのレコードを削除することはできません。',

    'WARNING_NO_DELETE_SELECTED_STAGE' => '選択されたレコードの1つ以上はクローズドウォンまたはクローズドロストのセールスステージがあり、削除することはできません。',
    'WARNING_NO_DELETE_SELECTED_STATUS' => '選択されたレコードの1つ以上はクローズドウォンまたはクローズドロストのセールスステージがあり、削除することはできません。',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => '取引先',
    'LBL_OLD_ACCOUNT_LINK' => '以前の取引先',
    'LBL_ACCOUNTS' => '取引先',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'アクティビティ',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'サマリ表示',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'サマリ表示',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => '追加',
    'LBL_ADD_BUTTON' => '追加',
    'LBL_ADD_DASHLET_BUTTON' => 'ダッシュレットを追加',
    'LBL_ADD_DOCUMENT' => 'ドキュメント追加',
    'LBL_REPLACE_BUTTON' => '入れ替え',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'ターゲットリストに追加',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'ターゲットリストに追加',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'クリックして閉じる',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => '完了',
    'LBL_ADDITIONAL_DETAILS' => '詳細情報',
    'LBL_ADMIN' => '管理',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => '保存',
    'LBL_ASSIGNED_TO_USER' => 'アサイン先',
    'LBL_ASSIGNED_TO' => 'アサイン先:',
    'LBL_BACK' => '戻る',
    'LBL_BASE_RATE' => '基本レート',
    'LBL_BILL_TO_ACCOUNT' => '取引先に請求',
    'LBL_BILL_TO_CONTACT' => '取引先担当者に請求',
    'LBL_BILLING_ADDRESS' => '請求先住所',
    'LBL_QUICK_CREATE_TITLE' => 'クイック作成',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'バグトラッカー',
    'LBL_BY' => 'by',
    'LBL_CALLS' => '電話',
    'LBL_CALL' => '電話',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'キューに従ってキャンペーンEメールを送信',
    'LBL_SUBMIT_BUTTON_LABEL' => '作成',
    'LBL_CASE' => 'ケース',
    'LBL_CASES' => 'ケース',
    'LBL_MESSAGE' => 'メッセージ',
    'LBL_MESSAGES' => 'メッセージ',
    'LBL_ESCALATIONS' => 'エスカレーション',
    'LBL_ESCALATION' => 'エスカレーション',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSignエンベロープ',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSignエンベロープ',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => '署名者の受信者を選択',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'パスワード変更',
    'LBL_CHANGE_BUTTON_LABEL' => '変更',
    'LBL_CHANGE_BUTTON_TITLE' => '変更',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'すべてチェック',
    'LBL_CITY' => '市区町村',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'クリア',
    'LBL_CLEAR_BUTTON_TITLE' => 'クリア',
    'LBL_CLEARALL' => 'すべてクリア',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => '閉じる',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'ウィンドウを閉じる',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'すべて閉じる',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'すべて閉じる',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'これを完了状態にして複製を新規作成',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'これを完了状態にして複製を新規作成',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => '記録URLをコピー',
    'LBL_OPEN_ITEMS' => '未完了',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Eメール作成',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'Eメールアドレス',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Eメール作成',
    'LBL_SEARCH_DROPDOWN_YES' => 'はい',
    'LBL_SEARCH_DROPDOWN_NO' => 'いいえ',
    'LBL_CONTACT_LIST' => '取引先担当者一覧',
    'LBL_CONTACT' => '取引先担当者',
    'LBL_CONTACTS' => '取引先担当者',
    'LBL_CONTRACTS' => '契約',
    'LBL_COUNTRY' => '国:',
    'LBL_RESET_BUTTON_LABEL' => 'リセット',
    'LBL_CREATE_BUTTON_LABEL' => '作成',
    'LBL_CREATED_BY_USER' => 'ユーザーにより作成',
    'LBL_CREATED_USER' => 'ユーザーにより作成',
    'LBL_CREATED_ID' => '作成者ID',
    'LBL_CREATED' => '作成者',
    'LBL_CREATE_NEW_TARGET_LIST' => '新しいターゲットリストを作成する',
    'LBL_CURRENT_USER_FILTER' => 'マイアイテム:',
    'LBL_CURRENCY' => '通貨',
    'LBL_CURRENCIES' => '通貨',
    'LBL_CURRENCY_NAME' => '通貨名',
    'LBL_CURRENCY_SYMBOL' => '通貨シンボル',
    'LBL_CURRENCY_RATE' => 'ベースのレート:',
    'LBL_CURRENCY_ID' => '通貨ID',
    'LBL_DOCUMENTS' => 'ドキュメント',
    'LBL_DATE_ENTERED' => '作成日:',
    'LBL_DATE_MODIFIED' => '更新日:',
    'LBL_ACTIVITY_MODIFIED' => '変更済み',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'オーバービュータブの編集',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'モジュールタブの編集',
    'LBL_EDIT_BUTTON' => '編集',
    'LBL_DUPLICATE_BUTTON' => '複製',
    'LBL_DELETE_BUTTON' => '削除',
    'LBL_DELETE' => '削除',
    'LBL_DELETED' => '削除済み',
    'LBL_DIRECT_REPORTS' => '直接的なリポート',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => '完了',
    'LBL_DONE_BUTTON_TITLE' => '完了',
    'LBL_DST_NEEDS_FIXIN' => 'このアプリはサマータイムの設定が必要です。アドミン今s-ルの <a href="index.php?module=Administration&action=DstFix">Repair</a> リンクに行ってサマータイムを設定してください',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => '新規として編集',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => '新規として編集',
    'LBL_EDIT_IN_NEW_TAB' => '新しいタブ内で編集',
    'LBL_FAVORITES' => 'お気に入り',
    'LBL_FILTER' => 'フィルタ',
    'LBL_DEFAULT_DATA_FILTER' => '既定のデータフィルター',
    'LBL_FILTER_MENU_BY' => 'フィルタメニュー',
    'LBL_FILTER_SELECT_FIELD' => 'フィールドを選択',
    'LBL_FILTER_SELECT_OPERATOR' => 'オペレーターを選択',
    'LBL_FILTER_CREATE_NEW' => '作成',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'フィルターを作成(未保存)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(未保存)',
    'LBL_FILTER_CREATE_FILTER' => '新規フィルターの作成',
    'LBL_FILTER_CLOSE_FILTER' => 'フィルタを閉じる',
    'LBL_FILTER_EDIT_FILTER' => 'フィルターの編集',
    'LBL_FILTER_ALL_RECORDS' => '全てのレコード',
    'TPL_FILTER_SAVE' => 'フィールド{{name}}の作成に成功しました。',
    'LBL_FILTER_BETWEEN_FROM' => 'から',
    'LBL_FILTER_BETWEEN_TO' => 'To',
    'LBL_FILTER_DATEBETWEEN_FROM' => '開始日',
    'LBL_FILTER_DATEBETWEEN_TO' => '終了日',
    'LBL_FOLLOWING' => 'フォロー中',
    'LBL_UNFOLLOW' => 'フォローしていない',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'vCardをダウンロードする',
    'LBL_EMPTY_VCARD' => 'vCardファイルを選択してください',
    'LBL_IMAGE' => '画像',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCardはこのモジュールの全ての必須フィールドを持っていません。',
    'LBL_VCARD_ERROR_FILESIZE' => 'アップロードされたファイルはHTMLフォームで指定された30000バイトを超えています。',
    'LBL_VCARD_ERROR_DEFAULT' => 'vCardファイルのアップロードにエラーがありました。',
    'TPL_IMPORT_VCARD_FAILURE' => 'vCardから{{module}}を作成するのに失敗',
    'LBL_IMPORT_VCARD' => 'vCardのインポート',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'vCardのインポート',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'vCardのインポート',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => '閲覧',
    'LBL_VIEW_BUTTON_TITLE' => '閲覧',
    'LBL_VIEW_BUTTON' => '閲覧',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'PDFでEメール',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'PDFでEメール',
    'LBL_EMAIL' => 'Eメール',
    'LBL_EMAILS' => 'Eメール',
    'LBL_EMPLOYEES' => '従業員',
    'LBL_ENTER_DATE' => '作成日',
    'LBL_EXPORT_ALL' => '全てエクスポート',
    'LBL_EXPORT' => 'エクスポート',
    'LBL_FAVORITES_FILTER' => 'お気に入り：',
    'LBL_GLOBAL_SEARCH' => 'グローバル検索',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'グローバル検索モジュールフィルタ',
    'LBL_GLOBAL_SEARCH_RUN' => 'グローバル検索を実行',
    'LBL_GO_BUTTON_LABEL' => '実行',
    'LBL_GS_HELP' => '検索内のこのモジュールのフィールドをは上記のようです。強調されたテキストが検索条件に合っています。',
    'LBL_HIDE' => '非表示',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => 'インポート',
    'LBL_IMPORT_STARTED' => 'インポート開始:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'カスタムデリミタを設定してください。',
    'LBL_LAST_VIEWED' => '最新の閲覧履歴',
    'LBL_SELECTED_RECORDS' => '選択済: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => '「更に表示」を閉じる',
    'LBL_SHOW_MORE' => '更に表示',
    'LBL_SHOW_MORE_MODULE' => 'その他の {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'もっとRecents',
    'LBL_SHOW_LESS_RECENTS' => '少ないRecents',
    'LBL_SHOW_MORE_RESULTS' => '検索結果をさらに表示...',
    'TPL_SHOW_MORE_MODULE' => 'その他の {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => '更に {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => '今日のアクティビティ',
    'LBL_LEADS' => 'リード',
    'LBL_LEAD' => 'リード',
    'LBL_QUOTES_BILL_TO' => '見積（請求先）',
    'LBL_LESS' => '以下',
    'LBL_CAMPAIGN' => 'キャンペーン:',
    'LBL_CAMPAIGNS' => 'キャンペーン',
    'LBL_CAMPAIGNLOG' => 'キャンペーンログ',
    'LBL_CAMPAIGN_CONTACT' => 'キャンペーン',
    'LBL_CAMPAIGN_ID' => 'キャンペーンID',
    'LBL_THEME' => 'テーマ:',
    'LBL_THEME_PICKER' => 'ページスタイル',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => '警告：インターネットエクスプローラー6は選択されたテーマをサポートしていません。選択するにはOKを、違うテーマを選択するにはキャンセルをクリックしてください。',
    'LBL_FOUND_IN_RELEASE' => '発見リリース:',
    'LBL_FIXED_IN_RELEASE' => '修正リリース:',
    'LBL_LIST_ACCOUNT_NAME' => 'アカウント名',
    'LBL_LIST_ASSIGNED_USER' => 'ユーザ',
    'LBL_LIST_CONTACT_NAME' => '取引先担当者名',
    'LBL_LIST_CONTACT_ROLE' => '取引先担当者役割:',
    'LBL_LIST_DATE_ENTERED' => '作成日',
    'LBL_LIST_EMAIL' => 'Eメール',
    'LBL_LIST_NAME' => '名前',
    'LBL_LIST_OF' => 'の',
    'LBL_LIST_PHONE' => '電話',
    'LBL_LIST_RELATED_TO' => '関連先',
    'LBL_LIST_USER_NAME' => 'ユーザ名',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => '本当に全てのリストをアップデートしますか？',
    'LBL_LISTVIEW_NO_SELECTED' => '進めるには最低1つのレコードを選択してください。',
    'LBL_LISTVIEW_TWO_REQUIRED' => '進めるには最低2つのレコードを選択してください。',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => '進めるには最低10個のレコードを選択してください。',
    'LBL_LISTVIEW_ALL' => 'すべて',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'カラム1を固定',
    'LBL_DUPECHECK_FILTER_DEFAULT' => '全ての複製',
    'LBL_LISTVIEW_NONE' => '全てを非選択',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'このページを選択する',
    'LBL_LISTVIEW_OPTION_ENTIRE' => '全てを選択',
    'LBL_LISTVIEW_OPTION_SELECTED' => '選択されたレコード',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => '選択済: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => '選択した項目をすべて消去します。',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => '全てのレコードを選択する',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => '結果には {{num}} を超えるレコードがあります。最初の {{num}} レコードを選択されました。',
    'TPL_LISTVIEW_SELECTED' => '検索結果から{{num}}レコードを選択しました。',
    'TPL_LISTVIEW_SELECTED_ONE' => '検索結果から1つのレコードを選択しました。',
    'TPL_LISTVIEW_SELECTED_ALL' => '結果内の全ての{{num}} レコードを選択しました。',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'このビューの全ての{{num}} レコードを選択しました。 結果内の{{link}}',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => '{{total}} 中 {{num}} を更新中',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(残り約{{time}} {{unit}})',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => '一括更新失敗。再度実行({{total}中{{num}}回目}',
    'TPL_MASSUPDATE_WARNING_CLOSE' => '一括更新は未完了。{{num}} レコードが変更されていません。',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => '一括更新は未完了。{{num}} レコードが変更されていません。',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '許可またはエラーのため、{{remain}} レコードは無視されました',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} レコードのアップデートに成功しました。',
    'TPL_MASSUPDATE_TITLE' => '{{module}} 一括更新',
    'TPL_MASSDELETE_PROGRESS_STATUS' => '{{total}} 中 {{num}} を削除中',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(残り約{{time}} {{unit}})',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => '一括削除に失敗。再度実行 ({{total}}中{{num}}回目 )',
    'TPL_MASSDELETE_WARNING_CLOSE' => '一括削除に失敗。{{num}}レコードが残っています。',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => '一括削除に失敗。{{num}}レコードが残っています。',
    'TPL_MASSDELETE_SUCCESS' => '{{num}}レコードの削除に成功しました。',
    'TPL_MASSDELETE_TITLE' => '{{module}} 一括削除',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => '{{total}}中{{num}}を追加中',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(残り約{{time}} {{unit}})',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'ターゲットリストの一括追加に失敗。 再度実行({{total}}中{{num}}回目)',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'ターゲットリストの一括追加は未完了。 {{num}}レコードは追加されていません。',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'ターゲットリストの一括追加は未完了。 {{num}}レコードは追加されていません。',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} レコードの追加に成功しました。',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} ターゲットリストへの一括追加',
    'TPL_MASSLINK_PROGRESS_STATUS' => '{{total}}中{{num}}をリンク中。',
    'TPL_MASSLINK_DURATION_FORMAT' => '(残り約{{time}} {{unit}})',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => '一括リンクに失敗。再度実行({{total}}中{{num}}回目)。',
    'TPL_MASSLINK_WARNING_CLOSE' => '一括リンクに失敗。{{num}}レコードは追加されませんでした。',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => '一括リンクに失敗。{{num}}レコードは追加されませんでした。',
    'TPL_MASSLINK_SUCCESS' => '{{num}} レコードのリンクに成功しました。',
    'TPL_MASSLINK_TITLE' => '{{module}} 一括リンク',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => '選択',
    'LBL_LISTVIEW_ACTIONS' => 'アクション',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'このページのすべてのレコードを選択する',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'このページのすべてのレコードの選択を解除する',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} / {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '読み込み中 {{num}}...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'クリックして総数を表示',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => '/',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'ページ数を取得',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => '太郎',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => '佐藤',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => '様',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => '非凡なコード モンキー',
    'LBL_LOGIN_TO_ACCESS' => 'このエリアにアクセスするにはサインインしてください。',
    'LBL_LOGOUT' => 'ログアウト',
    'LBL_FINISH_IMPERSONATING' => '偽装を終了する',
    'LBL_RESET_MFA' => '多要素認証をリセットする',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}、あなたは現在 {{user}} になりすましています。',
    'LBL_PROFILE' => 'プロフィール',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'メールマージ',
    'LBL_MASS_UPDATE' => '一括更新',
    'LBL_MASS_UPDATE_ALL_RECORDS' => '大型アップデート用にすべての記録を選択する',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => '大型アップデートの記録を含める',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'フィールド追加',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'フィールドの削除',
    'LBL_GENERATE_QUOTE' => '見積を生成',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => '一括アップデートに使用可能なフィールドがありません',
    'LBL_MASS_UPDATE_JOB_QUEUED' => '一括アップデートのリクエストがスケジュールされました。',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'サービス開始日がサービス終了日より後になっています',
    'LBL_MASS_UPDATE_SUCCESS' => '全てのレコードのアップデートに成功しました。',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => '選択されたレコードは<a href="{{listUrl}}">{{listName}}</a>ターゲットリストに追加されました。',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => '選択されたレコードを<a href="{{listUrl}}">{{listName}}</a>ターゲットリストに追加するリクエストがスケジュールされました。',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'アップデートは以下の値を削除します：',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => '現在の値を保存する際はキャンセルしてください。値を削除する際は確認してください。',
    'LBL_OPT_OUT_FLAG_PRIMARY' => '主のEメールを選択する',
    'LBL_MEETINGS' => '会議',
    'LBL_MEETING' => '会議:',
    'LBL_MEETING_GO_BACK' => 'ミーティングに戻る',
    'LBL_MEMBERS' => 'メンバー',
    'LBL_MEMBER_OF' => '以下のメンバー',
    'LBL_MODIFIED_BY_USER' => 'ユーザーにより更新',
    'LBL_MODIFIED_USER' => 'ユーザーにより更新',
    'LBL_MODIFIED' => '更新者',
    'LBL_MODIFIED_NAME' => '更新者',
    'LBL_MODIFIED_ID' => '更新者ID',
    'LBL_MORE' => '追加',
    'LBL_MORE_MODULES' => '更にモジュール',
    'LBL_MORE_TABS' => 'その他のタブ',
    'LBL_MULTIPLE_MODULES' => '複数のモジュール',
    'LBL_COUNT_MODULES' => 'モジュール {{count}} 件',
    'LBL_MY_ACCOUNT' => 'ユーザ設定',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'システムデフォルト',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'ユーザーデフォルト',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'ユーザーアカウント',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'グループアカウント',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => '名前',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => '作成',
    'LBL_NEW_BUTTON_TITLE' => '作成',
    'LBL_NEXT_BUTTON_LABEL' => '次へ',
    'LBL_NOTES' => '備考',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => '全て開く',
    'LBL_OPENALL_BUTTON_TITLE' => '全て開く',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => '開く',
    'LBL_OPENTO_BUTTON_TITLE' => '開く',
    'LBL_OPEN_IN_NEW_TAB' => '新しいタブ内で開く',
    'LBL_OPPORTUNITIES' => '商談',
    'LBL_OPPORTUNITY_NAME' => '商談名',
    'LBL_OPPORTUNITY' => '商談',
    'LBL_OR' => 'もしくは',
    'LBL_LOWER_OR' => 'もしくは',
    'LBL_PANEL_ASSIGNMENT' => 'その他',
    'LBL_PANEL_ADVANCED' => '詳細情報',
    'LBL_PANEL_BODY' => '概要',
    'LBL_PARENT_TYPE' => '親タイプ',
    'LBL_RELATED_TYPE' => '関連タイプ',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => '範囲',
    'LBL_PICTURE_FILE' => 'アバター',
    'LBL_POSTAL_CODE' => '郵便番号:',
    'LBL_PRIMARY_ADDRESS_CITY' => '主となる市区町村:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => '主となる国:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => '主となる郵便番号:',
    'LBL_PRIMARY_ADDRESS_STATE' => '主となる都道府県:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => '主となる住所 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => '主となる住所 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => '主となる番地その他:',
    'LBL_PRIMARY_ADDRESS' => '主となる住所:',

    'LBL_BILLING_STREET' => '番地：',
    'LBL_SHIPPING_STREET' => '番地：',

    'LBL_PRODUCT_BUNDLES' => '製品セット',
    'LBL_PRODUCTS' => '製品',
    'LBL_PROJECT_TASKS' => 'プロジェクトタスク',
    'LBL_PRODUCT_TEMPLATES' => '製品テンプレート',
    'LBL_PROJECTS' => 'プロジェクト',
    'LBL_PROSPECTS' => 'ターゲット',
    'LBL_QUICK_CREATE_MENU' => 'クイックメニュー作成',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => '見積から商談を作成する',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => '見積から商談を作成する',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => '商談を作成中...',
    'LBL_QUOTES_SHIP_TO' => '見積（出荷先）',
    'LBL_QUOTES' => '見積',

    'LBL_FORECAST_WORKSHEETS' => '売上予測ワークシート',
    'LBL_FORECAST_WORKSHEET' => '売上予測ワークシート',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => '招待',
    'LBL_INVITED' => '招待済',
    'LBL_RECOMMENDED_INVITES' => '推奨の招待',
    'LBL_INSTANCES' => 'インスタンス',
    'LBL_YOUR_INSTANCES' => 'あなたのインスタンス',
    'LBL_INSTANCE_USERS' => 'インスタンスユーザー',
    'LBL_SWITCH_INSTANCE' => 'このインスタンスに切替',
    'LBL_LAST_LOGIN' => '最後のログイン',
    'LBL_ENTER_EMAIL' => '招待する人のEメールを入力。',
    'LBL_INSTANCE_IN_USE' => '使用中のインスタンス',
    'LBL_INSTANCE_ACTIVE' => '既にこのインスタンスを使用しています。',
    'LBL_INSTANCE_INVITE_SENT' => '送信先を招待',
    'LBL_INSTANCE_SWITCH_FAILED' => 'インスタンスをスイッチするのに失敗',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'リマインダ',
    'LBL_REMINDERS_OVERDUE' => '期限切れ',
    'LBL_REMINDERS_UPCOMING' => '今度',
    'LBL_REMINDERS_NONE_FOUND' => 'リマインダはありません。',
    'LBL_REMINDERS_FINISHED' => '完了',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => '商談メトリックス',

    'LBL_SWEETSPOT' => 'スイート スポット',
    'LBL_SWEETSPOT_CONFIG' => 'Sweet Spot Configuration Panel',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'ホットキー',
    'LBL_SWEETSPOT_CONFIG_ERR' => '構成設定を更新できませんでした: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'スイート スポット アクション',
    'LBL_SWEETSPOT_KEY' => 'キーワード',
    'LBL_SWEETSPOT_REMOVE' => 'アクションを削除する',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'ホットキー',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'アクション',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'レコード',
    'LBL_SWEETSPOT_THEME' => 'テーマ',
    'LBL_SWEETSPOT_THEME_SELECT' => 'テーマを選択する',

    'LBL_RELATED' => '関連',
    'LBL_RELATED_INFORMATION' => '関連情報',
    'LBL_RELATED_RECORDS' => '関連{{module}}',
    'LBL_REPORTS_TO' => '上司',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => '必須フィールド',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => '完了',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => '別名で保存',
    'LBL_SAVE_AS_BUTTON_TITLE' => '別名で保存',
    'LBL_FULL_FORM_BUTTON_KEY' => 'L',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'フルフォーム',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'フルフォーム',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => '保存して新規作成',
    'LBL_SAVE_NEW_BUTTON_TITLE' => '保存して新規作成',
    'LBL_SAVE_OBJECT' => '保存 {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => '検索',
    'LBL_SEARCH_BUTTON_TITLE' => '検索',
    'LBL_SEARCH' => '検索',
    'LBL_SEARCH_TIPS' => '検索ボタンを押すか入力をクリックしてぴったり合致する結果を得る',
    'LBL_SEARCH_TIPS_2' => '検索ボタンを押すか入力をクリックしてぴったり合致する結果を得る',
    'LBL_SEARCH_MORE' => 'さらに表示',
    'LBL_SEE_ALL' => '全て見る',
    'LBL_SEARCH_LOAD_MORE' => '更にロード',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => '無効なファイル形式。画像ファイルのみアップロードできます。',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => '画像フォーマット{0}はサポートされていません。',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => '選択',
    'LBL_SELECT_BUTTON_TITLE' => '選択',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'チームを追加',
    'LBL_SELECT_TEAMS_TITLE' => 'チームを追加',
    'LBL_SELECT_APPEND_TEAMS' => 'チームを追加',
    'LBL_SELECT_APPEND_VALUES' => '値を追加',
    'LBL_SELECT_APPEND_TAGS' => 'タグを追加する',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'ドキュメントをブラウズ',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'ドキュメントをブラウズ',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => '取引先担当者を選択',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => '取引先担当者を選択',
    'LBL_GRID_SELECTED_FILE' => '選択されたファイル',
    'LBL_GRID_SELECTED_FILES' => '選択されたファイル',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'レポートから選択',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => '選択されたレポート',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'ユーザ選択',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'ユーザ選択',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => '選択をクリア',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => '選択をクリア',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => '選択をクリア',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => '選択をクリア',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'ファイルを選択',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'ファイルを選択',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'ファイルをクリア',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'ファイルをクリア',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'ユーザ選択:',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'ユーザ選択:',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'ユーザをクリア',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'ユーザをクリア',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => '取引先選択',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => '取引先選択',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => '取引先をクリア',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => '取引先をクリア',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'キャンペーンを選択',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'キャンペーンを選択',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'キャンペーンをクリア',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'キャンペーンをクリア',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => '取引先担当者を選択',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => '取引先担当者を選択',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => '取引先担当者をクリア',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => '取引先担当者をクリア',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'チームを選択',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'チームを選択',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'チームをクリア',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'チームをクリア',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'リソースはこのページの作成に使用されています（クエリ、ファイル）',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => '秒',
    'LBL_SERVER_RESPONSE_TIME' => 'サーバー応答時間：',
    'LBL_SERVER_MEMORY_BYTES' => 'バイト',
    'LBL_SERVER_MEMORY_USAGE' => 'サーバーメモリ使用量: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => '使用量: - モジュール: {0} - アクション: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'サーバーのピーク時使用量: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => '出荷先の取引先',
    'LBL_SHIP_TO_CONTACT' => '出荷先の取引先担当者',
    'LBL_SHIPPING_ADDRESS' => '出荷先住所',
    'LBL_SHORTCUTS' => 'ショートカット',
    'LBL_SHOW' => '表示',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => '都道府県:',
    'LBL_STATUS_UPDATED' => 'このイベントのステータスがアップデートされました。',
    'LBL_STATUS_NOT_UPDATED' => 'このイベントのステータスは更新されていません。',
    'LBL_STATUS' => 'ステータス:',
    'LBL_STREET' => '番地',
    'LBL_SUBJECT' => '件名',

    'LBL_INBOUNDEMAIL_ID' => '受信EメールID',
    'LBL_EAMP_ID' => '承認トークンID',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        '無断複写・転載を禁じます。<br />SugarCRM、Sugarおよび3-DキューブはSugarCRM Inc. の登録商標です。 ' .
        'この製品に使用される、または出現するその他すべての会社名および製品名は ' .
        'それらが関連する各会社の登録商標である可能性があります。',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'スケジュールされたジョブが完了しました',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'スケジュールされたジョブの実行に成功しました',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => '商談品目はあなたのSugarインスタンスで有効です',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => '商談品目がSugarインスタンスで有効にされ、すべての既存の商談データが処理されました。インスタンスは現在商談品目で使用する準備ができています。行われた変更の詳細については{{doc_url}} を参照してください。SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => '売上予測モジュールはあなたのSugarインスタンスの商談で使用される準備ができています。',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'Sugarインスタンスの売上予測モジュールが商談と共に使用可能になっています。以前の商談品目売上予測コミットデータは削除され、インスタンスは商談にコミットされて作成された売上予測のために準備ができています。更なる変更に関する情報は{{doc_url}} をご覧ください。SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Sugarのインスタンス内で商談品目が無効になりました。',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => '現在 Sugar インスタンスで商品が無効化されていて、すべての既存商品データが処理されました。インスタンスが Opportunities で利用できるようになりました。加えられた変更について詳しくは {{doc_url}} を参照してください。

よろしくお願いいたします SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => '商談設定ドキュメンテーション',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'ログイン',
    'LBL_LOGIN_WELCOME_TO' => 'ようこそ',
    'LBL_LOGIN_OPTIONS' => 'オプション',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'パスワードをお忘れですか？',
    'LBL_LOGIN_SUBMIT' => '送信',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'ログインの失敗が最大値を超えました。',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => '再度ログインできるのは',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => '日後です。',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => '時間後です。',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => '分後です。',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => '秒後です。',
    'LBL_LOGIN_ADMIN_CALL' => 'システム管理者に連絡してください。',
    'LBL_LOGIN_USERNAME' => 'ユーザ名',
    'LBL_LOGIN_PASSWORD' => 'パスワード',
    'LBL_LOGGED_OUT' => 'ログアウトしました',
    'LBL_LOGIN_FORM_LABEL' => 'ログイン画面を表示',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'ログインに戻る',
    'LBL_LOGIN_INACTIVE_USER' => '非アクティブなユーザー',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'ポータルまたはグループ ユーザーはログインできません。',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'ダッシュボード',
    'LBL_SYNC' => '同期',
    'LBL_TASKS' => 'タスク',
    'LBL_TEAMS_LINK' => 'チーム',
    'LBL_THEME_COLOR' => 'カラー',
    'LBL_THEME_FONT' => 'フォント',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => '会議作成',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => '会議作成',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'Eメールアーカイブ',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'Eメールアーカイブ',
    'LBL_UNAUTH_ADMIN' => '管理者権限への権限の無いアクセス',
    'LBL_UNDELETE_BUTTON_LABEL' => '削除しない',
    'LBL_UNDELETE_BUTTON_TITLE' => '削除しない',
    'LBL_UNDELETE_BUTTON' => '削除しない',
    'LBL_UNDELETE' => '削除しない',
    'LBL_UNSYNC' => '同期しない',
    'LBL_UPDATE' => '更新',
    'LBL_UPDATES' => '更新',
    'LBL_USER_LIST' => 'ユーザーリスト',
    'LBL_USER_MENU' => 'ユーザーメニュー',
    'LBL_USERS_SYNC' => 'ユーザー同期',
    'LBL_USERS' => 'ユーザ',
    'LBL_USER' => 'ユーザー',
    'LBL_CURRENT_USER' => '現在のユーザー',
    'LBL_VERIFY_EMAIL_ADDRESS' => '現在のEメールエントリを確認しています',
    'LBL_VERIFY_PORTAL_NAME' => '現在のポータル名を確認しています。',
    'LBL_VIEW_IMAGE' => '表示',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'PDFとして印刷',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'PDFとして印刷',

    'LBL_KBDOCUMENTS' => 'ナレッジベース',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => '製品について',
    'LNK_ADVANCED_SEARCH' => '詳細検索',
    'LNK_BASIC_SEARCH' => '基本検索',
    'LNK_SEARCH_NO_RESULTS' => '結果がありません。',
    'LNK_SEARCH_FTS_VIEW_ALL' => '全ての結果を表示',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'すべてを表示',
    'LNK_CLOSE' => '閉じる',
    'LBL_MODIFY_CURRENT_SEARCH' => '現在の検索を編集',
    'LNK_SAVED_VIEWS' => 'レイアウトオプション',
    'LNK_DELETE_ALL' => '全て削除',
    'LNK_DELETE' => '削除',
    'LNK_EDIT' => '編集',
    'LNK_VIEW' => '表示',
    'LNK_GET_LATEST' => '最新のものを得る',
    'LNK_GET_LATEST_TOOLTIP' => '最新バージョンに替える',
    'LNK_HELP' => 'ヘルプ',
    'LNK_CREATE' => '作成',
    'LNK_CREATE_WHEN_EMPTY' => 'レコードを今作成',
    'LNK_LIST_END' => '終了',
    'LNK_LIST_NEXT' => '次',
    'LNK_LIST_PREVIOUS' => '前',
    'LNK_LIST_RETURN' => 'リストへ戻る',
    'LNK_LIST_START' => '開始',
    'LNK_LOAD_SIGNED' => 'サイン',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'サインされたドキュメントに替える',
    'LNK_PRINT' => '印刷',
    'LNK_BACKTOTOP' => 'トップへ戻る',
    'LNK_REMOVE' => 'はずす',
    'LNK_RESUME' => '再開',
    'LNK_VIEW_CHANGE_LOG' => '監査ログを表示',
    'TPL_AUDIT_LOG_TITLE' => '{{{name}}} の監査ログ',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'クリックしてメールアドレスの監査ログを見る',
    'LBL_NO_SEARCH_RESULTS' => '検索結果が見つかりませんでした。',
    'NTC_CLICK_BACK' => 'ブラウザの戻るボタンを押してエラーを直してください。',
    'NTC_DATE_FORMAT' => '(yyyy-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(yyyy-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => '本当に選択したレコードを削除しますか？',
    'NTC_TEMPLATE_IS_USED' => 'テンプレートは最低1つのEメールマーケティングレコードに使用されます。本当に削除しますか？',
    'NTC_TEMPLATES_IS_USED' => "以下のテンプレートはEメールマーケティングレコードに使用されます。本当に削除しますか？",
    'NTC_DELETE_CONFIRMATION' => '本当にこのレコードを削除してよいですか？',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => '本当に{0}を削除しますか？',
    'LBL_METRIC_DELETE_WARNING' => 'このメトリックタブを共有しているユーザーも、アクセスできなくなります。',
    'NTC_DELETE_CONFIRMATION_NUM' => '本当に以下を削除しますか',
    'NTC_UPDATE_CONFIRMATION_NUM' => '本当に以下をアップデートしますか',
    'NTC_DELETE_SELECTED_RECORDS' => '選択されたレコード？',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'フィルタは全てのビューから削除されます。これにはダッシュレットのデータ設定も含まれます。本当にこのフィルタを削除しますか？',
    'TPL_DELETE_FILTER_SUCCESS' => 'フィルタ {{name}}を削除しました。',
    'NTC_DELETE_SUCCESS' => '{0}を削除しました。',
    'NTC_UNLINK_CONFIRMATION' => '本当にこのレコードのリンクをはずしますか？',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => '本当に{0}のリンクをはずしますか？',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => '{0} のリンクを解除しますか？この操作を行うと、案件の[第一連絡先] フィールドも削除されます。',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => '{0} はこの案件の第一の連絡先であるため、リンク解除することはできません。この記録のリンクを解除する前に[第一の連絡先] フィールドを更新してください。',
    'NTC_UNLINK_SUCCESS' => '{0}のリンクをはずしました。',
    'NTC_LOGIN_MESSAGE' => 'ユーザー名とパスワードを入力してください。',
    'NTC_NO_ITEMS_DISPLAY' => 'なし',
    'NTC_REMOVE_CONFIRMATION' => '本当にこの関連付けをはずしてよいですか？関連付けだけがはずされ、レコードは削除されません。',
    'NTC_REQUIRED' => '必須フィールド',
    'NTC_SUPPORT_SUGARCRM' => 'SugarCRMオープンソースプロジェクトにペイパルで寄付をしてサポートする。早くて安全。',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'ようこそ',
    'NTC_YEAR_FORMAT' => '(yyyy)',
    'LOGIN_LOGO_ERROR' => 'SugarCRMのロゴを交換してください。',
    'FATAL_LICENSE_ALTERED' => 'あなたのライセンスは前回認証した時から変更されています。',
    'ERROR_FULLY_EXPIRED' => "会社のSugarCRMライセンスは期限切れになって7日以上となりアップデートが必要です。管理者のみログインできます。",
    'ERROR_LICENSE_EXPIRED' => "会社のSugarCRMライセンスはアップデートが必要です。管理者のみログインできます。",
    'WARN_LICENSE_EXPIRED' => "会社のSugarCRMライセンスはもうすぐ期限切れとなります。",
    'ERROR_LICENSE_VALIDATION' => "会社のSugarCRMライセンスは認証が必要です。管理者のみログイン可能です。",
    'WARN_LICENSE_VALIDATION' => "会社のSugarCRMライセンスはもうすぐ認証が必要になります。",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '警告：ブラウザのIEコンパチビリティビューはサポートされていません。',
    'WARN_LICENSE_SEATS' => '警告：アクティブユーザーが既にライセンスの上限に達しています。',
    'WARN_LICENSE_SEATS_MAXED' => '警告：アクティブユーザーがライセンスの許可される数を超えています。',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'アクティブユーザー数がライセンスの上限数を超えています。管理者にお問い合わせください。',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => '管理者のみログインできます。',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'ユーザーライセンス数が上限に達しています。既存のユーザーだけがログインできます。',
    'WARN_ONLY_ADMINS' => '管理者のみログインできます。',
    'WARN_UNSAVED_CHANGES' => 'このレコードに行った変更を保存せずにレコードから離れようとしています。本当にこのレコードから離れてよいですか？',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'ブラウザを更新すると、開いているすべてのSugarLive通話またはチャットセッションが自動的に閉じられ、保存されていない変更はすべて失われます。 続行しますか？',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => '保存されていない変更があります。本当にこのページを離れて変更を破棄しますか？',
    'LBL_MFA_RESET_CONFIRMATION' => '<a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">多要素認証</a>をリセットしてもよろしいですか？ 
このアクションを実行するとすぐにログアウトされ、次回ログイン時に認証アプリを使用して認証する必要があります。',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => '確認してログアウトする',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => '1つ以上のダッシュレットの変更が保存されていません。引き出しを閉じてもよいですか？',
    'LBL_NAVIGATE_TO_REPORTS' => 'レポートモジュールを動かしています。ダッシュレットへの変更は保存されません。続けますか？',
    'ERROR_NO_RECORD' => 'エラー　レコードを受信しています。レコードは削除されるか、閲覧する権限が無くなります。',
    'ERROR_TYPE_NOT_VALID' => 'エラー。このタイプは有効ではありません。',
    'ERROR_MAX_FIELD_LENGTH' => 'エラー。このフィールドの最長は{{this}}です。',
    'ERROR_MIN_FIELD_LENGTH' => 'エラー。このフィールドの最短は{{this}}です。',
    'ERROR_EMAIL' => 'エラー。無効なEメールアドレス： {{#each this}}{{{this}}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'エラー。少なくとも1つの主となるアドレスを設定してください。',
    'ERROR_DUPLICATE_EMAIL' => 'エラー。Eメールアドレスの重複：{{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'エラー。このフィールドは必須です。',
    'ERROR_MINVALUE' => 'エラー。このフィールドの最少の値は{{this}}です。',
    'ERROR_MAXVALUE' => 'エラー。このフィールドの最大の値は{{this}}です。',
    'ERROR_IS_GREATER_THAN' => 'エラー。このフィールドの値は{{this}}より大きくなければならない。',
    'ERROR_IS_LESS_THAN' => 'エラー。このフィールドの値は{{this}}より小さくなければならない。',
    'ERROR_DATETIME' => 'エラー。このフィールドは有効な日付が必須です。',
    'ERROR_IS_BEFORE' => 'エラー。このフィールドの日付は{{this}}より後でなければならない。',
    'ERROR_IS_AFTER' => 'エラー。このフィールドの日付は{{this}}より前でなければならない。',
    'ERROR_TIME_IS_BEFORE' => 'エラー。このフィールドの時刻は、{{this}} フィールドの時刻より前でなければなりません。',
    'ERROR_TIME_IS_AFTER' => 'エラー。このフィールドの時刻は、{{this}} フィールドの時刻より後でなければなりません。',
    'ERROR_NUMBER' => 'エラー。このフィールドには有効な数字が必須です。',
    'ERROR_INT' => 'エラー。無効な整数。',
    'ERROR_URL' => 'エラー。無効な URL です',
    'ERROR_NO_BEAN' => 'beanを得るのに失敗',
    'ERROR_ACCESS_MODULE' => 'このモジュールへのアクセスがありません。',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'エラー。添付が大きすぎます。',
    'ERROR_UPLOAD_FAILED' => 'エラー。ファイルのアップロードに失敗。',
    'ERROR_UPLOAD_ACCESS_PD' => 'このモジュールの [プロセス定義] を作成する権限がありません。',
    'ERROR_UPLOAD_ACCESS_BR' => 'このモジュールの [ビジネス ルール] を作成する権限がありません。',
    'ERROR_UPLOAD_ACCESS_ET' => 'このモジュールの [Eメール テンプレート] を作成する権限がありません。',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'エラーです。サポートされていない演算子が入力されました。',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'エラーです。無効な演算子が入力されました。',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'エラーです。無効なフィルターを入力します。',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'インポートが失敗しました。プロセス定義でグループフィールドが部分的にロックされています。' .
        ' プロセス定義でこれらのフィールドのロックが解除されないと、定義がインポートできません。',
    'ERROR_EXP_DATE_LOW' => 'エラー。有効期限は公開日より前に設定できません。',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'エラーです。承認ステータスには、発行年月日が必要です。',
    'ERROR_ACTIVE_DATE_EMPTY' => '発行日が空です。',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => '重複を探す',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => '重複チェックは、{{module}} では無効です。',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'サブスクリプションの管理',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'サブスクリプションの管理',
    'LBL_SUBSCRIBE' => 'サブスクライブ',
    'LBL_UNSUBSCRIBE' => 'サブスクライブしない',
    'LBL_CREATE_LINK_RECORD' => '作成してレコードをリンクする',
    'LBL_CREATE_LINK_BUTTON_LABEL' => '作成してレコードをリンクする',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}}レコードがリンクされました。',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'リンクするレコードがありません。',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => '選択されたレポートは正しいモジュールタイプに基づいていません。',
    'ERROR_EMPTY_LINK_MODULE' => '関連付けを先に選択してください。',
    // Ajax status strings
    'LBL_LOADING' => '読み込み中...',
    'LBL_LOADING_NO_DOTS' => '読み込み中',
    'LBL_SEARCHING' => '検索中...',
    'LBL_SEARCH_UNDERWAY' => '検索',
    'LBL_SAVING_LAYOUT' => 'レイアウトを保存中...',
    'LBL_SAVED_LAYOUT' => 'レイアウトは保存されました。',
    'LBL_SAVED' => '保存済み',
    'LBL_SAVING' => '保存中',
    'LBL_FAILED' => '失敗',
    'LBL_DISPLAY_COLUMNS' => '表示カラム',
    'LBL_HIDE_COLUMNS' => '非表示カラム',
    'LBL_SEARCH_CRITERIA' => '条件を検索',
    'LBL_SAVED_VIEWS' => '保存された表示',
    'LBL_PROCESSING_REQUEST' => '処理中。',
    'LBL_REQUEST_PROCESSED' => '完了',
    'LBL_AJAX_FAILURE' => 'Ajax不良',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => '検索',
    'LBL_SAVED_SEARCH_SHORTCUT' => '保存された検索',
    'LBL_SEARCH_POPULATE_ONLY' => '上記の検索フォームを使用した検索を実行する',
    'LBL_SEARCH_NO_RESULTS' => '以下に対する結果がありません。',
    'LBL_SEARCH_FOR' => '検索',
    'LBL_SEARCH_FOR_MORE' => '更に検索。',
    'LBL_SEARCH_SELECT' => '選択',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => '検索して選択...',
    'LBL_SEARCH_SELECT_MODULE' => '{{module}}を選択...',
    'LBL_DETAILVIEW' => '詳細画面',
    'LBL_LISTVIEW' => '一覧ビュー',
    'LBL_EDITVIEW' => '編集ビュー',
    'LBL_SEARCHFORM' => '検索フォーム',
    'LBL_SAVED_SEARCH_ERROR' => 'このビューの名前を指定してください。',
    'LBL_DISPLAY_LOG' => 'ログを表示',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => '場所：',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => '種類',
    'MSG_JS_ALERT_MTG_REMINDER_START' => '開始中',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'OKをクリックしてこのコールを見るか、キャンセルをクリックしてこのメッセージを無視する。',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'OKをクリックしてこの会議を見るか、キャンセルをクリックしてこのメッセージを無視する。',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => '結果がありません。',
    'MSG_LIST_VIEW_NO_RESULTS' => '以下に関する結果がありません',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => '新規として作成',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => '現在保存されている<item1> レコードはありません。<item2> または <item3> しましょう。',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => '保存された <item1> レコードはありません。<item2>しましょう。',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'リストから作成できます。',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => '肯定的',
    'LBL_SENTIMENT_NEUTRAL' => '中立',
    'LBL_SENTIMENT_NEGATIVE' => '否定的',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'メトリックタブが設定されていません',
    'LBL_NO_METRIC_VISIBLE' => 'メトリックタブが表示されていません',
    'LBL_MAKE_METRIC_VISIBLE' => '[整理] を選択すると、メトリックタブが表示されます',
    'LBL_PLEASE_CONTACT_ADMIN' => '管理者にお問い合わせください',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'ここをクリック',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'お気に入りに追加',
    'LBL_MARK_AS_FAVORITES' => 'お気に入りにマーク',
    'LBL_CREATE_CONTACT' => '取引先担当者作成',
    'LBL_CREATE_NOTE' => 'メモ作成',
    'LBL_CREATE_OPPORTUNITY' => '商談作成',
    'LBL_SCHEDULE_CALL' => '電話を記録',
    'LBL_SCHEDULE_CALL2' => '電話',
    'LBL_SCHEDULE_MEETING' => '会議作成',
    'LBL_SCHEDULE_MEETING2' => '会議',
    'LBL_CREATE_MESSAGE' => 'メッセージを作成',
    'LBL_CREATE_MESSAGE2' => 'メッセージ',
    'LBL_CREATE_TASK' => 'タスク作成',
    'LBL_CREATE_TASK2' => 'タスク',
    'LBL_REMOVE_FROM_FAVORITES' => 'お気に入りからはずす',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'メモ',
    'LBL_DOWNLOAD_ALL' => 'すべてダウンロード',
    'LBL_DOWNLOAD_ONE' => 'ダウンロード',
    'LBL_ATTACHMENTS' => '添付ファイル',
    'LBL_ADD_ATTACHMENT' => '表示',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => '作成元',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Web To Leadフォームを保存する',

    'LBL_PLEASE_SELECT' => '選択してください',
    'LBL_REDIRECT_URL' => 'リダイレクトURL:',
    'LBL_RELATED_CAMPAIGN' => '関連キャンペーン:',
    'LBL_ADD_ALL_LEAD_FIELDS' => '全フィールドの追加',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => '全てのフィールドを削除する',
    'LBL_ONLY_IMAGE_ATTACHMENT' => '以下のサポートされた画像タイプの添付のみ埋め込み可能です：JPG, PNG.',
    'LBL_REMOVE' => '削除',
    'LBL_TRAINING' => 'サポート',
    'ERR_DATABASE_CONN_DROPPED' => 'クエリ実行のエラー。データベースの接続が落ちた可能性があります。ページをリフレッシュし、ウェブサーバーを再起動する必要があるかもしれません。',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'エラー 設定 {0} 関連 : {1}',
    'ERR_MSSQL_DB_CONTEXT' => '変更されたデータベースコンテキスト',
    'ERR_MSSQL_WARNING' => '警告：',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'vCardフォーマットを分類するのに失敗しました',
    'ERR_VCARD_FILE_MISSING' => 'vcfファイルが見つかりません',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => '危険：[[field]]フィールドは[moduleDir] vardefs.phpファイルのマッピングされた入力がありません',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'エラー：[[file]]ファイルは見つかりません。対応するHTMLファイルが見つからないため作成できません。',
    'ERR_CANNOT_FIND_MODULE' => 'エラー：モジュール[module]は存在しません。',
    'LBL_ALT_ADDRESS' => '別の住所',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'エラー： displayParams配列内の&#39;key&#39; and &#39;copy&#39;要素の引数が等しくありません。',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'displayParams配列のインデックスがありません。',

    'LBL_DASHLET' => 'ダッシュレット',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'フィルタ',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => '私のアイテムのみ',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'タイトル',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => '列の表示',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => '現在のレコードに関連付けする',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'リンクされたフィールド',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => '最初のカラムを固定',

    'LBL_REMOVE_DASHLET_CONFIRM' => '本当にSugarダッシュレットをはずしてよいですか？',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => '列を本当に削除しますか？',
    'LBL_MAXIMUM_OF' => '最大の',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => '表示できるカラム',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'ダッシュボード',
    'LBL_DEFAULT_DASHBOARD_TITLE' => '私のダッシュボード',
    'LBL_COLLAPSE_ALL' => 'すべて閉じる',
    'LBL_EXPAND_ALL' => 'すべて表示',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => '編集',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'レポートを表示',
    'LBL_DASHLET_REFRESH_LABEL' => '更新',
    'LBL_DASHLET_REMOVE_LABEL' => '削除',
    'LBL_DASHLET_DROP_HERE' => 'ここにドロップ',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => '閉じる',
    'LBL_DASHLET_MAXIMIZE' => '開く',
    'LBL_DASHLET_CONFIGURE' => '設定する',
    'LBL_DASHLET_TOGGLE' => '開く/閉じる',
    'LBL_SIDEPANE_TOGGLE' => 'サイドペインを開く/閉じる',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'デフォルトのダッシュレットに戻す',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'ダッシュボードは設定されていません',
    'LBL_CREATE_DASHBOARD_LINK' => 'ダッシュボードの作成',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'ヘルプ',
    'LBL_HELPLET_TOGGLE' => '開く/閉じる',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'モジュール',
    'LBL_FACET_MODIFIED_BY_ME' => '私が修正',
    'LBL_FACET_CREATED_BY_ME' => '私が作成',
    'LBL_FACET_MY_FAVORITES' => 'お気に入り',
    'LBL_FACET_ASSIGNED_TO_ME' => '私にアサイン',
    'LBL_FACET_NO_DATA' => 'このファセットのデータがありません。',

    'LBL_DASHLET_LISTVIEW_NAME' => '一覧ビュー',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => '指定の条件に合致する、モジュールレコードの一覧を表示する',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'コンソールリストの表示',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'コンソールに表示しているレコードに関連する特定のモジュールのレコードを一覧表示します。',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => '記録ビュー',
    'LBL_RELATED_RECORDS' => '関連する{{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'タブに記録を表示するほか、オプションで関連する記録も表示します。',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'ベース記録タイプ',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'この {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'タブ',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => '基本レイアウトのプレビュー',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => '警告、タブには {{numWord}} ({{num}}) モジュールのみ表示できます。' .
        '他のモジュールを追加する前に、1つ以上のモジュールを削除してください。',
    'LBL_SIX' => '6', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'コメントログ',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => '記録のコメントを表示',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => '閲覧可能なコメントなし',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => '追加',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'コメントを追加',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'すべて表示',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'データがありません。これらのモジュールにアクセスする権限がありません。' .
    " \nこのダッシュレットを更新または削除してください。",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => '私の {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => '表示対象の記録はありません',
    'LBL_CONTENT_SEARCH_DASHLET' => 'ダッシュレットのコンテンツ検索',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => '{{username}} さん、今日はどのようなご用件ですか？',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'ケースを作成しますか？',

    'LBL_DASHLET_OPPORTUNITY_NAME' => '商談メトリックス',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => '関連アカウントの商談メトリックス。',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => '製品カタログ クイックピック',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => '最近使用した項目やお気に入りに保存した製品を表示',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => '最近使用したもの',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'お気に入り',

    'LBL_DASHBOARD_CREATE' => 'ダッシュボードを作成',
    'LBL_DASHBOARD_DUPLICATE' => 'ダッシュボードを複製',
    'LBL_DASHBOARD_DELETE' => 'ダッシュボードを削除',
    'LBL_PIN_TO_TOP' => 'トップに固定',
    'LBL_PIN_TO_BOTTOM' => '一番下に固定',
    'LBL_MANAGE_DASHBOARDS' => 'ダッシュボードを管理',

    'LBL_DASHBOARD_CONFIG' => 'ダッシュボード設定',
    'LBL_LIST_VIEW__NAME' => 'リストビュー',
    'LBL_PIPELINE_VIEW_NAME' => 'タイルビュー',
    'LBL_PIPELINE_VIEW_BTN' => 'タイルビュー',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{fieldName}} ごとの {{module}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'タイルビューが有効ではありません',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => '今回はレコードは見つかりませんでした。',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'ケースサマリー',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'タイムライン',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'ノート＆添付ファイル',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'レコードに属するメモと添付',
    'LBL_DASHLET_PIPLINE_NAME' => 'パイプライン',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => '最近のツイート-@{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => '保存されたダッシュボードはありません',

    'LBL_DNB_AND' => 'と',
    'LBL_DNB_PRIM_NAME_DESC' => '組織の名前のテキスト',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => '返信',
    'LBL_TWITTER_RETWEET' => 'リツイート',
    'LBL_TWITTER_FAVORITE' => 'お気に入り',
    'LBL_TWITTER_FOLLOW' => 'フォロー',
    'LBL_TWITTER_DESCRIPTION' => '該当のTwitterユーザのツイート、リツイート、ツイートへのリプライを見る',
    'LBL_TWITTER_ID' => 'Twitter ID',
    'LBL_TWITTER_DISPLAY_ROWS' => '列の表示',
    'LBL_TWITTER_MY_ACCOUNT' => 'マイアカウント',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'ソースツイート',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => '学習リソース',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'トレーニングと認定',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub コミュニティ',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'ドキュメントとサービス',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters マーケットプレイス',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => '国別売上',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => '国の地図ごとに営業チャートを表示する',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'ナレッジベースカテゴリーおよび公開記事',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'ナレッジベースのカテゴリーおよび公開記事のツリービューを表示',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'ナレッジベース検索',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => '公開されたナレッジベースの記事とカテゴリの検索可能なツリービューを表示します。',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => '他の言語での公開記事',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => '最も有用な公開ナレッジベース記事',
    'LBL_DASHLET_MOST_USEFUL_DESC' => '最も反響の多い公開ナレッジベース記事を表示する',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} は {{label}} "{{value}}" でフィルタリングされました',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => '記事の有用性',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'ページを追加',
    'LBL_LOADING_PAGE' => 'ページをロード中、お待ちください。',
    'LBL_SEARCH_RESULTS' => '検索結果',
    'LBL_SEARCH_RESULTS_FOR' => '次の検索結果: ',
    'LBL_SEARCH_HELP_TITLE' => '検索のコツ',
    'LBL_SEARCH_RESULTS_FOUND' => '検索結果があります',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => '私のパイプライン',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "チームのパイプライン",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => '営業のパイプラインチャート',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => '現在のパイプラインチャートを表示します。',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => '画像がありません',

    'LBL_MODULE' => 'モジュール',
    'LBL_RELATIONSHIP' => '関連',
    'LBL_SINGULAR_LABEL' => '単数形ラベル',
    'LBL_PLURAL_LABEL' => '複数形ラベル',
    'LBL_MODULE_DISPLAY' => '表示',
    'LBL_MODULE_DISPLAY_TYPE' => '表示タイプ',
    'LBL_MODULE_ICON' => 'アイコン',
    'LBL_MODULE_COLOR' => 'モジュールの背景色',
    'LBL_LANGUAGE_SELECTOR' => '言語',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'モジュール設定',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'モジュール設定が保存されました。',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => '左からアドレスをコピーしてください',
    'LBL_SAVE_AND_CONTINUE' => '保存して継続',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>複数選択制御</strong></p><ul><li>値をクリックして属性を選択します。</li><li>Ctrlを押しながらクリック&nbsp;して&nbsp;複数選択します。マックユーザーは CMD-クリックを使用してください。</li><li>2つの属性間ですべての値を選択するには、&nbsp; 最初の値をクリックして&nbsp;最後の値をShiftを押しながらクリックします。</li></ul><p><strong>詳細検索＆レイアウト オプション</strong><br><br><b>保存済検索＆レイアウト</b>オプションを使用すると、今後素早く必要な検索結果を取得できるように検索パラメーターおよび/またはカスタマイズしたリスト表示レイアウトを保存できます。カスタマイズされた検索およびレイアウトはいくつでも保存できます。すべての保存済検索はその名前が、最後に読み込まれた保存済検索が一番上になって保存済検索リストに表示されます。<br><br>リスト表示レイアウトをカスタマイズするには、列を表示および列を非表示ボックスを使用して検索結果にどのフィールドを表示するか選択します。例えば、検索結果でレコード名、割当ユーザー、割当チームを表示／非表示にできます。リスト表示に列を追加するには、非表示列リストから列を選択して左向き矢印を使って表示列リストに移動します。リスト表示から列を削除するには、表示列リストから列を選択して右向き矢印を使って非表示列リストに移動します。<br><br>レイアウト設定を保存すると、検索および/またはレイアウトを更新するためにいつでも読み込むことができます。<br><br>検索および/またはレイアウトを保存して更新するには次を行います。<ol><li><b>この検索を名前を付けて保存</b>フィールドに検索結果の名前を入力して<b>保存</b>をクリックします。これで、<b>クリア</b>ボタンの隣の保存済み検索リストに名前が表示されます。</li><li>保存済検索を表示するには、保存済み検索リストから選択します。検索結果がリスト表示に表示されます。</li><li>保存済検索のプロパティを更新するには、リストから保存済検索を選択し、新しい検索条件および/またはレイアウトオプションを詳細検索エリアに入力して、<b>現在の検索を修正</b>の横の<b>更新</b>をクリックします。</li><li>保存済検索を削除するには、保存済検索リストから選択して、<b>現在の検索を修正</b>の横の<b>削除</b>をクリックした後に<b>OK</b>をクリックして削除を確定します。</li></ol><p><strong>ヒント</strong><br><br>% をワイルドカード演算子として使用することで、検索をより幅広くすることができます。例えば、"Apples"と等しい対象を検索するのではなく、検索条件を"Apples%"に変えれば"Apples"で始まり他の文字も含むすべての結果に一致させることができます。</p>',

    //resource management
    'ERR_QUERY_LIMIT' => 'エラー: $module モジュールでクエリの限界 $limit に達しました。',
    'ERROR_NOTIFY_OVERRIDE' => 'エラー：リソースオブザーバー->notify() は優先される必要がある。',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'エラー：メタデータファイルが空であるか、ファイルが存在しないため、モニタを作成することができません。',
    'ERR_MONITOR_NOT_CONFIGURED' => 'エラー：要求された名前のために設定されたモニタはありません',
    'ERR_UNDEFINED_METRIC' => 'エラー：未定義のメトリック値を設定することができません',
    'ERR_STORE_FILE_MISSING' => 'エラー：ストア実装ファイルが見つかりません',

    'LBL_MONITOR_ID' => 'モニターID',
    'LBL_TEAM_ID' => 'チームID',
    'LBL_SELECT_MODULE' => 'モジュールの選択：',
    'LBL_USER_ID' => 'ユーザID',
    'LBL_MODULE_NAME' => 'モジュール名',
    'LBL_MODULE_ALL' => 'すべて',
    'LBL_ITEM_ID' => 'アイテムID',
    'LBL_ITEM_SUMMARY' => 'アイテムサマリー',
    'LBL_ACTION' => 'アクション',
    'LBL_SESSION_ID' => 'セッションID',
    'LBL_BREADCRUMBSTACK_CREATED' => 'BreadCrumbStack ユーザーid {0}に作成されました',
    'LBL_VISIBLE' => '見えるレコード',
    'LBL_DATE_LAST_ACTION' => '最後のアクション日',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQLテスト',
    'LBL_QUERY_HASH' => 'SQLハッシュ',
    'LBL_SEC_TOTAL' => '総秒数',
    'LBL_SEC_AVG' => '平均秒数',
    'LBL_RUN_COUNT' => 'クエリカウント',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'クライアントIPアドレス',
    'LBL_DATE_START' => '開始日',
    'LBL_ACTIVE' => 'セッションアクティブ',
    'LBL_ROUNDTRIPS' => 'アクションカウント',
    'LBL_SECONDS' => 'アクティブな秒',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'データベース·ラウンドトリップ',
    'LBL_FILES_OPENED' => 'アクセスされたファイル',
    'LBL_MEMORY_USAGE' => 'メモリ容量（バイト）',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'ツイッターコネクターをロード中',
    'LBL_TWITTER_DATA_EMPTY' => 'ツイッターからのデータがありません',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'アウトルック用Sugarプラグイン',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Sugar EメールとMicrosoft Outlookの予定表の情報を統合します。',
    'LBL_PLUGIN_WORD_NAME' => 'ワード用Sugarプラグイン',
    'LBL_PLUGIN_WORD_DESC' => '自動的にフォームレター、ダイレクトメールやその他のMicrosoftのドキュメントにSugarCRMのから情報を読み込む',
    'LBL_PLUGIN_EXCEL_NAME' => 'エクセル用Sugarプラグイン',
    'LBL_PLUGIN_EXCEL_DESC' => 'キーメトリクッスのよりよい分析のためにSugarとスプレッドシートを統合します。',
    'LBL_PLUGINS_TITLE' => 'Microsoft Office 用 Sugar プラグイン<sup>TM</sup>',
    'LBL_PLUGINS_DESC' => 'プラグイン機能について読む<a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">プラグインドキュメンテーション</a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'ロータスノーツ用Sugarプラグイン',
    'LBL_PLUGIN_LOTUS_NAME' => 'Lotus Notes 用 Sugar プラグイン',
    'LBL_PLUGIN_LOTUS_DESC' => 'Sugarをロータスノーツを統合する',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => '前ではない',
    'MSG_IS_MORE_THAN' => 'は以下より多い',
    'MSG_IS_LESS_THAN' => 'は次より小さい',
    'MSG_SHOULD_BE' => 'であるはず',
    'MSG_OR_GREATER' => 'もしくは大きい',
    'MSG_EXCEEDS_MAXLEN' => '指定最大長を超えています ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Sugarポータル5.1.0へようこそ',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar ポータルは事例、バグ＆ニュースレターなどを顧客にリアルタイム表示で提供するフレームワークです。これは Sugar への外向きインターフェイスであり、任意の web サイト内に展開することができます。 今後のリリースでのプロジェクト管理およびフォーラムのような顧客セルフサービス機能にご期待ください。',
    'LBL_LIST' => 'リスト',
    'LBL_CREATE_CASE' => 'ケース作成',
    'LBL_CREATE_BUG' => '不具合作成',
    'LBL_NO_RECORDS_FOUND' => '-レコードが見つかりませんでした-',

    'DATA_TYPE_DUE' => '期限',
    'DATA_TYPE_START' => '開始：',
    'DATA_TYPE_SENT' => '送付済',
    'DATA_TYPE_MODIFIED' => '修正：',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => '計算',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => '対象画像',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => '日付を選択',

    'LBL_VALIDATE_RANGE' => 'は有効な範囲内ではありません',
    'LBL_VALIDATE_URL' => 'は有効な URL ではありません。',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'すべて',

    'LBL_OPERATOR_IN_TEXT' => 'は以下のうちの一つです',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'は以下のうちの一つではありません',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'エラー：Beanパラメータの配列数は、結果の配列数と一致しません。',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'エラー：モジュールのマッピングエントリがありません。',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'エラー：{0} コネクターのデータを取得できません。このサービスは現在アクセス不能もしくは構成設定が無効の可能性があります。コネクタのエラーメッセージ：（{1}）。',
    'ERROR_CONNECTOR_CONFIGURE' => 'データを取得できません。このサービスは現在アクセス不能もしくは構成設定が無効の可能性があります。',
    'LBL_CONNECT_TWITTER' => 'ツイッターに接続',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'ツイッターIDの有効なタイムラインが見つかりません。',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'ツイッターコネクターを設定',
    'LBL_CONNECT_TEST_FAIL' => 'エラー：コネクターの構成設定が無効である可能性があります。管理者に連絡してください。',
    'LBL_CONFIGURE_TWITTER' => 'ツイッターを設定するために管理者に連絡してください',
    'LBL_MERGE_CONNECTORS' => 'データを取得',
    'LBL_NO_DATA_AVAILABLE' => 'データがありません',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'このモジュールのコネクター統合を本当に無効にしますか？',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Elasticのサーバーに接続失敗しました',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'グローバルグループは削除できません。',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'このプライベートチーム[{0}]は、ユーザー[{1}]は削除されるまで削除することはできません。',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'Abobe Flashがオフになっているか、Adobe Flash Playerの古いバージョンを使用しています。 Flash Playerの最新バージョンを取得するには、してください。 <a href="http://www.adobe.com/go/getflashplayer/">ここをクリック</a>してください。',
    //Collection Field
    'LBL_COLLECTION_NAME' => '名前',
    'LBL_COLLECTION_PRIMARY' => '主',
    'ERROR_MISSING_COLLECTION_SELECTION' => '必須フィールドが空白',
    'LBL_COLLECTION_EXACT' => '正確に',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'IIS/FastCGI SAPIを適切に使用するためには、php.iniファイルで fastcgi.logging を 0 に設定してください。',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'アサイン先',
    'LBL_DESCRIPTION' => '詳細',
    'LBL_PRIMARY_CONTACT_NAME' => '主な連絡窓口',
    'LBL_PRIMARY_CONTACT_ID' => '主な連絡窓口のID',

    'LBL_NONE' => '-なし-',
    'LBL_YESTERDAY' => '昨日',
    'LBL_TODAY' => '今日',
    'LBL_TOMORROW' => '翌日',
    'LBL_NEXT_WEEK' => '来週',
    'LBL_NEXT_MONDAY' => '来週月曜日',
    'LBL_NEXT_FRIDAY' => '来週金曜日',
    'LBL_TWO_WEEKS' => '2週間',
    'LBL_NEXT_MONTH' => '翌月',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => '翌月1日',
    'LBL_THREE_MONTHS' => '3か月',
    'LBL_SIXMONTHS' => '6か月',
    'LBL_NEXT_YEAR' => '翌年',
    'LBL_FILTERED' => 'フィルタされた',

    //Datetimecombo fields
    'LBL_HOURS' => '時間',
    'LBL_MINUTES' => '分',
    'LBL_MERIDIEM' => 'Meridiem',
    'LBL_DATE' => '日付',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => '自動更新',

    'LBL_DURATION_DAY' => '曜日',
    'LBL_DURATION_HOUR' => '時',
    'LBL_DURATION_MINUTE' => '分',
    'LBL_DURATION_DAYS' => '日',
    'LBL_DURATION_HOURS' => '時間',
    'LBL_DURATION_MINUTES' => '分',
    'LBL_DURATION_SECONDS' => '秒',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => '月を選択',
    'LBL_ENTER_YEAR' => '年を入力',
    'LBL_ENTER_VALID_YEAR' => '有効な年を入力してください',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => '市外局番を含む数値の米国の電話番号を入力してください。',
    'LBL_CCP_NOT_INITIATED' => 'エージェントの非ログイン中に CCP を使用したダイアルが試行されました。',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'CCP を介して通話を開始できませんでした。',
    'LBL_CCP_DIALING_ERROR' => 'この通話をダイヤル済みとして完了することはできません。',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => '発信コールを行う前に、SugarLiveのチャットセッションをすべて閉じてください。',

    //File write error label
    'ERR_FILE_WRITE' => 'エラー：{0}ファイルを書き込めませんでした。システムとWebサーバのアクセス権を確認してください。',
    'ERR_FILE_NOT_FOUND' => 'エラー：ファイル{0}を書き込めませんでした。システムとWebサーバのアクセス権を確認してください。',

    'LBL_AND' => 'と',
    'LBL_BEFORE' => '以前',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'コンピューターからアップデート',
    'LBL_SEARCH_EXTERNAL_API' => '外部ソースからのファイル',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => '外部ソースへのアップロード',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => '外部ソースからのリンク',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'セキュリティ',
    'LBL_SHARE_PRIVATE' => 'プライベート',
    'LBL_SHARE_COMPANY' => '会社',
    'LBL_SHARE_LINKABLE' => 'リンク可能',
    'LBL_SHARE_PUBLIC' => 'パブリック',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSSフィード',
    'LBL_RSS_RECORDS_FOUND' => 'レコードが見つかりました',
    'ERR_RSS_INVALID_INPUT' => 'RSSは有効なinput_typeではありません',
    'ERR_RSS_INVALID_RESPONSE' => 'RSSはこの方法に対して有効なresponse_typeではありません',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs は提供されたファイルフォーマットをサポートしていません',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => '空白',
    'LBL_IS_EMPTY' => '空である',
    'LBL_IS_NOT_EMPTY' => '空でない',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '
"これは、インポートできる状態のファイルに想定される内容の一例を示すインポートファイルのサンプルです。"
"このファイルはカンマ区切りでフィールド修飾子が二重引用符の .csv ファイルになっています。"

"ヘッダー行がファイルの一番上の行で、アプリケーションに表示されるフィールドのラベルを含みます。"
"これらのラベルはファイルのデータをアプリケーションのフィールドにマッピングするために使用されます。"

"注：ヘッダー行にはデータベース名も使用できます。これは、phpMyAdmin または他のデータベースツールをインポート対象データの出力リストを提供するために使用しているときに有用です。"
"インポート処理がヘッダー行に基づきデータを適切なフィールドに一致させるため、列の並び順は重要ではありません。"


"ファイルをテンプレートとして使うには、以下を行います。"
"1. データのサンプル行を削除します"
"2. 今読んでいるヘルプテキストを削除します"
"3. 適切な行および列に自分のデータを入力します"
"4. システムの既知の場所にファイルを保存します"
"5. アプリケーションでアクションメニューのインポートオプションをクリックしてアップロードするファイルを選択します"   ',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'アサイン先ID',
    'LBL_EXPORT_CREATED_BY' => '作成者ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => '更新者ID',
    'LBL_EXPORT_REPORTS_TO_ID' => '上司ID',
    'LBL_EXPORT_TEAM_ID' => 'チームID',
    'LBL_EXPORT_TEAM_SET_ID' => 'チームセットID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'アサインされたユーザー',
    'LBL_EXPORT_FULL_NAME' => 'フルネーム',
    'LBL_EXPORT_TEAM_NAME' => 'チーム',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'ナビゲート中',

    'LBL_PENDING_NOTIFICATIONS' => '通知',
    'LBL_ALT_ADD_TEAM_ROW' => '新しいチーム列を追加',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'チームを削除',
    'LBL_ALT_SPOT_SEARCH' => 'スポット検索',
    'LBL_ALT_NOT_SORTED' => '未ソート',
    'LBL_ALT_SORT_DESC' => '降順でソート',
    'LBL_ALT_SORT_ASC' => '昇順でソート',
    'LBL_ALT_SORTABLE' => 'ソート可能',
    'LBL_ALT_NOT_SORTABLE' => 'ソート不可',
    'LBL_ALT_SORT' => 'ソート',
    'LBL_ALT_SHOW_OPTIONS' => 'オプション表示',
    'LBL_ALT_HIDE_OPTIONS' => 'オプション非表示',
    'LBL_ALT_MOVE_COLUMN_LEFT' => '選択されたエントリを左のリストに移動',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => '選択されたエントリを右のリストに移動',
    'LBL_ALT_MOVE_COLUMN_UP' => '表示されたリストの順に選択したエントリを上に移動',
    'LBL_ALT_MOVE_COLUMN_DOWN' => '表示されたリストの順に選択したエントリを下に移動',
    'LBL_ALT_INFO' => '情報',
    'MSG_DUPLICATE' => '作成しようとしている{0}レコードは既に存在している{0}レコードと重複する可能性があります。{1}レコードは下記に挙げられているものと似た名前を含んでいます。作成をクリック{1}してこれを新しい{0}として作成するか、 存在する{0}を以下のリストから選択して下さい。',
    'MSG_SHOW_DUPLICATES' => '作成しようとしている{0}レコードは既に存在している{0}レコードと重複する可能性があります。{1}レコードは下記に挙げられているものと似た名前を含んでいます。保存をクリックしてこれを新しい{0}として作成するかキャンセルをクリックして{0}を作成せずにモジュールに戻ってください。',
    'LBL_EMAIL_TITLE' => 'Eメールアドレス',
    'LBL_EMAIL_OPT_TITLE' => 'オプトアウトのEメールアドレス',
    'LBL_EMAIL_INV_TITLE' => '無効なEメールアドレス',
    'LBL_EMAIL_PRIM_TITLE' => '主のEメールアドレス',
    'LBL_SELECT_ALL_TITLE' => '全てを選択',
    'LBL_SELECT_THIS_ROW_TITLE' => 'この行を選択',
    'LBL_TEAM_SELECTED_TITLE' => 'チームを選択',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'このチームを主に選択',
    'LBL_TEAM_TBSELECTED_TITLE' => '選択済みチームベースとしてマークされたチーム',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => '選択済みのチームベースとしてこのチームをマーク',
    'LBL_SEARCH_AND_SELECT' => '{{module}}を検索して選択',
    'TPL_SEARCH_AND_ADD' => '検索して {{module}} を追加',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'エラー：アップロード中にエラーがありました。エラーコード：{0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'エラー：アップロード中にエラーがありました。エラーコード：{0} - {1}。upload_maxsizeは{2}です',
    'UPLOAD_ERROR_HOME_TEXT' => 'エラー：アップロード中にエラーがありました。管理者に連絡してください。',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'アップロード（{0}バイト）のサイズが最大許容超過：{1}バイト',
    'UPLOAD_REQUEST_ERROR' => 'エラーが起こりました。ページを更新してもう一度行ってください。',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => '編集',
    'LBL_ADD_BUTTON_LABEL' => '追加',
    'LBL_EDIT_BUTTON_TITLE' => '編集',
    'LBL_REFRESH_BUTTON_LABEL' => '更新',
    'LBL_REFRESH_BUTTON_TITLE' => '更新',
    'LBL_DUPLICATE_BUTTON_KEY' => 'u',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'コピー',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'コピー',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'レポートスケジュール',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'レポートスケジュール',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'レポートの詳細',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'レポートの詳細',
    'LBL_DELETE_BUTTON_KEY' => 'd',
    'LBL_DELETE_BUTTON_LABEL' => '削除',
    'LBL_DELETE_BUTTON_TITLE' => '削除',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => '保存',
    'LBL_SAVE_BUTTON_TITLE' => '保存',
    'LBL_CANCEL_BUTTON_KEY' => 'l',
    'LBL_CANCEL_BUTTON_LABEL' => 'キャンセル',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'ストップする',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'ページにとどまる',
    'LBL_CANCEL_BUTTON_TITLE' => 'キャンセル',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'シェア',
    'LBL_SHARE_BUTTON_TITLE' => 'シェア',
    'LBL_START_BUTTON_LABEL' => '開始',
    'LBL_START_BUTTON_TITLE' => '開始',
    'LBL_FINISH_BUTTON_LABEL' => '完了',
    'LBL_FINISH_BUTTON_TITLE' => '完了',
    'LBL_CONFIRM_BUTTON_LABEL' => '確認',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => '継続する',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'ページを離れて変更を破棄する',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'キーボ－ドショートカット',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => 'フォームの機能 - Altキー+<br />I = 編集（detailview）<br />U =複製（detailview）<br />D =削除（detailview）<br />R=シェア（detailview）<br />A = 保存（editview）<br />L = キャンセル（editview）<br /><br />検索とナビゲーション - Altキー+<br />7= 編集フォーム上最初の入力<br />8= 高度な検索]リンク<br />9= 最初の検索フォームに入力<br />0= 統合検索入力',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'エスカレーションする',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'シェア',
    'TPL_RECORD_SHARE_SUBJECT' => '{{appId}}からシェアされた {{module}} {{name}}',
    'TPL_RECORD_SHARE_BODY' => '{{appId}}からの{{module}} {{name}}を確認してください',

    'ERR_CONNECTOR_NOT_ARRAY' => '{0}内のコネクタ配列が誤って定義されるか、または空であり、使用することができません。',
    'LBL_PDF_VIEW' => 'PDFをダウンロード',
    'LBL_PDF_EMAIL' => 'PDFをEメール送信',

    'ERR_SUHOSIN' => 'アップロードストリームはSuhosinによってブロックされています。「アップロード」をsuhosin.executor.include.whitelistへ追加してください（詳細についてはsugarcrm.logを参照してください）',

    //for sidecar
    'LBL_TIME_AGO_NOW' => '今',
    'LBL_TIME_AGO_SECONDS' => '1分以内',
    'LBL_TIME_AGO_MINUTE' => '約1分前',
    'LBL_TIME_AGO_MINUTES' => '{{this}}分前',
    'LBL_TIME_AGO_HOUR' => '約1時間前',
    'LBL_TIME_AGO_HOURS' => '{{this}}時間前',
    'LBL_TIME_AGO_DAY' => '昨日',
    'LBL_TIME_AGO_DAYS' => '{{this}} 日前',
    'LBL_TIME_AGO_YEAR' => '1年以上前',
    'LBL_TIME_UNTIL_SECONDS' => '1分以内',
    'LBL_TIME_UNTIL_MINUTE' => '約1分以内',
    'LBL_TIME_UNTIL_MINUTES' => '{{this}}分以内',
    'LBL_TIME_UNTIL_HOUR' => '約1時間以内',
    'LBL_TIME_UNTIL_HOURS' => '{{this}}時間以内',
    'LBL_TIME_UNTIL_DAY' => '翌日',
    'LBL_TIME_UNTIL_DAYS' => '{{this}}日内',
    'LBL_TIME_UNTIL_YEAR' => '1年以内',
    'LBL_TIME_RELATIVE' => '{{relativetime}} を {{date}} {{time}} に投稿しました',
    'LBL_LAST_TOUCHED' => '{{date}} {{time}}に最後に触った{{relativetime}}',
    'LBL_LAST_COMMIT' => '最終コミットメント: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'データがありません',
    'LBL_DETAILVIEW_NO_RECORDS' => 'このレコードは、この時点でレンダリングすることができませんでした。',
    'LBL_REFINE_LIST' => 'リストを更新',
    'LBL_SEARCH_BY' => '以下で検索',
    'LBL_PREVIEW' => 'プレビュー',
    'LBL_COLUMNS' => 'カラム',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'プレビューは無効：データがありません',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'プレビューは無効：アクセスするレコードがありません。',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'プレビューは無効：データがありません',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'プレビューは無効：現在のレコードで表示',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'プレビューは無効：レコードは削除されたかアクセスがありません',
    'LBL_PREVIEW_PREVIOUS' => '以前のものをプレビュー',
    'LBL_PREVIEW_NEXT' => '次をプレビュー',
    'LBL_PREVIEW_CLOSE' => 'プレビュー終了',
    'LBL_STREAM_NO_RECORDS' => 'このレコードには今メモがありません。メモを追加リンクをクリックしてメモを追加してください。',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} レコードの重複が見つかりました。',
    'LBL_NO_DUPLICATES_FOUND' => '重複が見つかりません。',
    'LBL_RESET_DEFAULT_VIEW' => 'デフォルトビューをリセット',
    'LBL_RESET_DEFAULT_WIDTHS' => 'デフォルトの幅をリセット',
    'LBL_TIMEZONE_UPDATED' => 'Sugarは、ブラウザのタイムゾーンと一致するようにユーザープロフィールのタイムゾーンを更新しました',
    'LBL_SUCCESS' => '成功',
    'LBL_ERROR' => 'エラー',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => '重複をマージする',
    'LBL_MERGE_DUPLICATES_PROCEED' => '実行しますか？中止する場合はキャンセル、レコードを削除する場合は確認をクリックしてください。',
    'LBL_MERGE_DUPLICATES_CONFIRM' => '以下のレコードが削除されます。',
    'LBL_MERGE' => 'マージ',
    'TPL_MERGING_RECORDS' => '{{mergeCount}}レコードをマージ中',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        '渡されたレコードの数が無効です。有効範囲は{{minRecords}}から{{MaxRecords}}まで。',
    'LBL_MERGE_NO_ACCESS' =>
        'このアクションを実行するためにアクセスすることができません。少なくとも一つのレコードが編集可能である必要があります。',
    'LBL_MERGE_LOCKED' => 'マージ対象として選択されたレコードの一部に、編集中のためプロセスによりロックされたフィールドが含まれているため、今回はマージできません。',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        '新しいプライマリ·レコードに切り替えるとすべての変更は破棄されます。本当に切り替えしますか？',
    'LBL_MERGE_DUPLICATES_TITLE' => '関連するレコードをマージする',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'マージ済み: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        '関連する{{objectName}}のマージに失敗。新規に試みます({{total}}中{{num}}回).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        '関連する{{objectName}}のマージに失敗。',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        '関連するレコードのマージは未完了です。いくつかのレコードがマージされていません。',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'いくつかの関連するレコードが適切にマージされませんでした。中止するにはキャンセルしてください。マージを続行するには確認してください。',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        '全ての関連するレコードが主のレコードに移動されます。',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        '本当にこのレコードをマージから削除しますか？',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'レコードをマージから削除',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => '無効なレコードの数が渡されました。有効な範囲は 1 から {{maxRecords}} 件のレコードです。',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'ユーザー名/パスワードの組み合わせが正しくありません。再度行ってください。',
    'LBL_INVALID_CREDS_TITLE' => '無効な認証',
    'LBL_INVALID_GRANT' => 'トークンが無効もしくは期限切れ。再度ログインしてください。',
    'LBL_INVALID_GRANT_TITLE' => 'トークンが期限切れ',
    'LBL_AUTH_FAILED' => 'クライアント認証に失敗しました。',
    'LBL_AUTH_FAILED_TITLE' => '無効なクライアント',
    'LBL_INVALID_REQUEST' => 'リクエストは無効または不正な形式である。テクニカルサポートに連絡してください。',
    'LBL_INVALID_REQUEST_TITLE' => '無効なリクエスト',
    'LBL_REQUEST_TIMEOUT' => 'サーバーからの応答がありません。インターネット接続を確認してください。',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'リクエストのタイムアウト：',
    'LBL_UNAUTHORIZED' => 'すみませんが、このリソースへのアクセスが許可されていないようです。',
    'LBL_UNAUTHORIZED_TITLE' => '権限がありません',
    'LBL_RESOURCE_UNAVAILABLE' => 'リソースはありません。',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => '禁止',
    'LBL_METHOD_NOT_ALLOWED' => 'このリソースにはHTTPメソッドは許可されていません。テクニカルサポートに連絡してください。',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'メソッドは許可されていません',
    'LBL_PRECONDITION_MISSING' => 'リクエスト失敗。もしくは失われた/無効なパラメータ。テクニカルサポートに連絡してください。',
    'LBL_PRECONDITION_MISSING_TITLE' => 'エラー：',
    'LBL_INVALID_412_RESPONSE' => 'リクエストはアプリケーションを使用不可能にします。テクニカルサポートに連絡してください。',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => '{1}モジュールでフィールド {0}を編集するのは許可されていません。',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'このレコードでアクション"{0}"を実行するのは許可されていません',
    'LBL_LOGIN_BUTTON_LABEL' => 'ログイン',
    'LBL_ACTIVITY_VIEW_TOUR' => 'アクティビティビューツアー',
    'LNK_TOUR' => 'ツアー',
    'LNK_MOBILE' => 'モバイル',
    'LBL_FEEDBACK' => 'フィードバック',
    'LBL_SUPPORT' => 'サポート',
    'LBL_LANGUAGE' => '言語',
    'LBL_LOADING_LANGUAGE' => '言語パックをロード中',
    'LBL_UPLOADING' => 'アップロード中',
    'LBL_UPLOADING_DOTS' => 'アップロード中...',
    'LBL_IMAGE_DELETE_CONFIRM' => '本当にこの画像を削除しますか？',
    'LBL_FILE_DELETE_CONFIRM' => '本当にこのファイルを削除しますか？これは取り消せません。',
    'LBL_FILE_DELETED' => 'ファイルの削除に成功しました。',

    //theme roller
    'LBL_PORTAL_THEME' => 'ポータルテーマ',
    'LBL_THEME_PREVIEW' => 'ポータルテーマのプレビュー',
    'LBL_LOADING_PREVIEW' => 'プレビューをロード中',
    'LBL_RESET' => 'リセット',
    'LBL_COLORS' => '色',
    'BorderColor' => '線の色',
    'NavigationBar' => 'ナビゲーションバー',
    'PrimaryButton' => '主ボタン',
    'LBL_SAVE_AND_DEPLOY_BTN' => '保存して配置',
    'LBL_RESET_THEME_LNK' => 'デフォルトテーマに戻す',
    'LBL_RESET_THEME_MODAL_INFO' => '本当にこのテーマのカスタマイズを破棄してデフォルトのテーマにしますか?',
    'LBL_RESET_THEME_PROCESS' => 'デフォルトのテーマを復元中。',
    'LBL_SAVE_THEME_PROCESS' => 'テーマを保存中',

    // image loader
    'LBL_SELECT_PHOTO' => '写真を保存',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Sugarの拡張された予定機能',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">予測パラメーターを設定します</li><li class="fa fa-check">予測売上およびパイプラインの健常性を簡単に追跡します</li><li class="fa fa-check">営業チームからの予測売り上げに基づき予測します</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => '売上予測のパラメータを設定する',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">年度開始日を選択します</li><li class="fa fa-check">期間を年間または四半期に設定します</li><li class="fa fa-check">ワークシート上で過去、未来の期間を何期分表示する必要があるかを設定します</li><li class="fa fa-check">Opportunities タグで予測範囲を含める、除外するまたはアップサイドに設定します</li><li class="fa fa-check">最も可能性の高い、ベストおよびワーストの予測を識別する予測シナリオを選択します</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => '営業チームの予定の営業成績を管理する',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">予測をレビューする期間を選択します</li><li class="fa fa-check">営業チーム メンバーのワークシートを見て、調整された予測を提供します</li><li class="fa fa-check"> 営業チームのメンバーが新しい予測をコミットしたときワークシートに警告メッセージが表示されます</li> <li class="fa fa-check"> 下書きバージョンとして予測ワークシートを保存するか、上司に予測を提出します</li><li class="fa fa-check">以前の提出の履歴を表示します</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => '営業チームの予定の営業成績を管理する',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">営業チームメンバー全員の予測にわたるパイプライン分析のパレート チャートを表示します</li><li class="fa fa-check">最も可能性の高い、ベストまたはワースト予測で予測売り上げを視覚化します</li><li class="fa fa-check">売上予測とチームのノルマを達成するまであとどれくらいかを表示します</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'あなたの予定の営業成績を管理する',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">予測の期間を選択します</li><li class="fa fa-check">what-if分析のために金額と勝率をレビューしてインラインで編集します</li><li class="fa fa-check">予測ワークシートを下書き版として保存するか、マネージャーに予測を提出します</li><li class="fa fa-check">以前の提出履歴を表示します</li><li class="fa fa-check">予測をマネージャーに提出して、以前の提出履歴を表示します</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'あなたのの予定の営業成績を管理する',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">Opportunities の時間経過とともにパイプライン分析パレート チャートを表示します</li><li class="fa fa-check">営業ステージまたは勝率のどちらでパイプライン分布を視覚化するか選びます</li><li class="fa fa-check">売上予測およびあなたに割り当てられたノルマ達成まであとどれくらいかを表示します。</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Sugarの新着情報',
    'LBL_TOUR_WATCH' => 'Sugarの新着情報を見る',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="fa fa-check">改善された外見と使用感 - 新しい近代的なテーマに。</li><li class="fa fa-check">強化された予算モジュール - 直感的なユーザーインターフェイスと新しいデータの可視化</li></ul>',
    'LBL_TOUR_VISIT' => '更なる情報に関してはアプリを訪問してください',
    'LBL_TOUR_DONE' => '完了',
    'LBL_TOUR_REFERENCE_1' => 'いつでも参照できます',
    'LBL_TOUR_REFERENCE_2' => 'プロファイルメニューの「サポート」リンクから',
    'LNK_TOUR_DOCUMENTATION' => 'ドキュメンテーション',
    'LBL_TOUR_CALENDAR_URL_1' => 'SugarCRMのカレンダーとMicrosoft OutlookやExchangeなどのサードパーティ製アプリケーションとを共有していますか？その場合は新しいURLがあります。この新しくより安全なURLは、カレンダーの不正発行を防ぐことができる個人的なキーが含まれています。',
    'LBL_TOUR_CALENDAR_URL_2' => '新しい共有カレンダーのURLを取得する',
    'LBL_TOUR_CUBE' => 'ダッシュボードとアクティブストリームにアクセス',
    'LBL_TOUR_NAV_BAR' => '各モジュールにアクセスできるナビゲーションメニュー',
    'LBL_TOUR_NOTIFICATIONS' => '重要な通知が表示され、クリックして確認できます。',
    'LBL_TOUR_SEARCH' => '複数のモジュールを一括で検索できます。',
    'LBL_TOUR_AVATAR' => 'プロフィールの変更やアプリについての詳細を取得するかログアウトする',
    'LBL_TOUR_ADD' => '新規にレコードを作成します。',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'クリックしてインテリジェンスペインを開閉する',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => '選択してアクティビティかレコードのリストを見る',
    'LBL_TOUR_LIST_FILTER1' => 'フィルタバーでこのモジュールを検索できる',
    'LBL_TOUR_LIST_FILTER2' => '定義済みのフィルタを選択するか、新規作成する',
    'LBL_TOUR_LIST_FILTER_SEARCH' => '入力して名前で検索する',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => '選択して行を編集するか詳細をプレビューする',
    'LBL_TOUR_RECORD_ACTIONS' => 'レコードに対してアクションする',
    'LBL_TOUR_RECORD_SUBPANEL' => 'ヘッダーをクリックしてサブパネルを展開／折りたたみます',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'レコード名はアップデートできる',
    'LBL_TOUR_RECORD_STATUS' => 'ここでレコードレベル状態を見つける',
    'LBL_TOUR_RECORD_SHOWMORE' => 'クリックしてレコードの更なるデータを見る',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'アクティビティまたは関連レコードの表示を選択',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'クリックしてフィールドインラインを編集する',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'ダッシュレットの新しいグループを作成する',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'ダッシュレットのグループ名をアサインする',
    'LBL_TOUR_RECORD_DASHLETCOG' => '選択してダッシュレットを削除するか設定を変更する',
    'LBL_TOUR_INTRO' =>'<h4>Sugarへようこそ</h4> 機能についてのご説明をご覧いただけます。画面下の「<」および「>」のボタンをクリックしガイドを進めることができます。<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">新着情報</a><p class="details">最新バージョンの主な変更点をご確認いただけます。</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Sugarの詳細</a><p class="details">eラーニング、ライブおよびバーチャル教室でのトレーニング、ウェビナーやビデオチュートリアルをご覧いただけます。（英語のみ）</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">サポート</a><p class="details">Sugar の各種マニュアルや不具合情報をご確認いただけます。</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'レコードのリストを閲覧してレコードにアクションする',
    'LBL_TOUR_RECORD_INTRO' => 'レコードの詳細を閲覧して関連する全てのデータを見る',
    'LBL_TOUR_FORECAST_INTRO' => 'パイプラインと売上予測を管理する',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => '期間を選択して対応する売上予測を見る',
    'LBL_TOUR_FORECASTS_COMMITS' => 'クリックして以前のコミットを見る',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'クリックしてインラインでデータを編集する',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'ノルマ達成までレビューする',
    'LBL_TOUR_FORECASTS_CHART' => '売上予測のディストリビューションをレビューする',
    'LBL_TOUR_TOUR' => 'いつでもガイドをご覧いただけます。',
    'LBL_TOUR_TAGS_ADD' => 'タグフィールドをクリックしてタグを追加および削除します',
    'LBL_TOUR_TAGS_DELETE' => 'タグを削除するには、backspace キーを使用するか各タグの [X] ボタンをクリックしてください',
    'LBL_TOUR_RECORD_SAVE' => '準備ができたら、保存をクリックします。',


    'LBL_FUTURE' => '将来',
    'LBL_REQUIRED_FIELD' => '必須',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => '見積済みの商品',
    'LBL_DISCOUNT_TOTAL' => '値引計',
    'LBL_DISCOUNT_PERCENT' => '割合（％）',
    'LBL_DISCOUNT_SELECT' => '値引が割合（％）か一律かを決めます。',
    'LBL_TAX' => '税金',
    'LBL_SHIPPING' => '配送',
    'LBL_GRAND_TOTAL' => '総計',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'アカウントのプロフィールを使って請求先を自動入力',
    'LBL_QLI_ADD_GROUP' => 'グループを追加',
    'LBL_QLI_COMMENT' => 'コメント',
    'LBL_SELECT_ACTION' => 'アクション選択',
    'LBL_QLI_GROUP_NAME' => 'グループ名',
    'LBL_GROUP_TOTAL' => 'グループ合計',
    'LBL_ITEM_NAME' => '商品',
    'LBL_QLI_DELETE' => '本当にこの商品を削除しますか？',
    'LBL_QLI_COMMENT_DELETE' => '本当にこの商品コメントを削除しますか？',
    'LBL_QLI_GROUP_DELETE' => 'グループ「{0}」を削除してもよろしいですか？すべての項目がデフォルトのグループに移動します。',
    'LBL_QLI_GROUP_EMPTY' => '見積済みの商品がありません',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'オプショナル',
    'LBL_RELATED_MODULE' => '{{{this}}}に関連',
    'LBL_RELATED_MODULE_PLURAL' => '{{{this}}}に関連',
    'LBL_CREATE_MODULE' => '{{{this}}}を作成',
    'LBL_EDIT' => '{{{this}}}を編集',
    'LBL_ASSOC' => '{{{this}}}をリンク',
    'LBL_ASSIGN' => '{{{this}}}を選択',
    'LBL_EDIT_RELATED' => '関連する{{{this}}}を編集',
    'LBL_CREATE_RELATED' => '関連する{{{this}}}を作成',
    'LBL_ASSOC_EXISTING' => '既存の{{{this}}}をリンク',
    'LBL_SEARCH_ALL' => '全ての{{{this}}}を検索',
    'LBL_SEARCH_ALL_RECORDS' => '全てのレコードを検索',
    'LBL_SEARCH_ALL_MODULES' => '全て検索',
    'LBL_OK' => 'OK',
    'LBL_YES' => 'はい',
    'LBL_NO' => 'いいえ',
    'LBL_SHOW_NUMBERING' => 'ステージ番号を表示',
    'LBL_HIDE_NUMBERING' => 'ステージ番号を非表示',
    'LBL_CALL_BUTTON' => '電話',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'Eメール',
    'LBL_HONEYPOT' => 'あなたがもし本当の人間であるならばここは記入しないでください',
    'LBL_LINK_BUTTON' => 'リンク',
    'LBL_UNLINK_BUTTON' => 'はずす',
    'LBL_MAP_BUTTON' => '地図',
    'LBL_FILE_BUTTON' => 'ファイル',
    'LBL_URL_BUTTON' => 'Web',
    'LBL_WARNING' => '警告',
    'LBL_CONFIRM' => 'はい',
    'LBL_CONFIRMATION_POPUP' => '確認ポップアップ',
    'LBL_NO_ACCESS' => '（アクセスなし）',
    'LBL_NO_ACCESS_LOWER' => 'アクセスなし',
    'LBL_NO_FIELD_ACCESS' => 'アクセスなし',
    'LBL_NO_LICENSE_ACCESS' => '必須ライセンス',
    'LBL_VALUE_ERASED' => '値が消去されました',
    'LBL_VALUE_ERASED_TOOLTIP' => 'この情報はデータプライバシー要求を介して消去されました',
    'LBL_CREATE_RELATED_RECORD' => '関連するレコードを作成',
    'LBL_ASSOC_RELATED_RECORD' => '既存のレコードにリンク',
    'LBL_CHOOSE_LINK' => 'リンクタイプを選択',
    'LBL_CHOOSE_PARENT_TYPE' => '親タイプを選択',
    'LBL_HOME' => 'ホーム',
    'ERR_NO_DOCS' => 'ドキュメントがありません',
    'ERR_NO_RECORDS_SELECTED' => 'レコードを選択していません',
    'LBL_DELETING' => '削除中...',
    'LBL_UNLINKING' => 'リンクをはずしています',
    'LBL_UNLINKED' => 'リンクをはずしました',
    'LBL_LEGAL' => 'リーガル',
    'LBL_UPCOMING' => '私の今後のイベント',
    'LBL_RECENTLY_UPDATED' => '最近のアップデート',
    'LBL_NOTES_SUBPANEL_TITLE' => 'メモ',
    'LBL_MEETINGS_SUBPANEL_TITLE' => '会議',
    'LBL_TASKS_SUBPANEL_TITLE' => 'タスク',
    'LBL_CALLS_SUBPANEL_TITLE' => '電話',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'アカウント',
    'LBL_CONTACTS_SUBPANEL_TITLE' => '取引先担当者',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'Eメール',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'シフト',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => '見積済商品',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'シフトの例外',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'ドキュメント',
    'LBL_ESCALATIONS' => 'エスカレーション',
    'LBL_ESCALATED' => 'エスカレーション済み',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'エスカレーション',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'その他の関連エスカレーション',
    'LBL_ESCALATIONS' => 'エスカレーション',
    'LNK_SETTINGS' => '設定',
    'LBL_MOBILE_SUPPORT' => 'サポート',
    'LBL_MOBILE_SHOW_MORE' => 'さらに表示',
    'LBL_MOBILE_SHOW_MORE_TOP' => '更に表示',
    'LBL_MOBILE_NO_RECORDS' => 'レコードが見つかりませんでした',
    'LBL_MOBILE_SEARCH_TEAMS' => 'チーム検索',
    'LBL_MOBILE_SELECT_TEAMS' => 'チーム選択',
    'LBL_MOBILE_WAIT' => 'お待ちください',
    'LBL_MOBILE_LOGING_OUT' => 'ログアウトしています。お待ちください。',
    'LBL_MOBILE_RELOGIN_BUTTON' => '再ログイン',
    'LBL_MOBILE_META_SYNC_FAILED' => 'サーバーに同期ができません',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'サーバーに同期ができません。再度行いますか?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'プライバシー、規約、条件',
    'LBL_MOBILE_APP_VERSION' => 'APPバージョン',
    'LBL_MOBILE_SERVER_VERSION' => 'サーバーバージョン',
    'LBL_MOBILE_SERVER_URL' => 'サーバー URL',
    'LBL_MOBILE_PTR_PULL' => 'プルダウンで更新...',
    'LBL_MOBILE_PTR_RELEASE' => 'リリースで更新...',
    'LBL_MOBILE_EDIT_REL' => '関連の編集',
    'LBL_MOBILE_DESKTOP' => 'デスクトップバージョン',
    'LBL_MOBILE_DELETE_CONFIRM' => '本当にこのレコードを削除してよいですか？',
    'LBL_MOBILE_UNLINK_CONFIRM' => '本当にこのレコードのリンクをはずしますか？',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => '最後の電話のログを取りますか？',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => '受取人を選択',
    'LBL_MOBILE_CHOOSE_PHONE' => '電話番号を選択',
    'LBL_MOBILE_CHOOSE_URL' => 'URLを選択',
    'LBL_MOBILE_CHOOSE_DOC' => 'ドキュメントを選択',
    'LBL_MOBILE_CHOOSE_LOCATION' => '場所を選択',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'アクションがありません',
    'LBL_MOBILE_FEEDBACK' => 'フィードバック',
    'LBL_MOBILE_DOC' => 'ドキュメント',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'ダウンロード開始: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'ダウンロード完了: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'ファイルをアップロード中',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'ファイルのアップロードに成功',
    'LBL_MOBILE_PROCESSING_IMAGE' => '画像を準備中',
    'LBL_CLOSE_SAVE_BUTTON' => 'タスクを閉じて保存',
    'LBL_LATER' => '後で',
    'LBL_USE_HTTPS' => 'セキュア接続を使用',
    'LBL_LOADING_FILES' => 'ドキュメントリストをロード中。後で再度試してください。',
    'LBL_NEW_WEB_VERSION' => 'このアプリの新しいバージョンが利用可能です。アップデートしますか？',
    'LBL_SET_FONTSIZE' => 'フォントサイズ',
    'LBL_FONTSIZE_TINY' => 'とても小さい',
    'LBL_FONTSIZE_SMALL' => '小さい',
    'LBL_FONTSIZE_NORMAL' => '普通（デフォルト）',
    'LBL_FONTSIZE_LARGE' => '大きい',
    'LBL_FONTSIZE_LARGER' => '更に大きい',
    'LBL_FONTSIZE_HUGE' => 'とても大きい',
    'LBL_FONTSIZE_EXTRA_HUGE' => '巨大',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "ダウンロード失敗\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'さらに...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '少なく',
    'LBL_OFFLINE_MODE' => 'オフラインモード',
    'LBL_OFFLINE_DELETED' => 'レコードは見つかりませんでした。',
    'LBL_OFFLINE_DELETED_RELATED' => '関連するレコードが見つかりません。削除されたかリンクが外されたかもしれません。',
    'LBL_OFFLINE_PREFETCH_PROMPT' => '割り当てられた、お気に入りの、フォローしているレコードをオフラインアクセスでダウンロードするのは、完了に時間がかかる場合があります。高速の接続が推奨されます。続行しますか？',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => '割り当てられた、お気に入りの、フォローしているレコードをオフラインアクセスでダウンロードしますか？高速の接続が推奨され、時間がかかる可能性があります。メインメニュー→オフラインからダウンロードできます。',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'レコードのダウンロードに成功しました',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'レコードをダウンロードしています',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'レコードをダウンロード中にエラー',
    'LBL_OFFLINE_PREFETCHING' => 'レコードをロード中',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'ロード中{{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => '残り時間約{{estimatedTime}}...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => '{{module}}ロード完了',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'ストレージをクリーニング中',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'クリーニング完了',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'この変更を戻しますか？',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => '変更取り消し完了',
    'LBL_OFFLINE_ROLLBACK_FAILED' => '変更取り消し失敗',
    'LBL_OFFLINE_CLEAR_DB' => 'ストレージをクリアする',
    'LBL_OFFLINE_COMPACT_DB' => 'ストレージをコンパクト化する',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'このアクションによりアクセスしていないレコードを削除します。続けますか？',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'ローカルストレージの全てのレコードを削除しますか？',
    'LNK_OFFLINE_SETTINGS' => 'オフライン',
    'LBL_OFFLINE_SETTINGS' => 'デバッグ設定',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => '同期待ちの変更無し',
    'LBL_OFFLINE_STATUS_PENDING_TX' => '変更は未同期',
    'LBL_OFFLINE_STATUS_ONLINE' => 'デバイスはオンライン',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'デバイスはオフライン',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'サーバーに接続できません。',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => '同期に失敗。トランザクションログを確認してください。',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => '同期が進行中',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'トランザクションは同期されました',
    'LBL_OFFLINE_ENABLE_PROMPT' => '本当にオフラインサポートをオンにしますか？',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'オフラインサポートをオフにしますか？同期していない変更は失われます。',
    'LBL_OFFLINE_ENABLED' => 'オフラインモードが有効',
    'LBL_OFFLINE_DISABLED' => 'オフラインモードは無効',
    'LBL_OFFLINE_STATS' => 'ストレージ分析',
    'LBL_OFFLINE_SERVER_FETCH' => 'サーバーから取得中',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => '誰かがサーバー上の同じレコードを編集しました。オートマージに確認して変更するか破棄する。',
    'LBL_OFFLINE_LAST_SYNC_TS' => '最後の同期の試み: {{ts}}',
    'LBL_ACTION_UPDATE' => 'アップデート',
    'LBL_ACTION_CREATE' => '作成',
    'LBL_ACTION_DELETE' => '削除',
    'LBL_ACTION_LINK' => 'リンク',
    'LBL_ACTION_UNLINK' => 'はずす',
    'LBL_ACTION_FAVORITE' => 'お気に入り',
    'LBL_ACTION_FOLLOW' => 'フォロー',
    'LBL_ACTION_CREATE_EXPLANATION' => '作成された {{module}} "{{name}}"',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'アップデートされた {{module}} "{{name}}"',
    'LBL_ACTION_DELETE_EXPLANATION' => '削除された {{module}} "{{name}}"',
    'LBL_ACTION_LINK_EXPLANATION' => 'リンクされた {{module}} "{{name}}" から {{relatedModule}} "{{relatedName}}" へ',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'リンクをはずされた {{module}} "{{name}}" {{relatedModule}} "{{relatedName}}" から',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'フォローされた {{module}} "{{name}}"',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'フォローをはずした {{module}} "{{name}}"',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'お気に入りにした {{module}} "{{name}}"',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'お気に入りから外した {{module}} "{{name}}"',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => '{{relatedModule}} "{{relatedName}}" に関連のある{{module}} "{{name}}" 作成しました',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => '主',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'オプトアウト',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'オプトイン',
    'LBL_EMAIL_ACTION_SET_VALID' => '有効',
    'LBL_EMAIL_ACTION_SET_INVALID' => '無効',
    'LBL_ROLLBACK_BUTTON' => 'ロールバック',
    'LBL_TX_LOG' => 'トランザクションログ',
    'LBL_TX_LOG_DETAIL' => 'トランザクション詳細',
    'LBL_RECORD_DELETED' => '(レコードは削除されました)',
    'LBL_NOT_AVAILABLE' => '利用できません',
    'LBL_FILE_SIZE' => 'ファイルのサイズ',
    'LBL_FILE_SIZE_UNITS_B' => 'バイト',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'アイテムを選ぶ',
    'LBL_OFFLINE_DB_SIZE' => 'データベースのサイズ',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'モジュールのレコード',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'レコードの総数',
    'LBL_RECORD_NOT_FOUND' => 'レコードは見つかりませんでした。',
    'LBL_RELATED_RECORD_NOT_FOUND' => '関連するレコードは見つかりませんでした。',
    'LBL_NOT_AUTHORIZED' => 'このレコードを閲覧する権限がありません。',
    'LBL_MOBILE_PROCESSING_FILE' => 'ファイルを準備中',
    'LNK_THIRD_PARTY_SOFTWARE' => 'サードパーティーソフトウェア',
    'LNK_TERMS_OF_USE' => '利用規約',
    'LNK_PRIVACY_POLICY' => 'プライバシーポリシー',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'シングルサインオン',
    'LBL_RECENTS' => '最近',
    'LBL_SHOWING_CACHED_DATA' => 'サーバーに到達できません。最新の使用可能なデータ ({{lastFetched}}) を表示しています。',
    'LBL_CLOSE_AND_SAVE_BUTTON' => '{{moduleSingular}} を閉じて保存します',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => '特定のダッシュ ボード',
    'LBL_MOBILE_SPECIFIC_MODULE' => '特定のモジュール',
    'LBL_MOBILE_DEFAULT_VIEW' => 'スタート画面',
    'LBL_MOBILE_DEFAULT_MODULE' => '選択されたモジュール',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => '選択されたダッシュ ボード',
    'LBL_MOBILE_DEFAULT_DASHLET' => '選択されたダッシュレット',
    'LBL_ALL_DASHLETS' => 'すべてのダッシュレット',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'グローバル検索',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => '@ を入力してユーザーに言及します。# を入力してレコードを参照します。',
    'LBL_MOBILE_NEW_COMMENT' => '新しいコメント',
    'LBL_RECENTLY_VIEWED' => '最新の閲覧履歴',
    'LBL_FILE_STORED_LOCALLY' => 'ローカルストレージに保存されたファイルは端末がオンラインになれば、同期されます。',
    'LBL_IDM_USER_PROFILE_READONLY' => '編集不能なフィールドを変更したい場合は、アドミニストレータにそれらの変更を通知してください。',
    'LBL_ACTIVITY_POST' => '{{{link}}}上の{{{value}}}',
    'LBL_COMMENTLOG_EMPTY' => 'コメントなし',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => '次の{{{commentsLeft}}} コメントを表示する',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => '折りたたむ',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'コメント作成の確認',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'コメントログを空欄のままにすることはできません',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'PDFファイル{{{pdfTemplateName}}} のダウンロード',

    'ERR_SYNC_FAILED' => 'サーバーに同期ができません',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'アクセスは許可されていません。',
    'ERR_MOBILE_INVALID_CREDS' => '無効なユーザー名かパスワードです',
    'ERR_MOBILE_SESSION_EXPIRED' => 'セッションは期限切れになりました',
    'ERR_MOBILE_NOT_FOUND' => 'リソースが見つかりません',
    'ERR_MOBILE_TIMEOUT' => 'サーバーが応答していません。',
    'ERR_MOBILE_CONNECTION_FAILED' => 'サーバーに到達できません',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'インターネット接続がありません。',
    'ERR_MOBILE_INTERNAL' => '内部エラー ({{{code}}})。後でもう一度試してください。',
    'ERR_MOBILE_VALIDATION' => 'レコードが無効です',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => '互換性の無いサーバーフレーバーです {{{flavor}}}. サポートされたフレーバー: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => '互換性の無いサーバーバージョンです：{{{version}}}。最低必要バージョン： {{{minVersion}}}',
    'ERR_MOBILE_EMAIL' => 'エラー：無効なEメールアドレス',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'このドキュメントタイプはサポートされていません。',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => '認証に失敗しました。',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => '要求されたリソースは見つかりませんでした。',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'サーバ内部のエラー。',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => '禁止',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'サービスは利用不可です。',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => '予期しないエラーが起きました。',
    'ERR_MOBILE_UPLOAD' => 'ファイルアップロード中のエラー',
    'ERR_MOBILE_FILE_PROCESSING' => 'ファイルの処理エラー',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'デバイスストレージは利用不可',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'あなたのappは古く、接続しようとしている{{{brandName}}}インスタンスに適応していません。App Storeで新しいバージョンをダウンロードしますか？',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'サーバー設定が変更されリロードが必要です。進めますか？',
    'ERR_MOBILE_CONFLICT' => '誰かがサーバー上の同じレコードを編集しました。オートマージに確認して変更するか破棄する。',
    'ERR_MOBILE_METADATA_CHANGED' => 'サーバー設定は変更されました。',
    'ERR_MOBILE_FILE_READ' => 'ファイルの読み込みに失敗しました',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'ファイルは見つかりませんでした',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'ファイルは読み込めないものです',
    'ERR_MOBILE_FILE_ABORTED' => 'リードオペレーションが回避されました',
    'ERR_MOBILE_FILE_SECURITY' => 'ファイルはロックされました',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'モバイルバージョンはこの機能をサポートしていません。デスクトップバージョンを開きますか？',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'ファイルは大きすぎます。最大のサイズは{{size}}です',
    'ERR_OFFLINE' => 'オフラインエラー',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'ローカルストレージを開くのに失敗しました',
    'ERR_OFFLINE_STORAGE_CREATE' => 'ローカルストレージを作成するのに失敗しました',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'ローカルストレージを作成するのに失敗しました。スペースがありません。',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'ローカルストレージのスペースがありません。',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'データベースのクリーンナップに失敗',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'オフラインストレージの容量がありません。ストレージのクリーンアップが推奨されます。数分かかる場合があります。',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'サーバーからのレコードのプリフェッチに失敗',
    'ERR_OFFLINE_SYNC_ERROR' => '同期エラー',
    'ERR_OFFLINE_SYNC_CONFLICT' => '同期競合',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'サーバータイムの取得に失敗',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'オフライン モードを有効にできませんでした。サーバーに到達できません。',
    'LBL_EXPORT_CSV' => 'CSVのエクスポート',
    'LBL_ERR_EXPORTING_CSV' => 'エクスポートに失敗しました',
    'LBL_ERR_EXPORT_ALL' => '選択されたレコードのデータ取得に失敗しました。もう一度お試しください',
    'LBL_LIST_SETTINGS_RESTORE' => 'デフォルトに復元',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'フィールドを復元しますか？',
    'LBL_LIST_SETTINGS_TITLE' => 'リストビュービルダー',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => '利用可能なフィールド',
    'LBL_LIST_SETTINGS_REMOVE' => '削除',
    'LBL_LIST_SETTINGS_TEXT' => 'リストビュービルダーにフィールドをドラッグし、それらを並べ替えて、{{moduleName}} リストビューを配置します。',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'レイアウトには、少なくとも1つのフィールドを追加する必要があります。',
    'LBL_LIST_SETTINGS_EMPTY' => '利用可能なフィールドがありません',
    'LBL_LIST_SETTINGS_NO_MATCHING' => '一致するフィールドが見つかりません',
    'LBL_LIST_FILTER' => 'フィールド検索',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'Eメールクライアント',
    'LBL_DEFAULT_SYSTEM_CLIENT' => '外部Eメールクライアント',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar Eメールクライアント',
    'LBL_OFFLINE_CAPABILITIES' => 'オフライン機能を有効にする',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'トランザクションの削除に失敗しました。',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'トランザクションが削除されました。',
    'LBL_SECURE_MODE' => '強化されたセキュリティモード',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'この設定を有効にすると、アプリがバックグラウンドにあるときにSugar Mobileのコンテンツを非表示にし、いつでもアプリのスクリーンショットができないようにします。',
    'LBL_SECURE_MODE_IOS_TEXT' => 'この設定を有効にすると、アプリがバックグラウンドにあるときにSugar Mobileのコンテンツを非表示にします。',
    'LBL_ALWAYS_OFFLINE_MODE' => '常時オフラインモード',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => '常時オフラインモードで作業しています。再接続しますか？',
    'LBL_RECONNECT' => '再接続',
    'LBL_STAY_OFFLINE' => 'オフラインのままにする',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'アクセスしようとしているモジュールは、Sugar Mobileでは使用できません。',
    'LBL_MOBILE_RELEASE_NOTE' => '{{platform}} 用Sugar Mobileリリースノート',
    'LBL_MOBILE_USER_GUIDE' => '{{platform}} 用Sugar Mobileユーザーガイド',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'これらのワードを含む',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'これらのワードを除く',
    'LBL_NOTIFICATIONS_CHANNEL' => '更新',
    'LBL_APPLY_BUTTON_LABEL' => '適用',
    'LBL_ACTION_CREATE_FAILURE' => "レコードの保存に失敗しました：\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "レコードの更新に失敗しました：\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'サーバー上のフィールド計算の解決に失敗しました。',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => '以下のフィールドは無効です：{{{fields}}}。',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>成功。</b> {{{module}}} <a href="#{{{recordUrl}}}">「{{{recordName}}}」</a>の作成に成功しました。',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>成功。</b> レコードの更新に成功しました',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'サーバーからのEメールデータの取得に失敗しました。',
    'LBL_ASSIGN_SUCCESS' => '<B>成功。</b> レコードが {{{userName}}} に割り当てられました。',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'このEメールを下書きとして保存しますか？',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => '下書きとして保存',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'Eメールを破棄する',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => '下書きを保存しないと、このメールは失われます。',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => '署名の選択',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'Eメールテンプレートの選択',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'テンプレートは、このEメールのすべての内容を上書きします。本当にこのテンプレートを使用して内容を上書きしますか？',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'Eメール作成',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'このメールには、関連先レコードの値で置き換えられる変数が含まれています。関連先フィールドが正しく設定されていることを確認してから送信してください。',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => '送信メールアカウントが見つかりません。Sugarの管理者にお問い合わせください。',
    'LBL_EMAIL_MORE_RECIPIENTS' => 'と {{{count}}} 以上',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'Eメールを追加',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => '連絡先の名前またはEメールを入力します',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (新しいメール)',
    'LBL_TEMPLATE_HAS_VARIABLES' => '変数',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'Eメールテンプレート',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'キャンペーンテンプレート',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'ワークフローテンプレート',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'システムテンプレート',
    'LBL_FILTER_EDIT' => 'フィルターを編集する',
    'LBL_FILTER_MY_FILTER' => 'マイフィルター',
    'LBL_FILTER_MY_FILTER_BY' => '{{{filters}}} によるマイフィルター',
    'LBL_FILTER_SAVE' => 'フィルターを保存する',
    'LBL_SELECT_PARAM' => '選択',
    'LBL_SELECT_MODULES' => 'モジュールセレクター',
    'LBL_SELECT_ADDITIONAL_PARAMS' => '追加のパラメータを選択する',
    'LBL_FILTER_TEMPORARY' => '一時的なフィルター',
    'LBL_ERROR_FILE_UPLOAD' => '{{{fieldLabel}}} ファイル 「{{{fileName}}}」のアップロードに失敗しました。 {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">失敗したレコードを表示する</a>',
    'LBL_FILE_UPLOAD_ONE' => 'ファイルの保存中...',
    'LBL_FILE_UPLOAD_MANY' => '{{{total}}} のうち {{{index}}} ファイルの保存中...',
    'LNK_NOTIFICATIONS_SETTINGS' => '通知設定',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'プッシュ通知の管理',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "デバイスの通知設定を使用して、通知がどのように表示されるかを制御します。",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'アサイン先',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'あなたにレコードが割り当てられたときに通知を受信します。',
    'LBL_NOTIFICATION_MENTIONS' => 'メンション',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'コメントログエントリに記載されたときに通知を受け取ります。',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'コメントログフィールドは、管理者によってこのレイアウトに追加されていません。Sugarの管理者にお問い合わせください。',
    'ERR_NO_PERMISSION_TITLE' => 'アクセスを許可してください',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} では、写真を添付できるようにカメラへのアクセスを許可する必要があります。システム設定でカメラへのアクセスを許可してください。',
    'LBL_MOBILE_SYSTEM_SETTINGS' => '設定',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => '時間',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => '残り時間',
    'LBL_LIST_SUPPORT_EXPIRES' => '有効期限',
    'LBL_CASCADE_RLI_EDIT' => 'オープンしている商談品目の更新',
    'LBL_MOBILE_CALENDAR' => 'カレンダー',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'カレンダーの設定',
    'LBL_MOBILE_CALENDAR_WEEK_START' => '週の開始日',
    'LBL_MOBILE_CALENDAR_MODULES' => '表示するイベント',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}} 時間: {{{minutes}}} 分',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} 時間',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} 分',
    'LBL_MOBILE_CALENDAR_TODAY' => '今日',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => '{{{moduleName}}} を追加',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'アクティビティをスケジュールする',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => '少なくとも1つのイベントタイプを有効にしてください。',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => '終日',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'カレンダーの読み込みに失敗しました。',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'このアクションはSugar Mobileでは利用できません。代わりにデスクトップアプリケーションを開きますか？',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'テンプレートの選択',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'マージ',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'エラー：HEICファイルからEXIFデータが欠落しています',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'エラー：画像の解像度が高すぎます',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'エラー：画像を処理できません',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'エラー：画像のキャンバスへのレンダリングに失敗しました',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'エラー：ファイルを画像として読み込めませんでした',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1項目選択されました',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} 項目選択されました',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'すべて選択',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'このビューで {{{count}}} レコードを選択しました。すべてのレコードを選択しますか？',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => '{{{count}}} レコードを選択する',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => '本当に選択したレコードを削除しますか？',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => '{{{total}}}　のうち　{{{count}}}　件を削除中...',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => '選択されたレコードに有効なEメールがありません',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => '外観',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'システム設定を使用する',
    'LBL_MOBILE_APP_THEME_LIGHT' => '明るい',
    'LBL_MOBILE_APP_THEME_DARK' => '暗い',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => '新しいファイル名',
    'LBL_ATTACHMENT_RENAME_MSG' => 'ファイルの名前変更',
    // Filters related
    'LBL_CREATED_BY_ME' => '自作',
    'LBL_OPERATOR_ONE_OF' => '以下のいずれか',
    'LBL_OPERATOR_NOT_ONE_OF' => '以下のいずれでもない',
    'LBL_OPERATOR_CONTAINS' => '次のいずれか',
    'LBL_OPERATOR_CONTAINS_WORD' => 'は次を含む：',
    'LBL_OPERATOR_NOT_CONTAINS' => '次のいずれでもない',
    'LBL_OPERATOR_EMPTY' => '空である',
    'LBL_OPERATOR_NOT_EMPTY' => '空でない',
    'LBL_OPERATOR_MATCHES' => '次の値と一致する',
    'LBL_OPERATOR_STARTS_WITH' => '次で始まる',
    'LBL_OPERATOR_EQUALS' => '次と等しい',
    'LBL_OPERATOR_NOT_EQUALS' => '次と等しくない',
    'LBL_OPERATOR_GREATER_THAN' => '次より大きい',
    'LBL_OPERATOR_LESS_THAN' => '次より小さい',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => '次より多いか同じ',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => '次より少ないか同じ',
    'LBL_OPERATOR_BETWEEN' => '次の範囲内',
    'LBL_OPERATOR_BEFORE' => '以前',
    'LBL_OPERATOR_AFTER' => '以降',
    'LBL_OPERATOR_YESTERDAY' => '昨日',
    'LBL_OPERATOR_TODAY' => '今日',
    'LBL_OPERATOR_TOMORROW' => '翌日',
    'LBL_OPERATOR_LAST_7_DAYS' => '過去7日間',
    'LBL_OPERATOR_NEXT_7_DAYS' => '翌7日間',
    'LBL_OPERATOR_LAST_30_DAYS' => '過去30日間',
    'LBL_OPERATOR_NEXT_30_DAYS' => '翌30日間',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => '__ 日以上前',
    'LBL_OPERATOR_LAST_X_DAYS' => '過去__日間',
    'LBL_OPERATOR_NEXT_X_DAYS' => '今後__日間',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => '今後__日以上',
    'LBL_OPERATOR_LAST_MONTH' => '昨月',
    'LBL_OPERATOR_THIS_MONTH' => '今月',
    'LBL_OPERATOR_NEXT_MONTH' => '翌月',
    'LBL_OPERATOR_LAST_YEAR' => '昨年',
    'LBL_OPERATOR_THIS_YEAR' => '今年',
    'LBL_OPERATOR_NEXT_YEAR' => '翌年',
    'LBL_OPERATOR_IS' => 'は',
    'LBL_OPERATOR_IS_NOT' => 'ではない',
    'LBL_OPERATOR_AFTER_TODAY' => '本日以降',
    'LBL_OPERATOR_BEFORE_TODAY' => '本日以前',
    'LBL_ERROR_FILTER_EMPTY' => 'フィルタ条件を追加してください。',
    'LBL_ADD_FILTER' => '検索条件を追加',
    'LBL_FILTER_NAME' => 'フィルタ名',
    'LBL_FILTER_FIELD' => 'フィールド',
    'LBL_FILTER_OPERATOR' => 'オペレータ',
    'LBL_FILTER_VALUE' => '値',
    'LBL_FILTER_SYNC_TO_SERVER' => 'デスクトップアプリに保存',
    'LBL_FILTER_LOCAL' => 'ローカルフィルタ',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => '{{{brandName}}}にようこそ。<br />新しい機能をご紹介します。',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'メインメニューナビゲーション',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'ビューごとの使用可能なアクション',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'レコードのグローバル検索',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => '私のお気に入りレコードを表示するためにリストをフィルタする',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'アサインされたレコードを表示するためにリストをフィルタする',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'レコードをお気に入りとしてマーク',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => '今日から始まる私のイベント',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => '一番最近変更されたレコード',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'レコード上で使用可能なアクション。',
    'LBL_MOBILE_TUTORIAL_HOME_END' => '全ての新しい機能をお楽しみください。',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'これはプラスメニューです',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'プラスメニューを閉じる',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => '実行するアクションを選択する',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'これがホームメニューです。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'ホ－ムメニューを閉じる。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => '特定のモジュールを閲覧',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'アプリをカスタマイズ',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'ウェブブラウザでSugarを開く',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'プロフィールを表示',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'これが詳細ページです',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'レコードに関しての最も重要な情報',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => '追加情報を閲覧するかレコードを編集する',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'レコード上で使用可能なアクション。',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => '前のページに戻る',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'いつでもツアーにアクセス',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => '戻る',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'クリックして関連するレコードを開く',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'レコードをフォロー/アンフォロー',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'クリックして詳細情報を開く',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'メインメニュービュー',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'メインメニューは画面左側に開きます。',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => '詳細画面',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => '詳細画面は画面右側に開きます。',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => '下の矢印を使ってこのメニューのキーコンポーネンツのクイックツアーを見る',

    'LBL_COMMENT_ADD' => 'コメントを追加',
    'LBL_REQUIRED' => '必須',
    'LBL_MORE_BUTTON' => '追加',
    'LBL_NO_OPTIONS' => '使用可能なオプションはありません',
    'LBL_TRY_AGAIN' => '再度試す',
    'LBL_NEW_RECORDS' => '最新の作成履歴',
    'LBL_ASSIGNED_TO_ME' => '私の {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'すべての {{{module}}}',
    'LBL_UNFAVORITE' => 'お気に入り解除',
    'LBL_ACTIVITY_CREATE' => '{{{record}}} {{{module}}} を作成しました',
    'LBL_ACTIVITY_UPDATE' => '{{{record}}} {{{module}}} 上の {{{changes}}} を更新しました',
    'LBL_ACTIVITY_LINK' => '{{{relatedRecord}}} を {{{record}}} {{{module}}} にリンクしました',
    'LBL_ACTIVITY_UNLINK' => '{{{relatedRecord}}} を {{{record}}} {{{module}}} からリンク解除しました',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{parentModule}} 用の {{relationship}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => '関連レコードをダウンロード...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'ダッシュボード構成が変更されました。リロードしますか？',
    'LBL_RECORDS' => 'レコード',
    'LBL_DASHBOARDS' => 'ダッシュボード',
    'LBL_TEMPLATES' => 'テンプレート',
    'LBL_NON_TEMPLATES' => 'テンプレート以外',
    'LBL_IS_TEMPLATE' => 'テンプレートです',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => '選択したテンプレートにはダッシュボードテンプレートが含まれており、一括更新することはできません。続行するには、テンプレートの選択を解除してください。',
    'LBL_UNSELECT_DELETE_TEMPLATES' => '選択したテンプレートにはダッシュボードテンプレートが含まれており、一括削除することはできません。続行するには、テンプレートの選択を解除してください。',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => '{{searchCriteria}} を検索...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'メインメニュー',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => '新規レコードをクイック作成',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'スワイプしてその他のオプションを表示',
    'LBL_DETAILS' => '詳細',
    'LBL_DETAIL_RELATED' => '関連',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'この {{module}} には {{relatedModule}} が必要です。<a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>{{relatedModule}} レコードを作成してください</a>。',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'レコードを編集',
    'LBL_OFFLINE_MENU_SETTINGS' => 'オフライン設定',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'デバッグ設定',
    'LBL_OFFLINE_TOTAL_RECORDS' => '合計レコード',
    'LBL_OFFLINE_LAST_DOWNLOAD' => '最終ダウンロード',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'ファイルをダウンロードできません。',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'サーバからダッシュボードを読み込むことに失敗しました',
    'ERR_FILTERS_FETCHING' => 'フィルタを取得できません',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'ローカルストレージを暗号化するのに失敗しました',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'オフラインデータを暗号化中です。これには数分かかることがあります。',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'オフラインデータ暗号化が完了しました。',
    'ERR_ACCESS_SPECIFIC_MODULE' => '{{{module}}} モジュールへのアクセス権がありません。',
    'LBL_SKIP' => 'スキップ',
    'LBL_CONTINUE' => '続ける',
    'LBL_ENABLE' => '有効にする',
    'LBL_MOBILE_TRIAL_UNTIL' => 'トライアル期限',
    'LBL_MOBILE_SDK_VERSION' => 'SDKバージョン',
    'LBL_LOG_LEVEL' => 'ログレベル',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'ログイン設定が再構成されました。',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'トライアル期間が期限切れになりました。',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'サーバがセキュア接続をサポートしていません。セキュア接続をオフにしてください。',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'サーバがセキュア接続をサポートしています。セキュア接続をオンにしてください。',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => '接続がセキュアではありません。管理者に連絡してください。',
    'LBL_LOGIN_SETTINGS_HEADER' => 'ログイン設定',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => '{{{brandName}}} インスタンスを設定',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'アプリが機能するには、{{{brandName}}} インスタンスのURLを入力する必要があります。インスタンスURLがわからない場合は、管理者に連絡してください。',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => 'Touch ID',
    'LBL_ENABLE_TOUCHID' => '{{{biometryType}}} を有効にする',
    'LBL_SETUP_TOUCHID' => '{{{biometryType}}} を設定',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => '指を使ってサインイン',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} がお使いのデバイスで設定されていません。\n\nデバイス設定に移動して {{{biometryType}}} を設定してください。設定が完了したら、メインメニュー > 「設定」で {{{brandName}}} の {{{biometryType}}} を有効にしてください。",
    'LBL_TOUCH_ID_DISCLAIMER' => '{{{brandName}}} で {{{biometryType}}} を使用することで、{{{brandName}}} にアクセスする際にパスワードを入力する代わりに生体識別子を使用できます。',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => '{{{biometryType}}} の設定を進めますか？    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => '{{{brandName}}} パスワードを入力して {{{biometryType}}} を有効にしてください',
    'LBL_SETUPBUDDY_HEADER_TITLE' => '設定',
    'LBL_MDM_CONFIRM_CHANGE' => 'アプリケーション構成がモバイルデバイスマネージャーから変更されました。変更を適用するために再度ログインしてください。',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'デバイスの設定であなたの場所へのアクセス権を {{{brandName}}} に付与してください。',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => '現在の場所を利用できません。',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "現在の場所の取得がタイムアウトしました。\nもう一度やり直してください。",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => '場所プレイスマークが利用できません',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => '場所調整が無効です',
    'ERR_MOBILE_INVALID_PASSWORD' => 'パスワードが無効です。',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'アプリが古いため、接続している{{{brandName}}}インスタンスと互換性がなくなっています。更新しますか？ ',
    'LBL_MOBILE_BY' => '以下の日まで:',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'このフィルターはオフラインで利用できません',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'オフラインレコード',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => '設定をダウンロード',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'オフラインアクセス用にあなたに割り当てられたレコード、お気に入りのレコードおよびフォローされたレコードをダウンロードしてください。あなたのユーザ設定をオフライン設定で更新できます。',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'あなたのレコードのダウンロードが終了しました。それらにオフラインモードでアクセスできるようになりました。',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "一部のレコードがダウンロードされませんでした。\nもう一度試しますか？",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'セルラーデータを使用',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => '後で',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'ダウンロードが一時停止しました。もう一度アプリを開いたときに再開されます。',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => '{{{module}}} をダウンロード中: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => '最新のレコードを更新',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => '接続を待機中',
    'LBL_BULK_LOAD_STATUS_PAUSED' => '一時停止',
    'LBL_BULK_LOAD_STATUS_STOPPING' => '停止中',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'ダウンロード',
    'LBL_BULK_LOAD_BTN_PAUSE' => '一時停止',
    'LBL_BULK_LOAD_BTN_RESUME' => '再開',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'デフォルトではWiFi接続のみが使用されます。',
    'LBL_NPS_RATING_MSG' => "{{{productName}}} エクスペリエンス\nをどのように評価しますか？",
    'LBL_NPS_THANKS_MSG' => 'フィードバックをありがとうございます！',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'App Storeで評価していただけますか？',
    'LBL_NPS_NO_THANKS' => 'いいえ、遠慮します',
    'LBL_NPS_NOT_NOW' => '後で',
    'LBL_NPS_RATE_NOW' => '今すぐ評価',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'ネットワークを利用できません。アプリはオフライン中も使用できます',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => '変更はオンラインのときに同期されます。<a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>詳細を参照してください</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => '同期されていないデータがあります。<a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>トランザクションログ</a>を確認してください',
    'LBL_CONVERT' => 'コンバート',
    'LBL_CONVERT_LEAD' => 'リードのコンバート',
    'LBL_SEARCH_EXISTING_RECORD' => '既存の {{{this}}} を検索',
    'LBL_DUPLICATES_CHECK_FAILED' => '重複チェックに失敗しました',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => '関連アクティビティを取引先担当者レコードに移動しますか？',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'リード {{{name}}} のコンバートに成功しました',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => '重複が見つかりませんでした。',
    'ERR_LEAD_CONVERSION_FAIL' => 'リードコンバージョンに失敗しました',
    'LBL_SELECT_DUPLICATE_RECORD' => '重複 {{{modulePlural}}} から選択',
    'LBL_SELECTED_EXISTING_RECORD' => '{{{moduleSingular}}} を選択しました',
    'LBL_CREATED_NEW_RECORD' => '新しい {{{moduleSingular}}} を作成しました',
    'LBL_VO_BACK_BTN' => '戻るボタン',
    'LBL_VO_HOME_BTN' => 'ホームボタン',
    'LBL_VO_DASHBOARD_BTN' => 'ダッシュボードボタン',
    'LBL_VO_SEARCH_BTN' => '検索ボタン',
    'LBL_VO_RIGHT_MENU_BTN' => '右メニューボタン',
    'LBL_VO_ADD_BTN' => '追加ボタン',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => '値引',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'マッピングアプリを選択',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => '選択された{{entityName}} は関連する値があります: {{localizedFieldNames}}。 キャンセルして現在の値をそのままにするか、確認して新しい値で上書きしてください。',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'データ暗号化が有効になっています。',
    'LBL_LEAD_ALREADY_CONVERTED' => '選択したリードはすでに変換されています。',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'このアクションは、デバイスがオンラインの時にのみ実行可能です',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => '見積から商談を作成しますか？',
    'LBL_TAG_ADD' => 'タグを追加',
    'LBL_TAG_ENTER_TAG_NAME' => 'タグを入力',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'タグによるフィルタリングは、デバイスがオフラインの時には対応しません。',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'コメントをすべて表示',
    'LBL_COMMENT_VIEW' => 'コメントを表示',
    'LBL_PMSE_LABEL_DUEDATE' => '期日',
    'LBL_PMSE_DUE' => '期限',
    'LBL_PMSE_DUE_ON' => '以下の期限:',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => '最初に {{conversionParentModuleName}} を作成してください',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => '必須のレコードがありません: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => '画質を選択してください。サーバーに保存する前に、それに応じて画像のサイズが変更されます。 選択した値は、今後すべての同様の操作のデフォルトとして使用されます。',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'ファイルサイズを推定しています...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'ファイルの推定サイズは',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => '画質',
    'LBL_IMAGE_QUALITY_BEST' => 'オリジナルのサイズ',
    'LBL_IMAGE_QUALITY_GOOD' => '良画質',
    'LBL_IMAGE_QUALITY_POOR' => '小サイズ',
    'LBL_IMAGE_QUALITY_BTN' => '圧縮: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => '{{module}} のリストフィールド',
    'LBL_LIST_RESET_FIELDS' => 'デフォルトにリセットする',
    'LBL_LIST_NOT_ENOUGH' => 'アクティブなフィールドを少なくとも1つ設定してください。',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'SugarCRMインスタンスと連携可能になるには、ログインしてアクセス許可を受け入れる必要があります。',
    'LBL_SELECTING_EXISTING_RECORD' => '{{{moduleSingular}}} の選択',
    'LBL_CREATING_NEW_RECORD' => '新規{{{moduleSingular}}} の選択',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => '画像サイズ',
    'LBL_COPY_ADDRESS' => 'アドレスをコピー',
    'LBL_OPEN_IN' => '以下で開く:',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'ファイルが選択されていません。',
    'LBL_ATTACHMENT_ADD' => '添付',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'このアプリはcookieを使用します',
    'LBL_USE_COOKIES_CONFIRM' => '優れたユーザ体験を提供するために、このアプリケーションではcookieを使用します。続行すると、お客様は当社のプライバシーポリシーに基づいてcookieを使用することに同意したものとみなされます。',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'あなたは、将来のモバイル版リリースにおいて実装されるSugar Mobileとの互換性がないSugarインスタンスを使用しています。管理者に問い合わせて可能な限り速やかにSugarをアップグレードしてください。',
    'ERROR_TAG_NAME_INVALID' => 'タグ名に「{{{forbiddenChars}}}」文字を含めることはできません',
    'ERROR_NO_TAGS_FOUND' => '「{{{searchQuery}}}」一致する使用可能なタグはありません',
    'ERR_PA_RECORD_INVALID' => '{{{moduleName}}} レコードに1つ以上の無効な値が含まれており、保存できません。{{{actionLabel}}} アクションを実行するためにレコードを編集しますか？',
    'ERR_MOBILE_METADATA_RELOAD' => '管理者があなたのSugarインスタンスの設定に変更を加えました。OKを押してアプリの設定をサーバーと同期してください。',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'このアプリケーションではcookieを使用します',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => '同意する場合はチェックしてください(必須)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => '優れたユーザ体験を提供するために、このアプリケーションではcookieを使用します。続行すると、お客様は当社の<a href="{{href}}" target="_blank">プライバシーポリシー</a>に基づいてcookieを使用することに同意したものとみなされます。',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'レコードビューでレコードの詳細を見る事ができます。',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'メモで他のポータルユーザーとサポート担当とコラボレーションできます。',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'クリックしてこのレコードにメモを加える',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'これらのアイコンをクリックして添付されたメモを詳細を見る事ができます。',

    //for portal
    'LBL_PORTAL_HOME' => 'ホームダッシュボード',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'すべての未解決ケース',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => '最近の解決済みケース',
    'LBL_PORTAL_SEARCH' => '名前と番号で検索',
    'LBL_SIGNUP_BUTTON_LABEL' => 'サインアップ',
    'LBL_PORTAL_NO_EMAIL' => 'Eメールを受け取りましたか？',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'パスワードを忘れた場合',
    'LBL_PORTAL_FORGOT_USERNAME' => 'ユーザ名を忘れた場合',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'パスワードを2回入力してください。2つのパスワードは一致しなければなりません。',
    'LBL_PORTAL_RESET_PASSWORD' => 'パスワードのリセット',
    'LBL_PORTAL_REENTER_PASSWORD' => 'パスワードの再入力',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'パスワードが一致していません。再入力してください。',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'パスワードがリセットされました。',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'エラーが発生しました。パスワードのリセットを新たに依頼してください。',
    'LBL_PORTAL_SIGNUP_PROCESS' => '登録中',
    'LBL_PORTAL_SIGNUP_TITLE' => 'サインアップありがとうございます',
    'LBL_PORTAL_SIGNUP' => '詳細情報の確認後にご連絡します。',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => '名',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => '姓',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'ユーザ名',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'Eメールアドレス',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (オプション)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => '国',
    'LBL_PORTAL_SIGNUP_STATE' => '都道府県',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => '会社名',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => '職位',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'パスワード',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'パスワードの確認',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'ログイン情報を忘れた場合',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'パスワードを忘れましたか？',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'パスワードをリセットするには、Sugar 管理者にお問い合わせください。',
    'LBL_PORTAL_LOGIN_USERNAME' => 'ユーザ名',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'パスワード',
    'LBL_PORTAL_LOADING' => '読み込み中',
    'LBL_PORTAL_SAVING' => '保存中',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'ページは使用不可です',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "すみませんがこの機能は今回は使用不可です。",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => '"{query}"に関しての検索結果を表示',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'Eメールを受け取りませんでしたか？',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'サポートが必要な場合や当社にお問合せいただく場合は、以下のいずれかの方法でご連絡ください。',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => '電話: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'Eメール: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'ウェブサイト: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'チャットを閉じます、よろしいですか？',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'メモの作成または添付ファイルの追加',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'メモの追加',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'ログインできませんでした。もう一度お試しください。',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => '無効な認証',
    'LBL_PORTAL_INVALID_GRANT' => 'セッションの有効期限が切れました。もう一度ログインしてください。',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'セッションの有効期限が切れました',
    'LBL_PORTAL_AUTH_FAILED' => 'クライアント認証に失敗しました。',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => '無効なクライアント',
    'LBL_PORTAL_INVALID_REQUEST' => 'リクエストは無効または不正な形式である。テクニカルサポートに連絡してください。',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => '無効なリクエスト',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'リクエストはタイムアウトしました。',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'リクエストがタイムアウト',
    'LBL_PORTAL_UNAUTHORIZED' => 'すみませんが、このリソースへのアクセスが許可されていないようです。',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => '権限がありません',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'リソースはありません。',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => '禁止',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'このリソースにはHTTPメソッドは許可されていません。テクニカルサポートに連絡してください。',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'メソッドは許可されていません',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'リクエスト失敗。もしくは失われた/無効なパラメータ。テクニカルサポートに連絡してください。',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'エラー：',
    'LBL_PORTAL_MIN_MODULES' => 'このアプリケーションを使用するために、最低ケースとバグもしくはナレッジベースモジュールが必要です。',
    'LBL_PORTAL_ERROR' => 'エラー',
    'LBL_PORTAL_ROUTE_ERROR' => 'モジュールのロードに問題。後でもう一度試すかサポートに連絡してください。',
    'LBL_PORTAL_OFFLINE' => '申し訳ございませんがアプリケーションは使用不可です。サイトの管理者に連絡してください。',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'パスワード変更',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'ユーザ名はすでにシステムに登録されています。紛失したパスワードを請求するか、または別のユーザ名を選択してください。',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => '入力されたEメールは無効です。',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'パスワードが一致しません。',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'サービスコンソール',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => '概要',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'デフォルトのダッシュボードに戻す',
    'LBL_UNTITLED' => '名称未設定',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'コンソールの更新',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'オーバービュー',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'ステージ/ステータス',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => '名前/アカウント名',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'オムニチャネルのダッシュボード',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => '顧客',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}}、{{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'お使いのブラウザは SugarLive に対応していません。Google Chrome または Mozilla Firefox を使用してください。',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'あなたの会話詳細を含む  <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> が作成されました。',
    'LBL_OMNICHANNEL_SUBJECT' => '件名',
    'LBL_OMNICHANNEL_DESCRIPTION' => '詳細',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'メッセージの要約',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => '電話要約',
    'LBL_OMNICHANNEL_LINK_TO' => '{{fromModule}} から {{toModule}} へのリンク',
    'LBL_OMNICHANNEL_LINK_RECORD' => '{{module}} へのリンク',
    'LBL_OMNICHANNEL_LINKED' => 'リンク済み',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'ご利用のブラウザはチャットに対応していません。Google ChromeまたはMozilla Firefoxを使用してください。',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'ヘルプが必要な場合は、担当のSugar管理者にお問い合わせください。',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'レイアウトの設定',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => '発信コールを行う前に、SugarLiveの設定を完了してください。',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'SugarLiveを開く前に、SugarLiveの設定を完了してください。',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'SugarLiveレイアウトを設定する前に、SugarLiveの自分のステータスを「オフライン」に設定してください。',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'コンパクトビュー',
    'LBL_OMNICHANNEL_FULL_VIEW' => '全画面',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDRダッシュボード',
    'LBL_SALES_MANAGER_CONSOLE' => 'セールスマネージャーダッシュボード',
    'LBL_SALES_REP_CONSOLE' => '販売担当者ダッシュボード',
    'LBL_MARKETING_CONSOLE' => 'マーケティングダッシュボード',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'カスタマーサクセスダッシュボード',
    'LBL_EXECUTIVE_CONSOLE' => 'エグゼクティブダッシュボード',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'タブをデフォルトに戻す',
    'LBL_CONFIGURE_SUMMARY_PANEL' => '設定の概要パネル',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'ユーザプロフィール',
    'LBL_WIZ_COMPLETE_TITLE' => '設定完了',
    'LBL_SETUP_COMPLETE_INFO' => 'Sugarを使い始めましょう！',
    'LBL_SETUP_USER_INFO' => 'ユーザー情報を設定',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'ユーザーロケール設定',
    'LBL_SETUP_USER_LOCALE_INFO' => 'タイムゾーン、日付、名前フォーマットを設定',
    'LBL_WIZ_START_SUGAR' => 'Sugarを始める',
    'LBL_WIZ_FIRST_NAME' => '名',
    'LBL_WIZ_LAST_NAME' => '姓',
    'LBL_WIZ_EMAIL' => 'Eメール',
    'LBL_WIZ_TIMEZONE' => 'タイムゾーン',
    'LBL_WIZ_TIMEFORMAT' => '時間フォーマット',
    'LBL_WIZ_DATE_FORMAT' => '日付フォーマット',
    'LBL_WIZ_NAME_FORMAT' => '名前フォーマット',
    'LBL_SETUP_PROGRESS' => '進捗',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugarトレーニング',
    'LBL_WIZ_DOCUMENTATION' => 'ドキュメンテーション',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'ナレッジベース',
    'LBL_WIZ_FORUMS' => 'フォーラム',
    'TPL_TIMEZONE_DIFFERENT' => 'ブラウザのタイムゾーンは保存されているタイムゾーンと一致しません。{{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'タイムゾーンを調整する',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'ロケール設定',
    'LBL_WIZ_EMAIL_SETTINGS' => 'Eメール設定',
    'LBL_WIZ_IMPORT_DATA' => 'データのインポート',
    'LBL_WIZ_CREATE_USERS' => 'ユーザ作成',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'システム設定',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'スタジオ',

    'LBL_CSP_ERROR_MESSAGE' => '入力した値はサポートされていないか、許容される形式を満たしていません。許容される値と形式の一覧は、 <a href="{{linkToDocumentation}}" target="_blank">システム</a> ドキュメントを参照してください。',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'このコンテンツは未承認です。ご利用のシステムの <a href="{{linkToDocumentation}}" target="_blank">コンテンツのセキュリティポリシー設定</a>を更新してください。',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'このコンテンツは未承認です。<a href="{{linkToDocumentation}}" target="_blank">コンテンツのセキュリティポリシー設定</a>を更新するには、管理者にお問い合わせください。設定が更新されたら、変更を有効にするためにブラウザを更新する必要があります。',

    // For password related labels
    'LBL_PASSWORD' => 'パスワード',
    'LBL_CHANGE_YOUR_PASSWORD' => 'パスワードを変更する',
    'LBL_PASSWORD_REQUIREMENTS' => 'パスワードの要件',
    'LBL_CURRENT_PASSWORD' => '今のパスワード',
    'LBL_NEW_PASSWORD1' => '新パスワード',
    'LBL_NEW_PASSWORD2' => 'パスワードの確認',
    'LBL_PASSWORD_CHANGED' => 'パスワードは正常に変更されました',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => '確認のため再度パスワードを入力してください。',
    'ERR_ENTER_NEW_PASSWORD' => '新しいパスワードを入力してください。',
    'ERR_ENTER_OLD_PASSWORD' => '古いパスワードを入力してください。',
    'ERR_REENTER_PASSWORDS' => '新しいパスワードと確認パスワードが一致しません。',
    'ERR_PASSWORD_MISMATCH' => 'パスワードがシステム内でマッチしません。',
    'LBL_CANNOT_SEND_PASSWORD' => 'パスワードを送信できません',
    'LBL_REQUEST_PASSWORD' => 'パスワードをリクエストする',
    'LBL_RESET_PASSWORD' => 'パスワードのリセット',
    'LBL_RESET_PASSWORD_MESSAGE' => 'ユーザ名を入力すると、パスワードをリセットするためのリンクが送信されます。',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Eメールを確認してください<br><br>登録されたEメールアドレス宛てに、パスワードのリセット方法を送信しました。',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'エラー：このユーザーのパスワードアップデートに問題がありました。',
    'LBL_INCORRECT_PASSWORD' => 'エラー：パスワード間違い',
    'LBL_PASSWORD_ENFORCE_TITLE' => '指定されたパスワードは必要条件に合いません。再度試みてください。',
    'LBL_PASSWORD_MIN_LENGTH' => '最小の長さは{0}です。',
    'LBL_PASSWORD_MAX_LENGTH' => '最大の長さは{0}です。',
    'LBL_PASSWORD_ONE_UPPERCASE' => '少なくとも１つの大文字の英字を含む(A-Z)。',
    'LBL_PASSWORD_ONE_LOWERCASE' => '少なくとも１つの小文字の英字を含む(a-z)。',
    'LBL_PASSWORD_ONE_NUMBER' => '少なくとも１つの数字を含む(0-9)。',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => '少なくとも１つの特殊文字を含む(~!@#$%^&*()_+-={}|)。',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'パスワードは、次の正規表現パターンと同一にできません: {0}。',

    'LBL_PREFERRED_LANGUAGE' => '言語の設定:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'パスワードのリセットメールを送信できませんでした。',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'レポートを選択',
    'LBL_REPORT_AUTO_REFRESH' => '自動更新',
    'LBL_REPORT_EDIT' => '選択したレポートを編集',
    'LBL_REFRESH_LIST_AND_CHART' => 'リストと図を更新',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'チャートがありません。',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'このレポートにフィルターが含まれていません。',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => '実行時のフィルターのみ非表示になっています。高度なフィルターを参照してください。',
    'LBL_RUNTIME_FILTERS' => 'ランタイムフィルター',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => '日付がユーザーの希望する日付形式と一致しません：',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'このダッシュレットにはランタイムフィルターがありません',
    'LBL_DASHBOARD_FILTER_GROUP' => '新規フィルター',
    'LBL_RUNTIME_FILTER_LIMITATION' => '少なくとも1つの値を選択する必要があります。',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'デフォルトのフィルターにリセットする',
    'LBL_COPY_FILTER_SUMMARY' => 'フィルターの概要のコピー',
    'LBL_APPLY_FILTERS' => '適用',
    'LBL_REPORTS_FILTERS' => 'フィルター',
    'LBL_RUNTIME_FILTERS_INVALID' => 'ランタイムフィルターが無効な値のため適用できません',
    'LBL_RUNTIME_FILTERS_COPIED' => 'フィルターの概要をクリップボードにコピーしました。',
    'LBL_ADVANCED_FILTERS' => '高度なフィルター',
    'LBL_ADVANCED_OR_DESC' => 'いずれかの条件を満たしたときに含める',
    'LBL_ADVANCED_AND_DESC' => 'すべての条件を満たしたときに含める',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'これはオリジナルデザインのフィルターです',
    'LBL_AND_UPPERCASE' => 'AND',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'この機能は、プレビューモードでは使用できません',
    'LBL_REPORT_DEFAULT_NAME' => '無題のレポート',
    'LBL_REPORT_QUERY' => 'クエリ',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => '現在のレコードに関連する',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'リンクされたフィールド',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'リンクされたフィールドは空にできません',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'レポートが選択されていません。',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => '折れ線グラフはこのレポートと互換性がありません',
    'LBL_REPORT_DASHLET' => 'レポートダッシュレット',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'データテーブル',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'ランタイムフィルター',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'データテーブルのプレビュー',
    'LBL_REPORTS_DASHLET_CHART' => 'チャート',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'チャートのプレビュー',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'フィルターのプレビュー',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => '選択されたレポートは、チャートをサポートしていません。',
    'LBL_REPORTS_DASHLET_LABELS' => 'ラベル',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => '合計レコード数を表示する',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'ソート順序',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'デフォルトの選択済みビュー',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'プライマリーチャートソートオーダー',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'セカンダリーチャートソートオーダー',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => '選択されたレポートへの {{module}} リンクがありません',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'このレポートタイプでは使用できません',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'この機能は、チャートタブでのみ使用できます',
    'LBL_REPORTS_CHART_TYPE' => 'グラフタイプ',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => '棒グラフの値配置',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => '合計を表示',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'レジェンドを表示',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'X軸ラベルを表示',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Y軸ラベルを表示',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => '行数の表示制限',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'これらのランタイムフィルターを使用する権限がありません。',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => '不明',
    'ERR_HTTP_DEFAULT_TITLE' => '不明なエラー',
    'ERR_HTTP_DEFAULT_TEXT' => '不明なエラー',
    'ERR_HTTP_DEFAULT_ACTION' => '前のページに戻る',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'エラー: 無効な要求',
    'ERR_HTTP_400_TEXT_LINE1' => 'お使いのブラウザーがサーバーに理解できない要求を送信しました。',
    'ERR_HTTP_400_TEXT_LINE2' => '詳細については、担当の Sugar 管理者にお問い合わせください。',
    'ERR_HTTP_400_ACTION' => '前のページに戻る',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'データがありません',
    'ERR_HTTP_404_TEXT_LINE1' => 'ページは存在しないか、アクセス権限がありません。',
    'ERR_HTTP_404_TEXT_LINE2' => 'もう一度やり直してください。エラーが引き続き発生する場合は、Sugar の管理者に問い合わせてください。',
    'ERR_HTTP_404_ACTION' => '前のページに戻る',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 内部サーバエラー',
    'ERR_HTTP_500_TEXT_LINE1' => 'サーバー エラーのため要求を完了できませんでした。',
    'ERR_HTTP_500_TEXT_LINE2' => 'もう一度やり直してください。エラーが引き続き発生する場合は、Sugar の管理者に問い合わせてください。',
    'ERR_HTTP_500_ACTION' => 'テクニカルサポートに連絡してください。',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 内部サーバエラー',
    'ERR_HTTP_502_TEXT_LINE1' => 'サーバーで一時的なエラーが発生したため、要求を完了できませんでした。',
    'ERR_HTTP_502_TEXT_LINE2' => 'もう一度やり直してください。エラーが引き続き発生する場合は、Sugar の管理者に問い合わせてください。',
    'ERR_HTTP_502_ACTION' => 'テクニカルサポートに連絡してください。',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 内部サーバエラー',
    'ERR_HTTP_503_TEXT_LINE1' => 'サーバーが利用できないため、要求を完了できません。',
    'ERR_HTTP_503_TEXT_LINE2' => '後ほどもう一度やり直してください。エラーが引き続き発生する場合は、Sugar の管理者に問い合わせてください。',
    'ERR_HTTP_503_ACTION' => 'テクニカルサポートに連絡してください。',

    'ERR_RENDER_FAILED_TITLE' => 'レンダーリング閲覧に失敗',
    'ERR_RENDER_FAILED_MSG' => 'レンダーリングを見るのに失敗',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'フィールドレンダーリングに失敗',
    'ERR_RENDER_FIELD_FAILED_MSG' => '{0}フィールドのレンダーリングができません。',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'アクセス拒否',
    'ERR_NO_VIEW_ACCESS_REASON' => 'このページにアクセスする許可がありません。',
    'ERR_NO_VIEW_ACCESS_ACTION' => '管理者に連絡してアクセスを要求してください。',
    'ERR_NO_VIEW_ACCESS_MSG' => '{0}',

    'ERR_LAYOUT_RENDER_TITLE' => 'レイアウトレンダーリングに失敗',
    'ERR_LAYOUT_RENDER_MSG' => '何もレンダーリングできませんでした。後でもう一度試すかサポートに連絡してください。',
    'ERR_INTERNAL_ERR_MSG' => '内部のエラー',
    'ERR_GENERIC_TITLE' => 'エラー',
    'ERR_CONTACT_TECH_SUPPORT' => 'テクニカルサポートに連絡してください。',

    'LBL_SYNCED_RECURRING_MSG' => '外部のクライアントから同期されていますので、このレコードを編集できません。',
    'LBL_EXISTING' => '存在する',
    'LBL_PANEL_DEFAULT' => 'デフォルト',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'サーバーからの悪いレスポンス',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'AssignTo 操作中にエラーが発生しました。',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => '"{{name}}"にアクセスする権限がありません。管理者に連絡してください。',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => '{0}年',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => '更にアクション',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'アラート',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => '重複を無視して保存',
    'LBL_RESTORE' => 'リセットして元に戻す',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => '消去用にマークされたレコード',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => '情報を消去するデータプライバシー要求に関連するレコードを '
        . '表示します。',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSSフィード',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => '外部RSSやブログフィードを追加して最新情報をウォッチする',
    'LBL_RSS_FEED_URL' => 'フィードURL',
    'LBL_RSS_FEED_AUTHOR' => '作成者',
    'LBL_RSS_FEED_ENTRIES_COUNT' => '表示するエントリー数',
    'LBL_ERR_LOADING_RSS_FEED' => 'RSSフィードをロードするのに失敗',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => '私のアイテム',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'チームのアイテム',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'ユーザーが Sugar アプリケーションをダッシュボードに追加できるようにします',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => '履歴',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => '過去のミーティング、電話、送受信したメールの履歴を表示する',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'Eメール',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'Eメール',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => '私の履歴',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'チームの履歴',
    'LBL_UNASSIGNED' => 'アサインされていない',
    'LBL_ARCHIVE_EMAIL' => 'Eメールアーカイブ',
    'LBL_EMAIL_ARCHIVED' => 'アーカイブされたEメール',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'アーカイブされたEメールを作成します。',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'アクティビティ予定',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'ミーティングや電話の予定を表示する',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => '今日',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => '将来',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => '私のアクティビティ',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'チームのアクティビティ',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => '保留中',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => '{0}をクローズとしてマークしますか？',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'アクティブなタスク',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => '締切りもしくは締切り間近のタスクやTo Doタスクを表示する',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => '締め切りは今',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => '今度の',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'To Do',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => '完了',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => '{0}を完了としてクローズしますか？',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => '私のタスク',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'チームのタスク',
    'LBL_LIST_REMOVE_EMAIL_INFO' => '変更中のレコードに追加のEメールがありました。これがプライマリとなり以下に追加されています。',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'アクティブではないタスク',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => '延期された、もしくは完了したタスクを表示する',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => '延期',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => '完了',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => '最後の変更 {{relativetime}} 日付 {{date}} 時間 {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => '私のタスク',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'チームのタスク',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => '最近閲覧したケース',

    'LBL_REPORT_DASHLET_TITLE_12' => 'ステータス別ユーザー別オープンケース',
    'LBL_REPORT_DASHLET_TITLE_125' => '週ごとのビジネスセンター別の新しいケース',
    'LBL_REPORT_DASHLET_TITLE_126' => '最近作成されたケース',
    'LBL_REPORT_DASHLET_TITLE_127' => '週ごとの顧客ティア別の新規ケース',
    'LBL_REPORT_DASHLET_TITLE_128' => '顧客ティアおよび優先度別にケースを開く',
    'LBL_REPORT_DASHLET_TITLE_129' => 'ビジネスセンターで今月解決した総ケース数',
    'LBL_REPORT_DASHLET_TITLE_130' => 'エージェントごとの今月解決した総ケース数',
    'LBL_REPORT_DASHLET_TITLE_131' => '最近解決したケースの一覧',
    'LBL_REPORT_DASHLET_TITLE_132' => '今月解決したケース（週別）',
    'LBL_REPORT_DASHLET_TITLE_133' => '本日および期限切れのケース',
    'LBL_REPORT_DASHLET_TITLE_134' => '本日および期限切れのすべてのケース',
    'LBL_REPORT_DASHLET_TITLE_135' => 'フォローアップ日別のオープンケース',
    'LBL_REPORT_DASHLET_TITLE_136' => 'フォローアップ日別のすべてのオープンケース',
    'LBL_REPORT_DASHLET_TITLE_137' => 'ステータス別のオープンケース',
    'LBL_REPORT_DASHLET_TITLE_138' => 'ステータス別の先週のケース',
    'LBL_REPORT_DASHLET_TITLE_139' => '自分に割り当てられたオープンタスクのステータス',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAPまたは古いREST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cronジョブ',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => '論理フック',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugarワークフロー',
    'LBL_AUDIT_SUBJECT_USER' => 'ユーザ',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web to Lead',

    //common chart strings
    'LBL_CHART' => 'チャート',
    'LBL_CHART_NO_DATA' => 'データがありません',
    'LBL_CHART_LEGEND_CLOSE' => 'レジェンドを隠す',
    'LBL_CHART_LEGEND_OPEN' => 'レジェンドを表示',
    'LBL_CHART_CONTROLS_CLOSE' => 'コントロールを隠す',
    'LBL_CHART_CONTROLS_OPEN' => 'コントロールを表示',
    'LBL_CHART_UNDEFINED' => '未定義',
    'LBL_CHART_NO_LABEL' => '未定義',
    'LBL_CHART_AMOUNT' => '金額',
    'LBL_CHART_COUNT' => 'カウント',
    'LBL_CHART_PERCENT' => 'パーセント',
    'LBL_CHART_GROUP' => 'グループ',
    'LBL_CHART_DATE' => '日付',
    'LBL_CHART_KEY' => 'キー',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'チャートタイプ',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'タイトルを表示',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => '合計を表示する',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'X軸ラベルを表示',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Y軸ラベルを表示',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'ディスプレイ方法をチェック',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'ラップティック',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'スタガーティック',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'ローテイトティック',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => '棒グラフの値配置',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => '棒グラフ表示オプション',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'スクロールを許可',
    'LBL_CHART_CONFIG_STACK_DATA' => 'スタックデータ系列',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => '空のグループを隠す',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => '送付済',
    'LBL_EMAIL_RECV' => 'rec',

    //record save
    'LBL_RECORD_SAVED' => 'レコードは保存されました。', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => '{{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a>の作成に成功しました。', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => '{{moduleSingularLower}} の作成に成功しました。',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'このレコードの作成に成功しましたが、アクセスする権限はありません。', // use when user has no access to the model
    'LBL_VALIDATING' => '有効化中',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => '成功：',
    'LBL_ALERT_TITLE_WARNING' => '危険：',
    'LBL_ALERT_TITLE_NOTICE' => '注意：',
    'LBL_ALERT_TITLE_ERROR' => 'エラー：',
    'LBL_ALERT_TITLE_LOADING' => '読み込み中',
    'LBL_ALERT_NO_ACCESS' => 'このダッシュレットに適用されるフィルターへのアクセス権限がありません。',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'ダッシュボードを複製してこのダッシュレットを独自のフィルタで構成してください。',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'ブラウザのバージョンがサポートされていないか、サポートされていないブラウザを使用しています。',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'サポートされているプラットフォーム',
    'LBL_ALERT_CONFIRM_DELETE' => '本当にこの項目を削除しますか？',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => '本当にこれらの項目を削除しますか？',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => '選択されたレコードは下記の値を上書きします：{{values}}。キャンセルして現在の値をそのままにするか、確認して新しい値で上書きしてください。',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => '選択された{{moduleSingularLower}}は関連する値があります: {{values}}。 キャンセルして現在の値をそのままにするか、確認して新しい値で上書きしてください。',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'から',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'To:',

    //organization chart
    'LBL_ORG_CHART' => '組織図',
    'LBL_ORG_CHART_DESC' => '組織図を表示する',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'トグルオリエンテーション',
    'LBL_ORG_CHART_TOOLTIP_NODES' => '全てのノードを表示',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'ズームしてフィットする',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'ケースサマリー',
    'LBL_CASE_SUMMARY_CHART_DESC' => '関係するケースの概要を表示',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => '概要',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'クローズされたケース',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => '未完了のケース',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'TOP10商談品目',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'トップ10の商談品目をバブルチャートで表示する',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => '私の高収益商品',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "チームの商談品目",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'デフォルト日付フィルタ',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'デフォルトデータセット',

    'LBL_PRODUCT_CATALOG_NAME' => '商品カタログ',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => '商品カタログ',
    'LBL_PRODUCT_CATALOG_DESC' => '商品カタログからアイテムを表示および追加する。',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => '商品カタログから項目を表示および追加する。',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}}　日付 {{date}} 時間 {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'メモをタイプするか添付をドラッグアンドドロップしてください。@をタイプするとユーザーをメンションします。#をタイプするとレコードを参照します。',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'コメントを追記して下さい。@をタイプするとユーザーをメンションします。#をタイプするとレコードを参照します。',
    'LBL_ACTIVITY_STREAM' => 'アクティビティストリーム',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'アクティブストリームは有効になっていません',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'アクティブストリームはこのモジュールでは有効になっていません',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'その他の投稿',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => '以下の時間に',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => '私のアクティブストリーム',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'レコードに対して実行された操作や投稿されたコメントの一覧を表示する',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'アクティブストリームが無効になっています',

    'LBL_DATA_VIEW' => 'データービュー',
    'LBL_COMMENT' => 'コメント',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'サーバーに接続中にエラーが生じました。もう一度行ってください。',
    'ERR_RESOLVE_ERRORS' => '進める前にエラーを解決してください。',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => '承認するには、すべての必須フィールドが入力される必要があります。ただし、このレコードを拒否またはルーティングすることもできます。',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => '拒否/ルーティングするには、すべての必須フィールドが入力される必要があります。',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'リストの更新',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'タイルを更新',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => '非表示のテキストを表示',
    'LBL_TEXTAREA_LESS' => 'テキストを非表示に戻す',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} 添付',
    'LBL_CREATE_ATTACHMENT' => '添付を作成',
    'LBL_DASHLET_REFRESH' => '更新',
    'LBL_DASHLET_MOVE' => '移動',
    'LBL_DASHLET_CLOSE' => '閉じる',

    'LBL_DASHLET_FORECAST_NAME' => '売上予測中',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => '売上予測バーチャート',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => '売上予測バーチャート',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => '以下の売上予測',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => '指定された期間内の売上予測バーチャートを表示する',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'グループ',
    'LBL_DASHLET_FORECASTS_DATASET' => 'データセット',
    'LBL_DASHLET_FORECASTS_DETAILS' => '売上予測詳細',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => '現在の売上予測詳細を表示する',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => '保存されたレポートチャートダッシュレット',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => '保存されたレポートから表を表示',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => '公開された関連記事',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => '履歴概要',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => '更に履歴',
    'LBL_RELATED_CONTACT' => '関連する担当者',
    'LBL_MODULE_TYPE' => 'タイプ',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'Eメール宛先',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'Eメール元',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'レガシーモジュールはプレビューできません。',

    //SFA
    'LBL_BEST' => 'ベスト',
    'LBL_WORST' => 'ワースト',
    'LBL_LIKELY' => '達成可能',
    'LBL_BEST_FORECAST' => 'コミットメント(最高)',
    'LBL_WORST_FORECAST' => 'コミットメント(最低)',
    'LBL_LIKELY_FORECAST' => 'コミットメント(可能性が高い)',
    'LBL_BEST_ADJUSTED' => '調整済みコミットメント(最高)',
    'LBL_WORST_ADJUSTED' => '調整済みのコミットメント(最低)',
    'LBL_LIKELY_ADJUSTED' => '調整済みのコミットメント(可能性が高い)',
    'LBL_AMOUNT_USDOLLAR' => '変換された金額',
    'LBL_OVERDUE' => '期限切れ',

    'LBL_PASSWORD_REQUEST_SENT' => '依頼が送信されました。',
    'LBL_PASSWORD_REQUEST_ERROR' => 'ユーザー名とEメールの組み合わせに問題があります。',

    'LBL_REMINDER_TITLE' => 'リマインダ',
    'LBL_CLICK_TO_DRILLDOWN' => 'クリックしてドリルダウン',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => '全ての言語を使用不可にはできません。',

    'LBL_UPDATE_CALC_FIELDS' => '値を再計算',

    //Optimistic Locking
    'LBL_YOU' => 'あなた',
    'LBL_RESOLVE_CONFLICT' => '{{name}}の競合を解決する',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => '更なる情報は下記を参照 {{{more_info_url}}} {{plural_module_name}} ドキュメンテーション。{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'データがありません',
    'LBL_NEED_HELP' => '新しいモノ/サービスにヘルプが必要ですか？',
    'LBL_NEW_CASE' => 'ケース作成',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'ヘルプダッシュレットは、現在閲覧しているモジュールに関連する、より多くの情報のためのアプリケーションガイドの対応するドキュメントへのリンクと一緒に表示されている特定の情報を（例えば、リードドキュメンテーション）を提供します。',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'リストビューヘルプ',
    'LBL_HELP_RECORDS' => "モジュールのリストビューは現在の検索条件に合いユーザーのアクセスできるレコードを全て表示します。レコードの基本的詳細はリストビューのカラムもしくはレコードの名前をクリックしてレコードビューを開く事により閲覧ができます。",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'レコードビューヘルプ',
    'LBL_HELP_RECORD' => 'このレコードビューは、徹底した個々のレコードについての情報だけでなく、それにリンクされたレコードのいくつかの詳細を提供します。
- 個々のフィールドまたは「編集」ボタンをクリックして、このレコードのフィールドを編集します。
- 表示または左下のペインに「データビュー」をトグルすることによってサブパネル内の他のレコードへのリンクを変更します。
- 左下のペインに「アクティビティストリーム」をトグルすることによって、ユーザーのコメントやビューレコードの変更履歴と対話します。
- レコード名の右にあるアイコンを使用して、このレコードをフォローするか、お気に入りにします。
- 追加のアクションは、「編集」ボタンの右にあるドロップダウンの操作メニューで利用できます。',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}} 作成',
    'LBL_HELP_CREATE' => '{{plural_module_name}} を作成するには：
1. 必要に応じてフィールドの値を指定します。
 *「必須」フィールドは保存前に入力完了してください。
 * 必要に応じて、追加のフィールドを展開する「更に表示」をクリックします。
2. 新しいレコードを確定し、{{plural_module_name}} リストビューに戻るには「保存」をクリックします。',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => '潜在的重複を検知',
    'LBL_HELP_DUPLICATE' => 'Sugar は、作成しようとしているレコードが既に存在する可能性があることを検出しました。 

新しいものを作成するのではなく、既存のレコードを変更するには、目的のレコード右側の [選択と編集] をクリックします。既存のレコードの空白のフィールドに入力した値が表示されます。[保存] をクリックして既存のレコードを変更します。

代わりに、既存のレコードの値ではなく今入力した値を使用する場合は、[元にリセット] をクリックします。入力した値は既存のレコードに適用され、さらに追加の変更を加え、既存のレコードへの変更を確定する[保存] をクリックします。入力した値を使用して新しいレコードを作成するには、画面右上の[重複を無視して保存」をクリックします。',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => '失われたSMTPサーバー設定',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'レコードアサイン通知を送るには、SMTPサーバが{{emailSettingsUrl}} で設定されていなければなりません。',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'Eメール設定',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => '新しい株式レポートがあります',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => '新しい株式レポートは次にあります',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'レポートモジュール',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'それらは「株式レポート」としてタグ付けされており、フィルターすることが可能です。また、レポートは内容に応じて「売り上げとマーケティング」または「カスタマーサービス」、「データプライバシー」、「管理」ともタグ付けされています。詳しくは次を参照してください。',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'ドキュメント',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRMは生産性を高めるためにキーボードショートカットでタスクをすぐに実行できるようにしています。右のテーブルには使用可能なショートカットとアクションのキーがあります。',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>対応キー</h1><ul><li>英数字および記号すべて</li><li>shift、ctrl、alt、command、mod (Windows/Linux は ctrl、Mac はcommand)</li><li>enter、esc、space、tab、pageup、pagedown、end、home、ins、del、backspace</li></ul><h1>対応の機能</h1><ul><li>キーの組み合わせ: ctrl+m</li><li>複数キー: m、ctrl+m</li><li>キーシーケンス: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'グローバルショートカット',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'コンテクストショートカット',
    'LBL_SHORTCUT_KEY_KEY' => 'キー',
    'LBL_SHORTCUT_FUNCTION' => '機能',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'コンテクストショートカットの設定',
    'LBL_SHORTCUT_CONFIG_DISABLED' => '設定するコンテクストショートカットがありません',
    'LBL_SHORTCUT_HELP' => 'ショートカットヘルプページを表示',
    'LBL_SHORTCUT_QUICK_CREATE' => 'クイック作成メニューをトグル',
    'LBL_SHORTCUT_SEARCH' => 'グローバル検索フィールドをフォーカス',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'トグルサイドバー',
    'LBL_SHORTCUT_CREATE_RECORD' => '新規レコードを作成',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'リストの次のレコードを選択',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'リストの以前のレコードを選択',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'リストを左にスクロール',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'リストを右にスクロール',
    'LBL_SHORTCUT_OPEN' => 'リストの選択されたレコードを開く',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'リストの選択されたレコードを編集',
    'LBL_SHORTCUT_RECORD_DELETE' => 'レコードを削除',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => '保存せずにリストインラインモードから退出する',
    'LBL_SHORTCUT_RECORD_SAVE' => 'レコードを保存',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'レコードの変更をクリア',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'レコードをお気に入りとしてマーク',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'レコードをフォロー',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'レコードをプレビュー',
    'LBL_SHORTCUT_MARK_SELECTED' => 'レコードを選択済としてマーク',
    'LBL_SHORTCUT_SELECT_ALL' => '全てを選択する',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => '一括アクションドロップダウンメニューを開く',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'リストのフィルタフィールドをフォーカス',
    'LBL_SHORTCUT_FILTER_CREATE' => '新しいリストフィルタを作成',
    'LBL_SHORTCUT_FILTER_EDIT' => '現在のリストフィルタを編集',
    'LBL_SHORTCUT_FILTER_SHOW' => 'リストフィルタメニューを開く',
    'LBL_SHORTCUT_RECORD_EDIT' => 'レコードを編集',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => '以前のレコードを開く',
    'LBL_SHORTCUT_RECORD_NEXT' => '次のレコードを開く',
    'LBL_SHORTCUT_COPY_RECORD' => '現在のレコードをコピー',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'プライマリのアクションドロップダウンメニューを開く',
    'LBL_SHORTCUT_CLOSE_DRAWER' => '引き出しを閉じる',
    'LBL_SHORTCUT_FILTER_ADD' => 'フィルタの追加条件を加える',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'フィルタから条件を削除する',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'フィルタを閉じる',
    'LBL_SHORTCUT_FILTER_SAVE' => 'フィルタを保存する',
    'LBL_SHORTCUT_FILTER_DELETE' => 'フィルタを削除する',
    'LBL_SHORTCUT_FILTER_RESET' => 'フィルタをリセットする',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => '列を追加',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => '列を削除',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => '一括アップデートを閉じる',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'レコードをアップデート',
    'LBL_CREATE_CATEGORY' => '<div class="btn-link" data-action="create-new">カテゴリー</div>を作成します',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'はい',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'キャンセル',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => '複数選択フィールドのすべての項目を選択します',
    'LBL_SHORTCUT_SWEETSPOT' => 'スイート スポット バーを切り替える',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'スイート スポット バーを隠す',
    'LBL_SHORTCUT_SAVE_CONFIG' => '設定の保存',
    'LBL_SHORTCUT_RESTORE' => 'デフォルトに復元',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'サーバーでカスタムのショートカットキーを保存中にエラーが発生しました。もう一度お試しください。',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}}設定',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}} 設定は保存されました。',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}}設定エラー',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} は設定がありません。',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'ユーザーは{{module}}へのアクセスがありません。',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'ユーザーは{{module}}設定へのアクセスがありません。',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => '{{module}}のデータベース設定は修正が必要です',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'から',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => '開始と終了日',

    'LBL_CALENDAR_START_DATE' => '開始日',
    'LBL_CALENDAR_END_DATE' => '終了日',
    'LBL_CALENDAR_DURATION' => '時間',
    'LBL_CALENDAR_RECURRENCE' => '定期的な予定',
    'LBL_CALENDAR_REMINDERS' => 'リマインダ',

    'LBL_CALENDAR_CUSTOM_DATE' => 'カスタム日',
    'LBL_CALENDAR_REPEAT_TYPE' => '繰り返す頻度',
    'LBL_CALENDAR_REPEAT_INTERVAL' => '繰り返しの間隔',
    'LBL_CALENDAR_REPEAT_DOW' => '曜日毎に繰り返し',
    'LBL_CALENDAR_REPEAT_ON' => '繰り返し',
    'LBL_CALENDAR_REPEAT' => '繰り返し',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => '以下まで繰り返し',
    'LBL_CALENDAR_REPEAT_COUNT' => '繰り返し回数',
    'LBL_CALENDAR_REPEAT_SELECTOR' => '繰り返しセレクタ',
    'LBL_CALENDAR_REPEAT_DAYS' => '日',
    'LBL_CALENDAR_REPEAT_MONTH' => '年の月',
    'LBL_CALENDAR_REPEAT_ORDINAL' => '繰り返し (通常)',
    'LBL_CALENDAR_REPEAT_UNIT' => '繰り返し (ユニット)',
    'TPL_REPEAT_INTERVAL' => '{{repeatIntervalValue}} {{repeatTypeValue}} ごとに',
    'LBL_UNSUPPORTED_RRULE' => 'このシリーズはカレンダークライアントから同期されたため、Sugarでは使用できない「繰り返し」オプションを使用します。特定の日付で繰り返したい場合は、カレンダークライアントでこのシリーズを編集してください。このシリーズをSugarで編集すると、「繰り返し」が「なし」に設定されます。<br><br>続行しますか？',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => '定期的な予定の変更は、一連の最初のレコードを使用しなければなりません。',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => '繰り返しルールではイベントは作成されません。',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => '参加',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => '不参加',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => '暫定',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => '返事無し',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'スケジュール不可',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => '使用可能なビュー',
    'LBL_CALENDAR_DASHLET_NAME' => 'カレンダースケジューラー',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'デフォルトのビュー',
    'LBL_CALENDAR_MY_CALENDARS' => 'マイカレンダー',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'ユーザーおよびチームのカレンダー',
    'LBL_CALENDAR' => 'カレンダー',

    'LBL_CALENDAR_DAY' => '日',
    'LBL_CALENDAR_WEEK' => '週',
    'LBL_CALENDAR_MONTH' => '月',
    'LBL_CALENDAR_YEAR' => '年',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98回',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99回',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'スケジュール取得中にエラーが発生。',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => '保存して招待を送る',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => '出欠確認',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'プロセス',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'プロセスダッシュレットは、SugarBPM の内部で使用できるテンプレートを表示します。',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'プロセス定義',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'プロセス定義ダッシュレットは、SugarBPM の内部で使用できるテンプレートを表示します。',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'プロセス定義を作成',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'プロセス定義をインポート',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'プロセスビジネスルール',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'プロセスビジネスルールダッシュレットは、SugarBPM の内部で使用できるテンプレートを表示します。',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'プロセスビジネスルールを作成',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'プロセスビジネスルールをインポート',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'プロセスEメールテンプレート',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'プロセスEメールテンプレートダッシュレットは、SugarBPM の内部で使用できるテンプレートを表示します。',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'プロセスEメールテンプレートを作成',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'プロセスEメールテンプレートをインポート',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'Sugar の別のインスタンスでビジネス プロセス/ルール/Eメール テンプレートを開発するときは、インスタンスを生産システムの正確な複製にすることを強くお勧めします。Sugar の独立したインスタンスに構築されたプロセス/ビジネス ルール/Eメール テンプレートは、インポートが完了した後、希望した通りに機能しない可能性合があります。プロセス/ビジネス ルール/Eメール テンプレートが特定のスタジオ、またはカスタム フィールド名、データベース Id ドロップ ダウン値を含みますがこれに限定されないアプリケーションレベルの変更に依存する可能性があります。これらの値がプロセス/ビジネス ルール/Eメール テンプレートが構築されたインスタンスと同一ではない場合は、ターゲット インスタンスのプロセス/ビジネス ルール/Eメール テンプレートを手動で再構築する必要があります。',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'このインポートを続行してもよろしいですか？',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'このエクスポートを続行してもよろしいですか？',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => '次のドロップダウンフィールドに無効なオプションが含まれています',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'プロセスによる保留中のアクティビティ',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => '保留中のアクティビティ',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'プロセスによる保留中のアクティビティ',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => '全てのプロセス',
    'LBL_RECORD_DASHBOARD' => 'レコードダッシュボード',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'プロセスステータスサマリー',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'プロセスステータス詳細',

    'LBL_PMSE_IN_PROGESS_STATUS' => '進行中',
    'LBL_PMSE_COMPLETED_STATUS' => '完了',
    'LBL_PMSE_CANCELLED_STATUS' => 'キャンセル済み',
    'LBL_PMSE_TERMINATED_STATUS' => '終了',
    'LBL_PMSE_ERROR_STATUS' => 'エラー',
    'LBL_PMSE_SETTINGS' => 'SugarBPM 設定',

    'LBL_PRO_DISABLE_CONFIRMATION' => '本当にこのレコードを無効にしますか？',
    'LBL_PRO_ENABLE_CONFIRMATION' => '本当にこのレコードを有効にしますか？',
    'LBL_PRO_DELETE_CONFIRMATION' => '本当にこのレコードを削除してよいですか?',

    'LBL_PRO_ENABLE' => 'アップデート中',
    'LBL_PRO_DISABLE' => 'アップデート中',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} は処理中で、フィールドの一部がロックされている可能性があります。レコードを編集するには {{link}} をクリックしてください。',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => '実行中のプロセスで使用されているため、このフィールドはロックされています。',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'このレコードは処理中で、フィールドの一部がロックされている可能性があります。',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'ビジネスセンター',
    'LBL_BUSINESS_CENTER_ID' => 'ビジネスセンターID',
    'LBL_BUSINESS_CENTER_NAME' => 'ビジネスセンター名',

    'LBL_PLIS_ACTIVITIES' => '購入商品のアクティビティ',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(新しいタグ)',
    'LBL_TAG_FETCH_ERROR' => 'タグの取得中にエラーが発生しました。',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'SugarCRMはjavascriptが必要です。SugarCRMを使用するためにjavascriptを有効にしてください。',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'シリアル化されたデータをシリアル解除できませんでした。',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'オブジェクトやクラスへの参照が含まれているためシリアル化されたデータを解除できませんでした',

    'LBL_FIELD_TRIMMED' => '最大文字数を超えたため、フィールドはカットされました。',
    'LBL_FIELDSIZE_OVERFLOW' => 'フィールドの最大文字数制限を超えています。',
    'LBL_TINYMCE_TARGET_SAME' => '同じウインドウ',
    'LBL_TINYMCE_TARGET_NEW' => '新規ウインドウ',

    'LBL_OUTBOUND_EMAILS' => 'メール設定',
    'LBL_OUTBOUND_EMAIL' => 'メール設定',

    'LBL_EMAIL_PARTICIPANTS' => 'メール参加者',
    'LBL_EMAIL_PARTICIPANT' => 'メール参加者',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'データプライバシー',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'データプライバシー',
    'LBL_DATAPRIVACY_VIEW_PII' => '個人情報を表示',
    'LBL_DATAPRIVACY_MARKFORERASE' => '消去するようにマーク',
    'LBL_DATAPRIVACY_FIELDNAME' => 'フィールド',
    'LBL_DATAPRIVACY_VALUE' => '値',
    'LBL_DATAPRIVACY_CHANGED_BY' => '更新者',
    'LBL_DATAPRIVACY_SOURCE' => 'ソース',
    'LBL_DATAPRIVACY_CHANGE_DATE' => '最終更新日',
    'LBL_DATAPRIVACY_PII' => '個人情報',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => '消去するようにマーク',
    'TPL_DATAPRIVACY_PII_TITLE' => '{{{name}}} 用の個人情報',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'タイマー変更',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'メッセージ',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'クリップボードにコピーしました！',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'クリップボードにコピーできませんでした',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => '確認リンクのコピー',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'タイムライン',
    'LBL_NO_ACTIVITY' => 'アクティビティなし',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} タイムライン',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => '以下より多い',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => '以下より少ない',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'タイムラインには、現在のレコードの関連レコードと選択フィールドの更新情報が経時的に表示されます。',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => '更に表示...',
    'LBL_COMMENT_LOG_SHOW_LESS' => '更に表示しない...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => '利用可能なデータはありません',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'モジュールがライセンス発行されません。',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'アクティブサブスクライバー',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'このダッシュレットは、単一のアカウントにリンクするモジュールに対してのみ追加できます。詳細は、<a href={{linkToDocumentation}}>アクティブサブスクリプションのダッシュレット</a> ドキュメントを参照してください。',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'このリンク済みアカウントに属する購入を表示：',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => '特定のアカウントに対して有効なサブスクリプション。',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => '、数量{{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => '合計：',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'アクティブサブスクリプションなし',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'このダッシュレットが機能するには{{module_name}} が必要です。{{module_name}} を有効にするようにアドミニストレーターにリクエストしてください。',
    'LBL_PURCHASE_HISTORY_DASHLET' => '購入履歴',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => '特定のアカウントのすべての購入。',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'このダッシュレットは、単一のアカウントにリンクするモジュールにのみ追加できます。詳細については、<a href={{linkToDocumentation}} target="_blank">購入履歴ダッシュレット</a> ドキュメントを参照してください。',
    'LBL_NO_PURCHASE_HISTORY' => '表示する購入はありません',
    'LBL_NO_PLIS' => '購入済み商品なし',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => '合計',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => '数量',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'このダッシュレットが機能するには、購入と購入済み商品が必要です。購入と購入済み商品情報の有効化については、管理者に相談してください。',
    'LBL_SEARCH_PURCHASE_NAME' => '商品名で検索...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => '以下に移動して、Stidioを使用して記録ビューダッシュレットのレイアウトを編集します:' .
        'スタジオ>{{module}}>レイアウト>レコードビュー・ダッシュレット。<a href={{linkToStudio}}>スタジオで編集</a>。',
    'LBL_SERVICE_LEVEL' => 'サービスレベル',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => '番号',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'フォローアップ',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => '優先度/ステータス',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => '件名/説明',

//Service Duration
    'LBL_SERVICE_DURATION' => 'サービス期間',
    'LBL_SERVICE_DURATION_VALUE' => 'サービス期間値',
    'LBL_SERVICE_DURATION_UNIT' => 'サービス期間単位',
    'LBL_LOCK_DURATION' => 'ロック期間',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Amazon Connect CCPを読み込むことができませんでした。' .
        '以下を確認してください： ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">対応ブラウザ</a>。' .
        '問題が持続する場合は、Sugar 管理者にお問い合わせください。',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Sugar 管理者はあなたの Amazon Connect 用インスタンスを設定していません。',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Amazon Connect との接続の確立に失敗しました。担当の Sugar 管理者に連絡して支援を受けてください。',
    'LBL_OMNICHANNEL_UNKNOWN' => '不明',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'フォーカス ドロワ',
    'LBL_CLOSE_FOCUS_DRAWER' => 'フォーカス ドロワを閉じる',
    'LBL_EXTERNAL_GUESTS' => '外部ゲスト',
    'LBL_MY_FAVORITE_TASKS' => 'お気に入りのタスク',
    'LBL_RECORD' => 'レコード',

    'LBL_MY_TASKS' => 'マイタスク',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => '次のフィールドが見つかりませんでした: {0} モジュール内: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => '{0} を含むレコードが見つかりませんでした: {1} モジュール内: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => '次の名称の関連が見つかりませんでした: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'Id: {0}、{1} を含む: {2} モジュール内: {3} のデータベースエントリはすでに存在します',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'ソフト削除済み（削除フラグ = 1）',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => '{0} {1}、 モジュール{2} 上で複数のデータベース記録が見つかりました 。 ' .
        '一致するレコードを削除または更新してください。 一致するレコード：{3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => '次の実行',
    'LBL_TIME_AWARE_TYPE' => 'タイプ',
    'LBL_TIME_AWARE_BEAN_ID' => 'ビーンID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'ラベルを表示',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => '記録ビューを開く',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => '追加',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'ヘルプは使用できません',
    'LBL_ACTIONBUTTON_FUNCTIONS' => '機能',
    'LBL_ACTIONBUTTON_FIELDS' => 'フィールド',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'フィールドを選択...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'ロールアップ',
    'LBL_ACTIONBUTTON_RELATED' => '関連',
    'LBL_ACTIONBUTTON_SAVE' => '保存',
    'LBL_ACTIONBUTTON_CANCEL' => 'キャンセル',
    'LBL_ACTIONBUTTON_R_MODULE' => '関連するモジュール',
    'LBL_ACTIONBUTTON_R_FIELDS' => '関連フィールド',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'モジュールのロールアップ',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'フィールドのロールアップ',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => '関数のロールアップ',
    'LBL_ACTIONBUTTON_MINIMUM' => '最小',
    'LBL_ACTIONBUTTON_MAXIMUM' => '最大',
    'LBL_ACTIONBUTTON_AVERAGE' => '平均',
    'LBL_ACTIONBUTTON_SUM' => '合計',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'レコードを割り当てる',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'Eメール作成',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => '作成済みレコード',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'ドキュメントマージ',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'URLを開く',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'レポート実行',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => '記録を更新',
    'LBL_ACTIONBUTTON_ACTION' => 'アクション',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => '割り当て先',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'Eメール宛先',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'PMSEを使用する',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'テンプレート',
    'LBL_ACTIONBUTTON_MODULE' => 'モジュール',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => '表示設定',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'タイプ',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'ドロップダウン',
    'LBL_ACTIONBUTTON_BUTTON' => 'ボタン',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'ボタングループ',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => '記録にラベルを表示',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'ヘッダーにを表示',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => '編集で隠す',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'フォーカスダッシュボードヘッダーに表示',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'ダッシュボード',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'フォーカスダッシュボードヘッダー',
    'LBL_ACTIONBUTTON_SIZE' => 'サイズ',
    'LBL_ACTIONBUTTON_DEFAULT' => 'デフォルト',
    'LBL_ACTIONBUTTON_SMALL' => '小さい',
    'LBL_ACTIONBUTTON_LARGE' => '大きい',
    'LBL_ACTIONBUTTON_CALCULATED' => '計算中',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'PDFに変換',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'ドキュメントのマージ',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'プレビュー',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'プロパティ',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'ラベル',
    'LBL_ACTIONBUTTON_DESC' => 'ツールのヒント',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'ラベルを表示',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'アイコンを表示',
    'LBL_ACTIONBUTTON_SCHEME' => 'カラースキーム',
    'LBL_ACTIONBUTTON_ICON' => 'アイコン',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => '依存',
    'LBL_ACTIONBUTTON_DESIGN' => 'レイアウト構成',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'エラー時に停止',
    'LBL_ACTIONBUTTON_AUTOSAVE' => '自動保存',
    'LBL_ACTIONBUTTON_CONFIG' => 'コンフィグ',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => '保存する前にActionButtonを設定してください。',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => '設定ボタン',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => '自動作成',
    'LBL_ACTIONBUTTON_LINK' => '親との関係を作成',
    'LBL_ACTIONBUTTON_COPY_PARENT' => '親値をコピー',
    'LBL_ACTIONBUTTON_PRESET' => 'フィールド値を設定',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => '親からフィールド値をコピー',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => '選択...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => '親フィールドから ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'このボタンを削除してもよろしいですか？',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'このアクションを削除してもよろしいですか？',
    'LBL_ACTIONBUTTON_INVALID_DATA' => '無効なアクションボタンデータ',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => '保存前にモジュールを選択してください。',
    'LBL_ACTIONBUTTON_SELECT_LINK' => '保存前にリンクを選択してください。リンクが使用不可能な場合は、リンクオプションのチェックをオフにしてください。',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => '保存前に記録を選択してください。',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => '保存前にテンプレートを選択してください。',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => '第一',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => '第二',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'オーシャン',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'ピンク',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'アーミー',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'ティール',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'パシフィック',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'グリーン',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'イエロー',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'オレンジ',
    'LBL_ACTIONBUTTON_THEME_RED' => 'レッド',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'コーラル',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'パープル',
    'LBL_ACTIONBUTTON_FORMULA' => '計算式',
    'LBL_ACTIONBUTTON_ACTIONS' => 'アクション',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'ボタンデータの検証中にエラーが発生しました。',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'ボタンには、少なくともラベルまたはアイコンが設定されている必要があります。',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => '有効なボタンラベルを入力してください。',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => '必須の値がないため、レコードを作成できませんでした。管理者にお問い合わせください。',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'このボタンタイプには、少なくとも2つのアクティブなボタンが必要です。',
    'LBL_ACTIONBUTTON_RECORD' => '記録ビュー',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'アクションメニュー',
    'LBL_ACTIONBUTTON_ORDER' => '順番',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'リストビュー',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'レコードビューのヘッダー',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'レコードビューダッシュレットのヘッダー',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'サブパネル',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'タスクシーケンス実行エンジンが以下のアクションの実行に失敗しました：',
    'LBL_ACTIONBUTTON_ADD_ACTION' => '操作を追加',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'この操作を削除',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => '現在のユーザー',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'ドキュメントマージ',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'PDF にドキュメントマージ',

    //hint
    'LBL_HINT_COMPANY_SIZE' => '企業規模',
    'LBL_HINT_COMPANY_INDUSTRY' => '業界',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => '業界タグ',
    'LBL_HINT_COMPANY_LOCATION' => '会社所在地',
    'LBL_HINT_COMPANY_DESCRIPTION' => '会社概要',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => '設立年',
    'LBL_HINT_COMPANY_FACEBOOK' => '会社のFacebook',
    'LBL_HINT_COMPANY_TWITTER' => '会社のTwitter',
    'LBL_HINT_COMPANY_PIC' => '会社ロゴ',
    'LBL_HINT_CONTACT_PIC' => '担当者写真',
    'LBL_HINT_COMPANY_WEBSITE' => '会社のWebサイト',
    'LBL_HINT_PHOTO' => '写真のリンク',
    'LBL_HINT_JOB_2' => '前職',
    'LBL_HINT_EDUCATION' => '学歴',
    'LBL_HINT_EDUCATION_2' => 'その他の学歴',
    'LBL_HINT_TWITTER' => 'Twitterリンク',
    'LBL_HINT_FACEBOOK' => 'Facebookリンク',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICSコード',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SICコード',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => '決算期',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => '年間売上',
    'LBL_HINT_PHONE_1' => '電話1',
    'LBL_HINT_PHONE_2' => '電話2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'テーブル結合',
    'LBL_HINT_FULL_NAME' => '氏名',
    'LBL_HINT_JOB_TITLE' => '職務',
    'LBL_HINT_OFFICE_PHONE' => '会社電話',
    'LBL_HINT_MOBILE_PHONE' => '携帯',
    'LBL_HINT_OTHER_PHONE' => 'その他の電話',
    'LBL_HINT_WEBSITE' => 'Webサイト',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'このレコードの既存のデータをすべて、Sugar Hintで見つかった新しいデータで上書きしますか？',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'このレコードの既存の {{fieldName}} を、Sugar Hintで見つかった新しい {{fieldName}} で上書きしますか？',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'すべてのアカウント関連データが削除されます。続行しますか？',
    'LBL_HINT_COMPANY_LOGO' => 'ロゴ',
    'LBL_HINT_CONTACTS_AVATAR' => '写真',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint Accountsets タグ',

    'LBL_HINT_LOADING' => '読み込み中 ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Sugar Hintをアンインストールしています。お待ちください。',
    'LBL_HINT_VALUE_ERASED' => ' 値が消去されました ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'この情報はデータプライバシー要求を介して消去されました',

    'LBL_HINT_UNINSTALL_TITLE' => '以下のいずれかのアンインストールオプションを選択してください。',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Hintパッケージのみアンインストール',
    'LBL_HINT_UNINSTALL_FULL' => 'Hintを完全にアンインストール',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'このオプションは、Hint MLPを削除し、Sugar Hint Insightsのすべてのアクティブなサブスクリプションを無効にします。
    Hintを再インストールすると、サブスクリプションは自動的に再アクティブ化されます。',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'このオプションを選択すると、MLPの削除、すべての設定とサブスクリプション情報の削除など、Hintの完全なアンインストールが実行されます。',
    'LBL_HINT_UNINSTALL' => 'アンインストール',
    'LBL_HINT_UNINSTALL_HEADER' => 'Sugar Hintのアンインストール',
    'LBL_HINT_CANCEL' => 'キャンセル',
    'LBL_HINT_UNINSTALL_WARNING1' => '警告: 今後、Hintを使用する予定がない場合のみこのオプションを選択してください。
    アンインストールを実行する前に、Sugarデータベースの完全バックアップを完了し、Sugarをメンテナンスモードにします。',
    'LBL_HINT_UNINSTALL_WARNING2' => 'アンインストールプロセスの詳細については、',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint管理ガイド', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'を参照してください。',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Sugar Hintパッケージのみを本当にアンインストールしますか？',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Sugar Hintを完全にアンインストールしてよろしいですか？',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(注: この操作を元に戻すことはできません。)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint Fields',
    'LBL_HINT_NO_RESULTS_MSG' => '結果がありません。',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => '基本Hintパネルレイアウト',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => '取引先',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => '取引先担当者',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'リード',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => '拡張Hintパネルレイアウト',
    'LBL_HINT_CONFIG_DIR_PAR1' => '上記のHintパネルレイアウトセクションで、ドラッグアンドドロップしてフィールドを並べ替えます。',
    'LBL_HINT_CONFIG_DIR_PAR2' => '詳しい説明とデフォルトフィールド一覧については、以下を参照してください:',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' 以下をデフォルト設定に戻す:',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'モジュール。',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => '{{module}} モジュールをデフォルトに戻してもよろしいですか？',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'ここをクリック',
    'LBL_HINT_CONFIG_NAME' => 'Hint管理ガイド。',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'フィールド',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'エンリッチ化されたフィールド',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'このセクションでは、すべてのHintフィールドと、Hintによってエンリッチ化されたSugarフィールドの一覧を示します。Hintフィールドにはアスタリスク(*)が付いており、エンリッチ化されている場合のみ、Hintパネルに表示できます。',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'フィールド名',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'フィールドをエンリッチ化',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Hintで表示',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Hintパネルで表示',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'その他のSugarフィールド',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'このセクションでは、Hintによってエンリッチ化されていないすべてのSugarフィールドの一覧を示します。',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => '警告',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => '注意: Sugar Hint Insights サービスと同期しようとしています。保留中の電子メールダイジェストストーリーはすべて失われ、既存のニュースはInsightsダッシュレットから消去されます。同期が完了すると、すべてのタイプの通知が再開されます。',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'ご使用の {{_moduleSingular}} に関連する推奨企業を以下に示します。表示する企業データを選択してください。',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'アカウントが選択されていません',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => '複数のEメールが見つかりました。インポートするEメールを選択してください。',

    'LBL_HINT_HELP_MESSAGE1' => '入力されたデータに基づいて、Hintはシステム内で一致するものを見つけることができませんでした。',
    'LBL_HINT_HELP_MESSAGE2' => '人の名前とEメールアドレスを使うと、Hintで最良の結果を見つけることができます。',
    'LBL_HINT_HELP_MESSAGE3' => '会社のWebサイトのURLを使うと、Hintで最良の結果を見つけることができます。',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "あなたの {{_moduleSingular}} の会社名またはWebサイトを入力すると、Hintは追加データを検索します。",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "{{currentModule}} のEメールアドレスを入力すると、Hintは追加データを検索します。",

    'LBL_HINT_HISTORY_NONE' => '履歴ビューに使用できるデータがありません',
    'LBL_HINT_HISTORY_TITLE' => 'アクティビティ履歴',

    'LBL_HINT_PREVIEW_TITLE' => 'データのエンリッチ化',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Hintサービスのライセンスが失効しました。ライセンスの更新については、SugarCRMの管理者にお問い合わせください。',
    'LBL_HINT_PREVIEW_QUESTION' => 'Hintが、あなたとあなたの会社のために何ができるのか知りたいですか？Hintを追加するには、SugarCRMの管理者にお問い合わせください。',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'アカウント情報が見つかりません',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'エンリッチ化されたデータが見つかりました - クリックすると、すべてのエンリッチ化されたデータがレコードに保存されます。',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'クリックすると、エンリッチ化したデータをレコードに保存します。',

    'LBL_HINT_CONTACTS_TITLE' => '関連担当者',
    'LBL_HINT_CONTACTS_NONE' => '関連担当者なし',

    'LBL_HINT_NEWS' => 'ニュース',
    'LBL_HINT_GENERAL' => '一般',
    'LBL_HINT_ALL_NEWS' => 'すべてのニュース',
    'LBL_HINT_FILTER_NEWS' => 'ニュースをフィルタリング',
    'LBL_HINT_FINANCIAL_NEWS' => '金融',
    'LBL_HINT_PERSONNEL_NEWS' => '人事',
    'LBL_HINT_PRESS_RELEASES' => 'プレスリリース',
    'LBL_HINT_OTHER_NEWS' => 'その他',
    'LBL_HINT_NEWS_PLACEHOLDER' => '新しい記事を検索',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => '利用可能なニュースはありません',
    'LBL_NEW_NOTIFICATIONS' => '新規通知',
    'LBL_HINT_DASHLET_ALLOWED1' => 'Sugar Hint Insightsダッシュレットを表示するには、Sugar Hintライセンスが必要です。
    Sugar Hintライセンスの取得については、管理者にお尋ねください。',

    'LBL_HINT_FOR' => '以下のため',
    'LBL_HINT_WITH' => '以下と一緒に',
    'LBL_HINT_SHOW_ME' => '表示:',
    'LBL_HINT_NOTIFY_ME_BY' => '通知方法:',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insightsプリファレンスセンター',
    'LBL_NOTIFICATIONS_KEY_TITLE' => '初期設定オプションキー',
    'LBL_HINT_PREFERENCES' => '初期設定',
    'LBL_HINT_MINIMUM_PREFERENCES' => '削除を無効にしました。少なくとも1つの初期設定ステートメントが必要です',
    'LBL_HINT_MAXIMUM_PREFERENCES' => '追加を無効にしました。初期設定ステートメントの最大数に達しました',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Sugar Hint Insightsダッシュレットに含める',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'デスクトップ通知としてポップアップ表示',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => '常に通知を受け取るためには、すべてのブラウザとすべてのデスクトップコンピューターで通知を有効にする必要があります。',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Internet Explorerなど、一部のブラウザは通知に対応していません。通知に対応していないブラウザを使用している場合は、通知を有効にすることはできません。',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => '各通知に対して即座にメールアラートを送信',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => '毎日メールダイジェストを送信',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => '毎週メールダイジェストを送信',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => '初期設定を保存できませんでした。システムの接続を確認し、もう一度試してください。',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => '一部の必須フィールドに値がありません。初期設定を確認し、すべての必須フィールドが入力されていることを確認してください。',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'Sugar Hint Insightsのブラウザ通知を有効にしようとしています。[確認] をクリックして続行します。次に、ブラウザは、通知イベントの受信を許可するかどうかを尋ねます。',
    'LBL_HINT_PUSH_ERROR' => 'プッシュ通知プラグインが依存関係なしで {{options.type}} に登録されました。プラグインは意図したとおりに動作しません。ワーカーファイルへのパスと、サブスクリプションをサーバーに保存する方法を必ず指定してください。',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'すべてのユーザのHint通知をオンにする',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'すべてのユーザのHint通知をオフにする',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => '警告: Sugar Hintのアンインストール中に通知を無効にできませんでした。通知を無効にするには、Sugar Hint 5.4.0以降をインストールし、Sugarの管理セクションにあるSugar Hintアンインストーラーを使用して完全なアンインストールを実行します。',
    'LBL_HINT_ENRICH_ALL' => 'すべてエンリッチ',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'ヒントライセンスが必要です',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => '地図設定',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'ジオコーダーログビューア',
    'LBL_MAP_MAP' => '地図',
    'LBL_MAP_MAPS' => '地図',
    'LBL_MAP_GEOCODING_RECORD' => 'ジオコード',
    'LBL_MAP_GEOCODE_SUCCESS' => 'レコードが正常にジオコーディングされました。',
    'LBL_MAP_LATITUDE' => '緯度',
    'LBL_MAP_LONGITUDE' => '経度',
    'LBL_MAP_SEARCH_BY_ADDRESS' => '住所で検索...',
    'LBL_MAP_ALREADY_GEOCODED' => '現在のレコードはすでにジオコーディングされています。このレコードのジオコーディングを上書きしてよろしいですか？',
    'LBL_MAPS_MANUAL_GEOCODING' => '手動ジオコーディング',
    'LBL_MAP_POINT_COORDINATES' => '地図上の点の座標',
    'LBL_MAP_CALCULATING_DIRECTIONS' => '最適なルートを計算中...',
    'LBL_MAP_DIRECTIONS' => '方向',
    'LBL_MAP_DIRECTIONS_FROM_USER' => '現在のユーザから開始する方向',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'このレコードから開始する方向',
    'LBL_MAPS_RADIUS_INPUT' => '半径(0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => '郵便番号から半径の範囲',
    'LBL_MAPS_DISTANCE' => '距離',
    'LBL_MAPS_CENTER_ZIP_CODE' => '郵便番号',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => '無効な設定: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> フィールドマッピングは無効です。',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => '地図タイプ',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'ズームレベル',
    'LBL_MAPS_DASHLET' => '地図',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'ジオコーディングされたレコードを地図上に表示します。',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'このモジュールでは地図は使用できません。管理者コンソールで有効にしてください。',
    'LBL_MAP_MODULES' => 'モジュール',
    'LBL_MAP_FILTER_BY' => 'フィルター条件',
    'LBL_MAP_UNIT_TYPE' => 'ユニットタイプ',
    'LBL_MAP_UNIT_TYPE_MILES' => 'マイル',
    'LBL_MAP_UNIT_TYPE_KM' => 'キロメートル',
    'LBL_MAP_ADDRESS' => '住所',
    'LBL_MAP_NO_STARTING_POINT' => '開始地点がジオコーディングされていません。',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => '開始地点レコードがジオコーディングされていません。',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => '選択したレコードの一部はジオコーディングされておらず、地図に表示されません。',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'レコードがジオコーディングされていません。',
    'LBL_MAPS_MODULE_FIELDS' => 'モジュールフィールド',
    'LBL_MAPS_SELECT_FIELD' => 'フィールドを選択',
    'LBL_MAPS_RELATE_RECORD' => '関連するレコード',
    'LBL_MAPS_MAPPING_TYPE' => 'マッピングタイプ',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'ジオコーディングされたレコードはありません',
    'LBL_MAPS_ADDRESS' => '住所',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'アサインされたユーザ',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => '指定した地点のストリートサイドビューは利用できません',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> レコードはマッピングに有効ではありません。モジュールをリストから削除してください。',
    'LBL_MAPS_CLOSE_TOOLTIP' => '閉じる',
    'LBL_MAPS_EXPAND_TOOLTIP' => '拡張',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'PDFで保存',
    'LBL_MAPS_EMAIL_LINK' => 'Eメールリンク',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => '少なくとも1つのジオコーディングされたレコードが必要です。',
    'LBL_MAPS_GENERATING' => '地図を生成中...',
    'LBL_MAPS_POINTS' => '地図上のポイント',
    'LBL_MAPS_POINT' => 'ポイント',
    'LBL_MAPS_TRAVEL_DETAILS' => '移動の詳細',
    'LBL_MAPS_TOTAL_DISTANCE' => '総距離',
    'LBL_MAPS_TOTAL_DURATION' => '合計時間',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'トラフィックがない場合の合計時間',
    'LBL_MAPS_ITINERARY' => '旅程',
    'LBL_MAPS_TRAVEL_DISTANCE' => '移動距離',
    'LBL_MAPS_TRAVEL_DURATION' => '移動時間',
    'LBL_MAPS_TRAVEL_STEPS' => 'ステップ',
    'LBL_MAPS_TRAVEL_WARNINGS' => '警告',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Mapsは、共有地図上で最大10個のピンポイントに対応しています。選択内容を確認してください。',
    'LBL_MAPS_NO_LICENSE_ACCESS' => '地図ライセンスが必要です',
    'LBL_MAPS_SHARE_HELLO' => 'こんにちは、',
    'LBL_MAPS_SHARE_HEADER' => '以下の地点のBingマップをリクエストしました:',
    'LBL_MAPS_SHARE_OPEN_URL' => '次のURLから、Bingマップに上記の地点を含んだ地図を開きます:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Bingマップで地図を表示する',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bingマップ',
    'LBL_MAPS_NO_VALID_ITINERARY' => '提供されたウェイポイントのルートは見つかりませんでした。',
    'LBL_MAPS_GEOCODE_STATUS' => 'ジオコードステータス',
    'LBL_MAPS_GEOCODED' => 'ジオコーディング済み',
    'LBL_MAPS_NOT_GEOCODED' => 'ジオコーディングされていない',
    'LBL_MAPS_NOT_FOUND' => '住所が無効です',
    'LBL_MAPS_GEOCODING_FAILED' => 'ジオコーディングに失敗しました',
    'LBL_MAPS_QUEUED' => 'キューに追加済み',
    'LBL_MAPS_REQUEUED' => 'キューに再追加済み',
    'LBL_MAPS_RELATED_RECORD' => '関連するレコード',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'レポートを表示',
    'LBL_REPORT_DASHLET_DESC' => '保存されたレポートを表示',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'ダッシュレットをデフォルトにリセットする',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'レポートをデフォルトにリセットする',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'レポート結果を更新する',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'チャートをクリップボードにコピー',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'チャートのダウンロード',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'ダッシュレット {{label}} のレポートが編集され、ダッシュレットがデフォルト構成にリセットされました。',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'このフィールドを使用する権限がありません。',

    'LBL_INVALID_FORMULA' => '不正な計算式です',
    'LBL_RETURN_TYPE_MISSMATCH' => '関数の戻り値の型が一致しません',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => '予測',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => '理想的なお客様像',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => '週の予測スコアを閉じる',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => '予測値',
    'LBL_AI_CONV_BIN_ACCURACY' => '予測バイナリ精度',
    'LBL_AI_CONV_MULTIPLIER' => '予測乗数',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP値',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICPバイナリ精度',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP乗数',
    'LBL_AI_NEW' => '新規',
    'LBL_AI_ENTERED' => '入力済み',
    'LBL_AI_CREATED' => '作成済み',
    'LBL_AI_WEEK' => '週',
    'LBL_AI_MONTH' => '月',
    'LBL_AI_QUARTER' => '四半期',
    'LBL_AI_BYWEEK' => '週別',
    'LBL_AI_BYMONTH' => '月別',
    'LBL_AI_BYQUARTER' => '四半期別',
    'LBL_AI_WEEKTREND' => '週間トレンド',
    'LBL_AI_MONTHLYTREND' => '月間トレンド',
    'LBL_AI_QUARTERTREND' => '四半期ごとのトレンド',
    'LBL_AI_TREND' => 'トレンド条件',
    'LBL_AI_TRENDS' => 'トレンド条件',
    'LBL_AI_VELOCITY' => '速度',
    'LBL_AI_TOPX' => '上位{X}件',
    'LBL_AI_TIMESPAN' => 'ステージ間の間隔 -',
    'LBL_AI_BUSINESSTREND' => 'ビジネストレンドを含む',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Sugar Insightsをご紹介します！',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insightsは、定量分析を活用して、SugarCRMデータに新しい洞察を生成します。Sugarでは、お客様がデータを最大限に活用し、十分な情報に基づいた意思決定を行える新しい方法を常に模索しています。これはSugar Insightsで利用できることのほんの始まりに過ぎません。',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insightsは、定量分析を活用して、SugarCRMデータへの新しい洞察を生成します。',
    'LBL_AI_FIRMO' => 'ファーモグラフィックス',
    'LBL_AI_TOTALCOUNT' => '合計数',
    'LBL_AI_DAYSFROMLATESTACT' => '前回からの日数',
    'LBL_AI_DAYSSINCE' => '年齢',
    'LBL_AI_FIELDISSET' => '存在',
    'LBL_AI_CONTACTCOMPLETENESS' => '連絡先に関する情報の完全性',
    'LBL_AI_CUTDATE' => '予測期間',
    'LBL_AI_FROMLASTCHANGE' => '前回の特徴量の変更からの日数',
    'LBL_AI_CALLSHELD' => '保留された通話の合計数',
    'LBL_AI_CALLSPLANNED' => '計画された通話の合計数',
    'LBL_AI_OUTBOUNDCALLS' => '発信通話の合計数',
    'LBL_AI_INBOUNDCALLS' => '着信通話の合計数',
    'LBL_AI_AVGCALLDURATION' => '通話の平均時間',
    'LBL_AI_EMAILSARCHIVED' => 'アーカイブされたメールの合計数',
    'LBL_AI_EMAILSREAD' => '読まれたメールの合計数',
    'LBL_AI_EMAILSSENT' => '送信されたメールの合計数',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => '予想完了日が後の日付に変更されたレコードの合計数',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => '予想完了日が前の日付に変更されたレコードの合計数',
    'LBL_AI_AMOUNTINCREASED' => '金額が増加した案件の合計',
    'LBL_AI_AMOUNTDECREASED' => '金額が減少した案件の合計',

    // User last state
    'LBL_LAST_STATE' => '前回の状態',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'DocuSignに送信',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => '受信者の編集をキャンセル',
    'LBL_RECIPIENT_ROLE' => '受信者の役割',
    // Base sales stages
    'LBL_OPEN' => '開く',
    'LBL_CLOSED_WON' => '受注',
    'LBL_CLOSED_LOST' => '失注',
    'LBL_KIOSK_ADD_FILES' => 'ファイルを追加',
    'LBL_KIOSK_ADD_DROP_FILES' => 'ここにファイルを追加または挿入',
    'LBL_KIOSK_CANCEL' => 'キャンセル',
    'LBL_KIOSK_EDIT' => '編集',
    'LBL_KIOSK_EMAIL' => 'Eメール',
    'LBL_KIOSK_FILES_UPLOADING' => 'アップロード中',
    'LBL_KIOSK_FILES_ERROR' => '添付はアップロードに失敗',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => '添付ファイルが大きすぎます',
    'LBL_KIOSK_FILTER_SEARCH' => '検索',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'キオスク',
    'LBL_KIOSK_LANGUAGE' => '言語',
    'LBL_KIOSK_LAST_UPDATED' => '最終更新日',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'ビュー',
    'LBL_KIOSK_MENU' => 'メニュー',
    'LBL_KIOSK_MOBILE_PHONE' => 'モバイル',
    'LBL_KIOSK_MY_ACTIVITIES' => 'マイアクティビティ',
    'LBL_KIOSK_MY_PROFILE' => 'マイプロフィール',
    'LBL_KIOSK_NAME' => '名前',
    'LBL_KIOSK_OFFICE_PHONE' => '会社電話',
    'LBL_KIOSK_ORGANIZATION' => '組織',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'ページあたりの行数：',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'Powered by SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => '変更を保存',
    'LBL_KIOSK_SHOW_HIDE' => '表示/非表示',
    'LBL_KIOSK_SIGN_IN' => 'サインイン',
    'LBL_KIOSK_SIGN_OUT' => 'サインアウト',
    'LBL_KIOSK_SORT_BY' => 'ソート基準',
    'LBL_KIOSK_SUBMIT' => '送信',
    'LBL_KIOSK_TIMEZONE' => 'タイムゾーン',
    'LBL_KIOSK_ACTIVITY' => 'アクティビティ',
    'LBL_KIOSK_NO_ACTIVITY' => '表示するアクティビティはありません',
    'LBL_KIOSK_OLDEST_FIRST' => '古い順',
    'LBL_KIOSK_NEWEST_FIRST' => '新しい順',
    'LBL_KIOSK_SHOW_MORE' => 'さらに表示',
    'LBL_KIOSK_ADD_A_REPLY' => '返信を追加',
    'LBL_KIOSK_REPLY_EMPTY' => '返信を空のままにすることはできません。',
    'LBL_KIOSK_NUM_MORE' => '{{num}} 以上',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'ようこそ',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'リソースにすばやくアクセスできます。',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => '検索ケース',
    'LBL_KIOSK_SHOW_ALL' => 'すべて表示',
    'LBL_KIOSK_404_TITLE' => 'これを見つけられませんでした',
    'LBL_KIOSK_TENANT_404_TITLE' => 'テナントが見つかりません',
    'LBL_KIOSK_404_MESSAGE' => '削除されたリンク、一時的に利用できないリンク、または無効な URL を入力したリンクをクリックしました。',
    'LBL_KIOSK_TENANT_404_MESSAGE' => '正しい URL があることを確認してください。さらにサポートが必要な場合は、サポートにお問い合わせください。',
    'LBL_KIOSK_BACK_TO_HOME' => 'ホームへ戻る',
    'LBL_KIOSK_ERROR_CODE' => '{code}エラー： ',
    'LBL_KIOSK_401_TITLE' => '権限がありません',
    'LBL_KIOSK_401_MESSAGE' => 'このページを閲覧する権限がありません。',
    'LBL_KIOSK_403_TITLE' => '権限がありません',
    'LBL_KIOSK_403_MESSAGE' => 'このページを閲覧するアクセス権がありません。',
    'LBL_KIOSK_500_TITLE' => 'サーバーが応答していません',
    'LBL_KIOSK_500_MESSAGE' => 'こちら側で問題が発生しました',
    'LBL_KIOSK_GO_BACK' => '戻る',
    'LBL_KIOSK_DUPLICATE_ERROR' => '重複するレコードが見つかりました',
    'LBL_KIOSK_ACCOUNT' => 'アカウント',
    'LBL_KIOSK_STATUS' => 'ステータス',
    'LBL_KIOSK_DEACTIVATE' => '無効化',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'ユーザーが無効化されました',
    'LBL_KIOSK_MANAGE_USERS' => 'ユーザーを管理',
    'LBL_KIOSK_LAST_LOGIN' => '前回のログイン',
    'LBL_KIOSK_FIRST_NAME' => '名',
    'LBL_KIOSK_LAST_NAME' => '姓',
    'LBL_KIOSK_ROLE' => '役割',
    'LBL_KIOSK_INVITE' => '招待',
    'LBL_KIOSK_SEND_INVITES' => '招待状を送信',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => '招待状が正常に送信されました',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => '招待状が送信されませんでした',
    'LBL_KIOSK_REACTIVATE' => '再有効化',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'ユーザーが再有効化されました',
    'LBL_KIOSK_RESET_PASSWORD' => 'パスワードをリセット',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'パスワードリセットメールが送信されました',
    'LBL_KIOSK_USER_PROFILE' => 'ユーザープロフィール',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'ユーザーが無効化されました。管理者にお問い合わせください。',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'ログインに戻る',
    'LBL_KIOSK_REVOKE_INVITATION' => '招待を取り消す',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => '招待は正常に取り消されました',
    'LBL_KIOSK_SEARCH_AND_SELECT' => '検索して選択...',
    'LBL_KIOSK_NO_MATCHES' => '一致するものが見つかりません',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'プロフィールが更新されました。',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'プロフィールの更新中にエラーが発生しました。',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'ドキュメント',
    'LBL_KIOSK_DOCUMENTS_DESC' => '受信した共有ドキュメントを表示、検索、ダウンロードします。',
    'LBL_KIOSK_CASES' => 'ケース',
    'LBL_KIOSK_CASES_DESC' => '共有されたケースを表示、検索、返信します。',
    'LBL_KIOSK_DOWNLOAD' => 'ダウンロード',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'ファイルが正常にダウンロードされました',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => '開始する',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'より良いサポートをするために、姓名をお知らせください。',
    'LBL_KIOSK_SAVE' => '保存',
    'LBL_KIOSK_SHARED' => '共有済み',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => '{firstName}{lastInitial}さん、ようこそ。',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => '背景の色',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => '背景画像のURL',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'ファイルサイズが400K未満の画像を選択することをお勧めします。',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => '背景のタイプ',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'ホームの背景',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'テーマ',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'プライマリテーマの色',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'アプリ名',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'これはアプリケーションのタイトルで、ロゴの隣に表示されます。',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'アプリロゴのURL',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => '小さいサイズで最も見やすいロゴを選択することをお勧めします（例：ソーシャルメディアのプロフィール）。また、ファイルサイズは200K未満にすることをお勧めします。',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'アプリファビコンのURL',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'ファビコンは、ブラウザタブのページタイトルの横に表示される小さなロゴです。',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'オープンアクティビティを自動再割り当て',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'ユーザー上限に達しました',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'ライセンスキーが無効です',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'アプリケーションが無効です',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'アプリケーションが無効です',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => '認証キーが破損しています',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'ライセンスの期限が切れています',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => '不足している情報',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => '認証キーがありません',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'ユーザー不在のアクセス',
    'LBL_DRI_WORKFLOW' => 'スマートガイド',
    'LBL_DRI_WORKFLOWS' => 'スマートガイド',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'スマートガイドステージテンプレート',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'スマートガイドステージテンプレート',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'スマートガイドテンプレート',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'スマートガイドアクティビティテンプレート',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'アクティビティテンプレート',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'ウェブフック',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automateウェブフック',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => '現在のスマートガイドアクティビティ時刻',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automateウェブフック',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate ウェブフック',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugarアクション',
    'LBL_CJ_FORMS' => 'Smart Guide Sugarアクション',
    'LBL_CJ_FORM' => 'Smart Guide Sugarアクション',
    'LBL_DRI_SUBWORKFLOW' => 'スマートガイドステージ',
    'LBL_DRI_SUBWORKFLOWS' => 'スマートガイドステージ',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'スマートガイドアクティビティテンプレート',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'スマートガイドテンプレート',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'スマートガイド注文',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'スマートガイド実際の注文',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'スマートガイドスコア',
    'LBL_CJ_MOMENTUM_POINTS' => 'スマートガイドモメンタムポイント',
    'LBL_CJ_MOMENTUM_SCORE' => 'スマートガイドモメンタムスコア',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'スマートガイドアクティビティ許可実行者',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'スマートガイド進捗状況',
    'LBL_CJ_MOMENTUM_RATIO' => 'スマートガイドモメンタム率',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'スマートガイドポイント',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'スマートガイドタスク',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'スマートガイド親アクティビティタイプ',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'スマートガイドブロック者',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'スマートガイドブロック（ステージ別）',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'スマートガイド親アクティビティID',
    'LBL_START_NEXT_JOURNEY_ID' => '次のスマートガイドIDを開始',
    'LBL_CJ_URL' => 'スマートガイドURL',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'スマートガイド親アクティビティです',
    'LBL_CJ_MOMENTUM_START_DATE' => 'スマートガイドモメンタム開始日',
    'LBL_CJ_MOMENTUM_END_DATE' => 'スマートガイドモメンタム終了日',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'ウィジェットレイアウト構成',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'ウィジェットレイアウト構成',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => '同じテンプレートのスマートガイドの最大数',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'アクティブ',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'アーカイブ済み',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => '表示',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => '非表示',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => '縦向きモード',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => '横向きモード',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'ライセンスが無効です',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}}が{{assigned_user}}に以下のすまーどガイドアクティビティを割り当てました。</p>
    <ul>{{activities}}</ul>
    
    <p>これらのアクティビティは意kでレビューできます：<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'ライセンスが無効です',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'ユーザー上限に達しました。{{gracePeriodDays}}日以内にライセンスをアップグレードしてください。',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - 割り当てられたスマートガイドアクティビティ',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Sugar Automate のユーザー上限（{0}）を超えました<br>
    <br>
    <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> にお問い合わせいただき、ユーザー上限を引き上げるか、プラグインを使用しているユーザー数を減らしてください。',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate のユーザー上限に達しました',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Sugar Automate ライセンスは {0} 日後に有効期限が切れます。<br>
    <br>
    SugarCRMまたはSugarパートナーにお問い合わせいただき、更新してサービスが中断しないようにしてください。',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate ライセンスの有効期限が近づいています',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'テストウェブフック',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guideの進捗状況',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Sugar Automateの「Smart Guideの進捗状況」の円グラフを表示します。',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'ウェブフックの応答を表示します。',
    'LBL_DASHLET_SEND_LABEL' => 'リクエストを送信',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => '自分に割り当てる',
    'LBL_COMPLETE_BUTTON_TITLE' => '完了',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'すべてのタスクの完了',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'ステージを削除',
    'LBL_START_CYCLE_BUTTON_TITLE' => '開始',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => '該当なし',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'ステージを追加',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => '表示',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Smart Guideを編集',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'キャンセル',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'アーカイブ',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'アーカイブ解除',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'テンプレートを設定',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'タスクを追加',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => '会議をスケジュール',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => '通話をスケジュール',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => '未来にあります',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => '期限切れです',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => '今日です',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => '明日です',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'このスマートガイドをキャンセルしてもよろしいですか？',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'あなたはすべてのタスクを完了しようとしています。本当にこのまま続行しますか？',
    'LBL_CJ_BLOCK_BY' => '未解決の依存タスク {{Name}} があります。すべてのタスクを完了する前に、このタスクを完了させてください。',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => '未解決の依存タスクが複数あります。すべてのタスクを完了する前に、これらのタスクを完了させてください。',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'すべてのタスクが正常に完了しました',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'このスマートガイドをアーカイブしてもよろしいですか？',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'このスマートガイドのアーカイブを解除してもよろしいですか？',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate ：スマートガイド（フォーカスドロワーおよびコンソール）',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'アクティブなスマートガイドをサービス/更新コンソールとフォーカスドロワーダッシュボードで表示します。',
    'LBL_CJ_PROCESSING_REQUEST' => '処理中。',
    'LBL_CJ_SUCCESS' => 'すべてのタスクが正常に完了しました',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module} モジュールが有効になっていない',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'すべての表示設定が保存されます。',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'スマートガイドモメンタム',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Sugar Automate の「スマートガイドモメンタム」のゲージ表を表示します。',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guideの進捗状況',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Sugar Automateの「Smart Guideの進捗状況」の円グラフを表示します。',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => '親が見つかりませんでした',
    'CJ_NOT_FOUND_EXCEPTION' => '{data} の {moduleName} が見つかりませんでした',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'スマートガイドは、アーカイブする前に完了またはキャンセルする必要があります',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate は現在の Sugar ライセンスでは有効になっていません',
    'LBL_ACTION_NOT_FOUND' => 'アクションが見つかりません。システム管理者に問い合わせてください。',
    'LBL_CJ_SELECT_FIELD' => 'フィールドを選択',
    'LBL_CJ_SELECT_OPERATOR' => '演算子を選択',
    'LBL_CJ_SELECT_VALUE' => '値を選択',
    'LBL_CJ_ENTER_VALUE' => '値を入力',
    'LBL_CJ_FORM_BATCH_TITLE' => 'レコードを保存しています',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => '有効なSmart Guideが検出されました...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => '有効なSugarアクションを処理しています…',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => '有効なSmart Guideを更新しています…',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'レコードおよび関連するSmart Guideが正常に更新されました。',
    'LBL_CJ_FORM_BATCH_FAILURE' => '関連するSmart Guideの更新に失敗しました。エラーが続く場合は、Sugar管理者にお問い合わせください。',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => '関連するSmart Guideの更新に失敗しました。<a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">ログ</a>確認して、エラーをトラブルシューティングしてください。',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => '<a href="#{{module}}/{{id}}">{{name}}</a>{{moduleSingularLower}}が正常にリンクされました。',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => '<a href="#{{module}}/{{id}}">{{name}}</a>{{moduleSingularLower}}のリンク中に問題が発生しました。問題が解決しない場合は、Sugarサポートにお問い合わせください。',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => '{{modulePluralLower}}が正常にリンクされました。',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => '{{modulePluralLower}}のリンク中に問題が発生しました。問題が解決しない場合は、Sugarサポートにお問い合わせください。',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => '{{moduleSingularLower}}のリンク中に問題が発生しました。問題が解決しない場合は、Sugarサポートにお問い合わせください。',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => '{{stage}}ステージには、すでに<a href="#{{module}}/{{id}}">{{name}}</a>という名前の{{moduleSingularLower}}があります。',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => '<a href="#{{module}}/{{id}}">{{name}}</a>という名前の{{moduleSingularLower}}がすでに選択されています。',
    'LBL_CJ_ARCHIVED' => 'アーカイブ済み',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Smart Guideテンプレートを選択...',
    'LBL_ALL_SMART_GUIDES' => 'すべてのSmart Guide',
    'LBL_ACTIVE_SMART_GUIDES' => 'アクティブなSmart Guide',
    'LBL_ARCHIVED_SMART_GUIDES' => 'アーカイブ済みのSmart Guide',
    'LBL_VERTICAL_SCROLL_VIEW' => '縦積み表示',
    'LBL_HORIZONTAL_SCROLL_VIEW' => '水平スクロールを表示',
    'LBL_DRI_WORKFLOWS_FILTER' => 'フィルタ',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'このアクションを完了できません。このアクティビティのモジュールの [ステータス] フィールドが「読み取り専用」に設定されているため、[ステータス] フィールドを更新するスマートガイドのアクションは行われません。',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'このアクションを完了できません。このアクティビティまたはサブアクティビティのモジュールの [ステータス] フィールドが「読み取り専用」に設定されているため、[ステータス] フィールドを更新するスマートガイドのアクションは行われません。',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'ガイド内の一部のアクティビティのモジュールのステータスフィールドが「読み取り専用」に設定されています。これらのアクティビティはガイドをキャンセルしても変更されません。',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'クリップボードにコピーされました。',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => '定期的な予定をすべて削除',
    'ERROR_RECURRENCE_EVENT_PARAMS' => '無効な繰り返し設定です',
    'ERROR_INTERVAL_INVALID' => '繰り返しの間隔は1～99の間でなければなりません',
    'LBL_RECURRENCE_ADD' => '設定する',
    'LBL_REPEAT_DAYS' => '日',
    'LBL_REPEAT_END_TYPES' => '繰り返し',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'ナビゲーションプロバイダー',
    'LBL_MOBILE_PDF_EMAIL' => 'PDFファイル {{{pdfTemplateName}}} をメール送信する',
    'LBL_MOBILE_EMAIL_SENDING' => '送信中',
    'LBL_MOBILE_EMAIL_SENT' => '送信済み',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'Eメールを下書きとして保存しました。',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => '添付ファイルの追加',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'ローカルからアップロードする',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugarドキュメント',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => '選択したドロップダウンの値によって、レコードビューのレイアウトが変更されました。',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'SugarCRM モバイルアプリのリリースノート',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'SugarCRM モバイルアプリのユーザーガイド',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile は、ルート化されたモバイルデバイスでは使用できません。ルート化されていないデバイスでアプリを開いてください。',
    'LBL_VO_BUILD_ROUTE' => 'ルートの構築',
    'LBL_FILTER_MY_DISTANCE_FILTER' => '私の距離フィルター',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'ドキュメントはバックグラウンドで生成されます。ドキュメントマージページを開いてファイルにアクセスしてください。',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'テンプレートの取得に失敗しました。管理者にお問い合わせください。',
    'LBL_MAP_ERROR_LOAD' => 'マップを読み込めません',
    'LBL_MAP_DISTANCE' => '距離',
    'LBL_SELECT_UNIT_TYPE' => 'ユニットタイプ',
    'LBL_MAPS_UNIT_MILES' => 'マイル',
    'LBL_MAPS_UNIT_KILOMETERS' => 'キロメートル',
    'LBL_RADIUS' => '半径',
    'LBL_ZIP_CODE' => '郵便番号',
    'LBL_MOBILE_CHOOSE_ADDRESS' => '住所を選択',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => '住所 {{{address}}} からジオコードを作成できません。',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'レコードがジオコーディングされませんでした。',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'レコードに住所データが含まれていません。このレコードをマップ上に手動で配置しますか？',
    'LBL_ERR_SHOW_ON_MAP' => '選択されたレコードのマップを開くのに失敗しました。',
    'LBL_ERR_MISSING_ON_MAP' => '一部のレコードは住所データが欠落しているため表示されません',
    'LBL_MAPS_ROUTE' => 'ルーティング',
    'LBL_MAPS_PROVIDER' => 'Sugar Maps',
    'LBL_MAPS_CURRENT_LOC_ERROR' => '現在の場所を特定できませんでした。',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'マッピングには最大 {{{num}}} 件のレコードがサポートされます。',
    'LBL_ALL_MODULES' => 'すべてのモジュール',
    'LBL_DRIVE_SHARE_LINK' => 'リンクを共有する',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'ファイルの読み込みに失敗しました。',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => '名前は空にできません',
    'LBL_DRIVE_FOLDER_CREATED' => 'フォルダが作成されました。',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'フォルダの作成に失敗しました。',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'ファイルのアップロードに失敗しました。',
    'LBL_DRIVE_NO_ROOT_FOLDER' => '最初にルートフォルダを作成してください',
    'LBL_EDIT_ALL_RECURRENCES' => '定期的な予定をすべて編集',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'ファイルをDropboxで開けません',
    'LBL_FILE_NOT_AVAILABLE' => 'ファイルを開けません',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => '方向',
    'LBL_MAPS_ROUTE_NOT_FOUND' => '提供されたウェイポイントのルートは見つかりませんでした',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => '近く',
    'LBL_TAGS' => 'タグ',

    'LBL_CALLER_ID_SETTINGS' => '発信者IDの設定',
    'LBL_CALLER_ID_ENABLED' => '発信者IDが有効',
    'LBL_CALLER_ID_ENABLED_TEXT' => '着信コールには、電話番号と一致する担当者またはリードの名前が表示されます。',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'モバイルアプリに発信者IDを表示させるには、お使いのデバイスで以下の手順に従ってください：<br><br>1. iOSの[設定] > [電話] > [通話のブロックおよび識別]の順に開く。<br>2. 「{{{brandName}}}」を有効にする。',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'モバイルアプリに発信者IDを表示させるには、お使いのデバイスで以下の手順に従ってください：<br><br>1. アプリの設定を開く。<br>2. [権限]に移動する。<br>3. 電話の権限を有効にする。<br><br> このアプリケーションをデフォルトの発信者IDハンドラに設定するには、お使いのデバイスの設定に移動します。<br>1. アプリに移動する。<br>2. デフォルトのアプリを選択する。<br>3. 発信者IDと迷惑メールアプリを選択する。<br>4. このアプリケーションをデフォルトのオプションとして選択する。',
    'LBL_CALLER_ID_SYNC_HINT' => 'Sugarインスタンスにあるレコード（例：担当者、リード）の連絡先に関する情報の変更内容を確認できます。',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => '設定に移動',
    'LBL_CALLER_ID_SYNC' => 'レコードデータを同期',
    'LBL_CALLER_ID_NOT_ENABLED' => '発信者IDは、同期前にシステム設定で有効にする必要があります。',
    'LBL_CALLER_ID_SETUP_ENABLE' => '有効にする',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => '設定の後半',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'このアプリケーションは発信者ID機能に対応しています。<br> この機能を適切に機能させるため、有効にするボタンを押した後、2つの権限を付与するよう求められます。<br>発信者ID機能が正しく機能するようにするには、通話を管理する権限を付与し、このアプリケーションをデフォルトの発信者IDハンドラとして選択する必要があります。<br>通話を管理する権限を付与しない場合、アプリケーションから発信された通話をログに記録することもできなくなります。',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'SugarCRMモバイルアプリに発信者IDを表示させるには、お使いのデバイスで以下の手順に従ってください：<br><br>1. iOSの[設定] > [電話] > [通話のブロックおよび識別]の順に開く。<br>2. アプリを有効にする。',
    'LBL_MOBILE_LAST_SYNC' => '前回の同期',
    'LBL_CALLER_ID_SYNCING' => 'サーバーと同期しています。',
    'LBL_NEVER' => 'なし',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}}を空にすることはできません。',
    'LBL_ADD_RELATED_RECORD' => '関連{{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => '発信者IDを使用するために必要な権限がありません。管理者にお問い合わせください。',
    'LBL_CALLER_ID_FETCHING' => '同期しています…',
    'LBL_CALLER_ID_FETCH_ALL' => 'すべてのレコードを再同期',
    'LBL_CALLER_ID_FETCH_NEW' => 'レコードの更新情報を確認',

    'LBL_SORT_BY' => '並び替え順',
    'LBL_PRIMARY_SORT' => 'プライマリソート',
    'LBL_SECONDARY_SORT' => 'セカンダリソート',
    'LBL_OF' => 'の',
    'LBL_TABLE_FREEZE_FIRST' => '最初のカラムを固定',
    'LBL_TABLE_SETTINGS_TITLE' => 'カラム表示オプション',
    'LBL_TABLE_SETTINGS_NO_COL' => '少なくとも 1 つのカラムを選択する必要があります。',
    'LBL_TABLE_TOGGLER_INFO' => 'カラムを表示または非表示にして、好みの順序にドラッグします。',
    'LBL_RUNTIME_FILTERS_TITLE' => 'ランタイムフィルター',
    'LBL_FILTER_CONDITION' => '条件を選択',
    'LBL_FILTER_VALUES' => '値',
    'LBL_TABLE_EXPAND' => 'すべて表示',
    'LBL_TABLE_COLLAPSE' => 'すべて閉じる',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'サーバーエラー。関連するランタイムフィルターを読み込めませんでした。',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Pub/Subモジュールのイベントプッシュサブスクリプション',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Pub/Subモジュールのイベントプッシュサブスクリプション',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'パネル - 上部',
    'panel_bottom' => 'パネル - 下部',
    'tab_first' => 'タブ - 最初',
    'tab_last' => 'タブ - 最後',
];

$app_list_strings['activity_user_options'] = [
    '7' => '過去7日間',
    '30' => '過去30日間',
    '90' => '前四半期',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => '今日',
    'future' => '将来',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'はい',
    'group' => 'いいえ',
];

$app_list_strings['history_filter_options'] = [
    7 => '過去7日間',
    30 => '過去30日間',
    90 => '前四半期',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'はい',
    'group' => 'いいえ',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'はい',
    'group' => 'いいえ',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'はい',
    '0' => 'いいえ',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => '今四半期',
    'next' => '翌四半期',
    'year' => '今年',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'マイレコード',
    'group' => 'グループレコード',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => '私のパイプライン',
    'group' => 'チームのパイプライン',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => '私の売上予測',
    'group' => 'チームの売上予測',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => '商談',
    'RevenueLineItems' => '商談と商談品目',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => '最近のクローズ日',
    'earliest' => '一番古いクローズ日',
];

$app_list_strings['moduleList']['Library'] = 'ライブラリ';
$app_list_strings['moduleListSingular']['Library'] = 'ライブラリ';
$app_list_strings['library_type'] = ['Books' => '書籍', 'Music' => '音楽', 'DVD' => 'DVD', 'Magazines' => '雑誌'];
$app_list_strings['moduleList']['EmailAddresses'] = 'Eメールアドレス';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'Eメールアドレス';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'ドラフト',
    'in-review' => 'レビュー中',
    'approved' => '承認済',
    'published' => '公開済み',
    'expired' => '期限切れ',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--管理者のアクション--',
        'Create New Tag' => 'タグを作成',
        'Delete Tag' => 'タグを削除',
        'Rename Tag' => 'タグの名前を変更',
        'Move Selected Articles' => '選択された記事を移動',
        'Apply Tags On Articles' => '記事にタグを適用',
        'Delete Selected Articles' => '選択された記事を削除',
    ];

$app_list_strings['moduleList']['Words'] = 'ワード';
$app_list_strings['moduleListSingular']['Words'] = 'ワード';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = '記事作成';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'アブダビ',
    'ADEN' => 'アデン',
    'AFGHANISTAN' => 'アフガニスタン',
    'ALBANIA' => 'アルバニア',
    'ALGERIA' => 'アルジェリア',
    'AMERICAN SAMOA' => 'アメリカ領サモア',
    'ANDORRA' => 'アンドラ',
    'ANGOLA' => 'アンゴラ',
    'ANTARCTICA' => '南極大陸',
    'ANTIGUA' => 'アンティグア',
    'ARGENTINA' => 'アルゼンチン',
    'ARMENIA' => 'アルメニア',
    'ARUBA' => 'アルバ',
    'AUSTRALIA' => 'オーストラリア',
    'AUSTRIA' => 'オーストリア',
    'AZERBAIJAN' => 'アゼルバイジャン',
    'BAHAMAS' => 'バハマ',
    'BAHRAIN' => 'バーレーン',
    'BANGLADESH' => 'バングラデシュ',
    'BARBADOS' => 'バルバドス',
    'BELARUS' => 'ベラルーシ',
    'BELGIUM' => 'ベルギー',
    'BELIZE' => 'ベリーズ',
    'BENIN' => 'ベニン',
    'BERMUDA' => 'バミューダ',
    'BHUTAN' => 'ブータン',
    'BOLIVIA' => 'ボリビア',
    'BOSNIA' => 'ボスニア ・ ヘルツェゴビナ',
    'BOTSWANA' => 'ボツワナ',
    'BOUVET ISLAND' => 'ブーヴェ島',
    'BRAZIL' => 'ブラジル',
    'BRITISH ANTARCTICA TERRITORY' => 'イギリス領南極地域',
    'BRITISH INDIAN OCEAN TERRITORY' => 'イギリス領インド洋地域',
    'BRITISH VIRGIN ISLANDS' => 'イギリス領バージン諸島',
    'BRITISH WEST INDIES' => 'イギリスの西インド諸島',
    'BRUNEI' => 'ブルネイ',
    'BULGARIA' => 'ブルガリア',
    'BURKINA FASO' => 'ブルキナファソ',
    'BURUNDI' => 'ブルンジ',
    'CAMBODIA' => 'カンボジア',
    'CAMEROON' => 'カメルーン',
    'CANADA' => 'カナダ',
    'CANAL ZONE' => '運河地帯',
    'CANARY ISLAND' => 'カナリア島',
    'CAPE VERDI ISLANDS' => 'ケープベルディ諸島',
    'CAYMAN ISLANDS' => 'ケイマン諸島',
    'CEVLON' => 'Ceylon',
    'CHAD' => 'チャド',
    'CHANNEL ISLAND UK' => '英国領チャンネル諸島',
    'CHILE' => 'チリ',
    'CHINA' => '中国',
    'CHRISTMAS ISLAND' => 'クリスマス島',
    'COCOS (KEELING) ISLAND' => 'ココス (キーリング) 島',
    'COLOMBIA' => 'コロンビア',
    'COMORO ISLANDS' => 'コモロ諸島',
    'CONGO' => 'コンゴ',
    'CONGO KINSHASA' => 'コンゴ キンシャサ',
    'COOK ISLANDS' => 'クック諸島',
    'COSTA RICA' => 'コスタリカ',
    'CROATIA' => 'クロアチア',
    'CUBA' => 'キューバ',
    'CURACAO' => 'キュラソー',
    'CYPRUS' => 'キプロス',
    'CZECH REPUBLIC' => 'チェコ共和国',
    'DAHOMEY' => 'ダオメー',
    'DENMARK' => 'デンマーク',
    'DJIBOUTI' => 'ジブチ',
    'DOMINICA' => 'ドミニカ',
    'DOMINICAN REPUBLIC' => 'ドミニカ共和国',
    'DUBAI' => 'ドバイ',
    'ECUADOR' => 'エクアドル',
    'EGYPT' => 'エジプト',
    'EL SALVADOR' => 'エルサルバドル',
    'EQUATORIAL GUINEA' => '赤道ギニア',
    'ESTONIA' => 'エストニア',
    'ETHIOPIA' => 'エチオピア',
    'FAEROE ISLANDS' => 'フェロー諸島',
    'FALKLAND ISLANDS' => 'フォークランド諸島',
    'FIJI' => 'フィジー',
    'FINLAND' => 'フィンランド',
    'FRANCE' => 'フランス',
    'FRENCH GUIANA' => 'フランス領ギニア',
    'FRENCH POLYNESIA' => 'フランス領ポリネシア',
    'GABON' => 'ガボン',
    'GAMBIA' => 'ガンビア',
    'GEORGIA' => 'グルジア',
    'GERMANY' => 'ドイツ',
    'GHANA' => 'ガーナ',
    'GIBRALTAR' => 'ジブラルタル',
    'GREECE' => 'ギリシャ',
    'GREENLAND' => 'グリーンランド',
    'GUADELOUPE' => 'グアドループ',
    'GUAM' => 'グアム',
    'GUATEMALA' => 'グアテマラ',
    'GUINEA' => 'ギニア',
    'GUYANA' => 'ガイアナ',
    'HAITI' => 'ハイチ',
    'HONDURAS' => 'ホンジュラス',
    'HONG KONG' => '香港',
    'HUNGARY' => 'ハンガリー',
    'ICELAND' => 'アイスランド',
    'IFNI' => 'イフニ',
    'INDIA' => 'インド',
    'INDONESIA' => 'インドネシア',
    'IRAN' => 'イラン',
    'IRAQ' => 'イラク',
    'IRELAND' => 'アイルランド',
    'ISRAEL' => 'イスラエル',
    'ITALY' => 'イタリア',
    'IVORY COAST' => 'コートジボワール',
    'JAMAICA' => 'ジャマイカ',
    'JAPAN' => '日本',
    'JORDAN' => 'ヨルダン',
    'KAZAKHSTAN' => 'カザフスタン',
    'KENYA' => 'ケニア',
    'KOREA' => '韓国',
    'KOREA, SOUTH' => '韓国',
    'KUWAIT' => 'クウェート',
    'KYRGYZSTAN' => 'キルギスタン',
    'LAOS' => 'ラオス',
    'LATVIA' => 'ラトビア',
    'LEBANON' => 'レバノン',
    'LEEWARD ISLANDS' => 'リーワード諸島',
    'LESOTHO' => 'レソト',
    'LIBYA' => 'リビア',
    'LIECHTENSTEIN' => 'リヒテンシュタイン',
    'LITHUANIA' => 'リトアニア',
    'LUXEMBOURG' => 'ルクセンブルク',
    'MACAO' => 'マカオ',
    'MACEDONIA' => 'マケドニア',
    'MADAGASCAR' => 'マダガスカル',
    'MALAWI' => 'マラウィ',
    'MALAYSIA' => 'マレーシア',
    'MALDIVES' => 'モルジブ',
    'MALI' => 'マリ',
    'MALTA' => 'マルタ',
    'MARTINIQUE' => 'マルティニーク',
    'MAURITANIA' => 'モーリタニア',
    'MAURITIUS' => 'モーリシャス',
    'MELANESIA' => 'メラネシア',
    'MEXICO' => 'メキシコ',
    'MOLDOVIA' => 'モルドバ',
    'MONACO' => 'モナコ',
    'MONGOLIA' => 'モンゴル',
    'MOROCCO' => 'モロッコ',
    'MOZAMBIQUE' => 'モザンビーク',
    'MYANAMAR' => 'ミャンマー',
    'NAMIBIA' => 'ナミビア',
    'NEPAL' => 'ネパール',
    'NETHERLANDS' => 'オランダ',
    'NETHERLANDS ANTILLES' => 'オランダ領アンティル',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'オランダ領アンティル諸島の中立地帯',
    'NEW CALADONIA' => 'ニューカレドニア',
    'NEW HEBRIDES' => 'ニューヘブリディーズ',
    'NEW ZEALAND' => 'ニュージーランド',
    'NICARAGUA' => 'ニカラグア',
    'NIGER' => 'ニジェール',
    'NIGERIA' => 'ナイジェリア',
    'NORFOLK ISLAND' => 'ノーフォーク島',
    'NORWAY' => 'ノルウェー',
    'OMAN' => 'オマーン',
    'OTHER' => 'その他',
    'PACIFIC ISLAND' => '太平洋の島',
    'PAKISTAN' => 'パキスタン',
    'PANAMA' => 'パナマ',
    'PAPUA NEW GUINEA' => 'パプアニューギニア',
    'PARAGUAY' => 'パラグアイ',
    'PERU' => 'ペルー',
    'PHILIPPINES' => 'フィリピン',
    'POLAND' => 'ポーランド',
    'PORTUGAL' => 'ポルトガル',
    'PORTUGUESE TIMOR' => 'ポルトガル領ティモール',
    'PUERTO RICO' => 'プエルトリコ',
    'QATAR' => 'カタール',
    'REPUBLIC OF BELARUS' => 'ベラルーシ共和国',
    'REPUBLIC OF SOUTH AFRICA' => '南アフリカ共和国',
    'REUNION' => 'レユニオン',
    'ROMANIA' => 'ルーマニア',
    'RUSSIA' => 'ロシア',
    'RWANDA' => 'ルワンダ',
    'RYUKYU ISLANDS' => '琉球列島',
    'SABAH' => 'サバ',
    'SAN MARINO' => 'サンマリノ',
    'SAUDI ARABIA' => 'サウジアラビア',
    'SENEGAL' => 'セネガル',
    'SERBIA' => 'セルビア',
    'SEYCHELLES' => 'セイシェル',
    'SIERRA LEONE' => 'シエラレオネ',
    'SINGAPORE' => 'シンガポール',
    'SLOVAKIA' => 'スロバキア',
    'SLOVENIA' => 'スロベニア',
    'SOMALILIAND' => 'ソマリランド',
    'SOUTH AFRICA' => '南アフリカ',
    'SOUTH YEMEN' => '南イエメン',
    'SPAIN' => 'スペイン',
    'SPANISH SAHARA' => 'スペイン領サハラ',
    'SRI LANKA' => 'スリランカ',
    'ST. KITTS AND NEVIS' => 'セントクリストファー・ネイビス',
    'ST. LUCIA' => 'セントルシア',
    'SUDAN' => 'スーダン',
    'SURINAM' => 'スリナム',
    'SW AFRICA' => '南西アフリカ',
    'SWAZILAND' => 'スワジランド',
    'SWEDEN' => 'スウェーデン',
    'SWITZERLAND' => 'スイス',
    'SYRIA' => 'シリア',
    'TAIWAN' => '台湾',
    'TAJIKISTAN' => 'タジキスタン',
    'TANZANIA' => 'タンザニア',
    'THAILAND' => 'タイ',
    'TONGA' => 'トンガ',
    'TRINIDAD' => 'トリニダード',
    'TUNISIA' => 'チュニジア',
    'TURKEY' => 'トルコ',
    'UGANDA' => 'ウガンダ',
    'UKRAINE' => 'ウクライナ',
    'UNITED ARAB EMIRATES' => 'アラブ首長国連邦',
    'UNITED KINGDOM' => 'イギリス',
    'UPPER VOLTA' => 'オートボルタ',
    'URUGUAY' => 'ウルグアイ',
    'US PACIFIC ISLAND' => '米領の太平洋の島',
    'US VIRGIN ISLANDS' => '米領バージン諸島',
    'USA' => 'アメリカ',
    'UZBEKISTAN' => 'ウズベキスタン',
    'VANUATU' => 'バヌアツ',
    'VATICAN CITY' => 'バチカン市国',
    'VENEZUELA' => 'ベネズエラ',
    'VIETNAM' => 'ベトナム',
    'WAKE ISLAND' => 'ウェーク島',
    'WEST INDIES' => '西インド諸島',
    'WESTERN SAHARA' => '西サハラ',
    'YEMEN' => 'イエメン',
    'ZAIRE' => 'ザイール',
    'ZAMBIA' => 'ザンビア',
    'ZIMBABWE' => 'ジンバブエ',
];

$app_list_strings['state_dom'] = [
    'AL' => 'アラバマ',
    'AK' => 'アラスカ',
    'AZ' => 'アリゾナ',
    'AR' => 'アーカンソー',
    'CA' => 'カリフォルニア',
    'CO' => 'コロラド',
    'CT' => 'コネチカット',
    'DE' => 'デラウェア',
    'DC' => 'コロンビア特別区',
    'FL' => 'フロリダ',
    'GA' => 'ジョージア',
    'HI' => 'ハワイ',
    'ID' => 'アイダホ',
    'IL' => 'イリノイ',
    'IN' => 'インディアナ',
    'IA' => 'アイオワ',
    'KS' => 'カンザス',
    'KY' => 'ケンタッキー',
    'LA' => 'ルイジアナ',
    'ME' => 'メイン',
    'MD' => 'メリーランド',
    'MA' => 'マサチューセッツ',
    'MI' => 'ミシガン',
    'MN' => 'ミネソタ',
    'MS' => 'ミシシッピ',
    'MO' => 'ミズーリ',
    'MT' => 'モンタナ',
    'NE' => 'ネブラスカ',
    'NV' => 'ネバダ',
    'NH' => 'ニュー ・ ハンプシャー',
    'NJ' => 'ニュージャージー',
    'NM' => 'ニュー メキシコ',
    'NY' => 'ニューヨーク',
    'NC' => 'ノース ・ カロライナ',
    'ND' => 'ノース ・ ダコタ',
    'OH' => 'オハイオ',
    'OK' => 'オクラホマ',
    'OR' => 'オレゴン',
    'PA' => 'ペンシルベニア',
    'RI' => 'ロードアイランド',
    'SC' => 'サウス ・ カロライナ',
    'SD' => 'サウス ・ ダコタ',
    'TN' => 'テネシー',
    'TX' => 'テキサス',
    'UT' => 'ユタ',
    'VT' => 'バーモント',
    'VA' => 'Virginia',
    'WA' => 'ワシントン',
    'WV' => 'ウェスト バージニア',
    'WI' => 'ウィスコンシン',
    'WY' => 'ワイオミング',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (台湾と香港)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS キリル文字)',
    'CP1252' => 'CP1252 (MS 西ヨーロッパとUS)',
    'EUC-CN' => 'EUC-CN (簡体中国語 GB2312)',
    'EUC-JP' => 'EUC-JP (Unix 日本語)',
    'EUC-KR' => 'EUC-KR (韓国語)',
    'EUC-TW' => 'EUC-TW (台湾語)',
    'ISO-2022-JP' => 'ISO-2022-JP (日本語)',
    'ISO-2022-KR' => 'ISO-2022-KR (韓国語)',
    'ISO-8859-1' => 'ISO-8859-1 (西ヨーロッパとUS)',
    'ISO-8859-2' => 'ISO-8859-2 (中欧および東欧)',
    'ISO-8859-3' => 'ISO-8859-3 (ラテン語 3)',
    'ISO-8859-4' => 'ISO-8859-4 (ラテン語 4)',
    'ISO-8859-5' => 'ISO-8859-5 (キリル文字)',
    'ISO-8859-6' => 'ISO-8859-6 (アラビア語)',
    'ISO-8859-7' => 'ISO-8859-7 (ギリシャ語)',
    'ISO-8859-8' => 'ISO-8859-8 (ヘブライ語)',
    'ISO-8859-9' => 'ISO-8859-9 (ラテン語 5)',
    'ISO-8859-10' => 'ISO-8859-10 (ラテン語 6)',
    'ISO-8859-13' => 'ISO-8859-13 (ラテン語 7)',
    'ISO-8859-14' => 'ISO-8859-14 (ラテン語 8)',
    'ISO-8859-15' => 'ISO-8859-15 (ラテン語 9)',
    'KOI8-R' => 'KOI8-R (キリル文字 ロシア語)',
    'KOI8-U' => 'KOI8-U (キリル文字 ウクライナ語)',
    'SJIS' => 'SJIS (MS 日本語)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'アフリカ/アルジェ',
    'Africa/Luanda' => 'アフリカ/ルアンダ',
    'Africa/Porto-Novo' => 'アフリカ/ポルトノボ',
    'Africa/Gaborone' => 'アフリカ/ハボローネ',
    'Africa/Ouagadougou' => 'アフリカ/ワガドゥグー',
    'Africa/Bujumbura' => 'アフリカ/ブジュンブラ',
    'Africa/Douala' => 'アフリカ/ドゥアラ',
    'Atlantic/Cape_Verde' => 'アトランティック/カーボベルデ',
    'Africa/Bangui' => 'アフリカ/バンギ',
    'Africa/Ndjamena' => 'アフリカ/ンジャメナ',
    'Indian/Comoro' => 'インド/コモロ',
    'Africa/Kinshasa' => 'アフリカ/キンシャサ',
    'Africa/Lubumbashi' => 'アフリカ/ルブンバシ',
    'Africa/Brazzaville' => 'アフリカ/ブラザビル',
    'Africa/Abidjan' => 'アフリカ/アビジャン',
    'Africa/Djibouti' => 'アフリカ/ジブチ',
    'Africa/Cairo' => 'アフリカ/カイロ',
    'Africa/Malabo' => 'アフリカ/マラボ',
    'Africa/Asmera' => 'アフリカ/アスマラ',
    'Africa/Addis_Ababa' => 'アフリカ/アディスアベバ',
    'Africa/Libreville' => 'アフリカ/リーブルヴィル',
    'Africa/Banjul' => 'アフリカ/バンジュール',
    'Africa/Accra' => 'アフリカ ・ アクラ',
    'Africa/Conakry' => 'アフリカ/コナクリ',
    'Africa/Bissau' => 'アフリカ/ギニアビサウ',
    'Africa/Nairobi' => 'アフリカ/ナイロビ',
    'Africa/Maseru' => 'アフリカ/マセル',
    'Africa/Monrovia' => 'アフリカ/モンロビア',
    'Africa/Tripoli' => 'アフリカ/トリポリ',
    'Indian/Antananarivo' => 'インド/アンタナナリボ',
    'Africa/Blantyre' => 'アフリカ/ブランタイヤ',
    'Africa/Bamako' => 'アフリカ/バマコ',
    'Africa/Nouakchott' => 'アフリカ/ヌアクショット',
    'Indian/Mauritius' => 'インド/モーリシャス',
    'Indian/Mayotte' => 'インド/マヨット島',
    'Africa/Casablanca' => 'アフリカ/カサブランカ',
    'Africa/El_Aaiun' => 'アフリカ/El_Aaiun',
    'Africa/Maputo' => 'アフリカ/マプト',
    'Africa/Windhoek' => 'アフリカ/ウィントフック',
    'Africa/Niamey' => 'アフリカ/ニアメ',
    'Africa/Lagos' => 'アフリカ/ラゴス',
    'Indian/Reunion' => 'インド/レユニオン',
    'Africa/Kigali' => 'アフリカ/キガリ',
    'Atlantic/St_Helena' => 'アトランティック/セントヘレナ',
    'Africa/Sao_Tome' => 'アフリカ/サントメ',
    'Africa/Dakar' => 'アフリカ/ダカール',
    'Indian/Mahe' => 'インド/マヘ',
    'Africa/Freetown' => 'アフリカ/フリータウン',
    'Africa/Mogadishu' => 'アフリカ/モガディシュ',
    'Africa/Johannesburg' => 'アフリカ/ヨハネスブルグ',
    'Africa/Khartoum' => 'アフリカ/ハルツーム',
    'Africa/Mbabane' => 'アフリカ/ムババネ',
    'Africa/Dar_es_Salaam' => 'アフリカ/ダルエスサラーム',
    'Africa/Lome' => 'アフリカ/ロメ',
    'Africa/Tunis' => 'アフリカ/チュニス',
    'Africa/Kampala' => 'アフリカ/カンパラ',
    'Africa/Lusaka' => 'アフリカ/ルサカ',
    'Africa/Harare' => 'アフリカ/ハラレ',
    'Antarctica/Casey' => '南極/ケーシー',
    'Antarctica/Davis' => '南極/デイヴィス',
    'Antarctica/Mawson' => '南極/モーソン',
    'Indian/Kerguelen' => 'インド/ケルゲレン',
    'Antarctica/DumontDUrville' => '南極/デュモン・デュルヴィル',
    'Antarctica/Syowa' => '南極/昭和基地',
    'Antarctica/Vostok' => '南極/ボストーク',
    'Antarctica/Rothera' => '南極/ロゼラ',
    'Antarctica/Palmer' => '南極/パーマー',
    'Antarctica/McMurdo' => '南極/マクマード',
    'Asia/Kabul' => 'アジア/カブール',
    'Asia/Yerevan' => 'アジア/エレバン',
    'Asia/Baku' => 'アジア/バクー',
    'Asia/Bahrain' => 'アジア/バーレーン',
    'Asia/Dhaka' => 'アジア/ダッカ',
    'Asia/Thimphu' => 'アジア/ティンプー',
    'Indian/Chagos' => 'インド/チャゴス',
    'Asia/Brunei' => 'アジア/ブルネイ',
    'Asia/Rangoon' => 'アジア/ラングーン',
    'Asia/Phnom_Penh' => 'アジア/プノンペン',
    'Asia/Beijing' => 'アジア/北京',
    'Asia/Harbin' => 'アジア/ハルビン',
    'Asia/Shanghai' => 'アジア/上海',
    'Asia/Chongqing' => 'アジア/重慶',
    'Asia/Urumqi' => 'アジア/ウルムチ',
    'Asia/Kashgar' => 'アジア/カシュガル',
    'Asia/Hong_Kong' => 'アジア/香港',
    'Asia/Taipei' => 'アジア/台北',
    'Asia/Macau' => 'アジア/マカオ',
    'Asia/Nicosia' => 'アジア/ニコシア',
    'Asia/Tbilisi' => 'アジア/トビリシ',
    'Asia/Dili' => 'アジア/ディリ',
    'Asia/Calcutta' => 'アジア/カルカッタ',
    'Asia/Jakarta' => 'アジア/ジャカルタ',
    'Asia/Pontianak' => 'アジア/ポンティアナック',
    'Asia/Makassar' => 'アジア/マカッサル',
    'Asia/Jayapura' => 'アジア/ジャヤプラ',
    'Asia/Tehran' => 'アジア/テヘラン',
    'Asia/Baghdad' => 'アジア/バグダッド',
    'Asia/Jerusalem' => 'アジア/エルサレム',
    'Asia/Tokyo' => 'アジア/東京',
    'Asia/Amman' => 'アジア/アンマン',
    'Asia/Almaty' => 'アジア/アルマトイ',
    'Asia/Qyzylorda' => 'アジア/Qyzylorda',
    'Asia/Aqtobe' => 'アジア/アクトベ',
    'Asia/Aqtau' => 'アジア/アクタウ',
    'Asia/Oral' => 'アジア/オラル',
    'Asia/Bishkek' => 'アジア/ビシュケク',
    'Asia/Seoul' => 'アジア/ソウル',
    'Asia/Pyongyang' => 'アジア/平壌',
    'Asia/Kuwait' => 'アジア/クウェート',
    'Asia/Vientiane' => 'アジア/ビエンチャン',
    'Asia/Beirut' => 'アジア/ベイルート',
    'Asia/Kuala_Lumpur' => 'アジア/クアラランプール',
    'Asia/Kuching' => 'アジア/クチン',
    'Indian/Maldives' => 'インド/モルディブ',
    'Asia/Hovd' => 'アジア/ホブド',
    'Asia/Ulaanbaatar' => 'アジア/ウランバートル',
    'Asia/Choibalsan' => 'アジア/チョイバルサン',
    'Asia/Katmandu' => 'アジア/カトマンズ',
    'Asia/Muscat' => 'アジア/マスカット',
    'Asia/Karachi' => 'アジア/カラチ',
    'Asia/Gaza' => 'アジア/ガザ',
    'Asia/Manila' => 'アジア/マニラ',
    'Asia/Qatar' => 'アジア/カタール',
    'Asia/Riyadh' => 'アジア/リヤド',
    'Asia/Singapore' => 'アジア/シンガポール',
    'Asia/Colombo' => 'アジア/コロンボ',
    'Asia/Damascus' => 'アジア/ダマスカス',
    'Asia/Dushanbe' => 'アジア/ドゥシャンベ',
    'Asia/Bangkok' => 'アジア/バンコク',
    'Asia/Ashgabat' => 'アジア/アシガバート',
    'Asia/Dubai' => 'アジア/ドバイ',
    'Asia/Samarkand' => 'アジア/サマルカンド',
    'Asia/Tashkent' => 'アジア/タシケント',
    'Asia/Saigon' => 'アジア/サイゴン',
    'Asia/Aden' => 'アジア/アデン',
    'Australia/Darwin' => 'オーストラリア/ダーウィン',
    'Australia/Perth' => 'オーストラリア/パース',
    'Australia/Brisbane' => 'オーストラリア/ブリスベン',
    'Australia/Lindeman' => 'オーストラリア/リンドマン',
    'Australia/Adelaide' => 'オーストラリア/アデレード',
    'Australia/Hobart' => 'オーストラリア/ホバート',
    'Australia/Currie' => 'オーストラリア/カリー',
    'Australia/Melbourne' => 'オーストラリア/メルボルン',
    'Australia/Sydney' => 'オーストラリア/シドニー',
    'Australia/Broken_Hill' => 'オーストラリア/ブロークンヒル',
    'Indian/Christmas' => 'インド/クリスマス',
    'Pacific/Rarotonga' => 'パシフィック/ラロトンガ',
    'Indian/Cocos' => 'インド/ココス',
    'Pacific/Fiji' => '太平洋/フィジー',
    'Pacific/Gambier' => '太平洋/ガンビア',
    'Pacific/Marquesas' => '太平洋/マルケサス諸島',
    'Pacific/Tahiti' => '太平洋/タヒチ',
    'Pacific/Guam' => '太平洋/グアム',
    'Pacific/Tarawa' => '太平洋/タラワ',
    'Pacific/Enderbury' => '太平洋/エンダーベリー',
    'Pacific/Kiritimati' => '太平洋/キリティマティ',
    'Pacific/Saipan' => '太平洋/サイパン',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Kwajalein' => '太平洋/クエジェリン',
    'Pacific/Truk' => '太平洋/トラック諸島',
    'Pacific/Ponape' => '太平洋/ポナペ',
    'Pacific/Kosrae' => '太平洋/コスラエ',
    'Pacific/Nauru' => '太平洋/ナウル',
    'Pacific/Noumea' => '太平洋/ヌメア',
    'Pacific/Auckland' => '太平洋/オークランド',
    'Pacific/Chatham' => '太平洋/チャタム',
    'Pacific/Niue' => '太平洋/ニウエ',
    'Pacific/Norfolk' => '太平洋/ノーフォーク',
    'Pacific/Palau' => '太平洋/パラオ',
    'Pacific/Port_Moresby' => '太平洋/ポートモレスビー',
    'Pacific/Pitcairn' => '太平洋/ピトケアン',
    'Pacific/Pago_Pago' => '太平洋/パゴパゴ',
    'Pacific/Apia' => '太平洋/アピア',
    'Pacific/Guadalcanal' => '太平洋/ガダルカナル島',
    'Pacific/Fakaofo' => '太平洋/ファカオフォ',
    'Pacific/Tongatapu' => '太平洋/トンガタプ',
    'Pacific/Funafuti' => '太平洋/フナフチ',
    'Pacific/Johnston' => '太平洋/ジョンストン',
    'Pacific/Midway' => '太平洋/ミッドウェイ',
    'Pacific/Wake' => '太平洋/ウェーク',
    'Pacific/Efate' => '太平洋/エファテ島',
    'Pacific/Wallis' => '太平洋/ウォリス',
    'Europe/London' => 'ヨーロッパ/ロンドン',
    'Europe/Dublin' => 'ヨーロッパ/ダブリン',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'ヨーロッパ/チラネ',
    'Europe/Andorra' => 'ヨーロッパ/アンドラ',
    'Europe/Vienna' => 'ヨーロッパ/ウィーン',
    'Europe/Minsk' => 'ヨーロッパ/ミンスク',
    'Europe/Brussels' => 'ヨーロッパ/ブリュッセル',
    'Europe/Sofia' => 'ヨーロッパ/ソフィア',
    'Europe/Prague' => 'ヨーロッパ/プラハ',
    'Europe/Copenhagen' => 'ヨーロッパ/コペンハーゲン',
    'Atlantic/Faeroe' => 'アトランティック/フェロー',
    'America/Danmarkshavn' => 'アメリカ/Danmarkshavn',
    'America/Scoresbysund' => 'アメリカ/スコルズビスン',
    'America/Godthab' => 'アメリカ/ヌーク',
    'America/Thule' => 'アメリカ/トゥーレ',
    'Europe/Tallinn' => 'ヨーロッパ/タリン',
    'Europe/Helsinki' => 'ヨーロッパ/ヘルシンキ',
    'Europe/Paris' => 'ヨーロッパ/パリ',
    'Europe/Berlin' => 'ヨーロッパ/ベルリン',
    'Europe/Gibraltar' => 'ヨーロッパ/ジブラルタル',
    'Europe/Athens' => 'ヨーロッパ/アテネ',
    'Europe/Budapest' => 'ヨーロッパ/ブダペスト',
    'Atlantic/Reykjavik' => 'アトランティック/レイキャビク',
    'Europe/Rome' => 'ヨーロッパ/ローマ',
    'Europe/Riga' => 'ヨーロッパ/リガ',
    'Europe/Vaduz' => 'ヨーロッパ/ファドゥーツ',
    'Europe/Vilnius' => 'ヨーロッパ/ビリニュス',
    'Europe/Luxembourg' => 'ヨーロッパ/ルクセンブルク',
    'Europe/Malta' => 'ヨーロッパ/マルタ',
    'Europe/Chisinau' => 'ヨーロッパ/キシナウ',
    'Europe/Monaco' => 'ヨーロッパ/モナコ',
    'Europe/Amsterdam' => 'ヨーロッパ/アムステルダム',
    'Europe/Oslo' => 'ヨーロッパ/オスロ',
    'Europe/Warsaw' => 'ヨーロッパ/ワルシャワ',
    'Europe/Lisbon' => 'ヨーロッパ/リスボン',
    'Atlantic/Azores' => 'アトランティック/アゾレス諸島',
    'Atlantic/Madeira' => 'アトランティック/マデイラ',
    'Europe/Bucharest' => 'ヨーロッパ/ブカレスト',
    'Europe/Kaliningrad' => 'ヨーロッパ/カリーニング ラード',
    'Europe/Moscow' => 'ヨーロッパ/モスクワ',
    'Europe/Samara' => 'ヨーロッパ/サマラ',
    'Asia/Yekaterinburg' => 'アジア/エカテリンブルク',
    'Asia/Omsk' => 'アジア/オムスク',
    'Asia/Novosibirsk' => 'アジア/ノボシビルスク',
    'Asia/Krasnoyarsk' => 'アジア/クラスノヤルスク',
    'Asia/Irkutsk' => 'アジア/イルクーツク',
    'Asia/Yakutsk' => 'アジア/ヤクーツク',
    'Asia/Vladivostok' => 'アジア/ウラジオストク',
    'Asia/Sakhalin' => 'アジア/サハリン',
    'Asia/Magadan' => 'アジア/マガダン',
    'Asia/Kamchatka' => 'アジア/カムチャッカ',
    'Asia/Anadyr' => 'アジア/アナディリ',
    'Europe/Belgrade' => 'ヨーロッパ/ベオグラード',
    'Europe/Madrid' => 'ヨーロッパ/マドリード',
    'Africa/Ceuta' => 'アフリカ/セウタ',
    'Atlantic/Canary' => 'アトランティック/カナリア',
    'Europe/Stockholm' => 'ヨーロッパ/ストックホルム',
    'Europe/Zurich' => 'ヨーロッパ/チューリッヒ',
    'Europe/Istanbul' => 'ヨーロッパ/イスタンブール',
    'Europe/Kiev' => 'ヨーロッパ/キエフ',
    'Europe/Uzhgorod' => 'ヨーロッパ/ウージュホロド',
    'Europe/Zaporozhye' => 'ヨーロッパ/ザポリージャ',
    'Europe/Simferopol' => 'ヨーロッパ/シンフェロポリ',
    'America/New_York' => 'アメリカ/ニューヨーク',
    'America/Chicago' => 'アメリカ/シカゴ',
    'America/North_Dakota/Center' => 'アメリカ/ノース ダコタ/中央',
    'America/Denver' => 'アメリカ/デンバー',
    'America/Los_Angeles' => 'アメリカ/ロサンジェルス',
    'America/Juneau' => 'アメリカ/ジュノー',
    'America/Yakutat' => 'アメリカ/ヤクタット',
    'America/Anchorage' => 'アメリカ/アンカレッジ',
    'America/Nome' => 'アメリカ/ノーム',
    'America/Adak' => 'アメリカ/アダック',
    'Pacific/Honolulu' => '太平洋/ホノルル',
    'America/Phoenix' => 'アメリカ/フェニックス',
    'America/Boise' => 'アメリカ/ボイジー',
    'America/Indiana/Indianapolis' => 'アメリカ/インディアナ/インディ アナポリス',
    'America/Indiana/Marengo' => 'アメリカ/インディアナ/マレンゴ',
    'America/Indiana/Knox' => 'アメリカ/インディアナ/ノックス',
    'America/Indiana/Vevay' => 'アメリカ/インディアナ/ヴヴェイ',
    'America/Kentucky/Louisville' => 'アメリカ/ケンタッキー/ルイビル',
    'America/Kentucky/Monticello' => 'アメリカ/ケンタッキー/モンティセロ',
    'America/Detroit' => 'アメリカ/デトロイト',
    'America/Menominee' => 'アメリカ/メノミニー',
    'America/St_Johns' => 'アメリカ/セントジョンズ',
    'America/Goose_Bay' => 'アメリカ/グースベイ',
    'America/Halifax' => 'アメリカ/ハリファックス',
    'America/Glace_Bay' => 'アメリカ/グレースベイ',
    'America/Montreal' => 'アメリカ/モントリオール',
    'America/Toronto' => 'アメリカ/トロント',
    'America/Thunder_Bay' => 'アメリカ/サンダーベイ',
    'America/Nipigon' => 'アメリカ/ニピゴン',
    'America/Rainy_River' => 'アメリカ/レイニーリバー',
    'America/Winnipeg' => 'アメリカ/ウィニペグ',
    'America/Regina' => 'アメリカ/レジーナ',
    'America/Swift_Current' => 'アメリカ/スウィフトカレント',
    'America/Edmonton' => 'アメリカ/エドモントン',
    'America/Vancouver' => 'アメリカ/バンクーバー',
    'America/Dawson_Creek' => 'アメリカ/ドーソンクリーク',
    'America/Pangnirtung' => 'アメリカ/パングニータング',
    'America/Iqaluit' => 'アメリカ/イカルイト',
    'America/Coral_Harbour' => 'アメリカ/コーラルハーバー',
    'America/Rankin_Inlet' => 'アメリカ/ランキンインレット',
    'America/Cambridge_Bay' => 'アメリカ/ケンブリッジ・ベイ',
    'America/Yellowknife' => 'アメリカ/イエロー ナイフ',
    'America/Inuvik' => 'アメリカ/イヌヴィック',
    'America/Whitehorse' => 'アメリカ/ホワイト ホース',
    'America/Dawson' => 'アメリカ/ドーソン',
    'America/Cancun' => 'アメリカ/カンクン',
    'America/Merida' => 'アメリカ/メリダ',
    'America/Monterrey' => 'アメリカ/モンテレー',
    'America/Mexico_City' => 'アメリカ/メキシコシティ',
    'America/Chihuahua' => 'アメリカ/チワワ',
    'America/Hermosillo' => 'アメリカ/エルモシージョ',
    'America/Mazatlan' => 'アメリカ/マサトラン',
    'America/Tijuana' => 'アメリカ/ティファナ',
    'America/Anguilla' => 'アメリカ/アンギラ',
    'America/Antigua' => 'アメリカ/アンティグア',
    'America/Nassau' => 'アメリカ/ナッソー',
    'America/Barbados' => 'アメリカ/バルバドス',
    'America/Belize' => 'アメリカ/ベリーズ',
    'Atlantic/Bermuda' => '大西洋/バミューダ',
    'America/Cayman' => 'アメリカ/ケイマン',
    'America/Costa_Rica' => 'アメリカ/コスタリカ',
    'America/Havana' => 'アメリカ/ハバナ',
    'America/Dominica' => 'アメリカ/ドミニカ国',
    'America/Santo_Domingo' => 'アメリカ/サントドミンゴ',
    'America/El_Salvador' => 'アメリカ/エルサルバドル',
    'America/Grenada' => 'アメリカ/グレナダ',
    'America/Guadeloupe' => 'アメリカ/グアドループ',
    'America/Guatemala' => 'アメリカ/グアテマラ',
    'America/Port-au-Prince' => 'アメリカ/ポルトープランス',
    'America/Tegucigalpa' => 'アメリカ/テグシガルパ',
    'America/Jamaica' => 'アメリカ/ジャマイカ',
    'America/Martinique' => 'アメリカ/マルティニーク',
    'America/Montserrat' => 'アメリカ/モントセラト',
    'America/Managua' => 'アメリカ/マナグア',
    'America/Panama' => 'アメリカ/パナマ',
    'America/Puerto_Rico' => 'アメリカ/プエルトリコ',
    'America/St_Kitts' => 'アメリカ/セントキッツ島',
    'America/St_Lucia' => 'アメリカ/セントルシア',
    'America/Miquelon' => 'アメリカ/サンピエール島ミクロン島',
    'America/St_Vincent' => 'アメリカ/セントビン セント',
    'America/Grand_Turk' => 'アメリカ/グランドターク',
    'America/Tortola' => 'アメリカ/トルトラ',
    'America/St_Thomas' => 'アメリカ/セントトマス',
    'America/Argentina/Buenos_Aires' => 'アメリカ/アルゼンチン/ブエノスアイレス',
    'America/Argentina/Cordoba' => 'アメリカ/アルゼンチン/コルドバ',
    'America/Argentina/Tucuman' => 'アメリカ/アルゼンチン/トゥクマン',
    'America/Argentina/La_Rioja' => 'アメリカ/アルゼンチン/ラ・リオハ',
    'America/Argentina/San_Juan' => 'アメリカ/アルゼンチン/サンフアン',
    'America/Argentina/Jujuy' => 'アメリカ/アルゼンチン/フフイ',
    'America/Argentina/Catamarca' => 'アメリカ/アルゼンチン/カタマルカ',
    'America/Argentina/Mendoza' => 'アメリカ/アルゼンチン/メンドーサ',
    'America/Argentina/Rio_Gallegos' => 'アメリカ/アルゼンチン/リオ・ガジェゴス',
    'America/Argentina/Ushuaia' => 'アメリカ/アルゼンチン/ウシュアイア',
    'America/Aruba' => 'アメリカ/アルバ',
    'America/La_Paz' => 'アメリカ/ラパス',
    'America/Noronha' => 'アメリカ/ノローニャ',
    'America/Belem' => 'アメリカ/ベレン',
    'America/Fortaleza' => 'アメリカ/フォルタレザ',
    'America/Recife' => 'アメリカ/レシフェ',
    'America/Araguaina' => 'アメリカ/アラグァイーナ',
    'America/Maceio' => 'アメリカ/マセイオ',
    'America/Bahia' => 'アメリカ/バイア',
    'America/Sao_Paulo' => 'アメリカ/サンパウロ',
    'America/Campo_Grande' => 'アメリカ/カンポグランデ',
    'America/Cuiaba' => 'アメリカ/クイアバ',
    'America/Porto_Velho' => 'アメリカ/ポルト・ヴェーリョ',
    'America/Boa_Vista' => 'アメリカ/ボア・ヴィスタ',
    'America/Manaus' => 'アメリカ/マナウス',
    'America/Eirunepe' => 'アメリカ/エイルネペ',
    'America/Rio_Branco' => 'アメリカ/リオブランコ',
    'America/Santiago' => 'アメリカ/サンチアゴ',
    'Pacific/Easter' => '太平洋/イースター',
    'America/Bogota' => 'アメリカ/ボゴタ',
    'America/Curacao' => 'アメリカ/キュラソー',
    'America/Guayaquil' => 'アメリカ/グアヤキル',
    'Pacific/Galapagos' => '太平洋/ガラパゴス',
    'Atlantic/Stanley' => '大西洋/スタンレー',
    'America/Cayenne' => 'アメリカ/カイエン',
    'America/Guyana' => 'アメリカ/ガイアナ',
    'America/Asuncion' => 'アメリカ/アスンシオン',
    'America/Lima' => 'アメリカ/リマ',
    'Atlantic/South_Georgia' => 'アトランティック/サウス・ジョージア',
    'America/Paramaribo' => 'アメリカ/パラマリボ',
    'America/Port_of_Spain' => 'アメリカ/ポートオブスペイン',
    'America/Montevideo' => 'アメリカ/モンテビデオ',
    'America/Caracas' => 'アメリカ/カラカス',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'お気に入り';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'お気に入り';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google 連絡先',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google ドライブ',
];
$app_list_strings['token_status'] = [
    1 => 'リクエスト',
    2 => 'アクセス権',
    3 => '無効',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'アサイン先',
    'support_portal' => 'サポートポータル',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'キャンペーン',
    'email' => 'Eメール',
    'workflow' => 'ワークフロー',
    'system' => 'システム',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'キャンペーン',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'キャンペーン',
    'email' => 'Eメール',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'ドキュメント',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => '2つの期間',
    'show_buckets' => '3つの期間',
    'show_custom_buckets' => 'カスタム範囲',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'データベース年',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => '年間（サブピリオド　四半期）',
    'Quarter' => '四半期（サブピリオド　月）',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => '商談品目',
    'Opportunities' => '商談',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'はい',
    'no' => 'いいえ',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'アラート',
    'information' => '情報',
    'other' => 'その他',
    'success' => '成功',
    'warning' => '警告:',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'GET',
    'PUT' => 'PUT',
    'DELETE' => '削除',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => '手動',
    '5' => '5分ごと',
    '15' => '15分毎',
    '30' => '30分毎',
    '60' => '1時間毎',
];

$app_list_strings['moduleList']['KBDocuments'] = 'ナレッジベース';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'ナレッジベース';
$app_list_strings['moduleList']['KBContents'] = 'ナレッジベース';
$app_list_strings['moduleListSingular']['KBContents'] = 'ナレッジベース記事';
$app_list_strings['moduleList']['KBArticles'] = 'ナレッジベース記事';
$app_list_strings['moduleListSingular']['KBArticles'] = 'ナレッジベース記事';
$app_list_strings['moduleList']['KBContentTemplates'] = 'ナレッジ ベース テンプレート';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'ナレッジ ベース テンプレート';
$app_list_strings['moduleList']['EmbeddedFiles'] = '埋め込みファイル';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = '埋め込みファイル';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'レク',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'レク',
    'USD' => 'ドル',
    'AFN' => 'アフガニ',
    'ARS' => 'ペソ',
    'AWG' => 'ギルダー',
    'AUD' => 'ドル',
    'AZN' => 'ニューマナト',
    'BSD' => 'ドル',
    'BBD' => 'ドル',
    'BYR' => 'ルーブル',
    'EUR' => 'ユーロ',
    'BZD' => 'ドル',
    'BMD' => 'ドル',
    'BOB' => 'ボリビアノ',
    'BAM' => '兌換マルカ',
    'BWP' => 'プラ',
    'BGN' => 'レフ',
    'BRL' => 'レアイス',
    'GBP' => 'ポンド',
    'BND' => 'ドル',
    'KHR' => 'リエル',
    'CAD' => 'ドル',
    'KYD' => 'ドル',
    'CLP' => 'ペソ',
    'CNY' => '人民元',
    'COP' => 'ペソ',
    'CRC' => 'ColÃ³n',
    'HRK' => 'クナ',
    'CUP' => 'ペソ',
    'CZK' => 'コルナ',
    'DKK' => 'クローネ',
    'DOP' => 'ペソ',
    'XCD' => 'ドル',
    'EGP' => 'ポンド',
    'SVC' => 'コロン',
    'EEK' => 'クローン',
    'FKP' => 'ポンド',
    'FJD' => 'ドル',
    'GHC' => 'セディ',
    'GIP' => 'ポンド',
    'GTQ' => 'ケツァル',
    'GGP' => 'ポンド',
    'GYD' => 'ドル',
    'HNL' => 'レンピラ',
    'HKD' => 'ドル',
    'HUF' => 'フォリント',
    'ISK' => 'クローナ',
    'INR' => 'ルピー',
    'IDR' => 'ルピア',
    'IRR' => 'リアル',
    'IMP' => 'ポンド',
    'ILS' => '新シェケル',
    'JMD' => 'ドル',
    'JPY' => '円',
    'JEP' => 'ポンド',
    'KZT' => 'テンゲ',
    'KPW' => 'ウォン',
    'KRW' => 'ウォン',
    'KGS' => 'ソム',
    'LAK' => 'キップ',
    'LVL' => 'ラット',
    'LBP' => 'ポンド',
    'LRD' => 'ドル',
    'CHF' => 'スイス フラン',
    'LTL' => 'リータス',
    'MKD' => 'デナル',
    'MYR' => 'リンギット',
    'MUR' => 'ルピー',
    'MXN' => 'ペソ',
    'MNT' => 'トゥグリク',
    'MZN' => 'メティカル',
    'NAD' => 'ドル',
    'NPR' => 'ルピー',
    'ANG' => 'ギルダー',
    'NZD' => 'ドル',
    'NIO' => 'コルドバ',
    'NGN' => 'ナイラ',
    'NOK' => 'クローネ',
    'OMR' => 'リアル',
    'PKR' => 'ルピー',
    'PAB' => 'バルボア',
    'PYG' => 'グアラニー',
    'PEN' => 'ヌエボ・ソル',
    'PHP' => 'ペソ',
    'PLN' => 'ズウォティ',
    'QAR' => 'リアル',
    'RON' => 'ニューレイ',
    'RUB' => 'ルーブル',
    'SHP' => 'ポンド',
    'SAR' => 'リヤル',
    'RSD' => 'ディナール',
    'SCR' => 'ルピー',
    'SGD' => 'ドル',
    'SBD' => 'ドル',
    'SOS' => 'シリング',
    'ZAR' => 'ランド',
    'LKR' => 'ルピー',
    'SEK' => 'クローナ',
    'SRD' => 'ドル',
    'SYP' => 'ポンド',
    'TWD' => 'ニュードル',
    'THB' => 'バーツ',
    'TTD' => 'ドル',
    'TRY' => 'リラ',
    'TRL' => 'リラ',
    'TVD' => 'ドル',
    'UAH' => 'フリヴニャ',
    'UYU' => 'ペソ',
    'UZS' => 'スム',
    'VEF' => 'ボリーバルフエルテ',
    'VND' => 'ドン',
    'YER' => 'リアル',
    'ZWD' => 'ジンバブエ ドル',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => '非常に高い',
    '4' => '高い',
    '3' => 'どちらでもない',
    '2' => '低い',
    '1' => '非常に低い',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'なし',
    'future' => '現在の値',
    'old' => '以前の値',
    'both' => '現在および以前の値',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'シングルヒット',
];

$app_list_strings['merge_status_list'] = [
    'processing' => '実行中',
    'error' => 'エラー',
    'success' => '成功',
    'canceled' => 'キャンセル済み',
    'document_load' => 'テンプレートを読み込んでいます',
    'tags_extract' => 'タグを抽出しています',
    'tags_validate' => 'タグを有効にしています',
    'data_retrieving' => 'タグを取得しています',
    'serialize_document' => 'ドキュメントを元に戻しています',
    'send_document' => 'ドキュメントをあなたに送信中',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'マージ',
    'convert' => 'PDFマージ',
    'multimerge' => '複数マージ',
    'multimerge_convert' => 'PDFの複数マージ',
    'labelsgenerate' => 'ラベルの生成',
    'labelsgenerate_convert' => 'ラベルPDFの生成',
    'excel' => 'Excelマージ',
    'excel_convert' => 'Excelマージ変換',
    'presentation' => 'PowerPointマージ',
    'presentation_convert' => 'PowerPointマージPDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => '私の取引先',
    'favorites' => 'お気に入りの取引先',
    'tags' => 'タグ付けされた取引先',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'すべてのニュース',
    'General' => '一般',
    'Finance' => '金融',
    'People' => '人事',
    'Press Releases' => 'プレスリリース',
    'Other' => 'その他',
];

$app_strings['LBL_OWNERS'] = 'オーナー';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'クラウドドライブ';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'クラウドドライブ統合ダッシュレット';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'リンクをコピー';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'ダウンロード';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Sugarドキュメントを作成';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'このファイルをダウンロードできません';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'クラウドダッシュレットは存在しません';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar キュメントが作成されました';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'DocuSignに送信';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSignはこの場所からは利用できません。';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'Word/Excel/PowerPoint へのドキュメントマージは、この場所からは使用できません';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'DocuSignへのドキュメントマージはこの場所からは利用できません';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'PDFへのドキュメントマージはこの場所からは利用できません';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = '署名されたファイルは、この場所にアップロードする権限がある場合にのみここにアップロードされます。';
$app_strings['LBL_DOC_MERGE_TO'] = 'ドキュメントマージ先';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'マイファイル';
$app_strings['LBL_SHARED_WITH_ME'] = '共有アイテム';
$app_strings['LBL_CLOUD_PROVIDER'] = 'クラウドプロバイダー';

$app_list_strings['drive_types'] = [
    'google' => 'Google ドライブ',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropboxドライブ',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = '自分へ共有済み';
$app_strings['LBL_MY_FILES'] = 'マイファイル';
$app_strings['LBL_UPLOAD_FILE'] = 'ファイルをアップロード';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'フォルダが見つかりません';
$app_strings['LBL_CREATE_FOLDER'] = 'フォルダを作成';
$app_strings['LBL_LOAD_MORE'] = 'さらに読み込む...';
$app_strings['LBL_NEW_FOLDER'] = '新しいフォルダー';
$app_strings['LBL_FOLDER_NAME'] = 'フォルダー名:';
$app_strings['LBL_PERMISSION_ERROR'] = '現在のパスでそれを行う権限がありません。';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = '現在のパスに進む権限がありません。';
$app_strings['LBL_FILE_UPLOADED'] = 'ファイルがアップロードされました。';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'ファイルのサイズが大きいため、アップロードには時間がかかります。';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = '1つまたは複数のドキュメントのレコードに、添付ファイルがありません。レコードにファイルを添付して再試行するか、ファイルを添付した特定のレコードを個別に同期してください。';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Googleとの接続が見つかりません...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Microsoftとの接続が見つかりません...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Dropboxとの接続が見つかりません...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'OneDriveとの同期には時間がかかることがあります。';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = '本当にこのファイルを削除しますか？';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDriveへのアップロードが完了しました。';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = 'のアップロードに成功しました。';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'パスの読み込み中のエラー。';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'ファイルが破損しているため、エラーが発生しました。';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'ドキュメント <i>"{{documentName}}"</i> がクラウドドライブに保存され、ドキュメントモジュールに追加されました。';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'このファイルを削除する権限がありません。';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'このフォルダーを削除する権限がありません。';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'この場所にファイルをアップロードする権限がありません。';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'この場所にフォルダーを作成する権限がありません。';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'この場所にフォルダーを作成することはできません。';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'この場所にファイルをアップロードすることはできません。';
$app_strings['LBL_SITES'] = 'サイト';
$app_strings['LBL_SHARED'] = '共有済み';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'リンクが作成されました。ボタンをクリックして、リンクをクリップボードにコピーします。';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'クリップボードにコピー';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-なし-',
    'Exact' => '完全に一致',
    'Null_address_components' => '1つまたは複数の住所コンポーネントが空です',
    'Invalid_address' => '無効な住所、サーバーがFalseを返しました',
    'Invalid_server_response_not_XML' => '無効なサーバー応答、XMLではありません',
    'Invalid_address_no_location' => '無効な住所、サーバーが場所を返しませんでした',
    'Ambiguous_address' => 'あいまいな住所、複数一致',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => '道路',
    'a' => '空中',
    'rd' => '道路が暗い',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', '英語 (US)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'ニューヨーク (EST)'],
    ['pst', 'ロサンゼルス (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['新規', '新規'],
    ['アサイン済み', 'アサイン済み'],
    ['完了', '完了'],
    ['保留中', '保留中'],
    ['拒否', '拒否'],
    ['複製', '複製'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['管理', '管理'],
    ['製品', '製品'],
    ['ユーザー', 'ユーザー'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', '高'],
    ['P2', '中'],
    ['P3', '低'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['ユーザー', 'ユーザー'],
    ['管理者、ユーザー', '管理者'],
    ['アカウントマネージャー、ユーザー', 'アカウントマネージャー'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', '過去30日間'],
    ['last_90_days', '過去90日間'],
    ['this_year', '昨年'],
    ['カスタム', 'カスタム範囲'],
    ['すべて', 'すべて'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['デフォルト', 'デフォルト'],
    ['色', '無色'],
    ['URL', 'カスタム画像'],
];
