<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'עברית',
    'moduleList' => [
        'Home' => 'בית',
        'Contacts' => 'אנשי קשר',
        'Accounts' => 'חשבונות',
        'Opportunities' => 'הזדמנויות',
        'Cases' => 'אירועים',
        'Notes' => 'הערות',
        'Calls' => 'שיחות טלפון',
        'Emails' => 'דואר אלקטרוני',
        'Meetings' => 'פגישות',
        'Tasks' => 'משימות',
        'Calendar' => 'לוח שנה',
        'Leads' => 'לידים',
        'Currencies' => 'מטבעות',
        'Contracts' => 'חוזים',
        'Quotes' => 'הצעות מחיר',
        'Products' => 'פרטי שורה מצוטטים',
        'WebLogicHooks' => 'Web Logic Hooks',
        'ProductCategories' => 'קטגוריית מוצרים',
        'ProductTypes' => 'סוגי מוצרים',
        'ProductTemplates' => 'קטלוג מוצרים',
        'ProductBundles' => 'מארזי מוצרים',
        'ProductBundleNotes' => 'הערות למארזי מוצר',
        'Reports' => 'דוחות',
        'Forecasts' => 'תחזיות',
        'ForecastWorksheets' => 'גליונות תחזית',
        'ForecastManagerWorksheets' => 'גליונות  תחזית למנהל',
        'VisualPipeline' => 'צינור ויזואלי',
        'ConsoleConfiguration' => 'תצורת מסוף',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'מיכסות',
        'Teams' => 'קבוצות',
        'TeamNotices' => 'הודעות לצוות',
        'Manufacturers' => 'יצרנים',
        'Activities' => 'פעילויות',
        'Comments' => 'הערות',
        'Subscriptions' => 'מנויים',
        'Bugs' => 'באגים',
        'Feeds' => 'RSS',
        'iFrames' => 'האתרים שלי',
        'TimePeriods' => 'משכי זמן',
        'TaxRates' => 'שעורי מס',
        'ContractTypes' => 'סוגי חוזים',
        'Schedulers' => 'מתזמנים',
        'Project' => 'פרויקטים',
        'ProjectTask' => 'משימות בפרויקט',
        'Campaigns' => 'קמפיינים',
        'CampaignLog' => 'יומן קמפיין',
        'CampaignTrackers' => 'גששי קמפיין',
        'Documents' => 'מסמכים',
        'DocumentRevisions' => 'מסמכים בבדיקה מחדש',
        'Connectors' => 'מחברים',
        'Notifications' => 'הודעות',
        'Sync' => 'סנכרן',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => 'משתמשים חיצוניים',
        'ReportMaker' => 'Enterprise Reports',
        'DataSets' => 'תבניות נתונים',
        'CustomQueries' => 'שאלתות מותאמות',
        'pmse_Inbox' => 'תהליך',
        'pmse_Project' => 'הגדרת תהליך',
        'pmse_Business_Rules' => 'תהליך כללים עסקיים',
        'pmse_Emails_Templates' => 'תבניות מייל תהליך',
        'BusinessCenters' => 'מרכזי עסקים',
        'Shifts' => 'משמרות',
        'ShiftExceptions' => 'החרגות למשמרות',
        'Purchases' => 'רכישות',
        'PurchasedLineItems' => 'פריטי שורה - רכישות',
        'MobileDevices' => 'מכשירים ניידים',
        'PushNotifications' => 'הודעות בדחיפה',
        'Escalations' => 'הסלמות',
        'DocumentTemplates' => 'תבניות מסמכים',
        'DocumentMerges' => 'מיזוגי מסמכים',
        'CloudDrivePaths' => 'נתיבים לכונן הענן',
        'WorkFlow' => 'הגדרות זרימת עבודה',
        'EAPM' => 'חשבונות חיצוניים',
        'Worksheet' => 'גיליון עבודה',
        'Users' => 'משתמשים',
        'Employees' => 'עובדים',
        'Administration' => 'ניהול מערכת',
        'ACLRoles' => 'תפקידים',
        'InboundEmail' => 'Group Mail Account',
        'Releases' => 'שיחרורים',
        'Prospects' => 'מטרות',
        'Queues' => 'תורים',
        'EmailMarketing' => 'דואר שיווקי',
        'EmailTemplates' => 'תבניות דואר אלקטרוני',
        'SNIP' => 'ארכיון דואר אלקטרוני',
        'ProspectLists' => 'רשימת מטרות',
        'SavedSearch' => 'חיפושים שמורים',
        'UpgradeWizard' => 'אשף שדרוג',
        'Trackers' => 'גששים',
        'TrackerPerfs' => 'ביצועים של גשש',
        'TrackerSessions' => 'מעקב אחר הפעלות',
        'TrackerQueries' => 'שאילתות לגשש',
        'FAQ' => 'שאלות נפוצות',
        'Newsletters' => 'ניוזלטרים',
        'SugarFavorites' => 'מועדפים',
        'PdfManager' => 'מנהל PDF',
        'DataArchiver' => 'מאחסן נתונים בארכיון',
        'ArchiveRuns' => 'הפעלות ארכיון',

        'OAuthKeys' => 'מפתחי לקוח OAuth',
        'OAuthTokens' => 'אסימוני OAuth',
        'Filters' => 'מסננים',
        'UserSignatures' => 'חתימות דוא"ל',
        'Shippers' => 'חברות שילוח',
        'Styleguide' => 'מדריך סגנון',
        'Feedbacks' => 'משובים',
        'Tags' => 'תגיות',
        'Categories' => 'קטגוריות',
        'Dashboards' => 'לוחות מחוונים',
        'OutboundEmail' => 'הגדרות דוא"ל',
        'EmailParticipants' => 'המשתתפים בדוא"ל',
        'DataPrivacy' => 'פרטיות נתונים',
        'ReportSchedules' => 'דווח על לוחות זמנים',
        'CommentLog' => 'יומן הערות',
        'Holidays' => 'חגים וחופשות',
        'ChangeTimers' => 'שינוי טיימרים',
        'Metrics' => 'מדדים',
        'Messages' => 'הודעות',
        'Audit' => 'ביקורת',
        'RevenueLineItems' => 'פריטי שורות הכנסה',
        'DocuSignEnvelopes' => 'מעטפות DocuSign',
        'Geocode' => 'קוד גיאוגרפי',
        'DRI_Workflows' => 'מדריכים חכמים',
        'DRI_Workflow_Task_Templates' => 'תבניות פעילות של מדריכים חכמים',
        'DRI_SubWorkflows' => 'שלבי מדריך חכם',
        'DRI_Workflow_Templates' => 'תבניות של מדריכים חכמים',
        'CJ_WebHooks' => 'רכיבי Web Hook של Sugar Automate',
        'CJ_Forms' => 'פעולות Smart Guide ב-Sugar',
        'DRI_SubWorkflow_Templates' => 'תבניות שלבים של מדריכים חכמים',
        'PubSub_ModuleEvent_PushSubs' => 'מנויי דחיפה של אירוע מודול Pub/Sub',
    ],

    'moduleIconList' => [
        'Home' => 'בי&#39;',
        'Contacts' => 'אנ&#39;',
        'Accounts' => 'חש&#39;',
        'Opportunities' => 'הז&#39;',
        'Cases' => 'אירועים',
        'Notes' => 'פתקים',
        'Calls' => 'שיחות טלפון',
        'Emails' => 'הו&#39;',
        'Meetings' => 'פג&#39;',
        'Tasks' => 'משימות',
        'Calendar' => 'לו&#39;',
        'Leads' => 'לי&#39;',
        'Currencies' => 'מט&#39;',
        'Contracts' => 'חו&#39;',
        'Quotes' => 'הצ&#39;',
        'Products' => 'QL',
        'WebLogicHooks' => 'WL',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'PT',
        'ProductTemplates' => 'PC',
        'ProductBundles' => 'PB',
        'ProductBundleNotes' => 'PB',
        'Reports' => 'דו&#39;',
        'Forecasts' => 'תח&#39;',
        'ForecastWorksheets' => 'FW',
        'ForecastManagerWorksheets' => 'FM',
        'Quotas' => 'עבור',
        'VisualPipeline' => 'VP',
        'ConsoleConfiguration' => 'CC',
        'SugarLive' => 'Su',
        'Teams' => 'צו&#39;',
        'TeamNotices' => 'TN',
        'Manufacturers' => 'יצ&#39;',
        'Activities' => 'פע&#39;',
        'Comments' => 'הע&#39;',
        'Subscriptions' => 'מי&#39;',
        'Bugs' => 'בא&#39;',
        'Feeds' => 'RS',
        'iFrames' => 'MS',
        'TimePeriods' => 'TP',
        'TaxRates' => 'TR',
        'ContractTypes' => 'CT',
        'Schedulers' => 'מת&#39;',
        'Project' => 'פר&#39;',
        'ProjectTask' => 'PT',
        'Campaigns' => 'קמפיינים',
        'CampaignLog' => 'CL',
        'CampaignTrackers' => 'CT',
        'Documents' => 'מס&#39;',
        'DocumentRevisions' => 'DR',
        'Connectors' => 'מח&#39;',
        'Notifications' => 'הת&#39;',
        'Sync' => 'סנ&#39;',
        'HintAccountsets' => 'רמ&#39;',
        'HintNotificationTargets' => 'רמ&#39;',
        'HintNewsNotifications' => 'רמ&#39;',
        'HintEnrichFieldConfigs' => 'רמ&#39;',
        'ExternalUsers' => 'EU',
        'ReportMaker' => 'AR',
        'DataSets' => 'DF',
        'CustomQueries' => 'CQ',
        'pmse_Inbox' => 'תה&#39;',
        'pmse_Project' => 'PD',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE',
        'BusinessCenters' => 'מרכזי עסקים',
        'Shifts' => 'מש&#39;',
        'ShiftExceptions' => 'SE',
        'Purchases' => 'רכ&#39;',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'ני&#39;',
        'PushNotifications' => 'דח&#39;',
        'Escalations' => 'הס&#39;',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'כ"ע',
        'WorkFlow' => 'WD',
        'EAPM' => 'EA',
        'Worksheet' => 'גי&#39;',
        'Users' => 'מש&#39;',
        'Employees' => 'עו&#39;',
        'Administration' => 'מנ&#39;',
        'ACLRoles' => 'תפ&#39;',
        'InboundEmail' => 'IE',
        'Releases' => 'מה&#39;',
        'Prospects' => 'פו&#39;',
        'Queues' => 'תו&#39;',
        'EmailMarketing' => 'EM',
        'EmailTemplates' => 'ET',
        'SNIP' => 'EA',
        'ProspectLists' => 'TL',
        'SavedSearch' => 'SS',
        'UpgradeWizard' => 'UW',
        'Trackers' => 'עו&#39;',
        'TrackerPerfs' => 'TP',
        'TrackerSessions' => 'TS',
        'TrackerQueries' => 'TQ',
        'FAQ' => 'FA',
        'Newsletters' => 'יד&#39;',
        'SugarFavorites' => 'מו&#39;',
        'PdfManager' => 'PM',
        'DataArchiver' => 'DA',
        'ArchiveRuns' => 'AR',
        'OAuthKeys' => 'OC',
        'OAuthTokens' => 'OT',
        'Filters' => 'מס&#39;',
        'UserSignatures' => 'ES',
        'Shippers' => 'SP',
        'Styleguide' => 'סג&#39;',
        'Feedbacks' => 'מש&#39;',
        'Tags' => 'תג&#39;',
        'Categories' => 'קט&#39;',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'ES',
        'EmailParticipants' => 'EP',
        'DataPrivacy' => 'פ"נ',
        'ReportSchedules' => 'RS',
        'CommentLog' => 'CL',
        'Holidays' => 'חג&#39;',
        'ChangeTimers' => 'CT',
        'Metrics' => 'מד&#39;',
        'Messages' => 'הו&#39;',
        'Audit' => 'בי&#39;',
        'RevenueLineItems' => 'RL',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'גי&#39;',
        'DRI_Workflows' => 'SG',
        'DRI_Workflow_Task_Templates' => 'SG',
        'DRI_SubWorkflows' => 'SG',
        'DRI_Workflow_Templates' => 'SG',
        'CJ_WebHooks' => 'SA',
        'CJ_Forms' => 'SG',
        'DRI_SubWorkflow_Templates' => 'SG',
        'Library' => 'ספ&#39;',
        'EmailAddresses' => 'EA',
        'Words' => 'מי&#39;',
        'Sugar_Favorites' => 'מו&#39;',
        'KBDocuments' => 'KB',
        'KBContents' => 'KB',
        'KBArticles' => 'KB',
        'KBContentTemplates' => 'KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'EF',
    ],

    'moduleListSingular' => [
        'Home' => 'בית',
        'Dashboards' => 'לוח מחוונים',
        'Styleguide' => 'מדריך סגנון',
        'Contacts' => 'איש קשר',
        'Accounts' => 'חשבון',
        'Opportunities' => 'הזדמנות',
        'Cases' => 'פניית שירות',
        'Notes' => 'פתק',
        'Calls' => 'שיחת טלפון',
        'Emails' => 'Any Email',
        'Meetings' => 'פגישה',
        'Tasks' => 'משימה',
        'Calendar' => 'לוח שנה',
        'Leads' => 'ליד',
        'Manufacturers' => 'יצרן',
        'VisualPipeline' => 'צינור-ויזואלי',
        'ConsoleConfiguration' => 'ConsoleConfiguration',
        'MobileDevices' => 'מכשיר נייד',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'חוזה',
        'Quotes' => 'הצעת מחיר',
        'Products' => 'שורת פריט מצוטט',
        'ProductCategories' => 'קטגוריית מוצר:',
        'ProductBundles' => 'מארז מוצר',
        'ProductBundleNotes' => 'הערת מארז מוצר',
        'RevenueLineItems' => 'שורת פריט הכנסה',
        'WebLogicHooks' => 'Web Logic Hook',
        'Reports' => 'דוח',
        'Forecasts' => 'תחזית',
        'ForecastWorksheets' => 'גיליון עבודה לתחזית',
        'ForecastManagerWorksheets' => 'גליון  תחזית למנהל',
        'Quotas' => 'הצעת מחיר',
        'Teams' => 'צוות',
        'TeamNotices' => 'הודעה לצוות',
        'Activities' => 'פעילות',
        'ActivityStream' => 'Activities',
        'Bugs' => 'באג',
        'Feeds' => 'RSS',
        'iFrames' => 'האתרים שלי',
        'TimePeriods' => 'תקופת זמן',
        'TaxRates' => 'שיעור מס',
        'ContractTypes' => 'סוג חוזה',
        'Schedulers' => 'תזמן:',
        'Campaigns' => 'קמפיין',
        'CampaignLog' => 'יומן קמפיין',
        'Project' => 'פרויקט',
        'ProjectTask' => 'משימת הפרויקט',
        'Prospects' => 'מטרה',
        'ProspectLists' => 'רשימת מטרות',
        'CampaignTrackers' => 'עוקב קמפיין',
        'Documents' => 'מסמך',
        'DocumentRevisions' => 'בדיקה מחדש למסמכים',
        'Connectors' => 'מחבר',
        'Notifications' => 'הודעה',
        'Sync' => 'סנכרן',
        'PdfManager' => 'מנהל PDF',
        'DataArchiver' => 'מאחסן נתונים בארכיון',
        'ArchiveRuns' => 'הפעלות ארכיון',
        'ExternalUsers' => 'משתמש חיצוני',
        'ReportMaker' => 'מחולל דוחות',
        'DataSets' => 'תבנית תאריך',
        'CustomQueries' => 'שאילתא מותאמת',
        'pmse_Inbox' => 'תהליך',
        'pmse_Project' => 'הגדרת תהליך',
        'pmse_Business_Rules' => 'תהליך כלל עסקי',
        'pmse_Emails_Templates' => 'תבנית מייל תהליך',
        'BusinessCenters' => 'מרכז עסקים',
        'Shifts' => 'משמרת',
        'ShiftExceptions' => 'החרגות למשמרות',
        'Purchases' => 'רכישה',
        'PurchasedLineItems' => 'פריט שורה - רכישות',
        'PushNotifications' => 'הודעה בדחיפה',
        'Escalations' => 'הסלמה',
        'DocumentTemplates' => 'תבנית מסמך',
        'DocumentMerges' => 'מיזוג מסמך',
        'CloudDrivePaths' => 'נתיב לכונן הענן',
        'WorkFlow' => 'זרימת עבודה',
        'EAPM' => 'חשבון חיצוני',
        'Worksheet' => 'גיליון עבודה',
        'Users' => 'משתמש',
        'SugarFavorites' => 'מועדפי שוגר',
        'Employees' => 'עובד',
        'Administration' => 'ניהול מערכת',
        'ACLRoles' => 'תפקיד',
        'InboundEmail' => 'Group Mail Account',
        'Releases' => 'שיחרור',
        'Queues' => 'תור',
        'EmailMarketing' => 'דואר שיווקי',
        'EmailTemplates' => 'תבנית דואר אלקטרוני',
        'SNIP' => 'ארכיון דואר אלקטרוני',
        'SavedSearch' => 'חיפושים שמורים',
        'UpgradeWizard' => 'אשף שדרוג',
        'Trackers' => 'מעקב',
        'TrackerPerfs' => 'ביצועים של גשש',
        'TrackerSessions' => 'עוקב Session',
        'TrackerQueries' => 'שאילתת עוקב',
        'FAQ' => 'שאלות נפוצות',
        'Newsletters' => 'עלון חדשות',
        'OAuthKeys' => 'OAuth מפתח לקוח',
        'OAuthTokens' => 'OAuth אסימון',
        'Filters' => 'פילטר',
        'Comments' => 'תגובה',
        'CommentLog' => 'יומן הערות',
        'Currencies' => 'מטבע:',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'סוג מוצר',
        'Shippers' => 'ספק משלוח',
        'Subscriptions' => 'מנוי',
        'UserSignatures' => 'חתימת דוא"ל',
        'Feedbacks' => 'משוב',
        'Tags' => 'תגית',
        'Categories' => 'קטגוריה',
        'OutboundEmail' => 'הגדרת דוא"ל',
        'EmailParticipants' => 'המשתתף בדוא"ל',
        'DataPrivacy' => 'פרטיות נתונים',
        'ReportSchedules' => 'דווח על לוח זמנים',
        'Holidays' => 'חופשה',
        'ChangeTimers' => 'שינוי טיימר',
        'Metrics' => 'מדד',
        'Messages' => 'הודעה',
        'Audit' => 'ביקורת',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => 'קוד גיאוגרפי',
        'DRI_Workflows' => 'מדריך חכם',
        'DRI_Workflow_Task_Templates' => 'תבנית פעילות של מדריכים חכמים',
        'DRI_SubWorkflows' => 'שלב מדריך חכם',
        'DRI_Workflow_Templates' => 'תבנית מדריך חכם',
        'CJ_WebHooks' => 'Web Hook של Sugar Automate',
        'CJ_Forms' => 'פעולת Smart Guide ב-Sugar',
        'DRI_SubWorkflow_Templates' => 'תבנית שלב של מדריכים חכמים',
        'PubSub_ModuleEvent_PushSubs' => 'מנוי דחיפה של אירוע מודול Pub/Sub',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'כן',
        '2' => 'לא',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'לא',
        1 => 'כן',
    ],

    'notifications_status_dom' => [
        0 => 'לא נקרא',
        1 => 'נקרא',
    ],

    'optout_dom' => [
        '' => '-כלום-',
        'false' => 'לא',
        'true' => 'כן',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'אנליסט',
        'Competitor' => 'מתחרה',
        'Customer' => 'לקוח',
        'Integrator' => 'אינטגרטור',
        'Investor' => 'משקיע',
        'Partner' => 'שותף',
        'Press' => 'עיתונות',
        'Prospect' => 'תחזית',
        'Reseller' => 'ריסיילר',
        'Other' => 'אחר',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'לבוש',
        'Banking' => 'בנקאות',
        'Biotechnology' => 'ביוטק',
        'Chemicals' => 'כימיקלים',
        'Communications' => 'תקשורת',
        'Construction' => 'בנייה',
        'Consulting' => 'ייעוץ',
        'Education' => 'חינוך',
        'Electronics' => 'אלקטרוניקה',
        'Energy' => 'אנרגיה',
        'Engineering' => 'הנדסה',
        'Entertainment' => 'בידור',
        'Environmental' => 'סביבה',
        'Finance' => 'כספים',
        'Government' => 'ממשלה',
        'Healthcare' => 'קופות חולים',
        'Hospitality' => 'בתי חולים',
        'Insurance' => 'ביטוח',
        'Machinery' => 'מכונאות',
        'Manufacturing' => 'ייצור',
        'Media' => 'מדיה',
        'Not For Profit' => 'עמותה',
        'Recreation' => 'בילויים',
        'Retail' => 'קמעונאי',
        'Shipping' => 'שילוח',
        'Technology' => 'טכנולוגיה',
        'Telecommunications' => 'טלקומיוניקציה',
        'Transportation' => 'תחבורה',
        'Utilities' => 'שירותים ציבוריים',
        'Other' => 'אחר',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF ו-CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'תרשים',
        'Data Table' => 'טבלת נתונים',
        'Chart and Data Table' => 'תרשים וטבלת נתונים',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'בביצוע',
        'Completed' => 'הושלם',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'נכנסת',
        'Outbound' => 'יוצאת',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'צ&#39;אט',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'שכבה 1',
        'T2' => 'שכבה 2',
        'T3' => 'שכבה 3',
        'T4' => 'שכבה 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'כן',
        'No' => 'לא',
        'Completed' => 'הושלם',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'עתיד',
        'Active' => 'פעיל',
        'Past' => 'עבר',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'נוצר בעצמו',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'טלמרקטינג',
        'Existing Customer' => 'לקוח קיים',
        'Self Generated' => 'נוצר בעצמו',
        'Employee' => 'עובד',
        'Partner' => 'שותף',
        'Public Relations' => 'יחסי ציבור',
        'Direct Mail' => 'דיוור ישיר',
        'Conference' => 'ועידה',
        'Trade Show' => 'תערוכה',
        'Web Site' => 'אתר אינטרנט',
        'Word of mouth' => 'שמועה',
        'Email' => 'Any Email',
        'Campaign' => 'קמפיין',
        'Support Portal User Registration' => 'רישום משתמש בפורטל התמיכה',
        'Other' => 'אחר',
    ],
    'metric_status_dom' => [
        'Inactive' => 'לא פעיל',
        'Active' => 'פעיל',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'עסקים קיימים',
        'New Business' => 'עסקים חדשים',
    ],
    'taxrate_status_dom' => [
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
    ],
    'roi_type_dom' => [
        'Revenue' => 'הכנסה',
        'Investment' => 'השקעה',
        'Expected_Revenue' => 'רווח צפוי',
        'Budget' => 'תקציב',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'מקבל החלטות ראשי',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'מקבל החלטות ראשי',
        'Business Decision Maker' => 'מקבל החלטות עסקיות',
        'Business Evaluator' => 'מעריך עיסקי',
        'Technical Decision Maker' => 'מקבל החלטות טכניות',
        'Technical Evaluator' => 'מעריך טכנולוגי',
        'Executive Sponsor' => 'נותן חזות להנהלה',
        'Influencer' => 'משפיע',
        'Other' => 'אחר',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
    ],

    'shipper_status_dom' => [
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'איש קשר ראשי',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'איש קשר ראשי',
        'Alternate Contact' => 'איש קשר משני',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'לצד ערך השדה',
        'field_on_top' => 'מעל ערך השדה',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'שוטף פלוס 30',
        'Net 30' => 'שוטף פלוס 60',
    ],
    'sales_stage_default_key' => 'הערכת קשר פוטנציאלי',
    'fts_type' => [
        'Elastic' => 'elasticsearch',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'הערכת קשר פוטנציאלי',
        'Qualification' => 'מגבלות',
        'Needs Analysis' => 'מצריך אנליזה',
        'Value Proposition' => 'ערך מוסף ללקוח',
        'Id. Decision Makers' => 'זהות מקבל ההחלטות',
        'Perception Analysis' => 'ניתוח תפיסת לקוח',
        'Proposal/Price Quote' => 'הצעת מחיר',
        'Negotiation/Review' => 'משא ומתן',
        'Closed Won' => 'נסגר בהצלחה',
        'Closed Lost' => 'נסגר ואבד',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'חדש',
        'In Progress' => 'בתהליך',
        'Closed Won' => 'נסגר בהצלחה',
        'Closed Lost' => 'נסגר ואבד',
        'Converted to Quote' => 'המר להצעת מחיר',
    ],
    'sales_status_dom' => [
        'New' => 'חדש',
        'In Progress' => 'בתהליך',
        'Closed Won' => 'נסגר בהצלחה',
        'Closed Lost' => 'נסגר ואבד',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'כלול',
        'exclude' => 'אל תכלול',
    ],
    'commit_stage_dom' => [
        'include' => 'כלול',
        'upside' => 'יתרון',
        'exclude' => 'החסר',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'כלול',
        'upside' => 'יתרון',
        'exclude' => 'החסר',
    ],

    'in_total_group_stages' => [
        'Draft' => 'טיוטה',
        'Negotiation' => 'משא ומתן',
        'Delivered' => 'סופק',
        'On Hold' => 'בהמתנה',
        'Confirmed' => 'אושר',
        'Closed Accepted' => 'התקבל ונסגר',
        'Closed Lost' => 'נסגר ואבד',
        'Closed Dead' => 'נסגר ומת',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'שיחת טלפון',
        'Meeting' => 'פגישה',
        'Task' => 'משימה',
        'Email' => 'Any Email',
        'Note' => 'פתק',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'מר.',
        'Ms.' => 'עלמה.',
        'Mrs.' => 'גברת.',
        'Dr.' => 'ד"ר',
        'Prof.' => 'פרופ.',
        'Mx.' => 'מקס.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'אין',
        60 => 'לפני דקה',
        300 => 'לפני 5 דקות',
        600 => 'לפני 10 דקות',
        900 => 'לפני 15 דקות',
        1800 => 'לפני 30 דקות',
        3600 => 'לפני שעה',
        7200 => 'לפני שעתיים',
        10800 => 'לפני 3 שעות',
        18000 => 'לפני 5 שעות',
        86400 => 'לפני  יום',
        ],

        'task_priority_default' => 'בינוני',
        'task_priority_dom' => [
        'High' => 'גבוה',
        'Medium' => 'בינוני',
        'Low' => 'נמוך',
        ],
        'task_status_default' => 'לא התחיל',
        'task_status_dom' => [
        'Not Started' => 'לא התחיל',
        'In Progress' => 'בתהליך',
        'Completed' => 'הושלם',
        'Pending Input' => 'קלט תלוי ועומד',
        'Deferred' => 'נדחה',
        'Not Applicable' => 'לא ישים',
        ],
        'meeting_status_default' => 'מתוכנן',
        'meeting_status_dom' => [
        'Planned' => 'נקבע ביומן',
        'Held' => 'התקיים',
        'Not Held' => 'בוטל',
        'Deferred' => 'נדחה',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'אחר',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'מתוכנן',
        'call_status_dom' => [
        'Planned' => 'נקבע ביומן',
        'In Progress' => 'בביצוע',
        'Held' => 'התקיים',
        'Not Held' => 'בוטל',
        'Deferred' => 'נדחה',
        ],
        'call_direction_default' => 'יוצא',
        'call_direction_dom' => [
        'Inbound' => 'נכנסת',
        'Outbound' => 'יוצא',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'חדש',
        'Assigned' => 'הוקצו',
        'In Process' => 'בתהליך',
        'Converted' => 'הומר',
        'Recycled' => 'מוחזר',
        'Dead' => 'מת',
        ],
        'gender_list' => [
        'male' => 'זכר',
        'female' => 'נקבה',
        'other' => 'אחר',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'חדש',
        'case_status_dom' => [
        'New' => 'חדש',
        'Assigned' => 'הוקצו',
        'Closed' => 'נסגר',
        'Pending Input' => 'קלט תלוי ועומד',
        'Rejected' => 'נדחה',
        'Duplicate' => 'שכפל',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'גבוה',
        'P2' => 'בינוני',
        'P3' => 'נמוך',
        ],
        'user_type_dom' => [
        'RegularUser' => 'משתמש רגיל',
        'Administrator' => 'מנהל מערכת',
        ],
        'user_type_bool_dom' => [
            false => 'משתמש רגיל',
            true => 'מנהל מערכת',
        ],
        'user_type_group_bool_dom' => [
            true => 'משתמש קבוצה',
        ],
        'user_type_portal_bool_dom' => [
            true => 'משתמש שער API',
        ],
        'license_type_dom' => [
        'CURRENT' => 'מוצר נוכחי',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
        ],
        'employee_status_dom' => [
        'Active' => 'פעיל',
        'Terminated' => 'סיים',
        'Leave of Absence' => 'חופשה ללא תשלום',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
        ],
        'project_task_priority_options' => [
        'High' => 'גבוה',
        'Medium' => 'בינוני',
        'Low' => 'נמוך',
        ],
        'project_task_priority_default' => 'בינוני',

        'project_task_status_options' => [
        'Not Started' => 'לא התחיל',
        'In Progress' => 'בתהליך',
        'Completed' => 'הושלם',
        'Pending Input' => 'קלט תלוי ועומד',
        'Deferred' => 'נדחה',
        ],
        'project_task_utilization_options' => [
        '0' => 'אין',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'טיוטה',
        'In Review' => 'בסקירה',
        'Published' => 'בוצע בהצלחה',
        ],
        'project_status_default' => 'טיוטה',

        'project_duration_units_dom' => [
        'Days' => 'ימים',
        'Hours' => 'ששעות',
        ],

        'project_priority_options' => [
        'High' => 'גבוה',
        'Medium' => 'בינוני',
        'Low' => 'נמוך',
        ],
        'project_priority_default' => 'בינוני',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'חשבונות',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'חשבון',
        'Opportunities' => 'הזדמנות',
        'Cases' => 'פניית שירות',
        'Leads' => 'ליד',
        'Contacts' => 'אנשי קשר', // cn (11/22/2005) added to support Emails
        'Products' => 'שורת פריט מצוטט',
        'Quotes' => 'הצעת מחיר',
        'Bugs' => 'באג',
        'Project' => 'פרויקט',

        'Prospects' => 'מטרה',
        'ProjectTask' => 'משימת הפרויקט',

        'Tasks' => 'משימה',
        'KBContents' => 'מרכז מידע',
        'Notes' => 'הערה',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'חשבון',
        'Contacts' => 'איש קשר',
        'Opportunities' => 'הזדמנות',
        'Tasks' => 'משימה',
        'ProductTemplates' => 'קטלוג מוצרים',
        'Quotes' => 'הצעת מחיר',
        'Products' => 'שורת פריט מצוטט',
        'Contracts' => 'חוזה',
        'Emails' => 'Any Email',

        'Bugs' => 'באג',
        'Project' => 'פרויקט',
        'ProjectTask' => 'משימת הפרויקט',
        'Prospects' => 'מטרה',
        'Cases' => 'פניית שירות',
        'Leads' => 'ליד',

        'Meetings' => 'פגישה',
        'Calls' => 'שיחת טלפון',
        'KBContents' => 'מרכז מידע',
        'PurchasedLineItems' => 'פריט שורה - רכישות',
        'Purchases' => 'רכישה',
        'Escalations' => 'הסלמה',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'חשבון',
        'Contacts' => 'איש קשר',
        'Employees' => 'עובד',
        'Leads' => 'ליד',
        'Prospects' => 'מטרה',
        'Users' => 'משתמש',
        ],

        'parent_type_display' => [
        'Accounts' => 'חשבון',
        'Contacts' => 'איש קשר',
        'Tasks' => 'משימה',
        'Opportunities' => 'הזדמנות',
        'Products' => 'שורת פריט מצוטט',
        'Quotes' => 'הצעת מחיר',

        'Bugs' => 'באגים',
        'Cases' => 'פניית שירות',
        'Leads' => 'ליד',

        'Project' => 'פרויקט',
        'ProjectTask' => 'משימת הפרויקט',

        'Prospects' => 'מטרה',
        'KBContents' => 'מרכז מידע',
        'Notes' => 'הערה',
        'PurchasedLineItems' => 'פריט שורה - רכישות',
        'Purchases' => 'רכישה',
        'Escalations' => 'הסלמה',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'פניית שירות',
        ],

        'product_status_default_key' => 'משלוח',
        'product_status_quote_key' => 'הצעת מחיר',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'ניתנה הצעת מחיר',
        'Orders' => 'הוזמן',
        'Ship' => 'נשלח',
        ],
        'active_status_dom' => [
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
        'Retired' => 'יצא משימוש',
        ],
        'appearance_options' => [
        'system_default' => 'השתמש בהגדרת המערכת',
        'light' => 'בהיר',
        'dark' => 'כהה',
        ],


        'pricing_formula_default_key' => 'קבוע',
        'pricing_formula_dom' => [
        'Fixed' => 'מחיר קבוע',
        'ProfitMargin' => 'שולי הרוח',
        'PercentageMarkup' => 'מעל מחיר עלות',
        'PercentageDiscount' => 'הנחה ממחיר מחירון',
        'IsList' => 'במחיר מחיאון',
        ],
        'product_template_status_dom' => [
        'Available' => 'במלאי',
        'Unavailable' => 'לא במלאי',
        ],
        'tax_class_dom' => [
        'Taxable' => 'חייב במס',
        'Non-Taxable' => 'לא חייב במס',
        ],
        'support_term_dom' => [
        '+6 months' => 'שישה חודשים',
        '+1 year' => 'שנה',
        '+2 years' => 'שנתיים',
        ],

        'quote_type_dom' => [
        'Quotes' => 'הצעת מחיר',
        'Orders' => 'סדר',
        ],
        'default_quote_stage_key' => 'טיוטה',
        'quote_stage_dom' => [
        'Draft' => 'טיוטה',
        'Negotiation' => 'משא ומתן',
        'Delivered' => 'סופק',
        'On Hold' => 'בהמתנה',
        'Confirmed' => 'אושר',
        'Closed Accepted' => 'התקבל ונסגר',
        'Closed Lost' => 'נסגר ואבד',
        'Closed Dead' => 'נסגר ומת',
        ],
        'default_order_stage_key' => 'תלויות ועומדות',
        'order_stage_dom' => [
        'Pending' => 'תלויות ועומדות',
        'Confirmed' => 'אושר',
        'On Hold' => 'בהמתנה',
        'Shipped' => 'נשלח',
        'Cancelled' => 'בוטל',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'מקבל החלטות ראשי',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'מקבל החלטות ראשי',
        'Business Decision Maker' => 'מקבל החלטות עסקיות',
        'Business Evaluator' => 'מעריך עיסקי',
        'Technical Decision Maker' => 'מקבל החלטות טכניות',
        'Technical Evaluator' => 'מעריך טכנולוגי',
        'Executive Sponsor' => 'נותן חזות להנהלה',
        'Influencer' => 'משפיע',
        'Other' => 'אחר',
        ],
        'layouts_dom' => [
        'Standard' => 'הצעת מחיר',
        'Invoice' => 'חשבונית',
        ],
        'issue_priority_default_key' => 'בינוני',
        'issue_priority_dom' => [
        'Urgent' => 'בהול',
        'High' => 'גבוה',
        'Medium' => 'בינוני',
        'Low' => 'נמוך',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'התקבל',
        'Duplicate' => 'שכפל',
        'Closed' => 'נסגר',
        'Out of Date' => 'לא רלוונטי',
        'Invalid' => 'לא תקין',
        ],

        'issue_status_default_key' => 'חדש',
        'issue_status_dom' => [
        'New' => 'חדש',
        'Assigned' => 'הוקצו',
        'Closed' => 'נסגר',
        'Pending' => 'תלויות ועומדות',
        'Rejected' => 'נדחה',
        ],

        'bug_priority_default_key' => 'בינוני',
        'bug_priority_dom' => [
        'Urgent' => 'בהול',
        'High' => 'גבוה',
        'Medium' => 'בינוני',
        'Low' => 'נמוך',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'התקבל',
        'Duplicate' => 'שכפל',
        'Fixed' => 'קבוע',
        'Out of Date' => 'לא רלוונטי',
        'Invalid' => 'לא תקין',
        'Later' => 'מאוחר יותר',
        ],
        'bug_status_default_key' => 'חדש',
        'bug_status_dom' => [
        'New' => 'חדש',
        'Assigned' => 'הוקצו',
        'Closed' => 'נסגר',
        'Pending' => 'תלויות ועומדות',
        'Rejected' => 'נדחה',
        ],
        'bug_type_default_key' => 'באג',
        'bug_type_dom' => [
        'Defect' => 'דפקט',
        'Feature' => 'תכונה',
        ],
        'case_type_dom' => [
        'Administration' => 'ניהול מערכת',
        'Product' => 'מוצר',
        'User' => 'משתמש',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'פנימי',
        'Forum' => 'פורום',
        'Web' => 'ווב',
        'InboundEmail' => 'Any Email',
        'Twitter' => 'טוויטר',
        'Portal' => 'פורטל',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'פנימי',
        'Forum' => 'פורום',
        'Web' => 'ווב',
        'InboundEmail' => 'דוא"ל',
        'Twitter' => 'Twitter',
        'Portal' => 'פורטל',
        'Phone' => 'טלפון',
        'Chat' => 'צ&#39;אט',
        'Chatbot' => 'צ&#39;אט בוט',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'שלח בקשה לקבלת המדיניות של פרטיות הנתונים',
        'Send Personal Information being processed' => 'שלח מידע אישי בתהליך עיבוד',
        'Rectify Information' => 'ערוך מידע',
        'Request to Erase Information' => 'שלח בקשה למחיקת מידע',
        'Export Information' => 'ייצא מידע',
        'Restrict Processing' => 'הגבל עיבוד',
        'Object to Processing' => 'התנגד לעיבוד',
        'Consent to Process' => 'הסכם לעיבוד',
        'Withdraw Consent' => 'הסר הסכמה',
        'Other' => 'אחר',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'תקשורת עסקית',
        'Marketing Communications by company' => 'תקשורת שיווקית על ידי החברה',
        'Marketing Communications by partners' => 'תקשורת שיווקית על ידי שותפים',
        ],
        'dataprivacy_status_default_key' => 'פתוח',
        'dataprivacy_status_dom' => [
        'Open' => 'פתוח',
        'Closed' => 'הושלם',
        'Rejected' => 'נדחה',
        ],
        'dataprivacy_priority_default_key' => 'נמוך',
        'dataprivacy_priority_dom' => [
        'Low' => 'נמוך',
        'Medium' => 'בינוני',
        'High' => 'גבוה',
        ],
        'business_day_status_dom' => [
        'Open' => 'פתוח',
        'Open 24 Hours' => 'פתוח 24 שעות',
        'Closed' => 'סגור',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'חשבונות',
        'Activities' => 'פעילויות',
        'Bug Tracker' => 'מעקב באגים',
        'Calendar' => 'לוח שנה',
        'Calls' => 'שיחות טלפון',
        'Campaigns' => 'קמפיינים',
        'Cases' => 'אירועים',
        'Contacts' => 'אנשי קשר',
        'Currencies' => 'מטבעות',
        'Dashboard' => 'לוח מחונים',
        'Documents' => 'מסמכים',
        'Emails' => 'דואר אלקטרוני',
        'Feeds' => 'פידים',
        'Forecasts' => 'תחזיות',
        'Help' => 'עזרה',
        'Home' => 'בית',
        'Leads' => 'לידים',
        'Meetings' => 'פגישות',
        'Notes' => 'הערות',
        'Opportunities' => 'הזדמנויות',
        'Outlook Plugin' => 'פלגין לאוטלוק',
        'Product Catalog' => 'קטלוג מוצרים',
        'Products' => 'פרטי שורה מצוטטים',
        'RevenueLineItems' => 'שורות פרטי הכנסה',
        'Projects' => 'פרויקטים',
        'Quotes' => 'הצעות מחיר',
        'Releases' => 'שיחרורים',
        'RSS' => 'RSS',
        'Studio' => 'סטודיו',
        'Upgrade' => 'שידרוג',
        'Users' => 'משתמשים',
        'OutboundEmail' => 'הגדרות דוא"ל',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'בתיכנון',
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
        'Complete' => 'הסתיים',
        'In Queue' => 'בתור',
        'Sending' => 'שולח',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'מוקדנים',
        'Mail' => 'דואר',
        'Email' => 'Any Email',
        'Print' => 'הדפס',
        'Web' => 'ווב',
        'Radio' => 'רדיו',
        'Television' => 'טלויזיה',
        'NewsLetter' => 'עלון חדשות',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'שבועי',
        'Monthly' => 'חודשי',
        'Quarterly' => 'רבעוני',
        'Annually' => 'שנתי',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'ינואר',
        '2' => 'פברואר',
        '3' => 'מרץ',
        '4' => 'אפריל',
        '5' => 'מאי',
        '6' => 'יוני',
        '7' => 'יולי',
        '8' => 'אוגוסט',
        '9' => 'ספטמבר',
        '10' => 'אוקטובר',
        '11' => 'נובמבר',
        '12' => 'דצמבר',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'ינו',
        '2' => 'פבר',
        '3' => 'מרס',
        '4' => 'אפר',
        '5' => 'מאי',
        '6' => 'יוני',
        '7' => 'יולי',
        '8' => 'אוג',
        '9' => 'ספט',
        '10' => 'אוק',
        '11' => 'נוב',
        '12' => 'דצמ',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'ראשון',
        '2' => 'שני',
        '3' => 'שלישי',
        '4' => 'רביעי',
        '5' => 'חמישי',
        '6' => 'שישי',
        '7' => 'שבת',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'א',
        '2' => 'ב',
        '3' => 'ג',
        '4' => 'ד',
        '5' => 'ה',
        '6' => 'ו',
        '7' => 'ש',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'א&#39;',
        '2' => 'ב&#39;',
        '3' => 'ג&#39;',
        '4' => 'ד&#39;',
        '5' => 'ה&#39;',
        '6' => 'ו&#39;',
        '7' => 'שבת',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'א',
        '1' => 'ב',
        '2' => 'ג',
        '3' => 'ד',
        '4' => 'ה',
        '5' => 'ו',
        '6' => 'ש',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'לפני הצהרים',
        'pm' => 'אחרי הצהרים',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => 'שורות ועמודות',
        'summary' => 'סיכום',
        'detailed_summary' => 'סיכום מפורט',
        'Matrix' => 'מטריצה',
        ],


        'dom_email_types' => [
        'out' => 'נשלח',
        'archived' => 'ארכיב',
        'draft' => 'טיוטה',
        'inbound' => 'נכנסת',
        'campaign' => 'קמפיין',
        ],
        'dom_email_status' => [
        'archived' => 'ארכיב',
        'closed' => 'נסגר',
        'draft' => 'טיוטה',
        'read' => 'נקרא',
        'replied' => 'נענו',
        'sent' => 'נשלח',
        'send_error' => 'שלח שגיאה',
        'unread' => 'לא נקרא',
        ],
        'dom_email_archived_status' => [
        'archived' => 'ארכיב',
        ],

        'dom_email_server_type' => ['' => '--כלום--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--כלום--',
        'createcase' => 'צור אירוע',
        'bounce' => 'הקפץ טיפול',
        ],
        'dom_email_distribution' => ['' => '--כלום--',
        'direct' => 'הוקצה ישירות',
        'roundRobin' => 'הופץ למשתמשים אחדים',
        'leastBusy' => 'לאחרון שעסוק',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'הופץ למשתמשים אחדים',
        'leastBusy' => 'לאחרון שעסוק',
        'none' => 'ללא',
        ],
        'dom_email_errors' => [1 => 'בחר משתמש אחד בלבד בהקצאת פריט באופן ישיר',
        2 => 'היתן לבחור פריטים מסומנים בלבד',
        ],
        'dom_email_bool' => ['bool_true' => 'כן',
        'bool_false' => 'לא',
        ],
        'dom_int_bool' => [1 => 'כן',
        0 => 'לא',
        ],
        'dom_switch_bool' => ['on' => 'כן',
        'off' => 'לא',
        '' => 'לא',],

        'dom_email_link_type' => ['sugar' => 'לקוח דואר של שוגר',
        'mailto' => 'לקוח דואר חיצוני'],


        'dom_email_editor_option' => ['' => 'פורמט דואר בברירת המחדל',
        'html' => 'HTML דוא"ל',
        'plain' => 'דוא"ל בטקטס פשוט'],

        'schedulers_times_dom' => ['not run' => 'זמן ריצה עבר, לא הופעל',
        'ready' => 'מוכן',
        'in progress' => 'בתהליך',
        'failed' => 'נכשל',
        'completed' => 'הושלם',
        'no curl' => 'לא הופעל: CURL איננו זמין',
        ],

        'dom_email_states' => [
        'Draft' => 'טיוטה',
        'Archived' => 'בארכיון',
        ],

        'dom_email_direction' => [
        'Unknown' => 'לא ידוע',
        'Outbound' => 'יוצא',
        'Inbound' => 'נכנס',
        'Internal' => 'פנימי',
        ],

        'scheduler_status_dom' => [
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
        ],

        'scheduler_period_dom' => [
        'min' => 'דקות',
        'hour' => 'ששעות',
        ],
        'forecast_type_dom' => [
        'Direct' => 'ישיר',
        'Rollup' => 'נגלל',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'שיווק',
        'Knowledge Base' => 'מאגר ידע',
        'Sales' => 'מכירות',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'שיווק מקבילי',
        'Product Brochures' => 'עלון מוצרים',
        'FAQ' => 'שאלות נפוצות',
        ],

        'document_status_dom' => [
        'Active' => 'פעיל',
        'Draft' => 'טיוטה',
        'FAQ' => 'שאלות נפוצות',
        'Expired' => 'פג תוקף',
        'Under Review' => 'בסקירה',
        'Pending' => 'תלויות ועומדות',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'מיזוג דואר',
        'eula' => 'הסכם משתמש קצה',
        'nda' => 'הסכם שמירת סודיות',
        'license' => 'הסכם רישוי',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'קבל',
        'decline' => 'דחה',
        'tentative' => 'טנטטיבי',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'התקבל',
        'decline' => 'נדחה',
        'tentative' => 'טנטטיבי',
        'none' => 'אין',
        ],
        'dataset_output_default_dom' => [
        'table' => 'טבלה',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'מודול יחיד',
        'Multi Module' => 'מרובה מודולים',
        ],
        'report_align_dom' => [
        'left' => 'שמאל',
        'center' => 'מרכז',
        'right' => 'ימין',
        ],

        'width_type_dom' => [
        '%' => 'אחוזים (%)',
        'px' => 'פיקסלים (px)',
        ],
        'report_color_dom' => [
        '' => 'ברירת מחדל',
        'black' => 'שחור',
        'green' => 'ירוק',
        'blue' => 'כחול',
        'red' => 'אדום',
        'white' => 'לבן',
        'DarkGreen' => 'ירוק כהה',
        'LightGray' => 'אפור בהיר',
        'DodgerBlue' => 'כחול כהה',
        'LightBlue' => 'כחול בהיר',
        ],
        'font_size_dom' => [
        '-5' => 'קטן יותר (-5)',
        '-4' => 'קטן יותר(-4)',
        '-3' => 'ה(-3)',
        '-2' => 'קטן יותר(-2)',
        '-1' => 'קטן יותר(-1)',
        'Default' => 'ברירת מחדל',
        '1' => 'גדול יותר (+1)',
        '2' => 'גדול יותר (+2)',
        '3' => 'גדול יותר (+3)',
        '4' => 'גדול יותר (+4)',
        '5' => 'גדול יותר (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'שאילתא ראשית',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'הצג',
//  'Group By' => 'Group By',
        'Calculation' => 'חישוב',
        ],
        'query_display_type_dom' => [
        'Default' => 'ברירת מחדל',
        'Custom' => 'מותאם',
        'Hidden' => 'נסתר',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'יום',
        'Week' => 'שבוע',
        'Month' => 'חודש',
        'Quarter' => 'רבעון',
        'Year' => 'שנה',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'כעת',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'סיכום',
        'AVG' => 'ממוצע',
        'COUNT' => 'מנה',
        'STDDEV' => 'סטיית תקן',
        'VARIANCE' => 'שונות',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'שדה סטנדרטי',
        'Time' => 'מרווחי זמן',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'שורות (Y-Axis)',
        'Columns' => 'עמודות (X-Axis)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'סך בכל (הכל)',
        'AVG' => 'ממוצע',
        'MAX' => 'מקסימום',
        'MIN' => 'מינימום',
        'COUNT' => 'מנה',
        'STDDEV' => 'סטיית תקן',
        'VARIANCE' => 'שונות',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'סטנדרטי',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'מחשבון מתמטי',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'שדה',
        'Value' => 'ערך',
        'Group' => 'קבוצה',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'עמודה',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'מושבת',
        'Enabled' => 'פעיל',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'רגיל',
        'Scalar' => 'סקלרי',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'טקסט',
        'Accounting' => 'חשבונאות',
        'Date' => 'תאריך',
        'Datetime' => 'Datetime',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'שנה',
        'Quarter' => 'רבעון',
        'Month' => 'חודש',
        'Week' => 'שבוע',
        'Day' => 'יום',
        ],
        'dataset_style_dom' => [
        'normal' => 'רגיל',
        'bold' => 'מודגש',
        'italic' => 'נטוי',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) חיבור',
        '-' => '(-) חיסור',
        '*' => '(X) כפל',
        '/' => '(/) חילוק',
        ],
        'wflow_type_dom' => [
        'Normal' => 'בעת שמירת רשומה',
        'Time' => 'בתום זמן שחלף',
        ],
        'mselect_type_dom' => [
        'Equals' => 'היה',
        'in' => 'אחד מ',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'אחד מ',
        'not_in' => 'שאינו אחד מ',
        ],
        'cselect_type_dom' => [
        'Equals' => 'שווה',
        'Does not Equal' => 'לא שווה',
        ],
        'dselect_type_dom' => [
        'Equals' => 'שווה',
        'Less Than' => 'פחות מ',
        'More Than' => 'יותר מ',
        'Does not Equal' => 'אינו שווה ל',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'כן',
        'bool_false' => 'לא',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'שווה',
        ],
        'tselect_type_dom' => [
        '0' => '0 שעות',
        '14440' => '4 שעות',
        '28800' => '8 שעות',
        '43200' => '12 שעות',
        '86400' => '1 יום',
        '172800' => '2 ימים',
        '259200' => '3 ימים',
        '345600' => '4 ימים',
        '432000' => '5 ימים',
        '604800' => 'שבוע',
        '1209600' => 'שבועיים',
        '1814400' => '3 שבועות',
        '2592000' => '30 ימים',
        '5184000' => '60 ימים',
        '7776000' => '90 ימים',
        '10368000' => '120 ימים',
        '12960000' => '150 ימים',
        '15552000' => '180 ימים',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'היה יותר מ',
        'Less Than' => 'פחות מ',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'Any Email',
        'Invite' => 'הזמן',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'הודעה רגילה',
        'Custom Template' => 'התאם אישית את התבנית',
        'System Default' => 'ברירת מחדל מערכת',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'משתמשים נוכחים',
        'rel_user' => 'קשור למשתמשים',
        'rel_user_custom' => 'קשור למשתמשים מיוחדים',
        'specific_team' => 'צוות מסויים',
        'specific_role' => 'תפקיד מסויים',
        'specific_user' => 'משתמש מסויים',
        ],
        'wflow_array_type_dom' => [
        'future' => 'ערך חדש',
        'past' => 'ערך ישן',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'משתמש',
        'Manager' => "מנהל המשתמשים",
        ],
        'wflow_address_type_dom' => [
        'to' => 'אל:',
        'cc' => 'העתק:',
        'bcc' => 'העתק נסתר:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'אל:',
        'cc' => 'העתק:',
        'bcc' => 'העתק נסתר:',
        'invite_only' => '(מוזמנים בלבד)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'אל:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'עדכן רשומה',
        'update_rel' => 'עדכן רשומות קשורות',
        'new' => 'רשומה חדשה',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'תאריך מעורר',
        'Existing Value' => 'ערך קיים',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'אפשרויות בסיסיות',
        'Advanced' => 'אפשרויות מתקדמות',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'משתמש שהוקתה לרשומה מחוללת',
        'modified_user_id' => 'משתמש אחרון ששינה רשומה מחוללת',
        'created_by' => 'משתמש שיצר רשומה מחוללת',
        'current_user' => 'משתמשים פעילים',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'הצוות הנכחי של הרשומה מהחוללת',
        'team_set_id' => 'סט צוות נוכחי של רשומה מופעלת',
        'current_team' => 'הצוות של משתמשים פעילים',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'הזז תפריט נגלל אחורה על ידי',
        'advance' => 'הזז תפריט נגלל קדימה על ידי',
        ],
        'wflow_record_type_dom' => [
        'All' => 'רשומות חדשות ומעודכנות',
        'New' => 'רשומות חדשות בלבד',
        'Update' => 'רשומות שעודכנו בלבד',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'Aכל הקשורים',
        //'first' => 'The first related',
        'filter' => 'סנן קשורים',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'כל הקשורים',
        'any' => 'קשורים כלשהם',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'אזעקות ואחר כך פעולות',
        'actions_alerts' => 'פעולות ואחר כך הזעקות'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'אין',
        'Daily' => 'יומי',
        'Weekly' => 'שבועי',
        'Monthly' => 'חודשי',
        'Yearly' => 'שנתי',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'Days',
        'Weekly' => 'שבועי',
        'Monthly' => 'חודשי',
        'Yearly' => 'שנתי',
        ],

        'repeat_end_types' => [
        'Until' => 'עד',
        'Occurrences' => 'מופעים',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'ללא',
        'Each' => 'כל אחד',
        'On' => 'ב',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'ראשון',
        'second' => 'שני',
        'third' => 'שלישי',
        'fourth' => 'רביעי',
        'fifth' => 'חמישי',
        'last' => 'אחרון',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'ראשון',
        'Mon' => 'שני',
        'Tue' => 'שלישי',
        'Wed' => 'רביעי',
        'Thu' => 'חמישי',
        'Fri' => 'שישי',
        'Sat' => 'שבת',
        'Day' => 'יום',
        'WD' => 'יום חול',
        'WE' => 'יום בסוף השבוע',
        ],

        'duration_dom' => [
        '' => 'אין',
        '900' => '15 דקות',
        '1800' => '30 דקות',
        '2700' => '45 דקות',
        '3600' => 'שעה',
        '5400' => '1.5 שעות',
        '7200' => '2 שעות',
        '10800' => '3 שעות',
        '21600' => '6 שעות',
        '86400' => '1 יום',
        '172800' => '2 ימים',
        '259200' => '3 ימים',
        '604800' => 'שבוע',
        ],
        'repeat_month_dom' => [
        '1' => 'ינואר',
        '2' => 'פברואר',
        '3' => 'מרץ',
        '4' => 'אפריל',
        '5' => 'מאי',
        '6' => 'יוני',
        '7' => 'יולי',
        '8' => 'אוגוסט',
        '9' => 'ספטמבר',
        '10' => 'אוקטובר',
        '11' => 'נובמבר',
        '12' => 'דצמבר',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'ברירת מחדל',
        'seed' => 'זרע',
        'exempt_domain' => 'הדחק רשימה - לפי דומיין',
        'exempt_address' => 'הדחק רשימה - לפי דוא"ל',
        'exempt' => 'הדחק רשימה - לפי זהות',
        'test' => 'Test [Alt+T]',
        ],
        'currency_status_dom' => [
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'פעיל',
        'inactive' => 'לא פעיל',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'הודעה נשלחה/ניסיון לשלוח',
        'send error' => 'הודעות מוקפצות,אחר',
        'invalid email' => 'הודעות מוקפצות,דואר לא ולידי',
        'link' => 'הקש למעבר בקישור',
        'viewed' => 'הודעות שניצפו',
        'removed' => 'ביטל הצטרפות',
        'lead' => 'לידים שנוצרו',
        'contact' => 'אנשי קשר שנוצרו',
        'blocked' => 'נדחק לפי דוא"ל או שם מתחם',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'אנשי קשר',
        'Users' => 'משתמשים',
        'Prospects' => 'מטרות',
        'Leads' => 'לידים',
        'Accounts' => 'חשבונות',
        ],
        'merge_operators_dom' => [
        'like' => 'מכיל',
        'exact' => 'בדיוק',
        'start' => 'מתחיל ב',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'כן',
        'false' => 'לא',
        'required' => 'חובה',
        ],

        'fts_field_config' => [
        '0' => 'מושבת',
        '2' => 'ניתן לחיפוש',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'מושבת',
        1 => 'פעיל',
        2 => 'מסנן נבחר כברירת מחדל',
        3 => 'מסונן בלבד',
        4 => 'פילטר בלבד',
        ],

        'navigation_paradigms' => [
        'm' => 'מודולים',
        'gm' => 'מודולים מקובצים',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'לא התחיל',
        'inprogress' => 'בתהליך',
        'signed' => 'נחתם',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'חודשי',
        'quarterly' => 'רבעוני',
        'halfyearly' => 'חצי שנתי',
        'yearly' => 'שנתי',
        ],

        'contract_expiration_notice_dom' => [
        '1' => 'יום',
        '3' => '3 ימים',
        '5' => '5 ימים',
        '7' => 'שבוע',
        '14' => 'שבועיים',
        '21' => '3 שבועות',
        '31' => 'חודש',
        ],
        'projects_priority_options' => [
        'high' => 'גבוה',
        'medium' => 'בינוני',
        'low' => 'נמוך',
        ],

        'projects_status_options' => [
        'notstarted' => 'לא התחיל',
        'inprogress' => 'בתהליך',
        'completed' => 'הושלם',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'הרחב מקרא',
        'collapselegend' => 'גלול מקרא',
        'clickfordrilldown' => 'הקלק כדי לעבור לספריות משנה',
        'drilldownoptions' => 'אפשרויות מעבר לספריות משנה',
        'detailview' => 'עוד פרטים...',
        'piechart' => 'טבלת עוגה',
        'groupchart' => 'קבץ טבלאות',
        'stackedchart' => 'ערם טבלאות',
        'barchart' => 'טבלת עמודות',
        'horizontalbarchart' => 'טבלת עמודות אופקיים',
        'linechart' => 'טבלת קווים',
        'noData' => 'הנתונים לא זמינים',
        'print' => 'הדפס',
        'pieWedgeName' => 'מחלקות',
        ],
        'chart_types' => [
        'hBarF' => 'עמודות אופקיות (מוערם)',
        'hGBarF' => 'עמודות אופקיות (מקובץ)',
        'vBarF' => 'עמודות אנכיות (מוערם)',
        'vGBarF' => 'עמודות אנכיות (מקובץ)',
        'pieF' => 'עוגה',
        'funnelF' => 'משפך',
        'lineF' => 'קו',
        'donutF' => 'טבעת',
        'treemapF' => 'מפת עץ',
        ],
        'd3_value_placement' => [
        '0' => 'אין',
        '1' => 'ברירת מחדל',
        'start' => 'התחלה',
        'middle' => 'אמצע',
        'end' => 'סיום',
        'top' => 'למעלה',
        'total' => 'סך-הכל',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'משפך',
        'hbar' => 'פס אופקי',
        ],
        'release_status_dom' => [
        'Active' => 'פעיל',
        'Inactive' => 'לא פעיל',
        ],
        'email_settings_for_ssl' => [
        '0' => 'כלום',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'אפליקציות Google עם רמת אבטחה נמוכה יותר',
        'exchange' => 'Exchange',
        'other' => 'אחר',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'אחר',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'Single Quote (&#39;)',
        '"' => 'ציטוט כפול (")',
        '' => 'אין',
        'other' => 'אחר:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'אחר:',
        ],
        'link_target_dom' => [
        '_blank' => 'חלון חדש',
        '_self' => 'באותו חלון',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'לא לרענן באופן אוטומטי',
        '30' => 'כל 30 שניות',
        '60' => 'כל דקה',
        '180' => 'כל 3 דקות',
        '300' => 'כל 3 דקות',
        '600' => 'כל 10 דקות',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'אין',
        '15' => 'כל 15 דקות',
        '30' => 'כל 30 דקות',
        '45' => 'כל 45 דקות',
        '60' => 'כל שעה',
        '120' => 'כל שעתיים',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'מעולם',
        '30' => 'כל 30 שניות',
        '60' => 'כל דקה',
        '180' => 'כל 3 דקות',
        '300' => 'כל 3 דקות',
        '600' => 'כל 10 דקות',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'אין',
        '1' => 'כל דקה',
        '5' => 'כל 5 דקות',
        '10' => 'כל 10 דקות',
        '15' => 'כל 15 דקות',
        '30' => 'כל 30 דקות',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'שווה',
        'not_equal' => 'לא על',
        'greater_than' => 'אחרי',
        'less_than' => 'לפני',
        'last_7_days' => 'בשבעת הימים האחרונים',
        'next_7_days' => 'בשבעת הימים הבאים',
        'last_30_days' => 'בשלושים הימים האחרונים',
        'next_30_days' => 'בשלושים הימים הבאים',
        'last_month' => 'בחודש שעבר',
        'this_month' => 'החודש',
        'next_month' => 'בחוד הבא',
        'last_year' => 'בשנה שעברה',
        'this_year' => 'השנה',
        'next_year' => 'בשנה הבאה',
        'between' => 'באממצע',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'בשנה שעברה',
        'last_month' => 'בחודש שעבר',
        'last_30_days' => 'בשלושים הימים האחרונים',
        'last_7_days' => 'בשבעת הימים האחרונים',
        'this_month' => 'החודש',
        'this_year' => 'השנה',
        'next_7_days' => 'בשבעת הימים הבאים',
        'next_30_days' => 'בשלושים הימים הבאים',
        'next_month' => 'בחוד הבא',
        'next_year' => 'בשנה הבאה',
        ],
        'numeric_range_search_dom' => [
        '=' => 'שווה',
        'not_equal' => 'לא שווה',
        'greater_than' => 'גדול מ',
        'greater_than_equals' => 'גדול מ או שווה ל',
        'less_than' => 'פחות מ',
        'less_than_equals' => 'פחות מ או שווה ל',
        'between' => 'באממצע',
        ],

        'filter_checkbox_dom' => [
        0 => 'לא נכון',
        1 => 'נכון',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'זכייה',
        'lost' => 'הפסד',
        'active' => 'פעיל',
        ],

        'sweetspot_theme_options' => [
        'default' => 'ברירת מחדל',
        'light' => 'בהיר',
        'dark' => 'כהה',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'הזז',
        'donothing' => 'אל תעשה דבר',
        ],
        'processes_auto_save_interval' => [
        0 => 'אף פעם',
        30000 => 'כל 30 שניות',
        60000 => 'כל דקה 1',
        120000 => 'כל 2 דקות',
        180000 => 'כל 3 דקות',
        240000 => 'כל 4 דקות',
        300000 => 'כל 5 דקות',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'כן',
        'No' => 'לא',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'בתחזית',
        'sales_stage' => 'שלב במכירות',
        'probability' => 'הסתברות',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'סכום ההזדמנות',
        'best' => 'הכי טוב',
        'worst' => 'הגרוע ביותר',
        ],
        'webLogicHookList' => [
        'after_save' => 'לאחר שמירה',
        'after_delete' => 'לאחר מחיקה',
        'after_relationship_add' => 'להאחר הוספת יחסים',
        'after_relationship_delete' => 'להאחר מחיקת יחסים',
        'after_login' => 'לאחר לוגין',
        'after_logout' => 'לאחר יציאה',
        'after_login_failed' => 'לאחר כשלון בלוגין',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'פעיל',
        'INACTIVE' => 'מושבת',
        ],
        'dashboard_view_name_list' => [
        'record' => 'רשומה',
        'records' => 'רשימה',
        'activities' => 'תזרים פעילויות',
        'multi-line' => 'רשימה מרובת שורות',
        'omnichannel' => 'ריבוי ערוצים',
        'home' => 'Home',
        'focus' => 'מגירת פוקוס',
        ],
        'metric_context_list' => [
        'service_console' => 'מסוף שירות',
        'renewals_console' => 'מסוף חידושים',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'פעם בשעה',
        '21600' => 'פעם ב- 6 שעות',
        '43200' => 'פעם ב- 12 שעות',
        '86400' => 'פעם ביום',
        '604800' => 'פעם בשבוע',
        '1209600' => 'פעם בשבועיים',
        '2419200' => 'פעם ב- 4 שבועות',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'שנים',
        'month' => 'חודשים',
        'day' => 'ימים',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'לא בעבודה',
        'event' => 'אירוע',
        'other' => 'אחר',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'תאריך ({{module}} אחרון)',
        'start_date:asc' => 'תאריך ({{module}} ראשון)',
        'total_revenue:desc' => 'מחיר (הסה"כ הגבוה ביותר)',
        'total_revenue:asc' => 'מחיר (הסה"כ הנמוך ביותר)',
        ],
        'calendar_type_list' => [
        'main' => 'מרכז לוחות השנה',
        ],
        'calendar_views_options' => [
        'day' => 'יום',
        'week' => 'שבוע',
        'workWeek' => 'שבוע עבודה',
        'expandedMonth' => 'חודש',
        'agenda' => 'סדר יום',
        'timeline' => 'ציר זמן',
        'monthSchedule' => 'מתזמן',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'נוצרה',
        'completed' => 'הושלמה',
        'declined' => 'נדחתה',
        'delivered' => 'נמסרה',
        'sent' => 'נשלחה',
        'signed' => 'חתומה',
        'voided' => 'משוללת תוקף',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'הצג רשימת נמענים פוטנציאליים',
        'dont_show' => 'אל תציג נמענים פוטנציאליים',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'חותם',
        'carbon_copy' => 'מציג (עותק)',
        'certified_delivery' => 'מציג (משלוח מאומת)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'ברירת מחדל',
        'color' => 'צבע',
        'image' => 'תמונה',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'קיצור',
        'icon' => 'סמל',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'חץ כלפי מטה',
        'sicon-chevron-left' => 'סוגר זוויתי שמאלה',
        'sicon-check' => 'סימן ביקורת',
        'sicon-clock' => 'שעון',
        'sicon-dashboard-default' => 'ברירת המחדל של לוח המחוונים',
        'sicon-dashboard' => 'לוח מחוונים',
        'sicon-edit' => 'עריכה',
        'sicon-caret-down' => 'סימן כניסה למטה',
        'sicon-folder' => 'תיקייה',
        'sicon-info' => 'מידע',
        'sicon-kebab' => 'שיפוד',
        'sicon-link' => 'קישור',
        'sicon-list' => 'רשימה',
        'sicon-logout' => 'יציאה',
        'sicon-minus' => 'מינוס',
        'sicon-folder-open' => 'תיקייה פתוחה',
        'sicon-plus-sm' => 'פלוס Sm',
        'sicon-refresh' => 'רענון',
        'sicon-plus' => 'פלוס',
        'sicon-settings' => 'הגדרות',
        'sicon-arrow-right-double' => 'חץ ימינה כפול',
        'sicon-reports' => 'דוחות',
        'sicon-user' => 'משתמש',
        'sicon-upload' => 'העלאה',
        'sicon-user-group' => 'קבוצת משתמשים',
        'sicon-arrow-left-double' => 'חץ שמאלה כפול',
        'sicon-chevron-up' => 'סוגר זוויתי למעלה',
        'sicon-caret-up' => 'סימן כניסה למטה',
        'sicon-star-fill' => 'מילוי כוכב',
        'sicon-download' => 'הורדה',
        'sicon-close' => 'סגירה',
        'sicon-tile-view' => 'תצוגת אריחים',
        'sicon-list-view' => 'תצוגת רשימה',
        'sicon-thumbs-down' => 'אגודל למטה',
        'sicon-warning-circle' => 'מעגל אזהרה',
        'sicon-phone' => 'טלפון',
        'sicon-email' => 'דוא"ל',
        'sicon-document' => 'מסמך',
        'sicon-note' => 'הערה',
        'sicon-preview' => 'תצוגה מקדימה',
        'sicon-copy' => 'העתקה',
        'sicon-launch' => 'הפעלה',
        'sicon-lock' => 'נעילה',
        'sicon-arrow-top-right' => 'חץ למעלה ימינה',
        'sicon-full-screen' => 'מסך מלא',
        'sicon-full-screen-exit' => 'יציאה ממסך מלא',
        'sicon-expand-left' => 'הרחב שמאלה',
        'sicon-expand-right' => 'הרחב ימינה',
        'sicon-focus-drawer' => 'Focus Drawer',
        'sicon-ban' => 'איסור',
        'sicon-thumbs-up' => 'אגודל למעלה',
        'sicon-search' => 'חיפוש',
        'sicon-calendar' => 'לוח שנה',
        'sicon-calendar-lg' => 'לוח שנה Lg',
        'sicon-mobile-lg' => 'נייד Lg',
        'sicon-star-fill-lg' => 'מילוי כוכב Lg',
        'sicon-star-outline-lg' => 'תוואי כוכב Lg',
        'sicon-reset-lg' => 'איפוס Lg',
        'sicon-exchange-lg' => 'Exchange Lg',
        'sicon-help-lg' => 'עזרה Lg',
        'sicon-close-lg' => 'סגור Lg',
        'sicon-plus-lg' => 'פלוס Lg',
        'sicon-shortcuts-lg' => 'קיצורי דרך Lg',
        'sicon-search-lg' => 'חיפוש Lg',
        'sicon-email-lg' => 'דוא"ל Lg',
        'sicon-note-lg' => 'הערה Lg',
        'sicon-document-lg' => 'מסמך Lg',
        'sicon-add-dashlet-lg' => 'הוסף חלונית Lg',
        'sicon-collapse-lg' => 'כווץ Lg',
        'sicon-hamburger-lg' => 'המבורגר Lg',
        'sicon-pin-fill-lg' => 'מילוי סיכה Lg',
        'sicon-expand-lg' => 'הרחב Lg',
        'sicon-copy-lg' => 'העתק Lg',
        'sicon-dashboard-lg' => 'לוח מחוונים Lg',
        'sicon-star-outline' => 'תוואי כוכב',
        'sicon-reset' => 'איפוס',
        'sicon-unlink' => 'הסר קישור',
        'sicon-phone-lg' => 'טלפון Lg',
        'sicon-attach' => 'צרף',
        'sicon-case-lg' => 'קריאה Lg',
        'sicon-arrow-right-lg' => 'חץ ימינה Lg',
        'sicon-check-circle-lg' => 'מעגל עם סימן ביקורת Lg',
        'sicon-text-formatting' => 'עיצוב טקסט',
        'sicon-check-circle' => 'מעגל עם סימן ביקורת',
        'sicon-upload-lg' => 'העלאה Lg',
        'sicon-flag-lg' => 'דגל Lg',
        'sicon-studio-lg' => 'Studio Lg',
        'sicon-contact-lg' => 'איש קשר Lg',
        'sicon-edit-lg' => 'עריכה Lg',
        'sicon-arrow-left' => 'חץ שמאלה',
        'sicon-reply-all' => 'השב לכולם',
        'sicon-message-lg' => 'הודעה Lg',
        'sicon-info-lg' => 'מידע Lg',
        'sicon-error-lg' => 'שגיאה Lg',
        'sicon-check-circle-line-lg' => 'קו מעגל עם סימן ביקורת Lg',
        'sicon-warning-line-lg' => 'פס אזהרה Lg',
        'sicon-arrow-up' => 'חץ למעלה',
        'sicon-arrow-right' => 'חץ ימינה',
        'sicon-nodes' => 'צמתים',
        'sicon-hide' => 'הסתר',
        'sicon-help' => 'עזרה',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'הודעה',
        'sicon-sugar-predict-lg' => 'Sugar Predict Lg',
        'sicon-sugar-predict' => 'Sugar Predict',
        'sicon-opportunity-lg' => 'הזדמנות Lg',
        'sicon-lead-lg' => 'ליד Lg',
        'sicon-account-lg' => 'חשבון Lg',
        'sicon-user-sm' => 'משתמש Sm',
        'sicon-quote-lg' => 'הצעת מחיר Lg',
        'sicon-equal' => 'שווה',
        'sicon-slicers-xl' => 'כלי פריסה Xl',
        'sicon-escalation-lg' => 'הסלמה Lg',
        'sicon-add-circle-lg' => 'הוסף מעגל Lg',
        'sicon-add-line-lg' => 'הוסף שורה Lg',
        'sicon-add-target-lg' => 'הוסף יעד Lg',
        'sicon-help-circle-lg' => 'מעגל עזרה Lg',
        'sicon-divide-line-lg' => 'קו חלוקה Lg',
        'sicon-string' => 'מחרוזת',
        'sicon-filter' => 'מסנן',
        'sicon-number' => 'מספר',
        'sicon-format-lg' => 'פורמט Lg',
        'sicon-insights-lg' => 'Insights Lg',
        'sicon-invalid-circle-lg' => 'מעגל לא חוקי Lg',
        'sicon-layout-xl' => 'תצורה Xl',
        'sicon-layout-lg' => 'תצורה Lg',
        'sicon-multiply-line-lg' => 'קו הכפלה Lg',
        'sicon-redo-lg' => 'בצע שוב Lg',
        'sicon-refresh-lg' => 'רענן Lg',
        'sicon-undo-lg' => 'בטל פעולה Lg',
        'sicon-activity-feed-xl' => 'הזנת פעילות Xl',
        'sicon-chevron-left-xl' => 'סוגר זוויתי שמאלה Xl',
        'sicon-close-xl' => 'סגור Xl',
        'sicon-kebab-lg' => 'שיפוד Lg',
        'sicon-insights-xl' => 'Insights Xl',
        'sicon-hide-lg' => 'הסתר Lg',
        'sicon-kebab-xl' => 'שיפוד Xl',
        'sicon-comment-xl' => 'הערה Xl',
        'sicon-share-lg' => 'שיתוף Lg',
        'sicon-trash' => 'אשפה',
        'sicon-launch-lg' => 'הפעלה Lg',
        'sicon-thumbs-up-lg' => 'אגודל למעלה Lg',
        'sicon-thumbs-down-lg' => 'אגודל למטה Lg',
        'sicon-warning-lg' => 'אזהרה Lg',
        'sicon-wizard-circle-xl' => 'Wizard Circle Xl',
        'sicon-bell-cross-lg' => 'Bell Cross Lg',
        'sicon-bell-lg' => 'פעמון Lg',
        'sicon-daily-lg' => 'יומי Lg',
        'sicon-cloud-download-lg' => 'הורדת ענן Lg',
        'sicon-unlock' => 'ביטול נעילה',
        'sicon-news-lg' => 'חדשות Lg',
        'sicon-weekly-lg' => 'שבועי Lg',
        'sicon-knowledgebase-xl' => 'מאגר הידע Xl',
        'sicon-remove' => 'הסר',
        'sicon-chevron-down' => 'סוגר זוויתי למטה',
        'sicon-slicers-lg' => 'כלי פריסה Lg',
        'sicon-save-lg' => 'שמור Lg',
        'sicon-info-circle-lg' => 'מעגל מידע Lg',
        'sicon-chevron-right' => 'סוגר זוויתי ימינה',
        'sicon-warning-circle-lg' => 'מעגל אזהרה Lg',
        'sicon-right-paren-line-lg' => 'קו הורה ימין Lg',
        'sicon-comment-lg' => 'הערה Lg',
        'sicon-target-lg' => 'יעד Lg',
        'sicon-subtract-line-lg' => 'קו חיסור Lg',
        'sicon-settings-lg' => 'הגדרות Lg',
        'sicon-left-paren-line-lg' => 'קו הורה שמאל Lg',
        'sicon-preview-lg' => 'תצוגה מקדימה Lg',
        'sicon-thumbs-down-line-lg' => 'קו אגודל למטה Lg',
        'sicon-thumbs-up-line-lg' => 'קו אגודל למעלה Lg',
        'sicon-send-lg' => 'שלח Lg',
        'sicon-contact-xl' => 'איש קשר Xl',
        'sicon-wizard-circle-line-xl' => 'קו Wizard Circle Xl',
        'sicon-trash-lg' => 'אשפה Lg',
        'sicon-pin-lg' => 'סיכה Lg',
        'sicon-clock-lg' => 'שעון Lg',
        'sicon-comment-line-xl' => 'שורת הערה Xl',
        'sicon-dropdown-editor' => 'עורך בתפריט נפתח',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'באג',
        'sicon-catalog' => 'קטלוג',
        'sicon-cloud' => 'ענן',
        'sicon-config-api' => 'קביעת תצורה של API',
        'sicon-config-nav' => 'קביעת תצורה של ניווט',
        'sicon-connectors' => 'מחברים',
        'sicon-contracts' => 'חוזים',
        'sicon-currencies' => 'מטבעות',
        'sicon-diagnostics' => 'אבחון',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'קמפיין דוא"ל',
        'sicon-email-inbound' => 'דוא"ל נכנס',
        'sicon-email-queue' => 'תור דוא"ל',
        'sicon-forecasts' => 'תחזיות',
        'sicon-display-modules' => 'מודולי תצוגה',
        'sicon-email-contacts' => 'אנשי קשר בדוא"ל',
        'sicon-import' => 'ייבוא',
        'sicon-log-viewer' => 'מציג יומני הרישום',
        'sicon-lab' => 'Lab',
        'sicon-map-pin' => 'סיכת מפה',
        'sicon-manufacturers' => 'יצרנים',
        'sicon-update' => 'עדכון',
        'sicon-content-security' => 'אבטחת תוכן',
        'sicon-module-builder' => 'בונה מודולים',
        'sicon-languages' => 'שפות',
        'sicon-module-loader' => 'טוען מודולים',
        'sicon-oauth-key' => 'מפתח OAuth',
        'sicon-password-mgmt' => 'ניהול סיסמאות',
        'sicon-opportunities' => 'הזדמנויות',
        'sicon-upgrade' => 'שדרוג',
        'sicon-portal' => 'פורטל',
        'sicon-product-types' => 'סוגי מוצרים',
        'sicon-quotes' => 'הצעת מחיר',
        'sicon-relate-fields' => 'קישור שדות',
        'sicon-repair' => 'תיקון',
        'sicon-role-mgmt' => 'ניהול תפקידים',
        'sicon-scheduler' => 'מתזמן',
        'sicon-shippers' => 'שולחים',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'Web Logic',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'שיעורי מס',
        'sicon-team-mgmt' => 'ניהול צוותים',
        'sicon-team-perm' => 'הרשאות צוות',
        'sicon-tracker' => 'מעקב',
        'sicon-workflow' => 'זרימת עבודה',
        'sicon-mask' => 'מסכה',
        'sicon-mask-disabled' => 'מסכה מושבתת',
        'sicon-email-archive' => 'ארכיון דוא"ל',
        'sicon-mobile' => 'נייד',
        'sicon-archive' => 'ארכיון',
        'sicon-automate-scroll' => 'תצוגת גלילה אנכית',
        'sicon-automate-stacked' => 'תצוגת גלילה אופקית',
        'sicon-pdf-manager' => 'מנהל PDF',
        'sicon-my-sites' => 'האתרים שלי',
        'sicon-cloud-insights' => 'Cloud Insights',
        'sicon-sugar-logo-24' => 'לוגו Sugar 24',
        'sicon-sugar-logo-16' => 'לוגו Sugar 16',
        'sicon-task-lg' => 'משימה Lg',
        'sicon-web-lg' => 'אינטרנט Lg',
        'sicon-events-lg' => 'אירועים Lg',
        'sicon-sugar-logo-12' => 'לוגו Sugar 12',
        'sicon-tag' => 'תגית',
        'sicon-tag-lg' => 'תגית Lg',
        'sicon-bell-lg-line' => 'קו Bell Lg',
        'sicon-matrix-xxl' => 'Matrix Xxl',
        'sicon-advanced-filter' => 'מסנן מתקדם',
        'sicon-rows-and-columns-xxl' => 'שורות ועמודות Xxl',
        'sicon-summation-details-xxl' => 'פרטי סיכום Xxl',
        'sicon-summation-xxl' => 'סיכום Xxl',
        'sicon-lock-lg' => 'נעילה Lg',
        'sicon-csv-file-xxl' => 'קובץ Csv Xxl',
        'sicon-logo-linkedin' => 'לוגו Linkedin',
        'sicon-briefcase' => 'מזוודה',
        'sicon-car-front' => 'חזית מכונית',
        'sicon-airplane' => 'מטוס',
        'sicon-laptop' => 'מחשב נייד',
        'sicon-logo-instagram' => 'לוגו Instagram',
        'sicon-single-bed' => 'מיטת יחיד',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'לוגו Snapchat',
        'sicon-video-lg' => 'וידאו Lg',
        'sicon-reply' => 'תשובה',
        'sicon-subtract' => 'חיסור',
        'sicon-arrow-up-circle-line' => 'קו מעגל חץ למעלה',
        'sicon-asterisk' => 'כוכבית',
        'sicon-dot-circle-o-lg' => 'מעגל נקודות O Lg',
        'sicon-forward' => 'קדימה',
        'sicon-video' => 'וידאו',
        'sicon-gavel' => 'פטיש',
        'sicon-login' => 'כניסה',
        'sicon-pdf-file-xxl' => 'קובץ Pdf Xxl',
        'sicon-login-lg' => 'כניסה Lg',
        'sicon-cloud-download-xl' => 'הורדת ענן Xl',
        'sicon-campaigns-lg' => 'קמפיינים Lg',
        'sicon-customer-journey-stages-lg' => 'שלבי מסע לקוח Lg',
        'sicon-role-mgmt-lg' => 'ניהול תפקידים Lg',
        'sicon-default-module-lg' => 'מודול ברירת מחדל Lg',
        'sicon-quoted-line-items-lg' => 'שורות הצעות מחיר Lg',
        'sicon-projects-lg' => 'פרויקטים Lg',
        'sicon-process-business-rules-lg' => 'כללים עסקיים לתהליכים Lg',
        'sicon-process-email-templates-lg' => 'תבניות דוא"ל של תהליכים Lg',
        'sicon-processes-lg' => 'תהליכים Lg',
        'sicon-process-definitions-lg' => 'הגדרות תהליכים Lg',
        'sicon-target-lists-lg' => 'רשימות יעדים Lg',
        'sicon-purchased-line-items-lg' => 'רכישה Lg',
        'sicon-user-group-lg' => 'קבוצת משתמשים Lg',
        'sicon-revenue-line-items-lg' => 'פריטי שורות הכנסות Lg',
        'sicon-business-centers-lg' => 'מרכזי עסקים Lg',
        'sicon-logo-fb-simple' => 'לוגו Fb פשוט',
        'sicon-forecasts-lg' => 'תחזיות Lg',
        'sicon-contracts-lg' => 'חוזים Lg',
        'sicon-purchase-lg' => 'רכישה Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'מסע הלקוח Lg',
        'sicon-data-privacy-lg' => 'פרטיות נתונים Lg',
        'sicon-home-lg' => 'בית Lg',
        'sicon-data-table' => 'טבלת נתונים',
        'sicon-medical-clipboard-lg' => 'לוח רפואי Lg',
        'sicon-privacy-lg' => 'פרטיות Lg',
        'sicon-marketplace' => 'חנות',
        'sicon-marketplace-lg' => 'חנות Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => 'קזינו Lg',
        'sicon-jacuzzi-lg' => 'ג&#39;קוזי Lg',
        'sicon-scissors-lg' => 'מספריים Lg',
        'sicon-storage-lg' => 'אחסון Lg',
        'sicon-fan-lg' => 'מאוורר Lg',
        'sicon-medicine-lg' => 'רפואה Lg',
        'sicon-plant-lg' => 'צמח Lg',
        'sicon-telescope-lg' => 'טלסקופ Lg',
        'sicon-smart-phone-lg' => 'טלפון חכם Lg',
        'sicon-coffee-lg' => 'קפה Lg',
        'sicon-martini-lg' => 'מרטיני Lg',
        'sicon-cocktail-lg' => 'קוקטייל Lg',
        'sicon-stadium-lg' => 'אצטדיון Lg',
        'sicon-fire-lg' => 'אש Lg',
        'sicon-window-lg' => 'חלון Lg',
        'sicon-lotus-lg' => 'לוטוס Lg',
        'sicon-windmill-lg' => 'טחנת רוח Lg',
        'sicon-spades-lg' => 'פיק Lg',
        'sicon-hearts-lg' => 'לבבות Lg',
        'sicon-diamonds-lg' => 'יהלומים Lg',
        'sicon-clubs-lg' => 'תלתן Lg',
        'sicon-skull-lg' => 'גולגולת Lg',
        'sicon-send' => 'שלח',
        'sicon-world-lg' => 'עולם Lg',
        'sicon-airplane-lg' => 'מטוס Lg',
        'sicon-planet-lg' => 'כוכב לכת Lg',
        'sicon-trainer-lg' => 'מאמן Lg',
        'sicon-calculator-lg' => 'מחשבון Lg',
        'sicon-tv-lg' => 'טלוויזיה Lg',
        'sicon-video-player-lg' => 'נגן וידאו Lg',
        'sicon-media-player-lg' => 'נגן מדיה Lg',
        'sicon-decentralize-lg' => 'ביזור Lg',
        'sicon-statistics-lg' => 'סטטיסטיקה Lg',
        'sicon-virus-lg' => 'וירוס Lg',
        'sicon-shield-lg' => 'מגן Lg',
        'sicon-plug-lg' => 'פלאג Lg',
        'sicon-shuttle-lg' => 'שאטל Lg',
        'sicon-soundwave-lg' => 'גל קול Lg',
        'sicon-graph-lg' => 'גרף Lg',
        'sicon-playlist-lg' => 'פלייליסט Lg',
        'sicon-voice-recognition-lg' => 'זיהוי קולי Lg',
        'sicon-machine-learning-lg' => 'למידת מכונה Lg',
        'sicon-bed-lg' => 'מיטה Lg',
        'sicon-blueprint-lg' => 'שרטוט Lg',
        'sicon-content-delivery-lg' => 'אספקת תוכן Lg',
        'sicon-questionnaire-lg' => 'שאלון Lg',
        'sicon-presentation-lg' => 'מצגת Lg',
        'sicon-organic-lg' => 'אורגני Lg',
        'sicon-transactions-lg' => 'טרנזקציות Lg',
        'sicon-wand-lg' => 'שרביט Lg',
        'sicon-bin-lg' => 'פח Lg',
        'sicon-sync-lg' => 'סנכרון Lg',
        'sicon-external-authentication-lg' => 'אימות חיצוני Lg',
        'sicon-tracking-activity-lg' => 'מעקב אחר פעילות Lg',
        'sicon-account' => 'חשבון',
        'sicon-meetings-lg' => 'פגישות Lg',
        'sicon-stacked' => 'תצוגת פיצול אופקי',
        'sicon-sidebyside' => 'תצוגת פיצול אנכי',
        ],

        'module_colors_dom' => [
        'army' => 'צבא',
        'coral' => 'אלמוגים',
        'green' => 'ירוק',
        'orange' => 'כתום',
        'ocean' => 'אוקיינוס',
        'pacific' => 'האוקיינוס השקט',
        'pink' => 'ורוד',
        'purple' => 'סגול',
        'red' => 'אדום',
        'teal' => 'כחול-ירקרק',
        'yellow' => 'צהוב',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'חדש',
        'In Progress' => 'בביצוע',
        'Closed' => 'נסגר',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'אין פעילות',
        'Lack of Progress' => 'אין התקדמות',
        'Customer-Imposed Deadline' => 'תאריך יעד שהלקוח מחייב',
        'Account at Risk' => 'חשבון בסיכון',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'התבקש על ידי הלקוח',
        'Internally Requested' => 'התבקש מתוך הארגון',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'פניית שירות',
        'Bugs' => 'באג',
        'Accounts' => 'חשבון',
        'Opportunities' => 'הזדמנות',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'חיובי',
        'Negative' => 'שלילי',
        'Neutral' => 'נייטרלי',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'לא סביר',
        '02_less_likely' => 'פחות סביר',
        '03_neutral' => 'נייטרלי',
        '04_more_likely' => 'יותר סביר',
        '05_very_likely' => 'מאוד סביר',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'לא תואם ללקוחות',
        '02_no_match' => '',
        '01_matches_customers' => 'תואם ללקוחות',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'ליד',
        'Accounts' => 'חשבון',
        'Contacts' => 'איש קשר',
        'Cases' => 'קריאה',
        'Opportunities' => 'הזדמנות',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'לא התחיל',
        'in_progress' => 'בביצוע',
        'completed' => 'הושלם',
        'cancelled' => 'בוטל',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'ללא',
        'create' => 'ביצירה',
        'stage_start' => 'בתחילת השלב',
        'previous_activity_completed' => 'הפעילות הקודמת הושלמה',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'משתמש נוכחי',
        'parent_assignee' => 'מקבל הקצאת הורה',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'ימים מאז היצירה',
        'days_from_stage_started' => 'ימים מאז תחילת השלב',
        'days_from_previous_activity_completed' => 'ימים מאז השלמת הפעילות הקודמת',
        'days_from_parent_date_field' => 'ימים מאז שדה תאריך הורה',
        'days_from_specific_activity_completed' => 'ימים מאז שפעילות ספציפית הושלמה',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'בעת היצירה',
        'stage_started' => 'כשהשלב מתחיל',
        'previous_activity_completed' => 'בעת השלמת הפעילות הקודמת',
        'parent_date_field' => 'בשדה תאריך הורה',
        'specific_activity_completed' => 'פעילות ספציפית הושלמה',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'מוחלט',
        'Percentage' => 'אחוז',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'משימת לקוח',
        'milestone' => 'אבן דרך',
        'internal_task' => 'משימה פנימית',
        'agency_task' => 'משימת סוכנות',
        'automatic_task' => 'משימה אוטומטית',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'משימה',
        'Calls' => 'שיחה',
        'Meetings' => 'פגישה',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'ללא',
        'create' => 'ביצירה',
        'stage_start' => 'בתחילת השלב',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'לרשת',
        'current_user' => 'משתמש נוכחי',
        'parent_assignee' => 'מקבל הקצאת הורה',
        'user' => 'משתמש',
        'team' => 'צוות',
        'user_team' => 'משתמש וצוות',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'לרשת',
        'none' => 'ללא',
        'create' => 'ביצירה',
        'stage_start' => 'בתחילת השלב',
        'previous_activity_completed' => 'הפעילות הקודמת הושלמה',
        'specific_activity_completed' => 'פעילות ספציפית הושלמה',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'לא התחיל',
        'in_progress' => 'בביצוע',
        'not_completed' => 'לא הושלם',
        'completed' => 'הושלם',
        'cancelled' => 'בוטל',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'עריכת שלב',
        'stage_add_task_button' => 'צור משימה',
        'stage_add_meeting_button' => 'תזמן פגישה',
        'stage_add_call_button' => 'תזמן שיחה',
        'stage_delete_button' => 'מחק שלב',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'הוסף משימה',
        'activity_add_sub_meeting_button' => 'תזמן פגישה',
        'activity_add_sub_call_button' => 'תזמן שיחה',
        'activity_not_applicable_button' => 'לא ישים',
        'activity_delete_button' => 'מחק',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'הגדר כלא ישים',
        'remove_open_activities' => 'הסר פעילויות פתוחות',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'ברירת מחדל',
        'custom' => 'מותאם',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'GET',
        'POST' => 'POST',
        'PUT' => 'PUT',
        'PATCH' => 'PATCH',
        'DELETE' => 'DELETE',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'דלג על בקשה',
        'json' => 'JSON',
        'http_query' => 'שאילתת HTTP',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'אין תגובה',
        'json' => 'JSON',
        'http_query' => 'שאילתת HTTP',
        'text' => 'טקסט פשוט',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'לפני היצירה',
        'after_create' => 'אחרי היצירה',
        'before_in_progress' => 'לפני שבביצוע',
        'after_in_progress' => 'אחרי שבביצוע',
        'before_completed' => 'לפני שהושלם',
        'after_completed' => 'אחרי שהושלם',
        'before_not_applicable' => 'לפני לא ישים',
        'after_not_applicable' => 'אחרי לא ישים',
        'before_delete' => 'לפני מחיקה',
        'after_delete' => 'אחרי מחיקה',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'שלח מידע על מדריך חכם',
        'custom_body' => 'שלח גוף פוסט מותאם אישית',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'בביצוע',
        'completed' => 'הושלם',
        'not_applicable' => 'לא ישים',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'הצג רשומה',
        'create_record' => 'יצירת רשומה',
        'update_record' => 'עדכון רשומה',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'יצירה אוטומטית של רשומה',
        'manual_create' => 'יצירה ידנית של רשומה',
        'automatic_update' => 'עדכון אוטומטי של רשומה',
        'manual_update' => 'עדכון ידני של רשומה',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'תבנית מדריך חכם',
        'DRI_SubWorkflow_Templates' => 'תבנית שלב',
        'DRI_Workflow_Task_Templates' => 'תבנית פעילות',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'כן',
        'no' => 'לא',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'התקיים',
        'Not Held' => 'לא בהמתנה',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'התקיים',
        'Not Held' => 'לא בהמתנה',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'הושלם',
        'Not Applicable' => 'לא ישים',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'תבנית מדריך חכם',
        'DRI_SubWorkflow_Templates' => 'תבנית שלב',
        'DRI_Workflow_Task_Templates' => 'תבנית פעילות',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'משימה',
        'Meetings' => 'פגישה',
        'Calls' => 'שיחה',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'משימה נוכחית',
        'Calls' => 'שיחה נוכחית',
        'Meetings' => 'פגישה נוכחית',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'משתמשים ספציפיים',
        'specific_contacts' => 'אנשי קשר ספציפיים',
        'related_parent_users' => 'משתמשים הורים קשורים',
        'related_parent_contacts' => 'אנשי קשר הורים קשורים',
        'add_all_contacts_from_parent' => 'הוסף את כל אנשי הקשר מההורה',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'משתמשים',
        'specific_contacts' => 'אנשי קשר',
        'related_parent_users' => 'משתמשים',
        'related_parent_contacts' => 'אנשי קשר',
        'add_all_contacts_from_parent' => 'אנשי קשר',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'דקות',
        'hours' => 'שעות',
        'days' => 'ימים',
        'months' => 'חודשים',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'ימים',
        'months' => 'חודשים',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'תאריך קבוע',
        'relative' => 'תאריך יחסי',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'משתמשים',
        'teams' => 'צוותים',
        'roles' => 'תפקידים',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide לפעולה ב-Sugar',
        'sugar_action_to_smart_guide' => 'מפעולה ב-Sugar ל-Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'שלב Smart Guide',
        'Smart Guide Activities' => 'פעילויות Smart Guide',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'הושלם',
        'cancelled' => 'בוטל',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'בביצוע',
        'completed' => 'הושלם',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'בביצוע',
        'completed' => 'הושלם',
        'not_applicable' => 'לא ישים',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'סמן את כל הפעילויות כפעילויות שהושלמו',
        'mark_all_not_applicable' => 'סמן את כל הפעילויות שלא הושלמו כלא ישימות',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'ארצות הברית (אורגון) [us-west-2]',
        'ca-central-1' => 'קנדה (מרכז) [ca-central-1]',
        'ap-southeast-1' => 'אסיה פסיפיק (סינגפור) [ap-southeast-1]',
        'ap-southeast-2' => 'אסיה פסיפיק (סידני) [ap-southeast-2]',
        'eu-central-1' => 'אירופה (פרנקפורט) [eu-central-1]',
        'eu-west-2' => 'אירופה (לונדון) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'הקלט כותרת', // Studio editing of record views
    'LBL_RECORD_BODY' => 'כרטיס ביקור', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'הצג עוד', // Studio editing of record views
    'LBL_FAVORITE' => 'מועדפים', // Record view header panel element
    'LBL_FOLLOW' => 'עקוב', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'עקוב אחר קישור',
    'LBL_TOGGLE_VISIBILITY' => 'החלף נראות', // Record view header panel element
    'LBL_ACTIVITIES' => 'תזרים פעילויות',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM‏, Sugar וקוביית ‎3-D הם סימנים מסחריים רשומים של .SugarCRM Inc.' .
        'כל יתר השמות של חברות ומוצרים הנמצאים בשימוש במוצר זה או מופיעים בו עשויים להיות סימנים מסחריים של ' .
        'SugarCRM ®, Sugar Enterprise™ ו- Sugar™ הם סימנים מסחריים של SugarCRM Inc.',
    'LBL_TRADEMARK2' => 'SugarCRM®‎‏, Sugar Enterprise™‎ ו-Sugar™‎ הם סימנים מסחריים של SugarCRM Inc.',
    'LBL_SEND_INVITE' => 'שלח הזמנה',
    'LBL_INVITEES' => 'אורחים',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'האורח לא יקבל את ההזמנה שלך',
    'LBL_SELECT_ACTION_LABEL' => 'בחר פעולה',
    'LBL_TOGGLE_DRAWER' => 'החלף צייר',
    'LBL_TOUR_NEXT' => 'הבא',
    'LBL_TOUR_SKIP' => 'דלג',
    'LBL_TOUR_BACK' => 'חזרה',
    'LBL_TOUR_CLOSE' => 'סגור:',
    'LBL_TOUR_BTN_DONE' => 'בוצע',
    'LBL_TOUR_TAKE_TOUR' => 'קח סיבוב',
    'LBL_TOUR_FULL_TOUR' => 'סיור מלא',
    'LBL_TOUR_MODULE' => 'סייר בדף זה',
    'LBL_TOUR_END_TOUR' => 'סוף הסיור',
    'LBL_TOUR_OVERVIEW' => 'סקירת דף',
    'LBL_TOUR_REVISIT' => 'הקלק כאן לצפיה בסיור בכל עת',
    'LBL_MY_AREA_LINKS' => 'אזור הקישורים שלי' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'לוקח אוויר' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'ברוך הבא' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'חיפוש מתקדם' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'פרטים נוספים' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'ערוך בשורה' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'צפה' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'חיפוש' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'חפש...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'הסר' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'הוסף' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'עמודה' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => 'שתי עמודות' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => 'שלוש עמודות' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'חיפוש מתקדם' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'הוסף' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'הצג/הסתר' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'מחק' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'הוסף' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'נקה' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'הסר' /*for 508 compliance fix*/,
    'LBL_ADD' => 'הוסף' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'לוגו חברה' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'לוח שנה' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'ערך נפתח שבחרת שינה את תצורת תצוגת הרשומות. ' .
        'הערכים של שדות מוסתרים בתצורה חדשה זו נמחקו. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'פתח',
    'LBL_SIDEBAR_NAV_CLOSE' => 'סגירה',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => 'תפריט {{subject}}',
    'LBL_GOTO_SUGARCRM_COM' => 'עבור אל SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'ניווט במודול הראשי',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'החלף מצב פאנל-משנה',

    'LBL_ADVANCED' => 'מתקדם',
    'LBL_BASIC' => 'בסיסי',
    'LBL_MODULE_FILTER' => 'סנן על ידי',
    'LBL_CONNECTORS_POPUPS' => 'חלונות קופצים של מחברים',
    'LBL_CLOSEINLINE' => 'סגור:',
    'LBL_EDITINLINE' => 'ערוך',
    'LBL_VIEWINLINE' => 'צפה',
    'LBL_INFOINLINE' => 'מידע',
    'LBL_POWERED_BY_SUGARCRM' => 'מופעל על ידי SugarCRM',
    'LBL_PRINT' => 'הדפס',
    'LBL_HELP' => 'עזרה',
    'LBL_TOUR' => 'סיור',
    'LBL_TOUR_LINK' => 'סייר בדף זה',
    'LBL_MOBILE' => 'סלולרי',
    'LBL_ID_FF_SELECT' => 'בחר',
    'DEFAULT' => 'בסיסי',
    'LBL_SORT' => 'קצר',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'הוסף שרת...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'להפעיל SMTP על SSL או TLS?',
    'LBL_NO_ACTION' => 'אין פעילות בשם זה.',
    'LBL_NO_DATA' => 'אין נתונים',
    'LBL_NOT_APPLICABLE' => 'לא ישים',
    'LBL_ROUTING_ADD_RULE' => 'הוסף כלל',
    'LBL_ROUTING_ALL' => 'לפחות',
    'LBL_ROUTING_ANY' => 'כלשהו',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'בטל',
    'LBL_ROUTING_BUTTON_SAVE' => 'שמור כלל',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'העתק דואר',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'מחק אובייקט מערכת',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'מחק',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'מחק דוא"ל',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'העבר דוא"ל הלאה',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'דגלל דוא"ל',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'סמן כנקרא',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'סמן כלא נקרא',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'העבר דוא"ל',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'בצע את הפעולות הבאות',
    'LBL_ROUTING_ACTIONS_REPLY' => 'השב לדוא"ל',

    'LBL_ROUTING_CHECK_RULE' => "אובחנה שגיאה:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'וודא שכל השדות מסומנים.',
    'LBL_ROUTING_CONFIRM_DELETE' => "אתה בטוח שברצונך למחק כלל זה?<br />לא ניתן לאיזר הפעולה.",

    'LBL_ROUTING_FLAGGED' => 'קבע דגל',
    'LBL_ROUTING_FORM_DESC' => 'כללים שנשמרו פעילים מידית.',
    'LBL_ROUTING_FW' => 'העבר הלאה:',
    'LBL_ROUTING_LIST_TITLE' => 'כללים',
    'LBL_ROUTING_MATCH' => 'אם',
    'LBL_ROUTING_MATCH_2' => 'כשמתקיימים התאים הבאים:',
    'LBL_NOTIFICATIONS' => 'הודעות',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'העתק',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'תוכן גוף ההודעה',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'מאת',
    'LBL_ROUTING_MATCH_NAME' => 'נושא',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'בעדיפות גבוהה',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'בעדיפות רגילה',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'בעדיפות נמוכה',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'אל',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'מכיל',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'אינו מכיל',

    'LBL_ROUTING_NAME' => 'שם הכלל',
    'LBL_ROUTING_NEW_NAME' => 'כלל חדש',
    'LBL_ROUTING_ONE_MOMENT' => 'רגע אחד בבקשה...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'ההודעה המקורית עוקבת.',
    'LBL_ROUTING_RE' => 'הנדון:',
    'LBL_ROUTING_SAVING_RULE' => 'שומר כלל',
    'LBL_ROUTING_SUB_DESC' => 'הכללים המסומנים פעילים. הקש על השם כדי לבצע עריכה.',
    'LBL_ROUTING_TO' => 'ל',
    'LBL_ROUTING_TO_ADDRESS' => 'הכתובת אל',
    'LBL_ROUTING_WITH_TEMPLATE' => 'עם תבנית',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'רשומה זו כוללת ערכים בשדות טלפון במשרד וכתובת. כדי להזין את הטלפון במשרד והכתובת שהיקשת ולמחוק את הקיים הקש "OK". כדי לשמור את הערכים הקיימים הקש "בטל".',
    'LBL_DROP_HERE' => '[השלך לכאן]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'ערוך',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'מלא מראש ברירות מחדל של GMAIL &#153;',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'שם',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'מאפייני שרת דוטר יוצא',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'תוכנת העברת דואר',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'להשתמש באימות SMTP?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP סיסמאת',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'יציאת SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'שרת SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'השתמש ב SSL להתחברות',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP שם משתמש',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'ברירת מחדל',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'אזהרה: שם משתמש וסיסמא לדואר יוצא חסרים.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP נדרש שם משתמש ב',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP סיסמא נדרשת ל',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'ניהול חשבונות דוא"ל',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'פרוטוקול שרת דואר מסוג POP3 לא ייתמך בשחרור הבא. רק IMAP ייתמך.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'Set up Mail Accounts to view incoming emails from your email accounts.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Provide SMTP mail server information to use for outgoing email in Mail Accounts.',
    'LBL_EMAIL_ADD' => 'הוסף דואר אלקטרוני',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'בוצע',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'נקה',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'אל:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'עותק:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'עותק מוסתר:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'אל/לידיעת/עותק נסתר',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'רשימה חדשה',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'כתובות דוא"ל',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'בשלב זה ישנה תמיכה בעריכת איש הקשר בלבד.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'פילטר',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'שם פרטי/שם חשבון',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'שם משפחה',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'אנשי הקשר שלי',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'רשימות התפוצה שלי',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'שם',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'לא נמצאו כתובות',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'שמור והוסף לספר הכתובות',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'חפש',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'בחר נמעני דוא"ל',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'ספר כתובות',
    'LBL_EMAIL_REPORTS_TITLE' => 'דוחות',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'אזהרב! חשבון הדוא"ל היוצא שאתה מנסה למחוק קשור לחשבונות דוא"ל נכנס אחרים.  אתה בטוח שברצונך להמשיך?',
    'LBL_EMAIL_ADDRESSES' => 'דוא"ל',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'כתובת דוא"ל',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'כתובות דוא"ל',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'ייבוא אל המערכת',
    'LBL_EMAIL_ASSIGNMENT' => 'משימות',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'צרף',
    'LBL_EMAIL_ATTACHMENT' => 'צרף',
    'LBL_EMAIL_ATTACHMENTS' => 'המערכת המקומית',
    'LBL_EMAIL_ATTACHMENTS2' => 'ממסמכים בתוך ה CRM',
    'LBL_EMAIL_ATTACHMENTS3' => 'תבניות לצירוף קבצים',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'קובץ',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'מסמך',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'מטמע',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'צירוף קובץ נכשל',
    'LBL_REMOVING_ATTACHMENT' => 'מסיר קובץ מצורף...',
    'LBL_EMAIL_BCC' => 'עותק נסתר',
    'LBL_EMAIL_CANCEL' => 'בטל',
    'LBL_EMAIL_CC' => 'העתק',
    'LBL_EMAIL_CHARSET' => 'קוד שפה',
    'LBL_EMAIL_CHECK' => 'בדוק דואר',
    'LBL_EMAIL_CHECKING_NEW' => 'בודק אם יש דוא"ל חדש',
    'LBL_EMAIL_CHECKING_DESC' => 'רק רגע בבקשה... <br><br>אם זו הפעם הראשונה שאתה נכנס לחשבון הדוא"ל זה עלול לקחת קצת זמן.',
    'LBL_EMAIL_CLOSE' => 'Close',
    'LBL_EMAIL_COFFEE_BREAK' => 'בודק אם קיים דואר חדש. <br><br>חשבונות דוא"ל גדולים עלולים לקחת הרבה זמן המתן בסבלנות.',
    'LBL_EMAIL_COMMON' => 'משותף',

    'LBL_EMAIL_COMPOSE' => 'דוא"ל',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'אנא הכנס נמען או נמענים למייל הזה.',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'קשר עם',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'גוף ההודעה ריק, לשלוח בכל זאת?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'לדואר הזה אין נושא, לשלוח בכל זאת?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(אין נושא)',
    'LBL_EMAIL_COMPOSE_READ' => 'קרא וחבר הודעת דוא"ל',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'השלח מחשבון דוא"ל',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'אפשרויות',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'אנא הזן כתובת דוא"ל חוקית לשדות אל, לידיעת והעתק נסתר',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'השלך דוא"ל זה?',
    'LBL_EMAIL_CONFIRM_DELETE' => 'הסר רשומות אלה מספר הכתובות שלך?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'אתה בטוח שברצונך למחוק חתימה זו?',

    'LBL_EMAIL_CREATE_NEW' => '--צור תוך כדי שמירה--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'מרובה',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'ריק',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'תאריך שנשלח על ידי השולח',
    'LBL_EMAIL_DATE_RECEIVED' => 'נתונים התקבלו',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'הוקצה למשתמש',
    'LBL_EMAIL_DATE_TODAY' => 'היום',
    'LBL_EMAIL_DATE_YESTERDAY' => 'אתמול',
    'LBL_EMAIL_DD_TEXT' => 'דוא"ל נבחרו.',
    'LBL_EMAIL_DEFAULTS' => 'ברירות המחדל',
    'LBL_EMAIL_DELETE' => 'מחק',
    'LBL_EMAIL_DELETE_CONFIRM' => 'למחוק הודעות שנבחרו?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'ההודעות נמחקו בהצלחה.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'מוחק הודעה',
    'LBL_EMAIL_DETAILS' => 'פרטים',
    'LBL_EMAIL_DISPLAY_MSG' => 'מציג דוא"ל(s) {0} - {1} מתוך {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'מציג כתובות דוא"ל {0} - {1} מתוך {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'ערוך אנשי קשר',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'בעבודה עם אנשי קשר יעשה שימוש רק בכתובת ראשית.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'ערוך רשימת תפוצה לדוא"ל',

    'LBL_EMAIL_EMPTYING_TRASH' => 'רוקן סל מיחזור',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'מחק שרת דואר יוצא',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'מנקה קבצי מטמון',
    'LBL_EMAIL_EMPTY_MSG' => 'אין דוא"ל להצגה.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'אין כתובות דוא"ל להצגה.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'שם הספריה הוא חד ערכי והיא איננה ריקה. נזה שנית.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'לא ניתן למחוק ספריה זו. הספריה או ספריות המשנה מכילות דוא"ל או שקשורות בתיבת דואר כלשהי.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'לא מבין לאיזו ספריה אתה מתכוון.  נסה שנית.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'בדוק בבקשה את ההגדרות שלך.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'וודא שהכנסת שם משפחה.',
    'LBL_EMAIL_ERROR_DESC' => 'השגיאות הבאות אובחנו:',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'אין לך גישה לאזור זה, פנה למנהל המערכת לעזרה.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'שם הספריה חייב להיות חד ערכי.',
    'LBL_EMAIL_ERROR_EMPTY' => 'אנא הכנס קרטריונים לחיפוש.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'אירעה שגיאה',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'רשימת דוא"ל בשם זהה כבר קיימת',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'הודעה הוסרה מהשרת',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'או זההודעה הוסרה מהשרת או שהיא בספריה אחרת',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'הקישור לשרת הדואר נכשל. פנה למנהל המערכת',
    'LBL_EMAIL_ERROR_MOVE' => 'העברת דא"ל בין שרתי הדואר או בין ספריות איננו נתמך בשלב זה.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'שגיאה בהעברה',
    'LBL_EMAIL_ERROR_NAME' => 'נדרש שם.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'נדרשת כתובת מאת.  אנא הכנס כתובת דוא"ל חוקית.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'אנא ספק קובץ.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'אין כרגע תמיכה בשנוי שם ספריית בשרת ה IMAP.',
    'LBL_EMAIL_ERROR_SERVER' => 'כתובת שרת הדוא"ל נדרשת כאן.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'ככל הנראה חשבון הדוא"ל לא נשמר.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'אירעה שגיאה בתקקשורת עם שרת הדואר.',
    'LBL_EMAIL_ERROR_USER' => 'נדרש שם משתמש.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'נדרשת סיסמא.',
    'LBL_EMAIL_ERROR_PORT' => 'פורט שרת הדואר נדרש כאן.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'פרוטוקול דוא"ל נדרש כאן.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'נדרשת הספריה אותה רוצים לנטר.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'נדרשת ספריית סל המיחזור.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'המידע הזה אינו זמין',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'לא צויין שם שרת דואר יוצא.',
    'LBL_EMAIL_FOLDERS' => 'תיקיות',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'העבר אל',
    'LBL_EMAIL_FOLDERS_ADD' => 'הוסף',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'הוסף ספריה חדשה',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'שנה שם ספריה',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'שמירה',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'הוסף ספריה זו אל',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'לא ניתן לשנות ספריה זוd',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'אתה בטוח שברצונך למחוק ספריה זו?\nתהליך זה לא ניתן לאאחזר.\nהספריה כולל תת הספריות ימחקו לעד.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'שם לספריה חדשה',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'לפני ביצוע פעולה זו בחר ספריה.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'ניהול ספריות',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'קבוצות בשימוש',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'הקצה לצוות',
    'LBL_EMAIL_FORWARD' => 'העבר אל',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => 'הורדו [[count]] מתוך [[total]] דוא"ל',
    'LBL_EMAIL_FOUND' => 'נמצאו',
    'LBL_EMAIL_FROM' => 'מאת',
    'LBL_EMAIL_GROUP' => 'קבוצה',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'קבוצה',
    'LBL_EMAIL_HOME_FOLDER' => 'בית',
    'LBL_EMAIL_HTML_RTF' => 'שלך כ HTML',
    'LBL_EMAIL_IE_DELETE' => 'מוחק חשבון דוא"ל',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'מוחק חתימה',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'אתה בטוח שברצונך למחוק חשבון דוא"ל זה?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'נמחק בהצלחה.',
    'LBL_EMAIL_IE_SAVE' => 'שומר מידע על חשבון דוא"ל',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'מיבא דוא"ל',
    'LBL_EMAIL_IMPORT_EMAIL' => 'מיבא אל המערכת',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'מיבא הגדרות',
    'LBL_EMAIL_INVALID' => 'לא תקין',
    'LBL_EMAIL_LINK_RECORD' => 'הקלק כאן',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'שנה שם של רשימת תפוצה',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'הזן שם חדש לרשימת התפוצה הזו',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'הסר נתונים אלה מרשימת התפוצה הזו?',
    'LBL_EMAIL_LOADING' => 'טוען...',
    'LBL_EMAIL_MARK' => 'סמן',
    'LBL_EMAIL_MARK_FLAGGED' => 'כמדוגלל',
    'LBL_EMAIL_MARK_READ' => 'כנקרא',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'כלא מדוגלל',
    'LBL_EMAIL_MARK_UNREAD' => 'כלא נקרא',
    'LBL_EMAIL_ASSIGN_TO' => 'הקצה עבור',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'צור ספריה',
    'LBL_EMAIL_MENU_COMPOSE' => 'חבר אל',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'מחק ספריה',
    'LBL_EMAIL_MENU_EDIT' => 'ערוך',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'רוקן סל מיחזור',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'סנכרן',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'נקה קבצים ממטמון',
    'LBL_EMAIL_MENU_REMOVE' => 'הסר',
    'LBL_EMAIL_MENU_RENAME' => 'שנה שם',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'שנה שם ספריה',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'משנה את שם הספריה',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'אנא בצע בחירה לפני ביצוע הפעולה הזו.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'מחק ספריה (מרוחקת או מקומית)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'ארכב דבר דואר או דברי דואר לתוך SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'שלח דוא"ל לרשימת התפוצה שנבחרה',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'שלח דוא"ל לאיש הקשר הזה',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'הסר איש קשר',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'מחק דבר/י דוא"ל אלה',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'מחק ספריה (מרוחקת או מקומית)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'ערוך איש קשר',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'ערוך רשימת תפוצה',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'מחק את כל סלי המיחזור לחשבונות הדוא"ל שלך',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'סמן דבר/י דוא"ל אלה כמדוגללים',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'סמן דבר/י דוא"ל אלה כנקראו',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'סמן דבר/י דוא"ל אלה כלא מדוגללים',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'סמן דבר/י דוא"ל אלה כלא נקראו',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'מסיר רשימות תפוצה',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'שנה שם ספריה (מקומית או מרוחקת)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'השב לדוא"ל זה',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'השב אל כל הנמענים של דבר/י דוא"ל זה',

    'LBL_EMAIL_MESSAGES' => 'הודעות',

    'LBL_EMAIL_ML_NAME' => 'רשימת שמות',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'רשימת כתובות שנבחרה',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'רשימת כתובות שזמינות',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-Click</b> לבחירה מרובה<br />(Mac users use <b>CMD-Click</b>)',

    'LBL_EMAIL_NO' => 'לא',
    'LBL_EMAIL_NOT_SENT' => 'המערכת לא יכולה לבצע את מבוקשך, פנה בבקשה למנהל המערכת.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'לא ניתן היה להוסיף ב-users_password_link.',

    'LBL_EMAIL_OK' => 'אישור',
    'LBL_EMAIL_ONE_MOMENT' => 'רגע אחד בבקשה...',
    'LBL_EMAIL_OPEN_ALL' => 'פתח הודעות מרובות',
    'LBL_EMAIL_OPTIONS' => 'אפשרויות',
    'LBL_EMAIL_QUICK_COMPOSE' => 'השב בקצרה',
    'LBL_EMAIL_OPT_OUT' => 'ביטל הצטרפות',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'ביקש לא לקבל דוא"ל או אינו חוקי',
    'LBL_EMAIL_PAGE_AFTER' => 'מתוך {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'עמוד',
    'LBL_EMAIL_PERFORMING_TASK' => 'מבצע משימה',
    'LBL_EMAIL_PRIMARY' => 'ראשי',
    'LBL_EMAIL_PRINT' => 'הדפס',

    'LBL_EMAIL_QC_BUGS' => 'באג',
    'LBL_EMAIL_QC_CASES' => 'אירוע',
    'LBL_EMAIL_QC_LEADS' => 'ליד',
    'LBL_EMAIL_QC_CONTACTS' => 'איש קשר',
    'LBL_EMAIL_QC_TASKS' => 'משימה',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'הזדמנות',
    'LBL_EMAIL_QUICK_CREATE' => 'צור במהירות',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'בונה מחדש ספריות',
    'LBL_EMAIL_RELATE_TO' => 'קשר',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'הצג מערכות יחסים',
    'LBL_EMAIL_RECORD' => 'רשומת דוא"ל',
    'LBL_EMAIL_REMOVE' => 'הסר',
    'LBL_EMAIL_REPLY' => 'השב',
    'LBL_EMAIL_REPLY_ALL' => 'השב לכולם',
    'LBL_EMAIL_REPLY_TO' => 'השב-אל',
    'LBL_EMAIL_RETRIEVING_LIST' => 'מאחזר רשימת דוא"ל',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'מאחזר הודעה',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'מאחזר רשומת דוא"ל',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'בחר בבקשה רק רשומת דוא"ל אחת',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'לחזור למודול הקודם?',
    'LBL_EMAIL_REVERT' => 'פנה לאחור',
    'LBL_EMAIL_RELATE_EMAIL' => 'דוא"ל שקשור',

    'LBL_EMAIL_RULES_TITLE' => 'ניהול כללים',

    'LBL_EMAIL_SAVE' => 'שמירה',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'שמור והשב',
    'LBL_EMAIL_SAVE_DRAFT' => 'שמור טיוטה',

    'LBL_EMAIL_SEARCHING' => 'צבצע חיפוש',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'חיפוש מתקדם',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'תאריך מאת',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'תאריך עד',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'טקסט גוף ההודעה',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'אין כללים המתאימים לקרטריון החיפוש שלך.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'כללים לחיפוש',
    'LBL_EMAIL_SEARCH_TITLE' => 'חיפוש פשוט',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'חפש חשבון דוא"ל',

    'LBL_EMAIL_SELECT' => 'בחר',

    'LBL_EMAIL_SEND' => 'שלח',
    'LBL_EMAIL_SENDING_EMAIL' => 'שולח דוא"ל',

    'LBL_EMAIL_SETTINGS' => 'הגדרות',
    'LBL_EMAIL_SETTINGS_2_ROWS' => 'שתי שורות',
    'LBL_EMAIL_SETTINGS_3_COLS' => 'שלוש עמודות',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'סיגנון סידור',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'חשבונות דואר',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'נקה טופס',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'ייבוא דוא"ל תוך כדי צפייה',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'בדוק אם יש דואר חדש',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'השצמש בחלון צפייה מוקדמתe',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'השתמש בחלון קופץ',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'כמות דוא"ל לעמוד',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'ערוך חשבונות דוא"ל',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'תיקיות',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'כתובת השולח',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'כתובת דוא"ל להודעות בדיקה:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'לכתובות דוא"ל',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'שם מאת',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'השב לכתובות',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'מסך מלא',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'סנכרן כל חשבונות הדוא"ל',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'הודעת דוא"ל נשלחה לכתובת שצויינה באמצעות הגדרות דואר יוצא שהוגדרו. בדוק בבקשה שהדוא"ל הגיע על מנת לוודא שההגדרות נכונות.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'ביצוע פעולה זו יגרום לסינכרון חשבונות הדוא"ל ותוכנם.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'לבצע סינכרון מלא?\nחשבונות דוא"ל גדולים יקחו כמה דקות.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'לבחירת מספר ספריות בבת אחת לחץ על שיפט או קונטרול במקלדת שלך.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'כללי',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'ספריות קבוצה זמינות',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'צור ספריות לקבוצה',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'שומר ספריות לקבוצה',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'מאחזר סיפריות לקבוצה',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'ערוך ספריות לקבוצה',

    'LBL_EMAIL_SETTINGS_NAME' => 'שם חשבון דואר',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'בחר במספר ההודעות לעמוד בתיבת דואר נכנס. כדי להבחירה תקורן יש לרענן את הספריות.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'מאחזר חשבונות דואר',
    'LBL_EMAIL_SETTINGS_RULES' => 'כללים',
    'LBL_EMAIL_SETTINGS_SAVED' => 'ההגדרות נשמרו.\n\nכדי שהשינויים כנסו לתוקף עליך להעלות שוב את הדף הזה.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'יש לרענן את הדף על מנת שההגדרות החדשות יכנסו לפעולה',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'שלח הודעות בטקסט פשוט בלבד',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'פעיל',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'הודעות בעמוד',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'מקם טאב בתחתית העמוד',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'הגדרות לצפייה',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'ביצועים',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'הצג מתקדם',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'ספריות משתמשים זמינות',
    'LBL_EMAIL_ERROR_PREPEND' => 'שגיאה:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'שרת דואר יוצא שנבחר לחשבון זה איננו חוקי.  בדוק את ההגדרות או בחר שרת דואר יוצא עבור חשבון זה.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'לא קונפג שרת דואר יוצא שיאפשר שליחת דוא"ל. בחר שרת דואר יוצא או קנפג שרת דואר יוצא עבור חשבונות הדואר האלה >> שם חשבון דוא"ל.',
    'LBL_EMAIL_SHOW_READ' => 'הצג הכל',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'הצג הודעות שלא נקראו בלבד',
    'LBL_EMAIL_SIGNATURES' => 'חתימות',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'צור חתימה',
    'LBL_EMAIL_SIGNATURE_NAME' => 'שם לחתימה',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'גוף החתימה',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'אפליקציות Google עם רמת אבטחה נמוכה יותר',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'אחר',
    'LBL_EMAIL_AUTHORIZE' => 'הרשה',
    'LBL_EMAIL_AUTHORIZED' => 'מורשה',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'לא מורשה',
    'LBL_EMAIL_AUTH_WARNING' => 'על מנהל המערכת לקבוע את התצורה של מחבר {0} דרך &#39;מנהל מערכת&#39; > &#39;מחברים&#39; לפני שתוכל להגדיר את חשבון זה. לקבלת פרטים נוספים, עיין במסמכים של {1}.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'שגיאה במהלך אחזור נתוני המחבר',
    'LBL_EMAIL_AUTH_FAILURE' => 'כשל בהרשאה.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'עליך להעניק הרשאה לחשבון לפני שמירתו.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'עליך להעניק הרשאה לחשבון לפני בדיקתו.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'חשבון לא מורשה',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ ספריות מרוחקות ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ ספריות מקומיות ]',
    'LBL_EMAIL_SUBJECT' => 'נושא',
    'LBL_EMAIL_SUCCESS' => 'הצליח',
    'LBL_EMAIL_SUGAR_FOLDER' => 'ספריות מערכת',
    'LBL_EMAIL_TEAMS' => 'הוקצה לצוותים',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'גוף תבנית הדוא"ל ריק',
    'LBL_EMAIL_TEMPLATES' => 'תבניות',
    'LBL_EMAIL_TEXT_FIRST' => 'עמוד ראשון',
    'LBL_EMAIL_TEXT_PREV' => 'העמוד הקודם',
    'LBL_EMAIL_TEXT_NEXT' => 'העמוד הבא',
    'LBL_EMAIL_TEXT_LAST' => 'העמוד האחרון',
    'LBL_EMAIL_TEXT_REFRESH' => 'רענן',
    'LBL_EMAIL_TO' => 'אל',
    'LBL_EMAIL_TOGGLE_LIST' => 'רשימת החלפה',
    'LBL_EMAIL_VIEW' => 'צפה',
    'LBL_EMAIL_VIEWS' => 'נצפים',
    'LBL_EMAIL_VIEW_HEADERS' => 'הצג הדרים',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'גירסה להדפסה',
    'LBL_EMAIL_VIEW_RAW' => 'הצג דוא"ל גולמי',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'תכונה זו אינה זמינה בשימוש ב POP3.',
    'LBL_DEFAULT_LINK_TEXT' => 'מלל ברירת המחדל לקישור.',
    'LBL_EMAIL_YES' => 'כן',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'שלח הודעת בדיקה',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'הודעת בדיקה נשלחה',


    'LBL_EMAIL_MESSAGE_NO' => 'הודעה לא',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'ייבוא עבר',
    'LBL_EMAIL_IMPORT_FAIL' => 'יבוא ההודעה נכשל כי או שההודעה כבר יובאה או שהיא נמחקה מהשרת',

    'LBL_EMAILS_FROM' => 'המיילים נשלחו',
    'LBL_EMAILS_RECEIVED' => 'המיילים התקבלו',
    'LBL_EMAIL_ADDRESSES_USED' => 'כתובות דוא"ל המשומשות בדוא"ל',
    'LBL_EMAIL_ADDRESS' => 'כתובת דוא"ל',
    'LBL_FROM' => 'מאת',
    'LBL_TO' => 'אל',
    'LBL_CC' => 'CC',
    'LBL_BCC' => 'BCC',

    'LBL_START_DATE' => 'תאריך התחלה',
    'LBL_END_DATE' => 'תאריך סיום',
    'LBL_START' => 'התחלה',
    'LBL_END' => 'סיום',
    'LBL_DATE_LINKED' => 'תאריך מקושר',

    'LBL_LINK_NONE' => 'אין',
    'LBL_LINK_ALL' => 'הכל',
    'LBL_LINK_RECORDS' => 'רשומות',
    'LBL_LINK_SELECT' => 'בחר',
    'LBL_LINK_ACTIONS' => 'פעולות',
    'LBL_LINK_MORE' => 'עוד',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'אשר',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'ברצונך לסגור את #מודול#?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'את תציג הודעה זו בהמשך: &nbsp;',
    'LBL_INVALID_FILE_EXTENSION' => 'סיומת קובץ לא חוקית',
    'LBL_LIST_TEAM' => 'צוות',
    'LBL_TEAM' => 'צוות:',
    'LBL_TEAMS' => 'קבוצות',
    'LBL_TEAM_SET_ID' => 'שיבוץ צוות ID',
    'LBL_TEAM_SET_SELECTED_ID' => 'מזהה סט צוות נבחר',
    'LBL_TEAM_SET_SELECTED' => 'נבחר',
    'LBL_TEAM_SET_ENABLE' => 'אפשר הרשאות נוספות',
    'LBL_TEAM_SET_DISABLE' => 'בטל הרשאות נוספות',
    'LBL_TEAM_SET' => 'הגדרות קבוצה',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'צוותים נבחרים',
    'LBL_SEARCH_UNAVAILABLE' => 'מנוע החיפוש לא זמין,אנא נסה שנית מאוחר יותר',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'לא צויין צוות ראשי',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'שגיאה בהסרת ID של הצוות הראשי [{0}] עבור [{1}] מודול שה ID שלו [{2}]',
    'LBL_TEAM_ADD' => 'הוסף צוות',
    'LBL_TEAM_REMOVE' => 'הסר צוות',
    'LBL_TEAM_PRIMARY' => 'קבע כצוות עיקרי',

    'LBL_CLOSE_BUTTON_LABEL' => 'סגור',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} סומן כ{{status}}',

    'LBL_FOCUS' => 'פוקוס',

    'LBL_QUERY_VALID' => 'בר-תוקף',
    'LBL_QUERY_ERROR' => 'שגיאה!',
    'LBL_QUERY_CHILD' => 'שאילתת משנה ברת תוקף',
    'ERROR_EXAMINE_MSG' => 'בדוק בבקשה את הודעת השגיאה ברשומה מטה:',
    'NO_QUERY_SELECTED' => 'פורמט המידע שבחרת איננו מכיל שאילתא.  בחר בבקשה שאילתות מיוחדות עבור פורמט המידע הזה.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'An error has occured:',
    'ERR_AJAX_LOAD_FAILURE' => 'הייתה בעיה בביצוע הבקשה שלך. אנא נסה שוב מאוחר יותר.',
    'ERR_AJAX_LOAD_FOOTER' => 'במידה ושגיאה זו מופיעה שוב, אנא בקש ממנהל המערכת שלך להשבית Ajax עבור מודול זה',
    'ERR_CREATING_FIELDS' => 'שגיאה במלוי שדות המידע הנוספים האלה:',
    'ERR_CREATING_TABLE' => 'שגיאה ביצירת טבלה:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'מפריד העשרות לא יכול להכיל את אותו הסימן כמו מפריד המיאות.

  שנה את הערך בבקשה.',
    'ERR_DELETE_RECORD' => 'למחיקת איש הקשר הזה יש לציין מספר רשומה.',
    'ERR_EXPORT_DISABLED' => 'לא ניתן לייצא.',
    'ERR_EXPORT_TYPE' => 'שגיאה בייצוא',
    'ERR_REPORTS_DISABLED_EXPORT' => 'האפשרות &#39;ייצוא דוחות&#39; לא זמינה',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'רק משתמשי מנהל מערכת יכולים לייצא',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'הדוח משתמש במודולים בלי גישה ל&#39;ייצוא&#39;',
    'ERR_REPORTS_EXPORT_OWNER' => 'הדוח משתמש במודולים עם גישת ל&#39;ייצוא&#39; של &#39;בעלים&#39;',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'הדוח משתמש במודולים עם גישה מוגבלת ל&#39;רשימה&#39;',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'הדוח משתמש במודולים עם גישה מוגבלת ל&#39;תצוגה&#39;',
    'ERR_REPORTS_ACCESS_DISABLED' => 'הדוח משתמש במודולים עם גישה מוגבלת',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'הדוח משתמש בשדות עם גישה מוגבלת',
    'ERR_INVALID_AMOUNT' => 'אנא הכנס סכום חוקי.',
    'ERR_INVALID_DATE_FORMAT' => 'מבנה התאריך חייב להיות:',
    'ERR_INVALID_DATE' => 'אנא הכנס תאריך חוקי.',
    'ERR_INVALID_DAY' => 'אנא הזן יום חוקי.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'כתובת מייל לא חוקית.',
    'ERR_INVALID_FILE_REFERENCE' => 'מראה מקום הקובץ איננו חוקי',
    'ERR_INVALID_HOUR' => 'הזן בבקשה שעה חוקית.',
    'ERR_INVALID_MONTH' => 'הזן בבקשה חודש חוקי.',
    'ERR_INVALID_TIME' => 'הזן בבקשה זמן חוקי.',
    'ERR_INVALID_YEAR' => 'אנא הזן שנה חוקית בארבע ספרות.',
    'ERR_NEED_ACTIVE_SESSION' => 'לייצוא התוכן חייבת להיות פעילות חוקית.',
    'ERR_NO_HEADER_ID' => 'תכונה זו אינה זמינה בערכת נושא זו.',
    'ERR_NOT_ADMIN' => 'גישה לא מורשית למערכת ניהול.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'ניהול הססמאות זמין רק ב<a href="%s" target="_blank">הגדרות SugarCloud</a>.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'צור קשר עם מנהל מערכת של Sugar אם ברצונך לבצע שינויים בשדות שהוגדרו לקריאה בלבד.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'יש לגשת אל <a href="{0}" target="_blank">הגדרות SugarCloud</a> כדי לבצע שינויים בשדות שהוגדרו לקריאה בלבד.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'חסר שדה נדרש:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'שדה נדרש איננו חוקי:',
    'ERR_INVALID_VALUE' => 'ערך חוקי:',
    'ERR_NO_SUCH_FILE' => 'הקובץ איננו קיים במערכת',
    'ERR_NO_SINGLE_QUOTE' => 'לא ניתן להשתמש בגרשיים עבור סימון',
    'ERR_NOTHING_SELECTED' => 'אנא בצע בחירה לפני שתמשיך.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'הזדמנות בשם %s כבר קיימת.  אנא הכנס שם אחר למטה.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'לא הוזן שם ההזדמנות.  הזן בבקשה שם הזדמנות למטה.',
    'ERR_QUOTE_CONVERTED' => 'הצעת מחיר זו כבר הומרה להזדמנות',
    'ERR_POTENTIAL_SEGFAULT' => 'שגיאת סגמנטציה בשרת האפצי אירעה ככל הנראה.  דווח בבקשה למנהל המערכת על מנת שיוכל לדווח ל SugarCRM.',
    'ERR_SELF_REPORTING' => 'משתמש איננו יכול לדווח לעצמו.',
    'ERR_SINGLE_QUOTE' => 'לא נין להתמש בגרש לסימון שדה זה.  בחר משהו אחר.',
    'ERR_SQS_NO_MATCH_FIELD' => 'אין התאמה לשדה:',
    'ERR_SQS_NO_MATCH' => 'אין התאמה',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'אנא ספר &#39;key&#39; אינדקס בתוך displayParams תכונה להגדרות מטה-דטה אלה',
    'ERR_EXISTING_PORTAL_USERNAME' => 'שגיאה: שם פורטל זה כבר הוקצה לאיש קשר אחר.',
    'ERR_PORTAL_NAME_CHECK' => 'לא ניתן לוודא ששם המשתמש לפורטל ייחודי',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'הערך לשדה איננו תואם לערךהמדויק הנדרש',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'אירעה שגיאה בעת ניסיון שמירה של חשבון חיצוני.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'אירעה שגיאה בעת ביצוע העלאה  לשרת.  וודא שהקובץ שאתה מנסה להעלות איננו ריק.',
    'ERR_NO_DB' => 'לא מצליח להתחבר למסד הנתונים. פנה ל SugarCRM.Log לקבלת פרטים.',
    'ERR_DB_FAIL' => 'שגיאה במסד הנתונים. פנה בבקשה sugarcrm.log לקבלת פרטים.',
    'ERR_EXTERNAL_API_403' => 'הרשות נדחתה. סוג קובץ לא נתמך.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'Token גישת מחבר חסר',
    'ERR_DB_VERSION' => 'קבצי שוגר {0} ניתנים לשימוש עם בסיס נתונים של שוגר {1} Database.',
    'ERR_DB_QUERY' => '{0}:שאילתא נכשלה: {1}',
    'ERR_UW_RETIRED' => 'אשף שדרוג אינו זמין בגירסה זו',
    'ERR_NOT_CLOUD_INSTANCE' => 'מופע זה של Sugar אינו מופע של SugarCloud או שאינו מוגדר עבור תובנות של SugarCloud.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'אין לך הרשאה ליצור {moduleName}. צור קשר עם האדמיניסטרטור אם אתה צריך גישה.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'המתשמש הנוכחי אינו רשאי לשנות הגדרות של  {moduleName}',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'המתשמש הנוכחי אינו רשאי לשנות הגדרות של  {moduleName}',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'אינך מורשה למועדף  {moduleName}',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'אינך מורשה להרשם למועדף  {moduleName}',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'worksheet_columns_related_fields לא נמצאו במטען',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns אינו מערך',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'summary_columns_related_fields לא נמצאו במטען',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows אינו מערך',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rows_related_fields לא נמצאו במטען',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'בקשתך נכשלה מסיבה לא ברורה',
    'EXCEPTION_FATAL_ERROR' => 'בקשתך נכשלה בגלל טעות קריטית. בדוק את הלוגים לפרטים נוספים.',
    'EXCEPTION_NEED_LOGIN' => 'עליך להיות מחובר על מנת לבצע פעולה זו',
    'EXCEPTION_INVALID_TOKEN' => 'Token האימות שלך אינו תקין',
    'EXCEPTION_NOT_AUTHORIZED' => 'אינך מורשה לבצע פעולה זו',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'אינך מורשה להציג נתונים. פנה אל מנהל המערכת לקבלת גישה.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'אינך יכול להכנס לפורטל נכיוון שחשבון פורטל זה אינו פעיל.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'הפורטל אינו מוגדר כהלכה',
    'EXCEPTION_NO_METHOD' => 'בקשתך לא נתמכה. לא ניתן למצוא מתודת HTTP.',
    'EXCEPTION_NOT_FOUND' => 'המשאב שביקשת לא נמצא.',
    'EXCEPTION_MISSING_PARAMTER' => 'חסר פמטר בבקשתך',
    'EXCEPTION_INVALID_PARAMETER' => 'אחד הפרמטרים בבקשתך שגוי',
    'EXCEPTION_REQUEST_FAILURE' => 'בקשתך נכשלה',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'המטה דטה שלך או האש משתמש לא מתאים לשרת. אנא סנכרן מחדש את המטה דטה',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'בקשתך גדולה מדי לעיבוד',
    'EXCEPTION_EDIT_CONFLICT' => 'שגיאה בעריכה. אנא טען מחדש את רשומת הנתונים',
    'EXCEPTION_METADATA_CONFLICT' => 'שגיאה במטה דטה. טען מחדש את המטה דטה',
    'EXCEPTION_CLIENT_OUTDATED' => 'התוכנה שלך לא מעודכנת. אנא עדכן את ה Client שלך',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'מחבר או בקשת אינטגרצעה הובילו לתשובה שגויה',
    'EXCEPTION_MAINTENANCE' => 'שוגר נמצא במצב תחזוקה. רק מנהלים יכולים להכנס.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'השרת לא יכול לעבד את הבקשה שלך מכיוון שהוא עסוק או לא זמין בשלב זה.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'מנוע החיפוש לא זמין באופן זמני.',
    'EXCEPTION_SEARCH_RUNTIME' => 'התרחשה שגיאת זמן ריצה במנוע החיפוש. אנא פנה למנהל המערכת שלך.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'אין אפשרות לערוך שדה הנעול על-ידי תהליך.',
    'EXCEPTION_MODULE_DISABLED' => 'מודול זה מושבת עבור המשתמש הנוכחי.',
    'EXCEPTION_FIELD_DISABLED' => 'שדה זה מושבת עבור המשתמש הנוכחי.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'אין הרשאה ללקוח זה',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'היכולת להעלות חבילות אינה זמינה עבור סוג הרישיון שלך',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'נוצר מצב בעיה בשל כשל כללי או שגיאה. קיימות סיבות שונות לחריגה זו אך בדרך כלל מצב הבעיה נובע מחריגת API ספציפית.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'לא ניתן לעבד את הבקשה כפי שהוצגה או שקרתה שגיאה בתגובה. בדרך כלל המשמעות של זה היא שקרתה שגיאה חמורה וניתן לזהות את הכשל הספציפי בקובץ התיעוד של היישום.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'גירסת ממשק המשתמש שלך לא מתאימה לבקשה הניכחית',
    'EXCEPTION_NEED_LOGIN_DESC' => 'נקודת הקצה המבוקשת דורשת אימות והצרכן המבקש עוד לא אימת.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'מציין שאסימון האימות שהוצג עם הבקשה לא חוקי. זה בדרך כלל קורה עקב תפוגת התוקף של האסימון, אך עלול לקרות גם במידה והאסימון פגום או שגוי.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'מציין שלצרכן המבוקש אין הרשאה לבצע את הפעולה המבוקשת.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'חשבון השער שמשויך למשתמש המחובר לא פעיל כרגע. זה דורש פעולה של תמיכת הלקוחות.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'מציין שיישום השער לא מוגדר כהלכה ולא ניתן להשתמש בו. זה דורש פעולה של מנהל מערכת השער.',
    'EXCEPTION_NO_METHOD_DESC' => 'נקודת הקצה לא תומכת בסוג בקשת ה-HTTP שנשלחת. זה יכול לקרות כאשר בקשת POST נשלחת לנקודת קצה שנועדה לבקשת GET, לדוגמה.',
    'EXCEPTION_NOT_FOUND_DESC' => 'נקודת הקצה לא יכולה לאתר משאב עבור הבקשה או שאין לה מטפל לבקשה.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'מציין שייתכן ומתבצעות עריכות מקבילות של רישום והבקשה הנוכחית לעריכת הרישום תשפיע על עריכה קודמת שלו.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'מציין כי המטה-נתונים בשרת לא תואמים למטה-נתונים שמכונת הלקוח משתמש בהם כרגע. זה עלול לקרות לאחר ביצוע שינוי בהגדרות המערכת, שינויים במודולים ב-Studio או פרישתם של מודולים חדשים, בין שינויי מערכת אחרים.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'הבקשה גדולה מדי עבור השרת',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'חסר נתון בבקשה',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'נתון שנשלח אינו תקין',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'הבקשה נכשלה',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'מציין כי מכונת הלקוח שצורכת את ה-API מיושנת ויש לעדכן אותה קודם לצריכה נוספת של API.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'מצביע על כך שבקשה מהממשק לשירות אחר או URI נכשלו',
    'EXCEPTION_MAINTENANCE_DESC' => 'המופע של SugarCRM שמשרת את ה-API נמצא במצב תחזוקה. גישה ל-API מוגבלת למנהלי מערכת בלבד.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'מציין שהשרת עסוק, עמוס או מושבת.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'הקצה האחורי של מנוע החיפוש לא זמין כרגע עקב בעיית חיבור. אמת חיבוריות ותצורה במנהל מערכת->חיפוש->בדיקה.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'חריגת זמן הרצה קרתה ב-SearchEngine. ראה sugarcrm.log לפרטים נוספים.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'אין אפשרות לערוך שדה הנעול כעת על-ידי תהליך פועל.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s נעול על-ידי תהליך פועל, ולא ניתן לערוך אותו.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s נעולים על-ידי תהליך פועל, ולא ניתן לערוך אותם.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'מודול זה מושבת עבור המשתמש הנוכחי.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'שדה זה מושבת עבור המשתמש הנוכחי.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'אין הרשאה ללקוח זה',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'כבר קיים קובץ באותו שם במערכת.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'שגיאה תקופת זמן לא הוגדרה לתאריך {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'לתקופת הזמן כבר יש תתי תקופת זמן',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'לא ניתן לשים תתי תקופות בתתי תקופת זמן',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'לא ניתן לאחזר תקופות זמן מסוג {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'אין פרקי זמן פעילים עבור ההגדרות הנוכחיות.',
    'LBL_CURRENT_TIMEPERIOD' => 'תקופת זמן נוכחית',
    'LBL_PREVIOUS_TIMEPERIOD' => 'תקופת זמן קודמת',
    'LBL_NEXT_TIMEPERIOD' => 'תקופת זמן הבאה',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'הקודם, הנוכחי, הבא',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'לא ניתן למחוק רשומות אשר בשלב מכירות סגור',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'לא ניתן למחוק רשומות אשר בסטטוס מכירות סגור',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'רשומה אחת או יותר מאלה שנבחרו הן בשלב מכירה נסגר בהצלחה או נסגר ואבד ולכן לא ניתן למחיקה',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'רשומה אחת או יותר מאלה שנבחרו הן בשלב נסגר בהצלחה או נסגר ואבד ולכן לא ניתן למחיקה',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'אחת או יותר מהרשומות שנבחרו הן בעלות שלב מכירה של "סגור נצחון" או "סגור הפסד" ולא ניתן לעדכן את כולן ביחד.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'חשבון',
    'LBL_OLD_ACCOUNT_LINK' => 'חשבון ישן',
    'LBL_ACCOUNTS' => 'חשבונות',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'פעילויות',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'צפה בתקציר',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'צפה בתקציר [Alt+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'הוסף [Alt+A]',
    'LBL_ADD_BUTTON' => 'הוסף',
    'LBL_ADD_DASHLET_BUTTON' => 'הוסף חלונית',
    'LBL_ADD_DOCUMENT' => 'הוסף מסמך',
    'LBL_REPLACE_BUTTON' => 'החלף',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'הוסף לרשימת מטרות',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'הוסך לרשימת מטרות',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'הקש כדי לסגור',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'סגור',
    'LBL_ADDITIONAL_DETAILS' => 'פרטים נוספים',
    'LBL_ADMIN' => 'מנהל מערכת',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'ארכיב',
    'LBL_ASSIGNED_TO_USER' => 'הוקצה למשתמש',
    'LBL_ASSIGNED_TO' => 'הוקצה עבור:',
    'LBL_BACK' => 'חזרה',
    'LBL_BASE_RATE' => 'שער בסיס',
    'LBL_BILL_TO_ACCOUNT' => 'הגש חשבון לאיש קשר',
    'LBL_BILL_TO_CONTACT' => 'הגש חשבון לאיש קשר',
    'LBL_BILLING_ADDRESS' => 'כתובת להתחשבנויות',
    'LBL_QUICK_CREATE_TITLE' => 'צור במהירות',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'באגים',
    'LBL_BY' => 'על ידי',
    'LBL_CALLS' => 'שיחות טלפון',
    'LBL_CALL' => 'שיחת טלפון',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'שלח קמפיין דוא"ל שבתור',
    'LBL_SUBMIT_BUTTON_LABEL' => 'הגש',
    'LBL_CASE' => 'אירוע',
    'LBL_CASES' => 'אירועים',
    'LBL_MESSAGE' => 'הודעה',
    'LBL_MESSAGES' => 'הודעות',
    'LBL_ESCALATIONS' => 'הסלמות',
    'LBL_ESCALATION' => 'הסלמה',
    'LBL_DOCUSIGN_ENVELOPES' => 'מעטפות DocuSign',
    'LBL_DOCUSIGN_ENVELOPE' => 'מעטפת DocuSign',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'בחר נמעני חתימה',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'שינוי סיסמה',
    'LBL_CHANGE_BUTTON_LABEL' => 'שנה',
    'LBL_CHANGE_BUTTON_TITLE' => 'שנה [Alt+G]',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'סמן הכל',
    'LBL_CITY' => 'עיר',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'נקה',
    'LBL_CLEAR_BUTTON_TITLE' => 'נקה',
    'LBL_CLEARALL' => 'נקה בכל',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => 'סגור',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'סגור חלון',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'סגור הכל',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'סגור הכל [Alt+I]',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'סגור וצור חדש',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'סגור וצור חדש',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'העתק URL של רשומה',
    'LBL_OPEN_ITEMS' => 'פריטים פתוחים:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'חבר דוא"ל',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'דוא"ל',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'חבר דוא"ל [Alt+L]',
    'LBL_SEARCH_DROPDOWN_YES' => 'כן',
    'LBL_SEARCH_DROPDOWN_NO' => 'לא',
    'LBL_CONTACT_LIST' => 'רשימת אנשי קשר',
    'LBL_CONTACT' => 'איש קשר',
    'LBL_CONTACTS' => 'אנשי קשר',
    'LBL_CONTRACTS' => 'חוזים',
    'LBL_COUNTRY' => 'אזור:',
    'LBL_RESET_BUTTON_LABEL' => 'איפוס',
    'LBL_CREATE_BUTTON_LABEL' => 'צור',
    'LBL_CREATED_BY_USER' => 'נוצר על ידי משתמש',
    'LBL_CREATED_USER' => 'נוצר על ידי משתמש',
    'LBL_CREATED_ID' => 'נוצר על ידי Id',
    'LBL_CREATED' => 'נוצר על ידי',
    'LBL_CREATE_NEW_TARGET_LIST' => 'צור רשימת מטרה חדשה',
    'LBL_CURRENT_USER_FILTER' => 'הצוותים שלי:',
    'LBL_CURRENCY' => 'מטבע:',
    'LBL_CURRENCIES' => 'מטבעות',
    'LBL_CURRENCY_NAME' => 'שם מטבע',
    'LBL_CURRENCY_SYMBOL' => 'סימול מטבע',
    'LBL_CURRENCY_RATE' => 'שער בסיס',
    'LBL_CURRENCY_ID' => 'מטבע ID',
    'LBL_DOCUMENTS' => 'מסמכים',
    'LBL_DATE_ENTERED' => 'נוצר בתאריך:',
    'LBL_DATE_MODIFIED' => 'שונה בתאריך:',
    'LBL_ACTIVITY_MODIFIED' => 'השתנה',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'עריכת לשונית &#39;סקירה&#39;',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'עריכת לשוניות &#39;מודול&#39;',
    'LBL_EDIT_BUTTON' => 'ערוך',
    'LBL_DUPLICATE_BUTTON' => 'שכפל',
    'LBL_DELETE_BUTTON' => 'מחק',
    'LBL_DELETE' => 'מחק',
    'LBL_DELETED' => 'נמחק',
    'LBL_DIRECT_REPORTS' => 'דוחות ישירים',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'בוצע',
    'LBL_DONE_BUTTON_TITLE' => 'בוצע',
    'LBL_DST_NEEDS_FIXIN' => 'האפליקציה דורשת ליישם שעון חורף או קיץ.  לך אל <a href="index.php?module=Administration&action=DstFix">Repair</a> לינק בקונסול הניהול והפעל שעון חורף או קיץ כנדרש.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'ערוך כחדש',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'ערוך כחדש',
    'LBL_EDIT_IN_NEW_TAB' => 'ערוך בלשונית חדשה',
    'LBL_FAVORITES' => 'מועדפים',
    'LBL_FILTER' => 'מסנן',
    'LBL_DEFAULT_DATA_FILTER' => 'מסנן נתונים ברירת מחדל',
    'LBL_FILTER_MENU_BY' => 'סנן תפריט על ידי',
    'LBL_FILTER_SELECT_FIELD' => 'בחר קובץ...',
    'LBL_FILTER_SELECT_OPERATOR' => 'בחר אופרטור...',
    'LBL_FILTER_CREATE_NEW' => 'צור',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'בניית מסנן (לא נשמר)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(לא נשמר)',
    'LBL_FILTER_CREATE_FILTER' => 'צור מסנן חדש',
    'LBL_FILTER_CLOSE_FILTER' => 'סגור מסנן',
    'LBL_FILTER_EDIT_FILTER' => 'ערוך מסנן',
    'LBL_FILTER_ALL_RECORDS' => 'כל הרשומות',
    'TPL_FILTER_SAVE' => 'יצרת בהצלחה פילטר {{name}}.',
    'LBL_FILTER_BETWEEN_FROM' => 'מאת',
    'LBL_FILTER_BETWEEN_TO' => 'אל',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'תאריך התחלה',
    'LBL_FILTER_DATEBETWEEN_TO' => 'תאריך סיום',
    'LBL_FOLLOWING' => 'עוקב',
    'LBL_UNFOLLOW' => 'בטל מעקב',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'הורד vCard',
    'LBL_EMPTY_VCARD' => 'בחר בבקשה vCard קובץ',
    'LBL_IMAGE' => 'תמונה',
    'LBL_EMPTY_REQUIRED_VCARD' => 'אין את כל השדות הדרושים במודול זה ל vCard',
    'LBL_VCARD_ERROR_FILESIZE' => 'העלאה חורגת מ 30000 תווים',
    'LBL_VCARD_ERROR_DEFAULT' => 'שגיאה בהעלאת קובץ vCard',
    'TPL_IMPORT_VCARD_FAILURE' => 'נכשל ביצירת {{module}} מ vCard',
    'LBL_IMPORT_VCARD' => 'ייבוא vCard:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'ייבוא vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'ייבוא vCard [Alt+I]',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'צפה',
    'LBL_VIEW_BUTTON_TITLE' => 'צפה [Alt+V]',
    'LBL_VIEW_BUTTON' => 'צפה',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'דוא"ל כ PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'דוא"ל כ [Alt+M]',
    'LBL_EMAIL' => 'דואר אלקטרוני',
    'LBL_EMAILS' => 'דוא"ל',
    'LBL_EMPLOYEES' => 'עובדים',
    'LBL_ENTER_DATE' => 'הכנס תאריך',
    'LBL_EXPORT_ALL' => 'ייצא הכל',
    'LBL_EXPORT' => 'ייצא',
    'LBL_FAVORITES_FILTER' => 'המועדפים שלי:',
    'LBL_GLOBAL_SEARCH' => 'חיפוש גלובלי',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'מודול פילטר חיפוש גלובלי',
    'LBL_GLOBAL_SEARCH_RUN' => 'בצע חיפוש גלובלי',
    'LBL_GO_BUTTON_LABEL' => 'עבור',
    'LBL_GS_HELP' => 'השדות במודול זה שמובאים לשימוש בחיפוש מופיעים לעלה. המילים המודגשות תואמות לקריטריוני החיפוש שלך.',
    'LBL_HIDE' => 'הסתר',
    'LBL_ID' => 'מזהה',
    'LBL_IMPORT' => 'ייבוא',
    'LBL_IMPORT_STARTED' => 'ייבוא החל:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'חובה לספק תוחם מיוחד.',
    'LBL_LAST_VIEWED' => 'ניצפו לאחרונה',
    'LBL_SELECTED_RECORDS' => 'נבחר: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'הראה פחות',
    'LBL_SHOW_MORE' => 'הראה עוד',
    'LBL_SHOW_MORE_MODULE' => 'עוד {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'עוד לאחרונה...',
    'LBL_SHOW_LESS_RECENTS' => 'פחות לאחרונה...',
    'LBL_SHOW_MORE_RESULTS' => 'תוצאות חיפוש נוספות...',
    'TPL_SHOW_MORE_MODULE' => 'עוד {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => 'עוד {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => 'הפעילויות היום',
    'LBL_LEADS' => 'לידים',
    'LBL_LEAD' => 'ליד',
    'LBL_QUOTES_BILL_TO' => 'הצעות מחיר (חייב את)',
    'LBL_LESS' => 'פחות',
    'LBL_CAMPAIGN' => 'קמפיין:',
    'LBL_CAMPAIGNS' => 'קמפיינים',
    'LBL_CAMPAIGNLOG' => 'קמפיין לוג',
    'LBL_CAMPAIGN_CONTACT' => 'קמפיינים',
    'LBL_CAMPAIGN_ID' => 'קמפיין_id',
    'LBL_THEME' => 'ערכת נושא:',
    'LBL_THEME_PICKER' => 'סיגנון העמוד',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'אזהרה: אינטרנט אקספלורר גרסה 6 איננו מתאים לערכת הנושא הזו. הקש על OK על מנת לבחור ערכה זו למרות זאת או בחר ערכה אחרת.',
    'LBL_FOUND_IN_RELEASE' => 'נמצא בשיחרור',
    'LBL_FIXED_IN_RELEASE' => 'תוקן בשחרור',
    'LBL_LIST_ACCOUNT_NAME' => 'שם חשבון',
    'LBL_LIST_ASSIGNED_USER' => 'משתמש',
    'LBL_LIST_CONTACT_NAME' => 'שם איש קשר',
    'LBL_LIST_CONTACT_ROLE' => 'צור תפקיד',
    'LBL_LIST_DATE_ENTERED' => 'נוצר בתאריך',
    'LBL_LIST_EMAIL' => 'דוא"ל',
    'LBL_LIST_NAME' => 'שם',
    'LBL_LIST_OF' => 'של',
    'LBL_LIST_PHONE' => 'טלפון',
    'LBL_LIST_RELATED_TO' => 'קשור ל-',
    'LBL_LIST_USER_NAME' => 'שם משתמש',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'אתה בטוח שברצונך לעדכן את כל הרשימה הזו?',
    'LBL_LISTVIEW_NO_SELECTED' => 'כדי להמשיך בחר לפחות רשומה אחת.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'כדי להמשיך בחר לפחות שתי רשומות.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'כדי להמשיך בחר פחות מעשר רשומות.',
    'LBL_LISTVIEW_ALL' => 'הכל',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'הקפאת עמודה 1',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'כל ההעתקים',
    'LBL_LISTVIEW_NONE' => 'בטל הכל',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'בחר עמוד זה',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'בחר הכל',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'רשומות שנבחרו',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'נבחר: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'נקה את כל הבחירות.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'בחר את כל הרשומות',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'יש יותר מ {{num}} רשומות. בחרת  {{num}} רשומות ראשונות',
    'TPL_LISTVIEW_SELECTED' => 'בחרת {{num}} הרשומות שבתוצאות.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'בחרת רשומה אחת בקבוצת התוצאות.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'בחרת את כל {{num}} הרשומות שבתוצאות',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'בחרת את כל {{num}} הרשומות שבתוצאות שבתצוגה זו.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'מעדכן {{num}} מתוך {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(נשאר כ {{time}} {{unit}} זמן)',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'עדכון גורף נכשל. מנסה שוב ({{num}} of {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'עדכון גורף לא הושלם. {{num}} רשומות נותרו ללא שינוי',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'עדכון גורף לא הושלם. {{num}} רשומות נותרו ללא שינוי',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} רשומה(ות) זכו להתעלמות עקב הרשאות או שגיאות.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} רשומות עודכנו בהצלחה',
    'TPL_MASSUPDATE_TITLE' => '{{module}} עדכון גורף',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'מוחק {{num}} מתוך {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(נשאר כ {{time}} {{unit}} זמן)',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'עדכון גורף נכשל. מתחיל נסיון חחדש  ({{num}} מתוך {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'מחיקה גורפת לא הושלמה. נותרו  {{num}} רשומות',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'מחיקה גורפת לא הושלמה. נותרו  {{num}} רשומות',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} רשומות נמחקו בהצלחה',
    'TPL_MASSDELETE_TITLE' => '{{module}} מחיקה גורפת',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'מוסיף {{num}} מתוך {{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(נשאר כ {{time}} {{unit}} זמן)',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'הוספה גורפת לרשימת מטרה נכשלה. מתחיל נסיון חדש  ({{num}} מתוך {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'הוספת גורפת של רשימת מטרה לא הושלמה. {{num}} רשומות לא נוספו',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'הוספת גורפת של רשימת מטרה לא הושלמה. {{num}} רשומות לא נוספו',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} רשומות נוספו בהצלחה',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} הוספה גורפת לרשימת מטרה',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'מקשר {{num}} מתוך {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(נשאר כ {{time}} {{unit}} זמן)',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'קישור גורף נכשל. מתחיל נסיון חדש ({{num}} מתוך {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'קישור גורף לא הושלם. {{num}} רשומות לא נוספו',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'קישור גורף לא הושלם. {{num}} רשומות לא נוספו',
    'TPL_MASSLINK_SUCCESS' => '{{num}} רשומות קושרו בהצלחה',
    'TPL_MASSLINK_TITLE' => '{{module}} קישור גורף',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'בחר',
    'LBL_LISTVIEW_ACTIONS' => 'פעולות',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'בחר את כל הרשומות בדף זה',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'בטל את בחירת כל הרשומות בדף זה',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} של {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => 'טוען {{num}} מתוך...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'לחץ עבור סך הכל',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'מתוך',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'קבל את מספר הדפים',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'דוד',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'ישראלי',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'ד"ר',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'קוד קופיף יוצא מן הכלל',
    'LBL_LOGIN_TO_ACCESS' => 'כדי לגשת לאזור זה בצע כניסה למערכת.',
    'LBL_LOGOUT' => 'צא מהמערכת',
    'LBL_FINISH_IMPERSONATING' => 'סיום התחזות',
    'LBL_RESET_MFA' => 'איפוס אימות רב-גורמי',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, אתה במצב התחזות ל{{user}} כרגע.',
    'LBL_PROFILE' => 'פרופיל',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'מיזוג דואר',
    'LBL_MASS_UPDATE' => 'עדכון מאסיבי',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'בחר את כל הרשומות לביצוע עדכון גורף',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'כלול את הרשומה בעדכון גורף',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'הוסף שדה',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'הסר שדה',
    'LBL_GENERATE_QUOTE' => 'צור הצעת מחיר',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'אין שדות זמינים לביצוע עדכון גורף',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'בקשתך לעדכון גורף נקבעה',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'תאריך ההתחלה של השירות מאוחר יותר מתאריך הסיום',
    'LBL_MASS_UPDATE_SUCCESS' => 'כל הרשומות עודכנו בהצלחה',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'הרשומות שנבחרו נוספו לרשימת מטרה <a href="{{listUrl}}">{{listName}}</a>.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'בקשתך להוסיף רשומות שנבחרו לרשימת מטרה <a href="{{listUrl}}">{{listName}}</a> נקבעה.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'העדכון יסיר את הערכים הבאים',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'בטל לשמירה על הערכים הקיימים. אשר להסרת הערכים',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'כתובת דוא"ל שאליה לא מעוניין לקבל',
    'LBL_MEETINGS' => 'פגישות',
    'LBL_MEETING' => 'פגישה',
    'LBL_MEETING_GO_BACK' => 'לך חזרה לפגישה',
    'LBL_MEMBERS' => 'משתתפים',
    'LBL_MEMBER_OF' => 'חברים ב',
    'LBL_MODIFIED_BY_USER' => 'שונה על ידי משתמש',
    'LBL_MODIFIED_USER' => 'שונה על ידי משתמש',
    'LBL_MODIFIED' => 'שונה על ידי',
    'LBL_MODIFIED_NAME' => 'נערך על ידי',
    'LBL_MODIFIED_ID' => 'שונה על ידי Id',
    'LBL_MORE' => 'עוד',
    'LBL_MORE_MODULES' => 'מודולים נוספים',
    'LBL_MORE_TABS' => 'עוד לשוניות',
    'LBL_MULTIPLE_MODULES' => 'מודולים מרובים',
    'LBL_COUNT_MODULES' => '{{count}} מודולים',
    'LBL_MY_ACCOUNT' => 'ההגדרות שלי',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'ברירת מחדל מערכת',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'ברירת מחדל משתמש',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'חשבון משתמש',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'חשבון קבוצה',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'שם',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'צור',
    'LBL_NEW_BUTTON_TITLE' => 'צור',
    'LBL_NEXT_BUTTON_LABEL' => 'הבא',
    'LBL_NOTES' => 'הערות',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'פתח הכל',
    'LBL_OPENALL_BUTTON_TITLE' => 'פתח הכל [Alt+O]',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'פתח אל:',
    'LBL_OPENTO_BUTTON_TITLE' => 'פתח אל: [Alt+T]',
    'LBL_OPEN_IN_NEW_TAB' => 'פתח בלשונית חדשה',
    'LBL_OPPORTUNITIES' => 'הזדמנויות',
    'LBL_OPPORTUNITY_NAME' => 'שם ההזדמנות',
    'LBL_OPPORTUNITY' => 'הזדמנות',
    'LBL_OR' => 'או',
    'LBL_LOWER_OR' => 'או',
    'LBL_PANEL_ASSIGNMENT' => 'אחר',
    'LBL_PANEL_ADVANCED' => 'מידע נוסף',
    'LBL_PANEL_BODY' => 'סקירה כללית',
    'LBL_PARENT_TYPE' => 'סוג אב',
    'LBL_RELATED_TYPE' => 'סוג קשור',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'טווח',
    'LBL_PICTURE_FILE' => 'תמונה',
    'LBL_POSTAL_CODE' => 'מיקוד:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'כתובת עיר ראשית:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'כתובת מחוז ראשי:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'מיקוד ראשי:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'מדינה ראשית:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'רחוב ראשי 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'רחוב ראשי 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'כתובת רחוב ראשית:',
    'LBL_PRIMARY_ADDRESS' => 'כתובת ראשית:',

    'LBL_BILLING_STREET' => 'רחוב',
    'LBL_SHIPPING_STREET' => 'רחוב:',

    'LBL_PRODUCT_BUNDLES' => 'מארזי מוצרים',
    'LBL_PRODUCTS' => 'מוצרים',
    'LBL_PROJECT_TASKS' => 'משימות בפרויקט',
    'LBL_PRODUCT_TEMPLATES' => 'תבניות מוצר',
    'LBL_PROJECTS' => 'פרויקטים',
    'LBL_PROSPECTS' => 'מטרות',
    'LBL_QUICK_CREATE_MENU' => 'צור תפריט במהרה',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'צור הזדמנות מהצעת מחיר',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'צור הזמנות מהצעת מחיר [Alt+O]',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'יוצר הזדמנות...',
    'LBL_QUOTES_SHIP_TO' => 'Qהצעות מחיר נשלחו אל',
    'LBL_QUOTES' => 'הצעות מחיר',

    'LBL_FORECAST_WORKSHEETS' => 'גליונות תחזית',
    'LBL_FORECAST_WORKSHEET' => 'גיליון עבודה לתחזית',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'הזמן',
    'LBL_INVITED' => 'מוזמן',
    'LBL_RECOMMENDED_INVITES' => 'מוזמנים מומלצים',
    'LBL_INSTANCES' => 'מופעים',
    'LBL_YOUR_INSTANCES' => 'המופעים שלך',
    'LBL_INSTANCE_USERS' => 'מופעי משתמש',
    'LBL_SWITCH_INSTANCE' => 'החלף למופע זה',
    'LBL_LAST_LOGIN' => 'לוגין אחרון',
    'LBL_ENTER_EMAIL' => 'הכנס מייל של מוזמן...',
    'LBL_INSTANCE_IN_USE' => 'מופע בשימוש',
    'LBL_INSTANCE_ACTIVE' => 'אתה כבר משתמש במופע זה!',
    'LBL_INSTANCE_INVITE_SENT' => 'הזמנות נשלחו ל',
    'LBL_INSTANCE_SWITCH_FAILED' => 'החלפת מופע נכשלה',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'תזכורות',
    'LBL_REMINDERS_OVERDUE' => 'איחור',
    'LBL_REMINDERS_UPCOMING' => 'קרובים',
    'LBL_REMINDERS_NONE_FOUND' => 'לא נמצאו תזכורות',
    'LBL_REMINDERS_FINISHED' => 'הסתיים!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'מדדי הזדמנויות',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'לוח הגדרות של Sweet Spot',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'מקשים חמים',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'לא ניתן לעדכן העדפות תצורה: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'פעולה של Sweet Spot',
    'LBL_SWEETSPOT_KEY' => 'מילת מפתח',
    'LBL_SWEETSPOT_REMOVE' => 'הסר פעולה',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'מקשים חמים',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'פעולות',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'רשומות',
    'LBL_SWEETSPOT_THEME' => 'ערכת נושא',
    'LBL_SWEETSPOT_THEME_SELECT' => 'בחר ערכת נושא',

    'LBL_RELATED' => 'קשור אל',
    'LBL_RELATED_INFORMATION' => 'מידע שקשור אל',
    'LBL_RELATED_RECORDS' => '{{module}} קשור/ה',
    'LBL_REPORTS_TO' => 'מדווח אל',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'מצביע על שדה נדרש',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'בוצע',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'שמור כ',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'שמור כ [Alt+A]',
    'LBL_FULL_FORM_BUTTON_KEY' => 'F',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'טופס מלא',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'טופס מלא [Alt+F]',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'שמור וצור חדש',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'שמור וצור חדש [Alt+V]',
    'LBL_SAVE_OBJECT' => 'שמור {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'חיפוש',
    'LBL_SEARCH_BUTTON_TITLE' => 'חיפוש [Alt+Q]',
    'LBL_SEARCH' => 'חיפוש',
    'LBL_SEARCH_TIPS' => 'לחץ על כפתור החיפוש או לחץ על Enter כדי לקבל התאמה מדויקת עבורם.',
    'LBL_SEARCH_TIPS_2' => 'לחץ על כפתור החיפוש או לחץ על Enter כדי לקבל התאמה מדויקת עבור',
    'LBL_SEARCH_MORE' => 'עוד',
    'LBL_SEE_ALL' => 'ראה הכל',
    'LBL_SEARCH_LOAD_MORE' => 'טען עוד',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'קובץ לא חוקי, רק תמונות ניתנות להעלאה.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'פורמט תמונה {0} כבר לא נתמך',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'בחר',
    'LBL_SELECT_BUTTON_TITLE' => 'בחר [Alt+T]',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'הוסף צוות/ים',
    'LBL_SELECT_TEAMS_TITLE' => 'הוסף צוות/ים(s) [Alt+Z]',
    'LBL_SELECT_APPEND_TEAMS' => 'צרף קבוצות',
    'LBL_SELECT_APPEND_VALUES' => 'צרף ערכים',
    'LBL_SELECT_APPEND_TAGS' => 'צרף תיוג(ים)',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'דפדף במסמכים',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'דפדף במסמכים [Alt+B]',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'בחר איש קשר',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'בחר איש קשר [Alt+T]',
    'LBL_GRID_SELECTED_FILE' => 'תיקיות שנבחרו',
    'LBL_GRID_SELECTED_FILES' => 'תיקיות שנבחרו',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'בחר מדוחות',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'בחר דוחות',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'בחר משתמש',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'בחר משתמש [Alt+U]',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'נקה בחירה',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'נקה בחירה',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'נקה בחירה',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'נקה בחירה',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'בחר קובץ',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'בחר קובץ',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'נקה קובץ',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'נקה בחירה',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'בחר משתמש',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'בחר משתמש',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'נקה משתמש',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'נקה משתמש',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'בחר חשבון',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'בחר חשבון',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'נקה חשבון',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'נקה חשבון',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'בחר קמפיין',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'בחר קמפיין',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'נקה קמפיין',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'נקה קמפיין',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'בחר איש קשר',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'בחר איש קשר',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'נקה איש קשר',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'נקה איש קשר',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'בחר צוות',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'בחר צוות',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'נקה צוות',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'נקה צוות',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'משאבים שנעשה בהם שימוש לבניית עמוד זה (שאילתות, קבצים)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'שניות.',
    'LBL_SERVER_RESPONSE_TIME' => 'זמן תגובת השרת:',
    'LBL_SERVER_MEMORY_BYTES' => 'בתים',
    'LBL_SERVER_MEMORY_USAGE' => 'ניצולת זיכרון שרת: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'ניצולת: מודול: {0} - פעולה: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'ניצולת זיכרון שרת שיא: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'נשלח לחשבון',
    'LBL_SHIP_TO_CONTACT' => 'נשלח לאיש קשר',
    'LBL_SHIPPING_ADDRESS' => 'כתובת למשלוח',
    'LBL_SHORTCUTS' => 'קיצורי דרך',
    'LBL_SHOW' => 'הצג',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'מדינה:',
    'LBL_STATUS_UPDATED' => 'הסטאטוס שלך באירוע זה עודכן!',
    'LBL_STATUS_NOT_UPDATED' => 'הסטאטוס שלך עבור אירוע זה לא עודכן.',
    'LBL_STATUS' => 'מצב:',
    'LBL_STREET' => 'רחוב',
    'LBL_SUBJECT' => 'נושא',

    'LBL_INBOUNDEMAIL_ID' => 'דוא"ל נכנס ID',
    'LBL_EAMP_ID' => 'מזהה אסימון אימות',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'כל הזכויות שמורות.br />SugarCRM>‏, Sugar וקוביית ‎3-D הם סימנים מסחריים רשומים של .SugarCRM Inc.' .
        'כל יתר השמות של חברות ומוצרים הנמצאים בשימוש במוצר זה או מופיעים בו עשויים להיות סימנים מסחריים של ' .
        'החברות שאליהן הם משויכים.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'משימה מתוזמנת הסתיימה',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'המשרה שתוזמנה הורצה בהצלחה',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'שורות פרטי הכנסה מאופשרים כעת במופע השוגר שלך',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Revenue Line Items are now enabled in your Sugar instance, and all existing Opportunity data has been processed. Your instance is now ready to be used with Revenue Line Items. For more information about the changes which have been made, please refer to the {{doc_url}}.<br /><br />Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'מודול תחזית מוכן לשימוש כעת עם הזדמנויות במופע השוגר שלך',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'The Forecasts module in your Sugar instance is now available for use with opportunities. All previous Revenue Line Item forecast commit data has been removed, and the instance is ready for forecasts to be created and committed with opportunities. For more information about the changes which have been made, please refer to the {{doc_url}}.<br /><br />Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'שורות פרטי הכנסה אינן מאופשרות כעת במופע השוגר שלך',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Revenue line Items are now disabled in your Sugar instance, and all existing Revenue Line Item data has been processed. Your instance is now ready to be used with Opportunities. For more information about the changes which have been made, please refer to the {{doc_url}}.<br /><br />Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'תיעוד הגדרות הזדמנויות',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'כניסה למערכת',
    'LBL_LOGIN_WELCOME_TO' => 'ברוך הבא אל',
    'LBL_LOGIN_OPTIONS' => 'אפשרויות',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'שכחת את הסיסמא?',
    'LBL_LOGIN_SUBMIT' => 'שלח',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'יותר מידי ניסיונות כושלים להכנס למערכת.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'תוכל לנבות להכנס למערכת בתוך',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'ימים.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 'שעות.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'דקות.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'שניות.',
    'LBL_LOGIN_ADMIN_CALL' => 'אנא פנה למנהל המערכת.',
    'LBL_LOGIN_USERNAME' => 'שם משתמש',
    'LBL_LOGIN_PASSWORD' => 'סיסמה',
    'LBL_LOGGED_OUT' => 'יצאת מהמערכת',
    'LBL_LOGIN_FORM_LABEL' => 'הצג טופס לוגין',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'חזרה לכניסה',
    'LBL_LOGIN_INACTIVE_USER' => 'משתמש לא פעיל',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'הפורטל או המשתמש בקבוצה לא יכול להיכנס.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'דף בית',
    'LBL_SYNC' => 'סנכן',
    'LBL_TASKS' => 'משימות',
    'LBL_TEAMS_LINK' => 'קבוצות',
    'LBL_THEME_COLOR' => 'צבע',
    'LBL_THEME_FONT' => 'גופן',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'תזמן פגישה',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'תזמן פגישה',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'ארכב דוא"ל',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'ארכב דוא"ל [Alt+K]',
    'LBL_UNAUTH_ADMIN' => 'גישה לא מורשית לנהול המערכת',
    'LBL_UNDELETE_BUTTON_LABEL' => 'עודכן',
    'LBL_UNDELETE_BUTTON_TITLE' => 'עדכן [Alt+D]',
    'LBL_UNDELETE_BUTTON' => 'בטל מחיקה',
    'LBL_UNDELETE' => 'בטל מחיקה',
    'LBL_UNSYNC' => 'בטל סינכרון',
    'LBL_UPDATE' => 'עדכן',
    'LBL_UPDATES' => 'עדכונים',
    'LBL_USER_LIST' => 'רשימת משתמשים',
    'LBL_USER_MENU' => 'תפריט משתמש',
    'LBL_USERS_SYNC' => 'סנכרן משתמשים',
    'LBL_USERS' => 'משתמשים',
    'LBL_USER' => 'משתמש',
    'LBL_CURRENT_USER' => 'משתמש נוכחי',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'בודק דבר קיומה של כניסת דוא"ל...',
    'LBL_VERIFY_PORTAL_NAME' => 'בודק שם פורטל קיים...',
    'LBL_VIEW_IMAGE' => 'צפה',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'צפה כ PDF',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'הדפס כ PDF [Alt+P]',

    'LBL_KBDOCUMENTS' => 'מרכז מידע',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'אודות',
    'LNK_ADVANCED_SEARCH' => 'חיפוש מתקדם',
    'LNK_BASIC_SEARCH' => 'חיפוש בסיסי',
    'LNK_SEARCH_NO_RESULTS' => 'לא נמצאו תוצאות',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'צפה בכל התוצאות',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'הצג הכל',
    'LNK_CLOSE' => 'סגור',
    'LBL_MODIFY_CURRENT_SEARCH' => 'ערוך חיפוש זה',
    'LNK_SAVED_VIEWS' => 'אפשרויות תצורה',
    'LNK_DELETE_ALL' => 'מחק בכל',
    'LNK_DELETE' => 'מחק',
    'LNK_EDIT' => 'ערוך',
    'LNK_VIEW' => 'צפה',
    'LNK_GET_LATEST' => 'קבל את האחרונים',
    'LNK_GET_LATEST_TOOLTIP' => 'החלף עם הגירסה האחרונה',
    'LNK_HELP' => 'עזרה',
    'LNK_CREATE' => 'צור',
    'LNK_CREATE_WHEN_EMPTY' => 'צור רשומה חדשה כעת',
    'LNK_LIST_END' => 'סוף',
    'LNK_LIST_NEXT' => 'הבא',
    'LNK_LIST_PREVIOUS' => 'הקודם',
    'LNK_LIST_RETURN' => 'חזור לרשימה',
    'LNK_LIST_START' => 'התחל',
    'LNK_LOAD_SIGNED' => 'חתום',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'החלף במסמך חתום',
    'LNK_PRINT' => 'הדפס',
    'LNK_BACKTOTOP' => 'חזרה למהעלה',
    'LNK_REMOVE' => 'הסר',
    'LNK_RESUME' => 'המשך',
    'LNK_VIEW_CHANGE_LOG' => 'הצג יומן ביקורת',
    'TPL_AUDIT_LOG_TITLE' => 'יומן ביקורת עבור {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'לחץ כדי להציג יומן סקירה של כתובות דוא"ל',
    'LBL_NO_SEARCH_RESULTS' => 'לא נמצאו תוצאות עבור החיפוש שלך',
    'NTC_CLICK_BACK' => 'הקש על כפתור אחורה בדפדפן על מנת לתקן שגיאה זו.',
    'NTC_DATE_FORMAT' => '(yyyy-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(yyyy-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'אתה בטוח שברצונך למחוק רשומה או רשומות ?',
    'NTC_TEMPLATE_IS_USED' => 'התבנית הז בשימוש של לפחות תבנית דוא"ל אחת או רשומת מערכת. אתה בטוח שברצונך למחוק אותה?',
    'NTC_TEMPLATES_IS_USED' => "התבניות הבאות נמצאות בשימוש של תבניות דואר שיווקי או במקומות אחרים במערכת. אתה בטוח שברצונך למחוק אותן",
    'NTC_DELETE_CONFIRMATION' => 'אתה בטוח בשברצונך למחוק רשומה זו?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'אתה בטוח שברצונך למחוק את {0}?',
    'LBL_METRIC_DELETE_WARNING' => 'בנוסף, כל המשתמשים שכרטיסיית מדד זה שותפה עמם יאבדו את הגישה.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'אתה בטוח שברצונך למחוק את',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'אתה בטוח שברצונך לע',
    'NTC_DELETE_SELECTED_RECORDS' => 'רשומה או רשומות שנבחרו?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'פילטר זה יוסר מכל המסכים. האם אתה בטוח שברצונך להסירו?',
    'TPL_DELETE_FILTER_SUCCESS' => 'מחקת את הפילטר  {{name}}.',
    'NTC_DELETE_SUCCESS' => 'מחקת את ה {0}',
    'NTC_UNLINK_CONFIRMATION' => 'אתה בטוח שברצונך לבטל את הקישור של הרשומה הזו?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'אתה בטוח שברצונך לבטל את ה {0}?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'בטוח שברצונך לבטל את הקישור של {0}? פעולה זו תגרום גם להסרתם מהשדה &#39;איש קשר ראשי&#39; של האירוע.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => 'לא ניתן לבטל את הקישור של {0} מאחר שהם מוגדרים כאיש הקשר הראשי של אירוע זה. עדכן את השדה &#39;איש קשר ראשי&#39; לפני ביטול הקישור של רשומה זו.',
    'NTC_UNLINK_SUCCESS' => 'ביטלת את קישור ה {0}',
    'NTC_LOGIN_MESSAGE' => 'אנא הכנס את שם המשתמש והסיסמא שלך.',
    'NTC_NO_ITEMS_DISPLAY' => 'אין',
    'NTC_REMOVE_CONFIRMATION' => 'אתה בטוח שברצונך לביר קשרים אלה? רק הקשרים עצמם יוסרו. הרשומות שנוצרו לא יוסרו.',
    'NTC_REQUIRED' => 'מצביע על שדה חובה',
    'NTC_SUPPORT_SUGARCRM' => 'Support the SugarCRM open source project with a donation through PayPal - it&#39;s fast, free and secure!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'ברוך הבא',
    'NTC_YEAR_FORMAT' => '(yyyy)',
    'LOGIN_LOGO_ERROR' => 'החזר בבקשה את הלוגו של SugarCRM.',
    'FATAL_LICENSE_ALTERED' => 'הרשיון שלך שונה מאז הפעם האחרונה שתוקפו חודש',
    'ERROR_FULLY_EXPIRED' => "רישיונות הגישה שלך למערכת פג תוקפן לפני שלושים יום. רק מנהל המערכת יכול להכנס.",
    'ERROR_LICENSE_EXPIRED' => "רישיון הגישה למערכת צריך עדכון. רק מנהל המערכת יכול להכנס",
    'WARN_LICENSE_EXPIRED' => "הרשיון של החברה שלך לשוגר יפוג בקרוב",
    'ERROR_LICENSE_VALIDATION' => "יש צורך לאשרר את רישיונות הגישה שלך למערכת. רק מנהל המערכת יכול להכנס",
    'WARN_LICENSE_VALIDATION' => "יש לחדש את הרשיון של החברה שלך לשוגר בקרוב",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>אזהרה:</b> הדפדפן שלך במצב IE compatibility view שאינו נתמך',
    'WARN_LICENSE_SEATS' => 'אזהרה: מספר המתמשים הפעילים עבר את מספר הרישיונות שבבעלותכם.',
    'WARN_LICENSE_SEATS_MAXED' => 'אזהרה: מספר המשתמשים הפעילים עבר את מספר רישיונות הגישה שבידכם.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'מספר המשתמשים הפעילים חורג ממגבלות &#39;ספירת הרישיונות&#39;. אנא צור קשר עם מנהל המערכת שלך.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'רק מנהלי המערכת יוכלו להתחבר.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'המערכת הגיעה למגבלת &#39;ספירת רישיונות המשתמש&#39;. רק משתמשים קיימים יוכלו להתחבר.',
    'WARN_ONLY_ADMINS' => 'רק מנהלי המערכת יוכלו להתחבר.',
    'WARN_UNSAVED_CHANGES' => 'אתה מתכוון לעזוב את הרשומה הזו מבלי לשמור שינויים שערכת בה. אתה בטוח שברצונך לנווט הלאה מרשומה זו?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'רענון הדפדפן יסגור אוטומטית את כל הפעלות השיחה או הצ&#39;אט ב-SugarLive הפתוחות אצלך. שינויים שלא נשמרו יאבדו. האם ברצונך להמשיך?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'יש לך שינויים שלא נשמרו. האם אתה בטוח שברצונך לעזוב דף זה?',
    'LBL_MFA_RESET_CONFIRMATION' => 'בטוח שברצונך לאפס את <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">האימות הרב-גורמי</a> שלך? 
פעולה זו תגרום לניתוק מיידי שלך מהמערכת ויהיה עליך לבצע אימות באמצעות אפליקציית האימות בפעם הבאה שתיכנס.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'אישור ויציאה',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'תאסופית אחת או יותר כוללת שינויים שלא נשמרו. האם אתה בטוח שברצונך לסגור את הצייר?',
    'LBL_NAVIGATE_TO_REPORTS' => 'אתה עובר למודול דוחות. השינויים שביצעת לא יישמרו. האם להמשיך?',
    'ERROR_NO_RECORD' => 'שגיאה באיחזור הרשומה.  יתכן והרשומה נמחקה או שאינך מורשה לצפות בה.',
    'ERROR_TYPE_NOT_VALID' => 'שגיאה. סוג זה איננו חוקי.',
    'ERROR_MAX_FIELD_LENGTH' => 'שגיאה. אורך מקסימלי של שדה זה הוא  {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'שגיאה. אורך מינימלי של שדה זה הוא  {{this}}.',
    'ERROR_EMAIL' => 'שגיאה. מייל לא תקין: {{#each this}}{{{this}}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'שגיאה. יש למלא לפחות מייל עיקרי אחד',
    'ERROR_DUPLICATE_EMAIL' => 'שגיאה. כפילות במייל:  {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'שגיאה. שדה זה הוא חובה',
    'ERROR_MINVALUE' => 'שגיאה. ערך מינימלי של שדה זה הוא  {{this}}.',
    'ERROR_MAXVALUE' => 'שגיאה. ערך מקסימלי של שדה זה הוא  {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'שגיאה. ערך שדה זה צריך להיות יותר מ {{this}}.',
    'ERROR_IS_LESS_THAN' => 'שגיאה. ערך שדה זה צריך להיות פחות מ {{this}}.',
    'ERROR_DATETIME' => 'שגיאה. שדה זה דורש נתון תקין',
    'ERROR_IS_BEFORE' => 'שגיאה. התאריך בשדה זה אינו יכול להיות מאוחר מהתאריך בשדה {{this}}',
    'ERROR_IS_AFTER' => 'שגיאה. התאריך בשדה זה אינו יכול להיות לפני התאריך בשדה {{this}}',
    'ERROR_TIME_IS_BEFORE' => 'שגיאה. השעה בשדה זה אינה יכולה להיות מאוחרת מהשעה שבשדה {{this}}.',
    'ERROR_TIME_IS_AFTER' => 'שגיאה. השעה בשדה זה חייבת להיות מאוחרת מהשעה שבשדה {{this}}.',
    'ERROR_NUMBER' => 'שגיאה. שדה זה דורש מספר תקין',
    'ERROR_INT' => 'שגיאה: מספר שלם לא חוקי.',
    'ERROR_URL' => 'שגיאה. כתובת URL שגויה.',
    'ERROR_NO_BEAN' => 'לא ניתן להשיג bean.',
    'ERROR_ACCESS_MODULE' => 'אין לך הרשאה למודול זה',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'שגיאה. הקובץ המצורף גדול מדי.',
    'ERROR_UPLOAD_FAILED' => 'שגיאה בהעלאת הקובץ',
    'ERROR_UPLOAD_ACCESS_PD' => 'אין לך הרשאה ליצור [הגדרות תהליך] עבור מודול זה.',
    'ERROR_UPLOAD_ACCESS_BR' => 'אין לך הרשאה ליצור [כללי עסק] עבור מודול זה.',
    'ERROR_UPLOAD_ACCESS_ET' => 'אין לך הרשאה ליצור [תבניות דוא"ל] עבור מודול זה.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'שגיאה. הזנת אופרטור לא נתמך.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'שגיאה. הזנת אופרטור לא חוקי.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'שגיאה. הזנת מסנן לא חוקי.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'הייבוא נכשל. שדה קבוצה ננעל חלקית בהגדרת התהליך.' .
        ' יש לפתוח שדות אלה בהגדרת התהליך כדי לייבא את ההגדרה.',
    'ERROR_EXP_DATE_LOW' => 'שגיאה. תאריך פקיעת התוקף אינו יכול להיות לפני תאריך הפרסום.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'שגיאה. המצב מאושר דורש תאריך פרסום.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'תאריך הפרסום ריק.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'מצא משוכפלים',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'בדיקת כפילויות לא תהיה זמינה עבור {{module}}.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'נהל מנויים',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'נהל מנויים עבור',
    'LBL_SUBSCRIBE' => 'הרשם',
    'LBL_UNSUBSCRIBE' => 'בטל הרשמה',
    'LBL_CREATE_LINK_RECORD' => 'צור וקשר רשומה',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'צור וקשר רשומה',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} רשומות קושרו',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'אין רשומות לקשר',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'הדוח שנבחר אינו מבוסס על סוג מודול נכון',
    'ERROR_EMPTY_LINK_MODULE' => 'תחילה יש לבחור סוג קשר',
    // Ajax status strings
    'LBL_LOADING' => 'טוען...',
    'LBL_LOADING_NO_DOTS' => 'טוען ...',
    'LBL_SEARCHING' => 'מחפש...',
    'LBL_SEARCH_UNDERWAY' => 'מחפש',
    'LBL_SAVING_LAYOUT' => 'שומר מערך ...',
    'LBL_SAVED_LAYOUT' => 'המערך נשמר בהצלחה.',
    'LBL_SAVED' => 'נשמר',
    'LBL_SAVING' => 'שומר',
    'LBL_FAILED' => 'נכשל!',
    'LBL_DISPLAY_COLUMNS' => 'הצג עמודות',
    'LBL_HIDE_COLUMNS' => 'הסתר עמודות',
    'LBL_SEARCH_CRITERIA' => 'קריטריון חיפוש',
    'LBL_SAVED_VIEWS' => 'צפיות שנשמרו',
    'LBL_PROCESSING_REQUEST' => 'מעבד..',
    'LBL_REQUEST_PROCESSED' => 'בוצע',
    'LBL_AJAX_FAILURE' => 'Ajax נכשל',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'מחפש...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'חיפושים שנשמרו',
    'LBL_SEARCH_POPULATE_ONLY' => 'בצע חיפוש תוך כדי שימוש בטופס החיפוש הרשום מעלה',
    'LBL_SEARCH_NO_RESULTS' => 'לא נמצאו תוצאות עבוד',
    'LBL_SEARCH_FOR' => 'חפש',
    'LBL_SEARCH_FOR_MORE' => 'חפש עוד...',
    'LBL_SEARCH_SELECT' => 'בחר...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'חפש ובחר...',
    'LBL_SEARCH_SELECT_MODULE' => 'בחר {{module}}...',
    'LBL_DETAILVIEW' => 'צפה בפרטים',
    'LBL_LISTVIEW' => 'צפה כרשימה',
    'LBL_EDITVIEW' => 'ערוך צפייה',
    'LBL_SEARCHFORM' => 'טופס חיפוש',
    'LBL_SAVED_SEARCH_ERROR' => 'ספק שם לצפייה הזו.',
    'LBL_DISPLAY_LOG' => 'הצג לוג',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'מיקום:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'תיאור:',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'מתחיל',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'קליק OK לראות את ההודעה או קליק על בטל כדי להעלים אותה.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'קליק OK לראות את הישיבה הזו או הקש על בטל להעלים הודעה זו.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'לא מצאו תוצאות',
    'MSG_LIST_VIEW_NO_RESULTS' => 'לא נמצאו תוצאות עבור',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'צור כחדש',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'אין לך רשומות שמורות. <item2> או <item3> כעת.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'אין לך רשומות שמורות.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'באופרותך ליצור מרשימת a',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'חיובי',
    'LBL_SENTIMENT_NEUTRAL' => 'נייטרלי',
    'LBL_SENTIMENT_NEGATIVE' => 'שלילי',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'לא הוגדרו כרטיסיות מדד',
    'LBL_NO_METRIC_VISIBLE' => 'אין כרטיסיות מדדים גלויות',
    'LBL_MAKE_METRIC_VISIBLE' => 'בחר באפשרות "ארגון" כדי להציג כרטיסיות מדדים',
    'LBL_PLEASE_CONTACT_ADMIN' => 'נא לפנות למנהל המערכת',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'הקלק פה',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'הוסף למועדפים שלי',
    'LBL_MARK_AS_FAVORITES' => 'סמן כמועדף על ידי',
    'LBL_CREATE_CONTACT' => 'צור איש קשר',
    'LBL_CREATE_NOTE' => 'צור פתק',
    'LBL_CREATE_OPPORTUNITY' => 'צור הזדמנות',
    'LBL_SCHEDULE_CALL' => 'צור שיחת טלפון',
    'LBL_SCHEDULE_CALL2' => 'שיחת טלפון',
    'LBL_SCHEDULE_MEETING' => 'תזמן פגישה',
    'LBL_SCHEDULE_MEETING2' => 'פגישה',
    'LBL_CREATE_MESSAGE' => 'צור הודעה',
    'LBL_CREATE_MESSAGE2' => 'הודעה',
    'LBL_CREATE_TASK' => 'צור משימה',
    'LBL_CREATE_TASK2' => 'משימה',
    'LBL_REMOVE_FROM_FAVORITES' => 'הסר מהמועדפים שלי',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'הערה',
    'LBL_DOWNLOAD_ALL' => 'הורד הכל',
    'LBL_DOWNLOAD_ONE' => 'הורד',
    'LBL_ATTACHMENTS' => 'קבצים מצורפים',
    'LBL_ADD_ATTACHMENT' => 'עיון',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'צור טופס',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'שמור טופס לידים מאתר האינטרנט',

    'LBL_PLEASE_SELECT' => 'אנא בחר',
    'LBL_REDIRECT_URL' => 'כיוון מחדש URL',
    'LBL_RELATED_CAMPAIGN' => 'קמפיינים קשורים',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'הוסף את כל השדות',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'הסר את כל השדות',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'ניתן להכיל רק קבצים מסוג תמונה',
    'LBL_REMOVE' => 'הסר',
    'LBL_TRAINING' => 'תמיכה',
    'ERR_DATABASE_CONN_DROPPED' => 'שגיאה בהרצת שאילתא. יתכן, ומסד הנתונים שלך צחק את הקשר. אנא רענן את הדף, יתכן ועליך להפעיל את שרת האינטרנט שלך.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'שגיאה בהגדרת {0} יחס: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'שנה הקשר במסד הנתונים ל',
    'ERR_MSSQL_WARNING' => 'אזהרה:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'נכשל בניתוח פורמט vCard',
    'ERR_VCARD_FILE_MISSING' => 'קובץ vcf חסר',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'אזהרה: לשדה [[field]] אין רשומה ממופית בקובץ [moduleDir] vardefs.php',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'שגיאה: הקובץ [[file]] חסר. לא ניתן ליצור מכיוון שלא נמצא קובץ HTML תואם.',
    'ERR_CANNOT_FIND_MODULE' => 'שגיאה: מודול [module] לא קיים.',
    'LBL_ALT_ADDRESS' => 'Other Address:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Error: There are an unequal number of arguments for the &#39;key&#39; and &#39;copy&#39; elements in the displayParams array.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Missing index in displayParams Array for:',

    'LBL_DASHLET' => 'דשלט',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'מסננים',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'רק הפריטים שלי',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'כותרת',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'הצג שורות',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'קשור לרשומה הנוכחית',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'קישור נכשל',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'הקפאת עמודה ראשונה',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'אתה בטוח שברצונך להסיר תאסופה?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'אתה בטוח שברצונך למחוק שורה זו?',
    'LBL_MAXIMUM_OF' => 'מקסלימלי',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => 'ניתן להציג עמודות',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'לוח מחוונים',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'לוח המחוונים שלי',
    'LBL_COLLAPSE_ALL' => 'סגור הכל',
    'LBL_EXPAND_ALL' => 'הרחב הכל',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'ערוך',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'הצג דוח',
    'LBL_DASHLET_REFRESH_LABEL' => 'רענן',
    'LBL_DASHLET_REMOVE_LABEL' => 'הסר',
    'LBL_DASHLET_DROP_HERE' => 'הורד כאן',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'סגור',
    'LBL_DASHLET_MAXIMIZE' => 'פתח',
    'LBL_DASHLET_CONFIGURE' => 'הגדר',
    'LBL_DASHLET_TOGGLE' => 'פתח/סגור',
    'LBL_SIDEPANE_TOGGLE' => 'פתח/סגור חלון צדדי',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'שחזור חלוניות ברירת המחדל',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'אין לוח מחוונים מוגדר',
    'LBL_CREATE_DASHBOARD_LINK' => 'צור לוח מחוונים',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'עזרה',
    'LBL_HELPLET_TOGGLE' => 'פתח/סגור',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'מודולים',
    'LBL_FACET_MODIFIED_BY_ME' => 'נערך על ידי',
    'LBL_FACET_CREATED_BY_ME' => 'נוצר על ידי',
    'LBL_FACET_MY_FAVORITES' => 'המועדפים שלי',
    'LBL_FACET_ASSIGNED_TO_ME' => 'הוקצה אליי',
    'LBL_FACET_NO_DATA' => 'אין נתונים עבור היבט זה.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'צפה כרשימה',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'רשימות של רשומות ממודול מסויים לפי קריטריון שאתה מגדיר',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'תצוגת רשימת מסופים',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'פירוט הרשומות ממודול ספציפי שקשורות לרשומה שבה אתה צופה במסוף.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'תצוגת רשומה',
    'LBL_RELATED_RECORDS' => '{{module}} קשור/ה',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'מציג רשומה ורשומות קשורות אופציונליות בלשוניות.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'סוג רשומת בסיס',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => '{{moduleSingular}} זה',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'לשוניות',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'תצוגה מקדימה של מערך בסיסי',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'אזהרה, ניתן להציג עד {{numWord}} ({{num}}) מודולים בלשוניות. ' .
        'יש להסיר מודול אחד או יותר לפני הוספה של כל מודול אחר.',
    'LBL_SIX' => 'שש', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'יומן הערות',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'מציג הערות עבור רשומה',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'אין הערות זמינות',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'הוסף',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'הוסף הערה',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'הצג הכול',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'הנתונים לא זמינים. אין לך הרשאת גישה למודולים אלה.' .
    " \nנא לעדכן או להסיר חלונית זו.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => '{{module}} שלי',
    'LBL_DASHLET_PICK_A_RECORD' => 'לא נבחרו רשומות לתצוגה',
    'LBL_CONTENT_SEARCH_DASHLET' => 'תאסופית לחיפוש תוכן',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'איך אפשר לעזור לך, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'האם ברצונך ליצור אירוע?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'מדדי הזדמנויות',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'מדדי הזדמנות עבור החשבון הקשור.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'בחירה מהירה מקטלוג המוצרים',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'פירוט הפריטים שהיו בשימוש לאחרונה ומוצרים שנשמרו כמועדפים',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'היו בשימוש לאחרונה',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'מועדפים',

    'LBL_DASHBOARD_CREATE' => 'צור לוח מחוונים',
    'LBL_DASHBOARD_DUPLICATE' => 'שכפל לוח מחוונים',
    'LBL_DASHBOARD_DELETE' => 'מחק לוח מחוונים',
    'LBL_PIN_TO_TOP' => 'הצמד לחלק העליון',
    'LBL_PIN_TO_BOTTOM' => 'הצמד לחלק התחתון',
    'LBL_MANAGE_DASHBOARDS' => 'ניהול לוחות מחוונים',

    'LBL_DASHBOARD_CONFIG' => 'תצורת לוח מחוונים',
    'LBL_LIST_VIEW__NAME' => 'תצוגת רשימה',
    'LBL_PIPELINE_VIEW_NAME' => 'תצוגת אריחים',
    'LBL_PIPELINE_VIEW_BTN' => 'תצוגת אריחים',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} לפי {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'תצוגת אריחים לא פעילה',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'לא נמצאו רשומות',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'סיכום פניית שירות',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'ציר זמן',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'הודעות וצרופות',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'הודעות וצרופות השייכות לרשומה',
    'LBL_DASHLET_PIPLINE_NAME' => 'צינור',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'טוויטים אחרונים - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'אין לוחות מחוונים שנשמרו',

    'LBL_DNB_AND' => 'וגם',
    'LBL_DNB_PRIM_NAME_DESC' => 'שומר טקסט שם הארגון',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'השב [Alt+R]',
    'LBL_TWITTER_RETWEET' => 'צייץ שוב',
    'LBL_TWITTER_FAVORITE' => 'מועדפים',
    'LBL_TWITTER_FOLLOW' => 'עקוב',
    'LBL_TWITTER_DESCRIPTION' => 'ראה קורות חיים של מתמשי טוייטר מתאימים, שלח ציוצים והגב לציוצים',
    'LBL_TWITTER_ID' => 'ID טוויטר',
    'LBL_TWITTER_DISPLAY_ROWS' => 'הצג שורות',
    'LBL_TWITTER_MY_ACCOUNT' => 'החשבון שלי',
    'LBL_TWITTER_NAME' => 'טוויטר',
    'LBL_TWITTER_SOURCE' => 'מקור טוויט',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'מקורות לימוד',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'הכשרה והסמכה',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'קהילת SugarClub',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'תיעוד ותמיכה',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'חנות SugarOutfitters',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'מכירות לפי מדינה',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'מציג תרשים מכירות לפי מפת איזורים',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'קטגוריות בבסיס הידע & מאמרים שפורסמו',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'חיפוש במרכז המידע',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'תצוגת העץ שבו ניתן לחפש קטגוריות ומאמרים שפורסמו ממרכז מידע.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'מאמרים שפורסמו בשפות אחרות',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'מאמרי בסיס הידע המפורסמים המועילים ביותר',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'מציג את המאמרים הנצפים ביותר ואת אלה שקיבלו את המספר הגבוה ביותר של סימוני &#39;אהבתי&#39; במאגר הידע',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} סונן על ידי {{label}} {{value}}',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'שימושיות עבור מאמרים',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'הוסף עמוד',
    'LBL_LOADING_PAGE' => 'טוען עמוד, אנא המתן...',
    'LBL_SEARCH_RESULTS' => 'תוצאות החיפוש',
    'LBL_SEARCH_RESULTS_FOR' => 'תוצאות חיפוש עבור: ',
    'LBL_SEARCH_HELP_TITLE' => 'טיפים לחיפוש - באנגלית',
    'LBL_SEARCH_RESULTS_FOUND' => 'נמצאו תוצאות חיפוש',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'הצינור שלי',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "הצינור של הצוות שלי",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'תרשים צינור מכירות',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'מציג את תרשים הצינור הנוכחי.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'אין תמונות',

    'LBL_MODULE' => 'מודול',
    'LBL_RELATIONSHIP' => 'מערכת יחסים',
    'LBL_SINGULAR_LABEL' => 'תווית יחיד',
    'LBL_PLURAL_LABEL' => 'תווית רבים',
    'LBL_MODULE_DISPLAY' => 'תצוגה',
    'LBL_MODULE_DISPLAY_TYPE' => 'סוג תצוגה',
    'LBL_MODULE_ICON' => 'סמל',
    'LBL_MODULE_COLOR' => 'צבע רקע של מודול',
    'LBL_LANGUAGE_SELECTOR' => 'שפה',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'הגדרות מודול',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'הגדרות המודול נשמרו.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'העתק כתובת משמאל:',
    'LBL_SAVE_AND_CONTINUE' => 'שמור והמשך',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Multiselect controls</strong></p><ul><li>Click on the values to select an attribute.</li><li>Ctrl-click&nbsp;to&nbsp;select multiple. Mac users use CMD-click.</li><li>To select all values between two attributes,&nbsp; click first value&nbsp;and then shift-click last value.</li></ul><p><strong>Advanced Search & Layout Options</strong><br><br>Using the <b>Saved Search & Layout</b> option, you can save a set of search parameters and/or a custom List View layout in order to quickly obtain the desired search results in the future. You can save an unlimited number of custom searches and layouts. All saved searches appear by name in the Saved Searches list, with the last loaded saved search appearing at the top of the list.<br><br>To customize the List View layout, use the Hide Columns and Display Columns boxes to select which fields to display in the search results. For example, you can view or hide details such as the record name, and assigned user, and assigned team in the search results. To add a column to List View, select the field from the Hide Columns list and use the left arrow to move it to the Display Columns list. To remove a column from List View, select it from the Display Columns list and use the right arrow to move it to the Hide Columns list.<br><br>If you save layout settings, you will be able to load them at any time to view the search results in the custom layout.<br><br>To save and update a search and/or layout:<ol><li>Enter a name for the search results in the <b>Save this search as</b> field and click <b>Save</b>.The name now displays in the Saved Searches list adjacent to the <b>Clear</b> button.</li><li>To view a saved search, select it from the Saved Searches list. The search results are displayed in the List View.</li><li>To update the properties of a saved search, select the saved search from the list, enter the new search criteria and/or layout options in the Advanced Search area, and click <b>Update</b> next to <b>Modify Current Search</b>.</li><li>To delete a saved search, select it in the Saved Searches list, click <b>Delete</b> next to <b>Modify Current Search</b>, and then click <b>OK</b> to confirm the deletion.</li></ol><p><strong>Tips</strong><br><br>By using the % as a wildcard operator you can make your search more broad.  For example insead of just searching for results that equal "Apples" you could change your search to "Apples%" which would match all results that start with the word Apples but could contain other characters as well.</p>',

    //resource management
    'ERR_QUERY_LIMIT' => 'שגיאה: המערכת הגיעה להגבלת שאילתא $limit עבור מודול $module.',
    'ERROR_NOTIFY_OVERRIDE' => 'שגיאה: יש להחליף את ResourceObserver->notify().',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'שגיאה: לא יכול ליצר מוניטור כי קובץ מטה דטה ריק או לא קיים.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'שגיאה: לא קונפג מוניטור לשם הנדרש',
    'ERR_UNDEFINED_METRIC' => 'שגיאה: לא יכול ליצר ערך למידה שאיננה מוגדרת',
    'ERR_STORE_FILE_MISSING' => 'שגיאה: לא מצליח למצוא קובץ שאליו ניתן לישם את התוכנית',

    'LBL_MONITOR_ID' => 'מוניטור Id',
    'LBL_TEAM_ID' => 'צוות id',
    'LBL_SELECT_MODULE' => 'בחר מודול:',
    'LBL_USER_ID' => 'משתמש Id',
    'LBL_MODULE_NAME' => 'שם המודול',
    'LBL_MODULE_ALL' => 'הכל',
    'LBL_ITEM_ID' => 'צוות Id',
    'LBL_ITEM_SUMMARY' => 'תקציר פריט',
    'LBL_ACTION' => 'פעולה',
    'LBL_SESSION_ID' => 'פגישה Id',
    'LBL_BREADCRUMBSTACK_CREATED' => 'BreadCrumbStack נוצר עבור מזהה משתמש {0}',
    'LBL_VISIBLE' => 'רשומה ניראית',
    'LBL_DATE_LAST_ACTION' => 'תאריך פעולה אחרונה',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL אקטסט',
    'LBL_QUERY_HASH' => 'SQL Hash',
    'LBL_SEC_TOTAL' => 'סך הכל שניות',
    'LBL_SEC_AVG' => 'שניות בממוצע',
    'LBL_RUN_COUNT' => 'מונה שאילתא',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'כתובת אי.פי של הלקוח',
    'LBL_DATE_START' => 'תאריך התחלה',
    'LBL_ACTIVE' => 'פעילות קיימת',
    'LBL_ROUNDTRIPS' => 'ספירת פעילות',
    'LBL_SECONDS' => 'פעילות בשניות',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'קישור הלך ושוב למסד הנתונים',
    'LBL_FILES_OPENED' => 'קבצים שנגשו אליהם',
    'LBL_MEMORY_USAGE' => 'שימוש בזיכרון (bytes)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'מעלה קונקטור לטוויטר...',
    'LBL_TWITTER_DATA_EMPTY' => 'לא נמצא מידע מטוויטר',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'פלגאין של שוגר לאוטלוק',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'אחד דוא"ל ולוח שנה של שוגר עם דוא"ל ולוח שנה של אווטלוק.',
    'LBL_PLUGIN_WORD_NAME' => 'פלגאין לוורד',
    'LBL_PLUGIN_WORD_DESC' => 'הפץ אוטומטית מידע משוגר למכתבים בתוך וורד, הנחה דואר ושאר פרטים מאוטלוק.',
    'LBL_PLUGIN_EXCEL_NAME' => 'פלגאין לאקסל',
    'LBL_PLUGIN_EXCEL_DESC' => 'מזג שוגר לגליון אלקטרוני לשם ניתוח יעיל יותר של מידע.',
    'LBL_PLUGINS_TITLE' => 'פלגאין לאופיס של מיקרוסופט<sup>TM</sup>',
    'LBL_PLUGINS_DESC' => 'קרא אודות התכונות של הפלגאינים למיקרוסופט בקישור <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">תיעוד פלגאינים של מיקרוסופט</a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'תוספי Sugar עבור Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'תוסף Sugar עבור Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'שלב את Sugar עם Lotus Notes.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'לא לפני',
    'MSG_IS_MORE_THAN' => 'יותר',
    'MSG_IS_LESS_THAN' => 'פחות',
    'MSG_SHOULD_BE' => 'צריך להיות',
    'MSG_OR_GREATER' => 'או גדול מ',
    'MSG_EXCEEDS_MAXLEN' => 'חורג מהאורך המרבי המצוין ',

    'LBL_PORTAL_WELCOME_TITLE' => 'ברוך הבא לפורטל',
    'LBL_PORTAL_WELCOME_INFO' => 'שער Sugar היא מסגרת שמעלה תצוגה בזמן אמת של מקרים, באגים וניוזלטרים וכו&#39; ללקוחות. זה ממשק חיצוני ל-Sugar שניתן לפרוש אותו בתוך כל אתר. צפה לתכונות נוספות של שירות לקוחות כמו ניהול פרויקטים ופורומים בשחרורים הבאים שלנו.',
    'LBL_LIST' => 'רשימה',
    'LBL_CREATE_CASE' => 'צור אירוע',
    'LBL_CREATE_BUG' => 'צור באג',
    'LBL_NO_RECORDS_FOUND' => '- 0 רשומות נמצאו -',

    'DATA_TYPE_DUE' => 'עד:',
    'DATA_TYPE_START' => 'התחל:',
    'DATA_TYPE_SENT' => 'שלח:',
    'DATA_TYPE_MODIFIED' => 'שנה:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'ספור',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'אוביקט תמונה',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'בחר תאריך',

    'LBL_VALIDATE_RANGE' => 'איננו בטווח החוקי',
    'LBL_VALIDATE_URL' => 'איננה כתובת URL חוקית',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'הכל',

    'LBL_OPERATOR_IN_TEXT' => 'הוא אחד מהבאים:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'אינו אחד מהבאים:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'שגיאה: ספירת Array של הפרמטר bean לא תואמת לספירת Array של התוצאות.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'שגיאה: חסרה רשומת מיפוי עבור המודול.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'שגיאה: לא ניתן לאחזר נתונים עבור מחבר {0}. ייתכן והשירות לא נגיש כרגע או שהגדרות התצורה לא חוקיות. הודעת שגיאה למחבר: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'לא ניתן לאחזר נתונים. יתכן שהשירות אינו זמין או שההגדרות לא תקינות',
    'LBL_CONNECT_TWITTER' => 'התחבר לטוייור',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'לא ניתן למצוא ציר שמן לטוויטר ID',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'הגדר מחבר טוויטר',
    'LBL_CONNECT_TEST_FAIL' => 'שגיאה: יתכן שהגדרות המחבר לא תקינות. אנא פנה למנהל',
    'LBL_CONFIGURE_TWITTER' => 'מנה למנהל להגדרת טוויטר',
    'LBL_MERGE_CONNECTORS' => 'השג נתונים',
    'LBL_NO_DATA_AVAILABLE' => 'אין נתונים זמינים',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'האם אתה בטוח שברצונך להשבית את הטמעת המחבר במודול זה?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'החיבור לשרת האלסטי נכשל',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'לא ניתן למחוק צוות גלובלי.',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'צוות פרטי זה [{0}] לא ניתן למחיקה עד שמשתמש [{1}] ימחק.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'או שהשימוש בפלש של אדובי סגור או שאתה משתמש בגרסה ישנה שלו. כדי להשיג את הגרסה האחרונה של נגן הפלאש, <a href="http://www.adobe.com/go/getflashplayer/">הקש פה</a>.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'שם',
    'LBL_COLLECTION_PRIMARY' => 'ראשי',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'רוקן שדה נדרש',
    'LBL_COLLECTION_EXACT' => 'בדיוק',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'לחוויה אופטימלית באמצעות sapi IIS/FastCGI, הגדר fastcgi.logging ל0 בקובץ ה-php.ini שלך.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'הוקצה עבור',
    'LBL_DESCRIPTION' => 'תיאור',
    'LBL_PRIMARY_CONTACT_NAME' => 'איש קשר ראשי',
    'LBL_PRIMARY_CONTACT_ID' => 'מזהה איש קשר ראשי',

    'LBL_NONE' => '-כלום-',
    'LBL_YESTERDAY' => 'אתמול',
    'LBL_TODAY' => 'היום',
    'LBL_TOMORROW' => 'מחר',
    'LBL_NEXT_WEEK' => 'בשבוע הבא',
    'LBL_NEXT_MONDAY' => 'יום שני הבא',
    'LBL_NEXT_FRIDAY' => 'יום שישי הבא',
    'LBL_TWO_WEEKS' => 'שבועיים',
    'LBL_NEXT_MONTH' => 'בחודש הבא',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'ביום הראשון של החודש הבא',
    'LBL_THREE_MONTHS' => 'שלושה חודשים',
    'LBL_SIXMONTHS' => 'שישה חודשים',
    'LBL_NEXT_YEAR' => 'בשנה הבאה',
    'LBL_FILTERED' => 'מסונן',

    //Datetimecombo fields
    'LBL_HOURS' => 'ששעות',
    'LBL_MINUTES' => 'דקות',
    'LBL_MERIDIEM' => 'Meridiem',
    'LBL_DATE' => 'תאריך',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'ריענון-אוטומטי',

    'LBL_DURATION_DAY' => 'יום',
    'LBL_DURATION_HOUR' => 'שעה',
    'LBL_DURATION_MINUTE' => 'דקה',
    'LBL_DURATION_DAYS' => 'ימים',
    'LBL_DURATION_HOURS' => 'שעות',
    'LBL_DURATION_MINUTES' => 'דקות',
    'LBL_DURATION_SECONDS' => 'שניות',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'בחר חודש',
    'LBL_ENTER_YEAR' => 'הכנס שנה',
    'LBL_ENTER_VALID_YEAR' => 'אנא בחר שנה חוקית',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'אנא הזן מספר טפון כולל אזור חיוג.',
    'LBL_CCP_NOT_INITIATED' => 'ניסיון לחייג באמצעות CCP כשהספק לא נכנס למערכת.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'לא ניתן להוציא שיחה באמצעות CCP.',
    'LBL_CCP_DIALING_ERROR' => 'לא ניתן להשלים את השיחה כפי שחויגה.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'לפני ביצוע שיחה יוצאת, יש לסגור את כל הפעלות הצ&#39;אט ב-SugarLive.',

    //File write error label
    'ERR_FILE_WRITE' => 'שגיאה: לא מצליח לכתוב קובץ {0}.  בדוק הרשאות בשרת האינטרנט שלך.',
    'ERR_FILE_NOT_FOUND' => 'שגיאה: לא מצליח לטעון קובץ {0}.  בדוק הרשאות בשרת שלך.',

    'LBL_AND' => 'וגם',
    'LBL_BEFORE' => 'לפני',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'העלה מהמחשב שלי',
    'LBL_SEARCH_EXTERNAL_API' => 'קובץ או מקור חיצוני',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'העלאה למקור חיצוני',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'קישור ממקור חיצוני',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'ביטחון',
    'LBL_SHARE_PRIVATE' => 'פרטי',
    'LBL_SHARE_COMPANY' => 'חברה',
    'LBL_SHARE_LINKABLE' => 'ניתן לקישור',
    'LBL_SHARE_PUBLIC' => 'ציבורי',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS פיד',
    'LBL_RSS_RECORDS_FOUND' => 'רשומה/ות נמצאו',
    'ERR_RSS_INVALID_INPUT' => 'RSS איננו input_type חוקי',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS איננו response_type חוקי לשיטה זו',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs אינו תומך בפורמט הקובץ שסיפקתם.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'ריק',
    'LBL_IS_EMPTY' => 'ריק',
    'LBL_IS_NOT_EMPTY' => 'איננו ריק',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '"This is a sample import file which provides an example of the expected contents of a file that is ready for import."<br />"The file is a comma-delimited .csv file, using double-quotes as the field qualifier."<br /><br />"The header row is the top-most row in the file and contains the field labels as you would see them in the application."<br />"These labels are used for mapping the data in the file to the fields in the application."<br /><br />"Notes: The database names could also be used in the header row. This is useful when you are using phpMyAdmin or another database tool to provide an exported list of data to import."<br />"The column order is not critical as the import process matches the data to the appropriate fields based on the header row."<br /><br /><br />"To use this file as a template, do the following:"<br />"1. Remove the sample rows of data"<br />"2. Remove the help text that you are reading right now"<br />"3. Input your own data into the appropriate rows and columns"<br />"4. Save the file to a known location on your system"<br />"5. Click on the Import option from the Actions menu in the application and choose the file to upload"',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'הוקצה למשתמש ID',
    'LBL_EXPORT_CREATED_BY' => 'נוצר על ידי ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'נערך על ידי מזהה',
    'LBL_EXPORT_REPORTS_TO_ID' => 'מדווח אל זהות',
    'LBL_EXPORT_TEAM_ID' => 'צוות ID',
    'LBL_EXPORT_TEAM_SET_ID' => 'שיבוץ צוות ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'משתמש שהוקצה',
    'LBL_EXPORT_FULL_NAME' => 'שם מלא',
    'LBL_EXPORT_TEAM_NAME' => 'קבוצות',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'מנווט',

    'LBL_PENDING_NOTIFICATIONS' => 'הודעות',
    'LBL_ALT_ADD_TEAM_ROW' => 'הוסף שורה של צוות',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'הסר צוות',
    'LBL_ALT_SPOT_SEARCH' => 'חיפוש נקודת',
    'LBL_ALT_NOT_SORTED' => 'לא ממוין',
    'LBL_ALT_SORT_DESC' => 'בסדר עולה',
    'LBL_ALT_SORT_ASC' => 'בסדר יורד',
    'LBL_ALT_SORTABLE' => 'ניתן למיון',
    'LBL_ALT_NOT_SORTABLE' => 'לא ניתן למיון',
    'LBL_ALT_SORT' => 'סדר',
    'LBL_ALT_SHOW_OPTIONS' => 'הצג אפשרויות',
    'LBL_ALT_HIDE_OPTIONS' => 'הסתר אפשרויות',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'העבר את הבחירה שלך לרשימה שמשמאל',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'העבר את הבחירה שלך לרשימה שמימין',
    'LBL_ALT_MOVE_COLUMN_UP' => 'העבר את הבחירה שלך למעלה כדי לסדר את סדר הצגת הפריטים',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'העבר את הבחירה שלך חמטה כדי לסדר את סדר הצגת הפריטים',
    'LBL_ALT_INFO' => 'מידע',
    'MSG_DUPLICATE' => 'הרישום {0} שאתה עומד ליצור עלול להיות כפילות של רישום {0} שכבר קיים. רישומים {1} שמכילים שמות דומים רשומים מטה.<br>לחץ על צור{1} כדי להמשיך ליצור {0} חדש זה, או בחר {0} קיים מהרשימה מטה.',
    'MSG_SHOW_DUPLICATES' => 'הרישום {0} שאתה עומד ליצור עלול להיות כפילות של רישום {0} שכבר קיים. רישומים {1} שמכילים שמות דומים רשומים מטה. לחץ על שמור כדי להמשיך ליצור {0} חדש זה, או לחץ על ביטול כדי לחזור למודול מבלי ליצור את {0}.',
    'LBL_EMAIL_TITLE' => 'כתובת דואר אלקטרוני',
    'LBL_EMAIL_OPT_TITLE' => 'כתובת דוא"ל שבוטלה הצטרפותה',
    'LBL_EMAIL_INV_TITLE' => 'כתובת דואר אלקטרוני לא חוקית',
    'LBL_EMAIL_PRIM_TITLE' => 'כתובת דואר ראשית',
    'LBL_SELECT_ALL_TITLE' => 'בחר הכל',
    'LBL_SELECT_THIS_ROW_TITLE' => 'בחר שורה זו',
    'LBL_TEAM_SELECTED_TITLE' => 'צוות שנבחר',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'בחר כדי לעשות צוות זה ראשי',
    'LBL_TEAM_TBSELECTED_TITLE' => 'הצוות סומן כנבחר מבוסס-צוות ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'סמן צוות זה כנבחר מבוסס-צוות',
    'LBL_SEARCH_AND_SELECT' => 'חפש ובחר {{module}}',
    'TPL_SEARCH_AND_ADD' => 'חפש והוסף {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'שגיאה: קרתה שגיאה לאחר ההעלאה. קוד שגיאה: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'ERROR: There was an error during upload. Error code: {0} - {1}. The upload_maxsize is {2}',
    'UPLOAD_ERROR_HOME_TEXT' => 'שגיאה: קרתה שגיאה במהלך ההעלאה שלך, אנא צור קשר עם מנהל מערכת לקבלת עזרה.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'גודל העלאה ({0} בתים) חרג מהגודל המרבי המותר: {1} בתים',
    'UPLOAD_REQUEST_ERROR' => 'חלה שגיאה. נא לרענן את הדף ולנסות שוב',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'E',
    'LBL_EDIT_BUTTON_LABEL' => 'ערוך',
    'LBL_ADD_BUTTON_LABEL' => 'הוסף',
    'LBL_EDIT_BUTTON_TITLE' => 'ערוך',
    'LBL_REFRESH_BUTTON_LABEL' => 'רענון',
    'LBL_REFRESH_BUTTON_TITLE' => 'רענן',
    'LBL_DUPLICATE_BUTTON_KEY' => 'U',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'שכפל',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'שכפל [Alt+U]',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'לוחות זמנים לדוחות',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'לוחות זמנים לדוחות',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'פרטי הדוח',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'פרטי הדוח',
    'LBL_DELETE_BUTTON_KEY' => 'D',
    'LBL_DELETE_BUTTON_LABEL' => 'מחק',
    'LBL_DELETE_BUTTON_TITLE' => 'מחק',
    'LBL_SAVE_BUTTON_KEY' => 'S',
    'LBL_SAVE_BUTTON_LABEL' => 'שמירה',
    'LBL_SAVE_BUTTON_TITLE' => 'שמירה',
    'LBL_CANCEL_BUTTON_KEY' => 'X',
    'LBL_CANCEL_BUTTON_LABEL' => 'בטל',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'ליצור',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'להשאר בדף',
    'LBL_CANCEL_BUTTON_TITLE' => 'בטל [Alt+X]',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'שתף',
    'LBL_SHARE_BUTTON_TITLE' => 'שתף',
    'LBL_START_BUTTON_LABEL' => 'התחלה',
    'LBL_START_BUTTON_TITLE' => 'התחלה',
    'LBL_FINISH_BUTTON_LABEL' => 'סיום',
    'LBL_FINISH_BUTTON_TITLE' => 'סיום',
    'LBL_CONFIRM_BUTTON_LABEL' => 'אשר',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'להמשיך',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'לעזוב ולהתעלם משינויים',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'קיצורי דרך של המקלדת',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Form Functionality - Alt+</strong><br/> I = ed<b>I</b>t (detailview)<br/> U = d<b>U</b>plicate (detailview)<br/> D = <b>D</b>elete (detailview)<br/> A = s<b>A</b>ve (editview)<br/> L = cance<b>L</b> (editview) <br/><br/></p><p><strong>Search and Navigation  - Alt+</strong><br/> 7 = first input on Edit form<br/> 8 = Advanced Search link<br/> 9 = First Search Form input<br/> 0 = Unified search input<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'בצע הסלמה',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'שתף',
    'TPL_RECORD_SHARE_SUBJECT' => '{{module}} {{name}} משותף מ {{appId}}',
    'TPL_RECORD_SHARE_BODY' => '{{module}} {{name}} נא לבצע יציאה מ {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'מערך מחבר ב{0} הוגדר לא נכונה או ריק ולא ניתן להשתמש בו.',
    'LBL_PDF_VIEW' => 'הורד PDF',
    'LBL_PDF_EMAIL' => 'דואר אלקטרוני ב PDF',

    'ERR_SUHOSIN' => 'זרם העלאה נחסם על ידי Suhosin, אנא הוסף &quot;העלאה&quot; ל-suhosin.executor.include.whitelist (ראה sugarcrm.log לפרטים נוספים)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'כעת',
    'LBL_TIME_AGO_SECONDS' => 'לפני פחות מדקה',
    'LBL_TIME_AGO_MINUTE' => 'לפני כדקה',
    'LBL_TIME_AGO_MINUTES' => 'לפני {{this}} דקות',
    'LBL_TIME_AGO_HOUR' => 'לפני כשעה',
    'LBL_TIME_AGO_HOURS' => 'לפני {{this}} שעות',
    'LBL_TIME_AGO_DAY' => 'אתמול',
    'LBL_TIME_AGO_DAYS' => 'לפני {{this}} ימים',
    'LBL_TIME_AGO_YEAR' => 'לפני למעלה משנה',
    'LBL_TIME_UNTIL_SECONDS' => 'תוך פחות מדקה',
    'LBL_TIME_UNTIL_MINUTE' => 'תוך בערך דקה',
    'LBL_TIME_UNTIL_MINUTES' => 'ב {{this}} דקות',
    'LBL_TIME_UNTIL_HOUR' => 'בתוך כשעה',
    'LBL_TIME_UNTIL_HOURS' => 'ב {{this}} שעות',
    'LBL_TIME_UNTIL_DAY' => 'מחר',
    'LBL_TIME_UNTIL_DAYS' => 'ב  {{this}} ימים',
    'LBL_TIME_UNTIL_YEAR' => 'תוך יותר משנה',
    'LBL_TIME_RELATIVE' => '{{relativetime}} פרסם ב {{date}} ב {{time}}',
    'LBL_LAST_TOUCHED' => '{{relativetime}} שונה לאחרונה ב {{date}} ב {{time}}',
    'LBL_LAST_COMMIT' => 'התחייבות אחרונה: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'אין נתונים זמינים',
    'LBL_DETAILVIEW_NO_RECORDS' => 'לא ניתן לרנדר רשומה זא כעת',
    'LBL_REFINE_LIST' => 'חדד רשימה',
    'LBL_SEARCH_BY' => 'חפש לפי',
    'LBL_PREVIEW' => 'תצוגה מקדימה',
    'LBL_COLUMNS' => 'עמודות',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'תצוגה מקדימה לא פעילה. אין גישה לרשומה',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'תצוגה מקדימה לא פעילה. אין גישה לרשומה',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'תצוגה מקדימה לא פעילה. אין נתונים זמינים',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'תצוגה מקדימה לא פעילה. מציג כרשומה נוכחית',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'תצוגה מקדימה לא פעילה. הרשומה הוסרה או שאין גישה אליה',
    'LBL_PREVIEW_PREVIOUS' => 'הצג את הקודם בתצוגה מקדימה',
    'LBL_PREVIEW_NEXT' => 'הצג את הבא בתצוגה מקדימה',
    'LBL_PREVIEW_CLOSE' => 'סגירת התצוגה המקדימה',
    'LBL_STREAM_NO_RECORDS' => 'לרשומה זו אין פתקים. הוסף פתק על ידי לחיצה על הקישור הוסף פתק.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} כפילויות נמצאו',
    'LBL_NO_DUPLICATES_FOUND' => 'לא נמצאו כפילויות.',
    'LBL_RESET_DEFAULT_VIEW' => 'איפוס ערך ברירת מחדל',
    'LBL_RESET_DEFAULT_WIDTHS' => 'איפוס ברירת מחדל רוחבים',
    'LBL_TIMEZONE_UPDATED' => 'Sugar עדכן את אזור הזמן של פרופיל המשתמש, כך שיתאים לאזור הזמן של הדפדפן',
    'LBL_SUCCESS' => 'הצלחה',
    'LBL_ERROR' => 'שגיאה',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'מזג',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'האם ברצונך להמשיך? אשר למחיקת רשומות',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'פעולה זו תמחוק את רשומות אלו:',
    'LBL_MERGE' => 'מזג',
    'TPL_MERGING_RECORDS' => 'ממזג {{mergeCount}} רשומות',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'הועבר מספר בלתי חוקי של רשומות. הטווח התקין הוא מ {{minRecords}} ל {{maxRecords}} רשומות',
    'LBL_MERGE_NO_ACCESS' =>
        'אין לך הרשאה לביצוע פעולה זו. יש למחוק לפחות רשימה אחת',
    'LBL_MERGE_LOCKED' => 'חלק מהרשומות שנבחרו למיזוג מכילות שדות הנעולים לעריכה על-ידי תהליך כלשהו, ואינם ניתנים למיזוג בשלב זה.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'כל השינויים יעלמו כאשר תעבור לרשימה עיקרית חדשה. אתה בטוח?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'מזג רשומות קשורות',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'מוזגו: ‎{{percent}}%‎',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'מיזוג {{objectName}} מקושרים נכשל. מנסה שוב  ({{num}} מתוך {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'מיזוג {{objectName}} מקושרים נכשל',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'מיזוג רשומות קשורות לא הושלם. ישנן רשומות שנותרו לא ממוזגות',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'ישנן רשומות קשורות שלא מוזגו כהלכה. בטל. אשר להמשך מיזוג',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'כל הרשומות הקשורות יועברו לרשומה העיקרית',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'אתה בטוח שברצונך למחוק רשומה זו מהמיזוג?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'הסר רשומה ממיזוג',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'הועבר מספר לא חוקי של רישומים. הטווח התקין נע בין 1 ל{{maxRecords}} רישומים.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'שם משתמש וסיסמא שגויים',
    'LBL_INVALID_CREDS_TITLE' => 'פרטים שגויים',
    'LBL_INVALID_GRANT' => 'האסימון שלך לא חוקי או פג תוקף. אנא התחבר שוב.',
    'LBL_INVALID_GRANT_TITLE' => 'אסימון פג תוקף',
    'LBL_AUTH_FAILED' => 'אישור לקוח נכשל',
    'LBL_AUTH_FAILED_TITLE' => 'לקוח שגוי',
    'LBL_INVALID_REQUEST' => 'הבקשה לא תקינה. אנא פנה לתמיכה טכנית',
    'LBL_INVALID_REQUEST_TITLE' => 'בקשה לא חוקית',
    'LBL_REQUEST_TIMEOUT' => 'השרת אינו מגיב. בדוק את החיבור שלך לאינטרנט.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'חלף הזמן לבקשה: ',
    'LBL_UNAUTHORIZED' => 'אינך מורשה לגשת למשאב זה',
    'LBL_UNAUTHORIZED_TITLE' => 'לא מורשה',
    'LBL_RESOURCE_UNAVAILABLE' => 'משאב אינו זמין',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'אסור',
    'LBL_METHOD_NOT_ALLOWED' => 'לא ניתן להתשמש בשיטת HTTP במשאב זה. אנא פנה לתמיכה טכנית',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'שיטה לא מורשת',
    'LBL_PRECONDITION_MISSING' => 'שגיאה בבקשה או שפרמטר חסר או לא תקין. אנא פנה לתמיכה טכנית',
    'LBL_PRECONDITION_MISSING_TITLE' => 'שגיאה',
    'LBL_INVALID_412_RESPONSE' => 'בקשה שנכשלת מוציאה את האפליקציה משימוש. אנא פנה לתמיכה טכנית',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'לא ניתן לערוך את קובץ {0} במודול: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'לא ניתן לבצע פעולת {0} ברשומה זו',
    'LBL_LOGIN_BUTTON_LABEL' => 'כניסה למערכת',
    'LBL_ACTIVITY_VIEW_TOUR' => 'סיור תצוגת פעילות',
    'LNK_TOUR' => 'סיור',
    'LNK_MOBILE' => 'סלולרי',
    'LBL_FEEDBACK' => 'משוב',
    'LBL_SUPPORT' => 'תמיכה',
    'LBL_LANGUAGE' => 'שפה:',
    'LBL_LOADING_LANGUAGE' => 'טוען חבילת שפה',
    'LBL_UPLOADING' => 'מעלה',
    'LBL_UPLOADING_DOTS' => 'מעלה...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'אתה בטוח שברצונך למחוק תמונה זו?',
    'LBL_FILE_DELETE_CONFIRM' => 'אתה בטוח שברצונך למחוק קובץ זה? לא ניתן לבטל פעולה זו',
    'LBL_FILE_DELETED' => 'הקובץ נמחק בהצלחה',

    //theme roller
    'LBL_PORTAL_THEME' => 'פורטל נושא',
    'LBL_THEME_PREVIEW' => 'תצוגה מקדימה של עיצוב הפורטל',
    'LBL_LOADING_PREVIEW' => 'טוען תצוגה מקדימה',
    'LBL_RESET' => 'איפוס',
    'LBL_COLORS' => 'צבעים',
    'BorderColor' => 'צבע גבול',
    'NavigationBar' => 'בר ניווט',
    'PrimaryButton' => 'כפתור עיקרי',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'שמירה ופריסה',
    'LBL_RESET_THEME_LNK' => 'שחזר תבנית עיצוב ברירת מחדל',
    'LBL_RESET_THEME_MODAL_INFO' => 'אתה בטוח שברצונח לבטל את הגדרות תבנית העיצוב המותאמות ולהחליפן בתבנית עיצוב רירת מחדל?',
    'LBL_RESET_THEME_PROCESS' => 'משחזר תבנית עיצוב ברירת מחדל...',
    'LBL_SAVE_THEME_PROCESS' => 'שומר תבנית עיצוב...',

    // image loader
    'LBL_SELECT_PHOTO' => 'בחר תמונה',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'תחזית משופרת בשוגר',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Setup your forecasting parameters</li><li class="icon-ok">Easily track projected sales and pipeline health</li><li class="icon-ok">Forecast based on projected sales from your sales team</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'הגדר את הפרמטרים שלך לתחזית',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Choose fiscal year start date</li><li class="icon-ok">Setup Time Periods to be either yearly or quarterly</li><li class="icon-ok">Decide how many past and future Time Periods need to be visible in the worksheet</li><li class="icon-ok">Select Forecast ranges to tag Opportunities as Include, Exclude or Upside</li><li class="icon-ok">Select Forecast scenarios to identify Likely, Best and Worst forecast</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'נהל את המכירות הצפויות של צוות המכירות',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Select the Time Period to review the Forecast</li><li class="icon-ok">View your sales team members’ worksheets and provide adjusted forecasts</li><li class="icon-ok">See alert on worksheet when a sales team member commits a new Forecast</li><li class="icon-ok">Save the Forecast worksheet as a draft version or commit the Forecast to your manager</li><li class="icon-ok">View history of previous commits</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'נהל את המכירות הצפויות של צוות המכירות',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">View Pareto chart for pipeline analysis across all your sales team members&#39; forecasts</li><li class="icon-ok">Choose to visualize projected sales by Likely, Best or Worst forecast</li><li class="icon-ok">View projected sales and how close you are to make your team Quota</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'נהל את המכירות הצפויות שלך',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Select the Time Period for your Forecast</li><li class="icon-ok">Review and in-line edit amounts and Win Probability for a quick what-if analysis</li><li class="icon-ok">Save the Forecast worksheet as a draft version or commit the Forecast to your manager</li><li class="icon-ok">View history of previous commits</li><li class="icon-ok">Commit Forecast to Manager and view History of previous Commits</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'נהל את המכירות הצפויות שלך',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">View Pareto chart for pipeline analysis over time for your Opportunities</li><li class="icon-ok">Choose to visualize pipeline distribution by Sales Stage or Win Probability</li><li class="icon-ok">View projected sales and how close you are to make your assigned Quota</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'מה חדש בשוגר',
    'LBL_TOUR_WATCH' => 'צפה בחידושים בשוגר',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="icon-ok">Improved look and feel – now with a new modern theme.</li><li class="icon-ok">Enhanced Forecasts module – now with intuitive user interface and new data visualization</li></ul>',
    'LBL_TOUR_VISIT' => 'למידע נוסף בקר באפליקציה שלנו',
    'LBL_TOUR_DONE' => 'סיימת',
    'LBL_TOUR_REFERENCE_1' => 'תמיד תוכל לפנות ל',
    'LBL_TOUR_REFERENCE_2' => 'באמצעות הקישור לתמיכה שנמצא תחת תפריט פרופיל',
    'LNK_TOUR_DOCUMENTATION' => 'תיעוד',
    'LBL_TOUR_CALENDAR_URL_1' => 'האם אתה משתף את לוח השנה שלך ב-SugarCRM עם יישומים צד-שלישי, כמו Microsoft Outlook או Exchange? אם כן, יש לך כתובת URL חדשה. כתובת ה-URL החדשה והמאובטחת יותר כוללת מפתח שימנע פרסום לא מורשה של לוח השנה שלך.',
    'LBL_TOUR_CALENDAR_URL_2' => 'קבלת את הקישור ללוח שנה המשותף החדש שלך',
    'LBL_TOUR_CUBE' => 'גישה ללוח מחוונים ותזרים פעילות',
    'LBL_TOUR_NAV_BAR' => 'גישה לכל המודולים בתפריט ניווט ופעולות',
    'LBL_TOUR_NOTIFICATIONS' => 'הקלק לצפיה בהודעות',
    'LBL_TOUR_SEARCH' => 'בחר מודול אחד או יותר וחפש',
    'LBL_TOUR_AVATAR' => 'קבל פרטים נוספים או צא מהמערכת',
    'LBL_TOUR_ADD' => 'צור רשומה מכאן',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'הקלק לפתיחת פנל אינטיליגנציה',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'בחר לצפיה בפעילויות או רשומות',
    'LBL_TOUR_LIST_FILTER1' => 'בר פילטר מאפשר חיפוש במודול זה',
    'LBL_TOUR_LIST_FILTER2' => 'בחר פילטר מוגדר או צור חדש',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'הקלק כאן לחיפוש מבוסס שם',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'בחר לערוך את השורה או פרטים קודמים',
    'LBL_TOUR_RECORD_ACTIONS' => 'פעל על הרשומה',
    'LBL_TOUR_RECORD_SUBPANEL' => 'לחץ על הכותרת העליונה כדי להרחיב ולפרק פאנל משנה',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'שם הרשומה ניתנת לעדכון במקום',
    'LBL_TOUR_RECORD_STATUS' => 'מצא סטטוס רשומה כאן',
    'LBL_TOUR_RECORD_SHOWMORE' => 'הקלק למידע נוסף על הרשומה',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'בחר לראות פעילויות או רשומות קשורות',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'הקלק לעריכת רשומה',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'צור קבוצות חדשות של דשלטים',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'בחר שם לקבוצה של דשלטים',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'בחר להסיר דשלט לשינוי הגדרות',
    'LBL_TOUR_INTRO' =>'<h4>ברוכים הבאים ל-Sugar</h4> אנחנו רוצים לספר לך על חלק מהאפשרויות שלנו. השתמש בחצים < ו- > שבתחתית המסך כדי לעבור את הסיור.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">מה חדש</a><p class="details">גלה את השינויים העיקריים שביצענו בין הגרסאות השונות.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">גלה עוד אודות Sugar</a><p class="details">ספריית לימודים מקוונת עוצמתית, תרגולי כיתה וירטואליים ובשידור חי, סמינרים אינטרנטיים ומדריכי וידאו.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">קבל תמיכה</a><p class="details">זקוק לעזרה, נתקלת בבעיה או שיש לך הצעות כיצד לשפר את Sugar?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'צפה ברשימה של כל הרשומות ופעל',
    'LBL_TOUR_RECORD_INTRO' => 'צפה בפרטי הרשימה ובנתונים קשורים',
    'LBL_TOUR_FORECAST_INTRO' => 'נהל צינור ותחזית',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'בחר תקופת זמן לצפיה בתחזית מתאימה',
    'LBL_TOUR_FORECASTS_COMMITS' => 'הקלק לצפיה בהערות קודמות',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'הקלק לעריכת הנתונים',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'סקור מרחק להצעת מחיר',
    'LBL_TOUR_FORECASTS_CHART' => 'סקור תחזית הפצה',
    'LBL_TOUR_TOUR' => 'סיור גישה בכל עת',
    'LBL_TOUR_TAGS_ADD' => 'לחץ על שדה התיוגים כדי להוסיף ולהסיר תיוגים',
    'LBL_TOUR_TAGS_DELETE' => 'כדי למחוק תיוג, השתמש ב-Backspace או לחץ על הכפתור [X] בכל תיוג',
    'LBL_TOUR_RECORD_SAVE' => 'ברגע שאתה מוכן, לחץ על שמירה',


    'LBL_FUTURE' => 'עתיד',
    'LBL_REQUIRED_FIELD' => 'חובה',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'שורת פריט עם הצעת מחיר',
    'LBL_DISCOUNT_TOTAL' => 'סכום ההנחה הכולל',
    'LBL_DISCOUNT_PERCENT' => '% אחוז',
    'LBL_DISCOUNT_SELECT' => 'קביעה אם ההנחה היא באחוזים או סכום קבוע',
    'LBL_TAX' => 'מס',
    'LBL_SHIPPING' => 'משלוח',
    'LBL_GRAND_TOTAL' => 'סכום כולל',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'מלא באופן אוטומטי את הכתובת לחיוב מחשבון הפרופיל',
    'LBL_QLI_ADD_GROUP' => 'הוסף קבוצה',
    'LBL_QLI_COMMENT' => 'תגובה',
    'LBL_SELECT_ACTION' => 'בחר פעולה',
    'LBL_QLI_GROUP_NAME' => 'שם קבוצה',
    'LBL_GROUP_TOTAL' => 'סה"כ קבוצה',
    'LBL_ITEM_NAME' => 'שורת פריט',
    'LBL_QLI_DELETE' => 'האם אתה בטוח שברצונך למחוק את שורת פריט זו?',
    'LBL_QLI_COMMENT_DELETE' => 'האם אתה בטוח שברצונך למחוק את התגובה לשורת פריט זו?',
    'LBL_QLI_GROUP_DELETE' => 'האם אתה בטוח שברצונך למחוק את הקבוצה &#39;{0}&#39;? כל הפריטים יועברו לקבוצת ברירת המחדל.',
    'LBL_QLI_GROUP_EMPTY' => 'אין שורת פריט עם הצעת מחיר',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'אופציונלי',
    'LBL_RELATED_MODULE' => 'קשור ל {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'קשור {{{this}}}',
    'LBL_CREATE_MODULE' => 'צור {{{this}}}',
    'LBL_EDIT' => 'ערוך {{{this}}}',
    'LBL_ASSOC' => 'קשר {{{this}}}',
    'LBL_ASSIGN' => 'בחר {{{this}}}',
    'LBL_EDIT_RELATED' => 'ערוך מקושר {{{this}}}',
    'LBL_CREATE_RELATED' => 'צור מקושר {{{this}}}',
    'LBL_ASSOC_EXISTING' => 'קשר לקיים {{{this}}}',
    'LBL_SEARCH_ALL' => 'חפש בכל {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'חפש בכל הרשומות...',
    'LBL_SEARCH_ALL_MODULES' => 'חפש בכל',
    'LBL_OK' => 'אישור',
    'LBL_YES' => 'כן',
    'LBL_NO' => 'לא',
    'LBL_SHOW_NUMBERING' => 'הצג מספור שלבים',
    'LBL_HIDE_NUMBERING' => 'הסתר מספור שלבים',
    'LBL_CALL_BUTTON' => 'שיחת טלפון',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'דואר אלקטרוני',
    'LBL_HONEYPOT' => 'אם אתה אדם אמיתי אז אל תמלא זאת',
    'LBL_LINK_BUTTON' => 'לינק',
    'LBL_UNLINK_BUTTON' => 'הסר קישור',
    'LBL_MAP_BUTTON' => 'מפה',
    'LBL_FILE_BUTTON' => 'קובץ',
    'LBL_URL_BUTTON' => 'ווב',
    'LBL_WARNING' => 'אזהרה:',
    'LBL_CONFIRM' => 'אשר',
    'LBL_CONFIRMATION_POPUP' => 'חלון קופץ לאישור',
    'LBL_NO_ACCESS' => '(אין גישה)',
    'LBL_NO_ACCESS_LOWER' => 'אין גישה',
    'LBL_NO_FIELD_ACCESS' => 'ללא גישה',
    'LBL_NO_LICENSE_ACCESS' => 'נדרש רישיון',
    'LBL_VALUE_ERASED' => 'הערך נמחק',
    'LBL_VALUE_ERASED_TOOLTIP' => 'מידע זה נמחק באמצעות בקשת פרטיות נתונים',
    'LBL_CREATE_RELATED_RECORD' => 'צור רשומה קשורה',
    'LBL_ASSOC_RELATED_RECORD' => 'קשר רשימה מקושרת',
    'LBL_CHOOSE_LINK' => 'בחר סוג קישור',
    'LBL_CHOOSE_PARENT_TYPE' => 'בחר סוג הורה',
    'LBL_HOME' => 'בית',
    'ERR_NO_DOCS' => 'אין מסמכים זמינים',
    'ERR_NO_RECORDS_SELECTED' => 'לא בחרת רשומות',
    'LBL_DELETING' => 'מוחק...',
    'LBL_UNLINKING' => 'מסיר קישור...',
    'LBL_UNLINKED' => 'קישור הוסר',
    'LBL_LEGAL' => 'חוקי',
    'LBL_UPCOMING' => 'הפגישות הקרובות שלי',
    'LBL_RECENTLY_UPDATED' => 'עודכן לאחרונה',
    'LBL_NOTES_SUBPANEL_TITLE' => 'הערות',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'פגישות',
    'LBL_TASKS_SUBPANEL_TITLE' => 'משימות',
    'LBL_CALLS_SUBPANEL_TITLE' => 'שיחות',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'חשבונות',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'אנשי קשר',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'כתובות מייל',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'משמרות',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'שורות הצעות מחיר',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'החרגות למשמרות',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'מסמכים',
    'LBL_ESCALATIONS' => 'הסלמות',
    'LBL_ESCALATED' => 'הוסלם',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'הסלמות',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'הסלמות קשורות אחרות',
    'LBL_ESCALATIONS' => 'הסלמות',
    'LNK_SETTINGS' => 'הגדרות',
    'LBL_MOBILE_SUPPORT' => 'תמיכה',
    'LBL_MOBILE_SHOW_MORE' => 'הצג עוד...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'הצג עוד',
    'LBL_MOBILE_NO_RECORDS' => 'לא נמצאו רשומות',
    'LBL_MOBILE_SEARCH_TEAMS' => 'חפש צוותים...',
    'LBL_MOBILE_SELECT_TEAMS' => 'בחר צוותים',
    'LBL_MOBILE_WAIT' => 'אנא המתן...',
    'LBL_MOBILE_LOGING_OUT' => 'אנא המתן בעת היציאה',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'הכנס מחדש',
    'LBL_MOBILE_META_SYNC_FAILED' => 'לא ניתן לסנכרן עם שרת.',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'לא ניתן לסנכרן עם שרת. לנסות שוב?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'פרטיות ותנאים',
    'LBL_MOBILE_APP_VERSION' => 'גירסת אפליקציה',
    'LBL_MOBILE_SERVER_VERSION' => 'גירסת שרת',
    'LBL_MOBILE_SERVER_URL' => 'URL שרת',
    'LBL_MOBILE_PTR_PULL' => 'גלול מטה כדי לרענן',
    'LBL_MOBILE_PTR_RELEASE' => 'שחרר כדי לרענן...',
    'LBL_MOBILE_EDIT_REL' => 'ערוך מערכת יחסים',
    'LBL_MOBILE_DESKTOP' => 'גירסת שולחן העבודה',
    'LBL_MOBILE_DELETE_CONFIRM' => 'אתה בטוח בשברצונך למחוק רשומה זו?',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'אתה בטוח שברצונך לבטל את הקישור של הרשומה הזו?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'היית רוצה לשמור את השיחה האחרונה שביצעת?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'בחר נמען',
    'LBL_MOBILE_CHOOSE_PHONE' => 'בחר מספר טלפון',
    'LBL_MOBILE_CHOOSE_URL' => 'בחר URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'בחר מסמך',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'בחר מיקום',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'אין פעולה זמינה',
    'LBL_MOBILE_FEEDBACK' => 'משוב',
    'LBL_MOBILE_DOC' => 'מסמך',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'הורדה החלה: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'הורדה הסתיימה: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'מעלה קובץ...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'קובץ הועלה בהצלחה',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'מכין תמונה...',
    'LBL_CLOSE_SAVE_BUTTON' => 'סגור משימה ושמור',
    'LBL_LATER' => 'מאוחר יותר',
    'LBL_USE_HTTPS' => 'השתמש בחיבור מאובטח',
    'LBL_LOADING_FILES' => 'עדיין טוען רשמית מסמכים. אנא נסה שוב מאוחר יותר',
    'LBL_NEW_WEB_VERSION' => 'גירסה חדשה לאפליקציה זו זמינה. האם ברצונך להורידה?',
    'LBL_SET_FONTSIZE' => 'גודל פונט',
    'LBL_FONTSIZE_TINY' => 'קטן מאוד',
    'LBL_FONTSIZE_SMALL' => 'קטן',
    'LBL_FONTSIZE_NORMAL' => 'נורמלי (ברירת מחדל)',
    'LBL_FONTSIZE_LARGE' => 'גדול',
    'LBL_FONTSIZE_LARGER' => 'גדול',
    'LBL_FONTSIZE_HUGE' => 'ענק',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'ענק במיוחד',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "ההורדה נכשלה\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'עוד...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => 'פחות...',
    'LBL_OFFLINE_MODE' => 'מצב לא מקוון',
    'LBL_OFFLINE_DELETED' => 'רשומה לא נמצאה',
    'LBL_OFFLINE_DELETED_RELATED' => 'רשומה קשורה לא נמצאה. היא כנראה נחמקה או שהקישור הוסר',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'הורדת הרישומים המוקצים, המועדפים ובמעקב שלך עבור גישה לא מקוונת עשויה להימשך קצת זמן עד שתסתיים. מומלץ חיבור מהיר. האם ברצונך להמשיך?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'האם ברצונך להוריד כעת את הרישומים המוקצים, המועדפים ובמעקב שלך עבור גישה לא מקוונת? מומלץ חיבור מהיר מכיוון שפעולה זו עלולה להימשך זמן מה. באפשרותך להוריד בשלב מאוחר יותר דרך תפריט ראשי > לא מקוון.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'רשומות הורדו בהצלחה',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'מוריד את הרשומות שלך...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'שגיאה בעת הורדת רשומות',
    'LBL_OFFLINE_PREFETCHING' => 'טוען רשומות...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'טוען {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'הערכת זמן שנותרה {{estimatedTime}}s...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => 'טעינת {{module}} הושלמה',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'מנקה אחסון...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'נקיון הושלם',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'האם אתה רוצה להזיר שינוי זה למצב הקודם?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'חזרה למצב קושם הושלם',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'חזרה למצב קושם נכשל',
    'LBL_OFFLINE_CLEAR_DB' => 'נקה אחסון...',
    'LBL_OFFLINE_COMPACT_DB' => 'אחסון קומפקטי...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'פעולה זו תמחק רשומות שלא נגשת אליהן זמן מה. האם להמשיך?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'האם למחוק את כל הרשומות מהאסון המקומי?',
    'LNK_OFFLINE_SETTINGS' => 'לא מקוון',
    'LBL_OFFLINE_SETTINGS' => 'הגדרות דיבאג',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'אין שינויים ממתינים לסנכרון',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'שינויים ממתינים לסנכרון',
    'LBL_OFFLINE_STATUS_ONLINE' => 'המכשיר לא מקוון',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'המכשיר לא מקוון',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'לא מצליח להגיע לשרת',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'נסיון סנכרון אחרון נכשל. בדוק את הלוגים',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'מבצע סנכרון...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'טרנזקציה סונכרנה',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'ברצונך לכבות את התמיכה הבלתי מקוונת?',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'ברצונך לכבות את התמיכה הבלתי מקוונת? כל השינויים הממתינים יבוטלו',
    'LBL_OFFLINE_ENABLED' => 'מודול בלתי מקוון מופעל',
    'LBL_OFFLINE_DISABLED' => 'מודול בלתי מקוון מכובה',
    'LBL_OFFLINE_STATS' => 'סטטיסטיקת אחסון',
    'LBL_OFFLINE_SERVER_FETCH' => 'מביא מהשרת...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'מישהו כבר ערך את אותו הרישום בשרת. אשר כדי למזג אוטומטית את השינויים שלך או דחה כדי לבטל אותם.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'נסיון סנכרון אחרות => {{ts}}',
    'LBL_ACTION_UPDATE' => 'עדכן',
    'LBL_ACTION_CREATE' => 'צור',
    'LBL_ACTION_DELETE' => 'מחק',
    'LBL_ACTION_LINK' => 'קשר',
    'LBL_ACTION_UNLINK' => 'בטל קישור',
    'LBL_ACTION_FAVORITE' => 'מועדף',
    'LBL_ACTION_FOLLOW' => 'עקוב',
    'LBL_ACTION_CREATE_EXPLANATION' => 'נוצר {{module}} &#39;{{name}}&#39;',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'מעודכן {{module}} &#39;{{name}}&#39;',
    'LBL_ACTION_DELETE_EXPLANATION' => 'נמחק {{module}} &#39;{{name}}&#39;',
    'LBL_ACTION_LINK_EXPLANATION' => 'קושר {{module}} &#39;{{name}}&#39; ל {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'בוטל קישור {{module}} &#39;{{name}}&#39; ל {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'עוקב {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'לא עוקב {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'מועדף {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'לא מועדף {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'נוצר {{module}} &#39;{{name}}&#39; מקושר ל {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'ראשי',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'ביטול הצטרפות',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'הצטרפות',
    'LBL_EMAIL_ACTION_SET_VALID' => 'בר-תוקף',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'לא חוקי',
    'LBL_ROLLBACK_BUTTON' => 'חזרה למצב קודם',
    'LBL_TX_LOG' => 'לוג טרנזקציות',
    'LBL_TX_LOG_DETAIL' => 'פרטי טרנזקציה',
    'LBL_RECORD_DELETED' => 'הקלטה נמחקה',
    'LBL_NOT_AVAILABLE' => 'לא זמין',
    'LBL_FILE_SIZE' => 'גודל הקובץ',
    'LBL_FILE_SIZE_UNITS_B' => 'ביטים',
    'LBL_FILE_SIZE_UNITS_KB' => 'ק"ב',
    'LBL_FILE_SIZE_UNITS_MB' => 'מ"ב',
    'LBL_CHOOSE_ITEMS' => 'בחר פריטים',
    'LBL_OFFLINE_DB_SIZE' => 'גודל בסיס נתונים',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'רשומות למודול',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'סך הכל רשומות',
    'LBL_RECORD_NOT_FOUND' => 'רשומה לא נמצאה',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'רשומה מקושרת לא נמצאה',
    'LBL_NOT_AUTHORIZED' => 'אינך מורשה לצפות ברשומה זו.',
    'LBL_MOBILE_PROCESSING_FILE' => 'מכין קובץ...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'תוכנה של גוף שלישי',
    'LNK_TERMS_OF_USE' => 'תנאי שימוש',
    'LNK_PRIVACY_POLICY' => 'מדיניות פרטיות',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'כניסה לחשבון יחיד',
    'LBL_RECENTS' => 'לאחרונה',
    'LBL_SHOWING_CACHED_DATA' => 'לא ניתן ליצור קשר עם השרת. מציג נתונים זמינים אחרונים ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'סגור את {{moduleSingular}} ושמור',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'לוח מכוונים ספציפי',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'מודול ספציפי',
    'LBL_MOBILE_DEFAULT_VIEW' => 'מסך התחלה',
    'LBL_MOBILE_DEFAULT_MODULE' => 'מודול שנבחר',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'לוח מכוונים שנבחר',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'חלונית שנבחרה',
    'LBL_ALL_DASHLETS' => 'כל החלוניות',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'חיפוש גלובלי',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'הקלד @ כדי לאזכר משתמש. הקלד # כדי להפנות לרישום.',
    'LBL_MOBILE_NEW_COMMENT' => 'תגובה חדשה',
    'LBL_RECENTLY_VIEWED' => 'ניצפו לאחרונה',
    'LBL_FILE_STORED_LOCALLY' => 'הקובץ שמור באחסון מקומי והוא יסונכרן כשהמכשיר יהיה מחובר לאינטרנט.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'אם ברצונך לשנות שדות שאינם ניתנים לעריכה, פנה למנהל המערכת כדי ליידע אותו בשינויים הרצויים.',
    'LBL_ACTIVITY_POST' => '{{{value}}} ב-{{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'ללא הערה',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'הצג את {{{commentsLeft}}} ההערות הבאות',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'כווץ',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'אשר יצירת הערה',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'יומן ההערות אינו יכול להיות ריק',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'הורד PDF של {{{pdfTemplateName}}}',

    'ERR_SYNC_FAILED' => 'לא ניתן לסנכרן עם שרת.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'גישה לא מורשית',
    'ERR_MOBILE_INVALID_CREDS' => 'שם משתמש או סיסמא לא נכונים',
    'ERR_MOBILE_SESSION_EXPIRED' => 'הסשן שלך הסתיים',
    'ERR_MOBILE_NOT_FOUND' => 'משאב לא נמצא',
    'ERR_MOBILE_TIMEOUT' => 'השרת אינו מגיב',
    'ERR_MOBILE_CONNECTION_FAILED' => 'השרת אינו מגיב',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'קישור לאינטרנט אינו זמין',
    'ERR_MOBILE_INTERNAL' => 'שגיאה ({{{code}}}). נסה שוב מאוחר יותר',
    'ERR_MOBILE_VALIDATION' => 'רשומה אינה זמינה',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'טעם שרת לא תאים: {{{flavor}}}. טעמים נתמכים: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'גירסת שרת לא מתאימה: {{{version}}}.גירסה מינימלית דרושה: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'שגיאה: מייל שגוי',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'סוג מסמך זה אינו נתמך',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'אימות נכשל',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'המשאב לא נמצא',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'שגיאת שרת',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'אסור',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'שירות לא זמין',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'חלה שגיאה לא צפויה',
    'ERR_MOBILE_UPLOAD' => 'שגיאה בהעלאת קובץ',
    'ERR_MOBILE_FILE_PROCESSING' => 'שגיאה בעיבוד קובץ',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'מתקן אחסון אינו זמין',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'היישום שלך מיושן ולא תואם יותר למופע {{{brandName}}} שאתה מתחבר אליו. האם ברצונך להוריד את הרסה החדשה מה-App Store?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'הגדרות שרת השתנו ויש לטעון מחדש. להמשיך?',
    'ERR_MOBILE_CONFLICT' => 'מישהו כבר ערך את אותו הרישום בשרת. אשר כדי למזג אוטומטית את השינויים שלך או דחה כדי לבטל אותם.',
    'ERR_MOBILE_METADATA_CHANGED' => 'הגדרות שרת השתנו',
    'ERR_MOBILE_FILE_READ' => 'נכשל לקרוא קובץ',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'קובץ לא נמצא',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'לא ניתן לקרוא קובץ',
    'ERR_MOBILE_FILE_ABORTED' => 'הקריאה בוטלה',
    'ERR_MOBILE_FILE_SECURITY' => 'הקובץ נעול',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'הגרסה הסלולרית לא תומכת בפונקציונליות זאת. האם ברצונך לפתוח את גרסת המחשב?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'קובץ גדול מדי. גודל מקסימלי מותר: {{size}}',
    'ERR_OFFLINE' => 'שגיאה לא מקוונת',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'פתיחת אחסון מקומי נכשלה',
    'ERR_OFFLINE_STORAGE_CREATE' => 'יצירת אחסון מקומי נכשל',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'יצירת אחסון מקומי נכשל: המקום נגמר',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'נגמר המקום של האחסון המקומי',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'נקוי בסיס הנתונים נכשל',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'שטח האחסון המקומי נגמר. מומלץ לנקות שטח אחסון. הפעולה עשויה להימשך כמה דקות.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'הבאת רשומות מהשרת נכשלה',
    'ERR_OFFLINE_SYNC_ERROR' => 'שגיאת סנכרון',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'קוספליט בסנכרון',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'לא ניתן להשיג שעת שרת',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'לא ניתן להפעיל מצב לא מקוון. לא ניתן ליצור קשר עם השרת.',
    'LBL_EXPORT_CSV' => 'ייצוא CSV',
    'LBL_ERR_EXPORTING_CSV' => 'הייצוא נכשל',
    'LBL_ERR_EXPORT_ALL' => 'הבאת הנתונים לרשומות שנבחרו נכשלה, נא לנסות שוב',
    'LBL_LIST_SETTINGS_RESTORE' => 'שחזור הגדרות ברירת מחדל',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'לשחזר את השדות?',
    'LBL_LIST_SETTINGS_TITLE' => 'יוצר תצוגת הרשימה',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'שדות זמינים',
    'LBL_LIST_SETTINGS_REMOVE' => 'הסרה',
    'LBL_LIST_SETTINGS_TEXT' => 'יש לגרור שדות ליוצר תצוגת הרשימה ולארגן אותם מחדש כדי לעצב את תצוגת הרשימה של המודול "{{moduleName}}".',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'יש להוסיף לפחות שדה אחד לפריסה.',
    'LBL_LIST_SETTINGS_EMPTY' => 'אין שדות זמינים',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'לא נמצאו שדות תואמים',
    'LBL_LIST_FILTER' => 'חיפוש שדה',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'לקוח דוא"ל',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'לקוח דוא"ל חיצוני',
    'LBL_SUGAR_MOBILE_CLIENT' => 'לקוח דוא"ל של Sugar',
    'LBL_OFFLINE_CAPABILITIES' => 'הפעלת יכולות לא מקוונות',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'מחיקת הצעת המחיר נכשלה.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'הצעת המחיר נמחקה.',
    'LBL_SECURE_MODE' => 'מצב אבטחה מתוגברת',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'יש להפעיל הגדרה זו כדי להסתיר תכנים של Sugar Mobile כשהאפליקציה נמצאת ברקע וכדי למנוע צילומי מסך של האפליקציה בכל עת.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'יש להפעיל הגדרה זו כדי להסתיר תכנים של Sugar Mobile כשהאפליקציה נמצאת ברקע.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'תמיד במצב לא מקוון',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'הנך עובד/ת במצב "תמיד לא מקוון". רוצה להתחבר מחדש?',
    'LBL_RECONNECT' => 'להתחבר מחדש',
    'LBL_STAY_OFFLINE' => 'להישאר במצב לא מקוון',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'המודול שאליו הנך מנסה לגשת אינו זמין ב-Sugar Mobile.',
    'LBL_MOBILE_RELEASE_NOTE' => 'הערות על גרסת Sugar Mobile עבור {{platform}}',
    'LBL_MOBILE_USER_GUIDE' => 'מדריך למשתמש של Sugar Mobile עבור {{platform}}',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'מכיל מילים אלה',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'לא מכיל מילים אלה',
    'LBL_NOTIFICATIONS_CHANNEL' => 'עדכונים',
    'LBL_APPLY_BUTTON_LABEL' => 'החל/י',
    'LBL_ACTION_CREATE_FAILURE' => "שמירת הרשומה נכשלה:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "עדכון הרשומה נכשל:\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'כשל בפענוח חישובי השדות בשרת.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'השדות הבאות אינם חוקיים: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>כל הכבוד.</b> יצרת בהצלחה את {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}".</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>כל הכבוד.</b> עדכנת בהצלחה את הרשומה',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'כשל בהבאת נתוני הדוא"ל מהשרת.',
    'LBL_ASSIGN_SUCCESS' => '<b>כל הכבוד.</b> הרשומה הוקצתה אל {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'לשמור דוא"ל זה כטיוטה?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'לשמור כטיוטה',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'למחוק את הדוא"ל',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'אם תחליט/י שלא לשמור את הטיוטה, תוכן הדוא"ל שלך יאבד.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'בחירת חתימה',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'בחירת תבנית דוא"ל',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'הטבלה תחליף את כל התכנים בדוא"ל זה. בטוח שברצונך להשתמש בטבלה זו ולהחליף את התוכן?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'כתיבת הודעת דוא"ל',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'הדוא"ל שלך מכיל משתנים שיוחלפו בערכים מהרשומה "קשור ל-". עליך לאשר שהשדה "קשור ל-" מוגדר באופן נכון לפני שתשלח/י.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'לא נמצא אף חשבון דוא"ל יוצא. נא לפנות אל מנהל מערכת Sugar שלך.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' ועוד {{{count}}}',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'הוספת דוא"ל',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'נא להקליד את השם או את כתובת הדוא"ל של המשתמש',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (דוא"ל חדש)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'משתנים',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'תבניות דוא"ל',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'תבניות קמפיין',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'תבניות זרימת עבודה',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'תבניות מערכת',
    'LBL_FILTER_EDIT' => 'עריכת מסנן',
    'LBL_FILTER_MY_FILTER' => 'המסנן שלי',
    'LBL_FILTER_MY_FILTER_BY' => 'המסנן שלי על פי {{{filters}}}',
    'LBL_FILTER_SAVE' => 'שמירת המסנן',
    'LBL_SELECT_PARAM' => 'בחירה',
    'LBL_SELECT_MODULES' => 'בורר מודולים',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'בחירת פרמטר נוסף',
    'LBL_FILTER_TEMPORARY' => 'מסנן זמני',
    'LBL_ERROR_FILE_UPLOAD' => 'העלאת קובץ {{{fieldLabel}}} בשם "{{{fileName}}}" נכשלה. {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">הצגת הרשומה שנכשלה</a>',
    'LBL_FILE_UPLOAD_ONE' => 'שמירת הקובץ מתבצעת...',
    'LBL_FILE_UPLOAD_MANY' => 'שמירת קובץ {{{index}}} מתוך {{{total}}} מתבצעת...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'הגדרות ההתראה',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'נהל/י את ההודעות בדחיפה שלך',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "הגדרות ההתראות במכשיר שלך מאפשרות לך לשלוט באופן שבו ההתראות יופיעו.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'הקצאות',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'קבל/י התראות כשרשומות מוקצות לך.',
    'LBL_NOTIFICATION_MENTIONS' => 'אזכורים',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'קבל/י התראות בעת אזכורים שלך ברשומות של יומן ההערות.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'מנהל המערכת לא הוסיף את השדה "יומן הערות" לפריסה זו. נא לפנות למנהל המערכת שלך ב-Sugar.',
    'ERR_NO_PERMISSION_TITLE' => 'נא לאפשר גישה',
    'ERR_NO_CAMERA_PERMISSION_MSG' => 'ל-{{{brandName}}} דרושה גישה למצלמה כדי לאפשר לך לצרף תמונות. נא לאפשר גישה למצלמה בהגדרות המערכת.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'הגדרות',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'משך',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'הזמן שנותר',
    'LBL_LIST_SUPPORT_EXPIRES' => 'התוקף פג',
    'LBL_CASCADE_RLI_EDIT' => 'עדכן/י פריטי שורה פתוחים של הכנסות',
    'LBL_MOBILE_CALENDAR' => 'לוח שנה',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'הגדרות לוח שנה',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'יום תחילת השבוע',
    'LBL_MOBILE_CALENDAR_MODULES' => 'אירועים לתצוגה',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}ש&#39;:{{{minutes}}}דק&#39;',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} שע&#39;',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} דק&#39;',
    'LBL_MOBILE_CALENDAR_TODAY' => 'היום',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => 'הוספת {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'תזמון פעילות',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'נא לאפשר לפחות סוג אירוע אחד.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'כל היום',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'טעינת לוחות השנה נכשלה.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'פעולה זו אינה זמינה ב-Sugar Mobile. רוצה לפתוח את אפליקציית שולחן העבודה במקום זאת?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'בחירת תבנית',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'מיזוג',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'שגיאה: נתוני EXIF חסרים בקובץ HEIC',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'שגיאה: רזולוציית התמונה גבוהה מדי',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'שגיאה: לא ניתן לעבד את התמונה',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'שגיאה: עיבוד התמונה לבד ציור נכשל',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'שגיאה: טעינת הקובץ כתמונה נכשלה',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => 'פריט 1 נבחר',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} פריטים נבחרו',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'בחר/י הכול',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'בחרת {{{count}}} רשומות בתצוגה זו. לבחור את כל הרשומות?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'בחירת {{{count}}} רשומות',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'בטוח שברצונך למחוק את הרשומה(ות) שבחרת?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'מוחק… {{{count}}} מתוך {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'אף דוא"ל חוקי לא נמצא ברשומות שנבחרו',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'מראה',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'השתמש בהגדרת המערכת',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'בהיר',
    'LBL_MOBILE_APP_THEME_DARK' => 'כהה',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'שם קובץ חדש',
    'LBL_ATTACHMENT_RENAME_MSG' => 'שינוי שם הקובץ',
    // Filters related
    'LBL_CREATED_BY_ME' => 'אני יצרתי',
    'LBL_OPERATOR_ONE_OF' => 'אחד מתוך',
    'LBL_OPERATOR_NOT_ONE_OF' => 'לא אחד מתוך',
    'LBL_OPERATOR_CONTAINS' => 'הינו אחד מ',
    'LBL_OPERATOR_CONTAINS_WORD' => 'מכיל',
    'LBL_OPERATOR_NOT_CONTAINS' => 'אינו אחד מ',
    'LBL_OPERATOR_EMPTY' => 'ריק',
    'LBL_OPERATOR_NOT_EMPTY' => 'לא ריק',
    'LBL_OPERATOR_MATCHES' => 'זהה בדיוק',
    'LBL_OPERATOR_STARTS_WITH' => 'מתחיל ב',
    'LBL_OPERATOR_EQUALS' => 'שווה ל',
    'LBL_OPERATOR_NOT_EQUALS' => 'שונה מ',
    'LBL_OPERATOR_GREATER_THAN' => 'גדול מ',
    'LBL_OPERATOR_LESS_THAN' => 'קטן מ',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'גדול או שווה ל',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'קטן או שווה ל',
    'LBL_OPERATOR_BETWEEN' => 'בטווח שבין',
    'LBL_OPERATOR_BEFORE' => 'לפני',
    'LBL_OPERATOR_AFTER' => 'לאחר',
    'LBL_OPERATOR_YESTERDAY' => 'אתמול',
    'LBL_OPERATOR_TODAY' => 'היום',
    'LBL_OPERATOR_TOMORROW' => 'מחר',
    'LBL_OPERATOR_LAST_7_DAYS' => '7 הימים שעברו',
    'LBL_OPERATOR_NEXT_7_DAYS' => '7 הימים הבאים',
    'LBL_OPERATOR_LAST_30_DAYS' => '30 הימים שעברו',
    'LBL_OPERATOR_NEXT_30_DAYS' => '30 הימים הבאים',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'לפני יותר מ-__ ימים',
    'LBL_OPERATOR_LAST_X_DAYS' => '__ הימים האחרונים',
    'LBL_OPERATOR_NEXT_X_DAYS' => '__ הימים הבאים',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'בעוד יותר מאשר __ ימים',
    'LBL_OPERATOR_LAST_MONTH' => 'בחודש שעבר',
    'LBL_OPERATOR_THIS_MONTH' => 'החודש',
    'LBL_OPERATOR_NEXT_MONTH' => 'בחודש הבא',
    'LBL_OPERATOR_LAST_YEAR' => 'בשנה שעברה',
    'LBL_OPERATOR_THIS_YEAR' => 'בשנה זו',
    'LBL_OPERATOR_NEXT_YEAR' => 'בשנה הבאה',
    'LBL_OPERATOR_IS' => 'הינו',
    'LBL_OPERATOR_IS_NOT' => 'אינו',
    'LBL_OPERATOR_AFTER_TODAY' => 'אחרי היום',
    'LBL_OPERATOR_BEFORE_TODAY' => 'לפני היום',
    'LBL_ERROR_FILTER_EMPTY' => 'יש להוסיף למסנן קריטריונים.',
    'LBL_ADD_FILTER' => 'הוספת קריטריונים',
    'LBL_FILTER_NAME' => 'שם המסנן',
    'LBL_FILTER_FIELD' => 'שדה',
    'LBL_FILTER_OPERATOR' => 'אופרטור',
    'LBL_FILTER_VALUE' => 'ערך',
    'LBL_FILTER_SYNC_TO_SERVER' => 'שמירה באפליקציה למחשב שולחני',
    'LBL_FILTER_LOCAL' => 'מסנן &#39;מקומי&#39;',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'ברוך הבא ל {{{brandName}}}.',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'תפריט ראשי',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'פעולות אפשריות לתצוגה',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'חיפוש רשומות גלובלי',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'סנן את הרשומות להצגת הרשומות המועדפות שלי',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'סנן את הרשומות להצגת הרשומות המוקצות לי',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'סמן רשומות מועדפות',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'האירועים הבאים שלי החל מהיום',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'הרשומות ששונו לאחרונה',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'פעולות אפשרויות לרשומה',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'תהנה מכל התוספות החדשות!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'זוהי תפריט הפלוס',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'סגור את תפריט הפלוס',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'בחר פעולה לצפיה בביצוע',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'זהו תפריט הבית',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'סגור את תפריט הבית',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'צפה במודול מסויים',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'התאם את האפליקציה',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'פתח את שוגר בדפדפן',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'צפה בפרופיל שלך',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'זהו דף הפרטים',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'הידע החשוב ביותר על רשומה',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'צפה במידע נוסף וערוך רשונה',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'פעולות אפשרויות לרשומה',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'גש לדף הקודם',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'הכנס לסיור בכל זמן',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'חזור',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'הקלק לפתיחת רשומה קשורה',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'עקוב/אל תעקוב אחרי רשומה',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'הקלק להרחבת המידע',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'תצוגת תפריט ראשי',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'התפריט הראשי נפתח בצד השמאלי של המסך',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'צפה בפרטים',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'הפרטים נפתחים בצד הימיני של המסך',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'השתמש בחצים למטה שסיור מהיר באפשרויות של תפריט זה',

    'LBL_COMMENT_ADD' => 'הוסף הערה',
    'LBL_REQUIRED' => 'חובה',
    'LBL_MORE_BUTTON' => 'עוד',
    'LBL_NO_OPTIONS' => 'אין אפשרויות זמינות',
    'LBL_TRY_AGAIN' => 'נסה שוב',
    'LBL_NEW_RECORDS' => 'נוצרו לאחרונה',
    'LBL_ASSIGNED_TO_ME' => '{{{module}}} שלי',
    'LBL_LISTVIEW_FILTER_ALL' => 'כל {{{module}}}',
    'LBL_UNFAVORITE' => 'הסר מהמועדפים',
    'LBL_ACTIVITY_CREATE' => 'יצירה של {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => 'עדכון של {{{changes}}} במיקום &#39;{{{record}}} {{{module}}}&#39;',
    'LBL_ACTIVITY_LINK' => 'קישור של {{{relatedRecord}}} במיקום &#39;{{{record}}} {{{module}}}&#39;',
    'LBL_ACTIVITY_UNLINK' => 'הסרת קישור לרשומה/ות &#39;{{{relatedRecord}}}&#39; מתוך &#39;{{{record}}} {{{module}}}&#39;',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} עבור {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'מוריד רשומות קשורות...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'תצורת לוח המחוונים שלך השתנתה. האם ברצונך לטעון מחדש?',
    'LBL_RECORDS' => 'רשומות',
    'LBL_DASHBOARDS' => 'לוחות מחוונים',
    'LBL_TEMPLATES' => 'תבניות',
    'LBL_NON_TEMPLATES' => 'לא תבניות',
    'LBL_IS_TEMPLATE' => 'זוהי תבנית',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'הפריטים שנבחרו כוללים תבניות של לוח מחוונים, שאותן אי אפשר לעדכן בעדכון המוני. כדי להמשיך, יש לבטל בחירה בתבניות.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'הפריטים שנבחרו כוללים תבניות של לוח מחוונים, שאותן אי אפשר למחוק במחיקה המונית. כדי להמשיך, יש לבטל בחירה בתבניות.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'חפש {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'תפריט ראשי',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'יצירה מהירה של רשומה חדשה',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'החלק במהירות לקבלת אפשרויות נוספות',
    'LBL_DETAILS' => 'פרטים',
    'LBL_DETAIL_RELATED' => 'קשור אל',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'המודול {{module}} מחייב {{relatedModule}}. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>צור רשומת {{relatedModule}} </a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'ערוך רשומה',
    'LBL_OFFLINE_MENU_SETTINGS' => 'הגדרות למצב לא מקוון',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'הגדרות לפתרון באגים',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'סך רשומות',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'הורדה אחרונה',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'אין אפשרות להוריד את הקובץ.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'טעינת לוחות המחוונים מהשרת נכשלה',
    'ERR_FILTERS_FETCHING' => 'לא ניתן להביא את המסננים',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'הצפנת אחסון מקומי נכשלה',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'מצפין נתונים לא מקוונים. פעולה זו עשויה להימשך מספר דקות.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'הצפנת נתונים לא מקוונים הושלמה.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'אין לך הרשאה למודול &#39;{{{module}}}&#39;.',
    'LBL_SKIP' => 'דלג',
    'LBL_CONTINUE' => 'המשך',
    'LBL_ENABLE' => 'הפעל',
    'LBL_MOBILE_TRIAL_UNTIL' => 'ניסיון עד',
    'LBL_MOBILE_SDK_VERSION' => 'גרסת SDK',
    'LBL_LOG_LEVEL' => 'רמת תיעוד',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'תצורת ההתחברות הוגדרה מחדש.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'תקופת הניסיון שלך הגיעה לסיומה.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'השרת אינו תומך בחיבור מאובטח. אנא כבה חיבור מאובטח.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'השרת תומך בחיבור מאובטח. אנא הפעל חיבור מאובטח.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'החיבור שלך אינו מאובטח. פנה למנהל המערכת.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'הגדרות התחברות',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'הגדר את מופע &#39;{{{brandName}}}&#39;',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'כדי שהיישום יוכל לעבוד, עליך להקליד את כתובת ה- URL של מופע &#39;{{{brandName}}}&#39;. אם ברשותך את כתובת ה- URL של המופע, אנא פנה למנהל המערכת.',
    'LBL_FACEID' => 'מזהה פנים',
    'LBL_TOUCHID' => 'מזהה מגע',
    'LBL_ENABLE_TOUCHID' => 'הפעל את &#39;{{{biometryType}}}&#39;',
    'LBL_SETUP_TOUCHID' => 'הגדר את &#39;{{{biometryType}}}&#39;',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'התחבר בנגיעת אצבע',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "אין הגדרה ל'{{{biometryType}}}' במכשירך. \n\nעבור אל הגדרות המכשיר כדי להגדיר את '{{{biometryType}}}'. לאחר ההתקנה, הפעל את '{{{biometryType}}}' עבור {{{brandName}}} ב'תפריט ראשי' > 'הגדרות'.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'השימוש ב&#39;{{{biometryType}}}&#39; עם {{{brandName}}} יאפשר לך להשתמש במזהה הביומטרי שלך במקום להזין ססמה כדי לגשת ל{{{brandName}}}.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'האם ברצונך להמשיך עם &#39;{{{biometryType}}}&#39;?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'הזן ססמה עבור {{{brandName}}} כדי להפעיל את &#39;{{{biometryType}}}&#39;',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'התקנה',
    'LBL_MDM_CONFIRM_CHANGE' => 'הגדרת התצורה של היישום השתנתה מ&#39;מנהל מכשיר נייד&#39;. אנא התחבר מחדש כדי להחיל את השינויים.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'אנא תן ל{{{brandName}}} גישה למיקומך באמצעות הגדרות המכשיר.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'המיקום הנוכחי אינו זמין',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "תם הזמן הקצוב לאחזור במיקום הנוכחי. \n נסה שוב.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'סמני האתר אינם זמינים',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'הקואורדינטות של האתר אינן חוקיות',
    'ERR_MOBILE_INVALID_PASSWORD' => 'ססמה לא חוקית.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'היישום שלך מיושן ולא תואם יותר למופע {{{brandName}}} שאליו אתה מתחבר. האם ברצונך לעדכן אותו?',
    'LBL_MOBILE_BY' => 'על ידי',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'מסנן זה אינו זמין במצב לא מקוון',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'רשומות לא מקוונות',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'הורד הגדרות',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'הורד את הרשומות המוקצות, המועדפות ואלו שאחריהן אתה עוקב לגישה לא מקוונת. תוכל לעדכן את העדפותיך בהגדרות הלא מקוונות.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'הורדת הרשומות שלך הסתיימה. כעת תוכל לגשת אליהן במצב לא מקוון.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "לא כל הרשומות שלך הורדו. \n האם ברצונך לנסות שוב?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'השתמש בנתונים סלולריים',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'לא כרגע',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'ההורדה הושהתה ותחודש כשתפתח שוב את היישום.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'מוריד {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'עדכן רשומות אחרונות',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'מחכה לחיבור',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'מושהה',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'עוצר',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'הורד',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'השהה',
    'LBL_BULK_LOAD_BTN_RESUME' => 'המשך',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'רק חיבור WiFi משמש כברירת מחדל',
    'LBL_NPS_RATING_MSG' => "איך היית מדרג את החוויה שלך עם \n{{{productName}}}?",
    'LBL_NPS_THANKS_MSG' => 'תודה על המשוב ששלחת!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'אכפת לך לדרג את המוצר ב- App Store?',
    'LBL_NPS_NO_THANKS' => 'לא, תודה',
    'LBL_NPS_NOT_NOW' => 'לא כרגע',
    'LBL_NPS_RATE_NOW' => 'דרג עכשיו',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'הרשת אינה זמינה. ניתן להשתמש ביישום גם במצב לא מקוון',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'השינויים שביצעת יסונכרנו כשתתחבר לרשת.<a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>הצג פרטים</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'קיימים נתונים לא מסונכרנים. אנא בדוק את <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>יומן הרישום של הצעות המחיר</a>',
    'LBL_CONVERT' => 'המר',
    'LBL_CONVERT_LEAD' => 'המר ליד',
    'LBL_SEARCH_EXISTING_RECORD' => 'חפש {{{this}}} קיים/ת',
    'LBL_DUPLICATES_CHECK_FAILED' => 'בדיקת כפילויות נכשלה',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'האם ברצונך להעביר את הפעילויות הקשורות לרשומת איש הקשר?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'המרת בהצלחה את הליד &#39;{{{name}}}&#39;',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'לא נמצאו כפילויות.',
    'ERR_LEAD_CONVERSION_FAIL' => 'המרת הליד נכשלה',
    'LBL_SELECT_DUPLICATE_RECORD' => 'בחר מתוך &#39;{{{modulePlural}}}&#39; כפולים/ות',
    'LBL_SELECTED_EXISTING_RECORD' => '&#39;{{{moduleSingular}}}&#39; נבחר/ה',
    'LBL_CREATED_NEW_RECORD' => 'צור &#39;{{{moduleSingular}}}&#39; חדש/ה',
    'LBL_VO_BACK_BTN' => 'לחצן &#39;חזור&#39;',
    'LBL_VO_HOME_BTN' => 'לחצן &#39;בית&#39;',
    'LBL_VO_DASHBOARD_BTN' => 'לחצן &#39;לוח מחוונים&#39;',
    'LBL_VO_SEARCH_BTN' => 'לחצן &#39;חיפוש&#39;',
    'LBL_VO_RIGHT_MENU_BTN' => 'לחצן &#39;תפריט ימני&#39;',
    'LBL_VO_ADD_BTN' => 'לחצן &#39;הוסף&#39;',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'הנחה',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'בחר אפליקציית מיפוי',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'ל{{entityName}} שנבחר יש ערכים קשורים: {{localizedFieldNames}}. בטל כדי לשמור את הערכים הקיימים. אשר כדי להחליף בערכים חדשים.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'הצפנת נתונים מופעלת.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'הליד שנבחר כבר הומר.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'פעולה זו זמינה רק כשהמכשיר במצב מקוון',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'האם אתה בטוח שברצונך ליצור הזדמנות מהצעת המחיר?',
    'LBL_TAG_ADD' => 'הוסף תג',
    'LBL_TAG_ENTER_TAG_NAME' => 'הזן תג',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'כשהמכשיר במצב לא מקוון לא ניתן לסנן לפי תגים.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'הצג את התגובה המלאה',
    'LBL_COMMENT_VIEW' => 'הצג תגובה',
    'LBL_PMSE_LABEL_DUEDATE' => 'תאריך יעד',
    'LBL_PMSE_DUE' => 'לביצוע עד',
    'LBL_PMSE_DUE_ON' => 'לביצוע עד',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'יש ליצור {{conversionParentModuleName}} תחילה',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'חסרות רשומות נדרשות: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'בחר איכות תמונה. גודל התמונה ישתנה בהתאם לפני השמירה בשרת. הערך שנבחר ישמש כברירת מחדל עבור כל הפעולות הדומות בעתיד.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'מתבצעת הערכה של גודל הקובץ...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'גודל הקובץ המשוער הוא',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'איכות תמונה',
    'LBL_IMAGE_QUALITY_BEST' => 'גודל מקורי',
    'LBL_IMAGE_QUALITY_GOOD' => 'איכות טובה',
    'LBL_IMAGE_QUALITY_POOR' => 'גודל קטן',
    'LBL_IMAGE_QUALITY_BTN' => 'דחיסה: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'שדות רשימה ב-{{module}}',
    'LBL_LIST_RESET_FIELDS' => 'איפוס לברירות המחדל',
    'LBL_LIST_NOT_ENOUGH' => 'יש להגדיר לפחות שדה פעיל אחד.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'כדי שתוכל לעבוד עם הפעלה של SugarCRM, עליך להיכנס ולקבל הרשאות.',
    'LBL_SELECTING_EXISTING_RECORD' => 'בחירת {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'יצירת {{{moduleSingular}}} חדש',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'גודל תמונה',
    'LBL_COPY_ADDRESS' => 'העתק כתובת',
    'LBL_OPEN_IN' => 'פתח באמצעות',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'לא נבחר אף קובץ.',
    'LBL_ATTACHMENT_ADD' => 'צרף',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'באפליקציה זו נעשה שימוש בקובצי Cookie',
    'LBL_USE_COOKIES_CONFIRM' => 'באפליקציה זו נעשה שימוש בקובצי Cookie כדי לספק לך חוויה משופרת. המשך פעולה יהווה את הסכמתך לשימוש בקובצי Cookie בהתאם למדיניות הפרטיות שלנו.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'אתה משתמש במופע Sugar שלא יהיה תואם ל-Sugar Mobile בגרסה לנייד שתושק בקרוב. בקש ממנהל המערכת לשדרג את Sugar בהקדם האפשרי.',
    'ERROR_TAG_NAME_INVALID' => 'שם תג אינו יכול להכיל תווי "{{{forbiddenChars}}}"',
    'ERROR_NO_TAGS_FOUND' => 'לא זמינים תגים התואמים את {{{searchQuery}}}',
    'ERR_PA_RECORD_INVALID' => 'רשומת {{{moduleName}}} כוללת ערך לא חוקי אחד (או יותר) ולא ניתן לשמור אותה. האם ברצונך לערוך את הרשומה כדי לבצע פעולת {{{actionLabel}}}?',
    'ERR_MOBILE_METADATA_RELOAD' => 'מנהל מערכת ביצע שינויי תצורה בהפעלת Sugar שלך. לחץ על &#39;אישור&#39; כדי לסנכרן את תצורת האפליקציה עם השרת.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'באפליקציה זו נעשה שימוש בקובצי Cookie',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'סמן כדי לאשר (חובה)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'באפליקציה זו נעשה שימוש בקובצי Cookie כדי לספק לך חוויה משופרת. המשך פעולה יהווה את הסכמתך לשימוש בקובצי Cookie בהתאם ל<a href="{{href}}" target="_blank">מדיניות הפרטיות</a> שלנו.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'תצוגת רשומה מאפשרת לצפות בפרטי הרשומה',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'פתקים מאפשרים לשתף פעולה עם משתמשי פורטל אחרים ועם נציגי תמיכה',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'הקלק כאן להוספת פתק לרשימה',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'הקלק על איקונים אלו לצפיה בפרטים של הפתקים המצורפים',

    //for portal
    'LBL_PORTAL_HOME' => 'לוח מחוונים בדף הבית',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'כל האירועים הפתוחים',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'אירועים שנפתרו לאחרונה',
    'LBL_PORTAL_SEARCH' => 'חפש לפי שם, מספר',
    'LBL_SIGNUP_BUTTON_LABEL' => 'הרשם',
    'LBL_PORTAL_NO_EMAIL' => 'לא קיבלת דוא"ל?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'שכחתי את הסיסמה',
    'LBL_PORTAL_FORGOT_USERNAME' => 'שכחתי את שם המשתמש',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'הזן את הסיסמה פעמיים. חייבת להיות התאמה בין הסיסמאות.',
    'LBL_PORTAL_RESET_PASSWORD' => 'אפס סיסמה',
    'LBL_PORTAL_REENTER_PASSWORD' => 'הזן את הסיסמה שוב',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'אין התאמה בין הסיסמאות, נסה שוב',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'איפוס הסיסמה התבצע בהצלחה.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'אירעה שגיאה. צור בקשה חדשה לאיפוס סיסמה.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'הרשמה',
    'LBL_PORTAL_SIGNUP_TITLE' => 'תודה שנרשמת',
    'LBL_PORTAL_SIGNUP' => 'ניידע אותך לאחר שנאמת את הפרטים.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'שם פרטי',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'שם משפחה',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'שם משתמש',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'כתובת דוא"ל',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (אופציונאלי)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'מדינה',
    'LBL_PORTAL_SIGNUP_STATE' => 'מדינה',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'שם חברה',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'שם משרה (אופציונאלי)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'סיסמה',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'אשר סיסמה',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'שכחתי את פרטי הכניסה',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'שכחת סיסמא?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'צור קשר עם מנהל Sugar ובקש ממנו לאפס את סיסמתך.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'שם משתמש',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'סיסמה',
    'LBL_PORTAL_LOADING' => 'טוען',
    'LBL_PORTAL_SAVING' => 'שומר',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'דף לא זמין',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "אפשרות זו לא זמינה כעת",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'הצג תוצאות חיפוש עבור "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'לא קיבלת דוא"ל?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'לקבלת סיוע, או ליצירת קשר אתנו, השתמש בכל שיטה רצויה מבין השיטות הבאות: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'טלפון: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'דוא"ל: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'ווב: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'האם אתה בטוח שברצונך לסגור את הצ&#39;אט?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'צור פתק או הוסף צרופה',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'הוסף פתק',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'ניסיון הכניסה שלך כשל. נסה שנית.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'פרטים שגויים',
    'LBL_PORTAL_INVALID_GRANT' => 'תוקף ההפעלה שלך פג. התחבר שוב.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'תוקף ההפעלה פג',
    'LBL_PORTAL_AUTH_FAILED' => 'אישור לקוח נכשל',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'לקוח שגוי',
    'LBL_PORTAL_INVALID_REQUEST' => 'הבקשה לא תקינה. אנא פנה לתמיכה טכנית',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'בקשה לא חוקית',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'חלף הזמן לבקשה',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'חלף הזמן לבקשה',
    'LBL_PORTAL_UNAUTHORIZED' => 'אינך מורשה לגשת למשאב זה',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'לא מורשה',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'משאב אינו זמין',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'אסור',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'לא ניתן להתשמש בשיטת HTTP במשאב זה. אנא פנה לתמיכה טכנית',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'שיטה לא מורשת',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'שגיאה בבקשה או שפרמטר חסר או לא תקין. אנא פנה לתמיכה טכנית',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'שגיאה',
    'LBL_PORTAL_MIN_MODULES' => 'לכל הפחות, תצטרך להפעיל את המודול מקרים, באגים או בסיס ידע כדי להשתמש ביישום זה.',
    'LBL_PORTAL_ERROR' => 'שגיאה',
    'LBL_PORTAL_ROUTE_ERROR' => 'בעיה בטעינת המודול. אנא נסה שנית או תמה לתמיכה.',
    'LBL_PORTAL_OFFLINE' => 'האפליקציהלא זמינה כעת. נא לפנות לתמיכה.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'משנה סיסמא',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'שם המשתמש כבר קיים במערכת. בקש קישור לאיפוס סיסמה או בחר שם משתמש אחר.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'כתובת הדוא"ל שציינת אינה חוקית.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'הסיסמאות לא תואמות.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'מסוף שירות',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => '- סקירה כללית',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'שחזור לוח המחוונים המוגדר כברירת מחדל',
    'LBL_UNTITLED' => 'ללא כותרת',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'מסוף חידושים',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'סקירה',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'שלב/סטטוס',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'שם/שם חשבון',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'לוח מחוונים לריבוי ערוצים',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'לקוח',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} בשעה {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'הדפדפן שלך אינו תומך ב-SugarLive. יש להשתמש ב-Google Chrome או ב-Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'נוצר <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> המכיל את פרטי ההמרה שלך.',
    'LBL_OMNICHANNEL_SUBJECT' => 'נושא',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'תיאור',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'סיכום הודעה',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'סיכום שיחה',
    'LBL_OMNICHANNEL_LINK_TO' => 'קישור {{fromModule}} ל-{{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'קישור ל-{{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'מקושר',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'הדפדפן שלך אינו תומך בשיחות. יש להשתמש ב-Google Chrome או ב-Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'לקבלת עזרה, פנה אל מנהל המערכת שלך ב-Sugar.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'קביעת תצורה',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'לפני ביצוע שיחה יוצאת, יש לסיים את קביעת התצורה של SugarLive.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'לפני פתיחת SugarLive, יש לסיים את קביעת התצורה של SugarLive.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'לפני קביעת התצורה של SugarLive, הגדר את עצמך כ"לא מחובר" ב-SugarLive.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'תצוגה קומפקטית',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'תצוגה מלאה',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'לוח מחוונים של BDR',
    'LBL_SALES_MANAGER_CONSOLE' => 'לוח מחוונים של מנהל מכירות',
    'LBL_SALES_REP_CONSOLE' => 'לוח מחוונים של נציג מכירות',
    'LBL_MARKETING_CONSOLE' => 'לוח מחוונים של שיווק',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'לוח מחוונים של הצלחת לקוחות',
    'LBL_EXECUTIVE_CONSOLE' => 'לוח מחוונים של מנהל בכיר',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'שחזור הלשונית לברירת המחדל',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'הגדרת חלונית הסיכום',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'פרופיל משתמש',
    'LBL_WIZ_COMPLETE_TITLE' => 'התקנה הושלמה',
    'LBL_SETUP_COMPLETE_INFO' => 'התחל להשתמש בשוגר!',
    'LBL_SETUP_USER_INFO' => 'הגדר את פרטי המשתמש שלך',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'הגדרות משתמש מקומיות',
    'LBL_SETUP_USER_LOCALE_INFO' => 'הגדר איזור זמן, תאריך ותצורת שמות',
    'LBL_WIZ_START_SUGAR' => 'התחל את שוגר',
    'LBL_WIZ_FIRST_NAME' => 'שם פרטי',
    'LBL_WIZ_LAST_NAME' => 'שם משפחה',
    'LBL_WIZ_EMAIL' => 'דואר אלקטרוני',
    'LBL_WIZ_TIMEZONE' => 'אזור זמן',
    'LBL_WIZ_TIMEFORMAT' => 'תבנית זמן',
    'LBL_WIZ_DATE_FORMAT' => 'תבנית תאריך',
    'LBL_WIZ_NAME_FORMAT' => 'תבנית שם',
    'LBL_SETUP_PROGRESS' => 'מתבצעת התקנה',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'אימון שוגר',
    'LBL_WIZ_DOCUMENTATION' => 'תיעוד',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'מרכז מידע',
    'LBL_WIZ_FORUMS' => 'פורומים',
    'TPL_TIMEZONE_DIFFERENT' => 'אזור הזמן בדפדפן שלך לא תואמת את אזור הזמן השמור {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'התאם את אזור הזמן שלך',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'הגדרות מקומיות',
    'LBL_WIZ_EMAIL_SETTINGS' => 'הגדרות דוא"ל',
    'LBL_WIZ_IMPORT_DATA' => 'ייבוא נתונים',
    'LBL_WIZ_CREATE_USERS' => 'צור משתמש',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'הגדרות מערכת',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'סטודיו',

    'LBL_CSP_ERROR_MESSAGE' => 'הערכים שהזנת אינם נתמכים או שהפורמט שלהם אינו עומד בדרישות. לצפייה ברשימה של הפורמטים והערכים המקובלים עבור שדות, עיין במסמכי העזרה של ה<a href="{{linkToDocumentation}}" target="_blank">מערכת</a>.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'תוכן זה לא אושר. עדכן את <a href="{{linkToDocumentation}}" target="_blank">ההגדרות של מדיניות אבטחת תוכן</a> במערכת.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'תוכן זה לא אושר. בקש ממנהל המערכת לעדכן את <a href="{{linkToDocumentation}}" target="_blank">ההגדרות של מדיניות אבטחת תוכן</a> במערכת. ברגע שההגדרות יעודכנו, תצטרך לרענן את הדפדפן כדי שהשינויים ייכנסו לתוקף.',

    // For password related labels
    'LBL_PASSWORD' => 'סיסמה',
    'LBL_CHANGE_YOUR_PASSWORD' => 'שינוי הסיסמה שלך',
    'LBL_PASSWORD_REQUIREMENTS' => 'דרישות סיסמה',
    'LBL_CURRENT_PASSWORD' => 'סיסמה נוכחית',
    'LBL_NEW_PASSWORD1' => 'סיסמה חדשה',
    'LBL_NEW_PASSWORD2' => 'אשר סיסמה',
    'LBL_PASSWORD_CHANGED' => 'הצלחת להחליף את סיסמתך',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'אנא הזן את אישור הסיסמה שלך.',
    'ERR_ENTER_NEW_PASSWORD' => 'אנא הזן את הסיסמה החדשה שלך.',
    'ERR_ENTER_OLD_PASSWORD' => 'אנא הזן את הסיסמה הנוכחית שלך.',
    'ERR_REENTER_PASSWORDS' => 'הסיסמאות אינן תואמות',
    'ERR_PASSWORD_MISMATCH' => 'הסיסמא שהכנסת אינה תואמת את הסיסמא שבמערכת',
    'LBL_CANNOT_SEND_PASSWORD' => 'לא ניתן לשלוח סיסמה',
    'LBL_REQUEST_PASSWORD' => 'בקש סיסמא',
    'LBL_RESET_PASSWORD' => 'אפס סיסמה',
    'LBL_RESET_PASSWORD_MESSAGE' => 'הזן את שם המשתמש שלך ואנו נשלח אליך קישור לאיפוס הסיסמה.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'בדוק אם קיבלת דוא"ל <br><br> שלחנו הנחיות לאיפוס סיסמה אל כתובת הדוא"ל הרשומה אצלנו עבורך.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'שגיאה: הייתה בעיה בעדכון סיסמא למשתמש זה',
    'LBL_INCORRECT_PASSWORD' => 'שגיאה: סיסמא שגויה',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'הסיסמה שהזנת לא עומדת בדרישות ליצירת סיסמה. נסה שוב.',
    'LBL_PASSWORD_MIN_LENGTH' => 'האורך המינימלי הוא {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'האורך המקסימלי הוא {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'חייבת להכיל אות גדולה אחת (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'חייבת להכיל אות קטנה אחת (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'חייבת להכיל ספרה אחת (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'חייבת להכיל תו מיוחד אחד (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'אסור שהסיסמה תתאים לתבנית הביטוי הרגיל: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'העדפת שפה:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'לא ניתן היה לשלוח דוא"ל לאיפוס סיסמה.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'בחר דוח',
    'LBL_REPORT_AUTO_REFRESH' => 'רענן באופן אוטומטי',
    'LBL_REPORT_EDIT' => 'ערוך דוח נבחר',
    'LBL_REFRESH_LIST_AND_CHART' => 'רענן רשימה ותרשים',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'אף תרשים אינו זמין.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'דוח זה אינו כולל אף מסנן.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'הסתרת מסננים לזמן ריצה בלבד. עיין/י במסננים המתקדמים.',
    'LBL_RUNTIME_FILTERS' => 'מסנני זמן ריצה',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'התאריך אינו תואם לתבנית התאריך המועדפת על המשתמש: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'אין בחלונית זו מסנני זמן ריצה',
    'LBL_DASHBOARD_FILTER_GROUP' => 'מסנן חדש',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'יש לבחור ערך אחד לפחות.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'איפוס למסנני ברירת המחדל',
    'LBL_COPY_FILTER_SUMMARY' => 'העתקת סיכום המסנן',
    'LBL_APPLY_FILTERS' => 'הפעלה',
    'LBL_REPORTS_FILTERS' => 'מסננים',
    'LBL_RUNTIME_FILTERS_INVALID' => 'לא ניתן להפעיל מסננים לזמן ריצה בגלל ערכים לא חוקיים',
    'LBL_RUNTIME_FILTERS_COPIED' => 'סיכום המסנן הועתק ללוח שלך.',
    'LBL_ADVANCED_FILTERS' => 'מסננים מתקדמים',
    'LBL_ADVANCED_OR_DESC' => 'כלול/י כאשר כל תנאי שהוא מתקיים',
    'LBL_ADVANCED_AND_DESC' => 'כלול/י כשכל התנאים מתקיימים',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'זהו מסנן עיצוב מקורי',
    'LBL_AND_UPPERCASE' => 'וגם',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'תכונה זו אינה זמינה במצב תצוגה מקדימה',
    'LBL_REPORT_DEFAULT_NAME' => 'דוח ללא כותרת',
    'LBL_REPORT_QUERY' => 'שאילתא',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'קשור לרשומה הנוכחית',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'שדה מקושר',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'שדה מקושר לא יכול להיות ריק',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'לא נבחר דוח.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'תרשים קו לא תואם לדוח זה',
    'LBL_REPORT_DASHLET' => 'חלונית דוח',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'טבלת נתונים',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'מסנני זמן ריצה',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'תצוגה מקדימה של טבלת נתונים',
    'LBL_REPORTS_DASHLET_CHART' => 'תרשים',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'תצוגה מקדימה של תרשים',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'תצוגה מקדימה של מסנן',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'הדוח שנבחר אינו תומך בתרשים.',
    'LBL_REPORTS_DASHLET_LABELS' => 'תוויות',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'הצג ספירת רשומות כוללת',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'סדר מיון',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'תצוגת ברירת מחדל שנבחרה',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'סדר מיון תרשים ראשי',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'סדר מיון תרשים משני',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'אין קישורים של {{module}} לדוח הנבחר',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'לא זמין לדוח מסוג זה',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'התכונה זמינה רק בכרטיסיית התרשים',
    'LBL_REPORTS_CHART_TYPE' => 'סוג תרשים',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'מיקום ערך בתרשים עמודות',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'הצג סכום',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'הצג מקרא',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'הצג תווית ציר X',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'הצג תווית ציר Y',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'מגבלה על הצגת שורות',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'אין לך הרשאה להשתמש במסנני זמן ריצה.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'לא ידוע',
    'ERR_HTTP_DEFAULT_TITLE' => 'שגירה לא ידועה',
    'ERR_HTTP_DEFAULT_TEXT' => 'שגיאה לא ידועה.',
    'ERR_HTTP_DEFAULT_ACTION' => 'חזור לדף הקודם',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'שגיאה: בקשה לא חוקית',
    'ERR_HTTP_400_TEXT_LINE1' => 'הדפדפן שלך שלח בקשה שהשרת לא הצליח להבין אותה.',
    'ERR_HTTP_400_TEXT_LINE2' => 'אנא צור קשר עם מנהל המערכת שלך ב-Sugar לפרטים נוספים.',
    'ERR_HTTP_400_ACTION' => 'חזור לדף הקודם',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'הנתונים לא זמינים',
    'ERR_HTTP_404_TEXT_LINE1' => 'דף לא קיים או שאין לך הרשאה לגשת לדף זה.',
    'ERR_HTTP_404_TEXT_LINE2' => 'אנא נסה שנית. אם השגיאה נמשכת, אנא פנה למנהל ה-Sugar שלך.',
    'ERR_HTTP_404_ACTION' => 'חזור לדף הקודם',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 שגיאת שרת פנימית',
    'ERR_HTTP_500_TEXT_LINE1' => 'השרת נתקל בשגיאה ולא הצליח להשלים את הבקשה שלך.',
    'ERR_HTTP_500_TEXT_LINE2' => 'אנא נסה שנית. אם השגיאה נמשכת, אנא פנה למנהל ה-Sugar שלך.',
    'ERR_HTTP_500_ACTION' => 'אנה פנה לתמיכה',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP‏: 502 שגיאת שרת פנימית',
    'ERR_HTTP_502_TEXT_LINE1' => 'השרת נתקל בשגיאה זמנית ולא הצליח להשלים את הבקשה שלך.',
    'ERR_HTTP_502_TEXT_LINE2' => 'נא נסה שנית. אם השגיאה נמשכת, פנה למנהל מערכת Sugar שלך.',
    'ERR_HTTP_502_ACTION' => 'פנה לתמיכה הטכנית.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP‏: 503 שגיאת שרת פנימית',
    'ERR_HTTP_503_TEXT_LINE1' => 'השרת אינו זמין כדי להשלים את בקשתך.',
    'ERR_HTTP_503_TEXT_LINE2' => 'נא נסה שוב מאוחר יותר. אם השגיאה נמשכת, פנה למנהל מערכת Sugar שלך.',
    'ERR_HTTP_503_ACTION' => 'פנה לתמיכה הטכנית.',

    'ERR_RENDER_FAILED_TITLE' => 'תצוגת ביצוע נכשלה',
    'ERR_RENDER_FAILED_MSG' => 'תצוגת ביצוע נכשלה',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'ביצוע שדה נכשל',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'ביצוע שדה {0} נכשל',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'אין גישה',
    'ERR_NO_VIEW_ACCESS_REASON' => 'אין לך הרשאה לגשת לדף זה',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'פנה לתמיכה לבקשת גישה',
    'ERR_NO_VIEW_ACCESS_MSG' => 'פנה לתמיכה לבקשת גישהלתצוגה זו עבור מודול  {0}',

    'ERR_LAYOUT_RENDER_TITLE' => 'תצוגת ביצוע נכשלה',
    'ERR_LAYOUT_RENDER_MSG' => 'אופס! אנו לא מבצעים כלום. אנא נסה שוב או פנה לתמיכה',
    'ERR_INTERNAL_ERR_MSG' => 'שגיאה פנימית',
    'ERR_GENERIC_TITLE' => 'שגיאה',
    'ERR_CONTACT_TECH_SUPPORT' => 'פנה לתמיכה',

    'LBL_SYNCED_RECURRING_MSG' => 'לא ניתן לערוך רשומה זו כיוון שהיא סונכרנה מלקוח חיצוני',
    'LBL_EXISTING' => 'נמצא',
    'LBL_PANEL_DEFAULT' => 'ברירת מחדל',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'תגובת שרת שגויה',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'שגיאה קרתה עקב פעולת AssignTo.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'אין לך גישה ל-"{{name}}". אנא צור קשר עם מנהל המערכת שלך.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'שנה {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'פעולות נוספות',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'אזהרה',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'התעלם מכפילות ושמור',
    'LBL_RESTORE' => 'אפס מקורי',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'רשומות שסומנו למחיקה',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'מציג רשומות הקשורות לבקשת פרטיות נתונים לפעולת '
        . 'מחק מידע.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS פיד',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'השאר מעודכן על ידי הוספת RSS או בלוג חיצוני',
    'LBL_RSS_FEED_URL' => 'כתובת פיד',
    'LBL_RSS_FEED_AUTHOR' => 'מחבר:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'מספר כניסות לתצוגה',
    'LBL_ERR_LOADING_RSS_FEED' => 'כישלון בטעינת הזנת RSS',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'הפריטים שלי',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'הפריטים של הצוות',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'מאפשר למשתמשים להוסיף אפליקציות סוכר ללוח מחוונים',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'הסטוריה',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'דשלט הסטוריה מציג פגישות שנערכו, לוגים של שיחות, מיילים שהתקבלו ונשלחו',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'דואר אלקטרוני',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'דואר אלקטרוני',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'ההיסטוריה שדלי',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'ההיסטוריה של הצוות',
    'LBL_UNASSIGNED' => 'לא מוקצה',
    'LBL_ARCHIVE_EMAIL' => 'ארכב דואר אלקטרוני',
    'LBL_EMAIL_ARCHIVED' => 'ארכיון מייל',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'צור דוא"ל לארכיון',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'פעילויות מתוכננות',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'דשלט פעילויות מתוכננות מציג פגישות ושיחות מתוכננות',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'היום',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'עתיד',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'הפעילויות שלי',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'פעילויות צוות',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'התקיים',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'אתה בטוח שברצונך לסמן את {0} כסגור?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'משימות פעילות',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'דשלט משימות פעילות מציג משימות קרובות',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'לביצוע כעת',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'קרובים',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'לעשות',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'הושלם',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'אתה בטוח שברצונך לסגור את {0} כהושלם?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'המשימות שלי',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'משימות צוות',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'הייתה כתובת דוא"ל נוספת ברישום שאתה עורך, היא כעת העיקרית והוזנה למטה.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'משימות לא פעילות',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'דשלט משימות מציג משימות דחויות ומשימות סגורות',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'נדחה',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'הושלם',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'עודכן לאחרונה {{relativetime}} ב {{date}} ב {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'המשימות שלי',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'משימות צוות',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'אירועים שהצגתי לאחרונה',

    'LBL_REPORT_DASHLET_TITLE_12' => 'אירועים פתוחים לפי משתמש לפי סטטוס',
    'LBL_REPORT_DASHLET_TITLE_125' => 'אירועים חדשים לפי מרכז עסקים לפי שבוע',
    'LBL_REPORT_DASHLET_TITLE_126' => 'אירועים שנוצרו לאחרונה',
    'LBL_REPORT_DASHLET_TITLE_127' => 'אירועים חדשים לפי שכבת לקוח לפי שבוע',
    'LBL_REPORT_DASHLET_TITLE_128' => 'אירועים פתוחים לפי שכבת לקוח ועדיפות',
    'LBL_REPORT_DASHLET_TITLE_129' => 'סך אירועים שנפתרו החודש לפי מרכז עסקים',
    'LBL_REPORT_DASHLET_TITLE_130' => 'סך אירועים שנפתרו החודש לפי ספק',
    'LBL_REPORT_DASHLET_TITLE_131' => 'רשימה של אירועים שנפתרו לאחרונה',
    'LBL_REPORT_DASHLET_TITLE_132' => 'האירועים שלי שנפתרו החודש לפי שבוע',
    'LBL_REPORT_DASHLET_TITLE_133' => 'האירועים שלי שתוקפם פג היום ואירועים שפג תוקפם',
    'LBL_REPORT_DASHLET_TITLE_134' => 'כל האירועים שתוקפם פג היום ואירועים שפג תוקפם',
    'LBL_REPORT_DASHLET_TITLE_135' => 'האירועים הפתוחים שלי לפי תאריך להמשך טיפול',
    'LBL_REPORT_DASHLET_TITLE_136' => 'כל האירועים הפתוחים לפי תאריך להמשך טיפול',
    'LBL_REPORT_DASHLET_TITLE_137' => 'האירועים הפתוחים שלי לפי סטטוס',
    'LBL_REPORT_DASHLET_TITLE_138' => 'האירועים שלי בשבוע האחרון לפי סטטוס',
    'LBL_REPORT_DASHLET_TITLE_139' => 'סטטוס של משימות פתוחות שהוקצו על ידי',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP או Old REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar Workflow',
    'LBL_AUDIT_SUBJECT_USER' => 'משתמש',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web to Lead',

    //common chart strings
    'LBL_CHART' => 'תרשים',
    'LBL_CHART_NO_DATA' => 'אין נתונים זמינים',
    'LBL_CHART_LEGEND_CLOSE' => 'הסתר מקרא',
    'LBL_CHART_LEGEND_OPEN' => 'הצג מקרא',
    'LBL_CHART_CONTROLS_CLOSE' => 'הסתר פקדים',
    'LBL_CHART_CONTROLS_OPEN' => 'הצג פקדים',
    'LBL_CHART_UNDEFINED' => 'לא מוגדר',
    'LBL_CHART_NO_LABEL' => 'לא מוגדר',
    'LBL_CHART_AMOUNT' => 'סכום',
    'LBL_CHART_COUNT' => 'מנה',
    'LBL_CHART_PERCENT' => 'אחוז',
    'LBL_CHART_GROUP' => 'קבוצה',
    'LBL_CHART_DATE' => 'תאריך',
    'LBL_CHART_KEY' => 'מפתח',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'סוג תרשים',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'הצג כותרת',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'הצג סך הכל',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'הצג תווית ציר X',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'הצג תווית ציר Y',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'שיטות תצוגת שנתות',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'שנתות מעטפת',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'שנתות סטייג&#39;ר',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'שנתות סיבוב',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'מיקום ערך תרשים בר',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'אפשרויות תצוגה לתרשים בר',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'אפשר גלילה',
    'LBL_CHART_CONFIG_STACK_DATA' => 'סדרות נתונים',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'הסתר קבוצות ריקות',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'נשלח',
    'LBL_EMAIL_RECV' => 'הקלט',

    //record save
    'LBL_RECORD_SAVED' => 'הקלטה נשמרה', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'יצרת בהצלחה את {{moduleSingularLower}} {{full_name}}.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'יצרת בהצלחה את {{moduleSingularLower}}.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'יצרת רשומה זו בהצלחה אך אין לך הרשאת גישה אליה', // use when user has no access to the model
    'LBL_VALIDATING' => 'מאמת...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'הצלחה:',
    'LBL_ALERT_TITLE_WARNING' => 'אזהרה:',
    'LBL_ALERT_TITLE_NOTICE' => 'הודעה:',
    'LBL_ALERT_TITLE_ERROR' => 'שגיאה:',
    'LBL_ALERT_TITLE_LOADING' => 'טוען',
    'LBL_ALERT_NO_ACCESS' => 'אין לך גישה למסנן שהוחל על תאסופית זו.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'שכפל את לוח המחוונים כדי להגדיר תאסופית זו עם מסנן משלך.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'הדפדפן שלך לא נתמך',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'פלטפורמות נתמכות',
    'LBL_ALERT_CONFIRM_DELETE' => 'האם אתה בטוח שברצונך למחוק פריט זה?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'האם אתה בטוח שברצונך למחוק פריטים אלה?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'הרישום שנבחר יחליף את הערכים הבאים: {{values}}. בטל כדי לשמור את הערכים הקיימים. אשר כדי להחליף בערכים חדשים.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'ל{{moduleSingularLower}} שנבחר יש ערכים קשורים: {{values}}. בטל כדי לשמור את הערכים הקיימים. אשר כדי להחליף בערכים חדשים.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'מאת:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'אל:',

    //organization chart
    'LBL_ORG_CHART' => 'תרשים ארגון',
    'LBL_ORG_CHART_DESC' => 'מציג את מבנה העובדים בארגון',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'מתג אוריינטציה',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'הצג את כל הצמתים',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'זום להתאמה',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'סיכום פניית שירות',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'הצג סקירה של פניות שירות קשורות',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'סיכום',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'פניות שירות סגורות',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'פניות שירות פתוחות',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => '10 שורות פרטי רווח הטובים ביותר',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'מציג 10 שורות פרטי רווח הטובים ביותר בתרשים בועות',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'שורות פרטי רווח שלי',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "שורות פרטי רווח של הקבוצה שלי",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'פילטר תאריך מחדל',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'בסיס נתונים ברירת מחדל',

    'LBL_PRODUCT_CATALOG_NAME' => 'קטלוג מוצרים',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'קטלוג מוצרים',
    'LBL_PRODUCT_CATALOG_DESC' => 'הצג והוסף פריטים מקטלוג המוצרים שלך.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'הצג והוסף פריטים מקטלוג המוצרים שלך.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} ב {{date}} ב {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'צור פתק או גרור מצרף. הקלד @ לציון משתמש. הקלד # להתייחסות לרשומה',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'הוסף הערה... הקלד @ לציון משתמש. הקלד # להתייחסות לרשומה',
    'LBL_ACTIVITY_STREAM' => 'זרם פעילות',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'זרם פעילות לא מאופשר',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'זרם פעילות לא מאופשר במודול זה',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'פוסטים נוספים...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'ב',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'זרם פעילות שלי',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'צפה ברשימת פעולות שמבוצעות על רשומות ופרסם תגובות',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => '&#39;זרמי פעילות&#39; אינו זמין',

    'LBL_DATA_VIEW' => 'תצוגת תאריך',
    'LBL_COMMENT' => 'תגובה',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'שגיאה בהתחברות לשרת. אנא נסה שוב',
    'ERR_RESOLVE_ERRORS' => 'נא לפתור בעיות לפני שתמשיך',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'לצורך האישור, יש למלא את כל שדות החובה; עם זאת, תוכל עדיין לדחות או לנתב רשומה זו.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'כדי לדחות/לנתב, יש למלא את כל שדות החובה.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'רענן רשימה',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'רענון אריחים',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'עוד',
    'LBL_TEXTAREA_LESS' => 'פחות',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} מצרפים',
    'LBL_CREATE_ATTACHMENT' => 'צור מצרף',
    'LBL_DASHLET_REFRESH' => 'רענן',
    'LBL_DASHLET_MOVE' => 'הזז',
    'LBL_DASHLET_CLOSE' => 'סגור',

    'LBL_DASHLET_FORECAST_NAME' => 'בתחזית',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'תרשים בר תחזית',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'תרשים בר תחזית',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'תחזית עבור',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'הצג תרשים בר תחזית עבור תקופת זמן מסויימת',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'מקובץ לפי',
    'LBL_DASHLET_FORECASTS_DATASET' => 'קבוצת נתונים',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'פרטי תחזית',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'הצג פרטי תחזית נוכחית',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'דשלט תרשים דוחות שמורים',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'מציג תרשים כלשהו מדוחות שמורים',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'מאמרים קשורים שפורסמו',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'סיכום היסטורי',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'עוד סיסטוריה...',
    'LBL_RELATED_CONTACT' => 'איש קשר קשור',
    'LBL_MODULE_TYPE' => 'סוג',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'מייל אל',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'מייל מאת',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'לא ניתן לצפות במודולים היסטוריים',

    //SFA
    'LBL_BEST' => 'הטוב ביותר',
    'LBL_WORST' => 'הגרוע ביותר',
    'LBL_LIKELY' => 'הסביר ביותר',
    'LBL_BEST_FORECAST' => 'התחייבות (הכי טוב)',
    'LBL_WORST_FORECAST' => 'התחייבות (הכי גרוע)',
    'LBL_LIKELY_FORECAST' => 'התחייבות (סביר)',
    'LBL_BEST_ADJUSTED' => 'התחייבות מותאמת (הכי טוב)',
    'LBL_WORST_ADJUSTED' => 'התחייבות מותאמת (הכי גרוע)',
    'LBL_LIKELY_ADJUSTED' => 'התחייבות מותאמת (סביר)',
    'LBL_AMOUNT_USDOLLAR' => 'סכום מומר',
    'LBL_OVERDUE' => 'איחור',

    'LBL_PASSWORD_REQUEST_SENT' => 'הבקשה שלך הוגשה.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'בעיה בקבלת הסיסמא והמייל שלך',

    'LBL_REMINDER_TITLE' => 'תזכורת',
    'LBL_CLICK_TO_DRILLDOWN' => 'הקלק לגלילה מטה',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'לא ניתן לבטל את כל השפות',

    'LBL_UPDATE_CALC_FIELDS' => 'חשב ערכים מחדש',

    //Optimistic Locking
    'LBL_YOU' => 'אתה',
    'LBL_RESOLVE_CONFLICT' => 'פתור קונפליקט עבור  {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'לקבלת עזרה נוספת פנה לתיעוד הבא: {{{more_info_url}}} {{plural_module_name}}.{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'אין נתונים זמינים',
    'LBL_NEED_HELP' => 'זקוק לעזרה לגבי משהו חדש?',
    'LBL_NEW_CASE' => 'אירוע חדש',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'חלונית העזרה מציגה מידע ספציפי לגבי המודול שאתה כרגע צופה בו, יחד עם קישור למסמכי התיעוד התואמים (כגון מסמכי תיעוד של לידים) במדריך היישום לפרטים נוספים.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'רשימת עזרה',
    'LBL_HELP_RECORDS' => "A module&#39;s list view displays all records meeting the current search criteria and to which users have access. You can view the basic details of each record within the field columns of the list view or click the record&#39;s name to open the record view.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'עזרה בתצוגת רשומות',
    'LBL_HELP_RECORD' => 'This record view provides thorough information about an individual record as well as some details of the records linked to it.

- Edit this record&#39;s fields by clicking an individual field or the Edit button.
- View or modify links to other records in the subpanels by toggling the bottom left pane to "Data View".
- Interact with user comments and view record change history by toggling the bottom left pane to "Activity Stream".
- Follow or favorite this record using the icons to the right of the record name.
- Additional actions are available in the dropdown Actions menu to the right of the Edit button.',

    // create view
    'LBL_HELP_CREATE_TITLE' => 'יצירת {{module_name}}',
    'LBL_HELP_CREATE' => 'כדי ליצור {{plural_module_name}}:
1. ספק ערכים עבור השדות כפי שתרצה.
 * יש להשלם את השדות המסומנים כ"נדרשים" לפני השמירה.
 * לחץ על "הצג עוד" כדי להציג שדות נוספים אם נדרש.
2. לחץ על "שמור" כדי לסיים את הרשומה החדשה ולחזור לתצוגת הרשימה של {{plural_module_name}}.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'התגלתה אפשרות לכפילות',
    'LBL_HELP_DUPLICATE' => 'Sugar זיהתה שייתכן והרישום שאתה מנסה ליצור כבר קיים.

כדי לערוך רישום קיים במקום ליצור רישום חדש, לחץ על "בחר וערוך" מימין לרישום הרצוי. בשדות הריקים של הרישום הקיים יוזנו הערכים שהרגע הזנת. לחץ על "שמור" כדי להחיל שינויים אלה ברישום הקיים.

אם, במקום זאת, ברצונך להשתמש בערכים שהרגע הזנת במקום הערכים שברישום הקיים, לחץ על "איפוס למקורי". הערכים שהזנת לאחר מכן יחולו על הרישום הקיים, ובאפשרות כעת להזין שינויים נוספים וללחוץ על "שמור" כדי להחיל את השינויים ברישום הקיים.

כדי ליצור רישום חדש בעזרת הערכים שהזנת, לחץ על "התעלם מכפילות ושמור" בחלק הימני-עליון של המסך.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'הגדרות SMTP חסרות',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'לשליחת משימות יש להגדיר שרת SMTP ב {{emailSettingsUrl}}.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'הגדרות דוא"ל',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'דוחות מלאי חדשים זמינים',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'דוחות מלאי חדשים זמינים עבור ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'מודול לדוחות',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'הם מתויגים כ"דוח מלאי" וניתנים לסינון. הדוחות מתויגים גם כ"מכירות ושיווק", "שירות לקוחות", "פרטיות נתונים" או "אדמיניסטרטיבי" בהתאם לתוכן. לקבלת פרטים נוספים ניתן לעיין בסעיף ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'מסמכים',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM מאפשרת למשתמשים חזקים לבצע משימות מסוימות במהרה עם קיצורי דרך של המקלדת כדי להגדיל את היצרנות שלהם. הטבלאות בצד ימין מתארות את קיצורי הדרך הזמינים יחד עם המקשים והפעולות שהם מבצעים.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>מקשים נתמכים</h1><ul><li>כל התווים והסימנים האלפאנומריים</li><li>shift‏, ctrl‏, alt‏, command‏, mod ‏(ctrl ב-Windows/Linux ו-command ב-Mac)</li><li>enter‏, esc‏, space‏, tab‏, pageup‏, pagedown‏, end‏, home‏, ins‏, del‏, backspace</li></ul><h1>תכונות נתמכות</h1><ul><li>צירוף מקשים: ctrl+m</li><li>מקשים מרובים: m,ctrl+m</li><li>רצף מקשים: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'קיצורים גלובליים',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'קיצורים קונטקסטואליים',
    'LBL_SHORTCUT_KEY_KEY' => 'מפתח:',
    'LBL_SHORTCUT_FUNCTION' => 'פונקציה',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'הגדר קיצורי דרך הקשריים',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'אין קיצורי דרך הקשריים שניתן להגדיר',
    'LBL_SHORTCUT_HELP' => 'הצד דף עזרה לקיצורים',
    'LBL_SHORTCUT_QUICK_CREATE' => 'החלף את תפריט יצירה מהירה',
    'LBL_SHORTCUT_SEARCH' => 'התמקד בשדה חיפוש גלובלי',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'החלף בר צדדי',
    'LBL_SHORTCUT_CREATE_RECORD' => 'צור רשומה חדשה',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'בחר ברשומה הבאה',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'בחר רשומה קודמת',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'גלול רשימה שמאלה',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'גלול רשימה ימינה',
    'LBL_SHORTCUT_OPEN' => 'פתח את הרשומה שנבחרה',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'ערוך את הרשומה שנבחרה',
    'LBL_SHORTCUT_RECORD_DELETE' => 'מחק רשומה',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'צא מהרשימה ללא שמירה',
    'LBL_SHORTCUT_RECORD_SAVE' => 'שמור רשומה',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'בטל שינויים ברשומה',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'סמן רשומה כמועדפת',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'עקוב אחר רשומה',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'צפה ברשומה',
    'LBL_SHORTCUT_MARK_SELECTED' => 'סמן רשומה כנבחרה',
    'LBL_SHORTCUT_SELECT_ALL' => 'בחר הכל',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'פתח תפריט פעולות גורפות',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'התמקד בשדה רשימת פילטר',
    'LBL_SHORTCUT_FILTER_CREATE' => 'צור רשימת פילטר חדשה',
    'LBL_SHORTCUT_FILTER_EDIT' => 'ערוך רשימת פילטר',
    'LBL_SHORTCUT_FILTER_SHOW' => 'פתח תפריט רשימת פילטר',
    'LBL_SHORTCUT_RECORD_EDIT' => 'ערוך רשומה',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'ערוך רשומה קודמת',
    'LBL_SHORTCUT_RECORD_NEXT' => 'ערוך רשומה באה',
    'LBL_SHORTCUT_COPY_RECORD' => 'העתק רשומה נוכחית',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'פתח תפריט פעולות עיקריות',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'סגור צייר',
    'LBL_SHORTCUT_FILTER_ADD' => 'הוסף קריטריון נוסף לפילטר',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'הסר קריטריון אחרון מפילטר',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'סגור פילטר',
    'LBL_SHORTCUT_FILTER_SAVE' => 'שמור פילטר',
    'LBL_SHORTCUT_FILTER_DELETE' => 'מחק פילטר',
    'LBL_SHORTCUT_FILTER_RESET' => 'אפס פילטר',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'הוסף שורה',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'הסר שורה',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'סגור עדכון גורף',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'עדכן רשומות',
    'LBL_CREATE_CATEGORY' => 'צור <div class="btn-link" data-action="create-new">קטגוריה</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'אשר',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'בטל',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'בחר את כל הפריטים בשדה בחירה-מרובה',
    'LBL_SHORTCUT_SWEETSPOT' => 'שנה את הסרגל Sweet Spot',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'הסתר את הסרגל Sweet Spot',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'שמור תצורה',
    'LBL_SHORTCUT_RESTORE' => 'שחזר ברירת מחדל',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'אירעה שגיאה בעת שמירת מקשי קיצור מותאמים אישית בשרת. נסה שוב.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => 'הגדרות {{module}}',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => 'הגדרות {{module}} נשמרו',
    'LBL_CONFIG_BLOCKED_TITLE' => 'שגיאה בהגדרות {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => 'אין הגדרות ל{{module}}',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'אין למשתמש גישה ל{{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'אין למשתמש גישה להגדרות {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'יש לתקן הגדרות בסיס נתונים ל{{module}}',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'ל',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'תאריך התחלה וסיום',

    'LBL_CALENDAR_START_DATE' => 'תאריך התחלה',
    'LBL_CALENDAR_END_DATE' => 'תאריך סיום',
    'LBL_CALENDAR_DURATION' => 'משך',
    'LBL_CALENDAR_RECURRENCE' => 'חזרות',
    'LBL_CALENDAR_REMINDERS' => 'תזכורות',

    'LBL_CALENDAR_CUSTOM_DATE' => 'תאריך מותאם אישית',
    'LBL_CALENDAR_REPEAT_TYPE' => 'סוג תזכורת',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'מרווח תזכורת',
    'LBL_CALENDAR_REPEAT_DOW' => 'חזור לפי ימים בשבוע',
    'LBL_CALENDAR_REPEAT_ON' => 'חזרה ב:',
    'LBL_CALENDAR_REPEAT' => 'חזרה',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'חזור עד',
    'LBL_CALENDAR_REPEAT_COUNT' => 'חזרות',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'בורר חזרות',
    'LBL_CALENDAR_REPEAT_DAYS' => 'ימים בחודש',
    'LBL_CALENDAR_REPEAT_MONTH' => 'חודשים בשנה',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'חזור על מספר סידורי',
    'LBL_CALENDAR_REPEAT_UNIT' => 'יחידת חזרה',
    'TPL_REPEAT_INTERVAL' => 'כל {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'סדרה זו משתמשת באפשרות &#39;חזרה ב:&#39; שאינה זמינה ב-Sugar, משום שהסדרה סונכרנה מלקוח של לוח שנה. כדי שהסדרה תמשיך לחזור בתאריך ספציפי, נא לערוך את הסדרה בלקוח לוח השנה שלך. עריכת הסדרה ב-Sugar תגדיר את &#39;חזרה ב:&#39; בתור &#39;אין&#39;.<br><br>רוצה להמשיך?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'יש לבצע שינויים בחזרות תוך שימוש ברשומה הראשונה בסדרה',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'כללי המופע החוזר אינם גורמים ליצירת אירוע.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'משתתף',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'נדחה',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'טנטטיבי',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'ללא מענה',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'תזמון לא זמין',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'תצוגות זמינות',
    'LBL_CALENDAR_DASHLET_NAME' => 'מתזמן לוחות השנה',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'תצוגת ברירת מחדל',
    'LBL_CALENDAR_MY_CALENDARS' => 'לוחות השנה שלי',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'לוחות שנה של משתמשים וצוותים',
    'LBL_CALENDAR' => 'לוח שנה',

    'LBL_CALENDAR_DAY' => 'יום',
    'LBL_CALENDAR_WEEK' => 'שבוע',
    'LBL_CALENDAR_MONTH' => 'חודש',
    'LBL_CALENDAR_YEAR' => 'שנה',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => 'ה-2',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => 'ה-3',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => 'ה-4',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => 'ה-5',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => 'ה-6',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => 'ה-7',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => 'ה-8',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => 'ה-9',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => 'ה-10',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => 'ה-11',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => 'ה-12',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => 'ה-13',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => 'ה-14',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => 'ה-15',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => 'ה-16',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => 'ה-17',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => 'ה-18',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => 'ה-19',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => 'ה-20',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => 'ה-21',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => 'ה-22',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => 'ה-23',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => 'ה-24',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => 'ה-25',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => 'ה-26',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => 'ה-27',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => 'ה-28',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => 'ה-29',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => 'ה-30',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => 'ה-31',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => 'ה-32',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => 'ה-33',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => 'ה-34',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => 'ה-35',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => 'ה-36',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => 'ה-37',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => 'ה-38',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => 'ה-39',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => 'ה-40',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => 'ה-41',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => 'ה-42',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => 'ה-43',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => 'ה-44',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => 'ה-45',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => 'ה-46',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => 'ה-47',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => 'ה-48',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => 'ה-49',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => 'ה-50',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => 'ה-51',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => 'ה-52',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => 'ה-53',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => 'ה-54',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => 'ה-55',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => 'ה-56',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => 'ה-57',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => 'ה-58',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => 'ה-59',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => 'ה-60',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => 'ה-61',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => 'ה-62',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => 'ה-63',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => 'ה-64',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => 'ה-65',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => 'ה-66',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => 'ה-67',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => 'ה-68',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => 'ה-69',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => 'ה-70',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => 'ה-71',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => 'ה-72',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => 'ה-73',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => 'ה-74',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => 'ה-75',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => 'ה-76',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => 'ה-77',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => 'ה-78',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => 'ה-79',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => 'ה-80',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => 'ה-81',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => 'ה-82',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => 'ה-83',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => 'ה-84',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => 'ה-85',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => 'ה-86',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => 'ה-87',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => 'ה-88',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => 'ה-89',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => 'ה-90',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => 'ה-91',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => 'ה-92',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => 'ה-93',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => 'ה-94',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => 'ה-95',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => 'ה-96',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => 'ה-97',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => 'ה-98',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => 'ה-99',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'ארעה שגיעה בטעינת התזמון',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'שמור ושלח הזמנות',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'סטטוס קבלה',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'תהליכים',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'התאסופית &#39;תהליכים&#39; מציגה את התבניות שבהן ניתן להשתמש ב-SugarBPM.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'הגדרות תהליך',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'התאסופית &#39;הגדרות תהליך&#39; מציגה את התבניות שבהן ניתן להשתמש ב-SugarBPM.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'צור הגדרות תהליך',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'ייבא הגדרות תהליך',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'תהליך כללים עסקיים',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'התאסופית &#39;תהליך כלל עסקי&#39; מציגה את התבניות שבהן ניתן להשתמש ב-SugarBPM.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'צור תהליך כלל עסקי',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'ייבא תהליך ככלים עסקיים',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'תבניות מייל תהליך',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'התאסופית &#39;תבניות מייל תהליך&#39; מציגה את התבניות שבהן ניתן להשתמש ב-SugarBPM.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'צור תבנית מייל תהליך',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'ייבא תבניות מייל תהליך',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'כאשר אתה מפתח תהליכים/כללי עסק/תבניות דוא"ל במופע אחר של Sugar, אנחנו ממליצים בחוזקה שהמופע יהיה שכפול מדויק של מערכת הייצור שלך. תהליכים/כללי עסק/תבניות דוא"ל שנבנו במופע בלתי-תלוי של Sugar עלולים לא לתפקד כרצוי לאחר סיום הייבוא. ייתכן ותהליכים/כללי עסק/תבניות דוא"ל מסתמכים על שינויים ספציפיים של Studio או ברמת היישום, כולל אך לא מוגבל לשמות שדה מותאמים אישית, ערכי גלילה, מזהה מסד נתונים וכו&#39;. במידה וערכים אלה אינם זהים מהמופע שבו נבנה התהליך/הכלל העסקי/תבנית הדוא"ל, ייתכן ותצטרך לבנות מחדש באופן ידני את התהליך/הכלל העסקי/תבנית הדוא"ל במופע היעד שלך.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'האם ברצונך להמשיך בייבוא זה?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'האם ברצונך להמשיך בייצוא זה?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'השדות הנפתחים הבאים מכילים אפשרויות לא חוקיות',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'פעילויות בהמתנה ע"י תהליך',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'פעילויות בהמתנה',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'פעילויות בהמתנה ע"י תהליך',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'כל התהליכים',
    'LBL_RECORD_DASHBOARD' => 'לוח מחוונים של רשומות',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'סיכום סטטוס תהליך',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'תאור סטטוס תהליך',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'בתהליך',
    'LBL_PMSE_COMPLETED_STATUS' => 'הושלם',
    'LBL_PMSE_CANCELLED_STATUS' => 'בוטל',
    'LBL_PMSE_TERMINATED_STATUS' => 'הופסק',
    'LBL_PMSE_ERROR_STATUS' => 'שגיאה',
    'LBL_PMSE_SETTINGS' => 'הגדרות SugarBPM',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'אתה בטוח שברצונך למחוק רשומה זו?',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'אתה בטוח שברצונך לאפשר רשומה זו?',
    'LBL_PRO_DELETE_CONFIRMATION' => 'אתה בטוח בשברצונך למחוק רשומה זו?',

    'LBL_PRO_ENABLE' => 'מעדכן',
    'LBL_PRO_DISABLE' => 'מעדכן',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => 'הרשומה {{link}} משתתפת בתהליך ועשויה להכיל מספר שדות נעולים. כדי לערוך את הרשומה, לחץ כאן {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'שדה זה נעול מאחר שהוא מעורב בתהליך פועל.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'רשומה זו משתתפת בתהליך ועשויה להכיל מספר שדות נעולים.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'מרכז עסקים',
    'LBL_BUSINESS_CENTER_ID' => 'מזהה מרכז עסקים',
    'LBL_BUSINESS_CENTER_NAME' => 'שם מרכז עסקים',

    'LBL_PLIS_ACTIVITIES' => 'פריטי שורה - פעילויות רכישה',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(תיוג חדש)',
    'LBL_TAG_FETCH_ERROR' => 'קרתה שגיאה בעת אחזור תיוגים.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'יש לאפשר שימוש ב Javascript כדי להמשיך לעבוד עם שוגר',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'לא ניתן היה לבטל את העריכה בסידרה של הנתונים הערוכים בסידרה',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'לא ניתן היה לבטל את העריכה בסידרה של הנתונים הערוכים בסידרה מאחר שהם מכילים הפניות לאובייקטים או למחלקות',

    'LBL_FIELD_TRIMMED' => 'השדה נחתך עקב חריגה ממגבלת מספר התווים המרבי.',
    'LBL_FIELDSIZE_OVERFLOW' => 'השדה חורג ממגבלת התווים המרבית.',
    'LBL_TINYMCE_TARGET_SAME' => 'באותו חלון',
    'LBL_TINYMCE_TARGET_NEW' => 'חלון חדש',

    'LBL_OUTBOUND_EMAILS' => 'הגדרות דוא"ל',
    'LBL_OUTBOUND_EMAIL' => 'הגדרת דוא"ל',

    'LBL_EMAIL_PARTICIPANTS' => 'המשתתפים בדוא"ל',
    'LBL_EMAIL_PARTICIPANT' => 'המשתתף בדוא"ל',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'פרטיות נתונים',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'פרטיות נתונים',
    'LBL_DATAPRIVACY_VIEW_PII' => 'הצג מידע אישי',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'סמן למחיקה',
    'LBL_DATAPRIVACY_FIELDNAME' => 'שדה',
    'LBL_DATAPRIVACY_VALUE' => 'ערך',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'שונה על ידי',
    'LBL_DATAPRIVACY_SOURCE' => 'מקור',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'עודכן לאחרונה בתאריך',
    'LBL_DATAPRIVACY_PII' => 'מידע אישי',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'סמן למחיקה',
    'TPL_DATAPRIVACY_PII_TITLE' => 'מידע אישי עבור {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'שינוי טיימרים',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'הודעות',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'הועתק ללוח שלך!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'לא ניתן להעתיק ללוח שלך',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'העתק את קישור האישור',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'ציר זמן',
    'LBL_NO_ACTIVITY' => 'אין פעילות',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => 'ציר הזמן של {{moduleSingular}}',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'עוד',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'פחות',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'בציר הזמן מופיעות הרשומות הקשורות של הרשומה הנוכחית ועדכוני שדות נבחרים לאורך זמן.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'הצג עוד...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'הראה פחות...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'אין נתונים זמינים',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'אין רישיון לשימוש במודול.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'מנויים פעילים',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'ניתן להוסיף חלונית זו רק למודולים שמקושרים לחשבון יחיד. עיין במסמכים הזמינים ב<a href={{linkToDocumentation}}>חלונית למנויים פעילים</a> לקבל פרטים נוספים.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'הצג רכישות ששייכות לחשבון מקושר זה:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'מנויים פעילים עבור חשבון ספציפי.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', כמות {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'סה"כ:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'אין מנויים פעילים',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'חלונית זו מחייבת שימוש במודול {{module_name}} כדי לפעול. בקש ממנהל המערכת להפעיל את המודול {{module_name}}.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'היסטוריית רכישות',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'כל הרכישות עבור חשבון ספציפי.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'ניתן להוסיף חלונית זו רק למודולים שמקושרים לחשבון יחיד. למידע נוסף, עיין במסמכים הזמינים ב<a href={{linkToDocumentation}}>חלונית &#39;היסטוריית רכישות&#39;</a>.',
    'LBL_NO_PURCHASE_HISTORY' => 'אין רכישות להצגה',
    'LBL_NO_PLIS' => 'אין פריטי שורה של רכישות',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'סה"כ',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'כמות',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'כדי שחלונית זו תוכל לפעול, נדרש שימוש בפריטי השורה &#39;רכישות&#39; ו&#39;פריטים שנרכשו&#39;. בקש ממנהל המערכת להפעיל את פריטי השורה &#39;רכישות&#39; ו&#39;פריטים שנרכשו&#39;.',
    'LBL_SEARCH_PURCHASE_NAME' => 'חיפוש לפי שם רכישה...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'השתמש ב- Studio כדי לערוך את תצורת חלונית התצוגה של הרשימה על-ידי מעבר אל ' .
        'Studio > ‏{{module}} > תצורות > חלונית תצוגת רשומות. <a href={{linkToStudio}}>ערוך ב-Studio</a>.',
    'LBL_SERVICE_LEVEL' => 'רמת שירות',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'מספר',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'המשך טיפול',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'עדיפות/סטטוס',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'נושא/תיאור',

//Service Duration
    'LBL_SERVICE_DURATION' => 'משך זמן השירות',
    'LBL_SERVICE_DURATION_VALUE' => 'ערך משך זמן השירות',
    'LBL_SERVICE_DURATION_UNIT' => 'יחידת משך זמן השירות',
    'LBL_LOCK_DURATION' => 'משך הנעילה',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'לא ניתן להעלות את לוח הבקרה לאנשי קשר/CCP של Amazon Connect. נא' .
        'ודא שאתה משתמש ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">דפדפן נתמך</a>. ' .
        'אם הבעיה נמשכת, צור קשר עם מנהל המערכת של Sugar.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'מנהל המערכת של Sugar לא הגדיר את המופע שלך ל-Amazon Connect.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'לא ניתן להתחבר ל-Amazon Connect. צור קשר עם מנהל המערכת של Sugar לקבלת עזרה.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'לא ידוע',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'מגירת פוקוס',
    'LBL_CLOSE_FOCUS_DRAWER' => 'מגירת פוקוס סגירות',
    'LBL_EXTERNAL_GUESTS' => 'אורחים חיצוניים',
    'LBL_MY_FAVORITE_TASKS' => 'המשימות המועדפות שלי',
    'LBL_RECORD' => 'רשומה',

    'LBL_MY_TASKS' => 'המשימות שלי',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'אי אפשר היה למצוא את השדה: {0} במודול: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'אי אפשר היה למצוא רשומה עם {0}: {1} במודול: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'אי אפשר היה למצוא יחסים בשם: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'הרשומה במסד הנתונים עם המזהה: {0}, ו-{1}: {2} במודול: {3} כבר קיימת',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'מחיקה זמנית (עם דגל מחיקה = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'נמצאו מספר רשומות מבסיס הנתונים עבור {0} {1} במודול {2}. ' .
        'נא להסיר או לעדכן את הרשומות התואמות לפי הצורך. רשומות תואמות: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'ההפעלה הבאה',
    'LBL_TIME_AWARE_TYPE' => 'סוג',
    'LBL_TIME_AWARE_BEAN_ID' => 'מזהה Bean',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'תווית תצוגה',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'פתיחת תצוגת הרשומות',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'הוסף',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'אין עזרה זמינה',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'פונקציות',
    'LBL_ACTIONBUTTON_FIELDS' => 'שדות',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'בחירת שדה...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Rollup',
    'LBL_ACTIONBUTTON_RELATED' => 'קשור',
    'LBL_ACTIONBUTTON_SAVE' => 'שמירה',
    'LBL_ACTIONBUTTON_CANCEL' => 'ביטול',
    'LBL_ACTIONBUTTON_R_MODULE' => 'מודול קשור',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'שדות קשורים',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'מודול Rollup',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'שדות Rollup',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'פונקציית Rollup',
    'LBL_ACTIONBUTTON_MINIMUM' => 'מינימום',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'מקסימום',
    'LBL_ACTIONBUTTON_AVERAGE' => 'ממוצע',
    'LBL_ACTIONBUTTON_SUM' => 'סכום',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'הקצה רשומה',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'כתוב דוא"ל',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'יצירת רשומה',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'מיזוג מסמכים',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'פתח כתובת URL',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'הרץ דוח',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'עדכן רשומה',
    'LBL_ACTIONBUTTON_ACTION' => 'פעולה',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'הקצה ל',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'שלח בדוא"ל ל',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'השתמש ב-PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'תבנית',
    'LBL_ACTIONBUTTON_MODULE' => 'מודול',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'הגדרות תצוגה',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'סוג',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'תפריט נפתח',
    'LBL_ACTIONBUTTON_BUTTON' => 'כפתור',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'קבוצת כפתורים',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'הצג תווית ברשומה',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'הצג בכותרת העליונה',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'הסתר במהלך עריכה',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'הצג בכותרת העליונה של לוח המחוונים הממוקד',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'לוח מחוונים',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'כותרת עליונה של לוח מחוונים ממוקד',
    'LBL_ACTIONBUTTON_SIZE' => 'גודל',
    'LBL_ACTIONBUTTON_DEFAULT' => 'ברירת מחדל',
    'LBL_ACTIONBUTTON_SMALL' => 'קטן',
    'LBL_ACTIONBUTTON_LARGE' => 'גדול',
    'LBL_ACTIONBUTTON_CALCULATED' => 'מחושב',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'המר ל-PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'מיזוג מסמכים',
    'LBL_ACTIONBUTTON_URL' => 'כתובת URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'תצוגה מקדימה',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'מאפיינים',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'תווית',
    'LBL_ACTIONBUTTON_DESC' => 'תיאור כלי',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'הצג תווית',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'הצג סמל',
    'LBL_ACTIONBUTTON_SCHEME' => 'ערכת צבעים',
    'LBL_ACTIONBUTTON_ICON' => 'סמל',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'תלוי',
    'LBL_ACTIONBUTTON_DESIGN' => 'תצורת פריסה',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'עצור בשגיאה',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'שמירה אוטומטית',
    'LBL_ACTIONBUTTON_CONFIG' => 'הגדרה',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'הגדר את ה-ActionButton לפני השמירה.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'הגדרת כפתורים',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'יצירה אוטומטית',
    'LBL_ACTIONBUTTON_LINK' => 'יצירת קשר להורה',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'העתקת ערכי אב',
    'LBL_ACTIONBUTTON_PRESET' => 'הגדר ערכי שדה',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'העתק ערכי שדה מהורה',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'בחר...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'משדה האב ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'האם אתה בטוח שברצונך למחוק כפתור זה?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'אתה בטוח שברצונך למחוק פעולה זו?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'נתונים לא חוקיים של כפתור פעולה',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'יש לבחור מודול לפני השמירה.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'יש לבחור קישור לפני השמירה. אם אין קישור זמין, בטל את הבחירה באפשרות הקישור.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'יש לבחור רשומה לפני השמירה.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'יש לבחור תבנית לפני השמירה.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'ראשי',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'משני',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'ניראות גבוהה',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'ים',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'ורוד',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'צבא',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'כחול-ירקרק',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'האוקיינוס השקט',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'ירוק',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'צהוב',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'כתום',
    'LBL_ACTIONBUTTON_THEME_RED' => 'אדום',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'אדום-אלמוגים',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'סגול',
    'LBL_ACTIONBUTTON_FORMULA' => 'נוסחה',
    'LBL_ACTIONBUTTON_ACTIONS' => 'פעולות',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'שגיאה בעת אימות נתוני הכפתור.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'כפתורים חייבים לכלול לפחות תווית או מערך סמלים.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'הזן תווית כפתור חוקית.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'לא ניתן היה ליצור את הרשומה מאחר שחסרים ערכים נדרשים. פנה אל מנהל המערכת.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'חייבים להיות לפחות שני כפתורים פעילים עבור סוג כפתור זה.',
    'LBL_ACTIONBUTTON_RECORD' => 'תצוגות של רשומות',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'תפריטי פעולה',
    'LBL_ACTIONBUTTON_ORDER' => 'סדר',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'תצוגת רשימה',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'כותרת עליונה של תצוגת רשומות',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'כותרת עליונה של חלונית תצוגת רשומות',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'פאנלי-משנה',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'מנגנון הביצוע של רצף המשימות כשל בביצוע הפעולות הבאות: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'הוספת פעולה',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'הסרת פעולה זו',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'משתמש נוכחי',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'מיזוג מסמכים',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'מיזוג מסמכים ל-PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'גודל חברה',
    'LBL_HINT_COMPANY_INDUSTRY' => 'ענף',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'תגי ענף',
    'LBL_HINT_COMPANY_LOCATION' => 'מיקום החברה',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'תיאור החברה',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'שנת הקמה',
    'LBL_HINT_COMPANY_FACEBOOK' => 'דף החברה ב-Facebook',
    'LBL_HINT_COMPANY_TWITTER' => 'דף החברה ב-Twitter',
    'LBL_HINT_COMPANY_PIC' => 'הלוגו של החברה',
    'LBL_HINT_CONTACT_PIC' => 'תמונת איש קשר',
    'LBL_HINT_COMPANY_WEBSITE' => 'אתר האינטרנט של החברה',
    'LBL_HINT_PHOTO' => 'קישור לתמונה',
    'LBL_HINT_JOB_2' => 'תפקידים קודמים',
    'LBL_HINT_EDUCATION' => 'חינוך',
    'LBL_HINT_EDUCATION_2' => 'חינוך - נוסף',
    'LBL_HINT_TWITTER' => 'קישור ל-Twitter',
    'LBL_HINT_FACEBOOK' => 'קישור ל-Facebook',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'קוד NAICS',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'קוד SIC',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'סוף שנת כספים',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'הכנסה שנתית',
    'LBL_HINT_PHONE_1' => 'טלפון 1',
    'LBL_HINT_PHONE_2' => 'טלפון 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'טבלת איחוד',
    'LBL_HINT_FULL_NAME' => 'שם מלא',
    'LBL_HINT_JOB_TITLE' => 'תפקיד',
    'LBL_HINT_OFFICE_PHONE' => 'טלפון בעבודה',
    'LBL_HINT_MOBILE_PHONE' => 'נייד',
    'LBL_HINT_OTHER_PHONE' => 'טלפון אחר',
    'LBL_HINT_WEBSITE' => 'אתר אינטרנט',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'האם ברצונך להחליף את כל הנתונים הקיימים עבור רשומה זו בנתונים החדשים שנמצאו ב-Sugar Hint?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'האם ברצונך להחליף את השדה &#39;{{fieldName}}&#39; הקיים עבור רשומה זו בשדה &#39;{{fieldName}}&#39; החדש שנמצא ב- Sugar Hint?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'כל הנתונים הקשורים לחשבון יוסרו. בטוח שברצונך להמשיך?',
    'LBL_HINT_COMPANY_LOGO' => 'לוגו',
    'LBL_HINT_CONTACTS_AVATAR' => 'תמונה',
    'LBL_HINT_ACCOUNTSETS' => 'תגי קבוצות חשבונות ב-Sugar Hint',

    'LBL_HINT_LOADING' => 'המערכת טוענת...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'המערכת מסירה את ההתקנה של Sugar Hint, נא להמתין',
    'LBL_HINT_VALUE_ERASED' => ' הערך נמחק ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'מידע זה נמחק באמצעות בקשת פרטיות נתונים',

    'LBL_HINT_UNINSTALL_TITLE' => 'בחר אחת מהאפשרויות הבאות להסרת התקנה:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'הסר את ההתקנה של חבילת Hint בלבד',
    'LBL_HINT_UNINSTALL_FULL' => 'הסר את ההתקנה של Hint לחלוטין',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'בחירה באפשרות זו תגרום להסרת ה-MLP של Sugar Hint ולהשבתת כל המינויים הפעילים ל-Hint Insights.
    התקנה מחדש של Hint תפעיל מחדש את המינויים באופן אוטומטי.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'בחירה באפשרות זו תגרום להסרת התקנה מלאה של Hint, כולל הסרת ה-MLP ומחיקת כל מידע התצורה והמינויים.',
    'LBL_HINT_UNINSTALL' => 'הסר התקנה',
    'LBL_HINT_UNINSTALL_HEADER' => 'הסרת ההתקנה של Sugar Hint',
    'LBL_HINT_CANCEL' => 'ביטול',
    'LBL_HINT_UNINSTALL_WARNING1' => 'אזהרה: יש לבחור באפשרות זו רק אם אין בכוונתך להשתמש שוב ב-Hint בעתיד.
    לפני הסרת ההתקנה, בצע גיבוי מלא של מסד הנתונים של Sugar והעבר את Sugar למצב תחזוקה. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'ראה ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'מדריך Sugar Hint למנהלי מערכת ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'לקבלת פרטים על תהליך הסרת ההתקנה.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'בטוח שברצונך להסיר את ההתקנה של חבילת Sugar Hint בלבד?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'בטוח שברצונך להסיר את ההתקנה של Sugar Hint לחלוטין?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(הערה: פעולה זו בלתי הפיכה)',

    'LBL_HINT_CONFIG_TITLE' => 'שדות Sugar Hint',
    'LBL_HINT_NO_RESULTS_MSG' => 'לא נמצאו תוצאות.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'פריסה בסיסית של חלונית Hint',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'חשבונות',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'אנשי קשר',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'לידים',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'פריסה מורחבת של חלונית Hint',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'שנה את סדר השדות על ידי גרירה ושחרור בתוך אזורי פריסת החלונית של Hint שתיארנו מעל.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'לקבלת הוראות מפורטות ורשימה של שדות ברירת המחדל, ראה ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' כדי לשחזר את הגדרות ברירת המחדל עבור המודול ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => '.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'בטוח שברצונך לאפס את ההגדרות לברירות המחדל עבור המודול {{module}}?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'לחץ כאן',
    'LBL_HINT_CONFIG_NAME' => 'המדריך של Hint למנהלי מערכת.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'שדות',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'שדות מועשרים',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'באזור זה מופיעים כל השדות של Hint והשדות של Sugar המועשרים על ידי Hint. שדות של Hint מסומנים בכוכבית (*) ויכולים להופיע בחלונית של Hint רק אם הם מועשרים.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'שם שדה',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'העשרת שדה',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'הצג ב-Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'הצג בחלונית של Hint',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'שדות נוספים של Sugar',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'באזור זה מופיעים כל השדות של Sugar שאינם מועשרים על ידי Hint.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'אזהרה',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'זהירות: הנך עומד/ת לסנכרן עם שירות Sugar Hint Insights. כתבות תקציר שממתינות לשליחה בדוא"ל יאבדו, וחדשות קיימות יימחקו מהחלונית של Insights. ההודעות מכל הסוגים יתחדשו לאחר השלמת הסנכרון.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'חברות מוצעות שיש להן קשר ל{{_moduleSingular}} שלך מפורטות למטה. בחר את נתוני החברה שברצונך להציג.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'לא נבחר אף חשבון',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'נמצאו חשבונות דוא"ל מרובים, בחר את אלה שברצונך לייבא: ',

    'LBL_HINT_HELP_MESSAGE1' => 'Hint לא מצא התאמה במערכת על סמך הנתונים שהוזנו.',
    'LBL_HINT_HELP_MESSAGE2' => 'את התוצאות הטובות ביותר ב-Hint ניתן למצוא לפי השם וכתובת הדוא"ל של המשתמש.',
    'LBL_HINT_HELP_MESSAGE3' => 'את התוצאות הטובות ביותר ב-Hint ניתן למצוא לפי כתובת ה-URL של אתר החברה.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "יש להזין את השם או את האתר של החברה הקשורה ל{{_moduleSingular}} ו-Hint יחפש נתונים נוספים.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "יש להזין את כתובת הדוא\"ל שלך הקשורה למודול '{{currentModule}}' ו-Hint יחפש נתונים נוספים.",

    'LBL_HINT_HISTORY_NONE' => 'אין נתונים זמינים עבור תצוגת ההיסטוריה',
    'LBL_HINT_HISTORY_TITLE' => 'היסטוריית פעילויות',

    'LBL_HINT_PREVIEW_TITLE' => 'העשרת נתונים',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'תוקף הרישיון שלך לשירות Hint פג. נא לפנות אל מנהל מערכת SugarCRM בבקשה לחדש את הרישיון.',
    'LBL_HINT_PREVIEW_QUESTION' => 'רוצה לראות אילו יתרונות השימוש ב-Hint יאפשר לך ולחברה שלך? מומלץ לפנות אל מנהל מערכת SugarCRM שלך ולבקש שיוסיף את Hint.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'פרטי החשבון לא נמצאו',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'נמצאו נתונים מועשרים - לחץ כדי לשמור את כל הנתונים המועשרים ברשומה.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'לחץ כדי לשמור את הנתונים המועשרים ברשומה.',

    'LBL_HINT_CONTACTS_TITLE' => 'אנשי קשר רלוונטיים',
    'LBL_HINT_CONTACTS_NONE' => 'אין אנשי קשר רלוונטיים',

    'LBL_HINT_NEWS' => 'חדשות',
    'LBL_HINT_GENERAL' => 'כללי',
    'LBL_HINT_ALL_NEWS' => 'כל החדשות',
    'LBL_HINT_FILTER_NEWS' => 'סינון חדשות',
    'LBL_HINT_FINANCIAL_NEWS' => 'פיננסי',
    'LBL_HINT_PERSONNEL_NEWS' => 'אישי',
    'LBL_HINT_PRESS_RELEASES' => 'הודעות לעיתונות',
    'LBL_HINT_OTHER_NEWS' => 'אחר',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'חיפוש מאמרי חדשות',
    'LBL_HINT_NEWS_ALERT' => 'SugarCloud Insights',
    'LBL_HINT_NEWS_NONE' => 'אין חדשות זמינות',
    'LBL_NEW_NOTIFICATIONS' => 'הודעות חדשות',
    'LBL_HINT_DASHLET_ALLOWED1' => 'כדי להציג את חלונית Sugar Hint Insights, נדרש רישיון ל-Sugar Hint.
    תוכל/י לברר עם מנהל המערכת שלך כיצד להשיג רישיון ל-Sugar Hint.',

    'LBL_HINT_FOR' => 'עבור',
    'LBL_HINT_WITH' => 'עם',
    'LBL_HINT_SHOW_ME' => 'הראה לי: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'שלח לי הודעה באמצעות: ',

    'LBL_NOTIFICATIONS_TITLE' => 'מרכז ההעדפות של Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'מקש Option לקביעת העדפות',
    'LBL_HINT_PREFERENCES' => 'העדפות',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'אפשרות המחיקה מושבתת; חייבת להיות מוגדרת לפחות הצהרת העדפה אחת',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'אפשרות ההוספה מושבתת; הגעת למספר המרבי של הצהרות העדפות',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'כלול/י בחלונית של Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'חלון קופץ כהודעה בשולחן העבודה',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'כדי לקבל הודעות בעקביות, יש להפעיל את אפשרות ההודעות בכל הדפדפנים ובכל המחשבים השולחניים.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'חלק מהדפדפנים, כגון Internet Explorer, לא תומכים בהודעות. לא ניתן להפעיל הודעות כשמשתמשים בדפדפן שלא תומך בהודעות.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'שלח התראה מיידית בדוא"ל עבור כל הודעה',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'שלח תקציר יומי בדוא"ל',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'שלח תקציר שבועי בדוא"ל',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'לא ניתן היה לשמור את ההעדפות. בדוק את החיבור למערכת ונסה שוב.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'בחלק משדות החובה חסר ערך. בדוק את ההעדפות וודא שכל שדות החובה מולאו.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'הנך עומד/ת להפעיל הודעות בדפדפן עבור Sugar Hint Insights. נא ללחוץ על &#39;אישור&#39; כדי להמשיך. לאחר מכן, תוצג לך בדפדפן בקשה למתן הרשאה לקבלת אירועי הודעות.',
    'LBL_HINT_PUSH_ERROR' => 'תוסף התראות Push נרשם עבור {{options.type}} ללא יחסי התלות שלו. התוסף לא יעבוד כצפוי. ספק את הנתיב אל קובץ העובד ושיטה לשמירת המינוי בשרת.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'הפעל הודעות Hint עבור כל המשתמשים',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'השבת הודעות Hint עבור כל המשתמשים',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'אזהרה: לא הצלחנו להשבית את ההודעות במהלך הסרת ההתקנה של Sugar Hint. כדי להשבית הודעות, יש להתקין את גרסת Sugar Hint 5.4.0 ואילך ולבצע הסרת התקנה מלאה באמצעות הכלי Sugar Hint Uninstaller שנמצא באזור הניהול של Sugar.',
    'LBL_HINT_ENRICH_ALL' => 'העשר הכול',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'נדרש רישיון Hint',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'תצורת מפות',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'מציג יומן מקודד גאוגרפי',
    'LBL_MAP_MAP' => 'מפה',
    'LBL_MAP_MAPS' => 'מפות',
    'LBL_MAP_GEOCODING_RECORD' => 'קוד גיאוגרפי',
    'LBL_MAP_GEOCODE_SUCCESS' => 'הקידוד הגיאוגרפי של הרשומה בוצע בהצלחה.',
    'LBL_MAP_LATITUDE' => 'קו רוחב',
    'LBL_MAP_LONGITUDE' => 'קו אורך',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'חפש לפי כתובת...',
    'LBL_MAP_ALREADY_GEOCODED' => 'הרשומה הנוכחית כבר עברה קידוד גיאוגרפי. בטוח שברצונך להחליף את הקידוד הגיאוגרפי של הרשומה?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'קידוד גיאוגרפי ידני',
    'LBL_MAP_POINT_COORDINATES' => 'קואורדינטות של נקודות במפה',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'מחשב את המסלול האופטימלי...',
    'LBL_MAP_DIRECTIONS' => 'הנחיות הגעה',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'הנחיות הגעה החל מהמשתמש הנוכחי',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'הנחיות הגעה החל מרשומה זו',
    'LBL_MAPS_RADIUS_INPUT' => 'רדיוס (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'ברדיוס של המיקוד',
    'LBL_MAPS_DISTANCE' => 'מרחק',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'מיקוד',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'תצורה לא חוקית: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => 'המיפויים של שדה <strong>{{module}}</strong> לא חוקיים.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'סוג מפה',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'רמת מרחק מתצוגה',
    'LBL_MAPS_DASHLET' => 'מפות',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'הצגת רשומה(ות) שעברה(ו) קידוד גיאוגרפי על המפה.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'הרכיב &#39;מפות&#39; לא זמין עבור מודול זה. הפוך אותו לזמין במסוף הניהול.',
    'LBL_MAP_MODULES' => 'מודול',
    'LBL_MAP_FILTER_BY' => 'סנן לפי',
    'LBL_MAP_UNIT_TYPE' => 'סוג יחידה',
    'LBL_MAP_UNIT_TYPE_MILES' => 'מיילים',
    'LBL_MAP_UNIT_TYPE_KM' => 'קילומטרים',
    'LBL_MAP_ADDRESS' => 'כתובת',
    'LBL_MAP_NO_STARTING_POINT' => 'נקודת ההתחלה לא עברה קידוד גיאוגרפי.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'רשומת נקודת ההתחלה לא עברה קידוד גיאוגרפי.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'חלק מהרשומות שנבחרו לא עברו קידוד גיאוגרפי ולא יוצגו על המפה.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'הרשומה(ות) לא עברה(ו) קידוד גיאוגרפי.',
    'LBL_MAPS_MODULE_FIELDS' => 'שדות מודול',
    'LBL_MAPS_SELECT_FIELD' => 'בחירת שדה',
    'LBL_MAPS_RELATE_RECORD' => 'רשומה קשורה',
    'LBL_MAPS_MAPPING_TYPE' => 'סוג מיפוי',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'אין רשומות שעברו קידוד גיאוגרפי',
    'LBL_MAPS_ADDRESS' => 'כתובת',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'הוקצה למשתמש',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'תצוגה מצד הרחוב לא זמינה עבור הנקודה הנתונה',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> רשומות אינן חוקיות לצורך מיפוי. הסר מודול זה מהרשימה.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'סגירה',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'הרחבה',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'שמירה כ-PDF',
    'LBL_MAPS_EMAIL_LINK' => 'שליחת קישור בדוא"ל',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'חייבת להיות לפחות רשומה אחת שעברה קידוד גיאוגרפי.',
    'LBL_MAPS_GENERATING' => 'המערכת יוצרת את המפה...',
    'LBL_MAPS_POINTS' => 'נקודות במפה',
    'LBL_MAPS_POINT' => 'נקודה',
    'LBL_MAPS_TRAVEL_DETAILS' => 'פרטי נסיעה',
    'LBL_MAPS_TOTAL_DISTANCE' => 'מרחק כולל',
    'LBL_MAPS_TOTAL_DURATION' => 'משך כולל',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'משך כולל ללא מרכיב התנועה בכביש',
    'LBL_MAPS_ITINERARY' => 'לוח זמנים לנסיעה',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'מרחק הנסיעה',
    'LBL_MAPS_TRAVEL_DURATION' => 'משך הנסיעה',
    'LBL_MAPS_TRAVEL_STEPS' => 'שלבים',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'אזהרות',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Maps תומך במספר מרבי של עד 10 מיקומים מדויקים על מפה משותפת. בדוק שוב את הבחירה שלך.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'נדרש רישיון למפות',
    'LBL_MAPS_SHARE_HELLO' => 'שלום,',
    'LBL_MAPS_SHARE_HEADER' => 'ביקשת מפת Bing לנקודות הבאות:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'כתובת ה-URL הבאה תפתח מפה עם הנקודות שמצוינות למעלה ב-Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'הצגת המפה ב-Bing Maps',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'לא נמצא אף נתיב לנקודות שסיפקת.',
    'LBL_MAPS_GEOCODE_STATUS' => 'סטטוס קוד גאוגרפי',
    'LBL_MAPS_GEOCODED' => 'עם קידוד גאוגרפי',
    'LBL_MAPS_NOT_GEOCODED' => 'בלי קידוד גאוגרפי',
    'LBL_MAPS_NOT_FOUND' => 'כתובת לא חוקית',
    'LBL_MAPS_GEOCODING_FAILED' => 'קידוד גאוגרפי נכשל',
    'LBL_MAPS_QUEUED' => 'בתור',
    'LBL_MAPS_REQUEUED' => 'הוכנס שוב לתור',
    'LBL_MAPS_RELATED_RECORD' => 'רשומה קשורה',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'צפייה בדוח',
    'LBL_REPORT_DASHLET_DESC' => 'הצגת דוח שמור',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'איפוס לברירות המחדל של חלונית',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'איפוס לברירות המחדל של דוח',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'רענון תוצאות',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'העתקת תרשים ללוח',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'הורדת תרשים',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'הדוח של החלונית {{label}} נערך, והחלונית עברה איפוס לתצורת ברירת המחדל.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'אין לך הרשאה להשתמש בשדה זה.',

    'LBL_INVALID_FORMULA' => 'נוסחה לא חוקית',
    'LBL_RETURN_TYPE_MISSMATCH' => 'סוג ההחזרה של הפונקציה אינו מתאים',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'תחזית',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'פרופיל לקוח אידאלי',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'סגירת דירוגי חיזוי שבוע',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'ערך חיזוי',
    'LBL_AI_CONV_BIN_ACCURACY' => 'דיוק תא חיזוי',
    'LBL_AI_CONV_MULTIPLIER' => 'מכפיל חיזוי',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ערך ICP',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'דיוק תא ICP',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'מכפיל ICP',
    'LBL_AI_NEW' => 'חדש',
    'LBL_AI_ENTERED' => 'הוזן',
    'LBL_AI_CREATED' => 'נוצר',
    'LBL_AI_WEEK' => 'שבוע',
    'LBL_AI_MONTH' => 'חודש',
    'LBL_AI_QUARTER' => 'רבעון',
    'LBL_AI_BYWEEK' => 'לפי שבוע',
    'LBL_AI_BYMONTH' => 'לפי חודש',
    'LBL_AI_BYQUARTER' => 'לפי רבעון',
    'LBL_AI_WEEKTREND' => 'מגמה שבועית',
    'LBL_AI_MONTHLYTREND' => 'מגמה חודשית',
    'LBL_AI_QUARTERTREND' => 'מגמה רבעונית',
    'LBL_AI_TREND' => 'מגמה לפי',
    'LBL_AI_TRENDS' => 'מגמות לפי',
    'LBL_AI_VELOCITY' => 'מהירות',
    'LBL_AI_TOPX' => '{X} המובילים',
    'LBL_AI_TIMESPAN' => 'טווח זמן בין השלבים -',
    'LBL_AI_BUSINESSTREND' => 'עם מגמות עסקיות',
    'LBL_AI_SUGARINSIGHTINTRO' => 'הכירו את Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights ממנף ניתוח כמותי כדי ליצור תובנות חדשות לגבי הנתונים שלכם ב-SugarCRM. אנו ב-Sugar תמיד מחפשים דרכים חדשות שיעזרו לכם להפיק את המרב מהנתונים שלכם, לקבל החלטות מושכלות, וזו רק ההתחלה של מה שאנחנו מקווים להציע עם Sugar Insights.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights ממנף ניתוח כמותי כדי ליצור תובנות חדשות לגבי הנתונים שלכם ב-SugarCRM.',
    'LBL_AI_FIRMO' => 'מידע ארגוני גרפי',
    'LBL_AI_TOTALCOUNT' => 'המספר הכולל של',
    'LBL_AI_DAYSFROMLATESTACT' => 'ימים מאז הפעם האחרונה',
    'LBL_AI_DAYSSINCE' => 'גיל',
    'LBL_AI_FIELDISSET' => 'קיים',
    'LBL_AI_CONTACTCOMPLETENESS' => 'שלמות פרטי הקשר',
    'LBL_AI_CUTDATE' => 'תקופת החיזוי',
    'LBL_AI_FROMLASTCHANGE' => 'ימים מאז השינוי האחרון בערך התכונה',
    'LBL_AI_CALLSHELD' => 'המספר הכולל של שיחות שבוצעו',
    'LBL_AI_CALLSPLANNED' => 'המספר הכולל של שיחות מתוכננות',
    'LBL_AI_OUTBOUNDCALLS' => 'המספר הכולל של שיחות יוצאות',
    'LBL_AI_INBOUNDCALLS' => 'המספר הכולל של שיחות נכנסות',
    'LBL_AI_AVGCALLDURATION' => 'משך שיחות ממוצע',
    'LBL_AI_EMAILSARCHIVED' => 'המספר הכולל של הודעות דוא"ל שנשמרו בארכיון',
    'LBL_AI_EMAILSREAD' => 'המספר הכולל של הודעות דוא"ל שנקראו',
    'LBL_AI_EMAILSSENT' => 'המספר הכולל של הודעות דוא"ל שנשלחו',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'המספר הכולל של רשומות שבהן תאריך הסגירה הצפוי הוחלף בתאריך מאוחר יותר',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'המספר הכולל של רשומות שבהן תאריך הסגירה הצפוי הוחלף בתאריך מוקדם יותר',
    'LBL_AI_AMOUNTINCREASED' => 'סך ההזדמנויות שבהן הסכום עלה',
    'LBL_AI_AMOUNTDECREASED' => 'סך ההזדמנויות שבהן הסכום ירד',

    // User last state
    'LBL_LAST_STATE' => 'מצב אחרון',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'שלח ל-DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'ביטול עריכת נמען',
    'LBL_RECIPIENT_ROLE' => 'תפקיד הנמען',
    // Base sales stages
    'LBL_OPEN' => 'פתח',
    'LBL_CLOSED_WON' => 'נסגר בהצלחה',
    'LBL_CLOSED_LOST' => 'נסגר ואבד',
    'LBL_KIOSK_ADD_FILES' => 'הוספת קבצים',
    'LBL_KIOSK_ADD_DROP_FILES' => 'הוספה או שחרור של קבצים כאן',
    'LBL_KIOSK_CANCEL' => 'ביטול',
    'LBL_KIOSK_EDIT' => 'עריכה',
    'LBL_KIOSK_EMAIL' => 'דוא"ל',
    'LBL_KIOSK_FILES_UPLOADING' => 'העלאה',
    'LBL_KIOSK_FILES_ERROR' => 'העלאת הקובץ המצורף נכשלה',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'הקובץ המצורף גדול מדי',
    'LBL_KIOSK_FILTER_SEARCH' => 'חיפוש',
    'LBL_KIOSK_ID' => 'מזהה',
    'LBL_KIOSK_TITLE' => 'קיוסק',
    'LBL_KIOSK_LANGUAGE' => 'שפה',
    'LBL_KIOSK_LAST_UPDATED' => 'עודכן לאחרונה ב:',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'תצוגה',
    'LBL_KIOSK_MENU' => 'תפריט',
    'LBL_KIOSK_MOBILE_PHONE' => 'טלפון נייד',
    'LBL_KIOSK_MY_ACTIVITIES' => 'הפעילויות שלי',
    'LBL_KIOSK_MY_PROFILE' => 'הפרופיל שלי',
    'LBL_KIOSK_NAME' => 'שם',
    'LBL_KIOSK_OFFICE_PHONE' => 'טלפון בעבודה',
    'LBL_KIOSK_ORGANIZATION' => 'ארגון',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'שורות בעמוד:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'מופעל על ידי SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'לשמור שינויים',
    'LBL_KIOSK_SHOW_HIDE' => 'הצג / הסתר',
    'LBL_KIOSK_SIGN_IN' => 'כניסה',
    'LBL_KIOSK_SIGN_OUT' => 'יציאה',
    'LBL_KIOSK_SORT_BY' => 'מיון לפי',
    'LBL_KIOSK_SUBMIT' => 'הגש',
    'LBL_KIOSK_TIMEZONE' => 'אזור זמן',
    'LBL_KIOSK_ACTIVITY' => 'פעילות',
    'LBL_KIOSK_NO_ACTIVITY' => 'אין פעילות להציג',
    'LBL_KIOSK_OLDEST_FIRST' => 'הכי ישן ראשון',
    'LBL_KIOSK_NEWEST_FIRST' => 'הכי חדש ראשון',
    'LBL_KIOSK_SHOW_MORE' => 'הצג עוד',
    'LBL_KIOSK_ADD_A_REPLY' => 'הוספת תשובה',
    'LBL_KIOSK_REPLY_EMPTY' => 'אי אפשר להשאיר תשובה ריקה.',
    'LBL_KIOSK_NUM_MORE' => 'עוד {{num}}',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'ברוכים הבאים',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'קבל גישה מהירה למשאבים שלך.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'חיפוש אירועים',
    'LBL_KIOSK_SHOW_ALL' => 'הצג הכול',
    'LBL_KIOSK_404_TITLE' => 'לא מצאנו',
    'LBL_KIOSK_TENANT_404_TITLE' => 'הדייר לא נמצא',
    'LBL_KIOSK_404_MESSAGE' => 'הקישור שעליו לחצת הוסר, אינו זמין באופן זמני, או שהזנת כתובת URL לא חוקית.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'נא לוודא שמדובר בכתובת ה-URL הנכונה. לקבלת סיוע נוסף, פנה לתמיכה.',
    'LBL_KIOSK_BACK_TO_HOME' => 'חזרה הביתה',
    'LBL_KIOSK_ERROR_CODE' => 'שגיאת {code}‏: ',
    'LBL_KIOSK_401_TITLE' => 'לא מורשה',
    'LBL_KIOSK_401_MESSAGE' => 'אינך מורשה לצפות בדף זה.',
    'LBL_KIOSK_403_TITLE' => 'לא מורשה',
    'LBL_KIOSK_403_MESSAGE' => 'אין לך גישה לצפייה בדף זה.',
    'LBL_KIOSK_500_TITLE' => 'השרת לא מגיב',
    'LBL_KIOSK_500_MESSAGE' => 'משהו השתבש בצד שלנו.',
    'LBL_KIOSK_GO_BACK' => 'חזור',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'נמצאה רשומה כפולה',
    'LBL_KIOSK_ACCOUNT' => 'חשבון',
    'LBL_KIOSK_STATUS' => 'סטטוס',
    'LBL_KIOSK_DEACTIVATE' => 'השבת',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'המשתמש הושבת',
    'LBL_KIOSK_MANAGE_USERS' => 'ניהול משתמשים',
    'LBL_KIOSK_LAST_LOGIN' => 'הכניסה האחרונה',
    'LBL_KIOSK_FIRST_NAME' => 'שם פרטי',
    'LBL_KIOSK_LAST_NAME' => 'שם משפחה',
    'LBL_KIOSK_ROLE' => 'תפקיד',
    'LBL_KIOSK_INVITE' => 'הזמן',
    'LBL_KIOSK_SEND_INVITES' => 'שלח הזמנות',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'ההזמנות נשלחו',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'ההזמנות לא נשלחו',
    'LBL_KIOSK_REACTIVATE' => 'הפעל מחדש',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'המשתמש הופעל מחדש',
    'LBL_KIOSK_RESET_PASSWORD' => 'איפוס סיסמה',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'הודעת איפוס סיסמה נשלחה בדוא"ל',
    'LBL_KIOSK_USER_PROFILE' => 'פרופיל משתמש',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'המשתמש שלך הושבת. נא לפנות למנהל המערכת.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'חזרה להתחברות',
    'LBL_KIOSK_REVOKE_INVITATION' => 'בטל הזמנה',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'ההזמנה בוטלה',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'חיפוש ובחירה...',
    'LBL_KIOSK_NO_MATCHES' => 'לא נמצאו התאמות',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'הפרופיל עודכן.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'שגיאה בעדכון הפרופיל.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'הנדון: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'מסמכים',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'אפשר להציג את המסמכים המשותפים הנכנסים, לכלול אותם בחיפושים ולהוריד אותם.',
    'LBL_KIOSK_CASES' => 'אירועים',
    'LBL_KIOSK_CASES_DESC' => 'אפשר להציג את האירועים ששותפו איתך, לכלול אותם בחיפושים ולהשיב להם.',
    'LBL_KIOSK_DOWNLOAD' => 'הורדה',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'הקובץ ירד',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'תחילת העבודה',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'כדי שנוכל לסייע לך טוב יותר, נא לספק לנו את השם הפרטי ושם המשפחה שלך.',
    'LBL_KIOSK_SAVE' => 'שמירה',
    'LBL_KIOSK_SHARED' => 'משותף',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'ברוך בואך, {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'צבע הרקע',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'כתובת URL של תמונת רקע',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'מומלץ לבחור קובץ תמונה הקטן מ-400K.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'סוג רקע',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'רקע הבית',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'ערכת נושא',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'צבע ערכת נושא ראשית',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'שם האפליקציה',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'זוהי הכותרת של האפליקציה, והיא מופיעה לצד הלוגו שלך.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'כתובת URL ללוגו אפליקציה',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'מומלץ לבחור לוגו שאפשר להציג באופן מיטבי בגדלים קטנים (למשל, בפרופילים של מדיה חברתית). מומלץ גם לבחור קובץ הקטן מ-200K.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'URL לסמל מועדפים לאפליקציה',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'סמל מועדפים הוא לוגו קטן שמופיע ליד דף הכותרת בכרטיסיית דפדפן.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'הקצאה אוטומטית מחדש של פעילויות פתוחות',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'הגעת למגבלת משתמשים',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'מפתח רישיון לא בתוקף',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'אפליקציה לא תקפה',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'אפליקציה לא תקפה',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'מפתח אימות פגום',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'תוקף הרישיון פג',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'מידע חסר',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'מפתח אימות חסר',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'חסרה גישה למשתמש',
    'LBL_DRI_WORKFLOW' => 'מדריך חכם',
    'LBL_DRI_WORKFLOWS' => 'מדריכים חכמים',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'תבנית שלב של מדריכים חכמים',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'תבניות שלבים של מדריכים חכמים',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'תבנית מדריך חכם',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'תבנית פעילות של מדריכים חכמים',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'תבניות פעילות',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'רכיבי Web Hook',
    'LBL_CJ_WEBHOOKS' => 'רכיבי Web Hook של Sugar Automate',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'פעילות מדריך חכם נוכחית ב:',
    'LBL_CJ_WEBHOOKS' => 'רכיבי Web Hook של Sugar Automate',
    'LBL_CJ_WEBHOOK' => 'Web Hook של Sugar Automate',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'פעולות ב-Sugar',
    'LBL_CJ_FORMS' => 'פעולות Smart Guide ב-Sugar',
    'LBL_CJ_FORM' => 'פעולת Smart Guide ב-Sugar',
    'LBL_DRI_SUBWORKFLOW' => 'שלב מדריך חכם',
    'LBL_DRI_SUBWORKFLOWS' => 'שלבי מדריך חכם',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'תבניות פעילות של מדריכים חכמים',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'תבניות של מדריכים חכמים',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'סדר מדריך חכם',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'סדר מדריך חכם בפועל',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'ציון מדריך חכם',
    'LBL_CJ_MOMENTUM_POINTS' => 'נקודות Momentum של מדריך חכם',
    'LBL_CJ_MOMENTUM_SCORE' => 'ציון Momentum של מדריך חכם',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'מדריך חכם - אפשר פעילות לפי',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'התקדמות מדריך חכם',
    'LBL_CJ_MOMENTUM_RATIO' => 'יחס Momentum של מדריך חכם',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'נקודות מדריך חכם',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'משימת מדריך חכם',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'סוג פעילות הורה של מדריך חכם',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'מדריך חכם נחסם על-ידי',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'מדריך חכם נחסם לפי שלבים',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'מזהה פעילות הורה של מדריך חכם',
    'LBL_START_NEXT_JOURNEY_ID' => 'התחל את מזהה המדריך החכם הבא',
    'LBL_CJ_URL' => 'כתובת URL של מדריך חכם',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'פעילות הורה של מדריך חכם',
    'LBL_CJ_MOMENTUM_START_DATE' => 'תאריך תחילת Momentum של מדריך חכם',
    'LBL_CJ_MOMENTUM_END_DATE' => 'תאריך סיום Momentum של מדריך חכם',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'קביעת תצורה של רכיבים גרפיים',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'קביעת תצורה של רכיבים גרפיים',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'מספר מרבי של מדריכים חכמים מאותה תבנית',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'פעיל',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'בארכיון',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'הצג',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'הסתר',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'מצב אנכי',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'מצב אופקי',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'רישיון לא תקף',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>הפעילויות הבאות של מדריכים חכמים הוקצו על-ידי {{assigned_by}} למשתמש {{assigned_user}}.</p>
    <ul>{{activities}}</ul>
    
    <p>אפשר לעיין בפעילויות אלה בכתובת:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'רישיון לא תקף',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'הגעת למגבלת המשתמשים, יש לך {{gracePeriodDays}} ימים לשדרג את הרישיון.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - פעילויות מדריכים חכמים שהוקצו',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'חרגת ממגבלת המשתמשים שלך ב-Sugar Automate,‏ {0}<br>
    <br>
    נא לפנות אל <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> כדי להגדיל את מגבלת המשתמשים או להקטין את מספר המשתמשים בתוסף.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'הגעת למגבלת המשתמשים ב-Sugar Automate',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'תוקף הרישיון שלך ל-Sugar Automate יפוג עוד {0} ימים. <br>
    <br>
    נא לפנות אל SugarCRM או אל שותף Sugar כדי לחדש ולמנוע הפרעה לשירות.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'רישיון Sugar Automate יפוג בקרוב',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'בדיקת Webhook',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'התקדמות Smart Guide',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'מציג את תרשים העוגה "התקדמות Smart Guide" ב-Sugar Automate.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'להצגה של תגובת ה-Webhook',
    'LBL_DASHLET_SEND_LABEL' => 'שלח בקשה',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'הקצה אותי',
    'LBL_COMPLETE_BUTTON_TITLE' => 'הושלם',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'השלם את כל המשימות',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'מחק שלב',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'התחל',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'לא ישים',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'הוסף שלב',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'הצג',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'עריכת מדריך חכם',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'ביטול',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'שמור בארכיון',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'בטל שמירה בארכיון',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'הגדרת תבנית',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'הוסף משימה',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'תזמן פגישה',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'תזמן שיחה',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'חל בעתיד',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'באיחור',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'חל היום',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'חל מחר',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'בטוח שברצונך לבטל מדריך חכם זה?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'הפעולה תשלים את כל המשימות. בטוח שרוצה להמשיך?',
    'LBL_CJ_BLOCK_BY' => 'יש משימה תלויה שלא נפתרה: {{Name}}. נא להשלים משימה זו לפני בחירה באפשרות להשלים את כל המשימות.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'יש כמה משימות תלויות שלא נפתרו. נא להשלים משימות אלה לפני בחירה באפשרות להשלים את המשימות.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'הצלחת להשלים את כל המשימות',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'בטוח שברצונך לשמור מדריך חכם זה בארכיון?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'בטוח שברצונך להוציא מדריך חכם זה מהארכיון?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: מדריכים חכמים (Focus Drawers וקונסולה)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'להצגת מדריכים חכמים פעילים בלוחות מחוונים של Focus Drawer וקונסולת שירות/חידושים.',
    'LBL_CJ_PROCESSING_REQUEST' => 'מעבד..',
    'LBL_CJ_SUCCESS' => 'הצלחת להשלים את כל המשימות',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => 'המודול {module} לא מופעל',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'כל הגדרות התצוגה נשמרו.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Momentum של מדריך חכם',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'להצגת תרשים המד "Momentum של מדריך חכם" ב-Sugar Automate.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'התקדמות Smart Guide',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'מציג את תרשים העוגה "התקדמות Smart Guide" ב-Sugar Automate.',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'ההורה לא נמצא',
    'CJ_NOT_FOUND_EXCEPTION' => 'המערכת לא מצאה {moduleName} עם {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'יש להשלים או לבטל את המדריך החכם לפני האחסון בארכיון',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate לא מופעל ברישיון Sugar הנוכחי',
    'LBL_ACTION_NOT_FOUND' => 'הפעולה לא נמצאה, נא לפנות למנהל המערכת',
    'LBL_CJ_SELECT_FIELD' => 'בחירת שדה',
    'LBL_CJ_SELECT_OPERATOR' => 'בחירת אופרטור',
    'LBL_CJ_SELECT_VALUE' => 'בחירת ערך',
    'LBL_CJ_ENTER_VALUE' => 'הזנת ערך',
    'LBL_CJ_FORM_BATCH_TITLE' => 'שמירת רשומה',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'זוהו Smart Guides פעילים...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'מעבד פעולות פעילות ב-Sugar...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'מעדכן Smart Guides פעילים...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'הרשומה ומדריכי Smart Guide המשויכים אליה עודכנו.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'עדכון Smart Guide משויך נכשל. אם השגיאה נמשכת, נא לפנות למנהל המערכת שלך ב-Sugar כדי לקבל סיוע.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'עדכון Smart Guide משויך נכשל. נא לעיין ב<a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">יומנים</a> כדי לפתור את השגיאה.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => 'הקישור של <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} הצליח.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'הייתה בעיה בקישור של <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}}. אם הבעיה נמשכת, נא לפנות לצוות התמיכה של Sugar.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => 'הקישור של {{modulePluralLower}} הצליח.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'הייתה בעיה בקישור של {{modulePluralLower}}. אם הבעיה נמשכת, נא לפנות לצוות התמיכה של Sugar.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'הייתה בעיה בקישור של {{moduleSingularLower}}. אם הבעיה נמשכת, נא לפנות לצוות התמיכה של Sugar.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'כבר יש {{moduleSingularLower}} בשם <a href="#{{module}}/{{id}}">{{name}}</a> בשלב {{stage}}.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'כבר בחרת {{moduleSingularLower}} בשם <a href="#{{module}}/{{id}}">{{name}}</a>.',
    'LBL_CJ_ARCHIVED' => 'בארכיון',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'בחירת תבנית Smart Guide...',
    'LBL_ALL_SMART_GUIDES' => 'כל מדריכי Smart Guide',
    'LBL_ACTIVE_SMART_GUIDES' => 'מדריכי Smart Guide פעילים',
    'LBL_ARCHIVED_SMART_GUIDES' => 'מדריכי Smart Guide בארכיון',
    'LBL_VERTICAL_SCROLL_VIEW' => 'תצוגה אנכית מוערמת',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'תצוגת גלילה אופקית',
    'LBL_DRI_WORKFLOWS_FILTER' => 'מסנן',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'אי אפשר להשלים את הפעולה. שדה הסטטוס עבור מודול פעילויות זה מוגדר "לקריאה בלבד", מה שמונע פעולות Smart Guide המעדכנות את שדה הסטטוס.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'אי אפשר להשלים את הפעולה. שדה הסטטוס עבור מודולי פעילויות ופעילויות-משנה אלה מוגדרים "לקריאה בלבד", מה שמונע פעולות Smart Guide המעדכנות את שדה הסטטוס.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'שדה הסטטוס עבור חלק ממודולי הפעילויות שבמדריך מוגדרים "לקריאה בלבד", ואותן פעילויות יישארו ללא שינוי בעת ביטול המדריך.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'הועתק אל הלוח.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'מחק את כל החזרות',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'הגדרות חזרה לא תקינות',
    'ERROR_INTERVAL_INVALID' => 'על מרווח הזמנים לחזרות להיות בין 1 ל-99',
    'LBL_RECURRENCE_ADD' => 'הגדר',
    'LBL_REPEAT_DAYS' => 'ימים בחודש',
    'LBL_REPEAT_END_TYPES' => 'חזרה',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'ספק ניווט',
    'LBL_MOBILE_PDF_EMAIL' => 'שלח בדואר אלקטרוני PDF של {{{pdfTemplateName}}}',
    'LBL_MOBILE_EMAIL_SENDING' => 'שולח',
    'LBL_MOBILE_EMAIL_SENT' => 'נשלח',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'הודעת הדוא"ל נשמרה כטיוטה.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'הוסף קובץ מצורף',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'להעלות ממקומי',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'מסמך Sugar',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'פעולת עריכה שלך ברשומה זו שינתה את התצוגה.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'הערות מוצר לאפליקציית SugarCRM לנייד',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'מדריך למשתמש של אפליקציית SugarCRM לנייד',
    'ERR_MOBILE_ROOTED' => 'אי אפשר להשתמש ב-Sugar Mobile במכשיר נייד שעבר פריצת Root. נא לפתוח את האפליקציה במכשיר שלא עבר פריצת Root.',
    'LBL_VO_BUILD_ROUTE' => 'בנה מסלול',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'מסנן המרחק שלי',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'המסמך ייווצר ברקע. כדי לגשת לקובץ, אפשר לפתוח את הדף &#39;מיזוגי מסמכים&#39;.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'קבלת התבנית נכשלה. נא לפנות למנהל המערכת כדי לקבל סיוע.',
    'LBL_MAP_ERROR_LOAD' => 'אי אפשר לטעון מפה',
    'LBL_MAP_DISTANCE' => 'מרחק',
    'LBL_SELECT_UNIT_TYPE' => 'סוג יחידה',
    'LBL_MAPS_UNIT_MILES' => 'מיילים',
    'LBL_MAPS_UNIT_KILOMETERS' => 'קילומטרים',
    'LBL_RADIUS' => 'רדיוס',
    'LBL_ZIP_CODE' => 'מיקוד',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'בחר כתובת',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'אי אפשר ליצור קוד גיאוגרפי מהכתובת:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'הרשומה לא עברה קידוד גיאוגרפי.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'הרשומה לא מכילה שום נתוני כתובת. רוצה לאתר את הרשומה באופן ידני במפה?',
    'LBL_ERR_SHOW_ON_MAP' => 'פתיחת המפה לרשומות הנבחרות נכשלה.',
    'LBL_ERR_MISSING_ON_MAP' => 'לחלק מהרשומות חסרים נתוני כתובת, והן לא מוצגות',
    'LBL_MAPS_ROUTE' => 'מסלול',
    'LBL_MAPS_PROVIDER' => 'Sugar Maps',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'אי אפשר לקבוע מיקום נוכחי.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'המיפוי תומך ב-{{{num}}} רשומות לכל היותר.',
    'LBL_ALL_MODULES' => 'כל המודולים',
    'LBL_DRIVE_SHARE_LINK' => 'שתף קובץ',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'טעינת הקבצים נכשלה.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'השם לא יכול להיות ריק',
    'LBL_DRIVE_FOLDER_CREATED' => 'התיקייה נוצרה.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'יצירת התיקייה נכשלה.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'העלאת הקובץ נכשלה.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'נא ליצור תחילה תיקיית בסיס',
    'LBL_EDIT_ALL_RECURRENCES' => 'ערוך את כל החזרות',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'אי אפשר לפתוח את הקובץ ב-Dropbox',
    'LBL_FILE_NOT_AVAILABLE' => 'אי אפשר לפתוח את הקובץ',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'הנחיות הגעה',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'לא נמצא אף מסלול לנקודות הציון שסופקו',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'קרוב',
    'LBL_TAGS' => 'תגיות',

    'LBL_CALLER_ID_SETTINGS' => 'הגדרות שיחה מזוהה',
    'LBL_CALLER_ID_ENABLED' => 'שיחה מזוהה מופעלת',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'בשיחות נכנסות, יופיע שם איש הקשר או הליד שתואם למספר הטלפון.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'כדי לאפשר לאפליקציה לנייד להציג שיחות מזוהות, יש לבצע שלבים אלה אצלך במכשיר:<br><br>1. פתח את ה&#39;הגדרות&#39; של iOS > &#39;טלפון&#39; > &#39;חסימה וזיהוי של שיחות&#39;.<br>2. הפעל את "{{{brandName}}}".',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'כדי לאפשר לאפליקציה להציג שיחות מזוהות, יש לבצע שלבים אלה אצלך במכשיר:<br>1. פתח את הגדרות האפליקציה.<br>2. עבור ל&#39;הרשאות&#39;.<br>3. הפעל את ההרשאה &#39;טלפון&#39;.<br><br> כדי להגדיר אפליקציה זו בתור אפליקציית ברירת המחדל לניהול שיחות מזוהות, עבור להגדרות המכשיר שלך.<br>1. עבור אל &#39;אפליקציות&#39;.<br>2. בחר אפליקציות ברירת מחדל.<br>3. בחר אפליקציית שיחה מזוהה וזיהוי זבל.<br>4. בחר אפליקציה זו בתור ברירת המחדל.',
    'LBL_CALLER_ID_SYNC_HINT' => 'בדוק אם יש שינויים בפרטי הקשר מהרשומות (לדוגמה, &#39;אנשי קשר&#39;, &#39;לידים&#39;) בסביבה שלך ב-Sugar.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'עבור להגדרות',
    'LBL_CALLER_ID_SYNC' => 'סנכרון נתוני רשומות',
    'LBL_CALLER_ID_NOT_ENABLED' => 'לפני הסנכרון, יש להפעיל את אפשרות השיחה המזוהה בהגדרות המערכת.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'הפעל',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'מאוחר יותר בהגדרות',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'אפליקציה זו תומכת בתכונת השיחה המזוהה.<br> למען התפקוד התקין של התכונה, אחרי לחיצה על לחצן ההפעלה, המערכת תבקש ממך לתת שתי הרשאות.<br> כדי להבטיח פעולה נכונה של תכונת השיחה המזוהה, צריך לתת הרשאה לניהול שיחות ולבחור באפליקציה זו בתור אפליקציית ברירת המחדל לניהול שיחות מזוהות.<br> מבלי לתת את ההרשאה לנהל שיחות, גם לא תהיה לך אפשרות לרשום ביומן השיחות את השיחות שבוצעו מאפליקציה זו.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'כדי לאפשר לאפליקציה לנייד של SugarCRM להציג שיחות מזוהות, יש לבצע שלבים אלה אצלך במכשיר:<br><br>1. פתח את ה&#39;הגדרות&#39; של iOS > &#39;טלפון&#39; > &#39;חסימה וזיהוי של שיחות&#39;.<br>2. הפעל את האפליקציה.',
    'LBL_MOBILE_LAST_SYNC' => 'סנכרון אחרון',
    'LBL_CALLER_ID_SYNCING' => 'מסנכרן עם השרת.',
    'LBL_NEVER' => 'אף פעם לא',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} לא יכול להיות ריק.',
    'LBL_ADD_RELATED_RECORD' => '{{{moduleSingular}}} קשור/ה',
    'LBL_CALLER_ID_NO_PERMISSION' => 'אין לך ההרשאות הדרושות לשימוש בשיחה מזוהה. נא לפנות למנהל המערכת.',
    'LBL_CALLER_ID_FETCHING' => 'מסנכרן…',
    'LBL_CALLER_ID_FETCH_ALL' => 'לסנכרן את כל הרשומות',
    'LBL_CALLER_ID_FETCH_NEW' => 'לבדוק אם יש עדכונים לרשומות',

    'LBL_SORT_BY' => 'מיון לפי',
    'LBL_PRIMARY_SORT' => 'מיון ראשי',
    'LBL_SECONDARY_SORT' => 'מיון משני',
    'LBL_OF' => 'מתוך',
    'LBL_TABLE_FREEZE_FIRST' => 'הקפאת עמודה ראשונה',
    'LBL_TABLE_SETTINGS_TITLE' => 'אפשרויות תצוגת עמודה',
    'LBL_TABLE_SETTINGS_NO_COL' => 'יש לבחור עמודה אחת לפחות.',
    'LBL_TABLE_TOGGLER_INFO' => 'אפשר להציג עמודות או להסתיר אותן וגם לגרור אותן לפי הסדר המועדף.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'מסנני זמן ריצה',
    'LBL_FILTER_CONDITION' => 'בחר תנאי',
    'LBL_FILTER_VALUES' => 'ערכים',
    'LBL_TABLE_EXPAND' => 'הרחב הכול',
    'LBL_TABLE_COLLAPSE' => 'כווץ הכול',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'שגיאת שרת. לא הייתה אפשרות לטעון מסנני זמן ריצה רלוונטיים.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'מנויי דחיפה של אירוע מודול Pub/Sub',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'מנוי דחיפה של אירוע מודול Pub/Sub',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'פאנל - עליון',
    'panel_bottom' => 'פאנל - תחתון',
    'tab_first' => 'כרטיסייה - ראשונה',
    'tab_last' => 'כרטיסייה - אחרונה',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'בשבעת הימים האחרונים',
    '30' => 'בשלושים הימים האחרונים',
    '90' => 'ברבעון שעבר',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'היום',
    'future' => 'עתיד',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'כן',
    'group' => 'לא',
];

$app_list_strings['history_filter_options'] = [
    7 => 'בשבעת הימים האחרונים',
    30 => 'בשלושים הימים האחרונים',
    90 => 'ברבעון שעבר',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'כן',
    'group' => 'לא',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'כן',
    'group' => 'לא',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'כן',
    '0' => 'לא',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'ברבעון הנכחי',
    'next' => 'ברבעון הבא',
    'year' => 'השנה',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'הרישומים שלי',
    'group' => 'רישומי קבוצה',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'הדוחות שלי',
    'group' => 'הצינור של הצוות שלי',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'התחזית שלי',
    'group' => 'התחזית של הצוות שלי',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'הזדמנויות',
    'RevenueLineItems' => 'שורות פרטי הכנסה',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'תאריך סגירה אחרון',
    'earliest' => 'תאריך סגירה ראשון',
];

$app_list_strings['moduleList']['Library'] = 'ספריה';
$app_list_strings['moduleListSingular']['Library'] = 'ספריה';
$app_list_strings['library_type'] = ['Books' => 'ספר', 'Music' => 'מוסיקה', 'DVD' => 'DVD', 'Magazines' => 'מגזינים'];
$app_list_strings['moduleList']['EmailAddresses'] = 'כתובת דואר אלקטרוני:';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'כתובת דואר אלקטרוני:';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'טיוטה',
    'in-review' => 'בסקירה',
    'approved' => 'אושר',
    'published' => 'בוצע בהצלחה',
    'expired' => 'פג תוקף',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--פעולות אדמין--',
        'Create New Tag' => 'צור תגית חדשה',
        'Delete Tag' => 'מחק תגית',
        'Rename Tag' => 'שנה שם תגית',
        'Move Selected Articles' => 'הסר מאמרים שנבחרו',
        'Apply Tags On Articles' => 'החל תגיות למאמרים',
        'Delete Selected Articles' => 'מחק מאמרים שנבחרו',
    ];

$app_list_strings['moduleList']['Words'] = 'מילים';
$app_list_strings['moduleListSingular']['Words'] = 'מילה';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'צור מאמר';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'אבו דאבי',
    'ADEN' => 'אדן',
    'AFGHANISTAN' => 'אפגניסטן',
    'ALBANIA' => 'אלבניה',
    'ALGERIA' => 'אלג&#39;יריה',
    'AMERICAN SAMOA' => 'סמואה האמריקאית',
    'ANDORRA' => 'אנדורה',
    'ANGOLA' => 'אנגולה',
    'ANTARCTICA' => 'אנטרקטיקה',
    'ANTIGUA' => 'אנטיגווה',
    'ARGENTINA' => 'ארגנטינה',
    'ARMENIA' => 'ארמניה',
    'ARUBA' => 'ארובה',
    'AUSTRALIA' => 'אוסטרליה',
    'AUSTRIA' => 'אוסטריה',
    'AZERBAIJAN' => 'אזרבייג&#39;ן',
    'BAHAMAS' => 'איי הבהאמה',
    'BAHRAIN' => 'בחריין',
    'BANGLADESH' => 'בנגלדש',
    'BARBADOS' => 'ברבדוס',
    'BELARUS' => 'בלרוס',
    'BELGIUM' => 'בלגיה',
    'BELIZE' => 'בליז',
    'BENIN' => 'בנין',
    'BERMUDA' => 'ברמודה',
    'BHUTAN' => 'בהוטאן',
    'BOLIVIA' => 'בוליביה',
    'BOSNIA' => 'בוסניה',
    'BOTSWANA' => 'בוטסוואנה',
    'BOUVET ISLAND' => 'אי בובט',
    'BRAZIL' => 'ברזיל',
    'BRITISH ANTARCTICA TERRITORY' => 'הטריטוריה הבריטית באנטרקטיקה',
    'BRITISH INDIAN OCEAN TERRITORY' => 'הטריטוריה הבריטית באוקיינוס ההודי',
    'BRITISH VIRGIN ISLANDS' => 'איי הבתולה הבריטיים',
    'BRITISH WEST INDIES' => 'איי הודו המערבית בריטיים',
    'BRUNEI' => 'ברוני',
    'BULGARIA' => 'בולגריה',
    'BURKINA FASO' => 'ורקינה פאסו',
    'BURUNDI' => 'בורונדי',
    'CAMBODIA' => 'קמבודיה',
    'CAMEROON' => 'קמרון',
    'CANADA' => 'קנדה',
    'CANAL ZONE' => 'אזור התעלה',
    'CANARY ISLAND' => 'האיים הקנריים',
    'CAPE VERDI ISLANDS' => 'איי כף ורדה',
    'CAYMAN ISLANDS' => 'איי קיימן',
    'CEVLON' => 'ציילון',
    'CHAD' => 'צ&#39;אד',
    'CHANNEL ISLAND UK' => 'איי התעלה',
    'CHILE' => 'צ&#39;ילה',
    'CHINA' => 'סין',
    'CHRISTMAS ISLAND' => 'אי כריסטמס',
    'COCOS (KEELING) ISLAND' => 'אי קוקוז (קילינג)',
    'COLOMBIA' => 'קולומביה',
    'COMORO ISLANDS' => 'איי קומורו',
    'CONGO' => 'קונגו',
    'CONGO KINSHASA' => 'קונגו קינשאסה',
    'COOK ISLANDS' => 'איי קוק',
    'COSTA RICA' => 'קוסטה ריקה',
    'CROATIA' => 'קרואטיה',
    'CUBA' => 'קובה',
    'CURACAO' => 'קורסאו',
    'CYPRUS' => 'קפריסין',
    'CZECH REPUBLIC' => 'רפובליקת צ&#39;כיה',
    'DAHOMEY' => 'דהומיי',
    'DENMARK' => 'דנמרק',
    'DJIBOUTI' => 'ג&#39;יבוטי',
    'DOMINICA' => 'דומיניקה',
    'DOMINICAN REPUBLIC' => 'הרפובליקה הדומיניקנית',
    'DUBAI' => 'דובאי',
    'ECUADOR' => 'אקוודור',
    'EGYPT' => 'מצרים',
    'EL SALVADOR' => 'אל סלבדור',
    'EQUATORIAL GUINEA' => 'גיניאה המשוונית',
    'ESTONIA' => 'אסטוניה',
    'ETHIOPIA' => 'אתיופיה',
    'FAEROE ISLANDS' => 'איי פרו',
    'FALKLAND ISLANDS' => 'איי פוקלנד',
    'FIJI' => 'פיג&#39;י',
    'FINLAND' => 'פינלנד',
    'FRANCE' => 'צרפת',
    'FRENCH GUIANA' => 'גיניאה הצרפתית',
    'FRENCH POLYNESIA' => 'פולינזיה הצרפתית',
    'GABON' => 'גאבון',
    'GAMBIA' => 'גמביה',
    'GEORGIA' => 'ג&#39;ורג&#39;יה',
    'GERMANY' => 'גרמניה',
    'GHANA' => 'גאנה',
    'GIBRALTAR' => 'גיברלטר',
    'GREECE' => 'יוון',
    'GREENLAND' => 'גרינלנד',
    'GUADELOUPE' => 'גוואדלופ',
    'GUAM' => 'גואם',
    'GUATEMALA' => 'גוואטמלה',
    'GUINEA' => 'גיניאה',
    'GUYANA' => 'גיאנה',
    'HAITI' => 'האיטי',
    'HONDURAS' => 'הונדורס',
    'HONG KONG' => 'הונג קונג',
    'HUNGARY' => 'הונגריה',
    'ICELAND' => 'איסלנד',
    'IFNI' => 'איפני',
    'INDIA' => 'הודו',
    'INDONESIA' => 'אינדונזיה',
    'IRAN' => 'איראן',
    'IRAQ' => 'עיראק',
    'IRELAND' => 'אירלנד',
    'ISRAEL' => 'ישראל',
    'ITALY' => 'איטליה',
    'IVORY COAST' => 'חוף השנהב',
    'JAMAICA' => 'ג&#39;מייקה',
    'JAPAN' => 'יפן',
    'JORDAN' => 'ירדן',
    'KAZAKHSTAN' => 'קזחסטן',
    'KENYA' => 'קניה',
    'KOREA' => 'קוריאה',
    'KOREA, SOUTH' => 'דרום קוריאה',
    'KUWAIT' => 'כוויית',
    'KYRGYZSTAN' => 'קירגיסטן',
    'LAOS' => 'לאוס',
    'LATVIA' => 'לטביה',
    'LEBANON' => 'לבנון',
    'LEEWARD ISLANDS' => 'איי ליוורד',
    'LESOTHO' => 'לסוטו',
    'LIBYA' => 'לוב',
    'LIECHTENSTEIN' => 'ליכטנשטיין',
    'LITHUANIA' => 'ליטא',
    'LUXEMBOURG' => 'לוקסמבורג',
    'MACAO' => 'מקאו',
    'MACEDONIA' => 'מקדוניה',
    'MADAGASCAR' => 'מדגסקר',
    'MALAWI' => 'מלאווי',
    'MALAYSIA' => 'מלזיה',
    'MALDIVES' => 'איי המלדיביים',
    'MALI' => 'מאלי',
    'MALTA' => 'מלטה',
    'MARTINIQUE' => 'מרטיניק',
    'MAURITANIA' => 'מאוריטניה',
    'MAURITIUS' => 'מאוריציוס',
    'MELANESIA' => 'מלנזיה',
    'MEXICO' => 'מקסיקו',
    'MOLDOVIA' => 'מולדובה',
    'MONACO' => 'מונקו',
    'MONGOLIA' => 'מונגוליה',
    'MOROCCO' => 'מרוקו',
    'MOZAMBIQUE' => 'מוזמביק',
    'MYANAMAR' => 'מיאנמר',
    'NAMIBIA' => 'נמיביה',
    'NEPAL' => 'נפאל',
    'NETHERLANDS' => 'הולנד',
    'NETHERLANDS ANTILLES' => 'האנטילים ההולנדים',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'אזור ניטראלי של האנטילים ההולנדים',
    'NEW CALADONIA' => 'קלדוניה החדשה',
    'NEW HEBRIDES' => 'ההברידים החדשים',
    'NEW ZEALAND' => 'ניו זילנד',
    'NICARAGUA' => 'ניקרגוואה',
    'NIGER' => 'ניז&#39;ר',
    'NIGERIA' => 'ניגריה',
    'NORFOLK ISLAND' => 'אי נורפולק',
    'NORWAY' => 'נורווגיה',
    'OMAN' => 'עומאן',
    'OTHER' => 'אחר',
    'PACIFIC ISLAND' => 'אי פסיפי',
    'PAKISTAN' => 'פקיסטן',
    'PANAMA' => 'פנמה',
    'PAPUA NEW GUINEA' => 'פפואה גינאה החדשה',
    'PARAGUAY' => 'פרגוואי',
    'PERU' => 'פרו',
    'PHILIPPINES' => 'הפיליפינים',
    'POLAND' => 'פולין',
    'PORTUGAL' => 'פורטוגל',
    'PORTUGUESE TIMOR' => 'טימור הפורטוגזית',
    'PUERTO RICO' => 'פורטו ריקו',
    'QATAR' => 'קטאר',
    'REPUBLIC OF BELARUS' => 'רפובליקת בלרוס',
    'REPUBLIC OF SOUTH AFRICA' => 'רפובליקת דרום אפריקה',
    'REUNION' => 'איחוד',
    'ROMANIA' => 'רומניה',
    'RUSSIA' => 'רוסיה',
    'RWANDA' => 'רואנדה',
    'RYUKYU ISLANDS' => 'איי ריוקיו',
    'SABAH' => 'סבח',
    'SAN MARINO' => 'סן מרינו',
    'SAUDI ARABIA' => 'ערב הסעודית',
    'SENEGAL' => 'סנגל',
    'SERBIA' => 'סרביה',
    'SEYCHELLES' => 'איי סיישל',
    'SIERRA LEONE' => 'סיירה לאון',
    'SINGAPORE' => 'סינגפור',
    'SLOVAKIA' => 'סלובקיה',
    'SLOVENIA' => 'סלובניה',
    'SOMALILIAND' => 'סומלילנד',
    'SOUTH AFRICA' => 'דרום אפריקה',
    'SOUTH YEMEN' => 'דרום תימן',
    'SPAIN' => 'ספרד',
    'SPANISH SAHARA' => 'סהרה הספרדי',
    'SRI LANKA' => 'סרי לנקה',
    'ST. KITTS AND NEVIS' => 'סנט קיטס ונוויס',
    'ST. LUCIA' => 'סנט לוסיה',
    'SUDAN' => 'סודן',
    'SURINAM' => 'סורינאם',
    'SW AFRICA' => 'דרום מערב אפריקה',
    'SWAZILAND' => 'סווזילנד',
    'SWEDEN' => 'שוודיה',
    'SWITZERLAND' => 'שווייץ',
    'SYRIA' => 'סוריה',
    'TAIWAN' => 'טייוואן',
    'TAJIKISTAN' => 'טג&#39;קיסטן',
    'TANZANIA' => 'טנזניה',
    'THAILAND' => 'תאילנד',
    'TONGA' => 'טונגה',
    'TRINIDAD' => 'טרינידאד',
    'TUNISIA' => 'תוניסיה',
    'TURKEY' => 'טוריקה',
    'UGANDA' => 'אוגנדה',
    'UKRAINE' => 'אוקראינה',
    'UNITED ARAB EMIRATES' => 'איחוד האמירויות הערביות',
    'UNITED KINGDOM' => 'אנגליה',
    'UPPER VOLTA' => 'וולטה העילית',
    'URUGUAY' => 'אורוגוואי',
    'US PACIFIC ISLAND' => 'אי באוקיינוס השקט - ארה"ב',
    'US VIRGIN ISLANDS' => 'איי הבתולה - ארה"ב',
    'USA' => 'ארה"ב',
    'UZBEKISTAN' => 'אוזבקיסטן',
    'VANUATU' => 'ונואטו',
    'VATICAN CITY' => 'עיר הותיקן',
    'VENEZUELA' => 'ונצואלה',
    'VIETNAM' => 'וייטנאם',
    'WAKE ISLAND' => 'אי ווייק',
    'WEST INDIES' => 'איי הודו המערביים',
    'WESTERN SAHARA' => 'סהרה המערבי',
    'YEMEN' => 'תימן',
    'ZAIRE' => 'זאיר',
    'ZAMBIA' => 'זמביה',
    'ZIMBABWE' => 'זימבבואה',
];

$app_list_strings['state_dom'] = [
    'AL' => 'אלבמה',
    'AK' => 'אלסקה',
    'AZ' => 'אריזונה',
    'AR' => 'ארקנסו',
    'CA' => 'קליפורניה',
    'CO' => 'קולורדו',
    'CT' => 'קונטיקט',
    'DE' => 'דלוור',
    'DC' => 'מחוז קולומביה',
    'FL' => 'פלורידה',
    'GA' => 'ג&#39;ורג&#39;יה',
    'HI' => 'הוואי',
    'ID' => 'איידהו',
    'IL' => 'אילינוי',
    'IN' => 'אינדיאנה',
    'IA' => 'איווה',
    'KS' => 'קנזס',
    'KY' => 'קנטאקי',
    'LA' => 'לואיזיאנה',
    'ME' => 'מיין',
    'MD' => 'מרילנד',
    'MA' => 'מסצ&#39;וסטס',
    'MI' => 'מישיגן',
    'MN' => 'מינסוטה',
    'MS' => 'מיסיסיפי',
    'MO' => 'מיזורי',
    'MT' => 'מונטנה',
    'NE' => 'נברסקה',
    'NV' => 'נבאדה',
    'NH' => 'ניו-המפשייר',
    'NJ' => 'ניו ג&#39;רזי',
    'NM' => 'ניו מקסיקו',
    'NY' => 'ניו יורק',
    'NC' => 'צפון קרוליינה',
    'ND' => 'צפון דקוטה',
    'OH' => 'אוהיו',
    'OK' => 'אוקלהומה',
    'OR' => 'אורגון',
    'PA' => 'פנסילבניה',
    'RI' => 'רוד איילנד',
    'SC' => 'דרום קרוליינה',
    'SD' => 'דרום דקוטה',
    'TN' => 'טנסי',
    'TX' => 'טקסס',
    'UT' => 'יוטה',
    'VT' => 'ורמונט',
    'VA' => 'Virginia',
    'WA' => 'וושינגטון',
    'WV' => 'ווסט וירג&#39;יניה',
    'WI' => 'וויסקונסין',
    'WY' => 'וויומינג',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (טייוואן והונג קונג)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS Cyrillic)',
    'CP1252' => 'CP1252 (MS מערב אירופה וארה"ב)',
    'EUC-CN' => 'EUC-CN (סינית מופשטת GB2312)',
    'EUC-JP' => 'EUC-JP (Unix יפנית)',
    'EUC-KR' => 'EUC-KR (קוריאנית)',
    'EUC-TW' => 'EUC-TW (טייוואנית)',
    'ISO-2022-JP' => 'ISO-2022-JP (יפנית)',
    'ISO-2022-KR' => 'ISO-2022-KR (קוריאנית)',
    'ISO-8859-1' => 'ISO-8859-1 (מערב אירופה וארה"ב)',
    'ISO-8859-2' => 'ISO-8859-2 (מרכז ומזרח אירופה)',
    'ISO-8859-3' => 'ISO-8859-3 (Latin 3)',
    'ISO-8859-4' => 'ISO-8859-4 (Latin 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Cyrillic)',
    'ISO-8859-6' => 'ISO-8859-6 (Arabic)',
    'ISO-8859-7' => 'ISO-8859-7 (Greek)',
    'ISO-8859-8' => 'ISO-8859-8 (עברית)',
    'ISO-8859-9' => 'ISO-8859-9 (Latin 5)',
    'ISO-8859-10' => 'ISO-8859-10 (Latin 6)',
    'ISO-8859-13' => 'ISO-8859-13 (Latin 7)',
    'ISO-8859-14' => 'ISO-8859-14 (Latin 8)',
    'ISO-8859-15' => 'ISO-8859-15 (Latin 9)',
    'KOI8-R' => 'KOI8-R (Cyrillic Russian)',
    'KOI8-U' => 'KOI8-U (Cyrillic Ukranian)',
    'SJIS' => 'SJIS (MS Japanese)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Douala' => 'Africa/Douala',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Indian/Comoro' => 'Indian/Comoro',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Asmera' => 'Africa/Asmera',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Lagos' => 'Africa/Lagos',
    'Indian/Reunion' => 'Indian/Reunion',
    'Africa/Kigali' => 'Africa/Kigali',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Dakar' => 'Africa/Dakar',
    'Indian/Mahe' => 'Indian/Mahe',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Harare' => 'Africa/Harare',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Indian/Chagos' => 'Indian/Chagos',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Rangoon' => 'Asia/Rangoon',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Beijing' => 'Asia/Beijing',
    'Asia/Harbin' => 'Asia/Harbin',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Chongqing' => 'Asia/Chongqing',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Kashgar' => 'Asia/Kashgar',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Calcutta' => 'Asia/Calcutta',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Jerusalem' => 'Asia/ירושלים',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Indian/Maldives' => 'Indian/Maldives',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Katmandu' => 'Asia/Katmandu',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Saigon' => 'Asia/Saigon',
    'Asia/Aden' => 'Asia/Aden',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Sydney' => 'Australia/Sydney',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Indian/Christmas' => 'Indian/Christmas',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Indian/Cocos' => 'Indian/Cocos',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Truk' => 'Pacific/Truk',
    'Pacific/Ponape' => 'Pacific/Ponape',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Johnston' => 'Pacific/Johnston',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'Europe/London' => 'Europe/London',
    'Europe/Dublin' => 'Europe/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Brussels' => 'Europe/Brussels',
    'Europe/Sofia' => 'Europe/Sofia',
    'Europe/Prague' => 'Europe/Prague',
    'Europe/Copenhagen' => 'Europe/Copenhagen',
    'Atlantic/Faeroe' => 'Atlantic/Faeroe',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Godthab' => 'America/Godthab',
    'America/Thule' => 'America/Thule',
    'Europe/Tallinn' => 'Europe/Tallinn',
    'Europe/Helsinki' => 'Europe/Helsinki',
    'Europe/Paris' => 'Europe/Paris',
    'Europe/Berlin' => 'Europe/Berlin',
    'Europe/Gibraltar' => 'Europe/Gibraltar',
    'Europe/Athens' => 'Europe/Athens',
    'Europe/Budapest' => 'Europe/Budapest',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Europe/Rome' => 'Europe/Rome',
    'Europe/Riga' => 'Europe/Riga',
    'Europe/Vaduz' => 'Europe/Vaduz',
    'Europe/Vilnius' => 'Europe/Vilnius',
    'Europe/Luxembourg' => 'Europe/Luxembourg',
    'Europe/Malta' => 'Europe/Malta',
    'Europe/Chisinau' => 'Europe/Chisinau',
    'Europe/Monaco' => 'Europe/Monaco',
    'Europe/Amsterdam' => 'Europe/Amsterdam',
    'Europe/Oslo' => 'Europe/Oslo',
    'Europe/Warsaw' => 'Europe/Warsaw',
    'Europe/Lisbon' => 'Europe/Lisbon',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Europe/Bucharest' => 'Europe/Bucharest',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Samara' => 'Europe/Samara',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Madrid' => 'Europe/Madrid',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Zurich' => 'Europe/Zurich',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'America/New_York' => 'America/New_York',
    'America/Chicago' => 'America/Chicago',
    'America/North_Dakota/Center' => 'America/North_Dakota/Center',
    'America/Denver' => 'America/Denver',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Juneau' => 'America/Juneau',
    'America/Yakutat' => 'America/Yakutat',
    'America/Anchorage' => 'America/Anchorage',
    'America/Nome' => 'America/Nome',
    'America/Adak' => 'America/Adak',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'America/Phoenix' => 'America/Phoenix',
    'America/Boise' => 'America/Boise',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Detroit' => 'America/Detroit',
    'America/Menominee' => 'America/Menominee',
    'America/St_Johns' => 'America/St_Johns',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Halifax' => 'America/Halifax',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Montreal' => 'America/Montreal',
    'America/Toronto' => 'America/Toronto',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Nipigon' => 'America/Nipigon',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Regina' => 'America/Regina',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Edmonton' => 'America/Edmonton',
    'America/Vancouver' => 'America/Vancouver',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Coral_Harbour' => 'America/Coral_Harbour',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Yellowknife' => 'America/Yellowknife',
    'America/Inuvik' => 'America/Inuvik',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Dawson' => 'America/Dawson',
    'America/Cancun' => 'America/Cancun',
    'America/Merida' => 'America/Merida',
    'America/Monterrey' => 'America/Monterrey',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Tijuana' => 'America/Tijuana',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Nassau' => 'America/Nassau',
    'America/Barbados' => 'America/Barbados',
    'America/Belize' => 'America/Belize',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'America/Cayman' => 'America/Cayman',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Havana' => 'America/Havana',
    'America/Dominica' => 'America/Dominica',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Jamaica' => 'America/Jamaica',
    'America/Martinique' => 'America/Martinique',
    'America/Montserrat' => 'America/Montserrat',
    'America/Managua' => 'America/Managua',
    'America/Panama' => 'America/Panama',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/Miquelon' => 'America/Miquelon',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Tortola' => 'America/Tortola',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/La_Paz' => 'America/La_Paz',
    'America/Noronha' => 'America/Noronha',
    'America/Belem' => 'America/Belem',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Recife' => 'America/Recife',
    'America/Araguaina' => 'America/Araguaina',
    'America/Maceio' => 'America/Maceio',
    'America/Bahia' => 'America/Bahia',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Manaus' => 'America/Manaus',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santiago' => 'America/Santiago',
    'Pacific/Easter' => 'Pacific/Easter',
    'America/Bogota' => 'America/Bogota',
    'America/Curacao' => 'America/Curacao',
    'America/Guayaquil' => 'America/Guayaquil',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'America/Cayenne' => 'America/Cayenne',
    'America/Guyana' => 'America/Guyana',
    'America/Asuncion' => 'America/Asuncion',
    'America/Lima' => 'America/Lima',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Montevideo' => 'America/Montevideo',
    'America/Caracas' => 'America/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'מועדפים';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'מועדף';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google Docs',
    'Box' => 'Box.net',
    'Twitter' => 'טוויטר',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Contacts',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'בקשה',
    2 => 'גישה',
    3 => 'לא תקין',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'משתשמש מערכת',
    'support_portal' => 'פורטל תמיכה',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'קמפיין',
    'email' => 'Any Email',
    'workflow' => 'זרימת עבודה',
    'system' => 'מערכת',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'קמפיין',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'קמפיין',
    'email' => 'Any Email',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'תיעוד',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => '2 טווחים',
    'show_buckets' => '3 טווחים',
    'show_custom_buckets' => 'טווחים מותאמים',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'תאריך מבוסס שנה',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'שנתי, מבוסס רבעונים',
    'Quarter' => 'רבעון',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'שורות פרטי הכנסה',
    'Opportunities' => 'הזדמנויות',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'כן',
    'no' => 'לא',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'אזהרה',
    'information' => 'מידע',
    'other' => 'אחר',
    'success' => 'הצליח',
    'warning' => 'אזהרה:',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'GET',
    'PUT' => 'PUT',
    'DELETE' => 'מחק',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'ידנית',
    '5' => 'כל 3 דקות',
    '15' => 'כל 15 דקות',
    '30' => 'כל 30 דקות',
    '60' => 'כל שעה',
];

$app_list_strings['moduleList']['KBDocuments'] = 'מרכז המידע';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'מרכז המידע';
$app_list_strings['moduleList']['KBContents'] = 'מרכז מידע';
$app_list_strings['moduleListSingular']['KBContents'] = 'מאמר במרכז המידע';
$app_list_strings['moduleList']['KBArticles'] = 'מאמר במרכז המידע';
$app_list_strings['moduleListSingular']['KBArticles'] = 'מאמר במרכז המידע';
$app_list_strings['moduleList']['KBContentTemplates'] = 'תבנית בסיס ידע';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'תבנית בסיס ידע';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'קבצים מוטמעים';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'קובץ מוטמע';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'ליי',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leke',
    'USD' => 'דולר',
    'AFN' => 'אפגנים',
    'ARS' => 'פסו',
    'AWG' => 'גילדן',
    'AUD' => 'דולר',
    'AZN' => 'מאנאט חדש',
    'BSD' => 'דולר',
    'BBD' => 'דולר',
    'BYR' => 'רובל',
    'EUR' => 'אירו',
    'BZD' => 'דולר',
    'BMD' => 'דולר',
    'BOB' => 'בוליביאנו',
    'BAM' => 'מארק סחיר',
    'BWP' => 'פולס',
    'BGN' => 'לב',
    'BRL' => 'ריאל ברזילאי',
    'GBP' => 'פאונד',
    'BND' => 'דולר',
    'KHR' => 'ריאל',
    'CAD' => 'דולר',
    'KYD' => 'דולר',
    'CLP' => 'פסו',
    'CNY' => 'רנמינבי',
    'COP' => 'פסו',
    'CRC' => 'ColÃ³n',
    'HRK' => 'קונה',
    'CUP' => 'פסו',
    'CZK' => 'קורונה',
    'DKK' => 'כתר',
    'DOP' => 'פסו',
    'XCD' => 'דולר',
    'EGP' => 'פאונד',
    'SVC' => '	קולון',
    'EEK' => 'קרון',
    'FKP' => 'פאונד',
    'FJD' => 'דולר',
    'GHC' => 'סדי',
    'GIP' => 'פאונד',
    'GTQ' => 'קצאל',
    'GGP' => 'פאונד',
    'GYD' => 'דולר',
    'HNL' => 'למפירה',
    'HKD' => 'דולר',
    'HUF' => '	פורינט',
    'ISK' => 'קרונה',
    'INR' => 'רופי',
    'IDR' => 'רופיה',
    'IRR' => 'ריאל',
    'IMP' => 'פאונד',
    'ILS' => 'שקל חדש',
    'JMD' => 'דולר',
    'JPY' => 'ין',
    'JEP' => 'פאונד',
    'KZT' => 'טנגה',
    'KPW' => 'ווֹן',
    'KRW' => 'ווֹן',
    'KGS' => 'סומס',
    'LAK' => 'Kips',
    'LVL' => 'לט',
    'LBP' => 'פאונד',
    'LRD' => 'דולר',
    'CHF' => 'פרנק שווייצרי',
    'LTL' => 'ליטאס',
    'MKD' => 'דינר',
    'MYR' => 'רינגיט',
    'MUR' => 'רופי',
    'MXN' => 'פסו',
    'MNT' => 'טוגרוג',
    'MZN' => '	מטיקל',
    'NAD' => 'דולר',
    'NPR' => 'רופי',
    'ANG' => 'גילדן',
    'NZD' => 'דולר',
    'NIO' => 'קורדובה',
    'NGN' => 'נאירה',
    'NOK' => 'כתר',
    'OMR' => 'ריאל',
    'PKR' => 'רופי',
    'PAB' => 'בלבואה',
    'PYG' => 'גואראני',
    'PEN' => 'סול חדש',
    'PHP' => 'פסו',
    'PLN' => 'זלוטי',
    'QAR' => 'ריאל',
    'RON' => '	לאו חדש',
    'RUB' => 'רובל',
    'SHP' => 'פאונד',
    'SAR' => 'ריאל',
    'RSD' => 'דינר',
    'SCR' => 'רופי',
    'SGD' => 'דולר',
    'SBD' => 'דולר',
    'SOS' => 'שילינג',
    'ZAR' => '	ראנד',
    'LKR' => 'רופי',
    'SEK' => '	קרונה',
    'SRD' => 'דולר',
    'SYP' => 'פאונד',
    'TWD' => 'דולר חדש',
    'THB' => 'באט',
    'TTD' => 'דולר',
    'TRY' => 'לירה',
    'TRL' => 'לירה',
    'TVD' => 'דולר',
    'UAH' => '	הריבניה',
    'UYU' => 'פסו',
    'UZS' => 'סכומים',
    'VEF' => 'בוליבר ונצואליני',
    'VND' => 'דונג',
    'YER' => 'ריאל',
    'ZWD' => 'דולר זימבבואי',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'מאוד גבוהה',
    '4' => 'גבוהה',
    '3' => 'נייטרלית',
    '2' => 'נמוכה',
    '1' => 'מאוד נמוכה',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'ללא',
    'future' => 'ערך נוכחי',
    'old' => 'ערך ישן',
    'both' => 'ערכים ישנים ונוכחיים',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Single-Hit',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'מעבד',
    'error' => 'שגיאה',
    'success' => 'הצלחה',
    'canceled' => 'בוטל',
    'document_load' => 'טוען את התבנית',
    'tags_extract' => 'מחלץ תגים',
    'tags_validate' => 'מאמת תגים',
    'data_retrieving' => 'מאחזר נתונים',
    'serialize_document' => 'מרכיב את המסמך בחזרה',
    'send_document' => 'שולח אליך את המסמך',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'מזג',
    'convert' => 'מיזוג PDF',
    'multimerge' => 'מולטי-מיזוג',
    'multimerge_convert' => 'מולטי-מיזוג PDF',
    'labelsgenerate' => 'צור תוויות',
    'labelsgenerate_convert' => 'צור תוויות PDF',
    'excel' => 'מיזוג ב-Excel',
    'excel_convert' => 'המרת מיזוג ב-Excel',
    'presentation' => 'מיזוג ב-PowerPoint',
    'presentation_convert' => 'מיזוג PDF ב-PowerPoint',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'החשבונות שלי',
    'favorites' => 'חשבונות מועדפים',
    'tags' => 'חשבונות מתויגים',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'כל החדשות',
    'General' => 'כללי',
    'Finance' => 'פיננסי',
    'People' => 'אישי',
    'Press Releases' => 'הודעות לעיתונות',
    'Other' => 'אחר',
];

$app_strings['LBL_OWNERS'] = 'בעלים';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Cloud Drive';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'חלונית שילוב Cloud Drive';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'העתק קישור';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'הורד';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'יצירת מסמך Sugar';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'אין אפשרות להוריד קובץ זה';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'חלונית הענן לא מוצגת';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'מסמך Sugar נוצר';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'שלח ל-DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign לא זמין ממיקום זה.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'מיזוג מסמכים ל-Word/Excel/PowerPoint לא זמין ממיקום זה';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'מיזוג מסמכים ל-DocuSign לא זמין ממיקום זה';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'מיזוג מסמכים ל-PDF לא זמין ממיקום זה';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'הקובץ החתום שלך יועלה לכאן רק אם יש לך הרשאה להעלות במיקום זה.';
$app_strings['LBL_DOC_MERGE_TO'] = 'מיזוג מסמכים ל:';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'הקבצים שלי';
$app_strings['LBL_SHARED_WITH_ME'] = 'שותף איתי';
$app_strings['LBL_CLOUD_PROVIDER'] = 'ספק שירותי ענן';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'שותף איתי';
$app_strings['LBL_MY_FILES'] = 'הקבצים שלי';
$app_strings['LBL_UPLOAD_FILE'] = 'העלאת קובץ';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'התיקיה לא נמצאה';
$app_strings['LBL_CREATE_FOLDER'] = 'יצירת תיקיה';
$app_strings['LBL_LOAD_MORE'] = 'טען עוד...';
$app_strings['LBL_NEW_FOLDER'] = 'תיקייה חדשה';
$app_strings['LBL_FOLDER_NAME'] = 'שם התיקייה: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'אין לך הרשאה לעשות זאת בנתיב הנוכחי.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'אין לך הרשאה להשתמש בנתיב הנוכחי.';
$app_strings['LBL_FILE_UPLOADED'] = 'הקובץ הועלה.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'עקב הגודל הרב של הקובץ, ההעלאה תימשך זמן מה.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'לרשומת מסמכים אחת או יותר אין קובץ מצורף. נא לצרף קבצים לאותן רשומות ולנסות שוב, או לסנכרן באופן פרטני רשומות מסוימות עם הקבצים.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'החיבור ל-Google לא נמצא...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'החיבור ל-Microsoft לא נמצא...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'החיבור ל-Dropbox לא נמצא...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'הסנכרון עם OneDrive עשוי להימשך זמן מה';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'בטוח שברצונך למחוק את הקובץ?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'ההעלאה ל-OneDrive הושלמה.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' נטען/ה בהצלחה.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'שגיאה בעת טעינת נתיבים.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'אירעה שגיאה מכיוון שהקובץ פגום.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'המסמך <i>"{{documentName}}"</i> נשמר בכונן הענן שלך, ונוסף למודול המסמכים.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'אין לך הרשאה למחוק קובץ זה.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'אין לך הרשאה למחוק תיקייה זו.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'אין לך הרשאות להעלות קבצים למיקום זה.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'אין לך הרשאה ליצור תיקייה במיקום זה.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'אי אפשר ליצור את התיקיות במיקום זה.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'אי אפשר להעלות את הקבצים למיקום זה.';
$app_strings['LBL_SITES'] = 'אתרים';
$app_strings['LBL_SHARED'] = 'משותף';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'הקישור נוצר. כדי להעתיק את הקישור אל הלוח, יש ללחוץ על הלחצן.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'העתק ללוח';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-ריק-',
    'Exact' => 'מדויק',
    'Null_address_components' => 'רכיב כתובת ריק אחד או יותר',
    'Invalid_address' => 'כתובת לא חוקית, השרת החזיר את הערך False',
    'Invalid_server_response_not_XML' => 'תגובת שרת לא חוקית, לא XML',
    'Invalid_address_no_location' => 'כתובת לא חוקית, השרת לא החזיר כל מיקום',
    'Ambiguous_address' => 'כתובת רב-ערכית, התאמות רבות',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'כביש',
    'a' => 'מבט מהאוויר',
    'rd' => 'כביש חשוך',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'English (US)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'ניו יורק (EST)'],
    ['pst', 'לוס אנג&#39;לס (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['חדש', 'חדש'],
    ['הוקצה', 'הוקצה'],
    ['נסגר', 'נסגר'],
    ['ממתין לקלט', 'ממתין לקלט'],
    ['נדחה', 'נדחה'],
    ['כפילות', 'כפילות'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['ניהול מערכת', 'ניהול מערכת'],
    ['מוצר', 'מוצר'],
    ['משתמש', 'משתמש'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'גבוהה'],
    ['P2', 'בינונית'],
    ['P3', 'נמוכה'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['משתמש', 'משתמש'],
    ['מנהל מערכת, משתמש', 'מנהל מערכת'],
    ['מנהל חשבון,משתמש', 'מנהל חשבון'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', 'ב-30 הימים האחרונים'],
    ['last_90_days', 'ב-90 הימים האחרונים'],
    ['this_year', 'בשנה שעברה'],
    ['התאמה אישית', 'טווח מותאם'],
    ['הכול', 'הכול'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['ברירת מחדל', 'ברירת מחדל'],
    ['צבע', 'צבע אחיד'],
    ['כתובת URL', 'תמונה מותאמת אישית'],
];
