<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'Español',
    'moduleList' => [
        'Home' => 'Inicio',
        'Contacts' => 'Contactos',
        'Accounts' => 'Cuentas',
        'Opportunities' => 'Oportunidades',
        'Cases' => 'Casos',
        'Notes' => 'Notas',
        'Calls' => 'Llamadas',
        'Emails' => 'Correos electrónicos',
        'Meetings' => 'Reuniones',
        'Tasks' => 'Tareas',
        'Calendar' => 'Calendario',
        'Leads' => 'Clientes Potenciales',
        'Currencies' => 'Monedas',
        'Contracts' => 'Contratos',
        'Quotes' => 'Presupuestos',
        'Products' => 'Elementos presupuestados',
        'WebLogicHooks' => 'Web Logic Hooks',
        'ProductCategories' => 'Categorías de Producto',
        'ProductTypes' => 'Tipos de Producto',
        'ProductTemplates' => 'Catálogo de Productos',
        'ProductBundles' => 'Juegos de Productos',
        'ProductBundleNotes' => 'Notas sobre los juegos de productos',
        'Reports' => 'Informes',
        'Forecasts' => 'Previsiones',
        'ForecastWorksheets' => 'Hojas de Previsión',
        'ForecastManagerWorksheets' => 'Hojas de trabajo para el administrador de previsión',
        'VisualPipeline' => 'Canalización visual',
        'ConsoleConfiguration' => 'Configuración de la consola',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'Cuotas',
        'Teams' => 'Equipos',
        'TeamNotices' => 'Noticias de Equipo',
        'Manufacturers' => 'Fabricantes',
        'Activities' => 'Actividades',
        'Comments' => 'Comentarios',
        'Subscriptions' => 'Subscripciones',
        'Bugs' => 'Incidencias',
        'Feeds' => 'RSS',
        'iFrames' => 'Mis Sitios',
        'TimePeriods' => 'Períodos de Tiempo',
        'TaxRates' => 'Tipos de Impuestos',
        'ContractTypes' => 'Tipos de Contrato',
        'Schedulers' => 'Planificadores',
        'Project' => 'Proyectos',
        'ProjectTask' => 'Tareas de Proyecto',
        'Campaigns' => 'Campañas',
        'CampaignLog' => 'Registro de Campañas',
        'CampaignTrackers' => 'Seguimientos de Campaña',
        'Documents' => 'Documentos',
        'DocumentRevisions' => 'Revisiones de documentos',
        'Connectors' => 'Conectores',
        'Notifications' => 'Notificaciones',
        'Sync' => 'Sincronización',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => 'Usuarios externos',
        'ReportMaker' => 'Informes avanzados',
        'DataSets' => 'Formatos de datos',
        'CustomQueries' => 'Consultas Personalizadas',
        'pmse_Inbox' => 'Procesos',
        'pmse_Project' => 'Definiciones de procesos',
        'pmse_Business_Rules' => 'Normas empresariales de procesos',
        'pmse_Emails_Templates' => 'Plantillas de email de procesos',
        'BusinessCenters' => 'Centros de negocios',
        'Shifts' => 'Turnos',
        'ShiftExceptions' => 'Excepciones de turnos',
        'Purchases' => 'Compras',
        'PurchasedLineItems' => 'Elementos comprados',
        'MobileDevices' => 'DispositivosMóviles',
        'PushNotifications' => 'NotificacionesPush',
        'Escalations' => 'Escaladas',
        'DocumentTemplates' => 'Plantillas de documentos',
        'DocumentMerges' => 'Fusiones de documentos',
        'CloudDrivePaths' => 'Rutas de Cloud Drive',
        'WorkFlow' => 'Definiciones de Workflow',
        'EAPM' => 'Cuentas externas',
        'Worksheet' => 'Hoja de Trabajo',
        'Users' => 'Usuarios',
        'Employees' => 'Empleados',
        'Administration' => 'Administración',
        'ACLRoles' => 'Roles',
        'InboundEmail' => 'Correo Entrante',
        'Releases' => 'Publicaciones',
        'Prospects' => 'Público Objetivo',
        'Queues' => 'Colas',
        'EmailMarketing' => 'Marketing por Email',
        'EmailTemplates' => 'Plantillas de Email',
        'SNIP' => 'Email Archiving',
        'ProspectLists' => 'Listas de Público Objetivo',
        'SavedSearch' => 'Búsquedas guardadas',
        'UpgradeWizard' => 'Asistente de Actualizaciones',
        'Trackers' => 'Monitorizaciones',
        'TrackerPerfs' => 'Rendimiento de Monitorización',
        'TrackerSessions' => 'Sesiones de Monitorización',
        'TrackerQueries' => 'Consultas de Monitorización',
        'FAQ' => 'Preguntas frecuentes',
        'Newsletters' => 'Boletines de Noticias',
        'SugarFavorites' => 'Favoritos',
        'PdfManager' => 'Gestor de PDF',
        'DataArchiver' => 'Archivador de datos',
        'ArchiveRuns' => 'Ejecuciones del archivo',

        'OAuthKeys' => 'Claves del Consumidor OAuth',
        'OAuthTokens' => 'Tokens de OAuth',
        'Filters' => 'Filtros',
        'UserSignatures' => 'Firmas de correo electrónico',
        'Shippers' => 'Proveedores de Transporte',
        'Styleguide' => 'Guía de Estilo',
        'Feedbacks' => 'Comentarios',
        'Tags' => 'Etiquetas',
        'Categories' => 'Categorías',
        'Dashboards' => 'Cuadros de mando',
        'OutboundEmail' => 'Configuración de correo electrónico',
        'EmailParticipants' => 'Participantes por correo electrónico',
        'DataPrivacy' => 'Privacidad de datos',
        'ReportSchedules' => 'Planificación de informes',
        'CommentLog' => 'Registro de comentarios',
        'Holidays' => 'Festivos',
        'ChangeTimers' => 'Cambiar temporizadores',
        'Metrics' => 'Métricas',
        'Messages' => 'Mensajes',
        'Audit' => 'Auditoría',
        'RevenueLineItems' => 'Partidas de ingresos',
        'DocuSignEnvelopes' => 'Sobres de DocuSign',
        'Geocode' => 'Geocodificar',
        'DRI_Workflows' => 'Guías inteligentes',
        'DRI_Workflow_Task_Templates' => 'Plantillas de actividades de la guía inteligente',
        'DRI_SubWorkflows' => 'Fases de la guía inteligente',
        'DRI_Workflow_Templates' => 'Plantillas de la guía inteligente',
        'CJ_WebHooks' => 'Webhooks de Sugar Automate',
        'CJ_Forms' => 'Acciones de Sugar de Smart Guide',
        'DRI_SubWorkflow_Templates' => 'Plantillas de fases de la guía inteligente',
        'PubSub_ModuleEvent_PushSubs' => 'Suscripciones a emisiones de eventos del módulo Pub/Sub',
    ],

    'moduleIconList' => [
        'Home' => 'In',
        'Contacts' => 'Co',
        'Accounts' => 'Cu',
        'Opportunities' => 'Op',
        'Cases' => 'Cs',
        'Notes' => 'Nt',
        'Calls' => 'Cl',
        'Emails' => 'Co',
        'Meetings' => 'Re',
        'Tasks' => 'Ts',
        'Calendar' => 'Ca',
        'Leads' => 'Cp',
        'Currencies' => 'Mo',
        'Contracts' => 'Co',
        'Quotes' => 'Pr',
        'Products' => 'QL',
        'WebLogicHooks' => 'WL',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'TP',
        'ProductTemplates' => 'PP',
        'ProductBundles' => 'PP',
        'ProductBundleNotes' => 'PB',
        'Reports' => 'In',
        'Forecasts' => 'Pr',
        'ForecastWorksheets' => 'FP',
        'ForecastManagerWorksheets' => 'FM',
        'Quotas' => 'Fo',
        'VisualPipeline' => 'CV',
        'ConsoleConfiguration' => 'CC',
        'SugarLive' => 'Su',
        'Teams' => 'Eq',
        'TeamNotices' => 'NE',
        'Manufacturers' => 'Fa',
        'Activities' => 'Ac',
        'Comments' => 'Co',
        'Subscriptions' => 'Su',
        'Bugs' => 'Er',
        'Feeds' => 'RS',
        'iFrames' => 'MS',
        'TimePeriods' => 'PT',
        'TaxRates' => 'TF',
        'ContractTypes' => 'TC',
        'Schedulers' => 'Pr',
        'Project' => 'Pr',
        'ProjectTask' => 'TP',
        'Campaigns' => 'Ca',
        'CampaignLog' => 'RC',
        'CampaignTrackers' => 'SC',
        'Documents' => 'Do',
        'DocumentRevisions' => 'RD',
        'Connectors' => 'Co',
        'Notifications' => 'No',
        'Sync' => 'Si',
        'HintAccountsets' => 'Hi',
        'HintNotificationTargets' => 'Hi',
        'HintNewsNotifications' => 'Hi',
        'HintEnrichFieldConfigs' => 'Hi',
        'ExternalUsers' => 'UE',
        'ReportMaker' => 'CI',
        'DataSets' => 'DF',
        'CustomQueries' => 'SP',
        'pmse_Inbox' => 'Pr',
        'pmse_Project' => 'PD',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE',
        'BusinessCenters' => 'CN',
        'Shifts' => 'Ca',
        'ShiftExceptions' => 'EC',
        'Purchases' => 'Co',
        'PurchasedLineItems' => 'EL',
        'MobileDevices' => 'Mo',
        'PushNotifications' => 'Na',
        'Escalations' => 'Es',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'FT',
        'EAPM' => 'EA',
        'Worksheet' => 'Fi',
        'Users' => 'Us',
        'Employees' => 'Em',
        'Administration' => 'Ad',
        'ACLRoles' => 'Ro',
        'InboundEmail' => 'CE',
        'Releases' => 'Li',
        'Prospects' => 'Ta',
        'Queues' => 'Co',
        'EmailMarketing' => 'MC',
        'EmailTemplates' => 'PC',
        'SNIP' => 'EA',
        'ProspectLists' => 'LP',
        'SavedSearch' => 'BG',
        'UpgradeWizard' => 'AA',
        'Trackers' => 'Se',
        'TrackerPerfs' => 'TP',
        'TrackerSessions' => 'SS',
        'TrackerQueries' => 'SS',
        'FAQ' => 'PF',
        'Newsletters' => 'Bo',
        'SugarFavorites' => 'Fa',
        'PdfManager' => 'GP',
        'DataArchiver' => 'AD',
        'ArchiveRuns' => 'EA',
        'OAuthKeys' => 'CO',
        'OAuthTokens' => 'TO',
        'Filters' => 'Fi',
        'UserSignatures' => 'FU',
        'Shippers' => 'TR',
        'Styleguide' => 'Ge',
        'Feedbacks' => 'Co',
        'Tags' => 'Et',
        'Categories' => 'Ca',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'ES',
        'EmailParticipants' => 'EP',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'CH',
        'CommentLog' => 'RC',
        'Holidays' => 'Va',
        'ChangeTimers' => 'CT',
        'Metrics' => 'Me',
        'Messages' => 'Me',
        'Audit' => 'Au',
        'RevenueLineItems' => 'RL',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'Ge',
        'DRI_Workflows' => 'SG',
        'DRI_Workflow_Task_Templates' => 'SG',
        'DRI_SubWorkflows' => 'SG',
        'DRI_Workflow_Templates' => 'SG',
        'CJ_WebHooks' => 'SA',
        'CJ_Forms' => 'SG',
        'DRI_SubWorkflow_Templates' => 'SG',
        'Library' => 'Bi',
        'EmailAddresses' => 'DC',
        'Words' => 'Pa',
        'Sugar_Favorites' => 'Fa',
        'KBDocuments' => 'KB',
        'KBContents' => 'KB',
        'KBArticles' => 'KB',
        'KBContentTemplates' => 'KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'AI',
    ],

    'moduleListSingular' => [
        'Home' => 'Inicio',
        'Dashboards' => 'Cuadro de mando',
        'Styleguide' => 'Guía de Estilo',
        'Contacts' => 'Contacto',
        'Accounts' => 'Cuenta',
        'Opportunities' => 'Oportunidad',
        'Cases' => 'Caso',
        'Notes' => 'Nota',
        'Calls' => 'Llamada',
        'Emails' => 'Correo electrónico',
        'Meetings' => 'Reunión',
        'Tasks' => 'Tarea',
        'Calendar' => 'Calendario',
        'Leads' => 'Cliente Potencial',
        'Manufacturers' => 'Fabricante',
        'VisualPipeline' => 'Canalización visual',
        'ConsoleConfiguration' => 'Configuracióndelaconsola',
        'MobileDevices' => 'DispositivoMóvil',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'Contrato',
        'Quotes' => 'Presupuesto',
        'Products' => 'Línea de la Oferta',
        'ProductCategories' => 'Categoría de Producto',
        'ProductBundles' => 'Juego de Producto',
        'ProductBundleNotes' => 'Notas sobre el juego de producto',
        'RevenueLineItems' => 'Línea de Ingreso',
        'WebLogicHooks' => 'Web Logic Hook',
        'Reports' => 'Informe',
        'Forecasts' => 'Previsión',
        'ForecastWorksheets' => 'Hoja de Previsión',
        'ForecastManagerWorksheets' => 'Hoja de trabajo para el administrador de previsión',
        'Quotas' => 'Cuota',
        'Teams' => 'Equipo',
        'TeamNotices' => 'Notificación del Equipo',
        'Activities' => 'Actividad',
        'ActivityStream' => 'Flujo de actividad',
        'Bugs' => 'Incidencia',
        'Feeds' => 'RSS',
        'iFrames' => 'Mis Sitios',
        'TimePeriods' => 'Período de Tiempo',
        'TaxRates' => 'Tipo de Impuesto',
        'ContractTypes' => 'Tipo de Contrato',
        'Schedulers' => 'Planificador',
        'Campaigns' => 'Campaña',
        'CampaignLog' => 'Registro de Campañas',
        'Project' => 'Proyecto',
        'ProjectTask' => 'Tarea de Proyecto',
        'Prospects' => 'Público Objetivo',
        'ProspectLists' => 'Lista de Público Objetivo',
        'CampaignTrackers' => 'Seguimiento de Campaña',
        'Documents' => 'Documento',
        'DocumentRevisions' => 'Revisión del Documento',
        'Connectors' => 'Conector',
        'Notifications' => 'Notificación',
        'Sync' => 'Sincronización',
        'PdfManager' => 'Gestor de PDF',
        'DataArchiver' => 'Archivador de datos',
        'ArchiveRuns' => 'Ejecuciones del archivo',
        'ExternalUsers' => 'Usuario externo',
        'ReportMaker' => ' Informe avanzado',
        'DataSets' => 'Formato de Datos',
        'CustomQueries' => 'Consulta Personalizada',
        'pmse_Inbox' => 'Proceso',
        'pmse_Project' => 'Definición de proceso',
        'pmse_Business_Rules' => 'Norma empresarial de procesos',
        'pmse_Emails_Templates' => 'Plantilla de correo electrónico de procesos',
        'BusinessCenters' => 'Centro de negocios',
        'Shifts' => 'Turno',
        'ShiftExceptions' => 'Excepciones de turnos',
        'Purchases' => 'Compra',
        'PurchasedLineItems' => 'Elemento comprado',
        'PushNotifications' => 'NotificaciónPush',
        'Escalations' => 'Escalada',
        'DocumentTemplates' => 'Plantilla de documento',
        'DocumentMerges' => 'Fusión de documentos',
        'CloudDrivePaths' => 'Ruta de Cloud Drive',
        'WorkFlow' => 'Flujo de actividad',
        'EAPM' => 'Cuenta externa',
        'Worksheet' => 'Hoja de Trabajo',
        'Users' => 'Usuario',
        'SugarFavorites' => 'SugarFavorites',
        'Employees' => 'Empleado',
        'Administration' => 'Administración',
        'ACLRoles' => 'Rol',
        'InboundEmail' => 'Correo Entrante',
        'Releases' => 'Publicación',
        'Queues' => 'Cola',
        'EmailMarketing' => 'Marketing por Email',
        'EmailTemplates' => 'Plantilla de Email',
        'SNIP' => 'Email Archiving',
        'SavedSearch' => 'Búsqueda guardada',
        'UpgradeWizard' => 'Asistente de Actualizaciones',
        'Trackers' => 'Monitorización',
        'TrackerPerfs' => 'Rendimiento de Monitorización',
        'TrackerSessions' => 'Sesión de seguimiento',
        'TrackerQueries' => 'Consultas de seguimiento',
        'FAQ' => 'Preguntas frecuentes',
        'Newsletters' => 'Boletín de Noticias',
        'OAuthKeys' => 'Clave OAuth del consumidor',
        'OAuthTokens' => 'Identificador OAuth',
        'Filters' => 'Filtro',
        'Comments' => 'Comentario',
        'CommentLog' => 'Registro de comentarios',
        'Currencies' => 'Moneda',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'Tipo de Producto',
        'Shippers' => 'Proveedor de transporte',
        'Subscriptions' => 'Suscripción',
        'UserSignatures' => 'Firma de correo electrónico',
        'Feedbacks' => 'Comentarios',
        'Tags' => 'Etiqueta',
        'Categories' => 'Categoría',
        'OutboundEmail' => 'Configuración de correo electrónico',
        'EmailParticipants' => 'Participante por correo electrónico',
        'DataPrivacy' => 'Privacidad de datos',
        'ReportSchedules' => 'Planificación de informes',
        'Holidays' => 'Festivo',
        'ChangeTimers' => 'Cambiar temporizador',
        'Metrics' => 'Métrica',
        'Messages' => 'Mensaje',
        'Audit' => 'Auditoría',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => 'Geocodificar',
        'DRI_Workflows' => 'Guía inteligente',
        'DRI_Workflow_Task_Templates' => 'Plantilla de actividades de la guía inteligente',
        'DRI_SubWorkflows' => 'Fase de la guía inteligente',
        'DRI_Workflow_Templates' => 'Plantilla de la guía inteligente',
        'CJ_WebHooks' => 'Webhook de Sugar Automate',
        'CJ_Forms' => 'Acción de Sugar de Smart Guide',
        'DRI_SubWorkflow_Templates' => 'Plantilla de fases de la guía inteligente',
        'PubSub_ModuleEvent_PushSubs' => 'Suscripción a emisiones de eventos del módulo Pub/Sub',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'Sí',
        '2' => 'No',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'No',
        1 => 'Sí',
    ],

    'notifications_status_dom' => [
        0 => 'No leído',
        1 => 'Leído',
    ],

    'optout_dom' => [
        '' => '-ninguno-',
        'false' => 'No',
        'true' => 'Sí',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'Analista',
        'Competitor' => 'Competidor',
        'Customer' => 'Cliente',
        'Integrator' => 'Integrador',
        'Investor' => 'Inversor',
        'Partner' => 'Colaborador',
        'Press' => 'Prensa',
        'Prospect' => 'Prospecto',
        'Reseller' => 'Revendedor',
        'Other' => 'Otro',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'Textil',
        'Banking' => 'Banca',
        'Biotechnology' => 'Biotecnología',
        'Chemicals' => 'Química',
        'Communications' => 'Comunicaciones',
        'Construction' => 'Construcción',
        'Consulting' => 'Consultoría',
        'Education' => 'Educación',
        'Electronics' => 'Electrónica',
        'Energy' => 'Energía',
        'Engineering' => 'Ingeniería',
        'Entertainment' => 'Entretenimiento',
        'Environmental' => 'Medio ambiente',
        'Finance' => 'Finanzas',
        'Government' => 'Gobierno',
        'Healthcare' => 'Sanidad',
        'Hospitality' => 'Hotelería',
        'Insurance' => 'Seguros',
        'Machinery' => 'Maquinaria',
        'Manufacturing' => 'Fabricación',
        'Media' => 'Medios de comunicación',
        'Not For Profit' => 'Sin ánimo de lucro',
        'Recreation' => 'Ocio',
        'Retail' => 'Venta al por menor',
        'Shipping' => 'Envíos',
        'Technology' => 'Tecnología',
        'Telecommunications' => 'Telecomunicaciones',
        'Transportation' => 'Transportes',
        'Utilities' => 'Servicios públicos',
        'Other' => 'Otro',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF y CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'Gráfico',
        'Data Table' => 'Tabla de datos',
        'Chart and Data Table' => 'Gráfico y tabla de datos',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'En curso',
        'Completed' => 'Completado',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'Entrante',
        'Outbound' => 'Saliente',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'Chat',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'Nivel 1',
        'T2' => 'Nivel 2',
        'T3' => 'Nivel 3',
        'T4' => 'Nivel 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'Sí',
        'No' => 'No',
        'Completed' => 'Completada',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'Futuro',
        'Active' => 'Activo',
        'Past' => 'Pasado',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'Generado automáticamente',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'Llamada en frío',
        'Existing Customer' => 'Cliente existente',
        'Self Generated' => 'Generado automáticamente',
        'Employee' => 'Empleado',
        'Partner' => 'Colaborador',
        'Public Relations' => 'Relaciones Públicas',
        'Direct Mail' => 'Email directo',
        'Conference' => 'Conferencia',
        'Trade Show' => 'Exposición',
        'Web Site' => 'Sitio Web',
        'Word of mouth' => 'Recomendación',
        'Email' => 'Correo electrónico',
        'Campaign' => 'Campaña',
        'Support Portal User Registration' => 'Registro de usuario en el Portal de Asistencia',
        'Other' => 'Otros',
    ],
    'metric_status_dom' => [
        'Inactive' => 'Inactivo',
        'Active' => 'Activas',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'Negocio existente',
        'New Business' => 'Nuevo negocio',
    ],
    'taxrate_status_dom' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
    ],
    'roi_type_dom' => [
        'Revenue' => 'Ingresos',
        'Investment' => 'Inversión',
        'Expected_Revenue' => 'Ingresos Esperados',
        'Budget' => 'Presupuesto',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'Responsable principal',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Responsable principal',
        'Business Decision Maker' => 'Responsable de negocios',
        'Business Evaluator' => 'Evaluador de negocios',
        'Technical Decision Maker' => 'Responsable técnico',
        'Technical Evaluator' => 'Evaluador técnico',
        'Executive Sponsor' => 'Patrocinador Ejecutivo',
        'Influencer' => 'Formador de opiniones',
        'Other' => 'Otro',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
    ],

    'shipper_status_dom' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'Contacto principal',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'Contacto principal',
        'Alternate Contact' => 'Contacto alternativo',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'Al lado del valor del campo',
        'field_on_top' => 'Encima del valor del campo',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'Neto 15',
        'Net 30' => 'Neto 30',
    ],
    'sales_stage_default_key' => 'Prospección',
    'fts_type' => [
        'Elastic' => 'ElasticSearch',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'Prospección',
        'Qualification' => 'Calificación',
        'Needs Analysis' => 'Análisis de necesidades',
        'Value Proposition' => 'Propuesta de valor',
        'Id. Decision Makers' => 'Identificación de responsables',
        'Perception Analysis' => 'Análisis de percepción',
        'Proposal/Price Quote' => 'Propuesta/Presupuesto',
        'Negotiation/Review' => 'Negociación/Revisión',
        'Closed Won' => 'Cerrado',
        'Closed Lost' => 'Perdida',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'Nuevo',
        'In Progress' => 'En Progreso',
        'Closed Won' => 'Cerrado',
        'Closed Lost' => 'Perdida',
        'Converted to Quote' => 'Convertido en presupuesto',
    ],
    'sales_status_dom' => [
        'New' => 'Nuevo',
        'In Progress' => 'En progreso',
        'Closed Won' => 'Cerrado',
        'Closed Lost' => 'Perdida',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'Incluido',
        'exclude' => 'Excluido',
    ],
    'commit_stage_dom' => [
        'include' => 'Incluido',
        'upside' => 'Ventaja',
        'exclude' => 'Excluido',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'Incluido',
        'upside' => 'Ventaja',
        'exclude' => 'Excluido',
    ],

    'in_total_group_stages' => [
        'Draft' => 'Borrador',
        'Negotiation' => 'Negociación',
        'Delivered' => 'Enviado',
        'On Hold' => 'En espera',
        'Confirmed' => 'Confirmado',
        'Closed Accepted' => 'Aceptada',
        'Closed Lost' => 'Perdida',
        'Closed Dead' => 'Cerrado definitivo',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'Llamada',
        'Meeting' => 'Reunión',
        'Task' => 'Tarea',
        'Email' => 'Correo electrónico',
        'Note' => 'Nota',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'Sr.',
        'Ms.' => 'Sra.',
        'Mrs.' => 'Sra.',
        'Dr.' => 'Dr.',
        'Prof.' => 'Prof.',
        'Mx.' => 'Sr. y Sra.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'Ninguna',
        60 => '1 minuto antes',
        300 => '5 minutos antes',
        600 => '10 minutos antes',
        900 => '15 minutos antes',
        1800 => '30 minutos antes',
        3600 => '1 hora antes',
        7200 => '2 horas antes',
        10800 => '3 horas antes',
        18000 => '5 horas antes',
        86400 => '1 día antes',
        ],

        'task_priority_default' => 'Media',
        'task_priority_dom' => [
        'High' => 'Alta',
        'Medium' => 'Media',
        'Low' => 'Baja',
        ],
        'task_status_default' => 'No iniciada',
        'task_status_dom' => [
        'Not Started' => 'No iniciada',
        'In Progress' => 'En Progreso',
        'Completed' => 'Completada',
        'Pending Input' => 'Pendiente de Información',
        'Deferred' => 'Aplazada',
        'Not Applicable' => 'No aplicable',
        ],
        'meeting_status_default' => 'Planificado',
        'meeting_status_dom' => [
        'Planned' => 'Planificado',
        'Held' => 'Realizada',
        'Not Held' => 'Cancelada',
        'Deferred' => 'Aplazado',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'Otro',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'Planificado',
        'call_status_dom' => [
        'Planned' => 'Planificada',
        'In Progress' => 'En curso',
        'Held' => 'Realizada',
        'Not Held' => 'Cancelada',
        'Deferred' => 'Aplazado',
        ],
        'call_direction_default' => 'Saliente',
        'call_direction_dom' => [
        'Inbound' => 'Entrante',
        'Outbound' => 'Saliente',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'Nuevo',
        'Assigned' => 'Asignado',
        'In Process' => 'En proceso',
        'Converted' => 'Convertido',
        'Recycled' => 'Reciclado',
        'Dead' => 'Definitivo',
        ],
        'gender_list' => [
        'male' => 'Masculino',
        'female' => 'Femenino',
        'other' => 'Otros',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'Nuevo',
        'case_status_dom' => [
        'New' => 'Nuevo',
        'Assigned' => 'Asignado',
        'Closed' => 'Cerrado',
        'Pending Input' => 'Pendiente de Información',
        'Rejected' => 'Rechazado',
        'Duplicate' => 'Duplicar',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'Alta',
        'P2' => 'Media',
        'P3' => 'Baja',
        ],
        'user_type_dom' => [
        'RegularUser' => 'Usuario Normal',
        'Administrator' => 'Administrador',
        ],
        'user_type_bool_dom' => [
            false => 'Usuario normal',
            true => 'Administrador',
        ],
        'user_type_group_bool_dom' => [
            true => 'Usuario del grupo',
        ],
        'user_type_portal_bool_dom' => [
            true => 'Usuario de la API del portal',
        ],
        'license_type_dom' => [
        'CURRENT' => 'Producto actual',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
        ],
        'employee_status_dom' => [
        'Active' => 'Activo',
        'Terminated' => 'Despedido',
        'Leave of Absence' => 'Excedencia',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
        ],
        'project_task_priority_options' => [
        'High' => 'Alta',
        'Medium' => 'Media',
        'Low' => 'Baja',
        ],
        'project_task_priority_default' => 'Media',

        'project_task_status_options' => [
        'Not Started' => 'No iniciada',
        'In Progress' => 'En Progreso',
        'Completed' => 'Completada',
        'Pending Input' => 'Pendiente de Información',
        'Deferred' => 'Aplazada',
        ],
        'project_task_utilization_options' => [
        '0' => 'ninguno',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'Borrador',
        'In Review' => 'En revisión',
        'Published' => 'Publicado',
        ],
        'project_status_default' => 'Borrador',

        'project_duration_units_dom' => [
        'Days' => 'Días',
        'Hours' => 'Horas',
        ],

        'project_priority_options' => [
        'High' => 'Alta',
        'Medium' => 'Media',
        'Low' => 'Baja',
        ],
        'project_priority_default' => 'Media',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Cuentas',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'Cuenta',
        'Opportunities' => 'Oportunidad',
        'Cases' => 'Caso',
        'Leads' => 'Cliente Potencial',
        'Contacts' => 'Contactos', // cn (11/22/2005) added to support Emails
        'Products' => 'Línea de la Oferta',
        'Quotes' => 'Presupuesto',
        'Bugs' => 'Incidencia',
        'Project' => 'Proyecto',

        'Prospects' => 'Público Objetivo',
        'ProjectTask' => 'Tarea de Proyecto',

        'Tasks' => 'Tarea',
        'KBContents' => 'Base de Conocimiento',
        'Notes' => 'Nota',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'Cuenta',
        'Contacts' => 'Contacto',
        'Opportunities' => 'Oportunidad',
        'Tasks' => 'Tarea',
        'ProductTemplates' => 'Catálogo de Productos',
        'Quotes' => 'Presupuesto',
        'Products' => 'Línea de la Oferta',
        'Contracts' => 'Contrato',
        'Emails' => 'Correo electrónico',

        'Bugs' => 'Incidencia',
        'Project' => 'Proyecto',
        'ProjectTask' => 'Tarea de Proyecto',
        'Prospects' => 'Público Objetivo',
        'Cases' => 'Caso',
        'Leads' => 'Cliente Potencial',

        'Meetings' => 'Reunión',
        'Calls' => 'Llamada',
        'KBContents' => 'Base de Conocimiento',
        'PurchasedLineItems' => 'Elemento comprado',
        'Purchases' => 'Compra',
        'Escalations' => 'Escalada',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'Cuenta',
        'Contacts' => 'Contacto',
        'Employees' => 'Empleado',
        'Leads' => 'Cliente potencial',
        'Prospects' => 'Público Objetivo',
        'Users' => 'Usuario',
        ],

        'parent_type_display' => [
        'Accounts' => 'Cuenta',
        'Contacts' => 'Contacto',
        'Tasks' => 'Tarea',
        'Opportunities' => 'Oportunidad',
        'Products' => 'Línea de la Oferta',
        'Quotes' => 'Presupuesto',

        'Bugs' => 'Incidencias',
        'Cases' => 'Caso',
        'Leads' => 'Cliente Potencial',

        'Project' => 'Proyecto',
        'ProjectTask' => 'Tarea de Proyecto',

        'Prospects' => 'Público Objetivo',
        'KBContents' => 'Base de Conocimiento',
        'Notes' => 'Nota',
        'PurchasedLineItems' => 'Elemento comprado',
        'Purchases' => 'Compra',
        'Escalations' => 'Escalada',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'Caso',
        ],

        'product_status_default_key' => 'Enviar',
        'product_status_quote_key' => 'Presupuestos',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'Presupuestado',
        'Orders' => 'Pedido',
        'Ship' => 'Enviado',
        ],
        'active_status_dom' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
        'Retired' => 'Retirado',
        ],
        'appearance_options' => [
        'system_default' => 'Utilizar configuración del sistema',
        'light' => 'Claro',
        'dark' => 'Oscuro',
        ],


        'pricing_formula_default_key' => 'Corregido',
        'pricing_formula_dom' => [
        'Fixed' => 'Precio fijo',
        'ProfitMargin' => 'Margen comercial',
        'PercentageMarkup' => 'Incremento sobre coste',
        'PercentageDiscount' => 'Descuento sobre precio de lista',
        'IsList' => 'Precio de lista',
        ],
        'product_template_status_dom' => [
        'Available' => 'En stock',
        'Unavailable' => 'Sin stock',
        ],
        'tax_class_dom' => [
        'Taxable' => 'Sujeto a Impuestos',
        'Non-Taxable' => 'Libre de Impuestos',
        ],
        'support_term_dom' => [
        '+6 months' => 'Seis meses',
        '+1 year' => 'Un año',
        '+2 years' => 'Dos años',
        ],

        'quote_type_dom' => [
        'Quotes' => 'Presupuesto',
        'Orders' => 'Orden',
        ],
        'default_quote_stage_key' => 'Borrador',
        'quote_stage_dom' => [
        'Draft' => 'Borrador',
        'Negotiation' => 'Negociación',
        'Delivered' => 'Enviado',
        'On Hold' => 'En espera',
        'Confirmed' => 'Confirmado',
        'Closed Accepted' => 'Aceptada',
        'Closed Lost' => 'Perdida',
        'Closed Dead' => 'Cerrado definitivo',
        ],
        'default_order_stage_key' => 'Pendiente',
        'order_stage_dom' => [
        'Pending' => 'Pendiente',
        'Confirmed' => 'Confirmado',
        'On Hold' => 'En espera',
        'Shipped' => 'Enviado',
        'Cancelled' => 'Cancelado',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'Responsable principal',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Responsable principal',
        'Business Decision Maker' => 'Responsable de negocios',
        'Business Evaluator' => 'Evaluador de negocios',
        'Technical Decision Maker' => 'Responsable técnico',
        'Technical Evaluator' => 'Evaluador técnico',
        'Executive Sponsor' => 'Patrocinador Ejecutivo',
        'Influencer' => 'Formador de opiniones',
        'Other' => 'Otro',
        ],
        'layouts_dom' => [
        'Standard' => 'Presupuesto',
        'Invoice' => 'Factura',
        ],
        'issue_priority_default_key' => 'Media',
        'issue_priority_dom' => [
        'Urgent' => 'Urgente',
        'High' => 'Alta',
        'Medium' => 'Media',
        'Low' => 'Baja',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'Aceptado',
        'Duplicate' => 'Duplicar',
        'Closed' => 'Cerrado',
        'Out of Date' => 'Caducado',
        'Invalid' => 'Invalido',
        ],

        'issue_status_default_key' => 'Nuevo',
        'issue_status_dom' => [
        'New' => 'Nuevo',
        'Assigned' => 'Asignado',
        'Closed' => 'Cerrado',
        'Pending' => 'Pendiente',
        'Rejected' => 'Rechazado',
        ],

        'bug_priority_default_key' => 'Media',
        'bug_priority_dom' => [
        'Urgent' => 'Urgente',
        'High' => 'Alta',
        'Medium' => 'Media',
        'Low' => 'Baja',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'Aceptado',
        'Duplicate' => 'Duplicar',
        'Fixed' => 'Corregido',
        'Out of Date' => 'Caducado',
        'Invalid' => 'Invalido',
        'Later' => 'Pospuesto',
        ],
        'bug_status_default_key' => 'Nuevo',
        'bug_status_dom' => [
        'New' => 'Nuevo',
        'Assigned' => 'Asignado',
        'Closed' => 'Cerrado',
        'Pending' => 'Pendiente',
        'Rejected' => 'Rechazado',
        ],
        'bug_type_default_key' => 'Incidencia',
        'bug_type_dom' => [
        'Defect' => 'Defecto',
        'Feature' => 'Característica',
        ],
        'case_type_dom' => [
        'Administration' => 'Administración',
        'Product' => 'Producto',
        'User' => 'Usuario',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'Interno',
        'Forum' => 'Foro',
        'Web' => 'Web',
        'InboundEmail' => 'Correo electrónico',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'Interno',
        'Forum' => 'Foro',
        'Web' => 'Web',
        'InboundEmail' => 'Correo electrónico',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        'Phone' => 'Teléfono',
        'Chat' => 'Chat',
        'Chatbot' => 'Chatbot',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'Solicitud de la política de privacidad de datos',
        'Send Personal Information being processed' => 'Se está procesando el envío de información personal',
        'Rectify Information' => 'Rectificar información',
        'Request to Erase Information' => 'Solicitud para borrar información',
        'Export Information' => 'Exportar información',
        'Restrict Processing' => 'Restringir el tratamiento',
        'Object to Processing' => 'Oponerse al tratamiento',
        'Consent to Process' => 'Consentir el tratamiento',
        'Withdraw Consent' => 'Retirar el consentimiento',
        'Other' => 'Otro',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'Comunicaciones comerciales',
        'Marketing Communications by company' => 'Comunicaciones de marketing por empresa',
        'Marketing Communications by partners' => 'Comunicaciones de marketing por socio',
        ],
        'dataprivacy_status_default_key' => 'Abrir',
        'dataprivacy_status_dom' => [
        'Open' => 'Abrir',
        'Closed' => 'Completado',
        'Rejected' => 'Rechazado',
        ],
        'dataprivacy_priority_default_key' => 'Bajo',
        'dataprivacy_priority_dom' => [
        'Low' => 'Bajo',
        'Medium' => 'Medio',
        'High' => 'Alto',
        ],
        'business_day_status_dom' => [
        'Open' => 'Abierto',
        'Open 24 Hours' => 'Abierto 24 horas',
        'Closed' => 'Cerrado',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'Cuentas',
        'Activities' => 'Actividades',
        'Bug Tracker' => 'Seguimiento de Incidencias',
        'Calendar' => 'Calendario',
        'Calls' => 'Llamadas',
        'Campaigns' => 'Campañas',
        'Cases' => 'Casos',
        'Contacts' => 'Contactos',
        'Currencies' => 'Monedas',
        'Dashboard' => 'Cuadro de Mando',
        'Documents' => 'Documentos',
        'Emails' => 'Correos electrónicos',
        'Feeds' => 'Fuentes',
        'Forecasts' => 'Previsiones',
        'Help' => 'Ayuda',
        'Home' => 'Inicio',
        'Leads' => 'Clientes Potenciales',
        'Meetings' => 'Reuniones',
        'Notes' => 'Notas',
        'Opportunities' => 'Oportunidades',
        'Outlook Plugin' => 'Complemento de Outlook',
        'Product Catalog' => 'Catálogo de Productos',
        'Products' => 'Elementos presupuestados',
        'RevenueLineItems' => 'Líneas de Ingreso',
        'Projects' => 'Proyectos',
        'Quotes' => 'Presupuestos',
        'Releases' => 'Publicaciones',
        'RSS' => 'RSS',
        'Studio' => 'Studio',
        'Upgrade' => 'Actualización:',
        'Users' => 'Usuarios',
        'OutboundEmail' => 'Opciones de correo electrónico',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'Planificación',
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
        'Complete' => 'Completado',
        'In Queue' => 'En cola',
        'Sending' => 'En envío',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'Televentas',
        'Mail' => 'Correo',
        'Email' => 'Correo electrónico',
        'Print' => 'Imprimir',
        'Web' => 'Web',
        'Radio' => 'Radio',
        'Television' => 'Televisión',
        'NewsLetter' => 'Boletín de Noticias',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'RECIBIR',
        'POST' => 'PUBLICAR',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'Semanal',
        'Monthly' => 'Mensual',
        'Quarterly' => 'Trimestral',
        'Annually' => 'Anual',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'Enero',
        '2' => 'Febrero',
        '3' => 'Marzo',
        '4' => 'Abril',
        '5' => 'Mayo',
        '6' => 'Junio',
        '7' => 'Julio',
        '8' => 'Agosto',
        '9' => 'Septiembre',
        '10' => 'Octubre',
        '11' => 'Noviembre',
        '12' => 'Diciembre',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'Ene',
        '2' => 'Feb',
        '3' => 'Mar',
        '4' => 'Abr',
        '5' => 'Mayo',
        '6' => 'Jun',
        '7' => 'Jul',
        '8' => 'Ago',
        '9' => 'Sep',
        '10' => 'Oct',
        '11' => 'Nov',
        '12' => 'Dic',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'Domingo',
        '2' => 'Lunes',
        '3' => 'Martes',
        '4' => 'Miércoles',
        '5' => 'Jueves',
        '6' => 'Viernes',
        '7' => 'Sábado',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'Dom',
        '2' => 'Lun',
        '3' => 'Mar',
        '4' => 'Mié',
        '5' => 'Jue',
        '6' => 'Vie',
        '7' => 'Sáb',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'Dom',
        '2' => 'Lun',
        '3' => 'Mar',
        '4' => 'Mié',
        '5' => 'Jue',
        '6' => 'Vie',
        '7' => 'S',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'Dom',
        '1' => 'Lun',
        '2' => 'Mar',
        '3' => 'Mié',
        '4' => 'Jue',
        '5' => 'Vie',
        '6' => 'Sáb',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'a.m.',
        'pm' => 'p.m.',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'a.m.',
        'PM' => 'a.m.',
        ],

        'dom_report_types' => [
        'tabular' => 'Filas y columnas',
        'summary' => 'Sumatorio',
        'detailed_summary' => 'Sumatorio con detalles',
        'Matrix' => 'Matriz',
        ],


        'dom_email_types' => [
        'out' => 'Enviado',
        'archived' => 'Archivado',
        'draft' => 'Borrador',
        'inbound' => 'Entrante',
        'campaign' => 'Campaña',
        ],
        'dom_email_status' => [
        'archived' => 'Archivado',
        'closed' => 'Cerrado',
        'draft' => 'Borrador',
        'read' => 'Leído',
        'replied' => 'Respondido',
        'sent' => 'Enviado',
        'send_error' => 'Error de Envío',
        'unread' => 'No leído',
        ],
        'dom_email_archived_status' => [
        'archived' => 'Archivado',
        ],

        'dom_email_server_type' => ['' => '--Ninguno--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--Ninguno--',
        'createcase' => 'Nuevo Caso',
        'bounce' => 'Gestión de devoluciones',
        ],
        'dom_email_distribution' => ['' => '--Ninguno--',
        'direct' => 'Asignación directa',
        'roundRobin' => 'Turnos rotativos',
        'leastBusy' => 'Menos ocupado',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'Turnos rotativos',
        'leastBusy' => 'Menos ocupado',
        'none' => 'Ninguno',
        ],
        'dom_email_errors' => [1 => 'Seleccione sólo un usuario cuando realice una asignación directa de elementos.',
        2 => 'Debe asignar sólo elementos marcados cuando realice una asignación directa de elementos.',
        ],
        'dom_email_bool' => ['bool_true' => 'Sí',
        'bool_false' => 'No',
        ],
        'dom_int_bool' => [1 => 'Sí',
        0 => 'No',
        ],
        'dom_switch_bool' => ['on' => 'Sí',
        'off' => 'No',
        '' => 'No',],

        'dom_email_link_type' => ['sugar' => 'Cliente de email de Sugar',
        'mailto' => 'Cliente de email externo'],


        'dom_email_editor_option' => ['' => 'Formato de email por defecto',
        'html' => 'Email HTML',
        'plain' => 'Email con texto sin formato'],

        'schedulers_times_dom' => ['not run' => 'Transcurrido tiempo de ejecución, no ejecutado',
        'ready' => 'Listo',
        'in progress' => 'En Progreso',
        'failed' => 'Falló',
        'completed' => 'Completada',
        'no curl' => 'No ejecutado: cURL no está disponible',
        ],

        'dom_email_states' => [
        'Draft' => 'Borrador',
        'Archived' => 'Archivado',
        ],

        'dom_email_direction' => [
        'Unknown' => 'Desconocido',
        'Outbound' => 'Saliente',
        'Inbound' => 'Entrante',
        'Internal' => 'Interno',
        ],

        'scheduler_status_dom' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
        ],

        'scheduler_period_dom' => [
        'min' => 'Minutos',
        'hour' => 'Horas',
        ],
        'forecast_type_dom' => [
        'Direct' => 'Directo',
        'Rollup' => 'Resumen',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'Marketing',
        'Knowledge Base' => 'Base de conocimiento',
        'Sales' => 'Ventas',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'Impresos de Marketing',
        'Product Brochures' => 'Folletos de Producto',
        'FAQ' => 'Preguntas frecuentes',
        ],

        'document_status_dom' => [
        'Active' => 'Activo',
        'Draft' => 'Borrador',
        'FAQ' => 'Preguntas frecuentes',
        'Expired' => 'Caducado',
        'Under Review' => 'En Revisión',
        'Pending' => 'Pendiente',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'Combinar Correspondencia',
        'eula' => 'CLUF',
        'nda' => 'ANR',
        'license' => 'Contrato de licencia',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'Aceptar',
        'decline' => 'Rechazar',
        'tentative' => 'Provisional',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'Aceptado',
        'decline' => 'Rechazado',
        'tentative' => 'Provisional',
        'none' => 'Ninguna',
        ],
        'dataset_output_default_dom' => [
        'table' => 'Tabla',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'Módulo único',
        'Multi Module' => 'Multi Módulo',
        ],
        'report_align_dom' => [
        'left' => 'Izquierda',
        'center' => 'Centrar',
        'right' => 'Derecha',
        ],

        'width_type_dom' => [
        '%' => 'Porcentaje (%)',
        'px' => 'Píxeles (px)',
        ],
        'report_color_dom' => [
        '' => 'Por defecto',
        'black' => 'Negro',
        'green' => 'Verde',
        'blue' => 'Azul',
        'red' => 'Rojo',
        'white' => 'Blanco',
        'DarkGreen' => 'Verde oscuro',
        'LightGray' => 'Gris claro',
        'DodgerBlue' => 'Azul brillante',
        'LightBlue' => 'Azul claro',
        ],
        'font_size_dom' => [
        '-5' => 'Menor (-5)',
        '-4' => 'Menor (-4)',
        '-3' => 'Menor (-3)',
        '-2' => 'Menor (-2)',
        '-1' => 'Menor (-1)',
        'Default' => 'Por defecto',
        '1' => 'Mayor (+1)',
        '2' => 'Mayor (+2)',
        '3' => 'Mayor (+3)',
        '4' => 'Mayor (+4)',
        '5' => 'Mayor (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'Consulta principal',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'Visualización',
//  'Group By' => 'Group By',
        'Calculation' => 'Cálculo',
        ],
        'query_display_type_dom' => [
        'Default' => 'Por defecto',
        'Custom' => 'Personalizado',
        'Hidden' => 'Oculto',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'Día',
        'Week' => 'Semana',
        'Month' => 'Mes',
        'Quarter' => 'Trimestre',
        'Year' => 'Año',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'Ahora',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'SUM',
        'AVG' => 'AVG',
        'COUNT' => 'Cuenta',
        'STDDEV' => 'Desviación estándar',
        'VARIANCE' => 'Varianza',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'Campo estándar',
        'Time' => 'Intervalo de Tiempo',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'Filas (Eje Y)',
        'Columns' => 'Columnas (Eje X)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'Suma (Total)',
        'AVG' => 'Media',
        'MAX' => 'Máximo',
        'MIN' => 'Mínimo',
        'COUNT' => 'Cuenta',
        'STDDEV' => 'Desviación estándar',
        'VARIANCE' => 'Varianza',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'Estándar',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'Calc. matemático',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'Campo',
        'Value' => 'Valor',
        'Group' => 'Grupo',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'Columna',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'Deshabilitado',
        'Enabled' => 'Habilitado',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'Normal',
        'Scalar' => 'Escalar',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'Texto',
        'Accounting' => 'Contabilidad',
        'Date' => 'Fecha',
        'Datetime' => 'Fecha y hora',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'Año',
        'Quarter' => 'Trimestre',
        'Month' => 'Mes',
        'Week' => 'Semana',
        'Day' => 'Día',
        ],
        'dataset_style_dom' => [
        'normal' => 'Normal',
        'bold' => 'Negrita',
        'italic' => 'Cursiva',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) Más',
        '-' => '(-) Menos',
        '*' => '(X) Multiplicado Por',
        '/' => '(/) Dividido Por',
        ],
        'wflow_type_dom' => [
        'Normal' => 'Cuando se guarde el registro',
        'Time' => 'Después de transcurrir el tiempo',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Es',
        'in' => 'Es uno de',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'Es uno de',
        'not_in' => 'No es uno de',
        ],
        'cselect_type_dom' => [
        'Equals' => 'Igual a',
        'Does not Equal' => 'Distinto De',
        ],
        'dselect_type_dom' => [
        'Equals' => 'Igual a',
        'Less Than' => 'Menor Que',
        'More Than' => 'Mayor que',
        'Does not Equal' => 'No equivale a',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'Sí',
        'bool_false' => 'No',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'Igual a',
        ],
        'tselect_type_dom' => [
        '0' => '0 horas',
        '14440' => '4 horas',
        '28800' => '8 horas',
        '43200' => '12 horas',
        '86400' => '1 día',
        '172800' => '2 días',
        '259200' => '3 días',
        '345600' => '4 días',
        '432000' => '5 días',
        '604800' => '1 semana',
        '1209600' => '2 semanas',
        '1814400' => '3 semanas',
        '2592000' => '30 días',
        '5184000' => '60 días',
        '7776000' => '90 días',
        '10368000' => '120 días',
        '12960000' => '150 días',
        '15552000' => '180 días',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'era mayor que',
        'Less Than' => 'es menor que',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'Correo electrónico',
        'Invite' => 'Convocar',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'Mensaje normal',
        'Custom Template' => 'Plantilla Personalizada',
        'System Default' => 'Por Defecto en el Sistema',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'Usuarios actuales',
        'rel_user' => 'Usuarios relacionados',
        'rel_user_custom' => 'Usuario personalizado relacionado',
        'specific_team' => 'Equipo específico',
        'specific_role' => 'Rol específico',
        'specific_user' => 'Usuario específico',
        ],
        'wflow_array_type_dom' => [
        'future' => 'Valor Nuevo',
        'past' => 'Valor Anterior',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'Usuario',
        'Manager' => "Responsable del usuario",
        ],
        'wflow_address_type_dom' => [
        'to' => 'Para:',
        'cc' => 'CC:',
        'bcc' => 'CCO:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'Para:',
        'cc' => 'CC:',
        'bcc' => 'CCO:',
        'invite_only' => '(Sólo convocados)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'Para:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'Actualizar registro',
        'update_rel' => 'Actualizar registro relacionado',
        'new' => 'Nuevo registro',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'Fecha de activación',
        'Existing Value' => 'Valor existente',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'Opciones básicas',
        'Advanced' => 'Opciones Avanzadas',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'Usuario asignado al registro activado',
        'modified_user_id' => 'Usuario que modificó por última vez el registro activado',
        'created_by' => 'Usuario que creó el registro activado',
        'current_user' => 'Usuario con la sesión iniciada',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'Equipo actual del registro activado',
        'team_set_id' => 'Configuración del equipo actual del registro activado',
        'current_team' => 'Equipo del usuario con la sesión iniciada',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'Mover desplegable hacia atrás por',
        'advance' => 'Mover desplegable hacia adelante por',
        ],
        'wflow_record_type_dom' => [
        'All' => 'Registros nuevos y actualizados',
        'New' => 'Sólo registros nuevos',
        'Update' => 'Sólo registros actualizados',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'Todos los relacionados',
        //'first' => 'The first related',
        'filter' => 'Filtrar relacionados',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'todos los relacionados',
        'any' => 'cualquiera relacionado',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'Alertas antes de acciones',
        'actions_alerts' => 'Acciones antes de alertas'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'Ninguna',
        'Daily' => 'Diario',
        'Weekly' => 'Semanal',
        'Monthly' => 'Mensual',
        'Yearly' => 'Anual',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'día(s)',
        'Weekly' => 'semana(s)',
        'Monthly' => 'mes(es)',
        'Yearly' => 'año(s)',
        ],

        'repeat_end_types' => [
        'Until' => 'Hasta',
        'Occurrences' => 'Ocurrencias',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'Ninguna',
        'Each' => 'Cada',
        'On' => 'En el',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'primera',
        'second' => 'segunda',
        'third' => 'tercera',
        'fourth' => 'cuarta',
        'fifth' => 'quinta',
        'last' => 'última',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'Domingo',
        'Mon' => 'Lunes',
        'Tue' => 'Martes',
        'Wed' => 'Miércoles',
        'Thu' => 'Jueves',
        'Fri' => 'Viernes',
        'Sat' => 'Sábado',
        'Day' => 'Día',
        'WD' => 'Día de la semana',
        'WE' => 'Día del fin de semana',
        ],

        'duration_dom' => [
        '' => 'Ninguna',
        '900' => '15 minutos',
        '1800' => '30 minutos',
        '2700' => '45 minutos',
        '3600' => '1 hora',
        '5400' => '1,5 horas',
        '7200' => '2 horas',
        '10800' => '3 horas',
        '21600' => '6 horas',
        '86400' => '1 día',
        '172800' => '2 días',
        '259200' => '3 días',
        '604800' => '1 semana',
        ],
        'repeat_month_dom' => [
        '1' => 'Enero',
        '2' => 'Febrero',
        '3' => 'Marzo',
        '4' => 'Abril',
        '5' => 'Mayo',
        '6' => 'Junio',
        '7' => 'Julio',
        '8' => 'Agosto',
        '9' => 'Septiembre',
        '10' => 'Octubre',
        '11' => 'Noviembre',
        '12' => 'Diciembre',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'Por defecto',
        'seed' => 'Cabeza de Serie',
        'exempt_domain' => 'Lista de Exclusión - Por Dominio',
        'exempt_address' => 'Lista de Exclusión - Por Dirección de Email',
        'exempt' => 'Lista de Exclusión - Por Id',
        'test' => 'Comprobar',
        ],
        'currency_status_dom' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'Activo',
        'inactive' => 'Inactivo',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'Mensaje Enviado/Intentado',
        'send error' => 'Mensajes Rebotados,Otras causas',
        'invalid email' => 'Mensajes Rebotados,Email no válido',
        'link' => 'Enlace',
        'viewed' => 'Mensaje Visto',
        'removed' => 'Rehusado',
        'lead' => 'Clientes Portenciales Creados',
        'contact' => 'Contactos Creados',
        'blocked' => 'Excluidos por dirección o dominio',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'Contactos',
        'Users' => 'Usuarios',
        'Prospects' => 'Público Objetivo',
        'Leads' => 'Clientes Potenciales',
        'Accounts' => 'Cuentas',
        ],
        'merge_operators_dom' => [
        'like' => 'Contiene',
        'exact' => 'Exactamente',
        'start' => 'Empieza Con',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'Sí',
        'false' => 'No',
        'required' => 'Requerido',
        ],

        'fts_field_config' => [
        '0' => 'Deshabilitado',
        '2' => 'Posibilidad de búsqueda',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'Deshabilitado',
        1 => 'Habilitado',
        2 => 'En Filtro',
        3 => 'Filtro Seleccionado Por Defecto',
        4 => 'Sólo Filtro',
        ],

        'navigation_paradigms' => [
        'm' => 'Módulos',
        'gm' => 'Módulos Agrupados',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'No iniciada',
        'inprogress' => 'En Progreso',
        'signed' => 'Firmado',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'Mensual',
        'quarterly' => 'Trimestral',
        'halfyearly' => 'Semenstral',
        'yearly' => 'Anual',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 Día',
        '3' => '3 Días',
        '5' => '5 Días',
        '7' => '1 Semana',
        '14' => '2 Semanas',
        '21' => '3 Semanas',
        '31' => '1 Mes',
        ],
        'projects_priority_options' => [
        'high' => 'Alta',
        'medium' => 'Media',
        'low' => 'Baja',
        ],

        'projects_status_options' => [
        'notstarted' => 'No iniciada',
        'inprogress' => 'En Progreso',
        'completed' => 'Completada',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'Expandir Leyenda',
        'collapselegend' => 'Contraer Leyenda',
        'clickfordrilldown' => 'Clic para Profundizar',
        'drilldownoptions' => 'Opciones de Profundización',
        'detailview' => 'Más Detalles...',
        'piechart' => 'Gráfico Circular',
        'groupchart' => 'Gráfico Agrupado',
        'stackedchart' => 'Gráfico Apilado',
        'barchart' => 'Gráfico de Barras',
        'horizontalbarchart' => 'Gráfico de barras horizontales',
        'linechart' => 'Gráfico de Líneas',
        'noData' => 'Datos no disponibles',
        'print' => 'Imprimir',
        'pieWedgeName' => 'secciones',
        ],
        'chart_types' => [
        'hBarF' => 'Barra horizontal (apilada)',
        'hGBarF' => 'Barra horizontal (agrupada)',
        'vBarF' => 'Barra vertical (apilada)',
        'vGBarF' => 'Barra vertical (agrupada)',
        'pieF' => 'Círculo',
        'funnelF' => 'Embudo',
        'lineF' => 'Línea',
        'donutF' => 'Dónut',
        'treemapF' => 'Mapa de árbol',
        ],
        'd3_value_placement' => [
        '0' => 'Ninguna',
        '1' => 'Por defecto',
        'start' => 'Inicio',
        'middle' => 'Parte intermedia',
        'end' => 'Fin',
        'top' => 'Parte superior',
        'total' => 'Total',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'Embudo',
        'hbar' => 'Barra Horizontal',
        ],
        'release_status_dom' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
        ],
        'email_settings_for_ssl' => [
        '0' => 'Ninguno',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Aplicaciones menos seguras de Google',
        'exchange' => 'Exchange',
        'other' => 'Otro',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'Otros',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'Comillas Simples (&#39;)',
        '"' => 'Comillas Dobles (")',
        '' => 'Ninguna',
        'other' => 'Otro:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'Otro:',
        ],
        'link_target_dom' => [
        '_blank' => 'Nueva Ventana',
        '_self' => 'Misma Ventana',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'No actualizar automáticamente',
        '30' => 'Cada 30 segundos',
        '60' => 'Cada minuto',
        '180' => 'Cada 3 minutos',
        '300' => 'Cada 5 minutos',
        '600' => 'Cada 10 minutos',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'Ninguna',
        '15' => 'Cada 15 minutos',
        '30' => 'Cada 30 minutos',
        '45' => 'Cada 45 minutos',
        '60' => 'Cada Hora',
        '120' => 'Cada 2 Horas',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'Nunca',
        '30' => 'Cada 30 segundos',
        '60' => 'Cada minuto',
        '180' => 'Cada 3 minutos',
        '300' => 'Cada 5 minutos',
        '600' => 'Cada 10 minutos',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'Ninguna',
        '1' => 'Cada Minuto',
        '5' => 'Cada 5 Minutos',
        '10' => 'Cada 10 Minutos',
        '15' => 'Cada 15 minutos',
        '30' => 'Cada 30 minutos',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'Igual a',
        'not_equal' => 'No Está En',
        'greater_than' => 'Después de',
        'less_than' => 'Antes de',
        'last_7_days' => '7 Días Anteriores',
        'next_7_days' => '7 Días Siguientes',
        'last_30_days' => 'Últimos 30 Días',
        'next_30_days' => '30 Días Siguientes',
        'last_month' => 'Último Mes',
        'this_month' => 'Este Mes',
        'next_month' => 'Mes Siguiente',
        'last_year' => 'Último Año',
        'this_year' => 'Este Año',
        'next_year' => 'Año Siguiente',
        'between' => 'Está Entre',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'Último Año',
        'last_month' => 'Último Mes',
        'last_30_days' => 'Últimos 30 Días',
        'last_7_days' => '7 Días Anteriores',
        'this_month' => 'Este Mes',
        'this_year' => 'Este Año',
        'next_7_days' => '7 Días Siguientes',
        'next_30_days' => '30 Días Siguientes',
        'next_month' => 'Mes Siguiente',
        'next_year' => 'Año Siguiente',
        ],
        'numeric_range_search_dom' => [
        '=' => 'Igual a',
        'not_equal' => 'Distinto De',
        'greater_than' => 'Mayor Que',
        'greater_than_equals' => 'Mayor o Igual que',
        'less_than' => 'Menor Que',
        'less_than_equals' => 'Menor o Igual a',
        'between' => 'Está Entre',
        ],

        'filter_checkbox_dom' => [
        0 => 'Falso',
        1 => 'Verdadero',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'Ganado',
        'lost' => 'Perdido',
        'active' => 'Activo',
        ],

        'sweetspot_theme_options' => [
        'default' => 'Por defecto',
        'light' => 'Claro',
        'dark' => 'Oscuro',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'Mover',
        'donothing' => 'No hacer nada',
        ],
        'processes_auto_save_interval' => [
        0 => 'Nunca',
        30000 => 'Cada 30 segundos',
        60000 => 'Cada minuto',
        120000 => 'Cada 2 minutos',
        180000 => 'Cada 3 minutos',
        240000 => 'Cada 4 minutos',
        300000 => 'Cada 5 minutos',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'Sí',
        'No' => 'No',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'Incluido en la Previsión',
        'sales_stage' => 'Etapa de Ventas',
        'probability' => 'Probabilidad',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'Caso probable',
        'best' => 'Mejor',
        'worst' => 'Peor',
        ],
        'webLogicHookList' => [
        'after_save' => 'Después de Guardar',
        'after_delete' => 'Después de Eliminar',
        'after_relationship_add' => 'Después de Añadir la Relación',
        'after_relationship_delete' => 'Después de Eliminar la Relación',
        'after_login' => 'Después de Iniciar Sesión',
        'after_logout' => 'Después de Cerrar Sesión',
        'after_login_failed' => 'Después de Fallo de Inicio de Sesión',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'Habilitado',
        'INACTIVE' => 'Deshabilitado',
        ],
        'dashboard_view_name_list' => [
        'record' => 'Registro',
        'records' => 'Lista',
        'activities' => 'Flujo de actividad',
        'multi-line' => 'Lista multilineal',
        'omnichannel' => 'Omnichannel',
        'home' => 'Home',
        'focus' => 'Panel de enfoque',
        ],
        'metric_context_list' => [
        'service_console' => 'Consola de Servicio',
        'renewals_console' => 'Consola de renovaciones',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'Cada hora',
        '21600' => 'Cada 6 horas',
        '43200' => 'Cada 12 horas',
        '86400' => 'Diario',
        '604800' => 'Semanal',
        '1209600' => 'Cada 2 semanas',
        '2419200' => 'Cada 4 semanas',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'Año(s)',
        'month' => 'Mes(es)',
        'day' => 'Día(s)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'Descanso',
        'event' => 'Evento',
        'other' => 'Otro',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'Fecha (Último {{module}})',
        'start_date:asc' => 'Fecha (Primer {{module}})',
        'total_revenue:desc' => 'Precio (Total más alto)',
        'total_revenue:asc' => 'Precio (Total más bajo)',
        ],
        'calendar_type_list' => [
        'main' => 'Centro de Calendario',
        ],
        'calendar_views_options' => [
        'day' => 'Día',
        'week' => 'Semana',
        'workWeek' => 'Semana laboral',
        'expandedMonth' => 'Mes',
        'agenda' => 'Agenda',
        'timeline' => 'Línea de tiempo',
        'monthSchedule' => 'Planificador',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'Creado',
        'completed' => 'Completado',
        'declined' => 'Rechazado',
        'delivered' => 'Enviado',
        'sent' => 'Enviado',
        'signed' => 'Firmado',
        'voided' => 'Anulado',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'Mostrar lista de destinatarios potenciales',
        'dont_show' => 'No mostrar destinatarios potenciales',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'Firmante',
        'carbon_copy' => 'Visor (duplicado)',
        'certified_delivery' => 'Visor (Entrega certificada)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'Predeterminado',
        'color' => 'Color',
        'image' => 'Imagen',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'Abreviatura',
        'icon' => 'Icono',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'Flecha hacia abajo',
        'sicon-chevron-left' => 'Chevrón hacia la izquierda',
        'sicon-check' => 'Verificar',
        'sicon-clock' => 'Reloj',
        'sicon-dashboard-default' => 'Panel de control predeterminado',
        'sicon-dashboard' => 'Panel de control',
        'sicon-edit' => 'Editar',
        'sicon-caret-down' => 'Marca hacia abajo',
        'sicon-folder' => 'Carpeta',
        'sicon-info' => 'Información',
        'sicon-kebab' => 'Kebab',
        'sicon-link' => 'Enlace',
        'sicon-list' => 'Lista',
        'sicon-logout' => 'Cerrar sesión',
        'sicon-minus' => 'Menos',
        'sicon-folder-open' => 'Carpeta abierta',
        'sicon-plus-sm' => 'Más Sm',
        'sicon-refresh' => 'Actualizar',
        'sicon-plus' => 'Más',
        'sicon-settings' => 'Configuración',
        'sicon-arrow-right-double' => 'Flecha doble hacia la derecha',
        'sicon-reports' => 'Informes',
        'sicon-user' => 'Usuario',
        'sicon-upload' => 'Subir',
        'sicon-user-group' => 'Grupo de usuarios',
        'sicon-arrow-left-double' => 'Flecha doble hacia la izquierda',
        'sicon-chevron-up' => 'Chevrón hacia arriba',
        'sicon-caret-up' => 'Flecha hacia arriba',
        'sicon-star-fill' => 'Relleno de estrellas',
        'sicon-download' => 'Descargar',
        'sicon-close' => 'Cerrar',
        'sicon-tile-view' => 'Vista de mosaico',
        'sicon-list-view' => 'Vista de lista',
        'sicon-thumbs-down' => 'Pulgares hacia abajo',
        'sicon-warning-circle' => 'Círculo de advertencia',
        'sicon-phone' => 'Teléfono',
        'sicon-email' => 'Correo electrónico',
        'sicon-document' => 'Documento',
        'sicon-note' => 'Nota',
        'sicon-preview' => 'Vista previa',
        'sicon-copy' => 'Copiar',
        'sicon-launch' => 'Lanzar',
        'sicon-lock' => 'Bloquear',
        'sicon-arrow-top-right' => 'Flecha arriba a la derecha',
        'sicon-full-screen' => 'Pantalla Completa',
        'sicon-full-screen-exit' => 'Salir de pantalla completa',
        'sicon-expand-left' => 'Ampliar a la izquierda',
        'sicon-expand-right' => 'Ampliar a la derecha',
        'sicon-focus-drawer' => 'Cajón de enfoque',
        'sicon-ban' => 'Prohibir',
        'sicon-thumbs-up' => 'Pulgares arriba',
        'sicon-search' => 'Buscar',
        'sicon-calendar' => 'Calendario',
        'sicon-calendar-lg' => 'Calendario Lg',
        'sicon-mobile-lg' => 'Móvil Lg',
        'sicon-star-fill-lg' => 'Relleno de estrellas Lg',
        'sicon-star-outline-lg' => 'Contorno de estrella Lg',
        'sicon-reset-lg' => 'Restaurar Lg',
        'sicon-exchange-lg' => 'Intercambio Lg',
        'sicon-help-lg' => 'Ayuda Lg',
        'sicon-close-lg' => 'Cerrar Lg',
        'sicon-plus-lg' => 'Más Lg',
        'sicon-shortcuts-lg' => 'Accesos directos Lg',
        'sicon-search-lg' => 'Buscar Lg',
        'sicon-email-lg' => 'Correo electrónico Lg',
        'sicon-note-lg' => 'Nota Lg',
        'sicon-document-lg' => 'Documento Lg',
        'sicon-add-dashlet-lg' => 'Añadir dashlet Lg',
        'sicon-collapse-lg' => 'Contraer Lg',
        'sicon-hamburger-lg' => 'Hamburguesa Lg',
        'sicon-pin-fill-lg' => 'Relleno de chincheta Lg',
        'sicon-expand-lg' => 'Ampliar Lg',
        'sicon-copy-lg' => 'Copiar Lg',
        'sicon-dashboard-lg' => 'Panel de control Lg',
        'sicon-star-outline' => 'Contorno de estrella',
        'sicon-reset' => 'Restablecer',
        'sicon-unlink' => 'Desvincular',
        'sicon-phone-lg' => 'Teléfono Lg',
        'sicon-attach' => 'Adjuntar',
        'sicon-case-lg' => 'Caso Lg',
        'sicon-arrow-right-lg' => 'Flecha derecha Lg',
        'sicon-check-circle-lg' => 'Círculo de verificación Lg',
        'sicon-text-formatting' => 'Formato de texto',
        'sicon-check-circle' => 'Círculo de verificación',
        'sicon-upload-lg' => 'Subir Lg',
        'sicon-flag-lg' => 'Marcar Lg',
        'sicon-studio-lg' => 'Estudio Lg',
        'sicon-contact-lg' => 'Contacto Lg',
        'sicon-edit-lg' => 'Editar Lg',
        'sicon-arrow-left' => 'Flecha izquierda',
        'sicon-reply-all' => 'Responder a todos',
        'sicon-message-lg' => 'Mensaje Lg',
        'sicon-info-lg' => 'Información Lg',
        'sicon-error-lg' => 'Error Lg',
        'sicon-check-circle-line-lg' => 'Línea de círculo de verificación Lg',
        'sicon-warning-line-lg' => 'Línea de advertencia Lg',
        'sicon-arrow-up' => 'Flecha arriba',
        'sicon-arrow-right' => 'Flecha derecha',
        'sicon-nodes' => 'Nodos',
        'sicon-hide' => 'Ocultar',
        'sicon-help' => 'Ayuda',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'Mensaje',
        'sicon-sugar-predict-lg' => 'Sugar Predict Lg',
        'sicon-sugar-predict' => 'Sugar Predict',
        'sicon-opportunity-lg' => 'Oportunidad Lg',
        'sicon-lead-lg' => 'Cliente potencial Lg',
        'sicon-account-lg' => 'Cuenta Lg',
        'sicon-user-sm' => 'Usuario Sm',
        'sicon-quote-lg' => 'Presupuesto Lg',
        'sicon-equal' => 'Igual',
        'sicon-slicers-xl' => 'Segmentadores Xl',
        'sicon-escalation-lg' => 'Escalada Lg',
        'sicon-add-circle-lg' => 'Añadir círculo Lg',
        'sicon-add-line-lg' => 'Añadir línea Lg',
        'sicon-add-target-lg' => 'Añadir objetivo Lg',
        'sicon-help-circle-lg' => 'Círculo de ayuda Lg',
        'sicon-divide-line-lg' => 'Línea de división Lg',
        'sicon-string' => 'Cadena',
        'sicon-filter' => 'Filtro',
        'sicon-number' => 'Número',
        'sicon-format-lg' => 'Formato Lg',
        'sicon-insights-lg' => 'Perspectivas Lg',
        'sicon-invalid-circle-lg' => 'Círculo no válido Lg',
        'sicon-layout-xl' => 'Diseño Xl',
        'sicon-layout-lg' => 'Diseño Lg',
        'sicon-multiply-line-lg' => 'Línea de multiplicación Lg',
        'sicon-redo-lg' => 'Volver a hacer Lg',
        'sicon-refresh-lg' => 'Actualizar Lg',
        'sicon-undo-lg' => 'Deshacer Lg',
        'sicon-activity-feed-xl' => 'Canal de actividad Xl',
        'sicon-chevron-left-xl' => 'Chevrón hacia la izquierda Xl',
        'sicon-close-xl' => 'Cerrar Xl',
        'sicon-kebab-lg' => 'Kebab Lg',
        'sicon-insights-xl' => 'Perspectivas Xl',
        'sicon-hide-lg' => 'Ocultar Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => 'Comentario Xl',
        'sicon-share-lg' => 'Compartir Lg',
        'sicon-trash' => 'Papelera',
        'sicon-launch-lg' => 'Lanzar Lg',
        'sicon-thumbs-up-lg' => 'Pulgares arriba Lg',
        'sicon-thumbs-down-lg' => 'Pulgares hacia abajo Lg',
        'sicon-warning-lg' => 'Aviso Lg',
        'sicon-wizard-circle-xl' => 'Círculo de asistente Xl',
        'sicon-bell-cross-lg' => 'Campana cruzada Lg',
        'sicon-bell-lg' => 'Campana Lg',
        'sicon-daily-lg' => 'Diario Lg',
        'sicon-cloud-download-lg' => 'Descarga de la nube Lg',
        'sicon-unlock' => 'Desbloquear',
        'sicon-news-lg' => 'Noticias Lg',
        'sicon-weekly-lg' => 'Semanal Lg',
        'sicon-knowledgebase-xl' => 'Base de conocimientos Xl',
        'sicon-remove' => 'Eliminar',
        'sicon-chevron-down' => 'Chevrón abajo',
        'sicon-slicers-lg' => 'Segmentadores Lg',
        'sicon-save-lg' => 'Guardar Lg',
        'sicon-info-circle-lg' => 'Círculo de información Lg',
        'sicon-chevron-right' => 'Chevrón hacia la derecha',
        'sicon-warning-circle-lg' => 'Círculo de advertencia Lg',
        'sicon-right-paren-line-lg' => 'Paréntesis derecho Lg',
        'sicon-comment-lg' => 'Comentario Lg',
        'sicon-target-lg' => 'Objetivo Lg',
        'sicon-subtract-line-lg' => 'Línea de resta Lg',
        'sicon-settings-lg' => 'Configuración Lg',
        'sicon-left-paren-line-lg' => 'Paréntesis izquierdo Lg',
        'sicon-preview-lg' => 'Vista previa Lg',
        'sicon-thumbs-down-line-lg' => 'Línea de pulgares hacia abajo Lg',
        'sicon-thumbs-up-line-lg' => 'Línea de pulgares hacia arriba Lg',
        'sicon-send-lg' => 'Enviar Lg',
        'sicon-contact-xl' => 'Contacto Xl',
        'sicon-wizard-circle-line-xl' => 'Línea de círculo de asistente Xl',
        'sicon-trash-lg' => 'Papelera Lg',
        'sicon-pin-lg' => 'Chincheta Lg',
        'sicon-clock-lg' => 'Reloj Lg',
        'sicon-comment-line-xl' => 'Línea de comentario Xl',
        'sicon-dropdown-editor' => 'Editor de listas desplegables',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'Incidencia',
        'sicon-catalog' => 'Catálogo',
        'sicon-cloud' => 'Nube',
        'sicon-config-api' => 'API de configuración',
        'sicon-config-nav' => 'Navegador de configuración',
        'sicon-connectors' => 'Conectores',
        'sicon-contracts' => 'Contratos',
        'sicon-currencies' => 'Monedas',
        'sicon-diagnostics' => 'Diagnóstico',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'Campaña por correo electrónico',
        'sicon-email-inbound' => 'Correo electrónico entrante',
        'sicon-email-queue' => 'Cola de correo electrónico',
        'sicon-forecasts' => 'Previsiones',
        'sicon-display-modules' => 'Mostrar módulos',
        'sicon-email-contacts' => 'Contactos de correo electrónico',
        'sicon-import' => 'Importar',
        'sicon-log-viewer' => 'Visualizador de registros',
        'sicon-lab' => 'Laboratorio',
        'sicon-map-pin' => 'Punto del mapa',
        'sicon-manufacturers' => 'Fabricantes',
        'sicon-update' => 'Actualizar',
        'sicon-content-security' => 'Seguridad del contenido',
        'sicon-module-builder' => 'Constructor de módulos',
        'sicon-languages' => 'Idiomas',
        'sicon-module-loader' => 'Cargador de módulos',
        'sicon-oauth-key' => 'Clave Oauth',
        'sicon-password-mgmt' => 'Gestión de contraseñas',
        'sicon-opportunities' => 'Oportunidades',
        'sicon-upgrade' => 'Actualizar',
        'sicon-portal' => 'Portal',
        'sicon-product-types' => 'Tipos de productos',
        'sicon-quotes' => 'Presupuestos',
        'sicon-relate-fields' => 'Relacionar campos',
        'sicon-repair' => 'Reparar',
        'sicon-role-mgmt' => 'Gestión de roles',
        'sicon-scheduler' => 'Planificador',
        'sicon-shippers' => 'Consignadores',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'Lógica Web',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'Tipos de impuestos',
        'sicon-team-mgmt' => 'Gestión de equipos',
        'sicon-team-perm' => 'Permisos de equipo',
        'sicon-tracker' => 'Seguimiento',
        'sicon-workflow' => 'Flujo de actividad',
        'sicon-mask' => 'Máscara',
        'sicon-mask-disabled' => 'Máscara desactivada',
        'sicon-email-archive' => 'Archivo de correo electrónico',
        'sicon-mobile' => 'Móvil',
        'sicon-archive' => 'Archivo',
        'sicon-automate-scroll' => 'Vista de desplazamiento vertical',
        'sicon-automate-stacked' => 'Vista de desplazamiento horizontal',
        'sicon-pdf-manager' => 'Gestor de PDF',
        'sicon-my-sites' => 'Mis sitios',
        'sicon-cloud-insights' => 'Cloud Insights',
        'sicon-sugar-logo-24' => 'Logotipo de Sugar 24',
        'sicon-sugar-logo-16' => 'Logotipo de Sugar 16',
        'sicon-task-lg' => 'Tarea Lg',
        'sicon-web-lg' => 'Web Lg',
        'sicon-events-lg' => 'Eventos Lg',
        'sicon-sugar-logo-12' => 'Logotipo de Sugar 12',
        'sicon-tag' => 'Etiqueta',
        'sicon-tag-lg' => 'Etiqueta Lg',
        'sicon-bell-lg-line' => 'Línea de campana Lg',
        'sicon-matrix-xxl' => 'Matriz Xxl',
        'sicon-advanced-filter' => 'Filtro avanzado',
        'sicon-rows-and-columns-xxl' => 'Filas y columnas Xxl',
        'sicon-summation-details-xxl' => 'Detalles de la suma Xxl',
        'sicon-summation-xxl' => 'Suma Xxl',
        'sicon-lock-lg' => 'Bloquear Lg',
        'sicon-csv-file-xxl' => 'Archivo Csv Xxl',
        'sicon-logo-linkedin' => 'Logotipo Linkedin',
        'sicon-briefcase' => 'Maletín',
        'sicon-car-front' => 'Coche de frente',
        'sicon-airplane' => 'Avión',
        'sicon-laptop' => 'Ordenador portátil',
        'sicon-logo-instagram' => 'Logotipo Instagram',
        'sicon-single-bed' => 'Cama individual',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'Logotipo Snapchat',
        'sicon-video-lg' => 'Vídeo Lg',
        'sicon-reply' => 'Responder',
        'sicon-subtract' => 'Restar',
        'sicon-arrow-up-circle-line' => 'Línea circular flecha hacia arriba',
        'sicon-asterisk' => 'Asterisco',
        'sicon-dot-circle-o-lg' => 'Círculo de puntos O Lg',
        'sicon-forward' => 'Avanzar',
        'sicon-video' => 'Vídeo',
        'sicon-gavel' => 'Mazo',
        'sicon-login' => 'Inicio de sesión',
        'sicon-pdf-file-xxl' => 'Archivo Pdf Xxl',
        'sicon-login-lg' => 'Inicio de sesión Lg',
        'sicon-cloud-download-xl' => 'Descarga de la nube Xl',
        'sicon-campaigns-lg' => 'Campañas Lg',
        'sicon-customer-journey-stages-lg' => 'Etapas del recorrido del cliente Lg',
        'sicon-role-mgmt-lg' => 'Gestión de roles Lg',
        'sicon-default-module-lg' => 'Módulo predeterminado Lg',
        'sicon-quoted-line-items-lg' => 'Elementos presupuestados Lg',
        'sicon-projects-lg' => 'Proyectos Lg',
        'sicon-process-business-rules-lg' => 'Normas empresariales de procesos Lg',
        'sicon-process-email-templates-lg' => 'Plantillas de correo electrónico de procesos Lg',
        'sicon-processes-lg' => 'Procesos Lg',
        'sicon-process-definitions-lg' => 'Definiciones de procesos Lg',
        'sicon-target-lists-lg' => 'Lista de público objetivo Lg',
        'sicon-purchased-line-items-lg' => 'Elementos comprados Lg',
        'sicon-user-group-lg' => 'Grupo de usuarios Lg',
        'sicon-revenue-line-items-lg' => 'Partidas de ingresos Lg',
        'sicon-business-centers-lg' => 'Centros de negocios Lg',
        'sicon-logo-fb-simple' => 'Logotipo Fb Simple',
        'sicon-forecasts-lg' => 'Previsiones Lg',
        'sicon-contracts-lg' => 'Contratos Lg',
        'sicon-purchase-lg' => 'Compras Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'Recorrido del cliente Lg',
        'sicon-data-privacy-lg' => 'Privacidad de datos Lg',
        'sicon-home-lg' => 'Inicio Lg',
        'sicon-data-table' => 'Tabla de datos',
        'sicon-medical-clipboard-lg' => 'Carpeta médica Lg',
        'sicon-privacy-lg' => 'Privacidad Lg',
        'sicon-marketplace' => 'Mercado',
        'sicon-marketplace-lg' => 'Mercado Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => 'Casino Lg',
        'sicon-jacuzzi-lg' => 'Jacuzzi Lg',
        'sicon-scissors-lg' => 'Tijeras Lg',
        'sicon-storage-lg' => 'Almacenamiento Lg',
        'sicon-fan-lg' => 'Ventilador Lg',
        'sicon-medicine-lg' => 'Medicina Lg',
        'sicon-plant-lg' => 'Planta Lg',
        'sicon-telescope-lg' => 'Telescopio Lg',
        'sicon-smart-phone-lg' => 'Teléfono inteligente Lg',
        'sicon-coffee-lg' => 'Café Lg',
        'sicon-martini-lg' => 'Martini Lg',
        'sicon-cocktail-lg' => 'Cóctel Lg',
        'sicon-stadium-lg' => 'Estado Lg',
        'sicon-fire-lg' => 'Fuego Lg',
        'sicon-window-lg' => 'Ventana Lg',
        'sicon-lotus-lg' => 'Lotus Lg',
        'sicon-windmill-lg' => 'Molino de viento Lg',
        'sicon-spades-lg' => 'Picas Lg',
        'sicon-hearts-lg' => 'Corazones Lg',
        'sicon-diamonds-lg' => 'Diamantes Lg',
        'sicon-clubs-lg' => 'Tréboles Lg',
        'sicon-skull-lg' => 'Calavera Lg',
        'sicon-send' => 'Enviar',
        'sicon-world-lg' => 'Mundo Lg',
        'sicon-airplane-lg' => 'Avión Lg',
        'sicon-planet-lg' => 'Planeta Lg',
        'sicon-trainer-lg' => 'Entrenador Lg',
        'sicon-calculator-lg' => 'Calculadora Lg',
        'sicon-tv-lg' => 'Televisión Lg',
        'sicon-video-player-lg' => 'Reproductor de vídeo Lg',
        'sicon-media-player-lg' => 'Reproductor multimedia Lg',
        'sicon-decentralize-lg' => 'Descentralizar Lg',
        'sicon-statistics-lg' => 'Estadísticas Lg',
        'sicon-virus-lg' => 'Virus Lg',
        'sicon-shield-lg' => 'Escudo Lg',
        'sicon-plug-lg' => 'Enchufe Lg',
        'sicon-shuttle-lg' => 'Lanzadera Lg',
        'sicon-soundwave-lg' => 'Onda sonora Lg',
        'sicon-graph-lg' => 'Gráfico Lg',
        'sicon-playlist-lg' => 'Lista de reproducción Lg',
        'sicon-voice-recognition-lg' => 'Reconocimiento de voz Lg',
        'sicon-machine-learning-lg' => 'Aprendizaje automático Lg',
        'sicon-bed-lg' => 'Cama Lg',
        'sicon-blueprint-lg' => 'Plano Lg',
        'sicon-content-delivery-lg' => 'Entrega de contenido Lg',
        'sicon-questionnaire-lg' => 'Cuestionario Lg',
        'sicon-presentation-lg' => 'Presentación Lg',
        'sicon-organic-lg' => 'Orgánico Lg',
        'sicon-transactions-lg' => 'Transacciones Lg',
        'sicon-wand-lg' => 'Varita Lg',
        'sicon-bin-lg' => 'Contenedor Lg',
        'sicon-sync-lg' => 'Sincronizar Lg',
        'sicon-external-authentication-lg' => 'Autenticación externa Lg',
        'sicon-tracking-activity-lg' => 'Seguimiento de la actividad Lg',
        'sicon-account' => 'Cuenta',
        'sicon-meetings-lg' => 'Reuniones Lg',
        'sicon-stacked' => 'Vista dividida horizontal',
        'sicon-sidebyside' => 'Vista dividida vertical',
        ],

        'module_colors_dom' => [
        'army' => 'Verde militar',
        'coral' => 'Coral',
        'green' => 'Verde',
        'orange' => 'Naranja',
        'ocean' => 'Océano',
        'pacific' => 'Índigo',
        'pink' => 'Rosa',
        'purple' => 'Morado',
        'red' => 'Rojo',
        'teal' => 'Verde azulado',
        'yellow' => 'Amarillo',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'Nuevo',
        'In Progress' => 'En progreso',
        'Closed' => 'Cerrado',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'Inactividad',
        'Lack of Progress' => 'Falta de progreso',
        'Customer-Imposed Deadline' => 'Fecha límite impuesta por el cliente',
        'Account at Risk' => 'Cuenta en riesgo',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'Solicitado por el cliente',
        'Internally Requested' => 'Solicitado internamente',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'Caso',
        'Bugs' => 'Incidencia',
        'Accounts' => 'Cuenta',
        'Opportunities' => 'Oportunidad',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'Positivo',
        'Negative' => 'Negativo',
        'Neutral' => 'Neutro',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'No probable',
        '02_less_likely' => 'Menos probable',
        '03_neutral' => 'Neutro',
        '04_more_likely' => 'Más probable',
        '05_very_likely' => 'Muy probable',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'No coincide con ningún cliente',
        '02_no_match' => '',
        '01_matches_customers' => 'Coincide con algún cliente',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'Cliente potencial',
        'Accounts' => 'Cuenta',
        'Contacts' => 'Contacto',
        'Cases' => 'Caso',
        'Opportunities' => 'Oportunidad',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'No iniciada',
        'in_progress' => 'En curso',
        'completed' => 'Completado',
        'cancelled' => 'Cancelado',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'Ninguna',
        'create' => 'Al crear',
        'stage_start' => 'Al inicio de fase',
        'previous_activity_completed' => 'Anterior actividad completada',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'Usuario actual',
        'parent_assignee' => 'Asignado principal',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'Días desde la creación',
        'days_from_stage_started' => 'Días desde el inicio de la fase',
        'days_from_previous_activity_completed' => 'Días desde la anterior actividad completada',
        'days_from_parent_date_field' => 'Días desde el campo de la fecha principal',
        'days_from_specific_activity_completed' => 'Días desde la actividad específica completada',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'Cuándo se crea',
        'stage_started' => 'Cuando inicia la fase',
        'previous_activity_completed' => 'Cuando la anterior actividad se completa',
        'parent_date_field' => 'En el campo de fecha principal',
        'specific_activity_completed' => 'Actividad específica completada',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'Absoluto',
        'Percentage' => 'Porcentaje',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'Tarea del cliente',
        'milestone' => 'Hito',
        'internal_task' => 'Tarea interna',
        'agency_task' => 'Tarea de agencia',
        'automatic_task' => 'Tarea automática',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'Tarea',
        'Calls' => 'Llamada',
        'Meetings' => 'Reunión',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'Ninguna',
        'create' => 'Al crear',
        'stage_start' => 'Al inicio de fase',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'Heredar',
        'current_user' => 'Usuario actual',
        'parent_assignee' => 'Asignado principal',
        'user' => 'Usuario',
        'team' => 'Equipo',
        'user_team' => 'Usuario y equipo',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'Heredar',
        'none' => 'Ninguna',
        'create' => 'Al crear',
        'stage_start' => 'Al inicio de fase',
        'previous_activity_completed' => 'Anterior actividad completada',
        'specific_activity_completed' => 'Actividad específica completada',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'No iniciada',
        'in_progress' => 'En curso',
        'not_completed' => 'Sin completar',
        'completed' => 'Completado',
        'cancelled' => 'Cancelado',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'Editar fase',
        'stage_add_task_button' => 'Crear tarea',
        'stage_add_meeting_button' => 'Programar reunión',
        'stage_add_call_button' => 'Programar llamada',
        'stage_delete_button' => 'Eliminar fase',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'Añadir tarea',
        'activity_add_sub_meeting_button' => 'Programar reunión',
        'activity_add_sub_call_button' => 'Programar llamada',
        'activity_not_applicable_button' => 'No aplicable',
        'activity_delete_button' => 'Eliminar',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'Conjunto no aplicable',
        'remove_open_activities' => 'Eliminar actividades abiertas',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'Predeterminado',
        'custom' => 'Personalizado',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'RECIBIR',
        'POST' => 'PUBLICAR',
        'PUT' => 'PONER',
        'PATCH' => 'PARCHE',
        'DELETE' => 'ELIMINAR',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'Omitir solicitud',
        'json' => 'JSON',
        'http_query' => 'Consulta HTTP',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'Sin respuesta',
        'json' => 'JSON',
        'http_query' => 'Consulta HTTP',
        'text' => 'Texto sin formato',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'Antes de crear',
        'after_create' => 'Después de crear',
        'before_in_progress' => 'Antes de En curso',
        'after_in_progress' => 'Después de En curso',
        'before_completed' => 'Antes de Completado',
        'after_completed' => 'Después de Completado',
        'before_not_applicable' => 'Antes de No aplicable',
        'after_not_applicable' => 'Después de No aplicable',
        'before_delete' => 'Antes de Eliminar',
        'after_delete' => 'Después de Eliminar',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Enviar información de la guía inteligente',
        'custom_body' => 'Enviar el cuerpo de la publicación personalizada',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'En curso',
        'completed' => 'Completado',
        'not_applicable' => 'No aplicable',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'Ver el registro',
        'create_record' => 'Crear registro',
        'update_record' => 'Actualizar registro',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'Crear registro automáticamente',
        'manual_create' => 'Crear registro manualmente',
        'automatic_update' => 'Actualizar registro automáticamente',
        'manual_update' => 'Actualizar registro manualmente',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Plantilla de la guía inteligente',
        'DRI_SubWorkflow_Templates' => 'Plantilla de fase',
        'DRI_Workflow_Task_Templates' => 'Plantilla de actividad',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'Sí',
        'no' => 'No',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'Realizada',
        'Not Held' => 'No se celebró',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'Realizada',
        'Not Held' => 'No se celebró',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'Completado',
        'Not Applicable' => 'No aplicable',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Plantilla de la guía inteligente',
        'DRI_SubWorkflow_Templates' => 'Plantilla de fase',
        'DRI_Workflow_Task_Templates' => 'Plantilla de actividad',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'Tarea',
        'Meetings' => 'Reunión',
        'Calls' => 'Llamada',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'Tarea actual',
        'Calls' => 'Llamada actual',
        'Meetings' => 'Reunión actual',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'Usuarios específicos',
        'specific_contacts' => 'Contactos específicos',
        'related_parent_users' => 'Usuarios principales relacionados',
        'related_parent_contacts' => 'Contactos principales relacionados',
        'add_all_contacts_from_parent' => 'Añadir todos los contactos del principal',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'Usuarios',
        'specific_contacts' => 'Contactos',
        'related_parent_users' => 'Usuarios',
        'related_parent_contacts' => 'Contactos',
        'add_all_contacts_from_parent' => 'Contactos',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'Minuto(s)',
        'hours' => 'Hora(s)',
        'days' => 'Día(s)',
        'months' => 'Mes(es)',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'Día(s)',
        'months' => 'Mes(es)',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'Fecha fija',
        'relative' => 'Fecha relativa',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'Usuarios',
        'teams' => 'Equipos',
        'roles' => 'Roles',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'De Smart Guide a acción de Sugar',
        'sugar_action_to_smart_guide' => 'De acción de Sugar a Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Fase de Smart Guide',
        'Smart Guide Activities' => 'Actividades de Smart Guide',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'Completado',
        'cancelled' => 'Cancelado',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'En curso',
        'completed' => 'Completado',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'En curso',
        'completed' => 'Completado',
        'not_applicable' => 'No aplicable',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'Marcar todas las actividades como Completadas',
        'mark_all_not_applicable' => 'Marcar todas las actividades incompletas como No aplicables',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'Estados Unidos (Oregón) [us-west-2]',
        'ca-central-1' => 'Canadá (Central) [ca-central-1]',
        'ap-southeast-1' => 'Asia-Pacífico (Singapur) [ap-southeast-1]',
        'ap-southeast-2' => 'Asia-Pacífico (Sídney) [ap-southeast-2]',
        'eu-central-1' => 'Europa (Fráncfort) [eu-central-1]',
        'eu-west-2' => 'Europa (Londres) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'Registro de Cabecera', // Studio editing of record views
    'LBL_RECORD_BODY' => 'Tarjeta de Visita', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'Mostrar más', // Studio editing of record views
    'LBL_FAVORITE' => 'Favorito', // Record view header panel element
    'LBL_FOLLOW' => 'Seguir', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'Siga el Enlace',
    'LBL_TOGGLE_VISIBILITY' => 'Conmutar Visibilidad', // Record view header panel element
    'LBL_ACTIVITIES' => 'Flujo de actividad',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar y el Cubo 3-D son marcas registradas de SugarCRM Inc. ' .
        'Todos los demás nombres de empresas y productos que se utilizan o aparecen en este producto pueden ser marcas registradas de las ' .
        'SugarCRM®, Sugar Enterprise™ y Sugar™ son marcas registradas de SugarCRM Inc.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ y Sugar™ son marcas comerciales de SugarCRM Inc.',
    'LBL_SEND_INVITE' => 'Enviar invitación',
    'LBL_INVITEES' => 'Asistentes',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'El invitado no recibirá su invitación',
    'LBL_SELECT_ACTION_LABEL' => 'Seleccionar Acción',
    'LBL_TOGGLE_DRAWER' => 'Conmutar Panel',
    'LBL_TOUR_NEXT' => 'Siguiente',
    'LBL_TOUR_SKIP' => 'Saltar',
    'LBL_TOUR_BACK' => 'Atrás',
    'LBL_TOUR_CLOSE' => 'Cerrar:',
    'LBL_TOUR_BTN_DONE' => 'Hecho',
    'LBL_TOUR_TAKE_TOUR' => 'Visita guiada',
    'LBL_TOUR_FULL_TOUR' => 'Guía Completa',
    'LBL_TOUR_MODULE' => 'Ver esta Página',
    'LBL_TOUR_END_TOUR' => 'Terminar Guía',
    'LBL_TOUR_OVERVIEW' => 'Resumen de la Página',
    'LBL_TOUR_REVISIT' => 'Haga clic aquí para mostrar el recorrido en cualquier momento.',
    'LBL_MY_AREA_LINKS' => 'Mis enlaces de área: ' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Cogiendo Aire' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'Bienvenido' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'Búsqueda avanzada' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'Más detalles' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'Editar en línea' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'Ver' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Buscar' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'Búsqueda...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'Quitar' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'Agregar' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'Columna' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 columnas' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 columnas' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Búsqueda avanzada' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'Agregar' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'Ocultar/Mostrar' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'Eliminar' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'Agregar' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'Borrar' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'Desvincular' /*for 508 compliance fix*/,
    'LBL_ADD' => 'Agregar' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'Logotipo compañia' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'Calendario' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'Un valor desplegable que ha seleccionado ha cambiado su diseño de la vista de registros. ' .
        'Los campos ocultos en este nuevo diseño tienen sus valores borrados. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'Abrir',
    'LBL_SIDEBAR_NAV_CLOSE' => 'Cerrar',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => 'Menú {{subject}}',
    'LBL_GOTO_SUGARCRM_COM' => 'Ir a SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'navegación por el módulo principal',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'activar subpanel',

    'LBL_ADVANCED' => 'Avanzado',
    'LBL_BASIC' => 'Básico',
    'LBL_MODULE_FILTER' => 'Filtrar por...',
    'LBL_CONNECTORS_POPUPS' => 'Ventanas emergentes de conectores',
    'LBL_CLOSEINLINE' => 'Cerrado',
    'LBL_EDITINLINE' => 'Editar',
    'LBL_VIEWINLINE' => 'Ver',
    'LBL_INFOINLINE' => 'Información',
    'LBL_POWERED_BY_SUGARCRM' => 'Desarrollado por SugarCRM',
    'LBL_PRINT' => 'Imprimir',
    'LBL_HELP' => 'Ayuda',
    'LBL_TOUR' => 'Visita Guiada de la Vista de Actividades',
    'LBL_TOUR_LINK' => 'Ver esta Página',
    'LBL_MOBILE' => 'Móvil:',
    'LBL_ID_FF_SELECT' => 'Seleccionar',
    'DEFAULT' => 'Básico',
    'LBL_SORT' => 'Ordenar',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Agregar Servidor...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => '¿Habilitar SMTP sobre SSL o TLS?',
    'LBL_NO_ACTION' => 'No hay ninguna acción con ese nombre.',
    'LBL_NO_DATA' => 'Sin Datos',
    'LBL_NOT_APPLICABLE' => 'No aplicable',
    'LBL_ROUTING_ADD_RULE' => 'Agregar Regla',
    'LBL_ROUTING_ALL' => 'Al menos',
    'LBL_ROUTING_ANY' => 'Cualquiera',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'Cancelar',
    'LBL_ROUTING_BUTTON_SAVE' => 'Guardar Regla',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'Copiar Correo',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Eliminar Objeto Sugar',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Eliminar Archivo',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'Eliminar Email',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'Reenviar Email',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'Marcar Email para Seguimiento',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'Marcar como Leído',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Marcar como No leído',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'Mover Email',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'Realizar las siguientes acciones',
    'LBL_ROUTING_ACTIONS_REPLY' => 'Responder al Email',

    'LBL_ROUTING_CHECK_RULE' => "Se ha detectado un error:\n",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'Verifique todos los campos que han sido marcados.',
    'LBL_ROUTING_CONFIRM_DELETE' => "¿Está seguro de que desea eliminar esta regla?\nEsta operación no puede deshacerse.",

    'LBL_ROUTING_FLAGGED' => 'conjunto de marcas de seguimiento',
    'LBL_ROUTING_FORM_DESC' => 'Las reglas se activan inmediatamente tras ser guardadas.',
    'LBL_ROUTING_FW' => 'RV:',
    'LBL_ROUTING_LIST_TITLE' => 'Reglas',
    'LBL_ROUTING_MATCH' => 'Si',
    'LBL_ROUTING_MATCH_2' => 'de las siguientes condiciones se cumple:',
    'LBL_NOTIFICATIONS' => 'Notificaciones',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'CC',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'Contenido del Cuerpo',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'De',
    'LBL_ROUTING_MATCH_NAME' => 'Asunto',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'Alta Prioridad',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Prioridad Normal',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Baja Prioridad',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'A',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'Contiene',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'No contiene',

    'LBL_ROUTING_NAME' => 'Nombre de Regla',
    'LBL_ROUTING_NEW_NAME' => 'Nueva Regla',
    'LBL_ROUTING_ONE_MOMENT' => 'Espere un momento...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Mensaje original a continuación.',
    'LBL_ROUTING_RE' => 'RE:',
    'LBL_ROUTING_SAVING_RULE' => 'Guardando Regla',
    'LBL_ROUTING_SUB_DESC' => 'Las reglas marcadas están activas. Haga clic en un nombre para editarlas.',
    'LBL_ROUTING_TO' => 'a',
    'LBL_ROUTING_TO_ADDRESS' => 'a la dirección',
    'LBL_ROUTING_WITH_TEMPLATE' => 'con la plantilla',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'Los campos Teléfono de la Oficina y Dirección de su formulario ya tienen valor asignado. Para sobrescribir dichos valores con el teléfono/dirección de la Cuenta que ha seleccionado, haga clic en "Aceptar". Para mantener los valores actuales, haga clic en "Cancelar".',
    'LBL_DROP_HERE' => '[Soltar Aquí]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'Editar',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Establecer configuración para Gmail&amp;#153;',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'Nombre',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Propiedades del Servidor de Correo Saliente',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'Agente de transferencia de correo (MTA)',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => '¿Usar Autenticación SMTP?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'Contraseña SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'Puerto SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'Servidor SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'Usar SSL en la conexión',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'Nombre de usuario SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Por Defecto',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Aviso: Falta el nombre de usuario y la contraseña para la cuenta de correo saliente.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'Hace falta el nombre de usuario SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'Hace falta la contraseña SMTP',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'Administración de Cuentas de Correo',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'El Protocolo de Servidores de Correo de tipo POP3 no es compatible en la siguiente versión. Sólo IMAP será compatible.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'Configurar Cuentas de Correo para ver correos entrantes de sus cuentas de correo.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Proporcionar información del servidor de correo SMTP que se utilizará para el correo saliente en Cuentas de Correo.',
    'LBL_EMAIL_ADD' => 'Añadir email',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Hecho',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Borrar',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'Para:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Cc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Cco:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'Para/Cc/Cco',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'Nueva Lista',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'Dirección de Email',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Sólo se permite la edición de Contactos en este momento.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filtro',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'Nombre/Cuenta',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Apellidos',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'Mis Contactos',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'Mis Listas de Correo',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'Nombre',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'No se han encontrado ninguna dirección',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Guardar y Agregar a la Libreta de Direcciones',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Búsqueda',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Seleccionar Destinatarios de Email',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Libreta de Direcciones',
    'LBL_EMAIL_REPORTS_TITLE' => 'Informes',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => '¡Aviso! La cuenta de correo saliente que está intentando eliminar está asociada a una cuenta de correo entrante existente.  ¿Está seguro de que quiere continuar?',
    'LBL_EMAIL_ADDRESSES' => 'Correo electrónico',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'Dirección de Email',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'Direcciones de Email',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Importar a Sugar',
    'LBL_EMAIL_ASSIGNMENT' => 'Asignación',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Adjuntar',
    'LBL_EMAIL_ATTACHMENT' => 'Adjuntar',
    'LBL_EMAIL_ATTACHMENTS' => 'Desde el Equipo Local',
    'LBL_EMAIL_ATTACHMENTS2' => 'Desde Documentos Sugar',
    'LBL_EMAIL_ATTACHMENTS3' => 'Adjuntos de Plantilla',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'Archivo',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Documento',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Incrustado',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'Ha habido un error al cargar los adjuntos',
    'LBL_REMOVING_ATTACHMENT' => 'Eliminando adjunto...',
    'LBL_EMAIL_BCC' => 'CCO',
    'LBL_EMAIL_CANCEL' => 'Cancelar',
    'LBL_EMAIL_CC' => 'CC',
    'LBL_EMAIL_CHARSET' => 'Juego de Caracteres',
    'LBL_EMAIL_CHECK' => 'Comprobar Correo',
    'LBL_EMAIL_CHECKING_NEW' => 'Comprobando Email Nuevo',
    'LBL_EMAIL_CHECKING_DESC' => 'Un momento... <br><br>Si es la primera comprobación de la cuenta de correo, puede tardar un poco.',
    'LBL_EMAIL_CLOSE' => 'Cerrar',
    'LBL_EMAIL_COFFEE_BREAK' => 'Comprobando Correo Nuevo. <br><br>Las cuentas de correo con gran volumen pueden tardar una cantidad considerable de tiempo.',
    'LBL_EMAIL_COMMON' => 'Común',

    'LBL_EMAIL_COMPOSE' => 'Correo electrónico',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Introduzca los destinatarios de este email.',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'Asociar con',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'El cuerpo de este mensaje está vacío.  ¿Enviar de todas formas?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'Este mensaje no tiene asunto.  ¿Enviar de todas formas?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(sin asunto)',
    'LBL_EMAIL_COMPOSE_READ' => 'Leer y Redactar Email',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Enviar desde la Cuenta de Correo',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'Opciones',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Introduzca una dirección de email válida para los campos Para, CC y CCO',

    'LBL_EMAIL_CONFIRM_CLOSE' => '¿Descartar este email?',
    'LBL_EMAIL_CONFIRM_DELETE' => '¿Desea quitar estas entradas de su Libreta de Direcciones?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => '¿Está seguro de que desea eliminar esta firma?',

    'LBL_EMAIL_CREATE_NEW' => '--Crear Al Guardar--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Múltiple',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Vacío',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Fecha de Envío por Remitente',
    'LBL_EMAIL_DATE_RECEIVED' => 'Fecha de Recepción',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'Asignado a Usuario',
    'LBL_EMAIL_DATE_TODAY' => 'Hoy',
    'LBL_EMAIL_DATE_YESTERDAY' => 'Ayer',
    'LBL_EMAIL_DD_TEXT' => 'email(s) seleccionados.',
    'LBL_EMAIL_DEFAULTS' => 'Por defecto',
    'LBL_EMAIL_DELETE' => 'Eliminar',
    'LBL_EMAIL_DELETE_CONFIRM' => '¿Eliminar mensajes seleccionados?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'Email eliminado satisfactoriamente.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'Eliminando Mensaje',
    'LBL_EMAIL_DETAILS' => 'Detalles',
    'LBL_EMAIL_DISPLAY_MSG' => 'Mostrando emails {0} - {1} de {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'Mostrando direcciones de email {0} - {1} de {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'Editar Contacto',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Sólo se utilizará la Dirección principal al trabajar con Contactos.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'Editar Lista de Correo',

    'LBL_EMAIL_EMPTYING_TRASH' => 'Vaciando Papelera',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'Eliminando servidor saliente',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'Limpiando archivos de la caché',
    'LBL_EMAIL_EMPTY_MSG' => 'No hay emails que mostrar.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'No hay direcciones de email que mostrar.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'El nombre de carpeta debe ser único y no vacío. Inténtelo de nuevo.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'No puede borrarse una carpeta. O la carpeta o sus hijos tienen emails o una bandeja de correo asociada.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'No se ha podido determinar la carpeta deseada a partir del contexto. Inténtelo de nuevo.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Compruebe su configuración.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Asegúrese de introducir un apellido.',
    'LBL_EMAIL_ERROR_DESC' => 'Se han detectado errores:',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'No tiene acceso a esta área. Contacte al Administrador de su sitio web para obtenerlo.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Los nombres de carpetas Sugar deben ser únicos.',
    'LBL_EMAIL_ERROR_EMPTY' => 'Introduzca algún criterio de búsqueda.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'Ha ocurrido un error',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'Ya existe una lista de email con ese nombre',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Mensaje eliminado del servidor',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'El mensaje se ha eliminado en el servidor o se ha movido a otra carpeta',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'La conexión con el servidor de correo ha fallado. Contacte a su Administrador',
    'LBL_EMAIL_ERROR_MOVE' => 'De momento mover emails entre servidores y/o cuentas de correo no es compatible.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'Error al Mover',
    'LBL_EMAIL_ERROR_NAME' => 'Se requiere un nombre.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'Se requiere la Dirección del Remitente. Introduzca una dirección de email válida.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'Proporcione un archivo.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'El cambio de nombre en carpetas IMAP no es compatible en este momento.',
    'LBL_EMAIL_ERROR_SERVER' => 'Se requiere una dirección de servidor de correo.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'Es posible que la cuenta de correo no se haya guardado.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'Ha ocurrido un error durante la comunicación con el servidor de correo.',
    'LBL_EMAIL_ERROR_USER' => 'Se requiere un nombre de inicio de sesión.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'Se requiere una contraseña.',
    'LBL_EMAIL_ERROR_PORT' => 'Se requiere un puerto del servidor de correo.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'Se requiere un protocolo de servidor.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'Se requiere una Carpeta Monitorizada.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'Se requiere una Carpeta de Papelera.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'Esta información no está disponible',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'No se ha especificado un servidor de correo saliente.',
    'LBL_EMAIL_FOLDERS' => 'Carpetas',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'Mover A',
    'LBL_EMAIL_FOLDERS_ADD' => 'Agregar',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Agregar Nueva Carpeta',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Renombrar Carpeta',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Guardar',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Agregar esta carpeta a',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'Esta carpeta no se puede cambiar',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => '¿Está seguro de que quiere eliminar esta carpeta?\nEste proceso no se puede deshacer.\nLa eliminación de carpetas se aplicará en cascada a todas las carpetas incluidas.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'Nombre de la Nueva Carpeta',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Seleccione una carpeta antes de realizar esta acción.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'Administración de Carpetas',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Usando el Grupo',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'Asignar a Equipo',
    'LBL_EMAIL_FORWARD' => 'Reenviar',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => '[[count]] de [[total]] emails descargados',
    'LBL_EMAIL_FOUND' => 'Encontrado',
    'LBL_EMAIL_FROM' => 'De',
    'LBL_EMAIL_GROUP' => 'grupo',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'Grupo',
    'LBL_EMAIL_HOME_FOLDER' => 'Inicio',
    'LBL_EMAIL_HTML_RTF' => 'Enviar HTML',
    'LBL_EMAIL_IE_DELETE' => 'Eliminando Cuenta de Correo',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'Eliminando firma',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => '¿Está seguro de que desea eliminar esta cuenta de correo?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Borrado satisfactorio.',
    'LBL_EMAIL_IE_SAVE' => 'Guardando Información de Cuenta de Correo',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'Importando Email',
    'LBL_EMAIL_IMPORT_EMAIL' => 'Importar en Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'Configuración de Importación',
    'LBL_EMAIL_INVALID' => 'No válido',
    'LBL_EMAIL_LINK_RECORD' => 'Haga clic aquí',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'Renombrar Lista de Correo',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'Introduzca un nuevo nombre para la lista de correo',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => '¿Desea quitar estas entradas de sus listas de correo?',
    'LBL_EMAIL_LOADING' => 'Cargando...',
    'LBL_EMAIL_MARK' => 'Marcar',
    'LBL_EMAIL_MARK_FLAGGED' => 'Como Etiquetado',
    'LBL_EMAIL_MARK_READ' => 'Como Leído',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'Como No Etiquetado',
    'LBL_EMAIL_MARK_UNREAD' => 'Como no Leído',
    'LBL_EMAIL_ASSIGN_TO' => 'Asignar a',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'Crear Carpeta',
    'LBL_EMAIL_MENU_COMPOSE' => 'Redactar para',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Eliminar Carpeta',
    'LBL_EMAIL_MENU_EDIT' => 'Editar',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Vaciar Papelera',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Sincronizar',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Limpiar archivos de caché',
    'LBL_EMAIL_MENU_REMOVE' => 'Quitar',
    'LBL_EMAIL_MENU_RENAME' => 'Renombrar',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Renombrar Carpeta',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Renombrando Carpeta',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Realice una selección antes de intentar esta operación.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Crear una Carpeta (remota o en Sugar)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'Archivar estos correos en SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'Enviar por correo a las listas de Correo seleccionadas',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'Enviar por Correo a este Contacto',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Quitar un Contacto',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'Eliminar estos emails',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Eliminar una Carpeta (remota o en Sugar)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Editar un Contacto',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Editar una Lista de Correo',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Vacía todas las carpetas de Papelera de sus cuentas de correo',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'Marcar estos correos como etiquetados',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'Marcar estos correos como leídos',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'Marcar estos correos como no etiquetados',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'Marcar estos correos como no leídos',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Quita las Listas de Correo',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Renombrar una Carpeta (remota o en Sugar)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'Responder a estos correos',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'Responder a todos los destinatarios de estos correos',

    'LBL_EMAIL_MESSAGES' => 'mensajes',

    'LBL_EMAIL_ML_NAME' => 'Nombre de Lista',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'Lista de Direcciones Seleccionada',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'Lista de Direcciones Disponibles',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-Clic</b> para seleccionar múltiples<br />(los usuarios de Mac pueden usar <b>CMD-Clic</b>)',

    'LBL_EMAIL_NO' => 'No',
    'LBL_EMAIL_NOT_SENT' => 'Se ha producido un problema al enviar el correo de solicitud. Póngase en contacto con el administrador del sistema.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'No se ha podido insertar en users_password_link.',

    'LBL_EMAIL_OK' => 'Aceptar',
    'LBL_EMAIL_ONE_MOMENT' => 'Espere un momento...',
    'LBL_EMAIL_OPEN_ALL' => 'Abrir Varios Mensajes',
    'LBL_EMAIL_OPTIONS' => 'Opciones',
    'LBL_EMAIL_QUICK_COMPOSE' => 'Redacción Rápida',
    'LBL_EMAIL_OPT_OUT' => 'Rehusado',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Rehusado e invalido',
    'LBL_EMAIL_PAGE_AFTER' => 'de {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'Página',
    'LBL_EMAIL_PERFORMING_TASK' => 'Realizando Tarea',
    'LBL_EMAIL_PRIMARY' => 'Principal',
    'LBL_EMAIL_PRINT' => 'Imprimir',

    'LBL_EMAIL_QC_BUGS' => 'Incidencia',
    'LBL_EMAIL_QC_CASES' => 'Caso',
    'LBL_EMAIL_QC_LEADS' => 'Cliente Potencial',
    'LBL_EMAIL_QC_CONTACTS' => 'Contacto',
    'LBL_EMAIL_QC_TASKS' => 'Tarea',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'Oportunidad',
    'LBL_EMAIL_QUICK_CREATE' => 'Creación Rápida',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'Reconstruyendo Carpetas',
    'LBL_EMAIL_RELATE_TO' => 'Relacionar',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'Ver Relaciones',
    'LBL_EMAIL_RECORD' => 'Registro de Correo',
    'LBL_EMAIL_REMOVE' => 'Quitar',
    'LBL_EMAIL_REPLY' => 'Responder',
    'LBL_EMAIL_REPLY_ALL' => 'Responder a Todos',
    'LBL_EMAIL_REPLY_TO' => 'Responder a',
    'LBL_EMAIL_RETRIEVING_LIST' => 'Recuperando Lista de Emails',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Recuperando Mensaje',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'Recuperando Registro de Correo',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Seleccione un único registro de correo',
    'LBL_EMAIL_RETURN_TO_VIEW' => '¿Desea volver al Módulo Anterior?',
    'LBL_EMAIL_REVERT' => 'Volver',
    'LBL_EMAIL_RELATE_EMAIL' => 'Relacionar Correo',

    'LBL_EMAIL_RULES_TITLE' => 'Administración de Reglas',

    'LBL_EMAIL_SAVE' => 'Guardar',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'Guardar y Responder',
    'LBL_EMAIL_SAVE_DRAFT' => 'Guardar Borrador',

    'LBL_EMAIL_SEARCHING' => 'Llevando a cabo la Búsqueda',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'Búsqueda Avanzada',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'Fecha Desde',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Fecha Hasta',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'Texto del Cuerpo',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'No hay resultados para sus criterios de búsqueda.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Resultados de la Búsqueda',
    'LBL_EMAIL_SEARCH_TITLE' => 'Búsqueda Simple',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'Buscar cuenta de correo',

    'LBL_EMAIL_SELECT' => 'Seleccionar',

    'LBL_EMAIL_SEND' => 'Enviar',
    'LBL_EMAIL_SENDING_EMAIL' => 'Enviando Correo',

    'LBL_EMAIL_SETTINGS' => 'Configuración',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 Filas',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 columnas',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'Estilo de Presentación',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'Cuentas de Correo',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Limpiar Formulario',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'Importar Correo después de la Visualización',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Comprobar Correo Nuevo',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Usar Panel de Previsualización',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Usar Ventana Emergente',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'Número de emails por página',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'Editar Cuenta de Correo',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'Carpetas',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'Dirección de Remitente',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'Dirección para Notificación de Prueba:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'Dirección del Destinatario',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'Nombre de Remitente',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Dirección de Responder a',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Pantalla Completa',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Sincronizar Todas las Cuentas de Correo',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'Se ha enviado un email a la dirección utilizando la configuración de correo saliente proporcionada. Compruebe si ha recibido el email para verificar que la configuración es correcta.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Esta acción sincronizará las cuentas de correo y su contenido.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => '¿Desea realizar una sincronización completa?\nPara cuentas de correo grandes, puede tardar varios minutos.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Haga clic en la Tecla Mayús o en la tecla Ctrl para seleccionar varias carpetas.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'General',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Carpetas de Grupo Disponibles',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Crear Carpetas de Grupo',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Guardando Carpetas de Grupo',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Recuperando Carpetas de Grupo',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Editar Carpetas de Grupo',

    'LBL_EMAIL_SETTINGS_NAME' => 'Nombre de Cuenta de Correo',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Seleccione el número de emails por página en la Bandeja de Entrada. Tal vez sea necesario actualizar la página para que se aplique esta configuración.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'Recuperando Cuenta de Correo',
    'LBL_EMAIL_SETTINGS_RULES' => 'Reglas',
    'LBL_EMAIL_SETTINGS_SAVED' => 'La configuración se ha guardado.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'Debe volver a cargar la página para que la nueva configuración tenga efecto.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'Enviar Sólo Emails con Texto sin Formato',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Activas',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'Emails por Página',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'Poner Pestañas Abajo',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Configuración Visual',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Preferencias',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Mostrar Avanzado',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Carpetas de Usuario Disponibles',
    'LBL_EMAIL_ERROR_PREPEND' => 'Error:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'El servidor de correo saliente seleccionado para la cuenta de correo que está utilizando no es válido.  Compruebe la configuración o seleccione un servidor de correo distinto para la cuenta.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'No se ha configurado un servidor de correo saliente para el envío de correos. Configure o seleccione un servidor de correo saliente para la cuenta de correo que está utilizando en Configuración >> Cuenta de Correo.',
    'LBL_EMAIL_SHOW_READ' => 'Mostrar Todo',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Mostrar Sólo No leídos',
    'LBL_EMAIL_SIGNATURES' => 'Firmas',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'Nueva Firma',
    'LBL_EMAIL_SIGNATURE_NAME' => 'Nombre de la Firma',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'Cuerpo de la Firma',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Aplicaciones menos seguras de Google',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'Otro:',
    'LBL_EMAIL_AUTHORIZE' => 'Autorizar',
    'LBL_EMAIL_AUTHORIZED' => 'Autorizado',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'No autorizado',
    'LBL_EMAIL_AUTH_WARNING' => 'Un administrador debe configurar el Conector {0} desde Administración > Conectores antes de poder configurar esta cuenta. Para obtener más información, consulte la documentación de {1}.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'Error al recuperar la infomación del conector',
    'LBL_EMAIL_AUTH_FAILURE' => 'Fallo de autorización.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'Autorice la cuenta antes de guardar.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'Autorice la cuenta antes de probar.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'Cuenta no autorizada',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Carpetas Remotas ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Carpetas de Sugar ]',
    'LBL_EMAIL_SUBJECT' => 'Asunto',
    'LBL_EMAIL_SUCCESS' => 'Éxito',
    'LBL_EMAIL_SUGAR_FOLDER' => 'CarpetaDeSugar',
    'LBL_EMAIL_TEAMS' => 'Asignar a Equipos',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'El cuerpo de la plantilla de email está vacío',
    'LBL_EMAIL_TEMPLATES' => 'Plantillas',
    'LBL_EMAIL_TEXT_FIRST' => 'Página Primera',
    'LBL_EMAIL_TEXT_PREV' => 'Página Anterior',
    'LBL_EMAIL_TEXT_NEXT' => 'Página Siguiente',
    'LBL_EMAIL_TEXT_LAST' => 'Última Página',
    'LBL_EMAIL_TEXT_REFRESH' => 'Actualizar',
    'LBL_EMAIL_TO' => 'Para',
    'LBL_EMAIL_TOGGLE_LIST' => 'Cambiar Lista',
    'LBL_EMAIL_VIEW' => 'Ver',
    'LBL_EMAIL_VIEWS' => 'Vistas',
    'LBL_EMAIL_VIEW_HEADERS' => 'Mostrar Cabeceras',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'Versión Imprimible',
    'LBL_EMAIL_VIEW_RAW' => 'Mostrar Email Sin Procesar',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'Esta característica no es compatible cuando se usa con POP3.',
    'LBL_DEFAULT_LINK_TEXT' => 'Texto de enlace por defecto.',
    'LBL_EMAIL_YES' => 'Sí',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Enviar Email de Prueba',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Email de Prueba Enviado',


    'LBL_EMAIL_MESSAGE_NO' => 'Mensaje Nº',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'Importación Correcta',
    'LBL_EMAIL_IMPORT_FAIL' => 'Importación Fallida debido a que el mensaje ya ha sido importado o eliminado del servidor',

    'LBL_EMAILS_FROM' => 'Correos electrónicos enviados',
    'LBL_EMAILS_RECEIVED' => 'Correos electrónicos recibidos',
    'LBL_EMAIL_ADDRESSES_USED' => 'Direcciones de correo electrónico utilizadas en los correos electrónicos',
    'LBL_EMAIL_ADDRESS' => 'Dirección de correo electrónico',
    'LBL_FROM' => 'De',
    'LBL_TO' => 'Para',
    'LBL_CC' => 'CC',
    'LBL_BCC' => 'CCO',

    'LBL_START_DATE' => 'Fecha de inicio',
    'LBL_END_DATE' => 'Fecha de finalización',
    'LBL_START' => 'Inicio',
    'LBL_END' => 'Fin',
    'LBL_DATE_LINKED' => 'Fecha de vinculación',

    'LBL_LINK_NONE' => 'Ninguna',
    'LBL_LINK_ALL' => 'Todos',
    'LBL_LINK_RECORDS' => 'Registros',
    'LBL_LINK_SELECT' => 'Seleccionar',
    'LBL_LINK_ACTIONS' => 'Acciones',
    'LBL_LINK_MORE' => 'Más',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'Confirmar',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => '¿Desea cerrar este #module#?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'No mostrar este mensaje en el futuro: &nbsp;',
    'LBL_INVALID_FILE_EXTENSION' => 'Extensión de archivo no válida',
    'LBL_LIST_TEAM' => 'Equipo',
    'LBL_TEAM' => 'Equipo:',
    'LBL_TEAMS' => 'Equipos',
    'LBL_TEAM_SET_ID' => 'ID Conjunto de Equipo',
    'LBL_TEAM_SET_SELECTED_ID' => 'ID asignada al equipo seleccionado',
    'LBL_TEAM_SET_SELECTED' => 'Seleccionado',
    'LBL_TEAM_SET_ENABLE' => 'Habilitar permisos adicionales',
    'LBL_TEAM_SET_DISABLE' => 'Deshabilitar permisos adicionales',
    'LBL_TEAM_SET' => 'Conjunto de Equipo',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'Equipos seleccionados',
    'LBL_SEARCH_UNAVAILABLE' => 'La búsqueda no está disponible, inténtelo de nuevo más tarde.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'No se ha especificado un Equipo Principal',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'Error al intentar quitar el identificador principal del equipo [{0}] del módulo [{1}] con el id [{2}]',
    'LBL_TEAM_ADD' => 'Añadir&nbsp;Equipo',
    'LBL_TEAM_REMOVE' => 'Eliminar Equipo',
    'LBL_TEAM_PRIMARY' => 'Establecer como Equipo Principal',

    'LBL_CLOSE_BUTTON_LABEL' => 'Cerrar',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} marcado como {{status}}.',

    'LBL_FOCUS' => 'Enfoque',

    'LBL_QUERY_VALID' => 'Válida',
    'LBL_QUERY_ERROR' => 'Error.',
    'LBL_QUERY_CHILD' => 'Subconsulta válida',
    'ERROR_EXAMINE_MSG' => '  Examine el siguiente mensaje de error:',
    'NO_QUERY_SELECTED' => 'El formato de datos que ha seleccionado no contiene una consulta.  Seleccione una consulta personalizada para este formato de datos.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'Se ha producido un error:',
    'ERR_AJAX_LOAD_FAILURE' => 'Se ha producido un error al procesar su petición, inténtelo de nuevo más tarde.',
    'ERR_AJAX_LOAD_FOOTER' => 'Si el error continúa, solicite al administrador que deshabilite Ajax para este módulo',
    'ERR_CREATING_FIELDS' => 'Error al rellenar los campos adicionales de detalle:',
    'ERR_CREATING_TABLE' => 'Error al crear la tabla:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'No puede utilizarse el mismo carácter como separador decimal que el utilizado como separador de miles. Cambie los valores.',
    'ERR_DELETE_RECORD' => 'Debe especificar un número de registro para eliminar el contacto.',
    'ERR_EXPORT_DISABLED' => 'Exportación deshabilitada.',
    'ERR_EXPORT_TYPE' => 'Error al exportar ',
    'ERR_REPORTS_DISABLED_EXPORT' => 'La exportación de informes está deshabilitada',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'Solo los usuarios administradores pueden exportar',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'El informe utiliza módulos sin acceso de exportación',
    'ERR_REPORTS_EXPORT_OWNER' => 'El informe utiliza módulos con acceso a la exportación del propietario',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'El informe utiliza módulos con acceso restringido a las listas',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'El informe utiliza módulos con acceso restringido a las vistas',
    'ERR_REPORTS_ACCESS_DISABLED' => 'El informe utiliza módulos con acceso restringido',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'El informe utiliza campos con acceso restringido',
    'ERR_INVALID_AMOUNT' => 'Introduzca una cantidad válida.',
    'ERR_INVALID_DATE_FORMAT' => 'El formato de fecha debe ser:',
    'ERR_INVALID_DATE' => 'Introduzca una fecha válida.',
    'ERR_INVALID_DAY' => 'Introduzca un día válido.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'no es una dirección de email válida.',
    'ERR_INVALID_FILE_REFERENCE' => 'Referencia a archivo no válida',
    'ERR_INVALID_HOUR' => 'Introduzca una hora válida.',
    'ERR_INVALID_MONTH' => 'Introduzca un mes válido.',
    'ERR_INVALID_TIME' => 'Introduzca una hora válida.',
    'ERR_INVALID_YEAR' => 'Introduzca un año válido de 4 dígitos.',
    'ERR_NEED_ACTIVE_SESSION' => 'Debe tener una sesión activa para exportar el contenido.',
    'ERR_NO_HEADER_ID' => 'Esta funcionalidad no está disponible con este tema.',
    'ERR_NOT_ADMIN' => 'Acceso no autorizado a la administración.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'La Gestión de Contraseñas solo está disponible en <a href="%s" target="_blank">Ajustes de SugarCloud</a>.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'Contacte con su administrador de Sugar si quiere realizar cambios en los campos de solo lectura.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'Acceda a <a href="{0}" target="_blank">Ajustes de SugarCloud</a> para hacer cambios a los campos de solo lectura.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'Falta campo requerido:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'Campo requerido no válido:',
    'ERR_INVALID_VALUE' => 'Valor no válido:',
    'ERR_NO_SUCH_FILE' => 'El archivo no existe en el sistema',
    'ERR_NO_SINGLE_QUOTE' => 'No podemos utilizar las comillas simples para',
    'ERR_NOTHING_SELECTED' => 'Realice una selección antes de proceder.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'Ya existe una oportunidad con el nombre %s.  Introduzca otro nombre a continuación.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'No ha introducido un nombre para la oportunidad.  Introduzca un nombre para la oportunidad a continuación.',
    'ERR_QUOTE_CONVERTED' => 'La oferta ya ha sido convertida en Oportunidad.',
    'ERR_POTENTIAL_SEGFAULT' => 'Se ha detectado un posible error de segmentación de Apache.  Avise a su administrador del sistema para que confirme este problema e informe a SugarCRM.',
    'ERR_SELF_REPORTING' => 'Un usuario no puede informar acerca de sí mismo.',
    'ERR_SINGLE_QUOTE' => 'La comilla simple no es compatible en este campo. Cambie el valor.',
    'ERR_SQS_NO_MATCH_FIELD' => 'No se han encontrado coincidencias para el campo:',
    'ERR_SQS_NO_MATCH' => 'Sin coincidencias',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Especifique el índice "clave" en el atributo displayParams para la definición de Meta-Datos',
    'ERR_EXISTING_PORTAL_USERNAME' => 'Error: El Nombre del Portal ya se ha asignado a otro contacto.',
    'ERR_PORTAL_NAME_CHECK' => 'No es posible verificar si el nombre usuario del Portal es único',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'El valor del campo no es compatible con el valor de precisión',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'Se produjo un error al tratar de guardar en la cuenta externa.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'Se produjo un error durante la carga. Asegúrese de que el archivo que está cargando no está vacío.',
    'ERR_NO_DB' => 'No se ha podido realizar una conexión a la base de datos. Consulte sugarcrm.log para obtener más detalles.',
    'ERR_DB_FAIL' => 'Error de base de datos. Consulte sugarcrm.log para más detalles.',
    'ERR_EXTERNAL_API_403' => 'Permiso denegado. El tipo de archivo no es compatible.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'Falta el Tóken de Acceso OAuth.',
    'ERR_DB_VERSION' => 'Los archivos de Sugar CRM {0} solo se pueden utilizar con una base de datos de Sugar CRM {1}.',
    'ERR_DB_QUERY' => '{0}: consulta fallida: {1}',
    'ERR_UW_RETIRED' => 'El Asistente de Actualización no está disponible en esta versión.',
    'ERR_NOT_CLOUD_INSTANCE' => 'Esta instancia de Sugar no es una instancia de SugarCloud ni está configurada para SugarCloud Insights.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'No está autorizado para crear {moduleName}. Contacte con su administrador si necesita acceso.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'El Usuario Actual no está autorizado para cambiar ajustes de configuración en {moduleName}',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'El Usuario Actual no está autorizado para cambiar ajustes de configuración en {moduleName}',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'No está autorizado a marcar {moduleName} como favorito. Contacte al administrador si necesita acceso.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'No está autorizado a suscribirse a {moduleName}. Contacte al administrador si necesita acceso.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'worksheet_columns_related_fields no se ha encontrado en related_fields array',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'worksheet_columns no es una matriz',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'summary_columns_related_fields no se ha encontrado en la carga',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows no es una matriz',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rows_related_fields no se ha encontrado en la carga',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'Su solicitud ha fallado debido a una excepción desconocida.',
    'EXCEPTION_FATAL_ERROR' => 'Su solicitud no pudo completarse. Ha ocurrido un error grave. Compruebe los registros de errores para más detalles.',
    'EXCEPTION_NEED_LOGIN' => 'Tiene que estar autenticado para realizar esta acción.',
    'EXCEPTION_INVALID_TOKEN' => 'El token de autenticación no es válido.',
    'EXCEPTION_NOT_AUTHORIZED' => 'No está autorizado para realizar esta acción. Póngase en contacto con su administrador si necesita acceso.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'No está autorizado para visualizar datos. Contacte con su administrador si necesita acceso.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'No puede acceder al Portal debido a que su cuenta no está activa. Póngase en contacto con atención al cliente si necesita acceso.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'El Portal no está configurado de forma correcta. Póngase en contacto con su Administrador del Portal para obtener ayuda.',
    'EXCEPTION_NO_METHOD' => 'Su petición no es compatible. No se pudo encontrar el método HTTP de su solicitud para esta ruta.',
    'EXCEPTION_NOT_FOUND' => 'El recurso solicitado no se ha encontrado. No se ha podido encontrar un controlador para la ruta especificada en la solicitud.',
    'EXCEPTION_MISSING_PARAMTER' => 'Falta un parámetro requerido en su petición.',
    'EXCEPTION_INVALID_PARAMETER' => 'Un parámetro no es válido en su petición.',
    'EXCEPTION_REQUEST_FAILURE' => 'Su petición no pudo completarse.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'Los metadatos o el hash de usuario no coinciden con el servidor. Vuelva a sincronizar los metadatos.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'Su solicitud es demasiado grande para ser procesada.',
    'EXCEPTION_EDIT_CONFLICT' => 'Error de edición, vuelva a cargar los datos del registro.',
    'EXCEPTION_METADATA_CONFLICT' => 'Error en los metadatos, vuelva a cargarlos.',
    'EXCEPTION_CLIENT_OUTDATED' => 'El software ha expirado, actualice el cliente antes de intentar conectar de nuevo.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'Un conector o una petición de integración han resultado en una respuesta errónea.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM está en modo de mantenimiento. Sólo el perfil Administrador puede iniciar sesión. Contacte al administrador para obtener más detalles.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'El servidor no puede procesar la solicitud porque está ocupado o no disponible en este momento.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'El motor de búsqueda no está disponible temporalmente.',
    'EXCEPTION_SEARCH_RUNTIME' => 'Se ha producido un error en el tiempo de ejecución del motor de búsqueda. Póngase en contacto con el administrador del sistema.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'Un campo bloqueado por un proceso no puede editarse.',
    'EXCEPTION_MODULE_DISABLED' => 'Este módulo está inhabilitado para el usuario actual.',
    'EXCEPTION_FIELD_DISABLED' => 'Este campo está inhabilitado para el usuario actual.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'Este cliente no está permitido',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'La capacidad de cargar paquetes no está disponible para su tipo de licencia',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'Se ha encontrado una condición por un fallo general o error. Las razones de esta excepción varían, pero en general no entran en el ámbito de una excepción específica de la API.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'La solicitud no se ha podido procesar o se ha producido un error en la respuesta. Esto generalmente significa que se ha producido un error grave y la avería específica se puede identificar en el registro de aplicación.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'La versión de la API que está utilizando no es la correcta para la solicitud actual.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'El criterio de valoración solicitado requiere autenticación y el usuario solicitado aún no está autenticado.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'Indica que el token de identificación mostrado con la solicitud no es válido. Suele pasar debido que el token ha vencido pero también porque es incorrecto.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'Indica que el usuario solicitado no está autorizado para realizar la acción solicitada.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'La cuenta de portal asociada con el usuario conectado no está actualmente activa. Esto requiere una acción por parte del servicio de atención al cliente o del servicio de asistencia.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'Indica que la aplicación del portal no está configurada correctamente y no se puede usar. Esto requiere una acción por parte del administrador.',
    'EXCEPTION_NO_METHOD_DESC' => 'El punto final no es compatible con el tipo de solicitud HTTP realizada. Esto puede ocurrir cuando una petición de POST se realiza para un punto final diseñado para una petición GET, por ejemplo.',
    'EXCEPTION_NOT_FOUND_DESC' => 'El punto final no ha podido localizar un recurso para la solicitud o no tiene un operario para la misma.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'Indica tal vez había ediciones simultáneas de un registro y la solicitud para editar este registro podría afectar la edición anterior del registro.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'Indica que los metadatos en el servidor no coinciden con los metadatos el cliente está utilizando actualmente. Esto puede ocurrir después de un cambio en la configuración del sistema, cambios en módulos en Studio o la implementación de nuevos módulos, entre otros cambios sistemáticos.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'La petición es demasiado grande para ser gestionada por el servidor',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'Indica que el parámetro requerido en la solicitud no se encuentra.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'Indica que el parámetro enviado en la solicitud no es válido',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'La petición no se pudo completar.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'Indica que el cliente que está consumiendo el API está caducado y debería actualizarse antes de consumir el API.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'Indica que se ha producido un error en una petición realizada a través de API a otro servicio, punto final o URI o que el servidor no la ha podido procesar.',
    'EXCEPTION_MAINTENANCE_DESC' => 'La instancia de SugarCRM que cumple la API está en modo de mantenimiento. Acceso a la API está restringido a administradores solamente.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'Indica que el servidor está ocupado, sobrecargado o fuera de servicio.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'El motor de búsquedas interno actualmente no está disponible debido a un problema de conexión. Verifique la conectividad y la configuración en Admin-> búsqueda-> prueba.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'Se produjo una excepción de tiempo de ejecución en el Motor de búsqueda. Ver sugarcrm.log para más detalles.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'Un campo actualmente bloqueado por un proceso en ejecución no puede editarse.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s está bloqueado por un proceso en ejecución y no puede editarse.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s están bloqueados por un proceso en ejecución y no pueden editarse.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'Este módulo está inhabilitado para el usuario actual.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'Este campo está inhabilitado para el usuario actual.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'Este cliente no está permitido',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'Un archivo con el mismo nombre ya existe en el sistema.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'Error de Periodo de Tiempo no definido para la fecha {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'Este Periodo de Tiempo tiene sub-periodos.',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'Sub-Periodos de Tiempo no pueden contener sub-periodos.',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'Imposible recuperar cualquier periodo de tipo: {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'No existen períodos de tiempo activos para la configuración actual.',
    'LBL_CURRENT_TIMEPERIOD' => 'Periodo de Tiempo Actual',
    'LBL_PREVIOUS_TIMEPERIOD' => 'Periodo de Tiempo Anterior',
    'LBL_NEXT_TIMEPERIOD' => 'Próximo Periodo de Tiempo',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'Anterior,Actual,Próximo',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'No puede eliminar registros con una fase de venta cerrada.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'No puede eliminar registros con un estado de venta cerrado.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'Uno o más registros seleccionados tiene la fase de venta Ganado o Perdido y no se puede eliminar.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'Uno o más registros seleccionados tiene el estado de Ganado o Perdido y no se puede eliminar.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'Cuenta',
    'LBL_OLD_ACCOUNT_LINK' => 'Cuenta Antigua',
    'LBL_ACCOUNTS' => 'Cuentas',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Actividades',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Ver Resumen',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Ver Resumen [Alt+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Agregar',
    'LBL_ADD_BUTTON' => 'Agregar',
    'LBL_ADD_DASHLET_BUTTON' => 'Añadir Dashlet',
    'LBL_ADD_DOCUMENT' => 'Agregar Documento',
    'LBL_REPLACE_BUTTON' => 'Reemplazar',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Añadir a la Lista de Público Objetivo',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Añadir a la Lista de Público Objetivo',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Clic para Cerrar',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Cerrar',
    'LBL_ADDITIONAL_DETAILS' => 'Detalles Adicionales',
    'LBL_ADMIN' => 'Admin',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'Archivo',
    'LBL_ASSIGNED_TO_USER' => 'Asignado a Usuario',
    'LBL_ASSIGNED_TO' => 'Asignado a:',
    'LBL_BACK' => 'Atrás',
    'LBL_BASE_RATE' => 'Tasa de Referencia',
    'LBL_BILL_TO_ACCOUNT' => 'Cargar en Cuenta',
    'LBL_BILL_TO_CONTACT' => 'Cargar a Contacto',
    'LBL_BILLING_ADDRESS' => 'Dirección de Facturación',
    'LBL_QUICK_CREATE_TITLE' => 'Creación rápida',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'Incidencias',
    'LBL_BY' => 'por',
    'LBL_CALLS' => 'Llamadas',
    'LBL_CALL' => 'Llamada',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Enviar Emails de Campaña en la Cola',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Enviar',
    'LBL_CASE' => 'Caso',
    'LBL_CASES' => 'Casos',
    'LBL_MESSAGE' => 'Mensaje',
    'LBL_MESSAGES' => 'Mensajes',
    'LBL_ESCALATIONS' => 'Escaladas',
    'LBL_ESCALATION' => 'Escalada',
    'LBL_DOCUSIGN_ENVELOPES' => 'Sobres de DocuSign',
    'LBL_DOCUSIGN_ENVELOPE' => 'Sobre de DocuSign',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'Seleccionar destinatarios del firmante',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'Cambiar contraseña',
    'LBL_CHANGE_BUTTON_LABEL' => 'Cambiar',
    'LBL_CHANGE_BUTTON_TITLE' => 'Cambiar [Alt+G]',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Marcar Todos',
    'LBL_CITY' => 'Ciudad',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Borrar',
    'LBL_CLEAR_BUTTON_TITLE' => 'Borrar',
    'LBL_CLEARALL' => 'Desmarcar Todos',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => 'Cerrar',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'Cerrar Ventana',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Cerrar Todo',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Cerrar Todo [Alt+I]',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Cerrar y Crear Nuevo',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Cerrar y Crear Nuevo',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'Copiar URL del registro',
    'LBL_OPEN_ITEMS' => 'Abrir elementos:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Redactar Correo',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'Correo electrónico',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Redactar Correo [Alt+L]',
    'LBL_SEARCH_DROPDOWN_YES' => 'Sí',
    'LBL_SEARCH_DROPDOWN_NO' => 'No',
    'LBL_CONTACT_LIST' => 'Lista de Contactos',
    'LBL_CONTACT' => 'Contacto',
    'LBL_CONTACTS' => 'Contactos',
    'LBL_CONTRACTS' => 'Contratos',
    'LBL_COUNTRY' => 'País:',
    'LBL_RESET_BUTTON_LABEL' => 'Restablecer',
    'LBL_CREATE_BUTTON_LABEL' => 'Crear',
    'LBL_CREATED_BY_USER' => 'Creado por Usuario',
    'LBL_CREATED_USER' => 'Creado por Usuario',
    'LBL_CREATED_ID' => 'Creado por Id',
    'LBL_CREATED' => 'Creado por',
    'LBL_CREATE_NEW_TARGET_LIST' => 'Crear nueva lista de destino',
    'LBL_CURRENT_USER_FILTER' => 'Mis Elementos:',
    'LBL_CURRENCY' => 'Moneda:',
    'LBL_CURRENCIES' => 'Monedas',
    'LBL_CURRENCY_NAME' => 'Nombre de Moneda',
    'LBL_CURRENCY_SYMBOL' => 'Símbolo de Moneda',
    'LBL_CURRENCY_RATE' => 'Tipo de Cambio:',
    'LBL_CURRENCY_ID' => 'ID Moneda',
    'LBL_DOCUMENTS' => 'Documentos',
    'LBL_DATE_ENTERED' => 'Fecha de Creación:',
    'LBL_DATE_MODIFIED' => 'Fecha de Modificación:',
    'LBL_ACTIVITY_MODIFIED' => 'Modificado',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'Editar pestaña de resumen',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'Editar pestañas de módulos',
    'LBL_EDIT_BUTTON' => 'Editar',
    'LBL_DUPLICATE_BUTTON' => 'Duplicar',
    'LBL_DELETE_BUTTON' => 'Eliminar',
    'LBL_DELETE' => 'Eliminar',
    'LBL_DELETED' => 'Eliminado',
    'LBL_DIRECT_REPORTS' => 'Informes Directos',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Hecho',
    'LBL_DONE_BUTTON_TITLE' => 'Hecho [Alt+X]',
    'LBL_DST_NEEDS_FIXIN' => 'La aplicación requiere que se aplique una reparación de Horario de Verano.  Vaya al vínculo <a href="index.php?module=Administration&action=DstFix">Reparar</a> en la consola de Administración y aplique la reparación de Horario de Verano.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Editar Como Nuevo',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Editar Como Nuevo',
    'LBL_EDIT_IN_NEW_TAB' => 'Editar en pestaña nueva',
    'LBL_FAVORITES' => 'Favoritos',
    'LBL_FILTER' => 'Filtro',
    'LBL_DEFAULT_DATA_FILTER' => 'Filtro de datos por defecto',
    'LBL_FILTER_MENU_BY' => 'Filtrar menú por',
    'LBL_FILTER_SELECT_FIELD' => 'Seleccionar campo...',
    'LBL_FILTER_SELECT_OPERATOR' => 'Seleccionar operador...',
    'LBL_FILTER_CREATE_NEW' => 'Crear filtro',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'Crear un filtro (sin guardar)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(Sin guardar)',
    'LBL_FILTER_CREATE_FILTER' => 'Crear un nuevo filtro',
    'LBL_FILTER_CLOSE_FILTER' => 'Cerrar filtro',
    'LBL_FILTER_EDIT_FILTER' => 'Editar filtro',
    'LBL_FILTER_ALL_RECORDS' => 'Todos los Registros',
    'TPL_FILTER_SAVE' => 'Ha creado el filtro {{name}} correctamente.',
    'LBL_FILTER_BETWEEN_FROM' => 'Desde',
    'LBL_FILTER_BETWEEN_TO' => 'A',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'Fecha de Inicio',
    'LBL_FILTER_DATEBETWEEN_TO' => 'Fecha de Finalización',
    'LBL_FOLLOWING' => 'Siguiendo',
    'LBL_UNFOLLOW' => 'Dejar de seguir',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'Descargar vCard',
    'LBL_EMPTY_VCARD' => 'Seleccione un archivo vCard',
    'LBL_IMAGE' => 'Imagen',
    'LBL_EMPTY_REQUIRED_VCARD' => 'La vCard no tiene todos los campos requeridos para este módulo.',
    'LBL_VCARD_ERROR_FILESIZE' => 'El archivo subido excede el límite de tamaño de 30.000 bytes que se especificó en el formulario HTML.',
    'LBL_VCARD_ERROR_DEFAULT' => 'Ocurrió un error al cargar el archivo vCard',
    'TPL_IMPORT_VCARD_FAILURE' => 'Fallo al crear {{module}} desde vCard',
    'LBL_IMPORT_VCARD' => 'Importar vCard:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'Importar vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'Importar vCard [Alt+I]',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'Ver',
    'LBL_VIEW_BUTTON_TITLE' => 'Ver [Alt+V]',
    'LBL_VIEW_BUTTON' => 'Ver',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'Enviar como PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'Enviar como PDF [Alt+M]',
    'LBL_EMAIL' => 'Correo electrónico',
    'LBL_EMAILS' => 'Correos electrónicos',
    'LBL_EMPLOYEES' => 'Empleados',
    'LBL_ENTER_DATE' => 'Introducir Fecha',
    'LBL_EXPORT_ALL' => 'Exportar Todo',
    'LBL_EXPORT' => 'Exportar',
    'LBL_FAVORITES_FILTER' => 'Mis Favoritos:',
    'LBL_GLOBAL_SEARCH' => 'Búsqueda Global',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'Filtro del Módulo de Búsqueda Global',
    'LBL_GLOBAL_SEARCH_RUN' => 'Ejecutar Búsqueda Global',
    'LBL_GO_BUTTON_LABEL' => 'Ir',
    'LBL_GS_HELP' => 'Los campos de este módulo utilizados en esta búsqueda aparecen más arriba. El texto resaltado coincide con los criterios de búsqueda.',
    'LBL_HIDE' => 'Ocultar',
    'LBL_ID' => 'Id.',
    'LBL_IMPORT' => 'Importar',
    'LBL_IMPORT_STARTED' => 'Importación iniciada:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Debe especificar un delimitador particular.',
    'LBL_LAST_VIEWED' => 'Recientes',
    'LBL_SELECTED_RECORDS' => 'Seleccionado: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'Mostrar menos',
    'LBL_SHOW_MORE' => 'Mostrar más',
    'LBL_SHOW_MORE_MODULE' => 'Más {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'Más recientes...',
    'LBL_SHOW_LESS_RECENTS' => 'Menos recientes...',
    'LBL_SHOW_MORE_RESULTS' => 'Más resultados de búsqueda...',
    'TPL_SHOW_MORE_MODULE' => 'Más {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => 'Más {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => 'Actividades de Hoy',
    'LBL_LEADS' => 'Clientes Potenciales',
    'LBL_LEAD' => 'Cliente Potencial',
    'LBL_QUOTES_BILL_TO' => 'Presupuestos (Factura a)',
    'LBL_LESS' => 'menos',
    'LBL_CAMPAIGN' => 'Campaña:',
    'LBL_CAMPAIGNS' => 'Campañas',
    'LBL_CAMPAIGNLOG' => 'LogDeCampaña',
    'LBL_CAMPAIGN_CONTACT' => 'Campañas',
    'LBL_CAMPAIGN_ID' => 'campaña_id',
    'LBL_THEME' => 'Tema:',
    'LBL_THEME_PICKER' => 'Estilo de Página',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Aviso: Internet Explorer 6 no es compatible con el tema seleccionado. Haga clic en Aceptar para seleccionarlo de todas maneras o Cancelar para seleccionar otro tema.',
    'LBL_FOUND_IN_RELEASE' => 'Encontrado en Versión',
    'LBL_FIXED_IN_RELEASE' => 'Corregido en Versión',
    'LBL_LIST_ACCOUNT_NAME' => 'Nombre Cuenta',
    'LBL_LIST_ASSIGNED_USER' => 'Usuario',
    'LBL_LIST_CONTACT_NAME' => 'Nombre Contacto',
    'LBL_LIST_CONTACT_ROLE' => 'Rol de Contacto',
    'LBL_LIST_DATE_ENTERED' => 'Fecha de Creación',
    'LBL_LIST_EMAIL' => 'Correo electrónico',
    'LBL_LIST_NAME' => 'Nombre',
    'LBL_LIST_OF' => 'de',
    'LBL_LIST_PHONE' => 'Teléfono',
    'LBL_LIST_RELATED_TO' => 'Relacionado con',
    'LBL_LIST_USER_NAME' => 'Nombre de usuario',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => '¿Está seguro de que desea actualizar la lista entera?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Seleccione al menos 1 registro para proceder.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Seleccione al menos 2 registros para proceder.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Seleccione menos de 10 registros para proceder.',
    'LBL_LISTVIEW_ALL' => 'Todo',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'Congelar columna 1',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'Todos los duplicados',
    'LBL_LISTVIEW_NONE' => 'Anular la selección de todos',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Seleccionar Página Actual',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Seleccionar Todo',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Registros Seleccionados',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Seleccionado: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'Borrar todas las selecciones.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'Seleccionar todos los registros',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'Hay más de {{num}} registros en este conjunto de resultados. Ha seleccionado los primeros {{num}} registros.',
    'TPL_LISTVIEW_SELECTED' => 'Ha seleccionado {{num}} registros mostrados en este conjunto de resultados.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'Ha seleccionado 1 registro del conjunto de resultados.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'Ha seleccionado los {{num}} registros mostrados en este conjunto de resultados.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'Ha seleccionado todos los {{num}} registros en esta vista. {{link}} en el conjunto de resultados.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'Actualizando {{num}} de {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(tiempo de espera {{time}} {{unit}})',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'Error en la Actualización Masiva. Comenzando nuevo intento ({{num}} de {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'Actualización Masiva Incompleta. {{num}} registro(s) siguen sin modificar.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'Actualización Masiva Incompleta. {{num}} registro(s) siguen sin modificar.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} registros(s) han sido ignorados debido a permisos o errores.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} registros(s) han sido actualizados correctamente.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} Actualización Masiva',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'Eliminando {{num}} de {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(about {{time}} {{unit}} left)',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'Error en la Eliminación Masiva. Comenzand un nuevo intento ({{num}} de {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'Eliminación Masiva incompleta. {{num}} registros(s) pendientes.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'Eliminación Masiva incompleta. {{num}} registros(s) pendientes.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} registros(s) han sido eliminados correctamente.',
    'TPL_MASSDELETE_TITLE' => '{{module}} Eliminación Masiva',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'Añadiendo {{num}} de {{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(tiempo de espera {{time}} {{unit}})',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'Error en la Agregación Masiva a la Lista Objetivo. Comenzando un nuevo intento ({{num}} de {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'Adición Masiva a la Lista Objetivo incompleta. {{num}} registros pendientes.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'Adición Masiva a la Lista Objetivo incompleta. {{num}} registros pendientes.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} registros añadidos correctamente.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} Adición Masiva a la Lista Objetivo',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'Vincular {{num}} de {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(tiempo de espera {{time}} {{unit}})',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'Vinculación masiva fallida. Iniciando un nuevo intento ({{num}} de {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'Vinculación masiva incompleta. {{num}} registros no han sido añadidos.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'Vinculación masiva incompleta. {{num}} registros no han sido añadidos.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} registros han sido vinculados con éxito.',
    'TPL_MASSLINK_TITLE' => '{{module}} Vinculación masiva',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'Seleccionar',
    'LBL_LISTVIEW_ACTIONS' => 'Acciones',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'Seleccionar todos los registros de esta página',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'Elimine la selección de todos los registros de esta página',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} de {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '{{num}} de Cargando...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'Haga clic para ver el total',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'de',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'Obtener el número de páginas',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'Juan',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Pérez',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Sr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Mago del Código Fuente',
    'LBL_LOGIN_TO_ACCESS' => 'Inicie la sesión para acceder a este área.',
    'LBL_LOGOUT' => 'Salir',
    'LBL_FINISH_IMPERSONATING' => 'Terminar la suplantación',
    'LBL_RESET_MFA' => 'Restablecer autenticación multifactor',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, actualmente se está haciendo pasar por {{user}}.',
    'LBL_PROFILE' => 'Perfil',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'Combinar Correspondencia',
    'LBL_MASS_UPDATE' => 'Actualización Masiva',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'Seleccione todos los registros para realizar una actualización masiva',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'Incluya el registro en la actualización masiva',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'Agregar Campo',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'Eliminar Campo',
    'LBL_GENERATE_QUOTE' => 'Crear Presupuesto',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'No hay campos disponibles para la operación de actualización masiva.',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'La petición para la actualización masiva se ha programado.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'La fecha de inicio del servicio es posterior a la fecha de fin del servicio',
    'LBL_MASS_UPDATE_SUCCESS' => 'Todos los registros se han actualizado correctamente.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'Los registros seleccionados se han añadido a la lista objetivo <a href="{{listUrl}}">{{listName}}</a>.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'La petición para añadir los registros seleccionados a la lista objetivo <a href="{{listUrl}}">{{listName}}</a> se ha planificado.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'La actualización eliminará los siguientes valores: ',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'Cancelar para conservar los valores existentes serán. Confirmar para quitar los valores.',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'Rehusar para Email Principal',
    'LBL_MEETINGS' => 'Reuniones',
    'LBL_MEETING' => 'Reunión',
    'LBL_MEETING_GO_BACK' => 'Volver a la reunión',
    'LBL_MEMBERS' => 'Miembros',
    'LBL_MEMBER_OF' => 'Miembro de',
    'LBL_MODIFIED_BY_USER' => 'Modificado por Usuario',
    'LBL_MODIFIED_USER' => 'Modificado por Usuario',
    'LBL_MODIFIED' => 'Modificado por',
    'LBL_MODIFIED_NAME' => 'Modificado por',
    'LBL_MODIFIED_ID' => 'Modificado por Id',
    'LBL_MORE' => 'Más',
    'LBL_MORE_MODULES' => 'Mas Módulos',
    'LBL_MORE_TABS' => 'Más pestañas',
    'LBL_MULTIPLE_MODULES' => 'Módulos múltiples',
    'LBL_COUNT_MODULES' => '{{count}} módulos',
    'LBL_MY_ACCOUNT' => 'Mi Configuración',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'sistema por defecto',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'usuario por defecto',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'cuenta de usuario',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'cuenta de grupo',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'Nombre',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Nuevo',
    'LBL_NEW_BUTTON_TITLE' => 'Nuevo [Alt+N]',
    'LBL_NEXT_BUTTON_LABEL' => 'Siguiente',
    'LBL_NOTES' => 'Notas',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Abrir Todo',
    'LBL_OPENALL_BUTTON_TITLE' => 'Abrir Todo [Alt+O]',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Abrir En:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Abrir En:',
    'LBL_OPEN_IN_NEW_TAB' => 'Abrir en pestaña nueva',
    'LBL_OPPORTUNITIES' => 'Oportunidades',
    'LBL_OPPORTUNITY_NAME' => 'Nombre de Oportunidad',
    'LBL_OPPORTUNITY' => 'Oportunidad',
    'LBL_OR' => 'O',
    'LBL_LOWER_OR' => 'o',
    'LBL_PANEL_ASSIGNMENT' => 'Otro',
    'LBL_PANEL_ADVANCED' => 'Más Información',
    'LBL_PANEL_BODY' => 'Resumen',
    'LBL_PARENT_TYPE' => 'Tipo Padre',
    'LBL_RELATED_TYPE' => 'Tipo relacionado',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'Fase',
    'LBL_PICTURE_FILE' => 'Foto',
    'LBL_POSTAL_CODE' => 'Código Postal:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'Ciudad de dirección principal:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'País de dirección principal:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'CP de dirección principal:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Estado/Provincia de dirección principal:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Calle de dirección principal 2',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Calle de dirección principal 3',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Calle de dirección principal:',
    'LBL_PRIMARY_ADDRESS' => 'Dirección principal:',

    'LBL_BILLING_STREET' => 'Calle:',
    'LBL_SHIPPING_STREET' => 'Calle:',

    'LBL_PRODUCT_BUNDLES' => 'Juegos de Productos',
    'LBL_PRODUCTS' => 'Productos',
    'LBL_PROJECT_TASKS' => 'Tareas de Proyecto',
    'LBL_PRODUCT_TEMPLATES' => 'Plantillas de Producto',
    'LBL_PROJECTS' => 'Proyectos',
    'LBL_PROSPECTS' => 'Público Objetivo',
    'LBL_QUICK_CREATE_MENU' => 'Menú de Creación Rápida',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Crear Oportunidad a partir de Presupuesto',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Crear Oportunidad a partir de Presupuesto [Alt+O]',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'Creando oportunidad...',
    'LBL_QUOTES_SHIP_TO' => 'Presupuestos enviados a',
    'LBL_QUOTES' => 'Presupuestos',

    'LBL_FORECAST_WORKSHEETS' => 'Hojas de Previsión',
    'LBL_FORECAST_WORKSHEET' => 'Hoja de Previsión',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'Invitar',
    'LBL_INVITED' => 'Invitado',
    'LBL_RECOMMENDED_INVITES' => 'Invitados Recomendados',
    'LBL_INSTANCES' => 'Instancias',
    'LBL_YOUR_INSTANCES' => 'Tus Instancias',
    'LBL_INSTANCE_USERS' => 'Usuarios de la Instancia',
    'LBL_SWITCH_INSTANCE' => 'Cambiar a esta instancia',
    'LBL_LAST_LOGIN' => 'última sesión',
    'LBL_ENTER_EMAIL' => 'Introduce el email del invitado...',
    'LBL_INSTANCE_IN_USE' => 'Instancia en Uso',
    'LBL_INSTANCE_ACTIVE' => 'Ya está utilizando esta instancia',
    'LBL_INSTANCE_INVITE_SENT' => 'Invitación enviada a',
    'LBL_INSTANCE_SWITCH_FAILED' => 'Error al cambiar de instancia',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'Recordatorios',
    'LBL_REMINDERS_OVERDUE' => 'Vencido',
    'LBL_REMINDERS_UPCOMING' => 'Próximamente',
    'LBL_REMINDERS_NONE_FOUND' => 'Ningún recordatorio encontrado.',
    'LBL_REMINDERS_FINISHED' => '¡Completado!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'Métricas de Oportunidad',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'Panel de configuración de Sweet Spot',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'Teclas de acceso rápido',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'Error al actualizar preferencias de configuración: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'Acción de Sweet Spot',
    'LBL_SWEETSPOT_KEY' => 'Palabra clave',
    'LBL_SWEETSPOT_REMOVE' => 'Eliminar acción',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'Teclas de acceso rápido',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'Acciones',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'Registros',
    'LBL_SWEETSPOT_THEME' => 'Tema',
    'LBL_SWEETSPOT_THEME_SELECT' => 'Seleccionar tema',

    'LBL_RELATED' => 'Relacionado',
    'LBL_RELATED_INFORMATION' => 'Información Relacionada',
    'LBL_RELATED_RECORDS' => '{{module}} relacionado',
    'LBL_REPORTS_TO' => 'Informa a',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'Indica que es un campo requerido',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Hecho',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Guardar Como',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Guardar Como [Alt+A]',
    'LBL_FULL_FORM_BUTTON_KEY' => 'F',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Formulario Completo',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Formulario Completo [Alt+F]',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Guardar y Crear Nuevo',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Guardar y Crear Nuevo [Alt+V]',
    'LBL_SAVE_OBJECT' => 'Guardar {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Buscar',
    'LBL_SEARCH_BUTTON_TITLE' => 'Buscar [Alt+Q]',
    'LBL_SEARCH' => 'Buscar',
    'LBL_SEARCH_TIPS' => 'Pulse el botón de búsqueda o haga clic en Enter para obtener una coincidencia exacta para ellos.',
    'LBL_SEARCH_TIPS_2' => 'Pulse el botón de búsqueda o haga clic en Enter para obtener una coincidencia exacta para',
    'LBL_SEARCH_MORE' => 'más',
    'LBL_SEE_ALL' => 'Ver Todo',
    'LBL_SEARCH_LOAD_MORE' => 'CARGAR MÁS',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Formato de archivo no válido, sólo es posible cargar archivos con imágenes.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'Formato de imagen {0} ya no es compatible.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Seleccionar',
    'LBL_SELECT_BUTTON_TITLE' => 'Seleccionar [Alt+T]',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'Añadir Equipo(s)',
    'LBL_SELECT_TEAMS_TITLE' => 'Añadir Equipo(s)',
    'LBL_SELECT_APPEND_TEAMS' => 'Adjuntar Equipo(s)',
    'LBL_SELECT_APPEND_VALUES' => 'Adjuntar valor(es)',
    'LBL_SELECT_APPEND_TAGS' => 'Añadir etiqueta(s)',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Explorar Documentos',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Explorar Documentos [Alt+B]',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Seleccionar Contacto',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Seleccionar Contacto [Alt+T]',
    'LBL_GRID_SELECTED_FILE' => 'archivo seleccionado',
    'LBL_GRID_SELECTED_FILES' => 'archivos seleccionados',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Seleccionar desde Informes',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Seleccionar Informes',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Seleccionar Usuario',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Seleccionar Usuario [Alt+U]',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Borrar selección',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Borrar selección',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Borrar selección',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Borrar selección',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Seleccionar archivo [Alt+F]',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Seleccionar archivo',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Borrar archivo',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Borrar archivo',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Seleccionar usuario [Alt+U]',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Seleccionar usuario',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Borrar usuario',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Borrar usuario',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Seleccionar cuenta [Alt+A]',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Seleccionar cuenta',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Borrar cuenta',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Borrar cuenta',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Seleccionar campaña',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Seleccionar campaña',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Borrar campaña',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Borrar campaña',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'Seleccionar contacto [Alt+C]',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'Seleccionar contacto',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Borrar contacto',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Borrar contacto',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Seleccionar equipo [Alt+Z]',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Seleccionar equipo',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Borrar equipo',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Borrar equipo',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Recursos usados para construir esta página (consultas, archivos)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'segundos.',
    'LBL_SERVER_RESPONSE_TIME' => 'Tiempo de respuesta del servidor:',
    'LBL_SERVER_MEMORY_BYTES' => 'bytes',
    'LBL_SERVER_MEMORY_USAGE' => 'Uso de la memoria del servidor: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Uso: - módulo: {0} - acción: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Uso de la memoria máxima del servidor: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'Enviar a Cuenta',
    'LBL_SHIP_TO_CONTACT' => 'Enviar a Contacto',
    'LBL_SHIPPING_ADDRESS' => 'Dirección de Envío',
    'LBL_SHORTCUTS' => 'Accesos directos',
    'LBL_SHOW' => 'Mostrar',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'Estado/Provincia:',
    'LBL_STATUS_UPDATED' => 'Su estado para este evento se ha actualizado.',
    'LBL_STATUS_NOT_UPDATED' => 'Su estado para este evento no se ha actualizado.',
    'LBL_STATUS' => 'Estado:',
    'LBL_STREET' => 'Calle',
    'LBL_SUBJECT' => 'Asunto',

    'LBL_INBOUNDEMAIL_ID' => 'ID de Email Entrante',
    'LBL_EAMP_ID' => 'ID del token de autenticación',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'Todos los derechos reservados.<br />SugarCRM, Sugar y el Cubo 3-D son marcas registradas de SugarCRM Inc. ' .
        'Todos los demás nombres de empresas y productos que se utilizan o aparecen en este producto pueden ser marcas registradas de las ' .
        'respectivas empresas a las que están asociados.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'Trabajo programado completado',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'El trabajo programado se ha ejecutado correctamente',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'Ahora se han habilitado Elementos de líneas de ingresos en Su instancia Sugar',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Las líneas de ingresos se han habilitado ahora en su instancia Sugar y todos los datos de las Oportunidades existentes se han procesado. Su instancia ya está lista para el uso con líneas de ingresos. Para obtener más información acerca de los cambios realizados consulte {{doc_url}}. 

Atentamente, SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'El Módulo de previsiones ya está listo para el uso con Oportunidades en Su instancia Sugar',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'El Módulo de previsiones de su instancia Sugar está disponible para el uso con oportunidades. Todos los datos anteriores de compromiso de previsión de líneas de ingresos se han eliminado y la instancia está lista para que se creen previsiones y se comprometan con oportunidades. Para obtener más información acerca de los cambios realizados consulte {{doc_url}}. Atentamente, SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Las líneas de ingresos ahora se han deshabilitado en su instancia Sugar',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Las líneas de ingresos ahora se han deshabilitado en su instancia Sugar y todos los datos existentes de líneas de ingresos se han procesado. Su instancia está lista ahora para el uso con Oportunidades. Para obtener más información acerca de los cambios realizados consulte {{doc_url}}. Atentamente, SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'Documentación de configuración de oportunidades',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'Iniciar Sesión',
    'LBL_LOGIN_WELCOME_TO' => 'Bienvenido a',
    'LBL_LOGIN_OPTIONS' => 'Opciones',
    'LBL_LOGIN_FORGOT_PASSWORD' => '¿Ha olvidado su contraseña?',
    'LBL_LOGIN_SUBMIT' => 'Enviar',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'Demasiados intentos fallidos de inicio de sesión.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'Puede intentar iniciar la sesión de nuevo en',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'días.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 'h.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'min.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'seg.',
    'LBL_LOGIN_ADMIN_CALL' => 'Póngase en contacto con el administrador del sistema.',
    'LBL_LOGIN_USERNAME' => 'Nombre de usuario',
    'LBL_LOGIN_PASSWORD' => 'Contraseña',
    'LBL_LOGGED_OUT' => 'Su sesión ha expirado.',
    'LBL_LOGIN_FORM_LABEL' => 'Mostrar formulario de registro',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'Volver al inicio de sesión',
    'LBL_LOGIN_INACTIVE_USER' => 'Usuario inactivo',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'El usuario del portal o grupo no puede iniciar sesión.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'Inicio',
    'LBL_SYNC' => 'Sincronizar',
    'LBL_TASKS' => 'Tareas',
    'LBL_TEAMS_LINK' => 'Equipos',
    'LBL_THEME_COLOR' => 'Color',
    'LBL_THEME_FONT' => 'Fuente',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'Programar Reunión',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'Programar Reunión',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'Archivar Correo',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'Archivar Correo [Alt+K]',
    'LBL_UNAUTH_ADMIN' => 'Acceso no autorizado a la administración',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Restaurar',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Restaurar [Alt+D]',
    'LBL_UNDELETE_BUTTON' => 'Restaurar',
    'LBL_UNDELETE' => 'Restaurar',
    'LBL_UNSYNC' => 'Desincronizar',
    'LBL_UPDATE' => 'Actualizar',
    'LBL_UPDATES' => 'Actualizaciones',
    'LBL_USER_LIST' => 'Lista de Usuarios',
    'LBL_USER_MENU' => 'Menú de Usuario',
    'LBL_USERS_SYNC' => 'Sincronización de Usuarios',
    'LBL_USERS' => 'Usuarios',
    'LBL_USER' => 'Usuario',
    'LBL_CURRENT_USER' => 'Usuario actual',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'Comprobando la entrada de email actual...',
    'LBL_VERIFY_PORTAL_NAME' => 'Comprobando el nombre de portal actual...',
    'LBL_VIEW_IMAGE' => 'ver',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'Imprimir como PDF',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'Imprimir como PDF [Alt+P]',

    'LBL_KBDOCUMENTS' => 'Base de Conocimiento',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'Acerca de',
    'LNK_ADVANCED_SEARCH' => 'Búsqueda Avanzada',
    'LNK_BASIC_SEARCH' => 'Búsqueda Básica',
    'LNK_SEARCH_NO_RESULTS' => 'No se encontraron resultados.',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'Ver todos los resultados',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Mostrar Todo',
    'LNK_CLOSE' => 'cerrar',
    'LBL_MODIFY_CURRENT_SEARCH' => 'Modificar búsqueda actual',
    'LNK_SAVED_VIEWS' => 'Opciones de Diseño',
    'LNK_DELETE_ALL' => 'elim todo',
    'LNK_DELETE' => 'elim',
    'LNK_EDIT' => 'editar',
    'LNK_VIEW' => 'ver',
    'LNK_GET_LATEST' => 'Obtener última',
    'LNK_GET_LATEST_TOOLTIP' => 'Reemplazar con última versión',
    'LNK_HELP' => 'Ayuda',
    'LNK_CREATE' => 'Crear',
    'LNK_CREATE_WHEN_EMPTY' => 'Crear un registro ahora.',
    'LNK_LIST_END' => 'Fin',
    'LNK_LIST_NEXT' => 'Siguiente',
    'LNK_LIST_PREVIOUS' => 'Anterior',
    'LNK_LIST_RETURN' => 'Volver a lista',
    'LNK_LIST_START' => 'Inicio',
    'LNK_LOAD_SIGNED' => 'Firmar',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'Reemplazar con documento firmado',
    'LNK_PRINT' => 'Imprimir',
    'LNK_BACKTOTOP' => 'Volver al parte superior',
    'LNK_REMOVE' => 'quitar',
    'LNK_RESUME' => 'Reanudar',
    'LNK_VIEW_CHANGE_LOG' => 'Ver el registro de auditoría',
    'TPL_AUDIT_LOG_TITLE' => 'Registro de auditoría para {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'Haga clic para ver el registro de auditorías de la dirección de correo electrónico',
    'LBL_NO_SEARCH_RESULTS' => 'No se ha encontrado ningún resultado para su búsqueda',
    'NTC_CLICK_BACK' => 'Pulse el botón de retroceso del navegador y corrija el error.',
    'NTC_DATE_FORMAT' => '(aaaa-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(aaaa-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => '¿Está seguro de que desea eliminar los registros seleccionados?',
    'NTC_TEMPLATE_IS_USED' => 'La plantilla se está utilizando en al menos un registro de marketing por email. ¿Está seguro de que desea eliminarla?',
    'NTC_TEMPLATES_IS_USED' => "Las siguientes plantillas se están utilizando en registros de marketing por email. ¿Está seguro de que desea eliminarlas?\n",
    'NTC_DELETE_CONFIRMATION' => '¿Está seguro de que desea eliminar esta registro?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => '¿Está seguro de que desea eliminar el {0}?',
    'LBL_METRIC_DELETE_WARNING' => 'Los usuarios con quienes se haya compartido esta pestaña de métrica también perderán el acceso.',
    'NTC_DELETE_CONFIRMATION_NUM' => '¿Está seguro de que desea eliminar el (los)',
    'NTC_UPDATE_CONFIRMATION_NUM' => '¿Está seguro de que desea actualizar el (los)',
    'NTC_DELETE_SELECTED_RECORDS' => 'registro(s) seleccionado(s)?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'Este filtro se eliminará de todas vistas, y puede incluir la configuración de datos para dashlets. ¿Está seguro de que desea eliminar este filtro?',
    'TPL_DELETE_FILTER_SUCCESS' => 'Ha eliminado el filtro {{name}}.',
    'NTC_DELETE_SUCCESS' => 'Ha eliminado el/la {0}.',
    'NTC_UNLINK_CONFIRMATION' => '¿Está seguro de que desea desvincular este registro?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => '¿Está seguro de que desea desvincular el {0}?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => '¿Seguro que desea desvincular los {0}? Esta acción también los eliminará del campo Contacto principal del caso.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => 'Los {0} no se pueden desvincular porque son el contacto principal de este caso. Actualice el campo Contacto principal antes de desvincular este registro.',
    'NTC_UNLINK_SUCCESS' => 'Has desvinculado el/la {0}.',
    'NTC_LOGIN_MESSAGE' => 'Introduzca su nombre de usuario y contraseña.',
    'NTC_NO_ITEMS_DISPLAY' => 'ninguno',
    'NTC_REMOVE_CONFIRMATION' => '¿Está seguro de que desea quitar esta relación? Solo se eliminará la relación. El registro no se eliminará.',
    'NTC_REQUIRED' => 'Indica un campo requerido',
    'NTC_SUPPORT_SUGARCRM' => 'Apoye el proyecto de código abierto de SugarCRM mediante una donación a través de PayPal: es rápido, gratis y seguro.',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'Bienvenido',
    'NTC_YEAR_FORMAT' => '(aaaa)',
    'LOGIN_LOGO_ERROR' => 'Reemplace los logotipos de SugarCRM.',
    'FATAL_LICENSE_ALTERED' => 'Su licencia se ha alterado desde la última vez que la validó.',
    'ERROR_FULLY_EXPIRED' => "La licencia de su empresa para SugarCRM ha caducado hace más de 30 días y necesita ser actualizada. Sólo los administradores podrán iniciar la sesión.",
    'ERROR_LICENSE_EXPIRED' => "La licencia de su empresa para SugarCRM debe ser actualizada. Sólo los administradores podrán iniciar la sesión.",
    'WARN_LICENSE_EXPIRED' => "La licencia SugarCRM de su empresa caducará en breve.",
    'ERROR_LICENSE_VALIDATION' => "La licencia de su empresa para SugarCRM necesita ser validada. Sólo los administradores pueden iniciar la sesión.",
    'WARN_LICENSE_VALIDATION' => "La licencia de su empresa para SugarCRM necesitará ser validada pronto.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>Aviso:</b> Su navegador está en vista de compatibilidad IE y no es compatible.',
    'WARN_LICENSE_SEATS' => 'Aviso: El número de usuarios activos ha alcanzado el número máximo de licencias permitidas.',
    'WARN_LICENSE_SEATS_MAXED' => 'Aviso: El número de usuarios activos supera el número máximo de licencias permitidas.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'El número de usuarios activos excede los límites del recuento de licencias. Póngase en contacto con su administrador.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'Sólo los administradores pueden iniciar la sesión.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'Se ha alcanzado el límite de recuento de usuarios de la licencia. Solo los usuarios existentes podrán iniciar sesión.',
    'WARN_ONLY_ADMINS' => 'Sólo los administradores pueden iniciar la sesión.',
    'WARN_UNSAVED_CHANGES' => 'Está a punto de abandonar este registro sin guardar los cambios que haya podido realizar. ¿Está seguro de que desea salir de este registro?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Al actualizar el navegador se cerrarán automáticamente todas las llamadas de SugarLive o las sesiones de chat que haya abierto, y se perderán todos los cambios no guardados. ¿Desea continuar?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'Existen cambios que no se han guardado. ¿Está seguro de que desea abandonar la página y descartar los cambios?',
    'LBL_MFA_RESET_CONFIRMATION' => '¿Seguro que desea restablecer su <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">autenticación multifactor</a>? 
Realizar esta acción cerrará su sesión, y tendrá que volver a autenticarse con la aplicación de autenticación la próxima vez que inicie sesión.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'Confirmar y cerrar sesión',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'Uno o más dashlets tienen cambios sin guardar. ¿Está seguro de que desea cerrar el panel?',
    'LBL_NAVIGATE_TO_REPORTS' => 'Está saliendo al módulo Informes. Sus cambios en dashlet no se han guardado. ¿Desea continuar?',
    'ERROR_NO_RECORD' => 'Error al recuperar registro.  Este registro puede haber sido eliminado o puede que no esté autorizado para verlo.',
    'ERROR_TYPE_NOT_VALID' => 'Error. Este tipo no es válido.',
    'ERROR_MAX_FIELD_LENGTH' => 'Error. La longitud máxima de este campo es {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'Error. La longitud mínima de este campo es de {{this}}.',
    'ERROR_EMAIL' => 'Error. Dirección de Email No Válida: {{#each this}}{{{this}}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'Error. Al menos una dirección principal debe ser configurada.',
    'ERROR_DUPLICATE_EMAIL' => 'Error. Dirección de Email Duplicada: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'Error. Este campo es obligatorio.',
    'ERROR_MINVALUE' => 'Error. El valor mínimo para este campo es {{this}}.',
    'ERROR_MAXVALUE' => 'Error. El valor máximo para este campo es {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'Error. EL valor de este campo debe ser mayor que {{this}}.',
    'ERROR_IS_LESS_THAN' => 'Error. El valor de este campo debe de ser menor que {{this}}.',
    'ERROR_DATETIME' => 'Error. El campo requiere un dato válido.',
    'ERROR_IS_BEFORE' => 'Error. La fecha de este campo no puede ser posterior a la fecha del campo {{this}}.',
    'ERROR_IS_AFTER' => 'Error. La fecha de este campo no puede ser anterior a la fecha del campo {{this}}.',
    'ERROR_TIME_IS_BEFORE' => 'Error. La hora de este campo no puede ser posterior a la hora del campo {{this}}.',
    'ERROR_TIME_IS_AFTER' => 'Error. La hora de este campo no puede ser posterior a la hora del campo {{this}}.',
    'ERROR_NUMBER' => 'Error. Este campo requiere un número válido.',
    'ERROR_INT' => 'Error. Entero no válido.',
    'ERROR_URL' => 'Error. URL no válido.',
    'ERROR_NO_BEAN' => 'Error al obtener el bean.',
    'ERROR_ACCESS_MODULE' => 'No tiene acceso a este módulo.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'El archivo adjunto es demasiado grande.',
    'ERROR_UPLOAD_FAILED' => 'Error. El archivo no se ha cargado.',
    'ERROR_UPLOAD_ACCESS_PD' => 'No tiene permiso para crear [definiciones de proceso] en este módulo.',
    'ERROR_UPLOAD_ACCESS_BR' => 'No tiene permiso para crear [reglas de negocio] en este módulo.',
    'ERROR_UPLOAD_ACCESS_ET' => 'No tiene permiso para crear [plantillas de email] en este módulo.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'Error. Ha introducido un operador no compatible.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'Error. Ha ingresado un operador no válido.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'Error. Ha ingresado un filtro no válido.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'Error en la importación. Un campo del grupo está parcialmente bloqueado en la definición del proceso.' .
        ' Estos campos se deben desbloquear en la definición de proceso para poder importar la definición.',
    'ERROR_EXP_DATE_LOW' => 'Error. La fecha de vencimiento no puede ser anterior a la fecha de la publicación.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'Error. El estado de aprobado requiere fecha de publicación.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'La fecha de publicación está vacía.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'Buscar Duplicados',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'La comprobación de duplicados se ha inhabilitado para {{module}}.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'Administrar Suscripciones',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Administrar Suscripciones a',
    'LBL_SUBSCRIBE' => 'Suscribir',
    'LBL_UNSUBSCRIBE' => 'Eliminar Suscripción',
    'LBL_CREATE_LINK_RECORD' => 'Crear y Vincular Registro',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'Crear y Vincular Registro',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} registros han sido vinculados.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'Ningún registro vinculado.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'El informe seleccionado no se basa en el tipo de módulo correcto.',
    'ERROR_EMPTY_LINK_MODULE' => 'Primero seleccione la relación.',
    // Ajax status strings
    'LBL_LOADING' => 'Cargando ...',
    'LBL_LOADING_NO_DOTS' => 'Cargando ...',
    'LBL_SEARCHING' => 'Buscando...',
    'LBL_SEARCH_UNDERWAY' => 'Buscando',
    'LBL_SAVING_LAYOUT' => 'Guardando Diseño ...',
    'LBL_SAVED_LAYOUT' => 'El diseño ha sido guardado.',
    'LBL_SAVED' => 'Guardado',
    'LBL_SAVING' => 'Guardando',
    'LBL_FAILED' => '¡Error!',
    'LBL_DISPLAY_COLUMNS' => 'Mostrar Columnas',
    'LBL_HIDE_COLUMNS' => 'Ocultar Columnas',
    'LBL_SEARCH_CRITERIA' => 'Criterios de Búsqueda',
    'LBL_SAVED_VIEWS' => 'Vistas Guardadas',
    'LBL_PROCESSING_REQUEST' => 'Procesando...',
    'LBL_REQUEST_PROCESSED' => 'Hecho',
    'LBL_AJAX_FAILURE' => 'Fallo de Ajax',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'Buscar...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Búsquedas guardadas',
    'LBL_SEARCH_POPULATE_ONLY' => 'Realizar una búsqueda utilizando el formulario de búsqueda anterior',
    'LBL_SEARCH_NO_RESULTS' => 'Ningún resultado encontrado para',
    'LBL_SEARCH_FOR' => 'Buscar',
    'LBL_SEARCH_FOR_MORE' => 'Buscar más...',
    'LBL_SEARCH_SELECT' => 'Seleccionar...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'Buscar y Seleccionar...',
    'LBL_SEARCH_SELECT_MODULE' => 'Seleccionar {{module}}...',
    'LBL_DETAILVIEW' => 'Vista Detallada',
    'LBL_LISTVIEW' => 'Vista de Lista',
    'LBL_EDITVIEW' => 'Vista de Edición',
    'LBL_SEARCHFORM' => 'Formulario de Búsqueda',
    'LBL_SAVED_SEARCH_ERROR' => 'Introduzca un nombre para esta vista.',
    'LBL_DISPLAY_LOG' => 'Mostrar Traza',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Lugar:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Descripción:',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'empezando',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'Haga clic en Aceptar para acceder a esta llamada o haga clic en Cancelar para cerrar este mensaje.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'Haga clic en Aceptar para ver esta reunión o haga clic en Cancelar para omitir este mensaje.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'No se encontraron resultados.',
    'MSG_LIST_VIEW_NO_RESULTS' => 'No se encontraron resultados para <item1>',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Crear <item1> como <item2> nuevo/a',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'Actualmente no tiene registros de <item1> guardados. <item2> o <item3> uno ahora.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'Actualmente no tiene registros guardados para <item1>. <item2> uno ahora.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'Puede crear <item1> desde un/una <item2>. Lista <item3> <item2>.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'Positivo',
    'LBL_SENTIMENT_NEUTRAL' => 'Neutro',
    'LBL_SENTIMENT_NEGATIVE' => 'Negativo',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'No hay pestañas de métricas configuradas',
    'LBL_NO_METRIC_VISIBLE' => 'No hay pestañas de métricas visibles',
    'LBL_MAKE_METRIC_VISIBLE' => 'Elija "organizar" para que las pestañas de métricas sean visibles',
    'LBL_PLEASE_CONTACT_ADMIN' => 'Póngase en contacto con el administrador del sistema',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'Haga clic aquí',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Agregar a Mis Favoritos',
    'LBL_MARK_AS_FAVORITES' => 'Marcar como Favorito',
    'LBL_CREATE_CONTACT' => 'Nuevo Contacto',
    'LBL_CREATE_NOTE' => 'Nueva Nota',
    'LBL_CREATE_OPPORTUNITY' => 'Nueva Oportunidad',
    'LBL_SCHEDULE_CALL' => 'Registrar Llamada',
    'LBL_SCHEDULE_CALL2' => 'Llamada',
    'LBL_SCHEDULE_MEETING' => 'Programar Reunión',
    'LBL_SCHEDULE_MEETING2' => 'Reunión',
    'LBL_CREATE_MESSAGE' => 'Crear mensaje',
    'LBL_CREATE_MESSAGE2' => 'Mensaje',
    'LBL_CREATE_TASK' => 'Nueva Tarea',
    'LBL_CREATE_TASK2' => 'Tarea',
    'LBL_REMOVE_FROM_FAVORITES' => 'Quitar de Mis Favoritos',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'Nota',
    'LBL_DOWNLOAD_ALL' => 'Descargar todos',
    'LBL_DOWNLOAD_ONE' => 'Descargar',
    'LBL_ATTACHMENTS' => 'Adjuntos',
    'LBL_ADD_ATTACHMENT' => 'Navegar',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Generar Formulario',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Guardar Formulario Web A Cliente Potencial',

    'LBL_PLEASE_SELECT' => 'Seleccione',
    'LBL_REDIRECT_URL' => 'URL de Redirección',
    'LBL_RELATED_CAMPAIGN' => 'Campaña relacionada',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Agregar Todos los Campos',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Quitar Todos los Campos',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Sólo pueden incluirse adjuntos de tipo imagen en los siguientes formatos: JPG, PNG.',
    'LBL_REMOVE' => 'Quitar',
    'LBL_TRAINING' => 'Asistencia',
    'ERR_DATABASE_CONN_DROPPED' => 'Error ejecutando una consulta. Posiblemente su base de datos se ha desconectado. Actualice esta página. Es posible que incluso necesite reiniciar su servidor web.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'Error configurando relación {0}: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'Cambiado el contexto de base de datos a',
    'ERR_MSSQL_WARNING' => 'Aviso:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'Error al Analizar formato vCard',
    'ERR_VCARD_FILE_MISSING' => 'Falta el archivo vcf',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Aviso: el campo [[field]] no tiene una entrada mapeada en el archivo vardefs.php de [moduleDir]',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Error: No existe el archivo [[file]].  No se ha podido crear porque no se ha encontrado el archivo HTML correspondiente.',
    'ERR_CANNOT_FIND_MODULE' => 'Error: El módulo [module] no existe.',
    'LBL_ALT_ADDRESS' => 'Otra Dirección:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Error: Hay un número de argumentos desigual para los elementos "clave" y "copia" en el array displayParams.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Falta el índice del Array displayParams para: ',

    'LBL_DASHLET' => 'Dashlet',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filtros',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Sólo Mis Elementos',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Título',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Mostrar Filas',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'Relacionar con el registro actual',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'Campo vinculado',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'Congelar primera columna',

    'LBL_REMOVE_DASHLET_CONFIRM' => '¿Está seguro de que desea quitar el Sugar Dashlet?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => '¿Está seguro de que desea eliminar la fila?',
    'LBL_MAXIMUM_OF' => 'Máximo de',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => ' columnas no se puede(n) mostrar.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'Cuadro de mando',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'Mi Cuadro de Mando',
    'LBL_COLLAPSE_ALL' => 'Contraer Todo',
    'LBL_EXPAND_ALL' => 'Expandir Todo',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'Editar',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'Ver informe',
    'LBL_DASHLET_REFRESH_LABEL' => 'Refrescar',
    'LBL_DASHLET_REMOVE_LABEL' => 'Quitar',
    'LBL_DASHLET_DROP_HERE' => 'Dejar aquí',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'Minimizar',
    'LBL_DASHLET_MAXIMIZE' => 'Maximizar',
    'LBL_DASHLET_CONFIGURE' => 'Configurar',
    'LBL_DASHLET_TOGGLE' => 'Conmutar Visibilidad del Cuadro de Mando',
    'LBL_SIDEPANE_TOGGLE' => 'Abrir/cerrar el panel lateral',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'Restaurar dashlets predeterminados',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'Ningún cuadro de mando configurado',
    'LBL_CREATE_DASHBOARD_LINK' => 'Crear cuadro de mando',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'Ayuda',
    'LBL_HELPLET_TOGGLE' => 'Abrir/Cerrar',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'Módulos',
    'LBL_FACET_MODIFIED_BY_ME' => 'Modificado por mí',
    'LBL_FACET_CREATED_BY_ME' => 'Creado por Mí',
    'LBL_FACET_MY_FAVORITES' => 'Mis Favoritos',
    'LBL_FACET_ASSIGNED_TO_ME' => 'Asignados a mí',
    'LBL_FACET_NO_DATA' => 'No hay datos para este aspecto.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'Vista de Lista',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'Enumera registros desde un módulo concreto en base a los criterios definidos.',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'Vista de lista de la consola',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'Enumera registros de un módulo particular relacionados con el registro que ve en la consola.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'Vista de Registro',
    'LBL_RELATED_RECORDS' => '{{module}} relacionado',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'Muestra un registro y, de manera opcional, registros relacionados en pestañas.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'Tipo de registro base',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'Este {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'Pestañas',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'Vista previa de diseño básico',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'Aviso, solo se pueden mostrar {{numWord}} ({{num}}) en pestañas. ' .
        'Elimine uno o más módulos antes de añadir cualquier otro.',
    'LBL_SIX' => 'seis', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'Registro de comentarios',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'Muestra comentarios para un registro',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'Ningún comentario disponible',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'Añadir',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'Añadir comentario',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'Ver todos',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'Datos no disponibles. No tiene permiso para acceder a estos módulos.' .
    " \nActualice o suprima este dashlet.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'Mis {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'Ningún registro seleccionado para mostrar',
    'LBL_CONTENT_SEARCH_DASHLET' => 'Dashlet de búsqueda de contenido',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => '¿Qué podemos hacer para ayudarle hoy, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => '¿Desea crear un caso?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'Métricas de Oportunidad',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'Indicadores de oportunidad para la cuenta relacionada.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'Selección rápida del catálogo de productos',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'Listas de elementos usados recientemente y productos guardados como Favoritos',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'Usados recientemente',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'Favoritos',

    'LBL_DASHBOARD_CREATE' => 'Crear cuadro de mando',
    'LBL_DASHBOARD_DUPLICATE' => 'Duplicar cuadro de mando',
    'LBL_DASHBOARD_DELETE' => 'Borrar el cuadro de mandos',
    'LBL_PIN_TO_TOP' => 'Fijar arriba',
    'LBL_PIN_TO_BOTTOM' => 'Fijar abajo',
    'LBL_MANAGE_DASHBOARDS' => 'Administrar paneles de control',

    'LBL_DASHBOARD_CONFIG' => 'Configuración del panel',
    'LBL_LIST_VIEW__NAME' => 'Vista de listas',
    'LBL_PIPELINE_VIEW_NAME' => 'Vista del mosaico',
    'LBL_PIPELINE_VIEW_BTN' => 'Vista del mosaico',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} por {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'La vista de fichas no está habilitada',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'No se encontró ningún registro.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'Resumen del Caso',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'Línea de tiempo',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'Notas y Adjuntos',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'Notas y Adjuntos que pertenecen al registro',
    'LBL_DASHLET_PIPLINE_NAME' => 'Canalización',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'Tweets recientes - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'Cuadros de Mando no guardados',

    'LBL_DNB_AND' => 'y',
    'LBL_DNB_PRIM_NAME_DESC' => 'Texto que registra el nombre de esta organización',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'Responder',
    'LBL_TWITTER_RETWEET' => 'Retwittear',
    'LBL_TWITTER_FAVORITE' => 'Favorito',
    'LBL_TWITTER_FOLLOW' => 'Seguir',
    'LBL_TWITTER_DESCRIPTION' => 'Vea la bio de un usuario, sus tweets de Twitter, sus retweets y sus respuestas',
    'LBL_TWITTER_ID' => 'ID de Twitter',
    'LBL_TWITTER_DISPLAY_ROWS' => 'Mostrar Filas',
    'LBL_TWITTER_MY_ACCOUNT' => 'Mi Cuenta',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Fuente del Tweet:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'Recursos de Aprendizaje',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'Formación y certificación',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'Comunidad SugarClub',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'Documentación y asistencia',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'Mercado de SugarOutfitters',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'Ventas por País',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'Mostrar el gráfico de ventas por país',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'Categorías de bases de conocimientos y artículos publicados',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'Búsqueda en la Base de conocimientos',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'Muestra una vista de árbol con artículos y categorías de la base de conocimientos publicados que se pueden buscar.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'Artículos publicados en otros idiomas',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'Artículos más útiles publicados de la Base de conocimientos',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'Muestra los artículos más leídos y que más han gustado de la base de conocimiento',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} filtrado por {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'Utilidad de los artículos',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'Agregar Página',
    'LBL_LOADING_PAGE' => 'Cargando página, espere...',
    'LBL_SEARCH_RESULTS' => 'Resultados de Búsqueda',
    'LBL_SEARCH_RESULTS_FOR' => 'Resultados de búsqueda por: ',
    'LBL_SEARCH_HELP_TITLE' => 'Consejos de Búsqueda',
    'LBL_SEARCH_RESULTS_FOUND' => 'Resultados de la búsqueda',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'Mi pipeline',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "El Pipeline de mi equipo",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'Gráfico pipeline de ventas',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'Muestra el gráfico actual de pipeline.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'Sin Imagen',

    'LBL_MODULE' => 'Módulo',
    'LBL_RELATIONSHIP' => 'Relación',
    'LBL_SINGULAR_LABEL' => 'Etiqueta singular',
    'LBL_PLURAL_LABEL' => 'Etiqueta plural',
    'LBL_MODULE_DISPLAY' => 'Visualización',
    'LBL_MODULE_DISPLAY_TYPE' => 'Tipo de visualización',
    'LBL_MODULE_ICON' => 'Icono',
    'LBL_MODULE_COLOR' => 'Color de fondo del módulo',
    'LBL_LANGUAGE_SELECTOR' => 'Idioma',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'Configuración del módulo',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'La configuración del módulo se ha guardado.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Copiar dirección de la izquierda:',
    'LBL_SAVE_AND_CONTINUE' => 'Guardar y Continuar',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Controles de multiselección</strong></p><ul><li>Haga clic en los valores para seleccionar un atributo.</li><li>Ctrl-clic&nbsp;para&nbsp;seleccionar varios. Los usuario de Mac deben utilizar CMD-clic.</li><li>Para seleccionar todos los valores entre dos atributos,&nbsp;haga clic en el primer valor&nbsp;mantenga pulsado Mayús y haga clic en el último valor.</li></ul><p><strong>Opciones de diseño y búsqueda avanzada</strong><br><br>Con la opción<b>Diseño y búsqueda avanzada</b> puede guardar un conjunto de parámetros de búsqueda o un diseño de visualización de listas  para obtener rápidamente los resultados de búsqueda deseados en el futuro. Puedes guardar un número ilimitado de búsquedas y diseños personalizados. Todas las búsquedas guardadas aparecerán ordenadas por nombre en la lista de búsquedas guardadas, y las primera que aparecerá será las última búsqueda guardada cargada.<br><br>Para personalizar el diseño de la Visualización de lista utilice las casillas de Ocultar columnas y Mostrar columnas para seleccionar los campos que desea mostrar en los resultados de búsqueda. Por ejemplo, puede ver u ocultar detalles como el nombre de registro, usuario asignado y equipo asignado en los resultados de búsqueda. Para añadir una columna a la Visualización de lista, seleccione el campo de la lista de Ocultar columnas y utilice la flecha izquierda para moverla a la lista de Mostrar columnas. Para quitar una columna de la Visualización de lista, selecciónela de la lista de Mostrar columnas y utilice la flecha derecha para moverla a la lista de Ocultar columnas.<br><br>Si guarda la configuración de diseño, podrá cargarlos en cualquier momento para ver los resultados de búsqueda con el diseño personalizado.<br><br>Para guardar y actualizar una búsqueda y/o un diseño:<ol><li>Introduzca un nombre para los resultados de búsqueda en el campo <b>Guardar esta búsqueda como</b>y haga clic en <b>Guardar</b>.Ahora el nombre aparecerá en la lista de Búsqueda guardadas junto al botón <b>Borrar</b>.</li><li>Para ver una búsqueda guardada, selecciónela de la lista de Búsquedas guardadas. Los resultados de búsqueda se muestran en la Visualización de lista.</li><li>Para actualizar las propiedades de una búsqueda guardad, selecciónela en la lista, introduzca los nuevos criterios de búsqueda y/o las opciones de diseño en la zona de Búsqueda avanzada y haga clic en <b>Actualizar</b>junto a <b>Modificar búsqueda actual</b>.</li><li>Para eliminar una búsqueda guardada, selecciónela en la losta de Búsquedas guardadas, haga clic en <b>Eliminar</b> junto a<b>Modificar búsqueda actual</b>, y a continuación haga clic en <b>Aceptar</b> para confirmar la eliminación.</li></ol><p><strong>Consejos</strong><br><br>Si utiliza % como comodín, podrá ampliar su búsqueda. Por ejemplo, en lugar de buscar resultados iguales a “Manzanas” puede cambiar su búsqueda por “Manzanas%”, lo que presentaría todos los resultados que comienzan con la palabra Manzanas pero contienen además otros caracteres.</p>',

    //resource management
    'ERR_QUERY_LIMIT' => 'Error: Límite de consultas $limit alcanzado en el módulo $module.',
    'ERROR_NOTIFY_OVERRIDE' => 'Error: ResourceObserver->notify() se debe reemplazar.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'Error: No se puede crear monitor porque el archivo de metadatos está vacío o el archivo no existe.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'Error: No hay monitor configurado para el nombre solicitado',
    'ERR_UNDEFINED_METRIC' => 'Error: No se puede establecer el valor de métrica definido',
    'ERR_STORE_FILE_MISSING' => 'Error: No se puede encontrar el archivo de la aplicación de la tienda',

    'LBL_MONITOR_ID' => 'ID de Monitor',
    'LBL_TEAM_ID' => 'ID de Equipo',
    'LBL_SELECT_MODULE' => 'Seleccione un módulo:',
    'LBL_USER_ID' => 'ID de Usuario',
    'LBL_MODULE_NAME' => 'Nombre de Módulo',
    'LBL_MODULE_ALL' => 'Todo',
    'LBL_ITEM_ID' => 'Id de elemento',
    'LBL_ITEM_SUMMARY' => 'Resumen de elemento',
    'LBL_ACTION' => 'Acción',
    'LBL_SESSION_ID' => 'ID de Sesión',
    'LBL_BREADCRUMBSTACK_CREATED' => 'BreadCrumbStack creado por el usuario con id {0}',
    'LBL_VISIBLE' => 'Dato visible',
    'LBL_DATE_LAST_ACTION' => 'Fecha de última acción',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'Texto SQL',
    'LBL_QUERY_HASH' => 'Guión SQL',
    'LBL_SEC_TOTAL' => 'Total de segundos',
    'LBL_SEC_AVG' => 'Promedio de segundos',
    'LBL_RUN_COUNT' => 'Recuento de consultas',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'Dirección IP de cliente',
    'LBL_DATE_START' => 'Fecha de inicio',
    'LBL_ACTIVE' => 'Sesión activa',
    'LBL_ROUNDTRIPS' => 'Recuento de acciones',
    'LBL_SECONDS' => 'Segundos activos',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'Circuitos de base de datos',
    'LBL_FILES_OPENED' => 'Ficheros accedidos',
    'LBL_MEMORY_USAGE' => 'Memoria usada (bytes)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'Cargando conector de Twitter ...',
    'LBL_TWITTER_DATA_EMPTY' => 'No hay datos de Twitter',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Complemento de Sugar para Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Integrar e-mail e información de calendario de Sugar con Microsoft Outlook.',
    'LBL_PLUGIN_WORD_NAME' => 'Complemento de Sugar para Word',
    'LBL_PLUGIN_WORD_DESC' => 'Rellenar automáticamente la información de SugarCRM en cartas, correo directo y otros documentos de Microsoft.',
    'LBL_PLUGIN_EXCEL_NAME' => 'Complemento de Sugar para Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'Integrar Sugar con hojas de cálculo para un mejor análisis de las métricas clave.',
    'LBL_PLUGINS_TITLE' => 'Complemento de Sugar para Microsoft Office<sup>TM</sup>',
    'LBL_PLUGINS_DESC' => 'Leer sobre el complemento de funciones dentro de la <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">documentación de Plug-in</a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Complementos de Sugar para Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'Complemento de Sugar para Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'Integración de Sugar con Lotus Notes.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'no antes de',
    'MSG_IS_MORE_THAN' => 'es más que',
    'MSG_IS_LESS_THAN' => 'es menor que',
    'MSG_SHOULD_BE' => 'debe ser',
    'MSG_OR_GREATER' => 'o más',
    'MSG_EXCEEDS_MAXLEN' => 'excede la longitud máxima especificada ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Bienvenido a Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'El Portal de Sugar es un marco que proporciona en tiempo real punto de vista de los casos, las incidencias y boletines de noticias a los clientes, etc. Se trata de una interfaz externa de Sugar que se puede implementar en cualquier sitio web. Manténgase atento a las características de servicio al cliente como la Gestión de Proyectos y foros en nuestras futuras versiones.',
    'LBL_LIST' => 'Lista',
    'LBL_CREATE_CASE' => 'Nuevo Caso',
    'LBL_CREATE_BUG' => 'Crear incidencia',
    'LBL_NO_RECORDS_FOUND' => '- 0 Registros Encontrados -',

    'DATA_TYPE_DUE' => 'Vencimiento:',
    'DATA_TYPE_START' => 'Inicio:',
    'DATA_TYPE_SENT' => 'Enviado:',
    'DATA_TYPE_MODIFIED' => 'Modificado:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Total',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'imagen objeto',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'Seleccionar fecha',

    'LBL_VALIDATE_RANGE' => 'no está dentro del rango válido',
    'LBL_VALIDATE_URL' => 'no es una URL válida',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'Todos',

    'LBL_OPERATOR_IN_TEXT' => 'es uno de los siguientes:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'no es uno de los siguientes:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Error: La cantidad del Array del parámetro bean no coincide con la cantidad del Array del resultado.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Error: Falta el módulo de entrada de asignación.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Error: No se pueden recuperar datos del conector {0}. Actualmente, el servicio puede estar inaccesible o los ajustes de configuración pueden no ser válidos. Mensaje de error del conector: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'No se pueden recuperar los datos. El servicio está actualmente inaccesible o los ajustes de configuración no son válidos.',
    'LBL_CONNECT_TWITTER' => 'Conectar a Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'No se puede encontrar línea de tiempo para el ID de Twitter:',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'Configurar el conector de Twitter',
    'LBL_CONNECT_TEST_FAIL' => 'Error: Los valores de configuración del conector pueden no ser válidos. Póngase en contacto con su administrador.',
    'LBL_CONFIGURE_TWITTER' => 'Contacte con su administrador para configurar Twitter',
    'LBL_MERGE_CONNECTORS' => 'Obtener datos',
    'LBL_NO_DATA_AVAILABLE' => 'No hay datos disponibles.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => '¿Está usted seguro de que quiere desactivar la integración del conector de este módulo?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Error de conexión al servidor Elastic',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'El equipo Global no se pueden eliminar.',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'Este equipo privado [{0}] no puede ser eliminado hasta que el usuario [{1}] se elimine.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'Tiene Adobe Flash apagado o está utilizando una versión anterior del reproductor de Adobe Flash Player. Para obtener la última versión de Flash Player, <a href="http://www.adobe.com/go/getflashplayer/">haga clic aquí</a>.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'Nombre',
    'LBL_COLLECTION_PRIMARY' => 'Principal',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'Campo vacío requerido',
    'LBL_COLLECTION_EXACT' => 'Exactamente',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'Para unos resultados óptimos al utilizar el sapi IIS/FastCGI, ajuste fastcgi.logging en 0 en su archivo php.ini.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'Asignado a',
    'LBL_DESCRIPTION' => 'Descripción',
    'LBL_PRIMARY_CONTACT_NAME' => 'Contacto principal',
    'LBL_PRIMARY_CONTACT_ID' => 'Id del contacto principal',

    'LBL_NONE' => '-ninguno-',
    'LBL_YESTERDAY' => 'Ayer',
    'LBL_TODAY' => 'hoy',
    'LBL_TOMORROW' => 'mañana',
    'LBL_NEXT_WEEK' => 'la semana que viene',
    'LBL_NEXT_MONDAY' => 'próximo lunes',
    'LBL_NEXT_FRIDAY' => 'próximo viernes',
    'LBL_TWO_WEEKS' => 'dos semanas',
    'LBL_NEXT_MONTH' => 'el mes que viene',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'primer día del próximo mes',
    'LBL_THREE_MONTHS' => 'tres meses',
    'LBL_SIXMONTHS' => 'seis meses',
    'LBL_NEXT_YEAR' => 'próximo año',
    'LBL_FILTERED' => 'Filtrado',

    //Datetimecombo fields
    'LBL_HOURS' => 'Horas',
    'LBL_MINUTES' => 'Minutos',
    'LBL_MERIDIEM' => 'Meridiem',
    'LBL_DATE' => 'Fecha',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Actualización automática',

    'LBL_DURATION_DAY' => 'día',
    'LBL_DURATION_HOUR' => 'hora',
    'LBL_DURATION_MINUTE' => 'minuto',
    'LBL_DURATION_DAYS' => 'días',
    'LBL_DURATION_HOURS' => 'horas',
    'LBL_DURATION_MINUTES' => 'minutos',
    'LBL_DURATION_SECONDS' => 'segundos',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'Elegir mes',
    'LBL_ENTER_YEAR' => 'Introducir año',
    'LBL_ENTER_VALID_YEAR' => 'Introduzca un año válido',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'Introduzca un número de teléfono de EE. UU., incluyendo el código de área.',
    'LBL_CCP_NOT_INITIATED' => 'Intentando marcar con CCP mientras el agente no ha iniciado su sesión.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'No se puede iniciar la llamada con CCP.',
    'LBL_CCP_DIALING_ERROR' => 'Esta llamada no se ha podido completar al marcar.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'Cierre todas las sesiones de chat de SugarLive antes de realizar una llamada saliente.',

    //File write error label
    'ERR_FILE_WRITE' => 'Error: No se pudo escribir el archivo {0}. Revise el sistema y los permisos del servidor web.',
    'ERR_FILE_NOT_FOUND' => 'Error: No se puede cargar el archivo {0}. Compruebe los permisos del sistema y del servidor web.',

    'LBL_AND' => 'Y',
    'LBL_BEFORE' => 'Antes de',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'Cargar de vuestro ordenador',
    'LBL_SEARCH_EXTERNAL_API' => 'Fichero en fuente externa',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'Cargar a una fuente externa',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'Vincular de una fuente externa',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'Seguridad',
    'LBL_SHARE_PRIVATE' => 'Privado',
    'LBL_SHARE_COMPANY' => 'Empresa',
    'LBL_SHARE_LINKABLE' => 'Enlazable',
    'LBL_SHARE_PUBLIC' => 'Público',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'Fuente RSS',
    'LBL_RSS_RECORDS_FOUND' => 'registro(s) encontrado(s)',
    'ERR_RSS_INVALID_INPUT' => 'RSS no es un input_type correcto',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS no es un response_type válido para este método',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs no soporta el formato del fichero.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'Vacío',
    'LBL_IS_EMPTY' => 'Está Vacío',
    'LBL_IS_NOT_EMPTY' => 'No está Vacío',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '
"Este es un archivo de importación de muestra que es un ejemplo de los contenidos que se espera de un archivo que está listo para la importación." "El archivo es uno delimitado por comas .csv, usando comillas como el calificador de campo." "La fila de encabezado es la fila de arriba la mayoría en el archivo que contiene las etiquetas de campo como si fuera a ver en la aplicación." "Estas etiquetas se utilizan para el mapeo de los datos en el archivo de los campos de la aplicación." "Notas: Los nombres de base de datos también podrían ser utilizados en la cabecera. Esto es útil cuando usted está usando phpMyAdmin o cualquier otra herramienta de bases de datos para proporcionar una lista de exportación de datos a importar." "El orden de las columnas no es crítico, el proceso de importación coincide con los datos en los campos apropiados basados ​​en la fila de cabecera". "Para utilizar este archivo como plantilla, haga lo siguiente:" "1. Quite las filas de la muestra de los datos" "2. Retire el texto de ayuda que usted está leyendo ahora mismo" "3. de entrada de sus propios datos en las filas correspondientes y columnas" " 4. Guarde el archivo en una ubicación conocida de su sistema " " 5. Haga clic en la opción Importar en el menú Acciones en la aplicación y elegir el archivo a cargar "   ',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'ID del usuario asignado',
    'LBL_EXPORT_CREATED_BY' => 'Creado por ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'Modificado por ID',
    'LBL_EXPORT_REPORTS_TO_ID' => 'Informa a Id',
    'LBL_EXPORT_TEAM_ID' => 'ID de Equipo',
    'LBL_EXPORT_TEAM_SET_ID' => 'ID Conjunto de equipo',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Usuario asignado',
    'LBL_EXPORT_FULL_NAME' => 'Nombre Completo',
    'LBL_EXPORT_TEAM_NAME' => 'Equipos',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navegando...',

    'LBL_PENDING_NOTIFICATIONS' => 'Notificaciones',
    'LBL_ALT_ADD_TEAM_ROW' => 'Añadir nuevo fila de equipo',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'Eliminar equipo',
    'LBL_ALT_SPOT_SEARCH' => 'Lugar de búsqueda',
    'LBL_ALT_NOT_SORTED' => 'Sin ordenar',
    'LBL_ALT_SORT_DESC' => 'Ordenado descendente',
    'LBL_ALT_SORT_ASC' => 'Ordenado ascendente',
    'LBL_ALT_SORTABLE' => 'Ordenable',
    'LBL_ALT_NOT_SORTABLE' => 'No ordenable',
    'LBL_ALT_SORT' => 'Ordenar',
    'LBL_ALT_SHOW_OPTIONS' => 'Mostrar opciones',
    'LBL_ALT_HIDE_OPTIONS' => 'Ocultar opciones',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'Mover selección a la lista de la izquierda',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Mover selección a la lista de la derecha',
    'LBL_ALT_MOVE_COLUMN_UP' => 'Mover selección hacia arriba en el orden de la lista mostrada',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'Mover selección hacia abajo en el orden de la lista mostrada',
    'LBL_ALT_INFO' => 'Información',
    'MSG_DUPLICATE' => 'El registro {0} que está a punto de crear puede ser un duplicado de un registro {0} que ya existe. {1} registros que contienen nombres similares se enumeran a continuación.<br>Haga clic en Crear {1} para continuar la creación de este nuevo {0}, o seleccionar un archivo {0} enumerado a continuación.',
    'MSG_SHOW_DUPLICATES' => 'El registro {0} que está a punto de crear puede ser un duplicado de un registro {0} que ya existe. {1} registros que contienen nombres similares se enumeran a continuación. Haga clic en Guardar para continuar con la creación de este nuevo {0}, o haga clic en Cancelar para volver al módulo sin necesidad de crear {0}.',
    'LBL_EMAIL_TITLE' => 'dirección de email',
    'LBL_EMAIL_OPT_TITLE' => 'dirección de mail rehusada',
    'LBL_EMAIL_INV_TITLE' => 'dirección de email no válida',
    'LBL_EMAIL_PRIM_TITLE' => 'dirección de email principal',
    'LBL_SELECT_ALL_TITLE' => 'Seleccionar todo',
    'LBL_SELECT_THIS_ROW_TITLE' => 'Seleccionar esta fila',
    'LBL_TEAM_SELECTED_TITLE' => 'Equipo seleccionado',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Seleccione para hacer este equipo el principal',
    'LBL_TEAM_TBSELECTED_TITLE' => 'Equipo marcado como seleccionado para trabajo en equipo ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'Marcar este equipo como seleccionado para trabajo en equipo',
    'LBL_SEARCH_AND_SELECT' => 'Buscar y Seleccionar {{module}}',
    'TPL_SEARCH_AND_ADD' => 'Buscar y agregar {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'ERROR: Hubo un error durante la carga. Código de error: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'ERROR: Hubo un error durante la subida. Código de error: {0} - {1}. El upload_maxsize es {2}',
    'UPLOAD_ERROR_HOME_TEXT' => 'ERROR: Se ha producido un error durante la carga, póngase en contacto con un administrador para obtener ayuda.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'El tamaño de la carga ({0} bytes) superó el máximo permitido: {1} bytes',
    'UPLOAD_REQUEST_ERROR' => 'Ha ocurrido un error. Actualice la página y vuelva a intentarlo.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => 'Editar',
    'LBL_ADD_BUTTON_LABEL' => 'Añadir',
    'LBL_EDIT_BUTTON_TITLE' => 'Editar [Alt+E]',
    'LBL_REFRESH_BUTTON_LABEL' => 'Actualizar',
    'LBL_REFRESH_BUTTON_TITLE' => 'Actualizar',
    'LBL_DUPLICATE_BUTTON_KEY' => 'U',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Duplicar',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Duplicar [Alt+U]',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'Planificaciones de informes',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'Planificaciones de informes',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'Detalles de informes',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'Detalles de informes',
    'LBL_DELETE_BUTTON_KEY' => 'd',
    'LBL_DELETE_BUTTON_LABEL' => 'Eliminar',
    'LBL_DELETE_BUTTON_TITLE' => 'Eliminar [Alt+D]',
    'LBL_SAVE_BUTTON_KEY' => 'S',
    'LBL_SAVE_BUTTON_LABEL' => 'Guardar',
    'LBL_SAVE_BUTTON_TITLE' => 'Guardar [Alt+S]',
    'LBL_CANCEL_BUTTON_KEY' => 'i',
    'LBL_CANCEL_BUTTON_LABEL' => 'Cancelar',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'para parar.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'para seguir en la página.',
    'LBL_CANCEL_BUTTON_TITLE' => 'Cancelar [Alt+X]',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'Compartir',
    'LBL_SHARE_BUTTON_TITLE' => 'Compartir',
    'LBL_START_BUTTON_LABEL' => 'Iniciar',
    'LBL_START_BUTTON_TITLE' => 'Iniciar',
    'LBL_FINISH_BUTTON_LABEL' => 'Finalizar',
    'LBL_FINISH_BUTTON_TITLE' => 'Finalizar',
    'LBL_CONFIRM_BUTTON_LABEL' => 'Confirmar',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'para continuar.',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'para abandonar la página y descartar cambios.',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Accesos directos de teclado',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Funcionalidad en formularios- Alt+</strong><br/> I = editar (detailview)<br/> U = duplicar (detailview)<br/> D = borrar (detailview)<br/> A = guardar (editview)<br/> L = cancelar (editview) <br/><br/></p><p><strong>Búsquedas y Navegación  - Alt+</strong><br/> 7 = Primer elemento en el formulario de edición<br/> 8 = Enlace de búsqueda avanzada<br/> 9 = Primer elemento en el formulario de búsqueda<br/> 0 = Elemento en búsqueda unificada<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'Escalar',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'Compartir',
    'TPL_RECORD_SHARE_SUBJECT' => 'Compartir {{module}} {{name}} desde {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'Revise {{module}} {{name}} de {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'array de conectores en {0} se ha definido incorrectamente o está vacío y no se ha podido usar.',
    'LBL_PDF_VIEW' => 'Descargar PDF',
    'LBL_PDF_EMAIL' => 'Enviar PDF por email',

    'ERR_SUHOSIN' => 'El flujo de carga está bloqueado por Suhosin, añada un &quot;upload&quot; en suhosin.execu tor.include.whitelist (Ver sugarcrm.log para más información)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'ahora mismo',
    'LBL_TIME_AGO_SECONDS' => 'hace menos de un minuto',
    'LBL_TIME_AGO_MINUTE' => 'hace aprox. un minuto',
    'LBL_TIME_AGO_MINUTES' => 'hace {{this}} minutos',
    'LBL_TIME_AGO_HOUR' => 'hace aprox. una hora',
    'LBL_TIME_AGO_HOURS' => 'hace {{this}} horas',
    'LBL_TIME_AGO_DAY' => 'ayer',
    'LBL_TIME_AGO_DAYS' => 'hace {{this}} días',
    'LBL_TIME_AGO_YEAR' => 'hace más de un año',
    'LBL_TIME_UNTIL_SECONDS' => 'en menos de un minuto',
    'LBL_TIME_UNTIL_MINUTE' => 'en aproximadamente un minuto',
    'LBL_TIME_UNTIL_MINUTES' => 'en {{this}} minutos',
    'LBL_TIME_UNTIL_HOUR' => 'en aproximadamente una hora',
    'LBL_TIME_UNTIL_HOURS' => 'en {{this}} horas',
    'LBL_TIME_UNTIL_DAY' => 'mañana',
    'LBL_TIME_UNTIL_DAYS' => 'en {{this}} días',
    'LBL_TIME_UNTIL_YEAR' => 'en más de un año',
    'LBL_TIME_RELATIVE' => 'Publicado {{relativetime}} el {{date}} a las {{time}}',
    'LBL_LAST_TOUCHED' => 'Última modificación {{relativetime}} el {{date}} a las {{time}}',
    'LBL_LAST_COMMIT' => 'Último compromiso: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'No se encontraron registros en este momento.',
    'LBL_DETAILVIEW_NO_RECORDS' => 'Este registro no se puede mostrar en este momento.',
    'LBL_REFINE_LIST' => 'Refinar Lista',
    'LBL_SEARCH_BY' => 'Buscar por',
    'LBL_PREVIEW' => 'Vista Preliminar',
    'LBL_COLUMNS' => 'Columnas',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'Vista deshabilitada: No hay datos disponibles',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'Vista deshabilitada: No hay acceso al registro',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'Vista deshabilitada: No hay datos disponibles',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'Vista deshabilitada: En vista como registro actual',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'Vista deshabilitada: Registro eliminado o no se puede acceder al registro',
    'LBL_PREVIEW_PREVIOUS' => 'Vista previa anterior',
    'LBL_PREVIEW_NEXT' => 'Vista previa siguiente',
    'LBL_PREVIEW_CLOSE' => 'Cerrar vista previa',
    'LBL_STREAM_NO_RECORDS' => 'Este registro no tiene notas en este momento. Añada una nota haciendo clic en el enlace.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} duplicados encontrados.',
    'LBL_NO_DUPLICATES_FOUND' => 'No se encontraron duplicados.',
    'LBL_RESET_DEFAULT_VIEW' => 'Restablecer la vista por defecto',
    'LBL_RESET_DEFAULT_WIDTHS' => 'Restablecer los anchos por defecto',
    'LBL_TIMEZONE_UPDATED' => 'Sugar ha actualizado la zona horaria de su perfil de usuario para que coincida con la de su navegador',
    'LBL_SUCCESS' => 'Éxito',
    'LBL_ERROR' => 'Error',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'Combinar Duplicados',
    'LBL_MERGE_DUPLICATES_PROCEED' => '¿Desea continuar? Cancelar para abortar. Confirmar para eliminar los registros.',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'Esta acción eliminará el siguiente registro(s):',
    'LBL_MERGE' => 'Combinar',
    'TPL_MERGING_RECORDS' => 'Unificando {{mergeCount}} Registros',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'Número no válido de registros pasados. El rango válido es de {{minRecords}} a {{maxRecords}} registros.',
    'LBL_MERGE_NO_ACCESS' =>
        'No tiene acceso para realizar esta acción. Al menos un registro debe ser editable.',
    'LBL_MERGE_LOCKED' => 'Algunos de los registros seleccionados para combinar contienen campos que están bloqueados para la edición por un proceso y no se pueden combinar en este momento.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'Todos los cambios se perderán cuando cambie a un registro principal nuevo. ¿Está seguro de que desea cambiar?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'Combinar los Registros Relacionados',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'Unificados: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'Error al Unificar {{objectName}} Relacionados. Iniciando nuevo intento ({{num}} de {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'Error al Unificar {{objectName}} Relacionados.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'La combinación de registros relacionados está incompleta. Algunos registros permanecen sin combinar.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'La combinación de registros relacionados está incompleta. Cancelar para abortar. Confirmar para continuar la combinación.',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'Todos los registros relacionados se moverán al registro principal.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        '¿Está seguro de que quiere eliminar este registro de la combinación?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'Eliminar registro de la combinación',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'Cantidad de registros pasados no válida. El intervalo válido es de 1 a {{maxRecords}} registros.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'La combinación de nombre de usuario y contraseña suministrada es incorrecta, inténtelo de nuevo.',
    'LBL_INVALID_CREDS_TITLE' => 'Credenciales no válidas',
    'LBL_INVALID_GRANT' => 'Su identificación no es válida o ha expirado. Inténtelo de nuevo.',
    'LBL_INVALID_GRANT_TITLE' => 'Sesión expirada',
    'LBL_AUTH_FAILED' => 'Autenticación del Cliente fallida.',
    'LBL_AUTH_FAILED_TITLE' => 'Cliente no válido',
    'LBL_INVALID_REQUEST' => 'La solicitud es inválida o incorrecta. Póngase en contacto con la asistencia técnica.',
    'LBL_INVALID_REQUEST_TITLE' => 'Solicitud no válida',
    'LBL_REQUEST_TIMEOUT' => 'El servidor no responde. Compruebe su conexión a Internet.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'Agotado el tiempo de espera de la solicitud: ',
    'LBL_UNAUTHORIZED' => 'Lo sentimos, usted no está autorizado para acceder a este apartado.',
    'LBL_UNAUTHORIZED_TITLE' => 'No Autorizado',
    'LBL_RESOURCE_UNAVAILABLE' => 'Recurso no diponible.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'Prohibido',
    'LBL_METHOD_NOT_ALLOWED' => 'Método HTTP no permitido para este recurso. Póngase en contacto con asistencia técnica.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'Método No Permitido',
    'LBL_PRECONDITION_MISSING' => 'Solicitud fallida o parámetro que falta/no válido. Póngase en contacto con asistencia técnica',
    'LBL_PRECONDITION_MISSING_TITLE' => 'Error:',
    'LBL_INVALID_412_RESPONSE' => 'Una petición esta fallando y hace que no se pueda usar la aplicación. Póngase en contacte con asistencia técnica.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'No se permite editar el campo {0} en el módulo: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'No se permite ejecutar la acción "{0}" en este registro',
    'LBL_LOGIN_BUTTON_LABEL' => 'Iniciar Sesión',
    'LBL_ACTIVITY_VIEW_TOUR' => 'Guía rápida de Vista de Actividad',
    'LNK_TOUR' => 'Visita guiada',
    'LNK_MOBILE' => 'Móvil',
    'LBL_FEEDBACK' => 'Comentarios',
    'LBL_SUPPORT' => 'Asistencia',
    'LBL_LANGUAGE' => 'Idioma',
    'LBL_LOADING_LANGUAGE' => 'Cargando paquete de idioma',
    'LBL_UPLOADING' => 'Cargando',
    'LBL_UPLOADING_DOTS' => 'Cargando...',
    'LBL_IMAGE_DELETE_CONFIRM' => '¿Está seguro de que desea eliminar esta imagen?',
    'LBL_FILE_DELETE_CONFIRM' => '¿Está seguro de que desea eliminar este archivo? Esta acción no podrá deshacerse.',
    'LBL_FILE_DELETED' => 'El archivo se ha eliminado correctamente',

    //theme roller
    'LBL_PORTAL_THEME' => 'Tema del Portal',
    'LBL_THEME_PREVIEW' => 'Vista previa del tema del portal',
    'LBL_LOADING_PREVIEW' => 'Cargando vista previa',
    'LBL_RESET' => 'Restablecer',
    'LBL_COLORS' => 'Colores',
    'BorderColor' => 'Color del Borde',
    'NavigationBar' => 'Barra de Navegación',
    'PrimaryButton' => 'Botón Primario',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'Guardar y Desplegar',
    'LBL_RESET_THEME_LNK' => 'Restaurar Tema por Defecto',
    'LBL_RESET_THEME_MODAL_INFO' => '¿Está seguro de que quiere descartar las personalizaciones del tema y sustituirlas por el tema por defecto?',
    'LBL_RESET_THEME_PROCESS' => 'Restaurando Tema por Defecto...',
    'LBL_SAVE_THEME_PROCESS' => 'Guardando Tema...',

    // image loader
    'LBL_SELECT_PHOTO' => 'Seleccionar una imagen',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Funcionalidad de predicción mejorada en Sugar',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Configure sus parámetros de predicción</li><li class="icon-ok">Seguimiento sencillo de las ventas previstas y de la salud de su pipeline</li><li class="icon-ok">Pronóstico basado en las ventas previstas por su equipo de ventas</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'Configure sus parámetros de predicción',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Elija fecha de inicio del ejercicio fiscal</li><li class="icon-ok">Configure los periodos de tiempo para ser anuales o trimestrales </li><li class="icon-ok">Decida cuántos periodos de tiempo futuro o pasado necesita ver en la hoja de trabajo</li><li class="icon-ok">Seleccione rangos de Previsiones para etiquetar Oportunidades como Incluir, Excluir o Upside</li><li class="icon-ok">Seleccione escenarios de previsiones para identificar Previsiones Más Probables, Mejor, y Peor</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'Gestione las Ventas Previstas por su Equipo de Ventas',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Seleccione el periodo de tiempo previsto para revisar las Previsiones</li><li class="icon-ok">Vea las hojas de trabajo de los miembros de su equipo de ventas y realice previsiones ajustadas</li><li class="icon-ok">Observe una alerta en la hoja de trabajo cuando un miembro del equipo de ventas realiza un nuevo pronóstico</li><li class="icon-ok">Guarde su hoja de Previsión como borrador, o confírmela directamente con su gerente</li><li class="icon-ok">Vea el historial de confirmaciones anteriores</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'Gestione las Ventas Previstas por su Equipo de Ventas',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Vea la gráfica de Pareto para el análisis del pipeline atravesando todas las previsiones de ventas de los miembros de su equipo comercial</li><li class="icon-ok">Elija entre Probable, Mejor o Peor pronóstico de ventas y visualícelo</li><li class="icon-ok">Observe las ventas previstas y lo cerca que está su equipo de conseguir la Cuota</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'Gestione sus propias Ventas Previstas',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Seleccione el periodo de tiempo para tu Previsión de Ventas</li><li class="icon-ok">Revise y edite en línea las cantidades y Probabilidades de Ganar para hacer un análisis de distintas posibilidades"</li><li class="icon-ok">Guarde la hoja de Previsión como borrador o entréguela a su superior</li><li class="icon-ok">Vea un historial de confirmaciones</li><li class="icon-ok">Entregue Previsión de Ventas a su superior y vea un historial de confirmaciones anteriores.</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'Gestione sus propias Ventas Previstas',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="icon-ok">Vea la gráfica de Pareto para el análisis de su pipeline y observe sus oportunidades a lo largo del tiempo</li><li class="icon-ok">Elija visualizar la distribución de su pipeline con el Estado de la Venta o con la Probabilidad de Éxito</li><li class="icon-ok">Vea sus ventas previstas y lo cerca que está de alcanzar la Cuota</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Novedades de Sugar',
    'LBL_TOUR_WATCH' => 'Vea Lo Nuevo de Sugar',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="icon-ok">Mejor aspecto, ahora con un tema nuevo y moderno.</li><li class="icon-ok">Módulo Previsión de Ventas aún mejor, ahora con una interfaz del usuario intuitiva y nueva visualización de datos</li></ul>',
    'LBL_TOUR_VISIT' => 'Para obtener más información visite nuestra aplicación',
    'LBL_TOUR_DONE' => '¡Ya está!',
    'LBL_TOUR_REFERENCE_1' => 'Siempre puede consultar nuestro',
    'LBL_TOUR_REFERENCE_2' => 'a través del enlace "Support" en el menú de perfil.',
    'LNK_TOUR_DOCUMENTATION' => 'documentación',
    'LBL_TOUR_CALENDAR_URL_1' => '¿Comparte su calendario SugarCRM con aplicaciones de terceros, como Microsoft Outlook o Exchange? Si es así, tiene una nueva URL. Esta nueva URL es más segura e incluye una clave personal que impedirá la publicación no autorizada de su calendario.',
    'LBL_TOUR_CALENDAR_URL_2' => 'Consulte su nueva URL del calendario compartido.',
    'LBL_TOUR_CUBE' => 'Acceder Cuadro de Mando y Flujo de Actividades',
    'LBL_TOUR_NAV_BAR' => 'Acceder todos los módulos en el menu de Navegación y tomar acciones',
    'LBL_TOUR_NOTIFICATIONS' => 'Haga clic para ver las notificaciones',
    'LBL_TOUR_SEARCH' => 'Seleccione uno o más módulos y busque',
    'LBL_TOUR_AVATAR' => 'Obtenga más detalles sobre la aplicación o Salga',
    'LBL_TOUR_ADD' => 'Cree un registro desde aquí',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'Haga clic para abrir o cerrar el panel inteligente',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'Elija para ver actividades o un listado de registros',
    'LBL_TOUR_LIST_FILTER1' => 'La Barra de Filtro le permite buscar este módulo',
    'LBL_TOUR_LIST_FILTER2' => 'Elija los filtros predefinidos o cree uno nuevo',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'Escriba aquí para realizar la búsqueda basada en el nombre',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'Eleja para editar la fila o tener detalles de la vista previa',
    'LBL_TOUR_RECORD_ACTIONS' => 'Tomar acciones en este registro',
    'LBL_TOUR_RECORD_SUBPANEL' => 'Haga clic en encabezado para expandir y contraer subpanel',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'El nombre de registro se puede actualizar in situ',
    'LBL_TOUR_RECORD_STATUS' => 'Encontrar aquí el estado de nivel de registro',
    'LBL_TOUR_RECORD_SHOWMORE' => 'Haga click para ver más datos sobre el registro',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'Elija entre ver las actividades o los registros relacionados',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'Haga clic para editar cada campo en línea',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'Cree nuevos grupos de Dashlets',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'Asigne un nombre a un grupo de Dashlets',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'Elija quitar un Dashlet o cambie su configuración',
    'LBL_TOUR_INTRO' =>'<h4>Bienvenido a Sugar</h4> Nos gustaría mostrarle algunas de las funciones.  Utilice las flechas < y > en la parte inferior de la pantalla para realizar una visita.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">Novedades</a><p class="details">Descubra los cambios principales de una edición a otra.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Más información acerca de Sugar</a><p class="details">Una amplia biblioteca de formación en una clase virtual, presencial o con cursos multimedia, webinars y tutoriales de vídeo.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">Asistencia</a><p class="details">¿Necesita ayuda, tiene algún problema o quiere darnos alguna sugerencia para mejorar Sugar?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'Ver un listado de registros y tomar registros de acciones.',
    'LBL_TOUR_RECORD_INTRO' => 'Ver detalles de este registro y ver toda la información relacionada.',
    'LBL_TOUR_FORECAST_INTRO' => 'Gestionar pipeline y la Previsión de Ventas.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'Elegir un periodo de tiempo para ver la previsión correspondiente',
    'LBL_TOUR_FORECASTS_COMMITS' => 'Hacer clic para ver commits anteriores',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'Hacer clic para editar la información en línea',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'Revisar intervalo de la Cuota',
    'LBL_TOUR_FORECASTS_CHART' => 'Revisar distribución de la Previsión de Ventas',
    'LBL_TOUR_TOUR' => 'Acceder la Guía en cualquier momento',
    'LBL_TOUR_TAGS_ADD' => 'Haga clic en el campo de etiquetas para agregar y eliminar etiquetas',
    'LBL_TOUR_TAGS_DELETE' => 'Para eliminar una etiqueta, utilice la tecla retroceso o haga clic en el botón [X] en cada etiqueta',
    'LBL_TOUR_RECORD_SAVE' => 'Una vez que esté listo, haga clic en guardar',


    'LBL_FUTURE' => 'Futuro',
    'LBL_REQUIRED_FIELD' => 'Requerido',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'Elemento de la línea de presupuesto',
    'LBL_DISCOUNT_TOTAL' => 'Descuento total',
    'LBL_DISCOUNT_PERCENT' => '% Porcentaje',
    'LBL_DISCOUNT_SELECT' => 'Determina si el descuento es un porcentaje o una cantidad fija',
    'LBL_TAX' => 'Impuestos',
    'LBL_SHIPPING' => 'Envíos',
    'LBL_GRAND_TOTAL' => 'Total general',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'Rellenar automáticamente la dirección de facturación desde el perfil de la cuenta',
    'LBL_QLI_ADD_GROUP' => 'Añadir un grupo',
    'LBL_QLI_COMMENT' => 'Comentario',
    'LBL_SELECT_ACTION' => 'Seleccionar Acción',
    'LBL_QLI_GROUP_NAME' => 'Nombre de Grupo',
    'LBL_GROUP_TOTAL' => 'Total de grupo',
    'LBL_ITEM_NAME' => 'Elemento de la línea',
    'LBL_QLI_DELETE' => '¿Está seguro de que desea eliminar este elemento de línea?',
    'LBL_QLI_COMMENT_DELETE' => '¿Está seguro de que desea eliminar este comentario de línea?',
    'LBL_QLI_GROUP_DELETE' => 'Realmente desea eliminar el grupo {0}? Todos los elementos se trasladarán al grupo predeterminado.',
    'LBL_QLI_GROUP_EMPTY' => 'No hay ningún elemento de línea de presupuesto',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'Opcional',
    'LBL_RELATED_MODULE' => 'Relacionado {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'Relacionado {{{this}}}',
    'LBL_CREATE_MODULE' => 'Crear {{{this}}}',
    'LBL_EDIT' => 'Editar {{{this}}}',
    'LBL_ASSOC' => 'Vincular {{{this}}}',
    'LBL_ASSIGN' => 'Seleccionar {{{this}}}',
    'LBL_EDIT_RELATED' => 'Editar {{{this}}} Relacionado',
    'LBL_CREATE_RELATED' => 'Crear {{{this}}} Relacionado',
    'LBL_ASSOC_EXISTING' => 'Enlace {{{this}}} existente',
    'LBL_SEARCH_ALL' => 'Buscar todos los {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'Buscar todos los registros...',
    'LBL_SEARCH_ALL_MODULES' => 'Buscar todo',
    'LBL_OK' => 'Aceptar',
    'LBL_YES' => 'Sí',
    'LBL_NO' => 'No',
    'LBL_SHOW_NUMBERING' => 'Mostrar numeración de etapas',
    'LBL_HIDE_NUMBERING' => 'Ocultar numeración de las etapas',
    'LBL_CALL_BUTTON' => 'Llamada',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'Correo electrónico',
    'LBL_HONEYPOT' => 'Si usted es una persona real no rellene esto.',
    'LBL_LINK_BUTTON' => 'Enlace',
    'LBL_UNLINK_BUTTON' => 'Desvincular',
    'LBL_MAP_BUTTON' => 'Mapa',
    'LBL_FILE_BUTTON' => 'Archivo',
    'LBL_URL_BUTTON' => 'Web',
    'LBL_WARNING' => 'Aviso',
    'LBL_CONFIRM' => 'Confirmar',
    'LBL_CONFIRMATION_POPUP' => 'Ventana emergente de confirmación',
    'LBL_NO_ACCESS' => '(Sin acceso)',
    'LBL_NO_ACCESS_LOWER' => 'Sin acceso',
    'LBL_NO_FIELD_ACCESS' => 'Sin acceso',
    'LBL_NO_LICENSE_ACCESS' => 'Licencia obligatoria',
    'LBL_VALUE_ERASED' => 'Valor borrado',
    'LBL_VALUE_ERASED_TOOLTIP' => 'Esta información se ha borrado mediante una solicitud de privacidad de datos',
    'LBL_CREATE_RELATED_RECORD' => 'Crear un registro relacionado',
    'LBL_ASSOC_RELATED_RECORD' => 'Vincular un registro existente',
    'LBL_CHOOSE_LINK' => 'Seleccionar el tipo de Enlace',
    'LBL_CHOOSE_PARENT_TYPE' => 'Elegir Tipo de Raíz',
    'LBL_HOME' => 'Inicio',
    'ERR_NO_DOCS' => 'Ningún documento disponible',
    'ERR_NO_RECORDS_SELECTED' => 'No ha seleccionado ningún registro.',
    'LBL_DELETING' => 'Eliminando...',
    'LBL_UNLINKING' => 'Desvinculando...',
    'LBL_UNLINKED' => 'Desvinculado',
    'LBL_LEGAL' => 'Legal',
    'LBL_UPCOMING' => 'Mis Próximas Citas',
    'LBL_RECENTLY_UPDATED' => 'Actualizado Recientemente',
    'LBL_NOTES_SUBPANEL_TITLE' => 'Notas',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'Reuniones',
    'LBL_TASKS_SUBPANEL_TITLE' => 'Tareas',
    'LBL_CALLS_SUBPANEL_TITLE' => 'Llamadas',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'Cuentas',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'Contactos',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'Correos electrónicos',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'Turnos',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'Elementos presupuestados',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'Excepciones de turnos',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'Documentos',
    'LBL_ESCALATIONS' => 'Escaladas',
    'LBL_ESCALATED' => 'Escalado',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'Escaladas',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'Otras escaladas relacionadas',
    'LBL_ESCALATIONS' => 'Escaladas',
    'LNK_SETTINGS' => 'Configuración',
    'LBL_MOBILE_SUPPORT' => 'Asistencia',
    'LBL_MOBILE_SHOW_MORE' => 'Mostrar más...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'Mostrar más...',
    'LBL_MOBILE_NO_RECORDS' => 'Ningún registro encontrado',
    'LBL_MOBILE_SEARCH_TEAMS' => 'Buscar equipos...',
    'LBL_MOBILE_SELECT_TEAMS' => 'Seleccionar Equipos',
    'LBL_MOBILE_WAIT' => 'Espere...',
    'LBL_MOBILE_LOGING_OUT' => 'Espere mientras se cierra la sesión...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'Volver a iniciar sesión',
    'LBL_MOBILE_META_SYNC_FAILED' => 'No ha sido posible sincronizar con el servidor.',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'No es posible sincronizar con el servidor. ¿Volver a intentarlo?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'Privacidad, Términos y Condiciones',
    'LBL_MOBILE_APP_VERSION' => 'Versión de la Aplicación',
    'LBL_MOBILE_SERVER_VERSION' => 'Versión del Servidor',
    'LBL_MOBILE_SERVER_URL' => 'URL del Servidor',
    'LBL_MOBILE_PTR_PULL' => 'Baje para refrescar...',
    'LBL_MOBILE_PTR_RELEASE' => 'Libere para actualizar...',
    'LBL_MOBILE_EDIT_REL' => 'Editar Relación',
    'LBL_MOBILE_DESKTOP' => 'Versión de Escritorio',
    'LBL_MOBILE_DELETE_CONFIRM' => '¿Está seguro de que desea eliminar este registro?',
    'LBL_MOBILE_UNLINK_CONFIRM' => '¿Está seguro de que desea desvincular este registro?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => '¿Le gustaría entrar en su última Llamada?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'Elegir destinatario',
    'LBL_MOBILE_CHOOSE_PHONE' => 'Seleccionar número de teléfono',
    'LBL_MOBILE_CHOOSE_URL' => 'Seleccionar URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'Seleccionar documento',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'Seleccionar ubicación',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'Niguna acción disponible',
    'LBL_MOBILE_FEEDBACK' => 'Feedback',
    'LBL_MOBILE_DOC' => 'Documento',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'Descarga iniciada: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'Descarga completada: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'Cargando archivo...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'Archivo cargado correctamente',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'Preparando imagen...',
    'LBL_CLOSE_SAVE_BUTTON' => 'Cerrar tarea y guardar',
    'LBL_LATER' => 'Después',
    'LBL_USE_HTTPS' => 'Utilice una conexxión segura',
    'LBL_LOADING_FILES' => 'Todavía se está cargando la lista de documentos. Inténtelo de nuevo más tarde',
    'LBL_NEW_WEB_VERSION' => 'Está disponible una nueva versión de esta aplicación para móviles. Desea actualizar?',
    'LBL_SET_FONTSIZE' => 'Tamaño de la fuente',
    'LBL_FONTSIZE_TINY' => 'Muy pequeña',
    'LBL_FONTSIZE_SMALL' => 'Pequeña',
    'LBL_FONTSIZE_NORMAL' => 'Normal (por defecto)',
    'LBL_FONTSIZE_LARGE' => 'Grande',
    'LBL_FONTSIZE_LARGER' => 'Muy Grande',
    'LBL_FONTSIZE_HUGE' => 'Grande',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'Extra grande',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "Error de descarga\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'Más...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...Menos',
    'LBL_OFFLINE_MODE' => 'Modo Offline',
    'LBL_OFFLINE_DELETED' => 'Registro no encontrado.',
    'LBL_OFFLINE_DELETED_RELATED' => 'Registro relacionado no encontrado. Probablemente fue eliminado o desvinculado.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'Descargar sus registros asignados, favoritos y seguidos para tener acceso sin conexión puede llevar su tiempo. Se recomienda una conexión rápida. ¿Quiere continuar?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => '¿Desea descargar ahora sus registros asignados, favoritos y aquellos que sigue para acceder sin conexión? Una conexión rápida se recomienda ya que esta operación puede llevar algún tiempo. Puede descargarlos más adelante desde el menú principal> Offline (Sin Conexión).',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'Registros descargados satisfactoriamente',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'Descargar sus registros...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'Error mientras la descarga de registros',
    'LBL_OFFLINE_PREFETCHING' => 'Cargando registros...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'Cargando {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'El tiempo que queda es {{estimatedTime}}s...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => 'Carga de {{module}} completada',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'Limpiando almacenamiento...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'Limpieza completada',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => '¿Quiere retirar este cambio?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'Retiro completado',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'Retiro fallado',
    'LBL_OFFLINE_CLEAR_DB' => 'Limpiar almacenamiento...',
    'LBL_OFFLINE_COMPACT_DB' => 'Almacenamiento Compacto...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'Esta acción eliminará los registros a los que no ha accedido en mucho tiempo. ¿Continuar?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => '¿Desea eliminar todos los registros desde el almacenamiento local?',
    'LNK_OFFLINE_SETTINGS' => 'Fuera de línea',
    'LBL_OFFLINE_SETTINGS' => 'Eliminación de incidencias de configuraciones',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'Ningún cambio pendiente de sincronización.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'Los cambios están pendientes de sincronización.',
    'LBL_OFFLINE_STATUS_ONLINE' => 'El Dispositivo está conectado.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'El Dispositivo está desconectado.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'No se ha podido conectar al servidor.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'El último intento de sincronizar ha fallado. Comprobar el historial de transacciones.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'Sincronización en progreso...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'Transacción sincronizada.',
    'LBL_OFFLINE_ENABLE_PROMPT' => '¿Está seguro de que desea activar la asistencia sin conexión?',
    'LBL_OFFLINE_DISABLE_PROMPT' => '¿Está seguro de que desea desactivar la asistencia sin conexión? Todos los cambios pendientes de sincronización se perderán.',
    'LBL_OFFLINE_ENABLED' => 'Modo sin conexión habilitado',
    'LBL_OFFLINE_DISABLED' => 'Modo sin conexión deshabilitado',
    'LBL_OFFLINE_STATS' => 'Estadísticas de almacenamiento',
    'LBL_OFFLINE_SERVER_FETCH' => 'Recogiendo del servidor...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'Alguien ha editado el mismo registro en el servidor. Confirme para auto-combinar los cambios o rechace para descartarlos.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'Último intento de sincronizar: {{ts}}',
    'LBL_ACTION_UPDATE' => 'ACTUALIZAR',
    'LBL_ACTION_CREATE' => 'CREAR',
    'LBL_ACTION_DELETE' => 'ELIMINAR',
    'LBL_ACTION_LINK' => 'VINCULAR',
    'LBL_ACTION_UNLINK' => 'DESVINCULAR',
    'LBL_ACTION_FAVORITE' => 'FAVORITO',
    'LBL_ACTION_FOLLOW' => 'SEGUIR',
    'LBL_ACTION_CREATE_EXPLANATION' => 'Crear {{module}} "{{name}}"',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'Actualizar {{module}} "{{name}}"',
    'LBL_ACTION_DELETE_EXPLANATION' => 'Eliminado {{module}} "{{name}}"',
    'LBL_ACTION_LINK_EXPLANATION' => 'Vinculado {{module}} "{{name}}" a {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'Desvinculado {{module}} "{{name}}" de {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'Seguido {{module}} "{{name}}"',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'No seguido {{module}} "{{name}}"',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'Favorito {{module}} "{{name}}"',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'No favoritos {{module}} "{{name}}"',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'Creado {{module}} "{{name}}" relacionado con {{relatedModule}} "{{relatedName}}"',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'Principal',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'Dar de baja',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'Optar Inclusión',
    'LBL_EMAIL_ACTION_SET_VALID' => 'Válido',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'No válido',
    'LBL_ROLLBACK_BUTTON' => 'Reducción',
    'LBL_TX_LOG' => 'Log de Transacciones',
    'LBL_TX_LOG_DETAIL' => 'Detalles de la Transacción',
    'LBL_RECORD_DELETED' => '(Registro eliminado)',
    'LBL_NOT_AVAILABLE' => 'N/D',
    'LBL_FILE_SIZE' => 'Tamaño del archivo',
    'LBL_FILE_SIZE_UNITS_B' => 'Bytes',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'Seleccione elementos',
    'LBL_OFFLINE_DB_SIZE' => 'Tamaño de la base de datos',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'Registros por módulo',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'Número total de registros',
    'LBL_RECORD_NOT_FOUND' => 'Registro no encontrado.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'Registro relacionado no encontrado.',
    'LBL_NOT_AUTHORIZED' => 'No está autorizado para ver a este registro.',
    'LBL_MOBILE_PROCESSING_FILE' => 'Preparando el archivo...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'Software de Terceros',
    'LNK_TERMS_OF_USE' => 'Términos de uso',
    'LNK_PRIVACY_POLICY' => 'Política de privacidad',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'Inicio de sesión único',
    'LBL_RECENTS' => 'Recientes',
    'LBL_SHOWING_CACHED_DATA' => 'No se puede conectar con el servidor. Se muestran los últimos datos disponibles ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'Cerrar {{moduleSingular}} y guardar',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'Cuadro de mandos específico',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Módulo específico',
    'LBL_MOBILE_DEFAULT_VIEW' => 'Pantalla de inicio',
    'LBL_MOBILE_DEFAULT_MODULE' => 'Módulo seleccionado',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'Cuadro de mandos seleccionado',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'Dashlet seleccionado',
    'LBL_ALL_DASHLETS' => 'Todos los Dashlets',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'Búsqueda global',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Escriba @ para mencionar un usuario. Escriba # para mencionar un registro.',
    'LBL_MOBILE_NEW_COMMENT' => 'Nuevo comentario',
    'LBL_RECENTLY_VIEWED' => 'Visto recientemente',
    'LBL_FILE_STORED_LOCALLY' => 'El archivo está guardado en el almacenamiento local y se sincronizará una vez el dispositivo esté en línea.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'Si desea cambiar determinados campos que no son editables, póngase en contacto con Administrador para notificar estos cambios.',
    'LBL_ACTIVITY_POST' => '{{{value}}}en {{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'Sin comentarios',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'Mostrar los siguientes {{{commentsLeft}}} comentarios',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'Contraer',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'Confimar creación de comentarios',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'El registro de comentarios no puede estar vacío',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'Descargar {{{pdfTemplateName}}} PDF',

    'ERR_SYNC_FAILED' => 'No ha sido posible sincronizar con el servidor.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'Acceso no autorizado.',
    'ERR_MOBILE_INVALID_CREDS' => 'Usuario o contraseña no válido.',
    'ERR_MOBILE_SESSION_EXPIRED' => 'Su sesión ha caducado',
    'ERR_MOBILE_NOT_FOUND' => 'Recurso no encontrado',
    'ERR_MOBILE_TIMEOUT' => 'El servidor no responde.',
    'ERR_MOBILE_CONNECTION_FAILED' => 'No se puede conectar al servidor.',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'Conexión a Internet no disponible',
    'ERR_MOBILE_INTERNAL' => 'Error interno ({{{code}}}). Inténtelo de nuevo más tarde.',
    'ERR_MOBILE_VALIDATION' => 'El registro no es válido',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'Server Flavor Incompatible: {{{flavor}}}. Flavors compatibles: {{{flavorsCompatibles}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'Versión del servidor incompatible: {{{version}}}. Versión mínima requerida: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'Error: Dirección de email incorrecta.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'Este tipo de documento no es compatible.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'Fallo en la autenticación.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'Recurso solicitado no encontrado.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'Error interno en el servidor.',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'Prohibido.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'Servicio no disponible.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'Se ha producido un error inesperado.',
    'ERR_MOBILE_UPLOAD' => 'Error durante la carga del archivo',
    'ERR_MOBILE_FILE_PROCESSING' => 'Error de procesado del archivo',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'Almacén del equipo no disponible',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'La aplicación está caducada y ya no es compatible con la instancia {{{brandName}}} con la que está intentando conectar. ¿Quiere descargar la versión actualizada de la App Store?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'La configuración del servidor ha cambiado y es necesario volver a cargarla. ¿Continuar?',
    'ERR_MOBILE_CONFLICT' => 'Alguien ha editado el mismo registro en el servidor. Confirme para auto-combinar los cambios o rechace para descartarlos.',
    'ERR_MOBILE_METADATA_CHANGED' => 'La configuración del servidor se ha modificado.',
    'ERR_MOBILE_FILE_READ' => 'Fallo en la lectura del archivo',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'Archivo no encontrado',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'El archivo no se puede leer',
    'ERR_MOBILE_FILE_ABORTED' => 'Operación Read abortado',
    'ERR_MOBILE_FILE_SECURITY' => 'El archivo está bloqueado',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'La versión móvil no es compatible con esta funcionalidad. ¿Quiere abrir la versión de escritorio?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'El archivo es demasiado grande. El tamaño máximo permitido es {{size}}',
    'ERR_OFFLINE' => 'Error Offline',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'Error al abrir el almacenamiento local',
    'ERR_OFFLINE_STORAGE_CREATE' => 'Error al crear almacenamiento local',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'Error al crear almacenamiento local: se ha quedado sin espacio.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'Se ha quedado sin espacio en el almacenamiento local',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'La limpieza de la base de datos ha fallado.',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'No hay espacio para almacenar sin conexión. Se recomienda una limpieza del almacén. Esto puede tardar varios minutos.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'Error en la recogida de registros del servidor',
    'ERR_OFFLINE_SYNC_ERROR' => 'Error en la sincronización',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'Conflicto en la sincronización',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'Error en recoger tiempo del servidor',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'Error al activar el modo fuera de línea. No se puede conectar con el servidor.',
    'LBL_EXPORT_CSV' => 'Exportar CSV',
    'LBL_ERR_EXPORTING_CSV' => 'Error de exportación',
    'LBL_ERR_EXPORT_ALL' => 'Error al recoger los datos para los registros seleccionados, vuelva a intentarlo',
    'LBL_LIST_SETTINGS_RESTORE' => 'Restaurar preferencias por defecto',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => '¿Quiere restaurar los campos?',
    'LBL_LIST_SETTINGS_TITLE' => 'Generador de vista de lista',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'Campos disponibles',
    'LBL_LIST_SETTINGS_REMOVE' => 'Eliminar',
    'LBL_LIST_SETTINGS_TEXT' => 'Arrastre los campos al generador de vista de lista y reordénelos para diseñar la vista de lista de {{moduleName}}.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'Se debe añadir al menos un campo al diseño.',
    'LBL_LIST_SETTINGS_EMPTY' => 'No hay campos disponibles',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'No se han encontrado campos coincidentes',
    'LBL_LIST_FILTER' => 'Búsqueda de campo',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'Cliente de correo electrónico',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'Cliente de correo electrónico externo',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Cliente de correo electrónico de Sugar',
    'LBL_OFFLINE_CAPABILITIES' => 'Habilitar capacidades sin conexión',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'Error al suprimir la transacción.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'Transacción suprimida.',
    'LBL_SECURE_MODE' => 'Modo de seguridad mejorada',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'Habilite este ajuste para ocultar los contenidos de Sugar Mobile cuando la aplicación esté en segundo plano y para evitar capturas de pantalla de la aplicación en cualquier momento.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'Habilite este ajuste para ocultar los contenidos de Sugar Mobile cuando la aplicación esté en segundo plano.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'Modo siempre sin conexión',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'Está trabajando en el modo siempre sin conexión. ¿Quiere volver a conectarse?',
    'LBL_RECONNECT' => 'Volver a conectarse',
    'LBL_STAY_OFFLINE' => 'Mantenerse sin conexión',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'El módulo al que intenta acceder no está disponible en Sugar Mobile.',
    'LBL_MOBILE_RELEASE_NOTE' => 'Sugar Mobile para las notas de lanzamiento de {{platform}}',
    'LBL_MOBILE_USER_GUIDE' => 'Sugar Mobile para la guía del usuario de {{platform}}',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'contiene estas palabras',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'no incluye estas palabras',
    'LBL_NOTIFICATIONS_CHANNEL' => 'Actualizaciones',
    'LBL_APPLY_BUTTON_LABEL' => 'Aplicar',
    'LBL_ACTION_CREATE_FAILURE' => "Error al guardar el registro:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "Error al actualizar el registro: \n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'Error al resolver los cálculos de campos en el servidor.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'Los siguientes campos no son válidos: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>Correcto.</b> Ha creado el {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}" de manera correcta.</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>Correcto.</b> Ha actualizado el registro de manera correcta',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'Error al obtener los datos de correo electrónico del servidor.',
    'LBL_ASSIGN_SUCCESS' => '<b>Correcto.</b> El registro se ha asignado a {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => '¿Quiere guardar este correo electrónico como borrador?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'Guardar como borrador',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'Descartar correo electrónico',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'Si no guarda el borrador, perderá este correo electrónico.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'Seleccionar firma',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'Seleccionar plantilla de correo electrónico',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'La plantilla sobrescribirá todos los contenidos de este correo electrónico. ¿Seguro que quiere usar esta plantilla y sobrescribir el contenido?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'Redactar correo electrónico',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'Su correo electrónico contiene variables que se reemplazarán con valores del registro Relacionado con. Confirme que el campo Relacionado con esté configurado de manera correcta antes de enviarlo.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'No se ha encontrado ninguna cuenta de correo electrónico saliente. Póngase en contacto con su administrador de Sugar.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' y {{{count}}} más',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'Añada un correo electrónico',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'Escriba un nombre de contacto o correo electrónico',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (Nuevo correo electrónico)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'Variables',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'Plantillas de correo electrónico',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'Plantillas de campaña',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'Plantillas de flujo de trabajo',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'Plantillas de sistema',
    'LBL_FILTER_EDIT' => 'Editar filtro',
    'LBL_FILTER_MY_FILTER' => 'Mi filtro',
    'LBL_FILTER_MY_FILTER_BY' => 'Mi filtro por {{{filters}}}',
    'LBL_FILTER_SAVE' => 'Guardar filtro',
    'LBL_SELECT_PARAM' => 'Seleccionar',
    'LBL_SELECT_MODULES' => 'Selector de módulos',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'Seleccionar parámetro adicional',
    'LBL_FILTER_TEMPORARY' => 'Filtro temporal',
    'LBL_ERROR_FILE_UPLOAD' => 'Error al cargar {{{fieldLabel}}} archivo "{{{fileName}}}". {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">Ver registro fallido</a>',
    'LBL_FILE_UPLOAD_ONE' => 'Guardando archivo...',
    'LBL_FILE_UPLOAD_MANY' => 'Guardando archivo {{{index}}} de {{{total}}}...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'Configuración de notificación',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'Gestione sus notificaciones push',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "Controle cómo aparecen las notificaciones con la configuración de notificación de su dispositivo.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'Asignaciones',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'Reciba asignaciones cuando se le asignen registros.',
    'LBL_NOTIFICATION_MENTIONS' => 'Menciones',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'Reciba notificaciones cuando se le mencione en entradas de registros de comentarios.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'El campo Registro de comentarios no se ha añadido a este diseño por un administrador. Póngase en contacto con su administrador de Sugar.',
    'ERR_NO_PERMISSION_TITLE' => 'Permita el acceso',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} necesita el acceso a la cámara para que pueda adjuntar fotos. Permita el acceso a la cámara en la configuración de sistemas.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'Configuración',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'Duración',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'Tiempo restante',
    'LBL_LIST_SUPPORT_EXPIRES' => 'Caduca',
    'LBL_CASCADE_RLI_EDIT' => 'Crear elementos de una línea de ingreso abierta',
    'LBL_MOBILE_CALENDAR' => 'Calendario',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'Configuración de calendario',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'Día de inicio de la semana',
    'LBL_MOBILE_CALENDAR_MODULES' => 'Eventos para mostrar',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}horas:{{{minutes}}} minutos',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} horas',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} minutos',
    'LBL_MOBILE_CALENDAR_TODAY' => 'Hoy',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => 'Añadir {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'Programar una actividad',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'Habilite al menos un tipo de evento.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'Todo el día',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'Error al cargar Calendarios.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'Esta acción no está disponible en Sugar Mobile. ¿Quiere abrir la aplicación de escritorio en su lugar?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'Seleccionar plantilla',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'Combinar',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'Error: Faltan datos EXIF del archivo HEIC',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'Error: Resolución de imagen demasiado alta',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'Error: No se puede procesar la imagen',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'Error: Error al generar la imagen en el lienzo',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'Error: Error al cargar el archivo como imagen',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1 elemento seleccionado',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} elementos seleccionados',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'Seleccionar todo',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'Ha seleccionado {{{count}}} registros en esta vista. ¿Quiere seleccionar todos los registros?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'Seleccionar {{{count}}} registros',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => '¿Seguro que quiere suprimir los registros seleccionados?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'Suprimiendo… {{{count}}} de {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'No se ha encontrado ningún correo electrónico válido en los registros seleccionados',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'Aspecto',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'Utilizar configuración del sistema',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'Claro',
    'LBL_MOBILE_APP_THEME_DARK' => 'Oscuro',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'Nombre del nuevo archivo',
    'LBL_ATTACHMENT_RENAME_MSG' => 'Cambiar el nombre del archivo',
    // Filters related
    'LBL_CREATED_BY_ME' => 'Creado por mí',
    'LBL_OPERATOR_ONE_OF' => 'es uno de',
    'LBL_OPERATOR_NOT_ONE_OF' => 'no es uno de',
    'LBL_OPERATOR_CONTAINS' => 'es cualquiera de',
    'LBL_OPERATOR_CONTAINS_WORD' => 'contiene',
    'LBL_OPERATOR_NOT_CONTAINS' => 'no es ninguno de',
    'LBL_OPERATOR_EMPTY' => 'está vacío',
    'LBL_OPERATOR_NOT_EMPTY' => 'no está vacío',
    'LBL_OPERATOR_MATCHES' => 'coincide exactamente',
    'LBL_OPERATOR_STARTS_WITH' => 'comienza por',
    'LBL_OPERATOR_EQUALS' => 'es igual a',
    'LBL_OPERATOR_NOT_EQUALS' => 'no es igual a',
    'LBL_OPERATOR_GREATER_THAN' => 'es mayor que',
    'LBL_OPERATOR_LESS_THAN' => 'es menor que',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'es mayor que o igual a',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'es menor que o igual a',
    'LBL_OPERATOR_BETWEEN' => 'está entre',
    'LBL_OPERATOR_BEFORE' => 'antes',
    'LBL_OPERATOR_AFTER' => 'después',
    'LBL_OPERATOR_YESTERDAY' => 'ayer',
    'LBL_OPERATOR_TODAY' => 'hoy',
    'LBL_OPERATOR_TOMORROW' => 'mañana',
    'LBL_OPERATOR_LAST_7_DAYS' => 'últimos 7 días',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'próximos 7 días',
    'LBL_OPERATOR_LAST_30_DAYS' => 'últimos 30 días',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'próximos 30 días',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'Hace más de __ días',
    'LBL_OPERATOR_LAST_X_DAYS' => 'Últimos __ días',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'Próximos __ días',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'Más de __ días en el futuro',
    'LBL_OPERATOR_LAST_MONTH' => 'mes pasado',
    'LBL_OPERATOR_THIS_MONTH' => 'este mes',
    'LBL_OPERATOR_NEXT_MONTH' => 'el mes que viene',
    'LBL_OPERATOR_LAST_YEAR' => 'último año',
    'LBL_OPERATOR_THIS_YEAR' => 'este año',
    'LBL_OPERATOR_NEXT_YEAR' => 'próximo año',
    'LBL_OPERATOR_IS' => 'es',
    'LBL_OPERATOR_IS_NOT' => 'no es',
    'LBL_OPERATOR_AFTER_TODAY' => 'después de hoy',
    'LBL_OPERATOR_BEFORE_TODAY' => 'antes de hoy',
    'LBL_ERROR_FILTER_EMPTY' => 'Añada los criterios del filtro.',
    'LBL_ADD_FILTER' => 'Añadir criterios',
    'LBL_FILTER_NAME' => 'Nombre del filtro',
    'LBL_FILTER_FIELD' => 'Campo',
    'LBL_FILTER_OPERATOR' => 'Operador',
    'LBL_FILTER_VALUE' => 'Valor',
    'LBL_FILTER_SYNC_TO_SERVER' => 'Guardar en la aplicación de escritorio',
    'LBL_FILTER_LOCAL' => 'Filtro local',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'Bienvenido a {{{brandName}}}.<br/><br/> Permítanos destacar algunas novedades interesantes...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'Navegación de menu principal.',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'Acciones disponibles por vista.',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'Búsquedas globales de registros.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'Filtrar el listado para mostrar mis registros favoritos',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'Filtrar el listado para mostrar mis registros asignados',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'Registros marcados como favoritos.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'Mis próximos eventos comenzando por hoy.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'Registros modificados más recientemente.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'Acciones disponibles en un registro.',
    'LBL_MOBILE_TUTORIAL_HOME_END' => '¡Disfrute de las nuevas funcionalidades!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'Este es el menú adicional.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'Cerrar el menú adicional.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'Seleccionar la acción específica para ver para desempeñar.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'Esto es el menú inicial.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'Cerrar el menú inicial.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'Ver un módulo concreto.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'Personalizar su aplicación.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'Abrir Sugar en el navegador.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'Ver su perfil.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'Esta es la página de detalle.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'La información más importante de un registro.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'Ver información addional o editar un registro.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'Acciones disponibles en un registro.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'Ir a la página anterior.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'Acceda a la visita en cualquier momento.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'Volver.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'Haga clic para abrir un registro relacionado.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'Seguir/Dejar de seguir un registro.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'Haga clic para ampliar la información de un detalle.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'Vista del menú principal.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'El menú principal se abre a la izquierda de la pantalla.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'Vista Detallada',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'La vista de detalle se abre a la derecha de la pantalla.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'Utilice las flechas siguientes para realizar una vísita rápida de los componentes principales de este menú.',

    'LBL_COMMENT_ADD' => 'Añadir un comentario',
    'LBL_REQUIRED' => 'Requerido',
    'LBL_MORE_BUTTON' => 'Más',
    'LBL_NO_OPTIONS' => 'No hay opciones disponibles',
    'LBL_TRY_AGAIN' => 'Pruebe de nuevo',
    'LBL_NEW_RECORDS' => 'Creado recientemente',
    'LBL_ASSIGNED_TO_ME' => 'Mis {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'Todos los {{{module}}}',
    'LBL_UNFAVORITE' => 'Eliminar de favoritos',
    'LBL_ACTIVITY_CREATE' => '{{{record}}} {{{module}}} creado',
    'LBL_ACTIVITY_UPDATE' => 'Se han actualizado los {{{changes}}} en {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => 'Se ha vinculado el {{{relatedRecord}}} al {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => 'Se ha desvinculado el {{{relatedRecord}}} del {{{record}}} {{{module}}}',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} para {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'Descargar los registros relacionados...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'Ha cambiado la configuración de su cuadro de mando. ¿Desea volver a cargar?',
    'LBL_RECORDS' => 'Registros',
    'LBL_DASHBOARDS' => 'Cuadros de mando',
    'LBL_TEMPLATES' => 'Plantillas',
    'LBL_NON_TEMPLATES' => 'No plantillas',
    'LBL_IS_TEMPLATE' => 'Es plantilla',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'Su selección contiene plantillas de cuadros de mando, que no se pueden actualizar de forma masiva. Anule la selección de las plantillas para continuar.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'Su selección contiene plantillas de cuadros de mando, que no se pueden eliminar de forma masiva. Anule la selección de las plantillas para continuar.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'Buscar {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'Menú principal',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'Crear rápidamente un nuevo registro',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'Deslice para ver más opciones',
    'LBL_DETAILS' => 'Detalles',
    'LBL_DETAIL_RELATED' => 'Relacionado',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'Este {{module}} requiere un {{relatedModule}}.<a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>Cree un registro de {{relatedModule}}</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'Editar registro',
    'LBL_OFFLINE_MENU_SETTINGS' => 'Configuración sin conexión',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'Eliminación de incidencias de configuraciones',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'Registros totales',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'Última descarga',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'No se ha podido descargar el archivo.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'No se han podido cargar cuadros de mando del servidor',
    'ERR_FILTERS_FETCHING' => 'No se pueden recuperar sus filtros',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'No se ha podido encriptar el almacenamiento local',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'Encriptando los datos sin conexión. Esto puede tardar varios minutos.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'Encriptación de datos sin conexión completada.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'No tiene acceso al módulo {{{module}}}.',
    'LBL_SKIP' => 'Omitir',
    'LBL_CONTINUE' => 'Continuar',
    'LBL_ENABLE' => 'Habilitar',
    'LBL_MOBILE_TRIAL_UNTIL' => 'Prueba hasta',
    'LBL_MOBILE_SDK_VERSION' => 'Versión de SDK',
    'LBL_LOG_LEVEL' => 'Nivel de Registro',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'Se han reconfigurado los ajustes de inicio de sesión.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'Su período de prueba ha caducado.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'El servidor no es compatible con la conexión segura. Desactive la conexión segura.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'El servidor es compatible con la conexión segura. Active la conexión segura.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'Su conexión no es segura. Póngase en contacto con su administrador.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'Ajustes de inicio de sesión',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'Configure su instancia de {{{brandName}}}',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'Para que la aplicación funcione, deberá introducir la URL de la instancia de {{{brandName}}}. Si no tiene la URL de la instancia, póngase en contacto con su administrador.',
    'LBL_FACEID' => 'Identificación facial',
    'LBL_TOUCHID' => 'Touch ID',
    'LBL_ENABLE_TOUCHID' => 'Habilitar {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => 'Configurar {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'Inicie sesión con el dedo',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} no está configurado en su dispositivo. \n\nVaya a los ajustes de su dispositivo para configurar {{{biometryType}}}. Una vez esté configurado, habilite {{{biometryType}}} para {{{brandName}}} en Menú principal > Ajustes.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'El uso de {{{biometryType}}} con {{{brandName}}} le permitirá usar su identificador biométrico en lugar de introducir su contraseña para acceder a {{{brandName}}}.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => '¿Le gustaría proceder con {{{biometryType}}}?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'Introduzca la contraseña de {{{brandName}}} para habilitar {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'Configuración',
    'LBL_MDM_CONFIRM_CHANGE' => 'La configuración de la aplicación ha cambiado desde el Administrador de dispositivos móviles. Inicie sesión de nuevo para aplicar los cambios.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'Permita el acceso de {{{brandName}}} a su ubicación desde los ajustes de su dispositivo.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'La ubicación actual no está disponible',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "La recuperación de la ubicación actual ha superado el tiempo de espera. \nInténtelo de nuevo.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'Los marcadores de ubicación no están disponibles',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'Las coordenadas de ubicación no son válidas',
    'ERR_MOBILE_INVALID_PASSWORD' => 'Contraseña no válida.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'Su aplicación no está actualizada, y ya no es compatible con la instancia de {{{brandName}}} a la que está conectado. ¿Desea actualizarla?',
    'LBL_MOBILE_BY' => 'Por',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'Este filtro no está disponible sin conexión',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'Registros sin conexión',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'Ajustes de descarga',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'Descargue sus registros asignados, favoritos y seguidos para acceder a ellos sin conexión. Puede actualizar sus preferencias en ajustes sin conexión.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'Sus registros han acabado de descargarse. Ahora puede acceder a ellos en modo sin conexión.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "No se han descargado todos sus registros.\n ¿Desea intentarlo de nuevo?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'Usar datos móviles',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'No en este momento',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'La descarga se ha pausado y continuará cuando vuelva a abrir la aplicación.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'Descargando {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'Actualizar los últimos registros',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'Esperando conexión',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'Pausado',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'Detenido',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'Descargar',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'Pausar',
    'LBL_BULK_LOAD_BTN_RESUME' => 'Reanudar',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'Por defecto solo se usa la conexión WiFi',
    'LBL_NPS_RATING_MSG' => "¿Cómo calificaría su experiencia con \n{{{productName}}}?",
    'LBL_NPS_THANKS_MSG' => '¡Gracias por sus comentarios!',
    'LBL_NPS_APPSTORE_RATE_MSG' => '¿Le importaría valorarla en la App Store?',
    'LBL_NPS_NO_THANKS' => 'No, gracias',
    'LBL_NPS_NOT_NOW' => 'Ahora no',
    'LBL_NPS_RATE_NOW' => 'Valorar ahora',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'La red no está disponible. Puede seguir usando la aplicación mientras está sin conexión',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'Sus cambios se sincronizarán cuando esté conectado. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>Consulte los detalles</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'Hay datos sin sincronizar. Consulte el <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>registro de transacciones</a>',
    'LBL_CONVERT' => 'Convertir',
    'LBL_CONVERT_LEAD' => 'Convertir Cliente Potencial',
    'LBL_SEARCH_EXISTING_RECORD' => 'Buscar {{{this}}} existente',
    'LBL_DUPLICATES_CHECK_FAILED' => 'Ha fallado la comprobación de duplicados',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => '¿Desea mover las actividades relacionadas al registro de contacto?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'Ha convertido correctamente el cliente potencial {{{name}}}',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'No se han encontrado duplicados.',
    'ERR_LEAD_CONVERSION_FAIL' => 'Ha fallado la conversión de duplicados',
    'LBL_SELECT_DUPLICATE_RECORD' => 'Seleccione entre los {{{modulePlural}}} duplicados',
    'LBL_SELECTED_EXISTING_RECORD' => '{{{moduleSingular}}} seleccionado',
    'LBL_CREATED_NEW_RECORD' => 'Se ha creado un nuevo {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => 'Botón Atrás',
    'LBL_VO_HOME_BTN' => 'Botón de Inicio',
    'LBL_VO_DASHBOARD_BTN' => 'Botón de cuadro de mando',
    'LBL_VO_SEARCH_BTN' => 'Botón de búsqueda',
    'LBL_VO_RIGHT_MENU_BTN' => 'Botón derecho del menú',
    'LBL_VO_ADD_BTN' => 'Añadir botón',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'Descuento',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'Seleccione una aplicación de asignación',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'La {{entityName}} seleccionada tiene valores relacionados: {{localizedFieldNames}}. Cancele para mantener los valores existentes. Confirme para sobrescribir con los nuevos valores.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'El cifrado de datos está habilitado.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'El cliente potencial seleccionado ya se ha convertido.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'Esta acción solo está disponible cuando el dispositivo está en línea',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => '¿Está seguro de que desea crear una Oportunidad a partir del Presupuesto?',
    'LBL_TAG_ADD' => 'Añadir etiqueta',
    'LBL_TAG_ENTER_TAG_NAME' => 'Introducir etiqueta',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'El filtrado por Etiquetas no está disponible cuando el dispositivo está sin conexión.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'Mostrar todo el comentario',
    'LBL_COMMENT_VIEW' => 'Ver un comentario',
    'LBL_PMSE_LABEL_DUEDATE' => 'Fecha de vencimiento',
    'LBL_PMSE_DUE' => 'Vencimiento',
    'LBL_PMSE_DUE_ON' => 'Vence el',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'Cree primero el {{conversionParentModuleName}}',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'Faltan registros obligatorios: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'Escoja la calidad de la imagen. La imagen se redimensionará de acuerdo con esto antes de guardarla en el servidor. El valor seleccionado se utilizará como predeterminado para operaciones similares en el futuro.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'Estimando el tamaño del archivo...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'El tamaño estimado del archivo es',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'Calidad de la imagen',
    'LBL_IMAGE_QUALITY_BEST' => 'Tamaño original',
    'LBL_IMAGE_QUALITY_GOOD' => 'Buena calidad',
    'LBL_IMAGE_QUALITY_POOR' => 'Tamaño reducido',
    'LBL_IMAGE_QUALITY_BTN' => 'Compresión: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'Lista de campos en {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'Restaurar preferencias por defecto',
    'LBL_LIST_NOT_ENOUGH' => 'Establezca al menos 1 campo activo.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'Debe iniciar sesión y aceptar los permisos para poder trabajar con la instancia de SugarCRM.',
    'LBL_SELECTING_EXISTING_RECORD' => 'Seleccionando {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'Creando un nuevo {{{moduleSingular}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'Tamaño de la imagen',
    'LBL_COPY_ADDRESS' => 'Copiar dirección',
    'LBL_OPEN_IN' => 'Abrir en',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'Ningún archivo seleccionado.',
    'LBL_ATTACHMENT_ADD' => 'Adjuntar',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'Esta aplicación utiliza cookies',
    'LBL_USE_COOKIES_CONFIRM' => 'Esta aplicación utiliza cookies para ayudar a ofrecerle una mejor experiencia. Si continua, consiente el uso de cookies conforme a nuestra política de privacidad.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'Está utilizando una instancia de Sugar que no será compatible con Sugar Mobile en una próxima versión móvil. Pida a su administrador que actualice Sugar lo antes posible.',
    'ERROR_TAG_NAME_INVALID' => 'El nombre de la etiqueta no puede contener caracteres "{{{forbiddenChars}}}"',
    'ERROR_NO_TAGS_FOUND' => 'No hay etiquetas disponibles que coincidan con "{{{searchQuery}}}"',
    'ERR_PA_RECORD_INVALID' => 'El registro de {{{moduleName}}} tiene uno o más valores no válidos y no se puede guardar. ¿Desea editar el registro para realizar la acción {{{actionLabel}}}?',
    'ERR_MOBILE_METADATA_RELOAD' => 'Un administrador ha realizado cambios en la configuración de su instancia de Sugar. Pulse Aceptar para sincronizar la configuración de su aplicación con el servidor.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'Esta aplicación utiliza cookies',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'Comprobar para aceptar (Obligatorio)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'Esta aplicación utiliza cookies para ayudar a ofrecerle una mejor experiencia. Si continua, consiente el uso de cookies conforme a nuestra <a href="{{href}}" target="_blank">política de privacidad</a>.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'La vista de registro le permite ver los detalles de un registro.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Las notas le permiten colaborar con otros usuarios del portal y miembros del equipo de asistencia.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'Haga clic aquí para añadir una nota a este registro.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'Haga clic en estos iconos para ver los detalles de las notas adjuntas.',

    //for portal
    'LBL_PORTAL_HOME' => 'Cuadro de mando de inicio',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'Todos los casos abiertos',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'Casos resueltos recientemente',
    'LBL_PORTAL_SEARCH' => 'Buscar por Nombre, Número',
    'LBL_SIGNUP_BUTTON_LABEL' => 'Registrarse',
    'LBL_PORTAL_NO_EMAIL' => '¿No ha recibido un correo electrónico?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'He olvidado la contraseña',
    'LBL_PORTAL_FORGOT_USERNAME' => 'He olvidado el nombre de usuario',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'Introduzca su contraseña dos veces. Las contraseñas deben coincidir.',
    'LBL_PORTAL_RESET_PASSWORD' => 'Restablecer contraseña',
    'LBL_PORTAL_REENTER_PASSWORD' => 'Volver a introducir contraseña',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'Las contraseñas no coinciden, vuelva a introducirla',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'Su contraseña se ha restablecido correctamente.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'Se ha producido un error. Inicie una nueva solicitud de restablecimiento de contraseña.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'Registrando',
    'LBL_PORTAL_SIGNUP_TITLE' => 'Gracias por registrarse',
    'LBL_PORTAL_SIGNUP' => 'Le informaremos después de confirmar sus detalles.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'Nombre',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'Apellidos',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'Nombre de usuario',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'Dirección de correo electrónico',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (opcional)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'País:',
    'LBL_PORTAL_SIGNUP_STATE' => 'Estado/Provincia:',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'Nombre de la empresa',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'Profesión (opcional)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'Contraseña',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'Confirmar contraseña',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'He olvidado el usuario',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => '¿Olvidó la contraseña?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'Póngase en contacto con su administrador de Sugar para restablecer su contraseña.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'Nombre de usuario',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'Contraseña:',
    'LBL_PORTAL_LOADING' => 'Cargando',
    'LBL_PORTAL_SAVING' => 'Guardando',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'Página No Disponible',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "Lo sentimos, pero esta característica no está disponible en este momento.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'Muestra los resultados de "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => '¿No ha recibido un correo electrónico?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'Para obtener ayuda o ponerse en contacto con nosotros, utilice cualquiera de los siguientes medios: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'Teléfono: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'Correo elctrónico: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'Web: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => '¿Está seguro de que desea cerrar el chat?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'Crear nota o añadir adjunto',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'Añadir una nota',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'No ha iniciado sesión correctamente. Vuélvalo a intentar.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'Credenciales no válidas',
    'LBL_PORTAL_INVALID_GRANT' => 'Su identificación ha caducado. Inicie sesión de nuevo.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'Sesión caducada',
    'LBL_PORTAL_AUTH_FAILED' => 'Autenticación del Cliente fallida.',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'Cliente no válido',
    'LBL_PORTAL_INVALID_REQUEST' => 'La solicitud es inválida o incorrecta. Póngase en contacto con la asistencia técnica.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'Solicitud no válida',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'Su solicitud ha superado el tiempo de espera.',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'Solicitud fuera de tiempo',
    'LBL_PORTAL_UNAUTHORIZED' => 'Lo sentimos, usted no está autorizado para acceder a este apartado.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'Error HTTP: No Autorizado',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'Recurso no diponible.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'Error HTTP: Prohibido',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'Método HTTP no permitido para este recurso. Póngase en contacto con asistencia técnica.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'Error HTTP: Método No Permitido',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'Solicitud fallida o parámetro que falta/no válido. Póngase en contacto con asistencia técnica',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'Error HTTP:',
    'LBL_PORTAL_MIN_MODULES' => 'Para poder utilizar esta aplicación es necesario que habilite, por lo menos, el módulo de Casos, Gestor de Incidencias o Base de Conocimientos.',
    'LBL_PORTAL_ERROR' => 'Error',
    'LBL_PORTAL_ROUTE_ERROR' => 'Ha surgido un problema cargando el módulo. Inténtelo más tarde o póngase en contacto con la asistencia técnica.',
    'LBL_PORTAL_OFFLINE' => 'Lo sentimos, la aplicación no está disponible en este momento. Póngase en contacto con el administrador del sistema.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'Cambiar Contraseña',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'El nombre de usuario ya está registrado en el sistema. Solicite un restablecimiento de contraseña o seleccione otro nombre de usuario.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'El correo electrónico facilitado no es válido.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'Las contraseñas no coinciden.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'Consola de Servicio',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'Resumen',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'Restaurar cuadro de mando predeterminado',
    'LBL_UNTITLED' => 'Sin título',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'Consola de renovaciones',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'Resumen',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'Etapa/Estado',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'Nombre/Nombre de cuenta',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'Panel de Omnichannel',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'Cliente',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} a las {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'Su navegador no es compatible con SugarLive. Utilice Google Chrome o Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'Se ha creado un <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> que contiene los detalles de su conversación.',
    'LBL_OMNICHANNEL_SUBJECT' => 'Asunto',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'Descripción',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'Resumen del mensaje',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'Resumen de la llamada',
    'LBL_OMNICHANNEL_LINK_TO' => 'Vincular {{fromModule}} a {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'Enlazar a {{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'Vinculado',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'Su navegador no es compatible con el chat. Utilice Google Chrome o Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Póngase en contacto con su Administrador de Sugar para obtener ayuda.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'Configurar el diseño',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'Acabe de configurar SugarLive antes de realizar una llamada saliente.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'Acabe de configurar el diseño de SugarLive antes de abrir SugarLive.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'Establezca su estado de SugarLive en "Sin conexión" antes de configurar el diseño de SugarLive.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'Vista compacta',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'Vista completa',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'Cuadro de mando de BDR',
    'LBL_SALES_MANAGER_CONSOLE' => 'Cuadro de mando del gerente de ventas',
    'LBL_SALES_REP_CONSOLE' => 'Cuadro de mando del representante de ventas',
    'LBL_MARKETING_CONSOLE' => 'Cuadro de mando de marketing',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'Cuadro de mando de éxito del cliente',
    'LBL_EXECUTIVE_CONSOLE' => 'Cuadro de mando ejecutivo',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'Restaurar la pestaña a las preferencias por defecto',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'Configurar el panel de resumen',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'Perfil de usuario',
    'LBL_WIZ_COMPLETE_TITLE' => 'Configuración completada',
    'LBL_SETUP_COMPLETE_INFO' => '¡Comenzar a usar Sugar!',
    'LBL_SETUP_USER_INFO' => 'Configurar información de usuario',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'Configuración local del usuario',
    'LBL_SETUP_USER_LOCALE_INFO' => 'Configurar zona horaria, fecha y formato de nombre',
    'LBL_WIZ_START_SUGAR' => 'Iniciar Sugar',
    'LBL_WIZ_FIRST_NAME' => 'Nombre',
    'LBL_WIZ_LAST_NAME' => 'Apellidos',
    'LBL_WIZ_EMAIL' => 'Correo electrónico',
    'LBL_WIZ_TIMEZONE' => 'Zona Horaria',
    'LBL_WIZ_TIMEFORMAT' => 'Formato de Hora',
    'LBL_WIZ_DATE_FORMAT' => 'Formato de Fecha',
    'LBL_WIZ_NAME_FORMAT' => 'Formato de Nombre',
    'LBL_SETUP_PROGRESS' => 'Progreso de Configuración',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Formación para Sugar',
    'LBL_WIZ_DOCUMENTATION' => 'Documentación',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'Base de conocimiento',
    'LBL_WIZ_FORUMS' => 'Foros',
    'TPL_TIMEZONE_DIFFERENT' => 'La zona horaria de su navegador no coincide con su zona horaria guardada  {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'Ajustar su Zona Horaria.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'Configuración Regional',
    'LBL_WIZ_EMAIL_SETTINGS' => 'Configuración de Email',
    'LBL_WIZ_IMPORT_DATA' => 'Importar datos',
    'LBL_WIZ_CREATE_USERS' => 'Crear usuarios',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'Configuración del Sistema',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Studio',

    'LBL_CSP_ERROR_MESSAGE' => 'Los valores que ha introducido no son compatibles o no tienen un formato aceptable. Para ver una lista de todos los valores y los formatos aceptables para los campos, consulte la documentación de <a href="{{linkToDocumentation}}" target="_blank">Sistema</a>.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'Este contenido no se ha aprobado. Actualice los <a href="{{linkToDocumentation}}" target="_blank">Ajustes de la política de seguridad de contenido</a> de su sistema.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'Este contenido no se ha aprobado. Pida a su administrador que actualice los <a href="{{linkToDocumentation}}" target="_blank">Ajustes de la política de seguridad de contenido</a> de su sistema. Una vez se hayan acutalizado los ajustes, deberá actualizar el navegador para que los cambios tengan efecto.',

    // For password related labels
    'LBL_PASSWORD' => 'Contraseña',
    'LBL_CHANGE_YOUR_PASSWORD' => 'Cambie su contraseña',
    'LBL_PASSWORD_REQUIREMENTS' => 'Requisitos de la contraseña',
    'LBL_CURRENT_PASSWORD' => 'Contraseña actual',
    'LBL_NEW_PASSWORD1' => 'Nueva contraseña',
    'LBL_NEW_PASSWORD2' => 'Confirmar contraseña',
    'LBL_PASSWORD_CHANGED' => 'Ha cambiado la contraseña correctamente',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'Introduzca su confirmación de contraseña.',
    'ERR_ENTER_NEW_PASSWORD' => 'Introduzca su nueva contraseña.',
    'ERR_ENTER_OLD_PASSWORD' => 'Introduzca su actual contraseña.',
    'ERR_REENTER_PASSWORDS' => 'Las contraseñas deben coincidir.',
    'ERR_PASSWORD_MISMATCH' => 'La contraseña introducida no coincide en nuestro sistema.',
    'LBL_CANNOT_SEND_PASSWORD' => 'No ha podido enviarse la contraseña',
    'LBL_REQUEST_PASSWORD' => 'Solicite una contraseña',
    'LBL_RESET_PASSWORD' => 'Restablecer contraseña',
    'LBL_RESET_PASSWORD_MESSAGE' => 'Introduzca su nombre de usuario y le enviaremos un enlace para restablecer la contraseña.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Compruebe su correo electrónico <br><br> Le hemos enviado instrucciones para restablecer la contraseña a la dirección de correo electrónico
        que tenemos archivada.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'Error: Hubo un problema actualizando la contraseña para este usuario.',
    'LBL_INCORRECT_PASSWORD' => 'Error: Contraseña incorrecta',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'La contraseña que ha introducido no cumple con los requisitos de contraseñas. Inténtelo de nuevo.',
    'LBL_PASSWORD_MIN_LENGTH' => 'La longitud mínima es {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'La longitud máxima es {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'Debe contener una letra en mayúsculas (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'Debe contener una letra en minúsculas (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'Debe contener un número (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'Debe contener una carácter especial (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'La contraseña no debe coincidir con un patrón de expresión regular: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'Idioma preferido:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'No se ha podido enviar el correo electrónico para restablecer la contraseña.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'Seleccione un informe',
    'LBL_REPORT_AUTO_REFRESH' => 'Actualización automática',
    'LBL_REPORT_EDIT' => 'Editar informe seleccionado',
    'LBL_REFRESH_LIST_AND_CHART' => 'Actualizar lista y tabla',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'No hay gráfico disponible.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'Este informe no contiene filtros.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'Ha ocultado solo los filtros de tiempo de ejecución, consulte los filtros avanzados.',
    'LBL_RUNTIME_FILTERS' => 'Filtros en tiempo de ejecución',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'La fecha no coincide con el formato de fecha preferido del usuario: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'Este dashlet no tiene filtros de tiempo de ejecución',
    'LBL_DASHBOARD_FILTER_GROUP' => 'Nuevo filtro',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'Necesita seleccionar al menos un valor.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'Restablecer a los filtros por defecto',
    'LBL_COPY_FILTER_SUMMARY' => 'Copiar resumen de filtros',
    'LBL_APPLY_FILTERS' => 'Aplicar',
    'LBL_REPORTS_FILTERS' => 'Filtros',
    'LBL_RUNTIME_FILTERS_INVALID' => 'Los filtros de tiempo de ejecución no se pueden aplicar por valores no válidos',
    'LBL_RUNTIME_FILTERS_COPIED' => 'El resumen de filtros se ha copiado en su portapapeles.',
    'LBL_ADVANCED_FILTERS' => 'Filtros avanzados',
    'LBL_ADVANCED_OR_DESC' => 'Incluir cuando se cumpla CUALQUIER condición',
    'LBL_ADVANCED_AND_DESC' => 'Incluir cuando se cumplan TODAS las condiciones',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'Este es un filtro de diseño original',
    'LBL_AND_UPPERCASE' => 'Y',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'Esta función no está disponible en el modo de vista previa',
    'LBL_REPORT_DEFAULT_NAME' => 'Informe sin título',
    'LBL_REPORT_QUERY' => 'Consulta',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'Relacionado con el registro actual',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'Campo vinculado',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'El campo vinculado no puede estar vacío',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'No se ha seleccionado ningún informe.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'El gráfico de líneas no es compatible con este informe',
    'LBL_REPORT_DASHLET' => 'Dashlet de informes',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'Tabla de datos',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'Filtros en tiempo de ejecución',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'Vista previa de la tabla de datos',
    'LBL_REPORTS_DASHLET_CHART' => 'Gráfico',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'Previsualización del gráfico',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'Previsualización del filtro',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'El informe seleccionado no admite un gráfico.',
    'LBL_REPORTS_DASHLET_LABELS' => 'Etiquetas',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'Mostrar recuento total de registros',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'Orden',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'Vista seleccionada por defecto',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'Orden de clasificación de gráficos principal',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'Orden de clasificación de gráficos secundaria',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'Ningún {{module}} se enlaza al informe seleccionado',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'No disponible para este tipo de informe',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'Esta función solo está disponible en la pestaña gráfico',
    'LBL_REPORTS_CHART_TYPE' => 'Tipo de gráfico',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'Colocación de valores en el gráfico de barras',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'Mostrar total',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'Mostrar leyenda',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Mostrar etiqueta del eje x',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Mostrar etiqueta del eje y',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Límite de visualización de filas',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'No tiene permiso para usar estos filtros de tiempo de ejecución.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'Desconocido',
    'ERR_HTTP_DEFAULT_TITLE' => 'Error desconocido',
    'ERR_HTTP_DEFAULT_TEXT' => 'Error desconocido.',
    'ERR_HTTP_DEFAULT_ACTION' => 'Volver a la página anterior.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'Error: solicitud no válida',
    'ERR_HTTP_400_TEXT_LINE1' => 'El explorador ha enviado una solicitud que el servidor no ha podido comprender.',
    'ERR_HTTP_400_TEXT_LINE2' => 'Póngase en contacto con su Administrador de Sugar para obtener más información.',
    'ERR_HTTP_400_ACTION' => 'Volver a la página anterior.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'HTTP: 404 Not Found',
    'ERR_HTTP_404_TEXT_LINE1' => 'La página no existe o no tiene permiso para acceder a esta página.',
    'ERR_HTTP_404_TEXT_LINE2' => 'Inténtelo de nuevo. Si el error continúa, póngase en contacto con el administrador de Sugar.',
    'ERR_HTTP_404_ACTION' => 'Volver a la página anterior.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: Error de servidor interno 500',
    'ERR_HTTP_500_TEXT_LINE1' => 'El servidor ha encontrado un error y no ha podido completar la solicitud.',
    'ERR_HTTP_500_TEXT_LINE2' => 'Inténtelo de nuevo. Si el error continúa, póngase en contacto con el administrador de Sugar.',
    'ERR_HTTP_500_ACTION' => 'Póngase en contacto con asistencia técnica.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: Error de servidor interno 502',
    'ERR_HTTP_502_TEXT_LINE1' => 'El servidor ha encontrado un error temporal y no ha podido completar la solicitud.',
    'ERR_HTTP_502_TEXT_LINE2' => 'Inténtelo de nuevo. Si el error continúa, póngase en contacto con el administrador de Sugar.',
    'ERR_HTTP_502_ACTION' => 'Póngase en contacto con asistencia técnica.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: Error de servidor interno 503',
    'ERR_HTTP_503_TEXT_LINE1' => 'El servidor no está disponible para completar la solicitud.',
    'ERR_HTTP_503_TEXT_LINE2' => 'Inténtelo de nuevo más tarde. Si el error continúa, póngase en contacto con el administrador de Sugar.',
    'ERR_HTTP_503_ACTION' => 'Póngase en contacto con asistencia técnica.',

    'ERR_RENDER_FAILED_TITLE' => 'Error al procesar la vista',
    'ERR_RENDER_FAILED_MSG' => 'Error al procesar la vista',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'Error al procesar el campo',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'No ha sido posible procesar el campo {0}.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'Acceso Denegado',
    'ERR_NO_VIEW_ACCESS_REASON' => 'No tiene permiso para acceder a esta página.',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'Póngase en contacto con el administrador para solicitar el acceso.',
    'ERR_NO_VIEW_ACCESS_MSG' => 'Póngase en contacto con su administrador para obtener el acceso a esta vista para el módulo {0}.',

    'ERR_LAYOUT_RENDER_TITLE' => 'Error al procesar la disposición de campos.',
    'ERR_LAYOUT_RENDER_MSG' => 'No se ha podido procesar ninguna petición. Inténtelo más tarde o póngase en contacto con la asistencia técnica.',
    'ERR_INTERNAL_ERR_MSG' => 'Error interno',
    'ERR_GENERIC_TITLE' => 'Error',
    'ERR_CONTACT_TECH_SUPPORT' => 'Póngase en contacto con asistencia técnica.',

    'LBL_SYNCED_RECURRING_MSG' => 'No puede editar este registro porque se sincronizó desde un cliente externo.',
    'LBL_EXISTING' => 'Existente',
    'LBL_PANEL_DEFAULT' => 'Por Defecto',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'Respuesta mala del servidor',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'Error durante la acción Asignar a.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'No tiene acceso al módulo de "{{name}}". Póngase en contacto con su Administrador.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'Año {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'Más acciones',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'Alerta',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'Ignorar duplicado y Guardar',
    'LBL_RESTORE' => 'Restablecer al Original',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'Registros marcados para borrar',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'Muestra los registros relacionados con una solicitud de privacidad de datos para '
        . 'Borrar información.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'Fuente RSS',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'Permanezca al día mediante la adición de un canal de información RSS o blog.',
    'LBL_RSS_FEED_URL' => 'URL del canal de información',
    'LBL_RSS_FEED_AUTHOR' => 'Autor:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'Número de entradas que se muestran',
    'LBL_ERR_LOADING_RSS_FEED' => 'Error al cargar el canal de información RSS',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'Mis Elementos',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'Elementos del Equipo',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'Permite a los usuarios agregar aplicaciones de Sugar a un panel de control',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'Historial',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'El dashlet Historial muestra las Reuniones realizadas, llamadas hechas, emails recibidos y emails enviados.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'Correo electrónico',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'Correos electrónicos',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'Mi historial',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'Historial de Equipo',
    'LBL_UNASSIGNED' => 'Sin asignar',
    'LBL_ARCHIVE_EMAIL' => 'Archivar Email',
    'LBL_EMAIL_ARCHIVED' => 'Email archivado',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'Crear correo electrónico archivado',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'Actividades Planificadas',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'El dashlet Actividades Planificadas muestra Reuniones y Llamadas planificadas.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'Hoy',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'Futuro',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'Mis Actividades',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'Actividades del Equipo',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'Realizada',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => '¿Está seguro de que desea marcar {0} como cerrado?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'Tareas activas',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'El dashlet Tareas Activas muestra tareas actualmente caducadas y planificadas.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'Ya Vencidas',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'Próximamente',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'Por Hacer',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'Completado',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => '¿Está seguro de que desea cerrar el {0} como completado?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mis Tareas',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Tareas del equipo',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'Hubo un email adicional en el registro que está modificando. Ahora es el primario y los datos se han introducido abajo.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'Tareas inactivas',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'El dashlet de Tareas muestra Tareas pendientes y completadas.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'Aplazada',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'Completado',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'última modificación {{relativetime}} el {{date}} a las {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mis Tareas',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Tareas del equipo',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'Mis casos vistos recientemente',

    'LBL_REPORT_DASHLET_TITLE_12' => 'Casos abiertos por usuario por estado',
    'LBL_REPORT_DASHLET_TITLE_125' => 'Nuevos casos por Centro de negocios por semana',
    'LBL_REPORT_DASHLET_TITLE_126' => 'Casos creados recientemente',
    'LBL_REPORT_DASHLET_TITLE_127' => 'Nuevos casos por nivel de cliente por semana',
    'LBL_REPORT_DASHLET_TITLE_128' => 'Casos abiertos por nivel de cliente y prioridad',
    'LBL_REPORT_DASHLET_TITLE_129' => 'Casos totales resueltos este mes por Centro de negocios',
    'LBL_REPORT_DASHLET_TITLE_130' => 'Casos totales resueltos este mes por agente',
    'LBL_REPORT_DASHLET_TITLE_131' => 'Lista de casos resueltos recientemente',
    'LBL_REPORT_DASHLET_TITLE_132' => 'Mis casos totales resueltos este mes por semana',
    'LBL_REPORT_DASHLET_TITLE_133' => 'Mis casos pendientes para hoy y vencidos',
    'LBL_REPORT_DASHLET_TITLE_134' => 'Todos los casos pendientes para hoy y vencidos',
    'LBL_REPORT_DASHLET_TITLE_135' => 'Mis casos abiertos por fecha de seguimiento',
    'LBL_REPORT_DASHLET_TITLE_136' => 'Todos los casos abiertos por fecha de seguimiento',
    'LBL_REPORT_DASHLET_TITLE_137' => 'Mis casos abiertos por estado',
    'LBL_REPORT_DASHLET_TITLE_138' => 'Mis casos en la última semana por estado',
    'LBL_REPORT_DASHLET_TITLE_139' => 'Estado de casos abiertos asignados por mí mismo',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP o REST API antiguo',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar Workflow',
    'LBL_AUDIT_SUBJECT_USER' => 'Usuario',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web para el cliente potencial',

    //common chart strings
    'LBL_CHART' => 'Gráfico',
    'LBL_CHART_NO_DATA' => 'No se han encontrado datos.',
    'LBL_CHART_LEGEND_CLOSE' => 'Ocultar leyenda',
    'LBL_CHART_LEGEND_OPEN' => 'Mostrar leyenda',
    'LBL_CHART_CONTROLS_CLOSE' => 'Ocultar controles',
    'LBL_CHART_CONTROLS_OPEN' => 'Mostrar controles',
    'LBL_CHART_UNDEFINED' => 'No definido',
    'LBL_CHART_NO_LABEL' => 'No definido',
    'LBL_CHART_AMOUNT' => 'Cantidad',
    'LBL_CHART_COUNT' => 'Total',
    'LBL_CHART_PERCENT' => 'Porcentaje',
    'LBL_CHART_GROUP' => 'Grupo',
    'LBL_CHART_DATE' => 'Fecha',
    'LBL_CHART_KEY' => 'Clave',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'Tipo de gráfico',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'Mostrar título',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'Mostrar total',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Mostrar etiqueta del eje x',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Mostrar etiqueta del eje y',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'Marcar métodos de visualización',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'Ajustar marcas',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'Escalonar marcas',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'Girar marcas',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'Colocación de valores en el gráfico de barras',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'Opciones de visualización del gráfico de barras',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'Permitir desplazamiento',
    'LBL_CHART_CONFIG_STACK_DATA' => 'Apilar series de datos',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'Ocultar grupos vacíos',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'enviado',
    'LBL_EMAIL_RECV' => 'rec',

    //record save
    'LBL_RECORD_SAVED' => 'Registro guardado.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'Ha creado de forma correcta el {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a>.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'Ha creado el {{moduleSingularLower}} correctamente.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'Ha creado este registro correctamente, pero no tiene permiso para acceder a este registro.', // use when user has no access to the model
    'LBL_VALIDATING' => 'Validando...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'Éxito:',
    'LBL_ALERT_TITLE_WARNING' => 'Alerta:',
    'LBL_ALERT_TITLE_NOTICE' => 'Aviso:',
    'LBL_ALERT_TITLE_ERROR' => 'Error:',
    'LBL_ALERT_TITLE_LOADING' => 'Cargando',
    'LBL_ALERT_NO_ACCESS' => 'No tiene acceso al filtro aplicado a este dashlet.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'Duplique el cuadro de mando para configurar este dashlet con su propio filtro.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'La versión de su buscador no es compatible o está utilizando un navegador que no es compatible.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'Plataformas compatibles',
    'LBL_ALERT_CONFIRM_DELETE' => '¿Está seguro de que desea eliminar este elemento?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => '¿Está seguro de que desea eliminar estos elementos?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'El registro seleccionado va a sobrescribir los siguientes valores: {{values}}. Cancele para quedarse con los valores existentes. Confirme para guardar con nuevos valores.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'La {{moduleSingularLower}} seleccionada tiene valores relacionados: {{values}}. Cancelar para mantener los valores existentes. Confirmar para sobrescribir con los nuevos valores.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'De:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'Para:',

    //organization chart
    'LBL_ORG_CHART' => 'Organigrama',
    'LBL_ORG_CHART_DESC' => 'Muestra la estructura de empleados de su organización.',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'Alternar orientación',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'Mostrar todos los nodos',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'Zoom para ajustar',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'Resumen del Caso',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'Muestra una visión general de los casos relacionados.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'Resumen',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'Casos Cerrados',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'Casos Abiertos',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => '10 Ventas Principales',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'Mostrar las 10 Principales Líneas de Ingreso en un gráfico de burbujas.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'Mis Líneas de Ingreso',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "Elementos de Mi Equipo",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'Filtro de Datos por Defecto',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'Conjunto de Datos por Defecto',

    'LBL_PRODUCT_CATALOG_NAME' => 'Catálogo de Productos',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'Catálogo de Productos',
    'LBL_PRODUCT_CATALOG_DESC' => 'Ver y añadir elementos de su catálogo de productos.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'Ver y añadir elementos de su catálogo de productos.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} el {{date}} a las {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Escriba una nota o arrastre y suelte un archivo adjunto. Escriba @ para mencionar a un usuario. Escriba # para hacer referencia a un registro.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'Añada su comentario&hellip; Escriba @ para mencionar a un usuario. Escriba # para hacer referencia a un registro.',
    'LBL_ACTIVITY_STREAM' => 'Flujo de actividad',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'El Flujo de Actividades no está habilitado',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'El flujo de actividad no está disponible para este módulo',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'Más publicaciones...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'en',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'Mi Flujo de Actividad',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'Ver un listado de actividades realizadas en los registros y crear y cargar comentarios.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'Los flujos de actividad están inhabilitados',

    'LBL_DATA_VIEW' => 'Vista de los datos',
    'LBL_COMMENT' => 'Comentario',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'Ocurrió un error al conectarse al servidor. Vuelva a intentarlo.',
    'ERR_RESOLVE_ERRORS' => 'Resuelva los errores antes de continuar.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'Para poder Aprobar, debe haber rellenado todos los campos obligatorios; sin embargo, aún puede Rechazar o Dirigir este registro.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'Para Rechazar/Dirigir debe haber rellenado todos los campos obligatorios.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'Actualizar lista',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'Actualizar el mosaico',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'más',
    'LBL_TEXTAREA_LESS' => 'menos',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} adjuntos',
    'LBL_CREATE_ATTACHMENT' => 'Crear un adjunto',
    'LBL_DASHLET_REFRESH' => 'Refrescar',
    'LBL_DASHLET_MOVE' => 'Mover',
    'LBL_DASHLET_CLOSE' => 'Cerrar',

    'LBL_DASHLET_FORECAST_NAME' => 'Incluido en la Previsión',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'Gráfico de Barras de Previsiones',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Previsión en Diagrama de Pareto',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'Prévisión para',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'Muestra el Gráfico de Barras de Previsiones para un Período Determinado',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'Agrupar Por',
    'LBL_DASHLET_FORECASTS_DATASET' => 'Conjunto de datos',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'Detalles de previsiones',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'Muestra detalles actuales de la Previsión.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'Dashlet de Gráficas de Informes Guardados',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'Muestra cualquier gráfico de un informe guardado.',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'Artículos relacionados publicados',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'Resumen del historial',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'Más historial...',
    'LBL_RELATED_CONTACT' => 'Contacto Relacionado',
    'LBL_MODULE_TYPE' => 'Tipo',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'Email para',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'Email de',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'Módulos de Patrimonio no se pueden ver.',

    //SFA
    'LBL_BEST' => 'Mejor Caso',
    'LBL_WORST' => 'Peor Caso',
    'LBL_LIKELY' => 'Caso probable',
    'LBL_BEST_FORECAST' => 'Compromiso (mejor)',
    'LBL_WORST_FORECAST' => 'Compromiso (peor)',
    'LBL_LIKELY_FORECAST' => 'Compromiso (probable)',
    'LBL_BEST_ADJUSTED' => 'Compromiso ajustado (mejor)',
    'LBL_WORST_ADJUSTED' => 'Compromiso ajustado (peor)',
    'LBL_LIKELY_ADJUSTED' => 'Compromiso ajustado (probable)',
    'LBL_AMOUNT_USDOLLAR' => 'Cantidad convertida',
    'LBL_OVERDUE' => 'Vencido',

    'LBL_PASSWORD_REQUEST_SENT' => 'Su petición ha sido enviada.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'Hubo un problema al recuperar la combinación de su nombre de usuario e email.',

    'LBL_REMINDER_TITLE' => 'Recordatorio',
    'LBL_CLICK_TO_DRILLDOWN' => 'Haga clic para desglosar',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'No puede deshabilitar todos los idiomas.',

    'LBL_UPDATE_CALC_FIELDS' => 'Recalcular Valores',

    //Optimistic Locking
    'LBL_YOU' => 'Usted',
    'LBL_RESOLVE_CONFLICT' => 'Resolver Conflicto para {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'Para más información, consulte la documentación de {{{more_info_url}}} {{plural_module_name}}.{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'No hay datos disponibles',
    'LBL_NEED_HELP' => '¿Necesita ayuda con algo nuevo?',
    'LBL_NEW_CASE' => 'Nuevo caso',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'Este dashlet de ayuda ofrece información específica relacionada con el módulo que está viendo actualmente junto con un enlace a la documentación correspondiente (por ejemplo Documentación de clientes potenciales) en la guía de la Aplicación para acceder a más información.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'Ayuda de vista de lista',
    'LBL_HELP_RECORDS' => "La vista de lista de un módulo muestra todos los registros que cumplen con el criterio de búsqueda y a los cuales tienen acceso los usuarios. Puede ver los detalles básicos de cada registro en las columnas de la lista o hacer clic en el nombre del registro para abrir la vista del registro.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'Ayuda Vista de Registro',
    'LBL_HELP_RECORD' => 'Esta vista de registro ofrece información detallada acerca de un registro individual, así como algunos detalles de los registros vinculados al mismo.
- Editar los campos de este registro haciendo clic en un campo individual o en el botón Editar.
- Ver o modificar enlaces a otros registros en los subpaneles moviendo el panel izquierdo inferior a "Ver datos".
- Interactuar con los comentarios de los usuarios y vista del histórico de cambios moviendo el panel izquierdo inferior de "Flujo de Actividad".
- Siga o haga favorito este registro usando los iconos a la derecha del nombre del registro.
- Acciones adicionales están disponibles en el menú desplegable Acciones a la derecha del botón Editar.',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}} Creación',
    'LBL_HELP_CREATE' => 'Para crear un {{plural_module_name}}:
1. Proporcione valores para los campos que desee.
* Los campos marcados como "Obligatorio" se deben completar antes de guardar.
* Haga clic en "Mostrar Más" para ver los campos adicionales si es necesario.
2. Haga clic en "Guardar" para finalizar el nuevo registro y volver a la vista de lista {{plural_module_name}}.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'Detectado un potencial duplicado',
    'LBL_HELP_DUPLICATE' => 'Sugar ha detectado que el registro que está intentando crear ya existe.
Para modificar un registro existente en lugar de crear uno nuevo, haga clic en "Seleccionar y editar" en la derecha del registro deseado. Cualquier campo en blanco en el registro existente se rellenarán con los valores que  acaba de introducir. Haga clic en "Guardar" para realizar estos cambios para el registro existente.

En cambio, si desea utilizar los valores que acaba de introducir en lugar de mantener los valores existentes, haga clic en "Restablecer los originales.". Los valores que ha introducido se aplicarán al registro existente, y ahora podrá incluir cambios adicionales. Haga clic en "Guardar" para finalizar las modificaciones del registro existente. 

Para crear un nuevo registro utilizando los valores que ha introducido, haga clic en "Ignorar Duplicados y Guardar" en la parte superior derecha de la pantalla.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'Desaparecida la configuración del servidor SMTP',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'Para poder enviar notificaciones por correo electrónico deberá configurar un servidor SMTP en la {{emailSettingsUrl}}.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'Configuración de Correo',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'Nuevos informes de stock disponibles',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'Hay nuevos informes de stock disponibles en su ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'Módulo de Informes',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'Tienen la etiqueta "Informe de Stock" y se pueden filtrar. Los informes también están etiquetados como "Ventas y Marketing", "Servicio de atención al cliente", "Privacidad de datos" o "Administrativo" según el contenido. Para obtener más información consulte la ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'documentación',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM permite a los usuarios llevar a cabo tareas de forma rápida con accesos directos de teclado para aumentar su productividad. Las tablas de la derecha describen los atajos disponibles junto con las claves y las acciones que realizan.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>Teclas compatibles</h1> <ul><li>todos los caracteres alfanuméricos y símbolos de</li><li>shift, ctrl, alt, command, mod (ctrl en Windows/Linux y command en Mac)</li> <li>intro, esc, espacio, tabulador, RePág, AvPág, fin, inicio, ins, supr, retroceso</li></ul> <h1>Características compatibles</h1> <ul><li>Combinación de teclas: ctrl + m</li> <li>Teclas múltiples: m, ctrl + m</li> <li>secuencia de teclas: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'Accesos directos Globales',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'Accesos directos contextuales',
    'LBL_SHORTCUT_KEY_KEY' => 'Clave',
    'LBL_SHORTCUT_FUNCTION' => 'Función',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Configurar accesos directos contextuales',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'No existen accesos directos contextuales que configurar',
    'LBL_SHORTCUT_HELP' => 'Mostrar acceso directo para la página de Ayuda',
    'LBL_SHORTCUT_QUICK_CREATE' => 'Alternar el menu de creación rápida',
    'LBL_SHORTCUT_SEARCH' => 'Centrar en el campo de búsquedas globales',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'Alternar barra lateral',
    'LBL_SHORTCUT_CREATE_RECORD' => 'Crear un nuevo registro',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'Seleccionar registro siguiente en la lista',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'Seleccionar registros previos en la lista',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'Desplácese hacia la izquierda',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'Desplácese hacia la derecha',
    'LBL_SHORTCUT_OPEN' => 'Abrir registro seleccionado en la lista',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'Editar registro seleccionado en la lista',
    'LBL_SHORTCUT_RECORD_DELETE' => 'Eliminar registro',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Salir del modo edición en línea sin guardar cambios',
    'LBL_SHORTCUT_RECORD_SAVE' => 'Guardar registro',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'Eliminar cualquier cambio que se ha hecho al registro',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'Marcar registro como favorito',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'Seguir registro',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'Vista previa del registro',
    'LBL_SHORTCUT_MARK_SELECTED' => 'Marcar registro como seleccionado',
    'LBL_SHORTCUT_SELECT_ALL' => 'Seleccionar todo',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'Abrir menú desplegable de acción masiva',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'Enfocar en el campo de filtros de listado',
    'LBL_SHORTCUT_FILTER_CREATE' => 'Crear un nuevo filtro de lista',
    'LBL_SHORTCUT_FILTER_EDIT' => 'Editar filtro de listado actual',
    'LBL_SHORTCUT_FILTER_SHOW' => 'Abrir el menu de filtro de listado',
    'LBL_SHORTCUT_RECORD_EDIT' => 'Editar registro',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'Abrir el registro anterior',
    'LBL_SHORTCUT_RECORD_NEXT' => 'Abrir el siguiente registro',
    'LBL_SHORTCUT_COPY_RECORD' => 'Copiar el registro actual',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'Abrir el menú desplegable de acción principal',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'Cerrar cajón',
    'LBL_SHORTCUT_FILTER_ADD' => 'Añadir un criterio adicional al filtro',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'Quitar último criterio del filtro',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'Cerrar filtro',
    'LBL_SHORTCUT_FILTER_SAVE' => 'Guardar filtro',
    'LBL_SHORTCUT_FILTER_DELETE' => 'Eliminar filtro',
    'LBL_SHORTCUT_FILTER_RESET' => 'Restaurar filtro',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'Añadir fila',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'Quitar fila',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'Cerrar actualización masiva',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'Actualizar registros',
    'LBL_CREATE_CATEGORY' => 'Crear <div class="btn-link" data-action="create-new">categoría</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'Confirmar',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'Cancelar',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'Seleccionar todos los elementos en un campo de selección múltiple',
    'LBL_SHORTCUT_SWEETSPOT' => 'Cambiar la barra Sweet Spot',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'Ocultar la barra de Sweet Spot',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'Guardar configuración',
    'LBL_SHORTCUT_RESTORE' => 'Restaurar preferencias por defecto',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'Se ha producido un error al guardar los accesos directos de teclado en el servidor. Inténtelo de nuevo.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => 'Configuración de {{module}}',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => 'Se han guardado los parámetros de la configuración de {{module}}.',
    'LBL_CONFIG_BLOCKED_TITLE' => 'Error de configuración de {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => 'El módulo {{module}} no tiene ningún parámetro de configuración',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'El usuario no tiene acceso al módulo {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'El usuario no tiene acceso para configurar los parámetros de {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'Es necesario arreglar la configuración de la base de datos de {{module}}',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'hasta',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'Fecha de inicio y finalización',

    'LBL_CALENDAR_START_DATE' => 'Fecha de inicio',
    'LBL_CALENDAR_END_DATE' => 'Fecha de Finalización',
    'LBL_CALENDAR_DURATION' => 'Duración',
    'LBL_CALENDAR_RECURRENCE' => 'Repetición',
    'LBL_CALENDAR_REMINDERS' => 'Recordatorios',

    'LBL_CALENDAR_CUSTOM_DATE' => 'Fecha personalizada',
    'LBL_CALENDAR_REPEAT_TYPE' => 'Tipo de repetición',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'Intervalo de repetición',
    'LBL_CALENDAR_REPEAT_DOW' => 'Repetir entre semana',
    'LBL_CALENDAR_REPEAT_ON' => 'Repetir el',
    'LBL_CALENDAR_REPEAT' => 'Repetición',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'Repetir hasta',
    'LBL_CALENDAR_REPEAT_COUNT' => 'Repetir ocurrencias',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'Repita el selector',
    'LBL_CALENDAR_REPEAT_DAYS' => 'Día(s) del mes',
    'LBL_CALENDAR_REPEAT_MONTH' => 'Mes(es) del año',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'Repita el ordinal',
    'LBL_CALENDAR_REPEAT_UNIT' => 'Repita la unidad',
    'TPL_REPEAT_INTERVAL' => 'Cada {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'Esta serie utiliza una opción de Repetir el que no está disponible en Sugar porque esta serie se sincronizó desde un cliente de calendario. Edite esta serie en su cliente de calendario si quiere seguir repitiéndola en una fecha específica. Si edita esta serie en Sugar se establecerá Repetir el en Ninguno.<br><br>¿Desea continuar?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'Los cambios de recurrencia se deben hacer con el primer registro de las series.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'Las reglas de repetición no dan como resultado la generación de un evento.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'Aceptado',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'Rechazado',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'Provisional',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'Sin respuesta',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'Programa no disponible',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'Vistas disponibles',
    'LBL_CALENDAR_DASHLET_NAME' => 'Planificador del calendario',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'Vista predeterminada',
    'LBL_CALENDAR_MY_CALENDARS' => 'Mis calendarios',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'Calendarios del usuario y equipo',
    'LBL_CALENDAR' => 'Calendario',

    'LBL_CALENDAR_DAY' => 'día',
    'LBL_CALENDAR_WEEK' => 'semana',
    'LBL_CALENDAR_MONTH' => 'mes',
    'LBL_CALENDAR_YEAR' => 'año',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98º',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99º',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'Se ha producido un error mientras se recuperaba el programa.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'Guardar y enviar invitaciones',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'Aceptar estado',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'Procesos',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'El dashlet de procesos muestra las plantillas que se pueden utilizar dentro de SugarBPM.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'Definiciones de procesos',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'El dashlet de definiciones de procesos muestra las plantillas que se pueden utilizar dentro de SugarBPM.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'Crear definición de proceso',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'Importar definiciones de procesos',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'Normas empresariales de procesos',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'El dashlet de normas empresariales de procesos muestra las plantillas que se pueden utilizar dentro de SugarBPM.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'Crear norma empresarial de procesos',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'Importar normas empresariales de procesos',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'Plantillas de email de procesos',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'El dashlet de plantillas de email de procesos muestra las plantillas que se pueden utilizar dentro de SugarBPM.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'Crear plantilla de email de procesos',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'Importar plantillas de email de procesos',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'Al desarrollar plantillas de email, procesos, reglas comerciales, en otra instancia de Sugar, recomendamos firmemente que la instancia sea un clon exacto al de su sistema de producción. Es posible que las plantillas de emails, procesos, reglas comerciales desarrollados en una instancia independiente de Sugar no funcionen bien tras la importación. Estas plantillas pueden basarse en cambios de Studio específicos o cambios a nivel de la aplicación, entre otros se encuentran los nombres de campos personalizados, valores desplegables, Id. de bases de datos, etc. Si estos valores no son idénticos a los de la instancia donde se creó la plantilla de correo electrónico, procesos, regla comercial, es posible que deba ajustar manualmente la plantilla en su instancia objetivo.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => '¿Quiere continuar con esta importación de todas formas?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => '¿Quiere continuar con esta exportación de todas formas?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'El siguiente campo desplegable contiene opciones no válidas',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'Actividades pendientes por proceso',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'Actividades pendientes',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'Actividades pendientes por proceso',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'Todos los procesos',
    'LBL_RECORD_DASHBOARD' => 'Cuadro de mando del registro',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'Resumen de estado de proceso',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'Descripción de estado de proceso',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'En curso',
    'LBL_PMSE_COMPLETED_STATUS' => 'Completado',
    'LBL_PMSE_CANCELLED_STATUS' => 'Cancelado',
    'LBL_PMSE_TERMINATED_STATUS' => 'Finalizado',
    'LBL_PMSE_ERROR_STATUS' => 'Error',
    'LBL_PMSE_SETTINGS' => 'Configuración de SugarBPM',

    'LBL_PRO_DISABLE_CONFIRMATION' => '¿Está seguro de que quiere deshabilitar este registro?',
    'LBL_PRO_ENABLE_CONFIRMATION' => '¿Está seguro de que quiere habilitar este registro?',
    'LBL_PRO_DELETE_CONFIRMATION' => '¿Está seguro de que desea eliminar este registro?',

    'LBL_PRO_ENABLE' => 'Actualizando',
    'LBL_PRO_DISABLE' => 'Actualizando',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} participa en un proceso y puede que contenga algunos campos bloqueados. Para editar el registro, haga clic aquí {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'Este campo está bloqueado porque forma parte de un proceso en ejecución.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'Este registro está participando en un proceso y puede que contenga algunos campos bloqueados.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'Centro de negocios',
    'LBL_BUSINESS_CENTER_ID' => 'ID del centro de negocios',
    'LBL_BUSINESS_CENTER_NAME' => 'Nombre del centro de negocios',

    'LBL_PLIS_ACTIVITIES' => 'Actividades de los elementos comprados',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(Etiqueta nueva)',
    'LBL_TAG_FETCH_ERROR' => 'Se ha producido un error al recuperar etiquetas.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'SugarCRM requiere javascript. Habilite javascript para continuar utilizando SugarCRM.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'Los datos serializados no se pueden deserializar',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'Los datos serializados no se puedes deserializar porque contienen referencias a objetos o clases',

    'LBL_FIELD_TRIMMED' => 'El campo se ha recortado porque excede el límite superior de caracteres.',
    'LBL_FIELDSIZE_OVERFLOW' => 'El campo excede el límite máximo de caracteres.',
    'LBL_TINYMCE_TARGET_SAME' => 'Misma ventana',
    'LBL_TINYMCE_TARGET_NEW' => 'Nueva ventana',

    'LBL_OUTBOUND_EMAILS' => 'Configuración de correo electrónico',
    'LBL_OUTBOUND_EMAIL' => 'Configuración de correo electrónico',

    'LBL_EMAIL_PARTICIPANTS' => 'Participantes por correo electrónico',
    'LBL_EMAIL_PARTICIPANT' => 'Participante por correo electrónico',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'Privacidad de datos',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'Privacidad de datos',
    'LBL_DATAPRIVACY_VIEW_PII' => 'Ver información personal',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'Marcar para borrar',
    'LBL_DATAPRIVACY_FIELDNAME' => 'Campo',
    'LBL_DATAPRIVACY_VALUE' => 'Valor',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'Cambiado por',
    'LBL_DATAPRIVACY_SOURCE' => 'Origen',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'Última actualización',
    'LBL_DATAPRIVACY_PII' => 'Información personal',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'Marcar para borrar',
    'TPL_DATAPRIVACY_PII_TITLE' => 'Información personal de {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'Cambiar temporizadores',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'Mensajes',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => '¡Copiado en su portapapeles!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'No se ha podido copiar en su portapapeles',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'Copiar el enlace de confirmación',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'Línea de tiempo',
    'LBL_NO_ACTIVITY' => 'No hay actividad',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => 'Línea de tiempo de {{moduleSingular}}',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'Más',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'Menos',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'La línea de tiempo muestra los registros relacionados con el registro actual y las actualizaciones de los campos seleccionados a lo largo del tiempo.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'Mostrar más...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'Mostrar menos...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'No hay datos disponibles',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'Módulo sin licencia.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'Activar suscripciones',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'Este dashlet solo se puede añadir para módulos enlazados con una única cuenta. Consulte la documentación de <a href={{linkToDocumentation}}>Dashlet de suscripciones activas</a> para obtener más información.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'Muestra las compras que pertenecen a esta cuenta vinculada:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'Suscripciones activas para una cuenta específica.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', cantidad {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'Total:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'No hay suscripciones activas',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'Este dashlet requiere que {{module_name}} funcione. Hable con su administrador para habilitar {{module_name}}.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'Historial de compras',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'Todas las compras de una cuenta específica.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'Este dashlet solo se puede añadir para módulos enlazados con una única cuenta. Consulte la documentación de <a href={{linkToDocumentation}} target="_blank">Dashlet de historial de compras</a> para obtener más información.',
    'LBL_NO_PURCHASE_HISTORY' => 'No hay compras que mostrar',
    'LBL_NO_PLIS' => 'No hay elementos comprados',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'Total',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'Cantidad',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'Este dashlet necesita Compras y Elementos de línea comprados para funcionar. Hable con su administrador para habilitar Compras y Elementos de línea comprados.',
    'LBL_SEARCH_PURCHASE_NAME' => 'Buscar por Nombre de compra...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'Utilice Studio para editar el diseño del dashlet de la vista de registros en ' .
        'Studio > {{module}} > Diseños > Dashlet de la vista de registros. <a href={{linkToStudio}}>Editar en Studio</a>.',
    'LBL_SERVICE_LEVEL' => 'Nivel de servicio',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'Número',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'Seguimiento',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'Prioridad/Estado',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'Asunto/Descripción',

//Service Duration
    'LBL_SERVICE_DURATION' => 'Duración del servicio',
    'LBL_SERVICE_DURATION_VALUE' => 'Valor de la duración del servicio',
    'LBL_SERVICE_DURATION_UNIT' => 'Unidad de la duración del servicio',
    'LBL_LOCK_DURATION' => 'Duración del bloqueo',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'No se ha podido cargar el CCP de Amazon Connect.' .
        'Asegúrese de utilizar un ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">navegador compatible</a>. ' .
        'Si el problema persiste, contacte con su Administrador de Sugar.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Su Administrador de Sugar no ha configurado su instancia de Amazon Connect.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'No se ha podido establecer la conexión con Amazon Connect. Contacte con su Administrador de Sugar para obtener asistencia.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'Desconocido',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'Panel de enfoque',
    'LBL_CLOSE_FOCUS_DRAWER' => 'Cerrar panel de enfoque',
    'LBL_EXTERNAL_GUESTS' => 'Invitados externos',
    'LBL_MY_FAVORITE_TASKS' => 'Mis tareas favoritas',
    'LBL_RECORD' => 'Registro',

    'LBL_MY_TASKS' => 'Mis tareas',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'No se ha podido encontrar el campo: {0} en el módulo: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'No se ha podido encontrar el registro con {0}: {1} en el módulo: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'No se ha podido encontrar una relación con el nombre: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'Ya existe una entrada en la base de datos con el id: {0}, con {1}: {2} en el módulo: {3}',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'eliminado temporalmente (con indicador de borrado = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'Se han encontrado varios registros en la base de datos para {0} {1} en el módulo {2}. ' .
        'Elimine o actualice los registros coincidentes según corresponda. Registros coincidentes: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'Siguiente ejecución',
    'LBL_TIME_AWARE_TYPE' => 'Tipo',
    'LBL_TIME_AWARE_BEAN_ID' => 'ID de Bean',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'Mostrar etiqueta',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'Abrir vista de registros',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'Añadir',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'Ayuda no disponible',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'Funciones',
    'LBL_ACTIONBUTTON_FIELDS' => 'Campos',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'Seleccionar campo...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Acumulado',
    'LBL_ACTIONBUTTON_RELATED' => 'Relacionado',
    'LBL_ACTIONBUTTON_SAVE' => 'Guardar',
    'LBL_ACTIONBUTTON_CANCEL' => 'Cancelar',
    'LBL_ACTIONBUTTON_R_MODULE' => 'Módulo relacionado',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'Campos relacionados',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'Módulo consolidado',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'Campos consolidados',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'Función consolidada',
    'LBL_ACTIONBUTTON_MINIMUM' => 'Mínimo',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'Máximo',
    'LBL_ACTIONBUTTON_AVERAGE' => 'Media',
    'LBL_ACTIONBUTTON_SUM' => 'Total',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'Asignar registro',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'Redactar correo electrónico',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'Crear registro',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Fusión de documentos',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'Abrir Url',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'Ejecutar informe',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'Actualizar registro',
    'LBL_ACTIONBUTTON_ACTION' => 'Acción',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'Asignar a',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'Enviar correo electrónico a',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'Utilizar PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'Plantilla',
    'LBL_ACTIONBUTTON_MODULE' => 'Módulo',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'Configuración de pantalla',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'Tipo',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'Lista desplegable',
    'LBL_ACTIONBUTTON_BUTTON' => 'Botón',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'Grupo de botones',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'Mostrar etiqueta en el registro',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'Mostrar en la cabecera',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'Ocultar en editar',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'Mostrar en el encabezado del panel de enfoque',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'Panel',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'Encabezado del panel de enfoque',
    'LBL_ACTIONBUTTON_SIZE' => 'Tamaño',
    'LBL_ACTIONBUTTON_DEFAULT' => 'Predeterminado',
    'LBL_ACTIONBUTTON_SMALL' => 'Pequeño',
    'LBL_ACTIONBUTTON_LARGE' => 'Grande',
    'LBL_ACTIONBUTTON_CALCULATED' => 'Calculado',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'Convertir a PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Fusión de documentos',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'Vista previa',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'Propiedades',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'Etiqueta',
    'LBL_ACTIONBUTTON_DESC' => 'Información sobre herramientas',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'Mostrar etiqueta',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'Mostrar icono',
    'LBL_ACTIONBUTTON_SCHEME' => 'Esquema de colores',
    'LBL_ACTIONBUTTON_ICON' => 'Icono',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'Dependiente',
    'LBL_ACTIONBUTTON_DESIGN' => 'Configuración del diseño',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'Detenerse en el error',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'Guardar automáticamente',
    'LBL_ACTIONBUTTON_CONFIG' => 'Configuración',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'Configure su botón acción antes de guardar.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'Configurar botones',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'Crear automáticamente',
    'LBL_ACTIONBUTTON_LINK' => 'Crear relación con el padre',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'Copiar valores principales',
    'LBL_ACTIONBUTTON_PRESET' => 'Establecer valor(es) de campo',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'Copiar valor(es) de campo del padre',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'Seleccionar...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'Del campo Principal ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => '¿Seguro que desea eliminar este botón?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => '¿Seguro que desea eliminar esta acción?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'Datos de botón de acción inválidos',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'Seleccione un módulo antes de guardar.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'Seleccione un enlace antes de guardar. Si no hay ningún enlace disponible, desmarque la opción del enlace.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'Seleccione un registro antes de guardar.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'Seleccione una plantilla antes de guardar.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'Principal',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'Secundario',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'Océano',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'Rosa',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'Verde militar',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'Verde azulado',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'Índigo',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'Verde',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'Amarillo',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'Naranja',
    'LBL_ACTIONBUTTON_THEME_RED' => 'Rojo',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'Coral',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'Púrpura',
    'LBL_ACTIONBUTTON_FORMULA' => 'Fórmula',
    'LBL_ACTIONBUTTON_ACTIONS' => 'Acciones',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'Error al validar los datos del botón.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'Los botones deben tener al menos una etiqueta o un conjunto de iconos.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'Introduzca una etiqueta de botón válida.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'No se pudo crear el registro porque faltan valores obligatorios. Póngase en contacto con su administrador.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'Debe tener al menos dos botones activos para este tipo de botón.',
    'LBL_ACTIONBUTTON_RECORD' => 'Vistas de registro',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'Menús de acción',
    'LBL_ACTIONBUTTON_ORDER' => 'Orden',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'Vista de Lista',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'Encabezado de la vista de registro',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'Encabezado del dashlet de la vista de registro',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'Subpaneles',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'El motor de ejecución de la secuencia de tareas ha fallado en la ejecución de las acciones siguientes: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'Añadir una acción',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'Eliminar esta acción',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'Usuario actual',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'Combinación de documentos',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'Combinación de documentos a PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'Tamaño de la empresa',
    'LBL_HINT_COMPANY_INDUSTRY' => 'Industria',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'Etiquetas de la industria',
    'LBL_HINT_COMPANY_LOCATION' => 'Ubicación de la empresa',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'Descripción de la empresa',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'Año de fundación',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Facebook de la empresa',
    'LBL_HINT_COMPANY_TWITTER' => 'Twitter de la empresa',
    'LBL_HINT_COMPANY_PIC' => 'Logotipo de la empresa',
    'LBL_HINT_CONTACT_PIC' => 'Foto de contacto',
    'LBL_HINT_COMPANY_WEBSITE' => 'Sitio web de la empresa',
    'LBL_HINT_PHOTO' => 'Enlace a la foto',
    'LBL_HINT_JOB_2' => 'Trabajos anteriores',
    'LBL_HINT_EDUCATION' => 'Educación',
    'LBL_HINT_EDUCATION_2' => 'Educación adicional',
    'LBL_HINT_TWITTER' => 'Enlace de Twitter',
    'LBL_HINT_FACEBOOK' => 'Enlace de Facebook',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'Código NAICS',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'Código SIC',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'Fin del año fiscal',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'Ingresos anuales',
    'LBL_HINT_PHONE_1' => 'Teléfono 1',
    'LBL_HINT_PHONE_2' => 'Teléfono 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'Unir la tabla',
    'LBL_HINT_FULL_NAME' => 'Nombre y apellidos',
    'LBL_HINT_JOB_TITLE' => 'Cargo',
    'LBL_HINT_OFFICE_PHONE' => 'Teléfono de oficina',
    'LBL_HINT_MOBILE_PHONE' => 'Móvil',
    'LBL_HINT_OTHER_PHONE' => 'Teléfono Alternativo',
    'LBL_HINT_WEBSITE' => 'Sitio web',
    'LBL_HINT_MSG_OVERWRITE_ALL' => '¿Quiere sobrescribir todos los datos existentes de este registro con los nuevos datos que se han encontrado en Sugar Hint?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => '¿Quiere sobrescribir todos los {{fieldName}} existentes de este registro con los nuevos {{fieldName}} que se han encontrado en Sugar Hint?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'Se eliminarán todos los datos relacionados con la cuenta. ¿Seguro que quiere continuar?',
    'LBL_HINT_COMPANY_LOGO' => 'Logotipo',
    'LBL_HINT_CONTACTS_AVATAR' => 'Foto',
    'LBL_HINT_ACCOUNTSETS' => 'Etiquetas del grupo de cuentas de Sugar Hint',

    'LBL_HINT_LOADING' => 'Cargando...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Desinstalando Sugar Hint, espere',
    'LBL_HINT_VALUE_ERASED' => ' Valor borrado ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'Esta información se ha borrado mediante una solicitud de privacidad de datos',

    'LBL_HINT_UNINSTALL_TITLE' => 'Seleccione una de las opciones de desinstalación de las siguientes:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Desinstalar solo el paquete de Hint',
    'LBL_HINT_UNINSTALL_FULL' => 'Desinstalar Hint completamente',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'Esta opción eliminará el MLP de Hint e inhabilitará todas las suscripciones activas de Sugar Hint Insights.
    Al reinstalar Hint se reactivarán las suscripciones de manera automática.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'Esta opción llevará a cabo una desinstalación completa de Hint, incluida la eliminación del MLP y de todas las configuraciones la información de suscripción.',
    'LBL_HINT_UNINSTALL' => 'Desinstalar',
    'LBL_HINT_UNINSTALL_HEADER' => 'Desinstalar Sugar Hint',
    'LBL_HINT_CANCEL' => 'Cancelar',
    'LBL_HINT_UNINSTALL_WARNING1' => 'ADVERTENCIA: Escoja esta opción solo si no pretende volver a utilizar Hint en el futuro.
    Antes de llevar a cabo la desinstalación, haga una copia de seguridad completa de su base de datos de Sugar y ponga Sugar en modo de mantenimiento. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'Consulte la ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Guía de administración de Sugar Hint ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'para obtener más detalles sobre el proceso de desinstalación.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => '¿Seguro que quiere desinstalar solo el paquete de Sugar Hint?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => '¿Seguro de que quiere desinstalar Sugar Hint por completo?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(NOTA: ESTA ACCIÓN NO SE PUEDE DESHACER)',

    'LBL_HINT_CONFIG_TITLE' => 'Campos de Sugar Hint',
    'LBL_HINT_NO_RESULTS_MSG' => 'No se encontraron resultados.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'Diseño básico del panel de Hint',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'Cuentas',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'Contactos',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'Clientes potenciales',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'Diseño ampliado del panel de Hint',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'Para reordenar los campos, arrástrelos y suéltelos en las secciones del diseño del panel de Hint que hay arriba.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'Para obtener instrucciones detalladas y una lista de campos predeterminados, consulte ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' para restaurar la configuración predeterminada del ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'módulo.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => '¿Seguro que quiere restablecer los valores predeterminados del módulo {{module}}?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'Haga clic aquí',
    'LBL_HINT_CONFIG_NAME' => 'Guía de administración de Hint.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'Campos',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'Campos enriquecidos',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'Esta sección enumera todos los campos de Hint y los campos de Sugar que están enriquecidos con Hint. Los campos de Hint están marcados con un asterisco (*) y solo se pueden mostrar en el panel de Hint si están enriquecidos.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'Nombre del campo',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'Enriquecer campo',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Mostrar en Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Mostrar en el panel de Hint',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'Campos adicionales de Sugar',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'Esta sección enumera todos los campos de Sugar que no están enriquecidos con Hint.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'Advertencia',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'Precaución: Va a sincronizar con el servicio de Sugar Hint Insights. Cualquier historia pendiente del resumen de correo electrónico se perderá, y las noticias existentes se borrarán del dashlet de Insights. Las notificaciones de todo tipo se reanudarán tras completarse la sincronización.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'Las empresas sugeridas relacionadas con su {{_moduleSingular}} se enumeran a continuación. Seleccione los datos de la empresa que quiera mostrar.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'Ninguna cuenta seleccionada',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'Se han encontrado varios correos electrónicos, seleccione los que quiere importar: ',

    'LBL_HINT_HELP_MESSAGE1' => 'En función de los datos introducidos, Hint no ha podido encontrar una coincidencia en el sistema.',
    'LBL_HINT_HELP_MESSAGE2' => 'Los mejores resultados de Hint se pueden encontrar con el nombre y la dirección de correo electrónico de una persona.',
    'LBL_HINT_HELP_MESSAGE3' => 'Los mejores resultados de Hint se pueden encontrar con la url del sitio web de una empresa.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "Introduzca el nombre de empresa o el sitio web de su {{_moduleSingular}} y Hint buscará datos adicionales.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "Introduzca el correo electrónico de su {{currentModule}} y Hint buscará datos adicionales.",

    'LBL_HINT_HISTORY_NONE' => 'No hay datos disponibles para la vista histórica',
    'LBL_HINT_HISTORY_TITLE' => 'Historial de actividades',

    'LBL_HINT_PREVIEW_TITLE' => 'Enriquecimiento de datos',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'La licencia de su servicio de Hint ha caducado. Póngase en contacto con su administrador de SugarCRM para renovar la licencia.',
    'LBL_HINT_PREVIEW_QUESTION' => '¿Quiere ver lo que Hint puede hacer por usted y su empresa? Póngase en contacto con su administrador de SugarCRM para añadir Hint.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'No se ha encontrado información de la cuenta',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'Se han encontrado datos enriquecidos - haga clic para guardar todos los datos enriquecidos en su registro.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'Haga clic para guardar los datos enriquecidos en su registro.',

    'LBL_HINT_CONTACTS_TITLE' => 'Contactos relacionados',
    'LBL_HINT_CONTACTS_NONE' => 'No hay contactos relacionados',

    'LBL_HINT_NEWS' => 'Noticias',
    'LBL_HINT_GENERAL' => 'General',
    'LBL_HINT_ALL_NEWS' => 'Todas las noticias',
    'LBL_HINT_FILTER_NEWS' => 'Filtrar noticias',
    'LBL_HINT_FINANCIAL_NEWS' => 'Financieras',
    'LBL_HINT_PERSONNEL_NEWS' => 'Personal',
    'LBL_HINT_PRESS_RELEASES' => 'Notas de prensa',
    'LBL_HINT_OTHER_NEWS' => 'Otros',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'Buscar artículos de noticias',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'No hay noticias disponibles',
    'LBL_NEW_NOTIFICATIONS' => 'Notificaciones nuevas',
    'LBL_HINT_DASHLET_ALLOWED1' => 'Debe tener una licencia de Sugar Hint para ver el dashlet de Sugar Hint Insights.
    Consulte con su administrador para obtener una licencia de Sugar Hint.',

    'LBL_HINT_FOR' => 'Para',
    'LBL_HINT_WITH' => 'con',
    'LBL_HINT_SHOW_ME' => 'Muéstrame: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'Notifícame por: ',

    'LBL_NOTIFICATIONS_TITLE' => 'Centro de preferencias de Sugar Hint Insigths',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'Clave de opción de preferencias',
    'LBL_HINT_PREFERENCES' => 'Preferencias',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'Borrado inhabilitado, es obligatorio tener como mínimo una declaración de preferencias',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'Adición inhabilitada, ha llegado al máximo de declaraciones de preferencias',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Incluir en el dashlet de Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'Ventana emergente como notificación de escritorio',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'Las notificaciones deben estar habilitadas en todos los navegadores y en todos los ordenadores para recibir notificaciones de manera consistente.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Algunos navegadores, como Internet Explorer, no son compatibles con las notificaciones. No se pueden habilitar las notificaciones cuando se utiliza un navegador que no es compatible con ellas.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'Enviar una alerta instantánea por correo electrónico para cada notificación',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'Enviar un resumen diario por correo electrónico',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'Enviar un resumen semanal por correo electrónico',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'No se han podido guardar las preferencias. Revise la conexión del sistema e inténtelo de nuevo.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'Falta un valor en algunos campos obligatorios. Revise sus preferencias y asegúrese de que todos los campos obligatorios están rellenados.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'Está a punto de habilitar las notificaciones de navegador para Sugar Hint Insights. Haga clic en Confirmar para continuar. A continuación, su navegador le pedirá permiso para recibir los eventos de notificación.',
    'LBL_HINT_PUSH_ERROR' => 'Se ha registrado el complemento de notificaciones Push para {{options.type}} sin sus dependencias. El complemento no funcionará de la manera prevista, asegúrese de proporcionar una ruta al archivo del trabajador y un método para guardar la suscripción en el servidor.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'Active las notificaciones de Hint para todos los usuarios',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'Desactive las notificaciones de Hint para todos los usuarios',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'ADVERTENCIA: Error al inhabilitar las notificaciones durante la desinstalación de Sugar Hint. Para inhabilitar las notificaciones, instale Sugar Hint 5.4.0 o superior y lleve a cabo una desinstalación completa con el desinstalador de Sugar Hint que se encuentra en la sección de Administración de Sugar.',
    'LBL_HINT_ENRICH_ALL' => 'Enriquecer todo',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'Licencia Hint obligatoria',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'Configuración de mapas',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'Visor de registros de geocodificador',
    'LBL_MAP_MAP' => 'Mapa',
    'LBL_MAP_MAPS' => 'Mapas',
    'LBL_MAP_GEOCODING_RECORD' => 'Geocodificar',
    'LBL_MAP_GEOCODE_SUCCESS' => 'El registro se ha geocodificado correctamente.',
    'LBL_MAP_LATITUDE' => 'Latitud',
    'LBL_MAP_LONGITUDE' => 'Longitud',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'Buscar por dirección...',
    'LBL_MAP_ALREADY_GEOCODED' => 'El registro actual ya está geocodificado. ¿Seguro que quiere sobrescribir la geocodificación de este registro?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'Geocodificación manual',
    'LBL_MAP_POINT_COORDINATES' => 'Coordenadas del punto del mapa',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'Calculando la ruta óptima...',
    'LBL_MAP_DIRECTIONS' => 'Indicaciones',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'Indicaciones desde el usuario actual',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'Indicaciones desde este registro',
    'LBL_MAPS_RADIUS_INPUT' => 'Radio (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'en un radio desde el código postal',
    'LBL_MAPS_DISTANCE' => 'Distancia',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'Código postal',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'Configuración no válida: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => 'El mapeo del campo <strong>{{module}}</strong> no es válido.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'Tipo de mapa',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'Nivel de ampliación',
    'LBL_MAPS_DASHLET' => 'Mapas',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'Muestra los registros geocodificados en el mapa.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'Mapas no está disponible para este módulo. Habilítelo en la consola de administración.',
    'LBL_MAP_MODULES' => 'Módulo',
    'LBL_MAP_FILTER_BY' => 'Filtrar por',
    'LBL_MAP_UNIT_TYPE' => 'Tipo de unidad',
    'LBL_MAP_UNIT_TYPE_MILES' => 'Millas',
    'LBL_MAP_UNIT_TYPE_KM' => 'Kilómetros',
    'LBL_MAP_ADDRESS' => 'Dirección',
    'LBL_MAP_NO_STARTING_POINT' => 'Punto de inicio no geocodificado.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'El registro del punto de inicio no está geocodificado.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'Algunos de los registros seleccionados no están geocodificados y no se mostrarán en el mapa.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'Los registros no están geocodificados.',
    'LBL_MAPS_MODULE_FIELDS' => 'Campos del módulo',
    'LBL_MAPS_SELECT_FIELD' => 'Seleccionar campo',
    'LBL_MAPS_RELATE_RECORD' => 'Registro relacionado',
    'LBL_MAPS_MAPPING_TYPE' => 'Tipo de mapeo',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'No hay registros geocodificados',
    'LBL_MAPS_ADDRESS' => 'Dirección',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'Usuario asignado',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'La visualización de la calle no está disponible para el punto dado',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> registros no son válidos para el mapeo. Elimine el módulo de la lista.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'Cerrar',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'Expandir',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'Guardar como PDF',
    'LBL_MAPS_EMAIL_LINK' => 'Enlace de correo electrónico',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'Debe tener como mínimo un registro geocodificado.',
    'LBL_MAPS_GENERATING' => 'Generando mapa...',
    'LBL_MAPS_POINTS' => 'Puntos del mapa',
    'LBL_MAPS_POINT' => 'Punto',
    'LBL_MAPS_TRAVEL_DETAILS' => 'Detalles de viaje',
    'LBL_MAPS_TOTAL_DISTANCE' => 'Distancia total',
    'LBL_MAPS_TOTAL_DURATION' => 'Duración total',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'Duración total sin tráfico',
    'LBL_MAPS_ITINERARY' => 'Itinerario',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'Distancia de viaje',
    'LBL_MAPS_TRAVEL_DURATION' => 'Duración del viaje',
    'LBL_MAPS_TRAVEL_STEPS' => 'Pasos',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'Advertencias',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Maps es compatible con un máximo de 10 chinchetas en un mapa compartido. Revise su selección.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'Licencia de Mapas obligatoria',
    'LBL_MAPS_SHARE_HELLO' => 'Hola,',
    'LBL_MAPS_SHARE_HEADER' => 'Ha solicitado un mapa de Bing para los siguientes puntos:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'El siguiente URL abrirá un mapa que contiene los puntos anteriores en Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Mostrar mapa en Bing Maps',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'No se ha encontrado ninguna ruta para los puntos de recorrido proporcionados.',
    'LBL_MAPS_GEOCODE_STATUS' => 'Estado de geocodificación',
    'LBL_MAPS_GEOCODED' => 'Geocodificado',
    'LBL_MAPS_NOT_GEOCODED' => 'No geocodificado',
    'LBL_MAPS_NOT_FOUND' => 'Dirección no válida',
    'LBL_MAPS_GEOCODING_FAILED' => 'Error de geocodificación',
    'LBL_MAPS_QUEUED' => 'En cola',
    'LBL_MAPS_REQUEUED' => 'Devuelto a la cola',
    'LBL_MAPS_RELATED_RECORD' => 'Registro relacionado',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'Ver informe',
    'LBL_REPORT_DASHLET_DESC' => 'Mostrar un informe guardado',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'Restablecer a los valores predeterminados de Dashlet',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'Restablecer a los valores predeterminados del informe',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'Actualizar los resultados',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'Copiar gráfico al portapapeles',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'Descargar Gráfico',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'Se ha editado el informe del dashlet {{label}} y se ha restablecido a la configuración predeterminada.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'No tiene permiso para usar este campo.',

    'LBL_INVALID_FORMULA' => 'Fórmula no válida',
    'LBL_RETURN_TYPE_MISSMATCH' => 'El tipo de retorno de función no coincide',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'Predicción',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'Perfil de cliente ideal',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'Puntajes de predicción de semana de cierre',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'Valor de predicción',
    'LBL_AI_CONV_BIN_ACCURACY' => 'Precisión de la predicción de ubicación',
    'LBL_AI_CONV_MULTIPLIER' => 'Multiplicador de previsión',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'Valor de ICP',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'Precisión de la ubicación de ICP',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'Multiplicador ICP',
    'LBL_AI_NEW' => 'Nuevo',
    'LBL_AI_ENTERED' => 'Ingresado',
    'LBL_AI_CREATED' => 'Creado',
    'LBL_AI_WEEK' => 'Semana',
    'LBL_AI_MONTH' => 'Mes',
    'LBL_AI_QUARTER' => 'Trimestre',
    'LBL_AI_BYWEEK' => 'por semana',
    'LBL_AI_BYMONTH' => 'por mes',
    'LBL_AI_BYQUARTER' => 'por trimestre',
    'LBL_AI_WEEKTREND' => 'Tendencia semanal',
    'LBL_AI_MONTHLYTREND' => 'Tendencia mensual',
    'LBL_AI_QUARTERTREND' => 'Tendencia trimestral',
    'LBL_AI_TREND' => 'Tendencia de',
    'LBL_AI_TRENDS' => 'Tendencias de',
    'LBL_AI_VELOCITY' => 'Velocidad',
    'LBL_AI_TOPX' => '{X} principales',
    'LBL_AI_TIMESPAN' => 'Intervalo de tiempo entre etapas -',
    'LBL_AI_BUSINESSTREND' => 'con tendencias empresariales',
    'LBL_AI_SUGARINSIGHTINTRO' => '¡Presentamos Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights utiliza el análisis cuantitativo para generar nuevos conocimientos sobre sus datos de SugarCRM. En Sugar, siempre estamos buscando nuevas maneras de ayudarle a sacar el máximo provecho de sus datos, tomar decisiones informadas, y esto es solo el comienzo de lo que esperamos ofrecer con Sugar Insights.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights utiliza el análisis cuantitativo para generar nuevos conocimientos sobre los datos de SugarCRM.',
    'LBL_AI_FIRMO' => 'Firmografía',
    'LBL_AI_TOTALCOUNT' => 'Recuento total de',
    'LBL_AI_DAYSFROMLATESTACT' => 'Días desde el último',
    'LBL_AI_DAYSSINCE' => 'antigüedad',
    'LBL_AI_FIELDISSET' => 'existe',
    'LBL_AI_CONTACTCOMPLETENESS' => 'Integridad de la información de contacto',
    'LBL_AI_CUTDATE' => 'Periodo de predicción',
    'LBL_AI_FROMLASTCHANGE' => 'Días desde el último cambio de valor de la función',
    'LBL_AI_CALLSHELD' => 'Recuento total de llamadas realizadas',
    'LBL_AI_CALLSPLANNED' => 'Recuento total de llamadas previstas',
    'LBL_AI_OUTBOUNDCALLS' => 'Recuento total de llamadas salientes',
    'LBL_AI_INBOUNDCALLS' => 'Recuento total de llamadas entrantes',
    'LBL_AI_AVGCALLDURATION' => 'Duración media de las llamadas',
    'LBL_AI_EMAILSARCHIVED' => 'Recuento total de correos electrónicos archivados',
    'LBL_AI_EMAILSREAD' => 'Recuento total de correos electrónicos leídos',
    'LBL_AI_EMAILSSENT' => 'Recuento total de correos electrónicos enviados',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'Recuento total de registros en los que la fecha de cierre prevista se ha cambiado a una fecha posterior',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'Recuento total de registros en los que la fecha de cierre prevista se ha cambiado a una fecha anterior',
    'LBL_AI_AMOUNTINCREASED' => 'Total de oportunidades en las que aumentó la cantidad',
    'LBL_AI_AMOUNTDECREASED' => 'Total de oportunidades en las que disminuyó la cantidad',

    // User last state
    'LBL_LAST_STATE' => 'Último estado',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'Enviar a DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'Cancelar editar destinatario',
    'LBL_RECIPIENT_ROLE' => 'Función del destinatario',
    // Base sales stages
    'LBL_OPEN' => 'Abrir',
    'LBL_CLOSED_WON' => 'Cerrado ganado',
    'LBL_CLOSED_LOST' => 'Cerrado perdido',
    'LBL_KIOSK_ADD_FILES' => 'Agregar archivos',
    'LBL_KIOSK_ADD_DROP_FILES' => 'Agregue o suelte archivos aquí',
    'LBL_KIOSK_CANCEL' => 'Cancelar',
    'LBL_KIOSK_EDIT' => 'Editar',
    'LBL_KIOSK_EMAIL' => 'Correo electrónico',
    'LBL_KIOSK_FILES_UPLOADING' => 'Subiendo',
    'LBL_KIOSK_FILES_ERROR' => 'Ha habido un error al subir los adjuntos',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'El archivo adjunto es demasiado grande',
    'LBL_KIOSK_FILTER_SEARCH' => 'Buscar',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'Quiosco',
    'LBL_KIOSK_LANGUAGE' => 'Idioma',
    'LBL_KIOSK_LAST_UPDATED' => 'Última actualización',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'Vista',
    'LBL_KIOSK_MENU' => 'Menú',
    'LBL_KIOSK_MOBILE_PHONE' => 'Teléfono Móvil',
    'LBL_KIOSK_MY_ACTIVITIES' => 'Mis actividades',
    'LBL_KIOSK_MY_PROFILE' => 'Mi perfil',
    'LBL_KIOSK_NAME' => 'Nombre',
    'LBL_KIOSK_OFFICE_PHONE' => 'Teléfono de oficina',
    'LBL_KIOSK_ORGANIZATION' => 'Organización',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'Filas por página:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'Desarrollado por SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'Guardar cambios',
    'LBL_KIOSK_SHOW_HIDE' => 'Mostrar / Ocultar',
    'LBL_KIOSK_SIGN_IN' => 'Iniciar sesión',
    'LBL_KIOSK_SIGN_OUT' => 'Cerrar sesión',
    'LBL_KIOSK_SORT_BY' => 'Ordenar por',
    'LBL_KIOSK_SUBMIT' => 'Enviar',
    'LBL_KIOSK_TIMEZONE' => 'Zona horaria',
    'LBL_KIOSK_ACTIVITY' => 'Actividad',
    'LBL_KIOSK_NO_ACTIVITY' => 'Sin actividad para mostrar',
    'LBL_KIOSK_OLDEST_FIRST' => 'Los más antiguos primero',
    'LBL_KIOSK_NEWEST_FIRST' => 'Los más nuevos primero',
    'LBL_KIOSK_SHOW_MORE' => 'Mostrar más',
    'LBL_KIOSK_ADD_A_REPLY' => 'Añadir una respuesta',
    'LBL_KIOSK_REPLY_EMPTY' => 'La respuesta no se puede dejar vacía.',
    'LBL_KIOSK_NUM_MORE' => '{{num}} más',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'Bienvenido',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'Acceda a sus recursos de forma rápida.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'Buscar casos',
    'LBL_KIOSK_SHOW_ALL' => 'Mostrar todo',
    'LBL_KIOSK_404_TITLE' => 'No pudimos encontrar esto',
    'LBL_KIOSK_TENANT_404_TITLE' => 'Inquilino no encontrado',
    'LBL_KIOSK_404_MESSAGE' => 'Ha hecho clic en un enlace que se ha eliminado, no está disponible temporalmente o ha introducido una URL no válida.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'Asegúrese de tener la URL correcta. Para obtener más ayuda, póngase en contacto con el servicio de asistencia.',
    'LBL_KIOSK_BACK_TO_HOME' => 'Volver al inicio',
    'LBL_KIOSK_ERROR_CODE' => '{code} Error: ',
    'LBL_KIOSK_401_TITLE' => 'No autorizado',
    'LBL_KIOSK_401_MESSAGE' => 'No está autorizado para ver esta página.',
    'LBL_KIOSK_403_TITLE' => 'No autorizado',
    'LBL_KIOSK_403_MESSAGE' => 'No tiene acceso para ver esta página.',
    'LBL_KIOSK_500_TITLE' => 'El servidor no responde',
    'LBL_KIOSK_500_MESSAGE' => 'Algo salió mal de nuestra parte.',
    'LBL_KIOSK_GO_BACK' => 'Volver',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'Registro duplicado encontrado',
    'LBL_KIOSK_ACCOUNT' => 'Cuenta',
    'LBL_KIOSK_STATUS' => 'Estado',
    'LBL_KIOSK_DEACTIVATE' => 'Desactivar',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'Se ha desactivado al usuario',
    'LBL_KIOSK_MANAGE_USERS' => 'Gestionar usuarios',
    'LBL_KIOSK_LAST_LOGIN' => 'Último inicio de sesión',
    'LBL_KIOSK_FIRST_NAME' => 'Nombre',
    'LBL_KIOSK_LAST_NAME' => 'Apellido',
    'LBL_KIOSK_ROLE' => 'Función',
    'LBL_KIOSK_INVITE' => 'Invitación',
    'LBL_KIOSK_SEND_INVITES' => 'Enviar invitación(es)',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'Invitación(es) enviada(s) correctamente',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'Invitación(es) no enviada(s)',
    'LBL_KIOSK_REACTIVATE' => 'Reactivar',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'Se ha reactivado el usuario',
    'LBL_KIOSK_RESET_PASSWORD' => 'Restablecer contraseña',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'Se ha enviado un correo electrónico para restablecer la contraseña',
    'LBL_KIOSK_USER_PROFILE' => 'Perfil de usuario',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'Su usuario ha sido desactivado. Póngase en contacto con el administrador.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'Volver al inicio de sesión',
    'LBL_KIOSK_REVOKE_INVITATION' => 'Anular la invitación',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'Invitación anulada correctamente',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'Buscar y seleccionar...',
    'LBL_KIOSK_NO_MATCHES' => 'No se han encontrado coincidencias',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'Se ha actualizado el perfil.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'Error al actualizar el perfil.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'Documentos',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'Vea, busque y descargue los documentos compartidos entrantes.',
    'LBL_KIOSK_CASES' => 'Casos',
    'LBL_KIOSK_CASES_DESC' => 'Vea, busque y responda a los casos compartidos con usted.',
    'LBL_KIOSK_DOWNLOAD' => 'Descargar',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'Archivo descargado correctamente',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'Primeros pasos',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'Para ayudarle mejor, indíquenos su nombre y apellido.',
    'LBL_KIOSK_SAVE' => 'Guardar',
    'LBL_KIOSK_SHARED' => 'Compartido',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'Bienvenido {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'Color de fondo',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'URL de la imagen de fondo',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'Se recomienda elegir una imagen con un tamaño de archivo inferior a 400K.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'Tipo de fondo',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'Fondo de inicio',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'Tema',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'Color del tema principal',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'Nombre de la aplicación',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'Este es el título de su aplicación y se muestra junto a su logotipo.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'URL del logotipo de la aplicación',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'Se recomienda elegir un logotipo que se vea mejor en tamaños pequeños (por ejemplo, perfiles de redes sociales). También se recomienda tener un tamaño de archivo inferior a 200K.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'URL de favicons de la aplicación',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'Un favicon es un pequeño logotipo que aparece junto al título de la página en una pestaña del navegador.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'Reasignación automática de las actividades abiertas',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'Límite de usuarios alcanzado',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'Clave de licencia no válida',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'Aplicación no válida',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'Aplicación no válida',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'Clave de validación corrupta',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'Licencia caducada',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'Falta información',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'Falta la clave de validación',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'El usuario no tiene acceso',
    'LBL_DRI_WORKFLOW' => 'Guía inteligente',
    'LBL_DRI_WORKFLOWS' => 'Guías inteligentes',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Plantilla de fases de la guía inteligente',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Plantillas de fases de la guía inteligente',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Plantilla de la guía inteligente',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Plantilla de actividades de la guía inteligente',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'Plantillas de actividad',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'Web Hooks',
    'LBL_CJ_WEBHOOKS' => 'Webhooks de Sugar Automate',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'Actividad actual de la guía inteligente a',
    'LBL_CJ_WEBHOOKS' => 'Webhooks de Sugar Automate',
    'LBL_CJ_WEBHOOK' => 'Webhook de Sugar Automate',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Acciones de Sugar',
    'LBL_CJ_FORMS' => 'Acciones de Sugar de Smart Guide',
    'LBL_CJ_FORM' => 'Acción de Sugar de Smart Guide',
    'LBL_DRI_SUBWORKFLOW' => 'Fase de la guía inteligente',
    'LBL_DRI_SUBWORKFLOWS' => 'Fases de la guía inteligente',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Plantillas de actividades de la guía inteligente',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Plantillas de la guía inteligente',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Orden de la guía inteligente',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Orden actual de la guía inteligente',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Puntuación de la guía inteligente',
    'LBL_CJ_MOMENTUM_POINTS' => 'Puntos de impulso de la guía inteligente',
    'LBL_CJ_MOMENTUM_SCORE' => 'Puntuación de impulso de la guía inteligente',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Permitir actividad de la guía inteligente por',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Progreso de la guía inteligente',
    'LBL_CJ_MOMENTUM_RATIO' => 'Relación de impulso de la guía inteligente',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Puntos de la guía inteligente',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Tarea de la guía inteligente',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Tipo de actividad principal de la guía inteligente',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Guía inteligente bloqueada por',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'Guía inteligente bloqueada por Fases',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Id de actividad principal de la guía inteligente',
    'LBL_START_NEXT_JOURNEY_ID' => 'Iniciar el siguiente Id de la guía inteligente',
    'LBL_CJ_URL' => 'Url de la guía inteligente',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Es actividad principal de la guía inteligente',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Fecha de inicio de impulso de la guía inteligente',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Fecha de fin de impulso de la guía inteligente',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'Configuración del diseño del widget',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'Configuración del diseño del widget',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'Cantidad máxima de guías inteligentes de la misma plantilla',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'Activo',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'Archivado',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'Mostrar',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'Ocultar',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'Modo vertical',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'Modo horizontal',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Licencia no válida',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} ha asignado las siguientes actividades de la guía inteligente a {{assigned_user}}.</p>
    <ul>{{activities}}</ul>
    
    <p>Puede revisar estas actividades en:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Licencia no válida',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'Ha alcanzado el límite de usuarios, tiene {{gracePeriodDays}} días para mejorar la licencia.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - Actividades de la guía inteligente asignadas',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Se ha superado el límite de {0} usuarios de Sugar Automate <br>
    <br>
    Póngase en contacto con <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> para aumentar o reducir el número de usuarios que utilizan el complemento.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Se ha alcanzado el límite de usuarios de Sugar Automate',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Su licencia de Sugar Automate caducará en {0} días. <br>
    <br>
    Póngase en contacto con SugarCRM o con su colaborador de Sugar para renovarla y evitar la interrupción del servicio.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'La licencia de Sugar Automate está a punto de caducar',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'Probar Webhook',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Progreso de Smart Guide',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Muestra el gráfico circular "Progreso de Smart Guide" de Sugar Automate.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'Muestra la respuesta de Webhook',
    'LBL_DASHLET_SEND_LABEL' => 'Enviar solicitud',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'Asignar a mi',
    'LBL_COMPLETE_BUTTON_TITLE' => 'Completado',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'Completar todas las tareas',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'Eliminar fase',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'Iniciar',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'No aplicable',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'Añadir fase',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'Ver',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Editar Smart Guide',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'Cancelar',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'Archivar',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'Desarchivar',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'Configurar plantilla',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'Añadir tarea',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'Programar reunión',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'Programar llamada',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'es en el futuro',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'está vencido',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'es hoy',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'es mañana',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => '¿Seguro de que desea cancelar esta guía inteligente?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'Está a punto de completar todas las tareas. ¿Seguro que quiere seguir?',
    'LBL_CJ_BLOCK_BY' => 'Tiene una tarea dependiente sin resolver: {{Name}}. Complete esta tarea antes de completar todas las tareas.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'Tiene varias tareas dependientes sin resolver. Complete esta tarea antes de completar todas las tareas.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'Ha completado todas las tareas correctamente',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => '¿Seguro de que desea archivar esta guía inteligente?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => '¿Seguro de que desea desarchivar esta guía inteligente?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Guías inteligentes (cajones de enfoque y consola)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'Ver las Smart Guides activas en los paneles de control de la consola de servicios/renovaciones y del cajón de enfoque.',
    'LBL_CJ_PROCESSING_REQUEST' => 'Procesando..',
    'LBL_CJ_SUCCESS' => 'Ha completado todas las tareas correctamente',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => 'El módulo {module} no está habilitado',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'Se han guardado todos los ajustes de visualización.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Impulso de la guía inteligente',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Muestra el gráfico indicador del "Impulso de la guía inteligente" de Sugar Automate.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Progreso de Smart Guide',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Muestra el gráfico circular "Progreso de Smart Guide" de Sugar Automate.',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'No se ha podido encontrar el principal',
    'CJ_NOT_FOUND_EXCEPTION' => 'No se ha podido encontrar el {moduleName} con {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'Se debe completar o cancelar la guía inteligente antes de archivarla',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate no está habilitado en la licencia actual de Sugar',
    'LBL_ACTION_NOT_FOUND' => 'Acción no encontrada, Póngase en contacto con el administrador del sistema',
    'LBL_CJ_SELECT_FIELD' => 'Seleccionar campo',
    'LBL_CJ_SELECT_OPERATOR' => 'Seleccionar operador',
    'LBL_CJ_SELECT_VALUE' => 'Seleccionar valor',
    'LBL_CJ_ENTER_VALUE' => 'Ingresar valor',
    'LBL_CJ_FORM_BATCH_TITLE' => 'Guardando registro',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'Smart Guides activas detectadas...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'Procesando las acciones activas de Sugar...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'Actualizando Smart Guides activas...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'El registro y las Smart Guides asociadas se han actualizado correctamente.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'No se ha podido actualizar una Smart Guide asociada. Si el error persiste, póngase en contacto con el administrador de Sugar para obtener ayuda.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'No se ha podido actualizar una Smart Guide asociada. Revise los <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">registros</a> para solucionar el error.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => 'El {{moduleSingularLower}} <a href="#{{module}}/{{id}}">{{name}}</a> se ha vinculado correctamente.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'Se produjo un problema al vincular el {{moduleSingularLower}} <a href="#{{module}}/{{id}}">{{name}}</a>. Si el problema persiste, póngase en contacto con el servicio de asistencia de Sugar.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => 'Los {{modulePluralLower}} se han vinculado correctamente.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'Se produjo un problema al vincular los {{modulePluralLower}}. Si el problema persiste, póngase en contacto con el servicio de asistencia de Sugar.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'Se produjo un problema al vincular el {{moduleSingularLower}}. Si el problema persiste, póngase en contacto con el servicio de asistencia de Sugar.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'Ya existe un {{moduleSingularLower}} llamado <a href="#{{module}}/{{id}}">{{name}}</a> en la etapa {{stage}}.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'Ya se ha seleccionado un {{moduleSingularLower}} llamado <a href="#{{module}}/{{id}}">{{name}}</a>.',
    'LBL_CJ_ARCHIVED' => 'Archivado',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Seleccione la plantilla de Smart Guide...',
    'LBL_ALL_SMART_GUIDES' => 'Todas las Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => 'Smart Guides activas',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Smart Guides archivadas',
    'LBL_VERTICAL_SCROLL_VIEW' => 'Vista apilada vertical',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'Vista de desplazamiento horizontal',
    'LBL_DRI_WORKFLOWS_FILTER' => 'Filtrar',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'Esta acción no se puede completar. El campo Estado del módulo de esta actividad está configurado como "solo lectura", lo que impide cualquier acción de Smart Guide que actualice el campo Estado.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'Esta acción no se puede completar. El campo Estado de los módulos de estas actividades o subactividades está configurado como "solo lectura", lo que impide cualquier acción de Smart Guide que actualice el campo Estado.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'El campo Estado de los módulos de algunas actividades están configurados como "solo lectura". Estas actividades permanecerán sin alterar tras cancelar la guía.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'Copiado al portapapeles.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'Suprimir todas las recurrencias',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'Configuración de recurrencias inválida',
    'ERROR_INTERVAL_INVALID' => 'El intervalo de repetición debe estar entre 1 y 99',
    'LBL_RECURRENCE_ADD' => 'Configurar',
    'LBL_REPEAT_DAYS' => 'Día(s) del mes',
    'LBL_REPEAT_END_TYPES' => 'Repetición',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'Proveedor de navegación',
    'LBL_MOBILE_PDF_EMAIL' => 'Enviar correo electrónico {{{pdfTemplateName}}} PDF',
    'LBL_MOBILE_EMAIL_SENDING' => 'En envío',
    'LBL_MOBILE_EMAIL_SENT' => 'Enviado',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'Correo electrónico guardado como borrador.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'Añadir adjunto',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'Subir de Local',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Documento de Sugar',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'Un valor desplegable que ha seleccionado ha cambiado su diseño de la vista de registros.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'Notas de lanzamiento de la aplicación SugarCRM Mobile',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'Guía del usuario de la aplicación SugarCRM Mobile',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile no se puede usar en un dispositivo móvil enraizado. Abra la aplicación en un dispositivo no enraizado.',
    'LBL_VO_BUILD_ROUTE' => 'Crear ruta',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'Mi filtro de distancia',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'El documento se generará en segundo plano. Abra la página de fusiones de documentos para acceder al archivo.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'Error al obtener la plantilla. Póngase en contacto con su administrador para obtener ayuda.',
    'LBL_MAP_ERROR_LOAD' => 'No se puede cargar el mapa',
    'LBL_MAP_DISTANCE' => 'Distancia',
    'LBL_SELECT_UNIT_TYPE' => 'Tipo de unidad',
    'LBL_MAPS_UNIT_MILES' => 'Millas',
    'LBL_MAPS_UNIT_KILOMETERS' => 'Kilómetros',
    'LBL_RADIUS' => 'Radio',
    'LBL_ZIP_CODE' => 'Código postal',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'Elegir dirección',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'No se puede crear el geocódigo de la dirección:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'El registro no se geocodificó.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'El registro no contiene datos de dirección. ¿Quiere ubicar este registro en el mapa manualmente?',
    'LBL_ERR_SHOW_ON_MAP' => 'Error al abrir el mapa para los registros seleccionados.',
    'LBL_ERR_MISSING_ON_MAP' => 'Algunos registros no tienen datos de dirección y no se muestran',
    'LBL_MAPS_ROUTE' => 'Ruta',
    'LBL_MAPS_PROVIDER' => 'Sugar Maps',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'No se pudo determinar la ubicación actual.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'Un máximo de {{{num}}} registros son compatibles para los mapas.',
    'LBL_ALL_MODULES' => 'Todos los módulos',
    'LBL_DRIVE_SHARE_LINK' => 'Compartir un enlace',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'Error al cargar los archivos.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'El nombre no puede estar vacío',
    'LBL_DRIVE_FOLDER_CREATED' => 'Carpeta creada.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'Error al crear una carpeta.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'Error al cargar un archivo.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'Cree primero una carpeta raíz',
    'LBL_EDIT_ALL_RECURRENCES' => 'Editar todas las recurrencias',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'El archivo no se puede abrir en Dropbox',
    'LBL_FILE_NOT_AVAILABLE' => 'El archivo no se puede abrir',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'Indicaciones',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'No se ha encontrado ninguna ruta para los puntos de recorrido proporcionados',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'Cerca',
    'LBL_TAGS' => 'Etiquetas',

    'LBL_CALLER_ID_SETTINGS' => 'Configuración del identificador de llamadas',
    'LBL_CALLER_ID_ENABLED' => 'Identificador de llamadas activado',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'En las llamadas entrantes, se muestra el nombre del contacto o cliente potencial que coincide con el número de teléfono.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'Para permitir que la aplicación móvil muestre el identificador de llamadas, siga estos pasos en su dispositivo:<br><br>1. Vaya a Ajustes de iOS > Teléfono > Bloqueo e identificación de llamadas.<br>2. Habilite "{{{brandName}}}".',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'Para permitir que la aplicación móvil muestre el identificador de llamadas, siga estos pasos en su dispositivo:<br>1. Abra los ajustes de la aplicación.<br>2. Vaya a Permisos.<br>3. Active el permiso Teléfono.<br><br> Para establecer esta aplicación como gestor predeterminado del identificador de llamadas, vaya a la configuración de su dispositivo.<br>1. Vaya a Aplicaciones.<br>2. Elija las aplicaciones predeterminadas.<br>3. Elija la aplicación de identificación de llamadas y spam.<br>4. Seleccione esta aplicación como opción predeterminada.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Compruebe si se han producido cambios en la información de contacto de los registros (por ejemplo, contactos, clientes potenciales) en su instancia de Sugar.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'Vaya a Ajustes',
    'LBL_CALLER_ID_SYNC' => 'Sincronizar datos de registro',
    'LBL_CALLER_ID_NOT_ENABLED' => 'El identificador de llamadas debe estar activado en los ajustes del sistema antes de la sincronización.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'Habilitar',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'Más adelante en los ajustes',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'Esta aplicación es compatible con la función de identificador de llamadas.<br> Para que esta función funcione correctamente, después de pulsar el botón de activación, se le pedirá que conceda dos permisos.<br> Para garantizar que el identificador de llamadas funcione correctamente, debe conceder permiso para gestionar llamadas y seleccionar esta aplicación como gestor predeterminado del identificador de llamadas.<br> Si no concede el permiso para gestionar llamadas, tampoco podrá registrar las llamadas realizadas desde la aplicación.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'Para permitir que la aplicación móvil SugarCRM muestre el identificador de llamadas, siga estos pasos en su dispositivo:<br><br>1. Vaya a Ajustes de iOS > Teléfono > Bloqueo e identificación de llamadas.<br>2. Habilite la aplicación.',
    'LBL_MOBILE_LAST_SYNC' => 'Última sincronización',
    'LBL_CALLER_ID_SYNCING' => 'Sincronizando con el servidor.',
    'LBL_NEVER' => 'Nunca',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} no puede estar vacío.',
    'LBL_ADD_RELATED_RECORD' => '{{{moduleSingular}}} relacionado',
    'LBL_CALLER_ID_NO_PERMISSION' => 'No dispone de los permisos necesarios para utilizar el identificador de llamadas. Póngase en contacto con el administrador.',
    'LBL_CALLER_ID_FETCHING' => 'Sincronizando…',
    'LBL_CALLER_ID_FETCH_ALL' => 'Volver a sincronizar todos los registros',
    'LBL_CALLER_ID_FETCH_NEW' => 'Buscar actualizaciones de registros',

    'LBL_SORT_BY' => 'Ordenar por',
    'LBL_PRIMARY_SORT' => 'Orden principal',
    'LBL_SECONDARY_SORT' => 'Orden secundario',
    'LBL_OF' => 'de',
    'LBL_TABLE_FREEZE_FIRST' => 'Congelar la primera columna',
    'LBL_TABLE_SETTINGS_TITLE' => 'Opciones de la vista de columna',
    'LBL_TABLE_SETTINGS_NO_COL' => 'Debe haber al menos una columna seleccionada.',
    'LBL_TABLE_TOGGLER_INFO' => 'Muestre u oculte columnas y arrástrelas en el orden que prefiera.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'Filtros de tiempo de ejecución',
    'LBL_FILTER_CONDITION' => 'Seleccionar condición',
    'LBL_FILTER_VALUES' => 'Valores',
    'LBL_TABLE_EXPAND' => 'Expandir todo',
    'LBL_TABLE_COLLAPSE' => 'Contraer todo',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'Error del servidor. No se han podido cargar los filtros de tiempo de ejecución relevantes.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Suscripciones a emisiones de eventos del módulo Pub/Sub',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Suscripción a emisiones de eventos del módulo Pub/Sub',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'Panel - Parte superior',
    'panel_bottom' => 'Panel - Parte inferior',
    'tab_first' => 'Pestaña - Primera',
    'tab_last' => 'Pestaña - Última',
];

$app_list_strings['activity_user_options'] = [
    '7' => '7 Días Anteriores',
    '30' => 'Últimos 30 Días',
    '90' => 'Último Trimestre',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'Hoy',
    'future' => 'Futuro',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'Sí',
    'group' => 'No',
];

$app_list_strings['history_filter_options'] = [
    7 => '7 Días Anteriores',
    30 => 'Últimos 30 Días',
    90 => 'Último Trimestre',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'Sí',
    'group' => 'No',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'Sí',
    'group' => 'No',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'Sí',
    '0' => 'No',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'Este trimestre',
    'next' => 'Siguiente Trimestre',
    'year' => 'Este Año',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'Mis registros',
    'group' => 'Registros de grupo',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'Mi Pipeline',
    'group' => 'El Pipeline de mi equipo',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'Mi Previsión',
    'group' => 'Previsión de Mi Equipo',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'Oportunidades',
    'RevenueLineItems' => 'Oportunidades y líneas de ingresos',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'Fecha de cierre más reciente',
    'earliest' => 'Fecha de cierre más temprana',
];

$app_list_strings['moduleList']['Library'] = 'Biblioteca';
$app_list_strings['moduleListSingular']['Library'] = 'Biblioteca';
$app_list_strings['library_type'] = ['Books' => 'Libro', 'Music' => 'Música', 'DVD' => 'DVD', 'Magazines' => 'Revistas'];
$app_list_strings['moduleList']['EmailAddresses'] = 'Dirección de Correo electrónico';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'Dirección de Correo electrónico';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'Borrador',
    'in-review' => 'En revisión',
    'approved' => 'Aprobado',
    'published' => 'Publicado',
    'expired' => 'Caducado',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--Acciones de Admin.--',
        'Create New Tag' => 'Crear Nueva EtiquetaTag',
        'Delete Tag' => 'Eliminar Etiqueta',
        'Rename Tag' => 'Renombrar Etiqueta',
        'Move Selected Articles' => 'Mover Artículos Seleccionados',
        'Apply Tags On Articles' => 'Aplicar Etiquetas a Artículos',
        'Delete Selected Articles' => 'Eliminar Artículos Seleccionados',
    ];

$app_list_strings['moduleList']['Words'] = 'Palabras';
$app_list_strings['moduleListSingular']['Words'] = 'Palabra';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Crear artículo';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DHABI',
    'ADEN' => 'ADEN',
    'AFGHANISTAN' => 'AFGANISTÁN',
    'ALBANIA' => 'ALBANIA',
    'ALGERIA' => 'ARGELIA',
    'AMERICAN SAMOA' => 'SAMOA AMERICANA',
    'ANDORRA' => 'ANDORRA',
    'ANGOLA' => 'ANGOLA',
    'ANTARCTICA' => 'ANTÁRTIDA',
    'ANTIGUA' => 'ANTIGUA',
    'ARGENTINA' => 'ARGENTINA',
    'ARMENIA' => 'ARMENIA',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => 'AUSTRALIA',
    'AUSTRIA' => 'AUSTRIA',
    'AZERBAIJAN' => 'AZERBAIYÁN',
    'BAHAMAS' => 'BAHAMAS',
    'BAHRAIN' => 'BAHRAIN',
    'BANGLADESH' => 'BANGLADÉS',
    'BARBADOS' => 'BARBADOS',
    'BELARUS' => 'BIELORRUSIA',
    'BELGIUM' => 'BÉLGICA',
    'BELIZE' => 'BELICE',
    'BENIN' => 'BENIN',
    'BERMUDA' => 'BERMUDA',
    'BHUTAN' => 'BUTÁN',
    'BOLIVIA' => 'BOLIVIA',
    'BOSNIA' => 'BOSNIA',
    'BOTSWANA' => 'BOTSUANA',
    'BOUVET ISLAND' => 'ISLA BOUVET',
    'BRAZIL' => 'BRASIL',
    'BRITISH ANTARCTICA TERRITORY' => 'TERRITORIO BRITÁNICO EN LA ANTÁRTIDA',
    'BRITISH INDIAN OCEAN TERRITORY' => 'TERRITORIO BRITÁNICO DEL OCÉANO ÍNDICO',
    'BRITISH VIRGIN ISLANDS' => 'ISLAS VÍRGENES BRITÁNICAS',
    'BRITISH WEST INDIES' => 'BRITISH WEST INDIES',
    'BRUNEI' => 'BRUNEI',
    'BULGARIA' => 'BULGARIA',
    'BURKINA FASO' => 'BURKINA FASO',
    'BURUNDI' => 'BURUNDI',
    'CAMBODIA' => 'CAMBOYA',
    'CAMEROON' => 'CAMERÚN',
    'CANADA' => 'CANADÁ',
    'CANAL ZONE' => 'ZONA DEL CANAL',
    'CANARY ISLAND' => 'ISLAS CANARIAS',
    'CAPE VERDI ISLANDS' => 'ISLAS DE CABO VERDE',
    'CAYMAN ISLANDS' => 'ISLAS CAIMÁN',
    'CEVLON' => 'CEVLON',
    'CHAD' => 'CHAD',
    'CHANNEL ISLAND UK' => 'ISLAS DEL CANAL REINO UNIDO',
    'CHILE' => 'CHILE',
    'CHINA' => 'CHINA',
    'CHRISTMAS ISLAND' => 'ISLA DE NAVIDAD',
    'COCOS (KEELING) ISLAND' => 'ISLAS COCOS (KEELING)',
    'COLOMBIA' => 'COLOMBIA',
    'COMORO ISLANDS' => 'ISLAS COMORO',
    'CONGO' => 'CONGO',
    'CONGO KINSHASA' => 'CONGO KINSHASA',
    'COOK ISLANDS' => 'ISLAS COOK',
    'COSTA RICA' => 'COSTA RICA',
    'CROATIA' => 'CROACIA',
    'CUBA' => 'CUBA',
    'CURACAO' => 'CURACAO',
    'CYPRUS' => 'CHIPRE',
    'CZECH REPUBLIC' => 'REPÚBLICA CHECA',
    'DAHOMEY' => 'DAHOMEY',
    'DENMARK' => 'DINAMARCA',
    'DJIBOUTI' => 'YIBUTI',
    'DOMINICA' => 'DOMINICA',
    'DOMINICAN REPUBLIC' => 'REPÚBLICA DOMINICANA',
    'DUBAI' => 'DUBAI',
    'ECUADOR' => 'ECUADOR',
    'EGYPT' => 'EGIPTO',
    'EL SALVADOR' => 'EL SALVADOR',
    'EQUATORIAL GUINEA' => 'GUINEA ECUATORIAL',
    'ESTONIA' => 'ESTONIA',
    'ETHIOPIA' => 'ETIOPÍA',
    'FAEROE ISLANDS' => 'ISLAS FEROE',
    'FALKLAND ISLANDS' => 'ISLAS MALVINAS',
    'FIJI' => 'FIJI',
    'FINLAND' => 'FINLANDIA',
    'FRANCE' => 'FRANCIA',
    'FRENCH GUIANA' => 'GUAYANA FRANCESA',
    'FRENCH POLYNESIA' => 'POLINESIA FRANCESA',
    'GABON' => 'GABÓN',
    'GAMBIA' => 'GAMBIA',
    'GEORGIA' => 'GEORGIA',
    'GERMANY' => 'ALEMANIA',
    'GHANA' => 'GHANA',
    'GIBRALTAR' => 'GIBRALTAR',
    'GREECE' => 'GRECIA',
    'GREENLAND' => 'GROENLANDIA',
    'GUADELOUPE' => 'GUADALUPE',
    'GUAM' => 'GUAM',
    'GUATEMALA' => 'GUATEMALA',
    'GUINEA' => 'GUINEA',
    'GUYANA' => 'GUYANA',
    'HAITI' => 'HAITÍ',
    'HONDURAS' => 'HONDURAS',
    'HONG KONG' => 'HONG KONG',
    'HUNGARY' => 'HUNGRÍA',
    'ICELAND' => 'ISLANDIA',
    'IFNI' => 'IFNI',
    'INDIA' => 'INDIA',
    'INDONESIA' => 'INDONESIA',
    'IRAN' => 'IRÁN',
    'IRAQ' => 'IRAQ',
    'IRELAND' => 'IRLANDA',
    'ISRAEL' => 'ISRAEL',
    'ITALY' => 'ITALIA',
    'IVORY COAST' => 'COSTA DE MARFIL',
    'JAMAICA' => 'JAMAICA',
    'JAPAN' => 'JAPÓN',
    'JORDAN' => 'JORDANIA',
    'KAZAKHSTAN' => 'KAZAJSTÁN',
    'KENYA' => 'KENIA',
    'KOREA' => 'COREA',
    'KOREA, SOUTH' => 'COREA DEL SUR',
    'KUWAIT' => 'KUWAIT',
    'KYRGYZSTAN' => 'KIRGUISTÁN',
    'LAOS' => 'LAOS',
    'LATVIA' => 'LETONIA',
    'LEBANON' => 'LÍBANO',
    'LEEWARD ISLANDS' => 'ISLAS DE SOTAVENTO',
    'LESOTHO' => 'LESOTO',
    'LIBYA' => 'LIBIA',
    'LIECHTENSTEIN' => 'LIECHTENSTEIN',
    'LITHUANIA' => 'LITUANIA',
    'LUXEMBOURG' => 'LUXEMBURGO',
    'MACAO' => 'MACAO',
    'MACEDONIA' => 'MACEDONIA',
    'MADAGASCAR' => 'MADAGASCAR',
    'MALAWI' => 'MALAWI',
    'MALAYSIA' => 'MALASIA',
    'MALDIVES' => 'MALDIVAS',
    'MALI' => 'MALI',
    'MALTA' => 'MALTA',
    'MARTINIQUE' => 'MARTINICA',
    'MAURITANIA' => 'MAURITANIA',
    'MAURITIUS' => 'MAURICIO',
    'MELANESIA' => 'MELANESIA',
    'MEXICO' => 'MÉXICO',
    'MOLDOVIA' => 'MOLDAVIA',
    'MONACO' => 'MÓNACO',
    'MONGOLIA' => 'MONGOLIA',
    'MOROCCO' => 'MARRUECOS',
    'MOZAMBIQUE' => 'MOZAMBIQUE',
    'MYANAMAR' => 'MYANAMAR',
    'NAMIBIA' => 'NAMIBIA',
    'NEPAL' => 'NEPAL',
    'NETHERLANDS' => 'PAÍSES BAJOS',
    'NETHERLANDS ANTILLES' => 'ANTILLAS HOLANDESAS',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'ANTILLAS HOLANDESAS ZONA NEUTRAL',
    'NEW CALADONIA' => 'NUEVA CALEDONIA',
    'NEW HEBRIDES' => 'NUEVAS HÉBRIDAS',
    'NEW ZEALAND' => 'NUEVA ZELANDA',
    'NICARAGUA' => 'NICARAGUA',
    'NIGER' => 'NÍGER',
    'NIGERIA' => 'NIGERIA',
    'NORFOLK ISLAND' => 'ISLA NORFOLK',
    'NORWAY' => 'NORUEGA',
    'OMAN' => 'OMÁN',
    'OTHER' => 'OTRO',
    'PACIFIC ISLAND' => 'ISLA DEL PACIFICO',
    'PAKISTAN' => 'PAKISTÁN',
    'PANAMA' => 'PANAMÁ',
    'PAPUA NEW GUINEA' => 'PAPÚA NUEVA GUINEA',
    'PARAGUAY' => 'PARAGUAY',
    'PERU' => 'PERÚ',
    'PHILIPPINES' => 'FILIPINAS',
    'POLAND' => 'POLONIA',
    'PORTUGAL' => 'PORTUGAL',
    'PORTUGUESE TIMOR' => 'TIMOR ORIENTAL',
    'PUERTO RICO' => 'PUERTO RICO',
    'QATAR' => 'QATAR',
    'REPUBLIC OF BELARUS' => 'REPÚBLICA DE BIELORRUSIA',
    'REPUBLIC OF SOUTH AFRICA' => 'REPÚBLICA DE SUDÁFRICA',
    'REUNION' => 'REUNIÓN',
    'ROMANIA' => 'RUMANÍA',
    'RUSSIA' => 'RUSIA',
    'RWANDA' => 'RUANDA',
    'RYUKYU ISLANDS' => 'ISLAS DE RYUKYU',
    'SABAH' => 'SABAH',
    'SAN MARINO' => 'SAN MARINO',
    'SAUDI ARABIA' => 'ARABIA SAUDITA',
    'SENEGAL' => 'SENEGAL',
    'SERBIA' => 'SERBIA',
    'SEYCHELLES' => 'SEYCHELLES',
    'SIERRA LEONE' => 'SIERRA LEONE',
    'SINGAPORE' => 'SINGAPUR',
    'SLOVAKIA' => 'ESLOVAQUIA',
    'SLOVENIA' => 'ESLOVENIA',
    'SOMALILIAND' => 'SOMALILIAND',
    'SOUTH AFRICA' => 'SUDÁFRICA',
    'SOUTH YEMEN' => 'YEMEN DEL SUR',
    'SPAIN' => 'ESPAÑA',
    'SPANISH SAHARA' => 'SAHARA ESPAÑOL',
    'SRI LANKA' => 'SRI LANKA',
    'ST. KITTS AND NEVIS' => 'ST. KITTS AND NEVIS',
    'ST. LUCIA' => 'SANTA LUCÍA',
    'SUDAN' => 'SUDÁN',
    'SURINAM' => 'SURINAM',
    'SW AFRICA' => 'SO DE ÁFRICA',
    'SWAZILAND' => 'SWAZILANDIA',
    'SWEDEN' => 'SUECIA',
    'SWITZERLAND' => 'SUIZA',
    'SYRIA' => 'SIRIA',
    'TAIWAN' => 'TAIWÁN',
    'TAJIKISTAN' => 'TAYIKISTÁN',
    'TANZANIA' => 'TANZANIA',
    'THAILAND' => 'TAILANDIA',
    'TONGA' => 'TONGA',
    'TRINIDAD' => 'TRINIDAD',
    'TUNISIA' => 'TÚNEZ',
    'TURKEY' => 'TURQUÍA',
    'UGANDA' => 'UGANDA',
    'UKRAINE' => 'UCRANIA',
    'UNITED ARAB EMIRATES' => 'EMIRATOS ÁRABES UNIDOS',
    'UNITED KINGDOM' => 'REINO UNIDO',
    'UPPER VOLTA' => 'ALTO VOLTA',
    'URUGUAY' => 'URUGUAY',
    'US PACIFIC ISLAND' => 'ISLAS DEL PACÍFICO ESTADOS UNIDOS',
    'US VIRGIN ISLANDS' => 'ISLAS VÍRGENES DE EE.UU.',
    'USA' => 'EE.UU.',
    'UZBEKISTAN' => 'UZBEKISTÁN',
    'VANUATU' => 'VANUATU',
    'VATICAN CITY' => 'CIUDAD DEL VATICANO',
    'VENEZUELA' => 'VENEZUELA',
    'VIETNAM' => 'VIETNAM',
    'WAKE ISLAND' => 'ISLA WAKE',
    'WEST INDIES' => 'ANTILLAS',
    'WESTERN SAHARA' => 'SAHARA OCCIDENTAL',
    'YEMEN' => 'YEMEN',
    'ZAIRE' => 'ZAIRE',
    'ZAMBIA' => 'ZAMBIA',
    'ZIMBABWE' => 'ZIMBABWE',
];

$app_list_strings['state_dom'] = [
    'AL' => 'Alabama',
    'AK' => 'Alaska',
    'AZ' => 'Arizona',
    'AR' => 'Arkansas',
    'CA' => 'California',
    'CO' => 'Colorado',
    'CT' => 'Connecticut',
    'DE' => 'Delaware',
    'DC' => 'Distrito de Columbia',
    'FL' => 'Florida',
    'GA' => 'Georgia',
    'HI' => 'Hawaii',
    'ID' => 'Idaho',
    'IL' => 'Illinois',
    'IN' => 'Indiana',
    'IA' => 'Iowa',
    'KS' => 'Kansas',
    'KY' => 'Kentucky',
    'LA' => 'Louisiana',
    'ME' => 'Maine',
    'MD' => 'Maryland',
    'MA' => 'Massachusetts',
    'MI' => 'Michigan',
    'MN' => 'Minnesota',
    'MS' => 'Mississippi',
    'MO' => 'Missouri',
    'MT' => 'Montana',
    'NE' => 'Nebraska',
    'NV' => 'Nevada',
    'NH' => 'New Hampshire',
    'NJ' => 'New Jersey',
    'NM' => 'New Mexico',
    'NY' => 'New York',
    'NC' => 'North Carolina',
    'ND' => 'North Dakota',
    'OH' => 'Ohio',
    'OK' => 'Oklahoma',
    'OR' => 'Oregon',
    'PA' => 'Pennsylvania',
    'RI' => 'Rhode Island',
    'SC' => 'South Carolina',
    'SD' => 'South Dakota',
    'TN' => 'Tennessee',
    'TX' => 'Texas',
    'UT' => 'Utah',
    'VT' => 'Vermont',
    'VA' => 'Virginia',
    'WA' => 'Washington',
    'WV' => 'West Virginia',
    'WI' => 'Wisconsin',
    'WY' => 'Wyoming',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (Taiwan y Hong Kong)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (Cirílico de MS)',
    'CP1252' => 'CP1252 (Europa Occidental y EEUU de Ms)',
    'EUC-CN' => 'EUC-CN (Chino Simplificado GB2312)',
    'EUC-JP' => 'EUC-JP (Japonés Unix)',
    'EUC-KR' => 'EUC-KR (Coreano)',
    'EUC-TW' => 'EUC-TW (Taiwanés)',
    'ISO-2022-JP' => 'ISO-2022-JP (Japonés)',
    'ISO-2022-KR' => 'ISO-2022-KR (Coreano)',
    'ISO-8859-1' => 'ISO-8859-1 (Europa Occidental y EEUU)',
    'ISO-8859-2' => 'ISO-8859-2 (Centroeuropa y Europa del Este)',
    'ISO-8859-3' => 'ISO-8859-3 (Latín 3)',
    'ISO-8859-4' => 'ISO-8859-4 (Latín 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Cirílico)',
    'ISO-8859-6' => 'ISO-8859-6 (Árabe)',
    'ISO-8859-7' => 'ISO-8859-7 (Griego)',
    'ISO-8859-8' => 'ISO-8859-8 (Hebreo)',
    'ISO-8859-9' => 'ISO-8859-9 (Latín 5)',
    'ISO-8859-10' => 'ISO-8859-10 (Latín 6)',
    'ISO-8859-13' => 'ISO-8859-13 (Latín 7)',
    'ISO-8859-14' => 'ISO-8859-14 (Latín 8)',
    'ISO-8859-15' => 'ISO-8859-15 (Latín 9)',
    'KOI8-R' => 'KOI8-R (Cirílico Ruso)',
    'KOI8-U' => 'KOI8-U (Cirílico Ucraniano)',
    'SJIS' => 'SJIS (Japonés de MS)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Douala' => 'Africa/Douala',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Indian/Comoro' => 'Indian/Comoro',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Asmera' => 'Africa/Asmera',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Lagos' => 'Africa/Lagos',
    'Indian/Reunion' => 'Indian/Reunion',
    'Africa/Kigali' => 'Africa/Kigali',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Dakar' => 'Africa/Dakar',
    'Indian/Mahe' => 'Indian/Mahe',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Harare' => 'Africa/Harare',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Indian/Chagos' => 'Indian/Chagos',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Rangoon' => 'Asia/Rangoon',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Beijing' => 'Asia/Beijing',
    'Asia/Harbin' => 'Asia/Harbin',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Chongqing' => 'Asia/Chongqing',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Kashgar' => 'Asia/Kashgar',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Calcutta' => 'Asia/Calcutta',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Indian/Maldives' => 'Indian/Maldives',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Katmandu' => 'Asia/Katmandu',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Saigon' => 'Asia/Saigon',
    'Asia/Aden' => 'Asia/Aden',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Sydney' => 'Australia/Sydney',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Indian/Christmas' => 'Indian/Christmas',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Indian/Cocos' => 'Indian/Cocos',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Truk' => 'Pacific/Truk',
    'Pacific/Ponape' => 'Pacific/Ponape',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Johnston' => 'Pacific/Johnston',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'Europe/London' => 'Europe/London',
    'Europe/Dublin' => 'Europe/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Brussels' => 'Europa/Bruselas',
    'Europe/Sofia' => 'Europa/Sofia',
    'Europe/Prague' => 'Europa/Praga',
    'Europe/Copenhagen' => 'Europa y Copenhague',
    'Atlantic/Faeroe' => 'Atlantic/Faeroe',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Godthab' => 'America/Godthab',
    'America/Thule' => 'America/Thule',
    'Europe/Tallinn' => 'Europa/Tallin',
    'Europe/Helsinki' => 'Europa/Helsinki',
    'Europe/Paris' => 'Europa/París',
    'Europe/Berlin' => 'Europa/Berlín',
    'Europe/Gibraltar' => 'Europa/Gibraltar',
    'Europe/Athens' => 'Europa/Atenas',
    'Europe/Budapest' => 'Europa/Budapest',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Europe/Rome' => 'Europa/Roma',
    'Europe/Riga' => 'Europa/Riga',
    'Europe/Vaduz' => 'Europa/Vaduz',
    'Europe/Vilnius' => 'Europa/Vilnius',
    'Europe/Luxembourg' => 'Europa/Luxemburgo',
    'Europe/Malta' => 'Europa/Malta',
    'Europe/Chisinau' => 'Europa/Chisinau',
    'Europe/Monaco' => 'Europa/Mónaco',
    'Europe/Amsterdam' => 'Europa/Amsterdam',
    'Europe/Oslo' => 'Europa/Oslo',
    'Europe/Warsaw' => 'Europa/Varsovia',
    'Europe/Lisbon' => 'Europa/Lisboa',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Europe/Bucharest' => 'Europa/Bucarest',
    'Europe/Kaliningrad' => 'Europa/Kaliningrado',
    'Europe/Moscow' => 'Europa/Moscú',
    'Europe/Samara' => 'Europa/Samara',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Madrid' => 'Europe/Madrid',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Zurich' => 'Europe/Zurich',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'America/New_York' => 'America/New_York',
    'America/Chicago' => 'America/Chicago',
    'America/North_Dakota/Center' => 'America/North_Dakota/Center',
    'America/Denver' => 'America/Denver',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Juneau' => 'America/Juneau',
    'America/Yakutat' => 'America/Yakutat',
    'America/Anchorage' => 'America/Anchorage',
    'America/Nome' => 'America/Nome',
    'America/Adak' => 'America/Adak',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'America/Phoenix' => 'America/Phoenix',
    'America/Boise' => 'America/Boise',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Detroit' => 'America/Detroit',
    'America/Menominee' => 'America/Menominee',
    'America/St_Johns' => 'America/St_Johns',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Halifax' => 'America/Halifax',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Montreal' => 'America/Montreal',
    'America/Toronto' => 'America/Toronto',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Nipigon' => 'America/Nipigon',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Regina' => 'America/Regina',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Edmonton' => 'America/Edmonton',
    'America/Vancouver' => 'America/Vancouver',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Coral_Harbour' => 'America/Coral_Harbour',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Yellowknife' => 'America/Yellowknife',
    'America/Inuvik' => 'America/Inuvik',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Dawson' => 'America/Dawson',
    'America/Cancun' => 'America/Cancun',
    'America/Merida' => 'America/Merida',
    'America/Monterrey' => 'America/Monterrey',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Tijuana' => 'America/Tijuana',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Nassau' => 'America/Nassau',
    'America/Barbados' => 'America/Barbados',
    'America/Belize' => 'America/Belize',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'America/Cayman' => 'America/Cayman',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Havana' => 'America/Havana',
    'America/Dominica' => 'America/Dominica',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Jamaica' => 'America/Jamaica',
    'America/Martinique' => 'America/Martinique',
    'America/Montserrat' => 'America/Montserrat',
    'America/Managua' => 'America/Managua',
    'America/Panama' => 'America/Panama',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/Miquelon' => 'America/Miquelon',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Tortola' => 'America/Tortola',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/La_Paz' => 'America/La_Paz',
    'America/Noronha' => 'America/Noronha',
    'America/Belem' => 'America/Belem',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Recife' => 'America/Recife',
    'America/Araguaina' => 'America/Araguaina',
    'America/Maceio' => 'America/Maceio',
    'America/Bahia' => 'America/Bahia',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Manaus' => 'America/Manaus',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santiago' => 'America/Santiago',
    'Pacific/Easter' => 'Pacific/Easter',
    'America/Bogota' => 'America/Bogota',
    'America/Curacao' => 'America/Curacao',
    'America/Guayaquil' => 'America/Guayaquil',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'America/Cayenne' => 'America/Cayenne',
    'America/Guyana' => 'America/Guyana',
    'America/Asuncion' => 'America/Asuncion',
    'America/Lima' => 'America/Lima',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Montevideo' => 'America/Montevideo',
    'America/Caracas' => 'America/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'Favoritos';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'Favorito';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Contactos de Google',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'Solicitud',
    2 => 'Acceso',
    3 => 'Invalido',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Usuario de Sugar',
    'support_portal' => 'Portal de Asistencia',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'Campaña',
    'email' => 'Correo electrónico',
    'workflow' => 'Flujo de actividad',
    'system' => 'Sistema',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'Campaña',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'Campaña',
    'email' => 'Correo electrónico',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'Documentación',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'Dos rangos',
    'show_buckets' => 'Tres rangos',
    'show_custom_buckets' => 'Rangos Personalizados',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'Año Basado en Fecha',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'Anual (subperíodos trimestrales)',
    'Quarter' => 'Trimestral (subperíodos mensuales)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'Líneas de Ingreso',
    'Opportunities' => 'Oportunidades',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'Sí',
    'no' => 'No',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'Alerta',
    'information' => 'Información',
    'other' => 'Otro',
    'success' => 'Éxito',
    'warning' => 'Aviso',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'PUBLICAR',
    'GET' => 'RECIBIR',
    'PUT' => 'PUT',
    'DELETE' => 'ELIMINAR',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'Manualmente',
    '5' => 'Cada 5 minutos',
    '15' => 'Cada 15 minutos',
    '30' => 'Cada 30 minutos',
    '60' => 'Cada hora',
];

$app_list_strings['moduleList']['KBDocuments'] = 'Base de conocimientos';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'Base de conocimientos';
$app_list_strings['moduleList']['KBContents'] = 'Base de Conocimiento';
$app_list_strings['moduleListSingular']['KBContents'] = 'Artículo de Base de Conocimiento';
$app_list_strings['moduleList']['KBArticles'] = 'Artículo de Base de Conocimiento';
$app_list_strings['moduleListSingular']['KBArticles'] = 'Artículo de Base de Conocimiento';
$app_list_strings['moduleList']['KBContentTemplates'] = 'Plantilla de la base de conocimientos';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'Plantilla de la base de conocimientos';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'Archivos incrustados';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'Archivo incrustado';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => 'ریال',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leke',
    'USD' => 'Dólares',
    'AFN' => 'Afganos',
    'ARS' => 'Pesos',
    'AWG' => 'Florines',
    'AUD' => 'Dólares',
    'AZN' => 'Nuevos Manats',
    'BSD' => 'Dólares',
    'BBD' => 'Dólares',
    'BYR' => 'Rublos',
    'EUR' => 'Euros',
    'BZD' => 'Dólares',
    'BMD' => 'Dólares',
    'BOB' => 'Bolivianos',
    'BAM' => 'Marka convertible',
    'BWP' => 'Pulas',
    'BGN' => 'Leva',
    'BRL' => 'Reales',
    'GBP' => 'Libras',
    'BND' => 'Dólares',
    'KHR' => 'Reales',
    'CAD' => 'Dólares',
    'KYD' => 'Dólares',
    'CLP' => 'Pesos',
    'CNY' => 'Yuan Renminbi',
    'COP' => 'Pesos',
    'CRC' => 'Colón',
    'HRK' => 'Kuna',
    'CUP' => 'Pesos',
    'CZK' => 'Coronas',
    'DKK' => 'Coronas',
    'DOP' => 'Pesos',
    'XCD' => 'Dólares',
    'EGP' => 'Libras',
    'SVC' => 'Colones',
    'EEK' => 'Coronas',
    'FKP' => 'Libras',
    'FJD' => 'Dólares',
    'GHC' => 'Cedis',
    'GIP' => 'Libras',
    'GTQ' => 'Quetzales',
    'GGP' => 'Libras',
    'GYD' => 'Dólares',
    'HNL' => 'Lempiras',
    'HKD' => 'Dólares',
    'HUF' => 'Florín',
    'ISK' => 'Kronur',
    'INR' => 'Rupias',
    'IDR' => 'Rupias',
    'IRR' => 'Reales',
    'IMP' => 'Libras',
    'ILS' => 'Nuevos Shekels',
    'JMD' => 'Dólares',
    'JPY' => 'Yen',
    'JEP' => 'Libras',
    'KZT' => 'Tenge',
    'KPW' => 'Won',
    'KRW' => 'Won',
    'KGS' => 'Som',
    'LAK' => 'Kip',
    'LVL' => 'Lati',
    'LBP' => 'Libras',
    'LRD' => 'Dólares',
    'CHF' => 'Francos suizos',
    'LTL' => 'Litai',
    'MKD' => 'Dinares',
    'MYR' => 'Ringgits',
    'MUR' => 'Rupias',
    'MXN' => 'Pesos',
    'MNT' => 'Tugriks',
    'MZN' => 'Meticales',
    'NAD' => 'Dólares',
    'NPR' => 'Rupias',
    'ANG' => 'Florines',
    'NZD' => 'Dólares',
    'NIO' => 'Córdobas',
    'NGN' => 'Nairas',
    'NOK' => 'Coronas',
    'OMR' => 'Reales',
    'PKR' => 'Rupias',
    'PAB' => 'Balboa',
    'PYG' => 'Guaraní',
    'PEN' => 'Nuevos Soles',
    'PHP' => 'Pesos',
    'PLN' => 'Zlotych',
    'QAR' => 'Reales',
    'RON' => 'New Lei',
    'RUB' => 'Rublos',
    'SHP' => 'Libras',
    'SAR' => 'Reales',
    'RSD' => 'Dinares',
    'SCR' => 'Rupias',
    'SGD' => 'Dólares',
    'SBD' => 'Dólares',
    'SOS' => 'Chelines',
    'ZAR' => 'Rand',
    'LKR' => 'Rupias',
    'SEK' => 'Coronas suecas',
    'SRD' => 'Dólares',
    'SYP' => 'Libras',
    'TWD' => 'Nuevos dólares',
    'THB' => 'Baht',
    'TTD' => 'Dólares',
    'TRY' => 'Lira',
    'TRL' => 'Liras',
    'TVD' => 'Dólares',
    'UAH' => 'Hryvnia',
    'UYU' => 'Pesos',
    'UZS' => 'Sums',
    'VEF' => 'Bolívares Fuertes',
    'VND' => 'Dong',
    'YER' => 'Reales',
    'ZWD' => 'Dólares de Zimbabwe',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'Muy alto',
    '4' => 'Alto',
    '3' => 'Neutro',
    '2' => 'Bajo',
    '1' => 'Muy bajo',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'Ninguno',
    'future' => 'Valor actual',
    'old' => 'Valor anterior',
    'both' => 'Valor actual y anterior',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Resultado individual',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'Procesando',
    'error' => 'Error',
    'success' => 'Correcto',
    'canceled' => 'Cancelado',
    'document_load' => 'Cargando plantilla',
    'tags_extract' => 'Extrayendo etiquetas',
    'tags_validate' => 'Validando etiquetas',
    'data_retrieving' => 'Recuperando datos',
    'serialize_document' => 'Recomponiendo el documento',
    'send_document' => 'Enviando el documento',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'Fusionar',
    'convert' => 'Fusión PDF',
    'multimerge' => 'Fusión múltiple',
    'multimerge_convert' => 'Fusión múltiple de PDF',
    'labelsgenerate' => 'Generar etiquetas',
    'labelsgenerate_convert' => 'Generar etiquetas en PDF',
    'excel' => 'Fusión de Excel',
    'excel_convert' => 'Convertir la fusión de Excel',
    'presentation' => 'Fusión de PowerPoint',
    'presentation_convert' => 'Fusión de PowerPoint en PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'Mis cuentas',
    'favorites' => 'Cuentas favoritas',
    'tags' => 'Cuentas etiquetadas',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'Todas las noticias',
    'General' => 'General',
    'Finance' => 'Financieras',
    'People' => 'Personal',
    'Press Releases' => 'Notas de prensa',
    'Other' => 'Otros',
];

$app_strings['LBL_OWNERS'] = 'Propietarios';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Cloud Drive';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'Dashlet de integración con Cloud Drive';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'Copiar enlace';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'Descargar';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Crear documento de Sugar';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'No se ha podido descargar el archivo';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'El dashlet de la nube no está presente';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Documento de Sugar creado';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'Enviar a DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign no está disponible desde esta ubicación.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'La fusión de documentos a Word/Excel/PowerPoint no está disponible en esta ubicación';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'La fusión de documentos a DocuSign no está disponible en esta ubicación';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'La fusión de documentos a PDF no está disponible en esta ubicación';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'El archivo firmado solo se subirá aquí si tiene permiso para subir a esta ubicación.';
$app_strings['LBL_DOC_MERGE_TO'] = 'Combinar documentos en';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word / Excel / Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'Mis archivos';
$app_strings['LBL_SHARED_WITH_ME'] = 'Compartido conmigo';
$app_strings['LBL_CLOUD_PROVIDER'] = 'Proveedor de la nube';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'Compartido conmigo';
$app_strings['LBL_MY_FILES'] = 'Mis archivos';
$app_strings['LBL_UPLOAD_FILE'] = 'Cargar archivo';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'Carpeta no encontrada';
$app_strings['LBL_CREATE_FOLDER'] = 'Crear carpeta';
$app_strings['LBL_LOAD_MORE'] = 'Cargar más...';
$app_strings['LBL_NEW_FOLDER'] = 'Nueva carpeta';
$app_strings['LBL_FOLDER_NAME'] = 'Nombre de carpeta: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'No tiene permiso para hacer eso en la ruta actual.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'No tiene permiso para seguir la ruta actual.';
$app_strings['LBL_FILE_UPLOADED'] = 'El archivo se ha cargado.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'Debido al tamaño del archivo, la carga tardará un poco.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'Uno o más registros de documentos no tienen un archivo adjunto. Adjunte archivos a los registros y pruebe de nuevo, o sincronice de manera individual registros específicos con archivos.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'No se ha encontrado la conexión con Google...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'No se ha encontrado la conexión con Microsoft...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'No se ha encontrado la conexión con Dropbox...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'La sincronización con OneDrive puede tardar un rato';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = '¿Seguro que quiere suprimir este archivo?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'La carga de OneDrive se ha completado.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' se ha cargado de manera correcta.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'Error al cargar las rutas.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'Se ha producido un error porque el archivo está dañado.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'El documento <i>"{{documentName}}"</i> se ha guardado en su unidad en la nube y se ha agregado al módulo Documentos.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'No tiene permiso para suprimir este archivo.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'No tiene permiso para eliminar esta carpeta.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'No tiene permisos para subir archivos a esta ubicación.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'No tiene permiso para crear una carpeta en esta ubicación.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'No se pueden crear carpetas en esta ubicación.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'No se pueden cargar archivos en esta ubicación.';
$app_strings['LBL_SITES'] = 'Sitios';
$app_strings['LBL_SHARED'] = 'Compartido';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'Enlace creado. Haga clic en el botón para copiar el enlace al portapapeles.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'Copiar al portapapeles';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-vacío-',
    'Exact' => 'Exacto',
    'Null_address_components' => 'Uno o más de los componentes de la dirección están vacíos',
    'Invalid_address' => 'Dirección no válida, el servidor ha devuelto el resultado Falso',
    'Invalid_server_response_not_XML' => 'Respuesta del servidor no válida, no es XML',
    'Invalid_address_no_location' => 'Dirección no válida, el servidor no ha devuelto ninguna ubicación',
    'Ambiguous_address' => 'Dirección ambigua, múltiples coincidencias',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'Carretera',
    'a' => 'Aéreo',
    'rd' => 'Carretera oscura',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['es_es', 'Inglés (Estados Unidos)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'Nueva York (EST)'],
    ['pst', 'Los Ángeles (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['Nuevo', 'Nuevo'],
    ['Asignado', 'Asignado'],
    ['Cerrado', 'Cerrado'],
    ['Pendiente de Información', 'Pendiente de Información'],
    ['Rechazado', 'Rechazado'],
    ['Duplicar', 'Duplicar'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['Administración', 'Administración'],
    ['Producto', 'Producto'],
    ['Usuario', 'Usuario'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'Alta'],
    ['P2', 'Media'],
    ['P3', 'Baja'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['usuario', 'Usuario'],
    ['administrador,usuario', 'Admin'],
    ['administrador de cuentas,usuario', 'Administrador de cuentas'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', 'Últimos 30 días'],
    ['last_90_days', 'Últimos 90 días'],
    ['this_year', 'Último año'],
    ['personalizado', 'Rango personalizado'],
    ['todo', 'Todo'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['Predeterminado', 'Predeterminado'],
    ['Color', 'Color sólido'],
    ['Url', 'Imagen personalizada'],
];
