<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'US English',
    'moduleList' => [
        'Home' => 'Home',
        'Contacts' => 'Contacts',
        'Accounts' => 'Accounts',
        'Opportunities' => 'Opportunities',
        'Cases' => 'Cases',
        'Notes' => 'Notes',
        'Calls' => 'Calls',
        'Emails' => 'Emails',
        'Meetings' => 'Meetings',
        'Tasks' => 'Tasks',
        'Calendar' => 'Calendar',
        'Leads' => 'Leads',
        'Currencies' => 'Currencies',
        'Contracts' => 'Contracts',
        'Quotes' => 'Quotes',
        'Products' => 'Quoted Line Items',
        'WebLogicHooks' => 'Web Logic Hooks',
        'ProductCategories' => 'Product Categories',
        'ProductTypes' => 'Product Types',
        'ProductTemplates' => 'Product Catalog',
        'ProductBundles' => 'Product Bundles',
        'ProductBundleNotes' => 'Product Bundle Notes',
        'Reports' => 'Reports',
        'Forecasts' => 'Forecasts',
        'ForecastWorksheets' => 'Forecast Worksheets',
        'ForecastManagerWorksheets' => 'Forecast Manager Worksheets',
        'VisualPipeline' => 'Visual Pipeline',
        'ConsoleConfiguration' => 'Console Configuration',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'Quotas',
        'Teams' => 'Teams',
        'TeamNotices' => 'Team Notices',
        'Manufacturers' => 'Manufacturers',
        'Activities' => 'Activities',
        'Comments' => 'Comments',
        'Subscriptions' => 'Subscriptions',
        'Bugs' => 'Bugs',
        'Feeds' => 'RSS',
        'iFrames' => 'My Sites',
        'TimePeriods' => 'Time Periods',
        'TaxRates' => 'Tax Rates',
        'ContractTypes' => 'Contract Types',
        'Schedulers' => 'Schedulers',
        'Project' => 'Projects',
        'ProjectTask' => 'Project Tasks',
        'Campaigns' => 'Campaigns',
        'CampaignLog' => 'Campaign Log',
        'CampaignTrackers' => 'Campaign Trackers',
        'Documents' => 'Documents',
        'DocumentRevisions' => 'Document Revisions',
        'Connectors' => 'Connectors',
        'Notifications' => 'Notifications',
        'Sync' => 'Sync',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => 'External Users',
        'ReportMaker' => 'Advanced Reports',
        'DataSets' => 'Data Formats',
        'CustomQueries' => 'Custom Queries',
        'pmse_Inbox' => 'Processes',
        'pmse_Project' => 'Process Definitions',
        'pmse_Business_Rules' => 'Process Business Rules',
        'pmse_Emails_Templates' => 'Process Email Templates',
        'BusinessCenters' => 'Business Centers',
        'Shifts' => 'Shifts',
        'ShiftExceptions' => 'Shift Exceptions',
        'Purchases' => 'Purchases',
        'PurchasedLineItems' => 'Purchased Line Items',
        'MobileDevices' => 'MobileDevices',
        'PushNotifications' => 'PushNotifications',
        'Escalations' => 'Escalations',
        'DocumentTemplates' => 'Document Templates',
        'DocumentMerges' => 'Document Merges',
        'CloudDrivePaths' => 'Cloud Drive Paths',
        'WorkFlow' => 'Workflow Definitions',
        'EAPM' => 'External Accounts',
        'Worksheet' => 'Worksheet',
        'Users' => 'Users',
        'Employees' => 'Employees',
        'Administration' => 'Administration',
        'ACLRoles' => 'Roles',
        'InboundEmail' => 'Inbound Email',
        'Releases' => 'Releases',
        'Prospects' => 'Targets',
        'Queues' => 'Queues',
        'EmailMarketing' => 'Email Marketing',
        'EmailTemplates' => 'Email Templates',
        'SNIP' => 'Email Archiving',
        'ProspectLists' => 'Target Lists',
        'SavedSearch' => 'Saved Searches',
        'UpgradeWizard' => 'Upgrade Wizard',
        'Trackers' => 'Trackers',
        'TrackerPerfs' => 'Tracker Performance',
        'TrackerSessions' => 'Tracker Sessions',
        'TrackerQueries' => 'Tracker Queries',
        'FAQ' => 'FAQ',
        'Newsletters' => 'Newsletters',
        'SugarFavorites' => 'Favorites',
        'PdfManager' => 'PDF Manager',
        'DataArchiver' => 'Data Archiver',
        'ArchiveRuns' => 'Archive Runs',

        'OAuthKeys' => 'OAuth Consumer Keys',
        'OAuthTokens' => 'OAuth Tokens',
        'Filters' => 'Filters',
        'UserSignatures' => 'Email Signatures',
        'Shippers' => 'Shipping Providers',
        'Styleguide' => 'Styleguide',
        'Feedbacks' => 'Feedbacks',
        'Tags' => 'Tags',
        'Categories' => 'Categories',
        'Dashboards' => 'Dashboards',
        'OutboundEmail' => 'Email Settings',
        'EmailParticipants' => 'Email Participants',
        'DataPrivacy' => 'Data Privacy',
        'ReportSchedules' => 'Report Schedules',
        'CommentLog' => 'Comment Log',
        'Holidays' => 'Holidays',
        'ChangeTimers' => 'Change Timers',
        'Metrics' => 'Metrics',
        'Messages' => 'Messages',
        'Audit' => 'Audit',
        'RevenueLineItems' => 'Revenue Line Items',
        'DocuSignEnvelopes' => 'DocuSign Envelopes',
        'Geocode' => 'Geocode',
        'DRI_Workflows' => 'Smart Guides',
        'DRI_Workflow_Task_Templates' => 'Smart Guide Activity Templates',
        'DRI_SubWorkflows' => 'Smart Guide Stages',
        'DRI_Workflow_Templates' => 'Smart Guide Templates',
        'CJ_WebHooks' => 'Sugar Automate Web Hooks',
        'CJ_Forms' => 'Smart Guide Sugar Actions',
        'DRI_SubWorkflow_Templates' => 'Smart Guide Stage Templates',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub Module Event Push Subscriptions',
    ],

    'moduleIconList' => [
        'Home' => 'Ho',
        'Contacts' => 'Co',
        'Accounts' => 'Ac',
        'Opportunities' => 'Op',
        'Cases' => 'Cs',
        'Notes' => 'Nt',
        'Calls' => 'Cl',
        'Emails' => 'Em',
        'Meetings' => 'Me',
        'Tasks' => 'Ts',
        'Calendar' => 'Ca',
        'Leads' => 'Le',
        'Currencies' => 'Cu',
        'Contracts' => 'Co',
        'Quotes' => 'Qu',
        'Products' => 'QL',
        'WebLogicHooks' => 'WL',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'PT',
        'ProductTemplates' => 'PC',
        'ProductBundles' => 'PB',
        'ProductBundleNotes' => 'PB',
        'Reports' => 'Re',
        'Forecasts' => 'Fo',
        'ForecastWorksheets' => 'FW',
        'ForecastManagerWorksheets' => 'FM',
        'Quotas' => 'Fo',
        'VisualPipeline' => 'VP',
        'ConsoleConfiguration' => 'CC',
        'SugarLive' => 'Su',
        'Teams' => 'Te',
        'TeamNotices' => 'TN',
        'Manufacturers' => 'Ma',
        'Activities' => 'Ac',
        'Comments' => 'Co',
        'Subscriptions' => 'Su',
        'Bugs' => 'Bu',
        'Feeds' => 'RS',
        'iFrames' => 'MS',
        'TimePeriods' => 'TP',
        'TaxRates' => 'TR',
        'ContractTypes' => 'CT',
        'Schedulers' => 'Sc',
        'Project' => 'Pr',
        'ProjectTask' => 'PT',
        'Campaigns' => 'Ca',
        'CampaignLog' => 'CL',
        'CampaignTrackers' => 'CT',
        'Documents' => 'Do',
        'DocumentRevisions' => 'DR',
        'Connectors' => 'Co',
        'Notifications' => 'No',
        'Sync' => 'Sy',
        'HintAccountsets' => 'Hi',
        'HintNotificationTargets' => 'Hi',
        'HintNewsNotifications' => 'Hi',
        'HintEnrichFieldConfigs' => 'Hi',
        'ExternalUsers' => 'EU',
        'ReportMaker' => 'AR',
        'DataSets' => 'DF',
        'CustomQueries' => 'CQ',
        'pmse_Inbox' => 'Pr',
        'pmse_Project' => 'PD',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE',
        'BusinessCenters' => 'BC',
        'Shifts' => 'Sh',
        'ShiftExceptions' => 'SE',
        'Purchases' => 'Pu',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'Mo',
        'PushNotifications' => 'Pu',
        'Escalations' => 'Es',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'WD',
        'EAPM' => 'EA',
        'Worksheet' => 'Wo',
        'Users' => 'Us',
        'Employees' => 'Em',
        'Administration' => 'Ad',
        'ACLRoles' => 'Ro',
        'InboundEmail' => 'IE',
        'Releases' => 'Re',
        'Prospects' => 'Ta',
        'Queues' => 'Qu',
        'EmailMarketing' => 'EM',
        'EmailTemplates' => 'ET',
        'SNIP' => 'EA',
        'ProspectLists' => 'TL',
        'SavedSearch' => 'SS',
        'UpgradeWizard' => 'UW',
        'Trackers' => 'Tr',
        'TrackerPerfs' => 'TP',
        'TrackerSessions' => 'TS',
        'TrackerQueries' => 'TQ',
        'FAQ' => 'FA',
        'Newsletters' => 'Ne',
        'SugarFavorites' => 'Fa',
        'PdfManager' => 'PM',
        'DataArchiver' => 'DA',
        'ArchiveRuns' => 'AR',
        'OAuthKeys' => 'OC',
        'OAuthTokens' => 'OT',
        'Filters' => 'Fi',
        'UserSignatures' => 'ES',
        'Shippers' => 'SP',
        'Styleguide' => 'St',
        'Feedbacks' => 'Fe',
        'Tags' => 'Ta',
        'Categories' => 'Ca',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'ES',
        'EmailParticipants' => 'EP',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'RS',
        'CommentLog' => 'CL',
        'Holidays' => 'Ho',
        'ChangeTimers' => 'CT',
        'Metrics' => 'Me',
        'Messages' => 'Me',
        'Audit' => 'Au',
        'RevenueLineItems' => 'RL',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'Ge',
        'DRI_Workflows' => 'SG',
        'DRI_Workflow_Task_Templates' => 'SG',
        'DRI_SubWorkflows' => 'SG',
        'DRI_Workflow_Templates' => 'SG',
        'CJ_WebHooks' => 'SA',
        'CJ_Forms' => 'SG',
        'DRI_SubWorkflow_Templates' => 'SG',
        'Library' => 'Li',
        'EmailAddresses' => 'EA',
        'Words' => 'Wo',
        'Sugar_Favorites' => 'Fa',
        'KBDocuments' => 'KB',
        'KBContents' => 'KB',
        'KBArticles' => 'KB',
        'KBContentTemplates' => 'KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'EF',
    ],

    'moduleListSingular' => [
        'Home' => 'Home',
        'Dashboards' => 'Dashboard',
        'Styleguide' => 'Styleguide',
        'Contacts' => 'Contact',
        'Accounts' => 'Account',
        'Opportunities' => 'Opportunity',
        'Cases' => 'Case',
        'Notes' => 'Note',
        'Calls' => 'Call',
        'Emails' => 'Email',
        'Meetings' => 'Meeting',
        'Tasks' => 'Task',
        'Calendar' => 'Calendar',
        'Leads' => 'Lead',
        'Manufacturers' => 'Manufacturer',
        'VisualPipeline' => 'VisualPipeline',
        'ConsoleConfiguration' => 'ConsoleConfiguration',
        'MobileDevices' => 'MobileDevice',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'Contract',
        'Quotes' => 'Quote',
        'Products' => 'Quoted Line Item',
        'ProductCategories' => 'Product Category',
        'ProductBundles' => 'Product Bundle',
        'ProductBundleNotes' => 'Product Bundle Note',
        'RevenueLineItems' => 'Revenue Line Item',
        'WebLogicHooks' => 'Web Logic Hook',
        'Reports' => 'Report',
        'Forecasts' => 'Forecast',
        'ForecastWorksheets' => 'Forecast Worksheet',
        'ForecastManagerWorksheets' => 'Forecast Manager Worksheet',
        'Quotas' => 'Quota',
        'Teams' => 'Team',
        'TeamNotices' => 'Team Notice',
        'Activities' => 'Activity',
        'ActivityStream' => 'Activity Stream',
        'Bugs' => 'Bug',
        'Feeds' => 'RSS',
        'iFrames' => 'My Sites',
        'TimePeriods' => 'Time Period',
        'TaxRates' => 'Tax Rate',
        'ContractTypes' => 'Contract Type',
        'Schedulers' => 'Scheduler',
        'Campaigns' => 'Campaign',
        'CampaignLog' => 'Campaign Log',
        'Project' => 'Project',
        'ProjectTask' => 'Project Task',
        'Prospects' => 'Target',
        'ProspectLists' => 'Target List',
        'CampaignTrackers' => 'Campaign Tracker',
        'Documents' => 'Document',
        'DocumentRevisions' => 'Document Revision',
        'Connectors' => 'Connector',
        'Notifications' => 'Notification',
        'Sync' => 'Sync',
        'PdfManager' => 'PDF Manager',
        'DataArchiver' => 'Data Archiver',
        'ArchiveRuns' => 'Archive Runs',
        'ExternalUsers' => 'External User',
        'ReportMaker' => ' Advanced Report',
        'DataSets' => 'Data Format',
        'CustomQueries' => 'Custom Query',
        'pmse_Inbox' => 'Process',
        'pmse_Project' => 'Process Definition',
        'pmse_Business_Rules' => 'Process Business Rule',
        'pmse_Emails_Templates' => 'Process Email Template',
        'BusinessCenters' => 'Business Center',
        'Shifts' => 'Shift',
        'ShiftExceptions' => 'Shift Exceptions',
        'Purchases' => 'Purchase',
        'PurchasedLineItems' => 'Purchased Line Item',
        'PushNotifications' => 'PushNotification',
        'Escalations' => 'Escalation',
        'DocumentTemplates' => 'Document Template',
        'DocumentMerges' => 'Document Merge',
        'CloudDrivePaths' => 'Cloud Drive Path',
        'WorkFlow' => 'Workflow',
        'EAPM' => 'External Account',
        'Worksheet' => 'Worksheet',
        'Users' => 'User',
        'SugarFavorites' => 'SugarFavorites',
        'Employees' => 'Employee',
        'Administration' => 'Administration',
        'ACLRoles' => 'Role',
        'InboundEmail' => 'Inbound Email',
        'Releases' => 'Release',
        'Queues' => 'Queue',
        'EmailMarketing' => 'Email Marketing',
        'EmailTemplates' => 'Email Template',
        'SNIP' => 'Email Archiving',
        'SavedSearch' => 'Saved Search',
        'UpgradeWizard' => 'Upgrade Wizard',
        'Trackers' => 'Tracker',
        'TrackerPerfs' => 'Tracker Performance',
        'TrackerSessions' => 'Tracker Session',
        'TrackerQueries' => 'Tracker Query',
        'FAQ' => 'FAQ',
        'Newsletters' => 'Newsletter',
        'OAuthKeys' => 'OAuth Consumer Key',
        'OAuthTokens' => 'OAuth Token',
        'Filters' => 'Filter',
        'Comments' => 'Comment',
        'CommentLog' => 'Comment Log',
        'Currencies' => 'Currency',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'Product Type',
        'Shippers' => 'Shipping Provider',
        'Subscriptions' => 'Subscription',
        'UserSignatures' => 'Email Signature',
        'Feedbacks' => 'Feedback',
        'Tags' => 'Tag',
        'Categories' => 'Category',
        'OutboundEmail' => 'Email Setting',
        'EmailParticipants' => 'Email Participant',
        'DataPrivacy' => 'Data Privacy',
        'ReportSchedules' => 'Report Schedule',
        'Holidays' => 'Holiday',
        'ChangeTimers' => 'Change Timer',
        'Metrics' => 'Metric',
        'Messages' => 'Message',
        'Audit' => 'Audit',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => 'Geocode',
        'DRI_Workflows' => 'Smart Guide',
        'DRI_Workflow_Task_Templates' => 'Smart Guide Activity Template',
        'DRI_SubWorkflows' => 'Smart Guide Stage',
        'DRI_Workflow_Templates' => 'Smart Guide Template',
        'CJ_WebHooks' => 'Sugar Automate Web Hook',
        'CJ_Forms' => 'Smart Guide Sugar Action',
        'DRI_SubWorkflow_Templates' => 'Smart Guide Stage Template',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub Module Event Push Subscription',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'Yes',
        '2' => 'No',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'No',
        1 => 'Yes',
    ],

    'notifications_status_dom' => [
        0 => 'Unread',
        1 => 'Read',
    ],

    'optout_dom' => [
        '' => '-none-',
        'false' => 'No',
        'true' => 'Yes',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'Analyst',
        'Competitor' => 'Competitor',
        'Customer' => 'Customer',
        'Integrator' => 'Integrator',
        'Investor' => 'Investor',
        'Partner' => 'Partner',
        'Press' => 'Press',
        'Prospect' => 'Prospect',
        'Reseller' => 'Reseller',
        'Other' => 'Other',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'Apparel',
        'Banking' => 'Banking',
        'Biotechnology' => 'Biotechnology',
        'Chemicals' => 'Chemicals',
        'Communications' => 'Communications',
        'Construction' => 'Construction',
        'Consulting' => 'Consulting',
        'Education' => 'Education',
        'Electronics' => 'Electronics',
        'Energy' => 'Energy',
        'Engineering' => 'Engineering',
        'Entertainment' => 'Entertainment',
        'Environmental' => 'Environmental',
        'Finance' => 'Finance',
        'Government' => 'Government',
        'Healthcare' => 'Healthcare',
        'Hospitality' => 'Hospitality',
        'Insurance' => 'Insurance',
        'Machinery' => 'Machinery',
        'Manufacturing' => 'Manufacturing',
        'Media' => 'Media',
        'Not For Profit' => 'Not For Profit',
        'Recreation' => 'Recreation',
        'Retail' => 'Retail',
        'Shipping' => 'Shipping',
        'Technology' => 'Technology',
        'Telecommunications' => 'Telecommunications',
        'Transportation' => 'Transportation',
        'Utilities' => 'Utilities',
        'Other' => 'Other',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF and CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'Chart',
        'Data Table' => 'Data Table',
        'Chart and Data Table' => 'Chart and Data Table',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'Inbound',
        'Outbound' => 'Outbound',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'Chat',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'Tier 1',
        'T2' => 'Tier 2',
        'T3' => 'Tier 3',
        'T4' => 'Tier 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'Completed' => 'Completed',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'Future',
        'Active' => 'Active',
        'Past' => 'Past',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'Self Generated',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'Cold Call',
        'Existing Customer' => 'Existing Customer',
        'Self Generated' => 'Self Generated',
        'Employee' => 'Employee',
        'Partner' => 'Partner',
        'Public Relations' => 'Public Relations',
        'Direct Mail' => 'Direct Mail',
        'Conference' => 'Conference',
        'Trade Show' => 'Trade Show',
        'Web Site' => 'Web Site',
        'Word of mouth' => 'Word of mouth',
        'Email' => 'Email',
        'Campaign' => 'Campaign',
        'Support Portal User Registration' => 'Support Portal User Registration',
        'Other' => 'Other',
    ],
    'metric_status_dom' => [
        'Inactive' => 'Inactive',
        'Active' => 'Active',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'Existing Business',
        'New Business' => 'New Business',
    ],
    'taxrate_status_dom' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive',
    ],
    'roi_type_dom' => [
        'Revenue' => 'Revenue',
        'Investment' => 'Investment',
        'Expected_Revenue' => 'Expected Revenue',
        'Budget' => 'Budget',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'Primary Decision Maker',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primary Decision Maker',
        'Business Decision Maker' => 'Business Decision Maker',
        'Business Evaluator' => 'Business Evaluator',
        'Technical Decision Maker' => 'Technical Decision Maker',
        'Technical Evaluator' => 'Technical Evaluator',
        'Executive Sponsor' => 'Executive Sponsor',
        'Influencer' => 'Influencer',
        'Other' => 'Other',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive',
    ],

    'shipper_status_dom' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'Primary Contact',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'Primary Contact',
        'Alternate Contact' => 'Alternate Contact',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'Beside Field Value',
        'field_on_top' => 'Above Field Value',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'Net 15',
        'Net 30' => 'Net 30',
    ],
    'sales_stage_default_key' => 'Prospecting',
    'fts_type' => [
        'Elastic' => 'ElasticSearch',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'Prospecting',
        'Qualification' => 'Qualification',
        'Needs Analysis' => 'Needs Analysis',
        'Value Proposition' => 'Value Proposition',
        'Id. Decision Makers' => 'Id. Decision Makers',
        'Perception Analysis' => 'Perception Analysis',
        'Proposal/Price Quote' => 'Proposal/Price Quote',
        'Negotiation/Review' => 'Negotiation/Review',
        'Closed Won' => 'Closed Won',
        'Closed Lost' => 'Closed Lost',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'New',
        'In Progress' => 'In Progress',
        'Closed Won' => 'Closed Won',
        'Closed Lost' => 'Closed Lost',
        'Converted to Quote' => 'Converted to Quote',
    ],
    'sales_status_dom' => [
        'New' => 'New',
        'In Progress' => 'In Progress',
        'Closed Won' => 'Closed Won',
        'Closed Lost' => 'Closed Lost',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'Include',
        'exclude' => 'Exclude',
    ],
    'commit_stage_dom' => [
        'include' => 'Include',
        'upside' => 'Upside',
        'exclude' => 'Exclude',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'Include',
        'upside' => 'Upside',
        'exclude' => 'Exclude',
    ],

    'in_total_group_stages' => [
        'Draft' => 'Draft',
        'Negotiation' => 'Negotiation',
        'Delivered' => 'Delivered',
        'On Hold' => 'On Hold',
        'Confirmed' => 'Confirmed',
        'Closed Accepted' => 'Closed Accepted',
        'Closed Lost' => 'Closed Lost',
        'Closed Dead' => 'Closed Dead',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'Call',
        'Meeting' => 'Meeting',
        'Task' => 'Task',
        'Email' => 'Email',
        'Note' => 'Note',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'Mr.',
        'Ms.' => 'Ms.',
        'Mrs.' => 'Mrs.',
        'Dr.' => 'Dr.',
        'Prof.' => 'Prof.',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'None',
        60 => '1 minute prior',
        300 => '5 minutes prior',
        600 => '10 minutes prior',
        900 => '15 minutes prior',
        1800 => '30 minutes prior',
        3600 => '1 hour prior',
        7200 => '2 hours prior',
        10800 => '3 hours prior',
        18000 => '5 hours prior',
        86400 => '1 day prior',
        ],

        'task_priority_default' => 'Medium',
        'task_priority_dom' => [
        'High' => 'High',
        'Medium' => 'Medium',
        'Low' => 'Low',
        ],
        'task_status_default' => 'Not Started',
        'task_status_dom' => [
        'Not Started' => 'Not Started',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Pending Input' => 'Pending Input',
        'Deferred' => 'Deferred',
        'Not Applicable' => 'Not Applicable',
        ],
        'meeting_status_default' => 'Planned',
        'meeting_status_dom' => [
        'Planned' => 'Scheduled',
        'Held' => 'Held',
        'Not Held' => 'Canceled',
        'Deferred' => 'Deferred',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'Other',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'Planned',
        'call_status_dom' => [
        'Planned' => 'Scheduled',
        'In Progress' => 'In Progress',
        'Held' => 'Held',
        'Not Held' => 'Canceled',
        'Deferred' => 'Deferred',
        ],
        'call_direction_default' => 'Outbound',
        'call_direction_dom' => [
        'Inbound' => 'Inbound',
        'Outbound' => 'Outbound',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'New',
        'Assigned' => 'Assigned',
        'In Process' => 'In Process',
        'Converted' => 'Converted',
        'Recycled' => 'Recycled',
        'Dead' => 'Dead',
        ],
        'gender_list' => [
        'male' => 'Male',
        'female' => 'Female',
        'other' => 'Other',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'New',
        'case_status_dom' => [
        'New' => 'New',
        'Assigned' => 'Assigned',
        'Closed' => 'Closed',
        'Pending Input' => 'Pending Input',
        'Rejected' => 'Rejected',
        'Duplicate' => 'Duplicate',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'High',
        'P2' => 'Medium',
        'P3' => 'Low',
        ],
        'user_type_dom' => [
        'RegularUser' => 'Regular User',
        'Administrator' => 'Administrator',
        ],
        'user_type_bool_dom' => [
            false => 'Regular User',
            true => 'Administrator',
        ],
        'user_type_group_bool_dom' => [
            true => 'Group User',
        ],
        'user_type_portal_bool_dom' => [
            true => 'Portal API User',
        ],
        'license_type_dom' => [
        'CURRENT' => 'Current Product',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive',
        ],
        'employee_status_dom' => [
        'Active' => 'Active',
        'Terminated' => 'Terminated',
        'Leave of Absence' => 'Leave of Absence',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive',
        ],
        'project_task_priority_options' => [
        'High' => 'High',
        'Medium' => 'Medium',
        'Low' => 'Low',
        ],
        'project_task_priority_default' => 'Medium',

        'project_task_status_options' => [
        'Not Started' => 'Not Started',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Pending Input' => 'Pending Input',
        'Deferred' => 'Deferred',
        ],
        'project_task_utilization_options' => [
        '0' => 'none',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'Draft',
        'In Review' => 'In Review',
        'Published' => 'Published',
        ],
        'project_status_default' => 'Draft',

        'project_duration_units_dom' => [
        'Days' => 'Days',
        'Hours' => 'Hours',
        ],

        'project_priority_options' => [
        'High' => 'High',
        'Medium' => 'Medium',
        'Low' => 'Low',
        ],
        'project_priority_default' => 'Medium',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Accounts',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'Account',
        'Opportunities' => 'Opportunity',
        'Cases' => 'Case',
        'Leads' => 'Lead',
        'Contacts' => 'Contacts', // cn (11/22/2005) added to support Emails
        'Products' => 'Quoted Line Item',
        'Quotes' => 'Quote',
        'Bugs' => 'Bug',
        'Project' => 'Project',

        'Prospects' => 'Target',
        'ProjectTask' => 'Project Task',

        'Tasks' => 'Task',
        'KBContents' => 'Knowledge Base',
        'Notes' => 'Note',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'Account',
        'Contacts' => 'Contact',
        'Opportunities' => 'Opportunity',
        'Tasks' => 'Task',
        'ProductTemplates' => 'Product Catalog',
        'Quotes' => 'Quote',
        'Products' => 'Quoted Line Item',
        'Contracts' => 'Contract',
        'Emails' => 'Email',

        'Bugs' => 'Bug',
        'Project' => 'Project',
        'ProjectTask' => 'Project Task',
        'Prospects' => 'Target',
        'Cases' => 'Case',
        'Leads' => 'Lead',

        'Meetings' => 'Meeting',
        'Calls' => 'Call',
        'KBContents' => 'Knowledge Base',
        'PurchasedLineItems' => 'Purchased Line Item',
        'Purchases' => 'Purchase',
        'Escalations' => 'Escalation',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'Account',
        'Contacts' => 'Contact',
        'Employees' => 'Employee',
        'Leads' => 'Lead',
        'Prospects' => 'Target',
        'Users' => 'User',
        ],

        'parent_type_display' => [
        'Accounts' => 'Account',
        'Contacts' => 'Contact',
        'Tasks' => 'Task',
        'Opportunities' => 'Opportunity',
        'Products' => 'Quoted Line Item',
        'Quotes' => 'Quote',

        'Bugs' => 'Bugs',
        'Cases' => 'Case',
        'Leads' => 'Lead',

        'Project' => 'Project',
        'ProjectTask' => 'Project Task',

        'Prospects' => 'Target',
        'KBContents' => 'Knowledge Base',
        'Notes' => 'Note',
        'PurchasedLineItems' => 'Purchased Line Item',
        'Purchases' => 'Purchase',
        'Escalations' => 'Escalation',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'Case',
        ],

        'product_status_default_key' => 'Ship',
        'product_status_quote_key' => 'Quotes',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'Quoted',
        'Orders' => 'Ordered',
        'Ship' => 'Shipped',
        ],
        'active_status_dom' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive',
        'Retired' => 'Retired',
        ],
        'appearance_options' => [
        'system_default' => 'Use system setting',
        'light' => 'Light',
        'dark' => 'Dark',
        ],


        'pricing_formula_default_key' => 'Fixed',
        'pricing_formula_dom' => [
        'Fixed' => 'Fixed Price',
        'ProfitMargin' => 'Profit Margin',
        'PercentageMarkup' => 'Markup over Cost',
        'PercentageDiscount' => 'Discount from List',
        'IsList' => 'Same as List',
        ],
        'product_template_status_dom' => [
        'Available' => 'In Stock',
        'Unavailable' => 'Out Of Stock',
        ],
        'tax_class_dom' => [
        'Taxable' => 'Taxable',
        'Non-Taxable' => 'Non-Taxable',
        ],
        'support_term_dom' => [
        '+6 months' => 'Six months',
        '+1 year' => 'One year',
        '+2 years' => 'Two years',
        ],

        'quote_type_dom' => [
        'Quotes' => 'Quote',
        'Orders' => 'Order',
        ],
        'default_quote_stage_key' => 'Draft',
        'quote_stage_dom' => [
        'Draft' => 'Draft',
        'Negotiation' => 'Negotiation',
        'Delivered' => 'Delivered',
        'On Hold' => 'On Hold',
        'Confirmed' => 'Confirmed',
        'Closed Accepted' => 'Closed Accepted',
        'Closed Lost' => 'Closed Lost',
        'Closed Dead' => 'Closed Dead',
        ],
        'default_order_stage_key' => 'Pending',
        'order_stage_dom' => [
        'Pending' => 'Pending',
        'Confirmed' => 'Confirmed',
        'On Hold' => 'On Hold',
        'Shipped' => 'Shipped',
        'Cancelled' => 'Cancelled',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'Primary Decision Maker',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primary Decision Maker',
        'Business Decision Maker' => 'Business Decision Maker',
        'Business Evaluator' => 'Business Evaluator',
        'Technical Decision Maker' => 'Technical Decision Maker',
        'Technical Evaluator' => 'Technical Evaluator',
        'Executive Sponsor' => 'Executive Sponsor',
        'Influencer' => 'Influencer',
        'Other' => 'Other',
        ],
        'layouts_dom' => [
        'Standard' => 'Quote',
        'Invoice' => 'Invoice',
        ],
        'issue_priority_default_key' => 'Medium',
        'issue_priority_dom' => [
        'Urgent' => 'Urgent',
        'High' => 'High',
        'Medium' => 'Medium',
        'Low' => 'Low',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'Accepted',
        'Duplicate' => 'Duplicate',
        'Closed' => 'Closed',
        'Out of Date' => 'Out of Date',
        'Invalid' => 'Invalid',
        ],

        'issue_status_default_key' => 'New',
        'issue_status_dom' => [
        'New' => 'New',
        'Assigned' => 'Assigned',
        'Closed' => 'Closed',
        'Pending' => 'Pending',
        'Rejected' => 'Rejected',
        ],

        'bug_priority_default_key' => 'Medium',
        'bug_priority_dom' => [
        'Urgent' => 'Urgent',
        'High' => 'High',
        'Medium' => 'Medium',
        'Low' => 'Low',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'Accepted',
        'Duplicate' => 'Duplicate',
        'Fixed' => 'Fixed',
        'Out of Date' => 'Out of Date',
        'Invalid' => 'Invalid',
        'Later' => 'Later',
        ],
        'bug_status_default_key' => 'New',
        'bug_status_dom' => [
        'New' => 'New',
        'Assigned' => 'Assigned',
        'Closed' => 'Closed',
        'Pending' => 'Pending',
        'Rejected' => 'Rejected',
        ],
        'bug_type_default_key' => 'Bug',
        'bug_type_dom' => [
        'Defect' => 'Defect',
        'Feature' => 'Feature',
        ],
        'case_type_dom' => [
        'Administration' => 'Administration',
        'Product' => 'Product',
        'User' => 'User',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'Internal',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'Email',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'Internal',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'Email',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        'Phone' => 'Phone',
        'Chat' => 'Chat',
        'Chatbot' => 'Chatbot',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'Request for Data Privacy Policy',
        'Send Personal Information being processed' => 'Send Personal Information Being Processed',
        'Rectify Information' => 'Rectify Information',
        'Request to Erase Information' => 'Request to Erase Information',
        'Export Information' => 'Export Information',
        'Restrict Processing' => 'Restrict Processing',
        'Object to Processing' => 'Object to Processing',
        'Consent to Process' => 'Consent to Process',
        'Withdraw Consent' => 'Withdraw Consent',
        'Other' => 'Other',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'Business Communications',
        'Marketing Communications by company' => 'Marketing Communications by company',
        'Marketing Communications by partners' => 'Marketing Communications by partners',
        ],
        'dataprivacy_status_default_key' => 'Open',
        'dataprivacy_status_dom' => [
        'Open' => 'Open',
        'Closed' => 'Completed',
        'Rejected' => 'Rejected',
        ],
        'dataprivacy_priority_default_key' => 'Low',
        'dataprivacy_priority_dom' => [
        'Low' => 'Low',
        'Medium' => 'Medium',
        'High' => 'High',
        ],
        'business_day_status_dom' => [
        'Open' => 'Open',
        'Open 24 Hours' => 'Open 24 Hours',
        'Closed' => 'Closed',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'Accounts',
        'Activities' => 'Activities',
        'Bug Tracker' => 'Bug Tracker',
        'Calendar' => 'Calendar',
        'Calls' => 'Calls',
        'Campaigns' => 'Campaigns',
        'Cases' => 'Cases',
        'Contacts' => 'Contacts',
        'Currencies' => 'Currencies',
        'Dashboard' => 'Dashboard',
        'Documents' => 'Documents',
        'Emails' => 'Emails',
        'Feeds' => 'Feeds',
        'Forecasts' => 'Forecasts',
        'Help' => 'Help',
        'Home' => 'Home',
        'Leads' => 'Leads',
        'Meetings' => 'Meetings',
        'Notes' => 'Notes',
        'Opportunities' => 'Opportunities',
        'Outlook Plugin' => 'Outlook Plugin',
        'Product Catalog' => 'Product Catalog',
        'Products' => 'Quoted Line Items',
        'RevenueLineItems' => 'Revenue Line Items',
        'Projects' => 'Projects',
        'Quotes' => 'Quotes',
        'Releases' => 'Releases',
        'RSS' => 'RSS',
        'Studio' => 'Studio',
        'Upgrade' => 'Upgrade',
        'Users' => 'Users',
        'OutboundEmail' => 'Email Settings',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'Planning',
        'Active' => 'Active',
        'Inactive' => 'Inactive',
        'Complete' => 'Complete',
        'In Queue' => 'In Queue',
        'Sending' => 'Sending',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'Telesales',
        'Mail' => 'Mail',
        'Email' => 'Email',
        'Print' => 'Print',
        'Web' => 'Web',
        'Radio' => 'Radio',
        'Television' => 'Television',
        'NewsLetter' => 'Newsletter',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'Weekly',
        'Monthly' => 'Monthly',
        'Quarterly' => 'Quarterly',
        'Annually' => 'Annually',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'January',
        '2' => 'February',
        '3' => 'March',
        '4' => 'April',
        '5' => 'May',
        '6' => 'June',
        '7' => 'July',
        '8' => 'August',
        '9' => 'September',
        '10' => 'October',
        '11' => 'November',
        '12' => 'December',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'Jan',
        '2' => 'Feb',
        '3' => 'Mar',
        '4' => 'Apr',
        '5' => 'May',
        '6' => 'Jun',
        '7' => 'Jul',
        '8' => 'Aug',
        '9' => 'Sep',
        '10' => 'Oct',
        '11' => 'Nov',
        '12' => 'Dec',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'Sunday',
        '2' => 'Monday',
        '3' => 'Tuesday',
        '4' => 'Wednesday',
        '5' => 'Thursday',
        '6' => 'Friday',
        '7' => 'Saturday',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'Sun',
        '2' => 'Mon',
        '3' => 'Tue',
        '4' => 'Wed',
        '5' => 'Thu',
        '6' => 'Fri',
        '7' => 'Sat',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'Su',
        '2' => 'Mo',
        '3' => 'Tu',
        '4' => 'We',
        '5' => 'Th',
        '6' => 'Fr',
        '7' => 'Sa',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'Sun',
        '1' => 'Mon',
        '2' => 'Tue',
        '3' => 'Wed',
        '4' => 'Thu',
        '5' => 'Fri',
        '6' => 'Sat',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'am',
        'pm' => 'pm',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => 'Rows and Columns',
        'summary' => 'Summation',
        'detailed_summary' => 'Summation with details',
        'Matrix' => 'Matrix',
        ],


        'dom_email_types' => [
        'out' => 'Sent',
        'archived' => 'Archived',
        'draft' => 'Draft',
        'inbound' => 'Inbound',
        'campaign' => 'Campaign',
        ],
        'dom_email_status' => [
        'archived' => 'Archived',
        'closed' => 'Closed',
        'draft' => 'In Draft',
        'read' => 'Read',
        'replied' => 'Replied',
        'sent' => 'Sent',
        'send_error' => 'Send Error',
        'unread' => 'Unread',
        ],
        'dom_email_archived_status' => [
        'archived' => 'Archived',
        ],

        'dom_email_server_type' => ['' => '--None--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--None--',
        'createcase' => 'Create Case',
        'bounce' => 'Bounce Handling',
        ],
        'dom_email_distribution' => ['' => '--None--',
        'direct' => 'Direct Assign',
        'roundRobin' => 'Round-Robin',
        'leastBusy' => 'Least-Busy',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'Round-Robin',
        'leastBusy' => 'Least-Busy',
        'none' => 'None',
        ],
        'dom_email_errors' => [1 => 'Only select one user when Direct Assigning items.',
        2 => 'You must assign Only Checked Items when Direct Assigning items.',
        ],
        'dom_email_bool' => ['bool_true' => 'Yes',
        'bool_false' => 'No',
        ],
        'dom_int_bool' => [1 => 'Yes',
        0 => 'No',
        ],
        'dom_switch_bool' => ['on' => 'Yes',
        'off' => 'No',
        '' => 'No',],

        'dom_email_link_type' => ['sugar' => 'Sugar Email Client',
        'mailto' => 'External Email Client'],


        'dom_email_editor_option' => ['' => 'Default Email Format',
        'html' => 'HTML Email',
        'plain' => 'Plain Text Email'],

        'schedulers_times_dom' => ['not run' => 'Past Run Time, Not Executed',
        'ready' => 'Ready',
        'in progress' => 'In Progress',
        'failed' => 'Failed',
        'completed' => 'Completed',
        'no curl' => 'Not Run: No cURL available',
        ],

        'dom_email_states' => [
        'Draft' => 'Draft',
        'Archived' => 'Archived',
        ],

        'dom_email_direction' => [
        'Unknown' => 'Unknown',
        'Outbound' => 'Outbound',
        'Inbound' => 'Inbound',
        'Internal' => 'Internal',
        ],

        'scheduler_status_dom' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive',
        ],

        'scheduler_period_dom' => [
        'min' => 'Minutes',
        'hour' => 'Hours',
        ],
        'forecast_type_dom' => [
        'Direct' => 'Direct',
        'Rollup' => 'Rollup',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'Marketing',
        'Knowledge Base' => 'Knowledge Base',
        'Sales' => 'Sales',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'Marketing Collateral',
        'Product Brochures' => 'Product Brochures',
        'FAQ' => 'FAQ',
        ],

        'document_status_dom' => [
        'Active' => 'Active',
        'Draft' => 'Draft',
        'FAQ' => 'FAQ',
        'Expired' => 'Expired',
        'Under Review' => 'Under Review',
        'Pending' => 'Pending',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'Mail Merge',
        'eula' => 'EULA',
        'nda' => 'NDA',
        'license' => 'License Agreement',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'Accept',
        'decline' => 'Decline',
        'tentative' => 'Tentative',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'Accepted',
        'decline' => 'Declined',
        'tentative' => 'Tentative',
        'none' => 'None',
        ],
        'dataset_output_default_dom' => [
        'table' => 'Table',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'Single Module',
        'Multi Module' => 'Multi Module',
        ],
        'report_align_dom' => [
        'left' => 'Left',
        'center' => 'Center',
        'right' => 'Right',
        ],

        'width_type_dom' => [
        '%' => 'Percent (%)',
        'px' => 'Pixels (px)',
        ],
        'report_color_dom' => [
        '' => 'Default',
        'black' => 'Black',
        'green' => 'Green',
        'blue' => 'Blue',
        'red' => 'Red',
        'white' => 'White',
        'DarkGreen' => 'Dark Green',
        'LightGray' => 'Light Gray',
        'DodgerBlue' => 'Dodger Blue',
        'LightBlue' => 'Light Blue',
        ],
        'font_size_dom' => [
        '-5' => 'Smaller (-5)',
        '-4' => 'Smaller (-4)',
        '-3' => 'Smaller (-3)',
        '-2' => 'Smaller (-2)',
        '-1' => 'Smaller (-1)',
        'Default' => 'Default',
        '1' => 'Larger (+1)',
        '2' => 'Larger (+2)',
        '3' => 'Larger (+3)',
        '4' => 'Larger (+4)',
        '5' => 'Larger (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'Main Query',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'Display',
//  'Group By' => 'Group By',
        'Calculation' => 'Calculation',
        ],
        'query_display_type_dom' => [
        'Default' => 'Default',
        'Custom' => 'Custom',
        'Hidden' => 'Hidden',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'Day',
        'Week' => 'Week',
        'Month' => 'Month',
        'Quarter' => 'Quarter',
        'Year' => 'Year',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'Now',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'SUM',
        'AVG' => 'AVG',
        'COUNT' => 'Count',
        'STDDEV' => 'Standard Deviation',
        'VARIANCE' => 'Variance',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'Standard Field',
        'Time' => 'Time Interval',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'Rows (Y-Axis)',
        'Columns' => 'Columns (X-Axis)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'Sum (Total)',
        'AVG' => 'Average',
        'MAX' => 'Maximum',
        'MIN' => 'Minimum',
        'COUNT' => 'Count',
        'STDDEV' => 'Standard Deviation',
        'VARIANCE' => 'Variance',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'Standard',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'Math Calc',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'Field',
        'Value' => 'Value',
        'Group' => 'Group',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'Column',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'Disabled',
        'Enabled' => 'Enabled',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'Normal',
        'Scalar' => 'Scalar',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'Text',
        'Accounting' => 'Accounting',
        'Date' => 'Date',
        'Datetime' => 'Datetime',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'Year',
        'Quarter' => 'Quarter',
        'Month' => 'Month',
        'Week' => 'Week',
        'Day' => 'Day',
        ],
        'dataset_style_dom' => [
        'normal' => 'Normal',
        'bold' => 'Bold',
        'italic' => 'Italic',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) Plus',
        '-' => '(-) Minus',
        '*' => '(X) Multiplied By',
        '/' => '(/) Divided By',
        ],
        'wflow_type_dom' => [
        'Normal' => 'When record saved',
        'Time' => 'After time elapses',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Is',
        'in' => 'Is One of',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'Is One of',
        'not_in' => 'Is Not One of',
        ],
        'cselect_type_dom' => [
        'Equals' => 'Equals',
        'Does not Equal' => 'Does Not Equal',
        ],
        'dselect_type_dom' => [
        'Equals' => 'Equals',
        'Less Than' => 'Less Than',
        'More Than' => 'More Than',
        'Does not Equal' => 'Does not Equal',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'Yes',
        'bool_false' => 'No',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'Equals',
        ],
        'tselect_type_dom' => [
        '0' => '0 hours',
        '14440' => '4 hours',
        '28800' => '8 hours',
        '43200' => '12 hours',
        '86400' => '1 day',
        '172800' => '2 days',
        '259200' => '3 days',
        '345600' => '4 days',
        '432000' => '5 days',
        '604800' => '1 week',
        '1209600' => '2 weeks',
        '1814400' => '3 weeks',
        '2592000' => '30 days',
        '5184000' => '60 days',
        '7776000' => '90 days',
        '10368000' => '120 days',
        '12960000' => '150 days',
        '15552000' => '180 days',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'was more than',
        'Less Than' => 'is less than',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'Email',
        'Invite' => 'Invite',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'Normal Message',
        'Custom Template' => 'Custom Template',
        'System Default' => 'System Default',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'Current Users',
        'rel_user' => 'Related Users',
        'rel_user_custom' => 'Related Custom User',
        'specific_team' => 'Specific Team',
        'specific_role' => 'Specific Role',
        'specific_user' => 'Specific User',
        ],
        'wflow_array_type_dom' => [
        'future' => 'New Value',
        'past' => 'Old Value',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'User',
        'Manager' => "User's Manager",
        ],
        'wflow_address_type_dom' => [
        'to' => 'To:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'To:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        'invite_only' => '(Invite Only)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'To:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'Update Record',
        'update_rel' => 'Update Related Record',
        'new' => 'New Record',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'Triggered Date',
        'Existing Value' => 'Existing Value',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'Basic Options',
        'Advanced' => 'Advanced Options',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'User assigned to triggered record',
        'modified_user_id' => 'User who last modified triggered record',
        'created_by' => 'User who created triggered record',
        'current_user' => 'Logged-in User',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'Current Team of triggered Record',
        'team_set_id' => 'Current Team Set of triggered Record',
        'current_team' => 'Team of Logged-in User',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'Move dropdown backwards by ',
        'advance' => 'Move dropdown forwards by ',
        ],
        'wflow_record_type_dom' => [
        'All' => 'New and Updated Records',
        'New' => 'New Records Only',
        'Update' => 'Updated Records Only',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'All related',
        //'first' => 'The first related',
        'filter' => 'Filter related',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'all related',
        'any' => 'any related',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'Alerts then Actions',
        'actions_alerts' => 'Actions then Alerts'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'None',
        'Daily' => 'Daily',
        'Weekly' => 'Weekly',
        'Monthly' => 'Monthly',
        'Yearly' => 'Yearly',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'day(s)',
        'Weekly' => 'week(s)',
        'Monthly' => 'month(s)',
        'Yearly' => 'year(s)',
        ],

        'repeat_end_types' => [
        'Until' => 'Until',
        'Occurrences' => 'Occurrences',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'None',
        'Each' => 'Date',
        'On' => 'Day',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'first',
        'second' => 'second',
        'third' => 'third',
        'fourth' => 'fourth',
        'fifth' => 'fifth',
        'last' => 'last',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'Sunday',
        'Mon' => 'Monday',
        'Tue' => 'Tuesday',
        'Wed' => 'Wednesday',
        'Thu' => 'Thursday',
        'Fri' => 'Friday',
        'Sat' => 'Saturday',
        'Day' => 'Day',
        'WD' => 'Weekday',
        'WE' => 'Weekend Day',
        ],

        'duration_dom' => [
        '' => 'None',
        '900' => '15 minutes',
        '1800' => '30 minutes',
        '2700' => '45 minutes',
        '3600' => '1 hour',
        '5400' => '1.5 hours',
        '7200' => '2 hours',
        '10800' => '3 hours',
        '21600' => '6 hours',
        '86400' => '1 day',
        '172800' => '2 days',
        '259200' => '3 days',
        '604800' => '1 week',
        ],
        'repeat_month_dom' => [
        '1' => 'January',
        '2' => 'February',
        '3' => 'March',
        '4' => 'April',
        '5' => 'May',
        '6' => 'June',
        '7' => 'July',
        '8' => 'August',
        '9' => 'September',
        '10' => 'October',
        '11' => 'November',
        '12' => 'December',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'Default',
        'seed' => 'Seed',
        'exempt_domain' => 'Suppression List - By Domain',
        'exempt_address' => 'Suppression List - By Email Address',
        'exempt' => 'Suppression List - By Id',
        'test' => 'Test',
        ],
        'currency_status_dom' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'Active',
        'inactive' => 'Inactive',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'Message Sent/Attempted',
        'send error' => 'Bounced Messages,Other',
        'invalid email' => 'Bounced Messages,Invalid Email',
        'link' => 'Click-thru Link',
        'viewed' => 'Viewed Message',
        'removed' => 'Opted Out',
        'lead' => 'Leads Created',
        'contact' => 'Contacts Created',
        'blocked' => 'Suppressed by address or domain',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'Contacts',
        'Users' => 'Users',
        'Prospects' => 'Targets',
        'Leads' => 'Leads',
        'Accounts' => 'Accounts',
        ],
        'merge_operators_dom' => [
        'like' => 'Contains',
        'exact' => 'Exactly',
        'start' => 'Starts With',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'Yes',
        'false' => 'No',
        'required' => 'Required',
        ],

        'fts_field_config' => [
        '0' => 'Disabled',
        '2' => 'Searchable',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'Disabled',
        1 => 'Enabled',
        2 => 'In Filter',
        3 => 'Default Selected Filter',
        4 => 'Filter Only',
        ],

        'navigation_paradigms' => [
        'm' => 'Modules',
        'gm' => 'Grouped Modules',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'Not Started',
        'inprogress' => 'In Progress',
        'signed' => 'Signed',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'Monthly',
        'quarterly' => 'Quarterly',
        'halfyearly' => 'Half yearly',
        'yearly' => 'Yearly',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 Day',
        '3' => '3 Days',
        '5' => '5 Days',
        '7' => '1 Week',
        '14' => '2 Weeks',
        '21' => '3 Weeks',
        '31' => '1 Month',
        ],
        'projects_priority_options' => [
        'high' => 'High',
        'medium' => 'Medium',
        'low' => 'Low',
        ],

        'projects_status_options' => [
        'notstarted' => 'Not Started',
        'inprogress' => 'In Progress',
        'completed' => 'Completed',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'Expand Legend',
        'collapselegend' => 'Collapse Legend',
        'clickfordrilldown' => 'Click for Drilldown',
        'drilldownoptions' => 'Drill Down Options',
        'detailview' => 'More Details...',
        'piechart' => 'Pie Chart',
        'groupchart' => 'Group Chart',
        'stackedchart' => 'Stacked Chart',
        'barchart' => 'Bar Chart',
        'horizontalbarchart' => 'Horizontal Bar Chart',
        'linechart' => 'Line Chart',
        'noData' => 'Data not available',
        'print' => 'Print',
        'pieWedgeName' => 'sections',
        ],
        'chart_types' => [
        'hBarF' => 'Horizontal Bar (Stacked)',
        'hGBarF' => 'Horizontal Bar (Grouped)',
        'vBarF' => 'Vertical Bar (Stacked)',
        'vGBarF' => 'Vertical Bar (Grouped)',
        'pieF' => 'Pie',
        'funnelF' => 'Funnel',
        'lineF' => 'Line',
        'donutF' => 'Donut',
        'treemapF' => 'Treemap',
        ],
        'd3_value_placement' => [
        '0' => 'None',
        '1' => 'Default',
        'start' => 'Start',
        'middle' => 'Middle',
        'end' => 'End',
        'top' => 'Top',
        'total' => 'Total',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'Funnel',
        'hbar' => 'Horizontal Bar',
        ],
        'release_status_dom' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive',
        ],
        'email_settings_for_ssl' => [
        '0' => 'None',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Google Less Secure Apps',
        'exchange' => 'Exchange',
        'other' => 'Other',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'Other',
        ],
        'import_enclosure_options' => [
        '\'' => 'Single Quote (\')',
        '"' => 'Double Quote (")',
        '' => 'None',
        'other' => 'Other:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'Other:',
        ],
        'link_target_dom' => [
        '_blank' => 'New Window',
        '_self' => 'Same Window',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'Do not auto-refresh',
        '30' => 'Every 30 seconds',
        '60' => 'Every 1 minute',
        '180' => 'Every 3 minutes',
        '300' => 'Every 5 minutes',
        '600' => 'Every 10 minutes',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'None',
        '15' => 'Every 15 Minutes',
        '30' => 'Every 30 Minutes',
        '45' => 'Every 45 Minutes',
        '60' => 'Every Hour',
        '120' => 'Every 2 Hours',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'Never',
        '30' => 'Every 30 seconds',
        '60' => 'Every 1 minute',
        '180' => 'Every 3 minutes',
        '300' => 'Every 5 minutes',
        '600' => 'Every 10 minutes',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'None',
        '1' => 'Every 1 Minutes',
        '5' => 'Every 5 Minutes',
        '10' => 'Every 10 Minutes',
        '15' => 'Every 15 Minutes',
        '30' => 'Every 30 Minutes',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'Equals',
        'not_equal' => 'Not On',
        'greater_than' => 'After',
        'less_than' => 'Before',
        'last_7_days' => 'Last 7 Days',
        'next_7_days' => 'Next 7 Days',
        'last_30_days' => 'Last 30 Days',
        'next_30_days' => 'Next 30 Days',
        'last_month' => 'Last Month',
        'this_month' => 'This Month',
        'next_month' => 'Next Month',
        'last_year' => 'Last Year',
        'this_year' => 'This Year',
        'next_year' => 'Next Year',
        'between' => 'Is Between',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'Last Year',
        'last_month' => 'Last Month',
        'last_30_days' => 'Last 30 Days',
        'last_7_days' => 'Last 7 Days',
        'this_month' => 'This Month',
        'this_year' => 'This Year',
        'next_7_days' => 'Next 7 Days',
        'next_30_days' => 'Next 30 Days',
        'next_month' => 'Next Month',
        'next_year' => 'Next Year',
        ],
        'numeric_range_search_dom' => [
        '=' => 'Equals',
        'not_equal' => 'Does Not Equal',
        'greater_than' => 'Greater Than',
        'greater_than_equals' => 'Greater Than Or Equal To',
        'less_than' => 'Less Than',
        'less_than_equals' => 'Less Than Or Equal To',
        'between' => 'Is Between',
        ],

        'filter_checkbox_dom' => [
        0 => 'False',
        1 => 'True',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'Won',
        'lost' => 'Lost',
        'active' => 'Active',
        ],

        'sweetspot_theme_options' => [
        'default' => 'Default',
        'light' => 'Light',
        'dark' => 'Dark',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'Move',
        'donothing' => 'Do Nothing',
        ],
        'processes_auto_save_interval' => [
        0 => 'Never',
        30000 => 'Every 30 seconds',
        60000 => 'Every 1 minute',
        120000 => 'Every 2 minutes',
        180000 => 'Every 3 minutes',
        240000 => 'Every 4 minutes',
        300000 => 'Every 5 minutes',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'In Forecast',
        'sales_stage' => 'Sales Stage',
        'probability' => 'Probability',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'Likely',
        'best' => 'Best',
        'worst' => 'Worst',
        ],
        'webLogicHookList' => [
        'after_save' => 'After Save',
        'after_delete' => 'After Delete',
        'after_relationship_add' => 'After Relationship Add',
        'after_relationship_delete' => 'After Relationship Delete',
        'after_login' => 'After Login',
        'after_logout' => 'After Logout',
        'after_login_failed' => 'After Login Failed',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'Enabled',
        'INACTIVE' => 'Disabled',
        ],
        'dashboard_view_name_list' => [
        'record' => 'Record',
        'records' => 'List',
        'activities' => 'Activity Stream',
        'multi-line' => 'Multi-line List',
        'omnichannel' => 'Omnichannel',
        'home' => 'Home',
        'focus' => 'Focus Dashboard',
        ],
        'metric_context_list' => [
        'service_console' => 'Service Console',
        'renewals_console' => 'Renewals Console',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'Hourly',
        '21600' => 'Every 6 Hours',
        '43200' => 'Every 12 Hours',
        '86400' => 'Daily',
        '604800' => 'Weekly',
        '1209600' => 'Every 2 Weeks',
        '2419200' => 'Every 4 Weeks',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'Year(s)',
        'month' => 'Month(s)',
        'day' => 'Day(s)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'Time Off',
        'event' => 'Event',
        'other' => 'Other',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'Date (Last {{module}})',
        'start_date:asc' => 'Date (First {{module}})',
        'total_revenue:desc' => 'Price (Highest Total)',
        'total_revenue:asc' => 'Price (Lowest Total)',
        ],
        'calendar_type_list' => [
        'main' => 'Calendar Center',
        ],
        'calendar_views_options' => [
        'day' => 'Day',
        'week' => 'Week',
        'workWeek' => 'Work Week',
        'expandedMonth' => 'Month',
        'agenda' => 'Agenda',
        'timeline' => 'Timeline',
        'monthSchedule' => 'Scheduler',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'Created',
        'completed' => 'Completed',
        'declined' => 'Declined',
        'delivered' => 'Delivered',
        'sent' => 'Sent',
        'signed' => 'Signed',
        'voided' => 'Voided',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'Display list of potential recipients',
        'dont_show' => 'Don\'t show potential recipients',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'Signer',
        'carbon_copy' => 'Viewer (Carbon copy)',
        'certified_delivery' => 'Viewer (Certified Delivery)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'Default',
        'color' => 'Color',
        'image' => 'Image',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'Abbreviation',
        'icon' => 'Icon',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'Arrow Down',
        'sicon-chevron-left' => 'Chevron Left',
        'sicon-check' => 'Check',
        'sicon-clock' => 'Clock',
        'sicon-dashboard-default' => 'Dashboard Default',
        'sicon-dashboard' => 'Dashboard',
        'sicon-edit' => 'Edit',
        'sicon-caret-down' => 'Caret Down',
        'sicon-folder' => 'Folder',
        'sicon-info' => 'Info',
        'sicon-kebab' => 'Kebab',
        'sicon-link' => 'Link',
        'sicon-list' => 'List',
        'sicon-logout' => 'Logout',
        'sicon-minus' => 'Minus',
        'sicon-folder-open' => 'Folder Open',
        'sicon-plus-sm' => 'Plus Sm',
        'sicon-refresh' => 'Refresh',
        'sicon-plus' => 'Plus',
        'sicon-settings' => 'Settings',
        'sicon-arrow-right-double' => 'Arrow Right Double',
        'sicon-reports' => 'Reports',
        'sicon-user' => 'User',
        'sicon-upload' => 'Upload',
        'sicon-user-group' => 'User Group',
        'sicon-arrow-left-double' => 'Arrow Left Double',
        'sicon-chevron-up' => 'Chevron Up',
        'sicon-caret-up' => 'Caret Up',
        'sicon-star-fill' => 'Star Fill',
        'sicon-download' => 'Download',
        'sicon-close' => 'Close',
        'sicon-tile-view' => 'Tile View',
        'sicon-list-view' => 'List View',
        'sicon-thumbs-down' => 'Thumbs Down',
        'sicon-warning-circle' => 'Warning Circle',
        'sicon-phone' => 'Phone',
        'sicon-email' => 'Email',
        'sicon-document' => 'Document',
        'sicon-note' => 'Note',
        'sicon-preview' => 'Preview',
        'sicon-copy' => 'Copy',
        'sicon-launch' => 'Launch',
        'sicon-lock' => 'Lock',
        'sicon-arrow-top-right' => 'Arrow Top Right',
        'sicon-full-screen' => 'Full Screen',
        'sicon-full-screen-exit' => 'Full Screen Exit',
        'sicon-expand-left' => 'Expand Left',
        'sicon-expand-right' => 'Expand Right',
        'sicon-focus-drawer' => 'Focus Drawer',
        'sicon-ban' => 'Ban',
        'sicon-thumbs-up' => 'Thumbs Up',
        'sicon-search' => 'Search',
        'sicon-calendar' => 'Calendar',
        'sicon-calendar-lg' => 'Calendar Lg',
        'sicon-mobile-lg' => 'Mobile Lg',
        'sicon-star-fill-lg' => 'Star Fill Lg',
        'sicon-star-outline-lg' => 'Star Outline Lg',
        'sicon-reset-lg' => 'Reset Lg',
        'sicon-exchange-lg' => 'Exchange Lg',
        'sicon-help-lg' => 'Help Lg',
        'sicon-close-lg' => 'Close Lg',
        'sicon-plus-lg' => 'Plus Lg',
        'sicon-shortcuts-lg' => 'Shortcuts Lg',
        'sicon-search-lg' => 'Search Lg',
        'sicon-email-lg' => 'Email Lg',
        'sicon-note-lg' => 'Note Lg',
        'sicon-document-lg' => 'Document Lg',
        'sicon-add-dashlet-lg' => 'Add Dashlet Lg',
        'sicon-collapse-lg' => 'Collapse Lg',
        'sicon-hamburger-lg' => 'Hamburger Lg',
        'sicon-pin-fill-lg' => 'Pin Fill Lg',
        'sicon-expand-lg' => 'Expand Lg',
        'sicon-copy-lg' => 'Copy Lg',
        'sicon-dashboard-lg' => 'Dashboard Lg',
        'sicon-star-outline' => 'Star Outline',
        'sicon-reset' => 'Reset',
        'sicon-unlink' => 'Unlink',
        'sicon-phone-lg' => 'Phone Lg',
        'sicon-attach' => 'Attach',
        'sicon-case-lg' => 'Case Lg',
        'sicon-arrow-right-lg' => 'Arrow Right Lg',
        'sicon-check-circle-lg' => 'Check Circle Lg',
        'sicon-text-formatting' => 'Text Formatting',
        'sicon-check-circle' => 'Check Circle',
        'sicon-upload-lg' => 'Upload Lg',
        'sicon-flag-lg' => 'Flag Lg',
        'sicon-studio-lg' => 'Studio Lg',
        'sicon-contact-lg' => 'Contact Lg',
        'sicon-edit-lg' => 'Edit Lg',
        'sicon-arrow-left' => 'Arrow Left',
        'sicon-reply-all' => 'Reply All',
        'sicon-message-lg' => 'Message Lg',
        'sicon-info-lg' => 'Info Lg',
        'sicon-error-lg' => 'Error Lg',
        'sicon-check-circle-line-lg' => 'Check Circle Line Lg',
        'sicon-warning-line-lg' => 'Warning Line Lg',
        'sicon-arrow-up' => 'Arrow Up',
        'sicon-arrow-right' => 'Arrow Right',
        'sicon-nodes' => 'Nodes',
        'sicon-hide' => 'Hide',
        'sicon-help' => 'Help',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'Message',
        'sicon-sugar-predict-lg' => 'Sugar Predict Lg',
        'sicon-sugar-predict' => 'Sugar Predict',
        'sicon-opportunity-lg' => 'Opportunity Lg',
        'sicon-lead-lg' => 'Lead Lg',
        'sicon-account-lg' => 'Account Lg',
        'sicon-user-sm' => 'User Sm',
        'sicon-quote-lg' => 'Quote Lg',
        'sicon-equal' => 'Equal',
        'sicon-slicers-xl' => 'Slicers Xl',
        'sicon-escalation-lg' => 'Escalation Lg',
        'sicon-add-circle-lg' => 'Add Circle Lg',
        'sicon-add-line-lg' => 'Add Line Lg',
        'sicon-add-target-lg' => 'Add Target Lg',
        'sicon-help-circle-lg' => 'Help Circle Lg',
        'sicon-divide-line-lg' => 'Divide Line Lg',
        'sicon-string' => 'String',
        'sicon-filter' => 'Filter',
        'sicon-number' => 'Number',
        'sicon-format-lg' => 'Format Lg',
        'sicon-insights-lg' => 'Insights Lg',
        'sicon-invalid-circle-lg' => 'Invalid Circle Lg',
        'sicon-layout-xl' => 'Layout Xl',
        'sicon-layout-lg' => 'Layout Lg',
        'sicon-multiply-line-lg' => 'Multiply Line Lg',
        'sicon-redo-lg' => 'Redo Lg',
        'sicon-refresh-lg' => 'Refresh Lg',
        'sicon-undo-lg' => 'Undo Lg',
        'sicon-activity-feed-xl' => 'Activity Feed Xl',
        'sicon-chevron-left-xl' => 'Chevron Left Xl',
        'sicon-close-xl' => 'Close Xl',
        'sicon-kebab-lg' => 'Kebab Lg',
        'sicon-insights-xl' => 'Insights Xl',
        'sicon-hide-lg' => 'Hide Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => 'Comment Xl',
        'sicon-share-lg' => 'Share Lg',
        'sicon-trash' => 'Trash',
        'sicon-launch-lg' => 'Launch Lg',
        'sicon-thumbs-up-lg' => 'Thumbs Up Lg',
        'sicon-thumbs-down-lg' => 'Thumbs Down Lg',
        'sicon-warning-lg' => 'Warning Lg',
        'sicon-wizard-circle-xl' => 'Wizard Circle Xl',
        'sicon-bell-cross-lg' => 'Bell Cross Lg',
        'sicon-bell-lg' => 'Bell Lg',
        'sicon-daily-lg' => 'Daily Lg',
        'sicon-cloud-download-lg' => 'Cloud Download Lg',
        'sicon-unlock' => 'Unlock',
        'sicon-news-lg' => 'News Lg',
        'sicon-weekly-lg' => 'Weekly Lg',
        'sicon-knowledgebase-xl' => 'Knowledgebase Xl',
        'sicon-remove' => 'Remove',
        'sicon-chevron-down' => 'Chevron Down',
        'sicon-slicers-lg' => 'Slicers Lg',
        'sicon-save-lg' => 'Save Lg',
        'sicon-info-circle-lg' => 'Info Circle Lg',
        'sicon-chevron-right' => 'Chevron Right',
        'sicon-warning-circle-lg' => 'Warning Circle Lg',
        'sicon-right-paren-line-lg' => 'Right Paren Line Lg',
        'sicon-comment-lg' => 'Comment Lg',
        'sicon-target-lg' => 'Target Lg',
        'sicon-subtract-line-lg' => 'Subtract Line Lg',
        'sicon-settings-lg' => 'Settings Lg',
        'sicon-left-paren-line-lg' => 'Left Paren Line Lg',
        'sicon-preview-lg' => 'Preview Lg',
        'sicon-thumbs-down-line-lg' => 'Thumbs Down Line Lg',
        'sicon-thumbs-up-line-lg' => 'Thumbs Up Line Lg',
        'sicon-send-lg' => 'Send Lg',
        'sicon-contact-xl' => 'Contact Xl',
        'sicon-wizard-circle-line-xl' => 'Wizard Circle Line Xl',
        'sicon-trash-lg' => 'Trash Lg',
        'sicon-pin-lg' => 'Pin Lg',
        'sicon-clock-lg' => 'Clock Lg',
        'sicon-comment-line-xl' => 'Comment Line Xl',
        'sicon-dropdown-editor' => 'Dropdown Editor',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'Bug',
        'sicon-catalog' => 'Catalog',
        'sicon-cloud' => 'Cloud',
        'sicon-config-api' => 'Config Api',
        'sicon-config-nav' => 'Config Nav',
        'sicon-connectors' => 'Connectors',
        'sicon-contracts' => 'Contracts',
        'sicon-currencies' => 'Currencies',
        'sicon-diagnostics' => 'Diagnostics',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'Email Campaign',
        'sicon-email-inbound' => 'Email Inbound',
        'sicon-email-queue' => 'Email Queue',
        'sicon-forecasts' => 'Forecasts',
        'sicon-display-modules' => 'Display Modules',
        'sicon-email-contacts' => 'Email Contacts',
        'sicon-import' => 'Import',
        'sicon-log-viewer' => 'Log Viewer',
        'sicon-lab' => 'Lab',
        'sicon-map-pin' => 'Map Pin',
        'sicon-manufacturers' => 'Manufacturers',
        'sicon-update' => 'Update',
        'sicon-content-security' => 'Content Security',
        'sicon-module-builder' => 'Module Builder',
        'sicon-languages' => 'Languages',
        'sicon-module-loader' => 'Module Loader',
        'sicon-oauth-key' => 'Oauth Key',
        'sicon-password-mgmt' => 'Password Mgmt',
        'sicon-opportunities' => 'Opportunities',
        'sicon-upgrade' => 'Upgrade',
        'sicon-portal' => 'Portal',
        'sicon-product-types' => 'Product Types',
        'sicon-quotes' => 'Quotes',
        'sicon-relate-fields' => 'Relate Fields',
        'sicon-repair' => 'Repair',
        'sicon-role-mgmt' => 'Role Mgmt',
        'sicon-scheduler' => 'Scheduler',
        'sicon-shippers' => 'Shippers',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'Web Logic',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'Tax Rates',
        'sicon-team-mgmt' => 'Team Mgmt',
        'sicon-team-perm' => 'Team Perm',
        'sicon-tracker' => 'Tracker',
        'sicon-workflow' => 'Workflow',
        'sicon-mask' => 'Mask',
        'sicon-mask-disabled' => 'Mask Disabled',
        'sicon-email-archive' => 'Email Archive',
        'sicon-mobile' => 'Mobile',
        'sicon-archive' => 'Archive',
        'sicon-automate-scroll' => 'Vertical Scroll View',
        'sicon-automate-stacked' => 'Horizontal Scroll View',
        'sicon-pdf-manager' => 'Pdf Manager',
        'sicon-my-sites' => 'My Sites',
        'sicon-cloud-insights' => 'Cloud Insights',
        'sicon-sugar-logo-24' => 'Sugar Logo 24',
        'sicon-sugar-logo-16' => 'Sugar Logo 16',
        'sicon-task-lg' => 'Task Lg',
        'sicon-web-lg' => 'Web Lg',
        'sicon-events-lg' => 'Events Lg',
        'sicon-sugar-logo-12' => 'Sugar Logo 12',
        'sicon-tag' => 'Tag',
        'sicon-tag-lg' => 'Tag Lg',
        'sicon-bell-lg-line' => 'Bell Lg Line',
        'sicon-matrix-xxl' => 'Matrix Xxl',
        'sicon-advanced-filter' => 'Advanced Filter',
        'sicon-rows-and-columns-xxl' => 'Rows And Columns Xxl',
        'sicon-summation-details-xxl' => 'Summation Details Xxl',
        'sicon-summation-xxl' => 'Summation Xxl',
        'sicon-lock-lg' => 'Lock Lg',
        'sicon-csv-file-xxl' => 'Csv File Xxl',
        'sicon-logo-linkedin' => 'Logo Linkedin',
        'sicon-briefcase' => 'Briefcase',
        'sicon-car-front' => 'Car Front',
        'sicon-airplane' => 'Airplane',
        'sicon-laptop' => 'Laptop',
        'sicon-logo-instagram' => 'Logo Instagram',
        'sicon-single-bed' => 'Single Bed',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'Logo Snapchat',
        'sicon-video-lg' => 'Video Lg',
        'sicon-reply' => 'Reply',
        'sicon-subtract' => 'Subtract',
        'sicon-arrow-up-circle-line' => 'Arrow Up Circle Line',
        'sicon-asterisk' => 'Asterisk',
        'sicon-dot-circle-o-lg' => 'Dot Circle O Lg',
        'sicon-forward' => 'Forward',
        'sicon-video' => 'Video',
        'sicon-gavel' => 'Gavel',
        'sicon-login' => 'Login',
        'sicon-pdf-file-xxl' => 'Pdf File Xxl',
        'sicon-login-lg' => 'Login Lg',
        'sicon-cloud-download-xl' => 'Cloud Download Xl',
        'sicon-campaigns-lg' => 'Campaigns Lg',
        'sicon-customer-journey-stages-lg' => 'Customer Journey Stages Lg',
        'sicon-role-mgmt-lg' => 'Role Mgmt Lg',
        'sicon-default-module-lg' => 'Default Module Lg',
        'sicon-quoted-line-items-lg' => 'Quoted Line Items Lg',
        'sicon-projects-lg' => 'Projects Lg',
        'sicon-process-business-rules-lg' => 'Process Business Rules Lg',
        'sicon-process-email-templates-lg' => 'Process Email Templates Lg',
        'sicon-processes-lg' => 'Processes Lg',
        'sicon-process-definitions-lg' => 'Process Definitions Lg',
        'sicon-target-lists-lg' => 'Target Lists Lg',
        'sicon-purchased-line-items-lg' => 'Purchased Line Items Lg',
        'sicon-user-group-lg' => 'User Group Lg',
        'sicon-revenue-line-items-lg' => 'Revenue Line Items Lg',
        'sicon-business-centers-lg' => 'Business Centers Lg',
        'sicon-logo-fb-simple' => 'Logo Fb Simple',
        'sicon-forecasts-lg' => 'Forecasts Lg',
        'sicon-contracts-lg' => 'Contracts Lg',
        'sicon-purchase-lg' => 'Purchase Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'Customer Journey Lg',
        'sicon-data-privacy-lg' => 'Data Privacy Lg',
        'sicon-home-lg' => 'Home Lg',
        'sicon-data-table' => 'Data Table',
        'sicon-medical-clipboard-lg' => 'Medical Clipboard Lg',
        'sicon-privacy-lg' => 'Privacy Lg',
        'sicon-marketplace' => 'Marketplace',
        'sicon-marketplace-lg' => 'Marketplace Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => 'Casino Lg',
        'sicon-jacuzzi-lg' => 'Jacuzzi Lg',
        'sicon-scissors-lg' => 'Scissors Lg',
        'sicon-storage-lg' => 'Storage Lg',
        'sicon-fan-lg' => 'Fan Lg',
        'sicon-medicine-lg' => 'Medicine Lg',
        'sicon-plant-lg' => 'Plant Lg',
        'sicon-telescope-lg' => 'Telescope Lg',
        'sicon-smart-phone-lg' => 'Smart Phone Lg',
        'sicon-coffee-lg' => 'Coffee Lg',
        'sicon-martini-lg' => 'Martini Lg',
        'sicon-cocktail-lg' => 'Cocktail Lg',
        'sicon-stadium-lg' => 'Stadium Lg',
        'sicon-fire-lg' => 'Fire Lg',
        'sicon-window-lg' => 'Window Lg',
        'sicon-lotus-lg' => 'Lotus Lg',
        'sicon-windmill-lg' => 'Windmill Lg',
        'sicon-spades-lg' => 'Spades Lg',
        'sicon-hearts-lg' => 'Hearts Lg',
        'sicon-diamonds-lg' => 'Diamonds Lg',
        'sicon-clubs-lg' => 'Clubs Lg',
        'sicon-skull-lg' => 'Skull Lg',
        'sicon-send' => 'Send',
        'sicon-world-lg' => 'World Lg',
        'sicon-airplane-lg' => 'Airplane Lg',
        'sicon-planet-lg' => 'Planet Lg',
        'sicon-trainer-lg' => 'Trainer Lg',
        'sicon-calculator-lg' => 'Calculator Lg',
        'sicon-tv-lg' => 'TV Lg',
        'sicon-video-player-lg' => 'Video Player Lg',
        'sicon-media-player-lg' => 'Media Player Lg',
        'sicon-decentralize-lg' => 'Decentralize Lg',
        'sicon-statistics-lg' => 'Statistics Lg',
        'sicon-virus-lg' => 'Virus Lg',
        'sicon-shield-lg' => 'Shield Lg',
        'sicon-plug-lg' => 'Plug Lg',
        'sicon-shuttle-lg' => 'Shuttle Lg',
        'sicon-soundwave-lg' => 'Soundwave Lg',
        'sicon-graph-lg' => 'Graph Lg',
        'sicon-playlist-lg' => 'Playlist Lg',
        'sicon-voice-recognition-lg' => 'Voice Recognition Lg',
        'sicon-machine-learning-lg' => 'Machine Learning Lg',
        'sicon-bed-lg' => 'Bed Lg',
        'sicon-blueprint-lg' => 'Blueprint Lg',
        'sicon-content-delivery-lg' => 'Content Delivery Lg',
        'sicon-questionnaire-lg' => 'Questionnaire Lg',
        'sicon-presentation-lg' => 'Presentation Lg',
        'sicon-organic-lg' => 'Organic Lg',
        'sicon-transactions-lg' => 'Transactions Lg',
        'sicon-wand-lg' => 'Wand Lg',
        'sicon-bin-lg' => 'Bin Lg',
        'sicon-sync-lg' => 'Sync Lg',
        'sicon-external-authentication-lg' => 'External Authentication Lg',
        'sicon-tracking-activity-lg' => 'Tracking Activity Lg',
        'sicon-account' => 'Account',
        'sicon-meetings-lg' => 'Meetings Lg',
        'sicon-stacked' => 'Horizontal Split View',
        'sicon-sidebyside' => 'Vertical Split View',
        ],

        'module_colors_dom' => [
        'army' => 'Army',
        'coral' => 'Coral',
        'green' => 'Green',
        'orange' => 'Orange',
        'ocean' => 'Ocean',
        'pacific' => 'Pacific',
        'pink' => 'Pink',
        'purple' => 'Purple',
        'red' => 'Red',
        'teal' => 'Teal',
        'yellow' => 'Yellow',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'New',
        'In Progress' => 'In Progress',
        'Closed' => 'Closed',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'Inactivity',
        'Lack of Progress' => 'Lack of Progress',
        'Customer-Imposed Deadline' => 'Customer-Imposed Deadline',
        'Account at Risk' => 'Account at Risk',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'Customer Requested',
        'Internally Requested' => 'Internally Requested',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'Case',
        'Bugs' => 'Bug',
        'Accounts' => 'Account',
        'Opportunities' => 'Opportunity',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'Positive',
        'Negative' => 'Negative',
        'Neutral' => 'Neutral',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'Not Likely',
        '02_less_likely' => 'Less Likely',
        '03_neutral' => 'Neutral',
        '04_more_likely' => 'More Likely',
        '05_very_likely' => 'Very Likely',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'Does Not Match Customers',
        '02_no_match' => '',
        '01_matches_customers' => 'Matches Customers',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'Lead',
        'Accounts' => 'Account',
        'Contacts' => 'Contact',
        'Cases' => 'Case',
        'Opportunities' => 'Opportunity',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'Not Started',
        'in_progress' => 'In Progress',
        'completed' => 'Completed',
        'cancelled' => 'Cancelled',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'None',
        'create' => 'On Create',
        'stage_start' => 'On Stage Start',
        'previous_activity_completed' => 'Previous Activity Completed',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'Current User',
        'parent_assignee' => 'Parent Assignee',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'Days From Created',
        'days_from_stage_started' => 'Days From Stage Started',
        'days_from_previous_activity_completed' => 'Days From Previous Activity Completed',
        'days_from_parent_date_field' => 'Days From Parent Date Field',
        'days_from_specific_activity_completed' => 'Days From Specific Activity Completed',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'When Created',
        'stage_started' => 'When Stage Started',
        'previous_activity_completed' => 'When Previous Activity Completed',
        'parent_date_field' => 'On Parent Date Field',
        'specific_activity_completed' => 'Specific Activity Completed',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'Absolute',
        'Percentage' => 'Percentage',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'Customer Task',
        'milestone' => 'Milestone',
        'internal_task' => 'Internal Task',
        'agency_task' => 'Agency Task',
        'automatic_task' => 'Automatic Task',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'Task',
        'Calls' => 'Call',
        'Meetings' => 'Meeting',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'None',
        'create' => 'On Create',
        'stage_start' => 'On Stage Start',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'Inherit',
        'current_user' => 'Current User',
        'parent_assignee' => 'Parent Assignee',
        'user' => 'User',
        'team' => 'Team',
        'user_team' => 'User & Team',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'Inherit',
        'none' => 'None',
        'create' => 'On Create',
        'stage_start' => 'On Stage Start',
        'previous_activity_completed' => 'Previous Activity Completed',
        'specific_activity_completed' => 'Specific Activity Completed',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'Not Started',
        'in_progress' => 'In Progress',
        'not_completed' => 'Not Completed',
        'completed' => 'Completed',
        'cancelled' => 'Cancelled',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'Edit Stage',
        'stage_add_task_button' => 'Create Task',
        'stage_add_meeting_button' => 'Schedule Meeting',
        'stage_add_call_button' => 'Schedule Call',
        'stage_delete_button' => 'Delete Stage',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'Add Task',
        'activity_add_sub_meeting_button' => 'Schedule Meeting',
        'activity_add_sub_call_button' => 'Schedule Call',
        'activity_not_applicable_button' => 'Not Applicable',
        'activity_delete_button' => 'Delete',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'Set Not Applicable',
        'remove_open_activities' => 'Remove Open Activities',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'Default',
        'custom' => 'Custom',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'GET',
        'POST' => 'POST',
        'PUT' => 'PUT',
        'PATCH' => 'PATCH',
        'DELETE' => 'DELETE',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'Skip Request',
        'json' => 'JSON',
        'http_query' => 'HTTP Query',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'No Response',
        'json' => 'JSON',
        'http_query' => 'HTTP Query',
        'text' => 'Plain Text',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'Before Create',
        'after_create' => 'After Create',
        'before_in_progress' => 'Before In Progress',
        'after_in_progress' => 'After In Progress',
        'before_completed' => 'Before Completed',
        'after_completed' => 'After Completed',
        'before_not_applicable' => 'Before Not Applicable',
        'after_not_applicable' => 'After Not Applicable',
        'before_delete' => 'Before Delete',
        'after_delete' => 'After Delete',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Send Smart Guide Information',
        'custom_body' => 'Send Custom Post Body',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'In Progress',
        'completed' => 'Completed',
        'not_applicable' => 'Not Applicable',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'View Record',
        'create_record' => 'Create Record',
        'update_record' => 'Update Record',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'Automatically Create Record',
        'manual_create' => 'Manually Create Record',
        'automatic_update' => 'Automatically Update Record',
        'manual_update' => 'Manually Update Record',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Smart Guide Template',
        'DRI_SubWorkflow_Templates' => 'Stage Template',
        'DRI_Workflow_Task_Templates' => 'Activity Template',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'Yes',
        'no' => 'No',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'Held',
        'Not Held' => 'Not Held',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'Held',
        'Not Held' => 'Not Held',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'Completed',
        'Not Applicable' => 'Not Applicable',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Smart Guide Template',
        'DRI_SubWorkflow_Templates' => 'Stage Template',
        'DRI_Workflow_Task_Templates' => 'Activity Template',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'Task',
        'Meetings' => 'Meeting',
        'Calls' => 'Call',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'Current Task',
        'Calls' => 'Current Call',
        'Meetings' => 'Current Meeting',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'Specific Users',
        'specific_contacts' => 'Specific Contacts',
        'related_parent_users' => 'Related Parent Users',
        'related_parent_contacts' => 'Related Parent Contacts',
        'add_all_contacts_from_parent' => 'Add All Contacts From Parent',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'Users',
        'specific_contacts' => 'Contacts',
        'related_parent_users' => 'Users',
        'related_parent_contacts' => 'Contacts',
        'add_all_contacts_from_parent' => 'Contacts',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'Minute(s)',
        'hours' => 'Hour(s)',
        'days' => 'Day(s)',
        'months' => 'Month(s)',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'Day(s)',
        'months' => 'Month(s)',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'Fixed Date',
        'relative' => 'Relative Date',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'Users',
        'teams' => 'Teams',
        'roles' => 'Roles',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide to Sugar Action',
        'sugar_action_to_smart_guide' => 'Sugar Action to Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide Stage',
        'Smart Guide Activities' => 'Smart Guide Activities',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'Completed',
        'cancelled' => 'Cancelled',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'In Progress',
        'completed' => 'Completed',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'In Progress',
        'completed' => 'Completed',
        'not_applicable' => 'Not Applicable',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'Mark all activities as Completed',
        'mark_all_not_applicable' => 'Mark all Incomplete activities as Not Applicable',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'United States (Oregon) [us-west-2]',
        'ca-central-1' => 'Canada (Central) [ca-central-1]',
        'ap-southeast-1' => 'Asia Pacific (Singapore) [ap-southeast-1]',
        'ap-southeast-2' => 'Asia Pacific (Sydney) [ap-southeast-2]',
        'eu-central-1' => 'Europe (Frankfurt) [eu-central-1]',
        'eu-west-2' => 'Europe (London) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'Record Header', // Studio editing of record views
    'LBL_RECORD_BODY' => 'Business Card', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'Show More', // Studio editing of record views
    'LBL_FAVORITE' => 'Favorite', // Record view header panel element
    'LBL_FOLLOW' => 'Follow', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'Follow Link',
    'LBL_TOGGLE_VISIBILITY' => 'Toggle Visibility', // Record view header panel element
    'LBL_ACTIVITIES' => 'Activity Stream',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar, the Sugar stack logo, and the 3-D Cube are registered trademarks of SugarCRM Inc. ' .
        'All other company and product names used or appearing in this product may be trademarks of the ' .
        'respective companies with which they are associated.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ and Sugar™ are trademarks of SugarCRM Inc.',
    'LBL_SEND_INVITE' => 'Send invite',
    'LBL_INVITEES' => 'Guests',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'Guest will not receive your invite',
    'LBL_SELECT_ACTION_LABEL' => 'Select Action',
    'LBL_TOGGLE_DRAWER' => 'Toggle Drawer',
    'LBL_TOUR_NEXT' => 'Next',
    'LBL_TOUR_SKIP' => 'Skip',
    'LBL_TOUR_BACK' => 'Back',
    'LBL_TOUR_CLOSE' => 'Close',
    'LBL_TOUR_BTN_DONE' => 'Done',
    'LBL_TOUR_TAKE_TOUR' => 'Take the tour',
    'LBL_TOUR_FULL_TOUR' => 'Full Tour',
    'LBL_TOUR_MODULE' => 'Tour this Page',
    'LBL_TOUR_END_TOUR' => 'End Tour',
    'LBL_TOUR_OVERVIEW' => 'Page Overview',
    'LBL_TOUR_REVISIT' => 'Click here to show the tour at any time.',
    'LBL_MY_AREA_LINKS' => 'My area links: ' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Getting Air' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'Welcome' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'Advanced Search' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'More Detail' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'Edit Inline' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'View' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Search' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'Search...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'Remove' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'Add' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'Column' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 Columns' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 Columns' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Advanced Search' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'Add' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'Hide/Show' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'Delete' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'Add' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'Clear' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'Unlink' /*for 508 compliance fix*/,
    'LBL_ADD' => 'Add' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'Company logo' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'Calendar' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'An edit you made to this record has changed this view.' .
        '<br/><a id="cancel_button">Cancel</a>',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'Open',
    'LBL_SIDEBAR_NAV_CLOSE' => 'Close',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} menu',
    'LBL_GOTO_SUGARCRM_COM' => 'Go to SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'main module navigation',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => '{{module}} toggle subpanel',

    'LBL_ADVANCED' => 'Advanced',
    'LBL_BASIC' => 'Basic',
    'LBL_MODULE_FILTER' => 'Filter by...',
    'LBL_CONNECTORS_POPUPS' => 'Connectors Popups',
    'LBL_CLOSEINLINE' => 'Close',
    'LBL_EDITINLINE' => 'Edit',
    'LBL_VIEWINLINE' => 'View',
    'LBL_INFOINLINE' => 'Info',
    'LBL_POWERED_BY_SUGARCRM' => 'Powered by SugarCRM',
    'LBL_PRINT' => 'Print',
    'LBL_HELP' => 'Help',
    'LBL_TOUR' => 'Tour',
    'LBL_TOUR_LINK' => 'Tour This Page',
    'LBL_MOBILE' => 'Mobile',
    'LBL_ID_FF_SELECT' => 'Select',
    'DEFAULT' => 'Basic',
    'LBL_SORT' => 'Sort',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Add Server...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'Enable SMTP over SSL or TLS?',
    'LBL_NO_ACTION' => 'There is no action by that name.',
    'LBL_NO_DATA' => 'No data',
    'LBL_NOT_APPLICABLE' => 'Not Applicable',
    'LBL_ROUTING_ADD_RULE' => 'Add Rule',
    'LBL_ROUTING_ALL' => 'At Least',
    'LBL_ROUTING_ANY' => 'Any',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'Cancel',
    'LBL_ROUTING_BUTTON_SAVE' => 'Save Rule',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'Copy Mail',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Delete Sugar Object',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Delete File',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'Delete Email',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'Forward Email',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'Flag Email',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'Mark Read',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Mark Unread',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'Move Email',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'Perform the following actions',
    'LBL_ROUTING_ACTIONS_REPLY' => 'Reply to Email',

    'LBL_ROUTING_CHECK_RULE' => "An error was detected:\n",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'Please verify all fields that are marked.',
    'LBL_ROUTING_CONFIRM_DELETE' => "Are you sure you want to delete this rule?\nThis cannot be undone.",

    'LBL_ROUTING_FLAGGED' => 'flag set',
    'LBL_ROUTING_FORM_DESC' => 'Saved Rules are immediately active.',
    'LBL_ROUTING_FW' => 'FW: ',
    'LBL_ROUTING_LIST_TITLE' => 'Rules',
    'LBL_ROUTING_MATCH' => 'If',
    'LBL_ROUTING_MATCH_2' => 'of the following conditions are met:',
    'LBL_NOTIFICATIONS' => 'Notifications',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'CC',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'Body Content',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'From',
    'LBL_ROUTING_MATCH_NAME' => 'Subject',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'High Priority',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Normal Priority',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Low Priority',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'To',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'Contains',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'Does not contain',

    'LBL_ROUTING_NAME' => 'Rule Name',
    'LBL_ROUTING_NEW_NAME' => 'New Rule',
    'LBL_ROUTING_ONE_MOMENT' => 'One moment please...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Original message follows.',
    'LBL_ROUTING_RE' => 'RE: ',
    'LBL_ROUTING_SAVING_RULE' => 'Saving Rule',
    'LBL_ROUTING_SUB_DESC' => 'Checked rules are active. Click name to edit.',
    'LBL_ROUTING_TO' => 'to',
    'LBL_ROUTING_TO_ADDRESS' => 'to address',
    'LBL_ROUTING_WITH_TEMPLATE' => 'with template',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'This record currently contains values in the Office Phone and Address fields. To overwrite these values with the following Office Phone and Address of the Account that you selected, click "OK". To keep the current values, click "Cancel".',
    'LBL_DROP_HERE' => '[Drop Here]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'Edit',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Prefill Gmail&#153; Defaults',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'Name',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Outgoing Mail Server Properties',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'Mail transfer agent',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'Use SMTP Authentication?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP Password',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP Port',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP Server',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'Use SSL when connecting',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP Username',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Default',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Warning: Missing username and password for outgoing mail account.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP Username is required',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP Password is required',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'Mail Account Management',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'Mail Server Protocol of type POP3 will not be supported in the next release. Only IMAP will be supported.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'Set up Mail Accounts to view incoming Emails from your Email accounts.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Provide SMTP mail server information to use for outgoing Email in Mail Accounts.',
    'LBL_EMAIL_ADD' => 'Add email',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Done',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Clear',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'To:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Cc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Bcc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'To/Cc/Bcc',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'New List',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'Email Address',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Only Contact editing is supported at this time.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filter',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'First Name/Account Name',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Last Name',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'My Contacts',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'My Mailing Lists',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'Name',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'No Addresses Found',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Save & Add to Address Book',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Search',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Select Email Recipients',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Address Book',
    'LBL_EMAIL_REPORTS_TITLE' => 'Reports',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'Warning! The outbound Account you are trying to delete is associated to an existing inbound Account.  Are you sure you want to continue?',
    'LBL_EMAIL_ADDRESSES' => 'Email',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'Email Address',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'Email Addresses',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Import to Sugar',
    'LBL_EMAIL_ASSIGNMENT' => 'Assignment',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Attach',
    'LBL_EMAIL_ATTACHMENT' => 'Attach',
    'LBL_EMAIL_ATTACHMENTS' => 'From Local System',
    'LBL_EMAIL_ATTACHMENTS2' => 'From Sugar Documents',
    'LBL_EMAIL_ATTACHMENTS3' => 'Template Attachments',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'File',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Document',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Embeded',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'Attachment failed to upload',
    'LBL_REMOVING_ATTACHMENT' => 'Removing attachment...',
    'LBL_EMAIL_BCC' => 'BCC',
    'LBL_EMAIL_CANCEL' => 'Cancel',
    'LBL_EMAIL_CC' => 'CC',
    'LBL_EMAIL_CHARSET' => 'Character Set',
    'LBL_EMAIL_CHECK' => 'Check Mail',
    'LBL_EMAIL_CHECKING_NEW' => 'Checking for New Email',
    'LBL_EMAIL_CHECKING_DESC' => 'One moment please... <br><br>If this is the first check for the mail account, it may take some time.',
    'LBL_EMAIL_CLOSE' => 'Close',
    'LBL_EMAIL_COFFEE_BREAK' => 'Checking for New Email. <br><br>Large mail accounts may take a considerable amount of time.',
    'LBL_EMAIL_COMMON' => 'Common',

    'LBL_EMAIL_COMPOSE' => 'Email',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Please enter recipient(s) for this email.',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'Associate with',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'The body of this email is empty.  Send anyway?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'This email has no subject.  Send anyway?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(no subject)',
    'LBL_EMAIL_COMPOSE_READ' => 'Read & Compose Email',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Send From Mail Account',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'Options',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Please enter valid email address for To, CC and BCC fields',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'Discard this email?',
    'LBL_EMAIL_CONFIRM_DELETE' => 'Remove these entries from your Address Book?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'Are you sure you want to delete this signature?',

    'LBL_EMAIL_CREATE_NEW' => '--Create On Save--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Multiple',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Empty',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Date Sent by Sender',
    'LBL_EMAIL_DATE_RECEIVED' => 'Date Received',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'Assigned to User',
    'LBL_EMAIL_DATE_TODAY' => 'Today',
    'LBL_EMAIL_DATE_YESTERDAY' => 'Yesterday',
    'LBL_EMAIL_DD_TEXT' => 'email(s) selected.',
    'LBL_EMAIL_DEFAULTS' => 'Defaults',
    'LBL_EMAIL_DELETE' => 'Delete',
    'LBL_EMAIL_DELETE_CONFIRM' => 'Delete selected messages?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'Email deleted successfully.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'Deleting Message',
    'LBL_EMAIL_DETAILS' => 'Details',
    'LBL_EMAIL_DISPLAY_MSG' => 'Displaying email(s) {0} - {1} of {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'Displaying email address(es) {0} - {1} of {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'Edit Contact',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Only the Primary address will be used when working with Contacts.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'Edit Mailing List',

    'LBL_EMAIL_EMPTYING_TRASH' => 'Emptying Trash',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'Deleteting outbound server',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'CLearing cache files',
    'LBL_EMAIL_EMPTY_MSG' => 'No emails to display.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'No email addresses to display.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'Folder name be unique and not empty. Please try again.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'Cannot delete a folder. Either the folder or its children has emails or a mail box associated to it.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'Cannot determine the intended folder from context.  Try again.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Please check your settings.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Please make sure you enter a last name.',
    'LBL_EMAIL_ERROR_DESC' => 'Errors were detected: ',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'You do not have access to this area. Contact your site administrator to obtain access.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugar Folder names must be unique.',
    'LBL_EMAIL_ERROR_EMPTY' => 'Please enter some search criteria.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'An error has occurred',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'An email list with that name already exists',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Message Removed from Server',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'Either message Removed from Server or moved to a different folder',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'Connection to the mail server failed. Please contact your Administrator',
    'LBL_EMAIL_ERROR_MOVE' => 'Moving Email between servers and/or mail accounts is not supported at this time.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'Move Error',
    'LBL_EMAIL_ERROR_NAME' => 'A name is required.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'From Address is required.  Please enter a valid email address.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'Please provide a file.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'IMAP folder renaming is not supported at this time.',
    'LBL_EMAIL_ERROR_SERVER' => 'A mail server address is required.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'The mail account may not have been saved.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'An error has occurred while communicating with the mail server.',
    'LBL_EMAIL_ERROR_USER' => 'A login name is required.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'A password is required.',
    'LBL_EMAIL_ERROR_PORT' => 'A mail server port is required.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'A server protocol is required.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'Monitored Folder is required.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'Trash Folder is required.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'This information is not available',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'No outgoing mail server specified.',
    'LBL_EMAIL_FOLDERS' => 'Folders',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'Move To',
    'LBL_EMAIL_FOLDERS_ADD' => 'Add',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Add New Folder',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Rename Folder',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Save',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Add this folder to',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'This folder cannot be changed',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'Are you sure you would like to delete this folder? This process cannot be reversed. Folder deletions will cascade to all contained folders.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'New Folder Name',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Please select a folder before performing this action.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'Folder Management',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Using Group',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'Assign to Team',
    'LBL_EMAIL_FORWARD' => 'Forward',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => 'Downloaded [[count]] of [[total]] Emails',
    'LBL_EMAIL_FOUND' => 'Found',
    'LBL_EMAIL_FROM' => 'From',
    'LBL_EMAIL_GROUP' => 'group',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'Group',
    'LBL_EMAIL_HOME_FOLDER' => 'Home',
    'LBL_EMAIL_HTML_RTF' => 'Send HTML',
    'LBL_EMAIL_IE_DELETE' => 'Deleting Mail Account',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'Deleting signature',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'Are you sure you would like to delete this mail account?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Deletion successful.',
    'LBL_EMAIL_IE_SAVE' => 'Saving Mail Account Information',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'Importing Email',
    'LBL_EMAIL_IMPORT_EMAIL' => 'Import to Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'Import Settings',
    'LBL_EMAIL_INVALID' => 'Invalid',
    'LBL_EMAIL_LINK_RECORD' => 'Click Here',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'Rename Mailing List',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'Enter a new name for this mailing list',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'Remove these entries from your mailing lists?',
    'LBL_EMAIL_LOADING' => 'Loading...',
    'LBL_EMAIL_MARK' => 'Mark',
    'LBL_EMAIL_MARK_FLAGGED' => 'As Flagged',
    'LBL_EMAIL_MARK_READ' => 'As Read',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'As Unflagged',
    'LBL_EMAIL_MARK_UNREAD' => 'As Unread',
    'LBL_EMAIL_ASSIGN_TO' => 'Assign To',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'Create Folder',
    'LBL_EMAIL_MENU_COMPOSE' => 'Compose to',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Delete Folder',
    'LBL_EMAIL_MENU_EDIT' => 'Edit',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Empty Trash',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Synchronize',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Clear cache files',
    'LBL_EMAIL_MENU_REMOVE' => 'Remove',
    'LBL_EMAIL_MENU_RENAME' => 'Rename',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Rename Folder',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Renaming Folder',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Please make a selection before trying this operation.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Create a Folder (remote or in Sugar)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'Archive these email(s) to SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'Email selected Mailing Lists',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'Email this Contact',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Remove a Contact',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'Delete these email(s)',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Delete a Folder (remote or in Sugar)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Edit a Contact',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Edit a Mailing List',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Empties all Trash folders for your mail accounts',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'Mark these email(s) flagged',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'Mark these email(s) read',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'Mark these email(s) unflagged',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'Mark these email(s) unread',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Removes Mailing Lists',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Rename a Folder (remote or in Sugar)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'Reply to these email(s)',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'Reply to all recipients for these email(s)',

    'LBL_EMAIL_MESSAGES' => 'messages',

    'LBL_EMAIL_ML_NAME' => 'List Name',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'Selected List Addresses',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'Available List Addresses',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-Click</b> to select multiples<br />(Mac users use <b>CMD-Click</b>)',

    'LBL_EMAIL_NO' => 'No',
    'LBL_EMAIL_NOT_SENT' => 'There was a problem sending the request email. Please contact the system administrator.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'Could not insert in users_password_link.',

    'LBL_EMAIL_OK' => 'OK',
    'LBL_EMAIL_ONE_MOMENT' => 'One moment please...',
    'LBL_EMAIL_OPEN_ALL' => 'Open Multiple Messages',
    'LBL_EMAIL_OPTIONS' => 'Options',
    'LBL_EMAIL_QUICK_COMPOSE' => 'Quick Compose',
    'LBL_EMAIL_OPT_OUT' => 'Opted Out',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Opted Out and Invalid',
    'LBL_EMAIL_PAGE_AFTER' => 'of {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'Page',
    'LBL_EMAIL_PERFORMING_TASK' => 'Performing Task',
    'LBL_EMAIL_PRIMARY' => 'Primary',
    'LBL_EMAIL_PRINT' => 'Print',

    'LBL_EMAIL_QC_BUGS' => 'Bug',
    'LBL_EMAIL_QC_CASES' => 'Case',
    'LBL_EMAIL_QC_LEADS' => 'Lead',
    'LBL_EMAIL_QC_CONTACTS' => 'Contact',
    'LBL_EMAIL_QC_TASKS' => 'Task',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'Opportunity',
    'LBL_EMAIL_QUICK_CREATE' => 'Quick Create',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'Rebuilding Folders',
    'LBL_EMAIL_RELATE_TO' => 'Relate',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'View Relationships',
    'LBL_EMAIL_RECORD' => 'Email Record',
    'LBL_EMAIL_REMOVE' => 'Remove',
    'LBL_EMAIL_REPLY' => 'Reply',
    'LBL_EMAIL_REPLY_ALL' => 'Reply All',
    'LBL_EMAIL_REPLY_TO' => 'Reply-to',
    'LBL_EMAIL_RETRIEVING_LIST' => 'Retrieving Email List',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Retrieving Message',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'Retrieving Email Record',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Please select only one email record',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'Return to Previous Module?',
    'LBL_EMAIL_REVERT' => 'Revert',
    'LBL_EMAIL_RELATE_EMAIL' => 'Relate Email',

    'LBL_EMAIL_RULES_TITLE' => 'Rule Management',

    'LBL_EMAIL_SAVE' => 'Save',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'Save & Reply',
    'LBL_EMAIL_SAVE_DRAFT' => 'Save Draft',

    'LBL_EMAIL_SEARCHING' => 'Conducting Search',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'Advanced Search',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'Date From',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Date Until',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'Body Text',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'No results match your search criteria.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Search Results',
    'LBL_EMAIL_SEARCH_TITLE' => 'Simple Search',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'Search email account',

    'LBL_EMAIL_SELECT' => 'Select',

    'LBL_EMAIL_SEND' => 'Send',
    'LBL_EMAIL_SENDING_EMAIL' => 'Sending Email',

    'LBL_EMAIL_SETTINGS' => 'Settings',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 Rows',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 Columns',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'Layout Style',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'Mail Accounts',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Clear Form',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'Import Email Upon View',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Check for New Mail',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Use Preview Pane',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Use Popup Window',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'Number emails per page',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'Edit Mail Account',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'Folders',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'From Address',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'Email Address For Test Notification:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'To Email Address',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'From Name',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Reply to Address',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Full Screen',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Synchronize All Mail Accounts',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'An email was sent to the specified email address using the provided outgoing mail settings. Please check to see if the email was received to verify the settings are correct.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Performing this action will synchronize mail accounts and their contents.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'Perform a full synchronization?\nLarge mail accounts may take a few minutes.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Click the Shift key or the Ctrl key to select multiple folders.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'General',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Available Group Folders',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Create Group Folders',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Saving Group Folders',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Retrieving Group Folder',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Edit Group Folder',

    'LBL_EMAIL_SETTINGS_NAME' => 'Mail Account Name',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Select the number of emails per page in the Inbox. This setting might require a page refresh in order to take effect.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'Retrieving Mail Account',
    'LBL_EMAIL_SETTINGS_RULES' => 'Rules',
    'LBL_EMAIL_SETTINGS_SAVED' => 'The settings have been saved.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'You must reload the page for the new settings to take effect.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'Send Plain Text Emails Only',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Active',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'Emails per Page',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'Place Tabs at Bottom',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Visual Settings',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Preferences',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Show Advanced',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Available User Folders',
    'LBL_EMAIL_ERROR_PREPEND' => 'Error:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'The outbound mail server selected for the mail account you are using is invalid.  Check the settings or select a different mail server for the mail account.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'An outgoing mail server is not configured to send emails. Please configure an outgoing mail server or select an outgoing mail server for the mail account that you are using in Settings >> Mail Account.',
    'LBL_EMAIL_SHOW_READ' => 'Show All',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Show Unread Only',
    'LBL_EMAIL_SIGNATURES' => 'Signatures',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'Create Signature',
    'LBL_EMAIL_SIGNATURE_NAME' => 'Signature Name',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'Signature Body',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Google Basic Authentication',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Exchange Basic Authentication',
    'LBL_SMTPTYPE_OTHER' => 'Other',
    'LBL_EMAIL_AUTHORIZE' => 'Authorize',
    'LBL_EMAIL_AUTHORIZED' => 'Authorized',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'Not Authorized',
    'LBL_EMAIL_AUTH_WARNING' => 'An administrator must configure the {0} Connector via Admin > Connectors before you can set up this account. For more information, refer to the {1} documentation.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'Error retrieving Connector information',
    'LBL_EMAIL_AUTH_FAILURE' => 'Authorization failure.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'Please authorize the account before saving.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'Please authorize the account before testing.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'Account Not Authorized',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Remote Folders ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugar Folders ]',
    'LBL_EMAIL_SUBJECT' => 'Subject',
    'LBL_EMAIL_SUCCESS' => 'Success',
    'LBL_EMAIL_SUGAR_FOLDER' => 'SugarFolder',
    'LBL_EMAIL_TEAMS' => 'Assign to Teams',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'Email template body is empty',
    'LBL_EMAIL_TEMPLATES' => 'Templates',
    'LBL_EMAIL_TEXT_FIRST' => 'First Page',
    'LBL_EMAIL_TEXT_PREV' => 'Previous Page',
    'LBL_EMAIL_TEXT_NEXT' => 'Next Page',
    'LBL_EMAIL_TEXT_LAST' => 'Last Page',
    'LBL_EMAIL_TEXT_REFRESH' => 'Refresh',
    'LBL_EMAIL_TO' => 'To',
    'LBL_EMAIL_TOGGLE_LIST' => 'Toggle List',
    'LBL_EMAIL_VIEW' => 'View',
    'LBL_EMAIL_VIEWS' => 'Views',
    'LBL_EMAIL_VIEW_HEADERS' => 'Display Headers',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'Printable Version',
    'LBL_EMAIL_VIEW_RAW' => 'Display Raw Email',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'This feature is unsupported when used with POP3.',
    'LBL_DEFAULT_LINK_TEXT' => 'Default link text.',
    'LBL_EMAIL_YES' => 'Yes',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Send Test Email',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Test Email Sent',


    'LBL_EMAIL_MESSAGE_NO' => 'Message No',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'Import Passed',
    'LBL_EMAIL_IMPORT_FAIL' => 'Import Failed because either the message is already imported or deleted from server',

    'LBL_EMAILS_FROM' => 'Emails Sent',
    'LBL_EMAILS_RECEIVED' => 'Emails Received',
    'LBL_EMAIL_ADDRESSES_USED' => 'Email Addresses Used In Emails',
    'LBL_EMAIL_ADDRESS' => 'Email Address',
    'LBL_FROM' => 'From',
    'LBL_TO' => 'To',
    'LBL_CC' => 'CC',
    'LBL_BCC' => 'BCC',

    'LBL_START_DATE' => 'Start Date',
    'LBL_END_DATE' => 'End Date',
    'LBL_START' => 'Start',
    'LBL_END' => 'End',
    'LBL_DATE_LINKED' => 'Date Linked',

    'LBL_LINK_NONE' => 'None',
    'LBL_LINK_ALL' => 'All',
    'LBL_LINK_RECORDS' => 'Records',
    'LBL_LINK_SELECT' => 'Select',
    'LBL_LINK_ACTIONS' => 'Actions',
    'LBL_LINK_MORE' => 'More',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'Confirm',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'Do you want to close this #module#?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'Do not display this message in the future: &nbsp;',
    'LBL_INVALID_FILE_EXTENSION' => 'Invalid File Extension',
    'LBL_LIST_TEAM' => 'Team',
    'LBL_TEAM' => 'Team:',
    'LBL_TEAMS' => 'Teams',
    'LBL_TEAM_SET_ID' => 'Team Set ID',
    'LBL_TEAM_SET_SELECTED_ID' => 'Selected Team Set ID',
    'LBL_TEAM_SET_SELECTED' => 'Selected',
    'LBL_TEAM_SET_ENABLE' => 'Enable additional permissions',
    'LBL_TEAM_SET_DISABLE' => 'Disable additional permissions',
    'LBL_TEAM_SET' => 'Team Set',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'Selected Teams',
    'LBL_SEARCH_UNAVAILABLE' => 'Search unavailable, please try again later.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'No Primary Team specified',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'Error attempting to remove primary team id [{0}] for [{1}] module with id [{2}]',
    'LBL_TEAM_ADD' => 'Add&nbsp;Team',
    'LBL_TEAM_REMOVE' => 'Remove Team',
    'LBL_TEAM_PRIMARY' => 'Set as Primary Team',

    'LBL_CLOSE_BUTTON_LABEL' => 'Close',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} marked as {{status}}.',

    'LBL_FOCUS' => 'Focus',

    'LBL_QUERY_VALID' => 'Valid',
    'LBL_QUERY_ERROR' => 'Error!',
    'LBL_QUERY_CHILD' => 'Valid Sub-Query',
    'ERROR_EXAMINE_MSG' => '  Please examine the error message below:',
    'NO_QUERY_SELECTED' => 'The data format you have selected does not contain a query.  Please select a custom query for this data format.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'An error has occurred:',
    'ERR_AJAX_LOAD_FAILURE' => 'There was an error processing your request, please try again at a later time.',
    'ERR_AJAX_LOAD_FOOTER' => 'If this error persists, please have your administrator disable Ajax for this module',
    'ERR_CREATING_FIELDS' => 'Error filling in additional detail fields: ',
    'ERR_CREATING_TABLE' => 'Error creating table: ',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'The decimal separator cannot use the same character as the thousands separator. Please change one of the values.',
    'ERR_DELETE_RECORD' => 'A record number must be specified to delete the contact.',
    'ERR_EXPORT_DISABLED' => 'Exports Disabled.',
    'ERR_EXPORT_TYPE' => 'Error exporting ',
    'ERR_REPORTS_DISABLED_EXPORT' => 'Reports Export is disabled',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'Only admin users can export',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'Report uses modules without Export access',
    'ERR_REPORTS_EXPORT_OWNER' => 'Report uses modules with Owner Export access',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'Report uses modules with List restricted access',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'Report uses modules with View restricted access',
    'ERR_REPORTS_ACCESS_DISABLED' => 'Report uses modules with restricted access',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'Report uses fields with restricted access',
    'ERR_INVALID_AMOUNT' => 'Please enter a valid amount.',
    'ERR_INVALID_DATE_FORMAT' => 'The date format must be: ',
    'ERR_INVALID_DATE' => 'Please enter a valid date.',
    'ERR_INVALID_DAY' => 'Please enter a valid day.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'not a valid email address.',
    'ERR_INVALID_FILE_REFERENCE' => 'Invalid File Reference',
    'ERR_INVALID_HOUR' => 'Please enter a valid hour.',
    'ERR_INVALID_MONTH' => 'Please enter a valid month.',
    'ERR_INVALID_TIME' => 'Please enter a valid time.',
    'ERR_INVALID_YEAR' => 'Please enter a valid 4 digit year.',
    'ERR_NEED_ACTIVE_SESSION' => 'An active session is required to export content.',
    'ERR_NO_HEADER_ID' => 'This feature is unavailable in this theme.',
    'ERR_NOT_ADMIN' => 'Unauthorized access to administration.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'Password Management is only available in <a href="%s" target="_blank">SugarIdentity</a>.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'Please contact your Sugar administrator if you would like to make changes to read-only fields.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'Please access <a href="{0}" target="_blank">SugarIdentity</a> to make changes to read-only fields.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'Missing required field:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'Invalid required field:',
    'ERR_INVALID_VALUE' => 'Invalid Value:',
    'ERR_NO_SUCH_FILE' => 'File does not exist on system',
    'ERR_NO_SINGLE_QUOTE' => 'Cannot use the single quotation mark for ',
    'ERR_NOTHING_SELECTED' => 'Please make a selection before proceeding.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'An Opportunity with the name %s already exists.  Please enter another name below.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'An Opportunity name was not entered.  Please enter an Opportunity name below.',
    'ERR_QUOTE_CONVERTED' => 'This Quote has already been converted to an Opportunity.',
    'ERR_POTENTIAL_SEGFAULT' => 'A potential Apache segmentation fault was detected.  Please notify your system administrator to confirm this problem and have her/him report it to SugarCRM.',
    'ERR_SELF_REPORTING' => 'User cannot report to him or herself.',
    'ERR_SINGLE_QUOTE' => 'Using the single quote is not supported for this field.  Please change the value.',
    'ERR_SQS_NO_MATCH_FIELD' => 'No match for field: ',
    'ERR_SQS_NO_MATCH' => 'No Match',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Please specify \'key\' index in displayParams attribute for the Meta-Data definition',
    'ERR_EXISTING_PORTAL_USERNAME' => 'Error: The Portal Name is already assigned to another contact.',
    'ERR_PORTAL_NAME_CHECK' => 'Unable to verify that Portal user name is unique',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'Field value is not compatible with precision value',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'An error occurred when trying to save to the external account.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'An error occurred while uploading.  Please ensure the file you are uploading is not empty.',
    'ERR_NO_DB' => 'Could not connect to the database. Please refer to sugarcrm.log for details.',
    'ERR_DB_FAIL' => 'Database failure. Please refer to sugarcrm.log for details.',
    'ERR_EXTERNAL_API_403' => 'Permission Denied. File type is not supported.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth Access Token is missing.',
    'ERR_DB_VERSION' => 'Sugar CRM {0} Files May Only Be Used With A Sugar CRM {1} Database.',
    'ERR_DB_QUERY' => '{0}: query failed: {1}',
    'ERR_UW_RETIRED' => 'Upgrade Wizard is not available in this version.',
    'ERR_NOT_CLOUD_INSTANCE' => 'This instance of Sugar is either not a SugarCloud instance or is not configured for SugarCloud Insights.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'You are not authorized to create {moduleName}. Contact your administrator if you need access.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'Current User not authorized to change {moduleName} configuration settings',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'Current User not authorized to change {moduleName} configuration settings',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'You are not authorized to favorite {moduleName}. Contact your administrator if you need access.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'You are not authorized to subscribe to {moduleName}. Contact your administrator if you need access.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'worksheet_columns_related_fields not found in payload',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns is not an array',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'summary_columns_related_fields not found in payload',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows is not an array',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rows_related_fields not found in payload',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'Your request failed due to an unknown exception.',
    'EXCEPTION_FATAL_ERROR' => 'Your request failed to complete.  A fatal error occurred.  Check logs for more details.',
    'EXCEPTION_NEED_LOGIN' => 'You need to be logged in to perform this action.',
    'EXCEPTION_INVALID_TOKEN' => 'Your authentication token is invalid.',
    'EXCEPTION_NOT_AUTHORIZED' => 'You are not authorized to perform this action. Contact your administrator if you need access.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'You are not authorized to view data. Contact your administrator if you need access.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'You cannot access Portal because your portal account is inactive. Please contact customer support if you need access.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'Portal is not configured properly.  Contact your Portal Administrator for assistance.',
    'EXCEPTION_NO_METHOD' => 'Your request was not supported. Could not find the HTTP method of your request for this path.',
    'EXCEPTION_NOT_FOUND' => 'Your requested resource was not found.  Could not find a handler for the path specified in the request.',
    'EXCEPTION_MISSING_PARAMTER' => 'A required parameter in your request was missing.',
    'EXCEPTION_INVALID_PARAMETER' => 'A parameter in your request was invalid.',
    'EXCEPTION_REQUEST_FAILURE' => 'Your request failed to complete.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'Your metadata or user hash did not match the server. Please resync your metadata.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'Your request is too large to process.',
    'EXCEPTION_EDIT_CONFLICT' => 'Edit conflict, please reload the record data.',
    'EXCEPTION_METADATA_CONFLICT' => 'Metadata conflict, please reload the metadata.',
    'EXCEPTION_CLIENT_OUTDATED' => 'Your software is out of date, please update your client before attempting to connect again.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'A connector or an integration request resulted in a failed response.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM is in maintenance mode. Only admins can login. Please contact your administrator for details.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'The server cannot process your request because it is busy or unavailable at this time.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'Search engine is temporarily unavailable.',
    'EXCEPTION_SEARCH_RUNTIME' => 'A search engine runtime error occurred. Please contact your System Administrator.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'A field that is locked by a process cannot be edited.',
    'EXCEPTION_MODULE_DISABLED' => 'This module is disabled for current user.',
    'EXCEPTION_FIELD_DISABLED' => 'This field is disabled for current user.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'This client is not allowed',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'The ability to upload packages is not available for your license type',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'A condition was encountered because of a general failure or error. The reasons for this exception range but generally fall outside the scope of a more specific API exception.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'The request could not be processed as presented or there was an error with the response. This generally means a fatal error occurred and that the specific failure can be identified in the application log.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'The version of the API you are using is not correct for the current request.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'The requested endpoint requires authentication and the requesting consumer has not yet authenticated.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'Indicates that the authentication token presented with the request is invalid. This generally happens due to the token expiring but could also be because the token is malformed or is incorrect.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'Indicates that the requested consumer is not authorized to perform the requested action.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'The portal account associated with the logged in user is not currently active. This requires action on the part of the customer support.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'Indicates that the portal application is not properly configured and cannot be used. This requires action on the part of the portal administrator.',
    'EXCEPTION_NO_METHOD_DESC' => 'The endpoint does not support the HTTP request type being made. This might happen when a POST request is made to an endpoint designed for a GET request for example.',
    'EXCEPTION_NOT_FOUND_DESC' => 'The endpoint could not locate a resource for the request or does not have a handler for the request.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'Indicates that there may have been concurrent edits of a record taking place and the current request to edit the record would impact a previous edit of the record.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'Indicates that the metadata on the server does not match the metadata the client is currently using. This could occur after a change to system settings, changes to modules in Studio or the deployment of new modules, among other system changes.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'The request is too large to be handled by the server.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'Indicates a require parameter of the request is missing.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'Indicates a parameter sent in the request is invalid.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'The request failed to complete.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'Indicates the client consuming the API is out of date and must be updated before further consumption of the API can take place.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'Indicates that a request made through the API to another service, endpoint or URI  has failed or could not be handled by the server.',
    'EXCEPTION_MAINTENANCE_DESC' => 'The instance of SugarCRM that is serving the API is in maintenance mode. Access to the API is restricted to administrators only.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'Indicates that the server is busy, overloaded or down.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'The search engine backend is currently unavailable due to a connection issue. Verify connectivity and configuration in Admin->search->test.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'A runtime exception occured in SearchEngine. See sugarcrm.log for more details.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'A field that is currently locked by a running process cannot be edited.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s is locked by a running process and cannot be edited.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s are locked by a running process and cannot be edited.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'This module is disabled for current user.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'This field is disabled for current user.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'This client is not allowed',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'A file with the same name already exists in the system.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'Error Timeperiod undefined for date {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'This TimePeriod already has sub-periods',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'Sub Time Periods cannot have sub-periods',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'Unable to retrieve any Time Periods of type: {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'No active Time Periods for the current settings.',
    'LBL_CURRENT_TIMEPERIOD' => 'Current Time Period',
    'LBL_PREVIOUS_TIMEPERIOD' => 'Previous Time Period',
    'LBL_NEXT_TIMEPERIOD' => 'Next Time Period',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'Previous,Current,Next',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'You cannot delete records that have a closed sales stage.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'You cannot delete records that have a closed sales status.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be deleted.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be deleted.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'Account',
    'LBL_OLD_ACCOUNT_LINK' => 'Old Account',
    'LBL_ACCOUNTS' => 'Accounts',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Activities',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'View Summary',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'View Summary',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Add',
    'LBL_ADD_BUTTON' => 'Add',
    'LBL_ADD_DASHLET_BUTTON' => 'Add Dashlet',
    'LBL_ADD_DOCUMENT' => 'Add Document',
    'LBL_REPLACE_BUTTON' => 'Replace',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Add To Target List',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Add To Target List',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Click to Close',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Close',
    'LBL_ADDITIONAL_DETAILS' => 'Additional Details',
    'LBL_ADMIN' => 'Admin',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'Archive',
    'LBL_ASSIGNED_TO_USER' => 'Assigned to User',
    'LBL_ASSIGNED_TO' => 'Assigned to:',
    'LBL_BACK' => 'Back',
    'LBL_BASE_RATE' => 'Base Rate',
    'LBL_BILL_TO_ACCOUNT' => 'Bill to Account',
    'LBL_BILL_TO_CONTACT' => 'Bill to Contact',
    'LBL_BILLING_ADDRESS' => 'Billing Address',
    'LBL_QUICK_CREATE_TITLE' => 'Quick Create',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'Bugs',
    'LBL_BY' => 'by',
    'LBL_CALLS' => 'Calls',
    'LBL_CALL' => 'Call',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Send Queued Campaign Emails',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Submit',
    'LBL_CASE' => 'Case',
    'LBL_CASES' => 'Cases',
    'LBL_MESSAGE' => 'Message',
    'LBL_MESSAGES' => 'Messages',
    'LBL_ESCALATIONS' => 'Escalations',
    'LBL_ESCALATION' => 'Escalation',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign Envelopes',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign Envelope',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'Select signer recipients',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'Change Password',
    'LBL_CHANGE_BUTTON_LABEL' => 'Change',
    'LBL_CHANGE_BUTTON_TITLE' => 'Change',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Check All',
    'LBL_CITY' => 'City',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Clear',
    'LBL_CLEAR_BUTTON_TITLE' => 'Clear',
    'LBL_CLEARALL' => 'Clear All',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => 'Close',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'Close Window',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Close All',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Close All',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Close and Create New',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Close and Create New',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'Copy Record URL',
    'LBL_OPEN_ITEMS' => 'Open Items:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Compose Email',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'Email',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Compose Email',
    'LBL_SEARCH_DROPDOWN_YES' => 'Yes',
    'LBL_SEARCH_DROPDOWN_NO' => 'No',
    'LBL_CONTACT_LIST' => 'Contact List',
    'LBL_CONTACT' => 'Contact',
    'LBL_CONTACTS' => 'Contacts',
    'LBL_CONTRACTS' => 'Contracts',
    'LBL_COUNTRY' => 'Country:',
    'LBL_RESET_BUTTON_LABEL' => 'Reset',
    'LBL_CREATE_BUTTON_LABEL' => 'Create',
    'LBL_CREATED_BY_USER' => 'Created by User',
    'LBL_CREATED_USER' => 'Created by User',
    'LBL_CREATED_ID' => 'Created By Id',
    'LBL_CREATED' => 'Created by',
    'LBL_CREATE_NEW_TARGET_LIST' => 'Create new target list',
    'LBL_CURRENT_USER_FILTER' => 'My Items:',
    'LBL_CURRENCY' => 'Currency:',
    'LBL_CURRENCIES' => 'Currencies',
    'LBL_CURRENCY_NAME' => 'Currency Name',
    'LBL_CURRENCY_SYMBOL' => 'Currency Symbol',
    'LBL_CURRENCY_RATE' => 'Base Rate:',
    'LBL_CURRENCY_ID' => 'Currency ID',
    'LBL_DOCUMENTS' => 'Documents',
    'LBL_DATE_ENTERED' => 'Date Created:',
    'LBL_DATE_MODIFIED' => 'Date Modified:',
    'LBL_ACTIVITY_MODIFIED' => 'Modified',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'Edit Overview Tab',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'Edit Module Tabs',
    'LBL_EDIT_BUTTON' => 'Edit',
    'LBL_DUPLICATE_BUTTON' => 'Duplicate',
    'LBL_DELETE_BUTTON' => 'Delete',
    'LBL_DELETE' => 'Delete',
    'LBL_DELETED' => 'Deleted',
    'LBL_DIRECT_REPORTS' => 'Direct Reports',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Done',
    'LBL_DONE_BUTTON_TITLE' => 'Done',
    'LBL_DST_NEEDS_FIXIN' => 'The application requires a Daylight Saving Time fix to be applied.  Please go to the <a href="index.php?module=Administration&action=DstFix">Repair</a> link in the Admin console and apply the Daylight Saving Time fix.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Edit As New',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Edit As New',
    'LBL_EDIT_IN_NEW_TAB' => 'Edit in New Tab',
    'LBL_FAVORITES' => 'Favorites',
    'LBL_FILTER' => 'Filter',
    'LBL_DEFAULT_DATA_FILTER' => 'Default Data Filter',
    'LBL_FILTER_MENU_BY' => 'Filter Menu By',
    'LBL_FILTER_SELECT_FIELD' => 'Select field...',
    'LBL_FILTER_SELECT_OPERATOR' => 'Select operator...',
    'LBL_FILTER_CREATE_NEW' => 'Build Filter',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'Build Filter (Unsaved)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(Unsaved)',
    'LBL_FILTER_CREATE_FILTER' => 'Create new filter',
    'LBL_FILTER_CLOSE_FILTER' => 'Close filter',
    'LBL_FILTER_EDIT_FILTER' => 'Edit filter',
    'LBL_FILTER_ALL_RECORDS' => 'All Records',
    'TPL_FILTER_SAVE' => 'You successfully created the filter {{name}}.',
    'LBL_FILTER_BETWEEN_FROM' => 'From',
    'LBL_FILTER_BETWEEN_TO' => 'To',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'Start date',
    'LBL_FILTER_DATEBETWEEN_TO' => 'End date',
    'LBL_FOLLOWING' => 'Following',
    'LBL_UNFOLLOW' => 'Unfollow',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'Download vCard',
    'LBL_EMPTY_VCARD' => 'Please select a vCard file',
    'LBL_IMAGE' => 'Image',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard does not have all the required fields for this module.',
    'LBL_VCARD_ERROR_FILESIZE' => 'The uploaded file exceeds the 30000 bytes size limit which was specified in the HTML form.',
    'LBL_VCARD_ERROR_DEFAULT' => 'There was an error uploading the vCard file.',
    'TPL_IMPORT_VCARD_FAILURE' => 'Failed to create {{module}} from vCard',
    'LBL_IMPORT_VCARD' => 'Import vCard:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'Import vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'Import vCard',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'View',
    'LBL_VIEW_BUTTON_TITLE' => 'View',
    'LBL_VIEW_BUTTON' => 'View',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'Email as PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'Email as PDF',
    'LBL_EMAIL' => 'Email',
    'LBL_EMAILS' => 'Emails',
    'LBL_EMPLOYEES' => 'Employees',
    'LBL_ENTER_DATE' => 'Enter Date',
    'LBL_EXPORT_ALL' => 'Export All',
    'LBL_EXPORT' => 'Export',
    'LBL_FAVORITES_FILTER' => 'My Favorites:',
    'LBL_GLOBAL_SEARCH' => 'Global Search',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'Global Search Module Filter',
    'LBL_GLOBAL_SEARCH_RUN' => 'Run Global Search',
    'LBL_GO_BUTTON_LABEL' => 'Go',
    'LBL_GS_HELP' => 'The fields in this module used in this search appear above.  The highlighted text matches your search criteria.',
    'LBL_HIDE' => 'Hide',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => 'Import',
    'LBL_IMPORT_STARTED' => 'Import Started: ',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Must specify a custom delimiter.',
    'LBL_LAST_VIEWED' => 'Recently Viewed',
    'LBL_SELECTED_RECORDS' => 'Selected: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'Show less',
    'LBL_SHOW_MORE' => 'Show more',
    'LBL_SHOW_MORE_MODULE' => 'More {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'More recents...',
    'LBL_SHOW_LESS_RECENTS' => 'Less recents',
    'LBL_SHOW_MORE_RESULTS' => 'More search results...',
    'TPL_SHOW_MORE_MODULE' => 'More {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => 'More {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => 'Today\'s Activities',
    'LBL_LEADS' => 'Leads',
    'LBL_LEAD' => 'Lead',
    'LBL_QUOTES_BILL_TO' => 'Quotes (Bill To)',
    'LBL_LESS' => 'less',
    'LBL_CAMPAIGN' => 'Campaign:',
    'LBL_CAMPAIGNS' => 'Campaigns',
    'LBL_CAMPAIGNLOG' => 'CampaignLog',
    'LBL_CAMPAIGN_CONTACT' => 'Campaigns',
    'LBL_CAMPAIGN_ID' => 'campaign_id',
    'LBL_THEME' => 'Theme:',
    'LBL_THEME_PICKER' => 'Page Style',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Warning: Internet Explorer 6 is not supported for the selected theme. Click OK to select it anyways or Cancel to select a different theme.',
    'LBL_FOUND_IN_RELEASE' => 'Found In Release',
    'LBL_FIXED_IN_RELEASE' => 'Fixed In Release',
    'LBL_LIST_ACCOUNT_NAME' => 'Account Name',
    'LBL_LIST_ASSIGNED_USER' => 'User',
    'LBL_LIST_CONTACT_NAME' => 'Contact Name',
    'LBL_LIST_CONTACT_ROLE' => 'Contact Role',
    'LBL_LIST_DATE_ENTERED' => 'Date Created',
    'LBL_LIST_EMAIL' => 'Email',
    'LBL_LIST_NAME' => 'Name',
    'LBL_LIST_OF' => 'of',
    'LBL_LIST_PHONE' => 'Phone',
    'LBL_LIST_RELATED_TO' => 'Related To',
    'LBL_LIST_USER_NAME' => 'User Name',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'Are you sure you want to update the entire list?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Please select at least 1 record to proceed.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Please select at least 2 records to proceed.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Please select less than 10 records to proceed.',
    'LBL_LISTVIEW_ALL' => 'All',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'Freeze Column 1',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'All duplicates',
    'LBL_LISTVIEW_NONE' => 'Deselect All',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Select This Page',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Select All',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Selected Records',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Selected: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'Clear all selections.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'Select all records',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'There are more than {{num}} records in the result set. You have selected the first {{num}} records.',
    'TPL_LISTVIEW_SELECTED' => 'You have selected {{num}} records in the result set.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'You have selected 1 record in the result set.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'You have selected all {{num}} records in the result set.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'You have selected all {{num}} records in this view. {{link}} in the result set.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'Updating {{num}} of {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(about {{time}} {{unit}} left)',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'Mass Update failed. Initiating new attempt ({{num}} of {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'Mass Update incomplete. {{num}} record(s) remain unchanged.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'Mass Update incomplete. {{num}} record(s) remain unchanged.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} record(s) were ignored due to permissions or errors.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} record(s) were updated successfully.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} Mass Update',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'Deleting {{num}} of {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(about {{time}} {{unit}} left)',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'Mass Delete failed. Initiating new attempt ({{num}} of {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'Mass Delete incomplete. {{num}} record(s) remain.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'Mass Delete incomplete. {{num}} record(s) remain.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} record(s) were deleted successfully.',
    'TPL_MASSDELETE_TITLE' => '{{module}} Mass Delete',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'Adding {{num}} of {{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(about {{time}} {{unit}} left)',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'Mass Add to Target List failed. Initiating new attempt ({{num}} of {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'Mass Add to Target List incomplete. {{num}} records not added.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'Mass Add to Target List incomplete. {{num}} records not added.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} records were added successfully.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} Mass Add to Target List',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'Linking {{num}} of {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(about {{time}} {{unit}} left)',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'Mass Link failed. Initiating new attempt ({{num}} of {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'Mass Link incomplete. {{num}} records not added.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'Mass Link incomplete. {{num}} records not added.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} records were linked successfully.',
    'TPL_MASSLINK_TITLE' => '{{module}} Mass Link',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'Select',
    'LBL_LISTVIEW_ACTIONS' => 'Actions',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'Select all records on this page',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'Deselect all records on this page',
    'LBL_MASS_UPDATE_CHECKBOX' => 'Mass update',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} of {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '{{num}} of Loading...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'Click for total',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'of',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'Get number of pages',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'David',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Livingstone',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Dr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Code Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => 'Please sign in to access this area.',
    'LBL_LOGOUT' => 'Log Out',
    'LBL_FINISH_IMPERSONATING' => 'Finish Impersonating',
    'LBL_RESET_MFA' => 'Reset Multi-Factor Auth',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, you are currently impersonating {{user}}.',
    'LBL_PROFILE' => 'Profile',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'Mail Merge',
    'LBL_MASS_UPDATE' => 'Mass Update',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'Select all records for mass update',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'Include record in mass update',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'Add Field',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'Remove Field',
    'LBL_GENERATE_QUOTE' => 'Generate Quote',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'There are no fields available for the Mass Update operation',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'Your request for mass update has been scheduled.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'Service Start Date exceeds service End Date',
    'LBL_MASS_UPDATE_SUCCESS' => 'All records were updated successfully.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'Selected records were added to the <a href="{{listUrl}}">{{listName}}</a> target list.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'Your request to add selected records to the <a href="{{listUrl}}">{{listName}}</a> target list has been scheduled.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'The update will remove the following values: ',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'Cancel to keep existing values. Confirm to remove the values.',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'Opt out Primary Email',
    'LBL_MEETINGS' => 'Meetings',
    'LBL_MEETING' => 'Meeting',
    'LBL_MEETING_GO_BACK' => 'Go back to the Meeting',
    'LBL_MEMBERS' => 'Members',
    'LBL_MEMBER_OF' => 'Member Of',
    'LBL_MODIFIED_BY_USER' => 'Modified by User',
    'LBL_MODIFIED_USER' => 'Modified by User',
    'LBL_MODIFIED' => 'Modified by',
    'LBL_MODIFIED_NAME' => 'Modified By',
    'LBL_MODIFIED_ID' => 'Modified By Id',
    'LBL_MORE' => 'More',
    'LBL_MORE_MODULES' => 'More Modules',
    'LBL_MORE_TABS' => 'More Tabs',
    'LBL_MULTIPLE_MODULES' => 'Multiple Modules',
    'LBL_COUNT_MODULES' => '{{count}} Modules',
    'LBL_MY_ACCOUNT' => 'My Settings',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'system default',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'user default',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'user account',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'group account',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'Name',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Create',
    'LBL_NEW_BUTTON_TITLE' => 'Create',
    'LBL_NEXT_BUTTON_LABEL' => 'Next',
    'LBL_NOTES' => 'Notes',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Open All',
    'LBL_OPENALL_BUTTON_TITLE' => 'Open All',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Open To: ',
    'LBL_OPENTO_BUTTON_TITLE' => 'Open To:',
    'LBL_OPEN_IN_NEW_TAB' => 'Open in New Tab',
    'LBL_OPPORTUNITIES' => 'Opportunities',
    'LBL_OPPORTUNITY_NAME' => 'Opportunity Name',
    'LBL_OPPORTUNITY' => 'Opportunity',
    'LBL_OR' => 'OR',
    'LBL_LOWER_OR' => 'or',
    'LBL_PANEL_ASSIGNMENT' => 'Other',
    'LBL_PANEL_ADVANCED' => 'More Information',
    'LBL_PANEL_BODY' => 'Overview',
    'LBL_PARENT_TYPE' => 'Parent Type',
    'LBL_RELATED_TYPE' => 'Related Type',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'Range',
    'LBL_PICTURE_FILE' => 'Avatar',
    'LBL_POSTAL_CODE' => 'Postal Code:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'Primary Address City:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'Primary Address Country:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'Primary Address Postal Code:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Primary Address State:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Primary Address Street 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Primary Address Street 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Primary Address Street:',
    'LBL_PRIMARY_ADDRESS' => 'Primary Address:',

    'LBL_BILLING_STREET' => 'Street:',
    'LBL_SHIPPING_STREET' => 'Street:',

    'LBL_PRODUCT_BUNDLES' => 'Product Bundles',
    'LBL_PRODUCTS' => 'Products',
    'LBL_PROJECT_TASKS' => 'Project Tasks',
    'LBL_PRODUCT_TEMPLATES' => 'Product Templates',
    'LBL_PROJECTS' => 'Projects',
    'LBL_PROSPECTS' => 'Targets',
    'LBL_QUICK_CREATE_MENU' => 'Quick Create Menu',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Create Opportunity from Quote',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Create Opportunity from Quote',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'Creating Opportunity...',
    'LBL_QUOTES_SHIP_TO' => 'Quotes Ship to',
    'LBL_QUOTES' => 'Quotes',

    'LBL_FORECAST_WORKSHEETS' => 'Forecast Worksheets',
    'LBL_FORECAST_WORKSHEET' => 'Forecast Worksheet',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'Invite',
    'LBL_INVITED' => 'Invited',
    'LBL_RECOMMENDED_INVITES' => 'Recommended Invites',
    'LBL_INSTANCES' => 'Instances',
    'LBL_YOUR_INSTANCES' => 'Your Instances',
    'LBL_INSTANCE_USERS' => 'Instance Users',
    'LBL_SWITCH_INSTANCE' => 'Switch to this instance',
    'LBL_LAST_LOGIN' => 'last login',
    'LBL_ENTER_EMAIL' => 'Enter invitee email...',
    'LBL_INSTANCE_IN_USE' => 'Instance In Use',
    'LBL_INSTANCE_ACTIVE' => 'You are already using this instance!',
    'LBL_INSTANCE_INVITE_SENT' => 'Invite sent to',
    'LBL_INSTANCE_SWITCH_FAILED' => 'Failed to switch instances',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'Reminders',
    'LBL_REMINDERS_OVERDUE' => 'Overdue',
    'LBL_REMINDERS_UPCOMING' => 'Upcoming',
    'LBL_REMINDERS_NONE_FOUND' => 'No reminders found.',
    'LBL_REMINDERS_FINISHED' => 'Finished!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'Opportunity Metrics',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'Sweet Spot Configuration Panel',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'Hotkeys',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'Failed to update configuration preferences: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'Sweet Spot Action',
    'LBL_SWEETSPOT_KEY' => 'Keyword',
    'LBL_SWEETSPOT_REMOVE' => 'Remove action',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'Hotkeys',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'Actions',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'Records',
    'LBL_SWEETSPOT_THEME' => 'Theme',
    'LBL_SWEETSPOT_THEME_SELECT' => 'Select theme',

    'LBL_RELATED' => 'Related',
    'LBL_RELATED_INFORMATION' => 'Related Information',
    'LBL_RELATED_RECORDS' => 'Related Records',
    'LBL_REPORTS_TO' => 'Reports To',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'Indicates required field',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Done',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Save As',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Save As',
    'LBL_FULL_FORM_BUTTON_KEY' => 'L',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Full Form',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Full Form',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Save & Create New',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Save & Create New',
    'LBL_SAVE_OBJECT' => 'Save {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Search',
    'LBL_SEARCH_BUTTON_TITLE' => 'Search',
    'LBL_SEARCH' => 'Search',
    'LBL_SEARCH_TIPS' => 'Press the search button or click enter to get an exact match for them.',
    'LBL_SEARCH_TIPS_2' => 'Press the search button or click enter to get an exact match for',
    'LBL_SEARCH_MORE' => 'more',
    'LBL_SEE_ALL' => 'See All',
    'LBL_SEARCH_LOAD_MORE' => 'LOAD MORE',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Invalid file format, only image file can be uploaded.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'Image format {0} is no longer supported.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Select',
    'LBL_SELECT_BUTTON_TITLE' => 'Select',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'Add Team(s)',
    'LBL_SELECT_TEAMS_TITLE' => 'Add Teams(s)',
    'LBL_SELECT_APPEND_TEAMS' => 'Append Team(s)',
    'LBL_SELECT_APPEND_VALUES' => 'Append value(s)',
    'LBL_SELECT_APPEND_TAGS' => 'Append Tag(s)',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Browse Documents',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Browse Documents',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Select Contact',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Select Contact',
    'LBL_GRID_SELECTED_FILE' => 'selected file',
    'LBL_GRID_SELECTED_FILES' => 'selected files',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Select from Reports',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Select Reports',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Select User',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Select User',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Clear Selection',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Clear Selection',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Clear Selection',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Clear Selection',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Select File',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Select File',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Clear File',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Clear File',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Select User',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Select User',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Clear User',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Clear User',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Select Account',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Select Account',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Clear Account',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Clear Account',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Select Campaign',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Select Campaign',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Clear Campaign',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Clear Campaign',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'Select Contact',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'Select Contact',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Clear Contact',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Clear Contact',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Select Team',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Select Team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Clear Team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Clear Team',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Resources used to construct this page (queries, files)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'seconds.',
    'LBL_SERVER_RESPONSE_TIME' => 'Server response time:',
    'LBL_SERVER_MEMORY_BYTES' => 'bytes',
    'LBL_SERVER_MEMORY_USAGE' => 'Server Memory Usage: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Usage: - module: {0} - action: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Server Peak Memory Usage: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'Ship to Account',
    'LBL_SHIP_TO_CONTACT' => 'Ship to Contact',
    'LBL_SHIPPING_ADDRESS' => 'Shipping Address',
    'LBL_SHORTCUTS' => 'Shortcuts',
    'LBL_SHOW' => 'Show',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'State:',
    'LBL_STATUS_UPDATED' => 'Your Status for this event has been updated!',
    'LBL_STATUS_NOT_UPDATED' => 'Your Status for this event has not been updated.',
    'LBL_STATUS' => 'Status:',
    'LBL_STREET' => 'Street',
    'LBL_SUBJECT' => 'Subject',

    'LBL_INBOUNDEMAIL_ID' => 'Inbound Email ID',
    'LBL_EAMP_ID' => 'Authentication Token ID',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'All Rights Reserved.<br />SugarCRM, Sugar, the Sugar stack logo, and the 3-D Cube are registered trademarks of SugarCRM Inc. ' .
        'All other company and product names used or appearing in this product may be trademarks of the ' .
        'respective companies with which they are associated.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'Scheduled Job Completed',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'The Scheduled Job has successfully ran',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'Revenue Line Items Are Now Enabled in Your Sugar Instance',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Revenue Line Items are now enabled in your Sugar instance, and all existing Opportunity data has been processed. Your instance is now ready to be used with Revenue Line Items. For more information about the changes which have been made, please refer to the {{doc_url}}.

Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'Forecasts Module is Now Ready for Use With Opportunities in Your Sugar Instance',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'The Forecasts module in your Sugar instance is now available for use with opportunities. All previous Revenue Line Item forecast commit data has been removed, and the instance is ready for forecasts to be created and committed with opportunities. For more information about the changes which have been made, please refer to the {{doc_url}}.

Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Revenue Line Items Are Now Disabled in Your Sugar Instance',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Revenue line Items are now disabled in your Sugar instance, and all existing Revenue Line Item data has been processed. Your instance is now ready to be used with Opportunities. For more information about the changes which have been made, please refer to the {{doc_url}}.

Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'Opportunities Configuration documentation',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'Log In',
    'LBL_LOGIN_WELCOME_TO' => 'Welcome to',
    'LBL_LOGIN_OPTIONS' => 'Options',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'Forgot Password?',
    'LBL_LOGIN_SUBMIT' => 'Submit',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'Too many failed login attempts.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'You can try logging in again in ',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'days.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 'h.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'min.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'sec.',
    'LBL_LOGIN_ADMIN_CALL' => 'Please contact the system administrator.',
    'LBL_LOGIN_USERNAME' => 'Username',
    'LBL_LOGIN_PASSWORD' => 'Password',
    'LBL_LOGGED_OUT' => 'You have been logged out.',
    'LBL_LOGIN_FORM_LABEL' => 'Show log in form',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'Return to login',
    'LBL_LOGIN_INACTIVE_USER' => 'Inactive user',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'Portal or group user can not log in.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'Dashboard',
    'LBL_SYNC' => 'Sync',
    'LBL_TASKS' => 'Tasks',
    'LBL_TEAMS_LINK' => 'Teams',
    'LBL_THEME_COLOR' => 'Color',
    'LBL_THEME_FONT' => 'Font',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'Schedule Meeting',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'Schedule Meeting',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'Archive Email',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'Archive Email',
    'LBL_UNAUTH_ADMIN' => 'Unauthorized access to administration',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Undelete',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Undelete',
    'LBL_UNDELETE_BUTTON' => 'Undelete',
    'LBL_UNDELETE' => 'Undelete',
    'LBL_UNSYNC' => 'Unsync',
    'LBL_UPDATE' => 'Update',
    'LBL_UPDATES' => 'Updates',
    'LBL_USER_LIST' => 'User List',
    'LBL_USER_MENU' => 'User Menu',
    'LBL_USERS_SYNC' => 'Users Sync',
    'LBL_USERS' => 'Users',
    'LBL_USER' => 'User',
    'LBL_CURRENT_USER' => 'Current User',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'Checking for existing email entry...',
    'LBL_VERIFY_PORTAL_NAME' => 'Checking for existing portal name...',
    'LBL_VIEW_IMAGE' => 'view',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'Print as PDF',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'Print as PDF',

    'LBL_KBDOCUMENTS' => 'Knowledge Base',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'About',
    'LNK_ADVANCED_SEARCH' => 'Advanced Search',
    'LNK_BASIC_SEARCH' => 'Basic Search',
    'LNK_SEARCH_NO_RESULTS' => 'No results were found.',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'View all results',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Show All',
    'LNK_CLOSE' => 'close',
    'LBL_MODIFY_CURRENT_SEARCH' => 'Modify current search',
    'LNK_SAVED_VIEWS' => 'Layout Options',
    'LNK_DELETE_ALL' => 'del all',
    'LNK_DELETE' => 'delete',
    'LNK_EDIT' => 'edit',
    'LNK_VIEW' => 'view',
    'LNK_GET_LATEST' => 'Get latest',
    'LNK_GET_LATEST_TOOLTIP' => 'Replace with latest version',
    'LNK_HELP' => 'Help',
    'LNK_CREATE' => 'Create',
    'LNK_CREATE_WHEN_EMPTY' => 'Create a record now.',
    'LNK_LIST_END' => 'End',
    'LNK_LIST_NEXT' => 'Next',
    'LNK_LIST_PREVIOUS' => 'Previous',
    'LNK_LIST_RETURN' => 'Return to List',
    'LNK_LIST_START' => 'Start',
    'LNK_LOAD_SIGNED' => 'Sign',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'Replace with signed document',
    'LNK_PRINT' => 'Print',
    'LNK_BACKTOTOP' => 'Back to top',
    'LNK_REMOVE' => 'remove',
    'LNK_RESUME' => 'Resume',
    'LNK_VIEW_CHANGE_LOG' => 'View Audit Log',
    'TPL_AUDIT_LOG_TITLE' => 'Audit Log for {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'Click to view email address audit log',
    'LBL_NO_SEARCH_RESULTS' => 'No results found for your search',
    'NTC_CLICK_BACK' => 'Please click the browser back button and fix the error.',
    'NTC_DATE_FORMAT' => '(yyyy-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(yyyy-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'Are you sure you want to delete selected record(s)?',
    'NTC_TEMPLATE_IS_USED' => 'The template is used in at least one email marketing record. Are you sure you want to delete it?',
    'NTC_TEMPLATES_IS_USED' => "The following templates are used in email marketing records. Are you sure you want to delete them?\n",
    'NTC_DELETE_CONFIRMATION' => 'Are you sure you want to delete this record?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'Are you sure you want to delete the {0}?',
    'LBL_METRIC_DELETE_WARNING' => 'Any users this metric tab has been shared with will also lose access.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'Are you sure you want to delete the ',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'Are you sure you want to update the ',
    'NTC_DELETE_SELECTED_RECORDS' => ' selected record(s)?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'This filter will be removed from all views; this may include data configuration for dashlets. Are you sure you want to delete this filter?',
    'TPL_DELETE_FILTER_SUCCESS' => 'You deleted the filter {{name}}.',
    'NTC_DELETE_SUCCESS' => 'You deleted the {0}.',
    'NTC_UNLINK_CONFIRMATION' => 'Are you sure you want to unlink this record?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'Are you sure you want to unlink the {0}?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'Are you sure you want to unlink the {0}? This will also remove them from the case\'s Primary Contact field.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => 'The {0} cannot be unlinked because they are the primary contact on this case. Update the Primary Contact field before unlinking this record.',
    'NTC_UNLINK_SUCCESS' => 'You unlinked the {0}.',
    'NTC_LOGIN_MESSAGE' => 'Please enter your user name and password.',
    'NTC_NO_ITEMS_DISPLAY' => 'none',
    'NTC_REMOVE_CONFIRMATION' => 'Are you sure you want to remove this relationship? Only the relationship will be removed. The record will not be deleted.',
    'NTC_REQUIRED' => 'Indicates required field',
    'NTC_SUPPORT_SUGARCRM' => 'Support the SugarCRM open source project with a donation through PayPal - it\'s fast, free and secure!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'Welcome',
    'NTC_YEAR_FORMAT' => '(yyyy)',
    'LOGIN_LOGO_ERROR' => 'Please replace the SugarCRM logos.',
    'FATAL_LICENSE_ALTERED' => 'Your license has been altered since the last time it was validated.',
    'ERROR_FULLY_EXPIRED' => "Your company's license for SugarCRM has expired for more than 7 days and needs to be brought up to date. Only admins may login.",
    'ERROR_LICENSE_EXPIRED' => "Your company's license for SugarCRM needs to be updated. Only admins may login.",
    'WARN_LICENSE_EXPIRED' => "Your company's license for SugarCRM will expire soon.",
    'ERROR_LICENSE_VALIDATION' => "Your company's license for SugarCRM needs to be validated. Only admins may login.",
    'WARN_LICENSE_VALIDATION' => "Your company's license for SugarCRM needs to be validated soon.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>Warning:</b> Your browser is in IE compatibility view which is not supported.',
    'WARN_LICENSE_SEATS' => 'Warning: The number of active users is already the maximum number of licenses allowed.',
    'WARN_LICENSE_SEATS_MAXED' => 'Warning: The number of active users exceeds the maximum number of licenses allowed.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'Number of active users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'Only admins may login.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'The User License Count limit has been reached. Only existing users may login.',
    'WARN_ONLY_ADMINS' => 'Only admins may login.',
    'WARN_UNSAVED_CHANGES' => 'You are about to leave this record without saving any changes you may have made to the record. Are you sure you want to navigate away from this record?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close all SugarLive call or chat sessions you have open and any unsaved changes will be lost. Do you wish to proceed?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'You have unsaved changes. Are you sure you want to leave page and discard changes?',
    'LBL_MFA_RESET_CONFIRMATION' => 'Are you sure you want to reset your <a href="{{linkToDocumentation}}" target="_blank">multi-factor authentication</a>?
Performing this action will immediately log you out, and you will need to authenticate using the authenticator app the next time you log in.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'Confirm & Log Out',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'You have one or more unsaved changes. Are you sure you want to close the drawer?',
    'LBL_NAVIGATE_TO_REPORTS' => 'You are moving to the Reports module. Your changes to dashlet will not be saved. Continue?',
    'ERROR_NO_RECORD' => 'Error retrieving record.  This record may be deleted or you may not be authorized to view it.',
    'ERROR_TYPE_NOT_VALID' => 'Error. This type is not valid.',
    'ERROR_MAX_FIELD_LENGTH' => 'Error. The max length of this field is {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'Error. The min length of this field is {{this}}.',
    'ERROR_EMAIL' => 'Error. Invalid Email Address: {{#each this}}{{{this}}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'Error. At least one primary address should be set.',
    'ERROR_DUPLICATE_EMAIL' => 'Error. Duplicate Email Address: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'Error. This field is required.',
    'ERROR_MINVALUE' => 'Error. The minimum value of this field is {{this}}.',
    'ERROR_MAXVALUE' => 'Error. The maximum value of this field is {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'Error. The value of this field must be greater than {{this}}.',
    'ERROR_IS_LESS_THAN' => 'Error. The value of this field must be less than {{this}}.',
    'ERROR_DATETIME' => 'Error. This field requires a valid date.',
    'ERROR_IS_BEFORE' => 'Error. The date of this field must be before date of {{this}} field.',
    'ERROR_IS_AFTER' => 'Error. The date of this field must be after date of {{this}} field.',
    'ERROR_TIME_IS_BEFORE' => 'Error. The time of this field must be before the time of the {{this}} field.',
    'ERROR_TIME_IS_AFTER' => 'Error. The time of this field must be after the time of the {{this}} field.',
    'ERROR_NUMBER' => 'Error. This field requires a valid number.',
    'ERROR_INT' => 'Error. Invalid integer.',
    'ERROR_URL' => 'Error. Invalid URL.',
    'ERROR_NO_BEAN' => 'Failed to get bean.',
    'ERROR_ACCESS_MODULE' => 'You do not have access to this module.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'The attachment is too large.',
    'ERROR_UPLOAD_FAILED' => 'Error. The file failed to upload.',
    'ERROR_UPLOAD_ACCESS_PD' => 'You do not have permission to import Process Definitions. Please contact your Sugar Administrator.',
    'ERROR_UPLOAD_ACCESS_BR' => 'You do not have permission to create [business rules] for this module.',
    'ERROR_UPLOAD_ACCESS_ET' => 'You do not have permission to create [email templates] for this module.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'Error. You entered an unsupported operator.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'Error. You entered an invalid operator.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'Error. You entered an invalid filter.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'Import failed. A group field is partially locked in the Process Definition.' .
        ' These fields must be unlocked in the Process Definition in order for the definition to be imported.',
    'ERROR_EXP_DATE_LOW' => 'Error. Expiration Date can not be before the date of publishing.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'Error. The Approved status requires publishing date.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'The Publish Date is empty.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today\'s date.',
    'LBL_DUP_MERGE' => 'Find Duplicates',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'Duplicate check is disabled for {{module}}.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'Manage Subscriptions',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Manage Subscriptions for ',
    'LBL_SUBSCRIBE' => 'Subscribe',
    'LBL_UNSUBSCRIBE' => 'Unsubscribe',
    'LBL_CREATE_LINK_RECORD' => 'Create and Link Record',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'Create and Link Record',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} records have been linked.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'No records to link.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'The report selected is not based on the correct module type.',
    'ERROR_EMPTY_LINK_MODULE' => 'Please select the relationship first.',
    // Ajax status strings
    'LBL_LOADING' => 'Loading...',
    'LBL_LOADING_NO_DOTS' => 'Loading',
    'LBL_SEARCHING' => 'Searching...',
    'LBL_SEARCH_UNDERWAY' => 'Searching',
    'LBL_SAVING_LAYOUT' => 'Saving Layout...',
    'LBL_SAVED_LAYOUT' => 'Layout has been saved.',
    'LBL_SAVED' => 'Saved',
    'LBL_SAVING' => 'Saving',
    'LBL_FAILED' => 'Failed!',
    'LBL_DISPLAY_COLUMNS' => 'Display Columns',
    'LBL_HIDE_COLUMNS' => 'Hide Columns',
    'LBL_SEARCH_CRITERIA' => 'Search Criteria',
    'LBL_SAVED_VIEWS' => 'Saved Views',
    'LBL_PROCESSING_REQUEST' => 'Processing..',
    'LBL_REQUEST_PROCESSED' => 'Done',
    'LBL_AJAX_FAILURE' => 'Ajax failure',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'Search ...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Saved Searches',
    'LBL_SEARCH_POPULATE_ONLY' => 'Perform a search using the search form above',
    'LBL_SEARCH_NO_RESULTS' => 'No results found for ',
    'LBL_SEARCH_FOR' => 'Search for ',
    'LBL_SEARCH_FOR_MORE' => 'Search for more...',
    'LBL_SEARCH_SELECT' => 'Select...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'Search and Select...',
    'LBL_SEARCH_SELECT_MODULE' => 'Select {{module}}...',
    'LBL_DETAILVIEW' => 'Detail View',
    'LBL_LISTVIEW' => 'List View',
    'LBL_EDITVIEW' => 'Edit View',
    'LBL_SEARCHFORM' => 'Search Form',
    'LBL_SAVED_SEARCH_ERROR' => 'Please provide a name for this view.',
    'LBL_DISPLAY_LOG' => 'Display Log',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Location: ',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Description: ',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'starting',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'Click OK to view this Call or click Cancel to dismiss this message.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'Click OK to view this Meeting or click Cancel to dismiss this message.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'No results found.',
    'MSG_LIST_VIEW_NO_RESULTS' => 'No results found for <item1>',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Create <item1> as a new <item2>',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'You currently have no <item1> records saved. <item2> or <item3> one now.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'You currently have no <item1> records saved. <item2> one now.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'You can create <item1> from a <item2>. <item3> <item2> list.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'Positive',
    'LBL_SENTIMENT_NEUTRAL' => 'Neutral',
    'LBL_SENTIMENT_NEGATIVE' => 'Negative',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'No Metric Tabs Configured',
    'LBL_NO_METRIC_VISIBLE' => 'No Metric Tabs Visible',
    'LBL_MAKE_METRIC_VISIBLE' => 'Choose "organize" to make metric tabs visible',
    'LBL_PLEASE_CONTACT_ADMIN' => 'Please contact your administrator',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'Click here',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Add to My Favorites',
    'LBL_MARK_AS_FAVORITES' => 'Mark as Favorite',
    'LBL_CREATE_CONTACT' => 'Create Contact',
    'LBL_CREATE_NOTE' => 'Create Note',
    'LBL_CREATE_OPPORTUNITY' => 'Create Opportunity',
    'LBL_SCHEDULE_CALL' => 'Log Call',
    'LBL_SCHEDULE_CALL2' => 'Call',
    'LBL_SCHEDULE_MEETING' => 'Schedule Meeting',
    'LBL_SCHEDULE_MEETING2' => 'Meeting',
    'LBL_CREATE_MESSAGE' => 'Create Message',
    'LBL_CREATE_MESSAGE2' => 'Message',
    'LBL_CREATE_TASK' => 'Create Task',
    'LBL_CREATE_TASK2' => 'Task',
    'LBL_REMOVE_FROM_FAVORITES' => 'Remove From My Favorites',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'Note',
    'LBL_DOWNLOAD_ALL' => 'Download All',
    'LBL_DOWNLOAD_ONE' => 'Download',
    'LBL_ATTACHMENTS' => 'Attachments',
    'LBL_ADD_ATTACHMENT' => 'Browse',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Generate Form',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Save Web To Lead Form',

    'LBL_PLEASE_SELECT' => 'Please Select',
    'LBL_REDIRECT_URL' => 'Redirect URL',
    'LBL_RELATED_CAMPAIGN' => 'Related Campaign',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Add All Fields',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Remove All Fields',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Only the following supported image type attachments can be embedded: JPG, PNG.',
    'LBL_REMOVE' => 'Remove',
    'LBL_TRAINING' => 'Support',
    'ERR_DATABASE_CONN_DROPPED' => 'Error executing a query. Possibly, your database dropped the connection. Please refresh this page, you may need to restart you web server.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'Error setting {0} relationship: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'Changed database context to',
    'ERR_MSSQL_WARNING' => 'Warning:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'Failed to Parse vCard format',
    'ERR_VCARD_FILE_MISSING' => 'vcf file is missing',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Warning: field [[field]] does not have a mapped entry in [moduleDir] vardefs.php file',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Error: File [[file]] is missing.  Unable to create because no corresponding HTML file was found.',
    'ERR_CANNOT_FIND_MODULE' => 'Error: Module [module] does not exist.',
    'LBL_ALT_ADDRESS' => 'Other Address:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Error: There are an unequal number of arguments for the \'key\' and \'copy\' elements in the displayParams array.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Missing index in displayParams Array for: ',

    'LBL_DASHLET' => 'Dashlet',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filters',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Only My Items',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Title',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Rows display limit',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'Relate to current record',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'Linked field',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'Freeze First Column',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'Are you sure you want to remove the Sugar Dashlet?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'Are you sure you want to remove the row?',
    'LBL_MAXIMUM_OF' => 'Maximum of ',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => ' columns can be displayed.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'Dashboard',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'My Dashboard',
    'LBL_COLLAPSE_ALL' => 'Collapse All',
    'LBL_EXPAND_ALL' => 'Expand All',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'Edit',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'View Report',
    'LBL_DASHLET_REFRESH_LABEL' => 'Refresh',
    'LBL_DASHLET_REMOVE_LABEL' => 'Remove',
    'LBL_DASHLET_DROP_HERE' => 'Drop here',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'Close',
    'LBL_DASHLET_MAXIMIZE' => 'Open',
    'LBL_DASHLET_CONFIGURE' => 'Configure',
    'LBL_DASHLET_TOGGLE' => 'Open/Close',
    'LBL_SIDEPANE_TOGGLE' => 'Open/Close Side Pane',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'Restore Default Dashlets',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'No Dashboard Configured',
    'LBL_CREATE_DASHBOARD_LINK' => 'Create Dashboard',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'Help',
    'LBL_HELPLET_TOGGLE' => 'Open/Close',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'Modules',
    'LBL_FACET_MODIFIED_BY_ME' => 'Modified by Me',
    'LBL_FACET_CREATED_BY_ME' => 'Created by Me',
    'LBL_FACET_MY_FAVORITES' => 'My Favorites',
    'LBL_FACET_ASSIGNED_TO_ME' => 'Assigned to Me',
    'LBL_FACET_NO_DATA' => 'No data for this facet.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'List View',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'Lists records from a particular module according to criteria you define.',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'Console List View',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'Lists records from a particular module that are related to the record you are viewing in the console.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'Record View Dashlet',
    'LBL_RELATED_RECORDS' => 'Related {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'Displays a record and optionally related records in tabs.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'Base Record Type',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'This {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'Tabs',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'Basic Layout Preview',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'Warning, only {{numWord}} ({{num}}) modules may be displayed in tabs. ' .
        'Please remove one or more modules before adding any others.',
    'LBL_SIX' => 'six', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'Comment Log',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'Displays comments for a record',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'No comments available',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'Add',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'Add comment',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'View All',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'Data not available. You do not have permission to access these modules.' .
    " \nPlease update or remove this dashlet.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'My {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'No record selected for display',
    'LBL_CONTENT_SEARCH_DASHLET' => 'Content Search Dashlet',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'What can we help you with today, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'Would you like to create a case?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'Opportunity Metrics',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'Opportunity Metrics for Related Account.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'Product Catalog Quick Picks',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'Lists Recently used items and products saved as Favorites',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'Recently Used',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'Favorites',

    'LBL_DASHBOARD_CREATE' => 'Create Dashboard',
    'LBL_DASHBOARD_DUPLICATE' => 'Duplicate Dashboard',
    'LBL_DASHBOARD_DELETE' => 'Delete Dashboard',
    'LBL_PIN_TO_TOP' => 'Pin to Top',
    'LBL_PIN_TO_BOTTOM' => 'Pin to Bottom',
    'LBL_MANAGE_DASHBOARDS' => 'Manage Dashboards',

    'LBL_DASHBOARD_CONFIG' => 'Dashboard Configuration',
    'LBL_LIST_VIEW__NAME' => 'List View',
    'LBL_PIPELINE_VIEW_NAME' => 'Tile View',
    'LBL_PIPELINE_VIEW_BTN' => 'Tile View',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} by {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'Tile View is not enabled',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'No records were found at this time.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'Case Summary',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'Timeline',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'Notes & Attachments',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'Notes & Attachments belongs to the record',
    'LBL_DASHLET_PIPLINE_NAME' => 'Pipeline',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'Recent Tweets - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'No saved dashboards',

    'LBL_DNB_AND' => 'and',
    'LBL_DNB_PRIM_NAME_DESC' => 'Text recording a name of this organization',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'Reply',
    'LBL_TWITTER_RETWEET' => 'Retweet',
    'LBL_TWITTER_FAVORITE' => 'Favorite',
    'LBL_TWITTER_FOLLOW' => 'Follow',
    'LBL_TWITTER_DESCRIPTION' => 'See matching twitter user\'s bio and tweets, retweet, and reply to tweets',
    'LBL_TWITTER_ID' => 'Twitter ID',
    'LBL_TWITTER_DISPLAY_ROWS' => 'Display Rows',
    'LBL_TWITTER_MY_ACCOUNT' => 'My Account',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Source Tweet:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'Learning Resources',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'Training & Certification',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub Community',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'Documentation & Support',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters Marketplace',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'Sales by Country',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'Displays the sales chart by country map.',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'Knowledge Base Categories & Published Articles',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'Knowledge Base Search',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'Displays a searchable tree view of published knowledge base articles and categories.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'Published Articles in Other Languages',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'Most Useful Published Knowledge Base Articles',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'Displays the most liked and viewed knowledge base articles',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} filtered by {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'Usefulness for Articles',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'Add Page',
    'LBL_LOADING_PAGE' => 'Loading page, please wait...',
    'LBL_SEARCH_RESULTS' => 'Search Results',
    'LBL_SEARCH_RESULTS_FOR' => 'Search Results for: ',
    'LBL_SEARCH_HELP_TITLE' => 'Search Tips',
    'LBL_SEARCH_RESULTS_FOUND' => 'Search Results Found',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'My Pipeline',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "My Team's Pipeline",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'Sales Pipeline Chart',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'Displays current pipeline chart.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'No Image',

    'LBL_MODULE' => 'Module',
    'LBL_RELATIONSHIP' => 'Relationship',
    'LBL_SINGULAR_LABEL' => 'Singular Label',
    'LBL_PLURAL_LABEL' => 'Plural Label',
    'LBL_MODULE_DISPLAY' => 'Display',
    'LBL_MODULE_DISPLAY_TYPE' => 'Display Type',
    'LBL_MODULE_ICON' => 'Icon',
    'LBL_MODULE_COLOR' => 'Module Background Color',
    'LBL_LANGUAGE_SELECTOR' => 'Language',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'Module Settings',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'Module settings have been saved.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Copy address from left:',
    'LBL_SAVE_AND_CONTINUE' => 'Save and Continue',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Multiselect controls</strong></p><ul><li>Click on the values to select an attribute.</li><li>Ctrl-click&nbsp;to&nbsp;select multiple. Mac users use CMD-click.</li><li>To select all values between two attributes,&nbsp; click first value&nbsp;and then shift-click last value.</li></ul><p><strong>Advanced Search & Layout Options</strong><br><br>Using the <b>Saved Search & Layout</b> option, you can save a set of search parameters and/or a custom List View layout in order to quickly obtain the desired search results in the future. You can save an unlimited number of custom searches and layouts. All saved searches appear by name in the Saved Searches list, with the last loaded saved search appearing at the top of the list.<br><br>To customize the List View layout, use the Hide Columns and Display Columns boxes to select which fields to display in the search results. For example, you can view or hide details such as the record name, and assigned user, and assigned team in the search results. To add a column to List View, select the field from the Hide Columns list and use the left arrow to move it to the Display Columns list. To remove a column from List View, select it from the Display Columns list and use the right arrow to move it to the Hide Columns list.<br><br>If you save layout settings, you will be able to load them at any time to view the search results in the custom layout.<br><br>To save and update a search and/or layout:<ol><li>Enter a name for the search results in the <b>Save this search as</b> field and click <b>Save</b>.The name now displays in the Saved Searches list adjacent to the <b>Clear</b> button.</li><li>To view a saved search, select it from the Saved Searches list. The search results are displayed in the List View.</li><li>To update the properties of a saved search, select the saved search from the list, enter the new search criteria and/or layout options in the Advanced Search area, and click <b>Update</b> next to <b>Modify Current Search</b>.</li><li>To delete a saved search, select it in the Saved Searches list, click <b>Delete</b> next to <b>Modify Current Search</b>, and then click <b>OK</b> to confirm the deletion.</li></ol><p><strong>Tips</strong><br><br>By using the % as a wildcard operator you can make your search more broad.  For example instead of just searching for results that equal "Apples" you could change your search to "Apples%" which would match all results that start with the word Apples but could contain other characters as well.</p>',

    //resource management
    'ERR_QUERY_LIMIT' => 'Error: Query limit of $limit reached for $module module.',
    'ERROR_NOTIFY_OVERRIDE' => 'Error: ResourceObserver->notify() needs to be overridden.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'Error: Unable to create monitor because metadata file is empty or file does not exist.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'Error: There is no monitor configured for requested name',
    'ERR_UNDEFINED_METRIC' => 'Error: Unable to set value for undefined metric',
    'ERR_STORE_FILE_MISSING' => 'Error: Unable to find Store implementation file',

    'LBL_MONITOR_ID' => 'Monitor Id',
    'LBL_TEAM_ID' => 'Team ID',
    'LBL_SELECT_MODULE' => 'Select a module:',
    'LBL_USER_ID' => 'User Id',
    'LBL_MODULE_NAME' => 'Module Name',
    'LBL_MODULE_ALL' => 'All',
    'LBL_ITEM_ID' => 'Item Id',
    'LBL_ITEM_SUMMARY' => 'Item Summary',
    'LBL_ACTION' => 'Action',
    'LBL_SESSION_ID' => 'Session Id',
    'LBL_BREADCRUMBSTACK_CREATED' => 'BreadCrumbStack created for user id {0}',
    'LBL_VISIBLE' => 'Record Visible',
    'LBL_DATE_LAST_ACTION' => 'Date of Last Action',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL Text',
    'LBL_QUERY_HASH' => 'SQL Hash',
    'LBL_SEC_TOTAL' => 'Total Seconds',
    'LBL_SEC_AVG' => 'Average Seconds',
    'LBL_RUN_COUNT' => 'Query Count',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'Client IP Address',
    'LBL_DATE_START' => 'Date Start',
    'LBL_ACTIVE' => 'Session Active',
    'LBL_ROUNDTRIPS' => 'Action Count',
    'LBL_SECONDS' => 'Seconds Active',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'Database Roundtrips',
    'LBL_FILES_OPENED' => 'Files Accessed',
    'LBL_MEMORY_USAGE' => 'Memory Usage (bytes)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'Loading Twitter Connector...',
    'LBL_TWITTER_DATA_EMPTY' => 'No data availlable from Twitter',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Sugar Plug-in for Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Integrate Sugar e-mail and calendar information with Microsoft Outlook.',
    'LBL_PLUGIN_WORD_NAME' => 'Sugar Plug-in for Word',
    'LBL_PLUGIN_WORD_DESC' => 'Automatically populate information from SugarCRM into form letters, direct mail and other Microsoft documents.',
    'LBL_PLUGIN_EXCEL_NAME' => 'Sugar Plug-in for Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'Integrate Sugar with spreadsheets for better analysis of key metrics.',
    'LBL_PLUGINS_TITLE' => 'Sugar Plug-ins for Microsoft Office<sup>TM</sup>',
    'LBL_PLUGINS_DESC' => 'Read about the plug-in features within the <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">Plug-ins Documentation</a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Sugar Plug-ins for Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'Sugar Plug-in For Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'Integrate Sugar with Lotus Notes.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'is not before',
    'MSG_IS_MORE_THAN' => 'is more than',
    'MSG_IS_LESS_THAN' => 'is less than',
    'MSG_SHOULD_BE' => 'should be',
    'MSG_OR_GREATER' => 'or greater',
    'MSG_EXCEEDS_MAXLEN' => 'exceeds the max length specified ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Welcome to Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal is a framework which provides real-time view of cases, bugs & newsletters etc to customers. This is an external facing interface to Sugar that can be deployed within any website.  Stay tuned for more customer self service features like Project Management and Forums in our future releases.',
    'LBL_LIST' => 'List',
    'LBL_CREATE_CASE' => 'Create Case',
    'LBL_CREATE_BUG' => 'Create Bug',
    'LBL_NO_RECORDS_FOUND' => '- 0 Records Found -',

    'DATA_TYPE_DUE' => 'Due:',
    'DATA_TYPE_START' => 'Start:',
    'DATA_TYPE_SENT' => 'Sent:',
    'DATA_TYPE_MODIFIED' => 'Modified:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Count',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'object image',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'Select Date',

    'LBL_VALIDATE_RANGE' => 'is not within the valid range',
    'LBL_VALIDATE_URL' => 'is not a valid URL',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'All',

    'LBL_OPERATOR_IN_TEXT' => 'is one of the following:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'is not one of the following:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Error: The Array count of the bean parameter does not match the Array count of the results.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Error: Missing mapping entry for module.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Error: Unable to retrieve data for {0} Connector.  The service may currently be inaccessible or the configuration settings may be invalid.  Connector error message: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'Unable to retrieve data.  The service may currently be inaccessible or the configuration settings may be invalid.',
    'LBL_CONNECT_TWITTER' => 'Connect to Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'Can not find valid timeline for Twitter ID: ',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'Configure Twitter Connector',
    'LBL_CONNECT_TEST_FAIL' => 'Error: The connector configuration settings may be invalid. Please contact your administrator.',
    'LBL_CONFIGURE_TWITTER' => 'Contact your administrator to configure Twitter',
    'LBL_MERGE_CONNECTORS' => 'Get Data',
    'LBL_NO_DATA_AVAILABLE' => 'No data available.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'Are you sure you want to disable connector integration for this module?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Failed to connect to Elastic server',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'The Global team cannot be deleted.',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'This private team [{0}] cannot be deleted until the user [{1}] is deleted.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'You either have Abobe Flash turned off or are using an older version of the Adobe Flash Player. To get the latest version of the Flash Player, <a href="http://www.adobe.com/go/getflashplayer/">click here</a>.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'Name',
    'LBL_COLLECTION_PRIMARY' => 'Primary',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'Empty required field',
    'LBL_COLLECTION_EXACT' => 'Exact',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'For optimal experience using IIS/FastCGI sapi, set fastcgi.logging to 0 in your php.ini file.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'Assigned to',
    'LBL_DESCRIPTION' => 'Description',
    'LBL_PRIMARY_CONTACT_NAME' => 'Primary Contact',
    'LBL_PRIMARY_CONTACT_ID' => 'Primary Contact ID',

    'LBL_NONE' => '-none-',
    'LBL_YESTERDAY' => 'yesterday',
    'LBL_TODAY' => 'today',
    'LBL_TOMORROW' => 'tomorrow',
    'LBL_NEXT_WEEK' => 'next week',
    'LBL_NEXT_MONDAY' => 'next monday',
    'LBL_NEXT_FRIDAY' => 'next friday',
    'LBL_TWO_WEEKS' => 'two weeks',
    'LBL_NEXT_MONTH' => 'next month',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'first day of next month',
    'LBL_THREE_MONTHS' => 'three months',
    'LBL_SIXMONTHS' => 'six months',
    'LBL_NEXT_YEAR' => 'next year',
    'LBL_FILTERED' => 'Filtered',

    //Datetimecombo fields
    'LBL_HOURS' => 'Hours',
    'LBL_MINUTES' => 'Minutes',
    'LBL_MERIDIEM' => 'Meridiem',
    'LBL_DATE' => 'Date',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Auto-Refresh',

    'LBL_DURATION_DAY' => 'day',
    'LBL_DURATION_HOUR' => 'hour',
    'LBL_DURATION_MINUTE' => 'minute',
    'LBL_DURATION_DAYS' => 'days',
    'LBL_DURATION_HOURS' => 'hours',
    'LBL_DURATION_MINUTES' => 'minutes',
    'LBL_DURATION_SECONDS' => 'seconds',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'Choose Month',
    'LBL_ENTER_YEAR' => 'Enter Year',
    'LBL_ENTER_VALID_YEAR' => 'Please enter a valid year',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'Please enter a numeric U.S. phone number, including area code.',
    'LBL_CCP_NOT_INITIATED' => 'Attempting to Dial using CCP while Agent has not logged in.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'Unable to initiate call via CCP.',
    'LBL_CCP_DIALING_ERROR' => 'This call cannot be completed as dialed.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'Please close any chat sessions in SugarLive before making an outbound call.',

    //File write error label
    'ERR_FILE_WRITE' => 'Error: Could not write file {0}.  Please check system and web server permissions.',
    'ERR_FILE_NOT_FOUND' => 'Error: Could not load file {0}.  Please check system and web server permissions.',

    'LBL_AND' => 'And',
    'LBL_BEFORE' => 'Before',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'Upload From Your Computer',
    'LBL_SEARCH_EXTERNAL_API' => 'File on External Source',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'Upload to external source',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'Link from external source',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'Security',
    'LBL_SHARE_PRIVATE' => 'Private',
    'LBL_SHARE_COMPANY' => 'Company',
    'LBL_SHARE_LINKABLE' => 'Linkable',
    'LBL_SHARE_PUBLIC' => 'Public',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS Feed',
    'LBL_RSS_RECORDS_FOUND' => 'record(s) found',
    'ERR_RSS_INVALID_INPUT' => 'RSS is not a valid input_type',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS is not a valid response_type for this method',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs does not support the file format you provided.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'Empty',
    'LBL_IS_EMPTY' => 'Is empty',
    'LBL_IS_NOT_EMPTY' => 'Is not empty',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '
"This is a sample import file which provides an example of the expected contents of a file that is ready for import."
"The file is a comma-delimited .csv file, using double-quotes as the field qualifier."

"The header row is the top-most row in the file and contains the field labels as you would see them in the application."
"These labels are used for mapping the data in the file to the fields in the application."

"Notes: The database names could also be used in the header row. This is useful when you are using phpMyAdmin or another database tool to provide an exported list of data to import."
"The column order is not critical as the import process matches the data to the appropriate fields based on the header row."


"To use this file as a template, do the following:"
"1. Remove the sample rows of data"
"2. Remove the help text that you are reading right now"
"3. Input your own data into the appropriate rows and columns"
"4. Save the file to a known location on your system"
"5. Click on the Import option from the Actions menu in the application and choose the file to upload"
   ',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'Assigned User ID',
    'LBL_EXPORT_CREATED_BY' => 'Created By ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'Modified By ID',
    'LBL_EXPORT_REPORTS_TO_ID' => 'Reports To ID',
    'LBL_EXPORT_TEAM_ID' => 'Team ID',
    'LBL_EXPORT_TEAM_SET_ID' => 'Team Set ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Assigned User',
    'LBL_EXPORT_FULL_NAME' => 'Full Name',
    'LBL_EXPORT_TEAM_NAME' => 'Teams',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navigating... ',

    'LBL_PENDING_NOTIFICATIONS' => 'Notifications',
    'LBL_ALT_ADD_TEAM_ROW' => 'Add new team row',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'Remove team',
    'LBL_ALT_SPOT_SEARCH' => 'Spot Search',
    'LBL_ALT_NOT_SORTED' => 'Not Sorted',
    'LBL_ALT_SORT_DESC' => 'Sorted Descending',
    'LBL_ALT_SORT_ASC' => 'Sorted Ascending',
    'LBL_ALT_SORTABLE' => 'Sortable',
    'LBL_ALT_NOT_SORTABLE' => 'Not Sortable',
    'LBL_ALT_SORT' => 'Sort',
    'LBL_ALT_SHOW_OPTIONS' => 'Show Options',
    'LBL_ALT_HIDE_OPTIONS' => 'Hide Options',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'Move selected entry to the list on the left',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Move selected entry to the list on the right',
    'LBL_ALT_MOVE_COLUMN_UP' => 'Move selected entry up in the displayed list order',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'Move selected entry down in the displayed list order',
    'LBL_ALT_INFO' => 'Information',
    'MSG_DUPLICATE' => 'The {0} record you are about to create might be a duplicate of an {0} record that already exists. {1} records containing similar names are listed below.<br>Click Create {1} to continue creating this new {0}, or select an existing {0} listed below.',
    'MSG_SHOW_DUPLICATES' => 'The {0} record you are about to create might be a duplicate of a {0} record that already exists. {1} records containing similar names are listed below.  Click Save to continue creating this new {0}, or click Cancel to return to the module without creating the {0}.',
    'LBL_EMAIL_TITLE' => 'email address',
    'LBL_EMAIL_OPT_TITLE' => 'opted out email address',
    'LBL_EMAIL_INV_TITLE' => 'invalid email address',
    'LBL_EMAIL_PRIM_TITLE' => 'primary email address',
    'LBL_SELECT_ALL_TITLE' => 'Select all',
    'LBL_SELECT_THIS_ROW_TITLE' => 'Select this row',
    'LBL_TEAM_SELECTED_TITLE' => 'Team Selected ',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Select to make this team primary',
    'LBL_TEAM_TBSELECTED_TITLE' => 'Team marked as Team-Based Selected ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'Mark this team as Team-Based Selected',
    'LBL_SEARCH_AND_SELECT' => 'Search and Select {{module}}',
    'TPL_SEARCH_AND_ADD' => 'Search and Add {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'ERROR: There was an error during upload. Error code: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'ERROR: There was an error during upload. Error code: {0} - {1}. The upload_maxsize is {2} ',
    'UPLOAD_ERROR_HOME_TEXT' => 'ERROR: There was an error during your upload, please contact an administrator for help.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'Size of Upload ({0} bytes) Exceeded Allowed Maximum: {1} bytes',
    'UPLOAD_REQUEST_ERROR' => 'An error has occured. Please refresh your page and try again.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => 'Edit',
    'LBL_ADD_BUTTON_LABEL' => 'Add',
    'LBL_EDIT_BUTTON_TITLE' => 'Edit',
    'LBL_REFRESH_BUTTON_LABEL' => 'Refresh',
    'LBL_REFRESH_BUTTON_TITLE' => 'Refresh',
    'LBL_DUPLICATE_BUTTON_KEY' => 'u',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Copy',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Copy',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'Report Schedules',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'Report Schedules',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'Report Details',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'Report Details',
    'LBL_DELETE_BUTTON_KEY' => 'd',
    'LBL_DELETE_BUTTON_LABEL' => 'Delete',
    'LBL_DELETE_BUTTON_TITLE' => 'Delete',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => 'Save',
    'LBL_SAVE_BUTTON_TITLE' => 'Save',
    'LBL_CANCEL_BUTTON_KEY' => 'l',
    'LBL_CANCEL_BUTTON_LABEL' => 'Cancel',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'to stop.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'to stay on page.',
    'LBL_CANCEL_BUTTON_TITLE' => 'Cancel',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'Share',
    'LBL_SHARE_BUTTON_TITLE' => 'Share',
    'LBL_START_BUTTON_LABEL' => 'Start',
    'LBL_START_BUTTON_TITLE' => 'Start',
    'LBL_FINISH_BUTTON_LABEL' => 'Finish',
    'LBL_FINISH_BUTTON_TITLE' => 'Finish',
    'LBL_CONFIRM_BUTTON_LABEL' => 'Confirm',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'to continue.',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'to leave page and discard changes.',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Keyboard Shortcuts',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Form Functionality - Alt+</strong><br/> I = ed<b>I</b>t (detailview)<br/> U = d<b>U</b>plicate (detailview)<br/> D = <b>D</b>elete (detailview)<br/> R = Sha<b>R</b>e (detailview)<br/> A = s<b>A</b>ve (editview)<br/> L = cance<b>L</b> (editview) <br/><br/></p><p><strong>Search and Navigation  - Alt+</strong><br/> 7 = first input on Edit form<br/> 8 = Advanced Search link<br/> 9 = First Search Form input<br/> 0 = Unified search input<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'Escalate',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'Share',
    'TPL_RECORD_SHARE_SUBJECT' => 'Shared {{module}} {{name}} from {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'Please checkout {{module}} {{name}} from {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'connector array in {0} been defined incorrectly or is empty and could not be used.',
    'LBL_PDF_VIEW' => 'Download PDF',
    'LBL_PDF_EMAIL' => 'Email PDF',

    'ERR_SUHOSIN' => 'Upload stream is blocked by Suhosin, please add &quot;upload&quot; to suhosin.executor.include.whitelist (See sugarcrm.log for more information)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'right now',
    'LBL_TIME_AGO_SECONDS' => 'less than a minute ago',
    'LBL_TIME_AGO_MINUTE' => 'about 1 minute ago',
    'LBL_TIME_AGO_MINUTES' => '{{this}} minutes ago',
    'LBL_TIME_AGO_HOUR' => 'about an hour ago',
    'LBL_TIME_AGO_HOURS' => '{{this}} hours ago',
    'LBL_TIME_AGO_DAY' => 'yesterday',
    'LBL_TIME_AGO_DAYS' => '{{this}} days ago',
    'LBL_TIME_AGO_YEAR' => 'over a year ago',
    'LBL_TIME_UNTIL_SECONDS' => 'in less than a minute',
    'LBL_TIME_UNTIL_MINUTE' => 'in about 1 minute',
    'LBL_TIME_UNTIL_MINUTES' => 'in {{this}} minutes',
    'LBL_TIME_UNTIL_HOUR' => 'in about an hour',
    'LBL_TIME_UNTIL_HOURS' => 'in {{this}} hours',
    'LBL_TIME_UNTIL_DAY' => 'tomorrow',
    'LBL_TIME_UNTIL_DAYS' => 'in {{this}} days',
    'LBL_TIME_UNTIL_YEAR' => 'in over a year',
    'LBL_TIME_RELATIVE' => 'Posted {{relativetime}} on {{date}} at {{time}}',
    'LBL_LAST_TOUCHED' => 'Last touched {{relativetime}} on {{date}} at {{time}}',
    'LBL_LAST_COMMIT' => 'Last Commitment: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'No data available.',
    'LBL_DETAILVIEW_NO_RECORDS' => 'This record could not be rendered at this time.',
    'LBL_REFINE_LIST' => 'Refine list',
    'LBL_SEARCH_BY' => 'Search by',
    'LBL_PREVIEW' => 'Preview',
    'LBL_COLUMNS' => 'Columns',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'Preview disabled: No data available',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'Preview disabled: No access to record',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'Preview disabled: No data available',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'Preview disabled: In view as current record',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'Preview disabled: Record removed or no access to record',
    'LBL_PREVIEW_PREVIOUS' => 'Preview previous',
    'LBL_PREVIEW_NEXT' => 'Preview next',
    'LBL_PREVIEW_CLOSE' => 'Preview close',
    'LBL_STREAM_NO_RECORDS' => 'This record has no notes at this time. Please add a note by clicking on the add note link.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} duplicates found.',
    'LBL_NO_DUPLICATES_FOUND' => 'No duplicates found.',
    'LBL_RESET_DEFAULT_VIEW' => 'Reset default view',
    'LBL_RESET_DEFAULT_WIDTHS' => 'Reset default widths',
    'LBL_TIMEZONE_UPDATED' => 'Sugar has updated your user profile timezone to match your browser timezone',
    'LBL_SUCCESS' => 'Success',
    'LBL_ERROR' => 'Error',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'Merge Duplicates',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'Do you want to proceed? Cancel to abort. Confim to delete records.',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'This action will delete following record(s):',
    'LBL_MERGE' => 'Merge',
    'TPL_MERGING_RECORDS' => 'Merging {{mergeCount}} Records',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'Invalid number of records passed. The valid range is from {{minRecords}} to {{maxRecords}} records.',
    'LBL_MERGE_NO_ACCESS' =>
        'You have no access to perform this action. At least one record must be editable.',
    'LBL_MERGE_LOCKED' => 'Some of the records selected for merge contain fields that are locked for editing by a process and cannot be merged at this time.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'All changes will be discarded when you switch to a new primary record. Are you sure you want to switch?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'Merge Related Records',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'Merged: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'Merge Related {{objectName}} failed. Initiating new attempt ({{num}} of {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'Merge Related {{objectName}} failed.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'Merge Related Records incomplete. Some records remain unmerged.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'Some related records did not merge properly. Cancel to abort. Confirm to continue merge.',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'All related records will be moved to the Primary record.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'Are you sure you want to remove this record from merge?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'Remove record from merge',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'Invalid number of records passed. The valid range is from 1 to {{maxRecords}} records.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'The username/password combination provided is incorrect, please try again.',
    'LBL_INVALID_CREDS_TITLE' => 'Invalid Credentials',
    'LBL_INVALID_GRANT' => 'Your token is invalid or has expired. Please login again.',
    'LBL_INVALID_GRANT_TITLE' => 'Token Expired',
    'LBL_AUTH_FAILED' => 'Client authentication failed.',
    'LBL_AUTH_FAILED_TITLE' => 'Invalid Client',
    'LBL_INVALID_REQUEST' => 'The request made is invalid or malformed. Please contact technical support.',
    'LBL_INVALID_REQUEST_TITLE' => 'Invalid Request',
    'LBL_REQUEST_TIMEOUT' => 'The server is not responding. Check your internet connection.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'Request timeout: ',
    'LBL_UNAUTHORIZED' => 'We\'re sorry, but it appears you are unauthorized to access this resource.',
    'LBL_UNAUTHORIZED_TITLE' => 'Unauthorized',
    'LBL_RESOURCE_UNAVAILABLE' => 'Resource not available.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'Forbidden',
    'LBL_METHOD_NOT_ALLOWED' => 'HTTP method not allowed for this resource. Please contact technical support.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'Method Not Allowed',
    'LBL_PRECONDITION_MISSING' => 'Request failure, or, missing/invalid parameter. Please contact technical support',
    'LBL_PRECONDITION_MISSING_TITLE' => 'Error: ',
    'LBL_INVALID_412_RESPONSE' => 'A request is failing that makes the application unusable. Please contact technical support.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'Not allowed to edit field {0} in module: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'Not allowed to perform action "{0}" on this record',
    'LBL_LOGIN_BUTTON_LABEL' => 'Log In',
    'LBL_ACTIVITY_VIEW_TOUR' => 'Activity View Tour',
    'LNK_TOUR' => 'Tour',
    'LNK_MOBILE' => 'Mobile',
    'LBL_FEEDBACK' => 'Feedback',
    'LBL_SUPPORT' => 'Support',
    'LBL_LANGUAGE' => 'Language / Sprache / Idioma',
    'LBL_LOADING_LANGUAGE' => 'Loading language pack',
    'LBL_UPLOADING' => 'Uploading',
    'LBL_UPLOADING_DOTS' => 'Uploading...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'Are you sure you want to delete this image?',
    'LBL_FILE_DELETE_CONFIRM' => 'Are you sure you want to delete this file? This cannot be undone.',
    'LBL_FILE_DELETED' => 'File was successfully deleted',

    //theme roller
    'LBL_PORTAL_THEME' => 'Portal Theme',
    'LBL_THEME_PREVIEW' => 'Portal Theme Preview',
    'LBL_LOADING_PREVIEW' => 'Loading Preview',
    'LBL_RESET' => 'Reset',
    'LBL_COLORS' => 'Colors',
    'BorderColor' => 'Border Color',
    'NavigationBar' => 'Navigation Bar',
    'PrimaryButton' => 'Primary Button',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'Save & Deploy',
    'LBL_RESET_THEME_LNK' => 'Restore Default Theme',
    'LBL_RESET_THEME_MODAL_INFO' => 'Are you sure you want to discard your theme customizations and replace with default theme?',
    'LBL_RESET_THEME_PROCESS' => 'Restoring default theme...',
    'LBL_SAVE_THEME_PROCESS' => 'Saving theme...',

    // image loader
    'LBL_SELECT_PHOTO' => 'Select a Photo',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Enhanced forecasting functionality in Sugar',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="sicon sicon-check">Setup your forecasting parameters</li><li class="sicon sicon-check">Easily track projected sales and pipeline health</li><li class="sicon sicon-check">Forecast based on projected sales from your sales team</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'Setup your forecasting parameters',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="sicon sicon-check">Choose fiscal year start date</li><li class="sicon sicon-check">Setup Time Periods to be either yearly or quarterly</li><li class="sicon sicon-check">Decide how many past and future Time Periods need to be visible in the worksheet</li><li class="sicon sicon-check">Select Forecast ranges to tag Opportunities as Include, Exclude or Upside</li><li class="sicon sicon-check">Select Forecast scenarios to identify Likely, Best and Worst forecast</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'Manage your Sales Team\'s Projected Sales',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="sicon sicon-check">Select the Time Period to review the Forecast</li><li class="sicon sicon-check">View your sales team members’ worksheets and provide adjusted forecasts</li><li class="sicon sicon-check">See alert on worksheet when a sales team member commits a new Forecast</li><li class="sicon sicon-check">Save the Forecast worksheet as a draft version or commit the Forecast to your manager</li><li class="sicon sicon-check">View history of previous commits</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'Manage your Sales Team\'s Projected Sales',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="sicon sicon-check">View Pareto chart for pipeline analysis across all your sales team members\' forecasts</li><li class="sicon sicon-check">Choose to visualize projected sales by Likely, Best or Worst forecast</li><li class="sicon sicon-check">View projected sales and how close you are to make your team Quota</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'Manage your own Projected Sales',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="sicon sicon-check">Select the Time Period for your Forecast</li><li class="sicon sicon-check">Review and in-line edit amounts and Win Probability for a quick what-if analysis</li><li class="sicon sicon-check">Save the Forecast worksheet as a draft version or commit the Forecast to your manager</li><li class="sicon sicon-check">View history of previous commits</li><li class="sicon sicon-check">Commit Forecast to Manager and view History of previous Commits</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'Manage your own Projected Sales',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="sicon sicon-check">View Pareto chart for pipeline analysis over time for your Opportunities</li><li class="sicon sicon-check">Choose to visualize pipeline distribution by Sales Stage or Win Probability</li><li class="sicon sicon-check">View projected sales and how close you are to make your assigned Quota</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'What\'s New in Sugar',
    'LBL_TOUR_WATCH' => 'Watch What\'s New in Sugar',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="sicon sicon-check">Improved look and feel – now with a new modern theme.</li><li class="sicon sicon-check">Enhanced Forecasts module – now with intuitive user interface and new data visualization</li></ul>',
    'LBL_TOUR_VISIT' => 'For more information please visit our application',
    'LBL_TOUR_DONE' => 'You\'re Done!',
    'LBL_TOUR_REFERENCE_1' => 'You can always reference our',
    'LBL_TOUR_REFERENCE_2' => 'through the "Support" link under the profile menu.',
    'LNK_TOUR_DOCUMENTATION' => 'documentation',
    'LBL_TOUR_CALENDAR_URL_1' => 'Do you share your SugarCRM calendar with 3rd party applications, such as Microsoft Outlook or Exchange? If so, you have a new URL. This new, more secure URL includes a personal key which will prevent unauthorized publishing of your calendar.',
    'LBL_TOUR_CALENDAR_URL_2' => 'Retrieve your new shared calendar URL.',
    'LBL_TOUR_CUBE' => 'Access Dashboards and Activity Stream',
    'LBL_TOUR_NAV_BAR' => 'Access all modules in the Navigation menu and take actions',
    'LBL_TOUR_NOTIFICATIONS' => 'Click to see Notifications',
    'LBL_TOUR_SEARCH' => 'Select one or more modules and search',
    'LBL_TOUR_AVATAR' => 'Get more details about the application or Logout',
    'LBL_TOUR_ADD' => 'Create a record from here',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'Click to close or open the intelligence pane',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'Choose to see activities or list of records',
    'LBL_TOUR_LIST_FILTER1' => 'Filter bar enables search for this module',
    'LBL_TOUR_LIST_FILTER2' => 'Choose predefined filter or create new',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'Type here to search based on name',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'Choose to edit the row or preview details',
    'LBL_TOUR_RECORD_ACTIONS' => 'Take actions on the record',
    'LBL_TOUR_RECORD_SUBPANEL' => 'Click on header to expand and collapse subpanel',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'Record name can be updated in place',
    'LBL_TOUR_RECORD_STATUS' => 'Find record level status here',
    'LBL_TOUR_RECORD_SHOWMORE' => 'Click to see more data for the record',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'Choose to see activities or related records',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'Click to edit each field inline',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'Create new groups of Dashlets',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'Assign a name to the group of Dashlets',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'Choose to remove Dashlet or to change settings',
    'LBL_TOUR_INTRO' =>'<h4>Welcome to Sugar</h4> We\'d like to walk you through some of the features.  Use the < and > arrows on the bottom of the screen to take a tour.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="sicon sicon-lg sicon-wand-lg"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">What\'s New</a><p class="details">Find out the key changes between releases.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="sicon sicon-lg sicon-knowledgebase-xl"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Find out more about Sugar</a><p class="details">A robust library of eLearning, live and virtual classroom training, webinars and video tutorials.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="sicon sicon-lg sicon-help"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">Get Support</a><p class="details">Need help, have a issue or want to suggest how to make Sugar better?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'View a list of records and take actions records.',
    'LBL_TOUR_RECORD_INTRO' => 'View details on this record and see all data related to it.',
    'LBL_TOUR_FORECAST_INTRO' => 'Manage pipeline and Forecast.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'Choose a Time Period to see the corresponding Forecast',
    'LBL_TOUR_FORECASTS_COMMITS' => 'Click to see previous commits',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'Click to edit data inline',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'Review distance to Quota',
    'LBL_TOUR_FORECASTS_CHART' => 'Review Forecast distribution',
    'LBL_TOUR_TOUR' => 'Access Tour at any time',
    'LBL_TOUR_TAGS_ADD' => 'Click the tags field to add and remove tags',
    'LBL_TOUR_TAGS_DELETE' => 'To delete a tag, use backspace or click the [X] button on each tag',
    'LBL_TOUR_RECORD_SAVE' => 'Once you are ready, click Save',


    'LBL_FUTURE' => 'Future',
    'LBL_REQUIRED_FIELD' => 'Required',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'Quoted Line Item',
    'LBL_DISCOUNT_TOTAL' => 'Discount total',
    'LBL_DISCOUNT_PERCENT' => '% Percent',
    'LBL_DISCOUNT_SELECT' => 'Determines if the discount is a percentage or flat amount',
    'LBL_TAX' => 'Tax',
    'LBL_SHIPPING' => 'Shipping',
    'LBL_GRAND_TOTAL' => 'Grand Total',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'Auto populate billing address from Account profile',
    'LBL_QLI_ADD_GROUP' => 'Add a Group',
    'LBL_QLI_COMMENT' => 'Comment',
    'LBL_SELECT_ACTION' => 'Select Action',
    'LBL_QLI_GROUP_NAME' => 'Group Name',
    'LBL_GROUP_TOTAL' => 'Group Total',
    'LBL_ITEM_NAME' => 'Line Item',
    'LBL_QLI_DELETE' => 'Are you sure you want to delete this line item?',
    'LBL_QLI_COMMENT_DELETE' => 'Are you sure you want to delete this line item comment?',
    'LBL_QLI_GROUP_DELETE' => 'Do you really want to delete group {0}? All items will be moved to default group.',
    'LBL_QLI_GROUP_EMPTY' => 'No Quoted Line Item',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'Optional',
    'LBL_RELATED_MODULE' => 'Related {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'Related {{{this}}}',
    'LBL_CREATE_MODULE' => 'Create {{{this}}}',
    'LBL_EDIT' => 'Edit {{{this}}}',
    'LBL_ASSOC' => 'Link {{{this}}}',
    'LBL_ASSIGN' => 'Select {{{this}}}',
    'LBL_EDIT_RELATED' => 'Edit Related {{{this}}}',
    'LBL_CREATE_RELATED' => 'Create Related {{{this}}}',
    'LBL_ASSOC_EXISTING' => 'Link Existing {{{this}}}',
    'LBL_SEARCH_ALL' => 'Search all {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'Search all records...',
    'LBL_SEARCH_ALL_MODULES' => 'Search all',
    'LBL_OK' => 'OK',
    'LBL_YES' => 'Yes',
    'LBL_NO' => 'No',
    'LBL_SHOW_NUMBERING' => 'Show stage numbering',
    'LBL_HIDE_NUMBERING' => 'Hide stage numbering',
    'LBL_CALL_BUTTON' => 'Call',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'Email',
    'LBL_HONEYPOT' => 'If you are a real person do not fill this out.',
    'LBL_LINK_BUTTON' => 'Link',
    'LBL_UNLINK_BUTTON' => 'Unlink',
    'LBL_MAP_BUTTON' => 'Map',
    'LBL_FILE_BUTTON' => 'File',
    'LBL_URL_BUTTON' => 'Web',
    'LBL_WARNING' => 'Warning',
    'LBL_CONFIRM' => 'Confirm',
    'LBL_CONFIRMATION_POPUP' => 'Confirmation Popup',
    'LBL_NO_ACCESS' => '(No Access)',
    'LBL_NO_ACCESS_LOWER' => 'No access',
    'LBL_NO_FIELD_ACCESS' => 'No Access',
    'LBL_NO_LICENSE_ACCESS' => 'License Required',
    'LBL_VALUE_ERASED' => 'Value Erased',
    'LBL_VALUE_ERASED_TOOLTIP' => 'This information was erased via data privacy request',
    'LBL_CREATE_RELATED_RECORD' => 'Create Related Record',
    'LBL_ASSOC_RELATED_RECORD' => 'Link Existing Record',
    'LBL_CHOOSE_LINK' => 'Choose Link Type',
    'LBL_CHOOSE_PARENT_TYPE' => 'Choose Parent Type',
    'LBL_HOME' => 'Home',
    'ERR_NO_DOCS' => 'No Documents Available',
    'ERR_NO_RECORDS_SELECTED' => 'You haven\'t selected any records.',
    'LBL_DELETING' => 'Deleting...',
    'LBL_UNLINKING' => 'Unlinking...',
    'LBL_UNLINKED' => 'Unlinked',
    'LBL_LEGAL' => 'Legal',
    'LBL_UPCOMING' => 'My Upcoming Events',
    'LBL_RECENTLY_UPDATED' => 'Recently Updated',
    'LBL_NOTES_SUBPANEL_TITLE' => 'Notes',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'Meetings',
    'LBL_TASKS_SUBPANEL_TITLE' => 'Tasks',
    'LBL_CALLS_SUBPANEL_TITLE' => 'Calls',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'Accounts',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'Contacts',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'Emails',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'Shifts',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'Quoted Line Items',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'Shift Exceptions',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'Documents',
    'LBL_ESCALATIONS' => 'Escalations',
    'LBL_ESCALATED' => 'Escalated',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'Escalations',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'Other Related Escalations',
    'LBL_ESCALATIONS' => 'Escalations',
    'LNK_SETTINGS' => 'Settings',
    'LBL_MOBILE_SUPPORT' => 'Support',
    'LBL_MOBILE_SHOW_MORE' => 'Show more...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'Show more...',
    'LBL_MOBILE_NO_RECORDS' => 'No records found',
    'LBL_MOBILE_SEARCH_TEAMS' => 'Search teams...',
    'LBL_MOBILE_SELECT_TEAMS' => 'Select Teams',
    'LBL_MOBILE_WAIT' => 'Please wait...',
    'LBL_MOBILE_LOGING_OUT' => 'Please wait while logging out...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'Re-login',
    'LBL_MOBILE_META_SYNC_FAILED' => 'Unable to sync with server.',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'Unable to sync with server. Retry?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'Privacy, Terms, & Conditions',
    'LBL_MOBILE_APP_VERSION' => 'App Version',
    'LBL_MOBILE_SERVER_VERSION' => 'Server Version',
    'LBL_MOBILE_SERVER_URL' => 'Server URL',
    'LBL_MOBILE_PTR_PULL' => 'Pull down to refresh...',
    'LBL_MOBILE_PTR_RELEASE' => 'Release to refresh...',
    'LBL_MOBILE_EDIT_REL' => 'Edit Relationship',
    'LBL_MOBILE_DESKTOP' => 'Desktop Version',
    'LBL_MOBILE_DELETE_CONFIRM' => 'Are you sure you want to delete this record?',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'Are you sure you want to unlink this record?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'Would you like to log your last Call?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'Choose recepient',
    'LBL_MOBILE_CHOOSE_PHONE' => 'Choose phone number',
    'LBL_MOBILE_CHOOSE_URL' => 'Choose URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'Choose document',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'Choose location',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'No Actions Available',
    'LBL_MOBILE_FEEDBACK' => 'Feedback',
    'LBL_MOBILE_DOC' => 'Document',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'Download started: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'Download completed: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'Uploading file...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'File successfully uploaded',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'Preparing Image...',
    'LBL_CLOSE_SAVE_BUTTON' => 'Close task and save',
    'LBL_LATER' => 'Later',
    'LBL_USE_HTTPS' => 'Use secure connection',
    'LBL_LOADING_FILES' => 'Still loading document list. Please try again later',
    'LBL_NEW_WEB_VERSION' => 'A new version of this application is available. Would you like to update?',
    'LBL_SET_FONTSIZE' => 'Font size',
    'LBL_FONTSIZE_TINY' => 'Tiny',
    'LBL_FONTSIZE_SMALL' => 'Small',
    'LBL_FONTSIZE_NORMAL' => 'Normal (default)',
    'LBL_FONTSIZE_LARGE' => 'Large',
    'LBL_FONTSIZE_LARGER' => 'Larger',
    'LBL_FONTSIZE_HUGE' => 'Huge',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'Extra huge',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "Download failed\r\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'More...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...Less',
    'LBL_OFFLINE_MODE' => 'Offline Mode',
    'LBL_OFFLINE_DELETED' => 'Record not found.',
    'LBL_OFFLINE_DELETED_RELATED' => 'Related record not found. It was probably deleted or unlinked.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'Downloading your assigned, favorited, and followed records for offline access may take some time to complete. A fast connection is recommended. Would you like to proceed?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'Do you want your assigned, favorited, and followed records to be downloaded now for offline access? A fast connection is recommended as this operation may take some time. You may download later from Main Menu > Offline.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'Records downloaded successfully',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'Download your records...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'Error while downloading records',
    'LBL_OFFLINE_PREFETCHING' => 'Loading records...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'Loading {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'Time left is about {{estimatedTime}}s...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => 'Loading {{module}} completed',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'Cleaning storage...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'Clean-up completed',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'Do you want to rollback this change?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'Rollback completed',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'Rollback failed',
    'LBL_OFFLINE_CLEAR_DB' => 'Clear Storage...',
    'LBL_OFFLINE_COMPACT_DB' => 'Compact Storage...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'This action will delete records you haven\'t accessed in a while. Proceed?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'Do you want to delete all records from the local storage?',
    'LNK_OFFLINE_SETTINGS' => 'Offline',
    'LBL_OFFLINE_SETTINGS' => 'Debug settings',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'No changes pending synchronization.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'Changes are pending synchronization.',
    'LBL_OFFLINE_STATUS_ONLINE' => 'Device is online.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'Device is offline.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'Unable to reach the server.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'Last synchronization attempt failed. Check the transaction log.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'Synchronization in progress...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'Transaction synchronized.',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'Are you sure you want to turn on offline support?',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'Do you want to turn off offline support? All changes pending synchronization will be lost.',
    'LBL_OFFLINE_ENABLED' => 'Offline mode enabled',
    'LBL_OFFLINE_DISABLED' => 'Offline mode disabled',
    'LBL_OFFLINE_STATS' => 'Storage statistics',
    'LBL_OFFLINE_SERVER_FETCH' => 'Fetching from server...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'Someone has edited the same record on the server. Confirm to auto-merge your changes or reject to discard them.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'Last synchronization attempt: {{ts}}',
    'LBL_ACTION_UPDATE' => 'UPDATE',
    'LBL_ACTION_CREATE' => 'CREATE',
    'LBL_ACTION_DELETE' => 'DELETE',
    'LBL_ACTION_LINK' => 'LINK',
    'LBL_ACTION_UNLINK' => 'UNLINK',
    'LBL_ACTION_FAVORITE' => 'FAVORITE',
    'LBL_ACTION_FOLLOW' => 'FOLLOW',
    'LBL_ACTION_CREATE_EXPLANATION' => 'Created {{module}} "{{name}}"',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'Updated {{module}} "{{name}}"',
    'LBL_ACTION_DELETE_EXPLANATION' => 'Deleted {{module}} "{{name}}"',
    'LBL_ACTION_LINK_EXPLANATION' => 'Linked {{module}} "{{name}}" to {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'Unlinked {{module}} "{{name}}" from {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'Followed {{module}} "{{name}}"',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'Unfollowed {{module}} "{{name}}"',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'Favorited {{module}} "{{name}}"',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'Unfavorited {{module}} "{{name}}"',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'Created {{module}} "{{name}}" related to {{relatedModule}} "{{relatedName}}"',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'Primary',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'Opt-out',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'Opt-in',
    'LBL_EMAIL_ACTION_SET_VALID' => 'Valid',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'Invalid',
    'LBL_ROLLBACK_BUTTON' => 'Rollback',
    'LBL_TX_LOG' => 'Transaction Log',
    'LBL_TX_LOG_DETAIL' => 'Transaction Detail',
    'LBL_RECORD_DELETED' => '(Record deleted)',
    'LBL_NOT_AVAILABLE' => 'N/A',
    'LBL_FILE_SIZE' => 'File Size',
    'LBL_FILE_SIZE_UNITS_B' => 'Bytes',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'Choose items',
    'LBL_OFFLINE_DB_SIZE' => 'Database size',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'Records per module',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'Total number of records',
    'LBL_RECORD_NOT_FOUND' => 'Record not found.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'Related record not found.',
    'LBL_NOT_AUTHORIZED' => 'You are not authorized to view this record.',
    'LBL_MOBILE_PROCESSING_FILE' => 'Preparing file...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'Third Party Software',
    'LNK_TERMS_OF_USE' => 'Terms of Use',
    'LNK_PRIVACY_POLICY' => 'Privacy Policy',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'Single Sign-On',
    'LBL_RECENTS' => 'Recents',
    'LBL_SHOWING_CACHED_DATA' => 'Unable to reach the server. Showing latest available data ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'Close {{moduleSingular}} and save',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'Specific Dashboard',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Specific Module',
    'LBL_MOBILE_DEFAULT_VIEW' => 'Start Screen',
    'LBL_MOBILE_DEFAULT_MODULE' => 'Selected Module',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'Selected Dashboard',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'Selected Dashlet',
    'LBL_ALL_DASHLETS' => 'All Dashlets',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'Global Search',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Type @ to mention a user. Type # to reference a record.',
    'LBL_MOBILE_NEW_COMMENT' => 'New comment',
    'LBL_RECENTLY_VIEWED' => 'Recently Viewed',
    'LBL_FILE_STORED_LOCALLY' => 'File is stored on local storage and will be synced once device is online.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'If you wish to change certain fields that are not editable, please contact Administrator to notify these changes.',
    'LBL_ACTIVITY_POST' => '{{{value}}}on {{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'No comment',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'Show the next {{{commentsLeft}}} comments',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'Collapse',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'Confirm comment creation',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'Comment Log cannot be empty',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'Download {{{pdfTemplateName}}} PDF',

    'ERR_SYNC_FAILED' => 'Unable to sync with server.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'Access not authorized.',
    'ERR_MOBILE_INVALID_CREDS' => 'Invalid username or password.',
    'ERR_MOBILE_SESSION_EXPIRED' => 'Your session expired.',
    'ERR_MOBILE_NOT_FOUND' => 'Resource not found.',
    'ERR_MOBILE_TIMEOUT' => 'Server is not responding.',
    'ERR_MOBILE_CONNECTION_FAILED' => 'Can\'t reach the server.',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'Internet connection unavailable.',
    'ERR_MOBILE_INTERNAL' => 'Internal error ({{{code}}}). Please try again later.',
    'ERR_MOBILE_VALIDATION' => 'Record is invalid',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'Incompatible server flavor: {{{flavor}}}. Supported flavors: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'Incompatible server version: {{{version}}}. Minimum required version: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'Error. Invalid Email Address.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'This document type is unsupported.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'Authentication failed.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'Requested resource not found.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'Internal server error.',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'Forbidden.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'Service unavailable.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'An unexpected error has occurred.',
    'ERR_MOBILE_UPLOAD' => 'Error during file upload',
    'ERR_MOBILE_FILE_PROCESSING' => 'File processing error',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'Device storage is unavailable',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'Your app is outdated and is no longer compatible with the {{{brandName}}} instance you are connecting to. Do you want to download the new version from App Store?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'Server configuration has changed and reload is required. Proceed?',
    'ERR_MOBILE_CONFLICT' => 'Someone has edited the same record on the server. Confirm to auto-merge your changes or reject to discard them.',
    'ERR_MOBILE_METADATA_CHANGED' => 'Server configuration has changed.',
    'ERR_MOBILE_FILE_READ' => 'Failed to read the file',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'File not found',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'File not readable',
    'ERR_MOBILE_FILE_ABORTED' => 'Read operation was aborted',
    'ERR_MOBILE_FILE_SECURITY' => 'File is locked',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'Mobile version does not support this functionality. Do you want to open the desktop version?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'File is too big. Maximum allowed size is {{size}}',
    'ERR_OFFLINE' => 'Offline error',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'Failed to open local storage',
    'ERR_OFFLINE_STORAGE_CREATE' => 'Failed to create local storage',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'Failed to create local storage: you\'ve run out of space.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'You\'ve run out of space for local storage.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'Database clean-up failed',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'You have run out of space for offline storage, and storage cleanup will be performed. This may take several minutes.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'Failed to prefetch records from server',
    'ERR_OFFLINE_SYNC_ERROR' => 'Synchronization error',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'Synchronization conflict',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'Failed to get server time',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'Failed to enable offline mode. Unable to reach the server.',
    'LBL_EXPORT_CSV' => 'Export CSV',
    'LBL_ERR_EXPORTING_CSV' => 'Export failed',
    'LBL_ERR_EXPORT_ALL' => 'Failed fetching data for selected records, please retry',
    'LBL_LIST_SETTINGS_RESTORE' => 'Restore Defaults',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'Restore fields?',
    'LBL_LIST_SETTINGS_TITLE' => 'List View Builder',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'Available Fields',
    'LBL_LIST_SETTINGS_REMOVE' => 'Remove',
    'LBL_LIST_SETTINGS_TEXT' => 'Drag fields into the list view builder and rearrange them to design the {{moduleName}} list view.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'At least one field must be added to the layout.',
    'LBL_LIST_SETTINGS_EMPTY' => 'No available fields',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'No matching fields found',
    'LBL_LIST_FILTER' => 'Field Search',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'Email client',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'External Email Client',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar Email Client',
    'LBL_OFFLINE_CAPABILITIES' => 'Enable offline capabilities',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'Transaction delete failed.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'Transaction deleted.',
    'LBL_SECURE_MODE' => 'Enhanced Security Mode',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'Enable this setting to hide the contents of Sugar Mobile when the app is in the background and to prevent screenshots of the app at any time.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'Enable this setting to hide the contents of Sugar Mobile when the app is in the background.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'Always Offline Mode',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'You are working in Always Offline mode. Would you like to reconnect?',
    'LBL_RECONNECT' => 'Reconnect',
    'LBL_STAY_OFFLINE' => 'Stay Offline',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'The module you are trying to access is not available on Sugar Mobile.',
    'LBL_MOBILE_RELEASE_NOTE' => 'Sugar Mobile for {{platform}} Release Notes',
    'LBL_MOBILE_USER_GUIDE' => 'Sugar Mobile for {{platform}} User Guide',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'containing these words',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'excluding these words',
    'LBL_NOTIFICATIONS_CHANNEL' => 'Updates',
    'LBL_APPLY_BUTTON_LABEL' => 'Apply',
    'LBL_ACTION_CREATE_FAILURE' => "Failed to save the record:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "Failed to update the record:\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'Failed to resolve fields calculations on server.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'Following fields are invalid: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>Success.</b> You successfully created the {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}".</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>Success.</b> You successfully updated the record',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'Failed to get email data from server.',
    'LBL_ASSIGN_SUCCESS' => '<b>Success.</b> The record has been assigned to {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'Save this email as a draft?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'Save as draft',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'Discard email',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'If you do not save draft, you will lose this email.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'Select Signature',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'Select Email Template',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'The template will overwrite all contents in this email. Are you sure you want to use this template and overwrite content?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'Compose Email',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'Your email contains variables that will be replaced using values from the Related To record. Please confirm that the Related To field is set correctly before sending.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'No outbound email account found. Please contact your Sugar admin.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' and {{{count}}} more',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'Add an email',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'Type a contact name or email',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (New Email)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'Variables',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'Email Templates',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'Campaign Templates',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'Workflow Templates',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'System Templates',
    'LBL_FILTER_EDIT' => 'Edit Filter',
    'LBL_FILTER_MY_FILTER' => 'My filter',
    'LBL_FILTER_MY_FILTER_BY' => 'My filter by {{{filters}}}',
    'LBL_FILTER_SAVE' => 'Save filter',
    'LBL_SELECT_PARAM' => 'Select',
    'LBL_SELECT_MODULES' => 'Module Selector',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'Select Additional Parameter',
    'LBL_FILTER_TEMPORARY' => 'Temporary filter',
    'LBL_ERROR_FILE_UPLOAD' => 'Failed to upload {{{fieldLabel}}} file "{{{fileName}}}". {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">View failed record</a>',
    'LBL_FILE_UPLOAD_ONE' => 'Saving file...',
    'LBL_FILE_UPLOAD_MANY' => 'Saving file {{{index}}} of {{{total}}}...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'Notification Settings',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'Manage your push notifications',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "Control how notifications appear using your device's notification settings.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'Assignments',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'Receive notifications when records are assigned to you.',
    'LBL_NOTIFICATION_MENTIONS' => 'Mentions',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'Receive notifications when you are mentioned in comment log entries.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'The Comment Log field has not been added to this layout by an administrator. Please contact your Sugar admin.',
    'ERR_NO_PERMISSION_TITLE' => 'Please allow access',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} needs camera access so that you can attach photos. Please allow camera access in sytems settings.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'Settings',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'Duration',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'Time Remaining',
    'LBL_LIST_SUPPORT_EXPIRES' => 'Expires',
    'LBL_CASCADE_RLI_EDIT' => 'Update Open Revenue Line Items',
    'LBL_MOBILE_CALENDAR' => 'Calendar',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'Calendar Settings',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'Week start day',
    'LBL_MOBILE_CALENDAR_MODULES' => 'Events to display',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}h:{{{minutes}}} mins',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} Hrs',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} Mins',
    'LBL_MOBILE_CALENDAR_TODAY' => 'Today',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => 'Add {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'Schedule an activity',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'Please enable at least one event type.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'All day',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'Failed to load Calendars.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'This action is not available in Sugar Mobile. Do you want to open the desktop application instead?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'Select Template',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'Merge',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'Error: EXIF data missing from HEIC file',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'Error: Image resolution too high',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'Error: Cannot process the image',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'Error: Failed to render the image to canvas',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'Error: Failed to load file as image',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1 Item Selected',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} Items Selected',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'Select all',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'You have selected {{{count}}} records in this view. Select all records?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'Select {{{count}}} records',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'Are you sure you want to delete selected record(s)?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'Deleting… {{{count}}} out of {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'No valid email found in the selected records',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'Appearance',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'Use system setting',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'Light',
    'LBL_MOBILE_APP_THEME_DARK' => 'Dark',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'New file name',
    'LBL_ATTACHMENT_RENAME_MSG' => 'Rename the file',
    // Filters related
    'LBL_CREATED_BY_ME' => 'Created by me',
    'LBL_OPERATOR_ONE_OF' => 'is one of',
    'LBL_OPERATOR_NOT_ONE_OF' => 'is not one of',
    'LBL_OPERATOR_CONTAINS' => 'is any of',
    'LBL_OPERATOR_CONTAINS_WORD' => 'contains',
    'LBL_OPERATOR_NOT_CONTAINS' => 'is not any of',
    'LBL_OPERATOR_EMPTY' => 'is empty',
    'LBL_OPERATOR_NOT_EMPTY' => 'is not empty',
    'LBL_OPERATOR_MATCHES' => 'exactly matches',
    'LBL_OPERATOR_STARTS_WITH' => 'starts with',
    'LBL_OPERATOR_EQUALS' => 'is equal to',
    'LBL_OPERATOR_NOT_EQUALS' => 'is not equal to',
    'LBL_OPERATOR_GREATER_THAN' => 'is greater than',
    'LBL_OPERATOR_LESS_THAN' => 'is less than',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'is greater than or equal to',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'is less than or equal to',
    'LBL_OPERATOR_BETWEEN' => 'is between',
    'LBL_OPERATOR_BEFORE' => 'before',
    'LBL_OPERATOR_AFTER' => 'after',
    'LBL_OPERATOR_YESTERDAY' => 'yesterday',
    'LBL_OPERATOR_TODAY' => 'today',
    'LBL_OPERATOR_TOMORROW' => 'tomorrow',
    'LBL_OPERATOR_LAST_7_DAYS' => 'last 7 days',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'next 7 days',
    'LBL_OPERATOR_LAST_30_DAYS' => 'last 30 days',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'next 30 days',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'More than __ days ago',
    'LBL_OPERATOR_LAST_X_DAYS' => 'Last __ days',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'Next __ days',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'More than __ days in the future',
    'LBL_OPERATOR_LAST_MONTH' => 'last month',
    'LBL_OPERATOR_THIS_MONTH' => 'this month',
    'LBL_OPERATOR_NEXT_MONTH' => 'next month',
    'LBL_OPERATOR_LAST_YEAR' => 'last year',
    'LBL_OPERATOR_THIS_YEAR' => 'this year',
    'LBL_OPERATOR_NEXT_YEAR' => 'next year',
    'LBL_OPERATOR_IS' => 'is',
    'LBL_OPERATOR_IS_NOT' => 'is not',
    'LBL_OPERATOR_AFTER_TODAY' => 'after today',
    'LBL_OPERATOR_BEFORE_TODAY' => 'before today',
    'LBL_ERROR_FILTER_EMPTY' => 'Please add filter criteria.',
    'LBL_ADD_FILTER' => 'Add Criteria',
    'LBL_FILTER_NAME' => 'Filter name',
    'LBL_FILTER_FIELD' => 'Field',
    'LBL_FILTER_OPERATOR' => 'Operator',
    'LBL_FILTER_VALUE' => 'Value',
    'LBL_FILTER_SYNC_TO_SERVER' => 'Save to Desktop App',
    'LBL_FILTER_LOCAL' => 'Local filter',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'Welcome to {{{brandName}}}.<br/><br/> Allow us to highlight some new features...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'Main menu navigation.',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'Available actions per view.',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'Global search for records.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'Filter the list to show my favorite records.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'Filter the list to show records assigned to me.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'Mark record as a favorite.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'My upcoming events starting today.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'Most recently modified records.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'Available actions on a record.',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'Enjoy all the new features!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'This is the plus menu.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'Close the plus menu.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'Select the specific action to view to perform.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'This is the home menu.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'Close the home menu.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'View a specific module.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'Customize the application.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'Open Sugar in the web browser.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'View your profile.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'This is the detail page.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'The most important information about a record.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'View additional information or edit a record.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'Available actions on a record.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'Go to the previous page.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'Access Tour at any time.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'Go back.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'Click to open a related record.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'Follow/Unfollow a record.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'Click to expand a detail information.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'Main menu view.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'The main menu opens on the left side of your screen.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'Detail View',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'The detail view opens on the right side of your screen.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'Use the arrows below for a quick tour through the key components of this menu.',

    'LBL_COMMENT_ADD' => 'Add a Comment',
    'LBL_REQUIRED' => 'Required',
    'LBL_MORE_BUTTON' => 'More',
    'LBL_NO_OPTIONS' => 'No options available',
    'LBL_TRY_AGAIN' => 'Try again',
    'LBL_NEW_RECORDS' => 'Recently Created',
    'LBL_ASSIGNED_TO_ME' => 'My {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'All {{{module}}}',
    'LBL_UNFAVORITE' => 'Unfavorite',
    'LBL_ACTIVITY_CREATE' => 'Created {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => 'Updated {{{changes}}} on {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => 'Linked {{{relatedRecord}}} to {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => 'Unlinked {{{relatedRecord}}} from {{{record}}} {{{module}}}',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} for {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'Download related records...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'Your dashboard configuration has changed. Do you want to reload?',
    'LBL_RECORDS' => 'Records',
    'LBL_DASHBOARDS' => 'Dashboards',
    'LBL_TEMPLATES' => 'Templates',
    'LBL_NON_TEMPLATES' => 'Non Templates',
    'LBL_IS_TEMPLATE' => 'Is Template',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'Your selection contains dashboard templates, which cannot be mass updated. Please deselect templates to continue.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'Your selection contains dashboard templates, which cannot be deleted. Please deselect templates to continue.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'Search {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'Main menu',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'Quick create new record',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'Swipe for more options',
    'LBL_DETAILS' => 'Details',
    'LBL_DETAIL_RELATED' => 'Related',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'This {{module}} requires a {{relatedModule}}. <a class=\'alert-link\' href=\'{{{createLink}}}\'>Create a {{relatedModule}} record</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'Edit record',
    'LBL_OFFLINE_MENU_SETTINGS' => 'Offline Settings',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'Debug Settings',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'Total Records',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'Last download',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'Unable to download the file.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'Failed to load dashboards from server',
    'ERR_FILTERS_FETCHING' => 'Unable to fetch your filters',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'Failed to encrypt local storage',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'Encrypting offline data. This may take several minutes.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'Offline data encryption completed.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'You do not have access to {{{module}}} module.',
    'LBL_SKIP' => 'Skip',
    'LBL_CONTINUE' => 'Continue',
    'LBL_ENABLE' => 'Enable',
    'LBL_MOBILE_TRIAL_UNTIL' => 'Trial Until',
    'LBL_MOBILE_SDK_VERSION' => 'SDK Version',
    'LBL_LOG_LEVEL' => 'Log Level',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'Login settings have been reconfigured.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'Your trial period has expired.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'Server does not support secure connection. Please turn off secure connection.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'Server supports secure connection. Please turn on secure connection.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'Your connection is not secure. Contact your administrator.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'Login Settings',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'Set up your {{{brandName}}} instance',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'In order for the app to work, you will need to type in the URL of the {{{brandName}}} instance. If you do not have the instance URL, please contact your administrator.',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => 'Touch ID',
    'LBL_ENABLE_TOUCHID' => 'Enable {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => 'Setup {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'Sign in using your finger',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} is not set up on your device. \n\nGo to your device settings to set up {{{biometryType}}}. Once set up, enable {{{biometryType}}} for {{{brandName}}} in Main Menu > Settings.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'Using {{{biometryType}}} with {{{brandName}}} will allow you to use your biometric identifier instead of entering your password to access {{{brandName}}}.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'Would you like to proceed with {{{biometryType}}}?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'Enter {{{brandName}}} Password to Enable {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'Setup',
    'LBL_MDM_CONFIRM_CHANGE' => 'Application configuration has changed from Mobile Device Manager. Please re-login to apply changes.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'Please give {{{brandName}}} access to your location via your device\'s settings.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'Current location is not available',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "Current location retrieval timed out. \nPlease try again.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'Location placemarks are not available',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'Location coordinates are invalid',
    'ERR_MOBILE_INVALID_PASSWORD' => 'Invalid password.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'Your app is outdated and is no longer compatible with the {{{brandName}}} instance you are connecting to. Do you want to update it?',
    'LBL_MOBILE_BY' => 'By',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'This filter is not available in offline',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'Offline Records',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'Download Settings',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'Download your assigned, favorite, and followed records for offline access. You can update your preferences in offline settings.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'Your records have finished downloading. You can now access them in offline mode.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "Not all your records were downloaded.\n Do you want to try again?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'Use cellular data',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'Not right now',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'Download has paused and it will resume when you open the app again.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'Downloading {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'Update Latest Records',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'Waiting for connection',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'Paused',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'Stopping',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'Download',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'Pause',
    'LBL_BULK_LOAD_BTN_RESUME' => 'Resume',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'Only WiFi connection is used by default',
    'LBL_NPS_RATING_MSG' => "How would you rate your \n{{{productName}}} experience?",
    'LBL_NPS_THANKS_MSG' => 'Thanks for your feedback!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'Would you mind rating it on the App Store?',
    'LBL_NPS_NO_THANKS' => 'No, Thanks',
    'LBL_NPS_NOT_NOW' => 'Not Now',
    'LBL_NPS_RATE_NOW' => 'Rate Now',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'Network is unavailable. You can still use the app while offline',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'Your changes will be synced when you are online. <a class=\'alert-link\' href=\'{{{link}}}\'>See details</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'There are unsynced data. Please check the <a class=\'alert-link\' href=\'{{{link}}}\'>transaction log</a>',
    'LBL_CONVERT' => 'Convert',
    'LBL_CONVERT_LEAD' => 'Convert Lead',
    'LBL_SEARCH_EXISTING_RECORD' => 'Search Existing {{{this}}}',
    'LBL_DUPLICATES_CHECK_FAILED' => 'Duplicates check failed',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'Do you want to move related activities to the contact record?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'You successfully converted the lead {{{name}}}',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'No Duplicates Found.',
    'ERR_LEAD_CONVERSION_FAIL' => 'Lead Conversion Failed',
    'LBL_SELECT_DUPLICATE_RECORD' => 'Select From Duplicate {{{modulePlural}}}',
    'LBL_SELECTED_EXISTING_RECORD' => 'Selected {{{moduleSingular}}}',
    'LBL_CREATED_NEW_RECORD' => 'Created New {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => 'Back button',
    'LBL_VO_HOME_BTN' => 'Home button',
    'LBL_VO_DASHBOARD_BTN' => 'Dashboard button',
    'LBL_VO_SEARCH_BTN' => 'Search button',
    'LBL_VO_RIGHT_MENU_BTN' => 'Right menu button',
    'LBL_VO_ADD_BTN' => 'Add button',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'Discount',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'Select a mapping app',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'The selected {{entityName}} has related values: {{localizedFieldNames}}. Cancel to keep existing values. Confirm to overwrite with new values.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'Data encryption is enabled.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'Selected lead is already converted.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'This action is only available when device is online',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'Are you sure you want to create an Opportunity from the Quote?',
    'LBL_TAG_ADD' => 'Add tag',
    'LBL_TAG_ENTER_TAG_NAME' => 'Enter tag',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'Filtering by Tags is not supported while device is offline.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'Show entire comment',
    'LBL_COMMENT_VIEW' => 'View a Comment',
    'LBL_PMSE_LABEL_DUEDATE' => 'Due date',
    'LBL_PMSE_DUE' => 'Due',
    'LBL_PMSE_DUE_ON' => 'Due on',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'Please create {{conversionParentModuleName}} first',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'Missing required records: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'Choose image quality. The image will be resized accordingly before saving to the server. The selected value will be used as default for all similar operations in future.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'Estimating file size...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'The estimated file size is',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'Image quality',
    'LBL_IMAGE_QUALITY_BEST' => 'Original size',
    'LBL_IMAGE_QUALITY_GOOD' => 'Good quality',
    'LBL_IMAGE_QUALITY_POOR' => 'Small size',
    'LBL_IMAGE_QUALITY_BTN' => 'Compression: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'List fields on {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'Reset to defaults',
    'LBL_LIST_NOT_ENOUGH' => 'Please set at least 1 active field.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'You need to login and accept permissions to be able to work with SugarCRM instance.',
    'LBL_SELECTING_EXISTING_RECORD' => 'Selecting {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'Creating New {{{moduleSingular}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'Image Size',
    'LBL_COPY_ADDRESS' => 'Copy address',
    'LBL_OPEN_IN' => 'Open in',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'No file selected.',
    'LBL_ATTACHMENT_ADD' => 'Attach',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'This app uses cookies',
    'LBL_USE_COOKIES_CONFIRM' => 'This application uses cookies to aid in providing you with a better experience. By continuing, you consent to the use of cookies in accordance with our privacy policy.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'You are using a Sugar instance that will not be compatible with Sugar Mobile in an upcoming mobile release. Please ask your administrator to upgrade Sugar as soon as possible.',
    'ERROR_TAG_NAME_INVALID' => 'Tag name cannot contain "{{{forbiddenChars}}}" characters',
    'ERROR_NO_TAGS_FOUND' => 'No tags available matching "{{{searchQuery}}}"',
    'ERR_PA_RECORD_INVALID' => '{{{moduleName}}} record has one or more invalid values and cannot be saved. Do you want to edit the record in order to perform {{{actionLabel}}} action?',
    'ERR_MOBILE_METADATA_RELOAD' => 'An admin has made configuration changes in your Sugar instance. Press OK to sync your app\'s configuration with the server.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'This application uses cookies',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'Check to accept (Required)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'This application uses cookies to aid in providing you with a better experience. By continuing, you consent to the use of cookies in accordance with our <a href="{{href}}" target="_blank">privacy policy</a>.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'The record view allows you to see the details of a record.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Notes let you collaborate with other portal users and support representatives.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'Click here to add a note to this record.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'Click on these icons to view the details of attached notes.',

    //for portal
    'LBL_PORTAL_HOME' => 'Home Dashboard',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'All Open Cases',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'Recently Resolved Cases',
    'LBL_PORTAL_SEARCH' => 'Search by Name, Number',
    'LBL_SIGNUP_BUTTON_LABEL' => 'Sign Up',
    'LBL_PORTAL_NO_EMAIL' => 'Did not get an email?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'Forgot Password',
    'LBL_PORTAL_FORGOT_USERNAME' => 'Forgot Username',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'Enter your password twice. Passwords must match.',
    'LBL_PORTAL_RESET_PASSWORD' => 'Reset Password',
    'LBL_PORTAL_REENTER_PASSWORD' => 'Re-enter Password',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'Passwords do not match, please enter again',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'Your password has been successfully reset.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'An error occurred. Please initiate a new password reset request.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'Registering',
    'LBL_PORTAL_SIGNUP_TITLE' => 'Thank you for signing up.',
    'LBL_PORTAL_SIGNUP' => 'We will review your portal registration and notify you once your portal account is activated.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'First Name',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'Last Name',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'Username',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'Email Address',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (optional)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'Country',
    'LBL_PORTAL_SIGNUP_STATE' => 'State',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'Company Name',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'Job title (optional)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'Password',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'Confirm Password',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'Forgot Login',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'Forgot password?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'Please contact your Sugar Admin to reset your password.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'Username',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'Password',
    'LBL_PORTAL_LOADING' => 'Loading',
    'LBL_PORTAL_SAVING' => 'Saving',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'Page Not Available',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "We're Sorry, but this feature is not available at this time.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'Show search results for "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'Did not get an email?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'For assistance, or to contact us, please use any of the following: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'Phone: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'Email: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'Web: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'Are you sure you want to close the chat?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'Create Note or Add Attachment',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'Add a Note',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'Your login was not successful. Please try again.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'Invalid Credentials',
    'LBL_PORTAL_INVALID_GRANT' => 'Your session has expired. Please login again.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'Session Expired',
    'LBL_PORTAL_AUTH_FAILED' => 'Client authentication failed.',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'Invalid Client',
    'LBL_PORTAL_INVALID_REQUEST' => 'The request made is invalid or malformed. Please contact technical support.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'Invalid Request',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'The request timed out.',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'Request timeout',
    'LBL_PORTAL_UNAUTHORIZED' => 'We\'re sorry, but it appears you are unauthorized to access this resource.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'Unauthorized',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'Resource not available.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'Forbidden',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'HTTP method not allowed for this resource. Please contact technical support.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'Method Not Allowed',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'Request failure, or, missing/invalid parameter. Please contact technical support',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'Error: ',
    'LBL_PORTAL_MIN_MODULES' => 'At minimum, you need to have the Cases, Bugs or Knowledge Base module enabled to use this application.',
    'LBL_PORTAL_ERROR' => 'Error',
    'LBL_PORTAL_ROUTE_ERROR' => 'Issue loading module. Please try again later or contact support.',
    'LBL_PORTAL_OFFLINE' => 'Sorry the application is not available at this time. Please contact the site administrator.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'Change Password',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'Username is already registered in the system. Either request a forgotten password or select another username.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'The email provided is invalid.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'The passwords do not match.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'Service Console',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'Overview',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'Restore Default Dashboard',
    'LBL_UNTITLED' => 'Untitled',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'Sales Console',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'Overview',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'Stage/Status',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'Name/Account Name',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'Omnichannel Dashboard',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'Customer',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} at {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'Your browser is not supported for SugarLive. Please use Google Chrome or Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'A <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> has been created containing the details of your conversation.',
    'LBL_OMNICHANNEL_SUBJECT' => 'Subject',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'Description',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'Message Summary',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'Call Summary',
    'LBL_OMNICHANNEL_LINK_TO' => 'Link {{fromModule}} to {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'Link to {{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'Linked',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'Your browser is not supported for chat. Please use Google Chrome or Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Please contact your Sugar Administrator for assistance.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'Configure Layout',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'Please finish configuring SugarLive before making an outbound call.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'Please finish configuring the SugarLive layout before opening SugarLive.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'Set yourself to "Offline" in SugarLive before configuring the SugarLive layout.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'Compact View',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'Full View',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR Dashboard',
    'LBL_SALES_MANAGER_CONSOLE' => 'Sales Manager Dashboard',
    'LBL_SALES_REP_CONSOLE' => 'Sales Rep Dashboard',
    'LBL_MARKETING_CONSOLE' => 'Marketing Dashboard',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'Customer Success Dashboard',
    'LBL_EXECUTIVE_CONSOLE' => 'Executive Dashboard',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'Restore Tab to Default',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'Configure Summary Panel',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'User Profile',
    'LBL_WIZ_COMPLETE_TITLE' => 'Setup Complete',
    'LBL_SETUP_COMPLETE_INFO' => 'Start using Sugar!',
    'LBL_SETUP_USER_INFO' => 'Setup your user information',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'User Locale Settings',
    'LBL_SETUP_USER_LOCALE_INFO' => 'Set your time zone, date, and name formats',
    'LBL_WIZ_START_SUGAR' => 'Start Sugar',
    'LBL_WIZ_FIRST_NAME' => 'First name',
    'LBL_WIZ_LAST_NAME' => 'Last name',
    'LBL_WIZ_EMAIL' => 'Email',
    'LBL_WIZ_TIMEZONE' => 'Time Zone',
    'LBL_WIZ_TIMEFORMAT' => 'Time Format',
    'LBL_WIZ_DATE_FORMAT' => 'Date Format',
    'LBL_WIZ_NAME_FORMAT' => 'Name Format',
    'LBL_SETUP_PROGRESS' => 'Setup progress',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar Training',
    'LBL_WIZ_DOCUMENTATION' => 'Documentation',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'Knowledge Base',
    'LBL_WIZ_FORUMS' => 'Forums',
    'TPL_TIMEZONE_DIFFERENT' => 'Your browser\'s timezone does not match your saved timezone {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'Adjust Your Timezone.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'Locale Settings',
    'LBL_WIZ_EMAIL_SETTINGS' => 'Email Settings',
    'LBL_WIZ_IMPORT_DATA' => 'Import Data',
    'LBL_WIZ_CREATE_USERS' => 'Create Users',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'System Settings',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Studio',

    'LBL_CSP_ERROR_MESSAGE' => 'The value(s) you have entered is unsupported or does not meet the acceptable format. For a list of acceptable field values and formats, refer to the <a href="{{linkToDocumentation}}" target="_blank">System</a> documentation.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'This content has not been approved. Please update your system\'s <a href="{{linkToDocumentation}}" target="_blank">Content Security Policy Settings</a>.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'This content has not been approved. Ask your administrator to update your system\'s <a href="{{linkToDocumentation}}" target="_blank">Content Security Policy Settings</a>. Once the settings have been updated, you will need to refresh your browser for the changes to take effect.',

    // For password related labels
    'LBL_PASSWORD' => 'Password',
    'LBL_CHANGE_YOUR_PASSWORD' => 'Change your password',
    'LBL_PASSWORD_REQUIREMENTS' => 'Password requirements',
    'LBL_CURRENT_PASSWORD' => 'Current Password',
    'LBL_NEW_PASSWORD1' => 'New Password',
    'LBL_NEW_PASSWORD2' => 'Confirm Password',
    'LBL_PASSWORD_CHANGED' => 'You have successfully changed your password',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'Please enter your password confirmation.',
    'ERR_ENTER_NEW_PASSWORD' => 'Please enter your new password.',
    'ERR_ENTER_OLD_PASSWORD' => 'Please enter your current password.',
    'ERR_REENTER_PASSWORDS' => 'The passwords must match.',
    'ERR_PASSWORD_MISMATCH' => 'Password entered does not match that in our system.',
    'LBL_CANNOT_SEND_PASSWORD' => 'Cannot send password',
    'LBL_REQUEST_PASSWORD' => 'Request Password',
    'LBL_RESET_PASSWORD' => 'Reset Password',
    'LBL_RESET_PASSWORD_MESSAGE' => 'Enter your username and we will send you a link to reset your password.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Check your email <br><br> We have sent password reset instructions to the email address
        we have on file.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'Error: There was a problem updating password for this user.',
    'LBL_INCORRECT_PASSWORD' => 'Error: Incorrect password.',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'The password you entered did not meet the password requirements. Please try again.',
    'LBL_PASSWORD_MIN_LENGTH' => 'Minimum length is {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'Maximum length is {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'Must contain one upper case letter (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'Must contain one lower case letter (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'Must contain one number (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'Must contain one special character (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'The password must not match the regular expression pattern: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'Language Preference:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'Could not send password reset email.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'Select a Report',
    'LBL_REPORT_AUTO_REFRESH' => 'Auto Refresh',
    'LBL_REPORT_EDIT' => 'Edit Selected Report',
    'LBL_REFRESH_LIST_AND_CHART' => 'Refresh List and Chart',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'No chart available.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'This report does not contain any filters.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => '<p>You have no runtime filters.</p>',
    'LBL_RUNTIME_FILTERS' => 'Runtime Filters',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'The date does not match the user\'s preferred date format: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'This dashlet has no run-time filters',
    'LBL_DASHBOARD_FILTER_GROUP' => 'New Filter',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'You need at least one value selected.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'Reset To Default Filters',
    'LBL_COPY_FILTER_SUMMARY' => 'Copy Filter Summary',
    'LBL_APPLY_FILTERS' => 'Apply',
    'LBL_REPORTS_FILTERS' => 'Filters',
    'LBL_RUNTIME_FILTERS_INVALID' => 'At least one run-time filter has an invalid value.',
    'LBL_RUNTIME_FILTERS_COPIED' => 'The filter summary has been copied to your clipboard.',
    'LBL_ADVANCED_FILTERS' => 'Advanced Filters',
    'LBL_ADVANCED_OR_DESC' => 'Include when ANY condition is satisfied',
    'LBL_ADVANCED_AND_DESC' => 'Include when ALL conditions are satisfied',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'This is an original design filter',
    'LBL_AND_UPPERCASE' => 'AND',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'This feature is not available in Preview Mode',
    'LBL_REPORT_DEFAULT_NAME' => 'Untitled Report',
    'LBL_REPORT_QUERY' => 'Query',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'Related to Current Record',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'Field or Subpanel',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'Field or subpanel cannot be empty',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'No report selected.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'Line Chart is not compatible with this report',
    'LBL_REPORT_DASHLET' => 'Report Dashlet',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'Data Table',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'Runtime Filters',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'Data Table Preview',
    'LBL_REPORTS_DASHLET_CHART' => 'Chart',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'Chart Preview',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'Filter Preview',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'The selected report does not support a chart.',
    'LBL_REPORTS_DASHLET_LABELS' => 'Labels',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'Show Total Record Count',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'Sort Order',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'Default Selected View',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'Primary Chart Sort Order',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'Secondary Chart Sort Order',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'No {{module}} links to selected report',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'Not available for this report type',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'This feature is only available on chart tab',
    'LBL_REPORTS_CHART_TYPE' => 'Chart Type',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'Bar Chart Value Placement',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'Show Total',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'Show Legend',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Show x-axis Label',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Show y-axis Label',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Rows Display Limit',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'You do not have permission to use these runtime filters.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'Unknown',
    'ERR_HTTP_DEFAULT_TITLE' => 'Unknown Error',
    'ERR_HTTP_DEFAULT_TEXT' => 'Unknown error.',
    'ERR_HTTP_DEFAULT_ACTION' => 'Back to Previous Page',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'Error: Invalid Request',
    'ERR_HTTP_400_TEXT_LINE1' => 'Your browser sent a request that the server could not understand.',
    'ERR_HTTP_400_TEXT_LINE2' => 'Please contact your Sugar Administrator for more details.',
    'ERR_HTTP_400_ACTION' => 'Back to Previous Page',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'Data not available',
    'ERR_HTTP_404_TEXT_LINE1' => 'Page does not exist or you do not have permission to access this page.',
    'ERR_HTTP_404_TEXT_LINE2' => 'Please try again. If the error persists, please contact your Sugar Administrator.',
    'ERR_HTTP_404_ACTION' => 'Back to Previous Page',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 Internal Server Error',
    'ERR_HTTP_500_TEXT_LINE1' => 'The server encountered an error and could not complete your request.',
    'ERR_HTTP_500_TEXT_LINE2' => 'Please try again. If the error persists, please contact your Sugar Administrator.',
    'ERR_HTTP_500_ACTION' => 'Please contact technical support.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 Internal Server Error',
    'ERR_HTTP_502_TEXT_LINE1' => 'The server encountered a temporary error and could not complete your request.',
    'ERR_HTTP_502_TEXT_LINE2' => 'Please try again. If the error persists, please contact your Sugar Administrator.',
    'ERR_HTTP_502_ACTION' => 'Please contact technical support.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 Internal Server Error',
    'ERR_HTTP_503_TEXT_LINE1' => 'The server is unavailable to complete your request.',
    'ERR_HTTP_503_TEXT_LINE2' => 'Please try again later. If the error persists, please contact your Sugar Administrator.',
    'ERR_HTTP_503_ACTION' => 'Please contact technical support.',

    'ERR_RENDER_FAILED_TITLE' => 'View Render Failed',
    'ERR_RENDER_FAILED_MSG' => 'Failed to render a view',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'Field Render Failed',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'Unable to render the {0} field.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'Access Denied',
    'ERR_NO_VIEW_ACCESS_REASON' => 'You do not have permission to access this page.',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'Contact your administrator to request access.',
    'ERR_NO_VIEW_ACCESS_MSG' => 'Contact your Support Administrator to get access to this view for {0} module.',

    'ERR_LAYOUT_RENDER_TITLE' => 'Layout render failed',
    'ERR_LAYOUT_RENDER_MSG' => 'Oops! We are not able to render anything. Please try again later or contact support.',
    'ERR_INTERNAL_ERR_MSG' => 'Internal error',
    'ERR_GENERIC_TITLE' => 'Error',
    'ERR_CONTACT_TECH_SUPPORT' => 'Please contact technical support.',

    'LBL_SYNCED_RECURRING_MSG' => 'You cannot edit this record because it was synced from an external client.',
    'LBL_EXISTING' => 'Existing',
    'LBL_PANEL_DEFAULT' => 'Default',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'Bad response from the server',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'Error occurred during AssignTo action.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'You do not have access to "{{name}}". Please contact your Administrator.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'Year {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'More Actions',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'Alert',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'Ignore Duplicate and Save',
    'LBL_RESTORE' => 'Reset to Original',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'Records Marked For Erasure',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'Displays records related to a Data Privacy Request to '
        . 'Erase Information.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS Feed',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'Stay current by adding an external RSS or Blog Feed.',
    'LBL_RSS_FEED_URL' => 'Feed URL',
    'LBL_RSS_FEED_AUTHOR' => 'Author:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'Number of entries to show',
    'LBL_ERR_LOADING_RSS_FEED' => 'Failed loading RSS Feed',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'My Items',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'Team Items',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'Allows Users to add Sugar Apps to a Dashboard',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'History',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'The History dashlet displays Meetings held, Calls logged, Emails received and Emails sent.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'Email',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'Emails',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'My History',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'Team History',
    'LBL_UNASSIGNED' => 'Unassigned',
    'LBL_ARCHIVE_EMAIL' => 'Archive Email',
    'LBL_EMAIL_ARCHIVED' => 'Email archived',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'Create Archived Email',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'Planned Activities',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'The Planned Activities dashlet displays scheduled Meetings and Calls.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'Today',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'Future',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'My Activities',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'Team Activities',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'Held',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'Are you sure you want to mark {0} as closed?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'Active Tasks',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'The Active Tasks dashlet displays due now, upcoming and to do Tasks.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'Due Now',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'Upcoming',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'To Do',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'Completed',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'Are you sure you want to close the {0} as completed?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'My Tasks',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team Tasks',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'There was an additional email on the record you are modifying. It is now the primary and has been populated below.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'Inactive Tasks',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'The Tasks dashlet displays deferred and completed Tasks.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'Deferred',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'Completed',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'last modified {{relativetime}} on {{date}} at {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'My Tasks',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team Tasks',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'My Recently Viewed Cases',

    'LBL_REPORT_DASHLET_TITLE_12' => 'Open Cases by User by Status',
    'LBL_REPORT_DASHLET_TITLE_125' => 'New Cases by Business Center by Week',
    'LBL_REPORT_DASHLET_TITLE_126' => 'Recently Created Cases',
    'LBL_REPORT_DASHLET_TITLE_127' => 'New Cases by Customer Tier by Week',
    'LBL_REPORT_DASHLET_TITLE_128' => 'Open Cases by Customer Tier and Priority',
    'LBL_REPORT_DASHLET_TITLE_129' => 'Total Cases Resolved this Month by Business Center',
    'LBL_REPORT_DASHLET_TITLE_130' => 'Total Cases Resolved this Month by Agent',
    'LBL_REPORT_DASHLET_TITLE_131' => 'List of Recently Resolved Cases',
    'LBL_REPORT_DASHLET_TITLE_132' => 'My Cases Resolved this Month by Week',
    'LBL_REPORT_DASHLET_TITLE_133' => 'My Cases Due Today and Overdue',
    'LBL_REPORT_DASHLET_TITLE_134' => 'All Cases Due Today and Overdue',
    'LBL_REPORT_DASHLET_TITLE_135' => 'My Open Cases by Followup Date',
    'LBL_REPORT_DASHLET_TITLE_136' => 'All Open Cases by Followup Date',
    'LBL_REPORT_DASHLET_TITLE_137' => 'My Open Cases by Status',
    'LBL_REPORT_DASHLET_TITLE_138' => 'My Cases in the Last Week by Status',
    'LBL_REPORT_DASHLET_TITLE_139' => 'Status of Open Tasks Assigned by Me',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP or Old REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar Workflow',
    'LBL_AUDIT_SUBJECT_USER' => 'User',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web to Lead',

    //common chart strings
    'LBL_CHART' => 'Chart',
    'LBL_CHART_NO_DATA' => 'No data available.',
    'LBL_CHART_LEGEND_CLOSE' => 'Hide legend',
    'LBL_CHART_LEGEND_OPEN' => 'Show legend',
    'LBL_CHART_CONTROLS_CLOSE' => 'Hide controls',
    'LBL_CHART_CONTROLS_OPEN' => 'Show controls',
    'LBL_CHART_UNDEFINED' => 'Undefined',
    'LBL_CHART_NO_LABEL' => 'Undefined',
    'LBL_CHART_AMOUNT' => 'Amount',
    'LBL_CHART_COUNT' => 'Count',
    'LBL_CHART_PERCENT' => 'Percent',
    'LBL_CHART_GROUP' => 'Group',
    'LBL_CHART_DATE' => 'Date',
    'LBL_CHART_KEY' => 'Key',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'Chart type',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'Show title',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'Show total',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Show x-axis label',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Show y-axis label',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'Tick display methods',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'Wrap ticks',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'Stagger ticks',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'Rotate ticks',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'Bar chart value placement',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'Bar chart display options',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'Allow scrolling',
    'LBL_CHART_CONFIG_STACK_DATA' => 'Stack data series',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'Hide empty groups',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'sent',
    'LBL_EMAIL_RECV' => 'rec',

    //record save
    'LBL_RECORD_SAVED' => 'Record saved.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'You successfully created the {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a>.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'You successfully created the {{moduleSingularLower}}.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'You successfully created this record, but you do not have permission to access this record.', // use when user has no access to the model
    'LBL_VALIDATING' => 'Validating...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'Success:',
    'LBL_ALERT_TITLE_WARNING' => 'Warning:',
    'LBL_ALERT_TITLE_NOTICE' => 'Notice:',
    'LBL_ALERT_TITLE_ERROR' => 'Error:',
    'LBL_ALERT_TITLE_LOADING' => 'Loading',
    'LBL_ALERT_NO_ACCESS' => 'You do not have access to the filter applied to this dashlet.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'Duplicate the dashboard to configure this dashlet with your own filter.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'Your browser version is no longer supported or you are using an unsupported browser.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'Supported Platforms',
    'LBL_ALERT_CONFIRM_DELETE' => 'Are you sure you want to delete this item?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'Are you sure you want to delete these items?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'The selected record will overwrite the following values: {{values}}. Cancel to keep existing values. Confirm to overwrite with new values.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'The selected {{moduleSingularLower}} has related values: {{values}}. Cancel to keep existing values. Confirm to overwrite with new values.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'From:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'To:',

    //organization chart
    'LBL_ORG_CHART' => 'Organization Chart',
    'LBL_ORG_CHART_DESC' => 'Displays the employee structure of your organization.',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'Toggle orientation',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'Show all nodes',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'Zoom to fit',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'Case Summary',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'Shows an overview of related Cases.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'Summary',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'Closed Cases',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'Open Cases',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'Top 10 Sales',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'Displays top ten sales in a bubble chart.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'My Items',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "My Team's Items",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'Default date filter',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'Default dataset',

    'LBL_PRODUCT_CATALOG_NAME' => 'Product Catalog',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'Product Catalog',
    'LBL_PRODUCT_CATALOG_DESC' => 'View and add items from your Product Catalog.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'View and add items from your Product Catalog.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} on {{date}} at {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Type a note or drag and drop an attachment. Type @ to mention a user. Type # to reference a record.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'Add your comment&hellip; Type @ to mention a user. Type # to reference a record.',
    'LBL_ACTIVITY_STREAM' => 'Activity Stream',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'Activity Stream is not enabled',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'Activity Stream is not enabled for this module',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'More posts...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => ' on ',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'My Activity Stream',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'View a list of activities performed on records and create and post comments.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'Activity Streams is disabled',

    'LBL_DATA_VIEW' => 'Data View',
    'LBL_COMMENT' => 'Comment',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'There was an error while connecting to the server. Please try again.',
    'ERR_RESOLVE_ERRORS' => 'Please complete all required fields before saving.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'In order to Approve, all required fields must be filled in; however, you may still Reject or Route this record.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'In order to Reject/Route all required fields must be filled in.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'Refresh list',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'Refresh Tiles',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'more',
    'LBL_TEXTAREA_LESS' => 'less',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} attachments',
    'LBL_CREATE_ATTACHMENT' => 'Create attachment',
    'LBL_DASHLET_REFRESH' => 'Refresh',
    'LBL_DASHLET_MOVE' => 'Move',
    'LBL_DASHLET_CLOSE' => 'Close',

    'LBL_DASHLET_FORECAST_NAME' => 'In Forecast',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'Forecast Bar Chart',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Forecast Bar Chart',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'Forecast for',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'Displays the Forecast Bar Chart for a specific Time Period',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'Group By',
    'LBL_DASHLET_FORECASTS_DATASET' => 'Dataset',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'Forecasts Details',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'Displays current Forecast details.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'Saved Reports Chart Dashlet',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'Displays any chart from a saved report.',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'Published Related Articles',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'Historical Summary',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{{name}}}',
    'LBL_MORE_HISTORY' => 'More history...',
    'LBL_RELATED_CONTACT' => 'Related Contact',
    'LBL_MODULE_TYPE' => 'Type',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'Email To',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'Email From',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'Legacy modules cannot be previewed',

    //SFA
    'LBL_BEST' => 'Best',
    'LBL_WORST' => 'Worst',
    'LBL_LIKELY' => 'Likely',
    'LBL_BEST_FORECAST' => 'Commitment (Best)',
    'LBL_WORST_FORECAST' => 'Commitment (Worst)',
    'LBL_LIKELY_FORECAST' => 'Commitment (Likely)',
    'LBL_BEST_ADJUSTED' => 'Adjusted Commitment (Best)',
    'LBL_WORST_ADJUSTED' => 'Adjusted Commitment (Worst)',
    'LBL_LIKELY_ADJUSTED' => 'Adjusted Commitment (Likely)',
    'LBL_AMOUNT_USDOLLAR' => 'Converted Amount',
    'LBL_OVERDUE' => 'Overdue',

    'LBL_PASSWORD_REQUEST_SENT' => 'Your request has been submitted.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'There was a problem retrieving your username and email combination.',

    'LBL_REMINDER_TITLE' => 'Reminder',
    'LBL_CLICK_TO_DRILLDOWN' => 'Click to drilldown',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'You can not disable all languages.',

    'LBL_UPDATE_CALC_FIELDS' => 'Recalculate Values',

    //Optimistic Locking
    'LBL_YOU' => 'You',
    'LBL_RESOLVE_CONFLICT' => 'Resolve Conflict for {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'For more information, refer to the {{{more_info_url}}} {{plural_module_name}} documentation.{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'No Data Available',
    'LBL_NEED_HELP' => 'Need help with something new?',
    'LBL_NEW_CASE' => 'New Case',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'The help dashlet provides specific information pertaining to the module you are currently viewing along with a link to the corresponding documentation (e.g. Leads documentation) in the Application guide for more information.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'List View Help',
    'LBL_HELP_RECORDS' => "A module's list view displays all records meeting the current search criteria and to which users have access. You can view the basic details of each record within the field columns of the list view or click the record's name to open the record view.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'Record View Help',
    'LBL_HELP_RECORD' => 'This record view provides thorough information about an individual record as well as some details of the records linked to it.

- Edit this record\'s fields by clicking an individual field or the Edit button.
- View or modify links to other records in the subpanels by toggling the bottom left pane to "Data View".
- Interact with user comments and view record change history by toggling the bottom left pane to "Activity Stream".
- Follow or favorite this record using the icons to the right of the record name.
- Additional actions are available in the dropdown Actions menu to the right of the Edit button.',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}} Creation',
    'LBL_HELP_CREATE' => 'To create {{plural_module_name}}:
1. Provide values for the fields as desired.
 * Fields marked "Required" must be completed prior to saving.
 * Click "Show More" to expose additional fields if necessary.
2. Click "Save" to finalize the new record and return to the {{plural_module_name}} list view.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'Potential Duplicate Detected',
    'LBL_HELP_DUPLICATE' => 'Sugar has detected that the record you are trying to create may already exist.

To modify an existing record rather than creating a new one, click "Select and edit" to the right of the desired record. Any blank fields on the existing record will be filled in with the values you have just entered. Click "Save" to make these changes to the existing record.

If, instead, you wish to use the values you have just entered instead of the values on the existing record, click "Reset to original". The values you entered will then be applied to the existing record, and you may now provide any additional changes and click "Save" to finalize modifications to the existing record.

To create a new record using the values you have entered, click "Ignore Duplicate and Save" at the top right of the screen.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'Missing SMTP Server settings',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'To send record assignment notifications, an SMTP server must be configured in {{emailSettingsUrl}}.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'Email Settings',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'New Stock Reports Available',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'New Stock reports are available in your ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'Reports module',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'They are tagged as "Stock Report" and can be filtered. Reports are also tagged as "Sales and Marketing", "Customer Service", "Data Privacy" or "Administrative" based on the content. For more information, refer to the ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'documentation',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM enables power users to quickly perform certain tasks with keyboard shortcuts to increase productivity. The tables on the right describe available shortcuts along with the keys and the actions they perform.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>Supported keys</h1><ul><li>all alphanumeric characters and symbols</li><li>shift, ctrl, alt, command, mod (ctrl in Windows/Linux and command in Macs)</li><li>enter, esc, space, tab, pageup, pagedown, end, home, ins, del, backspace</li></ul><h1>Supported features</h1><ul><li>Key combination: ctrl+m</li><li>Multiple keys: m,ctrl+m</li><li>Key sequence: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'Global Shortcuts',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'Contextual Shortcuts',
    'LBL_SHORTCUT_KEY_KEY' => 'Key',
    'LBL_SHORTCUT_FUNCTION' => 'Function',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Configure Contextual Shortcuts',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'No contextual shortcuts to configure',
    'LBL_SHORTCUT_HELP' => 'Show shortcuts help page',
    'LBL_SHORTCUT_QUICK_CREATE' => 'Toggle the quick create menu',
    'LBL_SHORTCUT_SEARCH' => 'Focus on global search field',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'Toggle sidebar',
    'LBL_SHORTCUT_CREATE_RECORD' => 'Create new record',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'Select next record on the list',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'Select previous record on the list',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'Scroll list left',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'Scroll list right',
    'LBL_SHORTCUT_OPEN' => 'Open selected record on the list',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'Edit selected record on the list',
    'LBL_SHORTCUT_RECORD_DELETE' => 'Delete record',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Exit out of list inline edit mode without saving',
    'LBL_SHORTCUT_RECORD_SAVE' => 'Save record',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'Clear out any changes to the record',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'Mark record as favorite',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'Follow record',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'Preview record',
    'LBL_SHORTCUT_MARK_SELECTED' => 'Mark record as selected',
    'LBL_SHORTCUT_SELECT_ALL' => 'Select all',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'Open mass action dropdown menu',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'Focus on list filter field',
    'LBL_SHORTCUT_FILTER_CREATE' => 'Create a new list filter',
    'LBL_SHORTCUT_FILTER_EDIT' => 'Edit current list filter',
    'LBL_SHORTCUT_FILTER_SHOW' => 'Open list filter menu',
    'LBL_SHORTCUT_RECORD_EDIT' => 'Edit record',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'Open previous record',
    'LBL_SHORTCUT_RECORD_NEXT' => 'Open next record',
    'LBL_SHORTCUT_COPY_RECORD' => 'Copy current record',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'Open primary action dropdown menu',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'Close drawer',
    'LBL_SHORTCUT_FILTER_ADD' => 'Add additional criteria to filter',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'Remove last criteria from filter',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'Close filter',
    'LBL_SHORTCUT_FILTER_SAVE' => 'Save filter',
    'LBL_SHORTCUT_FILTER_DELETE' => 'Delete filter',
    'LBL_SHORTCUT_FILTER_RESET' => 'Reset filter',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'Add row',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'Remove row',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'Close mass update',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'Update records',
    'LBL_CREATE_CATEGORY' => 'Create a <div class="btn-link" data-action="create-new">category</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'Confirm',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'Cancel',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'Select all items in a multi-select field',
    'LBL_SHORTCUT_SWEETSPOT' => 'Toggle the Sweet Spot bar',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'Hide the Sweet Spot bar',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'Save configuration',
    'LBL_SHORTCUT_RESTORE' => 'Restore default',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'An error occurred while saving custom shortcut keys on the server. Please try again.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}} Settings',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}} configuration settings have been saved.',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} Configuration Error',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} does not have any configuration settings',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'User does not have access to {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'User does not have access to configure {{module}} settings',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'Database settings for {{module}} need to be fixed',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'to',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'Date and Time',

    'LBL_CALENDAR_START_DATE' => 'Start',
    'LBL_CALENDAR_END_DATE' => 'End',
    'LBL_CALENDAR_DURATION' => 'Duration',
    'LBL_CALENDAR_RECURRENCE' => 'Recurrence',
    'LBL_CALENDAR_REMINDERS' => 'Reminders',

    'LBL_CALENDAR_CUSTOM_DATE' => 'Custom Date',
    'LBL_CALENDAR_REPEAT_TYPE' => 'Repeat Type',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'Repeat Interval',
    'LBL_CALENDAR_REPEAT_DOW' => 'Repeat on Days of Week',
    'LBL_CALENDAR_REPEAT_ON' => 'Repeat On',
    'LBL_CALENDAR_REPEAT' => 'Repeat',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'Repeat Until',
    'LBL_CALENDAR_REPEAT_COUNT' => 'Repeat Occurrences',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'Repeat Selector',
    'LBL_CALENDAR_REPEAT_DAYS' => 'Day(s) of Month',
    'LBL_CALENDAR_REPEAT_MONTH' => 'Month(s) of Year',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'Repeat Ordinal',
    'LBL_CALENDAR_REPEAT_UNIT' => 'Repeat Unit',
    'TPL_REPEAT_INTERVAL' => 'Every {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'This series uses a Repeat On option that is not available in Sugar because the series was synced from a calendar client. Please edit this series in your calendar client if you would like to keep repeating on a specific date. Editing this series in Sugar will set Repeat On to None.<br><br>Would you like to continue?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'Recurrence changes must be made using the first record in the series.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'Recurrence rules do not result in an event being generated.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'Attending',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'Declined',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'Tentative',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'No Reply',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'Schedule Unavailable',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'Available Views',
    'LBL_CALENDAR_DASHLET_NAME' => 'Calendar Scheduler',
    'LBL_CALENDAR_DASHLET_DESCRIPTION' => 'Calendar',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'Default View',
    'LBL_CALENDAR_MY_CALENDARS' => 'My Calendars',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'User and Team Calendars',
    'LBL_CALENDAR' => 'Calendar',

    'LBL_CALENDAR_DAY' => 'day',
    'LBL_CALENDAR_WEEK' => 'week',
    'LBL_CALENDAR_MONTH' => 'month',
    'LBL_CALENDAR_YEAR' => 'year',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21st',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31st',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41st',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51st',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61st',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71st',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81st',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91st',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92nd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93rd',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98th',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99th',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'Error occurred while retrieving schedule.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'Save and Send Invites',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'Accept Status',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'Processes',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'Processes dashlet displays the templates that can be used inside of SugarBPM.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'Process Definitions',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'Process Definitions dashlet displays the templates that can be used inside of SugarBPM.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'Create Process Definition',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'Import Process Definitions',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'Process Business Rules',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'Process Business Rules dashlet displays the templates that can be used inside of SugarBPM.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'Create Process Business Rule',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'Import Process Business Rules',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'Process Email Templates',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'Process Email Templates dashlet displays the templates that can be used inside of SugarBPM.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'Create Process Email Template',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'Import Process Email Templates',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'When developing processes/business rules/email templates in another instance of Sugar, we strongly recommend that the instance is an exact clone of your production system. Processes/business rules/email templates built in an independent instance of Sugar may not function as desired after importing completes. Processes/business rules/email templates may rely on specific Studio or application-level changes including but not limited to custom field names, dropdown values, database IDs, etc. If these values are not identical from the instance where the process/business rule/email template was built, you may need to manually rebuild the process/business rule/email template in your target instance.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'Would you still like to proceed with this import?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'Would you still like to proceed with this export?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'The following dropdown fields contain invalid options',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'Pending Activities by Process',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'Pending Activities',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'Pending Activities by Process',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'All Processes',
    'LBL_RECORD_DASHBOARD' => 'Record Dashboard',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'Process Status Summary',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'Process Status Description',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'In Progress',
    'LBL_PMSE_COMPLETED_STATUS' => 'Completed',
    'LBL_PMSE_CANCELLED_STATUS' => 'Cancelled',
    'LBL_PMSE_TERMINATED_STATUS' => 'Terminated',
    'LBL_PMSE_ERROR_STATUS' => 'Error',
    'LBL_PMSE_SETTINGS' => 'SugarBPM Settings',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'Are you sure you want to disable this record?',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'Are you sure you want to enable this record?',
    'LBL_PRO_DELETE_CONFIRMATION' => 'Are you sure you want to delete this record?',

    'LBL_PRO_ENABLE' => 'Updating',
    'LBL_PRO_DISABLE' => 'Updating',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} is participating in a process and may contain some locked fields. To edit the record, click here {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'This field is locked because it is involved in a running process.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'This record is participating in a process and may contain some locked fields.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'Business Center',
    'LBL_BUSINESS_CENTER_ID' => 'Business Center ID',
    'LBL_BUSINESS_CENTER_NAME' => 'Business Center Name',

    'LBL_PLIS_ACTIVITIES' => 'Purchased Line Items Activities',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(New Tag)',
    'LBL_TAG_FETCH_ERROR' => 'An error has occurred while retrieving tags.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'Sugar 7 requires javascript. Please enable Javascript in your browser to use Sugar 7.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'Serialized data could not be unserialized',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'Serialized data could not be unserialized because it contains references to objects or classes',

    'LBL_FIELD_TRIMMED' => 'Field was trimmed, due to exceeding the maximum character limit.',
    'LBL_FIELDSIZE_OVERFLOW' => 'Field exceeds maximum character limit.',
    'LBL_TINYMCE_TARGET_SAME' => 'Same window',
    'LBL_TINYMCE_TARGET_NEW' => 'New window',

    'LBL_OUTBOUND_EMAILS' => 'Email Settings',
    'LBL_OUTBOUND_EMAIL' => 'Email Setting',

    'LBL_EMAIL_PARTICIPANTS' => 'Email Participants',
    'LBL_EMAIL_PARTICIPANT' => 'Email Participant',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => '{{email_address}} is opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'Data Privacy',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'Data Privacy',
    'LBL_DATAPRIVACY_VIEW_PII' => 'View Personal Info',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'Mark to Erase',
    'LBL_DATAPRIVACY_FIELDNAME' => 'Field',
    'LBL_DATAPRIVACY_VALUE' => 'Value',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'Changed By',
    'LBL_DATAPRIVACY_SOURCE' => 'Source',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'Last Updated',
    'LBL_DATAPRIVACY_PII' => 'Personal Info',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'Mark to Erase',
    'TPL_DATAPRIVACY_PII_TITLE' => 'Personal Info for {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'Change Timers',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'Messages',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'Copied to your clipboard!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'Could not copy to your clipboard',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'Copy Confirmation Link',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'Timeline',
    'LBL_NO_ACTIVITY' => 'No Activity',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} Timeline',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'Show more...',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'Show less',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'Timeline displays the current record’s related records and select field updates over time.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'Show more...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'Show less...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'No data available',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'Module not licensed.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'Active Subscriptions',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'This dashlet can only be added for modules which link to a single Account. Refer to the <a href={{linkToDocumentation}} target="_blank">Active Subscriptions dashlet</a> documentation for more information.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'Display Purchases belonging to this linked Account:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'Active subscriptions for a specific Account.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', quantity {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'Total:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'No active subscriptions',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'This dashlet requires {{module_name}} to function. Talk to your administrator about enabling {{module_name}}.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'Purchase History',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'All Purchases for a specific Account.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'This dashlet can only be added for modules which link to a single Account. Refer to the <a href={{linkToDocumentation}} target="_blank">Purchase History dashlet</a> documentation for more information.',
    'LBL_NO_PURCHASE_HISTORY' => 'No Purchases to display',
    'LBL_NO_PLIS' => 'No Purchased Line Items',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'Total',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'Quantity',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'This dashlet requires Purchases and Purchased Line Items to function. Talk to your administrator about enabling Purchases and Purchased Line Items.',
    'LBL_SEARCH_PURCHASE_NAME' => 'Search by Purchase Name...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'Use Studio to edit record view dashlet layout by going to ' .
        'Studio > {{module}} > Layouts > Record View Dashlet. <a href={{linkToStudio}}>Edit in Studio</a>.',
    'LBL_SERVICE_LEVEL' => 'Service Level',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'Number',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'Follow Up',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'Priority/Status',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'Subject/Description',

//Service Duration
    'LBL_SERVICE_DURATION' => 'Service Duration',
    'LBL_SERVICE_DURATION_VALUE' => 'Service Duration Value',
    'LBL_SERVICE_DURATION_UNIT' => 'Service Duration Unit',
    'LBL_LOCK_DURATION' => 'Lock Duration',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'The Amazon Connect CCP was unable to load. Please' .
        'ensure you are using a ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">supported browser</a>. ' .
        'If the problem persist, please contact your Sugar Administrator.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Your Sugar Administrator has not configured your instance for Amazon Connect.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Unable to establish connection with Amazon Connect. Please contact your Sugar Administrator for assistance.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'Unknown',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'Focus Dashboard',
    'LBL_CLOSE_FOCUS_DRAWER' => 'Close Focus Dashboard',
    'LBL_EXTERNAL_GUESTS' => 'External Guests',
    'LBL_MY_FAVORITE_TASKS' => 'My Favorite Tasks',
    'LBL_RECORD' => 'Record',

    'LBL_MY_TASKS' => 'My Tasks',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'Could not find field: {0} in module: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'Could not find record with {0}: {1} in module: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'Could not find a relationship named: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'A database entry of id: {0}, with {1}: {2} in module: {3} already exists',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'soft deleted (with deleted flag = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'Found multiple database records for {0} {1} on module {2}. ' .
        'Please remove or update the matching records accordingly. Matching records: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'Next Run',
    'LBL_TIME_AWARE_TYPE' => 'Type',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'Display Label',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'Open Record View',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'Add',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'Help not available',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'Functions',
    'LBL_ACTIONBUTTON_FIELDS' => 'Fields',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'Select Field...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Rollup',
    'LBL_ACTIONBUTTON_RELATED' => 'Related',
    'LBL_ACTIONBUTTON_SAVE' => 'Save',
    'LBL_ACTIONBUTTON_CANCEL' => 'Cancel',
    'LBL_ACTIONBUTTON_R_MODULE' => 'Related Module',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'Related Fields',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'Rollup Module',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'Rollup Fields',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'Rollup Function',
    'LBL_ACTIONBUTTON_MINIMUM' => 'Min',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'Max',
    'LBL_ACTIONBUTTON_AVERAGE' => 'Average',
    'LBL_ACTIONBUTTON_SUM' => 'Sum',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'Assign Record',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'Compose Email',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'Create Record',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Doc Merge',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'Open Url',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'Run Report',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'Update Record',
    'LBL_ACTIONBUTTON_ACTION' => 'Action',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'Assign To',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'Email To',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'Use BPM Template',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'Template',
    'LBL_ACTIONBUTTON_MODULE' => 'Module',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'Display Settings',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'Type',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'Dropdown',
    'LBL_ACTIONBUTTON_BUTTON' => 'Button',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'Button Group',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'Display Label on Record',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'Display Button on Record View Header',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'Hide on Record View Edit',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'Display on Focus Dashboard Header',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'Dashboard',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'Focus Dashboard Header',
    'LBL_ACTIONBUTTON_SIZE' => 'Size',
    'LBL_ACTIONBUTTON_DEFAULT' => 'Default',
    'LBL_ACTIONBUTTON_SMALL' => 'Small',
    'LBL_ACTIONBUTTON_LARGE' => 'Large',
    'LBL_ACTIONBUTTON_CALCULATED' => 'Calculated',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'Convert to PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Doc Merge',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'Preview',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'Properties',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'Button Text',
    'LBL_ACTIONBUTTON_DESC' => 'Tooltip',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'Show Button Text',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'Show Icon',
    'LBL_ACTIONBUTTON_SCHEME' => 'Color Scheme',
    'LBL_ACTIONBUTTON_ICON' => 'Icon',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'Dependent',
    'LBL_ACTIONBUTTON_DESIGN' => 'Layout Configuration',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'Stop on Error',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'Auto Save',
    'LBL_ACTIONBUTTON_CONFIG' => 'Config',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'Please configure your ActionButton before saving.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'Configure Buttons',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'Auto Create',
    'LBL_ACTIONBUTTON_LINK' => 'Create Relationship to Parent',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'Copy Parent Values',
    'LBL_ACTIONBUTTON_PRESET' => 'Set Field Value(s)',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'Copy Field Value(s) From Parent',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'Select...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'From Parent Field ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'Are you sure you want to delete this button?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'Are you sure you want to delete this action?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'Invalid Action Button Data',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'Please select a module before saving.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'Please select a link before saving. If no link is available, please uncheck the link option.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'Please select a record before saving.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'Please select a template before saving.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'Primary',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'Secondary',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'Ocean',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'Pink',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'Army',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'Teal',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'Pacific',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'Green',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'Yellow',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'Orange',
    'LBL_ACTIONBUTTON_THEME_RED' => 'Red',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'Coral',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'Purple',
    'LBL_ACTIONBUTTON_FORMULA' => 'Formula',
    'LBL_ACTIONBUTTON_ACTIONS' => 'Actions',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'Error validating button data.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'Buttons need to have at least a label or an icon set.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'Please input a valid button label.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'The record could not be created due to missing required values. Please contact your administrator.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'You must have at least two active buttons for this button type.',
    'LBL_ACTIONBUTTON_RECORD' => 'Buttons',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'Action Menus',
    'LBL_ACTIONBUTTON_ORDER' => 'Order',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'List View',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'Record View Header',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'Record View Dashlet Header',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'Subpanels',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'The task sequence execution engine failed executing the following actions: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'Add an Action',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'Remove this Action',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'Current User',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'Doc Merge',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'Doc Merge to PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'Company Size',
    'LBL_HINT_COMPANY_INDUSTRY' => 'Industry',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'Industry Tags',
    'LBL_HINT_COMPANY_LOCATION' => 'Company Location',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'Company Description',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'Year Founded',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Company Facebook',
    'LBL_HINT_COMPANY_TWITTER' => 'Company Twitter',
    'LBL_HINT_COMPANY_PIC' => 'Company Logo',
    'LBL_HINT_CONTACT_PIC' => 'Contact Photo',
    'LBL_HINT_COMPANY_WEBSITE' => 'Company Website',
    'LBL_HINT_PHOTO' => 'Photo Link',
    'LBL_HINT_JOB_2' => 'Previous Jobs',
    'LBL_HINT_EDUCATION' => 'Education',
    'LBL_HINT_EDUCATION_2' => 'Education Additional',
    'LBL_HINT_TWITTER' => 'Twitter Link',
    'LBL_HINT_FACEBOOK' => 'Facebook Link',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS Code',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC Code',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'FY End',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'Annual Revenue',
    'LBL_HINT_PHONE_1' => 'Phone 1',
    'LBL_HINT_PHONE_2' => 'Phone 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'Join table',
    'LBL_HINT_FULL_NAME' => 'Full Name',
    'LBL_HINT_JOB_TITLE' => 'Job Title',
    'LBL_HINT_OFFICE_PHONE' => 'Office Phone',
    'LBL_HINT_MOBILE_PHONE' => 'Mobile',
    'LBL_HINT_OTHER_PHONE' => 'Other Phone',
    'LBL_HINT_WEBSITE' => 'Website',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'Would you like to overwrite all the existing data for this record with the new data found in Sugar Hint?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'Would you like to overwrite the existing {{fieldName}} for this record with new {{fieldName}} found in Sugar Hint?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'All account related data will be removed, Are you sure you want to continue ?',
    'LBL_HINT_COMPANY_LOGO' => 'Logo',
    'LBL_HINT_CONTACTS_AVATAR' => 'Photo',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint Accountsets Tags',

    'LBL_HINT_LOADING' => 'Loading ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Uninstalling Sugar Hint, please wait',
    'LBL_HINT_VALUE_ERASED' => ' Value Erased ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'This information was erased via data privacy request',

    'LBL_HINT_UNINSTALL_TITLE' => 'Please select one of the uninstall options from below:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Uninstall Hint package only',
    'LBL_HINT_UNINSTALL_FULL' => 'Uninstall Hint completely',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'This option will remove the Hint MLP and disable all active subscriptions to Sugar Hint Insights.
    Reinstalling Hint will automatically reactivate subscriptions.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'This option will perform a full uninstall of Hint, including removal of the MLP and deletion of all configuration and subscription information.',
    'LBL_HINT_UNINSTALL' => 'Uninstall',
    'LBL_HINT_UNINSTALL_HEADER' => 'Uninstall Sugar Hint',
    'LBL_HINT_CANCEL' => 'Cancel',
    'LBL_HINT_UNINSTALL_WARNING1' => 'WARNING: Choose this option only if you do not intend to use Hint again in the future.
    Before performing the uninstall, complete a full backup of your Sugar database and put Sugar into maintenance mode. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'See the ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint Administration Guide ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'for details on the uninstall process.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Are you sure you want to uninstall the Sugar Hint package only?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Are you sure you want to uninstall the Sugar Hint completely?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(NOTE: YOU CANNOT UNDO THIS ACTION)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint Fields',
    'LBL_HINT_NO_RESULTS_MSG' => 'No results were found.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'Basic Hint Panel Layout',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'Accounts',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'Contacts',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'Leads',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'Expanded Hint Panel Layout',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'Rearrange the fields by dragging and dropping within the Hint Panel Layout sections above.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'For detailed instructions and a list of default fields, refer to the ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' to restore default settings for the ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'module.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'Are you sure you want to restore back to the defaults for the {{module}} module ?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'Click Here',
    'LBL_HINT_CONFIG_NAME' => 'Hint Administration Guide.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'Fields',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'Enriched Fields',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'This section lists all Hint fields and Sugar fields that are enriched by Hint. Hint fields are marked with an asterisk (*) and can only be shown in the Hint panel if they are enriched.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'Field Name',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'Enrich Field',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Show in Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Show in Hint Panel',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'Additional Sugar Fields',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'This section lists all Sugar fields that are not enriched by Hint.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'Warning',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'Caution: You are about to sync with the Sugar Hint Insights service. Any pending email digest stories will be lost, and existing news will be cleared from the Insights dashlet. Notifications of all types will resume after the sync completes.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'Suggested companies related to your {{_moduleSingular}} are listed below. Select company data to display.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'No account is selected',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'Multiple emails found, select emails to import: ',

    'LBL_HINT_HELP_MESSAGE1' => 'Based on the data entered, Hint was not able to find a match in the system.',
    'LBL_HINT_HELP_MESSAGE2' => 'Best results in Hint can be found with a person\'s name and email address.',
    'LBL_HINT_HELP_MESSAGE3' => 'Best results in Hint can be found with the company website url.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "Enter your {{_moduleSingular}}'s company name or website and Hint will search for additional data.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "Enter your {{currentModule}}'s email address and Hint will search for additional data.",

    'LBL_HINT_HISTORY_NONE' => 'No data available for historical view',
    'LBL_HINT_HISTORY_TITLE' => 'Activity History',

    'LBL_HINT_PREVIEW_TITLE' => 'Data enrichment',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'The license for your Hint service has expired. Contact your SugarCRM admin to renew your license.',
    'LBL_HINT_PREVIEW_QUESTION' => 'Want to see what Hint can do for you and your company? Contact your SugarCRM admin to add Hint.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'Account information not found',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'Enriched data found - click to save all enriched data to your record.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'Click to save enriched data to your record.',

    'LBL_HINT_CONTACTS_TITLE' => 'Related Contacts',
    'LBL_HINT_CONTACTS_NONE' => 'No related contacts',

    'LBL_HINT_NEWS' => 'News',
    'LBL_HINT_GENERAL' => 'General',
    'LBL_HINT_ALL_NEWS' => 'All News',
    'LBL_HINT_FILTER_NEWS' => 'Filter News',
    'LBL_HINT_FINANCIAL_NEWS' => 'Financial',
    'LBL_HINT_PERSONNEL_NEWS' => 'Personnel',
    'LBL_HINT_PRESS_RELEASES' => 'Press Releases',
    'LBL_HINT_OTHER_NEWS' => 'Other',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'Search news articles',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'No news available',
    'LBL_NEW_NOTIFICATIONS' => 'New notifications',
    'LBL_HINT_DASHLET_ALLOWED1' => 'You must have a Sugar Hint license to view the Sugar Hint Insights dashlet.
    Ask your administrator about getting a Sugar Hint license.',

    'LBL_HINT_FOR' => 'For',
    'LBL_HINT_WITH' => 'with',
    'LBL_HINT_SHOW_ME' => 'Show me: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'Notify me by: ',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insights Preference Center',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'Preference Option Key',
    'LBL_HINT_PREFERENCES' => 'Preferences',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'Delete disabled, minimum of one preference statement required',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'Add disabled, you have reached maximum of preference statements',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Include in Sugar Hint Insights dashlet',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'Pop-up as desktop notification',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'Notifications must be enabled on all browsers and on all desktop computers to consistently receive notifications.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Some browsers, like Internet Explorer, do not support notifications. Notifications cannot be enabled when using a browser that does not support notifications.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'Send instant email alert for each notification',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'Send a daily email digest',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'Send a weekly email digest',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'Preferences could not be saved. Check your system connection and try again.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'Some required fields are missing a value. Please check your preferences and ensure that all required fields are filled in.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'You are about to enable browser notifications for Sugar Hint Insights. Click Confirm to proceed. Your browser will then ask you for permission to allow receiving notification events.',
    'LBL_HINT_PUSH_ERROR' => 'Push Notifications plugin has been registered for {{options.type}} without its dependencies. The plugin will not work as intended, please be sure that you provide a path to the worker file and a method for saving the subscription on the server.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'Turn ON Hint notifications for all users',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'Turn OFF Hint notifications for all users',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'WARNING: Failed to disable notifications during uninstallation of Sugar Hint. To disable notifications, install Sugar Hint 5.4.0 or higher and perform a complete uninstall using the Sugar Hint Uninstaller found in the Administration section of Sugar.',
    'LBL_HINT_ENRICH_ALL' => 'Enrich All',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'Hint License Required',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'Maps Configuration',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'Geocoder Log Viewer',
    'LBL_MAP_MAP' => 'Map',
    'LBL_MAP_MAPS' => 'Maps',
    'LBL_MAP_GEOCODING_RECORD' => 'Geocode',
    'LBL_MAP_GEOCODE_SUCCESS' => 'Record has been geocoded successfully.',
    'LBL_MAP_LATITUDE' => 'Latitude',
    'LBL_MAP_LONGITUDE' => 'Longitude',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'Search by address...',
    'LBL_MAP_ALREADY_GEOCODED' => 'Current record is already geocoded. Are you sure you want to overwrite the geocoding for this record?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'Manual Geocoding',
    'LBL_MAP_POINT_COORDINATES' => 'Map Point Coordinates',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'Calculating the optimal route...',
    'LBL_MAP_DIRECTIONS' => 'Directions',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'Directions starting from Current User',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'Directions starting from this record',
    'LBL_MAPS_RADIUS_INPUT' => 'Radius (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'in a Radius from Zip Code',
    'LBL_MAPS_DISTANCE' => 'Distance',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'Zip Code',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'Invalid Config: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> field mappings is invalid.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'Map Type',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'Zoom Level',
    'LBL_MAPS_DASHLET' => 'Maps',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'Displays geocoded record(s) on map.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'Maps is not available for this module. Please enable it in Admin console.',
    'LBL_MAP_MODULES' => 'Module',
    'LBL_MAP_FILTER_BY' => 'Filter By',
    'LBL_MAP_UNIT_TYPE' => 'Unit Type',
    'LBL_MAP_UNIT_TYPE_MILES' => 'Miles',
    'LBL_MAP_UNIT_TYPE_KM' => 'Kilometers',
    'LBL_MAP_ADDRESS' => 'Address',
    'LBL_MAP_NO_STARTING_POINT' => 'Starting point in not geocoded.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'Starting point record is not geocoded.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'Some of the selected records are not geocoded and will not be displayed on map.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'Record(s) is not geocoded.',
    'LBL_MAPS_MODULE_FIELDS' => 'Module Fields',
    'LBL_MAPS_SELECT_FIELD' => 'Select Field',
    'LBL_MAPS_RELATE_RECORD' => 'Related Record',
    'LBL_MAPS_MAPPING_TYPE' => 'Mapping Type',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'No Geocoded Records',
    'LBL_MAPS_ADDRESS' => 'Address',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'Assigned User',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'Street side view not available for given point',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> records are not valid for mapping. Please remove the module from the list.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'Close',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'Expand',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'Save as PDF',
    'LBL_MAPS_EMAIL_LINK' => 'Email Link',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'You must have at least one geocoded record.',
    'LBL_MAPS_GENERATING' => 'Generating map...',
    'LBL_MAPS_POINTS' => 'Map Points',
    'LBL_MAPS_POINT' => 'Point',
    'LBL_MAPS_TRAVEL_DETAILS' => 'Travel Details',
    'LBL_MAPS_TOTAL_DISTANCE' => 'Total Distance',
    'LBL_MAPS_TOTAL_DURATION' => 'Total Duration',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'Total Duration without traffic',
    'LBL_MAPS_ITINERARY' => 'Itinerary',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'Travel Distance',
    'LBL_MAPS_TRAVEL_DURATION' => 'Travel Duration',
    'LBL_MAPS_TRAVEL_STEPS' => 'Steps',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'Warnings',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Maps supports a maximum of 10 pinpoints on a shared map. Please review your selection.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'Maps License Required',
    'LBL_MAPS_SHARE_HELLO' => 'Hello,',
    'LBL_MAPS_SHARE_HEADER' => 'You have requested a Bing map for the following points:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'The following URL will open a map containing the above points on Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Show Map on Bing Maps',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'No route was found for the waypoints provided.',
    'LBL_MAPS_GEOCODE_STATUS' => 'Geocode Status',
    'LBL_MAPS_GEOCODED' => 'Geocoded',
    'LBL_MAPS_NOT_GEOCODED' => 'Not geocoded',
    'LBL_MAPS_NOT_FOUND' => 'Invalid Address',
    'LBL_MAPS_GEOCODING_FAILED' => 'Geocoding failed',
    'LBL_MAPS_QUEUED' => 'Queued',
    'LBL_MAPS_REQUEUED' => 'Requeued',
    'LBL_MAPS_RELATED_RECORD' => 'Related Record',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'View Report',
    'LBL_REPORT_DASHLET_DESC' => 'Display a saved report',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'Reset to Dashlet Defaults',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'Reset to Report Defaults',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'Refresh Results',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'Copy Chart to Clipboard',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'Download Chart',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'The report for the dashlet {{label}} was edited and the dashlet has been reset to the default configuration.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'You do not have permission to use this field.',

    'LBL_INVALID_FORMULA' => 'Invalid formula',
    'LBL_RETURN_TYPE_MISSMATCH' => 'Function return type does not match',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'Prediction',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'Ideal Customer Profile',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'Close Week Prediction Scores',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'Prediction Value',
    'LBL_AI_CONV_BIN_ACCURACY' => 'Prediction Bin Accuracy',
    'LBL_AI_CONV_MULTIPLIER' => 'Prediction Multiplier',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP Value',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP Bin Accuracy',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP Multiplier',
    'LBL_AI_NEW' => 'New',
    'LBL_AI_ENTERED' => 'Entered',
    'LBL_AI_CREATED' => 'Created',
    'LBL_AI_WEEK' => 'Week',
    'LBL_AI_MONTH' => 'Month',
    'LBL_AI_QUARTER' => 'Quarter',
    'LBL_AI_BYWEEK' => 'by Week',
    'LBL_AI_BYMONTH' => 'by Month',
    'LBL_AI_BYQUARTER' => 'by Quarter',
    'LBL_AI_WEEKTREND' => 'Weekly trend',
    'LBL_AI_MONTHLYTREND' => 'Monthly trend',
    'LBL_AI_QUARTERTREND' => 'Quarterly trend',
    'LBL_AI_TREND' => 'Trend by',
    'LBL_AI_TRENDS' => 'Trends by',
    'LBL_AI_VELOCITY' => 'Velocity',
    'LBL_AI_TOPX' => 'Top {X}',
    'LBL_AI_TIMESPAN' => 'Time Span between stages -',
    'LBL_AI_BUSINESSTREND' => 'with Business Trends',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Introducing Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights leverages quantitative analysis to generate new insights into your SugarCRM data. At Sugar, we are always looking for new ways to help you get the most out of your data, make informed decisions, and this is just the beginning of what we hope to offer with Sugar Insights.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights leverages quantitative analysis to generate new insights into your SugarCRM data.',
    'LBL_AI_FIRMO' => 'Firmographics',
    'LBL_AI_TOTALCOUNT' => 'Total count of',
    'LBL_AI_DAYSFROMLATESTACT' => 'Days since last',
    'LBL_AI_DAYSSINCE' => 'age',
    'LBL_AI_FIELDISSET' => 'exists',
    'LBL_AI_CONTACTCOMPLETENESS' => 'Completeness of Contact information',
    'LBL_AI_CUTDATE' => 'Prediction period',
    'LBL_AI_FROMLASTCHANGE' => 'Days from last feature value change',
    'LBL_AI_CALLSHELD' => 'Total count of calls held',
    'LBL_AI_CALLSPLANNED' => 'Total count of calls planned',
    'LBL_AI_OUTBOUNDCALLS' => 'Total count of outbound calls',
    'LBL_AI_INBOUNDCALLS' => 'Total count of inbound calls',
    'LBL_AI_AVGCALLDURATION' => 'Average duration of calls',
    'LBL_AI_EMAILSARCHIVED' => 'Total count of archived emails',
    'LBL_AI_EMAILSREAD' => 'Total count of emails read',
    'LBL_AI_EMAILSSENT' => 'Total count of emails sent',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'Total count of records where Expected Close Date is changed to a later date',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'Total count of records where Expected Close Date is changed to a sooner date',
    'LBL_AI_AMOUNTINCREASED' => 'Total opportunties where amount increased',
    'LBL_AI_AMOUNTDECREASED' => 'Total opportunties where amount decreased',

    // User last state
    'LBL_LAST_STATE' => 'Last state',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'Send to DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'Cancel edit recipient',
    'LBL_RECIPIENT_ROLE' => 'Recipient role',
    'LBL_DASHLET_DOCUSIGN_NAME' => 'DocuSign',
    'LBL_DASHLET_DOCUSIGN_DESCRIPTION' => 'Send documents using DocuSign and track status.',
    // Base sales stages
    'LBL_OPEN' => 'Open',
    'LBL_CLOSED_WON' => 'Closed Won',
    'LBL_CLOSED_LOST' => 'Closed Lost',
    'LBL_KIOSK_ADD_FILES' => 'Add files',
    'LBL_KIOSK_ADD_DROP_FILES' => 'Add or drop files here',
    'LBL_KIOSK_CANCEL' => 'Cancel',
    'LBL_KIOSK_EDIT' => 'Edit',
    'LBL_KIOSK_EMAIL' => 'Email',
    'LBL_KIOSK_FILES_UPLOADING' => 'Uploading',
    'LBL_KIOSK_FILES_ERROR' => 'Attachment failed to upload',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'Attachment is too large',
    'LBL_KIOSK_FILTER_SEARCH' => 'Search',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'Kiosk',
    'LBL_KIOSK_LANGUAGE' => 'Language',
    'LBL_KIOSK_LAST_UPDATED' => 'Last Updated',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'View',
    'LBL_KIOSK_MENU' => 'Menu',
    'LBL_KIOSK_MOBILE_PHONE' => 'Mobile Phone',
    'LBL_KIOSK_MY_ACTIVITIES' => 'My Activities',
    'LBL_KIOSK_MY_PROFILE' => 'My Profile',
    'LBL_KIOSK_NAME' => 'Name',
    'LBL_KIOSK_OFFICE_PHONE' => 'Office Phone',
    'LBL_KIOSK_ORGANIZATION' => 'Organization',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'Rows per page:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'Powered by SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'Save Changes',
    'LBL_KIOSK_SHOW_HIDE' => 'Show/Hide',
    'LBL_KIOSK_SIGN_IN' => 'Sign In',
    'LBL_KIOSK_SIGN_OUT' => 'Sign Out',
    'LBL_KIOSK_SORT_BY' => 'Sort by',
    'LBL_KIOSK_SUBMIT' => 'Submit',
    'LBL_KIOSK_TIMEZONE' => 'Timezone',
    'LBL_KIOSK_ACTIVITY' => 'Activity',
    'LBL_KIOSK_NO_ACTIVITY' => 'No activity to display',
    'LBL_KIOSK_OLDEST_FIRST' => 'Oldest first',
    'LBL_KIOSK_NEWEST_FIRST' => 'Newest first',
    'LBL_KIOSK_SHOW_MORE' => 'Show more',
    'LBL_KIOSK_ADD_A_REPLY' => 'Add a reply',
    'LBL_KIOSK_REPLY_EMPTY' => 'Reply cannot be left empty.',
    'LBL_KIOSK_NUM_MORE' => '{{num}} more',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'Welcome',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'Quickly access your resources.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'Search cases',
    'LBL_KIOSK_SHOW_ALL' => 'Show all',
    'LBL_KIOSK_404_TITLE' => 'We couldn\'t find this',
    'LBL_KIOSK_TENANT_404_TITLE' => 'Tenant not found',
    'LBL_KIOSK_404_MESSAGE' => 'The link you clicked has been removed, is temporarily unavailable, or the URL is invalid.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'Please make sure that you have the correct URL. For further assistance, please contact Support.',
    'LBL_KIOSK_BACK_TO_HOME' => 'Back to home',
    'LBL_KIOSK_ERROR_CODE' => '{code} Error: ',
    'LBL_KIOSK_401_TITLE' => 'Unauthorized',
    'LBL_KIOSK_401_MESSAGE' => 'You are not authorized to view this page.',
    'LBL_KIOSK_403_TITLE' => 'Unauthorized',
    'LBL_KIOSK_403_MESSAGE' => 'You do not have access to view this page.',
    'LBL_KIOSK_500_TITLE' => 'Server not responding',
    'LBL_KIOSK_500_MESSAGE' => 'Something went wrong on our end.',
    'LBL_KIOSK_GO_BACK' => 'Go back',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'Duplicate record found',
    'LBL_KIOSK_ACCOUNT' => 'Account',
    'LBL_KIOSK_STATUS' => 'Status',
    'LBL_KIOSK_DEACTIVATE' => 'Deactivate',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'User has been deactivated',
    'LBL_KIOSK_MANAGE_USERS' => 'Manage Users',
    'LBL_KIOSK_LAST_LOGIN' => 'Last Login',
    'LBL_KIOSK_FIRST_NAME' => 'First Name',
    'LBL_KIOSK_LAST_NAME' => 'Last Name',
    'LBL_KIOSK_ROLE' => 'Role',
    'LBL_KIOSK_INVITE' => 'Invite',
    'LBL_KIOSK_SEND_INVITES' => 'Send Invite(s)',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'Invite(s) sent successfully',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'Invite(s) not sent',
    'LBL_KIOSK_REACTIVATE' => 'Reactivate',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'User has been reactivated',
    'LBL_KIOSK_RESET_PASSWORD' => 'Reset Password',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'Reset password email sent',
    'LBL_KIOSK_USER_PROFILE' => 'User Profile',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'Your user has been deactivated. Please contact your administrator.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'Back to login',
    'LBL_KIOSK_REVOKE_INVITATION' => 'Revoke Invitation',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'Invitation revoked successfully',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'Search and Select...',
    'LBL_KIOSK_NO_MATCHES' => 'No matches found',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'Profile has been updated.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'Error updating profile.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'Documents',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'View, search, and download your incoming shared documents.',
    'LBL_KIOSK_CASES' => 'Cases',
    'LBL_KIOSK_CASES_DESC' => 'View, search, and reply to cases shared with you.',
    'LBL_KIOSK_DOWNLOAD' => 'Download',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'File downloaded successfully',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'Getting started',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'To better assist you, please provide us with your first and last name.',
    'LBL_KIOSK_SAVE' => 'Save',
    'LBL_KIOSK_SHARED' => 'Shared',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'Welcome, {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'Background Color',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'Background Image URL',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'It is recommended to choose an image with a file size of less than 400K.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'Background Type',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'Home Background',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'Theme',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'Primary Theme Color',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'App Name',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'This is the title of your application and is shown next to your logo.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'App Logo URL',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'It is recommended to choose a logo that is best viewable in small sizes (e.g., social media profiles). It is also recommended to have a file size less than 200K.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'App Favicon URL',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'A favicon is a small logo that appears beside the page title in a browser tab.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'Auto Reassign Open Activities',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'User Limit Reached',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'Invalid License Key',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'Invalid Application',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'Invalid Application',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'Corrupt Validation Key',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'License Expired',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'Missing Info',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'Missing Validation Key',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'User Missing Access',
    'LBL_DRI_WORKFLOW' => 'Smart Guide',
    'LBL_DRI_WORKFLOWS' => 'Smart Guides',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Smart Guide Stage Template',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Smart Guide Stage Templates',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Smart Guide Template',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Smart Guide Activity Template',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'Activity Templates',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'Web Hooks',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Web Hooks',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'Current Smart Guide Activity At',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Web Hooks',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate Web Hook',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar Actions',
    'LBL_CJ_FORMS' => 'Smart Guide Sugar Actions',
    'LBL_CJ_FORM' => 'Smart Guide Sugar Action',
    'LBL_DRI_SUBWORKFLOW' => 'Smart Guide Stage',
    'LBL_DRI_SUBWORKFLOWS' => 'Smart Guide Stages',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Smart Guide Activity Templates',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Smart Guide Templates',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Smart Guide Order',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Smart Guide Actual Order',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Smart Guide Score',
    'LBL_CJ_MOMENTUM_POINTS' => 'Smart Guide Momentum Points',
    'LBL_CJ_MOMENTUM_SCORE' => 'Smart Guide Momentum Score',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Smart Guide Allow Activity By',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Smart Guide Progress',
    'LBL_CJ_MOMENTUM_RATIO' => 'Smart Guide Momentum Ratio',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Smart Guide Points',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Smart Guide Task',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Smart Guide Parent Activity Type',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Smart Guide Blocked By',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'Smart Guide Blocked By Stages',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Smart Guide Parent Activity Id',
    'LBL_START_NEXT_JOURNEY_ID' => 'Start Next Smart Guide Id',
    'LBL_CJ_URL' => 'Smart Guide Url',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Is Smart Guide Parent Activity',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Smart Guide Momentum Start Date',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Smart Guide Momentum End Date',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'Widget Layout Configuration',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'Widget Layout Configuration',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'Maximum number of Smart Guides from the same template',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'Active',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'Archived',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'Show',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'Hide',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'Vertical Mode',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'Horizontal Mode',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Invalid License',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} has assigned the following Smart Guide activities to {{assigned_user}}.</p>
    <ul>{{activities}}</ul>

    <p>You may review these activities at:<br/>
    <<a href=\"{{module_link}}\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Invalid License',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'User limit has reached, you have {{gracePeriodDays}} days to upgrade the license.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - Assigned Smart Guide Activities',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Your Sugar Automate user limit of {0} has been exceeded<br>
    <br>
    Please contact <a href=\"mailto:customersuccess@sugarcrm.com\">customersuccess@sugarcrm.com</a> to raise the user limit or decrease the number of users using the plugin.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate user limit reached',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Your Sugar Automate license will expire in {0} days. <br>
    <br>
    Please contact SugarCRM or your Sugar Partner to renew and prevent interruption of service.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate license is about to expire',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'Test Webhook',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide Progress',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Displays the Sugar Automate \"Smart Guide Progress\" pie chart.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'Displays the Webhook response',
    'LBL_DASHLET_SEND_LABEL' => 'Send Request',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'Assign me',
    'LBL_COMPLETE_BUTTON_TITLE' => 'Complete',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'Complete All Tasks',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'Delete Stage',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'Start',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'Not Applicable',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'Add Stage',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'View',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Edit Smart Guide',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'Cancel',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'Archive',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'Un-archive',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'Configure Template',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'Add Task',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'Schedule Meeting',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'Schedule Call',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'is in the future',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'is overdue',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'is today',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'is tomorrow',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'Are you sure that you want to cancel this Smart Guide?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'You are about to complete all tasks. Are you sure you want to proceed?',
    'LBL_CJ_BLOCK_BY' => 'You have an unresolved, dependent task: {{Name}}. Please complete this task before Completing All Tasks.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'You have multiple unresolved, dependent task. Please complete these tasks before Completing All Tasks.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'You have successfully completed all tasks',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'Are you sure that you want to archive this Smart Guide?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'Are you sure that you want to un-archive this Smart Guide?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Smart Guides (Focus Drawers & Console)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'View active Smart Guides on Service/Renewals Console and Focus Drawer dashboards.',
    'LBL_CJ_PROCESSING_REQUEST' => 'Processing..',
    'LBL_CJ_SUCCESS' => 'You have successfully completed all tasks',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module} module is not enabled',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'All display settings are saved.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Smart Guide Momentum',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Displays the Sugar Automate "Smart Guide Momentum" gauge chart.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide Progress',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Displays the Sugar Automate "Smart Guide Progress" pie chart.',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'Could not find parent',
    'CJ_NOT_FOUND_EXCEPTION' => 'Could not find {moduleName} with {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'Smart Guide must be completed or cancelled before archiving',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate is not enabled in current Sugar License',
    'LBL_ACTION_NOT_FOUND' => 'Action Not Found, Contact System Administrator',
    'LBL_CJ_SELECT_FIELD' => 'Select Field',
    'LBL_CJ_SELECT_OPERATOR' => 'Select Operator',
    'LBL_CJ_SELECT_VALUE' => 'Select Value',
    'LBL_CJ_ENTER_VALUE' => 'Enter Value',
    'LBL_CJ_FORM_BATCH_TITLE' => 'Saving Smart Guides',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'Active smart guides detected...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'Processing active sugar actions...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'Updating active smart guides...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'The record and associated smart guides have been updated successfully.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'An associated smart guide has failed to update. If the error continues please reach out to your Sugar administrator for assistance.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'An associated smart guide has failed to update. Please review the <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">logs</a> to troubleshoot the error.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => 'The <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} has been linked successfully.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'There was an issue linking the <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}}. If the issue persists, please contact Sugar support.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => 'The {{modulePluralLower}} have been linked successfully.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'There was an issue linking the {{modulePluralLower}}. If the issue persists, please contact Sugar support.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'There was an issue linking the {{moduleSingularLower}}. If the issue persists, please contact Sugar support.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'There is already a {{moduleSingularLower}} named <a href="#{{module}}/{{id}}">{{name}}</a> in the {{stage}} stage.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'A {{moduleSingularLower}} named <a href="#{{module}}/{{id}}">{{name}}</a> has already been selected.',
    'LBL_CJ_ARCHIVED' => 'Archived',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Select Smart Guide Template...',
    'LBL_ALL_SMART_GUIDES' => 'All Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => 'Active Smart Guides',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Archived Smart Guides',
    'LBL_VERTICAL_SCROLL_VIEW' => 'Vertical Stacked View',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'Horizontal Scroll View',
    'LBL_DRI_WORKFLOWS_FILTER' => 'Filter',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'This action cannot be completed. The Status field for this activities\' module is set to "read only", preventing any Smart Guide actions that update the Status field.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'This action cannot be completed. The Status field for this activities\' and or sub-activities\' modules are set to "read only", preventing any Smart Guide actions that update the Status field.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'The Status field for some activities\' modules in the guide are set to "read only", these activities will remain unaltered on guide cancelation.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'Copied to clipboard.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'Delete All Recurrences',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'Invalid recurrence settings',
    'ERROR_INTERVAL_INVALID' => 'Repeat interval must be between 1 and 99',
    'LBL_RECURRENCE_ADD' => 'Configure',
    'LBL_REPEAT_DAYS' => 'Day(s) of Month',
    'LBL_REPEAT_END_TYPES' => 'Repeat',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'Navigation provider',
    'LBL_MOBILE_PDF_EMAIL' => 'Email {{{pdfTemplateName}}} PDF',
    'LBL_MOBILE_EMAIL_SENDING' => 'Sending',
    'LBL_MOBILE_EMAIL_SENT' => 'Sent',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'Email saved as draft.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'Add attachment',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'Upload From Local',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar Document',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'An edit you made to this record has changed this view.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'SugarCRM Mobile App Release Notes',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'SugarCRM Mobile App User Guide',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile cannot be used on a rooted mobile device. Please open the app on an unrooted device.',
    'LBL_VO_BUILD_ROUTE' => 'Build route',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'My distance filter',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'The document will be generated in the background. Open the Document Merges page to access the file.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'Failed to get Template. Contact your administrator for assistance.',
    'LBL_MAP_ERROR_LOAD' => 'Cannot load Map',
    'LBL_MAP_DISTANCE' => 'Distance',
    'LBL_SELECT_UNIT_TYPE' => 'Unit Type',
    'LBL_MAPS_UNIT_MILES' => 'Miles',
    'LBL_MAPS_UNIT_KILOMETERS' => 'Kilometers',
    'LBL_RADIUS' => 'Radius',
    'LBL_ZIP_CODE' => 'Zip Code',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'Choose address',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'Cannot geocode record from address: {{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'Record was not geocoded.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'Record does not contain any address data. Do you want to locate this record on the map manually?',
    'LBL_ERR_SHOW_ON_MAP' => 'Failed to open map for selected records.',
    'LBL_ERR_MISSING_ON_MAP' => 'Some records are missing address data and are not shown',
    'LBL_MAPS_ROUTE' => 'Route',
    'LBL_MAPS_PROVIDER' => 'Sugar Maps',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'Could not determine current location.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'Maximum of {{{num}}} records is supported for mapping.',
    'LBL_ALL_MODULES' => 'All Modules',
    'LBL_DRIVE_SHARE_LINK' => 'Share a link',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'Failed to load files.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'Name cannot be empty',
    'LBL_DRIVE_FOLDER_CREATED' => 'Folder created.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'Failed to create a folder.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'Failed to upload a file.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'Please create a root folder first',
    'LBL_EDIT_ALL_RECURRENCES' => 'Edit All Recurrences',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'File cannot be opened in Dropbox',
    'LBL_FILE_NOT_AVAILABLE' => 'File cannot be opened',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'Directions',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'No route was found for the waypoints provided',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'Nearby',
    'LBL_TAGS' => 'Tags',

    'LBL_CALLER_ID_SETTINGS' => 'Caller ID Settings',
    'LBL_CALLER_ID_ENABLED' => 'Caller ID Enabled',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'On incoming calls, the name of the contact or lead that matches the phone number is displayed.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'To allow the mobile app to display caller IDs, follow these steps on your device:<br><br>1. Open iOS Settings > Phone > Call blocking & identification.<br>2. Enable "{{{brandName}}}".',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'To allow the mobile app to display caller IDs, follow these steps on your device:<br>1. Open the app settings.<br>2. Go to Permissions.<br>3. Enable the Phone permission.<br><br> To set this application as the default Caller ID handler, go to your device settings.<br>1. Navigate to Apps.<br>2. Choose default apps.<br>3. Choose Caller ID and spam app.<br>4. Select this application as the default option.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Check for changes to contact information from records (e.g., Contacts, Leads) in your Sugar instance.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'Go to Settings',
    'LBL_CALLER_ID_SYNC' => 'Sync Record Data',
    'LBL_CALLER_ID_NOT_ENABLED' => 'Caller Id must be enabled in system settings before synchronization.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'Enable',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'Later in the settings',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'This application supports the Caller ID feature.<br> For proper functioning of this feature, after pressing the enable button, you will be prompted to grant two permissions.<br> To ensure the Caller ID feature works correctly, you need to grant permission to manage calls and select this application as the default Caller ID handler.<br> If you do not grant the permission to manage calls, you will also be unable to log calls made from the application.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'To allow the SugarCRM mobile app to display caller IDs, follow these steps on your device:<br><br>1. Open iOS Settings > Phone > Call blocking & identification.<br>2. Enable App.',
    'LBL_MOBILE_LAST_SYNC' => 'Last Sync',
    'LBL_CALLER_ID_SYNCING' => 'Syncing with server.',
    'LBL_NEVER' => 'Never',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} cannot be empty.',
    'LBL_ADD_RELATED_RECORD' => 'Related {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => 'You do not have the required permissions to use caller ID. Please contact your administrator.',
    'LBL_CALLER_ID_FETCHING' => 'Syncing…',
    'LBL_CALLER_ID_FETCH_ALL' => 'Resync all records',
    'LBL_CALLER_ID_FETCH_NEW' => 'Check for record updates',

    'LBL_SORT_BY' => 'Sort by',
    'LBL_PRIMARY_SORT' => 'Primary Sort',
    'LBL_SECONDARY_SORT' => 'Secondary Sort',
    'LBL_OF' => 'of',
    'LBL_TABLE_FREEZE_FIRST' => 'Freeze First Column',
    'LBL_TABLE_SETTINGS_TITLE' => 'Column View Options',
    'LBL_TABLE_SETTINGS_NO_COL' => 'At least one column must be selected.',
    'LBL_TABLE_TOGGLER_INFO' => 'Show or hide columns and drag them into your preferred order.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'Runtime Filters',
    'LBL_FILTER_CONDITION' => 'Select Condition',
    'LBL_FILTER_VALUES' => 'Values',
    'LBL_TABLE_EXPAND' => 'Expand All',
    'LBL_TABLE_COLLAPSE' => 'Collapse All',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'Server error. Could not load relevant runtime filters.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Pub/Sub Module Event Push Subscriptions',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Pub/Sub Module Event Push Subscription',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'Panel - Top',
    'panel_bottom' => 'Panel - Bottom',
    'tab_first' => 'Tab - First',
    'tab_last' => 'Tab - Last',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'Last 7 Days',
    '30' => 'Last 30 Days',
    '90' => 'Last Quarter',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'Today',
    'future' => 'Future',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'Yes',
    'group' => 'No',
];

$app_list_strings['history_filter_options'] = [
    7 => 'Last 7 Days',
    30 => 'Last 30 Days',
    90 => 'Last Quarter',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'Yes',
    'group' => 'No',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'Yes',
    'group' => 'No',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'Yes',
    '0' => 'No',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'This Quarter',
    'next' => 'Next Quarter',
    'year' => 'This Year',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'My Records',
    'group' => 'Group Records',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'My Pipeline',
    'group' => 'My Team\'s Pipeline',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'My Forecast',
    'group' => 'My Team\'s Forecast',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'Opportunities',
    'RevenueLineItems' => 'Opportunities and Revenue Line Items',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'Latest Close Date',
    'earliest' => 'Earliest Close Date',
];

$app_list_strings['moduleList']['Library'] = 'Library';
$app_list_strings['moduleListSingular']['Library'] = 'Library';
$app_list_strings['library_type'] = ['Books' => 'Book', 'Music' => 'Music', 'DVD' => 'DVD', 'Magazines' => 'Magazines'];
$app_list_strings['moduleList']['EmailAddresses'] = 'Email Address';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'Email Address';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'Draft',
    'in-review' => 'In Review',
    'approved' => 'Approved',
    'published' => 'Published',
    'expired' => 'Expired',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--Admin Actions--',
        'Create New Tag' => 'Create New Tag',
        'Delete Tag' => 'Delete Tag',
        'Rename Tag' => 'Rename Tag',
        'Move Selected Articles' => 'Move Selected Articles',
        'Apply Tags On Articles' => 'Apply Tags To Articles',
        'Delete Selected Articles' => 'Delete Selected Articles',
    ];

$app_list_strings['moduleList']['Words'] = 'Words';
$app_list_strings['moduleListSingular']['Words'] = 'Word';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Create Article';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DHABI',
    'ADEN' => 'ADEN',
    'AFGHANISTAN' => 'AFGHANISTAN',
    'ALBANIA' => 'ALBANIA',
    'ALGERIA' => 'ALGERIA',
    'AMERICAN SAMOA' => 'AMERICAN SAMOA',
    'ANDORRA' => 'ANDORRA',
    'ANGOLA' => 'ANGOLA',
    'ANTARCTICA' => 'ANTARCTICA',
    'ANTIGUA' => 'ANTIGUA',
    'ARGENTINA' => 'ARGENTINA',
    'ARMENIA' => 'ARMENIA',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => 'AUSTRALIA',
    'AUSTRIA' => 'AUSTRIA',
    'AZERBAIJAN' => 'AZERBAIJAN',
    'BAHAMAS' => 'BAHAMAS',
    'BAHRAIN' => 'BAHRAIN',
    'BANGLADESH' => 'BANGLADESH',
    'BARBADOS' => 'BARBADOS',
    'BELARUS' => 'BELARUS',
    'BELGIUM' => 'BELGIUM',
    'BELIZE' => 'BELIZE',
    'BENIN' => 'BENIN',
    'BERMUDA' => 'BERMUDA',
    'BHUTAN' => 'BHUTAN',
    'BOLIVIA' => 'BOLIVIA',
    'BOSNIA' => 'BOSNIA',
    'BOTSWANA' => 'BOTSWANA',
    'BOUVET ISLAND' => 'BOUVET ISLAND',
    'BRAZIL' => 'BRAZIL',
    'BRITISH ANTARCTICA TERRITORY' => 'BRITISH ANTARCTICA TERRITORY',
    'BRITISH INDIAN OCEAN TERRITORY' => 'BRITISH INDIAN OCEAN TERRITORY',
    'BRITISH VIRGIN ISLANDS' => 'BRITISH VIRGIN ISLANDS',
    'BRITISH WEST INDIES' => 'BRITISH WEST INDIES',
    'BRUNEI' => 'BRUNEI',
    'BULGARIA' => 'BULGARIA',
    'BURKINA FASO' => 'BURKINA FASO',
    'BURUNDI' => 'BURUNDI',
    'CAMBODIA' => 'CAMBODIA',
    'CAMEROON' => 'CAMEROON',
    'CANADA' => 'CANADA',
    'CANAL ZONE' => 'CANAL ZONE',
    'CANARY ISLAND' => 'CANARY ISLAND',
    'CAPE VERDI ISLANDS' => 'CAPE VERDI ISLANDS',
    'CAYMAN ISLANDS' => 'CAYMAN ISLANDS',
    'CEVLON' => 'CEVLON',
    'CHAD' => 'CHAD',
    'CHANNEL ISLAND UK' => 'CHANNEL ISLAND UK',
    'CHILE' => 'CHILE',
    'CHINA' => 'CHINA',
    'CHRISTMAS ISLAND' => 'CHRISTMAS ISLAND',
    'COCOS (KEELING) ISLAND' => 'COCOS (KEELING) ISLAND',
    'COLOMBIA' => 'COLOMBIA',
    'COMORO ISLANDS' => 'COMORO ISLANDS',
    'CONGO' => 'CONGO',
    'CONGO KINSHASA' => 'CONGO KINSHASA',
    'COOK ISLANDS' => 'COOK ISLANDS',
    'COSTA RICA' => 'COSTA RICA',
    'CROATIA' => 'CROATIA',
    'CUBA' => 'CUBA',
    'CURACAO' => 'CURACAO',
    'CYPRUS' => 'CYPRUS',
    'CZECH REPUBLIC' => 'CZECH REPUBLIC',
    'DAHOMEY' => 'DAHOMEY',
    'DENMARK' => 'DENMARK',
    'DJIBOUTI' => 'DJIBOUTI',
    'DOMINICA' => 'DOMINICA',
    'DOMINICAN REPUBLIC' => 'DOMINICAN REPUBLIC',
    'DUBAI' => 'DUBAI',
    'ECUADOR' => 'ECUADOR',
    'EGYPT' => 'EGYPT',
    'EL SALVADOR' => 'EL SALVADOR',
    'EQUATORIAL GUINEA' => 'EQUATORIAL GUINEA',
    'ESTONIA' => 'ESTONIA',
    'ETHIOPIA' => 'ETHIOPIA',
    'FAEROE ISLANDS' => 'FAEROE ISLANDS',
    'FALKLAND ISLANDS' => 'FALKLAND ISLANDS',
    'FIJI' => 'FIJI',
    'FINLAND' => 'FINLAND',
    'FRANCE' => 'FRANCE',
    'FRENCH GUIANA' => 'FRENCH GUIANA',
    'FRENCH POLYNESIA' => 'FRENCH POLYNESIA',
    'GABON' => 'GABON',
    'GAMBIA' => 'GAMBIA',
    'GEORGIA' => 'GEORGIA',
    'GERMANY' => 'GERMANY',
    'GHANA' => 'GHANA',
    'GIBRALTAR' => 'GIBRALTAR',
    'GREECE' => 'GREECE',
    'GREENLAND' => 'GREENLAND',
    'GUADELOUPE' => 'GUADELOUPE',
    'GUAM' => 'GUAM',
    'GUATEMALA' => 'GUATEMALA',
    'GUINEA' => 'GUINEA',
    'GUYANA' => 'GUYANA',
    'HAITI' => 'HAITI',
    'HONDURAS' => 'HONDURAS',
    'HONG KONG' => 'HONG KONG',
    'HUNGARY' => 'HUNGARY',
    'ICELAND' => 'ICELAND',
    'IFNI' => 'IFNI',
    'INDIA' => 'INDIA',
    'INDONESIA' => 'INDONESIA',
    'IRAN' => 'IRAN',
    'IRAQ' => 'IRAQ',
    'IRELAND' => 'IRELAND',
    'ISRAEL' => 'ISRAEL',
    'ITALY' => 'ITALY',
    'IVORY COAST' => 'IVORY COAST',
    'JAMAICA' => 'JAMAICA',
    'JAPAN' => 'JAPAN',
    'JORDAN' => 'JORDAN',
    'KAZAKHSTAN' => 'KAZAKHSTAN',
    'KENYA' => 'KENYA',
    'KOREA' => 'KOREA',
    'KOREA, SOUTH' => 'KOREA, SOUTH',
    'KUWAIT' => 'KUWAIT',
    'KYRGYZSTAN' => 'KYRGYZSTAN',
    'LAOS' => 'LAOS',
    'LATVIA' => 'LATVIA',
    'LEBANON' => 'LEBANON',
    'LEEWARD ISLANDS' => 'LEEWARD ISLANDS',
    'LESOTHO' => 'LESOTHO',
    'LIBYA' => 'LIBYA',
    'LIECHTENSTEIN' => 'LIECHTENSTEIN',
    'LITHUANIA' => 'LITHUANIA',
    'LUXEMBOURG' => 'LUXEMBOURG',
    'MACAO' => 'MACAO',
    'MACEDONIA' => 'MACEDONIA',
    'MADAGASCAR' => 'MADAGASCAR',
    'MALAWI' => 'MALAWI',
    'MALAYSIA' => 'MALAYSIA',
    'MALDIVES' => 'MALDIVES',
    'MALI' => 'MALI',
    'MALTA' => 'MALTA',
    'MARTINIQUE' => 'MARTINIQUE',
    'MAURITANIA' => 'MAURITANIA',
    'MAURITIUS' => 'MAURITIUS',
    'MELANESIA' => 'MELANESIA',
    'MEXICO' => 'MEXICO',
    'MOLDOVIA' => 'MOLDOVIA',
    'MONACO' => 'MONACO',
    'MONGOLIA' => 'MONGOLIA',
    'MOROCCO' => 'MOROCCO',
    'MOZAMBIQUE' => 'MOZAMBIQUE',
    'MYANAMAR' => 'MYANAMAR',
    'NAMIBIA' => 'NAMIBIA',
    'NEPAL' => 'NEPAL',
    'NETHERLANDS' => 'NETHERLANDS',
    'NETHERLANDS ANTILLES' => 'NETHERLANDS ANTILLES',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'NETHERLANDS ANTILLES NEUTRAL ZONE',
    'NEW CALADONIA' => 'NEW CALADONIA',
    'NEW HEBRIDES' => 'NEW HEBRIDES',
    'NEW ZEALAND' => 'NEW ZEALAND',
    'NICARAGUA' => 'NICARAGUA',
    'NIGER' => 'NIGER',
    'NIGERIA' => 'NIGERIA',
    'NORFOLK ISLAND' => 'NORFOLK ISLAND',
    'NORWAY' => 'NORWAY',
    'OMAN' => 'OMAN',
    'OTHER' => 'OTHER',
    'PACIFIC ISLAND' => 'PACIFIC ISLAND',
    'PAKISTAN' => 'PAKISTAN',
    'PANAMA' => 'PANAMA',
    'PAPUA NEW GUINEA' => 'PAPUA NEW GUINEA',
    'PARAGUAY' => 'PARAGUAY',
    'PERU' => 'PERU',
    'PHILIPPINES' => 'PHILIPPINES',
    'POLAND' => 'POLAND',
    'PORTUGAL' => 'PORTUGAL',
    'PORTUGUESE TIMOR' => 'PORTUGUESE TIMOR',
    'PUERTO RICO' => 'PUERTO RICO',
    'QATAR' => 'QATAR',
    'REPUBLIC OF BELARUS' => 'REPUBLIC OF BELARUS',
    'REPUBLIC OF SOUTH AFRICA' => 'REPUBLIC OF SOUTH AFRICA',
    'REUNION' => 'REUNION',
    'ROMANIA' => 'ROMANIA',
    'RUSSIA' => 'RUSSIA',
    'RWANDA' => 'RWANDA',
    'RYUKYU ISLANDS' => 'RYUKYU ISLANDS',
    'SABAH' => 'SABAH',
    'SAN MARINO' => 'SAN MARINO',
    'SAUDI ARABIA' => 'SAUDI ARABIA',
    'SENEGAL' => 'SENEGAL',
    'SERBIA' => 'SERBIA',
    'SEYCHELLES' => 'SEYCHELLES',
    'SIERRA LEONE' => 'SIERRA LEONE',
    'SINGAPORE' => 'SINGAPORE',
    'SLOVAKIA' => 'SLOVAKIA',
    'SLOVENIA' => 'SLOVENIA',
    'SOMALILIAND' => 'SOMALILIAND',
    'SOUTH AFRICA' => 'SOUTH AFRICA',
    'SOUTH YEMEN' => 'SOUTH YEMEN',
    'SPAIN' => 'SPAIN',
    'SPANISH SAHARA' => 'SPANISH SAHARA',
    'SRI LANKA' => 'SRI LANKA',
    'ST. KITTS AND NEVIS' => 'ST. KITTS AND NEVIS',
    'ST. LUCIA' => 'ST. LUCIA',
    'SUDAN' => 'SUDAN',
    'SURINAM' => 'SURINAM',
    'SW AFRICA' => 'SW AFRICA',
    'SWAZILAND' => 'SWAZILAND',
    'SWEDEN' => 'SWEDEN',
    'SWITZERLAND' => 'SWITZERLAND',
    'SYRIA' => 'SYRIA',
    'TAIWAN' => 'TAIWAN',
    'TAJIKISTAN' => 'TAJIKISTAN',
    'TANZANIA' => 'TANZANIA',
    'THAILAND' => 'THAILAND',
    'TONGA' => 'TONGA',
    'TRINIDAD' => 'TRINIDAD',
    'TUNISIA' => 'TUNISIA',
    'TURKEY' => 'TURKEY',
    'UGANDA' => 'UGANDA',
    'UKRAINE' => 'UKRAINE',
    'UNITED ARAB EMIRATES' => 'UNITED ARAB EMIRATES',
    'UNITED KINGDOM' => 'UNITED KINGDOM',
    'UPPER VOLTA' => 'UPPER VOLTA',
    'URUGUAY' => 'URUGUAY',
    'US PACIFIC ISLAND' => 'US PACIFIC ISLAND',
    'US VIRGIN ISLANDS' => 'US VIRGIN ISLANDS',
    'USA' => 'USA',
    'UZBEKISTAN' => 'UZBEKISTAN',
    'VANUATU' => 'VANUATU',
    'VATICAN CITY' => 'VATICAN CITY',
    'VENEZUELA' => 'VENEZUELA',
    'VIETNAM' => 'VIETNAM',
    'WAKE ISLAND' => 'WAKE ISLAND',
    'WEST INDIES' => 'WEST INDIES',
    'WESTERN SAHARA' => 'WESTERN SAHARA',
    'YEMEN' => 'YEMEN',
    'ZAIRE' => 'ZAIRE',
    'ZAMBIA' => 'ZAMBIA',
    'ZIMBABWE' => 'ZIMBABWE',
];

$app_list_strings['state_dom'] = [
    'AL' => 'Alabama',
    'AK' => 'Alaska',
    'AZ' => 'Arizona',
    'AR' => 'Arkansas',
    'CA' => 'California',
    'CO' => 'Colorado',
    'CT' => 'Connecticut',
    'DE' => 'Delaware',
    'DC' => 'District Of Columbia',
    'FL' => 'Florida',
    'GA' => 'Georgia',
    'HI' => 'Hawaii',
    'ID' => 'Idaho',
    'IL' => 'Illinois',
    'IN' => 'Indiana',
    'IA' => 'Iowa',
    'KS' => 'Kansas',
    'KY' => 'Kentucky',
    'LA' => 'Louisiana',
    'ME' => 'Maine',
    'MD' => 'Maryland',
    'MA' => 'Massachusetts',
    'MI' => 'Michigan',
    'MN' => 'Minnesota',
    'MS' => 'Mississippi',
    'MO' => 'Missouri',
    'MT' => 'Montana',
    'NE' => 'Nebraska',
    'NV' => 'Nevada',
    'NH' => 'New Hampshire',
    'NJ' => 'New Jersey',
    'NM' => 'New Mexico',
    'NY' => 'New York',
    'NC' => 'North Carolina',
    'ND' => 'North Dakota',
    'OH' => 'Ohio',
    'OK' => 'Oklahoma',
    'OR' => 'Oregon',
    'PA' => 'Pennsylvania',
    'RI' => 'Rhode Island',
    'SC' => 'South Carolina',
    'SD' => 'South Dakota',
    'TN' => 'Tennessee',
    'TX' => 'Texas',
    'UT' => 'Utah',
    'VT' => 'Vermont',
    'VA' => 'Virginia ',
    'WA' => 'Washington',
    'WV' => 'West Virginia',
    'WI' => 'Wisconsin',
    'WY' => 'Wyoming',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (Taiwan and Hong Kong)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS Cyrillic)',
    'CP1252' => 'CP1252 (MS Western European & US)',
    'EUC-CN' => 'EUC-CN (Simplified Chinese GB2312)',
    'EUC-JP' => 'EUC-JP (Unix Japanese)',
    'EUC-KR' => 'EUC-KR (Korean)',
    'EUC-TW' => 'EUC-TW (Taiwanese)',
    'ISO-2022-JP' => 'ISO-2022-JP (Japanese)',
    'ISO-2022-KR' => 'ISO-2022-KR (Korean)',
    'ISO-8859-1' => 'ISO-8859-1 (Western European and US)',
    'ISO-8859-2' => 'ISO-8859-2 (Central and Eastern European)',
    'ISO-8859-3' => 'ISO-8859-3 (Latin 3)',
    'ISO-8859-4' => 'ISO-8859-4 (Latin 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Cyrillic)',
    'ISO-8859-6' => 'ISO-8859-6 (Arabic)',
    'ISO-8859-7' => 'ISO-8859-7 (Greek)',
    'ISO-8859-8' => 'ISO-8859-8 (Hebrew)',
    'ISO-8859-9' => 'ISO-8859-9 (Latin 5)',
    'ISO-8859-10' => 'ISO-8859-10 (Latin 6)',
    'ISO-8859-13' => 'ISO-8859-13 (Latin 7)',
    'ISO-8859-14' => 'ISO-8859-14 (Latin 8)',
    'ISO-8859-15' => 'ISO-8859-15 (Latin 9)',
    'KOI8-R' => 'KOI8-R (Cyrillic Russian)',
    'KOI8-U' => 'KOI8-U (Cyrillic Ukranian)',
    'SJIS' => 'SJIS (MS Japanese)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Douala' => 'Africa/Douala',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Indian/Comoro' => 'Indian/Comoro',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Asmera' => 'Africa/Asmera',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Lagos' => 'Africa/Lagos',
    'Indian/Reunion' => 'Indian/Reunion',
    'Africa/Kigali' => 'Africa/Kigali',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Dakar' => 'Africa/Dakar',
    'Indian/Mahe' => 'Indian/Mahe',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Harare' => 'Africa/Harare',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Indian/Chagos' => 'Indian/Chagos',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Rangoon' => 'Asia/Rangoon',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Beijing' => 'Asia/Beijing',
    'Asia/Harbin' => 'Asia/Harbin',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Chongqing' => 'Asia/Chongqing',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Kashgar' => 'Asia/Kashgar',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Calcutta' => 'Asia/Calcutta',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Indian/Maldives' => 'Indian/Maldives',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Katmandu' => 'Asia/Katmandu',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Saigon' => 'Asia/Saigon',
    'Asia/Aden' => 'Asia/Aden',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Sydney' => 'Australia/Sydney',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Indian/Christmas' => 'Indian/Christmas',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Indian/Cocos' => 'Indian/Cocos',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Truk' => 'Pacific/Truk',
    'Pacific/Ponape' => 'Pacific/Ponape',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Johnston' => 'Pacific/Johnston',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'Europe/London' => 'Europe/London',
    'Europe/Dublin' => 'Europe/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Brussels' => 'Europe/Brussels',
    'Europe/Sofia' => 'Europe/Sofia',
    'Europe/Prague' => 'Europe/Prague',
    'Europe/Copenhagen' => 'Europe/Copenhagen',
    'Atlantic/Faeroe' => 'Atlantic/Faeroe',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Godthab' => 'America/Godthab',
    'America/Thule' => 'America/Thule',
    'Europe/Tallinn' => 'Europe/Tallinn',
    'Europe/Helsinki' => 'Europe/Helsinki',
    'Europe/Paris' => 'Europe/Paris',
    'Europe/Berlin' => 'Europe/Berlin',
    'Europe/Gibraltar' => 'Europe/Gibraltar',
    'Europe/Athens' => 'Europe/Athens',
    'Europe/Budapest' => 'Europe/Budapest',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Europe/Rome' => 'Europe/Rome',
    'Europe/Riga' => 'Europe/Riga',
    'Europe/Vaduz' => 'Europe/Vaduz',
    'Europe/Vilnius' => 'Europe/Vilnius',
    'Europe/Luxembourg' => 'Europe/Luxembourg',
    'Europe/Malta' => 'Europe/Malta',
    'Europe/Chisinau' => 'Europe/Chisinau',
    'Europe/Monaco' => 'Europe/Monaco',
    'Europe/Amsterdam' => 'Europe/Amsterdam',
    'Europe/Oslo' => 'Europe/Oslo',
    'Europe/Warsaw' => 'Europe/Warsaw',
    'Europe/Lisbon' => 'Europe/Lisbon',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Europe/Bucharest' => 'Europe/Bucharest',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Samara' => 'Europe/Samara',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Madrid' => 'Europe/Madrid',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Zurich' => 'Europe/Zurich',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'America/New_York' => 'America/New_York',
    'America/Chicago' => 'America/Chicago',
    'America/North_Dakota/Center' => 'America/North_Dakota/Center',
    'America/Denver' => 'America/Denver',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Juneau' => 'America/Juneau',
    'America/Yakutat' => 'America/Yakutat',
    'America/Anchorage' => 'America/Anchorage',
    'America/Nome' => 'America/Nome',
    'America/Adak' => 'America/Adak',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'America/Phoenix' => 'America/Phoenix',
    'America/Boise' => 'America/Boise',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Detroit' => 'America/Detroit',
    'America/Menominee' => 'America/Menominee',
    'America/St_Johns' => 'America/St_Johns',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Halifax' => 'America/Halifax',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Montreal' => 'America/Montreal',
    'America/Toronto' => 'America/Toronto',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Nipigon' => 'America/Nipigon',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Regina' => 'America/Regina',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Edmonton' => 'America/Edmonton',
    'America/Vancouver' => 'America/Vancouver',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Coral_Harbour' => 'America/Coral_Harbour',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Yellowknife' => 'America/Yellowknife',
    'America/Inuvik' => 'America/Inuvik',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Dawson' => 'America/Dawson',
    'America/Cancun' => 'America/Cancun',
    'America/Merida' => 'America/Merida',
    'America/Monterrey' => 'America/Monterrey',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Tijuana' => 'America/Tijuana',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Nassau' => 'America/Nassau',
    'America/Barbados' => 'America/Barbados',
    'America/Belize' => 'America/Belize',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'America/Cayman' => 'America/Cayman',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Havana' => 'America/Havana',
    'America/Dominica' => 'America/Dominica',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Jamaica' => 'America/Jamaica',
    'America/Martinique' => 'America/Martinique',
    'America/Montserrat' => 'America/Montserrat',
    'America/Managua' => 'America/Managua',
    'America/Panama' => 'America/Panama',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/Miquelon' => 'America/Miquelon',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Tortola' => 'America/Tortola',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/La_Paz' => 'America/La_Paz',
    'America/Noronha' => 'America/Noronha',
    'America/Belem' => 'America/Belem',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Recife' => 'America/Recife',
    'America/Araguaina' => 'America/Araguaina',
    'America/Maceio' => 'America/Maceio',
    'America/Bahia' => 'America/Bahia',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Manaus' => 'America/Manaus',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santiago' => 'America/Santiago',
    'Pacific/Easter' => 'Pacific/Easter',
    'America/Bogota' => 'America/Bogota',
    'America/Curacao' => 'America/Curacao',
    'America/Guayaquil' => 'America/Guayaquil',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'America/Cayenne' => 'America/Cayenne',
    'America/Guyana' => 'America/Guyana',
    'America/Asuncion' => 'America/Asuncion',
    'America/Lima' => 'America/Lima',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Montevideo' => 'America/Montevideo',
    'America/Caracas' => 'America/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'Favorites';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'Favorite';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Contacts',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'Request',
    2 => 'Access',
    3 => 'Invalid',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugar User',
    'support_portal' => 'Support Portal',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'Campaign',
    'email' => 'Email',
    'workflow' => 'Workflow',
    'system' => 'System',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'Campaign',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'Campaign',
    'email' => 'Email',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'Documentation',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'Two Ranges',
    'show_buckets' => 'Three Ranges',
    'show_custom_buckets' => 'Custom Ranges',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'Date Based Year',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'Yearly (Quarterly sub-periods)',
    'Quarter' => 'Quarterly (Monthly sub-periods)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'Revenue Line Items',
    'Opportunities' => 'Opportunities',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'Yes',
    'no' => 'No',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'Alert',
    'information' => 'Info',
    'other' => 'Other',
    'success' => 'Success',
    'warning' => 'Warning',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'GET',
    'PUT' => 'PUT',
    'DELETE' => 'DELETE',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'Manually',
    '5' => 'Every 5 minutes',
    '15' => 'Every 15 minutes',
    '30' => 'Every 30 minutes',
    '60' => 'Every hour',
];

$app_list_strings['moduleList']['KBDocuments'] = 'Knowledge Base Document';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'Knowledge Base Document';
$app_list_strings['moduleList']['KBContents'] = 'Knowledge Base';
$app_list_strings['moduleListSingular']['KBContents'] = 'Knowledge Base Article';
$app_list_strings['moduleList']['KBArticles'] = 'Knowledge Base Article';
$app_list_strings['moduleListSingular']['KBArticles'] = 'Knowledge Base Article';
$app_list_strings['moduleList']['KBContentTemplates'] = 'Knowledge Base Template';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'Knowledge Base Template';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'Embedded Files';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'Embedded File';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '﷼',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '﷼',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '﷼',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '﷼',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '﷼',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leke',
    'USD' => 'Dollars',
    'AFN' => 'Afghanis',
    'ARS' => 'Pesos',
    'AWG' => 'Guilders',
    'AUD' => 'Dollars',
    'AZN' => 'New Manats',
    'BSD' => 'Dollars',
    'BBD' => 'Dollars',
    'BYR' => 'Rubles',
    'EUR' => 'Euro',
    'BZD' => 'Dollars',
    'BMD' => 'Dollars',
    'BOB' => 'Bolivianos',
    'BAM' => 'Convertible Marka',
    'BWP' => 'Pulas',
    'BGN' => 'Leva',
    'BRL' => 'Reais',
    'GBP' => 'Pounds',
    'BND' => 'Dollars',
    'KHR' => 'Riels',
    'CAD' => 'Dollars',
    'KYD' => 'Dollars',
    'CLP' => 'Pesos',
    'CNY' => 'Yuan Renminbi',
    'COP' => 'Pesos',
    'CRC' => 'ColÃ³n',
    'HRK' => 'Kuna',
    'CUP' => 'Pesos',
    'CZK' => 'Koruny',
    'DKK' => 'Kroner',
    'DOP' => 'Pesos',
    'XCD' => 'Dollars',
    'EGP' => 'Pounds',
    'SVC' => 'Colones',
    'EEK' => 'Krooni',
    'FKP' => 'Pounds',
    'FJD' => 'Dollars',
    'GHC' => 'Cedis',
    'GIP' => 'Pounds',
    'GTQ' => 'Quetzales',
    'GGP' => 'Pounds',
    'GYD' => 'Dollars',
    'HNL' => 'Lempiras',
    'HKD' => 'Dollars',
    'HUF' => 'Forint',
    'ISK' => 'Kronur',
    'INR' => 'Rupees',
    'IDR' => 'Rupiahs',
    'IRR' => 'Rials',
    'IMP' => 'Pounds',
    'ILS' => 'New Shekels',
    'JMD' => 'Dollars',
    'JPY' => 'Yen',
    'JEP' => 'Pounds',
    'KZT' => 'Tenge',
    'KPW' => 'Won',
    'KRW' => 'Won',
    'KGS' => 'Soms',
    'LAK' => 'Kips',
    'LVL' => 'Lati',
    'LBP' => 'Pounds',
    'LRD' => 'Dollars',
    'CHF' => 'Switzerland Francs',
    'LTL' => 'Litai',
    'MKD' => 'Denars',
    'MYR' => 'Ringgits',
    'MUR' => 'Rupees',
    'MXN' => 'Pesos',
    'MNT' => 'Tugriks',
    'MZN' => 'Meticais',
    'NAD' => 'Dollars',
    'NPR' => 'Rupees',
    'ANG' => 'Guilders',
    'NZD' => 'Dollars',
    'NIO' => 'Cordobas',
    'NGN' => 'Nairas',
    'NOK' => 'Krone',
    'OMR' => 'Rials',
    'PKR' => 'Rupees',
    'PAB' => 'Balboa',
    'PYG' => 'Guarani',
    'PEN' => 'Nuevos Soles',
    'PHP' => 'Pesos',
    'PLN' => 'Zlotych',
    'QAR' => 'Rials',
    'RON' => 'New Lei',
    'RUB' => 'Rubles',
    'SHP' => 'Pounds',
    'SAR' => 'Riyals',
    'RSD' => 'Dinars',
    'SCR' => 'Rupees',
    'SGD' => 'Dollars',
    'SBD' => 'Dollars',
    'SOS' => 'Shillings',
    'ZAR' => 'Rand',
    'LKR' => 'Rupees',
    'SEK' => 'Kronor',
    'SRD' => 'Dollars',
    'SYP' => 'Pounds',
    'TWD' => 'New Dollars',
    'THB' => 'Baht',
    'TTD' => 'Dollars',
    'TRY' => 'Lira',
    'TRL' => 'Liras',
    'TVD' => 'Dollars',
    'UAH' => 'Hryvnia',
    'UYU' => 'Pesos',
    'UZS' => 'Sums',
    'VEF' => 'Bolivares Fuertes',
    'VND' => 'Dong',
    'YER' => 'Rials',
    'ZWD' => 'Zimbabwe Dollars',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'Very High',
    '4' => 'High',
    '3' => 'Neutral',
    '2' => 'Low',
    '1' => 'Very Low',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'None',
    'future' => 'Current Value',
    'old' => 'Old Value',
    'both' => 'Current and Old Values',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Single-Hit',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'Processing',
    'error' => 'Error',
    'success' => 'Success',
    'canceled' => 'Canceled',
    'document_load' => 'Loading Template',
    'tags_extract' => 'Extracting Tags',
    'tags_validate' => 'Validating Tags',
    'data_retrieving' => 'Retrieving Data',
    'serialize_document' => 'Putting the document back together',
    'send_document' => 'Sending the document to you',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'Merge',
    'convert' => 'PDF Merge',
    'multimerge' => 'Multimerge',
    'multimerge_convert' => 'Multimerge PDF',
    'labelsgenerate' => 'Generate Labels',
    'labelsgenerate_convert' => 'Generate Labels PDF',
    'excel' => 'Excel Merge',
    'excel_convert' => 'Excel Merge Convert',
    'presentation' => 'PowerPoint Merge',
    'presentation_convert' => 'PowerPoint Merge PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'My Accounts',
    'favorites' => 'Favorite Accounts',
    'tags' => 'Accounts tagged',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'All News',
    'General' => 'General',
    'Finance' => 'Financial',
    'People' => 'Personnel',
    'Press Releases' => 'Press Releases',
    'Other' => 'Other',
];

$app_strings['LBL_OWNERS'] = 'Owners';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Cloud Drive';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'Cloud Drive Integration Dashlet';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'Copy Link';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'Download';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Create Sugar Document';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'Unable to download this file';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'Cloud dashlet not present';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar Document Created';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'Send to DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign is not available from this location';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'Doc Merge to Word/Excel/PowerPoint is not available from this location';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'Doc Merge to DocuSign is not available from this location';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'Doc Merge to PDF is not available from this location';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'Your signed file will be uploaded here only if you have permission to upload in this location.';
$app_strings['LBL_DOC_MERGE_TO'] = 'Doc Merge to';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'My files';
$app_strings['LBL_SHARED_WITH_ME'] = 'Shared with me';
$app_strings['LBL_CLOUD_PROVIDER'] = 'Cloud Provider';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft OneDrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'Shared With Me';
$app_strings['LBL_MY_FILES'] = 'My files';
$app_strings['LBL_UPLOAD_FILE'] = 'Upload File';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'Folder not found';
$app_strings['LBL_CREATE_FOLDER'] = 'Create Folder';
$app_strings['LBL_LOAD_MORE'] = 'Load more...';
$app_strings['LBL_NEW_FOLDER'] = 'New Folder';
$app_strings['LBL_FOLDER_NAME'] = 'Folder Name: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'You do not have permission to do that on the current path.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'You do not have permission to go on the current path.';
$app_strings['LBL_FILE_UPLOADED'] = 'The file has been uploaded.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'Due to the large size of your file, the upload will take a while.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'One or more document records do not have an attached file. Please attach files to the records and try again, or individually sync specific records with files.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Connection with Google not found...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Connection with Microsoft not found...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Connection with Dropbox not found...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'Syncing with OneDrive might take a while';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'Are you sure you want to delete this file?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDrive upload has been completed.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' has been successfully uploaded.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'Error while loading paths.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'An error has occured because the file is corrupt.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'The document <i>"{{documentName}}"</i> has been saved to your cloud drive and added to the Documents module.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'You do not have permission to delete this file.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'You do not have permission to delete this folder.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'You do not have permissions to upload files to this location.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'You do not have permission to create a folder in this location.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'Folders cannot be created in this location.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'Files cannot be uploaded to this location.';
$app_strings['LBL_SITES'] = 'Sites';
$app_strings['LBL_SHARED'] = 'Shared';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'Link created. Click the button to copy the link to your clipboard.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'Copy to clipboard';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-blank-',
    'Exact' => 'Exact',
    'Null_address_components' => 'One or many address components empty',
    'Invalid_address' => 'Invalid Address, server returned False',
    'Invalid_server_response_not_XML' => 'Invalid server response, not XML',
    'Invalid_address_no_location' => 'Invalid address, server returned no location',
    'Ambiguous_address' => 'Ambiguous address, multiple matches',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'Road',
    'a' => 'Aerial',
    'rd' => 'Dark Road',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'English (US)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'New York (EST)'],
    ['pst', 'Los Angeles (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['New', 'New'],
    ['Assigned', 'Assigned'],
    ['Closed', 'Closed'],
    ['Pending Input', 'Pending Input'],
    ['Rejected', 'Rejected'],
    ['Duplicate', 'Duplicate'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['Administration', 'Administration'],
    ['Product', 'Product'],
    ['User', 'User'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'High'],
    ['P2', 'Medium'],
    ['P3', 'Low'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['user', 'User'],
    ['admin,user', 'Admin'],
    ['account manager,user', 'Account Manager'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', 'Last 30 Days'],
    ['last_90_days', 'Last 90 Days'],
    ['this_year', 'Last Year'],
    ['custom', 'Custom Range'],
    ['all', 'All'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['Default', 'Default'],
    ['Color', 'Solid Color'],
    ['Url', 'Custom Image'],
];
