<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'Deutsch',
    'moduleList' => [
        'Home' => 'Startseite',
        'Contacts' => 'Kontakte',
        'Accounts' => 'Firmen',
        'Opportunities' => 'Verkaufschancen',
        'Cases' => 'Tickets',
        'Notes' => 'Notizen',
        'Calls' => 'Anrufe',
        'Emails' => 'E-Mails',
        'Meetings' => 'Meetings',
        'Tasks' => 'Aufgaben',
        'Calendar' => 'Kalender',
        'Leads' => 'Interessenten',
        'Currencies' => 'Währungen',
        'Contracts' => 'Verträge',
        'Quotes' => 'Angebote',
        'Products' => 'Produkte',
        'WebLogicHooks' => 'Web Logic-Hooks',
        'ProductCategories' => 'Produktkategorien',
        'ProductTypes' => 'Produktarten',
        'ProductTemplates' => 'Produktkatalog',
        'ProductBundles' => 'Produktpakete',
        'ProductBundleNotes' => 'Produktpaket-Notizen',
        'Reports' => 'Berichte',
        'Forecasts' => 'Prognosen',
        'ForecastWorksheets' => 'Prognose-Arbeitsblätter',
        'ForecastManagerWorksheets' => 'Umsatzplanung Manager-Arbeitsblätter',
        'VisualPipeline' => 'Visuelle Pipeline',
        'ConsoleConfiguration' => 'Konfiguration der Konsole',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'Quoten',
        'Teams' => 'Teams',
        'TeamNotices' => 'Team-Notizen',
        'Manufacturers' => 'Hersteller',
        'Activities' => 'Aktivitäten',
        'Comments' => 'Kommentare',
        'Subscriptions' => 'Kontaktlisten',
        'Bugs' => 'Fehler',
        'Feeds' => 'RSS',
        'iFrames' => 'Meine Seiten',
        'TimePeriods' => 'Zeiträume',
        'TaxRates' => 'Steuersätze',
        'ContractTypes' => 'Vertragstypen verwalten',
        'Schedulers' => 'Zeitplaner',
        'Project' => 'Projekte',
        'ProjectTask' => 'Projektaufgaben',
        'Campaigns' => 'Kampagnen',
        'CampaignLog' => 'Kampagnen-Protokoll',
        'CampaignTrackers' => 'Kampagnen-Tracker',
        'Documents' => 'Dokumente',
        'DocumentRevisions' => 'Dokument-Revisionen',
        'Connectors' => 'Konnektoren',
        'Notifications' => 'Benachrichtigungen',
        'Sync' => 'Synchronisierung',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintEnrichFieldConfigs',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => 'Externe Benutzer',
        'ReportMaker' => 'Erweiterte Berichte',
        'DataSets' => 'Datenformate',
        'CustomQueries' => 'Benutzerdefinierte Anfragen',
        'pmse_Inbox' => 'Prozesse',
        'pmse_Project' => 'Prozessdefinitionen',
        'pmse_Business_Rules' => 'Prozess-Geschäftsregeln',
        'pmse_Emails_Templates' => 'Prozess-E-Mail-Vorlagen',
        'BusinessCenters' => 'Geschäftszentren',
        'Shifts' => 'Schichten',
        'ShiftExceptions' => 'Schichtausnahmen',
        'Purchases' => 'Einkäufe',
        'PurchasedLineItems' => 'Gekaufte Produkte',
        'MobileDevices' => 'Mobilgeräte',
        'PushNotifications' => 'Push-Benachrichtigungen',
        'Escalations' => 'Eskalationen',
        'DocumentTemplates' => 'Dokumentenvorlagen',
        'DocumentMerges' => 'Dokumentzusammenführungen',
        'CloudDrivePaths' => 'Cloud Drive Pfade',
        'WorkFlow' => 'Workflow-Definitionen',
        'EAPM' => 'Externe Konten',
        'Worksheet' => 'Arbeitsblatt',
        'Users' => 'Benutzer',
        'Employees' => 'Mitarbeiter',
        'Administration' => 'Administration',
        'ACLRoles' => 'Rollen',
        'InboundEmail' => 'Einstellungen eingehende E-Mails',
        'Releases' => 'Versionen',
        'Prospects' => 'Zielkontakte',
        'Queues' => 'Warteschlangen',
        'EmailMarketing' => 'E-Mail-Marketing',
        'EmailTemplates' => 'E-Mail-Vorlagen',
        'SNIP' => 'E-Mail-Archivierung',
        'ProspectLists' => 'Kontaktlisten',
        'SavedSearch' => 'Gespeicherte Suchen',
        'UpgradeWizard' => 'Upgrade-Assistent',
        'Trackers' => 'Trackers',
        'TrackerPerfs' => 'Tracker-Leistung',
        'TrackerSessions' => 'Tracker-Sitzungen',
        'TrackerQueries' => 'Tracker-Abfragen',
        'FAQ' => 'Häufig gestellte Fragen',
        'Newsletters' => 'Newsletter',
        'SugarFavorites' => 'Favoriten',
        'PdfManager' => 'PDF-Manager',
        'DataArchiver' => 'Datenarchivierer',
        'ArchiveRuns' => 'Archivierungsläufe',

        'OAuthKeys' => 'OAuth Konsumenten-Schlüssel',
        'OAuthTokens' => 'OAuth Tokens',
        'Filters' => 'Filter',
        'UserSignatures' => 'E-Mail-Signaturen',
        'Shippers' => 'Versender',
        'Styleguide' => 'Stilrichtlinien',
        'Feedbacks' => 'Rückmeldungen',
        'Tags' => 'Tags',
        'Categories' => 'Kategorien',
        'Dashboards' => 'Dashboards',
        'OutboundEmail' => 'E-Mail-Einstellungen',
        'EmailParticipants' => 'E-Mail-Teilnehmer',
        'DataPrivacy' => 'Datenschutz',
        'ReportSchedules' => 'Berichtzeitpläne',
        'CommentLog' => 'Kommentarprotokoll',
        'Holidays' => 'Feiertage',
        'ChangeTimers' => 'Zeitmesser ändern',
        'Metrics' => 'Metriken',
        'Messages' => 'Nachrichten',
        'Audit' => 'Audit',
        'RevenueLineItems' => 'Umsatzposten',
        'DocuSignEnvelopes' => 'DocuSign Umschläge',
        'Geocode' => 'Geocode',
        'DRI_Workflows' => 'Smart Guides',
        'DRI_Workflow_Task_Templates' => 'Smart Guide Aktivitätsvorlagen',
        'DRI_SubWorkflows' => 'Smart Guides Stufen',
        'DRI_Workflow_Templates' => 'Smart Guide Vorlagen',
        'CJ_WebHooks' => 'Sugar Automate Web-Hooks',
        'CJ_Forms' => 'Smart Guide Sugar-Aktionen',
        'DRI_SubWorkflow_Templates' => 'Smart Guide Stufenvorlagen',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub-Modul-Event-Push-Abonnements',
    ],

    'moduleIconList' => [
        'Home' => 'Ho',
        'Contacts' => 'Ko',
        'Accounts' => 'Ko',
        'Opportunities' => 'Cha',
        'Cases' => 'Tickets',
        'Notes' => 'Notizen',
        'Calls' => 'Anrufe',
        'Emails' => 'EM',
        'Meetings' => 'Me',
        'Tasks' => 'Aufgaben',
        'Calendar' => 'Ka',
        'Leads' => 'In',
        'Currencies' => 'Wä',
        'Contracts' => 'Ve',
        'Quotes' => 'An',
        'Products' => 'Pr',
        'WebLogicHooks' => 'WL',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'PT',
        'ProductTemplates' => 'PV',
        'ProductBundles' => 'PP',
        'ProductBundleNotes' => 'PP',
        'Reports' => 'Be',
        'Forecasts' => 'Vo',
        'ForecastWorksheets' => 'WS',
        'ForecastManagerWorksheets' => 'VM',
        'Quotas' => 'Fo',
        'VisualPipeline' => 'VP',
        'ConsoleConfiguration' => 'KK',
        'SugarLive' => 'Su',
        'Teams' => 'Te',
        'TeamNotices' => 'TN',
        'Manufacturers' => 'He',
        'Activities' => 'Ak',
        'Comments' => 'Ko',
        'Subscriptions' => 'Ab',
        'Bugs' => 'Bu',
        'Feeds' => 'RS',
        'iFrames' => 'iF',
        'TimePeriods' => 'ZP',
        'TaxRates' => 'StS',
        'ContractTypes' => 'VT',
        'Schedulers' => 'Zp',
        'Project' => 'Pr',
        'ProjectTask' => 'PA',
        'Campaigns' => 'Kampagnen',
        'CampaignLog' => 'KP',
        'CampaignTrackers' => 'KT',
        'Documents' => 'Do',
        'DocumentRevisions' => 'DR',
        'Connectors' => 'Ko',
        'Notifications' => 'Be',
        'Sync' => 'Sy',
        'HintAccountsets' => 'Hi',
        'HintNotificationTargets' => 'Hi',
        'HintNewsNotifications' => 'Hi',
        'HintEnrichFieldConfigs' => 'Hi',
        'ExternalUsers' => 'EB',
        'ReportMaker' => 'BE',
        'DataSets' => 'DS',
        'CustomQueries' => 'IA',
        'pmse_Inbox' => 'Pr',
        'pmse_Project' => 'PD',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE',
        'BusinessCenters' => 'BC',
        'Shifts' => 'Sch',
        'ShiftExceptions' => 'SA',
        'Purchases' => 'Kä',
        'PurchasedLineItems' => 'KP',
        'MobileDevices' => 'Mo',
        'PushNotifications' => 'Pu',
        'Escalations' => 'Es',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'Wf',
        'EAPM' => 'EA',
        'Worksheet' => 'Wo',
        'Users' => 'Be',
        'Employees' => 'An',
        'Administration' => 'Ad',
        'ACLRoles' => 'Ro',
        'InboundEmail' => 'EE',
        'Releases' => 'Ve',
        'Prospects' => 'Pr',
        'Queues' => 'WS',
        'EmailMarketing' => 'EM',
        'EmailTemplates' => 'EV',
        'SNIP' => 'EA',
        'ProspectLists' => 'ZKL',
        'SavedSearch' => 'GS',
        'UpgradeWizard' => 'UA',
        'Trackers' => 'Tr',
        'TrackerPerfs' => 'TP',
        'TrackerSessions' => 'TS',
        'TrackerQueries' => 'TA',
        'FAQ' => 'FAQ',
        'Newsletters' => 'Ne',
        'SugarFavorites' => 'Fa',
        'PdfManager' => 'PM',
        'DataArchiver' => 'DA',
        'ArchiveRuns' => 'AL',
        'OAuthKeys' => 'OS',
        'OAuthTokens' => 'OT',
        'Filters' => 'Fi',
        'UserSignatures' => 'BS',
        'Shippers' => 'Ab',
        'Styleguide' => 'St',
        'Feedbacks' => 'Fe',
        'Tags' => 'Ta',
        'Categories' => 'Ka',
        'Dashboards' => 'DS',
        'OutboundEmail' => 'AE',
        'EmailParticipants' => 'ET',
        'DataPrivacy' => 'DS',
        'ReportSchedules' => 'BZ',
        'CommentLog' => 'KP',
        'Holidays' => 'Ur',
        'ChangeTimers' => 'Zä',
        'Metrics' => 'Me',
        'Messages' => 'Na',
        'Audit' => 'Au',
        'RevenueLineItems' => 'UP',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'Ge',
        'DRI_Workflows' => 'DRI',
        'DRI_Workflow_Task_Templates' => 'DRI',
        'DRI_SubWorkflows' => 'SG',
        'DRI_Workflow_Templates' => 'DRI',
        'CJ_WebHooks' => 'CJW',
        'CJ_Forms' => 'CJF',
        'DRI_SubWorkflow_Templates' => 'DRI',
        'Library' => 'Bi',
        'EmailAddresses' => 'EA',
        'Words' => 'Wo',
        'Sugar_Favorites' => 'Fa',
        'KBDocuments' => 'KB',
        'KBContents' => 'KB',
        'KBArticles' => 'KB',
        'KBContentTemplates' => 'KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'ED',
    ],

    'moduleListSingular' => [
        'Home' => 'Startseite',
        'Dashboards' => 'Dashboard',
        'Styleguide' => 'Stilrichtlinien',
        'Contacts' => 'Kontakt',
        'Accounts' => 'Firma',
        'Opportunities' => 'Verkaufschance',
        'Cases' => 'Ticket',
        'Notes' => 'Notiz',
        'Calls' => 'Anruf',
        'Emails' => 'E-Mail',
        'Meetings' => 'Meeting',
        'Tasks' => 'Aufgabe',
        'Calendar' => 'Kalender',
        'Leads' => 'Interessent',
        'Manufacturers' => 'Hersteller',
        'VisualPipeline' => 'VisualPipeline',
        'ConsoleConfiguration' => 'ConsoleConfiguration',
        'MobileDevices' => 'Mobilgerät',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'Vertrag',
        'Quotes' => 'Angebot',
        'Products' => 'Produkt',
        'ProductCategories' => 'Produktkategorie',
        'ProductBundles' => 'Produktpaket',
        'ProductBundleNotes' => 'Produktpaket-Notizen',
        'RevenueLineItems' => 'Umsatzposten',
        'WebLogicHooks' => 'Web Logic-Hook',
        'Reports' => 'Bericht',
        'Forecasts' => 'Prognose',
        'ForecastWorksheets' => 'Prognose-Arbeitsblatt',
        'ForecastManagerWorksheets' => 'Umsatzplanung Manager-Arbeitsblatt',
        'Quotas' => 'Vorgabe',
        'Teams' => 'Team',
        'TeamNotices' => 'Team-Notiz',
        'Activities' => 'Aktivitäten',
        'ActivityStream' => 'Aktivitäten-Stream',
        'Bugs' => 'Fehler',
        'Feeds' => 'RSS',
        'iFrames' => 'Meine Seiten',
        'TimePeriods' => 'Zeitraum:',
        'TaxRates' => 'Steuersatz',
        'ContractTypes' => 'Vertragstyp',
        'Schedulers' => 'Zeitplaner',
        'Campaigns' => 'Kampagne',
        'CampaignLog' => 'Kampagnen-Protokoll',
        'Project' => 'Projekt',
        'ProjectTask' => 'Projektaufgabe',
        'Prospects' => 'Zielkontakt',
        'ProspectLists' => 'Zielkontaktliste',
        'CampaignTrackers' => 'Kampagnen-Tracker',
        'Documents' => 'Dokument',
        'DocumentRevisions' => 'Dokument-Revision',
        'Connectors' => 'Konnektor',
        'Notifications' => 'Benachrichtigung',
        'Sync' => 'Synchronisierung',
        'PdfManager' => 'PDF-Manager',
        'DataArchiver' => 'Datenarchivierer',
        'ArchiveRuns' => 'Archivierungsläufe',
        'ExternalUsers' => 'Externe Benutzer',
        'ReportMaker' => ' Erweiterter Bericht',
        'DataSets' => 'Datenformat',
        'CustomQueries' => 'Individuelle Abfrage',
        'pmse_Inbox' => 'Prozess',
        'pmse_Project' => 'Prozessdefinition',
        'pmse_Business_Rules' => 'Prozess-Geschäftsregel',
        'pmse_Emails_Templates' => 'Prozess-E-Mail-Vorlage',
        'BusinessCenters' => 'Geschäftszentrum',
        'Shifts' => 'Schicht',
        'ShiftExceptions' => 'Schichtausnahmen',
        'Purchases' => 'Einkauf',
        'PurchasedLineItems' => 'Gekauftes Produkt',
        'PushNotifications' => 'Push-Benachrichtigung',
        'Escalations' => 'Eskalation',
        'DocumentTemplates' => 'Dokumentenvorlage',
        'DocumentMerges' => 'Dokumentzusammenführung',
        'CloudDrivePaths' => 'Cloud Drive Pfad',
        'WorkFlow' => 'Workflow',
        'EAPM' => 'Externes Konto',
        'Worksheet' => 'Arbeitsblatt',
        'Users' => 'Benutzer',
        'SugarFavorites' => 'Sugar-Favoriten',
        'Employees' => 'Mitarbeiter',
        'Administration' => 'Administration',
        'ACLRoles' => 'Rolle',
        'InboundEmail' => 'Einstellungen eingehende E-Mails',
        'Releases' => 'Version',
        'Queues' => 'Warteschlange',
        'EmailMarketing' => 'E-Mail-Marketing',
        'EmailTemplates' => 'E-Mail-Vorlage',
        'SNIP' => 'E-Mail-Archivierung',
        'SavedSearch' => 'Gespeicherte Suche',
        'UpgradeWizard' => 'Upgrade-Assistent',
        'Trackers' => 'Tracker',
        'TrackerPerfs' => 'Tracker-Leistung',
        'TrackerSessions' => 'Tracker-Sitzung',
        'TrackerQueries' => 'Tracker-Abfrage',
        'FAQ' => 'Häufig gestellte Fragen',
        'Newsletters' => 'Newsletter',
        'OAuthKeys' => 'OAuth-Kunden-Schlüssel',
        'OAuthTokens' => 'OAuth Token',
        'Filters' => 'Filter',
        'Comments' => 'Kommentar',
        'CommentLog' => 'Kommentarprotokoll',
        'Currencies' => 'Währung',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'Produktart',
        'Shippers' => 'Transportunternehmen',
        'Subscriptions' => 'Abonnement',
        'UserSignatures' => 'E-Mail-Signatur',
        'Feedbacks' => 'Rückmeldungen',
        'Tags' => 'Tag',
        'Categories' => 'Kategorie',
        'OutboundEmail' => 'E-Mail-Einstellung',
        'EmailParticipants' => 'E-Mail-Teilnehmer',
        'DataPrivacy' => 'Datenschutz',
        'ReportSchedules' => 'Berichtzeitplan',
        'Holidays' => 'Feiertag',
        'ChangeTimers' => 'Zeitmesser ändern',
        'Metrics' => 'Metrik',
        'Messages' => 'Nachricht',
        'Audit' => 'Audit',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => 'Geocode',
        'DRI_Workflows' => 'Smart Guide',
        'DRI_Workflow_Task_Templates' => 'Smart Guide Aktivitätsvorlagen',
        'DRI_SubWorkflows' => 'Smart Guide Stufen',
        'DRI_Workflow_Templates' => 'Smart Guide Vorlage',
        'CJ_WebHooks' => 'Sugar Automate Web-Hook',
        'CJ_Forms' => 'Smart Guide Sugar-Aktion',
        'DRI_SubWorkflow_Templates' => 'Smart Guide Stufenvorlage',
        'PubSub_ModuleEvent_PushSubs' => 'Pub/Sub-Modul-Event-Push-Abonnement',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'Ja',
        '2' => 'Nein',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'Nein',
        1 => 'Ja',
    ],

    'notifications_status_dom' => [
        0 => 'Ungelesen',
        1 => 'Gelesen',
    ],

    'optout_dom' => [
        '' => '--kein(e)--',
        'false' => 'Nein',
        'true' => 'Ja',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'Analytiker',
        'Competitor' => 'Mitbewerber',
        'Customer' => 'Kunde',
        'Integrator' => 'Integrator',
        'Investor' => 'Investor',
        'Partner' => 'Partner',
        'Press' => 'Presse',
        'Prospect' => 'Potentieller Kunde',
        'Reseller' => 'Wiederverkäufer',
        'Other' => 'Andere',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'Bekleidungsindustrie',
        'Banking' => 'Bankwesen',
        'Biotechnology' => 'Biotechnologie',
        'Chemicals' => 'Chemieindustrie',
        'Communications' => 'Kommunikation',
        'Construction' => 'Baugewerbe',
        'Consulting' => 'Beratung',
        'Education' => 'Bildungwesen',
        'Electronics' => 'Elektronik',
        'Energy' => 'Energiesektor',
        'Engineering' => 'Entwicklung',
        'Entertainment' => 'Unterhaltungsindustrie',
        'Environmental' => 'Umwelt',
        'Finance' => 'Finanzwesen',
        'Government' => 'Regierung',
        'Healthcare' => 'Gesundheitswesen',
        'Hospitality' => 'Gastgewerbe',
        'Insurance' => 'Versicherung',
        'Machinery' => 'Maschinenbau',
        'Manufacturing' => 'Produktion',
        'Media' => 'Medien',
        'Not For Profit' => 'Gemeinnützige Organisation',
        'Recreation' => 'Freizeitindustrie',
        'Retail' => 'Einzelhandel',
        'Shipping' => 'Versandhandel',
        'Technology' => 'Technologie',
        'Telecommunications' => 'Telekommunikation',
        'Transportation' => 'Transportwesen',
        'Utilities' => 'Energieversorger',
        'Other' => 'Andere',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF und CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'Diagramm',
        'Data Table' => 'Datentabelle',
        'Chart and Data Table' => 'Diagramm und Datentabelle',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'In Bearbeitung',
        'Completed' => 'Abgeschlossen',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'Eingehend',
        'Outbound' => 'Ausgehend',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'Chat',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'Ebene 1',
        'T2' => 'Ebene 2',
        'T3' => 'Ebene 3',
        'T4' => 'Ebene 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nein',
        'Completed' => 'Abgeschlossen',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'Zukunft',
        'Active' => 'Aktiv',
        'Past' => 'Vergangen',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'Selbst generiert',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'Kaltakquise',
        'Existing Customer' => 'Bestehender Kunde',
        'Self Generated' => 'Selbst generiert',
        'Employee' => 'Mitarbeiter',
        'Partner' => 'Partner',
        'Public Relations' => 'Public Relations',
        'Direct Mail' => 'Aussendung',
        'Conference' => 'Konferenz',
        'Trade Show' => 'Messe',
        'Web Site' => 'Webseite',
        'Word of mouth' => 'Mund zu Mund-Propaganda',
        'Email' => 'E-Mail',
        'Campaign' => 'Kampagne',
        'Support Portal User Registration' => 'Benutzerregistrierung für Support-Portal',
        'Other' => 'Andere',
    ],
    'metric_status_dom' => [
        'Inactive' => 'Inaktiv',
        'Active' => 'Aktiv',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'Bestandsgeschäft',
        'New Business' => 'Neugeschäft',
    ],
    'taxrate_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
    ],
    'roi_type_dom' => [
        'Revenue' => 'Umsatz',
        'Investment' => 'Investition',
        'Expected_Revenue' => 'Erwarteter Umsatz',
        'Budget' => 'Budget',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'Primäre Entscheidungsträger',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primäre Entscheidungsträger',
        'Business Decision Maker' => 'Business-Entscheidungsträger',
        'Business Evaluator' => 'Business-Vorentscheider',
        'Technical Decision Maker' => 'Technischer Entscheidungsträger',
        'Technical Evaluator' => 'Technik Vorentscheider',
        'Executive Sponsor' => 'Unternehmens-Sponsor',
        'Influencer' => 'Einflussreiche Person',
        'Other' => 'Andere',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
    ],

    'shipper_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'Hauptansprechpartner',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'Hauptansprechpartner',
        'Alternate Contact' => 'Zweitkontakt',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'Neben dem Feldwert',
        'field_on_top' => 'Über dem Feldwert',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => '15 Tage netto',
        'Net 30' => '30 Tage netto',
    ],
    'sales_stage_default_key' => 'Prospektion',
    'fts_type' => [
        'Elastic' => 'Elastische Suche',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'Prospektion',
        'Qualification' => 'Qualifikation',
        'Needs Analysis' => 'Bedarfserhebung',
        'Value Proposition' => 'Richtangebot',
        'Id. Decision Makers' => 'Entscheider ident.',
        'Perception Analysis' => 'Wahrnehmungsanalyse',
        'Proposal/Price Quote' => 'Preisangebot',
        'Negotiation/Review' => 'Verhandlung/Überarbeitung',
        'Closed Won' => 'Abgeschlossen',
        'Closed Lost' => 'Geschlossen/Verloren',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'Neu',
        'In Progress' => 'In Bearbeitung',
        'Closed Won' => 'Abgeschlossen',
        'Closed Lost' => 'Geschlossen/Verloren',
        'Converted to Quote' => 'Zu Angebot konvertiert',
    ],
    'sales_status_dom' => [
        'New' => 'Neu',
        'In Progress' => 'In Bearbeitung',
        'Closed Won' => 'Abgeschlossen',
        'Closed Lost' => 'Geschlossen/Verloren',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'inkludieren',
        'exclude' => 'exkludieren',
    ],
    'commit_stage_dom' => [
        'include' => 'inkludieren',
        'upside' => 'Oberseite',
        'exclude' => 'exkludieren',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'inkludieren',
        'upside' => 'Oberseite',
        'exclude' => 'exkludieren',
    ],

    'in_total_group_stages' => [
        'Draft' => 'Entwurf',
        'Negotiation' => 'Verhandlung',
        'Delivered' => 'Ausgeliefert',
        'On Hold' => 'In Warteschlange',
        'Confirmed' => 'Bestätigt',
        'Closed Accepted' => 'akzeptierter Abschluss',
        'Closed Lost' => 'Geschlossen/Verloren',
        'Closed Dead' => 'abgebrochener Abschluss',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'Anruf',
        'Meeting' => 'Meeting',
        'Task' => 'Aufgabe',
        'Email' => 'E-Mail',
        'Note' => 'Notiz',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'Herr',
        'Ms.' => 'Frau',
        'Mrs.' => 'Frau',
        'Dr.' => 'Dr.',
        'Prof.' => 'Prof.',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'keine Erinnerungszeit',
        60 => '1 Minute vorher',
        300 => '5 Minuten vorher',
        600 => '10 Minuten vorher',
        900 => '15 Minuten vorher',
        1800 => '30 Minuten vorher',
        3600 => '1 Stunde vorher',
        7200 => '2 Stunden vorher',
        10800 => '3 Stunden vorher',
        18000 => '5 Stunden vorher',
        86400 => '1 Tag vorher',
        ],

        'task_priority_default' => 'Mittel',
        'task_priority_dom' => [
        'High' => 'Hoch',
        'Medium' => 'Mittel',
        'Low' => 'Niedrig',
        ],
        'task_status_default' => 'Noch nicht gestartet',
        'task_status_dom' => [
        'Not Started' => 'Noch nicht gestartet',
        'In Progress' => 'In Bearbeitung',
        'Completed' => 'Abgeschlossen',
        'Pending Input' => 'Eingabe ausstehend',
        'Deferred' => 'Zurückgestellt',
        'Not Applicable' => 'Nicht zutreffend',
        ],
        'meeting_status_default' => 'Geplant',
        'meeting_status_dom' => [
        'Planned' => 'Geplant',
        'Held' => 'Durchgeführt',
        'Not Held' => 'Abgesagt',
        'Deferred' => 'Zurückgestellt',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'Andere',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'Geplant',
        'call_status_dom' => [
        'Planned' => 'Geplant',
        'In Progress' => 'In Bearbeitung',
        'Held' => 'Durchgeführt',
        'Not Held' => 'Abgesagt',
        'Deferred' => 'Zurückgestellt',
        ],
        'call_direction_default' => 'Ausgehend',
        'call_direction_dom' => [
        'Inbound' => 'Eingehend',
        'Outbound' => 'Ausgehend',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'Neu',
        'Assigned' => 'Zugewiesen',
        'In Process' => 'In Bearbeitung',
        'Converted' => 'Konvertiert',
        'Recycled' => 'Wiedereröffnet',
        'Dead' => 'Tot',
        ],
        'gender_list' => [
        'male' => 'Männlich',
        'female' => 'Weiblich',
        'other' => 'Andere',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'Neu',
        'case_status_dom' => [
        'New' => 'Neu',
        'Assigned' => 'Zugewiesen',
        'Closed' => 'Geschlossen',
        'Pending Input' => 'Eingabe ausstehend',
        'Rejected' => 'Abgelehnt',
        'Duplicate' => 'Duplizieren',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'Hoch',
        'P2' => 'Mittel',
        'P3' => 'Niedrig',
        ],
        'user_type_dom' => [
        'RegularUser' => 'Normaler Benutzer',
        'Administrator' => 'Administrator',
        ],
        'user_type_bool_dom' => [
            false => 'Normale:r Benutzer:in',
            true => 'Administrator:in',
        ],
        'user_type_group_bool_dom' => [
            true => 'Gruppen-Benutzer:in',
        ],
        'user_type_portal_bool_dom' => [
            true => 'Portal API-Benutzer:in',
        ],
        'license_type_dom' => [
        'CURRENT' => 'Aktuelles Produkt',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'employee_status_dom' => [
        'Active' => 'Aktiv',
        'Terminated' => 'Beendet',
        'Leave of Absence' => 'Abwesend',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'project_task_priority_options' => [
        'High' => 'Hoch',
        'Medium' => 'Mittel',
        'Low' => 'Niedrig',
        ],
        'project_task_priority_default' => 'Mittel',

        'project_task_status_options' => [
        'Not Started' => 'Noch nicht gestartet',
        'In Progress' => 'In Bearbeitung',
        'Completed' => 'Abgeschlossen',
        'Pending Input' => 'Eingabe ausstehend',
        'Deferred' => 'Zurückgestellt',
        ],
        'project_task_utilization_options' => [
        '0' => 'nichts',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'Entwurf',
        'In Review' => 'In Durchsicht',
        'Published' => 'Veröffentlicht',
        ],
        'project_status_default' => 'Entwurf',

        'project_duration_units_dom' => [
        'Days' => 'Tage',
        'Hours' => 'Stunden',
        ],

        'project_priority_options' => [
        'High' => 'Hoch',
        'Medium' => 'Mittel',
        'Low' => 'Niedrig',
        ],
        'project_priority_default' => 'Mittel',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Firmen',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'Firma',
        'Opportunities' => 'Verkaufschance',
        'Cases' => 'Ticket',
        'Leads' => 'Interessent',
        'Contacts' => 'Kontakte', // cn (11/22/2005) added to support Emails
        'Products' => 'Produkt',
        'Quotes' => 'Angebot',
        'Bugs' => 'Fehler',
        'Project' => 'Projekt',

        'Prospects' => 'Zielkontakt',
        'ProjectTask' => 'Projektaufgabe',

        'Tasks' => 'Aufgabe',
        'KBContents' => 'Wissensdatenbank',
        'Notes' => 'Hinweis',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'Firma',
        'Contacts' => 'Kontakt',
        'Opportunities' => 'Verkaufschance',
        'Tasks' => 'Aufgabe',
        'ProductTemplates' => 'Produktkatalog',
        'Quotes' => 'Angebot',
        'Products' => 'Produkt',
        'Contracts' => 'Vertrag',
        'Emails' => 'E-Mail',

        'Bugs' => 'Fehler',
        'Project' => 'Projekt',
        'ProjectTask' => 'Projektaufgabe',
        'Prospects' => 'Zielkontakt',
        'Cases' => 'Ticket',
        'Leads' => 'Interessent',

        'Meetings' => 'Meeting',
        'Calls' => 'Anruf',
        'KBContents' => 'Wissensdatenbank',
        'PurchasedLineItems' => 'Gekauftes Produkt',
        'Purchases' => 'Einkauf',
        'Escalations' => 'Eskalation',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'Firma',
        'Contacts' => 'Kontakt',
        'Employees' => 'Mitarbeiter',
        'Leads' => 'Interessent',
        'Prospects' => 'Ziel',
        'Users' => 'Benutzer',
        ],

        'parent_type_display' => [
        'Accounts' => 'Firma',
        'Contacts' => 'Kontakt',
        'Tasks' => 'Aufgabe',
        'Opportunities' => 'Verkaufschance',
        'Products' => 'Produkt',
        'Quotes' => 'Angebot',

        'Bugs' => 'Fehler',
        'Cases' => 'Ticket',
        'Leads' => 'Interessent',

        'Project' => 'Projekt',
        'ProjectTask' => 'Projektaufgabe',

        'Prospects' => 'Zielkontakt',
        'KBContents' => 'Wissensdatenbank',
        'Notes' => 'Hinweis',
        'PurchasedLineItems' => 'Gekauftes Produkt',
        'Purchases' => 'Einkauf',
        'Escalations' => 'Eskalation',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'Ticket',
        ],

        'product_status_default_key' => 'Versenden',
        'product_status_quote_key' => 'Angebote',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'angeboten',
        'Orders' => 'Bestellung',
        'Ship' => 'Versandt',
        ],
        'active_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        'Retired' => 'Deaktiviert',
        ],
        'appearance_options' => [
        'system_default' => 'Systemeinstellung verwenden',
        'light' => 'Hell',
        'dark' => 'Dunkel',
        ],


        'pricing_formula_default_key' => 'Behoben',
        'pricing_formula_dom' => [
        'Fixed' => 'Fixpreis',
        'ProfitMargin' => 'Bruttogewinn',
        'PercentageMarkup' => 'prozentualer Bruttogewinn',
        'PercentageDiscount' => 'Rabatt vom Listenpreis',
        'IsList' => 'wie Listenpreis',
        ],
        'product_template_status_dom' => [
        'Available' => 'Verfügbar',
        'Unavailable' => 'Nicht verfügbar',
        ],
        'tax_class_dom' => [
        'Taxable' => 'steuerpflichtig',
        'Non-Taxable' => 'steuerfrei',
        ],
        'support_term_dom' => [
        '+6 months' => 'Sechs Monate',
        '+1 year' => 'Ein Jahr',
        '+2 years' => 'Zwei Jahre',
        ],

        'quote_type_dom' => [
        'Quotes' => 'Angebot',
        'Orders' => 'Position',
        ],
        'default_quote_stage_key' => 'Entwurf',
        'quote_stage_dom' => [
        'Draft' => 'Entwurf',
        'Negotiation' => 'Verhandlung',
        'Delivered' => 'Ausgeliefert',
        'On Hold' => 'In Warteschlange',
        'Confirmed' => 'Bestätigt',
        'Closed Accepted' => 'akzeptierter Abschluss',
        'Closed Lost' => 'Geschlossen/Verloren',
        'Closed Dead' => 'abgebrochener Abschluss',
        ],
        'default_order_stage_key' => 'Ausstehend',
        'order_stage_dom' => [
        'Pending' => 'Ausstehend',
        'Confirmed' => 'Bestätigt',
        'On Hold' => 'In Warteschlange',
        'Shipped' => 'Versandt',
        'Cancelled' => 'Storniert',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'Primäre Entscheidungsträger',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primäre Entscheidungsträger',
        'Business Decision Maker' => 'Business-Entscheidungsträger',
        'Business Evaluator' => 'Business-Vorentscheider',
        'Technical Decision Maker' => 'Technischer Entscheidungsträger',
        'Technical Evaluator' => 'Technik Vorentscheider',
        'Executive Sponsor' => 'Unternehmens-Sponsor',
        'Influencer' => 'Einflussreiche Person',
        'Other' => 'Andere',
        ],
        'layouts_dom' => [
        'Standard' => 'Angebot',
        'Invoice' => 'Rechnung',
        ],
        'issue_priority_default_key' => 'Mittel',
        'issue_priority_dom' => [
        'Urgent' => 'Dringend',
        'High' => 'Hoch',
        'Medium' => 'Mittel',
        'Low' => 'Niedrig',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'Akzeptiert',
        'Duplicate' => 'Duplizieren',
        'Closed' => 'Geschlossen',
        'Out of Date' => 'Abgelaufen',
        'Invalid' => 'Ungültig',
        ],

        'issue_status_default_key' => 'Neu',
        'issue_status_dom' => [
        'New' => 'Neu',
        'Assigned' => 'Zugewiesen',
        'Closed' => 'Geschlossen',
        'Pending' => 'Ausstehend',
        'Rejected' => 'Abgelehnt',
        ],

        'bug_priority_default_key' => 'Mittel',
        'bug_priority_dom' => [
        'Urgent' => 'Dringend',
        'High' => 'Hoch',
        'Medium' => 'Mittel',
        'Low' => 'Niedrig',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'Akzeptiert',
        'Duplicate' => 'Duplizieren',
        'Fixed' => 'Behoben',
        'Out of Date' => 'Abgelaufen',
        'Invalid' => 'Ungültig',
        'Later' => 'Später',
        ],
        'bug_status_default_key' => 'Neu',
        'bug_status_dom' => [
        'New' => 'Neu',
        'Assigned' => 'Zugewiesen',
        'Closed' => 'Geschlossen',
        'Pending' => 'Ausstehend',
        'Rejected' => 'Abgelehnt',
        ],
        'bug_type_default_key' => 'Fehler',
        'bug_type_dom' => [
        'Defect' => 'Defekt',
        'Feature' => 'Eigenschaft',
        ],
        'case_type_dom' => [
        'Administration' => 'Administration',
        'Product' => 'Produkt',
        'User' => 'Benutzer',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'E-Mail',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'E-Mail',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        'Phone' => 'Telefon',
        'Chat' => 'Chat',
        'Chatbot' => 'Chatbot',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'Anfrage für Datenschutzerklärung',
        'Send Personal Information being processed' => 'Persönliche Informationen, die verarbeitet werden, senden',
        'Rectify Information' => 'Informationen berichtigen',
        'Request to Erase Information' => 'Anfrage, Informationen zu löschen',
        'Export Information' => 'Informationen exportieren',
        'Restrict Processing' => 'Verarbeitung einschränken',
        'Object to Processing' => 'Einspruch gegen Verarbeitung',
        'Consent to Process' => 'Zustimmung zu Verarbeitung',
        'Withdraw Consent' => 'Einwilligung widerrufen',
        'Other' => 'Andere',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'Business-Mitteilungen',
        'Marketing Communications by company' => 'Marketing-Mitteilung nach Firma',
        'Marketing Communications by partners' => 'Marketing-Mitteilung nach Partnern',
        ],
        'dataprivacy_status_default_key' => 'Öffnen',
        'dataprivacy_status_dom' => [
        'Open' => 'Öffnen',
        'Closed' => 'Abgeschlossen',
        'Rejected' => 'Abgelehnt',
        ],
        'dataprivacy_priority_default_key' => 'Niedrig',
        'dataprivacy_priority_dom' => [
        'Low' => 'Niedrig',
        'Medium' => 'Mittel',
        'High' => 'Hoch',
        ],
        'business_day_status_dom' => [
        'Open' => 'Geöffnet',
        'Open 24 Hours' => '24 Stunden geöffnet',
        'Closed' => 'Geschlossen',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'Firmen',
        'Activities' => 'Aktivitäten',
        'Bug Tracker' => 'Fehlerverfolgung',
        'Calendar' => 'Kalender',
        'Calls' => 'Anrufe',
        'Campaigns' => 'Kampagnen',
        'Cases' => 'Tickets',
        'Contacts' => 'Kontakte',
        'Currencies' => 'Währungen',
        'Dashboard' => 'Dashboard',
        'Documents' => 'Dokumente',
        'Emails' => 'E-Mails',
        'Feeds' => 'Feeds',
        'Forecasts' => 'Prognosen',
        'Help' => 'Hilfe',
        'Home' => 'Startseite',
        'Leads' => 'Interessenten',
        'Meetings' => 'Meetings',
        'Notes' => 'Notizen',
        'Opportunities' => 'Verkaufschancen',
        'Outlook Plugin' => 'Outlook-Plugin',
        'Product Catalog' => 'Produktkatalog',
        'Products' => 'Produkte',
        'RevenueLineItems' => 'Umsatzposten',
        'Projects' => 'Projekte',
        'Quotes' => 'Angebote',
        'Releases' => 'Versionen',
        'RSS' => 'RSS',
        'Studio' => 'Studio',
        'Upgrade' => 'Aktualisieren:',
        'Users' => 'Benutzer',
        'OutboundEmail' => 'E-Mail-Einstellungen',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'Planung',
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        'Complete' => 'Fertig',
        'In Queue' => 'in Warteschlange',
        'Sending' => 'wird gesendet',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'Telefonverkauf',
        'Mail' => 'Post',
        'Email' => 'E-Mail',
        'Print' => 'Drucken',
        'Web' => 'Web',
        'Radio' => 'Radio',
        'Television' => 'Fernsehen',
        'NewsLetter' => 'Newsletter',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'wöchentlich',
        'Monthly' => 'Monatlich',
        'Quarterly' => 'alle 3 Monate',
        'Annually' => 'Jährlich',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'Januar',
        '2' => 'Februar',
        '3' => 'März',
        '4' => 'April',
        '5' => 'Mai',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'August',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'Dezember',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'Jan',
        '2' => 'Feb',
        '3' => 'Mär',
        '4' => 'Apr',
        '5' => 'Mai',
        '6' => 'Jun',
        '7' => 'Jul',
        '8' => 'Aug',
        '9' => 'Sep',
        '10' => 'Okt',
        '11' => 'Nov',
        '12' => 'Dez',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'Sonntag',
        '2' => 'Montag',
        '3' => 'Dienstag',
        '4' => 'Mittwoch',
        '5' => 'Donnerstag',
        '6' => 'Freitag',
        '7' => 'Samstag',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'So',
        '2' => 'Mo',
        '3' => 'Di',
        '4' => 'Mi',
        '5' => 'Do',
        '6' => 'Fr',
        '7' => 'Sa',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'So',
        '2' => 'Mo',
        '3' => 'Di',
        '4' => 'Mi',
        '5' => 'Do',
        '6' => 'Fr',
        '7' => 'Sa',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'So',
        '1' => 'Mo',
        '2' => 'Di',
        '3' => 'Mi',
        '4' => 'Do',
        '5' => 'Fr',
        '6' => 'Sa',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'am',
        'pm' => 'pm',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => 'Zeilen und Spalten',
        'summary' => 'Summe',
        'detailed_summary' => 'Summe mit Details',
        'Matrix' => 'Matrix',
        ],


        'dom_email_types' => [
        'out' => 'Gesendet',
        'archived' => 'Archiviert',
        'draft' => 'Entwurf',
        'inbound' => 'Eingehend',
        'campaign' => 'Kampagne',
        ],
        'dom_email_status' => [
        'archived' => 'Archiviert',
        'closed' => 'Geschlossen',
        'draft' => 'Entwurf',
        'read' => 'Gelesen',
        'replied' => 'Beantwortet',
        'sent' => 'Gesendet',
        'send_error' => 'Sende-Fehler',
        'unread' => 'Ungelesen',
        ],
        'dom_email_archived_status' => [
        'archived' => 'Archiviert',
        ],

        'dom_email_server_type' => ['' => '--Kein(e)--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--Kein(e)--',
        'createcase' => 'Neues Tickets',
        'bounce' => 'Nicht zustellbare bearbeiten',
        ],
        'dom_email_distribution' => ['' => '--Kein(e)--',
        'direct' => 'Direkt zuweisen',
        'roundRobin' => 'Umlauf-Verfahren',
        'leastBusy' => 'geringste Auslastung',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'Umlauf-Verfahren',
        'leastBusy' => 'geringste Auslastung',
        'none' => 'Keine',
        ],
        'dom_email_errors' => [1 => 'Beim direkt Zuweisen nur 1 Mitarbeiter auswählen.',
        2 => 'Beim direkt Zuweisen müssen die markierten Elemente zugewiesen werden.',
        ],
        'dom_email_bool' => ['bool_true' => 'Ja',
        'bool_false' => 'Nein',
        ],
        'dom_int_bool' => [1 => 'Ja',
        0 => 'Nein',
        ],
        'dom_switch_bool' => ['on' => 'Ja',
        'off' => 'Nein',
        '' => 'Nein',],

        'dom_email_link_type' => ['sugar' => 'SugarCRM E-Mail-Client',
        'mailto' => 'Externer E-Mail-Client'],


        'dom_email_editor_option' => ['' => 'Standard E-Mail-Format',
        'html' => 'HTML E-Mail',
        'plain' => 'Nur-Text-E-Mail'],

        'schedulers_times_dom' => ['not run' => 'Zeitvorgabe abgelaufen, nicht ausgeführt',
        'ready' => 'Bereit',
        'in progress' => 'In Bearbeitung',
        'failed' => 'Fehlgeschlagen',
        'completed' => 'Abgeschlossen',
        'no curl' => 'Nicht gelaufen: cURL nicht verfügbar',
        ],

        'dom_email_states' => [
        'Draft' => 'Entwurf',
        'Archived' => 'Archiviert',
        ],

        'dom_email_direction' => [
        'Unknown' => 'Unbekannt',
        'Outbound' => 'Ausgehend',
        'Inbound' => 'Eingehend',
        'Internal' => 'Intern',
        ],

        'scheduler_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],

        'scheduler_period_dom' => [
        'min' => 'Minuten',
        'hour' => 'Stunden',
        ],
        'forecast_type_dom' => [
        'Direct' => 'Direkt',
        'Rollup' => 'Rollup',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'Marketingseite',
        'Knowledge Base' => 'Wissendatenbank',
        'Sales' => 'Verkaufsseite',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'Werbematerial',
        'Product Brochures' => 'Produktbroschüren',
        'FAQ' => 'Häufig gestellte Fragen',
        ],

        'document_status_dom' => [
        'Active' => 'Aktiv',
        'Draft' => 'Entwurf',
        'FAQ' => 'Häufig gestellte Fragen',
        'Expired' => 'Abgelaufen',
        'Under Review' => 'Wird überprüft',
        'Pending' => 'Ausstehend',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'Serienbrief',
        'eula' => 'EULA',
        'nda' => 'Vertraulichkeitserklärung',
        'license' => 'Lizenzvereinbarung',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'Bestätigen',
        'decline' => 'Ablehnen',
        'tentative' => 'Vorläufig',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'Akzeptiert',
        'decline' => 'Abgelehnt',
        'tentative' => 'Vorläufig',
        'none' => 'nichts',
        ],
        'dataset_output_default_dom' => [
        'table' => 'Tabelle',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'Einzelmodul',
        'Multi Module' => 'Multimodul',
        ],
        'report_align_dom' => [
        'left' => 'Links',
        'center' => 'Mitte',
        'right' => 'Rechts',
        ],

        'width_type_dom' => [
        '%' => 'Prozent (%)',
        'px' => 'Pixel (px)',
        ],
        'report_color_dom' => [
        '' => 'Standard',
        'black' => 'Schwarz',
        'green' => 'Grün',
        'blue' => 'Blau',
        'red' => 'Rot',
        'white' => 'Weiß',
        'DarkGreen' => 'Dunkelgrün',
        'LightGray' => 'Hellgrau',
        'DodgerBlue' => 'Dunkelblau',
        'LightBlue' => 'Hellblau',
        ],
        'font_size_dom' => [
        '-5' => 'Kleiner (-5)',
        '-4' => 'Kleiner (-4)',
        '-3' => 'Kleiner (-3)',
        '-2' => 'Kleiner (-2)',
        '-1' => 'Kleiner (-1)',
        'Default' => 'Standard',
        '1' => 'Größer (+1)',
        '2' => 'Größer (+2)',
        '3' => 'Größer (+3)',
        '4' => 'Größer (+4)',
        '5' => 'Größer (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'Hauptabfrage',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'Anzeige',
//  'Group By' => 'Group By',
        'Calculation' => 'Berechnung',
        ],
        'query_display_type_dom' => [
        'Default' => 'Standard',
        'Custom' => 'Benutzerdefiniert',
        'Hidden' => 'Ausgeblendet',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'Tag',
        'Week' => 'Woche',
        'Month' => 'Monat',
        'Quarter' => 'Quartal',
        'Year' => 'Jahr',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'Jetzt',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'SUMME',
        'AVG' => 'AVG',
        'COUNT' => 'Zähler',
        'STDDEV' => 'Standardabweichung',
        'VARIANCE' => 'Varianz',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'Feld',
        'Time' => 'Zeitababstand',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'Zeilen (Y-Achse)',
        'Columns' => 'Spalte (X-Achse)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'Summe (Gesamt)',
        'AVG' => 'Durchschnitt',
        'MAX' => 'Maximum',
        'MIN' => 'Minimum',
        'COUNT' => 'Zähler',
        'STDDEV' => 'Standardabweichung',
        'VARIANCE' => 'Varianz',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'Standard',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'Berechnung',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'Feld',
        'Value' => 'Wert',
        'Group' => 'Gruppe',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'Spalte',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'Deaktiviert',
        'Enabled' => 'Aktiv',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'Normal',
        'Scalar' => 'Skalar',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'Text',
        'Accounting' => 'Buchführung',
        'Date' => 'Datum',
        'Datetime' => 'Datum/Zeit',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'Jahr',
        'Quarter' => 'Quartal',
        'Month' => 'Monat',
        'Week' => 'Woche',
        'Day' => 'Tag',
        ],
        'dataset_style_dom' => [
        'normal' => 'Normal',
        'bold' => 'Fett',
        'italic' => 'Kursiv',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) Plus',
        '-' => '(-) Minus',
        '*' => '(*) Multiplikation',
        '/' => '(/) Division',
        ],
        'wflow_type_dom' => [
        'Normal' => 'Beim Speichern des Datensatzes',
        'Time' => 'Nach Zeitablauf',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Ist',
        'in' => 'Enthalten in',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'Enthalten in',
        'not_in' => 'Nicht enthalten in',
        ],
        'cselect_type_dom' => [
        'Equals' => 'Gleich',
        'Does not Equal' => 'Ungleich',
        ],
        'dselect_type_dom' => [
        'Equals' => 'Gleich',
        'Less Than' => 'Weniger als',
        'More Than' => 'Größer als',
        'Does not Equal' => 'Ungleich',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'Ja',
        'bool_false' => 'Nein',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'Gleich',
        ],
        'tselect_type_dom' => [
        '0' => '0 Stunden',
        '14440' => '4 Stunden',
        '28800' => '8 Stunden',
        '43200' => '12 Stunden',
        '86400' => '1 Tag',
        '172800' => '2 Tage',
        '259200' => '3 Tage',
        '345600' => '4 Tage',
        '432000' => '5 Tage',
        '604800' => '1 Woche',
        '1209600' => '2 Wochen',
        '1814400' => '3 Wochen',
        '2592000' => '30 Tage',
        '5184000' => '60 Tage',
        '7776000' => '90 Tage',
        '10368000' => '120 Tage',
        '12960000' => '150 Tage',
        '15552000' => '180 Tage',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'Größer als',
        'Less Than' => 'ist kleiner als',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'E-Mail',
        'Invite' => 'Einladung',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'Standard-Nachricht',
        'Custom Template' => 'Benutzerdefinierte Vorlage',
        'System Default' => 'Systemstandard',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'Aktuelle Benutzer',
        'rel_user' => 'Verknüpfte Benutzer',
        'rel_user_custom' => 'Verknüpfte Individualbenutzer',
        'specific_team' => 'Bestimmtes Team',
        'specific_role' => 'Bestimmte Rolle',
        'specific_user' => 'Bestimmte Benutzer',
        ],
        'wflow_array_type_dom' => [
        'future' => 'Neuer Wert',
        'past' => 'Alter Wert',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'Benutzer',
        'Manager' => "Manager des Benutzers",
        ],
        'wflow_address_type_dom' => [
        'to' => 'An:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'An:',
        'cc' => 'CC:',
        'bcc' => 'BCC:',
        'invite_only' => '(Nur Einladungen)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'An:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'Datensatz aktualisieren',
        'update_rel' => 'Verknüpfte Datensätze aktualisieren',
        'new' => 'Neuer Datensatz',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'Zeitpunkt der Ausführung',
        'Existing Value' => 'bestehender Wert',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'Standard-Optionen',
        'Advanced' => 'Erw. Optionen',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'Benutzer, der dem ausgelösten Eintrag zugewiesen ist',
        'modified_user_id' => 'Benutzer, der den ausgelösten Eintrag zuletzt geändert hat',
        'created_by' => 'Benutzer, der den ausgelösten Eintrag erstellt hat',
        'current_user' => 'Angemeldeter Benutzer',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'Derzeitiges Team des ausgelösten Eintrags',
        'team_set_id' => 'Satz der ausgelösten Datesätze des aktullen Teams',
        'current_team' => 'Team des angemeldeten Benutzers',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'Dropdown nach hinten verschieben um ',
        'advance' => 'Dropdown nach vorne verschieben um ',
        ],
        'wflow_record_type_dom' => [
        'All' => 'Neue und bestehende Einträge',
        'New' => 'Nur neue Einträge',
        'Update' => 'Nur bestehende Einträge',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'Alle zugehörigen',
        //'first' => 'The first related',
        'filter' => 'Zugehörige filtern',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'Alle zugehörigen',
        'any' => 'Alle zugehörigen',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'Alarm dann Aktionen',
        'actions_alerts' => 'Aktionen dann Alarm'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'nichts',
        'Daily' => 'täglich',
        'Weekly' => 'wöchentlich',
        'Monthly' => 'Monatlich',
        'Yearly' => 'Jährlich',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'Tage',
        'Weekly' => 'wöchentlich',
        'Monthly' => 'monatlich',
        'Yearly' => 'Jährlich',
        ],

        'repeat_end_types' => [
        'Until' => 'Bis',
        'Occurrences' => 'Ereignisse',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'Nichts',
        'Each' => 'Jedes',
        'On' => 'Am',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'erster',
        'second' => 'zweiter',
        'third' => 'dritter',
        'fourth' => 'vierter',
        'fifth' => 'fünfter',
        'last' => 'letzter',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'Sonntag',
        'Mon' => 'Montag',
        'Tue' => 'Dienstag',
        'Wed' => 'Mittwoch',
        'Thu' => 'Donnerstag',
        'Fri' => 'Freitag',
        'Sat' => 'Samstag',
        'Day' => 'Tag',
        'WD' => 'Wochentag',
        'WE' => 'Tag am Wochenende',
        ],

        'duration_dom' => [
        '' => 'nichts',
        '900' => '15 Minuten',
        '1800' => '30 Minuten',
        '2700' => '45 Minuten',
        '3600' => '1 Stunde',
        '5400' => '1,5 Stunden',
        '7200' => '2 Stunden',
        '10800' => '3 Stunden',
        '21600' => '6 Stunden',
        '86400' => '1 Tag',
        '172800' => '2 Tage',
        '259200' => '3 Tage',
        '604800' => '1 Woche',
        ],
        'repeat_month_dom' => [
        '1' => 'Januar',
        '2' => 'Februar',
        '3' => 'März',
        '4' => 'April',
        '5' => 'Mai',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'August',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'Dezember',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'Standard',
        'seed' => 'Muster',
        'exempt_domain' => 'Unterdrückungs-Liste - nach Domäne',
        'exempt_address' => 'Unterdrückungs-Liste - nach E-Mail-Adresse',
        'exempt' => 'Unterdrückungs-Liste - nach ID',
        'test' => 'Testliste',
        ],
        'currency_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'Aktiv',
        'inactive' => 'Inaktiv',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'Nachricht gesendet/versucht',
        'send error' => 'Nicht zustellbar, andere',
        'invalid email' => 'Nicht zustellbar, ungültige E-Mail',
        'link' => 'Klickbarer Link',
        'viewed' => 'Gelesene Mitteilung',
        'removed' => 'Abgelehnt',
        'lead' => 'Erstellte Intessenten',
        'contact' => 'Neue Kontakte',
        'blocked' => 'Abgelehnt durch Adresse oder Domäne',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'Kontakte',
        'Users' => 'Benutzer',
        'Prospects' => 'Zielkontakte',
        'Leads' => 'Interessenten',
        'Accounts' => 'Firmen',
        ],
        'merge_operators_dom' => [
        'like' => 'Enthält',
        'exact' => 'Genau',
        'start' => 'Beginnt mit',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'Ja',
        'false' => 'Nein',
        'required' => 'Erforderlich',
        ],

        'fts_field_config' => [
        '0' => 'Deaktiviert',
        '2' => 'Durchsuchbar',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'Deaktiviert',
        1 => 'Aktiv',
        2 => 'Im Filter',
        3 => 'Standard-Filterauswahl',
        4 => 'Nur Filter',
        ],

        'navigation_paradigms' => [
        'm' => 'Module',
        'gm' => 'Gruppierte Module',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'Noch nicht gestartet',
        'inprogress' => 'In Bearbeitung',
        'signed' => 'Unterzeichnet',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'Monatlich',
        'quarterly' => 'alle 3 Monate',
        'halfyearly' => 'Halbjährlich',
        'yearly' => 'Jährlich',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 Tag',
        '3' => '3 Tage',
        '5' => '5 Tage',
        '7' => '1 Woche',
        '14' => '2 Wochen',
        '21' => '3 Wochen',
        '31' => '1 Monat',
        ],
        'projects_priority_options' => [
        'high' => 'Hoch',
        'medium' => 'Mittel',
        'low' => 'Niedrig',
        ],

        'projects_status_options' => [
        'notstarted' => 'Noch nicht gestartet',
        'inprogress' => 'In Bearbeitung',
        'completed' => 'Abgeschlossen',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'Legende anzeigen',
        'collapselegend' => 'Legende verbergen',
        'clickfordrilldown' => 'Klick zum Drilldown',
        'drilldownoptions' => 'Drilldown-Optionen',
        'detailview' => 'Detailansicht...',
        'piechart' => 'Tortendiagramm',
        'groupchart' => 'Gruppendiagramm',
        'stackedchart' => 'Stapelgrafik',
        'barchart' => 'Balkendiagramm',
        'horizontalbarchart' => 'Waagrechtes Balkendiagramm',
        'linechart' => 'Liniendiagramm',
        'noData' => 'Daten nicht verfügbar',
        'print' => 'Drucken',
        'pieWedgeName' => 'Segment',
        ],
        'chart_types' => [
        'hBarF' => 'Waagerechter Balken (gestapelt)',
        'hGBarF' => 'Waagerechter Balken (gruppiert)',
        'vBarF' => 'Senkrechter Balken (gestapelt)',
        'vGBarF' => 'Senkrechter Balken (gruppiert)',
        'pieF' => 'Tortenstück',
        'funnelF' => 'Trichter',
        'lineF' => 'Linie',
        'donutF' => 'Donut',
        'treemapF' => 'Baumstruktur',
        ],
        'd3_value_placement' => [
        '0' => 'nichts',
        '1' => 'Standard',
        'start' => 'Start',
        'middle' => 'Mitte',
        'end' => 'Ende',
        'top' => 'Oben',
        'total' => 'Gesamt',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'Trichter',
        'hbar' => 'Waagrechter Balken',
        ],
        'release_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'email_settings_for_ssl' => [
        '0' => 'Kein(e)',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Google Weniger sichere Apps',
        'exchange' => 'Exchange',
        'other' => 'Andere',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'Andere',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'Hochkomma (&#39;)',
        '"' => 'Doppeltes Hochkomma (")',
        '' => 'nichts',
        'other' => 'Andere:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'Andere:',
        ],
        'link_target_dom' => [
        '_blank' => 'In neuem Fenster',
        '_self' => 'Im selben Fenster',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'Keine Auto-Aktualisierung',
        '30' => 'Alle 30 Sekunden',
        '60' => 'Jede Minute',
        '180' => 'Alle 3 Minuten',
        '300' => 'Alle 5 Minuten',
        '600' => 'Alle 10 Minuten',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'nichts',
        '15' => 'Alle 15 Minuten',
        '30' => 'Alle 30 Minuten',
        '45' => 'Alle 45 Minuten',
        '60' => 'Stündlich',
        '120' => 'Alle 2 Stunden',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'Nie',
        '30' => 'Alle 30 Sekunden',
        '60' => 'Jede Minute',
        '180' => 'Alle 3 Minuten',
        '300' => 'Alle 5 Minuten',
        '600' => 'Alle 10 Minuten',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'nichts',
        '1' => 'Jede Minute',
        '5' => 'Alle 5 Minuten',
        '10' => 'Alle 10 Minuten',
        '15' => 'Alle 15 Minuten',
        '30' => 'Alle 30 Minuten',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'Gleich',
        'not_equal' => 'Nicht an',
        'greater_than' => 'nach',
        'less_than' => 'vor',
        'last_7_days' => 'Letzten 7 Tage',
        'next_7_days' => 'Nächsten 7 Tage',
        'last_30_days' => 'Letzten 30 Tage',
        'next_30_days' => 'Nächsten 30 Tage',
        'last_month' => 'Letzten Monat',
        'this_month' => 'Diesen Monat',
        'next_month' => 'Nächster Monat',
        'last_year' => 'Letztes Jahr',
        'this_year' => 'Dieses Jahr',
        'next_year' => 'Nächstes Jahr',
        'between' => 'ist zwischen',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'Letztes Jahr',
        'last_month' => 'Letzten Monat',
        'last_30_days' => 'Letzten 30 Tage',
        'last_7_days' => 'Letzten 7 Tage',
        'this_month' => 'Diesen Monat',
        'this_year' => 'Dieses Jahr',
        'next_7_days' => 'Nächsten 7 Tage',
        'next_30_days' => 'Nächsten 30 Tage',
        'next_month' => 'Nächster Monat',
        'next_year' => 'Nächstes Jahr',
        ],
        'numeric_range_search_dom' => [
        '=' => 'Gleich',
        'not_equal' => 'Ungleich',
        'greater_than' => 'Größer als',
        'greater_than_equals' => 'Größer oder gleich',
        'less_than' => 'Weniger als',
        'less_than_equals' => 'Kleiner oder gleich',
        'between' => 'ist zwischen',
        ],

        'filter_checkbox_dom' => [
        0 => 'Falsch',
        1 => 'Wahr',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'Gewonnen',
        'lost' => 'Verloren',
        'active' => 'Aktiv',
        ],

        'sweetspot_theme_options' => [
        'default' => 'Standard',
        'light' => 'Hell',
        'dark' => 'Dunkel',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'Verschieben',
        'donothing' => 'Nichts machen',
        ],
        'processes_auto_save_interval' => [
        0 => 'Nie',
        30000 => 'Alle 30 Sekunden',
        60000 => 'Jede Minute',
        120000 => 'Alle 2 Minuten',
        180000 => 'Alle 3 Minuten',
        240000 => 'Alle 4 Minuten',
        300000 => 'Alle 5 Minuten',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nein',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'In Prognose',
        'sales_stage' => 'Verkaufsphase',
        'probability' => 'Wahrscheinlichkeit',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'Wahrscheinlich',
        'best' => 'Bestens',
        'worst' => 'Schlechtestens',
        ],
        'webLogicHookList' => [
        'after_save' => 'Nach Speichern',
        'after_delete' => 'Nach Löschen',
        'after_relationship_add' => 'Nach Relation hinzufügen',
        'after_relationship_delete' => 'Nach Relation löschen',
        'after_login' => 'Nach Login',
        'after_logout' => 'Nach Logout',
        'after_login_failed' => 'Nach fehlgeschlagenem Login',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'Aktiv',
        'INACTIVE' => 'Deaktiviert',
        ],
        'dashboard_view_name_list' => [
        'record' => 'Eintrag',
        'records' => 'Liste',
        'activities' => 'Aktivitäten-Stream',
        'multi-line' => 'Mehrzeilige Liste',
        'omnichannel' => 'Omnichannel',
        'home' => 'Home',
        'focus' => 'Fokus-Drawer',
        ],
        'metric_context_list' => [
        'service_console' => 'Service-Konsole',
        'renewals_console' => 'Erneuerungen-Konsole',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'Stündlich',
        '21600' => 'Alle 6 Stunden',
        '43200' => 'Alle 12 Stunden',
        '86400' => 'Täglich',
        '604800' => 'Wöchentlich',
        '1209600' => 'Alle 2 Wochen',
        '2419200' => 'Alle 4 Wochen',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'Jahr(e)',
        'month' => 'Monat(e)',
        'day' => 'Tag(e)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'Arbeitsfreie Zeit',
        'event' => 'Ereignis',
        'other' => 'Andere',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'Datum (letzter {{module}})',
        'start_date:asc' => 'Datum (erster {{module}})',
        'total_revenue:desc' => 'Preis (höchster Gesamtbetrag)',
        'total_revenue:asc' => 'Preis (geringster Gesamtbetrag)',
        ],
        'calendar_type_list' => [
        'main' => 'Kalenderzentrum',
        ],
        'calendar_views_options' => [
        'day' => 'Tag',
        'week' => 'Woche',
        'workWeek' => 'Arbeitswoche',
        'expandedMonth' => 'Monat',
        'agenda' => 'Agenda',
        'timeline' => 'Zeitleiste',
        'monthSchedule' => 'Zeitplaner',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'Erstellt',
        'completed' => 'Abgeschlossen',
        'declined' => 'Abgelehnt',
        'delivered' => 'Ausgeliefert',
        'sent' => 'Gesendet',
        'signed' => 'Unterzeichnet',
        'voided' => 'Unwirksam',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'Liste potenzieller Empfänger anzeigen',
        'dont_show' => 'Potenzielle Empfänger nicht anzeigen',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'Unterzeichner',
        'carbon_copy' => 'Betrachter (E-Mail-Kopie)',
        'certified_delivery' => 'Betrachter (Zertifizierte Lieferung)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'Standard',
        'color' => 'Farbe',
        'image' => 'Bild',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'Abkürzung',
        'icon' => 'Symbol',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'Pfeil nach unten',
        'sicon-chevron-left' => 'Chevron Links',
        'sicon-check' => 'Prüfen',
        'sicon-clock' => 'Uhr',
        'sicon-dashboard-default' => 'Dashboard-Standard',
        'sicon-dashboard' => 'Dashboard',
        'sicon-edit' => 'Bearbeiten',
        'sicon-caret-down' => 'Caret nach unten',
        'sicon-folder' => 'Ordner',
        'sicon-info' => 'Info',
        'sicon-kebab' => 'Kebab',
        'sicon-link' => 'Link',
        'sicon-list' => 'Liste',
        'sicon-logout' => 'Abmelden',
        'sicon-minus' => 'Minus',
        'sicon-folder-open' => 'Ordner öffnen',
        'sicon-plus-sm' => 'Plus Sm',
        'sicon-refresh' => 'Aktualisieren',
        'sicon-plus' => 'Plus',
        'sicon-settings' => 'Einstellungen',
        'sicon-arrow-right-double' => 'Doppelpfeil nach rechts',
        'sicon-reports' => 'Berichte',
        'sicon-user' => 'Benutzer',
        'sicon-upload' => 'Hochladen',
        'sicon-user-group' => 'Benutzergruppe',
        'sicon-arrow-left-double' => 'Doppelpfeil nach links',
        'sicon-chevron-up' => 'Chevron nach oben',
        'sicon-caret-up' => 'Caret nach oben',
        'sicon-star-fill' => 'Sternfüllung',
        'sicon-download' => 'Download',
        'sicon-close' => 'Beenden',
        'sicon-tile-view' => 'Kachelansicht',
        'sicon-list-view' => 'Listenansicht',
        'sicon-thumbs-down' => 'Daumen runter',
        'sicon-warning-circle' => 'Warnkreis',
        'sicon-phone' => 'Telefonnummer',
        'sicon-email' => 'E-Mail',
        'sicon-document' => 'Dokument',
        'sicon-note' => 'Notiz',
        'sicon-preview' => 'Vorschau',
        'sicon-copy' => 'Kopieren',
        'sicon-launch' => 'Starten',
        'sicon-lock' => 'Verriegeln',
        'sicon-arrow-top-right' => 'Pfeil oben rechts',
        'sicon-full-screen' => 'Vollbild',
        'sicon-full-screen-exit' => 'Vollbild beenden',
        'sicon-expand-left' => 'Nach links erweitern',
        'sicon-expand-right' => 'Nach rechts erweitern',
        'sicon-focus-drawer' => 'Focus Drawer',
        'sicon-ban' => 'Sperren',
        'sicon-thumbs-up' => 'Daumen hoch',
        'sicon-search' => 'Suchen',
        'sicon-calendar' => 'Kalender',
        'sicon-calendar-lg' => 'Kalender Lg',
        'sicon-mobile-lg' => 'Mobile Lg',
        'sicon-star-fill-lg' => 'Sternfüllung Lg',
        'sicon-star-outline-lg' => 'Sternumriss Lg',
        'sicon-reset-lg' => 'Zurücksetzen Lg',
        'sicon-exchange-lg' => 'Exchange Lg',
        'sicon-help-lg' => 'Hilfe Lg',
        'sicon-close-lg' => 'Schließen Lg',
        'sicon-plus-lg' => 'Plus Lg',
        'sicon-shortcuts-lg' => 'Schnellmenü Lg',
        'sicon-search-lg' => 'Suchen Lg',
        'sicon-email-lg' => 'E-Mail Lg',
        'sicon-note-lg' => 'Notiz Lg',
        'sicon-document-lg' => 'Dokument Lg',
        'sicon-add-dashlet-lg' => 'Dashlet hinzufügen Lg',
        'sicon-collapse-lg' => 'Einklappen Lg',
        'sicon-hamburger-lg' => 'Hamburger Lg',
        'sicon-pin-fill-lg' => 'Pin-Füllung Lg',
        'sicon-expand-lg' => 'Erweitern Lg',
        'sicon-copy-lg' => 'Kopieren Lg',
        'sicon-dashboard-lg' => 'Dashboard Lg',
        'sicon-star-outline' => 'Sternumriss',
        'sicon-reset' => 'Zurücksetzen',
        'sicon-unlink' => 'Verknüpfung aufheben',
        'sicon-phone-lg' => 'Telefonnummer Lg',
        'sicon-attach' => 'Anhängen',
        'sicon-case-lg' => 'Fall Lg',
        'sicon-arrow-right-lg' => 'Pfeil nach rechts Lg',
        'sicon-check-circle-lg' => 'Kontrollkreis Lg',
        'sicon-text-formatting' => 'Textformatierung',
        'sicon-check-circle' => 'Kontrollkreis',
        'sicon-upload-lg' => 'Upload Lg',
        'sicon-flag-lg' => 'Markierung Lg',
        'sicon-studio-lg' => 'Studio Lg',
        'sicon-contact-lg' => 'Kontakt Lg',
        'sicon-edit-lg' => 'Bearbeiten Lg',
        'sicon-arrow-left' => 'Pfeil nach links',
        'sicon-reply-all' => 'Allen antworten',
        'sicon-message-lg' => 'Nachricht Lg',
        'sicon-info-lg' => 'Info Lg',
        'sicon-error-lg' => 'Fehler Lg',
        'sicon-check-circle-line-lg' => 'Kontrollkreis-Linie Lg',
        'sicon-warning-line-lg' => 'Warnlinie Lg',
        'sicon-arrow-up' => 'Pfeil nach oben',
        'sicon-arrow-right' => 'Pfeil nach rechts',
        'sicon-nodes' => 'Knoten',
        'sicon-hide' => 'Ausblenden',
        'sicon-help' => 'Hilfe',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'Nachricht',
        'sicon-sugar-predict-lg' => 'Sugar Vorhersage Lg',
        'sicon-sugar-predict' => 'Sugar Vorhersage',
        'sicon-opportunity-lg' => 'Verkaufschance Lg',
        'sicon-lead-lg' => 'Interessent Lg',
        'sicon-account-lg' => 'Konto Lg',
        'sicon-user-sm' => 'Benutzer Sm',
        'sicon-quote-lg' => 'Angebot Lg',
        'sicon-equal' => 'Gleich',
        'sicon-slicers-xl' => 'Datenschnitte Xl',
        'sicon-escalation-lg' => 'Eskalation Lg',
        'sicon-add-circle-lg' => 'Kreis hinzufügen Lg',
        'sicon-add-line-lg' => 'Linie hinzufügen Lg',
        'sicon-add-target-lg' => 'Ziel hinzufügen Lg',
        'sicon-help-circle-lg' => 'Hilfskreis Lg',
        'sicon-divide-line-lg' => 'Linie teilen Lg',
        'sicon-string' => 'Zeichenkette',
        'sicon-filter' => 'Filter',
        'sicon-number' => 'Nummer',
        'sicon-format-lg' => 'Format Lg',
        'sicon-insights-lg' => 'Einblicke Lg',
        'sicon-invalid-circle-lg' => 'Ungültiger Kreis Lg',
        'sicon-layout-xl' => 'Layout Xl',
        'sicon-layout-lg' => 'Layout Lg',
        'sicon-multiply-line-lg' => 'Linie multiplizieren Lg',
        'sicon-redo-lg' => 'Wiederherstellen Lg',
        'sicon-refresh-lg' => 'Aktualisieren Lg',
        'sicon-undo-lg' => 'Rückgängig Lg',
        'sicon-activity-feed-xl' => 'Aktivitäts-Feed Xl',
        'sicon-chevron-left-xl' => 'Chevron Links Xl',
        'sicon-close-xl' => 'Schließen Xl',
        'sicon-kebab-lg' => 'Kebab Lg',
        'sicon-insights-xl' => 'Einblicke Xl',
        'sicon-hide-lg' => 'Ausblenden Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => 'Kommentar Xl',
        'sicon-share-lg' => 'Teilen Lg',
        'sicon-trash' => 'Papierkorb',
        'sicon-launch-lg' => 'Starten Lg',
        'sicon-thumbs-up-lg' => 'Daumen hoch Lg',
        'sicon-thumbs-down-lg' => 'Daumen runter Lg',
        'sicon-warning-lg' => 'Warnung Lg',
        'sicon-wizard-circle-xl' => 'Assistentenkreis Xl',
        'sicon-bell-cross-lg' => 'Glockenkreuz Lg',
        'sicon-bell-lg' => 'Glocke Lg',
        'sicon-daily-lg' => 'Täglich Lg',
        'sicon-cloud-download-lg' => 'Cloud-Download Lg',
        'sicon-unlock' => 'Freigeben',
        'sicon-news-lg' => 'News Lg',
        'sicon-weekly-lg' => 'Wöchentlich Lg',
        'sicon-knowledgebase-xl' => 'Wissensdatenbank Xl',
        'sicon-remove' => 'Entfernen',
        'sicon-chevron-down' => 'Chevron nach unten',
        'sicon-slicers-lg' => 'Datenschnitte Lg',
        'sicon-save-lg' => 'Speichern Lg',
        'sicon-info-circle-lg' => 'Infokreis Lg',
        'sicon-chevron-right' => 'Chevron nach rechts',
        'sicon-warning-circle-lg' => 'Warnkreis Lg',
        'sicon-right-paren-line-lg' => 'Rechte übergeordnete Linie Lg',
        'sicon-comment-lg' => 'Kommentar Lg',
        'sicon-target-lg' => 'Ziel Lg',
        'sicon-subtract-line-lg' => 'Subtrahiere Linie Lg',
        'sicon-settings-lg' => 'Einstellungen Lg',
        'sicon-left-paren-line-lg' => 'Linke übergeordnete Linie Lg',
        'sicon-preview-lg' => 'Vorschau Lg',
        'sicon-thumbs-down-line-lg' => 'Daumen runter Linie lg',
        'sicon-thumbs-up-line-lg' => 'Daumen hoch Linie lg',
        'sicon-send-lg' => 'Senden Lg',
        'sicon-contact-xl' => 'Kontakt Xl',
        'sicon-wizard-circle-line-xl' => 'Assistentenkreis-Linie Xl',
        'sicon-trash-lg' => 'Müll Lg',
        'sicon-pin-lg' => 'Markierung Lg',
        'sicon-clock-lg' => 'Uhr Lg',
        'sicon-comment-line-xl' => 'Kommentarzeile Xl',
        'sicon-dropdown-editor' => 'Dropdown-Editor',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'Fehler',
        'sicon-catalog' => 'Katalog',
        'sicon-cloud' => 'Cloud',
        'sicon-config-api' => 'Konfigurations-API',
        'sicon-config-nav' => 'Konfigurations-Navigation',
        'sicon-connectors' => 'Konnektoren',
        'sicon-contracts' => 'Verträge',
        'sicon-currencies' => 'Währungen',
        'sicon-diagnostics' => 'Diagnose',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'E-Mail-Kampagne',
        'sicon-email-inbound' => 'Eingehende E-Mail',
        'sicon-email-queue' => 'E-Mail-Warteschlange',
        'sicon-forecasts' => 'Prognosen',
        'sicon-display-modules' => 'Anzeigemodule',
        'sicon-email-contacts' => 'E-Mail-Kontakte',
        'sicon-import' => 'Import',
        'sicon-log-viewer' => 'Protokoll-Viewer',
        'sicon-lab' => 'Labor',
        'sicon-map-pin' => 'Karten-Markierung',
        'sicon-manufacturers' => 'Hersteller',
        'sicon-update' => 'Aktualisieren',
        'sicon-content-security' => 'Sicherheit von Inhalten',
        'sicon-module-builder' => 'Modul-Ersteller',
        'sicon-languages' => 'Sprachen',
        'sicon-module-loader' => 'Modullader',
        'sicon-oauth-key' => 'Oauth-Schlüssel',
        'sicon-password-mgmt' => 'Passwort-Verwaltung',
        'sicon-opportunities' => 'Verkaufschancen',
        'sicon-upgrade' => 'Upgrade',
        'sicon-portal' => 'Portal',
        'sicon-product-types' => 'Produktarten',
        'sicon-quotes' => 'Angebote',
        'sicon-relate-fields' => 'Felder verknüpfen',
        'sicon-repair' => 'Reparieren',
        'sicon-role-mgmt' => 'Rollenmanagement',
        'sicon-scheduler' => 'Zeitplaner',
        'sicon-shippers' => 'Absender',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'Web-Logik',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'Steuersätze',
        'sicon-team-mgmt' => 'Teammanagement',
        'sicon-team-perm' => 'Team Perm',
        'sicon-tracker' => 'Tracker',
        'sicon-workflow' => 'Workflow',
        'sicon-mask' => 'Maske',
        'sicon-mask-disabled' => 'Maske deaktiviert',
        'sicon-email-archive' => 'E-Mail-Archiv',
        'sicon-mobile' => 'Mobiltelefon',
        'sicon-archive' => 'Archiv',
        'sicon-automate-scroll' => 'Vertikale Bildlaufansicht',
        'sicon-automate-stacked' => 'Horizontale Bildlaufansicht',
        'sicon-pdf-manager' => 'PDF-Manager',
        'sicon-my-sites' => 'Meine Seiten',
        'sicon-cloud-insights' => 'Cloud Insights',
        'sicon-sugar-logo-24' => 'Sugar-Logo 24',
        'sicon-sugar-logo-16' => 'Sugar-Logo 16',
        'sicon-task-lg' => 'Aufgabe Lg',
        'sicon-web-lg' => 'Web Lg',
        'sicon-events-lg' => 'Events Lg',
        'sicon-sugar-logo-12' => 'Sugar-Logo 12',
        'sicon-tag' => 'Tag',
        'sicon-tag-lg' => 'Tag Lg',
        'sicon-bell-lg-line' => 'Glocke Lg Linie',
        'sicon-matrix-xxl' => 'Matrix Xxl',
        'sicon-advanced-filter' => 'Erweiterter Filter',
        'sicon-rows-and-columns-xxl' => 'Zeilen und Spalten Xxl',
        'sicon-summation-details-xxl' => 'Summierungsdetails Xxl',
        'sicon-summation-xxl' => 'Summierung Xxl',
        'sicon-lock-lg' => 'Sperre Lg',
        'sicon-csv-file-xxl' => 'Csv-Datei Xxl',
        'sicon-logo-linkedin' => 'Logo Linkedin',
        'sicon-briefcase' => 'Aktentasche',
        'sicon-car-front' => 'Fahrzeugfront',
        'sicon-airplane' => 'Flugzeug',
        'sicon-laptop' => 'Laptop',
        'sicon-logo-instagram' => 'Logo Instagram',
        'sicon-single-bed' => 'Einzelbett',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'Logo Snapchat',
        'sicon-video-lg' => 'Video Lg',
        'sicon-reply' => 'Antworten',
        'sicon-subtract' => 'Subtrahieren',
        'sicon-arrow-up-circle-line' => 'Kreislinie mit Pfeil nach oben',
        'sicon-asterisk' => 'Sternchen',
        'sicon-dot-circle-o-lg' => 'Punktkreis O Lg',
        'sicon-forward' => 'Weiterleiten',
        'sicon-video' => 'Video',
        'sicon-gavel' => 'Hammer',
        'sicon-login' => 'Anmelden',
        'sicon-pdf-file-xxl' => 'PDF-Datei Xxl',
        'sicon-login-lg' => 'Anmelden Lg',
        'sicon-cloud-download-xl' => 'Cloud-Download Xl',
        'sicon-campaigns-lg' => 'Kampagnen Lg',
        'sicon-customer-journey-stages-lg' => 'Kundenreisestufen Lg',
        'sicon-role-mgmt-lg' => 'Rollenmanagement Lg',
        'sicon-default-module-lg' => 'Standardmodul Lg',
        'sicon-quoted-line-items-lg' => 'Angebotene Einzelposten Lg',
        'sicon-projects-lg' => 'Projekte Lg',
        'sicon-process-business-rules-lg' => 'Prozess-Geschäftsregeln Lg',
        'sicon-process-email-templates-lg' => 'Prozess-E-Mail-Vorlagen Lg',
        'sicon-processes-lg' => 'Prozesse Lg',
        'sicon-process-definitions-lg' => 'Prozessdefinitionen Lg',
        'sicon-target-lists-lg' => 'Zielkontaktlisten Lg',
        'sicon-purchased-line-items-lg' => 'Gekaufte Produkte Lg',
        'sicon-user-group-lg' => 'Benutzergruppe Lg',
        'sicon-revenue-line-items-lg' => 'Umsatzposten Lg',
        'sicon-business-centers-lg' => 'Geschäftszentren Lg',
        'sicon-logo-fb-simple' => 'Logo Fb Einfach',
        'sicon-forecasts-lg' => 'Prognosen Lg',
        'sicon-contracts-lg' => 'Verträge Lg',
        'sicon-purchase-lg' => 'Kaufen Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'Kundenreise Lg',
        'sicon-data-privacy-lg' => 'Datenschutz Lg',
        'sicon-home-lg' => 'Startseite Lg',
        'sicon-data-table' => 'Datentabelle',
        'sicon-medical-clipboard-lg' => 'Medizinische Zwischenablage Lg',
        'sicon-privacy-lg' => 'Privatsphäre Lg',
        'sicon-marketplace' => 'Marktplatz',
        'sicon-marketplace-lg' => 'Marktplatz Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => 'Casino Lg',
        'sicon-jacuzzi-lg' => 'Whirlpool Lg',
        'sicon-scissors-lg' => 'Schere Lg',
        'sicon-storage-lg' => 'Lagerung Lg',
        'sicon-fan-lg' => 'Ventilator Lg',
        'sicon-medicine-lg' => 'Medizin Lg',
        'sicon-plant-lg' => 'Pflanze Lg',
        'sicon-telescope-lg' => 'Teleskop Lg',
        'sicon-smart-phone-lg' => 'Smartphone Lg',
        'sicon-coffee-lg' => 'Kaffee Lg',
        'sicon-martini-lg' => 'Martini Lg',
        'sicon-cocktail-lg' => 'Cocktail Lg',
        'sicon-stadium-lg' => 'Stadion Lg',
        'sicon-fire-lg' => 'Feuer Lg',
        'sicon-window-lg' => 'Fenster Lg',
        'sicon-lotus-lg' => 'Lotus Lg',
        'sicon-windmill-lg' => 'Windmühle Lg',
        'sicon-spades-lg' => 'Pik Lg',
        'sicon-hearts-lg' => 'Herz Lg',
        'sicon-diamonds-lg' => 'Karo Lg',
        'sicon-clubs-lg' => 'Kreuz Lg',
        'sicon-skull-lg' => 'Schädel Lg',
        'sicon-send' => 'Senden',
        'sicon-world-lg' => 'Welt Lg',
        'sicon-airplane-lg' => 'Flugzeug Lg',
        'sicon-planet-lg' => 'Planet Lg',
        'sicon-trainer-lg' => 'Trainer Lg',
        'sicon-calculator-lg' => 'Rechner Lg',
        'sicon-tv-lg' => 'TV Lg',
        'sicon-video-player-lg' => 'Video-Player Lg',
        'sicon-media-player-lg' => 'Media Player Lg',
        'sicon-decentralize-lg' => 'Dezentralisieren Lg',
        'sicon-statistics-lg' => 'Statistik Lg',
        'sicon-virus-lg' => 'Virus Lg',
        'sicon-shield-lg' => 'Schild Lg',
        'sicon-plug-lg' => 'Stecker Lg',
        'sicon-shuttle-lg' => 'Shuttle Lg',
        'sicon-soundwave-lg' => 'Schallwelle Lg',
        'sicon-graph-lg' => 'Grafik Lg',
        'sicon-playlist-lg' => 'Wiedergabeliste Lg',
        'sicon-voice-recognition-lg' => 'Spracherkennung Lg',
        'sicon-machine-learning-lg' => 'Maschinelles Lernen Lg',
        'sicon-bed-lg' => 'Bett Lg',
        'sicon-blueprint-lg' => 'Blaupause Lg',
        'sicon-content-delivery-lg' => 'Inhaltsbereitstellung Lg',
        'sicon-questionnaire-lg' => 'Fragebogen Lg',
        'sicon-presentation-lg' => 'Präsentation Lg',
        'sicon-organic-lg' => 'Bio Lg',
        'sicon-transactions-lg' => 'Transaktionen Lg',
        'sicon-wand-lg' => 'Stab Lg',
        'sicon-bin-lg' => 'Mülleimer Lg',
        'sicon-sync-lg' => 'Synchronisieren Lg',
        'sicon-external-authentication-lg' => 'Externe Authentifizierung Lg',
        'sicon-tracking-activity-lg' => 'Aktivität tracken Lg',
        'sicon-account' => 'Konto',
        'sicon-meetings-lg' => 'Meetings Lg',
        'sicon-stacked' => 'Horizontal geteilte Ansicht',
        'sicon-sidebyside' => 'Vertikal geteilte Ansicht',
        ],

        'module_colors_dom' => [
        'army' => 'Armee',
        'coral' => 'Koralle',
        'green' => 'Grün',
        'orange' => 'Orange',
        'ocean' => 'Ozean',
        'pacific' => 'Pazifik',
        'pink' => 'Pink',
        'purple' => 'Violett',
        'red' => 'Rot',
        'teal' => 'Türkis',
        'yellow' => 'Gelb',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'Neu',
        'In Progress' => 'In Bearbeitung',
        'Closed' => 'Geschlossen',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'Inaktivität',
        'Lack of Progress' => 'Fehlender Fortschritt',
        'Customer-Imposed Deadline' => 'Vom Kunden auferlegte Frist',
        'Account at Risk' => 'Konto unsicher',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'Vom Kunden angefordert',
        'Internally Requested' => 'Intern angefordert',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'Fall',
        'Bugs' => 'Fehler',
        'Accounts' => 'Konto',
        'Opportunities' => 'Verkaufschance',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'Positiv',
        'Negative' => 'Negativ',
        'Neutral' => 'Neutral',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'Unwahrscheinlich',
        '02_less_likely' => 'Weniger wahrscheinlich',
        '03_neutral' => 'Neutral',
        '04_more_likely' => 'Eher wahrscheinlich',
        '05_very_likely' => 'Sehr wahrscheinlich',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'Entspricht nicht den Kunden',
        '02_no_match' => '',
        '01_matches_customers' => 'Entspricht den Kunden',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'Interessent',
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Cases' => 'Fall',
        'Opportunities' => 'Verkaufschance',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'Noch nicht gestartet',
        'in_progress' => 'In Bearbeitung',
        'completed' => 'Abgeschlossen',
        'cancelled' => 'Storniert',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'Kein(e)',
        'create' => 'Beim Erstellen',
        'stage_start' => 'Bei Stufenstart',
        'previous_activity_completed' => 'Vorherige Aktivität abgeschlossen',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'Aktueller Benutzer',
        'parent_assignee' => 'Übergeordneter Zugewiesener',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'Tage ab Erstellung',
        'days_from_stage_started' => 'Tage ab Stufenstart',
        'days_from_previous_activity_completed' => 'Tage ab vorheriger Aktivität abgeschlossen',
        'days_from_parent_date_field' => 'Tage ab Feld "übergeordnetes Datum"',
        'days_from_specific_activity_completed' => 'Tage ab spezifischer Aktivität abgeschlossen',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'Bei der Erstellung',
        'stage_started' => 'Bei Stufenstart',
        'previous_activity_completed' => 'Wenn vorherige Aktivität abgeschlossen',
        'parent_date_field' => 'Am Feld "übergeordnetes Datum"',
        'specific_activity_completed' => 'Spezifische Aktivität abgeschlossen',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'Absolut',
        'Percentage' => 'Prozentsatz',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'Kundenaufgabe',
        'milestone' => 'Meilenstein',
        'internal_task' => 'Interne Aufgabe',
        'agency_task' => 'Agenturaufgabe',
        'automatic_task' => 'Automatische Aufgabe',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'Aufgabe',
        'Calls' => 'Anruf',
        'Meetings' => 'Meeting',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'Kein(e)',
        'create' => 'Beim Erstellen',
        'stage_start' => 'Bei Stufenstart',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'Übernehmen',
        'current_user' => 'Aktueller Benutzer',
        'parent_assignee' => 'Übergeordneter Zugewiesener',
        'user' => 'Benutzer',
        'team' => 'Team',
        'user_team' => 'Benutzer & Team',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'Übernehmen',
        'none' => 'Kein(e)',
        'create' => 'Beim Erstellen',
        'stage_start' => 'Bei Stufenstart',
        'previous_activity_completed' => 'Vorherige Aktivität abgeschlossen',
        'specific_activity_completed' => 'Spezifische Aktivität abgeschlossen',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'Noch nicht gestartet',
        'in_progress' => 'In Bearbeitung',
        'not_completed' => 'Nicht abgeschlossen',
        'completed' => 'Abgeschlossen',
        'cancelled' => 'Storniert',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'Stufe bearbeiten',
        'stage_add_task_button' => 'Aufgabe erstellen',
        'stage_add_meeting_button' => 'Meeting planen',
        'stage_add_call_button' => 'Anruf planen',
        'stage_delete_button' => 'Stufe löschen',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'Aufgabe hinzufügen',
        'activity_add_sub_meeting_button' => 'Meeting planen',
        'activity_add_sub_call_button' => 'Anruf planen',
        'activity_not_applicable_button' => 'Nicht zutreffend',
        'activity_delete_button' => 'Löschen',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'Set nicht zutreffend',
        'remove_open_activities' => 'Offene Aktivitäten entfernen',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'Standard',
        'custom' => 'Benutzerdefiniert',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'ERHALTEN',
        'POST' => 'POST',
        'PUT' => 'STELLEN',
        'PATCH' => 'FLICKEN',
        'DELETE' => 'LÖSCHEN',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'Anfrage überspringen',
        'json' => 'JSON',
        'http_query' => 'HTTP-Abfrage',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'Keine Antwort',
        'json' => 'JSON',
        'http_query' => 'HTTP-Abfrage',
        'text' => 'Nur-Text',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'Vor dem Erstellen',
        'after_create' => 'Nach dem Erstellen',
        'before_in_progress' => 'Vor Bearbeitung',
        'after_in_progress' => 'Nach Bearbeitung',
        'before_completed' => 'Vor Fertigstellung',
        'after_completed' => 'Nach Abschluss',
        'before_not_applicable' => 'Vor nicht zutreffend',
        'after_not_applicable' => 'Nach nicht zutreffend',
        'before_delete' => 'Vor dem Löschen',
        'after_delete' => 'Nach Löschen',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Smart Guide Informationen senden',
        'custom_body' => 'Benutzerdefinierten Beitragstext senden',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'In Bearbeitung',
        'completed' => 'Abgeschlossen',
        'not_applicable' => 'Nicht zutreffend',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'Datensatz anzeigen',
        'create_record' => 'Datensatz erstellen',
        'update_record' => 'Datensatz aktualisieren',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'Datensatz automatisch erstellen',
        'manual_create' => 'Datensatz manuell erstellen',
        'automatic_update' => 'Datensatz automatisch aktualisieren',
        'manual_update' => 'Datensatz manuell aktualisieren',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Smart Guide Vorlage',
        'DRI_SubWorkflow_Templates' => 'Stufenvorlage',
        'DRI_Workflow_Task_Templates' => 'Aktivitätsvorlage',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'Ja',
        'no' => 'Nein',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'Durchgeführt',
        'Not Held' => 'Nicht abgehalten',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'Durchgeführt',
        'Not Held' => 'Nicht abgehalten',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'Abgeschlossen',
        'Not Applicable' => 'Nicht zutreffend',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Smart Guide Vorlage',
        'DRI_SubWorkflow_Templates' => 'Stufenvorlage',
        'DRI_Workflow_Task_Templates' => 'Aktivitätsvorlage',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'Aufgabe',
        'Meetings' => 'Meeting',
        'Calls' => 'Anruf',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'Aktuelle Aufgabe',
        'Calls' => 'Aktueller Anruf',
        'Meetings' => 'Aktuelles Meeting',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'Bestimmte Benutzer',
        'specific_contacts' => 'Bestimmte Kontakte',
        'related_parent_users' => 'Verwandte übergeordnete Benutzer',
        'related_parent_contacts' => 'Verwandte übergeordnete Kontakte',
        'add_all_contacts_from_parent' => 'Alle Kontakte aus dem übergeordneten Element hinzufügen',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'Benutzer',
        'specific_contacts' => 'Kontakte',
        'related_parent_users' => 'Benutzer',
        'related_parent_contacts' => 'Kontakte',
        'add_all_contacts_from_parent' => 'Kontakte',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'Minute(n)',
        'hours' => 'Stunde(n)',
        'days' => 'Tag(e)',
        'months' => 'Monat(e)',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'Tag(e)',
        'months' => 'Monat(e)',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'Festes Datum',
        'relative' => 'Relatives Datum',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'Benutzer',
        'teams' => 'Teams',
        'roles' => 'Rollen',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Von Smart Guide zu Sugar-Aktion',
        'sugar_action_to_smart_guide' => 'Von Sugar-Aktion zu Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide Stufe',
        'Smart Guide Activities' => 'Smart Guide Aktivitäten',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'Abgeschlossen',
        'cancelled' => 'Abgebrochen',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'In Bearbeitung',
        'completed' => 'Abgeschlossen',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'In Bearbeitung',
        'completed' => 'Abgeschlossen',
        'not_applicable' => 'Nicht zutreffend',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'Alle Aktivitäten als erledigt markieren',
        'mark_all_not_applicable' => 'Alle unvollständigen Aktivitäten als nicht zutreffend markieren',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'Vereinigte Staaten (Oregon) [us-west-2]',
        'ca-central-1' => 'Kanada (Zentral) [ca-central-1]',
        'ap-southeast-1' => 'Asien-Pazifik (Singapur) [ap-southeast-1]',
        'ap-southeast-2' => 'Asien-Pazifik (Sydney) [ap-southeast-2]',
        'eu-central-1' => 'Europa (Frankfurt) [eu-central-1]',
        'eu-west-2' => 'Europa (London) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'Datensatz-Header', // Studio editing of record views
    'LBL_RECORD_BODY' => 'Visitenkarte', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'Mehr anzeigen', // Studio editing of record views
    'LBL_FAVORITE' => 'Favoriten', // Record view header panel element
    'LBL_FOLLOW' => 'Folgen', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'Dem Link folgen',
    'LBL_TOGGLE_VISIBILITY' => 'Sichtbarkeit aktivieren', // Record view header panel element
    'LBL_ACTIVITIES' => 'Aktivitäten-Stream',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar und der 3-D-Würfel sind eingetragene Warenzeichen von SugarCRM Inc. ' .
        'Alle anderen in diesem Produkt verwendeten oder angegebenen Firmen- und Produktnamen sind möglicherweise Markenzeichen von ' .
        'SugarCRM®, Sugar Enterprise™ und Sugar™ sind eingetragene Warenzeichen von SugarCRM Inc.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ und Sugar™ sind Marken von SugarCRM Inc.',
    'LBL_SEND_INVITE' => 'Einladung senden',
    'LBL_INVITEES' => 'Teilnehmer',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'Gast wird Ihre Einladung nicht erhalten',
    'LBL_SELECT_ACTION_LABEL' => 'Aktion wählen',
    'LBL_TOGGLE_DRAWER' => 'Schublade anzeigen',
    'LBL_TOUR_NEXT' => 'Weiter',
    'LBL_TOUR_SKIP' => 'überspringen',
    'LBL_TOUR_BACK' => 'Zurück',
    'LBL_TOUR_CLOSE' => 'Schließen',
    'LBL_TOUR_BTN_DONE' => 'Fertig',
    'LBL_TOUR_TAKE_TOUR' => 'Machen Sie die Tour',
    'LBL_TOUR_FULL_TOUR' => 'Ganze Tour',
    'LBL_TOUR_MODULE' => 'Tour nur über diese Seite',
    'LBL_TOUR_END_TOUR' => 'Tour beenden',
    'LBL_TOUR_OVERVIEW' => 'Seiten-Übersicht',
    'LBL_TOUR_REVISIT' => 'Klicken Sie hier, um die Tour zu starten.',
    'LBL_MY_AREA_LINKS' => 'Links für meinen Bereich: ' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Luft holen' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'Willkommen' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'Erweitert' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'Mehr Details' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'Inline bearbeiten' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'Ansicht:' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Einfache Suche' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'Suche...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'Entfernen' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'Hinzufügen' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'Spalte' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 Spalten' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 Spalten' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Erweiterte Suche' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'Hinzufügen' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'Ausblenden/Anzeigen' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'Löschen' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'Hinzufügen' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'Leeren' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'Entfernen' /*for 508 compliance fix*/,
    'LBL_ADD' => 'Hinzufügen' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'Firmenlogo' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'Kalender' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'Ein von Ihnen ausgewählter Dropdown-Wert hat das Layout Ihrer Datensatzansicht verändert.' .
        'Die Werte der in diesem Layout ausgeblendeten Felder wurden gelöscht. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'Öffnen',
    'LBL_SIDEBAR_NAV_CLOSE' => 'Beenden',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}}-Menü',
    'LBL_GOTO_SUGARCRM_COM' => 'Gehe zu SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'Hauptmenü-Navigation',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'Toggle-Subpanel',

    'LBL_ADVANCED' => 'Erweitert',
    'LBL_BASIC' => 'Einfach',
    'LBL_MODULE_FILTER' => 'Gefiltert nach',
    'LBL_CONNECTORS_POPUPS' => 'Konnektor-Popups',
    'LBL_CLOSEINLINE' => 'Beenden',
    'LBL_EDITINLINE' => 'Bearbeiten',
    'LBL_VIEWINLINE' => 'Ansicht:',
    'LBL_INFOINLINE' => 'Info',
    'LBL_POWERED_BY_SUGARCRM' => 'Powered by SugarCRM',
    'LBL_PRINT' => 'Drucken',
    'LBL_HELP' => 'Hilfe',
    'LBL_TOUR' => 'Activity View Tour',
    'LBL_TOUR_LINK' => 'Diese Seite anschauen',
    'LBL_MOBILE' => 'Mobiltelefon',
    'LBL_ID_FF_SELECT' => 'Auswählen',
    'DEFAULT' => 'Einfach',
    'LBL_SORT' => 'Sortieren',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Server hinzufügen...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'SMTP via SSL oder TLS aktivieren?',
    'LBL_NO_ACTION' => 'Für diesen Namen gibt es keine Aktionen.',
    'LBL_NO_DATA' => 'Keine Daten',
    'LBL_NOT_APPLICABLE' => 'Nicht zutreffend',
    'LBL_ROUTING_ADD_RULE' => 'Regel hinzufügen',
    'LBL_ROUTING_ALL' => 'Alle',
    'LBL_ROUTING_ANY' => 'Irgendeine',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'Abbrechen',
    'LBL_ROUTING_BUTTON_SAVE' => 'Regel speichern',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'E-Mail kopieren',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Sugar-Objekt löschen',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Datei löschen',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'E-Mail löschen',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'E-Mail weiterleiten',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'E-Mail markieren',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'Als gelesen markieren',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Als ungelesen markieren',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'E-Mail verschieben',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'Die folgende Aktion durchführen',
    'LBL_ROUTING_ACTIONS_REPLY' => 'Auf E-Mail antworten',

    'LBL_ROUTING_CHECK_RULE' => "Ein Fehler wurde gefunden:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'Bitte überprüfen Sie alle markierten Felder.',
    'LBL_ROUTING_CONFIRM_DELETE' => "Sind Sie sicher, dass Sie diese Regel löschen möchten?\nDieser Vorgang kann nicht rückgängig gemacht werden.",

    'LBL_ROUTING_FLAGGED' => 'Markierung gesetzt',
    'LBL_ROUTING_FORM_DESC' => 'Gespeicherte Regeln sind sofort aktiv.',
    'LBL_ROUTING_FW' => 'WG:',
    'LBL_ROUTING_LIST_TITLE' => 'Regeln',
    'LBL_ROUTING_MATCH' => 'Wenn',
    'LBL_ROUTING_MATCH_2' => 'eine der folgende Bedingungen zutrifft:',
    'LBL_NOTIFICATIONS' => 'Benachrichtigungen',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'CC',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'Mailinhalt',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'Von',
    'LBL_ROUTING_MATCH_NAME' => 'Betreff',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'Hohe Priorität',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Normale Priorität',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Niedrige Priorität',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'An',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'Enthält',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'Enthält nicht',

    'LBL_ROUTING_NAME' => 'Regelname',
    'LBL_ROUTING_NEW_NAME' => 'Neue Regel',
    'LBL_ROUTING_ONE_MOMENT' => 'Einen Moment bitte...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Originalnachricht folgt.',
    'LBL_ROUTING_RE' => 'AW:',
    'LBL_ROUTING_SAVING_RULE' => 'Regel speichern',
    'LBL_ROUTING_SUB_DESC' => 'Ausgewähle Regeln sind aktiv. Wählen Sie einen Namen, um diesen zu bearbeiten.',
    'LBL_ROUTING_TO' => 'an',
    'LBL_ROUTING_TO_ADDRESS' => 'an Adresse',
    'LBL_ROUTING_WITH_TEMPLATE' => 'mit Vorlage',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'Sie haben Einträge für Telefon und Adresse in Ihrem Formular. Um die Einträge mit jenen der Firma, die Sie ausgewählt haben, zu überschreiben, klicken Sie auf "OK". Um die aktuellen Werte beizubehalten, klicken Sie auf "Abbrechen".',
    'LBL_DROP_HERE' => '[Hier Ablegen]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'Bearbeiten',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Gmail-Standardwerte füllen',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'Name',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Ausgehender Mailserver',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'Mail Transfer Agent',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'SMTP-Authentfiizierung verwenden?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP-Passwort',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP-Port',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP-Server',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'SSL bei der Verbindung verwenden',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP-Benutzername',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Standard',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Warnung: Benutzername und Password für ausgehenden Mailserver nicht angegeben.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP-Benutzername erforderlich',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP-Passwort erforderlich',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'E-Mail-Kontoverwaltung',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'Das Mailserver-Protokolö POP3 wird im nächsten Release nicht mehr unterstützt. Es wird nur noch IMAP unterstützt.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'E-Mail-Konten einrichten, um eingehende Nachrichten zu lesen.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'SMTP-Mailserver-Einstellungen für ausgehende Nachrichten konfigurieren.',
    'LBL_EMAIL_ADD' => 'E-Mail hinzufügen',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Hinzufügen',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Löschen',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'An:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Cc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Bcc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'An/Cc/Bcc',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'Liste hinzufügen',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'E-Mail-Adresse',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Momentan können nur Kontakte bearbeitet werden.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filter',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'Vorname',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Nachname',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'Meine Kontakte',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'Meine Verteilerliste',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'Name',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'Keine Adressen gefunden',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Speichern & zum Adressbuch hinzufügen',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Suchen',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Adressbuch-Einträge auswählen',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Adressbuch',
    'LBL_EMAIL_REPORTS_TITLE' => 'Berichte',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'Warnung! Das ausgehende Konto, das Sie zu löschen versuchen, ist mit einem bestehenden eingehenden Konto verknüpft. Möchten Sie wirklich fortfahren?',
    'LBL_EMAIL_ADDRESSES' => 'E-Mail',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'E-Mail-Adresse',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'E-Mail-Adressen',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'In Sugar importieren',
    'LBL_EMAIL_ASSIGNMENT' => 'Aufgabe',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Anhängen',
    'LBL_EMAIL_ATTACHMENT' => 'Anhängen',
    'LBL_EMAIL_ATTACHMENTS' => 'Vom lokalen System',
    'LBL_EMAIL_ATTACHMENTS2' => 'Von Sugar-Dokumenten',
    'LBL_EMAIL_ATTACHMENTS3' => 'Vorlage-Anhänge',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'Datei',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Dokument',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Eingebettet',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'Anhang-Upload fehlgeschlagen',
    'LBL_REMOVING_ATTACHMENT' => 'Anhang wird entfernt...',
    'LBL_EMAIL_BCC' => 'BCC',
    'LBL_EMAIL_CANCEL' => 'Abbrechen',
    'LBL_EMAIL_CC' => 'CC',
    'LBL_EMAIL_CHARSET' => 'Zeichensatz',
    'LBL_EMAIL_CHECK' => 'E-Mails abrufen',
    'LBL_EMAIL_CHECKING_NEW' => 'Nach neuen E-Mails überprüfen',
    'LBL_EMAIL_CHECKING_DESC' => 'Einen Moment bitte... <br><br>Wenn das die erste Überprüfung ist, so kann der Vorgang einige Zeit dauern.',
    'LBL_EMAIL_CLOSE' => 'Schließen',
    'LBL_EMAIL_COFFEE_BREAK' => 'Überprüfe nach neuen E-Mails.<br><br>Bei großen E-Mail-Konten kann der Vorgang ggf. sehr lange dauern.',
    'LBL_EMAIL_COMMON' => 'Allgemein',

    'LBL_EMAIL_COMPOSE' => 'E-Mail',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Bitte Empfänger angeben',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'Bezieht sich auf',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'Diese E-Mail hat keinen Inhalt. Trotzdem senden?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'Diese E-Mail hat kein Betreff. Trotzdem senden?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(kein Betreff)',
    'LBL_EMAIL_COMPOSE_READ' => 'Lesen & Neue E-Mail',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Von E-Mail-Konto senden',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'Optionen',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Bitte eine gültige E-Mail-Adresse in An, CC und BCC verwenden',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'E-Mail verwerfen?',
    'LBL_EMAIL_CONFIRM_DELETE' => 'Diese Einträge aus dem Adressbuch entfernen?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'Sind Sie sicher, dass Sie diese Signatur löschen möchten?',

    'LBL_EMAIL_CREATE_NEW' => '--Erstellen beim Speichern--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Mehrere',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Leer',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Sendedatum des Absenders',
    'LBL_EMAIL_DATE_RECEIVED' => 'Empfangsdatum',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'Bearbeiter',
    'LBL_EMAIL_DATE_TODAY' => 'Heute',
    'LBL_EMAIL_DATE_YESTERDAY' => 'Gestern',
    'LBL_EMAIL_DD_TEXT' => 'E-Mail(s) ausgewählt.',
    'LBL_EMAIL_DEFAULTS' => 'Standardwerte',
    'LBL_EMAIL_DELETE' => 'Löschen',
    'LBL_EMAIL_DELETE_CONFIRM' => 'Ausgewählte Nachrichten löschen?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'E-Mail erfolgreich gelöscht.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'Nachricht wird gelöscht',
    'LBL_EMAIL_DETAILS' => 'Details',
    'LBL_EMAIL_DISPLAY_MSG' => 'E-Mail(s) anzeigen {0} - {1} von {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'E-Mail-Adresse(n) anzeigen {0} - {1} von {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'Kontakt bearbeiten',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Bei Kontakten wird nur die Hauptadresse verwendet',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'Verteilerliste anpassen',

    'LBL_EMAIL_EMPTYING_TRASH' => 'Papierkorb leeren',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'Ausgehenden Server löschen',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'Cache-Dateien löschen',
    'LBL_EMAIL_EMPTY_MSG' => 'Keine E-Mails vorhanden.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'Keine E-Mail-Adressen vorhanden.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'Die Ordnernamen müssen eindeutig und nicht leer sein. Bitte nochmals versuchen.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'Der Ordner kann nicht gelöscht werden. Dieser Ordner bzw. seine Unterordner haben eine Mailbox zugeordnet.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'Der Ordner kann vom Inhalt her nicht bestimmt werden. Bitte nochmals versuchen.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Bitte die Einstellungen überprüfen.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Bitte Nachnamen eintragen.',
    'LBL_EMAIL_ERROR_DESC' => 'Fehler gefunden:',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'Sie haben keine Zugriffsrechte für diesen Bereich. Bitte kontaktieren Sie den Administrator.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugar-Ordnernamen müssen eindeutig sein.',
    'LBL_EMAIL_ERROR_EMPTY' => 'Bitte Suchkriterien eingeben.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'Ein Fehler ist aufgetreten',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'Eine E-Mail-Liste mit diesem Namen existiert bereits',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Nachricht vom Server entfernt',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'Die E-Mail wurde entweder entfernt oder in einen anderen Ordner verschoben',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'Keine Verbindung mit dem Mailserver. Bitte kontaktieren Sie Ihren Administrator',
    'LBL_EMAIL_ERROR_MOVE' => 'E-Mails zwischen Servern und/oder Mailkonten zu verschieben, wird momentan nicht unterstüzt.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'Fehler beim Verschieben.',
    'LBL_EMAIL_ERROR_NAME' => 'Ein Name wird benötigt.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'Von-Adresse ist ein Pflichtfeld.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'Bitte eine Datei auswählen.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'IMAP-Ordner können derzeit nicht umbenannt werden.',
    'LBL_EMAIL_ERROR_SERVER' => 'Ein Mailserverkonto wird benötigt.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'Das E-Mail-Konto konnte eventuell nicht gespeichert werden.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'Kommunikationsfehler mit dem Mailserver',
    'LBL_EMAIL_ERROR_USER' => 'Ein Benutzername wird benötigt.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'Ein Passwort wird benötigt.',
    'LBL_EMAIL_ERROR_PORT' => 'Ein Mailserver-Port wird benötigt.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'Ein Mailserver-Protokoll wird benötigt.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'Überwachter Ordner wird benötigt.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'Papierkorb-Ordner wird benötigt.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'Diese Information ist nicht verfügbar',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'Kein ausgehender Mailserver angegeben.',
    'LBL_EMAIL_FOLDERS' => 'Ordner',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'Verschieben nach',
    'LBL_EMAIL_FOLDERS_ADD' => 'Hinzufügen',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Ordner hinzufügen',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Ordner umbenennen',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Speichern',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Dieser Ordner hinzufügen zu',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'Dieser Ordner kann nicht umbenannt werden',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'Möchten Sie diesen Ordner wirklich löschen?\nDieser Vorgang kann nicht rückgängig gemacht werden.\nAlle Unterordner werden auch gelöscht.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'Neuer Ordnername',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Bevor diese Aktion durchgeführt werden kann, bitte zuerst einen Ordner auswählen,',
    'LBL_EMAIL_FOLDERS_TITLE' => 'Ordnerverwaltung',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Gruppe verwenden',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'Team zuweisen',
    'LBL_EMAIL_FORWARD' => 'Weiterleiten',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => 'Heruntergeladen [[count]] von [[total]] E-Mails',
    'LBL_EMAIL_FOUND' => 'Gefunden',
    'LBL_EMAIL_FROM' => 'Von',
    'LBL_EMAIL_GROUP' => 'Gruppe',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'Gruppe',
    'LBL_EMAIL_HOME_FOLDER' => 'Startseite',
    'LBL_EMAIL_HTML_RTF' => 'In HTML senden',
    'LBL_EMAIL_IE_DELETE' => 'E-Mail-Konto löschen',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'Signatur wird gelöscht',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'Möchten Sie dieses E-Mail-Konto wirklich löschen?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Erfolgreich gelöscht.',
    'LBL_EMAIL_IE_SAVE' => 'E-Mail-Kontoinformationen speichern',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'E-Mail importieren',
    'LBL_EMAIL_IMPORT_EMAIL' => 'In Sugar importieren',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'Import-Einstellungen',
    'LBL_EMAIL_INVALID' => 'Ungültig',
    'LBL_EMAIL_LINK_RECORD' => 'Klicken Sie hier.',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'Verteilerliste umbenennen',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'Geben Sie einen neuen Namen für diese Verteilerliste ein',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'Sollen diese Einträge von Ihrer Verteilerliste entfernt werden?',
    'LBL_EMAIL_LOADING' => 'Laden...',
    'LBL_EMAIL_MARK' => 'Markieren',
    'LBL_EMAIL_MARK_FLAGGED' => 'Als markiert',
    'LBL_EMAIL_MARK_READ' => 'Als gelesen',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'Als nicht markiert',
    'LBL_EMAIL_MARK_UNREAD' => 'Als ungelesen',
    'LBL_EMAIL_ASSIGN_TO' => 'Zuweisen an',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'Ordner erstellen',
    'LBL_EMAIL_MENU_COMPOSE' => 'Neue E-Mail',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Ordner löschen',
    'LBL_EMAIL_MENU_EDIT' => 'Bearbeiten',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Papierkorb leeren',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Synchronisieren',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Cache-Dateien leeren',
    'LBL_EMAIL_MENU_REMOVE' => 'Entfernen',
    'LBL_EMAIL_MENU_RENAME' => 'Umbennenen',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Ordner umbennenen',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Ordner umbennenen',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Etwas auswählen, bevor dieser Vorgang durchgeführt werden kann.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Ordner erstellen (Remote oder in Sugar)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'E-Mail(s) nach SugarCRM archiveren',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'Verteilerliste für diese E-Mail',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'E-Mail an diesen Kontakt',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Kontakt entfernen',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'Diese E-Mail(s) löschen',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Ordner löschen (Remote oder in Sugar)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Kontakt bearbeiten',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Verteilerliste bearbeiten',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Alle Papierkörbe für Ihre E-Mail-Konten löschen',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'Diese E-Mail(s) markieren',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'Diese E-Mail(s) als gelesen markieren',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'Markierung dieser E-Mail(s) aufheben',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'Diese E-Mail(s) als ungelesen markieren',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Entfernt Verteilerlisten',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Ordner umbennenen (Remote oder in Sugar)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'Auf diese E-Mail(s) antworten',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'Allen Empfängern dieser E-Mail(s) antworten',

    'LBL_EMAIL_MESSAGES' => 'Nachrichten',

    'LBL_EMAIL_ML_NAME' => 'Name der Verteilerliste',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'Adressen für Verteilerliste auswählen',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'Verfügbare Verteilerliste-Adressen',

    'LBL_EMAIL_MULTISELECT' => '<b>STRG-Klick</b>, um mehrere Elemente auszuwählen<br />(Für Mac-Benutzer <b>CMD-Klick</b>)',

    'LBL_EMAIL_NO' => 'Nein',
    'LBL_EMAIL_NOT_SENT' => 'Das System war nicht in der Lage, diese Anfrage zu verarbeiten. Bitte kontaktieren Sie den Systemadministrator.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'Konnte nicht in users_password_link eingefügt werden.',

    'LBL_EMAIL_OK' => 'OK',
    'LBL_EMAIL_ONE_MOMENT' => 'Einen Moment bitte...',
    'LBL_EMAIL_OPEN_ALL' => 'Mehrere Nachrichten öffnen',
    'LBL_EMAIL_OPTIONS' => 'Optionen',
    'LBL_EMAIL_QUICK_COMPOSE' => 'Schnellerfassung',
    'LBL_EMAIL_OPT_OUT' => 'Abgelehnt',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Opt-Out und ungültig',
    'LBL_EMAIL_PAGE_AFTER' => 'von {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'Seite',
    'LBL_EMAIL_PERFORMING_TASK' => 'Aufgabe wird durchgeführt',
    'LBL_EMAIL_PRIMARY' => 'Primär',
    'LBL_EMAIL_PRINT' => 'Drucken',

    'LBL_EMAIL_QC_BUGS' => 'Fehler',
    'LBL_EMAIL_QC_CASES' => 'Ticket',
    'LBL_EMAIL_QC_LEADS' => 'Interessent',
    'LBL_EMAIL_QC_CONTACTS' => 'Kontakt',
    'LBL_EMAIL_QC_TASKS' => 'Aufgabe',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'Verkaufschance',
    'LBL_EMAIL_QUICK_CREATE' => 'Schnellerfassung',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'Ordner werden neu aufgebaut',
    'LBL_EMAIL_RELATE_TO' => 'Verknüpfung',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'Beziehungen anzeigen',
    'LBL_EMAIL_RECORD' => 'E-Mail-Eintrag',
    'LBL_EMAIL_REMOVE' => 'Entfernen',
    'LBL_EMAIL_REPLY' => 'Antworten',
    'LBL_EMAIL_REPLY_ALL' => 'Allen antworten',
    'LBL_EMAIL_REPLY_TO' => 'Antworte an',
    'LBL_EMAIL_RETRIEVING_LIST' => 'E-Mail-Liste laden',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Nachrichten laden',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'E-Mail-Eintrag laden',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Bitte nur einen E-Mail-Eintrag auswählen',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'Zurück zum vorherigen Modul?',
    'LBL_EMAIL_REVERT' => 'Zurückkehren',
    'LBL_EMAIL_RELATE_EMAIL' => 'E-Mail zuordnen',

    'LBL_EMAIL_RULES_TITLE' => 'Regel-Management',

    'LBL_EMAIL_SAVE' => 'Speichern',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'Speichern und Antworten',
    'LBL_EMAIL_SAVE_DRAFT' => 'Entwurf speichern',

    'LBL_EMAIL_SEARCHING' => 'Suche läuft',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'Erweiterte Suche',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'Von Datum',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Bis Datum',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'Textkörper',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'Keine passenden Resultate.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Suchergebnisse',
    'LBL_EMAIL_SEARCH_TITLE' => 'Einfache Suche',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'E-Mail-Konto durchsuchen',

    'LBL_EMAIL_SELECT' => 'Auswählen',

    'LBL_EMAIL_SEND' => 'Senden',
    'LBL_EMAIL_SENDING_EMAIL' => 'E-Mail wird gesendet',

    'LBL_EMAIL_SETTINGS' => 'Einstellungen',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 Zeilen',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 Spalten',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'Layout-Stil',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'E-Mail-Konten',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Formular leeren',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'E-Mail importieren beim Lesen',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Nach neuen E-Mails überprüfen',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Vorschau-Fenster verwenden',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Popup-Fenster verwenden',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'Anzahl der E-Mails pro Seite',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'E-Mail-Konto ändern',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'Ordner',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'Von-Adresse',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'E-Mail-Adresse für Test-Nachricht:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'An E-Mail-Adresse',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'Von-Name',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Antwortadresse',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Gesamter Bildschirm',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Alle E-Mail-Konten synchronisieren',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'Es wurde eine E-Mail an die angegebene Adresse gesendet. Bitte prüfen Sie nach, ob die E-Mail empfangen wurde und ob die Einstellungen für ausgehende E-Mails korrekt sind.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Dieser Vorgang synchronisiert alle Mailkonten und deren Inhalte.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'Eine volle Synchronisation durchführen?\nBei großen E-Mail-Konten kann dieser Vorgang einige Zeit dauern.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Drücken Sie die Umsch- oder Strg-Taste, um mehrere Ordner auszuwählen.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'Allgemein',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Verfügbare Gruppenordner',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Gruppenordner erstellen',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Gruppenordner werden gespeichert',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Gruppenordner wieder holen',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Gruppenordner bearbeiten',

    'LBL_EMAIL_SETTINGS_NAME' => 'Name',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Diese Einstellungen werden erst nach einem Neuaufbau der Seite verfügbar.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'E-Mail-Einstellungen laden',
    'LBL_EMAIL_SETTINGS_RULES' => 'Regeln',
    'LBL_EMAIL_SETTINGS_SAVED' => 'Einstellungen gespeichert.\n\nSie müssen die Seite neu laden, um die Einstellungen wirksam werden zu lassen.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'Sie müssen die Seite neu laden, damit die Einstellungen übernommen werden.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'E-Mail als Nur-Text senden',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Aktive E-Mailkonten',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'Anzahl der E-Mails pro Seite',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'Tabs unten anzeigen',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Visuelle Einstellungen',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Einstellungen',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Erweiterte Einstellungen anzeigen',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Verfügbare Benutzerordner',
    'LBL_EMAIL_ERROR_PREPEND' => 'Fehler:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'Der ausgehende Mailserver, der für dieses Konto ausgewählt wurde, ist ungültig. Überprüfen Sie die Einstellungen oder wählen Sie einen anderen Mailserver für dieses Konto.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'Es wurde kein ausgehender Mailserver für ausgehende E-Mails für dieses Konto konfiguriert. Bitte wählen oder ergänzen Sie einen ausgehenden Mailserver für dieses Konto.',
    'LBL_EMAIL_SHOW_READ' => 'Alle zeigen',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Alle ungelesenen zeigen',
    'LBL_EMAIL_SIGNATURES' => 'Signaturen',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'Signatur erstellen',
    'LBL_EMAIL_SIGNATURE_NAME' => 'Signaturname',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'Signatur-Inhalt',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Google Weniger sichere Apps',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'Andere:',
    'LBL_EMAIL_AUTHORIZE' => 'Autorisieren',
    'LBL_EMAIL_AUTHORIZED' => 'Autorisiert',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'Nicht autorisiert',
    'LBL_EMAIL_AUTH_WARNING' => 'Ein Administrator muss den {0} Anschluss über Admin > Anschlüsse konfigurieren, bevor Sie dieses Konto einrichten können. Weitere Informationen finden Sie in der {1} Dokumentation.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'Fehler beim Abrufen der Connector-Informationen',
    'LBL_EMAIL_AUTH_FAILURE' => 'Fehler bei der Autorisierunng.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'Bitte genehmigen Sie das Konto vor dem Speichern.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'Bitte autorisieren Sie das Konto vor dem Testen.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'Konto nicht autorisiert',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Remote-Ordner ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugar-Ordner ]',
    'LBL_EMAIL_SUBJECT' => 'Betreff',
    'LBL_EMAIL_SUCCESS' => 'Erfolg',
    'LBL_EMAIL_SUGAR_FOLDER' => 'Sugar-Ordner',
    'LBL_EMAIL_TEAMS' => 'Teams zuweisen',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'E-Mail-Vorlage ist leer',
    'LBL_EMAIL_TEMPLATES' => 'Vorlagen',
    'LBL_EMAIL_TEXT_FIRST' => 'Erste Seite',
    'LBL_EMAIL_TEXT_PREV' => 'Vorherige Seite',
    'LBL_EMAIL_TEXT_NEXT' => 'Nächste Seite',
    'LBL_EMAIL_TEXT_LAST' => 'Letzte Seite',
    'LBL_EMAIL_TEXT_REFRESH' => 'Aktualisieren',
    'LBL_EMAIL_TO' => 'An',
    'LBL_EMAIL_TOGGLE_LIST' => 'Liste ein-/ausblenden',
    'LBL_EMAIL_VIEW' => 'Ansicht',
    'LBL_EMAIL_VIEWS' => 'Ansichten',
    'LBL_EMAIL_VIEW_HEADERS' => 'Kopfzeile anzeigen',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'Druckbare Version',
    'LBL_EMAIL_VIEW_RAW' => 'Rohe E-Mail anzeigen',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'Diese Funktion kann nicht mit POP3 verwendet werden.',
    'LBL_DEFAULT_LINK_TEXT' => 'Standard-Linktext.',
    'LBL_EMAIL_YES' => 'Ja',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Test-E-Mail senden',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Test-E-Mail gesendet',


    'LBL_EMAIL_MESSAGE_NO' => 'Nachricht Nr.',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'Import durchgeführt',
    'LBL_EMAIL_IMPORT_FAIL' => 'Import fehlgeschlagen. Die Nachricht wurde bereits importiert oder wurde vom Server entfernt.',

    'LBL_EMAILS_FROM' => 'Gesendete E-Mails',
    'LBL_EMAILS_RECEIVED' => 'Erhaltene E-Mails',
    'LBL_EMAIL_ADDRESSES_USED' => 'In E-Mails verwendete E-Mail-Adressen',
    'LBL_EMAIL_ADDRESS' => 'E-Mail-Adresse',
    'LBL_FROM' => 'Von',
    'LBL_TO' => 'An',
    'LBL_CC' => 'CC',
    'LBL_BCC' => 'BCC',

    'LBL_START_DATE' => 'Startdatum',
    'LBL_END_DATE' => 'Enddatum',
    'LBL_START' => 'Start',
    'LBL_END' => 'Ende',
    'LBL_DATE_LINKED' => 'Verknüpftes Datum',

    'LBL_LINK_NONE' => 'Kein(e)',
    'LBL_LINK_ALL' => 'Alle',
    'LBL_LINK_RECORDS' => 'Sätze',
    'LBL_LINK_SELECT' => 'Auswählen',
    'LBL_LINK_ACTIONS' => 'Aktionen',
    'LBL_LINK_MORE' => 'Mehr',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'Bestätigen',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'Möchten Sie dieses #module# wirklich schließen?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'Diese Nachricht in Zukunft nicht mehr anzeigen',
    'LBL_INVALID_FILE_EXTENSION' => 'Ungültige Dateierweiterung',
    'LBL_LIST_TEAM' => 'Team',
    'LBL_TEAM' => 'Team',
    'LBL_TEAMS' => 'Teams',
    'LBL_TEAM_SET_ID' => 'Team-Set-ID',
    'LBL_TEAM_SET_SELECTED_ID' => 'Ausgewählte Team Set ID',
    'LBL_TEAM_SET_SELECTED' => 'Ausgewählt',
    'LBL_TEAM_SET_ENABLE' => 'Aktivieren von zusätzlichen Berechtigungen',
    'LBL_TEAM_SET_DISABLE' => 'Deaktivieren von zusätzlichen Berechtigungen',
    'LBL_TEAM_SET' => 'Team-Gruppe',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'Ausgewählte Teams',
    'LBL_SEARCH_UNAVAILABLE' => 'Suche nicht verfügbar, bitte später versuchen',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'Kein Primär-Team angegeben',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'Fehler beim entfernen der primären Team ID [{0}] für [{1}] Modul mit der ID [{2}]',
    'LBL_TEAM_ADD' => 'Team hinzufügen',
    'LBL_TEAM_REMOVE' => 'Team entfernen',
    'LBL_TEAM_PRIMARY' => 'Als primäres Team definieren',

    'LBL_CLOSE_BUTTON_LABEL' => 'Schließen',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} markiert als {{status}}.',

    'LBL_FOCUS' => 'Fokus',

    'LBL_QUERY_VALID' => 'Gültig',
    'LBL_QUERY_ERROR' => 'Fehler!',
    'LBL_QUERY_CHILD' => 'Gültige Sub-Anfrage',
    'ERROR_EXAMINE_MSG' => 'Bitte beachten Sie die unten stehende Fehlermeldung:',
    'NO_QUERY_SELECTED' => 'Das von Ihnen gewählte Datenformat enthält keine Abfrage. Bitte wählen Sie eine Abfrage für dieses Format aus.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'Ein Fehler ist aufgetreten',
    'ERR_AJAX_LOAD_FAILURE' => 'Es gab einen Fehler bei dieser Abfrage, bitte später erneut versuchen.',
    'ERR_AJAX_LOAD_FOOTER' => 'Wenn der Fehler andauernd, muss der Administrator Ajax für dieses Modul deaktivieren',
    'ERR_CREATING_FIELDS' => 'Fehler beim Ausfüllen von zusätzlichen Detailfeldern:',
    'ERR_CREATING_TABLE' => 'Fehler beim Anlegen der Tabelle:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'Die Dezimal- und Tausender-Trennzeichen müssen unterschiedlich sein. Bitte einen der Werte ändern.',
    'ERR_DELETE_RECORD' => 'Um einen Kontakt zu löschen, muss die Nummer des Datensatzes angegeben werden.',
    'ERR_EXPORT_DISABLED' => 'Exportieren deaktiviert.',
    'ERR_EXPORT_TYPE' => 'Fehler beim Exportieren',
    'ERR_REPORTS_DISABLED_EXPORT' => 'Der Export von Berichten ist deaktiviert',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'Nur Admin-Benutzer können exportieren',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'Der Bericht verwendet Module ohne Exportzugriff',
    'ERR_REPORTS_EXPORT_OWNER' => 'Der Bericht verwendet Module mit Eigentümer-Export-Zugriff',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'Der Bericht verwendet Module mit eingeschränktem Listenzugriff',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'Der Bericht verwendet Module mit eingeschränktem Ansichtszugriff',
    'ERR_REPORTS_ACCESS_DISABLED' => 'Der Bericht verwendet Module mit eingeschränktem Zugriff',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'Der Bericht verwendet Felder mit eingeschränktem Zugriff',
    'ERR_INVALID_AMOUNT' => 'Bitte einen gültigen Betrag eingeben.',
    'ERR_INVALID_DATE_FORMAT' => 'Das Datumsformat muss sein:',
    'ERR_INVALID_DATE' => 'Bitte ein gültiges Datum eingeben.',
    'ERR_INVALID_DAY' => 'Bitte einen gültigen Tag eingeben.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'Keine gültige E-Mail-Adresse.',
    'ERR_INVALID_FILE_REFERENCE' => 'Ungültige Datei-Referenz',
    'ERR_INVALID_HOUR' => 'Bitte eine gültige Stunde eingeben.',
    'ERR_INVALID_MONTH' => 'Bitte einen gültigen Monat eingeben.',
    'ERR_INVALID_TIME' => 'Bitte eine gültige Uhrzeit eingeben.',
    'ERR_INVALID_YEAR' => 'Bitte eine gültige Jahreszahl mit 4 Ziffern eingeben.',
    'ERR_NEED_ACTIVE_SESSION' => 'Um den Inhalt zu exportieren, muss eine aktive Sitzung vorhanden sein.',
    'ERR_NO_HEADER_ID' => 'Diese Funktion ist für dieses Design nicht verfügbar.',
    'ERR_NOT_ADMIN' => 'Unautorisierter Zugriff auf die Administration.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'Die Passwortverwaltung ist nur in den <a href="%s" target="_blank">SugarCloud-Einstellungen</a>verfügbar.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'Bitte wenden Sie sich an Ihren Sugar-Administrator, wenn Sie Änderungen an schreibgeschützten Feldern vornehmen möchten.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'Bitte gehen Sie zu den <a href="{0}" target="_blank">SugarCloud-Einstellungen</a>, um Änderungen an schreibgeschützten Feldern vorzunehmen.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'Fehlendes Pflichtfeld:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'Ungültige Pflichtfelder:',
    'ERR_INVALID_VALUE' => 'Ungültiger Wert:',
    'ERR_NO_SUCH_FILE' => 'Diese Datei existiert im System nicht.',
    'ERR_NO_SINGLE_QUOTE' => 'Hochkomma kann nicht verwendet werden als',
    'ERR_NOTHING_SELECTED' => 'Bevor Sie weitermachen, treffen Sie bitte erst eine Auswahl.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'Eine Verkaufschance mit dem Namen %s ist bereits vorhanden. Bitte einen anderen Namen unten eingeben.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'Es wurde kein Name für die Verkaufschance eingegeben. Bitte geben Sie unten einen Namen für die Verkaufschance ein.',
    'ERR_QUOTE_CONVERTED' => 'Dieses Angebot wurde bereits zu einer Verkaufschance konvertiert.',
    'ERR_POTENTIAL_SEGFAULT' => 'Ein potentieller Apache-Segmentationsfehler wurde entdeckt. Bitte informieren Sie Ihren Systemadministrator, um das Problem zu bestätigen, damit er/sie SugarCRM informieren kann.',
    'ERR_SELF_REPORTING' => 'Ein Mitarbeiter kann nicht an sich selbst berichten.',
    'ERR_SINGLE_QUOTE' => 'Hochkommas werden für dieses Feld nicht unterstützt. Bitte ändern.',
    'ERR_SQS_NO_MATCH_FIELD' => 'Kein passender Eintrag:',
    'ERR_SQS_NO_MATCH' => 'Kein Treffer',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Spezifizieren Sie den Index "key" im Attribut "displayParams" für die Metadaten-Definition',
    'ERR_EXISTING_PORTAL_USERNAME' => 'Fehler: Der Portalname wurde bereits einer anderen Kontaktperson zugeordnet',
    'ERR_PORTAL_NAME_CHECK' => 'Eindeutigkeit des Portal-Benutzernamens nicht feststellbar',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'Der Feldwert ist nicht kompatibel mit dem numerischen Feldformat.',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'Ein Fehler ist beim Speichern im externen Konto aufgetreten.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'Ein Fehler ist beim Hochladen aufgetreten. Bitte sicherstellen, dass die Datei nicht leer ist.',
    'ERR_NO_DB' => 'Könnte keine Verbindung mit dem Datenbank aufbauen. Details in der Datei "sugarcrm.log".',
    'ERR_DB_FAIL' => 'Datenbankzugriff fehlgeschlagen. Details in der Datei "sugarcrm.log".',
    'ERR_EXTERNAL_API_403' => 'Zugriff verweigert, Dateityp nicht unterstützt.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth Access Token fehlt.',
    'ERR_DB_VERSION' => 'Sugar CRM {0} kann nur mit einer Sugar CRM {1}-Datenbank arbeiten.',
    'ERR_DB_QUERY' => '{0}: Abfrage fehlgeschlagen: {1}',
    'ERR_UW_RETIRED' => 'In dieser Version ist der Upgrade-Assistent nicht verfügbar.',
    'ERR_NOT_CLOUD_INSTANCE' => 'Diese Sugar-Instanz ist entweder keine SugarCloud-Instanz oder nicht für SugarCloud Insights konfiguriert.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'Sie haben nicht die Berechtigungen, um {moduleName} zu erstellen. Benachrichtigen Sie Ihren Administrator, wenn Sie einen Zugriff benötigen.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'Der aktuelle Benutzer hat keine Berechtigung, um die Einstellungen der Konfiguration {moduleName} zu andern',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'Der aktuelle Benutzer hat keine Berechtigung, um die Einstellungen der Konfiguration {moduleName} zu andern',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'Es ist Ihnen nicht erlaubt, {moduleName} als Favorit hinzuzufügen. Bitte wenden Sie sich an den Administrator.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'Sie sind nicht berechtigt, das Modul {moduleName} zu abonnieren. Bitte wenden Sie sich an den Administrator.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'worksheet_columns_related_fields wurde nicht in Ladung gefunden',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns ist kein Array',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'summary_columns_related_fields wurde nicht in Ladung gefunden',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows ist kein Array',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rows_related_fields wurde nicht in Ladung gefunden',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'Ihre Anfrage ist wegen einer unbekannten Ausnahme fehlgeschlagen.',
    'EXCEPTION_FATAL_ERROR' => 'Ihre Anfrage konnte nicht abgeschlossen werden.  Ein schwerwiegender Fehler ist aufgetreten. Weitere Details finden Sie in den Protokollen.',
    'EXCEPTION_NEED_LOGIN' => 'Sie müssen sich zuerst anmelden, um diese Aktion durchzuführen.',
    'EXCEPTION_INVALID_TOKEN' => 'Ihr Authentifizierungstoken ist ungültig',
    'EXCEPTION_NOT_AUTHORIZED' => 'Sie haben nicht die Berechtigungen, diese Aktion durchzuführen. Benachrichtigen Sie Ihren Administrator, wenn Sie einen Zugriff benötigen.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'Sie haben nicht die Berechtigungen, um sich Daten anzeigen zu lassen. Benachrichtigen Sie Ihren Administrator, wenn Sie einen Zugriff benötigen.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'Ihr Portal-Konto ist inaktiv. Verständigen Sie den Kundendienst, wenn Sie einen Zugriff benötigen.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'Das Portal ist nicht korrekt konfiguriert. Verständigen Sie Ihren Administrator für Hilfe.',
    'EXCEPTION_NO_METHOD' => 'Ihre Anfrage wurde nicht zugelassen. Die HTTP-Methode Ihrer Anfrage konnte für diesen Pfad nicht gefunden werden.',
    'EXCEPTION_NOT_FOUND' => 'Die Anfrage konnte nicht bearbeitet werden. Es konnte kein Handler für den Pfad in der Anfrage gefunden werden.',
    'EXCEPTION_MISSING_PARAMTER' => 'Ein erforderlicher Parameter in Ihrer Anfrage fehlt.',
    'EXCEPTION_INVALID_PARAMETER' => 'Ein Parameter in Ihrer Anfrage war ungültig.',
    'EXCEPTION_REQUEST_FAILURE' => 'Ihre Anfrage konnte nicht bearbeitet werden.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'Ihre Metadaten oder Benutzer-Hashwerte stimmen nicht mit dem Server überein. Bitte synchronisieren Sie Ihre Metadaten erneut.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'Ihre Anfrage ist zum Bearbeiten zu groß.',
    'EXCEPTION_EDIT_CONFLICT' => 'Bearbeitungskonflikt, den Datensatz bitte neu laden.',
    'EXCEPTION_METADATA_CONFLICT' => 'Metadaten-Konflikt, bitte laden Sie die Metadaten neu.',
    'EXCEPTION_CLIENT_OUTDATED' => 'Ihr Programm ist veraltet, bitte führen Sie ein Update durch, bevor Sie erneut versuchen, sich zu verbinden.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'Ein Konnektor oder eine Integrationsanfrage hat zu einer fehlgeschlagenen Antwort geführt.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM ist im Wartungsmodus. Nur Administratoren können sich anmelden. Bitte kontaktieren Sie ihren Administrator für weitere Details.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'Der Server kann Ihre Anfrage nicht verarbeiten, weil er im Augenblick ausgelastet oder nicht verfügbar ist.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'Die Suchmaschine ist vorübergehend nicht verfügbar.',
    'EXCEPTION_SEARCH_RUNTIME' => 'Ein Suchmaschinenlaufzeitfehler ist aufgetreten. Bitte kontaktieren Sie Ihren Systemadministrator.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'Ein Feld, das durch einen Prozess gesperrt ist, kann nicht bearbeitet werden.',
    'EXCEPTION_MODULE_DISABLED' => 'Dieses Modul ist für den aktuellen Benutzer deaktiviert.',
    'EXCEPTION_FIELD_DISABLED' => 'Dieses Feld ist für den aktuellen Benutzer deaktiviert.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'Dieser Client ist unzulässig',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'Die Möglichkeit, Pakete hochzuladen, ist für Ihren Lizenztyp nicht verfügbar',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'Wegen eines allgemeinen Fehlers ist ein Ausnahmezustand eingetreten. Die Gründe für diesen Ausnahmezustand sind zwar definiert, liegen aber außerhalb des für API-Ausnahmen definierten Bereiches.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'Die Anfrage konnte nicht verarbeitet werden oder bei der Rückmeldung der Anfrage ist ein Fehler aufgetreten. Das bedeutet, dass ein schwerer Fehler aufgetreten ist. Mehr Informationen finden Sie im Anwendungsprotokoll.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'Die von Ihnen verwendete API-Version ist nicht übereinstimmend mit der Anfrage.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'Der aufgerufene Endpunkt erfordert eine Anmeldung, die noch nicht erfolgt ist.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'Das bei der Authentifizierung mitgegebene Token ist ungültig. Normalerweise ist dieses Token dann abgelaufen, es kann aber auch durch ein falsch formatiertes oder falsches Token mitgegeben worden sein.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'Weist darauf hin, dass der angefragte Benutzer nicht für diese Aktion autorisiert ist.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'Der Portalzugang für den angemeldeten Benutzer ist zur Zeit nicht aktiv. Unterstützung durch den Kundensupport ist notwendig.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'Fehlerhafte Konfiguration des Portals. Bitte kontaktieren Sie den Administrator des Portals.',
    'EXCEPTION_NO_METHOD_DESC' => 'Der Endpunkt unterstützt die HTTP-Anforderung nicht. Dies ist z. B. der Fall, wenn eine POST-Anforderung an einen Endpunkt gestellt wird, der nur GET-Anforderungen unterstützt.',
    'EXCEPTION_NOT_FOUND_DESC' => 'Der Endpunkt konnte keine Ressource für die Anforderung finden oder er hat keinen Handler für diese Anforderung.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'Auf einen Datensatz wurde mehrfach schreibend zugegriffen und der aktuelle Zugriff würde eine frühere Eingabe überschreiben.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'Die Metadaten des Servers stimmen nicht mit den Metadaten des Clients überein. Die kann neben anderen Systemveränderungen durch Änderung der Systemeinstellungen, Änderung von Modulen im Studio oder Installation neuer Module hervorgerufen werden.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'Die Anfrage ist zu groß, um vom Server abgearbeitet zu werden.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'Fehlender Parameter',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'Ein gesendeter Parameter ist unzulässig.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'Die Anfrage konnte nicht durchgeführt werden.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'Der Client, der API-Aufrufe tätigt, ist abgelaufen und muss erneuert werden, bevor weitere API-Aufrufe durchgeführt werden können.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'Zeigt an, dass eine über die API an einen anderen Dienst, Endpunkt oder URI gestellte Anfrage fehlgeschlagen ist oder vom Server nicht bearbeitet werden konnte.',
    'EXCEPTION_MAINTENANCE_DESC' => 'Die SugarCRM-Instanz, in der das API ausgeführt wird, befindet sich im Wartungsmodus. Nur Administratoren können das API aufrufen.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'Gibt an, dass der Server beschäftigt, überladen oder ausgefallen ist.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'Das Suchmaschinen-Backend steht derzeit wegen eines Verbindungsproblems nicht zur Verfügung. Überprüfen Sie die Verbindung und die Einstellungen unter Admin-> Suche-> Test.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'In der Suchmaschine ist eine Laufzeitausnahme aufgetreten. Mehr Details finden Sie in der Datei sugarcrm.log.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'Ein Feld, das momentant durch einen laufenden Prozess gesperrt ist, kann nicht bearbeitet werden.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s ist durch einen laufenden Prozess gesperrt und kann nicht bearbeitet werden.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s sind durch einen laufenden Prozess gesperrt und können nicht bearbeitet werden.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'Dieses Modul ist für den aktuellen Benutzer deaktiviert.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'Dieses Feld ist für den aktuellen Benutzer deaktiviert.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'Dieser Client ist unzulässig',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'Es existiert bereits eine Datei mit demselben Namen im System.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'Fehler-Zeitspanne nicht definiert für Datum {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'Die Zeitspanne hat bereits untergeordnete Zeitspannen',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'Eine untergeordnete Zeitspanne kann keine weitere untergeordnete Zeitspannen haben',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'Abruf der Zeitspanne von Typ: {0} nicht möglich',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'Keine aktiven Zeiträume für die aktuellen Einstellungen.',
    'LBL_CURRENT_TIMEPERIOD' => 'Aktuelle Periode',
    'LBL_PREVIOUS_TIMEPERIOD' => 'Vorherige Periode',
    'LBL_NEXT_TIMEPERIOD' => 'Nächste Periode',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'Vorherige, aktuelle, nächste',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'Berichte, für die die Verkaufphase abgeschlossen wurde, können nicht gelöscht werden.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'Berichte, deren Verkaufsstatus geschlossen ist, können nicht gelöscht werden.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'Einer oder mehrere der ausgewählten Berichte haben die Verkaufsphase bereits gewonnen oder verloren und können nicht gelöscht werden.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'Einer oder mehrere der ausgewählten Berichte hat den Status gewonnen oder verloren und kann nicht gelöscht werden.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'Firma',
    'LBL_OLD_ACCOUNT_LINK' => 'Alte Firma',
    'LBL_ACCOUNTS' => 'Firmen',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Aktivitäten',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Zusammenfassung zeigen',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Zusammenfassung zeigen [Alt+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Hinzufügen',
    'LBL_ADD_BUTTON' => 'Hinzufügen',
    'LBL_ADD_DASHLET_BUTTON' => 'Dashlet hinzufügen',
    'LBL_ADD_DOCUMENT' => 'Dokument hinzufügen',
    'LBL_REPLACE_BUTTON' => 'Ersetzen',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Zu einer Kontaktliste hinzufügen',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Zu einer Kontaktliste hinzufügen',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Zum Beenden klicken',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Schließen',
    'LBL_ADDITIONAL_DETAILS' => 'Weitere Details',
    'LBL_ADMIN' => 'Admin',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'Archivieren',
    'LBL_ASSIGNED_TO_USER' => 'Bearbeiter',
    'LBL_ASSIGNED_TO' => 'Zugewiesen an:',
    'LBL_BACK' => 'Zurück',
    'LBL_BASE_RATE' => 'Grundtrarif',
    'LBL_BILL_TO_ACCOUNT' => 'Rechnung an Firma',
    'LBL_BILL_TO_CONTACT' => 'Rechnung an Kontaktperson',
    'LBL_BILLING_ADDRESS' => 'Rechnungsadresse',
    'LBL_QUICK_CREATE_TITLE' => 'Schnellerfassung',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'Fehler',
    'LBL_BY' => 'von',
    'LBL_CALLS' => 'Anrufe',
    'LBL_CALL' => 'Anruf',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Sende Kampagnen-E-Mails in Warteschlange',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Ausführen',
    'LBL_CASE' => 'Ticket',
    'LBL_CASES' => 'Tickets',
    'LBL_MESSAGE' => 'Nachricht',
    'LBL_MESSAGES' => 'Nachrichten',
    'LBL_ESCALATIONS' => 'Eskalationen',
    'LBL_ESCALATION' => 'Eskalation',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign Umschläge',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign Umschlag',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'Unterzeichner-Empfänger auswählen',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'Passwort ändern',
    'LBL_CHANGE_BUTTON_LABEL' => 'Ändern',
    'LBL_CHANGE_BUTTON_TITLE' => 'Ändern [Alt+G]',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Alle markieren',
    'LBL_CITY' => 'Stadt',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Leeren',
    'LBL_CLEAR_BUTTON_TITLE' => 'Leeren [Alt+C]',
    'LBL_CLEARALL' => 'Alle Markierungen entfernen',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => 'Schließen',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'Fenster schließen',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Alle schließen',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Alle schließen [Alt+I]',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Schließen & Neu',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Schließen & Neu',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'URL des Datensatzes kopieren',
    'LBL_OPEN_ITEMS' => 'Offene Datensätze',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Neue E-Mail',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'E-Mail',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Neue E-Mail [Alt+E]',
    'LBL_SEARCH_DROPDOWN_YES' => 'Ja',
    'LBL_SEARCH_DROPDOWN_NO' => 'Nein',
    'LBL_CONTACT_LIST' => 'Kontaktliste',
    'LBL_CONTACT' => 'Kontakt',
    'LBL_CONTACTS' => 'Kontakte',
    'LBL_CONTRACTS' => 'Verträge',
    'LBL_COUNTRY' => 'Land:',
    'LBL_RESET_BUTTON_LABEL' => 'Zurücksetzen',
    'LBL_CREATE_BUTTON_LABEL' => 'Erstellen',
    'LBL_CREATED_BY_USER' => 'Erstellt von',
    'LBL_CREATED_USER' => 'Erstellt von',
    'LBL_CREATED_ID' => 'Ersteller',
    'LBL_CREATED' => 'Erstellt von',
    'LBL_CREATE_NEW_TARGET_LIST' => 'Neue Kontaktliste erstellen',
    'LBL_CURRENT_USER_FILTER' => 'Meine Einträge:',
    'LBL_CURRENCY' => 'Währung',
    'LBL_CURRENCIES' => 'Währungen',
    'LBL_CURRENCY_NAME' => 'Währungsname',
    'LBL_CURRENCY_SYMBOL' => 'Währungssymbol',
    'LBL_CURRENCY_RATE' => 'Grundtarif:',
    'LBL_CURRENCY_ID' => 'Währungs-ID',
    'LBL_DOCUMENTS' => 'Dokumente',
    'LBL_DATE_ENTERED' => 'Datum erstellt:',
    'LBL_DATE_MODIFIED' => 'Geändert am:',
    'LBL_ACTIVITY_MODIFIED' => 'Geändert',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'Registerkarte Übersicht bearbeiten',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'Modul-Registerkarten bearbeiten',
    'LBL_EDIT_BUTTON' => 'Bearbeiten',
    'LBL_DUPLICATE_BUTTON' => 'Duplizieren',
    'LBL_DELETE_BUTTON' => 'Löschen',
    'LBL_DELETE' => 'Löschen',
    'LBL_DELETED' => 'Gelöscht',
    'LBL_DIRECT_REPORTS' => 'Direkt Unterstellte',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Fertig',
    'LBL_DONE_BUTTON_TITLE' => 'Fertig [Alt+X]',
    'LBL_DST_NEEDS_FIXIN' => 'Das Programm benötigt die Anwendung des Sommerzeit-Patches.Bitte klicken Sie auf <a href="index.php?module=Administration&action=DstFix">Reparieren</a> im Admin-Bereich und wenden Sie den Sommerzeit-Patch an.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Als neu bearbeiten',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Als neu bearbeiten',
    'LBL_EDIT_IN_NEW_TAB' => 'In neuer Registerkarte bearbeiten',
    'LBL_FAVORITES' => 'Favoriten',
    'LBL_FILTER' => 'Filter',
    'LBL_DEFAULT_DATA_FILTER' => 'Standard-Daten-Filter',
    'LBL_FILTER_MENU_BY' => 'Menü filtern nach',
    'LBL_FILTER_SELECT_FIELD' => 'Feld wählen...',
    'LBL_FILTER_SELECT_OPERATOR' => 'Operator wahlen...',
    'LBL_FILTER_CREATE_NEW' => 'Erstellen',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'Build Filter (nicht gespeichert)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(Nicht gespeichert)',
    'LBL_FILTER_CREATE_FILTER' => 'Neuen Filter erstellen',
    'LBL_FILTER_CLOSE_FILTER' => 'Filter schließen',
    'LBL_FILTER_EDIT_FILTER' => 'Filter bearbeiten',
    'LBL_FILTER_ALL_RECORDS' => 'Alle Datensätze',
    'TPL_FILTER_SAVE' => 'Der Filter {{name}} wurde erfolgreich erstellt.',
    'LBL_FILTER_BETWEEN_FROM' => 'Von',
    'LBL_FILTER_BETWEEN_TO' => 'An',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'Startdatum',
    'LBL_FILTER_DATEBETWEEN_TO' => 'Enddatum',
    'LBL_FOLLOWING' => 'Folgen',
    'LBL_UNFOLLOW' => 'Nicht mehr folgen',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'vCard herunterladen',
    'LBL_EMPTY_VCARD' => 'Bitte wählen Sie eine vCard-Datei aus',
    'LBL_IMAGE' => 'Bild',
    'LBL_EMPTY_REQUIRED_VCARD' => 'Die vCard verfügt nicht über die Pflichtfelder für dieses Modul.',
    'LBL_VCARD_ERROR_FILESIZE' => 'Die hochgeladene Datei überschreitet die Größenbeschränkung von 30 000 Bytes, welche im HTML-Formular angegeben wurde.',
    'LBL_VCARD_ERROR_DEFAULT' => 'Beim Laden der vCard ist ein Fehler aufgetreten.',
    'TPL_IMPORT_VCARD_FAILURE' => 'Fehler beim Erstellen von vCard.',
    'LBL_IMPORT_VCARD' => 'vCard importieren:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'Importiere vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'Importiere vCard [Alt+I]',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'Ansicht',
    'LBL_VIEW_BUTTON_TITLE' => 'Anzeigen [Alt+V]',
    'LBL_VIEW_BUTTON' => 'Ansicht',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'E-Mail als PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'E-Mail als PDF [Alt+M]',
    'LBL_EMAIL' => 'E-Mail',
    'LBL_EMAILS' => 'E-Mails',
    'LBL_EMPLOYEES' => 'Mitarbeiter',
    'LBL_ENTER_DATE' => 'Datum eingeben',
    'LBL_EXPORT_ALL' => 'Alle exportieren',
    'LBL_EXPORT' => 'Exportieren',
    'LBL_FAVORITES_FILTER' => 'Meine Favoriten',
    'LBL_GLOBAL_SEARCH' => 'Globale Suche',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'Globaler Suchemodul-Filter',
    'LBL_GLOBAL_SEARCH_RUN' => 'Globale Suche starten',
    'LBL_GO_BUTTON_LABEL' => 'Start',
    'LBL_GS_HELP' => 'Die Suchfelder für dieses Modul erscheinen oben. Der markierte Text passt zu Ihren Suchkriterien.',
    'LBL_HIDE' => 'Ausblenden',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => 'Import',
    'LBL_IMPORT_STARTED' => 'Import gestartet:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Ein benutzerdefiniertes Trennzeichen muss angegeben werden.',
    'LBL_LAST_VIEWED' => 'Zuletzt angesehen',
    'LBL_SELECTED_RECORDS' => 'Ausgewählt: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'Weniger anzeigen',
    'LBL_SHOW_MORE' => 'Mehr anzeigen',
    'LBL_SHOW_MORE_MODULE' => 'Mehr {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'Weniger zeigen...',
    'LBL_SHOW_LESS_RECENTS' => 'Zeige weniger',
    'LBL_SHOW_MORE_RESULTS' => 'Mehr Suchergebnisse...',
    'TPL_SHOW_MORE_MODULE' => 'Mehr {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => 'Mehr {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => 'Heutige Aktivitäten',
    'LBL_LEADS' => 'Interessenten',
    'LBL_LEAD' => 'Interessent',
    'LBL_QUOTES_BILL_TO' => 'Angebote (Rechnung)',
    'LBL_LESS' => 'weniger',
    'LBL_CAMPAIGN' => 'Kampagne:',
    'LBL_CAMPAIGNS' => 'Kampagnen',
    'LBL_CAMPAIGNLOG' => 'KampagnenProtokoll',
    'LBL_CAMPAIGN_CONTACT' => 'Kampagnen',
    'LBL_CAMPAIGN_ID' => 'campaign_id',
    'LBL_THEME' => 'Schema',
    'LBL_THEME_PICKER' => 'Seitendesign',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Warnung: Internet Explorer 6 wird für das ausgewählte Schema nicht unterstützt. Auf "OK" klicken, um fortzufahren, oder auf "Abbrechen" klicken, um ein anderes Schema auszuwählen.',
    'LBL_FOUND_IN_RELEASE' => 'Gefunden in Release',
    'LBL_FIXED_IN_RELEASE' => 'Behoben in Version',
    'LBL_LIST_ACCOUNT_NAME' => 'Firmenname',
    'LBL_LIST_ASSIGNED_USER' => 'Benutzer',
    'LBL_LIST_CONTACT_NAME' => 'Kontaktname',
    'LBL_LIST_CONTACT_ROLE' => 'Kontakt-Rolle',
    'LBL_LIST_DATE_ENTERED' => 'Erstellungsdatum',
    'LBL_LIST_EMAIL' => 'E-Mail',
    'LBL_LIST_NAME' => 'Name',
    'LBL_LIST_OF' => 'von',
    'LBL_LIST_PHONE' => 'Telefonnummer',
    'LBL_LIST_RELATED_TO' => 'Bezieht sich auf',
    'LBL_LIST_USER_NAME' => 'Benutzername',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'Möchten Sie wirklich die gesamte Liste aktualisieren?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Bitte mindestens 1 Datensatz auswählen, um fortzufahren.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Bitte wählen Sie mindestens 2 Datensätze aus, um fortzufahren.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Bitte weniger als 10 Datensätze auswählen, um fortzufahren.',
    'LBL_LISTVIEW_ALL' => 'Alle',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'Säule 1 einfrieren',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'Alle Duplikate',
    'LBL_LISTVIEW_NONE' => 'Alle Markierungen aufheben',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Diese Seite auswählen',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Alle auswählen',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Ausgewählte Datensätze',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Ausgewählt: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'Alle Markierungen löschen',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'Alle auswählen',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'Die Liste enthält mehr als {{num}} Datensätze. Sie habe die ersten {{num}} Datensätze ausgewählt.',
    'TPL_LISTVIEW_SELECTED' => 'Sie haben {{num}} Datensätze in den Resultaten ausgewählt.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'Sie haben 1 Datensatz in der Trefferliste ausgewählt.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'Sie haben alle {{num}} Datensätze in den Resultaten ausgewählt.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'Sie haben alle {{num}} Datensätze dieser Ansicht ausgewählt. {{link}} in den Resultaten.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => '{{num}} von {{total}} werden aktualisiert',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(ca. {{time}} {{unit}} verbleibend)',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'Massenänderung fehlgeschlagen. Einleiten eines neuen Versuches ({{num}} von {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'Massenänderung unvollständig. {{num}} Datensatz/-sätze bleiben unverändert.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'Massenänderung unvollständig. {{num}} Datensatz/-sätze bleiben unverändert.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} Datensatz/-sätze wurden wegen der Zugriffsrechte oder wegen Fehlern ignoriert.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} Datensatz/-sätze wurden erfolgreich geändert.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} Massenänderung',
    'TPL_MASSDELETE_PROGRESS_STATUS' => '{{num}} von {{total}} werden gelöscht',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(ca. {{time}} {{unit}} verbleibend)',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'Massenlöschung fehlgeschlagen. Einleiten eines neuen Versuches ({{num}} von {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'Massenlöschung unvollständig. {{num}} Datensatz/-sätze bleiben ungelöscht.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'Massenlöschung unvollständig. {{num}} Datensatz/-sätze bleiben ungelöscht.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} Datensatz/-sätze wurden erfolgreich gelöscht.',
    'TPL_MASSDELETE_TITLE' => '{{module}} Massenlöschung',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => '{{num}} von {{total}} werden hinzugefügt.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(ca. {{time}} {{unit}} verbleibend)',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'Hinzufügen zur Zielkontaktliste fehlgeschlagen. Einleiten eines neuen Versuches ({{num}} von {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'Hinzufügen zur Zielkontaktliste unvollständig. {{num}} Datensatz/-sätze nicht hinzugefügt.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'Hinzufügen zur Zielkontaktliste unvollständig. {{num}} Datensatz/-sätze nicht hinzugefügt.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} Datensatz/-sätze wurden erfolgreich hinzugefügt.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} Hinzufügen zur Zielkontaktliste',
    'TPL_MASSLINK_PROGRESS_STATUS' => '{{num}} von {{total}} werden verknüpft.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(ca. {{time}} {{unit}} verbleibend)',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'Massenverknüpfung fehlgeschlagen. Neuer Versuch, ({{num}} von {{total}}) zu verknüpfen.',
    'TPL_MASSLINK_WARNING_CLOSE' => 'Verknüpfung unvollständig. {{num}} Datensätze wurden nicht hinzugefügt.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'Verknüpfung unvollständig. {{num}} Datensätze wurden nicht hinzugefügt.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} Datensätze wurden erfolgreich verknüpft.',
    'TPL_MASSLINK_TITLE' => '{{module}} Massenverknüpfung',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'Auswählen',
    'LBL_LISTVIEW_ACTIONS' => 'Aktionen',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'Alle Datensätze auf dieser Seite auswählen',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'Alle Datensätze auf dieser Seite abwählen',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} von {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '{{num}} werden geladen...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'Klicken Sie hier für die Gesamtsumme',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'von',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'Anzahl Seiten erhalten',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'Hans',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Muster',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Hr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Code Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => 'Bitte anmelden, um diesen Bereich benutzen zu können.',
    'LBL_LOGOUT' => 'Abmelden',
    'LBL_FINISH_IMPERSONATING' => 'Imitation abschließen',
    'LBL_RESET_MFA' => 'Multi-Faktor-Authentifizierung zurücksetzen',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, Sie imitieren momentan {{user}}.',
    'LBL_PROFILE' => 'Profil',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'Serienbrief',
    'LBL_MASS_UPDATE' => 'Massenänderung',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'Alle Datensätze für Massenaktualisierung auswählen',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'Datensatz in Massenaktualisierung einbeziehen',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'Feld hinzufügen',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'Feld entfernen',
    'LBL_GENERATE_QUOTE' => 'Angebot generieren',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'Es gibt keine Felder für die Massen-Update-Funktion',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'Ihre Anforderung für das Massen-Update wurde eingeplant.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'Service-Startdatum liegt nach Service-Enddatum.',
    'LBL_MASS_UPDATE_SUCCESS' => 'Alle Einträge wurden erfolgreich aktualisiert.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'Die ausgewählten Datensätze wurden der Zielkontaktliste <a href="{{listUrl}}">{{listName}}</a> hinzugefügt.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'Ihr Antrag, Datensätze der Zielkontakliste <a href="{{listUrl}}">{{listName}}</a> hinzuzufügen, wurde eingeplant.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'Die folgenden Attribute haben leere Werte:',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'Abbrechen, um die aktuellen Werte beizubehalten. Bestätigen, um die Werte zu entfernen.',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'Primäre E-Mail-Adresse abmelden',
    'LBL_MEETINGS' => 'Meetings',
    'LBL_MEETING' => 'Meeting',
    'LBL_MEETING_GO_BACK' => 'Zurück zum Meeting',
    'LBL_MEMBERS' => 'Mitglieder',
    'LBL_MEMBER_OF' => 'Mitglied von',
    'LBL_MODIFIED_BY_USER' => 'Geändert von',
    'LBL_MODIFIED_USER' => 'Geändert von',
    'LBL_MODIFIED' => 'Geändert von',
    'LBL_MODIFIED_NAME' => 'Geändert von Name',
    'LBL_MODIFIED_ID' => 'Geändert von ID',
    'LBL_MORE' => 'mehr',
    'LBL_MORE_MODULES' => 'Weitere Module',
    'LBL_MORE_TABS' => 'Weitere Registerkarten',
    'LBL_MULTIPLE_MODULES' => 'Mehrere Module',
    'LBL_COUNT_MODULES' => '{{count}} Module',
    'LBL_MY_ACCOUNT' => 'Meine Einstellungen',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'Systemstandard',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'Benutzerstandard',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'Benutzerkonto',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'Gruppenkonto',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'Name',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Erstellen',
    'LBL_NEW_BUTTON_TITLE' => 'Neu [Alt+N]',
    'LBL_NEXT_BUTTON_LABEL' => 'Weiter',
    'LBL_NOTES' => 'Notizen',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Alle öffnen',
    'LBL_OPENALL_BUTTON_TITLE' => 'Alle öffnen [Alt+O]',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Öffnen zu:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Öffnen zu:',
    'LBL_OPEN_IN_NEW_TAB' => 'In neuer Registerkarte öffnen',
    'LBL_OPPORTUNITIES' => 'Verkaufschancen',
    'LBL_OPPORTUNITY_NAME' => 'Verkaufschance-Name',
    'LBL_OPPORTUNITY' => 'Verkaufschance',
    'LBL_OR' => 'ODER',
    'LBL_LOWER_OR' => 'oder',
    'LBL_PANEL_ASSIGNMENT' => 'Andere',
    'LBL_PANEL_ADVANCED' => 'Mehr Informationen',
    'LBL_PANEL_BODY' => 'Überblick',
    'LBL_PARENT_TYPE' => 'Eltern-Typ',
    'LBL_RELATED_TYPE' => 'Verknüpfter Typ',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'Bereich',
    'LBL_PICTURE_FILE' => 'Bild',
    'LBL_POSTAL_CODE' => 'PLZ:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'Hauptadresse Stadt:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'Hauptadresse Land:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'Hauptadresse PLZ:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Hauptadresse Bundesland:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Hauptadresse Strasse 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Hauptadresse Strasse 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Hauptadresse Straße:',
    'LBL_PRIMARY_ADDRESS' => 'Hauptadresse:',

    'LBL_BILLING_STREET' => 'Straße:',
    'LBL_SHIPPING_STREET' => 'Straße:',

    'LBL_PRODUCT_BUNDLES' => 'Produktpakete',
    'LBL_PRODUCTS' => 'Produkte',
    'LBL_PROJECT_TASKS' => 'Projektaufgaben',
    'LBL_PRODUCT_TEMPLATES' => 'Produktvorlagen',
    'LBL_PROJECTS' => 'Projekte',
    'LBL_PROSPECTS' => 'Zielkontakte',
    'LBL_QUICK_CREATE_MENU' => 'Menü für Schnellerstellung',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Verkaufschance aus Angebot erstellen',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Verkaufschance aus Angebot erstellen [Alt+O]',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'Verkaufschance wird erstellt...',
    'LBL_QUOTES_SHIP_TO' => 'Angebote liefern an',
    'LBL_QUOTES' => 'Angebote',

    'LBL_FORECAST_WORKSHEETS' => 'Prognose-Arbeitsblätter',
    'LBL_FORECAST_WORKSHEET' => 'Prognose-Arbeitsblatt',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'Einladung',
    'LBL_INVITED' => 'eingeladen',
    'LBL_RECOMMENDED_INVITES' => 'Empfohlene Einladungen',
    'LBL_INSTANCES' => 'Instanzen',
    'LBL_YOUR_INSTANCES' => 'Ihre Instanzen',
    'LBL_INSTANCE_USERS' => 'Instanz-Benutzer',
    'LBL_SWITCH_INSTANCE' => 'Zu dieser Instanz wechseln',
    'LBL_LAST_LOGIN' => 'letzte Anmeldung',
    'LBL_ENTER_EMAIL' => 'E-Mail für Teilnehmer angeben...',
    'LBL_INSTANCE_IN_USE' => 'Instanz in Verwendung',
    'LBL_INSTANCE_ACTIVE' => 'Sie verwenden diese Instanz bereits!',
    'LBL_INSTANCE_INVITE_SENT' => 'Einladung gesendet an:',
    'LBL_INSTANCE_SWITCH_FAILED' => 'Instanzwechsel fehlgeschlagen',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'Erinnerungen',
    'LBL_REMINDERS_OVERDUE' => 'Überfällig',
    'LBL_REMINDERS_UPCOMING' => 'Bevorstehend',
    'LBL_REMINDERS_NONE_FOUND' => 'Keine Erinnerungen gefunden.',
    'LBL_REMINDERS_FINISHED' => 'Abgeschlossen!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'Verkaufschancen im Überblick',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'Sweet Spot-Konfigurationsfeld',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'Hotkeys',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'Fehler beim Aktualisieren der Konfigurationseinstellungen: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'Sweet Spot-Aktion',
    'LBL_SWEETSPOT_KEY' => 'Schlüsselwort',
    'LBL_SWEETSPOT_REMOVE' => 'Vorgang rückgängig machen',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'Hotkeys',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'Aktionen',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'Sätze',
    'LBL_SWEETSPOT_THEME' => 'Design',
    'LBL_SWEETSPOT_THEME_SELECT' => 'Design wählen',

    'LBL_RELATED' => 'Verknüpft',
    'LBL_RELATED_INFORMATION' => 'Verknüpfte Informationen',
    'LBL_RELATED_RECORDS' => 'Verknüpftes {{module}}',
    'LBL_REPORTS_TO' => 'Berichtet an',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'Pflichtfeld',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Erledigt',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Speichern unter',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Speichern unter [Alt+A]',
    'LBL_FULL_FORM_BUTTON_KEY' => 'F',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Komplettes Formular',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Komplettes Formular [Alt+F]',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Speichern & Neu erstellen',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Speichern & Neu erstellen',
    'LBL_SAVE_OBJECT' => 'Speichern {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Suchen',
    'LBL_SEARCH_BUTTON_TITLE' => 'Suchen [Alt+Q]',
    'LBL_SEARCH' => 'Suchen',
    'LBL_SEARCH_TIPS' => 'Klicken Sie auf die Suche-Schaltfläche oder betätigen Sie die Eingabetaste, um ein exaktes Resultat zu erhalten.',
    'LBL_SEARCH_TIPS_2' => 'Klicken Sie auf die Suche-Schaltfläche oder betätigen Sie die Eingabetaste für ein exaktes Resultat für',
    'LBL_SEARCH_MORE' => 'mehr',
    'LBL_SEE_ALL' => 'Alle ansehen',
    'LBL_SEARCH_LOAD_MORE' => 'MEHR LADEN',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Ungültiges Dateiformat! Es können nur Bilddateien hochgeladen werden.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'Das Bildformat {0} wird nicht mehr unterstutzt.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Auswählen',
    'LBL_SELECT_BUTTON_TITLE' => 'Auswählen [Alt+T]',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'Team(s) hinzufügen',
    'LBL_SELECT_TEAMS_TITLE' => 'Team(s) hinzufügen ',
    'LBL_SELECT_APPEND_TEAMS' => 'Teams anheften',
    'LBL_SELECT_APPEND_VALUES' => 'Wert(e) anheften',
    'LBL_SELECT_APPEND_TAGS' => 'Tag(s) anheften',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Dokumente durchsuchen',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Dokumente durchsuchen [Alt+B]',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Kontakt auswählen',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Kontakt auswählen [Alt+T]',
    'LBL_GRID_SELECTED_FILE' => 'gewählte Datei',
    'LBL_GRID_SELECTED_FILES' => 'gewählte Dateien',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Aus Bericht wählen',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Berichte auswählen',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Benutzer auswählen',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Benutzer auswählen [Alt+U]',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Auswahl aufheben',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Auswahl aufheben',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Auswahl aufheben',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Auswahl aufheben',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Datei auswählen [Alt+F]',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Datei auswählen:',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Datei löschen',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Datei löschen',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Benutzer auswählen [Alt+U]',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Benutzer auswählen',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Benutzer löschen',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Benutzer löschen',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Firma auswählen [Alt+A]',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Firma auswählen',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Firma löschen',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Firma löschen',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Kampagne auswählen [Alt+M]',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Kampage auswählen',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Kampagne leeren',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Kampagne leeren',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'Kontakt auswählen [Alt+C]',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'Kontakt auswählen',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Kontakt leeren',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Kontakt leeren',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Team auswählen [Alt+Z]',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Team auswählen',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Team leeren',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Team leeren',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Ressourcen zum Aufbau dieser Seite (Abfragen, Dateien)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'Sekunden.',
    'LBL_SERVER_RESPONSE_TIME' => 'Server-Antwortzeit:',
    'LBL_SERVER_MEMORY_BYTES' => 'Bytes',
    'LBL_SERVER_MEMORY_USAGE' => 'Speicherauslastung des Servers: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Verbrauch: - Modul: {0} - Vorgang: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Höchstauslastung des Server-Speichers: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'Liefern an Firma',
    'LBL_SHIP_TO_CONTACT' => 'Liefern an Kontaktperson',
    'LBL_SHIPPING_ADDRESS' => 'Lieferadresse',
    'LBL_SHORTCUTS' => 'Schnellmenü',
    'LBL_SHOW' => 'Anzeigen',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'Bundesland:',
    'LBL_STATUS_UPDATED' => 'Der Status für dieses Ereignis wurde aktualisiert!',
    'LBL_STATUS_NOT_UPDATED' => 'Ihr Status für dieses Ereignis wurde nicht aktualisiert.',
    'LBL_STATUS' => 'Status:',
    'LBL_STREET' => 'Straße',
    'LBL_SUBJECT' => 'Betreff',

    'LBL_INBOUNDEMAIL_ID' => 'Eingehende E-Mail-ID',
    'LBL_EAMP_ID' => 'Token-ID für die Authentifizierung',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'Alle Rechte vorbehalten.<br />SugarCRM, Sugar und der 3-D-Würfel sind eingetragene Warenzeichen von SugarCRM Inc. ' .
        'Alle anderen in diesem Produkt verwendeten oder angegebenen Firmen- und Produktnamen sind möglicherweise Markenzeichen von ' .
        'den jeweiligen Unternehmen, mit denen sie verbunden sind.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'Geplanter Job abgeschlossen',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'Der geplante Job wurde erfolgreich ausgeführt',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'Umsatzposten sind jetzt in Ihrer Sugar-Instanz aktiviert',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Umsatzposten sind jetzt in Ihrer Sugar-Instanz aktiviert und alle bestehenden Verkaufschancendaten wurden verarbeitet. Ihre Instanz kann jetzt mit Umsatzposten verwendet werden. Weitere Informationen über die vorgenommenen Änderungen siehe {{doc_url}}.

Mit freundlichen Grüßen, SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'Das Prognosemodul kann jetzt mit den Verkaufschancen in Ihrer Sugar-Instanz verwendet werden',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'Das Prognosemodul in Ihrer Sugar-Instanz kann jetzt mit Verkaufschancen verwendet werden. Alle vorhergehenden Umsatzposten-Prognosedaten wurden entfernt und die Instanz ist für Prognosen bereit, die mit Verkaufschancen erstellt und festgelegt werden. Weitere Informationen über die vorgenommenen Änderungen siehe {{doc_url}}.

Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Umsatzposten sind jetzt in Ihrer Sugar-Instanz deaktiviert',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Umsatzposten sind jetzt in Ihrer Sugar-Instanz deaktiviert und alle bestehenden Umsatzpostendaten wurden verarbeitet. Ihre Instanz kann jetzt mit Umsatzposten verwendet werden. Weitere Informationen über die vorgenommenen Änderungen siehe {{doc_url}}.

Sincerely, SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'Dokumentation Verkaufschancen-Konfiguration',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'Anmelden',
    'LBL_LOGIN_WELCOME_TO' => 'Willkommen bei',
    'LBL_LOGIN_OPTIONS' => 'Optionen',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'Passwort vergessen?',
    'LBL_LOGIN_SUBMIT' => 'Absenden',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'Zu viele fehlgeschlagene Anmeldeversuche.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'Sie können nochmals versuchen, sich anzumelden',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'Tage.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 'Std.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'Min.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'Sec.',
    'LBL_LOGIN_ADMIN_CALL' => 'Bitte kontaktieren Sie den Systemadministrator',
    'LBL_LOGIN_USERNAME' => 'Benutzername',
    'LBL_LOGIN_PASSWORD' => 'Passwort',
    'LBL_LOGGED_OUT' => 'Sie wurden abgemeldet.',
    'LBL_LOGIN_FORM_LABEL' => 'Anmeldeformular anzeigen',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'Zurück zur Anmeldung',
    'LBL_LOGIN_INACTIVE_USER' => 'Inaktiver Benutzer',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'Portal- oder Gruppenbenutzer kann sich nicht anmelden.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'Dashboard',
    'LBL_SYNC' => 'Synchronisierung',
    'LBL_TASKS' => 'Aufgaben',
    'LBL_TEAMS_LINK' => 'Team',
    'LBL_THEME_COLOR' => 'Farbe',
    'LBL_THEME_FONT' => 'Schriftart',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'Neues Meeting',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'Neues Meeting',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'E-Mail archivieren',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'E-Mail archivieren [Alt+K]',
    'LBL_UNAUTH_ADMIN' => 'Unautorisierter Zugriff auf Verwaltung',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Rückgängig',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Rückgängig [Alt+D]',
    'LBL_UNDELETE_BUTTON' => 'Rückgängig',
    'LBL_UNDELETE' => 'Rückgängig',
    'LBL_UNSYNC' => 'Nicht mehr synchronisieren',
    'LBL_UPDATE' => 'Aktualisieren',
    'LBL_UPDATES' => 'Aktualisierungen',
    'LBL_USER_LIST' => 'Benutzerliste',
    'LBL_USER_MENU' => 'Benutzer',
    'LBL_USERS_SYNC' => 'Benutzer-Synchronisierung',
    'LBL_USERS' => 'Benutzer',
    'LBL_USER' => 'Benutzer',
    'LBL_CURRENT_USER' => 'Aktueller Benutzer',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'Suche nach bestehenden E-Mail-Einträgen...',
    'LBL_VERIFY_PORTAL_NAME' => 'Suche nach bestehendem Portalnamen...',
    'LBL_VIEW_IMAGE' => 'Ansicht',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'Als PDF drucken',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'Als PDF drucken [Alt+P]',

    'LBL_KBDOCUMENTS' => 'Wissensdatenbank',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'Über',
    'LNK_ADVANCED_SEARCH' => 'Erweiterte Suche',
    'LNK_BASIC_SEARCH' => 'Einfache Suche',
    'LNK_SEARCH_NO_RESULTS' => 'Keine Ergebnisse wurden gefunden.',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'Alle Ergebnisse anzeigen',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Alle zeigen',
    'LNK_CLOSE' => 'Schließen',
    'LBL_MODIFY_CURRENT_SEARCH' => 'Aktuelle Suche ändern',
    'LNK_SAVED_VIEWS' => 'Layout-Optionen',
    'LNK_DELETE_ALL' => 'Alles löschen',
    'LNK_DELETE' => 'Löschen',
    'LNK_EDIT' => 'Bearbeiten',
    'LNK_VIEW' => 'Ansicht',
    'LNK_GET_LATEST' => 'Letzte anzeigen',
    'LNK_GET_LATEST_TOOLTIP' => 'Ersetzen mit letzter Version',
    'LNK_HELP' => 'Hilfe',
    'LNK_CREATE' => 'Erstellen',
    'LNK_CREATE_WHEN_EMPTY' => 'Erstellen Sie jetzt einen Datensatz.',
    'LNK_LIST_END' => 'Ende',
    'LNK_LIST_NEXT' => 'Weiter',
    'LNK_LIST_PREVIOUS' => 'Zurück',
    'LNK_LIST_RETURN' => 'Zurück zur Liste',
    'LNK_LIST_START' => 'Start',
    'LNK_LOAD_SIGNED' => 'Unterschreiben',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'Ersetzen durch signiertes Dokument',
    'LNK_PRINT' => 'Drucken',
    'LNK_BACKTOTOP' => 'zurück zum Anfang',
    'LNK_REMOVE' => 'entfernen',
    'LNK_RESUME' => 'Fortsetzen',
    'LNK_VIEW_CHANGE_LOG' => 'Audit-Protokoll anzeigen',
    'TPL_AUDIT_LOG_TITLE' => 'Audit-Protokoll für {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'Klicken Sie darauf, um das Audit-Protokoll der E-Mail-Adresse anzuzeigen',
    'LBL_NO_SEARCH_RESULTS' => 'Keine Ergebnisse zu Ihrer Suche gefunden',
    'NTC_CLICK_BACK' => 'Bitte den Zurück-Button des Browsers anklicken und den Fehler beheben.',
    'NTC_DATE_FORMAT' => '(jjjj-mm-tt)',
    'NTC_DATE_TIME_FORMAT' => '(jjjj-mm-tt 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'Möchten Sie die ausgewählten Einträge wirklich löschen?',
    'NTC_TEMPLATE_IS_USED' => 'Die Vorlage wird in mindestens einem E-Mail-Marketing-Datensatz verwendet. Sind Sie sicher dass Sie diesen löschen möchten?',
    'NTC_TEMPLATES_IS_USED' => "Die Vorlagen werden in mindestens einem E-Mail-Marketing Datensatz verwendet. Sind Sie sicher dass Sie diese löschen möchten?\n",
    'NTC_DELETE_CONFIRMATION' => 'Sind Sie sicher, dass Sie diesen Eintrag löschen möchten?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'Sind Sie sicher, dass Sie den {0} löschen möchten?',
    'LBL_METRIC_DELETE_WARNING' => 'Alle Benutzer, mit denen diese Metrikregisterkarte geteilt wurde, verlieren ebenfalls den Zugriff.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'Bestätigen Sie das Löschen von ',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'Bestätigen Sie das Update von ',
    'NTC_DELETE_SELECTED_RECORDS' => ' ausgewählten Datensätzen?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'Dieser Filter wird von allen Ansichten entfernt; das kann auch die Datenkonfiguration für Dashlets betreffen. Sind Sie sicher, dass Sie diesen Filter löschen möchten?',
    'TPL_DELETE_FILTER_SUCCESS' => 'Der Filter {{name}} wurde gelöscht.',
    'NTC_DELETE_SUCCESS' => '{0} wurde gelöscht.',
    'NTC_UNLINK_CONFIRMATION' => 'Sind Sie sicher, dass Sie diesen Eintrag trennen möchten?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'Sind Sie sicher, dass Sie die Verknüpfung für {0} entfernen möchten?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'Möchten Sie wirklich die Verknüpfung mit den {0} aufheben? Dadurch werden sie auch aus dem Feld "Hauptansprechpartner" des Tickets entfernt.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => 'Die Verknüpfung mit den {0} kann nicht aufgehoben werden, da sie der Hauptansprechpartner in diesem Ticket sind. Aktualisieren Sie das Feld "Hauptansprechpartner", bevor Sie die Verknüpfung dieses Datensatzes aufheben.',
    'NTC_UNLINK_SUCCESS' => 'Sie haben {0} Verknüpfungen entfernt.',
    'NTC_LOGIN_MESSAGE' => 'Bitte geben Sie Ihren Benutzernamen und Ihr Passwort ein.',
    'NTC_NO_ITEMS_DISPLAY' => 'nichts',
    'NTC_REMOVE_CONFIRMATION' => 'Möchten Sie diese Beziehung wirklich entfernen?',
    'NTC_REQUIRED' => 'Pflichtfeld',
    'NTC_SUPPORT_SUGARCRM' => 'Unterstützen Sie das SugarCRM Open Source-Projekt mit einer Spende über PayPal - schnell, gratis und sicher!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'Willkommen',
    'NTC_YEAR_FORMAT' => '(jjjj)',
    'LOGIN_LOGO_ERROR' => 'Bitte die SugarCRM-Logos ersetzen.',
    'FATAL_LICENSE_ALTERED' => 'Ihre Lizenz wurde seit der letzten Validierung verändert.',
    'ERROR_FULLY_EXPIRED' => "Die Lizenz Ihrer SugarCRM-Installation ist seit über 7 Tagen abgelaufen und muss aktualisiert werden. Nur Administratoren können sich anmelden.",
    'ERROR_LICENSE_EXPIRED' => "Die Lizenz Ihrer SugarCRM-Installation muss aktualisiert werden. Nur Administratoren können sich anmelden.",
    'WARN_LICENSE_EXPIRED' => "Achtung: Ihr Lizenzschlüssel läuft bald ab",
    'ERROR_LICENSE_VALIDATION' => "Ihre Lizenz für SugarCRM muss validiert werden. Nur Administratoren können sich anmelden.",
    'WARN_LICENSE_VALIDATION' => "Ihre SugarCRM-Lizenzen müssen bald neu validiert werden.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>Warnung:</b>Der Kompatibilitätsmodus von Internet Explorer wird nicht unterstützt.',
    'WARN_LICENSE_SEATS' => 'Warnung: Die maximale Anzahl an aktiven Benutzern hat bereits das Lizenzlimit erreicht.',
    'WARN_LICENSE_SEATS_MAXED' => 'Warnung: Die Anzahl der aktiven Benutzern hat die maximal erlaubte Anzahl überschritten.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'Die Anzahl der aktiven Benutzer überschreitet die Höchstgrenze der Anzahl von Lizenzen. Bitte kontaktieren Sie Ihren Administrator.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'Nur Administratoren dürfen sich anmelden.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'Die Höchstgrenze der Anzahl von Benutzerlizenzen wurde erreicht. Es können sich nur vorhandene Benutzer anmelden.',
    'WARN_ONLY_ADMINS' => 'Nur Administratoren dürfen sich anmelden.',
    'WARN_UNSAVED_CHANGES' => 'Sie sind dabei, diesen Eintrag zu verlassen, ohne die vorgenommenen Änderungen zu speichern. Sind Sie sicher, dass Sie das tun möchten?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Wenn Sie den Browser aktualisieren, werden automatisch alle offenen SugarLive-Anruf- oder Chat-Sitzungen geschlossen und alle nicht gespeicherten Änderungen gehen verloren. Möchten Sie fortfahren?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'Die Änderungen wurden nicht gespeichert. Möchten Sie die Seite verlassen, ohne diese zu speichern?',
    'LBL_MFA_RESET_CONFIRMATION' => 'Möchten Sie wirklich Ihre <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">Multi-Faktor-Authentifizierung</a> zurücksetzen? 
Dadurch werden Sie sofort abgemeldet und müssen sich erneut mit der Authentifizierungsapp authentifizieren, wenn Sie sich das nächste Mal anmelden.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'Bestätigen und abmelden',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'In einem oder mehreren Dashlets wurden Änderungen vorgenommen, die nicht gespeichert wurden. Möchten Sie die Fach wirklich schließen?',
    'LBL_NAVIGATE_TO_REPORTS' => 'Sie navigieren zum Berichtemodul. Ihre Änderungen im Dashlet werden nicht gespeichert. Möchten Sie fortfahren?',
    'ERROR_NO_RECORD' => 'Fehler beim Anzeigen des Datensatzes. Dieser Datensatz wurde entweder gelöscht oder Sie sind nicht dazu berechtigt, diesen anzuzeigen.',
    'ERROR_TYPE_NOT_VALID' => 'Fehler. Dieser Typ is nicht gültig.',
    'ERROR_MAX_FIELD_LENGTH' => 'Error. Die maximale Länge des Feldes ist {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'Error. Die minimale Länge des Feldes ist {{this}}.',
    'ERROR_EMAIL' => 'Error. Ungülige E-Mail-Adresse: {{#each this}}{{{this}}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'Fehler: Mindestens eine primäre Adresse muss eingegeben werden.',
    'ERROR_DUPLICATE_EMAIL' => 'Fehler: E-Mail-Adresse dupliziert: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'Error. Dieses Feld ist ein Pfilichtfeld.',
    'ERROR_MINVALUE' => 'Error. Der Mindestwert des Feldes ist {{this}}.',
    'ERROR_MAXVALUE' => 'Error. Der Höchstwert des Feldes ist {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'Fehler. Der Wert in diesem Feld muss größer als {{this}} sein.',
    'ERROR_IS_LESS_THAN' => 'Fehler. Der Wert in diesem Feld muss kleiner als {{this}} sein.',
    'ERROR_DATETIME' => 'Error. Dieses Feld benötigt ein gültiges Datum.',
    'ERROR_IS_BEFORE' => 'Fehler. Das Datum in diesem Feld kann nicht nach dem Datum im Feld {{this}} sein.',
    'ERROR_IS_AFTER' => 'Fehler. Das Datum in diesem Feld kann nicht vor dem Datum im Feld {{this}} sein.',
    'ERROR_TIME_IS_BEFORE' => 'Fehler. Die Zeitangabe in diesem Feld kann nicht nach der Zeitangabe im Feld {{this}} sein.',
    'ERROR_TIME_IS_AFTER' => 'Fehler. Die Zeitangabe in diesem Feld kann nicht vor der Zeitangabe im Feld {{this}} sein.',
    'ERROR_NUMBER' => 'Fehler: Dieses Feld benötigt einen gültigen Wert.',
    'ERROR_INT' => 'Fehler. Ungültige Ganzzahl',
    'ERROR_URL' => 'Fehler wegen ungültiger URL.',
    'ERROR_NO_BEAN' => 'Bean nicht gefunden.',
    'ERROR_ACCESS_MODULE' => 'Sie haben keine Zugriffsberechtigung für dieses Modul.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'Fehler. Der Anhang ist zu groß.',
    'ERROR_UPLOAD_FAILED' => 'Fehler. Die Datei konnte nicht hochgeladen werden.',
    'ERROR_UPLOAD_ACCESS_PD' => 'Sie sind nicht berechtigt, [Prozessdefinitionen] für dieses Modul zu erstellen.',
    'ERROR_UPLOAD_ACCESS_BR' => 'Sie sind nicht berechtigt, [Geschäftsregeln] für dieses Modul zu erstellen.',
    'ERROR_UPLOAD_ACCESS_ET' => 'Sie sind nicht berechtigt, [E-Mailvorlagen] für dieses Modul zu erstellen.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'Fehler. Sie haben einen nicht unterstützten Operator eingegeben.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'Fehler. Sie haben einen ungültigen Operator eingegeben.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'Fehler. Sie haben einen ungültigen Filter eingegeben.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'Import fehlgeschlagen. Ein Gruppenfeld ist in der Prozessdefinition teilweise gesperrt.' .
        ' Diese Felder müssen in der Prozessdefinition entsperrt werden, damit die Definition importiert werden kann.',
    'ERROR_EXP_DATE_LOW' => 'Fehler. Ablaufdatum kann nicht vor dem Zeitpunkt der Veröffentlichung sein.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'Fehler. Der Genehmigungsstatus erfordert ein Veröffentlichungsdatum.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'Das Veröffentlichungsdatum ist leer.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'Duplikate finden',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'Duplikateprüfung für {{module}} ist deaktiviert.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'Abonnements verwalten',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Abonnements verwalten für',
    'LBL_SUBSCRIBE' => 'Anmelden',
    'LBL_UNSUBSCRIBE' => 'Abmelden',
    'LBL_CREATE_LINK_RECORD' => 'Eintrag erfassen und verlinken',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'Eintrag erfassen und verlinken',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} Datensätze wurden verknüpft.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'Keine Datensätze zu verknüpfen.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'Der ausgewählte Bericht basiert nicht auf dem korrekten Modultyp.',
    'ERROR_EMPTY_LINK_MODULE' => 'Bitte zuerst das Verhältnis auswählen.',
    // Ajax status strings
    'LBL_LOADING' => 'Die Benutzeroberfläche wird geladen...',
    'LBL_LOADING_NO_DOTS' => 'Laden. Bitte warten...',
    'LBL_SEARCHING' => 'Suche...',
    'LBL_SEARCH_UNDERWAY' => 'Suche läuft',
    'LBL_SAVING_LAYOUT' => 'Layout wird gespeichert...',
    'LBL_SAVED_LAYOUT' => 'Layout wurde gespeichert.',
    'LBL_SAVED' => 'Gespeichert.',
    'LBL_SAVING' => 'Speichern',
    'LBL_FAILED' => 'Fehlgeschlagen!',
    'LBL_DISPLAY_COLUMNS' => 'Spalten anzeigen',
    'LBL_HIDE_COLUMNS' => 'Spalten ausblenden',
    'LBL_SEARCH_CRITERIA' => 'Suchkriterien',
    'LBL_SAVED_VIEWS' => 'Gespeicherte Ansichten',
    'LBL_PROCESSING_REQUEST' => 'Verarbeitung...',
    'LBL_REQUEST_PROCESSED' => 'Fertig',
    'LBL_AJAX_FAILURE' => 'Ajax-Fehler',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'Suche ...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Gespeicherte Suchen',
    'LBL_SEARCH_POPULATE_ONLY' => 'Mit dem obigen Suchformular suchen',
    'LBL_SEARCH_NO_RESULTS' => 'Keine Suchergebnisse für ',
    'LBL_SEARCH_FOR' => 'Suche nach',
    'LBL_SEARCH_FOR_MORE' => 'Nach mehr suchen...',
    'LBL_SEARCH_SELECT' => 'Auswählen...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'Suchen und wählen Sie...',
    'LBL_SEARCH_SELECT_MODULE' => 'Wählen Sie eine {{module}}...',
    'LBL_DETAILVIEW' => 'Detailansicht',
    'LBL_LISTVIEW' => 'Listenansicht',
    'LBL_EDITVIEW' => 'Bearbeitungsansicht',
    'LBL_SEARCHFORM' => 'Suchformular',
    'LBL_SAVED_SEARCH_ERROR' => 'Bitte geben Sie einen Namen für diese Ansicht ein.',
    'LBL_DISPLAY_LOG' => 'Protokoll anzeigen',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Ort:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Beschreibung:',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'wird gestartet',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'OK auswählen, um diesen Anruf anzuzeigen, oder "Abbrechen".',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'OK auswählen, um dieses Meeting anzuzeigen, oder "Abbrechen".',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'Keine Ergebnisse gefunden.',
    'MSG_LIST_VIEW_NO_RESULTS' => 'Keine Ergebnisse gefunden für <item1>',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => '<item1> als <item2> neu erstellen',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'Sie haben derzeit keine Datensätze <item1> gespeichert. <item2> oder <item3> Sie jetzt einen neuen Datensatz.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'Sie haben momentan keine Datensätze <item1> gespeichert. <item2> Sie jetzt einen neuen Datensatz.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'Sie können <item1> aus einer Liste <item2>. <item3> <item2> erstellen.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'Positiv',
    'LBL_SENTIMENT_NEUTRAL' => 'Neutral',
    'LBL_SENTIMENT_NEGATIVE' => 'Negativ',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'Keine Metrik-Registerkarten konfiguriert',
    'LBL_NO_METRIC_VISIBLE' => 'Keine metrischen Registerkarten sichtbar',
    'LBL_MAKE_METRIC_VISIBLE' => 'Wählen Sie "Organisieren", um metrische Registerkarten sichtbar zu machen',
    'LBL_PLEASE_CONTACT_ADMIN' => 'Bitte kontaktieren Sie Ihren Administrator',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'Hier klicken',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Zu Favoriten hinzufügen',
    'LBL_MARK_AS_FAVORITES' => 'Als Favorit markieren',
    'LBL_CREATE_CONTACT' => 'Neuer Kontakt',
    'LBL_CREATE_NOTE' => 'Neue Notiz',
    'LBL_CREATE_OPPORTUNITY' => 'Neue Verkaufschance',
    'LBL_SCHEDULE_CALL' => 'Neuer Anruf',
    'LBL_SCHEDULE_CALL2' => 'Anruf',
    'LBL_SCHEDULE_MEETING' => 'Neues Meeting',
    'LBL_SCHEDULE_MEETING2' => 'Meeting',
    'LBL_CREATE_MESSAGE' => 'Nachricht erstellen',
    'LBL_CREATE_MESSAGE2' => 'Nachricht',
    'LBL_CREATE_TASK' => 'Neue Aufgabe',
    'LBL_CREATE_TASK2' => 'Aufgabe',
    'LBL_REMOVE_FROM_FAVORITES' => 'Aus Favoriten entfernen',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'Notiz',
    'LBL_DOWNLOAD_ALL' => 'Alle herunterladen',
    'LBL_DOWNLOAD_ONE' => 'Herunterladen',
    'LBL_ATTACHMENTS' => 'Anhänge',
    'LBL_ADD_ATTACHMENT' => 'Durchsuchen',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Formular erstellen',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Web-2-Lead-Formular speichern',

    'LBL_PLEASE_SELECT' => 'Bitte auswählen',
    'LBL_REDIRECT_URL' => 'Weiterleitungs-URL',
    'LBL_RELATED_CAMPAIGN' => 'Verknüpfte Kampagne',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Alle Felder hinzufügen',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Alle Felder entfernen',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Nur Bilder können eingefügt werden',
    'LBL_REMOVE' => 'Entfernen',
    'LBL_TRAINING' => 'Training',
    'ERR_DATABASE_CONN_DROPPED' => 'Fehler bei der Abfrageausführung. Möglicherweise wurde die Verbindung zur Datenbank unterbrochen. Bitte die Seite erneut aufrufen; möglicherweise muss der Webserver neu gestartet werden.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'Fehler bei Einstellung {0} der Beziehung: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'Datenbank-Kontext geändert auf',
    'ERR_MSSQL_WARNING' => 'Warnung:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'vCard-Format konnte nicht gelesen werden.',
    'ERR_VCARD_FILE_MISSING' => 'vcf-Datei fehlt',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Warnung: Feld [[field]] hat keinen Eintrag in der Datei [moduleDir] vardefs.php',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Fehler: Datei [[file]] fehlt. Erstellung gescheitert, da keine entsprechende HTML-Datei gefunden wurde.',
    'ERR_CANNOT_FIND_MODULE' => 'Fehler: Modul [module] existiert nicht.',
    'LBL_ALT_ADDRESS' => 'Alternative Adresse:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Fehler: Es gibt eine ungleiche Anzahl der Elemente &#39;key&#39; and &#39;copy&#39; im Array "displayParams".',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Fehlender Index in Array "displayParams": ',

    'LBL_DASHLET' => 'Dashlet',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filter',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Nur meine Einträge',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Name',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Zeilen anzeigen',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'Abhängig vom angezeigten Datensatz',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'Verknüpftes Feld',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'Erste Spalte einfrieren',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'Möchten Sie dieses Sugar-Dashlet wirklich löschen?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'Möchten Sie die Zeile wirklich entfernen?',
    'LBL_MAXIMUM_OF' => 'Maximal',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => 'Spalten können angezeigt werden.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'Dashboard',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'Mein Dashboard',
    'LBL_COLLAPSE_ALL' => 'Alle verstecken',
    'LBL_EXPAND_ALL' => 'Alle erweitern',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'Bearbeiten',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'Bericht anzeigen',
    'LBL_DASHLET_REFRESH_LABEL' => 'Aktualisieren',
    'LBL_DASHLET_REMOVE_LABEL' => 'Entfernen',
    'LBL_DASHLET_DROP_HERE' => 'Hier hinziehen',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'Minimieren',
    'LBL_DASHLET_MAXIMIZE' => 'Maximieren',
    'LBL_DASHLET_CONFIGURE' => 'Anpassen',
    'LBL_DASHLET_TOGGLE' => 'Öffnen/Schließen',
    'LBL_SIDEPANE_TOGGLE' => 'Seitenbereich öffnen/schließen',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'Standard-Dashlets wiederherstellen',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'Kein Dashboard konfiguriert',
    'LBL_CREATE_DASHBOARD_LINK' => 'Dashboard erstellen',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'Hilfe',
    'LBL_HELPLET_TOGGLE' => 'Öffnen/Schließen',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'Module',
    'LBL_FACET_MODIFIED_BY_ME' => 'Durch mich verändert',
    'LBL_FACET_CREATED_BY_ME' => 'Erstellt von mir',
    'LBL_FACET_MY_FAVORITES' => 'Meine Favoriten',
    'LBL_FACET_ASSIGNED_TO_ME' => 'Mir zugewiesen',
    'LBL_FACET_NO_DATA' => 'Keine Daten für diese Facette.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'Meine Listenansicht',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'Datensätze des angemeldeten Benutzers.',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'Listenansicht der Konsole',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'Listet Datensätze eines bestimmten Moduls auf, die sich auf den Datensatz beziehen, den Sie in der Konsole anzeigen.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'Datensatzansicht',
    'LBL_RELATED_RECORDS' => 'Verknüpftes {{{module}}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'Zeigt einen Datensatz und optional zugehörige Datensätze in Registerkarten an.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'Basisdatensatztyp',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'Dieser {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'Registerkarten',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'Grundlegende Layout-Vorschau',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'Achtung, nur {{numWord}} ({{num}}) Module können in Registerkarten angezeigt werden. ' .
        'Bitte entfernen Sie ein oder mehrere Module, bevor Sie weitere hinzufügen.',
    'LBL_SIX' => 'sechs', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'Kommentarprotokoll',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'Zeigt Kommentare zu einem Datensatz an',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'Keine Kommentare gefunden',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'Hinzufügen',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'Kommentar hinzufügen',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'Alle anzeigen',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'Keine Daten verfügbar. Sie haben keine Berechtigung für den Zugriff auf diese Module.' .
    " \nBitte aktualisieren oder entfernen Sie dieses Dashlet.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'Meine {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'Kein Datensatz zum Anzeigen ausgewählt',
    'LBL_CONTENT_SEARCH_DASHLET' => 'Dashlet zur Suche nach Inhalten',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'Womit können wir Ihnen heute helfen, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'Möchten Sie ein Ticket erstellen?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'Verkaufschancen im Überblick',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'Verkaufschancen-Metrik für verknüpfte Firmen.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'Produktkatalog Schnellauswahl',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'Listen Zuletzt verwendete Elemente und Produkte, die als Favoriten gespeichert wurden',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'Zuletzt verwendet',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'Favoriten',

    'LBL_DASHBOARD_CREATE' => 'Neues Dashboard',
    'LBL_DASHBOARD_DUPLICATE' => 'Dashboard duplizieren',
    'LBL_DASHBOARD_DELETE' => 'Dashboard löschen',
    'LBL_PIN_TO_TOP' => 'Oben anheften',
    'LBL_PIN_TO_BOTTOM' => 'Unten anheften',
    'LBL_MANAGE_DASHBOARDS' => 'Dashboards verwalten',

    'LBL_DASHBOARD_CONFIG' => 'Dashboard-Konfiguration',
    'LBL_LIST_VIEW__NAME' => 'Listenansicht',
    'LBL_PIPELINE_VIEW_NAME' => 'Kachelansicht',
    'LBL_PIPELINE_VIEW_BTN' => 'Kachelansicht',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} nach {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'Die Kachelansicht ist nicht aktiviert',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'Keine Datensätze gefunden.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'Ticket-Übersicht',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'Zeitleiste',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'Notizen & Anlagen',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'Notizen und Anhänge gehören zu diesem Datensatz',
    'LBL_DASHLET_PIPLINE_NAME' => 'Pipeline',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'Neueste Tweets - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'Keine gespeicherten Dashboards.',

    'LBL_DNB_AND' => 'und',
    'LBL_DNB_PRIM_NAME_DESC' => 'Name der Organisation/Firma',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'Antworten [Alt+R]',
    'LBL_TWITTER_RETWEET' => 'Retweet',
    'LBL_TWITTER_FAVORITE' => 'Favorit',
    'LBL_TWITTER_FOLLOW' => 'Folgen',
    'LBL_TWITTER_DESCRIPTION' => 'Zeigt mit dem Benutzer übereinstimmende Tweets, Retweets und Antworten',
    'LBL_TWITTER_ID' => 'Twitter-Konto',
    'LBL_TWITTER_DISPLAY_ROWS' => 'Zeilen anzeigen',
    'LBL_TWITTER_MY_ACCOUNT' => 'Mein Konto',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Original-Tweet:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'Trainingsmaterialien',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'Schulung und Zertifizierung',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub-Community',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'Dokumentation und Support',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters Marktplatz',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'Umsatz nach Land',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'Zeigt das Umsatzdiagramm mit Landkarte an.',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'Wissensdatenbank-Kategorien & veröffentlichte Artikel',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'Suche in der Wissensdatenbank',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'Zeigt eine durchsuchbare Baumansicht veröffentlichter Artikel und Kategorien der Wissensdatenbank an.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'Veröffentlichte Artikel in anderen Sprachen',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'Die hilfsreichsten veröffentlichten Wissensdatenbank-Artikel',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'Zeigt die beliebtesten und am häufigsten gelesenen Artikel der Wissensdatenbank an',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}}, gefiltert nach {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'Nützlichkeit für Artikel',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'Seite hinzufügen',
    'LBL_LOADING_PAGE' => 'Seite wird geladen, bitte warten...',
    'LBL_SEARCH_RESULTS' => 'Suchergebnisse',
    'LBL_SEARCH_RESULTS_FOR' => 'Suchergebnisse für: ',
    'LBL_SEARCH_HELP_TITLE' => 'Arbeiten mit Mehrfachauswahlen und gespeicherten Suchen',
    'LBL_SEARCH_RESULTS_FOUND' => 'Suchergebnisse gefunden',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'Meine Pipeline',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "Meine Team-Pipeline",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'Verkaufs-Pipeline-Diagramm',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'Zeigt das aktuelle Pipeline-Diagramm an.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'Kein Bild',

    'LBL_MODULE' => 'Modul',
    'LBL_RELATIONSHIP' => 'Beziehung',
    'LBL_SINGULAR_LABEL' => 'Singular-Bezeichnung',
    'LBL_PLURAL_LABEL' => 'Plural-Bezeichnung',
    'LBL_MODULE_DISPLAY' => 'Anzeige',
    'LBL_MODULE_DISPLAY_TYPE' => 'Anzeigetyp',
    'LBL_MODULE_ICON' => 'Symbol',
    'LBL_MODULE_COLOR' => 'Hintergrundfarbe Modul',
    'LBL_LANGUAGE_SELECTOR' => 'Sprache',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'Moduleinstellungen',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'Moduleinstellungen wurden gespeichert.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Adresse von links kopieren:',
    'LBL_SAVE_AND_CONTINUE' => 'Speichern und weiter',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Steuerungen zur Mehrfachauswahl</p><ul><li>Klicken Sie auf die Werte, um ein Attribut auszuwählen.</li><li>STRG-Klick um mehrere auszuwählen. Mac-Benutzer verwenden CMD-Klick.</li><li>Um alle Werte zwischen zwei Attributen auszuwählen, klicken Sie zuerst auf den ersten Wert und dann mit UMSCH-Klick auf den zweiten.</li></ul><p><strong>Erweiterte Suche und Layout-Optionen</strong><br><br>Wenn Sie die Option <b>Gespeicherte Suche & Layout</b> verwenden, können Sie eine vordefinierte Suche bzw. eine angepasste Listenansicht speichern, um später schnell zu den gewünschten Ergebnissen zu kommen. Sie können eine unbegrenzte Anzahl solcher Auswahlen speichern. Alle gespeicherten Auswahlen scheinen in der Liste &#39;Gespeicherte Suche&#39; mit Namen auf, wobei die aktuell geladene Suche am Anfang steht.<br><br>Um die Listenansicht anzupassen, verwenden Sie die Option &#39;Spalten anzeigen&#39; bzw. &#39;Spalten verstecken&#39;. Sie können zum Beispiel Angaben wie Teams, zugewiesene Benutzer oder Datensatzname ausblenden oder anzeigen. Um eine Spalte zur Listenansicht hinzuzufügen, wählen Sie das Feld aus der Liste der ausgeblendeten Spalten und ziehen es mit der linken Pfeiltaste in die Spalte der angezeigten Begriffe. Um eine Spalte aus der Listenansicht zu entfernen, gehen Sie umgekehrt vor.<br><br>Wenn Sie die Layout-Einstellungen speichern, können Sie Ihre Suchergebnisse später immer in diesem Layout ausgeben.<br><br>Um eine Suche bzw. ein Layout zu speichern:<ol><li>Geben Sie einen Namen für das Suchresultat unter <b>Suche speichern unter</b> ein und klicken Sie auf <b>Speichern</b>. Der Name wird nun in der Liste "Gespeicherte Suche" angezeigt, direkt neben der  Schaltfläche <b>Leeren</b>.</li><li>Um eine gespeicherte Suche aufzurufen, wählen Sie diese in der Liste aus. Die Suchergebnisse werden in der Listenansicht dargestellt.</li><li>Um eine gespeicherte Suche zu ändern, wählen Sie die Suche in der Liste aus, ändern die entsprechenden Such- und/oder Darstellungsparameter und klicken Sie auf <b>Aktualisieren</b> neben <b>Aktuelle Suche ändern</b>.</li><li>Um eine gespeicherte Suche zu löschen, wählen Sie die Suche aus der Liste aus, klicken <b>Löschen</b> neben <b>Aktuelle Suche ändern</b>, und klicken dann auf <b>OK</b>, um das Löschen zu bestätigen.</li></ol>',

    //resource management
    'ERR_QUERY_LIMIT' => 'Fehler: Abfragelimit von $limit erreicht für Modul $module.',
    'ERROR_NOTIFY_OVERRIDE' => 'Fehler: ResourceObserver->notify() muss überschrieben werden.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'Fehler: kann Monitor nicht erstellen, da die Metadaten-Datei leer ist oder nicht existiert.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'Fehler: Kein Monitor für den angefragten Namen konfiguriert',
    'ERR_UNDEFINED_METRIC' => 'Fehler: Kann keinen Wert für undefinierte Metrik setzen',
    'ERR_STORE_FILE_MISSING' => 'Fehler: Kann die Store-Implementation-Datei nicht finden',

    'LBL_MONITOR_ID' => 'Monitor-ID',
    'LBL_TEAM_ID' => 'Team-ID',
    'LBL_SELECT_MODULE' => 'Ein Modul auswählen:',
    'LBL_USER_ID' => 'Benutzer-ID',
    'LBL_MODULE_NAME' => 'Modulname',
    'LBL_MODULE_ALL' => 'Alle',
    'LBL_ITEM_ID' => 'Element-ID',
    'LBL_ITEM_SUMMARY' => 'Element-Zusammenfassung',
    'LBL_ACTION' => 'Aktion',
    'LBL_SESSION_ID' => 'Sitzungs-ID',
    'LBL_BREADCRUMBSTACK_CREATED' => 'BreadcrumbStack für Benutzer-ID {0} erstellt',
    'LBL_VISIBLE' => 'Datensätze sichtbar',
    'LBL_DATE_LAST_ACTION' => 'Datum der letzten Aktion',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL-Text',
    'LBL_QUERY_HASH' => 'SQL-Hash',
    'LBL_SEC_TOTAL' => 'Sekunden insgesamt',
    'LBL_SEC_AVG' => 'Sekunden durchschnittlich',
    'LBL_RUN_COUNT' => 'Abfrage-Anzahl',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'Client IP-Adresse',
    'LBL_DATE_START' => 'Startdatum',
    'LBL_ACTIVE' => 'Sitzung aktiv',
    'LBL_ROUNDTRIPS' => 'Anzahl der Aktionen',
    'LBL_SECONDS' => 'Sekunden aktiv',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'Datenbank-Roundtrips',
    'LBL_FILES_OPENED' => 'Dateizugriffe',
    'LBL_MEMORY_USAGE' => 'Speicherauslastung (Bytes)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'Lade Twitter-Connector ...',
    'LBL_TWITTER_DATA_EMPTY' => 'Keine Twitter-Daten verfügbar',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Sugar-Plug-In für Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Integrieren Sie Sugar-E-Mail- und Kalenderdaten mit Microsoft Outlook.',
    'LBL_PLUGIN_WORD_NAME' => 'Sugar Plug-In für Word',
    'LBL_PLUGIN_WORD_DESC' => 'Füllen Sie Briefe, E-Mails- und andere Microsoft-Dokumente mit Informationen aus Sugar.',
    'LBL_PLUGIN_EXCEL_NAME' => 'Sugar-Plug-In für Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'SugarCRM mit Tabellenkalkulationssysteme verbunden für bessere Auswertungen',
    'LBL_PLUGINS_TITLE' => 'Sugar-Plug-Ins for Microsoft Office<sup>TM</sup>',
    'LBL_PLUGINS_DESC' => 'Lesen Sie mehr über Plug-Ins in der <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">Plug-Ins-Dokumentation</a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Sugar-Plug-Ins für Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'Sugar Plug-In für Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'Sugar mit Lotus Notes integrieren.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'ist nicht bevor',
    'MSG_IS_MORE_THAN' => 'ist größer als',
    'MSG_IS_LESS_THAN' => 'is kleiner als',
    'MSG_SHOULD_BE' => 'sollte sein',
    'MSG_OR_GREATER' => 'oder größer',
    'MSG_EXCEEDS_MAXLEN' => 'überschreitet die angegebene Maximallänge ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Willkommen beim Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Das Sugar Portal bietet eine Echtzeit-Übersicht auf Support-Tickets, Bugs und Newsletters etc. für Kunden. Es ist eine Schnittstelle nach außen, die in jede Webseitze eingebunden werden kann. Sehen Sie weitere Kunden-Selbstbedienungsfunktionen, z.B. im Projektmanagement und für Forums in unseren kommenden Releases.',
    'LBL_LIST' => 'Liste',
    'LBL_CREATE_CASE' => 'Neues Tickets',
    'LBL_CREATE_BUG' => 'Neuer Fehler',
    'LBL_NO_RECORDS_FOUND' => '- 0 Einträge gefunden -',

    'DATA_TYPE_DUE' => 'Fällig:',
    'DATA_TYPE_START' => 'Start:',
    'DATA_TYPE_SENT' => 'Gesendet:',
    'DATA_TYPE_MODIFIED' => 'Verändert:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Zähler',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'Objekt-Bild',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'Datum auswählen',

    'LBL_VALIDATE_RANGE' => 'ist nicht innerhalb des gültigen Bereichs',
    'LBL_VALIDATE_URL' => 'ist keine gültige URL',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'Alle',

    'LBL_OPERATOR_IN_TEXT' => 'ist einer der folgenden:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'ist keiner der folgenden:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Fehler: Die Anzahl der Bean-Parameter im Array ist nicht gleich der Anzahl im Resultat.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Fehler: Fehlender Zuordnungseintrag für Modul',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Fehler: Kann keine Daten für Konnector {0} finden. Möglicherweise ist der Dienst derzeit nicht zugänglich oder falsch konfiguriert. Fehlermeldung: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'Daten können nicht abgerufen werden. Möglicherweise ist der Service gerade nicht verfügbar oder die Einstellungen sind nicht korrekt.',
    'LBL_CONNECT_TWITTER' => 'Verbinden mit Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'Kann keine valide Zeitspanne für Twitter-ID finden',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'Twitter-Konnektor konfigurieren',
    'LBL_CONNECT_TEST_FAIL' => 'Fehler: Die Konfiguration des Connektors ist nicht gültig. Bitte kontaktieren Sie einen Administrator.',
    'LBL_CONFIGURE_TWITTER' => 'Kontaktieren Sie ihren Administrator für die Twitter-Konfiguration',
    'LBL_MERGE_CONNECTORS' => 'Daten laden',
    'LBL_NO_DATA_AVAILABLE' => 'Keine Daten gefunden.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'Sind Sie sicher, dass Sie die Konnektor-Integration für dieses Modul deaktivieren möchten?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Es konnte keine Verbindung zum Elastic Server hergestellt werden.',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'Das globale Team kann nicht gelöscht werden.',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'Dieses privates Team [{0}] kann erst dann gelöscht werden, wenn Benutzer [{1}] entfernt wurde.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'Hallo, Sie haben entweder Flash ausgeschaltet oder eine alte Version des Adobe Flash Players. Bitte gehen Sie auf <a href="http://www.adobe.com/go/getflashplayer/">, um die letzte Version des Flash Players zu installieren</a> oder schalten Sie Flash in Ihrem Browser ein.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'Name',
    'LBL_COLLECTION_PRIMARY' => 'Primär',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'Leeres Pflichtfeld',
    'LBL_COLLECTION_EXACT' => 'Exakt',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'Für optimale Leistung oder Ergebnisse mit IIS/FastCGI sapi sollte fastcgi.logging in der php.ini auf 0 gesetzt sein.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'Zugewiesen an',
    'LBL_DESCRIPTION' => 'Beschreibung',
    'LBL_PRIMARY_CONTACT_NAME' => 'Hauptansprechpartner',
    'LBL_PRIMARY_CONTACT_ID' => 'Hauptansprechpartner ID',

    'LBL_NONE' => '--kein(e)--',
    'LBL_YESTERDAY' => 'gestern',
    'LBL_TODAY' => 'Heute',
    'LBL_TOMORROW' => 'Morgen',
    'LBL_NEXT_WEEK' => 'Nächste Woche',
    'LBL_NEXT_MONDAY' => 'Nächsten Montag',
    'LBL_NEXT_FRIDAY' => 'Nächsten Freitag',
    'LBL_TWO_WEEKS' => 'zwei Wochen',
    'LBL_NEXT_MONTH' => 'Nächster Monat',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'Erster Tag des nächsten Monats',
    'LBL_THREE_MONTHS' => 'Drei Monate',
    'LBL_SIXMONTHS' => 'Sechs Monate',
    'LBL_NEXT_YEAR' => 'nächstes Jahr',
    'LBL_FILTERED' => 'Gefiltert',

    //Datetimecombo fields
    'LBL_HOURS' => 'Stunden',
    'LBL_MINUTES' => 'Minuten',
    'LBL_MERIDIEM' => 'Meridiem',
    'LBL_DATE' => 'Datum',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Automatisch aktualisieren',

    'LBL_DURATION_DAY' => 'Tag',
    'LBL_DURATION_HOUR' => 'Stunde',
    'LBL_DURATION_MINUTE' => 'Minute',
    'LBL_DURATION_DAYS' => 'Tage',
    'LBL_DURATION_HOURS' => 'Stunden',
    'LBL_DURATION_MINUTES' => 'Minuten',
    'LBL_DURATION_SECONDS' => 'Sekunden',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'Monat auswählen',
    'LBL_ENTER_YEAR' => 'Jahr eingeben',
    'LBL_ENTER_VALID_YEAR' => 'Bitte geben Sie ein gültiges Jahr ein',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'Bitte geben Sie eine gültige US-Telefonnummer inklusive der Vorwahl ein.',
    'LBL_CCP_NOT_INITIATED' => 'Wahlversuch mithilfe von CCP, während Agent nicht angemeldet ist.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'Anruf kann nicht über CCP gestartet werden.',
    'LBL_CCP_DIALING_ERROR' => 'Dieser Anruf kann nicht als gewählt abgeschlossen werden.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'Bitte schließen Sie alle Chat-Sitzungen in SugarLive, bevor Sie einen ausgehenden Anruf tätigen.',

    //File write error label
    'ERR_FILE_WRITE' => 'Fehler: Datei konnte nicht erstellt werden {0}.  Bitte das System und die Rechte des Webservers überprüfen.',
    'ERR_FILE_NOT_FOUND' => 'Fehler: Datei konnte nicht geladen werden {0}.  Bitte das System und die Rechte des Webservers überprüfen.',

    'LBL_AND' => 'und',
    'LBL_BEFORE' => 'vor',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'Vom Computer hochladen',
    'LBL_SEARCH_EXTERNAL_API' => 'Datei liegt auf externer Quelle',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'In externe Quelle hochladen',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'Link von externer Quelle',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'Sicherheit',
    'LBL_SHARE_PRIVATE' => 'Privat',
    'LBL_SHARE_COMPANY' => 'Firma',
    'LBL_SHARE_LINKABLE' => 'Verlinkbar',
    'LBL_SHARE_PUBLIC' => 'Öffentlich',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS-Feed',
    'LBL_RSS_RECORDS_FOUND' => 'Datensatz / Datensätze gefunden',
    'ERR_RSS_INVALID_INPUT' => 'RSS ist kein gültiger Eingabetyp',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS ist keinen gültigen Antworttyp für diese Methode',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs unterstützt dieses Dateiformat nicht.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'Leer',
    'LBL_IS_EMPTY' => 'Ist leer',
    'LBL_IS_NOT_EMPTY' => 'Ist nicht leer',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '
"This is a sample import file which provides an example of the expected contents of a file that is ready for import."
 "The file is a comma-delimited .csv file, using double-quotes as the field qualifier."

 "The header row is the top-most row in the file and contains the field labels as you would see them in the application."
 "These labels are used for mapping the data in the file to the fields in the application."

 "Notes: The database names could also be used in the header row. This is useful when you are using phpMyAdmin or another database tool to provide an exported list of data to import."
 "The column order is not critical as the import process matches the data to the appropriate fields based on the header row."


 "To use this file as a template, do the following:"
 "1. Remove the sample rows of data"
 "2. Remove the help text that you are reading right now"
 "3. Input your own data into the appropriate rows and columns"
 "4. Save the file to a known location on your system"
 "5. Click on the Import option from the Actions menu in the application and choose the file to upload"',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'Zugewiesene Benutzer-ID',
    'LBL_EXPORT_CREATED_BY' => 'Ersteller',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'Geändert von ID',
    'LBL_EXPORT_REPORTS_TO_ID' => 'Berichtet an:',
    'LBL_EXPORT_TEAM_ID' => 'Team-ID',
    'LBL_EXPORT_TEAM_SET_ID' => 'Team-Set-ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Zugew. Benutzer',
    'LBL_EXPORT_FULL_NAME' => 'Vollständiger Name',
    'LBL_EXPORT_TEAM_NAME' => 'Teams',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navigieren....',

    'LBL_PENDING_NOTIFICATIONS' => 'Benachrichtigungen',
    'LBL_ALT_ADD_TEAM_ROW' => 'Neue Teamzeile hinzugüfen',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'Team entfernen',
    'LBL_ALT_SPOT_SEARCH' => 'Geben Sie Ihren Suchbegriff bzw. einen Teil davon ein oder …klicken Sie auf das Suchen Icon um eine exakte Suche durchzuführen',
    'LBL_ALT_NOT_SORTED' => 'Nicht sortiert',
    'LBL_ALT_SORT_DESC' => 'Absteigend sortieren',
    'LBL_ALT_SORT_ASC' => 'Aufsteigend sortieren',
    'LBL_ALT_SORTABLE' => 'Sortierbar',
    'LBL_ALT_NOT_SORTABLE' => 'Nicht sortierbar',
    'LBL_ALT_SORT' => 'Sortieren',
    'LBL_ALT_SHOW_OPTIONS' => 'Optionen anzeigen',
    'LBL_ALT_HIDE_OPTIONS' => 'Optionen ausblenden',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'Ausgewählter Eintrag links verschieben',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Ausgewählter Eintrag rechts verschieben',
    'LBL_ALT_MOVE_COLUMN_UP' => 'Ausgewählter Eintrag nach oben verschieben',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'Ausgewählter Eintrag nach unten verschieben',
    'LBL_ALT_INFO' => 'Informationen',
    'MSG_DUPLICATE' => 'Der {0} Datensatz könnte ein Duplikatsatz vom einem Datensatz {0} sein. {1} Der Datensatz enthält einen ähnlichen Namen, wie unten aufgelistet.<br>Bitte erstellen Sie {1}, um den neuen Datensatz zu erstellen {0}, oder einen bestehenden Datensatz von unten {0} auswählen.',
    'MSG_SHOW_DUPLICATES' => 'Der {0}-Datensatz, den Sie gerade erstellen, könnte möglicherweise ein Duplikat eines {0}-Datensatzes sein, der bereits vorhanden ist. {1}-Einträge mit ähnlichen Namen sind unten aufgeführt. Klicken Sie auf "Speichern", um mit dem Erstellen dieser neuen {0} fortfahren, oder klicken Sie auf "Abbrechen", um zum Modul zurückzukehren, ohne die {0} zu erstellen.',
    'LBL_EMAIL_TITLE' => 'E-Mail-Adresse',
    'LBL_EMAIL_OPT_TITLE' => 'Keine E-Mail-Adresse angegeben',
    'LBL_EMAIL_INV_TITLE' => 'Ungültige E-Mail-Adresse',
    'LBL_EMAIL_PRIM_TITLE' => 'primäre E-Mail-Adresse',
    'LBL_SELECT_ALL_TITLE' => 'Alle auswählen',
    'LBL_SELECT_THIS_ROW_TITLE' => 'Diese Zeile auswählen',
    'LBL_TEAM_SELECTED_TITLE' => 'Team gewählt',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Primäres Team auswählen',
    'LBL_TEAM_TBSELECTED_TITLE' => 'Team markiert als Team-basierte Ausgewählte ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'Dieses Team als Team-basierte Ausgewählte markieren',
    'LBL_SEARCH_AND_SELECT' => 'Suchen und auswählen {{module}}',
    'TPL_SEARCH_AND_ADD' => 'Suchen und Hinzufügen von {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'Fehler: Es gab einen Fehler beim Upload. Fehlercode: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'Fehler: Es gab einen Fehler beim Upload. Fehlercode: {0} - {1}. upload_maxsize ist {2} ',
    'UPLOAD_ERROR_HOME_TEXT' => 'Fehler: Es gab einen Fehler beim Upload. Bitte den Systemadministrator kontaktieren.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'Maximale Upload-Größe überschritten: ({0} bytes). Erlaubtes Maximum: {1} bytes',
    'UPLOAD_REQUEST_ERROR' => 'Ein Fehler ist aufgetreten. Bitte aktualisieren Sie Ihre Seite und versuchen Sie es erneut.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'E',
    'LBL_EDIT_BUTTON_LABEL' => 'Bearbeiten',
    'LBL_ADD_BUTTON_LABEL' => 'Hinzufügen',
    'LBL_EDIT_BUTTON_TITLE' => 'Bearbeiten [Alt+E]',
    'LBL_REFRESH_BUTTON_LABEL' => 'Aktualisieren',
    'LBL_REFRESH_BUTTON_TITLE' => 'Aktualisieren',
    'LBL_DUPLICATE_BUTTON_KEY' => 'U',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Duplizieren',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Duplizieren [Alt+U]',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'Berichtzeitpläne',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'Berichtzeitpläne',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'Berichtsdetails',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'Berichtsdetails',
    'LBL_DELETE_BUTTON_KEY' => 'D',
    'LBL_DELETE_BUTTON_LABEL' => 'Löschen',
    'LBL_DELETE_BUTTON_TITLE' => 'Löschen [Alt+D]',
    'LBL_SAVE_BUTTON_KEY' => 'S',
    'LBL_SAVE_BUTTON_LABEL' => 'Speichern',
    'LBL_SAVE_BUTTON_TITLE' => 'Speichern [Alt+S]',
    'LBL_CANCEL_BUTTON_KEY' => 'X',
    'LBL_CANCEL_BUTTON_LABEL' => 'Abbrechen',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'um den Vorgang anzuhalten.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'um auf der Seite zu bleiben.',
    'LBL_CANCEL_BUTTON_TITLE' => 'Abbrechen [Alt+X]',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'Teilen',
    'LBL_SHARE_BUTTON_TITLE' => 'Teilen',
    'LBL_START_BUTTON_LABEL' => 'Start',
    'LBL_START_BUTTON_TITLE' => 'Start',
    'LBL_FINISH_BUTTON_LABEL' => 'Fertigstellen',
    'LBL_FINISH_BUTTON_TITLE' => 'Fertigstellen',
    'LBL_CONFIRM_BUTTON_LABEL' => 'OK',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'um fortzufahren.',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'Seite verlassen und Änderungen verwerfen.',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Tastenkombinationen',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Form Funktionalität - Alt+</strong><br/> I = ed<b>I</b>t (detailview)<br/> U = d<b>U</b>plikat (detailview)<br/> D = <b>D</b>elete (detailview)<br/> A = s<b>A</b>ve (editview)<br/> L = cance<b>L</b> (editview) <br/><br/></p><p><strong>Suche und Navigation - Alt+</strong><br/> 7 = erste Eingabe in Bearbeitungsformular<br/> 8 = Link für erweiterte Suche<br/> 9 = Erste Eingabe in Suchformular<br/> 0 = Gemeinsame Sucheingabe<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'Eskalieren',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'Teilen',
    'TPL_RECORD_SHARE_SUBJECT' => 'Geteilt {{module}} {{name}} von {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'Bitte {{module}} {{name}} von {{appId}} auschecken',

    'ERR_CONNECTOR_NOT_ARRAY' => 'Konnector-Array {0} ist falsch definiert worden und ist entweder leer oder kann nicht verwendet werden.',
    'LBL_PDF_VIEW' => 'PDF herunterladen.',
    'LBL_PDF_EMAIL' => 'PDF per E-Mail versenden',

    'ERR_SUHOSIN' => 'Der Upload Stream wird von Suhosin blockiert, bitte fügen Sie "upload" in suhosin.executor.include.whitelist ein. (Für weitere Informationen siehe Datei "sugarcrm.log")',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'jetzt',
    'LBL_TIME_AGO_SECONDS' => 'vor weniger als einer Minute',
    'LBL_TIME_AGO_MINUTE' => 'vor ca. einer Minute',
    'LBL_TIME_AGO_MINUTES' => 'vor {{this}} Minuten',
    'LBL_TIME_AGO_HOUR' => 'vor ca. einer Stunde',
    'LBL_TIME_AGO_HOURS' => 'vor {{this}} Stunden',
    'LBL_TIME_AGO_DAY' => 'gestern',
    'LBL_TIME_AGO_DAYS' => 'vor {{this}} Tagen',
    'LBL_TIME_AGO_YEAR' => 'vor über einem Jahr',
    'LBL_TIME_UNTIL_SECONDS' => 'in weniger als einer Minute',
    'LBL_TIME_UNTIL_MINUTE' => 'in ca. 1 Minute',
    'LBL_TIME_UNTIL_MINUTES' => 'in {{this}} Minuten',
    'LBL_TIME_UNTIL_HOUR' => 'in ca. 1 Stunde',
    'LBL_TIME_UNTIL_HOURS' => 'in {{this}} Stunden',
    'LBL_TIME_UNTIL_DAY' => 'Morgen',
    'LBL_TIME_UNTIL_DAYS' => 'in {{this}} Tage',
    'LBL_TIME_UNTIL_YEAR' => 'in über einem Jahr',
    'LBL_TIME_RELATIVE' => 'Veröffentlicht {{relativetime}} am {{date}} um {{time}}',
    'LBL_LAST_TOUCHED' => 'Zuletzt geändert {{relativetime}} am {{date}} um {{time}}',
    'LBL_LAST_COMMIT' => 'Letzter Einsatz:',
    'LBL_LISTVIEW_NO_RECORDS' => 'Keine Daten gefunden.',
    'LBL_DETAILVIEW_NO_RECORDS' => 'Dieser Datensatz kann zurzeit nicht dargestellt werden.',
    'LBL_REFINE_LIST' => 'Liste verfeinern',
    'LBL_SEARCH_BY' => 'Suche nach',
    'LBL_PREVIEW' => 'Vorschau',
    'LBL_COLUMNS' => 'Spalten',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'Vorschau deaktiviert: keine Daten verfügbar',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'Vorschau deaktiviert: kein Zugriff auf Datensatz',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'Vorschau deaktiviert: keine Daten verfügbar',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'Vorschau deaktiviert für diesen Datensatz',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'Vorschau disabled: Datensatz wurde möglicherweise entfernt oder Sie haben keinen Zugriff.',
    'LBL_PREVIEW_PREVIOUS' => 'Vorschau vorherige',
    'LBL_PREVIEW_NEXT' => 'Vorschau nächste',
    'LBL_PREVIEW_CLOSE' => 'Vorschau schließen',
    'LBL_STREAM_NO_RECORDS' => 'Dieser Datensatz hat keine Notizen. Fügen Sie eine Notiz hinzu, indem Sie auf den Link "Notiz" klicken.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} Dublikate gefunden.',
    'LBL_NO_DUPLICATES_FOUND' => 'Keine Duplikate gefunden.',
    'LBL_RESET_DEFAULT_VIEW' => 'Standardansicht zurücksetzen',
    'LBL_RESET_DEFAULT_WIDTHS' => 'Standardbreiten zurücksetzen',
    'LBL_TIMEZONE_UPDATED' => 'Sugar hat die Zeitzone Ihres Benutzerprofils an die Zeitzone Ihres Browsers angepasst',
    'LBL_SUCCESS' => 'Erfolg',
    'LBL_ERROR' => 'Fehler',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'Duplikate zusammenführen',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'Möchten Sie fortfahren? Klicken Sie auf "Abbrechen", oder auf "Bestätigen", um die Datensätze zu löschen.',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'Diese Aktion löscht folgende(n) Datensatz:',
    'LBL_MERGE' => 'Zusammenführen',
    'TPL_MERGING_RECORDS' => '{{mergeCount}} Datensätze werden zusammengeführt',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'Ungültige Anzahl von Datensätzen übergeben. Die gültige Anzahl ist von {{minRecords}} bis {{maxRecords}} Datensätze.',
    'LBL_MERGE_NO_ACCESS' =>
        'Sie haben keinen Zugriff, um diese Aktion durchzuführen. Mindestens ein Datensatz muss bearbeitbar sein.',
    'LBL_MERGE_LOCKED' => 'Einige der Datensätze, die für die Zusammenführung ausgewählt wurden, enthalten Felder, die durch einen Prozess für die Bearbeitung gesperrt sind und die zu diesem Zeitpunkt nicht zusammengeführt werden können.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'Alle Änderungen werden verworfen, wenn Sie zu einem neuen primären Datensatz wechseln. Sind Sie sicher, dass Sie wechseln möchten?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'Verknüpfte Datensätze zusammenführen',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'Zusammengeführt {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'Zusammenführung von {{objectName}} fehlgeschlagen. Initiiere neuen Versuch ({{num}} von {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'Zusammenführen {{objectName}} schlug fehl.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'Das Zusammenführen von Datensätzen wurde nicht vollständig durchgeführt.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'Einiger der verknüpften Datensätze konnten nicht ordnungsgemäß zusammengeführt werden. Klicken Sie auf "Abbrechen", um den Vorgang abzubrechen, und auf "OK", um mit der Zusammenführung weiterzumachen.',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'Alle verknüpften Datensätze werden zum Primärdatensatz verschoben.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'Sind Sie sich sicher, daß Sie diesen Datensatz von der Datenzusammenführung entfernen möchten?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'Datensatz von Datenzusammenführung entfernen',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'Ungültige Anzahl von Datensätzen weitergegeben. Der gültige Bereich liegt zwischen 1 und {{maxRecords}} Datensätzen.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'Die Kombination Benutzername/Passwort ist falsch; bitte versuchen Sie es erneut.',
    'LBL_INVALID_CREDS_TITLE' => 'Ungültige Daten',
    'LBL_INVALID_GRANT' => 'Ihr Token ist ungültig oder abgelaufen. Melden Sie sich erneut an.',
    'LBL_INVALID_GRANT_TITLE' => 'Token abgelaufen',
    'LBL_AUTH_FAILED' => 'Client-Authentifizierung fehlgeschlagen.',
    'LBL_AUTH_FAILED_TITLE' => 'Ungültiger Client',
    'LBL_INVALID_REQUEST' => 'Die Anfrage ist ungültig. Bitte verständigen Sie den technischen Support.',
    'LBL_INVALID_REQUEST_TITLE' => 'Ungültige Anfrage',
    'LBL_REQUEST_TIMEOUT' => 'Der Server antwortet nicht. Überprüfen Sie Ihre Internetverbindung.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'Zeitüberschreitung bei Anfrage: ',
    'LBL_UNAUTHORIZED' => 'Leider sind Sie nicht dazu autorisiert, auf diese Ressource zuzugreifen.',
    'LBL_UNAUTHORIZED_TITLE' => 'Unauthorisiert',
    'LBL_RESOURCE_UNAVAILABLE' => 'Resource nicht verfügbar.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'Verboten',
    'LBL_METHOD_NOT_ALLOWED' => 'HTTP-Methode hier nicht zugelassen. Bitte verständigen Sie Ihren Support.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'Methode hier nicht zugelassen',
    'LBL_PRECONDITION_MISSING' => 'Anfrage-Fehler, fehlender/ ungültiger Parameter. Bitte verständigen Sie den technischen Support.',
    'LBL_PRECONDITION_MISSING_TITLE' => 'Fehler:',
    'LBL_INVALID_412_RESPONSE' => 'Eine Anfrage ist gescheitert und macht die Anwendung unverwendbar. Bitte setzen Sie sich mit dem technischen Support in Verbindung.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'Keine Erlaubnis Feld {0} in Modul: {1} zu bearbeiten',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'Dieser Vorgang ist für den Datensatz "{0}" nicht erlaubt.',
    'LBL_LOGIN_BUTTON_LABEL' => 'Anmelden',
    'LBL_ACTIVITY_VIEW_TOUR' => 'Tour Aktivitätsansicht',
    'LNK_TOUR' => 'Tour',
    'LNK_MOBILE' => 'Mobiltelefon:',
    'LBL_FEEDBACK' => 'Rückmeldungen',
    'LBL_SUPPORT' => 'Support',
    'LBL_LANGUAGE' => 'Language / Sprache / Idioma',
    'LBL_LOADING_LANGUAGE' => 'Sprachpaket laden',
    'LBL_UPLOADING' => 'Wird hochgeladen',
    'LBL_UPLOADING_DOTS' => 'Wird hochgeladen...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'Sind Sie sicher, dass sie dieses Bild löschen möchten?',
    'LBL_FILE_DELETE_CONFIRM' => 'Sind Sie sicher, dass Sie diese Datei löschen möchten? Dieser Vorgang kann nicht rückgängig gemacht werden.',
    'LBL_FILE_DELETED' => 'Die Datei wurde erfolgreich gelöscht',

    //theme roller
    'LBL_PORTAL_THEME' => 'Portal-Design',
    'LBL_THEME_PREVIEW' => 'Vorschau des Portaldesigns',
    'LBL_LOADING_PREVIEW' => 'Vorschau wird geladen',
    'LBL_RESET' => 'Zurücksetzen',
    'LBL_COLORS' => 'Farben',
    'BorderColor' => 'Rahmenfarbe',
    'NavigationBar' => 'Navigationsleiste',
    'PrimaryButton' => 'Primäre Schaltfläche',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'Speichern & Anwenden',
    'LBL_RESET_THEME_LNK' => 'Standarddesign wiederherstellen',
    'LBL_RESET_THEME_MODAL_INFO' => 'Möchten Sie Ihr benutzerdefiniertes Design wirklich mit dem Standarddesign überschreiben?',
    'LBL_RESET_THEME_PROCESS' => 'Das Standarddesign wird wiederhergestellt...',
    'LBL_SAVE_THEME_PROCESS' => 'Desugb wird gespeichert...',

    // image loader
    'LBL_SELECT_PHOTO' => 'Wählen Sie ein Foto',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Verbesserte Umsatzplanungsfunktionen in SugarCRM',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => ' <div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">Richten Sie Ihre Prognose-Parameter ein</li><li class="fa fa-check">Den Status der Verkaufszahlen und der Pipeline einfach überwachen</li><li class="fa fa-check">Prognose basierend auf den erwarteten Verkaufszahlen ihres Verkaufsteams</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'Stellen Sie Umsatzplanungsparameter ein',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">Startdatum für Geschäftsjahr wählen</li><li class="fa fa-check">Einstellen der Zeit: Jährlich oder vierteljährlich</li><li class="fa fa-check">Wie viele Zeitspannen sollen im Worksheet rückwirkend und zukünftig angezeigt werden</li><li class="fa fa-check">Welche Verkaufsphasen sollen im Forecast berücksicht bzw. nicht berücksichtigt werden und welche als "Upside".</li><li class="fa fa-check">Wählen Sie Prognoseszenarien, um die wahrscheinlichste, die beste und die schlechteste Prognose zu wählen</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen2-thumb.png" width="220" id="thumbnail_2" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'Umsatzplanung Ihres Verkaufsteams verwalten',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">Wählen Sie den Zeitraum für den Überblick der Umsatzplanung </li><li class="fa fa-check">Ansicht des Arbeitsblätter der Teammitglieder und Bereitstellen der angepaßten Umsatzplanung</li><li class="fa fa-check">Anzeige, wenn ein Teammitglied eine neue Umsatzplanung übergibt</li><li class="fa fa-check">Speichern der Umsatzplanung als Entwurf, bevor man sie dem Manager übergibt</li><li class="fa fa-check">Anzeige der vergangenen Übergaben</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'Umsatzplanung Ihres Verkaufsteams verwalten',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">Anzeige Pareto-Diagramm der Pipeline aller Teammitglieder</li><li class="fa fa-check">Auswahl des angezeigten Umsatzes, wahrscheinlich, bestes und schlechtestes Szenario/li><li class="fa fa-check">Anzeige des Umsatzes und wie viel fehlt, um die Team-Sollvorgabe zu erreichen</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'Die eigene Umsatzplanung verwalten',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">Wählen Sie den Zeitraum für die Prognose</li><li class="fa fa-check">Überprüfen und Bearbeiten der Werte für ein schnelle "What-if"-Analyse innerhalb der Zeile</li><li class="fa fa-check">Speichern der Umsatzplanung als Entwurf oder Übermitteln an den Manager</li><li class="fa fa-check">Verlauf aller bisher übergebenen Werte</li><li class="fa fa-check">Übergabe der Prognose an Manager und Überblick der vergangenen Umsatzübergaben</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'Eigene geplante Umsätze verwalten',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">Anzeige Pareto-Diagramm der Analyse der Verkaufschancen über einen bestimmten Zeitraum</li><li class="fa fa-check">Visualisierung der Verteilung der einzelnen Verkaufsphasen und Gewinn-Wahrscheinlichkeiten</li><li class="fa fa-check">Übersicht des sichtlichen Umsatzes und Sollvorgaben</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Was gibt es Neues in Sugar?',
    'LBL_TOUR_WATCH' => 'Sehen Sie sich an, was es Neues in Sugar gibt',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="fa fa-check">Verbessertes Design – jetzt moderner gestaltet.<li class="fa fa-check">Verbessertes Prognose-Modul – jetzt mit intuitiver Benutzeroberfläche mit neuen grafischen Verbesserungen</li></ul>',
    'LBL_TOUR_VISIT' => 'Für mehr Information besuchen Sie unsere Anwendung',
    'LBL_TOUR_DONE' => 'Sie sind fertig!',
    'LBL_TOUR_REFERENCE_1' => 'Sie können jederzeit unsere',
    'LBL_TOUR_REFERENCE_2' => 'durch den "Support"-Link im Profil-Menü aufrufen.',
    'LNK_TOUR_DOCUMENTATION' => 'Dokumentation',
    'LBL_TOUR_CALENDAR_URL_1' => 'Teilen Sie ihren SugarCRM-Kalender mit anderen Anwendungen wie Microsoft Outlook oder Exchange? Wenn ja, dann haben Sie eine neue URL. Diese neue, sicherere URL beinhaltet einen persönlichen Schlüssel und verhindert die unautorisierte Veröffentlichung Ihres Kalenders.',
    'LBL_TOUR_CALENDAR_URL_2' => 'Die URL Ihres öffentlichen Kalenders abrufen.',
    'LBL_TOUR_CUBE' => 'Dashboard und Aktivitäten aufrufen',
    'LBL_TOUR_NAV_BAR' => 'Auf alle Module zugreifen und Maßnahmen treffen',
    'LBL_TOUR_NOTIFICATIONS' => 'Klicken Sie hier, um Benachrichtigungen anzeigen',
    'LBL_TOUR_SEARCH' => 'Module auswählen und darin suchen',
    'LBL_TOUR_AVATAR' => 'Mehr Details über die Anwendung anzeigen oder sich abmelden',
    'LBL_TOUR_ADD' => 'Von hier einen Eintrag erfassen',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'Informationsfeld ein- oder ausblenden',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'Wahlen Sie, ob Sie die Aktivitäten oder die Liste der Datensätze anzeigen möchten',
    'LBL_TOUR_LIST_FILTER1' => 'Die Filterleiste ermöglicht die Suche für dieses Modul',
    'LBL_TOUR_LIST_FILTER2' => 'Vordefinierte Filter wählen oder neue erstellen',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'Scheiben Sie hier, um nach einem Namen zu suchen',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'Wähen Sie, ob Sie die Zeilen oder die Vorschaudetails bearbeiten möchten',
    'LBL_TOUR_RECORD_ACTIONS' => 'Aktionen am Datensatz durchführen',
    'LBL_TOUR_RECORD_SUBPANEL' => 'Klicken Sie auf die Überschrift zum Erweitern und Reduzieren des Sub-Panels',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'Der Datensatzname wird aktualisisert',
    'LBL_TOUR_RECORD_STATUS' => 'Finden Sie den Datensatz-Level-Status hier',
    'LBL_TOUR_RECORD_SHOWMORE' => 'Klicken Sie hier, um mehr Daten zu dem Eintrag zu sehen',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'Wahlen Sie diese Option, um Aktivitäten oder verwandte Eintrage zu sehen',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'Klicken Sie in die einzelnen Felder, um diese direkt zu bearbeiten',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'Neue Dashlet-Gruppen erstellen',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'Der Dashlet-Gruppe einen Namen zuweisen',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'Entfernen eines Dashlets oder Einstellungen ändern.',
    'LBL_TOUR_INTRO' =>'<h4>Willkommen bei Sugar</h4> Wir werden Ihnen nun einige Funktionen erklären.  Verwenden Sie die Pfeiltasten < und > unten auf dem Bildschirm, um der Tour zu folgen.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">Neuigkeiten</a><p class="details">Erfahren Sie mehr über die Unterschiede der neuen Versionen.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Erfahren Sie mehr über Sugar</a><p class="details">Eine umfassende Bibliothek an E-Learning-Material, Ausbildungsprogrammen mit E-Kursen und Live-Klassen, Web-Seminaren und Video-Tutorials.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">Kundendienst</a><p class="details">Haben Sie Fragen, Probleme oder Anregungen?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'Eine Liste aller Datensätze anzeigen und Aktionen durchführen.',
    'LBL_TOUR_RECORD_INTRO' => 'Details über den Eintrag und damit verbundene Daten anzeigen.',
    'LBL_TOUR_FORECAST_INTRO' => 'Verkaufs-Pipeline und Prognose verwalten.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'Wahlen Sie einen Zeitraum, um die zugehörige Umsatzplanung zu sehen',
    'LBL_TOUR_FORECASTS_COMMITS' => 'Klicken Sie hier, um die vorher freigegebenen Umsatzpläne zu sehen',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'Klicken um hier, um die Inline-Bearbeitung zu aktivieren',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'Distanz zur Quote evaluieren',
    'LBL_TOUR_FORECASTS_CHART' => 'Prognose-Verteilung evaluieren',
    'LBL_TOUR_TOUR' => 'Tour jederzeit starten',
    'LBL_TOUR_TAGS_ADD' => 'Klicken Sie auf das Feld "Tags" zum Hinzufügen und Entfernen von Tags',
    'LBL_TOUR_TAGS_DELETE' => 'Um einen Tag zu löschen, verwenden Sie die Rücktaste oder klicken Sie auf das bei jedem Feld stehende [X]',
    'LBL_TOUR_RECORD_SAVE' => 'Wenn Sie fertig sind, klicken Sie auf Speichern',


    'LBL_FUTURE' => 'Zukunft',
    'LBL_REQUIRED_FIELD' => 'Erforderlich',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'Angebotenes Produkt',
    'LBL_DISCOUNT_TOTAL' => 'Gesamt-Rabatt',
    'LBL_DISCOUNT_PERCENT' => '% Prozent',
    'LBL_DISCOUNT_SELECT' => 'Bestimmt, ob der Rabatt ein Prozentsatz oder ein Pauschalbetrag ist',
    'LBL_TAX' => 'Steuer',
    'LBL_SHIPPING' => 'Lieferung',
    'LBL_GRAND_TOTAL' => 'Gesamtbetrag',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'Die Rechnungsadresse automatisch aus dem Firmenprofil ausfüllen',
    'LBL_QLI_ADD_GROUP' => 'Eine Gruppe hinzufügen',
    'LBL_QLI_COMMENT' => 'Kommentar',
    'LBL_SELECT_ACTION' => 'Aktion auswählen',
    'LBL_QLI_GROUP_NAME' => 'Name der Gruppe',
    'LBL_GROUP_TOTAL' => 'Gesamtbetrag der Gruppe',
    'LBL_ITEM_NAME' => 'Produkt',
    'LBL_QLI_DELETE' => 'Sind Sie sicher, dass Sie dieses Produkt löschen möchten?',
    'LBL_QLI_COMMENT_DELETE' => 'Sind Sie sicher, dass Sie den Kommentar zu diesem Produkt löschen möchten?',
    'LBL_QLI_GROUP_DELETE' => 'Möchten Sie die Gruppe {0} wirklich löschen? Alle Elemente werden in die Standardgruppe verschoben.',
    'LBL_QLI_GROUP_EMPTY' => 'Kein angebotenes Produkt',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'Optional',
    'LBL_RELATED_MODULE' => 'Verknüpfte {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'Verknüpfte {{{this}}}',
    'LBL_CREATE_MODULE' => 'Erstelle {{{this}}}',
    'LBL_EDIT' => 'Bearbeite {{{this}}}',
    'LBL_ASSOC' => 'Zuweisen von {{{this}}}',
    'LBL_ASSIGN' => 'Wähle {{{this}}}',
    'LBL_EDIT_RELATED' => 'Bearbeite Verknüpfte/r {{{this}}}',
    'LBL_CREATE_RELATED' => 'Erstelle Verknüpfte/r {{{this}}}',
    'LBL_ASSOC_EXISTING' => 'Zuweisen von bestehenden {{{this}}}',
    'LBL_SEARCH_ALL' => 'Suche alle {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'Alle Datensätze suchen...',
    'LBL_SEARCH_ALL_MODULES' => 'Alle suchen',
    'LBL_OK' => 'OK',
    'LBL_YES' => 'Ja',
    'LBL_NO' => 'Nein',
    'LBL_SHOW_NUMBERING' => 'Stufennummerierung anzeigen',
    'LBL_HIDE_NUMBERING' => 'Stufennummerierung ausblenden',
    'LBL_CALL_BUTTON' => 'Anruf',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'E-Mail',
    'LBL_HONEYPOT' => 'Dieses Feld nicht ausfüllen, wenn Sie eine reale Person sind.',
    'LBL_LINK_BUTTON' => 'Link',
    'LBL_UNLINK_BUTTON' => 'Entfernen',
    'LBL_MAP_BUTTON' => 'Karte',
    'LBL_FILE_BUTTON' => 'Datei',
    'LBL_URL_BUTTON' => 'Web',
    'LBL_WARNING' => 'Warnung',
    'LBL_CONFIRM' => 'Bestätigen',
    'LBL_CONFIRMATION_POPUP' => 'Bestätigungs-Popup',
    'LBL_NO_ACCESS' => '(Kein Zugriff)',
    'LBL_NO_ACCESS_LOWER' => 'Kein Zugriff',
    'LBL_NO_FIELD_ACCESS' => 'Kein Zugriff',
    'LBL_NO_LICENSE_ACCESS' => 'Lizenz erforderlich',
    'LBL_VALUE_ERASED' => 'Wert gelöscht',
    'LBL_VALUE_ERASED_TOOLTIP' => 'Diese Informationen wurden aufgrund einer Datenschutzanfrage gelöscht',
    'LBL_CREATE_RELATED_RECORD' => 'Verknüpften Datensatz erstellen',
    'LBL_ASSOC_RELATED_RECORD' => 'Verknüpfung zu einem existierenden Datensatz',
    'LBL_CHOOSE_LINK' => 'Linktyp wählen',
    'LBL_CHOOSE_PARENT_TYPE' => 'Wählen Sie den übergeordneten Typ',
    'LBL_HOME' => 'Startseite',
    'ERR_NO_DOCS' => 'Keine Dokumente verfügbar',
    'ERR_NO_RECORDS_SELECTED' => 'Sie haben keine Eintrage ausgewählt',
    'LBL_DELETING' => 'Löschvorgang läuft...',
    'LBL_UNLINKING' => 'Verknüpfung aufheben...',
    'LBL_UNLINKED' => 'Verknüpfung aufgehoben...',
    'LBL_LEGAL' => 'Rechtliches',
    'LBL_UPCOMING' => 'Meine nächsten Termine',
    'LBL_RECENTLY_UPDATED' => 'Kürzlich aktualisiert',
    'LBL_NOTES_SUBPANEL_TITLE' => 'Notizen',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'Meetings',
    'LBL_TASKS_SUBPANEL_TITLE' => 'Aufgaben',
    'LBL_CALLS_SUBPANEL_TITLE' => 'Anrufe',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'Konten',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'Kontakte',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'E-Mails',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'Schichten',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'Produkte',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'Schichtausnahmen',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'Dokumente',
    'LBL_ESCALATIONS' => 'Eskalationen',
    'LBL_ESCALATED' => 'Eskaliert',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'Eskalationen',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'Weitere verknüpfte Eskalationen',
    'LBL_ESCALATIONS' => 'Eskalationen',
    'LNK_SETTINGS' => 'Einstellungen',
    'LBL_MOBILE_SUPPORT' => 'Support',
    'LBL_MOBILE_SHOW_MORE' => 'Mehr anzeigen...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'Mehr anzeigen...',
    'LBL_MOBILE_NO_RECORDS' => 'keine Einträge gefunden',
    'LBL_MOBILE_SEARCH_TEAMS' => 'Suche Teams...',
    'LBL_MOBILE_SELECT_TEAMS' => 'Teams auswählen',
    'LBL_MOBILE_WAIT' => 'Bitte warten...',
    'LBL_MOBILE_LOGING_OUT' => 'Bitte warten, während die Abmeldung erfolgt...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'Erneut anmelden',
    'LBL_MOBILE_META_SYNC_FAILED' => 'Synchronisation mit dem Server nicht möglich.',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'Synchronisation mit dem Server nicht möglich. Erneut versuchen?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'Datenschutz, allgemeine Geschäftsbedingungen',
    'LBL_MOBILE_APP_VERSION' => 'App-Version',
    'LBL_MOBILE_SERVER_VERSION' => 'Server-Version',
    'LBL_MOBILE_SERVER_URL' => 'Server-URL',
    'LBL_MOBILE_PTR_PULL' => 'Zum Aktualisieren nach unten ziehen...',
    'LBL_MOBILE_PTR_RELEASE' => 'Zum Aktualisieren loslassen...',
    'LBL_MOBILE_EDIT_REL' => 'Beziehung bearbeiten',
    'LBL_MOBILE_DESKTOP' => 'Desktop-Version',
    'LBL_MOBILE_DELETE_CONFIRM' => 'Sind Sie sicher, dass Sie diesen Eintrag löschen möchten?',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'Sind Sie sicher, dass Sie diesen Eintrag trennen möchten?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'Möchten Sie den letzten Anruf im System protokollieren?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'Empfänger auswählen',
    'LBL_MOBILE_CHOOSE_PHONE' => 'Telefonnummer wählen',
    'LBL_MOBILE_CHOOSE_URL' => 'URL auswählen',
    'LBL_MOBILE_CHOOSE_DOC' => 'Dokument wählen',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'Standort wählen',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'Keine Aktionen verfügbar',
    'LBL_MOBILE_FEEDBACK' => 'Rückmeldungen',
    'LBL_MOBILE_DOC' => 'Dokument',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'Download gestartet: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'Download fertig: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'Datei wird hochgeladen...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'Datei erfolgreich hochgeladen.',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'Bild wird vorbereitet...',
    'LBL_CLOSE_SAVE_BUTTON' => 'Aufgabe schließen und speichern',
    'LBL_LATER' => 'Später',
    'LBL_USE_HTTPS' => 'Sichere Verbindung verwenden',
    'LBL_LOADING_FILES' => 'Die Dokumenteliste wird noch geladen. Bitte versuchen Sie es später erneut',
    'LBL_NEW_WEB_VERSION' => 'Eine neue Version von SugarCRM Mobile ist verfügbar. Möchten Sie das Update starten?',
    'LBL_SET_FONTSIZE' => 'Schriftgröße',
    'LBL_FONTSIZE_TINY' => 'sehr klein',
    'LBL_FONTSIZE_SMALL' => 'klein',
    'LBL_FONTSIZE_NORMAL' => 'normal (Standardeinstellung)',
    'LBL_FONTSIZE_LARGE' => 'groß',
    'LBL_FONTSIZE_LARGER' => 'größer',
    'LBL_FONTSIZE_HUGE' => 'sehr groß',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'extrem groß',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "Download fehlgeschlagen\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'Mehr...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...weniger',
    'LBL_OFFLINE_MODE' => 'Offline Modus',
    'LBL_OFFLINE_DELETED' => 'Der Datensatz wurde nicht gefunden.',
    'LBL_OFFLINE_DELETED_RELATED' => 'Der verknüpfte Datensatz konnte nicht gefunden werden. Möglicherweise wurde er gelöscht oder die Verknüpfung wurde aufgehoben.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'Das Herunterladen Ihrer zugewiesenen, favorisierten und gefolgten Datensätze für den Offline-Zugriff kann einige Zeit in Anspruch nehmen. Eine schnelle Verbindung ist empfohlen. Möchten Sie fortfahren?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'Möchten Sie jetzt Ihre zugewiesenen, favorisierten und gefolgten Datensätze für den Offline Zugriff herunterladen? Eine schnelle Verbindung ist empfohlen, da dies einige Zeit in Anspruch nehmen kann. Sie können diese später über das Hauptmenü > Offline herunterladen.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'Der Download der Datensätze war erfolgreich.',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'Downloaden der Datensätze...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'Fehler beim Downloaden der Datensätze',
    'LBL_OFFLINE_PREFETCHING' => 'Laden der Datensätze',
    'LBL_OFFLINE_PREFETCHING_MODULE' => '{{module}} {{progressValue}} wird geladen...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'Ca. verbleibende Zeit: {{estimatedTime}}',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => 'Laden von Modul {{module}} abgeschlossen',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'Speicher bereinigen...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'Bereinigung beendet',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'Möchten Sie diese Änderungen rückgängig machen?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'Rollback abgeschlossen',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'Rollback fehlgeschlagen',
    'LBL_OFFLINE_CLEAR_DB' => 'Speicher leeren...',
    'LBL_OFFLINE_COMPACT_DB' => 'Speicher kompremieren...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'Diese Aktion löscht alle Datensätze, die seit längerer Zeit nicht verwendet wurden. Möchten Sie fortfahren?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'Möchten Sie wirklich alle Daten von der lokalen Festplatte löschen?',
    'LNK_OFFLINE_SETTINGS' => 'Offline',
    'LBL_OFFLINE_SETTINGS' => 'Debug-Einstellungen',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'Keine Änderungen, die auf die Synchronisierung warten.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'Änderungen, die auf Synchronisierung warten.',
    'LBL_OFFLINE_STATUS_ONLINE' => 'Das Gerät ist online.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'Das Gerät ist online.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'Keine Verbindung zum Server.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'Die letzte Synchronisation schlug fehl. Überprüfen Sie das Transaktionsprotokoll.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'Synchronisation in Arbeit...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'Transaktion synchronisiert.',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'Sind Sie sicher dass sie offline arbeiten möchten?',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'Sind Sie sicher, dass Sie den Offlinemodus beenden möchten? Alle nicht synchronisierten Änderungen werden verloren gehen.',
    'LBL_OFFLINE_ENABLED' => 'Offline eingerichtet',
    'LBL_OFFLINE_DISABLED' => 'Offline deaktiviert',
    'LBL_OFFLINE_STATS' => 'Speicher-Statistik',
    'LBL_OFFLINE_SERVER_FETCH' => 'Empfang der Daten vom Server...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'Ein Benutzer auf derm Server hat denselben Datensatz editiert. Bitte bestätigen Sie das automatische Zusammenführen der Änderungen oder lehnen Sie ab, um die Änderungen zu verwerfen.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'Letzter Synchronisierungsversuch => {{ts}}',
    'LBL_ACTION_UPDATE' => 'Aktualisieren',
    'LBL_ACTION_CREATE' => 'Erstellen',
    'LBL_ACTION_DELETE' => 'Löschen',
    'LBL_ACTION_LINK' => 'Verknüpfen',
    'LBL_ACTION_UNLINK' => 'Verknüpfung aufheben',
    'LBL_ACTION_FAVORITE' => 'Favorit',
    'LBL_ACTION_FOLLOW' => 'Folgen',
    'LBL_ACTION_CREATE_EXPLANATION' => 'Erstellt {{module}} "{{name}}"',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'Aktualisiert {{module}} "{{name}}"',
    'LBL_ACTION_DELETE_EXPLANATION' => 'Gelöscht {{module}} "{{name}}"',
    'LBL_ACTION_LINK_EXPLANATION' => 'Verknüpfe {{module}} "{{name}}" mit {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'Verknüpfung aufheben {{module}} "{{name}}" mit {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'Gefolgte {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'Unfollowed {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'Favorisiert {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'Unfavorited {{module}} => &#39;{{name}}&#39;',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'Created {{module}} &#39;{{name}}&#39; related to {{relatedModule}} &#39;{{relatedName}}&#39;',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'Primär',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'Opt-out',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'Beitreten/zustimmen',
    'LBL_EMAIL_ACTION_SET_VALID' => 'Gültig',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'Ungültig',
    'LBL_ROLLBACK_BUTTON' => 'Wiederholen',
    'LBL_TX_LOG' => 'Transaktionsprotokoll',
    'LBL_TX_LOG_DETAIL' => 'Transaktionsdetails',
    'LBL_RECORD_DELETED' => '(Datensatz gelöscht)',
    'LBL_NOT_AVAILABLE' => 'nicht verfügbar',
    'LBL_FILE_SIZE' => 'Dateigröße',
    'LBL_FILE_SIZE_UNITS_B' => 'Bytes',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'Elemente wählen',
    'LBL_OFFLINE_DB_SIZE' => 'Datenbankgröße',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'Datensätze pro Modul',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'Anzahl der Datensätze insgesamt',
    'LBL_RECORD_NOT_FOUND' => 'Der Datensatz wurde nicht gefunden.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'Dazugehöriger Bericht wurde nicht gefunden.',
    'LBL_NOT_AUTHORIZED' => 'Sie haben nicht die Rechte, diesen Datensatz anzuzeigen.',
    'LBL_MOBILE_PROCESSING_FILE' => 'Datei wird vorbereitet...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'Software von Drittanbietern',
    'LNK_TERMS_OF_USE' => 'AGB',
    'LNK_PRIVACY_POLICY' => 'Datenschutzrichtlinie',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'Einmalige Anmeldung',
    'LBL_RECENTS' => 'Kürzlich',
    'LBL_SHOWING_CACHED_DATA' => 'Kann den Server nicht erreichen. Anzeige der neuesten verfügbaren Daten ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'Speichern und Schließen von {{moduleSingular}}',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'Spezifisches Dashboard',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Spezifisches Modul',
    'LBL_MOBILE_DEFAULT_VIEW' => 'Startbildschirm',
    'LBL_MOBILE_DEFAULT_MODULE' => 'Ausgewähltes Modul',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'Ausgewähltes Dashboard',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'Ausgewähltes Dashlet',
    'LBL_ALL_DASHLETS' => 'Alle Dashlets',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'Globale Suche',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Geben Sie @ ein, um einen Benutzer zu erwähnen. Geben Sie # ein, um auf einen Datensatz zu verweisen.',
    'LBL_MOBILE_NEW_COMMENT' => 'Neuer Kommentar',
    'LBL_RECENTLY_VIEWED' => 'Zuletzt angesehen',
    'LBL_FILE_STORED_LOCALLY' => 'Die Datei wird lokal gespeichert und synchronisiert, sobald das Gerät online ist.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'Wenn Sie bestimmte Felder ändern möchten, die nicht bearbeitet werden können, wenden Sie sich an den Administrator, um ihm diese Änderungen mitzuteilen.',
    'LBL_ACTIVITY_POST' => '{{{value}}}auf {{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'Kein Kommentar',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'Die nächsten {{{commentsLeft}}} Kommentare anzeigen',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'Einklappen',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'Erstellung des Kommentars bestätigen',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'Comment Log darf nicht leer sein',
    'LBL_MOBILE_PDF_DOWNLOAD' => '{{{pdfTemplateName}}} PDF herunterladen',

    'ERR_SYNC_FAILED' => 'Synchronisation mit dem Server nicht möglich.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'Nicht autorisierter Zugriff.',
    'ERR_MOBILE_INVALID_CREDS' => 'Ungüliger Benutzername oder Passwort.',
    'ERR_MOBILE_SESSION_EXPIRED' => 'Ihre Sitzung ist abgelaufen.',
    'ERR_MOBILE_NOT_FOUND' => 'Ressource nicht gefunden.',
    'ERR_MOBILE_TIMEOUT' => 'Server antwortet nicht.',
    'ERR_MOBILE_CONNECTION_FAILED' => 'Server kann nicht erreicht werden.',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'Keine Internetverbindung verfügbar.',
    'ERR_MOBILE_INTERNAL' => 'Internerfehler ({{{code}}}). Bitte versuchen Sie es später erneut.',
    'ERR_MOBILE_VALIDATION' => 'Datensatz ist ungültig',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'Nicht unterstützte Server-Edition: {{{flavor}}}. Unterstützte Editionen: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'Nicht unterstützte Server-Version: {{{version}}}. Minimal benötigte Version: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'Error. Ungültige E-Mail-Adresse.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'Dieser Dokumenttyp wird nicht unterstutzt.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'Authentifizierung fehlgeschlagen.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'Angeforderte Ressource wurde nicht gefunden.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'Interner Serverfehler',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'Verboten.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'Dienst nicht verfügbar.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'Ein unerwarteter Fehler ist aufgetreten.',
    'ERR_MOBILE_UPLOAD' => 'Fehler beim Datei-Upload',
    'ERR_MOBILE_FILE_PROCESSING' => 'Datei-Verarbeitungsfehler',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'Der Gerätspeicher ist nicht verfügbar',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'Ihre Anwendung ist veraltet und nicht länger kompatibel mit der Instanz von{{{brandName}}}, mit der Sie sich verbinden. Möchten Sie die neue Version aus dem App Store herunterladen?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'Die Serverkonfiguration hat sich geändert und ein erneutes Laden ist notwendig. Möchten Sie fortfahren?',
    'ERR_MOBILE_CONFLICT' => 'Ein Benutzer auf derm Server hat denselben Datensatz editiert. Bitte bestätigen Sie das automatische Zusammenführen der Änderungen oder lehnen Sie ab, um die Änderungen zu verwerfen.',
    'ERR_MOBILE_METADATA_CHANGED' => 'Die Serverkonfiguration wurde geändert.',
    'ERR_MOBILE_FILE_READ' => 'Fehler beim Lesen der Datei',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'Datei nicht gefunden',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'Datei nicht lesbar',
    'ERR_MOBILE_FILE_ABORTED' => 'Lesevorgang wurde abgebrochen',
    'ERR_MOBILE_FILE_SECURITY' => 'Datei ist gesperrt',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'Die mobile Version unterstützt diese Funktionalität nicht. Möchten Sie die Desktop-Version öffnen?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'Die Datei ist zu groß. Maximale Dateigröße {{size}}',
    'ERR_OFFLINE' => 'Offline-Fehler',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'Gescheiterter Versuch, den lokalen Speicher zu öffnen',
    'ERR_OFFLINE_STORAGE_CREATE' => 'Gescheiterter Versuch, den lokalen Speicher zu erstellen',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'Gescheiterter Versuch, den lokalen Speicher zu erstellen: Sie haben nicht genügend Speicherplatz.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'Sie haben nicht genügend Speicherplatz im lokalen Speicher.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'Datenbank Bereinigung gescheitert.',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'Sie haben nicht genügend Speicherplatz für die Offline-Speicherung. Eine Speicherbereinigung wird empfohlen. Das kann einige Minuten dauern.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'Fehlgeschlagener Versuch, Datensätze vom Server abzurufen.',
    'ERR_OFFLINE_SYNC_ERROR' => 'Sychnronisierungsfehler aufgetreten',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'Snychronisierungskonflikt.',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'Fehlgeschlagener Versuch, die Serverzeit abzurufen',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'Der Offline-Modus konnte nicht aktiviert werden. Der Server kann nicht erreicht werden.',
    'LBL_EXPORT_CSV' => 'CSV exportieren',
    'LBL_ERR_EXPORTING_CSV' => 'Export fehlgeschlagen',
    'LBL_ERR_EXPORT_ALL' => 'Datenabruf für ausgewählte Datensätze ist fehlgeschlagen, bitte erneut versuchen',
    'LBL_LIST_SETTINGS_RESTORE' => 'Standardeinstellungen wiederherstellen',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'Felder wiederherstellen?',
    'LBL_LIST_SETTINGS_TITLE' => 'Listenansicht-Ersteller',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'Verfügbare Felder',
    'LBL_LIST_SETTINGS_REMOVE' => 'Entfernen',
    'LBL_LIST_SETTINGS_TEXT' => 'Felder in den Listenansicht-Ersteller ziehen und neu anordnen, um die {{moduleName}}-Listenansicht zu gestalten.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'Mindestens ein Feld muss dem Layout hinzugefügt werden.',
    'LBL_LIST_SETTINGS_EMPTY' => 'Keine verfügbaren Felder',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'Keine übereinstimmenden Felder gefunden',
    'LBL_LIST_FILTER' => 'Feld Suche',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'E-Mail-Client',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'Externer E-Mail-Client',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar E-Mail-Client',
    'LBL_OFFLINE_CAPABILITIES' => 'Offline-Funktionen aktivieren',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'Löschen der Transaktion fehlgeschlagen.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'Transaktion gelöscht.',
    'LBL_SECURE_MODE' => 'Verbesserter Sicherheitsmodus',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'Aktivieren Sie diese Einstellung, um den Inhalt von Sugar Mobile auszublenden, wenn die App im Hintergrund läuft. Dies verhindert auch jederzeit Screenshots der App.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'Aktivieren Sie diese Einstellung, um den Inhalt von Sugar Mobile auszublenden, wenn die App im Hintergrund läuft.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'Immer Offline Modus',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'Sie arbeiten im Immer Offline Modus. Möchten sie erneut verbinden?',
    'LBL_RECONNECT' => 'Wiederverbinden',
    'LBL_STAY_OFFLINE' => 'Offline bleiben',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'Das Modul, auf das Sie zugreifen möchten, ist auf Sugar Mobile nicht verfügbar.',
    'LBL_MOBILE_RELEASE_NOTE' => 'Sugar Mobile für {{Plattform}} Freigabehinweise',
    'LBL_MOBILE_USER_GUIDE' => 'Sugar Mobile für {{Plattform}} Benutzerhandbuch',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'in dem diese Wörter enthalten sind',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'unter Ausschluss dieser Wörter',
    'LBL_NOTIFICATIONS_CHANNEL' => 'Aktualisierungen',
    'LBL_APPLY_BUTTON_LABEL' => 'Anwenden',
    'LBL_ACTION_CREATE_FAILURE' => "Datensatz konnte nicht gespeichert werden: \n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "Datensatz konnte nicht aktualisiert werden: \n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'Feldberechnungen konnten nicht auf dem Server aufgelöst werden.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'Folgende Felder sind ungültig: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>Erfolg.</b> Sie haben erfolgreich das {{{module}}} erstellt <a href="#{{{recordUrl}}}"><a href="#{{{recordUrl}}}"><a href="#{{{recordUrl}}}">{{{recordName}}}".</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>Erfolg.</b> Sie haben den Datensatz erfolgreich aktualisiert',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'E-Mail-Daten konnten nicht vom Server abgerufen werden.',
    'LBL_ASSIGN_SUCCESS' => '<b>Erfolg.</b> Der Datensatz wurde an {{{userName}}} zugewiesen',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'Diese E-Mail als Entwurf speichern?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'Als Entwurf speichern',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'E-Mail verwerfen',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'Wenn Sie den Entwurf nicht speichern, verlieren Sie diese E-Mail.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'Signatur auswählen',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'E-Mail-Vorlage auswählen',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'Die Vorlage wird alle Inhalte in dieser E-Mail überschreiben. Sind Sie sicher, dass Sie diese Vorlage verwenden und den Inhalt überschreiben möchten?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'Neue E-Mail',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'Ihre E-Mail enthält Variablen, die durch Werte aus dem Datensatz "Zugehörig zu" ersetzt werden. Bitte vergewissern Sie sich vor dem Versenden, dass das Feld "Zugehörig zu" korrekt eingestellt ist.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'Kein E-Mail-Konto für ausgehende E-Mails gefunden. Bitte kontaktieren Sie Ihren Sugar-Administrator.',
    'LBL_EMAIL_MORE_RECIPIENTS' => 'und {{{count}}} weitere',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'Eine E-Mail hinzufügen',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'Geben Sie einen Kontaktnamen oder eine E-Mail ein',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (Neue E-Mail)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'Variablen',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'E-Mail-Vorlagen',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'Kampagnenvorlagen',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'Workflow-Vorlagen',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'Systemvorlagen',
    'LBL_FILTER_EDIT' => 'Filter bearbeiten',
    'LBL_FILTER_MY_FILTER' => 'Mein Filter',
    'LBL_FILTER_MY_FILTER_BY' => 'Mein Filter nach {{{filters}}}',
    'LBL_FILTER_SAVE' => 'Filter speichern',
    'LBL_SELECT_PARAM' => 'Auswählen',
    'LBL_SELECT_MODULES' => 'Modul Auswahl',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'Zusätzliche Parameter auswählen',
    'LBL_FILTER_TEMPORARY' => 'Temporäre Filter',
    'LBL_ERROR_FILE_UPLOAD' => '{{{fieldLabel}}}-Datei „{{{fileName}}}“ konnte nicht hochgeladen werden. {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">Anzeigen des Berichts fehlgeschlagen</a>',
    'LBL_FILE_UPLOAD_ONE' => 'Datei speichern...',
    'LBL_FILE_UPLOAD_MANY' => 'Speichern der Datei {{{index}}} von {{{total}}}...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'Benachrichtigungseinstellungen',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'Verwalten Sie Ihre Push-Benachrichtigungen',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "Steuern Sie die Anzeige von Benachrichtigungen über die Benachrichtigungseinstellungen Ihres Geräts.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'Aufgaben',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'Benachrichtigungen erhalten, wenn Ihnen Datensätze zugewiesen werden.',
    'LBL_NOTIFICATION_MENTIONS' => 'Erwähnungen',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'Benachrichtigungen erhalten, wenn Sie in Kommentarprotokolleinträgen erwähnt werden.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'Das Feld Kommentarprotokoll wurde nicht von einem Administrator zu diesem Layout hinzugefügt. Bitte kontaktieren Sie Ihren Sugar-Administrator.',
    'ERR_NO_PERMISSION_TITLE' => 'Bitte Zugriff erlauben',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} benötigt Kamerazugriff, damit Sie Fotos anhängen können. Bitte erlauben Sie den Kamerazugriff in den Systemeinstellungen.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'Einstellungen',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'Dauer',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'Verbleibende Zeit',
    'LBL_LIST_SUPPORT_EXPIRES' => 'Endet',
    'LBL_CASCADE_RLI_EDIT' => 'Offene Umsatzposten aktualisieren',
    'LBL_MOBILE_CALENDAR' => 'Kalender',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'Kalender Einstellungen',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'Starttag der Woche',
    'LBL_MOBILE_CALENDAR_MODULES' => 'Anzuzeigende Ereignisse',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}h:{{{minutes}}} Minuten',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} Stunden',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} Minuten',
    'LBL_MOBILE_CALENDAR_TODAY' => 'Heute',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => '{{{moduleName}}} neu erstellen',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'Aktivität planen',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'Bitte schalten Sie mindestens einen Ereignistyp frei.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'Ganztägig',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'Kalendar konnte nicht geladen werden.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'Diese Handlung ist in Sugar Mobile nicht verfügbar. Möchten Sie stattdessen die Desktop-Anwendung öffnen?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'Vorlage auswählen',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'Zusammenführen',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'Fehler: EXIF-Daten fehlen in der HEIC-Datei',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'Fehler: Bildauflösung zu hoch',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'Fehler: Das Bild kann nicht verarbeitet werden',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'Fehler: Das Bild konnte nicht auf die Leinwand übertragen werden',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'Fehler: Datei konnte nicht als Bild geladen werden',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1 Gegenstand ausgewählt',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} Gegenstände ausgewählt',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'Alle auswählen',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'Sie haben {{{count}}} Einträge in dieser Ansicht ausgewählt. Alle Einträge auswählen?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => '{{{count}}} Einträge auswählen',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'Möchten Sie die ausgewählten Einträge wirklich löschen?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'Löschen...{{{count}}} von {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'Keine gültige E-Mail in den ausgewählten Datensätzen gefunden',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'Aussehen',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'Systemeinstellung verwenden',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'Hell',
    'LBL_MOBILE_APP_THEME_DARK' => 'Dunkel',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'Neuer Dateiname',
    'LBL_ATTACHMENT_RENAME_MSG' => 'Datei umbenennen',
    // Filters related
    'LBL_CREATED_BY_ME' => 'Von mir erstellt',
    'LBL_OPERATOR_ONE_OF' => 'enthalten in',
    'LBL_OPERATOR_NOT_ONE_OF' => 'nicht enthalten in',
    'LBL_OPERATOR_CONTAINS' => 'ist einer von',
    'LBL_OPERATOR_CONTAINS_WORD' => 'enthält',
    'LBL_OPERATOR_NOT_CONTAINS' => 'ist keiner von',
    'LBL_OPERATOR_EMPTY' => 'ist leer',
    'LBL_OPERATOR_NOT_EMPTY' => 'ist nicht leer',
    'LBL_OPERATOR_MATCHES' => 'stimmt genau überein',
    'LBL_OPERATOR_STARTS_WITH' => 'beginnt mit',
    'LBL_OPERATOR_EQUALS' => 'ist gleich',
    'LBL_OPERATOR_NOT_EQUALS' => 'ist ungleich',
    'LBL_OPERATOR_GREATER_THAN' => 'ist größer als',
    'LBL_OPERATOR_LESS_THAN' => 'ist kleiner als',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'ist größer oder gleich',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'ist kleiner oder gleich',
    'LBL_OPERATOR_BETWEEN' => 'ist zwischen',
    'LBL_OPERATOR_BEFORE' => 'vor',
    'LBL_OPERATOR_AFTER' => 'nach',
    'LBL_OPERATOR_YESTERDAY' => 'gestern',
    'LBL_OPERATOR_TODAY' => 'heute',
    'LBL_OPERATOR_TOMORROW' => 'morgen',
    'LBL_OPERATOR_LAST_7_DAYS' => 'letzten 7 Tage',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'nächsten 7 Tage',
    'LBL_OPERATOR_LAST_30_DAYS' => 'letzten 30 Tage',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'nächsten 30 Tage',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'Vor mehr als __ Tagen',
    'LBL_OPERATOR_LAST_X_DAYS' => 'Letzte __ Tage',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'Nächste __ Tage',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'Mehr als __ Tage in der Zukunft',
    'LBL_OPERATOR_LAST_MONTH' => 'letzten Monat',
    'LBL_OPERATOR_THIS_MONTH' => 'diesen Monat',
    'LBL_OPERATOR_NEXT_MONTH' => 'nächsten Monat',
    'LBL_OPERATOR_LAST_YEAR' => 'letztes Jahr',
    'LBL_OPERATOR_THIS_YEAR' => 'dieses Jahr',
    'LBL_OPERATOR_NEXT_YEAR' => 'nächstes Jahr',
    'LBL_OPERATOR_IS' => 'ist',
    'LBL_OPERATOR_IS_NOT' => 'ist nicht',
    'LBL_OPERATOR_AFTER_TODAY' => 'nach dem heutigen Tag',
    'LBL_OPERATOR_BEFORE_TODAY' => 'vor dem heutigen Tag',
    'LBL_ERROR_FILTER_EMPTY' => 'Bitte fügen Sie Filterkriterien hinzu.',
    'LBL_ADD_FILTER' => 'Kriterien hinzufügen',
    'LBL_FILTER_NAME' => 'Filtername',
    'LBL_FILTER_FIELD' => 'Feld',
    'LBL_FILTER_OPERATOR' => 'Operator',
    'LBL_FILTER_VALUE' => 'Wert',
    'LBL_FILTER_SYNC_TO_SERVER' => 'In Desktop-App speichern',
    'LBL_FILTER_LOCAL' => 'Lokaler Filter',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'Willkommen bei {{{brandName}}}.<br/><br/> Erlauben Sie es uns, Ihnen einige der neuen Funktionen zu präsentieren...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'Hauptmenü-Navigation.',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'Verfügbare Aktionen per Ansicht.',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'Globale Suche nach Datensätzen.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'Filterung der Liste, um meine favorisierten Datensätze anzuzeigen.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'Filterung der Liste, um Datensätze anzuzeigen, die mir zugewiesen sind.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'Eintrag als Favorit markieren.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'Meine heute bevorstehenden Veranstaltungen.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'Zuletzt veränderte Berichte.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'Verfügbare Aktionen für den Datensatz.',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'Machen Sie das Meiste aus den neuen Funktionen!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'Dies ist das Plus-Menü.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'Plus-Menü schließen.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'Wählen Sie den spezifischen Vorgang aus, der anzeigt und ausgeführt werden soll.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'Dies ist das Startmenü.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'Startmenü schließen.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'Ansicht eines Moduls.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'Konfigurieren der Anwendung.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'Sugar im Webbrowser öffnen.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'Ihr Profil anzeigen.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'Das ist die Detailansicht.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'Die wichtigsten Informationen eines Datensatzes.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'Ansicht weiterer Informationen oder Bearbeiten eines Datensatzes.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'Verfügbare Aktionen für den Datensatz.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'Zu vorheriger Seite gehen.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'Der Zugriff auf die Tour ist jederzeit möglich.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'Zurück.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'Klicken, um den dazugehörigen Bericht zu öffnen.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'Einem Bericht folgen/nicht mehr folgen.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'Klicken, um Detailinformationen anzuzeigen.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'Hauptmenüansicht.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'Das Hauptmenü öffnet sich auf der linken Seite des Bildschirms.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'Detailansicht',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'Die Detailansicht öffnet sich auf der rechten Seite des Bildschirms.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'Verwenden Sie die Pfeile unten für eine kurze Tour durch die wichtigsten Komponenten dieses Menüs.',

    'LBL_COMMENT_ADD' => 'Kommentar hinzufügen',
    'LBL_REQUIRED' => 'Erforderlich',
    'LBL_MORE_BUTTON' => 'Mehr',
    'LBL_NO_OPTIONS' => 'Keine Optionen verfügbar',
    'LBL_TRY_AGAIN' => 'Wiederholen',
    'LBL_NEW_RECORDS' => 'Zuletzt erstellt',
    'LBL_ASSIGNED_TO_ME' => 'Mein {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'Alle {{{module}}}',
    'LBL_UNFAVORITE' => 'Unfavorite',
    'LBL_ACTIVITY_CREATE' => 'Erstellt {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => 'Aktualisierte {{{changes}}} in {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => '{{{relatedRecord}}} mit {{{record}}} {{{module}}} verknüpft',
    'LBL_ACTIVITY_UNLINK' => 'Verknüpfung von {{{relatedRecord}}} mit {{{record}}} {{{module}}} aufgehoben',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} für {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'Verknüpfte Datensätze herunterladen...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'Ihre Dashboard-Konfiguration wurde geändert. Möchten Sie sie erneut laden?',
    'LBL_RECORDS' => 'Datensätze',
    'LBL_DASHBOARDS' => 'Dashboards',
    'LBL_TEMPLATES' => 'Vorlagen',
    'LBL_NON_TEMPLATES' => 'Nicht-Vorlagen',
    'LBL_IS_TEMPLATE' => 'Ist Vorlage',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'Ihre Auswahl enthält Dashboard-Vorlagen, die nicht als Mehrfachauswahl aktualisiert werden können. Deaktivieren Sie bitte Vorlagen, um fortzufahren.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'Ihre Auswahl enthält Dashboard-Vorlagen, die nicht als Mehrfachauswahl gelöscht werden können. Deaktivieren Sie bitte Vorlagen, um fortzufahren.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => '{{searchCriteria}} suchen...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'Hauptmenü',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'Neuen Datensatz schnell erstellen',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'Für mehr Optionen wischen',
    'LBL_DETAILS' => 'Details',
    'LBL_DETAIL_RELATED' => 'Verknüpft',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'Dieses {{module}} erfordert ein {{relatedModule}}. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>Erstellen Sie einen {{relatedModule}} Datensatz</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'Datensatz bearbeiten',
    'LBL_OFFLINE_MENU_SETTINGS' => 'Offline-Einstellungen',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'Debug-Einstellungen',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'Gesamte Datensätze',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'Letzter Download',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'Datei konnte nicht heruntergeladen werden.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'Dashboards konnten nicht vom Server geladen werden',
    'ERR_FILTERS_FETCHING' => 'Ihre Filter konnten nicht abgerufen werden',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'Lokaler Speicher konnte nicht verschlüsselt werden',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'Offline-Daten werden verschlüsselt. Dies kann mehrere Minuten dauern.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'Offline-Datenverschlüsselung abgeschlossen.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'Sie haben keine Zugriffsberechtigung für das Modul {{{module}}}.',
    'LBL_SKIP' => 'Überspringen',
    'LBL_CONTINUE' => 'Weiter',
    'LBL_ENABLE' => 'Aktivieren',
    'LBL_MOBILE_TRIAL_UNTIL' => 'Demo-Version bis',
    'LBL_MOBILE_SDK_VERSION' => 'SDK-Version',
    'LBL_LOG_LEVEL' => 'Protokollstufe',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'Login-Einstellungen wurden neu konfiguriert.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'Ihre Testperiode ist abgelaufen.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'Sichere Verbindung wird vom Server nicht unterstützt. Bitte deaktivieren Sie die sichere Verbindung.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'Sichere Verbindung wird vom Server unterstützt. Bitte aktivieren Sie die sichere Verbindung.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'Ihre Verbindung ist nicht sicher. Bitte kontaktieren Sie Ihren Administrator.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'Login-Einstellungen',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'Richten Sie Ihre {{{brandName}}}-Instanz ein',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'Für die ordnungsgemäße Funktion der App müssen Sie die URL der Instanz {{{brandName}}} eingeben. Falls Sie die Instanz-URL nicht haben, kontaktieren Sie bitte Ihren Administrator.',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => 'Touch-ID',
    'LBL_ENABLE_TOUCHID' => '{{{biometryType}}} aktivieren',
    'LBL_SETUP_TOUCHID' => 'Einrichtung {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'Anmelden mit Ihrem Fingerabdruck',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} ist auf Ihrem Gerät nicht eingerichtet. \n\nÖffnen Sie die Geräteeinstellungen, um {{{biometryType}}} einzurichten. Nach der Einrichtung aktivieren Sie {{{biometryType}}} für {{{brandName}}} unter Hauptmenü > Einstellungen.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'Durch die Verwendung von {{{biometryType}}} mit {{{brandName}}} können Sie Ihren biometrischen Identifkator anstelle Ihres Passworts für den Zugriff auf {{{brandName}}} verwenden.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'Möchten Sie mit {{{biometryType}}} fortfahren?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'Passwort {{{brandName}}} eingeben, um {{{biometryType}}} zu aktivieren',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'Einrichtung',
    'LBL_MDM_CONFIRM_CHANGE' => 'Anwendungskonfiguration wurde vom Mobile Device Manager geändert. Bitte melden Sie sich erneut an, um die Änderungen anzuwenden.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'Bitte gewähren Sie {{{brandName}}} Zugriff auf Ihren Standort in den Geräteeinstellungen.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'Aktueller Standort ist nicht verfügbar',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "Zeitüberschreitung beim Abruf des aktuellen Standorts. \nBitte erneut versuchen.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'Standort-Ortsmarken sind nicht verfügbar',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'Standortkoordinaten sind ungültig',
    'ERR_MOBILE_INVALID_PASSWORD' => 'Ungültiges Passwort.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'Ihre Anwendung ist veraltet und nicht länger kompatibel mit der Instanz von {{{brandName}}}, mit der Sie sich verbinden. Möchten Sie sie aktualisieren?',
    'LBL_MOBILE_BY' => 'Nach',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'Dieser Filter ist offline nicht verfügbar',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'Offline-Datensätze',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'Einstellungen herunterladen',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'Ihre zugewiesenen, favorisierten und gefolgten Datensätze für den Offline-Zugriff herunterladen. Ihre Voreinstellungen können in den Offline-Einstellungen aktualisiert werden.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'Das Herunterladen Ihrer Datensätze ist abgeschlossen. Sie könenn jetzt im Offline-Modus darauf zugreifen.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "Nicht alle Datensätze wurden heruntergeladen. \n Möchten Sie es noch einmal versuchen?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'Mobildaten verwenden',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'Nicht jetzt',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'Der Download wurde angehalten, und wird fortgesetzt, wenn Sie die App wieder öffnen.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => '{{{module}}} {{count}} wird heruntergeladen',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'Neueste Datensätze aktualisieren',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'Warten auf Verbindung',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'Angehalten',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'Wird gestoppt',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'Herunterladen',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'Anhalten',
    'LBL_BULK_LOAD_BTN_RESUME' => 'Fortsetzen',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'Standardmäßig wird nur WiFi-Verbindung verwendet',
    'LBL_NPS_RATING_MSG' => "Wie bewerten Sie Ihre \n{{{productName}}} Erfahrung?",
    'LBL_NPS_THANKS_MSG' => 'Vielen Dank für Ihr Feedback!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'Würden Sie dies im App Store bewerten?',
    'LBL_NPS_NO_THANKS' => 'Nein, danke',
    'LBL_NPS_NOT_NOW' => 'Nicht jetzt',
    'LBL_NPS_RATE_NOW' => 'Jetzt bewerten',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'Netzwerk ist nicht verfügbar. Die App kann auch offline weiter verwendet werden',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'Ihre Änderungen werden synchronisiert, wenn Sie online sind. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>Siehe Details</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'Es gibt nicht synchronisierte Daten. Bitte überprüfen Sie das <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>Transaktionsprotokoll</a>',
    'LBL_CONVERT' => 'Konvertieren',
    'LBL_CONVERT_LEAD' => 'Interessent konvertieren',
    'LBL_SEARCH_EXISTING_RECORD' => 'Bestehenden {{{this}}} suchen',
    'LBL_DUPLICATES_CHECK_FAILED' => 'Duplikateprüfung fehlgeschlagen',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'Möchten Sie verbundene Aktivitäten zum Kontakt-Datensatz verschieben?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'Sie haben den Interessenten {{{name}}} erfolgreich konvertiert',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'Keine Duplikate gefunden.',
    'ERR_LEAD_CONVERSION_FAIL' => 'Interessenten-Konvertierung fehlgeschlagen',
    'LBL_SELECT_DUPLICATE_RECORD' => 'Aus Duplikat {{{modulePlural}}} auswählen',
    'LBL_SELECTED_EXISTING_RECORD' => '{{{moduleSingular}}} ausgewählt',
    'LBL_CREATED_NEW_RECORD' => '{{{moduleSingular}}} neu erstellt',
    'LBL_VO_BACK_BTN' => 'Schaltfläche „Zurück“',
    'LBL_VO_HOME_BTN' => 'Schaltfläche „Home“',
    'LBL_VO_DASHBOARD_BTN' => 'Schaltfläche „Dashboard“',
    'LBL_VO_SEARCH_BTN' => 'Schaltfläche „Suchen“',
    'LBL_VO_RIGHT_MENU_BTN' => 'Rechte Menü-Schaltfläche',
    'LBL_VO_ADD_BTN' => 'Schaltfläche „Hinzufügen“',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'Rabatt',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'Wählen Sie eine Mapping-App',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'Der ausgewählte {{entityName}} hat verknüpfte Werte: {{localizedFieldNames}}. "Abbrechen", um die bestehenden Werte zu erhalten. Bestätigen, um diese Werte zu überschreiben.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'Die Datenverschlüsselung ist aktiviert.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'Der ausgewählte Kontakt ist bereits konvertiert.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'Diese Aktion ist nur verfügbar, wenn das Gerät online ist',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'Möchten Sie wirklich eine Verkaufschance aus dem Angebot erstellen?',
    'LBL_TAG_ADD' => 'Tag hinzufügen',
    'LBL_TAG_ENTER_TAG_NAME' => 'Tag eingeben',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'Das Filtern nach Tags wird nicht unterstützt, wenn das Gerät offline ist.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'Gesamten Kommentar anzeigen',
    'LBL_COMMENT_VIEW' => 'Einen Kommentar ansehen',
    'LBL_PMSE_LABEL_DUEDATE' => 'Fälligkeitsdatum',
    'LBL_PMSE_DUE' => 'Fällig',
    'LBL_PMSE_DUE_ON' => 'Fällig am',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'Bitte erstellen Sie zuerst {{conversionParentModuleName}}',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'Fehlende erforderliche Datensätze: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'Wählen Sie die Bildqualität. Das Bild wird vor dem Speichern auf dem Server in der Größe entsprechend angepasst. Der gewählte Wert wird als Standard für alle ähnlichen Vorgänge in der Zukunft verwendet.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'Schätzen der Dateigröße…',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'Die geschätzte Dateigröße beträgt',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'Bildqualität',
    'LBL_IMAGE_QUALITY_BEST' => 'Originalgröße',
    'LBL_IMAGE_QUALITY_GOOD' => 'Gute Qualität',
    'LBL_IMAGE_QUALITY_POOR' => 'Kleine Größe',
    'LBL_IMAGE_QUALITY_BTN' => 'Kompression: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'Felder auflisten in {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'Zurücksetzen auf Standard',
    'LBL_LIST_NOT_ENOUGH' => 'Bitte stellen Sie mindestens 1 aktives Feld ein.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'Sie müssen sich anmelden und Berechtigungen akzeptieren, um mit der SugarCRM-Instanz arbeiten zu können.',
    'LBL_SELECTING_EXISTING_RECORD' => '{{{moduleSingular}}} wird ausgewählt',
    'LBL_CREATING_NEW_RECORD' => '{{{moduleSingular}}} wird neu erstellt',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'Bildgröße',
    'LBL_COPY_ADDRESS' => 'Adresse kopieren',
    'LBL_OPEN_IN' => 'Öffnen in',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'Keine Datei ausgewählt.',
    'LBL_ATTACHMENT_ADD' => 'Anhängen',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'Diese Anwendung verwendet Cookies',
    'LBL_USE_COOKIES_CONFIRM' => 'Diese Anwendung verwendet Cookies, um Ihnen eine bessere Erfahrung zu bieten. Wenn Sie fortfahren, stimmen Sie der Verwendung von Cookies gemäß unserer Datenschutzerklärung zu.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'Sie verwenden eine Sugar-Instanz, die in einer kommenden mobilen Version nicht mit Sugar Mobile kompatibel sein wird. Bitten Sie Ihren Administrator, Sugar so bald wie möglich zu aktualisieren.',
    'ERROR_TAG_NAME_INVALID' => 'Tag-Name darf keine "{{{forbiddenChars}}}"-Zeichen enthalten',
    'ERROR_NO_TAGS_FOUND' => 'Keine Tags verfügbar für "{{{searchQuery}}}"',
    'ERR_PA_RECORD_INVALID' => 'Der {{{moduleName}}}-Datensatz hat einen oder mehrere ungültige Werte und kann nicht gespeichert werden. Möchten Sie den Datensatz bearbeiten, um die Aktion {{{actionLabel}}} auszuführen?',
    'ERR_MOBILE_METADATA_RELOAD' => 'Ein Administrator hat Konfigurationsänderungen in Ihrer Sugar-Instanz vorgenommen. Drücken Sie OK, um die Konfiguration Ihrer App mit dem Server zu synchronisieren.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'Diese Anwendung verwendet Cookies',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'Zum Akzeptieren auswählen  (Erforderlich)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'Diese Anwendung verwendet Cookies, um Ihnen eine bessere Erfahrung zu bieten. Wenn Sie fortfahren, stimmen Sie der Verwendung von Cookies gemäß unserer <a href="{{href}}" target="_blank">Datenschutzerklärung zu</a> .',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'Die Datensatzansicht erlaubt es Ihnen, die Details eines Datensatzes anzuzeigen.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Notizen erlauben es, mit anderen Portal-Benutzern oder den Support-Mitarbeitern zusammenzuarbeiten.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'Klicken Sie hier, um eine Notiz zu diesem Datensatz anzulegen.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'Klicken Sie auf diese Symbole, um die Details der angehängten Notizen zu sehen.',

    //for portal
    'LBL_PORTAL_HOME' => 'Startseite des Dashboards',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'Alle offenen Tickets',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'Kürzlich gelöste Tickets',
    'LBL_PORTAL_SEARCH' => 'Suche nach Name, Nummer',
    'LBL_SIGNUP_BUTTON_LABEL' => 'Anmelden',
    'LBL_PORTAL_NO_EMAIL' => 'Haben Sie keine E-Mail erhalten?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'Ich habe das Passwort vergessen',
    'LBL_PORTAL_FORGOT_USERNAME' => 'Ich habe den Benutzernamen vergessen',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'Geben Sie Ihr Passwort zweimal ein. Die Passwörter müssen übereinstimmen.',
    'LBL_PORTAL_RESET_PASSWORD' => 'Passwort zurücksetzen',
    'LBL_PORTAL_REENTER_PASSWORD' => 'Passwort erneut eingeben',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'Die Passwörter stimmen nicht überein, bitte geben Sie sie erneut ein',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'Ihr Passwort wurde erfolgreich zurückgesetzt.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'Es ist ein Fehler aufgetreten. Bitte starten Sie eine neue Anfrage zum Zurücksetzen des Passworts.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'Registrieren',
    'LBL_PORTAL_SIGNUP_TITLE' => 'Vielen Dank für Ihre Registrierung',
    'LBL_PORTAL_SIGNUP' => 'Wir werden Sie informieren, nachdem wir Ihre Angaben bestätigt haben.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'Vorname',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'Nachname',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'Benutzername',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'E-Mail-Adresse',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (optional)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'Land',
    'LBL_PORTAL_SIGNUP_STATE' => 'Bundesland',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'Firmenname',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'Jobtitel (optional)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'Passwort',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'Passwort bestätigen',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'Ich habe die Anmeldedaten vergessen',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'Passwort vergessen?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'Bitte wenden Sie sich an Ihren Sugar-Administrator, um Ihr Passwort zurücksetzen zu lassen.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'Benutzername',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'Passwort',
    'LBL_PORTAL_LOADING' => 'Laden. Bitte warten...',
    'LBL_PORTAL_SAVING' => 'Speichern',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'Seite nicht verfügbar',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "Leider ist diese Funktion derzeit nicht verfügbar.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'Suchergebnisse für "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'Haben Sie keine E-Mail erhalten?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'Wenn Sie Hilfe benötigen oder mit uns Kontakt aufnehmen möchten, verwenden Sie bitte eine der folgenden Möglichkeiten:',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'Telefon: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'E-Mail: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'Website: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'Sind Sie sicher, dass Sie den Chat schließen möchten?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'Notiz erstellen oder Anhang hinzufügen',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'Notiz erstellen',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'Ihre Anmeldung ist fehlgeschlagen. Bitte versuchen Sie es erneut.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'Ungültige Daten',
    'LBL_PORTAL_INVALID_GRANT' => 'Ihre Sitzung ist abgelaufen. Melden Sie sich erneut an.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'Sitzung abgelaufen',
    'LBL_PORTAL_AUTH_FAILED' => 'Client-Authentifizierung fehlgeschlagen.',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'Ungültiger Client',
    'LBL_PORTAL_INVALID_REQUEST' => 'Die Anfrage ist ungültig. Bitte verständigen Sie den technischen Support.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'Ungültige Anfrage',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'Ihre Anfrage ist abgelaufen.',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'Anfrage abgelaufen',
    'LBL_PORTAL_UNAUTHORIZED' => 'Leider sind Sie nicht dazu autorisiert, auf diese Ressource zuzugreifen.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'Unauthorisiert',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'Resource nicht verfügbar.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'Verboten',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'HTTP-Methode hier nicht zugelassen. Bitte verständigen Sie Ihren Support.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP Error: Method Not Allowed',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'Anfrage-Fehler, fehlender/ ungültiger Parameter. Bitte verständigen Sie den technischen Support.',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'HTTP Error: 412',
    'LBL_PORTAL_MIN_MODULES' => 'Die müssen zumindest die Module "Tickets", "Fehler" und "Wissensdatenbank" aktivieren, um diese Anwendung zu verwenden.',
    'LBL_PORTAL_ERROR' => 'Fehler',
    'LBL_PORTAL_ROUTE_ERROR' => 'Fehler beim Laden des Moduls. Versuchen Sie es nochmal oder verständigen Sie Ihren Support.',
    'LBL_PORTAL_OFFLINE' => 'Das System ist momentan nicht verfügbar. Bitte kontaktieren Sie Ihren Systemadministrator.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'Passwort ändern',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'Der Benutzername ist bereits im System registriert. Bitten Sie um das Zurücksetzen des Passworts oder wählen Sie einen anderen Benutzernamen.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'Die angegebene E-Mail ist ungültig.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'Die Passwörter stimmen nicht überein.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'Service-Konsole',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'Überblick',
    'LBL_CASE_OVERDUE' => 'Überfällig',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'Standard-Dashboard wiederherstellen',
    'LBL_UNTITLED' => 'Unbenannt',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'Erneuerungen Konsole',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'Übersicht',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'Phase/Status',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'Name/Firmenname',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'Omnichannel-Dashboard',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'Kunde',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} um {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'SugerLive wird nicht von Ihrem Browser unterstützt. Verwenden Sie Google Chrome oder Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'Ein <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> wurde erstellt und enthält die Details Ihrer Unterhaltung.',
    'LBL_OMNICHANNEL_SUBJECT' => 'Betreff',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'Beschreibung',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'Nachrichtenzusammenfassung',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'Anrufzusammenfassung',
    'LBL_OMNICHANNEL_LINK_TO' => '{{fromModule}} mit {{toModule}} verknüpfen',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'Mit {{module}} verknüpfen',
    'LBL_OMNICHANNEL_LINKED' => 'Verknüpft',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'Ihr Browser unterstützt keinen Chat. Verwenden Sie Google Chrome oder Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Bitte wenden Sie sich für Hilfe an Ihren Sugar-Administrator.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'Layout konfigurieren',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'Bitte beenden Sie die Konfiguration von SugarLive, bevor Sie einen ausgehenden Anruf tätigen.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'Bitte schließen Sie die Konfiguration des SugarLive-Layouts ab, bevor Sie SugarLive öffnen.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'Stellen Sie sich in SugarLive auf "Offline", bevor Sie das SugarLive-Layout konfigurieren.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'Kompaktansicht',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'Vollansicht',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR-Dashboard',
    'LBL_SALES_MANAGER_CONSOLE' => 'Verkaufsleiter-Dashboard',
    'LBL_SALES_REP_CONSOLE' => 'Verkäufer-Dashboard',
    'LBL_MARKETING_CONSOLE' => 'Marketing-Dashboard',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'Kundenerfolg-Dashboard',
    'LBL_EXECUTIVE_CONSOLE' => 'Führungskraft-Dashboard',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'Tab auf Standard zurücksetzen',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'Zusammenfassungsfeld konfigurieren',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'Benutzerprofil',
    'LBL_WIZ_COMPLETE_TITLE' => 'Setup abgeschlossen',
    'LBL_SETUP_COMPLETE_INFO' => 'Sie können Sugar ab sofort verwenden!',
    'LBL_SETUP_USER_INFO' => 'Benutzerinformationen einrichten',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'Ländereinstellungen für Benutzer',
    'LBL_SETUP_USER_LOCALE_INFO' => 'Zeitzone, Datums- und Namenformat',
    'LBL_WIZ_START_SUGAR' => 'Sugar starten',
    'LBL_WIZ_FIRST_NAME' => 'Vorname',
    'LBL_WIZ_LAST_NAME' => 'Nachname',
    'LBL_WIZ_EMAIL' => 'E-Mail',
    'LBL_WIZ_TIMEZONE' => 'Zeitzone',
    'LBL_WIZ_TIMEFORMAT' => 'Zeitformat',
    'LBL_WIZ_DATE_FORMAT' => 'Datumsformat',
    'LBL_WIZ_NAME_FORMAT' => 'Standardformat für Namen',
    'LBL_SETUP_PROGRESS' => 'Setup-Fortschritt',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar-Training',
    'LBL_WIZ_DOCUMENTATION' => 'Dokumentation',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'Wissendatenbank',
    'LBL_WIZ_FORUMS' => 'Foren',
    'TPL_TIMEZONE_DIFFERENT' => 'Die Browserzeit stimmt nicht mit der gespeicherten Systemzeit überein {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'Anpassen der Zeitzone',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'Lokale Einstellungen',
    'LBL_WIZ_EMAIL_SETTINGS' => 'E-Mail-Einstellungen',
    'LBL_WIZ_IMPORT_DATA' => 'Daten importieren',
    'LBL_WIZ_CREATE_USERS' => 'Benutzer erstellen',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'Systemeinstellungen',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Studio',

    'LBL_CSP_ERROR_MESSAGE' => 'Die von Ihnen eingegebenen Werte werden nicht unterstützt oder stimmen nicht mit dem zulässigen Format überein. Eine Liste der zulässigen Feldwerte und Formate finden Sie in der <a href="{{linkToDocumentation}}" target="_blank">System</a>dokumentation.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'Dieser Inhalt wurde nicht genehmigt. Bitte aktualisieren Sie die <a href="{{linkToDocumentation}}" target="_blank">Einstellungen der Inhaltssicherheitsrichtlinie</a> Ihres Systems.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'Dieser Inhalt wurde nicht genehmigt. Bitten Sie Ihren Administrator, die <a href="{{linkToDocumentation}}" target="_blank">Einstellungen der Inhaltssicherheitsrichtlinie</a> Ihres Systems zu aktualisieren. Sobald die Einstellungen aktualisiert wurden, müssen Sie Ihren Browser aktualisieren, damit die Änderungen wirksam werden.',

    // For password related labels
    'LBL_PASSWORD' => 'Passwort',
    'LBL_CHANGE_YOUR_PASSWORD' => 'Ihr Passwort ändern',
    'LBL_PASSWORD_REQUIREMENTS' => 'Passwort-Anforderungen',
    'LBL_CURRENT_PASSWORD' => 'Aktuelles Passwort',
    'LBL_NEW_PASSWORD1' => 'Neues Passwort',
    'LBL_NEW_PASSWORD2' => 'Passwort bestätigen',
    'LBL_PASSWORD_CHANGED' => 'Sie haben Ihr Passwort erfolgreich geändert',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'Bitte bestätigen Sie Ihr neues Passwort.',
    'ERR_ENTER_NEW_PASSWORD' => 'Bitte geben Sie Ihr neues Passwort ein.',
    'ERR_ENTER_OLD_PASSWORD' => 'Bitte geben Sie Ihr altes Passwort ein.',
    'ERR_REENTER_PASSWORDS' => 'Die Passwörter müssen übereinstimmen',
    'ERR_PASSWORD_MISMATCH' => 'Das eingegebene Passwort stimmt nicht mit dem in unserem System gespeicherten überein.',
    'LBL_CANNOT_SEND_PASSWORD' => 'Das Passwort konnte nicht gesendet werden',
    'LBL_REQUEST_PASSWORD' => 'Passwort anfordern',
    'LBL_RESET_PASSWORD' => 'Passwort zurücksetzen',
    'LBL_RESET_PASSWORD_MESSAGE' => 'Geben Sie Ihren Benutzernamen ein und wir senden Ihnen einen Link zum Zurücksetzen Ihres Passworts.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Überprüfen Sie Ihren Posteingang <br><br> Wir haben Anweisungen zum Zurücksetzen des Passworts an die E-Mail-Adresse gesendet, 
        die wir gespeichert haben.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'Fehler: Es ist ein Problem beim Speichern des Passworts aufgetreten.',
    'LBL_INCORRECT_PASSWORD' => 'Fehler: Falsches Passwort.',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'Das eingegeben Passwort erfüllt die Passwortanforderungen nicht. Bitte versuchen Sie es erneut.',
    'LBL_PASSWORD_MIN_LENGTH' => 'Die Mindestlänge ist {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'Die Maximallänge ist {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'Muss einen Großbuchstaben (A-Z) enthalten.',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'Muss einen Kleinbuchstaben (a-z) enthalten.',
    'LBL_PASSWORD_ONE_NUMBER' => 'Muss eine Zahl (0-9) enthalten.',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'Muss ein Sonderzeichen (~!@#$%^&*()_+-={}|) enthalten.',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'Das Passwort darf nicht mit dem Muster für gängige Ausdrücke übereinstimmen: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'Spracheinstellung:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'E-Mail zum Zurücksetzen des Passworts konnte nicht gesendet werden.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'Wählen Sie einen Bericht',
    'LBL_REPORT_AUTO_REFRESH' => 'Auto-Aktualisierung',
    'LBL_REPORT_EDIT' => 'Ausgewählten Bericht bearbeiten',
    'LBL_REFRESH_LIST_AND_CHART' => 'Liste und Diagramm aktualisieren',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'Keine Tabelle verfügbar.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'Dieser Bericht enthält keine Filter.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'Sie haben nur Laufzeitfilter ausgeblendet, siehe Erweiterte Filter.',
    'LBL_RUNTIME_FILTERS' => 'Laufzeitfilter',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'Das Datum stimmt nicht mit dem bevorzugten Datumsformat des Benutzers überein: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'Dieses Dashlet hat keine Laufzeitfilter',
    'LBL_DASHBOARD_FILTER_GROUP' => 'Neuer Filter',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'Es muss mindestens ein Wert ausgewählt sein.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'Zurücksetzen auf Standardfilter',
    'LBL_COPY_FILTER_SUMMARY' => 'Filter Zusammenfassung kopieren',
    'LBL_APPLY_FILTERS' => 'Anwenden',
    'LBL_REPORTS_FILTERS' => 'Filter',
    'LBL_RUNTIME_FILTERS_INVALID' => 'Laufzeitfilter können aufgrund ungültiger Werte nicht angewendet werden',
    'LBL_RUNTIME_FILTERS_COPIED' => 'Die Filterzusammenfassung wurde in Ihre Zwischenablage kopiert.',
    'LBL_ADVANCED_FILTERS' => 'Erweiterte Filter',
    'LBL_ADVANCED_OR_DESC' => 'Einschließen, wenn JEGLICHE Bedingung erfüllt ist',
    'LBL_ADVANCED_AND_DESC' => 'Einschließen, wenn ALLE Bedingungen erfüllt sind',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'Dieser Filter ist ein Originalentwurf',
    'LBL_AND_UPPERCASE' => 'UND',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'Diese Funktion ist im Vorschaumodus nicht verfügbar',
    'LBL_REPORT_DEFAULT_NAME' => 'Unbenannter Bericht',
    'LBL_REPORT_QUERY' => 'Abfrage',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'Bezogen auf aktuellen Datensatz',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'Verknüpftes Feld',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'Verknüpftes Feld darf nicht leer stehen',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'Kein Bericht ausgewählt.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'Liniendiagramm ist mit diesem Bericht nicht kompatibel',
    'LBL_REPORT_DASHLET' => 'Berichte Dashlet',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'Datentabelle',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'Laufzeitfilter',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'Datentabelle-Vorschau',
    'LBL_REPORTS_DASHLET_CHART' => 'Diagramm',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'Diagrammvorschau',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'Filtervorschau',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'Der ausgewählte Bericht unterstützt kein Diagramm.',
    'LBL_REPORTS_DASHLET_LABELS' => 'Bezeichnungen',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'Gesamtzahl der Datensätze anzeigen',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'Sortierreihenfolge',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'Standard-Ansichtsauswahl',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'Sortierreihenfolge des primären Diagramms',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'Sortierreihenfolge des sekundären Diagramms',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'Keine {{module}}-Verknüpfungen zum ausgewählten Bericht',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'Für diesen Berichtstyp nicht verfügbar',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'Diese Funktion ist nur auf der Diagramm-Registerkarte verfügbar',
    'LBL_REPORTS_CHART_TYPE' => 'Diagrammtyp',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'Werte-Positionierung Balkendiagramm',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'Gesamtanzahl anzeigen',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'Legende einblenden',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'X-Achsen-Bezeichnung anzeigen',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Y-Achsen-Bezeichnung anzeigen',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Zeilen-Anzeigegrenze',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'Sie verfügen nicht über Berechtigungen zum Verwenden dieser Laufzeitfilter.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'Unbekannt',
    'ERR_HTTP_DEFAULT_TITLE' => 'Unbekannter Fehler',
    'ERR_HTTP_DEFAULT_TEXT' => 'Unbekannter Fehler.',
    'ERR_HTTP_DEFAULT_ACTION' => 'Zurück auf vorherige Seite.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'Fehler: Ungültige Anfrage',
    'ERR_HTTP_400_TEXT_LINE1' => 'Ihr Browser hat eine Anfrage gesendet, die der Server nicht verstanden hat.',
    'ERR_HTTP_400_TEXT_LINE2' => 'Bitte wenden Sie sich für weitere Details an Ihren Sugar-Administrator.',
    'ERR_HTTP_400_ACTION' => 'Zurück auf vorherige Seite.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'HTTP: 404 Nicht Gefunden',
    'ERR_HTTP_404_TEXT_LINE1' => 'Diese Seite existiert nicht oder Sie haben keine Zugangsberechtigung.',
    'ERR_HTTP_404_TEXT_LINE2' => 'Bitte versuchen Sie es erneut. Wenn der Fehler weiterhin auftritt, kontaktieren Sie bitte Ihren Sugar-Administrator.',
    'ERR_HTTP_404_ACTION' => 'Zurück auf vorherige Seite.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 Interner Serverfehler',
    'ERR_HTTP_500_TEXT_LINE1' => 'Der Server hat einen Fehler festgestellt und konnte Ihre Anforderung nicht ausführen.',
    'ERR_HTTP_500_TEXT_LINE2' => 'Bitte versuchen Sie es erneut. Wenn der Fehler weiterhin auftritt, kontaktieren Sie bitte Ihren Sugar-Administrator.',
    'ERR_HTTP_500_ACTION' => 'Bitte kontaktieren Sie den technischen Support.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 Interner Serverfehler',
    'ERR_HTTP_502_TEXT_LINE1' => 'Der Server hat einen temporären Fehler festgestellt und konnte Ihre Anforderung nicht ausführen.',
    'ERR_HTTP_502_TEXT_LINE2' => 'Bitte versuchen Sie es erneut. Wenn der Fehler weiterhin auftritt, kontaktieren Sie bitte Ihren Sugar-Administrator.',
    'ERR_HTTP_502_ACTION' => 'Bitte kontaktieren Sie den technischen Support.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 Interner Serverfehler',
    'ERR_HTTP_503_TEXT_LINE1' => 'Der Server konnte Ihre Anforderung nicht ausführen.',
    'ERR_HTTP_503_TEXT_LINE2' => 'Bitte versuchen Sie es später erneut. Wenn der Fehler weiterhin auftritt, kontaktieren Sie bitte Ihren Sugar-Administrator.',
    'ERR_HTTP_503_ACTION' => 'Bitte kontaktieren Sie den technischen Support.',

    'ERR_RENDER_FAILED_TITLE' => 'Ansichts-Darstellung fehlgeschlagen',
    'ERR_RENDER_FAILED_MSG' => 'Die Ansicht konnte nicht dargestellt werden',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'Feld-Darstellung fehlgeschlagen',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'Fehler beim Darstellen des Feldes: {0}.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'Zugriff verweigert',
    'ERR_NO_VIEW_ACCESS_REASON' => 'Sie haben nicht die entsprechenden Benutzerrechte um diese Seite zu sehen',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'Fragen Sie Ihren Admininstrator, um einen Zugriff zu erhalten.',
    'ERR_NO_VIEW_ACCESS_MSG' => 'Verständigen Sie Ihren Administrator, um den Zugriff auf das Modul {0} zu erhalten.',

    'ERR_LAYOUT_RENDER_TITLE' => 'Layout-Darstellung fehlgeschlagen',
    'ERR_LAYOUT_RENDER_MSG' => 'Oops! Die Darstellung ist fehlgeschlagen. Versuchen Sie es erneut oder verständigen Sie den Support.',
    'ERR_INTERNAL_ERR_MSG' => 'Interner Error',
    'ERR_GENERIC_TITLE' => 'Fehler',
    'ERR_CONTACT_TECH_SUPPORT' => 'Bitte kontaktieren Sie den technischen Support.',

    'LBL_SYNCED_RECURRING_MSG' => 'Dieser Datensatz kann nicht bearbeitet werden, da er von einem externen Client synchronisiert wird.',
    'LBL_EXISTING' => 'Bestehend',
    'LBL_PANEL_DEFAULT' => 'Standard',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'Fehlerhafte Antwort vom Server',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'Fehler beim Zuweisen.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'Sie haben keinen Zugriff auf "{{name}}". Bitte kontaktieren Sie ihren Administrator.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'Jahr {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Quartal {0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'Weitere Aktionen',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'Warnung',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'Duplikat ignorieren und Speichern',
    'LBL_RESTORE' => 'In Originalzustand versetzen',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'Für Löschung markierte Datensätze',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'Zeigt Datensätze im Zusammenhang mit einer Datenschutzanfrage für '
        . 'Informationen löschen.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS-Feed',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'Bleiben Sie auf dem Laufenden, indem Sie einen externen RSS- oder Bog-Feed hinzufügen.',
    'LBL_RSS_FEED_URL' => 'Feed-URL',
    'LBL_RSS_FEED_AUTHOR' => 'Autor:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'Anzahl der anzuzeigenden Einträge',
    'LBL_ERR_LOADING_RSS_FEED' => 'RSS-Feed konnte nicht geladen werden',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'Meine Elemente',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'Team-Elemente',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'Ermöglicht es Benutzern, Sugar-Apps zu einem Dashboard hinzuzufügen',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'Verlauf',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'Das Verlaufs-Dashlet zeigt alle durchgeführten Termine, gespeicherten Anrufe und gesendete und empfangene E-Mails.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'E-Mail',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'E-Mails',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'Mein Verlauf',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'Team-Verlauf',
    'LBL_UNASSIGNED' => 'Nicht zugewiesen',
    'LBL_ARCHIVE_EMAIL' => 'E-Mail archivieren',
    'LBL_EMAIL_ARCHIVED' => 'E-Mail archiviert',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'Archivierte E-Mail erstellen',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'Geplante Aktivitäten',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'Das Dashlet der geplante Aktivitäten zeigt alle Termine und Anrufe.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'Heute',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'Zukunft',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'Meine Aktivitäten',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'Team-Aktivitäten',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'Durchgeführt',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'Sind Sie sicher, dass Sie {0} als geschlossen markieren möchten?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'Aktive Aufgaben',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Zeigt alle ausstehenden und überfälligen Aufgaben an.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'Jetzt fällig',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'Bevorstehend',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'Zu tun',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'Abgeschlossen',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'Sind Sie siche, dass Sie {0} schließen möchten?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Meine Aufgaben',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team-Aufgaben',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'Es existiert eine weitere E-Mail-Adresse für den Datensatz, den Sie bearbeiten. Diese ist nun die primäre Adresse und wurde unten eingetragen.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'Inaktive Aufgaben',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Zeigt alle zurückgestellten und erledigten Aufgaben an.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'Zurückgestellt',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'Abgeschlossen',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'Letzte Änderung {{relativetime}} am {{date}} um {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Meine Aufgaben',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team-Aufgaben',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'Meine kürzlich angesehenen Tickets',

    'LBL_REPORT_DASHLET_TITLE_12' => 'Offene Tickets nach Benutzer und Status',
    'LBL_REPORT_DASHLET_TITLE_125' => 'Neue Tickets nach Geschäftszentrum und Woche',
    'LBL_REPORT_DASHLET_TITLE_126' => 'Kürzlich erstellte Tickets',
    'LBL_REPORT_DASHLET_TITLE_127' => 'Neue Tickets nach Kundenebene und Woche',
    'LBL_REPORT_DASHLET_TITLE_128' => 'Offene Tickets nach Kundenebene und Priorität',
    'LBL_REPORT_DASHLET_TITLE_129' => 'Gesamtzahl der in diesem Monat gelösten Tickets nach Geschäftszentrum',
    'LBL_REPORT_DASHLET_TITLE_130' => 'Gesamtzahl der in diesem Monat gelösten Tickets nach Agent',
    'LBL_REPORT_DASHLET_TITLE_131' => 'Liste der kürzlich gelösten Tickets',
    'LBL_REPORT_DASHLET_TITLE_132' => 'Meine in diesem Monat gelösten Tickets nach Woche',
    'LBL_REPORT_DASHLET_TITLE_133' => 'Meine Tickets, die heute fällig sind und die, die überfällig sind',
    'LBL_REPORT_DASHLET_TITLE_134' => 'Alle Tickets, die heute fällig sind und die, die überfällig sind',
    'LBL_REPORT_DASHLET_TITLE_135' => 'Meine offenen Tickets nach Nachverfolgungsdatum',
    'LBL_REPORT_DASHLET_TITLE_136' => 'Alle offenen Tickets nach Nachverfolgungsdatum',
    'LBL_REPORT_DASHLET_TITLE_137' => 'Meine offenen Tickets nach Status',
    'LBL_REPORT_DASHLET_TITLE_138' => 'Meine Tickets in der letzten Woche nach Status',
    'LBL_REPORT_DASHLET_TITLE_139' => 'Status der von mir zugewiesenen offenen Aufgaben',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP oder Alte REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron-Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar-Workflow',
    'LBL_AUDIT_SUBJECT_USER' => 'Benutzer',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web-2-Lead',

    //common chart strings
    'LBL_CHART' => 'Diagramm',
    'LBL_CHART_NO_DATA' => 'Keine Daten gefunden.',
    'LBL_CHART_LEGEND_CLOSE' => 'Legende ausblenden',
    'LBL_CHART_LEGEND_OPEN' => 'Legende einblenden',
    'LBL_CHART_CONTROLS_CLOSE' => 'Steuerung ausblenden',
    'LBL_CHART_CONTROLS_OPEN' => 'Steuerung einblenden',
    'LBL_CHART_UNDEFINED' => 'undefiniert',
    'LBL_CHART_NO_LABEL' => 'Undefiniert',
    'LBL_CHART_AMOUNT' => 'Betrag',
    'LBL_CHART_COUNT' => 'Zähler',
    'LBL_CHART_PERCENT' => 'Prozent',
    'LBL_CHART_GROUP' => 'Gruppe',
    'LBL_CHART_DATE' => 'Datum',
    'LBL_CHART_KEY' => 'Schlüssel',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'Diagrammtyp',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'Titel anzeigen',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'Gesamtanzahl anzeigen',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'X-Achsen-Bezeichnung anzeigen',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Y-Achsen-Bezeichnung anzeigen',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'Anzeigemethoden markieren',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'Markierungen umkehren',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'Markierungen staffeln',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'Markierungen drehen',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'Werte-Positionierung Balkendiagramm',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'Anzeigeoptionen für Balkendiagramm',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'Scrollen zulassen',
    'LBL_CHART_CONFIG_STACK_DATA' => 'Stapeldatenreihen',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'Leere Gruppen ausblenden',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'gesendet',
    'LBL_EMAIL_RECV' => 'rec',

    //record save
    'LBL_RECORD_SAVED' => 'Datensatz gespeichert.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => '{{moduleSingularLower}} Datensatz <a href="#{{buildRoute model=this}}">{{name}}</a> wurde gespeichert.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'Sie haben das {{moduleSingularLower}} erfolgreich erstellt.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'Der Datensatz wurde erfolgreich angelegt. Sie besitzen allerdings nicht über die benötigte Rolle um den Datensatz zu öffnen.', // use when user has no access to the model
    'LBL_VALIDATING' => 'Wird überprüft...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'Erfolg:',
    'LBL_ALERT_TITLE_WARNING' => 'Warnung:',
    'LBL_ALERT_TITLE_NOTICE' => 'Hinweis:',
    'LBL_ALERT_TITLE_ERROR' => 'Fehler:',
    'LBL_ALERT_TITLE_LOADING' => 'Laden',
    'LBL_ALERT_NO_ACCESS' => 'Sie haben keinen Zugriff auf den auf dieses Dashlet angewendeten Filter.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'Duplizieren Sie das Dashboard, um dieses Dashlet mit Ihrem eigenen Filter zu konfigurieren.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'Ihre Browserversion wird nicht mehr unterstützt oder Sie verwenden eine nicht unterstützten Browser.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'Unterstützte Plattformen',
    'LBL_ALERT_CONFIRM_DELETE' => 'Sind Sie sicher, daß Sie die Auswahl löschen möchten?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'Sind Sie sicher, daß Sie diese Elemente löschen möchten?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'Der markierte Datensatz wird folgende Werte überschreiben: {{values}}. Drücken Sie auf "Abbrechen", um die bestehenden Werte beizubehalten. Durch "OK" werden die Werte mit den neuen überschrieben.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'Der ausgewählte {{moduleSingularLower}} hat verknüpfte Werte: {{values}}. "Abbrechen", um die bestehenden Werte zu erhalten. Bestätigen, um diese Werte zu überschreiben.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'Von:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'An:',

    //organization chart
    'LBL_ORG_CHART' => 'Organisationsstruktur',
    'LBL_ORG_CHART_DESC' => 'Ansicht der Mitarbeiterstruktur des Unternehmens',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'Ausrichtung ändern',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'Alle Knoten anzeigen',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'An Fenstergröße anpassen',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'Ticket-Übersicht',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'Überblick der verknüpften Tickets.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'Zusammenfassung',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'Geschlossene Tickets',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'Offene Tickets',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'Top 10 der Umsatzposten',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'Top 10 der Umsatzposten als Blasendiagramm.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'Meine Elemente',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "Elemente in meinem Team",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'Standardfilter für Datum',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'Standard-Zeichensatz',

    'LBL_PRODUCT_CATALOG_NAME' => 'Produktkatalog',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'Produktkatalog',
    'LBL_PRODUCT_CATALOG_DESC' => 'Zeigen Sie Elemente aus Ihrem Produktkatalog an und fügen Sie welche hinzu.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'Zeigen Sie Elemente aus Ihrem Produktkatalog an und fügen Sie welche hinzu.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} am {{date}} um {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Geben Sie eine Notiz ein oder fügen Sie Anhänge durch Ziehen und Ablegen ein. Geben Sie @ ein, um einen Benutzer anzusprechen. Geben Sie # ein, um einen Datensatz zu referenzieren.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'Fügen Sie Ihre Kommentare hinzu und geben Sie @ ein, um einen Benutzer anzusprechen. Geben Sie # ein, um einen Datensatz zu referenzieren.',
    'LBL_ACTIVITY_STREAM' => 'Aktivitäten-Stream',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'Der Activity Stream ist nicht aktiviert',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'Der Aktivity Stream ist für dieses Modul nicht aktiviert',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'Weitere Posts anzeigen',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'an',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'Mein Activity Stream',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'Zeigen Sie eine Liste der Tätigkeiten an, die auf Datensätze angewendet wurden, und verfassen Sie Kommentare dazu.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'Activity Streams ist nicht aktiviert',

    'LBL_DATA_VIEW' => 'Datenansicht',
    'LBL_COMMENT' => 'Kommentar',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'Bei der Verbindung zum Server ist ein Fehler aufgetreten. Bitte nochmal versuchen.',
    'ERR_RESOLVE_ERRORS' => 'Bitte beheben Sie alle Fehler, bevor Sie fortfahren.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'Zum Genehmigen müssen alle Pflichtfelder ausgefüllt werden; allerdings können Sie diesen Datensatz noch „Ablehnen“ oder „Weiterleiten“.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'Zum Ablehnen/Weiterleiten müssen alle Pflichtfelder ausgefüllt sein.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'Liste aktualisieren',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'Kacheln aktualisieren',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'mehr',
    'LBL_TEXTAREA_LESS' => 'weniger',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} Anhänge',
    'LBL_CREATE_ATTACHMENT' => 'Anhang erstellen',
    'LBL_DASHLET_REFRESH' => 'Aktualisieren',
    'LBL_DASHLET_MOVE' => 'Verschieben',
    'LBL_DASHLET_CLOSE' => 'Schließen',

    'LBL_DASHLET_FORECAST_NAME' => 'In Prognose',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'Umsatzplanung Balkendiagramm ',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Umsatzplanung Balkendiagramm ',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'Umsatzplanung für',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'Zeigt die Umsatzplanung als Balkendiagramm für einen spezifischen Zeitraum an',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'Gruppieren nach',
    'LBL_DASHLET_FORECASTS_DATASET' => 'Datensatz',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'Prognosen-Details',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'Zeigt die aktuellen Umsatzplanungsdetails an.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'Gespeichertes Dashlet für grafische Berichte',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'Anzeige der Diagramme der bestehenden Berichte',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'Veröffentlichte Artikel dazu',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'Historische Zusammenfassung',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'Mehr Historie...',
    'LBL_RELATED_CONTACT' => 'Verknüpfter Kontakt',
    'LBL_MODULE_TYPE' => 'Typ',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'E-Mail an',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'E-Mail von',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'Ältere Module können nicht in der Vorschau angesehen werden',

    //SFA
    'LBL_BEST' => 'Bestens',
    'LBL_WORST' => 'Schlechtestens',
    'LBL_LIKELY' => 'Wahrscheinlich',
    'LBL_BEST_FORECAST' => 'Zusage (bestmöglich)',
    'LBL_WORST_FORECAST' => 'Zusage (schlimmstmöglich)',
    'LBL_LIKELY_FORECAST' => 'Zusage (wahrscheinlich)',
    'LBL_BEST_ADJUSTED' => 'Angepasste Zusage (bestmöglich)',
    'LBL_WORST_ADJUSTED' => 'Angepasstee Zusage (schlimmstmöglich)',
    'LBL_LIKELY_ADJUSTED' => 'Angepasste Zusage (wahrscheinlich)',
    'LBL_AMOUNT_USDOLLAR' => 'Konvertierter Betrag',
    'LBL_OVERDUE' => 'Überfällig',

    'LBL_PASSWORD_REQUEST_SENT' => 'Ihre Anfrage wurde gesendet.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'Es ist ein Problem bei der Abfrage von Benutzernamen und E-Mail-Adresse aufgetreten.',

    'LBL_REMINDER_TITLE' => 'Erinnerung',
    'LBL_CLICK_TO_DRILLDOWN' => 'Klicken für Drill-down',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'Es können nicht alle Sprachen deaktiviert werden.',

    'LBL_UPDATE_CALC_FIELDS' => 'Werte erneut berechnen',

    //Optimistic Locking
    'LBL_YOU' => 'Sie',
    'LBL_RESOLVE_CONFLICT' => 'Konflikte auflösen für {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'Für mehr Informationen siehe Dokumentation von {{{more_info_url}}} {{plural_module_name}}.{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'Keine Daten verfügbar',
    'LBL_NEED_HELP' => 'Brauchen Sie Hilfe bei etwas Neuem?',
    'LBL_NEW_CASE' => 'Neues Ticket',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'Das Hilfe-Dashlet stellt Ihnen Informationen zu dem Modul bereit, das Sie aktuell geöffnet haben, zusammen mit Verweisen auf die passende Dokumentation (z.B. zu Leads/Interessenten) im Anwendungshandbuch.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'Listenansicht-Hilfe',
    'LBL_HELP_RECORDS' => "Die Modulliste zeigt alle Datensätze an, die den aktuellen Suchkriterien entsprechen und auf die der Benutzer Zugriff hat. Die Basisinformationen können innerhalb der Liste eingesehen werden oder durch Klicken auf den Namen und Öffnen des Datensatzes.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'Datensatzansicht-Hilfe',
    'LBL_HELP_RECORD' => 'Die Datensatzansicht bietet umfassende Informationen über einen einzelnen Datensatz sowie einige Details der Datensätze, die mit ihm verknüpft sind.
- Bearbeiten Sie den Datensatz, indem sie auf ein Feld oder auf die Schaltfläche "Bearbeiten" klicken.
- Sehen Sie sich in der Vorschau Verknüpfungen zu anderen Datensätzen an. Klicken Sie im Sub-Panel entsprechend auf das Vorschausymbol klicken.
- Erstellen oder sehen Sie sich Benutzerkommentare und die Änderungshistorie verschiedener Datensätze an, indem Sie die Ansicht auf "Activity Stream" im unteren linken Bereich stellen. 
- Folgen Sie favorisierten Einträgen, indem Sie das Sternsymbol neben dem Namen oben anklicken. 
- Weitere Aktionen finden Sie im Ausklappmenü auf der rechten Seite der Schaltfläche "Bearbeiten".',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}} erstellen',
    'LBL_HELP_CREATE' => 'Um {{plural_module_name}} zu erstellen: 
1. Erfassen Sie alle relevanten Informationen. 
* Felder, die als Pflichtfeld markiert sind, müssen vor dem Speichern ausgefüllt werden.
* Klicken Sie auf "Mehr anzeigen", um weitere Felder zu erfassen. 
2. Drücken Sie auf "Speichern", um den Datensatz fertigzustellen und zurück zur Listenansicht {{plural_module_name}} zu wechseln.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'Mögliches Duplikat entdeckt',
    'LBL_HELP_DUPLICATE' => 'Sugar hat festgestellt, dass der Datensatz, den Sie versuchen, zu erstellen, bereits existiert. 

Wenn Sie einen vorhandenen Datensatz verwenden möchten, klicken Sie auf "Auswählen und Bearbeiten" rechts neben dem Eintrag. Alle leeren Felder des Datensatzes werden mit den von Ihnen eingegebenen Werten befüllt. Klicken Sie auf "Speichern", um die Änderungen zu speichern. 

Möchten Sie dagegen die neu eingegebenen Werte übernehmen, klicken Sie auf "In Originalzustand versetzen". Die eingegebenen Werte werden dann in den vorhandenen Datensatz übernommen und Sie können nun alle zusätzlichen Änderungen erfassen. Klicken Sie auf "Speichern" um die Änderungen am vorhandenen Datensatz abzuschließen. 

Um einen neuen Datensatz mit den eingegebenen Werten zu erstellen, klicken Sie auf "Duplizieren Ignorieren und Speichern" oben rechts auf dem Bildschirm.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'Fehlende SMTP-Einstellungen',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'Es müssen SMTP-Einstellungen unter {{emailSettingsUrl}} konfiguriert sein, um automatisch systemgenerierte Meldungen versenden zu können.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'E-Mail-Einstellungen',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'Neue Lagerberichte verfügbar',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'Neue Lagerberichte verfügbar in Ihrem ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'Berichtemodul',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'Sie werden als "Lagerbericht" gekennzeichnet und können gefiltert werden. Berichte werden je nach Inhalt auch als "Vertrieb und Marketing", "Kundendiesnt", "Datenschutz" oder "Administrativ" markiert. Weitere Informationen finden Sie in ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'Dokumentation',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'Mit Hilfe von Schnellzugriffen befähigt SugarCRM Poweruser, schnell bestimmte Aufgaben zu erledigen, um die Produktivität zu erhöhen.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => 'Text for Translation
<h1>Unterstützte Tasten</h1><ul><li>alel alphanumerischen Zeichen und Symbole</li><li>shift, ctrl, alt, Befehl, mod (ctrl in Windows/Linux und Befehl in Macs)</li><li>Eingabe, Esc, Leerzeichen, Tab, Seiteauf, Seiteab, Ende, home, ins, entf, backspace</li></ul><h1>Unterstützte Funktionen</h1><ul><li>Tastenkombination: ctrl+m</li><li>Mehrere Tasten: m,ctrl+m</li><li>Tastenfolge: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'Globale Schnellzugriffe',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'Kontextbezogene Shortcuts',
    'LBL_SHORTCUT_KEY_KEY' => 'Schlüssel:',
    'LBL_SHORTCUT_FUNCTION' => 'Name',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Kontextbezogene Shortcuts konfigurieren',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'Nicht kontextbezogene Shortcuts zu konfigurieren',
    'LBL_SHORTCUT_HELP' => 'Shortcuts Hilfeseite anzeigen',
    'LBL_SHORTCUT_QUICK_CREATE' => 'Das Schnellerstellungsmenü ein-/ausblenden',
    'LBL_SHORTCUT_SEARCH' => 'Das Feld für die globale Suche fokussieren',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'Seitenleiste ein-/ausblenden',
    'LBL_SHORTCUT_CREATE_RECORD' => 'Neuen Datensatz erstellen',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'Nächsten Datensatz selektieren',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'Vorherigen Datensatz selektieren',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'Liste nach links scrollen',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'Liste nach rechts scrollen',
    'LBL_SHORTCUT_OPEN' => 'Ausgewählten Datensatz öffnen',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'Ausgewählten Datensatz bearbeiten',
    'LBL_SHORTCUT_RECORD_DELETE' => 'Datensatz löschen',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Inline-Bearbeitung ohne Speichern beenden',
    'LBL_SHORTCUT_RECORD_SAVE' => 'Datensatz speichern',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'Änderungen am Datensatz löschen',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'Datensatz als Favorit markieren',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'Datensatz folgen',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'Datensatz als Vorschau anzeigen',
    'LBL_SHORTCUT_MARK_SELECTED' => 'Datensatzes als ausgewählt markieren',
    'LBL_SHORTCUT_SELECT_ALL' => 'Alle auswählen',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'Dropdownmenü "Massenaktion" öffnen',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'Liste der Filter-Felder aktivieren',
    'LBL_SHORTCUT_FILTER_CREATE' => 'Neuen Filter für Liste erstellen',
    'LBL_SHORTCUT_FILTER_EDIT' => 'Aktuellen Filter für Liste bearbeiten',
    'LBL_SHORTCUT_FILTER_SHOW' => 'Filtermenü öffnen',
    'LBL_SHORTCUT_RECORD_EDIT' => 'Datensatz bearbeiten',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'Vorherigen Datensatz öffnen',
    'LBL_SHORTCUT_RECORD_NEXT' => 'Nächsten Datensatz öffnen',
    'LBL_SHORTCUT_COPY_RECORD' => 'Aktuellen Datensatz kopieren',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'Primäres Aktions-Auswahlmenü öffnen',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'Fach schließen',
    'LBL_SHORTCUT_FILTER_ADD' => 'Weiteres Filterkriterium hinzufügen',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'Letztes Filterkriterium entfernen',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'Filter schließen',
    'LBL_SHORTCUT_FILTER_SAVE' => 'Filter speichern',
    'LBL_SHORTCUT_FILTER_DELETE' => 'Filter löschen',
    'LBL_SHORTCUT_FILTER_RESET' => 'Filter zurücksetzen',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'Zeile hinzufügen',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'Zeile entfernen',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'Massen-Update schließen',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'Datensätze aktualisieren',
    'LBL_CREATE_CATEGORY' => 'Eine <div class="btn-link" data-action="create-new"> Kategorie</div> erstellen',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'Bestätigen',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'Abbrechen',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'Wählen Sie alle Elemente in einem Mehrfachauswahl-Feld aus',
    'LBL_SHORTCUT_SWEETSPOT' => 'Sweet-Spot-Leiste ein-/ausblenden',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'Sweet-Spot-Leiste ausblenden',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'Konfiguration speichern',
    'LBL_SHORTCUT_RESTORE' => 'Standard wiederherstellen',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'Es ist ein Fehler beim Speichern der benutzerdefinierten Tastenkombinationen auf dem Server aufgetreten. Bitet versuchen sie es erneut.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}} Einstellungen',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}} Konfigurationseinstellungen wurden gespeichert.',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} Konfigurationsfehler',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} besitzt keine Konfigurationseinstellungen',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'Benutzer hat keinen Zugriff auf {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'Benutzer hat keinen Zugriff auf die Konfiguration der Einstellungen von {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'Die Datenbankeinstellungen für {{module}} müssen repariert werden',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'bis',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'Start- und Enddatum',

    'LBL_CALENDAR_START_DATE' => 'Startdatum',
    'LBL_CALENDAR_END_DATE' => 'Enddatum',
    'LBL_CALENDAR_DURATION' => 'Dauer',
    'LBL_CALENDAR_RECURRENCE' => 'Serienereignis',
    'LBL_CALENDAR_REMINDERS' => 'Erinnerungen',

    'LBL_CALENDAR_CUSTOM_DATE' => 'Benutzerdefiniertes Datum',
    'LBL_CALENDAR_REPEAT_TYPE' => 'Wiederholungstyp',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'Wiederholungsintervall',
    'LBL_CALENDAR_REPEAT_DOW' => 'Wiederholen an Wochentagen',
    'LBL_CALENDAR_REPEAT_ON' => 'Wiederholen am',
    'LBL_CALENDAR_REPEAT' => 'Wiederholen',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'Wiederholen bis',
    'LBL_CALENDAR_REPEAT_COUNT' => 'Ereignisse wiederholen',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'Auswahl wiederholen',
    'LBL_CALENDAR_REPEAT_DAYS' => 'Tag(e) des Monats',
    'LBL_CALENDAR_REPEAT_MONTH' => 'Monat(e) des Jahres',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'Ordnungszahl wiederholen',
    'LBL_CALENDAR_REPEAT_UNIT' => 'Einheit wiederholen',
    'TPL_REPEAT_INTERVAL' => 'Jede/n/s {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'Diese Serie verwendet eine Wiederholungsoption, die in Sugar nicht zur Verfügung steht, da die Serie von einem Kalenderclient synchronisiert wurde. Bitte bearbeiten Sie diese Serie in Ihrem Kalender-Client, wenn Sie sie an einem bestimmten Datum wiederholen möchten. Wenn Sie diese Serie in Sugar bearbeiten, wird "Wiederholung ein" auf "Keine" gesetzt.<br><br>Möchten Sie weitermachen?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'Änderungen an einem Serienereignis müssen am ersten Bericht der Serie durchgeführt werden.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'Wiederholungsregeln führen nicht zu einem Ereignis, das generiert wird.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'Teilnehmend',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'Abgelehnt',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'Vorläufig',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'Keine Antwort',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'Zeitplan nicht verfügbar',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'Verfügbare Ansichten',
    'LBL_CALENDAR_DASHLET_NAME' => 'Kalenderplaner',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'Standardansicht',
    'LBL_CALENDAR_MY_CALENDARS' => 'Meine Kalender',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'Benutzer- und Teamkalender',
    'LBL_CALENDAR' => 'Kalender',

    'LBL_CALENDAR_DAY' => 'Tag',
    'LBL_CALENDAR_WEEK' => 'Woche',
    'LBL_CALENDAR_MONTH' => 'Monat',
    'LBL_CALENDAR_YEAR' => 'Jahr',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99.',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'Fehler beim Abrufen des Zeitplans.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'Speichern und Einladungen senden',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'Status annehmen',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'Prozesse',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'Das Prozess-Dashlet zeigt die Vorlagen an, die im SugarBPM verwendet werden können.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'Prozessdefinitionen',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'Das Prozessdefinitions-Dashlet zeigt die Vorlagen an, die im SugarBPM verwendet werden können.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'Prozessdefinition erstellen',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'Prozessdefinitionen importieren',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'Prozess-Geschäftsregeln',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'Das Prozessgeschäftsregel-Dashlet zeigt die Vorlagen an, die im SugarBPM verwendet werden können.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'Prozess-Geschäftsregel erstellen',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'Prozess-Geschäftsregeln importieren',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'Prozess-E-Mail-Vorlagen',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'Das Prozess-E-Mail-Vorlagen-Dashlet zeigt die Vorlagen an, die im SugarBPM verwendet werden können.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'Prozess-E-Mail-Vorlage erstellen',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'Prozess-E-Mail-Vorlagen importieren',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'Bei der Entwicklung von Prozessen/Geschäftsregeln/E-Mail-Vorlagen in einer anderen Instanz von Sugar, empfehlen wir dringlichst, dass diese Instanz eine exakte Kopie Ihrer Produktionssysteme ist. Prozesse/Geschäftsregeln/E-Mail-Vorlagen, die in einer eigenständigen Sugar-Instanz erstellt wurden, funktionieren nach Abschluss des Imports möglicherweise nicht wie gewünscht. Prozesse/Geschäftsregeln/E-Mail-Vorlagen beruhen möglicherweise auf bestimmten, in Studio oder auf Anwendungsebene durchgeführten Änderungen, einschließlich, aber nicht beschränkt auf benutzerdefinierte Feldnamen, Dropdown-Werte, Datenbank-IDs, etc. Wenn diese Werte nicht mit denen aus der Instanz übereinstimmen, in der die Prozesse/Geschäftsregelen/E-Mail-Vorlagen erstellt wurden, müssen Sie die Prozesse/Geschäftsregeln/E-Mail-Vorlagen in der Ziel-Instanz möglicherweise manuell noch einmal erstellen.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'Möchten Sie diesen Import dennoch fortsetzen?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'Möchten Sie diesen Export dennoch fortsetzen?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'Die folgenden Dropdown-Felder enthalten ungültige Optionen.',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'Ausstehende Aktivitäten nach Prozess',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'Ausstehende Aktivitäten',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'Ausstehende Aktivitäten nach Prozess',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'Alle Prozesse',
    'LBL_RECORD_DASHBOARD' => 'Bericht-Dashboard',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'Prozessstatus-Zusammenfassung',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'Prozessstatus-Beschreibung',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'In Bearbeitung',
    'LBL_PMSE_COMPLETED_STATUS' => 'Abgeschlossen',
    'LBL_PMSE_CANCELLED_STATUS' => 'Storniert',
    'LBL_PMSE_TERMINATED_STATUS' => 'Beendet',
    'LBL_PMSE_ERROR_STATUS' => 'Fehler',
    'LBL_PMSE_SETTINGS' => 'SugarBPM-Einstellungen',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'Sind Sie sicher, dass Sie diesen Eintrag deaktivieren möchten?',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'Sind Sie sicher, dass Sie diesen Eintrag aktivieren möchten?',
    'LBL_PRO_DELETE_CONFIRMATION' => 'Sind Sie sicher, dass Sie diesen Eintrag löschen möchten?',

    'LBL_PRO_ENABLE' => 'Update in Bearbeitung',
    'LBL_PRO_DISABLE' => 'Update in Bearbeitung',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} ist an einem Prozess beteiligt und kann einige gesperrte Felder enthalten. Um den Datensatz zu bearbeiten, klicken Sie bitte hier {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'Dieses Feld ist gesperrt, weil es an einem laufenden Prozess beteiligt ist.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'Dieser Datensatz ist an einem Prozess beteiligt und kann einige gesperrte Felder enthalten.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'Geschäftszentrum',
    'LBL_BUSINESS_CENTER_ID' => 'ID des Geschäftszentrums',
    'LBL_BUSINESS_CENTER_NAME' => 'Name des Geschäftszentrums',

    'LBL_PLIS_ACTIVITIES' => 'Aktivitäten der gekauften Produkte',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(Neuer Tag)',
    'LBL_TAG_FETCH_ERROR' => 'Fehler beim Abrufen von Tags.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'Sugar 7 erfordert Javascript. Bitte aktivieren Sie Javascript, um Sugar 7 weiter zu verwenden.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'Serialisierung der serialisierten Daten konnte nicht aufgehoben werden',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'Serialisierung der serialisierten Daten konnte nicht aufgehoben werden, da sie Verweise zu Objekten oder Klassen enthalten',

    'LBL_FIELD_TRIMMED' => 'Feld wurde gekürzt, da die maximale Zeichenanzahl überschritten wurde.',
    'LBL_FIELDSIZE_OVERFLOW' => 'Feld überschreitet die maximale Zeichenanzahl.',
    'LBL_TINYMCE_TARGET_SAME' => 'Im selben Fenster',
    'LBL_TINYMCE_TARGET_NEW' => 'In neuem Fenster',

    'LBL_OUTBOUND_EMAILS' => 'E-Mail-Einstellungen',
    'LBL_OUTBOUND_EMAIL' => 'E-Mail-Einstellung',

    'LBL_EMAIL_PARTICIPANTS' => 'E-Mail-Teilnehmer',
    'LBL_EMAIL_PARTICIPANT' => 'E-Mail-Teilnehmer',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'Datenschutz',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'Datenschutz',
    'LBL_DATAPRIVACY_VIEW_PII' => 'Persönliche Info anzeigen',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'Zum Löschen markieren',
    'LBL_DATAPRIVACY_FIELDNAME' => 'Feld',
    'LBL_DATAPRIVACY_VALUE' => 'Wert',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'Geändert von',
    'LBL_DATAPRIVACY_SOURCE' => 'Quelle',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'Zuletzt aktualisiert',
    'LBL_DATAPRIVACY_PII' => 'Persönliche Info',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'Zum Löschen markieren',
    'TPL_DATAPRIVACY_PII_TITLE' => 'Persönliche Info für {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'Zeitmesser ändern',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'Nachrichten',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'In Ihre Zwischenablage kopiert!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'Konnte nicht in die Zwischenablage kopiert werden',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'Bestätigungs-Link kopieren',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'Zeitleiste',
    'LBL_NO_ACTIVITY' => 'Keine Aktivität',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}}-Zeitleiste',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'Mehr',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'Weniger',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'Die Zeitleiste zeigt die Bezugsdatensätze des aktuellen Datensatzes an und wählt Feldaktualisierungen im Laufe der Zeit aus.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'Mehr anzeigen...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'Weniger anzeigen...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'Keine Daten verfügbar',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'Modul nicht lizenziert.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'Aktive Abonnements',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'Dieses Dashlet kann nur für Module hinzugefügt werden, die mit einem einzelnen Konto verknüpft sind. Weitere Informationen finden Sie in der Dokumentation zum <a href={{linkToDocumentation}}>Dashlet der aktiven Abonnements</a>.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'Einkäufe anzeigen, die zu diesem verknüpften Konto gehören:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'Aktive Abonnements für ein bestimmtes Konto.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', Menge {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'Gesamt:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'Keine aktiven Abonnements',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'Dieses Dashlet benötigt {{module_name}}, um funktionieren zu können. Sprechen Sie mit Ihrem Administrator über die Aktivierung von {{module_name}}.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'Kaufverlauf',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'Alle Käufe für ein bestimtes Konto.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'Dieses Dashlet kann nur für Module hinzugefügt werden, die mit einem einzelnen Konto verknüpft sind. Weitere Informationen finden Sie in der Dokumentation zum <a href={{linkToDocumentation}}>Dashlet des Kaufverlaufs</a>.',
    'LBL_NO_PURCHASE_HISTORY' => 'Keine anzuzeigenden Käufe',
    'LBL_NO_PLIS' => 'Keine gekauften Produkte',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'Gesamt',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'Menge',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'Dieses Dashlet erfordert die Funktion von „Käufe“ und „Gekaufte Produkte“. Sprechen Sie mit Ihrem Administrtor über die Aktivierung von „Käufe“ und „Gekaufte Produkte“.',
    'LBL_SEARCH_PURCHASE_NAME' => 'Nach Kaufname suchen...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'Verwenden Sie Studio, um das Dashlet-Layout der Datensatzansicht zu bearbeiten. Gehen Sie dazu zu' .
        'Studio > {{module}} > Layouts > Datensatzansicht des Dashlets. <a href={{linkToStudio}}>In Studio bearbeiten</a>.',
    'LBL_SERVICE_LEVEL' => 'Service-Level',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'Nummer',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'Nachverfolgung',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'Priorität/Status',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'Betreff/Beschreibung',

//Service Duration
    'LBL_SERVICE_DURATION' => 'Servicedauer',
    'LBL_SERVICE_DURATION_VALUE' => 'Servicedauer-Wert',
    'LBL_SERVICE_DURATION_UNIT' => 'Servicedauer-Einheit',
    'LBL_LOCK_DURATION' => 'Dauer der Sperre',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Die Amazon Connect CCP konnte nicht geladen werden. Bitte' .
        'stellen Sie sicher, dass Sie einen ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">unterstützte Browser</a>. ' .
        'Wenn das Problem weiterhin besteht, wenden Sie sich bitte an Ihren Sugar-Administrator.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Ihr Sugar-Administrator hat Ihre Instanz nicht für Amazon Connect konfiguriert.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Die Verbindung mit Amazon Connect kann nicht hergestellt werden. Bitte wenden Sie sich an Ihren Sugar-Administrator, um Unterstützung zu erhalten.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'Unbekannt',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'Fokus-Drawer',
    'LBL_CLOSE_FOCUS_DRAWER' => 'Fokus-Drawer schließen',
    'LBL_EXTERNAL_GUESTS' => 'Externe Gäste',
    'LBL_MY_FAVORITE_TASKS' => 'Meine favorisierten Aufgaben',
    'LBL_RECORD' => 'Datensatz',

    'LBL_MY_TASKS' => 'Meine Aufgaben',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'Das Feld: {0} im Modul: {1} konnte nicht gefunden werden',
    'LBL_INTEGRATE_INVALID_PARAM' => 'Der Datensatz mit {0}: {1} im Modul: {2} konnte nicht gefunden werden',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'Es konnte keine Relation mit dem Namen: {0} gefunden werden',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'Ein Datenbankeintrag mit der ID: {0} mit {1}: {2} im Modul: {3} ist bereits vorhanden
',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'Software gelöscht (mit gelöschter Markierung = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'Es wurden mehrere Datenbankeinträge für {0} {1} auf Modul {2} gefunden. ' .
        'Bitte entfernen oder aktualisieren Sie die übereinstimmenden Datensätze entsprechend. Übereinstimmende Datensätze: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'Nächste Ausführung',
    'LBL_TIME_AWARE_TYPE' => 'Typ',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean-ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'Bezeichnung anzeigen',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'Datensatzansicht öffnen',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'Hinzufügen',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'Hilfe nicht verfügbar',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'Funktionen',
    'LBL_ACTIONBUTTON_FIELDS' => 'Felder',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'Feld auswählen...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Rollup',
    'LBL_ACTIONBUTTON_RELATED' => 'Verknüpft',
    'LBL_ACTIONBUTTON_SAVE' => 'Speichern',
    'LBL_ACTIONBUTTON_CANCEL' => 'Abbrechen',
    'LBL_ACTIONBUTTON_R_MODULE' => 'Verknüpftes Modul',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'Verknüpte Felder',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'Rollup-Modul',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'Rollup-Felder',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'Rollup-Funktion',
    'LBL_ACTIONBUTTON_MINIMUM' => 'Min.',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'Max.',
    'LBL_ACTIONBUTTON_AVERAGE' => 'Durchschnitt',
    'LBL_ACTIONBUTTON_SUM' => 'Summe',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'Datensatz zuweisen',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'E-Mail verfassen',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'Datensatz erstellen',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Dokument-Zusammenführung',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'URL öffnen',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'Bericht ausführen',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'Datensatz aktualisieren',
    'LBL_ACTIONBUTTON_ACTION' => 'Aktion',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'Zuweisen an',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'E-Mail an',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'PMSE verwenden',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'Vorlage',
    'LBL_ACTIONBUTTON_MODULE' => 'Modul',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'Anzeigeeinstellungen',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'Typ',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'Dropdown-Liste',
    'LBL_ACTIONBUTTON_BUTTON' => 'Schaltfläche',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'Schaltflächengruppe',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'Bezeichnung für Datensatz anzeigen',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'In Kopfzeile anzeigen',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'Beim Bearbeiten ausblenden',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'In Kopfzeile des Fokus-Dashboards anzeigen',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'Dashboard',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'Fokus-Dashboard-Kopfzeile',
    'LBL_ACTIONBUTTON_SIZE' => 'Größe',
    'LBL_ACTIONBUTTON_DEFAULT' => 'Standard',
    'LBL_ACTIONBUTTON_SMALL' => 'Klein',
    'LBL_ACTIONBUTTON_LARGE' => 'Groß',
    'LBL_ACTIONBUTTON_CALCULATED' => 'Berechnet',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'In PDF konvertieren',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Dokument-Zusammenführung',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'Vorschau',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'Eigenschaften',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'Bezeichnung',
    'LBL_ACTIONBUTTON_DESC' => 'Tooltip',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'Bezeichnung anzeigen',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'Symbol anzeigen',
    'LBL_ACTIONBUTTON_SCHEME' => 'Farbschema',
    'LBL_ACTIONBUTTON_ICON' => 'Symbol',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'Abhängig',
    'LBL_ACTIONBUTTON_DESIGN' => 'Layout-Konfiguration',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'Bei Fehler stoppen',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'Automatisch speichern',
    'LBL_ACTIONBUTTON_CONFIG' => 'Konfigurieren',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'Konfigurieren Sie vor dem Speichern bitte Ihre Aktionsschaltfläche.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'Konfigurationsschaltflächen',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'Automatisch erstellen',
    'LBL_ACTIONBUTTON_LINK' => 'Beziehung zum übergeordneten Element erstellen',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'Übergeordnete Werte kopieren',
    'LBL_ACTIONBUTTON_PRESET' => 'Feldwert(e) festlegen',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'Feldwert(e) aus dem übergeordneten Element kopieren',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'Auswählen...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'Von übergeordnetem Feld',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'Möchten Sie diese Schaltfläche wirklich löschen?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'Möchten Sie diese Aktion wirklich löschen?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'Ungültige Daten für Aktionsschaltfläche',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'Wählen Sie bitte vor dem Speichern ein Modul aus.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'Wählen Sie bitte vor dem Speichern einen Link aus. Falls kein Link verfügbar ist, deaktivieren Sie die Link-Option.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'Wählen Sie bitte vor dem Speichern einen Datensatz aus.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'Wählen Sie bitte vor dem Speichern eine Vorlage aus.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'Primär',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'Sekundär',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'Ozean',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'Pink',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'Armee',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'Türkis',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'Pazifik',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'Grün',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'Gelb',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'Orange',
    'LBL_ACTIONBUTTON_THEME_RED' => 'Rot',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'Koralle',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'Violett',
    'LBL_ACTIONBUTTON_FORMULA' => 'Formel',
    'LBL_ACTIONBUTTON_ACTIONS' => 'Aktionen',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'Fehler beim Validieren der Schaltflächendaten.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'Für Schaltflächen muss mindestens eine Bezeichnung oder ein Symbol festgelegt sein.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'Geben Sie bitte eine gültige Schaltflächenbezeichnung ein.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'Der Datensatz konnte aufgrund von fehlenden erforderlichen Werten nicht erstellt werden. Kontaktieren Sie bitte Ihren Administrator.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'Sie müssen mindestens zwei aktive Schaltflächen für diesen Schaltflächentyp besitzen.',
    'LBL_ACTIONBUTTON_RECORD' => 'Datensatzansichten',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'Aktionsmenüs',
    'LBL_ACTIONBUTTON_ORDER' => 'Reihenfolge',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'Listenansicht',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'Kopfzeile der Datensatzansicht',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'Datensatzansicht-Dashlet-Kopfzeile',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'Sub-Panels',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'Die Engine zur Ausführung von Aufgabensequenzen ist beim Ausführen der folgenden Aktionen fehlgeschlagen:',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'Aktion hinzufügen',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'Diese Aktion entfernen',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'Aktueller Benutzer',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'Dokumente zusammenführen',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'Dokumente in PDF zusammenführen',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'Unternehmensgröße',
    'LBL_HINT_COMPANY_INDUSTRY' => 'Branche',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'Branchenmarkierungen',
    'LBL_HINT_COMPANY_LOCATION' => 'Firmenstandort',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'Firmenbescheibung',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'Gründungsjahr',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Firmenprofil bei Facebook',
    'LBL_HINT_COMPANY_TWITTER' => 'Firmenprofil bei Twitter',
    'LBL_HINT_COMPANY_PIC' => 'Firmenlogo',
    'LBL_HINT_CONTACT_PIC' => 'Kontaktfoto',
    'LBL_HINT_COMPANY_WEBSITE' => 'Firmenwebsite',
    'LBL_HINT_PHOTO' => 'Link zum Foto',
    'LBL_HINT_JOB_2' => 'bisherige Tätigkeiten',
    'LBL_HINT_EDUCATION' => 'Ausbildung',
    'LBL_HINT_EDUCATION_2' => 'Zusätzliche Ausbildung',
    'LBL_HINT_TWITTER' => 'Twitter-Link',
    'LBL_HINT_FACEBOOK' => 'Facebook-Link',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS-Code',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC-Code',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'FY Ende',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'Jährliches einkommen',
    'LBL_HINT_PHONE_1' => 'Telefonnummer 1',
    'LBL_HINT_PHONE_2' => 'Telefonnummer 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'Tabellen verbinden',
    'LBL_HINT_FULL_NAME' => 'Vollständiger Name',
    'LBL_HINT_JOB_TITLE' => 'Job-Titel',
    'LBL_HINT_OFFICE_PHONE' => 'Telefon Büro',
    'LBL_HINT_MOBILE_PHONE' => 'MObiltelefon',
    'LBL_HINT_OTHER_PHONE' => 'Weiteres Telefon',
    'LBL_HINT_WEBSITE' => 'Website',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'Möchten Sie alle vorhandenen Daten in diesem Datensatz mit den neuen Daten aus Sugar Hint ersetzen?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'Möchten Sie das vorhandene Feld {{fieldName}} in diesem Datensatz mit dem neuen {{fieldName}} aus Sugar Hint ersetzen? ',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'Alle firmenbezogenen Daten werden entfernt. Wollen Sie wirklich fortfahren?',
    'LBL_HINT_COMPANY_LOGO' => 'Logo',
    'LBL_HINT_CONTACTS_AVATAR' => 'Foto',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint Firmensatz Markierungen',

    'LBL_HINT_LOADING' => 'Laden...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Sugar Hint wird deinstalliert, bitte warten',
    'LBL_HINT_VALUE_ERASED' => 'Wert gelöscht',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'Diese Informationen wurden aufgrund einer Datenschutzanfrage gelöscht',

    'LBL_HINT_UNINSTALL_TITLE' => 'Bitte wählen Sie eine der folgenden Deinstallierungsmöglichen:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Nur das Hint-Paket deinstallieren',
    'LBL_HINT_UNINSTALL_FULL' => 'Hint vollständig deinstallieren',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'Mit dieser Option wird die Hint MLP entfernt und alle aktiven Abonnements an Sugar Hint Insights werden deaktiviert. Die erneute Installation von Hint aktiviert automatisch die Abonnements erneut.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'Mit dieser Option wird eine vollständige Deinstallation von Hint vorgenommen, einschließlich der Entfernung von MLP und der Löschung aller Konfigurations- und Abonnementinformationen.',
    'LBL_HINT_UNINSTALL' => 'Deinstallieren',
    'LBL_HINT_UNINSTALL_HEADER' => 'Sugar Hint deinstallieren',
    'LBL_HINT_CANCEL' => 'Abbrechen',
    'LBL_HINT_UNINSTALL_WARNING1' => 'WARNUNG: Wählen Sie diese Option nur, falls Sie Hint in der Zukunft nicht mehr verwenden wollen. Bevor Sie die Deinstallation durchführen, erstellen Sie einen vollen Backup Ihrer Sugar-Datenbank und aktivieren Sie den Wartungsmodus in Sugar.',
    'LBL_HINT_UNINSTALL_WARNING2' => 'Siehe ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint Bedienungsanleitung ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'für weitere Einzelheiten zum Deinstallationsprozess.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Möchten Sie wirklich nur das Sugar Hint-Paket deinstallieren?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Möchten Sie Sugar Hint wirklich vollständig deinstallieren?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(HINWEIS: DIESE AKTION KANN NICHT RÜCKGÄNGIG GEMACHT WERDEN)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint Felder',
    'LBL_HINT_NO_RESULTS_MSG' => 'Keine Ergebnisse wurden gefunden.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'Basis-Layout des Hint-Panels',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'Konten',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'Kontakte',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'Interessenten',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'Erweitertes Layout des Hint-Panels',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'Arrangieren Sie die Felder, indem Sie sie innerhalb des Hint-Panel-Layoutbereichs mittels Drag & Drop verschieben.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'Ausführliche Anweisungen und eine Liste der Standardwerte finden Sie in der ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ', um die Standardeinstellungen wiederherzustellen für das',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'Modul.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'Möchten Sie wirklich die Standardeinstellungen für das Modul {{module}} wiederherstellen?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'Klicken Sie hier',
    'LBL_HINT_CONFIG_NAME' => 'Hint Bedienungsanleitung.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'Felder',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'Angereicherte Felder',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'In diesem Bereich werden alle Hint-Felder und Sugar-Felder aufgelistet, die von Hint angereichtert wurden. Hint-Felder sind mit einem Sternchen (*) markiert und können nur im Hint-Panel angezeigt werden, wenn sie angereichert wurden.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'Feldname',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'Angereichertes Feld',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'In Hint anzeigen',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Im Hint-Panel anzeigen',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'Zusätzliche Sugar-Felder',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'In diesem Bereich werden alle Sugar-Felder aufgelistet, die nicht von Hint angereichert wurden.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'Warnung.',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'Achtung: Sie sind dabei, sich mit dem Sugar Hint Insights Dienst zu synchronisieren. Alle nicht versendeten E-Mail-Nachrichten gehen verloren und bestehende Nachrichten vom Insights Dashlet werden gelöscht. Benachrichtigungen jeglicher Art werden wiederaufgenommen, nachdem die Synchronisierung abgeschlossen ist.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'Vorgeschlagene Firmen, die mit Ihrem {{_moduleSingular}} in Verbindung stehen, sind unten aufgelistet. Wählen Sie die Firmendaten, die angezeigt werden sollen.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'Kein Konto ausgewählt',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'Mehr als eine E-Mail gefunden, wählen Sie die E-Mails zum Importieren aus.',

    'LBL_HINT_HELP_MESSAGE1' => 'Hint konnte zu den eingegebenen Daten keine Übereinstimmungen im System finden.',
    'LBL_HINT_HELP_MESSAGE2' => 'Die besten Ergebnisse können in Hint mittels Eingabe des Names einer Person und der E-Mail-Adresse erzielt werden.',
    'LBL_HINT_HELP_MESSAGE3' => 'Die besten Ergebnisse können in Hint mittels Eingabe der URL des Unternehmens erzielt werden.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "Geben Sie den Firmennamen oder die Website Ihres {{_moduleSingular}} ein und Hint sucht nach weiteren Daten.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "Geben Sie die E-Mail-Adresse Ihres {{currentModule}} ein und Hint sucht nach zusätzlichen Daten.",

    'LBL_HINT_HISTORY_NONE' => 'Keine Daten für die Verlaufsansicht verfügbar',
    'LBL_HINT_HISTORY_TITLE' => 'Aktivitätenverlauf',

    'LBL_HINT_PREVIEW_TITLE' => 'Anreicherung der Daten',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Die Lizenz für Ihren Hint Service ist abgelaufen. Kontaktieren Sie Ihren SugarCRM-Administrator, um Ihre Lizenz zu erneuern.',
    'LBL_HINT_PREVIEW_QUESTION' => 'Möchten Sie sehen, was Hint für Sie und Ihre Firma tun kann? Kontaktieren Sie Ihren SugarCRM-Administrator und fügen Sie Hint hinzu.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'Kontoinformationen nicht gefunden',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'Angereicherte Daten gefunden - klicken Sie auf alle angereicherte Daten, um sie in Ihrem Datensatz zu speichern.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'Klicken Sie alle angereicherte Daten, um sie in Ihrem Datensatz zu speichern.',

    'LBL_HINT_CONTACTS_TITLE' => 'Verknüpfte Kontakte',
    'LBL_HINT_CONTACTS_NONE' => 'Keine verknüpfte Kontakte',

    'LBL_HINT_NEWS' => 'Neuigkeiten',
    'LBL_HINT_GENERAL' => 'Allgemein',
    'LBL_HINT_ALL_NEWS' => 'Alle Neuigkeiten',
    'LBL_HINT_FILTER_NEWS' => 'Neuigkeiten filtern',
    'LBL_HINT_FINANCIAL_NEWS' => 'Finanzen',
    'LBL_HINT_PERSONNEL_NEWS' => 'Personal',
    'LBL_HINT_PRESS_RELEASES' => 'Pressemitteilungen',
    'LBL_HINT_OTHER_NEWS' => 'Andere',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'Neue Artikel suchen',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'Keine Neuigkeien verfügbar',
    'LBL_NEW_NOTIFICATIONS' => 'Neue Benachrichtigungen',
    'LBL_HINT_DASHLET_ALLOWED1' => 'Sie müssen eine Sugar Hint-Lizens haben, um das Sugar Hint Insights Dashlet anzuzeigen. Fragen Sie Ihren Administrator, ob Sie eine Sugar Hint-Lizenz erhalten können.',

    'LBL_HINT_FOR' => 'Für',
    'LBL_HINT_WITH' => 'mit',
    'LBL_HINT_SHOW_ME' => 'Zeige mir:',
    'LBL_HINT_NOTIFY_ME_BY' => 'Benachrichtige mich mit:',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insights Präferenzzentrum',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'Optionstaste für Präferenzen',
    'LBL_HINT_PREFERENCES' => 'Präferenzen',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'Löschen deaktiviert, mindestens eine Präferenzerklärung erforderlich',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'Hinzufügen deaktiviert, Sie haben die maximale Anzahl von Präferenzerklärungen erreicht',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Im Sugar Hint Insights Dashlet miteinbeziehen',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'Pop-Up als Desktop Benachrichtigung',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'Die Benachrichtigungen müssen in allen Browsern und auf allen Desktop-Computern aktiviert sein, damit sie durchgängig angezeigt werden können.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Einige Browser, wie der Internet Explorer, unterstützen keine Benachrichtigungen. Benachrichtigungen können nicht aktiviert werden, wenn Sie einen Browser verwenden, der keine Benachrichtigungen unterstützt.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'Sofortige E-Mail-Warnung für jede Benachrichtigung senden',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'Tägliche E-Mail-Zusammenfassung senden',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'Wöchwentliche E-Mail-Zusammenfassung senden',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'Präferenzen konnten nicht gespeichert werden. Überprüfen Sie Ihre Systemverbindung und versuchen Sie es erneut.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'In einigen Pflichtfeldern fehlt ein Wert. Bitte überprüfen Sie Ihre Einstellungen und stellen Sie sicher, dass alle erforderlichen Felder ausgefüllt sind.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'Sie sind dabei, Browser-Benachrichtigungen für Sugar Hint Insights zu aktivieren. Klicken Sie auf Bestätigen, um fortzufahren. Ihr Browser fragt Sie dann nach Ihrer Erlaubnis, Benachrichtigungen empfangen zu dürfen.',
    'LBL_HINT_PUSH_ERROR' => 'Das Plugin für Push-Benachrichtigungen wurde für {{options.type}} ohne seine Abhängigkeiten registriert. Das Plugin wird nicht wie vorgesehen funktionieren. Bitte stellen Sie sicher, dass Sie einen Pfad zur Worker-Datei und eine Methode zum Speichern des Abonnements auf dem Server angeben.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'Hint-Benachrichtigungen für alle Benutzer aktivieren',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'Hint-Benachrichtigungen für alle Benutzer deaktivieren',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'WARNUNG: Bei der Deinstallation von Sugar Hint konnten die Benachrichtigungen nicht deaktiviert werden. Um die Benachrichtigungen zu deaktivieren, installieren Sie Sugar Hint 5.4.0 oder höher und führen Sie eine vollständige Deinstallation mit dem Sugar Hint Uninstaller durch, den Sie im Verwaltungsbereich von Sugar finden.',
    'LBL_HINT_ENRICH_ALL' => 'Alle anreichern',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'Hint-Lizenz erforderlich',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'Maps-Konfiguration',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'Geocoder-Protokoll-Viewer',
    'LBL_MAP_MAP' => 'Karte',
    'LBL_MAP_MAPS' => 'Karten',
    'LBL_MAP_GEOCODING_RECORD' => 'Geocode',
    'LBL_MAP_GEOCODE_SUCCESS' => 'Der Datensatz wurde erfolgreich geokodiert.',
    'LBL_MAP_LATITUDE' => 'Breitengrad',
    'LBL_MAP_LONGITUDE' => 'Längengrad',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'Suche nach Adresse...',
    'LBL_MAP_ALREADY_GEOCODED' => 'Der Aktuelle Datensatz wurde bereits geokodiert. Wollen Sie den Geocode dieses Datensatzes wirklich überschreiben?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'Manuelles Geokodieren',
    'LBL_MAP_POINT_COORDINATES' => 'Punktkoordinaten der Karte',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'Optimale Route wird berechnet...',
    'LBL_MAP_DIRECTIONS' => 'Wegbeschreibungen',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'Wegbeschreibungen beginnend vom aktuellen Benutzer',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'Wegbeschreibungen beginnend von diesem Datensatz',
    'LBL_MAPS_RADIUS_INPUT' => 'Radius (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'in einem Radius von der Postleitzahl',
    'LBL_MAPS_DISTANCE' => 'Entfernung',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'Postleitzahl',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'Ungültige Konfiguration',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong>Feldzuordnungen sind ungültig.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'Kartentyp',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'Zoom-Stufe',
    'LBL_MAPS_DASHLET' => 'Maps',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'Gekodierte(n) Datensatz(sätze) in der Karte anzeigen.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'Maps ist für dieses Modul nicht verfügbar. Bitte aktivieren Sie es in der Admin Konsole.',
    'LBL_MAP_MODULES' => 'Module',
    'LBL_MAP_FILTER_BY' => 'Filtern nach',
    'LBL_MAP_UNIT_TYPE' => 'Einheitsart',
    'LBL_MAP_UNIT_TYPE_MILES' => 'Meilen',
    'LBL_MAP_UNIT_TYPE_KM' => 'Kilometer',
    'LBL_MAP_ADDRESS' => 'Adresse',
    'LBL_MAP_NO_STARTING_POINT' => 'Der Startpunkt ist nicht geokodiert.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'Der Startpunktdatensatz ist nicht geokodiert.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'Einige der ausgewählten Datensätze sind nicht geokodiert und werden auf der Karte nicht angezeigt.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'Datensatz(sätze) ist(sind) nicht geokodiert. ',
    'LBL_MAPS_MODULE_FIELDS' => 'Modulfelder',
    'LBL_MAPS_SELECT_FIELD' => 'Feld auswählen',
    'LBL_MAPS_RELATE_RECORD' => 'Verknüfte Datensätze',
    'LBL_MAPS_MAPPING_TYPE' => 'Art der Kartierung',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'Keine geokodierten Datensätze',
    'LBL_MAPS_ADDRESS' => 'Adresse',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'Zugewiesener Benutzer',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'Für den eingegebenen Punkt gibt es keine Street Side View.',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> Datensätze sind für die Kartierung ungültig. Bitte entfernen Sie das Modul von der Liste.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'Schließen',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'Erweitern',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'Als PDF speichern',
    'LBL_MAPS_EMAIL_LINK' => 'E-Mail-Link',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'Sie müssen mindestens einen Datensatz mit Geocode haben.',
    'LBL_MAPS_GENERATING' => 'Karte wird generiert...',
    'LBL_MAPS_POINTS' => 'Markierungspunkte',
    'LBL_MAPS_POINT' => 'Punkt',
    'LBL_MAPS_TRAVEL_DETAILS' => 'Reisedetails',
    'LBL_MAPS_TOTAL_DISTANCE' => 'Entfernung insgesamt',
    'LBL_MAPS_TOTAL_DURATION' => 'Dauer Insgesamt',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'Dauer insgesamt ohne Verkehr',
    'LBL_MAPS_ITINERARY' => 'Reiseplan',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'Fahrtstrecke',
    'LBL_MAPS_TRAVEL_DURATION' => 'Reisedauer',
    'LBL_MAPS_TRAVEL_STEPS' => 'Schritte',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'Warnungen',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => '
Bing Maps unterstützen ein Maximum von 10 Standorten auf einer geteilten Karte. Bitte überprüfen Sie Ihre Auswahl.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'Maps Lizenz ist erforderlich',
    'LBL_MAPS_SHARE_HELLO' => 'Hallo,',
    'LBL_MAPS_SHARE_HEADER' => 'Sie haben eine Bing-Karte für die folgenden Punkte angefordert:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'Die folgende URL öffnet eine Karte mit den oben genannten Punkten auf Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Karte auf Bing Maps anzeigen',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'Für die angegebenen Wegpunkte wurde keine Route gefunden.',
    'LBL_MAPS_GEOCODE_STATUS' => 'Geocode-Status',
    'LBL_MAPS_GEOCODED' => 'Geokodiert',
    'LBL_MAPS_NOT_GEOCODED' => 'Nicht geokodiert',
    'LBL_MAPS_NOT_FOUND' => 'Ungültige Adresse',
    'LBL_MAPS_GEOCODING_FAILED' => 'Geokodierung fehlgeschlagen',
    'LBL_MAPS_QUEUED' => 'Warteschlange',
    'LBL_MAPS_REQUEUED' => 'In die Warteschleife zurückgesetzt',
    'LBL_MAPS_RELATED_RECORD' => 'Verknüfter Datensatz',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'Bericht anzeigen',
    'LBL_REPORT_DASHLET_DESC' => 'Einen gespeicherten Bericht anzeigen',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'Auf Dashlet-Standardwerte zurücksetzen',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'Auf Bericht-Standardwerte zurücksetzen',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'Ergebnisse aktualisieren',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'Tabelle in Zwischenablage kopieren',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'Diagramm herunterladen',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'Der Bericht für das Dashlet- {{label}} wurde bearbeitet und das Dashlet auf die Standardkonfiguration zurückgesetzt.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'Sie haben nicht die entsprechenden Benutzerrechte, um dieses Feld zu nutzen.',

    'LBL_INVALID_FORMULA' => 'Ungültige Formel',
    'LBL_RETURN_TYPE_MISSMATCH' => 'Funktionsrückgabetyp stimmt nicht überein',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'Vorhersage',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'Ideales Kundenprofil',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'Wochenvorhersage-Punktzahl schließen',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'Vorhersagewert',
    'LBL_AI_CONV_BIN_ACCURACY' => 'Vorhersage-Bin-Genauigkeit',
    'LBL_AI_CONV_MULTIPLIER' => 'Vorhersage-Multiplikator',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP-Wert',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP-Bin-Genauigkeit',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP-Multiplikator',
    'LBL_AI_NEW' => 'Neu',
    'LBL_AI_ENTERED' => 'Eingegeben',
    'LBL_AI_CREATED' => 'Erstellt',
    'LBL_AI_WEEK' => 'Woche',
    'LBL_AI_MONTH' => 'Monat',
    'LBL_AI_QUARTER' => 'Quartal',
    'LBL_AI_BYWEEK' => 'nach Woche',
    'LBL_AI_BYMONTH' => 'nach Monat',
    'LBL_AI_BYQUARTER' => 'nach Quartal',
    'LBL_AI_WEEKTREND' => 'Wöchentlicher Trend',
    'LBL_AI_MONTHLYTREND' => 'Monatlicher Trend',
    'LBL_AI_QUARTERTREND' => 'Quartalstrend',
    'LBL_AI_TREND' => 'Trend nach',
    'LBL_AI_TRENDS' => 'Trends nach',
    'LBL_AI_VELOCITY' => 'Geschwindigkeit',
    'LBL_AI_TOPX' => 'Top {X}',
    'LBL_AI_TIMESPAN' => 'Zeitspanne zwischen Stufen –',
    'LBL_AI_BUSINESSTREND' => 'mit Geschäftstrends',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Wir stellen Sugar Insights vor!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights nutzt quantitative Analysen, um neue Erkenntnisse über Ihre SugarCRM-Daten zu gewinnen. Bei Sugar sind wir immer auf der Suche nach neuen Wegen, um Ihnen zu helfen, das Beste aus Ihren Daten herauszuholen und fundierte Entscheidungen zu treffen. Und dies ist nur der Anfang dessen, was wir mit Sugar Insights anbieten möchten.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights nutzt quantitative Analysen, um neue Erkenntnisse über Ihre SugarCRM-Daten zu gewinnen.',
    'LBL_AI_FIRMO' => 'Firmografie',
    'LBL_AI_TOTALCOUNT' => 'Gesamtzahl der',
    'LBL_AI_DAYSFROMLATESTACT' => 'Tage seit letztem/letzter',
    'LBL_AI_DAYSSINCE' => 'Alter',
    'LBL_AI_FIELDISSET' => 'existiert',
    'LBL_AI_CONTACTCOMPLETENESS' => 'Vollständigkeit der Kontaktinformationen',
    'LBL_AI_CUTDATE' => 'Prognosezeitraum',
    'LBL_AI_FROMLASTCHANGE' => 'Tage seit der letzten Änderung des Funktionswertes',
    'LBL_AI_CALLSHELD' => 'Gesamtzahl der gehaltenen Anrufe',
    'LBL_AI_CALLSPLANNED' => 'Gesamtzahl der geplanten Anrufe',
    'LBL_AI_OUTBOUNDCALLS' => 'Gesamtzahl der ausgehenden Anrufe',
    'LBL_AI_INBOUNDCALLS' => 'Gesamtzahl der eingehenden Anrufe',
    'LBL_AI_AVGCALLDURATION' => 'Durchschnittliche Dauer der Anrufe',
    'LBL_AI_EMAILSARCHIVED' => 'Gesamtzahl der archivierten E-Mails',
    'LBL_AI_EMAILSREAD' => 'Gesamtzahl der gelesenen E-Mails',
    'LBL_AI_EMAILSSENT' => 'Gesamtzahl der gesendeten E-Mails',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'Gesamtzahl der Datensätze, bei denen das erwartete Abschlussdatum auf ein späteres Datum geändert wurde',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'Gesamtzahl der Datensätze, bei denen das erwartete Abschlussdatum auf ein früheres Datum geändert wurde',
    'LBL_AI_AMOUNTINCREASED' => 'Gesamtchancen, bei denen der Betrag erhöht wurde',
    'LBL_AI_AMOUNTDECREASED' => 'Gesamtchancen, bei denen der Betrag verringert wurde',

    // User last state
    'LBL_LAST_STATE' => 'Letzter Status',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'An DocuSign gesendet',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'Bearbeiten von Empfänger abbrechen',
    'LBL_RECIPIENT_ROLE' => 'Empfängerrolle',
    // Base sales stages
    'LBL_OPEN' => 'Öffnen',
    'LBL_CLOSED_WON' => 'Abgeschlossen gewonnen',
    'LBL_CLOSED_LOST' => 'Abgeschlossen verloren',
    'LBL_KIOSK_ADD_FILES' => 'Dateien hinzufügen',
    'LBL_KIOSK_ADD_DROP_FILES' => 'Hier Dateien hinzufügen oder ablegen',
    'LBL_KIOSK_CANCEL' => 'Abbrechen',
    'LBL_KIOSK_EDIT' => 'Bearbeiten',
    'LBL_KIOSK_EMAIL' => 'E-Mail',
    'LBL_KIOSK_FILES_UPLOADING' => 'Wird hochgeladen',
    'LBL_KIOSK_FILES_ERROR' => 'Anhang-Hochladen fehlgeschlagen',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'Anhang ist zu groß',
    'LBL_KIOSK_FILTER_SEARCH' => 'Suchen',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'Kiosk',
    'LBL_KIOSK_LANGUAGE' => 'Sprache',
    'LBL_KIOSK_LAST_UPDATED' => 'Zuletzt aktualisiert',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'Ansicht',
    'LBL_KIOSK_MENU' => 'Menü',
    'LBL_KIOSK_MOBILE_PHONE' => 'Mobiltelefon',
    'LBL_KIOSK_MY_ACTIVITIES' => 'Meine Aktivitäten',
    'LBL_KIOSK_MY_PROFILE' => 'Mein Profil',
    'LBL_KIOSK_NAME' => 'Name',
    'LBL_KIOSK_OFFICE_PHONE' => 'Bürotelefon',
    'LBL_KIOSK_ORGANIZATION' => 'Organisation',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'Zeilen pro Seite:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'Powered by SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'Änderungen speichern',
    'LBL_KIOSK_SHOW_HIDE' => 'Ein-/Ausblenden',
    'LBL_KIOSK_SIGN_IN' => 'Anmelden',
    'LBL_KIOSK_SIGN_OUT' => 'Abmelden',
    'LBL_KIOSK_SORT_BY' => 'Sortieren nach',
    'LBL_KIOSK_SUBMIT' => 'Absenden',
    'LBL_KIOSK_TIMEZONE' => 'Zeitzone',
    'LBL_KIOSK_ACTIVITY' => 'Aktivität',
    'LBL_KIOSK_NO_ACTIVITY' => 'Keine Aktivität zum Anzeigen',
    'LBL_KIOSK_OLDEST_FIRST' => 'Älteste zuerst',
    'LBL_KIOSK_NEWEST_FIRST' => 'Neueste zuerst',
    'LBL_KIOSK_SHOW_MORE' => 'Mehr anzeigen',
    'LBL_KIOSK_ADD_A_REPLY' => 'Eine Antwort hinzufügen',
    'LBL_KIOSK_REPLY_EMPTY' => 'Antwort darf nicht leer gelassen werden.',
    'LBL_KIOSK_NUM_MORE' => '{{num}} mehr',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'Willkommen',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'Greifen Sie schnell auf Ihre Ressourcen zu.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'Fälle suchen',
    'LBL_KIOSK_SHOW_ALL' => 'Alle zeigen',
    'LBL_KIOSK_404_TITLE' => 'Wir konnten das nicht finden',
    'LBL_KIOSK_TENANT_404_TITLE' => 'Mandant nicht gefunden',
    'LBL_KIOSK_404_MESSAGE' => 'Sie haben auf einen Link geklickt, der entfernt wurde oder vorübergehend nicht verfügbar ist, oder Sie haben eine ungültige URL eingegeben.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'Bitte stellen Sie sicher, dass Sie die richtige URL haben. Für weitere Unterstützung wenden Sie sich bitte an den Kundendienst.',
    'LBL_KIOSK_BACK_TO_HOME' => 'Zurück zur Startseite',
    'LBL_KIOSK_ERROR_CODE' => '{code} Fehler: ',
    'LBL_KIOSK_401_TITLE' => 'Unauthorisiert',
    'LBL_KIOSK_401_MESSAGE' => 'Sie haben nicht die Rechte, diese Seite anzuzeigen.',
    'LBL_KIOSK_403_TITLE' => 'Unauthorisiert',
    'LBL_KIOSK_403_MESSAGE' => 'Sie haben keinen Zugang, um diese Seite anzuzeigen.',
    'LBL_KIOSK_500_TITLE' => 'Server antwortet nicht',
    'LBL_KIOSK_500_MESSAGE' => 'Irgendetwas ist bei uns schief gelaufen.',
    'LBL_KIOSK_GO_BACK' => 'Zurück',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'Doppelter Datensatz gefunden',
    'LBL_KIOSK_ACCOUNT' => 'Konto',
    'LBL_KIOSK_STATUS' => 'Status',
    'LBL_KIOSK_DEACTIVATE' => 'Deaktivieren',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'Benutzer wurde deaktiviert',
    'LBL_KIOSK_MANAGE_USERS' => 'Benutzer verwalten',
    'LBL_KIOSK_LAST_LOGIN' => 'Letzte Anmeldung',
    'LBL_KIOSK_FIRST_NAME' => 'Vorname',
    'LBL_KIOSK_LAST_NAME' => 'Nachname',
    'LBL_KIOSK_ROLE' => 'Rolle',
    'LBL_KIOSK_INVITE' => 'Einladung',
    'LBL_KIOSK_SEND_INVITES' => 'Einladung(en) senden',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'Einladung(en) erfolgreich gesendet',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'Einladung(en) nicht gesendet',
    'LBL_KIOSK_REACTIVATE' => 'Reaktivieren',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'Benutzer wurde reaktiviert',
    'LBL_KIOSK_RESET_PASSWORD' => 'Passwort zurücksetzen',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'E-Mail zum Zurücksetzen des Passworts gesendet',
    'LBL_KIOSK_USER_PROFILE' => 'Benutzerprofil',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'Ihr Benutzer wurde deaktiviert. Wenden Sie sich bitte an Ihren Administrator.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'Zurück zur Anmeldung',
    'LBL_KIOSK_REVOKE_INVITATION' => 'Einladung widerrufen',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'Einladung erfolgreich widerrufen',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'Suchen und auswählen ...',
    'LBL_KIOSK_NO_MATCHES' => 'Keine Treffer gefunden',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'Ihr Profil wurde aktualisiert.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'Fehler beim Aktualisieren Ihres Profils.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'Dokumente',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'Sehen Sie Ihre eingehenden geteilten Dokumente an, durchsuchen und laden Sie sie herunter.',
    'LBL_KIOSK_CASES' => 'Fälle',
    'LBL_KIOSK_CASES_DESC' => 'Sehen Sie mit Ihnen geteilte Fälle an, durchsuchen und beantworten Sie sie.',
    'LBL_KIOSK_DOWNLOAD' => 'Herunterladen',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'Datei erfolgreich heruntergeladen',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'Erste Schritte',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'Damit wir Ihnen besser helfen können, teilen Sie uns bitte Ihren Vor- und Nachnamen mit.',
    'LBL_KIOSK_SAVE' => 'Speichern',
    'LBL_KIOSK_SHARED' => 'Geteilt',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'Willkommen {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'Hintergrundfarbe',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'URL des Hintergrundbildes',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'Es wird empfohlen, ein Bild mit einer Dateigröße von weniger als 400 KB zu wählen.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'Hintergrundtyp',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'Hintergrund der Startseite',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'Design',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'Primäre Designfarbe',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'App-Name',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'Dies ist der Titel Ihrer Anwendung. Er wird neben Ihrem Logo angezeigt.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'URL des App-Logos',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'Es wird empfohlen, ein Logo auszuwählen, das bei kleiner Größe (z. B. Social-Media-Profile) am besten sichtbar ist. Es wird auch empfohlen, eine Datei auszuwählen, die kleiner als 200 KB ist.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'App-Favicon-URL',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'Ein Favicon ist ein kleines Logo, das neben dem Seitentitel in einem Browser-Tab angezeigt wird.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'Offene Aktivitäten automatisch neu zuweisen',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'Benutzerlimit erreicht',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'Ungültiger Lizenzschlüssel',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'Ungültige Bewerbung',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'Ungültige Bewerbung',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'Beschädigter Validierungsschlüssel',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'Lizenz abgelaufen',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'Fehlende Informationen',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'Fehlender Validierungsschlüssel',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'Fehlender Benutzerzugriff',
    'LBL_DRI_WORKFLOW' => 'Smart Guide',
    'LBL_DRI_WORKFLOWS' => 'Smart Guides',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Smart Guide Stufenvorlage',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Smart Guide Stufenvorlagen',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Smart Guide Vorlage',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Smart Guide Aktivitätsvorlage',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'Aktivitätsvorlagen',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'Web-Hooks',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Web-Hooks',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'Aktuelle Smart Guide Aktivität unter',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate Web-Hooks',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate Web-Hook',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar-Aktionen',
    'LBL_CJ_FORMS' => 'Smart Guide Sugar-Aktionen',
    'LBL_CJ_FORM' => 'Smart Guide Sugar-Aktion',
    'LBL_DRI_SUBWORKFLOW' => 'Smart Guide Stufe',
    'LBL_DRI_SUBWORKFLOWS' => 'Smart Guides Stufen',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Smart Guide Aktivitätsvorlagen',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Smart Guide Vorlagen',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Smart Guide Bestellung',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Smart Guide Aktuelle Bestellung',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Smart Guide Punktzahl',
    'LBL_CJ_MOMENTUM_POINTS' => 'Smart Guide Momentum Punkte',
    'LBL_CJ_MOMENTUM_SCORE' => 'Smart Guide Momentum Punktzahl',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Smart Guide Aktivität erlauben nach',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Smart Guide Fortschritt',
    'LBL_CJ_MOMENTUM_RATIO' => 'Smart Guide Momentum Verhältnis',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Smart Guide Punkte',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Smart Guide Aufgabe',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Smart Guide übergeordneter Aktivitätstyp',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Smart Guide blockiert durch',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'Smart Guide blockiert durch Stufen',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Smart Guide übergeordnete Aktivitäts-ID',
    'LBL_START_NEXT_JOURNEY_ID' => 'Nächste Smart Guide-ID starten',
    'LBL_CJ_URL' => 'Smart Guide URL',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Ist übergeordnete Smart Guide Aktivität',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Smart Guide Momentum Startdatum',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Smart Guide Momentum Enddatum',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'Widget-Layout-Konfiguration',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'Widget-Layout-Konfiguration',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'Maximale Anzahl intelligenter Hilfslinien aus derselben Vorlage',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'Aktiv',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'Archiviert',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'Anzeigen',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'Ausblenden',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'Vertikaler Modus',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'Horizontaler Modus',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ungültige Lizenz',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} hat {{assigned_user}} die folgenden Smart Guide Aktivitäten zugewiesen.</p>
    <ul>{{activities}}</ul>
    
    <p>Sie können diese Aktivitäten hier einsehen:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ungültige Lizenz',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'Das Benutzerlimit ist erreicht, Sie haben {{gracePeriodDays}} Tage Zeit, um die Lizenz zu aktualisieren.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - Zugewiesene Smart Guide Aktivitäten',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Ihr Sugar Automate Benutzerlimit von {0} wurde überschritten<br>
    <br>
    Bitte kontaktieren Sie <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> , um das Benutzerlimit zu erhöhen oder die Anzahl der Benutzer zu verringern, die das Plugin verwenden.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate Benutzerlimit erreicht',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Ihre Sugar Automate Lizenz läuft in {0} Tagen ab. <br>
    <br>
    Bitte wenden Sie sich an SugarCRM oder Ihren Sugar-Partner, um den Service zu erneuern und eine Unterbrechung zu verhindern.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate Lizenz läuft bald ab',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'Webhook testen',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide-Fortschritt',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Zeigt das Sugar Automate-Kreisdiagramm „Smart Guide-Fortschritt“ an.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'Zeigt die Webhook-Antwort an',
    'LBL_DASHLET_SEND_LABEL' => 'Anfrage senden',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'Mir zuweisen',
    'LBL_COMPLETE_BUTTON_TITLE' => 'Abgeschlossen',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'Alle Aufgaben abschließen',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'Stufe löschen',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'Start',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'Nicht zutreffend',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'Stufe hinzufügen',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'Ansicht',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Smart Guide bearbeiten',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'Abbrechen',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'Archivieren',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'Archivierung aufheben',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'Vorlage konfigurieren',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'Aufgabe hinzufügen',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'Meeting planen',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'Anruf planen',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'liegt in der Zukunft',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'ist überfällig',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'ist heute',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'ist morgen',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'Sind Sie sicher, dass Sie diesen Smart Guide löschen möchten?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'Sie sind im Begriff, alle Aufgaben abzuschließen. Möchten Sie wirklich fortfahren?',
    'LBL_CJ_BLOCK_BY' => 'Sie haben eine ungelöste, abhängige Aufgabe: {{Name}}. Bitte erledigen Sie diese Aufgabe, bevor Sie alle Aufgaben abschließen.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'Sie haben mehrere ungelöste, abhängige Aufgaben. Bitte erledigen Sie diese Aufgaben, bevor Sie alle Aufgaben abschließen.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'Sie haben alle Aufgaben erfolgreich abgeschlossen',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'Sind Sie sicher, dass Sie diesen Smart Guide archivieren möchten?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'Sind Sie sicher, dass Sie die Archivierung dieses Smart Guide aufheben möchten?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Smart Guides (Focus Drawers & Konsole)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'Aktive Smart Guides in der Service-/Erneuerungs-Konsole und im Focus Drawer Dashboard anzeigen',
    'LBL_CJ_PROCESSING_REQUEST' => 'In Bearbeitung..',
    'LBL_CJ_SUCCESS' => 'Sie haben alle Aufgaben erfolgreich abgeschlossen',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module} Modul ist nicht aktiviert',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'Alle Anzeigeeinstellungen werden gespeichert.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Smart Guide Momentum',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Zeigt die Sugar Automate "Smart Guide Momentum"-Anzeige an.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide-Fortschritt',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Zeigt das Sugar Automate-Kreisdiagramm „Smart Guide-Fortschritt“ an.',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'Übergeordnetes Element konnte nicht gefunden werden',
    'CJ_NOT_FOUND_EXCEPTION' => '{moduleName} mit {data} konnte nicht gefunden werden',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'Smart Guide muss vor der Archivierung abgeschlossen oder abgebrochen werden',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate ist in der aktuellen Sugar-Lizenz nicht aktiviert',
    'LBL_ACTION_NOT_FOUND' => 'Aktion nicht gefunden, wenden Sie sich an den Systemadministrator',
    'LBL_CJ_SELECT_FIELD' => 'Feld auswählen',
    'LBL_CJ_SELECT_OPERATOR' => 'Operator auswählen',
    'LBL_CJ_SELECT_VALUE' => 'Wert auswählen',
    'LBL_CJ_ENTER_VALUE' => 'Wert eingeben',
    'LBL_CJ_FORM_BATCH_TITLE' => 'Datensatz wird gespeichert',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'Aktive Smart Guides erkannt...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'Aktive Sugar-Aktionen werden verarbeitet...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'Aktive Smart Guides werden aktualisiert...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'Der Datensatz und die zugehörigen Smart Guides wurden erfolgreich aktualisiert.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'Ein verknüpfter Smart Guide konnte nicht aktualisiert werden. Wenn der Fehler weiterhin besteht, wenden Sie sich bitte an Ihren Sugar-Administrator, um Hilfe zu erhalten.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'Ein verknüpfter Smart Guide konnte nicht aktualisiert werden. Lesen Sie bitte die <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">Protokolle</a> , um den Fehler zu beheben.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => 'Das <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} wurde erfolgreich verknüpft.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'Beim Verknüpfen von <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} ist ein Problem aufgetreten. Wenn das Problem weiterhin besteht, wenden Sie sich bitte an den Sugar-Support.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => 'Die {{modulePluralLower}} wurden erfolgreich gelöscht.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'Beim Verknüpfen der {{modulePluralLower}} ist ein Problem aufgetreten. Wenn das Problem weiterhin besteht, wenden Sie sich bitte an den Sugar-Support.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'Beim Verknüpfen des {{moduleSingularLower}} ist ein Problem aufgetreten. Wenn das Problem weiterhin besteht, wenden Sie sich bitte an den Sugar-Support.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'Es gibt bereits ein {{moduleSingularLower}} mit dem Namen <a href="#{{module}}/{{id}}">{{name}}</a> in Stufe {{stage}}.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'Ein {{moduleSingularLower}} mit dem Namen <a href="#{{module}}/{{id}}">{{name}}</a> wurde bereits ausgewählt.',
    'LBL_CJ_ARCHIVED' => 'Archiviert',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Smart Guide-Vorlage auswählen ...',
    'LBL_ALL_SMART_GUIDES' => 'Alle Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => 'Aktive Smart Guides',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Archivierte Smart Guides',
    'LBL_VERTICAL_SCROLL_VIEW' => 'Vertikale gestapelte Ansicht',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'Horizontale Bildlaufansicht',
    'LBL_DRI_WORKFLOWS_FILTER' => 'Filter',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'Diese Aktion kann nicht abgeschlossen werden. Das Status-Feld für das Modul dieser Aktivitäten ist auf "schreibgeschützt" gesetzt; damit wird verhindert, dass Smart Guide-Aktionen das Status-Feld aktualisieren.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'Diese Aktion kann nicht abgeschlossen werden. Das Status-Feld für das Modul dieser Aktivitäten und/oder Unteraktivitäten ist auf "schreibgeschützt" gesetzt; damit wird verhindert, dass Smart Guide-Aktionen das Status-Feld aktualisieren.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'Das Status-Feld für einige Aktivitätsmodule im Guide ist auf "schreibgeschützt" gesetzt; diese Aktivitäten bleiben bei der Stornierung des Guides unverändert.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'In Zwischenablage kopiert.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'Alle Ereignisse entfernen',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'Ungültige Ereigniseinstellungen',
    'ERROR_INTERVAL_INVALID' => 'Wiederholungsintervall muss zwischen 1 und 99 liegen.',
    'LBL_RECURRENCE_ADD' => 'Anpassen',
    'LBL_REPEAT_DAYS' => 'Tag(e) des Monats',
    'LBL_REPEAT_END_TYPES' => 'Wiederholen',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'Navigationsanbieter',
    'LBL_MOBILE_PDF_EMAIL' => 'E-Mail {{pdfTemplateName}} PDF',
    'LBL_MOBILE_EMAIL_SENDING' => 'Wird gesendet',
    'LBL_MOBILE_EMAIL_SENT' => 'Gesendet',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'E-Mail als Entwurf gespeichert.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'Anhang hinzufügen',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'Hochladen von Lokal',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar-Dokument',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'Ein von Ihnen ausgewählter Dropdown-Wert hat das Layout Ihrer Datensatzansicht verändert.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'Versionshinweise für die SugarCRM Mobile App',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'Benutzerhandbuch für die SugarCRM Mobile App',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile kann nicht auf einem gerooteten mobilen Gerät verwendet werden. Bitte öffnen Sie die App auf einem nicht gerooteten Gerät.',
    'LBL_VO_BUILD_ROUTE' => 'Route erstellen',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'Mein Entfernungsfilter',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'Das Dokument wird im Hintergrund erstellt. Öffnen Sie die Seite Dokumentzusammenführungen, um auf die Datei zuzugreifen.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'Vorlage konnte nicht abgerufen werden. Kontaktieren Sie Ihren Administrator für weitere Hilfe.',
    'LBL_MAP_ERROR_LOAD' => 'Karte kann nicht geladen werden',
    'LBL_MAP_DISTANCE' => 'Entfernung',
    'LBL_SELECT_UNIT_TYPE' => 'Einheitsart',
    'LBL_MAPS_UNIT_MILES' => 'Meilen',
    'LBL_MAPS_UNIT_KILOMETERS' => 'Kilometer',
    'LBL_RADIUS' => 'Radius',
    'LBL_ZIP_CODE' => 'Postleitzahl',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'Adresse auswählen',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'Kann keinen Geocode erstellen aus Adresse:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'Datensatz ist nicht geokodiert. ',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'Datensatz enthält keine Adressdaten. Möchten Sie diesen Datensatz manuell auf der Karte lokalisieren?',
    'LBL_ERR_SHOW_ON_MAP' => 'Karte für ausgewählte Datensätze konnte nicht geöffnet werden.',
    'LBL_ERR_MISSING_ON_MAP' => 'Bei einigen Datensätzen fehlen Adressdaten und sie werden nicht angezeigt',
    'LBL_MAPS_ROUTE' => 'Weiterleiten',
    'LBL_MAPS_PROVIDER' => 'Sugar-Karten',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'Aktueller Standort konnte nicht ermittelt werden.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'Maximal {{{num}}} Datensätze können zugeordnet werden.',
    'LBL_ALL_MODULES' => 'Alle Module',
    'LBL_DRIVE_SHARE_LINK' => 'Einen Link teilen',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'Dateien konnten nicht geladen werden.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'Name darf nicht leer sein',
    'LBL_DRIVE_FOLDER_CREATED' => 'Ordner erstellt.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'Ordner konnte nicht erstellt werden.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'Datei konnte nicht hochgeladen werden.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'Bitte erstellen Sie zunächst einen Stammordner',
    'LBL_EDIT_ALL_RECURRENCES' => 'Alle Ereignisse bearbeiten',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'Datei kann nicht in Dropbox geöffnet werden',
    'LBL_FILE_NOT_AVAILABLE' => 'Datei kann nicht geöffnet werden',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'Richtungen',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'Für die angegebenen Wegpunkte wurde keine Route gefunden',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'Nah',
    'LBL_TAGS' => 'Tags',

    'LBL_CALLER_ID_SETTINGS' => 'Anrufer-ID-Einstellungen',
    'LBL_CALLER_ID_ENABLED' => 'Anrufer-ID aktiviert',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'Bei eingehenden Anrufen wird der Name des Kontakts oder Interessenten, der mit der Telefonnummer übereinstimmt, angezeigt.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'Damit die mobile App Anrufer-IDs anzeigen kann, führen Sie auf Ihrem Gerät die folgenden Schritte aus:<br><br>1. Öffnen Sie die iOS-Einstellungen und wählen Sie „Telefon > Anrufe blockieren und identifizieren“.<br>2. Aktivieren Sie „{{{brandName}}}“.',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'Damit die mobile App Anrufer-IDs anzeigen kann, führen Sie auf Ihrem Gerät die folgenden Schritte aus:<br>1. Öffnen Sie die App-Einstellungen.<br>2. Wählen Sie „Berechtigungen“.<br>3. Aktivieren Sie die Berechtigung „Telefon“.<br><br> Um diese Anwendung als Standard-Anrufer-ID-Handler festzulegen, öffnen Sie die Geräteeinstellungen.<br>1. Navigieren Sie zu „Apps“.<br>2. Wählen Sie „Standard-Apps“ aus.<br>3. Wählen Sie „Anrufer-ID“ und „Spam-App“.<br>4. Wählen Sie diese Anwendung als Standardoption aus.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Suchen Sie in Ihrer Sugar-Instanz nach Änderungen der Kontaktinformationen aus Datensätzen (z. B. Kontakte, Interessenten).',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'Einstellungen öffnen',
    'LBL_CALLER_ID_SYNC' => 'Datensatzdaten synchronisieren',
    'LBL_CALLER_ID_NOT_ENABLED' => 'Die Anrufer-ID muss vor der Synchronisierung in den Systemeinstellungen aktiviert werden.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'Aktivieren',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'Später in den Einstellungen',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'Diese Anwendung unterstützt die Anrufer-ID-Funktion.<br> Damit diese Funktion ordnungsgemäß funktioniert, werden Sie nach Betätigen der Schaltfläche „Aktivieren“ aufgefordert, zwei Berechtigungen zu erteilen.<br> Um sicherzustellen, dass die Anrufer-ID-Funktion ordnungsgemäß funktioniert, müssen Sie die Berechtigung zum Verwalten von Anrufen erteilen und diese Anwendung als Standard-Anrufer-ID-Handler auswählen.<br> Wenn Sie die Berechtigung zum Verwalten von Anrufen nicht erteilen, können Sie auch keine Anrufe protokollieren, die über die Anwendung getätigt wurden.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'Damit die mobile Sugar CRM-App Anrufer-IDs anzeigen kann, führen Sie auf Ihrem Gerät die folgenden Schritte aus:<br><br>1. Öffnen Sie die iOS-Einstellungen und wählen Sie „Telefon > Anrufe blockieren und identifizieren“.<br>2. Aktivieren Sie die App.',
    'LBL_MOBILE_LAST_SYNC' => 'Letzte Synchronisierung',
    'LBL_CALLER_ID_SYNCING' => 'Synchronisierung mit dem Server läuft.',
    'LBL_NEVER' => 'Nie',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} darf nicht leer sein.',
    'LBL_ADD_RELATED_RECORD' => 'Verknüpftes {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => 'Sie verfügen nicht über die erforderlichen Berechtigungen zur Verwendung der Anrufer-ID. Wenden Sie sich bitte an Ihren Administrator.',
    'LBL_CALLER_ID_FETCHING' => 'Synchronisierung läuft…',
    'LBL_CALLER_ID_FETCH_ALL' => 'Alle Datensätze erneut synchronisieren',
    'LBL_CALLER_ID_FETCH_NEW' => 'Auf Datensatzaktualisierungen prüfen',

    'LBL_SORT_BY' => 'Sortieren nach',
    'LBL_PRIMARY_SORT' => 'Primäre Sortierung',
    'LBL_SECONDARY_SORT' => 'Sekundäre Sortierung',
    'LBL_OF' => 'von',
    'LBL_TABLE_FREEZE_FIRST' => 'Erste Spalte einfrieren',
    'LBL_TABLE_SETTINGS_TITLE' => 'Optionen für die Spaltenansicht',
    'LBL_TABLE_SETTINGS_NO_COL' => 'Mindestens eine Spalte muss ausgewählt sein.',
    'LBL_TABLE_TOGGLER_INFO' => 'Blenden Sie Spalten ein oder aus und ziehen Sie sie in die gewünschte Reihenfolge.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'Laufzeitfilter',
    'LBL_FILTER_CONDITION' => 'Bedingung auswählen',
    'LBL_FILTER_VALUES' => 'Werte',
    'LBL_TABLE_EXPAND' => 'Alle erweitern',
    'LBL_TABLE_COLLAPSE' => 'Alle einklappen',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'Serverfehler. Die relevanten Laufzeitfilter konnten nicht geladen werden.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Pub/Sub-Modul-Event-Push-Abonnements',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Pub/Sub-Modul-Event-Push-Abonnement',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'Panel oben',
    'panel_bottom' => 'Panel unten',
    'tab_first' => 'Registerkarte - Erste',
    'tab_last' => 'Registerkarte - Letzte',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'Letzten 7 Tage',
    '30' => 'Letzten 30 Tage',
    '90' => 'Letzes Quartal',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'Heute',
    'future' => 'Zukunft',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nein',
];

$app_list_strings['history_filter_options'] = [
    7 => 'Letzten 7 Tage',
    30 => 'Letzten 30 Tage',
    90 => 'Letzes Quartal',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nein',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nein',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'Ja',
    '0' => 'Nein',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'Dieses Quartal',
    'next' => 'Nächstes Quartal',
    'year' => 'Dieses Jahr',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'Meine Einträge',
    'group' => 'Gruppeneinträge',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'Meine Pipeline',
    'group' => 'Meine Team-Pipeline',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'Meine Prognose',
    'group' => 'Meine Team-Prognose',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'Verkaufschancen',
    'RevenueLineItems' => 'Verkaufschancen und Umsatzposten',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'Spätestes Abschlussdatum',
    'earliest' => 'Frühestes Abschlussdatum',
];

$app_list_strings['moduleList']['Library'] = 'Bibliothek';
$app_list_strings['moduleListSingular']['Library'] = 'Bibliothek';
$app_list_strings['library_type'] = ['Books' => 'Buch', 'Music' => 'Musik', 'DVD' => 'DVD', 'Magazines' => 'Magazine'];
$app_list_strings['moduleList']['EmailAddresses'] = 'E-Mail-Adresse';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'E-Mail-Adresse';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'Entwurf',
    'in-review' => 'In Durchsicht',
    'approved' => 'Genehmigt',
    'published' => 'Veröffentlicht',
    'expired' => 'Abgelaufen',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--Admin-Aktionen--',
        'Create New Tag' => 'Neuen Tag erstellen',
        'Delete Tag' => 'Tag löschen',
        'Rename Tag' => 'Tag umbenennen',
        'Move Selected Articles' => 'Ausgewählte Artikel verschieben',
        'Apply Tags On Articles' => 'Tags auf Artikel anwenden',
        'Delete Selected Articles' => 'Ausgewählte Artikel löschen',
    ];

$app_list_strings['moduleList']['Words'] = 'Wörter';
$app_list_strings['moduleListSingular']['Words'] = 'Wort';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Erstelle Artikel';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DHABI',
    'ADEN' => 'ADEN',
    'AFGHANISTAN' => 'AFGHANISTAN',
    'ALBANIA' => 'ALBANIEN',
    'ALGERIA' => 'ALGERIEN',
    'AMERICAN SAMOA' => 'AMERICAN SAMOA',
    'ANDORRA' => 'ANDORRA',
    'ANGOLA' => 'ANGOLA',
    'ANTARCTICA' => 'ANTARKTIS',
    'ANTIGUA' => 'ANTIGUA',
    'ARGENTINA' => 'ARGENTINIEN',
    'ARMENIA' => 'ARMENIEN',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => 'AUSTRALIEN',
    'AUSTRIA' => 'ÖSTERREICH',
    'AZERBAIJAN' => 'ASERBAIDSCHAN',
    'BAHAMAS' => 'BAHAMAS',
    'BAHRAIN' => 'BAHRAIN',
    'BANGLADESH' => 'BANGLADESH',
    'BARBADOS' => 'BARBADOS',
    'BELARUS' => 'WEISSRUSSLAND',
    'BELGIUM' => 'BELGIEN',
    'BELIZE' => 'BELIZE',
    'BENIN' => 'BENIN',
    'BERMUDA' => 'BERMUDA',
    'BHUTAN' => 'BHUTAN',
    'BOLIVIA' => 'BOLIVIEN',
    'BOSNIA' => 'BOSNIEN',
    'BOTSWANA' => 'BOTSWANA',
    'BOUVET ISLAND' => 'BOUVET ISLAND',
    'BRAZIL' => 'BRASILIEN',
    'BRITISH ANTARCTICA TERRITORY' => 'BRITISH TERRITORIEN ANTARKTIS',
    'BRITISH INDIAN OCEAN TERRITORY' => 'BRITISH TERRITORIEN IM INDISCHEN OZEAN',
    'BRITISH VIRGIN ISLANDS' => 'BRITISH VIRGIN INSELN',
    'BRITISH WEST INDIES' => 'BRITISH WEST INDIES',
    'BRUNEI' => 'BRUNEI',
    'BULGARIA' => 'BULGARIEN',
    'BURKINA FASO' => 'BURKINA FASO',
    'BURUNDI' => 'BURUNDI',
    'CAMBODIA' => 'KAMBODSCHA',
    'CAMEROON' => 'KAMERUN',
    'CANADA' => 'KANADA',
    'CANAL ZONE' => 'CANAL ZONE',
    'CANARY ISLAND' => 'KANARISCHE INSELN',
    'CAPE VERDI ISLANDS' => 'KAPVERDISCHEN INSELN',
    'CAYMAN ISLANDS' => 'CAYMAN INSELN',
    'CEVLON' => 'CEVLON',
    'CHAD' => 'CHAD',
    'CHANNEL ISLAND UK' => 'KANALINSELN UK',
    'CHILE' => 'CHILE',
    'CHINA' => 'CHINA',
    'CHRISTMAS ISLAND' => 'WEIHNACHTSINSEL',
    'COCOS (KEELING) ISLAND' => 'COCOS (KEELING) INSEL',
    'COLOMBIA' => 'KOLUMBIEN',
    'COMORO ISLANDS' => 'COMORO INSELN',
    'CONGO' => 'KONGO',
    'CONGO KINSHASA' => 'KONGO KINSHASA',
    'COOK ISLANDS' => 'COOK INSELN',
    'COSTA RICA' => 'COSTA RICA',
    'CROATIA' => 'KROATIEN',
    'CUBA' => 'KUBA',
    'CURACAO' => 'CURACAO',
    'CYPRUS' => 'ZYPERN',
    'CZECH REPUBLIC' => 'TSCHECHISCHE REPUBLIK',
    'DAHOMEY' => 'DAHOMEY',
    'DENMARK' => 'DÄNEMARK',
    'DJIBOUTI' => 'DSCHIBUTI',
    'DOMINICA' => 'DOMINICA',
    'DOMINICAN REPUBLIC' => 'DOMINIKANISCHE REPUBLIK',
    'DUBAI' => 'DUBAI',
    'ECUADOR' => 'ECUADOR',
    'EGYPT' => 'ÄGYPTEN',
    'EL SALVADOR' => 'EL SALVADOR',
    'EQUATORIAL GUINEA' => 'ÄQUATORIAL GUINEA',
    'ESTONIA' => 'ESTLAND',
    'ETHIOPIA' => 'ÄTHIOPIEN',
    'FAEROE ISLANDS' => 'FÄRÖER INSEL',
    'FALKLAND ISLANDS' => 'FALKLANDINSELN',
    'FIJI' => 'FIDSCHI',
    'FINLAND' => 'FINNLAND',
    'FRANCE' => 'FRANKREICH',
    'FRENCH GUIANA' => 'FRANZÖSISCH GUIANA',
    'FRENCH POLYNESIA' => 'FRANZÖSISCH POLYNESIEN',
    'GABON' => 'GABON',
    'GAMBIA' => 'GAMBIA',
    'GEORGIA' => 'GEORGIEN',
    'GERMANY' => 'DEUTSCHLAND',
    'GHANA' => 'GHANA',
    'GIBRALTAR' => 'GIBRALTAR',
    'GREECE' => 'GRIECHENLAND',
    'GREENLAND' => 'GRÖNLAND',
    'GUADELOUPE' => 'GUADELOUPE',
    'GUAM' => 'GUAM',
    'GUATEMALA' => 'GUATEMALA',
    'GUINEA' => 'GUINEA',
    'GUYANA' => 'GUYANA',
    'HAITI' => 'HAITI',
    'HONDURAS' => 'HONDURAS',
    'HONG KONG' => 'HONG KONG',
    'HUNGARY' => 'UNGARN',
    'ICELAND' => 'ISLAND',
    'IFNI' => 'IFNI',
    'INDIA' => 'INDIEN',
    'INDONESIA' => 'INDONESIEN',
    'IRAN' => 'IRAN',
    'IRAQ' => 'IRAK',
    'IRELAND' => 'IRLAND',
    'ISRAEL' => 'ISRAEL',
    'ITALY' => 'ITALIEN',
    'IVORY COAST' => 'ELFENBEINKÜSTE',
    'JAMAICA' => 'JAMAIKA',
    'JAPAN' => 'JAPAN',
    'JORDAN' => 'JORDANIEN',
    'KAZAKHSTAN' => 'KASACHSTAN',
    'KENYA' => 'KENIA',
    'KOREA' => 'KOREA',
    'KOREA, SOUTH' => 'SÜD KOREA',
    'KUWAIT' => 'KUWAIT',
    'KYRGYZSTAN' => 'KIRGISIEN',
    'LAOS' => 'LAOS',
    'LATVIA' => 'LETTLAND',
    'LEBANON' => 'LIBANON',
    'LEEWARD ISLANDS' => 'LEEWARD INSELN',
    'LESOTHO' => 'LESOTHO',
    'LIBYA' => 'LYBIEN',
    'LIECHTENSTEIN' => 'LIECHTENSTEIN',
    'LITHUANIA' => 'LETTLAND',
    'LUXEMBOURG' => 'LUXEMBURG',
    'MACAO' => 'MACAU',
    'MACEDONIA' => 'MAZEDONIEN',
    'MADAGASCAR' => 'MADAGASKAR',
    'MALAWI' => 'MALAWI',
    'MALAYSIA' => 'MALAYSIEN',
    'MALDIVES' => 'MALEDIVEN',
    'MALI' => 'MALI',
    'MALTA' => 'MALTA',
    'MARTINIQUE' => 'MARTINIQUE',
    'MAURITANIA' => 'MAURITANIEN',
    'MAURITIUS' => 'MAURITIUS',
    'MELANESIA' => 'MELANESIA',
    'MEXICO' => 'MEXIKO',
    'MOLDOVIA' => 'MOLDAWIEN',
    'MONACO' => 'MONACO',
    'MONGOLIA' => 'MONGOLEI',
    'MOROCCO' => 'MAROKKO',
    'MOZAMBIQUE' => 'MOSAMBIK',
    'MYANAMAR' => 'MYANAMAR',
    'NAMIBIA' => 'NAMIBIA',
    'NEPAL' => 'NEPAL',
    'NETHERLANDS' => 'NIEDERLANDE',
    'NETHERLANDS ANTILLES' => 'NIEDERLÄNDISCHE ANTILLEN',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'NIEDERLÄNDISCHE ANTILLEN NEUTRALE ZONE',
    'NEW CALADONIA' => 'NEU KALEDONIEN',
    'NEW HEBRIDES' => 'NEUE HEBRIDEN',
    'NEW ZEALAND' => 'NEUSEELAND',
    'NICARAGUA' => 'NICARAGUA',
    'NIGER' => 'NIGER',
    'NIGERIA' => 'NIGERIA',
    'NORFOLK ISLAND' => 'NORFOLK-INSELN',
    'NORWAY' => 'NORWEGEN',
    'OMAN' => 'OMAN',
    'OTHER' => 'ANDERE',
    'PACIFIC ISLAND' => 'PAZIFISCE-INSEL',
    'PAKISTAN' => 'PAKISTAN',
    'PANAMA' => 'PANAMA',
    'PAPUA NEW GUINEA' => 'PAPUA NEUGUINEA',
    'PARAGUAY' => 'PARAGUAY',
    'PERU' => 'PERU',
    'PHILIPPINES' => 'PHILIPPINEN',
    'POLAND' => 'POLEN',
    'PORTUGAL' => 'PORTUGAL',
    'PORTUGUESE TIMOR' => 'PORTUGUESE TIMOR',
    'PUERTO RICO' => 'PUERTO RICO',
    'QATAR' => 'QATAR',
    'REPUBLIC OF BELARUS' => 'WEISSRUSSLAND',
    'REPUBLIC OF SOUTH AFRICA' => 'REPUBLIK SÜDAFRIKA',
    'REUNION' => 'REUNION',
    'ROMANIA' => 'RUMÄNIEN',
    'RUSSIA' => 'RUSSLAND',
    'RWANDA' => 'RUANDA',
    'RYUKYU ISLANDS' => 'RYUKYU-INSELN',
    'SABAH' => 'SABAH',
    'SAN MARINO' => 'SAN MARINO',
    'SAUDI ARABIA' => 'SAUDI-ARABIEN',
    'SENEGAL' => 'SENEGAL',
    'SERBIA' => 'SERBIEN',
    'SEYCHELLES' => 'SEYCHELLEN',
    'SIERRA LEONE' => 'SIERRA LEONE',
    'SINGAPORE' => 'SINGAPUR',
    'SLOVAKIA' => 'SLOWAKEI',
    'SLOVENIA' => 'SLOWENIEN',
    'SOMALILIAND' => 'SOMALILIAND',
    'SOUTH AFRICA' => 'SÜDAFRIKA',
    'SOUTH YEMEN' => 'SÜD JEMEN',
    'SPAIN' => 'SPANIEN',
    'SPANISH SAHARA' => 'SPANISCHE SAHARA',
    'SRI LANKA' => 'SRI LANKA',
    'ST. KITTS AND NEVIS' => 'ST. KITTS AND NEVIS',
    'ST. LUCIA' => 'ST. LUCIA',
    'SUDAN' => 'SUDAN',
    'SURINAM' => 'SURINAM',
    'SW AFRICA' => 'SW AFRIKA',
    'SWAZILAND' => 'SWAZILAND',
    'SWEDEN' => 'SCHWEDEN',
    'SWITZERLAND' => 'SCHWEIZ',
    'SYRIA' => 'SYRIEN',
    'TAIWAN' => 'TAIWAN',
    'TAJIKISTAN' => 'TADSCHIKISTAN',
    'TANZANIA' => 'TANSANIA',
    'THAILAND' => 'THAILAND',
    'TONGA' => 'TONGA',
    'TRINIDAD' => 'TRINIDAD',
    'TUNISIA' => 'TUNESIEN',
    'TURKEY' => 'TÜRKEI',
    'UGANDA' => 'UGANDA',
    'UKRAINE' => 'UKRAINE',
    'UNITED ARAB EMIRATES' => 'VEREINIGTE ARABISCHE EMIRATE',
    'UNITED KINGDOM' => 'VEREINIGTES KÖNIGREICH',
    'UPPER VOLTA' => 'OBERVOLTA',
    'URUGUAY' => 'URUGUAY',
    'US PACIFIC ISLAND' => 'US PAZIFISCHE INSEL',
    'US VIRGIN ISLANDS' => 'US JUNGFRAU-INSELN',
    'USA' => 'VEREINIGTE STAATEN (USA)',
    'UZBEKISTAN' => 'UZBEKISTAN',
    'VANUATU' => 'VANUATU',
    'VATICAN CITY' => 'VATIKAN',
    'VENEZUELA' => 'VENEZUELA',
    'VIETNAM' => 'VIETNAM',
    'WAKE ISLAND' => 'WAKE ISLAND',
    'WEST INDIES' => 'WEST INDIES',
    'WESTERN SAHARA' => 'WESTSAHARA',
    'YEMEN' => 'JEMEN',
    'ZAIRE' => 'ZAIRE',
    'ZAMBIA' => 'SAMBIA',
    'ZIMBABWE' => 'SIMBABWE',
];

$app_list_strings['state_dom'] = [
    'AL' => 'Alabama',
    'AK' => 'Alaska',
    'AZ' => 'Arizona',
    'AR' => 'Arkansas',
    'CA' => 'California',
    'CO' => 'Colorado',
    'CT' => 'Connecticut',
    'DE' => 'Delaware',
    'DC' => 'District Of Columbia',
    'FL' => 'Florida',
    'GA' => 'Georgien',
    'HI' => 'Hawaii',
    'ID' => 'Idaho',
    'IL' => 'Illinois',
    'IN' => 'Indienna',
    'IA' => 'Iowa',
    'KS' => 'Kansas',
    'KY' => 'Kentucky',
    'LA' => 'Louisiana',
    'ME' => 'Maine',
    'MD' => 'Maryland',
    'MA' => 'Massachusetts',
    'MI' => 'Michigan',
    'MN' => 'Minnesota',
    'MS' => 'Mississippi',
    'MO' => 'Missouri',
    'MT' => 'Montana',
    'NE' => 'Nebraska',
    'NV' => 'Nevada',
    'NH' => 'New Hampshire',
    'NJ' => 'New Jersey',
    'NM' => 'New Mexico',
    'NY' => 'New York',
    'NC' => 'North Carolina',
    'ND' => 'North Dakota',
    'OH' => 'Ohio',
    'OK' => 'Oklahoma',
    'OR' => 'Oregon',
    'PA' => 'Pennsylvania',
    'RI' => 'Rhode Island',
    'SC' => 'South Carolina',
    'SD' => 'South Dakota',
    'TN' => 'Tennessee',
    'TX' => 'Texas',
    'UT' => 'Utah',
    'VT' => 'Vermont',
    'VA' => 'Virginia',
    'WA' => 'Washington',
    'WV' => 'West Virginia',
    'WI' => 'Wisconsin',
    'WY' => 'Wyoming',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (Taiwan und Hong Kong)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS Cyrillisch)',
    'CP1252' => 'CP1252 (MS Westeuropa & US)',
    'EUC-CN' => 'EUC-CN (Simplified Chinese GB2312)',
    'EUC-JP' => 'EUC-JP (Unix Japanisch)',
    'EUC-KR' => 'EUC-KR (Koreanisch)',
    'EUC-TW' => 'EUC-TW (Taiwanesisch)',
    'ISO-2022-JP' => 'ISO-2022-JP (Japanisch)',
    'ISO-2022-KR' => 'ISO-2022-KR (Koreanisch)',
    'ISO-8859-1' => 'ISO-8859-1 (Westeuropa und US)',
    'ISO-8859-2' => 'ISO-8859-2 (Zentral- und Osteuropa)',
    'ISO-8859-3' => 'ISO-8859-3 (Latin 3)',
    'ISO-8859-4' => 'ISO-8859-4 (Latin 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Kyrillisch)',
    'ISO-8859-6' => 'ISO-8859-6 (Arabisch)',
    'ISO-8859-7' => 'ISO-8859-7 (Griechisch)',
    'ISO-8859-8' => 'ISO-8859-8 (Hebräisch)',
    'ISO-8859-9' => 'ISO-8859-9 (Latin 5)',
    'ISO-8859-10' => 'ISO-8859-10 (Latin 6)',
    'ISO-8859-13' => 'ISO-8859-13 (Latin 7)',
    'ISO-8859-14' => 'ISO-8859-14 (Latin 8)',
    'ISO-8859-15' => 'ISO-8859-15 (Latin 9)',
    'KOI8-R' => 'KOI8-R (Kyrillisch Russisch)',
    'KOI8-U' => 'KOI8-U (Kyrillisch Ukrainisch)',
    'SJIS' => 'SJIS (MS-Japanisch)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Afrika/Algiers',
    'Africa/Luanda' => 'Afrika/Luanda',
    'Africa/Porto-Novo' => 'Afrika/Porto-Novo',
    'Africa/Gaborone' => 'Afrika/Gaborone',
    'Africa/Ouagadougou' => 'Afrika/Ouagadougou',
    'Africa/Bujumbura' => 'Afrika/Bujumbura',
    'Africa/Douala' => 'Afrika/Douala',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Africa/Bangui' => 'Afrika/Bangui',
    'Africa/Ndjamena' => 'Afrika/Ndjamena',
    'Indian/Comoro' => 'Indien/Comoro',
    'Africa/Kinshasa' => 'Afrika/Kinshasa',
    'Africa/Lubumbashi' => 'Afrika/Lubumbashi',
    'Africa/Brazzaville' => 'Afrika/Brazzaville',
    'Africa/Abidjan' => 'Afrika/Abidjan',
    'Africa/Djibouti' => 'Afrika/Dschibuti',
    'Africa/Cairo' => 'Afrika/Cairo',
    'Africa/Malabo' => 'Afrika/Malabo',
    'Africa/Asmera' => 'Afrika/Asmera',
    'Africa/Addis_Ababa' => 'Afrika/Addis_Ababa',
    'Africa/Libreville' => 'Afrika/Libreville',
    'Africa/Banjul' => 'Afrika/Banjul',
    'Africa/Accra' => 'Afrika/Accra',
    'Africa/Conakry' => 'Afrika/Conakry',
    'Africa/Bissau' => 'Afrika/Bissau',
    'Africa/Nairobi' => 'Afrika/Nairobi',
    'Africa/Maseru' => 'Afrika/Maseru',
    'Africa/Monrovia' => 'Afrika/Monrovia',
    'Africa/Tripoli' => 'Afrika/Tripoli',
    'Indian/Antananarivo' => 'Indien/Antananarivo',
    'Africa/Blantyre' => 'Afrika/Blantyre',
    'Africa/Bamako' => 'Afrika/Bamako',
    'Africa/Nouakchott' => 'Afrika/Nouakchott',
    'Indian/Mauritius' => 'Indien/Mauritius',
    'Indian/Mayotte' => 'Indien/Mayotte',
    'Africa/Casablanca' => 'Afrika/Casablanca',
    'Africa/El_Aaiun' => 'Afrika/El_Aaiun',
    'Africa/Maputo' => 'Afrika/Maputo',
    'Africa/Windhoek' => 'Afrika/Windhoek',
    'Africa/Niamey' => 'Afrika/Niamey',
    'Africa/Lagos' => 'Afrika/Lagos',
    'Indian/Reunion' => 'Indien/Reunion',
    'Africa/Kigali' => 'Afrika/Kigali',
    'Atlantic/St_Helena' => 'Atlantik/St_Helena',
    'Africa/Sao_Tome' => 'Afrika/Sao_Tome',
    'Africa/Dakar' => 'Afrika/Dakar',
    'Indian/Mahe' => 'Indien/Mahe',
    'Africa/Freetown' => 'Afrika/Freetown',
    'Africa/Mogadishu' => 'Afrika/Mogadishu',
    'Africa/Johannesburg' => 'Afrika/Johannesburg',
    'Africa/Khartoum' => 'Afrika/Khartoum',
    'Africa/Mbabane' => 'Afrika/Mbabane',
    'Africa/Dar_es_Salaam' => 'Afrika/Dar_es_Salaam',
    'Africa/Lome' => 'Afrika/Lome',
    'Africa/Tunis' => 'Afrika/Tunis',
    'Africa/Kampala' => 'Afrika/Kampala',
    'Africa/Lusaka' => 'Afrika/Lusaka',
    'Africa/Harare' => 'Afrika/Harare',
    'Antarctica/Casey' => 'Antarktis/Casey',
    'Antarctica/Davis' => 'Antarktis/Davis',
    'Antarctica/Mawson' => 'Antarktis/Mawson',
    'Indian/Kerguelen' => 'Indien/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antarktis/DumontDUrville',
    'Antarctica/Syowa' => 'Antarktis/Syowa',
    'Antarctica/Vostok' => 'Antarktis/Vostok',
    'Antarctica/Rothera' => 'Antarktis/Rothera',
    'Antarctica/Palmer' => 'Antarktis/Palmer',
    'Antarctica/McMurdo' => 'Antarktis/McMurdo',
    'Asia/Kabul' => 'Asien/Kabul',
    'Asia/Yerevan' => 'Asien/Yerevan',
    'Asia/Baku' => 'Asien/Baku',
    'Asia/Bahrain' => 'Asien/Bahrain',
    'Asia/Dhaka' => 'Asien/Dhaka',
    'Asia/Thimphu' => 'Asien/Thimphu',
    'Indian/Chagos' => 'Indien/Chagos',
    'Asia/Brunei' => 'Asien/Brunei',
    'Asia/Rangoon' => 'Asien/Rangoon',
    'Asia/Phnom_Penh' => 'Asien/Phnom_Penh',
    'Asia/Beijing' => 'Asien/Peking',
    'Asia/Harbin' => 'Asien/Harbin',
    'Asia/Shanghai' => 'Asien/Shanghai',
    'Asia/Chongqing' => 'Asien/Chongqing',
    'Asia/Urumqi' => 'Asien/Urumqi',
    'Asia/Kashgar' => 'Asien/Kashgar',
    'Asia/Hong_Kong' => 'Asien/Hong_Kong',
    'Asia/Taipei' => 'Asien/Taipei',
    'Asia/Macau' => 'Asien/Macau',
    'Asia/Nicosia' => 'Asien/Nicosia',
    'Asia/Tbilisi' => 'Asien/Tbilisi',
    'Asia/Dili' => 'Asien/Dili',
    'Asia/Calcutta' => 'Asien/Calcutta',
    'Asia/Jakarta' => 'Asien/Jakarta',
    'Asia/Pontianak' => 'Asien/Pontianak',
    'Asia/Makassar' => 'Asien/Makassar',
    'Asia/Jayapura' => 'Asien/Jayapura',
    'Asia/Tehran' => 'Asien/Tehran',
    'Asia/Baghdad' => 'Asien/Baghdad',
    'Asia/Jerusalem' => 'Asien/Jerusalem',
    'Asia/Tokyo' => 'Asien/Tokyo',
    'Asia/Amman' => 'Asien/Amman',
    'Asia/Almaty' => 'Asien/Almaty',
    'Asia/Qyzylorda' => 'Asien/Qyzylorda',
    'Asia/Aqtobe' => 'Asien/Aqtobe',
    'Asia/Aqtau' => 'Asien/Aqtau',
    'Asia/Oral' => 'Asien/Oral',
    'Asia/Bishkek' => 'Asien/Bishkek',
    'Asia/Seoul' => 'Asien/Seoul',
    'Asia/Pyongyang' => 'Asien/Pyongyang',
    'Asia/Kuwait' => 'Asien/Kuwait',
    'Asia/Vientiane' => 'Asien/Vientiane',
    'Asia/Beirut' => 'Asien/Beirut',
    'Asia/Kuala_Lumpur' => 'Asien/Kuala_Lumpur',
    'Asia/Kuching' => 'Asien/Kuching',
    'Indian/Maldives' => 'Indien/Malediven',
    'Asia/Hovd' => 'Asien/Hovd',
    'Asia/Ulaanbaatar' => 'Asien/Ulaanbaatar',
    'Asia/Choibalsan' => 'Asien/Choibalsan',
    'Asia/Katmandu' => 'Asien/Katmandu',
    'Asia/Muscat' => 'Asien/Muscat',
    'Asia/Karachi' => 'Asien/Karachi',
    'Asia/Gaza' => 'Asien/Gaza',
    'Asia/Manila' => 'Asien/Manila',
    'Asia/Qatar' => 'Asien/Qatar',
    'Asia/Riyadh' => 'Asien/Riyadh',
    'Asia/Singapore' => 'Asien/Singapur',
    'Asia/Colombo' => 'Asien/Colombo',
    'Asia/Damascus' => 'Asien/Damascus',
    'Asia/Dushanbe' => 'Asien/Dushanbe',
    'Asia/Bangkok' => 'Asien/Bangkok',
    'Asia/Ashgabat' => 'Asien/Ashgabat',
    'Asia/Dubai' => 'Asien/Dubai',
    'Asia/Samarkand' => 'Asien/Samarkand',
    'Asia/Tashkent' => 'Asien/Tashkent',
    'Asia/Saigon' => 'Asien/Saigon',
    'Asia/Aden' => 'Asien/Aden',
    'Australia/Darwin' => 'Australien/Darwin',
    'Australia/Perth' => 'Australien/Perth',
    'Australia/Brisbane' => 'Australien/Brisbane',
    'Australia/Lindeman' => 'Australien/Lindeman',
    'Australia/Adelaide' => 'Australien/Adelaide',
    'Australia/Hobart' => 'Australien/Hobart',
    'Australia/Currie' => 'Australien/Currie',
    'Australia/Melbourne' => 'Australien/Melbourne',
    'Australia/Sydney' => 'Australien/Sydney',
    'Australia/Broken_Hill' => 'Australien/Broken_Hill',
    'Indian/Christmas' => 'Indien/Christmas',
    'Pacific/Rarotonga' => 'Pazifik/Rarotonga',
    'Indian/Cocos' => 'Indien/Cocos',
    'Pacific/Fiji' => 'Pazifik/Fidschi',
    'Pacific/Gambier' => 'Pazifik/Gambier',
    'Pacific/Marquesas' => 'Pazifik/Marquesas',
    'Pacific/Tahiti' => 'Pazifik/Tahiti',
    'Pacific/Guam' => 'Pazifik/Guam',
    'Pacific/Tarawa' => 'Pazifik/Tarawa',
    'Pacific/Enderbury' => 'Pazifik/Enderbury',
    'Pacific/Kiritimati' => 'Pazifik/Kiritimati',
    'Pacific/Saipan' => 'Pazifik/Saipan',
    'Pacific/Majuro' => 'Pazifik/Majuro',
    'Pacific/Kwajalein' => 'Pazifik/Kwajalein',
    'Pacific/Truk' => 'Pazifik/Truk',
    'Pacific/Ponape' => 'Pazifik/Ponape',
    'Pacific/Kosrae' => 'Pazifik/Kosrae',
    'Pacific/Nauru' => 'Pazifik/Nauru',
    'Pacific/Noumea' => 'Pazifik/Noumea',
    'Pacific/Auckland' => 'Pazifik/Auckland',
    'Pacific/Chatham' => 'Pazifik/Chatham',
    'Pacific/Niue' => 'Pazifik/Niue',
    'Pacific/Norfolk' => 'Pazifik/Norfolk',
    'Pacific/Palau' => 'Pazifik/Palau',
    'Pacific/Port_Moresby' => 'Pazifik/Port_Moresby',
    'Pacific/Pitcairn' => 'Pazifik/Pitcairn',
    'Pacific/Pago_Pago' => 'Pazifik/Pago_Pago',
    'Pacific/Apia' => 'Pazifik/Apia',
    'Pacific/Guadalcanal' => 'Pazifik/Guadalcanal',
    'Pacific/Fakaofo' => 'Pazifik/Fakaofo',
    'Pacific/Tongatapu' => 'Pazifik/Tongatapu',
    'Pacific/Funafuti' => 'Pazifik/Funafuti',
    'Pacific/Johnston' => 'Pazifik/Johnston',
    'Pacific/Midway' => 'Pazifik/Midway',
    'Pacific/Wake' => 'Pazifik/Wake',
    'Pacific/Efate' => 'Pazifik/Efate',
    'Pacific/Wallis' => 'Pazifik/Wallis',
    'Europe/London' => 'Europa/London',
    'Europe/Dublin' => 'Europa/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'Europa/Tirane',
    'Europe/Andorra' => 'Europa/Andorra',
    'Europe/Vienna' => 'Europa/Vienna',
    'Europe/Minsk' => 'Europa/Minsk',
    'Europe/Brussels' => 'Europa/Brussels',
    'Europe/Sofia' => 'Europa/Sofia',
    'Europe/Prague' => 'Europa/Prague',
    'Europe/Copenhagen' => 'Europa/Copenhagen',
    'Atlantic/Faeroe' => 'Atlantik/Faeroe',
    'America/Danmarkshavn' => 'Amerika/Danmarkshavn',
    'America/Scoresbysund' => 'Amerika/Scoresbysund',
    'America/Godthab' => 'Amerika/Godthab',
    'America/Thule' => 'Amerika/Thule',
    'Europe/Tallinn' => 'Europa/Tallinn',
    'Europe/Helsinki' => 'Europa/Helsinki',
    'Europe/Paris' => 'Europa/Paris',
    'Europe/Berlin' => 'Europa/Berlin',
    'Europe/Gibraltar' => 'Europa/Gibraltar',
    'Europe/Athens' => 'Europa/Athens',
    'Europe/Budapest' => 'Europa/Budapest',
    'Atlantic/Reykjavik' => 'Atlantik/Reykjavik',
    'Europe/Rome' => 'Europa/Rome',
    'Europe/Riga' => 'Europa/Riga',
    'Europe/Vaduz' => 'Europa/Vaduz',
    'Europe/Vilnius' => 'Europa/Vilnius',
    'Europe/Luxembourg' => 'Europa/Luxemburg',
    'Europe/Malta' => 'Europa/Malta',
    'Europe/Chisinau' => 'Europa/Chisinau',
    'Europe/Monaco' => 'Europa/Monaco',
    'Europe/Amsterdam' => 'Europa/Amsterdam',
    'Europe/Oslo' => 'Europa/Oslo',
    'Europe/Warsaw' => 'Europa/Warsaw',
    'Europe/Lisbon' => 'Europa/Lisbon',
    'Atlantic/Azores' => 'Atlantik/Azores',
    'Atlantic/Madeira' => 'Atlantik/Madeira',
    'Europe/Bucharest' => 'Europa/Bucharest',
    'Europe/Kaliningrad' => 'Europa/Kaliningrad',
    'Europe/Moscow' => 'Europa/Moscow',
    'Europe/Samara' => 'Europa/Samara',
    'Asia/Yekaterinburg' => 'Asien/Yekaterinburg',
    'Asia/Omsk' => 'Asien/Omsk',
    'Asia/Novosibirsk' => 'Asien/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asien/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asien/Irkutsk',
    'Asia/Yakutsk' => 'Asien/Yakutsk',
    'Asia/Vladivostok' => 'Asien/Vladivostok',
    'Asia/Sakhalin' => 'Asien/Sakhalin',
    'Asia/Magadan' => 'Asien/Magadan',
    'Asia/Kamchatka' => 'Asien/Kamchatka',
    'Asia/Anadyr' => 'Asien/Anadyr',
    'Europe/Belgrade' => 'Europa/Belgrade',
    'Europe/Madrid' => 'Europa/Madrid',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Atlantic/Canary' => 'Atlantik/Canary',
    'Europe/Stockholm' => 'Europa/Stockholm',
    'Europe/Zurich' => 'Europa/Zurich',
    'Europe/Istanbul' => 'Europa/Istanbul',
    'Europe/Kiev' => 'Europa/Kiev',
    'Europe/Uzhgorod' => 'Europa/Uzhgorod',
    'Europe/Zaporozhye' => 'Europa/Zaporozhye',
    'Europe/Simferopol' => 'Europa/Simferopol',
    'America/New_York' => 'Amerika/New_York',
    'America/Chicago' => 'Amerika/Chicago',
    'America/North_Dakota/Center' => 'Amerika/North_Dakota/Center',
    'America/Denver' => 'Amerika/Denver',
    'America/Los_Angeles' => 'Amerika/Los_Angeles',
    'America/Juneau' => 'Amerika/Juneau',
    'America/Yakutat' => 'Amerika/Yakutat',
    'America/Anchorage' => 'Amerika/Anchorage',
    'America/Nome' => 'Amerika/Nome',
    'America/Adak' => 'Amerika/Adak',
    'Pacific/Honolulu' => 'Pazifik/Honolulu',
    'America/Phoenix' => 'Amerika/Phoenix',
    'America/Boise' => 'Amerika/Boise',
    'America/Indiana/Indianapolis' => 'Amerika/Indienna/Indiennapolis',
    'America/Indiana/Marengo' => 'Amerika/Indienna/Marengo',
    'America/Indiana/Knox' => 'Amerika/Indienna/Knox',
    'America/Indiana/Vevay' => 'Amerika/Indienna/Vevay',
    'America/Kentucky/Louisville' => 'Amerika/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'Amerika/Kentucky/Monticello',
    'America/Detroit' => 'Amerika/Detroit',
    'America/Menominee' => 'Amerika/Menominee',
    'America/St_Johns' => 'Amerika/St_Johns',
    'America/Goose_Bay' => 'Amerika/Goose_Bay',
    'America/Halifax' => 'Amerika/Halifax',
    'America/Glace_Bay' => 'Amerika/Glace_Bay',
    'America/Montreal' => 'Amerika/Montreal',
    'America/Toronto' => 'Amerika/Toronto',
    'America/Thunder_Bay' => 'Amerika/Thunder_Bay',
    'America/Nipigon' => 'Amerika/Nipigon',
    'America/Rainy_River' => 'Amerika/Rainy_River',
    'America/Winnipeg' => 'Amerika/Winnipeg',
    'America/Regina' => 'Amerika/Regina',
    'America/Swift_Current' => 'Amerika/Swift_Current',
    'America/Edmonton' => 'Amerika/Edmonton',
    'America/Vancouver' => 'Amerika/Vancouver',
    'America/Dawson_Creek' => 'Amerika/Dawson_Creek',
    'America/Pangnirtung' => 'Amerika/Pangnirtung',
    'America/Iqaluit' => 'Amerika/Iqaluit',
    'America/Coral_Harbour' => 'Amerika/Coral_Harbour',
    'America/Rankin_Inlet' => 'Amerika/Rankin_Inlet',
    'America/Cambridge_Bay' => 'Amerika/Cambridge_Bay',
    'America/Yellowknife' => 'Amerika/Yellowknife',
    'America/Inuvik' => 'Amerika/Inuvik',
    'America/Whitehorse' => 'Amerika/Whitehorse',
    'America/Dawson' => 'Amerika/Dawson',
    'America/Cancun' => 'Amerika/Cancun',
    'America/Merida' => 'Amerika/Merida',
    'America/Monterrey' => 'Amerika/Monterrey',
    'America/Mexico_City' => 'Amerika/Mexico_City',
    'America/Chihuahua' => 'Amerika/Chihuahua',
    'America/Hermosillo' => 'Amerika/Hermosillo',
    'America/Mazatlan' => 'Amerika/Mazatlan',
    'America/Tijuana' => 'Amerika/Tijuana',
    'America/Anguilla' => 'Amerika/Anguilla',
    'America/Antigua' => 'Amerika/Antigua',
    'America/Nassau' => 'Amerika/Nassau',
    'America/Barbados' => 'Amerika/Barbados',
    'America/Belize' => 'Amerika/Belize',
    'Atlantic/Bermuda' => 'Atlantik/Bermuda',
    'America/Cayman' => 'Amerika/Cayman',
    'America/Costa_Rica' => 'Amerika/Costa_Rica',
    'America/Havana' => 'Amerika/Havana',
    'America/Dominica' => 'Amerika/Dominica',
    'America/Santo_Domingo' => 'Amerika/Santo_Domingo',
    'America/El_Salvador' => 'Amerika/El_Salvador',
    'America/Grenada' => 'Amerika/Grenada',
    'America/Guadeloupe' => 'Amerika/Guadeloupe',
    'America/Guatemala' => 'Amerika/Guatemala',
    'America/Port-au-Prince' => 'Amerika/Port-au-Prince',
    'America/Tegucigalpa' => 'Amerika/Tegucigalpa',
    'America/Jamaica' => 'Amerika/Jamaika',
    'America/Martinique' => 'Amerika/Martinique',
    'America/Montserrat' => 'Amerika/Montserrat',
    'America/Managua' => 'Amerika/Managua',
    'America/Panama' => 'Amerika/Panama',
    'America/Puerto_Rico' => 'Amerika/Puerto_Rico',
    'America/St_Kitts' => 'Amerika/St_Kitts',
    'America/St_Lucia' => 'Amerika/St_Lucia',
    'America/Miquelon' => 'Amerika/Miquelon',
    'America/St_Vincent' => 'Amerika/St_Vincent',
    'America/Grand_Turk' => 'Amerika/Grand_Turk',
    'America/Tortola' => 'Amerika/Tortola',
    'America/St_Thomas' => 'Amerika/St_Thomas',
    'America/Argentina/Buenos_Aires' => 'Amerika/Argentinien/Buenos_Aires',
    'America/Argentina/Cordoba' => 'Amerika/Argentinien/Cordoba',
    'America/Argentina/Tucuman' => 'Amerika/Argentinien/Tucuman',
    'America/Argentina/La_Rioja' => 'Amerika/Argentinien/La_Rioja',
    'America/Argentina/San_Juan' => 'Amerika/Argentinien/San_Juan',
    'America/Argentina/Jujuy' => 'Amerika/Argentinien/Jujuy',
    'America/Argentina/Catamarca' => 'Amerika/Argentinien/Catamarca',
    'America/Argentina/Mendoza' => 'Amerika/Argentinien/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'Amerika/Argentinien/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'Amerika/Argentinien/Ushuaia',
    'America/Aruba' => 'Amerika/Aruba',
    'America/La_Paz' => 'Amerika/La_Paz',
    'America/Noronha' => 'Amerika/Noronha',
    'America/Belem' => 'Amerika/Belem',
    'America/Fortaleza' => 'Amerika/Fortaleza',
    'America/Recife' => 'Amerika/Recife',
    'America/Araguaina' => 'Amerika/Araguaina',
    'America/Maceio' => 'Amerika/Maceio',
    'America/Bahia' => 'Amerika/Bahia',
    'America/Sao_Paulo' => 'Amerika/Sao_Paulo',
    'America/Campo_Grande' => 'Amerika/Campo_Grande',
    'America/Cuiaba' => 'Amerika/Cuiaba',
    'America/Porto_Velho' => 'Amerika/Porto_Velho',
    'America/Boa_Vista' => 'Amerika/Boa_Vista',
    'America/Manaus' => 'Amerika/Manaus',
    'America/Eirunepe' => 'Amerika/Eirunepe',
    'America/Rio_Branco' => 'Amerika/Rio_Branco',
    'America/Santiago' => 'Amerika/Santiago',
    'Pacific/Easter' => 'Pazifik/Easter',
    'America/Bogota' => 'Amerika/Bogota',
    'America/Curacao' => 'Amerika/Curacao',
    'America/Guayaquil' => 'Amerika/Guayaquil',
    'Pacific/Galapagos' => 'Pazifik/Galapagos',
    'Atlantic/Stanley' => 'Atlantik/Stanley',
    'America/Cayenne' => 'Amerika/Cayenne',
    'America/Guyana' => 'Amerika/Guyana',
    'America/Asuncion' => 'Amerika/Asuncion',
    'America/Lima' => 'Amerika/Lima',
    'Atlantic/South_Georgia' => 'Atlantik/South_Georgien',
    'America/Paramaribo' => 'Amerika/Paramaribo',
    'America/Port_of_Spain' => 'Amerika/Port_of_Spanien',
    'America/Montevideo' => 'Amerika/Montevideo',
    'America/Caracas' => 'Amerika/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'Favoriten';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'Favorit';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google Docs',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Kontakte',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'Anfrage',
    2 => 'Zugang',
    3 => 'Ungültig',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugar-Benutzer',
    'support_portal' => 'Support-Portal',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'Kampagne',
    'email' => 'E-Mail',
    'workflow' => 'Workflow',
    'system' => 'System',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'Kampagne',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'Kampagne',
    'email' => 'E-Mail',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'Dokumentation',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'zwei Bereiche',
    'show_buckets' => 'drei Bereiche',
    'show_custom_buckets' => 'Benutzerdefinierte Bereiche',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'Zugrundeliegendes Jahr',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'Jährlich (Unterperioden nach Quartal)',
    'Quarter' => 'Quartalsweise (Unterperioden nach Monaten)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'Umsatzposten',
    'Opportunities' => 'Verkaufschancen',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'Ja',
    'no' => 'Nein',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'Warnung',
    'information' => 'Info',
    'other' => 'Andere',
    'success' => 'Erfolg',
    'warning' => 'Warnung',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'GET',
    'PUT' => 'PUT',
    'DELETE' => 'Löschen',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'Manuell',
    '5' => 'Alle 5 Minuten',
    '15' => 'Alle 15 Minuten',
    '30' => 'Alle 30 Minuten',
    '60' => 'Stündlich',
];

$app_list_strings['moduleList']['KBDocuments'] = 'Wissendatenbank';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'Wissendatenbank';
$app_list_strings['moduleList']['KBContents'] = 'Wissensdatenbank';
$app_list_strings['moduleListSingular']['KBContents'] = 'Artikel der Wissensdatenbank';
$app_list_strings['moduleList']['KBArticles'] = 'Wissensdatenbank-Artikel';
$app_list_strings['moduleListSingular']['KBArticles'] = 'Wissensdatenbank-Artikel';
$app_list_strings['moduleList']['KBContentTemplates'] = 'Wissensdatenbank-Vorlage';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'Wissensdatenbank-Vorlage';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'Eingebettete Dateien';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'Eingebettete Datei';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leke',
    'USD' => 'Dollar',
    'AFN' => 'Afghanis',
    'ARS' => 'Pesos',
    'AWG' => 'Gulden',
    'AUD' => 'Dollar',
    'AZN' => 'New Manats',
    'BSD' => 'Dollar',
    'BBD' => 'Dollar',
    'BYR' => 'Rubel',
    'EUR' => 'Euro',
    'BZD' => 'Dollar',
    'BMD' => 'Dollar',
    'BOB' => 'Bolivianos',
    'BAM' => 'Konvertierbare Marka',
    'BWP' => 'Pula',
    'BGN' => 'Leva',
    'BRL' => 'Reais',
    'GBP' => 'Pfund',
    'BND' => 'Dollar',
    'KHR' => 'Riel',
    'CAD' => 'Dollar',
    'KYD' => 'Dollar',
    'CLP' => 'Pesos',
    'CNY' => 'Yuan Renminbi',
    'COP' => 'Pesos',
    'CRC' => 'Colón',
    'HRK' => 'Kuna',
    'CUP' => 'Pesos',
    'CZK' => 'Koruny',
    'DKK' => 'Kronen',
    'DOP' => 'Pesos',
    'XCD' => 'Dollar',
    'EGP' => 'Pfund',
    'SVC' => 'Colones',
    'EEK' => 'Krooni',
    'FKP' => 'Pfund',
    'FJD' => 'Dollar',
    'GHC' => 'CeDiS',
    'GIP' => 'Pfund',
    'GTQ' => 'Quetzales',
    'GGP' => 'Pfund',
    'GYD' => 'Dollar',
    'HNL' => 'Lempiras',
    'HKD' => 'Dollar',
    'HUF' => 'Forint',
    'ISK' => 'Kronur',
    'INR' => 'Rupien',
    'IDR' => 'Rupiah',
    'IRR' => 'Rial',
    'IMP' => 'Pfund',
    'ILS' => 'Neuer Schekel',
    'JMD' => 'Dollar',
    'JPY' => 'Yen',
    'JEP' => 'Pfund',
    'KZT' => 'Tenge',
    'KPW' => 'Won',
    'KRW' => 'Won',
    'KGS' => 'Soms',
    'LAK' => 'Kips',
    'LVL' => 'Lati',
    'LBP' => 'Pfund',
    'LRD' => 'Dollar',
    'CHF' => 'Schweizer Franken',
    'LTL' => 'Litai',
    'MKD' => 'Denar',
    'MYR' => 'Ringgit',
    'MUR' => 'Rupien',
    'MXN' => 'Pesos',
    'MNT' => 'Tugriks',
    'MZN' => 'Meticais',
    'NAD' => 'Dollar',
    'NPR' => 'Rupien',
    'ANG' => 'Gulden',
    'NZD' => 'Dollar',
    'NIO' => 'Cordobas',
    'NGN' => 'Naira',
    'NOK' => 'Krone',
    'OMR' => 'Rial',
    'PKR' => 'Rupien',
    'PAB' => 'Balboa',
    'PYG' => 'Guarani',
    'PEN' => 'Nuevos Soles',
    'PHP' => 'Pesos',
    'PLN' => 'Zloty',
    'QAR' => 'Rial',
    'RON' => 'New Lei',
    'RUB' => 'Rubel',
    'SHP' => 'Pfund',
    'SAR' => 'Rial',
    'RSD' => 'Dinar',
    'SCR' => 'Rupien',
    'SGD' => 'Dollar',
    'SBD' => 'Dollar',
    'SOS' => 'Schilling',
    'ZAR' => 'Rand',
    'LKR' => 'Rupien',
    'SEK' => 'Kronen',
    'SRD' => 'Dollar',
    'SYP' => 'Pfund',
    'TWD' => 'Neue Dollar',
    'THB' => 'Baht',
    'TTD' => 'Dollar',
    'TRY' => 'Lira',
    'TRL' => 'Lira',
    'TVD' => 'Dollar',
    'UAH' => 'Griwna',
    'UYU' => 'Pesos',
    'UZS' => 'Som',
    'VEF' => 'Bolivares Fuertes',
    'VND' => 'Dong',
    'YER' => 'Rial',
    'ZWD' => 'Zimbabwe Dollar',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'Sehr hoch',
    '4' => 'Hoch',
    '3' => 'Neutral',
    '2' => 'Niedrig',
    '1' => 'Sehr niedrig',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'Kein(e)',
    'future' => 'Aktueller Wert',
    'old' => 'Alter Wert',
    'both' => 'Aktueller und alter Wert',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Einzel-Treffer',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'In Bearbeitung',
    'error' => 'Fehler',
    'success' => 'Erfolgreich',
    'canceled' => 'Abgebrochen',
    'document_load' => 'Vorlage wird geladen',
    'tags_extract' => 'Tags werden extrahiert',
    'tags_validate' => 'Tags werden validiert',
    'data_retrieving' => 'Daten werden abgerufen',
    'serialize_document' => 'Dokument wieder wieder zusammengesetzt',
    'send_document' => 'Dokument wird an Sie geschickt',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'Zusammenführen',
    'convert' => 'PDF-Zusammenführung',
    'multimerge' => 'Mehrfache Zusammenführung',
    'multimerge_convert' => 'Mehrfache PDF-Zusammenführung',
    'labelsgenerate' => 'Bezeichnungen generieren',
    'labelsgenerate_convert' => 'PDF-Bezeichnungen generieren',
    'excel' => 'Excel-Zusammenführung',
    'excel_convert' => 'Konvertierung von Excel-Zusammenführungen',
    'presentation' => 'PowerPoint-Zusammenführung',
    'presentation_convert' => 'PowerPoint-PDF-Zusammenführung',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'Meine Firmen',
    'favorites' => 'Bevorzugte Firmen',
    'tags' => 'Markierte Firmen',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'Alle Neuigkeiten',
    'General' => 'Allgemein',
    'Finance' => 'Finanzen',
    'People' => 'Personal',
    'Press Releases' => 'Pressemitteilungen',
    'Other' => 'Andere',
];

$app_strings['LBL_OWNERS'] = 'Eigentümer';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Cloud-Laufwerk';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'Cloud-Laufwerk Integrations-Dashlet';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'Link kopieren';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'Download';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Sugar Dokument erstellen';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'Datei konnte nicht heruntergeladen werden';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'Cloud-Dashlet nicht vorhanden';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar-Dokument erstellt';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'An DocuSign senden';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign ist von diesem Speicherort aus nicht verfügbar.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'Die Option "Dokument mit Word/Excel/PowerPoint verbinden" steht an diesem Speicherort nicht zur Verfügung';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = '"Dokument mit DocuSign verbinden" steht an diesem Speicherort nicht zur Verfügung';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = '"Dokument mit PDF verbinden" steht an diesem Speicherort nicht zur Verfügung';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'Ihre signierte Datei wird nur dann hier hochgeladen, wenn Sie die Berechtigung zum Hochladen an diesem Standort haben.';
$app_strings['LBL_DOC_MERGE_TO'] = 'Dokument-Zusammenführung in';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Wort / Excel / Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'Meine Dateien';
$app_strings['LBL_SHARED_WITH_ME'] = 'Mit mir geteilt';
$app_strings['LBL_CLOUD_PROVIDER'] = 'Cloud Anbieter';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'Mit mir geteilt';
$app_strings['LBL_MY_FILES'] = 'Meine Dateien';
$app_strings['LBL_UPLOAD_FILE'] = 'Datei hochladen';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'Ordner nicht gefunden';
$app_strings['LBL_CREATE_FOLDER'] = 'Ordner erstellen';
$app_strings['LBL_LOAD_MORE'] = 'Mehr laden...';
$app_strings['LBL_NEW_FOLDER'] = 'Neuer Ordner';
$app_strings['LBL_FOLDER_NAME'] = 'Ordnername:';
$app_strings['LBL_PERMISSION_ERROR'] = 'Sie haben dafür auf dem aktuellen Pfad nicht die Erlaubnis.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'Sie haben nicht die Erlaubnis, auf den aktuellen Pfad zu gehen.';
$app_strings['LBL_FILE_UPLOADED'] = 'Die Datei wurde hochgeladen.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'Aufgrund der Größe Ihrer Datei dauert das Hochladen etwas länger.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'Ein oder mehrere Dokumentendatensätze enthalten keine angehängte Datei. Bitte hängen Sie Dateien an die Datensätze an und versuchen Sie es erneut oder synchronisieren Sie bestimmte Datensätze mit Dateien einzeln.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Verbindung mit Google nicht gefunden...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Verbindung mit Microsoft nicht gefunden...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Verbindung mit Dropbox nicht gefunden...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'Synchronisierung mit OneDrive kann eine Weile dauern';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'Möchten Sie diese Datei wirklich löschen?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDrive-Upload ist abgeschlossen.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = 'wurde erfolgreich aktualisiert.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'Fehler beim Laden von Pfaden.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'Es ist ein Fehler aufgetreten, weil die Datei beschädigt ist.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'Das Dokument <i>"{{documentName}}"</i> wurde auf Ihrem Cloud-Laufwerk gespeichert und dem Dokument-Modul hinzugefügt.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'Sie haben nicht die entsprechenden Benutzerrechte, um diese Datei zu löschen.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'Sie haben nicht die Berechtigung, um diesen Ordner zu löschen.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'Sie haben nicht die Berechtigungen, um Dateien an diesen Speicherort hochzuladen.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'Sie haben nicht die Berechtigung, um einen Ordner an diesem Speicherort zu erstellen.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'An diesem Speicherort können keine Ordner erstellt werden.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'An diesem Speicherort können keine Ordner hochgeladen werden.';
$app_strings['LBL_SITES'] = 'Websites';
$app_strings['LBL_SHARED'] = 'Geteilt';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'Link erstellt. Klicken Sie auf die Schaltfläche, um den Link in die Zwischenablage zu kopieren.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'In Zwischenablage kopieren';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-leer-',
    'Exact' => 'Exakt',
    'Null_address_components' => 'Eine oder viele Adressenkomponenten sind leer',
    'Invalid_address' => 'Ungültige Adresse, der Server meldet "Fehlanzeige"',
    'Invalid_server_response_not_XML' => 'Ungültige Serverantwort, "nicht XML"',
    'Invalid_address_no_location' => 'Ungültige Adresse, der Server meldet "kein Standort"',
    'Ambiguous_address' => 'Mehrdeutige Adresse, mehrere Treffer',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'Straße',
    'a' => 'Luftaufnahme',
    'rd' => 'Straße dunkel',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'English (US)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'New York (EST)'],
    ['pst', 'Los Angeles (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['Neu', 'Neu'],
    ['Zugewiesen', 'Zugewiesen'],
    ['Geschlossen', 'Geschlossen'],
    ['Eingabe ausstehend', 'Eingabe ausstehend'],
    ['Abgelehnt', 'Abgelehnt'],
    ['Duplikat', 'Duplikat'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['Administration', 'Administration'],
    ['Produkt', 'Produkt'],
    ['Benutzer', 'Benutzer'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'Hoch'],
    ['P2', 'Mittel'],
    ['P3', 'Niedrig'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['Benutzer', 'Benutzer'],
    ['Adminstrator:in, Benutzer:in', 'Admin'],
    ['Account Manager, Benutzer', 'Account Manager'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', 'Letzte 30 Tage'],
    ['last_90_days', 'Letzte 90 Tage'],
    ['this_year', 'Letztes Jahr'],
    ['benutzerdefiniert', 'Benutzerdefinierter Bereich'],
    ['all', 'Alle'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['Standard', 'Standard'],
    ['Farbe', 'Volltonfarbe'],
    ['URL', 'Benutzerdefiniertes Bild'],
];
