<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'Dansk',
    'moduleList' => [
        'Home' => 'Startside',
        'Contacts' => 'Kontakter',
        'Accounts' => 'Konti',
        'Opportunities' => 'Salgsmuligheder',
        'Cases' => 'Sager',
        'Notes' => 'Noter',
        'Calls' => 'Opkald',
        'Emails' => 'E-mails',
        'Meetings' => 'Møder',
        'Tasks' => 'Opgaver',
        'Calendar' => 'Kalender',
        'Leads' => 'Kundeemner',
        'Currencies' => 'Valutaer',
        'Contracts' => 'Kontrakter',
        'Quotes' => 'Tilbud',
        'Products' => 'Produkter',
        'WebLogicHooks' => 'Web Logic Hooks',
        'ProductCategories' => 'Produktkategorier',
        'ProductTypes' => 'Produkttyper',
        'ProductTemplates' => 'Produktkatalog',
        'ProductBundles' => 'Produkt-pakkeløsninger',
        'ProductBundleNotes' => 'Bemærkninger til produkt-pakkeløsninger',
        'Reports' => 'Rapporter',
        'Forecasts' => 'Prognoser',
        'ForecastWorksheets' => 'Prognose regneark',
        'ForecastManagerWorksheets' => 'Prognose Manager Worksheets',
        'VisualPipeline' => 'Visuel kanal',
        'ConsoleConfiguration' => 'Konsolkonfiguration',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'Kvoter',
        'Teams' => 'Team',
        'TeamNotices' => 'Teammeddelelser',
        'Manufacturers' => 'Producenter',
        'Activities' => 'Aktiviteter',
        'Comments' => 'Kommentarer',
        'Subscriptions' => 'Abonnementer',
        'Bugs' => 'Fejl',
        'Feeds' => 'RSS',
        'iFrames' => 'Mine websteder',
        'TimePeriods' => 'Tidsperioder',
        'TaxRates' => 'Momssatser',
        'ContractTypes' => 'Kontrakttyper',
        'Schedulers' => 'Planlæggere',
        'Project' => 'Projekter',
        'ProjectTask' => 'Projektopgaver',
        'Campaigns' => 'Kampagner',
        'CampaignLog' => 'Kampagnelog',
        'CampaignTrackers' => 'Kampagnesporinger',
        'Documents' => 'Dokumenter',
        'DocumentRevisions' => 'Dokumentrevisioner',
        'Connectors' => 'Forbindelser',
        'Notifications' => 'Meddelelser',
        'Sync' => 'Synkroniser',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => 'Eksterne brugere',
        'ReportMaker' => 'Virksomhedsrapporter',
        'DataSets' => 'Dataformater',
        'CustomQueries' => 'Brugerdefinerede forespørgsler',
        'pmse_Inbox' => 'Processer',
        'pmse_Project' => 'Procesdefinitioner',
        'pmse_Business_Rules' => 'Proces forretningsregler',
        'pmse_Emails_Templates' => 'Proces e-mail-skabeloner',
        'BusinessCenters' => 'Forretningscentre',
        'Shifts' => 'Shift',
        'ShiftExceptions' => 'Shift-undtagelser',
        'Purchases' => 'Køb',
        'PurchasedLineItems' => 'Købte linjeprodukter',
        'MobileDevices' => 'MobileEnheder',
        'PushNotifications' => 'PushNotifikationer',
        'Escalations' => 'Eskaleringer',
        'DocumentTemplates' => 'Dokumentskabeloner',
        'DocumentMerges' => 'Dokumentfletninger',
        'CloudDrivePaths' => 'Cloud Drive-stier',
        'WorkFlow' => 'Arbejdsgangdefinitioner:',
        'EAPM' => 'Eksterne konti',
        'Worksheet' => 'Regneark',
        'Users' => 'Brugere',
        'Employees' => 'Medarbejdere',
        'Administration' => 'Administration',
        'ACLRoles' => 'Roller',
        'InboundEmail' => 'Indgående e-mail',
        'Releases' => 'Udgivelser',
        'Prospects' => 'Mål',
        'Queues' => 'Køer',
        'EmailMarketing' => 'E-mail-markedsføring',
        'EmailTemplates' => 'E-mail-skabeloner',
        'SNIP' => 'E-mail arkivering',
        'ProspectLists' => 'Målgruppelister',
        'SavedSearch' => 'Gemte søgninger',
        'UpgradeWizard' => 'Guiden Opgradering',
        'Trackers' => 'Sporinger',
        'TrackerPerfs' => 'Sporingsperformance',
        'TrackerSessions' => 'Sporingssessioner',
        'TrackerQueries' => 'Sporingsforespørgsler',
        'FAQ' => 'Ofte stillede spørgsmål',
        'Newsletters' => 'Nyhedsbreve',
        'SugarFavorites' => 'Favoriter',
        'PdfManager' => 'PdfManager',
        'DataArchiver' => 'Dataarkivar',
        'ArchiveRuns' => 'Arkivkørsler',

        'OAuthKeys' => 'OAuth forbugertaster',
        'OAuthTokens' => 'OAuth Tokens',
        'Filters' => 'Filtre',
        'UserSignatures' => 'E-mail-signaturer',
        'Shippers' => 'Speditører',
        'Styleguide' => 'Styleguide',
        'Feedbacks' => 'Feedbacks',
        'Tags' => 'Tags',
        'Categories' => 'Kategorier',
        'Dashboards' => 'Betjeningspaneler',
        'OutboundEmail' => 'E-mail-indstillinger',
        'EmailParticipants' => 'E-mail-deltagere',
        'DataPrivacy' => 'Beskyttelse af personlige oplysninger',
        'ReportSchedules' => 'Posttidsplaner',
        'CommentLog' => 'Kommentarregister',
        'Holidays' => 'Ferier',
        'ChangeTimers' => 'Skift timere',
        'Metrics' => 'Effektivitetsmålinger',
        'Messages' => 'Meddelelser',
        'Audit' => 'Revision',
        'RevenueLineItems' => 'Indtægtsposter',
        'DocuSignEnvelopes' => 'DocuSign-konvolutter',
        'Geocode' => 'Geokode',
        'DRI_Workflows' => 'Smart Guides',
        'DRI_Workflow_Task_Templates' => 'Smart Guide-aktivitetsskabeloner',
        'DRI_SubWorkflows' => 'Smart Guide-faser',
        'DRI_Workflow_Templates' => 'Smart Guide-skabeloner',
        'CJ_WebHooks' => 'Sugar Automate-webhooks',
        'CJ_Forms' => 'Smart Guide Sugar-handlinger',
        'DRI_SubWorkflow_Templates' => 'Smart Guide-faseskabeloner',
        'PubSub_ModuleEvent_PushSubs' => 'Push-abonnementer for hændelse i Pub/Sub-modul',
    ],

    'moduleIconList' => [
        'Home' => 'Ho',
        'Contacts' => 'Co',
        'Accounts' => 'Ac',
        'Opportunities' => 'Op',
        'Cases' => 'Sager',
        'Notes' => 'Noter',
        'Calls' => 'Opkald',
        'Emails' => 'Em',
        'Meetings' => 'Me',
        'Tasks' => 'Opgave',
        'Calendar' => 'Ca',
        'Leads' => 'Le',
        'Currencies' => 'Cu',
        'Contracts' => 'Co',
        'Quotes' => 'Qu',
        'Products' => 'QL',
        'WebLogicHooks' => 'WL',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'PT',
        'ProductTemplates' => 'PC',
        'ProductBundles' => 'PB',
        'ProductBundleNotes' => 'PB',
        'Reports' => 'Re',
        'Forecasts' => 'Fo',
        'ForecastWorksheets' => 'FW',
        'ForecastManagerWorksheets' => 'FM',
        'Quotas' => 'Fo',
        'VisualPipeline' => 'VP',
        'ConsoleConfiguration' => 'CC',
        'SugarLive' => 'Su',
        'Teams' => 'Te',
        'TeamNotices' => 'TN',
        'Manufacturers' => 'Ma',
        'Activities' => 'Ac',
        'Comments' => 'Co',
        'Subscriptions' => 'Su',
        'Bugs' => 'Bu',
        'Feeds' => 'RS',
        'iFrames' => 'MS',
        'TimePeriods' => 'TP',
        'TaxRates' => 'TR',
        'ContractTypes' => 'CT',
        'Schedulers' => 'Sc',
        'Project' => 'Pr',
        'ProjectTask' => 'PT',
        'Campaigns' => 'Ca',
        'CampaignLog' => 'CL',
        'CampaignTrackers' => 'CT',
        'Documents' => 'Do',
        'DocumentRevisions' => 'DR',
        'Connectors' => 'Co',
        'Notifications' => 'No',
        'Sync' => 'Sy',
        'HintAccountsets' => 'Hi',
        'HintNotificationTargets' => 'Tip',
        'HintNewsNotifications' => 'Nyt',
        'HintEnrichFieldConfigs' => 'Opd',
        'ExternalUsers' => 'EkstB',
        'ReportMaker' => 'Rapp',
        'DataSets' => 'DS',
        'CustomQueries' => 'KS',
        'pmse_Inbox' => 'Indb',
        'pmse_Project' => 'PRJKT',
        'pmse_Business_Rules' => 'FR',
        'pmse_Emails_Templates' => 'ES',
        'BusinessCenters' => 'BC',
        'Shifts' => 'Skift',
        'ShiftExceptions' => 'SkfU',
        'Purchases' => 'Køb',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'Mob',
        'PushNotifications' => 'Push',
        'Escalations' => 'Esk',
        'DocumentTemplates' => 'DS',
        'DocumentMerges' => 'DF',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'ArbF',
        'EAPM' => 'EAPM',
        'Worksheet' => 'ArbA',
        'Users' => 'Brg',
        'Employees' => 'Marb',
        'Administration' => 'Adm',
        'ACLRoles' => 'Rolle',
        'InboundEmail' => 'Ind',
        'Releases' => 'Udg',
        'Prospects' => 'Pot',
        'Queues' => 'Køer',
        'EmailMarketing' => 'EMM',
        'EmailTemplates' => 'EMS',
        'SNIP' => 'SNIP',
        'ProspectLists' => 'POTL',
        'SavedSearch' => 'GS',
        'UpgradeWizard' => 'OPGW',
        'Trackers' => 'Spor',
        'TrackerPerfs' => 'TRP',
        'TrackerSessions' => 'TRS',
        'TrackerQueries' => 'TRSP',
        'FAQ' => 'FAQ',
        'Newsletters' => 'NhB',
        'SugarFavorites' => 'Fav',
        'PdfManager' => 'PDFM',
        'DataArchiver' => 'DTA',
        'ArchiveRuns' => 'ARK',
        'OAuthKeys' => 'AUTN',
        'OAuthTokens' => 'AUTT',
        'Filters' => 'Filtr',
        'UserSignatures' => 'BRGS',
        'Shippers' => 'SHP',
        'Styleguide' => 'StG',
        'Feedbacks' => 'Fb',
        'Tags' => 'Tags',
        'Categories' => 'Kat',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'UD',
        'EmailParticipants' => 'ED',
        'DataPrivacy' => 'DB',
        'ReportSchedules' => 'RSK',
        'CommentLog' => 'KL',
        'Holidays' => 'Ferie',
        'ChangeTimers' => 'ST',
        'Metrics' => 'Meter',
        'Messages' => 'Besk',
        'Audit' => 'Rev',
        'RevenueLineItems' => 'ILP',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'Geo',
        'DRI_Workflows' => 'Arbfl',
        'DRI_Workflow_Task_Templates' => 'Arbop',
        'DRI_SubWorkflows' => 'Uarb',
        'DRI_Workflow_Templates' => 'Arbsk',
        'CJ_WebHooks' => 'WH',
        'CJ_Forms' => 'SG',
        'DRI_SubWorkflow_Templates' => 'UAS',
        'Library' => 'Bib',
        'EmailAddresses' => 'EA',
        'Words' => 'Ord',
        'Sugar_Favorites' => 'Fav',
        'KBDocuments' => 'KBDOK',
        'KBContents' => 'KBIHD',
        'KBArticles' => 'KBART',
        'KBContentTemplates' => 'KBIHS',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'ILF',
    ],

    'moduleListSingular' => [
        'Home' => 'Startside',
        'Dashboards' => 'Betjeningspanel',
        'Styleguide' => 'Styleguide',
        'Contacts' => 'Kontakt',
        'Accounts' => 'Virksomhed',
        'Opportunities' => 'Salgsmulighed',
        'Cases' => 'Sag',
        'Notes' => 'Note',
        'Calls' => 'Opkald',
        'Emails' => 'E-mail',
        'Meetings' => 'Møde',
        'Tasks' => 'Opgave',
        'Calendar' => 'Kalender',
        'Leads' => 'Kundeemne',
        'Manufacturers' => 'Producent',
        'VisualPipeline' => 'VisuelKanal',
        'ConsoleConfiguration' => 'KonsolKonfiguration',
        'MobileDevices' => 'MobilEnhed',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'Kontrakt',
        'Quotes' => 'Tilbud',
        'Products' => 'Angiven linjepost',
        'ProductCategories' => 'Produktkategori',
        'ProductBundles' => 'Produkt-pakkeløsning',
        'ProductBundleNotes' => 'Bemærkning til produkt-pakkeløsninger',
        'RevenueLineItems' => 'Revenue detaljposter',
        'WebLogicHooks' => 'Web Logic Hook',
        'Reports' => 'Rapport',
        'Forecasts' => 'Forpligte stadie prognose',
        'ForecastWorksheets' => 'Foreløbigt regneark',
        'ForecastManagerWorksheets' => 'Prognose Manager Worksheets',
        'Quotas' => 'Kvote',
        'Teams' => 'Team',
        'TeamNotices' => 'Teammeddelelse',
        'Activities' => 'Aktivitet',
        'ActivityStream' => 'Aktiviteter',
        'Bugs' => 'Fejl',
        'Feeds' => 'RSS',
        'iFrames' => 'Mine websteder',
        'TimePeriods' => 'Tidsperiode',
        'TaxRates' => 'Skatteprocent',
        'ContractTypes' => 'Kontrakttype',
        'Schedulers' => 'Planlægger',
        'Campaigns' => 'Kampagne',
        'CampaignLog' => 'Kampagnelog',
        'Project' => 'Projekt',
        'ProjectTask' => 'Projektopgave',
        'Prospects' => 'Mål:',
        'ProspectLists' => 'Målgruppeliste',
        'CampaignTrackers' => 'Kampagne tracker',
        'Documents' => 'Dokument',
        'DocumentRevisions' => 'Dokumentrevision',
        'Connectors' => 'Forbindelse',
        'Notifications' => 'Meddelelse',
        'Sync' => 'Synkroniser',
        'PdfManager' => 'PdfManager',
        'DataArchiver' => 'Dataarkivar',
        'ArchiveRuns' => 'Arkivkørsler',
        'ExternalUsers' => 'Ekstern bruger',
        'ReportMaker' => 'SweetReport',
        'DataSets' => 'Dataformat',
        'CustomQueries' => 'Brugerdefineret forespørgsel:',
        'pmse_Inbox' => 'Proces',
        'pmse_Project' => 'Procesdefinition',
        'pmse_Business_Rules' => 'Proces forretningsregel',
        'pmse_Emails_Templates' => 'Proces e-mail-skabelon',
        'BusinessCenters' => 'Forretningscenter',
        'Shifts' => 'Shift',
        'ShiftExceptions' => 'Shift-undtagelser',
        'Purchases' => 'Køb',
        'PurchasedLineItems' => 'Købt linjeprodukt',
        'PushNotifications' => 'PushNotifikation',
        'Escalations' => 'Eskalering',
        'DocumentTemplates' => 'Dokumentskabelon',
        'DocumentMerges' => 'Dokumentflet',
        'CloudDrivePaths' => 'Cloud Drive-sti',
        'WorkFlow' => 'Workflow',
        'EAPM' => 'Ekstern konto',
        'Worksheet' => 'Regneark',
        'Users' => 'Bruger',
        'SugarFavorites' => 'Favoritter',
        'Employees' => 'Medarbejder',
        'Administration' => 'Administration',
        'ACLRoles' => 'Rolle:',
        'InboundEmail' => 'Indgående e-mail',
        'Releases' => 'Udgivelse',
        'Queues' => 'Kø',
        'EmailMarketing' => 'E-mail-markedsføring',
        'EmailTemplates' => 'E-mail-skabelon',
        'SNIP' => 'E-mail arkivering',
        'SavedSearch' => 'Gemte søgninger',
        'UpgradeWizard' => 'Guiden Opgradering',
        'Trackers' => 'Sporing',
        'TrackerPerfs' => 'Sporingsperformance',
        'TrackerSessions' => 'Sporingssessioner',
        'TrackerQueries' => 'Sporingsforespørgsler',
        'FAQ' => 'Ofte stillede spørgsmål',
        'Newsletters' => 'Nyhedsbrev',
        'OAuthKeys' => 'OAuth forbrugernøgle',
        'OAuthTokens' => 'OAuth Token',
        'Filters' => 'Filter',
        'Comments' => 'Kommentar',
        'CommentLog' => 'Kommentarregister',
        'Currencies' => 'Valuta',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'Produkttype:',
        'Shippers' => 'Speditør',
        'Subscriptions' => 'Abonnement',
        'UserSignatures' => 'E-mail-signatur',
        'Feedbacks' => 'Feedback',
        'Tags' => 'Tag',
        'Categories' => 'Kategori navn',
        'OutboundEmail' => 'E-mail-indstilling',
        'EmailParticipants' => 'Email-deltager',
        'DataPrivacy' => 'Beskyttelse af personlige oplysninger',
        'ReportSchedules' => 'Posttidsplan',
        'Holidays' => 'Ferie',
        'ChangeTimers' => 'Skift timer',
        'Metrics' => 'Effektivitetsmåling',
        'Messages' => 'Meddelelse',
        'Audit' => 'Revision',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => 'Geokode',
        'DRI_Workflows' => 'Smart Guide',
        'DRI_Workflow_Task_Templates' => 'Smart Guide-aktivitetsskabelon',
        'DRI_SubWorkflows' => 'Smart Guide-fase',
        'DRI_Workflow_Templates' => 'Smart Guide-skabelon',
        'CJ_WebHooks' => 'Sugar Automate-webhook',
        'CJ_Forms' => 'Smart Guide Sugar-handling',
        'DRI_SubWorkflow_Templates' => 'Smart Guide-faseskabelon',
        'PubSub_ModuleEvent_PushSubs' => 'Push-abonnement for hændelse i Pub/Sub-modul',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'Ja',
        '2' => 'Nej',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'Nej',
        1 => 'Ja',
    ],

    'notifications_status_dom' => [
        0 => 'Ulæst',
        1 => 'Læs',
    ],

    'optout_dom' => [
        '' => '-ingen-',
        'false' => 'Nej',
        'true' => 'Ja',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'Analytiker',
        'Competitor' => 'Konkurrent',
        'Customer' => 'Kunde',
        'Integrator' => 'Integrator',
        'Investor' => 'Investor',
        'Partner' => 'Partner',
        'Press' => 'Press',
        'Prospect' => 'Potentiel kunde',
        'Reseller' => 'Forhandler',
        'Other' => 'Andet',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'Beklædning',
        'Banking' => 'Bank',
        'Biotechnology' => 'Bioteknologi',
        'Chemicals' => 'Kemikalier',
        'Communications' => 'Kommunikation',
        'Construction' => 'Byggeri',
        'Consulting' => 'Rådgivning',
        'Education' => 'Uddannelse',
        'Electronics' => 'Elektronik',
        'Energy' => 'Energi',
        'Engineering' => 'Teknik',
        'Entertainment' => 'Underholdning',
        'Environmental' => 'Miljø',
        'Finance' => 'Finans',
        'Government' => 'Offentlig',
        'Healthcare' => 'Sundhed',
        'Hospitality' => 'Hotel og restaurant',
        'Insurance' => 'Forsikring',
        'Machinery' => 'Maskiner',
        'Manufacturing' => 'Fremstilling',
        'Media' => 'Medier',
        'Not For Profit' => 'Non-profit',
        'Recreation' => 'Fritid',
        'Retail' => 'Detailhandel',
        'Shipping' => 'Fragt',
        'Technology' => 'Teknologi',
        'Telecommunications' => 'Telekommunikation',
        'Transportation' => 'Transport',
        'Utilities' => 'Forsyningsvirksomhed',
        'Other' => 'Andet',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF og CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'Dagram',
        'Data Table' => 'Datatabel',
        'Chart and Data Table' => 'Diagram og Datatabel',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'I gang',
        'Completed' => 'Fuldført',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'Indgående',
        'Outbound' => 'Udgående',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'Chat',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'Tier 1',
        'T2' => 'Tier 2',
        'T3' => 'Tier 3',
        'T4' => 'Tier 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nej',
        'Completed' => 'Fuldført',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'Fremtid',
        'Active' => 'Aktiv',
        'Past' => 'Fortid',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'Selvgenereret',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'Uopfordret opkald',
        'Existing Customer' => 'Eksisterende kunde',
        'Self Generated' => 'Selvgenereret',
        'Employee' => 'Medarbejder',
        'Partner' => 'Partner',
        'Public Relations' => 'PR',
        'Direct Mail' => 'Direct mail',
        'Conference' => 'Konference',
        'Trade Show' => 'Messe',
        'Web Site' => 'Websted',
        'Word of mouth' => 'Mund-til-mund',
        'Email' => 'E-mail',
        'Campaign' => 'Kampagne',
        'Support Portal User Registration' => 'Support portal bruger registrering',
        'Other' => 'Andet',
    ],
    'metric_status_dom' => [
        'Inactive' => 'Inaktiv',
        'Active' => 'Aktiv',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'Eksisterende forretning',
        'New Business' => 'Ny forretning',
    ],
    'taxrate_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
    ],
    'roi_type_dom' => [
        'Revenue' => 'Omsætning',
        'Investment' => 'Investering',
        'Expected_Revenue' => 'Forventet indtægt',
        'Budget' => 'Budget',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'Primær beslutningstager',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primær beslutningstager',
        'Business Decision Maker' => 'Forretningsbeslutningstager',
        'Business Evaluator' => 'Forretningsevaluator',
        'Technical Decision Maker' => 'Teknisk beslutningstager',
        'Technical Evaluator' => 'Teknisk evaluator',
        'Executive Sponsor' => 'Ledende sponsor',
        'Influencer' => 'Influent',
        'Other' => 'Andet',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
    ],

    'shipper_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'Primær kontakt',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'Primær kontakt',
        'Alternate Contact' => 'Alternativ kontakt',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'Ud for feltværdi',
        'field_on_top' => 'Over feltværdi',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'Netto 15',
        'Net 30' => 'Netto 30',
    ],
    'sales_stage_default_key' => 'Forundersøgelse',
    'fts_type' => [
        'Elastic' => 'elasticsearch',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'Forundersøgelse',
        'Qualification' => 'Kvalifikation',
        'Needs Analysis' => 'Behovsanalyse',
        'Value Proposition' => 'Værdiforslag',
        'Id. Decision Makers' => 'Id. beslutningstagere',
        'Perception Analysis' => 'Perceptionsanalyse',
        'Proposal/Price Quote' => 'Forslag/pristilbud',
        'Negotiation/Review' => 'Forhandling/gennemsyn',
        'Closed Won' => 'Lukket vundet',
        'Closed Lost' => 'Lukket mistet',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'Ny',
        'In Progress' => 'I gang',
        'Closed Won' => 'Lukket vundet',
        'Closed Lost' => 'Lukket mistet',
        'Converted to Quote' => 'Konverteret til tilbud',
    ],
    'sales_status_dom' => [
        'New' => 'Ny',
        'In Progress' => 'I gang',
        'Closed Won' => 'Lukket vundet',
        'Closed Lost' => 'Lukket mistet',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'Inklusive',
        'exclude' => 'Ekskluder',
    ],
    'commit_stage_dom' => [
        'include' => 'Inklusive',
        'upside' => 'Overside',
        'exclude' => 'Ekskluder',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'Inklusive',
        'upside' => 'Overside',
        'exclude' => 'Ekskluder',
    ],

    'in_total_group_stages' => [
        'Draft' => 'Kladde',
        'Negotiation' => 'Forhandling',
        'Delivered' => 'Leveret',
        'On Hold' => 'På hold',
        'Confirmed' => 'Bekræftet',
        'Closed Accepted' => 'Lukket accepteret',
        'Closed Lost' => 'Lukket mistet',
        'Closed Dead' => 'Lukket Ikke interesseret',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'Opkald',
        'Meeting' => 'Møde',
        'Task' => 'Opgave',
        'Email' => 'E-mail',
        'Note' => 'Note',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'Hr.',
        'Ms.' => 'Fru',
        'Mrs.' => 'Frk.',
        'Dr.' => 'Mr.',
        'Prof.' => 'Prof.',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'Ingen',
        60 => '1 minut før',
        300 => '5 minutter før',
        600 => '10 minutter før',
        900 => '15 minutter før',
        1800 => '30 minutter før',
        3600 => '1 time før',
        7200 => '2 timer før',
        10800 => '3 timer før',
        18000 => '5 timer før',
        86400 => '1 dag før',
        ],

        'task_priority_default' => 'Medium',
        'task_priority_dom' => [
        'High' => 'Høj',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'task_status_default' => 'Ikke påbegyndt',
        'task_status_dom' => [
        'Not Started' => 'Ikke påbegyndt',
        'In Progress' => 'I gang',
        'Completed' => 'Fuldført',
        'Pending Input' => 'Afventer input',
        'Deferred' => 'Udskudt',
        'Not Applicable' => 'Ikke relevant',
        ],
        'meeting_status_default' => 'Planlagt',
        'meeting_status_dom' => [
        'Planned' => 'Planlagt',
        'Held' => 'Afholdt',
        'Not Held' => 'Annulleret',
        'Deferred' => 'Udskudt',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'Andet',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'Planlagt',
        'call_status_dom' => [
        'Planned' => 'Planlagt',
        'In Progress' => 'I gang',
        'Held' => 'Holdt',
        'Not Held' => 'Annulleret',
        'Deferred' => 'Udskudt',
        ],
        'call_direction_default' => 'Udgående',
        'call_direction_dom' => [
        'Inbound' => 'Indgående',
        'Outbound' => 'Udgående',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'Ny',
        'Assigned' => 'Tildelt',
        'In Process' => 'Startet',
        'Converted' => 'Konverteret',
        'Recycled' => 'Genbrugt',
        'Dead' => 'Ikke interesseret',
        ],
        'gender_list' => [
        'male' => 'Mand',
        'female' => 'Kvinde',
        'other' => 'Andet',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'Ny',
        'case_status_dom' => [
        'New' => 'Ny',
        'Assigned' => 'Tildelt',
        'Closed' => 'Lukket',
        'Pending Input' => 'Afventer input',
        'Rejected' => 'Afvist',
        'Duplicate' => 'Dupliker',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'Høj',
        'P2' => 'Medium',
        'P3' => 'Lav',
        ],
        'user_type_dom' => [
        'RegularUser' => 'Almindelig bruger',
        'Administrator' => 'Administrator',
        ],
        'user_type_bool_dom' => [
            false => 'Almindelig bruger',
            true => 'Administrator',
        ],
        'user_type_group_bool_dom' => [
            true => 'Gruppebruger',
        ],
        'user_type_portal_bool_dom' => [
            true => 'Portal-API-bruger',
        ],
        'license_type_dom' => [
        'CURRENT' => 'Nuværende produkt',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'employee_status_dom' => [
        'Active' => 'Aktiv',
        'Terminated' => 'Fratrådt',
        'Leave of Absence' => 'Orlov',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'project_task_priority_options' => [
        'High' => 'Høj',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'project_task_priority_default' => 'Medium',

        'project_task_status_options' => [
        'Not Started' => 'Ikke påbegyndt',
        'In Progress' => 'I gang',
        'Completed' => 'Fuldført',
        'Pending Input' => 'Afventer input',
        'Deferred' => 'Udskudt',
        ],
        'project_task_utilization_options' => [
        '0' => 'ingen',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'Kladde',
        'In Review' => 'Til gennemsyn',
        'Published' => 'Udgivet',
        ],
        'project_status_default' => 'Kladde',

        'project_duration_units_dom' => [
        'Days' => 'Dager',
        'Hours' => 'Timer',
        ],

        'project_priority_options' => [
        'High' => 'Høj',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'project_priority_default' => 'Medium',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Konti',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'Virksomhed',
        'Opportunities' => 'Salgsmulighed',
        'Cases' => 'Sag',
        'Leads' => 'Kundeemne',
        'Contacts' => 'Kontakter', // cn (11/22/2005) added to support Emails
        'Products' => 'Angiven linjepost',
        'Quotes' => 'Tilbud',
        'Bugs' => 'Fejl',
        'Project' => 'Projekt',

        'Prospects' => 'Mål:',
        'ProjectTask' => 'Projektopgave',

        'Tasks' => 'Opgave',
        'KBContents' => 'Videnbase',
        'Notes' => 'Note',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'Virksomhed',
        'Contacts' => 'Kontakt',
        'Opportunities' => 'Salgsmulighed',
        'Tasks' => 'Opgave',
        'ProductTemplates' => 'Produktkatalog',
        'Quotes' => 'Tilbud',
        'Products' => 'Angiven linjepost',
        'Contracts' => 'Kontrakt',
        'Emails' => 'E-mail',

        'Bugs' => 'Fejl',
        'Project' => 'Projekt',
        'ProjectTask' => 'Projektopgave',
        'Prospects' => 'Mål:',
        'Cases' => 'Sag',
        'Leads' => 'Kundeemne',

        'Meetings' => 'Møde',
        'Calls' => 'Opkald',
        'KBContents' => 'Videnbase',
        'PurchasedLineItems' => 'Købt linjeelement',
        'Purchases' => 'Køb',
        'Escalations' => 'Eskalering',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'Virksomhed',
        'Contacts' => 'Kontakt',
        'Employees' => 'Medarbejder',
        'Leads' => 'Kundeemne',
        'Prospects' => 'Mål',
        'Users' => 'Bruger',
        ],

        'parent_type_display' => [
        'Accounts' => 'Virksomhed',
        'Contacts' => 'Kontakt',
        'Tasks' => 'Opgave',
        'Opportunities' => 'Salgsmulighed',
        'Products' => 'Angiven linjepost',
        'Quotes' => 'Tilbud',

        'Bugs' => 'Fejl',
        'Cases' => 'Sag',
        'Leads' => 'Kundeemne',

        'Project' => 'Projekt',
        'ProjectTask' => 'Projektopgave',

        'Prospects' => 'Mål:',
        'KBContents' => 'Videnbase',
        'Notes' => 'Note',
        'PurchasedLineItems' => 'Købt linjeelement',
        'Purchases' => 'Køb',
        'Escalations' => 'Eskalering',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'Sag',
        ],

        'product_status_default_key' => 'Send',
        'product_status_quote_key' => 'Tilbud',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'Tilbudt',
        'Orders' => 'Bestilt',
        'Ship' => 'Afsendt',
        ],
        'active_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        'Retired' => 'Pensioneret',
        ],
        'appearance_options' => [
        'system_default' => 'Brug systemindstilling',
        'light' => 'Lys',
        'dark' => 'Mørk',
        ],


        'pricing_formula_default_key' => 'Fastsat',
        'pricing_formula_dom' => [
        'Fixed' => 'Fast pris',
        'ProfitMargin' => 'Overskudsgrad',
        'PercentageMarkup' => 'Bruttofortjeneste',
        'PercentageDiscount' => 'Rabat fra liste',
        'IsList' => 'Samme som liste',
        ],
        'product_template_status_dom' => [
        'Available' => 'På lager',
        'Unavailable' => 'Ikke på lager',
        ],
        'tax_class_dom' => [
        'Taxable' => 'Momspligtig',
        'Non-Taxable' => 'Ikke-momspligtig',
        ],
        'support_term_dom' => [
        '+6 months' => 'Seks måneder',
        '+1 year' => 'Et år',
        '+2 years' => 'To år',
        ],

        'quote_type_dom' => [
        'Quotes' => 'Tilbud',
        'Orders' => 'Rækkefølge',
        ],
        'default_quote_stage_key' => 'Kladde',
        'quote_stage_dom' => [
        'Draft' => 'Kladde',
        'Negotiation' => 'Forhandling',
        'Delivered' => 'Leveret',
        'On Hold' => 'På hold',
        'Confirmed' => 'Bekræftet',
        'Closed Accepted' => 'Lukket accepteret',
        'Closed Lost' => 'Lukket mistet',
        'Closed Dead' => 'Lukket Ikke interesseret',
        ],
        'default_order_stage_key' => 'Afventer',
        'order_stage_dom' => [
        'Pending' => 'Afventer',
        'Confirmed' => 'Bekræftet',
        'On Hold' => 'På hold',
        'Shipped' => 'Afsendt',
        'Cancelled' => 'Annulleret',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'Primær beslutningstager',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'Primær beslutningstager',
        'Business Decision Maker' => 'Forretningsbeslutningstager',
        'Business Evaluator' => 'Forretningsevaluator',
        'Technical Decision Maker' => 'Teknisk beslutningstager',
        'Technical Evaluator' => 'Teknisk evaluator',
        'Executive Sponsor' => 'Ledende sponsor',
        'Influencer' => 'Influent',
        'Other' => 'Andet',
        ],
        'layouts_dom' => [
        'Standard' => 'Tilbud',
        'Invoice' => 'Faktura',
        ],
        'issue_priority_default_key' => 'Medium',
        'issue_priority_dom' => [
        'Urgent' => 'Haster',
        'High' => 'Høj',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'Accepteret',
        'Duplicate' => 'Dupliker',
        'Closed' => 'Lukket',
        'Out of Date' => 'Forældet',
        'Invalid' => 'Ugyldig',
        ],

        'issue_status_default_key' => 'Ny',
        'issue_status_dom' => [
        'New' => 'Ny',
        'Assigned' => 'Tildelt',
        'Closed' => 'Lukket',
        'Pending' => 'Afventer',
        'Rejected' => 'Afvist',
        ],

        'bug_priority_default_key' => 'Medium',
        'bug_priority_dom' => [
        'Urgent' => 'Haster',
        'High' => 'Høj',
        'Medium' => 'Medium',
        'Low' => 'Lav',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'Accepteret',
        'Duplicate' => 'Dupliker',
        'Fixed' => 'Fastsat',
        'Out of Date' => 'Forældet',
        'Invalid' => 'Ugyldig',
        'Later' => 'Senere',
        ],
        'bug_status_default_key' => 'Ny',
        'bug_status_dom' => [
        'New' => 'Ny',
        'Assigned' => 'Tildelt',
        'Closed' => 'Lukket',
        'Pending' => 'Afventer',
        'Rejected' => 'Afvist',
        ],
        'bug_type_default_key' => 'Fejl',
        'bug_type_dom' => [
        'Defect' => 'Defekt',
        'Feature' => 'Funktion',
        ],
        'case_type_dom' => [
        'Administration' => 'Administration',
        'Product' => 'Produkt',
        'User' => 'Bruger',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Internettet',
        'InboundEmail' => 'E-mail',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'Intern',
        'Forum' => 'Forum',
        'Web' => 'Web',
        'InboundEmail' => 'E-mail',
        'Twitter' => 'Twitter',
        'Portal' => 'Portal',
        'Phone' => 'Telefon',
        'Chat' => 'Chat',
        'Chatbot' => 'Chatrobot',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'Anmodning om beskyttelse af personlige oplysninger',
        'Send Personal Information being processed' => 'Send personlige oplysninger behandles',
        'Rectify Information' => 'Ret oplysninger',
        'Request to Erase Information' => 'Anmodning om sletning af oplysninger',
        'Export Information' => 'Eksporter oplysninger',
        'Restrict Processing' => 'Begræns behandling',
        'Object to Processing' => 'Gør indsigelse mod behandling',
        'Consent to Process' => 'Giv samtykke til proces',
        'Withdraw Consent' => 'Træk samtykke tilbage',
        'Other' => 'Andet',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'Erhvervskommunikationer',
        'Marketing Communications by company' => 'Marketingskommunikationer fra virksomhed',
        'Marketing Communications by partners' => 'Marketingskommunikationer fra partnere',
        ],
        'dataprivacy_status_default_key' => 'Åben',
        'dataprivacy_status_dom' => [
        'Open' => 'Åben',
        'Closed' => 'Afsluttet',
        'Rejected' => 'Afvist',
        ],
        'dataprivacy_priority_default_key' => 'Lav',
        'dataprivacy_priority_dom' => [
        'Low' => 'Lav',
        'Medium' => 'Medium',
        'High' => 'Høj',
        ],
        'business_day_status_dom' => [
        'Open' => 'Åben',
        'Open 24 Hours' => 'Åben 24 timer',
        'Closed' => 'Lukket',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'Konti',
        'Activities' => 'Aktiviteter',
        'Bug Tracker' => 'Fejlsporing',
        'Calendar' => 'Kalender',
        'Calls' => 'Opkald',
        'Campaigns' => 'Kampagner',
        'Cases' => 'Sager',
        'Contacts' => 'Kontakter',
        'Currencies' => 'Valutaer',
        'Dashboard' => 'Dashboard',
        'Documents' => 'Dokumenter',
        'Emails' => 'E-mails',
        'Feeds' => 'Feeds',
        'Forecasts' => 'Prognoser',
        'Help' => 'Hjælp',
        'Home' => 'Startside',
        'Leads' => 'Kundeemner',
        'Meetings' => 'Møder',
        'Notes' => 'Noter',
        'Opportunities' => 'Salgsmuligheder',
        'Outlook Plugin' => 'Outlook-plug-in',
        'Product Catalog' => 'Produktkatalog',
        'Products' => 'Produkter',
        'RevenueLineItems' => 'Omsætningsposter',
        'Projects' => 'Projekter',
        'Quotes' => 'Tilbud',
        'Releases' => 'Udgivelser',
        'RSS' => 'RSS',
        'Studio' => 'Studio',
        'Upgrade' => 'Opgradér',
        'Users' => 'Brugere',
        'OutboundEmail' => 'E-mail-indstillinger',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'Planlægning',
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        'Complete' => 'Fuldført',
        'In Queue' => 'I kø',
        'Sending' => 'Sender',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'Telesalg',
        'Mail' => 'Post',
        'Email' => 'E-mail',
        'Print' => 'Udskriv',
        'Web' => 'Internettet',
        'Radio' => 'Radio',
        'Television' => 'Fjernsyn',
        'NewsLetter' => 'Nyhedsbrev',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'Ugentligt',
        'Monthly' => 'Månedligt',
        'Quarterly' => 'Kvartalsvis',
        'Annually' => 'Årlig',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'Januar',
        '2' => 'Februar',
        '3' => 'Marts',
        '4' => 'April',
        '5' => 'Maj',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'August',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'December',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'Jan',
        '2' => 'Feb',
        '3' => 'Mar',
        '4' => 'Apr',
        '5' => 'Maj',
        '6' => 'Jun',
        '7' => 'Jul',
        '8' => 'Aug',
        '9' => 'Sep',
        '10' => 'Okt',
        '11' => 'Nov',
        '12' => 'Dec',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'Søndag',
        '2' => 'Mandag',
        '3' => 'Tirsdag',
        '4' => 'Onsdag',
        '5' => 'Torsdag',
        '6' => 'Fredag',
        '7' => 'Lørdag',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'Søn',
        '2' => 'Man',
        '3' => 'Tirs',
        '4' => 'Ons',
        '5' => 'Tors',
        '6' => 'Fre',
        '7' => 'Lør',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'Sø',
        '2' => 'Ma',
        '3' => 'Ti',
        '4' => 'On',
        '5' => 'To',
        '6' => 'Fr',
        '7' => 'Lø',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'Søn',
        '1' => 'Man',
        '2' => 'Tirs',
        '3' => 'Ons',
        '4' => 'Tors',
        '5' => 'Fre',
        '6' => 'Lør',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'am',
        'pm' => 'pm',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'AM',
        'PM' => 'PM',
        ],

        'dom_report_types' => [
        'tabular' => 'Rækker og kolonner',
        'summary' => 'Summering',
        'detailed_summary' => 'Summering med detaljer',
        'Matrix' => 'Matrix',
        ],


        'dom_email_types' => [
        'out' => 'Sendt',
        'archived' => 'Arkiveret',
        'draft' => 'Kladde',
        'inbound' => 'Indgående',
        'campaign' => 'Kampagne',
        ],
        'dom_email_status' => [
        'archived' => 'Arkiveret',
        'closed' => 'Lukket',
        'draft' => 'I kladde',
        'read' => 'Læs',
        'replied' => 'Besvaret',
        'sent' => 'Sendt',
        'send_error' => 'Send fejl',
        'unread' => 'Ulæst',
        ],
        'dom_email_archived_status' => [
        'archived' => 'Arkiveret',
        ],

        'dom_email_server_type' => ['' => '- Ingen -',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '- Ingen -',
        'createcase' => 'Opret sag',
        'bounce' => 'Afvisningshåndtering',
        ],
        'dom_email_distribution' => ['' => '- Ingen -',
        'direct' => 'Tildel direkte',
        'roundRobin' => 'Round robin',
        'leastBusy' => 'Mindst optaget',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'Round robin',
        'leastBusy' => 'Mindst optaget',
        'none' => 'Ingen',
        ],
        'dom_email_errors' => [1 => 'Vælg kun én bruger, når du tildeler poster direkte.',
        2 => 'Du må kun tildele kontrollerede poster, når du tildeler poster direkte.',
        ],
        'dom_email_bool' => ['bool_true' => 'Ja',
        'bool_false' => 'Nej',
        ],
        'dom_int_bool' => [1 => 'Ja',
        0 => 'Nej',
        ],
        'dom_switch_bool' => ['on' => 'Ja',
        'off' => 'Nej',
        '' => 'Nej',],

        'dom_email_link_type' => ['sugar' => 'Sugar-e-mail-klient',
        'mailto' => 'Ekstern e-mail-klient'],


        'dom_email_editor_option' => ['' => 'E-mail-format, standard',
        'html' => 'HTML-e-mail',
        'plain' => 'E-mail i almindeligt tekstformat'],

        'schedulers_times_dom' => ['not run' => 'Efter kørselstidspunkt, ikke udført',
        'ready' => 'Klar',
        'in progress' => 'I gang',
        'failed' => 'Mislykkedes',
        'completed' => 'Fuldført',
        'no curl' => 'Ikke kørt: Der er ingen tilgængelig cURL',
        ],

        'dom_email_states' => [
        'Draft' => 'Kladde',
        'Archived' => 'Arkiveret',
        ],

        'dom_email_direction' => [
        'Unknown' => 'Ukendt',
        'Outbound' => 'Udgående',
        'Inbound' => 'Indgående',
        'Internal' => 'Intern',
        ],

        'scheduler_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],

        'scheduler_period_dom' => [
        'min' => 'Minutter',
        'hour' => 'Timer',
        ],
        'forecast_type_dom' => [
        'Direct' => 'Direkte',
        'Rollup' => 'Rollup',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'Markedsføringsside',
        'Knowledge Base' => 'Videnbase',
        'Sales' => 'Salgsside',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'Markedsføringsmateriale',
        'Product Brochures' => 'Produktbrochurer',
        'FAQ' => 'Ofte stillede spørgsmål',
        ],

        'document_status_dom' => [
        'Active' => 'Aktiv',
        'Draft' => 'Kladde',
        'FAQ' => 'Ofte stillede spørgsmål',
        'Expired' => 'Udløbet',
        'Under Review' => 'Til gennemsyn',
        'Pending' => 'Afventer',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'Brevfletning',
        'eula' => 'Slutbrugerlicensaftale',
        'nda' => 'Hemmeligholdelsesaftale',
        'license' => 'Licensaftale',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'Acceptér',
        'decline' => 'Afslå',
        'tentative' => 'Foreløbig',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'Accepteret',
        'decline' => 'Afslået',
        'tentative' => 'Foreløbig',
        'none' => 'Ingen',
        ],
        'dataset_output_default_dom' => [
        'table' => 'Tabel',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'Enkelt modul',
        'Multi Module' => 'Multimodul',
        ],
        'report_align_dom' => [
        'left' => 'Venstre',
        'center' => 'Centreret',
        'right' => 'Højre',
        ],

        'width_type_dom' => [
        '%' => 'Procent "%"',
        'px' => 'Pixel "px"',
        ],
        'report_color_dom' => [
        '' => 'Standard',
        'black' => 'Sort',
        'green' => 'Grøn',
        'blue' => 'Blå',
        'red' => 'Rød',
        'white' => 'Hvid',
        'DarkGreen' => 'Mørkegrøn',
        'LightGray' => 'Lysegrå',
        'DodgerBlue' => 'Dodger-blå',
        'LightBlue' => 'Lyseblå',
        ],
        'font_size_dom' => [
        '-5' => 'Mindre "-5"',
        '-4' => 'Mindre "-4"',
        '-3' => 'Mindre "-3"',
        '-2' => 'Mindre "-2"',
        '-1' => 'Mindre "-1"',
        'Default' => 'Standard',
        '1' => 'Større "+1"',
        '2' => 'Større "+2"',
        '3' => 'Større "+3"',
        '4' => 'Større "+4"',
        '5' => 'Større "+5"',
        ],
        'query_type_dom' => [
        'Main Query' => 'Hovedforespørgsel',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'Vis',
//  'Group By' => 'Group By',
        'Calculation' => 'Beregning',
        ],
        'query_display_type_dom' => [
        'Default' => 'Standard',
        'Custom' => 'Brugerdefineret',
        'Hidden' => 'Skjult',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'Dag',
        'Week' => 'Uge',
        'Month' => 'Måned',
        'Quarter' => 'Kvartal',
        'Year' => 'År',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'Nu',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'SUM',
        'AVG' => 'GNSN',
        'COUNT' => 'Antal',
        'STDDEV' => 'Standardafvigelse',
        'VARIANCE' => 'Varians',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'Standardfelt',
        'Time' => 'Tidsinterval',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'Rækker "Y-akse"',
        'Columns' => 'Kolonner "X-akse"',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'Sum "i alt"',
        'AVG' => 'Gennemsnit',
        'MAX' => 'Maksimum',
        'MIN' => 'Minimum',
        'COUNT' => 'Antal',
        'STDDEV' => 'Standardafvigelse',
        'VARIANCE' => 'Varians',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'Standard',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'Matematisk beregn.',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'Felt',
        'Value' => 'Værdi',
        'Group' => 'Gruppe',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'Kolonne',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'Deaktiveret',
        'Enabled' => 'Aktiveret',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'Normal',
        'Scalar' => 'Skalar',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'Tekst',
        'Accounting' => 'Regnskab',
        'Date' => 'Dato',
        'Datetime' => 'Dato/klokkeslæt',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'År',
        'Quarter' => 'Kvartal',
        'Month' => 'Måned',
        'Week' => 'Uge',
        'Day' => 'Dag',
        ],
        'dataset_style_dom' => [
        'normal' => 'Normal',
        'bold' => 'Fed',
        'italic' => 'Kursiv',
        ],

        'query_calc_oper_dom' => [
        '+' => '"+" Plus',
        '-' => '"-" Minus',
        '*' => '"X" Multipliceret med',
        '/' => '"/" Divideret med',
        ],
        'wflow_type_dom' => [
        'Normal' => 'Når posten er gemt',
        'Time' => 'Efter den tid, der går',
        ],
        'mselect_type_dom' => [
        'Equals' => 'Er',
        'in' => 'Er en af',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'Er en af',
        'not_in' => 'Er ikke en af',
        ],
        'cselect_type_dom' => [
        'Equals' => 'Lig med',
        'Does not Equal' => 'Ikke lig med',
        ],
        'dselect_type_dom' => [
        'Equals' => 'Lig med',
        'Less Than' => 'Mindre end',
        'More Than' => 'Mere end',
        'Does not Equal' => 'Ikke lig med',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'Ja',
        'bool_false' => 'Nej',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'Lig med',
        ],
        'tselect_type_dom' => [
        '0' => '0 timer',
        '14440' => '4 timer',
        '28800' => '8 timer',
        '43200' => '12 timer',
        '86400' => '1 dag',
        '172800' => '2 dage',
        '259200' => '3 dage',
        '345600' => '4 dage',
        '432000' => '5 dage',
        '604800' => '1 uge',
        '1209600' => '2 uger',
        '1814400' => '3 uger',
        '2592000' => '30 dage',
        '5184000' => '60 dage',
        '7776000' => '90 dage',
        '10368000' => '120 dage',
        '12960000' => '150 dage',
        '15552000' => '180 dage',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'var mere end',
        'Less Than' => 'er mindre end',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'E-mail',
        'Invite' => 'Inviter',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'Almindelig meddelelse',
        'Custom Template' => 'Brugerdefineret skabelon',
        'System Default' => 'Systemstandard',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'Nuværende brugere',
        'rel_user' => 'Relaterede brugere',
        'rel_user_custom' => 'Relateret brugerdefineret bruger',
        'specific_team' => 'Specifikt team',
        'specific_role' => 'Specifik rolle',
        'specific_user' => 'Specifik bruger',
        ],
        'wflow_array_type_dom' => [
        'future' => 'Ny værdi',
        'past' => 'Gammel værdi',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'Bruger',
        'Manager' => "Brugerens leder",
        ],
        'wflow_address_type_dom' => [
        'to' => 'Til:',
        'cc' => 'Cc:',
        'bcc' => 'Bcc:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'Til:',
        'cc' => 'Cc:',
        'bcc' => 'Bcc:',
        'invite_only' => '"Kun invitation"',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'Til:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'Opdater post',
        'update_rel' => 'Opdater relateret post',
        'new' => 'Ny post',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'Udløst den',
        'Existing Value' => 'Eksisterende værdi',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'Grundlæggende indstillinger',
        'Advanced' => 'Avancerede indstillinger',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'Bruger tildelt til den udløste post',
        'modified_user_id' => 'Bruger, der senest har ændret den udløste post',
        'created_by' => 'Bruger, der har oprettet den udløste post',
        'current_user' => 'Bruger, der er logget på',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'Nuværende team til den udløste post',
        'team_set_id' => 'Nuværende team-sæt af udløst fortegnelse',
        'current_team' => 'Team til bruger, der er logget på',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'Flyt rulleliste tilbage ved',
        'advance' => 'Flyt rulleliste frem ved',
        ],
        'wflow_record_type_dom' => [
        'All' => 'Nye og eksisterende poster',
        'New' => 'Kun nye poster',
        'Update' => 'Kun eksisterende poster',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'Alle relaterede',
        //'first' => 'The first related',
        'filter' => 'Filtrer relaterede',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'alle relaterede',
        'any' => 'nogen relaterede',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'Beskeder derefter handlinger',
        'actions_alerts' => 'Handlinger derefter beskeder'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'Ingen',
        'Daily' => 'Dagligt',
        'Weekly' => 'Ugentligt',
        'Monthly' => 'Månedligt',
        'Yearly' => 'Årligt',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'Dage',
        'Weekly' => 'uge(r)',
        'Monthly' => 'måned(er)',
        'Yearly' => 'år',
        ],

        'repeat_end_types' => [
        'Until' => 'Indtil',
        'Occurrences' => 'Forekomster',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'Ingen',
        'Each' => 'Hver',
        'On' => 'På den',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'først',
        'second' => 'sekund',
        'third' => 'tredje',
        'fourth' => 'fjerde',
        'fifth' => 'femte',
        'last' => 'sidste',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'Søndag',
        'Mon' => 'Mandag',
        'Tue' => 'Tirsdag',
        'Wed' => 'Onsdag',
        'Thu' => 'Torsdag',
        'Fri' => 'Fredag',
        'Sat' => 'Lørdag',
        'Day' => 'Dag',
        'WD' => 'Ugedag',
        'WE' => 'Weekenddag',
        ],

        'duration_dom' => [
        '' => 'Ingen',
        '900' => '15 minutter',
        '1800' => '30 minutter',
        '2700' => '45 minutter',
        '3600' => '1 time',
        '5400' => '1,5 time',
        '7200' => '2 timer',
        '10800' => '3 timer',
        '21600' => '6 timer',
        '86400' => '1 dag',
        '172800' => '2 dage',
        '259200' => '3 dage',
        '604800' => '1 uge',
        ],
        'repeat_month_dom' => [
        '1' => 'Januar',
        '2' => 'Februar',
        '3' => 'Marts',
        '4' => 'April',
        '5' => 'Maj',
        '6' => 'Juni',
        '7' => 'Juli',
        '8' => 'August',
        '9' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'December',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'Standard',
        'seed' => 'Startværdi',
        'exempt_domain' => 'Undertrykkelsesliste - efter domæne',
        'exempt_address' => 'Undertrykkelsesliste - efter e-mail-adresse',
        'exempt' => 'Undertrykkelsesliste - efter id',
        'test' => 'Test',
        ],
        'currency_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'Aktiv',
        'inactive' => 'Inaktiv',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'Meddelelsen er sendt/forsøgt',
        'send error' => 'Afviste meddelelser, andre',
        'invalid email' => 'Afviste meddelelser, ugyldige e-mails',
        'link' => 'Click through-link',
        'viewed' => 'Læst meddelelse',
        'removed' => 'Fravalgt',
        'lead' => 'Kundeemner oprettet',
        'contact' => 'Kontakter oprettet',
        'blocked' => 'Undertrykt af adresse eller domæne',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'Kontakter',
        'Users' => 'Brugere',
        'Prospects' => 'Mål',
        'Leads' => 'Kundeemner',
        'Accounts' => 'Konti',
        ],
        'merge_operators_dom' => [
        'like' => 'Indeholder',
        'exact' => 'Præcis',
        'start' => 'Starter med',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'Ja',
        'false' => 'Nej',
        'required' => 'Obligatorisk',
        ],

        'fts_field_config' => [
        '0' => 'Deaktiveret',
        '2' => 'Søgbar',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'Deaktiveret',
        1 => 'Aktiveret',
        2 => 'I filter',
        3 => 'Brug det valgte filter som standard',
        4 => 'Kun filter',
        ],

        'navigation_paradigms' => [
        'm' => 'Moduler',
        'gm' => 'Grupperede moduler',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'Ikke påbegyndt',
        'inprogress' => 'I gang',
        'signed' => 'Signeret',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'Månedligt',
        'quarterly' => 'Kvartalsvis',
        'halfyearly' => 'Halvårlig',
        'yearly' => 'Årligt',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 dag',
        '3' => '3 dage',
        '5' => '5 dage',
        '7' => '1 uge',
        '14' => '2 uger',
        '21' => '3 uger',
        '31' => '1 måned',
        ],
        'projects_priority_options' => [
        'high' => 'Høj',
        'medium' => 'Medium',
        'low' => 'Lav',
        ],

        'projects_status_options' => [
        'notstarted' => 'Ikke påbegyndt',
        'inprogress' => 'I gang',
        'completed' => 'Fuldført',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'Udvid signaturforklaring',
        'collapselegend' => 'Skjul signaturforklaring',
        'clickfordrilldown' => 'Klik for specifikation',
        'drilldownoptions' => 'Specifikationsindstillinger',
        'detailview' => 'Flere detaljer...',
        'piechart' => 'Cirkeldiagram',
        'groupchart' => 'Gruppér diagram',
        'stackedchart' => 'Stablet diagram',
        'barchart' => 'Søjlediagram',
        'horizontalbarchart' => 'Liggende søjlediagram',
        'linechart' => 'Kurvediagram',
        'noData' => 'Data ikke tilgængelige',
        'print' => 'Udskriv',
        'pieWedgeName' => 'sektioner',
        ],
        'chart_types' => [
        'hBarF' => 'Vandret søjle (stablet)',
        'hGBarF' => 'Horisontal søjle (grupperet)',
        'vBarF' => 'Lodret søjle (stablet)',
        'vGBarF' => 'Lodret søjle (grupperet)',
        'pieF' => 'Cirkeldiagram',
        'funnelF' => 'Tragt',
        'lineF' => 'Linje',
        'donutF' => 'Donut',
        'treemapF' => 'Træstruktur',
        ],
        'd3_value_placement' => [
        '0' => 'Ingen',
        '1' => 'Standard',
        'start' => 'Start',
        'middle' => 'Midt',
        'end' => 'Slut',
        'top' => 'Top',
        'total' => 'I alt',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'Tragt',
        'hbar' => 'Liggende søjlediagram',
        ],
        'release_status_dom' => [
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ],
        'email_settings_for_ssl' => [
        '0' => 'Ingen',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Byt online',
        'outlook' => 'Outlook',
        'google' => 'Google Mindre sikre apps',
        'exchange' => 'Exchange',
        'other' => 'Andet',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Byt online',
        'other' => 'Andet',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'Enkelt anførselstegn (&#39;)',
        '"' => 'Dobbelt anførselstegn (")',
        '' => 'Ingen',
        'other' => 'Andet:',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'Andet:',
        ],
        'link_target_dom' => [
        '_blank' => 'Nyt vindue',
        '_self' => 'samme vindue',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'Foretag ikke automatisk opdatering',
        '30' => 'Hver 30. sekunder',
        '60' => 'Hvert minut',
        '180' => 'Hver 3. minut',
        '300' => 'Hver 5 minut',
        '600' => 'Hver 10. minut',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'Ingen',
        '15' => 'Hvert 15. minut',
        '30' => 'Hvert 30. minut',
        '45' => 'Hvert 45. minut',
        '60' => 'Hver time',
        '120' => 'Hver 2. time',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'Aldrig',
        '30' => 'Hver 30. sekunder',
        '60' => 'Hver minut',
        '180' => 'Hver 3. minut',
        '300' => 'Hver 5 minut',
        '600' => 'Hver 10. minut',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'Ingen',
        '1' => 'Hvert minut',
        '5' => 'Hvert 5. minut',
        '10' => 'Hvert 10. minut',
        '15' => 'Hvert 15. minut',
        '30' => 'Hvert 30. minut',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'Lig med',
        'not_equal' => 'Ikke på',
        'greater_than' => 'Efter',
        'less_than' => 'Før',
        'last_7_days' => 'De sidste 7 dage',
        'next_7_days' => 'De næste 7 dage',
        'last_30_days' => 'De sidste 30 dage',
        'next_30_days' => 'De næste 30 dage',
        'last_month' => 'Sidste måned',
        'this_month' => 'Denne måned',
        'next_month' => 'Næste måned',
        'last_year' => 'Sidste år',
        'this_year' => 'I år',
        'next_year' => 'Næste år',
        'between' => 'Er mellem',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'Sidste år',
        'last_month' => 'Sidste måned',
        'last_30_days' => 'De sidste 30 dage',
        'last_7_days' => 'De sidste 7 dage',
        'this_month' => 'Denne måned',
        'this_year' => 'I år',
        'next_7_days' => 'De næste 7 dage',
        'next_30_days' => 'De næste 30 dage',
        'next_month' => 'Næste måned',
        'next_year' => 'Næste år',
        ],
        'numeric_range_search_dom' => [
        '=' => 'Lig med',
        'not_equal' => 'Ikke lig med',
        'greater_than' => 'Større ned',
        'greater_than_equals' => 'Større end eller lig med',
        'less_than' => 'Mindre end',
        'less_than_equals' => 'Mindre ned eller lig med',
        'between' => 'Er mellem',
        ],

        'filter_checkbox_dom' => [
        0 => 'Urigtige',
        1 => 'Sandt',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'Vundet',
        'lost' => 'Mistet',
        'active' => 'Aktiv',
        ],

        'sweetspot_theme_options' => [
        'default' => 'Standard',
        'light' => 'Lys',
        'dark' => 'Mørk',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'Flyt',
        'donothing' => 'Gør ingenting',
        ],
        'processes_auto_save_interval' => [
        0 => 'Aldrig',
        30000 => 'Hver 30. sekund',
        60000 => 'Hvert minut',
        120000 => 'Hvert 2. minut',
        180000 => 'Hvert 3. minut',
        240000 => 'Hvert 4. minut',
        300000 => 'Hvert 5. minut',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'Ja',
        'No' => 'Nej',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'I prognose',
        'sales_stage' => 'Salgsfase',
        'probability' => 'Sandsynlighed',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'Beløb',
        'best' => 'Bedste',
        'worst' => 'Værste',
        ],
        'webLogicHookList' => [
        'after_save' => 'Efter Gem',
        'after_delete' => 'Efter Slet',
        'after_relationship_add' => 'Efter tilføjelse afforbindelse tilføjelse',
        'after_relationship_delete' => 'Efter sletning af forbindelse',
        'after_login' => 'Efter login ind',
        'after_logout' => 'Efter udlogning',
        'after_login_failed' => 'Efter login mislykkedes',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'Aktiveret',
        'INACTIVE' => 'Deaktiveret',
        ],
        'dashboard_view_name_list' => [
        'record' => 'Post',
        'records' => 'Liste',
        'activities' => 'Activity Stream',
        'multi-line' => 'Liste med flere linjer',
        'omnichannel' => 'Omnichannel',
        'home' => 'Home',
        'focus' => 'Fokusskuffe',
        ],
        'metric_context_list' => [
        'service_console' => 'Servicekonsol',
        'renewals_console' => 'Fornyelser konsol',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'Pr. time',
        '21600' => 'Hver 6. time',
        '43200' => 'Hver 12. time',
        '86400' => 'Dagligt',
        '604800' => 'Ugentligt',
        '1209600' => 'Hver 2. uge',
        '2419200' => 'Hver 4. uge',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => ' 
20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'År',
        'month' => 'Måned(er)',
        'day' => 'Dag(e)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'Fritid',
        'event' => 'Hændelse',
        'other' => 'Andet',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'Dato (sidste {{module}})',
        'start_date:asc' => 'Dato (første {{module}})',
        'total_revenue:desc' => 'Pris (højeste total)',
        'total_revenue:asc' => 'Pris (laveste total)',
        ],
        'calendar_type_list' => [
        'main' => 'Kalendercenter',
        ],
        'calendar_views_options' => [
        'day' => 'Dag',
        'week' => 'Uge',
        'workWeek' => 'Arbejdsuge',
        'expandedMonth' => 'Måned',
        'agenda' => 'Dagsorden',
        'timeline' => 'Tidslinje',
        'monthSchedule' => 'Planlægger',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'Oprettet',
        'completed' => 'Gennemført',
        'declined' => 'Afvist',
        'delivered' => 'Leveret',
        'sent' => 'Sendt',
        'signed' => 'Underskrevet',
        'voided' => 'Ugyldiggjort',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'Vis liste over potentielle modtagere',
        'dont_show' => 'Vis ikke potentielle modtagere',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'Underskriver',
        'carbon_copy' => 'Fremviser (Carbon copy)',
        'certified_delivery' => 'Fremviser (Certificeret Levering)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'Standard',
        'color' => 'Farve',
        'image' => 'Billede',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'Forkortelse',
        'icon' => 'Ikon',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'Pil ned',
        'sicon-chevron-left' => 'Venstre vinkeltegn',
        'sicon-check' => 'Kontrol',
        'sicon-clock' => 'Ur',
        'sicon-dashboard-default' => 'Standardbetjeningspanel',
        'sicon-dashboard' => 'Betjeningspanel',
        'sicon-edit' => 'Rediger',
        'sicon-caret-down' => 'Indsætningspunkt ned',
        'sicon-folder' => 'Mappe',
        'sicon-info' => 'Info',
        'sicon-kebab' => 'Kebab',
        'sicon-link' => 'Link',
        'sicon-list' => 'Liste',
        'sicon-logout' => 'Log af',
        'sicon-minus' => 'Minus',
        'sicon-folder-open' => 'Åben mappe',
        'sicon-plus-sm' => 'Plus Sm',
        'sicon-refresh' => 'Opdater',
        'sicon-plus' => 'Plus',
        'sicon-settings' => 'Indstillinger',
        'sicon-arrow-right-double' => 'Dobbelpil til højre',
        'sicon-reports' => 'Rapporter',
        'sicon-user' => 'Bruger',
        'sicon-upload' => 'Upload',
        'sicon-user-group' => 'Brugergruppe',
        'sicon-arrow-left-double' => 'Dobbelpil til venstre',
        'sicon-chevron-up' => 'Opadvendt vinkeltegn',
        'sicon-caret-up' => 'Indsætningspunkt op',
        'sicon-star-fill' => 'Fyldt stjerne',
        'sicon-download' => 'Download',
        'sicon-close' => 'Luk',
        'sicon-tile-view' => 'Feltvisning',
        'sicon-list-view' => 'Listevisning',
        'sicon-thumbs-down' => 'Tommelfinger ned',
        'sicon-warning-circle' => 'Advarselscirkel',
        'sicon-phone' => 'Telefon',
        'sicon-email' => 'E-mail',
        'sicon-document' => 'Dokument',
        'sicon-note' => 'Note',
        'sicon-preview' => 'Forhåndsvisning',
        'sicon-copy' => 'Kopiér',
        'sicon-launch' => 'Start',
        'sicon-lock' => 'Lås',
        'sicon-arrow-top-right' => 'Pil øverst til højre',
        'sicon-full-screen' => 'Fuld skærm',
        'sicon-full-screen-exit' => 'Forlad fuld skærm',
        'sicon-expand-left' => 'Udvid til venstre',
        'sicon-expand-right' => 'Udvid til højre',
        'sicon-focus-drawer' => 'Fokusskuffe',
        'sicon-ban' => 'Forbyd',
        'sicon-thumbs-up' => 'Tommelfinger op',
        'sicon-search' => 'Søg',
        'sicon-calendar' => 'Kalender',
        'sicon-calendar-lg' => 'Kalender Lg',
        'sicon-mobile-lg' => 'Mobil Lg',
        'sicon-star-fill-lg' => 'Fyldt stjerne Lg',
        'sicon-star-outline-lg' => 'Stjerneomrids Lg',
        'sicon-reset-lg' => 'Nulstil Lg',
        'sicon-exchange-lg' => 'Exchange Lg',
        'sicon-help-lg' => 'Hjælp Lg',
        'sicon-close-lg' => 'Luk Lg',
        'sicon-plus-lg' => 'Plus Lg',
        'sicon-shortcuts-lg' => 'Genveje Lg',
        'sicon-search-lg' => 'Søg Lg',
        'sicon-email-lg' => 'E-mail Lg',
        'sicon-note-lg' => 'Note Lg',
        'sicon-document-lg' => 'Dokument Lg',
        'sicon-add-dashlet-lg' => 'Tilføj Dashlet Lg',
        'sicon-collapse-lg' => 'Skjul Lg',
        'sicon-hamburger-lg' => 'Hamburger Lg',
        'sicon-pin-fill-lg' => 'Fyldt markering Lg',
        'sicon-expand-lg' => 'Udvid Lg',
        'sicon-copy-lg' => 'Kopi Lg',
        'sicon-dashboard-lg' => 'Betjeningspanel Lg',
        'sicon-star-outline' => 'Stjerneomrids',
        'sicon-reset' => 'Nulstil',
        'sicon-unlink' => 'Fjern link',
        'sicon-phone-lg' => 'Telefon Lg',
        'sicon-attach' => 'Vedhæft',
        'sicon-case-lg' => 'Sag Lg',
        'sicon-arrow-right-lg' => 'Pil til højre Lg',
        'sicon-check-circle-lg' => 'Kontrolcirkel Lg',
        'sicon-text-formatting' => 'Tekstformatering',
        'sicon-check-circle' => 'Kontrolcirkel',
        'sicon-upload-lg' => 'Upload Lg',
        'sicon-flag-lg' => 'Flag Lg',
        'sicon-studio-lg' => 'Studio Lg',
        'sicon-contact-lg' => 'Kontakt Lg',
        'sicon-edit-lg' => 'Rediger Lg',
        'sicon-arrow-left' => 'Pil til venstre',
        'sicon-reply-all' => 'Svar alle',
        'sicon-message-lg' => 'Meddelelse Lg',
        'sicon-info-lg' => 'Info Lg',
        'sicon-error-lg' => 'Fejl Lg',
        'sicon-check-circle-line-lg' => 'Kontrolcirkellinje Lg',
        'sicon-warning-line-lg' => 'Advarselslinje Lg',
        'sicon-arrow-up' => 'Pil op',
        'sicon-arrow-right' => 'Pil til højre',
        'sicon-nodes' => 'Noder',
        'sicon-hide' => 'Skjul',
        'sicon-help' => 'Hjælp',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'Meddelelse',
        'sicon-sugar-predict-lg' => 'Sugar Predict Lg',
        'sicon-sugar-predict' => 'Sugar Predict',
        'sicon-opportunity-lg' => 'Salgsmulighed Lg',
        'sicon-lead-lg' => 'Kundeemne Lg',
        'sicon-account-lg' => 'Konto Lg',
        'sicon-user-sm' => 'Bruger Sm',
        'sicon-quote-lg' => 'Tilbud Lg',
        'sicon-equal' => 'Lig med',
        'sicon-slicers-xl' => 'Udsnit Xl',
        'sicon-escalation-lg' => 'Eskalering Lg',
        'sicon-add-circle-lg' => 'Tilføj cirkel Lg',
        'sicon-add-line-lg' => 'Tilføj linje Lg',
        'sicon-add-target-lg' => 'Tilføj mål Lg',
        'sicon-help-circle-lg' => 'Hjælpecirkel Lg',
        'sicon-divide-line-lg' => 'Opdel linje Lg',
        'sicon-string' => 'Streng',
        'sicon-filter' => 'Filter',
        'sicon-number' => 'Antal',
        'sicon-format-lg' => 'Format Lg',
        'sicon-insights-lg' => 'Indsigt Lg',
        'sicon-invalid-circle-lg' => 'Ugyldig cirkel Lg',
        'sicon-layout-xl' => 'Layout Xl',
        'sicon-layout-lg' => 'Layout Lg',
        'sicon-multiply-line-lg' => 'Multiplicer linje Lg',
        'sicon-redo-lg' => 'Fortryd Lg',
        'sicon-refresh-lg' => 'Opdater Lg',
        'sicon-undo-lg' => 'Fortryd Lg',
        'sicon-activity-feed-xl' => 'Aktivitetsfeed Xl',
        'sicon-chevron-left-xl' => 'Venstre vinkeltegn Xl',
        'sicon-close-xl' => 'Luk Xl',
        'sicon-kebab-lg' => 'Kebab Lg',
        'sicon-insights-xl' => 'Indsigt Xl',
        'sicon-hide-lg' => 'Skjul Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => 'Kommentar Xl',
        'sicon-share-lg' => 'Del Lg',
        'sicon-trash' => 'Papirkurv',
        'sicon-launch-lg' => 'Start Lg',
        'sicon-thumbs-up-lg' => 'Tommelfinger op Lg',
        'sicon-thumbs-down-lg' => 'Tommelfinger ned Lg',
        'sicon-warning-lg' => 'Advarsel Lg',
        'sicon-wizard-circle-xl' => 'Guide Cirkel Xl',
        'sicon-bell-cross-lg' => 'Klokkekors Lg',
        'sicon-bell-lg' => 'Klokke Lg',
        'sicon-daily-lg' => 'Dagligt lg',
        'sicon-cloud-download-lg' => 'Cloud-download Lg',
        'sicon-unlock' => 'Lås op',
        'sicon-news-lg' => 'Nyheder Lg',
        'sicon-weekly-lg' => 'Ugentligt Lg',
        'sicon-knowledgebase-xl' => 'Vidensbase Xl',
        'sicon-remove' => 'Fjern',
        'sicon-chevron-down' => 'Nedadvendt vinkeltegn',
        'sicon-slicers-lg' => 'Udsnit Lg',
        'sicon-save-lg' => 'Gem Lg',
        'sicon-info-circle-lg' => 'Infocirkel Lg',
        'sicon-chevron-right' => 'Højre vinkeltegn',
        'sicon-warning-circle-lg' => 'Advarselscirkel Lg',
        'sicon-right-paren-line-lg' => 'Højre overordnet linje Lg',
        'sicon-comment-lg' => 'Kommentar Lg',
        'sicon-target-lg' => 'Mål Lg',
        'sicon-subtract-line-lg' => 'Subtrahere linje Lg',
        'sicon-settings-lg' => 'Indstillinger Lg',
        'sicon-left-paren-line-lg' => 'Venstre overordnet linje Lg',
        'sicon-preview-lg' => 'Forhåndsvisning Lg',
        'sicon-thumbs-down-line-lg' => 'Tommelfinger ned linje Lg',
        'sicon-thumbs-up-line-lg' => 'Tommelfinger op linje Lg',
        'sicon-send-lg' => 'Send Lg',
        'sicon-contact-xl' => 'Kontakt Xl',
        'sicon-wizard-circle-line-xl' => 'Guide Cirkellinje Xl',
        'sicon-trash-lg' => 'Papirkurv Lg',
        'sicon-pin-lg' => 'Markering Lg',
        'sicon-clock-lg' => 'Ur Lg',
        'sicon-comment-line-xl' => 'Kommentarlinje Xl',
        'sicon-dropdown-editor' => 'Rullelisteeditor',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'Fejl',
        'sicon-catalog' => 'Katalog',
        'sicon-cloud' => 'Cloud',
        'sicon-config-api' => 'Konfigurations-API',
        'sicon-config-nav' => 'Konfigurationsnavigation',
        'sicon-connectors' => 'Forbindelser',
        'sicon-contracts' => 'Kontrakter',
        'sicon-currencies' => 'Valutaer',
        'sicon-diagnostics' => 'Diagnosticeringer',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'E-mailkampagne',
        'sicon-email-inbound' => 'Indgående e-mail',
        'sicon-email-queue' => 'E-mailkø',
        'sicon-forecasts' => 'Prognoser',
        'sicon-display-modules' => 'Vis moduler',
        'sicon-email-contacts' => 'E-mailkontakter',
        'sicon-import' => 'Import',
        'sicon-log-viewer' => 'Logviser',
        'sicon-lab' => 'Lab',
        'sicon-map-pin' => 'Kortmarkering',
        'sicon-manufacturers' => 'Producenter',
        'sicon-update' => 'Opdater',
        'sicon-content-security' => 'Sikkerhed for indhold',
        'sicon-module-builder' => 'Modulgenerator',
        'sicon-languages' => 'Sprog',
        'sicon-module-loader' => 'Modulindlæser',
        'sicon-oauth-key' => 'Oauth-nøgle',
        'sicon-password-mgmt' => 'Adgangskodeadministration',
        'sicon-opportunities' => 'Salgsmuligheder',
        'sicon-upgrade' => 'Opgrader',
        'sicon-portal' => 'Portal',
        'sicon-product-types' => 'Produkttyper',
        'sicon-quotes' => 'Tilbud',
        'sicon-relate-fields' => 'Relater felter',
        'sicon-repair' => 'Reparation',
        'sicon-role-mgmt' => 'Rolleadministration',
        'sicon-scheduler' => 'Planlægger',
        'sicon-shippers' => 'Afsendere',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => 'Web Logic',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'Momssatser',
        'sicon-team-mgmt' => 'Teamadministration',
        'sicon-team-perm' => 'Teamrettigheder',
        'sicon-tracker' => 'Sporing',
        'sicon-workflow' => 'Arbejdsgang',
        'sicon-mask' => 'Maske',
        'sicon-mask-disabled' => 'Maske deaktiveret',
        'sicon-email-archive' => 'E-mailarkiv',
        'sicon-mobile' => 'Mobil',
        'sicon-archive' => 'Arkiv',
        'sicon-automate-scroll' => 'Lodret, rullevisning',
        'sicon-automate-stacked' => 'Vandret, rullevisning',
        'sicon-pdf-manager' => 'PDF-manager',
        'sicon-my-sites' => 'Mine websteder',
        'sicon-cloud-insights' => 'Cloud-indsigt',
        'sicon-sugar-logo-24' => 'Sugar-logo 24',
        'sicon-sugar-logo-16' => 'Sugar-logo 16',
        'sicon-task-lg' => 'Opgave Lg',
        'sicon-web-lg' => 'Web Lg',
        'sicon-events-lg' => 'Begivenheder Lg',
        'sicon-sugar-logo-12' => 'Sugar-logo 12',
        'sicon-tag' => 'Tag',
        'sicon-tag-lg' => 'Tag Lg',
        'sicon-bell-lg-line' => 'Klokke Lg Linje',
        'sicon-matrix-xxl' => 'Matrix Xxl',
        'sicon-advanced-filter' => 'Avancerede filter',
        'sicon-rows-and-columns-xxl' => 'Rækker og kolonner Xxl',
        'sicon-summation-details-xxl' => 'Summeringsdetaljer Xxl',
        'sicon-summation-xxl' => 'Summering Xxl',
        'sicon-lock-lg' => 'Lås Lg',
        'sicon-csv-file-xxl' => 'Csv-fil Xxl',
        'sicon-logo-linkedin' => 'Linkedin-logo',
        'sicon-briefcase' => 'Dokumentmappe',
        'sicon-car-front' => 'Frontparti på bil',
        'sicon-airplane' => 'Flyvemaskine',
        'sicon-laptop' => 'Laptop',
        'sicon-logo-instagram' => 'Instagram-logo',
        'sicon-single-bed' => 'Enkeltseng',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'Snapchat-logo',
        'sicon-video-lg' => 'Video Lg',
        'sicon-reply' => 'Besvar',
        'sicon-subtract' => 'Subtrahere',
        'sicon-arrow-up-circle-line' => 'Cirkellinje med pil op',
        'sicon-asterisk' => 'Asterisk',
        'sicon-dot-circle-o-lg' => 'Punktkcirkel O Lg',
        'sicon-forward' => 'Videresend',
        'sicon-video' => 'Video',
        'sicon-gavel' => 'Hammer',
        'sicon-login' => 'Login',
        'sicon-pdf-file-xxl' => 'PDF-fil Xxl',
        'sicon-login-lg' => 'Login Lg',
        'sicon-cloud-download-xl' => 'Cloud-download Xl',
        'sicon-campaigns-lg' => 'Kampagner Lg',
        'sicon-customer-journey-stages-lg' => 'Kunderejsefaser Lg',
        'sicon-role-mgmt-lg' => 'Rolleadministration Lg',
        'sicon-default-module-lg' => 'Standardmodul Lg',
        'sicon-quoted-line-items-lg' => 'Produkter Lg',
        'sicon-projects-lg' => 'Projekter Lg',
        'sicon-process-business-rules-lg' => 'Proces forretningsregler Lg',
        'sicon-process-email-templates-lg' => 'Proces e-mailskabeloner Lg',
        'sicon-processes-lg' => 'Processer Lg',
        'sicon-process-definitions-lg' => 'Procesdefinitioner Lg',
        'sicon-target-lists-lg' => 'Målgruppelister Lg',
        'sicon-purchased-line-items-lg' => 'Købte linjeprodukter Lg',
        'sicon-user-group-lg' => 'Brugergruppe Lg',
        'sicon-revenue-line-items-lg' => 'Omsætningsposter Lg',
        'sicon-business-centers-lg' => 'Forretningscentre Lg',
        'sicon-logo-fb-simple' => 'Fb-logo simpel',
        'sicon-forecasts-lg' => 'Prognoser Lg',
        'sicon-contracts-lg' => 'Kontrakter Lg',
        'sicon-purchase-lg' => 'Køb Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => 'Kunderejse Lg',
        'sicon-data-privacy-lg' => 'Databeskyttelse Lg',
        'sicon-home-lg' => 'Startside Lg',
        'sicon-data-table' => 'Datatabel',
        'sicon-medical-clipboard-lg' => 'Medicinsk udklipsholder Lg',
        'sicon-privacy-lg' => 'Privatliv Lg',
        'sicon-marketplace' => 'Markedsplads',
        'sicon-marketplace-lg' => 'Markedsplads Lg',
        'sicon-blockquote-lg' => 'Blockquote Lg',
        'sicon-casino-lg' => 'Casino Lg',
        'sicon-jacuzzi-lg' => 'Jacuzzi Lg',
        'sicon-scissors-lg' => 'Saks Lg',
        'sicon-storage-lg' => 'Lagring Lg',
        'sicon-fan-lg' => 'Ventilator Lg',
        'sicon-medicine-lg' => 'Medicin Lg',
        'sicon-plant-lg' => 'Plante Lg',
        'sicon-telescope-lg' => 'Teleskop Lg',
        'sicon-smart-phone-lg' => 'Smartphone Lg',
        'sicon-coffee-lg' => 'Kaffe Lg',
        'sicon-martini-lg' => 'Martini Lg',
        'sicon-cocktail-lg' => 'Cocktail Lg',
        'sicon-stadium-lg' => 'Stadion Lg',
        'sicon-fire-lg' => 'Ild Lg',
        'sicon-window-lg' => 'Vindue Lg',
        'sicon-lotus-lg' => 'Lotus Lg',
        'sicon-windmill-lg' => 'Vindmølle Lg',
        'sicon-spades-lg' => 'Spar Lg',
        'sicon-hearts-lg' => 'Hjerter Lg',
        'sicon-diamonds-lg' => 'Ruder Lg',
        'sicon-clubs-lg' => 'Klør Lg',
        'sicon-skull-lg' => 'Kranie Lg',
        'sicon-send' => 'Send',
        'sicon-world-lg' => 'Verden Lg',
        'sicon-airplane-lg' => 'Flyvemaskine Lg',
        'sicon-planet-lg' => 'Planet Lg',
        'sicon-trainer-lg' => 'Træning Lg',
        'sicon-calculator-lg' => 'Lommeregner Lg',
        'sicon-tv-lg' => 'TV Lg',
        'sicon-video-player-lg' => 'Videoafspiller Lg',
        'sicon-media-player-lg' => 'Medieafspiller Lg',
        'sicon-decentralize-lg' => 'Decentralisere Lg',
        'sicon-statistics-lg' => 'Statistik Lg',
        'sicon-virus-lg' => 'Virus Lg',
        'sicon-shield-lg' => 'Skjold Lg',
        'sicon-plug-lg' => 'Plug Lg',
        'sicon-shuttle-lg' => 'Shuttle Lg',
        'sicon-soundwave-lg' => 'Lydbølge Lg',
        'sicon-graph-lg' => 'Graf Lg',
        'sicon-playlist-lg' => 'Playliste Lg',
        'sicon-voice-recognition-lg' => 'Stemmegenkendelse Lg',
        'sicon-machine-learning-lg' => 'Maskinlæring Lg',
        'sicon-bed-lg' => 'Seng Lg',
        'sicon-blueprint-lg' => 'Blueprint Lg',
        'sicon-content-delivery-lg' => 'Indholdslevering Lg',
        'sicon-questionnaire-lg' => 'Spørgeskema Lg',
        'sicon-presentation-lg' => 'Præsentation Lg',
        'sicon-organic-lg' => 'Organisk Lg',
        'sicon-transactions-lg' => 'Transaktioner Lg',
        'sicon-wand-lg' => 'Tryllestav Lg',
        'sicon-bin-lg' => 'Skraldespand Lg',
        'sicon-sync-lg' => 'Synkronisering Lg',
        'sicon-external-authentication-lg' => 'Ekstern godkendelse Lg',
        'sicon-tracking-activity-lg' => 'Sporing af aktivitet Lg',
        'sicon-account' => 'Konto',
        'sicon-meetings-lg' => 'Møder Lg',
        'sicon-stacked' => 'Vandret, delt visning',
        'sicon-sidebyside' => 'Lodret, delt visning',
        ],

        'module_colors_dom' => [
        'army' => 'Hær',
        'coral' => 'Koral',
        'green' => 'Grøn',
        'orange' => 'Orange',
        'ocean' => 'Ocean',
        'pacific' => 'Stillehavet',
        'pink' => 'Lyserød',
        'purple' => 'Lilla',
        'red' => 'Rød',
        'teal' => 'Blågrøn',
        'yellow' => 'Gul',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'Ny',
        'In Progress' => 'I Gang',
        'Closed' => 'Lukket',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'Inaktivitet',
        'Lack of Progress' => 'Mangel på Fremskridt',
        'Customer-Imposed Deadline' => 'Kundepålagt Deadline',
        'Account at Risk' => 'Konto i Fare',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'Kunde Anmodede',
        'Internally Requested' => 'Internt Anmodet',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'Sag',
        'Bugs' => 'Fejl',
        'Accounts' => 'Konto',
        'Opportunities' => 'Mulighed',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'Positiv',
        'Negative' => 'Negativ',
        'Neutral' => 'Neutral',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'Ikke sandsynlig',
        '02_less_likely' => 'Mindre sandsynlig',
        '03_neutral' => 'Neutral',
        '04_more_likely' => 'Mere sandsynlig',
        '05_very_likely' => 'Meget sandsynlig',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'Matcher ikke kunder',
        '02_no_match' => '',
        '01_matches_customers' => 'Matcher kunder',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'Kundeemne',
        'Accounts' => 'Konto',
        'Contacts' => 'Kontakt',
        'Cases' => 'Sag',
        'Opportunities' => 'Salgsmulighed',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'Ikke påbegyndt',
        'in_progress' => 'I gang',
        'completed' => 'Fuldført',
        'cancelled' => 'Annulleret',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'Ingen',
        'create' => 'På Opret',
        'stage_start' => 'På fasestart',
        'previous_activity_completed' => 'Tidligere aktivitet fuldført',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'Aktuel bruger',
        'parent_assignee' => 'Overordnet modtager',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'Dage fra oprettelse',
        'days_from_stage_started' => 'Dage fra fasen startede',
        'days_from_previous_activity_completed' => 'Dage fra tidligere aktivitet fuldført',
        'days_from_parent_date_field' => 'Dage fra feltet Overordnet dato',
        'days_from_specific_activity_completed' => 'Dage fra specifik aktivitet fuldført',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'Når oprettet',
        'stage_started' => 'Hvornår fasen startede',
        'previous_activity_completed' => 'Når tidligere aktivitet er fuldført',
        'parent_date_field' => 'På felt Overordnet dato',
        'specific_activity_completed' => 'Specifik aktivitet fuldført',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'Absolut',
        'Percentage' => 'Procent',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'Kundeopgave',
        'milestone' => 'Milepæl',
        'internal_task' => 'Intern opgave',
        'agency_task' => 'Bureau-opgave',
        'automatic_task' => 'Automatisk opgave',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'Opgave',
        'Calls' => 'Opkald',
        'Meetings' => 'Møde',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'Ingen',
        'create' => 'På Opret',
        'stage_start' => 'På fasestart',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'Overtag',
        'current_user' => 'Aktuel bruger',
        'parent_assignee' => 'Overordnet modtager',
        'user' => 'Bruger',
        'team' => 'Team',
        'user_team' => 'Bruger og team',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'Overtag',
        'none' => 'Ingen',
        'create' => 'På Opret',
        'stage_start' => 'På fasestart',
        'previous_activity_completed' => 'Tidligere aktivitet fuldført',
        'specific_activity_completed' => 'Specifik aktivitet fuldført',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'Ikke påbegyndt',
        'in_progress' => 'I gang',
        'not_completed' => 'Ikke fuldført',
        'completed' => 'Fuldført',
        'cancelled' => 'Annulleret',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'Rediger fase',
        'stage_add_task_button' => 'Opret opgave',
        'stage_add_meeting_button' => 'Planlæg møde',
        'stage_add_call_button' => 'Planlæg opkald',
        'stage_delete_button' => 'Slet fase',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'Tilføj opgave',
        'activity_add_sub_meeting_button' => 'Planlæg møde',
        'activity_add_sub_call_button' => 'Planlæg opkald',
        'activity_not_applicable_button' => 'Ikke relevant',
        'activity_delete_button' => 'Slet',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'Indstil til Ikke relevant',
        'remove_open_activities' => 'Fjern åbne aktiviteter',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'Standard',
        'custom' => 'Brugerdefineret',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'FÅ',
        'POST' => 'POST',
        'PUT' => 'PUT',
        'PATCH' => 'PATCH',
        'DELETE' => 'SLET',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'Spring anmodning over',
        'json' => 'JSON',
        'http_query' => 'HTTP-forespørgsel',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'Intet svar',
        'json' => 'JSON',
        'http_query' => 'HTTP-forespørgsel',
        'text' => 'Almindelig tekst',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'Før Opret',
        'after_create' => 'Efter Opret',
        'before_in_progress' => 'Før I gang',
        'after_in_progress' => 'Efter I gang',
        'before_completed' => 'Før Fuldført',
        'after_completed' => 'Efter Fuldført',
        'before_not_applicable' => 'Før Ikke relevant',
        'after_not_applicable' => 'Efter Ikke relevant',
        'before_delete' => 'Før sletning',
        'after_delete' => 'Efter sletning',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'Send Smart Guide-information',
        'custom_body' => 'Send brugerdefineret posttekst',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'I gang',
        'completed' => 'Fuldført',
        'not_applicable' => 'Ikke relevant',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'Vis post',
        'create_record' => 'Opret post',
        'update_record' => 'Opdater post',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'Opret automatisk post',
        'manual_create' => 'Opret post manuelt',
        'automatic_update' => 'Opdater post automatisk',
        'manual_update' => 'Opdater post manuelt',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'Smart Guide-skabelon',
        'DRI_SubWorkflow_Templates' => 'Faseskabelon',
        'DRI_Workflow_Task_Templates' => 'Aktivitetsskabelon',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'Ja',
        'no' => 'Nej',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'Afholdt',
        'Not Held' => 'Holdes ikke',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'Afholdt',
        'Not Held' => 'Holdes ikke',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'Fuldført',
        'Not Applicable' => 'Ikke relevant',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'Smart Guide-skabelon',
        'DRI_SubWorkflow_Templates' => 'Faseskabelon',
        'DRI_Workflow_Task_Templates' => 'Aktivitetsskabelon',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'Opgave',
        'Meetings' => 'Møde',
        'Calls' => 'Opkald',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'Aktuel opgave',
        'Calls' => 'Aktuelt opkald',
        'Meetings' => 'Aktuelt møde',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'Specifikke brugere',
        'specific_contacts' => 'Specifikke kontakter',
        'related_parent_users' => 'Relaterede overordnede brugere',
        'related_parent_contacts' => 'Relaterede overordnede kontakter',
        'add_all_contacts_from_parent' => 'Tilføj alle kontakter fra overordnet',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'Brugere',
        'specific_contacts' => 'Kontakter',
        'related_parent_users' => 'Brugere',
        'related_parent_contacts' => 'Kontakter',
        'add_all_contacts_from_parent' => 'Kontakter',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'Minut(ter)',
        'hours' => 'Time(r)',
        'days' => 'Dag(e)',
        'months' => 'Måned(er)',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'Dag(e)',
        'months' => 'Måned(er)',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'Fast dato',
        'relative' => 'Relativ dato',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'Brugere',
        'teams' => 'Teams',
        'roles' => 'Roller',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide til Sugar-handling',
        'sugar_action_to_smart_guide' => 'Sugar-handling til Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide-fase',
        'Smart Guide Activities' => 'Smart Guide-aktiviteter',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'Gennemført',
        'cancelled' => 'Annulleret',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'Igangværende',
        'completed' => 'Gennemført',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'Igangværende',
        'completed' => 'Gennemført',
        'not_applicable' => 'Ikke relevant',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'Markér alle aktiviteter som Gennemført',
        'mark_all_not_applicable' => 'Markér alle ikke-gennemførte aktiviteter som Ikke relevant',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'USA (Oregon) [us-west-2]',
        'ca-central-1' => 'Canada (central) [ca-central-1]',
        'ap-southeast-1' => 'Asien og Stillehavsområdet (Singapore) [ap-southeast-1]',
        'ap-southeast-2' => 'Asien og Stillehavsområdet (Sydney) [ap-southeast-2]',
        'eu-central-1' => 'Europa (Frankfurt) [eu-central-1]',
        'eu-west-2' => 'Europa (London) [eu-vest-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'Rapport overskrift', // Studio editing of record views
    'LBL_RECORD_BODY' => 'Visitkort', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'Vis flere', // Studio editing of record views
    'LBL_FAVORITE' => 'Favorit', // Record view header panel element
    'LBL_FOLLOW' => 'Følg', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'Følg link',
    'LBL_TOGGLE_VISIBILITY' => 'Skift mellem visning', // Record view header panel element
    'LBL_ACTIVITIES' => 'Aktiviteter',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM, Sugar og 3D-terning er registrerede varemærker af SugarCRM Inc. ' .
        'Alle andre firma- og produktnavne, som er anvendt eller optræder i dette produkt kan være varemærker tilhørende de ' .
        'SugarCRM®, Sugar Enterprise™ og Sugar™ er varemærker tilhørende SugarCRM Inc.',
    'LBL_TRADEMARK2' => 'SugarCRM ®, Sugar Enterprise™ og Sugar™ er varemærker tilhørende SugarCRM Inc.',
    'LBL_SEND_INVITE' => 'Send invitation',
    'LBL_INVITEES' => 'Inviterede',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'Gæster vil ikke modtage din invitation',
    'LBL_SELECT_ACTION_LABEL' => 'Vælg handling',
    'LBL_TOGGLE_DRAWER' => 'Toggle Drawer',
    'LBL_TOUR_NEXT' => 'Næste',
    'LBL_TOUR_SKIP' => 'Spring over',
    'LBL_TOUR_BACK' => 'Tilbage',
    'LBL_TOUR_CLOSE' => 'Luk',
    'LBL_TOUR_BTN_DONE' => 'Udført',
    'LBL_TOUR_TAKE_TOUR' => 'Tag den guidede tur',
    'LBL_TOUR_FULL_TOUR' => 'Fuld tour',
    'LBL_TOUR_MODULE' => 'Rundvisning af denne side',
    'LBL_TOUR_END_TOUR' => 'Afslut rundvisning',
    'LBL_TOUR_OVERVIEW' => 'Side overblik',
    'LBL_TOUR_REVISIT' => 'Klik her for at vise præsentationen til enhver tid.',
    'LBL_MY_AREA_LINKS' => 'Mine links:' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'Trækker luft' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'Velkommen' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'Avanceret søgning' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'Vis mere' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'Rediger' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'Vis' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'Søg' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'Søg...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'Fjern' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'Tilføj' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'Kolonne' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 kolonner' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 kolonner' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'Avanceret søgning' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'Tilføj' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'Skjul/Vis' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'Slet' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'Tilføj' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'Ryd' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'Fjern' /*for 508 compliance fix*/,
    'LBL_ADD' => 'Tilføj' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'Virksomhedslogo' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'Kalender' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'En rullelisteværdi, som du har valgt, ændrede dit layout for postvisning. ' .
        'Værdier i felter, der er skjult i dette nye layout, ryddes. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'Åbn',
    'LBL_SIDEBAR_NAV_CLOSE' => 'Luk',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} menu',
    'LBL_GOTO_SUGARCRM_COM' => 'Gå til SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'hovedmenunavigation',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'skift undertavle',

    'LBL_ADVANCED' => 'Avanceret',
    'LBL_BASIC' => 'Grundlæggende',
    'LBL_MODULE_FILTER' => 'Filterer efter',
    'LBL_CONNECTORS_POPUPS' => 'Connectors Popups',
    'LBL_CLOSEINLINE' => 'Luk',
    'LBL_EDITINLINE' => 'Rediger',
    'LBL_VIEWINLINE' => 'Vis',
    'LBL_INFOINLINE' => 'Info',
    'LBL_POWERED_BY_SUGARCRM' => 'Powered by SugarCRM',
    'LBL_PRINT' => 'Udskriv',
    'LBL_HELP' => 'Hjælp',
    'LBL_TOUR' => 'Præsentation',
    'LBL_TOUR_LINK' => 'Kig denne side igennem',
    'LBL_MOBILE' => 'Mobiltelefon:',
    'LBL_ID_FF_SELECT' => 'Vælg',
    'DEFAULT' => 'Grundlæggende',
    'LBL_SORT' => 'Sortér',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'Tilføj server...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'Aktivér SMTP via SSL eller TLS',
    'LBL_NO_ACTION' => 'Der er ingen handling med det navn.',
    'LBL_NO_DATA' => 'Ingen data',
    'LBL_NOT_APPLICABLE' => 'Ikke relevant',
    'LBL_ROUTING_ADD_RULE' => 'Tilføj regel',
    'LBL_ROUTING_ALL' => 'Mindst',
    'LBL_ROUTING_ANY' => 'Nogen',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => 'Annuller',
    'LBL_ROUTING_BUTTON_SAVE' => 'Gem regel',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'Kopiér e-mail',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'Slet Sugar-objekt',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'Slet fil',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'Slet e-mail',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'Videresend e-mail',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'Markér e-mail med flag',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'Markér som Læst',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'Markér som ulæst',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'Flyt e-mail',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'Udfør følgende handlinger',
    'LBL_ROUTING_ACTIONS_REPLY' => 'Besvar e-mail',

    'LBL_ROUTING_CHECK_RULE' => "En fejl er opdaget:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'Kontrollér alle de felter, der er markeret.',
    'LBL_ROUTING_CONFIRM_DELETE' => "Er du sikker på, at du vil slette denne regel? Det kan ikke fortrydes.",

    'LBL_ROUTING_FLAGGED' => 'flag angivet',
    'LBL_ROUTING_FORM_DESC' => 'Gemte regler er straks aktive.',
    'LBL_ROUTING_FW' => 'VS:',
    'LBL_ROUTING_LIST_TITLE' => 'Regler',
    'LBL_ROUTING_MATCH' => 'Hvis',
    'LBL_ROUTING_MATCH_2' => 'af følgende betingelser er opfyldt:',
    'LBL_NOTIFICATIONS' => 'Meddelelser',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'Cc',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'Indhold i brødtekst',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'Fra',
    'LBL_ROUTING_MATCH_NAME' => 'Emne',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'Høj prioritet',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'Normal prioritet',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'Lav prioritet',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'Til',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'Indeholder',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'Indeholder ikke',

    'LBL_ROUTING_NAME' => 'Regelnavn',
    'LBL_ROUTING_NEW_NAME' => 'Ny regel',
    'LBL_ROUTING_ONE_MOMENT' => 'Et øjeblik...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'Oprindelig meddelelse følger.',
    'LBL_ROUTING_RE' => 'SV:',
    'LBL_ROUTING_SAVING_RULE' => 'Gemmer regel',
    'LBL_ROUTING_SUB_DESC' => 'De markerede regler er aktive. Klik på et navn for redigere.',
    'LBL_ROUTING_TO' => 'til',
    'LBL_ROUTING_TO_ADDRESS' => 'til adresse',
    'LBL_ROUTING_WITH_TEMPLATE' => 'med skabelon',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => '"Du har værdier i formularen til telefon- og adressefelterne. Hvis du vil overskrive disse værdier med telefon- og adresseoplysningerne for den virksomhed, du har valgt, skal du klikke på ""OK"". Hvis du vil beholde de aktuelle værdier, skal du klikke på ""Annuller""."',
    'LBL_DROP_HERE' => '[Slip her]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'Rediger',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'Angiv Gmail som standard',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'Navn',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'Egenskaber for udgående e-mail-server',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'E-mail-overførselsagent',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'Vil du bruge SMTP-godkendelse?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP-adgangskode',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP-port',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP-server',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'Brug SSL, når der oprettes forbindelse',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP-brugernavn',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'Standard',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'Advarsel: Brugernavn og adgangskode til udgående e-mail-konto mangler.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP-brugernavn er obligatorisk',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP-adgangskode er obligatorisk',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'Administration af e-mail-konto',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'E-mail-server-protokollen for POP3-typen understøttes ikke i den næste udgivelse. Kun IMAP understøttes.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'Konfigurer E-mail-konti for at få vist indgående e-mails fra dine e-mail-konti.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'Angiv oplysninger om SMTP-e-mail-server, der skal bruges til udgående e-mail, i E-mail-konti.',
    'LBL_EMAIL_ADD' => 'Tilføj e-mail',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'Udført',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'Ryd',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'Til:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'Cc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'Bcc:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'Til/Cc/Bcc',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'Ny liste',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'E-mail-adresse',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'Kun redigering af kontakter understøttes i øjeblikket.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'Filter',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'Fornavn/virksomhednavn',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'Efternavn',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'Mine kontakter',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'Mine adresselister',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'Navn',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'Ingen adresser blev fundet',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'Gem og føj til adressekartotek',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'Søg',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'Vælg e-mail-modtagere',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'Adressekartotek',
    'LBL_EMAIL_REPORTS_TITLE' => 'Rapporter',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'Advarsel! Den udgående konto, du prøver at slette, er knyttet til en eksisterende indgående konto. Er du sikker på, at du vil fortsætte?',
    'LBL_EMAIL_ADDRESSES' => 'E-mail',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'E-mail-adresse',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'E-mail-adresser',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'Importér til Sugar',
    'LBL_EMAIL_ASSIGNMENT' => 'Tildeling',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'Vedhæft',
    'LBL_EMAIL_ATTACHMENT' => 'Vedhæft',
    'LBL_EMAIL_ATTACHMENTS' => 'Fra lokalt system',
    'LBL_EMAIL_ATTACHMENTS2' => 'Fra Sugar-dokumenter',
    'LBL_EMAIL_ATTACHMENTS3' => 'Vedhæftede filer med skabeloner',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'Fil',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'Dokument',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'Integreret',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'Attachment mislykkedes at uploade',
    'LBL_REMOVING_ATTACHMENT' => 'Fjerner vedhæftet fil...',
    'LBL_EMAIL_BCC' => 'Bcc',
    'LBL_EMAIL_CANCEL' => 'Annuller',
    'LBL_EMAIL_CC' => 'Cc',
    'LBL_EMAIL_CHARSET' => 'Tegnsæt',
    'LBL_EMAIL_CHECK' => 'Tjek e-mail',
    'LBL_EMAIL_CHECKING_NEW' => 'Søger efter nye e-mails',
    'LBL_EMAIL_CHECKING_DESC' => 'Søger efter nye e-mails. <br><br>Hvis det er første gang, du tjekker e-mail-kontoen, kan der gå noget tid.',
    'LBL_EMAIL_CLOSE' => 'Luk',
    'LBL_EMAIL_COFFEE_BREAK' => 'Søger efter nye e-mails. <br><br>Store e-mail-konti kan tage temmelig lang tid.',
    'LBL_EMAIL_COMMON' => 'Fælles',

    'LBL_EMAIL_COMPOSE' => 'E-mail',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'Angiv modtager"e" af denne e-mail.',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'Knyt til',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'Indholdet af denne e-mail er tomt. Vil du sende alligevel?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'Denne e-mail har intet emne. Vil du sende alligevel?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '"intet emne"',
    'LBL_EMAIL_COMPOSE_READ' => 'Læs og opret e-mail',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'Send fra e-mail-konto',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'Indstillinger',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'Skriv en gyldig e-mail-adresse i felterne Til, Cc og Bcc',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'Vil du kassere denne e-mail?',
    'LBL_EMAIL_CONFIRM_DELETE' => 'Vil du fjerne disse poster fra dit adressekartotek?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'Er du sikker på, at du vil slette denne signatur?',

    'LBL_EMAIL_CREATE_NEW' => '- Opret ved Gem -',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'Flere',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'Tom',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'Sendt af afsenderen den',
    'LBL_EMAIL_DATE_RECEIVED' => 'Modtaget den',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'Tildelt til bruger',
    'LBL_EMAIL_DATE_TODAY' => 'I dag',
    'LBL_EMAIL_DATE_YESTERDAY' => 'I går',
    'LBL_EMAIL_DD_TEXT' => 'valgte e-mails.',
    'LBL_EMAIL_DEFAULTS' => 'Standarder',
    'LBL_EMAIL_DELETE' => 'Slet',
    'LBL_EMAIL_DELETE_CONFIRM' => 'Vil du slette de valgte meddelelser?',
    'LBL_EMAIL_DELETE_SUCCESS' => 'E-mailen blev slettet.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'Sletter meddelelse',
    'LBL_EMAIL_DETAILS' => 'Detaljer',
    'LBL_EMAIL_DISPLAY_MSG' => 'Viser e-mail"s" {0} - {1} af {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'Viser e-mail-adresse"r" {0} - {1} af {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'Rediger kontakt',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'Kun den primære adresse bruges, når du arbejder med kontakter.',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'Rediger adresseliste',

    'LBL_EMAIL_EMPTYING_TRASH' => 'Tømmer papirkurv',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'Sletter udgående server',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'Rydder cachefiler',
    'LBL_EMAIL_EMPTY_MSG' => 'Ingen e-mails at vise.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'Ingen e-mail-adresser at vise.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'Mappenavnet skal være entydigt og må ikke være tomt. Prøv igen.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'En mappe kan ikke slettes. Enten indeholder mappen eller den underordnede e-mails, eller der er en postkasse tilknyttet.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'Den påtænkte mappe kan ikke bestemmes ud fra konteksten. Prøv igen.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'Kontrollér dine indstillinger.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'Kontrollér, at du har skrevet et efternavn.',
    'LBL_EMAIL_ERROR_DESC' => 'Fejl er opdaget:',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'Du har ikke adgang til dette område. Kontakt webstedsadministratoren for at få adgang.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugar-mappenavne skal være entydige.',
    'LBL_EMAIL_ERROR_EMPTY' => 'Angiv nogle søgekriterier.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'En fejl er opstået',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'En e-mail-liste med dette navn findes allerede',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'Meddelelsen er fjernet fra serveren',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'Meddelelsen er enten fjernet fra serveren eller flyttet til en anden mappe',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'Der kunne ikke oprettes forbindelse til e-mail-serveren. Kontakt administratoren',
    'LBL_EMAIL_ERROR_MOVE' => 'Flytning af e-mails mellem servere og/eller e-mail-konti understøttes ikke i øjeblikket.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'Fejl ved flytning',
    'LBL_EMAIL_ERROR_NAME' => 'Et navn er påkrævet.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'En adresse i Fra er påkrævet.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'Angiv en fil.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'Omdøbning af mappen IMAP understøttes ikke i øjeblikket.',
    'LBL_EMAIL_ERROR_SERVER' => 'En e-mail-serveradresse er påkrævet.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'E-mail-kontoen er muligvis ikke gemt.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'Der opstod en fejl, mens der blev kommunikeret med e-mail-serveren.',
    'LBL_EMAIL_ERROR_USER' => 'Et brugernavn er påkrævet.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'En adgangskode er påkrævet.',
    'LBL_EMAIL_ERROR_PORT' => 'En e-mail-serverport er påkrævet.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'En serverprotokol er påkrævet.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'En overvåget mappe er påkrævet.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'En papirkurvsmappe er påkrævet.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'Disse oplysninger er ikke tilgængelige',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'Ingen udgående e-mail-server er angivet.',
    'LBL_EMAIL_FOLDERS' => 'Folders',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'Flyt til',
    'LBL_EMAIL_FOLDERS_ADD' => 'Tilføj',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'Tilføj ny mappe',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'Omdøb mappe',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'Gem',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'Tilføj denne mappe til',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'Denne mappe kan ikke ændres',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'Er du sikker på, at du vil slette denne mappe?\nDenne handling kan ikke fortrydes.\nSletningen gælder for alle de mapper, der indeholder den.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'Nyt mappenavn',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'Vælg en mappe, før du udfører denne handling.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'Administration af mapper',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'Bruger gruppe',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'Tildel til team',
    'LBL_EMAIL_FORWARD' => 'Videresend',
    'LBL_EMAIL_DELIMITER' => '"::;::"',
    'LBL_EMAIL_DOWNLOAD_STATUS' => 'Downloadet [[count]] af [[total]] e-mails',
    'LBL_EMAIL_FOUND' => 'Fundet',
    'LBL_EMAIL_FROM' => 'Fra',
    'LBL_EMAIL_GROUP' => 'gruppe',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'Gruppe',
    'LBL_EMAIL_HOME_FOLDER' => 'Startside',
    'LBL_EMAIL_HTML_RTF' => 'Send HTML',
    'LBL_EMAIL_IE_DELETE' => 'Sletter e-mail-konto',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'Sletter signatur',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'Er du sikker på, at du vil slette denne e-mail-konto?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'Sletningen blev foretaget.',
    'LBL_EMAIL_IE_SAVE' => 'Gemmer oplysninger om e-mail-konto',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'Importerer e-mail',
    'LBL_EMAIL_IMPORT_EMAIL' => 'Importér til Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'Importindstillinger',
    'LBL_EMAIL_INVALID' => 'Ugyldig',
    'LBL_EMAIL_LINK_RECORD' => 'Klik her',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'Omdøb adresseliste',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'Indtast et nyt navn for denne mailingliste',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'Vil du fjerne disse poster fra dine adresselister?',
    'LBL_EMAIL_LOADING' => 'Indlæser...',
    'LBL_EMAIL_MARK' => 'Markér',
    'LBL_EMAIL_MARK_FLAGGED' => 'Med flag',
    'LBL_EMAIL_MARK_READ' => 'Som læst',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'Uden flag',
    'LBL_EMAIL_MARK_UNREAD' => 'Som ulæst',
    'LBL_EMAIL_ASSIGN_TO' => 'Tildel til',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'Opret mappe',
    'LBL_EMAIL_MENU_COMPOSE' => 'Meddelelse til',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'Slet mappe',
    'LBL_EMAIL_MENU_EDIT' => 'Rediger',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'Tøm papirkurv',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'Synkroniser',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'Ryd cachefiler',
    'LBL_EMAIL_MENU_REMOVE' => 'Fjern',
    'LBL_EMAIL_MENU_RENAME' => 'Omdøb',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'Omdøb mappe',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'Omdøber mappe',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'Foretag et valg, før du prøver denne handling.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'Opret en mappe "i eller uden for Sugar"',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'Arkivér disse e-mails i SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'E-mail til valgte adresselister',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'E-mail til denne kontakt',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'Fjern en kontakt',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'Slet disse e-mails',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'Slet en mappe "i eller uden for Sugar"',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'Rediger en kontakt',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'Rediger en adresseliste',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'Tømmer alle papirkurvsmapper til dine e-mail-konti',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'Markér disse e-mails med flag',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'Markér disse e-mails som læst',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'Markér disse e-mails uden flag',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'Markér disse e-mails som ulæst',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'Fjerner adresselister',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'Omdøb en mappe "i eller uden for Sugar"',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'Besvar disse e-mails',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'Svar til alle modtagere af disse e-mails',

    'LBL_EMAIL_MESSAGES' => 'meddelelser',

    'LBL_EMAIL_ML_NAME' => 'Listenavn',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'Valgte listeadresser',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'Tilgængelige listeadresser',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-klik</b> for at markere flere <br />"Mac-brugere skal bruge <b>CMD-klik</b>"',

    'LBL_EMAIL_NO' => 'Nej',
    'LBL_EMAIL_NOT_SENT' => 'Systemet kan ikke behandle din anmodning. Kontakt systemadministratoren.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'Kunne ikke sættes in i bruger_password_link.',

    'LBL_EMAIL_OK' => 'OK',
    'LBL_EMAIL_ONE_MOMENT' => 'Et øjeblik...',
    'LBL_EMAIL_OPEN_ALL' => 'Åbn flere meddelelser',
    'LBL_EMAIL_OPTIONS' => 'Indstillinger',
    'LBL_EMAIL_QUICK_COMPOSE' => 'Opret hurtigt',
    'LBL_EMAIL_OPT_OUT' => 'Fravalgt',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'Frameldt og ugyldig',
    'LBL_EMAIL_PAGE_AFTER' => 'fra {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'Side',
    'LBL_EMAIL_PERFORMING_TASK' => 'Udfører opgave',
    'LBL_EMAIL_PRIMARY' => 'Primær',
    'LBL_EMAIL_PRINT' => 'Udskriv',

    'LBL_EMAIL_QC_BUGS' => 'Fejl',
    'LBL_EMAIL_QC_CASES' => 'Sag',
    'LBL_EMAIL_QC_LEADS' => 'Kundeemne',
    'LBL_EMAIL_QC_CONTACTS' => 'Kontakt',
    'LBL_EMAIL_QC_TASKS' => 'Opgave',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'Salgsmulighed',
    'LBL_EMAIL_QUICK_CREATE' => 'Hurtig oprettelse',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'Genopbygger mapper',
    'LBL_EMAIL_RELATE_TO' => 'Relater',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'Vis relationer',
    'LBL_EMAIL_RECORD' => 'E-mail-post',
    'LBL_EMAIL_REMOVE' => 'Fjern',
    'LBL_EMAIL_REPLY' => 'Besvar',
    'LBL_EMAIL_REPLY_ALL' => 'Svar til alle',
    'LBL_EMAIL_REPLY_TO' => 'Svar til',
    'LBL_EMAIL_RETRIEVING_LIST' => 'Henter e-mail-liste',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'Henter meddelelse',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'Henter e-mail-post',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'Vælg kun én e-mail-post',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'Retur til foregående modul?',
    'LBL_EMAIL_REVERT' => 'Vend tilbage',
    'LBL_EMAIL_RELATE_EMAIL' => 'Relater e-mail',

    'LBL_EMAIL_RULES_TITLE' => 'Administration af regler',

    'LBL_EMAIL_SAVE' => 'Gem',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'Gem og besvar',
    'LBL_EMAIL_SAVE_DRAFT' => 'Gem kladde',

    'LBL_EMAIL_SEARCHING' => 'Udfører søgning',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'Avanceret søgning',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'Dato fra',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'Dato til',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'Brødtekst',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'Ingen resultater matcher dine søgekriterier.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'Søgeresultater',
    'LBL_EMAIL_SEARCH_TITLE' => 'Enkel søgning',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'Søg efter e-mail-konto',

    'LBL_EMAIL_SELECT' => 'Vælg',

    'LBL_EMAIL_SEND' => 'Send',
    'LBL_EMAIL_SENDING_EMAIL' => 'Sender e-mail',

    'LBL_EMAIL_SETTINGS' => 'Indstillinger',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 rækker',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 koloner',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'Layouttypografi',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'E-mail-konti',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'Ryd formular',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'Importér e-mail ved visning',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'Søg efter nye e-mails',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'Brug indholdsrude',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'Brug pop op-vindue',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'Antal e-mails pr. side',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'Rediger e-mail-konto',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'Mapper',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'Fra adresse',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'E-mail-adresse til testmeddelelse:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'Til e-mail-adresse',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'Fra navn',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'Svar til adresse',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'Fuld skærm',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'Synkroniser alle e-mail-konti',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'En e-mail er sendt til den angivne e-mail-adresse ved hjælp af de angivne indstillinger for udgående e-mail. Kontrollér, om e-mailen er modtaget, for at bekræfte, at indstillingerne er korrekte.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'Når du udfører denne handling, synkroniseres e-mail-konti og deres indhold.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'Vil du udføre en fuldstændig synkronisering?\nMed store e-mail-konti kan det tage et par minutter.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'Tryk på Skift eller Ctrl for at vælge flere mapper.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'Generelt',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'Tilgængelige gruppemapper',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'Opret gruppemapper',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Gemmer gruppemapper',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'Henter gruppemappe',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Rediger gruppemappe',

    'LBL_EMAIL_SETTINGS_NAME' => 'Navn på e-mail-konto',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'Disse indstillinger kan kræve en opdatering af siden for at aktivere.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'Henter e-mail-konto',
    'LBL_EMAIL_SETTINGS_RULES' => 'Regler',
    'LBL_EMAIL_SETTINGS_SAVED' => 'Indstillingerne er gemt.\n\nDu skal genindlæse siden, før de nye indstillinger træder i kraft.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'Du skal genindlæse siden før de nye indstillinger træder i kraft.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'Send kun e-mails som almindelig tekst',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'Aktiv',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'E-mails pr. side',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'Placer faner nederst',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'Visuelle indstillinger',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'Indstillinger',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'Vis avanceret',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'Tilgængelige brugermapper',
    'LBL_EMAIL_ERROR_PREPEND' => 'Fejl under afsendelse af e-mail:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'Den udgående e-mail-server, der er valgt til den e-mail-konto, du bruger, er ugyldig. Kontrollér indstillingerne, eller vælg en anden e-mail-server til e-mail-kontoen.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'En udgående e-mail-server er ikke konfigureret til udgående e-mail for den e-mail-konto, du bruger. Vælg eller tilføj en udgående e-mail-server til e-mail-kontoen.',
    'LBL_EMAIL_SHOW_READ' => 'Vis alle',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'Vis kun ulæste',
    'LBL_EMAIL_SIGNATURES' => 'Signaturer',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'Opret signatur',
    'LBL_EMAIL_SIGNATURE_NAME' => 'Signaturnavn',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'Signaturtekst',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Byt online',
    'LBL_SMTPTYPE_GMAIL' => 'Google Mindre sikre apps',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! e-mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'Andet',
    'LBL_EMAIL_AUTHORIZE' => 'Godkend',
    'LBL_EMAIL_AUTHORIZED' => 'Godkendt',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'Ikke godkendt',
    'LBL_EMAIL_AUTH_WARNING' => 'En administrator skal konfigurere {0} Connector via Admin > Connectors, før du kan opsætte denne konto. For mere information se {1} dokumentation.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'Fejl ved hentning af forbindelsesoplysninger',
    'LBL_EMAIL_AUTH_FAILURE' => 'Godkendelse mislykkedes.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'Godkend kontoen før gemning.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'Godkend kontoen før testning.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'Konto er ikke godkendt',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ Eksterne mapper ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugar-mapper ]',
    'LBL_EMAIL_SUBJECT' => 'Emne',
    'LBL_EMAIL_SUCCESS' => 'Handlingen lykkedes',
    'LBL_EMAIL_SUGAR_FOLDER' => 'Sugar-mappe',
    'LBL_EMAIL_TEAMS' => 'Tildel til team',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'Brødteksten til e-mail-skabelonen er tom',
    'LBL_EMAIL_TEMPLATES' => 'Skabeloner',
    'LBL_EMAIL_TEXT_FIRST' => 'Første side',
    'LBL_EMAIL_TEXT_PREV' => 'Foregående side',
    'LBL_EMAIL_TEXT_NEXT' => 'Næste side',
    'LBL_EMAIL_TEXT_LAST' => 'Sidste side',
    'LBL_EMAIL_TEXT_REFRESH' => 'Opdater',
    'LBL_EMAIL_TO' => 'Til',
    'LBL_EMAIL_TOGGLE_LIST' => 'Slå liste til og fra',
    'LBL_EMAIL_VIEW' => 'Vis',
    'LBL_EMAIL_VIEWS' => 'Visninger',
    'LBL_EMAIL_VIEW_HEADERS' => 'Vis headere',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'Version, der kan udskrives',
    'LBL_EMAIL_VIEW_RAW' => 'Vis rå e-mail',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'Denne funktion understøttes ikke, når den bruges med POP3.',
    'LBL_DEFAULT_LINK_TEXT' => 'Standardtekst til link.',
    'LBL_EMAIL_YES' => 'Ja',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'Send test-e-mail',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'Test-e-mailen er sendt',


    'LBL_EMAIL_MESSAGE_NO' => 'Meddelelsesnr.',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'Importen er fuldført',
    'LBL_EMAIL_IMPORT_FAIL' => 'Importen mislykkedes, fordi meddelelsen enten allerede er importeret eller er blevet slettet fra serveren',

    'LBL_EMAILS_FROM' => 'E-mails afsendt',
    'LBL_EMAILS_RECEIVED' => 'E-mails modtaget',
    'LBL_EMAIL_ADDRESSES_USED' => 'E-mail-adresser, der bruges i E-mails',
    'LBL_EMAIL_ADDRESS' => 'E-mail-adresse',
    'LBL_FROM' => 'Fra',
    'LBL_TO' => 'Til',
    'LBL_CC' => 'Cc',
    'LBL_BCC' => 'Bcc',

    'LBL_START_DATE' => 'Startdato',
    'LBL_END_DATE' => 'Slutdato',
    'LBL_START' => 'Start',
    'LBL_END' => 'Afslut',
    'LBL_DATE_LINKED' => 'Dato sammenkædet',

    'LBL_LINK_NONE' => 'Ingen',
    'LBL_LINK_ALL' => 'Alle',
    'LBL_LINK_RECORDS' => 'Poster',
    'LBL_LINK_SELECT' => 'Vælg',
    'LBL_LINK_ACTIONS' => 'Handlinger',
    'LBL_LINK_MORE' => 'Mere',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'Bekræft',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'Vil du lukke dette #module#?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'Vis ikke denne meddelelse i fremtiden:',
    'LBL_INVALID_FILE_EXTENSION' => 'Ugyldigt fil-efternavn',
    'LBL_LIST_TEAM' => 'Team',
    'LBL_TEAM' => 'Team:',
    'LBL_TEAMS' => 'Team',
    'LBL_TEAM_SET_ID' => 'Teamsæt-ID',
    'LBL_TEAM_SET_SELECTED_ID' => 'Valgte Teamsæt-ID',
    'LBL_TEAM_SET_SELECTED' => 'Valgt',
    'LBL_TEAM_SET_ENABLE' => 'Aktiver yderligere tilladelser',
    'LBL_TEAM_SET_DISABLE' => 'Deaktiver yderligere tilladelser',
    'LBL_TEAM_SET' => 'Teamsæt',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'Valgte teams',
    'LBL_SEARCH_UNAVAILABLE' => 'Søgning ikke tilgængelig, venligst prøv igen senere.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'Intet primært team er angivet',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'Fejl under forsøg på at fjerne det primære team-ID [{0}] for [{1}]-modulet med id&#39;et [{2}]',
    'LBL_TEAM_ADD' => 'Tilføj Team',
    'LBL_TEAM_REMOVE' => 'Fjern Team',
    'LBL_TEAM_PRIMARY' => 'Angiv som Primært Team',

    'LBL_CLOSE_BUTTON_LABEL' => 'Luk',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} markeret som {{status}}.',

    'LBL_FOCUS' => 'Fokus',

    'LBL_QUERY_VALID' => 'Gyldig',
    'LBL_QUERY_ERROR' => 'Fejl!',
    'LBL_QUERY_CHILD' => 'Gyldig underforespørgsel',
    'ERROR_EXAMINE_MSG' => 'Undersøg fejlmeddelelsen nedenfor:',
    'NO_QUERY_SELECTED' => 'Det dataformat, du har valgt, indeholder ikke nogen forespørgsel. Vælg en brugerdefineret forespørgsel til dette dataformat.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'Der er opstået en fejl:',
    'ERR_AJAX_LOAD_FAILURE' => 'Der opstod en fejl under behandling af din anmodning, prøv igen på et senere tidspunkt.',
    'ERR_AJAX_LOAD_FOOTER' => 'Hvis fejlen opstår igen, skal du have din administrator til at deaktivere Ajax for dette modul.',
    'ERR_CREATING_FIELDS' => 'Fejl ved udfyldning af felter med yderligere detaljer:',
    'ERR_CREATING_TABLE' => 'Fejl ved oprettelse af tabel:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'Decimalseparatoren kan ikke bruge samme tegn som tusindtalsseparatoren.

 Prøv at ændre værdierne.',
    'ERR_DELETE_RECORD' => 'Der skal angives et postnummer for at slette kontakten.',
    'ERR_EXPORT_DISABLED' => 'Eksport blev deaktiveret.',
    'ERR_EXPORT_TYPE' => 'Fejl ved eksport',
    'ERR_REPORTS_DISABLED_EXPORT' => 'Eksport af rapporter er deaktiveret',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'Kun administratorbrugere kan eksportere',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'Rapport benytter moduler uden adgang til Eksport',
    'ERR_REPORTS_EXPORT_OWNER' => 'Rapport benytter moduler med adgang til Ejereksport',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'Rapport benytter moduler med begrænset adgang til Liste',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'Rapport benytter moduler med begrænset adgang til Visning',
    'ERR_REPORTS_ACCESS_DISABLED' => 'Rapport benytter moduler med begrænset adgang',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'Rapport benytter felter med begrænset adgang',
    'ERR_INVALID_AMOUNT' => 'Angiv et gyldigt beløb.',
    'ERR_INVALID_DATE_FORMAT' => 'Datoformatet skal være:',
    'ERR_INVALID_DATE' => 'Indtast en gyldig dato.',
    'ERR_INVALID_DAY' => 'Indtast en gyldig dag.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'ikke gyldig e-mail-adresse.',
    'ERR_INVALID_FILE_REFERENCE' => 'Ugyldig filreference',
    'ERR_INVALID_HOUR' => 'Angiv et gyldigt klokkeslæt.',
    'ERR_INVALID_MONTH' => 'Angiv en gyldig måned.',
    'ERR_INVALID_TIME' => 'Angiv et gyldigt tidspunkt.',
    'ERR_INVALID_YEAR' => 'Angiv et gyldigt 4-cifret årstal.',
    'ERR_NEED_ACTIVE_SESSION' => 'En aktiv session skal eksportere indhold.',
    'ERR_NO_HEADER_ID' => 'Denne funktion er ikke tilgængelig i dette tema.',
    'ERR_NOT_ADMIN' => 'Uautoriseret adgang til administration.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'Password Management fås kun i <a href="%s" target="_blank">SugarCloud Settings</a>.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'Kontakt venligst Sugar-administratoren, hvis du vil foretage ændringer af skrivebeskyttede felter.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'Gå til <a href="{0}" target="_blank">Cloud Settings</a> for at foretage ændringer i ikke-skrivbare felter.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'Mangler obligatorisk felt:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'Ugyldigt obligatorisk felt:',
    'ERR_INVALID_VALUE' => 'Ugyldig værdi:',
    'ERR_NO_SUCH_FILE' => 'Filen findes ikke på systemet',
    'ERR_NO_SINGLE_QUOTE' => 'Enkelt anførselstegn kan ikke bruges til',
    'ERR_NOTHING_SELECTED' => 'Foretag et valg, før du fortsætter.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'En salgsmulighed med navnet %s findes allerede. Angiv et andet navn nedenfor.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'Et salgsmulighedsnavn er ikke angivet. Angiv et salgsmulighedsnavn nedenfor.',
    'ERR_QUOTE_CONVERTED' => 'Dette tilbud er allerede blevet konverteret til en salgsmulighed.',
    'ERR_POTENTIAL_SEGFAULT' => 'En potentiel Apache-segmenteringsfejl blev opdaget. Giv systemadministratoren besked om at bekræfte dette problem og få hende/ham til at rapportere det til SugarCRM.',
    'ERR_SELF_REPORTING' => 'En bruger kan ikke rapportere til sig selv.',
    'ERR_SINGLE_QUOTE' => 'Brug af enkelt anførselstegn understøttes ikke i dette felt. Rediger værdien.',
    'ERR_SQS_NO_MATCH_FIELD' => 'Intet resultat for feltet:',
    'ERR_SQS_NO_MATCH' => 'Intet resultat',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Angiv &#39;nøgle&#39;indeks i attributten displayParams til definitionen af metadata',
    'ERR_EXISTING_PORTAL_USERNAME' => 'Fejl: Portalnavnet er allerede tildelt til en anden kontakt.',
    'ERR_PORTAL_NAME_CHECK' => 'Kan ikke kontrollere, at Portal brugernavn er unik',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'Feltværdien er ikke kompatibel med præcisionsværdien',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'Der opstod en fejl, da du forsøgte at gemme på den eksterne konto.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'En fejl opstod under upload. Tilse venligst at den fil, du uploader, ikke er tom.',
    'ERR_NO_DB' => 'Kunne ikke forbinde til databasen. Der henvises til sugarcrm.log for detaljer.',
    'ERR_DB_FAIL' => 'Database fejl. Der henvises til sugarcrm.log for detaljer.',
    'ERR_EXTERNAL_API_403' => 'Adgang nægtet. Filtype understøttes ikke.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth Adgang Token mangler.',
    'ERR_DB_VERSION' => 'Sugar CRM {0} filer må kun benyttes med en Sugar CRM {1} database.',
    'ERR_DB_QUERY' => '{0}: søg mislykkedes: {1}',
    'ERR_UW_RETIRED' => 'Opgradere Wizard er ikke tilgængelig i denne version.',
    'ERR_NOT_CLOUD_INSTANCE' => 'Sugar-tilfældet er enten ikke et SugarCloud-tilfælde eller er ikke konfigureret til SugarCloud Insights.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'Du har ikke rettigheder til at oprette {moduleName}. Kontakt din administrator hvis du har brug for adgang.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'Nuværende bruger ikke autoriseret til at ændre {moduleName} konfigurationsindstillinger',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'Nuværende bruger ikke autoriseret til at ændre {moduleName} konfigurationsindstillinger',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'Du er ikke autoriseret til at gemme denne som en favorit {moduleName}. Kontakt din administrator for at få adgang.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'Du er ikke autoriseret til at abonnere på den {moduleName}. Kontakt din administrator for at få adgang.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'arbejdsark_kolonner_tilhørende_felter ikke fundet i data',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'resumé_kolonner er ikke et array',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'resumé_kolonner_tilhørende_felter ikke fundet i data',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rækker er ikke et array',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'footer_rækker_tilhørende_felter ikke fundet i data',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'Din forespørgsel fejlede pga. en ukendt fejl.',
    'EXCEPTION_FATAL_ERROR' => 'Din forespørgsel blev ikke afsluttet. En fatal fejl opstod. Check logs for at få mere information.',
    'EXCEPTION_NEED_LOGIN' => 'Du skal være logget ind for at kunne udføre dette.',
    'EXCEPTION_INVALID_TOKEN' => 'Din ægthedsbekræftelsestoken er ugyldig.',
    'EXCEPTION_NOT_AUTHORIZED' => 'Du har ikke tilladelse til at udføre denne handling. Kontakt administratoren, hvis du har brug for adgang.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'Du har ikke tilladelse til at se data. Kontakt din administrator, hvis du har brug for adgang.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'Du kan ikke få adgang til portalen, fordi din portal konto er inaktiv. Kontakt venligst kundesupport, hvis du har brug for adgang til.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'Portalen er ikke konfigureret korrekt. Kontakt din Portal Administrator for assistance.',
    'EXCEPTION_NO_METHOD' => 'Din anmodning er ikke understøttet. Kan ikke finde HTTP-metoden til stien i din anmodning.',
    'EXCEPTION_NOT_FOUND' => 'Din efterspurgte ressource blev ikke fundet. Kunne ikke finde en håndtering til stien angivet i anmodningen.',
    'EXCEPTION_MISSING_PARAMTER' => 'En nødvendig parameter i din anmodning mangler.',
    'EXCEPTION_INVALID_PARAMETER' => 'En parameter i din anmodning er ugyldig.',
    'EXCEPTION_REQUEST_FAILURE' => 'Din anmodning kunne ikke fuldføres.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'Din metadata eller brugerhash svarer ikke til serveren. Venligst gensende din metadata.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'Din anmodning er for stor til processen.',
    'EXCEPTION_EDIT_CONFLICT' => 'Redigerings konflikt, bedes genindlæse postens data.',
    'EXCEPTION_METADATA_CONFLICT' => 'Metadata konflikt, bedes genindlæse metadata.',
    'EXCEPTION_CLIENT_OUTDATED' => 'Softwaren er forældet, opdatere din klient, før du prøver at oprette forbindelse igen.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'En konnektor- eller en integrationsanmodning resulterede i et mislykket svar.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM er i vedligeholdelse stilstand. Kun admins kan logge ind. Kontakt din administrator for yderligere oplysninger.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'Serveren kan ikke behandle din anmodning, fordi den er optaget eller ikke tilgængelig på dette tidspunkt.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'Søgemaskine er midlertidigt utilgængelig.',
    'EXCEPTION_SEARCH_RUNTIME' => 'Der opstod en fejl i søgemaskinen. Kontakt venligst din systemadministrator.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'Et felt, der er låst af en proces kan ikke redigeres.',
    'EXCEPTION_MODULE_DISABLED' => 'Dette modul er deaktiveret for nuværende bruger.',
    'EXCEPTION_FIELD_DISABLED' => 'Dette feltmodul er deaktiveret for nuværende bruger.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'Denne klient er ikke tilladt',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'Muligheden for at uploade pakker er ikke muligt for din licenstype',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'En tilstand opstået på grund af en generel svigt eller fejl. Årsagerne til denne undtagelse varierer, men normalt falder udenfor rammerne af en mere specifik API undtagelse.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'Din anmodning kan ikke behandles som fremlagt, eller der var en fejl for den respons. Dette indikerer normalt en fatal fejl, og at de specifikke mangler kan identificeres i ansøgningen log.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'Den version af API, du bruger, er ikke korrekt for den aktuelle anmodning.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'Den ønskede endpoint kræver godkendelse og den anmodende forbrugeren har endnu ikke godkendt.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'Angiver, at ægthedsbekræftelsestoken præsenteret for anmodningen er ugyldig. Dette sker normalt på grund af den token udløber, men kan også være, fordi token er forkert format eller er forkert.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'Indikerer at den forespurte forbrukeren ikke er autorisert til å utføre den forespurte handlingen.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'Portalkonto i forbindelse med den indloggede bruger er ikke aktiv i øjeblikket. Dette kræver handling fra den del af kundesupport.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'Angiver, at portalen ansøgning ikke er konfigureret korrekt, og kan ikke bruges. Dette kræver en indsats fra  portalens administrator.',
    'EXCEPTION_NO_METHOD_DESC' => 'Endepunkt understøtter ikke HTTP requesttypen, der bliver gjort. Dette kan ske, når en POST anmodningen er stilet til et endepunkt, der er designet til en GET-anmodning.',
    'EXCEPTION_NOT_FOUND_DESC' => 'Endepunkt kunne ikke allokere en ressource for anmodningen eller ikke besidder en handler til anmodningen.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'Angiver, at der kan have været parallelle redigeringer i en post, og den aktuelle anmodning om at redigere posten ville påvirke en tidligere redigering af posten.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'Angiver, at metadata på serveren ikke svarer til metadata klienten bruger i øjeblikket. Dette kan ske efter en ændring til systemindstillinger, ændringer i moduler i Studio eller indsættelse af nye moduler, blandt andet systemændringer.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'Anmodningen er for stor til at blive håndteret af serveren.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'Angiver en påkrævet parameter af anmodningen mangler.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'Angiver en parameter sendt i anmodningen er ugyldig.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'Anmodningen kunne ikke fuldføre.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'Angiver klienten forbrugende af API er forældet og skal opdateres før yderligere forbrug af API kan finde sted.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'Angiver, at en anmodning via API&#39;en til en anden tjeneste, endpoint eller URI er mislykkedes eller ikke kunne håndteres af serveren.',
    'EXCEPTION_MAINTENANCE_DESC' => 'Den forekomst af SugarCRM, der afsoner API er i vedligeholdelsestilstand. Adgang til API er begrænset til kun administratorer.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'Angiver, at serveren er optaget, overbelastet eller nede.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'Søgemaskinens backend er ikke tilgængelig i øjeblikket på grund af et forbindelsesproblem. Kontroller tilslutning og konfiguration i Admin->search->test.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'En runtime undtagelse opstod i SearchEngine. Se sugarcrm.log for yderligere detaljer.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'Et felt, der er i øjeblikket låst af en kørende proces kan ikke redigeres.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s er låst af en kørende proces og kan ikke redigeres.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s er låst af en kørende proces og kan ikke redigeres.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'Dette modul er deaktiveret for nuværende bruger.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'Dette felt er deaktiveret for nuværende bruger.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'Denne klient er ikke tilladt',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'En fil navn med samme navn findes allerede i systemet.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'Fejl Tidsperiode udefineret for dato {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'Denne tidsperiode har allerede delperioder',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'Delperioder kan ikke have egne delperioder',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'Kan ikke hente nogen perioder af typen: {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'Ingen aktive tidsperioder for de nuværende indstillinger.',
    'LBL_CURRENT_TIMEPERIOD' => 'Aktuel tidsperiode',
    'LBL_PREVIOUS_TIMEPERIOD' => 'Foregående tidsperiode',
    'LBL_NEXT_TIMEPERIOD' => 'Næste tidsperiode',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'Foregående, Nuværende, Næste',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'Du kan ikke slette poster, der har en lukket salgsfase.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'Du kan ikke slette poster, der har en lukket salgsstatus.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'En eller flere af de udvalgte poster har en salgsfase som Closed Won eller Closed Lost og kan ikke slettes.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'En eller flere af de udvalgte poster har en salgsstatus som Closed Won eller Closed Lost og kan ikke slettes.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'Virksomhed',
    'LBL_OLD_ACCOUNT_LINK' => 'Gammel konto',
    'LBL_ACCOUNTS' => 'Konti',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'Aktiviteter',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Vis oversigt',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Vis oversigt [Alt+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Tilføj [Alt+A]',
    'LBL_ADD_BUTTON' => 'Tilføj',
    'LBL_ADD_DASHLET_BUTTON' => 'Tilføj Dashlet',
    'LBL_ADD_DOCUMENT' => 'Tilføj dokument',
    'LBL_REPLACE_BUTTON' => 'Erstat',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Føj til målgruppeliste',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Føj til målgruppeliste',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Klik for at lukke',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Luk',
    'LBL_ADDITIONAL_DETAILS' => 'Flere oplysninger',
    'LBL_ADMIN' => 'Administration',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'Arkiv',
    'LBL_ASSIGNED_TO_USER' => 'Tildelt til bruger',
    'LBL_ASSIGNED_TO' => 'Tildelt til:',
    'LBL_BACK' => 'Tilbage',
    'LBL_BASE_RATE' => 'basevaluta',
    'LBL_BILL_TO_ACCOUNT' => 'Fakturamodtager',
    'LBL_BILL_TO_CONTACT' => 'Fakturamodtagers kontakt',
    'LBL_BILLING_ADDRESS' => 'Faktureringsadresse',
    'LBL_QUICK_CREATE_TITLE' => 'Hurtig oprettelse',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} » {{/if}}{{module}} » {{appId}}',
    'LBL_BUGS' => 'Fejl',
    'LBL_BY' => 'af',
    'LBL_CALLS' => 'Opkald',
    'LBL_CALL' => 'Opkald',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Send kampagne-e-mails, der er i kø',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Indsend',
    'LBL_CASE' => 'Sag',
    'LBL_CASES' => 'Sager',
    'LBL_MESSAGE' => 'Meddelelse',
    'LBL_MESSAGES' => 'Meddelelser',
    'LBL_ESCALATIONS' => 'Eskaleringer',
    'LBL_ESCALATION' => 'Eskalering',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign-konvolutter',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign-konvolut',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'Vælg underskriverens modtagere',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'Skift adgangskode',
    'LBL_CHANGE_BUTTON_LABEL' => 'Skift',
    'LBL_CHANGE_BUTTON_TITLE' => 'Skift [Alt+G]',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Tjek alt',
    'LBL_CITY' => 'By',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Ryd',
    'LBL_CLEAR_BUTTON_TITLE' => 'Ryd [Alt+C]',
    'LBL_CLEARALL' => 'Ryd alt',
    'LBL_CLICK_TO_EDIT' => 'Klik for at redigere',
    'LBL_CLOSE_BUTTON_TITLE' => 'Luk',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'Luk vindue',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Luk alt',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Luk alt [Alt+I]',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Luk og opret ny',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Luk og opret ny',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'Kopiér Record URL',
    'LBL_OPEN_ITEMS' => 'Open poster:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Opret e-mail',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'Email',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Opret e-mail [Alt+L]',
    'LBL_SEARCH_DROPDOWN_YES' => 'Ja',
    'LBL_SEARCH_DROPDOWN_NO' => 'Nej',
    'LBL_CONTACT_LIST' => 'Kontaktliste',
    'LBL_CONTACT' => 'Kontakt',
    'LBL_CONTACTS' => 'Kontakter',
    'LBL_CONTRACTS' => 'Kontrakter',
    'LBL_COUNTRY' => 'Land:',
    'LBL_RESET_BUTTON_LABEL' => 'Nulstille',
    'LBL_CREATE_BUTTON_LABEL' => 'Opret',
    'LBL_CREATED_BY_USER' => 'Oprettet af bruger',
    'LBL_CREATED_USER' => 'Oprettet af bruger',
    'LBL_CREATED_ID' => 'Oprettet af ID',
    'LBL_CREATED' => 'Oprettet af',
    'LBL_CREATE_NEW_TARGET_LIST' => 'Opret ny målliste',
    'LBL_CURRENT_USER_FILTER' => 'Kun mine poster:',
    'LBL_CURRENCY' => 'Valuta:',
    'LBL_CURRENCIES' => 'Valutaer',
    'LBL_CURRENCY_NAME' => 'Valutanavn',
    'LBL_CURRENCY_SYMBOL' => 'Valutasymbol',
    'LBL_CURRENCY_RATE' => 'Valuta kurs',
    'LBL_CURRENCY_ID' => 'Valuta ID',
    'LBL_DOCUMENTS' => 'Dokumenter',
    'LBL_DATE_ENTERED' => 'Oprettet den:',
    'LBL_DATE_MODIFIED' => 'Sidst ændret:',
    'LBL_ACTIVITY_MODIFIED' => 'Ændret',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'Rediger oversigtsfane',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'Rediger modulfaner',
    'LBL_EDIT_BUTTON' => 'Rediger',
    'LBL_DUPLICATE_BUTTON' => 'Dupliker',
    'LBL_DELETE_BUTTON' => 'Slet',
    'LBL_DELETE' => 'Slet',
    'LBL_DELETED' => 'Slettet',
    'LBL_DIRECT_REPORTS' => 'Direkte rapporter',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Udført',
    'LBL_DONE_BUTTON_TITLE' => 'Udført [Alt+X]',
    'LBL_DST_NEEDS_FIXIN' => '"Programmet kræver, at rettelsen Sommertid anvendes. Gå til linket <a href=""index.php?module=Administration&action=DstFix"">Repair</a> i administrationskonsollen, og anvend rettelsen Sommertid."',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'Rediger som ny',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'Rediger som ny',
    'LBL_EDIT_IN_NEW_TAB' => 'Redigér i Ny fane',
    'LBL_FAVORITES' => 'Favoritter',
    'LBL_FILTER' => 'Filter',
    'LBL_DEFAULT_DATA_FILTER' => 'Standard datafilter',
    'LBL_FILTER_MENU_BY' => 'Filtrer menu efter',
    'LBL_FILTER_SELECT_FIELD' => 'Vælg feltet ...',
    'LBL_FILTER_SELECT_OPERATOR' => 'Vælg operatør ...',
    'LBL_FILTER_CREATE_NEW' => 'Opret',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'Opret filter (ikke gemt)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(Ikke gemt)',
    'LBL_FILTER_CREATE_FILTER' => 'Opret nyt filter',
    'LBL_FILTER_CLOSE_FILTER' => 'Luk filter',
    'LBL_FILTER_EDIT_FILTER' => 'Rediger filter',
    'LBL_FILTER_ALL_RECORDS' => 'Alle poster',
    'TPL_FILTER_SAVE' => 'Du oprettet filtret {{name}}.',
    'LBL_FILTER_BETWEEN_FROM' => 'Fra',
    'LBL_FILTER_BETWEEN_TO' => 'Til',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'Startdato',
    'LBL_FILTER_DATEBETWEEN_TO' => 'Slutdato',
    'LBL_FOLLOWING' => 'Følger',
    'LBL_UNFOLLOW' => 'Følg ikke længere',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'Hent .vcf',
    'LBL_EMPTY_VCARD' => 'Vælg en vCard-fil',
    'LBL_IMAGE' => 'Billede',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard har ikke alle de påkrævede felter for dette modul.',
    'LBL_VCARD_ERROR_FILESIZE' => 'Den uploadede fil overstiger 30000 byte størrelse grænse, som blev angivet i HTML-formularen.',
    'LBL_VCARD_ERROR_DEFAULT' => 'Der opstod en fejl under upload af vCard-filen.',
    'TPL_IMPORT_VCARD_FAILURE' => 'Kunne ikke oprette {{module}} fra vCard',
    'LBL_IMPORT_VCARD' => 'Importér vCard:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'Importér vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'Importér vCard [Alt+I]',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'Vis',
    'LBL_VIEW_BUTTON_TITLE' => 'Vis [Alt+V]',
    'LBL_VIEW_BUTTON' => 'Vis',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'E-mail som PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'E-mail som PDF [Alt+M]',
    'LBL_EMAIL' => 'E-mail',
    'LBL_EMAILS' => 'E-mails',
    'LBL_EMPLOYEES' => 'Medarbejdere',
    'LBL_ENTER_DATE' => 'Indtast dato',
    'LBL_EXPORT_ALL' => 'Eksportér alt',
    'LBL_EXPORT' => 'Eksportér',
    'LBL_FAVORITES_FILTER' => 'Mine favoritter:',
    'LBL_GLOBAL_SEARCH' => 'Global søgning',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'Global søgning af modulfilter',
    'LBL_GLOBAL_SEARCH_RUN' => 'Kør global søgning',
    'LBL_GO_BUTTON_LABEL' => 'Start',
    'LBL_GS_HELP' => 'Felterne i dette modul som blev brugt i søgningen vises ovenfor. Den fremhævede tekst matcher dine søgekriterier.',
    'LBL_HIDE' => 'Skjul',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => 'Importér',
    'LBL_IMPORT_STARTED' => 'Import startet:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Du skal angive et brugerdefineret afgrænsningstegn.',
    'LBL_LAST_VIEWED' => 'Senest vist',
    'LBL_SELECTED_RECORDS' => 'Valgt: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'Vis færre',
    'LBL_SHOW_MORE' => 'Vis flere',
    'LBL_SHOW_MORE_MODULE' => 'Mere {{{module}}} ...',
    'LBL_SHOW_MORE_RECENTS' => 'Flere sidst brugte...',
    'LBL_SHOW_LESS_RECENTS' => 'Færre sidst brugte...',
    'LBL_SHOW_MORE_RESULTS' => 'Flere søgeresultater...',
    'TPL_SHOW_MORE_MODULE' => 'Flere {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => 'Flere {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => 'Dagens aktiviteter',
    'LBL_LEADS' => 'Kundeemner',
    'LBL_LEAD' => 'Kundeemne',
    'LBL_QUOTES_BILL_TO' => 'Tilbud (Send regning til)',
    'LBL_LESS' => 'mindre',
    'LBL_CAMPAIGN' => 'Kampagne:',
    'LBL_CAMPAIGNS' => 'Kampagner',
    'LBL_CAMPAIGNLOG' => 'Kampagnelog',
    'LBL_CAMPAIGN_CONTACT' => 'Kampagner',
    'LBL_CAMPAIGN_ID' => 'kampagne_ID',
    'LBL_THEME' => 'Tema:',
    'LBL_THEME_PICKER' => 'Sidelayout',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'Advarsel: Internet Explorer 6 understøttes ikke til det valgte tema. Klik på OK for at vælge det alligevel eller på Annuller for at vælge et andet tema.',
    'LBL_FOUND_IN_RELEASE' => 'Fundet i udgivelse',
    'LBL_FIXED_IN_RELEASE' => 'Rettet i udgivelse',
    'LBL_LIST_ACCOUNT_NAME' => 'Kontonavn',
    'LBL_LIST_ASSIGNED_USER' => 'Bruger',
    'LBL_LIST_CONTACT_NAME' => 'Kontaktnavn',
    'LBL_LIST_CONTACT_ROLE' => 'Kontaktrolle',
    'LBL_LIST_DATE_ENTERED' => 'Oprettet den',
    'LBL_LIST_EMAIL' => 'E-mail',
    'LBL_LIST_NAME' => 'Navn',
    'LBL_LIST_OF' => 'af',
    'LBL_LIST_PHONE' => 'Telefon',
    'LBL_LIST_RELATED_TO' => 'Relateret til',
    'LBL_LIST_USER_NAME' => 'Brugernavn',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'Er du sikker på, at du vil opdatere hele listen?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Vælg mindst 1 post for at fortsætte.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Vælg mindst 2 poster for at fortsætte.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'Vælg mindre end 10 poster for at fortsætte.',
    'LBL_LISTVIEW_ALL' => 'Alle',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'Frys kolonne 1',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'Alle dubletter',
    'LBL_LISTVIEW_NONE' => 'Ingen',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Denne side',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Alle poster',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Valgte poster',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Valgt: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'Ryd alle valg.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'Vælg alle poster',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'Der er mere end {{num}} poster i resultatet. Du har valgt de første {{num}} poster.',
    'TPL_LISTVIEW_SELECTED' => 'Du har valgt {{num}} poster i resultat sættett.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'Du har valgt 1 post i resultatsættet.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'Du har valgt alle {{num}} poster i  resultat sættett.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'Du har valgt alle {{num}} poster i denne visning. {{link}} i resultat sættett.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'Opdaterer {{num}} af {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(cirka {{time}} {{unit}} tilbage)',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'Masseopdatering mislykkedes. Start af nyt forsøg ({{num}} af {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'Masseopdatering ufuldstændig. {{num}} post (er) forbliver uændret.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'Masseopdatering ufuldstændig. {{num}} post (er) forbliver uændret.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} poster blev ignoreret på grund af tilladeler eller fejl.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} post(er) er blevet opdateret.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} Masseopdatering',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'Sletter {{num}} af {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(cirka {{time}} {{unit}} tilbage)',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'Massesletning mislykkedes. Start af nyt forsøg ({{num}} af {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'Massesletning ufuldstændig. {{num}} post(er) tilbage.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'Massesletning ufuldstændig. {{num}} post(er) tilbage.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} post(er) blev slettet.',
    'TPL_MASSDELETE_TITLE' => '{{module}} Masse sletning',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'Tilføjelse {{num}} af {{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(cirka {{time}} {{unit}} tilbage)',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'Masse-tilføjelse til mål liste mislykkedes. Start af nyt forsøg ({{num}} af {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'Masse-tilføjelse til mål liste mislykkedes. {{num}} poster ikke tilføjet.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'Masse-tilføjelse til mål liste mislykkedes. {{num}} poster ikke tilføjet.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} poster blev tilføjet.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} Masse-tilføjelser til målliste',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'Sammenkobling {{num}} af {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(cirka {{time}} {{unit}} tilbage)',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'Masse-sammenkobling mislykkedes. Start af nyt forsøg ({{num}} af {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'Masse-sammenkobling mislykkedes. {{num}} poster ikke tilføjet.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'Masse-sammenkobling mislykkedes. {{num}} poster ikke tilføjet.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} poster blev forbundet med succes.',
    'TPL_MASSLINK_TITLE' => '{{module}} Masse-sammenkobling',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'Vælge',
    'LBL_LISTVIEW_ACTIONS' => 'Handlinger',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'Vælg alle poster på denne side',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'Fravælg alle poster på denne side',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} af {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => 'Indlæser {{num}} ...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'Klik for total',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'af',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'Hent antal sider',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'John',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Doe',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Mr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Kode Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => 'Log på for at få adgang til dette område.',
    'LBL_LOGOUT' => 'Log af',
    'LBL_FINISH_IMPERSONATING' => 'Afslut efterligning',
    'LBL_RESET_MFA' => 'Nulstil Multi-Factor Auth',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}, du efterliger i øjeblikket {{user}}.',
    'LBL_PROFILE' => 'Profil',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'Brevfletning',
    'LBL_MASS_UPDATE' => 'Masseopdatering',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'Vælg alle poster til masseopdatering',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'Inkluder post i masseopdatering',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'Tilføj felt',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'Fjern felt',
    'LBL_GENERATE_QUOTE' => 'Skabe tilbud',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'Der er ingen felter til rådighed for masseopdateringen',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'Deres anmodning om masse opdateringen er blevet planlagt.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'Startdato for tjeneste overskrider slutdato for tjeneste',
    'LBL_MASS_UPDATE_SUCCESS' => 'Alle poster er blevet opdateret.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'Udvalgte poster blev føjet til <a href="{{listUrl}}">{{listName}}</a> målliste.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'Din anmodning om at tilføje udvalgte poster til <a href="{{listUrl}}">{{listName}}</a> målliste er blevet planlagt.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'Opdateringen vil fjerne de følgende værdier:',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'Annuler for at beholde de eksisterende værdier. Bekræft for at fjerne værdier.',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'Fravælg primær e-mail',
    'LBL_MEETINGS' => 'Møder',
    'LBL_MEETING' => 'Møde',
    'LBL_MEETING_GO_BACK' => 'Tilbage til mødet',
    'LBL_MEMBERS' => 'Medlemmer',
    'LBL_MEMBER_OF' => 'Moderselskab',
    'LBL_MODIFIED_BY_USER' => 'Ændret af bruger',
    'LBL_MODIFIED_USER' => 'Ændret af bruger',
    'LBL_MODIFIED' => 'Ændret af',
    'LBL_MODIFIED_NAME' => 'Ændret af navn',
    'LBL_MODIFIED_ID' => 'Ændret af ID',
    'LBL_MORE' => 'mere',
    'LBL_MORE_MODULES' => 'Flere moduler',
    'LBL_MORE_TABS' => 'Flere faner',
    'LBL_MULTIPLE_MODULES' => 'Flere moduler',
    'LBL_COUNT_MODULES' => '{{count}} Moduler',
    'LBL_MY_ACCOUNT' => 'Min konto',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'systemstandarden',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'bruger standardindstilling',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'brugerkonto',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'gruppe-konto',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'Navn',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Opret',
    'LBL_NEW_BUTTON_TITLE' => 'Opret [Alt+N]',
    'LBL_NEXT_BUTTON_LABEL' => 'Næste',
    'LBL_NOTES' => 'Noter',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Åbn alt',
    'LBL_OPENALL_BUTTON_TITLE' => 'Åbn alt [Alt+O]',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Åbn til:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Åbn til: [Alt+T]',
    'LBL_OPEN_IN_NEW_TAB' => 'Åbn i Ny fane',
    'LBL_OPPORTUNITIES' => 'Salgsmuligheder',
    'LBL_OPPORTUNITY_NAME' => 'Salgsmuligheds navn',
    'LBL_OPPORTUNITY' => 'Salgsmulighed',
    'LBL_OR' => 'ELLER',
    'LBL_LOWER_OR' => 'eller',
    'LBL_PANEL_ASSIGNMENT' => 'Andet',
    'LBL_PANEL_ADVANCED' => 'Flere oplysninger',
    'LBL_PANEL_BODY' => 'Oversigt',
    'LBL_PARENT_TYPE' => 'Overordnet type',
    'LBL_RELATED_TYPE' => 'Relateret Type',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'Fase',
    'LBL_PICTURE_FILE' => 'Billede',
    'LBL_POSTAL_CODE' => 'Postnummer:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'Primær adresse, by:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'Primær adresse, land:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'Primær adresse, postnummer:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Primær adresse, stat:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Primær adresse, gade 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Primær adresse, gade 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Primær adresse, gade:',
    'LBL_PRIMARY_ADDRESS' => 'Primær adresse:',

    'LBL_BILLING_STREET' => 'Vej:',
    'LBL_SHIPPING_STREET' => 'Vej:',

    'LBL_PRODUCT_BUNDLES' => 'Produkt-pakkeløsninger',
    'LBL_PRODUCTS' => 'Produkter',
    'LBL_PROJECT_TASKS' => 'Projektopgaver',
    'LBL_PRODUCT_TEMPLATES' => 'Produkt Skabeloner',
    'LBL_PROJECTS' => 'Projekter',
    'LBL_PROSPECTS' => 'Mål',
    'LBL_QUICK_CREATE_MENU' => 'Quick Opret Menu',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Opret slagsmulighed fra tilbud',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Opret slagsmulighed fra tilbud [Alt+O]',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'Opretter salgsmulighed ...',
    'LBL_QUOTES_SHIP_TO' => 'Lever tilbud til',
    'LBL_QUOTES' => 'Tilbud',

    'LBL_FORECAST_WORKSHEETS' => 'Prognose regneark',
    'LBL_FORECAST_WORKSHEET' => 'Prognose regneark',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'Inviter',
    'LBL_INVITED' => 'Inviterte',
    'LBL_RECOMMENDED_INVITES' => 'Anbefalte invitasjoner',
    'LBL_INSTANCES' => 'Instanser',
    'LBL_YOUR_INSTANCES' => 'Deres forekomster',
    'LBL_INSTANCE_USERS' => 'Instans brugere',
    'LBL_SWITCH_INSTANCE' => 'Skift til denne instans',
    'LBL_LAST_LOGIN' => 'sidste login',
    'LBL_ENTER_EMAIL' => 'Indtast inviteredes email...',
    'LBL_INSTANCE_IN_USE' => 'Instans i brug',
    'LBL_INSTANCE_ACTIVE' => 'Du bruger allerede denne instans!',
    'LBL_INSTANCE_INVITE_SENT' => 'Invitation sendt til',
    'LBL_INSTANCE_SWITCH_FAILED' => 'Det lykkedes ikke at skifte instanser',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'Påmindelser',
    'LBL_REMINDERS_OVERDUE' => 'Forfaldne',
    'LBL_REMINDERS_UPCOMING' => 'Kommende',
    'LBL_REMINDERS_NONE_FOUND' => 'Ingen påmindelser fundet.',
    'LBL_REMINDERS_FINISHED' => 'Afsluttet!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'Salgsmulighed metrics',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'Sweet Spot Configuration Panel',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'Hotkeys',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'Failed to update configuration preferences: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'Sweet Spot Action',
    'LBL_SWEETSPOT_KEY' => 'Nøgleord',
    'LBL_SWEETSPOT_REMOVE' => 'Fjern handling',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'Hotkeys',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'Handlinger',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'Poster',
    'LBL_SWEETSPOT_THEME' => 'Tema',
    'LBL_SWEETSPOT_THEME_SELECT' => 'Vælg tema',

    'LBL_RELATED' => 'Relateret',
    'LBL_RELATED_INFORMATION' => 'Relaterede oplysninger',
    'LBL_RELATED_RECORDS' => 'Relateret {{module}}',
    'LBL_REPORTS_TO' => 'Rapporterer til',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'Angiver obligatorisk felt',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'Udført',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Gem som',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Gem som [Alt+A]',
    'LBL_FULL_FORM_BUTTON_KEY' => 'F',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Hele formularen',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Hele formularen [Alt+F]',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Gem og opret ny',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Gem og opret ny [Alt+V]',
    'LBL_SAVE_OBJECT' => 'Gem {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Søg',
    'LBL_SEARCH_BUTTON_TITLE' => 'Søg [Alt+Q]',
    'LBL_SEARCH' => 'Søg',
    'LBL_SEARCH_TIPS' => 'Tryk på knappen Søg eller klik på Enter for at få et nøjagtigt match.',
    'LBL_SEARCH_TIPS_2' => 'Tryk på knappen Søg eller klik på Enter for at få et nøjagtigt match',
    'LBL_SEARCH_MORE' => 'mere',
    'LBL_SEE_ALL' => 'Se alt',
    'LBL_SEARCH_LOAD_MORE' => 'INDLÆS FLERE',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'Forkert fil-format, kun billedfiler kan oploades.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'Billedformat {0} er ikke længere supporteret.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Vælg',
    'LBL_SELECT_BUTTON_TITLE' => 'Vælg [Alt+T]',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'Tilføj team',
    'LBL_SELECT_TEAMS_TITLE' => 'Tilføj team [Alt+Z]',
    'LBL_SELECT_APPEND_TEAMS' => 'Tilføje Team(s)',
    'LBL_SELECT_APPEND_VALUES' => 'Tilføje værdier',
    'LBL_SELECT_APPEND_TAGS' => 'Tilføj tag(s)',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Gennemse dokumenter',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Gennemse dokumenter [Alt+B]',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Vælg kontakt',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Vælg kontakt [Alt+T]',
    'LBL_GRID_SELECTED_FILE' => 'valgt fil',
    'LBL_GRID_SELECTED_FILES' => 'valgte filer',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Vælg fra rapporter',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Vælg rapporter',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Vælg bruger',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Vælg bruger [Alt+U]',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'Slet valg',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'Slet valg',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'Slet valg',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'Slet valg',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'Vælg fil',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'Vælg fil',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'Ryd fil',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'Ryd fil',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'Vælg bruger',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'Vælg bruger',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'Ryd bruger',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'Ryd bruger',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'Vælg virksomhed',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'Vælg virksomhed',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'Ryd konto',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'Ryd konto',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'Vælg kampagne',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'Vælg kampagne',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'Ryd kampagne',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'Ryd kampagne',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'Vælg kontakt',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'Vælg kontakt',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'Ryd kontakt',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'Ryd kontakt',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'Vælg team',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'Vælg team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'Ryd team',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'Ryd team',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Ressourcer brugt til at konstruere denne side "forespørgsler, filer"',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'sekunder.',
    'LBL_SERVER_RESPONSE_TIME' => 'Serverens svartid:',
    'LBL_SERVER_MEMORY_BYTES' => 'bytes',
    'LBL_SERVER_MEMORY_USAGE' => 'Server hukommelsesforbrug: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'Forbrug: - modul: {0} - handling: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'Server top hukommelsesforbrug: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'Leveringsmodtager',
    'LBL_SHIP_TO_CONTACT' => 'Leveringsmodtagers kontakt',
    'LBL_SHIPPING_ADDRESS' => 'Leveringsadresse:',
    'LBL_SHORTCUTS' => 'Genveje',
    'LBL_SHOW' => 'Vis',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'Tilstand:',
    'LBL_STATUS_UPDATED' => 'Din status for denne begivenhed er blevet opdateret!',
    'LBL_STATUS_NOT_UPDATED' => 'Din status for denne begivenhed er ikke blevet opdateret.',
    'LBL_STATUS' => 'Status:',
    'LBL_STREET' => 'Gade',
    'LBL_SUBJECT' => 'Emne',

    'LBL_INBOUNDEMAIL_ID' => 'ID for indgående e-mail',
    'LBL_EAMP_ID' => 'Godkendelse token-id',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'Alle rettigheder forbeholdt. <br />SugarCRM, Sugar og 3D-terning er registrerede varemærker af SugarCRM Inc. ' .
        'Alle andre firma- og produktnavne, som er anvendt eller optræder i dette produkt kan være varemærker tilhørende de ' .
        'respektive selskaber, som de er forbundet med.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'Planlagt job afsluttet',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'Det planlagte Job har kørt med succes',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'Indtægt linjeposter nu aktiveret i dit Sugar eksempel',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'Indtægt linjeposter er nu aktiveret i dit Sugar eksempel, og alle eksisterende mulighedsdata er blevet behandlet. Dit eksempel er nu klar til at blive brugt med indtægt linjeposter. For yderligere information om de ændringer, der er foretaget, henvises til {{doc_url}}.

Med venlig hilsen, SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'Prognosemodul er nu klar til brug med muligheder i dit Sugar eksempel',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'Prognosemodul i dit Sugar eksempel er nu tilgængeligt til brug med muligheder. Alle tidligere indtægt linjepostprognose dannede data er blevet fjernet, og eksemplet er klar til prognoser, der skal oprettes og engageret med muligheder. For yderligere information om de ændringer, der er foretaget, henvises til {{doc_url}}.

Med venlig hilsen, SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'Indtægt linjeposter er nu deaktiveret i dit Sugar eksempel',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'Indtægt linjeposter nu deaktiveret i dit Sugar eksempel, og alle eksisterende indtægt linjepost data er blevet behandlet. Dit eksempel er nu klart til at blive brugt med muligheder. For yderligere information om de ændringer, der er foretaget, henvises til {{doc_url}}.

Med venlig hilsen, SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'Muligheder konfiguration dokumentation',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'Log ind',
    'LBL_LOGIN_WELCOME_TO' => 'Velkommen til',
    'LBL_LOGIN_OPTIONS' => 'Indstillinger',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'Glemt adgangskode?',
    'LBL_LOGIN_SUBMIT' => 'Indsend',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'For mange mislykkede log ind forsøg.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'Du kan prøve at logge ind igen om',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'dage.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 'h.',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'min.',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'sek.',
    'LBL_LOGIN_ADMIN_CALL' => 'Kontakt systemadministratoren.',
    'LBL_LOGIN_USERNAME' => 'Brugernavn:',
    'LBL_LOGIN_PASSWORD' => 'Adgangskode',
    'LBL_LOGGED_OUT' => 'Du er blevet logget ud.',
    'LBL_LOGIN_FORM_LABEL' => 'Vis login-formular',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'Gå tilbage til login',
    'LBL_LOGIN_INACTIVE_USER' => 'Inaktiv bruger',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'Portalen eller gruppebruger kan ikke logge ind.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'Startside',
    'LBL_SYNC' => 'Synkroniser',
    'LBL_TASKS' => 'Opgaver',
    'LBL_TEAMS_LINK' => 'Team',
    'LBL_THEME_COLOR' => 'Farve',
    'LBL_THEME_FONT' => 'Skrifttype',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'Planlæg møde',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'Planlæg møde',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'Arkivér e-mail',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'Arkivér e-mail [Alt+K]',
    'LBL_UNAUTH_ADMIN' => 'Uautoriseret adgang til administration',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Fortryd sletning',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Fortryd sletning [Alt+D]',
    'LBL_UNDELETE_BUTTON' => 'Fortryd sletning',
    'LBL_UNDELETE' => 'Fortryd sletning',
    'LBL_UNSYNC' => 'Fortryd synkronisering',
    'LBL_UPDATE' => 'Opdater',
    'LBL_UPDATES' => 'Opdateringer',
    'LBL_USER_LIST' => 'Brugerliste',
    'LBL_USER_MENU' => 'Brugermenu',
    'LBL_USERS_SYNC' => 'Brugersynkronisering',
    'LBL_USERS' => 'Brugere',
    'LBL_USER' => 'Bruger',
    'LBL_CURRENT_USER' => 'Nuværende bruger',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'Søger efter eksisterende e-mail-post...',
    'LBL_VERIFY_PORTAL_NAME' => 'Søger efter eksisterende portalnavn...',
    'LBL_VIEW_IMAGE' => 'Vis',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'Udskriv som PDF',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'Udskriv som PDF [Alt+P]',

    'LBL_KBDOCUMENTS' => 'Videnbase',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'Om',
    'LNK_ADVANCED_SEARCH' => 'Avanceret søgning',
    'LNK_BASIC_SEARCH' => 'Grundlæggende søgning',
    'LNK_SEARCH_NO_RESULTS' => 'Ingen søgeresultater fundet.',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'Vis alle resultater',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'Vis alle',
    'LNK_CLOSE' => 'luk',
    'LBL_MODIFY_CURRENT_SEARCH' => 'Rediger aktuel søgning',
    'LNK_SAVED_VIEWS' => 'Layoutindstillinger',
    'LNK_DELETE_ALL' => 'del alt',
    'LNK_DELETE' => 'del',
    'LNK_EDIT' => 'rediger',
    'LNK_VIEW' => 'Vis',
    'LNK_GET_LATEST' => 'Få nyeste',
    'LNK_GET_LATEST_TOOLTIP' => 'Erstat med nyeste version',
    'LNK_HELP' => 'Hjælp',
    'LNK_CREATE' => 'Opret',
    'LNK_CREATE_WHEN_EMPTY' => 'Opret post nu.',
    'LNK_LIST_END' => 'Slut',
    'LNK_LIST_NEXT' => 'Næste',
    'LNK_LIST_PREVIOUS' => 'Foregående',
    'LNK_LIST_RETURN' => 'Retur til liste',
    'LNK_LIST_START' => 'Start',
    'LNK_LOAD_SIGNED' => 'Signer',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'Erstat med signeret dokument',
    'LNK_PRINT' => 'Udskriv',
    'LNK_BACKTOTOP' => 'Tilbage til toppen',
    'LNK_REMOVE' => 'fjern',
    'LNK_RESUME' => 'Genoptag',
    'LNK_VIEW_CHANGE_LOG' => 'Se revisionslog',
    'TPL_AUDIT_LOG_TITLE' => 'Revisionslog for {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'Klik for at se revisionslog for e-mails',
    'LBL_NO_SEARCH_RESULTS' => 'Ingen resultater fundet for din søgning',
    'NTC_CLICK_BACK' => 'Klik på browserens tilbage-knap, og ret fejlen.',
    'NTC_DATE_FORMAT' => '"åååå-mm-dd"',
    'NTC_DATE_TIME_FORMAT' => '"åååå-mm-dd 24:00"',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'Er du sikker på, at du vil slette den eller de valgte poster?',
    'NTC_TEMPLATE_IS_USED' => 'Skabelonen bruges i mindst én e-mail-markedsføringspost. Er du sikker på, at du vil slette den?',
    'NTC_TEMPLATES_IS_USED' => "Følgende skabeloner bruges i e-mail-markedsføringsposter. Er du sikker på, at du vil slette dem?",
    'NTC_DELETE_CONFIRMATION' => 'Er du sikker på, at du vil slette denne post?',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'Er du sikker på du vil slette {0}?',
    'LBL_METRIC_DELETE_WARNING' => 'Alle brugere, som denne effektivitetsfane er blevet delt med, vil også miste adgangen.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'Er du sikker på, at du vil slette',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'Er du sikker på, du vil opdatere',
    'NTC_DELETE_SELECTED_RECORDS' => 'valgte poster?',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'Dette filter vil blive fjernet fra alle visninger; dette kan omfatte data konfiguration til dashlets. Er du sikker på du vil slette dette filter?',
    'TPL_DELETE_FILTER_SUCCESS' => 'Du slettede filtret {{name}}.',
    'NTC_DELETE_SUCCESS' => 'Du slettede den {0}.',
    'NTC_UNLINK_CONFIRMATION' => 'Er du sikker på du vil fjerne linket til denne post?',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'Er du sikker på du vil fjerne linket til {0}?',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'Er du sikker på, at du vil fjerne linket til {0}? Dette fjerner dem også fra sagens primære kontaktfelt.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => '{0} kan ikke fjerne linket, fordi de er den primære kontaktperson i denne sag. Opdater feltet Primær kontakt, før du fjerner linket til denne post.',
    'NTC_UNLINK_SUCCESS' => 'Du har fjernet linket til {0}.',
    'NTC_LOGIN_MESSAGE' => 'Indtast dit brugernavn og din adgangskode:',
    'NTC_NO_ITEMS_DISPLAY' => 'ingen',
    'NTC_REMOVE_CONFIRMATION' => 'Er du sikker på, at du vil fjerne denne relation?',
    'NTC_REQUIRED' => 'Angiver obligatorisk felt',
    'NTC_SUPPORT_SUGARCRM' => 'Støt SugarCRM open source-projektet med en donation via PayPal - det er hurtigt, gratis og sikkert!',
    'NTC_TIME_FORMAT' => '"24:00"',
    'NTC_WELCOME' => 'Velkommen',
    'NTC_YEAR_FORMAT' => '"åååå"',
    'LOGIN_LOGO_ERROR' => 'Erstat SugarCRM-logoerne.',
    'FATAL_LICENSE_ALTERED' => 'Din licens er blevet ændret siden sidste gang den blev valideret.',
    'ERROR_FULLY_EXPIRED' => "Din virksomheds licens til SugarCRM er udløbet for mere end 30 dage siden og skal bringes ajour. Kun administratorer må logge på.",
    'ERROR_LICENSE_EXPIRED' => "Din virksomheds licens til SugarCRM skal opdateres. Kun administratorer må logge på.",
    'WARN_LICENSE_EXPIRED' => "Din virksomheds licens til SugarCRM udløber snart.",
    'ERROR_LICENSE_VALIDATION' => "Din virksomheds licens til SugarCRM skal valideres. Kun administratorer må logge på.",
    'WARN_LICENSE_VALIDATION' => "Din virksomheds licens til SugarCRM skal valideres snart.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => 'Advarsel: Din browser er IE kompatibilitetsvisning, som ikke understøttes.',
    'WARN_LICENSE_SEATS' => 'Advarsel: Antallet af aktive brugere er allerede det maksimale antal tilladte licenser.',
    'WARN_LICENSE_SEATS_MAXED' => 'Advarsel: Antallet af aktive brugere overstiger det maksimale antal tilladte licenser.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'Antal aktive brugere overstiger licensgrænsen. Kontakt din administrator.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'Kun admins kan logge ind.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'Brugerlicensgrænsen er nået. Kun eksisterende brugere kan logge ind.',
    'WARN_ONLY_ADMINS' => 'Kun admins kan logge ind.',
    'WARN_UNSAVED_CHANGES' => 'Du er ved at forlade denne post uden at gemme eventuelle ændringer, du måtte have foretaget til posten. Er du sikker på du vil navigere væk fra denne post?',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Opdatering af browseren lukker automatisk alle SugarLive-opkald eller chat-sessioner, du har åbnet, og alle ikke-gemte ændringer går tabt. Ønsker du at fortsætte?',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'Du har ikke-gemte ændringer. Er du sikker på du vil forlade siden og kassere ændringerne?',
    'LBL_MFA_RESET_CONFIRMATION' => 'Er du sikker på, at du vil nulstille din <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">multifaktorgodkendelse</a>?
Hvis du udfører denne handling, logges du straks ud, og du skal godkende ved hjælp af godkendelsesappen næste gang du logger ind.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'Bekræft og log af',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'En eller flere dashlets har ugemte ændringer. Er du sikker på, du vil lukke skuffen?',
    'LBL_NAVIGATE_TO_REPORTS' => 'Du flytter til Reports modulet. Dine ændringer til dashlet vil ikke blive gemt. Fortsæt?',
    'ERROR_NO_RECORD' => 'Fejl ved hentning af post. Denne post kan blive slettet, eller du har ikke tilladelse til at se den.',
    'ERROR_TYPE_NOT_VALID' => 'Fejl. Denne type er ikke gyldig.',
    'ERROR_MAX_FIELD_LENGTH' => 'Fejl. Den maksimale længde af dette felt er {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'Fejl. Den min længde af dette felt er {{this}}.',
    'ERROR_EMAIL' => 'Fejl. Ugyldig e-mail-adresse: {{#each this}}{{this}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'Error. Mindst en primær adresse skal indstilles.',
    'ERROR_DUPLICATE_EMAIL' => 'Error. Duplicate Email Adresse: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'Fejl. Dette felt er påkrævet.',
    'ERROR_MINVALUE' => 'Fejl. Den mindste værdi af dette felt er {{this}}.',
    'ERROR_MAXVALUE' => 'Fejl. Den maksimale værdi af dette felt er {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'Fejl. Værdien af dette felt skal være større end {{this}}.',
    'ERROR_IS_LESS_THAN' => 'Fejl. Værdien af dette felt skal være mindre end {{this}}.',
    'ERROR_DATETIME' => 'Error. Dette felt kræver en gyldig dato.',
    'ERROR_IS_BEFORE' => 'Error. Datoen for dette felt kan ikke være efter datoen for {{this}} felt.',
    'ERROR_IS_AFTER' => 'Error. Datoen for dette felt kan ikke være før datoen for {{this}} felt.',
    'ERROR_TIME_IS_BEFORE' => 'Fejl. Dette felts tidspunkt skal være før tidspunktet for {{this}} felt.',
    'ERROR_TIME_IS_AFTER' => 'Fejl. Dette felts tidspunkt skal være efter tidspunktet for dette {{this}} felt.',
    'ERROR_NUMBER' => 'Error. Dette felt kræver et gyldigt nummer.',
    'ERROR_INT' => 'Fejl. Ugyldig integer.',
    'ERROR_URL' => 'Fejl. Ugyldig URL.',
    'ERROR_NO_BEAN' => 'Fjel under hentning af bean.',
    'ERROR_ACCESS_MODULE' => 'Du har ikke adgang til dette modul.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'Den vedhæftede fil er for stor.',
    'ERROR_UPLOAD_FAILED' => 'Fejl. Filen kunne ikke uploades.',
    'ERROR_UPLOAD_ACCESS_PD' => 'Du har ikke tilladelse til at oprette [procesdefinitioner] for dette modul.',
    'ERROR_UPLOAD_ACCESS_BR' => 'Du har ikke tilladelse til at oprette [forretningsregler] for dette modul.',
    'ERROR_UPLOAD_ACCESS_ET' => 'Du har ikke tilladelse til at oprette [e-mail skabeloner] for dette modul.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'Fejl. Du har indtastet et ikke-understøttet operatør.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'Fejl. Du har indtastet en ugyldig operatør.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'Fejl. Du har indtastet et ugyldigt filter.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'Importen mislykkedes. Et grupperingsfelt er delvist låst i procesdefinitionen.' .
        ' Disse felter skal låses op i procesdefinitionen for at definitionen kan importeres.',
    'ERROR_EXP_DATE_LOW' => 'Fejl. Udløbsdato kan ikke være senere end udgivelsesdato.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'Fejl. Godkendelsen kræver udgivelsesdato.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'Udgivelsesdato er tom.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'Find dubletter',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'Dobbelt check er deaktiveret i {{module}}.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'Administrer abonnementer',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'Administrer abonnementer for',
    'LBL_SUBSCRIBE' => 'Abonner',
    'LBL_UNSUBSCRIBE' => 'Afmeld',
    'LBL_CREATE_LINK_RECORD' => 'Opret og link post',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'Opret og link post',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} poster har været knyttet.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'Ingen poster at linke.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'Rapporten valgt er ikke baseret på den korrekte modul type.',
    'ERROR_EMPTY_LINK_MODULE' => 'Vælg venligst relationen først.',
    // Ajax status strings
    'LBL_LOADING' => 'Indlæser ...',
    'LBL_LOADING_NO_DOTS' => 'Indlæser ...',
    'LBL_SEARCHING' => 'Søger...',
    'LBL_SEARCH_UNDERWAY' => 'Søger',
    'LBL_SAVING_LAYOUT' => 'Gemmer layout ...',
    'LBL_SAVED_LAYOUT' => 'Layoutet er blevet gemt.',
    'LBL_SAVED' => 'Gemt',
    'LBL_SAVING' => 'Gemmer',
    'LBL_FAILED' => 'Mislykkedes!',
    'LBL_DISPLAY_COLUMNS' => 'Vis kolonner',
    'LBL_HIDE_COLUMNS' => 'Skjul kolonner',
    'LBL_SEARCH_CRITERIA' => 'Søgekriterier',
    'LBL_SAVED_VIEWS' => 'Gemte visninger',
    'LBL_PROCESSING_REQUEST' => 'Behandler...',
    'LBL_REQUEST_PROCESSED' => 'Udført',
    'LBL_AJAX_FAILURE' => 'Ajax fejl',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'Søg...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Gemte søgninger',
    'LBL_SEARCH_POPULATE_ONLY' => 'Udfør en søgning ved hjælp af søgeformularen ovenfor',
    'LBL_SEARCH_NO_RESULTS' => 'Ingen resultater fundet for',
    'LBL_SEARCH_FOR' => 'Søg efter',
    'LBL_SEARCH_FOR_MORE' => 'Søg efter mere...',
    'LBL_SEARCH_SELECT' => 'Vælg...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'Søg og vælg...',
    'LBL_SEARCH_SELECT_MODULE' => 'Vælg {{module}}...',
    'LBL_DETAILVIEW' => 'Detaljevisning',
    'LBL_LISTVIEW' => 'Listevisning',
    'LBL_EDITVIEW' => 'Rediger visning',
    'LBL_SEARCHFORM' => 'Søgeformular',
    'LBL_SAVED_SEARCH_ERROR' => 'Angiv et navn til denne visning.',
    'LBL_DISPLAY_LOG' => 'Vis log',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Sted:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Beskrivelse:',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'starter',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'Klik på OK for at se dette kald, eller klik på Annuller for at afvise denne meddelelse.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'Klik på OK for at se dette møde, eller klik på Annuller for at afvise denne meddelelse.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'Ingen resultater fundet',
    'MSG_LIST_VIEW_NO_RESULTS' => 'Ingen resultater fundet for',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'Opret som ny',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'Du har i øjeblikket ingen poster gemt. eller en nu.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'Du har i øjeblikket ingen poster gemt. en nu.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'Du kan oprette <item1> fra en <item2>. <item3> <item2> liste.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'Positiv',
    'LBL_SENTIMENT_NEUTRAL' => 'Neutral',
    'LBL_SENTIMENT_NEGATIVE' => 'Negativ',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'Ingen effektivitetsfaner opsat',
    'LBL_NO_METRIC_VISIBLE' => 'Ingen synlige faner for metrics',
    'LBL_MAKE_METRIC_VISIBLE' => 'Vælg "organiser" for at gøre faner for metrics synlige',
    'LBL_PLEASE_CONTACT_ADMIN' => 'Kontakt din administrator',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'Klik her',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Føj til mine favoritter',
    'LBL_MARK_AS_FAVORITES' => 'Markér som favorit',
    'LBL_CREATE_CONTACT' => 'Opret kontakt',
    'LBL_CREATE_NOTE' => 'Opret note',
    'LBL_CREATE_OPPORTUNITY' => 'Opret salgsmulighed',
    'LBL_SCHEDULE_CALL' => 'Planlæg opkald',
    'LBL_SCHEDULE_CALL2' => 'Opkald',
    'LBL_SCHEDULE_MEETING' => 'Planlæg møde',
    'LBL_SCHEDULE_MEETING2' => 'Møde',
    'LBL_CREATE_MESSAGE' => 'Opret meddelelse',
    'LBL_CREATE_MESSAGE2' => 'Meddelelse',
    'LBL_CREATE_TASK' => 'Opret opgave',
    'LBL_CREATE_TASK2' => 'Opgave',
    'LBL_REMOVE_FROM_FAVORITES' => 'Fjern fra mine favoritter',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'Note',
    'LBL_DOWNLOAD_ALL' => 'Hent alle',
    'LBL_DOWNLOAD_ONE' => 'Hent',
    'LBL_ATTACHMENTS' => 'Vedhæftede filer',
    'LBL_ADD_ATTACHMENT' => 'Gennemse',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Generer formular',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'Gem formularen Internettet til kundeemne',

    'LBL_PLEASE_SELECT' => 'Vælg',
    'LBL_REDIRECT_URL' => 'URL til omdirigering',
    'LBL_RELATED_CAMPAIGN' => 'Relateret kampagne',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Tilføj alle felter',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Fjern alle felter',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Kun vedhæftet fil af typen billede kan indlejres',
    'LBL_REMOVE' => 'Fjern',
    'LBL_TRAINING' => 'Support',
    'ERR_DATABASE_CONN_DROPPED' => 'Fejl ved udførelse af en forespørgsel. Din database har muligvis mistet forbindelsen. Opdater denne side. Du skal muligvis genstarte webserveren.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'Fejl indstilling {0} forhold: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'Ændret databasekontekst til',
    'ERR_MSSQL_WARNING' => 'Advarsel:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'Det lykkedes ikke at parse vCard format',
    'ERR_VCARD_FILE_MISSING' => 'vcf-fil mangler',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Advarsel! Feltet [[field]] har ikke en tilknyttet post i filen [moduleDir] vardefs.php',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Fejl: Filen [[file]] mangler. Kan ikke oprette, fordi ingen tilsvarende HTML-fil blev fundet.',
    'ERR_CANNOT_FIND_MODULE' => 'Fejl: Modulet [module] findes ikke.',
    'LBL_ALT_ADDRESS' => 'Anden adresse:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Fejl: Der er et ulige antal argumenter for elementerne &#39;nøgle&#39; og &#39;kopi&#39; i matrixen displayParams.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Mangler indeks i matrixen displayParams for:',

    'LBL_DASHLET' => 'Sugar-dashlet',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filtre',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Kun mine poster',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Titel',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Vis rækker',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'Forholde sig til aktuelle post',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'Linked felt',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'Frys første kolonne',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'Er du sikker på, at du vil fjerne denne Sugar-dashlet?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'Er du sikker på du vil fjerne rækken?',
    'LBL_MAXIMUM_OF' => 'Maksimalt av',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => 'kolonnene kan fremvises.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'Betjeningspanel',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'Mit instrumentpanel',
    'LBL_COLLAPSE_ALL' => 'Skjul alle',
    'LBL_EXPAND_ALL' => 'Udvid alle',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'Rediger',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'Vis rapport',
    'LBL_DASHLET_REFRESH_LABEL' => 'Opdater',
    'LBL_DASHLET_REMOVE_LABEL' => 'Fjern',
    'LBL_DASHLET_DROP_HERE' => 'Drop her',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'Luk',
    'LBL_DASHLET_MAXIMIZE' => 'Åbne',
    'LBL_DASHLET_CONFIGURE' => 'Konfigurer',
    'LBL_DASHLET_TOGGLE' => 'Åbn/Luk',
    'LBL_SIDEPANE_TOGGLE' => 'Åbn/luk siderude',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'Gendan standard layout',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'Der er ikke konfigureret noget dashboard',
    'LBL_CREATE_DASHBOARD_LINK' => 'Opret Dashboard',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'Hjælp',
    'LBL_HELPLET_TOGGLE' => 'Åbn/Luk',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'Moduler',
    'LBL_FACET_MODIFIED_BY_ME' => 'Modificeret af mig',
    'LBL_FACET_CREATED_BY_ME' => 'Oprettet af mig',
    'LBL_FACET_MY_FAVORITES' => 'Mine favoritter',
    'LBL_FACET_ASSIGNED_TO_ME' => 'Tildelt mig',
    'LBL_FACET_NO_DATA' => 'Ingen data for denne facet.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'Listevisning',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'Viser poster fra en bestemt modul i henhold til kriterier, du definerer.',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'Listevisning konsol',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'Oplister registre fra et bestemt modul, der er knyttet til det register, som du ser i konsollen.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'Record-visning',
    'LBL_RELATED_RECORDS' => 'Relateret {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'Viser en optagelse og muligvis tilhørende optagelser i faner.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'Grundlæggende optagelsestype',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'Dette {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'Faner',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'Grundlæggende layout-forhåndsvisning',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'Advarsel, kun {{numWord}} ({{num}}) moduler må vises i faner.' .
        'Fjern venligst en eller flere moduler, før andre tilføjes.',
    'LBL_SIX' => 'seks', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'Kommentarregister',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'Viser kommentarer til et register',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'Ingen kommentarer tilgængelige',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'Tilføj',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'Tilføj kommentar',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'Vis alle',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'Der er ingen tilgængelige data. Du har ikke tilladelse til at få adgang til disse moduler.' .
    " \nOpdater eller fjern denne dashlet.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'Mine {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'Intet register valgt til visning',
    'LBL_CONTENT_SEARCH_DASHLET' => 'Indholdssøgning Dashlet',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'Hvad kan vi hjælpe dig med i dag, {{username}}?',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'Vil du oprette en sag?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'Salgsmulighed metrics',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'Salgsmulighedsværdier for relateret konto.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'Produktkataloget Quick Picks',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'Oplister nyligt brugte varer og produkter, der er gemt som favoritter',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'Nyligt brugt',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'Favoritter',

    'LBL_DASHBOARD_CREATE' => 'Opret dashboard',
    'LBL_DASHBOARD_DUPLICATE' => 'Duplikér dashboard',
    'LBL_DASHBOARD_DELETE' => 'Slet dashboard',
    'LBL_PIN_TO_TOP' => 'Fastgør til toppen',
    'LBL_PIN_TO_BOTTOM' => 'Fastgør til bunden',
    'LBL_MANAGE_DASHBOARDS' => 'Administrer betjeningspaneler',

    'LBL_DASHBOARD_CONFIG' => 'Dashboardkonfiguration',
    'LBL_LIST_VIEW__NAME' => 'Listevisning',
    'LBL_PIPELINE_VIEW_NAME' => 'Feltvisning',
    'LBL_PIPELINE_VIEW_BTN' => 'Feltvisning',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} af {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'Feltvisning er ikke aktiveret',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'Ingen optegnelser blev fundet på dette tidspunkt.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'Resumé af sagen',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'Tidslinje',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'Noter & vedhæftede filer',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'Noter & Vedhæftede filer hører til posten',
    'LBL_DASHLET_PIPLINE_NAME' => 'Pipeline',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'Nylige Tweets - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'Ingen gemte instrumentpaneler',

    'LBL_DNB_AND' => 'og',
    'LBL_DNB_PRIM_NAME_DESC' => 'Tekst optager et navn for denne organisation',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'Besvare',
    'LBL_TWITTER_RETWEET' => 'Retweet',
    'LBL_TWITTER_FAVORITE' => 'Favorit',
    'LBL_TWITTER_FOLLOW' => 'Følg',
    'LBL_TWITTER_DESCRIPTION' => 'Se matchende twitter brugerens bio og tweets, retweet, og svare på tweets',
    'LBL_TWITTER_ID' => 'Twitter ID',
    'LBL_TWITTER_DISPLAY_ROWS' => 'Vis rækker',
    'LBL_TWITTER_MY_ACCOUNT' => 'Min konto',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Kilde Tweet:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'Læringsressourcer',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'Træning og certificering',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub-fællesskab',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'Dokumentation og support',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters-markedsplads',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'Salg per land',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'Viser salgs diagrammet efter landkort.',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'Kategorier & publicerede artikler fra videnbase',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'Vidensbase-søgning',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'Viser en søgbar træ-visning af offentliggjorte vidensbase-artikler og kategorier.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'Publicerede Arikler på andre sprog',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'Mest nyttige udgivne videnbaseartikler',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'Viser de artikler i vidensbasen, som der er mest læste og mest synes godt om',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} filtreret af {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'Anvendeligheden af artikler',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'Tilføj side',
    'LBL_LOADING_PAGE' => 'Indlæser side. Vent et øjeblik...',
    'LBL_SEARCH_RESULTS' => 'Søgeresultater',
    'LBL_SEARCH_RESULTS_FOR' => 'Søgeresultater for: ',
    'LBL_SEARCH_HELP_TITLE' => 'Bruger multiselect og gemte søgninger',
    'LBL_SEARCH_RESULTS_FOUND' => 'Søge resultater fundet',
    'LBL_SEARCH_RESULTS_TIME' => 'ms.',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'Min pipeline',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "Mit teams Pipeline",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'Prognose pipeline-diagram',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'Viser aktuelt pipeline-diagram.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'Intet billede',

    'LBL_MODULE' => 'Modul',
    'LBL_RELATIONSHIP' => 'Relation',
    'LBL_SINGULAR_LABEL' => 'Ental etiket',
    'LBL_PLURAL_LABEL' => 'Flertal etiket',
    'LBL_MODULE_DISPLAY' => 'Vis',
    'LBL_MODULE_DISPLAY_TYPE' => 'Visningstype',
    'LBL_MODULE_ICON' => 'Ikon',
    'LBL_MODULE_COLOR' => 'Farve på modulbaggrund',
    'LBL_LANGUAGE_SELECTOR' => 'Sprog',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'Modulindstillinger',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'Modulindstillinger er gemt.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Kopiér adresse fra venstre:',
    'LBL_SAVE_AND_CONTINUE' => 'Gem og fortsæt',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Multiselect-kontrolelementer</strong></p><ul><li>Klik på værdierne for at vælge en attribut.</li><li>Brug Ctrl-klik for at vælge flere. Mac-brugere anvender CMD-klik.</li><li>Hvis du vil vælge alle værdierne mellem to attributter, skal du klikke på den første værdi og derefter bruge skift-klik på den sidste værdi.</li></ul><p><strong>Avancerede søge- og layoutindstillinger</strong><br><br>Med indstillingen <b>Gemt søgning og layout</b> kan du gemme et sæt søgeparametre og/eller et brugerdefineret layout af listevisningen, så du hurtigt kan opnå de ønskede søgeresultater i fremtiden. Du kan gemme et ubegrænset antal brugerdefinerede søgninger og layout. Alle de gemte søgninger vises ved navn på listen Gemte søgninger, idet den senest indlæste gemte søgning vises øverst på listen. <br><br>Hvis du vil tilpasse layoutet Listevisning, skal du bruge felterne Skjul kolonner og Vis kolonner til at vælge, hvilke felter der skal vises i søgeresultaterne. Du kan f.eks. se eller skjule oplysninger såsom postnavn, tildelt bruger og tildelt team i søgeresultaterne. Hvis du vil føje en kolonne til listevisningen, skal du markere feltet på listen Skjul kolonner og bruge venstre pil til at flytte den til listen Vis kolonner. Hvis du vil fjerne en kolonne fra listevisningen, skal du vælge den på listen Vis kolonner og bruge højre pil til at flytte den til listen Skjul kolonner.<br><br>Hvis du gemmer layoutindstillingerne, kan du altid indlæse dem for at få vist søgeresultaterne i det brugerdefinerede layout.<br><br>Hvis du vil gemme og opdatere en søgning og/eller et layout, skal du benytte følgende fremgangsmåde:<ol><li>Angiv et navn til søgeresultaterne i feltet <b>Gem denne søgning som</b>, og klik op <b>Gem</b>. Navnet vises nu på listen Gemte søgninger ved siden af knappen <b>Ryd</b>.</li><li>Hvis du vil se en gemt søgning, skal du vælge den på listen Gemte søgninger. Søgeresultaterne vises i listevisningen.</li><li>Hvis du vil opdatere egenskaberne for en gemt søgning, skal du vælge den gemte søgning på listen, angive de nye søgekriterier og/eller layoutindstillinger i området Avanceret søgning og klikke på <b>Opdater</b> ud for <b>Rediger aktuel søgning</b>.</li><li>Hvis du vil slette en gemt søgning, skal du vælge den på listen Gemte søgninger, klikke på <b>Slet</b> ud for <b>Rediger aktuel søgning</b> og derefter klikke på <b>OK</b> for at bekræfte sletningen.</li></ol>',

    //resource management
    'ERR_QUERY_LIMIT' => 'Fejl: Forespørgselsgrænsen på $limit er nået for $module modulet.',
    'ERROR_NOTIFY_OVERRIDE' => 'Fejl: ResourceObserver->notify"" skal tilsidesættes.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'Fejl: Kan ikke oprette overvågning, fordi metadatafilen er tom, eller filen ikke findes.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'Fejl: Der er konfigureret nogen overvågning til det ønskede navn',
    'ERR_UNDEFINED_METRIC' => 'Fejl: Kunne ikke angive værdien for udefineret metrikværdi',
    'ERR_STORE_FILE_MISSING' => 'Fejl: Kunne ikke finde Store-implementeringsfilen',

    'LBL_MONITOR_ID' => 'Overvågnings-ID',
    'LBL_TEAM_ID' => 'Team-ID',
    'LBL_SELECT_MODULE' => 'Vælg et modul:',
    'LBL_USER_ID' => 'Bruger-ID',
    'LBL_MODULE_NAME' => 'Modulnavn',
    'LBL_MODULE_ALL' => 'Alle',
    'LBL_ITEM_ID' => 'Post-ID',
    'LBL_ITEM_SUMMARY' => 'Postoversigt',
    'LBL_ACTION' => 'Handling',
    'LBL_SESSION_ID' => 'Sessions-ID',
    'LBL_BREADCRUMBSTACK_CREATED' => 'BreadCrumbStack opretter for bruger-id {0}',
    'LBL_VISIBLE' => 'Posten er synlig',
    'LBL_DATE_LAST_ACTION' => 'Dato for seneste handling',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL-tekst',
    'LBL_QUERY_HASH' => 'SQL-hash',
    'LBL_SEC_TOTAL' => 'Samlede antal sekunder',
    'LBL_SEC_AVG' => 'Gennemsnitligt antal sekunder',
    'LBL_RUN_COUNT' => 'Antal forespørgsler',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'Klientens IP-adresse',
    'LBL_DATE_START' => 'Startdato',
    'LBL_ACTIVE' => 'Session aktiv',
    'LBL_ROUNDTRIPS' => 'Antal handlinger',
    'LBL_SECONDS' => 'Sekunder aktiv',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'Database tur-retur',
    'LBL_FILES_OPENED' => 'Filer åbnet',
    'LBL_MEMORY_USAGE' => 'Hukommelsesbrug "byte"',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'Indlæser Twitter Connector...',
    'LBL_TWITTER_DATA_EMPTY' => 'Ingen data tilgængelig fra Twitter',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Sugar plug-in til Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'Integrér Sugar e-mail og kalender information med Microsoft Outlook.',
    'LBL_PLUGIN_WORD_NAME' => 'Sugar plug-in til Word',
    'LBL_PLUGIN_WORD_DESC' => 'Automatisk udfylde oplysninger fra SugarCRM i formular-breve, direct mails og andre Microsoft-dokumenter.',
    'LBL_PLUGIN_EXCEL_NAME' => 'Sugar plug-in til Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'Integrér Sugar med regneark for at få bedre analyse af nøgletal.',
    'LBL_PLUGINS_TITLE' => 'Sugar plug-in til  Microsoft OfficeTM',
    'LBL_PLUGINS_DESC' => 'Læs om plug-in funktionerne i <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">Plug-In dokumentationen</a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Sugar Plug-ins for Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'Sugar Plug-in for Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'Integrer Sugar med Lotus Notes.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'er ikke før',
    'MSG_IS_MORE_THAN' => 'er mere end',
    'MSG_IS_LESS_THAN' => 'er mindre end',
    'MSG_SHOULD_BE' => 'skal være',
    'MSG_OR_GREATER' => 'eller mere',
    'MSG_EXCEEDS_MAXLEN' => 'overstiger den angivne max længde ',

    'LBL_PORTAL_WELCOME_TITLE' => 'Velkommen til Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal er en ramme, hvor kunderne kan få vist sager, fejl og nyhedsbreve mv. i realtid. Dette er en grænseflade, der vender udad mod Sugar, som kan installeres på ethvert websted. Hold dig orienteret om flere selvbetjeningsfunktioner for kunder som f.eks. Projektstyring og Fora i vores fremtidige udgivelser.',
    'LBL_LIST' => 'Liste',
    'LBL_CREATE_CASE' => 'Opret sag',
    'LBL_CREATE_BUG' => 'Opret fejl',
    'LBL_NO_RECORDS_FOUND' => '- 0 poster blev fundet -',

    'DATA_TYPE_DUE' => 'Forfald:',
    'DATA_TYPE_START' => 'Start:',
    'DATA_TYPE_SENT' => 'Sendt:',
    'DATA_TYPE_MODIFIED' => 'Ændret:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'Antal',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'objektbillede',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'Vælg dato',

    'LBL_VALIDATE_RANGE' => 'er ikke inden for det gyldige område',
    'LBL_VALIDATE_URL' => 'er ikke en gyldig webadresse',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'Alle',

    'LBL_OPERATOR_IN_TEXT' => 'er en af følgende:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'er ikke en af følgende:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'Fejl: Antallet af matrixer i bean-parameteren svarer ikke til antallet af matrixer i resultaterne.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'Fejl: Tilknytningspost til modul mangler.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'Fejl: Data kan ikke hentes til {0}-forbindelse. Der er muligvis ikke adgang til tjenesten i øjeblikket, eller konfigurationsindstillingerne kan være ugyldige. Forbindelsesfejlmeddelelse: "{1}".',
    'ERROR_CONNECTOR_CONFIGURE' => 'Kan ikke hente data. Tjenesten kan i øjeblikket være utilgængelige eller konfigurationsindstillingerne kan være ugyldigt.',
    'LBL_CONNECT_TWITTER' => 'Opret forbindelse til Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'Kan ikke finde gyldig timeline for Twitter ID:',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'Konfigurer Twitter Konnektor',
    'LBL_CONNECT_TEST_FAIL' => 'Fejl: Indstillingerne for connector configuration kan være ugyldigt. Kontakt din administrator.',
    'LBL_CONFIGURE_TWITTER' => 'kt din administrator for at konfigurere Twitter',
    'LBL_MERGE_CONNECTORS' => 'Hent data',
    'LBL_NO_DATA_AVAILABLE' => 'Ingen tilgængelige data.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'Er du sikker på, at du vil deaktivere integration af forbindelse for dette modul?',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'Det lykkedes ikke at oprette forbindelse til Elastic server',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'Du kan desværre ikke slette det globale team. Afbryder',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'Dettee private team [{0}] kan ikke slettes før bruger [{1}] slettes.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => '"Hej. Flash er enten slået fra, eller du har en gammel version af Adobes Flash Player. <a href=""http://www.adobe.com/go/getflashplayer/"">Hent den nyeste Flash Player</a>, eller slå Flash til."',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'Navn',
    'LBL_COLLECTION_PRIMARY' => 'Primær',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'Tomt obligatorisk felt',
    'LBL_COLLECTION_EXACT' => 'Nøjagtig',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'Du kan få den optimale oplevelse med IIS/FastCGI sapi ved at angive fastcgi.logging til 0 i filen php.ini.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'Tildelt til',
    'LBL_DESCRIPTION' => 'Beskrivelse',
    'LBL_PRIMARY_CONTACT_NAME' => 'Primær kontakt',
    'LBL_PRIMARY_CONTACT_ID' => 'Primær kontakt ID',

    'LBL_NONE' => '-ingen-',
    'LBL_YESTERDAY' => 'i går',
    'LBL_TODAY' => 'i dag',
    'LBL_TOMORROW' => 'i morgen',
    'LBL_NEXT_WEEK' => 'næste uge',
    'LBL_NEXT_MONDAY' => 'næste mandag',
    'LBL_NEXT_FRIDAY' => 'næste fredag',
    'LBL_TWO_WEEKS' => '2 uger',
    'LBL_NEXT_MONTH' => 'næste måned',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'første dag i næste måned',
    'LBL_THREE_MONTHS' => '3 måneder',
    'LBL_SIXMONTHS' => '6 måneder',
    'LBL_NEXT_YEAR' => 'næste år',
    'LBL_FILTERED' => 'Filtreret',

    //Datetimecombo fields
    'LBL_HOURS' => 'Timer',
    'LBL_MINUTES' => 'Minutter',
    'LBL_MERIDIEM' => 'Meridiem',
    'LBL_DATE' => 'Dato',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'Automatisk opdatering',

    'LBL_DURATION_DAY' => 'dag',
    'LBL_DURATION_HOUR' => 'time',
    'LBL_DURATION_MINUTE' => 'minut',
    'LBL_DURATION_DAYS' => 'dage',
    'LBL_DURATION_HOURS' => 'timer',
    'LBL_DURATION_MINUTES' => 'minutter',
    'LBL_DURATION_SECONDS' => 'sekunder',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'Vælg måned',
    'LBL_ENTER_YEAR' => 'Indtast år',
    'LBL_ENTER_VALID_YEAR' => 'Indtast venligst et gyldigt år',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'Indtast venligst et numerisk amerikansk telefonnummer, herunder områdenummeret.',
    'LBL_CCP_NOT_INITIATED' => 'Der forsøges at ringe ved hjælp af CCP, mens agenten ikke er logget på.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'Kan ikke foretage opkald via CCP.',
    'LBL_CCP_DIALING_ERROR' => 'Dette opkald kan ikke gennemføres som forventet.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'Luk venligst alle chat-sessions i SugarLive, før du foretager et udgående opkald.',

    //File write error label
    'ERR_FILE_WRITE' => 'Fejl: Kunne ikke skrive filen {0}. Tjek venligst system og webserver tilladelser.',
    'ERR_FILE_NOT_FOUND' => 'Fejl: Kunne ikke indlæse filen {0}. Tjek venligst system og webserver tilladelser.',

    'LBL_AND' => 'Og',
    'LBL_BEFORE' => 'Før',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'Upload fra din computer',
    'LBL_SEARCH_EXTERNAL_API' => 'Fil på ekstern kilde',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'Upload til ekstern kilde',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'Link fra ekstern kilde',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'Sikkerhed',
    'LBL_SHARE_PRIVATE' => 'Privat',
    'LBL_SHARE_COMPANY' => 'Firma',
    'LBL_SHARE_LINKABLE' => 'Linkbart',
    'LBL_SHARE_PUBLIC' => 'Offentlige',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS Feed',
    'LBL_RSS_RECORDS_FOUND' => 'post(er) fundet',
    'ERR_RSS_INVALID_INPUT' => 'RSS er ikke en gyldig input_type',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS er ikke et gyldigt response_type for denne metode',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs understøtter ikke filformatet, du har angivet.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'Tom',
    'LBL_IS_EMPTY' => 'Er tom',
    'LBL_IS_NOT_EMPTY' => 'Er ikke tom',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '"Dette er et eksempel på en import fil, der viser et eksempel på indholdet af en fil, der er klar til import." "Filen er en kommasepareret .csv-fil, med dobbelt anførselstegn som felt-qualifier." "Den øverste række er en kolonneoverskriftsrække som indeholder feltetiketter som du ville se dem i applikationen." "Disse etiketter bruges til at mappe data i filen til felterne i applikationen." "Bemærk: Database navne kan også anvendes i overskriftsrækken. Dette er nyttigt, når du bruger phpMyAdmin eller ande database værktøj til at skabe en eksporteret liste over data, der skal importeres" "Kolonne rækkefølge er ikke kritisk, da importen matcher data til de relevante felter baseret på kolonneoverskriften." "For at kunne bruge denne fil som en skabelon, skal du gøre følgende:" "1. ​​Fjern rækker med eksempel data" "2. Fjern den hjælpetekst du læser lige nu." "3. Indsæt dine egne data i de relevante rækker og kolonner" "4. Gem filen på en kendt placering på dit system" "5. Klik på Import indstillinger i menuen Handlinger i applikationen og vælg den fil der skal uploades"',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'Tildelt bruger-id',
    'LBL_EXPORT_CREATED_BY' => 'Oprettet af id',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'Ændret af id',
    'LBL_EXPORT_REPORTS_TO_ID' => 'Rapporterer til ID:',
    'LBL_EXPORT_TEAM_ID' => 'Team-ID',
    'LBL_EXPORT_TEAM_SET_ID' => 'Teamsæt-ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'Tildelt bruger',
    'LBL_EXPORT_FULL_NAME' => 'Fuldt navn',
    'LBL_EXPORT_TEAM_NAME' => 'Teams',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'Navigerer...',

    'LBL_PENDING_NOTIFICATIONS' => 'Meddelelser',
    'LBL_ALT_ADD_TEAM_ROW' => 'Tilføj ny team række',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'Fjern team',
    'LBL_ALT_SPOT_SEARCH' => 'Spot søgning',
    'LBL_ALT_NOT_SORTED' => 'Ikke sorteret',
    'LBL_ALT_SORT_DESC' => 'Sorteret faldende',
    'LBL_ALT_SORT_ASC' => 'Sorteret stigende',
    'LBL_ALT_SORTABLE' => 'Sorterbare',
    'LBL_ALT_NOT_SORTABLE' => 'Ikke sorterbare',
    'LBL_ALT_SORT' => 'Sortér',
    'LBL_ALT_SHOW_OPTIONS' => 'Vis valgmuligheder',
    'LBL_ALT_HIDE_OPTIONS' => 'Skjul valgmuligheder',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'Flyt den valgte post til listen til venstre',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'Flyt valgte post til listen til højre',
    'LBL_ALT_MOVE_COLUMN_UP' => 'Flyt den valgte post op i den viste liste',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'Flyt den valgte post ned i den viste liste',
    'LBL_ALT_INFO' => 'Information',
    'MSG_DUPLICATE' => 'Den {0} post, du er ved at oprette, kan være en dublet af en {0} post, der allerede findes. {1} poster, som indeholder lignende navne, er angivet nedenfor.<br>Klik på Opret {1} for at fortsætte med at oprette denne nye {0}, eller vælg en eksisterende {0} nedenfor.',
    'MSG_SHOW_DUPLICATES' => 'Den {0} post, du er ved at oprette, kan være en dublet af en {0} post, der allerede findes. {1} poster, som indeholder lignende navne, er angivet nedenfor.<br>Klik på Gem for at fortsætte med at oprette denne nye {0}, eller klik på Annuller for at vende tilbage til modulet uden at oprette {0}.',
    'LBL_EMAIL_TITLE' => 'e-mail adresse',
    'LBL_EMAIL_OPT_TITLE' => 'opted out e-mail adresse',
    'LBL_EMAIL_INV_TITLE' => 'ugyldig e-mail adresse',
    'LBL_EMAIL_PRIM_TITLE' => 'primær e-mail adresse',
    'LBL_SELECT_ALL_TITLE' => 'Vælg alle',
    'LBL_SELECT_THIS_ROW_TITLE' => 'Vælg denne række',
    'LBL_TEAM_SELECTED_TITLE' => 'Valgt team',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'Vælg for at gøre denne til primær team',
    'LBL_TEAM_TBSELECTED_TITLE' => 'Team markeret som valgt team-baseret ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'Marker dette hold som valgt team-baseret',
    'LBL_SEARCH_AND_SELECT' => 'Søg, og vælg {{module}}',
    'TPL_SEARCH_AND_ADD' => 'Søg og tilføj {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'FEJL: Der opstod en fejl under upload. Fejlkode: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'FEJL: Der opstod en fejl under upload. Fejlkode: {0} - {1}. upload_maxsize er {2}',
    'UPLOAD_ERROR_HOME_TEXT' => 'FEJL: Der opstod en fejl i din upload, du bedes kontakte en administrator for at få hjælp.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'Størrelsen på Upload ({0} bytes) har overskredet tilladte maksimum: {1} bytes',
    'UPLOAD_REQUEST_ERROR' => 'Der er opstået en fejl. Opdater venligst din side og prøv igen.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'E',
    'LBL_EDIT_BUTTON_LABEL' => 'Rediger',
    'LBL_ADD_BUTTON_LABEL' => 'Tilføj',
    'LBL_EDIT_BUTTON_TITLE' => 'Rediger [Alt+E]',
    'LBL_REFRESH_BUTTON_LABEL' => 'Opdater',
    'LBL_REFRESH_BUTTON_TITLE' => 'Opdater',
    'LBL_DUPLICATE_BUTTON_KEY' => 'U',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Dupliker',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Dupliker [Alt+U]',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'Rapporttidsplaner',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'Rapporttidsplaner',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'Rapportdetaljer',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'Rapportdetaljer',
    'LBL_DELETE_BUTTON_KEY' => 'D',
    'LBL_DELETE_BUTTON_LABEL' => 'Slet',
    'LBL_DELETE_BUTTON_TITLE' => 'Slet [Alt+D]',
    'LBL_SAVE_BUTTON_KEY' => 'S',
    'LBL_SAVE_BUTTON_LABEL' => 'Gem',
    'LBL_SAVE_BUTTON_TITLE' => 'Gem [Alt+S]',
    'LBL_CANCEL_BUTTON_KEY' => 'X',
    'LBL_CANCEL_BUTTON_LABEL' => 'Annuller',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'at stoppe.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'at blive på siden.',
    'LBL_CANCEL_BUTTON_TITLE' => 'Annuller [Alt+X]',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'Del',
    'LBL_SHARE_BUTTON_TITLE' => 'Del',
    'LBL_START_BUTTON_LABEL' => 'Start',
    'LBL_START_BUTTON_TITLE' => 'Start',
    'LBL_FINISH_BUTTON_LABEL' => 'Udfør',
    'LBL_FINISH_BUTTON_TITLE' => 'Udfør',
    'LBL_CONFIRM_BUTTON_LABEL' => 'Bekræft',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'at fortsætte.',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'at forlade siden og kassere ændringerne.',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'Tastaturgenveje',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>Form funktionalitet - Alt+</strong><br/>I = red<b>I</b>ger (detailvisning)<br/> U = d<b>U</b>blet (detailvisning)<br/> D = <b>D</b> Slet (detailvisning)<br/> A = <b>A</b> Gem ​​(redigeringsvisning)<br/> L = Anu<b>L</b>ler (redigeringsvisning)<br/><br/></p><p><strong>Søgning og Navigation - Alt+</strong><br/> 7 = Første input på redigeringsformularen<br/> 8 = Avanceret søge link<br/> 9 = Første søgeformular input<br/> 0 = Samlet søgningsinput<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'Eskalere',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'Del',
    'TPL_RECORD_SHARE_SUBJECT' => 'Delt {{module}} {{name}} fra {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'Venligst checkout {{module}} {{name}} from {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'connector array i {0} er ukorrekt defineret eller tom og kan ikke anvendes.',
    'LBL_PDF_VIEW' => 'Download PDF',
    'LBL_PDF_EMAIL' => 'E-mail PDF',

    'ERR_SUHOSIN' => 'Upload strøm er blokeret af Suhosin, du bedes tilføje "upload" til suhosin.executor.include.whitelist (Se sugarcrm.log for mere information)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'nu',
    'LBL_TIME_AGO_SECONDS' => 'mindre end et minut siden',
    'LBL_TIME_AGO_MINUTE' => 'ca. 1 minut siden',
    'LBL_TIME_AGO_MINUTES' => '{{this}} minutter siden',
    'LBL_TIME_AGO_HOUR' => 'ca. 1 time siden',
    'LBL_TIME_AGO_HOURS' => '{{this}} htimer siden',
    'LBL_TIME_AGO_DAY' => 'i går',
    'LBL_TIME_AGO_DAYS' => '{{this}} dage siden',
    'LBL_TIME_AGO_YEAR' => 'over et år siden',
    'LBL_TIME_UNTIL_SECONDS' => 'på mindre end et minut',
    'LBL_TIME_UNTIL_MINUTE' => 'i omkring 1 minut',
    'LBL_TIME_UNTIL_MINUTES' => 'om {{this}} minutter',
    'LBL_TIME_UNTIL_HOUR' => 'om omkring en time',
    'LBL_TIME_UNTIL_HOURS' => 'om {{this}} timer',
    'LBL_TIME_UNTIL_DAY' => 'i morgen',
    'LBL_TIME_UNTIL_DAYS' => 'om {{this}} dager',
    'LBL_TIME_UNTIL_YEAR' => 'i over et år',
    'LBL_TIME_RELATIVE' => 'Sendt {{relativetime}} den {{date}} kl. {{time}}',
    'LBL_LAST_TOUCHED' => 'Senest rørt {{relativetime}} den {{date}} ved {{time}}',
    'LBL_LAST_COMMIT' => 'Seneste forpligtelse: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'Ingen data tilgængelige.',
    'LBL_DETAILVIEW_NO_RECORDS' => 'Denne post kan ikke gengives på nuværende tidspunkt.',
    'LBL_REFINE_LIST' => 'User Registration',
    'LBL_SEARCH_BY' => 'Søg efter',
    'LBL_PREVIEW' => 'Eksempel',
    'LBL_COLUMNS' => 'Kolonner',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'Visning deaktiveret: Ingen tilgængelige data',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'Visning deaktiveret: Ingen tilgængelige post',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'Visning deaktiveret: Ingen tilgængelige data',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'Visning deaktiveret: I visning som aktuelle post',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'Visning deaktiveret: Post fjernet eller ingen adgang til post',
    'LBL_PREVIEW_PREVIOUS' => 'Gennemse tidligere',
    'LBL_PREVIEW_NEXT' => 'Gennemse næste',
    'LBL_PREVIEW_CLOSE' => 'Luk gennemse',
    'LBL_STREAM_NO_RECORDS' => 'Denne post har ingen noter i øjeblikket. Venligst tilføje en note ved at klikke på Tilføj note.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} dubletter fundet.',
    'LBL_NO_DUPLICATES_FOUND' => 'Ingen dubletter fundet.',
    'LBL_RESET_DEFAULT_VIEW' => 'Nulstil standardvisning',
    'LBL_RESET_DEFAULT_WIDTHS' => 'Nulstil standardbredder',
    'LBL_TIMEZONE_UPDATED' => 'Sugar har opdateret din brugerprofils tidszone, så den stemmer overens med din browsers tidszone',
    'LBL_SUCCESS' => 'Vellykket',
    'LBL_ERROR' => 'Fejl',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'Flet',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'Ønsker du at fortsætte? Annuller for at afbryde. Bekræft at slette poster.',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'Denne handling vil slette følgende post(er):',
    'LBL_MERGE' => 'Flet',
    'TPL_MERGING_RECORDS' => 'Fletning af {{mergeCount}} Poster',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'Ugyldigt antal poster bestået. Det gyldige interval er fra {{minRecords}} til {{maxRecords}} poster.',
    'LBL_MERGE_NO_ACCESS' =>
        'Du har ikke adgang til at udføre denne handling. Mindst én post skal være redigerbare.',
    'LBL_MERGE_LOCKED' => 'Nogle af de poster, der er markeret til fletning, indeholder felter, der er låst for redigering af en proces og kan ikke flettes på dette tidspunkt.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'Alle ændringer vil blive kasseret, når du skifter til en ny primær post. Er du sikker på du vil skifte?',
    'LBL_MERGE_DUPLICATES_TITLE' => 'Flet Relaterede Poster',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'Flettet: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'Flet relaterede {{objectName}}  mislykkedes. Start af nyt forsøg ({{num}} af {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'Flet relaterede{{objectName}} mislykkedes.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'Flet af relaterede poster ufuldstændig. Nogle optegnelser forbliver uflettede.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'Nogle relaterede poster har ikke flette korrekt. Annuller for at afbryde. Bekræft for at fortsætte fletningen.',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'Alle relaterede poster vil blive flyttet til den primære post.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'Er du sikker på du vil fjerne denne post fra fletning?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'Fjern post fra fletning',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'Ugyldigt antal poster overført. Det gyldige interval er fra 1 til {{maxRecords}} poster.',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'Kombinationen brugernavn/adgangskode, er forkert, prøv venligst igen.',
    'LBL_INVALID_CREDS_TITLE' => 'Ugyldige legitimationsoplysninger',
    'LBL_INVALID_GRANT' => 'Dit token er ugyldigt eller udløbet. Log ind igen.',
    'LBL_INVALID_GRANT_TITLE' => 'Token Udløbet',
    'LBL_AUTH_FAILED' => 'Klient Autentificering mislykkedes.',
    'LBL_AUTH_FAILED_TITLE' => 'Ugyldig klient',
    'LBL_INVALID_REQUEST' => 'Anmodningen er ugyldig eller udformet forkert. Kontakt venligst teknisk support.',
    'LBL_INVALID_REQUEST_TITLE' => 'Ugyldig anmodning',
    'LBL_REQUEST_TIMEOUT' => 'Serveren svarer ikke. Tjek din internetforbindelse.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'Forespørgsel timeout: ',
    'LBL_UNAUTHORIZED' => 'Vi beklager, men det synes du er uberettiget til at få adgang til denne ressource.',
    'LBL_UNAUTHORIZED_TITLE' => 'Uautoriseret',
    'LBL_RESOURCE_UNAVAILABLE' => 'Ressource ikke tilgængelig.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'Forbudt',
    'LBL_METHOD_NOT_ALLOWED' => 'HTTP metode ikke tilladt for denne ressource. Kontakt venligst teknisk support.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'Metode ikke tilladt',
    'LBL_PRECONDITION_MISSING' => 'Bed om svigt, eller manglende/ugyldig parameter. Kontakt venligst teknisk support',
    'LBL_PRECONDITION_MISSING_TITLE' => 'Fejl:',
    'LBL_INVALID_412_RESPONSE' => 'En anmodning mislykkes, der gør programmet ubrugeligt. Kontakt venligst teknisk support.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'Ikke tilladt at redigere feltet {0} i modul: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'Ikke tilladt at udføre handlingen "{0}" på denne post',
    'LBL_LOGIN_BUTTON_LABEL' => 'Log på',
    'LBL_ACTIVITY_VIEW_TOUR' => 'Aktivitets View Tour',
    'LNK_TOUR' => 'Præsentation',
    'LNK_MOBILE' => 'Mobil',
    'LBL_FEEDBACK' => 'Tilbagemelding',
    'LBL_SUPPORT' => 'Support',
    'LBL_LANGUAGE' => 'Sprog',
    'LBL_LOADING_LANGUAGE' => 'Indlæser sprogpakke',
    'LBL_UPLOADING' => 'Oploader',
    'LBL_UPLOADING_DOTS' => 'Uploader...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'Er du sikker på du vil slette billedet?',
    'LBL_FILE_DELETE_CONFIRM' => 'Er du sikker på at du vil slette denne fil? Dette kan ikke fortrydes.',
    'LBL_FILE_DELETED' => 'Fil blev slettet',

    //theme roller
    'LBL_PORTAL_THEME' => 'Tema portal',
    'LBL_THEME_PREVIEW' => 'Eksempel på portaltema',
    'LBL_LOADING_PREVIEW' => 'Indlæser Visning',
    'LBL_RESET' => 'Nulstille',
    'LBL_COLORS' => 'Farger',
    'BorderColor' => 'Kantfarve',
    'NavigationBar' => 'Navigationsbjælke',
    'PrimaryButton' => 'Primære knap',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'Gem & Implementer',
    'LBL_RESET_THEME_LNK' => 'Gendan standard Tema',
    'LBL_RESET_THEME_MODAL_INFO' => 'Er du sikker på du vil kassere dit tema tilpasninger og erstatte med standard tema?',
    'LBL_RESET_THEME_PROCESS' => 'Gendannelse af standard tema...',
    'LBL_SAVE_THEME_PROCESS' => 'Gemmer tema...',

    // image loader
    'LBL_SELECT_PHOTO' => 'Vælg et foto',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'Forbedret prognose funktionalitet i Sugar',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => 'Opsætning af dit fremskrivning parametre<br /><br />Nemt spore forventede salg og pipeline helbred<br /><br />Prognose baseret på forventede salg fra dit salgsteam',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'Opsætning af dit fremskrivningsparametre',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => 'Vælg finansårets startdato<br /><br />Opsætning af tidsperioder at være enten årligt eller kvartalsvis<br /><br />Beslut, hvor mange tidligere og fremtidige tidsperioder skal være synlige i regnearket<br /><br />Vælg prognose spænder at mærke Salgsmuligheder som Inkludere, Ekskludere eller Upside<br /><br />Vælg prognose scenarier at identificere Sandsynligt, Bedste og Værste prognose',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'Administrer din salgsteams forventede salg',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => 'Vælg den periode for at gennemgå prognose<br /><br />Vis dit salgsteam medlemmers regneark og giver korrigerede prognoser<br /><br />Se advarsel på regneark, når et salgsteam medlem forpligter en ny prognose<br /><br />Gem prognose regneark som et udkast eller forpligt prognose til din chef<br /><br />Vis oversigt over tidligere indsendelser',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'Administrer din salgsteams forventede salg',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => 'Vis Pareto diagram for pipeline analyse på tværs af alle dine salgs teammedlemmers prognoser<br /><br />Vælg at visualisere det forventede salg ved Sandsynlig, Bedste eller Værste prognose<br /><br />Vis forventede salg, og hvor tæt du er til at nå dit team budget',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'Administrer dine egne forventede salg',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => 'Vælge den tidsperiode for din prognose<br /><br />Gennemgå og in-line redigere beløb og Vind Sandsynlighed for en hurtig hvad hvis-analyse<br /><br />Gem prognose regneark som et udkast eller forpligte prognosen til din chef<br /><br />Vis oversigt over tidligere indsendelser<br /><br />Forpligte prognose til Manager og vis historik af tidligere indsendelser',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'Administrer dine egne forventede salg',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => 'Se Pareto diagram for pipeline analyse over tid for dine salgsmuligheder<br /><br />Vælg at visualisere pipeline distribution af Salgsfase eller Vind Sandsynlighed<br /><br />Vis forventede salg, og hvor tæt du er til at gøre dit tildelte budget',
    'LBL_TOUR_WELCOME' => 'Hvad er nyt i Sugar',
    'LBL_TOUR_WATCH' => 'Se Hvad er nyt i Sugar',
    'LBL_TOUR_FEATURES_670' => 'Forbedret udseende - nu med en ny moderne tema. Forbedret prognoser modul - nu med intuitiv brugergrænseflade og ny data visualisering',
    'LBL_TOUR_VISIT' => 'For mere information besøg venligst vores applikation',
    'LBL_TOUR_DONE' => 'Du er færdig!',
    'LBL_TOUR_REFERENCE_1' => 'Du kan altid henvise til vores',
    'LBL_TOUR_REFERENCE_2' => 'via linket "Support" under menuen Profil.',
    'LNK_TOUR_DOCUMENTATION' => 'dokumentation',
    'LBL_TOUR_CALENDAR_URL_1' => 'Deler du sin SugarCRM kalender med 3. parts applikationer, såsom Microsoft Outlook eller Exchange? Hvis ja, har du en ny webadresse. Denne nye, mere sikre URL inkluderer en personlig nøgle, som vil forhindre uautoriseret offentliggørelse af din kalender.',
    'LBL_TOUR_CALENDAR_URL_2' => 'Hent din nye delte kalender URL.',
    'LBL_TOUR_CUBE' => 'Adgang til Dashboards og Activity Stream',
    'LBL_TOUR_NAV_BAR' => 'Få adgang til alle moduler i menuen Navigation og træffe foranstaltninger',
    'LBL_TOUR_NOTIFICATIONS' => 'Klik for at se meddelelser',
    'LBL_TOUR_SEARCH' => 'Vælg et eller flere moduler og søg',
    'LBL_TOUR_AVATAR' => 'Få flere oplysninger om programmet eller Logout',
    'LBL_TOUR_ADD' => 'Opret en post herfra',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'Klik for at lukke eller åbne intelligens rute',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'Vælg at se aktiviteter eller liste over poster',
    'LBL_TOUR_LIST_FILTER1' => 'Filter bar gør søgning til dette modul',
    'LBL_TOUR_LIST_FILTER2' => 'Vælg foruddefineret filter eller oprette nye',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'Skriv her for at søge baseret på navn',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'Vælge at redigere række eller vis detaljer',
    'LBL_TOUR_RECORD_ACTIONS' => 'Tag aktioner på post',
    'LBL_TOUR_RECORD_SUBPANEL' => 'Klik på header for at udvide og skjule underpanel',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'Postens navn kan blive opdateret på plads',
    'LBL_TOUR_RECORD_STATUS' => 'Find post niveau status her',
    'LBL_TOUR_RECORD_SHOWMORE' => 'Klik for at se flere data for posten',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'Vælg at se aktiviteter eller relaterede poster',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'Klik for at redigere hvert felt inline',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'Opret nye grupper af Dashlets',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'Giv et navn til gruppen af ​​Dashlets',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'Vælg at fjerne Dashlet eller ændre indstillinger',
    'LBL_TOUR_INTRO' =>'<h4>Velkommen til Sugar</h4> Vi vil gerne vise dig nogle af mulighederne. Brug < og > pilene nedenfor til en hurtig rundvisning.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">Hvad er nyt?</a><p class="details">Find ud af, hvad de grundlæggende ændringer er i den seneste version.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">Find ud af mere om Sugar</a><p class="details">Et solidt bibliotek til eLearning, direkte og virtuel undervisning, webinars og videovejledninger.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">Få support</a><p class="details">Har du brug for hjælp, har du et problem eller vil du bare komme med et forslag til at gøre Sugar bedre?</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'Se en liste over poster og træffe foranstaltninger til postene.',
    'LBL_TOUR_RECORD_INTRO' => 'Se detaljer om denne post og se alle data relateret til det.',
    'LBL_TOUR_FORECAST_INTRO' => 'Administrer pipeline og prognose.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'Vælg en periode for at se den tilhørende prognose',
    'LBL_TOUR_FORECASTS_COMMITS' => 'Klik for at se tidligere indsendelser',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'Klik for at redigere data inline',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'Gennemgang af afstand til budget',
    'LBL_TOUR_FORECASTS_CHART' => 'Gennemgang af prognose fordeling',
    'LBL_TOUR_TOUR' => 'Adgang til Tour til enhver tid',
    'LBL_TOUR_TAGS_ADD' => 'Klik på feltet tags for at tilføje og fjerne tags',
    'LBL_TOUR_TAGS_DELETE' => 'For at slette et tag, brug backspace eller klik på [X] på hvert tag',
    'LBL_TOUR_RECORD_SAVE' => 'Når du er klar, skal du klikke på Gem',


    'LBL_FUTURE' => 'Fremtiden',
    'LBL_REQUIRED_FIELD' => 'Obligatorisk',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'Angiven linjepost',
    'LBL_DISCOUNT_TOTAL' => 'Rabat i alt',
    'LBL_DISCOUNT_PERCENT' => '% procent',
    'LBL_DISCOUNT_SELECT' => 'Afgør hvorvidt rabatten er en procentdel eller et fast beløb',
    'LBL_TAX' => 'Skat',
    'LBL_SHIPPING' => 'Forsendelse',
    'LBL_GRAND_TOTAL' => 'Samlet beløb',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'Udfyld automatisk faktureringsadresse fra kontoprofil',
    'LBL_QLI_ADD_GROUP' => 'Tilføj en gruppe',
    'LBL_QLI_COMMENT' => 'Kommentar',
    'LBL_SELECT_ACTION' => 'Vælg handling',
    'LBL_QLI_GROUP_NAME' => 'Gruppenavn',
    'LBL_GROUP_TOTAL' => 'Samlet gruppe',
    'LBL_ITEM_NAME' => 'Linjepost',
    'LBL_QLI_DELETE' => 'Er du sikker på, at du ønsker at slette denne linjepost?',
    'LBL_QLI_COMMENT_DELETE' => 'Er du sikker på, at du ønsker at slette denne linjepost-kommentar?',
    'LBL_QLI_GROUP_DELETE' => 'Ønsker du at slette gruppe {0}? Alle emner vil blive flyttet til standardgruppen.',
    'LBL_QLI_GROUP_EMPTY' => 'Intet angivet linjepunkt',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'Valgfri',
    'LBL_RELATED_MODULE' => 'Relateret {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'Relateret {{{this}}}',
    'LBL_CREATE_MODULE' => 'Opret {{{this}}}',
    'LBL_EDIT' => 'Rediger {{{this}}}',
    'LBL_ASSOC' => 'Link til {{{this}}}',
    'LBL_ASSIGN' => 'Vælg {{{this}}}',
    'LBL_EDIT_RELATED' => 'Rediger relaterede  {{{this}}}',
    'LBL_CREATE_RELATED' => 'Skab relaterede {{{this}}}',
    'LBL_ASSOC_EXISTING' => 'Link eksisterende {{{this}}}',
    'LBL_SEARCH_ALL' => 'Søg alle  {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'Søg alle poster...',
    'LBL_SEARCH_ALL_MODULES' => 'Søg alle',
    'LBL_OK' => 'OK',
    'LBL_YES' => 'Ja',
    'LBL_NO' => 'Nej',
    'LBL_SHOW_NUMBERING' => 'Vis fasenummerering',
    'LBL_HIDE_NUMBERING' => 'Skjul fasenummerering',
    'LBL_CALL_BUTTON' => 'Opkald',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'E-mail',
    'LBL_HONEYPOT' => 'Hvis du er en virkelig person, skal du ikke udfylde det her.',
    'LBL_LINK_BUTTON' => 'Link',
    'LBL_UNLINK_BUTTON' => 'Fjern',
    'LBL_MAP_BUTTON' => 'Kort',
    'LBL_FILE_BUTTON' => 'Fil',
    'LBL_URL_BUTTON' => 'Internettet',
    'LBL_WARNING' => 'Advarsel',
    'LBL_CONFIRM' => 'Bekræft',
    'LBL_CONFIRMATION_POPUP' => 'Popup til bekræftelse',
    'LBL_NO_ACCESS' => '(Ingen adgang)',
    'LBL_NO_ACCESS_LOWER' => 'Ingen adgang',
    'LBL_NO_FIELD_ACCESS' => 'Ingen adgang',
    'LBL_NO_LICENSE_ACCESS' => 'Licens er påkrævet',
    'LBL_VALUE_ERASED' => 'Værdi slettet',
    'LBL_VALUE_ERASED_TOOLTIP' => 'Disse oplysninger er blevet slettet gennem anmodning om beskyttelse af personlige oplysninger',
    'LBL_CREATE_RELATED_RECORD' => 'Opret relateret post',
    'LBL_ASSOC_RELATED_RECORD' => 'Tilknyt eksisterende post',
    'LBL_CHOOSE_LINK' => 'Vælg link type',
    'LBL_CHOOSE_PARENT_TYPE' => 'Vælg hoved type',
    'LBL_HOME' => 'Startside',
    'ERR_NO_DOCS' => 'Ingen dokumenter tilgængelige',
    'ERR_NO_RECORDS_SELECTED' => 'Du har ikke valgt nogen poster.',
    'LBL_DELETING' => 'Sletter...',
    'LBL_UNLINKING' => 'Ophæve link...',
    'LBL_UNLINKED' => 'Ikke linket',
    'LBL_LEGAL' => 'Juridisk',
    'LBL_UPCOMING' => 'Mine kommende begivenheder',
    'LBL_RECENTLY_UPDATED' => 'Nyligt opdateret',
    'LBL_NOTES_SUBPANEL_TITLE' => 'Noter',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'Møder',
    'LBL_TASKS_SUBPANEL_TITLE' => 'Opgaver',
    'LBL_CALLS_SUBPANEL_TITLE' => 'Opkald',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'Konti',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'Kontakter',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'E-mails',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'Skiftene',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'Produkter',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'Undtagelser fra skift',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'Dokumenter',
    'LBL_ESCALATIONS' => 'Eskaleringer',
    'LBL_ESCALATED' => 'Eskaleret',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'Eskaleringer',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'Andre Relaterede Eskaleringer',
    'LBL_ESCALATIONS' => 'Eskaleringer',
    'LNK_SETTINGS' => 'Indstillinger',
    'LBL_MOBILE_SUPPORT' => 'Support',
    'LBL_MOBILE_SHOW_MORE' => 'Vis mere...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'Vis mere...',
    'LBL_MOBILE_NO_RECORDS' => 'Ingen poster blev fundet',
    'LBL_MOBILE_SEARCH_TEAMS' => 'Søg team...',
    'LBL_MOBILE_SELECT_TEAMS' => 'Vælg teams',
    'LBL_MOBILE_WAIT' => 'Vent venligst',
    'LBL_MOBILE_LOGING_OUT' => 'Vent, mens logger ud...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'Re-Logind',
    'LBL_MOBILE_META_SYNC_FAILED' => 'Kunne ikke synkronisere med serveren.',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'Kunne ikke synkronisere med serveren. Prøv igen?',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'Privacy, Vilkår & Betingelser',
    'LBL_MOBILE_APP_VERSION' => 'App version',
    'LBL_MOBILE_SERVER_VERSION' => 'Server Version',
    'LBL_MOBILE_SERVER_URL' => 'Server-URL:',
    'LBL_MOBILE_PTR_PULL' => 'Træk ned for at opdatere...',
    'LBL_MOBILE_PTR_RELEASE' => 'Frigiv for at opdatere...',
    'LBL_MOBILE_EDIT_REL' => 'Rediger relation',
    'LBL_MOBILE_DESKTOP' => 'Desktop Version',
    'LBL_MOBILE_DELETE_CONFIRM' => 'Er du sikker på, at du vil slette denne post?',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'Er du sikker på du vil fjerne linket til denne post?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'Vil du gerne logge din sidste opkald?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'Vælg modtager',
    'LBL_MOBILE_CHOOSE_PHONE' => 'Vælg telefonnummer',
    'LBL_MOBILE_CHOOSE_URL' => 'Vælg URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'Vælg dokument',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'Vælg placering',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'Ingen tilgængelige handlinger',
    'LBL_MOBILE_FEEDBACK' => 'Tilbagemelding',
    'LBL_MOBILE_DOC' => 'Dokument',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'Download startede: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'Download afsluttet: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'Uploader fil...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'Fil uploadet korrekt',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'Forbereder billede...',
    'LBL_CLOSE_SAVE_BUTTON' => 'Luk opgave, og gem',
    'LBL_LATER' => 'Senere',
    'LBL_USE_HTTPS' => 'Brug sikker forbindelse',
    'LBL_LOADING_FILES' => 'Opdaterer dokument liste. Prøv venligst igen senere',
    'LBL_NEW_WEB_VERSION' => 'En ny version af dette program er tilgængelig. Vil du gerne opdatere?',
    'LBL_SET_FONTSIZE' => 'Skriftstørrelse',
    'LBL_FONTSIZE_TINY' => 'Meget lille',
    'LBL_FONTSIZE_SMALL' => 'Lille',
    'LBL_FONTSIZE_NORMAL' => 'Normal (standard)',
    'LBL_FONTSIZE_LARGE' => 'Stor',
    'LBL_FONTSIZE_LARGER' => 'Større',
    'LBL_FONTSIZE_HUGE' => 'Stort',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'Ekstra stor',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "Download failed\r\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'Mere...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...Mindre',
    'LBL_OFFLINE_MODE' => 'Offline tilstand',
    'LBL_OFFLINE_DELETED' => 'Post ikke fundet.',
    'LBL_OFFLINE_DELETED_RELATED' => 'Relateret post ikke fundet. Den var formentlig slettet eller fjernet tilknytning.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'At downloade dine tildelte, favorisiert, og fulgte poster for offline-adgang kan tage lidt tid at fuldføre. Det anbefales en hurtig forbindelse. Vil du fortsætte?',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'Ønsker du, at dine tildelte, favoritter og fulgte poster overføres til offline adgang? Det anbefales en hurtig forbindelse, da denne operation kan tage nogen tid. Du kan download senere fra hovedmenu > Offline.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'Poster downloadet med succes',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'Download dine poster...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'Fejl under download af poster',
    'LBL_OFFLINE_PREFETCHING' => 'Indlæser poster...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'Indlæser {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'Tid tilbage er ca {{estimatedTime}}s...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => 'Indlæser {{module}} afsluttet',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'Oprydning af lagring...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'Oprydning afsluttet',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'Ønsker du at rollback denne ændring?',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'Rollback afsluttet',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'Rollback mislykkedes',
    'LBL_OFFLINE_CLEAR_DB' => 'Annuler lager...',
    'LBL_OFFLINE_COMPACT_DB' => 'Kompakt lagring',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'Denne handling vil slette de poster, du ikke har brugt i et stykke tid. Fortsæt?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'Ønsker du at slette alle poster fra lokal lagring?',
    'LNK_OFFLINE_SETTINGS' => 'Offline',
    'LBL_OFFLINE_SETTINGS' => 'Fejlsøge indstillinger',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'Ingen ændringer verserer synkronisering.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'Ændringer afventer synkronisering.',
    'LBL_OFFLINE_STATUS_ONLINE' => 'Enheden er online.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'Enheden er offline.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'Kunne ikke få forbindelse til serveren.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'Sidste synkronisering mislykkedes. Kontroller transactions journal.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'Synkronisering i gang...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'Transaktionen synkroniseret.',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'Er du sikker på du vil aktivere offline support?',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'Ønsker du at slå offline support? Alle ændringer der verserer synkronisering vil gå tabt.',
    'LBL_OFFLINE_ENABLED' => 'Offline mode er aktiveret',
    'LBL_OFFLINE_DISABLED' => 'Offline mode er deaktiveret',
    'LBL_OFFLINE_STATS' => 'Lagring statistik',
    'LBL_OFFLINE_SERVER_FETCH' => 'Henter fra server ...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'Nogen har redigeret den samme post på serveren. Bekræft at auto-flette dine ændringer eller afvise for at kassere dem.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'Sidste synkroniseringsforsøg: {{ts}}',
    'LBL_ACTION_UPDATE' => 'OPDATER',
    'LBL_ACTION_CREATE' => 'SKAB',
    'LBL_ACTION_DELETE' => 'SLET',
    'LBL_ACTION_LINK' => 'LINK',
    'LBL_ACTION_UNLINK' => 'FJERNE LINKET',
    'LBL_ACTION_FAVORITE' => 'FAVORIT',
    'LBL_ACTION_FOLLOW' => 'FØLG',
    'LBL_ACTION_CREATE_EXPLANATION' => 'Oprettet {{module}} "{{name}}"',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'Opdateret {{module}} "{{name}}"',
    'LBL_ACTION_DELETE_EXPLANATION' => 'Slettet {{module}} "{{name}}"',
    'LBL_ACTION_LINK_EXPLANATION' => 'Linket {{module}} "{{name}}" til {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'Fjernet tilknytningen {{module}} "{{name}}" fra {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'Fulgt {{module}} "{{name}}"',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'Følger ikke {{module}} "{{name}}"',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'Favoriseret {{module}} "{{name}}"',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'Fjern favorit {{module}} "{{name}}"',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'Skabt {{module}} "{{name}}" relateret til {{relatedModule}} "{{relatedName}}"',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'Primær',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'Fravælg',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'Tilføje',
    'LBL_EMAIL_ACTION_SET_VALID' => 'Gyldig',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'Ugyldig',
    'LBL_ROLLBACK_BUTTON' => 'Rollback',
    'LBL_TX_LOG' => 'Transaktionsjournal',
    'LBL_TX_LOG_DETAIL' => 'Transaktionsdetaljer',
    'LBL_RECORD_DELETED' => '(Post slettet)',
    'LBL_NOT_AVAILABLE' => 'ikke tilgængelig',
    'LBL_FILE_SIZE' => 'Filstørrelse',
    'LBL_FILE_SIZE_UNITS_B' => 'Bytes',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => 'Vælg emner',
    'LBL_OFFLINE_DB_SIZE' => 'Database størrelse',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'Poster per modul',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'Total antal poster',
    'LBL_RECORD_NOT_FOUND' => 'Post ikke fundet.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'Relateret post ikke fundet.',
    'LBL_NOT_AUTHORIZED' => 'Du er ikke autoriseret til at se denne post.',
    'LBL_MOBILE_PROCESSING_FILE' => 'Forbereder fil...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'Tredjeparts software',
    'LNK_TERMS_OF_USE' => 'Brugsbetingelser',
    'LNK_PRIVACY_POLICY' => 'Fortrolighedspolitik',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'Enkelt logon',
    'LBL_RECENTS' => 'Seneste',
    'LBL_SHOWING_CACHED_DATA' => 'Ude af stand til at nå serveren. Viser seneste tilgængelige data ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'Luk {{moduleSingular}} og gem',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'Specifikt betjeningspanel',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'Specifikt modul',
    'LBL_MOBILE_DEFAULT_VIEW' => 'Start screen',
    'LBL_MOBILE_DEFAULT_MODULE' => 'Valgt modul',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'Valgt betjeningspanel',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'Valgt dashlet',
    'LBL_ALL_DASHLETS' => 'Alle dashlets',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'Global søgning',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Indtast @ for at nævne en bruger. Indtast # for at referere en post.',
    'LBL_MOBILE_NEW_COMMENT' => 'Ny kommentar',
    'LBL_RECENTLY_VIEWED' => 'Senest vist',
    'LBL_FILE_STORED_LOCALLY' => 'Filen lagres lokalt og synkroniseres, når enheden er online.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'Hvis du ønsker at ændre bestemte felter, som ikke er redigerbare, så kontakt venligst Administrator, og oplys om disse ændringer.',
    'LBL_ACTIVITY_POST' => '{{{value}}}tændt {{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'Ingen kommentar',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'Vis de næste {{{commentsLeft}}} kommentarer',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'Fold sammen',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'Bekræft oprettelse af kommentar',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'Kommentar-log kan ikke være tom',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'Download {{{pdfTemplateName}}} PDF',

    'ERR_SYNC_FAILED' => 'Kunne ikke synkronisere med serveren.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'Adgang er ikke godkendt.',
    'ERR_MOBILE_INVALID_CREDS' => 'Ugyldigt brugernavn eller adgangskode.',
    'ERR_MOBILE_SESSION_EXPIRED' => 'Din session er udløbet.',
    'ERR_MOBILE_NOT_FOUND' => 'Ressource ikke fundet.',
    'ERR_MOBILE_TIMEOUT' => 'Server svarer ikke.',
    'ERR_MOBILE_CONNECTION_FAILED' => 'Kan ikke nå serveren.',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'Internetforbindelsen er utilgængelig.',
    'ERR_MOBILE_INTERNAL' => 'Intern fejl ({{{code}}}). Prøv venligst igen senere.',
    'ERR_MOBILE_VALIDATION' => 'Post er ugyldig',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'Inkompatibel server udgave: {{{flavor}}}. Understøttede udgaver: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'Inkompatibel server-version: {{{version}}}. Minimum påkrævede version: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'Fejl. Ugyldig e-mail-adresse.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'Denne type dokument er ikke understøttet.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'Godkendelse mislykkedes.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'Anmodede ressource blev ikke fundet.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'Intern serverfejl.',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'Forbudt.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'Tjenesten er ikke tilgængelig.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'Der er opstået en uventet fejl.',
    'ERR_MOBILE_UPLOAD' => 'Fejl under fil upload',
    'ERR_MOBILE_FILE_PROCESSING' => 'Fil forarbejdning fejl',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'Lagerenhed er ikke tilgængelig',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'Din app er forældet og er ikke længere forenelig med {{{brandName}}} instans du opretter forbindelse til. Ønsker du for at downloade den nye version fra App Store?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'Server-konfiguration har ændret sig og reload er påkrævet. Fortsæt?',
    'ERR_MOBILE_CONFLICT' => 'Nogen har redigeret den samme post på serveren. Bekræft at auto-flette dine ændringer eller afvise for at kassere dem.',
    'ERR_MOBILE_METADATA_CHANGED' => 'Server-konfiguration har ændret sig.',
    'ERR_MOBILE_FILE_READ' => 'Kunne ikke læse filen',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'Fil ikke fundet',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'Kunne ikke læse filen',
    'ERR_MOBILE_FILE_ABORTED' => 'Læs blev afbrudt',
    'ERR_MOBILE_FILE_SECURITY' => 'Filen er låst',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'Mobilversion understøtter ikke denne funktionalitet. Ønsker du at åbne desktop-versionen?',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'Filen er for stor. Max tilladte størrelse er {{size}}',
    'ERR_OFFLINE' => 'Offline fejl',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'Kunne ikke åbne lokal lagring',
    'ERR_OFFLINE_STORAGE_CREATE' => 'Kunne ikke oprette lokal lagring',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'Kunne ikke oprette lokal lagring: Du er løbet tør for plass.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'Du er løbet tør for plads til lokal lagring.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'Database oprydning mislykkedes',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'Du er løbet tør for plads til offline lagring. Det anbefales at rydde op i lageret. Dette kan tage flere minutter.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'Lykkedes ikke at forudhente poster fra server',
    'ERR_OFFLINE_SYNC_ERROR' => 'Synkronisering fejl',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'Synkronisering konflikt',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'Det lykkedes ikke at få server tid',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'Det lykkedes ikke at aktivere offline-tilstand. Kunne ikke nå serveren.',
    'LBL_EXPORT_CSV' => 'Eksporter CSV',
    'LBL_ERR_EXPORTING_CSV' => 'Eksporten mislykkedes',
    'LBL_ERR_EXPORT_ALL' => 'Det lykkedes ikke at hente data for udvalgte poster, prøv igen',
    'LBL_LIST_SETTINGS_RESTORE' => 'Gendan standarder',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'Gendan felter?',
    'LBL_LIST_SETTINGS_TITLE' => 'Listevisningsværktøj',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'Tilgængelige felter',
    'LBL_LIST_SETTINGS_REMOVE' => 'Fjern',
    'LBL_LIST_SETTINGS_TEXT' => 'Træk felter ind i listevisningsværktøjet, og omarranger dem for at designe {{moduleName}}-listevisningen.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'Mindst ét felt skal tilføjes til layoutet.',
    'LBL_LIST_SETTINGS_EMPTY' => 'Ingen tilgængelige felter',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'Ingen matchende felter fundet',
    'LBL_LIST_FILTER' => 'Søg efter felt',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'E-mail-klient',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'Ekstern e-mail-klient',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar e-mail-klient',
    'LBL_OFFLINE_CAPABILITIES' => 'Aktiver offline-funktioner',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'Sletning af transaktionen mislykkedes.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'Transaktion slettet.',
    'LBL_SECURE_MODE' => 'Forbedret sikkerhedstilstand',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'Aktiver denne indstilling for at skjule indholdet af Sugar Mobile, når appen er i baggrunden, og for at forhindre at der tages skærmbilleder af appen på ethvert tidspunkt.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'Aktiver denne indstilling for at skjule indholdet af Sugar Mobile, når appen er i baggrunden.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'Altid offline-tilstand',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'Du arbejder i altid offline-tilstand. Ønsker du at genoprette forbindelsen?',
    'LBL_RECONNECT' => 'Genopret forbindelsen',
    'LBL_STAY_OFFLINE' => 'Forbliv offline',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'Det modul, du forsøger at få adgang til, er ikke tilgængeligt på Sugar Mobile.',
    'LBL_MOBILE_RELEASE_NOTE' => 'Udgivelsesnoter for Sugar Mobile til {{platform}}',
    'LBL_MOBILE_USER_GUIDE' => 'Brugervejledning til Sugar Mobile til {{platform}}',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'der indeholder disse ord',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'der ikke indeholder disse ord',
    'LBL_NOTIFICATIONS_CHANNEL' => 'Opdateringer',
    'LBL_APPLY_BUTTON_LABEL' => 'Anvend',
    'LBL_ACTION_CREATE_FAILURE' => "Kunne ikke gemme posten:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "Kunne ikke opdatere posten:\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'Det lykkedes ikke at løse feltberegninger på serveren.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'Følgende felter er ugyldige: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>Succes.</b> Du har oprettet {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}".</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>Succes.</b> Du har opdateret posten',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'Kunne ikke hente e-maildata fra serveren.',
    'LBL_ASSIGN_SUCCESS' => '<b>Succes.</b> Posten er blevet tildelt til {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'Gem denne e-mail som et udkast?',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'Gem som udkast',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'Kassér e-mail',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'Hvis du ikke gemmer udkastet, mister du denne e-mail.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'Vælg signatur',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'Vælg e-mail-skabelon',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'Skabelonen overskriver alt indhold i denne e-mail. Er du sikker på, at du ønsker at bruge denne skabelon og overskrive indholdet?',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'Opret e-mail',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'Din e-mail indeholder variabler, der erstattes med værdier fra posten "Relateret til". Bekræft venligst, at feltet "Relateret til" er indstillet korrekt, inden du sender.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'Der er ikke fundet nogen udgående e-mail-konto. Kontakt din Sugar-administrator.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' og {{{count}}} flere',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'Tilføj en e-mail',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'Indtast et kontaktnavn eller en e-mail',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (Ny e-mail)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'Variabler',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'E-mail-skabeloner',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'Kampagne-skabeloner',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'Skabeloner til arbejdsgang',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'Systemskabeloner',
    'LBL_FILTER_EDIT' => 'Rediger filter',
    'LBL_FILTER_MY_FILTER' => 'Mit filter',
    'LBL_FILTER_MY_FILTER_BY' => 'Mit filter efter {{{filters}}}',
    'LBL_FILTER_SAVE' => 'Gem filter',
    'LBL_SELECT_PARAM' => 'Vælg',
    'LBL_SELECT_MODULES' => 'Modulvælger',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'Vælg yderligere parameter',
    'LBL_FILTER_TEMPORARY' => 'Midlertidigt filter',
    'LBL_ERROR_FILE_UPLOAD' => 'Kunne ikke uploade filen {{{fieldLabel}}} med navn "{{{fileName}}}". {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">Se fejlslagen post</a>',
    'LBL_FILE_UPLOAD_ONE' => 'Gemmer fil...',
    'LBL_FILE_UPLOAD_MANY' => 'Gemmer fil {{{index}}} af {{{total}}}...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'Indstillinger for notifikationer',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'Administrer dine push-notifikationer',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "Kontroller hvordan notifikationer vises ved at ændre din enheds indstillinger for notifikationer.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'Tildelinger',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'Modtag notifikationer, når du får tildelt poster.',
    'LBL_NOTIFICATION_MENTIONS' => 'Nævnt',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'Modtag notifikationer, når du bliver nævnt i kommentarlogposter.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'Feltet Kommentarlog er ikke blevet tilføjet til dette layout af en administrator. Kontakt din Sugar-administrator.',
    'ERR_NO_PERMISSION_TITLE' => 'Tillad adgang',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} har brug for kameraadgang, så du kan vedhæfte billeder. Du skal tillade kameraadgang i systemindstillingerne.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'Indstillinger',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'Varighed',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'Tid tilbage',
    'LBL_LIST_SUPPORT_EXPIRES' => 'Udløber',
    'LBL_CASCADE_RLI_EDIT' => 'Opdater åbne indtægts linjeelementer',
    'LBL_MOBILE_CALENDAR' => 'Kalender',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'Kalenderindstillinger',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'Ugens startdag',
    'LBL_MOBILE_CALENDAR_MODULES' => 'Begivenheder, der skal vises',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}h:{{{minutes}}} min',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} timer',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} min',
    'LBL_MOBILE_CALENDAR_TODAY' => 'I dag',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => 'Tilføj {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'Planlæg en aktivitet',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'Du skal aktivere mindst én begivenhedstype.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'Hele dagen',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'Kunne ikke indlæse kalendere.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'Denne handling er ikke tilgængelig i Sugar Mobile. Ønsker du at åbne skrivebordsprogrammet i stedet?',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'Vælg skabelon',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'Flet',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'Fejl: EXIF-data mangler fra HEIC-fil',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'Fejl: Billedopløsning for høj',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'Fejl: Kan ikke behandle billedet',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'Fejl: Kunne ikke renderi billedet til kanvas',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'Fejl: Kunne ikke indlæse filen som billede',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '1 element valgt',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '{{{count}}} elementer valgt',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'Vælg alle',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'Du har valgt {{{{count}}}} poster i denne visning. Vælg alle poster?',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'Vælg {{{count}}} poster',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'Er du sikker på, at du vil slette den eller de valgte poster?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'Sletter… {{{count}}} af {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'Ingen gyldig e-mail fundet i de valgte poster',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'Udseende',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'Brug systemindstillinger',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'Lys',
    'LBL_MOBILE_APP_THEME_DARK' => 'Mørk',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'Nyt filnavn',
    'LBL_ATTACHMENT_RENAME_MSG' => 'Omdøb filen',
    // Filters related
    'LBL_CREATED_BY_ME' => 'Oprettet af mig',
    'LBL_OPERATOR_ONE_OF' => 'er en af',
    'LBL_OPERATOR_NOT_ONE_OF' => 'er ikke en af',
    'LBL_OPERATOR_CONTAINS' => 'er nogen af',
    'LBL_OPERATOR_CONTAINS_WORD' => 'indeholder',
    'LBL_OPERATOR_NOT_CONTAINS' => 'er ikke nogen af',
    'LBL_OPERATOR_EMPTY' => 'er tom',
    'LBL_OPERATOR_NOT_EMPTY' => 'er ikke tom',
    'LBL_OPERATOR_MATCHES' => 'matcher nøjagtigt',
    'LBL_OPERATOR_STARTS_WITH' => 'starter med',
    'LBL_OPERATOR_EQUALS' => 'er lig med',
    'LBL_OPERATOR_NOT_EQUALS' => 'er ikke lig med',
    'LBL_OPERATOR_GREATER_THAN' => 'er større end',
    'LBL_OPERATOR_LESS_THAN' => 'er mindre end',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'er større end eller lig med',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'er mindre end eller lig med',
    'LBL_OPERATOR_BETWEEN' => 'er mellem',
    'LBL_OPERATOR_BEFORE' => 'før',
    'LBL_OPERATOR_AFTER' => 'efter',
    'LBL_OPERATOR_YESTERDAY' => 'i går',
    'LBL_OPERATOR_TODAY' => 'i dag',
    'LBL_OPERATOR_TOMORROW' => 'i morgen',
    'LBL_OPERATOR_LAST_7_DAYS' => 'de sidste 7 dage',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'de næste 7 dage',
    'LBL_OPERATOR_LAST_30_DAYS' => 'de sidste 30 dage',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'de næste 30 dage',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'For mere end __ dage siden',
    'LBL_OPERATOR_LAST_X_DAYS' => 'Seneste __ dage',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'Næste __ dage',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'Mere end __ dage i fremtiden',
    'LBL_OPERATOR_LAST_MONTH' => 'sidste måned',
    'LBL_OPERATOR_THIS_MONTH' => 'denne måned',
    'LBL_OPERATOR_NEXT_MONTH' => 'næste måned',
    'LBL_OPERATOR_LAST_YEAR' => 'sidste år',
    'LBL_OPERATOR_THIS_YEAR' => 'dette år',
    'LBL_OPERATOR_NEXT_YEAR' => 'næste år',
    'LBL_OPERATOR_IS' => 'er',
    'LBL_OPERATOR_IS_NOT' => 'er ikke',
    'LBL_OPERATOR_AFTER_TODAY' => 'efter i dag',
    'LBL_OPERATOR_BEFORE_TODAY' => 'inden i dag',
    'LBL_ERROR_FILTER_EMPTY' => 'Venligst tilføj filterkriterier.',
    'LBL_ADD_FILTER' => 'Tilføj kriterier',
    'LBL_FILTER_NAME' => 'Filternavn',
    'LBL_FILTER_FIELD' => 'Felt',
    'LBL_FILTER_OPERATOR' => 'Operatør',
    'LBL_FILTER_VALUE' => 'Værdi',
    'LBL_FILTER_SYNC_TO_SERVER' => 'Gem til desktop-app',
    'LBL_FILTER_LOCAL' => 'Lokalt filter',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'Velkommen til {{{brandName}}}.<br /><br />Tillad os at fremhæve nogle nye funktioner...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'Hovedmenu navigation.',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'Tilgængelige handlinger per view.',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'Global søgning efter poster.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'Filtrere listen for at vise mine favorit poster.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'Filtrere listen for at vise poster tildelt mig.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'Markere post som en favorit.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'Mine kommende begivenheder begynder i dag.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'De senest modificerede poster.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'Tilgængelige handlinger på en post.',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'Nyd alle de nye funktioner!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'Dette er plus menuen.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'Luk plus menuen.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'Vælg den specifikke handling, for at udføre.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'Dette er startmenuen.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'Luk startmenuen.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'Se et særligt modul.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'Tilpas ansøgningen.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'Åbn Sugar i webbrowseren.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'Se din profil.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'Dette er den detaljerede side.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'De vigtigste oplysninger om en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'Se yderligere oplysninger eller redigere en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'Tilgængelige handlinger på en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'Gå til den forrige side.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'Få adgang til Tour til enhver tid.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'Gå tilbage.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'Klik for at åbne en relateret post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'Følg / Følg ikke en post.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'Klik for at udvide en detaljeoplysning.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'Hovedmenuvisning.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'Hovedmenuen åbnes i venstre side af skærmen.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'Detaljevisning',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'Detaljevisningen åbner på højre side af skærmen.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'Brug pilene nedenfor for en hurtig tur gennem de centrale elementer i denne menu.',

    'LBL_COMMENT_ADD' => 'Tilføj en kommentar',
    'LBL_REQUIRED' => 'Påkrævet',
    'LBL_MORE_BUTTON' => 'Mere',
    'LBL_NO_OPTIONS' => 'Ingen muligheder tilgængelige',
    'LBL_TRY_AGAIN' => 'Prøv igen',
    'LBL_NEW_RECORDS' => 'Nyligt oprettet',
    'LBL_ASSIGNED_TO_ME' => 'Mine {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => 'Alle {{{module}}}',
    'LBL_UNFAVORITE' => 'Fjern favorit',
    'LBL_ACTIVITY_CREATE' => 'Oprettet {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => 'Opdateret {{{changes}}} den {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => 'Linket {{{relatedRecord}}} {{{record}}} til {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => 'Link fjernet {{{relatedRecord}}} {{{record}}} fra {{{module}}}',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} til {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'Download relaterede poster...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'Konfigurationen af dit dashboard er blevet ændret. Ønsker du at opdatere?',
    'LBL_RECORDS' => 'Poster',
    'LBL_DASHBOARDS' => 'Betjeningspaneler',
    'LBL_TEMPLATES' => 'Skabeloner',
    'LBL_NON_TEMPLATES' => 'Ikke skabeloner',
    'LBL_IS_TEMPLATE' => 'Er en skabelon',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'Dit valg indeholder dashboard-skabeloner, som ikke kan masseopdateres. Fravælg en eller flere skabeloner for at fortsætte.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'Dit valg indeholder dashboard-skabeloner, som ikke kan masseslettes. Fravælg en eller flere skabeloner for at fortsætte.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'Søg {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'Hovedmenu',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'Hurtig opretning af ny post',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'Swipe for yderligere muligheder',
    'LBL_DETAILS' => 'Detaljer',
    'LBL_DETAIL_RELATED' => 'Relateret',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'Dette {{module}} kræver en {{relatedModule}}. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>Opret en {{relatedModule}} post</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'Rediger post',
    'LBL_OFFLINE_MENU_SETTINGS' => 'Offline Indstillinger',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'Fejlsøg indstillinger',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'Samlet antal poster',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'Sidste download',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'Kan ikke downloade filen.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'Kunne ikke dowloade dashboards fra server',
    'ERR_FILTERS_FETCHING' => 'Ikke i stand til at indlæse dine filtre',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'Kunne ikke kryptere lokal lagring',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'Kryptering af offline data. Dette kan tage flere minutter.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'Offline datakryptering afsluttet.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'Du har ikke adgang til {{{module}}} modul.',
    'LBL_SKIP' => 'Spring over',
    'LBL_CONTINUE' => 'Fortsæt',
    'LBL_ENABLE' => 'Aktivér',
    'LBL_MOBILE_TRIAL_UNTIL' => 'Prøveperiode indtil',
    'LBL_MOBILE_SDK_VERSION' => 'SDK-version',
    'LBL_LOG_LEVEL' => 'Logføringsniveau',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'Login-indstillinger er blevet konfigurerede.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'Din prøveperiode er udløbet.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'Serveren understøtter ikke sikker forbindelse. Sluk venligst for sikker forbindelse.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'Serveren understøtter sikker forbindelse. Slå venligst sikker forbindelse til.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'Din forbindelse er ikke sikker. Kontakt din administrator.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'Login-indstillinger',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'Konfigurer dit {{{brandName}}} eksempel',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'For at app&#39;en kan fungere, skal du indtaste dit {{{brandName}}} eksempels URL. Hvis du ikke har eksemplets URL, skal du kontakte din administrator.',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => 'Touch-ID',
    'LBL_ENABLE_TOUCHID' => 'Enable {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => 'Setup {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'Log på ved hjælp af din finger',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "{{{biometryType}}} is not set up on your device. \n\nGo to your device settings to set up {{{biometryType}}}. Once set up, enable {{{biometryType}}} for {{{brandName}}} in Main Menu > Settings.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'Using {{{biometryType}}} with {{{brandName}}} will allow you to use your biometric identifier instead of entering your password to access {{{brandName}}}.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'Would you like to proceed with {{{biometryType}}}?    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'Enter {{{brandName}}} Password to Enable {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'Opsætning',
    'LBL_MDM_CONFIRM_CHANGE' => 'App-konfiguration er ændret fra Mobile Device Manager. Log venligst på igen for overføre ændringerne.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'Giv venligst {{{brandName}}} adgang til din placering via enhedens indstillinger.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'Nuværende placering er ikke tilgængelig',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "Current location retrieval timed out. \nPlease try again.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'Placeringsmarkører er ikke tilgængelige',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'Lokalitetskoordinater er ugyldige',
    'ERR_MOBILE_INVALID_PASSWORD' => 'Ugyldig adgangskode.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'Din app er forældet og er ikke længere forenelig med det {{{brandName}}} eksempel, du opretter forbindelse til. Ønsker du at opdatere den?',
    'LBL_MOBILE_BY' => 'Af',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'Dette filter er ikke tilgængeligt offline',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'Offline poster',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'Indstillinger for downloads',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'Download dine tildelte, favoritter og poster du følger så du har adgang offline. Du kan opdatere dine præferencer i offline-indstillinger.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'Your records have finished downloading. You can now access them in offline mode.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "Not all your records were downloaded.\n Do you want to try again?",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'Anvend mobildata',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'Ikke lige nu',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'Download er sat på pause og vil fortsætte når du åbner app&#39;en igen.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'Downloader {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'Opdater seneste poster',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'Venter på forbindelse',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'Sat på pause',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'Stopper',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'Download',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'Sæt på pause',
    'LBL_BULK_LOAD_BTN_RESUME' => 'Genoptag',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'Som standard anvendes der kun WiFi-forbindelse',
    'LBL_NPS_RATING_MSG' => "How would you rate your \n{{{productName}}} experience?",
    'LBL_NPS_THANKS_MSG' => 'Tak for din feedback!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'Vil du have noget imod at bedømme den inde i App Store?',
    'LBL_NPS_NO_THANKS' => 'Nej tak',
    'LBL_NPS_NOT_NOW' => 'Ikke nu',
    'LBL_NPS_RATE_NOW' => 'Bedøm nu',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'Netværk ikke tilgængeligt. Du kan stadig anvende app&#39;en offline',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'Dine ændringer vil blive synkroniseret når du er online. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>Se detaljer</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'Ingen data er magler at blive synkroniserede. Kontroller venligst din <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>transaktionslog</a>',
    'LBL_CONVERT' => 'Konverter',
    'LBL_CONVERT_LEAD' => 'Konverter Kundeemne',
    'LBL_SEARCH_EXISTING_RECORD' => 'Søg eksisterende {{{this}}}',
    'LBL_DUPLICATES_CHECK_FAILED' => 'Kontrol for dubletter slog fejl',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'Ønsker du at flytte relaterede aktiviteter til kontaktlisten?',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'Du oprettet kundeemnet {{{name}}}',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'Ingen dubletter fundet.',
    'ERR_LEAD_CONVERSION_FAIL' => 'Konvertering af kundeemne slog fejl',
    'LBL_SELECT_DUPLICATE_RECORD' => 'Vælg fra dublet {{{modulePlural}}}',
    'LBL_SELECTED_EXISTING_RECORD' => 'Valgte {{{moduleSingular}}}',
    'LBL_CREATED_NEW_RECORD' => 'Opret ny {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => 'Returknap',
    'LBL_VO_HOME_BTN' => 'Menuknap',
    'LBL_VO_DASHBOARD_BTN' => 'Dashboard-knap',
    'LBL_VO_SEARCH_BTN' => 'Søgeknap',
    'LBL_VO_RIGHT_MENU_BTN' => 'Knap, højre menu',
    'LBL_VO_ADD_BTN' => 'Tilføj knap',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'Rabat',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'Vælg en mapping app',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'Den valgte {{entityName}} har relaterede værdier: {{localizedFieldNames}}. Annuler for at beholde de eksisterende værdier. Bekræft venligst for at overskrive med nye værdier.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'Datakryptering er aktiveret.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'Valgte kundeemner er allerede konverteret.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'Denne handling er kun tilgængelig, når enheden er online',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'Er du sikker på, at du vil oprette en salgsmulighed fra tilbuddet?',
    'LBL_TAG_ADD' => 'Tilføj tag',
    'LBL_TAG_ENTER_TAG_NAME' => 'Indtast tag',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'Filtrering efter tags understøttes ikke, når enheden er offline.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'Vis hele kommentaren',
    'LBL_COMMENT_VIEW' => 'Vis en kommentar',
    'LBL_PMSE_LABEL_DUEDATE' => 'Forfaldsdato',
    'LBL_PMSE_DUE' => 'Termin',
    'LBL_PMSE_DUE_ON' => 'Forfalder den',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'Opret venligst {{conversionParentModuleName}} først',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'Manglende krævede poster: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'Vælg billedkvalitet. Billedet ændres i overensstemmelse hermed, før det gemmes på serveren. Den valgte værdi vil blive brugt som standard for alle lignende handlinger i fremtiden.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'Estimeret filstørrelse...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'Den estimerede filstørrelse er',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'Billedkvalitet',
    'LBL_IMAGE_QUALITY_BEST' => 'Oprindelig størrelse',
    'LBL_IMAGE_QUALITY_GOOD' => 'God kvalitet',
    'LBL_IMAGE_QUALITY_POOR' => 'Lille størrelse',
    'LBL_IMAGE_QUALITY_BTN' => 'Komprimering: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'Listefelter på {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'Nulstil til standarder',
    'LBL_LIST_NOT_ENOUGH' => 'Vælg venligst mindst 1 aktivt felt.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'Du er nødt til at logge ind og acceptere tilladelser for at kunne arbejde med SugarCRM eksempel.',
    'LBL_SELECTING_EXISTING_RECORD' => 'Valg af {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'Opret ny {{{moduleSingular}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'Billedstørrelse',
    'LBL_COPY_ADDRESS' => 'Kopier adresse',
    'LBL_OPEN_IN' => 'Åbn i',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'Ingen filer valgt.',
    'LBL_ATTACHMENT_ADD' => 'Vedhæft',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'Denne applikation bruger cookies',
    'LBL_USE_COOKIES_CONFIRM' => 'Denne applikation bruger cookies til at hjælpe dig med at give dig en bedre oplevelse. Ved at fortsætte accepterer du brugen af cookies i overensstemmelse med vores privacy policy.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'Du er i gang med at bruge et Sugar eksempel, der ikke være kompatibel med Sugar Mobile i en kommende mobil udgivelse. Bed venligst din administrator om at opgradere Sugar så hurtigt som muligt.',
    'ERROR_TAG_NAME_INVALID' => 'Tag-navn kan ikke indeholde "{{{forbiddenChars}}}" karakterer',
    'ERROR_NO_TAGS_FOUND' => 'Ingen tags tilgængelige, der matcher "{{{searchQuery}}}"',
    'ERR_PA_RECORD_INVALID' => '{{{moduleName}}} optegnelse har en eller flere ugyldige værdier og kan ikke gemmes. Ønsker du at redigere optegnelsen for at udføre {{{actionLabel}}} handling?',
    'ERR_MOBILE_METADATA_RELOAD' => 'En administrator har foretaget konfigurationsændringer i dit Sugar-eksempel. Tryk på OK for at synkronisere din apps konfiguration med serveren.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'Denne applikation bruger cookies',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'Marker for at acceptere (påkrævet)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'Denne applikation bruger cookies til at hjælpe dig med at give dig en bedre oplevelse. Ved at fortsætte accepterer du brugen af cookies i overensstemmelse med vores <a href="{{href}}" target="_blank">privacy policy</a>.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'Postvisningen giver dig mulighed for at se detaljerne i en post.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Notes lader dig samarbejder med andre portal brugere og support repræsentanter.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'Klik her for at tilføje en note til denne post.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'Klik på disse ikoner for at få vist detaljer om vedhæftede noter.',

    //for portal
    'LBL_PORTAL_HOME' => 'Hjem Dashboard',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'Alle åbne sager',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'Nyligt løste sager',
    'LBL_PORTAL_SEARCH' => 'Søg på navn, nummer',
    'LBL_SIGNUP_BUTTON_LABEL' => 'Tilmelding',
    'LBL_PORTAL_NO_EMAIL' => 'Fik du ikke en e-mail?',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'Glemt adgangskode',
    'LBL_PORTAL_FORGOT_USERNAME' => 'Glemt brugernavn',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'Indtast din adgangskode to gange. Adgangskoderne skal matche.',
    'LBL_PORTAL_RESET_PASSWORD' => 'Nulstil adgangskode',
    'LBL_PORTAL_REENTER_PASSWORD' => 'Indtast adgangskode igen',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'Adgangskoder stemmer ikke overens. Indtast venligst igen',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'Din adgangskode er nulstillet.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'En fejl opstod. Start venligst en ny anmodning om nulstilling af adgangskode.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'Registrering',
    'LBL_PORTAL_SIGNUP_TITLE' => 'Tak for din tilmelding',
    'LBL_PORTAL_SIGNUP' => 'Vi informerer dig, når vi har bekræftet dine detaljer.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'Fornavn',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'Efternavn',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'Brugernavn',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'E-mail-adresse',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (valgfrit)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'Land',
    'LBL_PORTAL_SIGNUP_STATE' => 'Stat',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'Firmanavn',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'Job titel (valgfrit)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'Adgangskode',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'Bekræft adgangskode',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'Glemt login',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'Glemt password?',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'Kontakt din Sugar administrator for at få en ny adgangskode.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'Brugernavn',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'Adgangskode',
    'LBL_PORTAL_LOADING' => 'Indlæser ...',
    'LBL_PORTAL_SAVING' => 'Gemmer',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'Siden er ikke tilgængelig',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "Vi beklager, men denne funktion er ikke tilgængelig på dette tidspunkt.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'Vis søgeresultater for "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'Fik du ikke en e-mail?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'Brug venligst enhver af følgende for assistance eller for at kontakte os: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'Telefon: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'E-mail: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'Internettet: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'Er du sikker på du vil fjerne chatten?',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'Opret Note eller Tilføj Vedhæftet Fil',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'Tilføj en Note',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'Dit login mislykkedes. Prøv venligst igen.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'Ugyldige legitimationsoplysninger',
    'LBL_PORTAL_INVALID_GRANT' => 'Din session er udløbet. Log ind igen.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'Session Udløbet',
    'LBL_PORTAL_AUTH_FAILED' => 'Klient autentificering mislykkedes.',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'Ugyldig klient',
    'LBL_PORTAL_INVALID_REQUEST' => 'Anmodningen er ugyldig eller udformet forkert. Kontakt venligst teknisk support.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'Ugyldig anmodning',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'Du er færdig!',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'Forespørgsel timeout',
    'LBL_PORTAL_UNAUTHORIZED' => 'Vi beklager, men det synes du er uberettiget til at få adgang til denne ressource.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'HTTP Fejl: 401 Ikke autoriseret',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'Ressource ikke tilgængelig.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'HTTP Fejl: 403 Forbudt',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'HTTP metode ikke tilladt for denne ressource. Kontakt venligst teknisk support.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP Fejl: 405 Metode ikke tilladt',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'Forespørgsel svigt, eller manglende/ugyldig parameter. Kontakt venligst teknisk support',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'HTTP Fejl: 412',
    'LBL_PORTAL_MIN_MODULES' => 'Som minimum skal du have Sager, Bugs eller Videnbase modul aktiveret for at bruge dette program.',
    'LBL_PORTAL_ERROR' => 'Fejl',
    'LBL_PORTAL_ROUTE_ERROR' => 'Udstedelse under indlæsning af modul. Prøv venligst igen senere, eller kontakt support.',
    'LBL_PORTAL_OFFLINE' => 'Desværre programmet er ikke tilgængelig på dette tidspunkt. Kontakt venligst administratoren.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'Skift adgangskode',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'Brugernavn er allerede registreret i systemet. Enten anmod om en glemt adgangskode eller vælg et andet brugernavn.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'Den indtastede e-mail er ugyldig.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'Adgangskoderne stemmer ikke overens.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'Servicekonsol',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'Oversigt',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'Gendan standardbetjeningspanel',
    'LBL_UNTITLED' => 'Uden titel',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'Fornyelser konsol',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'Oversigt',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'Fase/Status',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'Navn/virksomhedsnavn',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'Omnichannel Dashboard',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'Kunde',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} kl {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'Din browser understøtter ikke SugarLive. Brug Google Chrome eller Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'Et <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> med oplysningerne om din samtale er oprettet.',
    'LBL_OMNICHANNEL_SUBJECT' => 'Emne',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'Beskrivelse',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'Beskedoversigt',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'Opkaldsoversigt',
    'LBL_OMNICHANNEL_LINK_TO' => 'Knyt {{fromModule}} til {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'Link til {{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'Tilknyttet',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'Din browser understøtter ikke chat. Brug Google Chrome eller Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'Kontakt din Sugar-administrator for at få hjælp.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'Konfigurer layout',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'Venligst færdiggør konfigurering af SugarLive, før du foretager et udgående opkald.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'Venligst færdiggør konfigurering af SugarLive, før SugarLive åbnes.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'Sæt dig selv til "Offline" i SugarLive, før du konfigurere SugarLive layout.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'Kompakt visning',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'Fuld Visning',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR-dashboard',
    'LBL_SALES_MANAGER_CONSOLE' => 'Dashboard for salgschef',
    'LBL_SALES_REP_CONSOLE' => 'Dashboard for salgsrepræsentant',
    'LBL_MARKETING_CONSOLE' => 'Dashboard for marketing',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'Dashboard for kundesucces',
    'LBL_EXECUTIVE_CONSOLE' => 'Dashboard for ledere',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'Gendan tab til standard',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'Konfigurer oversigtspanel',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'Brugerprofiler',
    'LBL_WIZ_COMPLETE_TITLE' => 'Installationen er gennemført',
    'LBL_SETUP_COMPLETE_INFO' => 'Begynd at bruge Sugar!',
    'LBL_SETUP_USER_INFO' => 'Setup af dine brugeroplysninger',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'Brugernes indstillinger',
    'LBL_SETUP_USER_LOCALE_INFO' => 'Angiv din tidszone, dato og navn formater',
    'LBL_WIZ_START_SUGAR' => 'Start Sugar',
    'LBL_WIZ_FIRST_NAME' => 'Fornavn',
    'LBL_WIZ_LAST_NAME' => 'Efternavn',
    'LBL_WIZ_EMAIL' => 'E-mail',
    'LBL_WIZ_TIMEZONE' => 'Tidszone',
    'LBL_WIZ_TIMEFORMAT' => 'Tidsformat',
    'LBL_WIZ_DATE_FORMAT' => 'Datoformat',
    'LBL_WIZ_NAME_FORMAT' => 'Navneformat',
    'LBL_SETUP_PROGRESS' => 'Opsætning fremskridt',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar Træning',
    'LBL_WIZ_DOCUMENTATION' => 'Dokumentation',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'Videnbase',
    'LBL_WIZ_FORUMS' => 'Fora',
    'TPL_TIMEZONE_DIFFERENT' => 'Din browsers tidszone ikke passer med din gemte tidszone {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'Juster din tidszone.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'Indstillinger for landestandard',
    'LBL_WIZ_EMAIL_SETTINGS' => 'E-mail indstillinger',
    'LBL_WIZ_IMPORT_DATA' => 'Importer data',
    'LBL_WIZ_CREATE_USERS' => 'Opret brugere',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'Systemindstillinger',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'Studio',

    'LBL_CSP_ERROR_MESSAGE' => 'Værdi(er), du har indtastet, understøttes ikke eller opfylder ikke det acceptable format. Der henvises til en liste over acceptable feltværdier i dokumentationen <a href={{linkToDocumentation}} target="_blank">System</a>.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'Dette indhold er ikke blevet godkendt. Opdater venligst dit systems <a href="{{linkToDocumentation}}" target="_blank"> Indstillinger for indholdssikkerhedspolitik </a>.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'Dette indhold er ikke godkendt. Bed din administrator om at opdatere dit systems <a href="{{linkToDocumentation}}" target="_blank"> Indstillinger for indholdssikkerhedspolitik </a>. Når indstillingerne er opdateret, er du nødt til at opdatere din browser, før ændringerne træder i kraft.',

    // For password related labels
    'LBL_PASSWORD' => 'Adgangskode',
    'LBL_CHANGE_YOUR_PASSWORD' => 'Skift din adgangskode',
    'LBL_PASSWORD_REQUIREMENTS' => 'Adgangskodekrav',
    'LBL_CURRENT_PASSWORD' => 'Nuværende adgangskode',
    'LBL_NEW_PASSWORD1' => 'Ny adgangskode',
    'LBL_NEW_PASSWORD2' => 'Bekræft adgangskode',
    'LBL_PASSWORD_CHANGED' => 'Du har ændret din adgangskode',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'Angiv din bekræftelse af adgangskoden.',
    'ERR_ENTER_NEW_PASSWORD' => 'Angiv din nye adgangskode.',
    'ERR_ENTER_OLD_PASSWORD' => 'Angiv din nuværende adgangskode.',
    'ERR_REENTER_PASSWORDS' => 'Adgangskoderne skal matche.',
    'ERR_PASSWORD_MISMATCH' => 'Adgangskode indtastet matcher ikke det i dit system.',
    'LBL_CANNOT_SEND_PASSWORD' => 'Kan ikke sende adgangskode',
    'LBL_REQUEST_PASSWORD' => 'Bed om adgangskode',
    'LBL_RESET_PASSWORD' => 'Nulstil adgangskode',
    'LBL_RESET_PASSWORD_MESSAGE' => 'Indtast dit brugernavn, og vi sender dig et link til at nulstille din adgangskode.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'Check din e-mail <br><br> V har send instruktioner til nulstilling  af adgangskode til e-mailadresse, vi har stående.
        we have on file.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'Fejl: Der var problemer med at opdatere adgangskoden for denne bruger.',
    'LBL_INCORRECT_PASSWORD' => 'Fejl: Forkert adgangskode.',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'Den adgangskode, du har angivet, opfylder ikke adgangskodekravene. Prøv igen.',
    'LBL_PASSWORD_MIN_LENGTH' => 'Minimunslængden er {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'Maksimumslængden er {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'Skal indeholde ét stort bogstav (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'Skal indeholde ét lille bogstav (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'Skal indeholde ét tal (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'Skal indeholde én specialkarakter (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'Adganskoden må ikke matche det regulære udtryksmønster: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'Foretrukne sprog:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'Kunne ikke sende e-mail med nulstilling af adgangskode.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'Vælg en rapport',
    'LBL_REPORT_AUTO_REFRESH' => 'Automatisk opdatering',
    'LBL_REPORT_EDIT' => 'Rediger valgte Rapport',
    'LBL_REFRESH_LIST_AND_CHART' => 'Opdater liste og diagram',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'Intet diagram tilgængeligt.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'Denne rapport indeholder ikke nogen filtre.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'Du har kun skjulte rin time-filtre, se avancerede filtre.',
    'LBL_RUNTIME_FILTERS' => 'Kørselsfiltre',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'Datoen stemmer ikke overens med brugerens foretrukne datoformat: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'Denne dashlet har ingen kørselsfiltre',
    'LBL_DASHBOARD_FILTER_GROUP' => 'Nyt filter',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'Du skal have valgt mindst én værdi.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'Nulstil til standardfiltre',
    'LBL_COPY_FILTER_SUMMARY' => 'Kopier filteroversigt',
    'LBL_APPLY_FILTERS' => 'Anvend',
    'LBL_REPORTS_FILTERS' => 'Filtre',
    'LBL_RUNTIME_FILTERS_INVALID' => 'Runtime-filtre kan ikke anvendes på grund af ugyldige værdier',
    'LBL_RUNTIME_FILTERS_COPIED' => 'Filteroversigten er blevet kopieret til din udklipsholder.',
    'LBL_ADVANCED_FILTERS' => 'Avancerede filtre',
    'LBL_ADVANCED_OR_DESC' => 'Medtage, når EN HVILKEN SOM HELST betingelse er opfyldt',
    'LBL_ADVANCED_AND_DESC' => 'Medtag, når ALLE betingelse er opfyldt',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'Dette er et originalt designfilter',
    'LBL_AND_UPPERCASE' => 'OG',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'Denne funktion er ikke tilgængelig i forhåndvisning',
    'LBL_REPORT_DEFAULT_NAME' => 'Rapport uden navn',
    'LBL_REPORT_QUERY' => 'Forespørgsel',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'Relateret til aktuelle post',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'Linket felt',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'Linket felt kan ikke være tomt',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'Ingen rapport valgt.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'Kurvediagram er ikke kompatibelt med denne rapport',
    'LBL_REPORT_DASHLET' => 'Rapport Dashlet',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'Datatabel',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'Kørselsfiltre',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'Eksempel på datatabel',
    'LBL_REPORTS_DASHLET_CHART' => 'Diagram',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'Eksempel på diagram',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'Forhåndsvisning af filter',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'Den valgte rapport understøtter ikke et diagram.',
    'LBL_REPORTS_DASHLET_LABELS' => 'Etiketter',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'Vis samlet antal poster',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'Sorter rækkefølge',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'Standardvalgte visning',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'Primær diagrams sorteringsrækkefølge',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'Sekundær diagrams sorteringsrækkefølge',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'Ingen {{module}} link til valgte rapport',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'Ikke tilgængelig for denne rapporttype',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'Denne funktion er kun tilgængelig på fanen diagram',
    'LBL_REPORTS_CHART_TYPE' => 'Diagramtype',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'Søjlediagram Værdi Placering',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'Vis Total',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'Vis Label',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Vis x-akse Etiket',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Vis y-akse Etiket',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Grænse for rækkevisning',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'Du har ikke tilladelse til at bruge disse kørselsfiltre.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'Ukendt',
    'ERR_HTTP_DEFAULT_TITLE' => 'Ukendt fejl',
    'ERR_HTTP_DEFAULT_TEXT' => 'Ukendt fejl.',
    'ERR_HTTP_DEFAULT_ACTION' => 'Gå tilbage til forrige side.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'Fejl: Ugyldig anmodning',
    'ERR_HTTP_400_TEXT_LINE1' => 'Din browser sendte en anmodning, som serveren ikke kunne forstå.',
    'ERR_HTTP_400_TEXT_LINE2' => 'Kontakt din Sugar administrator for flere detaljer.',
    'ERR_HTTP_400_ACTION' => 'Gå tilbage til forrige side.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'HTTP: 404 Ikke fundet',
    'ERR_HTTP_404_TEXT_LINE1' => 'Siden eksisterer ikke eller du har ikke tilladelse til at få adgang til denne side.',
    'ERR_HTTP_404_TEXT_LINE2' => 'Forsøg venligst igen. Hvis fejlen fortsætter, skal du kontakte Suger administratoren.',
    'ERR_HTTP_404_ACTION' => 'Gå tilbage til forrige side.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 Intern Server Fejl',
    'ERR_HTTP_500_TEXT_LINE1' => 'Serveren har fundet en fejl og kunne ikke fuldføre din anmodning.',
    'ERR_HTTP_500_TEXT_LINE2' => 'Forsøg venligst igen. Hvis fejlen fortsætter, skal du kontakte Suger administratoren.',
    'ERR_HTTP_500_ACTION' => 'Venligst kontakt teknisk support.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 500 Intern serverfejl',
    'ERR_HTTP_502_TEXT_LINE1' => 'Serveren har fundet en fejl og kunne ikke fuldføre din anmodning.',
    'ERR_HTTP_502_TEXT_LINE2' => 'Forsøg venligst igen. Hvis fejlen fortsætter, skal du kontakte Sugar administratoren.',
    'ERR_HTTP_502_ACTION' => 'Venligst kontakt teknisk support.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 intern serverfejl',
    'ERR_HTTP_503_TEXT_LINE1' => 'Serveren er ikke tilgængelig til at fuldføre din anmodning.',
    'ERR_HTTP_503_TEXT_LINE2' => 'Forsøg venligst igen. Hvis fejlen fortsætter, skal du kontakte Sugar administratoren.',
    'ERR_HTTP_503_ACTION' => 'Venligst kontakt teknisk support.',

    'ERR_RENDER_FAILED_TITLE' => 'Vis gengivelse mislykkedes',
    'ERR_RENDER_FAILED_MSG' => 'Det lykkedes ikke at gengive en visning',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'Feltet gengivelse mislykkedes',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'Kunne ikke gengive {0} feltet.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'Adgang nægtet',
    'ERR_NO_VIEW_ACCESS_REASON' => 'Du har ikke adgang til denne side.',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'Kontakt din administrator for at anmode om adgang.',
    'ERR_NO_VIEW_ACCESS_MSG' => 'Kontakt din Support Administrator for at få adgang til denne visning for {0} modul.',

    'ERR_LAYOUT_RENDER_TITLE' => 'Layout gengivelse mislykkedes',
    'ERR_LAYOUT_RENDER_MSG' => 'Ups! Vi er ikke i stand til at gengive noget. Prøv venligst igen senere, eller kontakt support.',
    'ERR_INTERNAL_ERR_MSG' => 'Intern fejl',
    'ERR_GENERIC_TITLE' => 'Fejl',
    'ERR_CONTACT_TECH_SUPPORT' => 'Venligst kontakt teknisk support.',

    'LBL_SYNCED_RECURRING_MSG' => 'Du kan ikke redigere denne post, fordi det blev synkroniseret fra en ekstern klient.',
    'LBL_EXISTING' => 'Eksisterende',
    'LBL_PANEL_DEFAULT' => 'Standard',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'Dårlig respons fra serveren',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'Der opstod fejl under handlingen AssignTo.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'Du har ikke adgang til "{{name}}". Kontakt din Administrator.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'År {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'Flere handlinger',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'Alert',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'Ignorer dubletter og gem',
    'LBL_RESTORE' => 'Reset til original',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'Poster markeret til sletning',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'Vi poster, der er relateret til en anmodning om beskyttelse af personlige oplysninger til '
        . 'Slet oplysninger.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS Feed',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'Hold dig opdateret ved at tilføje en ekstern RSS eller Blog Feed.',
    'LBL_RSS_FEED_URL' => 'Feed URL',
    'LBL_RSS_FEED_AUTHOR' => 'Forfatter:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'Antal poster, der kan vises',
    'LBL_ERR_LOADING_RSS_FEED' => 'Fejl i indlæsning af RSS Feed',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'Mine poster',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'Team poster',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'Giver brugerne mulighed for at tilføje Sugar Apps til et dashboard',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'Historie',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'Historie dashlet viser Møder afholdt, Opkald logget, e-mails modtaget og e-mails, der sendes.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'E-mail',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'E-mails',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'Min historie',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'Teamets historie',
    'LBL_UNASSIGNED' => 'Ikke tildelt',
    'LBL_ARCHIVE_EMAIL' => 'Arkivér e-mail',
    'LBL_EMAIL_ARCHIVED' => 'E-mail arkiveret',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'Opret arkiveret e-mail',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'Planlagte aktiviteter',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'Den planlagte aktiviteter dashlet viser planlagte møder og opkald.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'I dag',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'Fremtiden',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'Mine aktiviteter',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'Team Aktiviteter',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'Holdt',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'Er du sikker på, du vil markere {0} som lukket?',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'Aktive opgaver',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Den Aktive Opgaver dashlet viser forfaldne nu, kommende og to-do opgaver.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'Forfaldne nu',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'Kommende',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'At gøre',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'Fuldført',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'Er du sikker på du vil lukke {0} som afsluttet?',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mine opgaver',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team Opgaver',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'Der var en ekstra e-mail på den post, du redigerer. Det er nu den primære og er blevet tilføjet nedenfor.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'Inaktive Opgaver',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'Opgave dashlet viser forsinket og afsluttede opgaver.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'Udskudt',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'Fuldført',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'Sidst ændret {{relativetime}} på {{date}} klokken {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'Mine opgaver',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'Team Opgaver',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'Senest sete sager',

    'LBL_REPORT_DASHLET_TITLE_12' => 'Åbne sager efter bruger og sorteret efter status',
    'LBL_REPORT_DASHLET_TITLE_125' => 'Nye sager efter forretningscenter sorteret efter uge',
    'LBL_REPORT_DASHLET_TITLE_126' => 'Nyligt oprettede sager',
    'LBL_REPORT_DASHLET_TITLE_127' => 'Nye sager efter kundeniveau sorteret efter uge',
    'LBL_REPORT_DASHLET_TITLE_128' => 'Åbne sager efter kundeniveau og prioritet',
    'LBL_REPORT_DASHLET_TITLE_129' => 'Samlede sager løst denne måned af forretningscenter',
    'LBL_REPORT_DASHLET_TITLE_130' => 'Samlede sager løst denne måned af agent',
    'LBL_REPORT_DASHLET_TITLE_131' => 'Liste over nyligt løste sager',
    'LBL_REPORT_DASHLET_TITLE_132' => 'Mine sager løst denne måned sorteret efter uge',
    'LBL_REPORT_DASHLET_TITLE_133' => 'Mine sager forfaldne i dag og forfaldne',
    'LBL_REPORT_DASHLET_TITLE_134' => 'Alle sager forfaldne i dag og forfaldne',
    'LBL_REPORT_DASHLET_TITLE_135' => ' 
Mine åbne sager sorteret efter opfølgningsdato',
    'LBL_REPORT_DASHLET_TITLE_136' => 'Alle åbne sager efter opfølgningsdato',
    'LBL_REPORT_DASHLET_TITLE_137' => 'Mine åbne sager efter status',
    'LBL_REPORT_DASHLET_TITLE_138' => 'Mine sager i de sidste uge efter status',
    'LBL_REPORT_DASHLET_TITLE_139' => 'Status for åbne opgaver tildelt af mig',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST. API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP eller gammel REST. API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron-Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar Workflow',
    'LBL_AUDIT_SUBJECT_USER' => 'Bruger',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web til Kundeemne',

    //common chart strings
    'LBL_CHART' => 'Diagram',
    'LBL_CHART_NO_DATA' => 'Ingen data tilgængelige.',
    'LBL_CHART_LEGEND_CLOSE' => 'Skjul label',
    'LBL_CHART_LEGEND_OPEN' => 'Vis label',
    'LBL_CHART_CONTROLS_CLOSE' => 'Skjul kontrolelementer',
    'LBL_CHART_CONTROLS_OPEN' => 'Vis kontrolelementer',
    'LBL_CHART_UNDEFINED' => 'Udefineret',
    'LBL_CHART_NO_LABEL' => 'Ikke defineret',
    'LBL_CHART_AMOUNT' => 'Beløb',
    'LBL_CHART_COUNT' => 'Antal',
    'LBL_CHART_PERCENT' => 'Procent',
    'LBL_CHART_GROUP' => 'Gruppe',
    'LBL_CHART_DATE' => 'Dato',
    'LBL_CHART_KEY' => 'Nøgle',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'Diagramtype',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'Vis titel',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'Vis total',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'Vis x-akse etiket',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'Vis y-akse etiket',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'Afkryds display metoder',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'Ombryd afkrydsninger',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'Anbring afkrydsninger forskudt for hinanden',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'Rotér afkrydsninger',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'Søjlediagram værdi placering',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'Søjlediagram visningsmuligheder',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'Tillad scrolling',
    'LBL_CHART_CONFIG_STACK_DATA' => 'Stak dataserier',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'Skjul tomme grupper',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'sendt',
    'LBL_EMAIL_RECV' => 'po',

    //record save
    'LBL_RECORD_SAVED' => 'Post gemmes.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'Du har med succes skabt {{moduleSingularLower}} {{name}}.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'Du oprettede {{moduleSingularLower}}.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'Du skabte denne post, men du har ikke tilladelse til at få adgang til dette element.', // use when user has no access to the model
    'LBL_VALIDATING' => 'Validerer...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'Vellykket:',
    'LBL_ALERT_TITLE_WARNING' => 'Advarsel:',
    'LBL_ALERT_TITLE_NOTICE' => 'Bemærk:',
    'LBL_ALERT_TITLE_ERROR' => 'Fejl:',
    'LBL_ALERT_TITLE_LOADING' => 'Indlæser ...',
    'LBL_ALERT_NO_ACCESS' => 'Du har ikke adgang til filtret, der er anvendt til denne dashlet.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'Duplikér dashboardet for at konfigurere denne dashlet med dit eget filter.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'Din browser-version understøttes ikke længere, eller du bruger en ikke-understøttet browser.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'Understøttede platforme',
    'LBL_ALERT_CONFIRM_DELETE' => 'Er du sikker på at du vil slette dette emne?',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'Er du sikker på, at du vil slette disse emner?',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'Den valgte post overskriver følgende værdier: {{values}}. Annuller for at beholde de eksisterende værdier. Bekræft venligst for at overskrive med nye værdier.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'Den valgte {{moduleSingularLower}} har relaterede værdier: {{values}}. Annuler for at beholde de eksisterende værdier. Bekræft venligst for at overskrive med nye værdier.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'Fra:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'Til:',

    //organization chart
    'LBL_ORG_CHART' => 'Organisationsdiagram',
    'LBL_ORG_CHART_DESC' => 'Viser medarbejderen strukturen i din organisation.',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'Skift orientering',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'Vis alle noder',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'Zoom så det passer',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'Resumé af sagen',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'Viser en oversigt over relaterede sager.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'Sammendrag',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'Lukkede sager',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'Åbne sager',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'Top 10 Salgs omsætningsposter',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'Viser top ti omsætning poster i et boblediagram.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'Mine omsætnings poster',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "Mit teams omsætnings poster",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'Standard dato filter',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'Standard datasæt',

    'LBL_PRODUCT_CATALOG_NAME' => 'Produktkatalog',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'Produktkatalog',
    'LBL_PRODUCT_CATALOG_DESC' => 'Se og tilføj elementer fra dit produktkatalog.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'Se og tilføj elementer fra dit produktkatalog.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} på {{date}} på {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'Skriv en note eller træk og slip en vedhæftet fil. Indtast @ for at nævne en bruger. Indtast # for at referere til en post.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'Tilføj din kommentar... Indtast @ for at nævne en bruger. Indtast # for at referere til en post.',
    'LBL_ACTIVITY_STREAM' => 'Aktiviteter',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'Activity Stream er ikke aktiveret',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'Activity Stream er ikke aktiveret for dette modul',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'Flere poster...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'på',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'Min Activity Stream',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'Se en liste over aktiviteter udført på poster og oprette og skrive kommentarer.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'Activity Streams is disabled',

    'LBL_DATA_VIEW' => 'Datavisning',
    'LBL_COMMENT' => 'Kommentar',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'Der opstod en fejl under oprettelse af forbindelse til serveren. Venligst prøv igen.',
    'ERR_RESOLVE_ERRORS' => 'Venligst løse eventuelle fejl før du fortsætter.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'For at kunne godkende, skal alle påkrævede felter være udfyldt; men du kan dog stadig afvise eller sende denne post.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'Alle påkrævede felter skal udfyldes for at kunne afvise/sende.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'Opdater liste',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'Forny fliser',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'mere',
    'LBL_TEXTAREA_LESS' => 'mindre',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} vedhæftede',
    'LBL_CREATE_ATTACHMENT' => 'Opret vedhæftninger',
    'LBL_DASHLET_REFRESH' => 'Opdater',
    'LBL_DASHLET_MOVE' => 'Flyt',
    'LBL_DASHLET_CLOSE' => 'Luk',

    'LBL_DASHLET_FORECAST_NAME' => 'I prognose',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'Prognose diagram',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Prognose diagram',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'Prognose for',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'Viser Prognosediagram for en bestemt tidsperiode',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'Gruppér efter',
    'LBL_DASHLET_FORECASTS_DATASET' => 'Datasæt',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'Prognose detaljer',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'Viser aktuelle prognose detaljer.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'Gemte rapportdiagram Dashlets',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'Viser ethvert diagram fra en gemt rapport.',

    'LBL_QUESTION_MARK' => '?',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'Publicerede relaterede artikler',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'Historisk oversigt',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'Mere historie...',
    'LBL_RELATED_CONTACT' => 'Relateret kontakt',
    'LBL_MODULE_TYPE' => 'Type',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'E-mail til',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'E-mail fra',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'Legacy-moduler kan ikke vises',

    //SFA
    'LBL_BEST' => 'Bedste',
    'LBL_WORST' => 'Værste',
    'LBL_LIKELY' => 'Sandsynlig',
    'LBL_BEST_FORECAST' => 'Forpligtelse (bedste)',
    'LBL_WORST_FORECAST' => 'Forpligtelse (værste)',
    'LBL_LIKELY_FORECAST' => 'Forpligtelse (sandsynlig)',
    'LBL_BEST_ADJUSTED' => 'Justeret forpligtelse (bedste)',
    'LBL_WORST_ADJUSTED' => 'Justeret forpligtelse (værste)',
    'LBL_LIKELY_ADJUSTED' => 'Justeret forpligtelse (sandsynlig)',
    'LBL_AMOUNT_USDOLLAR' => 'Konverterede beløb',
    'LBL_OVERDUE' => 'Forfaldne',

    'LBL_PASSWORD_REQUEST_SENT' => 'Din anmodning er indsendt.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'Der var et problem med at hente dit brugernavn og e-mail-kombination.',

    'LBL_REMINDER_TITLE' => 'Påmindelse',
    'LBL_CLICK_TO_DRILLDOWN' => 'Klik for detaljeret visning',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'Du kan ikke deaktivere alle sprog.',

    'LBL_UPDATE_CALC_FIELDS' => 'Genberegn Værdier',

    //Optimistic Locking
    'LBL_YOU' => 'Du',
    'LBL_RESOLVE_CONFLICT' => 'Løse konflikter for {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'For yderligere oplysninger henvises til {{{more_info_url}}} {{plural_module_name}} dokumentation. {{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'Ingen data tilgængelige',
    'LBL_NEED_HELP' => 'Har du brug for hjælp til noget nyt?',
    'LBL_NEW_CASE' => 'Ny sag',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'Hjælp Dashlet indeholder specifikke oplysninger vedrørende den modul, du ser i øjeblikket sammen med et link til den tilsvarende dokumentation (fx Leads dokumentation) i Application guide for mere information.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'Hjælp til listevisning',
    'LBL_HELP_RECORDS' => "Modul listevisning viser alle elementer som opfylder de nuværende søgekriterier og som brugerne har adgang til. Du kan se de grundlæggende oplysninger om hver post inden i kolonnerne i listevisningen eller klikke på elementets navn for at åbne elementvisningen.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'Listevisning Hjælp',
    'LBL_HELP_RECORD' => 'Denne postvisning giver grundig information om en individuel post samt nogle oplysninger om de poster, der er knyttet til den.

- Rediger denne posts felter ved at klikke på et enkelt felt eller på knappen Rediger.
- Se eller ændre links til andre poster i sub-paneler ved at skifte den nederste venstre rude til "Datavisning".
- Arbejd med brugernes kommentarer og se posten ændre historie ved at skifte den nederste venstre rude til "Activity Stream".
- Følg eller favourite denne post med ikonerne til højre for posten navn.
- Yderligere handlinger er tilgængelige i dropdown menuen Handlinger til højre for knappen Rediger.',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}} Oprettelse',
    'LBL_HELP_CREATE' => 'For at oprette {{plural_module_name}}:
1. Give værdier for felterne som ønsket.
* Felter mærket "Påkrævet" skal være afsluttet, før du gemmer.
*Klik på "Vis mere" for at eksponere yderligere felter, hvis det er nødvendigt.
2. Klik på "Gem" for at færdiggøre den nye post og vende tilbage til {{plural_module_name}} listevisning.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'Potentielle dubletter fundet',
    'LBL_HELP_DUPLICATE' => 'Sugar har registreret, at den post, du forsøger at skabe måske allerede eksisterer. For at ændre en eksisterende post snarere end at skabe en ny, klik på "Vælg og rediger" til højre for den ønskede post. Eventuelle blanke felter på den eksisterende post vil blive udfyldt med de værdier, du lige har indtastet. Klik på "Gem" for at foretage disse ændringer af den eksisterende post. Hvis du i stedet ønsker at bruge de værdier, du lige har indtastet i stedet for værdierne på den eksisterende post, klik på "Reset til original". De indtastede værdier vil derefter blive anvendt til den eksisterende post, og du kan nu fremlægge eventuelle yderligere ændringer, og klik på "Gem" for at færdiggøre ændringer af den eksisterende post. Hvis du vil oprette en ny post ved hjælp af de værdier, du har indtastet, skal du klikke på "Ignorer Duplicate og Gem" øverst til højre på skærmen.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'Mangler SMTP Server-indstillinger',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'For at sende post opgave notifikationer, skal en SMTP-server konfigureres i {{emailSettingsUrl}}.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'E-mail-indstillinger',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'Nye lagerrapporter tilgængelige',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'Nye lagerrapporter er tilgængelige i dit ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'Rapportmodul',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'De er mærket som "Lagerrapport" og kan filtreres. Rapporter er også mærket som "Salg og marketing", "Kundeservice", "Databeskyttelse" eller "Administration" afhængig af indholdet. For yderligere information, se ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'dokumentation',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'For at øge produktiviteten, gør SugarCRM det muligt for superbrugere hurtigt at udføre visse opgaver, ved hjælp af tastaturgenveje. Tabellerne til højre beskriver de tilgængelige genvejstaster, såvel som tastekombinationerne og de handlinger som disse udfører.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>Understøttede taster</h1> <ul><li>alle alfanumeriske tegn og symboler,</li> <li>Skift, ctrl, alt, kommando, mod (ctrl i Windows/Linux og kommando i Mla)</li> <li>enter, esc, mellemrum, tab, pageup, pagedown, end, home, ins, del, backspace</li></ul> <h1>Understøttede funktioner</h1> <ul><li>Tastaturkombination: ctrl + m</li> <li>flere taster: m, ctrl + m</li> <li>tastatursekvens: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'Globale genveje',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'Kontekstuel genveje',
    'LBL_SHORTCUT_KEY_KEY' => 'Tastekombination',
    'LBL_SHORTCUT_FUNCTION' => 'Funktion',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'Konfigurer kontekstuelle genveje',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'Ingen kontekstuelle genveje at konfigurere',
    'LBL_SHORTCUT_HELP' => 'Vis genvej til hjælpeside',
    'LBL_SHORTCUT_QUICK_CREATE' => 'Skift til menuen for hurtig oprettelse',
    'LBL_SHORTCUT_SEARCH' => 'Fokus på globalt søgefelt',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'Skift sidebar',
    'LBL_SHORTCUT_CREATE_RECORD' => 'Opret ny post',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'Vælg næste post på listen',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'Vælg forrige post på listen',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'Scroll liste til venstre',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'Scroll liste til højre',
    'LBL_SHORTCUT_OPEN' => 'Åbent valgte post på listen',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'Rediger valgte post på listen',
    'LBL_SHORTCUT_RECORD_DELETE' => 'Slet post',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'Exit ud af listen inline redigeringstilstand uden at gemme',
    'LBL_SHORTCUT_RECORD_SAVE' => 'Gem post',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'Ryd ud eventuelle ændringer i post',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'Markér post som favorit',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'Følg post',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'Forhåndsvis post',
    'LBL_SHORTCUT_MARK_SELECTED' => 'Markér post som valgt',
    'LBL_SHORTCUT_SELECT_ALL' => 'Vælg alle',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'Åbne masseaktioner rullemenu',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'Fokus på liste filterfeltet',
    'LBL_SHORTCUT_FILTER_CREATE' => 'Opret et nyt liste filter',
    'LBL_SHORTCUT_FILTER_EDIT' => 'Rediger nuværende liste filter',
    'LBL_SHORTCUT_FILTER_SHOW' => 'Åbne liste filter menu',
    'LBL_SHORTCUT_RECORD_EDIT' => 'Rediger post',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'Åbne forrige post',
    'LBL_SHORTCUT_RECORD_NEXT' => 'Åbne næste post',
    'LBL_SHORTCUT_COPY_RECORD' => 'Kopiér nuværende rekord',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'Åbne primær handlings rullemenu',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'Luk skuffe',
    'LBL_SHORTCUT_FILTER_ADD' => 'Tilføj yderligere kriterier for at filtrere',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'Fjern sidste kriterier fra filter',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'Luk filter',
    'LBL_SHORTCUT_FILTER_SAVE' => 'Gem filter',
    'LBL_SHORTCUT_FILTER_DELETE' => 'Slet filter',
    'LBL_SHORTCUT_FILTER_RESET' => 'Nulstil filter',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'Tilføj række',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'Fjern række',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'Luk masse opdatering',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'Opdatere poster',
    'LBL_CREATE_CATEGORY' => 'Opret <div class="btn-link" data-action="create-new">kategori</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'Bekræft',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'Annullér',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'Vælg alle elementer i et multi-valg felt',
    'LBL_SHORTCUT_SWEETSPOT' => 'Skift til bjælken Sweet Spot',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'Skjul Sweet Spot bjælken',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'Gem konfiguration',
    'LBL_SHORTCUT_RESTORE' => 'Gendan standard',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'Der opstod en fejl under lagring af brugerdefinerede genvejstaster på serveren. Prøv venligst igen.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}} Indstillinger',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}} konfigurationsindstillingerne er gemt.',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} Konfigurationsfejl',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} har ingen konfigurationsindstillinger',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'Bruger har ikke adgang til {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'Bruger har ikke adgang til at konfigurere {{module}} indstillinger',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'Database indstillinger for {{module}} skal fastsættes',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'til',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'Start- & slutdato',

    'LBL_CALENDAR_START_DATE' => 'Startdato',
    'LBL_CALENDAR_END_DATE' => 'Slutdato',
    'LBL_CALENDAR_DURATION' => 'Varighed',
    'LBL_CALENDAR_RECURRENCE' => 'Gentagelse',
    'LBL_CALENDAR_REMINDERS' => 'Påmindelser',

    'LBL_CALENDAR_CUSTOM_DATE' => 'Brugerdefineret dato',
    'LBL_CALENDAR_REPEAT_TYPE' => 'Gentag type',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'Gentag interval',
    'LBL_CALENDAR_REPEAT_DOW' => 'Gentag på ugedage',
    'LBL_CALENDAR_REPEAT_ON' => 'Gentag den',
    'LBL_CALENDAR_REPEAT' => 'Gentag',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'Gentag indtil',
    'LBL_CALENDAR_REPEAT_COUNT' => 'Gentag hændelser',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'Gentag valg',
    'LBL_CALENDAR_REPEAT_DAYS' => 'Dag(e) i måneden',
    'LBL_CALENDAR_REPEAT_MONTH' => 'Måned(er) af året',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'Gentag ordenstal',
    'LBL_CALENDAR_REPEAT_UNIT' => 'Gentag enhed',
    'TPL_REPEAT_INTERVAL' => 'Hver {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'Denne serie bruger en Gentag på-indstilling, som ikke er tilgængelig i Sugar, fordi serien blev synkroniseret fra en kalenderklient. Rediger denne serie i din kalenderklient, hvis du gerne vil gentage den på en bestemt dato. Hvis du redigerer denne serie i Sugar, sættes Gentag på til Ingen.<br><br>Vil du fortsætte?',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'Gentagelsesændringer skal foretages ved hjælp af den første post i serien.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'Gentagelsesregler medfører ikke, at der oprettes en begivenhed.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'Deltagelse',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'Afslået',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'Foreløbig',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'Ingen svar',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'Tidsplan ikke tilgængelig',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'Tilgængelige visninger',
    'LBL_CALENDAR_DASHLET_NAME' => 'Kalenderplanlægger',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'Standardvisning',
    'LBL_CALENDAR_MY_CALENDARS' => 'Mine kalendere',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'Bruger- og teamkalendere',
    'LBL_CALENDAR' => 'Kalender',

    'LBL_CALENDAR_DAY' => 'dag',
    'LBL_CALENDAR_WEEK' => 'uge',
    'LBL_CALENDAR_MONTH' => 'måned',
    'LBL_CALENDAR_YEAR' => 'år',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98.',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99.',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'Der opstod en fejl under hentning af tidsplan.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'Gem og send invitationer',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'Acceptér status',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'Processer',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'Processer-dashlet viser de skabeloner, der kan bruges inde i SugarBPM.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'Procesdefinitioner',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'Procesdefinitioner-dashlet viser de skabeloner, der kan bruges inde i SugarBPM.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'Opret procesdefinition',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'Importér procesdefinitioner',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'Proces forretningsregler',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'Procesforretningsregler-dashlet viser de skabeloner, der kan bruges inde i SugarBPM.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'Opret proces forretningsregler',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'Importér procesforretningsregler',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'Proces e-mail-skabeloner',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'Procesmailskabeloner-dashlet viser de skabeloner, der kan bruges inde i SugarBPM.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'Opret proces e-mail-skabeloner',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'Importér proces e-mail-skabeloner',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'Når processer/forretningsregler/e-mail skabeloner udvikles i et andet eksempel i Sugar, anbefaler vi kraftigt, at eksemplet er en nøjagtig klon af dit produktionssystem. Processer/forretningsregler/e-mail skabeloner opbygget i et uafhængigt eksempel i Sugar fungerer muligvis ikke som ønsket efter import af fuldført. Processer/forretningsregler/e-mail skabeloner kan afhænge af en specifik Studio eller anvendelses-niveau ændringer, herunder men ikke begrænset til brugerdefinerede feltnavne, dropdown værdier, database-id&#39;er osv, Hvis disse værdier ikke er identiske med eksemplet, hvor processen/forretningsregel/e-mail-skabelon blev opbygget, skal du muligvis manuelt genopbygge processen/forretningsregel/email skabelonen i dit mål eksempel.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'Vil du stadig gerne fortsætte med denne import?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'Vil du stadig gerne fortsætte med denne eksport?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'Følgende rullelister indeholder ugyldige indstillinger',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'Ventende på aktiviteter via proces',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'Ventende på aktiviteter',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'Ventende på aktiviteter via proces',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'Alle processer',
    'LBL_RECORD_DASHBOARD' => 'Betjeningspanel til optegnelser',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'Processtatus resumé',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'Processtatus beskrivelse',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'I gang',
    'LBL_PMSE_COMPLETED_STATUS' => 'Fuldført',
    'LBL_PMSE_CANCELLED_STATUS' => 'Annulleret',
    'LBL_PMSE_TERMINATED_STATUS' => 'Fratrådt',
    'LBL_PMSE_ERROR_STATUS' => 'Fejl',
    'LBL_PMSE_SETTINGS' => 'SugarBPM-indstillinger',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'Er du sikker på du vil deaktivere denne post?',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'Er du sikker på du vil aktivere denne post?',
    'LBL_PRO_DELETE_CONFIRMATION' => 'Er du sikker på, at du vil slette denne post?',

    'LBL_PRO_ENABLE' => 'Opdatering',
    'LBL_PRO_DISABLE' => 'Opdatering',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} deltager i en proces og kan indeholde nogle låste felter. For at redigere posten, klik her {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'Dette felt er låst, fordi det er involveret i en kørende proces.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'Denne post er deltager i en proces og kan indeholde nogle låste felter.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'Forretningscenter',
    'LBL_BUSINESS_CENTER_ID' => 'Forretningscenter-Id',
    'LBL_BUSINESS_CENTER_NAME' => 'Navn forretningscenter',

    'LBL_PLIS_ACTIVITIES' => 'Købte linjeelementer og aktiviteter',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(Ny tag)',
    'LBL_TAG_FETCH_ERROR' => 'Der opstod en fejl under hentning af tags.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'Sugar 7 kræver JavaScript. Slå Javascript til i din browser for at bruge Sugar 7.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'Serialiserede data kunne ikke fjernes fra serie',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'Serialiserede data kunne ikke fjernes fra serie, fordi de indeholder referencer til objekter eller klasser',

    'LBL_FIELD_TRIMMED' => 'Felt blev beskåret, pga. overstigelse af den maksimale tilladte grænse for tegn.',
    'LBL_FIELDSIZE_OVERFLOW' => 'Feltet overskrider maksimal tegngrænse.',
    'LBL_TINYMCE_TARGET_SAME' => 'Samme vindue',
    'LBL_TINYMCE_TARGET_NEW' => 'Nyt vindue',

    'LBL_OUTBOUND_EMAILS' => 'E-mail indstillinger',
    'LBL_OUTBOUND_EMAIL' => 'E-mail-indstilling',

    'LBL_EMAIL_PARTICIPANTS' => 'E-mail-deltagere',
    'LBL_EMAIL_PARTICIPANT' => 'E-mail-deltager',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'Beskyttelse af personlige oplysninger',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'Beskyttelse af personlige oplysninger',
    'LBL_DATAPRIVACY_VIEW_PII' => 'Se personlige oplysninger',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'Marker til sletning',
    'LBL_DATAPRIVACY_FIELDNAME' => 'Felt',
    'LBL_DATAPRIVACY_VALUE' => 'Værdi',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'Ændret af',
    'LBL_DATAPRIVACY_SOURCE' => 'Kilde',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'Senest opdateret',
    'LBL_DATAPRIVACY_PII' => 'Personlige oplysninger',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'Marker til sletning',
    'TPL_DATAPRIVACY_PII_TITLE' => 'Personlige oplysninger til {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'Skift timere',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'Beskeder',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'Kopieret til dit clipboard!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'Kunne ikke kopieres til dit clipboard',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'Kopier bekræftelseslink',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'Tidslinje',
    'LBL_NO_ACTIVITY' => 'Ingen aktivitet',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} Tidslinje',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'Mere',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'Mindre',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'Tidslinje viser den aktuelle posts relaterede poster og vælger feltopdateringer med tiden.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'Vis mere ...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'Vis mindre ...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'Ingen data tilgængelige',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'Modulet er ikke licenseret.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'Aktive abonnementer',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'Denne dashlet kan kun tilføjes for moduler, som linker til en enkelt konto. Se <a href={{linkToDocumentation}}>Aktive abonnementer-dashlet</a> dokumentation for mere information.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'Vis køb, der tilhører denne tilknyttede konto:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'Aktive abonnementer for en bestemt konto.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => ', mængde {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'I alt:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'Ingen aktive abonnementer',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'For at kunne virke kræver denne dashlet {{module_name}}. Tal med din administrator om aktivering af {{module_name}}.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'Købshistorik',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'Alle køb for en bestemt konto.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'Denne dashlet kan kun tilføjes for moduler, som er knyttet til en enkelt konto. Find flere oplysninger i dokumentationen <a href={{linkToDocumentation}} target="_blank">Købshistorik-dashlet</a>.',
    'LBL_NO_PURCHASE_HISTORY' => 'Intet køb til visning',
    'LBL_NO_PLIS' => 'Ingen købte produkter',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'I alt',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'Antal',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'Denne dashlet har brug for, at Køb og købte produkter fungerer. Bed din administrator om at aktivere Køb og købte produkter.',
    'LBL_SEARCH_PURCHASE_NAME' => 'Søg efter købsnavn ...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'Brug Studie til at redigere optagelsesvisning af dashlet-layout ved at gå til' .
        'Studio > {{module}} > Layouts > Postvisning-dashlet. <a href={{linkToStudio}}>Rediger i Studio</a>.',
    'LBL_SERVICE_LEVEL' => 'Serviceniveau',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'Antal',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'Opfølgning',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'Prioritet/Status',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'Emne/Beskrivelse',

//Service Duration
    'LBL_SERVICE_DURATION' => 'Servicevarighed',
    'LBL_SERVICE_DURATION_VALUE' => 'Servicevarighed værdi',
    'LBL_SERVICE_DURATION_UNIT' => 'Servicevarighed enhed',
    'LBL_LOCK_DURATION' => 'Låsevarighed',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Amazon Connect CCP kunne ikke indlæse. Venligst' .
        'sørg for, at du bruger en ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">understøttet browser</a>. ' .
        'Hvis problemet fortsætter, bedes du kontakte din Sugar-administrator.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'Din Sugar-administrator har ikke konfigureret din hændelse for Amazon Connect.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'Kan ikke etablere forbindelse med Amazon Connect. Du bedes kontakte din Sugar Administrator for hjælp.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'Ukendt',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'Fokusskuffe',
    'LBL_CLOSE_FOCUS_DRAWER' => 'Luk fokusskuffe',
    'LBL_EXTERNAL_GUESTS' => 'Eksterne gæster',
    'LBL_MY_FAVORITE_TASKS' => 'Mine favoritopgaver',
    'LBL_RECORD' => 'Post',

    'LBL_MY_TASKS' => 'Mine opgaver',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'Kunne ikke finde feltet: {0} i modul: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'Kunne ikke finde register med {0}: {1} i modul: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'Kunne ikke finde en relation med navnet: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'En database-indtastning af id: {0}, med {1}: {2} i modul: {3} eksisterer allerede',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'blødt slettet (med slettet flag = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'Fandt flere databaseregistre for {0} {1} på modul {2}. ' .
        'Du bedes også fjerne eller opdatere de matchende registre. Matchende registre: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'Næste kørsel',
    'LBL_TIME_AWARE_TYPE' => 'Type',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean-id',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'Vis etiket',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'Åben Visningen af Post',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'Tilføj',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'Hjælpen er ikke tilgængelig',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'Funktioner',
    'LBL_ACTIONBUTTON_FIELDS' => 'Felter',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'Vælg felt...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'Rollup',
    'LBL_ACTIONBUTTON_RELATED' => 'Relateret',
    'LBL_ACTIONBUTTON_SAVE' => 'Gem',
    'LBL_ACTIONBUTTON_CANCEL' => 'Annullér',
    'LBL_ACTIONBUTTON_R_MODULE' => 'Relateret modul',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'Relateret felter',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'Rollup-modul',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'Rollup-felter',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'Rollup-funktion',
    'LBL_ACTIONBUTTON_MINIMUM' => 'Min',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'Maks',
    'LBL_ACTIONBUTTON_AVERAGE' => 'Gennemsnit',
    'LBL_ACTIONBUTTON_SUM' => 'Sum',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'Tildel post',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'Skriv Email',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'Opret Post',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Dokumentfletning',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'Åben Url',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'Kør rapport',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'Opdater post',
    'LBL_ACTIONBUTTON_ACTION' => 'Handling',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'Tildel til',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'E-mail til',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'Brug PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'Skabelon',
    'LBL_ACTIONBUTTON_MODULE' => 'Modul',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'Skærmindstillinger',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'Type',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'Rulleliste',
    'LBL_ACTIONBUTTON_BUTTON' => 'Knap',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'Knapgruppe',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'Vis Etiket på Post',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'Vis i Overskrift',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'Skjul på Rediger',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'Vis i fokusskuffen Overskrift',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'Dashboard',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'Fokusskuffen Overskrift',
    'LBL_ACTIONBUTTON_SIZE' => 'Størrelse',
    'LBL_ACTIONBUTTON_DEFAULT' => 'Standard',
    'LBL_ACTIONBUTTON_SMALL' => 'Lille',
    'LBL_ACTIONBUTTON_LARGE' => 'Stor',
    'LBL_ACTIONBUTTON_CALCULATED' => 'Beregnet',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'Konverter til PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'Dokumentfletning',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'Forhåndsvisning',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'Egenskaber',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'Etiket',
    'LBL_ACTIONBUTTON_DESC' => 'Værktøjstip',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'Vis Etiket',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'Vis Ikon',
    'LBL_ACTIONBUTTON_SCHEME' => 'Farvetema',
    'LBL_ACTIONBUTTON_ICON' => 'Ikon',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'Afhængig',
    'LBL_ACTIONBUTTON_DESIGN' => 'Layoutkonfiguration',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'Stop ved fejl',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'Gem Automatisk',
    'LBL_ACTIONBUTTON_CONFIG' => 'Konfiguration',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'Konfigurer venligst din ActionButton, før du gemmer.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'Konfigurer knapper',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'Opret Automatisk',
    'LBL_ACTIONBUTTON_LINK' => 'Opret forhold til overordnet',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'Kopier Overordnede Værdier',
    'LBL_ACTIONBUTTON_PRESET' => 'Indstil feltværdier',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'Kopiér feltværdier fra overordnet',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'Vælg...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'Fra Original Felt ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'Er du sikker på, at du vil slette denne knap?',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'Er du sikker på, at du vil slette denne handling?',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'Ugyldig handlingsknap-data',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'Vælg et modul inden du gemmer.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'Vælg et link inden du gemmer. Hvis der ikke findes noget link, skal du fjerne markeringen i linkindstillingen.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'Vælg en post, før du gemmer.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'Vælg en skabelon inden du gemmer.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'Primær',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'Sekundær',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'Ocean',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'Lyserød',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'Hær',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'Blågrøn',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'Stillehavet',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'Grøn',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'Gul',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'Orange',
    'LBL_ACTIONBUTTON_THEME_RED' => 'Rød',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'Koral',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'Lilla',
    'LBL_ACTIONBUTTON_FORMULA' => 'Formel',
    'LBL_ACTIONBUTTON_ACTIONS' => 'Handlinger',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'Fejl ved validering af knapdata.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'Knapper skal som minimum have en etiket eller et ikonsæt.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'Indtast venligst en gyldig knapbetegnelse.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'Registreringen kunne ikke oprettes, fordi der mangler de krævede værdier. Kontakt venligst din administrator.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'Du skal have mindst to aktive knapper for denne knaptype.',
    'LBL_ACTIONBUTTON_RECORD' => 'Postvisninger',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'Handlingsmenuer',
    'LBL_ACTIONBUTTON_ORDER' => 'Ordre',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'Listevisning',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'Registrér Vis overskrift',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'Registrér Vis Dashlet-overskrift',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'Underpaneler',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'Udførelsesmotoren til opgavesekvensen kunne ikke udføre følgende handlinger: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'Tilføj en handling',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'Fjern denne handling',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'Aktuel bruger',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'Flet skabelon',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'Flet skabelon til PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'Virksomhedsstørrelse',
    'LBL_HINT_COMPANY_INDUSTRY' => 'Branche',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'Branchemærker',
    'LBL_HINT_COMPANY_LOCATION' => 'Virksomhedsplacering',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'Virksomhedsbeskrivelse',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'Stiftelsesår',
    'LBL_HINT_COMPANY_FACEBOOK' => 'Virksomhedens Facebook',
    'LBL_HINT_COMPANY_TWITTER' => 'Virksomhedens Twitter',
    'LBL_HINT_COMPANY_PIC' => 'Virksomhedslogo',
    'LBL_HINT_CONTACT_PIC' => 'Kontaktfoto',
    'LBL_HINT_COMPANY_WEBSITE' => 'Virksomhedens websted',
    'LBL_HINT_PHOTO' => 'Fotolink',
    'LBL_HINT_JOB_2' => 'Tidligere jobs',
    'LBL_HINT_EDUCATION' => 'Uddannelse',
    'LBL_HINT_EDUCATION_2' => 'Yderligere uddannelse',
    'LBL_HINT_TWITTER' => 'Twitter-link',
    'LBL_HINT_FACEBOOK' => 'Facebook-link',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS-kode',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC-kode',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'Skatteårs afslutning',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'Årlig omsætning',
    'LBL_HINT_PHONE_1' => 'Telefon 1',
    'LBL_HINT_PHONE_2' => 'Telefon 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'Sammenføj tabel',
    'LBL_HINT_FULL_NAME' => 'Fuldt navn',
    'LBL_HINT_JOB_TITLE' => 'Stillingsbetegnelse',
    'LBL_HINT_OFFICE_PHONE' => 'Kontortelefon',
    'LBL_HINT_MOBILE_PHONE' => 'Mobil',
    'LBL_HINT_OTHER_PHONE' => 'Anden telefon',
    'LBL_HINT_WEBSITE' => 'Websted',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'Vil du overskrive alle de eksisterende data for denne post med de nye data fra Sugar Hint?',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'Vil du overskrive det eksisterende {{fieldName}} for denne post med det nye {{fieldName}} fra Sugar Hint?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'Alle kontorelaterede data fjernes. Vil du fortsætte?',
    'LBL_HINT_COMPANY_LOGO' => 'Logo',
    'LBL_HINT_CONTACTS_AVATAR' => 'Foto',
    'LBL_HINT_ACCOUNTSETS' => 'Mærker for Suagr Hint-kontosæt',

    'LBL_HINT_LOADING' => 'Indlæser ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'Afinstallerer Sugar Hint. Vent',
    'LBL_HINT_VALUE_ERASED' => ' Værdi slettet ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'Disse oplysninger er blevet slettet via anmodning om beskyttelse af personlige oplysninger',

    'LBL_HINT_UNINSTALL_TITLE' => 'Vælg én af nedenstående valgmuligheder for afinstallation:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'Afinstallér kun Hint-pakke',
    'LBL_HINT_UNINSTALL_FULL' => 'Afinstallér Hint fuldstændigt',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'Denne valgmulighed fjerner Hint MLP og deaktiverer alle aktive abonnementer på Sugar Hint Insights.
    Hvis Hint installeres igen, aktiverer det abonnementer igen automatisk.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'Denne valgmulighed udfører en fuld afinstallation af Hint, herunder fjernelse af MLP og sletning af alle konfigurations- og abonnementsoplysninger.',
    'LBL_HINT_UNINSTALL' => 'Afinstallér',
    'LBL_HINT_UNINSTALL_HEADER' => 'Afinstallér Sugar Hint',
    'LBL_HINT_CANCEL' => 'Annullér',
    'LBL_HINT_UNINSTALL_WARNING1' => 'ADVARSEL: Vælg denne valgmulighed, hvis du ikke har til hensigt at bruge Hint igen i fremtiden.
    Inden afinstallationen udføres, skal du gennemføre en fuld sikkerhedskopiering af din Sugar-database og indstille Sugar til vedligeholdelsestilstand. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'Se ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Vejledning til Sugar Hint-administration ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'for at se oplysninger om afinstallationsprocessen.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'Vil du kun afinstallere Sugar Hint-pakken?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'Vil du afinstallere Sugar Hint fuldstændigt?',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(BEMÆRK: DU KAN IKKE FORTRYDE DENNE HANDLING)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint-felter',
    'LBL_HINT_NO_RESULTS_MSG' => 'Ingen resultater blev fundet.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'Basislayout for Hint-panel',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'Konti',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'Kontakter',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'Kundeemner',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'Udvidet layout for Hint-panel',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'Omarrangér felterne ved at trække og slippe inden for ovenstående sektioner i Hint-panelets layout.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'Find detaljerede anvisninger og en liste over standardfelter i ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' for at gendanne standardindstillinger for ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'modul.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'Vil du gendanne standardværdierne for modulet {{module}}?',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'Klik her',
    'LBL_HINT_CONFIG_NAME' => 'Vejledning til Hint-administration.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'Felter',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'Berigede felter',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'Dette afsnit opfører alle Hint-felter og Sugar-felter, der beriges af Hint. Hint-felter er markerede med en stjerne (*) og kan kun vises i Hint-panelet, hvis de beriges.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'Feltnavn',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'Berig felt',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'Vis i Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'Vis i Hint-panel',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'Yderligere Sugar-felter',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'Dette afsnit opfører alle Sugar-felter, der ikke beriges af Hint.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'Advarsel',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'Forsigtig: Du er ved at synkronisere til tjenesten Sugar Hint Insights. Alle afventende e-mailsammenfatningshistorier vil gå tabt, og eksisterende nyheder vil blive ryddet fra Insights-dashlet. Meddelelser af alle typer genoptages, når synkroniseringen er gennemført.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'Foreslåede virksomheder i forhold til dit {{_moduleSingular}} opføres herunder. Vælg virksomhedsdata til visning.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'Ingen konto er valgt',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'Der er fundet flere e-mails. Vælg e-mails til import: ',

    'LBL_HINT_HELP_MESSAGE1' => 'Baseret på de indtastede data kunne Hint ikke finde et matchende resultat i systemet.',
    'LBL_HINT_HELP_MESSAGE2' => 'De bedste resultater i Hint kan findes med en persons navn og e-mailadresse.',
    'LBL_HINT_HELP_MESSAGE3' => 'De bedste resultater i Hint kan findes med Url&#39;en til virksomhedens websted.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "Indtast dit {{_moduleSingular}}s virksomhedsnavn eller websted, hvorefter Hint søger efter yderligere data.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "Indtast dit {{currentModule}}s e-mailadresse, hvorefter Hint søger efter yderligere data.",

    'LBL_HINT_HISTORY_NONE' => 'Ingen data tilgængelige for historisk visning',
    'LBL_HINT_HISTORY_TITLE' => 'Aktivitetshistorik',

    'LBL_HINT_PREVIEW_TITLE' => 'Databerigelse',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Licensen til din Hint-tjeneste er udløbet. Kontakt din SugarCRM-administrator for at forny din licens.',
    'LBL_HINT_PREVIEW_QUESTION' => 'Vil du se, hvad Hint kan gøre for dig og din virksomhed? Kontakt din SugarCRM-administrator for at tilføje Hint.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'Kontooplysningerne blev ikke fundet',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'Berigede data fundet - klik for at gemme alle berigede data i dit register.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'Klik for at gemme berigede data i dit register.',

    'LBL_HINT_CONTACTS_TITLE' => 'Tilknyttede kontakter',
    'LBL_HINT_CONTACTS_NONE' => 'Ingen tilknyttede kontakter',

    'LBL_HINT_NEWS' => 'Nyheder',
    'LBL_HINT_GENERAL' => 'Generelt',
    'LBL_HINT_ALL_NEWS' => 'Alle nyheder',
    'LBL_HINT_FILTER_NEWS' => 'Filtrér nyheder',
    'LBL_HINT_FINANCIAL_NEWS' => 'Finans',
    'LBL_HINT_PERSONNEL_NEWS' => 'Personale',
    'LBL_HINT_PRESS_RELEASES' => 'Pressemeddelelser',
    'LBL_HINT_OTHER_NEWS' => 'Andet',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'Søg efter nyhedsartikler',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'Ingen nyheder tilgængelige',
    'LBL_NEW_NOTIFICATIONS' => 'Nye meddelelser',
    'LBL_HINT_DASHLET_ALLOWED1' => 'Du skal have en Sugar Hint-licens for at se Sugar Hint Insights-dashlet.
    Bed din administrator om anskaffelse af en Sugar Hint-licens.',

    'LBL_HINT_FOR' => 'For',
    'LBL_HINT_WITH' => 'med',
    'LBL_HINT_SHOW_ME' => 'Vis mig: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'Underret mig pr.: ',

    'LBL_NOTIFICATIONS_TITLE' => 'Præferencecenter i Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'Tast til præferenceindstillinger',
    'LBL_HINT_PREFERENCES' => 'Præferencer',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'Sletning deaktiveret. Der kræves som minimum én præferenceerklæring',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'Tilføjelse deaktiveret. Du har nået det maksimale antal præferenceerklæringer',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'Inkludér i Sugar Hint Insights-dashlet',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'Vis som meddelelse på skrivebordet',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'Meddelelser skal være aktiverede på alle browsere og på alle stationære computere, så meddelelser modtages konsekvent.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'Nogle browsere som Internet Explorer understøtter ikke meddelelser. Meddelelser kan ikke aktiveres, når der bruges en browser, der ikke understøtter meddelelser.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'Send øjeblikkelig e-mailbesked for hver meddelelse',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'Send en daglig e-mailsammenfatning',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'Send en ugentlig e-mailsammenfatning',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'Præferencer kunne ikke gemmes. Kontrollér dit systems forbindelse, og prøv igen.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'Nogle obligatoriske felter mangler en værdi. Kontrollér dine præferencer, og sørg for, at alle obligatoriske felter er udfyldt.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'Du er ved at aktivere browsermeddelelser for Sugar Hint Insights. Klik på Bekræft for at gå videre. Din browser beder dig så om tilladelse til at modtage meddelelseshændelser.',
    'LBL_HINT_PUSH_ERROR' => 'Pluginet Pushmeddelelser er blevet registreret for {{options.type}} uden dettes afhængigheder. Pluginet fungerer ikke som forventet. Sørg for at angive en sti til arbejderfilen og en metode til at gemme abonnementet på serveren.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'Slå Hint-meddelelser til for alle brugere',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'Slå Hint-meddelelser fra for alle brugere',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'ADVARSEL: Deaktivering af meddelelser under afinstallation af Sugar Hint mislykkedes. Hvis du vil deaktivere meddelelser, skal du installere Sugar Hint 5.4.0 eller nyere og udføre en fuld afinstallation ved hjælp af installationsprogrammet til Sugar Hint, der findes i afsnittet Administration i Sugar.',
    'LBL_HINT_ENRICH_ALL' => 'Berig alle',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'Hint-licens påkrævet',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'Konfiguration af kort',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'Geocode logfremviser',
    'LBL_MAP_MAP' => 'Kort',
    'LBL_MAP_MAPS' => 'Kort',
    'LBL_MAP_GEOCODING_RECORD' => 'Geokode',
    'LBL_MAP_GEOCODE_SUCCESS' => 'Post er blevet geokodet.',
    'LBL_MAP_LATITUDE' => 'Breddegrad',
    'LBL_MAP_LONGITUDE' => 'Længdegrad',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'Søg efter adresse ...',
    'LBL_MAP_ALREADY_GEOCODED' => 'Den aktuelle post er allerede geokodet. Vil du overskrive geokodningen for denne post?',
    'LBL_MAPS_MANUAL_GEOCODING' => 'Manuel geokodning',
    'LBL_MAP_POINT_COORDINATES' => 'Koordinater for kortpunkt',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'Beregner den optimale rute ...',
    'LBL_MAP_DIRECTIONS' => 'Anvisninger',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'Anvisninger, der starter fra den aktuelle bruger',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'Anvisninger, der starter fra denne post',
    'LBL_MAPS_RADIUS_INPUT' => 'Radius (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'i en radius fra postnummer',
    'LBL_MAPS_DISTANCE' => 'Afstand',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'Postnummer',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'Ugyldig konfiguration: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => 'Tilknytninger for feltet <strong>{{module}}</strong> er ugyldige.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'Korttype',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'Zoomniveau',
    'LBL_MAPS_DASHLET' => 'Kort',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'Viser geokodede poster på kortet.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'Kort er ikke tilgængelige for dette modul. Aktivér det i konsollen Administrator.',
    'LBL_MAP_MODULES' => 'Modul',
    'LBL_MAP_FILTER_BY' => 'Filtrér efter',
    'LBL_MAP_UNIT_TYPE' => 'Enhedstype',
    'LBL_MAP_UNIT_TYPE_MILES' => 'Miles',
    'LBL_MAP_UNIT_TYPE_KM' => 'Kilometer',
    'LBL_MAP_ADDRESS' => 'Adresse',
    'LBL_MAP_NO_STARTING_POINT' => 'Startpunkt er ikke geokodet.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'Post med startpunkt er ikke geokodet.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'Nogle af de valgte poster er ikke geokodede og vises ikke på kortet.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'Poster er ikke geokodede.',
    'LBL_MAPS_MODULE_FIELDS' => 'Modulfelter',
    'LBL_MAPS_SELECT_FIELD' => 'Vælg felt',
    'LBL_MAPS_RELATE_RECORD' => 'Tilknyttet post',
    'LBL_MAPS_MAPPING_TYPE' => 'Tilknytningstype',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'Ingen geokodede poster',
    'LBL_MAPS_ADDRESS' => 'Adresse',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'Tildelt bruger',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'Visning af gadeside er ikke tilgængelig for det givne punkt',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> poster er ikke gyldige til tilknytning. Fjern modulet fra listen.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'Luk',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'Udvid',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'Gem son PDF',
    'LBL_MAPS_EMAIL_LINK' => 'E-maillink',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'Du skal have mindst én geokodet post.',
    'LBL_MAPS_GENERATING' => 'Genererer kort ...',
    'LBL_MAPS_POINTS' => 'Tilknyt punkter',
    'LBL_MAPS_POINT' => 'Punkt',
    'LBL_MAPS_TRAVEL_DETAILS' => 'Rejseoplysninger',
    'LBL_MAPS_TOTAL_DISTANCE' => 'Afstand i alt',
    'LBL_MAPS_TOTAL_DURATION' => 'Samlet varighed',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'Samlet varighed uden trafik',
    'LBL_MAPS_ITINERARY' => 'Rejseplan',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'Rejseafstand',
    'LBL_MAPS_TRAVEL_DURATION' => 'Rejsevarighed',
    'LBL_MAPS_TRAVEL_STEPS' => 'Trin',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'Advarsler',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'Bing Kort understøtter maksimalt 10 observerede positioner på et delt kort. Gennemgå dit valg.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'Licens til Kort er påkrævet',
    'LBL_MAPS_SHARE_HELLO' => 'Hej,',
    'LBL_MAPS_SHARE_HEADER' => 'Du har anmodet om et Bing-kort for følgende punkter:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'Følgende URL åbner et kort med de ovennævnte punkter på Bing Maps:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'Vis kort på Bing Maps',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'Bing Maps',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'Der blev ikke fundet nogen rute for de angivne rutepunkter.',
    'LBL_MAPS_GEOCODE_STATUS' => 'Geokode status',
    'LBL_MAPS_GEOCODED' => 'Geokodet',
    'LBL_MAPS_NOT_GEOCODED' => 'Ikke geokodet',
    'LBL_MAPS_NOT_FOUND' => 'Ugyldig adresse',
    'LBL_MAPS_GEOCODING_FAILED' => 'Geokodning fejlede',
    'LBL_MAPS_QUEUED' => 'I kø',
    'LBL_MAPS_REQUEUED' => 'Sat i kø',
    'LBL_MAPS_RELATED_RECORD' => 'Tilknyttet post',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'Vis rapport',
    'LBL_REPORT_DASHLET_DESC' => 'Vis en gemt rapport',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'Nulstil til Dashlet-standardindstillinger',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'Nulstil til rapport-standardindstillinger',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'Opdater resultater',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'Kopier diagram til udklipsholder',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'Download diagram',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'Rapporten for dashlet {{label}} blev redigeret, og dashlet er nulstillet til standardkonfigurationen.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'Du har ikke tilladelse til at bruge dette felt.',

    'LBL_INVALID_FORMULA' => 'Ugyldig formel',
    'LBL_RETURN_TYPE_MISSMATCH' => 'Funktionens returtype stemmer ikke overens',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'Prognose',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'Ideel kundeprofil',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'Luk uge forudsigelsesscore',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'Forudsigelsesværdi',
    'LBL_AI_CONV_BIN_ACCURACY' => 'Forudsigelse Bin Nøjagtighed',
    'LBL_AI_CONV_MULTIPLIER' => 'Forudsigelsesmultiplikator',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP-værdi',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP Bin nøjagtighed',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP-multiplikator',
    'LBL_AI_NEW' => 'Ny',
    'LBL_AI_ENTERED' => 'Indtastet',
    'LBL_AI_CREATED' => 'Oprettet',
    'LBL_AI_WEEK' => 'Uge',
    'LBL_AI_MONTH' => 'Måned',
    'LBL_AI_QUARTER' => 'Kvartal',
    'LBL_AI_BYWEEK' => 'efter uge',
    'LBL_AI_BYMONTH' => 'efter måned',
    'LBL_AI_BYQUARTER' => 'efter kvartal',
    'LBL_AI_WEEKTREND' => 'Ugentlig trend',
    'LBL_AI_MONTHLYTREND' => 'Månedlig trend',
    'LBL_AI_QUARTERTREND' => 'Kvartalsvis trend',
    'LBL_AI_TREND' => 'Trend efter',
    'LBL_AI_TRENDS' => 'Trends efter',
    'LBL_AI_VELOCITY' => 'Hastighed',
    'LBL_AI_TOPX' => 'Top {X}',
    'LBL_AI_TIMESPAN' => 'Tidsperioder mellem faser -',
    'LBL_AI_BUSINESSTREND' => 'med forretningstrends',
    'LBL_AI_SUGARINSIGHTINTRO' => 'Vi præsenterer Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights udnytter kvantitativ analyse til at generere nye indsigter i dine SugarCRM-data. Hos Sugar er vi altid på udkig efter nye måder til at hjælpe dig med at udnytte dine data fuldt ud, træffe oplyste beslutninger, og dette er blot starten af det, som vi håber på at kunne tilbyde med Sugar Insights.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights udnytter kvantitativ analyse til at generere nye indsigter i dine SugarCRM-data.',
    'LBL_AI_FIRMO' => 'Firmografi',
    'LBL_AI_TOTALCOUNT' => 'Samlet antal',
    'LBL_AI_DAYSFROMLATESTACT' => 'Antal dage siden sidste',
    'LBL_AI_DAYSSINCE' => 'alder',
    'LBL_AI_FIELDISSET' => 'findes',
    'LBL_AI_CONTACTCOMPLETENESS' => 'Fuldstændighed af kontaktoplysninger',
    'LBL_AI_CUTDATE' => 'Forudsigelsesperiode',
    'LBL_AI_FROMLASTCHANGE' => 'Antal dage fra sidste ændring af funktionsværdi',
    'LBL_AI_CALLSHELD' => 'Samlet antal tilbageholdte opkald',
    'LBL_AI_CALLSPLANNED' => 'Samlet antal planlagte opkald',
    'LBL_AI_OUTBOUNDCALLS' => 'Samlet antal udgående opkald',
    'LBL_AI_INBOUNDCALLS' => 'Samlet antal indgående opkald',
    'LBL_AI_AVGCALLDURATION' => 'Gennemsnitlig varighed af opkald',
    'LBL_AI_EMAILSARCHIVED' => 'Samlet antal arkiverede e-mails',
    'LBL_AI_EMAILSREAD' => 'Samlet antal læste e-mails',
    'LBL_AI_EMAILSSENT' => 'Samlet antal sendte e-mails',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'Samlet antal poster, hvor Forventet lukkedato er ændret til en senere dato',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'Samlet antal poster, hvor Forventet lukkedato er ændret til en tidligere dato',
    'LBL_AI_AMOUNTINCREASED' => 'Samlet antal salgsmuligheder, hvor beløbet blev øget',
    'LBL_AI_AMOUNTDECREASED' => 'Samlet antal salgsmuligheder, hvor beløbet blev reduceret',

    // User last state
    'LBL_LAST_STATE' => 'Sidste tilstand',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'Send til DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'Annuller redigering af modtager',
    'LBL_RECIPIENT_ROLE' => 'Modtagers rolle',
    // Base sales stages
    'LBL_OPEN' => 'Åbn',
    'LBL_CLOSED_WON' => 'Lukket vundet',
    'LBL_CLOSED_LOST' => 'Lukket tabt',
    'LBL_KIOSK_ADD_FILES' => 'Tilføj filer',
    'LBL_KIOSK_ADD_DROP_FILES' => 'Tilføj eller drop filer her',
    'LBL_KIOSK_CANCEL' => 'Annuller',
    'LBL_KIOSK_EDIT' => 'Rediger',
    'LBL_KIOSK_EMAIL' => 'E-mail',
    'LBL_KIOSK_FILES_UPLOADING' => 'Uploader',
    'LBL_KIOSK_FILES_ERROR' => 'Attachment mislykkedes at uploade',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'Den vedhæftede fil er for stor',
    'LBL_KIOSK_FILTER_SEARCH' => 'Søg',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'Kiosk',
    'LBL_KIOSK_LANGUAGE' => 'Sprog',
    'LBL_KIOSK_LAST_UPDATED' => 'Sidst opdateret',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'Visning',
    'LBL_KIOSK_MENU' => 'Menu',
    'LBL_KIOSK_MOBILE_PHONE' => 'Mobiltelefon',
    'LBL_KIOSK_MY_ACTIVITIES' => 'Mine aktiviteter',
    'LBL_KIOSK_MY_PROFILE' => 'Min profil',
    'LBL_KIOSK_NAME' => 'Navn',
    'LBL_KIOSK_OFFICE_PHONE' => 'Kontortelefon',
    'LBL_KIOSK_ORGANIZATION' => 'Organisation',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'Rækker pr. side:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'Drevet af SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'Gem ændringer',
    'LBL_KIOSK_SHOW_HIDE' => 'Vis/skjul',
    'LBL_KIOSK_SIGN_IN' => 'Log ind',
    'LBL_KIOSK_SIGN_OUT' => 'Log ud',
    'LBL_KIOSK_SORT_BY' => 'Sortér efter',
    'LBL_KIOSK_SUBMIT' => 'Indsend',
    'LBL_KIOSK_TIMEZONE' => 'Tidszone',
    'LBL_KIOSK_ACTIVITY' => 'Aktivitet',
    'LBL_KIOSK_NO_ACTIVITY' => 'Ingen aktivitet at vise',
    'LBL_KIOSK_OLDEST_FIRST' => 'Ældste først',
    'LBL_KIOSK_NEWEST_FIRST' => 'Nyeste først',
    'LBL_KIOSK_SHOW_MORE' => 'Vis flere',
    'LBL_KIOSK_ADD_A_REPLY' => 'Tilføj et svar',
    'LBL_KIOSK_REPLY_EMPTY' => 'Svaret kan ikke efterlades tomt.',
    'LBL_KIOSK_NUM_MORE' => '{{num}} flere',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'Velkommen',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'Få hurtig adgang til dine ressourcer.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'Søg blandt sager',
    'LBL_KIOSK_SHOW_ALL' => 'Vis alle',
    'LBL_KIOSK_404_TITLE' => 'Vi kunne ikke finde dette',
    'LBL_KIOSK_TENANT_404_TITLE' => 'Lejer ikke fundet',
    'LBL_KIOSK_404_MESSAGE' => 'Du har klikket på et link, der er fjernet, er midlertidigt utilgængeligt, eller du har angivet et ugyldigt URL.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'Sørg for, at du har det korrekte URL. Kontakt support for at få yderligere hjælp.',
    'LBL_KIOSK_BACK_TO_HOME' => 'Tilbage til startsiden',
    'LBL_KIOSK_ERROR_CODE' => '{code}-fejl: ',
    'LBL_KIOSK_401_TITLE' => 'Uautoriseret',
    'LBL_KIOSK_401_MESSAGE' => 'Du er ikke autoriseret til at få vist denne side.',
    'LBL_KIOSK_403_TITLE' => 'Uautoriseret',
    'LBL_KIOSK_403_MESSAGE' => 'Du har ikke adgang til at se denne side.',
    'LBL_KIOSK_500_TITLE' => 'Server svarer ikke',
    'LBL_KIOSK_500_MESSAGE' => 'Der gik noget galt på vores side.',
    'LBL_KIOSK_GO_BACK' => 'Gå tilbage',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'Dubletpost fundet',
    'LBL_KIOSK_ACCOUNT' => 'Konto',
    'LBL_KIOSK_STATUS' => 'Status',
    'LBL_KIOSK_DEACTIVATE' => 'Deaktivér',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'Bruger er blevet deaktiveret',
    'LBL_KIOSK_MANAGE_USERS' => 'Administrér brugere',
    'LBL_KIOSK_LAST_LOGIN' => 'Sidste logon',
    'LBL_KIOSK_FIRST_NAME' => 'Fornavn',
    'LBL_KIOSK_LAST_NAME' => 'Efternavn',
    'LBL_KIOSK_ROLE' => 'Rolle',
    'LBL_KIOSK_INVITE' => 'Invitér',
    'LBL_KIOSK_SEND_INVITES' => 'Send invitationer',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'Invitationer blev sendt',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'Invitationer ikke sendt',
    'LBL_KIOSK_REACTIVATE' => 'Aktivér igen',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'Bruger er aktiveret igen',
    'LBL_KIOSK_RESET_PASSWORD' => 'Nulstil adgangskode',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'E-mail til nulstilling af adgangskode blev sendt',
    'LBL_KIOSK_USER_PROFILE' => 'Brugerprofil',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'Din bruger er blevet deaktiveret. Kontakt din administrator.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'Tilbage til logon',
    'LBL_KIOSK_REVOKE_INVITATION' => 'Tilbagekald invitation',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'Invitationen blev trukket tilbage',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'Søg og vælg...',
    'LBL_KIOSK_NO_MATCHES' => 'Der blev ikke fundet nogen matches',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'Profilen blev opdateret.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'Der opstod en fejl ved opdatering af profilen.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'RE: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'Dokumenter',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'Få vist, søg i og download dine indgående delte dokumenter.',
    'LBL_KIOSK_CASES' => 'Sager',
    'LBL_KIOSK_CASES_DESC' => 'Få vist, søg og svar på sager, der er delt med dig.',
    'LBL_KIOSK_DOWNLOAD' => 'Download',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'Filen blev downloadet',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'Komme i gang',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'For at vi bedre kan hjælpe dig, beder vi dig oplyse dit for- og efternavn.',
    'LBL_KIOSK_SAVE' => 'Gem',
    'LBL_KIOSK_SHARED' => 'Delt',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'Velkommen {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'Baggrundsfarve',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'URL-adresse til baggrundsbillede',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'Det anbefales at vælge et billede med en filstørrelse på mindre end 400K.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'Baggrundstype',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'Forsidebaggrund',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'Tema',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'Primær temafarve',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'App-navn',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'Dette er titlen på din applikation, og den vil blive vist ved siden af dit logo.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'URL-adresse til applogo',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'Det anbefales at vælge et logo, der bedst kan ses i små størrelser (f.eks. profiler på sociale medier). Det anbefales også at have en filstørrelse på mindre end 200K.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'URL-adresse til app-favicon',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'Et favicon er et lille logo, der vises ved siden af sidetitlen i en browserfane.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'Tildel automatisk åbne aktiviteter igen',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'Brugergrænse er nået',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'Ugyldig licensnøgle',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'Ugyldig applikation',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'Ugyldig applikation',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'Beskadiget valideringsnøgle',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'Licens er udløbet',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'Manglende info',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'Manglende valideringsnøgle',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'Bruger mangler adgang',
    'LBL_DRI_WORKFLOW' => 'Smart Guide',
    'LBL_DRI_WORKFLOWS' => 'Smart Guides',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'Smart Guide-faseskabelon',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'Smart Guide-faseskabeloner',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'Smart Guide-skabelon',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'Smart Guide-aktivitetsskabelon',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'Aktivitetsskabeloner',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'Webhooks',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate-webhooks',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'Aktuel Smart Guide-aktivitet på',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate-webhooks',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate-webhook',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar-handlinger',
    'LBL_CJ_FORMS' => 'Smart Guide Sugar-handlinger',
    'LBL_CJ_FORM' => 'Smart Guide Sugar-handling',
    'LBL_DRI_SUBWORKFLOW' => 'Smart Guide-fase',
    'LBL_DRI_SUBWORKFLOWS' => 'Smart Guide-faser',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'Smart Guide-aktivitetsskabeloner',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'Smart Guide-skabeloner',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'Smart Guide-rækkefølge',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'Smart Guide Aktuel ordre',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'Smart Guide-score',
    'LBL_CJ_MOMENTUM_POINTS' => 'Smart Guide-momentumpunkter',
    'LBL_CJ_MOMENTUM_SCORE' => 'Smart Guide-momentumscore',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'Smart Guide Tillad aktivitet af',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'Smart Guide-fremskridt',
    'LBL_CJ_MOMENTUM_RATIO' => 'Smart Guide Momentumratio',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'Smart Guide-punkter',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'Smart Guide-opgave',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'Smart Guide Overordnet aktivitetstype',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'Smart Guide Blokeret af',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'Smart Guide blokeret af faser',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'Smart Guide Overordnet aktivitets-id',
    'LBL_START_NEXT_JOURNEY_ID' => 'Start næste Smart Guide-id',
    'LBL_CJ_URL' => 'Smart Guide-URL',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'Er Smart Guide Overordnet aktivitet',
    'LBL_CJ_MOMENTUM_START_DATE' => 'Smart Guide Momentum Startdato',
    'LBL_CJ_MOMENTUM_END_DATE' => 'Smart Guide Momentum Slutdato',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'Widgetlayoutkonfiguration',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'Widgetlayoutkonfiguration',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'Maksimalt antal Smart Guides fra den samme skabelon',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'Aktiv',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'Arkiveret',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'Vis',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'Skjul',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'Lodret tilstand',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'Vandret tilstand',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ugyldig licens',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} har tildelt følgende Smart Guide-aktiviteter til {{assigned_user}}.</p>
    <ul>{{activities}}</ul>
    
    <p>Du kan gennemgå disse aktiviteter via:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'Ugyldig licens',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'Brugergrænsen er nået. Du har {{gracePeriodDays}} dage til at opgradere licensen.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - Tildelte Smart Guide-aktiviteter',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'Din Sugar Automate-brugergrænse på {0} er overskredet<br>
    <br>
    Kontakt <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> for at øge brugergrænsen eller reducere antallet af brugere, der bruger dette plugin.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate-brugergrænse er nået',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'Din Sugar Automate-licens udløber om {0} dage. <br>
    <br>
    Kontakt SugarCRM eller din Sugar-partner for at forny og forhindre afbrydelse af tjenesten.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate-licensen udløber snart',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'Test webhook',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide-fremskridt',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Viser cirkeldiagrammet for "Smart Guide fremskridt" i Sugar Automate.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'Viser webhook-svar',
    'LBL_DASHLET_SEND_LABEL' => 'Send anmodning',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'Tildel til mig',
    'LBL_COMPLETE_BUTTON_TITLE' => 'Fuldført',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'Fuldfør alle opgaver',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'Slet fase',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'Start',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'Ikke relevant',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'Tilføj fase',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'Vis',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'Redigér Smart Guide',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'Annuller',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'Arkivér',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'Fjern fra arkiv',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'Konfigurér skabelon',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'Tilføj opgave',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'Planlæg møde',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'Planlæg opkald',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'er i fremtiden',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'er forfalden',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'er i dag',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'er i morgen',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'Er du sikker på, at du vil anullere denne Smart Guide?',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'Du er ved at fuldføre alle opgaver. Er du sikker på at du vil fortsætte?',
    'LBL_CJ_BLOCK_BY' => 'Du har en uløst, underordnet opgave: {{Name}}. Udfør venligst denne opgave før Udførsel af Alle Opgaver.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'Du har flere uløste, underordnede opgaver. Udfør venligst disse opgaver før Udførsel af Alle Opgaver.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'Du har udført alle opgaver korrekt',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'Er du sikker på, at du vil arkivere denne Smart Guide?',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'Er du sikker på, at du vil fjerne arkivering af denne Smart Guide?',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: Smart Guides (fokusskuffer og konsol)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'Se aktive Smart Guides på betjeningspaneler for Servicekonsol/Fornyelser konsol og fokusskuffer.',
    'LBL_CJ_PROCESSING_REQUEST' => 'Behandler...',
    'LBL_CJ_SUCCESS' => 'Du har udført alle opgaver korrekt',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '{module}-modulet er ikke aktiveret',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'Alle skærmindstillinger er gemt.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'Smart Guide-momentum',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'Viser Sugar Automate "Smart Guide Momentum" målerdiagrammet.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide-fremskridt',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'Viser cirkeldiagrammet Sugar Automate "Smart Guide-fremskridt".',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'Kunne ikke finde overordnet element',
    'CJ_NOT_FOUND_EXCEPTION' => 'Kunne ikke finde {moduleName} med {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'Smart Guide skal være fuldført eller annulleret før arkivering',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate er ikke aktiveret i den aktuelle Sugar-licens',
    'LBL_ACTION_NOT_FOUND' => 'Handling ikke fundet, kontakt systemadministrator',
    'LBL_CJ_SELECT_FIELD' => 'Vælg felt',
    'LBL_CJ_SELECT_OPERATOR' => 'Vælg operatør',
    'LBL_CJ_SELECT_VALUE' => 'Vælg værdi',
    'LBL_CJ_ENTER_VALUE' => 'Indtast værdi',
    'LBL_CJ_FORM_BATCH_TITLE' => 'Gemmer post',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'Aktive smart guides registreret ...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'Behandler aktive sugar-handlinger ...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'Opdaterer aktive smart guides ...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'Posten og de tilhørende smart guides er blevet opdateret.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'En tilknyttet smart guide kunne ikke opdateres. Hvis fejlen fortsætter, skal du kontakte din Sugar-administrator for at få hjælp.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'En tilknyttet smart guide kunne ikke opdateres. Gennemgå <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">loggene</a> for at fejlfinde fejlen.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => '<a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} er tilknyttet.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'Der opstod et problem under tilknytning af <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}}. Hvis problemet fortsætter, skal du kontakte Sugar-support.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => '{{modulePluralLower}} er tilknyttet.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'Der opstod et problem under tilknytning af {{modulePluralLower}}. Hvis problemet fortsætter, skal du kontakte Sugar-support.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'Der opstod et problem under tilknytning af {{moduleSingularLower}}. Hvis problemet fortsætter, skal du kontakte Sugar-support.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'Der findes allerede et {{moduleSingularLower}} med navnet <a href="#{{module}}/{{id}}">{{name}}</a> i fasen {{stage}}.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'Et {{moduleSingularLower}} med navnet <a href="#{{module}}/{{id}}">{{name}}</a> er allerede blevet valgt.',
    'LBL_CJ_ARCHIVED' => 'Arkiveret',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'Vælg Smart Guide-skabelon...',
    'LBL_ALL_SMART_GUIDES' => 'Alle Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => 'Aktive Smart Guides',
    'LBL_ARCHIVED_SMART_GUIDES' => 'Arkiverede Smart Guides',
    'LBL_VERTICAL_SCROLL_VIEW' => 'Lodret stablet visning',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'Vandret stablet visning',
    'LBL_DRI_WORKFLOWS_FILTER' => 'Filter',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'Denne handling kan ikke gennemføres. Statusfeltet for dette aktivitetsmodul er indstillet til "skrivebeskyttet", hvilket forhindrer enhver Smart Guide-handling, der opdaterer statusfeltet.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'Denne handling kan ikke gennemføres. Statusfeltet for denne aktivitets og/eller underaktivitets moduler er indstillet til "skrivebeskyttet", hvilket forhindrer enhver Smart Guide-handling, der opdaterer statusfeltet.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'Statusfeltet for nogle aktivitetsmoduler i guiden er indstillet til "skrivebeskyttet", og disse aktiviteter forbliver uændrede, når guiden annulleres.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'Kopieret til udklipsholder.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'Slet alle gentagelser',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'Ugyldige indstillinger for gentagelse',
    'ERROR_INTERVAL_INVALID' => 'Gentagelsesinterval skal ligge mellem 1 og 99',
    'LBL_RECURRENCE_ADD' => 'Konfigurér',
    'LBL_REPEAT_DAYS' => 'Dag(e) i måneden',
    'LBL_REPEAT_END_TYPES' => 'Gentag',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'Navigationsudbyder',
    'LBL_MOBILE_PDF_EMAIL' => 'E-mail {{{pdfTemplateName}}} PDF',
    'LBL_MOBILE_EMAIL_SENDING' => 'Sender',
    'LBL_MOBILE_EMAIL_SENT' => 'Sendt',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'E-mail gemt som kladde.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'Tilføj vedhæftet fil',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'Upload fra lokal',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar-dokument',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'En redigering, du har foretaget af denne post, har ændret denne visning.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'Udgivelsesnoter for SugarCRM Mobile App',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'SugarCRM Mobile App Brugerguide',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile kan ikke bruges på en rooted mobil enhed. Åbn venligst appen på en enhed, der ikke er rooted.',
    'LBL_VO_BUILD_ROUTE' => 'Opbyg rute',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'Mit afstandsfilter',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'Dette dokument viol blive genereret i baggrunden. Åbn siden Dokumentfletninger for at åbne filen.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'Kunne ikke hente Skabelon. Kontakt din administrator for assistance.',
    'LBL_MAP_ERROR_LOAD' => 'Kan ikke indlæse kort',
    'LBL_MAP_DISTANCE' => 'Afstand',
    'LBL_SELECT_UNIT_TYPE' => 'Enhedstype',
    'LBL_MAPS_UNIT_MILES' => 'Mil',
    'LBL_MAPS_UNIT_KILOMETERS' => 'Kilometer',
    'LBL_RADIUS' => 'Radius',
    'LBL_ZIP_CODE' => 'Postnummer',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'Vælg adresse',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'Kan ikke oprette geokode ud fra adressen:{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'Posten var ikke geokodet.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'Posten indeholder ikke nogen adressedata. Vil du placere denne post på kortet manuelt?',
    'LBL_ERR_SHOW_ON_MAP' => 'Kunne ikke åbne kort over valgte poster.',
    'LBL_ERR_MISSING_ON_MAP' => 'Nogle poster mangler adressedata og vises ikke',
    'LBL_MAPS_ROUTE' => 'Rute',
    'LBL_MAPS_PROVIDER' => 'Sugar Maps',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'Kunne ikke fastsætte nuværende lokation.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'Maksimalt {{{num}}} poster understøttes til kortlægning.',
    'LBL_ALL_MODULES' => 'Alle moduler',
    'LBL_DRIVE_SHARE_LINK' => 'Del et link',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'Kunne ikke indlæse filer.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'Navn kan ikke være tomt',
    'LBL_DRIVE_FOLDER_CREATED' => 'Mappe oprettet.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'Kunne ikke oprette en mappe.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'Kunne ikke oploade en fil.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'Opret venligst en rodmappe først',
    'LBL_EDIT_ALL_RECURRENCES' => 'Redigér alle gentagelser',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'Fil kan ikke åbnes i Dropbox',
    'LBL_FILE_NOT_AVAILABLE' => 'Fil kan ikke åbnes',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'Retninger',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'Ingen rute blev fundet for de angivne vejpunkter',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'I nærheden',
    'LBL_TAGS' => 'Mærker',

    'LBL_CALLER_ID_SETTINGS' => 'Indstillinger for opkalds-id',
    'LBL_CALLER_ID_ENABLED' => 'Opkalds-id aktiveret',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'Ved indgående opkald vises navnet på den kontakt eller det kundeemne, der matcher telefonnummeret.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'For at gøre det muligt for mobilappen at vise opkalds-id&#39;er skal du følge disse trin på din enhed:<br><br>1. Åbn Indstillinger for iOS > Telefon > Blokering og identifikation af opkald.<br>2. Aktivér "{{{brandName}}}".',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'For at gøre det muligt for mobilappen at vise opkalds-id&#39;er skal du følge disse trin på din enhed:<br>1. Åbn appindstillingerne.<br>2. Gå til Tilladelser.<br>3. Aktivér tilladelsen Telefon.<br><br> For at indstille denne app som standardhåndtering af opkalds-id&#39;er skal du gå til dine enhedsindstillinger.<br>1. Gå til Apps.<br>2. Vælg standardapps.<br>3. Vælg Opkalds-id og spamapp.<br>4. Vælg denne app som standardvalgmulighed.',
    'LBL_CALLER_ID_SYNC_HINT' => 'Søg efter ændringer af kontaktoplysninger fra poster (f.eks. Kontakter, Kundeemner) i din Sugar-forekomst.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'Gå til Indstillinger',
    'LBL_CALLER_ID_SYNC' => 'Synkronisér postdata',
    'LBL_CALLER_ID_NOT_ENABLED' => 'Opkalds-id skal aktiveres i systemindstillinger før synkroniseringen.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'Aktivér',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'Senere i indstillingerne',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'Denne app understøtter funktionen Opkalds-id.<br> Når du har trykket på knappen Aktivér, bliver du bedt om at give to tilladelser, så denne funktion fungerer korrekt.<br> For at sikre, at funktionen Opkalds-id fungerer korrekt, skal du give tilladelse til at administrere opkald og vælge denne app som standardhåndtering af opkalds-id&#39;er.<br> Hvis du ikke giver tilladelsen til at administrere opkald, vil du heller ikke kunne logføre opkald, der er foretaget fra appen.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'For at gøre det muligt for mobil appen SugarCRM at vise opkalds-id&#39;er skal du følge disse trin på din enhed:<br><br>1. Åbn Indstillinger for iOS > Telefon > Blokering og identifikation af opkald.<br>2. Aktivér App.',
    'LBL_MOBILE_LAST_SYNC' => 'Seneste synkronisering',
    'LBL_CALLER_ID_SYNCING' => 'Synkroniserer til server.',
    'LBL_NEVER' => 'Aldrig',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} skal udfyldes.',
    'LBL_ADD_RELATED_RECORD' => 'Relateret {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => 'Du har ikke de nødvendige tilladelser til at bruge opkalds-id. Kontakt din administrator.',
    'LBL_CALLER_ID_FETCHING' => 'Synkroniserer …',
    'LBL_CALLER_ID_FETCH_ALL' => 'Synkronisér alle poster igen',
    'LBL_CALLER_ID_FETCH_NEW' => 'Søg efter postopdateringer',

    'LBL_SORT_BY' => 'Sortér efter',
    'LBL_PRIMARY_SORT' => 'Primær sortering',
    'LBL_SECONDARY_SORT' => 'Sekundær sortering',
    'LBL_OF' => 'af',
    'LBL_TABLE_FREEZE_FIRST' => 'Frys første kolonne',
    'LBL_TABLE_SETTINGS_TITLE' => 'Indstillinger for kolonnevisning',
    'LBL_TABLE_SETTINGS_NO_COL' => 'Mindst én kolonne skal være valgt.',
    'LBL_TABLE_TOGGLER_INFO' => 'Vis eller skjul kolonner, og træk dem i din foretrukne rækkefølge.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'Kørselsfiltre',
    'LBL_FILTER_CONDITION' => 'Vælg betingelse',
    'LBL_FILTER_VALUES' => 'Værdier',
    'LBL_TABLE_EXPAND' => 'Udvid alle',
    'LBL_TABLE_COLLAPSE' => 'Skjul alle',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'Serverfejl. Kunne ikke indlæse relevante runtime-filtre.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'Push-abonnementer for hændelse i Pub/Sub-modul',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'Push-abonnement for hændelse i Pub/Sub-modul',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'Panel - Top',
    'panel_bottom' => 'Panel - Bund',
    'tab_first' => 'Fane - Først',
    'tab_last' => 'Fane - Sidst',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'De sidste 7 dage',
    '30' => 'De sidste 30 dage',
    '90' => 'Sidste kvartal',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'I dag',
    'future' => 'Fremtiden',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nej',
];

$app_list_strings['history_filter_options'] = [
    7 => 'De sidste 7 dage',
    30 => 'De sidste 30 dage',
    90 => 'Sidste kvartal',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nej',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'Ja',
    'group' => 'Nej',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'Ja',
    '0' => 'Nej',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'Dette kvartal',
    'next' => 'Næste kvartal',
    'year' => 'I år',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'Mine poster',
    'group' => 'Gruppeposter',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'Min pipeline',
    'group' => 'Mit teams Pipeline',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'Min prognose',
    'group' => 'Mit teams prognose',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'Salgsmuligheder',
    'RevenueLineItems' => 'Muligheder og indtægt linjeposter',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'Seneste lukkedato',
    'earliest' => 'Tidligste lukkedato',
];

$app_list_strings['moduleList']['Library'] = 'Bibliotek';
$app_list_strings['moduleListSingular']['Library'] = 'Bibliotek';
$app_list_strings['library_type'] = ['Books' => 'Bog', 'Music' => 'Musik', 'DVD' => 'Dvd', 'Magazines' => 'Magasiner'];
$app_list_strings['moduleList']['EmailAddresses'] = 'E-mail-adresse';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'E-mail-adresse';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'Kladde',
    'in-review' => 'Til gennemsyn',
    'approved' => 'Godkendt',
    'published' => 'Udgivet',
    'expired' => 'Udløbet',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '- Administratorhandlinger -',
        'Create New Tag' => 'Opret nyt mærke',
        'Delete Tag' => 'Slet mærke',
        'Rename Tag' => 'Omdøb mærke',
        'Move Selected Articles' => 'Flyt valgte artikler',
        'Apply Tags On Articles' => 'Anvend mærker til artikler',
        'Delete Selected Articles' => 'Slet valgte artikler',
    ];

$app_list_strings['moduleList']['Words'] = 'Ord';
$app_list_strings['moduleListSingular']['Words'] = 'Ord';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Opret artikel';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DHABI',
    'ADEN' => 'ADEN',
    'AFGHANISTAN' => 'AFGHANISTAN',
    'ALBANIA' => 'ALBANIEN',
    'ALGERIA' => 'ALGERIET',
    'AMERICAN SAMOA' => 'AMERIKANSK SAMOA',
    'ANDORRA' => 'ANDORRA',
    'ANGOLA' => 'ANGOLA',
    'ANTARCTICA' => 'ANTARKTIS',
    'ANTIGUA' => 'ANTIGUA',
    'ARGENTINA' => 'ARGENTINA',
    'ARMENIA' => 'ARMENIEN',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => 'AUSTRALIEN',
    'AUSTRIA' => 'ØSTRIG',
    'AZERBAIJAN' => 'ASERBAJDSJAN',
    'BAHAMAS' => 'BAHAMAS',
    'BAHRAIN' => 'BAHRAIN',
    'BANGLADESH' => 'BANGLADESH',
    'BARBADOS' => 'BARBADOS',
    'BELARUS' => 'BELARUS',
    'BELGIUM' => 'BELGIEN',
    'BELIZE' => 'BELIZE',
    'BENIN' => 'BENIN',
    'BERMUDA' => 'BERMUDA',
    'BHUTAN' => 'BHUTAN',
    'BOLIVIA' => 'BOLIVIA',
    'BOSNIA' => 'BOSNIEN',
    'BOTSWANA' => 'BOTSWANA',
    'BOUVET ISLAND' => 'BOUVETØ',
    'BRAZIL' => 'BRASILIEN',
    'BRITISH ANTARCTICA TERRITORY' => 'DET BRITISKE TERRITORIUM I ANTARKTIS',
    'BRITISH INDIAN OCEAN TERRITORY' => 'BRITISKE TERRITORIER I DET INDISKE OCEAN',
    'BRITISH VIRGIN ISLANDS' => 'DE BRITISKE JOMFRUØER',
    'BRITISH WEST INDIES' => 'DE BRITISKE VESTINDISKE ØER',
    'BRUNEI' => 'BRUNEI',
    'BULGARIA' => 'BULGARIEN',
    'BURKINA FASO' => 'BURKINA FASO',
    'BURUNDI' => 'BURUNDI',
    'CAMBODIA' => 'CAMBODJA',
    'CAMEROON' => 'CAMEROUN',
    'CANADA' => 'CANADA',
    'CANAL ZONE' => 'KANALZONEN',
    'CANARY ISLAND' => 'DE KANARISKE ØER',
    'CAPE VERDI ISLANDS' => 'KAP VERDE',
    'CAYMAN ISLANDS' => 'CAYMANØERNE',
    'CEVLON' => 'SRI LANKA',
    'CHAD' => 'TCHAD',
    'CHANNEL ISLAND UK' => 'DE BRITISKE KANALØER',
    'CHILE' => 'CHILE',
    'CHINA' => 'KINA',
    'CHRISTMAS ISLAND' => 'JULEØEN',
    'COCOS (KEELING) ISLAND' => 'COCOSØERNE "KEELINGØERNE"',
    'COLOMBIA' => 'COLOMBIA',
    'COMORO ISLANDS' => 'COMORERNE',
    'CONGO' => 'CONGO',
    'CONGO KINSHASA' => 'CONGO KINSHASA',
    'COOK ISLANDS' => 'COOKØERNE',
    'COSTA RICA' => 'COSTA RICA',
    'CROATIA' => 'KROATIEN',
    'CUBA' => 'CUBA',
    'CURACAO' => 'CURACAO',
    'CYPRUS' => 'CYPERN',
    'CZECH REPUBLIC' => 'TJEKKIET',
    'DAHOMEY' => 'DAHOMEY',
    'DENMARK' => 'DANMARK',
    'DJIBOUTI' => 'DJIBOUTI',
    'DOMINICA' => 'DOMINICA',
    'DOMINICAN REPUBLIC' => 'DEN DOMINIKANSKE REPUBLIK',
    'DUBAI' => 'DUBAI',
    'ECUADOR' => 'ECUADOR',
    'EGYPT' => 'EGYPTEN',
    'EL SALVADOR' => 'EL SALVADOR',
    'EQUATORIAL GUINEA' => 'ÆKVATORIALGUINEA',
    'ESTONIA' => 'ESTLAND',
    'ETHIOPIA' => 'ETIOPIEN',
    'FAEROE ISLANDS' => 'FÆRØERNE',
    'FALKLAND ISLANDS' => 'FALKLANDSØERNE',
    'FIJI' => 'FIJI',
    'FINLAND' => 'FINLAND',
    'FRANCE' => 'FRANKRIG',
    'FRENCH GUIANA' => 'FRANSK GUYANA',
    'FRENCH POLYNESIA' => 'FRANSK POLYNESIEN',
    'GABON' => 'GABON',
    'GAMBIA' => 'GAMBIA',
    'GEORGIA' => 'GEORGIEN',
    'GERMANY' => 'TYSKLAND',
    'GHANA' => 'GHANA',
    'GIBRALTAR' => 'GIBRALTAR',
    'GREECE' => 'GRÆKENLAND',
    'GREENLAND' => 'GRØNLAND',
    'GUADELOUPE' => 'GUADELOUPE',
    'GUAM' => 'GUAM',
    'GUATEMALA' => 'GUATEMALA',
    'GUINEA' => 'GUINEA',
    'GUYANA' => 'GUYANA',
    'HAITI' => 'HAITI',
    'HONDURAS' => 'HONDURAS',
    'HONG KONG' => 'HONGKONG',
    'HUNGARY' => 'UNGARN',
    'ICELAND' => 'ISLAND',
    'IFNI' => 'IFNI',
    'INDIA' => 'INDIEN',
    'INDONESIA' => 'INDONESIEN',
    'IRAN' => 'IRAN',
    'IRAQ' => 'IRAK',
    'IRELAND' => 'IRLAND',
    'ISRAEL' => 'ISRAEL',
    'ITALY' => 'ITALIEN',
    'IVORY COAST' => 'ELFENBENSKYSTEN',
    'JAMAICA' => 'JAMAICA',
    'JAPAN' => 'JAPAN',
    'JORDAN' => 'JORDAN',
    'KAZAKHSTAN' => 'KASAKHSTAN',
    'KENYA' => 'KENYA',
    'KOREA' => 'KOREA',
    'KOREA, SOUTH' => 'SYDKOREA',
    'KUWAIT' => 'KUWAIT',
    'KYRGYZSTAN' => 'KIRGISISTAN',
    'LAOS' => 'LAOS',
    'LATVIA' => 'LETLAND',
    'LEBANON' => 'LIBANON',
    'LEEWARD ISLANDS' => 'LEEWARDØERNE',
    'LESOTHO' => 'LESOTHO',
    'LIBYA' => 'LIBYEN',
    'LIECHTENSTEIN' => 'LIECHTENSTEIN',
    'LITHUANIA' => 'LITAUEN',
    'LUXEMBOURG' => 'LUXEMBOURG',
    'MACAO' => 'MACAO',
    'MACEDONIA' => 'MAKEDONIEN',
    'MADAGASCAR' => 'MADAGASKAR',
    'MALAWI' => 'MALAWI',
    'MALAYSIA' => 'MALAYSIA',
    'MALDIVES' => 'MALDIVERNE',
    'MALI' => 'MALI',
    'MALTA' => 'MALTA',
    'MARTINIQUE' => 'MARTINIQUE',
    'MAURITANIA' => 'MAURETANIEN',
    'MAURITIUS' => 'MAURITIUS',
    'MELANESIA' => 'MELANESIEN',
    'MEXICO' => 'MEXICO',
    'MOLDOVIA' => 'MOLDOVA',
    'MONACO' => 'MONACO',
    'MONGOLIA' => 'MONGOLIET',
    'MOROCCO' => 'MAROKKO',
    'MOZAMBIQUE' => 'MOZAMBIQUE',
    'MYANAMAR' => 'MYANMAR',
    'NAMIBIA' => 'NAMIBIA',
    'NEPAL' => 'NEPAL',
    'NETHERLANDS' => 'NEDERLANDENE',
    'NETHERLANDS ANTILLES' => 'DE NEDERLANDSKE ANTILLER',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'DE NEDERLANDSKE ANTILLER, NEUTRAL ZONE',
    'NEW CALADONIA' => 'NY KALEDONIEN',
    'NEW HEBRIDES' => 'NY HEBRIDERNE',
    'NEW ZEALAND' => 'NEW ZEALAND',
    'NICARAGUA' => 'NICARAGUA',
    'NIGER' => 'NIGER',
    'NIGERIA' => 'NIGERIA',
    'NORFOLK ISLAND' => 'NORFOLK ISLAND',
    'NORWAY' => 'NORGE',
    'OMAN' => 'OMAN',
    'OTHER' => 'ANDET',
    'PACIFIC ISLAND' => 'STILLEHAVSØERNE',
    'PAKISTAN' => 'PAKISTAN',
    'PANAMA' => 'PANAMA',
    'PAPUA NEW GUINEA' => 'PAPUA NY GUINEA',
    'PARAGUAY' => 'PARAGUAY',
    'PERU' => 'PERU',
    'PHILIPPINES' => 'FILIPPINERNE',
    'POLAND' => 'POLEN',
    'PORTUGAL' => 'PORTUGAL',
    'PORTUGUESE TIMOR' => 'ØSTTIMOR',
    'PUERTO RICO' => 'PUERTO RICO',
    'QATAR' => 'QATAR',
    'REPUBLIC OF BELARUS' => 'REPUBLIKKEN BELARUS',
    'REPUBLIC OF SOUTH AFRICA' => 'DEN SYDAFRIKANSKE REPUBLIK',
    'REUNION' => 'REUNION',
    'ROMANIA' => 'RUMÆNIEN',
    'RUSSIA' => 'RUSLAND',
    'RWANDA' => 'RWANDA',
    'RYUKYU ISLANDS' => 'RYUKYUØERNE',
    'SABAH' => 'SABAH',
    'SAN MARINO' => 'SAN MARINO',
    'SAUDI ARABIA' => 'SAUDI-ARABIEN',
    'SENEGAL' => 'SENEGAL',
    'SERBIA' => 'SERBIEN',
    'SEYCHELLES' => 'SEYCHELLERNE',
    'SIERRA LEONE' => 'SIERRA LEONE',
    'SINGAPORE' => 'SINGAPORE',
    'SLOVAKIA' => 'SLOVAKIET',
    'SLOVENIA' => 'SLOVENIEN',
    'SOMALILIAND' => 'SOMALIA',
    'SOUTH AFRICA' => 'SYDAFRIKA',
    'SOUTH YEMEN' => 'SYDYEMEN',
    'SPAIN' => 'SPANIEN',
    'SPANISH SAHARA' => 'SPANSK SAHARA',
    'SRI LANKA' => 'SRI LANKA',
    'ST. KITTS AND NEVIS' => 'SAINT KITTS OG NEVIS',
    'ST. LUCIA' => 'SAINT LUCIA',
    'SUDAN' => 'SUDAN',
    'SURINAM' => 'SURINAM',
    'SW AFRICA' => 'SYDVESTAFRIKA',
    'SWAZILAND' => 'SWAZILAND',
    'SWEDEN' => 'SVERIGE',
    'SWITZERLAND' => 'SCHWEIZ',
    'SYRIA' => 'SYRIEN',
    'TAIWAN' => 'TAIWAN',
    'TAJIKISTAN' => 'TADSJIKISTAN',
    'TANZANIA' => 'TANZANIA',
    'THAILAND' => 'THAILAND',
    'TONGA' => 'TONGA',
    'TRINIDAD' => 'TRINIDAD',
    'TUNISIA' => 'TUNESIEN',
    'TURKEY' => 'TYRKIET',
    'UGANDA' => 'UGANDA',
    'UKRAINE' => 'UKRAINE',
    'UNITED ARAB EMIRATES' => 'DE FORENEDE ARABISKE EMIRATER',
    'UNITED KINGDOM' => 'STORBRITANNIEN',
    'UPPER VOLTA' => 'ØVRE VOLTA',
    'URUGUAY' => 'URUGUAY',
    'US PACIFIC ISLAND' => 'DE AMERIKANSKE STILLEHAVSØER',
    'US VIRGIN ISLANDS' => 'DE AMERIKANSKE JOMFRUØER',
    'USA' => 'USA',
    'UZBEKISTAN' => 'USBEKISTAN',
    'VANUATU' => 'VANUATU',
    'VATICAN CITY' => 'VATIKANSTATEN',
    'VENEZUELA' => 'VENEZUELA',
    'VIETNAM' => 'VIETNAM',
    'WAKE ISLAND' => 'WAKE ISLAND',
    'WEST INDIES' => 'DE VESTINDISKE ØER',
    'WESTERN SAHARA' => 'VESTSAHARA',
    'YEMEN' => 'YEMEN',
    'ZAIRE' => 'ZAIRE',
    'ZAMBIA' => 'ZAMBIA',
    'ZIMBABWE' => 'ZIMBABWE',
];

$app_list_strings['state_dom'] = [
    'AL' => 'Alabama',
    'AK' => 'Alaska',
    'AZ' => 'Arizona',
    'AR' => 'Arkansas',
    'CA' => 'California',
    'CO' => 'Colorado',
    'CT' => 'Connecticut',
    'DE' => 'Delaware',
    'DC' => 'District Of Columbia',
    'FL' => 'Florida',
    'GA' => 'Georgia',
    'HI' => 'Hawaii',
    'ID' => 'Idaho',
    'IL' => 'Illinois',
    'IN' => 'Indiana',
    'IA' => 'Iowa',
    'KS' => 'Kansas',
    'KY' => 'Kentucky',
    'LA' => 'Louisiana',
    'ME' => 'Maine',
    'MD' => 'Maryland',
    'MA' => 'Massachusetts',
    'MI' => 'Michigan',
    'MN' => 'Minnesota',
    'MS' => 'Mississippi',
    'MO' => 'Missouri',
    'MT' => 'Montana',
    'NE' => 'Nebraska',
    'NV' => 'Nevada',
    'NH' => 'New Hampshire',
    'NJ' => 'New Jersey',
    'NM' => 'New Mexico',
    'NY' => 'New York',
    'NC' => 'North Carolina',
    'ND' => 'North Dakota',
    'OH' => 'Ohio',
    'OK' => 'Oklahoma',
    'OR' => 'Oregon',
    'PA' => 'Pennsylvania',
    'RI' => 'Rhode Island',
    'SC' => 'South Carolina',
    'SD' => 'South Dakota',
    'TN' => 'Tennessee',
    'TX' => 'Texas',
    'UT' => 'Utah',
    'VT' => 'Vermont',
    'VA' => 'Virginia',
    'WA' => 'Washington',
    'WV' => 'West Virginia',
    'WI' => 'Wisconsin',
    'WY' => 'Wyoming',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 "Taiwan og Hongkong"',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 "MS kyrillisk"',
    'CP1252' => 'CP1252 "MS vesteuropæisk og amerikansk"',
    'EUC-CN' => 'EUC-CN "forenklet kinesisk GB2312"',
    'EUC-JP' => 'EUC-JP "Unix japansk"',
    'EUC-KR' => 'EUC-KR "koreansk"',
    'EUC-TW' => 'EUC-TW "taiwanesisk"',
    'ISO-2022-JP' => 'ISO-2022-JP "japansk"',
    'ISO-2022-KR' => 'ISO-2022-KR "koreansk"',
    'ISO-8859-1' => 'ISO-8859-1 "vesteuropæisk og amerikansk"',
    'ISO-8859-2' => 'ISO-8859-2 "central- og østeuropæisk"',
    'ISO-8859-3' => 'ISO-8859-3 "latinsk 3"',
    'ISO-8859-4' => 'ISO-8859-4 "latinsk 4"',
    'ISO-8859-5' => 'ISO-8859-5 "kyrillisk"',
    'ISO-8859-6' => 'ISO-8859-6 "arabisk"',
    'ISO-8859-7' => 'ISO-8859-7 "græsk"',
    'ISO-8859-8' => 'ISO-8859-8 "hebraisk"',
    'ISO-8859-9' => 'ISO-8859-9 "latinsk 5"',
    'ISO-8859-10' => 'ISO-8859-10 "latinsk 6"',
    'ISO-8859-13' => 'ISO-8859-13 "latinsk 7"',
    'ISO-8859-14' => 'ISO-8859-14 "latinsk 8"',
    'ISO-8859-15' => 'ISO-8859-15 "latinsk 9"',
    'KOI8-R' => 'KOI8-R "kyrillisk russisk"',
    'KOI8-U' => 'KOI8-U "kyrillisk ukrainsk"',
    'SJIS' => 'SJIS "MS japansk"',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'Afrika/Algier',
    'Africa/Luanda' => 'Afrika/Luanda',
    'Africa/Porto-Novo' => 'Afrika/Porto-Novo',
    'Africa/Gaborone' => 'Afrika/Gaborone',
    'Africa/Ouagadougou' => 'Afrika/Ouagadougou',
    'Africa/Bujumbura' => 'Afrika/Bujumbura',
    'Africa/Douala' => 'Afrika/Douala',
    'Atlantic/Cape_Verde' => 'Atlantic/Kap_Verde',
    'Africa/Bangui' => 'Afrika/Bangui',
    'Africa/Ndjamena' => 'Afrika/Ndjamena',
    'Indian/Comoro' => 'Indien/Comoro',
    'Africa/Kinshasa' => 'Afrika/Kinshasa',
    'Africa/Lubumbashi' => 'Afrika/Lubumbashi',
    'Africa/Brazzaville' => 'Afrika/Brazzaville',
    'Africa/Abidjan' => 'Afrika/Abidjan',
    'Africa/Djibouti' => 'Afrika/Djibouti',
    'Africa/Cairo' => 'Afrika/Cairo',
    'Africa/Malabo' => 'Afrika/Malabo',
    'Africa/Asmera' => 'Afrika/Asmera',
    'Africa/Addis_Ababa' => 'Afrika/Addis_Ababa',
    'Africa/Libreville' => 'Afrika/Libreville',
    'Africa/Banjul' => 'Afrika/Banjul',
    'Africa/Accra' => 'Afrika/Accra',
    'Africa/Conakry' => 'Afrika/Conakry',
    'Africa/Bissau' => 'Afrika/Bissau',
    'Africa/Nairobi' => 'Afrika/Nairobi',
    'Africa/Maseru' => 'Afrika/Maseru',
    'Africa/Monrovia' => 'Afrika/Monrovia',
    'Africa/Tripoli' => 'Afrika/Tripoli',
    'Indian/Antananarivo' => 'Indien/Antananarivo',
    'Africa/Blantyre' => 'Afrika/Blantyre',
    'Africa/Bamako' => 'Afrika/Bamako',
    'Africa/Nouakchott' => 'Afrika/Nouakchott',
    'Indian/Mauritius' => 'Indien/Mauritius',
    'Indian/Mayotte' => 'Indien/Mayotte',
    'Africa/Casablanca' => 'Afrika/Casablanca',
    'Africa/El_Aaiun' => 'Afrika/El_Aaiun',
    'Africa/Maputo' => 'Afrika/Maputo',
    'Africa/Windhoek' => 'Afrika/Windhoek',
    'Africa/Niamey' => 'Afrika/Niamey',
    'Africa/Lagos' => 'Afrika/Lagos',
    'Indian/Reunion' => 'Indien/Reunion',
    'Africa/Kigali' => 'Afrika/Kigali',
    'Atlantic/St_Helena' => 'Atlantic/Saint_Helena',
    'Africa/Sao_Tome' => 'Afrika/Sao_Tome',
    'Africa/Dakar' => 'Afrika/Dakar',
    'Indian/Mahe' => 'Indien/Mahe',
    'Africa/Freetown' => 'Afrika/Freetown',
    'Africa/Mogadishu' => 'Afrika/Mogadishu',
    'Africa/Johannesburg' => 'Afrika/Johannesburg',
    'Africa/Khartoum' => 'Afrika/Khartoum',
    'Africa/Mbabane' => 'Afrika/Mbabane',
    'Africa/Dar_es_Salaam' => 'Afrika/Dar_es_Salaam',
    'Africa/Lome' => 'Afrika/Lome',
    'Africa/Tunis' => 'Afrika/Tunis',
    'Africa/Kampala' => 'Afrika/Kampala',
    'Africa/Lusaka' => 'Afrika/Lusaka',
    'Africa/Harare' => 'Afrika/Harare',
    'Antarctica/Casey' => 'Antarktis/Casey',
    'Antarctica/Davis' => 'Antarktis/Davis',
    'Antarctica/Mawson' => 'Antarktis/Mawson',
    'Indian/Kerguelen' => 'Indien/Kerguelen',
    'Antarctica/DumontDUrville' => 'Antarktis/DumontDUrville',
    'Antarctica/Syowa' => 'Antarktis/Syowa',
    'Antarctica/Vostok' => 'Antarktis/Vostok',
    'Antarctica/Rothera' => 'Antarktis/Rothera',
    'Antarctica/Palmer' => 'Antarktis/Palmer',
    'Antarctica/McMurdo' => 'Antarktis/McMurdo',
    'Asia/Kabul' => 'Asien/Kabul',
    'Asia/Yerevan' => 'Asien/Yeravan',
    'Asia/Baku' => 'Asien/Baku',
    'Asia/Bahrain' => 'Asien/Bahrain',
    'Asia/Dhaka' => 'Asien/Dhaka',
    'Asia/Thimphu' => 'Asien/Thimphu',
    'Indian/Chagos' => 'Indien/Chagos',
    'Asia/Brunei' => 'Asien/Brunei',
    'Asia/Rangoon' => 'Asien/Rangoon',
    'Asia/Phnom_Penh' => 'Asien/Phnom_Penh',
    'Asia/Beijing' => 'Asien/Beijing',
    'Asia/Harbin' => 'Asien/Harbin',
    'Asia/Shanghai' => 'Asien/Shanghai',
    'Asia/Chongqing' => 'Asien/Chongquing',
    'Asia/Urumqi' => 'Asien/Urumqi',
    'Asia/Kashgar' => 'Asien/Kashgar',
    'Asia/Hong_Kong' => 'Asien/Hongkong',
    'Asia/Taipei' => 'Asien/Taipei',
    'Asia/Macau' => 'Asien/Macau',
    'Asia/Nicosia' => 'Asien/Nicosia',
    'Asia/Tbilisi' => 'Asien/Tbilisi',
    'Asia/Dili' => 'Asien/Dili',
    'Asia/Calcutta' => 'Asien/Calcutta',
    'Asia/Jakarta' => 'Asien/Jakarta',
    'Asia/Pontianak' => 'Asien/Pontianak',
    'Asia/Makassar' => 'Asien/Makassar',
    'Asia/Jayapura' => 'Asien/Jayapura',
    'Asia/Tehran' => 'Asien/Tehran',
    'Asia/Baghdad' => 'Asien/Baghdad',
    'Asia/Jerusalem' => 'Asien/Jerusalem',
    'Asia/Tokyo' => 'Asien/Tokyo',
    'Asia/Amman' => 'Asien/Amman',
    'Asia/Almaty' => 'Asien/Almaty',
    'Asia/Qyzylorda' => 'Asien/Qyzylorda',
    'Asia/Aqtobe' => 'Asien/Aqtobe',
    'Asia/Aqtau' => 'Asien/Aqtau',
    'Asia/Oral' => 'Asien/Oral',
    'Asia/Bishkek' => 'Asien/Bishkek',
    'Asia/Seoul' => 'Asien/Seoul',
    'Asia/Pyongyang' => 'Asien/Pyongyang',
    'Asia/Kuwait' => 'Asien/Kuwait',
    'Asia/Vientiane' => 'Asien/Vientiane',
    'Asia/Beirut' => 'Asien/Beirut',
    'Asia/Kuala_Lumpur' => 'Asien/Kuala_Lumpur',
    'Asia/Kuching' => 'Asien/Kuching',
    'Indian/Maldives' => 'Indien/Maldiverne',
    'Asia/Hovd' => 'Asien/Hovd',
    'Asia/Ulaanbaatar' => 'Asien/Ulaanbaatar',
    'Asia/Choibalsan' => 'Asien/Choibalsan',
    'Asia/Katmandu' => 'Asien/Katmandu',
    'Asia/Muscat' => 'Asien/Muscat',
    'Asia/Karachi' => 'Asien/Karachi',
    'Asia/Gaza' => 'Asien/Gaza',
    'Asia/Manila' => 'Asien/Manila',
    'Asia/Qatar' => 'Asien/Qatar',
    'Asia/Riyadh' => 'Asien/Riyadh',
    'Asia/Singapore' => 'Asien/Singapore',
    'Asia/Colombo' => 'Asien/Colombo',
    'Asia/Damascus' => 'Asien/Damaskus',
    'Asia/Dushanbe' => 'Asien/Dushanbe',
    'Asia/Bangkok' => 'Asien/Bangkok',
    'Asia/Ashgabat' => 'Asien/Ashgabat',
    'Asia/Dubai' => 'Asien/Dubai',
    'Asia/Samarkand' => 'Asien/Samarkand',
    'Asia/Tashkent' => 'Asien/Tashkent',
    'Asia/Saigon' => 'Asien/Saigon',
    'Asia/Aden' => 'Asien/Aden',
    'Australia/Darwin' => 'Australien/Darwin',
    'Australia/Perth' => 'Australien/Perth',
    'Australia/Brisbane' => 'Australien/Brisbane',
    'Australia/Lindeman' => 'Australien/Lindeman',
    'Australia/Adelaide' => 'Australien/Adelaide',
    'Australia/Hobart' => 'Australien/Hobart',
    'Australia/Currie' => 'Australien/Currie',
    'Australia/Melbourne' => 'Australien/Melbourne',
    'Australia/Sydney' => 'Australien/Sydney',
    'Australia/Broken_Hill' => 'Australien/Broken_Hill',
    'Indian/Christmas' => 'Indien/Juleøen',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Indian/Cocos' => 'Indien/Cocos',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Truk' => 'Pacific/Truk',
    'Pacific/Ponape' => 'Pacific/Ponape',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Johnston' => 'Pacific/Johnston',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'Europe/London' => 'Europa/London',
    'Europe/Dublin' => 'Europa/Dublin',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'Europa/Tirana',
    'Europe/Andorra' => 'Europa/Andorra',
    'Europe/Vienna' => 'Europa/Wien',
    'Europe/Minsk' => 'Europa/Minsk',
    'Europe/Brussels' => 'Europa/Bruxelles',
    'Europe/Sofia' => 'Europa/Sofia',
    'Europe/Prague' => 'Europa/Prag',
    'Europe/Copenhagen' => 'Europa/København',
    'Atlantic/Faeroe' => 'Atlantic/Færøerne',
    'America/Danmarkshavn' => 'Amerika/Danmarkshavn',
    'America/Scoresbysund' => 'Amerika/Scoresbysund',
    'America/Godthab' => 'Amerika/Nuuk',
    'America/Thule' => 'Amerika/Thule',
    'Europe/Tallinn' => 'Europa/Tallinn',
    'Europe/Helsinki' => 'Europa/Helsinki',
    'Europe/Paris' => 'Europa/Paris',
    'Europe/Berlin' => 'Europa/Berlin',
    'Europe/Gibraltar' => 'Europa/Gibraltar',
    'Europe/Athens' => 'Europa/Athen',
    'Europe/Budapest' => 'Europa/Budapest',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Europe/Rome' => 'Europa/Rom',
    'Europe/Riga' => 'Europa/Riga',
    'Europe/Vaduz' => 'Europa/Vaduz',
    'Europe/Vilnius' => 'Europa/Vilnius',
    'Europe/Luxembourg' => 'Europa/Luxembourg',
    'Europe/Malta' => 'Europa/Malta',
    'Europe/Chisinau' => 'Europa/Chisinau',
    'Europe/Monaco' => 'Europa/Monaco',
    'Europe/Amsterdam' => 'Europa/Amsterdam',
    'Europe/Oslo' => 'Europa/Oslo',
    'Europe/Warsaw' => 'Europa/Warszawa',
    'Europe/Lisbon' => 'Europa/Lissabon',
    'Atlantic/Azores' => 'Atlantic/Azorerne',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Europe/Bucharest' => 'Europa/Bukarest',
    'Europe/Kaliningrad' => 'Europa/Kaliningrad',
    'Europe/Moscow' => 'Europa/Moskva',
    'Europe/Samara' => 'Europa/Samara',
    'Asia/Yekaterinburg' => 'Asien/Yekaterinburg',
    'Asia/Omsk' => 'Asien/Omsk',
    'Asia/Novosibirsk' => 'Asien/Novosibirsk',
    'Asia/Krasnoyarsk' => 'Asien/Krasnoyarsk',
    'Asia/Irkutsk' => 'Asien/Irkutsk',
    'Asia/Yakutsk' => 'Asien/Yakutsk',
    'Asia/Vladivostok' => 'Asien/Vladivostok',
    'Asia/Sakhalin' => 'Asien/Sakhalin',
    'Asia/Magadan' => 'Asien/Magadan',
    'Asia/Kamchatka' => 'Asien/Kamchatka',
    'Asia/Anadyr' => 'Asien/Anadyr',
    'Europe/Belgrade' => 'Europa/Beograd',
    'Europe/Madrid' => 'Europa/Madrid',
    'Africa/Ceuta' => 'Afrika/Ceuta',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Europe/Stockholm' => 'Europa/Stockholm',
    'Europe/Zurich' => 'Europa/Zurich',
    'Europe/Istanbul' => 'Europa/Istanbul',
    'Europe/Kiev' => 'Europa/Kiev',
    'Europe/Uzhgorod' => 'Europa/Uzhgorod',
    'Europe/Zaporozhye' => 'Europa/Zaporozhye',
    'Europe/Simferopol' => 'Europa/Simferopol',
    'America/New_York' => 'Amerika/New_York',
    'America/Chicago' => 'Amerika/Chicago',
    'America/North_Dakota/Center' => 'Amerika/North_Dakota/Center',
    'America/Denver' => 'Amerika/Denver',
    'America/Los_Angeles' => 'Amerika/Los_Angeles',
    'America/Juneau' => 'Amerika/Juneau',
    'America/Yakutat' => 'Amerika/Yakutat',
    'America/Anchorage' => 'Amerika/Anchorage',
    'America/Nome' => 'Amerika/Nome',
    'America/Adak' => 'Amerika/Adak',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'America/Phoenix' => 'Amerika/Phoenix',
    'America/Boise' => 'Amerika/Boise',
    'America/Indiana/Indianapolis' => 'Amerika/Indiana/Indianapolis',
    'America/Indiana/Marengo' => 'Amerika/Indiana/Marengo',
    'America/Indiana/Knox' => 'Amerika/Indiana/Knox',
    'America/Indiana/Vevay' => 'Amerika/Indiana/Vevay',
    'America/Kentucky/Louisville' => 'Amerika/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'Amerika/Kentucky/Monticello',
    'America/Detroit' => 'Amerika/Detroit',
    'America/Menominee' => 'Amerika/Menominee',
    'America/St_Johns' => 'Amerika/St_Johns',
    'America/Goose_Bay' => 'Amerika/Goose_Bay',
    'America/Halifax' => 'Amerika/Halifax',
    'America/Glace_Bay' => 'Amerika/Glace_Bay',
    'America/Montreal' => 'Amerika/Montreal',
    'America/Toronto' => 'Amerika/Toronto',
    'America/Thunder_Bay' => 'Amerika/Thunder_Bay',
    'America/Nipigon' => 'Amerika/Nipigon',
    'America/Rainy_River' => 'Amerika/Rainy_River',
    'America/Winnipeg' => 'Amerika/Winnipeg',
    'America/Regina' => 'Amerika/Regina',
    'America/Swift_Current' => 'Amerika/Swift_Current',
    'America/Edmonton' => 'Amerika/Edmonton',
    'America/Vancouver' => 'Amerika/Vancouver',
    'America/Dawson_Creek' => 'Amerika/Dawson_Creek',
    'America/Pangnirtung' => 'Amerika/Pangnirtung',
    'America/Iqaluit' => 'Amerika/Iqaluit',
    'America/Coral_Harbour' => 'Amerika/Coral_Harbour',
    'America/Rankin_Inlet' => 'Amerika/Rankin_Inlet',
    'America/Cambridge_Bay' => 'Amerika/Cambridge_Bay',
    'America/Yellowknife' => 'Amerika/Yellowknife',
    'America/Inuvik' => 'Amerika/Inuvik',
    'America/Whitehorse' => 'Amerika/Whitehorse',
    'America/Dawson' => 'Amerika/Dawson',
    'America/Cancun' => 'Amerika/Cancun',
    'America/Merida' => 'Amerika/Merida',
    'America/Monterrey' => 'Amerika/Monterrey',
    'America/Mexico_City' => 'Amerika/Mexico_City',
    'America/Chihuahua' => 'Amerika/Chihuahua',
    'America/Hermosillo' => 'Amerika/Hermosillo',
    'America/Mazatlan' => 'Amerika/Mazatlan',
    'America/Tijuana' => 'Amerika/Tijuana',
    'America/Anguilla' => 'Amerika/Anguilla',
    'America/Antigua' => 'Amerika/Antigua',
    'America/Nassau' => 'Amerika/Nassau',
    'America/Barbados' => 'Amerika/Barbados',
    'America/Belize' => 'Amerika/Belize',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'America/Cayman' => 'Amerika/Cayman',
    'America/Costa_Rica' => 'Amerika/Costa_Rica',
    'America/Havana' => 'Amerika/Havana',
    'America/Dominica' => 'Amerika/Dominica',
    'America/Santo_Domingo' => 'Amerika/Santo_Domingo',
    'America/El_Salvador' => 'Amerika/El_Salvador',
    'America/Grenada' => 'Amerika/Grenada',
    'America/Guadeloupe' => 'Amerika/Guadeloupe',
    'America/Guatemala' => 'Amerika/Guatemala',
    'America/Port-au-Prince' => 'Amerika/Port-au-Prince',
    'America/Tegucigalpa' => 'Amerika/Tegucigalpa',
    'America/Jamaica' => 'Amerika/Jamaica',
    'America/Martinique' => 'Amerika/Martinique',
    'America/Montserrat' => 'Amerika/Montserrat',
    'America/Managua' => 'Amerika/Managua',
    'America/Panama' => 'Amerika/Panama',
    'America/Puerto_Rico' => 'Amerika/Puerto_Rico',
    'America/St_Kitts' => 'Amerika/Saint_Kitts',
    'America/St_Lucia' => 'Amerika/Saint_Lucia',
    'America/Miquelon' => 'Amerika/Miquelon',
    'America/St_Vincent' => 'Amerika/Saint_Vincent',
    'America/Grand_Turk' => 'Amerika/Grand_Turk',
    'America/Tortola' => 'Amerika/Tortola',
    'America/St_Thomas' => 'Amerika/Saint_Thomas',
    'America/Argentina/Buenos_Aires' => 'Amerika/Argentina/Buenos_Aires',
    'America/Argentina/Cordoba' => 'Amerika/Argentina/Cordoba',
    'America/Argentina/Tucuman' => 'Amerika/Argentina/Tucuman',
    'America/Argentina/La_Rioja' => 'Amerika/Argentina/La_Rioja',
    'America/Argentina/San_Juan' => 'Amerika/Argentina/San_Juan',
    'America/Argentina/Jujuy' => 'Amerika/Argentina/Jujuy',
    'America/Argentina/Catamarca' => 'Amerika/Argentina/Catamarca',
    'America/Argentina/Mendoza' => 'Amerika/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'Amerika/Argentina/Rio_Gallegos',
    'America/Argentina/Ushuaia' => 'Amerika/Argentina/Ushuaia',
    'America/Aruba' => 'Amerika/Aruba',
    'America/La_Paz' => 'Amerika/La_Paz',
    'America/Noronha' => 'Amerika/Noronha',
    'America/Belem' => 'Amerika/Belem',
    'America/Fortaleza' => 'Amerika/Fortaleza',
    'America/Recife' => 'Amerika/Recife',
    'America/Araguaina' => 'Amerika/Araguaina',
    'America/Maceio' => 'Amerika/Maceio',
    'America/Bahia' => 'Amerika/Bahia',
    'America/Sao_Paulo' => 'Amerika/Sao_Paulo',
    'America/Campo_Grande' => 'Amerika/Campo_Grande',
    'America/Cuiaba' => 'Amerika/Cuiaba',
    'America/Porto_Velho' => 'Amerika/Porto_Velho',
    'America/Boa_Vista' => 'Amerika/Boa_Vista',
    'America/Manaus' => 'Amerika/Manaus',
    'America/Eirunepe' => 'Amerika/Eirunepe',
    'America/Rio_Branco' => 'Amerika/Rio_Branco',
    'America/Santiago' => 'Amerika/Santiago',
    'Pacific/Easter' => 'Pacific/Easter',
    'America/Bogota' => 'Amerika/Bogota',
    'America/Curacao' => 'Amerika/Curacao',
    'America/Guayaquil' => 'Amerika/Guayaquil',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'America/Cayenne' => 'Amerika/Cayenne',
    'America/Guyana' => 'Amerika/Guyana',
    'America/Asuncion' => 'Amerika/Asuncion',
    'America/Lima' => 'Amerika/Lima',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'America/Paramaribo' => 'Amerika/Paramaribo',
    'America/Port_of_Spain' => 'Amerika/Port_of_Spain',
    'America/Montevideo' => 'Amerika/Montevideo',
    'America/Caracas' => 'Amerika/Caracas',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'Favoriter';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'Favorit';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google Docs',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Contacts',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'Anmod',
    2 => 'Adgang',
    3 => 'Ugyldig',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugar bruger',
    'support_portal' => 'Support Portal',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'Kampagne',
    'email' => 'E-mail',
    'workflow' => 'Workflow',
    'system' => 'System',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'Kampagne',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'Kampagne',
    'email' => 'E-mail',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'Dokumentation',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'To intervaller',
    'show_buckets' => 'Tre intervaller',
    'show_custom_buckets' => 'Brugerdefinerede intervaller',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'Dato baseret år',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'Årlig (Kvartalsvis under perioder)',
    'Quarter' => 'Kvartalsvis (Månedlig under perioder)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'Omsætningsposter',
    'Opportunities' => 'Salgsmuligheder',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'Ja',
    'no' => 'Nej',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'Advarsel',
    'information' => 'Info',
    'other' => 'Andet',
    'success' => 'Handlingen lykkedes',
    'warning' => 'Advarsel:',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'FÅ',
    'PUT' => 'PUT',
    'DELETE' => 'SLET',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'Manuelt',
    '5' => 'Hver 5 minut',
    '15' => 'Hvert 15. minut',
    '30' => 'Hvert 30. minut',
    '60' => 'Hver time',
];

$app_list_strings['moduleList']['KBDocuments'] = 'Videnbasedokument';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'Videnbasedokument';
$app_list_strings['moduleList']['KBContents'] = 'Videnbase';
$app_list_strings['moduleListSingular']['KBContents'] = 'Vidensbase artikel';
$app_list_strings['moduleList']['KBArticles'] = 'Videnbaseartikel';
$app_list_strings['moduleListSingular']['KBArticles'] = 'Videnbaseartikel';
$app_list_strings['moduleList']['KBContentTemplates'] = 'Skabelon for videnbase';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'Skabelon for videnbase';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'Integrerede filer';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'Integreret fil';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'Leke',
    'USD' => 'Dollars',
    'AFN' => 'Afghanis',
    'ARS' => 'Pesos',
    'AWG' => 'Gylden',
    'AUD' => 'Dollars',
    'AZN' => 'Ny Manats',
    'BSD' => 'Dollars',
    'BBD' => 'Dollars',
    'BYR' => 'Rubler',
    'EUR' => 'Euro',
    'BZD' => 'Dollars',
    'BMD' => 'Dollars',
    'BOB' => 'Bolivianos',
    'BAM' => 'Konvertible Marka',
    'BWP' => 'Pulas',
    'BGN' => 'Leva',
    'BRL' => 'Reais',
    'GBP' => 'Pund',
    'BND' => 'Dollars',
    'KHR' => 'Riels',
    'CAD' => 'Dollars',
    'KYD' => 'Dollars',
    'CLP' => 'Pesos',
    'CNY' => 'Yuan Renminbi',
    'COP' => 'Pesos',
    'CRC' => 'ColÃ³n',
    'HRK' => 'Kuna',
    'CUP' => 'Pesos',
    'CZK' => 'Koruny',
    'DKK' => 'Kroner',
    'DOP' => 'Pesos',
    'XCD' => 'Dollars',
    'EGP' => 'Pund',
    'SVC' => 'Colones',
    'EEK' => 'Krooni',
    'FKP' => 'Pund',
    'FJD' => 'Dollars',
    'GHC' => 'Cedis',
    'GIP' => 'Pund',
    'GTQ' => 'Quetzales',
    'GGP' => 'Pund',
    'GYD' => 'Dollars',
    'HNL' => 'Lempiras',
    'HKD' => 'Dollars',
    'HUF' => 'Forint',
    'ISK' => 'Kronur',
    'INR' => 'Rupees',
    'IDR' => 'Rupiahs',
    'IRR' => 'Rialer',
    'IMP' => 'Pund',
    'ILS' => 'Ny shekel',
    'JMD' => 'Dollars',
    'JPY' => 'Yen',
    'JEP' => 'Pund',
    'KZT' => 'Tenge',
    'KPW' => 'Vundet',
    'KRW' => 'Vundet',
    'KGS' => 'Soms',
    'LAK' => 'Kips',
    'LVL' => 'Lati',
    'LBP' => 'Pund',
    'LRD' => 'Dollars',
    'CHF' => 'Schweizerfranc',
    'LTL' => 'Litas',
    'MKD' => 'Dinarer',
    'MYR' => 'Ringgits',
    'MUR' => 'Rupees',
    'MXN' => 'Pesos',
    'MNT' => 'Tugriks',
    'MZN' => 'Meticais',
    'NAD' => 'Dollars',
    'NPR' => 'Rupees',
    'ANG' => 'Gylden',
    'NZD' => 'Dollars',
    'NIO' => 'Cordobas',
    'NGN' => 'Nairas',
    'NOK' => 'Kroner',
    'OMR' => 'Rialer',
    'PKR' => 'Rupees',
    'PAB' => 'Balboa',
    'PYG' => 'Guarani',
    'PEN' => 'Nuevos Soles',
    'PHP' => 'Pesos',
    'PLN' => 'Zlotych',
    'QAR' => 'Rialer',
    'RON' => 'Nye Lei',
    'RUB' => 'Rubler',
    'SHP' => 'Pund',
    'SAR' => 'Riyals',
    'RSD' => 'Dinarer',
    'SCR' => 'Rupees',
    'SGD' => 'Dollars',
    'SBD' => 'Dollars',
    'SOS' => 'Shillings',
    'ZAR' => 'Rand',
    'LKR' => 'Rupees',
    'SEK' => 'Kroner',
    'SRD' => 'Dollars',
    'SYP' => 'Pund',
    'TWD' => 'Nye Dollars',
    'THB' => 'Baht',
    'TTD' => 'Dollars',
    'TRY' => 'Lire',
    'TRL' => 'Lire',
    'TVD' => 'Dollars',
    'UAH' => 'Hryvnia',
    'UYU' => 'Pesos',
    'UZS' => 'Sums',
    'VEF' => 'Bolivares Fuertes',
    'VND' => 'Dong',
    'YER' => 'Rialer',
    'ZWD' => 'Zimbabwe Dollars',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'Meget høj',
    '4' => 'Høj',
    '3' => 'Neutral',
    '2' => 'Lav',
    '1' => 'Meget lav',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'Ingen',
    'future' => 'Nuværende værdi',
    'old' => 'Gammel værdi',
    'both' => 'Nuværende og gamle værdier',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'Single-Hit',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'Behandler',
    'error' => 'Fejl',
    'success' => 'Succes',
    'canceled' => 'Annulleret',
    'document_load' => 'Indlæser Skabelon',
    'tags_extract' => 'Udtrækker Mærker',
    'tags_validate' => 'Validerer Mærker',
    'data_retrieving' => 'Henter Data',
    'serialize_document' => 'Sætter dokumentet sammen igen',
    'send_document' => 'Sender dokumentet til dig',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'Flet',
    'convert' => 'PDF-flet',
    'multimerge' => 'Multi-flet',
    'multimerge_convert' => 'Multi-flet PDF',
    'labelsgenerate' => 'Generer Etiketter',
    'labelsgenerate_convert' => 'Generer Etiketter PDF',
    'excel' => 'Excel-flet',
    'excel_convert' => 'Konverter Excel-flet',
    'presentation' => 'PowerPoint-flet',
    'presentation_convert' => 'PowerPoint-flet PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOK',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'Mine konti',
    'favorites' => 'Favoritkonti',
    'tags' => 'Mærkede konti',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'Alle nyheder',
    'General' => 'Generelt',
    'Finance' => 'Finans',
    'People' => 'Personale',
    'Press Releases' => 'Pressemeddelelser',
    'Other' => 'Andet',
];

$app_strings['LBL_OWNERS'] = 'Ejere';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'Skydrev';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'Dashlet til skydrevintegration';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'Kopiér link';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'Hent';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'Opret Sugar-dokument';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'Kan ikke hente denne fil';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'Sky-dashlet findes ikke';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar-dokument oprettet';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'Send til DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign er ikke tilgængelig fra denne placering.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'Doc Merge til Word/Excel/PowerPoint er ikke tilgængelig fra denne placering';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'Doc Merge til DocuSign er ikke tilgængelig fra denne placering';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'Doc Merge til PDF er ikke tilgængelig fra denne placering';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'Din underskrevne fil vil kun blive uploadet her, hvis du har tilladelse til at uploade på denne placering.';
$app_strings['LBL_DOC_MERGE_TO'] = 'Flot dokument til';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'Mine filer';
$app_strings['LBL_SHARED_WITH_ME'] = 'Delt med mig';
$app_strings['LBL_CLOUD_PROVIDER'] = 'Skyudbyder';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'Delt med mig';
$app_strings['LBL_MY_FILES'] = 'Mine filer';
$app_strings['LBL_UPLOAD_FILE'] = 'Overfør fil';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'Mappe ikke fundet';
$app_strings['LBL_CREATE_FOLDER'] = 'Opret mappe';
$app_strings['LBL_LOAD_MORE'] = 'Indlæs mere ...';
$app_strings['LBL_NEW_FOLDER'] = 'Ny mappe';
$app_strings['LBL_FOLDER_NAME'] = 'Mappenavn: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'Du har ikke tilladelse til at gøre det på den aktuelle sti.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'Du har ikke tilladelse til at gå videre ad den aktuelle sti.';
$app_strings['LBL_FILE_UPLOADED'] = 'Filen er blevet uploadet.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'Uploadet tager et stykke tid, fordi din fil er for stor.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'En eller flere dokumentposter har ikke en vedhæftet fil. Vedhæft venligst filer til posterne og prøv igen, eller synkroniser specifikke poster med filer individuelt.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'Forbindelse med Google ikke fundet ...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'Forbindelse med Microsoft ikke fundet ...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'Forbindelse med Dropbox ikke fundet...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'Synkronisering med OneDrive kan tage et stykke tid';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'Er du sikker på, at du vil slette denne fil?';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'Upload til OneDrive er afsluttet.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' er blevet uploadet.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'Fejl under indlæsning af stier.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'Der er opstået en fejl, fordi filen er beskadiget.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'Dokumentet <i>{{documentName}}</i> er blevet gemt på dit drev i cloud og tilføjet til dokumentmodulet.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'Du har ikke tilladelse til at slette denne fil.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'Du har ikke tilladelse til at slette denne mappe.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'Du har ikke tilladelser til at uploade filer til denne placering.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'Du har ikke tilladelse til at oprette en mappe i denne placering.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'Mapper kan ikke oprettes i denne placering.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'Filer kan ikke uploades til denne placering.';
$app_strings['LBL_SITES'] = 'Websteder';
$app_strings['LBL_SHARED'] = 'Delt';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'Link oprettet. Klik på knappen for at kopiere linket til din udklipsholder.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'Kopier til udklipsholder';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-tom-',
    'Exact' => 'Nøjagtig',
    'Null_address_components' => 'En eller flere adressekomponenter skal udfyldes',
    'Invalid_address' => 'Ugyldig adresse. Server returnerede Falsk',
    'Invalid_server_response_not_XML' => 'Ugyldigt serversvar, ikke XML',
    'Invalid_address_no_location' => 'Ugyldig adresse. Server returnerede ingen placering',
    'Ambiguous_address' => 'Tvetydig adresse, flere matchende resultater',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'Vej',
    'a' => 'Luft',
    'rd' => 'Mørk vej',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'Engelsk (USA)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'New York (EST)'],
    ['pst', 'Los Angeles (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['Ny', 'Ny'],
    ['Tildelt', 'Tildelt'],
    ['Lukket', 'Lukket'],
    ['Afventer input', 'Afventer input'],
    ['Afvist', 'Afvist'],
    ['Dupliker', 'Dupliker'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['Administration', 'Administration'],
    ['Produkt', 'Produkt'],
    ['Bruger', 'Bruger'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'Høj'],
    ['P2', 'Mellem'],
    ['P3', 'Lav'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['bruger', 'Bruger'],
    ['admin,bruger', 'Administrator'],
    ['kontoansvarlig, bruger', 'Kontoansvarlig'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', 'De seneste 30 dage'],
    ['last_90_days', 'De seneste 90 dage'],
    ['this_year', 'Sidste år'],
    ['brugerdefineret', 'Brugerdefineret interval'],
    ['alle', 'Alle'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['Standard', 'Standard'],
    ['Farve', 'Ensfarvet'],
    ['URL', 'Brugerdefineret billede'],
];
