<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => 'العربية',
    'moduleList' => [
        'Home' => 'الصفحة الرئيسية',
        'Contacts' => 'جهات الاتصال',
        'Accounts' => 'الحسابات',
        'Opportunities' => 'الفرص',
        'Cases' => 'الحالات',
        'Notes' => 'ملاحظات',
        'Calls' => 'المكالمات',
        'Emails' => 'رسائل البريد الإلكتروني',
        'Meetings' => 'الاجتماعات',
        'Tasks' => 'المهام',
        'Calendar' => 'التقويم',
        'Leads' => 'العملاء المتوقعون',
        'Currencies' => 'العملات',
        'Contracts' => 'العقود',
        'Quotes' => 'عروض الأسعار',
        'Products' => 'البنود المسعرة',
        'WebLogicHooks' => 'أدوات الإضافة المنطقية على الويب',
        'ProductCategories' => 'فئات المنتج',
        'ProductTypes' => 'أنواع المنتج',
        'ProductTemplates' => 'كتالوج المنتج',
        'ProductBundles' => 'حِزم المنتج',
        'ProductBundleNotes' => 'ملاحظات حزم المنتج',
        'Reports' => 'التقارير',
        'Forecasts' => 'التوقعات',
        'ForecastWorksheets' => 'قوائم التوقعات',
        'ForecastManagerWorksheets' => 'قوائم إدارة التوقعات',
        'VisualPipeline' => 'التدفقات البصرية',
        'ConsoleConfiguration' => 'تكوين وحدة التحكم',
        'SugarLive' => 'SugarLive',
        'Quotas' => 'الحصص النسبية',
        'Teams' => 'الفرق',
        'TeamNotices' => 'إشعارات الفريق',
        'Manufacturers' => 'الشركات المصنعة',
        'Activities' => 'الأنشطة',
        'Comments' => 'التعليقات',
        'Subscriptions' => 'الاشتراكات',
        'Bugs' => 'الأخطاء',
        'Feeds' => 'RSS',
        'iFrames' => 'المواقع الخاصة بي',
        'TimePeriods' => 'الفترات الزمنية',
        'TaxRates' => 'أسعار الضريبة',
        'ContractTypes' => 'أنواع العقود',
        'Schedulers' => 'خدمات الجدولة',
        'Project' => 'المشروعات',
        'ProjectTask' => 'مهام المشروع',
        'Campaigns' => 'الحملات',
        'CampaignLog' => 'سجل الحملة',
        'CampaignTrackers' => 'متعقبو الحملة',
        'Documents' => 'المستندات',
        'DocumentRevisions' => 'مراجعات المستند',
        'Connectors' => 'الموصلات',
        'Notifications' => 'الإشعارات',
        'Sync' => 'مزامنة',
        'HintAccountsets' => 'مجموعات حسابات Hint',
        'HintNotificationTargets' => 'أهداف إشعارات Hint',
        'HintNewsNotifications' => 'إشعارات أخبار Hint',
        'HintEnrichFieldConfigs' => 'تكوينات حقل Hint المحسنة',
        'ExternalUsers' => 'المستخدمون الخارجيون',
        'ReportMaker' => 'تقارير متقدمة',
        'DataSets' => 'تنسيقات البيانات',
        'CustomQueries' => 'الاستعلامات المخصصة',
        'pmse_Inbox' => 'العملية',
        'pmse_Project' => 'تعريف العملية',
        'pmse_Business_Rules' => 'القواعد التجارية للعملية',
        'pmse_Emails_Templates' => 'قوالب البريد الإلكتروني للعملية',
        'BusinessCenters' => 'مراكز الأعمال',
        'Shifts' => 'الورديات',
        'ShiftExceptions' => 'استثناءات الورديات',
        'Purchases' => 'المشتريات',
        'PurchasedLineItems' => 'البنود المشتراة',
        'MobileDevices' => 'الأجهزة المحمولة',
        'PushNotifications' => 'إعلامات الدفع',
        'Escalations' => 'عمليات التصعيد',
        'DocumentTemplates' => 'قوالب المستند',
        'DocumentMerges' => 'عمليات دمج المستند',
        'CloudDrivePaths' => 'مسارات محرك السحابة',
        'WorkFlow' => 'تعريفات سير العمل',
        'EAPM' => 'الحسابات الخارجية',
        'Worksheet' => 'ورقة العمل',
        'Users' => 'المستخدمون',
        'Employees' => 'الموظفون',
        'Administration' => 'الإدارة',
        'ACLRoles' => 'الأدوار',
        'InboundEmail' => 'البريد الإلكتروني الوارد',
        'Releases' => 'الإصدارات',
        'Prospects' => 'الأهداف',
        'Queues' => 'قوائم الانتظار',
        'EmailMarketing' => 'البريد التسويقي',
        'EmailTemplates' => 'قوالب البريد الإلكتروني',
        'SNIP' => 'أرشفة البريد الإلكتروني',
        'ProspectLists' => 'قوائم هدف',
        'SavedSearch' => 'عمليات البحث المحفوظة',
        'UpgradeWizard' => 'معالج الترقية',
        'Trackers' => 'وحدات التعقب',
        'TrackerPerfs' => 'أداء المتعقب',
        'TrackerSessions' => 'جلسات وحدات التعقب',
        'TrackerQueries' => 'استعلامات المتعقب',
        'FAQ' => 'الأسئلة المتداولة',
        'Newsletters' => 'الرسائل الإخبارية',
        'SugarFavorites' => 'المفضلة',
        'PdfManager' => 'مدير PDF',
        'DataArchiver' => 'مؤرشف البيانات',
        'ArchiveRuns' => 'أرشفة عمليات التشغيل',

        'OAuthKeys' => 'مفاتيح مستهلك OAuth',
        'OAuthTokens' => 'رموز OAuth',
        'Filters' => 'عوامل التصفية',
        'UserSignatures' => 'توقيعات البريد الإلكتروني',
        'Shippers' => 'مزودي الشحن',
        'Styleguide' => 'دليل الأنماط',
        'Feedbacks' => 'تعليقات',
        'Tags' => 'العلامات',
        'Categories' => 'الفئات',
        'Dashboards' => 'لوحات المعلومات',
        'OutboundEmail' => 'إعدادات البريد الإلكتروني',
        'EmailParticipants' => 'مشتركو البريد الإلكتروني',
        'DataPrivacy' => 'خصوصية البيانات',
        'ReportSchedules' => 'جداول التقرير',
        'CommentLog' => 'سجل التعليقات',
        'Holidays' => 'الإجازات',
        'ChangeTimers' => 'تغيير المؤقتات',
        'Metrics' => 'القياسات',
        'Messages' => 'الرسائل',
        'Audit' => 'التدقيق',
        'RevenueLineItems' => 'بنود العائدات',
        'DocuSignEnvelopes' => 'مغلفات DocuSign',
        'Geocode' => 'الرمز الجفرافي',
        'DRI_Workflows' => 'الأدلة الذكية',
        'DRI_Workflow_Task_Templates' => 'قوالب نشاط الدليل الذكي',
        'DRI_SubWorkflows' => 'مراحل الدليل الذكي',
        'DRI_Workflow_Templates' => 'قوالب الدليل الذكي',
        'CJ_WebHooks' => 'أدوات الإضافة على الويب لـ Sugar Automate',
        'CJ_Forms' => 'إجراءات Smart Guide Sugar',
        'DRI_SubWorkflow_Templates' => 'قوالب مرحلة الدليل الذكي',
        'PubSub_ModuleEvent_PushSubs' => 'اشتراكات دفع أحداث وحدة Pub/Sub',
    ],

    'moduleIconList' => [
        'Home' => 'الصفحة الرئيسية',
        'Contacts' => 'جهات الاتصال',
        'Accounts' => 'الحسابات',
        'Opportunities' => 'الفرص',
        'Cases' => 'Cs',
        'Notes' => 'Nt',
        'Calls' => 'Cl',
        'Emails' => 'رسائل البريد الإلكتروني',
        'Meetings' => 'الاجتماعات',
        'Tasks' => 'Ts',
        'Calendar' => 'التقويم',
        'Leads' => 'العملاء المتوقعون',
        'Currencies' => 'العملات',
        'Contracts' => 'العقود',
        'Quotes' => 'عروض الأسعار',
        'Products' => 'المنتجات',
        'WebLogicHooks' => 'أدوات الإضافة المنطقية على الويب',
        'ProductCategories' => 'PG',
        'ProductTypes' => 'أنواع المنتج',
        'ProductTemplates' => 'قوالب المنتج',
        'ProductBundles' => 'حزم المنتج',
        'ProductBundleNotes' => 'ملاحظات حزم المنتج',
        'Reports' => 'التقارير',
        'Forecasts' => 'التوقعات',
        'ForecastWorksheets' => 'قائمه التوقعات',
        'ForecastManagerWorksheets' => 'قائمه إدارة التوقعات',
        'Quotas' => 'الحصة النسبية',
        'VisualPipeline' => 'التدفقات البصرية',
        'ConsoleConfiguration' => 'تكوين وحدة التحكم',
        'SugarLive' => 'SugarLive',
        'Teams' => 'الفرق',
        'TeamNotices' => 'إشعارات الفريق',
        'Manufacturers' => 'الشركات المصنعة',
        'Activities' => 'الأنشطة',
        'Comments' => 'التعليقات',
        'Subscriptions' => 'الاشتراكات',
        'Bugs' => 'الأخطاء',
        'Feeds' => 'موجز ويب',
        'iFrames' => 'iFrames',
        'TimePeriods' => 'الفترات الزمنية',
        'TaxRates' => 'أسعار الضريبة',
        'ContractTypes' => 'أنواع العقود',
        'Schedulers' => 'خدمات الجدولة',
        'Project' => 'المشروع',
        'ProjectTask' => 'مهمة المشروع',
        'Campaigns' => 'Ca',
        'CampaignLog' => 'سجل الحملة',
        'CampaignTrackers' => 'متعقبو الحملة',
        'Documents' => 'المستندات',
        'DocumentRevisions' => 'مراجعات المستند',
        'Connectors' => 'الموصلات',
        'Notifications' => 'الإشعارات',
        'Sync' => 'مزامنة',
        'HintAccountsets' => 'مجموعات حسابات Hint',
        'HintNotificationTargets' => 'أهداف إشعارات Hint',
        'HintNewsNotifications' => 'إشعارات أخبار Hint',
        'HintEnrichFieldConfigs' => 'تكوينات حقل Hint المحسنة',
        'ExternalUsers' => 'المستخدمون الخارجيون',
        'ReportMaker' => 'صانع التقرير',
        'DataSets' => 'مجموعات البيانات',
        'CustomQueries' => 'الاستعلامات المخصصة',
        'pmse_Inbox' => 'علبة الوارد',
        'pmse_Project' => 'المشروع',
        'pmse_Business_Rules' => 'قواعد العمل',
        'pmse_Emails_Templates' => 'قوالب البريد الإلكتروني',
        'BusinessCenters' => 'مركز الأعمال',
        'Shifts' => 'الورديات',
        'ShiftExceptions' => 'استثناءات الورديات',
        'Purchases' => 'المشتريات',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => 'الأجهزة المحمولة',
        'PushNotifications' => 'إعلامات الدفع',
        'Escalations' => 'عمليات التصعيد',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'محرك السحابة',
        'WorkFlow' => 'سير العمل',
        'EAPM' => 'EAPM',
        'Worksheet' => 'ورقة العمل',
        'Users' => 'المستخدمون',
        'Employees' => 'الموظفون',
        'Administration' => 'الإدارة',
        'ACLRoles' => 'أدوار ACL',
        'InboundEmail' => 'البريد الإلكتروني الوارد',
        'Releases' => 'الإصدارات',
        'Prospects' => 'العميل المتوقع',
        'Queues' => 'قوائم الانتظار',
        'EmailMarketing' => 'البريد التسويقي',
        'EmailTemplates' => 'قوالب البريد الإلكترونية',
        'SNIP' => 'SNIP',
        'ProspectLists' => 'قوائم العملاء المتوقعين',
        'SavedSearch' => 'البحث المحفوظ',
        'UpgradeWizard' => 'معالج الترقية',
        'Trackers' => 'المتعقبون',
        'TrackerPerfs' => 'أداء المتعقب',
        'TrackerSessions' => 'جلسات المتعقب',
        'TrackerQueries' => 'استعلامات المتعقب',
        'FAQ' => 'الأسئلة المتداولة',
        'Newsletters' => 'الرسائل الإخبارية',
        'SugarFavorites' => 'مفضلة Sugar',
        'PdfManager' => 'مدير Pdf',
        'DataArchiver' => 'مؤرشف البيانات',
        'ArchiveRuns' => 'أرشفة عمليات التشغيل',
        'OAuthKeys' => 'مفاتيح OAuth',
        'OAuthTokens' => 'رموز OAuth',
        'Filters' => 'عوامل التصفية',
        'UserSignatures' => 'توقيعات المستخدم',
        'Shippers' => 'الشاحنون',
        'Styleguide' => 'دليل الأنماط',
        'Feedbacks' => 'تعليقات',
        'Tags' => 'العلامات',
        'Categories' => 'الفئات',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'البريد الإلكتروني الصادر',
        'EmailParticipants' => 'مشتركو البريد الإلكتروني',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => 'جداول التقرير',
        'CommentLog' => 'سجل التعليقات',
        'Holidays' => 'الإجازات',
        'ChangeTimers' => 'تغيير المؤقتات',
        'Metrics' => 'القياسات',
        'Messages' => 'الرسائل',
        'Audit' => 'التدقيق',
        'RevenueLineItems' => 'بنود العائدات',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => 'الرمز الجفرافي',
        'DRI_Workflows' => 'سير عمل DRI',
        'DRI_Workflow_Task_Templates' => 'قوالب مهمة سير عمل DRI',
        'DRI_SubWorkflows' => 'سير عمل DRI فرعي',
        'DRI_Workflow_Templates' => 'قوالب سير عمل DRI',
        'CJ_WebHooks' => 'أدوات إضافة CJ على الويب',
        'CJ_Forms' => 'نماذج CJ',
        'DRI_SubWorkflow_Templates' => 'قوالب سير عمل DRI',
        'Library' => 'المكتبة',
        'EmailAddresses' => 'عناوين البريد الإلكتروني',
        'Words' => 'الكلمات',
        'Sugar_Favorites' => 'مفضلة Sugar',
        'KBDocuments' => 'مستندات KB',
        'KBContents' => 'محتويات KB',
        'KBArticles' => 'مقالات KB',
        'KBContentTemplates' => 'قوالب محتوى KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => 'الملفات المضمنة',
    ],

    'moduleListSingular' => [
        'Home' => 'الصفحة الرئيسية',
        'Dashboards' => 'لوحة المعلومات',
        'Styleguide' => 'دليل الأنماط',
        'Contacts' => 'جهة الاتصال',
        'Accounts' => 'الحساب',
        'Opportunities' => 'جديدة',
        'Cases' => 'الحالة',
        'Notes' => 'ملاحظة',
        'Calls' => 'المكالمة',
        'Emails' => 'البريد الإلكتروني',
        'Meetings' => 'الاجتماع',
        'Tasks' => 'المهمة',
        'Calendar' => 'التقويم',
        'Leads' => 'العميل المتوقع',
        'Manufacturers' => 'الشركة المصنعة',
        'VisualPipeline' => 'التدفقات البصرية',
        'ConsoleConfiguration' => 'تكوين وحدة التحكم',
        'MobileDevices' => 'الجهاز المحمول',
        'SugarLive' => 'SugarLive',
        'Contracts' => 'العقد',
        'Quotes' => 'عرض السعر',
        'Products' => 'البند المسعر',
        'ProductCategories' => 'فئة المنتج',
        'ProductBundles' => 'حِزمة المنتج',
        'ProductBundleNotes' => 'ملاحظة حزمة المنتج',
        'RevenueLineItems' => 'بند العائد',
        'WebLogicHooks' => 'أداة الإضافة المنطقي على الويب',
        'Reports' => 'التقرير',
        'Forecasts' => 'التوقع',
        'ForecastWorksheets' => 'قائمه التوقعات',
        'ForecastManagerWorksheets' => 'قائمه إدارة التوقعات',
        'Quotas' => 'الحصة النسبية',
        'Teams' => 'الفريق',
        'TeamNotices' => 'إشعار الفريق',
        'Activities' => 'النشاط',
        'ActivityStream' => 'سير النشاط الكلي',
        'Bugs' => 'الخطأ',
        'Feeds' => 'RSS',
        'iFrames' => 'المواقع الخاصة بي',
        'TimePeriods' => 'الفترة الزمنية',
        'TaxRates' => 'سعر الضريبة',
        'ContractTypes' => 'نوع العقد',
        'Schedulers' => 'المجدول',
        'Campaigns' => 'الحملة',
        'CampaignLog' => 'سجل الحملة',
        'Project' => 'المشروع',
        'ProjectTask' => 'مهمة المشروع',
        'Prospects' => 'الهدف',
        'ProspectLists' => 'قائمة هدف',
        'CampaignTrackers' => 'متعقب الحملة',
        'Documents' => 'المستند',
        'DocumentRevisions' => 'مراجعة المستند',
        'Connectors' => 'الموصل',
        'Notifications' => 'الإشعار',
        'Sync' => 'مزامنة',
        'PdfManager' => 'مدير PDF',
        'DataArchiver' => 'مؤرشف البيانات',
        'ArchiveRuns' => 'أرشفة عمليات التشغيل',
        'ExternalUsers' => 'المستخدم الخارجي',
        'ReportMaker' => 'تقرير متقدم',
        'DataSets' => 'تنسيق البيانات',
        'CustomQueries' => 'الاستعلام المخصص',
        'pmse_Inbox' => 'العملية',
        'pmse_Project' => 'تعريف العملية',
        'pmse_Business_Rules' => 'القاعدة التجارية للعملية',
        'pmse_Emails_Templates' => 'قالب البريد الإلكتروني للعملية',
        'BusinessCenters' => 'مركز الأعمال',
        'Shifts' => 'الوردية',
        'ShiftExceptions' => 'استثناءات الورديات',
        'Purchases' => 'شراء',
        'PurchasedLineItems' => 'البند المشترى',
        'PushNotifications' => 'إعلامات الدفع',
        'Escalations' => 'عملية التصعيد',
        'DocumentTemplates' => 'قالب المستند',
        'DocumentMerges' => 'دمج المستند',
        'CloudDrivePaths' => 'مسار محرك السحابة',
        'WorkFlow' => 'سير العمل',
        'EAPM' => 'الحساب الخارجي',
        'Worksheet' => 'ورقة العمل',
        'Users' => 'المستخدم',
        'SugarFavorites' => 'مفضلة Sugar',
        'Employees' => 'الموظف',
        'Administration' => 'الإدارة',
        'ACLRoles' => 'الدور',
        'InboundEmail' => 'البريد الإلكتروني الوارد',
        'Releases' => 'الإصدار',
        'Queues' => 'قائمة الانتظار',
        'EmailMarketing' => 'البريد التسويقي',
        'EmailTemplates' => 'قالب البريد الإلكتروني',
        'SNIP' => 'أرشفة البريد الإلكتروني',
        'SavedSearch' => 'البحث المحفوظ',
        'UpgradeWizard' => 'معالج الترقية',
        'Trackers' => 'المتعقب',
        'TrackerPerfs' => 'أداء المتعقب',
        'TrackerSessions' => 'جلسة المتعقب',
        'TrackerQueries' => 'استعلام المتعقب',
        'FAQ' => 'الأسئلة المتداولة',
        'Newsletters' => 'رسالة إخبارية',
        'OAuthKeys' => 'مفتاح مستهلك OAuth',
        'OAuthTokens' => 'رمز OAuth',
        'Filters' => 'الفلتر',
        'Comments' => 'تعليق',
        'CommentLog' => 'سجل التعليقات',
        'Currencies' => 'العملة',
        'ProductTemplates' => 'Product',
        'ProductTypes' => 'نوع المنتج',
        'Shippers' => 'مزود الشحن',
        'Subscriptions' => 'الاشتراك',
        'UserSignatures' => 'توقيع البريد الإلكتروني',
        'Feedbacks' => 'تعليقات',
        'Tags' => 'العلامة',
        'Categories' => 'الفئة',
        'OutboundEmail' => 'إعداد البريد الإلكتروني',
        'EmailParticipants' => 'مشترك البريد الإلكتروني',
        'DataPrivacy' => 'خصوصية البيانات',
        'ReportSchedules' => 'جدول التقرير',
        'Holidays' => 'الإجازة',
        'ChangeTimers' => 'تغيير المؤقت',
        'Metrics' => 'القياس',
        'Messages' => 'الرسالة',
        'Audit' => 'التدقيق',
        'DocuSignEnvelopes' => 'مغلف DocuSign',
        'HintAccountsets' => 'مجموعات حسابات Hint',
        'HintNotificationTargets' => 'أهداف إشعارات Hint',
        'HintNewsNotifications' => 'إشعارات أخبار Hint',
        'HintEnrichFieldConfigs' => 'تكوينات حقل Hint المحسنة',
        'Geocode' => 'الرمز الجفرافي',
        'DRI_Workflows' => 'الدليل الذكي',
        'DRI_Workflow_Task_Templates' => 'قالب نشاط الدليل الذكي',
        'DRI_SubWorkflows' => 'مرحلة الدليل الذكي',
        'DRI_Workflow_Templates' => 'قالب الدليل الذكي',
        'CJ_WebHooks' => 'أداة الإضافة على الويب لـ Sugar Automate',
        'CJ_Forms' => 'إجراء Smart Guide Sugar',
        'DRI_SubWorkflow_Templates' => 'قالب مرحلة الدليل الذكي',
        'PubSub_ModuleEvent_PushSubs' => 'اشتراك دفع أحداث وحدة Pub/Sub',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => 'نعم',
        '2' => 'لا',
    ],

    'checkbox_massupdate_dom' => [
        0 => 'لا',
        1 => 'نعم',
    ],

    'notifications_status_dom' => [
        0 => 'غير مقروء',
        1 => 'مقروء',
    ],

    'optout_dom' => [
        '' => '-بلا-',
        'false' => 'لا',
        'true' => 'نعم',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => 'المحلل',
        'Competitor' => 'المنافس',
        'Customer' => 'العميل',
        'Integrator' => 'الموحد',
        'Investor' => 'المستثمر',
        'Partner' => 'شريك',
        'Press' => 'الصحافة',
        'Prospect' => 'العميل المتوقع',
        'Reseller' => 'الموزع',
        'Other' => 'أخرى',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => 'النسيج',
        'Banking' => 'الأعمال المصرفية',
        'Biotechnology' => 'التكنولوجيا الحيوية',
        'Chemicals' => 'المواد الكيماوية',
        'Communications' => 'الاتصالات',
        'Construction' => 'المقاولات',
        'Consulting' => 'الاستشارة',
        'Education' => 'التعليم',
        'Electronics' => 'الإلكترونيات',
        'Energy' => 'الطاقة',
        'Engineering' => 'الهندسة',
        'Entertainment' => 'التسلية',
        'Environmental' => 'البيئية',
        'Finance' => 'التمويل',
        'Government' => 'الحكومة',
        'Healthcare' => 'الرعاية الصحية',
        'Hospitality' => 'ضيافة',
        'Insurance' => 'التأمين',
        'Machinery' => 'آليات',
        'Manufacturing' => 'التصنيع',
        'Media' => 'الإعلام',
        'Not For Profit' => 'غير هادف للربح',
        'Recreation' => 'ترفيه',
        'Retail' => 'تجزئة',
        'Shipping' => 'الشحن',
        'Technology' => 'التكنولوجيا',
        'Telecommunications' => 'الاتصالات عند بُعد',
        'Transportation' => 'المواصلات',
        'Utilities' => 'خدمات',
        'Other' => 'أخرى',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF وCSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => 'المخطط',
        'Data Table' => 'جدول البيانات',
        'Chart and Data Table' => 'المخطط وجدول البيانات',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => 'قيد التقدم',
        'Completed' => 'المكتملة',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => 'الواردة',
        'Outbound' => 'الصادرة',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => 'الدردشة',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => 'المستوى 1',
        'T2' => 'المستوى 2',
        'T3' => 'المستوى 3',
        'T4' => 'المستوى 4',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => 'نعم',
        'No' => 'لا',
        'Completed' => 'مكتمل',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => 'المستقبلية',
        'Active' => 'النشطة',
        'Past' => 'السابقة',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'إعدادات Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => 'منشأة ذاتيًا',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => 'المكالمة التسويقية',
        'Existing Customer' => 'العميل الحالي',
        'Self Generated' => 'منشأة ذاتيًا',
        'Employee' => 'الموظف',
        'Partner' => 'شريك',
        'Public Relations' => 'العلاقات العامة',
        'Direct Mail' => 'البريد المباشر',
        'Conference' => 'المؤتمر',
        'Trade Show' => 'معرض',
        'Web Site' => 'موقع الويب',
        'Word of mouth' => 'السماع',
        'Email' => 'البريد الإلكتروني',
        'Campaign' => 'الحملة',
        'Support Portal User Registration' => 'دعم تسجيل مستخدم البوابة',
        'Other' => 'أخرى',
    ],
    'metric_status_dom' => [
        'Inactive' => 'غير نشط',
        'Active' => 'نشط',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => 'صفقة حالية',
        'New Business' => 'صفقة جديدة',
    ],
    'taxrate_status_dom' => [
        'Active' => 'نشط',
        'Inactive' => 'غير نشط',
    ],
    'roi_type_dom' => [
        'Revenue' => 'العائد',
        'Investment' => 'الاستثمار',
        'Expected_Revenue' => 'العائد المتوقع',
        'Budget' => 'الميزانية',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => 'متخذ القرار الرئيسي',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'متخذ القرار الرئيسي',
        'Business Decision Maker' => 'متخذ قرار الأعمال',
        'Business Evaluator' => 'مُقيّم الأعمال',
        'Technical Decision Maker' => 'متخذ القرار الفني',
        'Technical Evaluator' => 'المقيم الفني',
        'Executive Sponsor' => 'الراعي التنفيذي',
        'Influencer' => 'المؤثر',
        'Other' => 'أخرى',
    ],

    'manufacturer_status_dom' => [
        'Active' => 'نشط',
        'Inactive' => 'غير نشط',
    ],

    'shipper_status_dom' => [
        'Active' => 'نشط',
        'Inactive' => 'غير نشط',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => 'جهة الاتصال الرئيسية',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => 'جهة الاتصال الرئيسية',
        'Alternate Contact' => 'جهة الاتصال البديلة',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => 'بجانب قيمة الحقل',
        'field_on_top' => 'فوق قيمة الحقل',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => 'الصافي 15',
        'Net 30' => 'الصافي 30',
    ],
    'sales_stage_default_key' => 'التوقع',
    'fts_type' => [
        'Elastic' => 'البحث المرن',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => 'التوقع',
        'Qualification' => 'التأهل',
        'Needs Analysis' => 'تحتاج إلى تحليل',
        'Value Proposition' => 'عرض القيمة',
        'Id. Decision Makers' => 'المعرّف. صُنَّاع القرار',
        'Perception Analysis' => 'تحليل الإدراك',
        'Proposal/Price Quote' => 'عرض السعر/الاقتراح',
        'Negotiation/Review' => 'التفاوض/المراجعة',
        'Closed Won' => 'إغلاق لسبب الفوز',
        'Closed Lost' => 'إغلاق لسبب الخساره',
    ],
    'sales_status_with_quote_dom' => [
        'New' => 'جديد',
        'In Progress' => 'يتقدم',
        'Closed Won' => 'إغلاق لسبب الفوز',
        'Closed Lost' => 'إغلاق لسبب الخساره',
        'Converted to Quote' => 'محول إلى عرض سعر',
    ],
    'sales_status_dom' => [
        'New' => 'جديد',
        'In Progress' => 'قيد التقدم',
        'Closed Won' => 'إغلاق لسبب الفوز',
        'Closed Lost' => 'إغلاق لسبب الخساره',
    ],

    'commit_stage_binary_dom' => [
        'include' => 'تضمين',
        'exclude' => 'استبعاد',
    ],
    'commit_stage_dom' => [
        'include' => 'تضمين',
        'upside' => 'الجانب الأعلى',
        'exclude' => 'استبعاد',
    ],

    'commit_stage_custom_dom' => [
        'include' => 'تضمين',
        'upside' => 'الجانب الأعلى',
        'exclude' => 'استبعاد',
    ],

    'in_total_group_stages' => [
        'Draft' => 'المسودة',
        'Negotiation' => 'التفاوض',
        'Delivered' => 'مستلم',
        'On Hold' => 'قيد التعليق',
        'Confirmed' => 'مؤكد',
        'Closed Accepted' => 'مقبول مغلق',
        'Closed Lost' => 'إغلاق لسبب الخساره',
        'Closed Dead' => 'خامد مغلق',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => 'المكالمة',
        'Meeting' => 'الاجتماع',
        'Task' => 'المهمة',
        'Email' => 'البريد الإلكتروني',
        'Note' => 'ملاحظة',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => 'السيد',
        'Ms.' => 'الآنسة',
        'Mrs.' => 'السيدة',
        'Dr.' => 'دكتور',
        'Prof.' => 'بروفيسور',
        'Mx.' => 'أقصى',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => 'بلا',
        60 => 'دقيقة سابقة',
        300 => '5 دقائق سابقة',
        600 => '10 دقائق سابقة',
        900 => '15 دقيقة سابقة',
        1800 => '30 دقيقة سابقة',
        3600 => 'ساعة سابقة',
        7200 => 'ساعتان سابقتان',
        10800 => '3 ساعات سابقة',
        18000 => '5 ساعات سابقة',
        86400 => 'يوم سابق',
        ],

        'task_priority_default' => 'متوسط',
        'task_priority_dom' => [
        'High' => 'عالية',
        'Medium' => 'متوسطة',
        'Low' => 'منخفضة',
        ],
        'task_status_default' => 'لم يبدأ',
        'task_status_dom' => [
        'Not Started' => 'لم يبدأ',
        'In Progress' => 'يتقدم',
        'Completed' => 'كامل',
        'Pending Input' => 'إدخال معلق',
        'Deferred' => 'مؤجل',
        'Not Applicable' => 'لا ينطبق',
        ],
        'meeting_status_default' => 'مخطط',
        'meeting_status_dom' => [
        'Planned' => 'تمت الجدولة',
        'Held' => 'تم الإجراء',
        'Not Held' => 'تم الإلغاء',
        'Deferred' => 'مؤجل',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => 'أخرى',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => 'مخطط',
        'call_status_dom' => [
        'Planned' => 'تمت الجدولة',
        'In Progress' => 'قيد التقدم',
        'Held' => 'تم الإجراء',
        'Not Held' => 'تم الإلغاء',
        'Deferred' => 'مؤجل',
        ],
        'call_direction_default' => 'خارجي',
        'call_direction_dom' => [
        'Inbound' => 'داخلي',
        'Outbound' => 'خارجي',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => 'جديد',
        'Assigned' => 'معيَّن',
        'In Process' => 'قيد التقدم',
        'Converted' => 'محول',
        'Recycled' => 'معاد تصنيعه',
        'Dead' => 'خامد',
        ],
        'gender_list' => [
        'male' => 'ذكر',
        'female' => 'أنثى',
        'other' => 'أخرى',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => 'New',
        'case_status_dom' => [
        'New' => 'جديد',
        'Assigned' => 'معيَّن',
        'Closed' => 'مغلق',
        'Pending Input' => 'إدخال معلق',
        'Rejected' => 'مرفوض',
        'Duplicate' => 'تكرار',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => 'عالٍ',
        'P2' => 'متوسط',
        'P3' => 'منخفض',
        ],
        'user_type_dom' => [
        'RegularUser' => 'مستخدم عادي',
        'Administrator' => 'المسؤول',
        ],
        'user_type_bool_dom' => [
            false => 'مستخدم عادي',
            true => 'المسؤول',
        ],
        'user_type_group_bool_dom' => [
            true => 'مستخدم المجموعة',
        ],
        'user_type_portal_bool_dom' => [
            true => 'مستخدم واجهة برمجة تطبيقات المدخل',
        ],
        'license_type_dom' => [
        'CURRENT' => 'المنتج الحالي',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => 'نشط',
        'Inactive' => 'غير نشط',
        ],
        'employee_status_dom' => [
        'Active' => 'نشط',
        'Terminated' => 'منتهٍ',
        'Leave of Absence' => 'غياب عن العمل بإذن',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => 'نشط',
        'Inactive' => 'غير نشط',
        ],
        'project_task_priority_options' => [
        'High' => 'عالٍ',
        'Medium' => 'متوسط',
        'Low' => 'منخفض',
        ],
        'project_task_priority_default' => 'متوسط',

        'project_task_status_options' => [
        'Not Started' => 'لم يبدأ',
        'In Progress' => 'يتقدم',
        'Completed' => 'كامل',
        'Pending Input' => 'إدخال معلق',
        'Deferred' => 'مؤجل',
        ],
        'project_task_utilization_options' => [
        '0' => 'بلا',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => 'المسودة',
        'In Review' => 'قيد المراجعة',
        'Published' => 'تم النشر',
        ],
        'project_status_default' => 'المسودة',

        'project_duration_units_dom' => [
        'Days' => 'أيام',
        'Hours' => 'ساعات',
        ],

        'project_priority_options' => [
        'High' => 'عالٍ',
        'Medium' => 'متوسط',
        'Low' => 'منخفض',
        ],
        'project_priority_default' => 'متوسط',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => 'Accounts',
        'record_type_display' => [
        '' => '',
        'Accounts' => 'الحساب',
        'Opportunities' => 'الفرصة',
        'Cases' => 'الحالة',
        'Leads' => 'العميل المتوقع',
        'Contacts' => 'جهات الاتصال', // cn (11/22/2005) added to support Emails
        'Products' => 'البند المسعر',
        'Quotes' => 'عرض السعر',
        'Bugs' => 'الخطأ',
        'Project' => 'المشروع',

        'Prospects' => 'الهدف',
        'ProjectTask' => 'مهمة المشروع',

        'Tasks' => 'المهمة',
        'KBContents' => 'قاعدة المعارف',
        'Notes' => 'ملاحظة',
        ],

        'record_type_display_notes' => [
        'Accounts' => 'الحساب',
        'Contacts' => 'جهة الاتصال',
        'Opportunities' => 'الفرصة',
        'Tasks' => 'المهمة',
        'ProductTemplates' => 'كتالوج المنتج',
        'Quotes' => 'عرض السعر',
        'Products' => 'البند المسعر',
        'Contracts' => 'العقد',
        'Emails' => 'البريد الإلكتروني',

        'Bugs' => 'الخطأ',
        'Project' => 'المشروع',
        'ProjectTask' => 'مهمة المشروع',
        'Prospects' => 'الهدف',
        'Cases' => 'الحالة',
        'Leads' => 'العميل المتوقع',

        'Meetings' => 'الاجتماع',
        'Calls' => 'المكالمة',
        'KBContents' => 'قاعدة المعارف',
        'PurchasedLineItems' => 'البند المشترى',
        'Purchases' => 'شراء',
        'Escalations' => 'عملية التصعيد',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => 'الحساب',
        'Contacts' => 'جهة الاتصال',
        'Employees' => 'الموظف',
        'Leads' => 'العميل المتوقع',
        'Prospects' => 'الهدف',
        'Users' => 'المستخدم',
        ],

        'parent_type_display' => [
        'Accounts' => 'الحساب',
        'Contacts' => 'جهة الاتصال',
        'Tasks' => 'المهمة',
        'Opportunities' => 'الفرصة',
        'Products' => 'البند المسعر',
        'Quotes' => 'عرض السعر',

        'Bugs' => 'الأخطاء',
        'Cases' => 'الحالة',
        'Leads' => 'العميل المتوقع',

        'Project' => 'المشروع',
        'ProjectTask' => 'مهمة المشروع',

        'Prospects' => 'الهدف',
        'KBContents' => 'قاعدة المعارف',
        'Notes' => 'ملاحظة',
        'PurchasedLineItems' => 'البند المشترى',
        'Purchases' => 'شراء',
        'Escalations' => 'عملية التصعيد',
        ],

        'changetimer_parent_type' => [
        'Cases' => 'الحالة',
        ],

        'product_status_default_key' => 'الشحن',
        'product_status_quote_key' => 'عروض الأسعار',
        'product_status_dom' => [
        '' => '',
        'Quotes' => 'تم عمل عرض سعر له',
        'Orders' => 'تم طلبه',
        'Ship' => 'تم شحنه',
        ],
        'active_status_dom' => [
        'Active' => 'نشطة',
        'Inactive' => 'غير نشطة',
        'Retired' => 'ملغاة',
        ],
        'appearance_options' => [
        'system_default' => 'استخدام إعداد النظام',
        'light' => 'فاتح',
        'dark' => 'داكن',
        ],


        'pricing_formula_default_key' => 'ثابت',
        'pricing_formula_dom' => [
        'Fixed' => 'سعر ثابت',
        'ProfitMargin' => 'هامش الربح',
        'PercentageMarkup' => 'رفع للسعر أعلى من التكلفة',
        'PercentageDiscount' => 'الخصم من القائمة',
        'IsList' => 'مثل القائمة',
        ],
        'product_template_status_dom' => [
        'Available' => 'في المخزون',
        'Unavailable' => 'خارج المخزون',
        ],
        'tax_class_dom' => [
        'Taxable' => 'مستحق الضريبة',
        'Non-Taxable' => 'غير مستحق الضريبة',
        ],
        'support_term_dom' => [
        '+6 months' => 'ستة شهور',
        '+1 year' => 'سنة واحدة',
        '+2 years' => 'سنتان',
        ],

        'quote_type_dom' => [
        'Quotes' => 'عرض السعر',
        'Orders' => 'الترتيب',
        ],
        'default_quote_stage_key' => 'المسودة',
        'quote_stage_dom' => [
        'Draft' => 'المسودة',
        'Negotiation' => 'التفاوض',
        'Delivered' => 'مستلم',
        'On Hold' => 'قيد التعليق',
        'Confirmed' => 'مؤكد',
        'Closed Accepted' => 'مقبول مغلق',
        'Closed Lost' => 'إغلاق لسبب الخساره',
        'Closed Dead' => 'خامد مغلق',
        ],
        'default_order_stage_key' => 'معلق',
        'order_stage_dom' => [
        'Pending' => 'معلق',
        'Confirmed' => 'مؤكد',
        'On Hold' => 'قيد التعليق',
        'Shipped' => 'تم شحنه',
        'Cancelled' => 'ملغي',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => 'متخذ القرار الرئيسي',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => 'متخذ القرار الرئيسي',
        'Business Decision Maker' => 'متخذ قرار الأعمال',
        'Business Evaluator' => 'مُقيّم الأعمال',
        'Technical Decision Maker' => 'متخذ القرار الفني',
        'Technical Evaluator' => 'المقيم الفني',
        'Executive Sponsor' => 'الراعي التنفيذي',
        'Influencer' => 'المؤثر',
        'Other' => 'أخرى',
        ],
        'layouts_dom' => [
        'Standard' => 'عرض السعر',
        'Invoice' => 'الفاتورة',
        ],
        'issue_priority_default_key' => 'متوسط',
        'issue_priority_dom' => [
        'Urgent' => 'عاجل',
        'High' => 'عالٍ',
        'Medium' => 'متوسط',
        'Low' => 'منخفض',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => 'مقبول',
        'Duplicate' => 'تكرار',
        'Closed' => 'مغلق',
        'Out of Date' => 'قديم',
        'Invalid' => 'غير صالح',
        ],

        'issue_status_default_key' => 'جديد',
        'issue_status_dom' => [
        'New' => 'جديد',
        'Assigned' => 'معيَّن',
        'Closed' => 'مغلق',
        'Pending' => 'معلق',
        'Rejected' => 'مرفوض',
        ],

        'bug_priority_default_key' => 'متوسط',
        'bug_priority_dom' => [
        'Urgent' => 'عاجل',
        'High' => 'عالٍ',
        'Medium' => 'متوسط',
        'Low' => 'منخفض',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => 'مقبول',
        'Duplicate' => 'تكرار',
        'Fixed' => 'ثابت',
        'Out of Date' => 'قديم',
        'Invalid' => 'غير صالح',
        'Later' => 'لاحقًا',
        ],
        'bug_status_default_key' => 'جديد',
        'bug_status_dom' => [
        'New' => 'جديد',
        'Assigned' => 'معيَّن',
        'Closed' => 'مغلق',
        'Pending' => 'معلق',
        'Rejected' => 'مرفوض',
        ],
        'bug_type_default_key' => 'الخطأ',
        'bug_type_dom' => [
        'Defect' => 'عيب',
        'Feature' => 'ميزة',
        ],
        'case_type_dom' => [
        'Administration' => 'الإدارة',
        'Product' => 'المنتج',
        'User' => 'المستخدم',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => 'داخلي',
        'Forum' => 'منتدى',
        'Web' => 'الويب',
        'InboundEmail' => 'البريد الإلكتروني',
        'Twitter' => 'Twitter',
        'Portal' => 'المدخل',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => 'الداخلي',
        'Forum' => 'المنتدى',
        'Web' => 'الويب',
        'InboundEmail' => 'البريد الإلكتروني',
        'Twitter' => 'Twitter',
        'Portal' => 'المدخل',
        'Phone' => 'الهاتف',
        'Chat' => 'الدردشة',
        'Chatbot' => 'روبوت الدردشة',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => 'طلب سياسة خصوصية بيانات',
        'Send Personal Information being processed' => 'إرسال لمعلومات الشخصية التي تتم معالجتها',
        'Rectify Information' => 'تصويب المعلومات',
        'Request to Erase Information' => 'طلب مسح المعلومات',
        'Export Information' => 'تصدير المعلومات',
        'Restrict Processing' => 'تقييد المعالجة',
        'Object to Processing' => 'الاعتراض على المعالجة',
        'Consent to Process' => 'الموافقة على المعالجة',
        'Withdraw Consent' => 'سحب الموافقة',
        'Other' => 'أخرى',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => 'الاتصالات التجارية',
        'Marketing Communications by company' => 'الاتصالات التسويقية بواسطة الشركة',
        'Marketing Communications by partners' => 'الاتصالات التسويقية بواسطة الشركاء',
        ],
        'dataprivacy_status_default_key' => 'مفتوح',
        'dataprivacy_status_dom' => [
        'Open' => 'مفتوح',
        'Closed' => 'مكتمل',
        'Rejected' => 'مرفوض',
        ],
        'dataprivacy_priority_default_key' => 'منخفض',
        'dataprivacy_priority_dom' => [
        'Low' => 'منخفض',
        'Medium' => 'متوسط',
        'High' => 'مرتفع',
        ],
        'business_day_status_dom' => [
        'Open' => 'فتح',
        'Open 24 Hours' => 'مفتوح 24 ساعة',
        'Closed' => 'مغلق',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => 'الحسابات',
        'Activities' => 'الأنشطة',
        'Bug Tracker' => 'متتبع الأخطاء',
        'Calendar' => 'التقويم',
        'Calls' => 'المكالمات',
        'Campaigns' => 'الحملات',
        'Cases' => 'الحالات',
        'Contacts' => 'جهات الاتصال',
        'Currencies' => 'العملات',
        'Dashboard' => 'لوحة المعلومات',
        'Documents' => 'المستندات',
        'Emails' => 'رسائل البريد الإلكتروني',
        'Feeds' => 'موجز ويب',
        'Forecasts' => 'التوقعات',
        'Help' => 'تعليمات',
        'Home' => 'الصفحة الرئيسية',
        'Leads' => 'العملاء المتوقعون',
        'Meetings' => 'الاجتماعات',
        'Notes' => 'ملاحظات',
        'Opportunities' => 'الفرص',
        'Outlook Plugin' => 'المكون الإضافي لـ Outlook',
        'Product Catalog' => 'كتالوج المنتج',
        'Products' => 'البنود المسعرة',
        'RevenueLineItems' => 'بنود العائدات',
        'Projects' => 'المشروعات',
        'Quotes' => 'عروض الأسعار',
        'Releases' => 'الإصدارات',
        'RSS' => 'RSS',
        'Studio' => 'الاستوديو',
        'Upgrade' => 'الترقية',
        'Users' => 'المستخدمون',
        'OutboundEmail' => 'إعدادات البريد الإلكتروني',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => 'التخطيط',
        'Active' => 'نشط',
        'Inactive' => 'غير نشط',
        'Complete' => 'مكتمل',
        'In Queue' => 'في قائمة انتظار',
        'Sending' => 'إرسال',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => 'البيع عن بُعد',
        'Mail' => 'البريد',
        'Email' => 'البريد الإلكتروني',
        'Print' => 'طباعة',
        'Web' => 'الويب',
        'Radio' => 'زر اختيار',
        'Television' => 'التليفزيون',
        'NewsLetter' => 'رسالة إخبارية',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => 'أسبوعيًا',
        'Monthly' => 'شهريًا',
        'Quarterly' => 'ربع سنوي',
        'Annually' => 'سنويًا',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => 'يناير',
        '2' => 'فبراير',
        '3' => 'مارس',
        '4' => 'أبريل',
        '5' => 'مايو',
        '6' => 'يونيو',
        '7' => 'يوليو',
        '8' => 'أغسطس',
        '9' => 'سبتمبر',
        '10' => 'أكتوبر',
        '11' => 'نوفمبر',
        '12' => 'ديسمبر',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => 'ينا',
        '2' => 'فبر',
        '3' => 'مار',
        '4' => 'أبر',
        '5' => 'مايو',
        '6' => 'يون',
        '7' => 'يول',
        '8' => 'أغس',
        '9' => 'سبت',
        '10' => 'أكت',
        '11' => 'نوف',
        '12' => 'ديس',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => 'الأحد',
        '2' => 'الاثنين',
        '3' => 'الثلاثاء',
        '4' => 'الأربعاء',
        '5' => 'الخميس',
        '6' => 'الجمعة',
        '7' => 'السبت',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => 'أحد',
        '2' => 'إثن',
        '3' => 'ثلا',
        '4' => 'أرب',
        '5' => 'خمس',
        '6' => 'جمع',
        '7' => 'سبت',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => 'أحد',
        '2' => 'إثنين',
        '3' => 'ثلاثاء',
        '4' => 'أربعاء',
        '5' => 'خميس',
        '6' => 'جمعة',
        '7' => 'سبت',
        ],
        'dom_cal_day_of_week' => [
        '0' => 'أحد',
        '1' => 'إثن',
        '2' => 'ثلا',
        '3' => 'أرب',
        '4' => 'خمس',
        '5' => 'جمع',
        '6' => 'سبت',
        ],
        'dom_meridiem_lowercase' => [
        'am' => 'ص',
        'pm' => 'م',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => 'ص',
        'PM' => 'م',
        ],

        'dom_report_types' => [
        'tabular' => 'الصفوف والأعمدة',
        'summary' => 'مجموع',
        'detailed_summary' => 'مجموع بتفاصيل',
        'Matrix' => 'المصفوفة',
        ],


        'dom_email_types' => [
        'out' => 'المرسلة',
        'archived' => 'المؤرشفة',
        'draft' => 'المسودة',
        'inbound' => 'داخلي',
        'campaign' => 'الحملة',
        ],
        'dom_email_status' => [
        'archived' => 'المؤرشفة',
        'closed' => 'مغلق',
        'draft' => 'في المسودة',
        'read' => 'مقروء',
        'replied' => 'تم الرد',
        'sent' => 'المرسلة',
        'send_error' => 'خطأ في الإرسال',
        'unread' => 'غير مقروء',
        ],
        'dom_email_archived_status' => [
        'archived' => 'المؤرشفة',
        ],

        'dom_email_server_type' => ['' => '--بلا--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--بلا--',
        'createcase' => 'إنشاء حالة',
        'bounce' => 'معالجة مرتدة',
        ],
        'dom_email_distribution' => ['' => '--بلا--',
        'direct' => 'تعيين مباشر',
        'roundRobin' => 'الترتيب الدوري',
        'leastBusy' => 'الأقل انشغالاً',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => 'الترتيب الدوري',
        'leastBusy' => 'الأقل انشغالاً',
        'none' => 'بلا',
        ],
        'dom_email_errors' => [1 => 'حدد مستخدمًا واحدًا فقط عند التعيين المباشر للعناصر.',
        2 => 'يجب عليك تعيين "العناصر التي تم التحقق منها فقط" عند "التعيين المباشر للعناصر".',
        ],
        'dom_email_bool' => ['bool_true' => 'نعم',
        'bool_false' => 'لا',
        ],
        'dom_int_bool' => [1 => 'نعم',
        0 => 'لا',
        ],
        'dom_switch_bool' => ['on' => 'نعم',
        'off' => 'لا',
        '' => 'لا',],

        'dom_email_link_type' => ['sugar' => 'عميل رسائل البريد الإلكتروني لـ Sugar',
        'mailto' => 'عميل رسائل البريد الإلكتروني الخارجية'],


        'dom_email_editor_option' => ['' => 'التنسيق الافتراضي لرسائل البريد الإلكتروني',
        'html' => 'البريد الإلكتروني بتنسيق HTML',
        'plain' => 'البريد الإلكتروني بنص عادي'],

        'schedulers_times_dom' => ['not run' => 'زمن التشغيل الماضي، لم يتم التنفيذ',
        'ready' => 'جاهز',
        'in progress' => 'يتقدم',
        'failed' => 'فشل',
        'completed' => 'كامل',
        'no curl' => 'ليس قيد التشغيل: لا يتوفر cURL',
        ],

        'dom_email_states' => [
        'Draft' => 'المسودة',
        'Archived' => 'المؤرشفة',
        ],

        'dom_email_direction' => [
        'Unknown' => 'غير معروف',
        'Outbound' => 'صادر',
        'Inbound' => 'وارد',
        'Internal' => 'داخلي',
        ],

        'scheduler_status_dom' => [
        'Active' => 'نشط',
        'Inactive' => 'غير نشط',
        ],

        'scheduler_period_dom' => [
        'min' => 'دقائق',
        'hour' => 'ساعات',
        ],
        'forecast_type_dom' => [
        'Direct' => 'مباشر',
        'Rollup' => 'القيمة المحتسبة',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => 'التسويق',
        'Knowledge Base' => 'قاعدة المعارف',
        'Sales' => 'المبيعات',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => 'وسائط التسويق',
        'Product Brochures' => 'منشورات المنتج',
        'FAQ' => 'الأسئلة المتداولة',
        ],

        'document_status_dom' => [
        'Active' => 'نشط',
        'Draft' => 'المسودة',
        'FAQ' => 'الأسئلة المتداولة',
        'Expired' => 'منتهي الصلاحية',
        'Under Review' => 'قيد المراجعة',
        'Pending' => 'معلق',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => 'دمج البريد',
        'eula' => 'EULA',
        'nda' => 'NDA',
        'license' => 'اتفاقية الترخيص',
        ],
        'dom_meeting_accept_options' => [
        'accept' => 'قبول',
        'decline' => 'رفض',
        'tentative' => 'مبدئي',
        ],
        'dom_meeting_accept_status' => [
        'accept' => 'مقبول',
        'decline' => 'مرفوض',
        'tentative' => 'مبدئي',
        'none' => 'بلا',
        ],
        'dataset_output_default_dom' => [
        'table' => 'الجدول',
        ],
        'report_maker_status_dom' => [
        'Single Module' => 'وحدة فردية',
        'Multi Module' => 'وحدة متعددة',
        ],
        'report_align_dom' => [
        'left' => 'لليسار',
        'center' => 'في المنتصف',
        'right' => 'لليمين',
        ],

        'width_type_dom' => [
        '%' => 'بنسبة (%)',
        'px' => 'البكسل (px)',
        ],
        'report_color_dom' => [
        '' => 'افتراضي',
        'black' => 'أسود',
        'green' => 'أخضر',
        'blue' => 'أزرق',
        'red' => 'أحمر',
        'white' => 'أبيض',
        'DarkGreen' => 'أخضر داكن',
        'LightGray' => 'رمادي فاتح',
        'DodgerBlue' => 'أزرق متموج',
        'LightBlue' => 'أزرق فاتح',
        ],
        'font_size_dom' => [
        '-5' => 'أصغر (-5)',
        '-4' => 'أصغر (-4)',
        '-3' => 'أصغر (-3)',
        '-2' => 'أصغر (-2)',
        '-1' => 'أصغر (-1)',
        'Default' => 'افتراضي',
        '1' => 'أكبر (+1)',
        '2' => 'أكبر (+2)',
        '3' => 'أكبر (+3)',
        '4' => 'أكبر (+4)',
        '5' => 'أكبر (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => 'الاستعلام العام',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => 'عرض',
//  'Group By' => 'Group By',
        'Calculation' => 'الحساب',
        ],
        'query_display_type_dom' => [
        'Default' => 'افتراضي',
        'Custom' => 'مخصص',
        'Hidden' => 'مخفي',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => 'يوم',
        'Week' => 'أسبوع',
        'Month' => 'شهر',
        'Quarter' => 'ربع سنة',
        'Year' => 'سنة',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => 'الآن',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => 'مبلغ',
        'AVG' => 'متوسط',
        'COUNT' => 'حساب',
        'STDDEV' => 'الانحراف القياسي',
        'VARIANCE' => 'التباين',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => 'حقل قياسي',
        'Time' => 'الفاصل الزمني',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => 'الصفوف (المحور س)',
        'Columns' => 'الأعمدة (المحور ص)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => 'جمع (الإجمالي)',
        'AVG' => 'المتوسط',
        'MAX' => 'الحد الأقصى',
        'MIN' => 'الحد الأدنى',
        'COUNT' => 'حساب',
        'STDDEV' => 'الانحراف القياسي',
        'VARIANCE' => 'التباين',
        ],
        'query_calc_type_dom' => [
        'Standard' => 'قياسي',
//  'Sub-Query' => 'Sub Query',
        'Math' => 'حسابات رياضية',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => 'الحقل',
        'Value' => 'القيمة',
        'Group' => 'مجموعة',
        ],


        'dataset_layout_type_dom' => [
        'Column' => 'العمود',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => 'معطَّل',
        'Enabled' => 'مُمكَّن',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => 'عادي',
        'Scalar' => 'الدالَّة',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => 'النص',
        'Accounting' => 'المحاسبة',
        'Date' => 'التاريخ',
        'Datetime' => 'التاريخ والوقت',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => 'سنة',
        'Quarter' => 'ربع سنة',
        'Month' => 'شهر',
        'Week' => 'أسبوع',
        'Day' => 'يوم',
        ],
        'dataset_style_dom' => [
        'normal' => 'عادي',
        'bold' => 'غامق',
        'italic' => 'مائل',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) إضافة',
        '-' => '(-) طرح',
        '*' => '(X) مضروبًا في',
        '/' => '(/) مقسومًا على',
        ],
        'wflow_type_dom' => [
        'Normal' => 'عند حفظ السجل',
        'Time' => 'بعد انقضاء الوقت',
        ],
        'mselect_type_dom' => [
        'Equals' => 'هو',
        'in' => 'هو واحد من',
        ],
        'mselect_multi_type_dom' => [
        'in' => 'هو واحد من',
        'not_in' => 'ليس واحدًا من',
        ],
        'cselect_type_dom' => [
        'Equals' => 'يساوي',
        'Does not Equal' => 'لا يساوي',
        ],
        'dselect_type_dom' => [
        'Equals' => 'يساوي',
        'Less Than' => 'أقل من',
        'More Than' => 'أكثر من',
        'Does not Equal' => 'لا يساوي',
        ],
        'bselect_type_dom' => [
        'bool_true' => 'نعم',
        'bool_false' => 'لا',
        ],
        'bopselect_type_dom' => [
        'Equals' => 'يساوي',
        ],
        'tselect_type_dom' => [
        '0' => '0 ساعة',
        '14440' => '4 ساعات',
        '28800' => '8 ساعات',
        '43200' => '12 ساعة',
        '86400' => 'يوم واحد',
        '172800' => 'يومان',
        '259200' => '3 أيام',
        '345600' => '4 أيام',
        '432000' => '5 أيام',
        '604800' => 'أسبوع واحد',
        '1209600' => 'أسبوعان',
        '1814400' => '3 أسابيع',
        '2592000' => '30 يومًا',
        '5184000' => '60 يومًا',
        '7776000' => '90 يومًا',
        '10368000' => '120 يومًا',
        '12960000' => '150 يومًا',
        '15552000' => '180 يومًا',
        ],
        'dtselect_type_dom' => [
        'More Than' => 'كان أكثر من',
        'Less Than' => 'أقل من',
        ],
        'wflow_alert_type_dom' => [
        'Email' => 'البريد الإلكتروني',
        'Invite' => 'دعوة',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => 'رسالة عادية',
        'Custom Template' => 'قالب مخصص',
        'System Default' => 'إعداد افتراضي للنظام',
        ],
        'wflow_user_type_dom' => [
        'current_user' => 'المستخدمون الحاليون',
        'rel_user' => 'المستخدمون ذوو الصلة',
        'rel_user_custom' => 'المستخدم المخصص ذو الصلة',
        'specific_team' => 'الفريق المحدد',
        'specific_role' => 'الدور المحدد',
        'specific_user' => 'المستخدم المحدد',
        ],
        'wflow_array_type_dom' => [
        'future' => 'قيمة جديدة',
        'past' => 'قيمة قديمة',
        ],
        'wflow_relate_type_dom' => [
        'Self' => 'المستخدم',
        'Manager' => "إدارة المستخدمين",
        ],
        'wflow_address_type_dom' => [
        'to' => 'إلى:',
        'cc' => 'نسخة:',
        'bcc' => 'نسخة مخفية:',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => 'إلى:',
        'cc' => 'نسخة:',
        'bcc' => 'نسخة مخفية:',
        'invite_only' => '(الدعوة فقط)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => 'إلى:',
        ],
        'wflow_action_type_dom' => [
        'update' => 'سجل محدث',
        'update_rel' => 'سجل محدث ذو صلة',
        'new' => 'سجل جديد',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => 'تاريخ التشغيل',
        'Existing Value' => 'القيمة الحالية',
        ],
        'wflow_set_type_dom' => [
        'Basic' => 'الخيارات الأساسية',
        'Advanced' => 'خيارات متقدمة',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => 'المستخدم معيَّن للسجل الذي تم تشغيله',
        'modified_user_id' => 'آخر مستخدم قام بتعديل السجل الذي تم تشغيله',
        'created_by' => 'المستخدم الذي قام بإنشاء السجل الذي تم تشغيله',
        'current_user' => 'المستخدم المسجل الدخول',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => 'الفريق الحالي للسجل الذي تم تشغيله',
        'team_set_id' => 'مجموعة السجلات النشطة حاليًا الخاصة بالفريق',
        'current_team' => 'فريق المستخدم المسجل الدخول',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => 'التنقل لأسفل وللخلف بواسطة',
        'advance' => 'التنقل للأسفل وللأمام بواسطة',
        ],
        'wflow_record_type_dom' => [
        'All' => 'السجلات القديمة والمحدثة',
        'New' => 'السجلات الجديدة فقط',
        'Update' => 'السجلات المحدثة فقط',
        ],
        'wflow_rel_type_dom' => [
        'all' => 'كل ما له صلة',
        //'first' => 'The first related',
        'filter' => 'عامل التصفية ذو الصلة',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => 'كل ما له صلة',
        'any' => 'ما ليس ذا صلة',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => 'التنبيهات ثم الإجراءات',
        'actions_alerts' => 'الإجراءات ثم التنبيهات'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => 'بلا',
        'Daily' => 'يوميًا',
        'Weekly' => 'أسبوعيًا',
        'Monthly' => 'شهريًا',
        'Yearly' => 'سنويًا',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => 'يوم (أيام)',
        'Weekly' => 'أسبوع (أسابيع)',
        'Monthly' => 'شهر (شهور)',
        'Yearly' => 'سنة (سنوات)',
        ],

        'repeat_end_types' => [
        'Until' => 'حتى',
        'Occurrences' => 'التكرارات',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => 'بلا',
        'Each' => 'كل',
        'On' => 'في',
        ],

        'repeat_ordinal_dom' => [
        'first' => 'الأول',
        'second' => 'الثاني',
        'third' => 'الثالث',
        'fourth' => 'الرابع',
        'fifth' => 'الخامس',
        'last' => 'الأخير',
        ],

        'repeat_unit_dom' => [
        'Sun' => 'الأحد',
        'Mon' => 'الإثنين',
        'Tue' => 'الثلاثاء',
        'Wed' => 'الأربعاء',
        'Thu' => 'الخميس',
        'Fri' => 'الجمعة',
        'Sat' => 'السبت',
        'Day' => 'يوم',
        'WD' => 'يوم عمل',
        'WE' => 'يوم العطلة الأسبوعية',
        ],

        'duration_dom' => [
        '' => 'بلا',
        '900' => '15 دقيقة',
        '1800' => '30 دقيقة',
        '2700' => '45 دقيقة',
        '3600' => 'ساعة واحدة',
        '5400' => '1.5 ساعة',
        '7200' => 'ساعتان',
        '10800' => '3 ساعات',
        '21600' => '6 ساعات',
        '86400' => 'يوم واحد',
        '172800' => 'يومان',
        '259200' => '3 أيام',
        '604800' => 'أسبوع واحد',
        ],
        'repeat_month_dom' => [
        '1' => 'يناير',
        '2' => 'فبراير',
        '3' => 'مارس',
        '4' => 'أبريل',
        '5' => 'مايو',
        '6' => 'يونيو',
        '7' => 'يوليو',
        '8' => 'أغسطس',
        '9' => 'سبتمبر',
        '10' => 'أكتوبر',
        '11' => 'نوفمبر',
        '12' => 'ديسمبر',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => 'افتراضي',
        'seed' => 'قائمه الاستقبال',
        'exempt_domain' => 'قائمة المنع - حسب المجال',
        'exempt_address' => 'قائمة المنع - حسب عنوان البريد الإلكتروني',
        'exempt' => 'قائمة المنع - حسب المعرّف',
        'test' => 'اختبار',
        ],
        'currency_status_dom' => [
        'Active' => 'نشط',
        'Inactive' => 'غير نشط',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => 'نشط',
        'inactive' => 'غير نشط',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => 'الرسالة المرسلة/التي تمت محاولة إرسالها',
        'send error' => 'الرسائل المرتدة، أخرى',
        'invalid email' => 'الرسائل المرتدة، بريد إلكتروني غير صحيح',
        'link' => 'ارتباط النقر',
        'viewed' => 'الرسالة المعروضة',
        'removed' => 'تم الرفض',
        'lead' => 'العملاء المتوقعون الذين تم إنشاؤهم',
        'contact' => 'جهات الاتصال التي تم إنشاؤها',
        'blocked' => 'الممنوعة حسب العنوان أو المجال',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => 'جهات الاتصال',
        'Users' => 'المستخدمون',
        'Prospects' => 'الأهداف',
        'Leads' => 'العملاء المتوقعون',
        'Accounts' => 'الحسابات',
        ],
        'merge_operators_dom' => [
        'like' => 'تحتوي على',
        'exact' => 'تمامًا',
        'start' => 'يبدأ بـ',
        ],

        'custom_fields_importable_dom' => [
        'true' => 'نعم',
        'false' => 'لا',
        'required' => 'مطلوب',
        ],

        'fts_field_config' => [
        '0' => 'معطَّل',
        '2' => 'قابل للبحث',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => 'معطَّل',
        1 => 'مُمكَّن',
        2 => 'في عامل التصفية',
        3 => 'عامل التصفية الافتراضي المحدد',
        4 => 'عامل التصفية فقط',
        ],

        'navigation_paradigms' => [
        'm' => 'الوحدات',
        'gm' => 'الوحدات المجمعة',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => 'لم يبدأ',
        'inprogress' => 'يتقدم',
        'signed' => 'موقَّع',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => 'شهريًا',
        'quarterly' => 'ربع سنوي',
        'halfyearly' => 'نصف سنوي',
        'yearly' => 'سنويًا',
        ],

        'contract_expiration_notice_dom' => [
        '1' => 'يوم واحد',
        '3' => '3 أيام',
        '5' => '5 أيام',
        '7' => 'أسبوع واحد',
        '14' => 'أسبوعان',
        '21' => '3 أسابيع',
        '31' => 'شهر واحد',
        ],
        'projects_priority_options' => [
        'high' => 'عالٍ',
        'medium' => 'متوسط',
        'low' => 'منخفض',
        ],

        'projects_status_options' => [
        'notstarted' => 'لم يبدأ',
        'inprogress' => 'يتقدم',
        'completed' => 'كامل',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => 'توسيع وسيلة الإيضاح',
        'collapselegend' => 'طي وسيلة الإيضاح',
        'clickfordrilldown' => 'النقر للانتقال التفصيلي',
        'drilldownoptions' => 'خيارات الانتقال التفصيلي',
        'detailview' => 'مزيد من التفاصيل...',
        'piechart' => 'المخطط الدائري',
        'groupchart' => 'مخطط المجموعة',
        'stackedchart' => 'المخطط المكدس',
        'barchart' => 'المخطط الشريطي',
        'horizontalbarchart' => 'المخطط الشريطي الأفقي',
        'linechart' => 'المخطط الخطي',
        'noData' => 'البيانات غير متوفرة',
        'print' => 'طباعة',
        'pieWedgeName' => 'الأقسام',
        ],
        'chart_types' => [
        'hBarF' => 'شريط أفقي (مكدس)',
        'hGBarF' => 'شريط أفقي (مجمع)',
        'vBarF' => 'شريط رأسي (مكدس)',
        'vGBarF' => 'شريط رأسي (مجمع)',
        'pieF' => 'دائري',
        'funnelF' => 'قُمعي',
        'lineF' => 'خطي',
        'donutF' => 'دونات',
        'treemapF' => 'هيكلي',
        ],
        'd3_value_placement' => [
        '0' => 'بلا',
        '1' => 'افتراضي',
        'start' => 'البدء',
        'middle' => 'الوسط',
        'end' => 'النهاية',
        'top' => 'أعلى',
        'total' => 'الإجمالي',
        ],
        'pipeline_chart_dom' => [
        'fun' => 'القمع',
        'hbar' => 'شريط أفقي',
        ],
        'release_status_dom' => [
        'Active' => 'نشط',
        'Inactive' => 'غير نشط',
        ],
        'email_settings_for_ssl' => [
        '0' => 'بلا',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'تطبيقات Google الأقل أمانًا',
        'exchange' => 'Exchange',
        'other' => 'أخرى',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => 'أخرى',
        ],
        'import_enclosure_options' => [
        '&#39;' => 'علامة اقتباس مفردة (&#39;)',
        '"' => 'علامة اقتباس مزدوجة (")',
        '' => 'بلا',
        'other' => 'غير ذلك:',
        ],
        'import_delimeter_options' => [
        ',' => '،',
        ';' => '؛',
        '\t' => '\t',
        '.' => '.',
        ':' => ':',
        '|' => '|',
        'other' => 'غير ذلك:',
        ],
        'link_target_dom' => [
        '_blank' => 'إطار جديد',
        '_self' => 'نفس الإطار',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => 'عدم التحديث التلقائي',
        '30' => 'كل 30 ثانية',
        '60' => 'كل دقيقة',
        '180' => 'كل 3 دقائق',
        '300' => 'كل 5 دقائق',
        '600' => 'كل 10 دقائق',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => 'بلا',
        '15' => 'كل 15 دقيقة',
        '30' => 'كل 30 دقيقة',
        '45' => 'كل 45 دقيقة',
        '60' => 'كل ساعة',
        '120' => 'كل ساعتين',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => 'مطلقًا',
        '30' => 'كل 30 ثانية',
        '60' => 'كل دقيقة',
        '180' => 'كل 3 دقائق',
        '300' => 'كل 5 دقائق',
        '600' => 'كل 10 دقائق',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => 'بلا',
        '1' => 'كل دقيقة',
        '5' => 'كل 5 دقائق',
        '10' => 'كل 10 دقائق',
        '15' => 'كل 15 دقيقة',
        '30' => 'كل 30 دقيقة',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => 'يساوي',
        'not_equal' => 'ليس',
        'greater_than' => 'بعد',
        'less_than' => 'قبل',
        'last_7_days' => 'آخر 7 أيام',
        'next_7_days' => 'الـ 7 أيام المقبلة',
        'last_30_days' => 'آخر 30 يومًا',
        'next_30_days' => 'الـ 30 يومًا المقبلة',
        'last_month' => 'الشهر الماضي',
        'this_month' => 'هذا الشهر',
        'next_month' => 'الشهر التالي',
        'last_year' => 'السنة الماضية',
        'this_year' => 'هذة السنة',
        'next_year' => 'السنة القادمة',
        'between' => 'بين',
        ],
        'date_range_operator_dom' => [
        'last_year' => 'السنة الماضية',
        'last_month' => 'الشهر الماضي',
        'last_30_days' => 'آخر 30 يومًا',
        'last_7_days' => 'آخر 7 أيام',
        'this_month' => 'هذا الشهر',
        'this_year' => 'هذة السنة',
        'next_7_days' => 'الـ 7 أيام المقبلة',
        'next_30_days' => 'الـ 30 يومًا المقبلة',
        'next_month' => 'الشهر التالي',
        'next_year' => 'السنة القادمة',
        ],
        'numeric_range_search_dom' => [
        '=' => 'يساوي',
        'not_equal' => 'لا يساوي',
        'greater_than' => 'أكبر من',
        'greater_than_equals' => 'أكبر من أو يساوي',
        'less_than' => 'أقل من',
        'less_than_equals' => 'أقل من أو يساوي',
        'between' => 'بين',
        ],

        'filter_checkbox_dom' => [
        0 => 'خطأ',
        1 => 'صواب',
        ],

        'opportunity_metrics_dom' => [
        'won' => 'ربح',
        'lost' => 'خسارة',
        'active' => 'نشط',
        ],

        'sweetspot_theme_options' => [
        'default' => 'افتراضي',
        'light' => 'مضيء',
        'dark' => 'مظلم',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => 'نقل',
        'donothing' => 'عدم القيام بشيء',
        ],
        'processes_auto_save_interval' => [
        0 => 'مطلقًا',
        30000 => 'كل 30 ثانية',
        60000 => 'كل دقيقة',
        120000 => 'كل دقيقتين',
        180000 => 'كل 3 دقائق',
        240000 => 'كل 4 دقائق',
        300000 => 'كل 5 دقائق',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => 'نعم',
        'No' => 'لا',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => 'في التوقع',
        'sales_stage' => 'مرحلة المبيعات',
        'probability' => 'الاحتمالية',
        ],
        'forecasts_options_dataset' => [
        'likely' => 'احتمال',
        'best' => 'أفضل',
        'worst' => 'أسوأ',
        ],
        'webLogicHookList' => [
        'after_save' => 'بعد الحفظ',
        'after_delete' => 'بعد الحذف',
        'after_relationship_add' => 'بعد إضافة علاقة',
        'after_relationship_delete' => 'بعد حذف علاقة',
        'after_login' => 'بعد تسجيل الدخول',
        'after_logout' => 'بعد تسجيل الخروج',
        'after_login_failed' => 'بعد فشل تسجيل الدخول',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => 'مُمكَّن',
        'INACTIVE' => 'معطَّل',
        ],
        'dashboard_view_name_list' => [
        'record' => 'السجل',
        'records' => 'القائمة',
        'activities' => 'سير النشاط',
        'multi-line' => 'قائمة متعددة الأسطر',
        'omnichannel' => 'قائمة متعددة الاتجاهات',
        'home' => 'Home',
        'focus' => 'درج التنظيم',
        ],
        'metric_context_list' => [
        'service_console' => 'وحدة تحكم الخدمة',
        'renewals_console' => 'وحدة تحكم التجديدات',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => 'كل ساعة',
        '21600' => 'كل 6 ساعات',
        '43200' => 'كل 12 ساعة',
        '86400' => 'يوميًا',
        '604800' => 'أسبوعيًا',
        '1209600' => 'كل أسبوعين',
        '2419200' => 'كل 4 أسابيع',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => 'سنة (سنوات)',
        'month' => 'شهر (أشهر)',
        'day' => 'يوم (أيام)',
        ],
        'shift_exception_type_dom' => [
        'time_off' => 'وقت التوقف',
        'event' => 'الحدث',
        'other' => 'أخرى',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => 'التاريخ (آخر {{module}})',
        'start_date:asc' => 'التاريخ (أول {{module}})',
        'total_revenue:desc' => 'السعر (أعلى إجمالي)',
        'total_revenue:asc' => 'السعر (أقل إجمالي)',
        ],
        'calendar_type_list' => [
        'main' => 'مركز التقويم',
        ],
        'calendar_views_options' => [
        'day' => 'اليوم',
        'week' => 'الأسبوع',
        'workWeek' => 'أسبوع العمل',
        'expandedMonth' => 'الشهر',
        'agenda' => 'جدول الأعمال',
        'timeline' => 'المخطط الزمني',
        'monthSchedule' => 'المجدول',
        ],
        'docusign_envelope_status_list' => [
        'created' => 'تم الإنشاء',
        'completed' => 'تم الإكمال',
        'declined' => 'تم الرفض',
        'delivered' => 'تم التسليم',
        'sent' => 'تم الإرسال',
        'signed' => 'تم التوقيع',
        'voided' => 'تم الإلغاء',
        ],
        'docusign_recipient_selection_list' => [
        'show' => 'عرض قائمة المستلمين المحتملين',
        'dont_show' => 'عدم عرض المستلمين المحتملين',
        ],
        'docusign_recipient_type_list' => [
        'signer' => 'الموقّع',
        'carbon_copy' => 'العارض (نسخة مماثلة)',
        'certified_delivery' => 'العارض (تسليم معتمد)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => 'الافتراضي',
        'color' => 'اللون',
        'image' => 'الصورة',
        ],
        'module_display_type_dom' => [
        'abbreviation' => 'الاختصار',
        'icon' => 'الأيقونة',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => 'سهم لأسفل',
        'sicon-chevron-left' => 'شارة رتبة لليسار',
        'sicon-check' => 'فحص',
        'sicon-clock' => 'ساعة',
        'sicon-dashboard-default' => 'لوحة المعلومات الافتراضية',
        'sicon-dashboard' => 'لوحة المعلومات',
        'sicon-edit' => 'تحرير',
        'sicon-caret-down' => 'علامة إقحام لأسفل',
        'sicon-folder' => 'مجلد',
        'sicon-info' => 'معلومات',
        'sicon-kebab' => 'كباب',
        'sicon-link' => 'ارتباط',
        'sicon-list' => 'قائمة',
        'sicon-logout' => 'تسجيل الخروج',
        'sicon-minus' => 'ناقص',
        'sicon-folder-open' => 'مجلد مفتوح',
        'sicon-plus-sm' => 'زائد صغير',
        'sicon-refresh' => 'تحديث',
        'sicon-plus' => 'زائد',
        'sicon-settings' => 'الإعدادات',
        'sicon-arrow-right-double' => 'سهم لليمين مزدوج',
        'sicon-reports' => 'التقارير',
        'sicon-user' => 'المستخدم',
        'sicon-upload' => 'تحميل',
        'sicon-user-group' => 'مجموعة المستخدم',
        'sicon-arrow-left-double' => 'سهم لليسار مزدوج',
        'sicon-chevron-up' => 'شارة رتبة لأعلى',
        'sicon-caret-up' => 'علامة إقحام لأعلى',
        'sicon-star-fill' => 'نجمة مملوءة',
        'sicon-download' => 'تنزيل',
        'sicon-close' => 'إغلاق',
        'sicon-tile-view' => 'عرض التجانب',
        'sicon-list-view' => 'عرض القائمة',
        'sicon-thumbs-down' => 'إبهام لأسفل',
        'sicon-warning-circle' => 'دائرة تحذير',
        'sicon-phone' => 'هاتف',
        'sicon-email' => 'بريد إلكتروني',
        'sicon-document' => 'مستند',
        'sicon-note' => 'ملاحظة',
        'sicon-preview' => 'معاينة',
        'sicon-copy' => 'نسخ',
        'sicon-launch' => 'إطلاق',
        'sicon-lock' => 'قفل',
        'sicon-arrow-top-right' => 'سهم يمين علوي',
        'sicon-full-screen' => 'ملء الشاشة',
        'sicon-full-screen-exit' => 'الخروج من ملء الشاشة',
        'sicon-expand-left' => 'توسيع يسار',
        'sicon-expand-right' => 'توسيع يمين',
        'sicon-focus-drawer' => 'جدول تنظيم',
        'sicon-ban' => 'منع',
        'sicon-thumbs-up' => 'إبهام أعلى',
        'sicon-search' => 'بحث',
        'sicon-calendar' => 'تقويم',
        'sicon-calendar-lg' => 'تقويم طويل',
        'sicon-mobile-lg' => 'هاتف جوال طويل',
        'sicon-star-fill-lg' => 'نجمة مملوءة طويلة',
        'sicon-star-outline-lg' => 'إطار نجمة طويل',
        'sicon-reset-lg' => 'إعادة تعيين طويل',
        'sicon-exchange-lg' => 'تبادل طويل',
        'sicon-help-lg' => 'تعليمات طويلة',
        'sicon-close-lg' => 'إغلاق طويل',
        'sicon-plus-lg' => 'زائد طويل',
        'sicon-shortcuts-lg' => 'اختصارات طويل',
        'sicon-search-lg' => 'بحث طويل',
        'sicon-email-lg' => 'بريد إلكتروني طويل',
        'sicon-note-lg' => 'ملاحظة طويل',
        'sicon-document-lg' => 'مستند طويل',
        'sicon-add-dashlet-lg' => 'إضافة لوحة معلومات طويل',
        'sicon-collapse-lg' => 'طي طويل',
        'sicon-hamburger-lg' => 'هامبرغر طويل',
        'sicon-pin-fill-lg' => 'دبوس مملوء طويل',
        'sicon-expand-lg' => 'توسيع طويل',
        'sicon-copy-lg' => 'نسخ طويل',
        'sicon-dashboard-lg' => 'لوحة المعلومات طويل',
        'sicon-star-outline' => 'إطار نجمة',
        'sicon-reset' => 'إعادة تعيين',
        'sicon-unlink' => 'إلغاء الربط',
        'sicon-phone-lg' => 'هاتف طويل',
        'sicon-attach' => 'إرفاق',
        'sicon-case-lg' => 'الحالة طويل',
        'sicon-arrow-right-lg' => 'سهم لليمين طويل',
        'sicon-check-circle-lg' => 'دائرة صح طويلة',
        'sicon-text-formatting' => 'تنسيق النص',
        'sicon-check-circle' => 'دائرة صح',
        'sicon-upload-lg' => 'تحميل طويل',
        'sicon-flag-lg' => 'راية طويلة',
        'sicon-studio-lg' => 'استوديو طويل',
        'sicon-contact-lg' => 'جهة اتصال طويلة',
        'sicon-edit-lg' => 'تحرير طويل',
        'sicon-arrow-left' => 'سهم لليسار',
        'sicon-reply-all' => 'رد على الكل',
        'sicon-message-lg' => 'رسالة طويلة',
        'sicon-info-lg' => 'معلومات طويلة',
        'sicon-error-lg' => 'خطأ طويل',
        'sicon-check-circle-line-lg' => 'خط دائرة صح طويلة',
        'sicon-warning-line-lg' => 'خط تحذير طويل',
        'sicon-arrow-up' => 'سهم لأعلى',
        'sicon-arrow-right' => 'سهم لليمين',
        'sicon-nodes' => 'العُقد',
        'sicon-hide' => 'إخفاء',
        'sicon-help' => 'تعليمات',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => 'رسالة',
        'sicon-sugar-predict-lg' => 'Sugar Predict طويل',
        'sicon-sugar-predict' => 'Sugar Predict',
        'sicon-opportunity-lg' => 'فرصة طويل',
        'sicon-lead-lg' => 'عميل متوقع طويل',
        'sicon-account-lg' => 'حساب طويل',
        'sicon-user-sm' => 'مستخدم صغير',
        'sicon-quote-lg' => 'عرض سعر صغير',
        'sicon-equal' => 'يساوي',
        'sicon-slicers-xl' => 'مقسمات طويلة جدًا',
        'sicon-escalation-lg' => 'عملية التصعيد طويلة',
        'sicon-add-circle-lg' => 'دائرة إضافة طويلة',
        'sicon-add-line-lg' => 'خط إضافة طويل',
        'sicon-add-target-lg' => 'هدف طويل',
        'sicon-help-circle-lg' => 'دائرة تعليمات طويلة',
        'sicon-divide-line-lg' => 'خط تقسيم طويل',
        'sicon-string' => 'سلسلة',
        'sicon-filter' => 'عامل تصفية',
        'sicon-number' => 'رقم',
        'sicon-format-lg' => 'تنسيق طويل',
        'sicon-insights-lg' => 'رؤى طويلة',
        'sicon-invalid-circle-lg' => 'دائرة غير صالحة طويلة',
        'sicon-layout-xl' => 'تخطيط طويل جدًا',
        'sicon-layout-lg' => 'تخطيط طويل',
        'sicon-multiply-line-lg' => 'خط ضرب طويل',
        'sicon-redo-lg' => 'إعادة طويلة',
        'sicon-refresh-lg' => 'تحديث طويل',
        'sicon-undo-lg' => 'تراجع طويل',
        'sicon-activity-feed-xl' => 'موجز نشاط طويل',
        'sicon-chevron-left-xl' => 'شارة رتبة لليسار طويلة جدًا',
        'sicon-close-xl' => 'إغلاق طويل جدًا',
        'sicon-kebab-lg' => 'كباب طويل',
        'sicon-insights-xl' => 'رؤى طويلة جدًا',
        'sicon-hide-lg' => 'إخفاء طويل',
        'sicon-kebab-xl' => 'كباب طويل جدًا',
        'sicon-comment-xl' => 'تعليق طويل جدًا',
        'sicon-share-lg' => 'مشاركة طويلة',
        'sicon-trash' => 'سلة محذوفات',
        'sicon-launch-lg' => 'إطلاق طويل',
        'sicon-thumbs-up-lg' => 'إبهام لأعلى طويل',
        'sicon-thumbs-down-lg' => 'إبهام لأسفل طويل',
        'sicon-warning-lg' => 'تحذير طويل',
        'sicon-wizard-circle-xl' => 'دائرة ساحر طويلة',
        'sicon-bell-cross-lg' => 'جرس متقاطع طويل',
        'sicon-bell-lg' => 'جرس طويل',
        'sicon-daily-lg' => 'يومي طويل',
        'sicon-cloud-download-lg' => 'تنزيل سحابة طويل',
        'sicon-unlock' => 'فتح',
        'sicon-news-lg' => 'أخبار طويل',
        'sicon-weekly-lg' => 'أسبوعي طويل',
        'sicon-knowledgebase-xl' => 'قاعدة معارف طويلة جدًا',
        'sicon-remove' => 'إزالة',
        'sicon-chevron-down' => 'شارة رتبة لأسفل',
        'sicon-slicers-lg' => 'مقسمات طويلة',
        'sicon-save-lg' => 'حفظ طويل',
        'sicon-info-circle-lg' => 'دائرة معلومات طويلة',
        'sicon-chevron-right' => 'شارة رتبة لليمين',
        'sicon-warning-circle-lg' => 'دائرة تحذير طويل',
        'sicon-right-paren-line-lg' => 'خط قوس يمين طويل',
        'sicon-comment-lg' => 'تعليق طويل',
        'sicon-target-lg' => 'هدف طويل',
        'sicon-subtract-line-lg' => 'خط طرح طويل',
        'sicon-settings-lg' => 'الإعدادات طويل',
        'sicon-left-paren-line-lg' => 'خط قوس يسار طويل',
        'sicon-preview-lg' => 'معاينة طويل',
        'sicon-thumbs-down-line-lg' => 'خط إبهام لأسفل طويل',
        'sicon-thumbs-up-line-lg' => 'خط إبهام لأعلى طويل',
        'sicon-send-lg' => 'إرسال طويل',
        'sicon-contact-xl' => 'جهة اتصال طويلة جدًا',
        'sicon-wizard-circle-line-xl' => 'خط دائرة ساحرة طويلة جدًا',
        'sicon-trash-lg' => 'سلة محذوفات طويل',
        'sicon-pin-lg' => 'دبوس طويل',
        'sicon-clock-lg' => 'ساعة طويل',
        'sicon-comment-line-xl' => 'خط تعليق طويل جدًا',
        'sicon-dropdown-editor' => 'محرر قائمة منسدلة',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => 'خطأ',
        'sicon-catalog' => 'كتالوج',
        'sicon-cloud' => 'سحابة',
        'sicon-config-api' => 'تكوين واجهة برمجة تطبيقات',
        'sicon-config-nav' => 'تكوين تنقل',
        'sicon-connectors' => 'موصلات',
        'sicon-contracts' => 'عقود',
        'sicon-currencies' => 'عملات',
        'sicon-diagnostics' => 'تشخيصات',
        'sicon-sugar-club' => 'Sugar Club',
        'sicon-email-campaign' => 'حملة البريد الإلكتروني',
        'sicon-email-inbound' => 'البريد الإلكتروني الوارد',
        'sicon-email-queue' => 'قائمة انتظار البريد الإلكتروني',
        'sicon-forecasts' => 'التوقعات',
        'sicon-display-modules' => 'عرض الوحدات',
        'sicon-email-contacts' => 'جهات اتصال البريد الإلكتروني',
        'sicon-import' => 'استيراد',
        'sicon-log-viewer' => 'عارض السجلات',
        'sicon-lab' => 'المختبر',
        'sicon-map-pin' => 'دبوس الخريطة',
        'sicon-manufacturers' => 'الشركات المصنعة',
        'sicon-update' => 'تحديث',
        'sicon-content-security' => 'أمان المحتوى',
        'sicon-module-builder' => 'منشئ الوحدات',
        'sicon-languages' => 'اللغات',
        'sicon-module-loader' => 'أداة تحميل الوحدات',
        'sicon-oauth-key' => 'مفتاح Oauth',
        'sicon-password-mgmt' => 'إدارة كلمة المرور',
        'sicon-opportunities' => 'الفرص',
        'sicon-upgrade' => 'ترقية',
        'sicon-portal' => 'المدخل',
        'sicon-product-types' => 'أنواع المنتج',
        'sicon-quotes' => 'عروض الأسعار',
        'sicon-relate-fields' => 'ربط الحقول',
        'sicon-repair' => 'إصلاح',
        'sicon-role-mgmt' => 'إدارة الدور',
        'sicon-scheduler' => 'المجدول',
        'sicon-shippers' => 'الشاحنون',
        'sicon-studio' => 'استوديو',
        'sicon-web-logic' => 'الأداة المنطقية على الويب',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => 'أسعار الضريبة',
        'sicon-team-mgmt' => 'إدارة الفريق',
        'sicon-team-perm' => 'إذن الفريق',
        'sicon-tracker' => 'المتعقب',
        'sicon-workflow' => 'سير العمل',
        'sicon-mask' => 'القناع',
        'sicon-mask-disabled' => 'تم تعطيل القناع',
        'sicon-email-archive' => 'أرشفة البريد الإلكتروني',
        'sicon-mobile' => 'الهاتف الجوال',
        'sicon-archive' => 'أرشفة',
        'sicon-automate-scroll' => 'عرض تمرير رأسي',
        'sicon-automate-stacked' => 'عرض تمرير أفقي',
        'sicon-pdf-manager' => 'مدير Pdf',
        'sicon-my-sites' => 'مواقعي',
        'sicon-cloud-insights' => 'رؤى السحابة',
        'sicon-sugar-logo-24' => 'شعار Sugar 24',
        'sicon-sugar-logo-16' => 'شعار Sugar 16',
        'sicon-task-lg' => 'مهمة طويلة',
        'sicon-web-lg' => 'ويب طويلة',
        'sicon-events-lg' => 'أحداث طويلة',
        'sicon-sugar-logo-12' => 'شعار Sugar 12',
        'sicon-tag' => 'علامة',
        'sicon-tag-lg' => 'علامة طويلة',
        'sicon-bell-lg-line' => 'خط جرس طويل',
        'sicon-matrix-xxl' => 'مصفوفة كبيرة جدًا جدًا',
        'sicon-advanced-filter' => 'عامل تصفية متقدم',
        'sicon-rows-and-columns-xxl' => 'صفوف وأعمدة كبيرة جدًا جدًا',
        'sicon-summation-details-xxl' => 'تفاصيل مجموع كبيرة جدًا جدًا',
        'sicon-summation-xxl' => 'مجموع كبير جدًا جدًا',
        'sicon-lock-lg' => 'قفل طويل',
        'sicon-csv-file-xxl' => 'ملف Csv كبير جدًا جدًا',
        'sicon-logo-linkedin' => 'شعار Linkedin',
        'sicon-briefcase' => 'حقيبة',
        'sicon-car-front' => 'واجهة سيارة',
        'sicon-airplane' => 'طائرة',
        'sicon-laptop' => 'كمبيوتر محمول',
        'sicon-logo-instagram' => 'شعار Instagram',
        'sicon-single-bed' => 'سرير مفرد',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => 'شعار Snapchat',
        'sicon-video-lg' => 'فيديو طويل',
        'sicon-reply' => 'رد',
        'sicon-subtract' => 'طرح',
        'sicon-arrow-up-circle-line' => 'خط دائرة سهم لأعلى',
        'sicon-asterisk' => 'نجمة',
        'sicon-dot-circle-o-lg' => 'دائرة نقطية طويلة',
        'sicon-forward' => 'إعادة توجيه',
        'sicon-video' => 'فيديو',
        'sicon-gavel' => 'مطرقه',
        'sicon-login' => 'تسجيل دخول',
        'sicon-pdf-file-xxl' => 'ملف Pdf كبير جدًا جدًا',
        'sicon-login-lg' => 'تسجيل دخول طويل',
        'sicon-cloud-download-xl' => 'تنزيل سحابة طويل جدًا',
        'sicon-campaigns-lg' => 'حملات طويل',
        'sicon-customer-journey-stages-lg' => 'مراحل رحلة العميل طويل',
        'sicon-role-mgmt-lg' => 'إدارة الدور طويل',
        'sicon-default-module-lg' => 'الوحدة الافتراضية طويل',
        'sicon-quoted-line-items-lg' => 'بنود مسعرة طويل',
        'sicon-projects-lg' => 'مشروعات طويل',
        'sicon-process-business-rules-lg' => 'القواعد التجارية للعملية طويل',
        'sicon-process-email-templates-lg' => 'قوالب البريد الإلكتروني للعملية طويل',
        'sicon-processes-lg' => 'العمليات طويل',
        'sicon-process-definitions-lg' => 'تعريفات العملية طويل',
        'sicon-target-lists-lg' => 'قوائم الهدف طويل',
        'sicon-purchased-line-items-lg' => 'البنود المشتراة طويل',
        'sicon-user-group-lg' => 'مجموعة المستخدم طويل',
        'sicon-revenue-line-items-lg' => 'بنود العائدات طويل',
        'sicon-business-centers-lg' => 'مراكز الأعمال طويل',
        'sicon-logo-fb-simple' => 'شعار Fb بسيط',
        'sicon-forecasts-lg' => 'التوقعات طويل',
        'sicon-contracts-lg' => 'العقود طويل',
        'sicon-purchase-lg' => 'المشتريات طويل',
        'sicon-sugar-live-lg' => 'Sugar Live طويل',
        'sicon-customer-journey-lg' => 'رحلة العميل طويل',
        'sicon-data-privacy-lg' => 'خصوصية البيانات طويل',
        'sicon-home-lg' => 'الصفحة الرئيسية طويل',
        'sicon-data-table' => 'جدول البيانات',
        'sicon-medical-clipboard-lg' => 'الحافظة الطبية طويل',
        'sicon-privacy-lg' => 'الخصوصية طويل',
        'sicon-marketplace' => 'السوق',
        'sicon-marketplace-lg' => 'السوق طويل',
        'sicon-blockquote-lg' => 'Blockquote طويل',
        'sicon-casino-lg' => 'كازينو طويل',
        'sicon-jacuzzi-lg' => 'جاكوزي طويل',
        'sicon-scissors-lg' => 'مقص طويل',
        'sicon-storage-lg' => 'تخزين طويل',
        'sicon-fan-lg' => 'مروحة طويل',
        'sicon-medicine-lg' => 'طب طويل',
        'sicon-plant-lg' => 'نبات طويل',
        'sicon-telescope-lg' => 'تلسكوب طويل',
        'sicon-smart-phone-lg' => 'هاتف ذكي طويل',
        'sicon-coffee-lg' => 'قهوة طويل',
        'sicon-martini-lg' => 'مارتيني طويل',
        'sicon-cocktail-lg' => 'كوكتيل طويل',
        'sicon-stadium-lg' => 'استاد طويل',
        'sicon-fire-lg' => 'نيران طويل',
        'sicon-window-lg' => 'نافذة طويل',
        'sicon-lotus-lg' => 'لوتس طويل',
        'sicon-windmill-lg' => 'طاحونة طويل',
        'sicon-spades-lg' => 'أوراق بستوني طويل',
        'sicon-hearts-lg' => 'قلوب طويل',
        'sicon-diamonds-lg' => 'ماسات طويل',
        'sicon-clubs-lg' => 'أندية طويل',
        'sicon-skull-lg' => 'جمجمة طويل',
        'sicon-send' => 'إرسال',
        'sicon-world-lg' => 'عالم طويل',
        'sicon-airplane-lg' => 'طائرة طويل',
        'sicon-planet-lg' => 'كوكب طويل',
        'sicon-trainer-lg' => 'مدرب طويل',
        'sicon-calculator-lg' => 'آلة حاسبة طويل',
        'sicon-tv-lg' => 'تلفاز طويل',
        'sicon-video-player-lg' => 'مشغل فيديو طويل',
        'sicon-media-player-lg' => 'مشغل وسائط طويل',
        'sicon-decentralize-lg' => 'لامركزية طويل',
        'sicon-statistics-lg' => 'إحصائيات طويل',
        'sicon-virus-lg' => 'فيروس طويل',
        'sicon-shield-lg' => 'واقي طويل',
        'sicon-plug-lg' => 'مقبس طويل',
        'sicon-shuttle-lg' => 'صاروخ طويل',
        'sicon-soundwave-lg' => 'موجة صوتية طويل',
        'sicon-graph-lg' => 'رسم بياني طويل',
        'sicon-playlist-lg' => 'قائمة تشغيل طويل',
        'sicon-voice-recognition-lg' => 'تعرف على الصوت طويل',
        'sicon-machine-learning-lg' => 'تعلم آلي طويل',
        'sicon-bed-lg' => 'سرير طويل',
        'sicon-blueprint-lg' => 'مخطط طويل',
        'sicon-content-delivery-lg' => 'تسليم المحتوى طويل',
        'sicon-questionnaire-lg' => 'استبيان طويل',
        'sicon-presentation-lg' => 'عرض تقديمي طويل',
        'sicon-organic-lg' => 'عضوي طويل',
        'sicon-transactions-lg' => 'معاملات طويل',
        'sicon-wand-lg' => 'صولجان طويل',
        'sicon-bin-lg' => 'سلة طويل',
        'sicon-sync-lg' => 'مزامنة طويل',
        'sicon-external-authentication-lg' => 'مصادقة خارجية طويل',
        'sicon-tracking-activity-lg' => 'تتبع النشاط طويل',
        'sicon-account' => 'الحساب',
        'sicon-meetings-lg' => 'الاجتماعات طويل',
        'sicon-stacked' => 'طريقة عرض انقسام أفقي',
        'sicon-sidebyside' => 'طريقة عرض انقسام عمودي',
        ],

        'module_colors_dom' => [
        'army' => 'جيش',
        'coral' => 'مرجاني',
        'green' => 'أخضر',
        'orange' => 'برتقالي',
        'ocean' => 'محيطي',
        'pacific' => 'باسيفيكي',
        'pink' => 'وردي',
        'purple' => 'أرجواني',
        'red' => 'أحمر',
        'teal' => 'أزرق مخضر',
        'yellow' => 'أصفر',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => 'جديد',
        'In Progress' => 'قيد التقدم',
        'Closed' => 'مغلق',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => 'عدم النشاط',
        'Lack of Progress' => 'غياب التقدم',
        'Customer-Imposed Deadline' => 'الموعد النهائي المفروض من العميل',
        'Account at Risk' => 'الحساب المعرض لخطر',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => 'مطلوب من العميل',
        'Internally Requested' => 'مطلوب داخليًا',
        ],
        'parent_type_display_escalations' => [
        'Cases' => 'الحالة',
        'Bugs' => 'الخطأ',
        'Accounts' => 'الحساب',
        'Opportunities' => 'الفرصة',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => 'إيجابي',
        'Negative' => 'سلبي',
        'Neutral' => 'محايد',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => 'غير مرجح',
        '02_less_likely' => 'أقل أرجحية',
        '03_neutral' => 'متعادل',
        '04_more_likely' => 'أكثر أرجحية',
        '05_very_likely' => 'مرجح للغاية',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => 'لا يطابق العملاء',
        '02_no_match' => '',
        '01_matches_customers' => 'يطابق العملاء',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => 'العميل المتوقع',
        'Accounts' => 'الحساب',
        'Contacts' => 'جهة الاتصال',
        'Cases' => 'الحالة',
        'Opportunities' => 'الفرصة',
        ],
        'dri_workflows_state_list' => [
        'not_started' => 'لم يبدأ',
        'in_progress' => 'قيد التقدم',
        'completed' => 'مكتمل',
        'cancelled' => 'ملغي',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => 'بلا',
        'create' => 'عند الإنشاء',
        'stage_start' => 'عند بدء المرحلة',
        'previous_activity_completed' => 'اكتمال النشاط السابق',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => 'المستخدم الحالي',
        'parent_assignee' => 'المستخدم المعين الأصل',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => 'أيام من الإنشاء',
        'days_from_stage_started' => 'أيام من بدء المرحلة',
        'days_from_previous_activity_completed' => 'أيام من اكتمال النشاط السابق',
        'days_from_parent_date_field' => 'أيام من حقل التاريخ الأصل',
        'days_from_specific_activity_completed' => 'أيام من اكتمال النشاط المحدد',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => 'عند الإنشاء',
        'stage_started' => 'عند بدء المرحلة',
        'previous_activity_completed' => 'عند اكتمال النشاط السابق',
        'parent_date_field' => 'في حقل التاريخ الأصل',
        'specific_activity_completed' => 'اكتمال النشاط المحدد',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => 'مطلق',
        'Percentage' => 'النسبة المئوية',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => 'مهمة العميل',
        'milestone' => 'الحدث الرئيسي',
        'internal_task' => 'مهمة داخلية',
        'agency_task' => 'مهمة الوكالة',
        'automatic_task' => 'مهمة تلقائية',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => 'المهمة',
        'Calls' => 'المكالمة',
        'Meetings' => 'الاجتماع',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => 'بلا',
        'create' => 'عند الإنشاء',
        'stage_start' => 'عند بدء المرحلة',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => 'توريث',
        'current_user' => 'المستخدم الحالي',
        'parent_assignee' => 'المستخدم المعين للأصل',
        'user' => 'المستخدم',
        'team' => 'الفريق',
        'user_team' => 'المستخدم والفريق',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => 'توريث',
        'none' => 'بلا',
        'create' => 'عند الإنشاء',
        'stage_start' => 'عند بدء المرحلة',
        'previous_activity_completed' => 'اكتمال النشاط السابق',
        'specific_activity_completed' => 'اكتمال النشاط المحدد',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => 'لم يبدأ',
        'in_progress' => 'قيد التقدم',
        'not_completed' => 'غير مكتمل',
        'completed' => 'مكتمل',
        'cancelled' => 'ملغي',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => 'تحرير المرحلة',
        'stage_add_task_button' => 'إنشاء مهمة',
        'stage_add_meeting_button' => 'جدولة اجتماع',
        'stage_add_call_button' => 'جدولة مكالمة',
        'stage_delete_button' => 'حذف المرحلة',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => 'إضافة مهمة',
        'activity_add_sub_meeting_button' => 'جدولة اجتماع',
        'activity_add_sub_call_button' => 'جدولة مكالمة',
        'activity_not_applicable_button' => 'لا ينطبق',
        'activity_delete_button' => 'حذف',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => 'تعيين غير قابل للتطبيق',
        'remove_open_activities' => 'إزالة الأنشطة المفتوحة',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => 'افتراضي',
        'custom' => 'مخصص',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'حصول',
        'POST' => 'نشر',
        'PUT' => 'وضع',
        'PATCH' => 'تصحيح',
        'DELETE' => 'حذف',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => 'تخطي الطلب',
        'json' => 'JSON',
        'http_query' => 'استعلام HTTP',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => 'لا استجابة',
        'json' => 'JSON',
        'http_query' => 'استعلام HTTP',
        'text' => 'نص عادي',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => 'قبل الإنشاء',
        'after_create' => 'بعد الإنشاء',
        'before_in_progress' => 'قبل قيد التقدم',
        'after_in_progress' => 'بعد قيد التقدم',
        'before_completed' => 'قبل الاكتمال',
        'after_completed' => 'بعد الاكتمال',
        'before_not_applicable' => 'قبل لا ينطبق',
        'after_not_applicable' => 'بعد لا ينطبق',
        'before_delete' => 'قبل الحذف',
        'after_delete' => 'بعد الحذف',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => 'إرسال معلومات الدليل الذكي',
        'custom_body' => 'إرسال نص منشور مخصص',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => 'قيد التقدم',
        'completed' => 'مكتمل',
        'not_applicable' => 'لا ينطبق',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => 'عرض السجل',
        'create_record' => 'إنشاء سجل',
        'update_record' => 'تحديث السجل',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => 'إنشاء سجل تلقائيًا',
        'manual_create' => 'إنشاء سجل يدويًا',
        'automatic_update' => 'تحديث السجل تلقائيًا',
        'manual_update' => 'تحديث السجل يدويًا',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => 'قالب الدليل الذكي',
        'DRI_SubWorkflow_Templates' => 'قالب المرحلة',
        'DRI_Workflow_Task_Templates' => 'قالب النشاط',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => 'نعم',
        'no' => 'لا',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => 'مُعلق',
        'Not Held' => 'غير معلقة',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => 'مُعلق',
        'Not Held' => 'غير معلقة',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => 'مكتمل',
        'Not Applicable' => 'غير منطبق',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => 'قالب الدليل الذكي',
        'DRI_SubWorkflow_Templates' => 'قالب المرحلة',
        'DRI_Workflow_Task_Templates' => 'قالب النشاط',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => 'المهمة',
        'Meetings' => 'الاجتماع',
        'Calls' => 'المكالمة',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => 'المهمة الحالية',
        'Calls' => 'المكالمة الحالية',
        'Meetings' => 'الاجتماع الحالي',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => 'المستخدمون المحددون',
        'specific_contacts' => 'جهات الاتصال المحددة',
        'related_parent_users' => 'المستخدمون الأصل ذوو الصلة',
        'related_parent_contacts' => 'جهات الاتصال الأصل ذات الصلة',
        'add_all_contacts_from_parent' => 'إضافة جميع جهات الاتصال من الأصل',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => 'المستخدمون',
        'specific_contacts' => 'جهات الاتصال',
        'related_parent_users' => 'المستخدمون',
        'related_parent_contacts' => 'جهات الاتصال',
        'add_all_contacts_from_parent' => 'جهات الاتصال',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => 'دقيقة (دقائق)',
        'hours' => 'ساعة (ساعات)',
        'days' => 'يوم (أيام)',
        'months' => 'شهر (أشهر)',
        ],
        'cj_relative_date_type_list' => [
        'days' => 'يوم (أيام)',
        'months' => 'شهر (أشهر)',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => 'تاريخ ثابت',
        'relative' => 'تاريخ نسبي',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => 'المستخدمون',
        'teams' => 'الفرق',
        'roles' => 'الأدوار',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Smart Guide إلى إجراء Sugar',
        'sugar_action_to_smart_guide' => 'إجراء Sugar إلى Smart Guide',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'مرحلة Smart Guide',
        'Smart Guide Activities' => 'أنشطة Smart Guide',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => 'مكتمل',
        'cancelled' => 'ملغي',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => 'قيد التقدم',
        'completed' => 'مكتمل',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => 'قيد التقدم',
        'completed' => 'مكتمل',
        'not_applicable' => 'غير منطبق',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => 'وضع علامة على جميع الأنشطة كمكتملة',
        'mark_all_not_applicable' => 'وضع علامة على جميع الأنشطة غير المكتملة كغير منطبقة',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => 'الولايات المتحدة (أوريغون) [الولايات المتحدة الغربية -2]',
        'ca-central-1' => 'كندا (الوسطى) [ca-central-1]',
        'ap-southeast-1' => 'آسيا والمحيط الهادئ (سنغافورة) [ap-جنوب شرق-1]',
        'ap-southeast-2' => 'آسيا والمحيط الهادئ (سيدني) [ap-جنوب شرق-2]',
        'eu-central-1' => 'أوروبا (فرانكفورت) [eu-central-1]',
        'eu-west-2' => 'أوروبا (لندن) [eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => 'عنوان السجل', // Studio editing of record views
    'LBL_RECORD_BODY' => 'بطاقة عمل', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => 'عرض المزيد', // Studio editing of record views
    'LBL_FAVORITE' => 'المفضلة', // Record view header panel element
    'LBL_FOLLOW' => 'متابعة', // Record view header panel element
    'LBL_FOLLOW_LINK' => 'ارتباط متابعة',
    'LBL_TOGGLE_VISIBILITY' => 'تبديل الرؤية', // Record view header panel element
    'LBL_ACTIVITIES' => 'سير النشاط الكلي',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM، وSugar، ومكعب 3-D هي علامات تجارية مسجلة خاصة بشركة SugarCRM Inc. ' .
        'جميع الشركات وأسماء المنتجات الأخرى المستخدمة أو تلك التي تظهر في هذا المنتج هي علامات تجارية خاصة ' .
        'تُعد SugarCRM ® وSugar Enterprise™ وSugar™ علامات تجارية مملوكة لشركة SugarCRM Inc.',
    'LBL_TRADEMARK2' => 'SugarCRM ® و Sugar Enterprise™ و Sugar™ هي علامات تجارية لشركة SugarCRM Inc.',
    'LBL_SEND_INVITE' => 'إرسال دعوة',
    'LBL_INVITEES' => 'الضيوف',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => 'لن يتلقى الضيف دعوتك',
    'LBL_SELECT_ACTION_LABEL' => 'تحديد إجراء',
    'LBL_TOGGLE_DRAWER' => 'تبديل الدرج',
    'LBL_TOUR_NEXT' => 'التالي',
    'LBL_TOUR_SKIP' => 'تخطي',
    'LBL_TOUR_BACK' => 'للخلف',
    'LBL_TOUR_CLOSE' => 'إغلاق',
    'LBL_TOUR_BTN_DONE' => 'تم',
    'LBL_TOUR_TAKE_TOUR' => 'بدء الجولة',
    'LBL_TOUR_FULL_TOUR' => 'جولة كاملة',
    'LBL_TOUR_MODULE' => 'جولة في هذه الصفحة',
    'LBL_TOUR_END_TOUR' => 'إنهاء الجولة',
    'LBL_TOUR_OVERVIEW' => 'نظرة عامة على الجولة',
    'LBL_TOUR_REVISIT' => 'انقر هنا لعرض الجولة في أي وقت.',
    'LBL_MY_AREA_LINKS' => 'ارتباطات منطقتي:' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => 'الحصول على الهواء' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => 'مرحبًا' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => 'بحث متقدم' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => 'مزيد من التفاصيل' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => 'تعديل المضمن' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => 'عرض' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => 'بحث' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => 'بحث...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => 'إزالة' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => 'إضافة' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => 'العمود' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => 'عمودان' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 أعمدة' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => 'بحث متقدم' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => 'إضافة' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => 'إخفاء/إظهار' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => 'حذف' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => 'إضافة' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => 'مسح' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => 'إلغاء الربط' /*for 508 compliance fix*/,
    'LBL_ADD' => 'إضافة' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => 'شعار الشركة' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => 'التقويم' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => 'أدت قيمة قائمة منسدلة حددتها إلى تغيير تخطيط عرض السجلات لديك. ' .
        'تم مسح قيم الحقول المخفية في هذا التخطيط الجديد. ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => 'فتح',
    'LBL_SIDEBAR_NAV_CLOSE' => 'إغلاق',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => 'قائمة {{subject}}',
    'LBL_GOTO_SUGARCRM_COM' => 'انتقل إلى SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => 'التنقل داخل الوحدة الرئيسية',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => 'تبديل اللوحة الفرعية',

    'LBL_ADVANCED' => 'خيارات متقدمة',
    'LBL_BASIC' => 'الأساسي',
    'LBL_MODULE_FILTER' => 'التصفية حسب...',
    'LBL_CONNECTORS_POPUPS' => 'الرسائل المنبثقة للموصلات',
    'LBL_CLOSEINLINE' => 'إغلاق',
    'LBL_EDITINLINE' => 'تحرير',
    'LBL_VIEWINLINE' => 'عرض',
    'LBL_INFOINLINE' => 'معلومات',
    'LBL_POWERED_BY_SUGARCRM' => 'بدعم SugarCRM',
    'LBL_PRINT' => 'طباعة',
    'LBL_HELP' => 'تعليمات',
    'LBL_TOUR' => 'الجولة',
    'LBL_TOUR_LINK' => 'جولة في هذه الصفحة',
    'LBL_MOBILE' => 'المحمول',
    'LBL_ID_FF_SELECT' => 'تحديد',
    'DEFAULT' => 'الأساسي',
    'LBL_SORT' => 'فرز',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => 'إضافة خادم...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'تمكين SMTP عبر SSL أو TLS؟',
    'LBL_NO_ACTION' => 'لا يوجد إجراء بهذا الاسم.',
    'LBL_NO_DATA' => 'لا توجد بيانات',
    'LBL_NOT_APPLICABLE' => 'لا ينطبق',
    'LBL_ROUTING_ADD_RULE' => 'إضافة قاعدة',
    'LBL_ROUTING_ALL' => 'على الأقل',
    'LBL_ROUTING_ANY' => 'أي',
    'LBL_ROUTING_BREAK' => ' -',
    'LBL_ROUTING_BUTTON_CANCEL' => 'إلغاء',
    'LBL_ROUTING_BUTTON_SAVE' => 'حفظ القاعدة',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => 'نسخ البريد',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => 'حذف كائن Sugar',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => 'حذف الملف',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => 'حذف البريد الإلكتروني',
    'LBL_ROUTING_ACTIONS_FORWARD' => 'إعادة توجيه البريد الإلكتروني',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => 'وضع علامة على البريد الإلكتروني',
    'LBL_ROUTING_ACTIONS_MARK_READ' => 'تمييز كمقروء',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => 'تمييز كغير مقروء',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => 'نقل البريد الإلكتروني',
    'LBL_ROUTING_ACTIONS_PEFORM' => 'تنفيذ الإجراءات التالية',
    'LBL_ROUTING_ACTIONS_REPLY' => 'الرد على البريد الإلكتروني',

    'LBL_ROUTING_CHECK_RULE' => "تم اكتشاف حدوث خطأ:",
    'LBL_ROUTING_CHECK_RULE_DESC' => 'يرجى التحقق من جميع الحقول المميزة.',
    'LBL_ROUTING_CONFIRM_DELETE' => "هل تريد بالتأكيد حذف هذه القاعدة؟<br />لا يمكن التراجع عن ذلك.",

    'LBL_ROUTING_FLAGGED' => 'وضع علامة على مجموعة',
    'LBL_ROUTING_FORM_DESC' => 'القواعد المحفوظة نشطة على الفور.',
    'LBL_ROUTING_FW' => 'إعادة توجيه:',
    'LBL_ROUTING_LIST_TITLE' => 'القواعد',
    'LBL_ROUTING_MATCH' => 'إذا',
    'LBL_ROUTING_MATCH_2' => 'أي من الحالات التالية قد تمت تلبيتها:',
    'LBL_NOTIFICATIONS' => 'الإشعارات',
    'LBL_ROUTING_MATCH_CC_ADDR' => 'نسخة',
    'LBL_ROUTING_MATCH_DESCRIPTION' => 'محتوى النص',
    'LBL_ROUTING_MATCH_FROM_ADDR' => 'من',
    'LBL_ROUTING_MATCH_NAME' => 'الموضوع',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => 'أولوية عالية',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => 'أولوية عادية',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => 'أولوية منخفضة',
    'LBL_ROUTING_MATCH_TO_ADDR' => 'إلى',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => 'تحتوي على',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => 'لا تحتوي على',

    'LBL_ROUTING_NAME' => 'اسم القاعدة',
    'LBL_ROUTING_NEW_NAME' => 'قاعدة جديدة',
    'LBL_ROUTING_ONE_MOMENT' => 'الرجاء الانتظار...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => 'الرسالة الأصلية تعقب ذلك.',
    'LBL_ROUTING_RE' => 'الرد:',
    'LBL_ROUTING_SAVING_RULE' => 'حفظ القاعدة',
    'LBL_ROUTING_SUB_DESC' => 'القواعد المتحقق منها نشطة. انقر فوق الاسم المطلوب تعديله.',
    'LBL_ROUTING_TO' => 'إلى',
    'LBL_ROUTING_TO_ADDRESS' => 'عنوان إلى',
    'LBL_ROUTING_WITH_TEMPLATE' => 'مع القالب',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => 'يحتوي هذا السجل حاليًا على قيم في حقول "هاتف المكتب" و"العنوان". للكتابة فوق هذه القيم مصحوبة بما يلي "هاتف المكتب" و"العنوان" الخاص بـ "الحساب" الذي حددته، انقر فوق "موافق". للاحتفاظ بالقيم الحالية، انقر فوق "إلغاء".',
    'LBL_DROP_HERE' => '[إسقاط هنا]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => 'تحرير',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => 'ملء مسبق Gmail&#153; الافتراضيات',
    'LBL_EMAIL_ACCOUNTS_NAME' => 'الاسم',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => 'خصائص خادم البريد الصادر',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => 'عامل نقل البريد',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => 'هل تريد استخدام مصادقة SMTP؟',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'كلمة مرور SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'منفذ SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'خادم SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => 'استخدم SSL عند التوصيل',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'اسم مستخدم SMTP',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => 'الافتراضي',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => 'تحذير: كلمة المرور أو اسم المستخدم لحساب البريد الصادر مفقود.',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'اسم مستخدم SMTP مطلوب',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'كلمة مرور SMTP مطلوبة',
    'LBL_EMAIL_ACCOUNTS_TITLE' => 'مدير حساب البريد',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'بروتوكول خادم البريد من النوع POP3 لن يتم دعمه في الإصدار التالي. سيتم فقط دعم IMAP.',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => 'قم بإعداد حسابات البريد لعرض رسائل البريد الواردة من حسابات البريد الإلكتروني الخاصة بك.',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => 'قم بتوفير معلومات خادم بريد SMTP لكي تستخدمها للبريد الصادر في حسابات البريد.',
    'LBL_EMAIL_ADD' => 'إضافة بريد إلكتروني',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => 'تم',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => 'مسح',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => 'إلى:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => 'نسخة:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => 'نسخة مخفية:',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => 'إلى/نسخة/نسخة مخفية',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => 'قائمة جديدة',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => 'عنوان البريد الإلكتروني',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => 'يتم دعم تعديل "جهة الاتصال" فقط في هذا الوقت.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => 'عامل التصفية',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => 'الاسم الأول/اسم الحساب',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => 'الاسم الأخير',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => 'جهات الاتصال الخاصة بي',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => 'قوائم البريد الخاصة بي',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => 'الاسم',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => 'لم يتم العثور على عناوين',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => 'الحفظ والإضافة إلى دفتر العناوين',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => 'بحث',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => 'تحديد مستلمي البريد الإلكتروني',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => 'دفتر العناوين',
    'LBL_EMAIL_REPORTS_TITLE' => 'التقارير',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => 'تحذير! الحساب الخارجي الذي تحاول حذفه مقترن بحساب داخلي حالي.  هل تريد بالتأكيد المتابعة؟',
    'LBL_EMAIL_ADDRESSES' => 'البريد الإلكتروني',
    'LBL_EMAIL_ADDRESS_PRIMARY' => 'عنوان البريد الإلكتروني',
    'LBL_EMAIL_ADDRESSES_TITLE' => 'عناوين البريد الإلكتروني',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => 'استيراد إلى Sugar',
    'LBL_EMAIL_ASSIGNMENT' => 'المهمة',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => 'إرفاق',
    'LBL_EMAIL_ATTACHMENT' => 'إرفاق',
    'LBL_EMAIL_ATTACHMENTS' => 'من نظام محلي',
    'LBL_EMAIL_ATTACHMENTS2' => 'من مستندات Sugar',
    'LBL_EMAIL_ATTACHMENTS3' => 'مرفقات القالب',
    'LBL_EMAIL_ATTACHMENTS_FILE' => 'الملف',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => 'المستند',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => 'مدمج',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => 'فشل تحميل الإرفاق',
    'LBL_REMOVING_ATTACHMENT' => 'تتم الآن إزالة المرفق...',
    'LBL_EMAIL_BCC' => 'نسخة مخفية',
    'LBL_EMAIL_CANCEL' => 'إلغاء',
    'LBL_EMAIL_CC' => 'نسخة',
    'LBL_EMAIL_CHARSET' => 'مجموعة الحروف',
    'LBL_EMAIL_CHECK' => 'فحص البريد',
    'LBL_EMAIL_CHECKING_NEW' => 'التحقق من ورود بريد إلكتروني جديد',
    'LBL_EMAIL_CHECKING_DESC' => 'الرجاء الانتظار... <br><br>إذا كانت هذه هي المرة الأولى التي تقوم فيها بالتحقق من حساب البريد الإلكتروني، فقد يستغرق الأمر بعض الوقت.',
    'LBL_EMAIL_CLOSE' => 'إغلاق',
    'LBL_EMAIL_COFFEE_BREAK' => 'تحقق من ورود بريد إلكتروني جديد. <br><br>حسابات البريد الإلكتروني الكبيرة قد تستغرق قدرًا كبيرًا من الوقت.',
    'LBL_EMAIL_COMMON' => 'عام',

    'LBL_EMAIL_COMPOSE' => 'البريد الإلكتروني',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => 'يرجى إدخال مستلم (مستلمين) لهذا البريد الإلكتروني.',
    'LBL_EMAIL_COMPOSE_LINK_TO' => 'شريك مع',
    'LBL_EMAIL_COMPOSE_NO_BODY' => 'نص هذا البريد الإلكتروني فارغ.  الإرسال على أي حال؟',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => 'هذا البريد الإلكتروني لا يتضمن عنوانًا.  الإرسال على أي حال؟',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '(لا يوجد عنوان)',
    'LBL_EMAIL_COMPOSE_READ' => 'قراءة وإنشاء البريد الإلكتروني',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => 'الإرسال من حساب البريد',
    'LBL_EMAIL_COMPOSE_OPTIONS' => 'الخيارات',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => 'يرجى إدخال عنوان بريد إلكتروني صالح للحقول "إلى"، و"نسخة"، و"نسخة مخفية"',

    'LBL_EMAIL_CONFIRM_CLOSE' => 'تجاهل هذا البريد الإلكتروني؟',
    'LBL_EMAIL_CONFIRM_DELETE' => 'إزالة هذه الإدخالات من دفتر العناوين لديك؟',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => 'هل تريد بالتأكيد حذف هذا التوقيع؟',

    'LBL_EMAIL_CREATE_NEW' => '--الإنشاء عند الحفظ--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => 'متعدد',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => 'فارغ',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => 'تاريخ الإرسال بواسطة المرسل',
    'LBL_EMAIL_DATE_RECEIVED' => 'تاريخ الاستلام',
    'LBL_EMAIL_ASSIGNED_TO_USER' => 'معيَّن للمستخدم',
    'LBL_EMAIL_DATE_TODAY' => 'اليوم',
    'LBL_EMAIL_DATE_YESTERDAY' => 'أمس',
    'LBL_EMAIL_DD_TEXT' => 'رسالة (رسائل) البريد الإلكتروني المحددة.',
    'LBL_EMAIL_DEFAULTS' => 'الافتراضيات',
    'LBL_EMAIL_DELETE' => 'حذف',
    'LBL_EMAIL_DELETE_CONFIRM' => 'حذف الرسائل المحددة؟',
    'LBL_EMAIL_DELETE_SUCCESS' => 'تم حذف البريد الإلكتروني بنجاح.',
    'LBL_EMAIL_DELETING_MESSAGE' => 'حذف الرسالة',
    'LBL_EMAIL_DETAILS' => 'التفاصيل',
    'LBL_EMAIL_DISPLAY_MSG' => 'عرض رسالة (رسائل) البريد الإلكتروني {0} - {1} لـ {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => 'عرض عنوان رسالة (رسائل) البريد الإلكتروني {0} - {1} لـ {2}',

    'LBL_EMAIL_EDIT_CONTACT' => 'تعديل جهة الاتصال',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => 'سيتم استخدام العنوان "الرئيسي" فقط عند العمل مع "جهات الاتصال".',
    'LBL_EMAIL_EDIT_MAILING_LIST' => 'تعديل قائمة المراسلة',

    'LBL_EMAIL_EMPTYING_TRASH' => 'تفريغ سلة المهملات',
    'LBL_EMAIL_DELETING_OUTBOUND' => 'حذف الخادم الخارجي',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => 'مسح ملفات التخزين المؤقت',
    'LBL_EMAIL_EMPTY_MSG' => 'لا توجد رسائل بريد إلكتروني لعرضها.',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => 'لا توجد عناوين رسائل بريد إلكتروني لعرضها.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => 'يجب أن يكون اسم المجلد فريدًا وغير فارغ. يُرجى المحاولة مرة أخرى.',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => 'لا يمكن حذف مجلد. إما أن المجلد أو أي من المجلدات التابعة له تحتوي على رسائل بريد إلكتروني وإما توجد علبة بريد مقترنة به.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => 'لا يمكن تحديد المجلد المستهدف من السياق.  حاول مرة أخرى.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => 'يرجى التحقق من الإعدادات لديك.',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => 'يرجى التأكد من إدخال اسم أخير.',
    'LBL_EMAIL_ERROR_DESC' => 'الأخطاء التي تم اكتشافها: ',
    'LBL_EMAIL_DELETE_ERROR_DESC' => 'لا يوجد لديك حق الوصول إلى هذه المنطقة. اتصل بمسؤول الموقع لديك للحصول على حق الوصول.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'أسماء مجلدات Sugar يجب أن تكون فريدة.',
    'LBL_EMAIL_ERROR_EMPTY' => 'يرجى إدخال بعض معايير البحث.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => 'حدث خطأ',
    'LBL_EMAIL_ERROR_LIST_NAME' => 'هناك قائمة رسائل بريد إلكتروني بهذا الاسم موجودة بالفعل',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => 'الرسالة التي تمت إزالتها من الخادم',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => 'إما أنه تمت إزالة الرسالة من الخادم وإما تم نقلها إلى مجلد آخر',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => 'فشل الاتصال بخادم البريد. يرجى الاتصال بالمسؤول لديك',
    'LBL_EMAIL_ERROR_MOVE' => 'نقل "البريد الإلكتروني" بين الخوادم و/أو حسابات البريد الإلكتروني لا يمكن دعمه في هذا الوقت.',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => 'خطأ أثناء النقل',
    'LBL_EMAIL_ERROR_NAME' => 'الاسم مطلوب.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => 'عنوان "من" مطلوب.  يرجى إدخال عنوان بريد إلكتروني صالح.',
    'LBL_EMAIL_ERROR_NO_FILE' => 'يرجى توفير ملف.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'إعادة تسمية مجلد IMAP غير مدعومة في هذا الوقت.',
    'LBL_EMAIL_ERROR_SERVER' => 'يلزم إدخال عنوان خادم البريد.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => 'حساب البريد ربما لم يتم حفظه.',
    'LBL_EMAIL_ERROR_TIMEOUT' => 'حدث خطأ أثناء الاتصال بخادم البريد.',
    'LBL_EMAIL_ERROR_USER' => 'اسم تسجل الدخول مطلوب.',
    'LBL_EMAIL_ERROR_PASSWORD' => 'كلمة المرور مطلوبة.',
    'LBL_EMAIL_ERROR_PORT' => 'منفذ خادم البريد مطلوب.',
    'LBL_EMAIL_ERROR_PROTOCOL' => 'بروتوكول الخادم مطلوب.',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => 'مجلد المُراقب مطلوب.',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => 'مجلد المهملات مطلوب.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => 'هذه المعلومات غير متاحة.',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => 'لا يوجد خادم بريد صادر محدد.',
    'LBL_EMAIL_FOLDERS' => 'المجلدات',
    'LBL_EMAIL_FOLDERS_ACTIONS' => 'انتقل إلى',
    'LBL_EMAIL_FOLDERS_ADD' => 'إضافة',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => 'إضافة مجلد جديد',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => 'إعادة تسمية مجلد',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => 'حفظ',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => 'إضافة هذا المجلد إلى',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => 'غير قادر على تغيير هذا المجلد',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => 'هل تريد بالتأكيد حذف هذا المجلد؟ غير قادر على عكس هذه العملية. عمليات حذف المجلد ستتوالى على جميع المجلدات المتضمنة.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => 'اسم مجلد جديد',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => 'يُرجى تحديد مجلد قبل القيام بهذا الإجراء.',
    'LBL_EMAIL_FOLDERS_TITLE' => 'إدارة المجلدات',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => 'استخدام مجموعة',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => 'تعيين لفريق',
    'LBL_EMAIL_FORWARD' => 'للأمام',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => 'تم تنزيل [[count]] من [[total]] رسائل البريد',
    'LBL_EMAIL_FOUND' => 'موجود',
    'LBL_EMAIL_FROM' => 'من',
    'LBL_EMAIL_GROUP' => 'المجموعة',
    'LBL_EMAIL_UPPER_CASE_GROUP' => 'المجموعة',
    'LBL_EMAIL_HOME_FOLDER' => 'الصفحة الرئيسية',
    'LBL_EMAIL_HTML_RTF' => 'إرسال HTML',
    'LBL_EMAIL_IE_DELETE' => 'حذف حساب البريد',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => 'حذف التوقيع',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => 'هل تريد بالتأكيد حذف حساب البريد هذا؟',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => 'تم الحذف بنجاح.',
    'LBL_EMAIL_IE_SAVE' => 'حفظ معلومات حساب البريد',
    'LBL_EMAIL_IMPORTING_EMAIL' => 'استيراد بريد إلكتروني',
    'LBL_EMAIL_IMPORT_EMAIL' => 'استيراد إلى Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => 'إعدادات الاستيراد',
    'LBL_EMAIL_INVALID' => 'غير صالح',
    'LBL_EMAIL_LINK_RECORD' => 'انقر هنا',
    'LBL_EMAIL_LIST_RENAME_TITLE' => 'إعادة تسمية قائمة المراسلة',
    'LBL_EMAIL_LIST_RENAME_DESC ' => 'أدخل اسمًا جديدًا لقائمة المراسلة',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => 'هل تريد إزالة هذه الإدخالات من قوائم المراسلة لديك؟',
    'LBL_EMAIL_LOADING' => 'يتم الآن التحميل...',
    'LBL_EMAIL_MARK' => 'علامة',
    'LBL_EMAIL_MARK_FLAGGED' => 'كمميز بعلامة',
    'LBL_EMAIL_MARK_READ' => 'كمقروء',
    'LBL_EMAIL_MARK_UNFLAGGED' => 'كغير مميز بعلامة',
    'LBL_EMAIL_MARK_UNREAD' => 'كغير مقروء',
    'LBL_EMAIL_ASSIGN_TO' => 'التعيين إلى',

    'LBL_EMAIL_MENU_ADD_FOLDER' => 'إنشاء مجلد',
    'LBL_EMAIL_MENU_COMPOSE' => 'إنشاء لـ',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => 'حذف مجلد',
    'LBL_EMAIL_MENU_EDIT' => 'تحرير',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => 'تفريغ سلة المهملات',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => 'تزامن',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => 'مسح ملفات التخزين المؤقت',
    'LBL_EMAIL_MENU_REMOVE' => 'إزالة',
    'LBL_EMAIL_MENU_RENAME' => 'إعادة تسمية',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => 'إعادة تسمية مجلد',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => 'إعادة تسمية مجلد جارية',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => 'يُرجى التحديد قبل محاولة إجراء هذه العملية.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => 'إنشاء مجلد (عن بُعد أو في Sugar)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => 'أرشفة هذا البريد (رسائل البريد) إلى SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => 'إرسال رسائل البريد لقوائم المراسلات المحددة',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => 'إرسال بريد لجهة الاتصال هذه',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => 'مسح جهة اتصال',
    'LBL_EMAIL_MENU_HELP_DELETE' => 'حذف تلك الرسالة (الرسائل) من البريد الإلكتروني',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => 'حذف مجلد (عن بُعد أو في Sugar)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => 'تحرير جهة اتصال',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => 'تعديل قائمة مراسلة',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => 'تفريغ جميع مجلدات سلة المهملات لحسابات بريدك الإلكتروني',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => 'وضع علامة على هذه الرسالة (الرسائل)',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => 'وضع علامة مقروء على هذه الرسالة (الرسائل)',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => 'تلك الرسالة (الرسائل) بدون علامة',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => 'تلك الرسالة (الرسائل) غير مقروءة',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => 'مسح قوائم المراسلة الخاصة بي',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => 'إعادة تسمية مجلد (عن بُعد أو في Sugar)',
    'LBL_EMAIL_MENU_HELP_REPLY' => 'الرد على هذه الرسالة (الرسائل)',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => 'الرد على كل المستلمين لهذه الرسالة (الرسائل) في البريد الإلكتروني',

    'LBL_EMAIL_MESSAGES' => 'الرسائل',

    'LBL_EMAIL_ML_NAME' => 'اسم القائمة',
    'LBL_EMAIL_ML_ADDRESSES_1' => 'عناوين القائمة المحددة',
    'LBL_EMAIL_ML_ADDRESSES_2' => 'عناوين القائمة المتاحة',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-انقر</b> لتحديد متعدد<br />(يستخدم مستخدموMac <b>CMD-انقر</b>)',

    'LBL_EMAIL_NO' => 'لا',
    'LBL_EMAIL_NOT_SENT' => 'هناك مشكلة في إرسال البريد الإلكتروني المطلوب. يُرجى الاتصال بمسؤول النظام.',
    'LBL_INSERT_TO_USER_PWD_FAILED' => 'تعذر إدراج users_password_link.',

    'LBL_EMAIL_OK' => 'موافق',
    'LBL_EMAIL_ONE_MOMENT' => 'الرجاء الانتظار...',
    'LBL_EMAIL_OPEN_ALL' => 'فتح رسائل متعددة',
    'LBL_EMAIL_OPTIONS' => 'الخيارات',
    'LBL_EMAIL_QUICK_COMPOSE' => 'إنشاء سريع',
    'LBL_EMAIL_OPT_OUT' => 'المرفوضة',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => 'مرفوضة وغير صالحة',
    'LBL_EMAIL_PAGE_AFTER' => 'من {0}',
    'LBL_EMAIL_PAGE_BEFORE' => 'صفحة',
    'LBL_EMAIL_PERFORMING_TASK' => 'القيام بمهمة',
    'LBL_EMAIL_PRIMARY' => 'أساسي',
    'LBL_EMAIL_PRINT' => 'طباعة',

    'LBL_EMAIL_QC_BUGS' => 'الخطأ',
    'LBL_EMAIL_QC_CASES' => 'الحالة',
    'LBL_EMAIL_QC_LEADS' => 'العميل المتوقع',
    'LBL_EMAIL_QC_CONTACTS' => 'جهة الاتصال',
    'LBL_EMAIL_QC_TASKS' => 'المهمة',
    'LBL_EMAIL_QC_OPPORTUNITIES' => 'الفرصة',
    'LBL_EMAIL_QUICK_CREATE' => 'إنشاء سريع',

    'LBL_EMAIL_REBUILDING_FOLDERS' => 'إعادة إنشاء مجلدات',
    'LBL_EMAIL_RELATE_TO' => 'ربط',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => 'عرض العلاقات',
    'LBL_EMAIL_RECORD' => 'سجل البريد الإلكتروني',
    'LBL_EMAIL_REMOVE' => 'إزالة',
    'LBL_EMAIL_REPLY' => 'الرد',
    'LBL_EMAIL_REPLY_ALL' => 'الرد على الكل',
    'LBL_EMAIL_REPLY_TO' => 'الرد على',
    'LBL_EMAIL_RETRIEVING_LIST' => 'استعادة قائمة البريد الإلكتروني',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => 'استعادة الرسائل',
    'LBL_EMAIL_RETRIEVING_RECORD' => 'استعادة سجل البريد الإلكتروني',
    'LBL_EMAIL_SELECT_ONE_RECORD' => 'يُرجى تحديد سجل بريد إلكتروني واحد',
    'LBL_EMAIL_RETURN_TO_VIEW' => 'العودة إلى النموذج السابق؟',
    'LBL_EMAIL_REVERT' => 'عودة',
    'LBL_EMAIL_RELATE_EMAIL' => 'ربط البريد الإلكتروني',

    'LBL_EMAIL_RULES_TITLE' => 'إدارة قاعدة',

    'LBL_EMAIL_SAVE' => 'حفظ',
    'LBL_EMAIL_SAVE_AND_REPLY' => 'الحفظ والرد',
    'LBL_EMAIL_SAVE_DRAFT' => 'حفظ المسودة',

    'LBL_EMAIL_SEARCHING' => 'إجراء بحث',
    'LBL_EMAIL_SEARCH_ADVANCED' => 'بحث متقدم',
    'LBL_EMAIL_SEARCH_DATE_FROM' => 'التاريخ من',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => 'التاريخ حتى',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => 'نص الموضوع',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => 'لم يتم العثور على نتائج مطابقة لمعايير البحث الخاصة بك.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => 'نتائج البحث',
    'LBL_EMAIL_SEARCH_TITLE' => 'بحث بسيط',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => 'البحث عن حساب البريد الإلكتروني',

    'LBL_EMAIL_SELECT' => 'تحديد',

    'LBL_EMAIL_SEND' => 'إرسال',
    'LBL_EMAIL_SENDING_EMAIL' => 'إرسال بريد إلكتروني',

    'LBL_EMAIL_SETTINGS' => 'الإعدادات',
    'LBL_EMAIL_SETTINGS_2_ROWS' => 'صفان',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 أعمدة',
    'LBL_EMAIL_SETTINGS_LAYOUT' => 'نمط المخطط',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => 'حسابات البريد',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => 'مسح نموذج',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => 'استيراد البريد عند العرض',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => 'التحقق من ورود بريد إلكتروني جديد',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => 'استخدم جزء المعاينة',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => 'استخدم نافذة منبثقة',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => 'عدد رسائل البريد الإلكتروني بكل صفحة',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => 'تحرير حساب البريد',
    'LBL_EMAIL_SETTINGS_FOLDERS' => 'المجلدات',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => 'عنوان "من"',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => 'عنوان البريد الإلكتروني من أجل اختبار الإشعارات:',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => 'إلى عنوان البريد الإلكتروني',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => 'من اسم',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => 'الرد على العنوان',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => 'شاشة كاملة',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => 'مزامنة جميع حسابات البريد الإلكتروني',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => 'تم إرسال بريد إلكتروني لعنوان البريد الإلكتروني المحدد باستخدام إعدادات البريد الصادر المقدمة. يُرجى التحقق من احتمال استلام البريد الإلكتروني للتحقق من صحة الإعدادات.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => 'القيام بهذا الإجراء سيتزامن مع حسابات البريد الإلكتروني ومحتوياتها.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => 'إجراء مزامنة كاملة؟\nفي حسابات البريد الإلكتروني الضخمة قد يستغرق ذلك بضع دقائق.',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => 'انقر فوق المفتاح Shift أو المفتاح Ctrl لتحديد مجلدات متعددة.',
    'LBL_EMAIL_SETTINGS_GENERAL' => 'عام',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => 'مجلدات مجموعة متاحة',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => 'إنشاء مجلدات مجموعة',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'حفظ مجلدات مجموعة',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => 'استعادة مجلد مجموعة',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'تعديل مجلد مجموعة',

    'LBL_EMAIL_SETTINGS_NAME' => 'اسم حساب البريد',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => 'تحديد عدد رسائل البريد بكل صفحة في صندوق الوارد. قد يحتاج هذا الإعداد إلى تحديث صفحة ليسري التأثير.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'استعادة حساب البريد',
    'LBL_EMAIL_SETTINGS_RULES' => 'القواعد',
    'LBL_EMAIL_SETTINGS_SAVED' => 'تم حفظ الإعدادات.',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => 'يتعين عليك إعادة تحميل الصفحة لبدء سريان الإعدادات الجديدة.',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => 'إرسال رسائل بريد بنص عادي فقط',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => 'نشط',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => 'رسائل البريد بكل صفحة',
    'LBL_EMAIL_SETTINGS_TAB_POS' => 'وضع علامات تبويب في الأسفل',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => 'الإعدادات المرئية',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => 'التفضيلات',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => 'عرض الخيارات المتقدمة',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => 'مجلدات مستخدم متاحة',
    'LBL_EMAIL_ERROR_PREPEND' => 'خطأ:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => 'خادم البريد الصادر المحدد لحسابك للبريد غير صالح.  تحقق من الإعدادات أو قم بتحديد خادم بريد لحساب البريد.',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => 'لم تتم تهيئة خادم البريد الصادر لإرسال رسائل البريد. يُرجى تهيئة خادم بريد صادر أو تحديد خادم بريد صادر لحساب البريد الذي تستخدمه من إعدادات >> حساب البريد.',
    'LBL_EMAIL_SHOW_READ' => 'إظهار الكل',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => 'إظهار غير المقروء فقط',
    'LBL_EMAIL_SIGNATURES' => 'توقيعات',
    'LBL_EMAIL_SIGNATURE_CREATE' => 'إنشاء توقيع',
    'LBL_EMAIL_SIGNATURE_NAME' => 'اسم التوقيع',
    'LBL_EMAIL_SIGNATURE_TEXT' => 'موضوع التوقيع',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'تطبيقات Google الأقل أمانًا',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! البريد',
    'LBL_SMTPTYPE_EXCHANGE' => ' Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'أخرى',
    'LBL_EMAIL_AUTHORIZE' => 'تصريح',
    'LBL_EMAIL_AUTHORIZED' => 'مصرح له',
    'LBL_EMAIL_NOT_AUTHORIZED' => 'غير مصرح له',
    'LBL_EMAIL_AUTH_WARNING' => 'يجب على أحد المسؤولين تكوين موصل {0} عبر المسؤول > الموصلات قبل إمكانية إعداد هذا الحساب. لمزيد من المعلومات، ارجع إلى وثائق {1}.',
    'LBL_EMAIL_AUTH_API_ERROR' => 'خطأ في استرداد معلومات الموصل',
    'LBL_EMAIL_AUTH_FAILURE' => 'فشل المصادقة.',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => 'الرجاء التصريح للحساب قبل الحفظ.',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => 'الرجاء التصريح للحساب قبل الاختبار.',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => 'لم يتم التصريح للحساب',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[ مجلدات عن بُعد ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ مجلدات Sugar ]',
    'LBL_EMAIL_SUBJECT' => 'الموضوع',
    'LBL_EMAIL_SUCCESS' => 'نجاح',
    'LBL_EMAIL_SUGAR_FOLDER' => 'مجلد Sugar',
    'LBL_EMAIL_TEAMS' => 'تعيين إلى فرق العمل',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => 'نص قالب البريد الإلكتروني فارغ',
    'LBL_EMAIL_TEMPLATES' => 'قوالب',
    'LBL_EMAIL_TEXT_FIRST' => 'الصفحة الأولى',
    'LBL_EMAIL_TEXT_PREV' => 'الصفحة السابقة',
    'LBL_EMAIL_TEXT_NEXT' => 'الصفحة التالية',
    'LBL_EMAIL_TEXT_LAST' => 'الصفحة الأخيرة',
    'LBL_EMAIL_TEXT_REFRESH' => 'تحديث',
    'LBL_EMAIL_TO' => 'إلى',
    'LBL_EMAIL_TOGGLE_LIST' => 'تبديل القائمة',
    'LBL_EMAIL_VIEW' => 'عرض',
    'LBL_EMAIL_VIEWS' => 'عروض',
    'LBL_EMAIL_VIEW_HEADERS' => 'عرض العناوين',
    'LBL_EMAIL_VIEW_PRINTABLE' => 'إصدار قابل للطباعة',
    'LBL_EMAIL_VIEW_RAW' => 'عرض البريد الإلكتروني البسيط',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => 'هذه الخاصية غير مدعومة عند استخدامها مع POP3.',
    'LBL_DEFAULT_LINK_TEXT' => 'نص الارتباط الافتراضي.',
    'LBL_EMAIL_YES' => 'نعم',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => 'إرسال بريد إلكتروني اختبار',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => 'تم إرسال رسالة اختبار ',


    'LBL_EMAIL_MESSAGE_NO' => 'رسالة لا',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'نجح الاستيراد',
    'LBL_EMAIL_IMPORT_FAIL' => 'فشل الاستيراد إما لأن الرسالة قد تم استيرادها بالفعل، وإما لأنها قد تم حذفها من الخادم',

    'LBL_EMAILS_FROM' => 'رسائل البريد الإلكتروني المرسلة',
    'LBL_EMAILS_RECEIVED' => 'رسائل البريد الإلكتروني المستلمة',
    'LBL_EMAIL_ADDRESSES_USED' => 'عناوين البريد الإلكتروني المستخدمة في الرسائل',
    'LBL_EMAIL_ADDRESS' => 'عنوان البريد الإلكتروني',
    'LBL_FROM' => 'من',
    'LBL_TO' => 'إلى',
    'LBL_CC' => 'نسخة',
    'LBL_BCC' => 'نسخة مخفية',

    'LBL_START_DATE' => 'تاريخ البدء',
    'LBL_END_DATE' => 'تاريخ الانتهاء',
    'LBL_START' => 'البدء',
    'LBL_END' => 'الانتهاء',
    'LBL_DATE_LINKED' => 'تاريخ الربط',

    'LBL_LINK_NONE' => 'بلا',
    'LBL_LINK_ALL' => 'الكل',
    'LBL_LINK_RECORDS' => 'السجلات',
    'LBL_LINK_SELECT' => 'تحديد',
    'LBL_LINK_ACTIONS' => 'الإجراءات',
    'LBL_LINK_MORE' => 'المزيد',
    'LBL_CLOSE_ACTIVITY_HEADER' => 'تأكيد',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => 'هل ترغب في غلق هذا #النموذج#؟',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => 'لا تعرض هذه الرسالة في المستقبل: &nbsp;',
    'LBL_INVALID_FILE_EXTENSION' => 'امتداد الملف غير صالح',
    'LBL_LIST_TEAM' => 'الفريق',
    'LBL_TEAM' => 'الفريق:',
    'LBL_TEAMS' => 'الفرق',
    'LBL_TEAM_SET_ID' => 'المعرّف المعين للفريق',
    'LBL_TEAM_SET_SELECTED_ID' => 'معرف تعيين الفريق المحدد',
    'LBL_TEAM_SET_SELECTED' => 'محدد',
    'LBL_TEAM_SET_ENABLE' => 'تمكين إذون إضافية',
    'LBL_TEAM_SET_DISABLE' => 'تعطيل إذون إضافية',
    'LBL_TEAM_SET' => 'ضبط الفريق',
    'LBL_TEAM_SET_SELECTED_TEAMS' => 'الفرق المختارة',
    'LBL_SEARCH_UNAVAILABLE' => 'البحث غير متاح، يُرجى المحاولة لاحقًا.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => 'لم يتم تحديد فريق رئيسي',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => 'خطأ في محاولة إزالة معرّف فريق أساسي [{0}] لـ [{1}] نموذج مزود بمعرّف [{2}]',
    'LBL_TEAM_ADD' => 'إضافة &nbsp;فريق',
    'LBL_TEAM_REMOVE' => 'إزالة فريق',
    'LBL_TEAM_PRIMARY' => 'تعيين كفريق أساسي',

    'LBL_CLOSE_BUTTON_LABEL' => 'إغلاق',
    'TPL_STATUS_CHANGE_SUCCESS' => 'تم تمييز {{moduleSingular}} بحالة {{status}}.',

    'LBL_FOCUS' => 'التركيز',

    'LBL_QUERY_VALID' => 'صالح',
    'LBL_QUERY_ERROR' => 'خطأ!',
    'LBL_QUERY_CHILD' => 'استعلام فرعي صالح',
    'ERROR_EXAMINE_MSG' => '  يُرجى اختبار رسالة الخطأ أدناه:',
    'NO_QUERY_SELECTED' => 'لا يتضمن تنسيق البيانات الذي اخترته استعلامًا.  يُرجى تحديد استعلام مخصص لتنسيق هذه البيانات.',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => 'حدث خطأ:',
    'ERR_AJAX_LOAD_FAILURE' => 'هناك خطأ في طلبك، يُرجى المحاولة مرة أخرى لاحقًا.',
    'ERR_AJAX_LOAD_FOOTER' => 'في حالة استمرار هذا الخطأ، يُرجى قيام المسؤول بتعطيل Ajax لهذا النموذج',
    'ERR_CREATING_FIELDS' => 'خطأ في ملء حقول التفاصيل الإضافية: ',
    'ERR_CREATING_TABLE' => 'خطأ في إنشاء جدول: ',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'لا يمكن للفاصل العشري استخدام نفس الحرف مثل فاصل الآلاف. يُرجى تغيير إحدى القيم.',
    'ERR_DELETE_RECORD' => 'يجب تحديد رقم السجل لإزالة جهة الاتصال.',
    'ERR_EXPORT_DISABLED' => 'تم تعطيل التصدير.',
    'ERR_EXPORT_TYPE' => 'خطأ في التصدير ',
    'ERR_REPORTS_DISABLED_EXPORT' => 'تم تعطيل تصدير التقارير',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => 'يمكن للمستخدمين المسؤولين فقط التصدير',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => 'يستخدم التقرير وحدات دون إذن تصدير',
    'ERR_REPORTS_EXPORT_OWNER' => 'يستخدم التقرير وحدات ذات إذن وصول لمالك التصدير',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => 'يستخدم التقرير وحدات ذات إذن وصول سرد مقيد',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => 'يستخدم التقرير وحدات ذات إذن وصول عرض مقيد',
    'ERR_REPORTS_ACCESS_DISABLED' => 'يستخدم التقرير وحدات ذات إذن وصول مقيد',
    'ERR_REPORTS_FIELDS_RESTRICTED' => 'يستخدم التقرير حقول ذات إذن وصول مقيد',
    'ERR_INVALID_AMOUNT' => 'يرجى إدخال كمية صالحة.',
    'ERR_INVALID_DATE_FORMAT' => 'يجب أن يكون تنسيق التاريخ: ',
    'ERR_INVALID_DATE' => 'يرجى إدخال تاريخ صالح.',
    'ERR_INVALID_DAY' => 'يرجى إدخال يوم صالح.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'عنوان بريد إلكتروني غير صالح.',
    'ERR_INVALID_FILE_REFERENCE' => 'مرجعية الملف غير صالحة',
    'ERR_INVALID_HOUR' => 'يرجى إدخال ساعة صالحة.',
    'ERR_INVALID_MONTH' => 'يرجى إدخال شهر صالح.',
    'ERR_INVALID_TIME' => 'يرجى إدخال وقت صالح.',
    'ERR_INVALID_YEAR' => 'يُرجى إدخال تاريخ مكون من 4 أرقام صالحة.',
    'ERR_NEED_ACTIVE_SESSION' => 'مطلوب جلسة نشطة لتصدير المحتوى.',
    'ERR_NO_HEADER_ID' => 'هذه الخاصية غير متاحة في هذا الموضوع.',
    'ERR_NOT_ADMIN' => 'دخول غير مسموح به للإدارة.',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        'إدارة كلمات المرور متوفرة فقط في <a href="%s" target="_blank">إعدادات SugarCloud</a>.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => 'الرجاء الاتصال بمسؤول Sugar إذا كنت ترغب في إجراء تغييرات على حقول القراءة فقط.',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => 'الرجاء الوصول إلى <a href="{0}" target="_blank">إعدادات SugarCloud</a> لإجراء التعييرات على حقول القراءة فقط.',
    'ERR_MISSING_REQUIRED_FIELDS' => 'حقل مطلوب مفقود:',
    'ERR_INVALID_REQUIRED_FIELDS' => 'حقل مطلوب غير صالح:',
    'ERR_INVALID_VALUE' => 'قيمة غير صالحة:',
    'ERR_NO_SUCH_FILE' => 'لم يتم العثور على ملف على النظام',
    'ERR_NO_SINGLE_QUOTE' => 'تعذر استخدام علامة اقتباس وحيدة من أجل ',
    'ERR_NOTHING_SELECTED' => 'يُرجى التحديد قبل المتابعة.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'هناك فرصة باسم %s موجودة بالفعل.  يُرجى إدخال اسم آخر أدناه.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'لم يتم إدخال اسم الفرصة.  يُرجى إدخال اسم فرصة أدناه.',
    'ERR_QUOTE_CONVERTED' => 'عرض السعر هذا تم تحويله بالفعل إلى فرصة.',
    'ERR_POTENTIAL_SEGFAULT' => 'تم اكتشاف خطأ تقسيم Apache محتمل.  يُرجى إخطار مسؤول النظام بالتأكيد على هذه المشكلة وقيامه/قيامها بالإبلاغ عنها لـ SugarCRM.',
    'ERR_SELF_REPORTING' => 'يتعذر على المستخدم الإبلاغ له أو لها.',
    'ERR_SINGLE_QUOTE' => 'استخدام عرض سعر واحد غير مدعوم لهذا الحقل.  يرجى تغيير القيمة.',
    'ERR_SQS_NO_MATCH_FIELD' => 'لا يوجد تطابق للحقل: ',
    'ERR_SQS_NO_MATCH' => 'عدم تطابق',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'يرجى تحديد فهرس &#39;key&#39; في عرض سمة المعلمات بالنسبة لتعريف بيانات التعريف',
    'ERR_EXISTING_PORTAL_USERNAME' => 'خطأ: اسم البوابة معيَّن بالفعل لجهة اتصال أخرى.',
    'ERR_PORTAL_NAME_CHECK' => 'غير قادر على التحقق من أن اسم مستخدم المنفذ فريد',
    'ERR_COMPATIBLE_PRECISION_VALUE' => 'قيمة الحقل غير متوافقة مع قيمة الدقة',
    'ERR_EXTERNAL_API_SAVE_FAIL' => 'حدث خطأ عند محاولة حفظ الحساب الخارجي.',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => 'وقع خطأ أثناء التحميل.  يرجى التأكيد على أن الملف الذي تقوم بتحميله غير فارغ.',
    'ERR_NO_DB' => 'تعذر الاتصال بقاعدة البيانات. يرجى الرجوع إلى sugarcrm.log لمزيد من التفاصيل.',
    'ERR_DB_FAIL' => 'عطل بقاعدة البيانات. يرجى الرجوع إلى sugarcrm.log لمزيد من التفاصيل.',
    'ERR_EXTERNAL_API_403' => 'رفض التصريح. نوع الملف غير مدعوم.',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'رمز الوصول إلى OAuth مفقود.',
    'ERR_DB_VERSION' => 'Sugar CRM {0} ملفات ربما تم استخدامها من خلال قاعدة بياناتA Sugar CRM {1}.',
    'ERR_DB_QUERY' => '{0}: فشل الاستعلام: {1}',
    'ERR_UW_RETIRED' => 'نافذة التحديث غير متاحة بهذا الإصدار.',
    'ERR_NOT_CLOUD_INSTANCE' => 'هذا المثيل من Sugar إما مثيل SugarCloud أو لم يتم تكوينه لـ SugarCloud Insights.',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => 'غير مصرح لك بإنشاء {moduleName}. اتصل بمسؤول النظام إذا كنت ترغب في الدخول.',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => 'غير مصرح للمستخدم الحالي بتغيير {moduleName}إعدادات التهيئة',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => 'غير مصرح للمستخدم الحالي بتغيير {moduleName}إعدادات التهيئة',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => 'غير مصرح لك بتفضيل{moduleName}. اتصل بمسؤول النظام إذا كنت ترغب في الدخول.',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => 'غير مصرح لك بالاشتراك في{moduleName}. اتصل بمسؤول النظام إذا كنت ترغب في الدخول.',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => 'لم يتم العثور على worksheet_columns_related_fields في الحمولة',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns ليست مصفوفة',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => 'لم يتم العثور على summary_columns_related_fields في الحمولة',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows ليست مصفوفة',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => 'لم يتم العثور على footer_rows_related_fields في الحمولة',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => 'فشل طلبك نتيجة استثناء غير معروف.',
    'EXCEPTION_FATAL_ERROR' => 'فشل اكتمال طلبك.  حدث خطأ فادح.  تحقق من السجلات لمزيد من التفاصيل.',
    'EXCEPTION_NEED_LOGIN' => 'يتعين عليك تسجيل الدخول للقيام بهذا الإجراء.',
    'EXCEPTION_INVALID_TOKEN' => 'رمز المصادقة الخاص بك غير صالح.',
    'EXCEPTION_NOT_AUTHORIZED' => 'غير مصرح لك بالقيام بهذا الإجراء. اتصل بمسؤول النظام إذا كنت ترغب في الدخول.',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => 'غير مصرح لك بعرض البيانات. اتصل بمسؤول النظام إذا كنت ترغب في الدخول.',
    'EXCEPTION_INACTIVE_PORTAL_USER' => 'لا يمكنك الدخول إلى البوابة بسبب أن حساب البوابة غير نشط. يرجى الاتصال بخدمة العملاء إذا كنت ترغب في الدخول.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => 'لم تتم تهيئة المنفذ بالشكل السليم.  اتصل بمسؤول المنفذ لطلب المساعدة.',
    'EXCEPTION_NO_METHOD' => 'طلبك لم يتم دعمه. تعذر العثور على طريقة HTTP لطلبك لهذا المسار.',
    'EXCEPTION_NOT_FOUND' => 'لم يتم العثور على مورد طلبك.  تعذر العثور على معالج للمسار المحدد في الطلب.',
    'EXCEPTION_MISSING_PARAMTER' => 'المعلمة المطلوبة غير موجودة في طلبك.',
    'EXCEPTION_INVALID_PARAMETER' => 'المعلمة المطلوبة الموجودة في طلبك غير صالحة.',
    'EXCEPTION_REQUEST_FAILURE' => 'فشل اكتمال طلبك.',
    'EXCEPTION_METADATA_OUT_OF_DATE' => 'عدم تطابق بيانات التعريف أو تجزئة المستخدم الخاصة بك مع الخادم. يرجى إعادة تزامن بيانات تعريفك.',
    'EXCEPTION_REQUEST_TOO_LARGE' => 'طلبك كبير جدًا للتعامل معه.',
    'EXCEPTION_EDIT_CONFLICT' => 'تحرير مشكلة، يرجى إعادة تحميل البيانات المسجلة.',
    'EXCEPTION_METADATA_CONFLICT' => 'مشكلة في بيانات التعريف، يرجى إعادة تحميل بيانات التعريف.',
    'EXCEPTION_CLIENT_OUTDATED' => 'برامجك غير محدثة، يرجى تحديث عميلك قبل محاولة الاتصال مجددًا.',
    'EXCEPTION_CONNECTOR_RESPONSE' => 'أدى طلب توصيل أو دمج إلى فشل الاستجابة.',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM في وضع الصيانة. الدخول لمسؤولي النظام فقط. يرجى الاتصال بمسؤول نظامك لمزيد من التفاصيل.',
    'EXCEPTION_SERVICE_UNAVAILABLE' => 'يتعذر على الملقم معالجة الطلب الخاص بك لأنه مشغول أو غير متوفرة في هذا الوقت.',
    'EXCEPTION_SEARCH_UNAVAILABLE' => 'محرك البحث غير متوفر مؤقتَا.',
    'EXCEPTION_SEARCH_RUNTIME' => 'حدث خطأ خلال وقت تشغيل محرك البحث. الرجاء الاتصال بـ "مسؤول النظام" لديك.',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => 'يتم قفل الحقل بواسطة عملية يتعذر تحريرها.',
    'EXCEPTION_MODULE_DISABLED' => 'تم تعطيل هذه الوحدة للمستخدم الحالي.',
    'EXCEPTION_FIELD_DISABLED' => 'تم تعطيل هذا الحقل للمستخدم الحالي.',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => 'هذا العميل غير مسموح له',
    'EXCEPTION_MODULELOADER_UPLOAD' => 'القدرة على تحميل الحزم غير متوفرة لنوع الترخيص الخاص بك',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => 'تمت مواجهة حالة نتيجة عطل أو فشل عام. تختلف أسباب هذا الاستثناء ولكن تقع عامةً خارج نطاق استثناء API محدد أكثر.',
    'EXCEPTION_FATAL_ERROR_DESC' => 'تعذر التعامل مع الطلب كما هو موضح أو أن هناك خطأ في الاستجابة. هذا يعني وقوع خطأ فادح بشكل عام ويمكن تحديد خطأ معيَّن في سجل التطبيق.',
    'EXCEPTION_INCORRECT_VERSION_DESC' => 'إصدار API قيد الاستخدام غير صحيح للطلب الحالي.',
    'EXCEPTION_NEED_LOGIN_DESC' => 'تحتاج نقطة النهاية المطلوبة المصادقة ولم يتم التصديق على المستهلك صاحب الطلب حتى الآن.',
    'EXCEPTION_INVALID_TOKEN_DESC' => 'تشير إلى عدم صلاحية رمز المصادقة المقدم مع الطلب. ويحدث ذلك عامةً نتيجة انتهاء صلاحية الرمز ولكن قد يكون السبب أيضًا تشوه الرمز أو أنه غير صحيح.',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => 'تشير إلى أن المستهلك صاحب الطلب غير مصدق له للقيام بالإجراء المطلوب.',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => 'حساب المنفذ المرتبط بالمستخدم قيد الدخول غير نشط حاليًا. هذا يتطلب إجراءً من جانب دعم العملاء.',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => 'تشير إلى أن تطبيق المنفذ لم تتم تهيئته بالشكل الصحيح ويتعذر استخدامه. هذا يتطلب إجراءً من جانب مسؤول المنفذ.',
    'EXCEPTION_NO_METHOD_DESC' => 'لا تدعم نقطة النهاية نوع طلب HTTP الذي تم عمله. قد يحدث هذا عند عمل طلب POST لنقطة نهاية مخصصة لطلب GET على سبيل المثال.',
    'EXCEPTION_NOT_FOUND_DESC' => 'تعذر على نقطة النهاية تحديد مكان مورد الطلب أو ليس لديها معالج للطلب.',
    'EXCEPTION_EDIT_CONFLICT_DESC' => 'تشير إلى أن هناك تعديلات حالية تُجرى لسجل وأن الطلب الحالي لتعديل السجل يؤثر على التعديل السابق للسجل.',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => 'تشير إلى أن بيانات التعريف على الخادم لا تتطابق مع بيانات التعريف التي يستخدمها العميل حاليًا. قد يحدث ذلك بعد تغيير لإعدادات النظام، أو تغييرات للوحدات في الاستوديو، أو توزيع الوحدات الجديدة، بين تغييرات النظام الأخرى.',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => 'الطلب ضخم جدًا للتعامل معه من قبل الخادم.',
    'EXCEPTION_MISSING_PARAMTER_DESC' => 'تشير إلى أن المعلمة المطلوبة الخاصة بالطلب مفقودة.',
    'EXCEPTION_INVALID_PARAMETER_DESC' => 'تشير إلى إرسال معلم في الطلب غير صالح.',
    'EXCEPTION_REQUEST_FAILURE_DESC' => 'فشل اكتمال الطلب.',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'تشير إلى أن استهلاك العميل API غير محدث ويجب تحديثه قبل المزيد من استهلاك API.',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => 'للإشارة إلى فشل أو عدم القدرة على التعامل مع طلب تم عمله من خلال واجهة API إلى خدمة أو نقطة نهاية أو عنوان URI آخر (أخرى) من خلال الخادم.',
    'EXCEPTION_MAINTENANCE_DESC' => 'مثال SugarCRM الذي يخدم API في وضع الصيانة. الدخول إلى API مقتصر على المسؤول فقط.',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => 'يشير إلى أن الملقم مشغول أو مضغوط عليه بشكل زائد أو معطل.',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => 'الطرف الخلفي لمحرك البحث غير متوفر حاليًا بسبب مشكلة اتصال. تحقق من الاتصال والتكوين في الإدارة-> بحث-> الاختبار.',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => 'حدث استثناء وقت تشغيل في محرك البحث. انظر ملف sugarcrm.log لمزيد من التفاصيل.',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => 'تم قفل الحقل حاليًا بواسطة عملية جارية يتعذر تحريرها.',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => 'تم تأمين %s بعملية جارية، ويتعذر تحريره.',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => 'تم تأمين %s بعملية جارية، ويتعذر تحريرها.',
    'EXCEPTION_MODULE_DISABLED_DESC' => 'تم تعطيل هذه الوحدة للمستخدم الحالي.',
    'EXCEPTION_FIELD_DISABLED_DESC' => 'تم تعطيل هذا الحقل للمستخدم الحالي.',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => 'هذا العميل غير مسموح له',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => 'ملف بنفس الاسم يوجد بالفعل في النظام.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => 'خطأ الفترة الزمنية غير محدد للتاريخ {0}',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => 'هذه الفترة الزمنية بالفعل لها فترات فرعية',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => 'لا يمكن للفترات الزمنية الفرعية أن يكون لها فترات فرعية',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => 'غير قادر على استعادة أي نوع من الفترات الزمنية: {0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => 'لا توجد فترات زمنية نشطة للإعدادات الحالية.',
    'LBL_CURRENT_TIMEPERIOD' => 'فترة زمنية حالية',
    'LBL_PREVIOUS_TIMEPERIOD' => 'فترة زمنية سابقة',
    'LBL_NEXT_TIMEPERIOD' => 'فترة زمنية تالية',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => 'سابق، وحالي، وتالٍ',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => 'لا يمكنك حذف السجلات التي لها مرحلة مبيعات مغلقة.',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => 'لا يمكنك حذف السجلات التي لها حالة مبيعات مغلقة.',

    'WARNING_NO_DELETE_SELECTED_STAGE' => 'أحد السجلات المحددة أو أكثر له مرحلة مبيعات "إغلاق لسبب الفوز" أو "إغلاق لسبب الخساره" ولا يمكن حذفه.',
    'WARNING_NO_DELETE_SELECTED_STATUS' => 'أحد السجلات المحددة أو أكثر له حالة "إغلاق لسبب الفوز" أو "إغلاق لسبب الخساره" لا يمكن حذفها.',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => 'الحساب',
    'LBL_OLD_ACCOUNT_LINK' => 'حساب قديم',
    'LBL_ACCOUNTS' => 'الحسابات',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => 'الأنشطة',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'عرض الملخص',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'عرض الملخص',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'إضافة',
    'LBL_ADD_BUTTON' => 'إضافة',
    'LBL_ADD_DASHLET_BUTTON' => 'إضافة لوحة معلومات',
    'LBL_ADD_DOCUMENT' => 'أضف مستندًا',
    'LBL_REPLACE_BUTTON' => 'استبدل',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'أضف لقائمة الهدف',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'أضف لقائمة الهدف',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'انقر للغلق',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'إغلاق',
    'LBL_ADDITIONAL_DETAILS' => 'تفاصيل إضافية',
    'LBL_ADMIN' => 'مسؤول',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => 'أرشيف',
    'LBL_ASSIGNED_TO_USER' => 'معيَّن للمستخدم',
    'LBL_ASSIGNED_TO' => 'تم تعيينها إلى:',
    'LBL_BACK' => 'للخلف',
    'LBL_BASE_RATE' => 'سعر الأساس',
    'LBL_BILL_TO_ACCOUNT' => 'تحرير الفاتورة إلى حساب',
    'LBL_BILL_TO_CONTACT' => 'تحرير الفاتورة إلى جهة اتصال',
    'LBL_BILLING_ADDRESS' => 'عنوان الفوترة',
    'LBL_QUICK_CREATE_TITLE' => 'إنشاء سريع',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => ' {{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => 'الأخطاء',
    'LBL_BY' => 'بواسطة',
    'LBL_CALLS' => 'المكالمات',
    'LBL_CALL' => 'المكالمة',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'إرسال رسائل إلكترونية لحملة في قائمة الانتظار',
    'LBL_SUBMIT_BUTTON_LABEL' => 'إرسال',
    'LBL_CASE' => 'الحالة',
    'LBL_CASES' => 'الحالات',
    'LBL_MESSAGE' => 'الرسالة',
    'LBL_MESSAGES' => 'الرسائل',
    'LBL_ESCALATIONS' => 'عمليات التصعيد',
    'LBL_ESCALATION' => 'عملية التصعيد',
    'LBL_DOCUSIGN_ENVELOPES' => 'مغلفات DocuSign',
    'LBL_DOCUSIGN_ENVELOPE' => 'مغلف DocuSign',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => 'تحديد مستلمي الموقِّع',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => 'تغيير كلمة المرور',
    'LBL_CHANGE_BUTTON_LABEL' => 'تغيير',
    'LBL_CHANGE_BUTTON_TITLE' => 'تغيير',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'فحص الكل',
    'LBL_CITY' => 'المدينة',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'مسح',
    'LBL_CLEAR_BUTTON_TITLE' => 'مسح',
    'LBL_CLEARALL' => 'مسح الكل',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => 'إغلاق',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => 'إغلاق النافذة',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'إغلاق الكل',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'إغلاق الكل',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'إغلاق وإنشاء جديد',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'إغلاق وإنشاء جديد',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => 'نسخ عنوان URL السجل',
    'LBL_OPEN_ITEMS' => 'فتح عناصر:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'إنشاء بريد إلكتروني',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => 'البريد الإلكتروني',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'إنشاء بريد إلكتروني',
    'LBL_SEARCH_DROPDOWN_YES' => 'نعم',
    'LBL_SEARCH_DROPDOWN_NO' => 'لا',
    'LBL_CONTACT_LIST' => 'قائمة جهات الاتصال',
    'LBL_CONTACT' => 'جهة الاتصال',
    'LBL_CONTACTS' => 'جهات الاتصال',
    'LBL_CONTRACTS' => 'العقود',
    'LBL_COUNTRY' => 'البلد:',
    'LBL_RESET_BUTTON_LABEL' => 'إعادة تعيين',
    'LBL_CREATE_BUTTON_LABEL' => 'إنشاء',
    'LBL_CREATED_BY_USER' => 'تم الإنشاء بواسطة المستخدم',
    'LBL_CREATED_USER' => 'تم الإنشاء بواسطة المستخدم',
    'LBL_CREATED_ID' => 'تم الإنشاء بواسطة المعرّف',
    'LBL_CREATED' => 'تم الإنشاء بواسطة',
    'LBL_CREATE_NEW_TARGET_LIST' => 'إنشاء قائمة أهداف جديدة',
    'LBL_CURRENT_USER_FILTER' => 'العناصر الخاصة بي:',
    'LBL_CURRENCY' => 'العملة:',
    'LBL_CURRENCIES' => 'العملات',
    'LBL_CURRENCY_NAME' => 'اسم العملة',
    'LBL_CURRENCY_SYMBOL' => 'رمز العملة',
    'LBL_CURRENCY_RATE' => 'معدل أساسي:',
    'LBL_CURRENCY_ID' => 'معرّف العملة',
    'LBL_DOCUMENTS' => 'المستندات',
    'LBL_DATE_ENTERED' => 'تاريخ الإنشاء:',
    'LBL_DATE_MODIFIED' => 'تاريخ التعديل:',
    'LBL_ACTIVITY_MODIFIED' => 'تم التعديل',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => 'علامة تبويب تحرير النظرة العامة',
    'LBL_EDIT_MODULE_TABS_BUTTON' => 'علامات تبويب تحرير الوحدة',
    'LBL_EDIT_BUTTON' => 'تحرير',
    'LBL_DUPLICATE_BUTTON' => 'تكرار',
    'LBL_DELETE_BUTTON' => 'حذف',
    'LBL_DELETE' => 'حذف',
    'LBL_DELETED' => 'تم الحذف',
    'LBL_DIRECT_REPORTS' => 'التقارير المباشرة',
    'LBL_DONE_BUTTON_KEY' => 'إكس',
    'LBL_DONE_BUTTON_LABEL' => 'تم',
    'LBL_DONE_BUTTON_TITLE' => 'تم',
    'LBL_DST_NEEDS_FIXIN' => 'يتطلب التطبيق تثبيت التوقيت الصيفي لتوفير الوقت لتطبيقه.  يرجى الذهاب إلى ارتباط إصلاح<a href="index.php?module=Administration&action=DstFix"></a> في منصة المسؤول وتطبيق التوقيت الصيفي لتوفير الوقت المثبت.',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => 'تعديل كجديد',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => 'تعديل كجديد',
    'LBL_EDIT_IN_NEW_TAB' => 'تحرير في علامة تبويب جديدة',
    'LBL_FAVORITES' => 'المفضلة',
    'LBL_FILTER' => 'عامل التصفية',
    'LBL_DEFAULT_DATA_FILTER' => 'عامل تصفية البيانات الافتراضي',
    'LBL_FILTER_MENU_BY' => 'قائمة عوامل التصفية حسب',
    'LBL_FILTER_SELECT_FIELD' => 'يتم الآن تحديد حقل...',
    'LBL_FILTER_SELECT_OPERATOR' => 'يتم الآن تحديد مشغل...',
    'LBL_FILTER_CREATE_NEW' => 'إنشاء',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => 'عامل تصفية البناء (غير محفوظ)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(غير محفوظ)',
    'LBL_FILTER_CREATE_FILTER' => 'إنشاء عامل تصفية جديد',
    'LBL_FILTER_CLOSE_FILTER' => 'إغلاق عامل التصفية',
    'LBL_FILTER_EDIT_FILTER' => 'تحرير عامل تصفية',
    'LBL_FILTER_ALL_RECORDS' => 'كل السجلات',
    'TPL_FILTER_SAVE' => 'لقد أنشأت عامل التصفية بنجاح{{name}}.',
    'LBL_FILTER_BETWEEN_FROM' => 'من',
    'LBL_FILTER_BETWEEN_TO' => 'إلى',
    'LBL_FILTER_DATEBETWEEN_FROM' => 'تاريخ البدء',
    'LBL_FILTER_DATEBETWEEN_TO' => 'تاريخ الانتهاء',
    'LBL_FOLLOWING' => 'التابع',
    'LBL_UNFOLLOW' => 'لا يتبع',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => 'تنزيل vCard',
    'LBL_EMPTY_VCARD' => 'يرجى تحديد ملف vCard',
    'LBL_IMAGE' => 'صورة',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard ليس لديه كل الحقول المطلوبة لهذه الوحدة.',
    'LBL_VCARD_ERROR_FILESIZE' => 'يتجاوز الملف المحمل 30000 بايت المحدد في نموذج HTML.',
    'LBL_VCARD_ERROR_DEFAULT' => 'حدث خطأ في تحميل ملف vCard.',
    'TPL_IMPORT_VCARD_FAILURE' => 'فشل إنشاء {{module}} من vCard',
    'LBL_IMPORT_VCARD' => 'استيراد vCard:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => 'استيراد vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => 'استيراد vCard',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'عرض',
    'LBL_VIEW_BUTTON_TITLE' => 'عرض',
    'LBL_VIEW_BUTTON' => 'عرض',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'بريد إلكتروني كملف PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'بريد إلكتروني كملف PDF',
    'LBL_EMAIL' => 'البريد الإلكتروني',
    'LBL_EMAILS' => 'رسائل البريد الإلكتروني',
    'LBL_EMPLOYEES' => 'الموظفون',
    'LBL_ENTER_DATE' => 'أدخل التاريخ',
    'LBL_EXPORT_ALL' => 'تصدير الكل',
    'LBL_EXPORT' => 'تصدير',
    'LBL_FAVORITES_FILTER' => 'مفضلاتي:',
    'LBL_GLOBAL_SEARCH' => 'بحث شامل',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => 'عامل تصفية وحدة البحث الشامل',
    'LBL_GLOBAL_SEARCH_RUN' => 'تشغيل بحث شامل',
    'LBL_GO_BUTTON_LABEL' => 'انتقال',
    'LBL_GS_HELP' => 'تظهر الحقول في هذه الوحدة المستخدمة في هذا البحث أعلاه.  يتطابق النص المميز مع معيار البحث لديك.',
    'LBL_HIDE' => 'إخفاء',
    'LBL_ID' => 'المعرّف',
    'LBL_IMPORT' => 'استيراد',
    'LBL_IMPORT_STARTED' => 'تم بدء الاستيراد: ',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'يجب تحديد محدد مخصص.',
    'LBL_LAST_VIEWED' => 'ما تم عرضه مؤخرًا',
    'LBL_SELECTED_RECORDS' => 'المحدد: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => 'عرض القليل',
    'LBL_SHOW_MORE' => 'عرض المزيد',
    'LBL_SHOW_MORE_MODULE' => 'المزيد{{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => 'المزيد من عمليات البحث الأخيرة...',
    'LBL_SHOW_LESS_RECENTS' => '...القليل من عمليات البحث الأخيرة',
    'LBL_SHOW_MORE_RESULTS' => 'المزيد من نتائج البحث...',
    'TPL_SHOW_MORE_MODULE' => 'مزيد من {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => '{{name}} أكثر...',
    'LBL_TODAYS_ACTIVITIES' => 'أنشطة اليوم',
    'LBL_LEADS' => 'العملاء المتوقعون',
    'LBL_LEAD' => 'العميل المتوقع',
    'LBL_QUOTES_BILL_TO' => 'عروض الأسعار (الدفع إلى)',
    'LBL_LESS' => 'أقل',
    'LBL_CAMPAIGN' => 'الحملة:',
    'LBL_CAMPAIGNS' => 'الحملات',
    'LBL_CAMPAIGNLOG' => 'سجل الحملة',
    'LBL_CAMPAIGN_CONTACT' => 'الحملات',
    'LBL_CAMPAIGN_ID' => 'معرّف_الحملة',
    'LBL_THEME' => 'السمة:',
    'LBL_THEME_PICKER' => 'نمط الصفحة',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => 'تحذير: Internet Explorer 6 لا يدعم السمة المحددة. انقر فوق "موافق" لتحديدها بأي حال من الأحوال أو "إلغاء" لتحديد موضوع آخر.',
    'LBL_FOUND_IN_RELEASE' => 'تم العثور عليه في الإصدار',
    'LBL_FIXED_IN_RELEASE' => 'تم التصحيح في الإصدار',
    'LBL_LIST_ACCOUNT_NAME' => 'اسم الحساب',
    'LBL_LIST_ASSIGNED_USER' => 'المستخدم',
    'LBL_LIST_CONTACT_NAME' => 'اسم جهة الاتصال',
    'LBL_LIST_CONTACT_ROLE' => 'دور جهة الاتصال',
    'LBL_LIST_DATE_ENTERED' => 'تاريخ الإنشاء',
    'LBL_LIST_EMAIL' => 'البريد الإلكتروني',
    'LBL_LIST_NAME' => 'الاسم',
    'LBL_LIST_OF' => 'من',
    'LBL_LIST_PHONE' => 'الهاتف',
    'LBL_LIST_RELATED_TO' => 'مرتبط بـ',
    'LBL_LIST_USER_NAME' => 'اسم المستخدم',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'هل تريد بالتأكيد تحديث القائمة بأكملها؟',
    'LBL_LISTVIEW_NO_SELECTED' => 'يرجى تحديد سجل 1 على الأقل للمتابعة.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'يرجى تحديد 2 سجل على الأقل للمتابعة.',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => 'يرجى تحديد أقل من 10 سجلات للمتابعة.',
    'LBL_LISTVIEW_ALL' => 'الكل',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => 'تجميد العمود 1',
    'LBL_DUPECHECK_FILTER_DEFAULT' => 'كل التكرارات',
    'LBL_LISTVIEW_NONE' => 'إلغاء تحديد الكل',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'حدد هذه الصفحة',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'تحديد الكل',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'سجلات محددة',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'المحدد: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => 'امسح كل التحديدات.',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => 'حدد كل السجلات',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => 'هناك أكثر من {{num}} سجلات في مجموعة النتائج. لقد اخترت السجلات {{num}} الأولى.',
    'TPL_LISTVIEW_SELECTED' => 'لقد حددت {{num}} السجلات في مجموعة النتائج.',
    'TPL_LISTVIEW_SELECTED_ONE' => 'لقد حددت سجلاً واحدًا في مجموعة النتائج.',
    'TPL_LISTVIEW_SELECTED_ALL' => 'لقد اخترت كل {{num}} السجلات في مجموعة النتائج.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => 'لقد اخترت كل {{num}} السجلات في هذا العرض. {{link}} في مجموعة النتائج.',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => 'يتم تحديث {{num}} من {{total}}',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(تقريبًا{{time}} {{unit}} اليسار)',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => 'فشل التحديث بأكمله. بدء محاولة جديدة ({{num}} لـ {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => 'التحديث بأكمله غير مكتمل. {{num}} لا يزال السجل (السجلات) بدون تغيير.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => 'التحديث بأكمله غير مكتمل. {{num}} لا يزال السجل (السجلات) بدون تغيير.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => 'تم تجاهل {{remain}} السجل (السجلات) بسبب الأذونات أو الأخطاء.',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}} تم تحديث السجل (السجلات) بنجاح.',
    'TPL_MASSUPDATE_TITLE' => '{{module}} تحديث شامل',
    'TPL_MASSDELETE_PROGRESS_STATUS' => 'يتم حذف {{num}} من {{total}}',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(تقريبًا{{time}} {{unit}} اليسار)',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => 'فشل الحذف بأكمله. بدء محاولة جديدة ({{num}} لـ {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => 'الحذف بأكمله غير مكتمل. {{num}} لا يزال السجل (السجلات).',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => 'الحذف بأكمله غير مكتمل. {{num}} لا يزال السجل (السجلات).',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} تم حذف السجل (السجلات) بنجاح.',
    'TPL_MASSDELETE_TITLE' => '{{module}} حذف بالكامل',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => 'إضافة{{num}}{{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(تقريبًا{{time}} {{unit}} اليسار)',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => 'فشلت الإضافة الكاملة لقائمة الأهداف. بدء محاولة جديدة ({{num}} لـ {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => 'الإضافة الكاملة لقائمة الأهداف غير مكتملة. {{num}} لم تتم إضافة السجلات.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => 'الإضافة الكاملة لقائمة الأهداف غير مكتملة. {{num}} لم تتم إضافة السجلات.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}} تمت إضافة السجلات بنجاح.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} الإضافة الكاملة لقائمة الأهداف',
    'TPL_MASSLINK_PROGRESS_STATUS' => 'ربط{{num}} {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(تقريبًا{{time}} {{unit}} اليسار)',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => 'فشل الرابط بأكمله. بدء محاولة جديدة ({{num}} لـ {{total}}).',
    'TPL_MASSLINK_WARNING_CLOSE' => 'الرابط بأكمله غير مكتمل. {{num}} لم تتم إضافة السجلات.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => 'الرابط بأكمله غير مكتمل. {{num}} لم تتم إضافة السجلات.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} تم ربط السجلات بنجاح.',
    'TPL_MASSLINK_TITLE' => '{{module}} رابط كامل',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => 'تحديد',
    'LBL_LISTVIEW_ACTIONS' => 'الإجراءات',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => 'تحديد كل السجلات في هذه الصفحة',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => 'إلغاء تحديد كل السجلات في هذه الصفحة',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} من {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => 'جارٍ تحميل {{num}}...',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => 'انقر للحصول على إجمالي',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => 'من',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => 'الحصول على عدد الصفحات',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'دافيد',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'ليفنجستون',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'دكتور',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Code Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => 'يرجى تسجيل الدخول للوصول لهذه المنطقة.',
    'LBL_LOGOUT' => 'تسجيل الخروج',
    'LBL_FINISH_IMPERSONATING' => 'إنهاء الانتحال',
    'LBL_RESET_MFA' => 'إعادة ضبط المصادقة متعددة العوامل',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}، أنت حاليًا تنتحل المستخدم {{user}}.',
    'LBL_PROFILE' => 'ملف التعريف',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'دمج البريد',
    'LBL_MASS_UPDATE' => 'تحديث شامل',
    'LBL_MASS_UPDATE_ALL_RECORDS' => 'تحديد كل السجلات للتحديث الشامل لها',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => 'تضمين السجل في التحديث الشامل',
    'LBL_MASS_UPDATE_ADD_FIELD' => 'إضافة حقل',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => 'إزالة حقل',
    'LBL_GENERATE_QUOTE' => 'إنشاء عرض سعر',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => 'لا توجد حقول متاحة لتشغيل التحديث بأكمله',
    'LBL_MASS_UPDATE_JOB_QUEUED' => 'تم وضع جدول زمني لطلب التحديث الكامل الخاص بك.',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => 'تاريخ بدء الخدمة يتجاوز تاريخ نهاية الخدمة',
    'LBL_MASS_UPDATE_SUCCESS' => 'تم تحديث كل السجلات بنجاح.',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => 'تمت إضافة السجلات المختارة إلى <a href="{{listUrl}}">{{listName}}</a> قائمة الأهداف.',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => 'تم وضع طلبك بإضافة السجلات المختارة <a href="{{listUrl}}">{{listName}}</a> لقائمة الأهداف في جدول زمني.',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => 'يقوم التحديث بمسح القيم التالية: ',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => 'الإلغاء للاحتفاظ بالقيم الموجودة. تأكيد لمسح القيم.',
    'LBL_OPT_OUT_FLAG_PRIMARY' => 'رفض البريد الإلكتروني الأساسي',
    'LBL_MEETINGS' => 'الاجتماعات',
    'LBL_MEETING' => 'الاجتماع',
    'LBL_MEETING_GO_BACK' => 'عودة إلى الاجتماع',
    'LBL_MEMBERS' => 'الأعضاء',
    'LBL_MEMBER_OF' => 'عضو في',
    'LBL_MODIFIED_BY_USER' => 'تم التعديل بواسطة المستخدم',
    'LBL_MODIFIED_USER' => 'تم التعديل بواسطة المستخدم',
    'LBL_MODIFIED' => 'تم التعديل بواسطة',
    'LBL_MODIFIED_NAME' => 'تم التعديل بواسطة',
    'LBL_MODIFIED_ID' => 'تم التعديل بواسطة المعرّف',
    'LBL_MORE' => 'المزيد',
    'LBL_MORE_MODULES' => 'المزيد من الوحدات',
    'LBL_MORE_TABS' => 'علامات تبويب أكثر',
    'LBL_MULTIPLE_MODULES' => 'وحدات نمطية متعددة',
    'LBL_COUNT_MODULES' => '{{count}} وحدات',
    'LBL_MY_ACCOUNT' => 'إعداداتي',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'إعداد افتراضي للنظام',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => 'افتراضي المستخدم',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => 'حساب المستخدم',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => 'حساب مجموعة',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => 'الاسم',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'إنشاء',
    'LBL_NEW_BUTTON_TITLE' => 'إنشاء',
    'LBL_NEXT_BUTTON_LABEL' => 'التالي',
    'LBL_NOTES' => 'ملاحظات',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'فتح الكل',
    'LBL_OPENALL_BUTTON_TITLE' => 'فتح الكل',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'فتح لـ: ',
    'LBL_OPENTO_BUTTON_TITLE' => 'فتح لـ:',
    'LBL_OPEN_IN_NEW_TAB' => 'فتح في علامة تبويب جديدة',
    'LBL_OPPORTUNITIES' => 'الفرص',
    'LBL_OPPORTUNITY_NAME' => 'اسم الفرصة',
    'LBL_OPPORTUNITY' => 'الفرصة',
    'LBL_OR' => 'أو',
    'LBL_LOWER_OR' => 'أو',
    'LBL_PANEL_ASSIGNMENT' => 'أخرى',
    'LBL_PANEL_ADVANCED' => 'مزيد من المعلومات',
    'LBL_PANEL_BODY' => 'نظرة عامة',
    'LBL_PARENT_TYPE' => 'نوع الأصل',
    'LBL_RELATED_TYPE' => 'النوع ذو الصلة',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => 'النطاق',
    'LBL_PICTURE_FILE' => 'أفاتار',
    'LBL_POSTAL_CODE' => 'الرمز البريدي:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'المدينة في العنوان الرئيسي:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'البلد في العنوان الرئيسي:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'الرمز البريدي في العنوان الرئيسي:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'الولاية في العنوان الرئيسي:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'الشارع في العنوان الرئيسي 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'الشارع في العنوان الرئيسي 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'الشارع في العنوان الرئيسي:',
    'LBL_PRIMARY_ADDRESS' => 'العنوان الرئيسي:',

    'LBL_BILLING_STREET' => 'الشارع:',
    'LBL_SHIPPING_STREET' => 'الشارع:',

    'LBL_PRODUCT_BUNDLES' => 'حِزم المنتج',
    'LBL_PRODUCTS' => 'المنتجات',
    'LBL_PROJECT_TASKS' => 'مهام المشروع',
    'LBL_PRODUCT_TEMPLATES' => 'قوالب المنتج',
    'LBL_PROJECTS' => 'المشروعات',
    'LBL_PROSPECTS' => 'الأهداف',
    'LBL_QUICK_CREATE_MENU' => 'قائمة الإنشاء السريع',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'إنشاء فرصة من عرض سعر',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'إنشاء فرصة من عرض سعر',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => 'خلق الفرصة...',
    'LBL_QUOTES_SHIP_TO' => 'شحن عروض السعر إلى',
    'LBL_QUOTES' => 'عروض الأسعار',

    'LBL_FORECAST_WORKSHEETS' => 'قوائم التوقعات',
    'LBL_FORECAST_WORKSHEET' => 'قائمه التوقعات',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => 'دعوة',
    'LBL_INVITED' => 'مدعو',
    'LBL_RECOMMENDED_INVITES' => 'الدعوات الموصى بها',
    'LBL_INSTANCES' => 'أمثلة',
    'LBL_YOUR_INSTANCES' => 'أمثلتك',
    'LBL_INSTANCE_USERS' => 'مثال للمستخدمين',
    'LBL_SWITCH_INSTANCE' => 'التحول لهذا المثال',
    'LBL_LAST_LOGIN' => 'آخر تسجيل دخول',
    'LBL_ENTER_EMAIL' => 'أدخل البريد الإلكتروني لاسم مدعو...',
    'LBL_INSTANCE_IN_USE' => 'مثال قيد الاستخدام',
    'LBL_INSTANCE_ACTIVE' => 'أنت تستخدم هذا المثال بالفعل!',
    'LBL_INSTANCE_INVITE_SENT' => 'تم إرسال الدعوة إلى',
    'LBL_INSTANCE_SWITCH_FAILED' => 'فشل تحويل الأمثلة',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => 'تذكيرات',
    'LBL_REMINDERS_OVERDUE' => 'متأخر',
    'LBL_REMINDERS_UPCOMING' => 'القادمة',
    'LBL_REMINDERS_NONE_FOUND' => 'لم يتم العثور على تذكيرات.',
    'LBL_REMINDERS_FINISHED' => 'انتهى!',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => 'قياسات الفرص',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'لوحة تكوين Sweet Spot',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => 'مفاتيح الاختصار',
    'LBL_SWEETSPOT_CONFIG_ERR' => 'فشل تحديث تفضيلات التكون: {{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'إجراء Sweet Spot',
    'LBL_SWEETSPOT_KEY' => 'الكلمة الرئيسية',
    'LBL_SWEETSPOT_REMOVE' => 'إزالة الإجراء',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => 'مفاتيح الاختصار',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => 'الإجراءات',
    'LBL_SWEETSPOT_RECORDS_SECTION' => 'السجلات',
    'LBL_SWEETSPOT_THEME' => 'السمة',
    'LBL_SWEETSPOT_THEME_SELECT' => 'تحديد موضوع',

    'LBL_RELATED' => 'مرتبط',
    'LBL_RELATED_INFORMATION' => 'المعلومات ذات الصلة',
    'LBL_RELATED_RECORDS' => '{{module}} المرتبطة',
    'LBL_REPORTS_TO' => 'تقارير إلى',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => 'يشير إلى حقل مطلوب',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => 'تم',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'حفظ باسم',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'حفظ باسم',
    'LBL_FULL_FORM_BUTTON_KEY' => 'L',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'نموذج كامل',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'نموذج كامل',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'حفظ وإنشاء جديد',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'حفظ وإنشاء جديد',
    'LBL_SAVE_OBJECT' => 'حفظ {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'بحث',
    'LBL_SEARCH_BUTTON_TITLE' => 'بحث',
    'LBL_SEARCH' => 'بحث',
    'LBL_SEARCH_TIPS' => 'اضغط زر البحث أو انقر enter للحصول على تطابق تام لها.',
    'LBL_SEARCH_TIPS_2' => 'اضغط زر البحث أو انقر enter للحصول على تطابق تام ',
    'LBL_SEARCH_MORE' => 'المزيد',
    'LBL_SEE_ALL' => 'مشاهدة الكل',
    'LBL_SEARCH_LOAD_MORE' => 'تحميل المزيد',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => 'تنسيق ملف غير صالح، يمكن تحميل ملف صورة فقط.',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => 'لم يعد تنسيق الصورة {0} مدعومًا.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'تحديد',
    'LBL_SELECT_BUTTON_TITLE' => 'تحديد',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => 'إضافة فريق (فرق)',
    'LBL_SELECT_TEAMS_TITLE' => 'إضافة فريق (فرق)',
    'LBL_SELECT_APPEND_TEAMS' => 'إلحاق فريق (فرق)',
    'LBL_SELECT_APPEND_VALUES' => 'إلحاق قيمة (قيم)',
    'LBL_SELECT_APPEND_TAGS' => 'إلحاق (العلامة (العلامات))',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'استعراض مستندات',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'استعراض مستندات',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'تحديد جهة اتصال',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'تحديد جهة اتصال',
    'LBL_GRID_SELECTED_FILE' => 'ملف محدد',
    'LBL_GRID_SELECTED_FILES' => 'ملفات محددة',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'حدد من التقارير',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'حدد التقارير',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'تحديد مستخدم',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'تحديد مستخدم',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => 'مسح التحديدات',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => 'مسح التحديدات',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => 'مسح التحديدات',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => 'مسح التحديدات',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => 'تحديد ملف',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => 'تحديد ملف',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => 'مسح ملف',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => 'مسح ملف',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => 'تحديد مستخدم',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => 'تحديد مستخدم',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => 'مسح مستخدم',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => 'مسح مستخدم',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => 'تحديد حساب',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => 'تحديد حساب',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => 'مسح حساب',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => 'مسح حساب',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => 'تحديد حملة',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => 'تحديد حملة',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => 'مسح حملة',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => 'مسح حملة',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => 'تحديد جهة اتصال',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => 'تحديد جهة اتصال',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => 'مسح جهة اتصال',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => 'مسح جهة اتصال',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => 'تحديد فريق',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => 'تحديد فريق',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => 'مسح فريق',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => 'مسح فريق',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'الموارد المستخدمة لإنشاء هذه الصفحة (استعلامات، ملفات)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'ثوانٍ.',
    'LBL_SERVER_RESPONSE_TIME' => 'وقت استجابة الخادم:',
    'LBL_SERVER_MEMORY_BYTES' => 'بايت',
    'LBL_SERVER_MEMORY_USAGE' => 'استخدام ذاكرة الخادم: {0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => 'الاستخدام: - الوحدة: {0} - الإجراء: {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => 'استخدام الذاكرة القصوى للخادم: {0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => 'شحن إلى حساب',
    'LBL_SHIP_TO_CONTACT' => 'شحن إلى جهة اتصال',
    'LBL_SHIPPING_ADDRESS' => 'عنوان الشحن',
    'LBL_SHORTCUTS' => 'اختصارات',
    'LBL_SHOW' => 'إظهار',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'الولاية:',
    'LBL_STATUS_UPDATED' => 'تم تحديث حالتك لهذا الحدث!',
    'LBL_STATUS_NOT_UPDATED' => 'لم يتم تحديث حالتك لهذا الحدث.',
    'LBL_STATUS' => 'الحالة:',
    'LBL_STREET' => 'الشارع',
    'LBL_SUBJECT' => 'الموضوع',

    'LBL_INBOUNDEMAIL_ID' => 'معرّف البريد الإلكتروني الداخلي',
    'LBL_EAMP_ID' => 'معرّف الرمز المميز للمصادقة',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        'جميع الحقوق محفوظة.<br /> إن SugarCRM، وSugar و3-D Cube هي علامات تجارية مسجلة خاصة بشركة SugarCRM Inc. ' .
        'جميع الشركات وأسماء المنتجات الأخرى المستخدمة أو تلك التي تظهر في هذا المنتج هي علامات تجارية خاصة ' .
        'بالشركات التابعة لها والمشتركة معها.',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => 'الوظائف المجدولة التي تم إكمالها',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => 'تم تشغيل الوظيفة المجدولة بنجاح',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => 'تم الآن تمكين بنود العائدات في مثيل Sugar الخاص بك',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => 'تم الآن تمكين بنود العائدات في مثيل Sugar الخاص بك، وكل بيانات الفرصة الحالية تمت معالجتها. المثيل الخاص بك جاهز الآن للاستخدام مع بنود العائدات. للحصول على المزيد من المعلومات حول التغييرات التي تم إجراؤها، الرجاء الرجوع إلى {{doc_url}}.<br /><br />مع أرق الأمنيات، SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => 'وحدة التوقعات جاهزة الآن للاستخدام مع الفرص في مثيل Sugar الخاص بك',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'وحدة التوقعات في مثيل Sugar الخاص بك جاهزة الآن للاستخدام مع الفرص. وكل بيانات تثبيت عنصر سطر الإيرادات السابقة تمت إزالتها، والمثيل جاهز لإنشاء وتثبيت التوقعات مع الفرص. للحصول على المزيد من المعلومات حول التغييرات التي تم إجراؤها، الرجاء الرجوع إلى {{doc_url}}. <br /><br /><br />مع أرق الأمنيات، SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => 'تم الآن تعطيل بنود العائدات في مثيل Sugar الخاص بك',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => 'تم الآن تعطيل بنود العائدات في مثيل Sugar الخاص بك، وكل بيانات بنود العائدات الحالية تمت معالجتها. المثيل الخاص بك جاهز الآن للاستخدام مع الفرص. للحصول على المزيد من المعلومات حول التغييرات التي تم إجراؤها، الرجاء الرجوع إلى {{doc_url}}.<br /><br /><br />مع أرق الأمنيات، SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => 'وثائق تكوين الفرص',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => 'تسجيل الدخول',
    'LBL_LOGIN_WELCOME_TO' => 'مرحبًا بك في',
    'LBL_LOGIN_OPTIONS' => 'الخيارات',
    'LBL_LOGIN_FORGOT_PASSWORD' => 'نسيت كلمة المرور؟',
    'LBL_LOGIN_SUBMIT' => 'إرسال',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => 'محاولات تسجيل دخول فاشلة كثيرة للغاية.',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => 'يمكنك محاولة تسجيل الدخول ثانية خلال ',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => 'أيام.',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => 'س',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => 'دق',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => 'ث',
    'LBL_LOGIN_ADMIN_CALL' => 'يُرجى الاتصال بمسؤول النظام.',
    'LBL_LOGIN_USERNAME' => 'اسم المستخدم',
    'LBL_LOGIN_PASSWORD' => 'كلمة المرور',
    'LBL_LOGGED_OUT' => 'لقد تم تسجيل خروجك.',
    'LBL_LOGIN_FORM_LABEL' => 'اعرض استمارة تسجيل الدخول',
    'LBL_RETURN_TO_LOGIN_PAGE' => 'العودة إلى تسجيل الدخول',
    'LBL_LOGIN_INACTIVE_USER' => 'مستخدم غير نشط',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => 'لا يمكن تسجيل دخول مستخدم البوابة أو المجموعة.',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => 'لوحة المعلومات',
    'LBL_SYNC' => 'مزامنة',
    'LBL_TASKS' => 'المهام',
    'LBL_TEAMS_LINK' => 'الفرق',
    'LBL_THEME_COLOR' => 'اللون',
    'LBL_THEME_FONT' => 'الخط',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => 'جدولة اجتماع',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => 'جدولة اجتماع',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'أرشيف البريد الإلكتروني',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'أرشيف البريد الإلكتروني',
    'LBL_UNAUTH_ADMIN' => 'دخول غير مسموح به للإدارة',
    'LBL_UNDELETE_BUTTON_LABEL' => 'إلغاء حذف',
    'LBL_UNDELETE_BUTTON_TITLE' => 'إلغاء حذف',
    'LBL_UNDELETE_BUTTON' => 'إلغاء حذف',
    'LBL_UNDELETE' => 'إلغاء حذف',
    'LBL_UNSYNC' => 'إلغاء مزامنة',
    'LBL_UPDATE' => 'تحديث',
    'LBL_UPDATES' => 'التحديثات',
    'LBL_USER_LIST' => 'قائمة المستخدمين',
    'LBL_USER_MENU' => 'قائمة المستخدمين',
    'LBL_USERS_SYNC' => 'مزامنة المستخدمين',
    'LBL_USERS' => 'المستخدمون',
    'LBL_USER' => 'المستخدم',
    'LBL_CURRENT_USER' => 'المستخدم الحالي',
    'LBL_VERIFY_EMAIL_ADDRESS' => 'يتم الآن التحقق من إدخال البريد الإلكتروني الحالي...',
    'LBL_VERIFY_PORTAL_NAME' => 'يتم الآن التحقق من اسم المنفذ الحالي...',
    'LBL_VIEW_IMAGE' => 'عرض',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'طباعة كـ PDF',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'طباعة كـ PDF',

    'LBL_KBDOCUMENTS' => 'قاعدة المعارف',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => 'نبذة عن',
    'LNK_ADVANCED_SEARCH' => 'بحث متقدم',
    'LNK_BASIC_SEARCH' => 'بحث رئيسي',
    'LNK_SEARCH_NO_RESULTS' => 'لم يتم العثور على نتائج.',
    'LNK_SEARCH_FTS_VIEW_ALL' => 'عرض كل النتائج',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => 'إظهار الكل',
    'LNK_CLOSE' => 'إغلاق',
    'LBL_MODIFY_CURRENT_SEARCH' => 'تعديل البحث الحالي',
    'LNK_SAVED_VIEWS' => 'خيارات التخطيط',
    'LNK_DELETE_ALL' => 'حذف الكل',
    'LNK_DELETE' => 'حذف',
    'LNK_EDIT' => 'تحرير',
    'LNK_VIEW' => 'عرض',
    'LNK_GET_LATEST' => 'الحصول على الأحدث',
    'LNK_GET_LATEST_TOOLTIP' => 'الاستبدال بالإصدار الأحدث',
    'LNK_HELP' => 'تعليمات',
    'LNK_CREATE' => 'إنشاء',
    'LNK_CREATE_WHEN_EMPTY' => 'إنشاء سجل الآن.',
    'LNK_LIST_END' => 'النهاية',
    'LNK_LIST_NEXT' => 'التالي',
    'LNK_LIST_PREVIOUS' => 'السابق',
    'LNK_LIST_RETURN' => 'العودة للقائمة',
    'LNK_LIST_START' => 'البدء',
    'LNK_LOAD_SIGNED' => 'علامة',
    'LNK_LOAD_SIGNED_TOOLTIP' => 'الاستبدال بمستند موقع عليه',
    'LNK_PRINT' => 'طباعة',
    'LNK_BACKTOTOP' => 'العودة لأعلى',
    'LNK_REMOVE' => 'إزالة',
    'LNK_RESUME' => 'استئناف',
    'LNK_VIEW_CHANGE_LOG' => 'عرض سجل التدقيق',
    'TPL_AUDIT_LOG_TITLE' => 'سجل التدقيق لـ {{{name}}}',
    'LBL_AUDIT_EMAIL_TOOLTIP' => 'انقر لعرض سجل تدقيق عنوان البريد الإلكتروني',
    'LBL_NO_SEARCH_RESULTS' => 'لم يتم العثور على نتائج لبحثك',
    'NTC_CLICK_BACK' => 'يرجى النقر فوق الزر السابق في المستعرض وإصلاح الخطأ.',
    'NTC_DATE_FORMAT' => '(yyyy-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(yyyy-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'هل تريد بالتأكيد حذف السجل (السجلات) المحددة؟',
    'NTC_TEMPLATE_IS_USED' => 'القالب مستخدم في سجل تسويق بريد إلكتروني واحد على الأقل. هل تريد بالتأكيد حذفه؟',
    'NTC_TEMPLATES_IS_USED' => "يتم استخدام القوالب التالية في سجلات تسويق البريد الإلكتروني. هل تريد بالتأكيد حذفها؟\n",
    'NTC_DELETE_CONFIRMATION' => 'هل تريد بالتأكيد حذف هذا السجل؟',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => 'هل تريد بالتأكيد حذف {0}؟',
    'LBL_METRIC_DELETE_WARNING' => 'سوف يفقد أيضًا أي مستخدمين تمت مشاركة هذا القياس معهم الوصول.',
    'NTC_DELETE_CONFIRMATION_NUM' => 'هل تريد بالتأكيد حذف  ',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'هل تريد بالتأكيد تحديث ',
    'NTC_DELETE_SELECTED_RECORDS' => ' سجل (سجلات) محددة؟',
    'LBL_DELETE_FILTER_CONFIRMATION' => 'ستتم إزالة عامل التصفية هذا من كل العروض، وقد يشمل ذلك تهيئة البيانات للشرط. هل تريد بالتأكيد حذف عامل التصفية هذا؟',
    'TPL_DELETE_FILTER_SUCCESS' => 'لقد حذفت عامل التصفية {{name}}.',
    'NTC_DELETE_SUCCESS' => 'لقد حذفت {0}.',
    'NTC_UNLINK_CONFIRMATION' => 'هل تريد بالتأكيد إلغاء رابط هذا السجل؟',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => 'هل تريد بالتأكيد إلغاء رابط {0}؟',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => 'هل تريد بالتأكيد إلغاء ارتباط {0}؟ سيؤدي هذا إلى إزالته أيضًا من حقل "جهة الاتصال الرئيسية" للحالة.',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => 'لا يمكن إلغاء ارتباط {0} لأنه جهة اتصال رئيسية لهذه الحالة. قم بتحديث حقل "جهة الاتصال الرئيسية" قبل إلغاء ربط هذا السجل.',
    'NTC_UNLINK_SUCCESS' => 'لقد ألغيت رابط {0}.',
    'NTC_LOGIN_MESSAGE' => 'يرجى إدخال اسم المستخدم وكلمة المرور الخاصة بك.',
    'NTC_NO_ITEMS_DISPLAY' => 'بلا',
    'NTC_REMOVE_CONFIRMATION' => 'هل تريد بالتأكيد حذف علاقة هذه العلاقة؟ سيتم حذف العلاقة فقط. لن يتم حذف السجل.',
    'NTC_REQUIRED' => 'يشير إلى حقل مطلوب',
    'NTC_SUPPORT_SUGARCRM' => 'دعم مشروع SugarCRM مفتوح المصدر بتبرع من خلال PayPal - فهو سريع، ومجاني، وآمن!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'مرحبًا',
    'NTC_YEAR_FORMAT' => '(yyyy)',
    'LOGIN_LOGO_ERROR' => 'يرجى استبدال شعارات SugarCRM.',
    'FATAL_LICENSE_ALTERED' => 'لقد تغيرت رخصتك منذ آخر مرة كانت سارية.',
    'ERROR_FULLY_EXPIRED' => "لقد انتهت صلاحية رخصة شركتك بالنسبة لـ SugarCRM لأكثر من 7 أيام وتحتاج إلى تحديثها. تسجيل الدخول لمسؤولي النظام فقط.",
    'ERROR_LICENSE_EXPIRED' => "تحتاج رخصة شركتك لـ SugarCRM للتحديث. تسجيل الدخول لمسؤولي النظام فقط.",
    'WARN_LICENSE_EXPIRED' => "ستنتهي رخصة شركتك لـ SugarCRM قريبًا.",
    'ERROR_LICENSE_VALIDATION' => "تحتاج رخصة شركتك لـ SugarCRM إلى تحديث صلاحيتها. تسجيل الدخول لمسؤولي النظام فقط.",
    'WARN_LICENSE_VALIDATION' => "تحتاج رخصة شركتك لـ SugarCRM إلى تحديث صلاحيتها قريبًا.",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>تحذير:</b> مستعرضك متوافق في عرض IE غير مدعوم.',
    'WARN_LICENSE_SEATS' => 'تحذير: عدد المستخدمين النشطاء هو الحد الأقصى للعدد المسموح به بالفعل للتراخيص.',
    'WARN_LICENSE_SEATS_MAXED' => 'تحذير: عدد المستخدمين النشطاء يتجاوز الحد الأقصى للعدد المسموح به بالفعل للتراخيص.',
    'ERROR_LICENSE_SEATS_MAXED' =>
        'عدد المستخدمين النشطين يتجاوز حد عدد التراخيص. الرجاء الاتصال بالمسؤول.',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => 'تسجيل الدخول للمسؤولين فقط.',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        'تم الوصول إلى حد عدد تراخيص المستخدمين. تسجيل الدخول للمستخدمين الحاليين فقط.',
    'WARN_ONLY_ADMINS' => 'تسجيل الدخول للمسؤولين فقط.',
    'WARN_UNSAVED_CHANGES' => 'أنت على وشك مغادرة هذا السجل بدون حفظ أي تغييرات قد أجريتها على السجل. هل تريد بالتأكيد الانتقال بعيدًا عن هذا السجل؟',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'يؤدي تحديث المستعرض إلى الإغلاق التلقائي لكل مكالمات أو جلسات دردشة SugarLive المفتوحة لديك وسيتم فقد أي تغييرات غير محفوظة. هل تريد المتابعة؟',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => 'لم يتم حفظ التغييرات. هل تريد بالتأكيد مغادرة الصفحة وتجاهل التغييرات؟',
    'LBL_MFA_RESET_CONFIRMATION' => 'هل تريد بالتأكيد إعادة ضبط <a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">المصادقة متعددة العوامل</a>؟ 
سيؤدي تنفيذ هذا الإجراء إلى تسجيل خروجك على الفور، وستحتاج إلى إعادة المصادقة باستخدام تطبيق التصديق في المرة التالية التي ستسجل فيها الدخول.',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => 'تأكيد وتسجيل الخروج',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => 'لوحة معلومات واحدة أو أكثر تتضمن تغييرات غير محفوظة. هل تريد بالتأكيد إغلاق الرسام؟',
    'LBL_NAVIGATE_TO_REPORTS' => 'أنت تنتقل لوحدة "التقارير". لن يتم حفظ تغييراتك على لوحة المعلومات. متابعة؟',
    'ERROR_NO_RECORD' => 'خطأ في استرداد السجل.  قد يتم حذف هذا السجل أو أنك غير مسموح لك بمشاهدته.',
    'ERROR_TYPE_NOT_VALID' => 'خطأ. هذا النوع غير مدعوم.',
    'ERROR_MAX_FIELD_LENGTH' => 'خطأ. أقصى طول لهذا الحقل هو {{this}}.',
    'ERROR_MIN_FIELD_LENGTH' => 'خطأ. أقل طول لهذا الحقل هو {{this}}.',
    'ERROR_EMAIL' => 'خطأ. عنوان البريد الإلكتروني غير صالح: {{#each this}}{{{this}}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => 'خطأ. يجب ضبط عنوان أساسي واحد على الأقل.',
    'ERROR_DUPLICATE_EMAIL' => 'خطأ. عنوان البريد الإلكتروني مكرر: {{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => 'خطأ. هذا الحقل مطلوب.',
    'ERROR_MINVALUE' => 'خطأ. أقل قيمة لهذا الحقل هي {{this}}.',
    'ERROR_MAXVALUE' => 'خطأ. أقصى قيمة لهذا الحقل هي {{this}}.',
    'ERROR_IS_GREATER_THAN' => 'خطأ. يجب أن تكون قيمة هذا الحقل أكبر من {{this}}.',
    'ERROR_IS_LESS_THAN' => 'خطأ. يجب أن تكون قيمة هذا الحقل أقل من {{this}}.',
    'ERROR_DATETIME' => 'خطأ. يحتاج هذا الحقل إلى تاريخ صالح.',
    'ERROR_IS_BEFORE' => 'خطأ. لا يمكن أن يكون تاريخ هذا الحقل بعد تاريخ الحقل {{this}}.',
    'ERROR_IS_AFTER' => 'خطأ. لا يمكن أن يكون تاريخ هذا الحقل قبل تاريخ الحقل {{this}}.',
    'ERROR_TIME_IS_BEFORE' => 'خطأ. يجب أن يكون وقت هذا الحقل قبل وقت حقل {{this}}.',
    'ERROR_TIME_IS_AFTER' => 'خطأ. يجب أن يكون وقت هذا الحقل بعد وقت حقل {{this}}.',
    'ERROR_NUMBER' => 'خطأ. يحتاج هذا الحقل إلى رقم صالح.',
    'ERROR_INT' => 'خطأ: عدد صحيح غير صالح.',
    'ERROR_URL' => 'خطأ: عنوان URL غير صالح.',
    'ERROR_NO_BEAN' => 'فشل الحصول على حبوب الفول.',
    'ERROR_ACCESS_MODULE' => 'لا يوجد لديك حق الوصول إلى هذه الوحدة.',
    'ERROR_MAX_FILESIZE_EXCEEDED' => 'خطأ. المرفق كبير للغاية.',
    'ERROR_UPLOAD_FAILED' => 'خطأ. فشل تحميل الملف.',
    'ERROR_UPLOAD_ACCESS_PD' => 'ليس لديك الإذن لإنشاء [تعريفات المعالجة] لهذه الوحدة.',
    'ERROR_UPLOAD_ACCESS_BR' => 'ليس لديك الإذن لإنشاء [قواعد الأعمال] لهذه الوحدة.',
    'ERROR_UPLOAD_ACCESS_ET' => 'ليس لديك الإذن لإنشاء [قوالب البريد الإلكتروني] لهذه الوحدة.',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => 'خطأ. قمت بإدخال مشغل غير مدعوم.',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => 'خطأ. قمت بإدخال مشغل غير صالح.',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => 'خطأ. قمت بإدخال عامل تصفية غير صالح.',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => 'فشل الاستيراد. يوجد حقل مقفل في إحدى المجموعات داخل تعريف العملية.' .
        ' يجب إلغاء قفل هذه الحقول في تعريف العملية لكي يتم استيراد التعريف.',
    'ERROR_EXP_DATE_LOW' => 'خطأ. لا يمكن أن يكون تاريخ الانتهاء قبل تاريخ النشر.',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => 'خطأ. يتطلب وضع الموافقة تاريخ النشر.',
    'ERROR_ACTIVE_DATE_EMPTY' => 'تاريخ النشر فارغ.',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => 'ابحث عن التكرارات',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => 'تم تعطيل الفحص المكرر لـ {{module}}.',
    'LBL_MANAGE_SUBSCRIPTIONS' => 'إدارة الاشتراكات',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => 'إدارة الاشتراكات لـ ',
    'LBL_SUBSCRIBE' => 'الاشتراك',
    'LBL_UNSUBSCRIBE' => 'إلغاء الاشتراك',
    'LBL_CREATE_LINK_RECORD' => 'إنشاء وربط سجل',
    'LBL_CREATE_LINK_BUTTON_LABEL' => 'إنشاء وربط سجل',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} تم ربط السجلات.',
    'LBL_LINK_FROM_REPORT_NO_DATA' => 'لا توجد سجلات للربط.',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => 'التقرير المحدد ليس قائمًا على نوع الوحدة الصحيح.',
    'ERROR_EMPTY_LINK_MODULE' => 'يرجى تحديد العلاقة أولاً.',
    // Ajax status strings
    'LBL_LOADING' => 'يتم الآن التحميل...',
    'LBL_LOADING_NO_DOTS' => 'تحميل',
    'LBL_SEARCHING' => 'يتم الآن البحث...',
    'LBL_SEARCH_UNDERWAY' => 'البحث',
    'LBL_SAVING_LAYOUT' => 'يتم الآن حفظ المخطط...',
    'LBL_SAVED_LAYOUT' => 'تم حفظ المخطط.',
    'LBL_SAVED' => 'محفوظ',
    'LBL_SAVING' => 'حفظ',
    'LBL_FAILED' => 'فشل!',
    'LBL_DISPLAY_COLUMNS' => 'عرض الأعمدة',
    'LBL_HIDE_COLUMNS' => 'إخفاء أعمدة',
    'LBL_SEARCH_CRITERIA' => 'معيار البحث',
    'LBL_SAVED_VIEWS' => 'عروض محفوظة',
    'LBL_PROCESSING_REQUEST' => 'تتم المعالجة الآن...',
    'LBL_REQUEST_PROCESSED' => 'تم',
    'LBL_AJAX_FAILURE' => 'فشل Ajax',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => 'بحث...',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'عمليات البحث المحفوظة',
    'LBL_SEARCH_POPULATE_ONLY' => 'إجراء بحث باستخدام استمارة البحث أعلاه',
    'LBL_SEARCH_NO_RESULTS' => 'لم يتم العثور على نتائج لـ ',
    'LBL_SEARCH_FOR' => 'البحث عن ',
    'LBL_SEARCH_FOR_MORE' => 'البحث عن المزيد...',
    'LBL_SEARCH_SELECT' => 'تحديد...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => 'البحث والتحديد...',
    'LBL_SEARCH_SELECT_MODULE' => 'تحديد {{module}}...',
    'LBL_DETAILVIEW' => 'عرض التفاصيل',
    'LBL_LISTVIEW' => 'عرض القائمة',
    'LBL_EDITVIEW' => 'تعديل العرض',
    'LBL_SEARCHFORM' => 'استمارة البحث',
    'LBL_SAVED_SEARCH_ERROR' => 'يرجى تقديم اسم لهذا العرض.',
    'LBL_DISPLAY_LOG' => 'سجل العرض',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'الموقع: ',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'الوصف: ',
    'MSG_JS_ALERT_MTG_REMINDER_START' => 'البداية',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => 'انقر فوق "موافق" لعرض هذا الاتصال، أو انقر فوق "إلغاء" لإلغاء هذه الرسالة.',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => 'انقر فوق "موافق" لعرض هذا الاجتماع أو انقر فوق "إلغاء" لإلغاء هذه الرسالة.',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => 'لم يتم العثور على نتائج.',
    'MSG_LIST_VIEW_NO_RESULTS' => 'لم يتم العثور على نتائج لـ <item1>',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => 'إنشاء <item1> جديد <item2>',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => 'ليس لديك حاليًا سجلات محفوظة. <item2> أو<item3> واحدة الآن.',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => 'ليس لديك حاليًا سجلات محفوظة. <item2> واحد الآن.',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => 'يمكنك إنشاء <item1> من قائمة <item2>.<item3> <item2>.',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => 'إيجابي',
    'LBL_SENTIMENT_NEUTRAL' => 'محايد',
    'LBL_SENTIMENT_NEGATIVE' => 'سلبي',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => 'لم يتم تكوين علامات تبويب قياس',
    'LBL_NO_METRIC_VISIBLE' => 'لا توجد علامات تبويب مترية مرئية',
    'LBL_MAKE_METRIC_VISIBLE' => 'اختر "تنظيم" لجعل علامات التبويب المترية مرئية',
    'LBL_PLEASE_CONTACT_ADMIN' => 'يُرجى الاتصال بالمسؤول',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => 'انقر هنا',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'إضافة إلى مفضلاتي',
    'LBL_MARK_AS_FAVORITES' => 'ضع علامة عليها كمفضلة',
    'LBL_CREATE_CONTACT' => 'إنشاء جهة اتصال',
    'LBL_CREATE_NOTE' => 'إنشاء ملاحظة',
    'LBL_CREATE_OPPORTUNITY' => 'إنشاء فرصة',
    'LBL_SCHEDULE_CALL' => 'سجل المكالمات',
    'LBL_SCHEDULE_CALL2' => 'المكالمة',
    'LBL_SCHEDULE_MEETING' => 'جدولة اجتماع',
    'LBL_SCHEDULE_MEETING2' => 'الاجتماع',
    'LBL_CREATE_MESSAGE' => 'إنشاء رسالة',
    'LBL_CREATE_MESSAGE2' => 'الرسالة',
    'LBL_CREATE_TASK' => 'إنشاء مهمة',
    'LBL_CREATE_TASK2' => 'المهمة',
    'LBL_REMOVE_FROM_FAVORITES' => 'الإزالة من مفضلاتي',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => 'الملاحظة',
    'LBL_DOWNLOAD_ALL' => 'تنزيل الكل',
    'LBL_DOWNLOAD_ONE' => 'تنزيل',
    'LBL_ATTACHMENTS' => 'المرفقات',
    'LBL_ADD_ATTACHMENT' => 'استعراض',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'إنشاء نموذج',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => 'حفظ شبكة لنموذج العميل المتوقع',

    'LBL_PLEASE_SELECT' => 'يُرجى تحديد',
    'LBL_REDIRECT_URL' => 'إعادة توجيه URL',
    'LBL_RELATED_CAMPAIGN' => 'الحملة المرتبطة',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'إضافة كل الحقول',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'إزالة كل الحقول',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'يمكن تضمين المرفقات التالية المدعوم فيها نوع الصورة فقط: JPG، PNG.',
    'LBL_REMOVE' => 'إزالة',
    'LBL_TRAINING' => 'دعم',
    'ERR_DATABASE_CONN_DROPPED' => 'خطأ في تنفيذ استعلام. هناك احتمال لإسقاط قاعدة بياناتك الاتصال. يُرجى تحديث هذه الصفحة، قد تحتاج إلى إعادة تشغيل خادم الشبكة الخاص بك.',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => 'خطأ إعداد {0} العلاقة: {1}',
    'ERR_MSSQL_DB_CONTEXT' => 'تم تغيير مضمون قاعدة البيانات إلى',
    'ERR_MSSQL_WARNING' => 'تحذير:',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => 'فشل في تنسيق توزيع vCard',
    'ERR_VCARD_FILE_MISSING' => 'ملف vcf مفقود',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'تحذير: الحقل [[field]] ليس له إدخال مخطط في ملف [moduleDir] vardefs.php',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'خطأ: الملف[[file]] مفقود.  غير قادر على الإنشاء بسبب عدم العثور على ملف HTML المقابل.',
    'ERR_CANNOT_FIND_MODULE' => 'خطأ: لم يتم العثور على وحدة [module].',
    'LBL_ALT_ADDRESS' => 'عنوان آخر:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'خطأ: هناك عدد غير متساوٍ من الوسائط بالنسبة إلى عناصر &#39;key&#39; و &#39;copy&#39; في صفيف معلمات الشاشة.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'فهرس مفقود في صفيف معلمات الشاشة لـ: ',

    'LBL_DASHLET' => 'لوحة المعلومات',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'عوامل التصفية',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'العناصر الخاصة بي فقط',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'العنوان',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'عرض الصفوف',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => 'مرتبط بالسجل الحالي',
    'LBL_DASHLET_CONFIGURE_LINKED' => 'حقل مربوط',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => 'تجميد العمود الأول',

    'LBL_REMOVE_DASHLET_CONFIRM' => 'هل تريد بالتأكيد حذف لوحة معلومات Sugar؟',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => 'هل تريد بالتأكيد حذف الصف؟',
    'LBL_MAXIMUM_OF' => 'أقصى من ',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => ' يمكن عرض الأعمدة.',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => 'لوحة المعلومات',
    'LBL_DEFAULT_DASHBOARD_TITLE' => 'لوحة المعلومات الخاصة بي',
    'LBL_COLLAPSE_ALL' => 'طي الكل',
    'LBL_EXPAND_ALL' => 'توسيع الكل',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => 'تحرير',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => 'عرض التقرير',
    'LBL_DASHLET_REFRESH_LABEL' => 'تحديث',
    'LBL_DASHLET_REMOVE_LABEL' => 'إزالة',
    'LBL_DASHLET_DROP_HERE' => 'الإسقاط هنا',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => 'إغلاق',
    'LBL_DASHLET_MAXIMIZE' => 'فتح',
    'LBL_DASHLET_CONFIGURE' => 'تهيئة',
    'LBL_DASHLET_TOGGLE' => 'فتح/إغلاق',
    'LBL_SIDEPANE_TOGGLE' => 'فتح/إغلاق اللوحة الجانبية',
    'LBL_RESTORE_DEFAULT_DASHLETS' => 'استعادة لوحات المعلومات الافتراضية',
    'LBL_NO_DASHBOARD_CONFIGURED' => 'لم يتم تكوين لوحة معلومات',
    'LBL_CREATE_DASHBOARD_LINK' => 'إنشاء لوحة معلومات',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => 'تعليمات',
    'LBL_HELPLET_TOGGLE' => 'فتح/إغلاق',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => 'الوحدات',
    'LBL_FACET_MODIFIED_BY_ME' => 'ما قمت أنا بتعديله',
    'LBL_FACET_CREATED_BY_ME' => 'تم الإنشاء بواسطتي',
    'LBL_FACET_MY_FAVORITES' => 'مفضلاتي',
    'LBL_FACET_ASSIGNED_TO_ME' => 'ما تم تعيينه لي',
    'LBL_FACET_NO_DATA' => 'لا توجد بيانات لهذا الجانب.',

    'LBL_DASHLET_LISTVIEW_NAME' => 'عرض القائمة',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => 'سجلات القوائم من وحدة معينة وفقًا للمعيار الذي تحدده.',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => 'طريق عرض قائمة وحدة التحكم',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => 'تعرض سجلات من وحدة معينة ترتبط بالسجل الذي تشاهده في لوحة التحكم.',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => 'عرض السجل',
    'LBL_RELATED_RECORDS' => '{{{module}}} المرتبطة',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => 'تعرض سجلاً والسجلات المرتبطة به اختياريًا في علامات تبويب.',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => 'نوع السجل الأساسي',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => 'هذه {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => 'علامات التبويب',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => 'معاينة التخطيط الأساسي',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => 'تحذير، فقط الوحدات {{numWord}} ({{num}}) هي التي يمكن عرضها في علامات تبويب. ' .
        'الرجاء إزالة وحدة واحدة أو أكثر قبل إضافة أي وحدة أخرى.',
    'LBL_SIX' => 'ستة', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => 'سجل التعليقات',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => 'يعرض التعليقات لسجل',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => 'لا تتوفر تعليقات',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => 'إضافة',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => 'إضافة تعليق',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => 'عرض الكل',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => 'البيانات غير متوفرة. ليس لديك إذن للوصول إلى هذه الوحدات.' .
    " \nيُرجى تحديث أو إزالة dashlet هذا.",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => 'جهات الاتصال {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => 'لم يتم تحديد سجل للعرض',
    'LBL_CONTENT_SEARCH_DASHLET' => 'لوحة معلومات بحث المحتوى',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => 'ما الذي يمكننا مساعدتك فيه اليوم، {{username}}؟',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => 'هل ترغب في إنشاء حالة؟',

    'LBL_DASHLET_OPPORTUNITY_NAME' => 'قياسات الفرص',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => 'قياسات الفرص للحساب ذو الصلة.',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => 'الاختيارات السريعة لكتالوج المنتج',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => 'تسرد العناصر والمنتحات المستخدمة مؤخرًا المحفوظة كمفضلات',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => 'المستخدمة مؤخرًا',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => 'المفضلة',

    'LBL_DASHBOARD_CREATE' => 'إنشاء لوحة معلومات',
    'LBL_DASHBOARD_DUPLICATE' => 'نسخ لوحة المعلومات',
    'LBL_DASHBOARD_DELETE' => 'حذف لوحة المعلومات',
    'LBL_PIN_TO_TOP' => 'تثبيت في الأعلى',
    'LBL_PIN_TO_BOTTOM' => 'تثبيت في الأسفل',
    'LBL_MANAGE_DASHBOARDS' => 'إدارة لوحات المعلومات',

    'LBL_DASHBOARD_CONFIG' => 'تكوين لوحة المعلومات',
    'LBL_LIST_VIEW__NAME' => 'عرض القائمة',
    'LBL_PIPELINE_VIEW_NAME' => 'عرض التجانب',
    'LBL_PIPELINE_VIEW_BTN' => 'عرض التجانب',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '{{module}} حسب {{fieldName}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => 'لم يتم تمكين عرض التجانب',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => 'لم يتم العثور على سجلات في هذه الفترة.',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => 'ملخص الحالة',
    'LBL_DASHLET_ITERACTIONS_NAME' => 'المخطط الزمني',
    'LBL_DASHLET_ATTACHMENTS_NAME' => 'ملاحظات ومرفقات',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => 'ملاحظات ومرفقات تخص السجل',
    'LBL_DASHLET_PIPLINE_NAME' => 'خط العائدات',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => 'التغريدات الأخيرة - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => 'لا توجد لوحات معلومات محفوظة',

    'LBL_DNB_AND' => 'و',
    'LBL_DNB_PRIM_NAME_DESC' => 'نص يسجل اسم هذه المنظمة',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => 'الرد',
    'LBL_TWITTER_RETWEET' => 'إعادة التغريد',
    'LBL_TWITTER_FAVORITE' => 'المفضلة',
    'LBL_TWITTER_FOLLOW' => 'متابعة',
    'LBL_TWITTER_DESCRIPTION' => 'شاهد التطابق بين مستخدمي تويتر والتغريدات، أعد التغريد والرد على التغريدات',
    'LBL_TWITTER_ID' => 'معرّف Twitter',
    'LBL_TWITTER_DISPLAY_ROWS' => 'عرض الصفوف',
    'LBL_TWITTER_MY_ACCOUNT' => 'حسابي',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'مصدر Tweet:',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => 'موارد المعرفة',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => 'التدريب والاعتماد',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'مجتمع SugarClub',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => 'الوثائق والدعم',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'سوق SugarOutfitters',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => 'المبيعات حسب البلد',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => 'عرض مخطط المبيعات حسب خريطة البلاد.',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => 'فئات قاعدة المعارف والمقالات المنشورة',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => 'بحث قاعدة المعارف',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => 'تعرض طريقة عرض شجرية قابلة للبحث بها عن المقالات والفئات المنشوؤة في قاعدة المعارف.',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => 'المقالات المنشورة بلغات أخرى',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => 'مقالات قاعدة المعارف المنشورة المفيدة للغاية',
    'LBL_DASHLET_MOST_USEFUL_DESC' => 'تعرض مقالات قاعدة المعرفة الأكثر حصولاً على الإعجاب والأكثر مشاهدة',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} تمت تصفيتها حسب {{label}} "{{value}}"',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => 'مدى الفائدة للمقالات',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => 'إضافة صفحة',
    'LBL_LOADING_PAGE' => 'يتم الآن تحميل صفحة، يرجى الانتظار...',
    'LBL_SEARCH_RESULTS' => 'نتائج البحث',
    'LBL_SEARCH_RESULTS_FOR' => 'نتائج البحث عن: ',
    'LBL_SEARCH_HELP_TITLE' => 'تلميحات البحث',
    'LBL_SEARCH_RESULTS_FOUND' => 'نتائج البحث التي تم العثور عليها',
    'LBL_SEARCH_RESULTS_TIME' => 'الآنسة',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => 'تدفقاتي',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "تدفقات فريقي",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => 'مخطط تدفق المبيعات',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => 'يظهر مخطط التدفق الحالي.',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => 'بدون صورة',

    'LBL_MODULE' => 'الوحدة',
    'LBL_RELATIONSHIP' => 'العلاقة',
    'LBL_SINGULAR_LABEL' => 'تسمية مفرد',
    'LBL_PLURAL_LABEL' => 'تسمية جمع',
    'LBL_MODULE_DISPLAY' => 'عرض',
    'LBL_MODULE_DISPLAY_TYPE' => 'نوع العرض',
    'LBL_MODULE_ICON' => 'الأيقونة',
    'LBL_MODULE_COLOR' => 'لون خلفية الوحدة',
    'LBL_LANGUAGE_SELECTOR' => 'اللغة',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => 'إعدادات الوحدة',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => 'تم حفظ إعدادات الوحدة.',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'نسخ العنوان من اليسار:',
    'LBL_SAVE_AND_CONTINUE' => 'الحفظ والاستمرار',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>أدوات تحكم متعددة الاختيار</strong></p><ul><li>انقر فوق القيم لتحديد سمة.</li><li>انقر Ctrl &nbsp;to&nbsp;حدد متعدد. مستخدمو Mac يستخدمون النقر فوق CMD.</li><li>لتحديد كل القيم بين سمتين &nbsp، انقر فوق القيمة الأولى nbspثم انقر فوق shift.</li></ul><p><strong>بحث ومخطط متقدم خيارات</strong><br><br>استخدام <b>البحث والمخطط المحفوظ</b> ، يمكنك حفظ مجموعة من معلمات البحث و/أو قائمة تخصيص للحصول سريعًا على نتائج البحث المرغوب فيها مستقبلاً. يمكنك حفظ عدد لانهائي من الأبحاث المخصصة والمخططات. تظهر كل عمليات البحث المحفوظة حسب الاسم في قائمة "أبحاث محفوظة"، مع آخر بحث محفوظ تم تحميله يظهر أعلى القائمة.<br><br>لتخصيص مخطط عرض القائمة، استخدم مربعات "إخفاء أعمدة وإظهار أعمدة" لتحديد الحقول المراد عرضها في نتائج البحث. على سبيل المثال، يمكنك عرض أو إخفاء التفاصيل على شكل اسم السجل، وتعيين مستخدم، وتعيين فريق في نتائج البحث. لإضافة عمود لعرض القائمة، حدد الحقل من قائمة "إخفاء أعمدة" واستخدم السهم الأيسر لنقله إلى قائمة "عرض أعمدة". لمسح عمود من عرض قائمة، حدده من قائمة "عرض أعمدة" واستخدم السهم الأيمن لنقله إلى قائمة "إخفاء أعمدة".<br><br>إذا حفظت إعدادات المخطط، فستكون قادرًا على تحميلها في أي وقت لعرض نتائج البحث في مخطط مخصص.<br><br>لحفظ وتحديث بحث و/أو مخطط:<ol><li>أدخل اسمًا لنتائج البحث في <b>حفظ هذا البحث على شكل</b> حقل وانقر فوق <b>حفظ</b>.يظهر الاسم الآن في قائمة الأبحاث المحفوظة <b>زر</b> مسح.</li><li>لعرض بحث محفوظ، حدده من قائمة "أبحاث محفوظة". يتم عرض نتائج البحث في قائمة العرض.</li><li>لتحديث خصائص بحث محفوظ، حدد بحثًا محفوظًا من القائمة، أدخل معيار البحث الجديد و/أو خيارات المخطط في منطقة "بحث متقدم" وانقر فوق <b>تحديث</b> بجوار <b>تعديل البحث الحالي </b>.</li><li>لحذف بحث محفوظ، حدده في قائمة "أبحاث محفوظة"، ثم انقر فوق <b>حذف</b> بجوار <b>تعديل البحث الحالي</b>، ثم انقر فوق<b>موافق</b> لتأكيد الحذف.</li></ol><p><strong>نصائح</strong><br><br>باستخدام علامة النسبة بوصفها مشغلًا، يمكنك القيام ببحثك بشكل أوسع نطاقًا.  على سبيل المثال، بدلاً من البحث فقط عن نتائج تساوي "تفاح" يمكنك تغيير بحثك "% تفاحات" الذي ربما يطابق كل النتائج التي تبدأ بالكلمة تفاح ولكن يحتوي على حروف أخرى أيضًا.</p>',

    //resource management
    'ERR_QUERY_LIMIT' => 'خطأ: تم الوصول إلى حد الاستعلام %$limit بالنسبة لوحدة $module.',
    'ERROR_NOTIFY_OVERRIDE' => 'خطأ: مراقب المورد->إخطار() يتطلب تجاوزه.',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => 'خطأ: غير قادر على إنشاء مراقب حيث إن ملف بيانات التعريف فارغ أو تعذر العثور على الملف.',
    'ERR_MONITOR_NOT_CONFIGURED' => 'خطأ: لم يوجد مراقب تمت تهيئته للاسم المطلوب',
    'ERR_UNDEFINED_METRIC' => 'خطأ: غير قادر على ضبط القيمة لقياس غير محدد',
    'ERR_STORE_FILE_MISSING' => 'خطأ: غير قادر على العثور على ملف تطبيق مخزن',

    'LBL_MONITOR_ID' => 'معرّف المراقب',
    'LBL_TEAM_ID' => 'معرّف الفريق',
    'LBL_SELECT_MODULE' => 'تحديد وحدة:',
    'LBL_USER_ID' => 'معرّف المستخدم ',
    'LBL_MODULE_NAME' => 'اسم الوحدة',
    'LBL_MODULE_ALL' => 'الكل',
    'LBL_ITEM_ID' => 'معرّف العنصر',
    'LBL_ITEM_SUMMARY' => 'ملخص العنصر',
    'LBL_ACTION' => 'الإجراء',
    'LBL_SESSION_ID' => 'معرّف الجلسة',
    'LBL_BREADCRUMBSTACK_CREATED' => 'تم إنشاء BreadCrumbStack لمعرّف المستخدم {0}',
    'LBL_VISIBLE' => 'السجل مرئي',
    'LBL_DATE_LAST_ACTION' => 'تاريخ آخر إجراء',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'نص SQL',
    'LBL_QUERY_HASH' => 'تجزئة SQL',
    'LBL_SEC_TOTAL' => 'إجمالي الثواني',
    'LBL_SEC_AVG' => 'متوسط الثواني',
    'LBL_RUN_COUNT' => 'حساب الاستعلام',

    //Tracker Sessions
    'LBL_CLIENT_IP' => 'عنوان IP العميل',
    'LBL_DATE_START' => 'تاريخ البدء',
    'LBL_ACTIVE' => 'الجلسة نشطة',
    'LBL_ROUNDTRIPS' => 'حساب الإجراء',
    'LBL_SECONDS' => 'الثواني نشطة',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => 'أزمنة انتقال قاعدة البيانات',
    'LBL_FILES_OPENED' => 'الملفات التي تم الوصول إليها',
    'LBL_MEMORY_USAGE' => 'استخدام الذاكرة (بايت)',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => 'يتم الآن تحميل موصل Twitter ...',
    'LBL_TWITTER_DATA_EMPTY' => 'لا توجد بيانات متاحة من Twitter',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'المكون الإضافي الخاص بـ Sugar لـ Outlook',
    'LBL_PLUGIN_OUTLOOK_DESC' => 'تكامل البريد الإلكتروني لـ Sugar وبيانات التقويم مع Microsoft Outlook.',
    'LBL_PLUGIN_WORD_NAME' => 'المكون الإضافي الخاص بـ Sugar لـ Word',
    'LBL_PLUGIN_WORD_DESC' => 'نشر المعلومات تلقائيًا من SugarCRM إلى الخطابات، والبريد الإلكتروني المباشر، ومستندات Microsoft الأخرى.',
    'LBL_PLUGIN_EXCEL_NAME' => 'المكون الإضافي الخاص بـ Sugar لـ Excel',
    'LBL_PLUGIN_EXCEL_DESC' => 'تكامل Sugar مع جداول البيانات لتحليل أفضل للقياسات الأساسية.',
    'LBL_PLUGINS_TITLE' => 'المكونات الإضافية الخاصة بـ Sugar لـ Microsoft Office<sup>TM</sup>',
    'LBL_PLUGINS_DESC' => 'اقرأ عن خصائص المكون الإضافي داخل <a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns"> مستندات المكونات الإضافية </a>.',

    'LBL_PLUGINS_LOTUS_TITLE' => 'المكونات الإضافية الخاصة بـ Sugar لـ Lotus Notes<sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'المكونات الإضافية الخاصة بـ Sugar لـ Lotus Notes',
    'LBL_PLUGIN_LOTUS_DESC' => 'تكامل Sugar مع Lotus Notes.',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => 'ليست قبل',
    'MSG_IS_MORE_THAN' => 'أكثر من',
    'MSG_IS_LESS_THAN' => 'أقل من',
    'MSG_SHOULD_BE' => 'يجب أن تكون',
    'MSG_OR_GREATER' => 'أو أكبر',
    'MSG_EXCEEDS_MAXLEN' => 'يتجاوز الحد الأقصى للطول المحدد ',

    'LBL_PORTAL_WELCOME_TITLE' => 'مرحبًا بك في Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'يمثل Sugar Portal إطار عمل يتيح إمكانية لعرض الوقت الفعلي، والمشكلات، ونشرات الأخبار، وما شابه للعملاء. يعتبر واجهة مواجهة خارجية لـ Sugar يمكن نشرها داخل أي موقع إلكتروني.  لا تزال مناسبة لمزيد من خصائص الخدمة الذاتية للعميل مثل إدارة المشروعات والمنتديات في إصداراتنا المستقبلية.',
    'LBL_LIST' => 'القائمة',
    'LBL_CREATE_CASE' => 'إنشاء حالة',
    'LBL_CREATE_BUG' => 'إنشاء خطأ',
    'LBL_NO_RECORDS_FOUND' => '- تم العثور على 0 سجلات -',

    'DATA_TYPE_DUE' => 'تستحق:',
    'DATA_TYPE_START' => 'البدء:',
    'DATA_TYPE_SENT' => 'المرسلة:',
    'DATA_TYPE_MODIFIED' => 'المعدلة:',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => 'حساب',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => 'صورة كائن',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => 'تحديد بيانات',

    'LBL_VALIDATE_RANGE' => 'ليست داخل نطاق صالح',
    'LBL_VALIDATE_URL' => 'ليس عنوان URL صالحًا',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => 'الكل',

    'LBL_OPERATOR_IN_TEXT' => 'هي واحدة مما يلي:',
    'LBL_OPERATOR_NOT_IN_TEXT' => 'ليست واحدة مما يلي:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => 'خطأ: لا يتطابق عدد صفيف معلمات الفول مع عدد صفيف النتائج.',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => 'خطأ: إدخال تعيين مفقود للوحدة.',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => 'خطأ: غير قادر على استعادة البيانات الخاصة بـ موصل {0}.  قد لا يمكن الوصول إلى الخدمة حاليًا، أو قد تكون إعدادات التهيئة غير صالحة.  رسالة خطأ الموصل: ({1}).',
    'ERROR_CONNECTOR_CONFIGURE' => 'غير قادر على استرداد البيانات.  قد لا يمكن الوصول إلى الخدمة حاليًا، أو قد تكون إعدادات التهيئة غير صالحة.',
    'LBL_CONNECT_TWITTER' => 'الاتصال بـ Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => 'لا يمكن العثور على توقيت زمني صالح لمعرّف Twitter: ',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => 'تهيئة موصل Twitter',
    'LBL_CONNECT_TEST_FAIL' => 'خطأ: قد تكون إعدادات الموصل غير صالحة. يُرجى الاتصال بالمسؤول الخاص بك.',
    'LBL_CONFIGURE_TWITTER' => 'اتصل بالمسؤول لتهيئة Twitter',
    'LBL_MERGE_CONNECTORS' => 'الحصول على بيانات',
    'LBL_NO_DATA_AVAILABLE' => 'لا تتوفر بيانات.',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => 'هل تريد بالتأكيد تعطيل تكامل الموصل لهذه الوحدة؟',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => 'فشل الاتصال بخادم Elastic',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => 'لا يمكن حذف الفريق العالمي.',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => 'لا يمكن حذف هذا الفريق الخاص [{0}] حتى يتم حذف [{1}] المستخدم.',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => 'ربما يوجد لديك برنامج Abobe Flash مغلق أو ربما تستخدم إصدارًا قديمًا من Adobe Flash Player. للحصول على أحدث إصدار من Flash Player، <a href="http://www.adobe.com/go/getflashplayer/">انقر هنا</a>.',
    //Collection Field
    'LBL_COLLECTION_NAME' => 'الاسم',
    'LBL_COLLECTION_PRIMARY' => 'أساسي',
    'ERROR_MISSING_COLLECTION_SELECTION' => 'الحقل المطلوب فارغ',
    'LBL_COLLECTION_EXACT' => 'بالضبط',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => 'للحصول على أفضل تجربة باستخدام IIS/FastCGI sapi، اضبط دخول fastcgi.logging على 0 في ملف php.ini الخاص بك.',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => 'تعيين إلى',
    'LBL_DESCRIPTION' => 'الوصف',
    'LBL_PRIMARY_CONTACT_NAME' => 'جهة الاتصال الأساسية',
    'LBL_PRIMARY_CONTACT_ID' => 'معرف جهة الاتصال الأساسية',

    'LBL_NONE' => '-بلا-',
    'LBL_YESTERDAY' => 'أمس',
    'LBL_TODAY' => 'اليوم',
    'LBL_TOMORROW' => 'غدًا',
    'LBL_NEXT_WEEK' => 'الأسبوع القادم',
    'LBL_NEXT_MONDAY' => 'الإثنين القادم',
    'LBL_NEXT_FRIDAY' => 'الجمعة القادم',
    'LBL_TWO_WEEKS' => 'أسبوعان',
    'LBL_NEXT_MONTH' => 'الشهر القادم',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => 'أول يوم من الشهر القادم',
    'LBL_THREE_MONTHS' => 'ثلاثة شهور',
    'LBL_SIXMONTHS' => 'ستة شهور',
    'LBL_NEXT_YEAR' => 'السنة القادمة',
    'LBL_FILTERED' => 'تمت تصفيته',

    //Datetimecombo fields
    'LBL_HOURS' => 'ساعات',
    'LBL_MINUTES' => 'دقائق',
    'LBL_MERIDIEM' => 'ظهرًا',
    'LBL_DATE' => 'التاريخ',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => 'تحديث تلقائي',

    'LBL_DURATION_DAY' => 'يوم',
    'LBL_DURATION_HOUR' => 'ساعة',
    'LBL_DURATION_MINUTE' => 'دقيقة',
    'LBL_DURATION_DAYS' => 'أيام',
    'LBL_DURATION_HOURS' => 'ساعات',
    'LBL_DURATION_MINUTES' => 'دقائق',
    'LBL_DURATION_SECONDS' => 'ثوانٍ',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => 'اختيار شهر',
    'LBL_ENTER_YEAR' => 'إدخال سنة',
    'LBL_ENTER_VALID_YEAR' => 'يرجى إدخال سنة صالحة',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => 'يرجى إدخال رقم هاتف في الولايات المتحدة مكون من أرقام، تتضمن رمز المنطقة.',
    'LBL_CCP_NOT_INITIATED' => 'تجري محاولة الاتصال باستخدام CCP في الوقت الذي لم يسجل فيه الوكيل الدخول.',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => 'يتعذر بدء الاتصال عبر CCP.',
    'LBL_CCP_DIALING_ERROR' => 'لا يمكن إكمال هذا الاتصال.',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => 'الرجاء إغلاق أي جلسات دردشة في SugarLive قبل إجراء أي مكالمة صادرة.',

    //File write error label
    'ERR_FILE_WRITE' => 'خطأ: تعذرت كتابة الملف {0}.  يرجى التحقق من النظام وتصاريح خادم الشبكة.',
    'ERR_FILE_NOT_FOUND' => 'خطأ: تعذر تحميل ملف {0}.  يرجى التحقق من النظام وتصاريح خادم الشبكة.',

    'LBL_AND' => 'و',
    'LBL_BEFORE' => 'قبل',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => 'تحميل من جهاز الكمبيوتر الخاص بك',
    'LBL_SEARCH_EXTERNAL_API' => 'ملف على مصدر خارجي',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => 'تحميل إلى مصدر خارجي',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => 'ربط من مصدر خارجي',
    'LBL_EXTERNAL_SECURITY_LEVEL' => 'الأمان',
    'LBL_SHARE_PRIVATE' => 'خاص',
    'LBL_SHARE_COMPANY' => 'الشركة',
    'LBL_SHARE_LINKABLE' => 'قابل للربط',
    'LBL_SHARE_PUBLIC' => 'عام',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'تغذية RSS',
    'LBL_RSS_RECORDS_FOUND' => 'تم العثور على السجل (السجلات) ',
    'ERR_RSS_INVALID_INPUT' => 'RSS ليس نوع إدخال صالح',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS ليس نوع استجابة صالحة لهذه الطريقة',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'لا تدعم Google Doc تنسيق الملف الذي قمت بتقديمه.',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => 'فارغ',
    'LBL_IS_EMPTY' => 'فارغ',
    'LBL_IS_NOT_EMPTY' => 'ليس فارغًا',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '
"هذه عينة ملف تم استيراده يوفر مثالاً للمحتويات المتوقعة لملف والجاهزة للاستيراد."
"هذا الملف عبارة عن ملف .csv مفصول بفاصلة، مستخدمًا أقواسًا مزدوجة كعامل تأهيل للحقل."

"يعتبر الصف الأمامي هو الصف الأعلى في الملف ويحتوي على بطاقات تسمية الحقل كما ستراه في التطبيق."
"يتم استخدام تلك البطاقات لوضع خريطة في الملف للحقول في ملاحظات."

"التطبيق: يمكن استخدام أسماء قواعد البيانات في الصف الأمامي. هذا مفيد عند استخدامك لـ phpMyAdmin أو قاعدة بيانات أخرى لتوفير قائمة مصدرة لبيانات لاستيرادها."
"لا يعتبر ترتيب العمود شيئًا حرجًا حيث تتطابق عملية استيراد البيانات بالحقول المناسبة القائمة على الصف الأمامي."


"لاستخدام هذا الملف كقالب، قم بالآتي:"
"1. احذف صفوف البيانات العينة"
"2. احذف نص التعليمات الذي تقرؤه الآن"
"3. أدخل بياناتك داخل الصفوف والأعمدة المناسبة"
"4. احفظ الملف في مكان معلوم على نظامك"
"5. انقر فوق خيار استيراد من القائمة "إجراءات" في التطبيق واختر الملف المراد تحميله"
   ',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => 'معرّف المستخدم المعين',
    'LBL_EXPORT_CREATED_BY' => 'تم الإنشاء بواسطة المعرّف',
    'LBL_EXPORT_MODIFIED_USER_ID' => 'تم التعديل بواسطة المعرّف',
    'LBL_EXPORT_REPORTS_TO_ID' => 'معرّف التقارير إلى ',
    'LBL_EXPORT_TEAM_ID' => 'معرّف الفريق',
    'LBL_EXPORT_TEAM_SET_ID' => 'المعرّف المعين للفريق',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => 'المستخدم المعين',
    'LBL_EXPORT_FULL_NAME' => 'الاسم بالكامل',
    'LBL_EXPORT_TEAM_NAME' => 'الفرق',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => 'يتم الآن التصفح... ',

    'LBL_PENDING_NOTIFICATIONS' => 'الإشعارات',
    'LBL_ALT_ADD_TEAM_ROW' => 'إضافة صف فريق جديد',
    'LBL_ALT_REMOVE_TEAM_ROW' => 'إزالة فريق',
    'LBL_ALT_SPOT_SEARCH' => 'البحث عن بقعة',
    'LBL_ALT_NOT_SORTED' => 'لم يتم فرزه',
    'LBL_ALT_SORT_DESC' => 'فرز تنازلي',
    'LBL_ALT_SORT_ASC' => 'فرز تصاعدي',
    'LBL_ALT_SORTABLE' => 'قابل للفرز',
    'LBL_ALT_NOT_SORTABLE' => 'غير قابل للفرز',
    'LBL_ALT_SORT' => 'فرز',
    'LBL_ALT_SHOW_OPTIONS' => 'عرض الخيارات',
    'LBL_ALT_HIDE_OPTIONS' => 'إخفاء الخيارات',
    'LBL_ALT_MOVE_COLUMN_LEFT' => 'انقل الإدخال المحدد للقائمة على اليسار',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => 'انقل الإدخال المحدد للقائمة على اليمين',
    'LBL_ALT_MOVE_COLUMN_UP' => 'انقل الإدخال المحدد لأعلى بترتيب القائمة الموضح',
    'LBL_ALT_MOVE_COLUMN_DOWN' => 'انقل الإدخال المحدد لأسفل بترتيب القائمة الموضح',
    'LBL_ALT_INFO' => 'معلومات',
    'MSG_DUPLICATE' => 'قد يكون {0} السجل الذي توشك على إنشائه نسخة من {0} السجل الموجود بالفعل. {1} سجلات تحتوي على أسماء مشابهة مذكورة أدناه.<br>انقر فوق إنشاء {1} لمتابعة إنشاء هذا {0}الجديد، أو حدد {0} الحالي المذكور أدناه.',
    'MSG_SHOW_DUPLICATES' => '{0} السجل الذي توشك على إنشائه نسخة من سجل {0} الموجود بالفعل. {1} سجلات تحتوي على أسماء مشابهة مذكورة أدناه.  انقر فوق "حفظ" لمتابعة إنشاء هذا {0}الجديد، أو انقر فوق "إلغاء" للعودة إلى الوحدة بدون إنشاء {0}.',
    'LBL_EMAIL_TITLE' => 'عنوان البريد الإلكتروني',
    'LBL_EMAIL_OPT_TITLE' => 'عنوان البريد الإلكتروني المرفوض',
    'LBL_EMAIL_INV_TITLE' => 'عنوان بريد إلكتروني غير صالح',
    'LBL_EMAIL_PRIM_TITLE' => 'عنوان البريد الإلكتروني الرئيسي',
    'LBL_SELECT_ALL_TITLE' => 'تحديد الكل',
    'LBL_SELECT_THIS_ROW_TITLE' => 'تحديد هذا الصف',
    'LBL_TEAM_SELECTED_TITLE' => 'الفريق المحدد ',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => 'حدد لجعل هذا الفريق أساسيًا',
    'LBL_TEAM_TBSELECTED_TITLE' => 'تم وضع علامة على هذا الفريق بالاختيار على أساس الفريق ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => 'وضع علامة على هذا الفريق بالاختيار على أساس الفريق',
    'LBL_SEARCH_AND_SELECT' => 'البحث والتحديد {{module}}',
    'TPL_SEARCH_AND_ADD' => 'البحث والإضافة {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => 'خطأ: حدث خطأ أثناء التحميل. رمز الخطأ: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => 'خطأ: حدث خطأ أثناء التحميل. رمز الخطأ: {0} - {1}. upload_maxsize هو {2} ',
    'UPLOAD_ERROR_HOME_TEXT' => 'خطأ: حدث خطأ أثناء تحميلك، يرجى الاتصال بالمسؤول للمساعدة.',
    'UPLOAD_MAXIMUM_EXCEEDED' => 'حجم التحميل ({0} بايت) تجاوز الحد الأقصى المسموح به: {1} بايت',
    'UPLOAD_REQUEST_ERROR' => 'حدث خطأ. يرجى تحديث صفحتك ثم حاول مرة أخرى.',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => 'تحرير',
    'LBL_ADD_BUTTON_LABEL' => 'إضافة',
    'LBL_EDIT_BUTTON_TITLE' => 'تحرير',
    'LBL_REFRESH_BUTTON_LABEL' => 'تحديث',
    'LBL_REFRESH_BUTTON_TITLE' => 'تحديث',
    'LBL_DUPLICATE_BUTTON_KEY' => 'u',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'نسخ',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'نسخ',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => 'جداول التقرير',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => 'جداول التقرير',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => 'تفاصيل التقرير',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => 'تفاصيل التقرير',
    'LBL_DELETE_BUTTON_KEY' => 'D',
    'LBL_DELETE_BUTTON_LABEL' => 'حذف',
    'LBL_DELETE_BUTTON_TITLE' => 'حذف',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => 'حفظ',
    'LBL_SAVE_BUTTON_TITLE' => 'حفظ',
    'LBL_CANCEL_BUTTON_KEY' => 'l',
    'LBL_CANCEL_BUTTON_LABEL' => 'إلغاء',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => 'للتوقف.',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => 'للبقاء في الصفحة.',
    'LBL_CANCEL_BUTTON_TITLE' => 'إلغاء',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => 'مشاركة',
    'LBL_SHARE_BUTTON_TITLE' => 'مشاركة',
    'LBL_START_BUTTON_LABEL' => 'البدء',
    'LBL_START_BUTTON_TITLE' => 'البدء',
    'LBL_FINISH_BUTTON_LABEL' => 'إنهاء',
    'LBL_FINISH_BUTTON_TITLE' => 'إنهاء',
    'LBL_CONFIRM_BUTTON_LABEL' => 'تأكيد',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => 'للمتابعة.',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => 'لترك الصفحة وتجاهل التغييرات.',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => 'اختصارات لوحة المفاتيح',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>من الوظائف - Alt+</strong><br/> I = ed<b>I</b>t (عرض تفصيلي)<br/> U = <b>U</b>تكرار (عرض تفصيلي)<br/> D = <b></b>حذف (عرض تفصيلي)<br/> R = Sha<b>R</b>مشاركة (عرض تفصيلي)<br/> A = s<b>A</b>حفظ (عرض التحرير)<br/> L = إلغاء<b></b> (عرض التحرير) <br/><br/></p><p><strong>بحث وتصفح - Alt+</strong><br/> 7 = إدخال أول على نموذج تعديل<br/> 8 = بحث متقدم الرابط<br/> 9 = أول نموذج بحث إدخال<br/> 0 = إدخال بحث موحد<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => 'تصعيد',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => 'مشاركة',
    'TPL_RECORD_SHARE_SUBJECT' => 'مشاركة{{module}} {{name}} من {{appId}}',
    'TPL_RECORD_SHARE_BODY' => 'يرجى مراجعة {{module}} {{name}} من {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => 'سهم الموصل في {0} تم تعريفه بطريقة غير صحيحة، أو قد يكون فارغًا وتعذر استخدامه.',
    'LBL_PDF_VIEW' => 'تنزيل PDF',
    'LBL_PDF_EMAIL' => 'إرسال بريد إلكتروني كـ PDF',

    'ERR_SUHOSIN' => 'منع التحميل من Suhosin، يرجى إضافة &quot;تحميل&quot; إلى suhosin.executor. متضمنًا القائمة البيضاء (لمزيد من المعلومات راجع sugarcrm.log)',

    //for sidecar
    'LBL_TIME_AGO_NOW' => 'في الحال',
    'LBL_TIME_AGO_SECONDS' => 'منذ أقل من دقيقة',
    'LBL_TIME_AGO_MINUTE' => 'منذ دقيقة تقريبًا',
    'LBL_TIME_AGO_MINUTES' => '{{this}} منذ دقائق',
    'LBL_TIME_AGO_HOUR' => 'منذ ساعة تقريبًا',
    'LBL_TIME_AGO_HOURS' => '{{this}} منذ ساعات',
    'LBL_TIME_AGO_DAY' => 'أمس',
    'LBL_TIME_AGO_DAYS' => '{{this}} منذ أيام',
    'LBL_TIME_AGO_YEAR' => 'منذ سنة',
    'LBL_TIME_UNTIL_SECONDS' => 'في أقل من دقيقة',
    'LBL_TIME_UNTIL_MINUTE' => 'في حوالي دقيقة',
    'LBL_TIME_UNTIL_MINUTES' => 'خلال {{this}} دقائق',
    'LBL_TIME_UNTIL_HOUR' => 'خلال حوالي ساعة',
    'LBL_TIME_UNTIL_HOURS' => 'خلال {{this}} ساعات',
    'LBL_TIME_UNTIL_DAY' => 'غدًا',
    'LBL_TIME_UNTIL_DAYS' => 'خلال {{this}} أيام',
    'LBL_TIME_UNTIL_YEAR' => 'خلال ما يزيد عن سنة',
    'LBL_TIME_RELATIVE' => 'مرسل{{relativetime}} على{{date}} إلى {{time}}',
    'LBL_LAST_TOUCHED' => 'آخر مرة تم لمسها {{relativetime}} على{{date}} في {{time}}',
    'LBL_LAST_COMMIT' => 'آخر التزام: ',
    'LBL_LISTVIEW_NO_RECORDS' => 'لا تتوفر بيانات.',
    'LBL_DETAILVIEW_NO_RECORDS' => 'تعذرت استعادة هذا السجل في هذا التوقيت.',
    'LBL_REFINE_LIST' => 'تنقيح القائمة',
    'LBL_SEARCH_BY' => 'البحث بواسطة',
    'LBL_PREVIEW' => 'معاينة',
    'LBL_COLUMNS' => 'الأعمدة',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => 'تم تعطيل المعاينة: لا تتوفر بيانات',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => 'تم تعطيل المعاينة: لا يمكن الوصول إلى سجل',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => 'تم تعطيل المعاينة: لا تتوفر بيانات',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => 'تم تعطيل المعاينة: أثناء العرض مثل السجل الحالي',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => 'تم تعطيل المعاينة: تم مسح سجل أو حظر الدخول على سجل',
    'LBL_PREVIEW_PREVIOUS' => 'معاينة السابق',
    'LBL_PREVIEW_NEXT' => 'معاينة التالي',
    'LBL_PREVIEW_CLOSE' => 'إغلاق المعاينة',
    'LBL_STREAM_NO_RECORDS' => 'لا توجد ملاحظات في هذا السجل هذه المرة. يرجى إضافة ملاحظة بالنقر فوق رابط إضافة ملاحظة.',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}} تم العثور على تكرار',
    'LBL_NO_DUPLICATES_FOUND' => 'لم يتم العثور على قيم مكررة.',
    'LBL_RESET_DEFAULT_VIEW' => 'إعادة تعيين طريقة العرض الافتراضية',
    'LBL_RESET_DEFAULT_WIDTHS' => 'إعادة تعيين العروض الافتراضية',
    'LBL_TIMEZONE_UPDATED' => 'حدّث Sugar المنطقة الزمنية لملف تعريف المستخدم الخاص بك لمطابقة المنطقة الزمنية للمستعرض لديك',
    'LBL_SUCCESS' => 'نجاح',
    'LBL_ERROR' => 'خطأ',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => 'دمج التكرارات',
    'LBL_MERGE_DUPLICATES_PROCEED' => 'هل ترغب في المتابعة؟ إيقاف قبل الاكتمال تأكيد حذف السجلات',
    'LBL_MERGE_DUPLICATES_CONFIRM' => 'يؤدي هذا الإجراء إلى حذف السجل (السجلات) التالي:',
    'LBL_MERGE' => 'دمج',
    'TPL_MERGING_RECORDS' => 'دمج{{mergeCount}} سجلات',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        'عدد غير صالح من السجلات تم المرور عليها. النطاق الصالح من {{minRecords}} إلى {{maxRecords}} سجلات.',
    'LBL_MERGE_NO_ACCESS' =>
        'لا تتوفر لديك إمكانية الوصول للقيام بهذا الإجراء. يجب أن يكون هناك سجل واحد قابل للتعديل على الأقل.',
    'LBL_MERGE_LOCKED' => 'بعض السجلات المحددة للدمج تحتوي على حقول مؤمنة للتحرير بواسطة عملية ولا يمكن دمجها في هذا الوقت.',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        'سيتم رفض كل التغييرات عند الانتقال إلى سجل أساسي جديد. هل تريد بالتأكيد الانتقال؟',
    'LBL_MERGE_DUPLICATES_TITLE' => 'دمج سجلات مرتبطة',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => 'تم الدمج: {{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        'فشل دمج {{objectName}}المرتبطة. بدء محاولة جديدة ({{num}} لـ {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        'فشل دمج {{objectName}}المرتبطة.',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        'دمج سجلات مرتبطة غير مكتمل. بقاء بعض السجلات بدون دمج.',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        'لم يتم دمج بعض السجلات المرتبطة بشكل صحيح. إيقاف قبل الاكتمال التأكيد على متابعة الدمج.',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        'سيتم نقل كل السجلات المرتبطة للسجل الأساسي.',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        'هل تريد بالتأكيد إزالة هذا السجل من الدمج؟',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => 'إزالة السجل من الدمج',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => 'تم تمرير عدد غير صحيح من السجلات. النطاق الصالح من 1 إلى {{maxRecords}} سجل (سجلات).',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => 'دمج اسم المستخدم/كلمة المرور غير صحيح، يرجى المحاولة مرة أخرى.',
    'LBL_INVALID_CREDS_TITLE' => 'اعتمادات غير صالحة',
    'LBL_INVALID_GRANT' => 'الرمز الخاص بك غير صالح أو انتهت صلاحيته. يرجى تسجيل الدخول مرة أخرى.',
    'LBL_INVALID_GRANT_TITLE' => 'الرمز منتهي الصلاحية',
    'LBL_AUTH_FAILED' => 'فشلت مصادقة العميل.',
    'LBL_AUTH_FAILED_TITLE' => 'عميل غير صالح',
    'LBL_INVALID_REQUEST' => 'الطلب غير صالح أو به عيوب. يرجى الاتصال بالدعم الفني.',
    'LBL_INVALID_REQUEST_TITLE' => 'طلب غير صالح',
    'LBL_REQUEST_TIMEOUT' => 'الخادم لا يستجيب. تحقق من اتصالك بإلانترنت.',
    'LBL_REQUEST_TIMEOUT_TITLE' => 'انتهاء زمن الطلب: ',
    'LBL_UNAUTHORIZED' => 'عذرًا، يبدو أنك غير مسموح لك بالدخول إلى هذا المورد.',
    'LBL_UNAUTHORIZED_TITLE' => 'غير مسموح',
    'LBL_RESOURCE_UNAVAILABLE' => 'المورد غير متاح.',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'ممنوع',
    'LBL_METHOD_NOT_ALLOWED' => 'غير مسموح بطريقة HTTP لهذا المورد. يرجى الاتصال بالدعم الفني.',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'غير مسموح بالطريقة',
    'LBL_PRECONDITION_MISSING' => 'فشل الطلب، أو، المعلمة مفقودة/غير صالحة. يرجى الاتصال بالدعم الفني.',
    'LBL_PRECONDITION_MISSING_TITLE' => 'خطأ: ',
    'LBL_INVALID_412_RESPONSE' => 'فشل الطلب مما يجعل التطبيق غير قابل للاستخدام. يرجى الاتصال بالدعم الفني.',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => 'غير مسموح بتعديل الحقل {0} في الوحدة: {1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => 'غير مسموح بهذا الإجراء \\"{0}\\" في هذا السجل',
    'LBL_LOGIN_BUTTON_LABEL' => 'تسجيل الدخول',
    'LBL_ACTIVITY_VIEW_TOUR' => 'جولة لعرض النشاط',
    'LNK_TOUR' => 'الجولة',
    'LNK_MOBILE' => 'المحمول',
    'LBL_FEEDBACK' => 'تعليقات',
    'LBL_SUPPORT' => 'دعم',
    'LBL_LANGUAGE' => 'اللغة/Sprache / Idioma',
    'LBL_LOADING_LANGUAGE' => 'تحميل حزمة اللغة',
    'LBL_UPLOADING' => 'تحميل',
    'LBL_UPLOADING_DOTS' => 'جارٍ التحميل...',
    'LBL_IMAGE_DELETE_CONFIRM' => 'هل تريد بالتأكيد حذف هذه الصوdة؟',
    'LBL_FILE_DELETE_CONFIRM' => 'هل تريد بالتأكيد حذف هذا الملف؟ لا يمكن التراجع عن ذلك.',
    'LBL_FILE_DELETED' => 'تم حذف الملف بنجاح',

    //theme roller
    'LBL_PORTAL_THEME' => 'سمة البوابة',
    'LBL_THEME_PREVIEW' => 'معاينة سمة المدخل',
    'LBL_LOADING_PREVIEW' => 'معاينة التحميل',
    'LBL_RESET' => 'إعادة تعيين',
    'LBL_COLORS' => 'الألوان',
    'BorderColor' => 'لون الحد',
    'NavigationBar' => 'شريط التصفح',
    'PrimaryButton' => 'زر أساسي',
    'LBL_SAVE_AND_DEPLOY_BTN' => 'حفظ ونشر',
    'LBL_RESET_THEME_LNK' => 'استعادة السمة الافتراضية',
    'LBL_RESET_THEME_MODAL_INFO' => 'هل تريد بالتأكيد تجاهل الإعدادات المخصصة للسمة الخاصة بك واستبدالها بالسمة الافتراضية؟',
    'LBL_RESET_THEME_PROCESS' => 'يتم الآن استعادة الموضوع الافتراضي...',
    'LBL_SAVE_THEME_PROCESS' => 'يتم الآن حفظ الموضوع...',

    // image loader
    'LBL_SELECT_PHOTO' => 'تحديد صورة',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => 'تعزيز وظيفة التوقع في Sugar',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left; width: 300px;"><li class="fa fa-check">إعداد معلمات التوقع الخاص بك<li class="fa fa-check">تتبع المبيعات المتوقعة وسلامة خط العائدات بكل سهولة<li class="fa fa-check">التوقع القائم على المبيعات المخطط لها من فريق البيع لديك</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen1-thumb.png" width="220" id="thumbnail_1" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => 'إعداد معلمات التوقع الخاص بك',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '• اختر تاريخ بدء السنة المالية<br />• فترات الإعداد لتكون سنوية أو ربع سنوية<br />• إقرار كم عدد الفترات الماضية والمستقبلية المراد أن تكون مرئية في صفحة العمل<br />• حدد نطاقات التوقع لوضع علامات على الفرص كما هو مضمن، أو خالٍ، أو أعلى<br />• حدد سيناريوهات التنبؤ لتعريف المشابه، والأفضل، والأسوأ',
    'LBL_TOUR_SCREEN_3_TITLE_670' => 'تحكم في فريق المبيعات والمبيعات المخطط لها',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '•	حدد الفترة الزمنية لمعاينة التوقع<br />•	عرض صفحات عمل مبيعات أعضاء فريقك وتقديم توقعات معدلة<br />•	راجع التنبيه في صفحة عمل عند التزام عضو فريقك بالتوقع الجديد<br />•	احفظ صفحة عمل التوقع كمسودة أو الالتزام بمديرك<br />•	عرض تاريخ الالتزامات السابقة',
    'LBL_TOUR_SCREEN_4_TITLE_670' => 'تحكم في فريق المبيعات والمبيعات المخطط لها',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '•	عرض مخطط باريتو لتحليل خط العائدات عبر توقعات أعضاء فريق مبيعاتك<br />•	اختر مشاهدة المبيعات المخطط لها المتشابهة، أو الأفضل، أو الأسوأ<br />•	عرض المبيعات المخطط لها وكيف أنك قريب لتحقيق الحصة النسبية الخاصة بفريقك',
    'LBL_TOUR_SCREEN_5_TITLE_670' => 'تحكم في مبيعاتك المخطط لها',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '•	حدد الفترة الزمنية للتوقع<br />•	الخاص بك، والكميات المعدلة، واحتمالية الفوز لما يتم تحليله سريعًا<br />•	احفظ صفحة عمل التوقع كمسودة أو الالتزام بمديرك<br />•	عرض تاريخ الالتزامات السابقة<br />•	التزام بالتوقع لمديرك وعرض تاريخ الالتزامات السابقة',
    'LBL_TOUR_SCREEN_6_TITLE_670' => 'تحكم في مبيعاتك المخطط لها',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '•	عرض مخطط باريتو لتحليل خط العائدات بمرور الوقت لفرصك<br />•	اختر مشاهدة توزيع خط الأنابيب حسب مرحلة المبيعات أو احتمالية الفوز<br />•	عرض المبيعات المخطط لها وكيفية تحقيق الحصة النسبية الخاصة بفريقك',
    'LBL_TOUR_WELCOME' => 'ما الجديد في Sugar',
    'LBL_TOUR_WATCH' => 'شاهد ما الجديد في Sugar',
    'LBL_TOUR_FEATURES_670' => '•	منظر وإحساس محسن - الآن مع السمة الجديدة.<br />•	تعزيز وحدة التوقعات - الآن مع واجهة المستخدم المبادر ورؤية البيانات الجديدة',
    'LBL_TOUR_VISIT' => 'للحصول على مزيد من المعلومات، يرجى زيارة التطبيق الخاص بنا',
    'LBL_TOUR_DONE' => 'لقد فعلتها!',
    'LBL_TOUR_REFERENCE_1' => 'يمكنك دائمًا الإشارة إلى',
    'LBL_TOUR_REFERENCE_2' => 'من خلال رابط الدع أسفل قائمة ملف التعريف.',
    'LNK_TOUR_DOCUMENTATION' => 'الوثائق',
    'LBL_TOUR_CALENDAR_URL_1' => 'هل تشارك تقويم SugarCRM الخاص بك مع تطبيقات خاصة بطرف خارجي، مثل Microsoft Outlook أو Exchange؟ وإذا كان الأمر كذلك، فلديك عنوان URL جديد يتضمن عنوان URL هذا الجديد والآمن مفتاحًا شخصيًا يمنع النشر غير المسوح به لتقويمك.',
    'LBL_TOUR_CALENDAR_URL_2' => 'قم باسترداد تقويم عنوان URL المشارك الجديد.',
    'LBL_TOUR_CUBE' => 'ادخل إلى لوحات المفاتيح وسير النشاط',
    'LBL_TOUR_NAV_BAR' => 'ادخل إلى كل الوحدات في قائمة "التصفح" واتخذ الإجراءات',
    'LBL_TOUR_NOTIFICATIONS' => 'انقر لمشاهدة الإخطارات',
    'LBL_TOUR_SEARCH' => 'حدد وحدة واحدة أو أكثر وابحث',
    'LBL_TOUR_AVATAR' => 'الحصول على مزيد من التفاصيل حول التطبيق أو تسجيل الخروج',
    'LBL_TOUR_ADD' => 'إنشاء سجل من هنا',
    'LBL_TOUR_LIST_INT_TOGGLE' => 'انقر لغلق جزء الذكاء أو فتحه',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => 'اختر مشاهدة الأنشطة أو قائمة السجلات',
    'LBL_TOUR_LIST_FILTER1' => 'يُمكِّن شريط التصفية من البحث عن هذه الوحدة',
    'LBL_TOUR_LIST_FILTER2' => 'اختر عامل تصفية محددًا مسبقًا أو قم بإنشاء جديد',
    'LBL_TOUR_LIST_FILTER_SEARCH' => 'اكتب هنا للبحث حسب الاسم',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => 'اختر التعديل للصف أو معاينة التفاصيل',
    'LBL_TOUR_RECORD_ACTIONS' => 'اتخذ الإجراءات في السجل',
    'LBL_TOUR_RECORD_SUBPANEL' => 'انقر على الرأس لتوسيع وطي اللوحة الفرعية',
    'LBL_TOUR_RECORD_INLINEEDIT' => 'يمكن تحديث اسم السجل في مكانه',
    'LBL_TOUR_RECORD_STATUS' => 'ابحث عن حالة مستوى السجل من هنا',
    'LBL_TOUR_RECORD_SHOWMORE' => 'انقر لمشاهدة المزيد من البيانات للسجل',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => 'اختر مشاهدة الأنشطة أو السجلات المرتبطة',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => 'انقر لتعديل سطر كل حقل',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => 'إنشاء مجموعات لوحات معلومات جديدة',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => 'قم بتعيين اسم لمجموعة لوحات معلومات',
    'LBL_TOUR_RECORD_DASHLETCOG' => 'اختر حذف لوحة معلومات لتغيير الإعدادات',
    'LBL_TOUR_INTRO' =>'<h4>مرحبًا بكم في Sugar</h4> نود أن نأخذكم في جولة حول السمات الخاصة بالتطبيق.  استخدم < و > الأسهم الموجودة أسفل الشاشة لأخذ جولة.<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">الجديد</a><p class="details">تعرف على التغييرات الرئيسية بين الإصدارات.</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">تعرف على المزيد حول Sugar</a><p class="details">مكتبة متميزة تحتوي على مواد التعليم الإلكتروني والتدريب في الفصول الدراسية الفورية والافتراضية والندوات التي تعقد على الويب ومقاطع الفيديو التعليمية.</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">الحصول على الدعم</a><p class="details">هل تحتاج إلى المساعدة أو لديك مشكلة أو ترغب في تقديم اقتراحات تساعد على جعل Sugar أفضل؟</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => 'اعرض قائمة السجلات وسجلات اتخاذ الإجراءات.',
    'LBL_TOUR_RECORD_INTRO' => 'اعرض التفاصيل الموجودة في هذا السجل وشاهد كل البيانات المرتبطة به.',
    'LBL_TOUR_FORECAST_INTRO' => 'تحكم في خط العائدات والتوقع.',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => 'اختر فترة زمنية لمشاهدة التوقع الملائم',
    'LBL_TOUR_FORECASTS_COMMITS' => 'انقر لمشاهدة الالتزامات السابقة',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => 'انقر لتعديل سطر البيانات',
    'LBL_TOUR_FORECASTS_PROGRESS' => 'معاينة المسافة بعرض السعر',
    'LBL_TOUR_FORECASTS_CHART' => 'معاينة توزيع التوقع',
    'LBL_TOUR_TOUR' => 'الدخول إلى الجولة في أي وقت',
    'LBL_TOUR_TAGS_ADD' => 'انقر على حقل العلامات لإضافة وإزالة العلامات',
    'LBL_TOUR_TAGS_DELETE' => 'لحذف علامة، استخدام زر مسح للخلف أو انقر على الزر [X] على كل علامة',
    'LBL_TOUR_RECORD_SAVE' => 'بمجرد أن تكون مستعدًا، انقر على حفظ',


    'LBL_FUTURE' => 'المستقبل',
    'LBL_REQUIRED_FIELD' => 'مطلوب',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => 'البند المسعر',
    'LBL_DISCOUNT_TOTAL' => 'إجمالي الخصم',
    'LBL_DISCOUNT_PERCENT' => '% بالمائة',
    'LBL_DISCOUNT_SELECT' => 'تحديد ما إذا كان الخصم نسبة مئوية أو مبلغ ثابت',
    'LBL_TAX' => 'الضريبة',
    'LBL_SHIPPING' => 'الشحن',
    'LBL_GRAND_TOTAL' => 'الإجمالي الكلي',
    'LBL_QUOTES_POPULATE_ADDRESS' => 'النشر التلقائي لعنوان الفوترة من ملف الحساب',
    'LBL_QLI_ADD_GROUP' => 'إضافة مجموعة',
    'LBL_QLI_COMMENT' => 'التعليق',
    'LBL_SELECT_ACTION' => 'تحديد إجراء',
    'LBL_QLI_GROUP_NAME' => 'اسم المجموعة',
    'LBL_GROUP_TOTAL' => 'إجمالي المجموعة',
    'LBL_ITEM_NAME' => 'البند',
    'LBL_QLI_DELETE' => 'هل تريد بالتأكيد حذف هذا البند؟',
    'LBL_QLI_COMMENT_DELETE' => 'هل تريد بالتأكيد حذف التعليق على هذا البند؟',
    'LBL_QLI_GROUP_DELETE' => 'هل تريد بالفعل حذف المجموعة {0}؟ سيتم نقل جميع البنود إلى المجموعة الافتراضية.',
    'LBL_QLI_GROUP_EMPTY' => 'لا بنود مسعرة جديدة',
    // end of: Quotes related

    'LBL_OPTIONAL' => 'اختياري',
    'LBL_RELATED_MODULE' => 'مرتبط {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => 'مرتبط {{{this}}}',
    'LBL_CREATE_MODULE' => 'إنشاء {{{this}}}',
    'LBL_EDIT' => 'تحرير {{{this}}}',
    'LBL_ASSOC' => 'رابط {{{this}}}',
    'LBL_ASSIGN' => 'تحديد {{{this}}}',
    'LBL_EDIT_RELATED' => 'تحرير ذي الصلة {{{this}}}',
    'LBL_CREATE_RELATED' => 'إنشاء ذي الصلة {{{this}}}',
    'LBL_ASSOC_EXISTING' => 'رابط حالي {{{this}}}',
    'LBL_SEARCH_ALL' => 'البحث في كل {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => 'البحث في جميع السجلات',
    'LBL_SEARCH_ALL_MODULES' => 'البحث في الكل',
    'LBL_OK' => 'موافق',
    'LBL_YES' => 'نعم',
    'LBL_NO' => 'لا',
    'LBL_SHOW_NUMBERING' => 'عرض ترقيم المراحل',
    'LBL_HIDE_NUMBERING' => 'إخفاء ترقيم المراحل',
    'LBL_CALL_BUTTON' => 'المكالمة',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => 'البريد الإلكتروني',
    'LBL_HONEYPOT' => 'إذا كنت شخصًا حقيقيًا فلا تملأ ذلك.',
    'LBL_LINK_BUTTON' => 'الربط',
    'LBL_UNLINK_BUTTON' => 'إلغاء الربط',
    'LBL_MAP_BUTTON' => 'الخريطة',
    'LBL_FILE_BUTTON' => 'الملف',
    'LBL_URL_BUTTON' => 'الويب',
    'LBL_WARNING' => 'تحذير',
    'LBL_CONFIRM' => 'تأكيد',
    'LBL_CONFIRMATION_POPUP' => 'رسالة منبثقة للتأكيد',
    'LBL_NO_ACCESS' => '(غير مسموح بالدخول)',
    'LBL_NO_ACCESS_LOWER' => 'غير مسموح بالدخول',
    'LBL_NO_FIELD_ACCESS' => 'غير مسموح بالدخول',
    'LBL_NO_LICENSE_ACCESS' => 'الترخيص مطلوب',
    'LBL_VALUE_ERASED' => 'تم مسح القيمة',
    'LBL_VALUE_ERASED_TOOLTIP' => 'تم مسح هذه المعلومات عبر طلب خصوصية بيانات',
    'LBL_CREATE_RELATED_RECORD' => 'إنشاء سجل ذي صلة',
    'LBL_ASSOC_RELATED_RECORD' => 'ربط السجل الحالي',
    'LBL_CHOOSE_LINK' => 'اختيار نوع الرابط',
    'LBL_CHOOSE_PARENT_TYPE' => 'اختيار نوع الأصل',
    'LBL_HOME' => 'الصفحة الرئيسية',
    'ERR_NO_DOCS' => 'لا تتوفر مستندات',
    'ERR_NO_RECORDS_SELECTED' => 'لم تقم بتحديد أي سجلات.',
    'LBL_DELETING' => 'يتم الآن الحذف...',
    'LBL_UNLINKING' => 'يتم الآن إلغاء الربط...',
    'LBL_UNLINKED' => 'غير مرتبط',
    'LBL_LEGAL' => 'قانوني',
    'LBL_UPCOMING' => 'مناسباتي القادمة',
    'LBL_RECENTLY_UPDATED' => 'محدثة مؤخرًا',
    'LBL_NOTES_SUBPANEL_TITLE' => 'ملاحظات',
    'LBL_MEETINGS_SUBPANEL_TITLE' => 'الاجتماعات',
    'LBL_TASKS_SUBPANEL_TITLE' => 'المهام',
    'LBL_CALLS_SUBPANEL_TITLE' => 'المكالمات',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => 'الحسابات',
    'LBL_CONTACTS_SUBPANEL_TITLE' => 'جهات الاتصال',
    'LBL_EMAILS_SUBPANEL_TITLE' => 'رسائل البريد الإلكتروني',
    'LBL_SHIFTS_SUBPANEL_TITLE' => 'الورديات',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => 'البنود المسعرة',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => 'استثناءات الورديات',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => 'المستندات',
    'LBL_ESCALATIONS' => 'عمليات التصعيد',
    'LBL_ESCALATED' => 'تم التصعيد',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => 'عمليات التصعيد',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => 'عمليات التصعيد الأخرى',
    'LBL_ESCALATIONS' => 'عمليات التصعيد',
    'LNK_SETTINGS' => 'الإعدادات',
    'LBL_MOBILE_SUPPORT' => 'دعم',
    'LBL_MOBILE_SHOW_MORE' => 'عرض المزيد...',
    'LBL_MOBILE_SHOW_MORE_TOP' => 'عرض المزيد...',
    'LBL_MOBILE_NO_RECORDS' => 'لم يتم العثور على سجلات',
    'LBL_MOBILE_SEARCH_TEAMS' => 'يتم الآن البحث عن الفرق...',
    'LBL_MOBILE_SELECT_TEAMS' => 'تحديد الفرق',
    'LBL_MOBILE_WAIT' => 'يرجى الانتظار....',
    'LBL_MOBILE_LOGING_OUT' => 'يرجى الانتظار لحين تسجيل الخروج...',
    'LBL_MOBILE_RELOGIN_BUTTON' => 'إعادة تسجيل الدخول',
    'LBL_MOBILE_META_SYNC_FAILED' => 'غير قادر على المزامنة مع الخادم.',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => 'غير قادر على المزامنة مع الخادم. إعادة المحاولة؟',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => 'الخصوصية، الشروط، والأحكام',
    'LBL_MOBILE_APP_VERSION' => 'إصدار التطبيق',
    'LBL_MOBILE_SERVER_VERSION' => 'إصدار الخادم',
    'LBL_MOBILE_SERVER_URL' => 'عنوان URL للخادم',
    'LBL_MOBILE_PTR_PULL' => 'اجذب لأسفل للتحديث...',
    'LBL_MOBILE_PTR_RELEASE' => 'حرر للتحديث...',
    'LBL_MOBILE_EDIT_REL' => 'تحرير العلاقة',
    'LBL_MOBILE_DESKTOP' => 'إصدار سطح المكتب',
    'LBL_MOBILE_DELETE_CONFIRM' => 'هل تريد بالتأكيد حذف هذا السجل؟',
    'LBL_MOBILE_UNLINK_CONFIRM' => 'هل تريد بالتأكيد إلغاء رابط هذا السجل؟',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => 'هل ترغب في تسجيل مكالمتك الأخيرة؟',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => 'اختيار مستلم',
    'LBL_MOBILE_CHOOSE_PHONE' => 'اختيار رقم هاتف',
    'LBL_MOBILE_CHOOSE_URL' => 'اختيار عنوان URL',
    'LBL_MOBILE_CHOOSE_DOC' => 'اختيار مستند',
    'LBL_MOBILE_CHOOSE_LOCATION' => 'اختيار موقع',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => 'لا تتوفر إجراءات',
    'LBL_MOBILE_FEEDBACK' => 'تعليقات',
    'LBL_MOBILE_DOC' => 'المستند',
    'LBL_MOBILE_DOWNLOAD_STARTED' => 'بدأ التنزيل: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => 'تم الانتهاء من التنزيل: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => 'يتم الآن تحميل ملف...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => 'تم تحميل الملف بنجاح',
    'LBL_MOBILE_PROCESSING_IMAGE' => 'يتم الآن إعداد الصورة...',
    'LBL_CLOSE_SAVE_BUTTON' => 'إغلاق المهمة والحفظ',
    'LBL_LATER' => 'لاحقًا',
    'LBL_USE_HTTPS' => 'استخدام اتصال آمن',
    'LBL_LOADING_FILES' => 'لا يزال تحميل قائمة المستند قائمًا. يرجى المحاولة مرة أخرى لاحقًا',
    'LBL_NEW_WEB_VERSION' => 'هناك إصدار جديد متاح لهذا التطبيق. هل ترغب في التحديث؟',
    'LBL_SET_FONTSIZE' => 'حجم الخط',
    'LBL_FONTSIZE_TINY' => 'دقيق',
    'LBL_FONTSIZE_SMALL' => 'صغير',
    'LBL_FONTSIZE_NORMAL' => 'عادي (افتراضي)',
    'LBL_FONTSIZE_LARGE' => 'كبير',
    'LBL_FONTSIZE_LARGER' => 'أكبر',
    'LBL_FONTSIZE_HUGE' => 'ضخم',
    'LBL_FONTSIZE_EXTRA_HUGE' => 'ضخم للغاية',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "فشل التنزيل\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => 'المزيد...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...أقل',
    'LBL_OFFLINE_MODE' => 'وضع عدم الاتصال',
    'LBL_OFFLINE_DELETED' => 'لم يتم العثور على السجل.',
    'LBL_OFFLINE_DELETED_RELATED' => 'لم يتم العثور على سجل ذي صلة. يُحتمل حذفه أو إلغاء ارتباطه.',
    'LBL_OFFLINE_PREFETCH_PROMPT' => 'تنزيل سجلاتك المحددة، والمفضلة، والمتبعة حيث قد يستغرق الدخول دون اتصال بعض الوقت للانتهاء. يُوصى باتصال سريع. هل ترغب في الاستمرار؟',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => 'هل ترغب في تنزيل سجلاتك المحددة، والمفضلة، والمتبعة الآن للدخول عليها دون اتصال؟ يُوصى بالاتصال السريع حيث قد تستغرق هذه العملية بعض الوقت. قد تقوم لاحقًا بالتنزيل من القائمة الرئيسية > دون الاتصال.',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => 'تم تنزيل السجلات بنجاح',
    'LBL_OFFLINE_PREFETCH_ACTION' => 'يتم الآن تنزيل سجلاتك...',
    'LBL_OFFLINE_PREFETCH_ERROR' => 'خطأ أثناء تنزيل السجلات',
    'LBL_OFFLINE_PREFETCHING' => 'يتم الآن تنزيل السجلات...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => 'تحميل {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => 'الوقت المتبقي هو{{estimatedTime}}ث...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => 'تم الانتهاء من{{module}} التنزيل',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => 'يتم الآن تنظيف المخزن...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => 'تم الانتهاء من التنظيف',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => 'هل ترغب في استرجاع هذا التغيير؟',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => 'تم الانتهاء من التراجع',
    'LBL_OFFLINE_ROLLBACK_FAILED' => 'فشل التراجع',
    'LBL_OFFLINE_CLEAR_DB' => 'مسح المخزن...',
    'LBL_OFFLINE_COMPACT_DB' => 'تخزين مضغوط...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => 'سيحذف هذا الإجراء السجلات التي لم تصل إليها منذ فترة. متابعة؟',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => 'هل ترغب في حذف كل السجلات من مخزنك المحلي؟',
    'LNK_OFFLINE_SETTINGS' => 'دون اتصال',
    'LBL_OFFLINE_SETTINGS' => 'تصحيح الإعدادات',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => 'لا توجد تغييرات تؤدي إلى تعليق المزامنة.',
    'LBL_OFFLINE_STATUS_PENDING_TX' => 'التغييرات تؤدي إلى تعليق المزامنة.',
    'LBL_OFFLINE_STATUS_ONLINE' => 'الجهاز متصل.',
    'LBL_OFFLINE_STATUS_OFFLINE' => 'الجهاز غير متصل.',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => 'غير قادر على الوصول إلى الخادم.',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => 'فشلت آخر محاولة للمزامنة. التحقق من سجل المعاملات.',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => 'المزامنة جارية...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => 'تمت مزامنة المعاملة.',
    'LBL_OFFLINE_ENABLE_PROMPT' => 'هل تريد بالتأكيد تشغيل الدعم دون اتصال؟',
    'LBL_OFFLINE_DISABLE_PROMPT' => 'هل تريد إيقاف تشغيل الدعم دون اتصال؟ سيتم فقدان كل التغييرات التي تؤدي إلى تعليق المزامنة.',
    'LBL_OFFLINE_ENABLED' => 'تفعيل وضع دون اتصال',
    'LBL_OFFLINE_DISABLED' => 'تعطيل وضع دون اتصال',
    'LBL_OFFLINE_STATS' => 'إحصائيات التخزين',
    'LBL_OFFLINE_SERVER_FETCH' => 'الجلب من الخادم...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => 'قام أحد الأشخاص بتعديل نفس السجل على الخادم. التأكيد على الدمج التلقائي لتغييراتك أو رفضها.',
    'LBL_OFFLINE_LAST_SYNC_TS' => 'آخر محاولة للمزامنة: {{ts}}',
    'LBL_ACTION_UPDATE' => 'تحديث',
    'LBL_ACTION_CREATE' => 'إنشاء',
    'LBL_ACTION_DELETE' => 'حذف',
    'LBL_ACTION_LINK' => 'الارتباط',
    'LBL_ACTION_UNLINK' => 'إلغاء الربط',
    'LBL_ACTION_FAVORITE' => 'المفضلة',
    'LBL_ACTION_FOLLOW' => 'متابعة',
    'LBL_ACTION_CREATE_EXPLANATION' => 'تم إنشاء {{module}} "{{name}}"',
    'LBL_ACTION_UPDATE_EXPLANATION' => 'تم تحديث {{module}} "{{name}}"',
    'LBL_ACTION_DELETE_EXPLANATION' => 'تم حذف {{module}} "{{name}}"',
    'LBL_ACTION_LINK_EXPLANATION' => 'تم ربط {{module}} "{{name}}" بـ {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_UNLINK_EXPLANATION' => 'تم فصل ارتباط {{module}} "{{name}}" عن {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_FOLLOW_EXPLANATION' => 'تمت متابعة {{module}} "{{name}}"',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => 'تم إلغاء متابعة {{module}} "{{name}}"',
    'LBL_ACTION_FAVORITE_EXPLANATION' => 'تمت إضافة {{module}} "{{name}}" إلى المفضلات',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => 'تم إلغاء إضافة {{module}} "{{name}}" إلى المفضلات',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => 'تم إنشاء {{module}} "{{name}}" بحيث يرتبط بـ {{relatedModule}} "{{relatedName}}"',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => 'أساسي',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => 'مرفوض',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => 'مقبول',
    'LBL_EMAIL_ACTION_SET_VALID' => 'صالح',
    'LBL_EMAIL_ACTION_SET_INVALID' => 'غير صالح',
    'LBL_ROLLBACK_BUTTON' => 'التراجع',
    'LBL_TX_LOG' => 'سجل المعاملات',
    'LBL_TX_LOG_DETAIL' => 'تفاصيل المعاملة',
    'LBL_RECORD_DELETED' => '(السجل المحذوف)',
    'LBL_NOT_AVAILABLE' => 'غير متاح',
    'LBL_FILE_SIZE' => 'حجم الملف',
    'LBL_FILE_SIZE_UNITS_B' => 'بايت',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'ميجابايت',
    'LBL_CHOOSE_ITEMS' => 'اختيار عناصر',
    'LBL_OFFLINE_DB_SIZE' => 'حجم قاعدة البيانات',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => 'السجلات حسب الوحدة',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => 'إجمالي عدد السجلات',
    'LBL_RECORD_NOT_FOUND' => 'لم يتم العثور على السجل.',
    'LBL_RELATED_RECORD_NOT_FOUND' => 'لم يتم العثور على سجل ذي صلة.',
    'LBL_NOT_AUTHORIZED' => 'غير مسموح لك بمشاهدة هذا السجل.',
    'LBL_MOBILE_PROCESSING_FILE' => 'يتم الآن تجهيز الملف...',
    'LNK_THIRD_PARTY_SOFTWARE' => 'برنامج من طرف آخر',
    'LNK_TERMS_OF_USE' => 'شروط الاستخدام',
    'LNK_PRIVACY_POLICY' => 'سياسة الخصوصية',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => 'تسجيل دخول فردي',
    'LBL_RECENTS' => 'الأحداث الأخيرة',
    'LBL_SHOWING_CACHED_DATA' => 'غير قادر على الوصول إلى الملقم. يتم عرض أحدث البيانات المتاحة ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => 'قم بإغلاق {{moduleSingular}} والحفظ',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => 'لوحة معلومات محددة',
    'LBL_MOBILE_SPECIFIC_MODULE' => 'وحدة محددة',
    'LBL_MOBILE_DEFAULT_VIEW' => 'شاشة البداية',
    'LBL_MOBILE_DEFAULT_MODULE' => 'الوحدة المحددة',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => 'لوحة المعلومات المحددة',
    'LBL_MOBILE_DEFAULT_DASHLET' => 'لوحة المعلومات المحددة',
    'LBL_ALL_DASHLETS' => 'كل لوحات المعلومات',
    'LBL_MOBILE_GLOBAL_SEARCH' => 'بحث شامل',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'اكتب @ لذكر مستخدم. اكتب # للإشارة إلى سجل.',
    'LBL_MOBILE_NEW_COMMENT' => 'تعليق جديد',
    'LBL_RECENTLY_VIEWED' => 'ما تم عرضه مؤخرًا',
    'LBL_FILE_STORED_LOCALLY' => 'تم تخزين الملف محليًا وستتم مزامنته بمجرد اتصال الجهاز بالإنترنت.',
    'LBL_IDM_USER_PROFILE_READONLY' => 'إذا كنت ترغب في تغيير حقول معينة غير قابلة للتحرير، الرجاء الاتصال بالمسؤول لإعلامه بشأن هذه التغييرات.',
    'LBL_ACTIVITY_POST' => '{{{value}}}على {{{link}}}',
    'LBL_COMMENTLOG_EMPTY' => 'لا تعليق',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => 'إظهار تعليقات {{{commentsLeft}}} التالية',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => 'طي',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => 'تأكيد إنشاء التعليق',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => 'لا يمكن أن يكون سجل التعليق فارغًا',
    'LBL_MOBILE_PDF_DOWNLOAD' => 'تنزيل {{{pdfTemplateName}}} PDF',

    'ERR_SYNC_FAILED' => 'غير قادر على المزامنة مع الخادم.',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => 'غير مسموح بالدخول.',
    'ERR_MOBILE_INVALID_CREDS' => 'اسم مستخدم أو كلمة مرور غير صالحة.',
    'ERR_MOBILE_SESSION_EXPIRED' => 'انتهت فترة جلستك.',
    'ERR_MOBILE_NOT_FOUND' => 'لم يتم العثور على مورد.',
    'ERR_MOBILE_TIMEOUT' => 'الخادم لا يستجيب.',
    'ERR_MOBILE_CONNECTION_FAILED' => 'لا يمكن الوصول إلى الخادم.',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => 'اتصال الإنترنت غير متاح.',
    'ERR_MOBILE_INTERNAL' => 'خطأ داخلي ({{{code}}}). يرجى المحاولة مرة أخرى لاحقًا.',
    'ERR_MOBILE_VALIDATION' => 'السجل غير صالح',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => 'خادم غير مطابق: {{{flavor}}}. المميزات المدعومة: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => 'إصدار الخادم غير مطابق: {{{version}}}. أقل إصدار مطلوب: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => 'خطأ. عنوان البريد الإلكتروني غير صالح.',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => 'نوع هذا المستند غير مدعوم.',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => 'فشلت المصادقة.',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => 'لم يتم العثور على المورد المطلوب.',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => 'خطأ داخلي في الخادم.',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => 'محظور.',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => 'الخدمة غير متاحة.',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => 'حدث خطأ غير متوقع.',
    'ERR_MOBILE_UPLOAD' => 'خطأ أثناء تحميل ملف',
    'ERR_MOBILE_FILE_PROCESSING' => 'خطأ في معالجة الملف',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => 'ذاكرة تخزين الجهاز غير متاحة',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => 'تطبيقك قديم ولم يعد مطابقًا بأي حال من الأحوال مع مثال {{{brandName}}} المتصل به هل ترغب في تنزيل أحدث إصدار من متجر التطبيقات؟',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => 'تغيرت تهيئة الخادم، وإعادة التحميل مطلوبة. متابعة؟',
    'ERR_MOBILE_CONFLICT' => 'قام أحد الأشخاص بتعديل نفس السجل على الخادم. التأكيد على الدمج التلقائي لتغييراتك أو رفضها.',
    'ERR_MOBILE_METADATA_CHANGED' => 'تغيرت تهيئة الخادم.',
    'ERR_MOBILE_FILE_READ' => 'فشلت قراءة الملف',
    'ERR_MOBILE_FILE_NOT_FOUND' => 'لم يتم العثور على ملف',
    'ERR_MOBILE_FILE_NOT_READABLE' => 'لم تتم قراءة الملف',
    'ERR_MOBILE_FILE_ABORTED' => 'تم رفض عملية القراءة',
    'ERR_MOBILE_FILE_SECURITY' => 'الملف مغلق',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => 'إصدار المحمول لا يدعم هذه الوظيفة. هل ترغب في فتح إصدار سطح المكتب؟',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => 'الملف كبير للغاية. أقصى حجم مسموح به هو {{size}}',
    'ERR_OFFLINE' => 'خطأ دون الاتصال',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => 'فشل فتح التخزين المحلي',
    'ERR_OFFLINE_STORAGE_CREATE' => 'فشل إنشاء التخزين المحلي',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => 'فشل إنشاء التخزين المحلي: لم تعد لديك مساحة تخزين.',
    'ERR_OFFLINE_OUT_OF_SPACE' => 'لم تعد لديك مساحة للتخزين المحلي.',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => 'فشل تنظيف قاعدة البيانات',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => 'لقد نفدت المساحة المخصصة للتخزين في وضع عدم الاتصال. يوصى بتنظيف مساحة التخزين. قد يستغرق ذلك عدة دقائق.',
    'ERR_OFFLINE_PREFETCH_FAILED' => 'فشل الجلب المسبق للسجلات من الخادم',
    'ERR_OFFLINE_SYNC_ERROR' => 'خطأ في المزامنة',
    'ERR_OFFLINE_SYNC_CONFLICT' => 'مشكلة في المزامنة',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => 'فشل الحصول على وقت بالخادم',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => 'فشل تمكين وضع دون اتصال. غير قادر على الوصول إلى الملقم.',
    'LBL_EXPORT_CSV' => 'تصدير CSV',
    'LBL_ERR_EXPORTING_CSV' => 'فشل التصدير',
    'LBL_ERR_EXPORT_ALL' => 'فشل إحضار البيانات للسجلات المحددة، الرجاء إعادة المحاولة',
    'LBL_LIST_SETTINGS_RESTORE' => 'استعادة الافتراضيات',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => 'استعادة الحقول؟',
    'LBL_LIST_SETTINGS_TITLE' => 'منشئ عرض القائمة',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => 'الحقول المتاحة',
    'LBL_LIST_SETTINGS_REMOVE' => 'إزالة',
    'LBL_LIST_SETTINGS_TEXT' => 'اسحب الحقول إلى داخل منشئ عرض القائمة وأعد ترتيبها لتصميم طريقة عرض قائمة {{moduleName}}.',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => 'يجب إضافة حقل واحد إلى التخطيط.',
    'LBL_LIST_SETTINGS_EMPTY' => 'لا حقول متاحة',
    'LBL_LIST_SETTINGS_NO_MATCHING' => 'لم يتم العثور على حقول مطابقة',
    'LBL_LIST_FILTER' => 'بحث عن حقل',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => 'عميل البريد الإلكتروني',
    'LBL_DEFAULT_SYSTEM_CLIENT' => 'عميل بريد إلكتروني خارجي',
    'LBL_SUGAR_MOBILE_CLIENT' => 'عميل بريد إلكتروني Sugar',
    'LBL_OFFLINE_CAPABILITIES' => 'تمكين القدرات دون اتصال',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => 'فشل حذف المعاملة.',
    'LBL_OFFLINE_TRANSACTION_DELETED' => 'تم حذف المعاملة.',
    'LBL_SECURE_MODE' => 'وضع الأمان المحسن',
    'LBL_SECURE_MODE_ANDROID_TEXT' => 'قم بتمكين هذا الإعداد لإخفاء محتويات Sugar Mobile عندما يكون التطبيق في الخلفية ولمنع لقطات الشاشة للتطبيق في أي وقت.',
    'LBL_SECURE_MODE_IOS_TEXT' => 'قم بتمكين هذا الإعداد لإخفاء محتويات Sugar Mobile عندما يكون التطبيق في الخلفية.',
    'LBL_ALWAYS_OFFLINE_MODE' => 'وضع دون اتصال دائمًا',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => 'أنت تعمل في وضع دون اتصال دائمًا. هل ترغب بإعادة الاتصال؟',
    'LBL_RECONNECT' => 'إعادة الاتصال',
    'LBL_STAY_OFFLINE' => 'البقاء دون اتصال',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => 'الوحدة التي تحاول الوصول إليها غير متوفرة في Sugar Mobile.',
    'LBL_MOBILE_RELEASE_NOTE' => 'ملاحظات إصدار Sugar Mobile لـ {{platform}}',
    'LBL_MOBILE_USER_GUIDE' => 'دليل مستخدم Sugar Mobile لـ {{platform}}',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => 'الاحتواء على هذه الكلمات',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => 'استبعاد هذه الكلمات',
    'LBL_NOTIFICATIONS_CHANNEL' => 'التحديثات',
    'LBL_APPLY_BUTTON_LABEL' => 'تطبيق',
    'LBL_ACTION_CREATE_FAILURE' => "فشل حفظ السجل:\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "فشل تحديث السجل:\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => 'فشل حل حسابات الحقول على الخادم.',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => 'الحقول التالية غير صحيحة: {{{fields}}}.',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>نجاح.</b> لقد أنشأت بنجاح {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}".</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>نجاح.</b> لقد حدثت السجل بنجاح',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => 'فشل الحصول على بيانات البريد الإلكتروني من الخادم.',
    'LBL_ASSIGN_SUCCESS' => '<b>نجاح.</b> تم تعيين السجل إلى {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => 'حفظ هذا البريد الإلكتروني كمسودة؟',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => 'حفظ كمسودة',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => 'تجاهل البريد الإلكتروني',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => 'إذا لم تحفظ المسودة، فستفقد هذا البريد الإلكتروني.',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => 'تحديد التوقيع',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => 'تحديد قالب البريد الإلكتروني',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => 'سيكتب القالب فوق كل المحتويات في هذا البريد الإلكتروني. هل تريد بالتأكيد استخدام هذا القالب والكتابة فوق المحتوى؟',
    'LBL_MOBILE_EMAIL_COMPOSE' => 'إنشاء بريد إلكتروني',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => 'يحتوي بريدك الإلكتروني على متغيرات سيتم استبدالها باستخدام القيم من السجل "مرتبط بـ". الرجاء التأكد من تعيين حقل "مرتبط بـ" بشكل صحيح قبل الإرسال.',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => 'لم يتم العثور على حساب البريد الإلكتروني الصادر. الرجاء الاتصال بمسؤول Sugar.',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' و{{{count}}} آخرين',
    'LBL_RECEPIENTS_EMAIL_ADD' => 'إضافة بريد إلكتروني',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => 'اكتب اسم جهة اتصال أو عنوان بريد إلكتروني',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (بريد إلكتروني جديد)',
    'LBL_TEMPLATE_HAS_VARIABLES' => 'المتغيرات',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => 'قوالب البريد الإلكتروني',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => 'قوالب الحملة',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => 'قوالب سير العمل',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => 'قوالب النظام',
    'LBL_FILTER_EDIT' => 'تحرير عامل التصفية',
    'LBL_FILTER_MY_FILTER' => 'عامل التصفية الخاص بي',
    'LBL_FILTER_MY_FILTER_BY' => 'عامل التصفية الخاص بي بحسب {{{filters}}}',
    'LBL_FILTER_SAVE' => 'حفظ عامل التصفية',
    'LBL_SELECT_PARAM' => 'تحديد',
    'LBL_SELECT_MODULES' => 'محدد الوحدة',
    'LBL_SELECT_ADDITIONAL_PARAMS' => 'تحديد معامل إضافي',
    'LBL_FILTER_TEMPORARY' => 'عامل تصفية مؤقت',
    'LBL_ERROR_FILE_UPLOAD' => 'فشل تحميل الملف {{{fieldLabel}}} "{{{fileName}}}". {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">عرض السجل الفاشل</a>',
    'LBL_FILE_UPLOAD_ONE' => 'جارٍ حفظ الملف...',
    'LBL_FILE_UPLOAD_MANY' => 'جارٍ حفظ الملف {{{index}}} من {{{total}}}...',
    'LNK_NOTIFICATIONS_SETTINGS' => 'إعدادات الإشعارات',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => 'إدارة إشعارات الدفع',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "تحكم بطريقة ظهور الإشعارات باستخدام إعدادات إشعار الجهاز.",
    'LBL_NOTIFICATION_ASSIGMENTS' => 'التعيينات',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => 'تَسلم إشعارات عند تعيين سجلات إليك.',
    'LBL_NOTIFICATION_MENTIONS' => 'الإشارات',
    'LBL_NOTIFICATION_MENTIONS_DSC' => 'تسلم إشعارات عند إشارة أحد الأشخاص إليك في إدخالات سجل تعليق.',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => 'لم تتم إضافة حقل سجل التعليق إلى هذا التخطيط من مسؤول. الرجاء الاتصال بمسؤول Sugar.',
    'ERR_NO_PERMISSION_TITLE' => 'الرجاء السماح بالوصول',
    'ERR_NO_CAMERA_PERMISSION_MSG' => 'يحتاج {{{brandName}}} إلى الوصول إلى الكاميرا ليمكنك إرفاق الصور. الرجاء السماح بالوصول إلى الكاميرا في إعدادات النظام.',
    'LBL_MOBILE_SYSTEM_SETTINGS' => 'الإعدادات',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => 'المدة',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => 'الوقت المتبقي',
    'LBL_LIST_SUPPORT_EXPIRES' => 'انتهاء',
    'LBL_CASCADE_RLI_EDIT' => 'تحديث بنود العائدات المفتوحة',
    'LBL_MOBILE_CALENDAR' => 'التقويم',
    'LBL_MOBILE_CALENDAR_SETTINGS' => 'إعدادات التقويم',
    'LBL_MOBILE_CALENDAR_WEEK_START' => 'تاريخ بدء الأسبوع',
    'LBL_MOBILE_CALENDAR_MODULES' => 'الأحداث التي ستعرض',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}س:{{{minutes}}} دقائق',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} ساعات',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} دقائق',
    'LBL_MOBILE_CALENDAR_TODAY' => 'اليوم',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => 'إضافة {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => 'جدولة نشاط',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => 'يرجى تمكين نوع حدث واحد على الأقل.',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => 'طوال اليوم',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => 'فشل تحميل التقويمات.',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => 'هذا الإجراء غير متاح في Sugar Mobile. هل تريد فتح تطبيق سطح المكتب بدلاً من ذلك؟',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => 'تحديد قالب',
    'LBL_DOC_MERGES_ACTION_MERGE' => 'دمج',
    'LBL_ERROR_IMAGE_NO_EXIF' => 'خطأ: بيانات EXIF مفقودة من ملف HEIC',
    'LBL_ERROR_IMAGE_TOO_BIG' => 'خطأ: دقة الصورة مرتفعة جدًا',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => 'خطأ: لا يمكن معالجة الصورة',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => 'خطأ: فشل عرض الصورة على اللوحة',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => 'خطأ: فشل تحميل الملف كصورة',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => 'تم تحديد عنصر واحد',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => 'تم تحديد {{{count}}} عناصر',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => 'تحديد الكل',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => 'لقد حددت {{{count}}} سجلات في هذا العرض. هل تريد تحديد كل السجلات؟',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => 'تحديد {{{count}}} سجلات',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => 'هل تريد بالتأكيد حذف السجل (السجلات) المحددة؟',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => 'جارٍ حذف… {{{count}}} من {{{total}}}',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => 'لم يتم العثور على بريد إلكتروني صالح في السجلات المحددة',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => 'المظهر',
    'LBL_MOBILE_APP_THEME_SYSTEM' => 'استخدام إعداد النظام',
    'LBL_MOBILE_APP_THEME_LIGHT' => 'فاتح',
    'LBL_MOBILE_APP_THEME_DARK' => 'داكن',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => 'اسم ملف جديد',
    'LBL_ATTACHMENT_RENAME_MSG' => 'إعادة تسمية الملف',
    // Filters related
    'LBL_CREATED_BY_ME' => 'إنشاء بواسطتي',
    'LBL_OPERATOR_ONE_OF' => 'هو واحد من',
    'LBL_OPERATOR_NOT_ONE_OF' => 'ليس واحدًا من',
    'LBL_OPERATOR_CONTAINS' => 'أي من',
    'LBL_OPERATOR_CONTAINS_WORD' => 'يحتوي على',
    'LBL_OPERATOR_NOT_CONTAINS' => 'ليس من',
    'LBL_OPERATOR_EMPTY' => 'فارغ',
    'LBL_OPERATOR_NOT_EMPTY' => 'ليس فارغًا',
    'LBL_OPERATOR_MATCHES' => 'يطابق تمامًا',
    'LBL_OPERATOR_STARTS_WITH' => 'يبدأ بـ',
    'LBL_OPERATOR_EQUALS' => 'يساوي',
    'LBL_OPERATOR_NOT_EQUALS' => 'لا يساوي',
    'LBL_OPERATOR_GREATER_THAN' => 'أكبر من',
    'LBL_OPERATOR_LESS_THAN' => 'أقل من',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => 'أكبر من أو يساوي',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => 'أقل من أو يساوي',
    'LBL_OPERATOR_BETWEEN' => 'بين',
    'LBL_OPERATOR_BEFORE' => 'قبل',
    'LBL_OPERATOR_AFTER' => 'بعد',
    'LBL_OPERATOR_YESTERDAY' => 'أمس',
    'LBL_OPERATOR_TODAY' => 'اليوم',
    'LBL_OPERATOR_TOMORROW' => 'غدًا',
    'LBL_OPERATOR_LAST_7_DAYS' => 'آخر 7 أيام',
    'LBL_OPERATOR_NEXT_7_DAYS' => 'الـ 7 أيام القادمة',
    'LBL_OPERATOR_LAST_30_DAYS' => 'آخر 30 يومًا',
    'LBL_OPERATOR_NEXT_30_DAYS' => 'الـ 30 يومًا التالية',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => 'منذ أكثر من __ أيام',
    'LBL_OPERATOR_LAST_X_DAYS' => 'آخر __ أيام',
    'LBL_OPERATOR_NEXT_X_DAYS' => 'الـ __ أيام القادمة',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => 'أكثر من __ أيام في المستقبل',
    'LBL_OPERATOR_LAST_MONTH' => 'الشهر الماضي',
    'LBL_OPERATOR_THIS_MONTH' => 'هذا الشهر',
    'LBL_OPERATOR_NEXT_MONTH' => 'الشهر التالي',
    'LBL_OPERATOR_LAST_YEAR' => 'السنة الماضية',
    'LBL_OPERATOR_THIS_YEAR' => 'هذه السنة',
    'LBL_OPERATOR_NEXT_YEAR' => 'السنة القادمة',
    'LBL_OPERATOR_IS' => 'هو',
    'LBL_OPERATOR_IS_NOT' => 'ليس هو',
    'LBL_OPERATOR_AFTER_TODAY' => 'بعد اليوم',
    'LBL_OPERATOR_BEFORE_TODAY' => 'قبل اليوم',
    'LBL_ERROR_FILTER_EMPTY' => 'الرجاء إضافة معايير تصفية.',
    'LBL_ADD_FILTER' => 'إضافة معايير',
    'LBL_FILTER_NAME' => 'اسم عامل التصفية',
    'LBL_FILTER_FIELD' => 'الحقل',
    'LBL_FILTER_OPERATOR' => 'المعامل',
    'LBL_FILTER_VALUE' => 'القيمة',
    'LBL_FILTER_SYNC_TO_SERVER' => 'حفظ إلى تطبيق سطح المكتب',
    'LBL_FILTER_LOCAL' => 'عامل التصفية المحلي',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => 'مرحبًا بكم {{{brandName}}}.<br/><br/> تتيح لنا إمكانية تمييز بعض الخواص الجديدة...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => 'التنقل داخل القائمة الرئيسية.',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => 'الإجراءات المتاحة حسب العرض.',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => 'البحث العام عن السجلات.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => 'تصفية القائمة لعرض سجلاتي المفضلة.',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => 'تصفية القائمة لعرض السجلات المخصصة لي.',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => 'وضع علامة على السجل كمفضلة.',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => 'أحداثي القادمة بدايةً من اليوم.',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => 'أكثر السجلات المعدلة مؤخرًا.',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => 'الإجراءات المتاحة في السجل.',
    'LBL_MOBILE_TUTORIAL_HOME_END' => 'استمتع بجميع الميزات الجديدة!',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => 'هذه قائمة إضافية.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => 'أغلق القائمة الإضافية.',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => 'حدد إجراءً معينًا لعرضه والقيام به.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => 'هذه قائمة رئيسية.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => 'أغلق القائمة الرئيسية.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => 'اعرض وحدة معينة.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => 'قم بتخصيص التطبيق.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => 'افتح Sugar في مستعرض الشبكة.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => 'اعرض ملف التعريف الخاص بك.',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => 'هذه صفحة التفاصيل.',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => 'أكثر المعلومات أهمية عن السجل.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => 'اعرض معلومات إضافية، أو قم بتعديل السجل.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => 'الإجراءات المتاحة في السجل.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => 'الذهاب إلى الصفحة السابقة.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => 'الدخول إلى جولة في أي وقت.',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => 'الرجوع.',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => 'انقر لفتح سجل ذي صلة.',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => 'متابعة/إلغاء متابعة سجل.',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => 'انقر لتوسيع معلومات تفصيلية.',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => 'عرض القائمة الرئيسية.',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => 'تفتح القائمة الرئيسية في الجانب الأيسر من شاشتك.',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => 'عرض التفاصيل',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => 'تفتح عرض التفاصيل على الجانب الأيمن من شاشتك.',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => 'استخدم الأسهم أدناه للتفقد السريع عبر مكونات هذه القائمة الأساسية.',

    'LBL_COMMENT_ADD' => 'إضافة تعليق',
    'LBL_REQUIRED' => 'مطلوب',
    'LBL_MORE_BUTTON' => 'المزيد',
    'LBL_NO_OPTIONS' => 'لا خيارات متاحة',
    'LBL_TRY_AGAIN' => 'المحاولة مرة أخرى',
    'LBL_NEW_RECORDS' => 'تم إنشاؤه مؤخرًا',
    'LBL_ASSIGNED_TO_ME' => '{{{module}}} الخاصة بي',
    'LBL_LISTVIEW_FILTER_ALL' => 'كل {{{module}}}',
    'LBL_UNFAVORITE' => 'إلغاء تفضيل',
    'LBL_ACTIVITY_CREATE' => 'تم إنشاء {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => 'تم تحديث {{{changes}}} في {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => 'تم ربط {{{relatedRecord}}} بـ {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => 'تم إلغاء ربط {{{relatedRecord}}} من {{{record}}} {{{module}}}',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} لـ {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => 'تنزيل السجلات ذات الصلة...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => 'تم تغيير تكوين لوحة المعلومات. هل تريد إعادة التحميل؟',
    'LBL_RECORDS' => 'السجلات',
    'LBL_DASHBOARDS' => 'لوحات المعلومات',
    'LBL_TEMPLATES' => 'القوالب',
    'LBL_NON_TEMPLATES' => 'لا توجد قوالب',
    'LBL_IS_TEMPLATE' => 'عبارة عن قالب',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => 'يضم اختيارك قوالب لوحة المعلومات التي لا يمكن تحديثها بالكامل. يرجى إلغاء تحديد القوالب للاستمرار.',
    'LBL_UNSELECT_DELETE_TEMPLATES' => 'يضم اختيارك قوالب لوحة المعلومات التي لا يمكن حذفها بالكامل. يرجى إلغاء تحديد القوالب للاستمرار.',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => 'بحث عن {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => 'القائمة الرئيسية',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => 'إنشاء سريع لسجل جديد',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => 'مرر لمزيد من الخيارات',
    'LBL_DETAILS' => 'التفاصيل',
    'LBL_DETAIL_RELATED' => 'ذو صلة',
    'LBL_CREATE_RELATED_MODULE_WARN' => 'تتطلب {{module}} {{relatedModule}}. <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>إنشاء سجل {{relatedModule}}</a>.',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => 'تحرير السجل',
    'LBL_OFFLINE_MENU_SETTINGS' => 'إعدادات عدم الاتصال',
    'LBL_OFFLINE_DEBUG_SETTINGS' => 'تصحيح الإعدادات',
    'LBL_OFFLINE_TOTAL_RECORDS' => 'إجمالي السجلات',
    'LBL_OFFLINE_LAST_DOWNLOAD' => 'آخر تنزيل',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => 'تعذر تنزيل الملف.',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => 'فشل تحميل لوحات المعلومات من الخادم',
    'ERR_FILTERS_FETCHING' => 'تعذر جلب عوامل التصفية',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => 'فشل تشفير التخزين المحلي',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => 'يجري تشفير بيانات عدم الاتصال. قد يستغرق ذلك عدة دقائق.',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => 'اكتمل تشفير بيانات عدم الاتصال.',
    'ERR_ACCESS_SPECIFIC_MODULE' => 'ليس لك حق الوصول إلى الوحدة {{{module}}}.',
    'LBL_SKIP' => 'تخطي',
    'LBL_CONTINUE' => 'استمرار',
    'LBL_ENABLE' => 'تمكين',
    'LBL_MOBILE_TRIAL_UNTIL' => 'تجربة حتى',
    'LBL_MOBILE_SDK_VERSION' => 'إصدار SDK',
    'LBL_LOG_LEVEL' => 'مستوى السجل',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => 'تم إعادة تكوين إعدادات تسجبل الدخول.',
    'LBL_TRIAL_PERIOD_EXPIRED' => 'انتهت صلاحية فترة التجربة.',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => 'الخادم لا يدعم الاتصال الآمن. الرجاء إيقاف الاتصال الآمن.',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => 'الخادم يدعم الاتصال الآمن. الرجاء تشغيل الاتصال الآمن.',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => 'اتصالك غير آمن. اتصل بالمسؤول.',
    'LBL_LOGIN_SETTINGS_HEADER' => 'إعدادات تسجيل الدخول',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => 'قم بإعداد مثيل {{{brandName}}}',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => 'كي يعمل التطبيق، سوف تحتاج إلى كتابة عنوان URL لمثيل {{{brandName}}}. إذا لم تكن تملكه، الرجاء الاتصال بالمسؤول.',
    'LBL_FACEID' => 'معرف الوجه',
    'LBL_TOUCHID' => 'معرف اللمس',
    'LBL_ENABLE_TOUCHID' => 'تمكين {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => 'إعداد {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => 'تسجيل الدخول باستخدام الإصبع',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "لم يتم إعداد {{{biometryType}}} على جهازك. \n\nانتقل إلى إعدادات الجهاز لإعداد {{{biometryType}}}. بمجرد الإعداد، قم بتمكين {{{biometryType}}} لـ {{{brandName}}} في القائمة الرئيسية > الإعدادات.",
    'LBL_TOUCH_ID_DISCLAIMER' => 'سيسمح استخدام {{{biometryType}}} مع {{{brandName}}} باستخدام المعرف البيولوجي بدلاً من إدخال كلمة المرور للوصول إلى {{{brandName}}}.',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => 'هل ترغب في المتابعة مع {{{biometryType}}}؟    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => 'أدخل كلمة مرور {{{brandName}}} لتمكين {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => 'الإعداد',
    'LBL_MDM_CONFIRM_CHANGE' => 'تم تغيير تكوين التطبيق من مدير الجهاز المحمول. الرجاء إعادة تسجيل الدخول لتطبيق التغييرات.',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => 'الرجاء منح {{{brandName}}} الوصول إلى موقعك عبر إعدادات الجهاز.',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => 'الموقع الحالي غير متاح',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "انتهت مهلة استرداد الموقع الحالي. \nالرجاء إعادة المحاولة.",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => 'علامات الموقع غير متاحة',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => 'إحداثيات الموقع غير صحيحة',
    'ERR_MOBILE_INVALID_PASSWORD' => 'كلمة مرور غير صحيحة.',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => 'تطبيقك قديم ولم يعد متوافقًا مع مثيل {{{brandName}}} الذي تتصل به. هل تريد تحديثه؟',
    'LBL_MOBILE_BY' => 'بواسطة',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => 'عامل التصفية غير متاح أثناء عدم الاتصال',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => 'سجلات عدم الاتصال',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => 'تنزيل الإعدادات',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => 'قم بتنزيل السجلات المعينة والمفضلة والمُتابعة للوصول أثناء عدم الاتصال. يمكنك تحديث تفضيلاتك في الإعدادات أثناء عدم الاتصال.',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => 'انتهى تنزيل سجلاتك. يمكنك الآن الوصول إليها في وضع عدم الاتصال.',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "لم يتم تنزيل جميع سجلاتك.\n هل تريد إعادة المحاولة؟",
    'LBL_BULK_LOAD_USE_CELLULAR' => 'استخدام البيانات الخلوية',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => 'ليس الآن',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => 'توقف التنزيل مؤقتًا وسيتم استئنافه عند فتح التطبيق مرة أخرى.',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => 'يجري تنزيل {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => 'تحديث آخر السجلات',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => 'بانتظار الاتصال',
    'LBL_BULK_LOAD_STATUS_PAUSED' => 'تم الإيقاف المؤقت',
    'LBL_BULK_LOAD_STATUS_STOPPING' => 'يجري الإيقاف',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => 'تنزيل',
    'LBL_BULK_LOAD_BTN_PAUSE' => 'إيقاف مؤقت',
    'LBL_BULK_LOAD_BTN_RESUME' => 'استئناف',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => 'فقط الاتصالات اللاسلكية هي التي تستخدم افتراضيًا',
    'LBL_NPS_RATING_MSG' => "كيف تُقيم تجربتك \nمع {{{productName}}}؟",
    'LBL_NPS_THANKS_MSG' => 'شكرًا لملاحظاتك!',
    'LBL_NPS_APPSTORE_RATE_MSG' => 'هل تتفضل بتقييمنا على متجر التطبيقات؟',
    'LBL_NPS_NO_THANKS' => 'لا، شكرًا',
    'LBL_NPS_NOT_NOW' => 'ليس الآن',
    'LBL_NPS_RATE_NOW' => 'التقييم الآن',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => 'الشبكة غير متوفرة. ما يزال بإمكانك استخدام التطبيق أثناء عدم الاتصال',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => 'ستتم مزامنة تغييراتك عندما تكون متصلاً. <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>انظر التفاصيل</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => 'هناك بيانات لم تتم مزامنتها. الرجاء مراجعة <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>سجل المعاملة</a>',
    'LBL_CONVERT' => 'تحويل',
    'LBL_CONVERT_LEAD' => 'تحويل العميل المتوقع',
    'LBL_SEARCH_EXISTING_RECORD' => 'بحث {{{this}}} الحالي',
    'LBL_DUPLICATES_CHECK_FAILED' => 'فشل فحص التكرارات',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => 'هل تريد تحريك الأنشطة ذات الصلة إلى سجل الاتصال؟',
    'LBL_LEAD_CONVERSION_SUCCESS' => 'لقد نجحت في تحويل العميل المتوقع {{{name}}}',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => 'لم يتم العثور على تكرارات.',
    'ERR_LEAD_CONVERSION_FAIL' => 'فشل تحويل العميل المتوقع',
    'LBL_SELECT_DUPLICATE_RECORD' => 'تحديد من {{{modulePlural}}} مكررة',
    'LBL_SELECTED_EXISTING_RECORD' => '{{{moduleSingular}}} المحددة',
    'LBL_CREATED_NEW_RECORD' => 'تم إنشاء {{{moduleSingular}}} جديدة',
    'LBL_VO_BACK_BTN' => 'زر السابق',
    'LBL_VO_HOME_BTN' => 'زر الصفحة الرئيسية',
    'LBL_VO_DASHBOARD_BTN' => 'زر لوحة المعلومات',
    'LBL_VO_SEARCH_BTN' => 'زر البحث',
    'LBL_VO_RIGHT_MENU_BTN' => 'زر القائمة اليمنى',
    'LBL_VO_ADD_BTN' => 'زر الإضافة',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => 'الخصم',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => 'تحديد تطبيق تخطيط',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => 'قيمة {{entityName}} المحددة لها القيم المرتبطة: {{localizedFieldNames}}. قم بالإلغاء للاحتفاظ بالقيم الموجودة. قم بالتأكيد للكتابة فوق تلك القيم بالقيم الجديدة.',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => 'تم تمكين تشفير البيانات.',
    'LBL_LEAD_ALREADY_CONVERTED' => 'العميل المتوقع المحدد تحول بالفعل.',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => 'لا يتوفر هذا الإجراء إلا عندما يكون الجهاز متصلاً بالإنترنت',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => 'هل تريد بالتأكيد إنشاء فرصة من عرض السعر؟',
    'LBL_TAG_ADD' => 'إضافة علامة',
    'LBL_TAG_ENTER_TAG_NAME' => 'إدخال العلامة',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => 'التصفية بحسب العلامات غير مدعومة عندما يكون الجهاز غير متصل بالإنترنت.',
    'LBL_COMMENTLOG_SHOWCOMMENT' => 'إظهار التعليق بأكمله',
    'LBL_COMMENT_VIEW' => 'عرض تعليق',
    'LBL_PMSE_LABEL_DUEDATE' => 'تاريخ الاستحقاق',
    'LBL_PMSE_DUE' => 'مستحق',
    'LBL_PMSE_DUE_ON' => 'مستحق في',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => 'الرجاء إنشاء {{conversionParentModuleName}} أولاً',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => 'سجلات مطلوبة مفقودة: {{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => 'اختر جودة الصورة. سيتم تغيير حجم الصورة وفقًا لذلك قبل حفظها على الخادم. ستستخدم القيمة المحددة كقيمة افتراضية لكل العمليات المشابهة في المستقبل.',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => 'جارٍ تقدير حجم الملف...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => 'الحجم التقديري للملف هو',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => 'جودة الصورة',
    'LBL_IMAGE_QUALITY_BEST' => 'الحجم الأصلي',
    'LBL_IMAGE_QUALITY_GOOD' => 'جودة جيدة',
    'LBL_IMAGE_QUALITY_POOR' => 'حجم صغير',
    'LBL_IMAGE_QUALITY_BTN' => 'الضغط: {{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => 'عرض الحقول في {{module}}',
    'LBL_LIST_RESET_FIELDS' => 'إعادة التعيين إلى القيم الافتراضية',
    'LBL_LIST_NOT_ENOUGH' => 'الرجاء ضبط سجل واحد نشط على الأقل.',
    'LBL_LOGIN_PERMISSION_ABORTED' => 'تحتاج إلى تسجيل الدخول وقبول الأذونات ليمكنك العمل على مثيل SugarCRM.',
    'LBL_SELECTING_EXISTING_RECORD' => 'تحديد {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => 'إنشاء {{{moduleSingular}}} جديد',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => 'حجم الصورة',
    'LBL_COPY_ADDRESS' => 'نسخ العنوان',
    'LBL_OPEN_IN' => 'فتح في',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => 'لم يتم تحديد ملف.',
    'LBL_ATTACHMENT_ADD' => 'إرفاق',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => 'هذا التطبيق يستخدم ملفات تعريف ارتباط',
    'LBL_USE_COOKIES_CONFIRM' => 'يستخدم هذا التطبيق ملفات تعريف ارتباط للمساعدة في تمتعك بتجربة استخدام أفضل. تعني متابعتك موافقتك على استخدام ملفات تعريف الارتباط بما يتوافق مع سياسة الخصوصية لدينا.',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => 'أنت تستخدم مثيل Sugar لن يتوافق مع Sugar Mobile في إصدار هاتف محمول قادم. اطلب من المسؤول لديك ترقية Sugar بأسرع ما يمكن.',
    'ERROR_TAG_NAME_INVALID' => 'لا يمكن أن يحتوي اسم العلامة على الأحرف "{{{forbiddenChars}}}"',
    'ERROR_NO_TAGS_FOUND' => 'لا علامات متاحة تطابق "{{{searchQuery}}}"',
    'ERR_PA_RECORD_INVALID' => 'يملك السجل {{{moduleName}}} قيمة غير صحيحة واحدة أو أكثر ولا يمكن حفظه. هل تريد تحرير السجل من أجل تنفيذ إجراء {{{actionLabel}}}؟',
    'ERR_MOBILE_METADATA_RELOAD' => 'أجرى مسؤول تغييرات على تكوين مثيل Sugar. اضغط على "موافق" لمزامنة تكوين تطبيقك مع الخادم.',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => 'هذا التطبيق يستخدم ملفات تعريف ارتباط',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => 'حدد للقبول (إجباري)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => 'يستخدم هذا التطبيق ملفات تعريف ارتباط للمساعدة في تزويدك بتجربة افضل. تعني متابعتك موافقتك على استخدام ملفات تعريف الارتباط بالتوافق مع <a href="{{href}}" target="_blank">سياسة الخصوصية</a> الخاصة بنا.',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => 'سيتيح لك عرض السجل مشاهدة تفاصيل سجل.',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'ستتيح لك الملاحظات التعاون مع مستخدمي المنفذ الآخرين ودعم المندوبين.',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => 'انقر هنا لإضافة ملاحظة على هذا السجل.',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => 'انقر فوق تلك الرموز لعرض تفاصيل الملاحظات المرفقة.',

    //for portal
    'LBL_PORTAL_HOME' => 'لوحة المعلومات الرئيسية',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => 'كل الحالات المفتوحة',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => 'الحالات التي تم حلها مؤخرًا',
    'LBL_PORTAL_SEARCH' => 'البحث حسب الاسم والرقم',
    'LBL_SIGNUP_BUTTON_LABEL' => 'الاشتراك',
    'LBL_PORTAL_NO_EMAIL' => 'لم تتلق رسالة بريد إلكتروني؟',
    'LBL_PORTAL_FORGOT_PASSWORD' => 'نسيت كلمة المرور',
    'LBL_PORTAL_FORGOT_USERNAME' => 'نسيت اسم المستخدم',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => 'أدخل كلمة مرورك مرتين. يجب أن تتطابق كلمتا المرور.',
    'LBL_PORTAL_RESET_PASSWORD' => 'إعادة تعيين كلمة المرور',
    'LBL_PORTAL_REENTER_PASSWORD' => 'إعادة إدخال كلمة المرور',
    'LBL_PORTAL_PASSWORD_MISMATCH' => 'كلمتا المرور غير متطابقتين، الرجاء إدخالهما مرة أخرى',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => 'تمت إعادة تعيين كلمة مرورك بنجاح.',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => 'حدث خطا. الرجاء بدء طلب إعادة تعيين كلمة مرور جديد.',
    'LBL_PORTAL_SIGNUP_PROCESS' => 'التسجيل',
    'LBL_PORTAL_SIGNUP_TITLE' => 'شكرًا لك على التسجيل',
    'LBL_PORTAL_SIGNUP' => 'سوف نبلغك بعد تأكيد بياناتك.',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => 'الاسم الأول',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => 'الاسم الأخير',
    'LBL_PORTAL_SIGNUP_USER_NAME' => 'اسم المستخدم',
    'LBL_PORTAL_SIGNUP_EMAIL' => 'عنوان البريد الإلكتروني',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (اختياري)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => 'البلد',
    'LBL_PORTAL_SIGNUP_STATE' => 'الولاية',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => 'اسم الشركة',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => 'المسمى الوظيفي (اختياري)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => 'كلمة المرور',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => 'تأكيد كلمة المرور',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => 'نسيت بيانات تسجيل الدخول',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => 'نسيت كلمة المرور؟',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => 'يرجى الاتصال بمسؤول Sugar لإعادة تعيين كلمة المرور الخاصة بك.',
    'LBL_PORTAL_LOGIN_USERNAME' => 'اسم المستخدم',
    'LBL_PORTAL_LOGIN_PASSWORD' => 'كلمة المرور',
    'LBL_PORTAL_LOADING' => 'التحميل',
    'LBL_PORTAL_SAVING' => 'حفظ',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => 'الصفحة غير متاحة',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "نعتذر لك، هذه الخاصية غير متاحة في هذا الوقت.",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => 'عرض نتائج البحث عن "{query}"',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => 'لم تتلق رسالة بريد إلكتروني؟',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => 'للمساعدة، أو للاتصال بنا، الرجاء استخدام أي مما يلي: ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => 'الهاتف: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => 'البريد الإلكتروني: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => 'الويب: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => 'هل تريد بالتأكيد إغلاق الدردشة؟',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => 'إنشاء ملاحظة أو إضافة مرفق',
    'LBL_PORTAL_NEW_NOTE_BTN' => 'إضافة ملاحظة',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => 'لم يكن تسجيل دخولك ناجحًا. الرجاء المحاولة مرة أخرى.',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => 'اعتمادات غير صالحة',
    'LBL_PORTAL_INVALID_GRANT' => 'الرمز الخاص بك انتهت صلاحيته. يرجى تسجيل الدخول مرة أخرى.',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => 'انتهت صلاحية الجلسة',
    'LBL_PORTAL_AUTH_FAILED' => 'فشلت مصادقة العميل.',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => 'عميل غير صالح',
    'LBL_PORTAL_INVALID_REQUEST' => 'الطلب غير صالح أو به عيوب. يرجى الاتصال بالدعم الفني.',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => 'طلب غير صالح',
    'LBL_PORTAL_REQUEST_TIMEOUT' => 'انتهى زمن الطلب.',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => 'انتهاء زمن الطلب',
    'LBL_PORTAL_UNAUTHORIZED' => 'عذرًا، يبدو أنك غير مسموح لك بالدخول إلى هذا المورد.',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'غير مسموح',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => 'المورد غير متاح.',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'ممنوع',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => 'غير مسموح بطريقة HTTP لهذا المورد. يرجى الاتصال بالدعم الفني.',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'غير مسموح بالطريقة',
    'LBL_PORTAL_PRECONDITION_MISSING' => 'فشل الطلب، أو، المعلمة مفقودة/غير صالحة. يرجى الاتصال بالدعم الفني.',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => 'خطأ: ',
    'LBL_PORTAL_MIN_MODULES' => 'في الحد الأدنى، يجب تمكين الحقائب، أو المشكلات، أو وحدة \\"قاعدة المعارف\\" وذلك لكي تستخدم هذا التطبيق.',
    'LBL_PORTAL_ERROR' => 'خطأ',
    'LBL_PORTAL_ROUTE_ERROR' => 'وحدة تحميل الإصدار. يرجى المحاولة لاحقًا أو الاتصال بقسم الدعم.',
    'LBL_PORTAL_OFFLINE' => 'عذرًا، التطبيق غير متاح في هذا الوقت. يُرجى الاتصال بمسؤول الموقع.',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => 'تغيير كلمة المرور',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => 'اسم المستخدم مسجل على النظام بالفعل. اطلب إما كلمة مرور منسية أو حدد اسم مستخدم آخر.',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => 'البريد الإلكتروني المزود غير صالح.',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => 'كلمتا المرور غير متطابقتين.',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => 'وحدة تحكم الخدمة',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => 'نظرة عامة',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => 'استعادة لوحة المعلومات الافتراضية',
    'LBL_UNTITLED' => 'دون عنوان',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => 'وحدة تحكم التجديدات',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => 'نظرة عامة',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => 'المرحلة/الحالة',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => 'الاسم/اسم الحساب',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => 'لوحة معلومات قائمة متعددة الاتجاهات',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => 'العميل',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} في {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => 'المستعرض لديك غير مدعوم للعمل مع SugarLive. الرجاء استخدام Google Chrome أو Mozilla Firefox.',
    'LBL_OMNICHANNEL_RECORD_CREATED' => 'تم إنشاء <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a> باستخدام تفاصيل محادثتك.',
    'LBL_OMNICHANNEL_SUBJECT' => 'الموضوع',
    'LBL_OMNICHANNEL_DESCRIPTION' => 'الوصف',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => 'ملخص الرسالة',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => 'ملخص المكالمة',
    'LBL_OMNICHANNEL_LINK_TO' => 'ربط {{fromModule}} بـ {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => 'ارتباط إلى {{module}}',
    'LBL_OMNICHANNEL_LINKED' => 'تم الربط',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => 'المستعرض لديك غير مدعوم للدردشة. الرجاء استخدام Google Chrome أو Mozilla Firefox.',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => 'الرجاء الاتصال بمسؤول Sugar للمساعدة.',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => 'تكوين التخطيط',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => 'الرجاء إنهاء تكوين SugarLive قبل إجراء مكالمة صادرة.',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => 'الرجاء إنهاء تكوين تخطيط SugarLive قبل فتحه.',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => 'اضبط حالتك على "دون اتصال" قبل تكوين تخطيط SugarLive.',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => 'طريقة عرض مصغرة',
    'LBL_OMNICHANNEL_FULL_VIEW' => 'طريقة عرض كاملة',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'لوحة معلومات BDR',
    'LBL_SALES_MANAGER_CONSOLE' => 'لوحة معلومات مدير المبيعات',
    'LBL_SALES_REP_CONSOLE' => 'لوحة معلومات مندوب المبيعات',
    'LBL_MARKETING_CONSOLE' => 'لوحة معلومات التسويق',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => 'لوحة معلومات نجاح العملاء',
    'LBL_EXECUTIVE_CONSOLE' => 'لوحة معلومات القسم التنفيذي',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => 'استعادة الإعدادات الافتراضية لعلامة التبويب',
    'LBL_CONFIGURE_SUMMARY_PANEL' => 'تكوين لوحة الملخص',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => 'ملف تعريف المستخدم',
    'LBL_WIZ_COMPLETE_TITLE' => 'اكتمل الإعداد',
    'LBL_SETUP_COMPLETE_INFO' => 'بدء تشغيل Sugar!',
    'LBL_SETUP_USER_INFO' => 'إعداد بيانات المستخدم',
    'LBL_WIZ_USER_LOCALE_TITLE' => 'الإعدادات المحلية للمستخدم',
    'LBL_SETUP_USER_LOCALE_INFO' => 'ضبط المنطقة الزمنية، والتاريخ، وتنسيق الاسم',
    'LBL_WIZ_START_SUGAR' => 'بدء تشغيل Sugar',
    'LBL_WIZ_FIRST_NAME' => 'الاسم الأول',
    'LBL_WIZ_LAST_NAME' => 'الاسم الأخير',
    'LBL_WIZ_EMAIL' => 'البريد الإلكتروني',
    'LBL_WIZ_TIMEZONE' => 'المنطقة الزمنية',
    'LBL_WIZ_TIMEFORMAT' => 'تنسيق الوقت',
    'LBL_WIZ_DATE_FORMAT' => 'تنسيق التاريخ',
    'LBL_WIZ_NAME_FORMAT' => 'تنسيق الاسم',
    'LBL_SETUP_PROGRESS' => 'تقدم الإعداد',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'التدريب على Sugar',
    'LBL_WIZ_DOCUMENTATION' => 'الوثائق',
    'LBL_WIZ_KNOWLEDGE_BASE' => 'قاعدة المعارف',
    'LBL_WIZ_FORUMS' => 'المنتديات',
    'TPL_TIMEZONE_DIFFERENT' => 'عدم تطابق مستعرضك/المنطقة الزمنية مع المنطقة الزمنية المحفوظة الخاصة بك {{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => 'تعديل المنطقة الزمنية الخاصة بك.',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => 'الإعدادات المحلية',
    'LBL_WIZ_EMAIL_SETTINGS' => 'إعدادات البريد الإلكتروني',
    'LBL_WIZ_IMPORT_DATA' => 'استيراد البيانات',
    'LBL_WIZ_CREATE_USERS' => 'إنشاء مستخدمين',
    'LBL_WIZ_APPLICATION_SETTINGS' => 'إعدادات النظام',
    'LBL_WIZ_CONFIGURE_APPLICATION' => 'الاستوديو',

    'LBL_CSP_ERROR_MESSAGE' => 'القيمة (القيم) التي أدخلتها غير مدعومة أو ليست بتنسيق مقبول. لقائمة بقيم وتنسيقات الحقول المقبولة، ارجع إلى وثائق <a href="{{linkToDocumentation}}" target="_blank">النظام</a>.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => 'لم تتم الموافقة على هذا المحتوى. الرجاء تحديث <a href="{{linkToDocumentation}}" target="_blank">إعدادات سياسة أمان المحتوى</a> للنظام.',
    'LBL_CSP_ERROR_MESSAGE_USER' => 'لم تتم الموافقة على هذا المحتوى. اطلب من مسؤولك تحديث <a href="{{linkToDocumentation}}" target="_blank">إعدادات سياسة أمان المحتوى<0> للنظام. بمجرد تحديث الإعدادات، ستحتاج إلى تحديث المستعرض لتسري التغييرات.',

    // For password related labels
    'LBL_PASSWORD' => 'كلمة المرور',
    'LBL_CHANGE_YOUR_PASSWORD' => 'تغيير كلمة المرور',
    'LBL_PASSWORD_REQUIREMENTS' => 'متطلبات كلمة المرور',
    'LBL_CURRENT_PASSWORD' => 'كلمة المرور الحالية',
    'LBL_NEW_PASSWORD1' => 'كلمة مرور جديدة',
    'LBL_NEW_PASSWORD2' => 'تأكيد كلمة المرور',
    'LBL_PASSWORD_CHANGED' => 'لقد قمت بتغيير كلمة مرورك بنجاح',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => 'يُرجى إدخال تأكيد كلمة المرور الخاصة بك.',
    'ERR_ENTER_NEW_PASSWORD' => 'يُرجى إدخال كلمة مرور جديدة.',
    'ERR_ENTER_OLD_PASSWORD' => 'يُرجى إدخال كلمة المرور الحالية.',
    'ERR_REENTER_PASSWORDS' => 'يجب تطابق كلمات المرور.',
    'ERR_PASSWORD_MISMATCH' => 'كلمة المرور المدخلة غير مطابقة لكلمة المرور الموجودة في النظام.',
    'LBL_CANNOT_SEND_PASSWORD' => 'لا يمكن إرسال كلمة المرور',
    'LBL_REQUEST_PASSWORD' => 'طلب كلمة المرور',
    'LBL_RESET_PASSWORD' => 'إعادة تعيين كلمة المرور',
    'LBL_RESET_PASSWORD_MESSAGE' => 'أدخل اسم المستخدم وسنرسل إليك ارتباطًا لإعادة تعيين كلمة المرور.',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => 'راجع بريدك الإلكتروني <br><br> لقد أرسلنا تعليمات إعادة تعيين كلمة المرور إلى عنوان البريد الإلكتروني
        الذي لدينا بالملف.',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => 'خطأ: هناك مشكلة في تحديث كلمة المرور لهذا المستخدم.',
    'LBL_INCORRECT_PASSWORD' => 'خطأ: كلمة المرور غير صحيحة.',
    'LBL_PASSWORD_ENFORCE_TITLE' => 'كلمة المرور التي أدخلتها لا تلبي متطلبات كلمة المرور. يُرجى المحاولة مرة أخرى.',
    'LBL_PASSWORD_MIN_LENGTH' => 'الحد الأدنى للطول هو {0}.',
    'LBL_PASSWORD_MAX_LENGTH' => 'الحد الأقصى للطول هو {0}.',
    'LBL_PASSWORD_ONE_UPPERCASE' => 'يجب أن تحتوي على حرف كبير (A-Z).',
    'LBL_PASSWORD_ONE_LOWERCASE' => 'يجب أن تحتوي على حرف صغير (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => 'يجب أن تحتوي على رقم (0-9).',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => 'يجب أن تحتوي على أحد الأحرف الخاصة (~!@#$%^&*()_+-={}|).',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => 'لا يجب أن تطابق كلمة المرور نمط التعبير العادي: {0}.',

    'LBL_PREFERRED_LANGUAGE' => 'تفضيل اللغة:',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => 'تعذر إرسال رسالة إعادة تعيين كلمة المرور.',

    //Saved Reports
    'LBL_REPORT_SELECT' => 'تحديد تقرير',
    'LBL_REPORT_AUTO_REFRESH' => 'تحديث تلقائي',
    'LBL_REPORT_EDIT' => 'تعديل التقرير المحدد',
    'LBL_REFRESH_LIST_AND_CHART' => 'تحديث القائمة والمخطط',
    'LBL_NO_CHART_REPORT_AVAILABLE' => 'لا يتوفر مخطط.',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => 'لا يحتوي هذا التقرير على أي عوامل تصفية.',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => 'لقد أخفيت عوامل تصفية وقت تشغيل فقط، انظر عوامل التصفية المتقدمة.',
    'LBL_RUNTIME_FILTERS' => 'عوامل تصفية وقت التشغيل',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => 'لا يتطابق التاريخ مع تنسيق التاريخ المفضل للمستخدم: ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => 'لا تحتوي لوحة المعلومات هذه على عوامل تصفية وقت تشغيل',
    'LBL_DASHBOARD_FILTER_GROUP' => 'عامل تصفية جديد',
    'LBL_RUNTIME_FILTER_LIMITATION' => 'تحتاج إلى تحديد قيمة واحدة على الأقل.',
    'LBL_RESET_FILTERS_TO_DEFAULT' => 'إعادة تعيين إلى عوامل التصفية الافتراضية',
    'LBL_COPY_FILTER_SUMMARY' => 'نسخ ملخص عوامل التصفية',
    'LBL_APPLY_FILTERS' => 'تطبيق',
    'LBL_REPORTS_FILTERS' => 'عوامل التصفية',
    'LBL_RUNTIME_FILTERS_INVALID' => 'لا يمكن تطبيق عوامل تصفية وقت التشغيل بسبب قيم غير صحيحة',
    'LBL_RUNTIME_FILTERS_COPIED' => 'تم نسخ ملخص عوامل التصفية إلى حافظتك.',
    'LBL_ADVANCED_FILTERS' => 'عوامل التصفية المتقدمة',
    'LBL_ADVANCED_OR_DESC' => 'تضمين عند تلبية "أي" شرط',
    'LBL_ADVANCED_AND_DESC' => 'تضمين عند تلبية "كل" الشروط',
    'LBL_ORIGINAL_DESIGN_FILTER' => 'هذا عامل تصفية تصميم أصلي',
    'LBL_AND_UPPERCASE' => 'و',
    'LBL_REPORTS_PREVIEW_LIMITATION' => 'هذه الميزة غير متاحة في وضع المعاينة',
    'LBL_REPORT_DEFAULT_NAME' => 'تقرير غير معنون',
    'LBL_REPORT_QUERY' => 'الاستعلام',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => 'مرتبط بالسجل الحالي',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => 'الحقل المرتبط',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => 'لا يمكن أن يكون الحقل المرتبط فارغًا',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => 'لم يتم تحديد تقرير.',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => 'المخطط الخطي غير متوافق مع هذا التقرير',
    'LBL_REPORT_DASHLET' => 'لوحة معلومات التقارير',
    'LBL_REPORTS_DASHLET_DATATABLE' => 'جدول البيانات',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => 'عوامل تصفية وقت التشغيل',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => 'معاينة جدول البيانات',
    'LBL_REPORTS_DASHLET_CHART' => 'المخطط',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => 'معاينة المخطط',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => 'معاينة عامل التصفية',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => 'التقرير المحدد لا يدعم المخطط.',
    'LBL_REPORTS_DASHLET_LABELS' => 'التسميات',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => 'إظهار إجمالي عدد السجلات',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => 'ترتيب الفرز',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => 'طريقة العرض المحددة الافتراضية',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => 'ترتيب فرز المخطط الرئيسي',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => 'ترتيب فرز المخطط الثانوي',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => 'لا ارتباطات {{module}} بالتقرير المحدد',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => 'غير متوفر لنوع التقرير هذا',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => 'هذه الميزة متاحة فقط في علامة تبويب المخطط',
    'LBL_REPORTS_CHART_TYPE' => 'نوع المخطط',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => 'وضع قيمة المخطط الشريطي',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => 'عرض الإجمالي',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => 'عرض وسيلة الإيضاح',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'إظهار تسمية المحور السيني',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'إظهار تسمية المحور الصادي',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'حد عرض الصفوف',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => 'ليس لديك إذن لاستخدام عوامل تصفية وقت التشغيل هذه.',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => 'غير معروف',
    'ERR_HTTP_DEFAULT_TITLE' => 'خطأ غير معروف',
    'ERR_HTTP_DEFAULT_TEXT' => 'خطأ غير معروف.',
    'ERR_HTTP_DEFAULT_ACTION' => 'العودة إلى الصفحة السابقة.',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => 'خطأ: طلب غير صالح',
    'ERR_HTTP_400_TEXT_LINE1' => 'أرسل المستعرض الخاص بك طلبًا لم يتمكن الخادم من فهمه.',
    'ERR_HTTP_400_TEXT_LINE2' => 'الرجاء الاتصال بمسؤول Sugar للحصول على المزيد من التفاصيل.',
    'ERR_HTTP_400_ACTION' => 'العودة إلى الصفحة السابقة.',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'البيانات غير متوفرة',
    'ERR_HTTP_404_TEXT_LINE1' => 'الصفحة غير موجودة، أو لا يوجد لديك إذن للوصول إلى هذه الصفحة.',
    'ERR_HTTP_404_TEXT_LINE2' => 'الرجاء المحاولة مرة أخرى. في حالة استمرار ظهور الخطأ، الرجاء الاتصال بـ "مسؤول Sugar".',
    'ERR_HTTP_404_ACTION' => 'العودة إلى الصفحة السابقة.',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500 خطأ في الخادم الداخلي',
    'ERR_HTTP_500_TEXT_LINE1' => 'تعرض الخادم لعطل، وتعذر استكمال الطلب الخاص بك.',
    'ERR_HTTP_500_TEXT_LINE2' => 'الرجاء المحاولة مرة أخرى. في حالة استمرار ظهور الخطأ، الرجاء الاتصال بـ "مسؤول Sugar".',
    'ERR_HTTP_500_ACTION' => 'يرجى الاتصال بالدعم الفني.',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 خطأ خادم داخلي',
    'ERR_HTTP_502_TEXT_LINE1' => 'تعرض الخادم لعطل مؤقت، وتعذر استكمال الطلب الخاص بك.',
    'ERR_HTTP_502_TEXT_LINE2' => 'الرجاء المحاولة مرة أخرى. في حالة استمرار ظهور الخطأ، الرجاء الاتصال بـ "مسؤول Sugar".',
    'ERR_HTTP_502_ACTION' => 'يرجى الاتصال بالدعم الفني.',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 خطأ خادم داخلي',
    'ERR_HTTP_503_TEXT_LINE1' => 'الخادم غير متوفر لإكمال طلبك.',
    'ERR_HTTP_503_TEXT_LINE2' => 'يرجى إعادة المحاولة لاحقًا. في حالة استمرار ظهور الخطأ، الرجاء الاتصال بـ "مسؤول Sugar".',
    'ERR_HTTP_503_ACTION' => 'يرجى الاتصال بالدعم الفني.',

    'ERR_RENDER_FAILED_TITLE' => 'فشل عرض التقديم',
    'ERR_RENDER_FAILED_MSG' => 'فشل تقديم عرض',
    'ERR_RENDER_FIELD_FAILED_TITLE' => 'فشل عرض حقل',
    'ERR_RENDER_FIELD_FAILED_MSG' => 'غير قادر على عرض {0} للحقل.',

    'ERR_NO_VIEW_ACCESS_TITLE' => 'تم رفض الوصول',
    'ERR_NO_VIEW_ACCESS_REASON' => 'ليس لديك إذن للوصول إلى هذه الصفحة.',
    'ERR_NO_VIEW_ACCESS_ACTION' => 'اتصل بالمسؤول لطلب الوصول.',
    'ERR_NO_VIEW_ACCESS_MSG' => 'اتصل بمسؤول الدعم للحصول على حق الوصول إلى هذا العرض الخاص بالوحدة {0}.',

    'ERR_LAYOUT_RENDER_TITLE' => 'فشل عرض مخطط',
    'ERR_LAYOUT_RENDER_MSG' => 'عذرًا! تعذر تقديم أي شيء لك. يرجى المحاولة لاحقًا أو الاتصال بقسم الدعم.',
    'ERR_INTERNAL_ERR_MSG' => 'خطأ داخلي',
    'ERR_GENERIC_TITLE' => 'خطأ',
    'ERR_CONTACT_TECH_SUPPORT' => 'يرجى الاتصال بالدعم الفني.',

    'LBL_SYNCED_RECURRING_MSG' => 'تعذر تعديل هذا السجل حيث إنه متزامن من عميل خارجي.',
    'LBL_EXISTING' => 'الحالي',
    'LBL_PANEL_DEFAULT' => 'الافتراضي',
    'ERR_BAD_RESPONSE_FROM_SERVER' => 'استجابة سيئة من الخادم',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => 'حدث خطأ أثناء إجراء التعيين إلى.',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => 'لا يمكنك الوصول إلى "{{name}}". يُرجى الاتصال بالمسؤول الخاص بك.',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => 'سنة {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} Q{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => 'مزيد من الإجراءات',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => 'تنبيه',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => 'تجاهل التكرار والحفظ',
    'LBL_RESTORE' => 'إعادة الضبط إلى الأصلي',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => 'تم تعليم السجلات للمسح',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => 'عرض سجلات ذات صلة بطلب خصوصية بيانات من أجل '
        . 'مسح المعلومات.',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'تغذية RSS',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => 'حافظ على حداثة معلوماتك من خلال إضافة موجز RSS خارجي أو موجزات المدونات.',
    'LBL_RSS_FEED_URL' => 'عنوان URL الموجز',
    'LBL_RSS_FEED_AUTHOR' => 'المؤلف:',
    'LBL_RSS_FEED_ENTRIES_COUNT' => 'عدد الإدخالات المطلوب عرضها',
    'LBL_ERR_LOADING_RSS_FEED' => 'فشل تحميل تغذية RSS',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => 'العناصر الخاصة بي',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => 'عناصر الفريق',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => 'يسمح للمستخدمين بإضافة تطبيقات السكر إلى لوحة التحكم',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => 'السجل',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => 'توضح لوحة السجل الاجتماعات المنعقدة، والمكالمات المسجلة، ورسائل البريد المتلقاة، ورسائل البريد المرسلة.',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => 'البريد الإلكتروني',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => 'رسائل البريد الإلكتروني',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => 'سجلي',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => 'سجل الفريق',
    'LBL_UNASSIGNED' => 'غير مخصص',
    'LBL_ARCHIVE_EMAIL' => 'أرشيف البريد الإلكتروني',
    'LBL_EMAIL_ARCHIVED' => 'تمت أرشفة البريد الإلكتروني',
    'LBL_CREATE_ARCHIVED_EMAIL' => 'إنشاء بريد إلكتروني مؤرشف',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => 'الأنشطة المخطط لها',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => 'توضح لوحة الأنشطة المخطط لها الاجتماعات المخطط لها والمكالمات.',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => 'اليوم',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => 'المستقبل',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => 'أنشطتي',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => 'أنشطة الفريق',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => 'تم الإجراء',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => 'هل تريد بالتأكيد وضع علامة {0} كمغلق؟',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => 'المهام النشطة',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => 'توضح لوحة معلومات المهام النشطة ما هو واجب الآن، وما هو آتٍ، والمهام المطلوب القيام بها.',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => 'الواجب تنفيذها الآن',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => 'القادمة',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => 'المراد القيام بها',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => 'كامل',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => 'هل تريد بالتأكيد وضع علامة {0} كتَم الانتهاء؟',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'مهامي',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'مهام الفريق',
    'LBL_LIST_REMOVE_EMAIL_INFO' => 'هناك بريد إلكتروني إضافي على السجل الذي تقوم بتعديله. هي الآن أساسية وتم نشرها أدناه.',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => 'المهام غير النشطة',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => 'توضح لوحة المهام المؤجلة والكاملة.',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => 'مؤجل',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => 'كامل',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => 'آخر مرة تم تعديلها{{relativetime}} على{{date}} في {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => 'مهامي',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => 'مهام الفريق',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => 'الحالات التي تم عرضها حديثها',

    'LBL_REPORT_DASHLET_TITLE_12' => 'الحالات المفتوحة حسب المستخدم ثم الحالة',
    'LBL_REPORT_DASHLET_TITLE_125' => 'الحالات الجديدة حسب مركز العمل ثم الأسبوع',
    'LBL_REPORT_DASHLET_TITLE_126' => 'الحالات التي تم إنشاؤها مؤخرًا',
    'LBL_REPORT_DASHLET_TITLE_127' => 'الحالات الجديدة حسب طبقة العميل ثم الأسبوع',
    'LBL_REPORT_DASHLET_TITLE_128' => 'الحالات المفتوحة حسب طبقة العميل والأولوية',
    'LBL_REPORT_DASHLET_TITLE_129' => 'إجمالي الحالات التي تم حلها هذا الشهر حسب مركز الأعمال',
    'LBL_REPORT_DASHLET_TITLE_130' => 'إجمالي الحالات التي تم حلها هذا الشهر حسب الوكيل',
    'LBL_REPORT_DASHLET_TITLE_131' => 'قائمة الحالات التي تم حلها مؤخرًا',
    'LBL_REPORT_DASHLET_TITLE_132' => 'إجمالي حالاتي التي تم حلها هذا الشهر حسب الأسبوع',
    'LBL_REPORT_DASHLET_TITLE_133' => 'إجمالي حالاتي المستحقة اليوم والتي فاد ميعاد استحقاقها',
    'LBL_REPORT_DASHLET_TITLE_134' => 'كل الحالات المستحقة اليوم والتي فاد ميعاد استحقاقها',
    'LBL_REPORT_DASHLET_TITLE_135' => 'حالاتي المفتوحة حسب تاريخ المتابعة',
    'LBL_REPORT_DASHLET_TITLE_136' => 'كل الحالات المفتوحة حسب تاريخ المتابعة',
    'LBL_REPORT_DASHLET_TITLE_137' => 'حالاتي المفتوحة حسب الحالة',
    'LBL_REPORT_DASHLET_TITLE_138' => 'حالاتي في الأسبوع الأخير حسب الحالة',
    'LBL_REPORT_DASHLET_TITLE_139' => 'حالة المهام المفتوحة المُعينة مني',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP أو Old REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'مهمة Cron',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'أداة الإضافة المنطقية',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'سير عمل Sugar',
    'LBL_AUDIT_SUBJECT_USER' => 'المستخدم',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web to Lead',

    //common chart strings
    'LBL_CHART' => 'المخطط',
    'LBL_CHART_NO_DATA' => 'لا تتوفر بيانات.',
    'LBL_CHART_LEGEND_CLOSE' => 'إخفاء وسيلة الإيضاح',
    'LBL_CHART_LEGEND_OPEN' => 'عرض وسيلة الإيضاح',
    'LBL_CHART_CONTROLS_CLOSE' => 'إخفاء أدوات التحكم',
    'LBL_CHART_CONTROLS_OPEN' => 'عرض أدوات التحكم',
    'LBL_CHART_UNDEFINED' => 'غير محدد',
    'LBL_CHART_NO_LABEL' => 'غير محدد',
    'LBL_CHART_AMOUNT' => 'المبلغ',
    'LBL_CHART_COUNT' => 'العدد',
    'LBL_CHART_PERCENT' => 'النسبة المئوية',
    'LBL_CHART_GROUP' => 'المجموعة',
    'LBL_CHART_DATE' => 'التاريخ',
    'LBL_CHART_KEY' => 'المفتاح',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => 'نوع المخطط',
    'LBL_CHART_CONFIG_SHOW_TITLE' => 'إظهار العنوان',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => 'عرض الإجمالي',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => 'إظهار تسمية المحور السيني',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => 'إظهار تسمية المحور الصادي',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => 'أساليب عرض المؤشر',
    'LBL_CHART_CONFIG_TICK_WRAP' => 'التفاف المؤشرات',
    'LBL_CHART_CONFIG_TICK_STAGGER' => 'مؤشرات مخطط Stagger',
    'LBL_CHART_CONFIG_TICK_ROTATE' => 'إدارة المؤشرات',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => 'تحديد وضع قيمة المخطط الشريطي',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => 'خيارات عرض المخطط الشريطي',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => 'السماح بالتمرير',
    'LBL_CHART_CONFIG_STACK_DATA' => 'تكديس تسلسل البيانات',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => 'إخفاء المجموعات الفارغة',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => 'المرسلة',
    'LBL_EMAIL_RECV' => 'المسجل',

    //record save
    'LBL_RECORD_SAVED' => 'تم حفظ السجل.', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => 'تم إنشاء {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{full_name}}</a> بنجاح.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => 'لقد أنشأت بنجاح {{moduleSingularLower}}.',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => 'لقد أنشأت هذا السجل بنجاح، ولكن ليس لديك تصريح بالوصول إليه.', // use when user has no access to the model
    'LBL_VALIDATING' => 'جارٍ التصديق الآن...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => 'نجاح:',
    'LBL_ALERT_TITLE_WARNING' => 'تحذير:',
    'LBL_ALERT_TITLE_NOTICE' => 'إشعار:',
    'LBL_ALERT_TITLE_ERROR' => 'خطأ:',
    'LBL_ALERT_TITLE_LOADING' => 'جارٍ التحميل',
    'LBL_ALERT_NO_ACCESS' => 'ليس لديك حق الوصول إلى عامل التصفية المطبق على لوحة المعلومات هذه.',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => 'قم بتكرار لوحة المعلومات لتكوين لوحة معلوماتك بعامل التصفية الخاص بك.',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => 'لم يعد إصدار المستعرض الخاص بك مدعومًا، أو ربما تستخدم مستعرضًا غير مدعوم.',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => 'المنصات المدعومة',
    'LBL_ALERT_CONFIRM_DELETE' => 'هل تريد بالتأكيد حذف هذا العنصر؟',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => 'هل تريد بالتأكيد حذف هذه العناصر؟',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => 'ستتم الكتابة فوق السجل المحدد بالقيم التالية: {{values}}. قم بالإلغاء للاحتفاظ بالقيم الموجودة. قم بالتأكيد للكتابة فوق تلك القيم بالقيم الجديدة.',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => 'قيمة {{moduleSingularLower}} المحددة لها قيم مرتبطة: {{values}}. قم بالإلغاء للاحتفاظ بالقيم الموجودة. قم بالتأكيد للكتابة فوق تلك القيم بالقيم الجديدة.',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => 'من:',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => 'إلى:',

    //organization chart
    'LBL_ORG_CHART' => 'المخطط التنظيمي',
    'LBL_ORG_CHART_DESC' => 'يعرض هيكل العاملين لمنظمتك.',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => 'تبديل الاتجاه',
    'LBL_ORG_CHART_TOOLTIP_NODES' => 'عرض كل العُقد',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => 'التكبير/التصغير للملاءمة',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => 'ملخص الحالة',
    'LBL_CASE_SUMMARY_CHART_DESC' => 'عرض نظرة عامة على الحالات ذات الصلة.',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => 'الملخص',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => 'الحالات المغلقة',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => 'الحالات المفتوحة',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'أعلى 10 فرص مبيعات',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => 'عرض أعلى 10 فرص في مخطط الفقاعة.',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => 'العناصر الخاصة بي',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "الفرص الخاصة بفريقي",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => 'عامل تصفية التاريخ الافتراضي',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => 'مجموعة البيانات الافتراضية',

    'LBL_PRODUCT_CATALOG_NAME' => 'كتالوج المنتج',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => 'كتالوج المنتج',
    'LBL_PRODUCT_CATALOG_DESC' => 'عرض عناصر وإضافتها من كتالوج المنتج.',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => 'عرض عناصر وإضافتها من كتالوج المنتج.',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} في {{date}} في {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => 'اكتب ملاحظة أو اسحب مرفقًا وأسقطه. اكتب @ لذكر المستخدم. اكتب # للإشارة إلى سجل.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => 'أضف تعليقاتك وتعليماتك، اكتب @ لتوضيح المستخدم. اكتب # للإشارة إلى سجل.',
    'LBL_ACTIVITY_STREAM' => 'سير النشاط الكلي',
    'LBL_ACTIVITY_STREAM_DISABLED' => 'لم يتم تمكين سير النشاط',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => 'لم يتم تمكين سير النشاط لهذه الوحدة',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => 'المزيد من المنشورات...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'في',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => 'سير النشاط الخاص بي',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => 'اعرض قائمة الأنشطة التي تم القيام بها في السجلات وأنشئ التعليقات وانشرها.',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => 'تم تعطيل سير النشاط',

    'LBL_DATA_VIEW' => 'عرض البيانات',
    'LBL_COMMENT' => 'التعليق',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => 'حدث خطأ أثناء الاتصال بالخادم. يُرجى المحاولة مرة أخرى.',
    'ERR_RESOLVE_ERRORS' => 'يرجى حل أي أخطاء قبل المتابعة.',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => 'من أجل الموافقة، يجب ملء كل الحقول المطلوبة؛ لكن يظل بإمكانك رفض هذا السجل أو توجيهه.',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => 'من أحل الرفض/التوجيه، يجب ملء كل الحقول المطلوبة.',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => 'تحديث القائمة',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => 'تحديث الإطارات المتجانبة',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => 'المزيد',
    'LBL_TEXTAREA_LESS' => 'أقل',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} المرفقات',
    'LBL_CREATE_ATTACHMENT' => 'إنشاء مرفق',
    'LBL_DASHLET_REFRESH' => 'تحديث',
    'LBL_DASHLET_MOVE' => 'نقل',
    'LBL_DASHLET_CLOSE' => 'إغلاق',

    'LBL_DASHLET_FORECAST_NAME' => 'في التوقع',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => 'المخطط الشريطي للتوقع',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'المخطط الشريطي للتوقع',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => 'التوقع بـ',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => 'عرض مخطط شريطي للتوقع لفترة زمنية محددة',
    'LBL_DASHLET_FORECASTS_GROUPBY' => 'مجموعة حسب',
    'LBL_DASHLET_FORECASTS_DATASET' => 'مجموعة البيانات',
    'LBL_DASHLET_FORECASTS_DETAILS' => 'تفاصيل التوقع',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => 'عرض تفاصيل التوقع الحالية.',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => 'لوحة مخطط التقارير المحفوظة',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => 'عرض أي مخطط من تقرير محفوظ.',

    'LBL_QUESTION_MARK' => '؟',

    'LBL_DASHLET_RELATED_DOCUMENTS' => 'المقالات المنشورة ذات الصلة',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => 'ملخص تاريخي',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => 'المزيد من السجلات...',
    'LBL_RELATED_CONTACT' => 'جهة اتصال ذات الصلة',
    'LBL_MODULE_TYPE' => 'النوع',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => 'إرسال بريد إلكتروني إلى',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => 'بريد إلكتروني من',
    'LBL_PREVIEW_BWC_TOOLTIP' => 'غير قادر على معاينة الوحدات القانونية',

    //SFA
    'LBL_BEST' => 'الأفضل',
    'LBL_WORST' => 'الأسوأ',
    'LBL_LIKELY' => 'احتمال',
    'LBL_BEST_FORECAST' => 'الالتزام (الأفضل)',
    'LBL_WORST_FORECAST' => 'الالتزام (الأسوأ)',
    'LBL_LIKELY_FORECAST' => 'الالتزام (الأرجح)',
    'LBL_BEST_ADJUSTED' => 'الالتزام المعدل (الأفضل)',
    'LBL_WORST_ADJUSTED' => 'الالتزام المعدل (الأسوأ)',
    'LBL_LIKELY_ADJUSTED' => 'الالتزام المعدل (الأرجح)',
    'LBL_AMOUNT_USDOLLAR' => 'المبلغ المحول',
    'LBL_OVERDUE' => 'متأخر',

    'LBL_PASSWORD_REQUEST_SENT' => 'تم إرسال طلبك.',
    'LBL_PASSWORD_REQUEST_ERROR' => 'هناك مشكلة في استعادة الدمج بين اسم المستخدم والبريد الإلكتروني.',

    'LBL_REMINDER_TITLE' => 'تذكير',
    'LBL_CLICK_TO_DRILLDOWN' => 'انقر للانتقال التفصيلي',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => 'لا يمكنك تعطيل كل اللغات.',

    'LBL_UPDATE_CALC_FIELDS' => 'قيم قابلة لإعادة الحساب',

    //Optimistic Locking
    'LBL_YOU' => 'أنت',
    'LBL_RESOLVE_CONFLICT' => 'حل مشكلة لـ {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => 'لمزيد من المعلومات راجع مستندات {{{more_info_url}}} {{plural_module_name}}.{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => 'لا تتوفر بيانات',
    'LBL_NEED_HELP' => 'تحتاج إلى المساعدة في شيء جديد؟',
    'LBL_NEW_CASE' => 'حالة جديدة',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => 'تتيح لوحة معلومات المساعدة معلومات محددة للحفاظ على الوحدة التي تعرضها حاليًا مزودة برابط بالمستند المتوافق (مثال مستند القيم المتوقعة) في دليل التطبيق لمزيد من المعلومات.',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => 'تعليمات عرض القائمة',
    'LBL_HELP_RECORDS' => "توضح قائمة الوحدة كل السجلات التي تلبي معايير البحث الحالي وأي المستخدمين الذين لهم حق الدخول. يمكنك عرض التفاصيل الأساسية لكل سجل داخل أعمدة الحقل الخاص بعرض القائمة أو انقر فوق اسم السجل لفتح عرض السجل.",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => 'تعليمات عرض السجل',
    'LBL_HELP_RECORD' => 'يتيح عرض هذا السجل من خلال البيانات الخاصة بفرد السجل بجانب بعض تفاصيل السجلات المرتبطة به.

- قم بتعديل حقول هذا السجل (السجلات) بواسطة النقر فوق حقل فردي، أو فوق الزر \\"تحرير\\".
- اعرض أو قم بتعديل الارتباطات إلى سجلات أخرى في اللوحات الفرعية بواسطة تبديل الجزء الأيسر السفلي إلى \\"عرض البيانات\\".
- قم بعمل وعرض تعليقات المستخدم وسجل تغيير السجلات بواسطة تبديل الجزء الأيسر السفلي إلى \\"سير النشاط\\".
- اتبع أو اجعل هذا السجل مفضلاً لديك باستخدام الرموز الموجودة على يمين اسم السجل.
- تتوفر إجراءات إضافية في القائمة المنسدلة \\"الإجراءات\\" الموجودة على يمين الزر \\"تحرير\\".',

    // create view
    'LBL_HELP_CREATE_TITLE' => 'إنشاء {{module_name}}',
    'LBL_HELP_CREATE' => 'لإنشاء {{plural_module_name}}:
1. قم بتوفير قيم للحقول حسب الرغبة.
 *الحقول المميزة بعلامة "مطلوب" يجب استكمالها قبل الحفظ.
 *انقر فوق "إظهار المزيد" لكشف الحقول الإضافية إذا لزم الأمر.
2. انقر فوق الزر "حفظ" لإنهاء السجل الجديد والرجوع إلى عرض القائمة {{plural_module_name}}.',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => 'احتمال اكتشاف تكرار',
    'LBL_HELP_DUPLICATE' => 'اكتشف Sugar أن السجل الذي تحاول إنشاءه قد يكون موجودًا بالفعل.

 لتعديل سجل موجود بخلاف إنشاء واحد جديد، انقر فوق \\"تحديد وتعديل\\" على يمين السجل المراد تعديله. يتم ملء أي حقول فارغة للسجل الموجود بالقيم التي قمت بإدخالها للتو. انقر فوق \\"حفظ\\" لتفعيل تلك التغييرات على السجل الموجود.

إذا لم يحدث ذلك، وكنت ترغب في استخدام القيم التي قمت بإدخالها بدلاً من القيم الموجودة بالسجل، فانقر فوق \\"إعادة الضبط إلى الأصل\\". سيتم تطبيق القيم التي أدخلتها على السجل الحالي، وقد تقوم بتوفير أي تغييرات إضافية وانقر فوق \\"حفظ\\" لإنهاء التعديلات على السجل الحالي.

لإنشاء سجل جديد باستخدام القيم التي أدخلتها، انقر فوق \\"تجاهل التكرار والحفظ\\" على يمين الشاشة.',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'إعدادات خادم SMTP مفقودة',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => 'لإرسال إخطارات تعيين سجل، يجب تهيئة خادم SMTP في{{emailSettingsUrl}}.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => 'إعدادات البريد الإلكتروني',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => 'تقارير الأسهم الجديدة المتاحة',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => 'تقارير الأسهم الجديدة متاحة في ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => 'وحدة التقارير',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => 'تم وضع علامة "تقرير الأسهم" عليهم ويمكن تصفيتها. تم أيضًا وضع علامة "المبيعات والتسويق" أو "خدمة العملاء" أو "خصوصية البيانات" أو "الإدارية" على التقارير استناداً إلى المحتوى. للحصول على مزيد من المعلومات، راجع ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => 'الوثائق',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'يقوم SugarCRM بتمكين المستخدمين الكبار من أداء مهام معينة بسرعة باستخدام اختصارات لوحة المفاتيح لزيادة الإنتاجية. توضح الجداول على اليمين الاختصارات إلى جانب المفاتيح والإجراءات التي تطبقها.',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>المفاتيح المدعومة</h1><ul><li>كل الحروف والرموز الأبجدية الرقمية</li><li>shift، ctrl، alt, command، mod (ctrl في Windows/Linux والأمر في Macs)</li><li>enter، esc، space، tab، pageup، pagedown، end، home، ins، del، backspace</li></ul><h1>الميزات المدعومة</h1><ul><li>مزيج المفاتيح: ctrl+m</li><li>المفاتيح المتعددة: m,ctrl+m</li><li>سلسلة المفاتيح: m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => 'اختصارات عامة',
    'LBL_CONTEXTUAL_SHORTCUTS' => 'اختصارات سياقية',
    'LBL_SHORTCUT_KEY_KEY' => 'المفتاح',
    'LBL_SHORTCUT_FUNCTION' => 'الوظيفة',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => 'تكوين الاختصارات السياقية',
    'LBL_SHORTCUT_CONFIG_DISABLED' => 'لا توجد اختصارات سياقية لتكوينها',
    'LBL_SHORTCUT_HELP' => 'عرض الاختصارات على صفحة التعليمات',
    'LBL_SHORTCUT_QUICK_CREATE' => 'تبديل قائمة إنشاء سريع',
    'LBL_SHORTCUT_SEARCH' => 'التركيز على حقل البحث العام',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => 'تبديل الشريط الجانبي',
    'LBL_SHORTCUT_CREATE_RECORD' => 'إنشاء سجل جديد',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => 'تحديد السجل التالي في القائمة',
    'LBL_SHORTCUT_NAVIGATE_UP' => 'تحديد السجل السابق في القائمة',
    'LBL_SHORTCUT_SCROLL_LEFT' => 'تمرير القائمة على اليسار',
    'LBL_SHORTCUT_SCROLL_RIGHT' => 'تمرير القائمة على اليمين',
    'LBL_SHORTCUT_OPEN' => 'فتح السجل المحدد في القائمة',
    'LBL_SHORTCUT_EDIT_SELECTED' => 'تعديل السجل المحدد في القائمة',
    'LBL_SHORTCUT_RECORD_DELETE' => 'حذف سجل',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => 'الخروج من القائمة في وضع التعديل بدون حفظ',
    'LBL_SHORTCUT_RECORD_SAVE' => 'حفظ السجل',
    'LBL_SHORTCUT_RECORD_CANCEL' => 'مسح أي تغييرات للسجل',
    'LBL_SHORTCUT_FAVORITE_RECORD' => 'وضع علامة على السجل كمفضلة',
    'LBL_SHORTCUT_FOLLOW_RECORD' => 'متابعة السجل',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => 'معاينة السجل',
    'LBL_SHORTCUT_MARK_SELECTED' => 'وضع علامة على السجل كمحدد',
    'LBL_SHORTCUT_SELECT_ALL' => 'تحديد الكل',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => 'فتح قائمة الإجراءات الشاملة المنسدلة',
    'LBL_SHORTCUT_FILTER_SEARCH' => 'التركيز على حقل التصفية',
    'LBL_SHORTCUT_FILTER_CREATE' => 'إنشاء عامل تصفية لقائمة جديد',
    'LBL_SHORTCUT_FILTER_EDIT' => 'تعديل عامل تصفية القائمة الحالي',
    'LBL_SHORTCUT_FILTER_SHOW' => 'فتح قائمة عامل تصفية القائمة',
    'LBL_SHORTCUT_RECORD_EDIT' => 'تعديل سجل',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => 'فتح سجل سابق',
    'LBL_SHORTCUT_RECORD_NEXT' => 'فتح سجل تالٍ',
    'LBL_SHORTCUT_COPY_RECORD' => 'نسخ سجل حالي',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => 'فتح قائمة الإجراءات الأساسية المنسدلة',
    'LBL_SHORTCUT_CLOSE_DRAWER' => 'إغلاق الرسام',
    'LBL_SHORTCUT_FILTER_ADD' => 'إضافة معايير إضافية لعامل التصفية',
    'LBL_SHORTCUT_FILTER_REMOVE' => 'إزالة آخر معيار من التصفية',
    'LBL_SHORTCUT_FILTER_CLOSE' => 'إغلاق عامل التصفية',
    'LBL_SHORTCUT_FILTER_SAVE' => 'حفظ عامل التصفية',
    'LBL_SHORTCUT_FILTER_DELETE' => 'حذف عامل التصفية',
    'LBL_SHORTCUT_FILTER_RESET' => 'إعادة ضبط عامل التصفية',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => 'إضافة صف',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => 'إزالة صف',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => 'غلق التحديث بأكمله',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => 'السجلات المحدثة',
    'LBL_CREATE_CATEGORY' => 'إنشاء <div class="btn-link" data-action="create-new">فئة</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => 'تأكيد',
    'LBL_SHORTCUT_ALERT_CANCEL' => 'إلغاء',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => 'تحديد جميع العناصر في حقل تحديد متعدد',
    'LBL_SHORTCUT_SWEETSPOT' => 'تبديل شريط Sweet Spot',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => 'إخفاء شريط Sweet Spot',
    'LBL_SHORTCUT_SAVE_CONFIG' => 'حفظ التكوين',
    'LBL_SHORTCUT_RESTORE' => 'استعادة الافتراضي',
    'LBL_SHORTCUT_CONFIG_ERROR' => 'حدث خطأ أثناء حفظ مفاتيح الاختصار المخصصة على الخادم. يرجى إعادة المحاولة لاحقًا.',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => 'إعدادات {{module}}',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => 'تم حفظ إعدادات تكوين {{module}}.',
    'LBL_CONFIG_BLOCKED_TITLE' => 'خطأ تكوين {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => 'لا توجد أي إعدادات تكوين لـ {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => 'لا يمتلك المستخدمون القدرة على الوصول إلى {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => 'لا يمتلك المستخدم القدرة على الوصول لتكوين إعدادات {{module}}',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => 'يجب إصلاح إعدادات قاعدة البيانات لـ {{module}}',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => 'إلى',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => 'تاريخ البدء والنهاية',

    'LBL_CALENDAR_START_DATE' => 'تاريخ البدء',
    'LBL_CALENDAR_END_DATE' => 'تاريخ الانتهاء',
    'LBL_CALENDAR_DURATION' => 'المدة',
    'LBL_CALENDAR_RECURRENCE' => 'التكرار',
    'LBL_CALENDAR_REMINDERS' => 'التذكيرات',

    'LBL_CALENDAR_CUSTOM_DATE' => 'تاريخ مخصص',
    'LBL_CALENDAR_REPEAT_TYPE' => 'نوع التكرار',
    'LBL_CALENDAR_REPEAT_INTERVAL' => 'فاصل التكرار',
    'LBL_CALENDAR_REPEAT_DOW' => 'التكرار في أيام الأسبوع',
    'LBL_CALENDAR_REPEAT_ON' => 'تشغيل التكرار',
    'LBL_CALENDAR_REPEAT' => 'تكرار',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => 'التكرار حتى',
    'LBL_CALENDAR_REPEAT_COUNT' => 'تكرار حالات التكرار',
    'LBL_CALENDAR_REPEAT_SELECTOR' => 'محدد التكرار',
    'LBL_CALENDAR_REPEAT_DAYS' => 'أيام الشهر',
    'LBL_CALENDAR_REPEAT_MONTH' => 'شهر (شهور) من السنة',
    'LBL_CALENDAR_REPEAT_ORDINAL' => 'تكرار العدد الترتيبي',
    'LBL_CALENDAR_REPEAT_UNIT' => 'تكرار الوحدة',
    'TPL_REPEAT_INTERVAL' => 'كل {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => 'تستخدم هذه السلسلة خيار "تشغيل التكرار" غير المتوفر في Sugar لأنه تمت مزامنة السلسلة من عميل تقويم. يرجى تعديل هذه السلسلة في عميل التقويم الخاص بك إذا كنت ترغب في استمرار التكرار في تاريخ محدد. سيؤدي تحرير هذه السلسلة في Sugar إلى تعيين "تشغيل التكرار" على "بلا".<br><br>هل ترغب في المتابعة؟',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => 'يجب أن يتم عمل تغييرات التكرار باستخدام أول سجل في السلسلة.',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => 'لا تؤدي قواعد التكرار إلى حدث يتم إنشائه.',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => 'الحضور',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => 'مرفوض',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => 'مبدئي',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => 'بلا رد',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => 'الجدول غير متاح',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => 'طرق العرض المتوفرة',
    'LBL_CALENDAR_DASHLET_NAME' => 'مجدول التقويم',
    'LBL_CALENDAR_DEFAULT_VIEW' => 'طريقة العرض الافتراضية',
    'LBL_CALENDAR_MY_CALENDARS' => 'تقويماتي',
    'LBL_CALENDAR_OTHER_CALENDARS' => 'تقويمات المستخدم والفريق',
    'LBL_CALENDAR' => 'التقويم',

    'LBL_CALENDAR_DAY' => 'يوم',
    'LBL_CALENDAR_WEEK' => 'أسبوع',
    'LBL_CALENDAR_MONTH' => 'شهر',
    'LBL_CALENDAR_YEAR' => 'سنة',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '2',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '3',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '4',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '5',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '6',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '7',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '8',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '9',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '10',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '11',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '12',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '13',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '14',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '15',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '16',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '17',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '18',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '19',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '20',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '21',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '22',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '23',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '24',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '25',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '26',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '27',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '28',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '29',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '30',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '31',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '32',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '33',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '34',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '35',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '36',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '37',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '38',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '39',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '40',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '41',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '42',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '43',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '44',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '45',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '46',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '47',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '48',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '49',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '50',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '51',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '52',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '53',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '54',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '55',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '56',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '57',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '58',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '59',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '60',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '61',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '62',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '63',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '64',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '65',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '66',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '67',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '68',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '69',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '70',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '71',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '72',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '73',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '74',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '75',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '76',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '77',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '78',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '79',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '80',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '81',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '82',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '83',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '84',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '85',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '86',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '87',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '88',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '89',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '90',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '91',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '92',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '93',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '94',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '95',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '96',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '97',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '98',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '99',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => 'حدث خطأ أثناء استعادة الجدول.',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => 'حفظ الدعوات وإرسالها',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => 'قبول الحالة',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => 'العمليات',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => 'تعرض لوحات معلومات العمليات القوالب التي يمكن استخدامها داخل SugarBPM.',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => 'تعريفات العملية',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => 'تعرض لوحات معلومات تعريفات العمليات القوالب التي يمكن استخدامها داخل SugarBPM.',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => 'إنشاء تعريف العملية',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => 'استيراد تعريفات العملية',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => 'القواعد التجارية للعملية',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => 'تعرض لوحات معلومات قواعد العمل القوالب التي يمكن استخدامها داخل SugarBPM.',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => 'إنشاء قاعدة الأعمال للعملية',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => 'استيراد قواعد الأعمال للعملية',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => 'قوالب البريد الإلكتروني للعملية',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => 'تعرض لوحات معلومات قوالب البريد الإلكتروني القوالب التي يمكن استخدامها داخل SugarBPM.',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => 'إنشاء قالب البريد الإلكتروني للعملية',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => 'استيراد قوالب البريد الإلكتروني للعملية',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => 'عند تطوير قوالب العمليات / قواعد الأعمال / البريد الإلكتروني في مثيل Sugar آخر، نوصي بشدة بأن يكون المثيل عبارة عن نسخة دقيقة من نظام الإنتاج لديك. قد لا تعمل قوالب العمليات / قواعد الأعمال / البريد الإلكتروني التي يتم بناؤها في مثيل مستقل من Sugar كما هو مرغوب بعد اكتمال الاستيراد. فقد تعتمد قوالب العمليات / قواعد الأعمال / البريد الإلكتروني على تغييرات معينة في الاستديو أو في مستوى التطبيقات بما في ذلك، دون الحصر، أسماء الحقول المخصصة وقيم القوائم المنسدلة ومعرفات قواعد البيانات وما إلى ذلك. إذا لم تكن هذه القيم متشابهة من المثيل الذي تم بناء العملية / قاعدة الأعمال / البريد الإلكتروني به، فقد تحتاج إلى إعادة بناء قالب العملية / قاعدة الأعمال / البريد الإلكتروني في مثيل الوجهة لديك.',
    'LBL_PMSE_IMPORT_CONFIRMATION' => 'هل ما زلت ترغب في متابعة عملية الاستيراد هذه؟',
    'LBL_PMSE_EXPORT_CONFIRMATION' => 'هل ما زلت ترغب في متابعة عملية التصدير هذه؟',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => 'تحتوي الحقول المنسدلة التالية على خيارات غير صالحة',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => 'الأنشطة المعلقة حسب العملية',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => 'الأنشطة المعلقة',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => 'الأنشطة المعلقة حسب العملية',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => 'كل العمليات',
    'LBL_RECORD_DASHBOARD' => 'لوحة معلومات السجل',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => 'ملخص حالة العملية',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => 'وصف حالة العملية',

    'LBL_PMSE_IN_PROGESS_STATUS' => 'قيد التقدم',
    'LBL_PMSE_COMPLETED_STATUS' => 'كامل',
    'LBL_PMSE_CANCELLED_STATUS' => 'ملغي',
    'LBL_PMSE_TERMINATED_STATUS' => 'منتهٍ',
    'LBL_PMSE_ERROR_STATUS' => 'خطأ',
    'LBL_PMSE_SETTINGS' => 'إعدادات SugarBPM',

    'LBL_PRO_DISABLE_CONFIRMATION' => 'هل تريد بالتأكيد تعطيل هذا السجل؟',
    'LBL_PRO_ENABLE_CONFIRMATION' => 'هل تريد بالتأكيد تمكين هذا السجل؟',
    'LBL_PRO_DELETE_CONFIRMATION' => 'هل تريد بالتأكيد حذف هذا السجل؟',

    'LBL_PRO_ENABLE' => 'تحديث',
    'LBL_PRO_DISABLE' => 'تحديث',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => 'يشارك {{link}} في عملية ما، وقد تحتوي حقول مقفلة. لتحرير السجل، انقر هنا {{link}}.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => 'هذا الحقل مقفل لأنه يشترك في عملية جارية.',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => 'يشارك هذا السجل في عملية ما، وقد يتضمن بعض الحقول المقفلة.',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => 'مركز الأعمال',
    'LBL_BUSINESS_CENTER_ID' => 'مُعرف مركز الأعمال',
    'LBL_BUSINESS_CENTER_NAME' => 'اسم مركز الأعمال',

    'LBL_PLIS_ACTIVITIES' => 'أنشطة البنود المشتراة',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(علامة جديدة)',
    'LBL_TAG_FETCH_ERROR' => 'حدث خطأ أثناء استرداد العلامات.',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'يحتاج SugarCRM إلى javascript. الرجاء تمكين javascript لمتابعة استخدام SugarCRM.',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => 'يتعذر أن تكون البيانات المتسلسلة غير متسلسلة',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => 'يتعذر أن تكون البيانات المتسلسلة غير متسلسلة لأنها تحتوي على مراجع إلى كائنات أو فئات',

    'LBL_FIELD_TRIMMED' => 'تم قص الحقل، بسبب تجاوز الحد الأقصى لعدد الحروف.',
    'LBL_FIELDSIZE_OVERFLOW' => 'يتجاوز الحقل الحد الأقصى للحروف.',
    'LBL_TINYMCE_TARGET_SAME' => 'نفس النافذة',
    'LBL_TINYMCE_TARGET_NEW' => 'نافذة جديدة',

    'LBL_OUTBOUND_EMAILS' => 'إعدادات البريد الإلكتروني',
    'LBL_OUTBOUND_EMAIL' => 'إعداد البريد الإلكتروني',

    'LBL_EMAIL_PARTICIPANTS' => 'مشتركو البريد الإلكتروني',
    'LBL_EMAIL_PARTICIPANT' => 'مشترك البريد الإلكتروني',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => 'خصوصية البيانات',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => 'خصوصية البيانات',
    'LBL_DATAPRIVACY_VIEW_PII' => 'عرض المعلومات الشخصية',
    'LBL_DATAPRIVACY_MARKFORERASE' => 'تعليم للمسح',
    'LBL_DATAPRIVACY_FIELDNAME' => 'الحقل',
    'LBL_DATAPRIVACY_VALUE' => 'القيمة',
    'LBL_DATAPRIVACY_CHANGED_BY' => 'تغيير بواسطة',
    'LBL_DATAPRIVACY_SOURCE' => 'المصدر',
    'LBL_DATAPRIVACY_CHANGE_DATE' => 'آخر تحديث',
    'LBL_DATAPRIVACY_PII' => 'المعلومات الشخصية',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => 'تعليم للمسح',
    'TPL_DATAPRIVACY_PII_TITLE' => 'معلومات شخصية لـ {{{name}}}',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => 'تغيير المؤقتات',
    'LBL_MESSAGES_SUBPANEL_TITLE' => 'الرسائل',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => 'تم النسخ إلى الحافظة الخاصة بك!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => 'تعذر النسخ إلى الحافظة الخاصة بك',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => 'نسخ ارتباط التأكيد',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => 'المخطط الزمني',
    'LBL_NO_ACTIVITY' => 'لا نشاط',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => 'مخطط {{moduleSingular}} الزمني',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => 'أكثر',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => 'أقل',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => 'يعرض المخطط الزمني السجلات ذات الصلة بالسجل الحالي ويحدد تحديثات الحقول بمرور الوقت.',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => 'عرض المزيد...',
    'LBL_COMMENT_LOG_SHOW_LESS' => 'عرض القليل...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => 'لا تتوفر بيانات',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => 'الوحدة غير مرخصة.',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => 'الاشتراكات النشطة',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => 'يمكن إضافة لوحة المعلومات هذه إلى الوحدات التي ترتبط بحساب فردي فقط. ارجع إلى وثائق <a href={{linkToDocumentation}}>لوحة معلومات الاشتراكات النشطة</a> لمزيد من المعلومات.',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => 'عرض المشتريات التي تنتمي إلى هذا الحساب المرتبط:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => 'الاشتراكات النشطة لحساب معين.',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => '، الكمية {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => 'الإجمالي:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => 'لا اشتراكات نشطة',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => 'تتطلب لوحة المعلومات هذه عمل {{module_name}}. تحدث إلى المسؤول بشأن تمكين {{module_name}}.',
    'LBL_PURCHASE_HISTORY_DASHLET' => 'سجل الشراء',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => 'كل المشتريات لحساب معين.',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => 'يمكن إضافة لوحة المعلومات هذه للوحدات التي ترتبط بحساب فردي فقط. ارجع إلى وثائق <a href={{linkToDocumentation}} target="_blank">لوحة معلومات سجل الشراء</a> لمزيد من المعلومات.',
    'LBL_NO_PURCHASE_HISTORY' => 'لا مشتريات لعرضها',
    'LBL_NO_PLIS' => 'لا بنود مشتراة',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => 'الإجمالي',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => 'الكمية',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => 'تتطلب لوحة المعلومات هذه وجود بنود مشتراة للعمل. تحدث إلى المسؤول بشأن تمكين المشتريات والبنود المشتراة.',
    'LBL_SEARCH_PURCHASE_NAME' => 'بحث حسب اسم عملية الشراء...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => 'استخدم Studio لتحرير تخطيط لوحة معلومات عرض السجل بالانتقال إلى ' .
        'الاستوديو > {{module}} > المخططات > لوحة معلومات عرض السجل. <a href={{linkToStudio}}>تحرير في الاستوديو</a>.',
    'LBL_SERVICE_LEVEL' => 'مستوى الخدمة',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => 'الرقم',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => 'المتابعة',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => 'الأولوية/الحالة',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => 'الموضوع/الوصف',

//Service Duration
    'LBL_SERVICE_DURATION' => 'مدة الخدمة',
    'LBL_SERVICE_DURATION_VALUE' => 'قيمة مدة الخدمة',
    'LBL_SERVICE_DURATION_UNIT' => 'وحدة مدة الخدمة',
    'LBL_LOCK_DURATION' => 'مدة القفل',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'تعذر تحميل Amazon Connect CCP. الرجاء' .
        'التأكد من أنك تستخدم ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">المستعرض المدعوم</a>. ' .
        'في حالة استمرار المشكلة، الرجاء الاتصال بمسؤول Sugar.',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => 'لم يقم مسؤول Sugar بتكوين المثيل الخاص بك لـ Amazon Connect.',
    'ERROR_OMNICHANNEL_TIMEOUT' => 'تعذر تأسيس اتصال مع Amazon Connect. الرجاء الاتصال بمسؤول Sugar للمساعدة.',
    'LBL_OMNICHANNEL_UNKNOWN' => 'غير معروف',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => 'درج التنظيم',
    'LBL_CLOSE_FOCUS_DRAWER' => 'إغلاق درج التنظيم',
    'LBL_EXTERNAL_GUESTS' => 'الضيوف الخارجيون',
    'LBL_MY_FAVORITE_TASKS' => 'مهامي المفضلة',
    'LBL_RECORD' => 'السجل',

    'LBL_MY_TASKS' => 'مهامي',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => 'تعذر العثور على الحقل: {0} في الوحدة: {1}',
    'LBL_INTEGRATE_INVALID_PARAM' => 'تعذر العثور على الحقل: {0}: {1} في الوحدة: {2}',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => 'تعذر العثور على علاقة بالاسم: {0}',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => 'إدخال قاعدة بيانات بالمعرف: {0}، والاسم {1}: {2} في الوحدة {3} موجود بالفعل',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => 'تم حذفه مؤقتًا (مع إضافة راية حذف = 1)',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => 'تم العثور على سجلات قواعد بيانات متعددة لـ {0} {1} في الوحدة {2}. ' .
        'الرجاء إزالة السجلات المطابقة أو تحديثها وفقًا لذلك. السجلات المطابقة: {3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => 'التشغيل التالي',
    'LBL_TIME_AWARE_TYPE' => 'النوع',
    'LBL_TIME_AWARE_BEAN_ID' => 'معرف المكون البرمجي',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => 'عرض التسمية',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => 'فتح طريقة عرض السجل',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => 'إضافة',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => 'التعليمات غير متوفرة',
    'LBL_ACTIONBUTTON_FUNCTIONS' => 'الوظائف',
    'LBL_ACTIONBUTTON_FIELDS' => 'الحقول',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => 'تحديد الحقل...',
    'LBL_ACTIONBUTTON_ROLLUP' => 'القيمة المحتسبة',
    'LBL_ACTIONBUTTON_RELATED' => 'ذات صلة',
    'LBL_ACTIONBUTTON_SAVE' => 'حفظ',
    'LBL_ACTIONBUTTON_CANCEL' => 'إلغاء',
    'LBL_ACTIONBUTTON_R_MODULE' => 'الوحدة ذات الصلة',
    'LBL_ACTIONBUTTON_R_FIELDS' => 'الحقول ذات الصلة',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => 'وحدة القيمة المحتسبة',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => 'حقول القيمة المحتسبة',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => 'وظيفة القيمة المحتسبة',
    'LBL_ACTIONBUTTON_MINIMUM' => 'الأدنى',
    'LBL_ACTIONBUTTON_MAXIMUM' => 'الأقصى',
    'LBL_ACTIONBUTTON_AVERAGE' => 'المتوسط',
    'LBL_ACTIONBUTTON_SUM' => 'المجموع',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => 'تعيين السجل',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => 'إنشاء بريد إلكتروني',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => 'إنشاء سجل',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'دمج المستندات',
    'LBL_ACTIONBUTTON_OPEN_URL' => 'فتح عنوان Url',
    'LBL_ACTIONBUTTON_RUN_REPORT' => 'تشغيل التقرير',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => 'تحديث السجل',
    'LBL_ACTIONBUTTON_ACTION' => 'الإجراء',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => 'تعيين إلى',
    'LBL_ACTIONBUTTON_EMAIL_TO' => 'بريد إلكتروني إلى',
    'LBL_ACTIONBUTTON_USE_PMSE' => 'استخدام PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => 'القالب',
    'LBL_ACTIONBUTTON_MODULE' => 'الوحدة',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => 'إعدادات العرض',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => 'النوع',
    'LBL_ACTIONBUTTON_DROPDOWN' => 'القائمة المنسدلة',
    'LBL_ACTIONBUTTON_BUTTON' => 'الزر',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => 'مجموعة الأزرار',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => 'عرض التسمية على السجل',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => 'عرض في الرأس',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => 'إخفاء عند التحرير',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => 'عرض على رأس درج التنظيم',
    'LBL_ACTIONBUTTON_DASHBOARD' => 'لوحة المعلومات',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => 'رأس درج التنظيم',
    'LBL_ACTIONBUTTON_SIZE' => 'الحجم',
    'LBL_ACTIONBUTTON_DEFAULT' => 'الافتراضي',
    'LBL_ACTIONBUTTON_SMALL' => 'صغير',
    'LBL_ACTIONBUTTON_LARGE' => 'كبير',
    'LBL_ACTIONBUTTON_CALCULATED' => 'محسوب',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => 'تحويل إلى PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => 'دمج المستندات',
    'LBL_ACTIONBUTTON_URL' => 'عنوان URL',
    'LBL_ACTIONBUTTON_PREVIEW' => 'معاينة',
    'LBL_ACTIONBUTTON_PROPERTIES' => 'الخصائص',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => 'التسمية',
    'LBL_ACTIONBUTTON_DESC' => 'تعريف الأدوات',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => 'إظهار التسمية',
    'LBL_ACTIONBUTTON_SHOW_ICON' => 'إظهار الأيقونة',
    'LBL_ACTIONBUTTON_SCHEME' => 'نظام الألوان',
    'LBL_ACTIONBUTTON_ICON' => 'الأيقونة',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => 'تابع',
    'LBL_ACTIONBUTTON_DESIGN' => 'تكوين التخطيط',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => 'التوقف عند الخطأ',
    'LBL_ACTIONBUTTON_AUTOSAVE' => 'حفظ تلقائي',
    'LBL_ACTIONBUTTON_CONFIG' => 'تكوين',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => 'الرجاء تكوين زر الإجراء قبل الحفظ.',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => 'تكوين الأزرار',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => 'إنشاء تلقائي',
    'LBL_ACTIONBUTTON_LINK' => 'إنشاء علاقة مع الأصل',
    'LBL_ACTIONBUTTON_COPY_PARENT' => 'نسخ القيم الأصلية',
    'LBL_ACTIONBUTTON_PRESET' => 'ضبط قيمة (قيم) الحقل',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => 'نسخ قيمة (قيم) الحقل من الأصل',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => 'تحديد...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => 'من الحقل الأصلي ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => 'هل تريد بالتأكيد حذف هذا الزر؟',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => 'هل تريد بالتأكيد حذف هذا الإجراء؟',
    'LBL_ACTIONBUTTON_INVALID_DATA' => 'بيانات زر إجراء غير صحيحة',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => 'الرجاء تحديد وحدة قبل الحفظ.',
    'LBL_ACTIONBUTTON_SELECT_LINK' => 'الرجاء تحديد ارتباط قبل الحفظ. إذا لم يتوفر ارتباط، الرجاء إلغاء تحديد خيار الارتباط هذا.',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => 'الرجاء تحديد سجل قبل الحفظ.',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => 'الرجاء تحديد قالب قبل الحفظ.',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => 'الرئيسي',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => 'الثانوي',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'رؤية مرتفعة',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => 'محيط',
    'LBL_ACTIONBUTTON_THEME_PINK' => 'وردي',
    'LBL_ACTIONBUTTON_THEME_ARMY' => 'عسكري',
    'LBL_ACTIONBUTTON_THEME_TEAL' => 'أزرق مخضر',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => 'باسيفيك',
    'LBL_ACTIONBUTTON_THEME_GREEN' => 'أخضر',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => 'أصفر',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => 'برتقالي',
    'LBL_ACTIONBUTTON_THEME_RED' => 'أحمر',
    'LBL_ACTIONBUTTON_THEME_CORAL' => 'مرجاني',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => 'أرجواني',
    'LBL_ACTIONBUTTON_FORMULA' => 'الصيغة',
    'LBL_ACTIONBUTTON_ACTIONS' => 'الإجراءات',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => 'خطأ في التحقق من صحة بيانات الزر.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => 'تحتاج الأزرار إلى ضبط تسمية أو أيقونة على الأقل.',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => 'الرجاء إدخال تسمية زر صحيحة.',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => 'لا يمكن إنشاء السجل بسبب غياب قيم مطلوبة. الرجاء الاتصال بالمسؤول.',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => 'يجب أن يكون لديك زرين نشطين على الأقل لهذا النوع من الأزرار.',
    'LBL_ACTIONBUTTON_RECORD' => 'طرق عرض السجلات',
    'LBL_ACTIONBUTTON_ACTION_MENU' => 'قوائم الإجراءات',
    'LBL_ACTIONBUTTON_ORDER' => 'ترتيب',
    'LBL_ACTIONBUTTON_LIST_VIEW' => 'طريقة عرض القائمة',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => 'رأس عرض السجل',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => 'رأس لوحة معلومات عرض السجل',
    'LBL_ACTIONBUTTON_SUBPANELS' => 'اللوحات الفرعية',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => 'فشل محرك تنفيذ تسلسل المهمة في تنفيذ الإجراءات التالية: ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => 'إضافة إجراء',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => 'إزالة هذا الإجراء',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => 'المستخدم الحالي',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => 'دمج المستندات',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => 'دمج المستندات مع PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => 'حجم الشركة',
    'LBL_HINT_COMPANY_INDUSTRY' => 'الصناعة',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => 'علامات الصناعة',
    'LBL_HINT_COMPANY_LOCATION' => 'موقع الشركة',
    'LBL_HINT_COMPANY_DESCRIPTION' => 'وصف الشركة',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => 'عام التأسيس',
    'LBL_HINT_COMPANY_FACEBOOK' => 'صفحة Facebook الشركة',
    'LBL_HINT_COMPANY_TWITTER' => 'صفحة Twitter الشركة',
    'LBL_HINT_COMPANY_PIC' => 'شعار الشركة',
    'LBL_HINT_CONTACT_PIC' => 'صورة الاتصال',
    'LBL_HINT_COMPANY_WEBSITE' => 'موقع ويب الشركة',
    'LBL_HINT_PHOTO' => 'ارتباط الصورة',
    'LBL_HINT_JOB_2' => 'الوظائف السابقة',
    'LBL_HINT_EDUCATION' => 'التعليم',
    'LBL_HINT_EDUCATION_2' => 'التعليم الإضافي',
    'LBL_HINT_TWITTER' => 'ارتباط Twitter',
    'LBL_HINT_FACEBOOK' => 'ارتباط Facebook',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'رمز NAICS',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'رمز SIC',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => 'انتهاء السنة المالية',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => 'العائد السنوي',
    'LBL_HINT_PHONE_1' => 'الهاتف 1',
    'LBL_HINT_PHONE_2' => 'الهاتف 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => 'جدول الربط',
    'LBL_HINT_FULL_NAME' => 'الاسم الكامل',
    'LBL_HINT_JOB_TITLE' => 'المسمى الوظيفي',
    'LBL_HINT_OFFICE_PHONE' => 'هاتف المكتب',
    'LBL_HINT_MOBILE_PHONE' => 'المحمول',
    'LBL_HINT_OTHER_PHONE' => 'هاتف آخر',
    'LBL_HINT_WEBSITE' => 'موقع الويب',
    'LBL_HINT_MSG_OVERWRITE_ALL' => 'هل ترغب في الكتابة فوق كل البيانات الحالية لهذا السجل باستخدام البيانات الجديدة الموجودة في Sugar Hint؟',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => 'هل ترغب في الكتابة فوق {{fieldName}} الحالي لهذا السجل باستخدام {{fieldName}} الجديد الموجود في Sugar Hint؟',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => 'ستتم إزالة كل البيانات المرتبطة بالحساب، هل تريد بالتأكيد المتابعة؟',
    'LBL_HINT_COMPANY_LOGO' => 'الشعار',
    'LBL_HINT_CONTACTS_AVATAR' => 'الصورة',
    'LBL_HINT_ACCOUNTSETS' => 'علامات مجموعات حسابات Sugar Hint',

    'LBL_HINT_LOADING' => 'جارٍ التحميل ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => 'يتم إلغاء تثبيت Sugar Hint، يرجى الانتظار',
    'LBL_HINT_VALUE_ERASED' => ' تم مسح القيمة ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => 'تم مسح هذه المعلومات عبر طلب خصوصية بيانات',

    'LBL_HINT_UNINSTALL_TITLE' => 'الرجاء تحديد أحد خيارات إلغاء التثبيت أدناه:',
    'LBL_HINT_UNINSTALL_PARTIAL' => 'إلغاء تثبيت حزمة Hint فقط',
    'LBL_HINT_UNINSTALL_FULL' => 'إلغاء تثبيت Hint بالكامل',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => 'سيزيل هذا الخيار Hint MLP ويعطل كل الاشتراكات النشطة في Sugar Hint Insights.
    سيؤدي إعادة تثبيت Hint إلى إعادة تنشيط الاشتراكات تلقائيًا.',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => 'سينفذ هذا الخيار إلغاء تثبيت كامل لـ Hint، بما في ذلك إزالة MLP وحذف كل معلومات التكوين والاشتراك.',
    'LBL_HINT_UNINSTALL' => 'إلغاء التثبيت',
    'LBL_HINT_UNINSTALL_HEADER' => 'إلغاء تثبيت Sugar Hint',
    'LBL_HINT_CANCEL' => 'إلغاء',
    'LBL_HINT_UNINSTALL_WARNING1' => 'تحذير: حدد هذا الخيار فقط إذا كنت لا تنوي استخدام Hint مرة أخرى في المستقبل.
    قبل تنفيذ إلغاء التثبيت، اصنع نسخة احتياطية كاملة من قاعدة بيانات Sugar وضع Sugar في وضع الصيانة. ',
    'LBL_HINT_UNINSTALL_WARNING2' => 'انظر ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'دليل إدارة Sugar Hint ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => 'لتفاصيل عن عملية إلغاء التثبيت.',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => 'هل تريد بالتأكيد إلغاء تثبيت حزمة Sugar Hint فقط؟',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => 'هل تريد بالتأكيد إلغاء تثبيت Sugar Hint بالكامل؟',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(ملاحظة: لا يمكنك التراجع عن هذا الإجراء)',

    'LBL_HINT_CONFIG_TITLE' => 'حقول Sugar Hint',
    'LBL_HINT_NO_RESULTS_MSG' => 'لم يتم العثور على نتائج.',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => 'تخطيط لوحة Hint الأساسية',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => 'الحسابات',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => 'جهات الاتصال',
    'LBL_HINT_CONFIG_TAB_LEADS' => 'العملاء المتوقعون',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => 'تخطيط لوحة Hint الموسعة',
    'LBL_HINT_CONFIG_DIR_PAR1' => 'أعد ترتيب الحقول بالسحب والإسقاط داخل أقسام تخطيط لوحة Hint أعلاه.',
    'LBL_HINT_CONFIG_DIR_PAR2' => 'للحصول على تعليمات تفضيلية وقائمة بالحقول الافتراضية، ارجع إلى ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' لاستعادة الإعدادات الافتراضية ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => 'للوحدة.',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => 'هل تريد بالتأكيد استعادة الإعدادات الافتراضية للوحدة {{module}}؟',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => 'انقر هنا',
    'LBL_HINT_CONFIG_NAME' => 'دليل إدارة Hint.',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => 'الحقول',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => 'الحقول المحسنة',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => 'يسرد هذا القسم كل حقول Hint وحقول Sugar المحسنة بواسطة Hint. حقول Hint موضوع عليها العلامة (*) وتظهر فقط في لوحة Hint في حالة تحسينها.',
    'LBL_HINT_CONFIG_FIELD_NAME' => 'اسم الحقل',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => 'تحسين الحقل',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => 'إظهار في Hint',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => 'إظهار في لوحة Hint',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => 'حقول Sugar الإضافية',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => 'يسرد هذا القسم كل حقول Sugar التي لم يتم تحسينها بواسطة Hint.',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => 'تحذير',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => 'تنبيه: أنت على وشك المزامنة مع خدمة Sugar Hint Insights. سيتم فقد أي قصص ملخصات بريد إلكتروني معلقة، وسيتم مسح الأخبار الحالية من لوحة معلومات Insights. سيتم استئناف الإشعارات من جميع الأنواع بعد اكتمال المزامنة.',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => 'تظهر أدناه الشركات المقترحة ذات الصلة بـ {{_moduleSingular}}. حدد بيانات الشركة لعرضها.',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => 'لم يتم تحديد حساب',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => 'تم العثور على رسائل بريد إلكتروني متعددة، حدد رسائل البريد الإلكتروني التي تريد استيرادها: ',

    'LBL_HINT_HELP_MESSAGE1' => 'استنادًا إلى البيانات المدخلة، لم يتمكن Hint من العثور على تطابق في النظام.',
    'LBL_HINT_HELP_MESSAGE2' => 'يمكن العثور على أفضل النتائج في Hint باستخدام اسم شخص وعنوان بريد إلكتروني.',
    'LBL_HINT_HELP_MESSAGE3' => 'يمكن العثور على أفضل النتائج في Hint باستخدام عنوان url موقع ويب الشركة.',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "أدخل اسم شركة أو موقع ويب {{_moduleSingular}} وسيبحث Hint عن بيانات إضافية.",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "أدخل عنوان البريد الإلكتروني لـ {{currentModule}} وسيبحث Hint عن بيانات إضافية.",

    'LBL_HINT_HISTORY_NONE' => 'لا بيانات متاحة لطريقة العرض التاريخية',
    'LBL_HINT_HISTORY_TITLE' => 'سجل النشاط',

    'LBL_HINT_PREVIEW_TITLE' => 'تحسين البيانات',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'انتهى ترخيصك لخدمة Hint. اتصل بمسؤول SugarCRM لتجديد ترخيصك.',
    'LBL_HINT_PREVIEW_QUESTION' => 'هل تريد رؤية ما يمكن لـ Hint فعله لك ولشركتك؟ اتصل بمسؤول SugarCRM لإضافة Hint.',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => 'لم يتم العثور على معلومات الحساب',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => 'تم العثور على بيانات محسنة - انقر لحفظ كل البيانات المحسنة في سجلك.',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => 'انقر لحفظ كل البيانات المحسنة في سجلك.',

    'LBL_HINT_CONTACTS_TITLE' => 'جهات الاتصال ذات الصلة',
    'LBL_HINT_CONTACTS_NONE' => 'لا توجد جهات تصال ذات صلة',

    'LBL_HINT_NEWS' => 'الأخبار',
    'LBL_HINT_GENERAL' => 'عام',
    'LBL_HINT_ALL_NEWS' => 'كل الأخبار',
    'LBL_HINT_FILTER_NEWS' => 'تصفية الأخبار',
    'LBL_HINT_FINANCIAL_NEWS' => 'مالي',
    'LBL_HINT_PERSONNEL_NEWS' => 'العاملون',
    'LBL_HINT_PRESS_RELEASES' => 'الإصدارات الصحفية',
    'LBL_HINT_OTHER_NEWS' => 'أخرى',
    'LBL_HINT_NEWS_PLACEHOLDER' => 'بحث عن مقالات صحفية',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => 'لا أخبار متاحة',
    'LBL_NEW_NOTIFICATIONS' => 'إشعارات جديدة',
    'LBL_HINT_DASHLET_ALLOWED1' => 'يجب امتلاك ترخيص Sugar Hint لعرض لوحة معلومات Hint Insights.
    استفسر من مسؤولك عن طريقة الحصول على ترخيص Sugar Hint.',

    'LBL_HINT_FOR' => 'لـ',
    'LBL_HINT_WITH' => 'مع',
    'LBL_HINT_SHOW_ME' => 'إظهار لي: ',
    'LBL_HINT_NOTIFY_ME_BY' => 'إبلاغي بحلول: ',

    'LBL_NOTIFICATIONS_TITLE' => 'مركز تفضيلات Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE' => 'مفتاح خيار التفضيل',
    'LBL_HINT_PREFERENCES' => 'التفضيلات',
    'LBL_HINT_MINIMUM_PREFERENCES' => 'تم تعطيل الحذف، يجب توافر بيان تفضيل واحد بحد أدنى',
    'LBL_HINT_MAXIMUM_PREFERENCES' => 'تم تعطيل الإضافة، لقد وصلت إلى الحد الأقصى من بيانات التفضيلات',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => 'تضمين في لوحة معلومات Sugar Hint Insights',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => 'الظهور كإشعار سطح مكتب',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => 'يجب تمكين الإشعارات على كل المتصفحات وعلى كل أجهزة كمبيوتر سطح المكتب للتسلم الدائم للإشعارات.',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => 'لا تدعم بعض المتصفحات، مثل Internet Explorer، الإشعارات. لا يمكن تمكين الإشعارات عند استخدام متصفح لا يدعم الإشعارات.',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => 'إرسال تنبيه بريد إلكتروني فوري لكل إشعار',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => 'إرسال ملخص بريد إلكتروني يومي',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => 'إرسال ملخص بريد إلكتروني أسبوعي',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => 'تعذر حفظ التفضيلات. راجع اتصال نظامك وحاول مرة أخرى.',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => 'بعض الحقول المطلوبة تفتقد قيمة. الرجاء مراجعة تفضيلاتك والتأكد من أن كل الحقول المطلوبة مملوءة.',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => 'أنت على وشك تمكين إشعارات المتصفح لـ Sugar Hint Insights. انقر على "تأكيد" للتقدم. سيطلب منك متصفحك بعد ذلك إذنًا للسماح بتسلم أحداث الإشعارات.',
    'LBL_HINT_PUSH_ERROR' => 'تم تسجيل المكون الإضافي "الإشعارات المباشرة" لـ {{options.type}} دون تبعياته. لن يعمل المكون الإضافي بالشكل المطلوب، الرجاء التأكد من توفيرك لمسار إلى ملف العمل ولطريقة لحفظ الاشتراك على الخادم.',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => 'تشغيل إشعارات Hint لكل المستخدمين',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => 'إيقاف إشعارات Hint لكل المستخدمين',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => 'تحذير: فَشل تعطيل الإشعارات أثناء إلغاء تثبيت Sugar Hint Insights. لتعطيل الإشعارات، قم بتثبيت Sugar Hint 5.4.0 أو إصدارًا أحدث ونفذ إلغاء تثبيت كامل باستخدام Sugar Hint Uninstaller الموجود في قسم "الإدارة" في Sugar.',
    'LBL_HINT_ENRICH_ALL' => 'تحسين الكل',
    'LBL_HINT_NO_LICENSE_ACCESS' => 'ترخيص Hint مطلوب',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => 'تكوين الخرائط',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => 'عارض سجل الترميز الجغرافي',
    'LBL_MAP_MAP' => 'الخريطة',
    'LBL_MAP_MAPS' => 'الخرائط',
    'LBL_MAP_GEOCODING_RECORD' => 'الرمز الجفرافي',
    'LBL_MAP_GEOCODE_SUCCESS' => 'تم الترميز الجغرافي للسجل بنجاح.',
    'LBL_MAP_LATITUDE' => 'خط العرض',
    'LBL_MAP_LONGITUDE' => 'خط الطول',
    'LBL_MAP_SEARCH_BY_ADDRESS' => 'البحث حسب العنوان...',
    'LBL_MAP_ALREADY_GEOCODED' => 'السجل الحالي مرمز جغرافيًا بالفعل. هل تريد بالتأكيد الكتابة فوق الترميز الجغرافي لهذا السجل؟',
    'LBL_MAPS_MANUAL_GEOCODING' => 'ترميز جغرافي يدوي',
    'LBL_MAP_POINT_COORDINATES' => 'إحداثيات نقطة الخريطة',
    'LBL_MAP_CALCULATING_DIRECTIONS' => 'جارٍ حساب المسار الأمثل...',
    'LBL_MAP_DIRECTIONS' => 'الاتجاهات',
    'LBL_MAP_DIRECTIONS_FROM_USER' => 'الاتجاهات بداية من المستخدم الحالي',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => 'الاتجاهات بداية من هذا السجل',
    'LBL_MAPS_RADIUS_INPUT' => 'نصف القطر (0-250)',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => 'في نصف قطر من الرمز البريدي',
    'LBL_MAPS_DISTANCE' => 'المسافة',
    'LBL_MAPS_CENTER_ZIP_CODE' => 'الرمز البريدي',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => 'تكوين غير صحيح: ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> تعيينات الحقل غير صالحة.',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => 'نوع الخريطة',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => 'مستوى التكبير',
    'LBL_MAPS_DASHLET' => 'الخرائط',
    'LBL_MAPS_DASHLET_DESCRIPTION' => 'تعرض السجل (السجلات) المرمزة جغرافيًا على الخريطة.',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => 'لا تتوفر الخرائط لهذه الوحدة. الرجاء تمكينها في وحدة تحكم "المسؤول".',
    'LBL_MAP_MODULES' => 'الوحدة',
    'LBL_MAP_FILTER_BY' => 'تصفية حسب',
    'LBL_MAP_UNIT_TYPE' => 'نوع الوحدة',
    'LBL_MAP_UNIT_TYPE_MILES' => 'أميال',
    'LBL_MAP_UNIT_TYPE_KM' => 'كيلومترات',
    'LBL_MAP_ADDRESS' => 'العنوان',
    'LBL_MAP_NO_STARTING_POINT' => 'نقطة البدء غير مرمزة جغرافيًا.',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => 'سجل نقطة البدء غير مرمز.',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => 'بعض من السجلات المحددة غير مرمز ولن يُعرض على الخريطة.',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => 'السجل (السجلات) غير مرمزة جغرافيًا.',
    'LBL_MAPS_MODULE_FIELDS' => 'حقول الوحدة',
    'LBL_MAPS_SELECT_FIELD' => 'تحديد الحقل',
    'LBL_MAPS_RELATE_RECORD' => 'السجل ذو الصلة',
    'LBL_MAPS_MAPPING_TYPE' => 'نوع التعيين',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => 'لا سجلات مرمزة جغرافيًا',
    'LBL_MAPS_ADDRESS' => 'العنوان',
    'LBL_MAPS_ASSIGNED_USER_NAME' => 'المستخدم المعين',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => 'طريقة عرض الشارع غير متوفرة للنقطة المعطاة',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> السجلات غير صالحة للتعيين. الرجاء إزالة الوحدة من القائمة.',
    'LBL_MAPS_CLOSE_TOOLTIP' => 'إغلاق',
    'LBL_MAPS_EXPAND_TOOLTIP' => 'توسيع',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => 'حفظ بتنسيق PDF',
    'LBL_MAPS_EMAIL_LINK' => 'ارتباط البريد الإلكتروني',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => 'يجب أن يكون لديك سجل مرمز جغرافيًا واحدًا على الأقل.',
    'LBL_MAPS_GENERATING' => 'جارٍ إنشاء الخريطة...',
    'LBL_MAPS_POINTS' => 'نقاط الخريطة',
    'LBL_MAPS_POINT' => 'النقطة',
    'LBL_MAPS_TRAVEL_DETAILS' => 'تفاصيل السفر',
    'LBL_MAPS_TOTAL_DISTANCE' => 'إجمالي المسافة',
    'LBL_MAPS_TOTAL_DURATION' => 'إجمالي المدة',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => 'إجمالي المدة دون مرور',
    'LBL_MAPS_ITINERARY' => 'المسار',
    'LBL_MAPS_TRAVEL_DISTANCE' => 'مسافة السفر',
    'LBL_MAPS_TRAVEL_DURATION' => 'مدة السفر',
    'LBL_MAPS_TRAVEL_STEPS' => 'الخطوات',
    'LBL_MAPS_TRAVEL_WARNINGS' => 'تحذيرات',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => 'تدعم خرائط Bing عدد 10 نقاط بحد أقصى على خريطة تمت مشاركتها. الرجاء مراجعة اختياراتك.',
    'LBL_MAPS_NO_LICENSE_ACCESS' => 'ترخيص الخرائط مطلوب',
    'LBL_MAPS_SHARE_HELLO' => 'مرحبًا،',
    'LBL_MAPS_SHARE_HEADER' => 'لقد طلبت خريطة Bing للنقاط التالية:',
    'LBL_MAPS_SHARE_OPEN_URL' => 'سيفتح عنوان URL التالي خريطة تحتوي على النقاط أعلاه على خرائط Bing:',
    'LBL_MAPS_SHARE_SHOW_MAP' => 'إظهار الخريطة على خرائط Bing',
    'LBL_MAPS_MAP_ON_BING_WEB' => 'خرائط Bing',
    'LBL_MAPS_NO_VALID_ITINERARY' => 'لم يتم العثور على مسار لنقاط الطريق المحددة.',
    'LBL_MAPS_GEOCODE_STATUS' => 'حالة الترميز الجغرافي',
    'LBL_MAPS_GEOCODED' => 'مرمز جعرافيًا',
    'LBL_MAPS_NOT_GEOCODED' => 'غير مرمز جغرافيًا',
    'LBL_MAPS_NOT_FOUND' => 'عنوان غير صالح',
    'LBL_MAPS_GEOCODING_FAILED' => 'فشل الترميز الجغرافي',
    'LBL_MAPS_QUEUED' => 'وضع في قائمة الانتظار',
    'LBL_MAPS_REQUEUED' => 'تمت إعادة الوضع في قائمة الانتظار',
    'LBL_MAPS_RELATED_RECORD' => 'السجل ذو الصلة',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => 'عرض التقرير',
    'LBL_REPORT_DASHLET_DESC' => 'عرض تقرير محفوظ',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => 'إعادة الضبط إلى القيم الافتراضية للوحة المعلومات',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => 'إعادة الضبط إلى القيم الافتراضية للتقرير',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => 'تحديث النتائج',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => 'نسخ المخطط إلى الحافظة',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => 'تنزيل المخطط',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => 'تم تحرير تقرير لوحة المعلومات {{label}} وتمت إعادة تعيين لوحة المعلومات إلى التكوين الافتراضي.',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => 'ليس لديك إذن لاستخدام هذا الحقل.',

    'LBL_INVALID_FORMULA' => 'صيغة غير صالحة',
    'LBL_RETURN_TYPE_MISSMATCH' => 'نوع إرجاع الوظيفة غير مطابق',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => 'التنبؤ',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => 'ملف العميل المثالي',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => 'إغلاق درجات تنبؤ الأسبوع',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => 'قيمة التنبؤ',
    'LBL_AI_CONV_BIN_ACCURACY' => 'دقة سلة التنبؤ',
    'LBL_AI_CONV_MULTIPLIER' => 'مضاعف التنبؤ',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'قيمة ICP',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'دقة سلة ICP',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'مضاعف ICP',
    'LBL_AI_NEW' => 'جديد',
    'LBL_AI_ENTERED' => 'تم إدخاله',
    'LBL_AI_CREATED' => 'تم إنشاؤه',
    'LBL_AI_WEEK' => 'الأسبوع',
    'LBL_AI_MONTH' => 'الشهر',
    'LBL_AI_QUARTER' => 'ربع السنة',
    'LBL_AI_BYWEEK' => 'حسب الأسبوع',
    'LBL_AI_BYMONTH' => 'حسب الشهر',
    'LBL_AI_BYQUARTER' => 'حسب الربع',
    'LBL_AI_WEEKTREND' => 'التوجه الأسبوعي',
    'LBL_AI_MONTHLYTREND' => 'التوجه الشهري',
    'LBL_AI_QUARTERTREND' => 'التوجه لكل ربع سنة',
    'LBL_AI_TREND' => 'التوجه حسب',
    'LBL_AI_TRENDS' => 'التوجهات حسب',
    'LBL_AI_VELOCITY' => 'السرعة',
    'LBL_AI_TOPX' => 'أعلى {X}',
    'LBL_AI_TIMESPAN' => 'الفترة الزمنية بين المراحل -',
    'LBL_AI_BUSINESSTREND' => 'مع اتجاهات الأعمال',
    'LBL_AI_SUGARINSIGHTINTRO' => 'نقدم Sugar Insights!',
    'LBL_AI_SUGARINSIGHTSDESC' => 'يستفيد Sugar Insights من التحليل الكمي لتوليد رؤى جديدة حول بيانات SugarCRM الخاصة بك. في Sugar، نبحث دائما عن طرق جديدة لمساعدتك في تحقيق أقصى استفادة من بياناتك، واتخاذ قرارات مستنيرة، وهذه مجرد بداية لما نأمل في تقديمه مع Sugar Insights.',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'يستفيد Sugar Insights من التحليل الكمي لتوليد رؤى جديدة حول بيانات SugarCRM الخاصة بك.',
    'LBL_AI_FIRMO' => 'فيرموغرافيكس',
    'LBL_AI_TOTALCOUNT' => 'العدد الإجمالي من',
    'LBL_AI_DAYSFROMLATESTACT' => 'الأيام منذ آخر',
    'LBL_AI_DAYSSINCE' => 'العمر',
    'LBL_AI_FIELDISSET' => 'يوجد',
    'LBL_AI_CONTACTCOMPLETENESS' => 'اكتمال معلومات الاتصال',
    'LBL_AI_CUTDATE' => 'فترة التنبؤ',
    'LBL_AI_FROMLASTCHANGE' => 'أيام من آخر تغيير في قيمة الميزة',
    'LBL_AI_CALLSHELD' => 'إجمالي عدد المكالمات التي تم إجراؤها',
    'LBL_AI_CALLSPLANNED' => 'إجمالي عدد المكالمات المخطط لها',
    'LBL_AI_OUTBOUNDCALLS' => 'إجمالي عدد المكالمات الصادرة',
    'LBL_AI_INBOUNDCALLS' => 'إجمالي عدد المكالمات الواردة',
    'LBL_AI_AVGCALLDURATION' => 'متوسط مدة المكالمات',
    'LBL_AI_EMAILSARCHIVED' => 'إجمالي عدد رسائل البريد الإلكتروني المؤرشفة',
    'LBL_AI_EMAILSREAD' => 'إجمالي عدد رسائل البريد الإلكتروني المقروءة',
    'LBL_AI_EMAILSSENT' => 'إجمالي عدد رسائل البريد الإلكتروني المرسلة',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => 'إجمالي عدد السجلات التي تم فيها تغيير تاريخ الإغلاق المتوقع إلى تاريخ لاحق',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => 'إجمالي عدد السجلات التي تم فيها تغيير تاريخ الإغلاق المتوقع إلى تاريخ لاحق',
    'LBL_AI_AMOUNTINCREASED' => 'مجموع الفرص التي زاد فيها المبلغ',
    'LBL_AI_AMOUNTDECREASED' => 'مجموع الفرص التي انخفض فيها المبلغ',

    // User last state
    'LBL_LAST_STATE' => 'الحالة الأخيرة',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => 'إرسال إلى DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => 'إلغاء تحرير المستلم',
    'LBL_RECIPIENT_ROLE' => 'دور المستلم',
    // Base sales stages
    'LBL_OPEN' => 'مفتوحة',
    'LBL_CLOSED_WON' => 'إغلاق لسبب الفوز',
    'LBL_CLOSED_LOST' => 'إغلاق لسبب الخساره',
    'LBL_KIOSK_ADD_FILES' => 'إضافة ملفات',
    'LBL_KIOSK_ADD_DROP_FILES' => 'إضافة ملفات أو إسقاطها هنا',
    'LBL_KIOSK_CANCEL' => 'إلغاء',
    'LBL_KIOSK_EDIT' => 'تحرير',
    'LBL_KIOSK_EMAIL' => 'البريد الإلكتروني',
    'LBL_KIOSK_FILES_UPLOADING' => 'يتم التحميل',
    'LBL_KIOSK_FILES_ERROR' => 'فشل تحميل المرفق',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => 'المرفق كبير للغاية',
    'LBL_KIOSK_FILTER_SEARCH' => 'بحث',
    'LBL_KIOSK_ID' => 'المعرف',
    'LBL_KIOSK_TITLE' => 'Kiosk',
    'LBL_KIOSK_LANGUAGE' => 'اللغة',
    'LBL_KIOSK_LAST_UPDATED' => 'آخر تحديث',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => 'عرض',
    'LBL_KIOSK_MENU' => 'القائمة',
    'LBL_KIOSK_MOBILE_PHONE' => 'الهاتف المحمول',
    'LBL_KIOSK_MY_ACTIVITIES' => 'أنشطتي',
    'LBL_KIOSK_MY_PROFILE' => 'ملف تعريفي',
    'LBL_KIOSK_NAME' => 'الاسم',
    'LBL_KIOSK_OFFICE_PHONE' => 'هاتف المكتب',
    'LBL_KIOSK_ORGANIZATION' => 'المؤسسة',
    'LBL_KIOSK_PAGINATION_FOOTER' => 'الصفوف لكل صفحة:',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => 'بدعم من SugarCRM',
    'LBL_KIOSK_SAVE_CHANGES' => 'حفظ التغييرات',
    'LBL_KIOSK_SHOW_HIDE' => 'إظهار/إخفاء',
    'LBL_KIOSK_SIGN_IN' => 'تسجيل الدخول',
    'LBL_KIOSK_SIGN_OUT' => 'تسجيل الخروج',
    'LBL_KIOSK_SORT_BY' => 'فرز حسب',
    'LBL_KIOSK_SUBMIT' => 'إرسال',
    'LBL_KIOSK_TIMEZONE' => 'المنطقة الزمنية',
    'LBL_KIOSK_ACTIVITY' => 'النشاط',
    'LBL_KIOSK_NO_ACTIVITY' => 'لا نشاط لعرضه',
    'LBL_KIOSK_OLDEST_FIRST' => 'الأقدم أولا',
    'LBL_KIOSK_NEWEST_FIRST' => 'الأحدث أولا',
    'LBL_KIOSK_SHOW_MORE' => 'عرض المزيد',
    'LBL_KIOSK_ADD_A_REPLY' => 'إضافة رد',
    'LBL_KIOSK_REPLY_EMPTY' => 'لا يمكن ترك الرد فارغًا.',
    'LBL_KIOSK_NUM_MORE' => '{{num}} أخرى',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => 'مرحبًا',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => 'وصول سريع لموارك.',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => 'البحث عن حالات',
    'LBL_KIOSK_SHOW_ALL' => 'إظهار الكل',
    'LBL_KIOSK_404_TITLE' => 'لم نتمكن من العثور على هذا',
    'LBL_KIOSK_TENANT_404_TITLE' => 'لم يتم العثور على المستأجر',
    'LBL_KIOSK_404_MESSAGE' => 'لقد نقرت على ارتباط تمت إزالته أو غير متوفر مؤقتا أو أدخلت عنوان URL غير صالح.',
    'LBL_KIOSK_TENANT_404_MESSAGE' => 'يرجى التأكد من أن لديك عنوان URL الصحيح. لمزيد من المساعدة، يرجى الاتصال بالدعم.',
    'LBL_KIOSK_BACK_TO_HOME' => 'رجوع إلى الصفحة الرئيسية',
    'LBL_KIOSK_ERROR_CODE' => 'خطأ {code}: ',
    'LBL_KIOSK_401_TITLE' => 'غير مصرح',
    'LBL_KIOSK_401_MESSAGE' => 'غير مصرح لك بعرض هذه الصفحة.',
    'LBL_KIOSK_403_TITLE' => 'غير مصرح',
    'LBL_KIOSK_403_MESSAGE' => 'ليس لديك إذن لعرض هذه الصفحة.',
    'LBL_KIOSK_500_TITLE' => 'الخادم لا يستجيب',
    'LBL_KIOSK_500_MESSAGE' => 'حدث خطأ ما من جانبنا.',
    'LBL_KIOSK_GO_BACK' => 'الرجوع',
    'LBL_KIOSK_DUPLICATE_ERROR' => 'تم العثور على سجل مكرر',
    'LBL_KIOSK_ACCOUNT' => 'الحساب',
    'LBL_KIOSK_STATUS' => 'الحالة',
    'LBL_KIOSK_DEACTIVATE' => 'الغاء تنشيط',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => 'تم إلغاء تنشيط المستخدم',
    'LBL_KIOSK_MANAGE_USERS' => 'إدارة المستخدمين',
    'LBL_KIOSK_LAST_LOGIN' => 'آخر تسجيل دخول',
    'LBL_KIOSK_FIRST_NAME' => 'الاسم الأول',
    'LBL_KIOSK_LAST_NAME' => 'الاسم الأخير',
    'LBL_KIOSK_ROLE' => 'الدور',
    'LBL_KIOSK_INVITE' => 'دعوة',
    'LBL_KIOSK_SEND_INVITES' => 'إرسال دعوة (دعوات)',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => 'تم إرسال الدعوة (الدعوات) بنجاح',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => 'لم يتم إرسال الدعوة (الدعوات)',
    'LBL_KIOSK_REACTIVATE' => 'إعاده تنشيط',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => 'تمت إعادة تنشيط المستخدم',
    'LBL_KIOSK_RESET_PASSWORD' => 'إعادة تعيين كلمة المرور',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => 'تم إرسال رسالة إعادة تعيين كلمة المرور',
    'LBL_KIOSK_USER_PROFILE' => 'ملف تعريف المستخدم',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => 'تم إلغاء تنشيط المستخدم الخاص بك. الرجاء الاتصال بالمسؤول.',
    'LBL_KIOSK_BACK_TO_LOGIN' => 'العودة إلى تسجيل الدخول',
    'LBL_KIOSK_REVOKE_INVITATION' => 'إلغاء الدعوة',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => 'تم إلغاء الدعوة بنجاح',
    'LBL_KIOSK_SEARCH_AND_SELECT' => 'بحث وتحديد...',
    'LBL_KIOSK_NO_MATCHES' => 'لم يتم العثور على مطابقات',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => 'تم تحديث ملف التعريف.',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => 'خطأ أثناء تحديث ملف التعريف.',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => 'رد: {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => 'المستندات',
    'LBL_KIOSK_DOCUMENTS_DESC' => 'اعرض المستندات المُشاركة الواردة وابحث عنها وقم بتنزيلها.',
    'LBL_KIOSK_CASES' => 'الحالات',
    'LBL_KIOSK_CASES_DESC' => 'اعرض الحالات المُشاركة معك وابحث عنها وقم بالرد عليها.',
    'LBL_KIOSK_DOWNLOAD' => 'تنزيل',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => 'تم تنزيل الملف بنجاح',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => 'البدء',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => 'لمساعدتك بشكل أفضل، يرجى تزويدنا باسميك الأول والأخير.',
    'LBL_KIOSK_SAVE' => 'حفظ',
    'LBL_KIOSK_SHARED' => 'مُشارك',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => 'مرحبًا، {firstName} {lastInitial}.',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => 'لون الخلفية',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => 'عنوان URL لصورة الخلفية',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => 'يوصى باختيار صورة بحجم ملف أقل من 400 كيلوبايت.',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => 'نوع الخلفية',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => 'خلفة الصفحة الرئيسية',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => 'السمة',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => 'لون السمة الأساسية',
    'LBL_KIOSK_CONFIG_APP_NAME' => 'اسم التطبيق',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => 'هذا هو عنوان التطبيق ويظهر بجانب شعارك.',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => 'عنوان URL لشعار التطبيق',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => 'يوصى باختيار شعار يمكن عرضه بأحجام صغيرة (مثل ملفات تعريف وسائل التواصل الاجتماعي). ويوصى أيضًا أن يكون حجم الملف أقل من 200 كيلوبايت.',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => 'عنوان URL لرمز المفضلة الخاص بالتطبيق',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => 'رمز المفضلة هو شعار صغير يظهر بجانب عنوان الصفحة في علامة تبويب المستعرض.',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => 'إعادة التعيين التلقائي للأنشطة المفتوحة',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => 'تم الوصول إلى حد عدد المستخدمين',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => 'مفتاح ترخيص غير صالح',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => 'تطبيق غير صالح',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => 'تطبيق غير صالح',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => 'مفتاح تحقق تالف',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => 'الترخيص منتهي',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => 'معلومات مفقودة',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => 'مفتاح تحقق مفقود',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => 'يفتقد المستخدم الوصول',
    'LBL_DRI_WORKFLOW' => 'الدليل الذكي',
    'LBL_DRI_WORKFLOWS' => 'الأدلة الذكية',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => 'قالب مرحلة الدليل الذكي',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => 'قوالب مرحلة الدليل الذكي',
    'LBL_DRI_WORKFLOW_TEMPLATE' => 'قالب الدليل الذكي',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => 'قالب نشاط الدليل الذكي',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => 'قوالب الأنشطة',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => 'أدوات الإضافة على الويب',
    'LBL_CJ_WEBHOOKS' => 'أدوات الإضافة على الويب لـ Sugar Automate',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => 'نشاط الدليل الذكي الحالي في',
    'LBL_CJ_WEBHOOKS' => 'أدوات الإضافة على الويب لـ Sugar Automate',
    'LBL_CJ_WEBHOOK' => 'أداة الإضافة على الويب لـ Sugar Automate',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'إجراءات Sugar',
    'LBL_CJ_FORMS' => 'إجراءات Smart Guide Sugar',
    'LBL_CJ_FORM' => 'إجراء Smart Guide Sugar',
    'LBL_DRI_SUBWORKFLOW' => 'مرحلة الدليل الذكي',
    'LBL_DRI_SUBWORKFLOWS' => 'مراحل الدليل الذكي',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => 'قوالب أنشطة الدليل الذكي',
    'LBL_DRI_WORKFLOW_TEMPLATES' => 'قوالب الدليل الذكي',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => 'ترتيب الدليل الذكي',
    'LBL_CJ_ACTUAL_SORT_ORDER' => 'الترتيب الفعلي للدليل الذكي',
    'LBL_CUSTOMER_JOURNEY_SCORE' => 'نتيجة الدليل الذكي',
    'LBL_CJ_MOMENTUM_POINTS' => 'نقاط زخم الدليل الذكي',
    'LBL_CJ_MOMENTUM_SCORE' => 'نتيجة زخم الدليل الذكي',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => 'السماح بالنشاط للدليل الذكي حسب',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => 'تقدم الدليل الذكي',
    'LBL_CJ_MOMENTUM_RATIO' => 'نسبة زخم الدليل الذكي',
    'LBL_CUSTOMER_JOURNEY_POINTS' => 'نقاط الدليل الذكي',
    'LBL_CUSTOMER_JOURNEY_TYPE' => 'مهمة الدليل الذكي',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => 'نوع النشاط الأصل للدليل الذكي',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => 'الدليل الذكي محظور بواسطة',
    'LBL_CJ_BLOCKED_BY_STAGES' => 'الدليل الذكي محظور حسب المراحل',
    'LBL_CJ_PARENT_ACTIVITY_ID' => 'معرف النشاط الأصل للدليل الذكي',
    'LBL_START_NEXT_JOURNEY_ID' => 'معرف الدليل الذكي للبدء التالي',
    'LBL_CJ_URL' => 'عنوان URL الدليل الذكي',
    'LBL_IS_CJ_PARENT_ACTIVITY' => 'هو نشاط أصل للدليل الذكي',
    'LBL_CJ_MOMENTUM_START_DATE' => 'تاريخ بدء زخم الدليل الذكي',
    'LBL_CJ_MOMENTUM_END_DATE' => 'تاريخ انتهاء زخم الدليل الذكي',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => 'تكوين تخطيط عنصر واجهة المستخدم',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => 'تكوين تخطيط عنصر واجهة المستخدم',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => 'العدد الأقصى من الأدلة الذكية من نفس القالب',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => 'نشطة',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => 'مؤرشفة',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => 'إظهار',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => 'إخفاء',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => 'الوضع العمودي',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => 'الوضع الأفقي',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'ترخيص غير صالح',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} قام بتعيين أنشطة الدليل الذكي التالية إلى {{assigned_user}}.</p>
    <ul>{{activities}}</ul>
    
    <p>يمكنك مراجعة هذه الأنشطة في:<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => 'ترخيص غير صالح',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => 'تم الوصول إلى حد عدد المستخدمين، لديك {{gracePeriodDays}} أيام لترقية الترخيص.',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - أنشطة الدليل الذكي المعينة',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => 'تم تجاوز حد عدد مستخدمي Sugar Automate الخاص بك البالغ {0}<br>
    <br>
    يرجى التواصل مع <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> لرفع حد عدد المستخدمين أو تقليل عدد المستخدمين الذين يستخدمون المكون الإضافي.',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'تم الوصول إلى حد عدد مستخدمي Sugar Automate',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => 'ستنتهي صلاحية ترخيص Sugar Automate الخاص بك في غضون {0} أيام. <br>
    <br>
    يرجى الاتصال بـ SugarCRM أو شريك Sugar الخاص بك لتجديد الخدمة ومنع انقطاعها.',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'ترخيص Sugar Automate على وشك الانتهاء',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => 'اختبار أداة الإضافة على الويب',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'تقدم الدليل الذكي',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'يعرض المخطط الدائري "تقدم الدليل الذكي" لـ Sugar Automate.',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => 'يعرض استجابة أداة الإضافة على الويب',
    'LBL_DASHLET_SEND_LABEL' => 'إرسال طلب',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => 'التعيين إليّ',
    'LBL_COMPLETE_BUTTON_TITLE' => 'إكمال',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => 'إكمال جميع المهام',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => 'حذف المرحلة',
    'LBL_START_CYCLE_BUTTON_TITLE' => 'البدء',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => 'لا ينطبق',
    'LBL_ADD_STAGE_BUTTON_TITLE' => 'إضافة مرحلة',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => 'عرض',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => 'تحرير Smart Guide',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => 'إلغاء',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => 'أرشفة',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => 'إلغاء الأرشفة',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => 'تكوين القالب',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => 'إضافة مهمة',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => 'جدولة اجتماع',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => 'جدولة مكالمة',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => 'في المستقبل',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => 'متأخر',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => 'اليوم',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => 'غدًا',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => 'هل تريد بالتأكيد إلغاء هذا الدليل الذكي؟',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => 'أنت على وشك إكمال جميع المهام. هل تريد بالتأكيد التقدم؟',
    'LBL_CJ_BLOCK_BY' => 'لديك مهمة تابعة لم يتم حلها: {{Name}}. الرجاء إكمال هذه المهمة قبل إكمال جميع المهام.',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => 'لديك مهام تابعة لم يتم حلها متعددة. الرجاء إكمال هذه المهام قبل إكمال جميع المهام.',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => 'لقد أكملت جيع المهام بنجاح',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => 'هل تريد بالتأكيد أرشفة هذا الدليل الذكي؟',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => 'هل تريد بالتأكيد إلغاء أرشفة هذا الدليل الذكي؟',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate: الأدلة الذكية (أدراج التنظيم ووحدة التحكم)',
    'LBL_CJ_AS_A_DASHLET_DESC' => 'اعرض الأدلة الذكية النشطة على وحدة تحكم الخدمة/التجديدات ولوحات معلومات درج التنظيم.',
    'LBL_CJ_PROCESSING_REQUEST' => 'تتم المعالجة..',
    'LBL_CJ_SUCCESS' => 'لقد أكملت جيع المهام بنجاح',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => 'لم يتم تمكين وحدة {module}',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => 'تم حفظ جميع إعدادات العرض.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => 'زخم الدليل الذكي',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => 'يعرض مخطط القياس "زخم الدليل الذكي" لـ Sugar Automate.',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'تقدم Smart Guide',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => 'يعرض المخطط الدائري لـ "تقدم الدليل الذكي" الخاص بـ Sugar Automate.',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => 'تعذر العثور على الأصل',
    'CJ_NOT_FOUND_EXCEPTION' => 'تعذر العثور على {moduleName} باستخدام {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => 'يجب إكمال الدليل الذكي أو إلغاؤه قبل الأرشفة',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'لم يتم تمكين Sugar Automate في ترخيص Sugar الحالي',
    'LBL_ACTION_NOT_FOUND' => 'لم يتم العثور على الإجراء، اتصل بمسؤول النظام',
    'LBL_CJ_SELECT_FIELD' => 'تحديد الحقل',
    'LBL_CJ_SELECT_OPERATOR' => 'تحديد المشغل',
    'LBL_CJ_SELECT_VALUE' => 'تحديد القيمة',
    'LBL_CJ_ENTER_VALUE' => 'أدخل القيمة',
    'LBL_CJ_FORM_BATCH_TITLE' => 'حفظ السجل',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => 'تم اكتشاف smart guides نشطة...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => 'جارٍ معالجة إجراءات sugar النشطة...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => 'جارٍ تحديث smart guides النشطة...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => 'تم تحديث السجل وأدلة smart guides المرتبطة به بنجاح.',
    'LBL_CJ_FORM_BATCH_FAILURE' => 'فشل تحديث smart guide مرتبط. إذا استمر الخطأ، يرجى التواصل مع مسؤول Sugar للحصول على المساعدة.',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => 'فشل تحديث smart guide مرتبط. يرجى مراجعة <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">السجلات</a> لاستكشاف الخطأ وإصلاحه.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => 'تم ربط <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} بنجاح.',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => 'ظهرت مشكلة في ربط <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}}. إذا استمرت المشكلة، يرجى الاتصال بدعم Sugar.',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => 'تم ربط {{modulePluralLower}} بنجاح.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => 'ظهرت مشكلة في ربط {{modulePluralLower}}. إذا استمرت المشكلة، يرجى الاتصال بدعم Sugar.',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => 'ظهرت مشكلة في ربط {{moduleSingularLower}}. إذا استمرت المشكلة، يرجى الاتصال بدعم Sugar.',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => 'يوجد بالفعل {{moduleSingularLower}} يحمل الاسم <a href="#{{module}}/{{id}}">{{name}}</a> في المرحلة {{stage}}.',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => 'تم تحديد {{moduleSingularLower}} يحمل الاسم <a href="#{{module}}/{{id}}">{{name}}</a> بالفعل.',
    'LBL_CJ_ARCHIVED' => 'مؤرشفة',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => 'تحديد قالب Smart Guide...',
    'LBL_ALL_SMART_GUIDES' => 'جميع Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => 'أدلة Smart Guides النشطة',
    'LBL_ARCHIVED_SMART_GUIDES' => 'أدلة Smart Guides المؤرشفة',
    'LBL_VERTICAL_SCROLL_VIEW' => 'عرض مكدس رأسي',
    'LBL_HORIZONTAL_SCROLL_VIEW' => 'عرض تمرير أفقي',
    'LBL_DRI_WORKFLOWS_FILTER' => 'عامل التصفية',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => 'لا يمكن إكمال هذا الإجراء. تم تعيين حقل الحالة لوحدة هذه الأنشطة على "للقراءة فقط"، مما يمنع أي إجراءات Smart Guide تعمل على تحديث حقل الحالة.',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => 'لا يمكن إكمال هذا الإجراء. تم تعيين حقل الحالة لوحدات هذه الأنشطة و/أو الأنشطة الفرعية إلى "للقراءة فقط"، مما يمنع أي إجراءات Smart Guide تعمل على تحديث حقل الحالة.',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => 'تم ضبط حقل الحالة لبعض وحدات الأنشطة النمطية في الدليل إلى "للقراءة فقط"، وستظل هذه الأنشطة دون تغيير عند إلغاء الدليل.',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => 'تم النسخ إلى الحافظة.',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => 'حذف جميع التكرارات',
    'ERROR_RECURRENCE_EVENT_PARAMS' => 'إعدادات تكرار غير صالحة',
    'ERROR_INTERVAL_INVALID' => 'يجب أن يكون فاصل التكرار بين 1 و99',
    'LBL_RECURRENCE_ADD' => 'تكوين',
    'LBL_REPEAT_DAYS' => 'يوم (أيام) الشهر',
    'LBL_REPEAT_END_TYPES' => 'تكرار',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => 'موفر التنقل',
    'LBL_MOBILE_PDF_EMAIL' => 'إرسال قالب PDF {{{pdfTemplateName}}} بالبريد الإلكتروني',
    'LBL_MOBILE_EMAIL_SENDING' => 'يتم الإرسال',
    'LBL_MOBILE_EMAIL_SENT' => 'تم الإرسال',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => 'تم حفظ البريد الإلكتروني كمسودة.',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => 'إضافة مرفق',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => 'تحميل من المحلي',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'مستند Sugar',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => 'أدت عملية تحرير قمت بها على هذا السجل إلى تغيير طريقة العرض.',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'ملاحظات إصدار تطبيق SugarCRM Mobile',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'دليل مستخدم SugarCRM Mobile',
    'ERR_MOBILE_ROOTED' => 'لا يمكن استخدام Sugar Mobile على جهاز جوال تم الوصول إلى جذره. الرجاء فتح التطبيق على جهاز لم يتم الوصول إلى جذره.',
    'LBL_VO_BUILD_ROUTE' => 'إنشاء مسار',
    'LBL_FILTER_MY_DISTANCE_FILTER' => 'عامل تصفيتي للمسافة',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => 'سيتم تكوين المستند في الخلفية. افتح صفحة عملية دمج المستند للوصول إلى الملف.',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => 'فشل الحصول على القالب. اتصل بالمسؤول لطلب المساعدة.',
    'LBL_MAP_ERROR_LOAD' => 'لا يمكن تحميل الخريطة',
    'LBL_MAP_DISTANCE' => 'المسافة',
    'LBL_SELECT_UNIT_TYPE' => 'نوع الوحدة',
    'LBL_MAPS_UNIT_MILES' => 'أميال',
    'LBL_MAPS_UNIT_KILOMETERS' => 'كيلومترات',
    'LBL_RADIUS' => 'نصف القطر',
    'LBL_ZIP_CODE' => 'الرمز البريدي',
    'LBL_MOBILE_CHOOSE_ADDRESS' => 'اختيار العنوان',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => 'لا يمكن إنشاء الرمز الجغرافي من العنوان: {{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => 'لم يتم الترميز الجغرافي للسجل.',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => 'لا يحتوي السجل على أي بيانات عنوان. هل تريد تحديد موقع هذا السجل على الخريطة يدويًا؟',
    'LBL_ERR_SHOW_ON_MAP' => 'فشل فتح الخريطة للسجلات المحددة.',
    'LBL_ERR_MISSING_ON_MAP' => 'بعض السجلات تفتقد إلى بيانات عنوان وغير معروضة',
    'LBL_MAPS_ROUTE' => 'المسار',
    'LBL_MAPS_PROVIDER' => 'خرائط Sugar',
    'LBL_MAPS_CURRENT_LOC_ERROR' => 'تعذر تحديد الموقع الحالي.',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => 'يتم دعم {{{num}}} سجلات بحد أقصى للتخطيط.',
    'LBL_ALL_MODULES' => 'جميع الوحدات',
    'LBL_DRIVE_SHARE_LINK' => 'مشاركة ارتباط',
    'LBL_DRIVE_LOAD_FILES_ERROR' => 'فشل تحميل الملفات.',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => 'لا يمكن أن يكون الاسم فارغًا',
    'LBL_DRIVE_FOLDER_CREATED' => 'تم إنشاء المجلد.',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => 'فشل إنشاء مجلد.',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => 'فشل تحميل ملف.',
    'LBL_DRIVE_NO_ROOT_FOLDER' => 'الرجاء إنشاء مجلد جذر أولاً',
    'LBL_EDIT_ALL_RECURRENCES' => 'تعديل جميع التكرارات',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => 'لا يمكن فتح الملف في Dropbox',
    'LBL_FILE_NOT_AVAILABLE' => 'لا يمكن فتح الملف',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => 'الاتجاهات',
    'LBL_MAPS_ROUTE_NOT_FOUND' => 'لم يتم العثور على مسار لنقاط الطريق المحددة',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => 'القريبه',
    'LBL_TAGS' => 'العلامات',

    'LBL_CALLER_ID_SETTINGS' => 'إعدادات التعرف على هوية المتصل',
    'LBL_CALLER_ID_ENABLED' => 'تم تمكين التعرف على هوية المتصل',
    'LBL_CALLER_ID_ENABLED_TEXT' => 'في المكالمات الواردة، يتم عرض اسم جهة الاتصال أو العميل المتوقع الذي يطابق رقم الهاتف.',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => 'للسماح لتطبيق الجوال بالتعرف على هوية المتصلين، اتبع هذه الخطوات على جهازك:<br><br>1. افتح إعدادات iOS > الهاتف > حظر المكالمات وتحديد الهوية.<br>2. تمكين "{{{brandName}}}".',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => 'للسماح لتطبيق الأجهزة المحمولة بعرض هويات المتصلين، اتبع هذه الخطوات على جهازك:<br>1. افتح إعدادات التطبيق.<br>2. انتقل إلى الأذونات.<br>3. قم بتمكين إذن الهاتف.<br><br> لتعيين هذا التطبيق كمعالج التعرف على هوية المتصل الافتراضي، انتقل إلى إعدادات جهازك.<br>1. انتقل إلى التطبيقات.<br>2. اختر التطبيقات الافتراضية.<br>3. اختر معرف المتصل وتطبيق البريد العشوائي.<br>4. حدد هذا التطبيق كخيار افتراضي.',
    'LBL_CALLER_ID_SYNC_HINT' => 'تحقق من التغييرات التي تطرأ على معلومات الاتصال من السجلات (على سبيل المثال، جهات الاتصال والعملاء المحتملون) في مثيل Sugar الخاص بك.',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => 'انتقل إلى الإعدادات',
    'LBL_CALLER_ID_SYNC' => 'مزامنة بيانات السجل',
    'LBL_CALLER_ID_NOT_ENABLED' => 'يجب تمكين التعرف على هوية المتصل في إعدادات النظام قبل المزامنة.',
    'LBL_CALLER_ID_SETUP_ENABLE' => 'تمكين',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => 'لاحقًا في الإعدادات',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => 'يدعم هذا التطبيق ميزة التعرف على هوية المتصل.<br> من أجل عمل هذه الميزة بالشكل المناسب، بعد الضغط على زر التمكين، سيطلب منك منح إذنين.<br> لضمان عمل ميزة التعرف على هوية المتصل بشكل صحيح، تحتاج إلى منح إذن لإدارة المكالمات وتحديد هذا التطبيق كمعالج التعرف على هوية المتصل الافتراضي.<br> إذا لم تمنح الإذن لإدارة المكالمات، فلن تتمكن أيضا من تسجيل المكالمات التي تم إجراؤها من التطبيق.',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => 'للسماح لتطبيق SugarCRM للجوال بالتعرف على هوية المتصلين، اتبع هذه الخطوات على جهازك:<br><br>1. افتح إعدادات iOS > الهاتف > حظر المكالمات وتحديد الهوية.<br>2. تمكين التطبيق.',
    'LBL_MOBILE_LAST_SYNC' => 'آخر مزامنة',
    'LBL_CALLER_ID_SYNCING' => 'المزامنة مع الخادم.',
    'LBL_NEVER' => 'مطلقًا',
    'LBL_RLI_MISSING_ERROR' => 'لا يمكن لـ {{{moduleName}}} أن يكون فارغًا.',
    'LBL_ADD_RELATED_RECORD' => '{{{moduleSingular}}} المرتبطة',
    'LBL_CALLER_ID_NO_PERMISSION' => 'ليس لديك الأذونات المطلوبة لاستخدام معرف المتصل. الرجاء الاتصال بالمسؤول.',
    'LBL_CALLER_ID_FETCHING' => 'جارٍ المزامنة…',
    'LBL_CALLER_ID_FETCH_ALL' => 'إعادة مزامنة جميع السجلات',
    'LBL_CALLER_ID_FETCH_NEW' => 'التحقق من وجود تحديثات للسجل',

    'LBL_SORT_BY' => 'فرز حسب',
    'LBL_PRIMARY_SORT' => 'الفرز الرئيسي',
    'LBL_SECONDARY_SORT' => 'الفرز الثانوي',
    'LBL_OF' => 'من',
    'LBL_TABLE_FREEZE_FIRST' => 'تجميد العمود الأول',
    'LBL_TABLE_SETTINGS_TITLE' => 'خيارات عرض العمود',
    'LBL_TABLE_SETTINGS_NO_COL' => 'يجب تحديد عمود واحد على الأقل.',
    'LBL_TABLE_TOGGLER_INFO' => 'قم بإظهار الأعمدة أو إخفاءها واسحبها إلى الترتيب المفضل لك.',
    'LBL_RUNTIME_FILTERS_TITLE' => 'عوامل تصفية وقت التشغيل',
    'LBL_FILTER_CONDITION' => 'تحديد الشرط',
    'LBL_FILTER_VALUES' => 'القيم',
    'LBL_TABLE_EXPAND' => 'توسيع الكل',
    'LBL_TABLE_COLLAPSE' => 'طي الكل',
    'LBL_RUNTIME_FILTERS_DEFAULT' => 'خطأ في الخادم. تعذر تحميل عوامل تصفية وقت التشغيل ذات الصلة.',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => 'اشتراكات دفع أحداث وحدة Pub/Sub',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => 'اشتراك دفع أحداث وحدة Pub/Sub',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => 'لوحة - أعلى',
    'panel_bottom' => 'لوحة - أسفل',
    'tab_first' => 'علامة تبويب - الأولى',
    'tab_last' => 'علامة تبويب - الأخيرة',
];

$app_list_strings['activity_user_options'] = [
    '7' => 'آخر 7 أيام',
    '30' => 'آخر 30 يومًا',
    '90' => 'ربع السنة الماضي',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => 'اليوم',
    'future' => 'المستقبل',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => 'نعم',
    'group' => 'لا',
];

$app_list_strings['history_filter_options'] = [
    7 => 'آخر 7 أيام',
    30 => 'آخر 30 يومًا',
    90 => 'ربع السنة الماضي',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => 'نعم',
    'group' => 'لا',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => 'نعم',
    'group' => 'لا',
];

$app_list_strings['list_visibility_options'] = [
    '1' => 'نعم',
    '0' => 'لا',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => 'ربع السنة الحالي',
    'next' => 'ربع السنة القادم',
    'year' => 'هذه السنة',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => 'السجلات الخاصة بي',
    'group' => 'السجلات المجمعة',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => 'تدفقاتي',
    'group' => 'تدفقات فريقي',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => 'توقعاتي',
    'group' => 'توقعات فريقي',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => 'الفرص',
    'RevenueLineItems' => 'الفرص وبنود العائدات',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => 'تاريخ الإغلاق الأخير',
    'earliest' => 'تاريخ الإغلاق الأقرب',
];

$app_list_strings['moduleList']['Library'] = 'المكتبة';
$app_list_strings['moduleListSingular']['Library'] = 'المكتبة';
$app_list_strings['library_type'] = ['Books' => 'الكتاب', 'Music' => 'الموسيقى', 'DVD' => 'DVD', 'Magazines' => 'المجلات'];
$app_list_strings['moduleList']['EmailAddresses'] = 'عنوان البريد الإلكتروني';
$app_list_strings['moduleListSingular']['EmailAddresses'] = 'عنوان البريد الإلكتروني';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => 'المسودة',
    'in-review' => 'قيد المراجعة',
    'approved' => 'معتمد',
    'published' => 'تم النشر',
    'expired' => 'منتهي الصلاحية',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--إجراءات المسؤول--',
        'Create New Tag' => 'إنشاء علامة جديدة',
        'Delete Tag' => 'حذف علامة',
        'Rename Tag' => 'إعادة تسمية علامة',
        'Move Selected Articles' => 'نقل مقالات محددة',
        'Apply Tags On Articles' => 'تطبيق علامات على مقالات',
        'Delete Selected Articles' => 'حذف مقالات محددة',
    ];

$app_list_strings['moduleList']['Words'] = 'الكلمات';
$app_list_strings['moduleListSingular']['Words'] = 'الكلمة';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = 'إنشاء مقالة';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'أبو ظبي',
    'ADEN' => 'عدن',
    'AFGHANISTAN' => 'أفغانستان',
    'ALBANIA' => 'ألبانيا',
    'ALGERIA' => 'الجزائر',
    'AMERICAN SAMOA' => 'ساموا الأمريكية',
    'ANDORRA' => 'أندورا',
    'ANGOLA' => 'أنجولا',
    'ANTARCTICA' => 'أنتاركتيكا',
    'ANTIGUA' => 'أنتيجوا',
    'ARGENTINA' => 'الأرجنتين',
    'ARMENIA' => 'أرمينيا',
    'ARUBA' => 'أروبا',
    'AUSTRALIA' => 'أستراليا',
    'AUSTRIA' => 'النمسا',
    'AZERBAIJAN' => 'أذربيجان',
    'BAHAMAS' => 'بهاماس',
    'BAHRAIN' => 'البحرين',
    'BANGLADESH' => 'بنجلاديش',
    'BARBADOS' => 'باربادوس',
    'BELARUS' => 'روسيا البيضاء',
    'BELGIUM' => 'بلجيكا',
    'BELIZE' => 'بيليز',
    'BENIN' => 'بنين',
    'BERMUDA' => 'برمودا',
    'BHUTAN' => 'بوتان',
    'BOLIVIA' => 'بوليفيا',
    'BOSNIA' => 'البوسنة',
    'BOTSWANA' => 'بوتسوانا',
    'BOUVET ISLAND' => 'جزيرة بوفيت',
    'BRAZIL' => 'البرازيل',
    'BRITISH ANTARCTICA TERRITORY' => 'إقليم أنتاركتيكا البريطانية',
    'BRITISH INDIAN OCEAN TERRITORY' => 'إقليم المحيط الهندي البريطاني',
    'BRITISH VIRGIN ISLANDS' => 'جزر فيرجن البريطانية',
    'BRITISH WEST INDIES' => 'غرب الأنديز البريطانية',
    'BRUNEI' => 'بروناي',
    'BULGARIA' => 'بلغاريا',
    'BURKINA FASO' => 'بوركينا فاسو',
    'BURUNDI' => 'بوروندي',
    'CAMBODIA' => 'كمبوديا',
    'CAMEROON' => 'الكاميرون',
    'CANADA' => 'كندا',
    'CANAL ZONE' => 'منطقة القناة',
    'CANARY ISLAND' => 'جزر الكناري',
    'CAPE VERDI ISLANDS' => 'جزر كاب فيردي',
    'CAYMAN ISLANDS' => 'جزر كايمان',
    'CEVLON' => 'سيفلون',
    'CHAD' => 'تشاد',
    'CHANNEL ISLAND UK' => 'جزر شانيل المملكة المتحدة',
    'CHILE' => 'شيلي',
    'CHINA' => 'الصين',
    'CHRISTMAS ISLAND' => 'جزيرة عيد الميلاد',
    'COCOS (KEELING) ISLAND' => 'جزيرة كوكوس (كيلنج)',
    'COLOMBIA' => 'كولومبيا',
    'COMORO ISLANDS' => 'جزر كومورو',
    'CONGO' => 'الكونغو',
    'CONGO KINSHASA' => 'كونجو كينشاسا',
    'COOK ISLANDS' => 'جزر كوك',
    'COSTA RICA' => 'كوستاريكا',
    'CROATIA' => 'كرواتيا',
    'CUBA' => 'كوبا',
    'CURACAO' => 'كوراكاو',
    'CYPRUS' => 'قبرص',
    'CZECH REPUBLIC' => 'جمهورية التشيك',
    'DAHOMEY' => 'داهومي',
    'DENMARK' => 'الدنمارك',
    'DJIBOUTI' => 'جيبوتي',
    'DOMINICA' => 'دومينيكا',
    'DOMINICAN REPUBLIC' => 'جمهورية الدومينيكان',
    'DUBAI' => 'دبي',
    'ECUADOR' => 'الإكوادور',
    'EGYPT' => 'مصر',
    'EL SALVADOR' => 'السلفادور',
    'EQUATORIAL GUINEA' => 'غينيا الاستوائية',
    'ESTONIA' => 'إستونيا',
    'ETHIOPIA' => 'إثيوبيا',
    'FAEROE ISLANDS' => 'جزر فارو',
    'FALKLAND ISLANDS' => 'جزر فوكلاند',
    'FIJI' => 'فيجي',
    'FINLAND' => 'فنلندا',
    'FRANCE' => 'فرنسا',
    'FRENCH GUIANA' => 'غويانا الفرنسية',
    'FRENCH POLYNESIA' => 'بولينيزيا الفرنسية',
    'GABON' => 'الجابون',
    'GAMBIA' => 'جامبيا',
    'GEORGIA' => 'جورجيا',
    'GERMANY' => 'ألمانيا',
    'GHANA' => 'غانا',
    'GIBRALTAR' => 'جبل طارق',
    'GREECE' => 'اليونان',
    'GREENLAND' => 'جرينلاند',
    'GUADELOUPE' => 'جواديلوب',
    'GUAM' => 'غوام',
    'GUATEMALA' => 'جواتيمالا',
    'GUINEA' => 'غينيا',
    'GUYANA' => 'غيانا',
    'HAITI' => 'هايتي',
    'HONDURAS' => 'هندوراس',
    'HONG KONG' => 'هونج كونج',
    'HUNGARY' => 'المجر',
    'ICELAND' => 'أيسلندا',
    'IFNI' => 'إيفني',
    'INDIA' => 'الهند',
    'INDONESIA' => 'إندونيسيا',
    'IRAN' => 'إيران',
    'IRAQ' => 'العراق',
    'IRELAND' => 'أيرلندا',
    'ISRAEL' => 'إسرائيل',
    'ITALY' => 'إيطاليا',
    'IVORY COAST' => 'ساحل العاج',
    'JAMAICA' => 'جامايكا',
    'JAPAN' => 'اليابان',
    'JORDAN' => 'الأردن',
    'KAZAKHSTAN' => 'كازاخستان',
    'KENYA' => 'كينيا',
    'KOREA' => 'كوريا',
    'KOREA, SOUTH' => 'كوريا الجنوبية',
    'KUWAIT' => 'الكويت',
    'KYRGYZSTAN' => 'قيرغيزستان',
    'LAOS' => 'لاوس',
    'LATVIA' => 'لاتفيا',
    'LEBANON' => 'لبنان',
    'LEEWARD ISLANDS' => 'جزر ليوارد',
    'LESOTHO' => 'ليسوتو',
    'LIBYA' => 'ليبيا',
    'LIECHTENSTEIN' => 'ليشتنشتاين',
    'LITHUANIA' => 'ليتوانيا',
    'LUXEMBOURG' => 'لوكسمبورج',
    'MACAO' => 'ماكاو',
    'MACEDONIA' => 'مقدونيا',
    'MADAGASCAR' => 'مدغشقر',
    'MALAWI' => 'مالاوي',
    'MALAYSIA' => 'ماليزيا',
    'MALDIVES' => 'المالديف',
    'MALI' => 'مالي',
    'MALTA' => 'مالطا',
    'MARTINIQUE' => 'المارتينيك',
    'MAURITANIA' => 'موريتانيا',
    'MAURITIUS' => 'موريشيوس',
    'MELANESIA' => 'ميلانيزيا',
    'MEXICO' => 'المكسيك',
    'MOLDOVIA' => 'مولدوفيا',
    'MONACO' => 'موناكو',
    'MONGOLIA' => 'منغوليا',
    'MOROCCO' => 'المغرب',
    'MOZAMBIQUE' => 'موزمبيق',
    'MYANAMAR' => 'ميانمار',
    'NAMIBIA' => 'ناميبيا',
    'NEPAL' => 'نيبال',
    'NETHERLANDS' => 'هولندا',
    'NETHERLANDS ANTILLES' => 'جزر الأنتيل الهولندية',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'منطقة جزر الأنتيل الهولندية المحايدة',
    'NEW CALADONIA' => 'نيوكاليدونيا',
    'NEW HEBRIDES' => 'نيوهيبريدس',
    'NEW ZEALAND' => 'نيوزيلندا',
    'NICARAGUA' => 'نيكاراجوا',
    'NIGER' => 'النيجر',
    'NIGERIA' => 'نيجيريا',
    'NORFOLK ISLAND' => 'جزيرة نوفولك',
    'NORWAY' => 'النرويج',
    'OMAN' => 'عُمان',
    'OTHER' => 'أخرى',
    'PACIFIC ISLAND' => 'جزيرة المحيط الهادي',
    'PAKISTAN' => 'باكستان',
    'PANAMA' => 'بنما',
    'PAPUA NEW GUINEA' => 'بابوا غينيا الجديدة',
    'PARAGUAY' => 'باراجواي',
    'PERU' => 'بيرو',
    'PHILIPPINES' => 'الفلبين',
    'POLAND' => 'بولندا',
    'PORTUGAL' => 'البرتغال',
    'PORTUGUESE TIMOR' => 'تيمور البرتغالية',
    'PUERTO RICO' => 'بورتوريكو',
    'QATAR' => 'قطر',
    'REPUBLIC OF BELARUS' => 'جمهورية روسيا البيضاء',
    'REPUBLIC OF SOUTH AFRICA' => 'جمهورية جنوب أفريقيا',
    'REUNION' => 'جزيرة ريونيون',
    'ROMANIA' => 'رومانيا',
    'RUSSIA' => 'روسيا',
    'RWANDA' => 'رواندا',
    'RYUKYU ISLANDS' => 'جزر ريوكيو',
    'SABAH' => 'صباح',
    'SAN MARINO' => 'سان مارينو',
    'SAUDI ARABIA' => 'المملكة العربية السعودية',
    'SENEGAL' => 'السنغال',
    'SERBIA' => 'صربيا',
    'SEYCHELLES' => 'سيشيل',
    'SIERRA LEONE' => 'سيراليون',
    'SINGAPORE' => 'سنغافورة',
    'SLOVAKIA' => 'سلوفاكيا',
    'SLOVENIA' => 'سلوفينيا',
    'SOMALILIAND' => 'أرض الصومال',
    'SOUTH AFRICA' => 'جنوب أفريقيا',
    'SOUTH YEMEN' => 'اليمن الجنوبي',
    'SPAIN' => 'إسبانيا',
    'SPANISH SAHARA' => 'الصحراء الإسبانية',
    'SRI LANKA' => 'سريلانكا',
    'ST. KITTS AND NEVIS' => 'ST. كيتس ونيفيس',
    'ST. LUCIA' => 'ST. لوتشيا',
    'SUDAN' => 'السودان',
    'SURINAM' => 'سورينام',
    'SW AFRICA' => 'جنوب غرب إفريقيا',
    'SWAZILAND' => 'سوازيلاند',
    'SWEDEN' => 'السويد',
    'SWITZERLAND' => 'سويسرا',
    'SYRIA' => 'سوريا',
    'TAIWAN' => 'تايوان',
    'TAJIKISTAN' => 'طاجيكستان',
    'TANZANIA' => 'تنزانيا',
    'THAILAND' => 'تايلاند',
    'TONGA' => 'تونجا',
    'TRINIDAD' => 'ترينداد',
    'TUNISIA' => 'تونس',
    'TURKEY' => 'تركيا',
    'UGANDA' => 'أوغندا',
    'UKRAINE' => 'أوكرانيا',
    'UNITED ARAB EMIRATES' => 'الإمارات العربية المتحدة',
    'UNITED KINGDOM' => 'المملكة المتحدة',
    'UPPER VOLTA' => 'فولتا العليا',
    'URUGUAY' => 'أوروجواي',
    'US PACIFIC ISLAND' => 'جزيرة المحيط الهادي الأمريكية',
    'US VIRGIN ISLANDS' => 'جزر فيرجن الأمريكية',
    'USA' => 'الولايات المتحدة الأمريكية',
    'UZBEKISTAN' => 'أوزبكستان',
    'VANUATU' => 'فانواتو',
    'VATICAN CITY' => 'مدينة الفاتيكان',
    'VENEZUELA' => 'فنزويلا',
    'VIETNAM' => 'فيتنام',
    'WAKE ISLAND' => 'جزيرة ويك',
    'WEST INDIES' => 'غرب الإنديز',
    'WESTERN SAHARA' => 'الصحراء الغربية',
    'YEMEN' => 'اليمن',
    'ZAIRE' => 'زائير',
    'ZAMBIA' => 'زامبيا',
    'ZIMBABWE' => 'زيمبابوي',
];

$app_list_strings['state_dom'] = [
    'AL' => 'ألاباما',
    'AK' => 'ألاسكا',
    'AZ' => 'أريزونا',
    'AR' => 'أركنسو',
    'CA' => 'كاليفورنيا',
    'CO' => 'كولورادو',
    'CT' => 'كونيتيكت',
    'DE' => 'ديلاوير',
    'DC' => 'مقاطعة كولومبيا',
    'FL' => 'فلوريدا',
    'GA' => 'جورجيا',
    'HI' => 'هاواي',
    'ID' => 'أيداهو',
    'IL' => 'إلينوي',
    'IN' => 'إنديانا',
    'IA' => 'آيوا',
    'KS' => 'كانساس',
    'KY' => 'كنتاكي',
    'LA' => 'لويزيانا',
    'ME' => 'مين',
    'MD' => 'ماريلاند',
    'MA' => 'ماساتشوستس',
    'MI' => 'ميشيغان',
    'MN' => 'مينيسوتا',
    'MS' => 'ميسيسيبي',
    'MO' => 'ميزوري',
    'MT' => 'مونتانا',
    'NE' => 'نبراسكا',
    'NV' => 'نيفادا',
    'NH' => 'نيو هامبشاير',
    'NJ' => 'نيو جيرسي',
    'NM' => 'نيو مكسيكو',
    'NY' => 'نيويورك',
    'NC' => 'نورث كارولاينا',
    'ND' => 'نورث داكوتا',
    'OH' => 'أوهايو',
    'OK' => 'أوكلاهوما',
    'OR' => 'أوريغون',
    'PA' => 'بنسلفانيا',
    'RI' => 'رود آيلاند',
    'SC' => 'ساوث كارولينا',
    'SD' => 'ساوث داكوتا',
    'TN' => 'تينيسي',
    'TX' => 'تكساس',
    'UT' => 'يوتا',
    'VT' => 'فيرمونت',
    'VA' => 'فيرجينيا ',
    'WA' => 'واشنطن',
    'WV' => 'ويست فيرجينيا',
    'WI' => 'ويسكونسن',
    'WY' => 'وايومنغ',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (تايوان وهونج كونج)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS Cyrillic)',
    'CP1252' => 'CP1252 (MS Western European & US)',
    'EUC-CN' => 'EUC-CN (Simplified Chinese GB2312)',
    'EUC-JP' => 'EUC-JP (Unix Japanese)',
    'EUC-KR' => 'EUC-KR (Korean)',
    'EUC-TW' => 'EUC-TW (Taiwanese)',
    'ISO-2022-JP' => 'ISO-2022-JP (Japanese)',
    'ISO-2022-KR' => 'ISO-2022-KR (Korean)',
    'ISO-8859-1' => 'ISO-8859-1 (Western European and US)',
    'ISO-8859-2' => 'ISO-8859-2 (Central and Eastern European)',
    'ISO-8859-3' => 'ISO-8859-3 (Latin 3)',
    'ISO-8859-4' => 'ISO-8859-4 (Latin 4)',
    'ISO-8859-5' => 'ISO-8859-5 (Cyrillic)',
    'ISO-8859-6' => 'ISO-8859-6 (Arabic)',
    'ISO-8859-7' => 'ISO-8859-7 (Greek)',
    'ISO-8859-8' => 'ISO-8859-8 (Hebrew)',
    'ISO-8859-9' => 'ISO-8859-9 (Latin 5)',
    'ISO-8859-10' => 'ISO-8859-10 (Latin 6)',
    'ISO-8859-13' => 'ISO-8859-13 (Latin 7)',
    'ISO-8859-14' => 'ISO-8859-14 (Latin 8)',
    'ISO-8859-15' => 'ISO-8859-15 (Latin 9)',
    'KOI8-R' => 'KOI8-R (Cyrillic Russian)',
    'KOI8-U' => 'KOI8-U (Cyrillic Ukranian)',
    'SJIS' => 'SJIS (MS Japanese)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => 'أفريقيا/الجزائر',
    'Africa/Luanda' => 'أفريقيا/لواندا',
    'Africa/Porto-Novo' => 'أفريقيا/بورتو نوفو',
    'Africa/Gaborone' => 'أفريقيا/جابروني',
    'Africa/Ouagadougou' => 'أفريقيا/واجادوجو',
    'Africa/Bujumbura' => 'أفريقيا/بوجمبورا',
    'Africa/Douala' => 'أفريقيا/دوالا',
    'Atlantic/Cape_Verde' => 'المحيط الأطلنطي/كيب فيردي',
    'Africa/Bangui' => 'أفريقيا/بانجوي',
    'Africa/Ndjamena' => 'أفريقيا/إنجامينا',
    'Indian/Comoro' => 'أفريقيا/القمر',
    'Africa/Kinshasa' => 'أفريقيا/كينشاسا',
    'Africa/Lubumbashi' => 'أفريقيا/لوبومباشي',
    'Africa/Brazzaville' => 'أفريقيا/برازافيل',
    'Africa/Abidjan' => 'أفريقيا/أبيدجان',
    'Africa/Djibouti' => 'أفريقيا/جيبوتي',
    'Africa/Cairo' => 'أفريقيا/القاهرة',
    'Africa/Malabo' => 'أفريقيا/مالابو',
    'Africa/Asmera' => 'أفريقيا/أسمرة',
    'Africa/Addis_Ababa' => 'أفريقيا/أديس أبابا',
    'Africa/Libreville' => 'أفريقيا/ليبرافيل',
    'Africa/Banjul' => 'أفريقيا/بانجول',
    'Africa/Accra' => 'أفريقيا/أكرا',
    'Africa/Conakry' => 'أفريقيا/كوناكري',
    'Africa/Bissau' => 'أفريقيا/بيساو',
    'Africa/Nairobi' => 'أفريقيا/نيروبي',
    'Africa/Maseru' => 'أفريقيا/ماسيرو',
    'Africa/Monrovia' => 'أفريقيا/مونروفيا',
    'Africa/Tripoli' => 'أفريقيا/طرابلس',
    'Indian/Antananarivo' => 'أفريقيا/تناناريفو',
    'Africa/Blantyre' => 'أفريقيا/بلانتير',
    'Africa/Bamako' => 'أفريقيا/باماكو',
    'Africa/Nouakchott' => 'أفريقيا/نواكشوط',
    'Indian/Mauritius' => 'أفريقيا/موريشيوس',
    'Indian/Mayotte' => 'أفريقيا/مايوت',
    'Africa/Casablanca' => 'أفريقيا/كازابلانكا',
    'Africa/El_Aaiun' => 'أفريقيا/العيون',
    'Africa/Maputo' => 'أفريقيا/مابوتو',
    'Africa/Windhoek' => 'أفريقيا/ويندهوك',
    'Africa/Niamey' => 'أفريقيا/نيامي',
    'Africa/Lagos' => 'أفريقيا/لاجوس',
    'Indian/Reunion' => 'أفريقيا/ريونيون',
    'Africa/Kigali' => 'أفريقيا/كيجالي',
    'Atlantic/St_Helena' => 'أفريقيا/سانت هيلينا',
    'Africa/Sao_Tome' => 'أفريقيا/ساوتومي',
    'Africa/Dakar' => 'أفريقيا/داكار',
    'Indian/Mahe' => 'المحيط الهندي/ماهي',
    'Africa/Freetown' => 'أفريقيا/فريتاون',
    'Africa/Mogadishu' => 'أفريقيا/مقديشيو',
    'Africa/Johannesburg' => 'أفريقيا/جوهانسبرج',
    'Africa/Khartoum' => 'أفريقيا/الخرطوم',
    'Africa/Mbabane' => 'أفريقيا/مبابان',
    'Africa/Dar_es_Salaam' => 'أفريقيا/دار السلام',
    'Africa/Lome' => 'أفريقيا/لومي',
    'Africa/Tunis' => 'أفريقيا/تونس',
    'Africa/Kampala' => 'أفريقيا/كامبالا',
    'Africa/Lusaka' => 'أفريقيا/لوساكا',
    'Africa/Harare' => 'أفريقيا/هراري',
    'Antarctica/Casey' => 'أنتاركتيكا/كاسي',
    'Antarctica/Davis' => 'أنتاركتيكا/دافيس',
    'Antarctica/Mawson' => 'أنتاركتيكا/ماوسون',
    'Indian/Kerguelen' => 'المحيط الهندي/كيرجولين',
    'Antarctica/DumontDUrville' => 'أنتاركتيكا/دومنت دورفيل',
    'Antarctica/Syowa' => 'أنتاركتيكا/سيوا',
    'Antarctica/Vostok' => 'أنتاركتيكا/فوستوك',
    'Antarctica/Rothera' => 'أنتاركتيكا/روثيرا',
    'Antarctica/Palmer' => 'أنتاركتيكا/بالمر',
    'Antarctica/McMurdo' => 'أنتاركتيكا/مكموردو',
    'Asia/Kabul' => 'آسيا/كابول',
    'Asia/Yerevan' => 'آسيا/يريفان',
    'Asia/Baku' => 'آسيا/باكو',
    'Asia/Bahrain' => 'آسيا/البحرين',
    'Asia/Dhaka' => 'آسيا/دكا',
    'Asia/Thimphu' => 'آسيا/ثيمفو',
    'Indian/Chagos' => 'آسيا/شاجوس',
    'Asia/Brunei' => 'آسيا/بروناي',
    'Asia/Rangoon' => 'آسيا/رانجون',
    'Asia/Phnom_Penh' => 'آسيا/بنوم بنه',
    'Asia/Beijing' => 'آسيا/بكين',
    'Asia/Harbin' => 'آسيا/هاربين',
    'Asia/Shanghai' => 'آسيا/شنغهاي',
    'Asia/Chongqing' => 'آسيا/شونج جونج',
    'Asia/Urumqi' => 'آسيا/أورومكي',
    'Asia/Kashgar' => 'آسيا/كاشجار',
    'Asia/Hong_Kong' => 'آسيا/هونج كونج',
    'Asia/Taipei' => 'آسيا/تايبي',
    'Asia/Macau' => 'آسيا/ماكاو',
    'Asia/Nicosia' => 'آسيا/نيقوسيا',
    'Asia/Tbilisi' => 'آسيا/تبليسي',
    'Asia/Dili' => 'آسيا/ديلهي',
    'Asia/Calcutta' => 'آسيا/كالكتا',
    'Asia/Jakarta' => 'آسيا/جاكرتا',
    'Asia/Pontianak' => 'آسيا/بونتيناك',
    'Asia/Makassar' => 'آسيا/ماكاسار',
    'Asia/Jayapura' => 'آسيا/جيبورا',
    'Asia/Tehran' => 'آسيا/طهران',
    'Asia/Baghdad' => 'آسيا/بغداد',
    'Asia/Jerusalem' => 'آسيا/القدس',
    'Asia/Tokyo' => 'آسيا/طوكيو',
    'Asia/Amman' => 'آسيا/عمان',
    'Asia/Almaty' => 'آسيا/المآتي',
    'Asia/Qyzylorda' => 'آسيا/قيزيلوردا',
    'Asia/Aqtobe' => 'آسيا/أكتوب',
    'Asia/Aqtau' => 'آسيا/أكتا',
    'Asia/Oral' => 'آسيا/أورال',
    'Asia/Bishkek' => 'آسيا/بيشكيك',
    'Asia/Seoul' => 'آسيا/سيول',
    'Asia/Pyongyang' => 'آسيا/بيونج يانج',
    'Asia/Kuwait' => 'آسيا/الكويت',
    'Asia/Vientiane' => 'آسيا/فينتيان',
    'Asia/Beirut' => 'آسيا/بيروت',
    'Asia/Kuala_Lumpur' => 'آسيا/كوالالمبور',
    'Asia/Kuching' => 'آسيا/كوشينج',
    'Indian/Maldives' => 'آسيا/المالديف',
    'Asia/Hovd' => 'آسيا/هوفد',
    'Asia/Ulaanbaatar' => 'آسيا/أولان باتار',
    'Asia/Choibalsan' => 'آسيا/شويبالسان',
    'Asia/Katmandu' => 'آسيا/كاتماندو',
    'Asia/Muscat' => 'آسيا/مسقط',
    'Asia/Karachi' => 'آسيا/كراتشي',
    'Asia/Gaza' => 'آسيا/غزة',
    'Asia/Manila' => 'آسيا/مانيلا',
    'Asia/Qatar' => 'آسيا/قطر',
    'Asia/Riyadh' => 'آسيا/الرياض',
    'Asia/Singapore' => 'آسيا/سنغافورة',
    'Asia/Colombo' => 'آسيا/كولومبو',
    'Asia/Damascus' => 'آسيا/دمشق',
    'Asia/Dushanbe' => 'آسيا/دوشانبي',
    'Asia/Bangkok' => 'آسيا/بانكوك',
    'Asia/Ashgabat' => 'آسيا/عشق أباد',
    'Asia/Dubai' => 'آسيا/دبي',
    'Asia/Samarkand' => 'آسيا/سمرقند',
    'Asia/Tashkent' => 'آسيا/طشقند',
    'Asia/Saigon' => 'آسيا/سايجون',
    'Asia/Aden' => 'آسيا/عدن',
    'Australia/Darwin' => 'أستراليا/داروين',
    'Australia/Perth' => 'أستراليا/بيرث',
    'Australia/Brisbane' => 'أستراليا/بريسبان',
    'Australia/Lindeman' => 'أستراليا/ليندمان',
    'Australia/Adelaide' => 'أستراليا/أديلايد',
    'Australia/Hobart' => 'أستراليا/هوبارت',
    'Australia/Currie' => 'أستراليا/كوري',
    'Australia/Melbourne' => 'أستراليا/مالبورن',
    'Australia/Sydney' => 'أستراليا/سيدني',
    'Australia/Broken_Hill' => 'أستراليا/بروكين هيل',
    'Indian/Christmas' => 'المحيط الهندي/كريسماس',
    'Pacific/Rarotonga' => 'المحيط الهادي/راروتونجا',
    'Indian/Cocos' => 'المحيط الهندي/كوكوس',
    'Pacific/Fiji' => 'المحيط الهادي/فيجي',
    'Pacific/Gambier' => 'المحيط الهادي/جامبير',
    'Pacific/Marquesas' => 'المحيط الهادي/ماركيساس',
    'Pacific/Tahiti' => 'المحيط الهادي/تاهيتي',
    'Pacific/Guam' => 'المحيط الهادي/غوام',
    'Pacific/Tarawa' => 'المحيط الهادي/تاراوا',
    'Pacific/Enderbury' => 'المحيط الهادي/إينديربوري',
    'Pacific/Kiritimati' => 'المحيط الهادي/كيريتماتي',
    'Pacific/Saipan' => 'المحيط الهادي/سايبان',
    'Pacific/Majuro' => 'المحيط الهادي/ماجورو',
    'Pacific/Kwajalein' => 'المحيط الهادي/واجالاين',
    'Pacific/Truk' => 'المحيط الهادي/تروك',
    'Pacific/Ponape' => 'المحيط الهادي/بونابي',
    'Pacific/Kosrae' => 'المحيط الهادي/كوسرا',
    'Pacific/Nauru' => 'المحيط الهادي/ناورو',
    'Pacific/Noumea' => 'المحيط الهادي/نوميا',
    'Pacific/Auckland' => 'المحيط الهادي/أوكلاند',
    'Pacific/Chatham' => 'المحيط الهادي/شاثام',
    'Pacific/Niue' => 'المحيط الهادي/نيو',
    'Pacific/Norfolk' => 'المحيط الهادي/نورفولك',
    'Pacific/Palau' => 'المحيط الهادي/بالاو',
    'Pacific/Port_Moresby' => 'المحيط الهادي/بورت موريسبي',
    'Pacific/Pitcairn' => 'المحيط الهادي/بيتكايرن',
    'Pacific/Pago_Pago' => 'المحيط الهادي/باجو باجو',
    'Pacific/Apia' => 'المحيط الهادي/أبيا',
    'Pacific/Guadalcanal' => 'المحيط الهادي/جوادالكانال',
    'Pacific/Fakaofo' => 'المحيط الهادي/فاكاوفو',
    'Pacific/Tongatapu' => 'المحيط الهادي/تونجاتابو',
    'Pacific/Funafuti' => 'المحيط الهادي/فونافوتي',
    'Pacific/Johnston' => 'المحيط الهادي/جونستون',
    'Pacific/Midway' => 'المحيط الهادي/ميدواي',
    'Pacific/Wake' => 'المحيط الهادي/واك',
    'Pacific/Efate' => 'المحيط الهادي/إيفات',
    'Pacific/Wallis' => 'المحيط الهادي/واليز',
    'Europe/London' => 'أوروبا/لندن',
    'Europe/Dublin' => 'أوروبا/دبلن',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => 'أوروبا/تيرانا',
    'Europe/Andorra' => 'أوروبا/أندورا',
    'Europe/Vienna' => 'أوروبا/فيينا',
    'Europe/Minsk' => 'أوروبا/مينسك',
    'Europe/Brussels' => 'أوروبا/بروكسل',
    'Europe/Sofia' => 'أوروبا/صوفيا',
    'Europe/Prague' => 'أوروبا/براغ',
    'Europe/Copenhagen' => 'أوروبا/كوبنهاجن',
    'Atlantic/Faeroe' => 'المحيط الأطلنطي/فارو',
    'America/Danmarkshavn' => 'أمريكا/دنماركشافان',
    'America/Scoresbysund' => 'أمريكا/سكورسبيسند',
    'America/Godthab' => 'أمريكا/جودثاب',
    'America/Thule' => 'أمريكا/ثولي',
    'Europe/Tallinn' => 'أوروبا/تالين',
    'Europe/Helsinki' => 'أوروبا/هيلسنكي',
    'Europe/Paris' => 'أوروبا/باريس',
    'Europe/Berlin' => 'أوروبا/برلين',
    'Europe/Gibraltar' => 'أوروبا/جبل طارق',
    'Europe/Athens' => 'أوروبا/أثينا',
    'Europe/Budapest' => 'أوروبا/بودابست',
    'Atlantic/Reykjavik' => 'أتلانتك/ريكيافيك',
    'Europe/Rome' => 'أوروبا/روما',
    'Europe/Riga' => 'أوروبا/ريجا',
    'Europe/Vaduz' => 'أوروبا/فادوز',
    'Europe/Vilnius' => 'أوروبا/فيلنيوس',
    'Europe/Luxembourg' => 'أوروبا/لوكسمبورج',
    'Europe/Malta' => 'أوروبا/مالطا',
    'Europe/Chisinau' => 'أوروبا/شيزيناو',
    'Europe/Monaco' => 'أوروبا/موناكو',
    'Europe/Amsterdam' => 'أوروبا/أمستردام',
    'Europe/Oslo' => 'أوروبا/أوسلو',
    'Europe/Warsaw' => 'أوروبا/وارسو',
    'Europe/Lisbon' => 'أوروبا/لشبونة',
    'Atlantic/Azores' => 'المحيط الأطلنطي/أزوريس',
    'Atlantic/Madeira' => 'أتلانتيك/ماديرا',
    'Europe/Bucharest' => 'أوروبا/بوخارست',
    'Europe/Kaliningrad' => 'أوروبا/كالينيجراد',
    'Europe/Moscow' => 'أوروبا/موسكو',
    'Europe/Samara' => 'أوروبا/سامارا',
    'Asia/Yekaterinburg' => 'آسيا/يكاتيرنبرج',
    'Asia/Omsk' => 'آسيا/أومسك',
    'Asia/Novosibirsk' => 'آسيا/نوفوسيبرسك',
    'Asia/Krasnoyarsk' => 'آسيا/كراسنويارسك',
    'Asia/Irkutsk' => 'آسيا/إيركوتسك',
    'Asia/Yakutsk' => 'آسيا/ياكوتسك',
    'Asia/Vladivostok' => 'آسيا/فلاديفوستوك',
    'Asia/Sakhalin' => 'آسيا/ساخالين',
    'Asia/Magadan' => 'آسيا/ماجادان',
    'Asia/Kamchatka' => 'آسيا/كامشتكا',
    'Asia/Anadyr' => 'آسيا/أنديار',
    'Europe/Belgrade' => 'أوروبا/بلجراد',
    'Europe/Madrid' => 'أوروبا/مدريد',
    'Africa/Ceuta' => 'أفريقيا/سيوتا',
    'Atlantic/Canary' => 'المحيط الأطلنطي/كاناري',
    'Europe/Stockholm' => 'أوروبا/ستوكهولم',
    'Europe/Zurich' => 'أوروبا/زيوريخ',
    'Europe/Istanbul' => 'أوروبا/إسطنبول',
    'Europe/Kiev' => 'أوروبا/كييف',
    'Europe/Uzhgorod' => 'أوروبا/زوجورود',
    'Europe/Zaporozhye' => 'أوروبا/زابوروزي',
    'Europe/Simferopol' => 'أوروبا/سيمفروبول',
    'America/New_York' => 'أمريكا/نيويورك',
    'America/Chicago' => 'أمريكا/شيكاغو',
    'America/North_Dakota/Center' => 'أمريكا/داكوتا الشمالية/الأوسط',
    'America/Denver' => 'أمريكا/دنفر',
    'America/Los_Angeles' => 'أمريكا/لوس أنجليس',
    'America/Juneau' => 'أمريكا/جينوا',
    'America/Yakutat' => 'أمريكا/ياكوتات',
    'America/Anchorage' => 'أمريكا/أنكوراج',
    'America/Nome' => 'أمريكا/نومي',
    'America/Adak' => 'أمريكا/أداك',
    'Pacific/Honolulu' => 'المحيط الهادي/هونولولو',
    'America/Phoenix' => 'أمريكا/فونيكس',
    'America/Boise' => 'أمريكا/بواسي',
    'America/Indiana/Indianapolis' => 'أمريكا/إنديانا/إنديانابوليس',
    'America/Indiana/Marengo' => 'أمريكا/إنديانا/مارينجو',
    'America/Indiana/Knox' => 'أمريكا/إنديانا/نوكس',
    'America/Indiana/Vevay' => 'أمريكا/إنديانا/نيفاي',
    'America/Kentucky/Louisville' => 'أمريكا/كنتاكي/لويسفيل',
    'America/Kentucky/Monticello' => 'أمريكا/كنتاكي/مونتيسيلو',
    'America/Detroit' => 'أمريكا/ديترويت',
    'America/Menominee' => 'أمريكا/مينوميني',
    'America/St_Johns' => 'أمريكا/سانت جون',
    'America/Goose_Bay' => 'أمريكا/جوسي باي',
    'America/Halifax' => 'أمريكا/هاليفاكس',
    'America/Glace_Bay' => 'أمريكا/جلاس باي',
    'America/Montreal' => 'أمريكا/مونتريال',
    'America/Toronto' => 'أمريكا/تورونتو',
    'America/Thunder_Bay' => 'أمريكا/ثاندر باي',
    'America/Nipigon' => 'أمريكا/نيبيجون',
    'America/Rainy_River' => 'أمريكا/راني ريفير',
    'America/Winnipeg' => 'أمريكا/وينيبيج',
    'America/Regina' => 'أمريكا/ريجينا',
    'America/Swift_Current' => 'أمريكا/سويفت كارينت',
    'America/Edmonton' => 'أمريكا/إدمونتون',
    'America/Vancouver' => 'أمريكا/فانكوفر',
    'America/Dawson_Creek' => 'أمريكا/داوسون كريك',
    'America/Pangnirtung' => 'أمريكا/بانجنيرتونج',
    'America/Iqaluit' => 'أمريكا/إيكاليت',
    'America/Coral_Harbour' => 'أمريكا/كورال هاربور',
    'America/Rankin_Inlet' => 'أمريكا/رانكن إنليت',
    'America/Cambridge_Bay' => 'أمريكا/كامبريدج باي',
    'America/Yellowknife' => 'أمريكا/يلونايف',
    'America/Inuvik' => 'أمريكا/إينوفيك',
    'America/Whitehorse' => 'أمريكا/وايتهورس',
    'America/Dawson' => 'أمريكا/داوسون',
    'America/Cancun' => 'أمريكا/كانكون',
    'America/Merida' => 'أمريكا/ميريدا',
    'America/Monterrey' => 'أمريكا/مونتيري',
    'America/Mexico_City' => 'أمريكا/مكسيكوسيتي',
    'America/Chihuahua' => 'أمريكا/شيهواهوا',
    'America/Hermosillo' => 'أمريكا/هيرموسيلو',
    'America/Mazatlan' => 'أمريكا/مازاتلان',
    'America/Tijuana' => 'أمريكا/تيجوانا',
    'America/Anguilla' => 'أمريكا/أنجيلا',
    'America/Antigua' => 'أمريكا/أنتيجوا',
    'America/Nassau' => 'أمريكا/ناساو',
    'America/Barbados' => 'أمريكا/باربادوس',
    'America/Belize' => 'أمريكا/بيليز',
    'Atlantic/Bermuda' => 'المحيط الأطلسي/برمودا',
    'America/Cayman' => 'أمريكا/كايمان',
    'America/Costa_Rica' => 'أمريكا/كوستاريكا',
    'America/Havana' => 'أمريكا/هافانا',
    'America/Dominica' => 'أمريكا/دومينيكا',
    'America/Santo_Domingo' => 'أمريكا/سانتو دومينجو',
    'America/El_Salvador' => 'أمريكا/السلفادور',
    'America/Grenada' => 'أمريكا/جرينادا',
    'America/Guadeloupe' => 'أمريكا/جواديلوب',
    'America/Guatemala' => 'أمريكا/جواتيمالا',
    'America/Port-au-Prince' => 'أمريكا/بورت أو برنس',
    'America/Tegucigalpa' => 'أمريكا/تيجوسيجالبا',
    'America/Jamaica' => 'أمريكا/جامايكا',
    'America/Martinique' => 'أمريكا/المارتينيك',
    'America/Montserrat' => 'أمريكا/مونتسيرات',
    'America/Managua' => 'أمريكا/ماناجوا',
    'America/Panama' => 'أمريكا/بنما',
    'America/Puerto_Rico' => 'أمريكا/بورتوريكو',
    'America/St_Kitts' => 'أمريكا/سانت كيتس',
    'America/St_Lucia' => 'أمريكا/سانت لوتشيا',
    'America/Miquelon' => 'أمريكا/ميكيلون',
    'America/St_Vincent' => 'أمريكا/سانت فينسنت',
    'America/Grand_Turk' => 'أمريكا/جراند تورك',
    'America/Tortola' => 'أمريكا/تورتولا',
    'America/St_Thomas' => 'أمريكا/سانت توماس',
    'America/Argentina/Buenos_Aires' => 'أمريكا/الأرجنتين/بوينس آيرس',
    'America/Argentina/Cordoba' => 'أمريكا/الأرجنتين/قرطبة',
    'America/Argentina/Tucuman' => 'أمريكا/الأرجنتين/توكومان',
    'America/Argentina/La_Rioja' => 'أمريكا/الأرجنتين/لاريوجا',
    'America/Argentina/San_Juan' => 'أمريكا/الأرجنتين/سان خوان',
    'America/Argentina/Jujuy' => 'أمريكا/الأرجنتين/جوجوي',
    'America/Argentina/Catamarca' => 'أمريكا/الأرجنتين/كاتاماركا',
    'America/Argentina/Mendoza' => 'أمريكا/الأرجنتين/ميندوزا',
    'America/Argentina/Rio_Gallegos' => 'أمريكا/الأرجنتين/ريوجاليجوس',
    'America/Argentina/Ushuaia' => 'أمريكا/الأرجنتين/أوشايا',
    'America/Aruba' => 'أمريكا/أروبا',
    'America/La_Paz' => 'أمريكا/لاباز',
    'America/Noronha' => 'أمريكا/نورونا',
    'America/Belem' => 'أمريكا/بيليم',
    'America/Fortaleza' => 'أمريكا/فورتاليزا',
    'America/Recife' => 'أمريكا/ريسيفي',
    'America/Araguaina' => 'أمريكا/أراجوانا',
    'America/Maceio' => 'أمريكا/ماسيو',
    'America/Bahia' => 'أمريكا/باهيا',
    'America/Sao_Paulo' => 'أمريكا/ساوباولو',
    'America/Campo_Grande' => 'أمريكا/كامبوجراند',
    'America/Cuiaba' => 'أمريكا/كيابا',
    'America/Porto_Velho' => 'أمريكا/بورتوفيلو',
    'America/Boa_Vista' => 'أمريكا/بوافيستا',
    'America/Manaus' => 'أمريكا/مانوس',
    'America/Eirunepe' => 'أمريكا/إيرونيب',
    'America/Rio_Branco' => 'أمريكا/ريوبرانكو',
    'America/Santiago' => 'أمريكا/سانتياجو',
    'Pacific/Easter' => 'المحيط الهادي/إيستر',
    'America/Bogota' => 'أمريكا/بوجوتا',
    'America/Curacao' => 'أمريكا/كوراكاو',
    'America/Guayaquil' => 'أمريكا/جواياكيل',
    'Pacific/Galapagos' => 'المحيط الهادي/جالاباجوس',
    'Atlantic/Stanley' => 'المحيط الأطلنطي/ستانلي',
    'America/Cayenne' => 'أمريكا/كايان',
    'America/Guyana' => 'أمريكا/غيانا',
    'America/Asuncion' => 'أمريكا/إسونسيون',
    'America/Lima' => 'أمريكا/ليما',
    'Atlantic/South_Georgia' => 'المحيط الأطلنطي/جورجيا الجنوبية',
    'America/Paramaribo' => 'أمريكا/باراماريبو',
    'America/Port_of_Spain' => 'أمريكا/بورت إسبانيا',
    'America/Montevideo' => 'أمريكا/مونتفيديو',
    'America/Caracas' => 'أمريكا/كاراكاس',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = 'المفضلة';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = 'المفضلة';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'ذهاب للاجتماع',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'جهات اتصال Google',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => 'طلب',
    2 => 'إمكانية الوصول',
    3 => 'غير صالح',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'مستخدم Sugar',
    'support_portal' => 'منفذ الدعم',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => 'الحملة',
    'email' => 'البريد الإلكتروني',
    'workflow' => 'سير العمل',
    'system' => 'النظام',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => 'الحملة',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => 'الحملة',
    'email' => 'البريد الإلكتروني',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => 'الوثائق',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => 'نطاقان',
    'show_buckets' => 'ثلاثة نطاقات',
    'show_custom_buckets' => 'نطاقات مخصصة',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => 'سنة استنادًا إلى اليوم',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => 'سنويًا (فترات فرعية ربع سنوية)',
    'Quarter' => 'ربع سنوي (فترات فرعية شهرية)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => 'بنود العائدات',
    'Opportunities' => 'الفرص',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => 'نعم',
    'no' => 'لا',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => 'تنبيه',
    'information' => 'معلومات',
    'other' => 'أخرى',
    'success' => 'نجاح',
    'warning' => 'تحذير',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'GET',
    'PUT' => 'PUT',
    'DELETE' => 'حذف',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => 'يدويًا',
    '5' => 'كل 5 دقائق',
    '15' => 'كل 15 دقيقة',
    '30' => 'كل 30 دقيقة',
    '60' => 'كل ساعة',
];

$app_list_strings['moduleList']['KBDocuments'] = 'قاعدة المعارف';
$app_list_strings['moduleListSingular']['KBDocuments'] = 'قاعدة المعارف';
$app_list_strings['moduleList']['KBContents'] = 'قاعدة المعارف';
$app_list_strings['moduleListSingular']['KBContents'] = 'مقالة قاعدة المعارف';
$app_list_strings['moduleList']['KBArticles'] = 'مقالة قاعدة المعارف';
$app_list_strings['moduleListSingular']['KBArticles'] = 'مقالة قاعدة المعارف';
$app_list_strings['moduleList']['KBContentTemplates'] = 'قالب قاعدة المعارف';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = 'قالب قاعدة المعارف';
$app_list_strings['moduleList']['EmbeddedFiles'] = 'الملفات المضمنة';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = 'الملف المضمن';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'ليك',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'KČ',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '•₪•',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => 'ليك',
    'USD' => 'دولار',
    'AFN' => 'أفغاني',
    'ARS' => 'بيزو',
    'AWG' => 'غيلدر',
    'AUD' => 'دولار',
    'AZN' => 'مانات جديد',
    'BSD' => 'دولار',
    'BBD' => 'دولار',
    'BYR' => 'روبل',
    'EUR' => 'يورو',
    'BZD' => 'دولار',
    'BMD' => 'دولار',
    'BOB' => 'بوليفيانو',
    'BAM' => 'ماركا قابلة للتحويل',
    'BWP' => 'بولا',
    'BGN' => 'ليف',
    'BRL' => 'ريال',
    'GBP' => 'جنيه',
    'BND' => 'دولار',
    'KHR' => 'ريالات',
    'CAD' => 'دولار',
    'KYD' => 'دولار',
    'CLP' => 'بيزو',
    'CNY' => 'رينمينبي الين الصيني',
    'COP' => 'بيزو',
    'CRC' => 'ColÃ³n',
    'HRK' => 'كونا',
    'CUP' => 'بيزو',
    'CZK' => 'كورونا',
    'DKK' => 'كرونا',
    'DOP' => 'بيزو',
    'XCD' => 'دولار',
    'EGP' => 'جنيه',
    'SVC' => 'كولون',
    'EEK' => 'كروني',
    'FKP' => 'جنيه',
    'FJD' => 'دولار',
    'GHC' => 'سيدي',
    'GIP' => 'جنيه',
    'GTQ' => 'كويتزال',
    'GGP' => 'جنيه',
    'GYD' => 'دولار',
    'HNL' => 'لامبيرا',
    'HKD' => 'دولار',
    'HUF' => 'فورنت',
    'ISK' => 'كرونر',
    'INR' => 'روبية',
    'IDR' => 'روبية',
    'IRR' => 'ريال',
    'IMP' => 'جنيه',
    'ILS' => 'شيكل جديد',
    'JMD' => 'دولار',
    'JPY' => 'ين',
    'JEP' => 'جنيه',
    'KZT' => 'تينج',
    'KPW' => 'وون',
    'KRW' => 'وون',
    'KGS' => 'سوم',
    'LAK' => 'كيب',
    'LVL' => 'لاتي',
    'LBP' => 'جنيه',
    'LRD' => 'دولار',
    'CHF' => 'فرنك سويسري',
    'LTL' => 'ليتا',
    'MKD' => 'دينار',
    'MYR' => 'رنجيت',
    'MUR' => 'روبية',
    'MXN' => 'بيزو',
    'MNT' => 'توجريت',
    'MZN' => 'ميتيكال',
    'NAD' => 'دولار',
    'NPR' => 'روبية',
    'ANG' => 'غيلدر',
    'NZD' => 'دولار',
    'NIO' => 'كوردبة',
    'NGN' => 'نايرا',
    'NOK' => 'كورون',
    'OMR' => 'ريال',
    'PKR' => 'روبية',
    'PAB' => 'بالبوا',
    'PYG' => 'غواراني',
    'PEN' => 'سول جديد',
    'PHP' => 'بيزو',
    'PLN' => 'زلوتيتش',
    'QAR' => 'ريال',
    'RON' => 'لي جديد',
    'RUB' => 'روبل',
    'SHP' => 'جنيه',
    'SAR' => 'ريال',
    'RSD' => 'دينار',
    'SCR' => 'روبية',
    'SGD' => 'دولار',
    'SBD' => 'دولار',
    'SOS' => 'شلن',
    'ZAR' => 'راند',
    'LKR' => 'روبية',
    'SEK' => 'كرونا',
    'SRD' => 'دولار',
    'SYP' => 'جنيه',
    'TWD' => 'دولار جديد',
    'THB' => 'باهت',
    'TTD' => 'دولار',
    'TRY' => 'ليرة',
    'TRL' => 'ليرات',
    'TVD' => 'دولار',
    'UAH' => 'هيرفنيا',
    'UYU' => 'بيزو',
    'UZS' => 'المبالغ',
    'VEF' => 'فويرتيس بوليفاري',
    'VND' => 'دونغ',
    'YER' => 'ريال',
    'ZWD' => 'دولار زيمبابوي',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => 'مرتغعة جدًا',
    '4' => 'مرتفعة',
    '3' => 'متعادلة',
    '2' => 'منخفضة',
    '1' => 'منخفضة جدًا',
];
$app_list_strings['process_et_field_type'] = [
    'none' => 'بلا',
    'future' => 'القيمة الحالية',
    'old' => 'القيمة القديمة',
    'both' => 'القيم الحالية والقديمة',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => 'إصابة مفردة',
];

$app_list_strings['merge_status_list'] = [
    'processing' => 'المعالجة',
    'error' => 'خطأ',
    'success' => 'نجاح',
    'canceled' => 'تم الإلغاء',
    'document_load' => 'تحميل القالب',
    'tags_extract' => 'استخراج العلامات',
    'tags_validate' => 'التحقق من صحة العلامات',
    'data_retrieving' => 'استرداد البيانات',
    'serialize_document' => 'إعادة تجميع المستند',
    'send_document' => 'إرسال المستند إليك',
];

$app_list_strings['merge_type_list'] = [
    'merge' => 'دمج',
    'convert' => 'دمج PDF',
    'multimerge' => 'دمج متعدد',
    'multimerge_convert' => 'دمج PDF متعدد',
    'labelsgenerate' => 'إنشاء تسميات',
    'labelsgenerate_convert' => 'إنشاء تسميات PDF',
    'excel' => 'دمج Excel',
    'excel_convert' => 'تحويل دمج Excel',
    'presentation' => 'دمج PowerPoint',
    'presentation_convert' => 'دمج PDF مع PowerPoint',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => 'حساباتي',
    'favorites' => 'الحسابات المفضلة',
    'tags' => 'الحسابات المُعلمة',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => 'كل الأخبار',
    'General' => 'عام',
    'Finance' => 'مالي',
    'People' => 'العاملون',
    'Press Releases' => 'الإصدارات الصحفية',
    'Other' => 'أخرى',
];

$app_strings['LBL_OWNERS'] = 'الملاك';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = 'محرك السحابة';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = 'لوحة معلومات تكامل محرك السحابة';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = 'نسخ الارتباط';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = 'تنزيل';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = 'إنشاء مستند Sugar';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = 'يتعذر تنزيل هذا الملف';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = 'لوحة معلومات السحابة غير موجودة';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'تم إنشاء مستند Sugar';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = 'إرسال إلى DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'لايتوفر DocuSign من هذا الموقع.';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = 'دمج المستندات إلى Word/Excel/PowerPoint غير متوفر من هذا الموقع';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = 'دمج المستندات إلى DocuSign غير متوفر من هذا الموقع';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = 'دمج المستندات إلى PDF غير متوفر من هذا الموقع';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = 'لن يتم تحميل ملفك الموقع هنا إلا إذا كان لديك إذن للتحميل في هذا الموقع.';
$app_strings['LBL_DOC_MERGE_TO'] = 'دمج المستندات مع';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = 'ملفاتي';
$app_strings['LBL_SHARED_WITH_ME'] = 'مشاركة معي';
$app_strings['LBL_CLOUD_PROVIDER'] = 'مقدم خدمة السحابة';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = 'مشترك معي';
$app_strings['LBL_MY_FILES'] = 'ملفاتي';
$app_strings['LBL_UPLOAD_FILE'] = 'تحميل ملف';
$app_strings['LBL_FOLDER_NOT_FOUND'] = 'لم يتم العثور على المجلد';
$app_strings['LBL_CREATE_FOLDER'] = 'إنشاء مجلد';
$app_strings['LBL_LOAD_MORE'] = 'تحميل المزيد...';
$app_strings['LBL_NEW_FOLDER'] = 'مجلد جديد';
$app_strings['LBL_FOLDER_NAME'] = 'اسم المجلد: ';
$app_strings['LBL_PERMISSION_ERROR'] = 'ليس لديك إذن لفعل ذلك على المسار الحالي.';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = 'ليس لديك إذن للمتابعة على المسار الحالي.';
$app_strings['LBL_FILE_UPLOADED'] = 'تم تحميل الملف.';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = 'نظرًا للحجم الكبير لملفك، سيستغرق التحميل بعض الوقت.';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = 'سجل مستند واحد أو أكثر لا يملك ملف مرفق. الرجاء إرفاق ملفات إلى السجلات وإعادة المحاولة، أو مزامنة سجلات معينة مع الملفات.';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = 'لم يتم العثور على اتصال مع Google...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = 'لم يتم العثور على اتصال مع Microsoft...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = 'لم يتم العثور على اتصال مع Dropbox...';
$app_strings['LBL_MICROSOFT_DELAY'] = 'قد تستغرق المزامنة مع OneDrive مدة';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = 'هل تريد بالتأكيد حذف هذا الملف؟';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'اكتمل تحميل OneDrive.';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' تم تحميله بنجاح.';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = 'خطأ أثناء تحميل المسارات.';
$app_strings['LBL_INVALID_DRIVE_FILE'] = 'حدث خطأ لأن الملف تالف.';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = 'تم حفظ المستند <i>"{{documentName}}"</i> على محرك الأقراص السحابي الخاص بك، وإضافته إلى وحدة المستندات.';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = 'ليس لديك إذن لحذف هذا الملف.';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = 'ليس لديك إذن لحذف هذا الملف.';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = 'ليس لديك أذونات لتحميل الملفات إلى هذا الموقع.';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = 'ليس لديك إذن لإنشاء مجلد في هذا الموقع.';
$app_strings['LBL_NO_FOLDER_CREATE'] = 'لا يمكن إنشاء المجلدات في هذا الموقع.';
$app_strings['LBL_NO_FILE_UPLOAD'] = 'لا يمكن تحميل الملفات إلى هذا الموقع.';
$app_strings['LBL_SITES'] = 'المواقع';
$app_strings['LBL_SHARED'] = 'مُشارك';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = 'تم إنشاء الارتباط. انقر فوق الزر لنسخ الارتباط إلى الحافظة الخاصة بك.';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = 'نسخ إلى الحافظة';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-فارغ-',
    'Exact' => 'بالضبط',
    'Null_address_components' => 'مكون أو مكونات عنوان متعددة فارغة',
    'Invalid_address' => 'عنوان غير صحيح، أرجع الخادم خطأ',
    'Invalid_server_response_not_XML' => 'استجابة خادم غير صالحة، ليس XML',
    'Invalid_address_no_location' => 'عنوان غير صالح، لم يرجع الخادم موقعًا',
    'Ambiguous_address' => 'عنوان غامض، تطابقات متعددة',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => 'الطريق',
    'a' => 'جوي',
    'rd' => 'طريق داكن',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', 'الإنجليزية (الولايات المتحدة)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['est', 'نيويورك (توقيت شرق الولايات المتحدة)'],
    ['pst', 'لوس أنجلوس (توقيت المحيط الهادي)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['جديد', 'جديد'],
    ['معيَّن', 'معيَّن'],
    ['مغلق', 'مغلق'],
    ['إدخال معلق', 'إدخال معلق'],
    ['مرفوض', 'مرفوض'],
    ['تكرار', 'تكرار'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['الإدارة', 'الإدارة'],
    ['المنتج', 'المنتج'],
    ['المستخدم', 'المستخدم'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', 'عالية'],
    ['P2', 'متوسطة'],
    ['P3', 'منخفضة'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['المستخدم', 'المستخدم'],
    ['مسؤول، مستخدم', 'مسؤول'],
    ['مدير حساب، مستخدم', 'مدير حساب'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['آخر_30_يومًا', 'آخر 30 يومًا'],
    ['آخر_90_يومًا', 'آخر 90 يومًا'],
    ['هذا_العام', 'العام الماضي'],
    ['مخصص', 'النطاق المخصص'],
    ['الكل', 'الكل'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    [' افتراضي', ' افتراضي'],
    ['اللون', 'لون ثابت'],
    ['عنوان Url', 'صورة مخصصة'],
];
