<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */


class SugarWidgetSubPanelRemoveButton extends SugarWidgetField
{
    public function displayHeaderCell($layout_def)
    {
        return '&nbsp;';
    }

    public function displayList($layout_def)
    {

        global $app_strings;
        global $subpanel_item_count;

        $unique_id = $layout_def['subpanel_id'] . '_remove_' . $subpanel_item_count; //bug 51512

        $parent_record_id = $_REQUEST['record'];
        $parent_module = $_REQUEST['module'];

        $action = 'DeleteRelationship';
        $record = $layout_def['fields']['ID'];
        $current_module = $layout_def['module'];
        //in document revisions subpanel ,users are now allowed to
        //delete the latest revsion of a document. this will be tested here
        //and if the condition is met delete button will be removed.
        $hideremove = false;
        if ($current_module == 'DocumentRevisions') {
            if ($layout_def['fields']['ID'] == $layout_def['fields']['LATEST_REVISION_ID']) {
                $hideremove = true;
            }
        } // Implicit Team-memberships are not "removeable"
        elseif ($_REQUEST['module'] == 'Teams' && $current_module == 'Users') {
            if ($layout_def['fields']['UPLINE'] != translate('LBL_TEAM_UPLINE_EXPLICIT', 'Users')) {
                $hideremove = true;
            }

            //We also cannot remove the user whose private team is set to the parent_record_id value
            $user = BeanFactory::getBean('Users', $layout_def['fields']['ID']);
            if ($parent_record_id == $user->getPrivateTeamID()) {
                $hideremove = true;
            }
        }


        $return_module = $_REQUEST['module'];
        $return_action = 'SubPanelViewer';
        $subpanel = $layout_def['subpanel_id'];
        $return_id = $_REQUEST['record'];
        if (isset($layout_def['linked_field_set']) && !empty($layout_def['linked_field_set'])) {
            $linked_field = $layout_def['linked_field_set'];
        } else {
            $linked_field = $layout_def['linked_field'];
        }
        $refresh_page = 0;
        if (!empty($layout_def['refresh_page'])) {
            $refresh_page = 1;
        }
        $return_url = "index.php?module=$return_module&action=$return_action&subpanel=$subpanel&record=$return_id&sugar_body_only=1&inline=1";

        $icon_remove_text = strtolower($app_strings['LBL_ID_FF_REMOVE']);

        if ($linked_field == 'get_emails_by_assign_or_link') {
            $linked_field = 'emails';
        }
        //based on listview since that lets you select records
        if ($layout_def['ListView'] && !$hideremove) {
            $retStr = "<a href=\"javascript:sub_p_rem('$subpanel', '$linked_field'"
                . ", '$record', $refresh_page);\""
                . ' class="listViewTdToolsS1"'
                . "id=$unique_id"
                . ' onclick="return sp_rem_conf();"'
                . ">$icon_remove_text</a>";
            return $retStr;
        } else {
            return '';
        }
    }
}
