<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$vardefs = [
    'fields' => [
        'salutation' => [
            'name' => 'salutation',
            'vname' => 'LBL_SALUTATION',
            'type' => 'enum',
            'options' => 'salutation_dom',
            'massupdate' => false,
            'len' => '255',
            'duplicate_on_record_copy' => 'always',
            'comment' => 'Contact salutation (e.g., Mr, Ms)',
            'audited' => true,
            'pii' => true,
        ],
        'first_name' => [
            'name' => 'first_name',
            'vname' => 'LBL_FIRST_NAME',
            'type' => 'varchar',
            'len' => '255',
            'unified_search' => true,
            'duplicate_on_record_copy' => 'always',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 1.81,
            ],
            'comment' => 'First name of the contact',
            'merge_filter' => 'selected',
            'audited' => true,
            'pii' => true,

        ],
        'last_name' => [
            'name' => 'last_name',
            'vname' => 'LBL_LAST_NAME',
            'type' => 'varchar',
            'len' => '255',
            'unified_search' => true,
            'duplicate_on_record_copy' => 'always',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 1.79,
            ],
            'comment' => 'Last name of the contact',
            'merge_filter' => 'selected',
            'required' => true,
            'importable' => 'required',
            'audited' => true,
            'pii' => true,
        ],
        'name' => [
            'name' => 'name',
            'vname' => 'LBL_NAME',
            'type' => 'fullname',
            'fields' => ['first_name', 'last_name', 'salutation', 'title'],
            'sort_on' => 'last_name',
            'source' => 'non-db',
            'group' => 'last_name',
            'db_concat_fields' => [0 => 'first_name', 1 => 'last_name'],
            'importable' => 'false',
            'duplicate_on_record_copy' => 'always',
        ],
        'full_name' => [
            'name' => 'full_name',
            'vname' => 'LBL_NAME',
            'type' => 'fullname',
            'fields' => ['first_name', 'last_name', 'salutation', 'title'],
            'sort_on' => 'last_name',
            'source' => 'non-db',
            'group' => 'last_name',
            'db_concat_fields' => [0 => 'first_name', 1 => 'last_name'],
            'studio' => ['listview' => false],
            'duplicate_on_record_copy' => 'always',
        ],
        'title' => [
            'name' => 'title',
            'vname' => 'LBL_TITLE',
            'type' => 'varchar',
            'len' => '100',
            'duplicate_on_record_copy' => 'always',
            'comment' => 'The title of the contact',
            'audited' => true,
            'pii' => true,
        ],
        'facebook' => [
            'name' => 'facebook',
            'vname' => 'LBL_FACEBOOK',
            'type' => 'varchar',
            'len' => '100',
            'duplicate_on_record_copy' => 'always',
            'comment' => 'The facebook name of the user',
            'audited' => true,
            'pii' => true,
        ],
        'twitter' => [
            'name' => 'twitter',
            'vname' => 'LBL_TWITTER',
            'type' => 'varchar',
            'len' => '100',
            'duplicate_on_record_copy' => 'always',
            'comment' => 'The twitter name of the user',
            'audited' => true,
            'pii' => true,
        ],
        'googleplus' => [
            'name' => 'googleplus',
            'vname' => 'LBL_GOOGLEPLUS',
            'type' => 'varchar',
            'len' => '100',
            'duplicate_on_record_copy' => 'always',
            'comment' => 'The google plus id of the user',
            'audited' => true,
            'pii' => true,
        ],
        'department' => [
            'name' => 'department',
            'vname' => 'LBL_DEPARTMENT',
            'type' => 'varchar',
            'len' => '255',
            'duplicate_on_record_copy' => 'always',
            'comment' => 'The department of the contact',
            'merge_filter' => 'enabled',
        ],
        'do_not_call' => [
            'name' => 'do_not_call',
            'vname' => 'LBL_DO_NOT_CALL',
            'type' => 'bool',
            'default' => '0',
            'audited' => true,
            'duplicate_on_record_copy' => 'always',
            'comment' => 'An indicator of whether contact can be called',
        ],
        'phone_home' => [
            'name' => 'phone_home',
            'vname' => 'LBL_HOME_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'duplicate_on_record_copy' => 'always',
            'unified_search' => true,
            'full_text_search' => ['enabled' => true, 'searchable' => true, 'boost' => 0.97],
            'comment' => 'Home phone number of the contact',
            'merge_filter' => 'enabled',
            'audited' => true,
            'pii' => true,
        ],
        'phone_mobile' => [
            'name' => 'phone_mobile',
            'vname' => 'LBL_MOBILE_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'unified_search' => true,
            'full_text_search' => ['enabled' => true, 'searchable' => true, 'boost' => 0.96],
            'comment' => 'Mobile phone number of the contact',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'phone_work' => [
            'name' => 'phone_work',
            'vname' => 'LBL_OFFICE_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'audited' => true,
            'unified_search' => true,
            'full_text_search' => ['enabled' => true, 'searchable' => true, 'boost' => 0.95],
            'comment' => 'Work phone number of the contact',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'phone_other' => [
            'name' => 'phone_other',
            'vname' => 'LBL_OTHER_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'unified_search' => true,
            'full_text_search' => ['enabled' => true, 'searchable' => true, 'boost' => 0.94],
            'comment' => 'Other phone number for the contact',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'phone_fax' => [
            'name' => 'phone_fax',
            'vname' => 'LBL_FAX_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'unified_search' => true,
            'full_text_search' => ['enabled' => true, 'searchable' => true, 'boost' => 0.93],
            'comment' => 'Contact fax number',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'primary_address_street' => [
            'name' => 'primary_address_street',
            'vname' => 'LBL_PRIMARY_ADDRESS_STREET',
            'type' => 'text',
            'dbType' => 'varchar',
            'len' => '150',
            'comment' => 'The street address used for primary address',
            'group' => 'primary_address',
            'group_label' => 'LBL_PRIMARY_ADDRESS',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 0.29,
            ],
            'audited' => true,
            'pii' => true,
            'rows' => 2,
            'cols' => 20,
        ],
        'primary_address_street_2' => [
            'name' => 'primary_address_street_2',
            'vname' => 'LBL_PRIMARY_ADDRESS_STREET_2',
            'type' => 'varchar',
            'len' => '150',
            'source' => 'non-db',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
            'massupdate' => false,
        ],
        'primary_address_street_3' => [
            'name' => 'primary_address_street_3',
            'vname' => 'LBL_PRIMARY_ADDRESS_STREET_3',
            'type' => 'varchar',
            'len' => '150',
            'source' => 'non-db',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
            'massupdate' => false,
        ],
        'primary_address_city' => [
            'name' => 'primary_address_city',
            'vname' => 'LBL_PRIMARY_ADDRESS_CITY',
            'type' => 'varchar',
            'len' => '100',
            'group' => 'primary_address',
            'comment' => 'City for primary address',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'primary_address_state' => [
            'name' => 'primary_address_state',
            'vname' => 'LBL_PRIMARY_ADDRESS_STATE',
            'type' => 'varchar',
            'len' => '100',
            'group' => 'primary_address',
            'comment' => 'State for primary address',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'primary_address_postalcode' => [
            'name' => 'primary_address_postalcode',
            'vname' => 'LBL_PRIMARY_ADDRESS_POSTALCODE',
            'type' => 'varchar',
            'len' => '20',
            'group' => 'primary_address',
            'comment' => 'Postal code for primary address',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,

        ],
        'primary_address_country' => [
            'name' => 'primary_address_country',
            'vname' => 'LBL_PRIMARY_ADDRESS_COUNTRY',
            'type' => 'varchar',
            'group' => 'primary_address',
            'comment' => 'Country for primary address',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'alt_address_street' => [
            'name' => 'alt_address_street',
            'vname' => 'LBL_ALT_ADDRESS_STREET',
            'type' => 'text',
            'dbType' => 'varchar',
            'len' => '150',
            'group' => 'alt_address',
            'group_label' => 'LBL_ALT_ADDRESS',
            'comment' => 'Street address for alternate address',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 0.28,
            ],
            'audited' => true,
            'pii' => true,
            'rows' => 2,
            'cols' => 20,
        ],
        'alt_address_street_2' => [
            'name' => 'alt_address_street_2',
            'vname' => 'LBL_ALT_ADDRESS_STREET_2',
            'type' => 'varchar',
            'len' => '150',
            'source' => 'non-db',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
            'massupdate' => false,
        ],
        'alt_address_street_3' => [
            'name' => 'alt_address_street_3',
            'vname' => 'LBL_ALT_ADDRESS_STREET_3',
            'type' => 'varchar',
            'len' => '150',
            'source' => 'non-db',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
            'massupdate' => false,
        ],
        'alt_address_city' => [
            'name' => 'alt_address_city',
            'vname' => 'LBL_ALT_ADDRESS_CITY',
            'type' => 'varchar',
            'len' => '100',
            'group' => 'alt_address',
            'comment' => 'City for alternate address',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'alt_address_state' => [
            'name' => 'alt_address_state',
            'vname' => 'LBL_ALT_ADDRESS_STATE',
            'type' => 'varchar',
            'len' => '100',
            'group' => 'alt_address',
            'comment' => 'State for alternate address',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'alt_address_postalcode' => [
            'name' => 'alt_address_postalcode',
            'vname' => 'LBL_ALT_ADDRESS_POSTALCODE',
            'type' => 'varchar',
            'len' => '20',
            'group' => 'alt_address',
            'comment' => 'Postal code for alternate address',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'alt_address_country' => [
            'name' => 'alt_address_country',
            'vname' => 'LBL_ALT_ADDRESS_COUNTRY',
            'type' => 'varchar',
            'group' => 'alt_address',
            'comment' => 'Country for alternate address',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'assistant' => [
            'name' => 'assistant',
            'vname' => 'LBL_ASSISTANT',
            'type' => 'varchar',
            'len' => '75',
            'unified_search' => true,
            'comment' => 'Name of the assistant of the contact',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'assistant_phone' => [
            'name' => 'assistant_phone',
            'vname' => 'LBL_ASSISTANT_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'group' => 'assistant',
            'unified_search' => true,
            'comment' => 'Phone number of the assistant of the contact',
            'merge_filter' => 'enabled',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
            'pii' => true,
        ],
        'picture' => [
            'name' => 'picture',
            'vname' => 'LBL_PICTURE_FILE',
            'type' => 'image',
            'dbtype' => 'varchar',
            'massupdate' => false,
            'reportable' => false,
            'comment' => 'Avatar',
            'len' => '255',
            'width' => '42',
            'height' => '42',
            'border' => '',
            'duplicate_on_record_copy' => 'always',
        ],
    ],
    'name_format_map' => [
        'f' => 'first_name',
        'l' => 'last_name',
        's' => 'salutation',
        't' => 'title',
    ],
    'uses' => [
        'email_address',
        'taggable',
        'audit',
        'external_user',
    ],
    'relationships' => [
    ],
    'indices' => [
        [
            'name' => 'idx_' . strtolower($module) . '_last_first',
            'type' => 'index',
            'fields' => ['last_name', 'first_name', 'deleted'],
        ],
        [
            'name' => 'idx_' . strtolower($module) . '_first_last',
            'type' => 'index',
            'fields' => ['first_name', 'last_name', 'deleted'],
        ],
    ],
    'duplicate_check' => [
        'enabled' => true,
        'FilterDuplicateCheck' => [
            'filter_template' => [
                ['$and' => [
                    ['first_name' => ['$starts' => '$first_name']],
                    ['last_name' => ['$starts' => '$last_name']],
                ]],
            ],
            'ranking_fields' => [
                ['in_field_name' => 'last_name', 'dupe_field_name' => 'last_name'],
                ['in_field_name' => 'first_name', 'dupe_field_name' => 'first_name'],
            ],
        ],
    ],
];
