<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$vardefs = [
    'fields' => [
        'dri_workflow_id' => [
            'name' => 'dri_workflow_id',
            'vname' => 'LBL_DRI_WORKFLOW',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
            'processes' => false,
        ],
        'dri_workflow_name' => [
            'name' => 'dri_workflow_name',
            'vname' => 'LBL_DRI_WORKFLOW',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflows',
            'id_name' => 'dri_workflow_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflows',
            'link' => 'dri_workflow_link',
            'processes' => false,
        ],
        'dri_workflow_link' => [
            'name' => 'dri_workflow_link',
            'vname' => 'LBL_DRI_WORKFLOW',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow',
            'relationship' => strtolower($object_name) . '_dri_workflows',
            'module' => 'DRI_Workflows',
            'processes' => false,
        ],
        'current_cj_activity_at' => [
            'name' => 'current_cj_activity_at',
            'vname' => 'LBL_CURRENT_CJ_ACTIVITY_AT',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow',
            'relationship' => strtolower($module) . '_flex_relate_dri_workflows',
            'module' => 'DRI_Workflows',
            'processes' => false,
        ],
        'dri_subworkflow_id' => [
            'name' => 'dri_subworkflow_id',
            'vname' => 'LBL_DRI_SUBWORKFLOW',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
            'processes' => false,
        ],
        'dri_subworkflow_name' => [
            'name' => 'dri_subworkflow_name',
            'vname' => 'LBL_DRI_SUBWORKFLOW',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_subworkflows',
            'id_name' => 'dri_subworkflow_id',
            'sort_on' => 'name',
            'module' => 'DRI_SubWorkflows',
            'link' => 'dri_subworkflow_link',
            'processes' => false,
        ],
        'dri_subworkflow_link' => [
            'name' => 'dri_subworkflow_link',
            'vname' => 'LBL_DRI_SUBWORKFLOW',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_SubWorkflow',
            'relationship' => strtolower($object_name) . '_dri_subworkflows',
            'module' => 'DRI_SubWorkflows',
            'processes' => false,
        ],
        'dri_subworkflow_template_id' => [
            'name' => 'dri_subworkflow_template_id',
            'vname' => 'LBL_DRI_SUBWORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
            'processes' => false,
        ],
        'dri_subworkflow_template_name' => [
            'name' => 'dri_subworkflow_template_name',
            'vname' => 'LBL_DRI_SUBWORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_subworkflow_templates',
            'id_name' => 'dri_subworkflow_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_SubWorkflow_Templates',
            'link' => 'dri_subworkflow_template_link',
            'processes' => false,
        ],
        'dri_subworkflow_template_link' => [
            'name' => 'dri_subworkflow_template_link',
            'vname' => 'LBL_DRI_SUBWORKFLOW_TEMPLATE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_SubWorkflow_Template',
            'relationship' => strtolower($object_name) . '_dri_subworkflow_templates',
            'module' => 'DRI_SubWorkflow_Templates',
            'processes' => false,
        ],
        'dri_workflow_template_id' => [
            'name' => 'dri_workflow_template_id',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
            'processes' => false,
        ],
        'dri_workflow_template_name' => [
            'name' => 'dri_workflow_template_name',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_templates',
            'id_name' => 'dri_workflow_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Templates',
            'link' => 'dri_workflow_template_link',
            'processes' => false,
        ],
        'dri_workflow_template_link' => [
            'name' => 'dri_workflow_template_link',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Template',
            'relationship' => strtolower($object_name) . '_dri_workflow_templates',
            'module' => 'DRI_Workflow_Templates',
            'processes' => false,
        ],
        'dri_workflow_task_template_id' => [
            'name' => 'dri_workflow_task_template_id',
            'vname' => 'LBL_DRI_WORKFLOW_TASK_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'cj_activity_tpl_name' => [
            'name' => 'cj_activity_tpl_name',
            'vname' => 'LBL_DRI_WORKFLOW_TASK_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_task_templates',
            'id_name' => 'dri_workflow_task_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Task_Templates',
            'link' => 'cj_activity_tpl_link',
            'processes' => false,
        ],
        'cj_activity_tpl_link' => [
            'name' => 'cj_activity_tpl_link',
            'vname' => 'LBL_DRI_WORKFLOW_TASK_TEMPLATE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => strtolower($object_name) . '_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
            'processes' => false,
        ],
        'dri_workflow_sort_order' => [
            'name' => 'dri_workflow_sort_order',
            'vname' => 'LBL_DRI_WORKFLOW_SORT_ORDER',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'varchar',
            'len' => 255,
            'default' => 1,
            'dependency' => 'not(equal($dri_subworkflow_id, ""))',
            'processes' => false,
        ],
        'cj_actual_sort_order' => [
            'name' => 'cj_actual_sort_order',
            'vname' => 'LBL_CJ_ACTUAL_SORT_ORDER',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'varchar',
            'len' => 255,
            'dependency' => 'not(equal($dri_subworkflow_id, ""))',
            'processes' => false,
        ],
        'customer_journey_score' => [
            'name' => 'customer_journey_score',
            'vname' => 'LBL_CUSTOMER_JOURNEY_SCORE',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'readonly' => true,
            'processes' => false,
        ],
        'cj_momentum_points' => [
            'name' => 'cj_momentum_points',
            'vname' => 'LBL_CJ_MOMENTUM_POINTS',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'readonly' => true,
            'processes' => false,
        ],
        'cj_momentum_score' => [
            'name' => 'cj_momentum_score',
            'vname' => 'LBL_CJ_MOMENTUM_SCORE',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'readonly' => true,
            'processes' => false,
        ],
        'cj_allow_activity_by' => [
            'name' => 'cj_allow_activity_by',
            'vname' => 'LBL_CJ_ALLOW_ACTIVITY_BY',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => false,
            'massupdate' => false,
            'type' => 'text',
            'studio' => false,
            'processes' => false,
        ],
        'customer_journey_progress' => [
            'name' => 'customer_journey_progress',
            'vname' => 'LBL_CUSTOMER_JOURNEY_PROGRESS',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'float',
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'processes' => false,
        ],
        'cj_momentum_ratio' => [
            'name' => 'cj_momentum_ratio',
            'vname' => 'LBL_CJ_MOMENTUM_RATIO',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'float',
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'processes' => false,
        ],
        'customer_journey_points' => [
            'name' => 'customer_journey_points',
            'vname' => 'LBL_CUSTOMER_JOURNEY_POINTS',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_points_list',
            'type' => 'enum',
            'dependency' => 'not(equal($dri_subworkflow_id, ""))',
            'default' => 10,
            'dbType' => 'int',
            'len' => 3,
            'processes' => false,
        ],
        'cj_parent_activity_type' => [
            'name' => 'cj_parent_activity_type',
            'vname' => 'LBL_CJ_PARENT_ACTIVITY_TYPE',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_cj_parent_activity_type_list',
            'type' => 'enum',
            'processes' => false,
        ],
        'customer_journey_blocked_by' => [
            'name' => 'customer_journey_blocked_by',
            'vname' => 'LBL_CUSTOMER_JOURNEY_BLOCKED_BY',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'json',
            'dbType' => 'text',
            'isMultiSelect' => true,
            'processes' => false,
        ],
        'cj_blocked_by_stages' => [
            'name' => 'cj_blocked_by_stages',
            'vname' => 'LBL_CJ_BLOCKED_BY_STAGES',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'json',
            'dbType' => 'text',
            'isMultiSelect' => true,
            'processes' => false,
        ],
        'is_cj_parent_activity' => [
            'name' => 'is_cj_parent_activity',
            'vname' => 'LBL_IS_CJ_PARENT_ACTIVITY',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'bool',
            'default' => false,
            'processes' => false,
        ],
        'is_customer_journey_activity' => [
            'name' => 'is_customer_journey_activity',
            'vname' => 'LBL_IS_CUSTOMER_JOURNEY_ACTIVITY',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'bool',
            'default' => false,
            'enforced' => true,
            'calculated' => true,
            'formula' => 'not(equal($dri_subworkflow_id, ""))',
            'processes' => false,
        ],
        'cj_momentum_start_date' => [
            'name' => 'cj_momentum_start_date',
            'vname' => 'LBL_CJ_MOMENTUM_START_DATE',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'datetime',
            'processes' => false,
        ],
        'cj_momentum_end_date' => [
            'name' => 'cj_momentum_end_date',
            'vname' => 'LBL_CJ_MOMENTUM_END_DATE',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'datetime',
            'processes' => false,
        ],
        'cj_url' => [
            'name' => 'cj_url',
            'vname' => 'LBL_CJ_URL',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'url',
            'dbType' => 'varchar',
            'processes' => false,
        ],
        'cj_parent_activity_id' => [
            'name' => 'cj_parent_activity_id',
            'vname' => 'LBL_CJ_PARENT_ACTIVITY_ID',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
            'processes' => false,
        ],
        'start_next_journey_id' => [
            'name' => 'start_next_journey_id',
            'vname' => 'LBL_START_NEXT_JOURNEY_ID',
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'parent_' . strtolower($object_name) . '_of_call_rel' => [
            'name' => 'parent_' . strtolower($object_name) . '_of_call_rel',
            'type' => 'link',
            'relationship' => 'parent_' . strtolower($object_name) . '_of_call_rel',
            'source' => 'non-db',
            'vname' => 'LBL_PARENT_' . strtoupper($object_name) . '_OF_CALL_REL',
            'reportable' => true,
        ],
        'parent_' . strtolower($object_name) . '_of_meeting_rel' => [
            'name' => 'parent_' . strtolower($object_name) . '_of_meeting_rel',
            'type' => 'link',
            'relationship' => 'parent_' . strtolower($object_name) . '_of_meeting_rel',
            'source' => 'non-db',
            'vname' => 'LBL_PARENT_' . strtoupper($object_name) . '_OF_MEETING_REL',
            'reportable' => true,
        ],
        'parent_' . strtolower($object_name) . '_of_task_rel' => [
            'name' => 'parent_' . strtolower($object_name) . '_of_task_rel',
            'type' => 'link',
            'relationship' => 'parent_' . strtolower($object_name) . '_of_task_rel',
            'source' => 'non-db',
            'vname' => 'LBL_PARENT_' . strtoupper($object_name) . '_OF_TASK_REL',
            'reportable' => true,
        ],
    ],
    'relationships' => [
        strtolower($object_name) . '_dri_workflows' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflows',
            'lhs_table' => 'dri_workflows',
            'rhs_module' => $module,
            'rhs_table' => strtolower($module),
            'rhs_key' => 'dri_workflow_id',
        ],
        strtolower($module) . '_flex_relate_dri_workflows' => [
            'lhs_key' => 'id',
            'relationship_type' => 'one-to-many',
            'lhs_module' => $module,
            'lhs_table' => strtolower($module),
            'rhs_key' => 'parent_id',
            'rhs_module' => 'DRI_Workflows',
            'rhs_table' => 'dri_workflows',
            'relationship_role_column_value' => $module,
            'relationship_role_column' => 'parent_type',
        ],
        strtolower($object_name) . '_dri_subworkflows' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_SubWorkflows',
            'lhs_table' => 'dri_subworkflows',
            'rhs_module' => $module,
            'rhs_table' => strtolower($module),
            'rhs_key' => 'dri_subworkflow_id',
        ],
        strtolower($object_name) . '_dri_subworkflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_SubWorkflow_Templates',
            'lhs_table' => 'dri_subworkflow_templates',
            'rhs_module' => $module,
            'rhs_table' => strtolower($module),
            'rhs_key' => 'dri_subworkflow_template_id',
        ],
        strtolower($object_name) . '_dri_workflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Templates',
            'lhs_table' => 'dri_workflow_templates',
            'rhs_module' => $module,
            'rhs_table' => strtolower($module),
            'rhs_key' => 'dri_workflow_template_id',
        ],
        strtolower($object_name) . '_dri_workflow_task_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Task_Templates',
            'lhs_table' => 'dri_workflow_task_templates',
            'rhs_module' => $module,
            'rhs_table' => strtolower($module),
            'rhs_key' => 'dri_workflow_task_template_id',
        ],
        'parent_' . strtolower($object_name) . '_of_call_rel' => [
            'lhs_module' => $module,
            'lhs_table' => strtolower($module),
            'lhs_key' => 'id',
            'rhs_module' => 'Calls',
            'rhs_table' => 'calls',
            'rhs_key' => 'cj_parent_activity_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'cj_parent_activity_type',
            'relationship_role_column_value' => $module,
        ],
        'parent_' . strtolower($object_name) . '_of_meeting_rel' => [
            'lhs_module' => $module,
            'lhs_table' => strtolower($module),
            'lhs_key' => 'id',
            'rhs_module' => 'Meetings',
            'rhs_table' => 'meetings',
            'rhs_key' => 'cj_parent_activity_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'cj_parent_activity_type',
            'relationship_role_column_value' => $module,
        ],
        'parent_' . strtolower($object_name) . '_of_task_rel' => [
            'lhs_module' => $module,
            'lhs_table' => strtolower($module),
            'lhs_key' => 'id',
            'rhs_module' => 'Tasks',
            'rhs_table' => 'tasks',
            'rhs_key' => 'cj_parent_activity_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'cj_parent_activity_type',
            'relationship_role_column_value' => $module,
        ],
    ],
    'indices' => [
        'idx_del_wf_tpl_sub_subtpl_' . strtolower($object_name) . '_name' => [
            'name' => 'idx_del_wf_tpl_sub_subtpl_' . strtolower($object_name) . '_name',
            'type' => 'index',
            'fields' => [
                'deleted',
                'dri_workflow_id',
                'dri_workflow_template_id',
                'dri_subworkflow_id',
                'dri_subworkflow_template_id',
                'dri_workflow_task_template_id',
                'name',
            ],
        ],
        'idx_del_wf_tpl_sub_subtpl_' . strtolower($object_name) . '_status' => [
            'name' => 'idx_del_wf_tpl_sub_subtpl_' . strtolower($object_name) . '_status',
            'type' => 'index',
            'fields' => [
                'deleted',
                'dri_workflow_id',
                'dri_workflow_template_id',
                'dri_subworkflow_id',
                'dri_subworkflow_template_id',
                'dri_workflow_task_template_id',
                'status',
            ],
        ],
        'idx_' . strtolower($object_name) . '_cj_stage_id' => [
            'name' => 'idx_' . strtolower($object_name) . '_cj_stage_id',
            'type' => 'index',
            'fields' => [
                'dri_subworkflow_id',
            ],
        ],
        'idx_' . strtolower($object_name) . '_cj_stage_tpl_id' => [
            'name' => 'idx_' . strtolower($object_name) . '_cj_stage_tpl_id',
            'type' => 'index',
            'fields' => [
                'dri_subworkflow_template_id',
            ],
        ],
        'idx_' . strtolower($object_name) . '_cj_journey_tpl_id' => [
            'name' => 'idx_' . strtolower($object_name) . '_cj_journey_tpl_id',
            'type' => 'index',
            'fields' => [
                'dri_workflow_template_id',
            ],
        ],
        'idx_' . strtolower($object_name) . '_cj_activity_tpl_id' => [
            'name' => 'idx_' . strtolower($object_name) . '_cj_activity_tpl_id',
            'type' => 'index',
            'fields' => [
                'dri_workflow_task_template_id',
            ],
        ],
        'idx_' . strtolower($object_name) . '_cj_parent_activity' => [
            'name' => 'idx_' . strtolower($object_name) . '_cj_parent_activity',
            'type' => 'index',
            'fields' => [
                'deleted',
                'cj_parent_activity_id',
                'cj_parent_activity_type',
            ],
        ],
    ],
];

// Fields to be added in Tasks module only
if ($module == 'Tasks') {
    $vardefs['fields']['customer_journey_type'] = [
        'name' => 'customer_journey_type',
        'vname' => 'LBL_CUSTOMER_JOURNEY_TYPE',
        'required' => false,
        'reportable' => true,
        'audited' => false,
        'importable' => 'true',
        'massupdate' => false,
        'options' => 'dri_workflow_task_templates_type_list',
        'type' => 'enum',
        'dependency' => 'not(equal($dri_subworkflow_id, ""))',
        'no_default' => true,
        'processes' => false,
    ];
    $vardefs['fields']['cj_activity_start_date'] = [
        'name' => 'cj_activity_start_date',
        'vname' => 'LBL_CJ_ACTIVITY_START_DATE',
        'required' => false,
        'readonly' => true,
        'reportable' => true,
        'audited' => false,
        'importable' => false,
        'massupdate' => false,
        'type' => 'datetime',
        'processes' => false,
    ];
    $vardefs['fields']['cj_activity_completion_date'] = [
        'name' => 'cj_activity_completion_date',
        'vname' => 'LBL_CJ_ACTIVITY_COMPLETION_DATE',
        'required' => false,
        'readonly' => true,
        'reportable' => true,
        'audited' => false,
        'importable' => false,
        'massupdate' => false,
        'type' => 'datetime',
        'processes' => false,
    ];
    $vardefs['fields']['cj_days_to_complete'] = [
        'name' => 'cj_days_to_complete',
        'vname' => 'LBL_CJ_DAYS_TO_COMPLETE',
        'required' => false,
        'readonly' => true,
        'reportable' => true,
        'audited' => false,
        'importable' => false,
        'massupdate' => false,
        'type' => 'varchar',
        'processes' => false,
    ];
}
