<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$vardefs = [
    'fields' => [
        'is_open_sunday' => [
            'name' => 'is_open_sunday',
            'vname' => 'LBL_SUNDAY_HOURS',
            'type' => 'bool',
            'default' => '0',
            'group' => 'sunday_hours',
            'comment' => 'Explicit marker for if this business center is open on Sunday',
            'duplicate_on_record_copy' => 'no',
            'audited' => true,
        ],
        'sunday_open_hour' => [
            'name' => 'sunday_open_hour',
            'vname' => 'LBL_SUNDAY_OPEN_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'sunday_hours',
            'comment' => 'The hour portion of the time this business center is open on Sunday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'sunday_open_minutes' => [
            'name' => 'sunday_open_minutes',
            'vname' => 'LBL_SUNDAY_OPEN_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'sunday_hours',
            'comment' => 'The minute portion of the time this business center is open on Sunday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'sunday_close_hour' => [
            'name' => 'sunday_close_hour',
            'vname' => 'LBL_SUNDAY_CLOSE_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'sunday_hours',
            'comment' => 'The hour portion of the time this business center is closed on Sunday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'sunday_close_minutes' => [
            'name' => 'sunday_close_minutes',
            'vname' => 'LBL_SUNDAY_CLOSE_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'sunday_hours',
            'comment' => 'The minute portion of the time this business center is closed on Sunday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'is_open_monday' => [
            'name' => 'is_open_monday',
            'vname' => 'LBL_MONDAY_HOURS',
            'type' => 'bool',
            'default' => '1',
            'group' => 'monday_hours',
            'comment' => 'Explicit marker for if this business center is open on Monday',
            'duplicate_on_record_copy' => 'no',
            'audited' => true,
        ],
        'monday_open_hour' => [
            'name' => 'monday_open_hour',
            'vname' => 'LBL_MONDAY_OPEN_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'monday_hours',
            'comment' => 'The hour portion of the time this business center is open on Monday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'monday_open_minutes' => [
            'name' => 'monday_open_minutes',
            'vname' => 'LBL_MONDAY_OPEN_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'monday_hours',
            'comment' => 'The minute portion of the time this business center is open on Monday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'monday_close_hour' => [
            'name' => 'monday_close_hour',
            'vname' => 'LBL_MONDAY_CLOSE_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'monday_hours',
            'comment' => 'The hour portion of the time this business center is closed on Monday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'monday_close_minutes' => [
            'name' => 'monday_close_minutes',
            'vname' => 'LBL_MONDAY_CLOSE_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'monday_hours',
            'comment' => 'The minute portion of the time this business center is closed on Monday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'is_open_tuesday' => [
            'name' => 'is_open_tuesday',
            'vname' => 'LBL_TUESDAY_HOURS',
            'type' => 'bool',
            'default' => '1',
            'group' => 'tuesday_hours',
            'comment' => 'Explicit marker for if this business center is open on Tuesday',
            'duplicate_on_record_copy' => 'no',
            'audited' => true,
        ],
        'tuesday_open_hour' => [
            'name' => 'tuesday_open_hour',
            'vname' => 'LBL_TUESDAY_OPEN_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'tuesday_hours',
            'comment' => 'The hour portion of the time this business center is open on Tuesday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'tuesday_open_minutes' => [
            'name' => 'tuesday_open_minutes',
            'vname' => 'LBL_TUESDAY_OPEN_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'tuesday_hours',
            'comment' => 'The minute portion of the time this business center is open on Tuesday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'tuesday_close_hour' => [
            'name' => 'tuesday_close_hour',
            'vname' => 'LBL_TUESDAY_CLOSE_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'tuesday_hours',
            'comment' => 'The hour portion of the time this business center is closed on Tuesday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'tuesday_close_minutes' => [
            'name' => 'tuesday_close_minutes',
            'vname' => 'LBL_TUESDAY_CLOSE_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'tuesday_hours',
            'comment' => 'The minute portion of the time this business center is closed on Tuesday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'is_open_wednesday' => [
            'name' => 'is_open_wednesday',
            'vname' => 'LBL_WEDNESDAY_HOURS',
            'type' => 'bool',
            'default' => '1',
            'group' => 'wednesday_hours',
            'comment' => 'Explicit marker for if this business center is open on Wednesday',
            'duplicate_on_record_copy' => 'no',
            'audited' => true,
        ],
        'wednesday_open_hour' => [
            'name' => 'wednesday_open_hour',
            'vname' => 'LBL_WEDNESDAY_OPEN_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'wednesday_hours',
            'comment' => 'The hour portion of the time this business center is open on Wednesday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'wednesday_open_minutes' => [
            'name' => 'wednesday_open_minutes',
            'vname' => 'LBL_WEDNESDAY_OPEN_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'wednesday_hours',
            'comment' => 'The minute portion of the time this business center is open on Wednesday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'wednesday_close_hour' => [
            'name' => 'wednesday_close_hour',
            'vname' => 'LBL_WEDNESDAY_CLOSE_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'wednesday_hours',
            'comment' => 'The hour portion of the time this business center is closed on Wednesday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'wednesday_close_minutes' => [
            'name' => 'wednesday_close_minutes',
            'vname' => 'LBL_WEDNESDAY_CLOSE_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'wednesday_hours',
            'comment' => 'The minute portion of the time this business center is closed on Wednesday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'is_open_thursday' => [
            'name' => 'is_open_thursday',
            'vname' => 'LBL_THURSDAY_HOURS',
            'type' => 'bool',
            'default' => '1',
            'group' => 'thursday_hours',
            'comment' => 'Explicit marker for if this business center is open on Thursday',
            'duplicate_on_record_copy' => 'no',
            'audited' => true,
        ],
        'thursday_open_hour' => [
            'name' => 'thursday_open_hour',
            'vname' => 'LBL_THURSDAY_OPEN_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'thursday_hours',
            'comment' => 'The hour portion of the time this business center is open on Thursday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'thursday_open_minutes' => [
            'name' => 'thursday_open_minutes',
            'vname' => 'LBL_THURSDAY_OPEN_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'thursday_hours',
            'comment' => 'The minute portion of the time this business center is open on Thursday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'thursday_close_hour' => [
            'name' => 'thursday_close_hour',
            'vname' => 'LBL_THURSDAY_CLOSE_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'thursday_hours',
            'comment' => 'The hour portion of the time this business center is closed on Thursday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'thursday_close_minutes' => [
            'name' => 'thursday_close_minutes',
            'vname' => 'LBL_THURSDAY_CLOSE_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'thursday_hours',
            'comment' => 'The minute portion of the time this business center is closed on Thursday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'is_open_friday' => [
            'name' => 'is_open_friday',
            'vname' => 'LBL_FRIDAY_HOURS',
            'type' => 'bool',
            'default' => '1',
            'group' => 'friday_hours',
            'comment' => 'Explicit marker for if this business center is open on Friday',
            'duplicate_on_record_copy' => 'no',
            'audited' => true,
        ],
        'friday_open_hour' => [
            'name' => 'friday_open_hour',
            'vname' => 'LBL_FRIDAY_OPEN_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'friday_hours',
            'comment' => 'The hour portion of the time this business center is open on Friday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'friday_open_minutes' => [
            'name' => 'friday_open_minutes',
            'vname' => 'LBL_FRIDAY_OPEN_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'friday_hours',
            'comment' => 'The minute portion of the time this business center is open on Friday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'friday_close_hour' => [
            'name' => 'friday_close_hour',
            'vname' => 'LBL_FRIDAY_CLOSE_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'friday_hours',
            'comment' => 'The hour portion of the time this business center is closed on Friday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'friday_close_minutes' => [
            'name' => 'friday_close_minutes',
            'vname' => 'LBL_FRIDAY_CLOSE_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'friday_hours',
            'comment' => 'The minute portion of the time this business center is closed on Friday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'is_open_saturday' => [
            'name' => 'is_open_saturday',
            'vname' => 'LBL_SATURDAY_HOURS',
            'type' => 'bool',
            'default' => '0',
            'group' => 'saturday_hours',
            'comment' => 'Explicit marker for if this business center is open on Saturday',
            'duplicate_on_record_copy' => 'no',
            'audited' => true,
        ],
        'saturday_open_hour' => [
            'name' => 'saturday_open_hour',
            'vname' => 'LBL_SATURDAY_OPEN_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'saturday_hours',
            'comment' => 'The hour portion of the time this business center is open on Saturday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'saturday_open_minutes' => [
            'name' => 'saturday_open_minutes',
            'vname' => 'LBL_SATURDAY_OPEN_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'saturday_hours',
            'comment' => 'The minute portion of the time this business center is open on Saturday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'saturday_close_hour' => [
            'name' => 'saturday_close_hour',
            'vname' => 'LBL_SATURDAY_CLOSE_HOUR',
            'type' => 'enum',
            'function' => 'getHoursDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'saturday_hours',
            'comment' => 'The hour portion of the time this business center is closed on Saturday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'saturday_close_minutes' => [
            'name' => 'saturday_close_minutes',
            'vname' => 'LBL_SATURDAY_CLOSE_MINUTES',
            'type' => 'enum',
            'function' => 'getMinutesDropdown',
            'function_bean' => 'BusinessCenters',
            'len' => 2,
            'group' => 'saturday_hours',
            'comment' => 'The minute portion of the time this business center is closed on Saturday',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
    ]
];
