<?php

use Sugarcrm\Sugarcrm\AccessControl\AdminWork;

if (!defined('sugarEntry')) {
    define('sugarEntry', true);
}
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//change directories to where this file is located.
chdir(__DIR__);
define('ENTRY_POINT_TYPE', 'api');
require_once 'include/entryPoint.php';

$sapi_type = php_sapi_name();
if (substr($sapi_type, 0, 3) != 'cli') {
    sugar_die('cron.php is CLI only.');
}

SugarMetric_Manager::getInstance()->setMetricClass('background')->setTransactionName('cron');

if (empty($current_language)) {
    $current_language = $sugar_config['default_language'];
}

$app_list_strings = return_app_list_strings_language($current_language);
$app_strings = return_application_language($current_language);

global $current_user;
$current_user = BeanFactory::newBean('Users');
$current_user->getSystemUser();

// allow admin to access everything
$adminWork = new AdminWork();
$adminWork->startAdminWork();

$GLOBALS['log']->debug('--------------------------------------------> at cron.php <--------------------------------------------');
$cron_driver = !empty($sugar_config['cron_class']) ? $sugar_config['cron_class'] : 'SugarCronJobs';
$GLOBALS['log']->debug("Using $cron_driver as CRON driver");

SugarAutoLoader::requireWithCustom("include/SugarQueue/$cron_driver.php");

$jobq = new $cron_driver();
$jobq->runCycle();

$exit_on_cleanup = true;

sugar_cleanup(false);
// some jobs have annoying habit of calling sugar_cleanup(), and it can be called only once
// but job results can be written to DB after job is finished, so we have to disconnect here again
// just in case we couldn't call cleanup
if (class_exists('DBManagerFactory')) {
    $db = DBManagerFactory::getInstance();
    $db->disconnect();
}

// If we have a session left over, destroy it
if (session_id()) {
    session_destroy();
}

if ($exit_on_cleanup) {
    exit($jobq->runOk() ? 0 : 1);
}
